<?php
/**
 * Internationalisation file for the Asirra module of the ConfirmEdit
 * extension.
 *
 * @file
 * @ingroup Extensions
 */

$messages = array();

/* English */
$messages['en'] = array(
	'asirra-desc' => 'Asirra module for ConfirmEdit',
	'asirra-edit' => 'To help protect against automated edit spam, please select just the cat photos in the box below:', 
	'asirra-addurl' => 'Your edit includes new external links. To help protect against automated spam, please select just the cat photos in the box below:',
	'asirra-badpass' => 'To help protect against automated password cracking, please select just the cat photos in the box below:',
	'asirra-createaccount' => 'To help protect against automated account creation, please select just the cat photos in the box below:',
	'asirra-createaccount-fail' => "Please correctly identify the cats.",
	'asirra-create' => 'To help protect against automated page creation, please select just the cat photos in the box below:', 
	'asirra-nojs' => '\'\'\'Please enable JavaScript and resubmit the page.\'\'\'',
	'asirra-failed' => 'Please identify all cat images',
);

/** Message documentation (Message documentation)
 * @author 2nd-player
 * @author Beta16
 */
$messages['qqq'] = array(
	'asirra-desc' => '{{desc}}',
	'asirra-edit' => 'See also
*{{msg-mw|Captcha-edit}}
*{{msg-mw|Questycaptcha-edit}}
*{{msg-mw|Fancycaptcha-edit}}
*{{msg-mw|Recaptcha-edit}}',
	'asirra-addurl' => 'See also
*{{msg-mw|Captcha-addurl}}
*{{msg-mw|Questycaptcha-addurl}}
*{{msg-mw|Fancycaptcha-addurl}}
*{{msg-mw|Recaptcha-addurl}}',
	'asirra-badpass' => 'See also
*{{msg-mw|Captcha-badlogin}}
*{{msg-mw|Questycaptcha-badlogin}}
*{{msg-mw|Fancycaptcha-badlogin}}
*{{msg-mw|Recaptcha-badpass}}',
	'asirra-createaccount' => 'See also
*{{msg-mw|Captcha-createaccount}}
*{{msg-mw|Questycaptcha-createaccount}}
*{{msg-mw|Fancycaptcha-createaccount}}
*{{msg-mw|Recaptcha-createaccount}}',
);

/** Belarusian (Taraškievica orthography) (беларуская (тарашкевіца)‎)
 * @author EugeneZelenko
 * @author Jim-by
 * @author Wizardist
 */
$messages['be-tarask'] = array(
	'asirra-desc' => 'Модуль Asirra для ConfirmEdit',
	'asirra-edit' => 'Для абароны супраць спаму, калі ласка, выберыце толькі фота з катом ў полі ніжэй:',
	'asirra-addurl' => 'Вашае рэдагаваньне ўтрымлівае новыя вонкавыя спасылкі. Для абароны супраць спаму, калі ласка, выберыце толькі фота з катом ў полі ніжэй:',
	'asirra-badpass' => 'Для абароны супраць аўтаматычнага падбору паролю, калі ласка, выберыце толькі фота з катом ў полі ніжэй:',
	'asirra-createaccount' => 'Для абароны супраць аўтаматычнага стварэньня рахункаў, калі ласка, выберыце толькі фота з катом ў полі ніжэй:',
	'asirra-createaccount-fail' => 'Калі ласка, слушна выберыце катоў.',
	'asirra-create' => 'Для абароны супраць аўтаматычнага стварэньня старонак, калі ласка, выберыце толькі фота з катом ў полі ніжэй:',
	'asirra-nojs' => "'''Калі ласка, дазвольце JavaScript і дашліце старонку зноў.'''",
	'asirra-failed' => 'Калі ласка, вызначце ўсе выявы з катамі',
);

/** German (Deutsch)
 * @author Kghbln
 */
$messages['de'] = array(
	'asirra-desc' => 'Ermöglicht die Nutzung des Anti-Spam-Moduls Asirra',
	'asirra-edit' => 'Zum Schutz vor automatisiertem Spam bitten wir dich, nur die Fotos mit Katzen im untenstehenden Feld auszuwählen:',
	'asirra-addurl' => 'Deine Bearbeitung enthält neue externe Links. Zum Schutz vor automatisiertem Spam bitten wir dich, nur die Fotos mit Katzen im untenstehenden Feld auszuwählen:',
	'asirra-badpass' => 'Zum Schutz gegen automatisiertes Knacken von Passwörtern bitten wir dich, nur die Fotos mit Katzen im untenstehenden Feld auszuwählen:',
	'asirra-createaccount' => 'Zum Schutz gegen automatisiertes Erstellen von Benutzerkonten bitten wir dich, nur die Fotos mit Katzen im untenstehenden Feld auszuwählen:',
	'asirra-createaccount-fail' => 'Bitte wähle nur die Fotos mit Katzen aus.',
	'asirra-create' => 'Zum Schutz gegen automatisiertes Erstellen von Seiten bitten wir dich, nur die Fotos mit Katzen im untenstehenden Feld auszuwählen:',
	'asirra-nojs' => "'''Bitte JavaScript aktivieren und die Seiten nochmals Speichern.'''",
	'asirra-failed' => 'Bitte wähle nur die Fotos mit Katzen aus.',
);

/** German (formal address) (Deutsch (Sie-Form)‎)
 * @author Kghbln
 */
$messages['de-formal'] = array(
	'asirra-addurl' => 'Ihre Bearbeitung enthält neue externe Links. Zum Schutz vor automatisiertem Spam bitten wir Sie, nur die Fotos mit Katzen im untenstehenden Feld auszuwählen:',
	'asirra-badpass' => 'Zum Schutz gegen automatisiertes Knacken von Passwörtern bitten wir Sie, nur die Fotos mit Katzen im untenstehenden Feld auszuwählen:',
	'asirra-createaccount' => 'Zum Schutz gegen automatisiertes Erstellen von Benutzerkonten bitten wir Sie, nur die Fotos mit Katzen im untenstehenden Feld auszuwählen:',
	'asirra-createaccount-fail' => 'Bitte wählen Sie nur die Fotos mit Katzen aus.',
	'asirra-create' => 'Zum Schutz gegen automatisiertes Erstellen von Seiten bitten wir Sie, nur die Fotos mit Katzen im untenstehenden Feld auszuwählen:',
	'asirra-failed' => 'Bitte wählen Sie nur die Fotos mit Katzen aus.',
);

/** Zazaki (Zazaki)
 * @author Erdemaslancan
 */
$messages['diq'] = array(
	'asirra-desc' => 'Qandê Asirra modulê RaştkerdenVurnen',
);

/** Spanish (español)
 * @author Armando-Martin
 */
$messages['es'] = array(
	'asirra-desc' => 'Módulo de Asirra para ConfirmEdit',
	'asirra-edit' => 'Para ayudar a protegernos contra el spam de edición automática, seleccione sólo las fotos de gatos en el cuadro siguiente:',
	'asirra-addurl' => 'Su edición incluye nuevos enlaces externos. Para ayudar a protegernos contra el spam automatizado, por favor, seleccione solo las fotos de gato en el cuadro siguiente:',
	'asirra-badpass' => 'Para ayudar a protegernos del robo automatizado de contraseñas, seleccione sólo las fotos de gatos en el cuadro siguiente:',
	'asirra-createaccount' => 'Para ayudar a protegernos contra la creación automatizada de cuentas, seleccione sólo las fotos de gato en el cuadro siguiente:',
	'asirra-createaccount-fail' => 'Identifique correctamente los gatos.',
	'asirra-create' => 'Para ayudar a protegernos contra la creación automática de páginas, seleccione sólo las fotos de gato en el cuadro siguiente:',
	'asirra-nojs' => "'''Por favor active JavaScript y vuelva a la página.'''",
	'asirra-failed' => 'Identifique todas las imágenes de gatos',
);

/** French (français)
 * @author Gomoko
 * @author Seb35
 */
$messages['fr'] = array(
	'asirra-desc' => 'Module Asirra pour ConfirmEdit',
	'asirra-edit' => 'Pour aider à nous protéger contre le spam d’édition automatique, veuillez sélectionner uniquement les photos de chats dans la boîte ci-dessous :',
	'asirra-addurl' => 'Votre édition contient des liens externes. Pour nous aider à nous protéger contre le spam automatique, veuillez sélectionner uniquement les photos de chats dans la boîte ci-dessous :',
	'asirra-badpass' => 'Pour nous aider à nous protéger des essais automatiques de cassage de mot de passe, veuillez sélectionner uniquement les photos de chats dans la boîte ci-dessous :',
	'asirra-createaccount' => 'Pour nous aider à nous protéger contre la création automatique de comptes, veuillez sélectionner uniquement les photos de chats dans la boîte ci-dessous :',
	'asirra-createaccount-fail' => 'Veuillez identifier correctement les chats.',
	'asirra-create' => 'Pour nous aider à nous protéger contre la création automatique de pages, veuillez sélectionner uniquement les photos de chats dans la boîte ci-dessous :',
	'asirra-nojs' => "'''Veuillez activer le JavaScript et re-soumettre la page.'''",
	'asirra-failed' => 'Veuillez identifier toutes les images de chat',
);

/** Galician (galego)
 * @author Toliño
 */
$messages['gl'] = array(
	'asirra-desc' => 'Módulo Asirra para ConfirmEdit',
	'asirra-edit' => 'Para axudarnos á protección contra o spam, seleccione só as fotos de gatos na caixa:',
	'asirra-addurl' => 'A súa edición inclúe novas ligazóns externas. Para axudar na protección contra o spam automático, seleccione só as fotos de gatos na caixa:',
	'asirra-badpass' => 'Para axudarnos á protección contra o roubo de contrasinais, seleccione só as fotos de gatos na caixa:',
	'asirra-createaccount' => 'Para axudarnos á protección contra a creación automática de contas, seleccione só as fotos de gatos na caixa:',
	'asirra-createaccount-fail' => 'Identifique correctamente os gatos.',
	'asirra-create' => 'Para axudarnos á protección contra a creación automática de páxinas, seleccione só as fotos de gatos na caixa:',
	'asirra-nojs' => "'''Active o JavaScript e volva enviar a páxina.'''",
	'asirra-failed' => 'Identifique todas as fotos de gatos',
);

/** Upper Sorbian (hornjoserbsce)
 * @author Michawiki
 */
$messages['hsb'] = array(
	'asirra-desc' => 'Modul Asirra za ConfirmEdit',
	'asirra-edit' => 'Za škit přećiwo awtomatizowanemu spamej, prošu wubjer jenož fota kóčkow w slědowacym polu:',
	'asirra-addurl' => 'Twoja změna wobsahuje nowe eksterne wotkazy. Za škit přećiwo awtomatizowanemu spamej, prošu wubjer jenož fota kóčkow w slědowacym polu:',
	'asirra-badpass' => 'Za škit přećiwo awtomatizowanemu złamanju hesłow, prošu wubjer jenož fota kóčkow w slědowacym polu:',
	'asirra-createaccount' => 'Za škit přećiwo awtomatiskemu wutworjenju konta, prošu wubjer jenož fota kóčkow w slědowacym polu:',
	'asirra-createaccount-fail' => 'Prošu identifikuj kóčki.',
	'asirra-create' => 'Za škit přećiwo awtomatiskemu wutworjenju strony, prošu wubjer jenož fota kóčkow w slědowacym polu:',
	'asirra-nojs' => "'''Prošu zmóžń JavaScript a składuj stronu hišće raz.'''",
	'asirra-failed' => 'Prošu identifikuj wšě wobrazy z kóčkami',
);

/** Interlingua (interlingua)
 * @author McDutchie
 */
$messages['ia'] = array(
	'asirra-desc' => 'Modulo de Asirra pro ConfirmEdit',
	'asirra-edit' => 'Pro adjutar a proteger nos contra le spam automatisate, per favor selige solmente le photos de cattos in le quadro sequente:',
	'asirra-addurl' => 'Iste modification include nove ligamines externe. Pro adjutar a proteger nos contra le spam automatisate, per favor selige solmente le photos de cattos in le quadro sequente:',
	'asirra-badpass' => 'Pro adjutar a proteger nos contra le furto automatisate de contrasignos, per favor selige solmente le photos de catto in le quadro sequente:',
	'asirra-createaccount' => 'Pro adjutar a proteger nos contra le creation automatisate de contos, per favor selige solmente le photos de cattos in le quadro sequente:',
	'asirra-createaccount-fail' => 'Per favor identifica correctemente le cattos.',
	'asirra-create' => 'Pro adjutar a proteger nos contra le creation automatisate de paginas, per favor selige solmente le photos de cattos in le quadro sequente:',
	'asirra-nojs' => "'''Per favor activa JavaScript e resubmitte le pagina.'''",
	'asirra-failed' => 'Per favor identifica tote le imagines de cattos',
);

/** Italian (italiano)
 * @author Beta16
 */
$messages['it'] = array(
	'asirra-desc' => 'Modulo ASIRRA per ConfirmEdit',
	'asirra-edit' => 'Per aiutarci a proteggerci dalle modifiche automatiche che aggiungono spam, seleziona solo le foto di gatti nel riquadro sottostante:',
	'asirra-addurl' => 'La tua modifica aggiunge qualche nuovo collegamento esterno. Per aiutarci a proteggerci dallo spam automatico, seleziona solo le foto di gatti nel riquadro sottostante:',
	'asirra-badpass' => 'Per aiutarci a proteggerci dalla forzatura automatica delle password, seleziona solo le foto di gatti nel riquadro sottostante:',
	'asirra-createaccount' => 'Per aiutarci a proteggerci dalla creazione automatica di nuovi accessi, seleziona solo le foto di gatti nel riquadro sottostante:',
	'asirra-createaccount-fail' => 'Identifica correttamente i gatti.',
	'asirra-create' => 'Per aiutarci a proteggerci dalla creazione automatica di pagine, seleziona solo le foto di gatti nel riquadro sottostante:',
	'asirra-nojs' => "'''Attiva JavaScript ed invia di nuovo la pagina.'''",
	'asirra-failed' => 'Identifica tutte le immagini di gatti',
);

/** Japanese (日本語)
 * @author 2nd-player
 * @author Shirayuki
 */
$messages['ja'] = array(
	'asirra-desc' => 'ConfirmEdit 用 Asirra モジュール',
	'asirra-edit' => '自動編集のスパム攻撃を防ぐため、猫が写っている画像を以下から選択してください:',
	'asirra-addurl' => 'あなたは新しい外部リンクを追加しようとしています。自動でのスパム攻撃を防ぐため、猫が写っている画像を以下から選択してください:',
	'asirra-badpass' => '自動でのパスワードクラック攻撃を防ぐため、猫が写っている画像を以下から選択してください:',
	'asirra-createaccount' => 'アカウントの自動登録を防ぐため、猫が写っている画像を以下から選択してください:',
	'asirra-createaccount-fail' => '猫を正しく選択してください。',
	'asirra-create' => 'ページの自動作成を防ぐため、猫が写っている画像を以下から選択してください:',
	'asirra-nojs' => "'''JavaScript を有効にしてページを再読込してください。'''",
	'asirra-failed' => '猫が写っている画像をすべて選択してください',
);

/** Colognian (Ripoarisch)
 * @author Purodha
 */
$messages['ksh'] = array(
	'asirra-desc' => 'Dä Zohsaz <i lang="en">Asirra</i> för et Zohsazprojramm <i lang="en">ConfirmEdit</i>.',
	'asirra-edit' => 'Heh dat Wiki well sesch jääje <i lang="en">SPAM</i> schöze. Dröm moß mer beim Ändere noch en Prööfong aflääje, dat mer ene Minsch un kei Projramm es. Söhk bloß de Katzebelder em Kaßte us:',
	'asirra-addurl' => 'Heh dat Wiki well sesch jääje <i lang="en">SPAM</i> schöze. Dröm moß mer, wam_mer lengks noh ußerhallef enfööje well, noch en Prööfong aflääje, dat mer ene Minsch un kei Projramm es. Söhk bloß de Katzebelder em Kaßte us:',
	'asirra-badpass' => 'Heh dat Wiki well sesch jääje et automattesche Paßwoot_Knacke schöze. Dröm moß mer heh nor_en Prööfong aflääje, dat mer ene Minsch un kei Projramm es. Söhk bloß de Katzebelder em Kaßte us:',
	'asirra-createaccount' => 'Heh dat Wiki well sesch jääje automattesch aanjelaate „Metmaacher“ schöze. Dröm moß mer heh nor_en Prööfong aflääje, dat mer ene Minsch un kei Projramm es. Söhk bloß de Katzebelder em Kaßte us:',
	'asirra-createaccount-fail' => 'Bes esu jood un don de Kazebelder ußwähle.',
	'asirra-create' => 'Heh dat Wiki well sesch jääje automattesch neu aanjelaate Sigge schöze. Dröm moß mer heh nor_en Prööfong aflääje, dat mer ene Minsch un kei Projramm es. Söhk bloß de Katzebelder em Kaßte us:',
	'asirra-nojs' => "'''Bes esu jood un donn JavaSkrep en Dingem Brauser aanschallde un scheck heh di Sigg norr_ens af.'''",
	'asirra-failed' => 'Bes esu jood un don all de Kazebelder ußwähle.',
);

/** Luxembourgish (Lëtzebuergesch)
 * @author Robby
 */
$messages['lb'] = array(
	'asirra-desc' => 'Asirra-Modul fir ConfirmEdit',
	'asirra-addurl' => "An Ärer Ännerung sinn nei extern Linken. Fir ze hëllefe géint automatiséierte Spam virzegoen, sicht w.e.g. d'Kategorie vun de Fotoen an der Këscht ënnendrënner eraus:",
	'asirra-createaccount-fail' => "Identifizéiert d'Kaze w.e.g. richteg.",
	'asirra-nojs' => "'''Aktivéiert w.e.g. JavaScript a schéckt d'Säit nachemol.'''",
	'asirra-failed' => 'Identifizéiert w.e.g. all Biller wou Kazen drop sinn',
);

/** Macedonian (македонски)
 * @author Bjankuloski06
 */
$messages['mk'] = array(
	'asirra-desc' => 'Asirra-модул за ПотврдиУредување',
	'asirra-edit' => 'Како заштитна мерка против автоматизиран спам, изберете ги само сликите со мачка прикажани во полето:',
	'asirra-addurl' => 'Во вашите измени има нови надворешни врски. Како заштитна мерка против автоматизиран спам, изберете ги само сликите со мачка прикажани во полето:',
	'asirra-badpass' => 'Како заштитна мерка против автоматизирано провалување на лозинки, изберете ги само сликите со мачка прикажани во полето:',
	'asirra-createaccount' => 'Како заштитна мерка против автоматизирано создавање на сметки, изберете ги само сликите со мачка прикажани во полето:',
	'asirra-createaccount-fail' => 'Посочете кои од следниве се мачки.',
	'asirra-create' => 'Како заштитна мерка против автоматизирано создавање на страници, изберете ги само сликите со мачка прикажани во полето:',
	'asirra-nojs' => "'''Овозможете JavaScript и поднесете ја страницата повторно.'''",
	'asirra-failed' => 'Изберете ги сликите што имаат мачка',
);

/** Maltese (Malti)
 * @author Chrisportelli
 */
$messages['mt'] = array(
	'asirra-desc' => 'Modulu ASIRRA għal ConfirmEdit',
	'asirra-edit' => "Sabiex tgħinna nipproteġu kontra l-modifiki li jżidu spam, jekk jogħġbok agħżel ir-ritratti tal-qtates fil-kaxxa t'hawn taħt:",
	'asirra-addurl' => "Il-modifika tiegħek tinkludi ħoloq esterni ġodda. Sabiex tipproteġi kontra spam awtomatiku, jekk jogħġbok agħżel ir-ritratti tal-qtates fil-kaxxa t'hawn taħt:",
	'asirra-badpass' => "Sabiex tgħinna nipproteġu kontra l-infurzar awtomatiku tal-passwords, jekk jogħġbok agħżel ir-ritratti tal-qtates fil-kaxxa t'hawn taħt:",
	'asirra-createaccount' => "Sabiex tgħinna nipproteġu kontra l-ħolqien awtomatiku ta' kontijiet ġodda, jekk jogħġbok agħżel ir-ritratti tal-qtates fil-kaxxa t'hawn taħt:",
	'asirra-createaccount-fail' => 'Sib il-qtates.',
	'asirra-create' => "Sabiex tgħinna nipproteġu kontra l-ħolqien awtomatiku ta' paġni, jekk jogħġbok agħżel ir-ritratti tal-qtates fil-kaxxa t'hawn taħt:",
	'asirra-nojs' => "'''Jekk jogħġbok attiva l-JavaScript u erġa' ibgħat din il-paġna.'''",
	'asirra-failed' => 'Sib l-istampi kollha tal-qtates',
);

/** Norwegian Bokmål (norsk (bokmål)‎)
 * @author Event
 */
$messages['nb'] = array(
	'asirra-desc' => 'Assirra-modulen for ConfirmEdit',
	'asirra-edit' => 'Som beskyttelse mot automatisk redigert spam, vennligst velg kun kattebildene i boksen under:',
	'asirra-addurl' => 'Din redigering inneholder nye eksterne lenker. Som beskyttelse mot automatisk redigert spam, vennligst velg kun kattebildene i boksen under:',
	'asirra-badpass' => 'Som beskyttelse mot automatisk passordknekking, vennligst velg kun kattebildene i boksen under:',
	'asirra-createaccount' => 'Som beskyttelse mot automatisk opprettelse av brukerkonto, vennligst velg kun kattebildene i boksen under:',
	'asirra-createaccount-fail' => 'Vennligst angi hva som er katter.',
	'asirra-create' => 'Som beskyttelse mot automatisk opprettelse av sider, vennligst velg kun kattebildene i boksen under:',
	'asirra-nojs' => "'''Vennligst åpne for JavaScript og lagre siden en gang til.'''",
);

/** Dutch (Nederlands)
 * @author SPQRobin
 * @author Siebrand
 */
$messages['nl'] = array(
	'asirra-desc' => 'Asirra-module voor ConfirmEdit',
	'asirra-edit' => 'Kies ter bescherming tegen geautomatiseerde spam de afbeeldingen met een poes in het onderstaande venster:',
	'asirra-addurl' => "Uw bewerking bevat nieuwe externe verwijzingen. Om te helpen beschermen tegen geautomatiseerde spam, selecteer de foto's van katten in het vak hieronder:",
	'asirra-badpass' => 'Kies ter bescherming tegen het automatisch kraken van wachtwoorden de afbeeldingen met een poes in het onderstaande venster:',
	'asirra-createaccount' => 'Kies om het automatisch aanmaken van gebruikers tegen te gaan de afbeeldingen met een poes in het onderstaande venster:',
	'asirra-createaccount-fail' => 'Identificeer de katten juist.',
	'asirra-create' => "Kies om het automatisch aanmaken van pagina's tegen te gaan de afbeeldingen met een poes in het onderstaande venster:",
	'asirra-nojs' => "'''Schakel JavaScript in en probeer de pagina opnieuw op te slaan.'''",
	'asirra-failed' => 'Identificeer alle afbeeldingen van katten.',
);

/** Polish (polski)
 * @author BeginaFelicysym
 */
$messages['pl'] = array(
	'asirra-desc' => 'Moduł Asirra dla ConfirmEdit',
	'asirra-edit' => 'Aby uchronić się przed automatami wprowadzającymi spam, proszę wybrać tylko zdjęcia kotów w poniższym polu:',
	'asirra-addurl' => 'Wprowadzony przez ciebie tekst zawiera linki zewnętrzne. Aby uchronić nas przed automatycznym spamem, proszę wskazać tylko zdjęcia kotów w poniższym polu:',
	'asirra-badpass' => 'Aby uchronić się przed zautomatyzowanym łamaniem haseł, proszę wybrać tylko zdjęcia kotów w poniższym polu:',
	'asirra-createaccount' => 'Aby uchronić się przed automatycznym tworzeniem kont, proszę wybrać tylko zdjęcia kotów w poniższym polu:',
	'asirra-createaccount-fail' => 'Prosimy prawidłowo zidentyfikować koty.',
	'asirra-create' => 'Aby uchronić się przed automatycznym tworzeniem stron, proszę wybrać tylko zdjęcia kotów w poniższym polu:',
	'asirra-nojs' => "'''Prosimy włączyć obsługę języka JavaScript i ponowne przesłanie strony.'''",
	'asirra-failed' => 'Prosimy wskazać wszystkie obrazy kotów',
);

/** Piedmontese (Piemontèis)
 * @author Borichèt
 * @author Dragonòt
 */
$messages['pms'] = array(
	'asirra-desc' => 'Mòdul Asirra për ConfirmEdit',
	'asirra-edit' => "Për giuté a protege contra la rumenta dle modìfiche automàtiche, për piasì ch'a selession-a mach le fòto ëd gat ant ël quàder sì-sota:",
	'asirra-addurl' => "Soa modìfica a conten dle liure esterne neuve. Për giuté a protege contra la rumenta dle modìfiche automàtiche, për piasì ch'a selession-a mach le fòto ëd gat ant ël quàder sì-sota:",
	'asirra-badpass' => "Për giuté a protege contra la forsadura automatisà ëd le ciav, për piasì ch'a selession-a mach la fòto dël gat ant ël quàder sì-sota:",
	'asirra-createaccount' => "Për giuté a protege contra la creassion automatisà ëd cont, për piasì ch'a selession-a mach la fòto dël gat ant ël quàder sì-sota:",
	'asirra-createaccount-fail' => 'Për piasì identifica coretament ij gat.',
	'asirra-create' => "Për giuté a protege contra la creassion automatisà ëd pàgine, për piasì ch'a selession-a mach le fòto ëd gat ant ël quàder sì-sota:",
	'asirra-nojs' => "'''Për piasì, ch'a abìlita JavaScript e ch'a spedissa torna la pàgina.'''",
	'asirra-failed' => 'Për piasì identìfica tute le figure ëd gat',
);

/** Portuguese (português)
 * @author Hamilton Abreu
 */
$messages['pt'] = array(
	'asirra-desc' => 'Módulo Asirra para o ConfirmEdit',
	'asirra-edit' => "Como prevenção contra sistemas automatizados de inserção de ''spam'', seleccione só as fotografias de gatos na caixa abaixo:",
	'asirra-addurl' => "A sua edição contém links externos novos. Como prevenção contra sistemas automatizados de inserção de ''spam'', seleccione só as fotografias de gatos na caixa abaixo:",
	'asirra-badpass' => 'Como prevenção com sistemas automatizados de descoberta de palavras-chave, seleccione só as fotografias de gatos na caixa abaixo:',
	'asirra-createaccount' => 'Como prevenção contra sistemas automatizados de criação de contas, seleccione só as fotografias de gatos na caixa abaixo:',
	'asirra-createaccount-fail' => 'Identifique correctamente os gatos, por favor.',
	'asirra-create' => 'Como prevenção contra sistemas automatizados de criação de páginas, seleccione só as fotografias de gatos na caixa abaixo:',
	'asirra-nojs' => "'''Possibilite o uso de JavaScript e reenvie a página, por favor.'''",
);

/** Russian (русский)
 * @author DCamer
 */
$messages['ru'] = array(
	'asirra-desc' => 'Модуль Asirra для ConfirmEdit',
	'asirra-edit' => 'В целях защиты от автоматического спама в правках, пожалуйста, выберите фотографии кота, которые вы видите ниже:',
	'asirra-addurl' => 'Ваша правка содержит новые внешние ссылки. В целях защиты от автоматического спама, пожалуйста, выберите фотографии кота, которые вы видите ниже:',
	'asirra-badpass' => 'В целях защиты от автоматического подбора пароля, пожалуйста, выберите фотографии кота, которые вы видите ниже:',
	'asirra-createaccount' => 'В целях защиты от автоматического создания учётных записей, пожалуйста, выберите фотографии кота, которые вы видите ниже:',
	'asirra-createaccount-fail' => 'Пожалуйста правильно идентифицируйте котов.',
	'asirra-create' => 'В целях защиты от автоматического создания страниц, пожалуйста, выберите фотографии кота, которые вы видите ниже:',
	'asirra-nojs' => "'''Пожалуйста, включите JavaScript и обновите страницу.'''",
	'asirra-failed' => 'Пожалуйста, идентифицируйте все фотографии кота',
);

/** Tagalog (Tagalog)
 * @author AnakngAraw
 */
$messages['tl'] = array(
	'asirra-desc' => 'Modyul ng Asirra para sa ConfirmEdit',
	'asirra-edit' => 'Upang makatulong sa pagprutekta laban sa kusang basurang pamamatnugot, paki piliin iyong mga litrato lamang ng pusa na nasa loob ng kahong nasa ibaba:',
	'asirra-addurl' => 'Ang pagbabago mo ay nagsasama ng bagong panlabas na mga kawing.  Upang makatulong sa pagprutekta laban sa kusang paglusob ng basurang-liham, paki piliin  iyong mga litrato lamang ng pusa na nasa loob ng kahong nasa ibaba:',
	'asirra-badpass' => 'Upang makatulong sa pagprutekta laban sa kusang pag-alam ng hudyat, paki piliin lamang iyong mga litrato ng pusa na nasa loob ng kahong nasa ibaba:',
	'asirra-createaccount' => 'Upang makatulong sa pagprutekta laban sa kusang paglikha ng akawnt, paki piliin lamang iyong mga litrato ng pusa na nasa loob ng kahong nasa ibaba:',
	'asirra-createaccount-fail' => 'Paki kilalanin ng tama ang mga pusa.',
	'asirra-create' => 'Upang makatulong sa pagprutekta laban sa kusang paglikha ng pahina, paki piliin lamang iyong mga litrato ng pusa na nasa loob ng kahong nasa ibaba:',
	'asirra-nojs' => "'''Paki paganahin ang JavaScript at muling ipasa ang pahina.'''",
	'asirra-failed' => 'Paki kilalanin ang lahat ng mga imahe ng pusa',
);

/** Walloon (walon)
 * @author Srtxg
 */
$messages['wa'] = array(
	'asirra-desc' => "Module Asirra pol passete d' acertinaedje des candjmints (ConfirmEdit)",
	'asirra-edit' => "Po s' mete a houte des des robots di spam, nos  vs dimandans d' acertiner ki vos estoz bén ene djin, po çoula tchoezixhoz seulmint les imådjes avou des tchets e l' boesse chal pa dzo:",
	'asirra-addurl' => "Dins vos candjmints i gn a des dfoûtrinnès hårdêyes (URL).
Po s' mete a houte des des robots di spam, nos  vs dimandans d' acertiner ki vos estoz bén ene djin, po çoula tchoezixhoz seulmint les imådjes avou des tchets e l' boesse chal pa dzo:",
	'asirra-badpass' => "Po s' mete a houte des des robots ki sayèt d' adviner les screts, nos  vs dimandans d' acertiner ki vos estoz bén ene djin, po çoula tchoezixhoz seulmint les imådjes avou des tchets e l' boesse chal pa dzo:",
	'asirra-createaccount' => "Po s' mete a houte des des robots k' ahivèt des contes otomaticmint, nos  vs dimandans d' acertiner ki vos estoz bén ene djin, po çoula tchoezixhoz seulmint les imådjes avou des tchets e l' boesse chal pa dzo:",
	'asirra-createaccount-fail' => 'Tchoezixhoz comifåt les tchets (les biesses ki gnawèt).',
	'asirra-create' => "Po s' mete a houte des des robots k' ahivèt des pådjes otomaticmint, nos  vs dimandans d' acertiner ki vos estoz bén ene djin, po çoula tchoezixhoz seulmint les imådjes avou des tchets e l' boesse chal pa dzo:",
	'asirra-nojs' => "'''Metoz s' i vs plait en alaedje li JavaScrit et s' revoyî l' pådje.'''",
	'asirra-failed' => 'Idintifyî totes les imådjes avou des tchets',
);

/** Simplified Chinese (中文（简体）‎)
 * @author Hzy980512
 */
$messages['zh-hans'] = array(
	'asirra-desc' => 'ConfirmEdit的Asirra模块',
	'asirra-edit' => '为了防止垃圾编辑攻击，请在下面的方框中选出猫的图片：',
	'asirra-addurl' => '您的编辑包含新的外部链接。为了帮助防止自动垃圾邮件，请在下面的方框中选出猫的图片：',
	'asirra-badpass' => '为防止自动程序破解密码，请在下面的方框中选出猫的图片：',
	'asirra-createaccount' => '为了防止自动程序创建帐户，请在下面的方框中选出猫的图片：',
	'asirra-createaccount-fail' => '请正确辨认出猫的图片。',
	'asirra-create' => '为了防止自动程序创建页面，请在下面的方框中选出猫的图片：',
	'asirra-nojs' => "'''请启动JavaScript后再提交页面。'''",
	'asirra-failed' => '请选出所有猫的图片',
);

/** Traditional Chinese (中文（繁體）‎) */
$messages['zh-hant'] = array(
	'asirra-desc' => 'ConfirmEdit的Asirra模塊',
	'asirra-edit' => '為了防止垃圾編輯攻擊，請在下面的方框中選出貓的圖片：',
	'asirra-addurl' => '您的編輯包含新的外部鏈接。為了幫助防止自動垃圾郵件，請在下面的方框中選出貓的圖片：',
	'asirra-badpass' => '為防止自動程序破解密碼，請在下面的方框中選出貓的圖片：',
	'asirra-createaccount' => '為了防止自動程序創建帳戶，請在下面的方框中選出貓的圖片：',
	'asirra-createaccount-fail' => '請正確辨認出貓的圖片。',
	'asirra-create' => '為了防止自動程序創建頁面，請在下面的方框中選出貓的圖片：',
	'asirra-nojs' => "'''請啟動JavaScript後再提交頁面。'''",
	'asirra-failed' => '請選出所有貓的圖片',
);

