<?php
/**
 * Aliases for MobileFrontend extension
 *
 * @file
 * @ingroup Extensions
 */

$specialPageAliases = array();

/** English (English) */
$specialPageAliases['en'] = array(
	'MobileFeedback' => array( 'MobileFeedback' ),
	'MobileOptions' => array( 'MobileOptions' ),
	'DonateImage' => array( 'DonateImage' ),
	'MobileDiff' => array( 'MobileDiff' ),
	'MobileMenu' => array( 'MobileMenu' ),
	'Nearby' => array( 'Nearby' ),
);

/** Arabic (العربية) */
$specialPageAliases['ar'] = array(
	'MobileFeedback' => array( 'تعليقات_المحمول' ),
	'MobileOptions' => array( 'خيارات_المحمول' ),
);

/** German (Deutsch) */
$specialPageAliases['de'] = array(
	'MobileFeedback' => array( 'Mobile_Rückmeldung' ),
	'MobileOptions' => array( 'Mobile_Optionen' ),
	'DonateImage' => array( 'Bild_spenden' ),
	'MobileDiff' => array( 'Mobiler_Unterschied' ),
	'MobileMenu' => array( 'Mobiles_Menü' ),
	'Nearby' => array( 'In_der_Nähe' ),
);

/** Estonian (eesti) */
$specialPageAliases['et'] = array(
	'MobileFeedback' => array( 'Mobiili_tagasiside' ),
	'MobileOptions' => array( 'Mobiili_suvandid' ),
);

/** Hebrew (עברית) */
$specialPageAliases['he'] = array(
	'Nearby' => array( 'קרוב' ),
);

/** Hindi (हिन्दी) */
$specialPageAliases['hi'] = array(
	'MobileFeedback' => array( 'मोबाइल_प्रतिक्रिया' ),
	'MobileOptions' => array( 'मोबाइल_विकल्प' ),
);

/** Italian (italiano) */
$specialPageAliases['it'] = array(
	'MobileFeedback' => array( 'FeedbackMobile' ),
	'MobileOptions' => array( 'OpzioniMobile' ),
);

/** Korean (한국어) */
$specialPageAliases['ko'] = array(
	'MobileFeedback' => array( '모바일피드백' ),
	'MobileOptions' => array( '모바일설정' ),
	'DonateImage' => array( '그림기부' ),
	'MobileDiff' => array( '모바일차이점' ),
	'MobileMenu' => array( '모바일메뉴' ),
	'Nearby' => array( '근처' ),
);

/** Luxembourgish (Lëtzebuergesch) */
$specialPageAliases['lb'] = array(
	'MobileOptions' => array( 'Mobil_Optiounen' ),
);

/** Macedonian (македонски) */
$specialPageAliases['mk'] = array(
	'MobileFeedback' => array( 'МислењеМобилен' ),
	'MobileOptions' => array( 'МобилниПоставки' ),
	'DonateImage' => array( 'ПодариСлика' ),
	'MobileDiff' => array( 'МобилнаРазлика' ),
	'MobileMenu' => array( 'МобилноМени' ),
);

/** Malayalam (മലയാളം) */
$specialPageAliases['ml'] = array(
	'MobileFeedback' => array( 'മൊബൈൽപ്രതികരണം' ),
	'MobileOptions' => array( 'മൊബൈൽഐച്ഛികങ്ങൾ' ),
);

/** Dutch (Nederlands) */
$specialPageAliases['nl'] = array(
	'MobileFeedback' => array( 'MobieleTerugkoppeling' ),
	'MobileOptions' => array( 'MobieleVoorkeuren' ),
	'DonateImage' => array( 'AfbeeldingDoneren' ),
	'MobileDiff' => array( 'MobielVerschillen' ),
	'MobileMenu' => array( 'MobielMenu' ),
	'Nearby' => array( 'InDeBuurt' ),
);

/** Polish (polski) */
$specialPageAliases['pl'] = array(
	'DonateImage' => array( 'Prześlij_zdjęcie' ),
	'Nearby' => array( 'W_pobliżu' ),
);

/** Sicilian (sicilianu) */
$specialPageAliases['scn'] = array(
	'MobileFeedback' => array( 'FeedbackMobile' ),
	'MobileOptions' => array( 'OpzioniMobile' ),
);

/** Vietnamese (Tiếng Việt) */
$specialPageAliases['vi'] = array(
	'MobileFeedback' => array( 'Phản_hồi_di_động' ),
	'MobileOptions' => array( 'Tùy_chọn_di_động' ),
	'DonateImage' => array( 'Đóng_góp_hình_ảnh', 'Đóng_góp_hình', 'Đóng_góp_ảnh' ),
	'MobileDiff' => array( 'So_sánh_di_động' ),
	'MobileMenu' => array( 'Trình_đơn_di_động' ),
	'Nearby' => array( 'Kề_bên' ),
);

/** Simplified Chinese (中文（简体）‎) */
$specialPageAliases['zh-hans'] = array(
	'MobileFeedback' => array( '移动版反馈' ),
	'MobileOptions' => array( '移动版选项' ),
	'DonateImage' => array( '捐赠图像' ),
	'MobileDiff' => array( '移动版差异' ),
	'MobileMenu' => array( '移动版菜单' ),
	'Nearby' => array( '附近' ),
);

/** Traditional Chinese (中文（繁體）‎) */
$specialPageAliases['zh-hant'] = array(
	'MobileFeedback' => array( '手機版意見' ),
	'MobileOptions' => array( '手機版選項' ),
	'DonateImage' => array( '捐贈圖像' ),
	'MobileDiff' => array( '手機版差異' ),
	'MobileMenu' => array( '手機版選單' ),
	'Nearby' => array( '附近' ),
);