<?php
/**
 * Internationalisation file for the extension MobileFrontend
 *
 * @file
 * @ingroup Extensions
 * @author Patrick Reilly
 * @copyright © 2011 Patrick Reilly
 * @licence GNU General Public Licence 2.0 or later
 */

$messages = array();

$messages['en'] = array (
	'mobile-frontend-desc' => 'Mobile Frontend',
	'mobile.css' => '/* CSS placed here will affect users of the mobile site */', # only translate this message to other languages if you have to change it
	'mobile.js' => '/* Any JavaScript here will be loaded for users using the mobile site */', # only translate this message to other languages if you have to change it
	'mobile-frontend-search-submit' => 'Go',
	'mobile-frontend-home-button' => 'Home',
	'mobile-frontend-logged-out' => 'Not logged in',
	'mobile-frontend-logged-in-homepage-notification' => 'Welcome, $1!',
	'mobile-frontend-logged-in-toast-notification' => 'Logged in as $1.',

	/** log-in page **/
	'mobile-frontend-sign-up-heading' => 'Sign up',
	'mobile-frontend-sign-in-heading' => 'Sign in',
	'mobile-frontend-sign-in-why' => 'If you have a {{SITENAME}} account, you may sign in below.',
	'mobile-frontend-sign-in-error-heading' => 'Whoops',
	/** end log-in page**/

	'mobile-frontend-settings-description' => 'Customize your experience on your mobile device with these mobile specific site settings.',
	'mobile-frontend-settings-beta' => 'Beta',
	'mobile-frontend-settings-alpha' => '[//en.wikipedia.org/wiki/Here_be_dragons Here be dragons] mode',
	'mobile-frontend-settings-alpha-description' => 'Enter dangerous and unexplored mobile territory. Get even more experimental features but with more danger of bugs.',
	'mobile-frontend-save-settings' => 'Save settings',
	'mobile-frontend-random-button' => 'Random',

	/* related to random widget */
	'mobile-frontend-ajax-random-heading' => 'Locating knowledge...',
	'mobile-frontend-ajax-random-quote' => 'Intellectual growth should commence at birth and cease only at death',
	'mobile-frontend-ajax-random-quote-author' => 'Albert Einstein',
	'mobile-frontend-ajax-random-question' => 'Read this page?',
	'mobile-frontend-ajax-random-yes' => 'Yes',
	'mobile-frontend-ajax-random-retry' => 'Try again',
	'mobile-frontend-ajax-random-suggestions' => 'Other suggestions:',

	'mobile-frontend-back-to-top-of-section' => 'Jump back a section',
	'mobile-frontend-close-section' => 'Close this section',
	'mobile-frontend-show-button' => 'Show',
	'mobile-frontend-hide-button' => 'Hide',
	'mobile-frontend-empty-homepage-text' => 'This homepage needs to be configured. [//meta.wikimedia.org/wiki/Mobile_Projects/Mobile_Gateway#Mobile_homepage Instructions on how to get this site mobile enabled]',
	'mobile-frontend-regular-site' => 'Desktop view',
	'mobile-frontend-wml-continue' => 'Continue...',
	'mobile-frontend-wml-back' => 'Back...',
	'mobile-frontend-view' => 'Mobile view',
	'mobile-frontend-view-desktop' => 'Desktop',
	'mobile-frontend-view-mobile' => 'Mobile',
	'mobile-frontend-opt-in-explain' => 'By joining the beta, you will get access to experimental features, at the risk of encountering bugs and issues.',
	'mobile-frontend-images-status' => 'Images',
	'mobile-frontend-disable-images' => 'Disable images on mobile site',
	'mobile-frontend-enable-images' => 'Enable images on mobile site',
	'mobile-frontend-missing-image' => 'Image',
	'mobile-frontend-off' => 'OFF',
	'mobile-frontend-on' => 'ON',
	'mobile-frontend-footer-contributors-text' => 'Page by [$1 contributors] like you',
	'mobile-frontend-featured-article' => 'Today\'s Featured Article',
	'mobile-frontend-news-items' => 'In The News',
	'mobile-frontend-leave-feedback-notice' => 'Your feedback helps us to improve your mobile site experience. It will be posted publicly (along with your user name, browser version and operating system) to the page &quot;$1&quot;. Please try to choose an informative subject line, e.g. "Formatting issues with wide tables". Your feedback is subject to our terms of use.',
	'mobile-frontend-leave-feedback-warning' => 'Unless you agree to have your information made public, please do not include personal information in your comments.',
	'mobile-frontend-leave-feedback-subject' => 'Subject:',
	'mobile-frontend-leave-feedback-message' => 'Message:',
	'mobile-frontend-leave-feedback-submit' => 'Submit feedback',
	'mobile-frontend-leave-feedback-link-text' => 'MobileFrontend Extension feedback',
	'mobile-frontend-leave-feedback' => 'Mobile site feedback',
	'mobile-frontend-leave-feedback-title' => 'Mobile site feedback',
	'mobile-frontend-leave-feedback-technical-problem-section-header' => 'Technical problem',
	'mobile-frontend-leave-feedback-general-section-header' => 'General',
	'mobile-frontend-leave-feedback-article-feedback-section-header' => 'Article feedback',
	'mobile-frontend-leave-feedback-email-body' => 'Please describe the problem you are experiencing with {{SITENAME}} above this line. Please note that we cannot reply to every message we receive.',
	'mobile-frontend-leave-feedback-technical-link-text' => 'Technical problem',
	'mobile-frontend-leave-feedback-general-link-text' => 'General feedback',
	'mobile-frontend-leave-feedback-article-personal-link-text' => 'Regarding me, a person, or a company I represent',
	'mobile-frontend-leave-feedback-article-factual-link-text' => 'Regarding a factual error',
	'mobile-frontend-leave-feedback-article-other-link-text' => 'Regarding another problem',
	'mobile-frontend-leave-feedback-form-subject-placeholder' => 'Message subject',
	'mobile-frontend-leave-feedback-form-message-placeholder' => 'Type your comment here',
	'mobile-frontend-leave-feedback-page-title' => 'Mobile site feedback',
	'mobile-frontend-feedback-page' => 'Project:Mobile Extension Feedback',
	'mobile-frontend-leave-feedback-special-title' => 'Contact us',
	'mobile-frontend-feedback-no-subject' => '(no subject)',
	'mobile-frontend-feedback-no-subject-field' => 'Please enter a subject',
	'mobile-frontend-feedback-no-message' => 'Please enter a message here',
	'mobile-frontend-feedback-edit-summary' => '$1 - automatically posted using the [[Special:MobileFeedback|mobile feedback tool]]',
	'mobile-frontend-leave-feedback-thanks' => 'Thanks for your feedback!',
	'mobile-frontend-leave-feedback-post-error' => 'There was an error processing your message. Please try again later.',
	'mobile-frontend-language' => 'Language:',
	'mobile-frontend-language-article-heading' => 'Read in another language',
	'mobile-frontend-current-language' => '{{#language:{{CONTENTLANG}}}}',
	'mobile-frontend-language-header' => 'This page is available in $1 {{PLURAL:$1|language|languages}}',
	'mobile-frontend-language-variant-header' => 'Choose {{#language:{{CONTENTLANG}}}} variant',
	'mobile-frontend-language-footer' => 'Note: This page may not be written in your preferred language. You can see which languages {{SITENAME}} supports by clicking here.',
	'mobile-frontend-language-site-choose' => 'Search language',
	'mobile-frontend-username' => 'Username:',
	'mobile-frontend-password' => 'Password:',
	'mobile-frontend-username-placeholder' => 'Username',
	'mobile-frontend-password-placeholder' => 'Password',
	'mobile-frontend-login' => 'Sign in',
	'mobile-frontend-last-modified-date' => 'Last modified on $1, at $2',
	'mobile-frontend-last-modified-seconds' => 'Last modified {{PLURAL:$1|$1 second|$1 seconds}} ago',
	'mobile-frontend-last-modified-minutes' => 'Last modified {{PLURAL:$1|$1 minute|$1 minutes}} ago',
	'mobile-frontend-last-modified-hours' => 'Last modified {{PLURAL:$1|$1 hour|$1 hours}} ago',
	'mobile-frontend-last-modified-days' => 'Last modified {{PLURAL:$1|$1 day|$1 days}} ago',
	'mobile-frontend-last-modified-months' => 'Last modified {{PLURAL:$1|$1 month|$1 months}} ago',
	'mobile-frontend-last-modified-years' => 'Last modified {{PLURAL:$1|$1 year|$1 years}} ago',
	// account creation
	'mobile-frontend-account-create-submit' => 'Sign up',
	'mobile-frontend-password-confirm-placeholder' => 'Confirm password',
	'mobile-frontend-account-create-email-placeholder' => 'Email address (optional)',
	'mobile-frontend-account-create-captcha-placeholder' => 'Enter security text',
	// Search
	'mobile-frontend-overlay-escape' => 'Go back',
	'mobile-frontend-placeholder' => 'Search {{SITENAME}}',
	'mobile-frontend-placeholder-beta' => 'Search {{SITENAME}} (Beta)',
	'mobile-frontend-placeholder-alpha' => 'Search {{SITENAME}} (Dragon Mode)',
	'mobile-frontend-search-help' => 'Type search term above and matching page titles will appear here.',
	'mobile-frontend-dismiss-notification' => 'dismiss this notification',
	'mobile-frontend-clear-search' => 'Clear',
	'mobile-frontend-privacy-link-text' => 'Privacy',
	'mobile-frontend-about-link-text' => 'About',
	'mobile-frontend-footer-sitename' => '{{SITENAME}}',
	'mobile-frontend-footer-license-text' => 'Content available under [//en.m.wikipedia.org/wiki/Wikipedia:Text_of_Creative_Commons_Attribution-ShareAlike_3.0_Unported_License?useformat=mobile CC BY-SA 3.0]',
	'mobile-frontend-terms-use-text' => '[//wikimediafoundation.org/wiki/Terms_of_use?useformat=mobile Terms of Use]',
	'mobile-frontend-footer-contact' => 'Contact',
	'mobile-frontend-search-noresults' => 'No page titles match your search. Change your search, or press the keyboard search button to search inside pages.',

	// Site navigation menu
	'mobile-frontend-main-menu-button-tooltip' => 'Open main menu',
	'mobile-frontend-main-menu-page-title' => 'Site navigation',
	'mobile-frontend-main-menu-featured' => 'Featured',
	'mobile-frontend-main-menu-nearby' => 'Nearby',
	'mobile-frontend-main-menu-login' => 'Log in',
	'mobile-frontend-main-menu-logout' => 'Log out',
	'mobile-frontend-main-menu-watchlist' => 'Watchlist',
	'mobile-frontend-main-menu-settings' => 'Settings',
	'mobile-frontend-main-menu-upload' => 'Uploads',
	'mobile-frontend-main-menu-settings-heading' => 'Mobile site settings',
	'mobile-frontend-settings-site-header' => '{{SITENAME}} Languages',
	'mobile-frontend-settings-site-description' => '{{SITENAME}} is available in $1 {{PLURAL:$1|language|languages}}. All available versions are listed below',
	'mobile-frontend-main-menu-contact' => 'Contact',
	'mobile-frontend-main-menu-account-create' => 'Create account',
	'mobile-frontend-page-menu-contents' => 'contents',
	'mobile-frontend-page-menu-language-current' => '{{#language:{{CONTENTLANG}}}}',
	'mobile-frontend-page-menu-history' => 'History',
	'mobile-frontend-meta-data-issues-header' => 'Issues',
	'mobile-frontend-meta-data-issues' => 'This page has some issues',

	'mobile-frontend-ajax-page-loading' => 'Loading $1',
	'mobile-frontend-page-saving' => 'Saving $1',
	'mobile-frontend-ajax-page-error' => 'Whoops! Something went wrong there. Please try refreshing your browser window.',

	// nearby
	'mobile-frontend-nearby-title' => 'Nearby',
	'mobile-frontend-nearby-loading' => 'Loading topics near your current location',
	'mobile-frontend-nearby-requirements' => 'This page requires both JavaScript and a location aware browser.',
	'mobile-frontend-nearby-distance-report' => '$1km from your current location',
	'mobile-frontend-nearby-lookup-error' => 'Unable to find you. Trying again..',
	'mobile-frontend-nearby-noresults' => 'You are in the middle of nowhere and we couldn\'t find any topics. Why not write one?',
	'mobile-frontend-nearby-refresh' => 'We found a more accurate location for you. Click here to refresh the list of nearby pages',
	'mobile-frontend-nearby-error' => 'An unexpected error occurred whilst trying to find pages nearby',

	// image donation
	'mobile-frontend-donate-image-login' => 'You must be logged in to see your uploads.',
	'mobile-frontend-photo-upload-generic' => 'Donate an image',
	'mobile-frontend-donate-image-title' => 'Donate an image',
	'mobile-frontend-donate-image-summary' => 'Photos bring pages on {{SITENAME}} to life.
There are many pages which have no photos due to a severe lack of freely licensed photos.
Help bring these pages to life by donating your images that you are willing to give away and could be of use to the wider {{SITENAME}} editing community.',
	'mobile-frontend-donate-image-heading' => 'Your recent contributions',
	'mobile-frontend-donate-image-page-title' => 'Upload',
	'mobile-frontend-donate-image-anon' => 'A [[Special:UserLogin|user account]] is required to view the uploads page',
	'mobile-frontend-listed-image-no-description' => 'No description',
	'mobile-frontend-donate-photo-upload-success' => 'Success! Your image can now be used on {{SITENAME}}!',
	'mobile-frontend-donate-photo-first-upload-success' => 'Success! Thanks for your first contribution!',

	// watchlist
	'mobile-frontend-watchlist-add' => 'Added $1 to your watchlist',
	'mobile-frontend-watchlist-removed' => 'Removed $1 from your watchlist',
	'mobile-frontend-watchlist-view' => 'View your watchlist',
	'mobile-frontend-watchlist-more' => 'more',
	'mobile-frontend-watchlist-cta' => 'Please login or sign up to watch this page.',
	'mobile-frontend-watchlist-cta-button-login' => 'Login',
	'mobile-frontend-watchlist-cta-button-signup' => 'Sign up',
	'mobile-frontend-watch-login' => 'You must be logged in to watch pages.',

	'mobile-frontend-watchlist-a-z' => 'All',
	'mobile-frontend-watchlist-feed' => 'Modified',
	'mobile-frontend-watchlist-a-z-empty' => 'You are currently not watching any pages',
	'mobile-frontend-watchlist-a-z-empty-howto-alt' => 'Click the star at the top of the page',
	'mobile-frontend-watchlist-a-z-empty-howto' => 'Watch a page you have found interesting by clicking the star icon at the top of the screen. This will allow you to bookmark pages of interest as well as see when they have changed.',
	'mobile-frontend-watchlist-feed-empty' => 'There are no pages with recent changes',
	'mobile-frontend-watchlist-back-home' => 'Back home',

	'mobile-frontend-changeslist-ip' => 'Anonymous user',
	'mobile-frontend-changeslist-nocomment' => 'no edit summary',
	'mobile-frontend-watchlist-filter-all' => 'All',
	'mobile-frontend-watchlist-filter-articles' => 'Articles',
	'mobile-frontend-watchlist-filter-talk' => 'Talk',
	'mobile-frontend-watchlist-filter-other' => 'Other',
	'mobile-frontend-watchlist-modified' => 'Modified $1',

	'mobile-frontend-diffview-404-title' => 'Bad revision',
	'mobile-frontend-diffview-404-desc' => 'The id for the revision you requested does not exist',
	'mobile-frontend-diffview-title' => 'Changes',
	'mobile-frontend-diffview-editcount' => '$1 {{PLURAL:$1|edit|edits}}',
	'mobile-frontend-diffview-anonymous' => 'Anonymous user',
	'mobile-frontend-diffview-bytesadded' => '$1 {{PLURAL:$1|byte|bytes}} added',
	'mobile-frontend-diffview-bytesremoved' => '$1 {{PLURAL:$1|byte|bytes}} removed',
	'mobile-frontend-diffview-explained' => 'The following lines were added (+) and removed (-):',

	// tables
	'mobile-frontend-table' => 'Table $1',
	// confirm exit
	'mobile-frontend-saving-exit-page' => 'Your contribution is still saving. If you leave your contributions will be lost. Are you sure you want to exit?',

	// photo uploads
	'mobile-frontend-photo-upload' => 'Add an image to this article',
	'mobile-frontend-photo-article-edit-comment' => 'Added photo for use on page',
	'mobile-frontend-photo-article-donate-comment' => 'Donated image from mobile',
	'mobile-frontend-photo-upload-comment' => 'Added photo to page',
	'mobile-frontend-photo-caption-placeholder' => 'Add a description (required)',
	'mobile-frontend-image-loading' => 'Loading image',
	'mobile-frontend-image-uploading-wait' => 'Uploading image, please wait.',
	'mobile-frontend-image-uploading-long' => 'Image still uploading! Thanks for your patience.',
	'mobile-frontend-image-uploading-cancel' => '<a href="#">Cancel</a> if this is taking too long.',
	'mobile-frontend-photo-upload-error' => 'Error, try again.',
	'mobile-frontend-photo-upload-success-article' => 'Success! Your image is now live on this page.',
	'mobile-frontend-photo-license' => 'By clicking "Submit", you agree to our [//wikimediafoundation.org/wiki/Terms_of_use Terms of Use] and agree to release your photo under the [//creativecommons.org/licenses/by-sa/3.0/ Creative Commons Attribution-ShareAlike 3.0 License].',
	'mobile-frontend-photo-submit' => 'Submit',
	'mobile-frontend-photo-cancel' => 'Cancel',
	'mobile-frontend-photo-upload-user-count' => '{{PLURAL:$1|<span>1</span> upload|<span>$1</span> uploads}}',
	'mobile-frontend-photo-upload-user-count-over-limit' => '500+ uploads',

	// Change tags
	'tag-mobile_edit' => 'Mobile edit',
	'tag-mobile_edit-description' => 'Edit made from mobile site',

	// navigation drawer
	'mobile-frontend-drawer-cancel' => 'Cancel',
);

/** Message documentation (Message documentation)
 * @author Amire80
 * @author Asmen
 * @author Base
 * @author Beta16
 * @author EugeneZelenko
 * @author Fryed-peach
 * @author Kghbln
 * @author McDutchie
 * @author Minh Nguyen
 * @author Mormegil
 * @author Nemo bis
 * @author Purodha
 * @author Raymond
 * @author SPQRobin
 * @author Shirayuki
 * @author Siebrand
 * @author Umherirrender
 * @author Wellwisher
 * @author Yekrats
 */
$messages['qqq'] = array(
	'mobile-frontend-desc' => '{{desc|name=Mobile Frontend|url=http://www.mediawiki.org/wiki/Extension:MobileFrontend}}',
	'mobile.css' => '{{optional}}
*{{msg-mw|Mobile.js}} (optional)
*{{msg-mw|Mobile.css}} (optional)',
	'mobile.js' => '{{optional}}
*{{msg-mw|Mobile.js}} (optional)
*{{msg-mw|Mobile.css}} (optional)',
	'mobile-frontend-search-submit' => 'Label for the button near the search box.
{{Identical|Go}}',
	'mobile-frontend-home-button' => 'This is the label of one of the buttons that appear if you click the wiki logo near the search box.

This buttons takes the user to the home page.
{{Identical|Home}}',
	'mobile-frontend-logged-out' => 'Message telling user they are not logged in on settings page.
{{Identical|Not logged in}}',
	'mobile-frontend-logged-in-homepage-notification' => 'Heading at top of homepage telling user they are logged in',
	'mobile-frontend-logged-in-toast-notification' => 'Message telling user that they are logged in. Shows as a notification at bottom of page
*$1 - username',
	'mobile-frontend-sign-up-heading' => 'Header for sign up page.
{{Identical|Sign up}}',
	'mobile-frontend-sign-in-heading' => 'Header for login page.
{{Identical|Sign in}}',
	'mobile-frontend-sign-in-why' => 'Short summary before login page explaining why someone should bother signing in',
	'mobile-frontend-sign-in-error-heading' => 'Heading for when an error occurred. You can translate "Error" instead.',
	'mobile-frontend-settings-description' => 'Text at top of the settings page explaining its purpose',
	'mobile-frontend-settings-beta' => 'Text for beta on settings page',
	'mobile-frontend-settings-alpha' => 'Heading for alpha mode on settings page. This is a highly experimental mode where there might be bugs',
	'mobile-frontend-settings-alpha-description' => 'Disclaimer about dangers and excitement that come with being in an alpha mode',
	'mobile-frontend-save-settings' => 'Text for button for saving settings on Special:MobileOptions.
{{Identical|Save settings}}',
	'mobile-frontend-random-button' => 'This is the label of one of the buttons that appear if you click the wiki logo near the search box.

This buttons takes the user to a random page.',
	'mobile-frontend-ajax-random-heading' => 'Message to show whilst locating a random article via ajax request',
	'mobile-frontend-ajax-random-quote' => 'Inspirational quote related to learning. This quote is attributed to [[wikiquote:Albert Einstein|Albert Einstein]].',
	'mobile-frontend-ajax-random-quote-author' => '{{Optional}}
Author of the quote chosen',
	'mobile-frontend-ajax-random-question' => 'Prompt that goes alongside the title of the article asking if the user wants to read',
	'mobile-frontend-ajax-random-yes' => 'Answer to question when they do want to read',
	'mobile-frontend-ajax-random-retry' => 'Answer to question when they would like to try again',
	'mobile-frontend-ajax-random-suggestions' => 'Prefix before a list of 10 random links to articles that can be clicked',
	'mobile-frontend-back-to-top-of-section' => 'This is a link that appears at the end of a page section.',
	'mobile-frontend-close-section' => 'This link allows you to close a page section.',
	'mobile-frontend-show-button' => '{{Identical|Show}}',
	'mobile-frontend-hide-button' => '{{Identical|Hide}}',
	'mobile-frontend-empty-homepage-text' => 'Message to display when an empty homepage is encountered',
	'mobile-frontend-regular-site' => 'When on the mobile site, this text links to the normal page for desktop computers',
	'mobile-frontend-wml-continue' => '{{Identical|Continue}}',
	'mobile-frontend-wml-back' => '{{Identical|Back}}',
	'mobile-frontend-view' => 'This is a link that appears at the bottom of a desktop view wiki page near {{msg-mw|privacy}} and {{msg-mw|disclaimers}}. Clicking it takes the user to a mobile view of the page.',
	'mobile-frontend-view-desktop' => 'This is a link that appears at the bottom of the mobile page. Clicking it takes the user to the desktop page. It appears near the message {{msg-mw|Mobile-frontend-view-mobile}} and should be worded similarly.
{{Identical|Desktop}}',
	'mobile-frontend-view-mobile' => 'This appears at the bottom of the mobile page, meaning that the current view is mobile. It appears near the message {{msg-mw|Mobile-frontend-view-desktop}} and should be worded similarly.
{{Identical|Mobile}}',
	'mobile-frontend-images-status' => 'On settings page label for turning on/off images.
{{Identical|Images}}',
	'mobile-frontend-missing-image' => 'When the mobile site removes images it replaces them with a link to the image and the alt text of the image. If no alt text is provided this string is shown to inform the user it is an image.
{{Identical|Image}}',
	'mobile-frontend-off' => 'On settings page signals that a feature will be turned off. Appears in {{msg-mw|Mobile-frontend-toggle-images}}.',
	'mobile-frontend-on' => 'On settings page signals that a feature will be turned on. Appears in {{msg-mw|Mobile-frontend-toggle-images}}.',
	'mobile-frontend-footer-contributors-text' => 'Link to history page',
	'mobile-frontend-featured-article' => 'The title that will appear before the element with the mf-tfa selector.',
	'mobile-frontend-news-items' => 'The title that will appear before the element with the mf-itn selector.',
	'mobile-frontend-leave-feedback-notice' => 'Parameters:
* "$1" is a link  to the page where the feedback will be posted.',
	'mobile-frontend-leave-feedback-subject' => '{{Identical|Subject}}',
	'mobile-frontend-leave-feedback-message' => '{{Identical|Message}}',
	'mobile-frontend-leave-feedback-submit' => 'Enter your feedback and submit',
	'mobile-frontend-leave-feedback-title' => 'Special page title',
	'mobile-frontend-leave-feedback-technical-problem-section-header' => 'Section header text for technical feedback portion of feedback form',
	'mobile-frontend-leave-feedback-general-section-header' => 'Section header text for general feedback portion of feedback form
{{Identical|General}}',
	'mobile-frontend-leave-feedback-article-feedback-section-header' => 'Section header text for article feedback portion of feedback form',
	'mobile-frontend-leave-feedback-email-body' => "Text that will appear in the e-mail body for feedback e-mails, instructing users to reply above this line of text with their technical problem. Please ensure that this doesn't request an e-mail address as we have this already! Also include a reference to the fact that they may not receive a reply to prevent follow ups.",
	'mobile-frontend-leave-feedback-technical-link-text' => 'Text for a link to give feedback about a technical problem.',
	'mobile-frontend-leave-feedback-general-link-text' => 'Text for a link to give general feedback',
	'mobile-frontend-leave-feedback-article-personal-link-text' => 'Text for a link to give article feedback regarding the user or another person',
	'mobile-frontend-leave-feedback-article-factual-link-text' => 'Text for a link to give article feedback regarding a factual error',
	'mobile-frontend-leave-feedback-article-other-link-text' => 'Text for a link to give article feedback regarding some other problem',
	'mobile-frontend-leave-feedback-form-subject-placeholder' => 'Placeholder for the "subject" field in the feedback form, which regards the subject of the message being submitted',
	'mobile-frontend-leave-feedback-form-message-placeholder' => 'Placeholder for the "message" field in the feedback form, which regards the feedback the user is submitting',
	'mobile-frontend-leave-feedback-page-title' => 'Special page title',
	'mobile-frontend-feedback-page' => '{{optional}}',
	'mobile-frontend-leave-feedback-special-title' => 'Title of special page containing the feedback form',
	'mobile-frontend-feedback-no-subject' => 'Used for section heading on the feedback page if user entered no subject',
	'mobile-frontend-feedback-no-message' => 'Error message on feedback form',
	'mobile-frontend-feedback-edit-summary' => '{{doc-important|Do not translate the special page name "<code>Special:MobileFeedback</code>".}}
Edit summary. Parameters:
* $1 - feedback subject',
	'mobile-frontend-leave-feedback-post-error' => 'Message displayed to user when there is an internal error processing form submission',
	'mobile-frontend-language' => '{{Identical|Language}}',
	'mobile-frontend-language-article-heading' => 'A heading within the article the content of which lists the other languages available for this article: translate the message considering the list to have an undetermined number of items.',
	'mobile-frontend-current-language' => '{{optional}}',
	'mobile-frontend-language-header' => 'Header at top of language selection overlay describing number of languages that it is possible to read the article in
* $1 - number of languages',
	'mobile-frontend-language-variant-header' => 'Header at top of language selection overlay prompting a user to select variant of the current language',
	'mobile-frontend-language-footer' => 'Footer at bottom of language selection overlay. This informs a user that if they cannot see a certain language in the list that there are other language versions of the current site that can be viewed by clicking on this link.',
	'mobile-frontend-language-site-choose' => 'Header for overlay when click on language on settings page',
	'mobile-frontend-username' => 'Field label for entry of username in Wikimedia mobile user interface.

{{Identical|Username}}',
	'mobile-frontend-password' => 'Field label for entry of password in Wikimedia mobile user interface.
{{Identical|Password}}',
	'mobile-frontend-username-placeholder' => 'placeholder text for username input box.
{{Identical|Username}}',
	'mobile-frontend-password-placeholder' => 'placeholder text for password input box.
{{Identical|Password}}',
	'mobile-frontend-login' => 'Button text for login in Wikimedia mobile user interface.
{{Identical|Log in}}',
	'mobile-frontend-last-modified-date' => 'Text that displays the date the page was last modified. Parameters:
* $1 - date
* $2 - time
See also:
* {{msg-mw|Mobile-frontend-last-modified-seconds}}
* {{msg-mw|Mobile-frontend-last-modified-minutes}}
* {{msg-mw|Mobile-frontend-last-modified-hours}}
* {{msg-mw|Mobile-frontend-last-modified-days}}
* {{msg-mw|Mobile-frontend-last-modified-months}}
* {{msg-mw|Mobile-frontend-last-modified-years}}',
	'mobile-frontend-last-modified-seconds' => 'Text displayed on page to show how long ago the page was updated in seconds.

See also:
* {{msg-mw|Mobile-frontend-last-modified-minutes}}
* {{msg-mw|Mobile-frontend-last-modified-hours}}
* {{msg-mw|Mobile-frontend-last-modified-days}}
* {{msg-mw|Mobile-frontend-last-modified-months}}
* {{msg-mw|Mobile-frontend-last-modified-years}}
* {{msg-mw|Mobile-frontend-last-modified-date}}',
	'mobile-frontend-last-modified-minutes' => 'Text displayed on page to show how long ago the page was updated in minutes.

See also:
* {{msg-mw|Mobile-frontend-last-modified-seconds}}
* {{msg-mw|Mobile-frontend-last-modified-hours}}
* {{msg-mw|Mobile-frontend-last-modified-days}}
* {{msg-mw|Mobile-frontend-last-modified-months}}
* {{msg-mw|Mobile-frontend-last-modified-years}}
* {{msg-mw|Mobile-frontend-last-modified-date}}',
	'mobile-frontend-last-modified-hours' => 'Text displayed on page to show how long ago the page was updated in hours.

See also:
* {{msg-mw|Mobile-frontend-last-modified-seconds}}
* {{msg-mw|Mobile-frontend-last-modified-minutes}}
* {{msg-mw|Mobile-frontend-last-modified-days}}
* {{msg-mw|Mobile-frontend-last-modified-months}}
* {{msg-mw|Mobile-frontend-last-modified-years}}
* {{msg-mw|Mobile-frontend-last-modified-date}}',
	'mobile-frontend-last-modified-days' => 'Text displayed on page to show how long ago the page was updated in days.

See also:
* {{msg-mw|Mobile-frontend-last-modified-seconds}}
* {{msg-mw|Mobile-frontend-last-modified-minutes}}
* {{msg-mw|Mobile-frontend-last-modified-hours}}
* {{msg-mw|Mobile-frontend-last-modified-months}}
* {{msg-mw|Mobile-frontend-last-modified-years}}
* {{msg-mw|Mobile-frontend-last-modified-date}}',
	'mobile-frontend-last-modified-months' => 'Text displayed on page to show how long ago the page was updated in months.

See also:
* {{msg-mw|Mobile-frontend-last-modified-seconds}}
* {{msg-mw|Mobile-frontend-last-modified-minutes}}
* {{msg-mw|Mobile-frontend-last-modified-hours}}
* {{msg-mw|Mobile-frontend-last-modified-days}}
* {{msg-mw|Mobile-frontend-last-modified-years}}
* {{msg-mw|Mobile-frontend-last-modified-date}}',
	'mobile-frontend-last-modified-years' => 'Text displayed on page to show how long ago the page was updated in years.

See also:
* {{msg-mw|Mobile-frontend-last-modified-seconds}}
* {{msg-mw|Mobile-frontend-last-modified-minutes}}
* {{msg-mw|Mobile-frontend-last-modified-hours}}
* {{msg-mw|Mobile-frontend-last-modified-days}}
* {{msg-mw|Mobile-frontend-last-modified-months}}
* {{msg-mw|Mobile-frontend-last-modified-date}}',
	'mobile-frontend-account-create-submit' => 'Text in account creation submit button.
{{Identical|Sign up}}',
	'mobile-frontend-password-confirm-placeholder' => 'Placeholder for confirm password field',
	'mobile-frontend-account-create-email-placeholder' => 'Placeholder for email address field',
	'mobile-frontend-account-create-captcha-placeholder' => 'Placeholder for captcha input field',
	'mobile-frontend-overlay-escape' => 'Text for the button to the left of search / an overlay that when clicked exits the overlay to the previous screen
{{Identical|Go back}}',
	'mobile-frontend-placeholder' => 'Phrase used to prompt user to use search interface for mobile full screen search',
	'mobile-frontend-placeholder-beta' => 'Phrase used to prompt user to use search interface for mobile full screen search with identifier that you are in beta mode',
	'mobile-frontend-placeholder-alpha' => 'Phrase used to prompt user to use search interface for mobile full screen search with identifier that you are in experimental mode',
	'mobile-frontend-search-help' => 'Help text that appears under search results when the search is focused',
	'mobile-frontend-dismiss-notification' => 'Phrase used to dismiss the top banner notification',
	'mobile-frontend-clear-search' => 'Tooltip for clear button that appears when you type into search box.
{{Identical|Clear}}',
	'mobile-frontend-privacy-link-text' => 'Custom version of "Privacy policy" link text for mobile footer, intended to be as brief as possible to take up as little screen real estate as possible.
{{Identical|Privacy}}',
	'mobile-frontend-about-link-text' => 'Custom version of "About {{Sitename}}" link text for mobile footer, intended to be as brief as possible to take up as little screen real estate as possible',
	'mobile-frontend-footer-sitename' => 'Name of site',
	'mobile-frontend-footer-license-text' => 'License shown in footer',
	'mobile-frontend-terms-use-text' => 'Label for terms of use link',
	'mobile-frontend-footer-contact' => 'Label for contact in footer',
	'mobile-frontend-search-noresults' => 'Text that appears when a search returns no results',
	'mobile-frontend-main-menu-button-tooltip' => 'Tooltip for menu button',
	'mobile-frontend-main-menu-page-title' => 'Title for Special:MobileMenu - shown to user in title bar of browser window',
	'mobile-frontend-main-menu-featured' => 'Featured link text in main menu
{{Identical|Featured}}',
	'mobile-frontend-main-menu-nearby' => 'Nearby link text in main menu.
{{Identical|Nearby}}',
	'mobile-frontend-main-menu-login' => 'Text for log in link in main menu.
{{Identical|Log in}}',
	'mobile-frontend-main-menu-logout' => 'Text for logout link in main menu.
{{Identical|Log out}}',
	'mobile-frontend-main-menu-watchlist' => 'Text for watchlist link in main menu.
{{Identical|My watchlist}}',
	'mobile-frontend-main-menu-settings' => 'Settings link text in main menu',
	'mobile-frontend-main-menu-upload' => 'Uploads link text in main menu.
{{Identical|Upload}}',
	'mobile-frontend-main-menu-settings-heading' => 'Heading for Special:MobileOptions page',
	'mobile-frontend-settings-site-header' => 'Heading for the Special:MobileOptions/Language page - only visible to non javascript users',
	'mobile-frontend-settings-site-description' => 'Shown on Special:MobileOptions
*$1 - the number of other language versions for this wiki',
	'mobile-frontend-main-menu-contact' => 'Contact link text in main menu',
	'mobile-frontend-main-menu-account-create' => 'Account creation link in main menu.
{{Identical|Create account}}',
	'mobile-frontend-page-menu-contents' => 'table of contents link text in secondary menu.
{{Identical|Content}}',
	'mobile-frontend-page-menu-language-current' => 'the text of the language link text in secondary menu which when clicked allows the user to change the content language of an article

{{optional}}',
	'mobile-frontend-page-menu-history' => 'history link text in secondary menu.
{{Identical|History}}',
	'mobile-frontend-meta-data-issues-header' => 'Heading for overlay listing all cleanup templates',
	'mobile-frontend-meta-data-issues' => 'This should be several words and should explain that an article has cleanup templates on it - meaning there is room for improvement on the page. It appears in a button that when clicked opens the overlay with heading {{msg-mw|mobile-frontend-meta-data-issues-header}}',
	'mobile-frontend-ajax-page-loading' => 'Text that accompanies an ajax loader when you dynamically load an article via javascript',
	'mobile-frontend-page-saving' => 'Text shown whilst an article is being saved',
	'mobile-frontend-ajax-page-error' => 'Text that accompanies an ajax loader when you dynamically load an article via javascript and it fails',
	'mobile-frontend-nearby-title' => 'Title of Special:Nearby.
{{Identical|Nearby}}',
	'mobile-frontend-nearby-loading' => 'Informative message telling user that their location is being looked up',
	'mobile-frontend-nearby-requirements' => 'Message shown to users who have no javascript or a browser that is not capable',
	'mobile-frontend-nearby-distance-report' => 'Distance to current location',
	'mobile-frontend-nearby-lookup-error' => 'Error message that shows in toast notification when location was lost',
	'mobile-frontend-nearby-noresults' => 'Message shown when nothing is nearby',
	'mobile-frontend-nearby-refresh' => 'Text of toast notification message shown when user moved and the list can be refreshed.',
	'mobile-frontend-nearby-error' => 'Text of generic error message when querying geodata api',
	'mobile-frontend-donate-image-login' => 'Title for [[Special:UserLogin]] when being redirected to Special:DonateImage',
	'mobile-frontend-photo-upload-generic' => 'Label on donate interface on Special:DonateImage.
{{Identical|Donate an image}}',
	'mobile-frontend-donate-image-title' => 'Title for Special:DonateImage.
{{Identical|Donate an image}}',
	'mobile-frontend-donate-image-summary' => 'Explanation of purpose of page and importance of participation.',
	'mobile-frontend-donate-image-heading' => 'heading for a list of recent contributions',
	'mobile-frontend-donate-image-page-title' => 'Heading for the Special:DonateImage page.
{{Identical|Upload}}',
	'mobile-frontend-donate-image-anon' => 'Message shown to user who visits the donate image page without a user account',
	'mobile-frontend-listed-image-no-description' => 'What to show when no description available',
	'mobile-frontend-donate-photo-upload-success' => 'On upload page - notification shown after a successful upload',
	'mobile-frontend-donate-photo-first-upload-success' => 'On upload page - notification shown after a successful upload when it is the first upload by that user',
	'mobile-frontend-watchlist-add' => 'Notification message when you add an article to your watchlist
*$1 - the title of the article',
	'mobile-frontend-watchlist-removed' => 'Notification message when you remove an article from your watchlist
*$1 - the title of the article',
	'mobile-frontend-watchlist-view' => 'Link to your watchlist',
	'mobile-frontend-watchlist-more' => 'Label for link that shows more pages of the watchlist a-z view.
{{Identical|More}}',
	'mobile-frontend-watchlist-cta' => 'Appears above the login form when you click watchlist icon when not logged in. First link is to login form, 2nd to sign up form. Links are created in javascript.',
	'mobile-frontend-watchlist-cta-button-login' => 'A link with label to login page
{{Identical|Login}}',
	'mobile-frontend-watchlist-cta-button-signup' => 'A link with label to sign up page
{{Identical|Sign up}}',
	'mobile-frontend-watchlist-a-z' => 'Label for a button that takes you to an A-Z list of all items in your watchlist.
{{Identical|All}}',
	'mobile-frontend-watchlist-feed' => 'Label for a button that takes you to a list of articles you watch that have changes.
{{Identical|Modified}}',
	'mobile-frontend-watchlist-a-z-empty' => 'Message to show when watchlist a-z list is empty',
	'mobile-frontend-watchlist-a-z-empty-howto-alt' => 'Alt text for image explaining how to watch articles',
	'mobile-frontend-watchlist-a-z-empty-howto' => 'Message to accompany image',
	'mobile-frontend-watchlist-feed-empty' => 'Message to show when watchlist feed is empty',
	'mobile-frontend-watchlist-back-home' => 'Label for button that takes you back to main page from empty watchlist',
	'mobile-frontend-changeslist-ip' => 'Label used in mobile watchlist/history/recentchanges overview for IP (non-logged-in) edits.
{{Identical|Anonymous user}}',
	'mobile-frontend-changeslist-nocomment' => 'Text to mark an empty edit summary in mobile watchlist/history/recentchanges overview.',
	'mobile-frontend-watchlist-filter-all' => 'Label on filter selector for mobile watchlist: all pages.
{{Identical|All}}',
	'mobile-frontend-watchlist-filter-articles' => 'Label on filter selector for mobile watchlist: all pages: article pages only',
	'mobile-frontend-watchlist-filter-talk' => 'Label on filter selector for mobile watchlist: talk pages',
	'mobile-frontend-watchlist-filter-other' => 'Label on filter selector for mobile watchlist: other pages (not talk or article).
{{Identical|Other}}',
	'mobile-frontend-watchlist-modified' => 'Text saying how long ago a page in watchlist was updated.
* $1 - output of {{msg-mw|ago}} (e.g. "15 days ago", "7 hours ago").',
	'mobile-frontend-diffview-404-title' => 'Heading on 404 page when bad revision id parameter is passed',
	'mobile-frontend-diffview-404-desc' => 'Text for 404 page when bad revision id parameter is passed',
	'mobile-frontend-diffview-title' => 'Header for common mobile diff/change view. Takes an optional parameter (for backwards compatibility):
* $1 is page title.',
	'mobile-frontend-diffview-editcount' => 'Edit count of user in common mobile diff/change view. $1 is the count, may use PLURAL.',
	'mobile-frontend-diffview-anonymous' => 'Label to indicate anonymous user in common mobile diff/change view.
{{Identical|Anonymous user}}',
	'mobile-frontend-diffview-bytesadded' => 'Edit byte-changed counter for common mobile diff/change view when change adds bytes. $1 is byte count; may use PLURAL.',
	'mobile-frontend-diffview-bytesremoved' => 'Edit byte-changed counter for common mobile diff/change view when change removes bytes. $1 is byte count; may use PLURAL.',
	'mobile-frontend-diffview-explained' => 'Explains the diff view importantly signaling that a "+" symbol means added and a "-" symbol means removed',
	'mobile-frontend-table' => 'Label for a button when clicked that opens a table. $1 is a unique table number for the article',
	'mobile-frontend-saving-exit-page' => 'When a user makes an edit in the page which is happening in the background
and then tries to leave the page this message is shown to check that they are happy that they will lose their changes.
They can either exit the page and lose them or stay on the page until they are complete',
	'mobile-frontend-photo-upload' => 'This appears on articles which have no photos and is a call to action to add the first image',
	'mobile-frontend-photo-article-edit-comment' => 'Comment associated with edit to page that inserts the image wikitext',
	'mobile-frontend-photo-article-donate-comment' => 'Edit summary associated with donating an image from mobile',
	'mobile-frontend-photo-upload-comment' => 'Comment associated with the upload of a photo',
	'mobile-frontend-photo-caption-placeholder' => 'Placeholder text prompting user to add a mandatory caption to a photo',
	'mobile-frontend-image-loading' => 'Text that displays while an image is loading',
	'mobile-frontend-image-uploading-wait' => 'Text that displays whilst an image is being uploaded',
	'mobile-frontend-image-uploading-long' => 'Text that displays whilst an image is taking long to upload',
	'mobile-frontend-image-uploading-cancel' => 'Text saying that user can cancel the image upload. Word "cancel" should be a link.',
	'mobile-frontend-photo-upload-error' => 'Text that displays when a photo fails to upload',
	'mobile-frontend-photo-upload-success-article' => 'Text that displays when a photo has been successfully added to a page.',
	'mobile-frontend-photo-license' => 'Text notifying user of license that image will be published under. You can change the URL to a "local" Wikipedia URL, but you cannot make it point to the country specific CC BY-SA 3.0 license.',
	'mobile-frontend-photo-submit' => 'Caption for the submit button on the photo uplaod form.
{{Identical|Submit}}',
	'mobile-frontend-photo-cancel' => 'Caption for the cancel button on the photo upload form.
{{Identical|Cancel}}',
	'mobile-frontend-photo-upload-user-count' => 'Displays the number of images the user has uploaded. Parameter is number of images. Wrap the number in a span tag to allow the number to be incremented programatically',
	'mobile-frontend-photo-upload-user-count-over-limit' => 'Displayed in place of mobile-frontend-photo-upload-user-count when user has uploaded more than 500 images.',
	'tag-mobile_edit' => 'Short change tag name that appears e.g. in [[Special:RecentChanges]].

See also:
* {{msg-mw|tag-mobile_edit-description}}',
	'tag-mobile_edit-description' => 'Change tag description e.g. in [[Special:Tags]], see also {{msg-mw|tag-mobile_edit}}',
	'mobile-frontend-drawer-cancel' => 'Not visible but the text label for the cancel button inside a navigation overlay
{{Identical|Cancel}}',
);

/** Achinese (Acèh)
 */
$messages['ace'] = array(
	'mobile-frontend-search-submit' => 'Jak u',
	'mobile-frontend-home-button' => 'Keue',
	'mobile-frontend-random-button' => 'Beurangkari',
	'mobile-frontend-back-to-top-of-section' => 'Riwang u bagian sigoh nyoe',
	'mobile-frontend-show-button' => 'Peuleumah',
	'mobile-frontend-hide-button' => 'Peusom',
	'mobile-frontend-regular-site' => 'Eu on nyoe bak {{SITENAME}} biyasa', # Fuzzy
	'mobile-frontend-featured-article' => 'Teunuleh Peunileh Uroe Nyoe',
);

/** Afrikaans (Afrikaans)
 * @author Naudefj
 * @author පසිඳු කාවින්ද
 */
$messages['af'] = array(
	'mobile-frontend-desc' => 'Mobiele Koppelvlak',
	'mobile-frontend-search-submit' => 'Soek',
	'mobile-frontend-home-button' => 'Tuisblad',
	'mobile-frontend-logged-out' => 'Nie aangemeld nie',
	'mobile-frontend-settings-beta' => 'Beta',
	'mobile-frontend-save-settings' => 'Stoor voorkeure',
	'mobile-frontend-random-button' => 'Lukrake blad',
	'mobile-frontend-back-to-top-of-section' => 'Spring een opskrif terug',
	'mobile-frontend-close-section' => 'Sluit hierdie paragraaf',
	'mobile-frontend-show-button' => 'Wys',
	'mobile-frontend-hide-button' => 'Versteek',
	'mobile-frontend-regular-site' => 'Standaardweergawe',
	'mobile-frontend-wml-continue' => 'Gaan voort ...',
	'mobile-frontend-wml-back' => 'Terug ...',
	'mobile-frontend-view' => 'Mobiele weergawe',
	'mobile-frontend-view-mobile' => 'Mobiele weergawe',
	'mobile-frontend-images-status' => 'Beelde',
	'mobile-frontend-disable-images' => 'Skakel beelde af',
	'mobile-frontend-enable-images' => 'Skakel beelde aan',
	'mobile-frontend-off' => 'AF',
	'mobile-frontend-on' => 'AAN',
	'mobile-frontend-footer-contributors-text' => 'Bladsye deur [$1 gebruikers] soos u',
	'mobile-frontend-featured-article' => 'Uitgelig',
	'mobile-frontend-news-items' => 'In die nuus',
	'mobile-frontend-leave-feedback-subject' => 'Onderwerp:',
	'mobile-frontend-leave-feedback-message' => 'Boodskap:',
	'mobile-frontend-leave-feedback-submit' => 'Stuur terugvoer',
	'mobile-frontend-leave-feedback-link-text' => 'Terugvoer oor mobiele koppelvlak',
	'mobile-frontend-leave-feedback' => 'Gee terugvoer',
	'mobile-frontend-leave-feedback-title' => 'Gee terugvoer oor u mobiele ervaringe',
	'mobile-frontend-leave-feedback-technical-problem-section-header' => 'Tegniese probleem',
	'mobile-frontend-leave-feedback-general-section-header' => 'Algemeen',
	'mobile-frontend-leave-feedback-article-feedback-section-header' => 'Bladsybeoordeling',
	'mobile-frontend-leave-feedback-email-body' => 'Skryf u e-pos bokant die reël.', # Fuzzy
	'mobile-frontend-leave-feedback-technical-link-text' => 'Tegniese probleem',
	'mobile-frontend-leave-feedback-general-link-text' => 'Algemene terugvoer',
	'mobile-frontend-leave-feedback-article-personal-link-text' => "Met betrekking tot my, 'n persoon of 'n maatskappy wat ek verteenwoordig",
	'mobile-frontend-leave-feedback-article-factual-link-text' => "Met betrekking tot 'n inhoudelike fout",
	'mobile-frontend-leave-feedback-article-other-link-text' => "Met betrekking tot 'n ander probleem",
	'mobile-frontend-leave-feedback-form-subject-placeholder' => 'Onderwerp',
	'mobile-frontend-leave-feedback-form-message-placeholder' => 'Voer u opmerking hier in',
	'mobile-frontend-leave-feedback-page-title' => 'Gee terugvoer oor u mobiele ervaringe',
	'mobile-frontend-leave-feedback-special-title' => 'Kontak ons',
	'mobile-frontend-feedback-no-subject' => '(geen onderwerp)',
	'mobile-frontend-feedback-no-subject-field' => "Verskaf asseblief 'n onderwerp.",
	'mobile-frontend-feedback-no-message' => 'Voeg boodskap hier in',
	'mobile-frontend-leave-feedback-thanks' => 'Dankie vir u terugvoer!',
	'mobile-frontend-language' => 'Taal:',
	'mobile-frontend-language-header' => "Hierdie bladsy is in {{PLURAL:$1|'n taal|$1 tale}} beskikbaar", # Fuzzy
	'mobile-frontend-language-footer' => '{{SITENAME}} is in ander tale beskikbaar.', # Fuzzy
	'mobile-frontend-username' => 'Gebruikersnaam:',
	'mobile-frontend-password' => 'Wagwoord',
	'mobile-frontend-login' => 'Teken in',
	'mobile-frontend-placeholder' => 'Deursoek {{SITENAME}}',
	'mobile-frontend-privacy-link-text' => 'Privaatheid',
	'mobile-frontend-about-link-text' => 'Aangaande',
	'mobile-frontend-footer-sitename' => '{{SITENAME}}',
	'mobile-frontend-footer-contact' => 'Kontak',
	'mobile-frontend-main-menu-featured' => 'Uitgelig',
	'mobile-frontend-main-menu-settings' => 'Voorkeure',
	'mobile-frontend-main-menu-contact' => 'Kontak',
	'mobile-frontend-page-menu-history' => 'Geskiedenis',
);

/** Akan (Akan)
 */
$messages['ak'] = array(
	'mobile-frontend-search-submit' => 'Kɔ',
	'mobile-frontend-home-button' => 'Fie',
	'mobile-frontend-random-button' => 'Randɔm',
	'mobile-frontend-show-button' => 'Kyerɛ',
	'mobile-frontend-hide-button' => 'Suma',
	'mobile-frontend-regular-site' => 'Hwɛ krataafa yi wɔ {{SITENAME}} a yenim dada so', # Fuzzy
	'mobile-frontend-featured-article' => 'Aatikel a Ɛwɔ So Ndɛ',
);

/** Amharic (አማርኛ)
 */
$messages['am'] = array(
	'mobile-frontend-search-submit' => 'ሂድ',
	'mobile-frontend-home-button' => 'ቤት',
	'mobile-frontend-random-button' => 'በነሲብ',
	'mobile-frontend-back-to-top-of-section' => 'ወደኋላ ምዕራፍ ዝለል',
	'mobile-frontend-show-button' => 'አሳይ',
	'mobile-frontend-hide-button' => 'ደብቅ',
	'mobile-frontend-featured-article' => 'ለዛሬ የተመረጠ ድርሰት',
);

/** Aragonese (aragonés)
 * @author Juanpabl
 */
$messages['an'] = array(
	'mobile-frontend-desc' => 'Interficie mobil',
	'mobile-frontend-search-submit' => 'Ir-ie',
	'mobile-frontend-home-button' => 'Portalada',
	'mobile-frontend-random-button' => 'Aliatorio',
	'mobile-frontend-back-to-top-of-section' => 'Ir una sección entazaga',
	'mobile-frontend-show-button' => 'Amostrar',
	'mobile-frontend-hide-button' => 'Amagar',
	'mobile-frontend-regular-site' => 'Veyer ista pachina en a {{SITENAME}} normal', # Fuzzy
	'mobile-frontend-wml-continue' => 'Continar...',
	'mobile-frontend-wml-back' => 'Enta zaga ...',
	'mobile-frontend-view' => 'Versión ta mobils',
	'mobile-frontend-opt-in-explain' => 'Prebando a beta, tendrá acceso a caracteristicas experimentals, con o risgo de trobar problemas u errors.',
	'mobile-frontend-disable-images' => 'Desactivar imachens en a versión ta mobils',
	'mobile-frontend-enable-images' => 'Activar imachens en a versión ta mobils',
	'mobile-frontend-featured-article' => 'Articlo destacau de hue',
	'mobile-frontend-news-items' => 'Actualidat',
	'mobile-frontend-leave-feedback-notice' => "A suya retroalimentación nos aduya a amillorar a suya experiencia mobil en ista pachina. Se publicará (en chunto con o suyo nombre d'usuario, a versión d'o navegador y o sistema operativo que emplega) en a pachina &quot;\$1&quot;. Mire de emplegar una linia d'afer informativa, p. eix. \"Problemas de formato con tablas amplas\". Os suyos comentarios serán subchectos a la nuestra politica d'emplego.",
	'mobile-frontend-leave-feedback-subject' => 'Afer', # Fuzzy
	'mobile-frontend-leave-feedback-message' => 'Mensache', # Fuzzy
	'mobile-frontend-leave-feedback-submit' => 'Ninviar comentarios',
	'mobile-frontend-leave-feedback-link-text' => 'Retroalimentación sobre a extensión MobileFrontend',
	'mobile-frontend-leave-feedback' => 'Retroalimentación sobre o puesto web mobil',
	'mobile-frontend-leave-feedback-title' => "Informar-nos d'a tuya experiencia en en o puesto ta mobils.",
	'mobile-frontend-leave-feedback-page-title' => "Informar-nos d'a tuya experiencia en en o puesto ta mobils.",
	'mobile-frontend-leave-feedback-thanks' => 'Gracias por o suyo comentario!',
	'mobile-frontend-language' => 'Idioma', # Fuzzy
	'mobile-frontend-username' => "Nombre d'usuario:",
	'mobile-frontend-password' => "Clau d'acceso:",
	'mobile-frontend-login' => 'Encetar sesión',
	'mobile-frontend-placeholder' => 'Introduzca a suya busca...', # Fuzzy
	'mobile-frontend-dismiss-notification' => 'refusar ista notificación',
);

/** Angika (अङ्गिका)
 */
$messages['anp'] = array(
	'mobile-frontend-search-submit' => 'चलॊ',
	'mobile-frontend-home-button' => 'मुखपृष्ठ',
	'mobile-frontend-random-button' => 'बेतरतीब',
	'mobile-frontend-back-to-top-of-section' => 'एक अनुभाग पीछू जा',
	'mobile-frontend-show-button' => 'देखाबॊ',
	'mobile-frontend-hide-button' => 'छुपाबॊ',
	'mobile-frontend-regular-site' => 'इ पृष्ठ नियमित विकीपीडिया मॆ देखॊ', # Fuzzy
	'mobile-frontend-featured-article' => 'आजकॊ विशेष लेख',
);

/** Arabic (العربية)
 * @author AwamerT
 * @author Bassem JARKAS
 * @author Meno25
 * @author Mido
 * @author OsamaK
 * @author Samer
 * @author زكريا
 */
$messages['ar'] = array(
	'mobile-frontend-desc' => 'واجهة الجوال',
	'mobile-frontend-search-submit' => 'اذهب',
	'mobile-frontend-home-button' => 'الرئيسية',
	'mobile-frontend-logged-out' => 'غير مسجل الدخول',
	'mobile-frontend-logged-in-homepage-notification' => 'أهلاً بك يا $1!',
	'mobile-frontend-logged-in-toast-notification' => 'مسجل الدخول بحساب $1.',
	'mobile-frontend-sign-up-heading' => 'أنشئ حسابًا',
	'mobile-frontend-sign-in-heading' => 'ادخل',
	'mobile-frontend-sign-in-why' => 'إذا كان لديك حساب على {{SITENAME}} فيمكنك الدخول أدناه.',
	'mobile-frontend-sign-in-error-heading' => 'آخ',
	'mobile-frontend-settings-description' => 'خصّص تجربتك على جوالك عبر هذه الاعدادات.',
	'mobile-frontend-settings-beta' => 'بيتا',
	'mobile-frontend-settings-alpha' => 'ألفا',
	'mobile-frontend-settings-alpha-description' => 'وضع تجريبي غير مستقر وغير مأمون العواقب. احصل على المزيد من المزايا التجريبية ولكن مع المزيد من المشاكل.',
	'mobile-frontend-save-settings' => 'احفظ الإعدادات',
	'mobile-frontend-random-button' => 'عشوائي',
	'mobile-frontend-ajax-random-heading' => 'يجري تحميل المعرفة...',
	'mobile-frontend-ajax-random-quote' => 'يفترض أن يبدأ النمو الفكري عند الميلاد ويتوقف فقط عند الموت',
	'mobile-frontend-ajax-random-question' => 'هل قرأت هذه الصفحة؟',
	'mobile-frontend-ajax-random-yes' => 'نعم',
	'mobile-frontend-ajax-random-retry' => 'كرر المحاولة',
	'mobile-frontend-ajax-random-suggestions' => 'اقتراحات أخرى:',
	'mobile-frontend-back-to-top-of-section' => 'اقفز إلى القسم السابق',
	'mobile-frontend-close-section' => 'أغلق هذا القسم',
	'mobile-frontend-show-button' => 'اعرض',
	'mobile-frontend-hide-button' => 'أخفِ',
	'mobile-frontend-empty-homepage-text' => 'هذه الصفحة الرئيسية تحتاج للضبط. [//meta.wikimedia.org/wiki/Mobile_Projects/Mobile_Gateway#Mobile_homepage تعليمات حول كيفية ضبط موقع الجوال هنا]',
	'mobile-frontend-regular-site' => 'عرض سطح المكتب',
	'mobile-frontend-wml-continue' => 'استمر...',
	'mobile-frontend-wml-back' => 'ارجع...',
	'mobile-frontend-view' => 'نسخة الجوال',
	'mobile-frontend-view-desktop' => 'سطح المكتب',
	'mobile-frontend-view-mobile' => 'جوال',
	'mobile-frontend-opt-in-explain' => 'بانضمامك إلى نسخة بيتا ستصل إلى ميزات تجريبية وقد تصادف عللا ومشاكل.',
	'mobile-frontend-images-status' => 'الصور',
	'mobile-frontend-disable-images' => 'عطل الصور على موقع الجوال',
	'mobile-frontend-enable-images' => 'مكّن الصور على موقع الجوال',
	'mobile-frontend-missing-image' => 'صورة',
	'mobile-frontend-off' => 'معطلة',
	'mobile-frontend-on' => 'مفعلة',
	'mobile-frontend-footer-contributors-text' => 'كتب الصفحة [$1 مساهمون] مثلك',
	'mobile-frontend-featured-article' => 'مقالة اليوم المختارة',
	'mobile-frontend-news-items' => 'في الأخبار',
	'mobile-frontend-leave-feedback-notice' => 'ملاحظاتك تساعدنا على تحسين واجهة الجوال. سيتم نشرها علنا (مع اسم المستخدم وإصدار المستعرض ونظام التشغيل) على صفحة &quot;$1&quot;. الرجاء اختيار عناوين ذات صلة، مثل "مشاكل في تنسيق الجداول العريضة". ملاحظاتك خاضعة لشروط الاستخدام.',
	'mobile-frontend-leave-feedback-warning' => 'نرجو ألا تتضمن تعليقاتك معلومات شخصية ما لم توافق على نشرها علنًا.',
	'mobile-frontend-leave-feedback-subject' => 'العنوان:',
	'mobile-frontend-leave-feedback-message' => 'الرسالة:',
	'mobile-frontend-leave-feedback-submit' => 'أرسل الملاحظات',
	'mobile-frontend-leave-feedback-link-text' => 'ملاحظات على امتداد MobileFrontend',
	'mobile-frontend-leave-feedback' => 'ملاحظات على موقع الجوال',
	'mobile-frontend-leave-feedback-title' => 'أعطنا ملاحظاتك عن تجربة موقع الجوال',
	'mobile-frontend-leave-feedback-technical-problem-section-header' => 'مشكلة تقنية',
	'mobile-frontend-leave-feedback-general-section-header' => 'عام',
	'mobile-frontend-leave-feedback-article-feedback-section-header' => 'ملاحظات على المقالة',
	'mobile-frontend-leave-feedback-email-body' => 'من فضلك اشرح المشكلة التي تواجهها مع {{SITENAME}} فوق هذا السطر. نرجو أن تتنبه إلى أننا لا نقدر على الرد على جميع الرسائل التي تصلنا.',
	'mobile-frontend-leave-feedback-technical-link-text' => 'مشكلة تقنية',
	'mobile-frontend-leave-feedback-general-link-text' => 'ملاحظات عامة',
	'mobile-frontend-leave-feedback-article-personal-link-text' => 'بخصوص شخصي أو شخص أخر أو شركة أمثلها',
	'mobile-frontend-leave-feedback-article-factual-link-text' => 'بخصوص خطأ معرفي',
	'mobile-frontend-leave-feedback-article-other-link-text' => 'بخصوص مشكلة أخرى',
	'mobile-frontend-leave-feedback-form-subject-placeholder' => 'موضوع الرسالة',
	'mobile-frontend-leave-feedback-form-message-placeholder' => 'اكتب تعليقك هنا',
	'mobile-frontend-leave-feedback-page-title' => 'ملاحظات موقع المحمول',
	'mobile-frontend-feedback-page' => 'Project:تعليقات امتداد المحمول',
	'mobile-frontend-leave-feedback-special-title' => 'اتصل بنا',
	'mobile-frontend-feedback-no-subject' => '(غير معنون)',
	'mobile-frontend-feedback-no-subject-field' => 'من فضلك أدخل موضوعا',
	'mobile-frontend-feedback-no-message' => 'من فضلك أدخل رسالة هنا',
	'mobile-frontend-feedback-edit-summary' => '$1 - أرسلت تلقائيا عبر [[Special:MobileFeedback|أداة ملاحظات المحمول]]',
	'mobile-frontend-leave-feedback-thanks' => 'شكرا على إبداء ملاحظاتك!',
	'mobile-frontend-leave-feedback-post-error' => 'حدث خطأ أثناء معالجة رسالتك. من فضلك حاول مرة أخرى.',
	'mobile-frontend-language' => 'اللغة:',
	'mobile-frontend-language-article-heading' => 'اقرأ بلغة أخرى',
	'mobile-frontend-language-header' => 'هذه الصفحة متوفرة ب{{PLURAL:$1||لغة واحدة|لغتين|$1 لغات|$1 لغة}}',
	'mobile-frontend-language-footer' => '!ملاحظة: قد لا تكون هذه الصفحة مكتوبة بلغتك المفضلة. يمكنك مشاهدة اللغات التي تدعمها {{SITENAME}} بالنقر هنا.',
	'mobile-frontend-language-site-choose' => 'بحث اللغة',
	'mobile-frontend-username' => 'اسم المستخدم:',
	'mobile-frontend-password' => 'كلمة السر:',
	'mobile-frontend-username-placeholder' => 'اسم المستخدم',
	'mobile-frontend-password-placeholder' => 'كلمة السر',
	'mobile-frontend-login' => 'تسجيل الدخول',
	'mobile-frontend-last-modified-date' => 'آخر تعديل بتاريخ $1، $2',
	'mobile-frontend-last-modified-seconds' => 'آخر تعديل  منذ {{PLURAL:$1|أقل من ثانية واحدة|ثانية واحدة|ثانيتين|$1 ثواني|$1 ثانية}}',
	'mobile-frontend-last-modified-minutes' => 'آخر تعديل  منذ {{PLURAL:$1|أقل من دقيقة واحدة|دقيقة واحدة|دقيقتين|$1 دقائق|$1 دقيقة}}',
	'mobile-frontend-last-modified-hours' => 'آخر تعديل  منذ {{PLURAL:$1|أقل من ساعة واحدة|ساعة واحدة|ساعتين|$1 ساعات|$1 ساعة}}',
	'mobile-frontend-last-modified-days' => 'آخر تعديل  منذ {{PLURAL:$1|أقل من يوم واحد|يوم واحد|يومان|$1 أيام|$1 يوما|$1 يوم}}',
	'mobile-frontend-last-modified-months' => 'آخر تعديل  منذ {{PLURAL:$1|أقل من شهر واحد|شهر واحد|شهرين|$1 شهور|$1 شهرا|$1 شهر}}',
	'mobile-frontend-last-modified-years' => 'آخر تعديل  منذ {{PLURAL:$1|أقل من سنة واحدة|سنة واحدة|سنتين|$1 سنوات|$1 سنة}}',
	'mobile-frontend-account-create-submit' => 'أنشئ حسابًا',
	'mobile-frontend-password-confirm-placeholder' => 'أكد كلمة السر',
	'mobile-frontend-account-create-email-placeholder' => 'البريد الإلكتروني (اختياري)',
	'mobile-frontend-overlay-escape' => 'ارجع',
	'mobile-frontend-placeholder' => 'ابحث في {{SITENAME}}',
	'mobile-frontend-placeholder-beta' => 'ابحث في {{SITENAME}} (تجريبي)',
	'mobile-frontend-placeholder-alpha' => 'ابحث في {{SITENAME}} (ألفا)',
	'mobile-frontend-search-help' => 'اكتب عبارة البحث أعلاه وستظهر عناوين الصفحات المطابقة هنا.',
	'mobile-frontend-dismiss-notification' => 'أخفِ هذا الإخطار',
	'mobile-frontend-clear-search' => 'إفراغ',
	'mobile-frontend-privacy-link-text' => 'الخصوصية',
	'mobile-frontend-about-link-text' => 'عن',
	'mobile-frontend-footer-sitename' => '{{SITENAME}}',
	'mobile-frontend-footer-license-text' => 'المحتويات مُرخّصة برخصة [//ar.m.wikipedia.org/wiki/%D9%88%D9%8A%D9%83%D9%8A%D8%A8%D9%8A%D8%AF%D9%8A%D8%A7:%D9%86%D8%B5_%D8%B1%D8%AE%D8%B5%D8%A9_%D8%A7%D9%84%D9%85%D8%B4%D8%A7%D8%B9_%D8%A7%D9%84%D8%A5%D8%A8%D8%AF%D8%A7%D8%B9%D9%8A:_%D8%A7%D9%84%D9%86%D8%B3%D8%A8%D8%A9-%D8%A7%D9%84%D8%AA%D8%B1%D8%AE%D9%8A%D8%B5_%D8%A8%D8%A7%D9%84%D9%85%D8%AB%D9%84_3.0?useformat=mobile CC BY-SA 3.0]',
	'mobile-frontend-terms-use-text' => '[//wikimediafoundation.org/wiki/Terms_of_use?useformat=mobile شروط الاستخدام]',
	'mobile-frontend-footer-contact' => 'اتصل',
	'mobile-frontend-main-menu-button-tooltip' => 'افتح القائمة الرئيسية',
	'mobile-frontend-main-menu-page-title' => 'تصفح الموقع',
	'mobile-frontend-main-menu-featured' => 'مميزة',
	'mobile-frontend-main-menu-nearby' => 'قريب',
	'mobile-frontend-main-menu-login' => 'ادخل',
	'mobile-frontend-main-menu-logout' => 'اخرج',
	'mobile-frontend-main-menu-watchlist' => 'قائمة مراقبتي',
	'mobile-frontend-main-menu-settings' => 'الإعدادات',
	'mobile-frontend-main-menu-upload' => 'المرفوعات',
	'mobile-frontend-main-menu-settings-heading' => 'إعدادات موقع المحمول',
	'mobile-frontend-settings-site-header' => 'لغات {{SITENAME}}',
	'mobile-frontend-main-menu-contact' => 'اتصال',
	'mobile-frontend-main-menu-account-create' => 'أنشئ حسابا',
	'mobile-frontend-page-menu-contents' => 'محتويات',
	'mobile-frontend-page-menu-history' => 'التاريخ',
	'mobile-frontend-meta-data-issues-header' => 'قضايا',
	'mobile-frontend-meta-data-issues' => 'تعاني الصفحة من بعض المشاكل',
	'mobile-frontend-ajax-page-loading' => 'يُحمّل $1',
	'mobile-frontend-page-saving' => 'يجري حفظ $1',
	'mobile-frontend-nearby-title' => 'في المقربة',
	'mobile-frontend-nearby-distance-report' => 'على بعد $1 كم من موقعك الحالي',
	'mobile-frontend-nearby-lookup-error' => 'لم نتمكن من تحديد موقعك. إعادة المحاولة...',
	'mobile-frontend-nearby-noresults' => 'لا وجود لأية مقالات عن أماكن حولك. لماذا لا تكتب واحدة؟',
	'mobile-frontend-photo-upload-generic' => 'تبرع بصورة',
	'mobile-frontend-donate-image-title' => 'تبرع بصورة',
	'mobile-frontend-donate-image-heading' => 'مساهماتك الأخيرة',
	'mobile-frontend-donate-image-page-title' => 'ارفع',
	'mobile-frontend-listed-image-no-description' => 'لا يوجد وصف',
	'mobile-frontend-donate-photo-upload-success' => 'نجحت! يمكن الآن أن تُشَاهد صورتك على {{SITENAME}}!',
	'mobile-frontend-donate-photo-first-upload-success' => 'نجحت! شكرا على مساهمتك الأولى!',
	'mobile-frontend-watchlist-add' => 'تمت إضافة $1 إلى قائمة مراقبتك',
	'mobile-frontend-watchlist-removed' => 'تمت إزالة $1 من قائمة مراقبتك',
	'mobile-frontend-watchlist-view' => 'اعرض قائمة مراقبتك',
	'mobile-frontend-watchlist-more' => 'المزيد',
	'mobile-frontend-watchlist-cta' => 'الرجاء تسجيل الدخول أو إنشاء حساب لمراقبة هذه الصفحة.',
	'mobile-frontend-watchlist-cta-button-login' => 'ادخل',
	'mobile-frontend-watchlist-cta-button-signup' => 'أنشئ حسابًا',
	'mobile-frontend-watchlist-a-z' => 'الكل',
	'mobile-frontend-watchlist-feed' => 'المعدل',
	'mobile-frontend-watchlist-a-z-empty' => 'لا توجد لديك صفحات تراقبها',
	'mobile-frontend-watchlist-a-z-empty-howto-alt' => 'اضغط النجمة في أعلى الصفحة',
	'mobile-frontend-watchlist-feed-empty' => 'لا توجد صفحات تم تحديثها مؤخرا',
	'mobile-frontend-watchlist-back-home' => 'العودة إلى الصفحة الرئيسية',
	'mobile-frontend-changeslist-ip' => 'مستخدم مجهول',
	'mobile-frontend-changeslist-nocomment' => 'لا يوجد ملخص تحرير',
	'mobile-frontend-watchlist-filter-all' => 'الكل',
	'mobile-frontend-watchlist-filter-articles' => 'المقالات',
	'mobile-frontend-watchlist-filter-talk' => 'نقاش',
	'mobile-frontend-watchlist-filter-other' => 'أخرى',
	'mobile-frontend-watchlist-modified' => 'عُدلت $1',
	'mobile-frontend-diffview-404-title' => 'نسخة خاطئة',
	'mobile-frontend-diffview-404-desc' => 'معرف النسخة الذي طلبته غير موجود',
	'mobile-frontend-diffview-title' => 'تغييرات',
	'mobile-frontend-diffview-anonymous' => 'مستخدم مجهول',
	'mobile-frontend-table' => 'الجدول $1',
	'mobile-frontend-photo-upload' => 'أضف صورة لهذه الصفحة',
	'mobile-frontend-photo-article-edit-comment' => 'أُضيفت صورة للاستخدام في الصفحة',
	'mobile-frontend-photo-article-donate-comment' => 'صورة تم التبرع بها من الجوال',
	'mobile-frontend-photo-upload-comment' => 'أُضيفت صورة للصفحة',
	'mobile-frontend-photo-caption-placeholder' => 'أضف وصف (ضروري)',
	'mobile-frontend-image-loading' => 'يجري تحميل الصورة',
	'mobile-frontend-image-uploading-wait' => 'يجري رفع الصورة، يرجى الانتظار.',
	'mobile-frontend-image-uploading-long' => 'لا يزال رفع الصورة! شكرا لانتظارك.',
	'mobile-frontend-image-uploading-cancel' => '<a href="#">ألغِ</a> إن طال الانتظار.',
	'mobile-frontend-photo-upload-error' => 'خطأ، حاول مرة أخرى.',
	'mobile-frontend-photo-upload-success-article' => 'رائع! تظهر صورتك الأن على هذه الصفحة.',
	'mobile-frontend-photo-license' => 'ملاحظة: سيتم نشر جميع الصور التي تقوم بنشرها تحت [//http://ar.wikipedia.org/wiki/%D9%88%D9%8A%D9%83%D9%8A%D8%A8%D9%8A%D8%AF%D9%8A%D8%A7:CC-BY-SA  رخصة المشاع الإبداعي: النسبة-الترخيص بالمثل 3.0]', # Fuzzy
	'mobile-frontend-photo-submit' => 'إرسال',
	'mobile-frontend-photo-cancel' => 'إلغاء',
	'tag-mobile_edit' => 'تحرير من الجوال',
	'tag-mobile_edit-description' => 'تحرير بواسطة موقع الجوال',
	'mobile-frontend-drawer-cancel' => 'إلغاء',
);

/** Aramaic (ܐܪܡܝܐ)
 * @author Basharh
 */
$messages['arc'] = array(
	'mobile-frontend-search-submit' => 'ܙܠ',
	'mobile-frontend-home-button' => 'ܪܝܫܝܬܐ',
	'mobile-frontend-random-button' => 'ܚܘܝܚܐܝܬ',
	'mobile-frontend-hide-button' => 'ܛܫܝ',
	'mobile-frontend-regular-site' => 'ܚܘܝ ܐܝܟ ܚܫܘܒܬܐ',
	'mobile-frontend-view' => 'ܓܠܚܐ ܒܙܥܘܩܐ ܟܘܪܝܐ (ܡܫܢܝܢܐ)',
	'mobile-frontend-language' => 'ܠܫܢܐ:',
);

/** Moroccan Spoken Arabic (Maġribi)
 */
$messages['ary'] = array(
	'mobile-frontend-search-submit' => 'Sir',
	'mobile-frontend-home-button' => 'Sṫiqbal',
	'mobile-frontend-random-button' => 'Ĝel l-lah',
	'mobile-frontend-back-to-top-of-section' => 'Ṛjeĝ s-séksyon li men qbel',
	'mobile-frontend-show-button' => 'Werri',
	'mobile-frontend-hide-button' => 'Ĥebbi',
	'mobile-frontend-regular-site' => 'Qra had ṣ-ṣefḫa fe l-Wikipédya l-ĝadi', # Fuzzy
	'mobile-frontend-featured-article' => 'L-Maqal dyal lyoma',
);

/** Assamese (অসমীয়া)
 * @author Bishnu Saikia
 * @author Gitartha.bordoloi
 * @author Nilamdyuti
 */
$messages['as'] = array(
	'mobile-frontend-desc' => "মোবাইল ফ্ৰ'ণ্টএণ্ড",
	'mobile-frontend-search-submit' => 'যাওক',
	'mobile-frontend-home-button' => 'বেটুপাত',
	'mobile-frontend-logged-out' => 'প্ৰৱেশ কৰা নাই',
	'mobile-frontend-logged-in-homepage-notification' => 'আদৰিছোঁ, $1!',
	'mobile-frontend-logged-in-toast-notification' => '$1 নামেৰে প্ৰৱেশ কৰিলে',
	'mobile-frontend-sign-up-heading' => 'পঞ্জীয়ন কৰক',
	'mobile-frontend-sign-in-heading' => 'প্ৰৱেশ কৰক',
	'mobile-frontend-sign-in-why' => 'আপোনাৰ যদি এটা {{SITENAME}} একাউণ্ট আছে, তেনে আপুনি তলত সদস্যভূক্তি হ’ব পাৰিব।',
	'mobile-frontend-sign-in-error-heading' => 'অহ্‌...',
	'mobile-frontend-settings-description' => "এই মোবাইল ছেটিংসমূহৰ সৈতে আপোনাৰ মোবাইলৰ অভিজ্ঞতা কাষ্ট'মাইজ কৰক।",
	'mobile-frontend-settings-beta' => 'বিটা',
	'mobile-frontend-save-settings' => 'ছেটিংসমূহ সাঁচক',
	'mobile-frontend-random-button' => 'যিকোনো',
	'mobile-frontend-ajax-random-heading' => 'জ্ঞান অম্বেষণ কৰা হৈ আছে ...',
	'mobile-frontend-ajax-random-quote' => 'বৌদ্ধিক বিকাশ জন্মত আৰম্ভ হৈ, একমাত্ৰ মৃত্যুৰ পাছতহে শেষ হোৱা উচিত।',
	'mobile-frontend-ajax-random-quote-author' => 'এলবাৰ্ট আইনষ্টাইন',
	'mobile-frontend-ajax-random-question' => 'এই পৃষ্ঠা পঢ়ক?',
	'mobile-frontend-ajax-random-yes' => 'হয়',
	'mobile-frontend-ajax-random-retry' => 'পুনৰ চেষ্টা কৰক',
	'mobile-frontend-ajax-random-suggestions' => 'অন্যান্য উপদেশ:',
	'mobile-frontend-back-to-top-of-section' => 'এটা অনুচ্ছেদ ঘূৰি যাওক',
	'mobile-frontend-close-section' => 'এই অনুচ্ছেদ বন্ধ কৰক',
	'mobile-frontend-show-button' => 'দেখুৱাওক',
	'mobile-frontend-hide-button' => 'লুকুৱাওক',
	'mobile-frontend-empty-homepage-text' => 'এই ঘৰপৃষ্ঠা সংৰূপণ কৰাৰ প্ৰয়োজন। <a href="http://meta.wikimedia.org/wiki/Mobile_Projects/Mobile_Gateway#Mobile_homepage">এই ছাইট ম\'বাইলৰ বাবে সামৰ্থবান কৰিবলে নিৰ্দেশবোৰ </a>', # Fuzzy
	'mobile-frontend-regular-site' => 'ডেক্সটপ সংস্কৰণ',
	'mobile-frontend-wml-continue' => 'অব্যাহত ...',
	'mobile-frontend-wml-back' => 'ঘূৰি যাওক...',
	'mobile-frontend-view' => 'মোবাইল সংস্কৰণ',
	'mobile-frontend-view-desktop' => 'ডেক্সটপ',
	'mobile-frontend-view-mobile' => 'মোবাইল',
	'mobile-frontend-opt-in-explain' => "বিটা বৈশিষ্ট সক্ৰিয় কৰিলে আপুনি পৰীক্ষামূলক কামবোৰত অংশ ল'ব পাৰিব কিন্তু তাৰ বিনিময়ত বাগ্‌ বা অন্য সমস্যাও হ'ব পাৰে।",
	'mobile-frontend-images-status' => 'চিত্ৰসমূহ',
	'mobile-frontend-disable-images' => 'মোবাইল চাইটত ছবি নিষ্ক্ৰিয় কৰক',
	'mobile-frontend-enable-images' => 'মোবাইল চাইটত ছবি সক্ৰিয় কৰক',
	'mobile-frontend-missing-image' => 'চিত্ৰ',
	'mobile-frontend-off' => 'বন্ধ',
	'mobile-frontend-on' => 'আৰম্ভ',
	'mobile-frontend-footer-contributors-text' => 'আপোনাৰ দৰে [$1 অৱদানকাৰীয়ে] সৃষ্টি কৰা পৃষ্ঠা',
	'mobile-frontend-featured-article' => 'আজিৰ নিৰ্বাচিত প্ৰবন্ধ',
	'mobile-frontend-news-items' => 'খবৰৰ শীৰ্ষত',
	'mobile-frontend-leave-feedback-notice' => "আপোনাৰ প্ৰতিক্ৰিয়াই আমাক ম'বাইল চাইটৰ অভিজ্ঞতা উন্নত কৰাত সহায় কৰে। ইয়াক ৰাজহুৱাভাৱে পৃষ্ঠাখনত প'ষ্ট কৰা হ'ব (আপোনাৰ সদস্যনাম, ব্ৰাউজাৰ সংস্কৰণ আৰু অ'পাৰেটিং প্ৰণালীৰ সৈতে) &quot;\$1&quot;। অনুগ্ৰহ কৰি এটা তথ্যপূৰ্ণ বিষয়বস্তু বাছি ল'বলৈ চেষ্টা কৰক, যেনে- \"বহল টেবুলৰ ফৰ্মেটিং সমস্যা\"। আপোনাৰ প্ৰতিক্ৰিয়াই আমাৰ ব্যৱহাৰৰ চৰ্ত্ত মানি চলিব।",
	'mobile-frontend-leave-feedback-warning' => 'আপোনাৰ তথ্য ৰাজহুৱা কৰিবলৈ মানি নোলোৱা পৰ্যন্ত অনুগ্ৰহ কৰি ব্যক্তিগত তথ্য আপোনাৰ মন্তব্যসমূহত অন্তৰ্ভুক্ত নকৰিব।',
	'mobile-frontend-leave-feedback-subject' => 'বিষয়:',
	'mobile-frontend-leave-feedback-message' => 'বাৰ্তা:',
	'mobile-frontend-leave-feedback-submit' => 'প্ৰতিক্ৰিয়া জমা কৰক',
	'mobile-frontend-leave-feedback-link-text' => "মোবাইলফ'ণ্টএণ্ড এক্সটেন্‌ছন ফীডবেক",
	'mobile-frontend-leave-feedback' => 'মোবাইল চাইট ফীডবেক',
	'mobile-frontend-leave-feedback-title' => 'মোবাইল চাইট ফীডবেক',
	'mobile-frontend-leave-feedback-technical-problem-section-header' => 'কাৰিকৰী সমস্যা',
	'mobile-frontend-leave-feedback-general-section-header' => 'সাধাৰণ',
	'mobile-frontend-leave-feedback-article-feedback-section-header' => 'প্ৰবন্ধৰ প্ৰতিক্ৰিয়া',
	'mobile-frontend-leave-feedback-email-body' => 'অনুগ্ৰহ কৰি এই শাৰীৰ ওপৰত আপুনি {{SITENAME}}ত পোৱা সমস্যাৰ বিষয়ে চমুকৈ লিখক। অনুগ্ৰহ কৰি মন কৰিব যে, আমি পোৱা প্ৰত্যেক মেইলৰ উত্তৰ দিয়া সম্ভৱ নহয়।',
	'mobile-frontend-leave-feedback-technical-link-text' => 'কাৰিকৰী সমস্যা',
	'mobile-frontend-leave-feedback-general-link-text' => 'সাধাৰণ প্ৰতিক্ৰিয়া',
	'mobile-frontend-leave-feedback-article-personal-link-text' => 'কোনো ব্যক্তি, মই প্ৰতিনিধিত্ব কৰা কোম্পানী বা মোৰ বিষয়ে',
	'mobile-frontend-leave-feedback-article-factual-link-text' => 'এটা তথ্যগত ভুলৰ বিষয়ে',
	'mobile-frontend-leave-feedback-article-other-link-text' => 'আন এটা সমস্যাৰ বিষয়ে',
	'mobile-frontend-leave-feedback-form-subject-placeholder' => 'বাৰ্তাৰ বিষয়',
	'mobile-frontend-leave-feedback-form-message-placeholder' => 'আপোনাৰ মন্তব্য ইয়াত টাইপ কৰক',
	'mobile-frontend-leave-feedback-page-title' => 'মোবাইল চাইট ফীডবেক',
	'mobile-frontend-leave-feedback-special-title' => 'আমাৰ লগত যোগাযোগ কৰক',
	'mobile-frontend-feedback-no-subject' => '(কোনো বিষয় নাই)',
	'mobile-frontend-feedback-no-subject-field' => 'অনুগ্ৰহ কৰি এটা বিষয় লিখক',
	'mobile-frontend-feedback-no-message' => 'অনুগ্ৰহ কৰি ইয়াত এটা বাৰ্তা লিখক',
	'mobile-frontend-feedback-edit-summary' => "$1 - [[Special:MobileFeedback|ম'বাইল ফীডবেক সঁজুলি]] ব্যৱহাৰ কৰি স্বয়ংক্ৰিয়ভাৱে প'ষ্ট কৰা হ'ল",
	'mobile-frontend-leave-feedback-thanks' => 'আপোনাৰ প্ৰতিক্ৰিয়াৰ বাবে ধন্যবাদ!',
	'mobile-frontend-leave-feedback-post-error' => 'আপোনাৰ বাৰ্তা প্ৰচেছ কৰাত ত্ৰুটী হৈছে। অনুগ্ৰহ কৰি অলপ পিছত চেষ্টা কৰক।',
	'mobile-frontend-language' => 'ভাষাসমূহ:',
	'mobile-frontend-language-article-heading' => 'অন্য ভাষাত পঢ়ক',
	'mobile-frontend-language-header' => 'এই পৃষ্ঠাটো $1 {{PLURAL:$1|ভাষাত|টা ভাষাত}} উপলব্ধ',
	'mobile-frontend-language-footer' => 'টোকা: এই পৃষ্ঠাটো সম্ভৱত আপোনাৰ পছন্দৰ ভাষাত লিখা হোৱা নাই। সমৰ্থিত ভাষাসমূহৰ সন্ধান {{SITENAME}} ইয়াত ক্লিক কৰিলে পাব।',
	'mobile-frontend-language-site-choose' => 'ভাষা অনুসন্ধান:',
	'mobile-frontend-username' => 'সদস্যনাম:',
	'mobile-frontend-password' => 'গুপ্তশব্দ:',
	'mobile-frontend-username-placeholder' => 'সদস্যনাম',
	'mobile-frontend-password-placeholder' => 'গুপ্তশব্দ',
	'mobile-frontend-login' => 'প্ৰৱেশ',
	'mobile-frontend-account-create-submit' => 'পঞ্জীয়ন কৰক',
	'mobile-frontend-password-confirm-placeholder' => 'গুপ্তশব্দ নিশ্চিত কৰক',
	'mobile-frontend-account-create-email-placeholder' => 'ই-মেইল ঠিকনা (বৈকল্পিক)',
	'mobile-frontend-account-create-captcha-placeholder' => 'ওপৰত লিখা পাঠ্য লিখক',
	'mobile-frontend-overlay-escape' => 'পাছলৈ যাওক',
	'mobile-frontend-placeholder' => 'সন্ধান কৰক {{SITENAME}}',
	'mobile-frontend-placeholder-beta' => 'সন্ধান কৰক {{SITENAME}} (বেটা)',
	'mobile-frontend-placeholder-alpha' => 'অনুসন্ধান {{SITENAME}} (ড্ৰেগন মোড)',
	'mobile-frontend-search-help' => 'অনুসন্ধান বিষয় ওপৰত টাইপ কৰক আৰু মিলা পৃষ্ঠাৰ শিৰোনামবোৰ ইয়াত দেখা পাব।',
	'mobile-frontend-dismiss-notification' => 'এই জাননী বাতিল কৰক',
	'mobile-frontend-clear-search' => 'পৰিস্কাৰ',
	'mobile-frontend-privacy-link-text' => 'গোপনীয়তা',
	'mobile-frontend-about-link-text' => 'পৰিচিতি',
	'mobile-frontend-footer-sitename' => '{{SITENAME}}',
	'mobile-frontend-footer-contact' => 'যোগাযোগ',
	'mobile-frontend-search-noresults' => "কোনো প্ৰবন্ধ আপোনাৰ অনুসন্ধানৰ লগত নিমিলিল। আপোনাৰ অনুসন্ধান সলনি কৰক বা কীব'ৰ্ডৰ অনুসন্ধান (Ctrl+F) বুটাম টিপি ভিতৰৰ পৃষ্ঠাত সন্ধান কৰক।",
	'mobile-frontend-main-menu-button-tooltip' => 'মূল মেনু খোলক',
	'mobile-frontend-main-menu-page-title' => 'ছাইট পৰিভ্ৰমন',
	'mobile-frontend-main-menu-featured' => 'নিৰ্বাচিত',
	'mobile-frontend-main-menu-nearby' => 'কাষৰীয়া',
	'mobile-frontend-main-menu-login' => 'প্ৰৱেশ',
	'mobile-frontend-main-menu-logout' => 'প্ৰস্থান',
	'mobile-frontend-main-menu-watchlist' => 'লক্ষ্য তালিকা',
	'mobile-frontend-main-menu-settings' => 'ছেটিং',
	'mobile-frontend-main-menu-settings-heading' => 'ম’বাইল ছাইট ছেটিং',
	'mobile-frontend-settings-site-header' => '{{SITENAME}} ভাষাসমূহ',
	'mobile-frontend-settings-site-description' => '{{SITENAME}} $1 {{PLURAL:$1|ভাষা|ভাষাসমূহত}} উপলদ্ধ, সকলো সংস্কৰণ তলত দিয়া হৈছে',
	'mobile-frontend-main-menu-contact' => 'যোগাযোগ',
	'mobile-frontend-main-menu-account-create' => 'একাউণ্ট সৃষ্টি কৰক',
	'mobile-frontend-page-menu-contents' => 'সূচীসমূহ',
	'mobile-frontend-page-menu-history' => 'ইতিহাস',
	'mobile-frontend-meta-data-issues-header' => 'বিষয়সমূহ',
	'mobile-frontend-meta-data-issues' => 'এই পৃষ্ঠাত কিছুমান অমিমাংসিত বিষয় আছে',
	'mobile-frontend-ajax-page-loading' => '$1 ল’ড হৈ আছে',
	'mobile-frontend-page-saving' => '$1 সংৰক্ষন কৰা হৈ আছে',
	'mobile-frontend-ajax-page-error' => 'অহ‌...! তাত কোনোধৰনৰ সমস্যা হৈছে। অনুগ্ৰহ কৰি আপোনাৰ ব্ৰাউজাৰ সতেজ কৰি পুনৰ প্ৰয়াস কৰক।',
	'mobile-frontend-watchlist-add' => '$1 আপোনাৰ লক্ষ্য তালিকাত যোগ দিয়া হ’ল',
	'mobile-frontend-watchlist-removed' => '$1 আপোনাৰ লক্ষ্য তালিকাৰ পৰা বিলোপ কৰা হ’ল',
	'mobile-frontend-watchlist-view' => 'আপোনাৰ লক্ষ্য তালিকা চাওক',
	'mobile-frontend-changeslist-ip' => 'বেনামী ব্যৱহাৰকাৰী',
	'mobile-frontend-changeslist-nocomment' => 'সম্পাদনা সাৰংশ নাই',
	'mobile-frontend-watchlist-filter-all' => 'সকলো',
	'mobile-frontend-watchlist-filter-articles' => 'প্ৰবন্ধসমূহ',
	'mobile-frontend-watchlist-filter-talk' => 'আলোচনা',
	'mobile-frontend-watchlist-filter-other' => 'অন্যান্য',
	'mobile-frontend-diffview-title' => '$1লৈ সলনি কৰক', # Fuzzy
	'mobile-frontend-diffview-editcount' => '$1 {{PLURAL:$1|সম্পাদনা|টা সম্পাদনা}}',
	'mobile-frontend-diffview-anonymous' => 'বেনামী ব্যৱহাৰকাৰী',
	'mobile-frontend-diffview-bytesadded' => '$1 {{PLURAL:$1|বাইট}} যোগ দিয়া হ’ল',
	'mobile-frontend-diffview-bytesremoved' => '$1 {{PLURAL:$1|বাইট}} বিলোপ কৰা হ’ল',
	'mobile-frontend-table' => 'টেবুল $1',
	'mobile-frontend-saving-exit-page' => 'পৃষ্ঠাটো সংৰক্ষণ কৰা হৈ আছে। আপুনি যদি এতিয়াই পৃষ্ঠাটো ত্যাগ কৰে তেনে আপুনি কৰা সম্পাদনাবোৰ সংৰক্ষণ নহ’ব। তথাপিটো আপুনি পৃষ্ঠাৰ পৰা আতৰি যাব খুজিছে নেকি?',
	'mobile-frontend-photo-upload' => 'এই পৃষ্ঠাত প্ৰথম চিত্ৰখন যোগ দিয়ক', # Fuzzy
	'mobile-frontend-photo-article-edit-comment' => 'এই পৃষ্ঠাত ব্যৱহাৰৰ বাবে চিত্ৰ যোগ দিয়া হ’ল',
	'mobile-frontend-photo-upload-comment' => 'পৃষ্ঠাত চিত্ৰ যোগ কৰা হ’ল',
	'mobile-frontend-photo-caption-placeholder' => 'চিত্ৰৰ বাবে এটা শিৰোনাম যোগ দিয়ক', # Fuzzy
	'mobile-frontend-image-loading' => 'চিত্ৰ ল’ড হৈ আছে',
	'mobile-frontend-image-uploading' => 'চিত্ৰ আপল’ড হৈ আছে', # Fuzzy
	'mobile-frontend-photo-upload-error' => 'চিত্ৰ আপল’ড কৰাত কিছু সমস্যা হৈছে। অনুগ্ৰহ কৰি অন্য চিত্ৰ আপ’লড কৰাৰ প্ৰয়াস কৰক।', # Fuzzy
	'mobile-frontend-photo-license' => 'টোকা: আপুনি প্ৰকাশ কৰা সকলোবোৰ চিত্ৰ  [//en.wikipedia.org/wiki/Wikipedia:Text_of_Creative_Commons_Attribution-ShareAlike_3.0_Unported_License CC BY-SA 3.0 license] অধীনত প্ৰকাশ কৰা হ’ব।', # Fuzzy
);

/** Asturian (asturianu)
 * @author Xuacu
 */
$messages['ast'] = array(
	'mobile-frontend-desc' => 'Interfaz pa móviles',
	'mobile-frontend-search-submit' => 'Dir',
	'mobile-frontend-home-button' => 'Entamu',
	'mobile-frontend-logged-out' => 'Non identificáu',
	'mobile-frontend-logged-in-homepage-notification' => '¡Bienllegáu, $1!',
	'mobile-frontend-logged-in-toast-notification' => 'Aniciasti sesión como $1.',
	'mobile-frontend-sign-up-heading' => "Date d'alta",
	'mobile-frontend-sign-in-heading' => 'Entrar',
	'mobile-frontend-sign-in-why' => 'Si tienes una cuenta en {{SITENAME}}, pues entrar más abaxo.',
	'mobile-frontend-sign-in-error-heading' => '¡Coime!',
	'mobile-frontend-settings-description' => 'Personaliza la to esperiencia nel preséu móvil con estes configuraciones específiques pa móvil.',
	'mobile-frontend-settings-beta' => 'Beta',
	'mobile-frontend-settings-alpha' => 'Mou «[//en.wikipedia.org/wiki/Here_be_dragons Equí hai cuélebres]»',
	'mobile-frontend-settings-alpha-description' => "Entra nun territoriu móvil peligrosu ya inesploráu. Consigui carauterístiques inda más esperimentales, pero con más riesgu d'errores.",
	'mobile-frontend-save-settings' => 'Guardar la configuración',
	'mobile-frontend-random-button' => 'Al debalu',
	'mobile-frontend-ajax-random-heading' => 'Llocalizando el conocimientu...',
	'mobile-frontend-ajax-random-quote' => 'El crecimientu intelectual tendría de comenzar col nacimientu y acabar sólo cola muerte',
	'mobile-frontend-ajax-random-question' => '¿Lleer esta páxina?',
	'mobile-frontend-ajax-random-yes' => 'Sí',
	'mobile-frontend-ajax-random-retry' => 'Volver a intentalo',
	'mobile-frontend-ajax-random-suggestions' => 'Otres suxerencies:',
	'mobile-frontend-back-to-top-of-section' => 'Tornar atrás una seición',
	'mobile-frontend-close-section' => 'Zarrar esta sección',
	'mobile-frontend-show-button' => 'Amosar',
	'mobile-frontend-hide-button' => 'Anubrir',
	'mobile-frontend-empty-homepage-text' => "Esta páxina d'aniciu ta por configurar. [//meta.wikimedia.org/wiki/Mobile_Projects/Mobile_Gateway#Mobile_homepage\">Instrucciones p'activar esti sitiu pa móvil]",
	'mobile-frontend-regular-site' => "Vista d'escritoriu",
	'mobile-frontend-wml-continue' => 'Continuar...',
	'mobile-frontend-wml-back' => 'Volver...',
	'mobile-frontend-view' => 'Vista pa móvil',
	'mobile-frontend-view-desktop' => 'Escritoriu',
	'mobile-frontend-view-mobile' => 'Móvil',
	'mobile-frontend-opt-in-explain' => "Al xunite a la versión beta tendrás accesu a carauterístiques esperimentales, pero col riesgu d'atopar fallos y problemes.",
	'mobile-frontend-images-status' => 'Imaxes',
	'mobile-frontend-disable-images' => 'Desactivar les imaxes nel sitiu pa móvil',
	'mobile-frontend-enable-images' => 'Activar les imaxes nel sitiu pa móvil',
	'mobile-frontend-missing-image' => 'Imaxe',
	'mobile-frontend-off' => 'DESACTIVAES',
	'mobile-frontend-on' => 'ACTIVAES',
	'mobile-frontend-footer-contributors-text' => 'Páxina fecha por [$1 collaboradores] como tu',
	'mobile-frontend-featured-article' => 'Artículu destacáu güei',
	'mobile-frontend-news-items' => 'Actualidá',
	'mobile-frontend-leave-feedback-notice' => "Los tos comentarios nos ayuden a meyorar la to esperiencia na versión pa móvil. Los mesmos s'asoleyen de mou públicu (xunto col to nome d'usuariu, versión de restolador y sistema operativu) na páxina &quot;\$1&quot;. Procura escoyer una llinia d'asuntu informativa; p. ex., \"Problemes de formatu con tables anches\". Los tos comentarios tan suxetos a los nuesos términos d'usu.",
	'mobile-frontend-leave-feedback-warning' => "Si nun tas d'alcuerdu con facer pública la to información, por favor, nun incluyas datos personales nos tos comentarios.",
	'mobile-frontend-leave-feedback-subject' => 'Asuntu:',
	'mobile-frontend-leave-feedback-message' => 'Mensaxe:',
	'mobile-frontend-leave-feedback-submit' => 'Unviar comentarios',
	'mobile-frontend-leave-feedback-link-text' => 'Comentarios a la estensión MobileFrontend',
	'mobile-frontend-leave-feedback' => 'Comentarios sobre la versión pa móvil',
	'mobile-frontend-leave-feedback-title' => 'Comentarios sobre la versión pa móvil',
	'mobile-frontend-leave-feedback-technical-problem-section-header' => 'Problema técnicu',
	'mobile-frontend-leave-feedback-general-section-header' => 'Xeneral',
	'mobile-frontend-leave-feedback-article-feedback-section-header' => "Comentarios sobro l'artículu",
	'mobile-frontend-leave-feedback-email-body' => "Describi la clase problema que tienes con {{SITENAME}} encima d'esta llinia. Por favor, ten en cuenta que nun podemos responder a cada mensaxe que recibimos.",
	'mobile-frontend-leave-feedback-technical-link-text' => 'Problema técnicu',
	'mobile-frontend-leave-feedback-general-link-text' => 'Comentarios xenerales',
	'mobile-frontend-leave-feedback-article-personal-link-text' => 'Tocante a min, una persona, o una empresa a la que represento',
	'mobile-frontend-leave-feedback-article-factual-link-text' => 'Tocante a un error nos fechos',
	'mobile-frontend-leave-feedback-article-other-link-text' => 'Tocante a otru problema',
	'mobile-frontend-leave-feedback-form-subject-placeholder' => 'Asuntu del mensaxe',
	'mobile-frontend-leave-feedback-form-message-placeholder' => 'Escribi equí el to comentariu',
	'mobile-frontend-leave-feedback-page-title' => 'Comentarios sobre la versión pa móvil',
	'mobile-frontend-leave-feedback-special-title' => 'Comunica con nós',
	'mobile-frontend-feedback-no-subject' => '(ensin asuntu)',
	'mobile-frontend-feedback-no-subject-field' => 'Por favor, escribi un asuntu',
	'mobile-frontend-feedback-no-message' => 'Escribi un mensaxe equí',
	'mobile-frontend-feedback-edit-summary' => "$1 - espublizáu automaticamente usando la [[Special:MobileFeedback|ferramienta de comentarios sobro'l sitiu pa móvil]]",
	'mobile-frontend-leave-feedback-thanks' => '¡Gracies polos tos comentarios!',
	'mobile-frontend-leave-feedback-post-error' => 'Hebo un fallu al procesar el to mensaxe. Torna a intentalo más sero.',
	'mobile-frontend-language' => 'Llingua:',
	'mobile-frontend-language-article-heading' => "Lleer n'otra llingua",
	'mobile-frontend-language-header' => 'Esta páxina ta disponible en $1 {{PLURAL:$1|llingua|llingües}}',
	'mobile-frontend-language-variant-header' => 'Escoyer la variante {{#language:{{CONTENTLANG}}}}',
	'mobile-frontend-language-footer' => 'Nota: Esta páxina pue que nun tea na to llingua preferida. Pues ver les llingües que sofita {{SITENAME}} calcando equí.',
	'mobile-frontend-language-site-choose' => 'Guetar llingua',
	'mobile-frontend-username' => "Nome d'usuariu:",
	'mobile-frontend-password' => 'Contraseña:',
	'mobile-frontend-username-placeholder' => "Nome d'usuariu",
	'mobile-frontend-password-placeholder' => 'Contraseña',
	'mobile-frontend-login' => 'Entrar',
	'mobile-frontend-last-modified-date' => 'Últimu cambéu el $1 a les $2',
	'mobile-frontend-last-modified-seconds' => 'Últimu cambéu hai {{PLURAL:$1|$1 segundu|$1 segundos}}',
	'mobile-frontend-last-modified-minutes' => 'Últimu cambéu hai {{PLURAL:$1|$1 minutu|$1 minutos}}',
	'mobile-frontend-last-modified-hours' => 'Últimu cambéu hai {{PLURAL:$1|$1 hora|$1 hores}}',
	'mobile-frontend-last-modified-days' => 'Últimu cambéu hai {{PLURAL:$1|$1 día|$1 díes}}',
	'mobile-frontend-last-modified-months' => 'Últimu cambéu hai {{PLURAL:$1|$1 mes|$1 meses}}',
	'mobile-frontend-last-modified-years' => 'Últimu cambéu hai {{PLURAL:$1|$1 añu|$1 años}}',
	'mobile-frontend-account-create-submit' => "Date d'alta",
	'mobile-frontend-password-confirm-placeholder' => 'Confirmar la contraseña',
	'mobile-frontend-account-create-email-placeholder' => 'Direición de corréu electrónicu (opcional)',
	'mobile-frontend-account-create-captcha-placeholder' => "Escriba'l testu de seguridá",
	'mobile-frontend-overlay-escape' => 'Volver',
	'mobile-frontend-placeholder' => 'Guetar en {{SITENAME}}',
	'mobile-frontend-placeholder-beta' => 'Gueta en {{SITENAME}} (Beta)',
	'mobile-frontend-placeholder-alpha' => 'Guetar en {{SITENAME}} (mou Cuélebre)',
	'mobile-frontend-search-help' => "Escribi arriba'l términu a guetar y los títulos de les páxines que casen apaecerán equí.",
	'mobile-frontend-dismiss-notification' => 'anubrir esta notificación',
	'mobile-frontend-clear-search' => 'Llimpiar',
	'mobile-frontend-privacy-link-text' => 'Intimidá',
	'mobile-frontend-about-link-text' => 'Tocante a',
	'mobile-frontend-footer-sitename' => '{{SITENAME}}',
	'mobile-frontend-footer-license-text' => 'Conteníu disponible baxo llicencia [//en.m.wikipedia.org/wiki/Wikipedia:Text_of_Creative_Commons_Attribution-ShareAlike_3.0_Unported_License?useformat=mobile" CC BY-SA 3.0]',
	'mobile-frontend-terms-use-text' => '[//wikimediafoundation.org/wiki/Terms_of_use?useformat=mobile" Condiciones d\'usu]',
	'mobile-frontend-footer-contact' => 'Contautu',
	'mobile-frontend-search-noresults' => 'Dengún títulu de páxina casa cola to gueta. Camuda la gueta o calca nel botón de gueta del tecláu pa guetar dientro de les páxines.',
	'mobile-frontend-main-menu-button-tooltip' => 'Abrir el menú principal',
	'mobile-frontend-main-menu-page-title' => 'Navegación del sitiu',
	'mobile-frontend-main-menu-featured' => 'Destacada',
	'mobile-frontend-main-menu-nearby' => 'Cercanu',
	'mobile-frontend-main-menu-login' => 'Identificase',
	'mobile-frontend-main-menu-logout' => 'Colar',
	'mobile-frontend-main-menu-watchlist' => 'Llista de vixilancia',
	'mobile-frontend-main-menu-settings' => 'Configuración',
	'mobile-frontend-main-menu-upload' => 'Xubíes',
	'mobile-frontend-main-menu-settings-heading' => 'Configuración del sitiu móvil',
	'mobile-frontend-settings-site-header' => 'Llingües de {{SITENAME}}',
	'mobile-frontend-settings-site-description' => '{{SITENAME}} ta disponible en $1 {{PLURAL:$1|llingua|llingües}}. Toles versiones disponibles apaecen abaxo',
	'mobile-frontend-main-menu-contact' => 'Contautu',
	'mobile-frontend-main-menu-account-create' => 'Crear una cuenta',
	'mobile-frontend-page-menu-contents' => 'conteníu',
	'mobile-frontend-page-menu-history' => 'Historial',
	'mobile-frontend-meta-data-issues-header' => 'Incidencies',
	'mobile-frontend-meta-data-issues' => 'Esta páxina tien dellos problemes',
	'mobile-frontend-ajax-page-loading' => 'Cargando $1',
	'mobile-frontend-page-saving' => 'Guardando $1',
	'mobile-frontend-ajax-page-error' => '¡Coime! Daqué nun funcionó. Prueba a recargar la ventana del navegador.',
	'mobile-frontend-nearby-title' => 'Cercanu',
	'mobile-frontend-nearby-loading' => 'Cargando temes cercanos al so allugamientu actual',
	'mobile-frontend-nearby-requirements' => "Esta páxina necesita JavaScript y un navegador que reconoza l'allugamientu.",
	'mobile-frontend-nearby-distance-report' => 'A $1km del so allugamientu actual',
	'mobile-frontend-nearby-lookup-error' => 'Nun se-y pudo llocalizar. Probando otra vuelta...',
	'mobile-frontend-nearby-noresults' => 'Ta nel mediu de nenyuri y nun pudimos alcontrar tema dalu. ¿Qué tal escribir unu?',
	'mobile-frontend-nearby-refresh' => 'Alcontramos un llugar más axustáu pa vusté. Calque equí pa recargar la llista de páxines cercanes',
	'mobile-frontend-nearby-error' => 'Hebo un fallu inesperáu al intentar atopar páxines cercanes',
	'mobile-frontend-donate-image-login' => "Tien d'aniciar sesión pa ver les sos xubíes.",
	'mobile-frontend-photo-upload-generic' => 'Donar una imaxe',
	'mobile-frontend-donate-image-title' => 'Donar una imaxe',
	'mobile-frontend-donate-image-summary' => "Les fotografíes dan vida a les páxines de {{SITENAME}}.
Hai munches páxines que nun tienen semeyes por aciu d'una bultable falta de fotografíes con llicencia llibre.
Ayude a dar vida a estes páxines regalando les imaxes quiera dar y que puedan ser útiles pa la comunidá d'editores de {{SITENAME}}.",
	'mobile-frontend-donate-image-page-title' => 'Xubir',
	'mobile-frontend-donate-image-anon' => "Fai falta tener una [[Special:UserLogin|cuenta d'usuariu]] pa entrar na páxina de xubíes",
	'mobile-frontend-listed-image-no-description' => 'Ensin descripción',
	'mobile-frontend-watchlist-add' => "S'amestó $1 a la to llista de siguimientu",
	'mobile-frontend-watchlist-removed' => 'Se desanició $1 de la to llista de siguimientu',
	'mobile-frontend-watchlist-view' => 'Ver la to llista de siguimientu',
	'mobile-frontend-watchlist-more' => 'más',
	'mobile-frontend-watchlist-cta-button-login' => 'Entrar',
	'mobile-frontend-watchlist-cta-button-signup' => "Date d'alta",
	'mobile-frontend-watchlist-a-z' => 'Toos',
	'mobile-frontend-watchlist-feed' => 'Camudaos',
	'mobile-frontend-watchlist-back-home' => 'Volver al aniciu',
	'mobile-frontend-changeslist-ip' => 'Usuariu anónimu',
	'mobile-frontend-changeslist-nocomment' => "ensin resume d'edición",
	'mobile-frontend-watchlist-filter-all' => 'Toes',
	'mobile-frontend-watchlist-filter-articles' => 'Artículos',
	'mobile-frontend-watchlist-filter-talk' => 'Alderique',
	'mobile-frontend-watchlist-filter-other' => 'Otres',
	'mobile-frontend-watchlist-modified' => 'Camudose $1',
	'mobile-frontend-diffview-404-title' => 'Revisión incorreuta',
	'mobile-frontend-diffview-404-desc' => 'La id de la revisión solicitada nun esiste',
	'mobile-frontend-diffview-title' => 'Cambios',
	'mobile-frontend-diffview-editcount' => '$1 {{PLURAL:$1|edición|ediciones}}',
	'mobile-frontend-diffview-anonymous' => 'Usuariu anónimu',
	'mobile-frontend-diffview-bytesadded' => '$1 {{PLURAL:$1|byte amestáu|bytes amestaos}}',
	'mobile-frontend-diffview-bytesremoved' => '$1 {{PLURAL:$1|byte desaniciáu|bytes desaniciaos}}',
	'mobile-frontend-diffview-explained' => "S'amestaron (+) y desaniciaron (-) les siguientes llinies:",
	'mobile-frontend-table' => 'Tabla $1',
	'mobile-frontend-saving-exit-page' => 'La to collaboración ta guardandose entá. Si coles se perderán les tos collaboraciones. ¿Seguro que quies colar?',
	'mobile-frontend-photo-upload' => 'Amestar una foto a esti artículu',
	'mobile-frontend-photo-article-edit-comment' => "S'amestó una foto para usar na páxina",
	'mobile-frontend-photo-article-donate-comment' => 'Imaxe donada dende un móvil',
	'mobile-frontend-photo-upload-comment' => 'Foto amestada a la páxina',
	'mobile-frontend-photo-caption-placeholder' => 'Amestar una descripción (requerío)',
	'mobile-frontend-image-loading' => 'Cargando la imaxe',
	'mobile-frontend-image-uploading-wait' => 'Xubiendo la imaxe, espere por favor.',
	'mobile-frontend-image-uploading-long' => '¡Inda ta xubiendo la imaxe! Gracies pola paciencia.',
	'mobile-frontend-image-uploading-cancel' => '<a href="#">Encaboxar</a> si ta tardando demasiao.',
	'mobile-frontend-photo-upload-error' => 'Error, vuelva a probar.',
	'mobile-frontend-photo-upload-success-article' => '¡Correuto! La so imaxe yá ye visible nesta páxina.',
	'mobile-frontend-photo-license' => 'Al calcar "Unviar", ta aceutando les [//wikimediafoundation.org/wiki/Terms_of_use Condiciones d\'usu] y ta d\'alcuerdu con distribuir la foto baxo la [//creativecommons.org/licenses/by-sa/3.0/ Llicencia Creative Commons Reconocimientu-CompartirIgual 3.0].',
	'mobile-frontend-photo-submit' => 'Unviar',
	'mobile-frontend-photo-cancel' => 'Encaboxar',
	'mobile-frontend-photo-upload-user-count' => '{{PLURAL:$1|1 xuba|$1 xubes}}', # Fuzzy
	'mobile-frontend-photo-upload-user-count-over-limit' => '+500 xubes',
	'tag-mobile_edit' => 'Edición de móvil',
	'tag-mobile_edit-description' => "Edición fecha dende'l sitiu pa móviles",
	'mobile-frontend-drawer-cancel' => 'Encaboxar',
);

/** Azerbaijani (azərbaycanca)
 * @author Cekli829
 * @author Vugar 1981
 */
$messages['az'] = array(
	'mobile-frontend-search-submit' => 'Get',
	'mobile-frontend-home-button' => 'Ana səhifə',
	'mobile-frontend-random-button' => 'Təsadüfi',
	'mobile-frontend-back-to-top-of-section' => 'Bir bölüm geriyə dön',
	'mobile-frontend-show-button' => 'Göstər',
	'mobile-frontend-hide-button' => 'Gizlət',
	'mobile-frontend-regular-site' => 'Bu səhifəni normal {{SITENAME}} görüntülə', # Fuzzy
	'mobile-frontend-wml-continue' => 'Davam et ...',
	'mobile-frontend-wml-back' => 'Geri ...',
	'mobile-frontend-view' => 'Mobil görüntü',
	'mobile-frontend-featured-article' => 'Günün seçilmiş məqaləsi',
	'mobile-frontend-leave-feedback-subject' => 'Mövzu', # Fuzzy
	'mobile-frontend-leave-feedback-message' => 'Mesaj', # Fuzzy
	'mobile-frontend-leave-feedback-general-section-header' => 'Ümumi',
	'mobile-frontend-language' => 'Dil', # Fuzzy
	'mobile-frontend-username' => 'İstifadəçi adı:',
	'mobile-frontend-password' => 'Parol:',
	'mobile-frontend-login' => 'Daxil ol',
	'mobile-frontend-clear-search' => 'Təmizlə',
	'mobile-frontend-about-link-text' => 'Haqqında',
);

/** South Azerbaijani (تورکجه)
 * @author Amir a57
 * @author Mousa
 */
$messages['azb'] = array(
	'mobile-frontend-search-submit' => 'گئت',
	'mobile-frontend-home-button' => 'ائو',
	'mobile-frontend-logged-out' => 'داخیل اولمامیسینیز',
	'mobile-frontend-sign-in-heading' => 'گیریش',
	'mobile-frontend-settings-beta' => 'بتا',
	'mobile-frontend-save-settings' => 'تنظیملری قئید ائت',
	'mobile-frontend-random-button' => 'تصادفی',
	'mobile-frontend-ajax-random-question' => 'صحیفه‌نی اوخو',
	'mobile-frontend-ajax-random-yes' => 'بلی',
	'mobile-frontend-ajax-random-retry' => 'یئنی دن جهد ائد',
	'mobile-frontend-back-to-top-of-section' => 'بیر بؤلوم گئرییه دؤن',
	'mobile-frontend-close-section' => 'بو بولومی باغلا',
	'mobile-frontend-show-button' => 'گؤستر',
	'mobile-frontend-hide-button' => 'گیزلت',
	'mobile-frontend-regular-site' => 'دئسک تاپی گوستر',
	'mobile-frontend-wml-continue' => 'داوام ائت',
	'mobile-frontend-wml-back' => 'گئیت',
	'mobile-frontend-view' => 'موبایل گؤرونتو',
	'mobile-frontend-view-mobile' => 'موبایل',
	'mobile-frontend-images-status' => 'شکیل‌لر',
	'mobile-frontend-missing-image' => 'شکیل',
	'mobile-frontend-off' => 'سون دور (گئچیت)',
	'mobile-frontend-on' => 'آلیشدیر (یاندیر)',
	'mobile-frontend-featured-article' => 'گونون سئچیلمیش مقاله‌سی',
	'mobile-frontend-news-items' => 'خبرلرده',
	'mobile-frontend-leave-feedback-subject' => 'قونو:',
	'mobile-frontend-leave-feedback-message' => 'مئساژ',
	'mobile-frontend-leave-feedback-general-section-header' => 'عمومی',
	'mobile-frontend-language' => 'دیل:',
	'mobile-frontend-language-site-choose' => 'دیل آختاریشی',
	'mobile-frontend-username' => 'ایستیفاده‌چی آدی:',
	'mobile-frontend-password' => 'رمز:',
	'mobile-frontend-username-placeholder' => 'ایستیفاده‌چی آدی',
	'mobile-frontend-password-placeholder' => 'رمز',
	'mobile-frontend-login' => 'گیریش',
	'mobile-frontend-overlay-escape' => 'دالییا گییت',
	'mobile-frontend-placeholder' => '{{SITENAME}}-دا آختار',
	'mobile-frontend-placeholder-beta' => '{{SITENAME}}-ی آختار (بِتا)',
	'mobile-frontend-search-help' => 'اوست‌ده آختاریش سؤزجویونو یازین و آشاغیدا بنزَر نتیجه‌لر گؤروشه‌جکلر.',
	'mobile-frontend-dismiss-notification' => 'بو بیلدیریشی بوراخ',
	'mobile-frontend-clear-search' => 'تمیزله',
	'mobile-frontend-privacy-link-text' => 'اؤزل‌لیک',
	'mobile-frontend-about-link-text' => 'گؤره',
	'mobile-frontend-footer-sitename' => '{{SITENAME}}',
	'mobile-frontend-footer-contact' => 'علاقه قورماق',
	'mobile-frontend-search-noresults' => 'سیزین آختاریشینیزا بیرنتیجه تاپیلمادی. آختاریشینیزی دَییشدیرین، یوخسا یازیلارین ایچینده آختارماق اوچون کیبورد آختاریش دویمه‌سینی وورون.',
	'mobile-frontend-main-menu-button-tooltip' => 'آنامِنونو آچ',
	'mobile-frontend-main-menu-page-title' => 'سایت‌دا دولانماق',
	'mobile-frontend-main-menu-featured' => 'اؤزل‌لنمیش',
	'mobile-frontend-main-menu-nearby' => 'یاخیندا',
	'mobile-frontend-main-menu-login' => 'گیریش',
	'mobile-frontend-main-menu-logout' => 'چیخیش',
	'mobile-frontend-main-menu-watchlist' => 'ایزلمه سیاهینیزداکی',
	'mobile-frontend-main-menu-settings' => 'تنظیملر',
	'mobile-frontend-main-menu-settings-heading' => 'موبایل سایت ترجیحلری',
	'mobile-frontend-settings-site-header' => '{{SITENAME}} دیل‌لری',
	'mobile-frontend-settings-site-description' => '{{SITENAME}}، {{PLURAL:$1|بیر|$1}} دیل‌ده ال‌ده‌دیر. بوتون ال‌ده اولان نوسخه‌لر آشاغیدا لیست اولونوبلار',
	'mobile-frontend-main-menu-contact' => 'علاقه قورماق',
	'mobile-frontend-main-menu-account-create' => 'حساب یارات',
	'mobile-frontend-page-menu-contents' => 'ایچینده‌کیلر',
	'mobile-frontend-page-menu-history' => 'گئچمیش',
	'mobile-frontend-meta-data-issues-header' => 'مقاله نی گوزلشدیرمک',
	'mobile-frontend-meta-data-issues' => 'بو صحیفه‌نین بیر نئچه ایشکالی وار',
	'mobile-frontend-ajax-page-loading' => '$1 یوکله‌نیر',
	'mobile-frontend-page-saving' => '$1 قئید اولونور',
	'mobile-frontend-ajax-page-error' => 'بیر ایشکال قاباغا گلدی. لوطفاً براوزِر پنجره‌نیزی یئنی‌له‌یین.',
	'mobile-frontend-watchlist-add' => '$1 سیزین ایزله‌دیکلرینیزه آرتیریلدی',
	'mobile-frontend-watchlist-removed' => '$1 سیزین ایزله‌دیکلرینیزدن سیلیندی',
	'mobile-frontend-watchlist-view' => 'ایزله‌دیکلرینیزه باخین',
	'mobile-frontend-changeslist-ip' => 'تانینمامیش ایستیفاده‌چی',
	'mobile-frontend-changeslist-nocomment' => 'هئچ بیر دییشدیر خلاصه‌سی',
	'mobile-frontend-watchlist-filter-all' => 'بوتون',
	'mobile-frontend-watchlist-filter-articles' => 'یازیلار',
	'mobile-frontend-watchlist-filter-talk' => 'دانیشیق',
	'mobile-frontend-watchlist-filter-other' => 'آیری',
	'mobile-frontend-diffview-title' => '$1-ه دَییشیکلیک', # Fuzzy
	'mobile-frontend-diffview-editcount' => '{{PLURAL:$1|بیر|$1}} دَییشیکلیک',
	'mobile-frontend-diffview-anonymous' => 'تانینمامیش ایستیفاده‌چی',
	'mobile-frontend-diffview-bytesadded' => '{{PLURAL:$1|بیر|$1}} باید آرتیریلدی',
	'mobile-frontend-diffview-bytesremoved' => '{{PLURAL:$1|بیر|$1}} بایت سیلیندی',
	'mobile-frontend-table' => 'جدول $1',
	'mobile-frontend-saving-exit-page' => 'سیزین چالیشمانیز قئید اولونماقدادیر. آیریلساز، او چالیشمانیز ایته‌جکدیر. چیخماقدان آرخایین‌سینیز؟',
	'mobile-frontend-photo-upload' => 'ایلک عکسی بو صحیفه‌یه آرتیر',
	'mobile-frontend-photo-article-edit-comment' => 'صحیفه‌ده ایشلدمک اوچون عکس آرتیریلدی',
	'mobile-frontend-photo-upload-comment' => 'صحیفه‌یه عکس آرتیریلدی',
	'mobile-frontend-photo-upload-progress' => 'عکسینیز بو صحیفه‌یه یوکله‌نیر',
	'mobile-frontend-photo-caption-placeholder' => 'بو عکسه بیر باشلیق آرتیر',
	'mobile-frontend-image-loading' => 'عکس یوکله‌نیر',
	'mobile-frontend-image-uploading' => 'عکس یوکله‌نیر',
	'mobile-frontend-photo-upload-error' => 'عکسی یوکله‌مک‌ده بیر خطا قاباغا گلدی. لوطفاً آیری بیر عکسی چالیشین.',
	'mobile-frontend-image-saving-to-article' => 'عکس صحیفه‌یه قئید اولونور',
	'mobile-frontend-photo-license' => 'دیقت: سیزین بوتون یایدیغینیز عکسلر، [//en.wikipedia.org/wiki/Wikipedia:Text_of_Creative_Commons_Attribution-ShareAlike_3.0_Unported_License CC BY-SA 3.0 لیسانس]ی ایله یاییلاجاقدیلار',
);

/** Bashkir (башҡортса)
 * @author Amire80
 * @author Assele
 * @author Haqmar
 * @author Roustammr
 * @author Гүзәл Ситдиҡова
 * @author ҒатаУлла
 */
$messages['ba'] = array(
	'mobile-frontend-desc' => 'Мобиль интерфейс',
	'mobile-frontend-search-submit' => 'Күсеү',
	'mobile-frontend-home-button' => 'Башына',
	'mobile-frontend-logged-out' => 'Танылмағанһығыҙ',
	'mobile-frontend-sign-in-heading' => 'Танылыу',
	'mobile-frontend-sign-in-why' => 'Әгәр һеҙҙең {{SITENAME}} проектында иҫәп яҙмағыҙ булһа, түбәндә таныла алаһығыҙ.',
	'mobile-frontend-sign-in-error-heading' => 'Хата',
	'mobile-frontend-settings-description' => 'Сайты үҙегеҙҙең мобиль ҡоролмағыҙға яраҡлаштырып көйләгеҙ.',
	'mobile-frontend-settings-beta' => 'Бета өлгөһө',
	'mobile-frontend-save-settings' => 'Көйләүҙәрҙе һаҡларға',
	'mobile-frontend-random-button' => 'Осраҡлы',
	'mobile-frontend-ajax-random-question' => 'Был бите уҡырғамы?',
	'mobile-frontend-ajax-random-yes' => 'Эйе',
	'mobile-frontend-ajax-random-retry' => 'Яңынан ҡабатлап ҡарарға',
	'mobile-frontend-ajax-random-suggestions' => 'Башҡа тәкдимдәр:',
	'mobile-frontend-back-to-top-of-section' => 'Бер бүлеккә кире ҡайтырға',
	'mobile-frontend-close-section' => 'Был бүлекте ябырға',
	'mobile-frontend-show-button' => 'Күрһәтергә',
	'mobile-frontend-hide-button' => 'Йәшерергә',
	'mobile-frontend-empty-homepage-text' => 'Был баш битте көйләргә кәрәк. <a href="https://meta.wikimedia.org/wiki/Mobile_Projects/Mobile_Gateway#Mobile_homepage">Сайтың мобиль нөхсәһен булдырыу буйынса күрһәтмәләр</a>', # Fuzzy
	'mobile-frontend-regular-site' => 'Ғәҙәти нөхсә',
	'mobile-frontend-wml-continue' => 'Дауамы...',
	'mobile-frontend-wml-back' => 'Кирегә...',
	'mobile-frontend-view' => 'Мобиль нөсхә',
	'mobile-frontend-view-desktop' => 'Ғәҙәти',
	'mobile-frontend-view-mobile' => 'Мобиль',
	'mobile-frontend-opt-in-explain' => 'Бета өлгөнө тикшереүгә ҡушылһағыҙ, һынау өсөн өҫтәлгән мөмкинлектәрҙе ҡуллана аласаҡығыҙ, әммә хаталарға һәм ҡыйынлыҡтарға тап булыуығыҙ бар.',
	'mobile-frontend-images-status' => 'Рәсемдәр',
	'mobile-frontend-disable-images' => 'Мобиль сайтта рәсемдәрҙе күрһәтмәҫкә',
	'mobile-frontend-enable-images' => 'Мобиль сайтта рәсемдәрҙе күрһәтергә',
	'mobile-frontend-missing-image' => 'Рәсем',
	'mobile-frontend-off' => 'ЮҠ',
	'mobile-frontend-on' => 'БАР',
	'mobile-frontend-footer-contributors-text' => 'Бит һеҙҙең һымаҡ [$1 авторҙар] тарафынан булдырылған',
	'mobile-frontend-featured-article' => 'Бөгөнгө көндә иң яҡшы мәҡәлә',
	'mobile-frontend-news-items' => 'Яңылыҡтар',
	'mobile-frontend-leave-feedback-notice' => 'Һеҙҙең фекерегеҙ беҙгә мобиль сайтты яҡшыртырға ярҙам итәсәк. Ул &quot;$1&quot битендә дөйөм ҡарауға асыҡ баҫылып сығасаҡ (исемегеҙ, браузерығыҙ һәм операцион системағыҙ төрө менән ҡуша). Зинһар, мәғлүмәтле тема һайлағыҙ, мәҫәлән, «Киң таблицаларҙы форматлау мәсьәләһе». Һеҙ ебәргән фекер һеҙҙең ҡулланыу шарттарына тап килергә тейеш.',
	'mobile-frontend-leave-feedback-subject' => 'Тема:',
	'mobile-frontend-leave-feedback-message' => 'Хәбәр:',
	'mobile-frontend-leave-feedback-submit' => 'Кире белдереү ебәрергә',
	'mobile-frontend-leave-feedback-link-text' => 'Мобиль арайөҙ тураһында баһаламалар',
	'mobile-frontend-leave-feedback' => 'Баһалама яҙырға',
	'mobile-frontend-leave-feedback-title' => 'Зинһар, әгәр, баҫылып сығыуын теләмәһәгеҙ, иҫкәрмәгеҙгә шәхси мәғлүмәт яҙмағыҙ.',
	'mobile-frontend-leave-feedback-technical-problem-section-header' => 'Техник ҡыйынлыҡтар',
	'mobile-frontend-leave-feedback-general-section-header' => 'Дөйөм',
	'mobile-frontend-leave-feedback-article-feedback-section-header' => 'Мәҡәлә баһаһы',
	'mobile-frontend-leave-feedback-email-body' => 'Зинһар, {{SITENAME}} проектында осраған ҡыйынлыҡтарҙы юғарыраҡ тасуирлағыҙ. Үкенескә ҡаршы, беҙ һәр хәбәргә яуап ебәрә алмайбыҙ.',
	'mobile-frontend-leave-feedback-technical-link-text' => 'Техник ҡыйынлыҡтар',
	'mobile-frontend-leave-feedback-general-link-text' => 'Дөйөм фекер',
	'mobile-frontend-leave-feedback-article-personal-link-text' => 'Минең, мин яҡлаған кеше йә ойошма тураһында',
	'mobile-frontend-leave-feedback-article-factual-link-text' => 'Ғәмәлдәге хата тураһында',
	'mobile-frontend-leave-feedback-article-other-link-text' => 'Башҡа ҡыйынлыҡтар тураһында',
	'mobile-frontend-leave-feedback-form-subject-placeholder' => 'Хәбәрҙең исеме',
	'mobile-frontend-leave-feedback-form-message-placeholder' => 'Бында үҙегеҙҙең иҫкәрмәгеҙҙе яҙығыҙ',
	'mobile-frontend-leave-feedback-page-title' => 'Баһалама яҙырға',
	'mobile-frontend-leave-feedback-special-title' => 'Бәйләнеш',
	'mobile-frontend-feedback-no-subject' => '(исемһеҙ)',
	'mobile-frontend-feedback-no-subject-field' => 'Зинһар, исем яҙығыҙ',
	'mobile-frontend-feedback-no-message' => 'Рәхим итеп, бында үҙ хәбәрегеҙҙе яҙығыҙ',
	'mobile-frontend-feedback-edit-summary' => '[[Special:MobileFeedback|Мобиль баһалама ҡулайламаһы]] ярҙамында үҙенән-үҙе баҫылып сыҡҡан', # Fuzzy
	'mobile-frontend-leave-feedback-thanks' => 'Баһаламағыҙ өсөн рәхмәт!',
	'mobile-frontend-leave-feedback-post-error' => 'Һеҙҙен хәберҙе эшкәртеү ваҡытында хата килеп сыҡты. Зинһар, һуңыраҡ тағы ҡабатлап ҡарағыҙ.',
	'mobile-frontend-language' => 'Тел:',
	'mobile-frontend-language-article-heading' => 'Башҡа телдә уҡырға',
	'mobile-frontend-language-header' => 'Был мәҡәлә {{PLURAL:$1|language|languages}} телдә бар',
	'mobile-frontend-language-footer' => 'Иғтибар: Был бит һеҙ теләгән телдә яҙыла алмай. {{SITENAME}} ниндәй телдәр ҡулланыуын бында ҡарай алаһығыҙ.',
	'mobile-frontend-language-site-choose' => 'Тел һайлау:',
	'mobile-frontend-username' => 'Ҡулланыусы исеме:',
	'mobile-frontend-password' => 'Пароль:',
	'mobile-frontend-login' => 'Танылыу',
	'mobile-frontend-overlay-escape' => 'Кире ҡайтырға',
	'mobile-frontend-placeholder' => '{{SITENAME}}-та эҙләргә',
	'mobile-frontend-placeholder-beta' => '{{SITENAME}} буйлап эҙләргә (Бета)',
	'mobile-frontend-search-help' => 'Юғарыла кәрәкле һүҙҙәрҙе керетегеҙ, һәм бында тап килгән бит исемдәре килеп сығасаҡ.',
	'mobile-frontend-dismiss-notification' => 'был иҫкәрмәне йәшерергә',
	'mobile-frontend-clear-search' => 'Таҙартыу',
	'mobile-frontend-privacy-link-text' => 'Сер һаҡлау',
	'mobile-frontend-about-link-text' => 'Тасуирлау',
	'mobile-frontend-footer-sitename' => '{{SITENAME}}',
	'mobile-frontend-footer-contact' => 'Бәйләнеш өсөн мәғлүмәт',
	'mobile-frontend-search-noresults' => 'Һеҙ кереткән һүҙҙәр менән тап килгән бит исемдәре юҡ. Эҙләү өсөн һүҙҙәрҙе үҙгәртегеҙ, йәки биттәр эсендә эҙләү өсөн «Эҙләргә» төймәһенә баҫығыҙ.',
	'mobile-frontend-main-menu-button-tooltip' => 'Төп менюны асырға',
	'mobile-frontend-main-menu-page-title' => 'Сайттың төп йүнәлештәре',
	'mobile-frontend-main-menu-featured' => 'Һайланған',
	'mobile-frontend-main-menu-nearby' => 'Эргәлә',
	'mobile-frontend-main-menu-login' => 'Танылыу',
	'mobile-frontend-main-menu-logout' => 'Тамамлау',
	'mobile-frontend-main-menu-watchlist' => 'Күҙәтеү исемлеге',
	'mobile-frontend-main-menu-settings' => 'Көйләүҙәр',
	'mobile-frontend-main-menu-settings-heading' => 'Сайттың мобиль нөхсәһен көйләү',
	'mobile-frontend-settings-site-header' => '{{SITENAME}} проектындағы телдәр',
	'mobile-frontend-settings-site-description' => '{{SITENAME}} проекты $1 {{PLURAL:$1|телдә}} бар. Түбәндә бөтә телдәр теҙмәһе килтерелгән.',
	'mobile-frontend-main-menu-contact' => 'Бәйләнеш өсөн мәғлүмәт',
	'mobile-frontend-page-menu-contents' => 'йөкмәткеһе',
	'mobile-frontend-page-menu-history' => 'Тарих',
	'mobile-frontend-table' => '$1 таблицаһы',
	'mobile-frontend-saving-exit-page' => 'Һеҙҙең үҙгәртеүҙәрегеҙ һаҡлана әле. Сыҡһағыҙ, үҙгәртеүҙәрегеҙ юғаласаҡ. Һеҙ ысынлап та сығырға теләйһегеҙме?',
	'mobile-frontend-photo-upload' => 'Был биткә тәүге фотоны өҫтәргә', # Fuzzy
);

/** Bavarian (Boarisch)
 * @author Mucalexx
 * @author Schläsinger
 */
$messages['bar'] = array(
	'mobile-frontend-desc' => 'Daméglicht dé fyr móbile Endgräte óptimierde Dorstejung vah Seiten',
	'mobile-frontend-search-submit' => 'Lós',
	'mobile-frontend-home-button' => 'Start',
	'mobile-frontend-random-button' => 'Zuafoi',
	'mobile-frontend-back-to-top-of-section' => 'Oah Kapitel zruck springer',
	'mobile-frontend-show-button' => 'Auhzoang',
	'mobile-frontend-hide-button' => 'Vastecker',
	'mobile-frontend-regular-site' => 'Za da klassischen {{SITENAME}}-Auhsicht wexeln', # Fuzzy
	'mobile-frontend-wml-continue' => 'Weider ...',
	'mobile-frontend-wml-back' => 'Zruck ...',
	'mobile-frontend-view' => 'Móbile Auhsicht',
	'mobile-frontend-opt-in-explain' => "Durch d' Teilnaum am Beta-Test dahoitst an Zuagrieff af experimenteje Funkzióner, dé dert owerraa Próbléme und Feeler vaursocher kennern.",
	'mobile-frontend-disable-images' => "Bijder a' da móbiln Auhsicht deaktiviern",
	'mobile-frontend-enable-images' => "Bijder a' da móbiln Auhsicht aktiviern",
	'mobile-frontend-featured-article' => 'Artiké vam Toog',
	'mobile-frontend-news-items' => "A' d' Noochrichten",
	'mobile-frontend-leave-feedback-notice' => "Deih Ryckmejdung hijft ins dodabei, d' móbile Auhsicht weider z' vabéssern. Sie werd éfferntlich af da Seiten &quot;$1&quot; auhzoagt. Deih Benutzernaum, d' Versión dé vah dir gnytzden Browser sówiaras vah dir gnytzde Betriabssystém auhgeem. Bittscheh wejh an informatiavm und assogkräfting Bedreff, wia z. Bsp.: „A Próblém ba da Auhzoag vah Tabejn“. Deih Ryckmejdung unterliagt inserne Nutzungsbedingunger.",
	'mobile-frontend-leave-feedback-subject' => 'Bedreff:', # Fuzzy
	'mobile-frontend-leave-feedback-message' => 'Noochricht', # Fuzzy
	'mobile-frontend-leave-feedback-submit' => 'Ryckmejdung sénden',
	'mobile-frontend-leave-feedback-link-text' => 'Ryckmejdung za da móbiln Auhsicht',
	'mobile-frontend-leave-feedback' => 'Ryckmejdung geem',
	'mobile-frontend-leave-feedback-title' => 'Gib ins bittscheh a Ryckmejdung zua deine Erforunger mid da móbiln Auhsicht',
	'mobile-frontend-leave-feedback-page-title' => 'Gib ins bittscheh a Ryckmejdung zua deine Erforunger mid da móbiln Auhsicht',
	'mobile-frontend-leave-feedback-thanks' => "An recht an scheener Daunk fyr d' Ryckmejdung.",
	'mobile-frontend-language' => 'Sprooch', # Fuzzy
	'mobile-frontend-username' => 'Benutzernaum:',
	'mobile-frontend-password' => 'Posswort:',
	'mobile-frontend-login' => 'Auhmejn',
	'mobile-frontend-placeholder' => 'Gib do deih Suach eih ...', # Fuzzy
	'mobile-frontend-dismiss-notification' => 'dé Benoochrichtigung schliassen',
	'mobile-frontend-clear-search' => 'Laarn',
);

/** Belarusian (Taraškievica orthography) (беларуская (тарашкевіца)‎)
 * @author EugeneZelenko
 * @author Jim-by
 * @author Renessaince
 * @author Wizardist
 * @author Zedlik
 */
$messages['be-tarask'] = array(
	'mobile-frontend-desc' => 'Мабільны інтэрфэйс',
	'mobile-frontend-search-submit' => 'Знайсьці',
	'mobile-frontend-home-button' => 'Хатняя',
	'mobile-frontend-logged-out' => 'Вы не ўвайшлі ў сыстэму',
	'mobile-frontend-logged-in-homepage-notification' => 'Вітаем, $1!',
	'mobile-frontend-logged-in-toast-notification' => 'Увайшлі як $1',
	'mobile-frontend-sign-up-heading' => 'Зарэгістравацца',
	'mobile-frontend-sign-in-heading' => 'Увайсьці',
	'mobile-frontend-sign-in-why' => 'Калі ў вас ёсьць рахунак у {{GRAMMAR:месны|{{SITENAME}}}}, можаце прадставіцца ніжэй.',
	'mobile-frontend-sign-in-error-heading' => 'Ой',
	'mobile-frontend-settings-description' => 'Налады ніжэй дапамогуць вам дастасаваць выгляд мабільнага сайту для сябе.',
	'mobile-frontend-settings-beta' => 'Бэта',
	'mobile-frontend-settings-alpha' => 'Рэжым «[//en.wikipedia.org/wiki/Here_be_dragons тут жывуць цмокі]»',
	'mobile-frontend-settings-alpha-description' => 'Завітайце ў небясьпечную й неразьведаную мабільную тэрыторыю. Напаткайце яшчэ больш экспэрымэнтальных магчымасьцяў, поўных хібаў.',
	'mobile-frontend-save-settings' => 'Захаваць налады',
	'mobile-frontend-random-button' => 'Выпадковая',
	'mobile-frontend-ajax-random-heading' => 'Шукаем веды...',
	'mobile-frontend-ajax-random-quote' => 'Набыцьцё ведаў мусіць пачынацца ад нараджэньня і сканчацца толькі па сьмерці',
	'mobile-frontend-ajax-random-question' => 'Чытаць гэтую старонку?',
	'mobile-frontend-ajax-random-yes' => 'Так',
	'mobile-frontend-ajax-random-retry' => 'Паспрабуйце зноў',
	'mobile-frontend-ajax-random-suggestions' => 'Іншыя варыянты:',
	'mobile-frontend-back-to-top-of-section' => 'Вярнуцца да папярэдняй сэкцыі',
	'mobile-frontend-close-section' => 'Зачыніць гэты разьдзел',
	'mobile-frontend-show-button' => 'Паказаць',
	'mobile-frontend-hide-button' => 'Схаваць',
	'mobile-frontend-empty-homepage-text' => 'Трэба наладзіць галоўную старонку. [//meta.wikimedia.org/wiki/Mobile_Projects/Mobile_Gateway#Mobile_homepage Даведайцеся болей пра наладку мабільнай вэрсіі]',
	'mobile-frontend-regular-site' => 'Поўная вэрсія',
	'mobile-frontend-wml-continue' => 'Далей …',
	'mobile-frontend-wml-back' => 'Вярнуцца …',
	'mobile-frontend-view' => 'Мабільная вэрсія',
	'mobile-frontend-view-desktop' => 'Для кампутара',
	'mobile-frontend-view-mobile' => 'Для тэлефону',
	'mobile-frontend-opt-in-explain' => 'Далучыўшыся да тэставаньня бэта-вэрсіі, Вы атрымаеце доступ да экспэрымэнтальных магчымасьцяў, але з рызыкай памылак і праблемаў.',
	'mobile-frontend-images-status' => 'Выявы',
	'mobile-frontend-disable-images' => 'Забараніць выявы на сайце для мабільных тэлефонаў',
	'mobile-frontend-enable-images' => 'Дазволіць выявы на сайце для мабільных тэлефонаў',
	'mobile-frontend-missing-image' => 'Выява',
	'mobile-frontend-off' => 'ВЫКЛ',
	'mobile-frontend-on' => 'УКЛ',
	'mobile-frontend-footer-contributors-text' => 'Старонка, створаная такімі ж як вы [$1 ўдзельнікамі]',
	'mobile-frontend-featured-article' => 'Сёньняшні абраны артыкул',
	'mobile-frontend-news-items' => 'Навіны',
	'mobile-frontend-leave-feedback-notice' => 'Ваш водгук дапаможа нам палепшыць карыстаньне мабільнай вэрсіяй. Ён будзе апублікаваны публічна (разам з Вашым імем карыстальніка, вэрсіяй браўзэра і апэрацыйнай сыстэмай) на старонцы &quot;$1&quot;. Калі ласка, паспрабуйце выбраць інфармацыйную назву, напрыклад «Праблемы фарматаваньня шырокіх табліцаў». Ваш водгук павінен адпавядаць нашым умовам выкарыстаньня.',
	'mobile-frontend-leave-feedback-warning' => 'Не ўключайце ў свае камэнтары прыватную інфармацыю, калі ня згодныя на яе публікацыю.',
	'mobile-frontend-leave-feedback-subject' => 'Тэма:',
	'mobile-frontend-leave-feedback-message' => 'Паведамленьне:',
	'mobile-frontend-leave-feedback-submit' => 'Даслаць водгук',
	'mobile-frontend-leave-feedback-link-text' => 'Водгук пра Мабільны інтэрфэйс',
	'mobile-frontend-leave-feedback' => 'Пакінуць водгук',
	'mobile-frontend-leave-feedback-title' => 'Водгук па мабільным сайце',
	'mobile-frontend-leave-feedback-technical-problem-section-header' => 'Тэхнічная праблема',
	'mobile-frontend-leave-feedback-general-section-header' => 'Агульнае',
	'mobile-frontend-leave-feedback-article-feedback-section-header' => 'Водгук на артыкул',
	'mobile-frontend-leave-feedback-email-body' => 'Апішыце, калі ласка, праблему, зь якой вы сутыкнуліся ў {{GRAMMAR:месны|{{SITENAME}}}}, над гэтай рыскай. Заўважце, калі ласка, што мы ня можам адказаць на кожны ліст, які атрымліваем.',
	'mobile-frontend-leave-feedback-technical-link-text' => 'Тэхнічная праблема',
	'mobile-frontend-leave-feedback-general-link-text' => 'Звычайны водгук',
	'mobile-frontend-leave-feedback-article-personal-link-text' => 'Тычыцца мяне, асобы або кампаніі, якую я рэпрэзэнтую',
	'mobile-frontend-leave-feedback-article-factual-link-text' => 'Тычыцца факталягічнай памылкі',
	'mobile-frontend-leave-feedback-article-other-link-text' => 'Тычыцца іншай праблемы',
	'mobile-frontend-leave-feedback-form-subject-placeholder' => 'Тэма паведамленьня',
	'mobile-frontend-leave-feedback-form-message-placeholder' => 'Увядзіце ваш камэнтар тут',
	'mobile-frontend-leave-feedback-page-title' => 'Водгук па мабільным сайце',
	'mobile-frontend-leave-feedback-special-title' => 'Напішыце нам',
	'mobile-frontend-feedback-no-subject' => '(бяз тэмы)',
	'mobile-frontend-feedback-no-subject-field' => 'Увядзіце, калі ласка, тэму',
	'mobile-frontend-feedback-no-message' => 'Увядзіце сюды паведамленьне, калі ласка',
	'mobile-frontend-feedback-edit-summary' => '$1 — адпраўлены аўтаматычна са [[Special:MobileFeedback|старонкі водгукаў]]',
	'mobile-frontend-leave-feedback-thanks' => 'Дзякуй за Ваш водгук!',
	'mobile-frontend-leave-feedback-post-error' => 'У час апрацоўкі вашага паведамленьня ўзьнікла памылка. Паспрабуйце, калі ласка, пазьней.',
	'mobile-frontend-language' => 'Мова:',
	'mobile-frontend-language-article-heading' => 'Чытаць на іншай мове',
	'mobile-frontend-language-header' => 'Гэтая старонка даступная на $1 {{PLURAL:$1|мове|мовах}}',
	'mobile-frontend-language-variant-header' => 'Выберыце варыянт мовы {{#language:{{CONTENTLANG}}}}',
	'mobile-frontend-language-footer' => 'Заўвага: гэтая старонка, магчыма, напісаная не на пажаданай мове. Вы можаце аглядзець сьпіс моваў, якія падтрымлівае {{SITENAME}}, пстрыкнуўшы тут.',
	'mobile-frontend-language-site-choose' => 'Пошук мовы',
	'mobile-frontend-username' => 'Імя ўдзельніка:',
	'mobile-frontend-password' => 'Пароль:',
	'mobile-frontend-username-placeholder' => 'Імя ўдзельніка',
	'mobile-frontend-password-placeholder' => 'Пароль',
	'mobile-frontend-login' => 'Увайсьці',
	'mobile-frontend-last-modified-date' => 'Апошнія зьмены $1 а $2',
	'mobile-frontend-last-modified-seconds' => 'Апошнія зьмены {{PLURAL:$1|$1 сэкунду|$1 сэкунды|$1 сэкундаў}} таму',
	'mobile-frontend-last-modified-minutes' => 'Апошнія зьмены {{PLURAL:$1|$1 хвіліну|$1 хвіліны|$1 хвілінаў}} таму',
	'mobile-frontend-last-modified-hours' => 'Апошнія зьмены {{PLURAL:$1|$1 гадзіну|$1 гадзіны|$1 гадзінаў}} таму',
	'mobile-frontend-last-modified-days' => 'Апошнія зьмены {{PLURAL:$1|$1 дзень|$1 дні|$1 дзён}} таму',
	'mobile-frontend-last-modified-months' => 'Апошнія зьмены {{PLURAL:$1|$1 месяц|$1 месяц|$1 месяцаў}} таму',
	'mobile-frontend-last-modified-years' => 'Апошнія зьмены {{PLURAL:$1|$1 год|$1 гады|$1 гадоў}} таму',
	'mobile-frontend-account-create-submit' => 'Зарэгістравацца',
	'mobile-frontend-password-confirm-placeholder' => 'Пацьвердзіце пароль',
	'mobile-frontend-account-create-email-placeholder' => 'Адрас e-mail (неабавязкова)',
	'mobile-frontend-account-create-captcha-placeholder' => 'Увядзіце код бясьпекі',
	'mobile-frontend-overlay-escape' => 'Вярнуцца',
	'mobile-frontend-placeholder' => 'Шукайце ў {{GRAMMAR:месны|{{SITENAME}}}}',
	'mobile-frontend-placeholder-beta' => 'Шукайце ў {{GRAMMAR:месны|{{SITENAME}}}} (бэта)',
	'mobile-frontend-placeholder-alpha' => 'Шукайце ў {{GRAMMAR:месны|{{SITENAME}}}} (рэжым з цмокамі)',
	'mobile-frontend-search-help' => 'Пасуючыя старонкі будуць зьяўляцца, як вы ўводзіце пошукавы запыт.',
	'mobile-frontend-dismiss-notification' => 'схаваць паведамленьне',
	'mobile-frontend-clear-search' => 'Ачысьціць',
	'mobile-frontend-privacy-link-text' => 'Прыватнасьць',
	'mobile-frontend-about-link-text' => 'Пра сайт',
	'mobile-frontend-footer-sitename' => '{{SITENAME}}',
	'mobile-frontend-footer-license-text' => 'Зьмест даступны на ўмовах ліцэнзіі [//en.m.wikipedia.org/wiki/Wikipedia:Text_of_Creative_Commons_Attribution-ShareAlike_3.0_Unported_License?useformat=mobile CC BY-SA 3.0]',
	'mobile-frontend-terms-use-text' => '[//wikimediafoundation.org/wiki/Умовы_выкарыстаньня?useformat=mobile Умовы выкарыстаньня]',
	'mobile-frontend-footer-contact' => 'Кантакты',
	'mobile-frontend-search-noresults' => 'Старонкі, чые загалоўкі б пасавалі вашаму запыту, ня знойдзеныя. Зьмяніце запыт, або націсьніце на клявіятуры кнопку пошуку, каб шукаць у зьмесьце старонак.',
	'mobile-frontend-main-menu-button-tooltip' => 'Адкрыць галоўнае мэню',
	'mobile-frontend-main-menu-page-title' => 'Навігацыя па сайце',
	'mobile-frontend-main-menu-featured' => 'Абранае',
	'mobile-frontend-main-menu-nearby' => 'Паблізу',
	'mobile-frontend-main-menu-login' => 'Увайсьці',
	'mobile-frontend-main-menu-logout' => 'Выйсьці',
	'mobile-frontend-main-menu-watchlist' => 'Сьпіс назіраньня',
	'mobile-frontend-main-menu-settings' => 'Налады',
	'mobile-frontend-main-menu-upload' => 'Запампоўкі',
	'mobile-frontend-main-menu-settings-heading' => 'Налады мабільнага сайту',
	'mobile-frontend-settings-site-header' => 'Мовы {{GRAMMAR:родны|{{SITENAME}}}}',
	'mobile-frontend-settings-site-description' => 'Праект «{{SITENAME}}» даступны на $1 {{PLURAL:$1|мове|мовах}}. Ніжэй выкладзеныя ўсе даступныя вэрсіі.',
	'mobile-frontend-main-menu-contact' => 'Кантакты',
	'mobile-frontend-main-menu-account-create' => 'Стварыць рахунак',
	'mobile-frontend-page-menu-contents' => 'зьмест',
	'mobile-frontend-page-menu-history' => 'Гісторыя',
	'mobile-frontend-meta-data-issues-header' => 'Хібы',
	'mobile-frontend-meta-data-issues' => 'Гэтая старонка мае хібы',
	'mobile-frontend-ajax-page-loading' => 'Загрузка артыкула «$1»',
	'mobile-frontend-page-saving' => 'Захоўваем «$1»',
	'mobile-frontend-ajax-page-error' => 'Ой! Штосьці ня так. Паспрабуйце абнавіць акно браўзэра.',
	'mobile-frontend-nearby-title' => 'Побач',
	'mobile-frontend-nearby-loading' => 'Загрузка тэмаў побач з вамі',
	'mobile-frontend-nearby-requirements' => 'Гэтая старонка вымагае ад браўзэра падтрымкі JavaScript і геалякацыі.',
	'mobile-frontend-nearby-distance-report' => '$1 км ад вашага становішча',
	'mobile-frontend-nearby-lookup-error' => 'Ня можам знайсьці вам. Спрабуем зноў...',
	'mobile-frontend-nearby-noresults' => 'Вы сігнулі ў бездань і мы не змаглі знайсьці пасуючых тэм. Чаму б не апісаць адну?',
	'mobile-frontend-nearby-refresh' => 'Мы атрымалі вашае болей дакладнае становішча. Націсьніце тут, каб абнавіць сьпіс блізкіх старонак',
	'mobile-frontend-nearby-error' => 'У часе пошуку блізкіх старонак адбылася нечаканая памылка',
	'mobile-frontend-donate-image-login' => 'Увайдзіце, каб праглядзець вашыя запампоўкі.',
	'mobile-frontend-photo-upload-generic' => 'Ахвяраваць выяву',
	'mobile-frontend-donate-image-title' => 'Ахвяраваньне выявы',
	'mobile-frontend-donate-image-summary' => 'Фатаграфіі ствараюць душу старонак {{GRAMMAR:родны|{{SITENAME}}}}. Як шмат старонак без фатаздымкаў толькі з-за таго, што крытычна не хапае фатаздымкаў з вольнымі ліцэнзіямі. Дапамажыце гэтым старонкам набыць сваю душу, ахвяраваўшы вашыя здымкі — загрузіўшы фота, яно трапляе ў рукі буйной супольнасьці рэдактараў {{GRAMMAR:родны|{{SITENAME}}}}.',
	'mobile-frontend-donate-image-heading' => 'Ваш нядаўні ўнёсак',
	'mobile-frontend-donate-image-page-title' => 'Запампоўка',
	'mobile-frontend-listed-image-no-description' => 'Без апісаньня',
	'mobile-frontend-watchlist-add' => '$1 дададзена ў сьпіс назіраньня',
	'mobile-frontend-watchlist-removed' => '$1 выдалена са сьпісу назіраньня',
	'mobile-frontend-watchlist-view' => 'Праглядзець сьпіс назіраньня',
	'mobile-frontend-watchlist-more' => 'болей',
	'mobile-frontend-watchlist-cta-button-login' => 'Увайсьці',
	'mobile-frontend-watchlist-cta-button-signup' => 'Зарэгістравацца',
	'mobile-frontend-changeslist-ip' => 'Ананімны ўдзельнік',
	'mobile-frontend-changeslist-nocomment' => 'няма апісаньня зьменаў',
	'mobile-frontend-watchlist-filter-all' => 'Усе',
	'mobile-frontend-watchlist-filter-articles' => 'Артыкулы',
	'mobile-frontend-watchlist-filter-talk' => 'Абмеркаваньні',
	'mobile-frontend-watchlist-filter-other' => 'Іншыя',
	'mobile-frontend-diffview-title' => 'Зьмены',
	'mobile-frontend-diffview-editcount' => '$1 {{PLURAL:$1|зьмена|зьмены|зьменаў}}',
	'mobile-frontend-diffview-anonymous' => 'Ананімны ўдзельнік',
	'mobile-frontend-diffview-bytesadded' => '$1 {{PLURAL:$1|байт дададзены|байты дададзена|байтаў дададзена}}',
	'mobile-frontend-diffview-bytesremoved' => '$1 {{PLURAL:$1|байт выдалены|байты выдалена|байтаў выдалена}}',
	'mobile-frontend-table' => 'Табліца $1',
	'mobile-frontend-saving-exit-page' => 'Ваш унёсак яшчэ захохоўваецца. Калі вы сыйдзеце, зьмены будуць згубленыя. Вы ўпэўненыя, што хочаце выйсьці?',
	'mobile-frontend-photo-upload' => 'Дадайце першую выяву ў гэты артыкул', # Fuzzy
	'mobile-frontend-photo-article-edit-comment' => 'Дададзеная выява для выкарыстаньня ў артыкуле', # Fuzzy
	'mobile-frontend-photo-upload-comment' => 'Дададзеная выява ў артыкул', # Fuzzy
	'mobile-frontend-photo-caption-placeholder' => 'Дадайце подпіс да гэтай выявы', # Fuzzy
	'mobile-frontend-image-loading' => 'Загрузка выявы',
	'mobile-frontend-image-uploading-wait' => 'Запампоўка выявы', # Fuzzy
	'mobile-frontend-photo-upload-error' => 'Пры запампоўцы выявы адбылася памылка. Паспрабуйце іншую.', # Fuzzy
	'mobile-frontend-photo-license' => 'Увага: усе здымкі, што вы публікуеце, пубудць даступныя на ўмовах ліцэнзіі [//en.wikipedia.org/wiki/Wikipedia:Text_of_Creative_Commons_Attribution-ShareAlike_3.0_Unported_License CC BY-SA].', # Fuzzy
	'tag-mobile_edit' => 'Праўка з тэлефона',
);

/** Bulgarian (български)
 * @author DCLXVI
 * @author Ivanko
 * @author Spiritia
 * @author Stanqo
 * @author Vladimir Penov
 * @author පසිඳු කාවින්ද
 */
$messages['bg'] = array(
	'mobile-frontend-search-submit' => 'Отиване',
	'mobile-frontend-home-button' => 'Начало',
	'mobile-frontend-sign-up-heading' => 'Регистриране',
	'mobile-frontend-sign-in-heading' => 'Влизане',
	'mobile-frontend-settings-beta' => 'Бета',
	'mobile-frontend-save-settings' => 'Съхраняване на настройките',
	'mobile-frontend-random-button' => 'Случайна',
	'mobile-frontend-ajax-random-yes' => 'Да',
	'mobile-frontend-ajax-random-retry' => 'Опитайте отново',
	'mobile-frontend-back-to-top-of-section' => 'Един раздел назад',
	'mobile-frontend-close-section' => 'Затворете този раздел',
	'mobile-frontend-show-button' => 'Показване',
	'mobile-frontend-hide-button' => 'Скриване',
	'mobile-frontend-regular-site' => 'Настолен изглед',
	'mobile-frontend-wml-continue' => 'Продължава...',
	'mobile-frontend-wml-back' => 'Назад...',
	'mobile-frontend-view' => 'Мобилен изглед',
	'mobile-frontend-images-status' => 'Изображения',
	'mobile-frontend-disable-images' => 'Спиране на изображенията по сайта',
	'mobile-frontend-enable-images' => 'Пускане на изображенията по сайта',
	'mobile-frontend-missing-image' => 'Изображение',
	'mobile-frontend-off' => 'ИЗКЛ.',
	'mobile-frontend-on' => 'ВКЛ.',
	'mobile-frontend-footer-contributors-text' => 'Статия от [$1 сътрудници] като вас',
	'mobile-frontend-featured-article' => 'Избрана статия на деня',
	'mobile-frontend-news-items' => 'В новините',
	'mobile-frontend-leave-feedback-warning' => 'Ако не сте съгласни ваша конфиденциална информация да стане публично достояние, моля, не включва лични данни във вашите коментари.',
	'mobile-frontend-leave-feedback-subject' => 'Тема:',
	'mobile-frontend-leave-feedback-message' => 'Съобщение:',
	'mobile-frontend-leave-feedback-submit' => 'Оставяне на коментар',
	'mobile-frontend-leave-feedback-technical-problem-section-header' => 'Технически проблем',
	'mobile-frontend-leave-feedback-general-section-header' => 'Основни',
	'mobile-frontend-leave-feedback-technical-link-text' => 'Технически проблем',
	'mobile-frontend-leave-feedback-general-link-text' => 'Общи коментари',
	'mobile-frontend-leave-feedback-form-subject-placeholder' => 'Тема на съобщението',
	'mobile-frontend-leave-feedback-form-message-placeholder' => 'Въведете коментар тук',
	'mobile-frontend-leave-feedback-special-title' => 'Свържете се с нас',
	'mobile-frontend-feedback-no-subject' => '(няма тема)',
	'mobile-frontend-feedback-no-subject-field' => 'Въведете тема',
	'mobile-frontend-feedback-no-message' => 'Въведете съобщение тук',
	'mobile-frontend-leave-feedback-thanks' => 'Благодарности за изразеното мнение!',
	'mobile-frontend-leave-feedback-post-error' => 'Възникна грешка при обработката на вашето съобщение. Моля опитайте отново по-късно.',
	'mobile-frontend-language' => 'Език:',
	'mobile-frontend-language-article-heading' => 'Прочитане на друг език',
	'mobile-frontend-language-site-choose' => 'Избиране на език:',
	'mobile-frontend-username' => 'Потребителско име:',
	'mobile-frontend-password' => 'Парола:',
	'mobile-frontend-username-placeholder' => 'Потребителско име',
	'mobile-frontend-password-placeholder' => 'Парола',
	'mobile-frontend-login' => 'Влизане',
	'mobile-frontend-account-create-submit' => 'Регистриране',
	'mobile-frontend-placeholder' => 'Търсене в {{SITENAME}}',
	'mobile-frontend-placeholder-beta' => 'Търсене в {{SITENAME}} (бета)',
	'mobile-frontend-clear-search' => 'Изчистване',
	'mobile-frontend-privacy-link-text' => 'Поверителност',
	'mobile-frontend-about-link-text' => 'Относно',
	'mobile-frontend-footer-sitename' => '{{SITENAME}}',
	'mobile-frontend-footer-contact' => 'Контакт',
	'mobile-frontend-main-menu-button-tooltip' => 'Отвори главното меню',
	'mobile-frontend-main-menu-page-title' => 'Навигация на сайта',
	'mobile-frontend-main-menu-featured' => 'Избрана',
	'mobile-frontend-main-menu-nearby' => 'Наблизо',
	'mobile-frontend-main-menu-login' => 'Влизане',
	'mobile-frontend-main-menu-logout' => 'Излизане',
	'mobile-frontend-main-menu-settings' => 'Настройки',
	'mobile-frontend-main-menu-settings-heading' => 'Настройки за мобилен сайт',
	'mobile-frontend-page-menu-contents' => 'съдържание',
	'mobile-frontend-page-menu-history' => 'История',
	'mobile-frontend-watchlist-cta-button-login' => 'Влизане',
	'mobile-frontend-watchlist-cta-button-signup' => 'Регистриране',
	'mobile-frontend-watchlist-filter-all' => 'Всички',
	'mobile-frontend-watchlist-filter-talk' => 'Беседа',
	'mobile-frontend-watchlist-filter-other' => 'Други',
	'mobile-frontend-drawer-cancel' => 'Отказване',
);

/** Bhojpuri (भोजपुरी)
 * @author Amire80
 */
$messages['bho'] = array(
	'mobile-frontend-home-button' => 'घर',
	'mobile-frontend-sign-up-heading' => 'खाता खोलीं',
	'mobile-frontend-sign-in-heading' => 'खाता मे प्रवेश करीं',
);

/** Bengali (বাংলা)
 * @author Bellayet
 * @author Nasir8891
 */
$messages['bn'] = array(
	'mobile-frontend-desc' => 'মোবাইল ফ্রন্টএন্ড',
	'mobile-frontend-search-submit' => 'যাও',
	'mobile-frontend-home-button' => 'প্রধান পাতা',
	'mobile-frontend-logged-out' => 'লগইন করা হয়নি',
	'mobile-frontend-sign-in-heading' => 'প্রবেশ',
	'mobile-frontend-settings-description' => 'মোবাইল থেকে সহজে ব্যবহার করার জন্য মোবাইলের উপযোগী পছন্দসমূহ নির্ধারন করুন।',
	'mobile-frontend-settings-beta' => 'বেটা সংস্করণ',
	'mobile-frontend-save-settings' => 'সেটিংস সংরক্ষণ',
	'mobile-frontend-random-button' => 'অজানা পাতা',
	'mobile-frontend-ajax-random-yes' => 'হ্যাঁ',
	'mobile-frontend-back-to-top-of-section' => 'অনুচ্ছেদে ফিরে যাও',
	'mobile-frontend-close-section' => 'বন্ধ করুন',
	'mobile-frontend-show-button' => 'দেখাও',
	'mobile-frontend-hide-button' => 'আড়াল করো',
	'mobile-frontend-empty-homepage-text' => 'এই হোমপেজটি কনফিগার করা প্রয়োজন। <a href="http://meta.wikimedia.org/wiki/Mobile_Projects/Mobile_Gateway#Mobile_homepage">বিস্তারিত দেখুন</a>', # Fuzzy
	'mobile-frontend-regular-site' => 'ডেক্সটপ সংস্করণ',
	'mobile-frontend-wml-continue' => 'অব্যাহত ...',
	'mobile-frontend-wml-back' => 'পিছনে ...',
	'mobile-frontend-view' => 'মোবাইল সংস্করণ',
	'mobile-frontend-view-desktop' => 'ডেক্সটপ',
	'mobile-frontend-view-mobile' => 'মোবাইল',
	'mobile-frontend-opt-in-explain' => 'বেটায় অংশগ্রহনের মাধ্যমে আপনি, পরীক্ষামূলক বৈশিষ্টগুলো ব্যবহারের সুযোগ পাবেন, তবে এখানে বাগ এবং ত্রুটিপূর্ণ বৈশিষ্ট থাকতে পারে।',
	'mobile-frontend-images-status' => 'চিত্রসমূহ',
	'mobile-frontend-disable-images' => 'মোবাইল সাইটে চিত্র নিস্ক্রিয়',
	'mobile-frontend-enable-images' => 'মোবাইল সাইটে চিত্র সক্রিয়',
	'mobile-frontend-off' => 'বন্ধ',
	'mobile-frontend-on' => 'চালু',
	'mobile-frontend-footer-contributors-text' => 'নিবন্ধটি আপনার মত [$1 স্বেচ্ছাসেবকরা] তৈরী করেছেন',
	'mobile-frontend-featured-article' => 'আজকের নির্বাচিত নিবন্ধ',
	'mobile-frontend-news-items' => 'খবরে',
	'mobile-frontend-leave-feedback-subject' => 'বিষয়:',
	'mobile-frontend-leave-feedback-message' => 'বার্তা:',
	'mobile-frontend-leave-feedback-submit' => 'প্রতিক্রিয়া জমা',
	'mobile-frontend-leave-feedback-link-text' => 'মোবাইল ফ্রন্টএন্ড এক্সটেনশন ফিডব্যাক',
	'mobile-frontend-leave-feedback' => 'মোবাইল সাইট প্রতিক্রিয়া',
	'mobile-frontend-leave-feedback-title' => 'মোবাইল সাইট ফিডব্যাক',
	'mobile-frontend-leave-feedback-technical-problem-section-header' => 'কারিগরি সমস্যা',
	'mobile-frontend-leave-feedback-general-section-header' => 'সাধারণ',
	'mobile-frontend-leave-feedback-article-feedback-section-header' => 'নিবন্ধ প্রতিক্রিয়া',
	'mobile-frontend-leave-feedback-email-body' => 'অনুগ্রহ করে এই লাইনের উপরে আপনার ই-মেইল ঠিকানা লিখুন।', # Fuzzy
	'mobile-frontend-leave-feedback-technical-link-text' => 'কারিগরি সমস্যা',
	'mobile-frontend-leave-feedback-general-link-text' => 'সাধারণ ফিডব্যাক',
	'mobile-frontend-leave-feedback-article-personal-link-text' => 'আমার নিজের, একজন ব্যক্তি অথবা আমার পরিচিত একটি কোম্পানি সম্পর্কে',
	'mobile-frontend-leave-feedback-article-factual-link-text' => 'ফ্যাটাল ত্রুটি সম্পর্কিত',
	'mobile-frontend-leave-feedback-article-other-link-text' => 'অন্য ত্রুটি সম্পর্কে',
	'mobile-frontend-leave-feedback-form-subject-placeholder' => 'বার্তার বিষয়',
	'mobile-frontend-leave-feedback-form-message-placeholder' => 'আপনার মন্তব্য লিখুন',
	'mobile-frontend-leave-feedback-page-title' => 'মোবাইল সাইট ফিডব্যাক',
	'mobile-frontend-leave-feedback-special-title' => 'যোগাযোগ',
	'mobile-frontend-feedback-no-subject' => '(বিষয় নেই)',
	'mobile-frontend-feedback-no-subject-field' => 'অনুগ্রহ করে বিষয় লিখুন',
	'mobile-frontend-feedback-no-message' => 'অনুগ্রহ করে এখানে মন্তব্য লিখুন',
	'mobile-frontend-feedback-edit-summary' => '$1 - [[Special:MobileFeedback|মোবাইল ফিডব্যাক টুলের]] মাধ্যমে পোস্ট করা হয়েছে',
	'mobile-frontend-leave-feedback-thanks' => 'প্রতিক্রিয়া জানানোর জন্য আপনাকে ধন্যবাদ!',
	'mobile-frontend-leave-feedback-post-error' => 'আপনার বার্তাটি পাঠানোর সময় কোনো সমস্যা হয়েছে। অনুগ্রহ করে আবার চেষ্ঠা করুন।',
	'mobile-frontend-language' => 'ভাষা:',
	'mobile-frontend-language-header' => 'এই নিবন্ধটি $1টি {{PLURAL:$1|ভাষায়|ভাষায়}} রয়েছে', # Fuzzy
	'mobile-frontend-language-footer' => '{{SITENAME}} অন্যান্য ভাষাতেও রয়েছে।', # Fuzzy
	'mobile-frontend-language-site-choose' => 'ভাষা অনুসন্ধান',
	'mobile-frontend-username' => 'ব্যবহারকারী নাম:',
	'mobile-frontend-password' => 'শব্দচাবি:',
	'mobile-frontend-login' => 'প্রবেশ',
	'mobile-frontend-placeholder' => '{{SITENAME}} অনুসন্ধান',
	'mobile-frontend-search-help' => 'অনুসন্ধানের বিষয়টি উপরে লিখুন এবং এর সাথে মিল রয়েছে এমন নিবন্ধের শিরনামগুলো দেখানো হবে।', # Fuzzy
	'mobile-frontend-dismiss-notification' => 'নোটিফিকেশন বন্ধ করুন',
	'mobile-frontend-clear-search' => 'পরিস্কার',
	'mobile-frontend-privacy-link-text' => 'গোপনীয়তা',
	'mobile-frontend-about-link-text' => 'পরিচিতি',
	'mobile-frontend-footer-sitename' => '{{SITENAME}}',
	'mobile-frontend-footer-contact' => 'যোগাযোগ',
	'mobile-frontend-main-menu-featured' => 'নির্বাচিত',
	'mobile-frontend-main-menu-nearby' => 'কাছাকাছি',
	'mobile-frontend-main-menu-login' => 'প্রবেশ',
	'mobile-frontend-main-menu-logout' => 'প্রস্থান',
	'mobile-frontend-main-menu-settings' => 'সেটিং',
	'mobile-frontend-main-menu-settings-heading' => 'মোবাইল সাইট সেটিং',
	'mobile-frontend-settings-site-header' => '{{SITENAME}} ভাষাসমূহ',
	'mobile-frontend-main-menu-contact' => 'যোগাযোগ',
	'mobile-frontend-page-menu-contents' => 'বিষয়বস্তু',
	'mobile-frontend-page-menu-history' => 'ইতিহাস',
);

/** Breton (brezhoneg)
 * @author Fohanno
 * @author Fulup
 * @author Y-M D
 */
$messages['br'] = array(
	'mobile-frontend-desc' => 'Talbenn evit an hezougoù',
	'mobile-frontend-search-submit' => 'Mont',
	'mobile-frontend-home-button' => 'Degemer',
	'mobile-frontend-logged-out' => "N'oc'h ket kevreet",
	'mobile-frontend-logged-in-homepage-notification' => 'Degemer mat, $1 !',
	'mobile-frontend-settings-beta' => 'Beta',
	'mobile-frontend-save-settings' => 'Enrollañ an arventennoù',
	'mobile-frontend-random-button' => 'Dargouezhek',
	'mobile-frontend-ajax-random-question' => 'Lenn ar bajenn-mañ ?',
	'mobile-frontend-ajax-random-yes' => 'Oui',
	'mobile-frontend-ajax-random-retry' => 'Esaeit en-dro',
	'mobile-frontend-ajax-random-suggestions' => 'Erbedadennoù all :',
	'mobile-frontend-back-to-top-of-section' => 'Lammat ur rann war-gil',
	'mobile-frontend-close-section' => 'Serriñ ar rann-mañ',
	'mobile-frontend-show-button' => 'Diskouez',
	'mobile-frontend-hide-button' => 'Kuzhat',
	'mobile-frontend-regular-site' => 'Gwel eus ar burev',
	'mobile-frontend-wml-continue' => "Kenderc'hel...",
	'mobile-frontend-wml-back' => 'Distreiñ...',
	'mobile-frontend-view' => 'Gwel evit an hezoug',
	'mobile-frontend-view-desktop' => 'Burev',
	'mobile-frontend-view-mobile' => 'Hezoug',
	'mobile-frontend-opt-in-explain' => "Ma kemerit perzh el labour amprouiñ e c'hallot implijout an arc'hwelioù war ziorren, ha tammoù drein a c'hallot bezañ strobet ganto.",
	'mobile-frontend-images-status' => 'Skeudennoù',
	'mobile-frontend-disable-images' => "Diweredekaat ar skeudennoù war al lec'hienn hezoug",
	'mobile-frontend-enable-images' => "Gweredekaat ar skeudennoù war al lec'hienn hezoug",
	'mobile-frontend-off' => 'LAZHET',
	'mobile-frontend-on' => 'ENAOUET',
	'mobile-frontend-footer-contributors-text' => 'Pennad kensavet gantr [$1 implijer] eveldout',
	'mobile-frontend-featured-article' => 'Un tamm sell war...',
	'mobile-frontend-news-items' => "Er C'heleier",
	'mobile-frontend-leave-feedback-notice' => "Ma roit ho soñj deomp e vimp sikouret da wellaat ar mod da embreger al lec'hienn hezoug evidoc'h. Embannet e vo ent emgefre (gant hoc'h anv implijer, stumm ho merdeer hag ho reizhiad korvoiñ) war ar bajenn&\$1quot;. Trugarez d'ober gant un titl splann, evel da sk. \"Kudennoù furmadiñ gant an taolennoù bras\". Graet e vo gant ho soñj diouzh hor reolennoù implijout.",
	'mobile-frontend-leave-feedback-subject' => 'Danvez :',
	'mobile-frontend-leave-feedback-message' => 'Kemennadenn :',
	'mobile-frontend-leave-feedback-submit' => 'Kas evezhiadennoù',
	'mobile-frontend-leave-feedback-link-text' => 'soñj war an astenn Talbenn Hezoug',
	'mobile-frontend-leave-feedback' => 'Reiñ e soñj war an Talbenn Hezoug',
	'mobile-frontend-leave-feedback-title' => "Kasit titouroù deomp diwar-benn ar pezh a soñjit eus al lec'hienn war an hezoug",
	'mobile-frontend-leave-feedback-technical-problem-section-header' => 'Kudenn deknikel',
	'mobile-frontend-leave-feedback-general-section-header' => 'Hollek',
	'mobile-frontend-leave-feedback-article-feedback-section-header' => 'Soñjoù diwar-benn ar pennad',
	'mobile-frontend-leave-feedback-email-body' => "Merkit ho chomlec'h postel a-us d'al linenn-mañ", # Fuzzy
	'mobile-frontend-leave-feedback-technical-link-text' => 'Kudenn deknikel',
	'mobile-frontend-leave-feedback-general-link-text' => 'Soñjoù dre-vras',
	'mobile-frontend-leave-feedback-article-personal-link-text' => 'Diwar ma fenn, un den, pe un embregerezh dileuriet ganin',
	'mobile-frontend-leave-feedback-article-factual-link-text' => 'Diwar-benn ur fazi war fedoù',
	'mobile-frontend-leave-feedback-article-other-link-text' => 'Diwar-benn ur gudenn all',
	'mobile-frontend-leave-feedback-form-subject-placeholder' => 'Danvez ar gemennadenn',
	'mobile-frontend-leave-feedback-form-message-placeholder' => "Merkit amañ hoc'h evezhiadennoù",
	'mobile-frontend-leave-feedback-page-title' => "Kasit titouroù deomp diwar-benn ar pezh a soñjit eus al lec'hienn war an hezoug",
	'mobile-frontend-leave-feedback-special-title' => 'Mont e darempred ganeomp',
	'mobile-frontend-feedback-no-subject' => '(danvez ebet)',
	'mobile-frontend-feedback-no-subject-field' => 'Skrivit anv un danvez bennak',
	'mobile-frontend-feedback-no-message' => 'Merkit ur gemennadenn amañ',
	'mobile-frontend-leave-feedback-thanks' => 'Trugarez da vezañ roet ho soñj.',
	'mobile-frontend-language' => 'Yezh :',
	'mobile-frontend-language-article-heading' => 'Lenn en ur yezh all',
	'mobile-frontend-language-header' => 'Ar pennad-mañ zo anezhañ e {{PLURAL:$1|yezh|yezh}}', # Fuzzy
	'mobile-frontend-language-site-choose' => 'Klask ar yezh',
	'mobile-frontend-username' => 'Anv implijer :',
	'mobile-frontend-password' => 'Ger-tremen :',
	'mobile-frontend-username-placeholder' => 'Anv implijer',
	'mobile-frontend-password-placeholder' => 'Ger-tremen',
	'mobile-frontend-login' => 'Kevreañ',
	'mobile-frontend-last-modified-date' => "Kemm diwezhañ d'an $1 da $2",
	'mobile-frontend-account-create-submit' => 'En em enskrivañ',
	'mobile-frontend-password-confirm-placeholder' => 'Kadarnaat ar ger-tremen',
	'mobile-frontend-account-create-email-placeholder' => "Chomlec'h postel (direizh)",
	'mobile-frontend-overlay-escape' => 'Distreiñ',
	'mobile-frontend-placeholder' => 'Klask e {{SITENAME}}',
	'mobile-frontend-placeholder-beta' => 'Klask {{SITENAME}} (Beta)',
	'mobile-frontend-dismiss-notification' => 'disteuler ar gemennadenn-mañ',
	'mobile-frontend-clear-search' => 'Riñsañ',
	'mobile-frontend-privacy-link-text' => 'Prevezded',
	'mobile-frontend-about-link-text' => 'Diwar-benn',
	'mobile-frontend-footer-sitename' => '{{SITENAME}}',
	'mobile-frontend-footer-contact' => 'Darempred',
	'mobile-frontend-main-menu-button-tooltip' => 'Digeriñ al lañser pennañ',
	'mobile-frontend-main-menu-featured' => 'War wel',
	'mobile-frontend-main-menu-nearby' => 'Nepell',
	'mobile-frontend-main-menu-login' => 'Kevreañ',
	'mobile-frontend-main-menu-logout' => 'Digevreañ',
	'mobile-frontend-main-menu-watchlist' => 'Roll evezhiañ',
	'mobile-frontend-main-menu-settings' => 'Arventennoù',
	'mobile-frontend-main-menu-upload' => 'Enporzhiañ', # Fuzzy
	'mobile-frontend-main-menu-settings-heading' => "Arventennoù al lec'hienn evit ar pellgomzerioù hezoug",
	'mobile-frontend-settings-site-header' => 'Yezhoù {{SITENAME}}',
	'mobile-frontend-main-menu-contact' => 'Darempred',
	'mobile-frontend-main-menu-account-create' => 'Krouiñ ur gont',
	'mobile-frontend-page-menu-contents' => 'Danvez',
	'mobile-frontend-page-menu-history' => 'Istor',
	'mobile-frontend-meta-data-issues-header' => 'Kudennoù',
	'mobile-frontend-meta-data-issues' => 'Kudennoù zo gant ar bajenn-mañ',
	'mobile-frontend-ajax-page-loading' => 'O kargañ $1',
	'mobile-frontend-page-saving' => "Oc'h enrollañ $1",
	'mobile-frontend-nearby-title' => 'Nepell',
	'mobile-frontend-nearby-distance-report' => "$1 km diouzh al lec'h m'emaoc'h",
	'mobile-frontend-photo-upload-generic' => 'Reiñ ur skeudenn',
	'mobile-frontend-donate-image-title' => 'Reiñ ur skeudenn',
	'mobile-frontend-donate-image-page-title' => 'Enporzhiañ',
	'mobile-frontend-listed-image-no-description' => 'Deskrivadur ebet',
	'mobile-frontend-watchlist-more' => "muioc'h",
	'mobile-frontend-watchlist-cta-button-login' => 'Kevreañ',
	'mobile-frontend-watchlist-cta-button-signup' => 'En em enskrivañ',
	'mobile-frontend-watchlist-a-z' => 'An holl',
	'mobile-frontend-watchlist-feed' => 'Kemmet',
	'mobile-frontend-watchlist-back-home' => "Distreiñ d'an degemer",
	'mobile-frontend-watchlist-filter-all' => 'An holl',
	'mobile-frontend-watchlist-filter-articles' => 'Pennadoù',
	'mobile-frontend-watchlist-filter-talk' => 'Kaozeal',
	'mobile-frontend-watchlist-filter-other' => 'All',
	'mobile-frontend-watchlist-modified' => '$1 kemmet',
	'mobile-frontend-diffview-title' => 'Kemmoù',
	'mobile-frontend-diffview-anonymous' => 'Implijer dizanv',
	'mobile-frontend-table' => 'Taolenn $1',
	'mobile-frontend-image-loading' => 'O kargañ ur skeudenn',
	'mobile-frontend-photo-submit' => 'Kas',
	'mobile-frontend-photo-cancel' => 'Nullañ',
	'mobile-frontend-drawer-cancel' => 'Nullañ',
);

/** Bosnian (bosanski)
 * @author CERminator
 * @author DzWiki
 */
$messages['bs'] = array(
	'mobile-frontend-desc' => 'Korisnički interfejs za mobilne uređaje',
	'mobile-frontend-search-submit' => 'Idi',
	'mobile-frontend-home-button' => 'Početna',
	'mobile-frontend-random-button' => 'Slučajni',
	'mobile-frontend-back-to-top-of-section' => 'Skoči nazad za jednu sekciju',
	'mobile-frontend-show-button' => 'Pokaži',
	'mobile-frontend-hide-button' => 'Sakrij',
	'mobile-frontend-regular-site' => 'Vidi ovu stranicu na običnoj Wikipediji', # Fuzzy
	'mobile-frontend-wml-continue' => 'Nastavi…',
	'mobile-frontend-wml-back' => 'Nazad…',
	'mobile-frontend-featured-article' => 'Odabrani članak',
);

/** Catalan (català)
 * @author Arnaugir
 * @author QuimGil
 * @author Toniher
 * @author Vriullop
 */
$messages['ca'] = array(
	'mobile-frontend-desc' => 'Interfície mòbil',
	'mobile-frontend-search-submit' => 'Vés-hi',
	'mobile-frontend-home-button' => 'Inici',
	'mobile-frontend-logged-out' => 'No heu iniciat la sessió',
	'mobile-frontend-logged-in-homepage-notification' => 'Benvingut, $1!',
	'mobile-frontend-logged-in-toast-notification' => 'Heu iniciat una sessió com a $1',
	'mobile-frontend-sign-in-heading' => 'Inicieu la sessió',
	'mobile-frontend-sign-in-why' => 'Si teniu un compte a {{SITENAME}}, podeu identificar-vos.',
	'mobile-frontend-sign-in-error-heading' => 'Renoi!',
	'mobile-frontend-settings-description' => 'Personalitzeu la vostra configuració al dispositiu mòbil amb aquests paràmetres específics.',
	'mobile-frontend-settings-beta' => 'Beta',
	'mobile-frontend-settings-alpha' => 'Versió [//ca.wikipedia.org/wiki/Hic_sunt_dracones "Aquí hi ha dracs"]',
	'mobile-frontend-settings-alpha-description' => "Entreu en territori perillós i inexplorat. Obtingueu funcionalitats encara més experimentals però amb un major risc d'errors.",
	'mobile-frontend-save-settings' => 'Desa la configuració',
	'mobile-frontend-random-button' => 'Aleatori',
	'mobile-frontend-ajax-random-heading' => 'Trobant coneixement...',
	'mobile-frontend-ajax-random-quote' => 'El creixement intel·lectual hauria de començar en néixer i finalitzar només amb la mort.',
	'mobile-frontend-ajax-random-question' => 'Llegir aquesta pàgina?',
	'mobile-frontend-ajax-random-yes' => 'Sí',
	'mobile-frontend-ajax-random-retry' => 'Torneu-ho a provar',
	'mobile-frontend-ajax-random-suggestions' => 'Altres suggeriments:',
	'mobile-frontend-back-to-top-of-section' => 'Salteu enrere una secció',
	'mobile-frontend-close-section' => 'Tanca aquesta secció',
	'mobile-frontend-show-button' => 'Mostra',
	'mobile-frontend-hide-button' => 'Amaga',
	'mobile-frontend-empty-homepage-text' => 'Aquesta pàgina d\'inici ha de ser configurada. Vegeu les <a href="http://meta.wikimedia.org/wiki/Mobile_Projects/Mobile_Gateway#Mobile_homepage">instruccions per habilitar aquest lloc per a mòbils</a>.', # Fuzzy
	'mobile-frontend-regular-site' => "Vista d'escriptori",
	'mobile-frontend-wml-continue' => 'Continua ...',
	'mobile-frontend-wml-back' => 'Enrere ...',
	'mobile-frontend-view' => 'Versió per a mòbils',
	'mobile-frontend-view-desktop' => 'Escriptori',
	'mobile-frontend-view-mobile' => 'Mòbil',
	'mobile-frontend-opt-in-explain' => 'Quan proveu la versió beta, tindreu accés a les característiques experimentals assumint el risc de trobar-hi problemes.',
	'mobile-frontend-images-status' => 'Imatges',
	'mobile-frontend-disable-images' => 'Inhabilita les imatges al lloc web mòbil',
	'mobile-frontend-enable-images' => 'Habilita les imatges al lloc web mòbil',
	'mobile-frontend-missing-image' => 'Imatge',
	'mobile-frontend-off' => 'NO',
	'mobile-frontend-on' => 'SÍ',
	'mobile-frontend-footer-contributors-text' => 'Article per [$1 coŀlaboradors] com vós',
	'mobile-frontend-featured-article' => "Article destacat d'avui",
	'mobile-frontend-news-items' => 'Actualitat',
	'mobile-frontend-leave-feedback-notice' => "Els vostres comentaris ens ajuden a millorar la experiència mòbil del lloc web. Allò que ens comenteu es publicarà públicament (amb el vostre nom d'usuari, versió de navegador i sistema operatiu) a la pàgina «$1». Proveu d'emprar una línia d'assumpte prou informativa, com ara «Problemes de format de les taules amples». Els vostres comentaris es troben subjectes als nostres termes d'ús.",
	'mobile-frontend-leave-feedback-warning' => 'A no ser que vulgueu que la vostra informació sigui pública, no afegiu informació personal en els vostres comentaris.',
	'mobile-frontend-leave-feedback-subject' => 'Assumpte:',
	'mobile-frontend-leave-feedback-message' => 'Missatge:',
	'mobile-frontend-leave-feedback-submit' => 'Tramet els comentaris',
	'mobile-frontend-leave-feedback-link-text' => 'Extensió de comentaris de la interfície mòbil',
	'mobile-frontend-leave-feedback' => 'Comentaris del lloc web mòbil',
	'mobile-frontend-leave-feedback-title' => 'Feu-nos comentaris de quina ha estat la vostra experiència des del mòbil',
	'mobile-frontend-leave-feedback-technical-problem-section-header' => 'Problema tècnic',
	'mobile-frontend-leave-feedback-general-section-header' => 'General',
	'mobile-frontend-leave-feedback-article-feedback-section-header' => "Avaluació de l'article",
	'mobile-frontend-leave-feedback-email-body' => "Escriviu la vostra adreça de correu electrònic sobre d'aquesta línia", # Fuzzy
	'mobile-frontend-leave-feedback-technical-link-text' => 'Problema tècnic',
	'mobile-frontend-leave-feedback-general-link-text' => 'Comentaris generals',
	'mobile-frontend-leave-feedback-article-personal-link-text' => 'Pel que fa a mi, una persona o una empresa que represento',
	'mobile-frontend-leave-feedback-article-factual-link-text' => 'Sobre un error factual',
	'mobile-frontend-leave-feedback-article-other-link-text' => 'Sobre altres problemes',
	'mobile-frontend-leave-feedback-form-subject-placeholder' => 'Assumpte del missatge',
	'mobile-frontend-leave-feedback-form-message-placeholder' => 'Escriviu aquí el vostre missatge',
	'mobile-frontend-leave-feedback-page-title' => 'Comentaris sobre el lloc mòbil',
	'mobile-frontend-leave-feedback-special-title' => 'Contacte',
	'mobile-frontend-feedback-no-subject' => '(sense assumpte)',
	'mobile-frontend-feedback-no-subject-field' => 'Indiqueu un assumpte',
	'mobile-frontend-feedback-no-message' => 'Escriviu un missatge aquí',
	'mobile-frontend-feedback-edit-summary' => "$1 - publicat automàticament amb l'[[Special:MobileFeedback|eina de resposta per mòbil]]",
	'mobile-frontend-leave-feedback-thanks' => 'Gràcies pels comentaris!',
	'mobile-frontend-leave-feedback-post-error' => "S'ha produït un error en processar el vostre missatge. Torneu-ho a provar més tard.",
	'mobile-frontend-language' => 'Llengua:',
	'mobile-frontend-language-article-heading' => 'Llegeix en un altre idioma',
	'mobile-frontend-language-header' => 'Aquest article està disponible en $1 {{PLURAL:$1|llengua|llengües}}', # Fuzzy
	'mobile-frontend-language-footer' => '{{SITENAME}} està disponible en altres llengües.', # Fuzzy
	'mobile-frontend-language-site-choose' => 'Cerca idioma',
	'mobile-frontend-username' => "Nom d'usuari:",
	'mobile-frontend-password' => 'Contrasenya:',
	'mobile-frontend-username-placeholder' => "Nom d'usuari",
	'mobile-frontend-password-placeholder' => 'Contrasenya',
	'mobile-frontend-login' => 'Inicia una sessió',
	'mobile-frontend-account-create-submit' => 'Registreu-vos',
	'mobile-frontend-password-confirm-placeholder' => 'Confirmeu la contrasenya:',
	'mobile-frontend-account-create-email-placeholder' => 'Correu (opcional)',
	'mobile-frontend-account-create-captcha-placeholder' => 'Introduïu el text de seguretat',
	'mobile-frontend-overlay-escape' => 'Torna',
	'mobile-frontend-placeholder' => 'Cerca a {{SITENAME}}',
	'mobile-frontend-placeholder-beta' => 'Cerca a {{SITENAME}} (Beta)',
	'mobile-frontend-placeholder-alpha' => 'Cerca a {{SITENAME}} (Versió Drac)',
	'mobile-frontend-search-help' => "Escriviu a sobre el terme a cercar i els títols d'articles coincidents apareixeran aquí.", # Fuzzy
	'mobile-frontend-dismiss-notification' => 'rebutja aquesta notificació',
	'mobile-frontend-clear-search' => 'Anuŀla',
	'mobile-frontend-privacy-link-text' => 'Privadesa',
	'mobile-frontend-about-link-text' => 'Quant a',
	'mobile-frontend-footer-sitename' => '{{SITENAME}}',
	'mobile-frontend-footer-contact' => 'Contacte',
	'mobile-frontend-search-noresults' => "Cap títol d'article coincideix amb la vostra cerca. Modifiqueu-la o utilitzeu el botó de cerca del teclat per cercar en el text dels articles.", # Fuzzy
	'mobile-frontend-main-menu-featured' => 'Destacat',
	'mobile-frontend-main-menu-nearby' => 'A prop',
	'mobile-frontend-main-menu-settings' => 'Configuració',
	'mobile-frontend-main-menu-settings-heading' => 'Configuració del lloc mòbil',
	'mobile-frontend-settings-site-header' => 'Idiomes de {{SITENAME}}',
	'mobile-frontend-settings-site-description' => '{{SITENAME}} està disponible en $1 {{PLURAL:$1|idioma|idiomes}}. Totes les versions disponibles es llisten a continuació',
	'mobile-frontend-main-menu-contact' => 'Contacte',
	'mobile-frontend-page-menu-contents' => 'continguts',
	'mobile-frontend-page-menu-history' => 'Historial',
	'tag-mobile_edit' => 'Des de mòbil',
	'tag-mobile_edit-description' => 'Modificació feta des de la versió per a mòbils',
);

/** Chechen (нохчийн)
 */
$messages['ce'] = array(
	'mobile-frontend-search-submit' => 'Дехьа вала',
	'mobile-frontend-home-button' => 'Цlехьа',
	'mobile-frontend-random-button' => 'Нисделларг',
	'mobile-frontend-back-to-top-of-section' => 'Юхагlо оцу даакъан',
	'mobile-frontend-show-button' => 'Гайта',
	'mobile-frontend-hide-button' => 'Къайла яккха',
	'mobile-frontend-regular-site' => 'Хьажа гуттаралера Википедийа агlоне', # Fuzzy
	'mobile-frontend-featured-article' => 'Хаьржина яззам',
);

/** Sorani Kurdish (کوردی)
 * @author Asoxor
 * @author Calak
 */
$messages['ckb'] = array(
	'mobile-frontend-search-submit' => 'بڕۆ',
	'mobile-frontend-home-button' => 'ماڵەوە',
	'mobile-frontend-logged-in-homepage-notification' => 'بەخێربێیت، $1!',
	'mobile-frontend-sign-in-error-heading' => 'وەی!',
	'mobile-frontend-settings-beta' => 'بێتا',
	'mobile-frontend-random-button' => 'بە ھەڵکەوت',
	'mobile-frontend-ajax-random-yes' => 'بەڵێ',
	'mobile-frontend-back-to-top-of-section' => 'بپەڕێوە بۆ بە بەشی پێشوو',
	'mobile-frontend-show-button' => 'نیشانیبدە',
	'mobile-frontend-hide-button' => 'بیشارەوە',
	'mobile-frontend-regular-site' => 'ئەم پەڕە لەسەر {{SITENAME}}ی ئاسایی ببینە', # Fuzzy
	'mobile-frontend-wml-continue' => 'درێژەی پێبدە ...',
	'mobile-frontend-wml-back' => 'بگەڕێوە ...',
	'mobile-frontend-view' => 'بینینەوەی مۆبایلی',
	'mobile-frontend-images-status' => 'وێنەکان',
	'mobile-frontend-disable-images' => 'ڕێگە مەدە بە وێنەکان لەسەر سایتی مۆبایل',
	'mobile-frontend-enable-images' => 'ڕێگە بدە بە وێنەکان لەسەر سایتی مۆبایل',
	'mobile-frontend-missing-image' => 'وێنە',
	'mobile-frontend-featured-article' => 'وتاری ھەڵبژاردەی ئەمڕۆ',
	'mobile-frontend-news-items' => 'لە ھەواڵەکاندا',
	'mobile-frontend-leave-feedback-subject' => 'بابەت', # Fuzzy
	'mobile-frontend-leave-feedback-message' => 'پەیام', # Fuzzy
	'mobile-frontend-leave-feedback-general-section-header' => 'گشتی',
	'mobile-frontend-leave-feedback-special-title' => 'پەیوەندی بگرە لەگەڵ ئێمە',
	'mobile-frontend-language' => 'زمان', # Fuzzy
	'mobile-frontend-username' => 'ناوی بەکارھێنەر:',
	'mobile-frontend-password' => 'تێپەڕوشە:',
	'mobile-frontend-username-placeholder' => 'ناوی بەکارھێنەر',
	'mobile-frontend-password-placeholder' => 'تێپەڕوشە',
	'mobile-frontend-account-create-email-placeholder' => 'ناونیشانی ئیمەیل (دڵخوازانە)',
	'mobile-frontend-overlay-escape' => 'بگەڕێوە',
	'mobile-frontend-about-link-text' => 'سەبارەت',
	'mobile-frontend-footer-contact' => 'پەیوەندی',
	'mobile-frontend-main-menu-featured' => 'تایبەتمەندییەکان',
	'mobile-frontend-main-menu-nearby' => 'لەم نزیکانەدا',
	'mobile-frontend-main-menu-login' => 'بچۆ ژوورەوە',
	'mobile-frontend-main-menu-logout' => 'بچۆ دەرەوە',
	'mobile-frontend-main-menu-watchlist' => 'پێرستی چاودێری',
	'mobile-frontend-page-menu-contents' => 'ناوەرۆکەکان',
	'mobile-frontend-page-menu-history' => 'مێژوو',
	'mobile-frontend-ajax-page-loading' => 'بارکردنی $1',
	'mobile-frontend-page-saving' => 'پاشەکەوتی $1',
	'mobile-frontend-changeslist-nocomment' => 'بەبێ کورتەی دەستکاری',
	'mobile-frontend-watchlist-filter-all' => 'ھەموو',
	'mobile-frontend-watchlist-filter-articles' => 'وتارەکان',
	'mobile-frontend-watchlist-filter-talk' => 'لێدوان',
	'mobile-frontend-watchlist-filter-other' => 'دیکە',
	'mobile-frontend-diffview-editcount' => '$1 {{PLURAL:$1|دەستکاری}}',
	'mobile-frontend-diffview-bytesadded' => '$1 {{PLURAL:$1|بایت}} زیاد کرا',
	'mobile-frontend-diffview-bytesremoved' => '$1 {{PLURAL:$1|بایت}} سڕایەوە',
);

/** Corsican (corsu)
 */
$messages['co'] = array(
	'mobile-frontend-leave-feedback-subject' => 'Sughjettu', # Fuzzy
	'mobile-frontend-leave-feedback-message' => 'Messaghju', # Fuzzy
);

/** Czech (česky)
 * @author Danny B.
 * @author JAn Dudík
 * @author Jezevec
 * @author Mormegil
 * @author Reaperman
 * @author Vks
 */
$messages['cs'] = array(
	'mobile-frontend-desc' => 'Mobilní rozhraní',
	'mobile-frontend-search-submit' => 'Hledat',
	'mobile-frontend-home-button' => 'Domů',
	'mobile-frontend-logged-out' => 'Nepřihlášen(a)',
	'mobile-frontend-logged-in-homepage-notification' => 'Vítejte, uživateli $1!',
	'mobile-frontend-logged-in-toast-notification' => '{{GENDER:$1|Přihlášen|Přihlášena}} jako $1',
	'mobile-frontend-sign-up-heading' => 'Registrace',
	'mobile-frontend-sign-in-heading' => 'Přihlásit se',
	'mobile-frontend-sign-in-why' => 'Pokud máte na {{grammar:6sg|{{SITENAME}}}} účet, můžete se níže přihlásit.',
	'mobile-frontend-settings-description' => 'Pomocí těchto nastavení specifických pro mobilní verzi si můžete web přizpůsobit svému mobilnímu zařízení.',
	'mobile-frontend-settings-beta' => 'Beta',
	'mobile-frontend-settings-alpha' => 'Režim „[//cs.wikipedia.org/wiki/Terra_incognita Zde jsou lvi]“',
	'mobile-frontend-settings-alpha-description' => 'Vstupte do nebezpečného a neprozkoumaného mobilního území. Zkuste ještě experimentálnější funkce, ale s vyšším rizikem chyb.',
	'mobile-frontend-save-settings' => 'Uložit nastavení',
	'mobile-frontend-random-button' => 'Náhodně',
	'mobile-frontend-ajax-random-heading' => 'Hledají se znalosti…',
	'mobile-frontend-ajax-random-question' => 'Přečíst tuto stránku?',
	'mobile-frontend-ajax-random-yes' => 'Ano',
	'mobile-frontend-ajax-random-retry' => 'Zkusit znovu',
	'mobile-frontend-ajax-random-suggestions' => 'Další návrhy:',
	'mobile-frontend-back-to-top-of-section' => 'Skočit zpět o sekci',
	'mobile-frontend-close-section' => 'Zavřít tuto sekci',
	'mobile-frontend-show-button' => 'Zobrazit',
	'mobile-frontend-hide-button' => 'Skrýt',
	'mobile-frontend-empty-homepage-text' => 'Tuto domácí stránku je potřeba nakonfigurovat. [//meta.wikimedia.org/wiki/Mobile_Projects/Mobile_Gateway#Mobile_homepage Instrukce, jak zprovoznit mobilní přístup k tomuto projektu]',
	'mobile-frontend-regular-site' => 'Klasické zobrazení',
	'mobile-frontend-wml-continue' => 'Pokračovat …',
	'mobile-frontend-wml-back' => 'Zpět …',
	'mobile-frontend-view' => 'Mobilní verze',
	'mobile-frontend-view-desktop' => 'Klasické',
	'mobile-frontend-view-mobile' => 'Mobilní',
	'mobile-frontend-opt-in-explain' => 'Připojením k betatestu získáte přístup k experimentálním funkcím, ale s rizikem, že narazíte na chyby a problémy.',
	'mobile-frontend-images-status' => 'Obrázky',
	'mobile-frontend-disable-images' => 'Vypnout v mobilní verzi obrázky',
	'mobile-frontend-enable-images' => 'Zapnout v mobilní verzi obrázky',
	'mobile-frontend-missing-image' => 'Obrázek',
	'mobile-frontend-off' => 'VYP',
	'mobile-frontend-on' => 'ZAP',
	'mobile-frontend-footer-contributors-text' => 'Stránka od [$1 přispěvatelů], jako jste vy',
	'mobile-frontend-featured-article' => 'Článek dne',
	'mobile-frontend-news-items' => 'Aktuality',
	'mobile-frontend-leave-feedback-notice' => 'Váš komentář bude spolu s vaším uživatelským jménem, verzí prohlížeče a operačním systémem zveřejněn na stránce „$1“',
	'mobile-frontend-leave-feedback-warning' => 'Nejste-li ochotni tyto informace zveřejnit, nevkládejte do komentáře osobní údaje.',
	'mobile-frontend-leave-feedback-subject' => 'Předmět:',
	'mobile-frontend-leave-feedback-message' => 'Zpráva:',
	'mobile-frontend-leave-feedback-submit' => 'Odeslat komentář',
	'mobile-frontend-leave-feedback-link-text' => 'Komentáře k rozšíření MobileFrontend',
	'mobile-frontend-leave-feedback' => 'Odeslat komentář',
	'mobile-frontend-leave-feedback-title' => 'Sdělte nám své zkušenosti s mobilním rozhraním',
	'mobile-frontend-leave-feedback-technical-problem-section-header' => 'Technický problém',
	'mobile-frontend-leave-feedback-general-section-header' => 'Obecné',
	'mobile-frontend-leave-feedback-article-feedback-section-header' => 'Odezva k článku',
	'mobile-frontend-leave-feedback-email-body' => 'Nad tímto řádkem popište problém, na který jste na {{grammar:6sg|{{SITENAME}}}} narazili. Uvědomte si prosím, že nemůžeme odpovídat na každou zprávu, kterou obdržíme.',
	'mobile-frontend-leave-feedback-technical-link-text' => 'Technický problém',
	'mobile-frontend-leave-feedback-general-link-text' => 'Obecný názor',
	'mobile-frontend-leave-feedback-article-personal-link-text' => 'Týkající se mě, osoby nebo společnosti, kterou zastupuji',
	'mobile-frontend-leave-feedback-article-factual-link-text' => 'Týkající se faktické chyby',
	'mobile-frontend-leave-feedback-article-other-link-text' => 'Týkající se jiného problému',
	'mobile-frontend-leave-feedback-form-subject-placeholder' => 'Předmět zprávy',
	'mobile-frontend-leave-feedback-form-message-placeholder' => 'Sem napište svůj komentář',
	'mobile-frontend-leave-feedback-page-title' => 'Sdělte nám své zkušenosti s mobilním rozhraním',
	'mobile-frontend-feedback-page' => 'Project:Komentáře k mobilnímu rozšíření',
	'mobile-frontend-leave-feedback-special-title' => 'Kontaktujte nás',
	'mobile-frontend-feedback-no-subject' => '(bez předmětu)',
	'mobile-frontend-feedback-no-subject-field' => 'Prosíme, zadejte předmět',
	'mobile-frontend-feedback-no-message' => 'Prosíme, zadejte sem zprávu',
	'mobile-frontend-feedback-edit-summary' => '$1 – automaticky vloženo pomocí [[Special:MobileFeedback|nástroje pro komentáře z mobilů]]',
	'mobile-frontend-leave-feedback-thanks' => 'Děkujeme za váš názor!',
	'mobile-frontend-leave-feedback-post-error' => 'Při zpracování vaší zprávy došlo k chybě. Zkuste to znovu o něco později.',
	'mobile-frontend-language' => 'Jazyk:',
	'mobile-frontend-language-article-heading' => 'Čtení v jiném jazyce',
	'mobile-frontend-language-header' => 'Tato stránka je k dispozici v $1 {{PLURAL:$1|jazyce|jazycích}}',
	'mobile-frontend-language-variant-header' => 'Vyberte variantu jazyka {{#language:{{CONTENTLANG}}}}',
	'mobile-frontend-language-footer' => 'Poznámka: Tato stránka nemusí být ve vašem preferovaném jazyce. Pokud chcete, můžete se podívat, jaké další jazyky {{SITENAME}} podporuje.',
	'mobile-frontend-language-site-choose' => 'Hledání jazyka',
	'mobile-frontend-username' => 'Uživatelské jméno:',
	'mobile-frontend-password' => 'Heslo:',
	'mobile-frontend-username-placeholder' => 'Uživatelské jméno',
	'mobile-frontend-password-placeholder' => 'Heslo',
	'mobile-frontend-login' => 'Přihlásit se',
	'mobile-frontend-last-modified-date' => 'Naposledy upraveno $1, v $2',
	'mobile-frontend-last-modified-seconds' => 'Naposledy změněno před {{PLURAL:$1|$1 sekundou|$1 sekundami}}',
	'mobile-frontend-last-modified-minutes' => 'Naposledy změněno před {{PLURAL:$1|$1 minutou|$1 minutami}}',
	'mobile-frontend-last-modified-hours' => 'Naposledy změněno před {{PLURAL:$1|$1 hodinou|$1 hodinami}}',
	'mobile-frontend-last-modified-days' => 'Naposledy změněno před {{PLURAL:$1|$1 dnem|$1 dny}}',
	'mobile-frontend-last-modified-months' => 'Naposledy změněno před {{PLURAL:$1|$1 měsícem|$1 měsíci}}',
	'mobile-frontend-last-modified-years' => 'Naposledy změněno před {{PLURAL:$1|$1 rokem|$1 lety}}',
	'mobile-frontend-account-create-submit' => 'Registrace',
	'mobile-frontend-password-confirm-placeholder' => 'Potvrďte heslo',
	'mobile-frontend-account-create-email-placeholder' => 'E-mailová adresa (nepovinné)',
	'mobile-frontend-account-create-captcha-placeholder' => 'Zadejte bezpečnostní text',
	'mobile-frontend-overlay-escape' => 'Zpět',
	'mobile-frontend-placeholder' => 'Hledání na {{grammar:6sg|{{SITENAME}}}}',
	'mobile-frontend-placeholder-beta' => 'Hledání ve {{grammar:6sg|{{SITENAME}}}} (beta)',
	'mobile-frontend-placeholder-alpha' => 'Hledání ve {{grammar:6sg|{{SITENAME}}}} (režim draci)',
	'mobile-frontend-search-help' => 'Nahoru napište hledaný výraz, zde se objeví názvy odpovídajících stránek.',
	'mobile-frontend-dismiss-notification' => 'zavřít toto oznámení',
	'mobile-frontend-clear-search' => 'Smazat',
	'mobile-frontend-privacy-link-text' => 'Ochrana soukromí',
	'mobile-frontend-about-link-text' => 'O aplikaci',
	'mobile-frontend-footer-sitename' => '{{SITENAME}}',
	'mobile-frontend-footer-license-text' => 'Obsah je dostupný pod [//cs.m.wikipedia.org/wiki/Wikipedie:Text_licence_Creative_Commons_Attribution-ShareAlike_3.0_Unported?useformat=mobile CC BY-SA 3.0]',
	'mobile-frontend-terms-use-text' => '[//wikimediafoundation.org/wiki/Terms_of_Use/cs?useformat=mobile Podmínky užití]',
	'mobile-frontend-footer-contact' => 'Kontakt',
	'mobile-frontend-search-noresults' => 'Vašemu hledání neodpovídají žádné názvy stránek. Změňte zadání nebo stiskněte tlačítko hledání pro hledání ve stránkách.',
	'mobile-frontend-main-menu-button-tooltip' => 'Otevřít hlavní menu',
	'mobile-frontend-main-menu-page-title' => 'Navigace po webu',
	'mobile-frontend-main-menu-featured' => 'Nejlepší',
	'mobile-frontend-main-menu-nearby' => 'Poblíž',
	'mobile-frontend-main-menu-login' => 'Přihlásit se',
	'mobile-frontend-main-menu-logout' => 'Odhlásit se',
	'mobile-frontend-main-menu-watchlist' => 'Sledované',
	'mobile-frontend-main-menu-settings' => 'Nastavení',
	'mobile-frontend-main-menu-upload' => 'Načtení souboru', # Fuzzy
	'mobile-frontend-main-menu-settings-heading' => 'Nastavení mobilní verze',
	'mobile-frontend-settings-site-header' => 'Jazyky {{grammar:2sg|{{SITENAME}}}}',
	'mobile-frontend-settings-site-description' => '{{SITENAME}} existuje v $1 {{PLURAL:$1|jazyce|jazycích}}. Níže jsou uvedeny všechny dostupné verze',
	'mobile-frontend-main-menu-contact' => 'Kontakt',
	'mobile-frontend-main-menu-account-create' => 'Vytvořit účet',
	'mobile-frontend-page-menu-contents' => 'obsah',
	'mobile-frontend-page-menu-history' => 'Historie',
	'mobile-frontend-meta-data-issues-header' => 'Nedostatky',
	'mobile-frontend-meta-data-issues' => 'Tato stránka má nedostatky',
	'mobile-frontend-ajax-page-loading' => 'Načítá se $1',
	'mobile-frontend-page-saving' => 'Ukládání $1',
	'mobile-frontend-ajax-page-error' => 'Jejda! Něco se tu pokazilo. Zkuste obnovit okno prohlížeče.',
	'mobile-frontend-nearby-title' => 'Poblíž',
	'mobile-frontend-nearby-loading' => 'Načítají se témata poblíž vaší aktuální polohy',
	'mobile-frontend-nearby-requirements' => 'Tato stránka vyžaduje JavaScript a prohlížeč se znalostí polohy.',
	'mobile-frontend-nearby-distance-report' => '$1 km od vaší aktuální polohy',
	'mobile-frontend-nearby-lookup-error' => 'Nepodařilo se nám vás najít. Zkoušíme to znovu.',
	'mobile-frontend-nearby-noresults' => 'Jste uprostřed ničeho a žádná témata jsme nedokázali najít. Proč o nějakém nenapsat?',
	'mobile-frontend-nearby-refresh' => 'Upřesnili jsme vaši polohu. Kliknutím sem můžete aktualizovat seznam blízkých stránek',
	'mobile-frontend-nearby-error' => 'Při hledání blízkých stránek došlo k neočekávané chybě',
	'mobile-frontend-donate-image-login' => 'Abyste mohli vidět své soubory, musíte se přihlásit.',
	'mobile-frontend-photo-upload-generic' => 'Darujte obrázek',
	'mobile-frontend-donate-image-title' => 'Darujte obrázek',
	'mobile-frontend-listed-image-no-description' => 'Bez popisu',
	'mobile-frontend-watchlist-add' => 'Stránka $1 přidána mezi sledované',
	'mobile-frontend-watchlist-removed' => 'Stránka $1 odebrána ze sledovaných',
	'mobile-frontend-watchlist-view' => 'Zobrazit seznam sledovaných stránek',
	'mobile-frontend-watchlist-more' => 'další',
	'mobile-frontend-watchlist-cta' => 'Pokud chcete sledovat tuto stránku, musíte se přihlásit nebo zaregistrovat.',
	'mobile-frontend-watchlist-cta-button-login' => 'Přihlásit se',
	'mobile-frontend-watchlist-cta-button-signup' => 'Zaregistrovat se',
	'mobile-frontend-watch-login' => 'Abyste mohli sledovat stránky, musíte se přihlásit.',
	'mobile-frontend-watchlist-a-z' => 'Vše',
	'mobile-frontend-watchlist-feed' => 'Změněné',
	'mobile-frontend-watchlist-a-z-empty' => 'V současné době žádné stránky nesledujete',
	'mobile-frontend-watchlist-a-z-empty-howto-alt' => 'Klikněte na hvězdičku v horní části stránky',
	'mobile-frontend-watchlist-a-z-empty-howto' => 'Stránky, které jsou pro vás zajímavé, můžete sledovat kliknutím na ikonku hvězdičky v horní části stránky. Tím si můžete vytvořit záložky na zajímavé stránky i sledovat jejich změny.',
	'mobile-frontend-watchlist-feed-empty' => 'Neexistují žádné stránky s nedávnými změnami',
	'mobile-frontend-changeslist-ip' => 'Anonymní uživatel',
	'mobile-frontend-changeslist-nocomment' => 'bez shrnutí editace',
	'mobile-frontend-watchlist-filter-all' => 'Všechno',
	'mobile-frontend-watchlist-filter-articles' => 'Články',
	'mobile-frontend-watchlist-filter-talk' => 'Diskuse',
	'mobile-frontend-watchlist-filter-other' => 'Jiné',
	'mobile-frontend-watchlist-modified' => 'Změněno $1',
	'mobile-frontend-diffview-404-title' => 'Chybná revize',
	'mobile-frontend-diffview-404-desc' => 'Požadované ID revize neexistuje',
	'mobile-frontend-diffview-title' => 'Změny',
	'mobile-frontend-diffview-editcount' => '$1 {{PLURAL:$1|editace|editace|editací}}',
	'mobile-frontend-diffview-anonymous' => 'Anonymní uživatel',
	'mobile-frontend-diffview-bytesadded' => '{{PLURAL:$1|Přidán $1 bajt|Přidány $1 bajty|Přidáno $1 bajtů}}',
	'mobile-frontend-diffview-bytesremoved' => '{{PLURAL:$1|Odebrán $1 bajt|Odebrány $1 bajty|Odebráno $1 bajtů}}',
	'mobile-frontend-diffview-explained' => 'Následující řádky byly přidány (+) a odebrány (-):',
	'mobile-frontend-table' => 'Tabulka $1',
	'mobile-frontend-saving-exit-page' => 'Váš příspěvek se stále ukládá. Pokud odejdete, budou vaše příspěvky ztraceny. Určitě chcete odejít?',
	'mobile-frontend-photo-caption-placeholder' => 'Přidejte popis (povinné)',
	'mobile-frontend-image-loading' => 'Načítá se obrázek',
	'mobile-frontend-image-uploading-long' => 'Obrázek se stále načítá! Děkujeme za trpělivost.',
	'mobile-frontend-image-uploading-cancel' => '<a href="#">Zrušit</a>, pokud to trvá příliš dlouho.',
	'mobile-frontend-photo-upload-error' => 'Chyba, zkuste to znovu.',
	'mobile-frontend-photo-upload-success-article' => 'Úspěch! Váš obrázek se nyní zobrazuje na této stránce.',
	'mobile-frontend-photo-cancel' => 'Storno',
	'mobile-frontend-photo-upload-user-count' => '{{PLURAL:$1|1 načtený soubor|$1 načtené soubory|$1 načtených souborů}}',
	'mobile-frontend-photo-upload-user-count-over-limit' => '500+ načtených souborů',
	'tag-mobile_edit' => 'Mobilní editace',
	'tag-mobile_edit-description' => 'Editace provedená ze stránek pro mobily',
	'mobile-frontend-drawer-cancel' => 'Storno',
);

/** Church Slavic (словѣ́ньскъ / ⰔⰎⰑⰂⰡⰐⰠⰔⰍⰟ)
 */
$messages['cu'] = array(
	'mobile-frontend-search-submit' => 'прѣиди',
	'mobile-frontend-home-button' => 'главьна страница',
	'mobile-frontend-random-button' => 'въ нєꙁаапѫ',
	'mobile-frontend-show-button' => 'виждь',
	'mobile-frontend-hide-button' => 'съкрꙑи',
);

/** Welsh (Cymraeg)
 * @author Lloffiwr
 * @author Robin Owain
 * @author Xxglennxx
 */
$messages['cy'] = array(
	'mobile-frontend-desc' => 'Rhaglen pen blaen i declynnau symudol',
	'mobile-frontend-search-submit' => 'Eler',
	'mobile-frontend-home-button' => 'Hafan',
	'mobile-frontend-logged-out' => 'Nid ydych wedi mewngofnodi',
	'mobile-frontend-logged-in-homepage-notification' => 'Croeso, $1!',
	'mobile-frontend-logged-in-toast-notification' => 'Mewngofnodwyd fel $1.',
	'mobile-frontend-sign-up-heading' => 'Mewngofnodwch',
	'mobile-frontend-sign-in-heading' => 'Mewngofnodwch',
	'mobile-frontend-sign-in-why' => 'Os oes gennych gyfri {{SITENAME}}, gallwch fewngofnodi isod.',
	'mobile-frontend-sign-in-error-heading' => 'WWWpsi!!',
	'mobile-frontend-save-settings' => 'Arbedwch eich dewisiadau',
	'mobile-frontend-random-button' => 'Ar hap',
	'mobile-frontend-ajax-random-heading' => 'Yn chwilio am wybodaeth...',
	'mobile-frontend-ajax-random-question' => 'Darllen y dudalen?',
	'mobile-frontend-ajax-random-yes' => 'Ie',
	'mobile-frontend-ajax-random-retry' => 'Ceisiwch eto',
	'mobile-frontend-ajax-random-suggestions' => 'Awgrymiadau eraill:',
	'mobile-frontend-back-to-top-of-section' => 'Neidio Un Adran Am Nôl',
	'mobile-frontend-close-section' => 'Ceuwch yr adran hon',
	'mobile-frontend-show-button' => 'Dangos',
	'mobile-frontend-hide-button' => 'Cuddio',
	'mobile-frontend-regular-site' => 'Gweld y fersiwn i gyfrifiadur',
	'mobile-frontend-wml-continue' => 'Parhau ...',
	'mobile-frontend-wml-back' => 'Nôl ...',
	'mobile-frontend-view' => "Golwg drwy'r teclun symudol",
	'mobile-frontend-view-mobile' => 'Teclun symudol',
	'mobile-frontend-images-status' => 'Delweddau',
	'mobile-frontend-disable-images' => 'Peidio a chaniatau delweddau ar declun symudol',
	'mobile-frontend-enable-images' => 'Caniatau delweddau ar declun symudol',
	'mobile-frontend-missing-image' => 'Delwedd',
	'mobile-frontend-featured-article' => 'Erthygl y Dydd',
	'mobile-frontend-news-items' => 'Ar y Newyddion',
	'mobile-frontend-leave-feedback-subject' => 'Pwnc:',
	'mobile-frontend-leave-feedback-message' => 'Neges:',
	'mobile-frontend-leave-feedback-submit' => 'Cyflwyner yr Adborth',
	'mobile-frontend-leave-feedback-thanks' => 'Diolch am eich adborth!',
	'mobile-frontend-language' => 'Iaith:',
	'mobile-frontend-language-site-choose' => 'Dewisiwch iaith',
	'mobile-frontend-username' => 'Enw defnyddiwr:',
	'mobile-frontend-password' => 'Cyfrinair:',
	'mobile-frontend-username-placeholder' => 'Enw defnyddiwr',
	'mobile-frontend-password-placeholder' => 'Cyfrinair',
	'mobile-frontend-login' => 'Mewngofnodi',
	'mobile-frontend-account-create-submit' => 'Cofrestru',
	'mobile-frontend-password-confirm-placeholder' => 'Gwirwch eich cyfrinair',
	'mobile-frontend-account-create-email-placeholder' => 'Cyfeiriad ebost (opsiynol)',
	'mobile-frontend-overlay-escape' => 'Ewch yn ol',
	'mobile-frontend-placeholder' => 'Chwilio {{SITENAME}}',
	'mobile-frontend-clear-search' => 'Clirio',
	'mobile-frontend-privacy-link-text' => 'Preifatrwydd',
	'mobile-frontend-about-link-text' => 'Ynglŷn â',
	'mobile-frontend-footer-sitename' => '{{SITENAME}}',
	'mobile-frontend-footer-contact' => 'Cysylltu',
	'mobile-frontend-main-menu-button-tooltip' => 'Agor y brif ddewislen',
	'mobile-frontend-main-menu-page-title' => "Fforio'r wefan",
	'mobile-frontend-main-menu-nearby' => 'Gerllaw',
	'mobile-frontend-main-menu-login' => 'Mewngofnodi',
	'mobile-frontend-main-menu-logout' => 'Allgofnodi',
	'mobile-frontend-main-menu-watchlist' => 'Rhestr wylio',
	'mobile-frontend-main-menu-settings' => 'Gosodiadau',
	'mobile-frontend-main-menu-upload' => 'Uwchlwytho', # Fuzzy
	'mobile-frontend-settings-site-header' => '{{SITENAME}} Ieithoedd',
	'mobile-frontend-main-menu-contact' => 'Cysylltu',
	'mobile-frontend-main-menu-account-create' => 'Crëwch gyfrif',
	'mobile-frontend-page-menu-contents' => 'cynnwys',
	'mobile-frontend-page-menu-history' => 'Hanes',
	'mobile-frontend-meta-data-issues-header' => 'Problemau',
	'mobile-frontend-meta-data-issues' => "Mae 'na broblem efo'r dudalen hon",
	'mobile-frontend-nearby-title' => 'Gerllaw',
	'mobile-frontend-donate-image-page-title' => 'Uwchlwytho',
	'mobile-frontend-listed-image-no-description' => 'Dim disgrifiad',
	'mobile-frontend-watchlist-more' => 'rhagor',
	'mobile-frontend-watchlist-cta-button-login' => 'Mewngofnodwch',
	'mobile-frontend-watchlist-back-home' => 'Adref',
	'mobile-frontend-watchlist-filter-all' => 'Pob un',
	'mobile-frontend-watchlist-filter-articles' => 'Erthyglau',
	'mobile-frontend-watchlist-filter-talk' => 'Sgwrs',
	'mobile-frontend-watchlist-filter-other' => 'Arall',
	'mobile-frontend-watchlist-modified' => 'Addaswyd $1',
	'mobile-frontend-diffview-title' => 'Newidiadau',
	'mobile-frontend-diffview-anonymous' => 'Defnyddiwr anhysbys',
	'mobile-frontend-photo-upload' => "Ychwanegwch y ddelwedd gyntaf i'r dudalen hon", # Fuzzy
	'mobile-frontend-image-loading' => 'Yn llwytho delwedd',
	'mobile-frontend-image-uploading-wait' => 'Uwchlwytho delwedd', # Fuzzy
	'tag-mobile_edit' => 'Golygiad drwy declyn symudol',
	'tag-mobile_edit-description' => 'Newidiwyd gyda theclyn symudol',
	'mobile-frontend-drawer-cancel' => 'Diddymu',
);

/** Danish (dansk)
 * @author Christian List
 * @author Fnielsen
 * @author Hylle
 * @author Jan Friberg
 * @author Kaare
 * @author Lokal Profil
 * @author Peter Alberti
 * @author Steenth
 * @author Tjernobyl
 */
$messages['da'] = array(
	'mobile-frontend-desc' => 'Mobil grænseflade',
	'mobile-frontend-search-submit' => 'Gå til',
	'mobile-frontend-home-button' => 'Hjem',
	'mobile-frontend-logged-out' => 'Ikke logget på',
	'mobile-frontend-logged-in-homepage-notification' => 'Velkommen, $1!',
	'mobile-frontend-logged-in-toast-notification' => 'Logget på som $1.',
	'mobile-frontend-sign-up-heading' => 'Opret en konto',
	'mobile-frontend-sign-in-heading' => 'Log på',
	'mobile-frontend-sign-in-why' => 'Hvis du har en {{SITENAME}} konto, kan du logge på nedenfor.',
	'mobile-frontend-sign-in-error-heading' => 'Ups!',
	'mobile-frontend-settings-description' => 'Tilpas din oplevelse på din mobile enhed med disse mobilspecifikke indstillinger.',
	'mobile-frontend-settings-beta' => 'Beta',
	'mobile-frontend-settings-alpha' => '[//en.wikipedia.org/wiki/Here_be_dragons Her findes drager] tilstand',
	'mobile-frontend-settings-alpha-description' => 'Gå til farlige og uudforskede mobile områder. Få endnu flere eksperimentelle funktioner, men med større risiko for fejl.',
	'mobile-frontend-save-settings' => 'Gem indstillinger',
	'mobile-frontend-random-button' => 'Tilfældig',
	'mobile-frontend-ajax-random-heading' => 'Søger efter viden...',
	'mobile-frontend-ajax-random-quote' => 'Intellektuel vækst bør påbegyndes ved fødslen og kun ophøre ved døden',
	'mobile-frontend-ajax-random-question' => 'Læs denne side?',
	'mobile-frontend-ajax-random-yes' => 'Ja',
	'mobile-frontend-ajax-random-retry' => 'Prøv igen',
	'mobile-frontend-ajax-random-suggestions' => 'Andre forslag:',
	'mobile-frontend-back-to-top-of-section' => 'Gå et afsnit tilbage',
	'mobile-frontend-close-section' => 'Luk dette afsnit',
	'mobile-frontend-show-button' => 'Vis',
	'mobile-frontend-hide-button' => 'Skjul',
	'mobile-frontend-empty-homepage-text' => 'Denne hjemmeside skal konfigureres. [//meta.wikimedia.org/wiki/Mobile_Projects/Mobile_Gateway#Mobile_homepage Instruktioner om, hvordan du får dette mobile websted aktiveret]',
	'mobile-frontend-regular-site' => 'Skrivebordsvisning',
	'mobile-frontend-wml-continue' => 'Fortsæt ...',
	'mobile-frontend-wml-back' => 'Tilbage ...',
	'mobile-frontend-view' => 'Mobilvisning',
	'mobile-frontend-view-desktop' => 'Skrivebord',
	'mobile-frontend-view-mobile' => 'Mobil',
	'mobile-frontend-opt-in-explain' => 'Ved at deltage i betaen, får du adgang til eksperimentale funktioner, med risiko for at støde på fejl og problemer.',
	'mobile-frontend-images-status' => 'Billeder',
	'mobile-frontend-disable-images' => 'Slå billeder fra på den mobile hjemmeside',
	'mobile-frontend-enable-images' => 'Slå billeder til på den mobile hjemmeside',
	'mobile-frontend-missing-image' => 'Billede',
	'mobile-frontend-off' => 'FRA',
	'mobile-frontend-on' => 'TIL',
	'mobile-frontend-footer-contributors-text' => 'Side af [$1 bidragydere] som dig',
	'mobile-frontend-featured-article' => 'Dagens artikel',
	'mobile-frontend-news-items' => 'Aktuelle begivenheder',
	'mobile-frontend-leave-feedback-notice' => 'Dine tilbagemeldinger hjælper os med at forbedre dine oplevelser med den mobile hjemmeside. De vil blive gjort offentligt tilgængelige (sammen med dit brugernavn, din browserversion og dit operativsystem) på siden &quot;$1&quot;. Forsøg venligst at vælge et meddelsomt emne som f. eks. "Formateringsproblem med brede tabeller". Dine tilbagemeldinger er genstand for vores brugsbetingelser.',
	'mobile-frontend-leave-feedback-warning' => 'Medmindre du er enig i at få dine oplysninger offentliggjort, venligst undlad personlige oplysninger i dine kommentarer.',
	'mobile-frontend-leave-feedback-subject' => 'Emne:',
	'mobile-frontend-leave-feedback-message' => 'Besked:',
	'mobile-frontend-leave-feedback-submit' => 'Send kommentar',
	'mobile-frontend-leave-feedback-link-text' => 'Tilbagemeldinger om udvidelsen til mobil grænseflade',
	'mobile-frontend-leave-feedback' => 'Giv tilbagemelding',
	'mobile-frontend-leave-feedback-title' => 'Giv os tilbagemeldinger om din oplevelse af den mobile grænseflade',
	'mobile-frontend-leave-feedback-technical-problem-section-header' => 'Teknisk problem',
	'mobile-frontend-leave-feedback-general-section-header' => 'Generelt',
	'mobile-frontend-leave-feedback-article-feedback-section-header' => 'Artikel feedback',
	'mobile-frontend-leave-feedback-email-body' => 'Beskriv det problem, du oplever med {{SITENAME}} over denne linje. Bemærk at vi ikke kan besvare alle meddelelser, vi modtager.',
	'mobile-frontend-leave-feedback-technical-link-text' => 'Teknisk problem',
	'mobile-frontend-leave-feedback-general-link-text' => 'Generel feedback',
	'mobile-frontend-leave-feedback-article-personal-link-text' => 'Om mig, en person eller et selskab jeg repræsenterer',
	'mobile-frontend-leave-feedback-article-factual-link-text' => 'Vedrørende en faktuel fejl',
	'mobile-frontend-leave-feedback-article-other-link-text' => 'Vedrørende et andet problem',
	'mobile-frontend-leave-feedback-form-subject-placeholder' => 'Emne',
	'mobile-frontend-leave-feedback-form-message-placeholder' => 'Indtast din kommentar her',
	'mobile-frontend-leave-feedback-page-title' => 'Giv os tilbagemeldinger om din oplevelse af den mobile grænseflade',
	'mobile-frontend-leave-feedback-special-title' => 'Kontakt os',
	'mobile-frontend-feedback-no-subject' => '(intet emne)',
	'mobile-frontend-feedback-no-subject-field' => 'Indtast venligst et emne',
	'mobile-frontend-feedback-no-message' => 'Indtast venligst en besked her',
	'mobile-frontend-feedback-edit-summary' => '$1 - automatisk sendt ved hjælp af [[Special:MobileFeedback|mobile feedback værktøjet]]',
	'mobile-frontend-leave-feedback-thanks' => 'Tak for dine tilbagemeldinger!',
	'mobile-frontend-leave-feedback-post-error' => 'Der opstod en fejl under behandling af din meddelelse. Prøv igen senere.',
	'mobile-frontend-language' => 'Sprog:',
	'mobile-frontend-language-article-heading' => 'Læs på et andet sprog',
	'mobile-frontend-language-header' => 'Denne side er tilgængelig på $1 {{PLURAL:$1|sprog}}',
	'mobile-frontend-language-variant-header' => 'Vælg {{#language:{{CONTENTLANG}}}} variant',
	'mobile-frontend-language-footer' => 'Bemærk: Denne side er måske ikke skrevet på dit foretrukne sprog. Du kan se hvilke sprog {{SITENAME}} understøtter ved at klikke her.',
	'mobile-frontend-language-site-choose' => 'Søgesprog',
	'mobile-frontend-username' => 'Brugernavn:',
	'mobile-frontend-password' => 'Adgangskode:',
	'mobile-frontend-username-placeholder' => 'Brugernavn',
	'mobile-frontend-password-placeholder' => 'Adgangskode',
	'mobile-frontend-login' => 'Log på',
	'mobile-frontend-last-modified-date' => 'Senest ændret $1 kl. $2',
	'mobile-frontend-last-modified-seconds' => 'Senest ændret for {{PLURAL:$1|$1 sekund|$1 sekunder}} siden',
	'mobile-frontend-last-modified-minutes' => 'Senest ændret for {{PLURAL:$1|$1 minut|$1 minutter}} siden',
	'mobile-frontend-last-modified-hours' => 'Senest ændret for {{PLURAL:$1|$1 time|$1 timer}} siden',
	'mobile-frontend-last-modified-days' => 'Senest ændret for {{PLURAL:$1|$1 dag|$1 dage}} siden',
	'mobile-frontend-last-modified-months' => 'Senest ændret for {{PLURAL:$1|$1 måned|$1 måneder}} siden',
	'mobile-frontend-last-modified-years' => 'Senest ændret for {{PLURAL:$1|$1 år}} siden',
	'mobile-frontend-account-create-submit' => 'Opret en konto',
	'mobile-frontend-password-confirm-placeholder' => 'Bekræft adgangskode',
	'mobile-frontend-account-create-email-placeholder' => 'E-mailadresse (valgfrit)',
	'mobile-frontend-account-create-captcha-placeholder' => 'Angiv sikkerhedstekst',
	'mobile-frontend-overlay-escape' => 'Gå tilbage',
	'mobile-frontend-placeholder' => 'Søg på {{SITENAME}}',
	'mobile-frontend-placeholder-beta' => 'Søg i {{SITENAME}} (Beta)',
	'mobile-frontend-placeholder-alpha' => 'Søg i {{SITENAME}} (Dragetilstand)',
	'mobile-frontend-search-help' => 'Skriv søgeordet ovenfor og matchende sidetitler vises her.',
	'mobile-frontend-dismiss-notification' => 'fjern denne besked',
	'mobile-frontend-clear-search' => 'Ryd',
	'mobile-frontend-privacy-link-text' => 'Fortrolighed',
	'mobile-frontend-about-link-text' => 'Om',
	'mobile-frontend-footer-sitename' => '{{SITENAME}}',
	'mobile-frontend-footer-license-text' => 'Indholdet er tilgængeligt under [//en.m.wikipedia.org/wiki/Wikipedia:Text_of_Creative_Commons_Attribution-ShareAlike_3.0_Unported_License?useformat=mobile CC BY-SA 3.0]',
	'mobile-frontend-terms-use-text' => '[//wikimediafoundation.org/wiki/Terms_of_use?useformat=mobile Brugsbetingelser]',
	'mobile-frontend-footer-contact' => 'Kontakt',
	'mobile-frontend-search-noresults' => 'Ingen sidetitler svarer til din søgning. Ændre søgningen, eller tryk på søgeknappen på tastaturet for at søge inde i sider.',
	'mobile-frontend-main-menu-button-tooltip' => 'Åbn hovedmenuen',
	'mobile-frontend-main-menu-page-title' => 'Navigering',
	'mobile-frontend-main-menu-featured' => 'Fremhævet',
	'mobile-frontend-main-menu-nearby' => 'I nærheden',
	'mobile-frontend-main-menu-login' => 'Log på',
	'mobile-frontend-main-menu-logout' => 'Log af',
	'mobile-frontend-main-menu-watchlist' => 'Overvågningsliste',
	'mobile-frontend-main-menu-settings' => 'Indstillinger',
	'mobile-frontend-main-menu-upload' => 'Upload',
	'mobile-frontend-main-menu-settings-heading' => 'Indstillinger for mobilside',
	'mobile-frontend-settings-site-header' => '{{SITENAME}} sprog',
	'mobile-frontend-settings-site-description' => '{{SITENAME}} er tilgængelig på $1 {{PLURAL:$1|sprog}}. Alle tilgængelige versioner vises nedenfor',
	'mobile-frontend-main-menu-contact' => 'Kontakt',
	'mobile-frontend-main-menu-account-create' => 'Opret konto',
	'mobile-frontend-page-menu-contents' => 'indhold',
	'mobile-frontend-page-menu-history' => 'Historik',
	'mobile-frontend-meta-data-issues-header' => 'Problemer',
	'mobile-frontend-meta-data-issues' => 'Denne side har nogle problemer',
	'mobile-frontend-ajax-page-loading' => 'Indlæser $1',
	'mobile-frontend-page-saving' => 'Gemmer $1',
	'mobile-frontend-ajax-page-error' => 'Ups! Noget gik galt der. Prøv at opdatere dit browservindue.',
	'mobile-frontend-nearby-title' => 'I nærheden',
	'mobile-frontend-nearby-loading' => 'Indlæser emner der ligger i nærheden',
	'mobile-frontend-nearby-requirements' => 'Denne side kræver JavaScript og en browser der kan finde din placering.',
	'mobile-frontend-nearby-distance-report' => '$1km fra din aktuelle placering',
	'mobile-frontend-nearby-lookup-error' => 'Kunne ikke finde dig. Prøver igen...',
	'mobile-frontend-nearby-noresults' => 'Du er midt i ingenting og vi kunne ikke finde nogen emner. Hvorfor ikke skrive en?',
	'mobile-frontend-photo-upload-generic' => 'Doner et billede',
	'mobile-frontend-donate-image-title' => 'Doner et billede',
	'mobile-frontend-donate-image-summary' => 'Fotos sætter liv på siden {{SITENAME}}.
Der er mange sider, som ingen fotos har på grund af en alvorlig mangel på frit licenserede billeder.
Hjælp med at bringe disse sider til live, ved at donere de billeder du er villig til at give væk, og som kunne være til nytte for det bredere {{SITENAME}} samfund.',
	'mobile-frontend-donate-image-heading' => 'Dine seneste bidrag',
	'mobile-frontend-listed-image-no-description' => 'Ingen beskrivelse',
	'mobile-frontend-watchlist-add' => 'Tilføjet $1 til din overvågningsliste',
	'mobile-frontend-watchlist-removed' => 'Fjernet $1 fra din overvågningsliste',
	'mobile-frontend-watchlist-view' => 'Se din overvågningsliste',
	'mobile-frontend-watchlist-cta' => 'Log på, eller tilmeld dig, for at se denne side.',
	'mobile-frontend-watchlist-cta-button-login' => 'Log på',
	'mobile-frontend-watchlist-cta-button-signup' => 'Tilmeld dig',
	'mobile-frontend-watchlist-a-z' => 'Alle',
	'mobile-frontend-watchlist-feed' => 'Ændrede',
	'mobile-frontend-watchlist-a-z-empty' => 'Du overvåger i øjeblikket ikke nogen sider',
	'mobile-frontend-watchlist-feed-empty' => 'Der er ingen sider med seneste ændringer',
	'mobile-frontend-changeslist-ip' => 'Anonym bruger',
	'mobile-frontend-changeslist-nocomment' => 'ingen ændringskommentar',
	'mobile-frontend-watchlist-filter-all' => 'Alle',
	'mobile-frontend-watchlist-filter-articles' => 'Artikler',
	'mobile-frontend-watchlist-filter-talk' => 'Diskussion',
	'mobile-frontend-watchlist-filter-other' => 'Øvrige',
	'mobile-frontend-watchlist-modified' => 'Ændret $1',
	'mobile-frontend-diffview-title' => 'Ændringer',
	'mobile-frontend-diffview-editcount' => '{{PLURAL:$1|én redigering|$1 redigeringer}}',
	'mobile-frontend-diffview-anonymous' => 'Anonym bruger',
	'mobile-frontend-diffview-bytesadded' => '$1 {{PLURAL:$1|byte|bytes}} tilføjet',
	'mobile-frontend-diffview-bytesremoved' => '$1 {{PLURAL:$1|byte|bytes}} fjernet',
	'mobile-frontend-diffview-explained' => 'Følgende linjer blev tilføjet (+) og fjernet (-):',
	'mobile-frontend-table' => 'Tabel $1',
	'mobile-frontend-saving-exit-page' => 'Dit bidrag bliver stadig gemt. Hvis du afslutter går dit bidrag tabt. Er du sikker på, du vil afslutte?',
	'mobile-frontend-photo-upload' => 'Tilføj det første fotografi til denne side', # Fuzzy
	'mobile-frontend-photo-article-edit-comment' => 'Tilføjet foto til brug på siden',
	'mobile-frontend-photo-article-donate-comment' => 'Giv billede fra mobil',
	'mobile-frontend-photo-upload-comment' => 'Tilføjet foto til siden',
	'mobile-frontend-photo-caption-placeholder' => 'Tilføj en billedtekst til dette billede', # Fuzzy
	'mobile-frontend-image-loading' => 'Indlæser billede',
	'mobile-frontend-image-uploading-wait' => 'Uploader billede', # Fuzzy
	'mobile-frontend-image-uploading-cancel' => '<a href="#">Afbryd</a>, hvis det tager for lang tid.',
	'mobile-frontend-photo-upload-error' => 'Der opstod en fejl, mens billedet uploadede. Prøv et andet billede.', # Fuzzy
	'mobile-frontend-photo-upload-success-article' => 'Succes! Dit billede er nu live på denne side.',
	'mobile-frontend-photo-license' => 'Bemærk: Alle billeder, du udgiver vil blive offentliggjort under en [//en.wikipedia.org/wiki/Wikipedia:Text_of_Creative_Commons_Attribution-ShareAlike_3.0_Unported_License CC BY-SA 3.0 licens]', # Fuzzy
	'mobile-frontend-photo-submit' => 'Send',
	'mobile-frontend-photo-cancel' => 'Afbryd',
	'mobile-frontend-photo-upload-user-count' => '{{PLURAL:$1|1 upload |$1 uploads}}', # Fuzzy
	'mobile-frontend-photo-upload-user-count-over-limit' => '500+ uploads',
	'tag-mobile_edit' => 'Mobilredigering',
	'tag-mobile_edit-description' => 'Redigering udført fra mobilsiden',
	'mobile-frontend-drawer-cancel' => 'Annuller',
);

/** German (Deutsch)
 * @author Als-Holder
 * @author Filzstift
 * @author Geitost
 * @author Kghbln
 * @author Metalhead64
 * @author Umherirrender
 */
$messages['de'] = array(
	'mobile-frontend-desc' => 'Ermöglicht die für mobile Endgeräte optimierte Darstellung von Seiten',
	'mobile.css' => '/* Das folgende CSS wird für alle Nutzer der Mobilen Version geladen. */',
	'mobile-frontend-search-submit' => 'Los',
	'mobile-frontend-home-button' => 'Start',
	'mobile-frontend-logged-out' => 'Nicht angemeldet',
	'mobile-frontend-logged-in-homepage-notification' => 'Willkommen, $1!',
	'mobile-frontend-logged-in-toast-notification' => 'Angemeldet als $1.',
	'mobile-frontend-sign-up-heading' => 'Registrieren',
	'mobile-frontend-sign-in-heading' => 'Registrieren',
	'mobile-frontend-sign-in-why' => 'Falls du ein {{SITENAME}}-Benutzerkonto hast, kannst du dich unten anmelden.',
	'mobile-frontend-sign-in-error-heading' => 'Hoppla!',
	'mobile-frontend-settings-description' => 'Passe dein mobiles Endgerät mit diesen Einstellungen an deine Bedürfnisse an.',
	'mobile-frontend-settings-beta' => 'Beta',
	'mobile-frontend-settings-alpha' => '[//de.wikipedia.org/wiki/Hic_sunt_dracones „Hic sunt dracones“]-Modus',
	'mobile-frontend-settings-alpha-description' => 'Steige in ein gefährliches und unentdecktes mobiles Territorium ein. Bekomme mehr experimentelle Funktionen, jedoch mit erhöhten Fehlerrisiken.',
	'mobile-frontend-save-settings' => 'Einstellungen speichern',
	'mobile-frontend-random-button' => 'Zufall',
	'mobile-frontend-ajax-random-heading' => 'Lokalisiere Wissen …',
	'mobile-frontend-ajax-random-quote' => 'Intellektuelles Wachstum sollte mit der Geburt anfangen und nur mit dem Tod aufhören',
	'mobile-frontend-ajax-random-question' => 'Diese Seite lesen?',
	'mobile-frontend-ajax-random-yes' => 'Ja',
	'mobile-frontend-ajax-random-retry' => 'Erneut versuchen',
	'mobile-frontend-ajax-random-suggestions' => 'Andere Vorschläge:',
	'mobile-frontend-back-to-top-of-section' => 'Einen Abschnitt zurück springen',
	'mobile-frontend-close-section' => 'Diesen Abschnitt schließen',
	'mobile-frontend-show-button' => 'Anzeigen',
	'mobile-frontend-hide-button' => 'Ausblenden',
	'mobile-frontend-empty-homepage-text' => 'Diese Homepage muss konfiguriert werden. [//meta.wikimedia.org/wiki/Mobile_Projects/Mobile_Gateway#Mobile_homepage Anleitungen, wie man die mobile Website aktivieren kann]',
	'mobile-frontend-regular-site' => 'Klassische Ansicht',
	'mobile-frontend-wml-continue' => 'Weiter …',
	'mobile-frontend-wml-back' => 'Zurück …',
	'mobile-frontend-view' => 'Mobile Ansicht',
	'mobile-frontend-view-desktop' => 'Klassische Ansicht',
	'mobile-frontend-view-mobile' => 'Mobil',
	'mobile-frontend-opt-in-explain' => 'Durch die Teilnahme am Beta-Test erhältst du Zugriff auf experimentelle Funktionen, die allerdings auch Probleme und Fehler verursachen können.',
	'mobile-frontend-images-status' => 'Bilder',
	'mobile-frontend-disable-images' => 'Bilder in der mobilen Ansicht deaktivieren',
	'mobile-frontend-enable-images' => 'Bilder in der mobilen Ansicht aktivieren',
	'mobile-frontend-missing-image' => 'Bild',
	'mobile-frontend-off' => 'AUS',
	'mobile-frontend-on' => 'AN',
	'mobile-frontend-footer-contributors-text' => 'Seite von [$1 Mitwirkenden] wie dir',
	'mobile-frontend-featured-article' => 'Artikel des Tages',
	'mobile-frontend-news-items' => 'In den Nachrichten',
	'mobile-frontend-leave-feedback-notice' => 'Deine Rückmeldung hilft uns dabei, die mobile Ansicht weiter zu verbessern. Sie wird öffentlich auf der Seite &quot;$1&quot; angezeigt. Dabei werden dein Benutzername, die Version des von dir genutzten Browsers sowie das von dir genutzte Betriebssystem angegeben. Bitte wähle einen informativen und aussagekräftigen Betreff, wie bswp. „Probleme bei der Anzeige von Tabellen“. Deine Rückmeldung unterliegt dabei unseren Nutzungsbedingungen.',
	'mobile-frontend-leave-feedback-warning' => 'Nimm bitte keine personenbezogenen Informationen von dir in deine Kommentare auf, es sei denn, du bist damit einverstanden, dass sie veröffentlicht werden.',
	'mobile-frontend-leave-feedback-subject' => 'Betreff:',
	'mobile-frontend-leave-feedback-message' => 'Nachricht:',
	'mobile-frontend-leave-feedback-submit' => 'Rückmeldung senden',
	'mobile-frontend-leave-feedback-link-text' => 'Rückmeldung zur mobilen Ansicht',
	'mobile-frontend-leave-feedback' => 'Rückmeldung geben',
	'mobile-frontend-leave-feedback-title' => 'Rückmeldung zur mobilen Ansicht',
	'mobile-frontend-leave-feedback-technical-problem-section-header' => 'Technisches Problem',
	'mobile-frontend-leave-feedback-general-section-header' => 'Allgemein',
	'mobile-frontend-leave-feedback-article-feedback-section-header' => 'Rückmeldung zum Artikel',
	'mobile-frontend-leave-feedback-email-body' => 'Bitte beschreibe das Problem, das du bei {{SITENAME}} entdeckt hast, oberhalb dieser Linie. Bitte bedenke, dass wir nicht auf jede Nachricht antworten können, die wir erhalten.',
	'mobile-frontend-leave-feedback-technical-link-text' => 'Technisches Problem',
	'mobile-frontend-leave-feedback-general-link-text' => 'Allgemeine Rückmeldung',
	'mobile-frontend-leave-feedback-article-personal-link-text' => 'Zu mir, einer Person oder einem Unternehmen, das ich vertrete',
	'mobile-frontend-leave-feedback-article-factual-link-text' => 'Zu einem sachlichen Fehler',
	'mobile-frontend-leave-feedback-article-other-link-text' => 'Zu einem anderen Problem',
	'mobile-frontend-leave-feedback-form-subject-placeholder' => 'Betreff der Nachricht',
	'mobile-frontend-leave-feedback-form-message-placeholder' => 'Gib deine Nachricht hier ein',
	'mobile-frontend-leave-feedback-page-title' => 'Rückmeldung zur mobilen Ansicht',
	'mobile-frontend-leave-feedback-special-title' => 'Kontaktiere uns',
	'mobile-frontend-feedback-no-subject' => '(kein Betreff)',
	'mobile-frontend-feedback-no-subject-field' => 'Bitte gib einen Betreff ein',
	'mobile-frontend-feedback-no-message' => 'Bitte gib deine Nachricht an dieser Stelle ein',
	'mobile-frontend-feedback-edit-summary' => '$1 - automatisch gespeicherte [[Special:MobileFeedback|Rückmeldung]]',
	'mobile-frontend-leave-feedback-thanks' => 'Vielen Dank für deine Rückmeldung.',
	'mobile-frontend-leave-feedback-post-error' => 'Beim Verarbeiten deiner Nachricht ist ein Fehler aufgetreten. Bitte versuche es später erneut.',
	'mobile-frontend-language' => 'Sprache:',
	'mobile-frontend-language-article-heading' => 'In einer anderen Sprache lesen',
	'mobile-frontend-language-header' => 'Diese Seite ist in {{PLURAL:$1|einer Sprache|$1 Sprachen}} verfügbar',
	'mobile-frontend-language-variant-header' => 'Variante von {{#language:{{CONTENTLANG}}}} auswählen',
	'mobile-frontend-language-footer' => 'Hinweis: Diese Seite ist möglicherweise nicht in deiner Sprache geschrieben. Du kannst einsehen, welche Sprachen {{SITENAME}} unterstützt, indem du hier klickst.',
	'mobile-frontend-language-site-choose' => 'Sprache suchen',
	'mobile-frontend-username' => 'Benutzername:',
	'mobile-frontend-password' => 'Passwort:',
	'mobile-frontend-username-placeholder' => 'Benutzername',
	'mobile-frontend-password-placeholder' => 'Passwort',
	'mobile-frontend-login' => 'Anmelden',
	'mobile-frontend-last-modified-date' => 'Zuletzt geändert am $1 um $2',
	'mobile-frontend-last-modified-seconds' => 'Zuletzt geändert vor {{PLURAL:$1|einer Sekunde|$1 Sekunden}}',
	'mobile-frontend-last-modified-minutes' => 'Zuletzt geändert vor {{PLURAL:$1|einer Minute|$1 Minuten}}',
	'mobile-frontend-last-modified-hours' => 'Zuletzt geändert vor {{PLURAL:$1|einer Stunde|$1 Stunden}}',
	'mobile-frontend-last-modified-days' => 'Zuletzt geändert vor {{PLURAL:$1|einem Tag|$1 Tagen}}',
	'mobile-frontend-last-modified-months' => 'Zuletzt geändert vor {{PLURAL:$1|einem Monat|$1 Monaten}}',
	'mobile-frontend-last-modified-years' => 'Zuletzt geändert vor {{PLURAL:$1|einem Jahr|$1 Jahren}}',
	'mobile-frontend-account-create-submit' => 'Registrieren',
	'mobile-frontend-password-confirm-placeholder' => 'Passwort bestätigen',
	'mobile-frontend-account-create-email-placeholder' => 'E-Mail-Adresse (optional)',
	'mobile-frontend-account-create-captcha-placeholder' => 'Sicherheitstext eingeben',
	'mobile-frontend-overlay-escape' => 'Zurück',
	'mobile-frontend-placeholder' => '{{SITENAME}} durchsuchen',
	'mobile-frontend-placeholder-beta' => '{{SITENAME}} durchsuchen (Beta)',
	'mobile-frontend-placeholder-alpha' => '{{SITENAME}} durchsuchen (Drachenmodus)',
	'mobile-frontend-search-help' => 'Gib oben den Suchbegriff ein. Passende Seitennamen werden dann hier angezeigt.',
	'mobile-frontend-dismiss-notification' => 'diese Benachrichtigung schließen',
	'mobile-frontend-clear-search' => 'Leeren',
	'mobile-frontend-privacy-link-text' => 'Datenschutz',
	'mobile-frontend-about-link-text' => 'Über',
	'mobile-frontend-footer-sitename' => '{{SITENAME}}',
	'mobile-frontend-footer-license-text' => 'Der Inhalt ist verfügbar unter der [//de.m.wikipedia.org/wiki/Wikipedia:Lizenzbestimmungen_Commons_Attribution-ShareAlike_3.0_Unported?useformat=mobile CC-BY-SA-3.0-Lizenz]',
	'mobile-frontend-terms-use-text' => '[//wikimediafoundation.org/wiki/Terms_of_Use/de?useformat=mobile Nutzungsbedingungen]',
	'mobile-frontend-footer-contact' => 'Kontakt',
	'mobile-frontend-search-noresults' => 'Kein Seitentitel entspricht deiner Suche. Ändere deine Suche oder drücke die Suchschaltfläche deiner Tastatur, um die Suche auf den Inhalt der Seiten auszuweiten.',
	'mobile-frontend-main-menu-button-tooltip' => 'Hauptmenü öffnen',
	'mobile-frontend-main-menu-page-title' => 'Websitenavigation',
	'mobile-frontend-main-menu-featured' => 'Exzellent',
	'mobile-frontend-main-menu-nearby' => 'In der Nähe',
	'mobile-frontend-main-menu-login' => 'Anmelden',
	'mobile-frontend-main-menu-logout' => 'Abmelden',
	'mobile-frontend-main-menu-watchlist' => 'Beobachtungsliste',
	'mobile-frontend-main-menu-settings' => 'Einstellungen',
	'mobile-frontend-main-menu-upload' => 'Hochgeladene Dateien',
	'mobile-frontend-main-menu-settings-heading' => 'Einstellungen zur mobilen Ansicht',
	'mobile-frontend-settings-site-header' => '{{SITENAME}} Sprachen',
	'mobile-frontend-settings-site-description' => '{{SITENAME}} steht in {{PLURAL:$1|einer Sprache|$1 Sprachen}} zur Verfügung. Alle verfügbaren Sprachversionen sind unten aufgeführt.',
	'mobile-frontend-main-menu-contact' => 'Kontakt',
	'mobile-frontend-main-menu-account-create' => 'Benutzerkonto erstellen',
	'mobile-frontend-page-menu-contents' => 'Inhalte',
	'mobile-frontend-page-menu-language-current' => '{{#language:{{CONTENTLANG}}}}',
	'mobile-frontend-page-menu-history' => 'Versionsgeschichte',
	'mobile-frontend-meta-data-issues-header' => 'Probleme',
	'mobile-frontend-meta-data-issues' => 'Mit dieser Seite gibt es einige Probleme',
	'mobile-frontend-ajax-page-loading' => 'Lade $1',
	'mobile-frontend-page-saving' => 'Speichere $1',
	'mobile-frontend-ajax-page-error' => 'Hoppla! Irgend etwas ist schief gelaufen. Bitte versuche, dein Browserfenster zu aktualisieren.',
	'mobile-frontend-nearby-title' => 'In der Nähe',
	'mobile-frontend-nearby-loading' => 'Themen laden, die in deiner Nähe liegen',
	'mobile-frontend-nearby-requirements' => 'Diese Seite benötigt JavaScript und einen standortbewussten Browser.',
	'mobile-frontend-nearby-distance-report' => '$1 km von deinem aktuellen Standort',
	'mobile-frontend-nearby-lookup-error' => 'Du konntest nicht gefunden werden. Bitte versuche es erneut.',
	'mobile-frontend-nearby-noresults' => 'Wir konnten leider keine Themen finden. Warum nicht selber eins verfassen?',
	'mobile-frontend-nearby-refresh' => 'Wir haben für dich einen passenderen Standort gefunden. Klicke hier, um die Liste zu aktualisieren.',
	'mobile-frontend-nearby-error' => 'Beim Auffinden von Seiten in der Nähe ist ein unerwarteter Fehler aufgetreten.',
	'mobile-frontend-donate-image-login' => 'Du musst angemeldet sein, um deine hochgeladenen Dateien anzusehen.',
	'mobile-frontend-photo-upload-generic' => 'Ein Bild spenden',
	'mobile-frontend-donate-image-title' => 'Ein Bild spenden',
	'mobile-frontend-donate-image-summary' => 'Fotos bringen die Seiten von {{SITENAME}} zum Leben.
Es gibt viele Seiten, die durch den Mangel an frei lizenzierten Fotos unbebildert sind.
Hilf mit, Leben in diese Seiten zu bringen, indem du Bilder spendest, die von der großen {{SITENAME}}-Gemeinschaft verwendet werden können.',
	'mobile-frontend-donate-image-heading' => 'Deine letzten Beiträge',
	'mobile-frontend-donate-image-page-title' => 'Hochladen',
	'mobile-frontend-donate-image-anon' => 'Um die hochgeladenen Dateien anzusehen, wird ein [[Special:UserLogin|Benutzerkonto]] benötigt',
	'mobile-frontend-listed-image-no-description' => 'Keine Beschreibung',
	'mobile-frontend-donate-photo-upload-success' => 'Erfolgreich! Dein Bild kann jetzt auf {{SITENAME}} verwendet werden!',
	'mobile-frontend-donate-photo-first-upload-success' => 'Erfolgreich! Vielen Dank für deinen ersten Beitrag!',
	'mobile-frontend-watchlist-add' => '$1 wurde zu deiner Beobachtungsliste hinzugefügt',
	'mobile-frontend-watchlist-removed' => '$1 wurde von deiner Beobachtungsliste entfernt',
	'mobile-frontend-watchlist-view' => 'Deine Beobachtungsliste ansehen',
	'mobile-frontend-watchlist-more' => 'mehr',
	'mobile-frontend-watchlist-cta' => 'Bitte melde dich an oder registriere dich, um diese Seite anzusehen.',
	'mobile-frontend-watchlist-cta-button-login' => 'Anmelden',
	'mobile-frontend-watchlist-cta-button-signup' => 'Registrieren',
	'mobile-frontend-watch-login' => 'Du musst angemeldet sein, um Seiten zu beobachten.',
	'mobile-frontend-watchlist-a-z' => 'Alle',
	'mobile-frontend-watchlist-feed' => 'Geändert',
	'mobile-frontend-watchlist-a-z-empty' => 'Du beobachtest derzeit keine Seiten',
	'mobile-frontend-watchlist-a-z-empty-howto-alt' => 'Klicke auf den Stern am Seitenanfang',
	'mobile-frontend-watchlist-a-z-empty-howto' => 'Beobachte eine Seite, die du interessant findest, indem du den Stern am Bildschirmanfang anklickst. Dies ermöglicht dir das Einmerken interessanter Seiten und das Anzeigen ihrer Änderungen.',
	'mobile-frontend-watchlist-feed-empty' => 'Es gibt keine Seiten mit kürzlich durchgeführten Änderungen',
	'mobile-frontend-watchlist-back-home' => 'Zurück zur Hauptseite',
	'mobile-frontend-changeslist-ip' => 'Anonymer Benutzer',
	'mobile-frontend-changeslist-nocomment' => 'keine Bearbeitungszusammenfassung',
	'mobile-frontend-watchlist-filter-all' => 'Alle',
	'mobile-frontend-watchlist-filter-articles' => 'Artikel',
	'mobile-frontend-watchlist-filter-talk' => 'Diskussion',
	'mobile-frontend-watchlist-filter-other' => 'Andere',
	'mobile-frontend-watchlist-modified' => 'Geändert $1',
	'mobile-frontend-diffview-404-title' => 'Ungültige Version',
	'mobile-frontend-diffview-404-desc' => 'Die Kennung für die gewünschte Version ist nicht vorhanden',
	'mobile-frontend-diffview-title' => 'Änderungen',
	'mobile-frontend-diffview-editcount' => '{{PLURAL:$1|Eine Bearbeitung|$1 Bearbeitungen}}',
	'mobile-frontend-diffview-anonymous' => 'Anonymer Benutzer',
	'mobile-frontend-diffview-bytesadded' => '{{PLURAL:$1|Ein Byte|$1 Byte}} hinzugefügt',
	'mobile-frontend-diffview-bytesremoved' => '{{PLURAL:$1|Ein Byte|$1 Byte}} entfernt',
	'mobile-frontend-diffview-explained' => 'Die folgenden Zeilen wurden hinzugefügt (+) und entfernt (−):',
	'mobile-frontend-table' => 'Tabelle $1',
	'mobile-frontend-saving-exit-page' => 'Dein Beitrag wird noch gespeichert. Beim Verlassen gehen deine Beiträge verloren. Willst du wirklich abbrechen?',
	'mobile-frontend-photo-upload' => 'Ein Bild zu diesem Artikel hinzufügen',
	'mobile-frontend-photo-article-edit-comment' => 'Foto zur Verwendung in der Seite hinzugefügt',
	'mobile-frontend-photo-article-donate-comment' => 'Gespendetes Bild von einem Mobilgerät',
	'mobile-frontend-photo-upload-comment' => 'Foto zur Seite hinzugefügt',
	'mobile-frontend-photo-caption-placeholder' => 'Füge eine Beschreibung hinzu (erforderlich)',
	'mobile-frontend-image-loading' => 'Lade Bild',
	'mobile-frontend-image-uploading-wait' => 'Lade Bild hoch. Bitte warten.',
	'mobile-frontend-image-uploading-long' => 'Bild wird hochgeladen! Danke für deine Geduld.',
	'mobile-frontend-image-uploading-cancel' => '<a href="#">Brich ab</a>, falls es zu lange dauert.',
	'mobile-frontend-photo-upload-error' => 'Fehler. Bitte erneut versuchen.',
	'mobile-frontend-photo-upload-success-article' => 'Erfolgreich! Dein Bild ist jetzt auf dieser Seite.',
	'mobile-frontend-photo-license' => 'Durch Klicken auf „Übertragen“ stimmst du unseren [//wikimediafoundation.org/wiki/Terms_of_Use/de Nutzungsbedingungen] und der Veröffentlichung deines Fotos unter der [//creativecommons.org/licenses/by-sa/3.0/deed.de Creative-Commons-Attribution-ShareAlike-3.0-Lizenz] zu.',
	'mobile-frontend-photo-submit' => 'Übertragen',
	'mobile-frontend-photo-cancel' => 'Abbrechen',
	'mobile-frontend-photo-upload-user-count' => '{{PLURAL:$1|<span>Eine</span> hochgeladene Datei|<span>$1</span> hochgeladene Dateien}}',
	'mobile-frontend-photo-upload-user-count-over-limit' => '500+ hochgeladene Dateien',
	'tag-mobile_edit' => 'Mobile Bearbeitung',
	'tag-mobile_edit-description' => 'Bearbeitet von der mobilen Website',
	'mobile-frontend-drawer-cancel' => 'Abbrechen',
);

/** Swiss High German (Schweizer Hochdeutsch)
 * @author Geitost
 */
$messages['de-ch'] = array(
	'mobile-frontend-dismiss-notification' => 'diese Benachrichtigung schliessen',
);

/** German (formal address) (Deutsch (Sie-Form)‎)
 * @author Kghbln
 */
$messages['de-formal'] = array(
	'mobile-frontend-settings-description' => 'Passen Sie Ihr mobiles Endgerät mit diesen Einstellungen an Ihre Bedürfnisse an.',
	'mobile-frontend-opt-in-explain' => 'Durch die Teilnahme am Beta-Test erhalten Sie Zugriff auf experimentelle Funktionen, die allerdings auch Probleme und Fehler verursachen können.',
	'mobile-frontend-footer-contributors-text' => 'Artikel von [$1 Mitwirkenden] wie Ihnen',
	'mobile-frontend-leave-feedback-notice' => 'Ihre Rückmeldung hilft uns dabei, die mobile Ansicht weiter zu verbessern. Sie wird öffentlich auf der Seite &quot;$1&quot; angezeigt. Dabei werden Ihr Benutzername, die Version des von Ihnen genutzten Browsers sowie das von Ihnen genutzte Betriebssystem angegeben. Bitte wählen Sie einen informativen und aussagekräftigen Betreff, wie bswp. „Probleme bei der Anzeige von Tabellen“. Ihre Rückmeldung unterliegt dabei unseren Nutzungsbedingungen.',
	'mobile-frontend-leave-feedback-warning' => 'Nehmen Sie bitte keine personenbezogenen Informationen von Ihnen in Ihre Kommentare auf, es sei denn, Sie sind damit einverstanden, dass sie veröffentlicht werden.',
	'mobile-frontend-leave-feedback-email-body' => 'Bitte beschreiben Sie das Problem, dass Sie bei {{SITENAME}} entdeckt haben, oberhalb dieser Linie. Bitte bedenken Sie, dass wir nicht auf jede Nachricht antworten können, die wir erhalten.',
	'mobile-frontend-leave-feedback-form-message-placeholder' => 'Geben Sie Ihre Nachricht hier ein',
	'mobile-frontend-feedback-no-subject-field' => 'Geben Sie einen Betreff ein',
	'mobile-frontend-feedback-no-message' => 'Bitte geben Sie Ihre Nachricht an dieser Stelle ein',
	'mobile-frontend-leave-feedback-thanks' => 'Vielen Dank für Ihre Rückmeldung.',
	'mobile-frontend-leave-feedback-post-error' => 'Beim Verarbeiten Ihrer Nachricht ist ein Fehler aufgetreten. Bitte versuchen Sie es später erneut.',
	'mobile-frontend-language-footer' => 'Hinweis: Dieser Artikel ist möglicherweise nicht in Ihrer Sprache geschrieben. Sie können einsehen, welche Sprachen {{SITENAME}} unterstützt, indem Sie hier klicken.', # Fuzzy
	'mobile-frontend-placeholder' => 'Geben Sie hier Ihre Suche ein ...', # Fuzzy
	'mobile-frontend-search-help' => 'Geben Sie oben den Suchbegriff ein. Passende Artikelnamen werden dann hier angezeigt.', # Fuzzy
	'mobile-frontend-search-noresults' => 'Kein Artikeltitel entspricht Ihrer Suche. Ändern sie Ihre Suche oder drücken Sie die Suchschaltfläche Ihrer Tastatur, um die Suche auf den Inhalt der Artikel auszuweiten.', # Fuzzy
);

/** Zazaki (Zazaki)
 * @author Erdemaslancan
 * @author Mirzali
 */
$messages['diq'] = array(
	'mobile-frontend-desc' => 'Vergılo mobil',
	'mobile-frontend-search-submit' => 'Şo',
	'mobile-frontend-home-button' => 'Keye',
	'mobile-frontend-logged-out' => 'Şıma cı nêkewtê',
	'mobile-frontend-logged-in-homepage-notification' => 'Xeyr amey, $1!',
	'mobile-frontend-logged-in-toast-notification' => 'Zey $1 cıkewtış.',
	'mobile-frontend-sign-up-heading' => 'Qeyd be',
	'mobile-frontend-sign-in-heading' => 'Qeyd be',
	'mobile-frontend-sign-in-why' => 'Eke yew hesabê {{SITENAME}} şıma esto, wa şıma şenê cêr qeyd bê.',
	'mobile-frontend-sign-in-error-heading' => 'Wey',
	'mobile-frontend-settings-description' => 'Nışanyaye sitan u mobil cihazan dı sazanê cerbnayışane xo xısusi kerê.',
	'mobile-frontend-settings-beta' => 'Beta',
	'mobile-frontend-save-settings' => 'Eyaran qeyd ke',
	'mobile-frontend-random-button' => 'Raştameye',
	'mobile-frontend-ajax-random-heading' => 'Melumat vênayış...',
	'mobile-frontend-ajax-random-quote' => 'Gırdbiyayışo fıkri gani biyayış ra dest pê kero u tenya merdış de vındeno',
	'mobile-frontend-ajax-random-question' => 'Nê meqaley bıwane?', # Fuzzy
	'mobile-frontend-ajax-random-yes' => 'Heya',
	'mobile-frontend-ajax-random-retry' => 'Fına bıcerebne',
	'mobile-frontend-ajax-random-suggestions' => 'Weseynayışê bini:',
	'mobile-frontend-back-to-top-of-section' => 'Yew cay ser çek',
	'mobile-frontend-close-section' => 'Nê leti racnê',
	'mobile-frontend-show-button' => 'Bımocne',
	'mobile-frontend-hide-button' => 'Bınımne',
	'mobile-frontend-empty-homepage-text' => 'Ena keyepela timarkerdışi nêbiya. <a href="http://meta.wikimedia.org/wiki/Mobile_Projects/Mobile_Gateway#Mobile_homepage">ena mobil sita buwanê</a>', # Fuzzy
	'mobile-frontend-regular-site' => 'Verqaydê serêmasi',
	'mobile-frontend-wml-continue' => 'Dewamê cı...',
	'mobile-frontend-wml-back' => 'Peyser...',
	'mobile-frontend-view' => 'Mobil asayış',
	'mobile-frontend-view-desktop' => 'Serê xonça',
	'mobile-frontend-view-mobile' => 'Mobil',
	'mobile-frontend-opt-in-explain' => 'Beta miyan kewtış, risko gırd esto se, cıkewtışe xısusiyeta re ray do debyo.',
	'mobile-frontend-images-status' => 'Resımi',
	'mobile-frontend-disable-images' => 'Mobile site ra resıman  racne',
	'mobile-frontend-enable-images' => 'Mobile site ra resıman aktiv kere',
	'mobile-frontend-missing-image' => 'Resım',
	'mobile-frontend-off' => 'RACNE',
	'mobile-frontend-on' => 'AKE',
	'mobile-frontend-footer-contributors-text' => 'Pela ke terefê [$1 iştıraqkeran] ra zey şıma',
	'mobile-frontend-featured-article' => 'Meqaleyê Ewroyênê Weçinıtey',
	'mobile-frontend-news-items' => 'Xeberi',
	'mobile-frontend-leave-feedback-notice' => 'Peyd rıştışe şıma mare tewr zaf rındi.ena pela do &quot;$1&quot;.  (name de karberi ra, wastekar...) tepya şari re erz bo. Şıma ra reca vatışe xo xet da "eni tabloy formule keri" sera mare fına peyd bırşe u bewni re şarte karkerdışi.',
	'mobile-frontend-leave-feedback-warning' => 'Zanışiye da şıma şari heta tesdiq nebiya, Şıma ra reca xısusi zanışe şıma wa vatışi zerre de nebe.',
	'mobile-frontend-leave-feedback-subject' => 'Mewzu:',
	'mobile-frontend-leave-feedback-message' => 'Mesac:',
	'mobile-frontend-leave-feedback-submit' => 'Peyxeberdar Bırşe',
	'mobile-frontend-leave-feedback-link-text' => 'Mobil verqayt ra peyd rıştış',
	'mobile-frontend-leave-feedback' => 'Mobil site ra peyd rıştış',
	'mobile-frontend-leave-feedback-title' => 'Mobil site ra peyd rıştış',
	'mobile-frontend-leave-feedback-technical-problem-section-header' => 'Xetaya teknike',
	'mobile-frontend-leave-feedback-general-section-header' => 'Bıngeh',
	'mobile-frontend-leave-feedback-article-feedback-section-header' => 'Peyserrıştışê meqaley',
	'mobile-frontend-leave-feedback-email-body' => 'Xet da cori ra şıma ra recayma problemê esto sê bırışê {{SITENAME}}.Enay bızanê ke ma mesaca pêron rê hema nêşem cewab bıdêm.',
	'mobile-frontend-leave-feedback-technical-link-text' => 'Teknik xeta',
	'mobile-frontend-leave-feedback-general-link-text' => 'Seran peyd rıştış',
	'mobile-frontend-leave-feedback-article-personal-link-text' => 'Heqa mı zi, ez merduma yana ez yew şirketa',
	'mobile-frontend-leave-feedback-article-factual-link-text' => 'Mı het ke xetaya fabrikasyona',
	'mobile-frontend-leave-feedback-article-other-link-text' => 'Mı het ke zewbi xeta esto',
	'mobile-frontend-leave-feedback-form-subject-placeholder' => 'Mersela mesaci',
	'mobile-frontend-leave-feedback-form-message-placeholder' => 'Babeta vatışte şıma',
	'mobile-frontend-leave-feedback-page-title' => 'Mobil site ra peyd rıştış',
	'mobile-frontend-leave-feedback-special-title' => 'Ma de irtıbat kewê',
	'mobile-frontend-feedback-no-subject' => '(mewzu çıniyo)',
	'mobile-frontend-feedback-no-subject-field' => 'Şıma ra reca vatışi tiya rone',
	'mobile-frontend-feedback-no-message' => 'Şıma ra reca mesace xo dekere tiya',
	'mobile-frontend-feedback-edit-summary' => '$1 - postey xo otomatik akar fiye [[Special:MobileFeedback|mobile peyd rıştış ]] dı',
	'mobile-frontend-leave-feedback-thanks' => 'Kande peyd rıştışi homay şıma ra razi bo!',
	'mobile-frontend-leave-feedback-post-error' => 'Mesaj karkerdeış de xırabin vıciye, Reca kem fına bıcerbne.',
	'mobile-frontend-language' => 'Zıwan:',
	'mobile-frontend-language-article-heading' => 'Zıwanê bin de bıwane',
	'mobile-frontend-language-header' => 'Na wesiqa {{PLURAL:$1|zıwan dê|zıwanan dê}} $1 dı esta', # Fuzzy
	'mobile-frontend-language-footer' => 'Not: Na wesiqa zıwan de iıma de nênusêna. Şıma şenê {{SITENAME}} ra qeydê zıwan de xo qebul kerê.', # Fuzzy
	'mobile-frontend-language-site-choose' => 'Bı geyr zıwan',
	'mobile-frontend-username' => 'Nameyê karberi:',
	'mobile-frontend-password' => 'Parola:',
	'mobile-frontend-username-placeholder' => 'Nameyê karberi',
	'mobile-frontend-password-placeholder' => 'Parola',
	'mobile-frontend-login' => 'Qeyd be',
	'mobile-frontend-overlay-escape' => 'Peyser şo',
	'mobile-frontend-placeholder' => '{{SITENAME}} de cıgeyre',
	'mobile-frontend-placeholder-beta' => '{{SITENAME}} de cı geyre (Beta)',
	'mobile-frontend-search-help' => 'Babeta cı geyrayışi terim u wesiqeyo hewl bo se odo itad bıaso.', # Fuzzy
	'mobile-frontend-dismiss-notification' => 'Eno xeberdayışê wezifayo',
	'mobile-frontend-clear-search' => 'Pak ke',
	'mobile-frontend-privacy-link-text' => 'Nımıtış',
	'mobile-frontend-about-link-text' => 'Heqa cı de',
	'mobile-frontend-footer-sitename' => '{{SITENAME}}',
	'mobile-frontend-footer-contact' => 'İrtıbat',
	'mobile-frontend-search-noresults' => 'Sernameyo ke şımayê geyrenê wesiqeyo do wuni çıniyo. Cı geyreyışê xo bıvurnê yana zerrey wesiqer de cıgeyrayışi re klawye ra butona cıgeyrayışi pıploğne.', # Fuzzy
	'mobile-frontend-main-menu-button-tooltip' => 'Menuyê bıngehi ake',
	'mobile-frontend-main-menu-page-title' => 'Pusulaya sita',
	'mobile-frontend-main-menu-featured' => 'Weçinıte',
	'mobile-frontend-main-menu-nearby' => 'Nezdi de',
	'mobile-frontend-main-menu-login' => 'Cı kewe',
	'mobile-frontend-main-menu-logout' => 'Bıveciye',
	'mobile-frontend-main-menu-watchlist' => 'Lista seyri',
	'mobile-frontend-main-menu-settings' => 'Eyari',
	'mobile-frontend-main-menu-settings-heading' => 'Eyarê sita mobile',
	'mobile-frontend-settings-site-header' => 'Zıwanê {{SITENAME}}',
	'mobile-frontend-settings-site-description' => '{{SITENAME}} de $1 {{PLURAL:$1|zıwan mewcudo|zıwani mewcudê}}. Versiyonê cıyê bini lista cêrêne de estê.',
	'mobile-frontend-main-menu-contact' => '
İrtıbat',
	'mobile-frontend-main-menu-account-create' => 'Hesab vıraze',
	'mobile-frontend-page-menu-contents' => 'tedeestey',
	'mobile-frontend-page-menu-language-current' => '{{#language:{{CONTENTLANG}}}}',
	'mobile-frontend-page-menu-history' => 'Tarix',
	'mobile-frontend-meta-data-issues-header' => 'Meseley',
	'mobile-frontend-meta-data-issues' => 'Na pele de tayê meseley estê',
	'mobile-frontend-ajax-page-loading' => '$1 bar beno',
	'mobile-frontend-page-saving' => '$1 qeyd beno',
	'mobile-frontend-ajax-page-error' => 'Wey! Tayê çi ters şi. Şıma ra reca ma awa ke pençereyê cıgeyrayoğê xo newe ra bıcerebnên.',
	'mobile-frontend-watchlist-add' => '$1 bi zerreyê lista seyrkerdışê şıma',
	'mobile-frontend-watchlist-removed' => 'Lista şımaya serykerdışi ra $1 wedariya.',
	'mobile-frontend-watchlist-view' => 'Lista serykerdışê xo bıvêne',
	'mobile-frontend-changeslist-ip' => 'IP', # Fuzzy
	'mobile-frontend-changeslist-nocomment' => 'nê vurnaye xulasa',
	'mobile-frontend-watchlist-filter-all' => 'Pêro',
	'mobile-frontend-watchlist-filter-articles' => 'Wesiqey',
	'mobile-frontend-watchlist-filter-talk' => 'Werênayış',
	'mobile-frontend-watchlist-filter-other' => 'Zewmi',
	'mobile-frontend-diffview-title' => 'Vurnayışê $1', # Fuzzy
	'mobile-frontend-diffview-editcount' => '$1 {{PLURAL:$1|vurnayiş|vurnayişi}}',
	'mobile-frontend-diffview-anonymous' => 'Karbero anonim',
	'mobile-frontend-diffview-bytesadded' => '$1 {{PLURAL:$1|bayt|bayti}} debiyay de',
	'mobile-frontend-diffview-bytesremoved' => '$1 {{PLURAL:$1|bayt|bayti}} wedariyay',
	'mobile-frontend-table' => 'Tabloye $1',
	'mobile-frontend-photo-upload' => 'Resımê sıfteyıni na pele ke', # Fuzzy
	'mobile-frontend-photo-article-edit-comment' => 'Seba gurenayışi resım bi be pele',
	'mobile-frontend-photo-upload-comment' => 'Resım bi be pele',
	'mobile-frontend-photo-caption-placeholder' => 'Seba nê resımi yew sernote cı ke', # Fuzzy
	'mobile-frontend-image-loading' => 'Barkerdışê resımi',
	'mobile-frontend-image-uploading-wait' => 'Resım bar beno, kerem ke sero bıvınde.',
	'mobile-frontend-photo-license' => 'Note: Resımê ke şıma pêro weşanenê bınê [//en.wikipedia.org/wiki/Wikipedia:Text_of_Creative_Commons_Attribution-ShareAlike_3.0_Unported_License CC BY-SA 3.0 lisans]i de weşaniyenê.', # Fuzzy
	'mobile-frontend-photo-cancel' => 'Bıtexelne',
	'mobile-frontend-drawer-cancel' => 'Bıtexelne',
);

/** Lower Sorbian (dolnoserbski)
 * @author Michawiki
 */
$messages['dsb'] = array(
	'mobile-frontend-desc' => 'Zwobraznjenje bokow za mobilne kóńcne rědy',
	'mobile-frontend-search-submit' => 'Wótpósłaś',
	'mobile-frontend-home-button' => 'Start',
	'mobile-frontend-logged-out' => 'Njepśizjawjony',
	'mobile-frontend-logged-in-homepage-notification' => 'Witaj, $1',
	'mobile-frontend-logged-in-toast-notification' => 'Pśizjawjony ako $1',
	'mobile-frontend-sign-up-heading' => 'Registrěrowaś',
	'mobile-frontend-sign-in-heading' => 'Registrěrowaś',
	'mobile-frontend-sign-in-why' => 'Jolic maš konto na {{GRAMMAR:lokatiw|{{SITENAME}}}}, móžoš se dołojce registrěrowaś.',
	'mobile-frontend-sign-in-error-heading' => 'Hopla',
	'mobile-frontend-settings-description' => 'Pśiměŕ swój mobilny rěd z toś tymi mobilnymi specifiskimi nastajenjami.',
	'mobile-frontend-settings-beta' => 'Beta',
	'mobile-frontend-settings-alpha' => 'Modus [//de.wikipedia.org/wiki/Hic_sunt_dracones „Hic sunt dracones“]',
	'mobile-frontend-save-settings' => 'Nastajenja składowaś',
	'mobile-frontend-random-button' => 'Pśipadny',
	'mobile-frontend-ajax-random-heading' => 'Wěda se pyta...',
	'mobile-frontend-ajax-random-quote' => 'Intelektualny rost by měł se z narodom zachopiś a ze smjerśu pśestaś',
	'mobile-frontend-ajax-random-question' => 'Toś ten bok cytaś?',
	'mobile-frontend-ajax-random-yes' => 'Jo',
	'mobile-frontend-ajax-random-retry' => 'Hyšći raz wopytaś',
	'mobile-frontend-ajax-random-suggestions' => 'Druge naraźenja:',
	'mobile-frontend-back-to-top-of-section' => 'Wótrězk slědk skócyś',
	'mobile-frontend-close-section' => 'Toś ten wótrězk zacyniś',
	'mobile-frontend-show-button' => 'Pokazaś',
	'mobile-frontend-hide-button' => 'Schowaś',
	'mobile-frontend-empty-homepage-text' => 'Toś ten startowy bok musy se konfigurěrowaś. [//meta.wikimedia.org/wiki/Mobile_Projects/Mobile_Gateway#Mobile_homepage Instrukcije, kak dajo se toś to mobilne websedło zmóžniś]',
	'mobile-frontend-regular-site' => 'Klasiski naglěd',
	'mobile-frontend-wml-continue' => 'Dalej ...',
	'mobile-frontend-wml-back' => 'Slědk ...',
	'mobile-frontend-view' => 'Mobilny naglěd',
	'mobile-frontend-view-desktop' => 'Desktop',
	'mobile-frontend-view-mobile' => 'Mobilny',
	'mobile-frontend-opt-in-explain' => 'Pśez wobźělenje na betatesće, změjoš pśistup na eksperimentelne funkcije, kótarež pak mógu zmólki a problemy zawinowaś.',
	'mobile-frontend-images-status' => 'Wobraze',
	'mobile-frontend-disable-images' => 'Wobraze w mobilnem naglěźe znjemóžniś',
	'mobile-frontend-enable-images' => 'Wobraze w mobilnem naglěźe zmóžniś',
	'mobile-frontend-missing-image' => 'Wobraz',
	'mobile-frontend-off' => 'WUŠALTOWANY',
	'mobile-frontend-on' => 'ZAŠALTOWANY',
	'mobile-frontend-footer-contributors-text' => 'Bok wót [$1 awtorow] ako ty',
	'mobile-frontend-featured-article' => 'Nastawk dnja',
	'mobile-frontend-news-items' => 'W nowosćach',
	'mobile-frontend-leave-feedback-notice' => 'Twóje komentary pomagaju nam mobilne sedło pólěpšyś. Wozjawja se z wužywarskim mjenim, wersiju wobglědowaka a źěłowym systemom na boku &quot;$1&quot;. Pšosym wubjeŕ wugroniwu temu, na ps. "Problemy pśi formatěrowanju tabelow". Twóje komentary pódlaže našym wužywarskim wuměnjenjam.',
	'mobile-frontend-leave-feedback-warning' => 'Pšosym njezapśimjej wósobinske informacije do swójich komentarow, mimo až sy wobjadny, až se twóje informacije wózjawiju.',
	'mobile-frontend-leave-feedback-subject' => 'Tema:',
	'mobile-frontend-leave-feedback-message' => 'Powěsć:',
	'mobile-frontend-leave-feedback-submit' => 'Komentar wótpósłaś',
	'mobile-frontend-leave-feedback-link-text' => 'Komentary k rozšyrjenjeju MobileFrontend',
	'mobile-frontend-leave-feedback' => 'Komentary wó mobilnem sedle',
	'mobile-frontend-leave-feedback-title' => 'Komentary wó mobilnem sedle',
	'mobile-frontend-leave-feedback-technical-problem-section-header' => 'Techniski problem',
	'mobile-frontend-leave-feedback-general-section-header' => 'Powšykny',
	'mobile-frontend-leave-feedback-article-feedback-section-header' => 'Komentary k nastawkam',
	'mobile-frontend-leave-feedback-email-body' => 'Pšosym wopisaj problem, na kótaryž sy z {{GRAMMAR:instrumental|{{SITENAME}}}} wuše toś teje linije starcył. Pšosym źiwaj na to, až njamóžomy na kuždu powěsć wótegroniś, kótaruž dostawamy.',
	'mobile-frontend-leave-feedback-technical-link-text' => 'Techniski problem',
	'mobile-frontend-leave-feedback-general-link-text' => 'Powšykne komentary',
	'mobile-frontend-leave-feedback-article-personal-link-text' => 'Nastupajucy mě, wósobu abo pśedewześe, kótarež reprezentěrujom',
	'mobile-frontend-leave-feedback-article-factual-link-text' => 'Nastupajucy wěcownu zmólku',
	'mobile-frontend-leave-feedback-article-other-link-text' => 'Nastupajucy drugi problem',
	'mobile-frontend-leave-feedback-form-subject-placeholder' => 'Tema powěsći',
	'mobile-frontend-leave-feedback-form-message-placeholder' => 'Zapódaj how swój komentar',
	'mobile-frontend-leave-feedback-page-title' => 'Komentary wó mobilnem sedle',
	'mobile-frontend-leave-feedback-special-title' => 'Kontaktěruj se z nami',
	'mobile-frontend-feedback-no-subject' => '(žedna tema)',
	'mobile-frontend-feedback-no-subject-field' => 'Pšosym zapódaj temu',
	'mobile-frontend-feedback-no-message' => 'Pšosym zapódaj how powěźeńku',
	'mobile-frontend-feedback-edit-summary' => '$1 - z [[Special:MobileFeedback|mobilnym komentarowym rědom]] awtomatiski rozpósłany',
	'mobile-frontend-leave-feedback-thanks' => 'Źěkujomy se za twój komentar!',
	'mobile-frontend-leave-feedback-post-error' => 'Pśi pśeźěłowanju twójeje powěsći jo zmólka nastała.
Pšosym wopytaj pózdźej hyšći raz.',
	'mobile-frontend-language' => 'Rěc:',
	'mobile-frontend-language-article-heading' => 'W drugej rěcy cytaś',
	'mobile-frontend-language-header' => 'Toś ten bok stoj w $1 {{PLURAL:$1|rěcy|rěcoma|rěcach}} k dispoziciji',
	'mobile-frontend-language-variant-header' => 'Wariantu rěcy {{#language:{{CONTENTLANG}}}} wubraś',
	'mobile-frontend-language-footer' => 'Glědaj: Toś ten bok njejo snaź w twójej preferěrowanej rěcy napisał. Móžoš wiźeś, kótare rěcy {{SITENAME}} pódpěra, z tym až kliknjoš how.',
	'mobile-frontend-language-site-choose' => 'Rěc pytaś',
	'mobile-frontend-username' => 'Wužywarske mě:',
	'mobile-frontend-password' => 'Gronidło:',
	'mobile-frontend-username-placeholder' => 'Wužywarske mě',
	'mobile-frontend-password-placeholder' => 'Gronidło',
	'mobile-frontend-login' => 'Pśizjawiś',
	'mobile-frontend-account-create-submit' => 'Registrěrowaś',
	'mobile-frontend-password-confirm-placeholder' => 'Gronidło wobkšuśiś',
	'mobile-frontend-account-create-email-placeholder' => 'E-mailowa adresa (opcionalny)',
	'mobile-frontend-account-create-captcha-placeholder' => 'Wěstotny tekst zapódaś',
	'mobile-frontend-overlay-escape' => 'Slědk',
	'mobile-frontend-placeholder' => '{{GRAMMAR:akuzatiw|{{SITENAME}}}} pśepytaś',
	'mobile-frontend-placeholder-beta' => '{{GRAMMAR:akuzatiw|{{SITENAME}}}} pśepytaś (beta)',
	'mobile-frontend-placeholder-alpha' => '{{GRAMMAR:akuzatiw|{{SITENAME}}}} pśepytaś (plonowy modus)',
	'mobile-frontend-search-help' => 'Zapiš górjejce pytańske zapśimjeśe a wótpowědne bokowe titele budu se how pokazaś.',
	'mobile-frontend-dismiss-notification' => 'Toś tu powěźeńku zachyśiś',
	'mobile-frontend-clear-search' => 'Wuprozniś',
	'mobile-frontend-privacy-link-text' => 'Priwatnosć',
	'mobile-frontend-about-link-text' => 'Wó',
	'mobile-frontend-footer-sitename' => '{{SITENAME}}',
	'mobile-frontend-footer-license-text' => 'Wopśimjeśe stoj pód licencu [//de.m.wikipedia.org/wiki/Wikipedia:Lizenzbestimmungen_Commons_Attribution-ShareAlike_3.0_Unported?useformat=mobile CC-BY-SA-3.0] k dispoziciji',
	'mobile-frontend-terms-use-text' => '[//wikimediafoundation.org/wiki/Terms_of_Use/de?useformat=mobile wužywarske wuměnjenja] (nimski)',
	'mobile-frontend-footer-contact' => 'Kontakt',
	'mobile-frontend-search-noresults' => 'Twójomu pytanjeju žedne bokowe titele njewotpówěduju. Změń swójo pytanje abo tłoc pytańsku tastu swójeje tastatury, aby w bokach pytał.',
	'mobile-frontend-main-menu-button-tooltip' => 'Głowny meni wócyniś',
	'mobile-frontend-main-menu-page-title' => 'Sedłowa nawigacija',
	'mobile-frontend-main-menu-featured' => 'Nabejny',
	'mobile-frontend-main-menu-nearby' => 'W bliskosći',
	'mobile-frontend-main-menu-login' => 'Pśizjawiś',
	'mobile-frontend-main-menu-logout' => 'Wótzjawiś',
	'mobile-frontend-main-menu-watchlist' => 'Wobglědowańka',
	'mobile-frontend-main-menu-settings' => 'Nastajenja',
	'mobile-frontend-main-menu-upload' => 'Nagraśa',
	'mobile-frontend-main-menu-settings-heading' => 'Mobilne nastajenja',
	'mobile-frontend-settings-site-header' => 'Rěcy {{GRAMMAR:genitiw|{{SITENAME}}}}',
	'mobile-frontend-settings-site-description' => '{{SITENAME}} stoj w $1 {{PLURAL:$1|rěcy|rěcoma|rěcach|rěcach}} k dispoziciji. Wšykne k dispoziciji stojece wersije su dołojce nalicone:',
	'mobile-frontend-main-menu-contact' => 'Kontakt',
	'mobile-frontend-main-menu-account-create' => 'Konto załožyś',
	'mobile-frontend-page-menu-contents' => 'wopśimjeśe',
	'mobile-frontend-page-menu-history' => 'Historija',
	'mobile-frontend-meta-data-issues-header' => 'Problemy',
	'mobile-frontend-meta-data-issues' => 'Toś ten bok ma problemy',
	'mobile-frontend-ajax-page-loading' => '$1 se zacytujo',
	'mobile-frontend-page-saving' => '$1 se składujo',
	'mobile-frontend-ajax-page-error' => 'Hopla! Něco jo se njeraźiło. Pšosym wopytaj wokno swójogo wobglědowaka aktualizěrowaś.',
	'mobile-frontend-nearby-title' => 'W bliskosći',
	'mobile-frontend-nearby-distance-report' => '$1 km wót twójogo aktualnego městna',
	'mobile-frontend-nearby-lookup-error' => 'Njejo móžno śi namakaś. Wopytaj hyšći raz.',
	'mobile-frontend-donate-image-login' => 'Musyš pśizjawjony byś, aby swóje nagraśa wiźeł.',
	'mobile-frontend-photo-upload-generic' => 'Wobraz pósćiś',
	'mobile-frontend-donate-image-title' => 'Wobraz pósćiś',
	'mobile-frontend-donate-image-heading' => 'Twóje nejnowše pśinoski',
	'mobile-frontend-donate-image-page-title' => 'Nagraś',
	'mobile-frontend-donate-image-anon' => 'Trjebaš [[Special:UserLogin|wužywarske konto]], aby se bok nagraśow woglědał',
	'mobile-frontend-listed-image-no-description' => 'Žedne wopisanje',
	'mobile-frontend-donate-photo-upload-success' => 'Wuspěch! Twój wobraz dajo se něnto na {{GRAMMAR:lokatiw|{{SITENAME}}}} wužywaś!',
	'mobile-frontend-donate-photo-first-upload-success' => 'Wuspěch! Wjeliki źěk za twój prědny pśinosk!',
	'mobile-frontend-watchlist-add' => '$1 jo se wobglědowańkam pśidał',
	'mobile-frontend-watchlist-removed' => '$1 jo se z wobglědowańkow wótpórał',
	'mobile-frontend-watchlist-view' => 'Se wobglědowańki woglědaś',
	'mobile-frontend-watchlist-more' => 'wěcej',
	'mobile-frontend-watchlist-cta' => 'Pšosym pśizjaw se abo zregistrěruj se, aby toś ten bok wobglědował.',
	'mobile-frontend-watchlist-cta-button-login' => 'Pśizjawiś',
	'mobile-frontend-watchlist-cta-button-signup' => 'Registrěrowaś',
	'mobile-frontend-watch-login' => 'Musyš pśizjawjony byś, aby dataje wobglědował.',
	'mobile-frontend-watchlist-a-z' => 'Wšykne',
	'mobile-frontend-watchlist-feed' => 'Změnjony',
	'mobile-frontend-watchlist-a-z-empty' => 'Njewobglědujoš tuchylu žedne boki',
	'mobile-frontend-watchlist-a-z-empty-howto-alt' => 'Klikni na gwězdku górjejce na boku',
	'mobile-frontend-watchlist-feed-empty' => 'Njejsu žedne boki z nowymi změnami',
	'mobile-frontend-watchlist-back-home' => 'Slědk k startowemu bokoju',
	'mobile-frontend-changeslist-ip' => 'Anonymny wužywaŕ',
	'mobile-frontend-changeslist-nocomment' => 'žedne zespominanje wobźěłanja',
	'mobile-frontend-watchlist-filter-all' => 'Wšykne',
	'mobile-frontend-watchlist-filter-articles' => 'Nastawki',
	'mobile-frontend-watchlist-filter-talk' => 'Diskusija',
	'mobile-frontend-watchlist-filter-other' => 'Druge',
	'mobile-frontend-watchlist-modified' => 'Změnjony $1',
	'mobile-frontend-diffview-404-title' => 'Njepłaśiwa wersija',
	'mobile-frontend-diffview-404-desc' => 'ID za póžedanu wersiju njeeksistěrujo',
	'mobile-frontend-diffview-title' => 'Změny',
	'mobile-frontend-diffview-editcount' => '$1 {{PLURAL:$1|změna|změnje|změny|změnow}}',
	'mobile-frontend-diffview-anonymous' => 'Anonymny wužywaŕ',
	'mobile-frontend-diffview-bytesadded' => '$1 {{PLURAL:$1|byte pśidany|byta pśidanej|byty pśidane|bytow pśidane}}',
	'mobile-frontend-diffview-bytesremoved' => '$1 {{PLURAL:$1|byte wótpórany|byta wótpóranej|byty wótpórane|bytow wótpórane}}',
	'mobile-frontend-diffview-explained' => 'Slědujuce smužki su se pśidali (+) a wótpórali (-):',
	'mobile-frontend-table' => 'Tabela $1',
	'mobile-frontend-saving-exit-page' => 'Twój pśinosk hyšći se składujo. Jolic něnto kóńcyš, se twóje pśinoski zgubiju. Coš napšawdu kóńcyś?',
	'mobile-frontend-photo-upload' => 'Wobraz toś tomu nastawkoju pśidaś',
	'mobile-frontend-photo-article-edit-comment' => 'Foto za wužywanje w boku pśidane',
	'mobile-frontend-photo-article-donate-comment' => 'Pósćony wobraz z mobilnego rěda',
	'mobile-frontend-photo-upload-comment' => 'Foto bokoju pśidane',
	'mobile-frontend-photo-caption-placeholder' => 'Wopisanje pśidaś (trěbne)',
	'mobile-frontend-image-loading' => 'Wobraz se zacytujo',
	'mobile-frontend-image-uploading-wait' => 'Wobraz se nagrawa, pšosym cakaj.',
	'mobile-frontend-image-uploading-long' => 'Wobraz se hyšći nagrawa! Źěkujomy se za twóju sćerpnosć.',
	'mobile-frontend-image-uploading-cancel' => '<a href="#">Pśetergni</a>, jolic to traje pśedłujko.',
	'mobile-frontend-photo-upload-error' => 'Zmólka, wopytaj hyšći raz.',
	'mobile-frontend-photo-upload-success-article' => 'Wuspěch! Twój wobraz jo něnto na toś tom boku.',
	'mobile-frontend-photo-license' => 'Gaž kliknjoš na "Wótpósłaś" zwólijoš do našych [//wikimediafoundation.org/wiki/Terms_of_use wužywarskich wuměnjenjow] a pśizwólijoš swóje foto pód licencu  [//creativecommons.org/licenses/by-sa/3.0/ Creative Commons Attribution-ShareAlike 3.0] wózjawiś.',
	'mobile-frontend-photo-submit' => 'Wótpósłaś',
	'mobile-frontend-photo-cancel' => 'Pśetergnuś',
	'mobile-frontend-photo-upload-user-count' => '{{PLURAL:$1|1 nagraśe|$1 nagraśi|$1 nagraśa|$1 nagraśow}}', # Fuzzy
	'mobile-frontend-photo-upload-user-count-over-limit' => '500+ nagratych datajow',
	'tag-mobile_edit' => 'Mobilna změna',
	'tag-mobile_edit-description' => 'Z mobilnego sedła změnjony',
	'mobile-frontend-drawer-cancel' => 'Pśetergnuś',
);

/** Central Dusun (Dusun Bundu-liwan)
 */
$messages['dtp'] = array(
	'mobile-frontend-search-submit' => 'Ibok',
	'mobile-frontend-home-button' => 'Damin',
	'mobile-frontend-random-button' => 'Songko',
	'mobile-frontend-back-to-top-of-section' => 'Poningguli Id Boogian A',
	'mobile-frontend-show-button' => 'Popokito',
	'mobile-frontend-hide-button' => 'Popolisok',
	'mobile-frontend-regular-site' => 'Intaai bolikon koubasanan Wikipodia', # Fuzzy
	'mobile-frontend-featured-article' => 'Babasaon Tadau Diti',
);

/** Ewe (eʋegbe)
 */
$messages['ee'] = array(
	'mobile-frontend-search-submit' => 'Yi',
	'mobile-frontend-random-button' => 'Ɖesiaɖe ko',
	'mobile-frontend-show-button' => 'Fia',
	'mobile-frontend-hide-button' => 'Ɣlae',
	'mobile-frontend-regular-site' => 'Kpɔ axa sia le {{SITENAME}} ŋutɔ dzi', # Fuzzy
);

/** Greek (Ελληνικά)
 * @author AK
 * @author Glavkos
 * @author Protnet
 * @author ZaDiak
 */
$messages['el'] = array(
	'mobile-frontend-search-submit' => 'Μετάβαση',
	'mobile-frontend-home-button' => 'Κύρια σελίδα',
	'mobile-frontend-logged-out' => 'Δεν έχετε συνδεθεί.',
	'mobile-frontend-sign-up-heading' => 'Εγγραφή',
	'mobile-frontend-sign-in-heading' => 'Σύνδεση',
	'mobile-frontend-settings-beta' => 'Δοκιμαστική Έκδοση',
	'mobile-frontend-save-settings' => 'Αποθήκευση ρυθμίσεων',
	'mobile-frontend-random-button' => 'Τυχαία',
	'mobile-frontend-ajax-random-yes' => 'Ναι',
	'mobile-frontend-ajax-random-retry' => 'Δοκιμάστε ξανά',
	'mobile-frontend-back-to-top-of-section' => 'Πίσω στην αρχή της ενότητας',
	'mobile-frontend-close-section' => 'Κλείσιμο αυτής της ενότητας',
	'mobile-frontend-show-button' => 'Εμφάνιση',
	'mobile-frontend-hide-button' => 'Απόκρυψη',
	'mobile-frontend-regular-site' => 'Άποψη επιφάνειας εργασίας',
	'mobile-frontend-wml-continue' => 'Συνέχεια ...',
	'mobile-frontend-wml-back' => 'Πίσω ...',
	'mobile-frontend-view' => 'Προβολή κινητού',
	'mobile-frontend-view-desktop' => 'Επιφάνεια εργασίας',
	'mobile-frontend-view-mobile' => 'Κινητό',
	'mobile-frontend-opt-in-explain' => 'Με την εγγραφή σας στη δοκιμή, θα έχετε πρόσβαση σε πειραματικά χαρακτηριστικά, με κίνδυνο την αντιμετώπιση σφάλμάτων και ζητημάτων.',
	'mobile-frontend-images-status' => 'Εικόνες',
	'mobile-frontend-disable-images' => 'Απενεργοποίηση εικόνων σε ιστοχώρους κινητών',
	'mobile-frontend-enable-images' => 'Ενεργοποίηση εικόνων στην ιστοσελίδα για κινητά',
	'mobile-frontend-off' => 'OFF',
	'mobile-frontend-on' => 'ON',
	'mobile-frontend-featured-article' => 'Σημερινό Επιλεγμένο Άρθρο',
	'mobile-frontend-news-items' => 'Στις ειδήσεις',
	'mobile-frontend-leave-feedback-subject' => 'Θέμα:',
	'mobile-frontend-leave-feedback-message' => 'Μήνυμα:',
	'mobile-frontend-leave-feedback-submit' => 'Υποβολή Ανατροφοδότησης',
	'mobile-frontend-leave-feedback' => 'Αφήστε ανατροφοδότηση',
	'mobile-frontend-leave-feedback-title' => 'Δώστε μας τα σχόλιά σας σχετικά με την εμπειρία σας στην ιστοσελίδα για κινητά',
	'mobile-frontend-leave-feedback-technical-problem-section-header' => 'Τεχνικό πρόβλημα',
	'mobile-frontend-leave-feedback-general-section-header' => 'Γενικά',
	'mobile-frontend-leave-feedback-article-feedback-section-header' => 'Ανατροφοδότηση λήμματος',
	'mobile-frontend-leave-feedback-email-body' => 'Παρακαλούμε γράψτε το e-mail σας πάνω απ΄αυτή τη γραμμή.', # Fuzzy
	'mobile-frontend-leave-feedback-technical-link-text' => 'Τεχνικό πρόβλημα',
	'mobile-frontend-leave-feedback-form-subject-placeholder' => 'Θέμα μηνύματος',
	'mobile-frontend-leave-feedback-form-message-placeholder' => 'Πληκτρολογήστε το σχόλιό σας εδώ',
	'mobile-frontend-leave-feedback-page-title' => 'Δώστε μας τα σχόλιά σας σχετικά με την εμπειρία σας στην ιστοσελίδα για κινητά',
	'mobile-frontend-leave-feedback-special-title' => 'Επικοινωνήστε μαζί μας',
	'mobile-frontend-feedback-no-subject' => '(χωρίς θέμα)',
	'mobile-frontend-feedback-no-subject-field' => 'Παρακαλούμε εισάγετε ένα θέμα',
	'mobile-frontend-feedback-no-message' => 'Παρακαλούμε εισάγετε ένα μήνυμα εδώ',
	'mobile-frontend-leave-feedback-thanks' => 'Ευχαριστούμε, για τα σχόλιά σας!',
	'mobile-frontend-language' => 'Γλώσσα:',
	'mobile-frontend-language-footer' => '{{SITENAME}} είναι διαθέσημη σε άλλες γλώσσες.', # Fuzzy
	'mobile-frontend-language-site-choose' => 'Αναζήτηση γλώσσας',
	'mobile-frontend-username' => 'Όνομα χρήστη:',
	'mobile-frontend-password' => 'Κωδικός πρόσβασης:',
	'mobile-frontend-username-placeholder' => 'Όνομα χρήστη',
	'mobile-frontend-password-placeholder' => 'Κωδικός πρόσβασης',
	'mobile-frontend-login' => 'Είσοδος',
	'mobile-frontend-account-create-submit' => 'Εγγραφή',
	'mobile-frontend-password-confirm-placeholder' => 'Επιβεβαίωση κωδικού',
	'mobile-frontend-account-create-email-placeholder' => 'Διεύθυνση ηλεκτρονικού ταχυδρομείου (προαιρετικό)',
	'mobile-frontend-overlay-escape' => 'Πήγαινε πίσω',
	'mobile-frontend-placeholder' => 'Αναζήτηση {{SITENAME}}',
	'mobile-frontend-placeholder-beta' => 'Αναζήτηση {{SITENAME}} (Δοκιμαστική λειτουργία)',
	'mobile-frontend-placeholder-alpha' => 'Αναζήτηση {{SITENAME}} (Άκρως πειραματική λειτουργία)',
	'mobile-frontend-clear-search' => 'Εκκαθάριση',
	'mobile-frontend-privacy-link-text' => 'Ιδιωτικότητα',
	'mobile-frontend-about-link-text' => 'Σχετικά',
	'mobile-frontend-footer-sitename' => '{{SITENAME}}',
	'mobile-frontend-footer-contact' => 'Επικοινωνία',
	'mobile-frontend-main-menu-button-tooltip' => 'Άνοιγμα κυρίως μενού',
	'mobile-frontend-main-menu-featured' => 'Επιλεγμένο',
	'mobile-frontend-main-menu-nearby' => 'Κοντά',
	'mobile-frontend-main-menu-login' => 'Είσοδος',
	'mobile-frontend-main-menu-logout' => 'Έξοδος',
	'mobile-frontend-main-menu-watchlist' => 'Λίστα παρακολούθησης',
	'mobile-frontend-main-menu-settings' => 'Ρυθμίσεις',
	'mobile-frontend-main-menu-settings-heading' => 'Ρυθμίσεις ιστότοπου κινητών',
	'mobile-frontend-settings-site-header' => '{{SITENAME}} Γλώσσες',
	'mobile-frontend-main-menu-contact' => 'Επικοινωνία',
	'mobile-frontend-main-menu-account-create' => 'Δημιουργία λογαριασμού',
	'mobile-frontend-page-menu-contents' => 'περιεχόμενα',
	'mobile-frontend-page-menu-history' => 'Ιστορικό',
	'mobile-frontend-meta-data-issues-header' => 'Θέματα',
	'mobile-frontend-ajax-page-loading' => 'Φόρτωση $1',
	'mobile-frontend-page-saving' => 'Αποθήκευση $1',
	'mobile-frontend-photo-upload-generic' => 'Δωρεά μιας εικόνας',
	'mobile-frontend-donate-image-title' => 'Δωρεά μιας εικόνας',
	'mobile-frontend-donate-image-heading' => 'Οι πρόσφατες συνεισφορές σας',
	'mobile-frontend-watchlist-view' => 'Προβολή της λίστας παρακολούθησής σας',
	'mobile-frontend-watchlist-a-z' => 'Σελίδες υπό παρακολούθηση', # Fuzzy
	'mobile-frontend-watchlist-feed' => 'Σελίδες με αλλαγές', # Fuzzy
	'mobile-frontend-changeslist-ip' => 'Ανώνυμος χρήστης',
	'mobile-frontend-changeslist-nocomment' => 'καμία σύνοψη επεξεργασίας',
	'mobile-frontend-watchlist-filter-all' => 'Όλα',
	'mobile-frontend-watchlist-filter-articles' => 'Άρθρα',
	'mobile-frontend-watchlist-filter-talk' => 'Συζήτηση',
	'mobile-frontend-watchlist-filter-other' => 'Άλλο',
	'mobile-frontend-diffview-title' => 'Αλλαγή σε $1', # Fuzzy
);

/** British English (British English)
 * @author Shirayuki
 */
$messages['en-gb'] = array(
	'mobile-frontend-settings-description' => 'Customise your experience on your mobile device with these mobile specific site settings.',
);

/** Esperanto (Esperanto)
 * @author ArnoLagrange
 * @author Karika
 * @author Objectivesea
 * @author Yekrats
 */
$messages['eo'] = array(
	'mobile-frontend-desc' => 'Poŝtelefona Fasado',
	'mobile-frontend-search-submit' => 'Ek',
	'mobile-frontend-home-button' => 'Ĉefpaĝo',
	'mobile-frontend-logged-out' => 'Ne ensalutita',
	'mobile-frontend-logged-in-homepage-notification' => 'Bonvenon, $1!',
	'mobile-frontend-logged-in-toast-notification' => 'Elsalutita kiel $1',
	'mobile-frontend-sign-up-heading' => 'Registriĝi',
	'mobile-frontend-sign-in-heading' => 'Ensaluti',
	'mobile-frontend-sign-in-why' => 'Se vi havas konton de {{SITENAME}}, vi povas ensaluti sube.',
	'mobile-frontend-sign-in-error-heading' => 'Ho ve!',
	'mobile-frontend-settings-description' => 'Fari propran etoson en via portebla ilo kun ĉi tiuj agordoj',
	'mobile-frontend-settings-beta' => 'Beta',
	'mobile-frontend-settings-alpha' => '[//en.wikipedia.org/wiki/Here_be_dragons Reĝimo Jen Drakoj]',
	'mobile-frontend-save-settings' => 'Konservi preferojn',
	'mobile-frontend-random-button' => 'Hazarde',
	'mobile-frontend-ajax-random-quote' => 'Intelekta kresko komencu je naskiĝo kaj ĉesu nur ĉe morto',
	'mobile-frontend-ajax-random-question' => 'Legi ĉi tiun paĝon?',
	'mobile-frontend-ajax-random-yes' => 'Jes',
	'mobile-frontend-ajax-random-retry' => 'Reprovi',
	'mobile-frontend-ajax-random-suggestions' => 'Aliaj sugestoj:',
	'mobile-frontend-back-to-top-of-section' => 'Je sekcio reen',
	'mobile-frontend-close-section' => 'Fermi ĉi tiun sekcion',
	'mobile-frontend-show-button' => 'Montri',
	'mobile-frontend-hide-button' => 'Kaŝi',
	'mobile-frontend-empty-homepage-text' => 'Ĉi tiu hejmpaĝo estu konfigurita. <a href="http://meta.wikimedia.org/wiki/Mobile_Projects/Mobile_Gateway#Mobile_homepage">Kiel ŝalti la porteblan version de la retejo</a>', # Fuzzy
	'mobile-frontend-regular-site' => 'Malŝalti la version mobilan',
	'mobile-frontend-wml-continue' => 'Kontinui …',
	'mobile-frontend-wml-back' => 'Retroiri ...',
	'mobile-frontend-view' => 'Vidigo por porteblaj aparatoj',
	'mobile-frontend-view-desktop' => 'Labortablo',
	'mobile-frontend-view-mobile' => 'Portebla',
	'mobile-frontend-opt-in-explain' => 'Aliĝante la beta-version, vi eblos atingi eksperimentajn ecojn, riskante renkonti cimojn kaj problemojn.',
	'mobile-frontend-images-status' => 'Bildoj',
	'mobile-frontend-disable-images' => 'Malŝalti bildojn en poŝtelefona retejo',
	'mobile-frontend-enable-images' => 'Ŝalti bildojn en poŝtelefona retejo',
	'mobile-frontend-missing-image' => 'Bildo',
	'mobile-frontend-off' => 'NEVIDEBLAJ',
	'mobile-frontend-on' => 'VIDEBLAJ',
	'mobile-frontend-footer-contributors-text' => 'Artikolo fare de <a href="$1">kontribuantoj</a> kiel vi', # Fuzzy
	'mobile-frontend-featured-article' => 'Artikolo prezentita hodiaŭ',
	'mobile-frontend-news-items' => 'Aktuale',
	'mobile-frontend-leave-feedback-notice' => 'Viaj komentoj helpas nin plibonigi la poŝtelefona fasado. Ĝi estos afiŝitaj publike, kune kun via salutnomo, retumila versio, kaj operaciumo al la paĝo &quot;$1&quot;. Bonvolu elekti informeca temo-linio, ekz-e "Problemoj formati vastajn tabelojn". Viaj opinioj estas regataj laŭ nia regularo pri uzado.',
	'mobile-frontend-leave-feedback-warning' => 'Bonvolu inkluzivi personan informan en viaj komentoj, nur se vi konsentas publikigi tian informon.',
	'mobile-frontend-leave-feedback-subject' => 'Temo:',
	'mobile-frontend-leave-feedback-message' => 'Mesaĝo:',
	'mobile-frontend-leave-feedback-submit' => 'Doni Mesaĝon',
	'mobile-frontend-leave-feedback-link-text' => 'Komentoj pri Poŝtelefona Fasado',
	'mobile-frontend-leave-feedback' => 'Lasi komenton',
	'mobile-frontend-leave-feedback-title' => 'Doni al ni vian opinion pri la Poŝtelefona Fasado',
	'mobile-frontend-leave-feedback-technical-problem-section-header' => 'Teknika problemo',
	'mobile-frontend-leave-feedback-general-section-header' => 'Ĝenerala',
	'mobile-frontend-leave-feedback-article-feedback-section-header' => 'Rimarkoj pri artikolo',
	'mobile-frontend-leave-feedback-email-body' => 'Bonvolu priskribi la problemon kiun vi havas en {{SITENAME}}supre de la linio. Bonvolu noti ke ni ne povas respondi al ĉiuj mesaĝoj recivotaj.',
	'mobile-frontend-leave-feedback-technical-link-text' => 'Teknika problemo',
	'mobile-frontend-leave-feedback-general-link-text' => 'Ĝeneralaj rimarkoj',
	'mobile-frontend-leave-feedback-article-personal-link-text' => 'Pri mi, persono aŭ firmao kiun mi reprezentas',
	'mobile-frontend-leave-feedback-article-factual-link-text' => 'Pri eraro de fakto',
	'mobile-frontend-leave-feedback-article-other-link-text' => 'Pri alia problemo',
	'mobile-frontend-leave-feedback-form-subject-placeholder' => 'Temo de mesaĝo',
	'mobile-frontend-leave-feedback-form-message-placeholder' => 'Entajpu komenton ĉi tien',
	'mobile-frontend-leave-feedback-page-title' => 'Doni al ni vian opinion pri la Poŝtelefona Fasado',
	'mobile-frontend-leave-feedback-special-title' => 'Kontaktigi nin',
	'mobile-frontend-feedback-no-subject' => '(sen temo)',
	'mobile-frontend-feedback-no-subject-field' => 'Bonvolu enigi temon.',
	'mobile-frontend-feedback-no-message' => 'Bonvolu enigi mesaĝon ĉi tien',
	'mobile-frontend-feedback-edit-summary' => '$1 - aŭtomate afiŝita per la [[Special:MobileFeedback|komentilo de portebla versio]]',
	'mobile-frontend-leave-feedback-thanks' => 'Dankon pro viaj komentoj!',
	'mobile-frontend-leave-feedback-post-error' => 'Estis eraro traktante vian mesaĝon. Bonvolu provi denove pli poste.',
	'mobile-frontend-language' => 'Lingvo:',
	'mobile-frontend-language-article-heading' => 'Legi en alia lingvo',
	'mobile-frontend-language-header' => 'Ĉi tiu artikolo disponas per $1 {{PLURAL:$1|lingvo|lingvoj}}', # Fuzzy
	'mobile-frontend-language-variant-header' => 'Elekti variaĵon de {{#language:{{CONTENTLANG}}}}',
	'mobile-frontend-language-footer' => 'Notu: Ĉi tiu paĝo eble ne estas skribita en via prefera lingvo. Vi povas vidi kiujn lingvojn {{SITENAME}} subtenas klakante ĉi tie.',
	'mobile-frontend-language-site-choose' => 'Traserĉi lingvon',
	'mobile-frontend-username' => 'Salutnomo:',
	'mobile-frontend-password' => 'Pasvorto:',
	'mobile-frontend-username-placeholder' => 'Salutnomo',
	'mobile-frontend-password-placeholder' => 'Pasvorto',
	'mobile-frontend-login' => 'Ensaluti',
	'mobile-frontend-last-modified-date' => 'Laste modifita je $1, $2',
	'mobile-frontend-account-create-submit' => 'Registriĝi',
	'mobile-frontend-password-confirm-placeholder' => 'Konfirmu pasvorton',
	'mobile-frontend-account-create-email-placeholder' => 'Retpoŝtadreso (nedeviga)',
	'mobile-frontend-account-create-captcha-placeholder' => 'Entajpi tekston sekurecan',
	'mobile-frontend-overlay-escape' => 'Reen',
	'mobile-frontend-placeholder' => 'Traserĉi {{SITENAME}}',
	'mobile-frontend-placeholder-beta' => 'Traserĉi {{SITENAME}} (Beta)',
	'mobile-frontend-placeholder-alpha' => 'Traserĉi {{SITENAME}} (Reĝimo Dragon)',
	'mobile-frontend-search-help' => 'Tajpi serĉmendon supren kaj kongruaj artikolo-titoloj aperos ĉi tie.', # Fuzzy
	'mobile-frontend-dismiss-notification' => 'Forigi ĉi tiun not-rubandon',
	'mobile-frontend-clear-search' => 'Nuligi',
	'mobile-frontend-privacy-link-text' => 'Privateco',
	'mobile-frontend-about-link-text' => 'Pri',
	'mobile-frontend-footer-sitename' => '{{SITENAME}}',
	'mobile-frontend-footer-license-text' => 'Enhavo disponeblas per <a href="//en.m.wikipedia.org/wiki/Wikipedia:Text_of_Creative_Commons_Attribution-ShareAlike_3.0_Unported_License?useformat=mobile">permesilo CC BY-SA 3.0</a>',
	'mobile-frontend-terms-use-text' => '<a href="//wikimediafoundation.org/wiki/Terms_of_use?useformat=mobile">Kondiĉoj pri Uzado</a>',
	'mobile-frontend-footer-contact' => 'Kontaktigi',
	'mobile-frontend-search-noresults' => 'Neniuj artikoloj kongruas vian mendon. Ŝanĝu vian mendon, aŭ klaki la butonon de klavara serĉado por traserĉi ene de artikoloj.', # Fuzzy
	'mobile-frontend-main-menu-button-tooltip' => 'Malfermi ĉefmenuon',
	'mobile-frontend-main-menu-page-title' => 'Navigado de retejo',
	'mobile-frontend-main-menu-featured' => 'Elstara',
	'mobile-frontend-main-menu-nearby' => 'Apude',
	'mobile-frontend-main-menu-login' => 'Ensaluti',
	'mobile-frontend-main-menu-logout' => 'Elsaluti',
	'mobile-frontend-main-menu-watchlist' => 'Atentaro',
	'mobile-frontend-main-menu-settings' => 'Agordoj',
	'mobile-frontend-main-menu-upload' => 'Alŝuti',
	'mobile-frontend-main-menu-settings-heading' => 'Agordoj por portebla versio',
	'mobile-frontend-settings-site-header' => 'Lingvoj por {{SITENAME}}',
	'mobile-frontend-settings-site-description' => '{{SITENAME}} disponas en $1 {{PLURAL:$1|lingvo|lingvoj}}. Jen ĉiuj disponaj versioj',
	'mobile-frontend-main-menu-contact' => 'Kontaktigi',
	'mobile-frontend-main-menu-account-create' => 'Krei konton',
	'mobile-frontend-page-menu-contents' => 'enhavo',
	'mobile-frontend-page-menu-history' => 'Historio:',
	'mobile-frontend-meta-data-issues-header' => 'Problemoj',
	'mobile-frontend-meta-data-issues' => 'Ĉi tiu paĝo havas iujn problemojn',
	'mobile-frontend-ajax-page-loading' => 'Ŝargante $1',
	'mobile-frontend-page-saving' => 'Konservante $1',
	'mobile-frontend-photo-upload-generic' => 'Doni bildon',
	'mobile-frontend-donate-image-title' => 'Doni bildon',
	'mobile-frontend-watchlist-add' => 'Aldonis $1 al via atentaro',
	'mobile-frontend-watchlist-removed' => 'Forigis $1 el via atentaro',
	'mobile-frontend-watchlist-view' => 'Rigardi vian atentaron',
	'mobile-frontend-watchlist-more' => 'pli',
	'mobile-frontend-watchlist-cta-button-login' => 'Ensaluti',
	'mobile-frontend-watchlist-cta-button-signup' => 'Registriĝi',
	'mobile-frontend-watchlist-a-z' => 'Atentataj paĝoj', # Fuzzy
	'mobile-frontend-watchlist-feed' => 'Paĝoj kun ŝanĝoj', # Fuzzy
	'mobile-frontend-changeslist-ip' => 'Anonimulo',
	'mobile-frontend-changeslist-nocomment' => 'Sen resumo de redakto',
	'mobile-frontend-watchlist-filter-all' => 'Ĉiuj',
	'mobile-frontend-watchlist-filter-articles' => 'Artikoloj',
	'mobile-frontend-watchlist-filter-talk' => 'Diskuto',
	'mobile-frontend-watchlist-filter-other' => 'Alia',
	'mobile-frontend-diffview-title' => 'Ŝanĝi al $1', # Fuzzy
	'mobile-frontend-diffview-editcount' => '$1 {{PLURAL:$1|redakto|redaktoj}}',
	'mobile-frontend-diffview-anonymous' => 'Anonimulo',
	'mobile-frontend-diffview-bytesadded' => '$1 {{PLURAL:$1|bitokon|bitokojn}} aldonis',
	'mobile-frontend-diffview-bytesremoved' => '$1 {{PLURAL:$1|bitokon|bitokojn}} forigis',
	'mobile-frontend-table' => 'Tabelo $1',
	'mobile-frontend-saving-exit-page' => 'Via kontribuo ankoraŭ konservadas. Se vi forlasus, via kontribuo perdiĝus. Ĉu vi certas ke vi volas foriri?',
	'mobile-frontend-photo-upload' => 'Aldoni la unuan foton al ĉi tiu paĝo', # Fuzzy
	'mobile-frontend-photo-article-edit-comment' => 'Aldonis foton por uzi en paĝo',
	'mobile-frontend-photo-upload-comment' => 'Aldonis foton al paĝo',
	'mobile-frontend-photo-caption-placeholder' => 'Aldoni apudskribon por ĉi tiu bildo', # Fuzzy
	'mobile-frontend-image-loading' => 'Ŝargante bildon',
	'mobile-frontend-image-uploading' => 'Alŝutante bildon', # Fuzzy
	'mobile-frontend-photo-upload-error' => 'Eraro okazis alŝutante la bildon. Bonvolu provi alian bildon.', # Fuzzy
	'mobile-frontend-drawer-cancel' => 'Nuligi',
);

/** Spanish (español)
 * @author Armando-Martin
 * @author Crazymadlover
 * @author Fitoschido
 * @author Imre
 * @author Invadinado
 * @author Platonides
 */
$messages['es'] = array(
	'mobile-frontend-desc' => 'Interfaz móvil',
	'mobile-frontend-search-submit' => 'Ir',
	'mobile-frontend-home-button' => 'Inicio',
	'mobile-frontend-logged-out' => 'No has iniciado sesión',
	'mobile-frontend-logged-in-homepage-notification' => '¡Bienvenido/a, $1!',
	'mobile-frontend-logged-in-toast-notification' => 'Has iniciado sesión como $1.',
	'mobile-frontend-sign-up-heading' => 'Registrarse',
	'mobile-frontend-sign-in-heading' => 'Iniciar sesión',
	'mobile-frontend-sign-in-why' => 'Se tienes una cuenta en {{SITENAME}}, puedes acceder a continuación.',
	'mobile-frontend-sign-in-error-heading' => '¡Vaya!',
	'mobile-frontend-settings-description' => 'Personaliza la experiencia en tu dispositivo móvil con estos ajustes específicos del sitio móvil.',
	'mobile-frontend-settings-beta' => 'Beta',
	'mobile-frontend-settings-alpha' => '[//en.wikipedia.org/wiki/Here_be_dragons Pasarás a un modo peligroso]',
	'mobile-frontend-settings-alpha-description' => 'Entrar en territorio móvil peligroso e inexplorado. Obtener características aún más experimentales, pero con más peligro de errores.',
	'mobile-frontend-save-settings' => 'Guardar configuración',
	'mobile-frontend-random-button' => 'Aleatorio',
	'mobile-frontend-ajax-random-heading' => 'Localizando la información...',
	'mobile-frontend-ajax-random-quote' => 'El crecimiento intelectual debería comenzar con el nacimiento y solo debería finalizar con la muerte.',
	'mobile-frontend-ajax-random-question' => '¿Leer esta página?',
	'mobile-frontend-ajax-random-yes' => 'Sí',
	'mobile-frontend-ajax-random-retry' => 'Reintentar',
	'mobile-frontend-ajax-random-suggestions' => 'Otras sugerencias:',
	'mobile-frontend-back-to-top-of-section' => 'Ir atrás una sección',
	'mobile-frontend-close-section' => 'Cerrar esta sección',
	'mobile-frontend-show-button' => 'Mostrar',
	'mobile-frontend-hide-button' => 'Ocultar',
	'mobile-frontend-empty-homepage-text' => 'Esta página debe configurarse. <a href="http://meta.wikimedia.org/wiki/Mobile_Projects/Mobile_Gateway#Mobile_homepage">Instrucciones sobre cómo activar este sitio móvil</a>', # Fuzzy
	'mobile-frontend-regular-site' => 'Vista del escritorio',
	'mobile-frontend-wml-continue' => 'Continuar…',
	'mobile-frontend-wml-back' => 'Atrás…',
	'mobile-frontend-view' => 'Versión para móviles',
	'mobile-frontend-view-desktop' => 'Escritorio',
	'mobile-frontend-view-mobile' => 'teléfono móvil',
	'mobile-frontend-opt-in-explain' => 'Al probar la versión beta, obtendrá acceso a características experimentales, con el riesgo de encontrarse con errores y problemas.',
	'mobile-frontend-images-status' => 'Imágenes',
	'mobile-frontend-disable-images' => 'Desactivar imágenes en la versión para móviles',
	'mobile-frontend-enable-images' => 'Activar imágenes en la versión para móviles',
	'mobile-frontend-missing-image' => 'Imagen',
	'mobile-frontend-off' => '○',
	'mobile-frontend-on' => '❙',
	'mobile-frontend-footer-contributors-text' => 'Página realizada por [$1 colaboradores] como tú',
	'mobile-frontend-featured-article' => 'Artículo destacado',
	'mobile-frontend-news-items' => 'Actualidad',
	'mobile-frontend-leave-feedback-notice' => 'Sus comentarios nos ayudan a mejorar su experiencia del sitio móvil. Serán publicados en sitio accesible (junto con su nombre de usuario, versión del navegador y sistema operativo) en la página "$1". Intente elegir una línea informativa del tema, por ejemplo, "Formateando contenidos con tablas de gran anchura". Sus comentarios está sujetos a nuestros términos de uso.',
	'mobile-frontend-leave-feedback-warning' => 'Si no aceptas que tu información se haga pública, no incluyas información personal en tus comentarios.',
	'mobile-frontend-leave-feedback-subject' => 'Asunto:',
	'mobile-frontend-leave-feedback-message' => 'Mensaje:',
	'mobile-frontend-leave-feedback-submit' => 'Enviar comentarios',
	'mobile-frontend-leave-feedback-link-text' => 'Comentarios de la extensión de interfaz de usuario móvil',
	'mobile-frontend-leave-feedback' => 'Comentarios sobre el sitio móvil',
	'mobile-frontend-leave-feedback-title' => 'Comentarios sobre la versión para móviles.',
	'mobile-frontend-leave-feedback-technical-problem-section-header' => 'Problema técnico',
	'mobile-frontend-leave-feedback-general-section-header' => 'General',
	'mobile-frontend-leave-feedback-article-feedback-section-header' => 'Comentarios del artículo',
	'mobile-frontend-leave-feedback-email-body' => 'Describe el problema que estás experimentando con {{SITENAME}} por encima de esta línea. Ten en cuenta que nosotros no podemos responder a cada mensaje que recibimos.',
	'mobile-frontend-leave-feedback-technical-link-text' => 'Problema técnico',
	'mobile-frontend-leave-feedback-general-link-text' => 'Comentarios generales',
	'mobile-frontend-leave-feedback-article-personal-link-text' => 'Con respecto a mí, una persona o una empresa a la que represento',
	'mobile-frontend-leave-feedback-article-factual-link-text' => 'Con respecto a un error fáctico',
	'mobile-frontend-leave-feedback-article-other-link-text' => 'Con respecto a otro problema',
	'mobile-frontend-leave-feedback-form-subject-placeholder' => 'Asunto del mensaje',
	'mobile-frontend-leave-feedback-form-message-placeholder' => 'Escribe aquí tu comentario',
	'mobile-frontend-leave-feedback-page-title' => 'Comentarios sobre el sitio para móviles.',
	'mobile-frontend-leave-feedback-special-title' => 'Contáctanos',
	'mobile-frontend-feedback-no-subject' => '(sin asunto)',
	'mobile-frontend-feedback-no-subject-field' => 'Escribe un asunto',
	'mobile-frontend-feedback-no-message' => 'Introduce un mensaje aquí',
	'mobile-frontend-feedback-edit-summary' => '$1 - publicado automáticamente con la [[Special:MobileFeedback|herramienta de comentarios sobre el sitio móvil]]',
	'mobile-frontend-leave-feedback-thanks' => '¡Gracias por tu comentario!',
	'mobile-frontend-leave-feedback-post-error' => 'Hubo un error al procesar el mensaje. Inténtalo de nuevo más tarde.',
	'mobile-frontend-language' => 'Idioma:',
	'mobile-frontend-language-article-heading' => 'Leer en otro idioma',
	'mobile-frontend-language-header' => 'Esta página está disponible en $1 {{PLURAL:$1|idioma|idiomas}}',
	'mobile-frontend-language-variant-header' => 'Elegir la variante {{#language:{{CONTENTLANG}}}}',
	'mobile-frontend-language-footer' => '!Nota: Esta página puede no estar escrita en tu idioma preferido. Puedes ver qué idiomas soporta {{SITENAME}} haciendo clic aquí.',
	'mobile-frontend-language-site-choose' => 'Seleccionar idioma',
	'mobile-frontend-username' => 'Nombre de usuario:',
	'mobile-frontend-password' => 'Contraseña:',
	'mobile-frontend-username-placeholder' => 'Nombre de usuario',
	'mobile-frontend-password-placeholder' => 'Contraseña',
	'mobile-frontend-login' => 'Iniciar sesión',
	'mobile-frontend-last-modified-date' => 'Última modificación el $1, a las $2',
	'mobile-frontend-last-modified-seconds' => 'Última modificación hace {{PLURAL:$1|$1 segundo|$1 segundos}}',
	'mobile-frontend-last-modified-minutes' => 'Última modificación hace {{PLURAL:$1|$1 minuto|$1 minutos}}',
	'mobile-frontend-last-modified-hours' => 'Última modificación hace {{PLURAL:$1|$1 hora|$1 horas}}',
	'mobile-frontend-last-modified-days' => 'Última modificación hace {{PLURAL:$1|$1 día|$1 días}}',
	'mobile-frontend-last-modified-months' => 'Última modificación hace {{PLURAL:$1|$1 mes|$1 meses}}',
	'mobile-frontend-last-modified-years' => 'Última modificación hace {{PLURAL:$1|$1 año|$1 años}}',
	'mobile-frontend-account-create-submit' => 'Registrarse',
	'mobile-frontend-password-confirm-placeholder' => 'Confirmar contraseña',
	'mobile-frontend-account-create-email-placeholder' => 'Dirección de correo electrónico (opcional)',
	'mobile-frontend-account-create-captcha-placeholder' => 'Introducir el texto de seguridad',
	'mobile-frontend-overlay-escape' => 'Atrás',
	'mobile-frontend-placeholder' => 'Buscar en {{SITENAME}}',
	'mobile-frontend-placeholder-beta' => 'Búsqueda en {{SITENAME}} (Beta)',
	'mobile-frontend-placeholder-alpha' => 'Búsqueda en {{SITENAME}} (modo beta)',
	'mobile-frontend-search-help' => 'Teclea el término de búsqueda encima y los títulos de página coincidentes aparecerán aquí.',
	'mobile-frontend-dismiss-notification' => 'Rechazar esta notificación',
	'mobile-frontend-clear-search' => 'Limpiar',
	'mobile-frontend-privacy-link-text' => 'Privacidad',
	'mobile-frontend-about-link-text' => 'Acerca de {{SITENAME}}',
	'mobile-frontend-footer-sitename' => '{{SITENAME}}',
	'mobile-frontend-footer-license-text' => 'El contenido está disponible bajo la licencia [//en.m.wikipedia.org/wiki/Wikipedia:Text_of_Creative_Commons_Attribution-ShareAlike_3.0_Unported_License?useformat=mobile CC BY-SA 3.0]',
	'mobile-frontend-terms-use-text' => '[//wikimediafoundation.org/wiki/Términos_de_uso?useformat=mobile Términos de uso]',
	'mobile-frontend-footer-contact' => 'Contacto',
	'mobile-frontend-search-noresults' => 'No hay ningún título de página que coincida con tu búsqueda. Cambia tu búsqueda, o pulsa el botón de búsqueda del teclado para buscar dentro de las páginas.',
	'mobile-frontend-main-menu-button-tooltip' => 'Abrir el menú principal',
	'mobile-frontend-main-menu-page-title' => 'Navegación del sitio',
	'mobile-frontend-main-menu-featured' => 'Destacado',
	'mobile-frontend-main-menu-nearby' => 'Cercano',
	'mobile-frontend-main-menu-login' => 'Iniciar sesión',
	'mobile-frontend-main-menu-logout' => 'Cerrar sesión',
	'mobile-frontend-main-menu-watchlist' => 'Lista de seguimiento',
	'mobile-frontend-main-menu-settings' => 'Configuración',
	'mobile-frontend-main-menu-upload' => 'Subir',
	'mobile-frontend-main-menu-settings-heading' => 'Configuración del sitio móvil',
	'mobile-frontend-settings-site-header' => 'Idiomas de {{SITENAME}}',
	'mobile-frontend-settings-site-description' => '{{SITENAME}} está disponible en  $1 {{PLURAL:$1|idioma|idiomas}}. Todas las versiones disponibles se enumeran a continuación',
	'mobile-frontend-main-menu-contact' => 'Contacto',
	'mobile-frontend-main-menu-account-create' => 'Crear una cuenta',
	'mobile-frontend-page-menu-contents' => 'contenido',
	'mobile-frontend-page-menu-history' => 'Historial',
	'mobile-frontend-meta-data-issues-header' => 'Incidencias',
	'mobile-frontend-meta-data-issues' => 'Esta página tiene algunas incidencias',
	'mobile-frontend-ajax-page-loading' => 'Cargando $1',
	'mobile-frontend-page-saving' => 'Guardando $1',
	'mobile-frontend-ajax-page-error' => '¡Vaya! Hubo un problema. Intenta recargar la ventana del navegador.',
	'mobile-frontend-nearby-title' => 'Cercanos',
	'mobile-frontend-nearby-loading' => 'Cargando temas cercanos a tu ubicación actual',
	'mobile-frontend-nearby-requirements' => 'Esta página requiere JavaScript y un navegador compatible con la geolocalización.',
	'mobile-frontend-nearby-distance-report' => '$1 km de tu ubicación actual',
	'mobile-frontend-nearby-lookup-error' => 'No pudimos encontrarte. Intentando de nuevo…',
	'mobile-frontend-nearby-noresults' => 'Parece que estás en el medio de la nada, pues no pudimos encontrar ningún tema. ¿Quieres escribir uno?',
	'mobile-frontend-nearby-refresh' => 'Encontramos una ubicación más exacta para ti. Pulsa aquí para actualizar la lista de páginas cercanas',
	'mobile-frontend-nearby-error' => 'Ocurrió un error inesperado al intentar encontrar páginas cercanas',
	'mobile-frontend-donate-image-login' => 'Inicia sesión para ver tus subidas',
	'mobile-frontend-photo-upload-generic' => 'Donar una imagen',
	'mobile-frontend-donate-image-title' => 'Donar una imagen',
	'mobile-frontend-donate-image-summary' => 'Las fotos dan vida a las páginas de {{SITENAME}}.
Debido a la falta de fotos con licencias libres, hay muchas páginas que no las tienen.
Ayuda a avivar esas páginas donando una imagen que quieras regalarle a la comunidad de {{SITENAME}}.',
	'mobile-frontend-donate-image-heading' => 'Tus contribuciones recientes',
	'mobile-frontend-donate-image-page-title' => 'Subir',
	'mobile-frontend-donate-image-anon' => 'Para ver la página de subidas necesitas una [[Special:UserLogin|cuenta de usuario]]',
	'mobile-frontend-listed-image-no-description' => 'Sin descripción',
	'mobile-frontend-donate-photo-upload-success' => '¡Bien! ¡Ahora puedes usar tu imagen en {{SITENAME}}!',
	'mobile-frontend-donate-photo-first-upload-success' => '¡Bien! ¡Gracias por tu primer aporte!',
	'mobile-frontend-watchlist-add' => 'Se ha añadido el artículo $1 a tu lista de seguimiento',
	'mobile-frontend-watchlist-removed' => 'Se ha eliminado el artículo $1 de tu lista de seguimiento',
	'mobile-frontend-watchlist-view' => 'Ver tu lista de seguimiento',
	'mobile-frontend-watchlist-more' => 'más',
	'mobile-frontend-watchlist-cta' => 'Inicia sesión o regístrate para ver esta página.',
	'mobile-frontend-watchlist-cta-button-login' => 'Iniciar sesión',
	'mobile-frontend-watchlist-cta-button-signup' => 'Regístrate',
	'mobile-frontend-watchlist-a-z' => 'Todas',
	'mobile-frontend-watchlist-feed' => 'Modificadas',
	'mobile-frontend-watchlist-a-z-empty' => 'Actualmente no tienes ninguna página en seguimiento',
	'mobile-frontend-watchlist-a-z-empty-howto-alt' => 'Pulsa en la estrella en la parte superior de la página',
	'mobile-frontend-watchlist-a-z-empty-howto' => 'Sigue una página que encuentres interesante pulsando en el icono de la estrella en la parte superior de la página. Esto te permitirá marcar páginas de interés y ver cuando son modificadas.',
	'mobile-frontend-watchlist-feed-empty' => 'No hay páginas con cambios recientes',
	'mobile-frontend-watchlist-back-home' => 'Regresar',
	'mobile-frontend-changeslist-ip' => 'Dirección IP',
	'mobile-frontend-changeslist-nocomment' => 'sin resumen de edición',
	'mobile-frontend-watchlist-filter-all' => 'Todas',
	'mobile-frontend-watchlist-filter-articles' => 'Artículos',
	'mobile-frontend-watchlist-filter-talk' => 'Discusión',
	'mobile-frontend-watchlist-filter-other' => 'Otras',
	'mobile-frontend-watchlist-modified' => 'Modificado $1',
	'mobile-frontend-diffview-404-title' => 'Revisión incorrecta',
	'mobile-frontend-diffview-404-desc' => 'El id. de la revisión solicitada no existe',
	'mobile-frontend-diffview-title' => 'Cambios en $1', # Fuzzy
	'mobile-frontend-diffview-editcount' => '$1 {{PLURAL:$1|edición|ediciones}}',
	'mobile-frontend-diffview-anonymous' => 'Usuario anónimo',
	'mobile-frontend-diffview-bytesadded' => '$1 {{PLURAL:$1|byte añadido|bytes añadidos}}',
	'mobile-frontend-diffview-bytesremoved' => '$1 {{PLURAL:$1|byte eliminado|bytes eliminados}}',
	'mobile-frontend-diffview-explained' => 'Se añadieron (+) y eliminaron (-) las siguientes líneas:',
	'mobile-frontend-table' => 'Tabla $1',
	'mobile-frontend-saving-exit-page' => 'Su contribución está todavía guardándose. Si abandonas tus contribuciones, se perderán. ¿Estás seguro que deseas salir?',
	'mobile-frontend-photo-upload' => 'Añadir la primera foto a esta página', # Fuzzy
	'mobile-frontend-photo-article-edit-comment' => 'Se ha añadido una foto para su uso en la página',
	'mobile-frontend-photo-article-donate-comment' => 'Imagen donada desde el móvil',
	'mobile-frontend-photo-upload-comment' => 'Se añadió una foto a la página',
	'mobile-frontend-photo-caption-placeholder' => 'Añadir un título a esta imagen', # Fuzzy
	'mobile-frontend-image-loading' => 'Cargando la imagen',
	'mobile-frontend-image-uploading-wait' => 'Subiendo la imagen', # Fuzzy
	'mobile-frontend-image-uploading-long' => '¡Aún se está subiendo la imagen! Gracias por tu paciencia.',
	'mobile-frontend-image-uploading-cancel' => '<a href="#">Cancélala</a> si tarda demasiado.',
	'mobile-frontend-photo-upload-error' => 'Se produjo un error mientras se cargaba la imagen. Prueba con otra imagen.', # Fuzzy
	'mobile-frontend-photo-upload-success-article' => '¡Bien! Tu imagen ahora es visible en la página.',
	'mobile-frontend-photo-license' => 'Nota: Todas las fotos que publicas tendrán una [//en.wikipedia.org/wiki/Wikipedia:Text_of_Creative_Commons_Attribution-ShareAlike_3.0_Unported_License licencia CC BY-SA]', # Fuzzy
	'mobile-frontend-photo-submit' => 'Enviar',
	'mobile-frontend-photo-cancel' => 'Cancelar',
	'mobile-frontend-photo-upload-user-count' => '{{PLURAL:$1|1 subida|$1 subidas}}',
	'mobile-frontend-photo-upload-user-count-over-limit' => '500+ subidas',
	'tag-mobile_edit' => 'Edición desde móvil',
	'tag-mobile_edit-description' => 'Edición realizada desde el sitio móvil',
	'mobile-frontend-drawer-cancel' => 'Cancelar',
);

/** Estonian (eesti)
 * @author Avjoska
 * @author Pikne
 */
$messages['et'] = array(
	'mobile-frontend-desc' => 'Mobiili eeskomponent',
	'mobile-frontend-search-submit' => 'Mine',
	'mobile-frontend-home-button' => 'Esileht',
	'mobile-frontend-logged-out' => 'Ei ole sisse logitud',
	'mobile-frontend-logged-in-homepage-notification' => 'Tere tulemast, $1!',
	'mobile-frontend-logged-in-toast-notification' => 'Sisse logitud kasutajanimega $1.',
	'mobile-frontend-sign-up-heading' => 'Registreeru',
	'mobile-frontend-sign-in-heading' => 'Logi sisse',
	'mobile-frontend-sign-in-error-heading' => 'Ups!',
	'mobile-frontend-settings-description' => 'Vali oma mobiiliseadme jaoks sobivad mobiilisaiti puudutavad eelistused.',
	'mobile-frontend-settings-beta' => 'Beeta',
	'mobile-frontend-settings-alpha' => 'Režiim [//en.wikipedia.org/wiki/Here_be_dragons Siin on lohed]',
	'mobile-frontend-settings-alpha-description' => 'Sisene ohtlikule ja läbiuurimata mobiilimaale. Leiad sealt veelgi katsefunktsioone ja võimalik, et ka rohkem vigu.',
	'mobile-frontend-save-settings' => 'Salvesta eelistused',
	'mobile-frontend-random-button' => 'Juhuslik',
	'mobile-frontend-ajax-random-question' => 'Kas loed seda lehekülge?',
	'mobile-frontend-ajax-random-yes' => 'Jah',
	'mobile-frontend-ajax-random-retry' => 'Proovi uuesti',
	'mobile-frontend-ajax-random-suggestions' => 'Muud ettepanekud:',
	'mobile-frontend-back-to-top-of-section' => 'Mine alaosa võrra tagasi',
	'mobile-frontend-close-section' => 'Sule see alaosa',
	'mobile-frontend-show-button' => 'Näita',
	'mobile-frontend-hide-button' => 'Peida',
	'mobile-frontend-empty-homepage-text' => 'See koduleht vajab häälestamist. [//meta.wikimedia.org/wiki/Mobile_Projects/Mobile_Gateway#Mobile_homepage Juhised mobiilisaidi ülesseadmiseks]',
	'mobile-frontend-regular-site' => 'Tavavaade',
	'mobile-frontend-wml-continue' => 'Jätka...',
	'mobile-frontend-wml-back' => 'Tagasi...',
	'mobile-frontend-view' => 'Mobiilivaade',
	'mobile-frontend-view-desktop' => 'Lauaarvuti',
	'mobile-frontend-view-mobile' => 'Mobiil',
	'mobile-frontend-opt-in-explain' => 'Beetat proovides antakse sulle ligipääs katselistele funktsioonidele, mille järel võid kokku puutuda tarkvaravigade ja muude probleemidega.',
	'mobile-frontend-images-status' => 'Pildid',
	'mobile-frontend-disable-images' => 'Keela mobiilivaates pildid',
	'mobile-frontend-enable-images' => 'Luba mobiilivaates pildid',
	'mobile-frontend-missing-image' => 'Pilt',
	'mobile-frontend-off' => 'VÄLJAS',
	'mobile-frontend-on' => 'SEES',
	'mobile-frontend-footer-contributors-text' => 'Sinusuguste [$1 kaastööliste] kirjutatud lehekülg',
	'mobile-frontend-featured-article' => 'Päevaartikkel',
	'mobile-frontend-news-items' => 'Päevakajaline',
	'mobile-frontend-leave-feedback-warning' => 'Kui sa pole nõus oma andmete avalikustamisega, siis palun ära lisa kommentaaridele isiklikke andmeid.',
	'mobile-frontend-leave-feedback-subject' => 'Teema:',
	'mobile-frontend-leave-feedback-message' => 'Sõnum:',
	'mobile-frontend-leave-feedback-submit' => 'Saada tagasiside',
	'mobile-frontend-leave-feedback-link-text' => 'Lisa MobileFrontend tagasiside',
	'mobile-frontend-leave-feedback' => 'Mobiilisaidi tagasiside',
	'mobile-frontend-leave-feedback-title' => 'Mobiilisaidi tagasiside',
	'mobile-frontend-leave-feedback-technical-problem-section-header' => 'Tehniline probleem',
	'mobile-frontend-leave-feedback-general-section-header' => 'Üldine',
	'mobile-frontend-leave-feedback-article-feedback-section-header' => 'Artikli tagasiside',
	'mobile-frontend-leave-feedback-email-body' => 'Palun kirjelda sellest reast ülalpool probleemi, millega {{GRAMMAR:inessive|{{SITENAME}}}} kokku puutusid. Pane tähele, et meil pole võimalik vastata kõigile vastuvõetud sõnumitele.',
	'mobile-frontend-leave-feedback-technical-link-text' => 'Tehniline probleem',
	'mobile-frontend-leave-feedback-general-link-text' => 'Üldine tagasiside',
	'mobile-frontend-leave-feedback-article-personal-link-text' => 'Minu, muu isiku või minu esindatava ettevõtte kohta',
	'mobile-frontend-leave-feedback-article-factual-link-text' => 'Faktivea kohta',
	'mobile-frontend-leave-feedback-article-other-link-text' => 'Muu probleemi kohta',
	'mobile-frontend-leave-feedback-form-subject-placeholder' => 'Sõnumi teema',
	'mobile-frontend-leave-feedback-form-message-placeholder' => 'Kirjuta oma kommentaar siia',
	'mobile-frontend-leave-feedback-special-title' => 'Võta meiega ühendust',
	'mobile-frontend-feedback-no-subject' => '(teemat ei ole)',
	'mobile-frontend-feedback-no-subject-field' => 'Palun sisesta teema.',
	'mobile-frontend-feedback-no-message' => 'Palun kirjuta sõnum siia',
	'mobile-frontend-leave-feedback-thanks' => 'Aitäh tagasiside eest!',
	'mobile-frontend-language' => 'Keel:',
	'mobile-frontend-language-article-heading' => 'Loe teises keeles',
	'mobile-frontend-language-header' => 'See lehekülg on saadaval {{PLURAL:$1|ühes|$1}} keeles.',
	'mobile-frontend-language-footer' => 'Märkus: See lehekülg ei pruugi olla kirjutatud keeles, mida eelistad. Saad vaadata, milliseid keeli {{SITENAME}} toetab, kui klõpsad siia.',
	'mobile-frontend-language-site-choose' => 'Otsi keelt',
	'mobile-frontend-username' => 'Kasutajanimi:',
	'mobile-frontend-password' => 'Parool:',
	'mobile-frontend-username-placeholder' => 'Kasutajanimi',
	'mobile-frontend-password-placeholder' => 'Parool',
	'mobile-frontend-login' => 'Logi sisse',
	'mobile-frontend-last-modified-date' => 'Viimati muudetud kuupäeval $1, kell $2',
	'mobile-frontend-last-modified-seconds' => 'Viimati muudetud {{PLURAL:$1|ühe|$1}} sekundi eest',
	'mobile-frontend-last-modified-minutes' => 'Viimati muudetud {{PLURAL:$1|ühe|$1}} minuti eest',
	'mobile-frontend-last-modified-hours' => 'Viimati muudetud {{PLURAL:$1|ühe|$1}} tunni eest',
	'mobile-frontend-last-modified-days' => 'Viimati muudetud {{PLURAL:$1|ühe|$1}} päeva eest',
	'mobile-frontend-last-modified-months' => 'Viimati muudetud {{PLURAL:$1|ühe|$1}} kuu eest',
	'mobile-frontend-last-modified-years' => 'Viimati muudetud {{PLURAL:$1|ühe|$1}} aasta eest',
	'mobile-frontend-account-create-submit' => 'Registreeru',
	'mobile-frontend-password-confirm-placeholder' => 'Kinnita parool',
	'mobile-frontend-account-create-email-placeholder' => 'E-posti aadress (valikuline)',
	'mobile-frontend-account-create-captcha-placeholder' => 'Sisesta turvatekst',
	'mobile-frontend-overlay-escape' => 'Mine tagasi',
	'mobile-frontend-placeholder' => 'Otsi {{GRAMMAR:elative|{{SITENAME}}}}',
	'mobile-frontend-placeholder-beta' => 'Otsi {{GRAMMAR:elative|{{SITENAME}}}} (beeta)',
	'mobile-frontend-placeholder-alpha' => 'Otsi {{GRAMMAR:elative|{{SITENAME}}}} (loherežiim)',
	'mobile-frontend-search-help' => 'Tipi ülespoole otsisõna ja vastavad leheküljepealkirjad ilmuvad siia.',
	'mobile-frontend-dismiss-notification' => 'ära näita seda teadet',
	'mobile-frontend-clear-search' => 'Tühjenda',
	'mobile-frontend-privacy-link-text' => 'Privaatsus',
	'mobile-frontend-about-link-text' => 'Tiitelandmed',
	'mobile-frontend-footer-license-text' => 'Sisu saadaval litsentsi [//en.m.wikipedia.org/wiki/Wikipedia:Text_of_Creative_Commons_Attribution-ShareAlike_3.0_Unported_License?useformat=mobile CC BY-SA 3.0] all',
	'mobile-frontend-terms-use-text' => '[//wikimediafoundation.org/wiki/Terms_of_use?useformat=mobile Kasutustingimused]',
	'mobile-frontend-footer-contact' => 'Kontakt',
	'mobile-frontend-search-noresults' => 'Otsitavale vastavad leheküljepealkirjad puuduvad. Vaheta otsisõna või vajuta sõrmistiku otsinuppu, et otsida lehekülgedelt.',
	'mobile-frontend-main-menu-button-tooltip' => 'Ava peamenüü',
	'mobile-frontend-main-menu-featured' => 'Esile tõstetud',
	'mobile-frontend-main-menu-nearby' => 'Lähedal',
	'mobile-frontend-main-menu-login' => 'Logi sisse',
	'mobile-frontend-main-menu-logout' => 'Logi välja',
	'mobile-frontend-main-menu-watchlist' => 'Jälgimisloend',
	'mobile-frontend-main-menu-settings' => 'Eelistused',
	'mobile-frontend-main-menu-upload' => 'Üleslaadimised',
	'mobile-frontend-main-menu-settings-heading' => 'Mobiilisaidi eelistused',
	'mobile-frontend-settings-site-header' => '{{GRAMMAR:genitive|{{SITENAME}}}} keeled',
	'mobile-frontend-settings-site-description' => '{{SITENAME}} on saadaval {{PLURAL:$1|ühes keeles|$1 keeles}}. Kõik saadaolevad versioonid on loetletud allpool.',
	'mobile-frontend-main-menu-contact' => 'Kontakt',
	'mobile-frontend-main-menu-account-create' => 'Loo konto',
	'mobile-frontend-page-menu-contents' => 'sisu',
	'mobile-frontend-page-menu-history' => 'Ajalugu',
	'mobile-frontend-meta-data-issues-header' => 'Probleemid',
	'mobile-frontend-meta-data-issues' => 'Selle leheküljega on probleeme',
	'mobile-frontend-page-saving' => 'Lehekülje "$1" salvestamine',
	'mobile-frontend-nearby-distance-report' => '$1km sinu praegusest asukohast',
	'mobile-frontend-donate-image-login' => 'Pead olema sisse loginud, et näha oma üleslaaditud faile.',
	'mobile-frontend-photo-upload-generic' => 'Kingi pilt',
	'mobile-frontend-donate-image-title' => 'Kingi pilt',
	'mobile-frontend-donate-image-heading' => 'Sinu viimased muudatused',
	'mobile-frontend-donate-image-page-title' => 'Üleslaadimine',
	'mobile-frontend-donate-image-anon' => 'Üleslaadimiste lehekülje vaatamiseks on vaja [[Special:UserLogin|kasutajakontot]].',
	'mobile-frontend-listed-image-no-description' => 'Kirjeldus puudub',
	'mobile-frontend-watchlist-add' => '"$1" on sinu jälgimisloendisse lisatud.',
	'mobile-frontend-watchlist-removed' => '"$1" on sinu jälgimisloendist eemaldatud.',
	'mobile-frontend-watchlist-view' => 'Vaata oma jälgimisloendit',
	'mobile-frontend-watchlist-more' => 'veel',
	'mobile-frontend-watchlist-cta' => 'Palun logi sisse või registreeru, et seda lehekülge jälgida.',
	'mobile-frontend-watchlist-cta-button-login' => 'Logi sisse',
	'mobile-frontend-watchlist-cta-button-signup' => 'Registreeru',
	'mobile-frontend-watchlist-a-z' => 'Kõik',
	'mobile-frontend-watchlist-feed' => 'Muudetud',
	'mobile-frontend-watchlist-a-z-empty' => 'Sa ei jälgi praegu ühtegi lehekülge.',
	'mobile-frontend-watchlist-a-z-empty-howto-alt' => 'Klõpsa tähekest lehekülje ülaosas',
	'mobile-frontend-watchlist-a-z-empty-howto' => 'Et jälgida huvipakkuvat lehekülge, klõpsa lehekülje ülaosas tähekese ikooni. Nii saad lisada huvipakkuvate lehekülgede juurde järjehoidja ja näha, millal neid muudetakse.',
	'mobile-frontend-watchlist-feed-empty' => 'Hiljutiste muudatustega leheküljed puuduvad.',
	'mobile-frontend-watchlist-back-home' => 'Tagasi esilehele',
	'mobile-frontend-changeslist-ip' => 'Anonüümne kasutaja',
	'mobile-frontend-changeslist-nocomment' => 'resümee puudub',
	'mobile-frontend-watchlist-filter-all' => 'Kõik',
	'mobile-frontend-watchlist-filter-articles' => 'Artiklid',
	'mobile-frontend-watchlist-filter-talk' => 'Arutelu',
	'mobile-frontend-watchlist-filter-other' => 'Muu',
	'mobile-frontend-diffview-title' => 'Muudatused',
	'mobile-frontend-diffview-editcount' => '$1 {{PLURAL:$1|muudatus|muudatust}}',
	'mobile-frontend-diffview-anonymous' => 'Anonüümne kasutaja',
	'mobile-frontend-diffview-bytesadded' => 'Lisatud $1 {{PLURAL:$1|bait|baiti}}',
	'mobile-frontend-diffview-bytesremoved' => 'Eemaldatud $1 {{PLURAL:$1|bait|baiti}}',
	'mobile-frontend-diffview-explained' => 'Lisati (+) ja eemaldati (-) järgmised read:',
	'mobile-frontend-photo-upload-error' => 'Tõrge. Proovi uuesti.',
	'mobile-frontend-photo-cancel' => 'Loobu',
	'mobile-frontend-photo-upload-user-count' => '{{PLURAL:$1|Üks üleslaadimine|$1 üleslaadimist}}', # Fuzzy
	'mobile-frontend-photo-upload-user-count-over-limit' => 'Üle 500 üleslaadimise',
	'tag-mobile_edit' => 'Mobiilimuudatus',
	'tag-mobile_edit-description' => 'Mobiilisaidil tehtud muudatus',
	'mobile-frontend-drawer-cancel' => 'Loobu',
);

/** Basque (euskara)
 * @author An13sa
 * @author පසිඳු කාවින්ද
 */
$messages['eu'] = array(
	'mobile-frontend-search-submit' => 'Joan',
	'mobile-frontend-home-button' => 'Azala',
	'mobile-frontend-logged-out' => 'Saioa hasi gabe',
	'mobile-frontend-settings-beta' => 'Beta',
	'mobile-frontend-save-settings' => 'Konfigurazioa gorde',
	'mobile-frontend-random-button' => 'Ausazkoa',
	'mobile-frontend-back-to-top-of-section' => 'Atal Bat Atzera Joan',
	'mobile-frontend-close-section' => 'atal hau itxi',
	'mobile-frontend-show-button' => 'Erakutsi',
	'mobile-frontend-hide-button' => 'Ezkutatu',
	'mobile-frontend-regular-site' => 'Idazmahaiko bista',
	'mobile-frontend-wml-continue' => 'Jarraitu ...',
	'mobile-frontend-wml-back' => 'Atzera ...',
	'mobile-frontend-view' => 'Mugikorreko bista',
	'mobile-frontend-view-desktop' => 'Idazmahaia',
	'mobile-frontend-view-mobile' => 'Mugikorra',
	'mobile-frontend-images-status' => 'Irudiak',
	'mobile-frontend-off' => 'OFF',
	'mobile-frontend-on' => 'ON',
	'mobile-frontend-featured-article' => 'Gaur Nabarmendutako Artikulua',
	'mobile-frontend-news-items' => 'Albisteak',
	'mobile-frontend-leave-feedback-subject' => 'Gaia:',
	'mobile-frontend-leave-feedback-message' => 'Mezua:',
	'mobile-frontend-leave-feedback-general-section-header' => 'Orokorra',
	'mobile-frontend-leave-feedback-article-feedback-section-header' => 'Artikuluaren feedbacka',
	'mobile-frontend-leave-feedback-technical-link-text' => 'Arazo teknikoa',
	'mobile-frontend-language' => 'Hizkuntza:',
	'mobile-frontend-language-site-choose' => 'Hikzuntza bilatu',
	'mobile-frontend-username' => 'Lankide izena:',
	'mobile-frontend-password' => 'Pasahitza',
	'mobile-frontend-login' => 'Saioa hasi',
	'mobile-frontend-clear-search' => 'Garbitu',
	'mobile-frontend-privacy-link-text' => 'Pribatutasuna',
	'mobile-frontend-about-link-text' => 'Honi buruz',
	'mobile-frontend-footer-sitename' => '{{SITENAME}}',
	'mobile-frontend-footer-contact' => 'Kontaktatu',
	'mobile-frontend-main-menu-featured' => 'Nabarmendua',
	'mobile-frontend-main-menu-nearby' => 'Gertukoak',
	'mobile-frontend-main-menu-settings' => 'Ezarpenak',
	'mobile-frontend-settings-site-header' => '{{SITENAME}}-ko hizkuntzak',
	'mobile-frontend-main-menu-contact' => 'Kontaktatu',
	'mobile-frontend-page-menu-contents' => 'Edukiak',
	'mobile-frontend-page-menu-history' => 'Historia',
	'mobile-frontend-photo-submit' => 'Bidali',
	'mobile-frontend-photo-cancel' => 'Utzi',
);

/** Extremaduran (estremeñu)
 */
$messages['ext'] = array(
	'mobile-frontend-search-submit' => 'Dil',
	'mobile-frontend-home-button' => 'Encetu',
	'mobile-frontend-random-button' => 'Aleatóriu',
	'mobile-frontend-back-to-top-of-section' => 'Dil alatrás un apaltihu',
	'mobile-frontend-show-button' => 'Muestral',
	'mobile-frontend-hide-button' => 'Açonchal',
	'mobile-frontend-regular-site' => 'Guipal esta páhina ena Güiquipeya estándal', # Fuzzy
	'mobile-frontend-featured-article' => 'Artículu destacau',
);

/** Persian (فارسی)
 * @author Baqeri
 * @author Hooshmand.hasannia
 * @author Huji
 * @author Leyth
 * @author Mjbmr
 * @author Pouyana
 * @author Reza1615
 * @author Rmashhadi
 * @author ZxxZxxZ
 * @author پسر یاس
 */
$messages['fa'] = array(
	'mobile-frontend-desc' => 'ظاهر تلفن همراه',
	'mobile-frontend-search-submit' => 'برو',
	'mobile-frontend-home-button' => 'خانه',
	'mobile-frontend-logged-out' => 'به سامانه وارد نشده‌اید',
	'mobile-frontend-sign-up-heading' => 'ثبت نام',
	'mobile-frontend-sign-in-heading' => 'ورود',
	'mobile-frontend-sign-in-why' => 'اگر در {{SITENAME}} حساب کاربری دارید، می‌توانید در پائین وارد سیستم شوید.',
	'mobile-frontend-sign-in-error-heading' => 'اوخ!',
	'mobile-frontend-settings-description' => 'تجربهٔ مرور این وب‌گاه بر روی تلفن همراه را با تنظیم کردن وب‌گاه تغییر دهید.',
	'mobile-frontend-settings-beta' => 'بتا',
	'mobile-frontend-save-settings' => 'ذخیرهٔ تنظیمات',
	'mobile-frontend-random-button' => 'تصادفی',
	'mobile-frontend-ajax-random-heading' => 'در حال یافتن دانش...',
	'mobile-frontend-ajax-random-question' => 'این صفحه را خوانده‌اید؟',
	'mobile-frontend-ajax-random-yes' => 'بله',
	'mobile-frontend-ajax-random-retry' => 'دوباره سعی کن',
	'mobile-frontend-ajax-random-suggestions' => 'پیشنهادات دیگر:',
	'mobile-frontend-back-to-top-of-section' => 'بازگشت به بخش قبلی',
	'mobile-frontend-close-section' => 'این بخش را ببندید',
	'mobile-frontend-show-button' => 'نمایش',
	'mobile-frontend-hide-button' => 'نهفتن',
	'mobile-frontend-empty-homepage-text' => 'این صفحه نیاز به پیکربندی دارد. <a href="http://meta.wikimedia.org/wiki/Mobile_Projects/Mobile_Gateway#Mobile_homepage">دستورالعمل فعال‌سازی نسخه تلفن همراه برای این وب‌گاه</a>', # Fuzzy
	'mobile-frontend-regular-site' => 'نمایش دسکتاپ',
	'mobile-frontend-wml-continue' => 'ادامه...',
	'mobile-frontend-wml-back' => 'بازگشت...',
	'mobile-frontend-view' => 'نمای تلفن همراه',
	'mobile-frontend-view-desktop' => 'رایانه',
	'mobile-frontend-view-mobile' => 'تلفن همراه',
	'mobile-frontend-opt-in-explain' => 'با پیوستن به نسخهٔ آزمایشی، شما به ویژگی‌های آزمایشی دسترسی پیدا می‌کنید اما ممکن است با مشکلاتی هم مواجه شوید.',
	'mobile-frontend-images-status' => 'تصویرها',
	'mobile-frontend-disable-images' => 'غیر فعال کردن تصاویر بر روی تارنمای تلفن همراه',
	'mobile-frontend-enable-images' => 'فعال سازی تصاویر بر روی تارنمای تلفن همراه',
	'mobile-frontend-missing-image' => 'تصویر',
	'mobile-frontend-off' => 'خاموش',
	'mobile-frontend-on' => 'روشن',
	'mobile-frontend-footer-contributors-text' => 'مقاله توسط  <a href="$1">مشارکت کنندگان</a> مانند شما', # Fuzzy
	'mobile-frontend-featured-article' => 'مقالهٔ برگزیدهٔ امروز',
	'mobile-frontend-news-items' => 'در خبرها',
	'mobile-frontend-leave-feedback-notice' => 'بازخورد شما به ما کمک می‌کند تا وبگاه مخصوص تلفن همراه را بهبود ببخشیم. بازخوردتان به طور عمومی (همراه با نام کاربری شما، نسخهٔ مرورگرتان و سیستم عامل‌تان) در صفحه «$1» ارسال خواهد شد. لطفاُ تلاش کنید که عنوان آگاهی‌دهنده‌ای برگزینید، مثلاُ «مشکل قالب‌بندی با تبلت‌های پهن». بازخورد شما مشمول قوانین استفاده ماست.',
	'mobile-frontend-leave-feedback-warning' => 'با توجه به اینکه که با عمومی شدن اطلاعاتتان موافق نیستید، لطفاً اطلاعات شخصیتان را در پیامتان ننویسید.',
	'mobile-frontend-leave-feedback-subject' => 'موضوع:',
	'mobile-frontend-leave-feedback-message' => 'پیغام:',
	'mobile-frontend-leave-feedback-submit' => 'ثبت بازخورد',
	'mobile-frontend-leave-feedback-link-text' => 'بازخورد ظاهر تلفن همراه',
	'mobile-frontend-leave-feedback' => 'گذاشتن بازخورد',
	'mobile-frontend-leave-feedback-title' => 'دربارهٔ تجربهٔ استفاده از وبگاه مخصوص تلفن همراه، بازخورد بگذارید',
	'mobile-frontend-leave-feedback-technical-problem-section-header' => 'مشکل فنی',
	'mobile-frontend-leave-feedback-general-section-header' => 'عمومی',
	'mobile-frontend-leave-feedback-article-feedback-section-header' => 'ارزیابی مقاله',
	'mobile-frontend-leave-feedback-email-body' => 'لطفاً مشکلاتی را که با آنها در {{SITENAME}} مواجه شده‌اید را در بالای این خط بنویسید.لطفاً توجه داشته باشید که به علت زیاد بودن درخواست ممکن است نتوانیم پاسخی به پیام‌های دریافتی بدهیم.',
	'mobile-frontend-leave-feedback-technical-link-text' => 'مشکل فنی',
	'mobile-frontend-leave-feedback-general-link-text' => 'انتقادات و پیشنهادات عمومی',
	'mobile-frontend-leave-feedback-article-personal-link-text' => 'من ، یک شخص حقیقی یا نماینده یک شرکت',
	'mobile-frontend-leave-feedback-article-factual-link-text' => 'با توجه به خطای واقعی',
	'mobile-frontend-leave-feedback-article-other-link-text' => 'با توجه به مشکل دیگر',
	'mobile-frontend-leave-feedback-form-subject-placeholder' => 'موضوع پیام',
	'mobile-frontend-leave-feedback-form-message-placeholder' => 'نظر خود را اینجا بنویسید',
	'mobile-frontend-leave-feedback-page-title' => 'دربارهٔ تجربهٔ استفاده از وبگاه مخصوص تلفن همراه، بازخورد بگذارید',
	'mobile-frontend-feedback-page' => 'پروژه: نظرخواهی درباره افزونه موبایل', # Fuzzy
	'mobile-frontend-leave-feedback-special-title' => 'تماس با ما',
	'mobile-frontend-feedback-no-subject' => '(بدون موضوع)',
	'mobile-frontend-feedback-no-subject-field' => 'لطفاً یک موضوع را وارد کنید',
	'mobile-frontend-feedback-no-message' => 'لطفاً پیام را در اینجا وارد کنید',
	'mobile-frontend-feedback-edit-summary' => '$1 - به طور خودکار ارسال شده‌ها  از [[Special:MobileFeedback|ابزار ارزیابی تلفن همراه]] استفاده می‌کنند.',
	'mobile-frontend-leave-feedback-thanks' => 'تشکر از ارائه بازخورد شما!',
	'mobile-frontend-leave-feedback-post-error' => 'برای پردازش تراکنش شما خطا وجود دارد. لطفاً دوباره تلاش کنید.',
	'mobile-frontend-language' => 'زبان:',
	'mobile-frontend-language-article-heading' => 'به زبان‌های دیگر مطالعه کنید',
	'mobile-frontend-language-header' => 'این مقاله در $1   {{PLURAL:$1| زبان|زبان‌ها}}  دسترس است', # Fuzzy
	'mobile-frontend-language-footer' => 'توجه:ممکن است این مقاله در زبان مورد نظر شما نگاشته نشده‌باشد. با کلیک کردن در اینجا می‌توانید ببینید که در کدام زبان {{SITENAME}} موجود است.', # Fuzzy
	'mobile-frontend-language-site-choose' => 'جستجوی زبان',
	'mobile-frontend-username' => 'نام کاربری:',
	'mobile-frontend-password' => 'گذرواژه:',
	'mobile-frontend-username-placeholder' => 'نام کاربری',
	'mobile-frontend-password-placeholder' => 'گذرواژه',
	'mobile-frontend-login' => 'ورود',
	'mobile-frontend-account-create-submit' => 'ثبت نام',
	'mobile-frontend-password-confirm-placeholder' => 'تأیید گذرواژه',
	'mobile-frontend-account-create-email-placeholder' => 'آدرس ایمیل (اختیاری)',
	'mobile-frontend-account-create-captcha-placeholder' => 'متن امنیت را وارد کنید',
	'mobile-frontend-overlay-escape' => 'بازگشت به عقب',
	'mobile-frontend-placeholder' => 'جستجوی {{SITENAME}}',
	'mobile-frontend-search-help' => 'در بالا عبارت مورد نظر را جستجو کنید و نتایج بدست آمده را با عنوان مورد نظرتان تطبیق دهید.', # Fuzzy
	'mobile-frontend-dismiss-notification' => 'مرخص نمودن این اعلان',
	'mobile-frontend-clear-search' => 'پاک‌کردن',
	'mobile-frontend-privacy-link-text' => 'حریم خصوصی',
	'mobile-frontend-about-link-text' => 'درباره',
	'mobile-frontend-footer-sitename' => '{{SITENAME}}',
	'mobile-frontend-footer-contact' => 'تماس',
	'mobile-frontend-search-noresults' => 'هیچ عنوان مقاله‌ای مطابق با کلیدواژه نیست. کلیدواژهٔ جستجو را تغییر دهید یا برای جستجو درون متن مقاله‌ها دکمه جستجوی کیبرد را بفشارید.', # Fuzzy
	'mobile-frontend-main-menu-button-tooltip' => 'باز کردن منو اصلی',
	'mobile-frontend-main-menu-page-title' => 'هدایت‌کننده وب‌گاه',
	'mobile-frontend-main-menu-featured' => 'ویژگی‌ها',
	'mobile-frontend-main-menu-nearby' => 'در نزدیکی',
	'mobile-frontend-main-menu-login' => 'ورود به سامانه',
	'mobile-frontend-main-menu-logout' => 'خروج از سامانه',
	'mobile-frontend-main-menu-watchlist' => 'فهرست پی‌گیری‌ها',
	'mobile-frontend-main-menu-settings' => 'تنظیمات',
	'mobile-frontend-main-menu-upload' => 'بارگذاری',
	'mobile-frontend-main-menu-settings-heading' => 'تنظیمات وب‌گاه تلفن همراه',
	'mobile-frontend-settings-site-header' => 'زبان‌های {{SITENAME}}',
	'mobile-frontend-settings-site-description' => '{{SITENAME}} در $1 {{PLURAL:$1|زبان|زبان}} موجود است. تمام نسخه‌ها در زیر فهرست شده‌اند.',
	'mobile-frontend-main-menu-contact' => 'تماس',
	'mobile-frontend-main-menu-account-create' => 'ایجاد حساب کاربری',
	'mobile-frontend-page-menu-contents' => 'محتویات',
	'mobile-frontend-page-menu-history' => 'تاریخچه',
	'mobile-frontend-meta-data-issues-header' => 'بهسازی این مقاله', # Fuzzy
	'mobile-frontend-meta-data-issues' => 'این مقاله مشکل دارد', # Fuzzy
	'mobile-frontend-ajax-page-loading' => 'بارگیری $1',
	'mobile-frontend-page-saving' => 'ذخیره $1',
	'mobile-frontend-ajax-page-error' => 'یک مشکل به وجود آمده‌است. مرورگر خود را رفرش نمائید.',
	'mobile-frontend-nearby-title' => 'در نزدیکی',
	'mobile-frontend-photo-upload-generic' => 'اهدای یک تصویر',
	'mobile-frontend-changeslist-nocomment' => 'بدون خلاصه ویرایش',
	'mobile-frontend-watchlist-filter-all' => 'همه',
	'mobile-frontend-watchlist-filter-articles' => 'مقاله‌ها',
	'mobile-frontend-watchlist-filter-talk' => 'بحث',
	'mobile-frontend-watchlist-filter-other' => 'دیگر',
	'mobile-frontend-diffview-editcount' => '$1 {{PLURAL:$1|ویرایش}}',
	'mobile-frontend-photo-upload-comment' => 'تصویر به صفحه افزوده شد',
	'mobile-frontend-image-loading' => 'در حال بار شدن تصویر',
	'mobile-frontend-image-uploading-wait' => 'در حال بارگذاری تصویر', # Fuzzy
);

/** Finnish (suomi)
 * @author Beluga
 * @author Crt
 * @author Kulmalukko
 * @author Linnea
 * @author Nedergard
 * @author Nike
 * @author Olli
 * @author Stryn
 * @author VezonThunder
 */
$messages['fi'] = array(
	'mobile-frontend-desc' => 'Mobiilikäyttöliittymä',
	'mobile-frontend-search-submit' => 'Siirry',
	'mobile-frontend-home-button' => 'Etusivu',
	'mobile-frontend-logged-out' => 'Et ole kirjautunut sisään',
	'mobile-frontend-logged-in-homepage-notification' => 'Tervetuloa $1!',
	'mobile-frontend-logged-in-toast-notification' => 'Kirjautunut nimellä $1.',
	'mobile-frontend-sign-up-heading' => 'Rekisteröidy',
	'mobile-frontend-sign-in-heading' => 'Kirjaudu sisään',
	'mobile-frontend-sign-in-why' => 'Jos sinulla on on {{SITENAME}}-käyttäjätunnus, voit kirjautua sisään alla.',
	'mobile-frontend-sign-in-error-heading' => 'Hups',
	'mobile-frontend-settings-description' => 'Mukauta mobiilisivuston asetuksia',
	'mobile-frontend-settings-beta' => 'Beeta',
	'mobile-frontend-settings-alpha' => '[//en.wikipedia.org/wiki/Here_be_dragons Täällä on lohikäärmeitä] -tila',
	'mobile-frontend-settings-alpha-description' => 'Lähde vaaralliselle ja tutkimattomalle mobiilialueelle. Saat vielä lisää kokeiluluonteisia toimintoja, mutta virheiden vaara on suurempi.',
	'mobile-frontend-save-settings' => 'Tallenna asetukset',
	'mobile-frontend-random-button' => 'Satunnainen',
	'mobile-frontend-ajax-random-heading' => 'Etsitään tietoa...',
	'mobile-frontend-ajax-random-quote' => 'Älyllisen kasvun pitäisi alkaa syntymästä ja loppua vasta kuolemassa',
	'mobile-frontend-ajax-random-question' => 'Haluatko lukea tämän sivun?',
	'mobile-frontend-ajax-random-yes' => 'Kyllä',
	'mobile-frontend-ajax-random-retry' => 'Yritä uudelleen',
	'mobile-frontend-ajax-random-suggestions' => 'Muut ehdotukset:',
	'mobile-frontend-back-to-top-of-section' => 'Palaa takaisin osioon',
	'mobile-frontend-close-section' => 'Sulje tämä osio',
	'mobile-frontend-show-button' => 'Näytä',
	'mobile-frontend-hide-button' => 'Piilota',
	'mobile-frontend-empty-homepage-text' => 'Tälle kotisivulle täytyy tehdä määrityksiä. [//meta.wikimedia.org/wiki/Mobile_Projects/Mobile_Gateway#Mobile_homepage Ohjeita mobiilisivuston käyttöönotosta]',
	'mobile-frontend-regular-site' => 'Työpöytänäkymä',
	'mobile-frontend-wml-continue' => 'Jatka...',
	'mobile-frontend-wml-back' => 'Takaisin...',
	'mobile-frontend-view' => 'Mobiilinäkymä',
	'mobile-frontend-view-desktop' => 'Työpöytä',
	'mobile-frontend-view-mobile' => 'Mobiili',
	'mobile-frontend-opt-in-explain' => 'Liittymällä kokeelliseen versioon, saat mahdollisuuden käyttää kokeellisia ominaisuuksia, mutta on mahdollista, että kohtaat ohjelmointivirheitä tai muita ongelmia.',
	'mobile-frontend-images-status' => 'Kuvat',
	'mobile-frontend-disable-images' => 'Poista kuvat käytöstä mobiilisivustolla',
	'mobile-frontend-enable-images' => 'Ota kuvat käyttöön mobiilisivustolla',
	'mobile-frontend-missing-image' => 'Kuva',
	'mobile-frontend-off' => 'pois',
	'mobile-frontend-on' => 'päällä',
	'mobile-frontend-footer-contributors-text' => 'Sivun ovat kirjoittaneet sinun kaltaisesi [$1 muokkaajat].',
	'mobile-frontend-featured-article' => 'Suositeltu artikkeli',
	'mobile-frontend-news-items' => 'Uutisissa',
	'mobile-frontend-leave-feedback-notice' => 'Palautteesi auttaa meitä kehittämään mobiilisivuston käyttökokemusta. Se tulee julkiseksi (käyttäjänimesi, selainversiosi ja käyttöjärjestelmäsi lisäksi) sivulle &quot;$1&quot;. Yritä valita mahdollisimman kuvaava otsikkorivi, esim. "Muotoiluongelmat leveiden taulukoiden kanssa". Palautteesi tulee noudattaa käyttöehtojamme.',
	'mobile-frontend-leave-feedback-warning' => 'Ellet halua tietojesi olevan julkisija, älä liitä niitä kommentteihisi.',
	'mobile-frontend-leave-feedback-subject' => 'Aihe:',
	'mobile-frontend-leave-feedback-message' => 'Viesti:',
	'mobile-frontend-leave-feedback-submit' => 'Lähetä palaute',
	'mobile-frontend-leave-feedback-link-text' => 'Mobiilinäkymän palaute',
	'mobile-frontend-leave-feedback' => 'Palaute mobiilisivustosta',
	'mobile-frontend-leave-feedback-title' => 'Anna palautetta mobiilisivuston käyttökokemuksesta',
	'mobile-frontend-leave-feedback-technical-problem-section-header' => 'Tekninen ongelma',
	'mobile-frontend-leave-feedback-general-section-header' => 'Yleinen',
	'mobile-frontend-leave-feedback-article-feedback-section-header' => 'Palaute artikkeleista',
	'mobile-frontend-leave-feedback-email-body' => 'Kuvaa ongelmaa, jonka olet kohdannut {{SITENAME}}-sivustolla, tämän rivin ylle. Huomaa, ettemme voi vastata jokaiseen saamaamme viestiin.',
	'mobile-frontend-leave-feedback-technical-link-text' => 'Tekninen ongelma',
	'mobile-frontend-leave-feedback-general-link-text' => 'Yleinen palaute',
	'mobile-frontend-leave-feedback-article-personal-link-text' => 'Liittyen minuun, tai yritykseen, jota edustan',
	'mobile-frontend-leave-feedback-article-factual-link-text' => 'Koskien virheellistä tietoa',
	'mobile-frontend-leave-feedback-article-other-link-text' => 'Toinen ongelma koskee',
	'mobile-frontend-leave-feedback-form-subject-placeholder' => 'Viestin aihe',
	'mobile-frontend-leave-feedback-form-message-placeholder' => 'Kirjoita kommenttisi tähän',
	'mobile-frontend-leave-feedback-page-title' => 'Palaute mobiilisivustosta',
	'mobile-frontend-leave-feedback-special-title' => 'Ota yhteyttä',
	'mobile-frontend-feedback-no-subject' => '(ei otsikkoa)',
	'mobile-frontend-feedback-no-subject-field' => 'Määritä aihe',
	'mobile-frontend-feedback-no-message' => 'Kirjoita viestisi tähän',
	'mobile-frontend-feedback-edit-summary' => '$1 – lähetetty automaattisesti [[Special:MobileFeedback|mobiilisivun palautetyökalulla]]',
	'mobile-frontend-leave-feedback-thanks' => 'Kiitos palautteestasi.',
	'mobile-frontend-leave-feedback-post-error' => 'Viestiäsi käsiteltäessä tapahtui virhe. Yritä myöhemmin uudelleen.',
	'mobile-frontend-language' => 'Kieli:',
	'mobile-frontend-language-article-heading' => 'Lue toisella kielellä',
	'mobile-frontend-language-header' => 'Tämä sivu on saatavilla {{PLURAL:$1|yhdellä|$1}} kielellä.',
	'mobile-frontend-language-variant-header' => 'Valitse kielen {{#language:{{CONTENTLANG}}}} kielimuoto',
	'mobile-frontend-language-footer' => 'Huomio: Tämä sivu ei välttämättä ole haluamallasi kielellä. Voit nähdä kielet, joita {{SITENAME}} tukee, painamalla tästä.',
	'mobile-frontend-language-site-choose' => 'Etsi kieltä',
	'mobile-frontend-username' => 'Käyttäjätunnus',
	'mobile-frontend-password' => 'Salasana',
	'mobile-frontend-username-placeholder' => 'Käyttäjätunnus',
	'mobile-frontend-password-placeholder' => 'Salasana',
	'mobile-frontend-login' => 'Kirjaudu sisään',
	'mobile-frontend-account-create-submit' => 'Luo tunnus',
	'mobile-frontend-password-confirm-placeholder' => 'Vahvista salasana',
	'mobile-frontend-account-create-email-placeholder' => 'Sähköpostiosoite (vapaaehtoinen)',
	'mobile-frontend-account-create-captcha-placeholder' => 'Kirjoita turvallisuusteksti',
	'mobile-frontend-overlay-escape' => 'Takaisin',
	'mobile-frontend-placeholder' => 'Etsi sivustolta {{SITENAME}}',
	'mobile-frontend-placeholder-beta' => '{{SITENAME}}-haku (beta)',
	'mobile-frontend-placeholder-alpha' => '{{SITENAME}}-haku (lohikäärmetila)',
	'mobile-frontend-search-help' => 'Kirjoita hakusana yläpuolelle ja vastaavat artikkelien otsikot näkyvät tässä.',
	'mobile-frontend-dismiss-notification' => 'Hylkää tämä ilmoitus',
	'mobile-frontend-clear-search' => 'Tyhjennä',
	'mobile-frontend-privacy-link-text' => 'Yksityisyys',
	'mobile-frontend-about-link-text' => 'Tietoja',
	'mobile-frontend-footer-sitename' => '{{SITENAME}}',
	'mobile-frontend-footer-contact' => 'Yhteystiedot',
	'mobile-frontend-search-noresults' => 'Hakuasi vastavaa artikkelin nimeä ei löytynyt. Muuta hakua tai käytä näppäimistön hakupainiketta etsiäksesi artikkelien sisältä.',
	'mobile-frontend-main-menu-button-tooltip' => 'Avaa päävalikko',
	'mobile-frontend-main-menu-page-title' => 'Sivuston navigaatio',
	'mobile-frontend-main-menu-featured' => 'Suositeltu',
	'mobile-frontend-main-menu-nearby' => 'Lähellä',
	'mobile-frontend-main-menu-login' => 'Kirjaudu sisään',
	'mobile-frontend-main-menu-logout' => 'Kirjaudu ulos',
	'mobile-frontend-main-menu-watchlist' => 'Tarkkailulista',
	'mobile-frontend-main-menu-settings' => 'Asetukset',
	'mobile-frontend-main-menu-settings-heading' => 'Mobiilisivuston asetukset',
	'mobile-frontend-settings-site-header' => 'Sivuston {{SITENAME}} kielet',
	'mobile-frontend-settings-site-description' => '{{SITENAME}} on saatavilla {{PLURAL:$1|yhdellä|$1}} kielellä. Kaikki saatavilla olevat kieliversiot on listattu alla.',
	'mobile-frontend-main-menu-contact' => 'Yhteystiedot',
	'mobile-frontend-main-menu-account-create' => 'Luo tunnus',
	'mobile-frontend-page-menu-contents' => 'sisältö',
	'mobile-frontend-page-menu-history' => 'Historia',
	'mobile-frontend-meta-data-issues-header' => 'Ongelmat',
	'mobile-frontend-meta-data-issues' => 'Tällä sivulla on ongelmia',
	'mobile-frontend-ajax-page-loading' => 'Ladataan $1',
	'mobile-frontend-page-saving' => 'Tallennetaan $1',
	'mobile-frontend-ajax-page-error' => 'Hups! Jokin meni pieleen. Kokeile päivittää selainikkuna.',
	'mobile-frontend-photo-upload-generic' => 'Lahjoita kuva',
	'mobile-frontend-donate-image-title' => 'Lahjoita kuva',
	'mobile-frontend-donate-image-summary' => 'Valokuvat herättävät {{GRAMMAR:genitive|{{SITENAME}}}} sivut eloon.
On monia sivuja, joilla ei ole kuvia, sillä vapaan lisenssin kuvista on vakava puute.
Auta herättämään nämä sivut eloon lahjoittamalla kuviasi, joita olet valmis antamaan ja joista olisi hyötyä laajemmalle {{SITENAME}}-muokkaajayhteisölle.',
	'mobile-frontend-donate-image-heading' => 'Tuoreet muokkauksesi',
	'mobile-frontend-watchlist-add' => '$1 on lisätty tarkkailulistallesi',
	'mobile-frontend-watchlist-removed' => '$1 on poistettu tarkkailulistaltasi',
	'mobile-frontend-watchlist-view' => 'Näytä tarkkailulista',
	'mobile-frontend-watchlist-more' => 'lisää',
	'mobile-frontend-watchlist-a-z' => 'Kaikki',
	'mobile-frontend-watchlist-feed' => 'Muokatut sivut', # Fuzzy
	'mobile-frontend-changeslist-ip' => 'Rekisteröitymätön käyttäjä',
	'mobile-frontend-changeslist-nocomment' => 'ei muokkausyhteenvetoa',
	'mobile-frontend-watchlist-filter-all' => 'Kaikki',
	'mobile-frontend-watchlist-filter-articles' => 'Artikkelit',
	'mobile-frontend-watchlist-filter-talk' => 'Keskustelu',
	'mobile-frontend-watchlist-filter-other' => 'Muut',
	'mobile-frontend-diffview-title' => 'Muutokset',
	'mobile-frontend-diffview-editcount' => '$1 {{PLURAL:$1|muokkaus|muokkausta}}',
	'mobile-frontend-diffview-anonymous' => 'Rekisteröitymän käyttäjä',
	'mobile-frontend-diffview-bytesadded' => '$1 {{PLURAL:$1|tavu|tavua}} lisätty',
	'mobile-frontend-diffview-bytesremoved' => '$1 {{PLURAL:$1|tavu|tavua}} poistettu',
	'mobile-frontend-table' => 'Taulukko $1',
	'mobile-frontend-saving-exit-page' => 'Muutoksiasi tallennetaan yhä. Jos poistut nyt, muutoksesi eivät tallennu. Haluatko varmasti poistua?',
	'mobile-frontend-photo-upload' => 'Lisää kuva tälle sivulle',
	'mobile-frontend-photo-article-edit-comment' => 'Lisäsi kuvan sivulla käytettäväksi',
	'mobile-frontend-photo-upload-comment' => 'Lisäsi kuvan sivulle',
	'mobile-frontend-photo-caption-placeholder' => 'Lisää kuvaus (vaaditaan)',
	'mobile-frontend-image-loading' => 'Ladataan kuvaa',
	'mobile-frontend-image-uploading-wait' => 'Lähetetään kuvaa. Odota.',
	'mobile-frontend-image-uploading-cancel' => '<a href="#">Peruuta</a>, jos tämä kestää liian kauan.',
	'mobile-frontend-photo-upload-error' => 'Virhe. Yritä uudelleen.',
	'mobile-frontend-photo-license' => 'Kaikki kuvasi julkaistaan [//fi.wikipedia.org/wiki/Wikipedia:Creative_Commons_Attribution-Share_Alike_3.0_Unported_-lisenssiehdot CC-BY-SA 3.0 -lisenssillä].', # Fuzzy
	'mobile-frontend-photo-submit' => 'Lähetä',
	'mobile-frontend-photo-cancel' => 'Peru',
	'tag-mobile_edit' => 'Mobiilimuutos',
	'tag-mobile_edit-description' => 'Muutos, joka on tehty mobiilisivustolta',
	'mobile-frontend-drawer-cancel' => 'Peru',
);

/** Faroese (føroyskt)
 * @author EileenSanda
 */
$messages['fo'] = array(
	'mobile-frontend-search-submit' => 'Far',
	'mobile-frontend-home-button' => 'Heim',
	'mobile-frontend-random-button' => 'Tilvildarlig',
	'mobile-frontend-show-button' => 'Vís',
	'mobile-frontend-hide-button' => 'Fjal',
	'mobile-frontend-regular-site' => 'Síggj hesa síðu á vanligu {{SITENAME}}', # Fuzzy
	'mobile-frontend-wml-continue' => 'Halt fram...',
	'mobile-frontend-wml-back' => 'Aftur ...',
	'mobile-frontend-view' => 'Mobil vísing',
	'mobile-frontend-featured-article' => 'Dagsins grein',
	'mobile-frontend-leave-feedback-subject' => 'Evni', # Fuzzy
	'mobile-frontend-leave-feedback-message' => 'Boð', # Fuzzy
	'mobile-frontend-leave-feedback-submit' => 'Send viðmerking',
	'mobile-frontend-leave-feedback-thanks' => 'Takk fyri tína afturmelding!',
	'mobile-frontend-language' => 'Mál', # Fuzzy
	'mobile-frontend-username' => 'Brúkaranavn:',
	'mobile-frontend-password' => 'Loyniorð:',
	'mobile-frontend-login' => 'Rita inn',
);

/** French (français)
 * @author Crochet.david
 * @author DavidL
 * @author Davidtsm
 * @author Gomoko
 * @author Hashar
 * @author Lucky
 * @author Sherbrooke
 * @author Tititou36
 * @author Tpt
 * @author Urhixidur
 * @author Wyz
 */
$messages['fr'] = array(
	'mobile-frontend-desc' => 'Affichage mobile',
	'mobile-frontend-search-submit' => 'Go',
	'mobile-frontend-home-button' => 'Accueil',
	'mobile-frontend-logged-out' => 'Non connecté(e)',
	'mobile-frontend-logged-in-homepage-notification' => 'Bienvenue, $1!',
	'mobile-frontend-logged-in-toast-notification' => 'Connecté en tant que $1.',
	'mobile-frontend-sign-up-heading' => 'Inscrivez-vous',
	'mobile-frontend-sign-in-heading' => 'Connexion',
	'mobile-frontend-sign-in-why' => 'Si vous avez un compte sur {{SITENAME}}, vous pouvez vous connecter ci-dessous.',
	'mobile-frontend-sign-in-error-heading' => 'Oups',
	'mobile-frontend-settings-description' => 'Personnalisez votre expérience sur votre mobile avec ces paramètres spécifiques.',
	'mobile-frontend-settings-beta' => 'Bêta',
	'mobile-frontend-settings-alpha' => 'Mode [//en.wikipedia.org/wiki/Here_be_dragons Ici sont les dragons]',
	'mobile-frontend-settings-alpha-description' => 'Entrez dans un territoire mobile dangereux et inexploré. Obtenez des fonctionnalisés encore plus expérimentales, mais avec plus de dangers de bogues.',
	'mobile-frontend-save-settings' => 'Enregistrez les paramètres',
	'mobile-frontend-random-button' => 'Au hasard',
	'mobile-frontend-ajax-random-heading' => 'Localisation de la connaissance…',
	'mobile-frontend-ajax-random-quote' => "Le développement intellectuel devrait commencer à la naissance et ne cesser qu'à la mort",
	'mobile-frontend-ajax-random-question' => 'Lire cette page?',
	'mobile-frontend-ajax-random-yes' => 'Oui',
	'mobile-frontend-ajax-random-retry' => 'Essayez de nouveau',
	'mobile-frontend-ajax-random-suggestions' => 'Autres suggestions:',
	'mobile-frontend-back-to-top-of-section' => "Revenir d'une section",
	'mobile-frontend-close-section' => 'Fermer cette section',
	'mobile-frontend-show-button' => 'Afficher',
	'mobile-frontend-hide-button' => 'Masquer',
	'mobile-frontend-empty-homepage-text' => "Cette page d'accueil doit être configurée. [//meta.wikimedia.org/wiki/Mobile_Projects/Mobile_Gateway#Mobile_homepage Comment activer ce site pour appareils mobiles]",
	'mobile-frontend-regular-site' => 'Désactiver la version mobile',
	'mobile-frontend-wml-continue' => 'Continuer…',
	'mobile-frontend-wml-back' => 'Retour…',
	'mobile-frontend-view' => 'Affichage mobile',
	'mobile-frontend-view-desktop' => 'Bureau',
	'mobile-frontend-view-mobile' => 'Mobile',
	'mobile-frontend-opt-in-explain' => 'En adhérant au beta-test, vous aurez accès aux fonctionnalités expérimentales, au risque de rencontrer bogues et problèmes.',
	'mobile-frontend-images-status' => 'Images',
	'mobile-frontend-disable-images' => 'Désactiver les images en version mobile',
	'mobile-frontend-enable-images' => 'Activer les images sur le site mobile',
	'mobile-frontend-missing-image' => 'Image',
	'mobile-frontend-off' => 'OFF',
	'mobile-frontend-on' => 'ON',
	'mobile-frontend-footer-contributors-text' => 'Page par [$1 contributeurs] comme vous',
	'mobile-frontend-featured-article' => 'Lumière sur...',
	'mobile-frontend-news-items' => 'Actualités',
	'mobile-frontend-leave-feedback-notice' => "Votre avis nous aidera à améliorer votre expérience du site mobile. Il sera publié publiquement (avec votre nom d'utilisateur, la version de votre navigateur et votre système d'exploitation) sur la page&quot;\$1&quot;. Merci d'essayer de choisir une ligne de sujet parlante, par ex. \"Problèmes de formatage avec les tableaux larges\". Votre avis est soumis à nos conditions d'utilisation.",
	'mobile-frontend-leave-feedback-warning' => 'Sauf à accepter que vos informations deviennent publiques, veuillez ne pas inclure de renseignements personnels dans vos commentaires.',
	'mobile-frontend-leave-feedback-subject' => 'Sujet :',
	'mobile-frontend-leave-feedback-message' => 'Message :',
	'mobile-frontend-leave-feedback-submit' => 'Soumettre son ressenti',
	'mobile-frontend-leave-feedback-link-text' => 'ressenti du frontal Mobile',
	'mobile-frontend-leave-feedback' => 'Laisser son ressenti',
	'mobile-frontend-leave-feedback-title' => 'Ressenti sur le site mobile',
	'mobile-frontend-leave-feedback-technical-problem-section-header' => 'Problème technique',
	'mobile-frontend-leave-feedback-general-section-header' => 'Général',
	'mobile-frontend-leave-feedback-article-feedback-section-header' => 'Évaluation de l’article',
	'mobile-frontend-leave-feedback-email-body' => 'Veuillez décrire le problème que vous rencontrez avec {{SITENAME}} au-dessus de cette ligne. Notez bien que nous ne  pouvons pas répondre à tous les messages que nous recevons.',
	'mobile-frontend-leave-feedback-technical-link-text' => 'Problème technique',
	'mobile-frontend-leave-feedback-general-link-text' => 'Ressenti général',
	'mobile-frontend-leave-feedback-article-personal-link-text' => 'Quant à moi, une personne, ou une entreprise que je représente',
	'mobile-frontend-leave-feedback-article-factual-link-text' => 'En ce qui concerne une erreur de fait',
	'mobile-frontend-leave-feedback-article-other-link-text' => 'En ce qui concerne un autre problème',
	'mobile-frontend-leave-feedback-form-subject-placeholder' => 'Sujet du message',
	'mobile-frontend-leave-feedback-form-message-placeholder' => 'Tapez votre commentaire ici',
	'mobile-frontend-leave-feedback-page-title' => 'Ressenti sur le site mobile',
	'mobile-frontend-leave-feedback-special-title' => 'Nous contacter',
	'mobile-frontend-feedback-no-subject' => '(aucun sujet)',
	'mobile-frontend-feedback-no-subject-field' => 'Veuillez entrer un sujet',
	'mobile-frontend-feedback-no-message' => 'Veuillez entrer un message ici',
	'mobile-frontend-feedback-edit-summary' => "$1 - publié automatiquement en utilisant l'[[Special:MobileFeedback|outil de commentaires mobile]]",
	'mobile-frontend-leave-feedback-thanks' => 'Merci pour votre avis!',
	'mobile-frontend-leave-feedback-post-error' => 'Il y a eu une erreur de traitement de votre message. Veuillez réessayer plus tard.',
	'mobile-frontend-language' => 'Langue :',
	'mobile-frontend-language-article-heading' => 'Lire dans une autre langue',
	'mobile-frontend-language-header' => 'Cette page est disponible en $1 {{PLURAL:$1|langue|langues}}',
	'mobile-frontend-language-variant-header' => 'Choisissez la variante {{#language:{{CONTENTLANG}}}}',
	'mobile-frontend-language-footer' => 'Remarque: Cette page peut ne pas être écrite dans votre langue favorite. Vous pouvez voir les langues supportées par {{SITENAME}} en cliquant ici.',
	'mobile-frontend-language-site-choose' => 'Rechercher la langue',
	'mobile-frontend-username' => 'Nom d’utilisateur :',
	'mobile-frontend-password' => 'Mot de passe :',
	'mobile-frontend-username-placeholder' => "Nom d'utilisateur",
	'mobile-frontend-password-placeholder' => 'Mot de passe',
	'mobile-frontend-login' => 'Se connecter',
	'mobile-frontend-last-modified-date' => 'Dernière modification le $1, à $2',
	'mobile-frontend-last-modified-seconds' => 'Dernière modification il y a {{PLURAL:$1|$1 seconde|$1 secondes}}',
	'mobile-frontend-last-modified-minutes' => 'Dernière modification il y a {{PLURAL:$1|$1 minute|$1 minutes}}',
	'mobile-frontend-last-modified-hours' => 'Dernière modification il y a {{PLURAL:$1|$1 heure|$1 heures}}',
	'mobile-frontend-last-modified-days' => 'Dernière modification il y a {{PLURAL:$1|$1 jour|$1 jours}}',
	'mobile-frontend-last-modified-months' => 'Dernière modification il y a {{PLURAL:$1|$1 mois}}',
	'mobile-frontend-last-modified-years' => 'Dernière modification il y a {{PLURAL:$1|$1 an|$1 ans}}',
	'mobile-frontend-account-create-submit' => 'Inscrivez-vous',
	'mobile-frontend-password-confirm-placeholder' => 'Confirmez le mot de passe',
	'mobile-frontend-account-create-email-placeholder' => 'Adresse de courriel (facultative)',
	'mobile-frontend-account-create-captcha-placeholder' => 'Entrez le texte de sécurité',
	'mobile-frontend-overlay-escape' => 'Retour en arrière',
	'mobile-frontend-placeholder' => 'Rechercher sur {{SITENAME}}',
	'mobile-frontend-placeholder-beta' => 'Rechercher {{SITENAME}} (Beta)',
	'mobile-frontend-placeholder-alpha' => 'Rechercher sur {{SITENAME}} (Mode Dragon)',
	'mobile-frontend-search-help' => "Tapez les critères de recherches ci-dessus et les titres de page correspondant s'afficheront ici.",
	'mobile-frontend-dismiss-notification' => 'rejeter cette notification',
	'mobile-frontend-clear-search' => 'Effacer',
	'mobile-frontend-privacy-link-text' => 'Confidentialité',
	'mobile-frontend-about-link-text' => 'À propos',
	'mobile-frontend-footer-sitename' => '{{SITENAME}}',
	'mobile-frontend-footer-license-text' => 'Contenu disponible sous la [//en.m.wikipedia.org/wiki/Wikipedia:Text_of_Creative_Commons_Attribution-ShareAlike_3.0_Unported_License?useformat=mobile licence CC BY-SA 3.0]',
	'mobile-frontend-terms-use-text' => "[//wikimediafoundation.org/wiki/Terms_of_use?useformat=mobile Conditions d'utilisation]",
	'mobile-frontend-footer-contact' => 'Contact',
	'mobile-frontend-search-noresults' => "Aucun titre de page ne correspond à votre recherche. Modifiez-la, ou appuyez sur le bouton de recherche du clavier pour chercher à l'intérieur des pages.",
	'mobile-frontend-main-menu-button-tooltip' => 'Ouvrir le menu principal',
	'mobile-frontend-main-menu-page-title' => 'Navigation dans le site',
	'mobile-frontend-main-menu-featured' => 'En vedette',
	'mobile-frontend-main-menu-nearby' => 'À proximité',
	'mobile-frontend-main-menu-login' => 'Connectez-vous',
	'mobile-frontend-main-menu-logout' => 'Se déconnecter',
	'mobile-frontend-main-menu-watchlist' => 'Liste de suivi',
	'mobile-frontend-main-menu-settings' => 'Configuration',
	'mobile-frontend-main-menu-upload' => 'Téléchargements',
	'mobile-frontend-main-menu-settings-heading' => 'Paramètres pour site mobile',
	'mobile-frontend-settings-site-header' => 'Langues de {{SITENAME}}',
	'mobile-frontend-settings-site-description' => '{{SITENAME}} est disponible en $1 {{PLURAL:$1|langue|langues}}. Toutes les versions disponibles sont listées ci-dessous',
	'mobile-frontend-main-menu-contact' => 'Contact',
	'mobile-frontend-main-menu-account-create' => 'Créer un compte',
	'mobile-frontend-page-menu-contents' => 'contenus',
	'mobile-frontend-page-menu-history' => 'Historique',
	'mobile-frontend-meta-data-issues-header' => 'Problèmes',
	'mobile-frontend-meta-data-issues' => 'Cette page a quelques problèmes',
	'mobile-frontend-ajax-page-loading' => 'Chargement de $1',
	'mobile-frontend-page-saving' => 'Enregistrement de $1',
	'mobile-frontend-ajax-page-error' => "Oups! Quelque chose s'est mal passé. Veuillez essayer de rafraîchir la fenêtre de votre navigateur.",
	'mobile-frontend-nearby-title' => 'À proximité',
	'mobile-frontend-nearby-loading' => 'Chargement des sujets proches de votre emplacement actuel',
	'mobile-frontend-nearby-requirements' => 'Cette page nécessite à la fois JavaScript et un navigateur gérant la localisation.',
	'mobile-frontend-nearby-distance-report' => '$1km de votre emplacement actuel',
	'mobile-frontend-nearby-lookup-error' => 'Impossible de vous trouver. Veuillez réessayer…',
	'mobile-frontend-nearby-noresults' => 'Vous êtes au milieu de nulle part et nous ne pouvons trouver aucun sujet. Pourquoi ne pas en écrire un?',
	'mobile-frontend-nearby-refresh' => 'Nous vous avons localisé plus précisément. Cliquez ici pour rafraîchir la liste des pages à proximité.',
	'mobile-frontend-nearby-error' => 'Une erreur inattendue s’est produite lors de la tentative de recherche de pages à proximité',
	'mobile-frontend-donate-image-login' => 'Vous devez être connecté pour voir vos téléchargements.',
	'mobile-frontend-photo-upload-generic' => 'Donner une image',
	'mobile-frontend-donate-image-title' => 'Donner une image',
	'mobile-frontend-donate-image-summary' => "Les photos font vivre les pages sur {{SITENAME}}.
Il y a beaucoup de pages qui n'ont pas de photo à cause d'un manque important de photos libres de droits. Aidez à faire vivre ces pages en donnant vos photos dont vous voulez vous débarrasser et qui pourraient être en aide à la large communauté des éditeurs de {{SITENAME}}.",
	'mobile-frontend-donate-image-heading' => 'Vos dernières contributions',
	'mobile-frontend-donate-image-page-title' => 'Télécharger',
	'mobile-frontend-donate-image-anon' => 'Un [[Special:UserLogin|compte utilisateur]] est nécessaire pour voir la page des téléchargements',
	'mobile-frontend-listed-image-no-description' => 'Aucune description',
	'mobile-frontend-donate-photo-upload-success' => 'Bravo! Votre image peut maintenant être utilisée sur {{SITENAME}}!',
	'mobile-frontend-donate-photo-first-upload-success' => 'Bravo! Merci pour votre première contribution!',
	'mobile-frontend-watchlist-add' => '$1 ajouté à votre liste de suivi',
	'mobile-frontend-watchlist-removed' => '$1 retiré de votre liste de suivi',
	'mobile-frontend-watchlist-view' => 'Afficher votre liste de surveillance',
	'mobile-frontend-watchlist-more' => 'plus',
	'mobile-frontend-watchlist-cta' => 'Veuillez vous connecter ou vous inscrire pour voir cette page.',
	'mobile-frontend-watchlist-cta-button-login' => 'Connectez-vous',
	'mobile-frontend-watchlist-cta-button-signup' => 'Inscrivez-vous',
	'mobile-frontend-watch-login' => 'Vous devez être connecté pour surveiller les pages.',
	'mobile-frontend-watchlist-a-z' => 'Tous',
	'mobile-frontend-watchlist-feed' => 'Modifiés',
	'mobile-frontend-watchlist-a-z-empty' => 'Vous ne consultez actuellement aucune page',
	'mobile-frontend-watchlist-a-z-empty-howto-alt' => 'Cliquez sur l’étoile en haut de la page',
	'mobile-frontend-watchlist-a-z-empty-howto' => 'Suivez une page que vous avez trouvé intéressante en cliquant sur l’icône de l’étoile en haut de l’écran. Cela vous permettra de mettre en favori les pages intéressantes et de voir quand elles sont modifiées.',
	'mobile-frontend-watchlist-feed-empty' => 'Il n’y a pas de pages avec les modifications récentes',
	'mobile-frontend-watchlist-back-home' => 'Retour à l’accueil',
	'mobile-frontend-changeslist-ip' => 'Utilisateur anonyme',
	'mobile-frontend-changeslist-nocomment' => 'aucun résumé de modification',
	'mobile-frontend-watchlist-filter-all' => 'Tous',
	'mobile-frontend-watchlist-filter-articles' => 'Articles',
	'mobile-frontend-watchlist-filter-talk' => 'Discussion',
	'mobile-frontend-watchlist-filter-other' => 'Autres',
	'mobile-frontend-watchlist-modified' => 'Modifié $1',
	'mobile-frontend-diffview-404-title' => 'Mauvaise révision',
	'mobile-frontend-diffview-404-desc' => "L'id de la révision que vous avez demandé n’existe pas.",
	'mobile-frontend-diffview-title' => 'Modifications',
	'mobile-frontend-diffview-editcount' => '$1 {{PLURAL:$1|modification|modifications}}',
	'mobile-frontend-diffview-anonymous' => 'Utilisateur anonyme',
	'mobile-frontend-diffview-bytesadded' => '$1 {{PLURAL:$1|octet ajouté|octets ajoutés}}',
	'mobile-frontend-diffview-bytesremoved' => '$1 {{PLURAL:$1|octet supprimé|octets supprimés}}',
	'mobile-frontend-diffview-explained' => 'Les lignes suivantes ont été ajoutées (+) et supprimées (-):',
	'mobile-frontend-table' => 'Tableau $1',
	'mobile-frontend-saving-exit-page' => "Votre contribution est en train d'être enregistrée. Si vous quittez, vos contributions seront perdues. Êtes-vous sûr de vouloir sortir?",
	'mobile-frontend-photo-upload' => 'Ajouter une image à cet article',
	'mobile-frontend-photo-article-edit-comment' => 'Photo ajoutée pour être utilisée sur la page',
	'mobile-frontend-photo-article-donate-comment' => 'Don d’image à partir d’un appareil mobile',
	'mobile-frontend-photo-upload-comment' => 'Photo ajoutée à la page',
	'mobile-frontend-photo-caption-placeholder' => 'Ajouter une description (obligatoire)',
	'mobile-frontend-image-loading' => "Chargement de l'image",
	'mobile-frontend-image-uploading-wait' => "Téléchargement de l'image, veuillez patienter.",
	'mobile-frontend-image-uploading-long' => 'L’image est en cours de téléchargement! Merci pour votre patience.',
	'mobile-frontend-image-uploading-cancel' => '<a href="#">Annuler</a> si cela dure trop longtemps.',
	'mobile-frontend-photo-upload-error' => "Une erreur s'est produite, veuillez réessayer.",
	'mobile-frontend-photo-upload-success-article' => 'Bravo! Votre image est maintenant en ligne sur cette page.',
	'mobile-frontend-photo-license' => 'En cliquant sur "Soumettre", vous acceptez nos [//wikimediafoundation.org/wiki/Terms_of_use conditions d’utilisation] et la mise à disposition de votre photo sous la [//creativecommons.org/licenses/by-sa/3.0/ licence Creative Commons Attribution-ShareAlike 3.0].',
	'mobile-frontend-photo-submit' => 'Soumettre',
	'mobile-frontend-photo-cancel' => 'Annuler',
	'mobile-frontend-photo-upload-user-count' => '{{PLURAL:$1|1 téléchargement|$1 téléchargements}}', # Fuzzy
	'mobile-frontend-photo-upload-user-count-over-limit' => '500+ téléchargements',
	'tag-mobile_edit' => 'Modification par mobile',
	'tag-mobile_edit-description' => 'Modification effectuée depuis la version mobile',
	'mobile-frontend-drawer-cancel' => 'Annuler',
);

/** Franco-Provençal (arpetan)
 * @author ChrisPtDe
 */
$messages['frp'] = array(
	'mobile-frontend-desc' => 'Frontâl mobilo',
	'mobile-frontend-search-submit' => 'Alar trovar',
	'mobile-frontend-home-button' => 'Reçua',
	'mobile-frontend-logged-out' => 'Pas branchiê',
	'mobile-frontend-logged-in-homepage-notification' => 'Benvegnua, $1 !',
	'mobile-frontend-logged-in-toast-notification' => 'Branchiê coment $1.',
	'mobile-frontend-sign-up-heading' => 'Enscrîde-vos',
	'mobile-frontend-sign-in-heading' => 'Branchement',
	'mobile-frontend-sign-in-error-heading' => 'Chancro !',
	'mobile-frontend-settings-beta' => 'Bèta',
	'mobile-frontend-save-settings' => 'Encartar la configuracion',
	'mobile-frontend-random-button' => 'A l’hasârd',
	'mobile-frontend-ajax-random-heading' => 'Localisacion de la cognessence...',
	'mobile-frontend-ajax-random-question' => 'Liére ceta pâge ?',
	'mobile-frontend-ajax-random-yes' => 'Ouè',
	'mobile-frontend-ajax-random-retry' => 'Tornâd èprovar',
	'mobile-frontend-ajax-random-suggestions' => 'Ôtres idês :',
	'mobile-frontend-back-to-top-of-section' => 'Tornar d’una sèccion',
	'mobile-frontend-close-section' => 'Cllôre ceta sèccion',
	'mobile-frontend-show-button' => 'Montrar',
	'mobile-frontend-hide-button' => 'Cachiér',
	'mobile-frontend-regular-site' => 'Visualisacion classica',
	'mobile-frontend-wml-continue' => 'Continuar ...',
	'mobile-frontend-wml-back' => 'Retôrn ...',
	'mobile-frontend-view' => 'Visualisacion mobila',
	'mobile-frontend-view-desktop' => 'Classica',
	'mobile-frontend-view-mobile' => 'Enfatâblo',
	'mobile-frontend-opt-in-explain' => 'En rentrent dens la bèta-èprôva, vos aréd accès a les fonccionalitâts èxpèrimentâles, u risco de rencontrar cofieries et problèmos.',
	'mobile-frontend-images-status' => 'Émâges',
	'mobile-frontend-disable-images' => 'Dèsctivar les émâges sur lo seto mobilo',
	'mobile-frontend-enable-images' => 'Activar les émâges sur lo seto mobilo',
	'mobile-frontend-missing-image' => 'Émâge',
	'mobile-frontend-off' => 'NAN',
	'mobile-frontend-on' => 'OUÈ',
	'mobile-frontend-footer-contributors-text' => 'Pâge per <a href="$1">contributors</a> coment vos', # Fuzzy
	'mobile-frontend-featured-article' => 'Lumiére dessus...',
	'mobile-frontend-news-items' => 'Dens les novèles',
	'mobile-frontend-leave-feedback-notice' => 'Voutron avis nos édierat a mèlyorar voutra èxpèrience du seto mobilo. Serat postâ publicament (avouéc voutron nom d’usanciér, la vèrsion de voutron navigator et pués voutron sistèmo d’èxplouètacion) sur la pâge « $1 ». Volyéd tâchiér de chouèsir una legne de sujèt parlenta, per ègz. « Problèmos de formatâjo avouéc les trâbles lârges ». Voutron avis est somês a noutres condicions d’usâjo.',
	'mobile-frontend-leave-feedback-subject' => 'Sujèt :',
	'mobile-frontend-leave-feedback-message' => 'Mèssâjo :',
	'mobile-frontend-leave-feedback-submit' => 'Mandar voutron avis',
	'mobile-frontend-leave-feedback-link-text' => 'Avis du frontâl mobilo',
	'mobile-frontend-leave-feedback' => 'Balyér voutron avis',
	'mobile-frontend-leave-feedback-title' => 'Balyéd-nos voutron avis sur voutra èxpèrience du seto mobilo',
	'mobile-frontend-leave-feedback-technical-problem-section-header' => 'Problèmo tècnico',
	'mobile-frontend-leave-feedback-general-section-header' => 'G·ènèral',
	'mobile-frontend-leave-feedback-article-feedback-section-header' => 'Avis sur l’articllo',
	'mobile-frontend-leave-feedback-technical-link-text' => 'Problèmo tècnico',
	'mobile-frontend-leave-feedback-general-link-text' => 'Avis g·ènèral',
	'mobile-frontend-leave-feedback-article-personal-link-text' => 'Por mè, na pèrsona ou ben n’entreprêsa que reprèsento',
	'mobile-frontend-leave-feedback-article-factual-link-text' => 'Por na fôta de chousa',
	'mobile-frontend-leave-feedback-article-other-link-text' => 'Por un ôtro problèmo',
	'mobile-frontend-leave-feedback-form-subject-placeholder' => 'Sujèt du mèssâjo',
	'mobile-frontend-leave-feedback-form-message-placeholder' => 'Buchiéd voutron comentèro ique',
	'mobile-frontend-leave-feedback-page-title' => 'Balyéd-nos voutron avis sur voutra èxpèrience du seto mobilo',
	'mobile-frontend-leave-feedback-special-title' => 'Sè veriér vers nos',
	'mobile-frontend-feedback-no-subject' => '(gins de sujèt)',
	'mobile-frontend-feedback-no-subject-field' => 'Volyéd buchiér un sujèt',
	'mobile-frontend-feedback-no-message' => 'Volyéd buchiér un mèssâjo ique',
	'mobile-frontend-leave-feedback-thanks' => 'Grant-marci por voutron avis !',
	'mobile-frontend-language' => 'Lengoua :',
	'mobile-frontend-language-article-heading' => 'Liére dens n’ôtra lengoua',
	'mobile-frontend-language-header' => 'Ceta pâge est disponibla en $1 lengou{{PLURAL:$1|a|es}}',
	'mobile-frontend-language-variant-header' => 'Chouèsésséd la varianta {{#language:{{CONTENTLANG}}}}',
	'mobile-frontend-language-footer' => 'Nota : ceta pâge pôt pas étre ècrita dens voutra lengoua prèferâye. Vos pouede vêre les lengoues recognues per {{SITENAME}} en cliquent ique.',
	'mobile-frontend-language-site-choose' => 'Rechèrchiér la lengoua',
	'mobile-frontend-username' => 'Nom d’utilisator :',
	'mobile-frontend-password' => 'Contresegno :',
	'mobile-frontend-username-placeholder' => 'Nom d’utilisator',
	'mobile-frontend-password-placeholder' => 'Contresegno',
	'mobile-frontend-login' => 'Sè branchiér',
	'mobile-frontend-account-create-submit' => 'Enscrîde-vos',
	'mobile-frontend-password-confirm-placeholder' => 'Confirmâd lo contresegno',
	'mobile-frontend-account-create-email-placeholder' => 'Adrèce èlèctronica (u chouèx)',
	'mobile-frontend-account-create-captcha-placeholder' => 'Buchiéd lo tèxto de sècuritât',
	'mobile-frontend-overlay-escape' => 'Retôrn',
	'mobile-frontend-placeholder' => 'Rechèrchiér dessus {{SITENAME}}',
	'mobile-frontend-placeholder-beta' => 'Rechèrchiér dessus {{SITENAME}} (Bèta)',
	'mobile-frontend-placeholder-alpha' => 'Rechèrchiér dessus {{SITENAME}} (Fôrma Dragon)',
	'mobile-frontend-dismiss-notification' => 'refusar ceta notificacion',
	'mobile-frontend-clear-search' => 'Èfaciér',
	'mobile-frontend-privacy-link-text' => 'Confidencialitât',
	'mobile-frontend-about-link-text' => 'A propôs',
	'mobile-frontend-footer-sitename' => '{{SITENAME}}',
	'mobile-frontend-footer-contact' => 'Contacte',
	'mobile-frontend-main-menu-button-tooltip' => 'Uvrir lo menu principâl',
	'mobile-frontend-main-menu-page-title' => 'Navigacion du seto',
	'mobile-frontend-main-menu-featured' => 'Remarcâblo',
	'mobile-frontend-main-menu-nearby' => 'De prés',
	'mobile-frontend-main-menu-login' => 'Branchiéd-vos',
	'mobile-frontend-main-menu-logout' => 'Sè dèbranchiér',
	'mobile-frontend-main-menu-watchlist' => 'Lista de survelyence',
	'mobile-frontend-main-menu-settings' => 'Configuracion',
	'mobile-frontend-main-menu-settings-heading' => 'Configuracion du seto mobilo',
	'mobile-frontend-settings-site-header' => 'Lengoues de {{SITENAME}}',
	'mobile-frontend-settings-site-description' => '{{SITENAME}} est disponiblo en $1 lengou{{PLURAL:$1|a|es}}. Totes les vèrsions disponibles sont listâyes ce-desot',
	'mobile-frontend-main-menu-contact' => 'Contacte',
	'mobile-frontend-main-menu-account-create' => 'Fâre un compto',
	'mobile-frontend-page-menu-contents' => 'contegnu',
	'mobile-frontend-page-menu-history' => 'Historico',
	'mobile-frontend-meta-data-issues-header' => 'Problèmos',
	'mobile-frontend-meta-data-issues' => 'Ceta pâge at doux-três problèmos',
	'mobile-frontend-ajax-page-loading' => 'Chargement de $1',
	'mobile-frontend-page-saving' => 'Encartâjo de $1',
	'mobile-frontend-photo-upload-generic' => 'Balyér n’émâge',
	'mobile-frontend-donate-image-title' => 'Balyér n’émâge',
	'mobile-frontend-donate-image-heading' => 'Voutres dèrriéres contribucions',
	'mobile-frontend-watchlist-add' => '$1 apondu a voutra lista de survelyence',
	'mobile-frontend-watchlist-removed' => '$1 enlevâ de voutra lista de survelyence',
	'mobile-frontend-watchlist-view' => 'Vêre voutra lista de survelyence',
	'mobile-frontend-watchlist-a-z' => 'Pâges siuvues', # Fuzzy
	'mobile-frontend-watchlist-feed' => 'Pâges avouéc changements', # Fuzzy
	'mobile-frontend-changeslist-ip' => 'Utilisator anonimo',
	'mobile-frontend-changeslist-nocomment' => 'nion rèsumâ de changement',
	'mobile-frontend-watchlist-filter-all' => 'Totes',
	'mobile-frontend-watchlist-filter-articles' => 'Articllos',
	'mobile-frontend-watchlist-filter-talk' => 'Discussion',
	'mobile-frontend-watchlist-filter-other' => 'Ôtres',
	'mobile-frontend-diffview-title' => 'Changements a $1', # Fuzzy
	'mobile-frontend-diffview-editcount' => '$1 changement{{PLURAL:$1||s}}',
	'mobile-frontend-diffview-anonymous' => 'Utilisator anonimo',
	'mobile-frontend-diffview-bytesadded' => '$1 {{PLURAL:$1|octèt apondu|octèts apondus}}',
	'mobile-frontend-diffview-bytesremoved' => '$1 {{PLURAL:$1|octèt enlevâ|octèts enlevâs}}',
	'mobile-frontend-table' => 'Grelye $1',
	'mobile-frontend-photo-upload' => 'Apondre la premiére fotô a ceta pâge',
	'mobile-frontend-photo-article-edit-comment' => 'Fotô apondua por étre empleyêye sur la pâge',
	'mobile-frontend-photo-upload-comment' => 'Fotô apondua a la pâge',
	'mobile-frontend-photo-upload-progress' => 'Tèlèchargement de voutron émâge dens ceta pâge',
	'mobile-frontend-photo-caption-placeholder' => 'Apondre na lègenda por cet’émâge',
	'mobile-frontend-image-loading' => 'Chargement de l’émâge',
	'mobile-frontend-image-uploading' => 'Tèlèchargement de l’émâge',
	'mobile-frontend-image-saving-to-article' => 'Encartâjo de l’émâge dens la pâge',
);

/** Northern Frisian (Nordfriisk)
 * @author Murma174
 */
$messages['frr'] = array(
	'mobile-frontend-desc' => 'Iinstelang för mobiil aperooten',
	'mobile-frontend-search-submit' => 'Widjer',
	'mobile-frontend-home-button' => 'Tüs',
	'mobile-frontend-logged-out' => 'Ei uunmeldet',
	'mobile-frontend-logged-in-homepage-notification' => 'Welkimen, $1!',
	'mobile-frontend-logged-in-toast-notification' => 'Uunmeldet üs $1',
	'mobile-frontend-sign-up-heading' => 'Skriiw di iin',
	'mobile-frontend-sign-in-heading' => 'Skriiw di iin',
	'mobile-frontend-sign-in-why' => 'Wan dü en {{SITENAME}}-brükerkonto heest, könst dü di oner uunmelde.',
	'mobile-frontend-sign-in-error-heading' => 'Uups!',
	'mobile-frontend-settings-description' => 'Paase dan mobiil aperoot mä jodiar iinstelangen uun.',
	'mobile-frontend-settings-beta' => 'Beta',
	'mobile-frontend-settings-alpha' => '[//de.wikipedia.org/wiki/Hic_sunt_dracones „Hic sunt dracones“]-Modus',
	'mobile-frontend-settings-alpha-description' => 'Enter dangerous and unexplored mobile territory. Get even more experimental features but with more danger of bugs.',
	'mobile-frontend-save-settings' => 'Iinstelangen seekre',
	'mobile-frontend-random-button' => 'Tufaal',
	'mobile-frontend-ajax-random-heading' => 'Weden lokalisiare ...',
	'mobile-frontend-ajax-random-quote' => 'Det liaren begant, wan dü üüb a welt komst, an häält iarst mä a duas ap.',
	'mobile-frontend-ajax-random-question' => 'Wel dü detdiar sidj lees?',
	'mobile-frontend-ajax-random-yes' => 'Ja',
	'mobile-frontend-ajax-random-retry' => 'Noch ans fersjük',
	'mobile-frontend-ajax-random-suggestions' => 'Ööder föörslacher:',
	'mobile-frontend-back-to-top-of-section' => 'En straal turag gung',
	'mobile-frontend-close-section' => 'Detdiar sektsjuun sacht maage',
	'mobile-frontend-show-button' => 'Wise',
	'mobile-frontend-hide-button' => 'Fersteeg',
	'mobile-frontend-empty-homepage-text' => 'Detdiar homepage skal noch iinracht wurd.
[//meta.wikimedia.org/wiki/Mobile_Projects/Mobile_Gateway#Mobile_homepage Lees widjer hü det gongt]',
	'mobile-frontend-regular-site' => 'Normool uunsicht',
	'mobile-frontend-wml-continue' => 'Widjer ...',
	'mobile-frontend-wml-back' => 'Turag ...',
	'mobile-frontend-view' => 'Mobiil uunsicht',
	'mobile-frontend-view-desktop' => 'Normool uunsicht',
	'mobile-frontend-view-mobile' => 'Mobiil uunsicht',
	'mobile-frontend-opt-in-explain' => 'Wan dü bi a beta-test mämaaget, heest dü muar mögelkhaiden, ferlicht werket det oober noch ei ales so üs det skal.',
	'mobile-frontend-images-status' => 'Bilen',
	'mobile-frontend-disable-images' => "Nian bilen uunwise bi't mobiil uunsicht",
	'mobile-frontend-enable-images' => "Bilen uunwise bi't mobiil uunsicht",
	'mobile-frontend-missing-image' => 'Bil',
	'mobile-frontend-off' => 'ÜTJ',
	'mobile-frontend-on' => 'UUN',
	'mobile-frontend-footer-contributors-text' => 'Sidj faan [$1 brükern] liküs di',
	'mobile-frontend-featured-article' => 'Artiikel faan a muun',
	'mobile-frontend-news-items' => 'Uun a noorachten',
	'mobile-frontend-leave-feedback-notice' => 'Dan komentaar helept üs, det mobiil uunsicht tu ferbeedrin. Hi woort üüb det sidj &quot;$1&quot; uunwiset. Diarbi woort uk dan brükernööm, dan browser an din bedrifsüsteem uunwiset. För ales wat dü skrafst, tääl üüs brüker-reegeln.',
	'mobile-frontend-leave-feedback-warning' => 'Skriiw niks persöönelks, wan dü ei wel, dat arken det lees koon.',
	'mobile-frontend-leave-feedback-subject' => 'Teemoo:',
	'mobile-frontend-leave-feedback-message' => 'Nooracht:',
	'mobile-frontend-leave-feedback-submit' => 'Komentaar ufsjüür',
	'mobile-frontend-leave-feedback-link-text' => "Komentaar tu't mobiil uunsicht",
	'mobile-frontend-leave-feedback' => 'Komentaar skriiw',
	'mobile-frontend-leave-feedback-title' => "Komentaar tu't mobiil uunsicht",
	'mobile-frontend-leave-feedback-technical-problem-section-header' => 'Technisk probleem',
	'mobile-frontend-leave-feedback-general-section-header' => 'Algemian',
	'mobile-frontend-leave-feedback-article-feedback-section-header' => 'Komentaar tu di artiikel',
	'mobile-frontend-leave-feedback-email-body' => 'Beskriiw di komer, di dü mä det sidj {{SITENAME}} heest, auer detdiar rä. Wi kön oober ei üüb arke nooracht glik swaare.',
	'mobile-frontend-leave-feedback-technical-link-text' => 'Technisk probleem',
	'mobile-frontend-leave-feedback-general-link-text' => 'Algemian komentaar',
	'mobile-frontend-leave-feedback-article-personal-link-text' => 'Tu mi, en persuun of en onernemen',
	'mobile-frontend-leave-feedback-article-factual-link-text' => 'Tu en feeler',
	'mobile-frontend-leave-feedback-article-other-link-text' => 'Tu wat ööders',
	'mobile-frontend-leave-feedback-form-subject-placeholder' => "Teemoo faan't nooracht",
	'mobile-frontend-leave-feedback-form-message-placeholder' => 'Skriiw din nooracht diar',
	'mobile-frontend-leave-feedback-page-title' => "Komentaar tu't mobiil uunsicht",
	'mobile-frontend-leave-feedback-special-title' => 'Kontaktiire üüs',
	'mobile-frontend-feedback-no-subject' => '(nian teemoo)',
	'mobile-frontend-feedback-no-subject-field' => 'Wees so gud an du en teemoo uun',
	'mobile-frontend-feedback-no-message' => 'Skriiw din nooracht diar',
	'mobile-frontend-feedback-edit-summary' => '$1 - automaatisk seekerd [[Special:MobileFeedback|komentaar]]',
	'mobile-frontend-leave-feedback-thanks' => 'Föl soonk för dan komentaar!',
	'mobile-frontend-leave-feedback-post-error' => "Bi't ferwerkin faan din nooracht as wat skiaf gingen. Fersjük det leeder noch ans.",
	'mobile-frontend-language' => 'Spriak:',
	'mobile-frontend-language-article-heading' => 'Uun en ööder spriak lees',
	'mobile-frontend-language-header' => 'Detdiar sidj jaft at uun {{PLURAL:$1|ian spriak|$1 spriaken}}.',
	'mobile-frontend-language-variant-header' => 'Spriak ütjsjük faan {{#language:{{CONTENTLANG}}}}',
	'mobile-frontend-language-footer' => 'Detdiar sidj as ferlicht ei uun din spriak skrewen. Wan dü diar trakst, könst dü sä, uun hük spriaken {{SITENAME}} skrewen as.',
	'mobile-frontend-language-site-choose' => 'Spriak sjük',
	'mobile-frontend-username' => 'Brükernööm:',
	'mobile-frontend-password' => 'Paaswurd:',
	'mobile-frontend-username-placeholder' => 'Brükernööm',
	'mobile-frontend-password-placeholder' => 'Paaswurd',
	'mobile-frontend-login' => 'Uunmelde',
	'mobile-frontend-last-modified-date' => 'Tuleetst feranert di $1 am a klook $2',
	'mobile-frontend-last-modified-seconds' => 'Tuleetst feranert föör {{PLURAL:$1|ian sekund|$1 sekunden}}',
	'mobile-frontend-last-modified-minutes' => 'Tuleetst feranert föör {{PLURAL:$1|ian minüüt|$1 minüüten}}',
	'mobile-frontend-last-modified-hours' => 'Tuleetst feranert föör {{PLURAL:$1|ian stünj|$1 stünjen}}',
	'mobile-frontend-last-modified-days' => 'Tuleetst feranert föör {{PLURAL:$1|ään dai|$1 daar}}',
	'mobile-frontend-last-modified-months' => 'Tuleetst feranert föör {{PLURAL:$1|ään muun|$1 muuner}}',
	'mobile-frontend-last-modified-years' => 'Tuleetst feranert föör {{PLURAL:$1|ian juar|$1 juaren}}',
	'mobile-frontend-account-create-submit' => 'Skriiw di iin',
	'mobile-frontend-password-confirm-placeholder' => 'Paaswurd gudkään',
	'mobile-frontend-account-create-email-placeholder' => 'E-mail adres (optional)',
	'mobile-frontend-account-create-captcha-placeholder' => 'Seekerhaidstekst iindu',
	'mobile-frontend-overlay-escape' => 'Turag',
	'mobile-frontend-placeholder' => 'Schük üüb {{SITENAME}}',
	'mobile-frontend-placeholder-beta' => 'Sjük {{SITENAME}} (Beta)',
	'mobile-frontend-placeholder-alpha' => 'Sjük {{SITENAME}} (Dragon Mode)',
	'mobile-frontend-search-help' => 'Du boowen det wurd iin, huar dü efter sjükst. Paaselk sidjennöömer wurd do heer uunwiset.',
	'mobile-frontend-dismiss-notification' => 'Detdiar nooracht strik',
	'mobile-frontend-clear-search' => 'Leesag maage',
	'mobile-frontend-privacy-link-text' => 'Dootenseekerhaid',
	'mobile-frontend-about-link-text' => 'Auer',
	'mobile-frontend-footer-sitename' => '{{SITENAME}}',
	'mobile-frontend-footer-license-text' => 'Stäänt oner det lisens [//en.m.wikipedia.org/wiki/Wikipedia:Text_of_Creative_Commons_Attribution-ShareAlike_3.0_Unported_License?useformat=mobile CC BY-SA 3.0]',
	'mobile-frontend-terms-use-text' => '[//wikimediafoundation.org/wiki/Terms_of_use?useformat=mobile Brüker reegeln]',
	'mobile-frontend-footer-contact' => 'Kontakt',
	'mobile-frontend-search-noresults' => "So'n sidj jaft at ei. Sjük en ööder sidj of trak üüb di sjük-knoop faan din tastatuur, am det wurd uk banen uun en sidj tu sjüken.",
	'mobile-frontend-main-menu-button-tooltip' => 'Hoodütjwool eeben maage',
	'mobile-frontend-main-menu-page-title' => 'Sidjen nawigatsjuun',
	'mobile-frontend-main-menu-featured' => 'Auer a miaten',
	'mobile-frontend-main-menu-nearby' => 'Naibi',
	'mobile-frontend-main-menu-login' => 'Uunmelde',
	'mobile-frontend-main-menu-logout' => 'Ufmelde',
	'mobile-frontend-main-menu-watchlist' => "Uun't uug behual",
	'mobile-frontend-main-menu-settings' => 'Iinstelangen',
	'mobile-frontend-main-menu-upload' => 'Huuchsjüürd dateien',
	'mobile-frontend-main-menu-settings-heading' => 'Mobiil iinstelangen',
	'mobile-frontend-settings-site-header' => '{{SITENAME}} Spriaken',
	'mobile-frontend-settings-site-description' => '{{SITENAME}} jaft at uun {{PLURAL:$1|ian spriak|$1 spriaken}}. A spriaken san oner apfeerd.',
	'mobile-frontend-main-menu-contact' => 'Kontakt',
	'mobile-frontend-main-menu-account-create' => 'Brükerkonto iinracht',
	'mobile-frontend-page-menu-contents' => 'Wat diar uun stäänt',
	'mobile-frontend-page-menu-history' => 'histoore',
	'mobile-frontend-meta-data-issues-header' => 'Komer',
	'mobile-frontend-meta-data-issues' => 'Mä detdiar sidj stemet wat ei.',
	'mobile-frontend-ajax-page-loading' => 'Loose $1',
	'mobile-frontend-page-saving' => 'Seekre $1',
	'mobile-frontend-ajax-page-error' => 'Uups! Diar as wat skiaf gingen. Aktualisiere din browser wönang.',
	'mobile-frontend-nearby-title' => 'Naibi',
	'mobile-frontend-nearby-loading' => 'Uun a naite',
	'mobile-frontend-nearby-requirements' => 'För detdiar sidj brükst dü JavaScript an en browser, diar mä geograafisk dooten amkoon.',
	'mobile-frontend-nearby-distance-report' => '$1km faan di wech',
	'mobile-frontend-nearby-lookup-error' => 'Dü küdst ei fünjen wurd. Fersjük det man noch ans nei.',
	'mobile-frontend-nearby-noresults' => 'Wi küd niks finj. Wel ei salew wat skriiw?',
	'mobile-frontend-nearby-refresh' => 'Wi haa en beeder steed för di fünjen. Trak diar för aktuel sidjen.',
	'mobile-frontend-nearby-error' => "Diar as wat skiaf gingen bi't sjüken faan sidjen uun a naite.",
	'mobile-frontend-donate-image-login' => 'Melde di uun, am din huuchsjüürd dateien uuntulukin.',
	'mobile-frontend-photo-upload-generic' => 'Skeenk en bil',
	'mobile-frontend-donate-image-title' => 'Skeenk en bil',
	'mobile-frontend-donate-image-summary' => 'Mä bilen wurd sidjen uun {{SITENAME}} labener. Flook sidjen haa nian bilen, auer diar nianen mä en frei lisens san. Wan dü din bilen skeenkst, kön ja uk faan öödern, diar {{SITENAME}} bewerke, brükt wurd.',
	'mobile-frontend-donate-image-heading' => 'Din leetst bidracher.',
	'mobile-frontend-donate-image-page-title' => 'Huuchsjüür',
	'mobile-frontend-donate-image-anon' => 'Dü brükst en [[Special:UserLogin|brükerkonto]], am huuchsjüürd dateien uuntulukin.',
	'mobile-frontend-listed-image-no-description' => 'Nian beskriiwang',
	'mobile-frontend-donate-photo-upload-success' => 'Klaar! Din bil koon nü brükt wurd üüb {{SITENAME}}!',
	'mobile-frontend-donate-photo-first-upload-success' => 'Klaar! Föl soonk för dan iarst bidrach!',
	'mobile-frontend-watchlist-add' => "$1 woort uun't uug behäälen.",
	'mobile-frontend-watchlist-removed' => "$1 woort ei muar uun't uug behäälen.",
	'mobile-frontend-watchlist-view' => "Wat ik uun't uug behual wal",
	'mobile-frontend-watchlist-more' => 'muar',
	'mobile-frontend-watchlist-cta' => 'Wess so gud an melde di uun of skriiw di iin, am det sidj uuntulukin.',
	'mobile-frontend-watchlist-cta-button-login' => 'Uunmelde',
	'mobile-frontend-watchlist-cta-button-signup' => 'Skriiw di iin',
	'mobile-frontend-watch-login' => "Dü skel di uunmelde, am sidjen uun't uug tu behualen.",
	'mobile-frontend-watchlist-a-z' => 'Aaltumaal',
	'mobile-frontend-watchlist-feed' => 'Feranert sidjen',
	'mobile-frontend-watchlist-a-z-empty' => 'Uun uugenblak lukest dü nian sidjen uun.',
	'mobile-frontend-watchlist-a-z-empty-howto-alt' => 'Klike üüb di stäär boowen üüb a sidj',
	'mobile-frontend-watchlist-a-z-empty-howto' => "Wan dü üüb di stäär boowen üüb a sidj klikest, behäälst dü det sidj uun't uug. So könst dü ferfulge, wan det sidj feranert woort.",
	'mobile-frontend-watchlist-feed-empty' => 'Diar san nian sidjen uun a leetst tidj feranert wurden.',
	'mobile-frontend-watchlist-back-home' => "Tüs tu't hoodsidj",
	'mobile-frontend-changeslist-ip' => 'Anonüüm brüker',
	'mobile-frontend-changeslist-nocomment' => 'nian tuupfaadang',
	'mobile-frontend-watchlist-filter-all' => 'Aaltumaal',
	'mobile-frontend-watchlist-filter-articles' => 'Artiikler',
	'mobile-frontend-watchlist-filter-talk' => 'Diskusjuun',
	'mobile-frontend-watchlist-filter-other' => 'Ööders wat',
	'mobile-frontend-watchlist-modified' => 'Feranert $1',
	'mobile-frontend-diffview-404-title' => 'Det werjuun docht niks',
	'mobile-frontend-diffview-404-desc' => 'Detdiar werjuun hää nian käännumer',
	'mobile-frontend-diffview-title' => 'Feranrangen',
	'mobile-frontend-diffview-editcount' => '{{PLURAL:$1|Ian feranrang|$1 feranrangen}}',
	'mobile-frontend-diffview-anonymous' => 'Anonüüm brüker',
	'mobile-frontend-diffview-bytesadded' => '{{PLURAL:$1|ian byte|$1 bytes}} diartu kimen',
	'mobile-frontend-diffview-bytesremoved' => '{{PLURAL:$1|ian byte|$1 bytes}} wechnimen',
	'mobile-frontend-diffview-explained' => 'Jodiar räen kaam diartu (+) of san wechnimen wurden (−):',
	'mobile-frontend-table' => 'Tabel $1',
	'mobile-frontend-saving-exit-page' => 'Dan bidrach woort noch seekert. Wan dü nü ufbräächst, as dan bidrach wech. Wel dü würelk ufbreeg?',
	'mobile-frontend-photo-upload' => 'Saat en bil tu di artiikel',
	'mobile-frontend-photo-article-edit-comment' => 'Bil för det sidj diartu saat',
	'mobile-frontend-photo-article-donate-comment' => 'Skeenkt bil faan en mobiilen aperoot',
	'mobile-frontend-photo-upload-comment' => 'Bil tu det sidj diartu saat',
	'mobile-frontend-photo-caption-placeholder' => 'Saat en beskriiwang för det bil diartu (nuadag)',
	'mobile-frontend-image-loading' => 'Loose det bil ...',
	'mobile-frontend-image-uploading-wait' => 'Sjüür bil huuch, ... wees so gud an teew.',
	'mobile-frontend-image-uploading-long' => 'Bil woort huuchsjüürd! Föl soonk, dat dü dülag beest.',
	'mobile-frontend-image-uploading-cancel' => '<a href="#">Breeg uf</a>, wan\'t tu loong düüret.',
	'mobile-frontend-photo-upload-error' => 'Diar as wat skiaf gingen. Fersjük det man noch ans nei.',
	'mobile-frontend-photo-upload-success-article' => 'Klaar! Din bil as nü üüb det sidj tu sen.',
	'mobile-frontend-photo-license' => "Wan dü det bil huuchsjüürst, stemest dü a [//wikimediafoundation.org/wiki/Terms_of_use brükerreegeln] tu an dat din bil oner det lisens [//en.wikipedia.org/wiki/Wikipedia:Text_of_Creative_Commons_Attribution-ShareAlike_3.0_Unported_License Creative Common Attribution-ShareAlike 3.0] uun't näät steld woort.", # Fuzzy
	'mobile-frontend-photo-submit' => 'Auerdreeg',
	'mobile-frontend-photo-cancel' => 'Ufbreeg',
	'mobile-frontend-photo-upload-user-count' => '{{PLURAL:$1|1 huuchsjüürd bil|$1 huuchsjüürd bilen}}', # Fuzzy
	'mobile-frontend-photo-upload-user-count-over-limit' => 'muar üs 500 huuchsjüürd bilen',
	'tag-mobile_edit' => 'Mobiil feranerang',
	'tag-mobile_edit-description' => 'Faan en mobiil wääbsidj feranert',
	'mobile-frontend-drawer-cancel' => 'Ufbreeg',
);

/** Friulian (furlan)
 */
$messages['fur'] = array(
	'mobile-frontend-search-submit' => 'Va',
	'mobile-frontend-home-button' => 'Cjase',
	'mobile-frontend-random-button' => 'Casuâl',
	'mobile-frontend-back-to-top-of-section' => 'Salte indaûr di une sezion',
	'mobile-frontend-show-button' => 'Mostre',
	'mobile-frontend-hide-button' => 'Plate',
	'mobile-frontend-regular-site' => 'Viôt cheste pagjine te Vichipedie', # Fuzzy
	'mobile-frontend-featured-article' => 'Articul in vitrine di vuê',
);

/** Irish (Gaeilge)
 * @author පසිඳු කාවින්ද
 */
$messages['ga'] = array(
	'mobile-frontend-show-button' => 'Taispeáin',
	'mobile-frontend-hide-button' => 'Folaigh',
	'mobile-frontend-leave-feedback-message' => 'Teachtaireacht:',
	'mobile-frontend-language' => 'Teanga:',
	'mobile-frontend-username' => 'Ainm úsáideora:',
	'mobile-frontend-password' => "D'fhocal faire:",
	'mobile-frontend-login' => 'Logáil isteach',
	'mobile-frontend-about-link-text' => 'Maidir leis',
	'mobile-frontend-footer-sitename' => '{{SITENAME}}',
	'mobile-frontend-main-menu-settings' => 'Sainroghanna',
	'mobile-frontend-page-menu-history' => 'Stair',
);

/** Scottish Gaelic (Gàidhlig)
 * @author Akerbeltz
 */
$messages['gd'] = array(
	'mobile-frontend-search-submit' => 'Rach',
	'mobile-frontend-home-button' => 'Dhachaigh',
	'mobile-frontend-random-button' => 'Air thuaiream',
	'mobile-frontend-back-to-top-of-section' => 'Leum earrann air ais',
	'mobile-frontend-show-button' => 'Seall',
	'mobile-frontend-hide-button' => 'Falaich',
	'mobile-frontend-regular-site' => 'Sealladh desktop',
	'mobile-frontend-featured-article' => 'Artaigil taghta an-diugh',
);

/** Galician (galego)
 * @author MetalBrasil
 * @author Toliño
 */
$messages['gl'] = array(
	'mobile-frontend-desc' => 'Interface para dispositivos móbiles',
	'mobile.css' => '/* O CSS que se coloque aquí afectará a quen use o sitio móbil */',
	'mobile.js' => '/* O JavaScript que se coloque aquí afectará a quen use o sitio móbil */',
	'mobile-frontend-search-submit' => 'Ir',
	'mobile-frontend-home-button' => 'Portada',
	'mobile-frontend-logged-out' => 'Non accedeu ao sistema',
	'mobile-frontend-logged-in-homepage-notification' => 'Reciba a nosa benvida, $1!',
	'mobile-frontend-logged-in-toast-notification' => 'Accedeu ao sistema como $1.',
	'mobile-frontend-sign-up-heading' => 'Crear unha conta',
	'mobile-frontend-sign-in-heading' => 'Acceder',
	'mobile-frontend-sign-in-why' => 'Se ten unha conta en {{SITENAME}}, pode acceder a continuación.',
	'mobile-frontend-sign-in-error-heading' => 'Vaites!',
	'mobile-frontend-settings-description' => 'Personalice a súa experiencia desde o dispositivo móbil con estas configuracións para versión móbil do sitio.',
	'mobile-frontend-settings-beta' => 'Beta',
	'mobile-frontend-settings-alpha' => 'Modo "[//en.wikipedia.org/wiki/Here_be_dragons Hic sunt dracones]"',
	'mobile-frontend-settings-alpha-description' => 'Entre nun territorio móbil perigoso e sen explorar. Consiga as características máis experimentais, pero con máis risco de erros.',
	'mobile-frontend-save-settings' => 'Gardar as configuracións',
	'mobile-frontend-random-button' => 'Ao chou',
	'mobile-frontend-ajax-random-heading' => 'Localizando o coñecemento...',
	'mobile-frontend-ajax-random-quote' => 'O crecemento intelectual debe comezar co nacemento e cesar unicamente coa morte',
	'mobile-frontend-ajax-random-question' => 'Quere ler esta páxina?',
	'mobile-frontend-ajax-random-yes' => 'Si',
	'mobile-frontend-ajax-random-retry' => 'Intentalo de novo',
	'mobile-frontend-ajax-random-suggestions' => 'Outras suxestións:',
	'mobile-frontend-back-to-top-of-section' => 'Volver ao comezo da sección',
	'mobile-frontend-close-section' => 'Pechar esta sección',
	'mobile-frontend-show-button' => 'Mostrar',
	'mobile-frontend-hide-button' => 'Agochar',
	'mobile-frontend-empty-homepage-text' => 'Cómpre configurar a páxina de inicio. [//meta.wikimedia.org/wiki/Mobile_Projects/Mobile_Gateway#Mobile_homepage Instrucións para activar o sitio móbil]',
	'mobile-frontend-regular-site' => 'Vista normal',
	'mobile-frontend-wml-continue' => 'Continuar...',
	'mobile-frontend-wml-back' => 'Volver...',
	'mobile-frontend-view' => 'Vista móbil',
	'mobile-frontend-view-desktop' => 'Escritorio',
	'mobile-frontend-view-mobile' => 'Móbil',
	'mobile-frontend-opt-in-explain' => 'Ao entrar nas probas da versión móbil terá acceso ás características experimentais, correndo o risco de atopar erros e problemas.',
	'mobile-frontend-images-status' => 'Imaxes',
	'mobile-frontend-disable-images' => 'Desactivar as imaxes na versión móbil',
	'mobile-frontend-enable-images' => 'Activar as imaxes na versión móbil',
	'mobile-frontend-missing-image' => 'Imaxe',
	'mobile-frontend-off' => 'DESACTIVADAS',
	'mobile-frontend-on' => 'ACTIVADAS',
	'mobile-frontend-footer-contributors-text' => 'Páxina realizada por [$1 colaboradores] coma vostede',
	'mobile-frontend-featured-article' => 'Artigo destacado',
	'mobile-frontend-news-items' => 'Actualidade',
	'mobile-frontend-leave-feedback-notice' => 'Os seus comentarios axúdannos a mellorar a súa experiencia na versión móbil. Faremos os comentarios públicos (xunto ao seu nome de usuario, versión do navegador e sistema operativo) na páxina &quot;$1&quot;. Intente elixir unha liña de asunto informativa; por exemplo, "Problemas de formato co largo das táboas". Os seus comentarios están suxeitos aos nosos termos de uso.',
	'mobile-frontend-leave-feedback-warning' => 'A menos que acepte facer pública a súa información, non inclúa información persoal nos seus comentarios.',
	'mobile-frontend-leave-feedback-subject' => 'Asunto:',
	'mobile-frontend-leave-feedback-message' => 'Mensaxe:',
	'mobile-frontend-leave-feedback-submit' => 'Enviar os comentarios',
	'mobile-frontend-leave-feedback-link-text' => 'Extensión para deixar comentarios sobre a versión móbil',
	'mobile-frontend-leave-feedback' => 'Comentarios sobre a versión móbil',
	'mobile-frontend-leave-feedback-title' => 'Comentarios sobre a versión móbil',
	'mobile-frontend-leave-feedback-technical-problem-section-header' => 'Problema técnico',
	'mobile-frontend-leave-feedback-general-section-header' => 'Xeral',
	'mobile-frontend-leave-feedback-article-feedback-section-header' => 'Comentarios sobre o artigo',
	'mobile-frontend-leave-feedback-email-body' => 'Describa o problema que atopou en {{SITENAME}} por riba desta liña. Teña en conta que non podemos dar resposta a todas as mensaxes que recibimos.',
	'mobile-frontend-leave-feedback-technical-link-text' => 'Problema técnico',
	'mobile-frontend-leave-feedback-general-link-text' => 'Comentarios xerais',
	'mobile-frontend-leave-feedback-article-personal-link-text' => 'Respecto a min, unha persoa ou compañía que represento',
	'mobile-frontend-leave-feedback-article-factual-link-text' => 'Respecto a un erro',
	'mobile-frontend-leave-feedback-article-other-link-text' => 'Respecto a outro problema',
	'mobile-frontend-leave-feedback-form-subject-placeholder' => 'Asunto da mensaxe',
	'mobile-frontend-leave-feedback-form-message-placeholder' => 'Escriba aquí o comentario',
	'mobile-frontend-leave-feedback-page-title' => 'Comentarios sobre a versión móbil',
	'mobile-frontend-leave-feedback-special-title' => 'Contacte con nós',
	'mobile-frontend-feedback-no-subject' => '(sen asunto)',
	'mobile-frontend-feedback-no-subject-field' => 'Escriba un asunto',
	'mobile-frontend-feedback-no-message' => 'Escriba aquí unha mensaxe',
	'mobile-frontend-feedback-edit-summary' => '$1 - publicado automaticamente mediante a [[Special:MobileFeedback|ferramenta de comentarios sobre a versión móbil]]',
	'mobile-frontend-leave-feedback-thanks' => 'Grazas polos seus comentarios!',
	'mobile-frontend-leave-feedback-post-error' => 'Houbo un erro ao procesar a súa mensaxe. Inténteo de novo máis tarde.',
	'mobile-frontend-language' => 'Lingua:',
	'mobile-frontend-language-article-heading' => 'Ler noutra lingua',
	'mobile-frontend-language-header' => 'Esta páxina está dispoñible en $1 {{PLURAL:$1|lingua|linguas}}',
	'mobile-frontend-language-variant-header' => 'Escolla a variante {{#language:{{CONTENTLANG}}}}',
	'mobile-frontend-language-footer' => 'Nota: Se cadra esta páxina non está escrita na súa lingua preferida. Pode facer clic aquí para consultar as linguas que soporta {{SITENAME}}.',
	'mobile-frontend-language-site-choose' => 'Procurar unha lingua',
	'mobile-frontend-username' => 'Nome de usuario:',
	'mobile-frontend-password' => 'Contrasinal:',
	'mobile-frontend-username-placeholder' => 'Nome de usuario',
	'mobile-frontend-password-placeholder' => 'Contrasinal',
	'mobile-frontend-login' => 'Rexistro',
	'mobile-frontend-last-modified-date' => 'Última modificación o $1 ás $2',
	'mobile-frontend-last-modified-seconds' => 'Última modificación hai {{PLURAL:$1|$1 segundo|$1 segundos}}',
	'mobile-frontend-last-modified-minutes' => 'Última modificación hai {{PLURAL:$1|$1 minuto|$1 minutos}}',
	'mobile-frontend-last-modified-hours' => 'Última modificación hai {{PLURAL:$1|$1 hora|$1 horas}}',
	'mobile-frontend-last-modified-days' => 'Última modificación hai {{PLURAL:$1|$1 día|$1 días}}',
	'mobile-frontend-last-modified-months' => 'Última modificación hai {{PLURAL:$1|$1 mes|$1 meses}}',
	'mobile-frontend-last-modified-years' => 'Última modificación hai {{PLURAL:$1|$1 ano|$1 anos}}',
	'mobile-frontend-account-create-submit' => 'Crear a conta',
	'mobile-frontend-password-confirm-placeholder' => 'Confirme o contrasinal',
	'mobile-frontend-account-create-email-placeholder' => 'Enderezo de correo electrónico (opcional)',
	'mobile-frontend-account-create-captcha-placeholder' => 'Insira o texto de seguridade',
	'mobile-frontend-overlay-escape' => 'Volver',
	'mobile-frontend-placeholder' => 'Procurar en {{SITENAME}}',
	'mobile-frontend-placeholder-beta' => 'Procurar en {{SITENAME}} (Beta)',
	'mobile-frontend-placeholder-alpha' => 'Procurar en {{SITENAME}} (modo Dragón)',
	'mobile-frontend-search-help' => 'Escriba o termo que queira procurar e os títulos que coincidan aparecerán aquí.',
	'mobile-frontend-dismiss-notification' => 'agochar esta notificación',
	'mobile-frontend-clear-search' => 'Limpar',
	'mobile-frontend-privacy-link-text' => 'Protección de datos',
	'mobile-frontend-about-link-text' => 'Acerca de',
	'mobile-frontend-footer-sitename' => '{{SITENAME}}',
	'mobile-frontend-footer-license-text' => 'Os contidos están dispoñibles baixo a licenza [//gl.m.wikipedia.org/wiki/Wikipedia:Texto_da_Licenza_Creative_Commons_Recoñecemento-CompartirIgual_3.0?useformat=mobile CC BY-SA 3.0]',
	'mobile-frontend-terms-use-text' => '[//wikimediafoundation.org/wiki/Terms_of_Use/gl?useformat=mobile Termos de uso]',
	'mobile-frontend-footer-contact' => 'Contacto',
	'mobile-frontend-search-noresults' => 'Non hai ningún título que coincida coa súa procura. Probe con outras palabras ou prema no botón de procuras do teclado para pescudar dentro das páxinas.',
	'mobile-frontend-main-menu-button-tooltip' => 'Abrir o menú principal',
	'mobile-frontend-main-menu-page-title' => 'Navegación do sitio',
	'mobile-frontend-main-menu-featured' => 'Destacado',
	'mobile-frontend-main-menu-nearby' => 'Preto',
	'mobile-frontend-main-menu-login' => 'Acceder ao sistema',
	'mobile-frontend-main-menu-logout' => 'Saír',
	'mobile-frontend-main-menu-watchlist' => 'Lista de vixilancia',
	'mobile-frontend-main-menu-settings' => 'Configuracións',
	'mobile-frontend-main-menu-upload' => 'Cargas',
	'mobile-frontend-main-menu-settings-heading' => 'Configuracións da versión móbil do sitio',
	'mobile-frontend-settings-site-header' => 'Lingua de {{SITENAME}}',
	'mobile-frontend-settings-site-description' => '{{SITENAME}} está dispoñible en $1 {{PLURAL:$1|lingua|linguas}}. Todas as versións dispoñibles aparecen a continuación',
	'mobile-frontend-main-menu-contact' => 'Contacto',
	'mobile-frontend-main-menu-account-create' => 'Crear unha conta',
	'mobile-frontend-page-menu-contents' => 'contidos',
	'mobile-frontend-page-menu-history' => 'Historial',
	'mobile-frontend-meta-data-issues-header' => 'Problemas',
	'mobile-frontend-meta-data-issues' => 'Esta páxina ten algúns problemas',
	'mobile-frontend-ajax-page-loading' => 'Cargando "$1"',
	'mobile-frontend-page-saving' => 'Gardando "$1"',
	'mobile-frontend-ajax-page-error' => 'Vaites! Houbo un problema. Intente recargar a ventá do navegador.',
	'mobile-frontend-nearby-title' => 'Preto',
	'mobile-frontend-nearby-loading' => 'Cargando os temas próximos á súa localización actual',
	'mobile-frontend-nearby-requirements' => 'Esta páxina necesita JavaScript e un navegador que indique a súa localización.',
	'mobile-frontend-nearby-distance-report' => 'A $1km da súa localización actual',
	'mobile-frontend-nearby-lookup-error' => 'Non puidemos determinar a súa localización. Intentándoo de novo...',
	'mobile-frontend-nearby-noresults' => 'Está no medio de ningures e non puidemos atopar ningún tema. Por que non escribe un?',
	'mobile-frontend-nearby-refresh' => 'Atopamos unha localización máis axeitada para vostede. Prema aquí para recargar a lista de páxinas próximas',
	'mobile-frontend-nearby-error' => 'Houbo un erro inesperado ao intentar atopar páxinas próximas',
	'mobile-frontend-donate-image-login' => 'Debe acceder ao sistema para ollar as súas cargas.',
	'mobile-frontend-photo-upload-generic' => 'Doar unha imaxe',
	'mobile-frontend-donate-image-title' => 'Doar unha imaxe',
	'mobile-frontend-donate-image-summary' => 'As fotografías dan vida ás páxinas de {{SITENAME}}.
Hai moitas páxinas que non teñen imaxes debido a unha enorme falta de fotografías con licenzas libres.
Axude a darlles vida a estas páxinas achegando aquelas imaxes que poidan ser de utilidade para a gran comunidade de editores de {{SITENAME}}.',
	'mobile-frontend-donate-image-heading' => 'As súas achegas recentes',
	'mobile-frontend-donate-image-page-title' => 'Cargar',
	'mobile-frontend-donate-image-anon' => 'Cómpre ter unha [[Special:UserLogin|conta de usuario]] para acceder á páxina de cargas',
	'mobile-frontend-listed-image-no-description' => 'Sen descrición',
	'mobile-frontend-donate-photo-upload-success' => 'Correcto! Pode usar a súa imaxe en {{SITENAME}}!',
	'mobile-frontend-donate-photo-first-upload-success' => 'Correcto! Grazas pola súa primeira contribución!',
	'mobile-frontend-watchlist-add' => '"$1" engadiuse á súa lista de vixilancia',
	'mobile-frontend-watchlist-removed' => '"$1" eliminouse da súa lista de vixilancia',
	'mobile-frontend-watchlist-view' => 'Ver a súa lista de vixilancia',
	'mobile-frontend-watchlist-more' => 'máis',
	'mobile-frontend-watchlist-cta' => 'Acceda ao sistema ou cree unha conta para vixiar esta páxina.',
	'mobile-frontend-watchlist-cta-button-login' => 'Identificarse',
	'mobile-frontend-watchlist-cta-button-signup' => 'Rexístrese',
	'mobile-frontend-watch-login' => 'Debe acceder ao sistema para vixiar páxinas.',
	'mobile-frontend-watchlist-a-z' => 'Todas',
	'mobile-frontend-watchlist-feed' => 'Modificadas',
	'mobile-frontend-watchlist-a-z-empty' => 'Non está vixiando ningunha páxina nestes intres',
	'mobile-frontend-watchlist-a-z-empty-howto-alt' => 'Prema na estrela da parte superior da páxina',
	'mobile-frontend-watchlist-a-z-empty-howto' => 'Vixíe unha páxina que atope interesante premendo na icona en forma de estrela da parte superior da pantalla. Isto permite marcar aquelas páxinas de interese, así como saber cando sufren modificacións.',
	'mobile-frontend-watchlist-feed-empty' => 'Non hai páxinas con cambios recentes',
	'mobile-frontend-watchlist-back-home' => 'Volver ao inicio',
	'mobile-frontend-changeslist-ip' => 'Usuario anónimo',
	'mobile-frontend-changeslist-nocomment' => 'sen resumo de edición',
	'mobile-frontend-watchlist-filter-all' => 'Todas',
	'mobile-frontend-watchlist-filter-articles' => 'Artigos',
	'mobile-frontend-watchlist-filter-talk' => 'Conversa',
	'mobile-frontend-watchlist-filter-other' => 'Outras',
	'mobile-frontend-watchlist-modified' => 'Modificada $1',
	'mobile-frontend-diffview-404-title' => 'Revisión incorrecta',
	'mobile-frontend-diffview-404-desc' => 'O identificador da revisión solicitada non existe',
	'mobile-frontend-diffview-title' => 'Cambios',
	'mobile-frontend-diffview-editcount' => '$1 {{PLURAL:$1|edición|edicións}}',
	'mobile-frontend-diffview-anonymous' => 'Usuario anónimo',
	'mobile-frontend-diffview-bytesadded' => '$1 {{PLURAL:$1|byte engadido|bytes engadidos}}',
	'mobile-frontend-diffview-bytesremoved' => '$1 {{PLURAL:$1|byte eliminado|bytes eliminados}}',
	'mobile-frontend-diffview-explained' => 'Engadíronse (+) e elimináronse (-) as seguintes liñas:',
	'mobile-frontend-table' => 'Táboa $1',
	'mobile-frontend-saving-exit-page' => 'A súa achega está gardándose. Se marcha, as súas contribucións hanse perder. Está seguro de querer saír?',
	'mobile-frontend-photo-upload' => 'Engadir unha imaxe a este artigo',
	'mobile-frontend-photo-article-edit-comment' => 'Engadiuse unha fotografía para o seu uso na páxina',
	'mobile-frontend-photo-article-donate-comment' => 'Imaxe achegada desde un dispositivo móbil',
	'mobile-frontend-photo-upload-comment' => 'Engadiuse unha fotografía á páxina',
	'mobile-frontend-photo-caption-placeholder' => 'Engadir unha descrición (obrigatorio)',
	'mobile-frontend-image-loading' => 'Cargando a imaxe',
	'mobile-frontend-image-uploading-wait' => 'Subindo a imaxe, agarde.',
	'mobile-frontend-image-uploading-long' => 'A imaxe aínda non rematou de cargarse! Grazas pola súa paciencia.',
	'mobile-frontend-image-uploading-cancel' => '<a href="#">Cancele</a> o proceso se leva demasiado tempo.',
	'mobile-frontend-photo-upload-error' => 'Houbo un erro. Inténteo de novo.',
	'mobile-frontend-photo-upload-success-article' => 'Correcto! A súa imaxe está agora nesta páxina.',
	'mobile-frontend-photo-license' => 'Ao premer no botón "Enviar", acepta os nosos [//wikimediafoundation.org/wiki/Terms_of_Use/gl termos de uso] e acepta liberar a súa fotografía baixo a [//creativecommons.org/licenses/by-sa/3.0/deed.gl licenza Creative Commons recoñecemento compartir igual 3.0].',
	'mobile-frontend-photo-submit' => 'Enviar',
	'mobile-frontend-photo-cancel' => 'Cancelar',
	'mobile-frontend-photo-upload-user-count' => '{{PLURAL:$1|1 carga|$1 cargas}}', # Fuzzy
	'mobile-frontend-photo-upload-user-count-over-limit' => '+500 cargas',
	'tag-mobile_edit' => 'Edición desde un dispositivo móbil',
	'tag-mobile_edit-description' => 'Edición feita desde o sitio móbil',
	'mobile-frontend-drawer-cancel' => 'Cancelar',
);

/** Ancient Greek (Ἀρχαία ἑλληνικὴ)
 * @author Crazymadlover
 */
$messages['grc'] = array(
	'mobile-frontend-search-submit' => 'Ἰέναι',
	'mobile-frontend-home-button' => 'Κυρία',
	'mobile-frontend-language' => 'Γλῶττα:',
	'mobile-frontend-username' => 'Ὄνομα χρωμένου:',
	'mobile-frontend-password' => 'Σῆμα:',
);

/** Swiss German (Alemannisch)
 * @author Als-Chlämens
 * @author Als-Holder
 */
$messages['gsw'] = array(
	'mobile-frontend-desc' => 'Optimiert Darstellig fir Mobili Ändgerät',
	'mobile-frontend-search-submit' => 'Gang',
	'mobile-frontend-home-button' => 'Start',
	'mobile-frontend-logged-out' => 'Nit aagmäldet',
	'mobile-frontend-settings-description' => 'Pass dyn Mobilgerät mit dänne Yystellige aa dyni Bedürfniss aa.',
	'mobile-frontend-settings-beta' => 'Beta',
	'mobile-frontend-save-settings' => 'Yystellige spychere',
	'mobile-frontend-random-button' => 'Zuefall',
	'mobile-frontend-back-to-top-of-section' => 'Ei Abschnitt zruckgumpe',
	'mobile-frontend-close-section' => 'De Abschnitt zuemache',
	'mobile-frontend-show-button' => 'Zeige',
	'mobile-frontend-hide-button' => 'Uusblände',
	'mobile-frontend-empty-homepage-text' => 'Die Homepage mueß konfiguriert wäre. <a href="http://meta.wikimedia.org/wiki/Mobile_Projects/Mobile_Gateway#Mobile_homepage">Aeleitige, wie mer di mobil Websyte cha aktiviere</a>', # Fuzzy
	'mobile-frontend-regular-site' => 'Klassischi Aasicht',
	'mobile-frontend-wml-continue' => 'Wyter ...',
	'mobile-frontend-wml-back' => 'Zruck ...',
	'mobile-frontend-view' => 'Mobili Aasicht',
	'mobile-frontend-view-desktop' => 'Arbetsflechi',
	'mobile-frontend-view-mobile' => 'Mobil',
	'mobile-frontend-opt-in-explain' => 'Wänn du bim Beta-Test mitmachsch, chunnsch Zuegriff uf experimentälli Funktione iber, wu aber au Probläm un Fähler chenne verursache.',
	'mobile-frontend-images-status' => 'Bilder',
	'mobile-frontend-disable-images' => 'Bilder in dr mobilen Aasicht deaktiviere',
	'mobile-frontend-enable-images' => 'Bilder in dr mobilen Aasicht aktiviere',
	'mobile-frontend-missing-image' => 'Bild',
	'mobile-frontend-off' => 'UUS',
	'mobile-frontend-on' => 'AA',
	'mobile-frontend-footer-contributors-text' => 'Artikel vo <a href="$1">Lüt wo mitgmacht hen</a> wie dir', # Fuzzy
	'mobile-frontend-featured-article' => 'Artikel vum Tag',
	'mobile-frontend-news-items' => 'In dr Nochrichte',
	'mobile-frontend-leave-feedback-notice' => 'Dyy Ruckmäldig hilft is derby, di mobil Aasicht wyter z verbessere. Si wird effetlig uf dr Syte &quot;$1&quot; aazeigt. Doderby wäre Dyy Benutzername, d Version vum Browser, wu Du brucht hesch, un s vu Dir brucht Betribssyschtem aagee. Bitte wehl e informativen un uussagechreftig Beträff, wie z. B. „Probläm bi dr Aazeig vu Tabälle“. Dyy Ruckmädig unterlyt doderby unsere Nutzigsbedingige.',
	'mobile-frontend-leave-feedback-warning' => 'Wänn nit demit yyverstande bisch, dass die Informatione öffentlich gmacht werde, no due bitte kei persönlichi Informatione in dyne Kommentar schrybe.',
	'mobile-frontend-leave-feedback-subject' => 'Beträff:',
	'mobile-frontend-leave-feedback-message' => 'Nochricht:',
	'mobile-frontend-leave-feedback-submit' => 'Ruckmäldig ibertrage',
	'mobile-frontend-leave-feedback-link-text' => 'Ruckmäldig zue dr mobilen Aasicht',
	'mobile-frontend-leave-feedback' => 'Ruckmäldig gee',
	'mobile-frontend-leave-feedback-title' => 'Gib is bitte ne Ruckmäldig zue Dyne Erfahrige mit dr mobilen Aasicht',
	'mobile-frontend-leave-feedback-technical-problem-section-header' => 'Technischs Problem',
	'mobile-frontend-leave-feedback-general-section-header' => 'Allgmein',
	'mobile-frontend-leave-feedback-article-feedback-section-header' => 'Ruggmäldig zum Artikel',
	'mobile-frontend-leave-feedback-email-body' => 'Bitte bschryb s Problem, wu Du bi {{SITENAME}} entdeckt hesch, oberhalb vu däre Lischt. Bitte dänk dra, dass mir nit uf jedi Nochricht chenne Antwort gee, wu mit iberchemme.',
	'mobile-frontend-leave-feedback-technical-link-text' => 'Technischs Problem',
	'mobile-frontend-leave-feedback-general-link-text' => 'Allgemeini Ruggmäldig',
	'mobile-frontend-leave-feedback-article-personal-link-text' => 'Zue mir, enere Person oder eme Unternämme, wonni vertritt.',
	'mobile-frontend-leave-feedback-article-factual-link-text' => 'Zu eme sachliche Fääler',
	'mobile-frontend-leave-feedback-article-other-link-text' => 'Zue eme andere Problem',
	'mobile-frontend-leave-feedback-form-subject-placeholder' => 'Beträff vo de Noochricht',
	'mobile-frontend-leave-feedback-form-message-placeholder' => 'Gib doo dyni Noochricht yy',
	'mobile-frontend-leave-feedback-page-title' => 'Gib is bitte ne Ruckmäldig zue Dyne Erfahrige mit dr mobilen Aasicht',
	'mobile-frontend-leave-feedback-special-title' => 'Kontaktier üs',
	'mobile-frontend-feedback-no-subject' => '(kei Beträff)',
	'mobile-frontend-feedback-no-subject-field' => 'Bitte gib en Betreff yy',
	'mobile-frontend-feedback-no-message' => 'Bitte gib Dyy Nochricht an däre Stell yy',
	'mobile-frontend-feedback-edit-summary' => '$1 - automatisch gspychereti [[Special:MobileFeedback|Ruckmäldig]]',
	'mobile-frontend-leave-feedback-thanks' => 'Dankschen vilmol fir Dyy Ruckmäldig!',
	'mobile-frontend-leave-feedback-post-error' => "S het bim Verarbeite vo dynrer Noochricht en Fääler gee. Bitte probier's spööter no emool.",
	'mobile-frontend-language' => 'Sproch:',
	'mobile-frontend-language-header' => 'De Artikel isch uff {{PLURAL:$1|einere Sprooch|$1 Sprooche}} verfiegbar', # Fuzzy
	'mobile-frontend-language-footer' => 'Hiiweis: Dää Artikel isch villicht nit in Dyre Sproch gschribe. Du chasch aaluege, weli Sproche {{SITENAME}} unterstitzt, indäm Du do klicksch.', # Fuzzy
	'mobile-frontend-language-site-choose' => 'Sproch sueche',
	'mobile-frontend-username' => 'Benutzername:',
	'mobile-frontend-password' => 'Passwort:',
	'mobile-frontend-login' => 'Aamälde',
	'mobile-frontend-placeholder' => '{{SITENAME}} dursueche',
	'mobile-frontend-search-help' => 'Gib obe de Suechbegriff yy. Artikelname, wo passe, werde deno doo aazeigt.', # Fuzzy
	'mobile-frontend-dismiss-notification' => 'die Benochrichtigung zuemache',
	'mobile-frontend-clear-search' => 'Lääre',
	'mobile-frontend-privacy-link-text' => 'Dateschutz',
	'mobile-frontend-about-link-text' => 'Iber',
	'mobile-frontend-footer-sitename' => '{{SITENAME}}',
	'mobile-frontend-footer-contact' => 'Kontakt',
	'mobile-frontend-search-noresults' => 'Es git kei Artikeltitel, wo dynrer Suechyygab entspricht. Du chasch dyni Suech aapasse, oder druff uff d Suechschaltflächi uff dynrer Tastatur, zume d Suech uff de ganze Inhalt vo de Artikel usszwyte.', # Fuzzy
	'mobile-frontend-main-menu-featured' => 'Bsundersch glunge',
	'mobile-frontend-main-menu-nearby' => 'In de Nööchi',
	'mobile-frontend-main-menu-settings' => 'Yystellige',
	'mobile-frontend-main-menu-settings-heading' => 'Mobilyystellige',
	'mobile-frontend-settings-site-header' => '{{SITENAME}}-Sproche',
	'mobile-frontend-settings-site-description' => '{{SITENAME}} stoht in {{PLURAL:$1|ere Sproch|$1 Sproche}} z Verfiegig. Alli verfiegbare Sprochversione sin unten ufgfiert.',
	'mobile-frontend-main-menu-contact' => 'Kontakt',
	'mobile-frontend-page-menu-contents' => 'Inhalt',
	'mobile-frontend-page-menu-history' => 'Versione',
	'mobile-frontend-meta-data-issues-header' => 'Dää Artikel verbessere', # Fuzzy
	'mobile-frontend-meta-data-issues' => 'Mit däm Artikel git s Probläm', # Fuzzy
);

/** Gujarati (ગુજરાતી)
 * @author Dsvyas
 * @author KartikMistry
 * @author Sushant savla
 * @author Tekina
 */
$messages['gu'] = array(
	'mobile-frontend-desc' => 'મોબાઈલ દેખાવ',
	'mobile-frontend-search-submit' => 'જાઓ',
	'mobile-frontend-home-button' => 'ઘર',
	'mobile-frontend-logged-out' => 'પ્રવેશ કરેલ નથી',
	'mobile-frontend-settings-beta' => 'બીટા',
	'mobile-frontend-save-settings' => 'ગોઠવણીઓ સંગ્રહો',
	'mobile-frontend-random-button' => 'ગમે તે',
	'mobile-frontend-back-to-top-of-section' => 'વિભાગ પર પાછાં જાઓ',
	'mobile-frontend-close-section' => 'આ સત્ર બંધ કરો',
	'mobile-frontend-show-button' => 'બતાવો',
	'mobile-frontend-hide-button' => 'છુપાવો',
	'mobile-frontend-regular-site' => 'ડેસ્કટોપ દેખાવ',
	'mobile-frontend-wml-continue' => 'ચાલુ રાખો...',
	'mobile-frontend-wml-back' => 'પાછાં જાઓ...',
	'mobile-frontend-view' => 'મોબાઈલ દેખાવ',
	'mobile-frontend-view-desktop' => 'ડેસ્કટોપ',
	'mobile-frontend-view-mobile' => 'મોબાઇલ',
	'mobile-frontend-opt-in-explain' => 'બીટામાં જોડાઈને તમે પ્રાયોગિક ધોરણે કાર્યાન્વીત થયેલી સેવા પામી શકશો. આમાં ત્રુટી, ક્ષતિ અનુભવી શકો છો.',
	'mobile-frontend-images-status' => 'ચિત્રો',
	'mobile-frontend-disable-images' => 'મોબાઈલ સાઈટ પર ચિત્રો નિષ્ક્રિય કરો',
	'mobile-frontend-enable-images' => 'મોબાઈલ સાઈટ પર ચિત્રો સક્રિય કરો',
	'mobile-frontend-off' => 'બંધ',
	'mobile-frontend-on' => 'ચાલુ',
	'mobile-frontend-footer-contributors-text' => 'તમારા જેવા <a href="$1">ફાળો આપનારા</a> દ્વારા લેખ', # Fuzzy
	'mobile-frontend-featured-article' => 'આજનો વિશેષ લેખ',
	'mobile-frontend-news-items' => 'સમાચારમાં',
	'mobile-frontend-leave-feedback-notice' => 'તમારો સુઝાવ અમને મોબાઈલ સાઈટના અનુભવને સુધારવામાં મદદ કરશે. આને (તમારા સભ્યનામ, બ્રાઉઝર આવૃત્તિ, અને ઓપરેટીંગ સીસ્ટમ સાથે)  સાર્વજનીક રીતે &quot;$1&quot પાના પર પ્રસિદ્ધ કરવામાં આવશે. કૃપા કરી માહિતીપૂર્વકને હરોળ પસંદ કરશો. દા.ત. "Formatting issues with wide tables".  તમરો સુઝાવ અમારા નિતી નિયમોને આધીન રહેશે.',
	'mobile-frontend-leave-feedback-subject' => 'વિષય:',
	'mobile-frontend-leave-feedback-message' => 'સંદેશ:',
	'mobile-frontend-leave-feedback-submit' => 'પ્રતિભાવ આપો',
	'mobile-frontend-leave-feedback-link-text' => 'મોબાઈલઅગ્રદેખાવ એક્સટેન્શન પ્રતિભાવ',
	'mobile-frontend-leave-feedback' => 'મોબાઈલ સાઈટ પ્રતિભાવ',
	'mobile-frontend-leave-feedback-title' => 'તમારા મોબાઈલ સાઈટના અનુભવ વિશે પ્રતિભાવ આપો',
	'mobile-frontend-leave-feedback-technical-problem-section-header' => 'ટેકનિકલ મુશ્કેલી',
	'mobile-frontend-leave-feedback-general-section-header' => 'સામાન્ય',
	'mobile-frontend-leave-feedback-article-feedback-section-header' => 'લેખ પ્રતિભાવ',
	'mobile-frontend-leave-feedback-email-body' => 'મહેરબાની કરી આ લીટીની ઉપર તમારું ઇ-મેલ લખો.', # Fuzzy
	'mobile-frontend-leave-feedback-technical-link-text' => 'ટેકનિકલ મુશ્કેલી',
	'mobile-frontend-leave-feedback-general-link-text' => 'સામાન્ય પ્રતિભાવ',
	'mobile-frontend-leave-feedback-article-factual-link-text' => 'સત્યતા ક્ષતિ વિષે',
	'mobile-frontend-leave-feedback-article-other-link-text' => 'બીજી મુશ્કેલી વિષે',
	'mobile-frontend-leave-feedback-form-subject-placeholder' => 'સંદેશ વિષય',
	'mobile-frontend-leave-feedback-form-message-placeholder' => 'તમારી ટીપ્પણી અહીં લખો',
	'mobile-frontend-leave-feedback-page-title' => 'તમારા મોબાઈલ સાઈટના અનુભવ વિશે પ્રતિભાવ આપો',
	'mobile-frontend-leave-feedback-special-title' => 'અમારો સંપર્ક કરો',
	'mobile-frontend-feedback-no-subject' => '(કોઇ વિષય નહી)',
	'mobile-frontend-feedback-no-subject-field' => 'મહેરબાની કરી વિષય દાખલ કરો',
	'mobile-frontend-feedback-no-message' => 'મહેરબાની કરી સંદેશ અહીં લખો',
	'mobile-frontend-leave-feedback-thanks' => 'તમારા પ્રતિભાવ માટે, આભાર!',
	'mobile-frontend-language' => 'ભાષા:',
	'mobile-frontend-language-footer' => '{{SITENAME}} બીજી ભાષાઓમાં પ્રાપ્ત છે.', # Fuzzy
	'mobile-frontend-language-site-choose' => 'શોધ ભાષા',
	'mobile-frontend-username' => 'સભ્યનામ:',
	'mobile-frontend-password' => 'પાસવર્ડ:',
	'mobile-frontend-login' => 'પ્રવેશ કરો',
	'mobile-frontend-placeholder' => '{{SITENAME}} શોધો',
	'mobile-frontend-dismiss-notification' => 'આ સૂચનાનું વિસર્જન કરો',
	'mobile-frontend-clear-search' => 'સાફ કરો',
	'mobile-frontend-privacy-link-text' => 'ખાનગીપણું',
	'mobile-frontend-about-link-text' => 'વિષે',
	'mobile-frontend-footer-sitename' => '{{SITENAME}}',
	'mobile-frontend-footer-contact' => 'સંપર્ક',
	'mobile-frontend-main-menu-featured' => 'રુપક',
	'mobile-frontend-main-menu-nearby' => 'નજીકમાં',
	'mobile-frontend-main-menu-settings' => 'ગોઠવણીઓ',
	'mobile-frontend-main-menu-settings-heading' => 'મોબાઇલ સાઇટ ગોઠવણીઓ',
	'mobile-frontend-settings-site-header' => '{{SITENAME}} ભાષાઓ',
	'mobile-frontend-main-menu-contact' => 'સંપર્ક',
	'mobile-frontend-page-menu-contents' => 'વિષયસૂચિ',
	'mobile-frontend-page-menu-history' => 'ઇતિહાસ',
);

/** Manx (Gaelg)
 */
$messages['gv'] = array(
	'mobile-frontend-search-submit' => 'Gow',
	'mobile-frontend-home-button' => 'Balley',
	'mobile-frontend-random-button' => 'Gyn tort',
	'mobile-frontend-back-to-top-of-section' => 'Goll Erash Un Rheynn',
	'mobile-frontend-show-button' => 'Taishbyney',
	'mobile-frontend-hide-button' => 'Follaghey',
	'mobile-frontend-regular-site' => 'Jeeagh er y duillag shoh er {{SITENAME}} chadjin', # Fuzzy
	'mobile-frontend-featured-article' => 'Yn Art Reiht Jiu',
);

/** Hausa (Hausa)
 */
$messages['ha'] = array(
	'mobile-frontend-search-submit' => 'Mu je',
	'mobile-frontend-home-button' => 'Marhabin',
	'mobile-frontend-random-button' => 'Randam',
	'mobile-frontend-back-to-top-of-section' => 'A tsallaka baya sashe guda',
	'mobile-frontend-show-button' => 'Nuna',
	'mobile-frontend-hide-button' => 'Ɓoye',
	'mobile-frontend-regular-site' => 'A duba wannan shafi a kan {{SITENAME}} na kullum', # Fuzzy
	'mobile-frontend-featured-article' => 'Zaɓaɓɓar maƙala ta yau',
);

/** Hawaiian (Hawai`i)
 */
$messages['haw'] = array(
	'mobile-frontend-search-submit' => 'Hele',
	'mobile-frontend-home-button' => 'Home',
	'mobile-frontend-random-button' => 'ʻOhi Kaulele',
	'mobile-frontend-back-to-top-of-section' => 'Hoʻi i ka Māhele ma mua',
	'mobile-frontend-show-button' => 'Hōʻike',
	'mobile-frontend-hide-button' => 'Hūnā',
	'mobile-frontend-regular-site' => 'Nānā kēia ʻaoʻao ma Wikipikia maʻamau', # Fuzzy
	'mobile-frontend-featured-article' => 'Ka ʻAtikala Nui o Kēia Lā',
);

/** Hebrew (עברית)
 * @author Amire80
 * @author Deror avi
 * @author Inkbug
 * @author Ypnypn
 */
$messages['he'] = array(
	'mobile-frontend-desc' => 'תצוגה עבור מכשירים ניידים',
	'mobile-frontend-search-submit' => 'חיפוש',
	'mobile-frontend-home-button' => 'דף הבית',
	'mobile-frontend-logged-out' => 'לא בחשבון',
	'mobile-frontend-logged-in-homepage-notification' => 'ברוך בואך, $1!',
	'mobile-frontend-logged-in-toast-notification' => 'נכנסת לחשבון $1.',
	'mobile-frontend-sign-up-heading' => 'רישום',
	'mobile-frontend-sign-in-heading' => 'כניסה לחשבון',
	'mobile-frontend-sign-in-why' => 'אם יש לך חשבון ב{{GRAMMAR:תחילית|{{SITENAME}}}}, אפשר להיכנס אליו להלן.',
	'mobile-frontend-sign-in-error-heading' => 'אוי',
	'mobile-frontend-settings-description' => 'התאמה אישית של סביבת עבודה במכשיר הנייד בהגדרות האתר למכשירים ניידים.',
	'mobile-frontend-settings-beta' => 'להפעיל ניסויים',
	'mobile-frontend-settings-alpha' => 'מצב שדה מוקשים',
	'mobile-frontend-settings-alpha-description' => 'כניסה לאזור מסוכן ולא מוכּר. יש פה אפשרויות עוד יותר ניסיוניות, אבל גם יותר סכנה לחוות באגים.',
	'mobile-frontend-save-settings' => 'שמירת הגדרות',
	'mobile-frontend-random-button' => 'דף אקראי',
	'mobile-frontend-ajax-random-heading' => 'איתור ידע...',
	'mobile-frontend-ajax-random-quote' => 'צמיחה שכלית אמורה להתחיל בלידה ולהסתיים רק במוות',
	'mobile-frontend-ajax-random-quote-author' => 'אלברט איינשטיין',
	'mobile-frontend-ajax-random-question' => 'לקרוא את הדף הזה?',
	'mobile-frontend-ajax-random-yes' => 'כן',
	'mobile-frontend-ajax-random-retry' => 'לנסות שוב',
	'mobile-frontend-ajax-random-suggestions' => 'הצעות אחרות:',
	'mobile-frontend-back-to-top-of-section' => 'חזרה לקטע הקודם',
	'mobile-frontend-close-section' => 'לסגור את החלק הזה',
	'mobile-frontend-show-button' => 'הצגה',
	'mobile-frontend-hide-button' => 'הסתרה',
	'mobile-frontend-empty-homepage-text' => 'צריך להגדיר את דף הבית הזה. [//meta.wikimedia.org/wiki/Mobile_Projects/Mobile_Gateway#Mobile_homepage הוראות איך להתאים את האתר הזה למכשירים ניידים]',
	'mobile-frontend-regular-site' => 'תצוגה למחשבים',
	'mobile-frontend-wml-continue' => 'המשך...',
	'mobile-frontend-wml-back' => 'חזרה...',
	'mobile-frontend-view' => 'תצוגה למכשירים ניידים',
	'mobile-frontend-view-desktop' => 'תצוגת מחשבים',
	'mobile-frontend-view-mobile' => 'תצוגת מכשירים ניידים',
	'mobile-frontend-opt-in-explain' => 'על־ידי הצטרפות לבטא, תקבלו גישה לאפשרויות ניסיוניות, אבל תסתכנו בהיתקלות בבאגים ובעיות.',
	'mobile-frontend-images-status' => 'להציג תמונות',
	'mobile-frontend-disable-images' => 'לכבות תמונות באתר למכשירים ניידים',
	'mobile-frontend-enable-images' => 'להפעיל תצוגת תמונות באתר למכשירים ניידים',
	'mobile-frontend-missing-image' => 'תמונה',
	'mobile-frontend-off' => 'לא',
	'mobile-frontend-on' => 'כן',
	'mobile-frontend-footer-contributors-text' => 'דף שנכתב על־ידי [$1 תורמים] כמוך',
	'mobile-frontend-featured-article' => 'הערך המומלץ של היום',
	'mobile-frontend-news-items' => 'בחדשות',
	'mobile-frontend-leave-feedback-notice' => 'המשוב שלך עוזר לנו לספר את חוויית השימוש באתר למכשירים ניידים. הוא יישלח באופן פומבי (יחד עם שם המשתמש שלך, גרסה הדפדפן ומערכת ההפעלה), לדף "$1". נא לרשום משהו ברור בשורת הנושא, למשל "יש בעיית עיצוב עם טבלאות". המשוב שלכם כפוף לתנאי השימוש.',
	'mobile-frontend-leave-feedback-warning' => 'אלא אם כן ברצונך לפרסם את המידע אישי שלך לציבור, נא לא לכתוב מידע אישי בהערות שלך.',
	'mobile-frontend-leave-feedback-subject' => 'נושא:',
	'mobile-frontend-leave-feedback-message' => 'הודעה:',
	'mobile-frontend-leave-feedback-submit' => 'שליחת משוב',
	'mobile-frontend-leave-feedback-link-text' => 'שליחת משוב על הממשק למכשירים ניידים',
	'mobile-frontend-leave-feedback' => 'שליחת משוב',
	'mobile-frontend-leave-feedback-title' => 'משוב על האתר למכשירים ניידים',
	'mobile-frontend-leave-feedback-technical-problem-section-header' => 'בעיה טכנית',
	'mobile-frontend-leave-feedback-general-section-header' => 'כללי',
	'mobile-frontend-leave-feedback-article-feedback-section-header' => 'המשוב על ערך',
	'mobile-frontend-leave-feedback-email-body' => 'נא לתאר את הבעיה שיש לך עם {{SITENAME}} מעל הקו הזה. אנא שימו לב כי איננו יכולים לענות אישית לכל הודעה שאנחנו מקבלים.',
	'mobile-frontend-leave-feedback-technical-link-text' => 'בעיה טכנית',
	'mobile-frontend-leave-feedback-general-link-text' => 'משוב כללי',
	'mobile-frontend-leave-feedback-article-personal-link-text' => 'עליי או על אדם או חברה שאני מייצג',
	'mobile-frontend-leave-feedback-article-factual-link-text' => 'על טעות עובדתית',
	'mobile-frontend-leave-feedback-article-other-link-text' => 'על בעיה אחרת',
	'mobile-frontend-leave-feedback-form-subject-placeholder' => 'נושא ההודעה',
	'mobile-frontend-leave-feedback-form-message-placeholder' => 'הקלדת ההערה שלך כאן',
	'mobile-frontend-leave-feedback-page-title' => 'משוב על האתר למכשירים ניידים',
	'mobile-frontend-leave-feedback-special-title' => 'יצירת קשר אתנו',
	'mobile-frontend-feedback-no-subject' => '(ללא נושא)',
	'mobile-frontend-feedback-no-subject-field' => 'נא להזין נושא',
	'mobile-frontend-feedback-no-message' => 'נא להזין הודעה',
	'mobile-frontend-feedback-edit-summary' => '$1 – נשלח באופן אוטומטי באמצעות [[Special:MobileFeedback|כלי המשוב למכשירים ניידים]]',
	'mobile-frontend-leave-feedback-thanks' => 'תודה על המשוב!',
	'mobile-frontend-leave-feedback-post-error' => 'אירעה שגיאה בעיבוד ההודעה שלך. נא לנסות שוב מאוחר יותר.',
	'mobile-frontend-language' => 'שפה:',
	'mobile-frontend-language-article-heading' => 'לקרוא בשפה אחרת',
	'mobile-frontend-language-header' => 'הדף הזה זמין {{PLURAL:$1|בשפה אחת|ב־$1 שפות}}',
	'mobile-frontend-language-variant-header' => 'בחירת ההגוון של {{#language:{{CONTENTLANG}}}}',
	'mobile-frontend-language-footer' => 'לתשומת לבך: ייתכן שהדף הזה אינו כתוב בשפה המועדפת שלך. ניתן לראות באילו עוד שפות תומך אתר {{SITENAME}} על־ידי לחיצה כאן.',
	'mobile-frontend-language-site-choose' => 'חיפוש שפה',
	'mobile-frontend-username' => 'שם משתמש:',
	'mobile-frontend-password' => 'ססמה:',
	'mobile-frontend-username-placeholder' => 'שם המשתמש',
	'mobile-frontend-password-placeholder' => 'סיסמה',
	'mobile-frontend-login' => 'כניסה',
	'mobile-frontend-last-modified-date' => 'השינוי האחרון נעשה בֹ־$1 ב־$2',
	'mobile-frontend-last-modified-seconds' => 'עודכן לאחרונה לפני {{PLURAL:$1|שנייה אחת|$1 שניות}}',
	'mobile-frontend-last-modified-minutes' => 'עודכן לאחרונה לפני {{PLURAL:$1|דקה אחת|$1 דקות}}',
	'mobile-frontend-last-modified-hours' => 'עודכן לאחרונה לפני {{PLURAL:$1|שעה אחת|שעתיים|$1 שעות}}',
	'mobile-frontend-last-modified-days' => 'עודכן לאחרונה לפני {{PLURAL:$1|יום אחד|יומיים|$1 ימים}}',
	'mobile-frontend-last-modified-months' => 'עודכן לאחרונה לפני {{PLURAL:$1|חודש אחד|חודשיים|$1 חודשים}}',
	'mobile-frontend-last-modified-years' => 'עודכן לאחרונה לפני {{PLURAL:$1|שנה אחת|שנתיים|$1 שנים}}',
	'mobile-frontend-account-create-submit' => 'רישום',
	'mobile-frontend-password-confirm-placeholder' => 'אימות ססמה',
	'mobile-frontend-account-create-email-placeholder' => 'כתובת דוא"ל (לא חובה)',
	'mobile-frontend-account-create-captcha-placeholder' => 'נא להזין טקסט ביטחון',
	'mobile-frontend-overlay-escape' => 'לחזור',
	'mobile-frontend-placeholder' => 'חיפוש באתר {{SITENAME}}...',
	'mobile-frontend-placeholder-beta' => 'חיפוש באתר {{SITENAME}} (בטא)',
	'mobile-frontend-placeholder-alpha' => 'חיפוש באתר {{SITENAME}} (מצב ניסיוני)',
	'mobile-frontend-search-help' => 'נא להקליד את מילות החיפוש למעלה. כותרות דפים תואמים יופיעו כאן.',
	'mobile-frontend-dismiss-notification' => 'הסתרת ההודעה הזאת',
	'mobile-frontend-clear-search' => 'ניקוי',
	'mobile-frontend-privacy-link-text' => 'פרטיות',
	'mobile-frontend-about-link-text' => 'אודות',
	'mobile-frontend-footer-sitename' => '{{SITENAME}}',
	'mobile-frontend-footer-contact' => 'יצירת קשר',
	'mobile-frontend-search-noresults' => 'שום כותרת של דף לא תאמה לחיפוש שלך. יש להחליף את החיפוש או ללחוץ על כתפור החיפוש במקלדת כדי לחפש בדפים.',
	'mobile-frontend-main-menu-button-tooltip' => 'פתיחת התפריט הראשי',
	'mobile-frontend-main-menu-page-title' => 'ניווט באתר',
	'mobile-frontend-main-menu-featured' => 'מומלץ',
	'mobile-frontend-main-menu-nearby' => 'בסביבה',
	'mobile-frontend-main-menu-login' => 'כניסה לחשבון',
	'mobile-frontend-main-menu-logout' => 'יציאה מהחשבון',
	'mobile-frontend-main-menu-watchlist' => 'רשימת מעקב',
	'mobile-frontend-main-menu-settings' => 'הגדרות',
	'mobile-frontend-main-menu-upload' => 'העלאה',
	'mobile-frontend-main-menu-settings-heading' => 'הגדרות האתר למכשירים ניידים',
	'mobile-frontend-settings-site-header' => '{{SITENAME}} – שפות',
	'mobile-frontend-settings-site-description' => 'אתר {{SITENAME}} זמין {{PLURAL:$1|רק בשפה אחת|ב־$1 שפות}}. כל השפות הזמינות רשומות להלן',
	'mobile-frontend-main-menu-contact' => 'יצירת קשר',
	'mobile-frontend-main-menu-account-create' => 'יצירת חשבון',
	'mobile-frontend-page-menu-contents' => 'תוכן עניינים',
	'mobile-frontend-page-menu-history' => 'היסטוריה',
	'mobile-frontend-meta-data-issues-header' => 'בעיות',
	'mobile-frontend-meta-data-issues' => 'בדף הזה יש בעיות',
	'mobile-frontend-ajax-page-loading' => 'טעינת הדף $1',
	'mobile-frontend-page-saving' => 'שמירת $1',
	'mobile-frontend-ajax-page-error' => 'אוי! משהו השתבש כאן. נא לנסות לרענן את חלון הדפדפן שלך.',
	'mobile-frontend-nearby-title' => 'בסביבה',
	'mobile-frontend-nearby-lookup-error' => 'אין אפשרות למצוא אותך. מנסה שוב...',
	'mobile-frontend-photo-upload-generic' => 'תרומת תמונה',
	'mobile-frontend-donate-image-title' => 'תרומת תמונה',
	'mobile-frontend-donate-image-summary' => 'תמונות מחיות את {{SITENAME}}. יש הרבה דפים שאין בהם תמונות בגלל מחסור בתמונות חופשיות. עזרו להחיות את הדפים האלה באמצעות תרומה של תמונות שאתם מוכנים לתרום ושיכולות להיות שימושיות לקהילת {{SITENAME}}.',
	'mobile-frontend-donate-image-heading' => 'התרומות האחרונות שלך',
	'mobile-frontend-donate-image-page-title' => 'העלאה',
	'mobile-frontend-watchlist-add' => 'הדף $1 נוסף לרשימת המעקב שלך',
	'mobile-frontend-watchlist-removed' => 'הדף $1 הוסר מרשימת המעקב שלך',
	'mobile-frontend-watchlist-view' => 'הצגת רשימת המעקב שלך',
	'mobile-frontend-watchlist-more' => 'עוד',
	'mobile-frontend-watchlist-cta' => 'נא להיכנס או להירשם כדי לעקוב אחרי הדף הזה.',
	'mobile-frontend-watchlist-cta-button-login' => 'כניסה',
	'mobile-frontend-watchlist-cta-button-signup' => 'רישום',
	'mobile-frontend-watchlist-a-z' => 'הכול',
	'mobile-frontend-watchlist-feed' => 'דפים ששונו',
	'mobile-frontend-watchlist-a-z-empty' => 'אין לך דפים במעקב עכשיו',
	'mobile-frontend-watchlist-feed-empty' => 'אין דפים ששונו לאחרונה',
	'mobile-frontend-changeslist-ip' => 'משתמש אלמוני',
	'mobile-frontend-changeslist-nocomment' => 'אין תקציר עריכה',
	'mobile-frontend-watchlist-filter-all' => 'הכול',
	'mobile-frontend-watchlist-filter-articles' => 'ערכים',
	'mobile-frontend-watchlist-filter-talk' => 'שיחה',
	'mobile-frontend-watchlist-filter-other' => 'אחר',
	'mobile-frontend-diffview-title' => 'שינויים',
	'mobile-frontend-diffview-editcount' => '{{PLURAL:$1|עריכה אחד|$1 עריכות}}',
	'mobile-frontend-diffview-anonymous' => 'משתמש אלמוני',
	'mobile-frontend-diffview-bytesadded' => '{{PLURAL:$1|נוסף בית אחד|נוספו $1 בתים}}',
	'mobile-frontend-diffview-bytesremoved' => '{{PLURAL:$1|הוסר בית אחד|הוסרו $1 בתים}}',
	'mobile-frontend-diffview-explained' => 'השורות הבאות נוספו (+) והוסרו (-):',
	'mobile-frontend-table' => 'טבלה $1',
	'mobile-frontend-saving-exit-page' => 'תרומתך עדיין נשמרת. אם היישום ייסגר עכשיו, תרומתך תלך לאיבוד. באם ברצונך באמת לצאת?',
	'mobile-frontend-photo-upload' => 'להוסיף את התמונה הראשונה לדף הזה', # Fuzzy
	'mobile-frontend-photo-article-edit-comment' => 'נוספה תמונה לשימוש בדף הזה',
	'mobile-frontend-photo-upload-comment' => 'נוספה תמונה לדף',
	'mobile-frontend-photo-caption-placeholder' => 'הוספת כיתוב לתמונה הזאת', # Fuzzy
	'mobile-frontend-image-loading' => 'טעינת תמונה',
	'mobile-frontend-image-uploading-wait' => 'מתבצעת העלאת תמונה', # Fuzzy
	'mobile-frontend-photo-upload-error' => 'אירעה שגיאה בעת העלאת התמונה. נא לנסות תמונה אחרת.', # Fuzzy
	'mobile-frontend-photo-license' => 'הערה: כל התמונות שמוּעלות ממך מתפרסמות לפי תנאי [//en.wikipedia.org/wiki/Wikipedia:Text_of_Creative_Commons_Attribution-ShareAlike_3.0_Unported_License רישיון CC by SA 3.0]', # Fuzzy
	'mobile-frontend-photo-cancel' => 'בטל',
	'tag-mobile_edit' => 'עריכה ממכשיר נייד',
	'tag-mobile_edit-description' => 'העריכה נעשתה מהאתר למכשירים ניידים',
	'mobile-frontend-drawer-cancel' => 'ביטול',
);

/** Hindi (हिन्दी)
 * @author Ankitgadgil
 * @author Ansumang
 * @author Faisalaziz4ever
 * @author Karthi.dr
 * @author Siddhartha Ghai
 */
$messages['hi'] = array(
	'mobile-frontend-desc' => 'मोबाइल फ़्रंटएंड',
	'mobile-frontend-search-submit' => 'जाएँ',
	'mobile-frontend-home-button' => 'गृह',
	'mobile-frontend-logged-out' => 'लॉग इन नहीं किया है',
	'mobile-frontend-sign-in-heading' => 'साइन इन करें',
	'mobile-frontend-sign-in-why' => 'अगर आप के पास {{SITENAME}} खाता है तो नीचे साइन इन कर सकते हैं।',
	'mobile-frontend-sign-in-error-heading' => 'त्रुटि',
	'mobile-frontend-settings-description' => 'इन मोबाइल विशिष्ट साइट सेटिंग्स के साथ अपने मोबाइल उपकरण पर अपने अनुभव को अनुकूलित करें।',
	'mobile-frontend-settings-beta' => 'बीटा',
	'mobile-frontend-save-settings' => 'सेटिंग्स सहेजें',
	'mobile-frontend-random-button' => 'बेतरतीब',
	'mobile-frontend-ajax-random-heading' => 'ज्ञान अन्वेषित किया जा रहा है',
	'mobile-frontend-ajax-random-quote' => 'बोद्धिक विकास जन्म से प्रारंभ और केवल मृत्युपरांत ही रुकना चाहिए',
	'mobile-frontend-ajax-random-question' => 'यह पृष्ठ पढ़ें?',
	'mobile-frontend-ajax-random-yes' => 'हाँ',
	'mobile-frontend-ajax-random-retry' => 'पुनः प्रयास करें',
	'mobile-frontend-ajax-random-suggestions' => 'अन्य सुझाव:',
	'mobile-frontend-back-to-top-of-section' => 'पिछला अनुभाग',
	'mobile-frontend-close-section' => 'इस भाग को बंद करें',
	'mobile-frontend-show-button' => 'दिखाएँ',
	'mobile-frontend-hide-button' => 'छुपाएँ',
	'mobile-frontend-regular-site' => 'डेस्कटॉप दृश्य',
	'mobile-frontend-wml-continue' => 'जारी रखें ...',
	'mobile-frontend-wml-back' => 'वापस ...',
	'mobile-frontend-view' => 'मोबाइल दृश्य',
	'mobile-frontend-view-mobile' => 'मोबाइल',
	'mobile-frontend-opt-in-explain' => 'बीटा में शामिल होने से आपको प्रयोगात्मक विशेषताएँ दिखाई जाएँगी, तथा प्रोग्राम में त्रुटियाँ और समस्याएँ आने का खतरा होगा।',
	'mobile-frontend-images-status' => ' चित्र',
	'mobile-frontend-disable-images' => 'मोबाइल साइट पर छवियों को अक्षम करें',
	'mobile-frontend-enable-images' => 'मोबाइल साइट पर छवियों को सक्षम करें',
	'mobile-frontend-missing-image' => 'छवि',
	'mobile-frontend-featured-article' => 'आज का निर्वाचित लेख',
	'mobile-frontend-news-items' => 'समाचार में',
	'mobile-frontend-leave-feedback-subject' => 'विषय', # Fuzzy
	'mobile-frontend-leave-feedback-message' => 'संदेश', # Fuzzy
	'mobile-frontend-leave-feedback-submit' => 'प्रतिक्रिया भेजें',
	'mobile-frontend-leave-feedback-link-text' => 'मोबाइल फ़्रंटएंड एक्स्टेंशन प्रतिक्रिया',
	'mobile-frontend-leave-feedback' => 'मोबाइल साइट पे सुझाव',
	'mobile-frontend-leave-feedback-title' => 'अपने मोबाइल साइट के अनुभव पर प्रतिक्रिया दें',
	'mobile-frontend-leave-feedback-general-section-header' => 'सामान्य',
	'mobile-frontend-leave-feedback-page-title' => 'अपने मोबाइल साइट के अनुभव पर प्रतिक्रिया दें',
	'mobile-frontend-leave-feedback-thanks' => 'प्रतिक्रिया के लिए धन्यवाद!',
	'mobile-frontend-language' => 'भाषा', # Fuzzy
	'mobile-frontend-username' => 'सदस्य नाम:',
	'mobile-frontend-password' => 'कूटशब्द:',
	'mobile-frontend-username-placeholder' => 'सदस्यनाम',
	'mobile-frontend-password-placeholder' => 'पासवर्ड',
	'mobile-frontend-login' => 'लॉग इन',
	'mobile-frontend-placeholder' => 'खोज शब्द यहाँ टाइप करें...', # Fuzzy
	'mobile-frontend-main-menu-account-create' => 'खाता बनाएँ',
	'mobile-frontend-page-menu-history' => 'इतिहास',
	'mobile-frontend-watchlist-filter-all' => 'सभी',
	'mobile-frontend-watchlist-filter-articles' => 'लेख',
	'mobile-frontend-watchlist-filter-talk' => 'वार्ता',
	'mobile-frontend-watchlist-filter-other' => 'अन्य',
);

/** Fiji Hindi (Latin script) (Fiji Hindi)
 * @author Karthi.dr
 */
$messages['hif-latn'] = array(
	'mobile-frontend-search-submit' => 'Jaao',
	'mobile-frontend-home-button' => 'Pahila Panna',
	'mobile-frontend-random-button' => 'Koi bhi',
	'mobile-frontend-show-button' => 'Dekhao',
	'mobile-frontend-hide-button' => 'Chhupao',
	'mobile-frontend-images-status' => 'Chhapa',
	'mobile-frontend-featured-article' => 'Aaj ke featured article',
	'mobile-frontend-leave-feedback-subject' => 'Vishay:',
	'mobile-frontend-language' => 'Bhasa:',
	'mobile-frontend-username' => 'Sadasya ke naam:',
	'mobile-frontend-login' => 'Log in karo',
	'mobile-frontend-placeholder' => '{{SITENAME}} khojo',
	'mobile-frontend-privacy-link-text' => 'Gupt',
	'mobile-frontend-settings-site-header' => '{{SITENAME}} Bhasa',
	'mobile-frontend-page-menu-history' => 'Itihaas',
);

/** Hiligaynon (Ilonggo)
 */
$messages['hil'] = array(
	'mobile-frontend-search-submit' => 'Lakat',
	'mobile-frontend-home-button' => 'Balay',
	'mobile-frontend-random-button' => 'Randum',
	'mobile-frontend-show-button' => 'Ipakita',
	'mobile-frontend-hide-button' => 'Taguon',
	'mobile-frontend-regular-site' => 'Tan-awon ini nga pahina sa regular na Wikipedya', # Fuzzy
	'mobile-frontend-featured-article' => 'Subong nga Napili na Artikulo',
);

/** Croatian (hrvatski)
 * @author Roberta F.
 * @author SpeedyGonsales
 */
$messages['hr'] = array(
	'mobile-frontend-desc' => 'Sučelje za mobilne uređaje',
	'mobile-frontend-search-submit' => 'Idi',
	'mobile-frontend-home-button' => 'Početna',
	'mobile-frontend-logged-out' => 'Niste prijavljeni',
	'mobile-frontend-logged-in-homepage-notification' => 'Dobrodošli, $1!',
	'mobile-frontend-logged-in-toast-notification' => 'Prijavljeni ste kao $1.',
	'mobile-frontend-sign-up-heading' => 'Prijavite se',
	'mobile-frontend-sign-in-heading' => 'Prijava',
	'mobile-frontend-sign-in-why' => 'Ako imate suradnički račun na {{SITENAME}}, prijavite se ovdje.',
	'mobile-frontend-sign-in-error-heading' => 'Pogrješka',
	'mobile-frontend-settings-description' => 'Prilagodite mobilno sučelje',
	'mobile-frontend-settings-beta' => 'Beta',
	'mobile-frontend-settings-alpha' => '[//en.wikipedia.org/wiki/Here_be_dragons Za napredne] i hrabre',
	'mobile-frontend-settings-alpha-description' => 'Još više eksperimentalnih mogućnosti, još veća opasnost od neriješenih bugova.',
	'mobile-frontend-save-settings' => 'Pohrani postavke',
	'mobile-frontend-random-button' => 'Slučajna stranica',
	'mobile-frontend-ajax-random-heading' => 'Tražim...',
	'mobile-frontend-ajax-random-quote' => 'Slučajna poruka',
	'mobile-frontend-ajax-random-question' => 'Želite čitati ovu stranicu?',
	'mobile-frontend-ajax-random-yes' => 'Da',
	'mobile-frontend-ajax-random-retry' => 'Pokušaj ponovo',
	'mobile-frontend-ajax-random-suggestions' => 'Drugi prijedlozi:',
	'mobile-frontend-back-to-top-of-section' => 'Skoči natrag na odjeljak',
	'mobile-frontend-close-section' => 'Zatvori odlomak',
	'mobile-frontend-show-button' => 'Prikaži',
	'mobile-frontend-hide-button' => 'Sakrij',
	'mobile-frontend-empty-homepage-text' => 'Ovu stranicu potrebno je konfigurirati. <a href="http://meta.wikimedia.org/wiki/Mobile_Projects/Mobile_Gateway#Mobile_homepage">Upute kako omogućiti mobilnu inačicu ovih web stranica</a>', # Fuzzy
	'mobile-frontend-regular-site' => 'Prikaz stranice kao na osobnom računalu',
	'mobile-frontend-wml-continue' => 'Nastavi...',
	'mobile-frontend-wml-back' => 'Natrag...',
	'mobile-frontend-view' => 'Mobilni prikaz',
	'mobile-frontend-view-desktop' => 'Osobno računalo',
	'mobile-frontend-view-mobile' => 'Mobilno računalo',
	'mobile-frontend-opt-in-explain' => 'Rabeći beta inačicu, dobivate pristup eksperimentalnim mogućnosti, ali uz rizik mogućih pogrješaka i problema.',
	'mobile-frontend-images-status' => 'Slike',
	'mobile-frontend-disable-images' => 'Onemogući prikaz slika na mobilnim stranicama',
	'mobile-frontend-enable-images' => 'Omogući prikaz slika na mobilnim stranicama',
	'mobile-frontend-missing-image' => 'Slika',
	'mobile-frontend-off' => 'isključeno',
	'mobile-frontend-on' => 'uključeno',
	'mobile-frontend-footer-contributors-text' => 'Ovu su stranicu pisali [$1 suradnici] poput Vas',
	'mobile-frontend-featured-article' => 'Današnji izabrani članak',
	'mobile-frontend-news-items' => 'U vijestima',
	'mobile-frontend-leave-feedback-notice' => 'Povratna informacija pomaže nam poboljšati sučelje. Bit će objavljena javno (s Vašim suradničkim imenom, inačicom internetskog preglednika i operacijskog sustava) na stranici &quot;$1&quot;. Molimo izaberite informativan predmet poruke, npr. "Oblikovanje širokih tablica". Vaša poruka podliježe uvjetima uporabe ovih stranica.',
	'mobile-frontend-leave-feedback-warning' => 'Ako ne želite da vaši podatci budu javni, molimo nemojte navoditi osobne podatke u Vašim komentarima.',
	'mobile-frontend-leave-feedback-subject' => 'Predmet:',
	'mobile-frontend-leave-feedback-message' => 'Poruka:',
	'mobile-frontend-leave-feedback-submit' => 'Pošaljite povratnu informaciju',
	'mobile-frontend-leave-feedback-link-text' => 'Vaše mišljenje o mobilnom sučelju',
	'mobile-frontend-leave-feedback' => 'Vaše mišljenje o mobilnom sučelju',
	'mobile-frontend-leave-feedback-title' => 'Vaše mišljenje o mobilnom sučelju',
	'mobile-frontend-leave-feedback-technical-problem-section-header' => 'Tehnički problem',
	'mobile-frontend-leave-feedback-general-section-header' => 'Općenito',
	'mobile-frontend-leave-feedback-article-feedback-section-header' => 'Ocjenjivanje članka',
	'mobile-frontend-leave-feedback-email-body' => 'Molimo opišite problem sa {{SITENAME}} iznad ove crte. Molimo uvažite to da ne možemo odgovoriti na svaku poruku koju dobijemo.',
	'mobile-frontend-leave-feedback-technical-link-text' => 'Tehnički problem',
	'mobile-frontend-leave-feedback-general-link-text' => 'Opća povratna informacija',
	'mobile-frontend-leave-feedback-article-personal-link-text' => 'U moje ime, pravne ili fizičke osobe koju zastupam',
	'mobile-frontend-leave-feedback-article-factual-link-text' => 'Glede činjenične pogrješke',
	'mobile-frontend-leave-feedback-article-other-link-text' => 'Glede nekog drugog problema',
	'mobile-frontend-leave-feedback-form-subject-placeholder' => 'Predmet poruke',
	'mobile-frontend-leave-feedback-form-message-placeholder' => 'Unesite Vaš komentar ovdje',
	'mobile-frontend-leave-feedback-page-title' => 'Vaše mišljenje o mobilnom sučelju',
	'mobile-frontend-leave-feedback-special-title' => 'Kontaktirajte nas',
	'mobile-frontend-feedback-no-subject' => '(nema predmeta)',
	'mobile-frontend-feedback-no-subject-field' => 'Molimo unesite predmet poruke',
	'mobile-frontend-feedback-no-message' => 'Molimo unesite poruku ovdje',
	'mobile-frontend-feedback-edit-summary' => '$1 – automatski poslano uporabom [[Special:MobileFeedback|alata za slanje "mobilnih" povratnih informacija]]',
	'mobile-frontend-leave-feedback-thanks' => 'Hvala Vam na povratnoj informaciji!',
	'mobile-frontend-leave-feedback-post-error' => 'Dogodila se pogrješka pri obradi vaše poruke. Molimo pokušajte kasnije.',
	'mobile-frontend-language' => 'Jezik:',
	'mobile-frontend-language-article-heading' => 'Drugi jezici',
	'mobile-frontend-language-header' => 'Ova stranica dostupna je na $1 {{PLURAL:$1|jeziku|jezika}}',
	'mobile-frontend-language-variant-header' => 'Izaberite {{#language:{{CONTENTLANG}}}} varijantu',
	'mobile-frontend-language-footer' => 'Napomena: Ova stranica možda nije prikazana na jeziku Vašeg izbora. Pogledajte pregled dostupnih jezika na "{{SITENAME}}" ovdje.',
	'mobile-frontend-language-site-choose' => 'Potraži jezik',
	'mobile-frontend-username' => 'Suradničko ime:',
	'mobile-frontend-password' => 'Zaporka:',
	'mobile-frontend-username-placeholder' => 'Suradničko ime',
	'mobile-frontend-password-placeholder' => 'Zaporka',
	'mobile-frontend-login' => 'Prijava',
	'mobile-frontend-account-create-submit' => 'Prijavite se',
	'mobile-frontend-password-confirm-placeholder' => 'Potvrdi zaporku',
	'mobile-frontend-account-create-email-placeholder' => 'Adresa e-pošte (neobvezno)',
	'mobile-frontend-account-create-captcha-placeholder' => 'Unesite "captcha" tekst',
	'mobile-frontend-overlay-escape' => 'Povratak',
	'mobile-frontend-placeholder' => 'Pretražite {{SITENAME}}',
	'mobile-frontend-placeholder-beta' => 'Pretražite {{SITENAME}} (Beta)',
	'mobile-frontend-placeholder-alpha' => 'Pretražite {{SITENAME}} (za napredne)',
	'mobile-frontend-search-help' => 'Unesite traženi pojam a ovdje će se prikazati članci koji odgovaraju upitu.',
	'mobile-frontend-dismiss-notification' => 'ukloni ovu obavijest',
	'mobile-frontend-clear-search' => 'Očisti',
	'mobile-frontend-privacy-link-text' => 'Privatnost',
	'mobile-frontend-about-link-text' => 'O nama',
	'mobile-frontend-footer-sitename' => '{{SITENAME}}',
	'mobile-frontend-footer-license-text' => 'Sadržaj je dostupan pod <a href="//en.m.wikipedia.org/wiki/Wikipedia:Text_of_Creative_Commons_Attribution-ShareAlike_3.0_Unported_License?useformat=mobile">CC BY-SA 3.0</a> licencijom.',
	'mobile-frontend-footer-contact' => 'Kontakt',
	'mobile-frontend-search-noresults' => 'Nema članka koji odgovara upitu. Promijenite traženi izraz, ili pritisnite gumb za pretraživanje sadržaja članaka.',
	'mobile-frontend-main-menu-button-tooltip' => 'Otvori glavni izbornik',
	'mobile-frontend-main-menu-page-title' => 'Navigacija',
	'mobile-frontend-main-menu-featured' => 'Izabrani članak',
	'mobile-frontend-main-menu-nearby' => 'U blizini',
	'mobile-frontend-main-menu-login' => 'Prijavite se',
	'mobile-frontend-main-menu-logout' => 'Odjava',
	'mobile-frontend-main-menu-watchlist' => 'Praćene stranice',
	'mobile-frontend-main-menu-settings' => 'Postavke',
	'mobile-frontend-main-menu-settings-heading' => 'Postavke mobilnog sučelja',
	'mobile-frontend-settings-site-header' => '{{SITENAME}} jezici',
	'mobile-frontend-settings-site-description' => 'Projekt {{SITENAME}} dostupan je na $1 {{PLURAL:$1|jeziku|jezika}}. Sve jezične inačice pobrojane su ovdje',
	'mobile-frontend-main-menu-contact' => 'Kontakt',
	'mobile-frontend-main-menu-account-create' => 'Otvori suradnički račun',
	'mobile-frontend-page-menu-contents' => 'sadržaj',
	'mobile-frontend-page-menu-history' => 'Povijest stranice',
	'mobile-frontend-meta-data-issues-header' => 'Nedostatci',
	'mobile-frontend-meta-data-issues' => 'Ova stranica ima sljedeće nedostatke',
	'mobile-frontend-ajax-page-loading' => 'Učitavam $1',
	'mobile-frontend-page-saving' => 'Snimam $1',
	'mobile-frontend-ajax-page-error' => 'Ups! Nije uspjelo. Molimo učitajte ponovo stranicu.',
	'mobile-frontend-photo-upload-generic' => 'Darujte nam sliku',
	'mobile-frontend-donate-image-title' => 'Darujte nam sliku',
	'mobile-frontend-donate-image-summary' => 'Slike čine članke na {{SITENAME}} životnijim.
Puno je članaka koji nemaju nijedne slike zbog nedostatka slobodnih slika.
Pomozite i Vi, darujte sliku (ili slike) zajednici.',
	'mobile-frontend-donate-image-heading' => 'Vaši nedavni doprinosi',
	'mobile-frontend-watchlist-add' => 'Stranica $1 dodana je na popis praćenih stranica',
	'mobile-frontend-watchlist-removed' => 'Stranica $1 uklonjena je sa popisa praćenih stranica',
	'mobile-frontend-watchlist-view' => 'Pregled popisa praćenih stranica',
	'mobile-frontend-watchlist-a-z' => 'Praćene stranice', # Fuzzy
	'mobile-frontend-watchlist-feed' => 'Promijenjene stranice', # Fuzzy
	'mobile-frontend-changeslist-ip' => 'Anonimni suradnik',
	'mobile-frontend-changeslist-nocomment' => 'bez sažetka',
	'mobile-frontend-watchlist-filter-all' => 'Sve',
	'mobile-frontend-watchlist-filter-articles' => 'Članci',
	'mobile-frontend-watchlist-filter-talk' => 'Razgovor',
	'mobile-frontend-watchlist-filter-other' => 'Ostalo',
	'mobile-frontend-diffview-title' => 'Promjeni u $1', # Fuzzy
	'mobile-frontend-diffview-editcount' => '$1 {{PLURAL:$1|uređivanje|uređivanja}}',
	'mobile-frontend-diffview-anonymous' => 'Anonimni suradnik',
	'mobile-frontend-diffview-bytesadded' => '$1 {{PLURAL:$1|bajt|bajta|bajtova}} dodano',
	'mobile-frontend-diffview-bytesremoved' => '$1 {{PLURAL:$1|bajt|bajta|bajtova}} obrisano',
	'mobile-frontend-table' => 'Tablica $1',
	'mobile-frontend-saving-exit-page' => 'Vaše uređivanje se još snima. Ako prekinete Vaše uređivanje bit će izgubljeno. Jeste li sigurni da želite prekinuti?',
	'mobile-frontend-photo-upload' => 'Dodaj prvu sliku na ovu stranicu',
	'mobile-frontend-photo-article-edit-comment' => 'Dodana slika na stranicu (s mobilnog uređaja)',
	'mobile-frontend-photo-upload-comment' => 'Dodana slika na stranicu (s mobilnog uređaja)',
	'mobile-frontend-photo-upload-progress' => 'Snimam Vašu sliku na stranicu',
	'mobile-frontend-photo-caption-placeholder' => 'Dodaj opis slike',
	'mobile-frontend-image-loading' => 'Učitavam sliku',
	'mobile-frontend-image-uploading' => 'Šaljem sliku',
	'mobile-frontend-photo-upload-error' => 'Pogrješka tijekom slanja. Pokušajte opet, ili pokušajte s nekom drugom slikom.',
	'mobile-frontend-image-saving-to-article' => 'Dodajem sliku na stranicu',
	'mobile-frontend-photo-license' => 'Napomena: Sve slike koje dodate objavujete pod [//en.wikipedia.org/wiki/Wikipedia:Text_of_Creative_Commons_Attribution-ShareAlike_3.0_Unported_License CC BY-SA 3.0 licencijom]',
);

/** Upper Sorbian (hornjoserbsce)
 * @author Michawiki
 */
$messages['hsb'] = array(
	'mobile-frontend-desc' => 'Zwobraznjenje stronow za mobilne kónčne graty',
	'mobile-frontend-search-submit' => 'Pytać',
	'mobile-frontend-home-button' => 'Start',
	'mobile-frontend-logged-out' => 'Njepřizjewjeny',
	'mobile-frontend-logged-in-homepage-notification' => 'Witaj, $1',
	'mobile-frontend-logged-in-toast-notification' => 'Přizjewjeny jako $1.',
	'mobile-frontend-sign-up-heading' => 'Registrować',
	'mobile-frontend-sign-in-heading' => 'Registrować',
	'mobile-frontend-sign-in-why' => 'Jeli maš konto na {{GRAMMAR:lokatiw|{{SITENAME}}}}, móžeš so deleka registrować.',
	'mobile-frontend-sign-in-error-heading' => 'Hopla',
	'mobile-frontend-settings-description' => 'Přiměr swój mobilny grat z tutymi mobilnymi specifiskimi nastajenjemi.',
	'mobile-frontend-settings-beta' => 'Beta',
	'mobile-frontend-settings-alpha' => 'Modus [//de.wikipedia.org/wiki/Hic_sunt_dracones „Hic sunt dracones“]',
	'mobile-frontend-save-settings' => 'Nastajenja składować',
	'mobile-frontend-random-button' => 'Připadny',
	'mobile-frontend-ajax-random-heading' => 'Wěda so pyta...',
	'mobile-frontend-ajax-random-quote' => 'Intelektualny róst měł so z narodom započeć a ze smjerću přestać',
	'mobile-frontend-ajax-random-question' => 'Tutu stronu čitać?',
	'mobile-frontend-ajax-random-yes' => 'Haj',
	'mobile-frontend-ajax-random-retry' => 'Hišće raz spytać',
	'mobile-frontend-ajax-random-suggestions' => 'Druhe namjety:',
	'mobile-frontend-back-to-top-of-section' => 'Wotrězk wróćo skočić',
	'mobile-frontend-close-section' => 'Tutón wotrězk začinić',
	'mobile-frontend-show-button' => 'Pokazać',
	'mobile-frontend-hide-button' => 'Schować',
	'mobile-frontend-empty-homepage-text' => 'Tuta startowa strona dyrbi so konfigurować. [//meta.wikimedia.org/wiki/Mobile_Projects/Mobile_Gateway#Mobile_homepage Instrukcije, kak hodźi so tute mobilne websydło zmóžnić]',
	'mobile-frontend-regular-site' => 'Klasiski napohlad',
	'mobile-frontend-wml-continue' => 'Dale ...',
	'mobile-frontend-wml-back' => 'Wróćo ...',
	'mobile-frontend-view' => 'Mobilny napohlad',
	'mobile-frontend-view-desktop' => 'Desktop',
	'mobile-frontend-view-mobile' => 'Mobilny',
	'mobile-frontend-opt-in-explain' => 'Přez wobdźělenje na betatesće, změješ přistup na eksperimentelne funkcije, kotrež wšak móža zmylki a problemy zawinować.',
	'mobile-frontend-images-status' => 'Wobrazy',
	'mobile-frontend-disable-images' => 'Wobrazy w mobilnym napohledźe znjemóžnić',
	'mobile-frontend-enable-images' => 'Wobrazy w mobilnym napohledźe zmóžnić',
	'mobile-frontend-missing-image' => 'Wobraz',
	'mobile-frontend-off' => 'WUPINJENY',
	'mobile-frontend-on' => 'ZAPINJENY',
	'mobile-frontend-footer-contributors-text' => 'Strona wot [$1 awtorow] kaž ty',
	'mobile-frontend-featured-article' => 'Nastawk dnja',
	'mobile-frontend-news-items' => 'W powěsćach',
	'mobile-frontend-leave-feedback-notice' => 'Twoje komentary pomhaja nam mobilne sydło polěpšić. Wozjewja so z wužiwarskim mjenom, wersiju wobhladowaka a dźěłowym systemom na stronje &quot;$1&quot;. Prošu wubjer wuprajiwu temu, na př. "Problemy při formatowanju tabelow". Twoje komentary podleža našim wužiwarskim wuměnjenjam.',
	'mobile-frontend-leave-feedback-warning' => 'Prošu njezapřimiće wosobinske informacije do swojich komentarow, chibazo sy přezjedny, zo so twoje informacije wozjewja.',
	'mobile-frontend-leave-feedback-subject' => 'Tema:',
	'mobile-frontend-leave-feedback-message' => 'Powěsć:',
	'mobile-frontend-leave-feedback-submit' => 'Komentar wotpósłać',
	'mobile-frontend-leave-feedback-link-text' => 'Komentary k rozšěrjenju MobileFrontend',
	'mobile-frontend-leave-feedback' => 'Komentary wo mobilnym sydle',
	'mobile-frontend-leave-feedback-title' => 'Komentary wo mobilnym sydle',
	'mobile-frontend-leave-feedback-technical-problem-section-header' => 'Techniski problem',
	'mobile-frontend-leave-feedback-general-section-header' => 'Powšitkowny',
	'mobile-frontend-leave-feedback-article-feedback-section-header' => 'Komentary wo nastawkach',
	'mobile-frontend-leave-feedback-email-body' => 'Prošu wopisaj problem, na kotryž sy z {{GRAMMAR:instrumental|{{SITENAME}}}} wyše tuteje linije storčił. Prošu dźiwaj na to, zo njemóžemy na kóždu powěsć wotmołwić, kotruž dóstawamy.',
	'mobile-frontend-leave-feedback-technical-link-text' => 'Techniski problem',
	'mobile-frontend-leave-feedback-general-link-text' => 'Powšitkowne komentary',
	'mobile-frontend-leave-feedback-article-personal-link-text' => 'Nastupajo mje, wosobu abo předewzaće, kotrež reprezentuju',
	'mobile-frontend-leave-feedback-article-factual-link-text' => 'Nastupajo wěcowny zmylk',
	'mobile-frontend-leave-feedback-article-other-link-text' => 'Nastupajo druhi problem',
	'mobile-frontend-leave-feedback-form-subject-placeholder' => 'Tema powěsće',
	'mobile-frontend-leave-feedback-form-message-placeholder' => 'Zapodaj tu swój komentar',
	'mobile-frontend-leave-feedback-page-title' => 'Komentary wo mobilnym sydle',
	'mobile-frontend-leave-feedback-special-title' => 'Skontaktuj so z  nami',
	'mobile-frontend-feedback-no-subject' => '(žana tema)',
	'mobile-frontend-feedback-no-subject-field' => 'Prošu zapodaj temu',
	'mobile-frontend-feedback-no-message' => 'Prošu zapodaj tu zdźělenku',
	'mobile-frontend-feedback-edit-summary' => '$1 - z [[Special:MobileFeedback|mobilnym komentarowym nastrojom]] awtomatisce rozpósłany',
	'mobile-frontend-leave-feedback-thanks' => 'Dźakujemy so za twój komentar!',
	'mobile-frontend-leave-feedback-post-error' => 'Při předźěłowanju wašeje powěsće je zmylk wustupił.
Prošu spytajće pozdźišo hišće raz.',
	'mobile-frontend-language' => 'Rěč:',
	'mobile-frontend-language-article-heading' => 'W druhej rěči čitać',
	'mobile-frontend-language-header' => 'Tuta strona steji w $1 {{PLURAL:$1|rěči|rěčomaj|rěčach}} k dispoziciji',
	'mobile-frontend-language-variant-header' => 'Wariantu rěče {{#language:{{CONTENTLANG}}}} wubrać',
	'mobile-frontend-language-footer' => 'Kedźbu: Tuta strona njeje so snano w twojej preferowanej rěči napisała. Móžeš widźeć, kotre rěče {{SITENAME}} podpěruje, kliknjo tu.',
	'mobile-frontend-language-site-choose' => 'Rěč pytać',
	'mobile-frontend-username' => 'Wužiwarske mjeno:',
	'mobile-frontend-password' => 'Hesło:',
	'mobile-frontend-username-placeholder' => 'Wužiwarske mjeno',
	'mobile-frontend-password-placeholder' => 'Hesło',
	'mobile-frontend-login' => 'Přizjewić',
	'mobile-frontend-account-create-submit' => 'Registrować',
	'mobile-frontend-password-confirm-placeholder' => 'Hesło wobkrućić',
	'mobile-frontend-account-create-email-placeholder' => 'E-mejlowa adresa (opcionalny)',
	'mobile-frontend-account-create-captcha-placeholder' => 'Wěstotny tekst zapodać',
	'mobile-frontend-overlay-escape' => 'Wróćo',
	'mobile-frontend-placeholder' => '{{GRAMMAR:akuzatiw|{{SITENAME}}}} přepytać',
	'mobile-frontend-placeholder-beta' => '{{GRAMMAR:akuzatiw|{{SITENAME}}}} přepytać (beta)',
	'mobile-frontend-placeholder-alpha' => '{{GRAMMAR:akuzatiw|{{SITENAME}}}} přepytać (zmijacy modus)',
	'mobile-frontend-search-help' => 'Zapisaj horjeka pytanske zapřijeće a wotpowědne titule strony budu se tu  jewić.',
	'mobile-frontend-dismiss-notification' => 'Tute zdźělenje zaćisnyć',
	'mobile-frontend-clear-search' => 'Wuprózdnić',
	'mobile-frontend-privacy-link-text' => 'Priwatnosć',
	'mobile-frontend-about-link-text' => 'Wo',
	'mobile-frontend-footer-sitename' => '{{SITENAME}}',
	'mobile-frontend-footer-license-text' => 'Wobsah steji pod licencu [//en.m.wikipedia.org/wiki/Wikipedia:Text_of_Creative_Commons_Attribution-ShareAlike_3.0_Unported_License?useformat=mobile CC BY-SA 3.0] k dispoziciji',
	'mobile-frontend-terms-use-text' => '[//wikimediafoundation.org/wiki/Terms_of_Use/de?useformat=mobile wužiwarske wuměnjenja] (němsce)',
	'mobile-frontend-footer-contact' => 'Kontakt',
	'mobile-frontend-search-noresults' => 'Twojemu pytanju žane titule strony njewotpowěduja. Změń swoje pytanje abo stłóč pytansku tastu swojeje tastatury, zo by znutřka stronow pytał.',
	'mobile-frontend-main-menu-button-tooltip' => 'Hłowny meni wočinić',
	'mobile-frontend-main-menu-page-title' => 'Sydłowa nawigacija',
	'mobile-frontend-main-menu-featured' => 'Wuběrny',
	'mobile-frontend-main-menu-nearby' => 'W bliskosći',
	'mobile-frontend-main-menu-login' => 'Přizjewić',
	'mobile-frontend-main-menu-logout' => 'Wotzjewić',
	'mobile-frontend-main-menu-watchlist' => 'Wobkedźbowanki',
	'mobile-frontend-main-menu-settings' => 'Nastajenja',
	'mobile-frontend-main-menu-upload' => 'Nahraća',
	'mobile-frontend-main-menu-settings-heading' => 'Mobilne nastajenja',
	'mobile-frontend-settings-site-header' => 'Rěče {{GRAMMAR:genitiw|{{SITENAME}}}}',
	'mobile-frontend-settings-site-description' => '{{SITENAME}} steji w $1 {{PLURAL:$1|rěči|rěči|rěčach|rěčach}} k dispoziciji. Wšě k dispoziciji stejace wersije su deleka nalistowane:',
	'mobile-frontend-main-menu-contact' => 'Kontakt',
	'mobile-frontend-main-menu-account-create' => 'Konto załožić',
	'mobile-frontend-page-menu-contents' => 'wobsah',
	'mobile-frontend-page-menu-history' => 'Stawizny',
	'mobile-frontend-meta-data-issues-header' => 'Problemy',
	'mobile-frontend-meta-data-issues' => 'Tuta strona ma problemy',
	'mobile-frontend-ajax-page-loading' => '$1 so začituje',
	'mobile-frontend-page-saving' => '$1 so składuje',
	'mobile-frontend-ajax-page-error' => 'Hopla! Něšto je so nimokuliło. Prošu spytaj wokno swojeho wobhladowaka aktualizować.',
	'mobile-frontend-nearby-title' => 'W bliskosći',
	'mobile-frontend-nearby-distance-report' => '$1 km wot twojeho aktualneho stejnišća',
	'mobile-frontend-nearby-lookup-error' => 'Njeje móžno će namakać. Spytaj hišće raz.',
	'mobile-frontend-donate-image-login' => 'Dyrbiš přizjewjeny być, zo by swoje nahraća widźał.',
	'mobile-frontend-photo-upload-generic' => 'Wobraz darić',
	'mobile-frontend-donate-image-title' => 'Wobraz darić',
	'mobile-frontend-donate-image-heading' => 'Twoje najnowše přinoški',
	'mobile-frontend-donate-image-page-title' => 'Nahrać',
	'mobile-frontend-donate-image-anon' => 'Trjebaš [[Special:UserLogin|wužiwarske konto]], zo by sej stronu nahraćow wobhladał',
	'mobile-frontend-listed-image-no-description' => 'Žane wopisanje',
	'mobile-frontend-donate-photo-upload-success' => 'Wuspěch! Twój wobraz hodźi so nětko na {{GRAMMAR:lokatiw|{{SITENAME}}}} wužiwać!',
	'mobile-frontend-donate-photo-first-upload-success' => 'Wuspěch! Wulki dźak za twój prěni přinošk!',
	'mobile-frontend-watchlist-add' => '$1 je so wobkedźbowankam přidał',
	'mobile-frontend-watchlist-removed' => '$1 je so z wobkedźbowankow wotstronił',
	'mobile-frontend-watchlist-view' => 'Sej wobkedźbowanki wobhladać',
	'mobile-frontend-watchlist-more' => 'wjace',
	'mobile-frontend-watchlist-cta' => 'Prošu přizjew so abo zregistruj so, zo by tutu stronu wobkedźbował.',
	'mobile-frontend-watchlist-cta-button-login' => 'Přizjewić',
	'mobile-frontend-watchlist-cta-button-signup' => 'Registrować',
	'mobile-frontend-watch-login' => 'Dyrbiš přizjewjeny być, zo by strony wobkedźbował.',
	'mobile-frontend-watchlist-a-z' => 'Wšě',
	'mobile-frontend-watchlist-feed' => 'Změnjeny',
	'mobile-frontend-watchlist-a-z-empty' => 'Njewobkedźbuješ tuchwilu žane strony',
	'mobile-frontend-watchlist-a-z-empty-howto-alt' => 'Klikń na hwěžku horjeka na stronje',
	'mobile-frontend-watchlist-feed-empty' => 'Njejsu žane strony z nowymi změnami',
	'mobile-frontend-watchlist-back-home' => 'Wróćo k startowej stronje',
	'mobile-frontend-changeslist-ip' => 'Anonymny wužiwar',
	'mobile-frontend-changeslist-nocomment' => 'žane zjeće',
	'mobile-frontend-watchlist-filter-all' => 'Wšě',
	'mobile-frontend-watchlist-filter-articles' => 'Nastawki',
	'mobile-frontend-watchlist-filter-talk' => 'Diskusija',
	'mobile-frontend-watchlist-filter-other' => 'Druhe',
	'mobile-frontend-watchlist-modified' => 'Změnjeny $1',
	'mobile-frontend-diffview-404-title' => 'Njepłaćiwa wersija',
	'mobile-frontend-diffview-404-desc' => 'ID za požadanu wersiju njeeksistuje',
	'mobile-frontend-diffview-title' => 'Změny',
	'mobile-frontend-diffview-editcount' => '$1 {{PLURAL:$1|změna|změnje|změny|změnow}}',
	'mobile-frontend-diffview-anonymous' => 'Anonymny wužiwar',
	'mobile-frontend-diffview-bytesadded' => '$1 {{PLURAL:$1|bajt přidaty|bajtaj přidatej|bajty přidate|bajtow přidatych}}',
	'mobile-frontend-diffview-bytesremoved' => '$1 {{PLURAL:$1|bajt wotstronjeny|bajtaj wotstronjenej|bajty wostronjene|bajtow wotstronjenych}}',
	'mobile-frontend-diffview-explained' => 'Slědowace linki su so přidali (+) a wotstronili (-):',
	'mobile-frontend-table' => 'Tabela $1',
	'mobile-frontend-saving-exit-page' => 'Twój přinošk so hišće składuje. Jeli nětko kónčiš, so twoje přinoški zhubja. Chceš woprawdźe kónčić?',
	'mobile-frontend-photo-upload' => 'Wobraz tutomu nastawkej přidać',
	'mobile-frontend-photo-article-edit-comment' => 'Foto za wužiwanje w stronje přidate',
	'mobile-frontend-photo-article-donate-comment' => 'Darjeny wobraz z mobilneho grata',
	'mobile-frontend-photo-upload-comment' => 'Foto stronje přidate',
	'mobile-frontend-photo-caption-placeholder' => 'Wopisanje přidać (trěbne)',
	'mobile-frontend-image-loading' => 'Wobraz so začituje',
	'mobile-frontend-image-uploading-wait' => 'Wobraz so nahrawa, prošu čakaj.',
	'mobile-frontend-image-uploading-long' => 'Wobraz so hišće nahrawa! Dźakujemy so za twoju sćerpliwosć.',
	'mobile-frontend-image-uploading-cancel' => '<a href="#">Přetorhń</a>, jeli to předołho traje.',
	'mobile-frontend-photo-upload-error' => 'Zmylk, prošu spytaj hišće raz.',
	'mobile-frontend-photo-upload-success-article' => 'Wuspěch! Twój wobraz je nětko na tutej stronje.',
	'mobile-frontend-photo-license' => 'Hdyž kliknješ na "Wotpósłać" zwoliš do našich [//wikimediafoundation.org/wiki/Terms_of_use wužiwarskich wuměnjenjow] a přizwoliš swoje foto pod licencu  [//creativecommons.org/licenses/by-sa/3.0/ Creative Commons Attribution-ShareAlike 3.0] wozjewić.',
	'mobile-frontend-photo-submit' => 'Wotpósłać',
	'mobile-frontend-photo-cancel' => 'Přetorhnyć',
	'mobile-frontend-photo-upload-user-count' => '{{PLURAL:$1|1 nahraće|$1 nahraći|$1 nahraća|$1 nahraćow}}', # Fuzzy
	'mobile-frontend-photo-upload-user-count-over-limit' => '500+ nahratych datajow',
	'tag-mobile_edit' => 'Mobilna změna',
	'tag-mobile_edit-description' => 'Z mobilneho sydła změnjeny',
	'mobile-frontend-drawer-cancel' => 'Přetorhnyć',
);

/** Hungarian (magyar)
 * @author BáthoryPéter
 * @author Dj
 * @author Hunyadym
 * @author Misibacsi
 */
$messages['hu'] = array(
	'mobile-frontend-desc' => 'Mobil felület',
	'mobile-frontend-search-submit' => 'Menj',
	'mobile-frontend-home-button' => 'Kezdőlap',
	'mobile-frontend-logged-out' => 'Nem vagy bejelentkezve',
	'mobile-frontend-logged-in-homepage-notification' => 'Üdvözlünk $1!',
	'mobile-frontend-logged-in-toast-notification' => 'Be vagy jelentkezve $1 néven.',
	'mobile-frontend-sign-up-heading' => 'Regisztráció',
	'mobile-frontend-sign-in-heading' => 'Bejelentkezés',
	'mobile-frontend-sign-in-why' => 'Ha van {{SITENAME}} fiókod, be tudsz jelentkezni.',
	'mobile-frontend-sign-in-error-heading' => 'Hoppá!',
	'mobile-frontend-settings-beta' => 'Béta',
	'mobile-frontend-save-settings' => 'Beállítások mentése',
	'mobile-frontend-random-button' => 'Véletlen lap',
	'mobile-frontend-ajax-random-question' => 'Elolvasod ezt a lapot?',
	'mobile-frontend-ajax-random-yes' => 'Igen',
	'mobile-frontend-ajax-random-retry' => 'Újrapróbálkozás',
	'mobile-frontend-ajax-random-suggestions' => 'Egyéb javaslatok:',
	'mobile-frontend-back-to-top-of-section' => 'Vissza egy bekezdést',
	'mobile-frontend-close-section' => 'Szakasz bezárása',
	'mobile-frontend-show-button' => 'Mutasd',
	'mobile-frontend-hide-button' => 'Elrejtés',
	'mobile-frontend-regular-site' => 'Lap megtekintése a szokásos {{SITENAME}} nézetben', # Fuzzy
	'mobile-frontend-wml-continue' => 'Folytatás ...',
	'mobile-frontend-wml-back' => 'Vissza ...',
	'mobile-frontend-view' => 'Mobil nézet',
	'mobile-frontend-view-desktop' => 'Asztali',
	'mobile-frontend-view-mobile' => 'Mobil',
	'mobile-frontend-opt-in-explain' => 'Ha csatlakozol a béta teszteléshez, akkor kísérleti szolgáltatásokhoz és újdonságokhoz is hozzáférsz, de esetleg hibákkal és problémákkal is találkozhatsz.',
	'mobile-frontend-images-status' => 'Képek',
	'mobile-frontend-disable-images' => 'Képek letiltása mobil nézetben',
	'mobile-frontend-enable-images' => 'Képek engedélyezése mobil nézetben',
	'mobile-frontend-missing-image' => 'Kép',
	'mobile-frontend-off' => 'ki',
	'mobile-frontend-on' => 'be',
	'mobile-frontend-footer-contributors-text' => 'Egy szócikk ugyanolyan <a href="$1">szerkesztőktől</a>, mint te.', # Fuzzy
	'mobile-frontend-featured-article' => 'A nap kiemelt szócikke',
	'mobile-frontend-news-items' => 'Hírek',
	'mobile-frontend-leave-feedback-subject' => 'Tárgy:',
	'mobile-frontend-leave-feedback-message' => 'Üzenet:',
	'mobile-frontend-leave-feedback-submit' => 'Visszajelzés elküldése',
	'mobile-frontend-leave-feedback-link-text' => 'Visszajelzés a mobil felületről',
	'mobile-frontend-leave-feedback' => 'A mobil webhellyel kapcsolatos visszajelzés',
	'mobile-frontend-leave-feedback-title' => 'Küldj visszajelzést a mobil nézettel kapcsolatos tapasztalataidról',
	'mobile-frontend-leave-feedback-technical-problem-section-header' => 'Technikai probléma',
	'mobile-frontend-leave-feedback-general-section-header' => 'Általános',
	'mobile-frontend-leave-feedback-article-feedback-section-header' => 'Cikk értékelése',
	'mobile-frontend-leave-feedback-email-body' => 'Kérlek írd meg a {{SITENAME}} oldalon felmerült problémát e vonal fölé. Megjegyezzük, hogy nem válaszolunk minden megkapott üzenetre.',
	'mobile-frontend-leave-feedback-technical-link-text' => 'Technikai probléma',
	'mobile-frontend-leave-feedback-general-link-text' => 'Általános visszajelzés',
	'mobile-frontend-leave-feedback-form-subject-placeholder' => 'Üzenet tárgya',
	'mobile-frontend-leave-feedback-form-message-placeholder' => 'Írd be ide megjegyzésed',
	'mobile-frontend-leave-feedback-page-title' => 'Küldj visszajelzést a mobil nézettel kapcsolatos tapasztalataidról',
	'mobile-frontend-leave-feedback-special-title' => 'Kapcsolatfelvétel',
	'mobile-frontend-feedback-no-subject' => '(nincs tárgy)',
	'mobile-frontend-feedback-no-subject-field' => 'Adj meg egy tárgyat',
	'mobile-frontend-feedback-no-message' => 'Kérlek írjál be valami üzenetet ide',
	'mobile-frontend-leave-feedback-thanks' => 'Köszönjük a visszajelzésedet!',
	'mobile-frontend-leave-feedback-post-error' => 'Hiba történt az üzeneted feldolgozása közben. Próbáld meg újra később!',
	'mobile-frontend-language' => 'Nyelv',
	'mobile-frontend-language-article-heading' => 'Olvasd el más nyelven',
	'mobile-frontend-language-header' => 'A szócikk $1 nyelven elérhető', # Fuzzy
	'mobile-frontend-language-footer' => '{{SITENAME}} más nyelveken is elérhető.', # Fuzzy
	'mobile-frontend-language-site-choose' => 'Nyelv keresése',
	'mobile-frontend-username' => 'Felhasználónév:',
	'mobile-frontend-password' => 'Jelszó:',
	'mobile-frontend-username-placeholder' => 'Felhasználónév',
	'mobile-frontend-password-placeholder' => 'Jelszó',
	'mobile-frontend-login' => 'Bejelentkezés',
	'mobile-frontend-account-create-submit' => 'Regisztráció',
	'mobile-frontend-password-confirm-placeholder' => 'Jelszó megerősítése',
	'mobile-frontend-account-create-email-placeholder' => 'E-mail cím (opcionáis)',
	'mobile-frontend-account-create-captcha-placeholder' => 'Biztonsági szöveg beírása',
	'mobile-frontend-overlay-escape' => 'Vissza',
	'mobile-frontend-placeholder' => 'Keresés a wikin',
	'mobile-frontend-search-help' => 'Írd be felülre a keresőkifejezést, a találatok a szócikkek címeiben itt fognak megjelenni.', # Fuzzy
	'mobile-frontend-dismiss-notification' => 'figyelmeztetés elutasítása',
	'mobile-frontend-clear-search' => 'Törlés',
	'mobile-frontend-privacy-link-text' => 'Adatvédelem',
	'mobile-frontend-about-link-text' => 'Rólunk',
	'mobile-frontend-footer-sitename' => '{{SITENAME}}',
	'mobile-frontend-footer-contact' => 'Kapcsolatfelvétel',
	'mobile-frontend-search-noresults' => 'Nincs találat a keresésedre. Változtasd meg a keresőszavakat, vagy nyomd meg a keresés gombot, hogy a szócikkeken belül is keress.', # Fuzzy
	'mobile-frontend-main-menu-button-tooltip' => 'Főmenü megnyitása',
	'mobile-frontend-main-menu-page-title' => 'Oldal navigáció',
	'mobile-frontend-main-menu-featured' => 'Kiemelt',
	'mobile-frontend-main-menu-nearby' => 'Közeli',
	'mobile-frontend-main-menu-login' => 'Bejelentkezés',
	'mobile-frontend-main-menu-logout' => 'Kijelentkezés',
	'mobile-frontend-main-menu-watchlist' => 'Figyelőlista',
	'mobile-frontend-main-menu-settings' => 'Beállítások',
	'mobile-frontend-main-menu-settings-heading' => 'Mobil oldal beállításai',
	'mobile-frontend-settings-site-header' => '{{SITENAME}} nyelvek',
	'mobile-frontend-settings-site-description' => '{{SITENAME}}  {{PLURAL:$1|egy nyelven|$1 nyelven}} érhető el. Az összes elérhető verzió alább található',
	'mobile-frontend-main-menu-contact' => 'Kapcsolatfelvétel',
	'mobile-frontend-main-menu-account-create' => 'Felhasználói fiók létrehozása',
	'mobile-frontend-page-menu-contents' => 'tartalom',
	'mobile-frontend-page-menu-history' => 'Előzmények',
	'mobile-frontend-ajax-page-loading' => '$1 betöltése',
	'mobile-frontend-page-saving' => '$1 mentése',
	'mobile-frontend-watchlist-removed' => '$1 eltávolítva a figyelőlistádról',
	'mobile-frontend-changeslist-ip' => 'Névtelen felhasználó',
	'mobile-frontend-changeslist-nocomment' => 'nincs szerkesztési összefoglaló',
	'mobile-frontend-watchlist-filter-all' => 'Mind',
	'mobile-frontend-watchlist-filter-articles' => 'Szócikkek',
	'mobile-frontend-watchlist-filter-talk' => 'Vitalap',
	'mobile-frontend-watchlist-filter-other' => 'Egyéb',
	'mobile-frontend-diffview-title' => '$1 módosításai', # Fuzzy
	'mobile-frontend-diffview-editcount' => '{{PLURAL:$1|egy|$1}} szerkesztés',
	'mobile-frontend-diffview-anonymous' => 'Névtelen felhasználó',
	'mobile-frontend-diffview-bytesadded' => '{{PLURAL:$1|egy|$1}} bájt hozzáadva',
	'mobile-frontend-diffview-bytesremoved' => '{{PLURAL:$1|egy|$1}} bájt törölve',
	'mobile-frontend-image-loading' => 'Kép betöltése',
	'mobile-frontend-image-uploading' => 'Kép feltöltése',
	'mobile-frontend-photo-upload-error' => 'Hiba történt a kép feltöltése során. Kérjük próbálj meg egy másik képet.',
);

/** Armenian (Հայերեն)
 * @author Vadgt
 */
$messages['hy'] = array(
	'mobile-frontend-home-button' => 'Դեպի տուն',
	'mobile-frontend-save-settings' => 'Պահպանել կարգավորումները',
	'mobile-frontend-random-button' => 'Պատահական',
	'mobile-frontend-back-to-top-of-section' => 'Վերադառնալ մեկ բաժին առաջ',
	'mobile-frontend-view-mobile' => 'Հեռախոս',
	'mobile-frontend-featured-article' => 'Օրվա ընտրված հոդվածը',
);

/** Interlingua (interlingua)
 * @author McDutchie
 */
$messages['ia'] = array(
	'mobile-frontend-desc' => 'Interfacie pro apparatos mobile',
	'mobile-frontend-search-submit' => 'Va',
	'mobile-frontend-home-button' => 'Initio',
	'mobile-frontend-logged-out' => 'Non identificate',
	'mobile-frontend-settings-description' => 'Personalisa tu experientia sur tu apparato mobile con iste configurationes de sito mobile.',
	'mobile-frontend-settings-beta' => 'Beta',
	'mobile-frontend-save-settings' => 'Confirmar configurationes',
	'mobile-frontend-random-button' => 'Aleatori',
	'mobile-frontend-back-to-top-of-section' => 'Retroceder un section',
	'mobile-frontend-close-section' => 'Clauder iste section',
	'mobile-frontend-show-button' => 'Monstrar',
	'mobile-frontend-hide-button' => 'Celar',
	'mobile-frontend-empty-homepage-text' => 'Iste pagina initial debe esser configurate. <a href="http://meta.wikimedia.org/wiki/Mobile_Projects/Mobile_Gateway#Mobile_homepage">Instructiones pro activar le version mobile de iste sito</a>', # Fuzzy
	'mobile-frontend-regular-site' => 'Vista normal',
	'mobile-frontend-wml-continue' => 'Continuar ...',
	'mobile-frontend-wml-back' => 'Retornar…',
	'mobile-frontend-view' => 'Version mobile',
	'mobile-frontend-view-desktop' => 'Scriptorio',
	'mobile-frontend-view-mobile' => 'Mobile',
	'mobile-frontend-opt-in-explain' => 'Per participar in le beta-test, tu habera accesso a functionalitate experimental, incurrente le risco de incontrar defectos e problemas.',
	'mobile-frontend-images-status' => 'Imagines',
	'mobile-frontend-disable-images' => 'Disactivar imagines in sito mobile',
	'mobile-frontend-enable-images' => 'Activar imagines in sito mobile',
	'mobile-frontend-off' => 'INACTIVE',
	'mobile-frontend-on' => 'ACTIVE',
	'mobile-frontend-footer-contributors-text' => 'Articulo per <a href="$1">contributores</a> como tu', # Fuzzy
	'mobile-frontend-featured-article' => 'Le articulo del die',
	'mobile-frontend-news-items' => 'Actualitates',
	'mobile-frontend-leave-feedback-notice' => 'Tu commentario nos adjuta a meliorar tu experientia del sito mobile. Illo essera publicate in le pagina "$1", con tu nomine de usator, version de navigator e systema de operation. Per favor tenta eliger un linea de subjecto informative, p.ex. "Problema con le formatation de tabellas large". Le evalutation que tu invia es subjecte a nostre conditiones de uso.',
	'mobile-frontend-leave-feedback-warning' => 'Si tu non vole que tu information deveni public, per favor non include information personal in tu commentos.',
	'mobile-frontend-leave-feedback-subject' => 'Subjecto:',
	'mobile-frontend-leave-feedback-message' => 'Message:',
	'mobile-frontend-leave-feedback-submit' => 'Submitter opinion',
	'mobile-frontend-leave-feedback-link-text' => 'Commentario sur Mobile Frontend',
	'mobile-frontend-leave-feedback' => 'Evalutation sur le sito mobile',
	'mobile-frontend-leave-feedback-title' => 'Evalutation sur le sito mobile',
	'mobile-frontend-leave-feedback-technical-problem-section-header' => 'Problema technic',
	'mobile-frontend-leave-feedback-general-section-header' => 'General',
	'mobile-frontend-leave-feedback-article-feedback-section-header' => 'Evalutation de articulos',
	'mobile-frontend-leave-feedback-email-body' => 'Per favor scribe tu message supra iste linea.', # Fuzzy
	'mobile-frontend-leave-feedback-technical-link-text' => 'Problema technic',
	'mobile-frontend-leave-feedback-general-link-text' => 'Commentario general',
	'mobile-frontend-leave-feedback-article-personal-link-text' => 'A proposito de me, un persona, o un compania que io representa',
	'mobile-frontend-leave-feedback-article-factual-link-text' => 'A proposito de un error factual',
	'mobile-frontend-leave-feedback-article-other-link-text' => 'A proposito de un altere problema',
	'mobile-frontend-leave-feedback-form-subject-placeholder' => 'Subjecto del message',
	'mobile-frontend-leave-feedback-form-message-placeholder' => 'Scribe hic tu commento',
	'mobile-frontend-leave-feedback-page-title' => 'Evalutation sur le sito mobile',
	'mobile-frontend-leave-feedback-special-title' => 'Contactar nos',
	'mobile-frontend-feedback-no-subject' => '(sin subjecto)',
	'mobile-frontend-feedback-no-subject-field' => 'Per favor scribe un subjecto',
	'mobile-frontend-feedback-no-message' => 'Per favor entra un message hic',
	'mobile-frontend-feedback-edit-summary' => '$1 - automaticamente publicate usante le [[Special:MobileFeedback|instrumento de evalutation mobile]]',
	'mobile-frontend-leave-feedback-thanks' => 'Gratias pro tu commentario!',
	'mobile-frontend-leave-feedback-post-error' => 'Un error occurreva durante le tractamento de tu message. Per favor reproba plus tarde.',
	'mobile-frontend-language' => 'Lingua:',
	'mobile-frontend-language-header' => 'Iste articulo es disponibile in $1 {{PLURAL:$1|lingua|linguas}}', # Fuzzy
	'mobile-frontend-language-footer' => '{{SITENAME}} es disponibile in altere linguas.', # Fuzzy
	'mobile-frontend-language-site-choose' => 'Cercar lingua',
	'mobile-frontend-username' => 'Nomine de usator:',
	'mobile-frontend-password' => 'Contrasigno:',
	'mobile-frontend-login' => 'Aperir session',
	'mobile-frontend-placeholder' => 'Cercar in {{SITENAME}}',
	'mobile-frontend-search-help' => 'Scribe parolas a cercar hic supra e le titulos del articulos correspondente apparera hic.', # Fuzzy
	'mobile-frontend-dismiss-notification' => 'clauder iste notification',
	'mobile-frontend-clear-search' => 'Rader',
	'mobile-frontend-privacy-link-text' => 'Confidentialitate',
	'mobile-frontend-about-link-text' => 'A proposito',
	'mobile-frontend-footer-sitename' => '{{SITENAME}}',
	'mobile-frontend-footer-contact' => 'Contacto',
	'mobile-frontend-search-noresults' => 'Nulle titulo de articulo corresponde a tu recerca. Cambia le recerca, o preme le button de recerca de claviero pro cercar intra articulos.', # Fuzzy
	'mobile-frontend-main-menu-featured' => 'Eminente',
	'mobile-frontend-main-menu-nearby' => 'A proximitate',
	'mobile-frontend-main-menu-settings' => 'Configuration',
	'mobile-frontend-main-menu-settings-heading' => 'Configuration de sito mobile',
	'mobile-frontend-settings-site-header' => 'Linguas de {{SITENAME}}',
	'mobile-frontend-settings-site-description' => '{{SITENAME}} es disponibile in $1 {{PLURAL:$1|lingua|linguas}}. Tote le versiones disponibile es listate hic infra.',
	'mobile-frontend-main-menu-contact' => 'Contacto',
	'mobile-frontend-page-menu-contents' => 'contento',
	'mobile-frontend-page-menu-history' => 'Historia',
);

/** Indonesian (Bahasa Indonesia)
 * @author Aldnonymous
 * @author Anakmalaysia
 * @author Farras
 * @author Kenrick95
 */
$messages['id'] = array(
	'mobile-frontend-desc' => 'Mobile Frontend',
	'mobile-frontend-search-submit' => 'Cari',
	'mobile-frontend-home-button' => 'Utama',
	'mobile-frontend-logged-out' => 'Belum masuk log',
	'mobile-frontend-logged-in-homepage-notification' => 'Selamat datang, $1!',
	'mobile-frontend-logged-in-toast-notification' => 'Masuk log sebagai $1',
	'mobile-frontend-sign-up-heading' => 'Daftar',
	'mobile-frontend-sign-in-heading' => 'Masuk log',
	'mobile-frontend-sign-in-error-heading' => 'Ups!',
	'mobile-frontend-settings-beta' => 'Beta',
	'mobile-frontend-save-settings' => 'Simpan pengaturan',
	'mobile-frontend-random-button' => 'Sembarang',
	'mobile-frontend-ajax-random-question' => 'Baca halaman ini?',
	'mobile-frontend-ajax-random-yes' => 'Ya',
	'mobile-frontend-ajax-random-retry' => 'Coba lagi',
	'mobile-frontend-ajax-random-suggestions' => 'Saran lain:',
	'mobile-frontend-back-to-top-of-section' => 'Kembali Ke Bagian Sebelumnya',
	'mobile-frontend-close-section' => 'Tutup bagian ini',
	'mobile-frontend-show-button' => 'Tampilkan',
	'mobile-frontend-hide-button' => 'Sembunyikan',
	'mobile-frontend-regular-site' => 'Tampilan desktop',
	'mobile-frontend-wml-continue' => 'Lanjutkan...',
	'mobile-frontend-wml-back' => 'Kembali ...',
	'mobile-frontend-view' => 'Tampilan seluler',
	'mobile-frontend-view-desktop' => 'Komputer',
	'mobile-frontend-view-mobile' => 'Telepon Genggam',
	'mobile-frontend-opt-in-explain' => 'Dengan bergabung dengan beta, Anda akan mendapatkan akses ke fitur eksperimental, dengan risiko menemukan bug dan masalah.',
	'mobile-frontend-images-status' => 'Gambar',
	'mobile-frontend-disable-images' => 'Nonaktifkan gambar pada situs seluler',
	'mobile-frontend-enable-images' => 'Aktifkan gambar pada situs seluler',
	'mobile-frontend-missing-image' => 'Gambar',
	'mobile-frontend-off' => 'OFF',
	'mobile-frontend-on' => 'ON',
	'mobile-frontend-footer-contributors-text' => 'Artikel oleh <a href="$1">kontributor</a> seperti Anda', # Fuzzy
	'mobile-frontend-featured-article' => 'Artikel Pilihan Hari Ini',
	'mobile-frontend-news-items' => 'Peristiwa Terkini',
	'mobile-frontend-leave-feedback-notice' => 'Umpan balik Anda membantu kami meningkatkan pengalaman situs seluler Anda. Hal ini akan dipublikasi (bersama nama pengguna, versi peramban web, dan sistem operasi Anda) ke halaman &quot;$1&quot;. Silakan coba memilik baris subjek yang inofatif, contohnya "Masalah pemformatan dengan tabel yang lebar." Umpan balik Anda tuduk pada syarat penggunaan kami.',
	'mobile-frontend-leave-feedback-warning' => 'Mohon untuk tidak memasukkan informasi pribadi ke komentar Anda, kecuali Anda ingin informasi Anda disebarluaskan.',
	'mobile-frontend-leave-feedback-subject' => 'Subyek:',
	'mobile-frontend-leave-feedback-message' => 'Pesan:',
	'mobile-frontend-leave-feedback-submit' => 'Kirim Umpan Balik',
	'mobile-frontend-leave-feedback-link-text' => 'Umpan Balik Ekstensi MobileFrontend',
	'mobile-frontend-leave-feedback' => 'Umpan balik situs seluler',
	'mobile-frontend-leave-feedback-title' => 'Beri kami umpan balik tentang pengalaman Anda di situs seluler',
	'mobile-frontend-leave-feedback-technical-problem-section-header' => 'Masalah teknis',
	'mobile-frontend-leave-feedback-general-section-header' => 'Umum',
	'mobile-frontend-leave-feedback-article-feedback-section-header' => 'Umpan balik artikel',
	'mobile-frontend-leave-feedback-email-body' => 'Silakan tulis surel Anda di atas garis ini.', # Fuzzy
	'mobile-frontend-leave-feedback-technical-link-text' => 'Masalah teknis',
	'mobile-frontend-leave-feedback-general-link-text' => 'Umpan balik umum',
	'mobile-frontend-leave-feedback-article-personal-link-text' => 'Tentang saya, seseorang, atau perusahaan yang saya wakili',
	'mobile-frontend-leave-feedback-article-factual-link-text' => 'Tentang kesalahan faktual',
	'mobile-frontend-leave-feedback-article-other-link-text' => 'Tentang masalah lain',
	'mobile-frontend-leave-feedback-form-subject-placeholder' => 'Judul pesan',
	'mobile-frontend-leave-feedback-form-message-placeholder' => 'Masukkan komentar Anda di sini',
	'mobile-frontend-leave-feedback-page-title' => 'Beri kami umpan balik tentang pengalaman Anda di situs seluler',
	'mobile-frontend-leave-feedback-special-title' => 'Hubungi kami',
	'mobile-frontend-feedback-no-subject' => '(tidak ada judul)',
	'mobile-frontend-feedback-no-subject-field' => 'Masukkan judul',
	'mobile-frontend-feedback-no-message' => 'Masukkan pesan di sini',
	'mobile-frontend-feedback-edit-summary' => '$1 - diposkan secara otomatis melalui [[Special:MobileFeedback|alat umpan balik bergerak]]',
	'mobile-frontend-leave-feedback-thanks' => 'Terima kasih, atas umpan balik Anda!',
	'mobile-frontend-leave-feedback-post-error' => 'Terjadi kesalahan dalam pemrosesan pesan Anda, Silakan coba lagi nanti.',
	'mobile-frontend-language' => 'Bahasa:',
	'mobile-frontend-language-article-heading' => 'Baca dalam bahasa lain',
	'mobile-frontend-language-header' => 'Artikel ini tersedia dalam $1 {{PLURAL:$1|bahasa|bahasa}}', # Fuzzy
	'mobile-frontend-language-variant-header' => 'Pilih varian {{#language:{{CONTENTLANG}}}}',
	'mobile-frontend-language-footer' => '{{SITENAME}} tersedia dalam bahasa lain.', # Fuzzy
	'mobile-frontend-language-site-choose' => 'Cari bahasa',
	'mobile-frontend-username' => 'Nama pengguna:',
	'mobile-frontend-password' => 'Kata sandi:',
	'mobile-frontend-username-placeholder' => 'Nama pengguna',
	'mobile-frontend-password-placeholder' => 'Sandi',
	'mobile-frontend-login' => 'Masuk log',
	'mobile-frontend-account-create-submit' => 'Daftar',
	'mobile-frontend-password-confirm-placeholder' => 'Konfirmasi sandi',
	'mobile-frontend-account-create-email-placeholder' => 'Alamat surel (opsional)',
	'mobile-frontend-account-create-captcha-placeholder' => 'Masukkan teks keamanan',
	'mobile-frontend-overlay-escape' => 'Kembali',
	'mobile-frontend-placeholder' => 'Cari {{SITENAME}}',
	'mobile-frontend-placeholder-beta' => 'Cari {{SITENAME}} (Beta)',
	'mobile-frontend-placeholder-alpha' => 'Cari {{SITENAME}} (Dragon Mode)',
	'mobile-frontend-search-help' => 'Masukkan kueri pencarian di atas dan judul artikel yang sesuai akan muncul di sini.', # Fuzzy
	'mobile-frontend-dismiss-notification' => 'tutup pemberitahuan ini',
	'mobile-frontend-clear-search' => 'Kosongkan',
	'mobile-frontend-privacy-link-text' => 'Privasi',
	'mobile-frontend-about-link-text' => 'Tentang',
	'mobile-frontend-footer-sitename' => '{{SITENAME}}',
	'mobile-frontend-footer-contact' => 'Kontak',
	'mobile-frontend-search-noresults' => 'Tidak ada judul artikel yang cocok dengan pencarian Anda. Ubah pencarian Anda, atau tekan tombol pencarian keyboard untuk mencari dalam artikel.', # Fuzzy
	'mobile-frontend-main-menu-button-tooltip' => 'Buka menu utama',
	'mobile-frontend-main-menu-page-title' => 'Navigasi situs',
	'mobile-frontend-main-menu-featured' => 'Terpilih',
	'mobile-frontend-main-menu-nearby' => 'Terdekat',
	'mobile-frontend-main-menu-login' => 'Masuk log',
	'mobile-frontend-main-menu-logout' => 'Keluar log',
	'mobile-frontend-main-menu-watchlist' => 'Daftar pantauan',
	'mobile-frontend-main-menu-settings' => 'Pengaturan',
	'mobile-frontend-main-menu-settings-heading' => 'Pengaturan situs telepon genggam',
	'mobile-frontend-settings-site-header' => 'Bahasa {{SITENAME}}',
	'mobile-frontend-settings-site-description' => '{{SITENAME}} tersedia dalam $1 {{PLURAL:$1|bahasa|bahasa}}. Semua versi yang tersedia disebutkan di bawah',
	'mobile-frontend-main-menu-contact' => 'Kontak',
	'mobile-frontend-main-menu-account-create' => 'Buat akun',
	'mobile-frontend-page-menu-contents' => 'isi',
	'mobile-frontend-page-menu-history' => 'Versi terdahulu',
	'mobile-frontend-meta-data-issues-header' => 'Masalah',
	'mobile-frontend-meta-data-issues' => 'Halaman ini memiliki beberapa masalah',
	'mobile-frontend-ajax-page-loading' => 'Memuat $1',
	'mobile-frontend-page-saving' => 'Menyimpan $1',
	'mobile-frontend-ajax-page-error' => 'Ups! Ada yang tidak beres. Coba muat ulang jendela peramban Anda.',
	'mobile-frontend-photo-upload-generic' => 'Sumbang gambar',
	'mobile-frontend-donate-image-title' => 'Sumbang gambar',
	'mobile-frontend-donate-image-heading' => 'Kontribusi terkini Anda',
	'mobile-frontend-watchlist-a-z' => 'Halaman yang dipantau', # Fuzzy
	'mobile-frontend-watchlist-feed' => 'Halaman dengan perubahan', # Fuzzy
	'mobile-frontend-changeslist-ip' => 'Pengguna anonim',
	'mobile-frontend-changeslist-nocomment' => 'tidak ada ringkasan suntingan',
	'mobile-frontend-watchlist-filter-all' => 'Semua',
	'mobile-frontend-watchlist-filter-articles' => 'Artikel',
	'mobile-frontend-watchlist-filter-talk' => 'Bicara',
	'mobile-frontend-watchlist-filter-other' => 'Lainnya',
	'mobile-frontend-diffview-editcount' => '$1 {{PLURAL:$1|suntingan|suntingan}}',
	'mobile-frontend-diffview-anonymous' => 'Pengguna anonim',
	'mobile-frontend-table' => 'Tabel $1',
	'mobile-frontend-photo-upload-comment' => 'Menambahkan foto ke halaman',
	'mobile-frontend-image-loading' => 'Memuat gambar',
	'mobile-frontend-image-uploading-wait' => 'Mengunggah gambar', # Fuzzy
);

/** Igbo (Igbo)
 * @author Ukabia
 */
$messages['ig'] = array(
	'mobile-frontend-show-button' => 'Zi',
	'mobile-frontend-hide-button' => 'Zonari',
);

/** Iloko (Ilokano)
 * @author Lam-ang
 */
$messages['ilo'] = array(
	'mobile-frontend-desc' => 'Nakuti a Sanguan',
	'mobile-frontend-search-submit' => 'Inkan',
	'mobile-frontend-home-button' => 'Balay',
	'mobile-frontend-logged-out' => 'Saan a nakastrek',
	'mobile-frontend-random-button' => 'Pugto',
	'mobile-frontend-back-to-top-of-section' => 'Agsubli idiay maysa a paset',
	'mobile-frontend-close-section' => 'Irikep daytoy a paset',
	'mobile-frontend-show-button' => 'Ipakita',
	'mobile-frontend-hide-button' => 'Ilemmeng',
	'mobile-frontend-empty-homepage-text' => 'Daytoy balay a panid ket nasken a maparnuay. <a href="http://meta.wikimedia.org/wiki/Mobile_Projects/Mobile_Gateway#Mobile_homepage">Agbasa pay ti adu ditoy</a>', # Fuzzy
	'mobile-frontend-regular-site' => 'Desktop a panagkita',
	'mobile-frontend-wml-continue' => 'Agtuloy...',
	'mobile-frontend-wml-back' => 'Agsubli...',
	'mobile-frontend-view' => 'Nakuti a panagkita',
	'mobile-frontend-opt-in-explain' => 'Babaen ti makitipon ti beta, makaserrek ka kadagiti subsubokan a langa, nga addaan ti peggad a makasarak ka kadagiti kiteb ken parikut.',
	'mobile-frontend-images-status' => 'Dagiti imahen',
	'mobile-frontend-disable-images' => 'Ibaldado dagiti imahen idiay nakuti a pagsaadan',
	'mobile-frontend-enable-images' => 'Pakabaelan dagiti imahen idiay nakuti a pagsaadan',
	'mobile-frontend-featured-article' => 'Ti Nailasin nga Artikulo iti daytoy nga Aldaw',
	'mobile-frontend-news-items' => 'Damdamag',
	'mobile-frontend-leave-feedback-notice' => 'Ti pangipagarupam ket makatulong kadakami nga agpasayaat ti panagpadas mo ti nakuti a pagsaadan. Daytoy ket maipablaak iti publiko (mairaman ti naganmo nga agar-aramat ken ti pagpaandar ti sistema)  idiay panid &quot;$1&quot;.
Pangngaasi a padasen ti agpili iti pakaammo a gandat a linia, a kasla daytoy. "Kinabuklan a parikut nga addaan dagiti nalawa a tabla". Ti pangipagarupam ket suheto kadagiti bagi mi a sakup ti pinagusar.',
	'mobile-frontend-leave-feedback-subject' => 'Suheto:',
	'mobile-frontend-leave-feedback-message' => 'Mensahe:',
	'mobile-frontend-leave-feedback-submit' => 'Agited ti Pagipagarupan',
	'mobile-frontend-leave-feedback-link-text' => 'Pangipagarupan ti Nakuti a Sanguan a Pagpa-atiddog',
	'mobile-frontend-leave-feedback' => 'Pangipagarupan ti nakuti a pagsaadan',
	'mobile-frontend-leave-feedback-title' => 'Ikkan dakami ti pangipagarupan maipanggep ti panagpadas mo ti nakuti a pagsaadan',
	'mobile-frontend-leave-feedback-page-title' => 'Ikkan dakami ti pangipagarupan maipanggep ti panagpadas mo ti nakuti a pagsaadan',
	'mobile-frontend-leave-feedback-thanks' => 'Agyama kami, kadagiti pangipagarupam!',
	'mobile-frontend-language' => 'Pagsasao:',
	'mobile-frontend-username' => 'Nagan ti agar-aramat:',
	'mobile-frontend-password' => 'Kontrasenias:',
	'mobile-frontend-login' => 'Sumrek',
	'mobile-frontend-placeholder' => 'Imakinilia dagiti birukem ditoy...', # Fuzzy
	'mobile-frontend-dismiss-notification' => 'pugsayen daytoy a paammo',
	'mobile-frontend-clear-search' => 'Dalusan',
	'mobile-frontend-privacy-link-text' => 'Panaka-pribado',
	'mobile-frontend-about-link-text' => 'Maipanggep',
	'mobile-frontend-footer-sitename' => '{{SITENAME}}',
	'mobile-frontend-footer-contact' => 'Pagdamagan',
);

/** Ingush (ГӀалгӀай)
 * @author Amire80
 */
$messages['inh'] = array(
	'mobile-frontend-search-submit' => 'Дехьавала/яла',
	'mobile-frontend-home-button' => 'ЦӀенга',
	'mobile-frontend-show-button' => 'Хьахокха',
	'mobile-frontend-hide-button' => 'Къайладаккха',
	'mobile-frontend-regular-site' => 'Ер оагӀув Вкипадечу хьажа', # Fuzzy
	'mobile-frontend-featured-article' => 'Укх ден хьаржа йоазув',
);

/** Icelandic (íslenska)
 * @author Bjarki S
 * @author Maxí
 * @author Snævar
 */
$messages['is'] = array(
	'mobile-frontend-search-submit' => 'Áfram',
	'mobile-frontend-home-button' => 'Forsíða',
	'mobile-frontend-logged-out' => 'Ekki innskráð(ur)',
	'mobile-frontend-logged-in-homepage-notification' => 'Velkomin(n), $1!',
	'mobile-frontend-logged-in-toast-notification' => 'Skráð/ur inn sem $1.',
	'mobile-frontend-sign-up-heading' => 'Nýskráning',
	'mobile-frontend-sign-in-heading' => 'Innskrá',
	'mobile-frontend-sign-in-why' => 'Ef þú átt {{SITENAME}} aðgang, þá getur þú skráð þig inn hér fyrir neðan.',
	'mobile-frontend-sign-in-error-heading' => 'Úps',
	'mobile-frontend-settings-beta' => 'Prufuútgáfa',
	'mobile-frontend-save-settings' => 'Vista stillingar',
	'mobile-frontend-random-button' => 'Handahófsvalið',
	'mobile-frontend-ajax-random-heading' => 'Staðset þekkingu...',
	'mobile-frontend-ajax-random-quote' => 'Vitsunalegur þroski ætti að hefjast við fæðingu og hætta eingöngu við dauða',
	'mobile-frontend-ajax-random-question' => 'Lesa þessa síðu?',
	'mobile-frontend-ajax-random-yes' => 'Já',
	'mobile-frontend-ajax-random-retry' => 'Reyna aftur',
	'mobile-frontend-ajax-random-suggestions' => 'Aðrar uppástungur',
	'mobile-frontend-back-to-top-of-section' => 'Fara til baka',
	'mobile-frontend-close-section' => 'Loka þessum hluta',
	'mobile-frontend-show-button' => 'Sýna',
	'mobile-frontend-hide-button' => 'Fela',
	'mobile-frontend-empty-homepage-text' => 'Það þarf að setja upp þessa heimasíðu. [//meta.wikimedia.org/wiki/Mobile_Projects/Mobile_Gateway#Mobile_homepage Leiðbeiningar um hvernig á að fara að]',
	'mobile-frontend-regular-site' => 'Skoða aðalvef',
	'mobile-frontend-wml-continue' => 'Áfram…',
	'mobile-frontend-wml-back' => 'Til baka…',
	'mobile-frontend-view' => 'Farsímaútgáfa',
	'mobile-frontend-view-desktop' => 'Einkatölvu útgáfa',
	'mobile-frontend-view-mobile' => 'Farsímaútgáfa',
	'mobile-frontend-opt-in-explain' => 'Með því að taka þátt í beta prófun, munt þú fá aðgang að tilrauna möguleikum sem hafa mögulegar villur eða vandamál.',
	'mobile-frontend-images-status' => 'Myndir',
	'mobile-frontend-disable-images' => 'Fela myndir á farsímasíðunni',
	'mobile-frontend-enable-images' => 'Sýna myndir á farsímasíðunni',
	'mobile-frontend-missing-image' => 'Mynd',
	'mobile-frontend-off' => 'AF',
	'mobile-frontend-on' => 'Á',
	'mobile-frontend-footer-contributors-text' => 'Grein eftir [$1 notendur] eins og þig',
	'mobile-frontend-featured-article' => 'Grein mánaðarins',
	'mobile-frontend-news-items' => 'Í fréttum',
	'mobile-frontend-leave-feedback-notice' => 'Svörun þín hjálpar okkur að bæta farsímaútgáfuna. Henni verður bætt við síðuna &quot;$1&quot; ásamt notendanafni og heiti vafrans sem þú ert að nota. Vinsamlegast notaðu lýsandi titil, t.d. "Útlitsgalli með breiðar töflur". Svörunin þín fellur undir notkunarskilmálana okkar.',
	'mobile-frontend-leave-feedback-warning' => 'Eingöngu skal tilgreina persónulegar upplýsingar ef þú vilt gera þær aðgengilegar.',
	'mobile-frontend-leave-feedback-subject' => 'Fyrirsögn:',
	'mobile-frontend-leave-feedback-message' => 'Skilaboð:',
	'mobile-frontend-leave-feedback-submit' => 'Senda svörun',
	'mobile-frontend-leave-feedback-link-text' => 'Skilja eftir svörun um MobileFrontend viðbótina',
	'mobile-frontend-leave-feedback' => 'Skilja eftir svörun um farsímaútgáfu',
	'mobile-frontend-leave-feedback-title' => 'Skilja eftir svörun um farsímaútgáfuna',
	'mobile-frontend-leave-feedback-technical-problem-section-header' => 'Tæknileg villa',
	'mobile-frontend-leave-feedback-general-section-header' => 'Almennt',
	'mobile-frontend-leave-feedback-article-feedback-section-header' => 'Svörun um grein',
	'mobile-frontend-leave-feedback-email-body' => 'Vinsamlegast lýstu vandamálinu á {{SITENAME}} fyrir ofan þessara línu. Athugaðu að við getum ekki svarað öllum skilaboðum sem við fáum.',
	'mobile-frontend-leave-feedback-technical-link-text' => 'Tæknileg villa',
	'mobile-frontend-leave-feedback-general-link-text' => 'Almenn svörun',
	'mobile-frontend-leave-feedback-article-personal-link-text' => 'Varðandi mig, persónu eða fyrirtæki sem ég er fulltrúi fyrir',
	'mobile-frontend-leave-feedback-article-factual-link-text' => 'Varðandi staðreyndarvillu',
	'mobile-frontend-leave-feedback-article-other-link-text' => 'Varðandi annað vandamál',
	'mobile-frontend-leave-feedback-form-subject-placeholder' => 'Efni skilaboða',
	'mobile-frontend-leave-feedback-form-message-placeholder' => 'Skrifaðu skilaboðin þín hér',
	'mobile-frontend-leave-feedback-page-title' => 'Skilja eftir svörun um farsímaútgáfuna',
	'mobile-frontend-leave-feedback-special-title' => 'Hafa samband',
	'mobile-frontend-feedback-no-subject' => '(engin fyrirsögn)',
	'mobile-frontend-feedback-no-subject-field' => 'Vinsamlegast sláðu inn fyrirsögn',
	'mobile-frontend-feedback-no-message' => 'Vinsamlegast sláðu inn skilaboð hingað',
	'mobile-frontend-feedback-edit-summary' => '$1 - sent sjálfvirkt með [[Special:MobileFeedback|farsíma svörunar smáforritinu]]',
	'mobile-frontend-leave-feedback-thanks' => 'Takk fyrir svörunina!',
	'mobile-frontend-leave-feedback-post-error' => 'Mistókst að bæta við svörun þinni. Vinsamlegast reyndu aftur síðar.',
	'mobile-frontend-language' => 'Tungumál:',
	'mobile-frontend-language-article-heading' => 'Lesa á öðru tungumáli',
	'mobile-frontend-language-header' => 'Þessi síða er aðgengileg á $1 {{PLURAL:$1|tungumáli|tungumálum}}.',
	'mobile-frontend-language-footer' => 'Athugið: Þessi síða er kanski ekki skrifuð á þínu tungumáli. Þú getur séð hvaða tungumál {{SITENAME}} styður með því að smella hér.',
	'mobile-frontend-language-site-choose' => 'Leita að tungumáli',
	'mobile-frontend-username' => 'Notandanafn:',
	'mobile-frontend-password' => 'Lykilorð:',
	'mobile-frontend-username-placeholder' => 'Notandanafn',
	'mobile-frontend-password-placeholder' => 'Lykilorð',
	'mobile-frontend-login' => 'Innskrá',
	'mobile-frontend-last-modified-date' => 'Síðast breytt $1, kl. $2',
	'mobile-frontend-last-modified-seconds' => 'Síðast breytt fyrir {{PLURAL:$1|$1 sekúndu|$1 sekúndum}} síðan',
	'mobile-frontend-last-modified-minutes' => 'Síðast breytt fyrir {{PLURAL:$1|$1 mínútu|$1 mínútum}} síðan',
	'mobile-frontend-last-modified-hours' => 'Síðast breytt fyrir {{PLURAL:$1|$1 klukkutíma|$1 klukkutímum}} síðan',
	'mobile-frontend-last-modified-days' => 'Síðast breytt {{PLURAL:$1|í gær|fyrir $1 dögum síðan}}',
	'mobile-frontend-last-modified-months' => 'Síðast breytt fyrir {{PLURAL:$1|$1 mánuði|$1 mánuðum}} síðan',
	'mobile-frontend-last-modified-years' => 'Síðast breytt fyrir {{PLURAL:$1|$1 ári|$1 árum}} síðan',
	'mobile-frontend-account-create-submit' => 'Nýskrá',
	'mobile-frontend-password-confirm-placeholder' => 'Staðfestu lykilorð',
	'mobile-frontend-account-create-email-placeholder' => 'Netfang (valfrjálst)',
	'mobile-frontend-account-create-captcha-placeholder' => 'Sláðu inn öryggis texta',
	'mobile-frontend-overlay-escape' => 'Til baka',
	'mobile-frontend-placeholder' => 'Leita á {{SITENAME}}',
	'mobile-frontend-placeholder-beta' => 'Leita á {{SITENAME}} (Prufuútgáfa)',
	'mobile-frontend-search-help' => 'Sláðu inn leitarorð hér fyrir ofan og leitarniðurstöður birtast hér.',
	'mobile-frontend-dismiss-notification' => 'sleppa þessari áminningu',
	'mobile-frontend-clear-search' => 'Hreinsa',
	'mobile-frontend-privacy-link-text' => 'Persónuvernd',
	'mobile-frontend-about-link-text' => 'Um',
	'mobile-frontend-footer-sitename' => '{{SITENAME}}',
	'mobile-frontend-footer-license-text' => 'Textinn er laus undir [//en.m.wikipedia.org/wiki/Wikipedia:Text_of_Creative_Commons_Attribution-ShareAlike_3.0_Unported_License?useformat=mobile CC BY-SA 3.0 leyfi]',
	'mobile-frontend-terms-use-text' => '[//meta.wikimedia.org/wiki/Terms_of_use-Summary/is?useformat=mobile Notkunarskilmálar]',
	'mobile-frontend-footer-contact' => 'Hafa samband',
	'mobile-frontend-search-noresults' => 'Engin síða með þessum titli fannst. Breyttu leitarorðinu, eða ýttu á leitartakkann á lyklaborðinu til þess að leita inní síðum.',
	'mobile-frontend-main-menu-button-tooltip' => 'Opna aðalvalmynd',
	'mobile-frontend-main-menu-featured' => 'Gæða',
	'mobile-frontend-main-menu-nearby' => 'Nálægt',
	'mobile-frontend-main-menu-login' => 'Innskrá',
	'mobile-frontend-main-menu-logout' => 'Útskrá',
	'mobile-frontend-main-menu-watchlist' => 'Vaktlisti',
	'mobile-frontend-main-menu-settings' => 'Stillingar',
	'mobile-frontend-main-menu-upload' => 'Upphöl',
	'mobile-frontend-main-menu-settings-heading' => 'Stillingar farsímaútgáfunnar',
	'mobile-frontend-settings-site-header' => '{{SITENAME}} tungumál',
	'mobile-frontend-settings-site-description' => '{{SITENAME}} er aðgengilegt á $1 {{PLURAL:$1|tungumáli|tungumálum}}. Allar aðgengilegar útgáfur eru skráðar hér fyrir neðan',
	'mobile-frontend-main-menu-contact' => 'Hafa samband',
	'mobile-frontend-main-menu-account-create' => 'Nýskrá',
	'mobile-frontend-page-menu-contents' => 'efnisyfirlit',
	'mobile-frontend-page-menu-history' => 'Breytingaskrá',
	'mobile-frontend-meta-data-issues-header' => 'Vandamál',
	'mobile-frontend-meta-data-issues' => 'Nokkur vandamál hrjá þessa síðu',
	'mobile-frontend-ajax-page-loading' => 'Hleð $1',
	'mobile-frontend-page-saving' => 'Vista $1',
	'mobile-frontend-ajax-page-error' => 'Úps! Eitthvað fór úrskeiðis. Vinsamlegast endurhladdu síðunni.',
	'mobile-frontend-nearby-title' => 'Nálægt',
	'mobile-frontend-photo-upload-generic' => 'Gefa mynd',
	'mobile-frontend-donate-image-title' => 'Gefa mynd',
	'mobile-frontend-donate-image-heading' => 'Nýjustu breytingarnar þínar',
	'mobile-frontend-watchlist-add' => '$1 bætt við vaktlistann þinn',
	'mobile-frontend-watchlist-removed' => '$1 fjarlægð úr vaktlistanum þínum',
	'mobile-frontend-watchlist-view' => 'Skoða vaktlistann þinn',
	'mobile-frontend-watchlist-cta' => 'Vinsamlegast innskráðu þig til að fylgjast með þessari síðu.',
	'mobile-frontend-watchlist-cta-button-login' => 'Innskrá',
	'mobile-frontend-watchlist-cta-button-signup' => 'Nýskrá',
	'mobile-frontend-watchlist-a-z' => 'Allt',
	'mobile-frontend-watchlist-feed' => 'Breytt',
	'mobile-frontend-watchlist-a-z-empty' => 'Þú ert ekki að fylgjast með neinum síðum',
	'mobile-frontend-watchlist-a-z-empty-howto' => 'Fylgstu með síðu sem þér finnst áhugaverð með því að smella á stjörnuna efst á skjánum. Þetta leyfir þér að bókarmerkja síður sem þú hefur áhuga á og sjá hvenær þeim er breytt.',
	'mobile-frontend-watchlist-feed-empty' => 'Engar síður með nýlegar breytingar',
	'mobile-frontend-changeslist-ip' => 'Óskráður notandi',
	'mobile-frontend-changeslist-nocomment' => 'ekkert breytingarágrip',
	'mobile-frontend-watchlist-filter-all' => 'Allar',
	'mobile-frontend-watchlist-filter-articles' => 'Greinar',
	'mobile-frontend-watchlist-filter-talk' => 'Spjallsíður',
	'mobile-frontend-watchlist-filter-other' => 'Aðrar',
	'mobile-frontend-watchlist-modified' => 'Breytt fyrir $1',
	'mobile-frontend-diffview-editcount' => '$1 {{PLURAL:$1|breyting|breytingar}}',
	'mobile-frontend-diffview-anonymous' => 'Óskráður notandi',
	'mobile-frontend-diffview-bytesadded' => '$1 {{PLURAL:$1|bæti|bætum}} bætt við',
	'mobile-frontend-diffview-bytesremoved' => '$1 {{PLURAL:$1|bæti fjarlægt|bæti fjarlægð}}',
	'mobile-frontend-diffview-explained' => 'Eftirfarandi línum var bætt við (+) og fjarlægðar (-):',
	'mobile-frontend-table' => 'Tafla $1',
	'mobile-frontend-saving-exit-page' => 'Breytingin þín er ennþá að vistast. Ef þú ferð þá tapast breytingin þín. Ertu viss um að þú viljir hætta?',
	'mobile-frontend-photo-upload' => 'Bæta fyrstu myndinni við þessa síðu', # Fuzzy
	'mobile-frontend-photo-article-edit-comment' => 'Bætti við mynd fyrir notkun á síðu',
	'mobile-frontend-photo-article-donate-comment' => 'Gaf mynd frá farsíma',
	'mobile-frontend-photo-upload-comment' => 'Bætti við mynd á síðu',
	'mobile-frontend-photo-caption-placeholder' => 'Bæta við myndaheiti fyrir þessa mynd', # Fuzzy
	'mobile-frontend-image-loading' => 'Hleð mynd',
	'mobile-frontend-image-uploading-wait' => 'Hleð inn mynd', # Fuzzy
	'mobile-frontend-image-uploading-long' => 'Myndin er enn að hlaðast inn! Takk fyrir þolinmæðina.',
	'mobile-frontend-image-uploading-cancel' => '<a href="#">Hætta við</a> ef þetta tekur of langan tíma.',
	'mobile-frontend-photo-upload-error' => 'Villa, reyndu aftur.',
	'mobile-frontend-photo-license' => 'Athugið: Allar myndir sem þú gefur út verða undir [//en.wikipedia.org/wiki/Wikipedia:Text_of_Creative_Commons_Attribution-ShareAlike_3.0_Unported_License?useformat=mobile CC BY-SA 3.0 leyfi]', # Fuzzy
	'mobile-frontend-photo-submit' => 'Senda',
	'mobile-frontend-photo-cancel' => 'Hætta við',
	'tag-mobile_edit' => 'Farsíma breyting',
	'tag-mobile_edit-description' => 'Breyting gerð frá farsímasíðu',
	'mobile-frontend-drawer-cancel' => 'Hætta við',
);

/** Italian (italiano)
 * @author Aushulz
 * @author Beta16
 * @author Nemo bis
 * @author Raoli
 * @author Ximo17
 */
$messages['it'] = array(
	'mobile-frontend-desc' => 'Interfaccia mobile',
	'mobile-frontend-search-submit' => 'Vai',
	'mobile-frontend-home-button' => 'Pagina principale',
	'mobile-frontend-logged-out' => 'Accesso non effettuato',
	'mobile-frontend-logged-in-homepage-notification' => 'Benvenuto, $1!',
	'mobile-frontend-logged-in-toast-notification' => 'Accesso effettuato come $1.',
	'mobile-frontend-sign-up-heading' => 'Registrati',
	'mobile-frontend-sign-in-heading' => 'Accedi',
	'mobile-frontend-sign-in-why' => 'Se hai un account {{SITENAME}}, può accedere dal form sotto.',
	'mobile-frontend-sign-in-error-heading' => 'Oops!',
	'mobile-frontend-settings-description' => 'Personalizza la tua esperienza sul dispositivo mobile con le impostazioni specifiche per questa versione.',
	'mobile-frontend-settings-beta' => 'Beta',
	'mobile-frontend-save-settings' => 'Salva impostazioni',
	'mobile-frontend-random-button' => 'Una pagina a caso',
	'mobile-frontend-ajax-random-heading' => 'Individuazione delle conoscenze...',
	'mobile-frontend-ajax-random-quote' => 'La crescita intellettuale dovrebbe iniziare alla nascita e cessare solo alla morte',
	'mobile-frontend-ajax-random-question' => 'Vuoi leggere questa pagina?',
	'mobile-frontend-ajax-random-yes' => 'Sì',
	'mobile-frontend-ajax-random-retry' => 'Riprova',
	'mobile-frontend-ajax-random-suggestions' => 'Altri suggerimenti:',
	'mobile-frontend-back-to-top-of-section' => 'Vai a inizio sezione',
	'mobile-frontend-close-section' => 'Chiudi questa sezione',
	'mobile-frontend-show-button' => 'Mostra',
	'mobile-frontend-hide-button' => 'Nascondi',
	'mobile-frontend-empty-homepage-text' => 'Questa pagina principale deve essere configurata. [//meta.wikimedia.org/wiki/Mobile_Projects/Mobile_Gateway#Mobile_homepage Istruzioni su come abilitare questo sito per dispositivi mobili]',
	'mobile-frontend-regular-site' => 'Vista desktop',
	'mobile-frontend-wml-continue' => 'Continua ...',
	'mobile-frontend-wml-back' => 'Indietro ...',
	'mobile-frontend-view' => 'Versione mobile',
	'mobile-frontend-view-desktop' => 'Desktop',
	'mobile-frontend-view-mobile' => 'Cellulare',
	'mobile-frontend-opt-in-explain' => 'Partecipando alla versione di prova avrai la possibilità di usare funzionalità sperimentali, ma con il rischio di incontrare errori e problemi.',
	'mobile-frontend-images-status' => 'Immagini',
	'mobile-frontend-disable-images' => 'Disabilita le immagini sul sito per dispositivi mobili',
	'mobile-frontend-enable-images' => 'Abilita le immagini sul sito per dispositivi mobili',
	'mobile-frontend-missing-image' => 'Immagine',
	'mobile-frontend-off' => 'OFF',
	'mobile-frontend-on' => 'ON',
	'mobile-frontend-footer-contributors-text' => 'Pagina scritta da [$1 contributori] come te',
	'mobile-frontend-featured-article' => 'Vetrina',
	'mobile-frontend-news-items' => 'Novità',
	'mobile-frontend-leave-feedback-notice' => 'I tuoi commenti ci aiutano a migliorare la tua soddisfazione del sito per dispositivi mobili. Sarà pubblicata (insieme al tuo nome utente, versione del browser e sistema operativo) alla pagina "$1". Per favore, scegli un oggetto descrittivo (ad esempio, "Problemi di formattazione con tabelle larghe"). Il tuo commento è soggetto alle condizioni d\'uso.',
	'mobile-frontend-leave-feedback-warning' => "Se non sei d'accordo a rendere pubblici i tuoi dati, per favore non inserire informazioni personali nei tuoi commenti.",
	'mobile-frontend-leave-feedback-subject' => 'Oggetto:',
	'mobile-frontend-leave-feedback-message' => 'Messaggio:',
	'mobile-frontend-leave-feedback-submit' => 'Invia commento',
	'mobile-frontend-leave-feedback-link-text' => "Commenti sull'estensione interfaccia mobile",
	'mobile-frontend-leave-feedback' => 'Commenti sul sito per dispositivi mobili',
	'mobile-frontend-leave-feedback-title' => 'Commenti sul sito per dispositivi mobili',
	'mobile-frontend-leave-feedback-technical-problem-section-header' => 'Problema tecnico',
	'mobile-frontend-leave-feedback-general-section-header' => 'Generale',
	'mobile-frontend-leave-feedback-article-feedback-section-header' => 'Commenta una voce',
	'mobile-frontend-leave-feedback-email-body' => 'Descrivi il problema che hai riscontrato con {{SITENAME}} al di sopra di questa linea. Ci scusiamo in anticipo, ma purtroppo non riusciamo a rispondere ad ogni messaggio che riceviamo.',
	'mobile-frontend-leave-feedback-technical-link-text' => 'Problema tecnico',
	'mobile-frontend-leave-feedback-general-link-text' => 'Commento generale',
	'mobile-frontend-leave-feedback-article-personal-link-text' => "Che riguarda me, una persona o un'azienda che rappresento",
	'mobile-frontend-leave-feedback-article-factual-link-text' => 'Che riguarda un errore fattuale',
	'mobile-frontend-leave-feedback-article-other-link-text' => 'Che riguarda un altro problema',
	'mobile-frontend-leave-feedback-form-subject-placeholder' => 'Oggetto del messaggio',
	'mobile-frontend-leave-feedback-form-message-placeholder' => 'Scrivi qui il tuo commento',
	'mobile-frontend-leave-feedback-page-title' => 'Commenti sul sito per dispositivi mobili',
	'mobile-frontend-leave-feedback-special-title' => 'Contattaci',
	'mobile-frontend-feedback-no-subject' => '(nessun oggetto)',
	'mobile-frontend-feedback-no-subject-field' => 'Si prega di inserire un oggetto',
	'mobile-frontend-feedback-no-message' => 'Si prega di inserire un messaggio qui',
	'mobile-frontend-feedback-edit-summary' => '$1 - inviato automaticamente utilizzando lo [[Special:MobileFeedback|strumento mobile feedback]]',
	'mobile-frontend-leave-feedback-thanks' => 'Grazie per aver espresso il tuo commento.',
	'mobile-frontend-leave-feedback-post-error' => "Si è verificato un errore durante l'elaborazione del messaggio. Si prega di riprovare più tardi.",
	'mobile-frontend-language' => 'Lingua:',
	'mobile-frontend-language-article-heading' => "Leggi in un'altra lingua",
	'mobile-frontend-language-header' => 'Questa pagina è disponibile in $1 {{PLURAL:$1|lingua|lingue}}',
	'mobile-frontend-language-variant-header' => 'Scegli una variante {{#language:{{CONTENTLANG}}}}',
	'mobile-frontend-language-footer' => 'Nota: questa pagina potrebbe non essere scritta nella tua lingua preferita. Si possono vedere quali lingue sono supportate da {{SITENAME}} cliccando qui.',
	'mobile-frontend-language-site-choose' => 'Ricerca lingua',
	'mobile-frontend-username' => 'Nome utente:',
	'mobile-frontend-password' => 'Password:',
	'mobile-frontend-username-placeholder' => 'Nome utente',
	'mobile-frontend-password-placeholder' => 'Password',
	'mobile-frontend-login' => 'Entra',
	'mobile-frontend-last-modified-date' => 'Ultima modifica il $1 alle $2',
	'mobile-frontend-last-modified-seconds' => 'Ultima modifica {{PLURAL:$1|$1 secondo|$1 secondi}} fa',
	'mobile-frontend-last-modified-minutes' => 'Ultima modifica {{PLURAL:$1|$1 minuto|$1 minuti}} fa',
	'mobile-frontend-last-modified-hours' => 'Ultima modifica {{PLURAL:$1|$1 ora|$1 ore}} fa',
	'mobile-frontend-last-modified-days' => 'Ultima modifica {{PLURAL:$1|$1 giorno|$1 giorni}} fa',
	'mobile-frontend-last-modified-months' => 'Ultima modifica {{PLURAL:$1|$1 mese|$1 mesi}} fa',
	'mobile-frontend-last-modified-years' => 'Ultima modifica {{PLURAL:$1|$1 anno|$1 anni}} fa',
	'mobile-frontend-account-create-submit' => 'Registrati',
	'mobile-frontend-password-confirm-placeholder' => 'Conferma password',
	'mobile-frontend-account-create-email-placeholder' => 'Indirizzo di posta elettronica (opzionale)',
	'mobile-frontend-account-create-captcha-placeholder' => 'Inserire il testo di sicurezza',
	'mobile-frontend-overlay-escape' => 'Indietro',
	'mobile-frontend-placeholder' => "Cerca all'interno di {{SITENAME}}",
	'mobile-frontend-placeholder-beta' => 'Ricerca su {{SITENAME}} (Beta)',
	'mobile-frontend-placeholder-alpha' => 'Cerca su {{SITENAME}} (Dragon Mode)',
	'mobile-frontend-search-help' => 'Digita le parole da ricercare ed i titoli delle pagine trovate appariranno qui.',
	'mobile-frontend-dismiss-notification' => 'ignora questa notifica',
	'mobile-frontend-clear-search' => 'Pulisci',
	'mobile-frontend-privacy-link-text' => 'Privacy',
	'mobile-frontend-about-link-text' => 'Informazioni',
	'mobile-frontend-footer-sitename' => '{{SITENAME}}',
	'mobile-frontend-footer-license-text' => 'Contenuti disponibili secondo la licenza [//en.m.wikipedia.org/wiki/Wikipedia:Text_of_Creative_Commons_Attribution-ShareAlike_3.0_Unported_License?useformat=mobile CC BY-SA 3.0]',
	'mobile-frontend-terms-use-text' => "[//wikimediafoundation.org/wiki/Terms_of_use?useformat=mobile Condizioni d'uso]",
	'mobile-frontend-footer-contact' => 'Contatti',
	'mobile-frontend-search-noresults' => 'Nessuna pagina ha un titolo che corrisponde alla tua ricerca. Modifica la tua ricerca, oppure premi il pulsante della tastiera "Cerca" per la ricerca nel testo delle pagine.',
	'mobile-frontend-main-menu-button-tooltip' => 'Apri il menu principale',
	'mobile-frontend-main-menu-page-title' => 'Navigazione sul sito',
	'mobile-frontend-main-menu-featured' => 'In primo piano',
	'mobile-frontend-main-menu-nearby' => 'Nelle vicinanze',
	'mobile-frontend-main-menu-login' => 'Entra',
	'mobile-frontend-main-menu-logout' => 'Esci',
	'mobile-frontend-main-menu-watchlist' => 'Osservati speciali',
	'mobile-frontend-main-menu-settings' => 'Impostazioni',
	'mobile-frontend-main-menu-upload' => 'Carica', # Fuzzy
	'mobile-frontend-main-menu-settings-heading' => 'Impostazioni del sito per cellulari',
	'mobile-frontend-settings-site-header' => 'Lingue {{SITENAME}}',
	'mobile-frontend-settings-site-description' => '{{SITENAME}} è disponibile in $1 {{PLURAL:$1|lingua|lingue}}. Tutte le versioni disponibili sono elencate di seguito',
	'mobile-frontend-main-menu-contact' => 'Contatto',
	'mobile-frontend-main-menu-account-create' => 'Registrati',
	'mobile-frontend-page-menu-contents' => 'contenuti',
	'mobile-frontend-page-menu-history' => 'Cronologia',
	'mobile-frontend-meta-data-issues-header' => 'Anomalie',
	'mobile-frontend-meta-data-issues' => 'Questa pagina ha alcuni problemi',
	'mobile-frontend-ajax-page-loading' => 'Sto caricando $1',
	'mobile-frontend-page-saving' => 'Sto salvando $1',
	'mobile-frontend-ajax-page-error' => 'Oops! Qualcosa è andato storto. Prova ad aggiornare la finestra del browser.',
	'mobile-frontend-nearby-title' => 'Nelle vicinanze',
	'mobile-frontend-nearby-loading' => 'Carico gli argomenti vicini alla tua posizione attuale',
	'mobile-frontend-nearby-requirements' => 'Questa pagina richiede JavaScript ed un browser in grado di rilevare la posizione.',
	'mobile-frontend-nearby-distance-report' => '$1 km dalla tua posizione attuale',
	'mobile-frontend-nearby-lookup-error' => 'Impossibile trovarti. Prova di nuovo...',
	'mobile-frontend-nearby-noresults' => 'Sei in mezzo al nulla e siamo riusciti a trovare nessun argomento. Perché non ne scrivi uno?',
	'mobile-frontend-nearby-refresh' => "Abbiamo trovato una posizione più precisa. Clicca qui per aggiornare l'elenco delle pagine nelle tue vicinanze",
	'mobile-frontend-nearby-error' => 'Si è verificato un errore imprevisto durante il tentativo di trovare le pagine nelle tue vicinanze',
	'mobile-frontend-donate-image-login' => "Devi aver effettuato l'accesso per vedere i file che hai caricato.",
	'mobile-frontend-photo-upload-generic' => "Dona un'immagine",
	'mobile-frontend-donate-image-title' => "Dona un'immagine",
	'mobile-frontend-donate-image-heading' => 'I tuoi contributi recenti',
	'mobile-frontend-donate-image-page-title' => 'Carica',
	'mobile-frontend-donate-image-anon' => "Per visualizzare la pagina di caricamento è necessario un'[[Special:UserLogin|utenza]]",
	'mobile-frontend-listed-image-no-description' => 'Nessuna descrizione',
	'mobile-frontend-watchlist-add' => 'Aggiunto $1 ai tuoi osservati speciali',
	'mobile-frontend-watchlist-removed' => 'Rimosso $1 dai tuoi osservati speciali',
	'mobile-frontend-watchlist-view' => 'Vedi i tuoi osservati speciali',
	'mobile-frontend-watchlist-more' => 'altro',
	'mobile-frontend-watchlist-cta' => "Effettua l'accesso o registrati per aggiungere questa pagina agli osservati speciali.",
	'mobile-frontend-watchlist-cta-button-login' => 'Accedi',
	'mobile-frontend-watchlist-cta-button-signup' => 'Registrati',
	'mobile-frontend-watchlist-a-z' => 'Tutte',
	'mobile-frontend-watchlist-feed' => 'Modificate',
	'mobile-frontend-watchlist-a-z-empty' => 'Attualmente non stai osservando alcuna pagina',
	'mobile-frontend-watchlist-a-z-empty-howto-alt' => 'Fai clic sulla stella in alto nella pagina',
	'mobile-frontend-watchlist-feed-empty' => 'Non ci sono pagine con modifiche recenti',
	'mobile-frontend-changeslist-ip' => 'Utente anonimo',
	'mobile-frontend-changeslist-nocomment' => 'nessun oggetto della modifica',
	'mobile-frontend-watchlist-filter-all' => 'Tutte',
	'mobile-frontend-watchlist-filter-articles' => 'Voci',
	'mobile-frontend-watchlist-filter-talk' => 'Discussioni',
	'mobile-frontend-watchlist-filter-other' => 'Altro',
	'mobile-frontend-watchlist-modified' => 'Modificata $1',
	'mobile-frontend-diffview-404-title' => 'Errore versione',
	'mobile-frontend-diffview-404-desc' => "L'id per la versione richiesta non esiste",
	'mobile-frontend-diffview-title' => 'Modifiche',
	'mobile-frontend-diffview-editcount' => '$1 {{PLURAL:$1|contributo|contributi}}',
	'mobile-frontend-diffview-anonymous' => 'Utente anonimo',
	'mobile-frontend-diffview-bytesadded' => '$1 byte {{PLURAL:$1|aggiunto|aggiunti}}',
	'mobile-frontend-diffview-bytesremoved' => '$1 byte {{PLURAL:$1|rimosso|rimossi}}',
	'mobile-frontend-diffview-explained' => 'Le righe seguenti sono stati aggiunte (+) e rimosse (-):',
	'mobile-frontend-table' => 'Tabella $1',
	'mobile-frontend-saving-exit-page' => 'La tua modifica è ancora da salvare. Se esci i tuoi contributi andranno persi. Sei sicuro di voler uscire?',
	'mobile-frontend-photo-upload' => "Aggiungi un'immagine a questa voce",
	'mobile-frontend-photo-article-edit-comment' => 'Aggiungi una foto a questa pagina',
	'mobile-frontend-photo-upload-comment' => 'Aggiungi questa foto ad una pagina',
	'mobile-frontend-photo-caption-placeholder' => 'Aggiungi una descrizione (obbligatoria)',
	'mobile-frontend-image-loading' => 'Caricamento immagine',
	'mobile-frontend-image-uploading-wait' => 'Caricamento immagine, attendi.',
	'mobile-frontend-photo-upload-error' => 'Errore, prova ancora.',
	'mobile-frontend-photo-license' => 'Nota: tutte le foto pubblicate saranno rilasciate con [//en.wikipedia.org/wiki/Wikipedia:Text_of_Creative_Commons_Attribution-ShareAlike_3.0_Unported_License licenza CC BY-SA 3.0]', # Fuzzy
	'mobile-frontend-photo-submit' => 'Invia',
	'mobile-frontend-photo-cancel' => 'Annulla',
	'mobile-frontend-photo-upload-user-count' => '{{PLURAL:$1|1 caricamento|$1 caricamenti}}', # Fuzzy
	'mobile-frontend-photo-upload-user-count-over-limit' => '500+ caricamenti',
	'tag-mobile_edit-description' => 'Modifica apportata dal sito per dispositivi mobili',
	'mobile-frontend-drawer-cancel' => 'Annulla',
);

/** Japanese (日本語)
 * @author Anakmalaysia
 * @author Fryed-peach
 * @author Miya
 * @author Ohgi
 * @author Schu
 * @author Shirayuki
 * @author Whym
 */
$messages['ja'] = array(
	'mobile-frontend-desc' => '携帯機器フロントエンド',
	'mobile.css' => '/* ここに記述したCSSは携帯機器版サイトの利用者に影響します */',
	'mobile.js' => '/* ここにあるすべてのJavaScriptは携帯機器版サイトの利用者に影響します */',
	'mobile-frontend-search-submit' => '表示',
	'mobile-frontend-home-button' => 'ホーム',
	'mobile-frontend-logged-out' => 'ログインしていません',
	'mobile-frontend-logged-in-homepage-notification' => 'ようこそ、$1さん!',
	'mobile-frontend-logged-in-toast-notification' => '$1 としてログインしています。',
	'mobile-frontend-sign-up-heading' => '利用者登録',
	'mobile-frontend-sign-in-heading' => 'ログイン',
	'mobile-frontend-sign-in-why' => '{{SITENAME}}のアカウントを既に持っている場合、以下でログインしてください。',
	'mobile-frontend-sign-in-error-heading' => 'エラー',
	'mobile-frontend-settings-beta' => 'ベータ',
	'mobile-frontend-save-settings' => '設定を保存',
	'mobile-frontend-random-button' => 'おまかせ表示',
	'mobile-frontend-ajax-random-quote' => '知性の成長は、生まれたときに始まり亡くなるまで続くべきである',
	'mobile-frontend-ajax-random-quote-author' => 'アルベルト・アインシュタイン',
	'mobile-frontend-ajax-random-question' => 'このページを読みますか?',
	'mobile-frontend-ajax-random-yes' => 'はい',
	'mobile-frontend-ajax-random-retry' => 'もう一度お試しください',
	'mobile-frontend-ajax-random-suggestions' => '他のおまかせ表示:',
	'mobile-frontend-back-to-top-of-section' => '節の先頭に戻る',
	'mobile-frontend-close-section' => 'この節を閉じる',
	'mobile-frontend-show-button' => '表示',
	'mobile-frontend-hide-button' => '非表示',
	'mobile-frontend-empty-homepage-text' => 'このホームページには設定が必要です。[//meta.wikimedia.org/wiki/Mobile_Projects/Mobile_Gateway#Mobile_homepage このサイトの携帯機器版を有効にする手順はこちら]',
	'mobile-frontend-regular-site' => 'デスクトップビュー',
	'mobile-frontend-wml-continue' => '続行...',
	'mobile-frontend-wml-back' => '戻る...',
	'mobile-frontend-view' => 'モバイルビュー',
	'mobile-frontend-view-desktop' => 'デスクトップ',
	'mobile-frontend-view-mobile' => '携帯機器',
	'mobile-frontend-opt-in-explain' => 'ベータテストへ参加すると、開発中の機能にアクセスできるようになりますがバグや問題に遭遇する危険性が伴います。',
	'mobile-frontend-images-status' => '画像',
	'mobile-frontend-disable-images' => '携帯機器ウェブサイトで画像を無効にする',
	'mobile-frontend-enable-images' => '携帯機器ウェブサイトで画像を有効にする',
	'mobile-frontend-missing-image' => '画像',
	'mobile-frontend-off' => 'OFF',
	'mobile-frontend-on' => 'ON',
	'mobile-frontend-footer-contributors-text' => 'あなたのような[$1 投稿者]が執筆したページ',
	'mobile-frontend-featured-article' => '今日の秀逸な記事',
	'mobile-frontend-news-items' => '新着情報',
	'mobile-frontend-leave-feedback-notice' => 'フィードバックは携帯機器ウェブサイトの使用感を向上させる助けになります。フィードバックは (利用者名、ブラウザーのバージョン、オペレーティングシステムとともに) &quot;$1&quot;のページで公開されます。「幅の広い表の書式の問題」のように、情報量が多い表題名を付けるようにしてください。フィードバックは利用規約の対象です。',
	'mobile-frontend-leave-feedback-warning' => '情報が公開されることに同意できる場合を除いて、コメントには個人情報を含めないでください。',
	'mobile-frontend-leave-feedback-subject' => '表題:',
	'mobile-frontend-leave-feedback-message' => '本文:',
	'mobile-frontend-leave-feedback-submit' => 'フィードバックを送信',
	'mobile-frontend-leave-feedback-link-text' => '携帯機器フロントエンド拡張機能のフィードバック',
	'mobile-frontend-leave-feedback' => '携帯機器ウェブサイトのフィードバック',
	'mobile-frontend-leave-feedback-title' => '携帯機器ウェブサイトのフィードバック',
	'mobile-frontend-leave-feedback-technical-problem-section-header' => '技術的な問題',
	'mobile-frontend-leave-feedback-general-section-header' => '全般',
	'mobile-frontend-leave-feedback-article-feedback-section-header' => '記事へのフィードバック',
	'mobile-frontend-leave-feedback-email-body' => 'あなたが {{SITENAME}} で体験した問題点についてこの行の上に書いてください。私たちがメッセージすべてに対しては返信できないことにご注意ください。',
	'mobile-frontend-leave-feedback-technical-link-text' => '技術的な問題',
	'mobile-frontend-leave-feedback-general-link-text' => '全般的なフィードバック',
	'mobile-frontend-leave-feedback-article-personal-link-text' => '自分、または自分が代理人を務める人物や会社について',
	'mobile-frontend-leave-feedback-article-factual-link-text' => '事実の誤認について',
	'mobile-frontend-leave-feedback-article-other-link-text' => 'その他の問題について',
	'mobile-frontend-leave-feedback-form-subject-placeholder' => 'メッセージの件名',
	'mobile-frontend-leave-feedback-form-message-placeholder' => 'コメントをここに入力',
	'mobile-frontend-leave-feedback-page-title' => '携帯機器ウェブサイトのフィードバック',
	'mobile-frontend-feedback-page' => 'Project:携帯機器拡張機能へのフィードバック',
	'mobile-frontend-leave-feedback-special-title' => 'ウィキメディアに関するお問い合わせ',
	'mobile-frontend-feedback-no-subject' => '(表題なし)',
	'mobile-frontend-feedback-no-subject-field' => '件名を入力してください',
	'mobile-frontend-feedback-no-message' => 'ここにメッセージをお書きください',
	'mobile-frontend-feedback-edit-summary' => '$1 - [[Special:MobileFeedback|携帯機器版のフィードバックツール]]を使用した自動投稿',
	'mobile-frontend-leave-feedback-thanks' => 'フィードバックをありがとうございます。',
	'mobile-frontend-leave-feedback-post-error' => 'メッセージの処理中にエラーが発生しました。後ほどまたお試しください。',
	'mobile-frontend-language' => '言語:',
	'mobile-frontend-language-article-heading' => '別の言語で閲覧',
	'mobile-frontend-language-header' => 'このページは $1 言語で提供されています。',
	'mobile-frontend-language-variant-header' => '{{#language:{{CONTENTLANG}}}}の言語変種の選択',
	'mobile-frontend-language-footer' => '{{SITENAME}}は他の言語でも利用できます。', # Fuzzy
	'mobile-frontend-language-site-choose' => '言語を検索',
	'mobile-frontend-username' => '利用者名:',
	'mobile-frontend-password' => 'パスワード:',
	'mobile-frontend-username-placeholder' => '利用者名',
	'mobile-frontend-password-placeholder' => 'パスワード',
	'mobile-frontend-login' => 'ログイン',
	'mobile-frontend-last-modified-date' => '最終更新日時 $1 $2',
	'mobile-frontend-last-modified-seconds' => '{{PLURAL:$1|$1秒}}前に最終更新',
	'mobile-frontend-last-modified-minutes' => '{{PLURAL:$1|$1分}}前に最終更新',
	'mobile-frontend-last-modified-hours' => '{{PLURAL:$1|$1時間}}前に最終更新',
	'mobile-frontend-last-modified-days' => '{{PLURAL:$1|$1日}}前に最終更新',
	'mobile-frontend-last-modified-months' => '{{PLURAL:$1|$1か月}}前に最終更新',
	'mobile-frontend-last-modified-years' => '{{PLURAL:$1|$1年}}前に最終更新',
	'mobile-frontend-account-create-submit' => '利用者登録',
	'mobile-frontend-password-confirm-placeholder' => 'パスワード再入力',
	'mobile-frontend-account-create-email-placeholder' => 'メールアドレス (省略可能)',
	'mobile-frontend-overlay-escape' => '戻る',
	'mobile-frontend-placeholder' => '{{SITENAME}}内を検索',
	'mobile-frontend-placeholder-beta' => '{{SITENAME}}内を検索 (ベータ版)',
	'mobile-frontend-search-help' => '検索したい語句を上の欄に入力すると、該当するページの名前がここに表示されます。',
	'mobile-frontend-dismiss-notification' => 'この通知を消す',
	'mobile-frontend-clear-search' => '消去',
	'mobile-frontend-privacy-link-text' => 'プライバシー',
	'mobile-frontend-about-link-text' => 'このサイトについて',
	'mobile-frontend-footer-sitename' => '{{SITENAME}}',
	'mobile-frontend-footer-license-text' => 'コンテンツは[//en.m.wikipedia.org/wiki/Wikipedia:Text_of_Creative_Commons_Attribution-ShareAlike_3.0_Unported_License?useformat=mobile CC BY-SA 3.0]で提供されています',
	'mobile-frontend-terms-use-text' => '[//wikimediafoundation.org/wiki/Terms_of_use/ja?useformat=mobile 利用規約]',
	'mobile-frontend-footer-contact' => '連絡先',
	'mobile-frontend-search-noresults' => '検索語句に該当する項目名はありませんでした。別の語句をお試しください。また、キーボードの検索ボタンを押すと、ページ内検索を行うこともできます。',
	'mobile-frontend-main-menu-button-tooltip' => 'メインメニューを開く',
	'mobile-frontend-main-menu-featured' => '秀逸',
	'mobile-frontend-main-menu-nearby' => '付近',
	'mobile-frontend-main-menu-login' => 'ログイン',
	'mobile-frontend-main-menu-logout' => 'ログアウト',
	'mobile-frontend-main-menu-watchlist' => 'ウォッチリスト',
	'mobile-frontend-main-menu-settings' => '設定',
	'mobile-frontend-main-menu-upload' => 'アップロード',
	'mobile-frontend-main-menu-settings-heading' => '携帯機器版サイトの設定',
	'mobile-frontend-settings-site-header' => '{{SITENAME}}の言語',
	'mobile-frontend-settings-site-description' => '{{SITENAME}}は $1 {{PLURAL:$1|言語}}で利用できます。利用できるすべての言語版を以下に列挙します',
	'mobile-frontend-main-menu-contact' => '連絡先',
	'mobile-frontend-main-menu-account-create' => 'アカウント作成',
	'mobile-frontend-page-menu-contents' => '目次',
	'mobile-frontend-page-menu-language-current' => '{{#language:{{CONTENTLANG}}}}',
	'mobile-frontend-page-menu-history' => '履歴',
	'mobile-frontend-meta-data-issues-header' => '問題点',
	'mobile-frontend-meta-data-issues' => 'このページには問題点があります',
	'mobile-frontend-ajax-page-loading' => '$1 を読み込み中',
	'mobile-frontend-page-saving' => '$1 を保存中',
	'mobile-frontend-ajax-page-error' => 'エラー! 何らかのエラーが発生しました。ブラウザーの再読込を試してください。',
	'mobile-frontend-nearby-title' => '付近',
	'mobile-frontend-nearby-loading' => '現在地付近の話題を読み込み中',
	'mobile-frontend-nearby-distance-report' => '現在地から $1 km',
	'mobile-frontend-nearby-error' => '付近のページを検索する際に予期しないエラーが発生しました',
	'mobile-frontend-donate-image-login' => '自分のアップロード一覧を表示するにはログインしてください。',
	'mobile-frontend-donate-image-heading' => '最近の投稿記録',
	'mobile-frontend-donate-image-page-title' => 'アップロード',
	'mobile-frontend-donate-image-anon' => 'アップロードページを閲覧するには[[Special:UserLogin|利用者アカウント]]が必要です',
	'mobile-frontend-listed-image-no-description' => '説明なし',
	'mobile-frontend-donate-photo-upload-success' => '完了しました! 画像は{{SITENAME}}上で使用できるようになりました!',
	'mobile-frontend-donate-photo-first-upload-success' => '完了しました! 初めてのアップロードありがとうございます!',
	'mobile-frontend-watchlist-add' => '$1 をウォッチリストに追加しました',
	'mobile-frontend-watchlist-removed' => '$1 をウォッチリストから除去しました',
	'mobile-frontend-watchlist-view' => 'ウォッチリストを表示',
	'mobile-frontend-watchlist-more' => '続き',
	'mobile-frontend-watchlist-cta' => 'このページをウォッチするにはログインまたは利用者登録をしてください。',
	'mobile-frontend-watchlist-cta-button-login' => 'ログイン',
	'mobile-frontend-watchlist-cta-button-signup' => '利用者登録',
	'mobile-frontend-watch-login' => 'ページをウォッチするにはログインしてください。',
	'mobile-frontend-watchlist-a-z' => 'すべて',
	'mobile-frontend-watchlist-feed' => '変更あり',
	'mobile-frontend-watchlist-a-z-empty' => '現在ウォッチしているページはありません',
	'mobile-frontend-watchlist-a-z-empty-howto-alt' => 'ページ上部の星アイコンをクリックします',
	'mobile-frontend-watchlist-a-z-empty-howto' => '興味深いページを見つけたら、画面上部の星アイコンをクリックすることでページをウォッチできます。これにより、ページをブックマークできるだけでなく、ページが変更された際にそれを知ることができるようになります。',
	'mobile-frontend-watchlist-feed-empty' => '最近更新されたページはありません',
	'mobile-frontend-watchlist-back-home' => 'ホームに戻る',
	'mobile-frontend-changeslist-ip' => '匿名利用者',
	'mobile-frontend-changeslist-nocomment' => '編集の要約なし',
	'mobile-frontend-watchlist-filter-all' => 'すべて',
	'mobile-frontend-watchlist-filter-articles' => '記事',
	'mobile-frontend-watchlist-filter-talk' => 'トーク',
	'mobile-frontend-watchlist-filter-other' => 'その他',
	'mobile-frontend-watchlist-modified' => '$1に変更',
	'mobile-frontend-diffview-404-title' => '版指定の誤り',
	'mobile-frontend-diffview-404-desc' => '指定した ID の版は存在しません',
	'mobile-frontend-diffview-title' => '差分',
	'mobile-frontend-diffview-editcount' => '$1 {{PLURAL:$1|回編集}}',
	'mobile-frontend-diffview-anonymous' => '匿名利用者',
	'mobile-frontend-diffview-bytesadded' => '$1 {{PLURAL:$1|バイト}}追加',
	'mobile-frontend-diffview-bytesremoved' => '$1 {{PLURAL:$1|バイト}}除去',
	'mobile-frontend-diffview-explained' => '「+」は追加された行、「-」は除去された行を示しています:',
	'mobile-frontend-table' => '表 $1',
	'mobile-frontend-saving-exit-page' => '編集内容をまだ保存中です。このまま終了すると編集内容が失われます。本当に終了しますか?',
	'mobile-frontend-photo-article-edit-comment' => 'ページで使用する写真を追加しました',
	'mobile-frontend-photo-upload-comment' => 'ページに写真を追加しました',
	'mobile-frontend-photo-caption-placeholder' => '説明を追加 (必須)',
	'mobile-frontend-image-loading' => '画像を読み込み中',
	'mobile-frontend-image-uploading-wait' => '画像をアップロード中です。お待ちください。',
	'mobile-frontend-image-uploading-long' => '画像をまだアップロード中です! もうしばらくお待ちください。',
	'mobile-frontend-image-uploading-cancel' => '時間がかかりすぎる場合は<a href="#">キャンセル</a>してください。',
	'mobile-frontend-photo-upload-error' => 'エラーです。もう一度試してください。',
	'mobile-frontend-photo-upload-success-article' => '完了しました! 画像をこのページに追加しました。',
	'mobile-frontend-photo-submit' => '送信',
	'mobile-frontend-photo-cancel' => 'キャンセル',
	'mobile-frontend-photo-upload-user-count' => '{{PLURAL:$1|アップロード <span>$1</span> 件}}',
	'mobile-frontend-photo-upload-user-count-over-limit' => 'アップロード 500+ 件',
	'tag-mobile_edit' => '携帯機器での編集',
	'tag-mobile_edit-description' => '携帯機器版サイトでの編集',
	'mobile-frontend-drawer-cancel' => 'キャンセル',
);

/** Javanese (Basa Jawa)
 * @author NoiX180
 */
$messages['jv'] = array(
	'mobile-frontend-desc' => 'Antarmuka Ponsèl',
	'mobile-frontend-search-submit' => 'Nuju',
	'mobile-frontend-home-button' => 'Latar',
	'mobile-frontend-logged-out' => 'Durung mlebu log',
	'mobile-frontend-settings-beta' => 'Béta',
	'mobile-frontend-save-settings' => 'Simpen pangaturan',
	'mobile-frontend-random-button' => 'Waton',
	'mobile-frontend-back-to-top-of-section' => 'Balik nèng sakdurungé',
	'mobile-frontend-close-section' => 'Tutup bagèyan iki',
	'mobile-frontend-show-button' => 'Tuduhna',
	'mobile-frontend-hide-button' => 'Dhelikna',
	'mobile-frontend-regular-site' => 'Tampilan komputer',
	'mobile-frontend-wml-continue' => 'Banjuraké...',
	'mobile-frontend-wml-back' => 'Balik...',
	'mobile-frontend-view' => 'Tampilan ponsel',
	'mobile-frontend-view-desktop' => 'Komputer',
	'mobile-frontend-view-mobile' => 'Ponsèl',
	'mobile-frontend-opt-in-explain' => 'Amarga gabung modé bèta, Sampéyan artiné ngéntukaké dalan nèng piranti èkspèrimèntal masiya mawa risiko ana bug lan masalah.',
	'mobile-frontend-images-status' => 'Gambar',
	'mobile-frontend-disable-images' => 'Patèni gambar nèng situs ponsèl',
	'mobile-frontend-enable-images' => 'Urubaké gambar nèng situs ponsèl',
	'mobile-frontend-off' => 'MATI',
	'mobile-frontend-on' => 'MURUB',
	'mobile-frontend-footer-contributors-text' => 'Artikel déning <a href="$1">contributors</a> kaya Sampéyan', # Fuzzy
	'mobile-frontend-featured-article' => 'Artikel Pinilih Dina Iki',
	'mobile-frontend-news-items' => 'Warta Pinjunjul',
	'mobile-frontend-leave-feedback-warning' => 'Kejaba Sampéyan pingin inpormasi Sampéyan kasebar nèng uwong-uwong, mangga aja lebokaké inpormasi pribadi nèng tanggepan Sampéyan.',
	'mobile-frontend-leave-feedback-subject' => 'Jejer:',
	'mobile-frontend-leave-feedback-message' => 'Layang:',
	'mobile-frontend-leave-feedback-submit' => 'Kirim lebon saran',
	'mobile-frontend-leave-feedback-link-text' => 'Lebon saran kanggo Èksténsi Antarmuka Ponsèl',
	'mobile-frontend-leave-feedback' => 'Lebon saran situs ponsèl',
	'mobile-frontend-leave-feedback-title' => 'Lebon lan saran kanggo situs ponsèl',
	'mobile-frontend-leave-feedback-technical-problem-section-header' => 'Masalah tèhnis',
	'mobile-frontend-leave-feedback-general-section-header' => 'Umum',
	'mobile-frontend-leave-feedback-article-feedback-section-header' => 'Labon saran artikel',
	'mobile-frontend-leave-feedback-email-body' => 'Mangga tulis layang èlèktronik Sampéyan ndhuwuré garis iki.', # Fuzzy
	'mobile-frontend-leave-feedback-technical-link-text' => 'Masalah tèhnis',
	'mobile-frontend-leave-feedback-general-link-text' => 'Lebon saran umum',
	'mobile-frontend-leave-feedback-article-personal-link-text' => 'Bab kula, uwong, utawa prusahan sing tak wakili',
	'mobile-frontend-leave-feedback-article-factual-link-text' => 'Bab kasalahan nyata',
	'mobile-frontend-leave-feedback-article-other-link-text' => 'Bab perkara liya',
	'mobile-frontend-leave-feedback-form-subject-placeholder' => 'Jejeré layang',
	'mobile-frontend-leave-feedback-form-message-placeholder' => 'Tulis tanggepan Sampéyan nèng kéné',
	'mobile-frontend-leave-feedback-page-title' => 'Lebon saran situs ponsèl',
	'mobile-frontend-leave-feedback-special-title' => 'Ngubungi awak dhéwé',
	'mobile-frontend-feedback-no-subject' => '(ora ana jejer)',
	'mobile-frontend-feedback-no-subject-field' => 'Mangga lebokaké jejer',
	'mobile-frontend-feedback-no-message' => 'Mangga lebokaké layang nèng kéné',
	'mobile-frontend-feedback-edit-summary' => '$1 - otomatis masang nganggo [[Special:MobileFeedback|piranti lebon saran ponsèl]]',
	'mobile-frontend-leave-feedback-thanks' => 'Matur nuwun lebon sarané!',
	'mobile-frontend-leave-feedback-post-error' => 'Ana kasalahan nalika mrosès layang Sampéyan. Mangga dijajal manèh.',
	'mobile-frontend-language' => 'Basa:',
	'mobile-frontend-language-header' => 'Artikel iki sumadhiya nèng $1 {{PLURAL:$1|basa|basa}}', # Fuzzy
	'mobile-frontend-language-footer' => '{{SITENAME}} sumadhiya nèng basa liya.', # Fuzzy
	'mobile-frontend-language-site-choose' => 'Golèk basa',
	'mobile-frontend-username' => 'Jeneng panganggo:',
	'mobile-frontend-password' => 'Tembung sandhi:',
	'mobile-frontend-login' => 'Mlebu log',
	'mobile-frontend-placeholder' => 'Golèk {{SITENAME}}',
	'mobile-frontend-search-help' => 'Tulis istilah sing digolèki kuwi lan cocokaké karo judhul artikel sing njedhul mengko.', # Fuzzy
	'mobile-frontend-dismiss-notification' => 'tutup warta iki',
	'mobile-frontend-clear-search' => 'Busak',
	'mobile-frontend-privacy-link-text' => 'Pripasi',
	'mobile-frontend-about-link-text' => 'Bab',
	'mobile-frontend-footer-sitename' => '{{SITENAME}}',
	'mobile-frontend-footer-contact' => 'Kontak',
	'mobile-frontend-search-noresults' => 'Ora ana artikel sing padha karo panggolèkan Sampéyan. Ganti panggolèkan, utawa teken tombol golèk nèng keyboard kanggo nggolèki saknjeroné artikel.', # Fuzzy
	'mobile-frontend-main-menu-featured' => 'Pinilih',
	'mobile-frontend-main-menu-nearby' => 'Paling cedhak',
	'mobile-frontend-main-menu-settings' => 'Pangaturan',
	'mobile-frontend-main-menu-settings-heading' => 'Pangaturan situs ponsèl',
	'mobile-frontend-settings-site-header' => 'Basa {{SITENAME}}',
	'mobile-frontend-settings-site-description' => '{{SITENAME}} sumadhiya nèng $1 {{PLURAL:$1|basa|basa}}. Kabéh vèrsi sumadhiya kadaptar nèng ngisor',
	'mobile-frontend-main-menu-contact' => 'Kontak',
	'mobile-frontend-page-menu-contents' => 'isi',
	'mobile-frontend-page-menu-history' => 'Riwayat',
);

/** Georgian (ქართული)
 * @author BRUTE
 * @author David1010
 * @author Dawid Deutschland
 * @author ITshnik
 * @author გიორგიმელა
 */
$messages['ka'] = array(
	'mobile-frontend-desc' => 'მობილური ინტერფეისი',
	'mobile-frontend-search-submit' => 'აბა ჰე',
	'mobile-frontend-home-button' => 'შინ',
	'mobile-frontend-logged-out' => 'შესვლა არ განხორციელდა',
	'mobile-frontend-logged-in-homepage-notification' => 'მოგესალმებით, $1!',
	'mobile-frontend-logged-in-toast-notification' => 'შესული ხართ როგორც $1.',
	'mobile-frontend-sign-up-heading' => 'რეგისტრაცია',
	'mobile-frontend-sign-in-heading' => 'რეგისტრაცია',
	'mobile-frontend-sign-in-why' => 'თუ თქვენ გაქვთ ანგარიში საიტზე {{SITENAME}}, თქვენ შეგიძლიათ შეხვიდეთ.',
	'mobile-frontend-sign-in-error-heading' => 'ვაი',
	'mobile-frontend-settings-beta' => 'ბეტა',
	'mobile-frontend-save-settings' => 'პარამეტრების შენახვა',
	'mobile-frontend-random-button' => 'შემთხვევითი',
	'mobile-frontend-ajax-random-heading' => 'ცოდნის ძიება...',
	'mobile-frontend-ajax-random-question' => 'ამ გვერდის კითხვა?',
	'mobile-frontend-ajax-random-yes' => 'დიახ',
	'mobile-frontend-ajax-random-retry' => 'კიდევ სცადეთ',
	'mobile-frontend-back-to-top-of-section' => 'დაბრუნება უკან',
	'mobile-frontend-close-section' => 'ამ სექციის დახურვა',
	'mobile-frontend-show-button' => 'აჩვენე',
	'mobile-frontend-hide-button' => 'დამალე',
	'mobile-frontend-empty-homepage-text' => 'ეს საწყისი გვერდი საჭიროებს კონფიგურაციას. [//meta.wikimedia.org/wiki/Mobile_Projects/Mobile_Gateway#Mobile_homepage საიტის მობილური ვერსიის ორგანიზების ინსტრუქცია]',
	'mobile-frontend-regular-site' => 'ჩვეულებრივი ვერსია',
	'mobile-frontend-wml-continue' => 'შემდეგ...',
	'mobile-frontend-wml-back' => 'უკან...',
	'mobile-frontend-view' => 'მობილური ვერსია',
	'mobile-frontend-view-desktop' => 'დესკტოპი',
	'mobile-frontend-view-mobile' => 'მობილური',
	'mobile-frontend-opt-in-explain' => 'ბეტა ვერსიასთან დაკავშირებისას, თქვენ მიიღებთ წვდომას რამდენიმე ექსპერიმენტულ ფუნქციასთან, მაგრამ აგრეთვე იზდრება იმის შანსიც, რომ გადააწყდეთ რაიმე შეცდომას ან პრობლემას.',
	'mobile-frontend-images-status' => 'სურათები',
	'mobile-frontend-disable-images' => 'მობილურ საიტზე სურათების გამორთვა',
	'mobile-frontend-enable-images' => 'მობილურ საიტზე სურათების ჩართვა',
	'mobile-frontend-missing-image' => 'სურათი',
	'mobile-frontend-off' => 'გამორთვა',
	'mobile-frontend-on' => 'ჩართვა',
	'mobile-frontend-footer-contributors-text' => '[$1 ამ გვერდის ავტორები] — თქვენნაირი მოხალისეები არიან',
	'mobile-frontend-featured-article' => 'დღის რჩეული სტატია',
	'mobile-frontend-news-items' => 'სიახლეებში',
	'mobile-frontend-leave-feedback-notice' => 'თქვენი გამოხმაურება ჩვენ დაგვეხმარება მობილური საიტის გამოყენების გაუმჯობესებაში. ის გამოქვეყნდება საჯაროდ (თქვენი მომხმარებლის სახელთან, ბრაუზერის ვერსიასა და ოპერაციულ სისტემასთან ერთად) გვერდზე &quot;$1&quot;. გთხოვთ, შეეცადეთ აირჩიოთ ინფორმატიული სიუჟეტური ხაზი, მაგალითად „განიერი ცხრილების ფორმატირების საკითხები“. თქვენი გამოხმაურება უნდა იყოს გამოყენების პირობების შესაბამისი.',
	'mobile-frontend-leave-feedback-subject' => 'თემა:',
	'mobile-frontend-leave-feedback-message' => 'შეტყობინება:',
	'mobile-frontend-leave-feedback-submit' => 'შეფასების გაგზავნა',
	'mobile-frontend-leave-feedback-link-text' => 'გამოხმაურება მობილური ინტერფეისის შესახებ',
	'mobile-frontend-leave-feedback' => 'გამოხმაურების დატოვება',
	'mobile-frontend-leave-feedback-title' => 'მობილური საიტის გამოხმაურება',
	'mobile-frontend-leave-feedback-technical-problem-section-header' => 'ტექნიკური პრობლემა',
	'mobile-frontend-leave-feedback-general-section-header' => 'მთავარი',
	'mobile-frontend-leave-feedback-article-feedback-section-header' => 'სტატიის შეფასება',
	'mobile-frontend-leave-feedback-email-body' => 'გთხოვთ, აღწეროთ გაუმართაობა, რომელსაც თქვენ განიცდით საიტზე „{{SITENAME}}“ ამ ხაზის ზემოთ. სამწუხაროდ ჩვენ არ შეგვიძლია ვუპასუხოთ ყველა კითხვას.',
	'mobile-frontend-leave-feedback-technical-link-text' => 'ტექნიკური პრობლემა',
	'mobile-frontend-leave-feedback-general-link-text' => 'მთავარი შეფასება',
	'mobile-frontend-leave-feedback-article-factual-link-text' => 'ფაქტიური შეცდომის შესახებ',
	'mobile-frontend-leave-feedback-article-other-link-text' => 'სხვა პრობლემის შესახებ',
	'mobile-frontend-leave-feedback-form-subject-placeholder' => 'შეტყობინების თემა',
	'mobile-frontend-leave-feedback-form-message-placeholder' => 'დაწერეთ თქვენი კომენტარი აქ',
	'mobile-frontend-leave-feedback-page-title' => 'მობილური საიტის გამოხმაურება',
	'mobile-frontend-leave-feedback-special-title' => 'დაგვეკონტაქტეთ',
	'mobile-frontend-feedback-no-subject' => '(თემის გარეშე)',
	'mobile-frontend-feedback-no-subject-field' => 'გთხოვთ, შეიყვანეთ თემა',
	'mobile-frontend-feedback-no-message' => 'გთხოვთ, შეტყობინება აქ შეიყვანოთ',
	'mobile-frontend-feedback-edit-summary' => '$1 - ავტომატურად ნარჩუნდება [[Special:MobileFeedback|უკუკავშირი]]',
	'mobile-frontend-leave-feedback-thanks' => 'გმადლობთ თქვენი შეფასებისთვის',
	'mobile-frontend-language' => 'ენა:',
	'mobile-frontend-language-article-heading' => 'სხვა ენაზე წაკითხვა',
	'mobile-frontend-language-header' => 'ეს გვერდი ხელმისაწვდომია $1 {{PLURAL:$1|ენაზე|ენაზე}}',
	'mobile-frontend-language-variant-header' => 'აირჩიეთ {{#language:{{CONTENTLANG}}}} ვარიანტი',
	'mobile-frontend-language-footer' => 'შენიშვნა: ამ გვერდის ჩაწერა თქვენთვის საჭირო ენაზე შეუძლებელია. თქვენ შეგიძიათ იხილოთ რომელი ენების მხარდაჭერა აქვს {{SITENAME}}-ს აქ დაჭერით.',
	'mobile-frontend-language-site-choose' => 'ენის ძიება',
	'mobile-frontend-username' => 'მომხმარებელი:',
	'mobile-frontend-password' => 'პაროლი:',
	'mobile-frontend-username-placeholder' => 'მომხმარებლის სახელი',
	'mobile-frontend-password-placeholder' => 'პაროლი',
	'mobile-frontend-login' => 'შესვლა',
	'mobile-frontend-last-modified-date' => 'ბოლოს შეიცვალა $1-ში, $2-ზე',
	'mobile-frontend-last-modified-seconds' => 'ბოლოს შეიცვალა {{PLURAL:$1|$1 წამის|$1 წამის}} წინ',
	'mobile-frontend-last-modified-minutes' => 'ბოლოს შეიცვალა {{PLURAL:$1|$1 წუთის|$1 წუთის}} წინ',
	'mobile-frontend-last-modified-hours' => 'ბოლოს შეიცვალა {{PLURAL:$1|$1 საათის|$1 საათის}} წინ',
	'mobile-frontend-last-modified-days' => 'ბოლოს შეიცვალა {{PLURAL:$1|$1 დღის|$1 დღის}} წინ',
	'mobile-frontend-last-modified-months' => 'ბოლოს შეიცვალა {{PLURAL:$1|$1 თვის|$1 თვის}} წინ',
	'mobile-frontend-last-modified-years' => 'ბოლოს შეიცვალა {{PLURAL:$1|$1 წლის|$1 წლის}} წინ',
	'mobile-frontend-account-create-submit' => 'რეგისტრაცია',
	'mobile-frontend-password-confirm-placeholder' => 'პაროლის დადასტურება',
	'mobile-frontend-account-create-email-placeholder' => 'ელ. ფოსტის მისამართი (არასავალდებულო)',
	'mobile-frontend-account-create-captcha-placeholder' => 'შეიყვანეთ უსაფრთხოების ტექსტი',
	'mobile-frontend-overlay-escape' => 'უკან',
	'mobile-frontend-placeholder' => 'ძიება {{SITENAME}}',
	'mobile-frontend-placeholder-beta' => 'ძიება {{SITENAME}} (ბეტა)',
	'mobile-frontend-dismiss-notification' => 'ამ შეტყობინების დამალვა',
	'mobile-frontend-clear-search' => 'გასუფთავება',
	'mobile-frontend-privacy-link-text' => 'უსაფრთხოება',
	'mobile-frontend-about-link-text' => 'მასზე',
	'mobile-frontend-footer-sitename' => '{{SITENAME}}',
	'mobile-frontend-footer-license-text' => '
შიგთავსი ხელმისაწვდომია [//en.m.wikipedia.org/wiki/Wikipedia:Text_of_Creative_Commons_Attribution-ShareAlike_3.0_Unported_License?useformat=mobile CC BY-SA 3.0] ლიცენზიით',
	'mobile-frontend-footer-contact' => 'კონტაქტი',
	'mobile-frontend-main-menu-button-tooltip' => 'მთავარი მენიუს გახსნა',
	'mobile-frontend-main-menu-page-title' => 'საიტის ნავიგაცია',
	'mobile-frontend-main-menu-featured' => 'რჩეული',
	'mobile-frontend-main-menu-nearby' => 'სიახლოვეს',
	'mobile-frontend-main-menu-login' => 'შესვლა',
	'mobile-frontend-main-menu-logout' => 'გასვლა',
	'mobile-frontend-main-menu-watchlist' => 'კონტროლის სია',
	'mobile-frontend-main-menu-settings' => 'პარამეტრები',
	'mobile-frontend-main-menu-upload' => 'ატვირთვა',
	'mobile-frontend-main-menu-settings-heading' => 'საიტის მობილური ვერსიის პარამეტრები',
	'mobile-frontend-settings-site-header' => '{{SITENAME}} ენები',
	'mobile-frontend-main-menu-contact' => 'კონტაქტი',
	'mobile-frontend-main-menu-account-create' => 'ანგარიშის შექმნა',
	'mobile-frontend-page-menu-contents' => 'შინაარსი',
	'mobile-frontend-page-menu-language-current' => '{{#language:{{CONTENTLANG}}}}',
	'mobile-frontend-page-menu-history' => 'ისტორია',
	'mobile-frontend-meta-data-issues-header' => 'პრობლემა',
	'mobile-frontend-meta-data-issues' => 'გვერდს აქვს რაღაც პრობლემა',
	'mobile-frontend-ajax-page-loading' => 'იტვირთება $1',
	'mobile-frontend-page-saving' => 'ინახება $1',
	'mobile-frontend-nearby-title' => 'ახლოს',
	'mobile-frontend-nearby-distance-report' => '$1 კმ თქვენი მიმდინარე მდებარეობიდან',
	'mobile-frontend-nearby-lookup-error' => 'თქვენი მდებარეობის დადგენა ვერ ხერხდება. კიდევ სცადეთ..',
	'mobile-frontend-donate-image-login' => 'შედით სისტემაში რათა იხილოთ თქვენი ატვირთვები',
	'mobile-frontend-photo-upload-generic' => 'სურათის შეწირვა',
	'mobile-frontend-donate-image-title' => 'სურათის შეწირვა',
	'mobile-frontend-donate-image-heading' => 'თქვენი ბოლო ცლილებები',
	'mobile-frontend-donate-image-page-title' => 'ატვირთვა',
	'mobile-frontend-donate-image-anon' => 'ატვირთვების გვერდის სანახავად საჭიროა [[Special:UserLogin|მომხმარებლის ანგარიში]]',
	'mobile-frontend-listed-image-no-description' => 'არ არის აღწერა',
	'mobile-frontend-watchlist-add' => '$1 დაემატა თქვენი კონტროლის სიაში',
	'mobile-frontend-watchlist-removed' => '$1 წაიშალა თქვენი კონტროლის სიიდან',
	'mobile-frontend-watchlist-view' => 'თქვენი კონტროლის სიის ხილვა',
	'mobile-frontend-watchlist-more' => 'მეტი',
	'mobile-frontend-watchlist-cta' => 'გთხოვთ, შედით ან დარეგისტრირდით, რათა იხილოთ ეს გვერდი.',
	'mobile-frontend-watchlist-cta-button-login' => 'შესვლა',
	'mobile-frontend-watchlist-cta-button-signup' => 'დარეგისტრირდით',
	'mobile-frontend-watchlist-a-z' => 'ყველა',
	'mobile-frontend-watchlist-feed' => 'შეცვლილია',
	'mobile-frontend-watchlist-a-z-empty' => 'ამჟამად თქვენ არ ადევნებთ თვალს არცერთ გვერდს',
	'mobile-frontend-watchlist-a-z-empty-howto-alt' => 'დააჭირეთ გვერდის ზედა ნაწილში განთავსებულ ვარსკვლავს',
	'mobile-frontend-watchlist-a-z-empty-howto' => 'შესაძლებელია თქვენთვის საინტერესო გვერდისათვის თვალის დევნება. ამისათვის საჭიროა ეკრანის ზედა ნაწილში ვარსკვლავის სიმბოლოზე დაწკაპუნება. ეს საშუალებას მოგცემთ თვალი ადევნოთ თქვენთვის სასურველი გვერდების ცვლილებებს.',
	'mobile-frontend-watchlist-feed-empty' => 'გვერდები ბოლო ცვლილებებით არ არის',
	'mobile-frontend-watchlist-back-home' => 'უკან დაბრუნება',
	'mobile-frontend-changeslist-ip' => 'ანონიმური მომხმარებელი',
	'mobile-frontend-changeslist-nocomment' => 'არ არის რედაქტირების რეზიუმე',
	'mobile-frontend-watchlist-filter-all' => 'ყველა',
	'mobile-frontend-watchlist-filter-articles' => 'სტატია',
	'mobile-frontend-watchlist-filter-talk' => 'განხილვა',
	'mobile-frontend-watchlist-filter-other' => 'სხვა',
	'mobile-frontend-watchlist-modified' => 'შეცვლილი $1',
	'mobile-frontend-diffview-404-title' => 'ცუდი ვერსია',
	'mobile-frontend-diffview-404-desc' => 'ვერსიები თქვენი მოთხოვნილი იდენტიფიკატორით არ არსებობს',
	'mobile-frontend-diffview-title' => 'ცვლილებები',
	'mobile-frontend-diffview-editcount' => '$1 {{PLURAL:$1|რედაქტირება|რედაქტირება}}',
	'mobile-frontend-diffview-anonymous' => 'ანონიმური მომხმარებელი',
	'mobile-frontend-diffview-bytesadded' => '$1 {{PLURAL:$1|ბაიტი|ბაიტი}} დაემატა',
	'mobile-frontend-diffview-bytesremoved' => '$1 {{PLURAL:$1|ბაიტი|ბაიტი}} წაიშალა',
	'mobile-frontend-diffview-explained' => 'შემდეგი ხაზები იქნა დამატებული (+) და წაშლილი (-):',
	'mobile-frontend-table' => 'ცხრილი $1',
	'mobile-frontend-saving-exit-page' => 'თქვენი შესწორება ჯერ კიდევ ინახება. თუ თქვენ დატოვებთ გვერდს, თქვენი ცვლილებები დაიკარგება. დარწმუნებული ხართ, რომ გსურთ გასვლა?',
	'mobile-frontend-photo-upload' => 'ამ სტატიაში სურათის დამატება',
	'mobile-frontend-photo-article-edit-comment' => 'გვერდზე გამოსაყენებლად დაემატა სურათი',
	'mobile-frontend-photo-article-donate-comment' => 'შემოწირა სურათი მობილური მოწყობილობიდან',
	'mobile-frontend-photo-upload-comment' => 'გვერდზე დაემატა ფოტო',
	'mobile-frontend-photo-caption-placeholder' => 'აღწერის დამატება (სავალდებულოა)',
	'mobile-frontend-image-loading' => 'სურათი იტვირთება',
	'mobile-frontend-image-uploading-wait' => 'სურათი იტვირთება, გთხოვთ მოიცადეთ. <a href="#">გააუქმეთ</a> თუ ეს დიდხანს გაგრძელდება.',
	'mobile-frontend-image-uploading-cancel' => '<a href="#">გააუქმეთ</a> თუ ეს დიდხანს გაგრძელდება.',
	'mobile-frontend-photo-upload-error' => 'შეცდომა, კიდევ სცადეთ.',
	'mobile-frontend-photo-upload-success-article' => 'წარმატებით აიტვირთა! თქვენი სურათი ახლა უკვე განთავსებულია ამ გვერდზე.',
	'mobile-frontend-photo-license' => '"მიღებაზე" დაწკაპუნებით, თქვენ ეთანხმებით ჩვენი [//wikimediafoundation.org/wiki/Terms_of_use გამოყენების წესებს] და თანახმა ხართ თქვენი ფოტოს გადაცემაზე [//en.wikipedia.org/wiki/Wikipedia:Text_of_Creative_Commons_Attribution-ShareAlike_3.0_Unported_License Creative Common Attribution-ShareAlike 3.0 ლიცენზიით].',
	'mobile-frontend-photo-submit' => 'მიღება',
	'mobile-frontend-photo-cancel' => 'გაუქმება',
	'tag-mobile_edit' => 'რედაქტირება მობილურით',
	'tag-mobile_edit-description' => 'რედაქტირება შესრულებულია საიტის მობილური ვერსიიდან',
	'mobile-frontend-drawer-cancel' => 'გაუქმება',
);

/** Адыгэбзэ (Адыгэбзэ)
 */
$messages['kbd-cyrl'] = array(
	'mobile-frontend-search-submit' => 'ЕкIуэкIын',
	'mobile-frontend-home-button' => 'ПэщIэдзэм',
	'mobile-frontend-random-button' => 'ЗэрамыщIэкIэрэ',
	'mobile-frontend-back-to-top-of-section' => 'Зы разделкIэ къэгъэзэжын',
	'mobile-frontend-show-button' => 'Къэгъэлъэгъуэн',
	'mobile-frontend-hide-button' => 'ГъэпщкIун',
	'mobile-frontend-regular-site' => 'НапэкIуэцIым Википедиедыдэм щеплъын', # Fuzzy
	'mobile-frontend-featured-article' => 'Нобэ и статья хэхар',
);

/** Kongo (Kongo)
 * @author Dfoy
 */
$messages['kg'] = array(
	'mobile-frontend-placeholder' => 'Sosila munu na {{SITENAME}}',
	'mobile-frontend-placeholder-beta' => 'Sosila munu na {{SITENAME}} (Beta)',
);

/** Khowar (کھوار)
 * @author Rachitrali
 */
$messages['khw'] = array(
	'mobile-frontend-main-menu-watchlist' => 'مہ زیرنظرفہرست',
	'mobile-frontend-watchlist-filter-all' => 'سف',
	'mobile-frontend-watchlist-filter-articles' => 'آرٹیکل',
	'mobile-frontend-diffview-anonymous' => 'نوژان ممبار',
);

/** Kirmanjki (Kırmancki)
 */
$messages['kiu'] = array(
	'mobile-frontend-search-submit' => 'So',
	'mobile-frontend-random-button' => 'Rastamae',
	'mobile-frontend-show-button' => 'Bıasne',
	'mobile-frontend-hide-button' => 'Bınımne',
);

/** Kazakh (Cyrillic script) (қазақша (кирил)‎)
 * @author GaiJin
 * @author Kaztrans
 */
$messages['kk-cyrl'] = array(
	'mobile-frontend-desc' => 'Мобильді интерфейс',
	'mobile-frontend-search-submit' => 'Өту',
	'mobile-frontend-home-button' => 'Басты бетке',
	'mobile-frontend-random-button' => 'Кездейсоқ',
	'mobile-frontend-back-to-top-of-section' => 'Бөлімнің басына оралу',
	'mobile-frontend-show-button' => 'Көрсет',
	'mobile-frontend-hide-button' => 'Жасыр',
	'mobile-frontend-regular-site' => 'Кәдімгі нұсқа',
	'mobile-frontend-wml-continue' => 'Жалғасы...',
	'mobile-frontend-wml-back' => 'Артқа...',
	'mobile-frontend-view' => 'Мобильді нұсқа',
	'mobile-frontend-disable-images' => 'Сайттың мобильді нұсқасында суреттерді көрсетпеу',
	'mobile-frontend-enable-images' => 'Сайттың мобильді нұсқасында суреттерді көрсетпеу',
	'mobile-frontend-featured-article' => 'Таңдаулы мақала',
	'mobile-frontend-news-items' => 'Жаңалықтар',
	'mobile-frontend-leave-feedback-subject' => 'Тақырып:',
	'mobile-frontend-leave-feedback-message' => 'Мәлімдеме:',
	'mobile-frontend-leave-feedback-submit' => 'Кері байланыс',
	'mobile-frontend-feedback-no-subject' => '(тақырыпсыз)',
	'mobile-frontend-language' => 'Тілі:',
	'mobile-frontend-username' => 'Қатысушы аты:',
	'mobile-frontend-password' => 'Құпия сөз:',
	'mobile-frontend-login' => 'Кіру',
	'mobile-frontend-placeholder' => 'Іздеу жолағы...', # Fuzzy
	'mobile-frontend-dismiss-notification' => 'бұл хабарламаны жасыру',
	'mobile-frontend-clear-search' => 'Тазарту',
	'mobile-frontend-footer-sitename' => '{{SITENAME}}',
	'mobile-frontend-footer-contact' => 'Байланыс',
);

/** Kalaallisut (kalaallisut)
 */
$messages['kl'] = array(
	'mobile-frontend-search-submit' => 'Tassunngarit',
	'mobile-frontend-home-button' => 'Angerlamut',
	'mobile-frontend-random-button' => 'Nalaatsornikkut',
	'mobile-frontend-back-to-top-of-section' => 'Immikkoortup qulaanut',
	'mobile-frontend-show-button' => 'Saqqummiuk',
	'mobile-frontend-hide-button' => 'Assequt',
	'mobile-frontend-regular-site' => 'Takutiguk {{SITENAME}} naliginnaasumut', # Fuzzy
	'mobile-frontend-featured-article' => 'Allaaserisaq ullumi',
);

/** Khmer (ភាសាខ្មែរ)
 * @author Evannak
 * @author គីមស៊្រុន
 * @author វ័ណថារិទ្ធ
 */
$messages['km'] = array(
	'mobile-frontend-desc' => 'ឧបករណ៍ចល័ត',
	'mobile-frontend-search-submit' => 'ទៅ',
	'mobile-frontend-home-button' => 'ទំព័រដើម',
	'mobile-frontend-logged-out' => 'មិន​ទាន់​ចូល',
	'mobile-frontend-logged-in-homepage-notification' => 'សូមស្វាគមន៍ $1!',
	'mobile-frontend-logged-in-toast-notification' => 'ចូល​ជា $1 ។',
	'mobile-frontend-sign-up-heading' => 'ចុះ​ឈ្មោះ',
	'mobile-frontend-sign-in-heading' => 'ចូល',
	'mobile-frontend-sign-in-why' => 'បើ​អ្នក​មាន​គណនី {{SITENAME}} អ្នក​អាច​ចូល​នៅ​ខាងក្រោម ។',
	'mobile-frontend-sign-in-error-heading' => 'អូ',
	'mobile-frontend-settings-beta' => 'បេតា',
	'mobile-frontend-save-settings' => 'រក្សា​ទុក​ការ​កំណត់',
	'mobile-frontend-random-button' => 'ចៃដន្យ',
	'mobile-frontend-ajax-random-question' => 'អាន​ទំព័រ​នេះ?',
	'mobile-frontend-ajax-random-yes' => 'បាទ/ចាស',
	'mobile-frontend-ajax-random-retry' => 'ព្យាយាម​ម្ដង​ទៀត',
	'mobile-frontend-ajax-random-suggestions' => 'សំណើផ្សេងទៀត៖',
	'mobile-frontend-back-to-top-of-section' => 'លោតត្រលប់ទៅផ្នែកខាងលើរបស់ផ្នែកនេះ',
	'mobile-frontend-close-section' => 'បិទ​ផ្នែក​នេះ',
	'mobile-frontend-show-button' => 'បង្ហាញ',
	'mobile-frontend-hide-button' => 'លាក់',
	'mobile-frontend-regular-site' => 'បើកមើលលើផ្ទៃអេក្រង់លើតុ',
	'mobile-frontend-wml-continue' => 'បន្ត...',
	'mobile-frontend-wml-back' => 'ត្រលប់ក្រោយ...',
	'mobile-frontend-view' => 'មើលលើឧបករណ៍ចល័ត',
	'mobile-frontend-view-desktop' => 'លើតុ',
	'mobile-frontend-view-mobile' => 'ចល័ត',
	'mobile-frontend-opt-in-explain' => 'ដោយ​ចូលរួម​កម្មវិធី​បេតា អ្នក​នឹងមាន​លទ្ធភាព​ប្រើ​មុខងា​រដែល​កំពុង​ស្ថិតនៅក្រោម​ការពិសោធន៍​នៅឡើយ ដែល​អាចធ្វើ​អោយ​អ្នកប្រឈមមុខ​នឹង​បញ្ហា​តូចតាច​មួយចំនួន។',
	'mobile-frontend-images-status' => 'រូបភាព',
	'mobile-frontend-disable-images' => 'បិទមិនអោយមើលរូបភាពនៅលើវិបសាយសំរាប់ឧបករណ៍ចល័ត',
	'mobile-frontend-enable-images' => 'បើកអោយមើលរូបភាពនៅលើវិបសាយសំរាប់ឧបករណ៍ចល័ត',
	'mobile-frontend-missing-image' => 'រូបភាព',
	'mobile-frontend-off' => 'បិទ',
	'mobile-frontend-on' => 'បើក',
	'mobile-frontend-footer-contributors-text' => 'ទំព័រ​ដោយ <a href="$1">អ្នក​ចូលរួម</a> ដូច​ជា​អ្នក', # Fuzzy
	'mobile-frontend-featured-article' => 'អត្ថបទពិសេសសំរាប់ថ្ងៃនេះ',
	'mobile-frontend-news-items' => 'នៅក្នុងសារព័ត៌មាន',
	'mobile-frontend-leave-feedback-notice' => 'មតិយោបល់របស់អ្នកនឹងជួយយើងខ្ញុំក្នុងការកែលំអវិបសាយសំរាប់ឧបករណ៍ចល័តរបស់យើងអោយកាន់តែប្រសើរឡើង។ មតិរបស់អ្នក (ព្រមជាមួយនឹងអត្តនាម វើសិនរបស់ឧបករណ៍រាវរក និងប្រព័ន្ធប្រតិបត្តិ) នឹងត្រូវបានផ្សព្វផ្សាយជាសាធារណៈនៅលើទំព័រ &quot;$1&quot;។ សូមជ្រើសរើសពាក្យដែលមានព័ត៌មានគ្រប់គ្រាន់​សំរាប់ដាក់ជាចំណងជើង។ ឧទាហរណ៍ "បញ្ហាទំរង់របស់តារាងធំៗ"។ មតិយោបល់របស់អ្នកនឹងត្រូវបានប្រើទៅតាមលក្ខខណ្ឌនៃការប្រើប្រាស់របស់យើងខ្ញុំ។',
	'mobile-frontend-leave-feedback-warning' => 'សូមកុំសរសេរព័ត៌មានផ្ទាល់ខ្លួនរបស់អ្នកនៅក្នុងមតិយោបល់របស់អ្នក លើកលែងតែអ្នកយល់ព្រមអោយបង្ហាញព័ត៌មានទាំងនោះជាសាធារណៈ។',
	'mobile-frontend-leave-feedback-subject' => 'ប្រធានបទ​៖',
	'mobile-frontend-leave-feedback-message' => 'សារ៖',
	'mobile-frontend-leave-feedback-submit' => 'ដាក់ស្នើមតិយោបល់',
	'mobile-frontend-leave-feedback-link-text' => 'មតិយោបល់អំពី MobileFrontend Extension',
	'mobile-frontend-leave-feedback' => 'មតិយោបល់ស្ដីអំពីវិបសាយសំរាប់ឧបករណ៍ចល័ត',
	'mobile-frontend-leave-feedback-title' => 'សូមផ្ដល់មតិយោបល់អំពីវិបសាយសំរាប់ឧបករណ៍ចល័តរបស់យើងខ្ញុំ',
	'mobile-frontend-leave-feedback-technical-problem-section-header' => 'បញ្ហា​បច្ចេកទេស',
	'mobile-frontend-leave-feedback-general-section-header' => 'ទូទៅ​',
	'mobile-frontend-leave-feedback-article-feedback-section-header' => 'មតិយោបល់កែលំអអត្ថបទ',
	'mobile-frontend-leave-feedback-email-body' => 'សូមរៀបរាប់ពីបញ្ហាដែលអ្នកមានជាមួយ{{SITENAME}} ពីលើជួរអក្សរនេះ។ សូមចាំថាយើងខ្ញុំមិនអាចឆ្លើយតបទៅកាន់សារទាំងអស់ដែលយើងខ្ញុំទទួលបានទេ។',
	'mobile-frontend-leave-feedback-technical-link-text' => 'បញ្ហា​បច្ចេក​ទេស',
	'mobile-frontend-leave-feedback-form-subject-placeholder' => 'ប្រធាន​បទ​សារ',
	'mobile-frontend-leave-feedback-form-message-placeholder' => 'បញ្ចូល​មតិ​ទីនេះ',
	'mobile-frontend-leave-feedback-page-title' => 'មតិយោបល់កែលំអវិបសាយចល័ត',
	'mobile-frontend-leave-feedback-special-title' => 'ទាក់ទង​យើង​ខ្ញុំ',
	'mobile-frontend-feedback-no-subject' => '(គ្មាន​ប្រធាន​បទ)',
	'mobile-frontend-feedback-no-subject-field' => 'សូម​បញ្ចូល​ប្រធាន​បទ',
	'mobile-frontend-feedback-no-message' => 'សូម​បញ្ចូល​សារ​នេះ​ទីនេះ',
	'mobile-frontend-leave-feedback-thanks' => 'សូមអរគុណសំរាប់មតិយោបល់របស់អ្នក។',
	'mobile-frontend-language' => 'ភាសា៖',
	'mobile-frontend-language-article-heading' => 'អាន​ជា​ភាសា​ផ្សេង​ទៀត',
	'mobile-frontend-language-header' => 'ទំព័រនេះអាចអានបានជា $1 {{PLURAL:$1|ភាសា|ភាសា}}',
	'mobile-frontend-language-site-choose' => 'ស្វែងរក​ភាសា',
	'mobile-frontend-username' => 'អត្តនាម៖',
	'mobile-frontend-password' => 'ពាក្យសំងាត់៖',
	'mobile-frontend-username-placeholder' => 'ឈ្មោះ​អ្នក​ប្រើ',
	'mobile-frontend-password-placeholder' => 'ពាក្យ​សម្ងាត់',
	'mobile-frontend-login' => 'កត់ឈ្មោះចូល',
	'mobile-frontend-account-create-submit' => 'ចុះ​ឈ្មោះ',
	'mobile-frontend-password-confirm-placeholder' => 'អះអាង​ពាក្យ​សម្ងាត់',
	'mobile-frontend-account-create-email-placeholder' => 'អាសយដ្ឋានអ៊ីមែល (ដាក់ក៏បានមិនដាក់ក៏បាន)',
	'mobile-frontend-account-create-captcha-placeholder' => 'បញ្ចូល​អត្ថបទ​សុវត្ថិភាព',
	'mobile-frontend-overlay-escape' => 'ត្រឡប់​ក្រោយ',
	'mobile-frontend-placeholder' => 'ស្វែងរកក្នុង{{SITENAME}}',
	'mobile-frontend-placeholder-beta' => 'ស្វែងរកក្នុង{{SITENAME}} (បេតា)',
	'mobile-frontend-placeholder-alpha' => 'ស្វែងរកក្នុង{{SITENAME}} (ម៉ូដនាគរាជ)',
	'mobile-frontend-search-help' => 'វាយបញ្ចូលពាក្យដែលចង់ស្វែងរកខាងលើ នោះចំណងជើងទំព័រដែលត្រូ​វនឹងវានឹងបង្ហាញនៅទីនេះ។',
	'mobile-frontend-dismiss-notification' => 'បិទការផ្ដល់ដំណឹងនេះ',
	'mobile-frontend-clear-search' => 'ជំរះ',
	'mobile-frontend-privacy-link-text' => 'ភាព​ឯកជន',
	'mobile-frontend-about-link-text' => 'អំពី',
	'mobile-frontend-footer-sitename' => '{{SITENAME}}',
	'mobile-frontend-footer-contact' => 'ទំនាក់ទំនង',
	'mobile-frontend-main-menu-button-tooltip' => 'បើក​ម៉ឺនុយ​មេ',
	'mobile-frontend-main-menu-page-title' => 'ការ​រុករក​បណ្ដាញ',
	'mobile-frontend-main-menu-login' => 'ចូល',
	'mobile-frontend-main-menu-logout' => 'ចេញ',
	'mobile-frontend-main-menu-watchlist' => 'បញ្ជី​តាមដាន',
	'mobile-frontend-main-menu-settings' => 'ការ​កំណត់',
	'mobile-frontend-main-menu-upload' => 'ផ្ទុកឡើង',
	'mobile-frontend-main-menu-settings-heading' => 'ការ​កំណត់​សម្រាប់​តំបន់​បណ្ដាញ​ទូរស័ព្ទ',
	'mobile-frontend-settings-site-header' => 'ភាសារបស់ {{SITENAME}}',
	'mobile-frontend-settings-site-description' => '{{SITENAME}} អាចអានបានជាំ $1 {{PLURAL:$1|ភាសា|ភាសា}} ដូចខាងក្រោម',
	'mobile-frontend-main-menu-contact' => 'ទំនាក់ទំនង',
	'mobile-frontend-main-menu-account-create' => 'បង្កើតគណនី',
	'mobile-frontend-page-menu-contents' => 'មាតិកា',
	'mobile-frontend-page-menu-history' => 'ប្រវត្តិ',
	'mobile-frontend-meta-data-issues-header' => 'បញ្ហា',
	'mobile-frontend-meta-data-issues' => 'អត្ថបទ​នេះ​មាន​បញ្ហា​មួយ​ចំនួន', # Fuzzy
	'mobile-frontend-ajax-page-loading' => 'កំពុង​ផ្ទុក $1',
	'mobile-frontend-page-saving' => 'កំពុង​រក្សា​ទុក $1',
	'mobile-frontend-nearby-title' => 'ជិតខាង',
	'mobile-frontend-nearby-loading' => 'ផ្ទុក​ប្រធាន​បទ​ដែល​នៅ​ទីតាំង​បច្ចុប្បន្ន​របស់​អ្នក',
	'mobile-frontend-nearby-distance-report' => '$1km ពី​ទីតាំង​បច្ចុប្បន្ន​របស់​អ្នក',
	'mobile-frontend-nearby-lookup-error' => 'មិន​អាច​រក​អ្នក​ឃើញ​ទេ។ សូម​ព្យាយាម​ម្ដង​ទៀត..',
	'mobile-frontend-donate-image-login' => 'ចូល​ដើម្បី​មើល​ការ​ផ្ទុក​របស់​អ្នក',
	'mobile-frontend-photo-upload-generic' => 'បរិច្ចាគ​រូបភាព',
	'mobile-frontend-donate-image-title' => 'បរិច្ចាក​រូបភាព',
	'mobile-frontend-donate-image-page-title' => 'ផ្ទុក',
	'mobile-frontend-listed-image-no-description' => 'គ្មាន​ការ​ពណ៌នា',
	'mobile-frontend-watchlist-add' => 'បន្ថែម $1 ទៅ​បញ្ជី​មើល​របស់​អ្នក',
	'mobile-frontend-watchlist-removed' => 'បាន​យក $1 ចេញ​ពី​បញ្ជី​មើល​របស់​អ្នក',
	'mobile-frontend-watchlist-view' => 'មើល​បញ្ជី​មើល​របស់​អ្នក',
	'mobile-frontend-watchlist-more' => 'បន្ថែមទៀត',
	'mobile-frontend-watchlist-cta' => 'សូមកត់ឈ្មោះចូលឬចុះឈ្មោះថ្មីដើម្បីមើលទំព័រនេះ។',
	'mobile-frontend-watchlist-cta-button-login' => 'កត់ឈ្មោះចូល',
	'mobile-frontend-watchlist-cta-button-signup' => 'ចុះ​ឈ្មោះ',
	'mobile-frontend-watchlist-a-z' => 'ទំព័រ​ដែល​តាមដាន', # Fuzzy
	'mobile-frontend-watchlist-feed' => 'ទំព័រ​ដែល​មាន​ការ​ផ្លាស់ប្ដូរ', # Fuzzy
	'mobile-frontend-watchlist-a-z-empty' => 'អ្នក​បច្ចុប្បន្ន​មិន​កំពុង​មើល​ទំព័រ​ណា​មួយ​ទេ',
	'mobile-frontend-watchlist-back-home' => 'ត្រឡប់​ទៅ​ដើម',
	'mobile-frontend-changeslist-ip' => 'អ្នក​ប្រើ​អនាមិក',
	'mobile-frontend-changeslist-nocomment' => 'គ្មាន​ការ​សង្ខេប​កែ​សម្រួល',
	'mobile-frontend-watchlist-filter-all' => 'ទាំងអស់',
	'mobile-frontend-watchlist-filter-articles' => 'អត្ថបទ',
	'mobile-frontend-watchlist-filter-talk' => 'ការ​ពិភាក្សា',
	'mobile-frontend-watchlist-filter-other' => 'ផ្សេង​ទៀត',
	'mobile-frontend-watchlist-modified' => 'បាន​កែប្រែ​នៅ $1 មុន',
	'mobile-frontend-diffview-404-title' => 'ការ​កែប្រែ​មិន​ល្អ',
	'mobile-frontend-diffview-title' => 'ផ្លាស់ប្ដូរ',
	'mobile-frontend-diffview-anonymous' => 'អ្នក​ប្រើ​អនាមិក',
	'mobile-frontend-diffview-bytesremoved' => 'យក $1 {{PLURAL:$1|byte|bytes}} ចេញ',
	'mobile-frontend-diffview-explained' => 'បន្ទាត់​ខាងក្រោម​ត្រូវ​បាន​បន្ថែម (+) និង​យក​ចេញ (-)៖',
	'mobile-frontend-table' => 'តារាង $1',
	'mobile-frontend-photo-upload' => 'បន្ថែម​រូបភាព​ដំបូង​ទៅ​ទំព័រ​នេះ', # Fuzzy
	'mobile-frontend-photo-article-edit-comment' => 'បាន​បន្ថែម​រូបថត​សម្រាប់​ប្រើ​លើ​ទំព័រ',
	'mobile-frontend-photo-upload-comment' => 'បាន​បន្ថែម​រូបភាព​ទៅ​ទំព័រ',
	'mobile-frontend-photo-caption-placeholder' => 'បន្ថែម​ចំណង​ជើង​សម្រាប់​រូបភាព​នេះ', # Fuzzy
	'mobile-frontend-image-loading' => 'កំពុង​ផ្ទុក​រូបភាព',
	'mobile-frontend-image-uploading-wait' => 'មាន​កំហុស​កើត​ឡើង ខណៈ​ពេល​ផ្ទុក​រូបភាព​នេះ​ឡើង', # Fuzzy
	'mobile-frontend-photo-upload-error' => 'មាន​កំហុស​កើត​ឡើង ខណៈ​កំពុង​ផ្ទុក​រូបភាព ។ សូម​សាកល្បង​រូបភាព​ផ្សេង​ទៀត ។', # Fuzzy
	'mobile-frontend-photo-submit' => 'ដាក់​ស្នើ',
	'mobile-frontend-photo-cancel' => 'បោះបង់',
	'tag-mobile_edit' => 'កែ​សម្រួល​តាម​ទូរស័ព្ទ',
	'tag-mobile_edit-description' => 'ការ​កែ​សម្រួល​បាន​ធ្វើ​ពី​តំបន់​បណ្ដាញ​សម្រាប់​ទូរស័ព្ទ',
	'mobile-frontend-drawer-cancel' => 'បោះបង់',
);

/** Kannada (ಕನ್ನಡ)
 * @author M G Harish
 * @author Nayvik
 * @author VASANTH S.N.
 */
$messages['kn'] = array(
	'mobile-frontend-desc' => 'ಮೊಬೈಲ್ ಮುನ್ನೆಲೆ',
	'mobile-frontend-search-submit' => 'ಹೋಗು',
	'mobile-frontend-home-button' => 'ಮುಖ್ಯಪುಟ',
	'mobile-frontend-random-button' => 'ಹೀಗೇ ಒಂದು ಪುಟ',
	'mobile-frontend-back-to-top-of-section' => 'ಒಂದು ವಿಭಾಗ ಹಿಂದಕ್ಕೆ ಹೋಗಿ',
	'mobile-frontend-show-button' => 'ತೋರಿಸು',
	'mobile-frontend-hide-button' => 'ಮರೆ ಮಾಡಿ',
	'mobile-frontend-regular-site' => 'ಮುಂತೆರೆ ನೋಟ',
	'mobile-frontend-wml-continue' => 'ಮುಂದುವರೆಸು...',
	'mobile-frontend-wml-back' => 'ಹಿಂದೆ...',
	'mobile-frontend-view' => 'ಮೊಬೈಲ್ ವೀಕ್ಷಣೆ',
	'mobile-frontend-opt-in-explain' => 'ಬೀಟಾವನ್ನು ಸೇರುವುದರಿಂದ, ದೋಷಗಳು ಮತ್ತು ವಿವಾದಾಂಶಗಳ ಅಪಾಯದೊಂದಿಗೆ, ನೀವು ಪ್ರಾಯೋಗಿಕ ವೈಶಿಷ್ಟ್ಯಗಳನ್ನು ಪಡೆಯುವಿರಿ.',
	'mobile-frontend-disable-images' => 'ಮೊಬೈಲ್ ಜಾಲತಾಣದಲ್ಲಿ ಚಿತ್ರಗಳನ್ನು ಅಡಗಿಸು',
	'mobile-frontend-enable-images' => 'ಮೊಬೈಲ್ ಜಾಲತಾಣದಲ್ಲಿ ಚಿತ್ರಗಳನ್ನು ತೋರಿಸು',
	'mobile-frontend-featured-article' => 'ಇಂದಿನ ವಿಶೇಷ ಲೇಖನ',
	'mobile-frontend-news-items' => 'ಸುದ್ದಿಯಲ್ಲಿ',
	'mobile-frontend-leave-feedback-notice' => 'ನಿಮ್ಮ ಮರುಮಾಹಿತಿ ನಿಮ್ಮ ಮೊಬೈಲ್ ಜಾಲತಾಣದ ಅನುಭವವನ್ನು ಉತ್ತಮಗೊಳಿಸಲು ನಮಗೆ ಸಹಕರಿಸುತ್ತದೆ. ಇದನ್ನು (ನಿಮ್ಮ ಹೆಸರು, ಜಾಲ ವೀಕ್ಷಕದ ಆವೃತ್ತಿ ಮತ್ತು ಕಾರ್ಯಾಚರಣೆ ವ್ಯವಸ್ಥೆಯ ಜೊತೆ) ಸಾರ್ವಜನಿಕವಾಗಿ &quot;$1&quot; ಪುಟದಲ್ಲಿ ಪ್ರಕಟಿಸಲಾಗುತ್ತದೆ. ದಯವಿಟ್ಟು ಮಾಹಿತಿಪೂರ್ಣ ವಿಷಯವನ್ನು ಸೂಚಿಸಿ. ಉದಾ: "ಕೋಷ್ಟಕಗಳ ವಿನ್ಯಾಸದಲ್ಲಿ ತೊಂದರೆ". ನಿಮ್ಮ ಮರುಮಾಹಿತಿಯು ನಮ್ಮ ಬಳಕೆಯ ನಿಬಂಧನೆಗಳಿಗೊಳಪಟ್ಟಿರುತ್ತದೆ.',
	'mobile-frontend-leave-feedback-subject' => 'ವಿಷಯ', # Fuzzy
	'mobile-frontend-leave-feedback-message' => 'ಸಂದೇಶ', # Fuzzy
	'mobile-frontend-leave-feedback-submit' => 'ಮರುಮಾಹಿತಿ ಕಳಿಸಿ',
	'mobile-frontend-leave-feedback-link-text' => 'MobileFrontend  ವಿಸ್ತರಣೆ ಬಗ್ಗೆ ಮರುಮಾಹಿತಿ',
	'mobile-frontend-leave-feedback' => 'ಮೊಬೈಲ್ ಜಾಲತಾಣ ಮರುಮಾಹಿತಿ',
	'mobile-frontend-leave-feedback-title' => 'ಮೊಬೈಲ್ ಜಾಲತಾಣದ ಬಗ್ಗೆ ನಿಮ್ಮ ಅನುಭವವನ್ನು ನಮಗೆ ತಿಳಿಸಿ',
	'mobile-frontend-leave-feedback-page-title' => 'ಮೊಬೈಲ್ ಜಾಲತಾಣದ ಬಗ್ಗೆ ನಿಮ್ಮ ಅನುಭವವನ್ನು ನಮಗೆ ತಿಳಿಸಿ',
	'mobile-frontend-leave-feedback-thanks' => 'ನಿಮ್ಮ ಮರುಮಾಹಿತಿಗಾಗಿ ಧನ್ಯವಾದ!',
	'mobile-frontend-language' => 'ಭಾಷೆ', # Fuzzy
	'mobile-frontend-username' => 'ಬಳಕೆದಾರ ಹೆಸರು:',
	'mobile-frontend-password' => 'ಪ್ರವೇಶಪದ:',
	'mobile-frontend-login' => 'ಒಳ ಬಾ',
	'mobile-frontend-placeholder' => 'ನಿಮ್ಮ ಹುಡುಕಾಟವನ್ನು ಇಲ್ಲಿ ನಮೂದಿಸಿ...', # Fuzzy
	'mobile-frontend-dismiss-notification' => 'ಈ ಅಧಿಸೂಚನೆಯನ್ನು ತೊಡೆದುಹಾಕಿ',
	'mobile-frontend-clear-search' => 'ಅಳಿಸಿ',
);

/** Korean (한국어)
 * @author Altostratus
 * @author Klutzy
 * @author Kwj2772
 * @author SEVEREN
 * @author 관인생략
 * @author 아라
 */
$messages['ko'] = array(
	'mobile-frontend-desc' => '모바일 프론트엔드',
	'mobile.css' => '/* 이 CSS 설정은 모바일 사이트를 사용하는 사용자에게 적용됩니다 */',
	'mobile.js' => '/* 이 자바스크립트 설정은 모바일 사이트를 사용하는 사용자에게 적용됩니다 */',
	'mobile-frontend-search-submit' => '가기',
	'mobile-frontend-home-button' => '대문',
	'mobile-frontend-logged-out' => '로그인하지 않음',
	'mobile-frontend-logged-in-homepage-notification' => '$1, 환영합니다!',
	'mobile-frontend-logged-in-toast-notification' => '$1 사용자로 로그인했습니다.',
	'mobile-frontend-sign-up-heading' => '가입하기',
	'mobile-frontend-sign-in-heading' => '로그인',
	'mobile-frontend-sign-in-why' => '{{SITENAME}} 계정이 있으면 아래에 로그인할 수 있습니다.',
	'mobile-frontend-sign-in-error-heading' => '이런',
	'mobile-frontend-settings-description' => '이러한 모바일 특정 사이트 설정을 사용하여 모바일 기기에서 내 경험을 사용자 정의합니다.',
	'mobile-frontend-settings-beta' => '베타',
	'mobile-frontend-settings-alpha' => '[//en.wikipedia.org/wiki/Here_be_dragons Here be dragons] 모드',
	'mobile-frontend-settings-alpha-description' => '위험하고 미개척한 모바일 영역에 들어갑니다. 더 많은 실험 중인 기능을 사용할 수 있지만 더 많은 버그 위험이 따릅니다.',
	'mobile-frontend-save-settings' => '설정 저장',
	'mobile-frontend-random-button' => '임의 문서',
	'mobile-frontend-ajax-random-heading' => '지식 찾기...',
	'mobile-frontend-ajax-random-quote' => '지적 성장은 출생할 때만 시작하고 죽을 때만 중단해야 합니다',
	'mobile-frontend-ajax-random-quote-author' => '알베르트 아인슈타인',
	'mobile-frontend-ajax-random-question' => '이 문서를 읽을까요?',
	'mobile-frontend-ajax-random-yes' => '예',
	'mobile-frontend-ajax-random-retry' => '다시 시도하세요',
	'mobile-frontend-ajax-random-suggestions' => '다른 제안:',
	'mobile-frontend-back-to-top-of-section' => '문단 처음으로',
	'mobile-frontend-close-section' => '이 문단 닫기',
	'mobile-frontend-show-button' => '보이기',
	'mobile-frontend-hide-button' => '숨기기',
	'mobile-frontend-empty-homepage-text' => '이 홈페이지는 재구성해야 합니다. [//meta.wikimedia.org/wiki/Mobile_Projects/Mobile_Gateway#Mobile_homepage 이 사이트를 모바일로 활성화하는 방법에 대한 지침]',
	'mobile-frontend-regular-site' => '데스크톱 버전',
	'mobile-frontend-wml-continue' => '계속...',
	'mobile-frontend-wml-back' => '뒤로...',
	'mobile-frontend-view' => '모바일판에서 보기',
	'mobile-frontend-view-desktop' => '데스크탑',
	'mobile-frontend-view-mobile' => '모바일',
	'mobile-frontend-opt-in-explain' => '베타에 참여하면서, 버그나 문제가 생길 위험을 감수하고 실험 중인 기능을 사용해볼 수 있습니다.',
	'mobile-frontend-images-status' => '그림',
	'mobile-frontend-disable-images' => '그림을 표시하지 않도록 설정',
	'mobile-frontend-enable-images' => '그림을 표시하도록 설정',
	'mobile-frontend-missing-image' => '그림',
	'mobile-frontend-off' => '끄기',
	'mobile-frontend-on' => '켜기',
	'mobile-frontend-footer-contributors-text' => '여러분과 같은 [$1 사용자]가 기여한 문서입니다',
	'mobile-frontend-featured-article' => '오늘의 알찬 글',
	'mobile-frontend-news-items' => '새로 들어온 소식',
	'mobile-frontend-leave-feedback-notice' => '당신의 피드백이 모바일 사이트를 개선하는 데 도움이 됩니다. 피드백은 당신의 사용자 이름, 브라우저 버전과 운영 체제 정보와 함께 &quot;$1&quot; 문서에 공개적으로 게시될 것입니다. 제목에 도움이 되는 정보를 입력해주세요. 예를 들면 "넓은 표에 관한 문제"라고 쓸 수 있습니다. 당신의 피드백은 이용 규약의 적용을 받습니다.',
	'mobile-frontend-leave-feedback-warning' => '당신의 정보를 대중에 공개하는 것에 대해 동의하셨다면, 개인 정보를 어떠한 의견에도 담지 말아 주십시오.',
	'mobile-frontend-leave-feedback-subject' => '제목:',
	'mobile-frontend-leave-feedback-message' => '메시지:',
	'mobile-frontend-leave-feedback-submit' => '피드백 보내기',
	'mobile-frontend-leave-feedback-link-text' => '모바일 프론트엔드 확장 기능 피드백',
	'mobile-frontend-leave-feedback' => '모바일 사이트 피드백',
	'mobile-frontend-leave-feedback-title' => '모바일 사이트 피드백',
	'mobile-frontend-leave-feedback-technical-problem-section-header' => '기술적인 문제',
	'mobile-frontend-leave-feedback-general-section-header' => '일반',
	'mobile-frontend-leave-feedback-article-feedback-section-header' => '문서 평가',
	'mobile-frontend-leave-feedback-email-body' => '이 선 위에 {{SITENAME}}에서 발생하는 문제를 설명하세요. 우리가 받은 메시지에 회신할 수는 없습니다.',
	'mobile-frontend-leave-feedback-technical-link-text' => '기술적인 문제',
	'mobile-frontend-leave-feedback-general-link-text' => '일반적인 피드백',
	'mobile-frontend-leave-feedback-article-personal-link-text' => '나, 사람, 또는 회사에 대해',
	'mobile-frontend-leave-feedback-article-factual-link-text' => '사실적인 오류에 대해',
	'mobile-frontend-leave-feedback-article-other-link-text' => '다른 문제에 대해',
	'mobile-frontend-leave-feedback-form-subject-placeholder' => '메시지 주제',
	'mobile-frontend-leave-feedback-form-message-placeholder' => '이 곳에 의견을 남겨주세요.',
	'mobile-frontend-leave-feedback-page-title' => '모바일 사이트 피드백',
	'mobile-frontend-feedback-page' => 'Project:모바일 확장 기능 피드백',
	'mobile-frontend-leave-feedback-special-title' => '문의하기',
	'mobile-frontend-feedback-no-subject' => '(제목 없음)',
	'mobile-frontend-feedback-no-subject-field' => '제목을 입력해주세요',
	'mobile-frontend-feedback-no-message' => '여기에 메시지를 입력하세요',
	'mobile-frontend-feedback-edit-summary' => '$1 - [[Special:MobileFeedback|모바일 피드백 도구]]를 통해 자동으로 게시됨',
	'mobile-frontend-leave-feedback-thanks' => '피드백해 주셔서 감사합니다!',
	'mobile-frontend-leave-feedback-post-error' => '메시지를 처리하는 동안 오류가 발생했습니다. 나중에 다시 시도하세요.',
	'mobile-frontend-language' => '언어:',
	'mobile-frontend-language-article-heading' => '다른 언어로 읽기',
	'mobile-frontend-language-header' => '이 문서는 $1개 {{PLURAL:$1|언어}}로 읽을 수 있습니다.',
	'mobile-frontend-language-variant-header' => '{{#language:{{CONTENTLANG}}}} 언어 변종을 선택하세요',
	'mobile-frontend-language-footer' => '참고: 이 문서는 선호하는 언어로 쓰여지지 않았을 수 있습니다. 여기를 클릭하여 {{SITENAME}}에서 지원하는 언어를 볼 수 있습니다.',
	'mobile-frontend-language-site-choose' => '언어 찾기',
	'mobile-frontend-username' => '사용자 이름:',
	'mobile-frontend-password' => '비밀번호:',
	'mobile-frontend-username-placeholder' => '사용자 이름',
	'mobile-frontend-password-placeholder' => '비밀번호',
	'mobile-frontend-login' => '로그인',
	'mobile-frontend-last-modified-date' => '$1 $2에 마지막으로 수정함',
	'mobile-frontend-last-modified-seconds' => '{{PLURAL:$1|$1초}} 전에 마지막으로 수정함',
	'mobile-frontend-last-modified-minutes' => '{{PLURAL:$1|$1분}} 전에 마지막으로 수정함',
	'mobile-frontend-last-modified-hours' => '{{PLURAL:$1|$1시간}} 전에 마지막으로 수정함',
	'mobile-frontend-last-modified-days' => '{{PLURAL:$1|$1일}} 전에 마지막으로 수정함',
	'mobile-frontend-last-modified-months' => '{{PLURAL:$1|$1월}} 전에 마지막으로 수정함',
	'mobile-frontend-last-modified-years' => '{{PLURAL:$1|$1년}} 전에 마지막으로 수정함',
	'mobile-frontend-account-create-submit' => '가입하기',
	'mobile-frontend-password-confirm-placeholder' => '비밀번호 확인',
	'mobile-frontend-account-create-email-placeholder' => '이메일 주소 (선택 사항)',
	'mobile-frontend-account-create-captcha-placeholder' => '보안 문자를 입력하세요',
	'mobile-frontend-overlay-escape' => '돌아가기',
	'mobile-frontend-placeholder' => '{{SITENAME}} 찾기',
	'mobile-frontend-placeholder-beta' => '{{SITENAME}} 찾기 (베타)',
	'mobile-frontend-placeholder-alpha' => '{{SITENAME}} 찾기 (Dragon 모드)',
	'mobile-frontend-search-help' => '위의 검색어를 입력하여 문서 제목과 일치하는 것은 여기에 표시됩니다.',
	'mobile-frontend-dismiss-notification' => '이 알림 숨기기',
	'mobile-frontend-clear-search' => '지우기',
	'mobile-frontend-privacy-link-text' => '개인정보 정책',
	'mobile-frontend-about-link-text' => '소개',
	'mobile-frontend-footer-sitename' => '{{SITENAME}}',
	'mobile-frontend-footer-license-text' => '모든 문서는 [//ko.m.wikipedia.org/w/index.php?title=%EC%9C%84%ED%82%A4%EB%B0%B1%EA%B3%BC:Creative_Commons_Attribution-ShareAlike_3.0_Unported_License&mobileaction=toggle_view_mobile 크리에이티브 커먼즈 저작자표시-동일조건변경허락 3.0]에 따라 사용할 수 있습니다.',
	'mobile-frontend-terms-use-text' => '[//wikimediafoundation.org/wiki/Terms_of_use?useformat=mobile 이용 약관]',
	'mobile-frontend-footer-contact' => '연락하기',
	'mobile-frontend-search-noresults' => '찾기 결과와 일치하는 문서를 찾지 못했습니다. 검색어을 바꾸거나, 키보드의 찾기 단추를 누르면 본문 내용을 검색합니다.',
	'mobile-frontend-main-menu-button-tooltip' => '주 메뉴 열기',
	'mobile-frontend-main-menu-page-title' => '사이트 둘러보기',
	'mobile-frontend-main-menu-featured' => '알참',
	'mobile-frontend-main-menu-nearby' => '근처',
	'mobile-frontend-main-menu-login' => '로그인',
	'mobile-frontend-main-menu-logout' => '로그아웃',
	'mobile-frontend-main-menu-watchlist' => '주시문서 목록',
	'mobile-frontend-main-menu-settings' => '설정',
	'mobile-frontend-main-menu-upload' => '올리기', # Fuzzy
	'mobile-frontend-main-menu-settings-heading' => '모바일 사이트 설정',
	'mobile-frontend-settings-site-header' => '{{SITENAME}} 언어',
	'mobile-frontend-settings-site-description' => '{{SITENAME}}(은)는 언어 $1개로 읽을 수 있습니다. 읽을 수 있는 모든 버전은 다음과 같습니다',
	'mobile-frontend-main-menu-contact' => '연락하기',
	'mobile-frontend-main-menu-account-create' => '계정 만들기',
	'mobile-frontend-page-menu-contents' => '목차',
	'mobile-frontend-page-menu-history' => '역사',
	'mobile-frontend-meta-data-issues-header' => '문제',
	'mobile-frontend-meta-data-issues' => '이 문서에 문제가 있습니다',
	'mobile-frontend-ajax-page-loading' => '$1 불러오는 중',
	'mobile-frontend-page-saving' => '$1 저장 중',
	'mobile-frontend-ajax-page-error' => '이런! 뭔가가 잘못됐습니다. 브라우저 창을 새로 고쳐보세요.',
	'mobile-frontend-nearby-title' => '근처',
	'mobile-frontend-nearby-loading' => '현재 위치 근처에 주제를 불러오는 중',
	'mobile-frontend-nearby-requirements' => '이 문서는 자바스크립트와 위치 인식 브라우저 모두 필요합니다.',
	'mobile-frontend-nearby-distance-report' => '현재 위치에서 $1km',
	'mobile-frontend-nearby-lookup-error' => '찾을 수 없습니다. 다시 시도하세요.',
	'mobile-frontend-nearby-noresults' => '어딘지 모를 한가운데에 어떠한 주제도 찾을 수 없습니다. 문서를 써보지 않겠습니까?',
	'mobile-frontend-nearby-refresh' => '정확한 위치를 찾았습니다. 근처 문서의 목록을 새로 고치려면 여기를 클릭하세요',
	'mobile-frontend-nearby-error' => '근처에 문서를 찾는 동안 예기치 않은 오류가 발생했습니다',
	'mobile-frontend-donate-image-login' => '내 올리기를 보려면 로그인해야 합니다.',
	'mobile-frontend-photo-upload-generic' => '그림 기부',
	'mobile-frontend-donate-image-title' => '그림 기부',
	'mobile-frontend-donate-image-summary' => '사진은 {{SITENAME}}에 있는 문서에 생명을 가져다 줍니다.
자유롭게 허가한 사진이 심각하게 부족하기 때문에 사진이 없는 문서가 많이 있습니다.
나눠주고자 하는 그림을 기부하면 이 문서에 생명을 가져다주는 데 도음이 되고 넓은 {{SITENAME}} 편집 공동체에 사용할 수 있습니다.',
	'mobile-frontend-donate-image-heading' => '내 최근 기여',
	'mobile-frontend-donate-image-page-title' => '올리기',
	'mobile-frontend-donate-image-anon' => '올리기 문서를 보려면 [[Special:UserLogin|사용자 계정]]이 필요합니다',
	'mobile-frontend-listed-image-no-description' => '설명 없음',
	'mobile-frontend-donate-photo-upload-success' => '성공했습니다! 그림은 이제 {{SITENAME}}에 사용할 수 있습니다!',
	'mobile-frontend-donate-photo-first-upload-success' => '성공했습니다! 첫 기여를 해주셔서 감사합니다!',
	'mobile-frontend-watchlist-add' => '내 주시문서 목록에 $1 문서를 추가했습니다',
	'mobile-frontend-watchlist-removed' => '내 주시문서 목록에서 $1 문서를 제거했습니다',
	'mobile-frontend-watchlist-view' => '내 주시문서 목록 보기',
	'mobile-frontend-watchlist-more' => '더 보기',
	'mobile-frontend-watchlist-cta' => '이 문서를 주시하려면 로그인하거나 가입하세요.',
	'mobile-frontend-watchlist-cta-button-login' => '로그인',
	'mobile-frontend-watchlist-cta-button-signup' => '가입하기',
	'mobile-frontend-watch-login' => '문서를 주시하려면 로그인해야 합니다.',
	'mobile-frontend-watchlist-a-z' => '모두',
	'mobile-frontend-watchlist-feed' => '수정됨',
	'mobile-frontend-watchlist-a-z-empty' => '현재 어떠한 문서도 주시하지 않았습니다',
	'mobile-frontend-watchlist-a-z-empty-howto-alt' => '문서의 위에 별을 클릭하세요',
	'mobile-frontend-watchlist-a-z-empty-howto' => '화면의 위에 별 아이콘을 클릭하여 흥미로움을 찾은 문서를 주시하세요. 문서가 바뀌었을 때 뿐만 아니라 볼 관심 있는 문서를 북마크에 추가합니다.',
	'mobile-frontend-watchlist-feed-empty' => '최근 바뀐 문서가 없습니다',
	'mobile-frontend-watchlist-back-home' => '대문으로 돌아가기',
	'mobile-frontend-changeslist-ip' => '익명 사용자',
	'mobile-frontend-changeslist-nocomment' => '편집 요약 없음',
	'mobile-frontend-watchlist-filter-all' => '모두',
	'mobile-frontend-watchlist-filter-articles' => '문서',
	'mobile-frontend-watchlist-filter-talk' => '토론',
	'mobile-frontend-watchlist-filter-other' => '기타',
	'mobile-frontend-watchlist-modified' => '$1에 수정함',
	'mobile-frontend-diffview-404-title' => '잘못된 판',
	'mobile-frontend-diffview-404-desc' => '요청한 판에 대한 id가 존재하지 않습니다',
	'mobile-frontend-diffview-title' => '바뀜',
	'mobile-frontend-diffview-editcount' => '편집 $1회',
	'mobile-frontend-diffview-anonymous' => '익명 사용자',
	'mobile-frontend-diffview-bytesadded' => '$1 {{PLURAL:$1|바이트}} 추가함',
	'mobile-frontend-diffview-bytesremoved' => '$1 {{PLURAL:$1|바이트}} 제거함',
	'mobile-frontend-diffview-explained' => '다음 줄이 추가(+)되고 제거(-)되었습니다.',
	'mobile-frontend-table' => '표 $1',
	'mobile-frontend-saving-exit-page' => '기여한 내용을 아직 저장하고 있습니다. 만일 떠나면 기여한 내용을 잃게 됩니다. 정말 끝내시겠습니까?',
	'mobile-frontend-photo-upload' => '이 문서에 그림 추가',
	'mobile-frontend-photo-article-edit-comment' => '문서에 사용할 사진을 추가했습니다',
	'mobile-frontend-photo-article-donate-comment' => '모바일에서 그림을 기부함',
	'mobile-frontend-photo-upload-comment' => '문서에 사진을 추가했습니다',
	'mobile-frontend-photo-caption-placeholder' => '설명 추가 (필수)',
	'mobile-frontend-image-loading' => '그림을 불러오는 중',
	'mobile-frontend-image-uploading-wait' => '그림을 올리는 중입니다, 기다려 주세요.',
	'mobile-frontend-image-uploading-long' => '그림은 아직 올리고 있습니다! 조금만 더 기다려 주세요.',
	'mobile-frontend-image-uploading-cancel' => '시간이 너무 오래 걸리면 <a href="#">취소</a>하세요.',
	'mobile-frontend-photo-upload-error' => '오류가 발생했습니다, 다시 시도하세요.',
	'mobile-frontend-photo-upload-success-article' => '성공했습니다! 그림은 지금 이 문서에 있습니다.',
	'mobile-frontend-photo-license' => '"제출"을 클릭하면 [//wikimediafoundation.org/wiki/Terms_of_use 이용 약관]에 동의하고 [//en.wikipedia.org/wiki/Wikipedia:Text_of_Creative_Commons_Attribution-ShareAlike_3.0_Unported_License 크리에이티브 커먼즈 저작자표시-동일조건변경허락 3.0 라이선스]에 따라 사진을 공개하는 데 동의합니다.',
	'mobile-frontend-photo-submit' => '제출',
	'mobile-frontend-photo-cancel' => '취소',
	'mobile-frontend-photo-upload-user-count' => '{{PLURAL:$1|올리기 1회|올리기 $1회}}',
	'mobile-frontend-photo-upload-user-count-over-limit' => '올리기 500회 초과',
	'tag-mobile_edit' => '모바일 편집',
	'tag-mobile_edit-description' => '모바일 사이트에서 편집',
	'mobile-frontend-drawer-cancel' => '취소',
);

/** Karachay-Balkar (къарачай-малкъар)
 * @author Iltever
 */
$messages['krc'] = array(
	'mobile-frontend-desc' => 'Мобил интерфейс',
	'mobile-frontend-search-submit' => 'Бар',
	'mobile-frontend-home-button' => 'Юйге',
	'mobile-frontend-logged-out' => 'Авторизацияны ётмегенсиз',
	'mobile-frontend-sign-in-heading' => 'Кириў',
	'mobile-frontend-sign-in-why' => '{{SITENAME}} сайтда тергеў джазыўугъуз (аккаунтугъуз) бар эсе, тюбюндеги форманы толтуруб, сайтха кирирге боллукъсуз.',
	'mobile-frontend-sign-in-error-heading' => 'Халат',
	'mobile-frontend-settings-description' => 'Сайтха мобил аппаратыгъызда къараў табыракъ болур ючюн мобил версияны бу энчи джарашдырыўларын хайырланыдырыгъыз.',
	'mobile-frontend-settings-beta' => 'Бета-версия',
	'mobile-frontend-save-settings' => 'Джарашдырыўланы сакъла',
	'mobile-frontend-random-button' => 'Эсде болмагъан бет',
	'mobile-frontend-ajax-random-heading' => 'Билги излеў...',
	'mobile-frontend-ajax-random-quote' => 'Интеллектуал ёсюў, туўгъан сагъатда башланыб, къуру аўушхан сагъатда таўусулургъа тыйыншлыды',
	'mobile-frontend-ajax-random-question' => 'Бу статьяны окъуймуса?', # Fuzzy
	'mobile-frontend-ajax-random-yes' => 'Хоў',
	'mobile-frontend-ajax-random-retry' => 'Джангыдан кёр',
	'mobile-frontend-back-to-top-of-section' => 'Бир бёлюмге артха атла',
	'mobile-frontend-close-section' => 'Бу бёлюмню джаб',
	'mobile-frontend-show-button' => 'Кёргюз',
	'mobile-frontend-hide-button' => 'Джашыр',
	'mobile-frontend-empty-homepage-text' => 'Бу баш бет джарашдырылыргъа керекди. <a href="http://meta.wikimedia.org/wiki/Mobile_Projects/Mobile_Gateway#Mobile_homepage">Сайтны мобил версиясын къураргъа юретген инструкция</a>', # Fuzzy
	'mobile-frontend-regular-site' => 'Тюз Википедияда къара бетге',
	'mobile-frontend-wml-continue' => 'Мындан арысы ...',
	'mobile-frontend-wml-back' => 'Артха ...',
	'mobile-frontend-view' => 'Мобил версия',
	'mobile-frontend-view-desktop' => 'Стационар',
	'mobile-frontend-view-mobile' => 'Мобил',
	'mobile-frontend-opt-in-explain' => 'Бета-тест этиўге къошулсагъыз, талай экспериментал функцияны хайырландырыргъа эркинлик берилликди, алай а халатха неда проблемагъа тюберге къоркъуў ёсерикди.',
	'mobile-frontend-images-status' => 'Суратла',
	'mobile-frontend-disable-images' => 'Мобил сайтда суратла кёрюнмезча эт',
	'mobile-frontend-enable-images' => 'Мобил сайтда суратла кёрюнюрча эт',
	'mobile-frontend-missing-image' => 'Сурат',
	'mobile-frontend-off' => 'ДЖУКЪЛ',
	'mobile-frontend-on' => 'ДЖАНД',
	'mobile-frontend-footer-contributors-text' => '<a href="$1">Бу статьяны авторлары</a> — кеслерини разылыкълары бла ишлеген, сизге ушагъан адамладыла', # Fuzzy
	'mobile-frontend-featured-article' => 'Бюгюннгю сайланнган статья',
	'mobile-frontend-news-items' => 'Джангылыкълада',
	'mobile-frontend-leave-feedback-notice' => 'Сизни оюмугъуз, мобил сайтны хайырланыўун игилендирирге болушурукъду. Ол, &quot;$1&quot; бетде адамлагъа ачыкъ (къошулуўчу атыгъыз бла, браўзеригизни версиясы бла эм операцион системагъыз бла) публикация этилликди. Тилейбиз, информациялы сюжет ызны сайларгъа кюрешигиз, сёз ючюн «кенг таблицаланы къураўда соруўла». Сизни оюмугъуз, хайырланыў шартлагъа келиширге керекди.',
	'mobile-frontend-leave-feedback-warning' => 'Тилейбиз, комментарийлеригизде персонал информациягъызны джазмагъыз, аны публикация этиллигине разы тюл эсегиз.',
	'mobile-frontend-leave-feedback-subject' => 'Тема:',
	'mobile-frontend-leave-feedback-message' => 'Билдириў:',
	'mobile-frontend-leave-feedback-submit' => 'Оюмунгу джибер',
	'mobile-frontend-leave-feedback-link-text' => 'Мобил интерфейсни юсюнден оюм',
	'mobile-frontend-leave-feedback' => 'Оюмунгу къой',
	'mobile-frontend-leave-feedback-title' => 'Сайтны мобил версиясыны юсюнден оюм',
	'mobile-frontend-leave-feedback-technical-problem-section-header' => 'Техника проблема',
	'mobile-frontend-leave-feedback-general-section-header' => 'Баш',
	'mobile-frontend-leave-feedback-article-feedback-section-header' => 'Статьягъа багъа бичиў',
	'mobile-frontend-leave-feedback-email-body' => 'Бу ызны башы бла {{SITENAME}} сайтда тюбеген проблемагъызны ачыкълагъыз. Хар джазгъаннга да джуўаб бериб баралмагъаныбызны да эсде тутугъуз.',
	'mobile-frontend-leave-feedback-technical-link-text' => 'Техника проблема',
	'mobile-frontend-leave-feedback-general-link-text' => 'Орта къайтхан байлам',
	'mobile-frontend-leave-feedback-article-personal-link-text' => 'Мени юсюмден, неда мен келечиси болгъан адамны (компанияны) юсюнден информация бла байламлы',
	'mobile-frontend-leave-feedback-article-factual-link-text' => 'Фактха кёре халат бла байламлы',
	'mobile-frontend-leave-feedback-article-other-link-text' => 'Башха проблема бла байламлы',
	'mobile-frontend-leave-feedback-form-subject-placeholder' => 'Билдириўню темасы',
	'mobile-frontend-leave-feedback-form-message-placeholder' => 'Былайда комментарийигизни джазагъыз',
	'mobile-frontend-leave-feedback-page-title' => 'Сайтны мобил версиясыны юсюнден оюм',
	'mobile-frontend-leave-feedback-special-title' => 'Бизни бла байламлы болугъуз',
	'mobile-frontend-feedback-no-subject' => '(темасыз)',
	'mobile-frontend-feedback-no-subject-field' => 'Теманы билдиригиз',
	'mobile-frontend-feedback-no-message' => 'Былайда билдириўюгюзню джазыгъыз',
	'mobile-frontend-feedback-edit-summary' => '$1, [[Special:MobileFeedback|къайтарыў байламны мобил инструментини]] юсю бла автомат халда публикация этилди',
	'mobile-frontend-leave-feedback-thanks' => 'Оюмугъуз ючюн саў болугъуз!',
	'mobile-frontend-leave-feedback-post-error' => 'Сизни билдириўюгюзню джарашдыргъан сагъатда халат болду. Кечирек джангыдан кёрюрсюз.',
	'mobile-frontend-language' => 'Тил:',
	'mobile-frontend-language-article-heading' => 'Башха тилде окъу',
	'mobile-frontend-language-header' => 'Бу статьяны $1 {{PLURAL:$1|тилде}} версиясы барды', # Fuzzy
	'mobile-frontend-language-footer' => 'Статья, сизни кёзюгюз къарагъан тилде джазылмагъан болургъа боллукъду. Былайгъа басыб, {{SITENAME}}ны къайсы тилледе версиялары болгъанын кёрюрге боллукъду.', # Fuzzy
	'mobile-frontend-language-site-choose' => 'Тилни изле',
	'mobile-frontend-username' => 'Къошулуучуну аты:',
	'mobile-frontend-password' => 'Паролюгъуз:',
	'mobile-frontend-login' => 'Кир',
	'mobile-frontend-placeholder' => '{{SITENAME}}да изле',
	'mobile-frontend-placeholder-beta' => '{{SITENAME}}да (Бета) изле',
	'mobile-frontend-search-help' => 'Башыракъда изленнген терминни джаз эм былайда аннга келишген статья атла кёрюннюкдюле.', # Fuzzy
	'mobile-frontend-dismiss-notification' => 'бу билдириуню джашыр',
	'mobile-frontend-clear-search' => 'Кетер',
	'mobile-frontend-privacy-link-text' => 'Конфиденциаллыкъ',
	'mobile-frontend-about-link-text' => 'Ачыкълау',
	'mobile-frontend-footer-sitename' => '{{SITENAME}}',
	'mobile-frontend-footer-contact' => 'Контакт информация',
	'mobile-frontend-search-noresults' => 'Сизни соруўугъузгъа келишген статья джокъду. Соруўугъузну тюрлендиригиз, неда клавиатурада статьяны ичинде излер ючюн тиекни басыгъыз.', # Fuzzy
	'mobile-frontend-main-menu-button-tooltip' => 'Баш менюну ач',
	'mobile-frontend-main-menu-page-title' => 'Сайт навигация',
	'mobile-frontend-main-menu-featured' => 'Сайлама',
	'mobile-frontend-main-menu-nearby' => 'Джуўукъда',
	'mobile-frontend-main-menu-login' => 'Кириў',
	'mobile-frontend-main-menu-logout' => 'Чыгъыў',
	'mobile-frontend-main-menu-settings' => 'Джарашдырыўла',
	'mobile-frontend-main-menu-settings-heading' => 'Сайтны мобил версиясыны джарашдырыўлары',
	'mobile-frontend-settings-site-header' => '«{{SITENAME}}» проектни тиллери',
	'mobile-frontend-settings-site-description' => '«{{SITENAME}}» проект $1 {{PLURAL:$1|тилде}} барды. Тюберекде болгъан версия да тизилибди.',
	'mobile-frontend-main-menu-contact' => 'Контакт информация',
	'mobile-frontend-page-menu-contents' => 'ичиндегиси',
	'mobile-frontend-page-menu-history' => 'Тарих',
	'mobile-frontend-meta-data-issues-header' => 'Бу статьяны игилендир', # Fuzzy
	'mobile-frontend-meta-data-issues' => 'Бу статьяны джетмегенликлери барды', # Fuzzy
	'mobile-frontend-ajax-page-loading' => '$1 джюклене турады',
	'mobile-frontend-page-saving' => '$1 сакълана турады',
	'mobile-frontend-ajax-page-error' => 'Джарсыў! Не эсе да терс болду. Браўзеринги джангыртыб кёр.',
	'mobile-frontend-watchlist-add' => '«$1» бетни кёзде тургъан тизменге къош',
	'mobile-frontend-watchlist-removed' => '«$1» бетни кёзде тургъан тизменгден кетер',
	'mobile-frontend-watchlist-view' => 'Кёзде тургъан тизменге кёч',
);

/** Colognian (Ripoarisch)
 * @author Purodha
 */
$messages['ksh'] = array(
	'mobile-frontend-desc' => 'Der Zohjang för Mobiljerääte',
	'mobile.css' => '/* Dat CSS heh aan dä Schtäll wirrek bloß op de Mobile ẞööver ẞait */',
	'mobile.js' => '/* Dat JavaSkrep heh aan dä Schtäll wirrek bloß op de Mobile ẞööver ẞait */',
	'mobile-frontend-search-submit' => 'Lohß Jonn!',
	'mobile-frontend-home-button' => 'Houpsigg',
	'mobile-frontend-logged-out' => 'Nit enjelogg',
	'mobile-frontend-logged-in-homepage-notification' => 'Wellkumme $1!',
	'mobile-frontend-logged-in-toast-notification' => 'Enjelogg als $1.',
	'mobile-frontend-sign-up-heading' => 'Aanmällde',
	'mobile-frontend-sign-in-heading' => 'Enlogge',
	'mobile-frontend-sign-in-error-heading' => 'Dä!',
	'mobile-frontend-settings-description' => 'Met heh dä Enschtällonge kanns De Dinge Zohjang för Mobiljerääte för Ding Bedörfniße paraat maache.',
	'mobile-frontend-settings-beta' => 'Betta',
	'mobile-frontend-save-settings' => 'Enschtällonge faßhallde',
	'mobile-frontend-random-button' => 'Zohfallsigg',
	'mobile-frontend-ajax-random-yes' => 'Joh',
	'mobile-frontend-ajax-random-retry' => 'Norrens versöhke',
	'mobile-frontend-back-to-top-of-section' => 'Jangk ene Afschnett zerök',
	'mobile-frontend-close-section' => 'Donn dä Afschnet heh aan et Ängk bränge',
	'mobile-frontend-show-button' => 'Zeisch!',
	'mobile-frontend-hide-button' => 'Verschteische!',
	'mobile-frontend-empty-homepage-text' => 'He di Aanfangssigg moß noch <a href="http://meta.wikimedia.org/wiki/Mobile_Projects/Mobile_Gateway#Mobile_homepage">enjereschdt wääde</a>.', # Fuzzy
	'mobile-frontend-regular-site' => 'jangk op de nomaale Belscherrem',
	'mobile-frontend-wml-continue' => 'Wiggermaache&nbsp;...',
	'mobile-frontend-wml-back' => 'Retuur&nbsp;...',
	'mobile-frontend-view' => 'Aansech om Mobiljerät',
	'mobile-frontend-view-desktop' => 'Jewöhnlejje Aansesch',
	'mobile-frontend-view-mobile' => 'Mobil-Aansesch',
	'mobile-frontend-opt-in-explain' => 'Beim Ußprobeere metmaache löht Desch neu Saache känne liehre, ävver et künnt sind, dat De jät fengks, wat noch nit flupp.',
	'mobile-frontend-images-status' => 'Belder',
	'mobile-frontend-disable-images' => 'Belder för et Mobiljerät ußschallde',
	'mobile-frontend-enable-images' => 'Belder för et Mobiljerät uohlohße',
	'mobile-frontend-missing-image' => 'Beld',
	'mobile-frontend-off' => 'Uß',
	'mobile-frontend-on' => 'Aan',
	'mobile-frontend-footer-contributors-text' => 'Enne Atikel vun <a href="$1">Metmaachere</a> wi Do eine bes.', # Fuzzy
	'mobile-frontend-featured-article' => 'Der Atikel vum Daach',
	'mobile-frontend-news-items' => 'En de Präß',
	'mobile-frontend-leave-feedback-notice' => 'Ding Röckmälunge helfe met, dat De met de Mobiljeräte besser heh bedeent wees.
Se wääde öffentlesch op dä Sigg „$1“ faßjehallde, zosamme met Dingem Metmaacher-Name, Dingem Brauser singe Version un däm Name vun Dingem Bedriefssüßtehm.
Bes esu jood un donn en joode Övverschreff för Dinge Beidraach heh ußsöhke; esu jät wi: „E Problehm mem Ußsinn bei Tabälle.“
För Ding Röckmälonge jällte uns Notzongesbedenonge.',
	'mobile-frontend-leave-feedback-warning' => 'Donn kein päsönlejjne Aanjabe en Ding Aanmärkonge, di De nit veröffentlesch han wells.',
	'mobile-frontend-leave-feedback-subject' => 'Theema:',
	'mobile-frontend-leave-feedback-message' => 'Nohreesch:',
	'mobile-frontend-leave-feedback-submit' => 'Lohß jonn!',
	'mobile-frontend-leave-feedback-link-text' => 'Röckmäldonge övver de Zohsazprojramme för Mobiljerääte',
	'mobile-frontend-leave-feedback' => 'Rückmäldonge övver der Zohjang för Mobiljerääte',
	'mobile-frontend-leave-feedback-title' => 'Jiv ons Röckmäldunge övver de !!FUZY!!ßait för Mobiljeräte',
	'mobile-frontend-leave-feedback-technical-problem-section-header' => 'E täschnesch Probleem',
	'mobile-frontend-leave-feedback-general-section-header' => 'Alljemein',
	'mobile-frontend-leave-feedback-article-feedback-section-header' => 'Enschäzonge för Sigge',
	'mobile-frontend-leave-feedback-email-body' => 'Donn Ding <i lang="en">e-mail</i> övver heh dä Linnesch enjävve.', # Fuzzy
	'mobile-frontend-leave-feedback-technical-link-text' => 'E täschnesch Probleem',
	'mobile-frontend-leave-feedback-general-link-text' => 'Allgemein Röckmäldonge',
	'mobile-frontend-leave-feedback-article-personal-link-text' => 'Övver mesch, udder Eine, udder en Ferma, för di esch schtonn',
	'mobile-frontend-leave-feedback-article-factual-link-text' => 'Övver ene Fähler en der Saach',
	'mobile-frontend-leave-feedback-article-other-link-text' => 'Övver e ander Probleem',
	'mobile-frontend-leave-feedback-form-subject-placeholder' => 'Et Theema vun dä Nohreesch',
	'mobile-frontend-leave-feedback-form-message-placeholder' => 'Jif Ding Röckmäldong heh en.',
	'mobile-frontend-leave-feedback-page-title' => 'Jiv ons Röckmäldunge övver de !!FUZY!!ßait för Mobiljeräte',
	'mobile-frontend-feedback-page' => 'Project:Röckmäldonge för der Zohjang för Mobiljerääte',
	'mobile-frontend-leave-feedback-special-title' => 'Kumtak noh ons',
	'mobile-frontend-feedback-no-subject' => '(Kei Theema)',
	'mobile-frontend-feedback-no-subject-field' => 'Donn e Theema enjävve',
	'mobile-frontend-feedback-no-message' => 'Jivv_en Nohreesch heh en',
	'mobile-frontend-feedback-edit-summary' => '$1 - automattesch faßjehallde [[Special:MobileFeedback|Röckmäldong]]',
	'mobile-frontend-leave-feedback-thanks' => 'Mer bedanke uns för Ding Rökmäldong.',
	'mobile-frontend-leave-feedback-post-error' => 'Et es ene Fähler opjetrodde beim Övverdraare udder Affärbeide vun Dinge Enjaabe.
Versöhg_et schpääder noch ens.',
	'mobile-frontend-language' => 'Schprooch:',
	'mobile-frontend-language-article-heading' => 'En ener andere Schprooch beloore.',
	'mobile-frontend-language-header' => 'Heh dä Atikel jidd_et en {{PLURAL:$1|eine Schprooch|$1 Schprooche|keine Schprooch}}.', # Fuzzy
	'mobile-frontend-language-variant-header' => 'Söhg en varrijetäät vun {{#language:{{CONTENTLANG}}}} uß',
	'mobile-frontend-language-footer' => '{{ucfirst:{{GRAMMAR:Nominative|{{ucfirst:{{SITENAME}}}}}}}} jidd_et en ander Schprooche.', # Fuzzy
	'mobile-frontend-language-site-choose' => 'Schprooch söhke',
	'mobile-frontend-username' => 'Metmaacher_Naame:',
	'mobile-frontend-password' => 'Paßwoot:',
	'mobile-frontend-password-placeholder' => 'Et Paßwoot',
	'mobile-frontend-login' => 'Enlogge',
	'mobile-frontend-account-create-submit' => 'Aanmällde',
	'mobile-frontend-placeholder' => 'Jiv heh en, wat De söhke wells&nbsp;&hellip;',
	'mobile-frontend-search-help' => 'Tipp Dinge Bejreff zom Söhke, un de zopaß Atikelle wääde heh aanjezeisch.', # Fuzzy
	'mobile-frontend-dismiss-notification' => 'donn heh di Nohresch zohmaache',
	'mobile-frontend-clear-search' => 'Läddesch maache',
	'mobile-frontend-privacy-link-text' => 'Prevaatheit',
	'mobile-frontend-about-link-text' => 'Övver',
	'mobile-frontend-footer-sitename' => '{{SITENAME}}',
	'mobile-frontend-footer-contact' => 'Kumtak',
	'mobile-frontend-search-noresults' => 'Kein Tittel vun enem Atikel deiht op dat paße, wat De söhks. Don jät angersch söhke udder nemm dä Knopp zom Söhke onger Dinge Taßte, un söhk der_met em Täx vun de Atikelle.', # Fuzzy
	'mobile-frontend-main-menu-featured' => 'Äxzälänt',
	'mobile-frontend-main-menu-nearby' => 'En de Nöh',
	'mobile-frontend-main-menu-login' => 'Enlogge',
	'mobile-frontend-main-menu-logout' => 'Ußlogge',
	'mobile-frontend-main-menu-watchlist' => 'De Oppassleß',
	'mobile-frontend-main-menu-settings' => 'Enschtällonge',
	'mobile-frontend-main-menu-settings-heading' => 'Enschtällonge för Mobiljerääte',
	'mobile-frontend-settings-site-header' => 'Schprooche {{GRAMMAR:vun+Dative|{{SITENAME}}}}',
	'mobile-frontend-settings-site-description' => '{{ucfirst:{{GRAMMAR:Nomminatif|{{ucfirst:{{SITENAME}}}}}}}} jiidd_et en {{PLURAL:$1|jenou eine Schprooch|$1 Schprooche|jaakein Schprooche}}. {{PLURAL:$1|Di Schprooch|Di Schprooche|Nix es dröm}} heh noh opjelėß.',
	'mobile-frontend-main-menu-contact' => 'Kumtak',
	'mobile-frontend-main-menu-account-create' => 'Ene neue Zohjang aanlääje',
	'mobile-frontend-page-menu-contents' => 'Enhalt',
	'mobile-frontend-page-menu-history' => 'Versione',
	'mobile-frontend-meta-data-issues-header' => 'Aanjelääjeheite',
	'mobile-frontend-watchlist-filter-all' => 'Alle',
	'mobile-frontend-watchlist-filter-articles' => 'Atikele',
	'mobile-frontend-diffview-title' => 'Op "$1" ändere', # Fuzzy
	'mobile-frontend-diffview-anonymous' => 'Nameloose Metmaacher',
	'mobile-frontend-photo-upload' => 'Donn et eezde Beld op di Sigg',
	'mobile-frontend-photo-article-edit-comment' => 'E Beld op di Sigg jedonn.',
	'mobile-frontend-photo-upload-comment' => 'E Fotto op di Sigg jedonn.',
	'mobile-frontend-image-loading' => 'Ben et Beld aam Laade&nbsp;&hellip;',
	'mobile-frontend-image-uploading' => 'Ben et Beld aam Huhlaade&nbsp;&hellip;',
);

/** Kurdish (Kurdî) */
$messages['ku'] = array(
	'mobile-frontend-search-submit' => 'Biçe',
	'mobile-frontend-home-button' => 'Mal',
	'mobile-frontend-random-button' => 'Tesadufî',
	'mobile-frontend-show-button' => 'Nîşan bide',
	'mobile-frontend-hide-button' => 'Veşêre',
	'mobile-frontend-regular-site' => 'Vê rûpelê di Wîkîpediya asayî de bibîne',
);

/** Kurdish (Latin script) (Kurdî (latînî)‎)
 * @author George Animal
 * @author Gomada
 */
$messages['ku-latn'] = array(
	'mobile-frontend-search-submit' => 'Biçe',
	'mobile-frontend-home-button' => 'Mal',
	'mobile-frontend-settings-beta' => 'Beta',
	'mobile-frontend-random-button' => 'Ketober',
	'mobile-frontend-show-button' => 'Nîşan bide',
	'mobile-frontend-hide-button' => 'veşêre',
	'mobile-frontend-regular-site' => 'Vê rûpelê di Wîkîpediya asayî de bibîne', # Fuzzy
	'mobile-frontend-wml-continue' => 'Didome ...',
	'mobile-frontend-view' => 'Xuyakirina mobîl',
	'mobile-frontend-leave-feedback-message' => 'Peyam:',
	'mobile-frontend-leave-feedback-technical-link-text' => 'Pirsgirêka teknîkî',
	'mobile-frontend-language' => 'Ziman:',
	'mobile-frontend-username' => 'Navê bikarhêner:',
	'mobile-frontend-password' => 'Şîfre:',
	'mobile-frontend-footer-contact' => 'Têkilî',
	'mobile-frontend-main-menu-contact' => 'Têkilî',
	'mobile-frontend-page-menu-contents' => 'naverok',
);

/** Komi (коми)
 */
$messages['kv'] = array(
	'mobile-frontend-search-submit' => 'Выльлаö',
	'mobile-frontend-home-button' => 'Керка',
	'mobile-frontend-random-button' => 'Случайнöй',
	'mobile-frontend-hide-button' => 'Дзебны',
);

/** Cornish (kernowek)
 * @author Kernoweger
 * @author Kw-Moon
 * @author Nrowe
 */
$messages['kw'] = array(
	'mobile-frontend-search-submit' => 'Mos',
	'mobile-frontend-home-button' => 'Folen dre',
	'mobile-frontend-random-button' => 'Dre jons',
	'mobile-frontend-back-to-top-of-section' => 'Labma war-dhelergh udn dregh',
	'mobile-frontend-show-button' => 'Diskwedhes',
	'mobile-frontend-hide-button' => 'Kudha',
	'mobile-frontend-regular-site' => 'Gwel desktop',
	'mobile-frontend-view' => 'Gwel pellgowsel',
	'mobile-frontend-featured-article' => 'Erthygel diskwedhys an jydh',
);

/** Kirghiz (Кыргызча)
 * @author Chorobek
 */
$messages['ky'] = array(
	'mobile-frontend-username' => 'Колдонуучунун аты:',
	'mobile-frontend-password' => 'Сырсөз:',
	'mobile-frontend-login' => 'Кирүү',
	'mobile-frontend-placeholder' => 'Издегениңизди бул жакка жазыңыз', # Fuzzy
	'mobile-frontend-privacy-link-text' => 'Купуялыкты сактоо',
);

/** Luxembourgish (Lëtzebuergesch)
 * @author Robby
 */
$messages['lb'] = array(
	'mobile-frontend-desc' => 'Frontend Applicatioun fir mobil Apparater',
	'mobile-frontend-search-submit' => 'Lass',
	'mobile-frontend-home-button' => 'Haaptsäit',
	'mobile-frontend-logged-out' => 'Net ageloggt',
	'mobile-frontend-logged-in-homepage-notification' => 'Wëllkomm $1!',
	'mobile-frontend-logged-in-toast-notification' => 'Als $1 ageloggt.',
	'mobile-frontend-sign-up-heading' => 'Schreift Iech an',
	'mobile-frontend-sign-in-heading' => 'Umellen',
	'mobile-frontend-sign-in-error-heading' => 'Ups',
	'mobile-frontend-settings-description' => 'Personaliséiert Är Erfarung op Ärem mobilen Apparat mat dëse spezifesche mobilen Astellungen.',
	'mobile-frontend-settings-beta' => 'Beta',
	'mobile-frontend-save-settings' => 'Astellunge späicheren',
	'mobile-frontend-random-button' => 'Zoufall',
	'mobile-frontend-ajax-random-question' => 'Dës Säit liesen?',
	'mobile-frontend-ajax-random-yes' => 'Jo',
	'mobile-frontend-ajax-random-retry' => 'Probéiert nach emol',
	'mobile-frontend-ajax-random-suggestions' => 'Aner Virschléi:',
	'mobile-frontend-back-to-top-of-section' => 'En Abschnitt zrécksprangen',
	'mobile-frontend-close-section' => 'Dësen Abschnitt zoumaachen',
	'mobile-frontend-show-button' => 'Weisen',
	'mobile-frontend-hide-button' => 'Verstoppen',
	'mobile-frontend-empty-homepage-text' => 'Dës Homepage muss konfiguréiert ginn. [http://meta.wikimedia.org/wiki/Mobile_Projects/Mobile_Gateway#Mobile_homepage">Instruktioune fir ze wësse wéi een dëse mobile Site aktivéiert]',
	'mobile-frontend-regular-site' => 'Desktop-Vue',
	'mobile-frontend-wml-continue' => 'Weider ...',
	'mobile-frontend-wml-back' => 'Zréck ...',
	'mobile-frontend-view' => 'Mobil Vue',
	'mobile-frontend-view-desktop' => 'Desktop',
	'mobile-frontend-view-mobile' => 'Mobil',
	'mobile-frontend-opt-in-explain' => "Duerch d'Matmaache beim mobile Beta-Projet, kritt Dir Zougang op experimentell Fonctiounen, mam Risiko datt Problemer a Feeler geschéien.",
	'mobile-frontend-images-status' => 'Biller',
	'mobile-frontend-disable-images' => 'Biller an der Mobiler Versioun desaktivéieren',
	'mobile-frontend-enable-images' => 'Biller an der Mobiler Versioun aktivéieren',
	'mobile-frontend-missing-image' => 'Bild',
	'mobile-frontend-off' => 'AUS',
	'mobile-frontend-on' => 'UN',
	'mobile-frontend-footer-contributors-text' => 'Artikel vu(n) [$1 Mataarbechter] wéi Dir',
	'mobile-frontend-featured-article' => 'Den Artikel vum Dag',
	'mobile-frontend-news-items' => 'An den Neiegkeeten',
	'mobile-frontend-leave-feedback-notice' => 'Äre Feedback hëlleft eis déi mobil Versioun vun eisem Site ze verbesseren. E gëtt ëffentlech op der Säit &quot;$1&quot; gewisen (zesumme mat Ärem Benotzernumm, der Versioun vun Ärem Browser a Betriibssystem). Versicht w.e.g. fir de Sujet vun Ärem Feedback informativ ze formuléieren, z. Bsp. "Formatéierungsproblemer bäi breeden Tabellen". Äre Feedback ënnerléit eisen allgemenge Conditiounen.',
	'mobile-frontend-leave-feedback-warning' => "Ausser wann Dir d'accord sidd datt Är perséinlech Informatiounen verëffentlecht ginn, sollt Dir w.e.g. keng perséinlech Informatiounen an Är Bemierkungen drasetzen.",
	'mobile-frontend-leave-feedback-subject' => 'Sujet:',
	'mobile-frontend-leave-feedback-message' => 'Message:',
	'mobile-frontend-leave-feedback-submit' => 'Feedback schécken',
	'mobile-frontend-leave-feedback-link-text' => 'Feedback vun der Erweiderung MobileFrontend',
	'mobile-frontend-leave-feedback' => 'Feedback fir de mobile Site',
	'mobile-frontend-leave-feedback-title' => 'Feedback vum mobile Site',
	'mobile-frontend-leave-feedback-technical-problem-section-header' => 'Technesche Problem',
	'mobile-frontend-leave-feedback-general-section-header' => 'Allgemeng',
	'mobile-frontend-leave-feedback-article-feedback-section-header' => 'Artikel Feedback',
	'mobile-frontend-leave-feedback-email-body' => 'Beschreift w.e.g. de Problem deen Dir op {{SITENAME}}  hutt iwwer dëser Linn. Leider kënne mir net op all Message äntwerten dee mir kréien.',
	'mobile-frontend-leave-feedback-technical-link-text' => 'Technesche Problem',
	'mobile-frontend-leave-feedback-general-link-text' => 'Allgemenge Feedback',
	'mobile-frontend-leave-feedback-article-personal-link-text' => 'Dee mech, eng Persoun oder eng Gesellschaft déi ech vertriede betrëfft',
	'mobile-frontend-leave-feedback-article-factual-link-text' => 'Deen e fachleche Feeler betrëfft',
	'mobile-frontend-leave-feedback-article-other-link-text' => 'Deen en anere Problem betrëfft',
	'mobile-frontend-leave-feedback-form-subject-placeholder' => 'Sujet vum Message',
	'mobile-frontend-leave-feedback-form-message-placeholder' => 'Tippt Är Bemierkung w.e.g. heihinn',
	'mobile-frontend-leave-feedback-page-title' => 'Feedback vum mobile Site',
	'mobile-frontend-leave-feedback-special-title' => 'Kontaktéiert eis',
	'mobile-frontend-feedback-no-subject' => '(kee Sujet)',
	'mobile-frontend-feedback-no-subject-field' => 'Gitt w.e.g. e Sujet un',
	'mobile-frontend-feedback-no-message' => 'Gitt w.e.g. hei e Message an',
	'mobile-frontend-leave-feedback-thanks' => 'Merci fir Äre Feedback!',
	'mobile-frontend-leave-feedback-post-error' => 'Et gouf e Feeler beim Verschaffe vun Ärem Message. Probéiert et w.e.g. spéider nach eng Kéier.',
	'mobile-frontend-language' => 'Sprooch:',
	'mobile-frontend-language-article-heading' => 'An enger anerer Sprooch liesen',
	'mobile-frontend-language-header' => 'Dës Säit ass {{PLURAL:$1|an enger Sprooch| a(n) $1 Sproochen}} disponibel',
	'mobile-frontend-language-footer' => 'Informatioun: Et ka sinn datt dës Säit net an Ärer Sprooch geschriwwen ass. Dir kënnt déi Sprooche gesinn déi vu(n) {{SITENAME}} ënnerstëtzt ginn, wann Dir hei klickt.',
	'mobile-frontend-language-site-choose' => 'Sprooch sichen',
	'mobile-frontend-username' => 'Benotzernumm:',
	'mobile-frontend-password' => 'Passwuert:',
	'mobile-frontend-username-placeholder' => 'Benotzernumm',
	'mobile-frontend-password-placeholder' => 'Passwuert',
	'mobile-frontend-login' => 'Aloggen',
	'mobile-frontend-account-create-submit' => 'Schreift Iech an',
	'mobile-frontend-password-confirm-placeholder' => 'Passwuert confirméieren',
	'mobile-frontend-overlay-escape' => 'Zréck goen',
	'mobile-frontend-placeholder' => 'Op {{SITENAME}} sichen',
	'mobile-frontend-search-help' => "Gitt d'Wuert wat Dir sicht hei driwwer an an déi passend Säitentitele ginn dann hei gewisen.",
	'mobile-frontend-dismiss-notification' => 'dës Noriicht zoumaachen',
	'mobile-frontend-clear-search' => 'Eidel maachen',
	'mobile-frontend-privacy-link-text' => 'Dateschutz',
	'mobile-frontend-about-link-text' => 'Iwwer',
	'mobile-frontend-footer-sitename' => '{{SITENAME}}',
	'mobile-frontend-footer-contact' => 'Kontakt',
	'mobile-frontend-search-noresults' => "Keng Säit gouf beim siche fonnt. Ännert d'Critèren oder dréckt de Sichknäppchen op Ärer Tastatur fir bannen an de Säiten ze sichen.",
	'mobile-frontend-main-menu-button-tooltip' => 'Haaptmenü opmaachen',
	'mobile-frontend-main-menu-featured' => 'Bemierkenswäert',
	'mobile-frontend-main-menu-nearby' => 'Nobäi',
	'mobile-frontend-main-menu-login' => 'Aloggen',
	'mobile-frontend-main-menu-logout' => 'Ausloggen',
	'mobile-frontend-main-menu-watchlist' => 'Iwwerwaachungslëscht',
	'mobile-frontend-main-menu-settings' => 'Astellungen',
	'mobile-frontend-main-menu-upload' => 'Eroplueden',
	'mobile-frontend-main-menu-settings-heading' => 'Mobil-Astellungen fir de Site',
	'mobile-frontend-settings-site-header' => '{{SITENAME}}-Sproochen',
	'mobile-frontend-settings-site-description' => '{{SITENAME}} ass {{PLURAL:$1|an enger Sprooch|a(n) $1 Sproochen}} disponibel. Alle Ddsponibel Versioune stinn hei drënner',
	'mobile-frontend-main-menu-contact' => 'Kontakt',
	'mobile-frontend-page-menu-contents' => 'Inhalter',
	'mobile-frontend-page-menu-history' => 'Versiounen',
	'mobile-frontend-meta-data-issues-header' => 'Problemer',
	'mobile-frontend-meta-data-issues' => 'Dës Säit huet e puer Problemer',
	'mobile-frontend-ajax-page-loading' => '$1 lueden',
	'mobile-frontend-page-saving' => '$1 späicheren',
	'mobile-frontend-nearby-title' => 'Nobäi',
	'mobile-frontend-photo-upload-generic' => 'E Bild spenden',
	'mobile-frontend-donate-image-title' => 'E Bild spenden',
	'mobile-frontend-donate-image-page-title' => 'Eroplueden',
	'mobile-frontend-listed-image-no-description' => 'Keng Beschreiwung',
	'mobile-frontend-watchlist-add' => '$1 gouf op Är Iwwerwaachungslëscht derbäigesat',
	'mobile-frontend-watchlist-view' => 'Är Iwwerwaachungslëscht weisen',
	'mobile-frontend-watchlist-more' => 'méi',
	'mobile-frontend-watchlist-cta-button-login' => 'Aloggen',
	'mobile-frontend-watchlist-cta-button-signup' => 'Mellt Iech un',
	'mobile-frontend-watchlist-a-z' => 'All',
	'mobile-frontend-watchlist-feed' => 'Geännert',
	'mobile-frontend-watchlist-a-z-empty' => 'Dir iwwerwaacht elo keng Säiten',
	'mobile-frontend-changeslist-ip' => 'Anonyme Benotzer',
	'mobile-frontend-changeslist-nocomment' => 'kee Resumé vun der Ännerung',
	'mobile-frontend-watchlist-filter-all' => 'All',
	'mobile-frontend-watchlist-filter-articles' => 'Artikelen',
	'mobile-frontend-watchlist-filter-talk' => 'Diskussioun',
	'mobile-frontend-watchlist-filter-other' => 'Anerer',
	'mobile-frontend-diffview-404-title' => 'Schlecht Versioun',
	'mobile-frontend-diffview-title' => 'Ännerungen',
	'mobile-frontend-diffview-anonymous' => 'Anonyme Benotzer',
	'mobile-frontend-table' => 'Tabell $1',
	'mobile-frontend-photo-upload' => 'Setzt eng Foto an dësen Artikel',
	'mobile-frontend-photo-upload-comment' => "Foto op d'Säit derbäigesat",
	'mobile-frontend-photo-caption-placeholder' => 'Setzt eng Beschreiwung derbäi (obligatoresch)',
	'mobile-frontend-image-loading' => 'Bild gëtt gelueden',
	'mobile-frontend-image-uploading' => 'Bild gëtt eropgelueden, waart w.e.g. <a href="#">Ofbrieche</a> wann et ze laang dauert.',
	'mobile-frontend-photo-upload-error' => 'Feeler, probéiert nach eng Kéier.',
	'mobile-frontend-photo-cancel' => 'Ofbriechen',
	'tag-mobile_edit' => 'Mobil Ännerung',
	'tag-mobile_edit-description' => 'Ännerung déi vun engem mobile Site gemaach gouf',
	'mobile-frontend-drawer-cancel' => 'Ofbriechen',
);

/** Lezghian (лезги)
 * @author Migraghvi
 */
$messages['lez'] = array(
	'mobile-frontend-search-submit' => 'ЭлячIун',
	'mobile-frontend-home-button' => 'КIвализ',
	'mobile-frontend-random-button' => 'Дуьшуьшдин',
	'mobile-frontend-show-button' => 'Къалурун',
	'mobile-frontend-hide-button' => 'Чуьнуьхун',
	'mobile-frontend-wml-continue' => 'Давамун...',
	'mobile-frontend-wml-back' => 'КЪулухъ...',
	'mobile-frontend-leave-feedback-message' => 'Чар', # Fuzzy
	'mobile-frontend-language' => 'Чlал', # Fuzzy
	'mobile-frontend-username' => 'Уртахдин тlвар:',
	'mobile-frontend-password' => 'Парол:',
);

/** Limburgish (Limburgs)
 * @author Ooswesthoesbes
 */
$messages['li'] = array(
	'mobile-frontend-desc' => 'Mobiel Frontend',
	'mobile-frontend-search-submit' => 'Gank',
	'mobile-frontend-home-button' => 'Veurblaad',
	'mobile-frontend-logged-out' => 'Neet aangemèld',
	'mobile-frontend-settings-description' => 'Pas dien gebroekerservaring óp diene mobiel aan via dees instèllinge.',
	'mobile-frontend-settings-beta' => 'Bèta',
	'mobile-frontend-save-settings' => 'Slaon instèllinge op',
	'mobile-frontend-random-button' => 'Willekäörig',
	'mobile-frontend-back-to-top-of-section' => 'Ein köpke tröksjpringe',
	'mobile-frontend-close-section' => 'Sloet dit deil',
	'mobile-frontend-show-button' => 'Tuin',
	'mobile-frontend-hide-button' => 'Versjtaek',
	'mobile-frontend-empty-homepage-text' => 'Dees startpagina mót waere samegesteldj. <a href="//meta.wikimedia.org/wiki/Mobile_Projects/Mobile_Gateway#Mobile_homepage">Hie kóns se mieë laeze</a>.', # Fuzzy
	'mobile-frontend-regular-site' => 'Standerdbetrachting',
	'mobile-frontend-wml-continue' => 'Gank door ...',
	'mobile-frontend-wml-back' => 'Trögk ...',
	'mobile-frontend-view' => 'Mobiele weergave',
	'mobile-frontend-view-desktop' => 'Desktop',
	'mobile-frontend-view-mobile' => 'Mobiel',
	'mobile-frontend-opt-in-explain' => 'Door ane bèta mit te doon kriegs se toegank aan experimenteel kinmirke en kums se meugelik bugs en anger ómstenj taenge.',
	'mobile-frontend-images-status' => 'Aafbeildjinge',
	'mobile-frontend-disable-images' => 'Zèt aafbeildinge óppe mobiel site oet',
	'mobile-frontend-enable-images' => 'Zèt aafbeildinge óppe mobiel site aan',
	'mobile-frontend-off' => 'OET',
	'mobile-frontend-on' => 'AAN',
	'mobile-frontend-footer-contributors-text' => 'Pagina door <a href="$1">gebroekers</a> wie dich', # Fuzzy
	'mobile-frontend-featured-article' => 'Sjterartikel',
	'mobile-frontend-news-items' => "In 't nuujs",
	'mobile-frontend-leave-feedback-notice' => 'Diene feedback hölp ós dien ervaring mitte mobiel site te baetere. Deze feedback is aopenber (mit diene gebroeker, browser en DOS) óppe pagina &quot;$1&quot;. Kees e.t.b. \'ne informatieve ongerwerpregel, bv. "Ópmaakperbleme mit brei tebelle". Op diene feedback zeen ós gebroeksverurwaerd van toepassing.',
	'mobile-frontend-leave-feedback-warning' => "Nöm gein persuuenlike gegaeves op in dien opmirkinge, terzie s'n akkaor geis mit 't aopenbaar make d'rvan.",
	'mobile-frontend-leave-feedback-subject' => 'Óngerwerp:',
	'mobile-frontend-leave-feedback-message' => 'Berich:',
	'mobile-frontend-leave-feedback-submit' => 'Slaon feedback óp',
	'mobile-frontend-leave-feedback-link-text' => 'Mobiel Frontend feedback',
	'mobile-frontend-leave-feedback' => 'Laot feedback achter',
	'mobile-frontend-leave-feedback-title' => 'Gaef ós feedback euver dien ervaringe mitte mobiel site',
	'mobile-frontend-leave-feedback-technical-problem-section-header' => 'Technisch perbleem',
	'mobile-frontend-leave-feedback-general-section-header' => 'Algemein',
	'mobile-frontend-leave-feedback-article-feedback-section-header' => 'Paginabeoerdeiling',
	'mobile-frontend-leave-feedback-email-body' => 'Sjrief dienen e-mail baove dizze lien.', # Fuzzy
	'mobile-frontend-leave-feedback-technical-link-text' => 'Technisch perbleem',
	'mobile-frontend-leave-feedback-general-link-text' => 'Algemeine feedback',
	'mobile-frontend-leave-feedback-article-personal-link-text' => 'Mit betrèkking toet mich, emes of e bedrief det ich vertaengewuuerjig.',
	'mobile-frontend-leave-feedback-article-factual-link-text' => "Mit betrèkking toet 'n inhawdelike fout",
	'mobile-frontend-leave-feedback-article-other-link-text' => "Mit betrèkking toet 'n anger perbleem",
	'mobile-frontend-leave-feedback-form-subject-placeholder' => 'Óngerwèrp',
	'mobile-frontend-leave-feedback-form-message-placeholder' => 'Veur hie dien opmirking in',
	'mobile-frontend-leave-feedback-page-title' => 'Gaef ós feedback euver dien ervaringe mitte mobiel site',
	'mobile-frontend-leave-feedback-special-title' => 'Nöm kóntak op',
	'mobile-frontend-feedback-no-subject' => '(gein óngerwèrp)',
	'mobile-frontend-feedback-no-subject-field' => "Gaef 'n óngerwèrp op",
	'mobile-frontend-feedback-no-message' => 'Veur hiej e berich in',
	'mobile-frontend-feedback-edit-summary' => "$1 - autematis geplaats via 't [[Special:MobileFeedback|hölpprogramma veur trögkkoppeling via mobiel]]",
	'mobile-frontend-leave-feedback-thanks' => 'Danke veure feedback!',
	'mobile-frontend-leave-feedback-post-error' => "d'r Is 'n fout opgetraoje tiejes 't verwirke van die berich.
Verzeuk 't lader nag 'ne kieër.",
	'mobile-frontend-language' => 'Spraok:',
	'mobile-frontend-language-header' => 'Dees pagina is besjikbaar in {{PLURAL:$1|ein spraok|$1 spräök}}', # Fuzzy
	'mobile-frontend-language-footer' => '{{SITENAME}} is in anger spräök besjikbaar.', # Fuzzy
	'mobile-frontend-language-site-choose' => 'Zeuk spraok',
	'mobile-frontend-username' => 'Gebroekersnaam:',
	'mobile-frontend-password' => 'Wachwaord:',
	'mobile-frontend-login' => 'Mèlj aan',
	'mobile-frontend-placeholder' => 'Doorzeuk {{SITENAME}}',
	'mobile-frontend-search-help' => 'Veur de trèfweurd hiebaove in. Zeukrizzeltaote waere hie waergaeve.', # Fuzzy
	'mobile-frontend-dismiss-notification' => 'verberg de notificatie',
	'mobile-frontend-clear-search' => 'Wösj',
	'mobile-frontend-privacy-link-text' => 'Prajvesie',
	'mobile-frontend-about-link-text' => 'Euver',
	'mobile-frontend-footer-sitename' => '{{SITENAME}}',
	'mobile-frontend-footer-contact' => 'Kóntak',
	'mobile-frontend-search-noresults' => "Gein rizzeltaote veur dien zeukopdrach. Veranger dien zeukopdrach of klik oppe zeukknoep oppe klaveer óm binne pagina's te zeuke.", # Fuzzy
	'mobile-frontend-main-menu-featured' => 'Oetgelich',
	'mobile-frontend-main-menu-nearby' => 'Kórtbie',
	'mobile-frontend-main-menu-settings' => 'Insjtèllinge',
	'mobile-frontend-main-menu-settings-heading' => 'Mobiel veurkäöre',
	'mobile-frontend-settings-site-header' => 'Spräök veur {{SITENAME}}',
	'mobile-frontend-settings-site-description' => '{{SITENAME}} is besjikbaar in {{PLURAL:$1|ein spraok|$1 spräök}}. Al besjikbaar versies staon hieónger',
	'mobile-frontend-main-menu-contact' => 'Kóntak',
	'mobile-frontend-page-menu-contents' => 'inhawd',
	'mobile-frontend-page-menu-history' => 'Gesjiechte',
);

/** lumbaart (lumbaart)
 */
$messages['lmo'] = array(
	'mobile-frontend-search-submit' => 'Inanz',
	'mobile-frontend-home-button' => 'Pagina principala',
	'mobile-frontend-random-button' => 'A cas',
	'mobile-frontend-back-to-top-of-section' => "Sàlta Indree d'una Sezión",
	'mobile-frontend-show-button' => 'Fàm vedè',
	'mobile-frontend-hide-button' => 'Scund',
	'mobile-frontend-regular-site' => "Varda 'sta pagina chì in sü la {{SITENAME}} nurmala", # Fuzzy
	'mobile-frontend-featured-article' => 'Vedrína',
);

/** Lingala (lingála)
 * @author Dfoy
 */
$messages['ln'] = array(
	'mobile-frontend-placeholder' => 'Luka na {{SITENAME}}',
	'mobile-frontend-placeholder-beta' => 'Luka na {{SITENAME}} (Beta)',
);

/** Lithuanian (lietuvių)
 * @author Eitvys200
 * @author Vogone
 */
$messages['lt'] = array(
	'mobile-frontend-search-submit' => 'Eiti',
	'mobile-frontend-home-button' => 'Pradžia',
	'mobile-frontend-logged-out' => 'Neprisijungta',
	'mobile-frontend-settings-beta' => 'Beta',
	'mobile-frontend-save-settings' => 'Išsaugoti nustatymus',
	'mobile-frontend-random-button' => 'Atsitiktinis',
	'mobile-frontend-back-to-top-of-section' => 'Peršokti atgal sekcija',
	'mobile-frontend-close-section' => 'Uždarykite šį skirsnį',
	'mobile-frontend-show-button' => 'Rodyti',
	'mobile-frontend-hide-button' => 'Slėpti',
	'mobile-frontend-regular-site' => 'Peržiūrėti šį puslapį įprastoje Vikipedijoje', # Fuzzy
	'mobile-frontend-wml-continue' => 'Toliau ...',
	'mobile-frontend-wml-back' => 'Atgal ...',
	'mobile-frontend-view' => 'Mobili peržiūra',
	'mobile-frontend-view-desktop' => 'Darbalaukis',
	'mobile-frontend-view-mobile' => 'Mobilus',
	'mobile-frontend-opt-in-explain' => 'Prisijungiant prie beta, jūs gausite prieigą prie dar tik bandomų galimybių, rizikuodami puslapio klaidomis.',
	'mobile-frontend-images-status' => 'Paveikslėliai',
	'mobile-frontend-disable-images' => 'Išjungti vaizdus mobilioje svetainėje',
	'mobile-frontend-enable-images' => 'Įjungti vaizdus mobilioje svetainėje',
	'mobile-frontend-off' => 'IŠJUNGTI',
	'mobile-frontend-on' => 'IJUNGTI',
	'mobile-frontend-featured-article' => 'Dienos straipsnis',
	'mobile-frontend-news-items' => 'Naujienose',
	'mobile-frontend-leave-feedback-subject' => 'Tema', # Fuzzy
	'mobile-frontend-leave-feedback-message' => 'Žinutė', # Fuzzy
	'mobile-frontend-leave-feedback-submit' => 'Siųsti atsiliepimus',
	'mobile-frontend-leave-feedback' => 'Palikti atsiliepimą',
	'mobile-frontend-leave-feedback-title' => 'Palikti atsiliepimą',
	'mobile-frontend-leave-feedback-technical-problem-section-header' => 'Techninė problema',
	'mobile-frontend-leave-feedback-article-feedback-section-header' => 'Straipsnio atsiliepimai',
	'mobile-frontend-leave-feedback-email-body' => 'Prašome parašyti savo el. pašto aukščiau šis eilutės.', # Fuzzy
	'mobile-frontend-leave-feedback-technical-link-text' => 'Techninė problema',
	'mobile-frontend-leave-feedback-form-subject-placeholder' => 'Žinutės tema',
	'mobile-frontend-leave-feedback-form-message-placeholder' => 'Įveskite savo komentarą čia',
	'mobile-frontend-leave-feedback-page-title' => 'Mobilios svetainės atsiliepimas',
	'mobile-frontend-leave-feedback-special-title' => 'Susisiekite su mumis',
	'mobile-frontend-feedback-no-subject' => '(be temos)',
	'mobile-frontend-feedback-no-subject-field' => 'Prašome įvesti temą',
	'mobile-frontend-feedback-no-message' => 'Prašome įvesti žinutę čia',
	'mobile-frontend-leave-feedback-thanks' => 'Dėkojame už jūsų atsiliepimą!',
	'mobile-frontend-leave-feedback-post-error' => 'Įvyko klaida apdorojant jūsų pranešimą. Mėginkite dar kartą vėliau.',
	'mobile-frontend-language' => 'Kalba:',
	'mobile-frontend-language-header' => 'Šis straipsnis prieinamas $1 {{PLURAL:$1|kalba|kalbomis}}', # Fuzzy
	'mobile-frontend-language-footer' => '{{SITENAME}} yra prieinamas kitomis kalbomis', # Fuzzy
	'mobile-frontend-language-site-choose' => 'Paieškos kalba',
	'mobile-frontend-username' => 'Naudotojo vardas:',
	'mobile-frontend-password' => 'Slaptažodis:',
	'mobile-frontend-login' => 'Prisijungti',
	'mobile-frontend-placeholder' => 'Ieškoti {{SITENAME}}',
	'mobile-frontend-clear-search' => 'Išvalyti',
	'mobile-frontend-privacy-link-text' => 'Privatumas',
	'mobile-frontend-about-link-text' => 'Apie',
	'mobile-frontend-footer-sitename' => '{{SITENAME}}',
	'mobile-frontend-footer-contact' => 'Kontaktai',
	'mobile-frontend-main-menu-nearby' => 'Netoli',
	'mobile-frontend-main-menu-settings' => 'Nustatymai',
	'mobile-frontend-main-menu-settings-heading' => 'Mobiliosios svetainės nustatymai',
	'mobile-frontend-settings-site-header' => '{{SITENAME}} Kalbos',
	'mobile-frontend-settings-site-description' => '{{SITENAME}} yra prieinamas $1 {{PLURAL:$1|kalba|kalbomis}}. Visos prieinamos versijos nurodytos žemiau',
	'mobile-frontend-main-menu-contact' => 'Kontaktai',
	'mobile-frontend-page-menu-contents' => 'turinys',
	'mobile-frontend-page-menu-history' => 'Istorija',
);

/** Latgalian (latgaļu)
 */
$messages['ltg'] = array(
	'mobile-frontend-show-button' => 'Paruodeit',
	'mobile-frontend-hide-button' => 'Nūglobuot',
);

/** Mizo (Mizo ţawng)
 * @author RMizo
 */
$messages['lus'] = array(
	'mobile-frontend-desc' => 'Biakhlatna hmanga thlìrna',
	'mobile-frontend-search-submit' => 'Khai le',
	'mobile-frontend-home-button' => 'Inpui',
	'mobile-frontend-random-button' => 'Kahpah',
	'mobile-frontend-back-to-top-of-section' => 'Hlawm khat zuan lêtna',
	'mobile-frontend-close-section' => 'Hläwm khàrna',
	'mobile-frontend-show-button' => 'Tihlanna',
	'mobile-frontend-hide-button' => 'Tihbona',
	'mobile-frontend-empty-homepage-text' => 'Inpui herrem a ngai. <a href="http://meta.wikimedia.org/wiki/Mobile_Projects/Mobile_Gateway#Mobile_homepage">\'Tah hian chhiar belh rawh.</a>', # Fuzzy
	'mobile-frontend-regular-site' => 'Hmaipui thlir',
	'mobile-frontend-wml-continue' => 'Chhunzawmna...',
	'mobile-frontend-wml-back' => 'Lêtna...',
	'mobile-frontend-view' => 'Biakhlatna hmanga thlìrna',
	'mobile-frontend-view-desktop' => 'Khawlthluaknei',
	'mobile-frontend-view-mobile' => 'Biakhlatna',
	'mobile-frontend-featured-article' => 'Tlangrèlthang...',
	'mobile-frontend-news-items' => 'Chanchin thar',
	'mobile-frontend-leave-feedback-subject' => 'Thupui:',
	'mobile-frontend-leave-feedback-message' => 'Lehkha:',
	'mobile-frontend-leave-feedback-submit' => 'Finchhuahna thehlut rawh le',
	'mobile-frontend-leave-feedback-technical-problem-section-header' => 'Rokhawlhna',
	'mobile-frontend-leave-feedback-article-feedback-section-header' => 'Thuziak fakselna',
	'mobile-frontend-leave-feedback-email-body' => 'Khawngaihin hemi rìn chungah hian i e-lehkha ziak rawh.', # Fuzzy
	'mobile-frontend-leave-feedback-technical-link-text' => 'Rokhawlhna',
	'mobile-frontend-language' => 'Ṭawng:',
	'mobile-frontend-username' => 'Hmangtuhming:',
	'mobile-frontend-password' => 'Thurûk:',
	'mobile-frontend-login' => 'Luhna',
	'mobile-frontend-placeholder' => 'I zawn duh hetah hian ziak rawh le. . .', # Fuzzy
	'mobile-frontend-dismiss-notification' => 'he hriattirna hi hnâwl rawh',
	'mobile-frontend-clear-search' => 'Nawhrehna',
	'mobile-frontend-privacy-link-text' => 'Inthupna',
	'mobile-frontend-about-link-text' => 'Chanchin',
	'mobile-frontend-footer-sitename' => '{{SITENAME}}',
	'mobile-frontend-footer-contact' => 'Biakna',
	'mobile-frontend-search-noresults' => 'I thuzawnin thuziak mil pakhat mah a nei lo. I thuzawn i thlâk loh pawhin i khawlthluaknei chhutthlènga zawnna hmehkhep hmet la, thuziak chhúngah i zawng thei ang.', # Fuzzy
	'mobile-frontend-main-menu-featured' => 'Tlángrèlthang',
);

/** Latvian (latviešu)
 * @author GreenZeb
 * @author Papuass
 */
$messages['lv'] = array(
	'mobile-frontend-search-submit' => 'Meklēt',
	'mobile-frontend-home-button' => 'Sākumlapa',
	'mobile-frontend-settings-beta' => 'Beta',
	'mobile-frontend-random-button' => 'Nejaušs raksts',
	'mobile-frontend-show-button' => 'Parādīt',
	'mobile-frontend-hide-button' => 'Paslēpt',
	'mobile-frontend-regular-site' => 'Apskatīt šo lapu parastajā {{SITENAME}}', # Fuzzy
	'mobile-frontend-wml-continue' => 'Turpināt...',
	'mobile-frontend-wml-back' => 'Atpakaļ...',
	'mobile-frontend-view' => 'Mobilais skats',
	'mobile-frontend-featured-article' => 'Vērtīgais raksts',
	'mobile-frontend-news-items' => 'Ziņās',
	'mobile-frontend-leave-feedback-subject' => 'Temats:',
	'mobile-frontend-leave-feedback-message' => 'Ziņojums:',
	'mobile-frontend-leave-feedback-submit' => 'Pievienot atsauksmi',
	'mobile-frontend-leave-feedback-link-text' => 'MobileFrontend Extension atsauksmes',
	'mobile-frontend-leave-feedback' => 'Mobilās vietnes atsauksmes',
	'mobile-frontend-leave-feedback-title' => 'Mobilās vietnes atsauksmes',
	'mobile-frontend-leave-feedback-technical-problem-section-header' => 'Tehniska problēma',
	'mobile-frontend-leave-feedback-general-section-header' => 'Vispārīgi',
	'mobile-frontend-leave-feedback-article-feedback-section-header' => 'Raksta atsauksmes',
	'mobile-frontend-leave-feedback-email-body' => 'Lūdzu, rakstiet savu e-pastu virs šīs rindas.', # Fuzzy
	'mobile-frontend-leave-feedback-technical-link-text' => 'Tehniska problēma',
	'mobile-frontend-leave-feedback-general-link-text' => 'Vispārējas atsauksmes',
	'mobile-frontend-leave-feedback-article-personal-link-text' => 'Attiecībā uz mani, personu vai uzņēmumu, ko es pārstāvu',
	'mobile-frontend-leave-feedback-article-factual-link-text' => 'Attiecībā uz faktuālu kļūdu',
	'mobile-frontend-leave-feedback-article-other-link-text' => 'Saistībā ar citu problēmu',
	'mobile-frontend-leave-feedback-form-subject-placeholder' => 'Ziņojuma temats',
	'mobile-frontend-leave-feedback-form-message-placeholder' => 'Ierakstiet šeit savu komentāru',
	'mobile-frontend-leave-feedback-page-title' => 'Mobilās vietnes atsauksmes',
	'mobile-frontend-leave-feedback-special-title' => 'Sazināties ar mums',
	'mobile-frontend-feedback-no-subject' => '(bez tēmas)',
	'mobile-frontend-feedback-no-subject-field' => 'Lūdzu, ievadiet tematu',
	'mobile-frontend-feedback-no-message' => 'Lūdzu, ievadiet šeit ziņojumu',
	'mobile-frontend-leave-feedback-thanks' => 'Paldies par jūsu atsauksmi!',
	'mobile-frontend-leave-feedback-post-error' => 'Radās kļūda, apstrādājot jūsu ziņojumu. Lūdzu, vēlāk mēģiniet vēlreiz.',
	'mobile-frontend-language' => 'Valoda:',
	'mobile-frontend-language-header' => 'Šis raksts ir pieejams $1 {{PLURAL:$1|valodā|valodās}}', # Fuzzy
	'mobile-frontend-language-footer' => '{{SITENAME}} ir pieejama arī citās valodās.', # Fuzzy
	'mobile-frontend-language-site-choose' => 'Meklēt valodu',
	'mobile-frontend-username' => 'Lietotājvārds:',
	'mobile-frontend-password' => 'Parole:',
	'mobile-frontend-login' => 'Pieslēgties',
	'mobile-frontend-placeholder' => 'Meklēt {{SITENAME}}',
	'mobile-frontend-dismiss-notification' => 'paslēpt šo paziņojumu',
	'mobile-frontend-clear-search' => 'Notīrīt',
	'mobile-frontend-privacy-link-text' => 'Konfidencialitāte',
	'mobile-frontend-about-link-text' => 'Par',
	'mobile-frontend-footer-sitename' => '{{SITENAME}}',
	'mobile-frontend-settings-site-header' => '{{SITENAME}} Valodas',
	'mobile-frontend-settings-site-description' => '{{SITENAME}} ir pieejams $1 {{PLURAL:$1|valodā|valodās}}. Visas pieejamās versijas ir uzskaitītas zemāk',
	'mobile-frontend-page-menu-contents' => 'saturs',
	'mobile-frontend-page-menu-history' => 'Vēsture',
);

/** Lazuri (Lazuri)
 */
$messages['lzz'] = array(
	'mobile-frontend-search-submit' => 'İgzali',
	'mobile-frontend-home-button' => 'Dudi',
	'mobile-frontend-random-button' => 'Randomi',
	'mobile-frontend-back-to-top-of-section' => "Ar burme uk'uni idi",
	'mobile-frontend-show-button' => "Ko3'iri",
	'mobile-frontend-hide-button' => 'Doşinaxi',
	'mobile-frontend-regular-site' => "Am but'k'a normaluri Vik'ip'edias ko3'iri", # Fuzzy
	'mobile-frontend-featured-article' => "Dolonişi Favori St'at'ia",
);

/** Malagasy (Malagasy)
 * @author Jagwar
 * @author Krinkle
 */
$messages['mg'] = array(
	'mobile-frontend-search-submit' => 'Tsidiho',
	'mobile-frontend-home-button' => 'Fandraisana',
	'mobile-frontend-random-button' => 'Takelaka kisendra',
	'mobile-frontend-back-to-top-of-section' => 'Hiverina any amina fizarana nialoha',
	'mobile-frontend-show-button' => 'Aseho',
	'mobile-frontend-hide-button' => 'Asitriho',
	'mobile-frontend-regular-site' => "Aseho amin'ny {{SITENAME}} tsotra ity pejy ity", # Fuzzy
	'mobile-frontend-featured-article' => "Takelak'ity andro ity",
);

/** Maori (Māori)
 */
$messages['mi'] = array(
	'mobile-frontend-search-submit' => 'Haere',
);

/** Macedonian (македонски)
 * @author Bjankuloski06
 */
$messages['mk'] = array(
	'mobile-frontend-desc' => 'Мобилен посредник',
	'mobile.css' => '/* Тука поставениот CSS ќе се применува врз корисниците на мобилното мрежно место */',
	'mobile.js' => '/* Тука поставениот JavaScript ќе им се вчитува на корисниците на мобилното мрежно место */',
	'mobile-frontend-search-submit' => 'Оди',
	'mobile-frontend-home-button' => 'Почетна',
	'mobile-frontend-logged-out' => 'Не сте најавени',
	'mobile-frontend-logged-in-homepage-notification' => 'Добре дојдовте, $1!',
	'mobile-frontend-logged-in-toast-notification' => 'Најавен како $1.',
	'mobile-frontend-sign-up-heading' => 'Регистрација',
	'mobile-frontend-sign-in-heading' => 'Најава',
	'mobile-frontend-sign-in-why' => 'Ако имате сметка на {{SITENAME}}, тогаш најавете се подолу.',
	'mobile-frontend-sign-in-error-heading' => 'Упс!',
	'mobile-frontend-settings-description' => 'Прилагодете си ја околината на мобилниот уред со овие наменски поставки',
	'mobile-frontend-settings-beta' => 'Бета',
	'mobile-frontend-settings-alpha' => 'Режим „[//en.wikipedia.org/wiki/Here_be_dragons кај ламјите]“',
	'mobile-frontend-settings-alpha-description' => 'Со ова влегувате во опасна и неистражена мобилна територија. Добивате уште повеќе експериментални функции, но со поголема опасност од бубачки и грешки.',
	'mobile-frontend-save-settings' => 'Зачувај поставки',
	'mobile-frontend-random-button' => 'Случајна',
	'mobile-frontend-ajax-random-heading' => 'Го пронаоѓам знаењето...',
	'mobile-frontend-ajax-random-quote' => 'Интелектуалниот развој треба да почне од самото раѓање и завршува дури кога ќе умреме',
	'mobile-frontend-ajax-random-quote-author' => 'Алберт Ајнштајн',
	'mobile-frontend-ajax-random-question' => 'Сакате да ја прочитате страницава?',
	'mobile-frontend-ajax-random-yes' => 'Да',
	'mobile-frontend-ajax-random-retry' => 'Обиди се пак',
	'mobile-frontend-ajax-random-suggestions' => 'Други предлози:',
	'mobile-frontend-back-to-top-of-section' => 'Оди на претх. заглавие',
	'mobile-frontend-close-section' => 'Затвори го поднасловот',
	'mobile-frontend-show-button' => 'Прикажи',
	'mobile-frontend-hide-button' => 'Скриј',
	'mobile-frontend-empty-homepage-text' => 'Оваа домашна страница треба да се намести. [//meta.wikimedia.org/wiki/Mobile_Projects/Mobile_Gateway#Mobile_homepage Прочитајте како да ја овозможите]',
	'mobile-frontend-regular-site' => 'Обичен изглед',
	'mobile-frontend-wml-continue' => 'Продолжи ...',
	'mobile-frontend-wml-back' => 'Назад ...',
	'mobile-frontend-view' => 'Мобилен изглед',
	'mobile-frontend-view-desktop' => 'Обично',
	'mobile-frontend-view-mobile' => 'Мобилно',
	'mobile-frontend-opt-in-explain' => 'Користејќи ја бета-верзијата добивате пристап до експетиментални функции, но и со можност за грешки и проблеми.',
	'mobile-frontend-images-status' => 'Слики',
	'mobile-frontend-disable-images' => 'Оневозможи слики во мобилниот изглед',
	'mobile-frontend-enable-images' => 'Овозможи слики во мобилниот изглед',
	'mobile-frontend-missing-image' => 'Слика',
	'mobile-frontend-off' => 'ИСКЛ',
	'mobile-frontend-on' => 'ВКЛЧ',
	'mobile-frontend-footer-contributors-text' => 'Сстраницата ја напишаа [$1 учесници] како вас',
	'mobile-frontend-featured-article' => 'Избрана статија за денес',
	'mobile-frontend-news-items' => 'Вести',
	'mobile-frontend-leave-feedback-notice' => 'Вашето мислење ни помага да ја подобриме мобилната верзија. Мислењето ќе биде објавено јавно (заедно со корисничкото име, верзијата на прелистувачот и оперативниот систем) на страницата „$1“. Одберете информативен наслов, како на пр. „Проблем со форматирање на широките табели“. Искажаното мислење подлежи на условите на употреба.',
	'mobile-frontend-leave-feedback-warning' => 'Доколку не сакате вашите информации да бидат јавни, ве молиме не наведувајте лични податоци во коментарот.',
	'mobile-frontend-leave-feedback-subject' => 'Наслов:',
	'mobile-frontend-leave-feedback-message' => 'Порака:',
	'mobile-frontend-leave-feedback-submit' => 'Поднеси мислење',
	'mobile-frontend-leave-feedback-link-text' => 'Мислење за Мобилниот посредник',
	'mobile-frontend-leave-feedback' => 'Дајте мислење',
	'mobile-frontend-leave-feedback-title' => 'Мислење за мобилната верзија',
	'mobile-frontend-leave-feedback-technical-problem-section-header' => 'Технички проблем',
	'mobile-frontend-leave-feedback-general-section-header' => 'Општо',
	'mobile-frontend-leave-feedback-article-feedback-section-header' => 'Оценување на статии',
	'mobile-frontend-leave-feedback-email-body' => 'Над овој ред опишете го проблемот со кој се соочувате на {{SITENAME}}. Имајте предвид дека не можеме да одговориме на секоја порака што ќе ја примиме.',
	'mobile-frontend-leave-feedback-technical-link-text' => 'Технички проблем',
	'mobile-frontend-leave-feedback-general-link-text' => 'Општи мислења',
	'mobile-frontend-leave-feedback-article-personal-link-text' => 'Во врска со мене, лице или фирма што застапувам',
	'mobile-frontend-leave-feedback-article-factual-link-text' => 'Во врска со фактографска грешка',
	'mobile-frontend-leave-feedback-article-other-link-text' => 'Во врска со друг проблем',
	'mobile-frontend-leave-feedback-form-subject-placeholder' => 'Наслов на пораката',
	'mobile-frontend-leave-feedback-form-message-placeholder' => 'Тука внесете го коментарот',
	'mobile-frontend-leave-feedback-page-title' => 'Мислење за мобилната верзија',
	'mobile-frontend-feedback-page' => 'Project:Мислења за мобилниот додаток',
	'mobile-frontend-leave-feedback-special-title' => 'Контактирајте нè',
	'mobile-frontend-feedback-no-subject' => '(без наслов)',
	'mobile-frontend-feedback-no-subject-field' => 'Внесете наслов',
	'mobile-frontend-feedback-no-message' => 'Тука напишете ја пораката',
	'mobile-frontend-feedback-edit-summary' => '$1 - автоматски објавено користејќи ја [[Special:MobileFeedback|алатката за мислења за мобилната верзија]]',
	'mobile-frontend-leave-feedback-thanks' => 'Ви благодариме за искажаното мислење!',
	'mobile-frontend-leave-feedback-post-error' => 'Настана грешка при обработката на пораката. Обидете се повторно.',
	'mobile-frontend-language' => 'Јазик:',
	'mobile-frontend-language-article-heading' => 'На други јазици',
	'mobile-frontend-language-header' => 'Оваа страница е достапна на $1 {{PLURAL:$1|јазик|јазици}}',
	'mobile-frontend-language-variant-header' => 'Одберете ја варијантата на {{#language:{{CONTENTLANG}}}}',
	'mobile-frontend-language-footer' => 'Напомена: Страницава може да ја нема на вашиот претпочитан јазик. За да видите на кои јазици е достапен проектот {{SITENAME}}, стиснете тука.',
	'mobile-frontend-language-site-choose' => 'Пребарување на јазик',
	'mobile-frontend-username' => 'Корисничко име:',
	'mobile-frontend-password' => 'Лозинка:',
	'mobile-frontend-username-placeholder' => 'Корисничко име',
	'mobile-frontend-password-placeholder' => 'Лозинка',
	'mobile-frontend-login' => 'Најава',
	'mobile-frontend-last-modified-date' => 'Последна измена на $1, во $2 ч.',
	'mobile-frontend-last-modified-seconds' => 'Подновено пред {{PLURAL:$1|$1 секунда|$1 секунди}}',
	'mobile-frontend-last-modified-minutes' => 'Подновено пред {{PLURAL:$1|$1 минута|$1 минути}}',
	'mobile-frontend-last-modified-hours' => 'Подновено пред $1 {{PLURAL:$1|$1 час|$1 часа}}',
	'mobile-frontend-last-modified-days' => 'Подновено пред $1 {{PLURAL:$1|$1 ден|$1 дена}}',
	'mobile-frontend-last-modified-months' => 'Подновено пред {{PLURAL:$1|$1 месец|$1 месеци}}',
	'mobile-frontend-last-modified-years' => 'Подновено пред $1 {{PLURAL:$1|$1 година|$1 години}}',
	'mobile-frontend-account-create-submit' => 'Регистрација',
	'mobile-frontend-password-confirm-placeholder' => 'Потврдете ја лозинката',
	'mobile-frontend-account-create-email-placeholder' => 'Е-пошта (незадолжително)',
	'mobile-frontend-account-create-captcha-placeholder' => 'Внесете го безбедносниот текст',
	'mobile-frontend-overlay-escape' => 'Назад',
	'mobile-frontend-placeholder' => 'Пребарајте ја {{SITENAME}}',
	'mobile-frontend-placeholder-beta' => 'Пребарување на {{SITENAME}} (бета)',
	'mobile-frontend-placeholder-alpha' => 'Пребарајте по {{SITENAME}} (режим „кај ламјите“)',
	'mobile-frontend-search-help' => 'Погоре внесете го она што го барате, а овде ќе се прикажат страниците што се совпаѓаат со бараното.',
	'mobile-frontend-dismiss-notification' => 'отстрани го известувањето',
	'mobile-frontend-clear-search' => 'Исчисти',
	'mobile-frontend-privacy-link-text' => 'Приватност',
	'mobile-frontend-about-link-text' => 'За програмот',
	'mobile-frontend-footer-sitename' => '{{SITENAME}}',
	'mobile-frontend-footer-license-text' => 'Содржините се достапни под лиценцата [//en.m.wikipedia.org/wiki/Wikipedia:Text_of_Creative_Commons_Attribution-ShareAlike_3.0_Unported_License?useformat=mobile CC BY-SA 3.0]',
	'mobile-frontend-terms-use-text' => '[//wikimediafoundation.org/wiki/Terms_of_use?useformat=mobile Услови на употреба]',
	'mobile-frontend-footer-contact' => 'Контакт',
	'mobile-frontend-search-noresults' => 'Нема наслови што одговараат на бараното. Изменете го она што го барате или пребарувајте по текстот на самите страници.',
	'mobile-frontend-main-menu-button-tooltip' => 'Отвори го главното мени',
	'mobile-frontend-main-menu-page-title' => 'Навигација',
	'mobile-frontend-main-menu-featured' => 'Избрано',
	'mobile-frontend-main-menu-nearby' => 'Во близина',
	'mobile-frontend-main-menu-login' => 'Најава',
	'mobile-frontend-main-menu-logout' => 'Одјава',
	'mobile-frontend-main-menu-watchlist' => 'Набљудувања',
	'mobile-frontend-main-menu-settings' => 'Нагодувања',
	'mobile-frontend-main-menu-upload' => 'Подигања',
	'mobile-frontend-main-menu-settings-heading' => 'Поставки на мобилната околина',
	'mobile-frontend-settings-site-header' => 'Јазици на {{SITENAME}}',
	'mobile-frontend-settings-site-description' => '{{SITENAME}} се нуди на $1 {{PLURAL:$1|јазик|јазици}}. Сите расположиви верзии се наведени подолу',
	'mobile-frontend-main-menu-contact' => 'Контакт',
	'mobile-frontend-main-menu-account-create' => 'Направи сметка',
	'mobile-frontend-page-menu-contents' => 'содржина',
	'mobile-frontend-page-menu-history' => 'Историја',
	'mobile-frontend-meta-data-issues-header' => 'Проблеми',
	'mobile-frontend-meta-data-issues' => 'Страницава има извесни проблеми',
	'mobile-frontend-ajax-page-loading' => 'Ја вчитувам $1',
	'mobile-frontend-page-saving' => 'Го зачувувам $1',
	'mobile-frontend-ajax-page-error' => 'Нешто не е во ред. Превчитајте ја страницата во прелистувачот.',
	'mobile-frontend-nearby-title' => 'Во близина',
	'mobile-frontend-nearby-loading' => 'Вчитувам теми во ваша близина',
	'mobile-frontend-nearby-requirements' => 'Страницава бара JavaScript и прелистувач способен да ви ја утврди местоположбата.',
	'mobile-frontend-nearby-distance-report' => '$1 км од местото кајшто сега се наоѓате',
	'mobile-frontend-nearby-lookup-error' => 'Не можев да ве пронајдам. Се обидувам повторно...',
	'mobile-frontend-nearby-noresults' => 'Нема теми за местото кајшто се наоѓате. Зошто не напишете некоја статија?',
	'mobile-frontend-nearby-refresh' => 'Најдов поточна местоположба на местото. Стиснете тука за да го освежите списокот на страници во близина',
	'mobile-frontend-nearby-error' => 'Се јави неочекувана грешка при обидот да најдам страници во близина',
	'mobile-frontend-donate-image-login' => 'Мора да сте најавени за да ги видите вашите подигања',
	'mobile-frontend-photo-upload-generic' => 'Дарувајте слика',
	'mobile-frontend-donate-image-title' => 'Дарувајте слика',
	'mobile-frontend-donate-image-summary' => 'Сликите ги оживуваат страниците на {{SITENAME}}.
Имаме многу страници без слики поради огромен недостиг на слободно-лиценцирани слики.
Помогнете ни да ги оживееме страниците - дарувајте ваши слики што би биле од полза за поширокото уредништво на {{SITENAME}}.',
	'mobile-frontend-donate-image-heading' => 'Ваши скорешни придонеси',
	'mobile-frontend-donate-image-page-title' => 'Подигање',
	'mobile-frontend-donate-image-anon' => 'За да ја гледате страницата за подигања ќе ви треба [[Special:UserLogin|корисничка сметка]]',
	'mobile-frontend-listed-image-no-description' => 'Нема опис',
	'mobile-frontend-donate-photo-upload-success' => 'Успешно! Вашата слика сега може да се користи на {{SITENAME}}!',
	'mobile-frontend-donate-photo-first-upload-success' => 'Успешно! Благодариме за вашиот прв придонес!',
	'mobile-frontend-watchlist-add' => 'Додадена „$1“ во набљудуваните',
	'mobile-frontend-watchlist-removed' => 'Отстранета $1 од набљудуваните',
	'mobile-frontend-watchlist-view' => 'Погл. вашиот список на набљудувања',
	'mobile-frontend-watchlist-more' => 'повеќе',
	'mobile-frontend-watchlist-cta' => 'Најавете се или регистрирајте се за да ја набљудувате страницава.',
	'mobile-frontend-watchlist-cta-button-login' => 'Најава',
	'mobile-frontend-watchlist-cta-button-signup' => 'Регистрација',
	'mobile-frontend-watch-login' => 'Мора да сте најавени за да набљудувате страници.',
	'mobile-frontend-watchlist-a-z' => 'Сите',
	'mobile-frontend-watchlist-feed' => 'Изменети',
	'mobile-frontend-watchlist-a-z-empty' => 'Моментално не набљудувате ниедна страница',
	'mobile-frontend-watchlist-a-z-empty-howto-alt' => 'Стиснете на ѕвездата најгоре на страницата',
	'mobile-frontend-watchlist-a-z-empty-howto' => 'Набљудувајте страница што ве интересира стискајќи на ѕвездата најгоре на екранот. Со ова ќе ги обележите страниците што ве интересираат и ќе имате увид во промените што им се случуваат.',
	'mobile-frontend-watchlist-feed-empty' => 'Нема ниедна страница во скорешните промени',
	'mobile-frontend-watchlist-back-home' => 'Назад на почетна',
	'mobile-frontend-changeslist-ip' => 'Анонимен корисник',
	'mobile-frontend-changeslist-nocomment' => 'нема опис на уредувањето',
	'mobile-frontend-watchlist-filter-all' => 'Сите',
	'mobile-frontend-watchlist-filter-articles' => 'Статии',
	'mobile-frontend-watchlist-filter-talk' => 'Разговор',
	'mobile-frontend-watchlist-filter-other' => 'Други',
	'mobile-frontend-watchlist-modified' => 'Изменето $1',
	'mobile-frontend-diffview-404-title' => 'Неисправна ревизија',
	'mobile-frontend-diffview-404-desc' => 'Побараната назнаката на ревизијата не постои',
	'mobile-frontend-diffview-title' => 'Промени',
	'mobile-frontend-diffview-editcount' => '$1 {{PLURAL:$1|уредување|уредувања}}',
	'mobile-frontend-diffview-anonymous' => 'Анонимен корисник',
	'mobile-frontend-diffview-bytesadded' => '{{PLURAL:$1|Додаден $1 бајт|Додадени $1 бајти}}',
	'mobile-frontend-diffview-bytesremoved' => '{{PLURAL:$1|Одземен $1 бајт|Одземени $1 бајти}}',
	'mobile-frontend-diffview-explained' => 'Следниве редови се додадени (+) и отстранети (-):',
	'mobile-frontend-table' => 'Табела $1',
	'mobile-frontend-saving-exit-page' => 'Вашите придонеси сè уште се зачувуваат. Доколку напуштите, ќе ги изгубите придонесите. Дали сте сигурни дека сакате да излезете?',
	'mobile-frontend-photo-upload' => 'Стави слика во страницава',
	'mobile-frontend-photo-article-edit-comment' => 'Ставена слика за употреба во страница',
	'mobile-frontend-photo-article-donate-comment' => 'Подарена слика од мобилен',
	'mobile-frontend-photo-upload-comment' => 'Ставена слика во страница',
	'mobile-frontend-photo-caption-placeholder' => 'Ставете опис (задолжително)',
	'mobile-frontend-image-loading' => 'Ја вчитувам сликата...',
	'mobile-frontend-image-uploading-wait' => 'Ја подигам сликата. Почекајте.',
	'mobile-frontend-image-uploading-long' => 'Сликата сè уште се подига! Ви благодариме за трпението.',
	'mobile-frontend-image-uploading-cancel' => '<a href="#">Откажете</a> ако ова трае предолго.',
	'mobile-frontend-photo-upload-error' => 'Грешка. Обидете се повторно.',
	'mobile-frontend-photo-upload-success-article' => 'Успеа! Вашата слика сега поставена на страницата.',
	'mobile-frontend-photo-license' => 'Стискајќи на „Поднеси“, се согласувате на [//wikimediafoundation.org/wiki/Terms_of_use/mk Условите на употреба] и се согласувате да ја објавите сликата под лиценцата [//creativecommons.org/licenses/by-sa/3.0/deed.mk Криејтив комонс НаведиИзвор-СподелиПодИстиУслови 3.0].',
	'mobile-frontend-photo-submit' => 'Поднеси',
	'mobile-frontend-photo-cancel' => 'Откажи',
	'mobile-frontend-photo-upload-user-count' => '{{PLURAL:$1|1 подигање|$1 подигања}}', # Fuzzy
	'mobile-frontend-photo-upload-user-count-over-limit' => '500+ подигања',
	'tag-mobile_edit' => 'Мобилно уредување',
	'tag-mobile_edit-description' => 'Уредување извршено од мобилната варијанта на викито',
	'mobile-frontend-drawer-cancel' => 'Откажи',
);

/** Malayalam (മലയാളം)
 * @author Akhilan
 * @author Praveenp
 * @author Vssun
 */
$messages['ml'] = array(
	'mobile-frontend-desc' => 'മൊബൈൽ മുഖം',
	'mobile-frontend-search-submit' => 'പോകൂ',
	'mobile-frontend-home-button' => 'പ്രധാനം',
	'mobile-frontend-logged-out' => 'പ്രവേശിച്ചിട്ടില്ല',
	'mobile-frontend-logged-in-homepage-notification' => 'സ്വാഗതം, $1!',
	'mobile-frontend-logged-in-toast-notification' => '$1 ആയി പ്രവേശിച്ചിരിക്കുന്നു.',
	'mobile-frontend-sign-up-heading' => 'അംഗത്വമെടുക്കുക',
	'mobile-frontend-sign-in-heading' => 'പ്രവേശിക്കുക',
	'mobile-frontend-sign-in-why' => 'താങ്കൾക്ക് {{SITENAME}} അംഗത്വമുണ്ടെങ്കിൽ, താഴെ പ്രവേശിക്കുക.',
	'mobile-frontend-sign-in-error-heading' => 'അയ്യോ!',
	'mobile-frontend-settings-description' => 'മൊബൈലിനായുള്ള ഈ സൈറ്റ് സജ്ജീകരണങ്ങൾ ഉപയോഗിച്ച് താങ്കളുടെ മൊബൈൽ ഉപകരണങ്ങളിലെ അനുഭവം മെച്ചപ്പെടുത്തുക.',
	'mobile-frontend-settings-beta' => 'ബീറ്റ',
	'mobile-frontend-settings-alpha' => '[//en.wikipedia.org/wiki/Here_be_dragons വ്യാളീ തലം]',
	'mobile-frontend-settings-alpha-description' => 'അപകടകരവും പരീക്ഷിക്കാത്തതുമായ മൊബൈൽ മേഖലയിലേയ്ക്ക് കടക്കുക. കൂടുതൽ പരീക്ഷണാടിസ്ഥാനത്തിലുള്ള സവിശേഷതകൾ ഉപയോഗിക്കുക പക്ഷേ അപകടകരമായ ബഗുകൾ ഉണ്ടായേക്കാം.',
	'mobile-frontend-save-settings' => 'സജ്ജീകരണങ്ങൾ സേവ് ചെയ്യുക',
	'mobile-frontend-random-button' => 'ക്രമരഹിതം',
	'mobile-frontend-ajax-random-heading' => 'വിജ്ഞാനം കണ്ടെത്തുന്നു...',
	'mobile-frontend-ajax-random-quote' => 'ബൗദ്ധികമായ വളർച്ച ജനനത്തിൽ തന്നെ തുടങ്ങുകയും മരണത്തിൽ മാത്രം അവസാനിക്കുകയും ചെയ്യുന്ന ഒന്നാണ്',
	'mobile-frontend-ajax-random-question' => 'ഈ താൾ വായിക്കുന്നോ?',
	'mobile-frontend-ajax-random-yes' => 'അതെ',
	'mobile-frontend-ajax-random-retry' => 'വീണ്ടും ശ്രമിക്കുക',
	'mobile-frontend-ajax-random-suggestions' => 'മറ്റു നിർദ്ദേശങ്ങൾ:',
	'mobile-frontend-back-to-top-of-section' => 'ഒരു ഉപഖണ്ഡം പുറകിലേയ്ക്ക് പോവുക',
	'mobile-frontend-close-section' => 'ഈ ഭാഗം അടയ്ക്കുക',
	'mobile-frontend-show-button' => 'പ്രദർശിപ്പിക്കുക',
	'mobile-frontend-hide-button' => 'മറയ്ക്കുക',
	'mobile-frontend-empty-homepage-text' => 'ഈ പ്രധാന താൾ ക്രമീകരിക്കേണ്ടതുണ്ട്. [//meta.wikimedia.org/wiki/Mobile_Projects/Mobile_Gateway#Mobile_homepage Instructions ഈ സൈറ്റ് എപ്രകാരം മൊബൈൽ സജ്ജമാക്കാമെന്ന് കാണുക]',
	'mobile-frontend-regular-site' => 'ഡെസ്ക്ടോപ്പ് രൂപം',
	'mobile-frontend-wml-continue' => 'തുടരുക...',
	'mobile-frontend-wml-back' => 'പിന്നിലേക്ക് ...',
	'mobile-frontend-view' => 'മൊബൈൽ ദൃശ്യരൂപം',
	'mobile-frontend-view-desktop' => 'ഡെസ്ക്ടോപ്പ്',
	'mobile-frontend-view-mobile' => 'മൊബൈൽ',
	'mobile-frontend-opt-in-explain' => 'ബീറ്റയിൽ പങ്കു ചേരുമ്പോൾ താങ്കൾക്ക് പരീക്ഷണത്തിലുള്ള സവിശേഷഗുണങ്ങൾ ലഭ്യമാകും, പക്ഷേ ബഗ്ഗുകളും പ്രശ്നങ്ങളും നേരിടേണ്ടി വന്നേക്കാം.',
	'mobile-frontend-images-status' => 'ചിത്രങ്ങൾ',
	'mobile-frontend-disable-images' => 'മൊബൈൽ സൈറ്റിൽ ചിത്രങ്ങൾ പ്രവർത്തനരഹിതമാക്കുക',
	'mobile-frontend-enable-images' => 'മൊബൈൽ സൈറ്റിൽ ചിത്രങ്ങൾ പ്രവർത്തനസജ്ജമാക്കുക',
	'mobile-frontend-missing-image' => 'ചിത്രം',
	'mobile-frontend-off' => 'വേണ്ട',
	'mobile-frontend-on' => 'വേണം',
	'mobile-frontend-footer-contributors-text' => 'താങ്കളെപ്പോലെയുള്ള [$1 സന്നദ്ധ സംഭാവകരാണ്] താൾ എഴുതിയത്',
	'mobile-frontend-featured-article' => 'ഇന്നത്തെ സമഗ്ര ലേഖനം',
	'mobile-frontend-news-items' => 'വാർത്തയിൽ',
	'mobile-frontend-leave-feedback-notice' => 'മൊബൈൽ സൈറ്റ് അനുഭവം മെച്ചപ്പെടുത്താൻ താങ്കളുടെ അഭിപ്രായം ഞങ്ങളെ സഹായിക്കുന്നതാണ്. അത് &quot;$1&quot; താളിൽ പരസ്യമായി (താങ്കളുടെ ഉപയോക്തൃനാമത്തോടും, ബ്രൗസർ വേർഷനോടും ഓപ്പറേറ്റിങ് സിസ്റ്റത്തിനോടും കൂടി) ലഭ്യമായിരിക്കും. ദയവായി തലക്കെട്ട് കുറിപ്പായി വിവരദായകമായ ഒരു വരി നൽകുക, ഉദാ: "പട്ടിക പ്രദർശിപ്പിക്കുന്നതിലെ പ്രശ്നങ്ങൾ".
താങ്കളുടെ അഭിപ്രായം ഞങ്ങളുടെ ഉപയോഗനിബന്ധനകൾക്ക് വിധേയമായിരിക്കും.',
	'mobile-frontend-leave-feedback-warning' => 'താങ്കളുടെ വിവരങ്ങൾ പരസ്യമാകുന്നതിൽ താങ്കൾക്ക് അംഗീകരിക്കാനാകുന്നില്ലെങ്കിൽ, ദയവായി വ്യക്തിപരമായ വിവരങ്ങൾ കുറിപ്പിൽ ചേർക്കാതിരിക്കുക.',
	'mobile-frontend-leave-feedback-subject' => 'വിഷയം:',
	'mobile-frontend-leave-feedback-message' => 'സന്ദേശം:',
	'mobile-frontend-leave-feedback-submit' => 'അഭിപ്രായം സമർപ്പിക്കുക',
	'mobile-frontend-leave-feedback-link-text' => 'മൊബൈൽ ഫ്രണ്ട്എൻഡ് അനുബന്ധത്തെക്കുറിച്ചുള്ള അഭിപ്രായങ്ങൾ',
	'mobile-frontend-leave-feedback' => 'മൊബൈൽ സൈറ്റിനെക്കുറിച്ചുള്ള അഭിപ്രായങ്ങൾ',
	'mobile-frontend-leave-feedback-title' => 'മൊബൈൽ സൈറ്റ് അഭിപ്രായം',
	'mobile-frontend-leave-feedback-technical-problem-section-header' => 'സാങ്കേതിക തകരാറ്',
	'mobile-frontend-leave-feedback-general-section-header' => 'സർവ്വം',
	'mobile-frontend-leave-feedback-article-feedback-section-header' => 'ലേഖനത്തെക്കുറിച്ചുള്ള പ്രതികരണം',
	'mobile-frontend-leave-feedback-email-body' => 'ഈ വരിയുടെ മുകളിലായി {{SITENAME}} സംരംഭത്തിൽ അനുഭവപ്പെട്ട പ്രശ്നം ദയവായി വിവരിക്കുക. ഞങ്ങൾക്കു കിട്ടുന്ന എല്ലാ സന്ദേശങ്ങൾക്കും മറുപടിയയ്ക്കാൻ ഞങ്ങൾക്കു കഴിഞ്ഞേക്കില്ല എന്ന കാര്യം ഓർക്കുമല്ലോ.',
	'mobile-frontend-leave-feedback-technical-link-text' => 'സാങ്കേതിക തകരാറ്',
	'mobile-frontend-leave-feedback-general-link-text' => 'പൊതു അഭിപ്രായം',
	'mobile-frontend-leave-feedback-article-personal-link-text' => 'എന്നെക്കുറിച്ച്, വ്യക്തിയെന്ന നിലയിൽ അല്ലെങ്കിൽ ഞാൻ പ്രതിനിധീകരിക്കുന്ന കമ്പനിയെന്ന നിലയിൽ',
	'mobile-frontend-leave-feedback-article-factual-link-text' => 'ഒരു യഥാർത്ഥ പിഴവിനെക്കുറിച്ച്',
	'mobile-frontend-leave-feedback-article-other-link-text' => 'മറ്റൊരു പ്രശ്നത്തെക്കുറിച്ച്',
	'mobile-frontend-leave-feedback-form-subject-placeholder' => 'സന്ദേശത്തിന്റെ വിഷയം',
	'mobile-frontend-leave-feedback-form-message-placeholder' => 'താങ്കളുടെ കുറിപ്പ് ഇവിടെ ചേർക്കുക',
	'mobile-frontend-leave-feedback-page-title' => 'മൊബൈൽ സൈറ്റ് അഭിപ്രായം',
	'mobile-frontend-leave-feedback-special-title' => 'ഞങ്ങളെ ബന്ധപ്പെടുക',
	'mobile-frontend-feedback-no-subject' => '(വിഷയം നൽകിയിട്ടില്ല)',
	'mobile-frontend-feedback-no-subject-field' => 'വിഷയം ചേർക്കുക',
	'mobile-frontend-feedback-no-message' => 'സന്ദേശം ഇവിടെ നൽകുക',
	'mobile-frontend-feedback-edit-summary' => '$1 - [[Special:MobileFeedback|മൊബൈൽ അഭിപ്രായമറിയിക്കൽ ഉപകരണം]] ഉപയോഗിച്ച് സ്വയം അയച്ചു',
	'mobile-frontend-leave-feedback-thanks' => 'താങ്കളുടെ അഭിപ്രായത്തിനു വളരെ നന്ദി!',
	'mobile-frontend-leave-feedback-post-error' => 'താങ്കളുടെ സന്ദേശം കൈകാര്യം ചെയ്തുകൊണ്ടിരിക്കെ ഒരു പിഴവുണ്ടായിരിക്കുന്നു. ദയവായി അൽപ്പസമയത്തിനു ശേഷം ശ്രമിക്കുക.',
	'mobile-frontend-language' => 'ഭാഷ:',
	'mobile-frontend-language-article-heading' => 'മറ്റൊരു ഭാഷയിൽ വായിക്കുക',
	'mobile-frontend-language-header' => 'ഈ താൾ {{PLURAL:$1|ഒരു ഭാഷയിൽ|$1 ഭാഷകളിൽ}} ലഭ്യമാണ്',
	'mobile-frontend-language-variant-header' => '{{#language:{{CONTENTLANG}}}} ഭേദം തിരഞ്ഞെടുക്കുക',
	'mobile-frontend-language-footer' => 'കുറിപ്പ്: താങ്കളുടെ ആഗ്രഹിക്കുന്ന ഭാഷയിൽ ഈ താൾ ഉണ്ടായിരിക്കണമെന്നില്ല. ഇവിടെ ഞെക്കി {{SITENAME}} പിന്തുണയുള്ള ഭാഷകൾ കാണാവുന്നതാണ്.',
	'mobile-frontend-language-site-choose' => 'ഭാഷ തിരയുക',
	'mobile-frontend-username' => 'ഉപയോക്തൃനാമം:',
	'mobile-frontend-password' => 'രഹസ്യവാക്ക്:',
	'mobile-frontend-username-placeholder' => 'ഉപയോക്തൃനാമം',
	'mobile-frontend-password-placeholder' => 'രഹസ്യവാക്ക്',
	'mobile-frontend-login' => 'പ്രവേശിക്കുക',
	'mobile-frontend-last-modified-date' => 'അവസാനം പുതുക്കപ്പെട്ടത് $1, $2',
	'mobile-frontend-last-modified-seconds' => '{{PLURAL:$1|ഒരു സെക്കൻഡ്|$1 സെക്കൻഡ്}} മുമ്പാണ് അവസാനം പുതുക്കിയത്',
	'mobile-frontend-last-modified-minutes' => '{{PLURAL:$1|ഒരു മിനിറ്റ്|$1 മിനിറ്റ്}} മുമ്പാണ് അവസാനം പുതുക്കിയത്',
	'mobile-frontend-last-modified-hours' => '{{PLURAL:$1|ഒരു മണിക്കൂർ|$1 മണിക്കൂർ}} മുമ്പാണ് അവസാനം പുതുക്കിയത്',
	'mobile-frontend-last-modified-days' => '{{PLURAL:$1|ഒരു ദിവസം|$1 ദിവസം}} മുമ്പാണ് അവസാനം പുതുക്കിയത്',
	'mobile-frontend-last-modified-months' => '{{PLURAL:$1|ഒരു മാസം|$1 മാസം}} മുമ്പാണ് അവസാനം പുതുക്കിയത്',
	'mobile-frontend-last-modified-years' => '{{PLURAL:$1|ഒരു വർഷം|$1 വർഷം}} മുമ്പാണ് അവസാനം പുതുക്കിയത്',
	'mobile-frontend-account-create-submit' => 'അംഗത്വമെടുക്കുക',
	'mobile-frontend-password-confirm-placeholder' => 'രഹസ്യവാക്ക് സ്ഥിരീകരിക്കുക',
	'mobile-frontend-account-create-email-placeholder' => 'ഇമെയിൽ വിലാസം (ഐച്ഛികം)',
	'mobile-frontend-account-create-captcha-placeholder' => 'സുരക്ഷാ വാക്യം നൽകുക',
	'mobile-frontend-overlay-escape' => 'പഴയ താളിലേയ്ക്ക് മടങ്ങുക',
	'mobile-frontend-placeholder' => '{{SITENAME}} സംരംഭത്തിൽ തിരയുക',
	'mobile-frontend-placeholder-beta' => '{{SITENAME}} (ബീറ്റ) സംരംഭത്തിൽ തിരയുക',
	'mobile-frontend-placeholder-alpha' => '{{SITENAME}} തിരയുക (ഡ്രാഗൺ മോഡ്)',
	'mobile-frontend-search-help' => 'തിരയാനുള്ള പദം മുകളിൽ നൽകുക, ചേർച്ചയുള്ള താളുകളുടെ തലക്കെട്ടുകൾ ഇവിടെ വരും.',
	'mobile-frontend-dismiss-notification' => 'ഈ അറിയിപ്പ് ഒഴിവാക്കുക',
	'mobile-frontend-clear-search' => 'ശൂന്യമാക്കുക',
	'mobile-frontend-privacy-link-text' => 'സ്വകാര്യത',
	'mobile-frontend-about-link-text' => 'വിവരണം',
	'mobile-frontend-footer-sitename' => '{{SITENAME}}',
	'mobile-frontend-footer-license-text' => 'ഉള്ളടക്കം [//en.m.wikipedia.org/wiki/Wikipedia:Text_of_Creative_Commons_Attribution-ShareAlike_3.0_Unported_License?useformat=mobile സി.സി. ബൈ-എസ്.എ. 3.0] പ്രകാരം ലഭ്യം',
	'mobile-frontend-terms-use-text' => '[//wikimediafoundation.org/wiki/Terms_of_use?useformat=mobile ഉപയോഗനിബന്ധനകൾ]',
	'mobile-frontend-footer-contact' => 'സമ്പർക്കം',
	'mobile-frontend-search-noresults' => 'താങ്കൾ തിരഞ്ഞതുമായി സാമ്യമുള്ള താളുകൾ ഒന്നുമില്ല. ദയവായി മാറ്റി തിരയുക, അല്ലെങ്കിൽ കീബോർഡ് തിരച്ചിൽ ബട്ടൺ ഉപയോഗിച്ച് താളുകൾക്കുള്ളിൽ തിരയുക.',
	'mobile-frontend-main-menu-button-tooltip' => 'പ്രധാന മെനു തുറക്കുക',
	'mobile-frontend-main-menu-page-title' => 'സൈറ്റിലൂടെ ഗമിക്കൽ',
	'mobile-frontend-main-menu-featured' => 'തിരഞ്ഞെടുക്കപ്പെട്ടത്',
	'mobile-frontend-main-menu-nearby' => 'സമീപസ്ഥം',
	'mobile-frontend-main-menu-login' => 'പ്രവേശിക്കുക',
	'mobile-frontend-main-menu-logout' => 'ലോഗൗട്ട്',
	'mobile-frontend-main-menu-watchlist' => 'ശ്രദ്ധിക്കുന്നവ',
	'mobile-frontend-main-menu-settings' => 'സജ്ജീകരണങ്ങൾ',
	'mobile-frontend-main-menu-upload' => 'അപ്‌ലോഡ്', # Fuzzy
	'mobile-frontend-main-menu-settings-heading' => 'മൊബൈൽ സൈറ്റ് സജ്ജീകരണങ്ങൾ',
	'mobile-frontend-settings-site-header' => '{{SITENAME}} ലഭ്യമായ ഭാഷകൾ',
	'mobile-frontend-settings-site-description' => '{{PLURAL:$1|ഒരു ഭാഷയിൽ|$1 ഭാഷകളിൽ}} {{SITENAME}} ലഭ്യമാണ്. എല്ലാ പതിപ്പുകളും താഴെക്കൊടുത്തിരിക്കുന്നു.',
	'mobile-frontend-main-menu-contact' => 'സമ്പർക്കം',
	'mobile-frontend-main-menu-account-create' => 'അംഗത്വമെടുക്കുക',
	'mobile-frontend-page-menu-contents' => 'ഉള്ളടക്കം',
	'mobile-frontend-page-menu-history' => 'നാൾവഴി',
	'mobile-frontend-meta-data-issues-header' => 'പ്രശ്നങ്ങൾ',
	'mobile-frontend-meta-data-issues' => 'ഈ താളിൽ ചില പ്രശ്നങ്ങളുണ്ട്',
	'mobile-frontend-ajax-page-loading' => '$1 ശേഖരിക്കുന്നു',
	'mobile-frontend-page-saving' => '$1 സേവ് ചെയ്യുന്നു',
	'mobile-frontend-ajax-page-error' => 'അയ്യോ! എന്തോ കുഴപ്പമുണ്ടായിരിക്കുന്നു. ദയവായി താങ്കളുടെ ബ്രൗസർ ജാലകം പുതുക്കി ശ്രമിക്കുക.',
	'mobile-frontend-nearby-title' => 'സമീപസ്ഥം',
	'mobile-frontend-nearby-loading' => 'താങ്കൾ നിൽക്കുന്ന സ്ഥാനത്തിനു സമീപമുള്ള വിഷയങ്ങൾ ശേഖരിക്കുന്നു',
	'mobile-frontend-nearby-requirements' => 'ഈ താളിന്റെ പ്രവർത്തനത്തിനായി ജാവാസ്ക്രിപ്റ്റും സ്ഥലബോധമുള്ള ബ്രൗസറും ആവശ്യമാണ്.',
	'mobile-frontend-nearby-distance-report' => 'താങ്കൾ നിൽക്കുന്ന സ്ഥലത്തുനിന്നും $1കി.മീ. അകലെ',
	'mobile-frontend-nearby-lookup-error' => 'താങ്കളെ കണ്ടെത്താനായില്ല. വീണ്ടും ശ്രമിക്കുക..',
	'mobile-frontend-nearby-noresults' => 'താങ്കൾ ശൂന്യതയുടെ മദ്ധ്യത്തിലാണോ? ഞങ്ങൾക്ക് വിഷങ്ങളൊന്നും കണ്ടെത്താനായില്ല. എന്തുകൊണ്ടൊരെണ്ണം എഴുതിക്കൂടാ?',
	'mobile-frontend-nearby-refresh' => 'താങ്കളുടെ കൂടുതൽ കൃത്യമായ സ്ഥാനം ഞങ്ങൾക്ക് കണ്ടെത്താനായി. താങ്കളുടെ സമീപസ്ഥമായ താളുകൾ പുതുക്കാനായി ഇവിടെ ഞെക്കുക',
	'mobile-frontend-nearby-error' => 'താങ്കളുടെ സമീപസ്ഥമായ താളുകൾ കണ്ടുപിടിക്കുന്നതിനിടെ ഒരപ്രതീക്ഷിത പിഴവുണ്ടായി',
	'mobile-frontend-donate-image-login' => 'താങ്കൾ അപ്‌ലോഡ് ചെയ്തവ കാണണമെങ്കിൽ പ്രവേശിച്ചിരിക്കണം.',
	'mobile-frontend-photo-upload-generic' => 'ഒരു ചിത്രം സംഭാവന ചെയ്യുക',
	'mobile-frontend-donate-image-title' => 'ഒരു ചിത്രം സംഭാവന ചെയ്യുക',
	'mobile-frontend-donate-image-summary' => 'ചിത്രങ്ങൾ {{SITENAME}} താളുകൾ ജീവസ്സുറ്റതാക്കുന്നു.
സ്വതന്ത്രമായ അനുമതിയില്ലാത്ത ചിത്രങ്ങളുടെ കുറവൊന്നുകൊണ്ടുമാത്രം നിരവധി താളുകൾ ഒരൊറ്റ ചിത്രവുമില്ലാതെയുണ്ട്.
ഈ താളുകൾക്കായി താങ്കൾക്ക് ചിത്രങ്ങൾ സംഭാവന ചെയ്യാവുന്നതാണ്, അവ വിശാലമായ {{SITENAME}} തിരുത്തൽ സമൂഹം ഫലപ്രദമായി ഉപയോഗിച്ചുകൊള്ളും.',
	'mobile-frontend-donate-image-heading' => 'താങ്കളുടെ സമീപകാല സംഭാവനകൾ',
	'mobile-frontend-donate-image-page-title' => 'അപ്‌ലോഡ്',
	'mobile-frontend-donate-image-anon' => 'അപ്‌ലോഡുകളുടെ താൾ കാണാനായി ഒരു [[Special:UserLogin|ഉപയോക്തൃ അംഗത്വം]] ആവശ്യമാണ്',
	'mobile-frontend-listed-image-no-description' => 'വിവരണമൊന്നുമില്ല',
	'mobile-frontend-donate-photo-upload-success' => 'വിജയകരം! താങ്കളെടുത്ത ചിത്രം {{SITENAME}} സംരംഭത്തിൽ ഇനി ഉപയോഗിക്കാം!',
	'mobile-frontend-donate-photo-first-upload-success' => 'വിജയകരം! താങ്കളുടെ ആദ്യസംഭാവനയ്ക്ക് നന്ദി!',
	'mobile-frontend-watchlist-add' => '$1 താങ്കൾ ശ്രദ്ധിക്കുന്ന താളുകളുടെ പട്ടികയിലേയ്ക്ക് ചേർത്തു',
	'mobile-frontend-watchlist-removed' => '$1 താങ്കൾ ശ്രദ്ധിക്കുന്ന താളുകളുടെ പട്ടികയിൽ നിന്ന് നീക്കി',
	'mobile-frontend-watchlist-view' => 'താങ്കൾ ശ്രദ്ധിക്കുന്നവയുടെ പട്ടിക കാണുക',
	'mobile-frontend-watchlist-more' => 'കൂടുതൽ',
	'mobile-frontend-watchlist-cta' => 'ഈ താൾ ശ്രദ്ധിക്കുന്നവയുടെ പട്ടികയിലേക്ക് ചേർക്കാൻ ലോഗിൻ ചെയ്യുക അല്ലെങ്കിൽ അംഗത്വമെടുക്കുക.',
	'mobile-frontend-watchlist-cta-button-login' => 'പ്രവേശിക്കുക',
	'mobile-frontend-watchlist-cta-button-signup' => 'അംഗത്വമെടുക്കുക',
	'mobile-frontend-watch-login' => 'ശ്രദ്ധിക്കുന്ന താളുകൾ കാണണമെങ്കിൽ താങ്കൾ പ്രവേശിച്ചിരിക്കണം.',
	'mobile-frontend-watchlist-a-z' => 'എല്ലാം',
	'mobile-frontend-watchlist-feed' => 'പുതുക്കപ്പെട്ടവ',
	'mobile-frontend-watchlist-a-z-empty' => 'താങ്കളിപ്പോൾ താളുകളൊന്നും ശ്രദ്ധിക്കുന്നില്ല',
	'mobile-frontend-watchlist-a-z-empty-howto-alt' => 'താളിനു മുകളിലുള്ള നക്ഷത്രത്തിൽ ഞെക്കുക',
	'mobile-frontend-watchlist-a-z-empty-howto' => 'താങ്കൾക്ക് താത്പര്യം തോന്നുന്ന താൾ ശ്രദ്ധിക്കാനായി സ്ക്രീനിനു മുകളിലായി കാണാവുന്ന നക്ഷത്രത്തിൽ ഞെക്കുക. ഇതുവഴി താങ്കൾക്ക് താത്പര്യമുള്ള താളുകൾ ബുക്ക്മാർക്ക് ചെയ്യാനും, അവയിൽ മാറ്റം വന്നാൽ കാണാനും കഴിയുന്നതാണ്.',
	'mobile-frontend-watchlist-feed-empty' => 'സമീപകാലത്ത് മാറ്റങ്ങളുണ്ടായ താളുകളൊന്നുമില്ല',
	'mobile-frontend-watchlist-back-home' => 'പ്രധാന താളിലേയ്ക്ക് മടങ്ങുക',
	'mobile-frontend-changeslist-ip' => 'അജ്ഞാത ഉപയോക്താവ്',
	'mobile-frontend-changeslist-nocomment' => 'തിരുത്തലിനു സംഗ്രഹമില്ല',
	'mobile-frontend-watchlist-filter-all' => 'എല്ലാം',
	'mobile-frontend-watchlist-filter-articles' => 'ലേഖനങ്ങൾ',
	'mobile-frontend-watchlist-filter-talk' => 'സംവാദം',
	'mobile-frontend-watchlist-filter-other' => 'മറ്റുള്ളവ',
	'mobile-frontend-watchlist-modified' => 'പുതുക്കപ്പെട്ടത് $1',
	'mobile-frontend-diffview-404-title' => 'മോശം നാൾപ്പതിപ്പ്',
	'mobile-frontend-diffview-404-desc' => 'താങ്കൾ ആവശ്യപ്പെട്ട നാൾപ്പതിപ്പിന്റെ ഐ.ഡി. നിലവിലില്ല',
	'mobile-frontend-diffview-title' => 'മാറ്റങ്ങൾ',
	'mobile-frontend-diffview-editcount' => '{{PLURAL:$1|ഒരു തിരുത്തൽ|$1 തിരുത്തലുകൾ}}',
	'mobile-frontend-diffview-anonymous' => 'അജ്ഞാത ഉപയോക്താവ്',
	'mobile-frontend-diffview-bytesadded' => '{{PLURAL:$1|ഒരു ബൈറ്റ്|$1 ബൈറ്റുകൾ}} കൂട്ടിച്ചേർത്തിരിക്കുന്നു',
	'mobile-frontend-diffview-bytesremoved' => '{{PLURAL:$1|ഒരു ബൈറ്റ്|$1 ബൈറ്റുകൾ}} നീക്കംചെയ്തിരിക്കുന്നു',
	'mobile-frontend-diffview-explained' => 'താഴെപ്പറയുന്ന വരികൾ ചേർക്കുകയും (+) നീക്കം ചെയ്യുകയും (-)‌‌ ചെയ്തിട്ടുണ്ട്:',
	'mobile-frontend-table' => 'പട്ടിക $1',
	'mobile-frontend-saving-exit-page' => 'താങ്കളുടെ സംഭാവന ഇപ്പോഴും സേ‌വ് ചെയ്തുകൊണ്ടിരിക്കുന്നു. താങ്കൾ ഇപ്പോൾ പോവുകയാണെങ്കിൽ, താങ്കളുടെ സേവനങ്ങൾ നഷ്ടപ്പെടുന്നതാണ്. പുറത്തുകടക്കണമെന്ന് താങ്കൾക്കുറപ്പാണോ?',
	'mobile-frontend-photo-upload' => 'ഈ ലേഖനത്തിലേയ്ക്ക് ആദ്യ ചിത്രം ചേർക്കുക',
	'mobile-frontend-photo-article-edit-comment' => 'താളിൽ ഉപയോഗിക്കാനായി ചിത്രം ചേർത്തു',
	'mobile-frontend-photo-article-donate-comment' => 'മൊബൈലിൽ നിന്നും ഒരു ചിത്രം സംഭാവന ചെയ്തു',
	'mobile-frontend-photo-upload-comment' => 'താളിൽ ചിത്രം ചേർത്തു',
	'mobile-frontend-photo-caption-placeholder' => 'വിവരണം ചേർക്കുക (ആവശ്യമാണ്)',
	'mobile-frontend-image-loading' => 'ചിത്രം എടുക്കുന്നു',
	'mobile-frontend-image-uploading-wait' => 'ചിത്രം അപ്‌ലോഡ് ചെയ്യുന്നു, ദയവായി കാത്തിരിക്കുക.',
	'mobile-frontend-image-uploading-long' => 'ചിത്രം ഇപ്പോഴും അപ്‌ലോഡ് ചെയ്യുകയാണ്! താങ്കളുടെ ക്ഷമയ്ക്ക് നന്ദി.',
	'mobile-frontend-image-uploading-cancel' => 'ഇതിനു വളരെ കാലതാമസമുണ്ടെങ്കിൽ <a href="#">റദ്ദാക്കുക</a>.',
	'mobile-frontend-photo-upload-error' => 'പിഴവുണ്ടായി, വീണ്ടും ശ്രമിക്കുക.',
	'mobile-frontend-photo-upload-success-article' => 'വിജയകരം! താങ്കളുടെ ചിത്രം ഇനി ഈ താളിൽ കാണാവുന്നതാണ്.',
	'mobile-frontend-photo-license' => '"സമർപ്പിക്കുക" എന്നത് ഞെക്കുമ്പോൾ, താങ്കൾ ഞങ്ങളുടെ [//wikimediafoundation.org/wiki/Terms_of_Use/ml ഉപയോഗനിബന്ധനകൾ] പാലിക്കാമെന്നും, താങ്കളെടുത്ത ചിത്രം  [//en.wikipedia.org/wiki/Wikipedia:Text_of_Creative_Commons_Attribution-ShareAlike_3.0_Unported_License ക്രിയേറ്റീവ് കോമൺസ് ആട്രിബ്യൂഷൻ-ഷെയർ‌എലൈക് 3.0 അനുവാദപത്രം] പ്രകാം പ്രസിദ്ധീകരിക്കുന്നുവെന്നും സമ്മതിക്കുന്നുണ്ട്.',
	'mobile-frontend-photo-submit' => 'സമർപ്പിക്കുക',
	'mobile-frontend-photo-cancel' => 'റദ്ദാക്കുക',
	'mobile-frontend-photo-upload-user-count' => '{{PLURAL:$1|ഒരു അപ്‌ലോഡ്|$1 അപ്‌ലോഡുകൾ}}',
	'mobile-frontend-photo-upload-user-count-over-limit' => '500+ അപ്‌ലോഡുകൾ',
	'tag-mobile_edit' => 'മൊബൈൽ സൈറ്റ്',
	'tag-mobile_edit-description' => 'മൊബൈൽ സൈറ്റ് വഴി വരുത്തിയ തിരുത്തുകൾ',
	'mobile-frontend-drawer-cancel' => 'റദ്ദാക്കുക',
);

/** Mongolian (монгол)
 */
$messages['mn'] = array(
	'mobile-frontend-search-submit' => 'Явах',
	'mobile-frontend-home-button' => 'Нүүр',
	'mobile-frontend-random-button' => 'Санамсаргүй',
	'mobile-frontend-back-to-top-of-section' => 'Өмнөх хэсэг руу буцах',
	'mobile-frontend-show-button' => 'Үзүүлэх',
	'mobile-frontend-hide-button' => 'Нуух',
	'mobile-frontend-regular-site' => 'Энэ хуудсыг ердийн Википедиа дээр үзэх', # Fuzzy
	'mobile-frontend-featured-article' => 'Өнөөдрийн онцлох өгүүлэл',
);

/** Moldavian (молдовеняскэ)
 */
$messages['mo'] = array(
	'mobile-frontend-search-submit' => 'Ду-те',
	'mobile-frontend-random-button' => 'Аляториу',
	'mobile-frontend-show-button' => 'Аратэ',
	'mobile-frontend-hide-button' => 'Аскунде',
);

/** Marathi (मराठी)
 * @author Evision
 * @author Kaajawa
 * @author Mahitgar
 * @author Prabodh1987
 * @author Rahuldeshmukh101
 * @author Sau6402
 * @author Shantanoo
 * @author Skomal
 * @author V.narsikar
 */
$messages['mr'] = array(
	'mobile-frontend-desc' => 'मोबाइल फ्रंटएंड',
	'mobile-frontend-search-submit' => 'चला',
	'mobile-frontend-home-button' => 'मुखपृष्ठ',
	'mobile-frontend-logged-out' => 'माझे नाव कोमल आहे. मी फोरसाइट महाविद्यालयात शिकत आहे. मि बी.सी.ए. करत आहे. वि',
	'mobile-frontend-sign-up-heading' => 'नमस्कार..........शुभ प्रभात!!!!!!!!!!!!!!! माझे नाव कोमल आहे. तु मी कसे आहात???????? मी  खुप शान आहे.. मि उद्या घरी येनार आहे. माझे गाव',
	'mobile-frontend-random-button' => 'अविशिष्ट',
	'mobile-frontend-back-to-top-of-section' => 'एक विभाग मागे जा',
	'mobile-frontend-show-button' => 'दाखवा',
	'mobile-frontend-hide-button' => 'लपवा',
	'mobile-frontend-regular-site' => 'हे पृष्ठ सामान्य {{SITENAME}}मधे पाहा', # Fuzzy
	'mobile-frontend-wml-continue' => 'सुरु ठेवा ...',
	'mobile-frontend-wml-back' => 'माघारी',
	'mobile-frontend-view' => 'लघु-दृश्य',
	'mobile-frontend-opt-in-explain' => 'बीटा जॉईन करून तुम्हाला एक्सपेरिमेंटल फिचर्सचा उपयोग करता येईल ,अर्थात बग्स आणी इतर अवघड स्थिती अनुभवण्याची मानसिक तयारी ठेवावी',
	'mobile-frontend-images-status' => 'चित्रे',
	'mobile-frontend-disable-images' => 'मोबाईल साईटवरील प्रतिमा अक्षम करा',
	'mobile-frontend-enable-images' => 'मोबाईल साईटवरील प्रतिमा सक्षम करा',
	'mobile-frontend-off' => 'बंद',
	'mobile-frontend-on' => 'सुरु',
	'mobile-frontend-featured-article' => 'आजचा लेख',
	'mobile-frontend-news-items' => 'बातम्यांमध्ये',
	'mobile-frontend-leave-feedback-notice' => 'तुमचा प्रतिसाद मोबाईल संस्थळावरील तुमचा अनुभव सुधारण्याच्या दृष्टीने आम्हाला मदतकारक सिद्ध होतो.आपला प्रतिसाद आपल्या ब्राऊजर व्हर्शन आणि ऑपरेटींग सिस्टीम  आणि आपल्या सदस्य नावा सोबत  संबधीत पानावरील नोंद कुणीही वाचू शकेल अशा जाहीर स्वरूपाची असेल हे लक्षात घ्या.&quot;$1&quot;. .शक्यतो विषयनावाची ओळ  माहितीपूर्ण स्वरूपात देण्याचा प्रयत्न करा जसे कि ,"Formatting issues with wide tables".
आपला प्रतिसाद आमच्या वापरण्याच्या अटींनी बाध्य असेल.',
	'mobile-frontend-leave-feedback-subject' => 'विषय', # Fuzzy
	'mobile-frontend-leave-feedback-message' => 'संदेश', # Fuzzy
	'mobile-frontend-leave-feedback-submit' => 'प्रतिक्रिया द्या',
	'mobile-frontend-leave-feedback-link-text' => 'मोबाइल फ्रंटएंड एक्सटेंनशन प्रतिक्रिया',
	'mobile-frontend-leave-feedback' => 'मोबाइल साइट  प्रतिसाद',
	'mobile-frontend-leave-feedback-title' => 'आपल्या मोबाइल साइट अनुभवा बद्दल  प्रतिक्रिया नोंदवा.आपल्या प्रतिक्रीया भविष्यातील सुधारणात मदतकारक ठरते.',
	'mobile-frontend-leave-feedback-general-section-header' => 'साधारण',
	'mobile-frontend-leave-feedback-page-title' => 'आपल्या मोबाइल साइट अनुभवा बद्दल  प्रतिक्रिया नोंदवा.आपल्या प्रतिक्रीया भविष्यातील सुधारणात मदतकारक ठरते.',
	'mobile-frontend-leave-feedback-thanks' => 'आपल्या प्रतिक्रियेबद्दल आभार !',
	'mobile-frontend-language' => 'भाषा', # Fuzzy
	'mobile-frontend-username' => 'सदस्य नाव:',
	'mobile-frontend-password' => 'परवलीचा शब्द',
	'mobile-frontend-login' => 'प्रवेश करा',
	'mobile-frontend-placeholder' => 'आपला  हवा असलेला शोध येथे टंकलिखित करा ...', # Fuzzy
	'mobile-frontend-dismiss-notification' => 'ही सुचना पुसा',
	'mobile-frontend-clear-search' => 'स्पष्ट',
	'mobile-frontend-privacy-link-text' => 'एकान्त',
	'mobile-frontend-about-link-text' => 'बद्दल माहिती',
	'mobile-frontend-footer-sitename' => '{{SITENAME}}',
	'mobile-frontend-footer-contact' => 'संपर्क',
	'mobile-frontend-main-menu-nearby' => 'जवळपास',
	'mobile-frontend-main-menu-settings' => 'मांडणी',
	'mobile-frontend-settings-site-header' => '{{SITENAME}} भाषा',
	'mobile-frontend-main-menu-contact' => 'संपर्क',
	'mobile-frontend-page-menu-contents' => 'मजकूर',
);

/** Malay (Bahasa Melayu)
 * @author Anakmalaysia
 */
$messages['ms'] = array(
	'mobile-frontend-desc' => 'Mobile Frontend',
	'mobile-frontend-search-submit' => 'Pergi',
	'mobile-frontend-home-button' => 'Laman Utama',
	'mobile-frontend-logged-out' => 'Belum log masuk',
	'mobile-frontend-logged-in-homepage-notification' => 'Selamat datang, $1!',
	'mobile-frontend-logged-in-toast-notification' => 'Log masuk sebagai $1.',
	'mobile-frontend-sign-up-heading' => 'Daftar diri',
	'mobile-frontend-sign-in-heading' => 'Log masuk',
	'mobile-frontend-sign-in-why' => 'Jika anda memegang akaun di {{SITENAME}}, anda boleh log masuk di bawah.',
	'mobile-frontend-sign-in-error-heading' => 'Alamak!',
	'mobile-frontend-settings-description' => 'Mudahkan penggunaan dengan tetapan yang khusus untuk kegunaan peranti mudah alih.',
	'mobile-frontend-settings-beta' => 'Beta',
	'mobile-frontend-settings-alpha' => 'Mod waspada',
	'mobile-frontend-settings-alpha-description' => 'Masuki wilayah mobil yang bahaya dan belum dijelajahi. Dapatkan lebih banyak ciri-ciri dalam percubaan tetapi awas, ada pepijat!',
	'mobile-frontend-save-settings' => 'Simpan tetapan',
	'mobile-frontend-random-button' => 'Rawak',
	'mobile-frontend-ajax-random-heading' => 'Mencari pengetahuan...',
	'mobile-frontend-ajax-random-quote' => 'Pertumbuhan intelek seharusnya bermula pada saat lahir, dan berhenti pada saat ajal sahaja.',
	'mobile-frontend-ajax-random-question' => 'Baca halaman ini?',
	'mobile-frontend-ajax-random-yes' => 'Ya',
	'mobile-frontend-ajax-random-retry' => 'Cuba lagi',
	'mobile-frontend-ajax-random-suggestions' => 'Cadangan lain:',
	'mobile-frontend-back-to-top-of-section' => 'Undur Satu Bahagian',
	'mobile-frontend-close-section' => 'Tutup bahagian ini',
	'mobile-frontend-show-button' => 'Tunjukkan',
	'mobile-frontend-hide-button' => 'Sorokkan',
	'mobile-frontend-empty-homepage-text' => 'Halaman utama ini perlu dikonfigurasikan. [//meta.wikimedia.org/wiki/Mobile_Projects/Mobile_Gateway#Mobile_homepage Panduan menghidupkan mod peranti mudah alih (mobil)]',
	'mobile-frontend-regular-site' => 'Paparan desktop',
	'mobile-frontend-wml-continue' => 'Teruskan ...',
	'mobile-frontend-wml-back' => 'Kembali ...',
	'mobile-frontend-view' => 'Paparan Mudah Alih',
	'mobile-frontend-view-desktop' => 'Desktop',
	'mobile-frontend-view-mobile' => 'Mudah Alih',
	'mobile-frontend-opt-in-explain' => 'Dengan menyertai beta ini, anda akan mendapat capaian kepada ciri-ciri percubaan, tetapi anda mungkin akan berdepan dengan pepijat dan masalah-masalah yang seumpamanya.',
	'mobile-frontend-images-status' => 'Gambar',
	'mobile-frontend-disable-images' => 'Matikan imej di tapak mudah alih',
	'mobile-frontend-enable-images' => 'Membolehkan imej di tapak mudah alih',
	'mobile-frontend-missing-image' => 'Imej',
	'mobile-frontend-off' => 'TUTUP',
	'mobile-frontend-on' => 'BUKA',
	'mobile-frontend-footer-contributors-text' => 'Halaman oleh [penyumbang-penyumbang $1] seperti anda',
	'mobile-frontend-featured-article' => 'Rencana Pilihan',
	'mobile-frontend-news-items' => 'Dalam Berita',
	'mobile-frontend-leave-feedback-notice' => 'Maklum balas anda membantu kami untuk meningkatkan pengalaman anda ketika melayari tapak mudah alih. Ia akan disiarkan secara umum (dengan nama pengguna, versi pelayar dan sistem pengendalian) pada laman &quot;$1&quot;. Sila cuba memilih baris subjek yang informatif, cth. "Masalah ketika memformatkan jadual yang lebar". Maklum balas anda tertakluk kepada terma-terma penggunaan kami.',
	'mobile-frontend-leave-feedback-warning' => 'Melainkan anda bersetuju untuk mendedahkan maklumat anda kepada umum, tolong jangan sertakan maklumat peribadi dalam komen anda.',
	'mobile-frontend-leave-feedback-subject' => 'Perkara:',
	'mobile-frontend-leave-feedback-message' => 'Pesanan:',
	'mobile-frontend-leave-feedback-submit' => 'Hantar Maklum Balas',
	'mobile-frontend-leave-feedback-link-text' => 'Maklum balas Mobile Frontend',
	'mobile-frontend-leave-feedback' => 'Tinggalkan maklum balas',
	'mobile-frontend-leave-feedback-title' => 'Maklum balas tapak mudah alih',
	'mobile-frontend-leave-feedback-technical-problem-section-header' => 'Masalah teknikal',
	'mobile-frontend-leave-feedback-general-section-header' => 'Umum',
	'mobile-frontend-leave-feedback-article-feedback-section-header' => 'Maklum balas rencana',
	'mobile-frontend-leave-feedback-email-body' => 'Sila jelaskan masalah yang anda hadapi di {{SITENAME}} di atas baris ini. Sila ambil maklum bahawa kami tidak boleh membalas setiap pesanan yang kami terima.',
	'mobile-frontend-leave-feedback-technical-link-text' => 'Masalah teknikal',
	'mobile-frontend-leave-feedback-general-link-text' => 'Maklum balas am',
	'mobile-frontend-leave-feedback-article-personal-link-text' => 'Berkenaan, seseorang atau sesebuah syarikat yang saya wakili',
	'mobile-frontend-leave-feedback-article-factual-link-text' => 'Berkenaan kesalahan fakta',
	'mobile-frontend-leave-feedback-article-other-link-text' => 'Berkenaan masalah lain',
	'mobile-frontend-leave-feedback-form-subject-placeholder' => 'Tajuk pesanan',
	'mobile-frontend-leave-feedback-form-message-placeholder' => 'Isikan ulasan anda di sini',
	'mobile-frontend-leave-feedback-page-title' => 'Maklum balas tapak mudah alih',
	'mobile-frontend-leave-feedback-special-title' => 'Hubungi kami',
	'mobile-frontend-feedback-no-subject' => '(tiada subjek)',
	'mobile-frontend-feedback-no-subject-field' => 'Sila isikan tajuk',
	'mobile-frontend-feedback-no-message' => 'Sila isikan pesanan di sini',
	'mobile-frontend-feedback-edit-summary' => '$1 - diposkan secara automatik dengan [[Special:MobileFeedback|alat maklum balas mudah alih]]',
	'mobile-frontend-leave-feedback-thanks' => 'Terima kasih atas maklum balas anda!',
	'mobile-frontend-leave-feedback-post-error' => 'Terdapat masalah dalam memproses pesanan anda. Sila cuba semula sebentar lagi.',
	'mobile-frontend-language' => 'Bahasa:',
	'mobile-frontend-language-article-heading' => 'Baca dalam bahasa lain',
	'mobile-frontend-language-header' => 'Halaman ini disediakan dalam $1 bahasa',
	'mobile-frontend-language-variant-header' => 'Pilih varian {{#language:{{CONTENTLANG}}}}',
	'mobile-frontend-language-footer' => 'Perhatian: Halaman ini mungkin tidak tersedia dalam bahasa keutamaan anda. Anda boleh melihat bahasa-bahasa mana yang disokong oleh {{SITENAME}} dengan mengklik di sini.',
	'mobile-frontend-language-site-choose' => 'Bahasa carian',
	'mobile-frontend-username' => 'Nama pengguna:',
	'mobile-frontend-password' => 'Kata laluan:',
	'mobile-frontend-username-placeholder' => 'Nama pengguna',
	'mobile-frontend-password-placeholder' => 'Kata laluan',
	'mobile-frontend-login' => 'Log masuk',
	'mobile-frontend-last-modified-date' => 'Kali terakhir disunting pada $1, $2',
	'mobile-frontend-last-modified-seconds' => 'Kali terakhir disunting $1 saat lepas',
	'mobile-frontend-last-modified-minutes' => 'Kali terakhir disunting $1 minit lepas',
	'mobile-frontend-last-modified-hours' => 'Kali terakhir disunting $1 jam lepas',
	'mobile-frontend-last-modified-days' => 'Kali terakhir disunting $1 hari lepas',
	'mobile-frontend-last-modified-months' => 'Kali terakhir disunting $1 bulan lepas',
	'mobile-frontend-last-modified-years' => 'Kali terakhir disunting $1 tahun lepas',
	'mobile-frontend-account-create-submit' => 'Daftar diri',
	'mobile-frontend-password-confirm-placeholder' => 'Sahkan kata laluan',
	'mobile-frontend-account-create-email-placeholder' => 'Alamat e-mel (pilihan)',
	'mobile-frontend-account-create-captcha-placeholder' => 'Taipkan teks keselamatan',
	'mobile-frontend-overlay-escape' => 'Kembali',
	'mobile-frontend-placeholder' => 'Cari dalam {{SITENAME}}',
	'mobile-frontend-placeholder-beta' => 'Cari dalam {{SITENAME}} (Beta)',
	'mobile-frontend-placeholder-alpha' => 'Cari dalam {{SITENAME}} (Mod Waspada)',
	'mobile-frontend-search-help' => 'Taipkan kata kunci di atas, dan tajuk-tajuk halaman yang berpadanan akan dipaparkan di sini.',
	'mobile-frontend-dismiss-notification' => 'abaikan pemberitahuan ini',
	'mobile-frontend-clear-search' => 'Padamkan',
	'mobile-frontend-privacy-link-text' => 'Privasi',
	'mobile-frontend-about-link-text' => 'Perihal',
	'mobile-frontend-footer-sitename' => '{{SITENAME}}',
	'mobile-frontend-footer-license-text' => 'Kandungan disediakan di bawah [//en.m.wikipedia.org/wiki/Wikipedia:Text_of_Creative_Commons_Attribution-ShareAlike_3.0_Unported_License?useformat=mobile CC BY-SA 3.0]',
	'mobile-frontend-terms-use-text' => '[//wikimediafoundation.org/wiki/Terms_of_use?useformat=mobile Syarat-Syarat Penggunaan]',
	'mobile-frontend-footer-contact' => 'Hubungi',
	'mobile-frontend-search-noresults' => 'Tiada tajuk halaman yang sepadan dengan carian anda. Ubah carian anda, atau tekan butang carian papan kekunci untuk mencari di dalam halaman.',
	'mobile-frontend-main-menu-button-tooltip' => 'Buka menu utama',
	'mobile-frontend-main-menu-page-title' => 'Pandu arah tapak',
	'mobile-frontend-main-menu-featured' => 'Sorotan',
	'mobile-frontend-main-menu-nearby' => 'Berdekatan',
	'mobile-frontend-main-menu-login' => 'Log masuk',
	'mobile-frontend-main-menu-logout' => 'Log keluar',
	'mobile-frontend-main-menu-watchlist' => 'Senarai pantau',
	'mobile-frontend-main-menu-settings' => 'Tetapan',
	'mobile-frontend-main-menu-upload' => 'Muatan naik',
	'mobile-frontend-main-menu-settings-heading' => 'Tetapan tapak mudah alih',
	'mobile-frontend-settings-site-header' => 'Bahasa-bahasa {{SITENAME}}',
	'mobile-frontend-settings-site-description' => '{{SITENAME}} terdapat dalam $1 bahasa. Berikut adalah semua versi yang ada',
	'mobile-frontend-main-menu-contact' => 'Hubungi',
	'mobile-frontend-main-menu-account-create' => 'Buka akaun',
	'mobile-frontend-page-menu-contents' => 'kandungan',
	'mobile-frontend-page-menu-history' => 'Sejarah',
	'mobile-frontend-meta-data-issues-header' => 'Isu',
	'mobile-frontend-meta-data-issues' => 'Halaman ini ada beberapa isu',
	'mobile-frontend-ajax-page-loading' => '$1 sedang dimuatkan',
	'mobile-frontend-page-saving' => 'Menyimpan $1',
	'mobile-frontend-ajax-page-error' => 'Maaf, ralat telah berlaku. Sila cuba segar semula tetingkap pelayar anda.',
	'mobile-frontend-nearby-title' => 'Berdekatan',
	'mobile-frontend-nearby-loading' => 'Memuatkan topik yang berdekatan dengan kedudukan semasa anda',
	'mobile-frontend-nearby-requirements' => 'Halaman ini memerlukan JavaScript dan pelayar yang peka lokasi.',
	'mobile-frontend-nearby-distance-report' => '$1km dari kedudukan anda sekarang',
	'mobile-frontend-nearby-lookup-error' => 'Tidak dapat mencari anda. Sedang mencuba lagi…',
	'mobile-frontend-nearby-noresults' => 'Entah di mana anda berada, kami tak dapat cari apa-apa topik. Apa kata anda tulis topik sendiri?',
	'mobile-frontend-nearby-refresh' => 'Kami telah menjumpai lokasi yang lebih tepat untuk anda. Klik di sini untuk memuat semula senarai halaman-halaman yang berdekatan.',
	'mobile-frontend-nearby-error' => 'Berlakunya ralat di luar jangkaan ketika cuba mencari halaman berdekatan',
	'mobile-frontend-donate-image-login' => 'Anda mesti log masuk untuk melihat muatan naik anda.',
	'mobile-frontend-photo-upload-generic' => 'Dermakan gambar',
	'mobile-frontend-donate-image-title' => 'Dermakan gambar',
	'mobile-frontend-donate-image-summary' => 'Gambar-gambar menghidupkan halaman-halaman {{SITENAME}}.
Terdapat banyak halaman yang ketiadaan gambar disebabkan ketandusan gambar yang berlesen bebas.
Tolong kami hidupkan halaman-halaman berkenaan dengan menghulurkan gambar-gambar yang sudi anda berikan dan mungkin berguna kepada seluruh komuniti penyunting {{SITENAME}}.',
	'mobile-frontend-donate-image-heading' => 'Sumbangan terkini anda',
	'mobile-frontend-donate-image-page-title' => 'Muat naik',
	'mobile-frontend-donate-image-anon' => '[[Special:UserLogin|Akaun pengguna]] diperlukan untuk melihat halaman muat naik',
	'mobile-frontend-listed-image-no-description' => 'Tiada keterangan',
	'mobile-frontend-donate-photo-upload-success' => 'Berjaya! Gambar anda kini boleh digunakan di {{SITENAME}}!',
	'mobile-frontend-donate-photo-first-upload-success' => 'Berjaya! Terima kasih atas sumbangan pertama anda!',
	'mobile-frontend-watchlist-add' => '$1 ditambahkan dalam senarai pantau anda',
	'mobile-frontend-watchlist-removed' => '$1 digugurkan dari senarai pantau anda',
	'mobile-frontend-watchlist-view' => 'Lihat senarai pantau anda',
	'mobile-frontend-watchlist-more' => 'lagi',
	'mobile-frontend-watchlist-cta' => 'Sila log masuk atau daftar diri untuk memantau halaman ini.',
	'mobile-frontend-watchlist-cta-button-login' => 'Log masuk',
	'mobile-frontend-watchlist-cta-button-signup' => 'Daftar diri',
	'mobile-frontend-watch-login' => 'Anda mesti log masuk untuk melihat halaman.',
	'mobile-frontend-watchlist-a-z' => 'Semua',
	'mobile-frontend-watchlist-feed' => 'Diubah',
	'mobile-frontend-watchlist-a-z-empty' => 'Anda tidak mengawasi sebarang halaman sekarang',
	'mobile-frontend-watchlist-a-z-empty-howto-alt' => 'Klik pada bintang di atas halaman',
	'mobile-frontend-watchlist-a-z-empty-howto' => 'Pantau halaman yang anda dapati menarik dengan mengklik ikon bintang di atas skrin. Ini akan membolehkan anda untuk mem-bookmark halaman yang menarik minat anda serta mengikuti perkembangan terbarunya.',
	'mobile-frontend-watchlist-feed-empty' => 'Tidak terdapat halaman dengan perubahan terkini',
	'mobile-frontend-watchlist-back-home' => 'Kembali ke halaman utama',
	'mobile-frontend-changeslist-ip' => 'Pengguna awanama',
	'mobile-frontend-changeslist-nocomment' => 'tiada ringkasan suntingan',
	'mobile-frontend-watchlist-filter-all' => 'Semua',
	'mobile-frontend-watchlist-filter-articles' => 'Rencana',
	'mobile-frontend-watchlist-filter-talk' => 'Perbualan',
	'mobile-frontend-watchlist-filter-other' => 'Lain-lain',
	'mobile-frontend-watchlist-modified' => 'Diubah $1',
	'mobile-frontend-diffview-404-title' => 'Semakan tak elok',
	'mobile-frontend-diffview-404-desc' => 'ID untuk semakan yang anda pohon tidak wujud.',
	'mobile-frontend-diffview-title' => 'Perubahan',
	'mobile-frontend-diffview-editcount' => '$1 suntingan',
	'mobile-frontend-diffview-anonymous' => 'Pengguna awanama',
	'mobile-frontend-diffview-bytesadded' => '$1 bait ditambah',
	'mobile-frontend-diffview-bytesremoved' => '$1 bait dibuang',
	'mobile-frontend-diffview-explained' => 'Baris-baris yang berikut ditambahkan (+) dan digugurkan (-):',
	'mobile-frontend-table' => 'Jadual $1',
	'mobile-frontend-saving-exit-page' => 'Sumbangan anda masih sedang disimpan. Jika anda pergi, sumbangan anda akan hilang. Adakah anda benar-benar ingin keluar?',
	'mobile-frontend-photo-upload' => 'Letakkan gambar pada rencana ini',
	'mobile-frontend-photo-article-edit-comment' => 'Meletakkan foto untuk digunakan pada halaman',
	'mobile-frontend-photo-article-donate-comment' => 'Menyumbangkan gambar dari peranti mudah alih',
	'mobile-frontend-photo-upload-comment' => 'Meletakkan foto pada halaman',
	'mobile-frontend-photo-caption-placeholder' => 'Isikan keterangan (wajib)',
	'mobile-frontend-image-loading' => 'Imej sedang dimuatkan',
	'mobile-frontend-image-uploading-wait' => 'Sila tunggu, gambar sedang dimuat naik.',
	'mobile-frontend-image-uploading-long' => 'Imej masih sedang dimuat naik. Terima kasih atas kesabaran anda.',
	'mobile-frontend-image-uploading-cancel' => '<a href="#">Batalkan</a> jika terlalu lama.',
	'mobile-frontend-photo-upload-error' => 'Ralat, cuba lagi.',
	'mobile-frontend-photo-upload-success-article' => 'Berjaya! Gambar anda kini disiarkan pada halaman ini.',
	'mobile-frontend-photo-license' => 'Dengan mengklik "Hantar", anda bersetuju dengan [//wikimediafoundation.org/wiki/Terms_of_use Syarat-Syarat Penggunaan] kami dan sudi menyiarkan foto anda dengan [//en.wikipedia.org/wiki/Wikipedia:Text_of_Creative_Commons_Attribution-ShareAlike_3.0_Unported_License Lesen Creative Commons Attribution-ShareAlike 3.0].', # Fuzzy
	'mobile-frontend-photo-submit' => 'Hantar',
	'mobile-frontend-photo-cancel' => 'Batalkan',
	'mobile-frontend-photo-upload-user-count' => '$1 muatan naik',
	'mobile-frontend-photo-upload-user-count-over-limit' => '500+ muatan naik',
	'tag-mobile_edit' => 'Suntingan mobil',
	'tag-mobile_edit-description' => 'Suntingan dari tapak mobil',
	'mobile-frontend-drawer-cancel' => 'Batalkan',
);

/** Maltese (Malti)
 * @author Chrisportelli
 */
$messages['mt'] = array(
	'mobile-frontend-desc' => 'Interfaċċa għall-mowbajl',
	'mobile-frontend-search-submit' => 'Mur',
	'mobile-frontend-home-button' => 'Daħla',
	'mobile-frontend-logged-out' => "M'intix illoggjat",
	'mobile-frontend-logged-in-homepage-notification' => 'Merħba, $1!',
	'mobile-frontend-logged-in-toast-notification' => 'Illogjat bħala $1.',
	'mobile-frontend-sign-up-heading' => 'Irreġistra',
	'mobile-frontend-sign-in-heading' => 'Idħol',
	'mobile-frontend-sign-in-why' => "Jekk għandek kont ta' {{SITENAME}}, tista' tidħol billi timla l-formola t'hawn taħt.",
	'mobile-frontend-sign-in-error-heading' => 'Oops!',
	'mobile-frontend-settings-description' => "Ippersonalizza l-esperjenza tiegħek fuq il-mowbajl b'dawn il-konfigurazzjonijiet speċifiċi għal din il-verżjoni.",
	'mobile-frontend-settings-beta' => 'Beta',
	'mobile-frontend-save-settings' => 'Salva l-konfigurazzjoni',
	'mobile-frontend-random-button' => 'Paġna kwalunkwe',
	'mobile-frontend-ajax-random-question' => "Trid taqra' din il-paġna?",
	'mobile-frontend-ajax-random-yes' => 'Iva',
	'mobile-frontend-ajax-random-retry' => "Erġa' pprova",
	'mobile-frontend-ajax-random-suggestions' => 'Suġġerimenti oħra:',
	'mobile-frontend-back-to-top-of-section' => 'Aqbeż sezzjoni lura',
	'mobile-frontend-close-section' => 'Agħlaq din is-sezzjoni',
	'mobile-frontend-show-button' => 'Uri',
	'mobile-frontend-hide-button' => 'Aħbi',
	'mobile-frontend-empty-homepage-text' => 'Din il-paġna prinċipali għandha bżonn tiġi konfigurata. <a href="http://meta.wikimedia.org/wiki/Mobile_Projects/Mobile_Gateway#Mobile_homepage">Struzzjonijiet fuq kif tippermetti dan is-sit għall-mowbajl</a>', # Fuzzy
	'mobile-frontend-regular-site' => 'Verżjoni għad-desktop',
	'mobile-frontend-wml-continue' => 'Kompli...',
	'mobile-frontend-wml-back' => 'Lura...',
	'mobile-frontend-view' => 'Verżjoni għall-mowbajl',
	'mobile-frontend-view-desktop' => 'Desktop',
	'mobile-frontend-view-mobile' => 'Mowbajl',
	'mobile-frontend-opt-in-explain' => "Billi tipparteċipa fil-verżjoni beta, se jkollok aċċess il-funzjonalità sperimentali, bir-riskju li tiltaqa' ma' żbalji u problemi.",
	'mobile-frontend-images-status' => 'Stampi',
	'mobile-frontend-disable-images' => 'Iddiżattiva l-istampi fuq is-sit għall-mowbajl',
	'mobile-frontend-enable-images' => 'Attiva l-istampi fuq is-sit għall-mowbajl',
	'mobile-frontend-missing-image' => 'Stampa',
	'mobile-frontend-off' => 'OFF',
	'mobile-frontend-on' => 'ON',
	'mobile-frontend-footer-contributors-text' => 'Paġna minn <a href="$1">kontributuri</a> bħalek', # Fuzzy
	'mobile-frontend-featured-article' => 'Vetrina',
	'mobile-frontend-news-items' => 'Fl-aħbarijiet',
	'mobile-frontend-leave-feedback-notice' => 'Il-kummenti tiegħek jgħinuna ntejbu l-esperjenza għas-sit għall-mowbajl. Dan se jiġi ppubblikat (flimkien mal-isem tal-utent, il-verżjoni tal-browżer u s-sistema operattiva) fuq il-paġna "$1". Jekk jogħġbok prova għażel suġġett informattiv (per eżempju, "Problemi fl-ifformattjar b\'tabelli wiesgħa"). Ir-rispons tiegħek huwa suġġett għat-terminu ta\' użu.',
	'mobile-frontend-leave-feedback-warning' => 'Jekk ma taqbilx li tħalli l-informazzjoni tiegħek pubblika, jekk jogħġbok iddaħħalx informazzjoni personali fil-kummenti tiegħek.',
	'mobile-frontend-leave-feedback-subject' => 'Suġġett:',
	'mobile-frontend-leave-feedback-message' => 'Messaġġ:',
	'mobile-frontend-leave-feedback-submit' => 'Ibgħat kumment',
	'mobile-frontend-leave-feedback-link-text' => 'Kummenti fuq l-estensjoni interfaċċa għall-mowbajl',
	'mobile-frontend-leave-feedback' => 'Rispons għas-sit għall-mowbajl',
	'mobile-frontend-leave-feedback-title' => 'Rispons għas-sit għall-mowbajl',
	'mobile-frontend-leave-feedback-technical-problem-section-header' => 'Problema teknika',
	'mobile-frontend-leave-feedback-general-section-header' => 'Ġenerali',
	'mobile-frontend-leave-feedback-article-feedback-section-header' => 'Ikkummenta fuq l-artiklu',
	'mobile-frontend-leave-feedback-email-body' => 'Jekk jogħġbok iddeskrivi l-problema li qieħħed taffaċċja fuq {{SITENAME}} fuq din il-linja. Kun af li aħna ma nistgħux nirrispondu għal kull messaġġ illi nirċievu.',
	'mobile-frontend-leave-feedback-technical-link-text' => 'Problem teknika',
	'mobile-frontend-leave-feedback-general-link-text' => 'Rispons ġenerali',
	'mobile-frontend-leave-feedback-article-personal-link-text' => 'Dwari, persuna, jew kumpanija li nirrappreżenta',
	'mobile-frontend-leave-feedback-article-factual-link-text' => 'Dwar żball fattwali',
	'mobile-frontend-leave-feedback-article-other-link-text' => 'Dwar problema oħra',
	'mobile-frontend-leave-feedback-form-subject-placeholder' => 'Suġġett tal-messaġġ',
	'mobile-frontend-leave-feedback-form-message-placeholder' => 'Ikteb il-kumment tiegħek hawnhekk',
	'mobile-frontend-leave-feedback-page-title' => 'Rispons għas-sit għall-mowbajl',
	'mobile-frontend-leave-feedback-special-title' => 'Ikkuntatjana',
	'mobile-frontend-feedback-no-subject' => '(l-ebda suġġett)',
	'mobile-frontend-feedback-no-subject-field' => 'Jekk jogħġbok daħħal suġġett',
	'mobile-frontend-feedback-no-message' => 'Jekk jogħġbok daħħal messaġġ',
	'mobile-frontend-feedback-edit-summary' => '$1 - mibgħut awtomatikament bl-użu tal-[[Special:MobileFeedback|għodda għar-rispons għall-mowbajl]]',
	'mobile-frontend-leave-feedback-thanks' => 'Grazzi tal-kumment tiegħek!',
	'mobile-frontend-leave-feedback-post-error' => "Kien hemm żball fl-ipproċessar tal-messaġġ tiegħek. Jekk jogħġbok erġa' pprova.",
	'mobile-frontend-language' => 'Lingwa:',
	'mobile-frontend-language-article-heading' => "Aqra f'lingwa oħra",
	'mobile-frontend-language-header' => "Din il-paġna hija disponibbli f'{{PLURAL:$1|lingwa waħda|$1 lingwi}}",
	'mobile-frontend-language-footer' => "Nota: Din il-paġna tista' ma tkunx miktuba bil-lingwa preferuta tiegħek. Tista' tara b'liema lingwi {{SITENAME}} hija disponibbli billi tagħfas hawnhekk.",
	'mobile-frontend-language-site-choose' => 'Fittex lingwa',
	'mobile-frontend-username' => 'Isem tal-utent:',
	'mobile-frontend-password' => 'Password:',
	'mobile-frontend-username-placeholder' => 'Isem tal-utent',
	'mobile-frontend-password-placeholder' => 'Password',
	'mobile-frontend-login' => 'Idħol',
	'mobile-frontend-account-create-submit' => 'Irreġistra',
	'mobile-frontend-password-confirm-placeholder' => 'Ikkonferma l-password',
	'mobile-frontend-account-create-email-placeholder' => 'Indirizz elettroniku (opzjonali)',
	'mobile-frontend-overlay-escape' => 'Mur lura',
	'mobile-frontend-placeholder' => 'Fittex fil-{{SITENAME}}',
	'mobile-frontend-placeholder-beta' => 'Fittex fuq {{SITENAME}} (Beta)',
	'mobile-frontend-search-help' => 'Daħħal il-kliem li trid tfittex hawn fuq u t-titli tal-paġni li jikkorrispondu jidhru hawnhekk.',
	'mobile-frontend-dismiss-notification' => 'neħħi din in-notifika',
	'mobile-frontend-clear-search' => 'Ħassar',
	'mobile-frontend-privacy-link-text' => 'Privatezza',
	'mobile-frontend-about-link-text' => 'Dwar',
	'mobile-frontend-footer-sitename' => '{{SITENAME}}',
	'mobile-frontend-footer-contact' => 'Kuntatt',
	'mobile-frontend-search-noresults' => 'L-ebda titlu ta\' paġna ma kkorrisponda mat-tfittxija tiegħek. Biddel it-tfittxija tiegħek, jew agħfas il-buttuna tat-tastiera "Fittex" sabiex tfittex fi ħdan it-test tal-paġni.',
	'mobile-frontend-main-menu-button-tooltip' => 'Iftaħ il-menu prinċipali',
	'mobile-frontend-main-menu-page-title' => 'Navigazzjoni tas-sit',
	'mobile-frontend-main-menu-featured' => 'Fil-vetrina',
	'mobile-frontend-main-menu-nearby' => 'Fil-qrib',
	'mobile-frontend-main-menu-login' => 'Idħol',
	'mobile-frontend-main-menu-logout' => 'Oħroġ',
	'mobile-frontend-main-menu-watchlist' => "Lista ta' osservazzjonijiet",
	'mobile-frontend-main-menu-settings' => 'Konfigurazzjoni',
	'mobile-frontend-main-menu-settings-heading' => 'Konfigurazzjoni għas-sit għall-mowbajl',
	'mobile-frontend-settings-site-header' => 'Lingwi {{SITENAME}}',
	'mobile-frontend-settings-site-description' => "{{SITENAME}} hija disponibbli f'$1 {{PLURAL:$1|lingwa|lingwi}}. Il-verżjonijiet disponibbli kollha huma mniżżla hawn taħt",
	'mobile-frontend-main-menu-contact' => 'Kuntatt',
	'mobile-frontend-main-menu-account-create' => 'Oħloq kont',
	'mobile-frontend-page-menu-contents' => 'werrej',
	'mobile-frontend-page-menu-history' => 'Kronoloġija',
	'mobile-frontend-meta-data-issues-header' => 'Anomaliji',
	'mobile-frontend-meta-data-issues' => 'Din il-paġna għandha xi problemi',
	'mobile-frontend-ajax-page-loading' => "Tiela' $1",
	'mobile-frontend-page-saving' => 'Qiegħed jiġi salvat $1',
	'mobile-frontend-ajax-page-error' => "Oops! Xi ħaġa marret ħażin. Jekk jogħġbok erġa' ffriska l-browżer.",
	'mobile-frontend-photo-upload-generic' => 'Agħti stampa',
	'mobile-frontend-donate-image-title' => 'Agħti stampa',
	'mobile-frontend-donate-image-heading' => 'Kontributi riċenti tiegħek',
	'mobile-frontend-watchlist-add' => "$1 ġie miżjud fil-lista ta' osservazzjonijiet tiegħek",
	'mobile-frontend-watchlist-removed' => "$1 tneħħa mil-lista ta' osservazzjonijiet tiegħek",
	'mobile-frontend-watchlist-view' => "Ara l-lista ta' osservazzjonijiet tiegħek",
	'mobile-frontend-watchlist-a-z' => 'Paġni osservati', # Fuzzy
	'mobile-frontend-watchlist-feed' => 'Paġni mingħajr tibdil', # Fuzzy
	'mobile-frontend-changeslist-ip' => 'Utent anonimu',
	'mobile-frontend-changeslist-nocomment' => 'l-ebda taqsira',
	'mobile-frontend-watchlist-filter-all' => 'Kollha',
	'mobile-frontend-watchlist-filter-articles' => 'Artikli',
	'mobile-frontend-watchlist-filter-talk' => 'Diskussjoni',
	'mobile-frontend-watchlist-filter-other' => 'Oħrajn',
	'mobile-frontend-diffview-title' => "Bidla f'$1", # Fuzzy
	'mobile-frontend-diffview-editcount' => '{{PLURAL:$1|modifika waħda|$1 modifiki}}',
	'mobile-frontend-diffview-anonymous' => 'Utent anonimu',
	'mobile-frontend-diffview-bytesadded' => '{{PLURAL:$1|byte|$1 bytes}} miżjuda',
	'mobile-frontend-diffview-bytesremoved' => '{{PLURAL:$1|byte|$1 bytes}} imneħħija',
	'mobile-frontend-table' => 'Tabella $1',
	'mobile-frontend-saving-exit-page' => 'Il-kontribuzzjoni tiegħek għadha qed tiġi salvata. Jekk se titlaq, il-kontribuzzjonijiet tiegħek jintilfu. Inti ċert li tixtieq titlaq?',
	'mobile-frontend-photo-upload' => "Żid l-ewwel ritratt f'din il-paġna",
	'mobile-frontend-photo-article-edit-comment' => 'Miżjud ritratt għall-użu fuq din il-paġna',
	'mobile-frontend-photo-upload-comment' => 'Miżjud ritratt mal-paġna',
	'mobile-frontend-photo-upload-progress' => "L-istampa qegħdha titella' lil din il-paġna",
	'mobile-frontend-photo-caption-placeholder' => 'Żid deskrizzjoni għal din l-istampa',
	'mobile-frontend-image-loading' => "L-istampa tiela'",
);

/** Burmese (မြန်မာဘာသာ)
 */
$messages['my'] = array(
	'mobile-frontend-search-submit' => 'သွား',
	'mobile-frontend-home-button' => 'ပင်မ',
	'mobile-frontend-random-button' => 'ကျပန်း',
	'mobile-frontend-back-to-top-of-section' => 'အပိုင်းတစ်ခု ခုန်ကျော်ရန်',
	'mobile-frontend-show-button' => 'ပြ',
	'mobile-frontend-hide-button' => 'ဝှက်',
	'mobile-frontend-regular-site' => 'ဤစာမျက်နှာကို ပုံမှန် ဝီကီပီးဒီးယား စာမျက်နှာတွင် ကြည့်ရန်', # Fuzzy
	'mobile-frontend-featured-article' => 'ယနေ့အထူးဆောင်းပါး',
);

/** Mazanderani (مازِرونی)
 * @author محک
 */
$messages['mzn'] = array(
	'mobile-frontend-view' => 'موبایلی هارشائن',
);

/** Norwegian Bokmål (norsk (bokmål)‎)
 * @author Danmichaelo
 * @author Event
 * @author Jsoby
 * @author Lokal Profil
 * @author Nghtwlkr
 */
$messages['nb'] = array(
	'mobile-frontend-desc' => 'Mobilgrensesnitt',
	'mobile-frontend-search-submit' => 'Gå',
	'mobile-frontend-home-button' => 'Hjem',
	'mobile-frontend-logged-out' => 'Ikke innlogget',
	'mobile-frontend-settings-beta' => 'Beta',
	'mobile-frontend-save-settings' => 'Lagre innstillinger',
	'mobile-frontend-random-button' => 'Tilfeldig',
	'mobile-frontend-back-to-top-of-section' => 'Gå ett avsnitt tilbake',
	'mobile-frontend-close-section' => 'Lukk dette avsnittet',
	'mobile-frontend-show-button' => 'Vis',
	'mobile-frontend-hide-button' => 'Skjul',
	'mobile-frontend-empty-homepage-text' => 'Denne hjemmesiden må konfigureres. <a href="http://meta.wikimedia.org/wiki/Mobile_Projects/Mobile_Gateway#Mobile_homepage">Instruksjoner for hvordan man aktiverer denne mobilsiden</a>', # Fuzzy
	'mobile-frontend-regular-site' => 'Bordmaskinvisning',
	'mobile-frontend-wml-continue' => 'Fortsett ...',
	'mobile-frontend-wml-back' => 'Tilbake...',
	'mobile-frontend-view' => 'Mobilvisning',
	'mobile-frontend-view-desktop' => 'Bordmaskin',
	'mobile-frontend-view-mobile' => 'Mobil',
	'mobile-frontend-opt-in-explain' => 'Ved å bli med på betatestingen vil du få tilgang til eksperimentelle funksjoner, som kan inneholde feil og problemer.',
	'mobile-frontend-images-status' => 'Bilder',
	'mobile-frontend-disable-images' => 'Deaktiver bilder på mobilsiden',
	'mobile-frontend-enable-images' => 'Gjør tilgjengelig bilder på mobilnettstedet',
	'mobile-frontend-missing-image' => 'Bilde',
	'mobile-frontend-off' => 'AV',
	'mobile-frontend-on' => 'PÅ',
	'mobile-frontend-footer-contributors-text' => 'Artikkel av <a href="$1">bidragsytere</a> som deg', # Fuzzy
	'mobile-frontend-featured-article' => 'Dagens utvalgte artikkel',
	'mobile-frontend-news-items' => 'I nyhetene',
	'mobile-frontend-leave-feedback-notice' => 'Din tilbakemelding hjelper oss å forbedre brukeropplevelsen på ditt mobilnettsted. Den vil bli publisert offentlig, sammen med ditt brukernavn, nettleserversjon og operativsystem, på siden &quot;$1&quot;. Vennligst lag en informativ emnetekst, f. eks. "Formateringsdetaljer for brede tabeller". For din tilbakemelding gjelder våre bruksvilkår.',
	'mobile-frontend-leave-feedback-subject' => 'Emne:',
	'mobile-frontend-leave-feedback-message' => 'Melding:',
	'mobile-frontend-leave-feedback-submit' => 'Send tilbakemelding',
	'mobile-frontend-leave-feedback-link-text' => 'Tilbakemelding på utvidelsen MobileFrontend',
	'mobile-frontend-leave-feedback' => 'Tilbakemelding på mobilnettsted',
	'mobile-frontend-leave-feedback-title' => 'Gi oss tilbakemelding om din erfaring med mobilnettstedet',
	'mobile-frontend-leave-feedback-technical-problem-section-header' => 'Teknisk problem',
	'mobile-frontend-leave-feedback-general-section-header' => 'Generelt',
	'mobile-frontend-leave-feedback-technical-link-text' => 'Teknisk problem',
	'mobile-frontend-leave-feedback-page-title' => 'Gi oss tilbakemelding om din erfaring med mobilnettstedet',
	'mobile-frontend-leave-feedback-special-title' => 'Kontakt oss',
	'mobile-frontend-feedback-no-subject' => '(mangler emnetekst)',
	'mobile-frontend-feedback-no-subject-field' => 'Skriv inn ett emne',
	'mobile-frontend-feedback-no-message' => 'Vennligst legg inn en melding her',
	'mobile-frontend-feedback-edit-summary' => '$1 - automatisk sendt ved hjelp av [[Special:MobileFeedback|tilbakemeldingsverktøy for mobiler]]',
	'mobile-frontend-leave-feedback-thanks' => 'Takk for din tilbakemelding!',
	'mobile-frontend-leave-feedback-post-error' => 'Det oppsto en feil under behandlingen av meldingen din. Vennligst prøv igjen senere.',
	'mobile-frontend-language' => 'Språk:',
	'mobile-frontend-language-header' => 'Artikkelen er tilgjengelig på {{PLURAL:$1|ett språk|$1 språk}}', # Fuzzy
	'mobile-frontend-language-footer' => '{{SITENAME}} finnes tilgjengelig på andre språk.', # Fuzzy
	'mobile-frontend-language-site-choose' => 'Søk etter språk',
	'mobile-frontend-username' => 'Brukernavn:',
	'mobile-frontend-password' => 'Passord:',
	'mobile-frontend-login' => 'Logg inn',
	'mobile-frontend-placeholder' => 'Søk i {{SITENAME}}',
	'mobile-frontend-search-help' => 'Skriv inn søkeord ovenfor og treffende artikkelnavn vises her.', # Fuzzy
	'mobile-frontend-dismiss-notification' => 'se bort i fra denne beskjeden',
	'mobile-frontend-clear-search' => 'Tilbakestill',
	'mobile-frontend-privacy-link-text' => 'Privat',
	'mobile-frontend-about-link-text' => 'Om',
	'mobile-frontend-footer-sitename' => '{{SITENAME}}',
	'mobile-frontend-footer-contact' => 'Kontakt',
	'mobile-frontend-main-menu-nearby' => 'I nærheten',
	'mobile-frontend-main-menu-settings' => 'Innstillinger',
	'mobile-frontend-main-menu-settings-heading' => 'Innstillinger for mobilside',
	'mobile-frontend-settings-site-header' => '{{SITENAME}} språk',
	'mobile-frontend-settings-site-description' => '{{SITENAME}} er tilgjengelig på $1 {{PLURAL:$1|språk|språk}}. Alle tilgjengelige utgaver er listet opp nedenfor',
	'mobile-frontend-main-menu-contact' => 'Kontakt',
	'mobile-frontend-page-menu-contents' => 'innhold',
	'mobile-frontend-page-menu-history' => 'Historikk',
);

/** Nedersaksies (Nedersaksies)
 * @author Servien
 */
$messages['nds-nl'] = array(
	'mobile-frontend-desc' => 'Mobiele weergave',
	'mobile-frontend-search-submit' => 'Artikel',
	'mobile-frontend-home-button' => 'Veurblad',
	'mobile-frontend-random-button' => 'Zo mer wat',
	'mobile-frontend-back-to-top-of-section' => 'Gao naor t veurige kopjen',
	'mobile-frontend-show-button' => 'Bekieken',
	'mobile-frontend-hide-button' => 'Verbargen',
	'mobile-frontend-regular-site' => 'Standardweergave',
	'mobile-frontend-wml-back' => 'Weerumme ...',
	'mobile-frontend-view' => 'Mobiele weergave',
	'mobile-frontend-disable-images' => 'Aofbeeldingen in de mobiele weergave uutzetten',
	'mobile-frontend-enable-images' => 'Aofbeeldingen in de mobiele weergave anzetten',
	'mobile-frontend-featured-article' => 'Uutekeuzen artikel',
	'mobile-frontend-news-items' => 'In t niejs',
	'mobile-frontend-leave-feedback-subject' => 'Onderwarp:',
	'mobile-frontend-leave-feedback-message' => 'Bericht:',
	'mobile-frontend-leave-feedback-submit' => 'Troegkoppeling opslaon',
	'mobile-frontend-leave-feedback-link-text' => 'Troegkoppeling over de mobiele weergave',
	'mobile-frontend-leave-feedback' => 'Troegkoppeling achterlaoten',
	'mobile-frontend-leave-feedback-thanks' => 'Bedankt veur joew troegkoppeling',
	'mobile-frontend-language' => 'Taal:',
	'mobile-frontend-username' => 'Gebrukersnaam:',
	'mobile-frontend-password' => 'Wachtwoord:',
	'mobile-frontend-login' => 'Anmelden',
	'mobile-frontend-placeholder' => '{{SITENAME}} duurzeukn',
);

/** Nepali (नेपाली)
 * @author RajeshPandey
 */
$messages['ne'] = array(
	'mobile-frontend-search-submit' => 'जाउ',
	'mobile-frontend-home-button' => 'गृह',
	'mobile-frontend-random-button' => 'कुनै पनि एक',
	'mobile-frontend-back-to-top-of-section' => 'एक खण्ड पछाडि जाने',
	'mobile-frontend-show-button' => 'देखाउने',
	'mobile-frontend-hide-button' => 'लुकाउने',
	'mobile-frontend-regular-site' => 'यो पृष्ठलाई नियमित {{SITENAME}}मा हेर्ने', # Fuzzy
	'mobile-frontend-featured-article' => 'आजको जोडदिएको लेख',
	'mobile-frontend-username' => 'प्रयोगकर्ता नाम:',
);

/** Dutch (Nederlands)
 * @author Akoopal
 * @author AvatarTeam
 * @author Patio
 * @author Rvlieshout
 * @author SPQRobin
 * @author Saruman
 * @author Siebrand
 * @author Wiki13
 */
$messages['nl'] = array(
	'mobile-frontend-desc' => 'Mobiele website',
	'mobile-frontend-search-submit' => 'Zoeken',
	'mobile-frontend-home-button' => 'Startpagina',
	'mobile-frontend-logged-out' => 'Niet aangemeld',
	'mobile-frontend-logged-in-homepage-notification' => 'Welkom, $1!',
	'mobile-frontend-logged-in-toast-notification' => 'Aangemeld als $1.',
	'mobile-frontend-sign-up-heading' => 'Registreren',
	'mobile-frontend-sign-in-heading' => 'Aanmelden',
	'mobile-frontend-sign-in-why' => 'Als u een gebruiker hebt op {{SITENAME}}, dan kunt u hieronder aanmelden.',
	'mobile-frontend-sign-in-error-heading' => 'Fout',
	'mobile-frontend-settings-description' => 'Pas uw gebruikerservaring op uw mobiele apparaat aan via deze instellingen.',
	'mobile-frontend-settings-beta' => 'Beta',
	'mobile-frontend-settings-alpha' => 'Experimentele functies',
	'mobile-frontend-settings-alpha-description' => 'Betreed gevaarlijk en onontgonnen mobiel gebied. Verken nog meer experimentele functies met de kan op bugs.',
	'mobile-frontend-save-settings' => 'Instellingen opslaan',
	'mobile-frontend-random-button' => 'Willekeurig',
	'mobile-frontend-ajax-random-heading' => 'Bezig met het laden van de pagina...',
	'mobile-frontend-ajax-random-quote' => 'Intellectuele groei moet beginnen bij de geboorte en pas eindigen bij de dood',
	'mobile-frontend-ajax-random-question' => 'Deze pagina lezen?',
	'mobile-frontend-ajax-random-yes' => 'Ja',
	'mobile-frontend-ajax-random-retry' => 'Opnieuw proberen',
	'mobile-frontend-ajax-random-suggestions' => 'Andere suggesties:',
	'mobile-frontend-back-to-top-of-section' => 'Een kopje terugspringen',
	'mobile-frontend-close-section' => 'Deze paragraaf sluiten',
	'mobile-frontend-show-button' => 'Weergeven',
	'mobile-frontend-hide-button' => 'Verbergen',
	'mobile-frontend-empty-homepage-text' => 'Deze startpagina moet worden samengesteld. [//meta.wikimedia.org/wiki/Mobile_Projects/Mobile_Gateway#Mobile_homepage Instructies over hoe deze mobiele site in te schakelen].',
	'mobile-frontend-regular-site' => 'Standaardweergave',
	'mobile-frontend-wml-continue' => 'Doorgaan ...',
	'mobile-frontend-wml-back' => 'Terug ...',
	'mobile-frontend-view' => 'Mobiele weergave',
	'mobile-frontend-view-desktop' => 'Desktopweergave',
	'mobile-frontend-view-mobile' => 'Mobiele weergave',
	'mobile-frontend-opt-in-explain' => 'Als u meedoet met testen, krijgt u toegang tot experimentele functionaliteit, met het risico op fouten en problemen.',
	'mobile-frontend-images-status' => 'Afbeeldingen',
	'mobile-frontend-disable-images' => 'Afbeeldingen op de mobiele site uitschakelen',
	'mobile-frontend-enable-images' => 'Afbeeldingen op de mobiele site inschakelen',
	'mobile-frontend-missing-image' => 'Afbeelding',
	'mobile-frontend-off' => 'UIT',
	'mobile-frontend-on' => 'AAN',
	'mobile-frontend-footer-contributors-text' => 'Pagina door [$1 gebruikers] zoals u',
	'mobile-frontend-featured-article' => 'Uitgelicht',
	'mobile-frontend-news-items' => 'In het nieuws',
	'mobile-frontend-leave-feedback-notice' => 'Uw terugkoppeling helpt ons uw ervaring op de mobiele site te verbeteren. Deze terugkoppeling is openbaar (als ook uw gebruikersnaam, browserversie en besturingssysteem) op de pagina &quot;$1&quot;. Kies alstublieft een informatieve onderwerpregel, bijvoorbeeld "Opmaakproblemen met brede tabellen". Op uw terugkoppeling zijn onze gebruiksvoorwaarden van toepassing.',
	'mobile-frontend-leave-feedback-warning' => 'Neem geen persoonlijke gegevens op in uw opmerkingen, tenzij u akkoord gaat met het openbaar maken ervan.',
	'mobile-frontend-leave-feedback-subject' => 'Onderwerp:',
	'mobile-frontend-leave-feedback-message' => 'Bericht:',
	'mobile-frontend-leave-feedback-submit' => 'Terugkoppeling opslaan',
	'mobile-frontend-leave-feedback-link-text' => 'Mobiele Frontend-terugkoppeling',
	'mobile-frontend-leave-feedback' => 'Terugkoppeling over de mobiele site',
	'mobile-frontend-leave-feedback-title' => 'Terugkoppeling over de mobiele site',
	'mobile-frontend-leave-feedback-technical-problem-section-header' => 'Technisch probleem',
	'mobile-frontend-leave-feedback-general-section-header' => 'Algemeen',
	'mobile-frontend-leave-feedback-article-feedback-section-header' => 'Paginabeoordeling',
	'mobile-frontend-leave-feedback-email-body' => 'Beschrijf boven deze regel het probleem dat u ervaart met {{SITENAME}}. Dank u wel voor uw terugkoppeling. Helaas kunnen we niet alle reacties beantwoorden.',
	'mobile-frontend-leave-feedback-technical-link-text' => 'Technisch probleem',
	'mobile-frontend-leave-feedback-general-link-text' => 'Algemene terugkoppeling',
	'mobile-frontend-leave-feedback-article-personal-link-text' => 'Met betrekking tot mij, een persoon of een bedrijf dat ik vertegenwoordig',
	'mobile-frontend-leave-feedback-article-factual-link-text' => 'Met betrekking tot een inhoudelijke fout',
	'mobile-frontend-leave-feedback-article-other-link-text' => 'Met betrekking tot een ander probleem',
	'mobile-frontend-leave-feedback-form-subject-placeholder' => 'Onderwerp',
	'mobile-frontend-leave-feedback-form-message-placeholder' => 'Voer hier uw reactie in',
	'mobile-frontend-leave-feedback-page-title' => 'Terugkoppeling over de mobiele site',
	'mobile-frontend-leave-feedback-special-title' => 'Contact opnemen',
	'mobile-frontend-feedback-no-subject' => '(geen onderwerp)',
	'mobile-frontend-feedback-no-subject-field' => 'Geef een onderwerp op',
	'mobile-frontend-feedback-no-message' => 'Voer hier een bericht in',
	'mobile-frontend-feedback-edit-summary' => '$1 - automatisch geplaatst via het [[Special:MobileFeedback|hulpprogramma voor terugkoppeling via mobiel]]',
	'mobile-frontend-leave-feedback-thanks' => 'Bedankt voor uw terugkoppeling!',
	'mobile-frontend-leave-feedback-post-error' => 'Er is een fout opgetreden tijdens het verwerken van uw bericht.
Probeer het later nog een keer.',
	'mobile-frontend-language' => 'Taal:',
	'mobile-frontend-language-article-heading' => 'In een andere taal lezen',
	'mobile-frontend-language-header' => 'Deze pagina is beschikbaar in {{PLURAL:$1|één taal|$1 talen}}',
	'mobile-frontend-language-variant-header' => 'Kies de variant voor {{#language:{{CONTENTLANG}}}}',
	'mobile-frontend-language-footer' => 'Deze pagina is mogelijk niet beschikbaar in uw voorkeurstaal. U kunt hier klikken om alle taken die {{SITENAME}} ondersteunt te bekijken.',
	'mobile-frontend-language-site-choose' => 'Taal zoeken',
	'mobile-frontend-username' => 'Gebruikersnaam:',
	'mobile-frontend-password' => 'Wachtwoord:',
	'mobile-frontend-username-placeholder' => 'Gebruikersnaam',
	'mobile-frontend-password-placeholder' => 'Wachtwoord',
	'mobile-frontend-login' => 'Aanmelden',
	'mobile-frontend-last-modified-date' => 'Gewijzigd op $1 om $2',
	'mobile-frontend-last-modified-seconds' => '{{PLURAL:$1|Eén seconde|$1 seconden}} geleden gewijzigd',
	'mobile-frontend-last-modified-minutes' => '{{PLURAL:$1|Eén minuut|$1 minuten}} geleden gewijzigd',
	'mobile-frontend-last-modified-hours' => '{{PLURAL:$1|Eén|$1}} uur geleden gewijzigd',
	'mobile-frontend-last-modified-days' => '{{PLURAL:$1|Eén dag|$1 dagen}} geleden gewijzigd',
	'mobile-frontend-last-modified-months' => '{{PLURAL:$1|Eén maand|$1 maanden}} geleden gewijzigd',
	'mobile-frontend-last-modified-years' => '{{PLURAL:$1|Eén|$1}} jaar geleden gewijzigd',
	'mobile-frontend-account-create-submit' => 'Registreren',
	'mobile-frontend-password-confirm-placeholder' => 'Wachtwoord bevestigen',
	'mobile-frontend-account-create-email-placeholder' => 'E-mailadres (optioneel)',
	'mobile-frontend-account-create-captcha-placeholder' => 'Voer de veiligheidstekst in',
	'mobile-frontend-overlay-escape' => 'Terug',
	'mobile-frontend-placeholder' => '{{SITENAME}} doorzoeken',
	'mobile-frontend-placeholder-beta' => '{{SITENAME}} doorzoeken (Beta)',
	'mobile-frontend-placeholder-alpha' => '{{SITENAME}} doorzoeken (Drakenmodus)',
	'mobile-frontend-search-help' => 'Voer de trefwoorden hierboven in. Zoekresultaten worden hier weergegeven.',
	'mobile-frontend-dismiss-notification' => 'deze melding verwijderen',
	'mobile-frontend-clear-search' => 'Wissen',
	'mobile-frontend-privacy-link-text' => 'Privacy',
	'mobile-frontend-about-link-text' => 'Over',
	'mobile-frontend-footer-sitename' => '{{SITENAME}}',
	'mobile-frontend-footer-license-text' => 'De inhoud is beschikbaar onder de licentie [//en.m.wikipedia.org/wiki/Wikipedia:Text_of_Creative_Commons_Attribution-ShareAlike_3.0_Unported_License?useformat=mobile CC BY-SA 3.0]',
	'mobile-frontend-terms-use-text' => '[//wikimediafoundation.org/wiki/Terms_of_use/nl?useformat=mobile Gebruiksvoorwaarden]',
	'mobile-frontend-footer-contact' => 'Contact',
	'mobile-frontend-search-noresults' => "Er zijn geen resultaten voor uw zoekopdracht. Wijzig uw zoekopdracht of klik op de zoekknop op het toetsenbord om binnen pagina's te zoeken.",
	'mobile-frontend-main-menu-button-tooltip' => 'Hoofdmenu openen',
	'mobile-frontend-main-menu-page-title' => 'Sitenavigatie',
	'mobile-frontend-main-menu-featured' => 'Uitgelicht',
	'mobile-frontend-main-menu-nearby' => 'In de buurt',
	'mobile-frontend-main-menu-login' => 'Aanmelden',
	'mobile-frontend-main-menu-logout' => 'Afmelden',
	'mobile-frontend-main-menu-watchlist' => 'Volglijst',
	'mobile-frontend-main-menu-settings' => 'Instellingen',
	'mobile-frontend-main-menu-upload' => 'Uploads',
	'mobile-frontend-main-menu-settings-heading' => 'Voorkeuren mobiel',
	'mobile-frontend-settings-site-header' => 'Talen voor {{SITENAME}}',
	'mobile-frontend-settings-site-description' => '{{SITENAME}} is beschikbaar in {{PLURAL:$1|één taal|$1 talen}}. Alle beschikbare versies staan hieronder',
	'mobile-frontend-main-menu-contact' => 'Contact',
	'mobile-frontend-main-menu-account-create' => 'Registreren',
	'mobile-frontend-page-menu-contents' => 'inhoud',
	'mobile-frontend-page-menu-history' => 'Geschiedenis',
	'mobile-frontend-meta-data-issues-header' => 'Verbeterpunten',
	'mobile-frontend-meta-data-issues' => 'Er zijn verbeterpunten voor deze pagina',
	'mobile-frontend-ajax-page-loading' => 'Bezig met laden van $1',
	'mobile-frontend-page-saving' => 'Bezig met het opslaan van $1',
	'mobile-frontend-ajax-page-error' => 'Er is iets misgegaan. Vernieuw de huidige pagina in uw browser.',
	'mobile-frontend-nearby-title' => 'In de buurt',
	'mobile-frontend-nearby-loading' => 'Onderwerpen dichtbij u aan het laden',
	'mobile-frontend-nearby-requirements' => 'Voor deze pagina is JavaScript en een browser die locatiebewust is nodig.',
	'mobile-frontend-nearby-distance-report' => '$1 km van uw huidige locatie',
	'mobile-frontend-nearby-lookup-error' => 'U kun niet gevonden worden. Probeer het opnieuw.',
	'mobile-frontend-nearby-noresults' => 'U bent in het midden van nergens en we konden geen onderwerpen vinden. Waarom schrijft u er niet over?',
	'mobile-frontend-nearby-refresh' => "We hebben uw locatie preciezer kunnen bepalen. Klik hier om de lijst met nabijgelegen pagina's te vernieuwen",
	'mobile-frontend-nearby-error' => 'Er is een onverwachte fout opgetreden tijdens het zoeken naar nabijgelegen onderwerpen',
	'mobile-frontend-donate-image-login' => 'U moet aangemeld zijn om uw uploads te bekijken.',
	'mobile-frontend-photo-upload-generic' => 'Afbeelding uploaden',
	'mobile-frontend-donate-image-title' => 'Afbeelding uploaden',
	'mobile-frontend-donate-image-summary' => "Afbeeldingen brengen {{SITENAME}} tot leven.
Er zijn veel pagina's zonder afbeeldingen vanwege een groot tekort aan afbeeldingen met een vrije licentie.
Help de pagina's tot leven te brengen door afbeeldingen te uploaden die u wilt weggeven en die de {{SITENAME}}gemeenschap kan gebruiken.",
	'mobile-frontend-donate-image-heading' => 'Uw recente bijdragen',
	'mobile-frontend-donate-image-page-title' => 'Uploaden',
	'mobile-frontend-donate-image-anon' => 'U moet een [[Special:UserLogin|gebruiker]] hebben om de pagina voor uploaden te bekijken',
	'mobile-frontend-listed-image-no-description' => 'Geen beschrijving',
	'mobile-frontend-donate-photo-upload-success' => 'Uw afbeelding kan nu gebruikt worden op {{SITENAME}}.',
	'mobile-frontend-donate-photo-first-upload-success' => 'Bedankt voor uw eerste bijdrage!',
	'mobile-frontend-watchlist-add' => '$1 is toegevoegd aan uw volglijst',
	'mobile-frontend-watchlist-removed' => '$1 is verwijderd van uw volglijst',
	'mobile-frontend-watchlist-view' => 'Volglijst bekijken',
	'mobile-frontend-watchlist-more' => 'meer',
	'mobile-frontend-watchlist-cta' => 'Meld u aan of registreer u om deze pagina te volgen.',
	'mobile-frontend-watchlist-cta-button-login' => 'Aanmelden',
	'mobile-frontend-watchlist-cta-button-signup' => 'Registreren',
	'mobile-frontend-watch-login' => "U moet aangemeld zijn om pagina's te kunnen volgen.",
	'mobile-frontend-watchlist-a-z' => 'Alle',
	'mobile-frontend-watchlist-feed' => 'Gewijzigd',
	'mobile-frontend-watchlist-a-z-empty' => "U bekijkt momenteel niet alle pagina 's",
	'mobile-frontend-watchlist-a-z-empty-howto-alt' => 'Klik op de ster bovenaan de pagina',
	'mobile-frontend-watchlist-a-z-empty-howto' => "Volg een pagina die u interessant vindt door op de ster bovenaan het scherm te klikken. Zo kunt u bladwijzers voor pagina's die u interesseren toevoegen en ook in de gaten houden wanneer ze gewijzigd zijn.",
	'mobile-frontend-watchlist-feed-empty' => "Er zijn geen pagina's met recente wijzigingen",
	'mobile-frontend-watchlist-back-home' => 'Terug naar startpagina',
	'mobile-frontend-changeslist-ip' => 'Anonieme gebruiker',
	'mobile-frontend-changeslist-nocomment' => 'geen bewerkingssamenvatting',
	'mobile-frontend-watchlist-filter-all' => 'Alle',
	'mobile-frontend-watchlist-filter-articles' => "Pagina's",
	'mobile-frontend-watchlist-filter-talk' => 'Overleg',
	'mobile-frontend-watchlist-filter-other' => 'Overige',
	'mobile-frontend-watchlist-modified' => '$1 gewijzigd',
	'mobile-frontend-diffview-404-title' => 'Onjuiste versie',
	'mobile-frontend-diffview-404-desc' => 'Het ID voor de versie die u hebt opgevraagd bestaat niet',
	'mobile-frontend-diffview-title' => 'Wijzigingen',
	'mobile-frontend-diffview-editcount' => '$1 {{PLURAL:$1|bewerking|bewerkingen}}',
	'mobile-frontend-diffview-anonymous' => 'Anonieme gebruiker',
	'mobile-frontend-diffview-bytesadded' => '$1 {{PLURAL:$1|byte|bytes}} toegevoegd',
	'mobile-frontend-diffview-bytesremoved' => '$1 {{PLURAL:$1|byte|bytes}} verwijderd',
	'mobile-frontend-diffview-explained' => 'De volgende regels zijn toegevoegd (+) en verwijderd (-):',
	'mobile-frontend-table' => 'Tabel $1',
	'mobile-frontend-saving-exit-page' => 'Uw bijdrage wordt opgeslagen. Als u deze pagina verlaat, gaat uw bijdrage verloren. Weet u zeker dat u deze pagina wilt verlaten?',
	'mobile-frontend-photo-upload' => 'Voeg een afbeelding toe aan deze pagina',
	'mobile-frontend-photo-article-edit-comment' => 'De afbeelding voor gebruik op de pagina is toegevoegd',
	'mobile-frontend-photo-article-donate-comment' => 'Mobiele upload',
	'mobile-frontend-photo-upload-comment' => 'De afbeelding is toegevoegd aan de pagina',
	'mobile-frontend-photo-caption-placeholder' => 'Voeg een beschrijving toe (verplicht)',
	'mobile-frontend-image-loading' => 'Bezig met het laden van de afbeelding',
	'mobile-frontend-image-uploading-wait' => 'Bezig met het uploaden van de afbeelding.',
	'mobile-frontend-image-uploading-long' => 'De afbeelding wordt nog geüpload. Dank u wel voor uw geduld.',
	'mobile-frontend-image-uploading-cancel' => 'Klik op <a href="#">Annuleren</a> als dit te lang duurt.',
	'mobile-frontend-photo-upload-error' => 'Er is een fout opgetreden. Probeer het opnieuw.',
	'mobile-frontend-photo-upload-success-article' => 'Uw afbeelding is nu zichtbaar op deze pagina.',
	'mobile-frontend-photo-license' => 'Door op "Opslaan" te klikken, gaat u akkoord met onze [//wikimediafoundation.org/wiki/Terms_of_Use Gebruiksvoorwaarden] en gaat u akkoord met het vrijgeven van uw afbeelding onder de licentie [//creativecommons.org/licenses/by-sa/3.0/deed.nl Naamsvermelding-GelijkDelen 3.0].',
	'mobile-frontend-photo-submit' => 'Opslaan',
	'mobile-frontend-photo-cancel' => 'Annuleren',
	'mobile-frontend-photo-upload-user-count' => '{{PLURAL:$1|1 upload|$1 uploads}}', # Fuzzy
	'mobile-frontend-photo-upload-user-count-over-limit' => '500+ uploads',
	'tag-mobile_edit' => 'Bewerking via mobiel',
	'tag-mobile_edit-description' => 'Bewerking gemaakt via mobiele site',
	'mobile-frontend-drawer-cancel' => 'Annuleren',
);

/** Nederlands (informeel)‎ (Nederlands (informeel)‎)
 * @author Effeietsanders
 * @author Siebrand
 */
$messages['nl-informal'] = array(
	'mobile-frontend-sign-in-why' => 'Als je een gebruiker hebt op {{SITENAME}}, dan kan hieronder aanmelden.',
	'mobile-frontend-settings-description' => 'Pas je gebruikerservaring op je mobiele apparaat aan via deze instellingen.',
	'mobile-frontend-opt-in-explain' => 'Als je meedoet met testen, krijg je toegang tot experimentele functionaliteit, met het risico op fouten en problemen.',
	'mobile-frontend-footer-contributors-text' => 'Pagina door <a href="$1">gebruikers</a> zoals jij', # Fuzzy
	'mobile-frontend-leave-feedback-notice' => 'Jouw terugkoppeling helpt ons om je ervaring op de mobiele site te verbeteren. Deze terugkoppeling is openbaar (ook je gebruikersnaam, browserversie en besturingssysteem) op de pagina &quot;$1&quot;. Kies alsjeblieft een informatieve onderwerpregel, bijvoorbeeld "Opmaakproblemen met brede tabellen". Op je terugkoppeling zijn onze gebruiksvoorwaarden van toepassing.',
	'mobile-frontend-leave-feedback-warning' => 'Neem geen persoonlijke gegevens op in je opmerkingen, tenzij je akkoord gaat met het openbaar maken ervan.',
	'mobile-frontend-leave-feedback-title' => 'Terugkoppeling over de mobiele site',
	'mobile-frontend-leave-feedback-email-body' => 'Beschrijf boven deze regel het probleem dat je ervaart met {{SITENAME}}. Dank je wel voor je terugkoppeling. Helaas kunnen we niet alle reacties beantwoorden.',
	'mobile-frontend-leave-feedback-form-message-placeholder' => 'Voer hier je opmerking in',
	'mobile-frontend-leave-feedback-page-title' => 'Terugkoppeling over de mobiele site',
	'mobile-frontend-leave-feedback-thanks' => 'Bedankt voor je terugkoppeling!',
	'mobile-frontend-leave-feedback-post-error' => 'Er is een fout opgetreden tijdens het verwerken van je bericht.
Probeer het later nog een keer.',
	'mobile-frontend-language-footer' => 'Deze pagina is mogelijk niet beschikbaar in je voorkeurstaal. Je kunt hier klikken om alle taken die {{SITENAME}} ondersteunt te bekijken.',
	'mobile-frontend-search-noresults' => "Er zijn geen resultaten voor je zoekopdracht. Wijzig je zoekopdracht of klik op de zoekknop op het toetsenbord om binnen pagina's te zoeken.",
);

/** Norwegian Nynorsk (norsk (nynorsk)‎)
 * @author Njardarlogar
 * @author Ranveig
 */
$messages['nn'] = array(
	'mobile-frontend-desc' => 'Mobilgrensesnitt',
	'mobile-frontend-search-submit' => 'Gå',
	'mobile-frontend-home-button' => 'Heim',
	'mobile-frontend-logged-out' => 'Ikkje innlogga',
	'mobile-frontend-logged-in-homepage-notification' => 'Velkomen, $1!',
	'mobile-frontend-logged-in-toast-notification' => 'Innlogga som $1.',
	'mobile-frontend-sign-up-heading' => 'Registrer deg',
	'mobile-frontend-sign-in-heading' => 'Logg inn',
	'mobile-frontend-sign-in-why' => 'Har du ein {{SITENAME}}-konto kan du logga inn nedanfor.',
	'mobile-frontend-sign-in-error-heading' => 'Ops',
	'mobile-frontend-settings-description' => 'Tilpass opplevinga di på den mobile eininga di med desse mobilspesifikke nettstadinnstillingane.',
	'mobile-frontend-settings-beta' => 'Beta',
	'mobile-frontend-settings-alpha' => '[//en.wikipedia.org/wiki/Here_be_dragons Her finst drakar]-modus (eksperimentell modus)',
	'mobile-frontend-settings-alpha-description' => 'Stig inn i farleg og uutforska mobilterreng. Få endå meir eksperimentale funksjonar, men med større fare for programfeil.',
	'mobile-frontend-save-settings' => 'Lagra innstillingane',
	'mobile-frontend-random-button' => 'Tilfeldig',
	'mobile-frontend-ajax-random-question' => 'Les sida?',
	'mobile-frontend-ajax-random-yes' => 'Ja',
	'mobile-frontend-ajax-random-retry' => 'Freist om att',
	'mobile-frontend-ajax-random-suggestions' => 'Andre framlegg:',
	'mobile-frontend-back-to-top-of-section' => 'Gå éin bolk attende',
	'mobile-frontend-close-section' => 'Lat att bolken',
	'mobile-frontend-show-button' => 'Vis',
	'mobile-frontend-hide-button' => 'Gøym',
	'mobile-frontend-empty-homepage-text' => 'Denne heimesida lyt stillast inn. <a href="https://meta.wikimedia.org/wiki/Mobile_Projects/Mobile_Gateway#Mobile_homepage">Instruksjonar for korleis ein slår på mobilnettstaden</a>', # Fuzzy
	'mobile-frontend-regular-site' => 'Stasjonærvising',
	'mobile-frontend-wml-continue' => 'Haldt fram...',
	'mobile-frontend-wml-back' => 'Attende...',
	'mobile-frontend-view' => 'For mobil',
	'mobile-frontend-view-desktop' => 'Stasjonær',
	'mobile-frontend-view-mobile' => 'Mobil',
	'mobile-frontend-opt-in-explain' => 'Ved å verta med på betatestinga, vil du få tilgang til funksjonar under utrøyning; med den kostnaden at du kan møta på feil og vanskar.',
	'mobile-frontend-images-status' => 'Bilete',
	'mobile-frontend-disable-images' => 'Slå av bilete på mobilsida',
	'mobile-frontend-enable-images' => 'Slå på bilete på mobilsida',
	'mobile-frontend-missing-image' => 'Bilete',
	'mobile-frontend-off' => 'AV',
	'mobile-frontend-on' => 'PÅ',
	'mobile-frontend-footer-contributors-text' => 'Side av <a href="$1">bidragsytarar</a> som deg', # Fuzzy
	'mobile-frontend-featured-article' => 'Dagens artikkel',
	'mobile-frontend-news-items' => 'Nyhende',
	'mobile-frontend-leave-feedback-notice' => 'Attendemeldinga di hjelper oss med å betra brukaropplevinga di på mobilnettstaden. Ho vil publiserast (i lag med brukarnamnet ditt, nettlesarversjon og operativsystem) til sida &laquo;$1&raquo;. Gjer vel å velja ein informativ emnetekst, t.d. «Formateringsvanskar med breie tabellar». For attendemeldinga di gjeld bruksvilkåra våre.',
	'mobile-frontend-leave-feedback-warning' => 'Minder du samtykkjer i at informasjonen din vert offentleggjord, skal du ikkje inkludera personleg informasjon i kommentarane dine.',
	'mobile-frontend-leave-feedback-subject' => 'Emne:',
	'mobile-frontend-leave-feedback-message' => 'Melding:',
	'mobile-frontend-leave-feedback-submit' => 'Send attendemelding',
	'mobile-frontend-leave-feedback-technical-problem-section-header' => 'Teknisk vanske',
	'mobile-frontend-leave-feedback-general-section-header' => 'Ålment',
	'mobile-frontend-leave-feedback-article-feedback-section-header' => 'Attendemelding om artiklar',
	'mobile-frontend-leave-feedback-technical-link-text' => 'Teknisk vanske',
	'mobile-frontend-leave-feedback-general-link-text' => 'Ålmenn attendemelding',
	'mobile-frontend-leave-feedback-article-personal-link-text' => 'Om meg, ein person eller eit føretak eg representerer',
	'mobile-frontend-leave-feedback-article-factual-link-text' => 'Om faktafeil',
	'mobile-frontend-leave-feedback-article-other-link-text' => 'Om ein annan vanske',
	'mobile-frontend-leave-feedback-form-subject-placeholder' => 'Meldingsemne',
	'mobile-frontend-leave-feedback-form-message-placeholder' => 'Skriv kommentaren din her',
	'mobile-frontend-leave-feedback-special-title' => 'Kontakt oss',
	'mobile-frontend-feedback-no-subject' => '(utan emne)',
	'mobile-frontend-feedback-no-subject-field' => 'Skriv inn eit emne',
	'mobile-frontend-feedback-no-message' => 'Skriv inn ei melding her',
	'mobile-frontend-leave-feedback-thanks' => 'Takk for attendemeldinga di!',
	'mobile-frontend-language' => 'Språk:',
	'mobile-frontend-language-article-heading' => 'Les på eit anna språk',
	'mobile-frontend-language-header' => 'Artikkelen finst på {{PLURAL:$1|eitt anna språk|$1 andre språk}}', # Fuzzy
	'mobile-frontend-username' => 'Brukarnamn:',
	'mobile-frontend-password' => 'Passord:',
	'mobile-frontend-username-placeholder' => 'Brukarnamn',
	'mobile-frontend-password-placeholder' => 'Passord',
	'mobile-frontend-login' => 'Logg inn',
	'mobile-frontend-account-create-submit' => 'Registrer',
	'mobile-frontend-password-confirm-placeholder' => 'Stadfest passord',
	'mobile-frontend-account-create-email-placeholder' => 'E-postadresse (valfritt)',
	'mobile-frontend-account-create-captcha-placeholder' => 'Skriv inn tryggingstekst',
	'mobile-frontend-overlay-escape' => 'Gå attende',
	'mobile-frontend-placeholder' => 'Søk i {{SITENAME}}',
	'mobile-frontend-placeholder-beta' => 'Søk i {{SITENAME}} (Beta)',
	'mobile-frontend-placeholder-alpha' => 'Søk i {{SITENAME}} (Drakemodus)',
	'mobile-frontend-search-help' => 'Skriv inn eit søkjeord ovanfor, og artikkeltitlar som passar vert viste her.', # Fuzzy
	'mobile-frontend-dismiss-notification' => 'fjern meldinga',
	'mobile-frontend-clear-search' => 'Tøm',
	'mobile-frontend-privacy-link-text' => 'Personvern',
	'mobile-frontend-about-link-text' => 'Om',
	'mobile-frontend-footer-sitename' => '{{SITENAME}}',
	'mobile-frontend-footer-contact' => 'Kontakt',
	'mobile-frontend-search-noresults' => 'Ingen artikkeltitlar passar med søket ditt. Endra søket ditt eller trykk på søkjeknappen på tastaturet for å søkja i artikkeltekstane.', # Fuzzy
	'mobile-frontend-main-menu-button-tooltip' => 'Opna hovudmenyen',
	'mobile-frontend-main-menu-page-title' => 'Nettstadnavigering',
	'mobile-frontend-main-menu-featured' => 'Utvald',
	'mobile-frontend-main-menu-nearby' => 'Nær',
	'mobile-frontend-main-menu-login' => 'Logg inn',
	'mobile-frontend-main-menu-logout' => 'Logg ut',
	'mobile-frontend-main-menu-watchlist' => 'Overvakingsliste',
	'mobile-frontend-main-menu-settings' => 'Innstillingar',
	'mobile-frontend-main-menu-settings-heading' => 'Innstillingar for mobilsida',
	'mobile-frontend-settings-site-header' => '{{SITENAME}}-språk',
	'mobile-frontend-settings-site-description' => '{{SITENAME}} er tilgjengeleg på {{PLURAL:$1|eitt språk|$1 språk}}. Alle tilgjengelege utgåver er lista opp nedanfor',
	'mobile-frontend-main-menu-contact' => 'Kontakt',
	'mobile-frontend-main-menu-account-create' => 'Opprett konto',
	'mobile-frontend-page-menu-contents' => 'innhald',
	'mobile-frontend-page-menu-history' => 'Historikk',
	'mobile-frontend-meta-data-issues-header' => 'Betra artikkelen', # Fuzzy
	'mobile-frontend-meta-data-issues' => 'Denne artikkelen har vanskar', # Fuzzy
	'mobile-frontend-ajax-page-loading' => 'Lastar $1',
	'mobile-frontend-page-saving' => 'Lagrar $1',
	'mobile-frontend-ajax-page-error' => 'Ops! Noko gjekk gale. Freist å oppdatera nettlesarvindauga ditt.',
	'mobile-frontend-photo-upload-generic' => 'Doner eit bilete',
	'mobile-frontend-donate-image-title' => 'Doner eit bilete',
	'mobile-frontend-donate-image-heading' => 'Siste bidraga av deg',
	'mobile-frontend-watchlist-add' => 'La til $1 i overvakingslista di',
	'mobile-frontend-watchlist-removed' => 'Fjerna $1 frå overvakingslista di',
	'mobile-frontend-watchlist-view' => 'Sjå overvakingslista di',
	'mobile-frontend-watchlist-a-z' => 'Overvaka sider', # Fuzzy
	'mobile-frontend-watchlist-feed' => 'Sider med endringar', # Fuzzy
	'mobile-frontend-changeslist-ip' => 'Anonyme brukarar',
	'mobile-frontend-changeslist-nocomment' => 'inkje endringssamandrag',
	'mobile-frontend-watchlist-filter-all' => 'Alle',
	'mobile-frontend-watchlist-filter-articles' => 'Artiklar',
	'mobile-frontend-watchlist-filter-talk' => 'Diskusjon',
	'mobile-frontend-watchlist-filter-other' => 'Andre',
	'mobile-frontend-diffview-title' => 'Endring på $1', # Fuzzy
	'mobile-frontend-diffview-editcount' => '{{PLURAL:$1|éi endring|$1 endringar}}',
	'mobile-frontend-diffview-anonymous' => 'Anonym brukar',
	'mobile-frontend-diffview-bytesadded' => '$1 {{PLURAL:$1|byte lagde til}}',
	'mobile-frontend-diffview-bytesremoved' => '$1 {{PLURAL:$1|byte fjerna}}',
	'mobile-frontend-table' => 'Tabell $1',
	'mobile-frontend-saving-exit-page' => 'Bidraget ditt vert framleis lagra. Fer du bort no vil bidraget ditt verta tapt. Er du viss på at du ynskjer å forlata?',
	'mobile-frontend-photo-upload' => 'Legg til det fyrste fotoet på sida',
	'mobile-frontend-photo-caption-placeholder' => 'Legg til ein bilettekst for biletet',
	'mobile-frontend-image-loading' => 'Lastar bilete',
	'mobile-frontend-image-uploading' => 'Lastar opp bilete',
);

/** Occitan (occitan)
 * @author Boulaur
 * @author Cedric31
 */
$messages['oc'] = array(
	'mobile-frontend-desc' => 'Afichatge mobil',
	'mobile-frontend-search-submit' => 'Consultar',
	'mobile-frontend-home-button' => 'Acuèlh',
	'mobile-frontend-logged-out' => 'Pas connectat(-ada)',
	'mobile-frontend-logged-in-homepage-notification' => 'Benvenguda, $1!',
	'mobile-frontend-logged-in-toast-notification' => 'Connectat en tant que $1.',
	'mobile-frontend-sign-up-heading' => 'Inscrivètz-vos',
	'mobile-frontend-sign-in-heading' => 'Connexion',
	'mobile-frontend-sign-in-error-heading' => 'Ops',
	'mobile-frontend-settings-beta' => 'Bèta',
	'mobile-frontend-random-button' => "A l'azard",
	'mobile-frontend-ajax-random-yes' => 'Òc',
	'mobile-frontend-ajax-random-retry' => 'Ensajatz tornarmai',
	'mobile-frontend-ajax-random-suggestions' => 'Autras suggestions :',
	'mobile-frontend-back-to-top-of-section' => "Tornar d'una seccion",
	'mobile-frontend-close-section' => 'Tampar aquesta seccion',
	'mobile-frontend-show-button' => 'Afichar',
	'mobile-frontend-hide-button' => 'Amagar',
	'mobile-frontend-regular-site' => 'Desactivar la version mobil',
	'mobile-frontend-wml-continue' => 'Contunhar…',
	'mobile-frontend-wml-back' => 'Retorn…',
	'mobile-frontend-view' => 'Afichatge mobil',
	'mobile-frontend-view-desktop' => 'Burèu',
	'mobile-frontend-view-mobile' => 'Mobil',
	'mobile-frontend-images-status' => 'Imatges',
	'mobile-frontend-missing-image' => 'Imatge',
	'mobile-frontend-off' => 'OFF',
	'mobile-frontend-on' => 'ON',
	'mobile-frontend-featured-article' => 'Lutz sus...',
	'mobile-frontend-leave-feedback-message' => 'Messatge :',
	'mobile-frontend-language' => 'Lenga :',
	'mobile-frontend-language-site-choose' => 'Recèrcar la lenga',
	'mobile-frontend-username' => "Nom d'utilizaire :",
	'mobile-frontend-password' => 'Senhal :',
	'mobile-frontend-username-placeholder' => "Nom d'utilizaire",
	'mobile-frontend-password-placeholder' => 'Senhal',
	'mobile-frontend-login' => 'Se connectar',
	'mobile-frontend-last-modified-date' => 'Darrièra modificacion lo $1, a $2',
	'mobile-frontend-last-modified-seconds' => 'Darrièra modificacion i a {{PLURAL:$1|$1 segonda|$1 segondas}}',
	'mobile-frontend-last-modified-minutes' => 'Darrièra modificacion i a {{PLURAL:$1|$1 minuta|$1 minutas}}',
	'mobile-frontend-last-modified-hours' => 'Darrièra modificacion i a {{PLURAL:$1|$1 ora|$1 oras}}',
	'mobile-frontend-last-modified-days' => 'Darrièra modificacion i a {{PLURAL:$1|$1 jorn|$1 jorns}}',
	'mobile-frontend-last-modified-months' => 'Darrièra modificacion i a {{PLURAL:$1|$1 mes|$1 meses}}',
	'mobile-frontend-last-modified-years' => 'Darrièra modificacion i a {{PLURAL:$1|$1 an|$1 ans}}',
	'mobile-frontend-account-create-submit' => 'Inscrivètz-vos',
	'mobile-frontend-password-confirm-placeholder' => 'Confirmatz lo senhal',
	'mobile-frontend-account-create-email-placeholder' => 'Adreça de corrièl (facultativa)',
	'mobile-frontend-account-create-captcha-placeholder' => 'Entratz lo tèxte de seguretat',
	'mobile-frontend-overlay-escape' => 'Retorn en arrièr',
	'mobile-frontend-placeholder' => 'Recercar sus {{SITENAME}}',
	'mobile-frontend-placeholder-beta' => 'Recercar {{SITENAME}} (Bèta)',
	'mobile-frontend-placeholder-alpha' => 'Recercar sus {{SITENAME}} (Mòde Dragon)',
	'mobile-frontend-dismiss-notification' => 'regetar aquesta notificacion',
	'mobile-frontend-clear-search' => 'Escafar',
	'mobile-frontend-privacy-link-text' => 'Confidencialitat',
	'mobile-frontend-about-link-text' => 'A prepaus',
	'mobile-frontend-footer-sitename' => '{{SITENAME}}',
	'mobile-frontend-footer-contact' => 'Contacte',
	'mobile-frontend-main-menu-button-tooltip' => 'Dobrir lo menú principal',
	'mobile-frontend-main-menu-page-title' => 'Navigacion dins lo site',
	'mobile-frontend-main-menu-nearby' => 'A proximitat',
	'mobile-frontend-main-menu-login' => 'Connectatz-vos',
	'mobile-frontend-main-menu-logout' => 'Se desconnectar',
	'mobile-frontend-main-menu-watchlist' => 'Lista de seguiment',
	'mobile-frontend-main-menu-settings' => 'Paramètres',
	'mobile-frontend-main-menu-settings-heading' => 'Paramètres per site mobil',
	'mobile-frontend-settings-site-header' => 'Lengas de {{SITENAME}}',
	'mobile-frontend-main-menu-contact' => 'Contacte',
	'mobile-frontend-main-menu-account-create' => 'Crear un compte',
	'mobile-frontend-page-menu-contents' => 'contenguts',
	'mobile-frontend-page-menu-history' => 'Istoric',
	'mobile-frontend-meta-data-issues-header' => 'Problèmas',
	'mobile-frontend-ajax-page-loading' => 'Cargament de $1',
	'mobile-frontend-page-saving' => 'Enregistrament de $1',
	'mobile-frontend-photo-upload-generic' => 'Balhar un imatge',
	'mobile-frontend-donate-image-title' => 'Balhar un imatge',
	'mobile-frontend-watchlist-more' => 'mai',
	'mobile-frontend-watchlist-cta-button-login' => 'Connectatz-vos',
	'mobile-frontend-watchlist-cta-button-signup' => 'Inscrivètz-vos',
	'mobile-frontend-watchlist-a-z' => 'Totes',
	'mobile-frontend-watchlist-feed' => 'Modificats',
	'mobile-frontend-watchlist-a-z-empty-howto-alt' => 'Clicatz sus l’estela amont de la pagina',
	'mobile-frontend-watchlist-back-home' => 'Retorn a l’acuèlh',
	'mobile-frontend-watchlist-filter-all' => 'Totes',
	'mobile-frontend-watchlist-filter-articles' => 'Articles',
	'mobile-frontend-watchlist-filter-talk' => 'Discussion',
	'mobile-frontend-watchlist-filter-other' => 'Autres',
	'mobile-frontend-watchlist-modified' => 'Modificat $1',
	'mobile-frontend-diffview-404-title' => 'Marrida revision',
	'mobile-frontend-diffview-title' => 'Cambiaments',
	'mobile-frontend-diffview-editcount' => '$1 {{PLURAL:$1|cambiament|cambiaments}}',
	'mobile-frontend-diffview-anonymous' => 'Utilizaire anonim',
	'mobile-frontend-diffview-bytesadded' => '$1 {{PLURAL:$1|octet apondut|octets aponduts}}',
	'mobile-frontend-diffview-bytesremoved' => '$1 {{PLURAL:$1|octet suprimit|octets suprimits}}',
	'mobile-frontend-table' => 'Tablèu $1',
);

/** Oriya (ଓଡ଼ିଆ)
 * @author Jnanaranjan Sahu
 * @author Odisha1
 * @author Psubhashish
 */
$messages['or'] = array(
	'mobile-frontend-desc' => 'ମୋବାଇଲ ଦେଖଣା',
	'mobile-frontend-search-submit' => 'ଯିବା',
	'mobile-frontend-home-button' => 'ମୂଳ ଜାଗା',
	'mobile-frontend-logged-out' => 'ଲଗ‌‌ ଇନ କରିନାହାନ୍ତି',
	'mobile-frontend-logged-in-homepage-notification' => 'ସ୍ଵାଗତ, $1!',
	'mobile-frontend-logged-in-toast-notification' => '$1 ଭାବେ ଲଗଇନ ହେଲା ।',
	'mobile-frontend-sign-up-heading' => 'ନାମ ଲେଖାଇବେ',
	'mobile-frontend-sign-in-heading' => 'ଲଗ ଇନ କରିବେ',
	'mobile-frontend-sign-in-why' => 'ଯଦି ଆପଣଙ୍କର ଗୋଟିଏ {{SITENAME}} ଖାତା ଅଛି, ଆପଣ ତଳେ ଲଗ ଇନ କରିପାରିବେ ।',
	'mobile-frontend-sign-in-error-heading' => 'ଓଃହ',
	'mobile-frontend-settings-description' => 'ମୋବାଇଲ ପାଇଁ ଥିବା ସଜାଣିଦ୍ଵାରା ସଜାଇ ଆପଣଙ୍କର ମୋବାଇଲ ଅଭିଜ୍ଞାତକୁ ସଜାନ୍ତୁ ।',
	'mobile-frontend-settings-beta' => 'ବିଟା',
	'mobile-frontend-settings-alpha' => '[//en.wikipedia.org/wiki/Here_be_dragons Here be dragons] ମୋଡ',
	'mobile-frontend-settings-alpha-description' => 'ଭୟଙ୍କର ଏବଂ ବ୍ୟବହାର ହୋଇନଥିବା ମୋବାଇଲ ଜଗତକୁ ପସନ୍ତୁ । ଆହୁରି ଅଧିକ ପରୀକ୍ଷାମୂଳକ ବିଶେଷତା ପାଆନ୍ତୁ କିନ୍ତୁ ଅସୁବିଧା ଗୁଡିକ ସହ ।',
	'mobile-frontend-save-settings' => 'ସଜାଣି ସାଇତିବେ',
	'mobile-frontend-random-button' => 'ଯାହିତାହି',
	'mobile-frontend-ajax-random-heading' => 'ଜ୍ଞାନ ଅହୋରଣ କରୁଛି...',
	'mobile-frontend-ajax-random-quote' => 'ନିଜସ୍ଵ ଜ୍ଞାନ ଜନ୍ମ ବେଳେ ଆସିବ ଏବଂ ମୃତ୍ୟୁ ବେଳକୁ ଅପସରି ଯିବ',
	'mobile-frontend-ajax-random-question' => 'ଏହି ପୃଷ୍ଠାଟି ପଢ଼ିବେ କି ?',
	'mobile-frontend-ajax-random-yes' => 'ହଁ',
	'mobile-frontend-ajax-random-retry' => 'ପୁଣି ଥରେ ଚେଷ୍ଟା କରନ୍ତୁ',
	'mobile-frontend-ajax-random-suggestions' => 'ଅନ୍ୟାନ୍ୟ ମତାମତ:',
	'mobile-frontend-back-to-top-of-section' => 'ଏକ ଭାଗକୁ ଡେଇଁଯିବେ',
	'mobile-frontend-close-section' => 'ଏହି ବାଛିବାକୁ ବନ୍ଦ କରିବେ',
	'mobile-frontend-show-button' => 'ଦେଖାଇବେ',
	'mobile-frontend-hide-button' => 'ଲୁଚାନ୍ତୁ',
	'mobile-frontend-empty-homepage-text' => 'ଏହି ମୂଳପୃଷ୍ଠାଟି ସଜା ହେବା ଦରକାର ।
[//meta.wikimedia.org/wiki/Mobile_Projects/Mobile_Gateway#Mobile_homepage Instructions on how to get this site mobile enabled]',
	'mobile-frontend-regular-site' => 'ଡେସ୍କଟପ ଦେଖଣା',
	'mobile-frontend-wml-continue' => 'ଚାଲୁରଖ ...',
	'mobile-frontend-wml-back' => 'ପୂର୍ବବର୍ତ୍ତୀ ...',
	'mobile-frontend-view' => 'ମୋବାଇଲ ଦେଖଣା',
	'mobile-frontend-view-desktop' => 'ଡେସ୍କଟପ',
	'mobile-frontend-view-mobile' => 'ମୋବାଇଲ',
	'mobile-frontend-opt-in-explain' => 'betaରେ ଯୋଗ ଦେଇ , ଆପଣଙ୍କୁ ପରଖ ପାଇଁ ଅନୁମତି ମିଳିଥାଏ ଯାହା ବଗ୍ ଓ ଅସୁବିଧାସବୁର ସମ୍ମୁଖୀନ ହେବାକୁ ପଡ଼ିପାରେ ।',
	'mobile-frontend-images-status' => 'ଛବିଗୁଡିକ',
	'mobile-frontend-disable-images' => 'ମୋବାଇଲ ସାଇଟ ପାଇଁ ଛବି ଦେଖଣା ଅଚଳ କରିବେ',
	'mobile-frontend-enable-images' => 'ମୋବାଇଲ ସାଇଟ ପାଇଁ ଛବି ଦେଖଣା ସଚଳ କରିବେ',
	'mobile-frontend-missing-image' => 'ଛବି',
	'mobile-frontend-off' => 'ବନ୍ଦ',
	'mobile-frontend-on' => 'ଚାଲୁ',
	'mobile-frontend-footer-contributors-text' => 'ପୃଷ୍ଠାଟି ଆପଣଙ୍କ ଭଳି [$1 ଅବଦନକାରୀ]ଙ୍କ ଦ୍ଵାରା',
	'mobile-frontend-featured-article' => 'ଆଜିର ବଛା ଲେଖା',
	'mobile-frontend-news-items' => 'ଖବରରେ',
	'mobile-frontend-leave-feedback-notice' => 'ଆପଣଙ୍କ ମତାମତ ଆମ୍ଭଙ୍କୁ ଆପଣଙ୍କର ମୋବାଇଲ ସାଇଟର ଅନୁଭୂତି ସୁଧାରିବାରେ ସହଯୋଗ କରିଥାଏ । &quot;$1&quot; ପୃଷ୍ଠାରେ ଏହା ସାଧାରଣରେ ପ୍ରକାଶିତ ହେବ (ଆପଣଙ୍କ ଇଉଜର ନାମ, ବ୍ରାଉଜର ସଂସ୍କରଣ ଓ ଅପରେଟିଙ୍ଗ ସିଷ୍ଟମ ସହିତ) । ଦୟାକରି ସୂଚନାକାରୀ ବିଷୟ ଧାଡ଼ିଟିଏ ବାଛନ୍ତୁ; ଯଥା - "ଓସାରିଆ ସାରଣୀ ଦେଖିବାରେ ଅସୁବିଧା" । ଆପଣଙ୍କର ମତ ଆମ୍ଭର ବ୍ୟବହାର ବିଧିଭୁକ୍ତ ।',
	'mobile-frontend-leave-feedback-warning' => 'ଯଦି ଆପଣ ନିଜ ବ୍ୟକ୍ତିଗତ ସୂଚନା କାହାକୁ ଦେବାକୁ ଚାହୁଁନାହାନ୍ତି, ତେବେ ଆପଣଙ୍କ ବ୍ୟକ୍ତିଗତ ସୂଚନା ମନ୍ତବ୍ୟରେ ଦିଅନ୍ତୁ ନାହିଁ ।',
	'mobile-frontend-leave-feedback-subject' => 'ବିଷୟ :',
	'mobile-frontend-leave-feedback-message' => 'ସନ୍ଦେଶ :',
	'mobile-frontend-leave-feedback-submit' => 'ମତାମତ ଦିଅନ୍ତୁ',
	'mobile-frontend-leave-feedback-link-text' => 'ମୋବାଇଲ ଆଗ ଭାଗ ଏକ୍ସଟେନସନ ମତାମତ',
	'mobile-frontend-leave-feedback' => 'ମୋବାଇଲ ସାଇଟ ମତାମତ',
	'mobile-frontend-leave-feedback-title' => 'ଆପଣଙ୍କ ମୋବାଇଲ ସାଇଟ ଅଭିଜ୍ଞତା ବାବଦରେ ଆମକୁ ମତାମତ ଦିଅନ୍ତୁ',
	'mobile-frontend-leave-feedback-technical-problem-section-header' => 'ଯାନ୍ତ୍ରିକ ତ୍ରୁଟି',
	'mobile-frontend-leave-feedback-general-section-header' => 'ସାଧାରଣ',
	'mobile-frontend-leave-feedback-article-feedback-section-header' => 'ଲେଖା ମତାମତ',
	'mobile-frontend-leave-feedback-email-body' => 'ଦୟାକରି ଏହି ଧାଡି ଉପରେ  ଆପଣ {{SITENAME}}ରେ ଭୋଗୁଥିବା ଅସୁବିଧା ଗୁଡିକ ବର୍ଣ୍ଣନା କରନ୍ତୁ । ଦୟାକରି ଜାଣିରଖନ୍ତୁ ଯେ ଆମେ ପାଉଥିବା ସମସ୍ତ ସନ୍ଦେଶର ଉତ୍ତର ନ ଦେଇ ପାରୁ ।',
	'mobile-frontend-leave-feedback-technical-link-text' => 'ଯାନ୍ତ୍ରିକ ତ୍ରୁଟି',
	'mobile-frontend-leave-feedback-general-link-text' => 'ସାଧାରଣ ମତାମତ',
	'mobile-frontend-leave-feedback-article-personal-link-text' => 'ମୁଁ,ମାନେ ଜଣେ ଲୋକ, କିମ୍ବା ମୁଁ କାମ କରୁଥିବା କମ୍ପାନୀ ବିଷୟରେ',
	'mobile-frontend-leave-feedback-article-factual-link-text' => 'ଏକ ଯୁକ୍ତିଯୁକ୍ତ ଅସୁବିଧା',
	'mobile-frontend-leave-feedback-article-other-link-text' => 'ଅନ୍ୟ ଅସୁବିଧା ବାବଦରେ',
	'mobile-frontend-leave-feedback-form-subject-placeholder' => 'ମେସେଜ ବିଷୟ',
	'mobile-frontend-leave-feedback-form-message-placeholder' => 'ଆପଣଙ୍କ ମତ ଏଠି ଲେଖନ୍ତୁ',
	'mobile-frontend-leave-feedback-page-title' => 'ଆପଣଙ୍କ ମୋବାଇଲ ସାଇଟ ଅଭିଜ୍ଞତା ବାବଦରେ ଆମକୁ ମତାମତ ଦିଅନ୍ତୁ',
	'mobile-frontend-leave-feedback-special-title' => 'ଆମକୁ ଯୋଗାଯୋଗ କରନ୍ତୁ',
	'mobile-frontend-feedback-no-subject' => '(ବିଷୟହିନ)',
	'mobile-frontend-feedback-no-subject-field' => 'ଦୟାକରି ଏକ ବିଷୟର ନାମ ଦିଅନ୍ତୁ ।',
	'mobile-frontend-feedback-no-message' => 'ଦୟାକରି ଆପଣଙ୍କ ସନ୍ଦେଶ ଏଠି ଲେଖନ୍ତୁ',
	'mobile-frontend-feedback-edit-summary' => '$1 - [[Special:MobileFeedback|mobile feedback tool]]କୁ ବ୍ୟବହାର କରି ଆପେ ଆପେ ପୋଷ୍ଟ ହେଇଛି',
	'mobile-frontend-leave-feedback-thanks' => 'ଆପଣଙ୍କ ମତାମତ ନିମନ୍ତେ ଧନ୍ୟବାଦ!',
	'mobile-frontend-leave-feedback-post-error' => 'ଆପଣଙ୍କର ସନ୍ଦେଶଟିକୁ ପଠାଇବାରେ ଅସୁବିଧା ହେଲା । ଦୟାକରି କିଛି ସମୟ ପରେ ଆଉଥରେ ଚେଷ୍ଟା କରନ୍ତୁ ।',
	'mobile-frontend-language' => 'ଭାଷା :',
	'mobile-frontend-language-article-heading' => 'ଅନ୍ୟ ଭାଷାରେ ପଢିବେ',
	'mobile-frontend-language-header' => 'ଏହି ପୃଷ୍ଠାଟି $1 {{PLURAL:$1|language|languages}}ରେ ଅଛି ।',
	'mobile-frontend-language-variant-header' => '{{#language:{{CONTENTLANG}}}} ବିଭିନ୍ନତାରୁ ବାଛନ୍ତୁ',
	'mobile-frontend-language-footer' => 'ଟୀକା: ଏହି ପୃଷ୍ଠାଟି ଆପଣଙ୍କ ଜଣାଶୁଣା ଭାଷାରେ ନ ଲେଖା ହୋଇଥାଇପାରେ । ଏଠାରେ କ୍ଲିକ କରି ଆପଣ କେଉଁ କେଉଁ ଭାଷା {{SITENAME}} ରହୁଛି ଦେଖି ପାରିବେ ।',
	'mobile-frontend-language-site-choose' => 'ଖୋଜା ଭାଷା',
	'mobile-frontend-username' => 'ବ୍ୟବହାରକାରୀଙ୍କ ନାମ:',
	'mobile-frontend-password' => 'ପାସୱାର୍ଡ଼',
	'mobile-frontend-username-placeholder' => 'ବ୍ୟବହାରକାରୀଙ୍କ ନାମ',
	'mobile-frontend-password-placeholder' => 'ପାସୱାର୍ଡ଼',
	'mobile-frontend-login' => 'ଲଗଇନ',
	'mobile-frontend-last-modified-date' => 'ଗତଥର $1ରେ, $2ଠାରେ ବଦଲାଯାଇଥିଲା',
	'mobile-frontend-last-modified-seconds' => 'ଗତଥର {{PLURAL:$1|$1 second|$1 seconds}} ପୂର୍ବରୁ ବଦଳା ଯାଇଥିଲା',
	'mobile-frontend-last-modified-minutes' => 'ଗତଥର {{PLURAL:$1|$1 minute|$1 minutes}} ପୂର୍ବରୁ ବଦଳା ଯାଇଥିଲା',
	'mobile-frontend-last-modified-hours' => 'ଗତଥର {{PLURAL:$1|$1 hour|$1 hours}} ପୂର୍ବରୁ ବଦଳା ଯାଇଥିଲା',
	'mobile-frontend-last-modified-days' => 'ଗତଥର {{PLURAL:$1|$1 ଦିନ|$1 ଦିନଗୁଡିକ}} ପୂର୍ବରୁ ବଦଳା ଯାଇଥିଲା',
	'mobile-frontend-last-modified-months' => 'ଗତଥର {{PLURAL:$1|$1 month|$1 months}} ପୂର୍ବରୁ ବଦଳା ଯାଇଥିଲା',
	'mobile-frontend-last-modified-years' => 'ଗତଥର {{PLURAL:$1|$1 year|$1 years}} ପୂର୍ବରୁ ବଦଳା ଯାଇଥିଲା',
	'mobile-frontend-account-create-submit' => 'ନାମ ଲେଖାଇବେ',
	'mobile-frontend-password-confirm-placeholder' => 'ପାସୱାର୍ଡ ନିଶ୍ଚିତ କରିବେ',
	'mobile-frontend-account-create-email-placeholder' => 'ଇ-ମେଲ ଠିକଣା(ଇଚ୍ଛାଧୀନ)',
	'mobile-frontend-account-create-captcha-placeholder' => 'ସୁରକ୍ଷା ପାଇଁ ଏଥିରେ ଥିବା ଅକ୍ଷରଗୁଡିକୁ ଲେଖନ୍ତୁ',
	'mobile-frontend-overlay-escape' => 'ପଛକୁ ଫେରିବେ',
	'mobile-frontend-placeholder' => '{{SITENAME}}ରେ ଖୋଜିବେ',
	'mobile-frontend-placeholder-beta' => '{{SITENAME}}ରେ ଖୋଜିବେ (bita)',
	'mobile-frontend-placeholder-alpha' => '{{SITENAME}}ରେ ଖୋଜିବେ (ଡ୍ରାଗନ ମୋଡ)',
	'mobile-frontend-search-help' => 'ଆପଣ ଯାହା ଖୋଜିବାକୁ ଚାହୁଁଛନ୍ତି ତାହା ଏଠାରେ ଲେଖନ୍ତୁ ଏବଂ ମିଶୁଥିବା ଲେଖାର ଶୀର୍ଷକ ଗୁଡିକ ଏଠାରେ ଆସିଯିବା ।',
	'mobile-frontend-dismiss-notification' => 'ସୂଚନାଟିକୁ ହଟାଇଦିଅନ୍ତୁ',
	'mobile-frontend-clear-search' => 'ଖାଲି କରିଦିଅନ୍ତୁ',
	'mobile-frontend-privacy-link-text' => 'ଗୁମରନିତି',
	'mobile-frontend-about-link-text' => 'ବିଷୟରେ',
	'mobile-frontend-footer-sitename' => '{{SITENAME}}',
	'mobile-frontend-footer-license-text' => 'ଲେଖାଟି [//en.m.wikipedia.org/wiki/Wikipedia:Text_of_Creative_Commons_Attribution-ShareAlike_3.0_Unported_License?useformat=mobile CC BY-SA 3.0] ଅନ୍ତର୍ଗତ ଅଛି',
	'mobile-frontend-terms-use-text' => '[//wikimediafoundation.org/wiki/Terms_of_use?useformat=mobile Terms of Use]',
	'mobile-frontend-footer-contact' => 'ଯୋଗାଯୋଗ',
	'mobile-frontend-search-noresults' => 'ଆପଣ ଖୋଜୁଥିବା ଲେଖାଟି କୌଣସି ଲେଖା ସହ ମିଳିଲାନି ।ଆପଣଙ୍କ ଖୋଜା ଲେଖାଟିକୁ ବଦଳାନ୍ତୁ, କିମ୍ବା କିବୋର୍ଡରେ ଥିବା ଖୋଜିବା ବଟନଟିକୁ କ୍ଲିକ କରି ପୃଷ୍ଠାଗୁଡିକ ଭିତରେ ଖୋଜନ୍ତୁ ।',
	'mobile-frontend-main-menu-button-tooltip' => 'ମୁଖ୍ୟ ମିନୁ ଦେଖିବେ',
	'mobile-frontend-main-menu-page-title' => 'ସାଇଟ ଦିଗବାରେଣୀ',
	'mobile-frontend-main-menu-featured' => 'ବିଶେଷ',
	'mobile-frontend-main-menu-nearby' => 'ପାଖାପାଖି',
	'mobile-frontend-main-menu-login' => 'ଲଗ ଇନ',
	'mobile-frontend-main-menu-logout' => 'ଲଗ ଆଉଟ',
	'mobile-frontend-main-menu-watchlist' => 'ଦେଖଣାତାଲିକା',
	'mobile-frontend-main-menu-settings' => 'ସଜାଣି',
	'mobile-frontend-main-menu-upload' => 'ଅପଲୋଡ଼ କରିବେ',
	'mobile-frontend-main-menu-settings-heading' => 'ମୋବାଇଲ ସାଇଟ ସଜାଣି',
	'mobile-frontend-settings-site-header' => '{{SITENAME}} ଭାଷାଗୁଡିକ',
	'mobile-frontend-settings-site-description' => '{{SITENAME}}ଟି $1 {{PLURAL:$1|ଭାଷା|ଭାଷାଗୁଡିକ}}ରେ ଉପଲବ୍ଧ ।ସମସ୍ତ ଉପଲବ୍ଧ ସଂସ୍କରଣର ତାଲିକା ତଳେ ଅଛି',
	'mobile-frontend-main-menu-contact' => 'ସମ୍ପର୍କ',
	'mobile-frontend-main-menu-account-create' => 'ଖାତାଟିଏ ଖୋଲିବେ',
	'mobile-frontend-page-menu-contents' => 'ସୂଚୀପତ୍ର',
	'mobile-frontend-page-menu-history' => 'ଇତିହାସ',
	'mobile-frontend-meta-data-issues-header' => 'ଅସୁବିଧାଗୁଡିକ',
	'mobile-frontend-meta-data-issues' => 'ଏହି ପୃଷ୍ଠାରେ କିଛି ଅସୁବିଧା ଅଛି',
	'mobile-frontend-ajax-page-loading' => '$1 ଲୋଡ ହେଉଛି',
	'mobile-frontend-page-saving' => '$1 ସାଇତା ଯାଉଛି',
	'mobile-frontend-ajax-page-error' => 'ଓଃହ! କିଛିଗୋଟେ ଅସୁବିଧା ହେଲା । ଦୟାକରି ଆପଣଙ୍କ ବ୍ରାଉଜରକୁ ଆଉଥରେ ରିଫ୍ରେଶ କରନ୍ତୁ ।',
	'mobile-frontend-nearby-title' => 'ପାଖାପାଖି',
	'mobile-frontend-nearby-loading' => 'ଆପଣଙ୍କ ବର୍ତ୍ତମାନର ଅବସ୍ଥାନର ପାଖାପାଖି ଲେଖାଗୁଡ଼ିକ ଧାରଣା ହେଉଛି',
	'mobile-frontend-nearby-requirements' => 'ଏହି ପୃଷ୍ଠାଟି ଉଭୟ ଜାଭାସ୍କ୍ରିପ୍ଟ ଏବଂ ଅବସ୍ଥିତି ନିର୍ଧାରକ ବ୍ରାଉଜର ଆବଶ୍ୟକ କରୁଛି ।',
	'mobile-frontend-nearby-distance-report' => 'ଆପଣଙ୍କ ବର୍ତ୍ତମାନର ଅବସ୍ଥିତି ଠାରୁ $1 କି.ମି',
	'mobile-frontend-nearby-lookup-error' => 'ଆପଣଙ୍କ ଅବସ୍ଥିତି ଜଣାପଡିଲା ନାହିଁ । ଆଉଥରେ ଚେଷ୍ଟା କରନ୍ତୁ..',
	'mobile-frontend-nearby-noresults' => 'ଆପଣ କୋଉଠି ଅଛନ୍ତି ଜଣାପଡୁନି ଏବଂ ଆମେ ମଧ୍ୟ ଆପଣଙ୍କ ପାଇଁ କିଛି ଲେଖା ପାଉନୁ । ଅପଣ ନିଜେ ଗୋଟେ ଲେଖନ୍ତୁ ନା ?',
	'mobile-frontend-nearby-refresh' => 'ଆମେ ଆପଣଙ୍କ ପ୍ରକୃତ ଅବସ୍ଥିତି ପାଇଲୁ । ଏଠାରେ କ୍ଲିକ କରି ପାଖାପାଖି ଲେଖାଗୁଡ଼ିକୁ ଆଉଥରେ ଲୋଡ କରନ୍ତୁ',
	'mobile-frontend-nearby-error' => 'ପାଖାପାଖି ପୃଷ୍ଠାଗୁଡିକୁ ଖୋଜିଲା ବେଳେ କିଛିଗୋଟେ ଅଜଣା ଅସୁବିଧା ଉପୁଜିଲା',
	'mobile-frontend-donate-image-login' => 'ଆପଣଙ୍କ ଅପଲୋଡଗୁଡିକୁ ଦେଖିବା ପାଇଁ ଲଗଇନ କରନ୍ତୁ', # Fuzzy
	'mobile-frontend-photo-upload-generic' => 'ଛବିଟିଏ ଅବଦାନ କରିବେ',
	'mobile-frontend-donate-image-title' => 'ଛବିଟିଏ ଅବଦାନ କରିବେ',
	'mobile-frontend-donate-image-summary' => 'ଛବିଗୁଡିକ {{SITENAME}}ରେ ଥିବା ପୃଷ୍ଠାଗୁଡିକୁ ଜୀବନ୍ତ କରିଦିଏ ।
ସର୍ଭରରେ ମାଗଣା ପଞ୍ଜୀକୃତ ହୋଇଥିବା ଛବିଗୁଡିକର ଅଭାବ ଯୋଗୁ ବହୁତ ଗୁଡିଏ ପୃଷ୍ଠା ଅଛି ଯେଉଁଥିରେ ଛବି ନାହିଁ ।
ଆପଣ ଅବଦାନ କରିବାକୁ ଚାହୁଁଥିବା ଛବିଗୁଡିକୁ ଦେଇ ଏହି ପୃଷ୍ଠାରେ ଜୀବନ ଆଣିବା ସଙ୍ଗେ ସଙ୍ଗେ {{SITENAME}} ସମ୍ପାଦନା ଗୋଷ୍ଠୀର ବ୍ୟବହାରରେ ସାହାଯ୍ୟ କରନ୍ତୁ ।',
	'mobile-frontend-donate-image-heading' => 'ଆପଣଙ୍କର ଏବେକାର ଅବଦାନଗୁଡିକ',
	'mobile-frontend-donate-image-page-title' => 'ଅପଲୋଡ଼ କରିବେ',
	'mobile-frontend-donate-image-anon' => 'ଏହି ଅପଲୋଡ ହୋଇଥିବା ପୃଷ୍ଠା ଦେଖିବାକୁ ହେଲେ ଗୋଟେ [[Special:UserLogin|ବ୍ୟବହାରକାରୀ ଖାତା]] ଆବଶ୍ୟକ',
	'mobile-frontend-listed-image-no-description' => 'କୌଣସି ବର୍ଣ୍ଣନା ନାହିଁ',
	'mobile-frontend-donate-photo-upload-success' => 'ସଫଳ ! ବର୍ତ୍ତମାନ ଆପଣଙ୍କର ଛବିଟି {{SITENAME}}!ରେ ବ୍ୟବହାର କରାଯାଇପାରିବ !',
	'mobile-frontend-donate-photo-first-upload-success' => 'ସଫଳ ! ଆପଣଙ୍କର ପ୍ରଥମ ଅବଦାନ ପାଇଁ ଧନ୍ୟବାଦ !',
	'mobile-frontend-watchlist-add' => 'ଆପଣଙ୍କ ଦେଖଣା ତାଲିକାରେ ଯୋଡା ଯାଇଥିବା $1',
	'mobile-frontend-watchlist-removed' => '$1କୁ ଆପଣଙ୍କ ଦେଖଣାତାଲିକାରୁ ହଟାଇବେ',
	'mobile-frontend-watchlist-view' => 'ଆପଣଙ୍କ ଦେଖଣାତାଲିକା ଦେଖିବେ',
	'mobile-frontend-watchlist-more' => 'ଅଧିକ',
	'mobile-frontend-watchlist-cta' => 'ଏହି ପୃଷ୍ଠାକୁ ଦେଖବା ପାଇଁ ଦୟାକରି ଲଗଇନ କରନ୍ତୁ କିମ୍ବା  ନାମ ଲେଖାନ୍ତୁ ।',
	'mobile-frontend-watchlist-cta-button-login' => 'ଲଗଇନ',
	'mobile-frontend-watchlist-cta-button-signup' => 'ନାମ ଲେଖାଇବେ',
	'mobile-frontend-watchlist-a-z' => 'ସମସ୍ତ',
	'mobile-frontend-watchlist-feed' => 'ବଦଳାଯାଇଥିବା',
	'mobile-frontend-watchlist-a-z-empty' => 'ଆପଣ ବର୍ତ୍ତମାନ କୌଣସି ପୃଷ୍ଠା ଦେଖୁନାହାନ୍ତି',
	'mobile-frontend-watchlist-a-z-empty-howto-alt' => 'ପୃଷ୍ଠାଟିର ଉପରେ ଥିବା ତାରା ଚିହ୍ନ ଉପରେ କ୍ଲିକ କରନ୍ତୁ',
	'mobile-frontend-watchlist-a-z-empty-howto' => 'ସ୍କ୍ରୀନର ଉପରେ ଥିବା ତାରା ଚିହ୍ନ ଉପରେ କ୍ଲିକ କରି ଆପଣଙ୍କୁ ଭଲ ଲାଗିଥିବା ପୃଷ୍ଠାଟିକୁ ଦେଖନ୍ତୁ । ଏହା ଆପଣଙ୍କୁ ଏହି ପୃଷ୍ଠଟିକୁ ବୁକମାର୍କ କରେଇବାରେ ଏବଂ ସେଥିରେ ବଦଳ ହେଲେ ଦେଖେଇବାରେ ସାହାଯ୍ୟ କରିବ ।',
	'mobile-frontend-watchlist-feed-empty' => 'ନଗଦବଦଳରେ କୌଣସି ପୃଷ୍ଠା ନାହିଁ',
	'mobile-frontend-watchlist-back-home' => 'ମୂଳକୁ ଫେରିବେ',
	'mobile-frontend-changeslist-ip' => 'Anonymous user',
	'mobile-frontend-changeslist-nocomment' => 'ବଦଳ ସାରକଥା ଲୁଚାଇଦିଅନ୍ତୁ',
	'mobile-frontend-watchlist-filter-all' => 'ସମସ୍ତ',
	'mobile-frontend-watchlist-filter-articles' => 'ପ୍ରସଙ୍ଗଗୁଡିକ',
	'mobile-frontend-watchlist-filter-talk' => 'କଥାଭାଷା',
	'mobile-frontend-watchlist-filter-other' => 'ଅନ୍ୟାନ୍ୟ',
	'mobile-frontend-watchlist-modified' => 'ବଦଳାଯାଇଥିବା $1',
	'mobile-frontend-diffview-404-title' => 'ଖରାପ ପୁନରାବୃତି',
	'mobile-frontend-diffview-404-desc' => 'ଆପଣ ପୁନରାବୃତି କରିବା ପାଇଁ ଚାହୁଁଥିବା IDଟି ଉପଲବ୍ଧ ନାହିଁ',
	'mobile-frontend-diffview-title' => 'ବଦଳଗୁଡିକ',
	'mobile-frontend-diffview-editcount' => '$1 {{PLURAL:$1|ବଦଳାଇଲେ|ମାନେ ବଦଳାଇଲେ}}',
	'mobile-frontend-diffview-anonymous' => 'ବେନାମି ସଭ୍ୟ',
	'mobile-frontend-diffview-bytesadded' => '$1 {{PLURAL:$1|ବାଇଟ|ବାଇଟଗୁଡିକ}} ଯୋଡାଗଲା',
	'mobile-frontend-diffview-bytesremoved' => '$1 {{PLURAL:$1|ବାଇଟ|ବାଇଟଗୁଡିକ}} କଢାଗଲା',
	'mobile-frontend-diffview-explained' => 'ଏହି ଧାଡିଗୁଡିକ ଯୋଡାଗଲା (+) ଏବଂ କଢାଗଲା (-):',
	'mobile-frontend-table' => '$1 ସାରଣୀ',
	'mobile-frontend-saving-exit-page' => 'ଆପଣଙ୍କ ଅବଦାନଗୁଡିକ ଏଯାଏଁ ସାଇତା ଯାଉଛି । ଯଦି ଆପଣ ଚାଲିଯିବେ ତାହେଲେ ଆପଣଙ୍କ ଅବଦାନଗୁଡିକ କଟିଯିବା । ଆପଣ ନିଶ୍ଚିତ ଯେ ଏହି ପୃଷ୍ଠାକୁ ବନ୍ଦ କରିବେ ?',
	'mobile-frontend-photo-upload' => 'ଏହି ଲେଖାରେ ଛବିଟିଏ ଯୋଡନ୍ତୁ',
	'mobile-frontend-photo-article-edit-comment' => 'ଏହି ପୃଷ୍ଠାରେ ବ୍ୟବହାର ପାଇଁ ଫଟୋ ଯୋଡାଗଲା',
	'mobile-frontend-photo-article-donate-comment' => 'ମୋବାଇଲ ଦ୍ଵାରା ଛବି ଅବଦାନ କରିବେ',
	'mobile-frontend-photo-upload-comment' => 'ପୃଷ୍ଠାରେ ଫଟୋ ଯୋଡାଗଲା',
	'mobile-frontend-photo-caption-placeholder' => 'ସବିଶେଷ ଯୋଡନ୍ତୁ (ଆବଶ୍ୟକ)',
	'mobile-frontend-image-loading' => 'ଛବି ଲୋଡ ହେଉଛି',
	'mobile-frontend-image-uploading-wait' => 'ଛବି ଅପଲୋଡ ହେଉଛି, ଦୟାକରି ଅପେକ୍ଷା କରନ୍ତୁ ।',
	'mobile-frontend-image-uploading-long' => 'ଛବିଟି ଏବେବି ଅପଲୋଡ ହେଉଛି ! ଆପଣଙ୍କର ଧୈର୍ଯ୍ୟ ପାଇଁ ଧନ୍ୟବାଦ ।',
	'mobile-frontend-image-uploading-cancel' => 'ଯଦି ଏହା ବହୁତ ସମୟ ନେଉଛି ତେବେ <a href="#">ବାତିଲ କରନ୍ତୁ</a> ।',
	'mobile-frontend-photo-upload-error' => 'ଅସୁବିଧା ହେଲା, ଦୟାକରି ଆଉଥରେ ଚେଷ୍ଟା କରନ୍ତୁ ।',
	'mobile-frontend-photo-upload-success-article' => 'ସଫଳ ! ଆପଣଙ୍କ ଛବିଟି ପୃଷ୍ଠାଟିରେ ଆସିଗଲା ।',
	'mobile-frontend-photo-license' => '"ପଇଠ"ରେ କ୍ଲିକ କରିବା ଦ୍ଵାରା ଅପଣ ଆମର [//wikimediafoundation.org/wiki/Terms_of_use ବ୍ୟବହାର କରିବା ନିୟମ] ସହ ରାଜି ହେଉଛନ୍ତି ଏବଂ ଆପଣଙ୍କ ଛବିଟିକୁ [//en.wikipedia.org/wiki/Wikipedia:Text_of_Creative_Commons_Attribution-ShareAlike_3.0_Unported_License କ୍ରିଏଟିଭି କମନ ଆଟ୍ରିବ୍ୟୁସନ-ସେଆରଆଲାଇକ ୩.0 ଲାଇସେନ୍ସ] ଅନ୍ତର୍ଗତ ରଖି ଛାଡୁଛନ୍ତି ।',
	'mobile-frontend-photo-submit' => 'ପଇଠ',
	'mobile-frontend-photo-cancel' => 'ବାତିଲ',
	'mobile-frontend-photo-upload-user-count' => '{{PLURAL:$1|$1ଟି ଅପଲୋଡ|$1 ଗୋଟି ଅପଲୋଡ}}',
	'mobile-frontend-photo-upload-user-count-over-limit' => '୫୦୦+ ଅପଲୋଡଗୁଡିକ',
	'tag-mobile_edit' => 'ମୋବାଇଲ ବଦଳ',
	'tag-mobile_edit-description' => 'ମୋବାଇଲ ସାଇଟଦ୍ଵାରା ହେଇଥିବା ବଦଳଗୁଡିକ',
	'mobile-frontend-drawer-cancel' => 'ବାତିଲ',
);

/** Ossetic (Ирон)
 * @author Amikeco
 * @author Bouron
 */
$messages['os'] = array(
	'mobile-frontend-desc' => 'Мобилон хуыз',
	'mobile-frontend-search-submit' => 'Уацмæ',
	'mobile-frontend-home-button' => 'Райдианмæ',
	'mobile-frontend-logged-out' => 'Системæмæ хызт нæ дæ',
	'mobile-frontend-sign-in-heading' => 'Бахизын',
	'mobile-frontend-sign-in-why' => 'Кæд дын ис {{grammar:genitive|{{SITENAME}}}} аккаунт, уæд дæ бон у дæлдæр бахизын.',
	'mobile-frontend-sign-in-error-heading' => 'Гъери гъа',
	'mobile-frontend-settings-description' => 'Сфæлынд дæ мобилон гарзыл архайд мæнæ ацы мобилон сайты уагæвæрæнтæй.',
	'mobile-frontend-settings-beta' => 'Бета',
	'mobile-frontend-save-settings' => 'Уаг бавæрын',
	'mobile-frontend-random-button' => 'Халæй',
	'mobile-frontend-ajax-random-heading' => 'Зонады ран бæрæг цæуы...',
	'mobile-frontend-ajax-random-question' => 'Ацы уац бафæрсын?', # Fuzzy
	'mobile-frontend-ajax-random-yes' => 'О',
	'mobile-frontend-ajax-random-retry' => 'Ногæй бафæлварын',
	'mobile-frontend-back-to-top-of-section' => 'Раздæхын иу хай фæстæмæ',
	'mobile-frontend-close-section' => 'Ацы хай сæхгæнын',
	'mobile-frontend-show-button' => 'Равдисын',
	'mobile-frontend-hide-button' => 'Айсын',
	'mobile-frontend-empty-homepage-text' => 'Ацы хæдзарон фарс хъæуы саразын. <a href="https://meta.wikimedia.org/wiki/Mobile_Projects/Mobile_Gateway#Mobile_homepage"> Ацы сайты мобилон хуыз куыд хъæуы баиу кæнын, уый разамынд</a>', # Fuzzy
	'mobile-frontend-regular-site' => 'Æнæхъæнæй',
	'mobile-frontend-wml-continue' => 'Дарддæр...',
	'mobile-frontend-wml-back' => 'Фæстæмæ...',
	'mobile-frontend-view' => 'Мобилон хуыз',
	'mobile-frontend-view-desktop' => 'Æнæхъæн',
	'mobile-frontend-view-mobile' => 'Мобилон',
	'mobile-frontend-opt-in-explain' => 'Мобилон бетамæ иу гæнгæйæ, ды эксперименталон функцитæм бавналæн исыс, фæлæтас у исты баг кæнæ рæдыдыл фембæлын.',
	'mobile-frontend-images-status' => 'Нывтæ',
	'mobile-frontend-disable-images' => 'Ахицæн кæнын нывтæ мобилон сайты',
	'mobile-frontend-enable-images' => 'Баиу кæнын нывтæ мобилон сайты',
	'mobile-frontend-missing-image' => 'Ныв',
	'mobile-frontend-off' => 'ХИЦӔН',
	'mobile-frontend-on' => 'ИУ',
	'mobile-frontend-footer-contributors-text' => 'Уац сарæзтой дæ хуызæн <a href="$1">архайджытæ</a>', # Fuzzy
	'mobile-frontend-featured-article' => 'Боны сæрмагонд статья',
	'mobile-frontend-news-items' => 'Нæуæг хабæртты',
	'mobile-frontend-leave-feedback-notice' => 'Дæ хъуыды махæн æххуыс кæны дæ мобилон архайд фæхуыздæр кæнын. Уый уагъд алкæмæн æвдыст æрцæудзæн (дæ фæсномыг, сгарæны фæлтæр æмæ операцион ситемæимæ) ацы фарсмæ: &quot;$1&quot;. Дæ хорзæхæй, равзар мидисджын темæйы рæнхъ. Зæгъæм, "Фæтæн таблицæты формат кæныны рæдыдтытæ". Дæ загъд хъуыды хауы нæ архайыны домæнтæм.',
	'mobile-frontend-leave-feedback-warning' => 'Цалынмæ ма сразы уай дæ информаци алкæмæн равдисын, уæдмæ, дæ хорзæхæй, дæ фиппаинæгты персоналон информаци ма бавæр.',
	'mobile-frontend-leave-feedback-subject' => 'Темæ:',
	'mobile-frontend-leave-feedback-message' => 'Фыстæг:',
	'mobile-frontend-leave-feedback-submit' => 'Зæгъын хъуыды',
	'mobile-frontend-leave-feedback-link-text' => 'Мобилон интерфейсы тыххæй хъуыдытæ',
	'mobile-frontend-leave-feedback' => 'Мобилон сайты хъуыдызæгъæн',
	'mobile-frontend-leave-feedback-title' => 'Мобилон сайты хъуыдызæгъæн',
	'mobile-frontend-leave-feedback-technical-problem-section-header' => 'Техникон проблемæ',
	'mobile-frontend-leave-feedback-general-section-header' => 'Сæйраг',
	'mobile-frontend-leave-feedback-article-feedback-section-header' => 'Уацы тыххæй хъуыдызæгъæн',
	'mobile-frontend-language' => 'Æвзаг:',
	'mobile-frontend-username' => 'Архайæджы ном:',
	'mobile-frontend-password' => 'Пароль:',
	'mobile-frontend-login' => 'Бахизын',
	'mobile-frontend-placeholder' => '{{grammar:genitive|{{SITENAME}}}} агурын',
	'mobile-frontend-clear-search' => 'Схафын',
	'mobile-frontend-about-link-text' => 'Афыст',
	'mobile-frontend-footer-sitename' => '{{SITENAME}}',
	'mobile-frontend-footer-contact' => 'Контакт',
);

/** Punjabi (ਪੰਜਾਬੀ)
 */
$messages['pa'] = array(
	'mobile-frontend-search-submit' => 'ਜਾਓ',
	'mobile-frontend-home-button' => 'ਘਰ',
	'mobile-frontend-back-to-top-of-section' => 'A ਸ਼ੈਕਸ਼ਨ ਉੱਤੇ ਵਾਪਸ ਜਾਉ',
	'mobile-frontend-show-button' => 'ਵੇਖਾਓ',
	'mobile-frontend-hide-button' => 'ਓਹਲੇ',
	'mobile-frontend-regular-site' => 'ਇਹ ਸਫ਼ਾ ਪੂਰੇ ਵਿਕਿਪੀਡਿਆ ਉੱਤੇ ਵੇਖੋ', # Fuzzy
	'mobile-frontend-featured-article' => 'ਅੱਜ ਦੇ ਖਾਸ ਲੇਖ',
);

/** Papiamento (Papiamentu)
 */
$messages['pap'] = array(
	'mobile-frontend-search-submit' => 'Buska',
	'mobile-frontend-home-button' => 'Página Prinsipal',
	'mobile-frontend-random-button' => 'Kualkier',
	'mobile-frontend-back-to-top-of-section' => 'Bai un sekshon patras',
	'mobile-frontend-show-button' => 'Mustra',
	'mobile-frontend-hide-button' => 'Skonde',
	'mobile-frontend-regular-site' => 'Mira e página aki riba un base regular', # Fuzzy
	'mobile-frontend-featured-article' => 'E Artíkulo Estelar Di Awe',
);

/** Deitsch (Deitsch)
 * @author Xqt
 */
$messages['pdc'] = array(
	'mobile-frontend-search-submit' => 'Geh los',
	'mobile-frontend-home-button' => 'Schtaert',
	'mobile-frontend-show-button' => 'Zeig',
	'mobile-frontend-leave-feedback-message' => 'Melding', # Fuzzy
	'mobile-frontend-language' => 'Schprooch', # Fuzzy
);

/** Pälzisch (Pälzisch)
 * @author Manuae
 */
$messages['pfl'] = array(
	'mobile-frontend-show-button' => 'Zaische',
	'mobile-frontend-hide-button' => 'Vaschdegle',
	'mobile-frontend-wml-continue' => 'Waida...',
	'mobile-frontend-wml-back' => 'Zurigg...',
	'mobile-frontend-leave-feedback-message' => 'Nochrischd:',
	'mobile-frontend-language' => 'Schbrooch', # Fuzzy
	'mobile-frontend-about-link-text' => 'Iwa',
);

/** Polish (polski)
 * @author BeginaFelicysym
 * @author Derbeth
 * @author Lazowik
 * @author Leinad
 * @author Matma Rex
 * @author Mikołka
 * @author Odder
 * @author Odie2
 * @author Olgak85
 * @author P0358
 * @author Przemub
 * @author Rezonansowy
 * @author Rzuwig
 * @author Sp5uhe
 * @author WTM
 * @author Woytecr
 */
$messages['pl'] = array(
	'mobile-frontend-desc' => 'Mobilny interfejs użytkownika',
	'mobile-frontend-search-submit' => 'Przejdź',
	'mobile-frontend-home-button' => 'Główna',
	'mobile-frontend-logged-out' => 'Nie jesteś zalogowany',
	'mobile-frontend-logged-in-homepage-notification' => 'Witaj, $1!',
	'mobile-frontend-logged-in-toast-notification' => 'Zalogowano jako $1.',
	'mobile-frontend-sign-up-heading' => 'Zarejestruj się',
	'mobile-frontend-sign-in-heading' => 'Zaloguj się',
	'mobile-frontend-sign-in-error-heading' => 'Ups',
	'mobile-frontend-settings-description' => 'Dostosuj ustawienia dla urządzeń mobilnych.',
	'mobile-frontend-settings-beta' => 'Beta',
	'mobile-frontend-save-settings' => 'Zapisz ustawienia',
	'mobile-frontend-random-button' => 'Losuj',
	'mobile-frontend-ajax-random-question' => 'Przeglądnąć tą stronę?',
	'mobile-frontend-ajax-random-yes' => 'Tak',
	'mobile-frontend-ajax-random-retry' => 'Spróbuj ponownie',
	'mobile-frontend-ajax-random-suggestions' => 'Inne sugestie:',
	'mobile-frontend-back-to-top-of-section' => 'Wróć do wcześniejszej sekcji',
	'mobile-frontend-close-section' => 'Zamknij tę sekcję',
	'mobile-frontend-show-button' => 'Pokaż',
	'mobile-frontend-hide-button' => 'Ukryj',
	'mobile-frontend-empty-homepage-text' => 'Ta strona wymaga skonfigurowania. [http://meta.wikimedia.org/wiki/Mobile_Projects/Mobile_Gateway#Mobile_homepage Przeczytaj więcej, jak odblokować tę stronę]',
	'mobile-frontend-regular-site' => 'Wersja dla urządzeń stacjonarnych',
	'mobile-frontend-wml-continue' => 'Dalej ...',
	'mobile-frontend-wml-back' => 'Wstecz ...',
	'mobile-frontend-view' => 'Wersja dla urządzeń mobilnych',
	'mobile-frontend-view-desktop' => 'Standardowa',
	'mobile-frontend-view-mobile' => 'Mobilna',
	'mobile-frontend-opt-in-explain' => 'Przyłączając się do wersji beta otrzymasz dostęp do eksperymentalnych funkcji, mogących wywołać błędy i problemy.',
	'mobile-frontend-images-status' => 'Obrazki',
	'mobile-frontend-disable-images' => 'Wyłącz wyświetlanie grafik w wersji mobilnej',
	'mobile-frontend-enable-images' => 'Włącz wyświetlanie grafik w wersji mobilnej',
	'mobile-frontend-missing-image' => 'Grafika',
	'mobile-frontend-off' => 'wyłączone',
	'mobile-frontend-on' => 'włączone',
	'mobile-frontend-footer-contributors-text' => 'Artykuł został napisany przez [$1 autorów] takich jak Ty',
	'mobile-frontend-featured-article' => 'Artykuł na medal',
	'mobile-frontend-news-items' => 'Aktualności',
	'mobile-frontend-leave-feedback-notice' => 'Twoja opinia pomoże poprawić mobilną witrynę. Opinia zostanie opublikowana na stronie „$1“ (wraz z nazwą użytkownika, wersją przeglądarki i systemem operacyjnym). Spróbuj wybrać najbardziej pasujący tytuł, np „Problem z formatowaniem szerokich tabel“. Twoja opinia będzie przetwarzana zgodnie z warunkami użytkowania witryny.',
	'mobile-frontend-leave-feedback-warning' => 'Nie podawaj informacji osobistych w komentarzach, chyba że wyrażasz zgodę na upublicznienie ich.',
	'mobile-frontend-leave-feedback-subject' => 'Temat:',
	'mobile-frontend-leave-feedback-message' => 'Wiadomość:',
	'mobile-frontend-leave-feedback-submit' => 'Prześlij opinię',
	'mobile-frontend-leave-feedback-link-text' => 'Opinia na temat mobilnego interfejsu użytkownika',
	'mobile-frontend-leave-feedback' => 'Prześlij opinię',
	'mobile-frontend-leave-feedback-title' => 'Ocena witryny mobilnej',
	'mobile-frontend-leave-feedback-technical-problem-section-header' => 'Problem techniczny',
	'mobile-frontend-leave-feedback-general-section-header' => 'Ogólne',
	'mobile-frontend-leave-feedback-article-feedback-section-header' => 'Uwagi do artykułu',
	'mobile-frontend-leave-feedback-email-body' => 'Opisz problem napotkany na {{GRAMMAR:MS.lp|{{SITENAME}}}} nad tą linią. Zaznaczamy, że nie możemy odpowiedzieć na wszystkie otrzymane wiadomości.',
	'mobile-frontend-leave-feedback-technical-link-text' => 'Problem techniczny',
	'mobile-frontend-leave-feedback-general-link-text' => 'Ogólne opinie',
	'mobile-frontend-leave-feedback-article-personal-link-text' => 'Dotyczące mnie, osoby lub firmy którą reprezentuję',
	'mobile-frontend-leave-feedback-article-factual-link-text' => 'Dotyczące błędu rzeczowego',
	'mobile-frontend-leave-feedback-article-other-link-text' => 'Dotyczące innego problemu',
	'mobile-frontend-leave-feedback-form-subject-placeholder' => 'Temat wiadomości',
	'mobile-frontend-leave-feedback-form-message-placeholder' => 'Wpisz swój komentarz tutaj',
	'mobile-frontend-leave-feedback-page-title' => 'Opinia witryny mobilnej',
	'mobile-frontend-leave-feedback-special-title' => 'Skontaktuj się z nami',
	'mobile-frontend-feedback-no-subject' => '(brak tematu)',
	'mobile-frontend-feedback-no-subject-field' => 'Wpisz temat',
	'mobile-frontend-feedback-no-message' => 'Wprowadź tutaj wiadomość',
	'mobile-frontend-feedback-edit-summary' => '$1 - opublikowano automatycznie przy użyciu [[Special:MobileFeedback|mobilnego narzędzia przesyłania komentarzy]]',
	'mobile-frontend-leave-feedback-thanks' => 'Dziękujemy za przesłaną opinię!',
	'mobile-frontend-leave-feedback-post-error' => 'Wystąpił błąd podczas przetwarzania Twojej wiadomości. Spróbuj później.',
	'mobile-frontend-language' => 'Język:',
	'mobile-frontend-language-article-heading' => 'Przeczytaj w innym języku',
	'mobile-frontend-language-header' => 'Ta strona jest dostępna w $1 {{PLURAL:$1|języku|językach}}',
	'mobile-frontend-language-variant-header' => 'Wybierz wariant języka {{#language:{{CONTENTLANG}}}}',
	'mobile-frontend-language-footer' => 'Uwaga: Ta strona nie może zostać napisana w wybranym języku. Możesz zobaczyć, które języki są obługiwane przez stronę {{SITENAME}} klikając tutaj.',
	'mobile-frontend-language-site-choose' => 'Szukaj język',
	'mobile-frontend-username' => 'Nazwa użytkownika:',
	'mobile-frontend-password' => 'Hasło:',
	'mobile-frontend-username-placeholder' => 'Nazwa użytkownika',
	'mobile-frontend-password-placeholder' => 'Hasło',
	'mobile-frontend-login' => 'Zaloguj się',
	'mobile-frontend-last-modified-date' => 'Ostatnio zmodyfikowano $2, $1',
	'mobile-frontend-last-modified-seconds' => 'Ostatnio zmodyfikowano {{PLURAL:$1|sekundę|$1 sekundy|$1 sekund}} temu',
	'mobile-frontend-last-modified-minutes' => 'Ostatnio zmodyfikowano {{PLURAL:$1|minutę|$1 minuty|$1 minut}} temu',
	'mobile-frontend-last-modified-hours' => 'Ostatnio zmodyfikowano {{PLURAL:$1|godzinę|$1 godziny|$1 godzin}} temu',
	'mobile-frontend-last-modified-days' => 'Ostatnio zmodyfikowano {{PLURAL:$1|dzień|$1 dni}} temu',
	'mobile-frontend-last-modified-months' => 'Ostatnio zmodyfikowano {{PLURAL:$1|miesiąc|$1 miesiące|$1 miesięcy}} temu',
	'mobile-frontend-last-modified-years' => 'Ostatnio zmodyfikowano {{PLURAL:$1|rok|$1 lata|$1 lat}} temu',
	'mobile-frontend-account-create-submit' => 'Zarejestruj się',
	'mobile-frontend-password-confirm-placeholder' => 'Potwierdź hasło',
	'mobile-frontend-account-create-email-placeholder' => 'Adres e-mail (opcjonalnie)',
	'mobile-frontend-overlay-escape' => 'Wróć',
	'mobile-frontend-placeholder' => '{{SITENAME}} - Znajdź',
	'mobile-frontend-search-help' => 'Wpisz poszukiwaną frazę powyżej, pasujące tytuły stron pojawią się tutaj.',
	'mobile-frontend-dismiss-notification' => 'odrzuć to powiadomienie',
	'mobile-frontend-clear-search' => 'Wyczyść',
	'mobile-frontend-privacy-link-text' => 'Polityka prywatności',
	'mobile-frontend-about-link-text' => 'O nas',
	'mobile-frontend-footer-sitename' => '{{SITENAME}}',
	'mobile-frontend-footer-license-text' => 'Treść udostępniona na licencji [//en.m.wikipedia.org/wiki/Wikipedia:Text_of_Creative_Commons_Attribution-ShareAlike_3.0_Unported_License?useformat=mobile&uselang=pl CC BY-SA 3.0]',
	'mobile-frontend-terms-use-text' => '[//wikimediafoundation.org/wiki/Terms_of_Use/pl?useformat=mobile&uselang=pl Warunki użytkowania]',
	'mobile-frontend-footer-contact' => 'Kontakt',
	'mobile-frontend-search-noresults' => 'Żaden tytuł strony nie pasuje do Twojego wyszukiwania. Zmień je lub wciśnij przycisk wyszukiwania aby szukać na stronach.',
	'mobile-frontend-main-menu-button-tooltip' => 'Otwórz menu główne',
	'mobile-frontend-main-menu-page-title' => 'Nawigacja',
	'mobile-frontend-main-menu-featured' => 'Wyróżnione',
	'mobile-frontend-main-menu-nearby' => 'W pobliżu',
	'mobile-frontend-main-menu-login' => 'Zaloguj się',
	'mobile-frontend-main-menu-logout' => 'Wyloguj',
	'mobile-frontend-main-menu-watchlist' => 'Lista obserwowanych',
	'mobile-frontend-main-menu-settings' => 'Ustawienia',
	'mobile-frontend-main-menu-settings-heading' => 'Ustawienia witryny dla telefonów komórkowych',
	'mobile-frontend-settings-site-header' => 'Języki {{GRAMMAR:D.lp|{{SITENAME}}}}',
	'mobile-frontend-settings-site-description' => 'Projekt {{SITENAME}} jest dostępny w $1 {{PLURAL:$1|języku|językach}}. Wszystkie dostępne wersje są wymienione poniżej.',
	'mobile-frontend-main-menu-contact' => 'Kontakt',
	'mobile-frontend-main-menu-account-create' => 'Załóż nowe konto',
	'mobile-frontend-page-menu-contents' => 'spis treści',
	'mobile-frontend-page-menu-history' => 'Historia',
	'mobile-frontend-meta-data-issues-header' => 'Problemy',
	'mobile-frontend-meta-data-issues' => 'Ta strona ma pewne problemy',
	'mobile-frontend-ajax-page-loading' => 'Ładowanie: $1...',
	'mobile-frontend-page-saving' => 'Zapisywanie: $1...',
	'mobile-frontend-ajax-page-error' => 'Ups! Coś poszło nie tak. Spróbuj odświeżyć stronę.',
	'mobile-frontend-nearby-title' => 'W pobliżu',
	'mobile-frontend-donate-image-heading' => 'Niedawny wkład',
	'mobile-frontend-watchlist-add' => 'Dodano „$1” do twojej listy obserwowanych',
	'mobile-frontend-watchlist-removed' => 'Usunięto „$1” z twojej listy obserwowanych',
	'mobile-frontend-watchlist-view' => 'Zobacz swoją listę obserwowanych',
	'mobile-frontend-watchlist-more' => 'więcej',
	'mobile-frontend-watchlist-cta' => 'Zaloguj się lub zarejestruj aby zobaczyć tę stronę.',
	'mobile-frontend-watchlist-cta-button-login' => 'Zaloguj się',
	'mobile-frontend-watchlist-cta-button-signup' => 'Zarejestruj się',
	'mobile-frontend-watchlist-a-z' => 'Wszystkie',
	'mobile-frontend-watchlist-feed' => 'Zmienione',
	'mobile-frontend-changeslist-ip' => 'Anonim',
	'mobile-frontend-changeslist-nocomment' => 'brak opisu edycji',
	'mobile-frontend-watchlist-filter-all' => 'Wszystko',
	'mobile-frontend-watchlist-filter-articles' => 'Artykuły',
	'mobile-frontend-watchlist-filter-talk' => 'Dyskusja',
	'mobile-frontend-watchlist-filter-other' => 'Inne',
	'mobile-frontend-diffview-title' => 'Zmiany',
	'mobile-frontend-diffview-editcount' => '$1 {{PLURAL:$1|edycja|edycje}}',
	'mobile-frontend-diffview-anonymous' => 'Anonim',
	'mobile-frontend-diffview-bytesadded' => '$1 {{PLURAL:$1|bajty|bajtów}} dodano',
	'mobile-frontend-diffview-bytesremoved' => '$1 {{PLURAL:$1|bajty|bajtów}} zostało usunięte',
	'mobile-frontend-table' => 'Tabela $1',
	'mobile-frontend-photo-upload' => 'Dodaj pierwsze zdjęcie do tej strony', # Fuzzy
	'mobile-frontend-photo-article-edit-comment' => 'Dodane zdjęcia do wykorzystania na stronie',
	'mobile-frontend-photo-upload-comment' => 'Dodano nowe zdjęcie na stronie',
	'mobile-frontend-photo-caption-placeholder' => 'Dodaj podpis do tej grafiki', # Fuzzy
	'mobile-frontend-image-loading' => 'Ładowanie grafiki...',
	'mobile-frontend-image-uploading-wait' => 'Przesyłanie grafiki...', # Fuzzy
	'mobile-frontend-photo-upload-error' => 'Wystąpił błąd podczas przesyłania obrazu. Spróbuj z innym obrazem.', # Fuzzy
	'mobile-frontend-photo-license' => 'Uwaga: Wszystkie zdjęcia, które publikujesz zostaną opublikowane na zasadach licencji [//en.wikipedia.org/wiki/Wikipedia:Text_of_Creative_Commons_Attribution-ShareAlike_3.0_Unported_License CC BY-SA 3.0]', # Fuzzy
	'tag-mobile_edit' => 'z urządzenia mobilnego',
	'tag-mobile_edit-description' => 'Edycja dokonana z urządzenia mobilnego',
	'mobile-frontend-drawer-cancel' => 'Anuluj',
);

/** Piedmontese (Piemontèis)
 * @author Borichèt
 * @author Dragonòt
 * @author පසිඳු කාවින්ද
 */
$messages['pms'] = array(
	'mobile-frontend-desc' => 'Visualisassion an sël sacociàbil',
	'mobile-frontend-search-submit' => 'Va',
	'mobile-frontend-home-button' => 'Pàgina Prinsipal',
	'mobile-frontend-logged-out' => 'Nen rintrà ant ël sistema',
	'mobile-frontend-logged-in-homepage-notification' => 'Bin ëvnù, $1!',
	'mobile-frontend-logged-in-toast-notification' => 'Intrà ant ël sistema com $1.',
	'mobile-frontend-sign-up-heading' => "Ch'as anscriva",
	'mobile-frontend-sign-in-heading' => 'Rintré ant ël sistema',
	'mobile-frontend-sign-in-why' => "S'a l'ha un cont su {{SITENAME}}, a peul intré ant ël sistema sì-sota.",
	'mobile-frontend-sign-in-error-heading' => 'Contacc',
	'mobile-frontend-settings-description' => "Ch'a përsonalisa soa esperiensa dzora a sò utiss sacociàbil con coste regolassion spessìfiche dël sit pr'ij sacociàbij.",
	'mobile-frontend-settings-beta' => 'Beta',
	'mobile-frontend-settings-alpha' => 'Manera [//en.wikipedia.org/wiki/Here_be_dragons Ambelessì a-i son ij dragon]',
	'mobile-frontend-settings-alpha-description' => "Ch'a intra ant un teritòri mòbil pericolos e nen esplorà. Ch'a oten-a ëdcò dle funsion pi sperimentaj ma con pi 'd pericol ëd bigat.",
	'mobile-frontend-save-settings' => 'Salvé le regolassion',
	'mobile-frontend-random-button' => 'A cas',
	'mobile-frontend-ajax-random-heading' => 'Localisé la conossensa...',
	'mobile-frontend-ajax-random-quote' => 'La chërsùa anteletual a dovrìa ancaminé a la nàssita e finì mach a la mòrt',
	'mobile-frontend-ajax-random-question' => 'Lesù sta pàgina?',
	'mobile-frontend-ajax-random-yes' => 'É!',
	'mobile-frontend-ajax-random-retry' => 'Preuva torna',
	'mobile-frontend-ajax-random-suggestions' => "D'àutri sugeriment:",
	'mobile-frontend-back-to-top-of-section' => 'Sàuta andré ëd na Session',
	'mobile-frontend-close-section' => 'Sara sta session-sì',
	'mobile-frontend-show-button' => 'Mosta',
	'mobile-frontend-hide-button' => 'Stërma',
	'mobile-frontend-empty-homepage-text' => "Costa pàgina d'intrada a dev esse configurà. <a [//meta.wikimedia.org/wiki/Mobile_Projects/Mobile_Gateway#Mobile_homepage Istrussion ëd com abilité ës sit për ij sacociàbij]",
	'mobile-frontend-regular-site' => 'Visualisassion da ordinator',
	'mobile-frontend-wml-continue' => 'Andé anans ...',
	'mobile-frontend-wml-back' => 'André ...',
	'mobile-frontend-view' => 'Visualisassion an sël sacociàbil',
	'mobile-frontend-view-desktop' => 'Tàula',
	'mobile-frontend-view-mobile' => 'Sacociàbil',
	'mobile-frontend-opt-in-explain' => "Partissipand a le preuve beta, a l'avrà drit a le funsion sperimentaj, con l'arzigh d'ancontré eror e problema.",
	'mobile-frontend-images-status' => 'Figure',
	'mobile-frontend-disable-images' => "Disabilité le figure an sël sit pr'ij sacociàbij",
	'mobile-frontend-enable-images' => "Abilité le figure an sël sit pr'ij sacociàbij",
	'mobile-frontend-missing-image' => 'Figura',
	'mobile-frontend-off' => 'Dëstiss',
	'mobile-frontend-on' => 'Anvisch',
	'mobile-frontend-footer-contributors-text' => 'Pàgina da [$1 contributor] com chiel',
	'mobile-frontend-featured-article' => 'Artìcol dël dì',
	'mobile-frontend-news-items' => 'Ant le Neuve',
	'mobile-frontend-leave-feedback-notice' => "Soa opinion an giuta a amelioré soa esperiensa dël sit për ij sacociàbij. A sarà publicà (ansema a sò stranòm, la version ëd sò navigador e sò sistema operativ) a la pàgina «$1». Për piasì ch'a preuva a buté un resumé anformativ, për esempi «Problema ëd formatassion con le tàule gròsse». Soa opinion a resta sota nòstre condission d'utilisassion.",
	'mobile-frontend-leave-feedback-warning' => "Gavà ch'a sia d'acòrdi d'avèj soe anformassion smonùe ëd fasson pùblica, për piasì ch'a buta pa d'anformassion përsonaj ant ij sò coment.",
	'mobile-frontend-leave-feedback-subject' => 'Soget:',
	'mobile-frontend-leave-feedback-message' => 'Mëssagi:',
	'mobile-frontend-leave-feedback-submit' => 'Spedì ij coment',
	'mobile-frontend-leave-feedback-link-text' => "Opinion an sla visualisassion pr'ij sacociàbij",
	'mobile-frontend-leave-feedback' => "Lassé n'opinion",
	'mobile-frontend-leave-feedback-title' => 'Dene soa opinion a propòsit ëd soa esperiensa dël sit për ij sacociàbij',
	'mobile-frontend-leave-feedback-technical-problem-section-header' => 'Problema técnich',
	'mobile-frontend-leave-feedback-general-section-header' => 'General',
	'mobile-frontend-leave-feedback-article-feedback-section-header' => "Valutassion ëd j'artìcoj",
	'mobile-frontend-leave-feedback-email-body' => "Për piasì ch'a dëscriva ël problema ch'a l'ha trovà con {{SITENAME}} dzora a sta linia. Për piasì ch'a nòta che i podoma pa rësponde a tuti ij mëssagi che i arseivoma.",
	'mobile-frontend-leave-feedback-technical-link-text' => 'Problema técnich',
	'mobile-frontend-leave-feedback-general-link-text' => 'Opinion general',
	'mobile-frontend-leave-feedback-article-personal-link-text' => "Quant a mi, na përson-a o n'asienda che mi i rapresento",
	'mobile-frontend-leave-feedback-article-factual-link-text' => "Për lòn ch'a rësguarda n'eror ëd fàit",
	'mobile-frontend-leave-feedback-article-other-link-text' => "Për lòn ch'a toca n'àutr problema",
	'mobile-frontend-leave-feedback-form-subject-placeholder' => 'Soget dël mëssagi',
	'mobile-frontend-leave-feedback-form-message-placeholder' => 'Scriv tò coment ambelessì',
	'mobile-frontend-leave-feedback-page-title' => 'Opinion a propòsit dël sit për ij sacociàbij',
	'mobile-frontend-leave-feedback-special-title' => 'Contatne',
	'mobile-frontend-feedback-no-subject' => '(pa gnun soget)',
	'mobile-frontend-feedback-no-subject-field' => "Për piasì ch'a buta un soget",
	'mobile-frontend-feedback-no-message' => "Për piasì ch'a buta un mëssagi ambelessì",
	'mobile-frontend-feedback-edit-summary' => "$1 - spedì automaticament an dovrand l'[[Special:MobileFeedback|utiss dij coment për ij sacociàbij]]",
	'mobile-frontend-leave-feedback-thanks' => 'Mersì, për toa opinion!',
	'mobile-frontend-leave-feedback-post-error' => "A-i é staie n'eror ëd tratament ëd sò mëssagi. Për piasì, ch'a preuva torna pì tard.",
	'mobile-frontend-language' => 'Lenga:',
	'mobile-frontend-language-article-heading' => "Les an n'àutra lenga",
	'mobile-frontend-language-header' => "Costa pàgina a l'é disponìbil an $1 {{PLURAL:$1|lenga|lenghe}}",
	'mobile-frontend-language-variant-header' => "Ch'a serna la variant {{#language:{{CONTENTLANG}}}}",
	'mobile-frontend-language-footer' => 'Nòta: Costa pàgina a peul nen esse scrivùa an soa lenga preferìa. A peule vëdde che lenge {{SITENAME}} a manten an ësgnacand ambelessì.',
	'mobile-frontend-language-site-choose' => 'Sërché la lenga',
	'mobile-frontend-username' => 'Stranòm:',
	'mobile-frontend-password' => 'Ciav:',
	'mobile-frontend-username-placeholder' => 'Stranòm',
	'mobile-frontend-password-placeholder' => 'Ciav',
	'mobile-frontend-login' => 'Intra',
	'mobile-frontend-last-modified-date' => 'Ultima modìfica ai $1, a $2',
	'mobile-frontend-last-modified-seconds' => 'Ultima modìfica {{PLURAL:$1|$1 second}} fà',
	'mobile-frontend-last-modified-minutes' => 'Ultima modìfica {{PLURAL:$1|$1 minuta|$1 minute}} fà',
	'mobile-frontend-last-modified-hours' => 'Ultima modìfica {{PLURAL:$1|$1 ora|$1 ore}} fà',
	'mobile-frontend-last-modified-days' => 'Ultima modìfica {{PLURAL:$1|$1 di}} fà',
	'mobile-frontend-last-modified-months' => 'Ultima modìfica {{PLURAL:$1|$1 mèis}} fà',
	'mobile-frontend-last-modified-years' => 'Ultima modìfica {{PLURAL:$1|$1 ann|$1 agn}} fà',
	'mobile-frontend-account-create-submit' => "Ch'as anscriva",
	'mobile-frontend-password-confirm-placeholder' => "Ch'a confirma la ciav",
	'mobile-frontend-account-create-email-placeholder' => 'Adrëssa ëd pòsta eletrònica (opsional)',
	'mobile-frontend-account-create-captcha-placeholder' => 'Anseriss ël test ëd sicurëssa',
	'mobile-frontend-overlay-escape' => 'Torna andré',
	'mobile-frontend-placeholder' => 'Sërca an {{SITENAME}}',
	'mobile-frontend-placeholder-beta' => 'Serca {{SITENAME}} (Beta)',
	'mobile-frontend-placeholder-alpha' => 'Arserché su {{SITENAME}} (Manera Dragon)',
	'mobile-frontend-search-help' => "Ch'a scriva le paròle d'arserca sì-dzora e ij tìtoj dle pàgine corispondente a compariran ambelessì.",
	'mobile-frontend-dismiss-notification' => 'arfuda sta notìfica',
	'mobile-frontend-clear-search' => 'Scancela',
	'mobile-frontend-privacy-link-text' => 'Confidensialità',
	'mobile-frontend-about-link-text' => 'A propòsit',
	'mobile-frontend-footer-sitename' => '{{SITENAME}}',
	'mobile-frontend-footer-license-text' => 'Contnù disponìbil sota [//en.m.wikipedia.org/wiki/Wikipedia:Text_of_Creative_Commons_Attribution-ShareAlike_3.0_Unported_License?useformat=mobile CC BY-SA 3.0]',
	'mobile-frontend-terms-use-text' => "[//wikimediafoundation.org/wiki/Terms_of_use?useformat=mobile Termo d'Usagi]",
	'mobile-frontend-footer-contact' => 'Contat',
	'mobile-frontend-search-noresults' => "A-i é gnun-a pàgina ch'a corëspond a soa arserca. Ch'a modìfica soa arserca, o ch'a gnaca ël boton d'arserca dla tastadura për serché andrinta a le pàgine.",
	'mobile-frontend-main-menu-button-tooltip' => 'Duverté lë mnù prinsipal',
	'mobile-frontend-main-menu-page-title' => 'Navigassion dël sit',
	'mobile-frontend-main-menu-featured' => 'Premià',
	'mobile-frontend-main-menu-nearby' => 'Vzin',
	'mobile-frontend-main-menu-login' => 'Intra',
	'mobile-frontend-main-menu-logout' => 'Seurte dal sistema',
	'mobile-frontend-main-menu-watchlist' => 'Ròba che as ten sot euj',
	'mobile-frontend-main-menu-settings' => 'Regolassion',
	'mobile-frontend-main-menu-settings-heading' => 'Regolassion dël sit për ij sacociàbij',
	'mobile-frontend-settings-site-header' => 'Lenghe ëd {{SITENAME}}',
	'mobile-frontend-settings-site-description' => "{{SITENAME}} a l'é disponìbil an $1 {{PLURAL:$1|lenga|lenghe}}. Tute le version disponìbij a son listà sì-sota",
	'mobile-frontend-main-menu-contact' => 'Contat',
	'mobile-frontend-main-menu-account-create' => 'Creé un cont',
	'mobile-frontend-page-menu-contents' => 'contnù',
	'mobile-frontend-page-menu-history' => 'Stòria',
	'mobile-frontend-meta-data-issues-header' => 'Problema',
	'mobile-frontend-meta-data-issues' => "Costa pàgina a l'ha chèich problema",
	'mobile-frontend-ajax-page-loading' => 'Carié $1',
	'mobile-frontend-page-saving' => 'Salvé $1',
	'mobile-frontend-ajax-page-error' => "Contacc! Quaicòs a l'é andàit mal ambelessì. Për piasì, ch'a preuva a rinfrësché la fnestra ëd sò navigador.",
	'mobile-frontend-photo-upload-generic' => 'Doné na figura',
	'mobile-frontend-donate-image-title' => 'Doné na figura',
	'mobile-frontend-donate-image-summary' => "Le fòto a fan vive le pàgine dzora a {{SITENAME}}.
A-i son tante pàgine che a l'han gnun-e fòto për na greva mancansa ëd fòto con licensa lìbera.
Ch'a giuta a fé vive coste pàgine donand soe figure dont a veul dësbarassesse e ch'a podrìo esse dovrà da la gròssa comunità d'editor ëd {{SITENAME}}.",
	'mobile-frontend-donate-image-heading' => 'Toe contribussion recente',
	'mobile-frontend-watchlist-add' => "Giontà $1 a la lista ëd lòn ch'as ten sot-euj",
	'mobile-frontend-watchlist-removed' => "Gavà $1 da la lista ëd lòn ch'as ten sot-euj",
	'mobile-frontend-watchlist-view' => "Vëdde la lista ëd lòn ch'as ten sot-euj",
	'mobile-frontend-watchlist-more' => 'ëd pi',
	'mobile-frontend-watchlist-cta' => "Për piasì intra o registr-te për ten-e d'euj sta pagina.",
	'mobile-frontend-watchlist-cta-button-login' => 'Intré ant ël sistema',
	'mobile-frontend-watchlist-cta-button-signup' => "Ch'as anscriva",
	'mobile-frontend-watchlist-a-z' => 'Tùit',
	'mobile-frontend-watchlist-feed' => 'Modificà',
	'mobile-frontend-watchlist-a-z-empty' => "Al moment it të stas pa tenend d'euj gnun-e pagine",
	'mobile-frontend-watchlist-feed-empty' => 'A-i son pa dle pagine con cambi recent',
	'mobile-frontend-changeslist-ip' => 'Utent anònim',
	'mobile-frontend-changeslist-nocomment' => 'gnun resumé ëd modìfica',
	'mobile-frontend-watchlist-filter-all' => 'Tùit',
	'mobile-frontend-watchlist-filter-articles' => 'Artìcoj',
	'mobile-frontend-watchlist-filter-talk' => 'Ciaciarade',
	'mobile-frontend-watchlist-filter-other' => 'Àutr',
	'mobile-frontend-watchlist-modified' => 'Modificà $1',
	'mobile-frontend-diffview-404-title' => 'Revision pa bon-a',
	'mobile-frontend-diffview-404-desc' => "L'id për la revision ch'it l'has ciamà a esist pa",
	'mobile-frontend-diffview-title' => 'Modìfiche',
	'mobile-frontend-diffview-editcount' => '$1 {{PLURAL:$1|modìfica|modìfiche}}',
	'mobile-frontend-diffview-anonymous' => 'Utent anònim',
	'mobile-frontend-diffview-bytesadded' => '$1 {{PLURAL:$1|byte|bytes}} giontà',
	'mobile-frontend-diffview-bytesremoved' => '$1 {{PLURAL:$1|byte|bytes}} gavà',
	'mobile-frontend-diffview-explained' => 'Le linie sota a son stàite giontà (+) e gavà (-):',
	'mobile-frontend-table' => 'Tàula $1',
	'mobile-frontend-saving-exit-page' => "Soa contribussion a l'é anco' da salvé. S'a chita, soe contribussion a sarà përdùe. É-lo sigur ëd vorèj seurte?",
	'mobile-frontend-photo-upload' => 'Gionté na plancia a cost artìcol',
	'mobile-frontend-photo-article-edit-comment' => 'Fòto giontà për esse dovrà an sla pàgina',
	'mobile-frontend-photo-article-donate-comment' => 'Figura donà da sacociàbil',
	'mobile-frontend-photo-upload-comment' => 'Fòto giontà a la pàgina',
	'mobile-frontend-photo-caption-placeholder' => 'Gionté na descrission (obligatòria)',
	'mobile-frontend-image-loading' => 'Cariagi ëd la figura',
	'mobile-frontend-image-uploading-wait' => 'Cariament ëd la figura, avèj passiensa.',
	'mobile-frontend-photo-upload-error' => "A l'é capitaje n'eror an cariand la figura. Për piasì preuva n'àutra figura.", # Fuzzy
	'mobile-frontend-photo-license' => "An sgnacand ansima a «Mandé», chiel a aceta nòstre [//wikimediafoundation.org/wiki/Terms_of_use condission d'utilisassion] e a l'é d'acòrd a buté a disposission soa fòto sota la [//creativecommons.org/licenses/by-sa/3.0/ licensa Creative Commons Attribution-ShareAlike 3.0].",
	'tag-mobile_edit' => 'Modìfica për sacociàbil',
	'tag-mobile_edit-description' => 'Modìfica fàita da un sit për sacociàbil',
	'mobile-frontend-drawer-cancel' => 'Scancela',
);

/** Western Punjabi (پنجابی)
 * @author Khalid Mahmood
 */
$messages['pnb'] = array(
	'mobile-frontend-desc' => 'ہلن والا وکھالہ',
	'mobile-frontend-search-submit' => 'چلو',
	'mobile-frontend-home-button' => 'کعر',
	'mobile-frontend-random-button' => 'الٹے پلٹے',
	'mobile-frontend-back-to-top-of-section' => 'اک سیکشن پچھے چلو',
	'mobile-frontend-show-button' => 'وکھاؤ',
	'mobile-frontend-hide-button' => 'لکاؤ',
	'mobile-frontend-regular-site' => 'ایس صفے نوں ریگولر {{ساغیٹناں}} تے ویکھو', # Fuzzy
	'mobile-frontend-wml-continue' => 'جاری رکھو',
	'mobile-frontend-wml-back' => 'پچھے نوں۔۔۔۔۔۔۔۔۔۔۔',
	'mobile-frontend-view' => 'ٹردی مورت',
	'mobile-frontend-opt-in-explain' => 'بیٹا پسند کرن نال تسیں اج کم ہوندیاں تھانواں تے آؤگے جتھے مسلے تے بگز ہوسکدے نیں۔',
	'mobile-frontend-disable-images' => 'موبائل آلی ویب سائٹ تے فوٹواں بند کرو',
	'mobile-frontend-enable-images' => 'موبائل آلی ویب سائٹ تے فوٹواں آن کرو',
	'mobile-frontend-featured-article' => 'اج دا چونواں آرٹیکل',
	'mobile-frontend-news-items' => 'دساں چ',
	'mobile-frontend-leave-feedback-notice' => 'تواڈا فیڈبیک ساڈی مدد کردا تواڈی موبائیل سائٹ ایکسپیرینس نوں ودیا کرن چ۔
ایہ عام لوکاں ل‏ی سامنے رکھیا جاۓ گا (تواڈے ناں ، براؤزر ورین تے اوپریٹنگ سسٹم) صفہ &quot;$1&quot تے۔ مہربانی کرکے اک جانکاری لین لکھو کسے ٹاپک تے۔ تواڈا فیڈبیک ای ساڈے ورتن دی شرط اے۔',
	'mobile-frontend-leave-feedback-subject' => 'آرٹیکل', # Fuzzy
	'mobile-frontend-leave-feedback-message' => 'سنیعہ', # Fuzzy
	'mobile-frontend-leave-feedback-submit' => 'مشورہ دیو',
	'mobile-frontend-leave-feedback-link-text' => 'موبائل توں آئی ایکسٹنشن صلاع',
	'mobile-frontend-leave-feedback' => 'موبائل تھاں صلاع',
	'mobile-frontend-leave-feedback-title' => 'سانوں فیڈبیک دیو اپنے موبائل سائیٹ تجربے بارے۔',
	'mobile-frontend-leave-feedback-page-title' => 'سانوں فیڈبیک دیو اپنے موبائل سائیٹ تجربے بارے۔',
	'mobile-frontend-leave-feedback-thanks' => 'تواڈی صلاع دا شکریہ',
	'mobile-frontend-language' => 'بولی', # Fuzzy
	'mobile-frontend-username' => 'ورتن والہ:',
	'mobile-frontend-password' => 'کنجی:',
	'mobile-frontend-login' => 'لاگ ان ہو جاو',
);

/** Pashto (پښتو)
 * @author Ahmed-Najib-Biabani-Ibrahimkhel
 */
$messages['ps'] = array(
	'mobile-frontend-search-submit' => 'ورځه',
	'mobile-frontend-home-button' => 'کور',
	'mobile-frontend-settings-beta' => 'بيټا',
	'mobile-frontend-save-settings' => 'امستنې خوندي کول',
	'mobile-frontend-random-button' => 'بېلابېل',
	'mobile-frontend-back-to-top-of-section' => 'د يوې برخې نه پرشا ټوپ وهل',
	'mobile-frontend-show-button' => 'ښکاره کول',
	'mobile-frontend-hide-button' => 'پټول',
	'mobile-frontend-regular-site' => 'کمپيوټر بڼه',
	'mobile-frontend-wml-continue' => 'ادامه...',
	'mobile-frontend-wml-back' => 'پر شا کېدل...',
	'mobile-frontend-view' => 'د موبايل په بڼې کتل',
	'mobile-frontend-view-mobile' => 'موبايل',
	'mobile-frontend-images-status' => 'انځورونه',
	'mobile-frontend-disable-images' => 'په موبايل وېبځي انځورونه ناچارنول',
	'mobile-frontend-enable-images' => 'په موبايل وېبځي انځورونه چارنول',
	'mobile-frontend-featured-article' => 'د نن ورځې غوره ليکنه',
	'mobile-frontend-news-items' => 'په خبرونو کې',
	'mobile-frontend-leave-feedback-subject' => 'سکالو:',
	'mobile-frontend-leave-feedback-message' => 'پيغام:',
	'mobile-frontend-leave-feedback-technical-problem-section-header' => 'تخنيکي ستونزه',
	'mobile-frontend-leave-feedback-general-section-header' => 'ټولګړی',
	'mobile-frontend-leave-feedback-technical-link-text' => 'تخنيکي ستونزه',
	'mobile-frontend-leave-feedback-special-title' => 'زموږ سره اړيکې',
	'mobile-frontend-feedback-no-message' => 'يو پيغام دلته وټاپۍ',
	'mobile-frontend-language' => 'ژبه:',
	'mobile-frontend-language-site-choose' => 'ژبه پلټل',
	'mobile-frontend-username' => 'کارن-نوم:',
	'mobile-frontend-password' => 'پټنوم:',
	'mobile-frontend-login' => 'ننوتل',
	'mobile-frontend-placeholder' => '{{SITENAME}} پلټل',
	'mobile-frontend-clear-search' => 'سپينول',
	'mobile-frontend-privacy-link-text' => 'پټنتيا',
	'mobile-frontend-about-link-text' => 'په اړه',
	'mobile-frontend-footer-contact' => 'اړيکه',
	'mobile-frontend-main-menu-settings' => 'امستنې',
	'mobile-frontend-main-menu-contact' => 'اړيکه',
	'mobile-frontend-page-menu-contents' => 'منځپانګه',
	'mobile-frontend-page-menu-history' => 'پېښليک',
);

/** Portuguese (português)
 * @author Giro720
 * @author Hamilton Abreu
 * @author João Sousa
 * @author Malafaya
 * @author MetalBrasil
 * @author SandroHc
 */
$messages['pt'] = array(
	'mobile-frontend-desc' => 'Interface para Telemóveis',
	'mobile-frontend-search-submit' => 'Prosseguir',
	'mobile-frontend-home-button' => 'Início',
	'mobile-frontend-logged-out' => 'Não autenticado',
	'mobile-frontend-settings-description' => 'Personalize o comportamento do seu dispositivo móvel com estas configurações específicas para o site móvel.',
	'mobile-frontend-settings-beta' => 'Beta',
	'mobile-frontend-save-settings' => 'Gravar configurações',
	'mobile-frontend-random-button' => 'Aleatório',
	'mobile-frontend-back-to-top-of-section' => 'Retroceder uma secção',
	'mobile-frontend-close-section' => 'Fechar esta secção',
	'mobile-frontend-show-button' => 'Mostrar',
	'mobile-frontend-hide-button' => 'Ocultar',
	'mobile-frontend-empty-homepage-text' => 'Esta página inicial deve ser configurada. <a href="http://meta.wikimedia.org/wiki/Mobile_Projects/Mobile_Gateway#Mobile_homepage">Instruções sobre como colocar este site móvel ativado</a>', # Fuzzy
	'mobile-frontend-regular-site' => 'Versão normal',
	'mobile-frontend-wml-continue' => 'Continuar ...',
	'mobile-frontend-wml-back' => 'Voltar ...',
	'mobile-frontend-view' => 'Versão móvel',
	'mobile-frontend-view-desktop' => 'Normal',
	'mobile-frontend-view-mobile' => 'Móvel',
	'mobile-frontend-opt-in-explain' => 'Ao adoptar a versão móvel beta terá acesso a funcionalidades experimentais, correndo o risco de encontrar defeitos e problemas.',
	'mobile-frontend-images-status' => 'Imagens',
	'mobile-frontend-disable-images' => 'Desativar imagens no site móvel',
	'mobile-frontend-enable-images' => 'Ativar imagens no site móvel',
	'mobile-frontend-off' => 'NÃO',
	'mobile-frontend-on' => 'SIM',
	'mobile-frontend-footer-contributors-text' => 'Artigo realizado por <a href="$1">colaboradores</a> como você', # Fuzzy
	'mobile-frontend-featured-article' => 'Artigo Destacado',
	'mobile-frontend-news-items' => 'Actualidade',
	'mobile-frontend-leave-feedback-notice' => 'Os seus comentários ajudam-nos a melhorar a versão móvel do site. Serão tornados públicos (em conjunto com o nome de utilizador, versão do browser e sistema operativo) na página &quot;$1&quot;. Tente tornar a linha do assunto informativa, por exemplo, "Problemas com a formatação de tabelas largas". Os comentários estão sujeitos às nossas condições de uso.',
	'mobile-frontend-leave-feedback-warning' => 'Se não concorda que informação sobre si seja tornada pública, não inclua informação pessoal nos seus comentários, por favor.',
	'mobile-frontend-leave-feedback-subject' => 'Assunto:',
	'mobile-frontend-leave-feedback-message' => 'Mensagem:',
	'mobile-frontend-leave-feedback-submit' => 'Enviar comentário',
	'mobile-frontend-leave-feedback-link-text' => 'Comentários sobre a Extensão Interface para Telemóveis',
	'mobile-frontend-leave-feedback' => 'Comentários sobre o site móvel',
	'mobile-frontend-leave-feedback-title' => 'Comentários sobre o site móvel',
	'mobile-frontend-leave-feedback-technical-problem-section-header' => 'Problema técnico',
	'mobile-frontend-leave-feedback-general-section-header' => 'Geral',
	'mobile-frontend-leave-feedback-article-feedback-section-header' => 'Comentários ao artigo',
	'mobile-frontend-leave-feedback-email-body' => 'Escreva a sua mensagem acima desta linha, por favor.', # Fuzzy
	'mobile-frontend-leave-feedback-technical-link-text' => 'Problema técnico',
	'mobile-frontend-leave-feedback-general-link-text' => 'Comentários gerais',
	'mobile-frontend-leave-feedback-article-personal-link-text' => 'Sobre mim, uma pessoa, ou uma empresa que represento',
	'mobile-frontend-leave-feedback-article-factual-link-text' => 'Sobre um erro material',
	'mobile-frontend-leave-feedback-article-other-link-text' => 'Sobre outro problema',
	'mobile-frontend-leave-feedback-form-subject-placeholder' => 'Assunto da mensagem',
	'mobile-frontend-leave-feedback-form-message-placeholder' => 'Insira o comentário aqui',
	'mobile-frontend-leave-feedback-page-title' => 'Comentários sobre o site móvel',
	'mobile-frontend-leave-feedback-special-title' => 'Contacte-nos',
	'mobile-frontend-feedback-no-subject' => '(sem assunto)',
	'mobile-frontend-feedback-no-subject-field' => 'Introduza um assunto, por favor',
	'mobile-frontend-feedback-no-message' => 'Introduza uma mensagem aqui, por favor',
	'mobile-frontend-feedback-edit-summary' => '$1 - publicado automaticamente usando a [[Special:MobileFeedback|ferramenta de comentários sobre a versão móvel]]',
	'mobile-frontend-leave-feedback-thanks' => 'Obrigado pelos seus comentários!',
	'mobile-frontend-leave-feedback-post-error' => 'Ocorreu um erro indeterminado ao processar a sua mensagem. Tente novamente mais tarde, por favor.',
	'mobile-frontend-language' => 'Língua:',
	'mobile-frontend-language-header' => 'Este artigo está disponível em $1 {{PLURAL:$1|língua|línguas}}', # Fuzzy
	'mobile-frontend-language-footer' => 'A {{SITENAME}} está disponível noutras línguas.', # Fuzzy
	'mobile-frontend-language-site-choose' => 'Pesquisar língua',
	'mobile-frontend-username' => 'Nome de utilizador:',
	'mobile-frontend-password' => 'Palavra-chave:',
	'mobile-frontend-login' => 'Autenticação',
	'mobile-frontend-placeholder' => 'Pesquisar a {{SITENAME}}',
	'mobile-frontend-search-help' => 'Introduza acima o termo de pesquisa e os artigos correspondentes aparecerão aqui.', # Fuzzy
	'mobile-frontend-dismiss-notification' => 'ignorar esta notificação',
	'mobile-frontend-clear-search' => 'Limpar',
	'mobile-frontend-privacy-link-text' => 'Privacidade',
	'mobile-frontend-about-link-text' => 'Sobre',
	'mobile-frontend-footer-sitename' => '{{SITENAME}}',
	'mobile-frontend-footer-contact' => 'Contacto',
	'mobile-frontend-search-noresults' => 'Nenhum dos artigos corresponde à sua pesquisa. Altere a pesquisa, ou pressione o botão de pesquisa do teclado para pesquisar dentro dos artigos.', # Fuzzy
	'mobile-frontend-main-menu-featured' => 'Destacado',
	'mobile-frontend-main-menu-nearby' => 'Perto',
	'mobile-frontend-main-menu-settings' => 'Configurações',
	'mobile-frontend-main-menu-settings-heading' => 'Configurações do site móvel',
	'mobile-frontend-settings-site-header' => 'Línguas da {{SITENAME}}',
	'mobile-frontend-settings-site-description' => 'A {{SITENAME}} está disponível em $1 {{PLURAL:$1|língua|línguas}}. Estão listadas abaixo todas as versões disponíveis',
	'mobile-frontend-main-menu-contact' => 'Contacto',
	'mobile-frontend-page-menu-contents' => 'índice',
	'mobile-frontend-page-menu-history' => 'Histórico',
);

/** Brazilian Portuguese (português do Brasil)
 * @author Giro720
 * @author MetalBrasil
 * @author Rafael Vargas
 * @author 555
 */
$messages['pt-br'] = array(
	'mobile-frontend-desc' => 'Interface para dispositivos móveis',
	'mobile-frontend-search-submit' => 'Ir',
	'mobile-frontend-home-button' => 'Início',
	'mobile-frontend-random-button' => 'Aleatório',
	'mobile-frontend-back-to-top-of-section' => 'Retroceder Uma Seção',
	'mobile-frontend-show-button' => 'Mostrar',
	'mobile-frontend-hide-button' => 'Esconder',
	'mobile-frontend-regular-site' => 'Visualização normal',
	'mobile-frontend-wml-continue' => 'continuar ...',
	'mobile-frontend-wml-back' => 'Voltar ...',
	'mobile-frontend-view' => 'Versão para dispositivo móvel',
	'mobile-frontend-opt-in-explain' => 'Ao participar dos testes, você terá acesso a recursos experimentais, correndo o risco de encontrar erros e problemas.',
	'mobile-frontend-disable-images' => 'Desativar imagens no site móvel',
	'mobile-frontend-enable-images' => 'Ativar imagens no site móvel',
	'mobile-frontend-featured-article' => 'Artigo em destaque',
	'mobile-frontend-news-items' => 'Eventos recentes',
	'mobile-frontend-leave-feedback-notice' => 'Seus comentários nos ajudam a melhorar a sua experiência no site móvel. Ele será postado publicamente (juntamente com seu nome de usuário, a versão do navegador e sistema operacional) na página "$1". Por favor, tente escolher um assunto informativo, por exemplo, "problemas de formatação em tabelas largas". Seus comentários estão sujeitos aos nossos termos de uso.',
	'mobile-frontend-leave-feedback-subject' => 'Assunto:',
	'mobile-frontend-leave-feedback-message' => 'Mensagem:',
	'mobile-frontend-leave-feedback-submit' => 'Enviar comentários',
	'mobile-frontend-leave-feedback-link-text' => 'Comentário de interface móvel',
	'mobile-frontend-leave-feedback' => 'Deixar comentário',
	'mobile-frontend-leave-feedback-title' => 'Deixar feedback sobre a experiência com a interface móvel',
	'mobile-frontend-leave-feedback-page-title' => 'Deixar feedback sobre a experiência com a interface móvel',
	'mobile-frontend-leave-feedback-thanks' => 'Obrigado por seus comentários!',
	'mobile-frontend-language' => 'Idioma:',
	'mobile-frontend-username' => 'Nome de usuário:',
	'mobile-frontend-password' => 'Senha:',
	'mobile-frontend-login' => 'Autenticar-se',
	'mobile-frontend-placeholder' => 'Digite sua pesquisa aqui...', # Fuzzy
);

/** Romansh (rumantsch)
 * @author Gion-andri
 * @author Kazu89
 */
$messages['rm'] = array(
	'mobile-frontend-search-submit' => 'Dai',
	'mobile-frontend-home-button' => 'Chasa',
	'mobile-frontend-random-button' => 'Casual',
	'mobile-frontend-back-to-top-of-section' => 'Siglir enavos in chapitel',
	'mobile-frontend-show-button' => 'Mussar',
	'mobile-frontend-hide-button' => 'Zuppentar',
	'mobile-frontend-regular-site' => 'Visitar la pagina regulara da {{SITENAME}}', # Fuzzy
	'mobile-frontend-wml-continue' => 'Cuntinuar…',
	'mobile-frontend-wml-back' => 'Enavos…',
	'mobile-frontend-view' => 'Versiun mobila',
	'mobile-frontend-featured-article' => 'Artitgels dal di',
	'mobile-frontend-leave-feedback-subject' => 'Object', # Fuzzy
	'mobile-frontend-leave-feedback-message' => 'Messadi', # Fuzzy
	'mobile-frontend-leave-feedback-submit' => 'Trametter il resun',
);

/** Romanian (română)
 * @author Firilacroco
 * @author Minisarm
 */
$messages['ro'] = array(
	'mobile-frontend-desc' => 'Interfața mobilă',
	'mobile-frontend-search-submit' => 'Du-te',
	'mobile-frontend-home-button' => 'Acasă',
	'mobile-frontend-logged-out' => 'Neautentificat',
	'mobile-frontend-logged-in-homepage-notification' => 'Bun venit, $1!',
	'mobile-frontend-logged-in-toast-notification' => 'Autentificat ca $1.',
	'mobile-frontend-sign-up-heading' => 'Înregistrare',
	'mobile-frontend-sign-in-heading' => 'Autentificare',
	'mobile-frontend-sign-in-why' => 'Dacă aveți un cont la {{SITENAME}}, vă puteți autentifica mai jos.',
	'mobile-frontend-sign-in-error-heading' => 'Hopa!',
	'mobile-frontend-settings-description' => 'Personalizați-vă experiența pe dispozitivele mobile cu aceste setări specifice site-ului mobil.',
	'mobile-frontend-settings-beta' => 'Beta',
	'mobile-frontend-settings-alpha' => 'Modul [//en.wikipedia.org/wiki/Here_be_dragons Exploratorului]',
	'mobile-frontend-settings-alpha-description' => 'Intrați pe teritoriul periculos și neexplorat al experienței mobile. Beneficiați de și mai multe caracteristici experimentale, însă cu un risc mai mare de erori.',
	'mobile-frontend-save-settings' => 'Salvează setările',
	'mobile-frontend-random-button' => 'Aleatoriu',
	'mobile-frontend-ajax-random-heading' => 'Se localizează informațiile...',
	'mobile-frontend-ajax-random-quote' => 'Dezvoltarea intelectuală ar trebui să înceapă la naștere și să se termine doar la moarte',
	'mobile-frontend-ajax-random-question' => 'Citiți această pagină?',
	'mobile-frontend-ajax-random-yes' => 'Da',
	'mobile-frontend-ajax-random-retry' => 'Încercă din nou',
	'mobile-frontend-ajax-random-suggestions' => 'Alte sugestii:',
	'mobile-frontend-back-to-top-of-section' => 'Salt la începutul secțiunii',
	'mobile-frontend-close-section' => 'Închide această secțiune',
	'mobile-frontend-show-button' => 'Arată',
	'mobile-frontend-hide-button' => 'Ascunde',
	'mobile-frontend-empty-homepage-text' => 'Această pagină principală trebuie configurată. [//meta.wikimedia.org/wiki/Mobile_Projects/Mobile_Gateway#Mobile_homepage Instrucțiuni despre cum se activează acest site mobil]',
	'mobile-frontend-regular-site' => 'Vizualizare ca pe desktop',
	'mobile-frontend-wml-continue' => 'Continuare...',
	'mobile-frontend-wml-back' => 'Înapoi...',
	'mobile-frontend-view' => 'Versiune mobilă',
	'mobile-frontend-view-desktop' => 'Desktop',
	'mobile-frontend-view-mobile' => 'Mobil',
	'mobile-frontend-opt-in-explain' => 'Prin examinarea stadiului beta, veți avea acces la caracteristici experimentale, cu riscul de a întâmpina erori și probleme.',
	'mobile-frontend-images-status' => 'Imagini',
	'mobile-frontend-disable-images' => 'Dezactivează imaginile pe site-urile mobile',
	'mobile-frontend-enable-images' => 'Activează imaginile pe site-urile mobile',
	'mobile-frontend-missing-image' => 'Imagine',
	'mobile-frontend-off' => 'OPRIT',
	'mobile-frontend-on' => 'PORNIT',
	'mobile-frontend-footer-contributors-text' => 'Pagină redactată de [$1 contribuitori] ca dumneavoastră',
	'mobile-frontend-featured-article' => 'Articolul de calitate al zilei',
	'mobile-frontend-news-items' => 'Știri',
	'mobile-frontend-leave-feedback-notice' => 'Părerea dumneavoastră ne va ajuta să îmbunătățim navigarea pe site-ul mobil. Aceasta va fi făcută publică (împreună cu numele dumneavoastră de utilizator, versiunea browserului și sistemul de operare) pe pagina „$1”. Încercați să alegeți un titlu informativ; ex.: „Probleme cu formatarea tabelelor late”. Comentariile dumnevoastră sunt supuse condițiilor noastre de utilizare.',
	'mobile-frontend-leave-feedback-warning' => 'Dacă nu sunteți de acord ca informațiile dumneavoastră să fie publice, vă rugăm să nu includeți detalii personale în comentarii.',
	'mobile-frontend-leave-feedback-subject' => 'Subiect:',
	'mobile-frontend-leave-feedback-message' => 'Mesaj:',
	'mobile-frontend-leave-feedback-submit' => 'Trimite părerea',
	'mobile-frontend-leave-feedback-link-text' => 'Păreri despre interfața mobilă',
	'mobile-frontend-leave-feedback' => 'Scrieți-vă părerea',
	'mobile-frontend-leave-feedback-title' => 'Păreri despre interfața mobilă',
	'mobile-frontend-leave-feedback-technical-problem-section-header' => 'Problemă tehnică',
	'mobile-frontend-leave-feedback-general-section-header' => 'Generalități',
	'mobile-frontend-leave-feedback-article-feedback-section-header' => 'Evaluare articol',
	'mobile-frontend-leave-feedback-email-body' => 'Vă rugăm să detaliați problema cu care vă confruntați la {{SITENAME}} deasupra acestei linii. Rețineți că nu putem răspunde tuturor mesajelor pe care le primim.',
	'mobile-frontend-leave-feedback-technical-link-text' => 'Problemă tehnică',
	'mobile-frontend-leave-feedback-general-link-text' => 'Păreri generale',
	'mobile-frontend-leave-feedback-article-personal-link-text' => 'Cu privire la mine, o persoană, sau o societate pe care o reprezint',
	'mobile-frontend-leave-feedback-article-factual-link-text' => 'În ceea ce privește o eroare de fapt',
	'mobile-frontend-leave-feedback-article-other-link-text' => 'Cu privire la o altă problemă',
	'mobile-frontend-leave-feedback-form-subject-placeholder' => 'Subiectul mesajului',
	'mobile-frontend-leave-feedback-form-message-placeholder' => 'Scrieți aici comentariul dumneavoastră',
	'mobile-frontend-leave-feedback-page-title' => 'Păreri despre interfața mobilă',
	'mobile-frontend-leave-feedback-special-title' => 'Contactați-ne',
	'mobile-frontend-feedback-no-subject' => '(fără subiect)',
	'mobile-frontend-feedback-no-subject-field' => 'Vă rugăm să specificați un subiect',
	'mobile-frontend-feedback-no-message' => 'Vă rugăm să introduceți un mesaj aici',
	'mobile-frontend-feedback-edit-summary' => '$1 - publicat automat prin intermediul [[Special:MobileFeedback|uneltei de feedback mobil]]',
	'mobile-frontend-leave-feedback-thanks' => 'Vă mulțumim pentru păreri!',
	'mobile-frontend-leave-feedback-post-error' => 'A apărut o eroare în timpul procesării mesajului dumneavoastră. Vă rugăm să reîncercați mai târziu.',
	'mobile-frontend-language' => 'Limbă:',
	'mobile-frontend-language-article-heading' => 'Lecturare în altă limbă',
	'mobile-frontend-language-header' => 'Această pagină este disponibilă {{PLURAL:$1|într-o singură limbă|în $1 limbi|în $1 de limbi}}',
	'mobile-frontend-language-variant-header' => 'Alegeți varianta în {{#language:{{CONTENTLANG}}}}',
	'mobile-frontend-language-footer' => 'Notă: Această pagină ar putea fi indisponibilă în limba dumneavoastră preferată. Puteți vedea ce limbi suportă {{SITENAME}} făcând clic aici.',
	'mobile-frontend-language-site-choose' => 'Căutare limbă',
	'mobile-frontend-username' => 'Nume de utilizator:',
	'mobile-frontend-password' => 'Parolă:',
	'mobile-frontend-username-placeholder' => 'Nume de utilizator',
	'mobile-frontend-password-placeholder' => 'Parolă',
	'mobile-frontend-login' => 'Autentificare',
	'mobile-frontend-last-modified-date' => 'Ultima modificare pe $1, la $2',
	'mobile-frontend-last-modified-seconds' => 'Ultima modificare acum {{PLURAL:$1|o secundă|$1 secunde|$1 de secunde}}',
	'mobile-frontend-last-modified-minutes' => 'Ultima modificare acum {{PLURAL:$1|un minut|$1 minute|$1 de minute}}',
	'mobile-frontend-last-modified-hours' => 'Ultima modificare acum {{PLURAL:$1|o oră|$1 ore|$1 de ore}}',
	'mobile-frontend-last-modified-days' => 'Ultima modificare acum {{PLURAL:$1|o zi|$1 zile|$1 de zile}}',
	'mobile-frontend-last-modified-months' => 'Ultima modificare acum {{PLURAL:$1|o lună|$1 luni|$1 de luni}}',
	'mobile-frontend-last-modified-years' => 'Ultima modificare acum {{PLURAL:$1|un an|$1 ani|$1 de ani}}',
	'mobile-frontend-account-create-submit' => 'Înregistrare',
	'mobile-frontend-password-confirm-placeholder' => 'Confirmați parola',
	'mobile-frontend-account-create-email-placeholder' => 'Adresă de e-mail (opțională)',
	'mobile-frontend-account-create-captcha-placeholder' => 'Introduceți textul de securitate',
	'mobile-frontend-overlay-escape' => 'Înapoi',
	'mobile-frontend-placeholder' => 'Căutare în {{SITENAME}}',
	'mobile-frontend-placeholder-beta' => 'Căutare în {{SITENAME}} (beta)',
	'mobile-frontend-placeholder-alpha' => 'Căutare în {{SITENAME}} (modul Explorator)',
	'mobile-frontend-search-help' => 'Introduceți deasupra termenii de căutat, iar titlurile paginilor ce corespund vor apărea aici.',
	'mobile-frontend-dismiss-notification' => 'respinge această notificare',
	'mobile-frontend-clear-search' => 'Curăță',
	'mobile-frontend-privacy-link-text' => 'Confidențialitate',
	'mobile-frontend-about-link-text' => 'Despre',
	'mobile-frontend-footer-sitename' => '{{SITENAME}}',
	'mobile-frontend-footer-license-text' => 'Conținut disponibil sub licența [//en.m.wikipedia.org/wiki/Wikipedia:Text_of_Creative_Commons_Attribution-ShareAlike_3.0_Unported_License?useformat=mobile CC BY-SA 3.0]',
	'mobile-frontend-terms-use-text' => '[//wikimediafoundation.org/wiki/Terms_of_use?useformat=mobile Termeni de utilizare]',
	'mobile-frontend-footer-contact' => 'Contact',
	'mobile-frontend-search-noresults' => 'Niciun titlu de pagină nu corespunde căutării dumneavoastră. Căutați altceva sau apăsați butonul de căutare de pe tastatură pentru a căuta în interiorul paginilor.',
	'mobile-frontend-main-menu-button-tooltip' => 'Deschide meniul principal',
	'mobile-frontend-main-menu-page-title' => 'Navigare în site',
	'mobile-frontend-main-menu-featured' => 'De calitate',
	'mobile-frontend-main-menu-nearby' => 'În apropiere',
	'mobile-frontend-main-menu-login' => 'Autentificare',
	'mobile-frontend-main-menu-logout' => 'Închide sesiunea',
	'mobile-frontend-main-menu-watchlist' => 'Pagini urmărite',
	'mobile-frontend-main-menu-settings' => 'Setări',
	'mobile-frontend-main-menu-upload' => 'Încărcări',
	'mobile-frontend-main-menu-settings-heading' => 'Setări site mobil',
	'mobile-frontend-settings-site-header' => 'Limbile pentru {{SITENAME}}',
	'mobile-frontend-settings-site-description' => '{{SITENAME}} este un proiect disponibil {{PLURAL:$1|într-o singură limbă|în $1 limbi|în $1 de limbi}}. Toate versiunile disponibile sunt enumerate mai jos',
	'mobile-frontend-main-menu-contact' => 'Contact',
	'mobile-frontend-main-menu-account-create' => 'Creează cont',
	'mobile-frontend-page-menu-contents' => 'cuprins',
	'mobile-frontend-page-menu-history' => 'Istoric',
	'mobile-frontend-meta-data-issues-header' => 'Probleme',
	'mobile-frontend-meta-data-issues' => 'Această pagină are anumite probleme',
	'mobile-frontend-ajax-page-loading' => 'Se încarcă $1',
	'mobile-frontend-page-saving' => 'Se salvează $1',
	'mobile-frontend-ajax-page-error' => 'Hopa! Ceva nu a funcționat bine. Încercați să reîmprospătați fereastra navigatorului dv.',
	'mobile-frontend-nearby-title' => 'În apropiere',
	'mobile-frontend-nearby-loading' => 'Se încarcă subiecte din apropierea dumneavoastră',
	'mobile-frontend-nearby-requirements' => 'Această pagină necesită atât javascript, cât și un navigator capabil de a furniza locația.',
	'mobile-frontend-nearby-distance-report' => '$1 km de locul în care vă aflați acum',
	'mobile-frontend-nearby-lookup-error' => 'Nu v-am putut repera. Reîncercați...',
	'mobile-frontend-nearby-noresults' => 'Sunteți în mijlocul pustietății și nu am putut găsi niciun subiect. De ce să nu scrieți unul?',
	'mobile-frontend-nearby-refresh' => 'V-am determinat poziția cu o precizie mai mare. Apăsați aici pentru a reîmprospăta lista cu pagini din apropiere',
	'mobile-frontend-nearby-error' => 'O eroare neașteptată a apărut în timpul căutării de pagini din apropiere',
	'mobile-frontend-donate-image-login' => 'Trebuie să vă autentificați pentru a vă vizualiza încărcările.',
	'mobile-frontend-photo-upload-generic' => 'Donează o imagine',
	'mobile-frontend-donate-image-title' => 'Donează o imagine',
	'mobile-frontend-donate-image-summary' => 'Fotografiile dau viață proiectului {{SITENAME}}.
Foarte multe pagini nu sunt ilustrate din cauza lipsei acute de imagini cu licență liberă.
Ajutați-ne să dăm viață acestor pagini, donând acele fotografii pe care doriți să le dați mai departe și care ar putea fi în folosul editorial al comunității de la {{SITENAME}}.',
	'mobile-frontend-donate-image-heading' => 'Contribuțiile dumneavoastră recente',
	'mobile-frontend-donate-image-page-title' => 'Încărcare',
	'mobile-frontend-donate-image-anon' => 'Un [[Special:UserLogin|cont de utilizator]] este necesar pentru a vizualiza pagina cu încărcări',
	'mobile-frontend-listed-image-no-description' => 'Fără descriere',
	'mobile-frontend-donate-photo-upload-success' => 'Succes! Imaginea dumneavoastră poate fi acum folosită pe {{SITENAME}}!',
	'mobile-frontend-donate-photo-first-upload-success' => 'Succes! Vă mulțumim pentru prima dumneavoastră contribuție!',
	'mobile-frontend-watchlist-add' => '$1 a fost adăugată listei dumneavoastră de pagini urmărite',
	'mobile-frontend-watchlist-removed' => '$1 a fost eliminată din lista dumneavoastră de pagini urmărite',
	'mobile-frontend-watchlist-view' => 'Vezi lista de pagini urmărite',
	'mobile-frontend-watchlist-more' => 'mai multe',
	'mobile-frontend-watchlist-cta' => 'Vă rugăm să vă autentificați sau să vă înregistrați pentru a urmări această pagină.',
	'mobile-frontend-watchlist-cta-button-login' => 'Autentificare',
	'mobile-frontend-watchlist-cta-button-signup' => 'Înregistrare',
	'mobile-frontend-watch-login' => 'Trebuie să vă autentificați pentru a vă urmări pagini.',
	'mobile-frontend-watchlist-a-z' => 'Toate',
	'mobile-frontend-watchlist-feed' => 'Modificate',
	'mobile-frontend-watchlist-a-z-empty' => 'În prezent nu urmăriți nicio pagină',
	'mobile-frontend-watchlist-a-z-empty-howto-alt' => 'Faceți clic pe steaua din partea de sus a paginii',
	'mobile-frontend-watchlist-a-z-empty-howto' => 'Urmăriți o pagină care vi se pare interesantă făcând clic pe pictograma „stea” din partea de sus a ecranului. Acest lucru vă permite să marcați paginile care vă interesează, dar și să fiți la curent atunci când au fost modificate.',
	'mobile-frontend-watchlist-feed-empty' => 'Nu există pagini cu schimbări recente',
	'mobile-frontend-watchlist-back-home' => 'Înapoi acasă',
	'mobile-frontend-changeslist-ip' => 'Utilizator anonim',
	'mobile-frontend-changeslist-nocomment' => 'fără descrierea modificării',
	'mobile-frontend-watchlist-filter-all' => 'Toate',
	'mobile-frontend-watchlist-filter-articles' => 'Articole',
	'mobile-frontend-watchlist-filter-talk' => 'Discuție',
	'mobile-frontend-watchlist-filter-other' => 'Altele',
	'mobile-frontend-watchlist-modified' => 'Modificată cu $1',
	'mobile-frontend-diffview-404-title' => 'Versiune defectuoasă',
	'mobile-frontend-diffview-404-desc' => 'ID-ul versiunii cerute nu există',
	'mobile-frontend-diffview-title' => 'Modificări',
	'mobile-frontend-diffview-editcount' => '{{PLURAL:$1|o modificare|$1 modificări|$1 de modificări}}',
	'mobile-frontend-diffview-anonymous' => 'Utilizator anonim',
	'mobile-frontend-diffview-bytesadded' => '$1 {{PLURAL:$1|octet adăugat|octeți adăugați|de octeți adăugați}}',
	'mobile-frontend-diffview-bytesremoved' => '$1 {{PLURAL:$1|octet șters|octeți șterși|de octeți șterși}}',
	'mobile-frontend-diffview-explained' => 'Următoarele rânduri au fost adăugate (+) și șterse (-):',
	'mobile-frontend-table' => 'Tabelul $1',
	'mobile-frontend-saving-exit-page' => 'Contribuția dumneavoastră încă se salvează. Dacă ieșiți, contribuțiile dumneavoastră se vor pierde. Sunteți sigur că doriți să ieșiți?',
	'mobile-frontend-photo-upload' => 'Adăugați o imagine pentru acest articol',
	'mobile-frontend-photo-article-edit-comment' => 'Fotografie adăugată pentru a fi utilizată în pagină',
	'mobile-frontend-photo-article-donate-comment' => 'A donat imaginea de pe un dispozitiv mobil',
	'mobile-frontend-photo-upload-comment' => 'Fotografie adăugată în pagină',
	'mobile-frontend-photo-caption-placeholder' => 'Adăugați o descriere (obligatoriu)',
	'mobile-frontend-image-loading' => 'Se încarcă afișarea imaginii',
	'mobile-frontend-image-uploading-wait' => 'Vă rugăm să așteptați, imaginea se încarcă.',
	'mobile-frontend-image-uploading-long' => 'Imaginea încă se încarcă! Vă mulțumim pentru răbdare.',
	'mobile-frontend-image-uploading-cancel' => '<a href="#">Revocați</a> dacă durează prea mult.',
	'mobile-frontend-photo-upload-error' => 'Eroare; reîncercați.',
	'mobile-frontend-photo-upload-success-article' => 'Succes! Imaginea dumneavoastră este acum afișată pe această pagină.',
	'mobile-frontend-photo-license' => 'Apăsând pe „Trimite” sunteți de acord cu [//wikimediafoundation.org/wiki/Terms_of_use Termenii noștri de utilizare] și sunteți de acord ca fotografia dumneavoastră să fie eliberată sub licența [//creativecommons.org/licenses/by-sa/3.0/ Creative Commons Atribuire și distribuire în condiții identice 3.0].',
	'mobile-frontend-photo-submit' => 'Trimite',
	'mobile-frontend-photo-cancel' => 'Revocare',
	'mobile-frontend-photo-upload-user-count' => '{{PLURAL:$1|<span>1</span> încărcare|<span>$1</span> încărcări<span>$1</span> de încărcări}}',
	'mobile-frontend-photo-upload-user-count-over-limit' => '500+ încărcări',
	'tag-mobile_edit' => 'Modificare mobilă',
	'tag-mobile_edit-description' => 'Modificare efectuată de pe site-ul mobil',
	'mobile-frontend-drawer-cancel' => 'Revocare',
);

/** tarandíne (tarandíne)
 * @author Joetaras
 */
$messages['roa-tara'] = array(
	'mobile-frontend-desc' => "Grafeche d'u Mobile",
	'mobile-frontend-search-submit' => 'Véje',
	'mobile-frontend-home-button' => 'Cáse',
	'mobile-frontend-logged-out' => 'Non ge sì collegate',
	'mobile-frontend-logged-in-homepage-notification' => 'Bovègne, $1!',
	'mobile-frontend-logged-in-toast-notification' => "E' trasute cumme $1",
	'mobile-frontend-sign-up-heading' => 'Reggistrate',
	'mobile-frontend-sign-in-heading' => 'Tràse',
	'mobile-frontend-sign-in-error-heading' => 'Ooooooh',
	'mobile-frontend-settings-beta' => 'Beta',
	'mobile-frontend-save-settings' => "Reggistre le 'mbostaziune",
	'mobile-frontend-random-button' => 'A uecchije',
	'mobile-frontend-ajax-random-question' => 'Ligge sta pàgene?',
	'mobile-frontend-ajax-random-yes' => 'Sìne',
	'mobile-frontend-ajax-random-retry' => 'Pruève arrete',
	'mobile-frontend-ajax-random-suggestions' => 'Otre suggereminde:',
	'mobile-frontend-back-to-top-of-section' => "Zumbe rrete a 'na sezione",
	'mobile-frontend-close-section' => 'Achiude sta sezione',
	'mobile-frontend-show-button' => 'Fà vedè',
	'mobile-frontend-hide-button' => 'Scunne',
	'mobile-frontend-regular-site' => 'Visione da combiuter da tavole',
	'mobile-frontend-wml-continue' => 'Condinue ...',
	'mobile-frontend-wml-back' => 'Rrete ...',
	'mobile-frontend-view' => "Viste d'u mobile",
	'mobile-frontend-view-mobile' => 'Mobile',
	'mobile-frontend-opt-in-explain' => "Trasenne jndr'à beta, tu puè ausà le funzionalità sperimendale, rischianne de acchià errore e casine varie.",
	'mobile-frontend-images-status' => 'Immaggine',
	'mobile-frontend-disable-images' => "Disabbilite le immaggine sus a 'u site mobile",
	'mobile-frontend-enable-images' => "Abbilite le immaggine sus a 'u site mobile",
	'mobile-frontend-missing-image' => 'Immaggine',
	'mobile-frontend-off' => 'Stute',
	'mobile-frontend-on' => 'Appizzeche',
	'mobile-frontend-footer-contributors-text' => 'Pàgene pe [$1 conderbbutore] ca te piaccene',
	'mobile-frontend-featured-article' => 'Vôsce dettagliate de osce',
	'mobile-frontend-news-items' => "Jndr'à le notizie",
	'mobile-frontend-leave-feedback-subject' => 'Suggette:',
	'mobile-frontend-leave-feedback-message' => 'Messàgge:',
	'mobile-frontend-leave-feedback-submit' => "Conferme 'u feedback",
	'mobile-frontend-leave-feedback-link-text' => "Feedback d'a grafeche d'u mobile",
	'mobile-frontend-leave-feedback' => "Lasse 'u feedbacl",
	'mobile-frontend-leave-feedback-technical-problem-section-header' => 'Probbleme tecniche',
	'mobile-frontend-leave-feedback-general-section-header' => 'Generale',
	'mobile-frontend-leave-feedback-article-feedback-section-header' => "Segnalazione sus 'a vôsce",
	'mobile-frontend-leave-feedback-technical-link-text' => 'Probbleme tecniche',
	'mobile-frontend-leave-feedback-general-link-text' => 'Segnalazione generale',
	'mobile-frontend-leave-feedback-form-subject-placeholder' => "Suggette d'u messàgge",
	'mobile-frontend-leave-feedback-form-message-placeholder' => "Scrive 'u commende tune aqquà",
	'mobile-frontend-leave-feedback-page-title' => "Segnalazione d'u site mobbile",
	'mobile-frontend-leave-feedback-special-title' => 'Condattace',
	'mobile-frontend-feedback-no-subject' => '(nisciune oggette)',
	'mobile-frontend-feedback-no-subject-field' => "Pe piacere scacchie 'n'oggette",
	'mobile-frontend-feedback-no-message' => "Pe piacere sckaffe 'u messàgge aqquà",
	'mobile-frontend-leave-feedback-thanks' => 'Grazie, pu feedback tune!',
	'mobile-frontend-language' => 'Lènghe:',
	'mobile-frontend-language-article-heading' => "Ligge jndr'à 'n'otra lènghe",
	'mobile-frontend-language-header' => "Sta vôsce jè disponibbele jndr'à $1 {{PLURAL:$1|lènghe}}",
	'mobile-frontend-language-footer' => "Note bbuène: Sta pàgene non ge pò essere scritte jndr'à lènga toje preferite. Tu puè 'ndrucà quale lènghe de {{SITENAME}} sò mandenute cazzanne aqquà.",
	'mobile-frontend-language-site-choose' => "Cirche 'a lènghe",
	'mobile-frontend-username' => 'Nome utende:',
	'mobile-frontend-password' => 'Passuord:',
	'mobile-frontend-username-placeholder' => 'Nome utende',
	'mobile-frontend-password-placeholder' => 'Passuord',
	'mobile-frontend-login' => 'Tràse',
	'mobile-frontend-last-modified-date' => "Urteme cangiamende 'u $1, a le $2",
	'mobile-frontend-account-create-submit' => 'Reggistrate',
	'mobile-frontend-password-confirm-placeholder' => "Conferme 'a passuord",
	'mobile-frontend-overlay-escape' => 'Tuèrne rrete',
	'mobile-frontend-placeholder' => 'Cirche {{SITENAME}}',
	'mobile-frontend-placeholder-beta' => 'Cirche {{SITENAME}} (Beta)',
	'mobile-frontend-placeholder-alpha' => "Cirche {{SITENAME}} (Mode d'u Draghe)",
	'mobile-frontend-dismiss-notification' => 'live sta notificazione',
	'mobile-frontend-clear-search' => 'Pulizze',
	'mobile-frontend-privacy-link-text' => 'Privacy',
	'mobile-frontend-about-link-text' => 'Sus a',
	'mobile-frontend-footer-sitename' => '{{SITENAME}}',
	'mobile-frontend-footer-contact' => 'Condatte',
	'mobile-frontend-main-menu-featured' => 'Dettagliate',
	'mobile-frontend-main-menu-nearby' => 'Vicine a',
	'mobile-frontend-main-menu-login' => 'Tràse',
	'mobile-frontend-main-menu-logout' => 'Isse',
	'mobile-frontend-main-menu-settings' => "'Mbostaziune",
	'mobile-frontend-main-menu-upload' => 'Carecaminde',
	'mobile-frontend-main-menu-settings-heading' => "'Mbostaziune d'u site mobbile",
	'mobile-frontend-settings-site-header' => 'Lènghe de {{SITENAME}}',
	'mobile-frontend-main-menu-contact' => 'Condatte',
	'mobile-frontend-main-menu-account-create' => "Ccreje 'nu cunde utende",
	'mobile-frontend-page-menu-contents' => 'condenute',
	'mobile-frontend-page-menu-history' => 'Cunde',
	'mobile-frontend-photo-upload-generic' => "Riale 'n'immaggine",
	'mobile-frontend-donate-image-title' => "Riale 'n'immaggine",
	'mobile-frontend-donate-image-page-title' => 'Careche',
	'mobile-frontend-watchlist-more' => 'de cchiù',
	'mobile-frontend-watchlist-cta-button-login' => 'Tràse',
	'mobile-frontend-watchlist-cta-button-signup' => 'Reggistrate',
	'mobile-frontend-watchlist-a-z' => 'Tutte',
	'mobile-frontend-watchlist-feed' => 'Cangiate',
	'mobile-frontend-changeslist-ip' => 'Utende anonime',
	'mobile-frontend-watchlist-filter-all' => 'Tutte',
	'mobile-frontend-watchlist-filter-articles' => 'Vôsce',
	'mobile-frontend-watchlist-filter-talk' => "'Ngazzamende",
	'mobile-frontend-watchlist-filter-other' => 'Otre',
	'mobile-frontend-diffview-title' => 'Cangiaminde',
	'mobile-frontend-diffview-editcount' => '$1 {{PLURAL:$1|cangiamende|cangiaminde}}',
	'mobile-frontend-diffview-anonymous' => 'Utende anonime',
	'mobile-frontend-diffview-bytesadded' => '$1 {{PLURAL:$1|byte}} aggiunde',
	'mobile-frontend-diffview-bytesremoved' => '$1 {{PLURAL:$1|byte}} luate',
	'mobile-frontend-table' => 'Tabbelle $1',
	'mobile-frontend-photo-caption-placeholder' => "Aggiunge 'na descrizione (richieste)",
	'mobile-frontend-image-loading' => "Stoche a scareche 'n'immaggine",
	'mobile-frontend-image-uploading-wait' => "Stoche a careche 'n'immaggine, pe piacere aspitte.",
	'mobile-frontend-image-uploading-cancel' => '<a href="#">Annulle</a> ce te ste pigghie assaije tiembe.',
	'mobile-frontend-photo-upload-error' => 'Errore, pruève arrete.',
	'mobile-frontend-photo-submit' => 'Conferme',
	'mobile-frontend-photo-cancel' => 'Annulle',
	'mobile-frontend-drawer-cancel' => 'Annulle',
);

/** Russian (русский)
 * @author AlexSm
 * @author Amire80
 * @author Biathlon
 * @author Bouron
 * @author DCamer
 * @author DR
 * @author Dim Grits
 * @author Eleferen
 * @author Express2000
 * @author Kaganer
 * @author Lockal
 * @author Ole Yves
 * @author Rave
 * @author ShinePhantom
 * @author Александр Сигачёв
 */
$messages['ru'] = array(
	'mobile-frontend-desc' => 'Мобильный интерфейс',
	'mobile-frontend-search-submit' => 'Перейти',
	'mobile-frontend-home-button' => 'Домой',
	'mobile-frontend-logged-out' => 'Вы не авторизованы',
	'mobile-frontend-logged-in-homepage-notification' => 'Добро пожаловать, $1!',
	'mobile-frontend-logged-in-toast-notification' => 'Вошёл как $1.',
	'mobile-frontend-sign-up-heading' => 'Зарегистрироваться',
	'mobile-frontend-sign-in-heading' => 'Войти',
	'mobile-frontend-sign-in-why' => 'Если у вас уже есть учётная запись в проекте {{SITENAME}}, вы можете представиться системе ниже.',
	'mobile-frontend-sign-in-error-heading' => 'Ой!',
	'mobile-frontend-settings-description' => 'Используйте эти специальные настройки мобильной версии для повышения удобства использования сайта на своём мобильном устройстве.',
	'mobile-frontend-settings-beta' => 'Бета-версия',
	'mobile-frontend-settings-alpha' => 'Режим «[//ru.wikipedia.org/wiki/Hic_sunt_dracones тут обитают драконы]»',
	'mobile-frontend-settings-alpha-description' => 'Войдите в опасную и неиследованную мобильную территорию. Получите ещё больше экспериментальных возможностей, но и большую опасность возникновения ошибок.',
	'mobile-frontend-save-settings' => 'Сохранить настройки',
	'mobile-frontend-random-button' => 'Случайная',
	'mobile-frontend-ajax-random-heading' => 'Поиск знаний...',
	'mobile-frontend-ajax-random-quote' => 'Интеллектуальный рост должен начаться в момент рождения и прекращаться только со смертью',
	'mobile-frontend-ajax-random-quote-author' => 'Альберт Эйнштейн',
	'mobile-frontend-ajax-random-question' => 'Прочитать данную страницу?',
	'mobile-frontend-ajax-random-yes' => 'Да',
	'mobile-frontend-ajax-random-retry' => 'Повторить',
	'mobile-frontend-ajax-random-suggestions' => 'Другие предложения:',
	'mobile-frontend-back-to-top-of-section' => 'Вернуться к предыдущему разделу',
	'mobile-frontend-close-section' => 'Закрыть этот раздел',
	'mobile-frontend-show-button' => 'Показать',
	'mobile-frontend-hide-button' => 'Скрыть',
	'mobile-frontend-empty-homepage-text' => 'Эта заглавная страница нуждается в настройке. [//meta.wikimedia.org/wiki/Mobile_Projects/Mobile_Gateway#Mobile_homepage Инструкции по организации мобильной версии сайта]',
	'mobile-frontend-regular-site' => 'Обычная версия',
	'mobile-frontend-wml-continue' => 'Далее ...',
	'mobile-frontend-wml-back' => 'Назад ...',
	'mobile-frontend-view' => 'Мобильная версия',
	'mobile-frontend-view-desktop' => 'Стационарный',
	'mobile-frontend-view-mobile' => 'Мобильный',
	'mobile-frontend-opt-in-explain' => 'Присоединившись к бета-тестированию, вы получите доступ к некоторым экспериментальным функциям, но увеличится и  ваш риск встретиться с ошибкой или проблемой.',
	'mobile-frontend-images-status' => 'Изображения',
	'mobile-frontend-disable-images' => 'Отключить изображения на мобильном сайте',
	'mobile-frontend-enable-images' => 'Включить изображения на мобильном сайте',
	'mobile-frontend-missing-image' => 'Изображение',
	'mobile-frontend-off' => 'ВЫКЛ',
	'mobile-frontend-on' => 'ВКЛ',
	'mobile-frontend-footer-contributors-text' => 'Эта страница написана [$1 добровольцами], похожими на вас',
	'mobile-frontend-featured-article' => 'Избранная статья дня',
	'mobile-frontend-news-items' => 'Новости',
	'mobile-frontend-leave-feedback-notice' => 'Ваш отзыв поможет нам улучшить использование мобильного сайта. Он будет опубликован в общедоступном режиме (вместе с вашим именем учётной записи, версией браузера и операционной системы) на странице &quot;$1&quot;. Пожалуйста, попробуйте выбрать информативную тему, например «вопросы форматирования широких таблиц». Ваш отзыв должен соответствовать нашим условиям использования.',
	'mobile-frontend-leave-feedback-warning' => 'Пожалуйста, не включайте в свои комментарии персональную информацию, если вы не согласны на её публикацию.',
	'mobile-frontend-leave-feedback-subject' => 'Тема:',
	'mobile-frontend-leave-feedback-message' => 'Сообщение:',
	'mobile-frontend-leave-feedback-submit' => 'Отправить отзыв',
	'mobile-frontend-leave-feedback-link-text' => 'Отзывы о мобильном интерфейсе',
	'mobile-frontend-leave-feedback' => 'Оставить отзыв',
	'mobile-frontend-leave-feedback-title' => 'Отзыв о мобильной версии сайта',
	'mobile-frontend-leave-feedback-technical-problem-section-header' => 'Техническая проблема',
	'mobile-frontend-leave-feedback-general-section-header' => 'Основное',
	'mobile-frontend-leave-feedback-article-feedback-section-header' => 'Оценка статьи',
	'mobile-frontend-leave-feedback-email-body' => 'Пожалуйста, опишите над этой строкой неполадку, с которой вы столкнулись на сайте «{{SITENAME}}». Пожалуйста, учтите, что мы, к сожалению, не можем отвечать на каждый запрос.',
	'mobile-frontend-leave-feedback-technical-link-text' => 'Техническая проблема',
	'mobile-frontend-leave-feedback-general-link-text' => 'Общая обратная связь',
	'mobile-frontend-leave-feedback-article-personal-link-text' => 'В связи с информацией обо мне, или о человеке или компании, которых я представляю',
	'mobile-frontend-leave-feedback-article-factual-link-text' => 'По поводу фактической ошибки',
	'mobile-frontend-leave-feedback-article-other-link-text' => 'По поводу другой проблемы',
	'mobile-frontend-leave-feedback-form-subject-placeholder' => 'Тема сообщения',
	'mobile-frontend-leave-feedback-form-message-placeholder' => 'Напишите здесь свой комментарий',
	'mobile-frontend-leave-feedback-page-title' => 'Отзыв о мобильной версии сайта',
	'mobile-frontend-feedback-page' => 'Project:Mobile Extension Feedback',
	'mobile-frontend-leave-feedback-special-title' => 'Свяжитесь с нами',
	'mobile-frontend-feedback-no-subject' => '(без темы)',
	'mobile-frontend-feedback-no-subject-field' => 'Пожалуйста, укажите тему',
	'mobile-frontend-feedback-no-message' => 'Пожалуйста, введите здесь своё сообщение',
	'mobile-frontend-feedback-edit-summary' => '$1 — опубликовано автоматически через [[Special:MobileFeedback|мобильный инструмент обратной связи]]',
	'mobile-frontend-leave-feedback-thanks' => 'Спасибо за ваш отзыв!',
	'mobile-frontend-leave-feedback-post-error' => 'При обработке вашего сообщения произошла ошибка. Пожалуйста, попробуйте снова позже.',
	'mobile-frontend-language' => 'Язык:',
	'mobile-frontend-language-article-heading' => 'Читать на другом языке',
	'mobile-frontend-language-header' => 'Эта страница существует на $1 {{PLURAL:$1|языке|языках}}',
	'mobile-frontend-language-variant-header' => 'Выберите вариант {{#language:{{CONTENTLANG}}}}',
	'mobile-frontend-language-footer' => 'Примечание: Эта страница может быть написана не на том языке, который вы предпочитаете. Вы можете увидеть, какие языки поддерживает {{SITENAME}}, кликнув здесь.',
	'mobile-frontend-language-site-choose' => 'Поиск языка',
	'mobile-frontend-username' => 'Имя участника:',
	'mobile-frontend-password' => 'Пароль:',
	'mobile-frontend-username-placeholder' => 'Имя участника',
	'mobile-frontend-password-placeholder' => 'Пароль',
	'mobile-frontend-login' => 'Войти',
	'mobile-frontend-last-modified-date' => 'Последние изменения на $2 $1',
	'mobile-frontend-last-modified-seconds' => 'Последние изменения были сделаны {{PLURAL:$1|$1 секунду|$1 секунды|$1 секунд}} назад',
	'mobile-frontend-last-modified-minutes' => 'Последние изменения были сделаны {{PLURAL:$1|$1 минуту|$1 минуты|$1 минут}} назад',
	'mobile-frontend-last-modified-hours' => 'Последние изменения были сделаны {{PLURAL:$1|$1 час|$1 часа|$1 часов}} назад',
	'mobile-frontend-last-modified-days' => 'Последние изменения были сделаны {{PLURAL:$1|$1 день|$1 дня|$1 дней}} назад',
	'mobile-frontend-last-modified-months' => 'Последние изменения были сделаны {{PLURAL:$1|$1 месяц|$1 месяца|$1 месяцев}} назад',
	'mobile-frontend-last-modified-years' => 'Последние изменения были сделаны {{PLURAL:$1|$1 год|$1 года|$1 лет}} назад',
	'mobile-frontend-account-create-submit' => 'Зарегистрироваться',
	'mobile-frontend-password-confirm-placeholder' => 'Подтвердите пароль',
	'mobile-frontend-account-create-email-placeholder' => 'Адрес электронной почты (необязательно)',
	'mobile-frontend-account-create-captcha-placeholder' => 'Введите текст проверки безопасности',
	'mobile-frontend-overlay-escape' => 'Вернуться назад',
	'mobile-frontend-placeholder' => 'Искать в {{grammar:genitive|{{SITENAME}}}}',
	'mobile-frontend-placeholder-beta' => 'Поиск по {{grammar:genitive|{{SITENAME}}}} (бета-версия)',
	'mobile-frontend-placeholder-alpha' => 'Поиск по {{grammar:genitive|{{SITENAME}}}} (режим драконов)',
	'mobile-frontend-search-help' => 'Введите выше искомый термин, и здесь отобразятся совпадающие с ним заголовки страниц.',
	'mobile-frontend-dismiss-notification' => 'скрыть это уведомление',
	'mobile-frontend-clear-search' => 'Очистить',
	'mobile-frontend-privacy-link-text' => 'Конфиденциальность',
	'mobile-frontend-about-link-text' => 'Описание',
	'mobile-frontend-footer-sitename' => '{{SITENAME}}',
	'mobile-frontend-footer-license-text' => 'Содержание доступно по лицензии [//en.m.wikipedia.org/wiki/Wikipedia:Text_of_Creative_Commons_Attribution-ShareAlike_3.0_Unported_License?useformat=mobile">CC BY-SA 3.0]',
	'mobile-frontend-terms-use-text' => '[//wikimediafoundation.org/wiki/Terms_of_use/ru?useformat=mobile Условия использования]',
	'mobile-frontend-footer-contact' => 'Контактная информация',
	'mobile-frontend-search-noresults' => 'Нет страниц, названия которых соответствуют вашему запросу. Измените свой запрос, или нажмите на клавиатуре кнопку для поиска внутри страниц.',
	'mobile-frontend-main-menu-button-tooltip' => 'Открыть главное меню',
	'mobile-frontend-main-menu-page-title' => 'Навигация по сайту',
	'mobile-frontend-main-menu-featured' => 'Избранное',
	'mobile-frontend-main-menu-nearby' => 'Рядом',
	'mobile-frontend-main-menu-login' => 'Представиться системе',
	'mobile-frontend-main-menu-logout' => 'Выйти',
	'mobile-frontend-main-menu-watchlist' => 'Список наблюдения',
	'mobile-frontend-main-menu-settings' => 'Настройки',
	'mobile-frontend-main-menu-upload' => 'Загрузить',
	'mobile-frontend-main-menu-settings-heading' => 'Настройки мобильной версии сайта',
	'mobile-frontend-settings-site-header' => 'Языки проекта «{{SITENAME}}»',
	'mobile-frontend-settings-site-description' => 'Проект «{{SITENAME}}» доступен на $1 {{PLURAL:$1|языке|языках|языках}}. Ниже перечислены все доступные версии',
	'mobile-frontend-main-menu-contact' => 'Контактная информация',
	'mobile-frontend-main-menu-account-create' => 'Создать учётную запись',
	'mobile-frontend-page-menu-contents' => 'содержание',
	'mobile-frontend-page-menu-history' => 'История',
	'mobile-frontend-meta-data-issues-header' => 'Вопросы',
	'mobile-frontend-meta-data-issues' => 'Насчёт данной страницы имеются вопросы.',
	'mobile-frontend-ajax-page-loading' => 'Загрузка $1',
	'mobile-frontend-page-saving' => 'Сохранение $1',
	'mobile-frontend-ajax-page-error' => 'Ой! Что-то пошло не так. Пожалуйста, попробуйте обновить окно браузера.',
	'mobile-frontend-nearby-title' => 'Рядом',
	'mobile-frontend-nearby-loading' => 'Загрузка информации о том, что находится невдалеке от вас',
	'mobile-frontend-nearby-requirements' => 'Эта страница требует, чтобы был включён JavaScript и браузер мог получать информацию о местоположении.',
	'mobile-frontend-nearby-distance-report' => '$1 км от вашего текущего местоположения',
	'mobile-frontend-nearby-lookup-error' => 'Не удаётся определить ваше местоположение. Попробуйте еще раз..',
	'mobile-frontend-nearby-noresults' => 'Вы находитесь в центре неизвестности, и нам не удалось найти никаких подходящих тем. Почему бы вам не написать что-либо?',
	'mobile-frontend-nearby-refresh' => 'Мы определили ваше местоположение точнее. Нажмите здесь, чтобы обновить список ближайших страниц',
	'mobile-frontend-nearby-error' => 'Произошла неожиданная ошибка при попытке найти страницы, связанные с вашим местоположением',
	'mobile-frontend-donate-image-login' => 'Войти для просмотра ваших заливок',
	'mobile-frontend-photo-upload-generic' => 'Пожертвовать изображение',
	'mobile-frontend-donate-image-title' => 'Пожертвовать изображение',
	'mobile-frontend-donate-image-summary' => 'Фотографии оживляют страницы проекта {{SITENAME}}.
Здесь много страниц, которые не содержат иллюстраций по причине острой нехватки фотографий со свободными лицензиями.
Помогите оживить эти страницы, пожертвовав свои изображения, которыми вы готовы поделиться для того, чтобы сообщество редакторов проекта {{SITENAME}} могло ими воспользоваться.',
	'mobile-frontend-donate-image-heading' => 'Ваши последние правки',
	'mobile-frontend-donate-image-page-title' => 'Загрузить',
	'mobile-frontend-donate-image-anon' => 'Для просмотра страницы закачек требуется [[Special:UserLogin|учетная запись пользователя]]',
	'mobile-frontend-listed-image-no-description' => 'Нет описания',
	'mobile-frontend-donate-photo-upload-success' => 'Получилось! Ваше изображние может быть использован на сайте {{SITENAME}}!',
	'mobile-frontend-donate-photo-first-upload-success' => 'Получилось! Спасибо за ваш вклад!',
	'mobile-frontend-watchlist-add' => '$1 добавлена в ваш список наблюдения',
	'mobile-frontend-watchlist-removed' => '$1 удалена из вашего списка наблюдения',
	'mobile-frontend-watchlist-view' => 'Просмотреть свой список наблюдения',
	'mobile-frontend-watchlist-more' => 'далее',
	'mobile-frontend-watchlist-cta' => 'Пожалуйста, авторизуйтесь или зарегистрируйтесь, чтобы посмотреть эту страницу.',
	'mobile-frontend-watchlist-cta-button-login' => 'Представиться',
	'mobile-frontend-watchlist-cta-button-signup' => 'Зарегистрироваться',
	'mobile-frontend-watchlist-a-z' => 'Все',
	'mobile-frontend-watchlist-feed' => 'Изменено',
	'mobile-frontend-watchlist-a-z-empty' => 'В настоящее время вы не следите ни за одной страницей',
	'mobile-frontend-watchlist-a-z-empty-howto-alt' => 'Нажмите на звёздочку в верхней части страницы',
	'mobile-frontend-watchlist-a-z-empty-howto' => 'Можно следить за страницей, которой вы заинтересовались, нажав на значок в виде звёздочки в верхней части экрана. Это позволит вам добавлять в закладки интересующие страницы, а также видеть, когда они были изменены.',
	'mobile-frontend-watchlist-feed-empty' => 'Отсутствуют страницы с последними изменениями',
	'mobile-frontend-watchlist-back-home' => 'Домой',
	'mobile-frontend-changeslist-ip' => 'Анонимный участник',
	'mobile-frontend-changeslist-nocomment' => 'Нет описания правки',
	'mobile-frontend-watchlist-filter-all' => 'Всё',
	'mobile-frontend-watchlist-filter-articles' => 'Статьи',
	'mobile-frontend-watchlist-filter-talk' => 'Обсуждения',
	'mobile-frontend-watchlist-filter-other' => 'Прочее',
	'mobile-frontend-watchlist-modified' => 'Изменено $1',
	'mobile-frontend-diffview-404-title' => 'Некорректная ссылка на версию',
	'mobile-frontend-diffview-404-desc' => 'Не существует версии с запрошенным вами идентификатором',
	'mobile-frontend-diffview-title' => 'Изменения',
	'mobile-frontend-diffview-editcount' => '$1 {{PLURAL:$1|правка|правки|правок}}',
	'mobile-frontend-diffview-anonymous' => 'Анонимный участник',
	'mobile-frontend-diffview-bytesadded' => '$1 {{PLURAL:$1|байт|байта|байтов}} добавлено',
	'mobile-frontend-diffview-bytesremoved' => '$1 {{PLURAL:$1|байт|байта|байтов}} убрано',
	'mobile-frontend-diffview-explained' => 'Следующие строки были добавлены (+) и удалены (-):',
	'mobile-frontend-table' => 'Таблица $1',
	'mobile-frontend-saving-exit-page' => 'Ваша правка всё ещё сохраняется. Если вы покинете страницу, ваши изменения будут потеряны. Вы уверены, что хотите уйти?',
	'mobile-frontend-photo-upload' => 'Добавить на эту страницу изображение',
	'mobile-frontend-photo-article-edit-comment' => 'Добавлена фотография для использования на странице',
	'mobile-frontend-photo-article-donate-comment' => 'Пожертвовал изображение с мобильного устройства',
	'mobile-frontend-photo-upload-comment' => 'Добавлена фотография на страницу',
	'mobile-frontend-photo-caption-placeholder' => 'Добавить описание (обязательно)',
	'mobile-frontend-image-loading' => 'Изображение загружается',
	'mobile-frontend-image-uploading-wait' => 'Загрузка изображения, подождите пожалуйста.', # Fuzzy
	'mobile-frontend-photo-upload-error' => 'Ошибка, попробуйте заново.',
	'mobile-frontend-photo-upload-success-article' => 'Загрузка удалась! Теперь ваше изображение размещено на этой странице.',
	'mobile-frontend-photo-license' => 'Примечание: Все публикуемые вами фотографии будут опубликованы под [//en.wikipedia.org/wiki/Wikipedia:Text_of_Creative_Commons_Attribution-ShareAlike_3.0_Unported_License лицензией CC BY-SA 3.0]', # Fuzzy
	'mobile-frontend-photo-submit' => 'Отправить',
	'mobile-frontend-photo-cancel' => 'Отмена',
	'tag-mobile_edit' => 'Правка с моб. устройства',
	'tag-mobile_edit-description' => 'Правки, сделанные через мобильнвую версию сайта',
	'mobile-frontend-drawer-cancel' => 'Отмена',
);

/** Rusyn (русиньскый)
 * @author Gazeb
 */
$messages['rue'] = array(
	'mobile-frontend-desc' => 'Мобілный інтерфейс',
	'mobile-frontend-search-submit' => 'Перейти',
	'mobile-frontend-home-button' => 'Домів',
	'mobile-frontend-logged-out' => 'Неприголошеный(а)',
	'mobile-frontend-settings-description' => 'Наштелюйте мобільну верзію якназручнїше.',
	'mobile-frontend-settings-beta' => 'Бета',
	'mobile-frontend-save-settings' => 'Уложыти наставлїня',
	'mobile-frontend-random-button' => 'Трафункова',
	'mobile-frontend-back-to-top-of-section' => 'Вернути ся о секцію назад',
	'mobile-frontend-close-section' => 'Заперти тоту секцію',
	'mobile-frontend-show-button' => 'Вказати',
	'mobile-frontend-hide-button' => 'Сховати',
	'mobile-frontend-empty-homepage-text' => 'Тота домашня сторінка мусить быти переконфіґурована. <a href="http://meta.wikimedia.org/wiki/Mobile_Projects/Mobile_Gateway#Mobile_homepage">Далшы інформації як тоту сторінку позволити мобілом</a>', # Fuzzy
	'mobile-frontend-regular-site' => 'Штандартне зображіня сторінкы',
	'mobile-frontend-wml-continue' => 'Дале ...',
	'mobile-frontend-wml-back' => 'Назад...',
	'mobile-frontend-view' => 'Мобілна верзія',
	'mobile-frontend-view-desktop' => 'Десктоп',
	'mobile-frontend-view-mobile' => 'Мобільный',
	'mobile-frontend-opt-in-explain' => 'Припоїнём к бетатесту здобудете доступ к експеріменталным функціям, але з різіком, же трафите на хыбы і проблемы.',
	'mobile-frontend-images-status' => 'Образчікы',
	'mobile-frontend-disable-images' => 'Выпнути образчікы в мобілній верзії',
	'mobile-frontend-enable-images' => 'Занути образчікы в мобілній верзії',
	'mobile-frontend-off' => 'ВЫП',
	'mobile-frontend-on' => 'ЗАП',
	'mobile-frontend-footer-contributors-text' => 'Статї од <a href="$1">приспівателїв</a> як вы', # Fuzzy
	'mobile-frontend-featured-article' => 'Статя дня',
	'mobile-frontend-news-items' => 'Новины',
	'mobile-frontend-leave-feedback-notice' => 'Ваша одозва помагать вылїпшати вашы зажыткы з мобілным сайтом. Ваша одозва буде публікована, вєдно з вашым іменом хоснователя, верзіёв перезерача і операчнов сістемов on the page "$1". Просине, звольте інформачно достаточный рядок темы, наприклад "Проблемы з форматованём шыршых таблиць". Ваша одозва є у одповідности до нашых условій схоснованя.',
	'mobile-frontend-leave-feedback-warning' => 'Кідь не мате дяку тоты інформації опубліковати, не ладуйте до коментаря пріватны інформації.',
	'mobile-frontend-leave-feedback-subject' => 'Тема:',
	'mobile-frontend-leave-feedback-message' => 'Повідомлїня:',
	'mobile-frontend-leave-feedback-submit' => 'Одослати одозву',
	'mobile-frontend-leave-feedback-link-text' => 'Одозва про мобілный інтерфейс',
	'mobile-frontend-leave-feedback' => 'Зохабити одозву',
	'mobile-frontend-leave-feedback-title' => 'Здїляйте нам вашы скусености з мобілным інтерфейсом',
	'mobile-frontend-leave-feedback-technical-problem-section-header' => 'Технічный проблем',
	'mobile-frontend-leave-feedback-general-section-header' => 'Обще',
	'mobile-frontend-leave-feedback-article-feedback-section-header' => 'Одозва на статю',
	'mobile-frontend-leave-feedback-email-body' => 'Просиме, жебы сьте свій імейл написали высше того рядка.', # Fuzzy
	'mobile-frontend-leave-feedback-technical-link-text' => 'Технічный проблем',
	'mobile-frontend-leave-feedback-general-link-text' => 'Общій погляд',
	'mobile-frontend-leave-feedback-article-personal-link-text' => 'Дотуляюче ся мене, персоны або компанію, котру заступую',
	'mobile-frontend-leave-feedback-article-factual-link-text' => 'Дотуляюче ся фактічной хыбы',
	'mobile-frontend-leave-feedback-article-other-link-text' => 'Дотуляюче ся другого проблему',
	'mobile-frontend-leave-feedback-form-subject-placeholder' => 'Тема повідомлїня',
	'mobile-frontend-leave-feedback-form-message-placeholder' => 'Гев напиште свій коментарь',
	'mobile-frontend-leave-feedback-page-title' => 'Здїляйте нам вашы скусености з мобілным інтерфейсом',
	'mobile-frontend-leave-feedback-special-title' => 'Спойте ся з нами',
	'mobile-frontend-feedback-no-subject' => '(нїт темы)',
	'mobile-frontend-feedback-no-subject-field' => 'Просиме, уведьте тему.',
	'mobile-frontend-feedback-no-message' => 'Просиме, уведьте гев повідомлїня',
	'mobile-frontend-feedback-edit-summary' => '$1 – автоматічно вложене за помочі [[Special:MobileFeedback|інштрументы коментарїв з мобіла]]',
	'mobile-frontend-leave-feedback-thanks' => 'Дякуєме за ваш погляд!',
	'mobile-frontend-leave-feedback-post-error' => 'Під час спрацованя вашого повідомлїня дішло к хыбі. Попробукте то знова кус пізнїше.',
	'mobile-frontend-language' => 'Язык:',
	'mobile-frontend-language-header' => 'Статя доступна в $1 {{PLURAL:$1|языцї|языках}}', # Fuzzy
	'mobile-frontend-language-footer' => '{{SITENAME}} є доступна в далшых языках.', # Fuzzy
	'mobile-frontend-language-site-choose' => 'Гляданя языка',
	'mobile-frontend-username' => 'Імя хоснователя:',
	'mobile-frontend-password' => 'Гесло:',
	'mobile-frontend-login' => 'Приголосити ся',
	'mobile-frontend-placeholder' => 'Глядати {{SITENAME}}',
	'mobile-frontend-search-help' => 'Горї уведьте гляданый термін, тай гев будуть назвы одповідных статей.', # Fuzzy
	'mobile-frontend-dismiss-notification' => 'заперти гевто повідомлїня',
	'mobile-frontend-clear-search' => 'Очістити',
	'mobile-frontend-privacy-link-text' => 'Охорона пріватности',
	'mobile-frontend-about-link-text' => 'О',
	'mobile-frontend-footer-sitename' => '{{SITENAME}}',
	'mobile-frontend-footer-contact' => 'Контакт',
	'mobile-frontend-search-noresults' => 'Вашому гляданю не одповідають ниякы назвы статей. Зміньте ваше гляданя або стистийте клапку гляданя внутрї статей.', # Fuzzy
	'mobile-frontend-main-menu-featured' => 'Выбране',
	'mobile-frontend-main-menu-nearby' => 'Наблизко',
	'mobile-frontend-main-menu-settings' => 'Наставлїня',
	'mobile-frontend-main-menu-settings-heading' => 'Наштелёваня мобілной верзії',
	'mobile-frontend-settings-site-header' => 'Языкы {{grammar:2sg|{{SITENAME}}}}',
	'mobile-frontend-settings-site-description' => '{{SITENAME}} є доступна в $1 {{PLURAL:$1|языцї|языках}}. Ниже суть зазначены вшыткы доступны верзії',
	'mobile-frontend-main-menu-contact' => 'Контакт',
	'mobile-frontend-page-menu-contents' => 'обсяг',
	'mobile-frontend-page-menu-history' => 'Історія',
);

/** Sanskrit (संस्कृतम्)
 * @author Ansumang
 * @author Shubha
 */
$messages['sa'] = array(
	'mobile-frontend-desc' => 'जङ्गमदूरवाणी-मुखान्त्यम्',
	'mobile-frontend-search-submit' => 'गम्यताम्',
	'mobile-frontend-home-button' => 'गृहम्',
	'mobile-frontend-logged-out' => 'न सम्प्रविष्टम्',
	'mobile-frontend-settings-description' => 'भवतः अनुभवान् जङ्गमोपकरणे अधोनिर्दिष्टैः क्षेत्रलक्षणैः व्यवस्थापयतु ।',
	'mobile-frontend-settings-beta' => 'उपान्त्यम्',
	'mobile-frontend-save-settings' => 'नियोजनं रक्ष्यताम्',
	'mobile-frontend-random-button' => 'यादृच्छिकम्',
	'mobile-frontend-back-to-top-of-section' => 'पृष्ठतः अध्यायं प्रति गम्यताम्',
	'mobile-frontend-close-section' => 'अयं भागः पिधीयताम्',
	'mobile-frontend-show-button' => 'दर्श्यताम्',
	'mobile-frontend-hide-button' => 'गोप्यताम्',
	'mobile-frontend-empty-homepage-text' => 'अस्य मूलपृष्ठस्य विन्यासः करणीयः । <a href="http://meta.wikimedia.org/wiki/Mobile_Projects/Mobile_Gateway#Mobile_homepage">इदं क्षेत्रं कथं जङ्गमोपकरणे सक्रियं करणीयमिति सूचनाः</a>', # Fuzzy
	'mobile-frontend-regular-site' => 'उत्पीठदृश्यम्',
	'mobile-frontend-wml-continue' => 'अनुवर्त्यते.....',
	'mobile-frontend-wml-back' => 'प्रतिनिर्वर्तनम्.....',
	'mobile-frontend-view' => 'जङ्गमदूरवाणी-दृश्यम्',
	'mobile-frontend-view-desktop' => 'उत्पीठम्',
	'mobile-frontend-view-mobile' => 'जङ्गमदूरवाणी',
	'mobile-frontend-opt-in-explain' => 'उपान्त्य(बीटा)प्रवेशेन भवता प्रयोगात्मकविशेषताः द्रष्टुं शक्याः भवन्ति । किन्तु दोषाणां समस्यानां सम्भवाः अपि विद्यन्ते एव ।',
	'mobile-frontend-images-status' => 'चित्राणि',
	'mobile-frontend-disable-images' => 'चरक्षेत्रे चित्राणि निष्क्रियानि क्रियन्ताम्',
	'mobile-frontend-enable-images' => 'चरक्षेत्रे चित्राणि सक्रियाणि क्रियन्ताम्',
	'mobile-frontend-off' => 'निर्वापणम्',
	'mobile-frontend-on' => 'प्रचालनम्',
	'mobile-frontend-footer-contributors-text' => 'भवादृशैः <a href="$1">योजकैः</a> लिखितः लेखः', # Fuzzy
	'mobile-frontend-featured-article' => 'अद्यतनः प्रमुखः लेखः',
	'mobile-frontend-news-items' => 'वार्तायाम्',
	'mobile-frontend-leave-feedback-notice' => 'भवतः प्रतिस्पन्दः उत्तमजङ्गमक्षेत्रानुभवदाने सहकरोति । इदं &quot;$1&quot; पृष्ठे सार्वजनिकरूपेण (भवतः योजकनाम, जालगवेशकसंस्करणं, कारकसंविधा - विवरणैः सह) प्रकाश्यते । कृपया विवरणयुक्तविषयपङ्क्तिः चीयताम्, उदा "Formatting issues with wide tables"। भवतः प्रतिस्पन्दः अस्माकम् उपयोगनियमान् अनुसरेत् ।',
	'mobile-frontend-leave-feedback-warning' => 'भवतः विषयः सार्वजनिकाः भवन्तु इति भवता अङ्गीक्रियेत चेदेव अत्र अभिप्रायलेखनावसरे स्वविवरणं लेखितुम् अर्हति ।',
	'mobile-frontend-leave-feedback-subject' => 'विषयः',
	'mobile-frontend-leave-feedback-message' => 'सन्देशः :',
	'mobile-frontend-leave-feedback-submit' => 'प्रतिस्पन्दः प्रेष्यताम्',
	'mobile-frontend-leave-feedback-link-text' => 'मोबैल्-फ़्रण्टेण्ड्-एक्स्टेंशन् प्रतिस्पन्दः',
	'mobile-frontend-leave-feedback' => 'चरक्षेत्रानुभवविषये लिख्यताम्',
	'mobile-frontend-leave-feedback-title' => 'चरक्षेत्रानुभवविषये लिख्यताम्',
	'mobile-frontend-leave-feedback-technical-problem-section-header' => 'तान्त्रिकसमस्या',
	'mobile-frontend-leave-feedback-general-section-header' => 'सामान्यम्',
	'mobile-frontend-leave-feedback-article-feedback-section-header' => 'लेख-प्रतिस्पन्दः',
	'mobile-frontend-leave-feedback-email-body' => 'अस्याः पङ्क्तेः उपरि भवतः ईपत्रसङ्केतः लिख्यताम् ।', # Fuzzy
	'mobile-frontend-leave-feedback-technical-link-text' => 'तान्त्रिकसमस्या',
	'mobile-frontend-leave-feedback-general-link-text' => 'सामान्यप्रतिस्पन्दः',
	'mobile-frontend-leave-feedback-article-personal-link-text' => 'मद्विषये, व्यक्तिरूपेण, संस्थायाः प्रतिनिधिरूपेण वा',
	'mobile-frontend-leave-feedback-article-factual-link-text' => 'वास्तविकदोषविषये',
	'mobile-frontend-leave-feedback-article-other-link-text' => 'अन्यसमस्यायाः विषये',
	'mobile-frontend-leave-feedback-form-subject-placeholder' => 'सन्देशविषयः',
	'mobile-frontend-leave-feedback-form-message-placeholder' => 'भवदीयः अभिप्रायः अत्र लिख्यताम्',
	'mobile-frontend-leave-feedback-page-title' => 'चरक्षेत्रानुभवविषये लिख्यताम्',
	'mobile-frontend-leave-feedback-special-title' => 'अस्माकं सम्पर्कः क्रियताम्',
	'mobile-frontend-feedback-no-subject' => '(न कोपि विषयः)',
	'mobile-frontend-feedback-no-subject-field' => 'कृपया विषयः निर्दिश्यताम्',
	'mobile-frontend-feedback-no-message' => 'कृपया अत्र सन्देशः लिख्यताम्',
	'mobile-frontend-feedback-edit-summary' => '[[Special:MobileFeedback|mobile feedback tool]] इत्येतत् उपयुज्य $1 स्वयं प्रेषितम्',
	'mobile-frontend-leave-feedback-thanks' => 'प्रतिस्पन्दाय धन्यवादः !',
	'mobile-frontend-leave-feedback-post-error' => 'भवतः सन्दॆशस्य प्रापणे दोषः जातः । पुनः प्रयतताम् ।',
	'mobile-frontend-language' => 'भाषा :',
	'mobile-frontend-language-header' => 'अयं लेखः $1 {{PLURAL:$1|lभाषा|भाषाः}} इत्यत्र उपलभ्यते', # Fuzzy
	'mobile-frontend-language-footer' => '{{SITENAME}} इदम् अन्यासु भाषासु उपलभ्यते ।', # Fuzzy
	'mobile-frontend-language-site-choose' => 'भाषायाः अन्वेषणम्',
	'mobile-frontend-username' => 'योजकनाम:',
	'mobile-frontend-password' => 'कूटशब्दः',
	'mobile-frontend-login' => 'सम्प्रवेशः',
	'mobile-frontend-placeholder' => '{{SITENAME}} अत्र अन्विष्यताम्',
	'mobile-frontend-search-help' => 'अन्वेषणपदम् उपरि लिख्यताम्, सदृशाः लेखाः अधः दृश्यन्ते ।', # Fuzzy
	'mobile-frontend-dismiss-notification' => 'इयं सूचना निराक्रियताम्',
	'mobile-frontend-clear-search' => 'स्वच्छीक्रियताम्',
	'mobile-frontend-privacy-link-text' => 'व्यक्तिगतम्',
	'mobile-frontend-about-link-text' => 'तद्विषये ।',
	'mobile-frontend-footer-sitename' => '{{SITENAME}}',
	'mobile-frontend-footer-contact' => 'सम्पर्कः',
	'mobile-frontend-search-noresults' => 'किमपि लेखशिरोनाम अन्वेषणपदसादृश्यं नास्ति । अन्वेषणं परिवर्त्यताम् अथवा लेखस्य अन्तः अन्वेषणाय कीलफलकस्य अन्वेषणकुड्मलं नुद्यताम् ।', # Fuzzy
	'mobile-frontend-main-menu-featured' => 'प्रमुखम्',
	'mobile-frontend-main-menu-nearby' => 'निकटम् ।',
	'mobile-frontend-main-menu-settings' => 'संरचनम्',
	'mobile-frontend-main-menu-settings-heading' => 'जङ्गमक्षेत्रसन्निवेशः',
	'mobile-frontend-settings-site-header' => '{{SITENAME}} भाषाः',
	'mobile-frontend-settings-site-description' => '$1 {{PLURAL:$1|भाषायां|भाषासु}} {{SITENAME}} उपलभ्यते । लभ्यमानाः आवृत्तयः अधः सूचिताः ।',
	'mobile-frontend-main-menu-contact' => 'सम्पर्कः',
	'mobile-frontend-page-menu-contents' => 'अन्तर्विषयाः',
	'mobile-frontend-page-menu-history' => 'इतिहासः',
);

/** Sakha (саха тыла)
 * @author HalanTul
 */
$messages['sah'] = array(
	'mobile-frontend-desc' => 'Мобильнай интерфейс',
	'mobile-frontend-search-submit' => 'Таһаар',
	'mobile-frontend-home-button' => 'Дьиэлээ',
	'mobile-frontend-random-button' => 'Түбэспиччэ',
	'mobile-frontend-back-to-top-of-section' => 'Биир салаанан кэнники бар',
	'mobile-frontend-show-button' => 'Көрдөр',
	'mobile-frontend-hide-button' => 'Кистээ',
	'mobile-frontend-regular-site' => 'Сирэйи көннөрү {{SITENAME}}ҕэ көр', # Fuzzy
	'mobile-frontend-wml-continue' => 'Салгыы...',
	'mobile-frontend-wml-back' => 'Төнүн...',
	'mobile-frontend-view' => 'Мобил барыла',
	'mobile-frontend-opt-in-explain' => 'Бета-тургутууга холбостоххуна сорох тургутуу кыахтары туһанар буолуоҥ, ол гынан баран алҕаһы көрсөрүҥ элбиэн сөп.',
	'mobile-frontend-disable-images' => 'Мобил ситим-сир ойууларын араар',
	'mobile-frontend-enable-images' => 'Мобил ситим-сир ойууларын холбоо',
	'mobile-frontend-featured-article' => 'Бүгүҥҥү талыы ыстатыйа',
	'mobile-frontend-news-items' => 'Сонуннар',
	'mobile-frontend-leave-feedback-notice' => 'Мобил ситим-сир туһунан суруйдаххына кини тупсарыгар көмөлөһүөҥ. Суруйбутуҥ дьоҥҥо манна &quot;$1&quot; көстүө (аатыҥ-суолуҥ, барузерыҥ барыла, операционнай систиэмэҥ). Бука диэн, чопчулуу сатаа, холобур «вопросы форматирования широких таблиц». Суруйууҥ туттуу сиэригэр сөп түбэһиэхтээх.',
	'mobile-frontend-leave-feedback-subject' => 'Сурук аата:', # Fuzzy
	'mobile-frontend-leave-feedback-message' => 'Сурук', # Fuzzy
	'mobile-frontend-leave-feedback-submit' => 'Ыыт',
	'mobile-frontend-leave-feedback-link-text' => 'Мобил интерфейс туһунан санаалар',
	'mobile-frontend-leave-feedback' => 'Санааны этии',
	'mobile-frontend-leave-feedback-title' => 'Мобил интерфейс туһунан суруйуу',
	'mobile-frontend-leave-feedback-page-title' => 'Мобил интерфейс туһунан суруйуу',
	'mobile-frontend-leave-feedback-thanks' => 'Санааҕын эппиккэр махтал!',
	'mobile-frontend-language' => 'Омук тыла', # Fuzzy
	'mobile-frontend-username' => 'Кытааччы аата:',
	'mobile-frontend-password' => 'Киирии тыла:',
	'mobile-frontend-login' => 'Киир',
	'mobile-frontend-placeholder' => 'Көрдөбүл устуруоката...', # Fuzzy
	'mobile-frontend-dismiss-notification' => 'бу биллэриини кистээ',
	'mobile-frontend-clear-search' => 'Сот',
);

/** Sicilian (sicilianu)
 * @author Aushulz
 * @author Gmelfi
 */
$messages['scn'] = array(
	'mobile-frontend-desc' => 'Ntirfaccia mòbbili',
	'mobile-frontend-search-submit' => 'Và trova',
	'mobile-frontend-home-button' => 'Pàggina principali',
	'mobile-frontend-random-button' => 'Na pàggina a muzzu',
	'mobile-frontend-back-to-top-of-section' => 'Vai â ccuminzata dû paràgrufu',
	'mobile-frontend-show-button' => 'Ammustra',
	'mobile-frontend-hide-button' => 'Ammuccia',
	'mobile-frontend-empty-homepage-text' => 'Sta pàggina havi a siri cunfigurata. <a href="http://meta.wikimedia.org/wiki/Mobile_Projects/Mobile_Gateway#Mobile_homepage">Pi sapìrinni cchiossai</a>', # Fuzzy
	'mobile-frontend-regular-site' => 'Disattivari la virsioni mòbbili',
	'mobile-frontend-wml-continue' => 'Camina...',
	'mobile-frontend-wml-back' => 'Narreri',
	'mobile-frontend-view' => 'Virsioni mòbbili',
	'mobile-frontend-view-desktop' => 'Desktop',
	'mobile-frontend-view-mobile' => 'Mòbbili',
	'mobile-frontend-opt-in-explain' => 'Participannu â virsioni beta, ci hai la pussibbilitati di usari funziunalitati spririmintali, ma cô rìsicu di ncuntrari errura e prubblemi',
	'mobile-frontend-disable-images' => 'Disabbìlita li mmàggini supra lu situ pi dispusitivi mòbbili',
	'mobile-frontend-enable-images' => 'Abbilita li mmàggini supra lu situ pi dispusitivi mòbbili',
	'mobile-frontend-off' => 'OFF',
	'mobile-frontend-on' => 'ON',
	'mobile-frontend-footer-contributors-text' => 'Articulu di <a href="$1">cuntribbutura</a> comu a vossìa', # Fuzzy
	'mobile-frontend-featured-article' => 'Vitrina',
	'mobile-frontend-news-items' => 'Attualitati',
	'mobile-frontend-leave-feedback-notice' => 'Li tò cummenti ni aiutanu a dari cchiossai saddisfazzioni pi lu situ pi dispusitivi mòbbili. Veni pubbricatu (nsemmula ô tò nomu di utilizzaturi, virsioni dû browser e sistema upirativu) supra la pàggina &quot;$1&quot;. Pi favuri, scigghi n\'uggettu discrittivu (pi esempiu "Prubblemi di furmattazzioni chê tabbelli làrichi"). Lu tò cummentu è suggettu ê cunnizzioni d\'usu.',
	'mobile-frontend-leave-feedback-subject' => 'Uggettu:',
	'mobile-frontend-leave-feedback-message' => 'Missaggiu:',
	'mobile-frontend-leave-feedback-submit' => 'Suttametti lu cummentu',
	'mobile-frontend-leave-feedback-link-text' => "Cummenta supra l'estintioni interfaccia pi dispusitivi mòbbili",
	'mobile-frontend-leave-feedback' => 'Cummenti supra lu situ pi dispusitivi mòbbili',
	'mobile-frontend-leave-feedback-title' => 'Feedback pô situ pi dispusitivi mòbbili',
	'mobile-frontend-leave-feedback-technical-problem-section-header' => 'Prubblema tecnicu',
	'mobile-frontend-leave-feedback-general-section-header' => 'Ginirali',
	'mobile-frontend-leave-feedback-article-feedback-section-header' => "Valutazzioni di l'articulu",
	'mobile-frontend-leave-feedback-general-link-text' => 'Cummentu ginirali',
	'mobile-frontend-leave-feedback-article-personal-link-text' => 'Pi mìa, na pirsuna o la sucità ca arrapprisentu',
	'mobile-frontend-leave-feedback-article-factual-link-text' => "Pi quantu arriguarda n'erruri di fattu",
	'mobile-frontend-leave-feedback-article-other-link-text' => "Pi quantu arriguarda n'àutri prubblema",
	'mobile-frontend-leave-feedback-form-subject-placeholder' => 'Oggettu dû missaggiu',
	'mobile-frontend-leave-feedback-form-message-placeholder' => 'Scrivi lu tò cummentu ccà',
	'mobile-frontend-leave-feedback-page-title' => 'Cummenti supra lu situ pi dispusitivi mòbbili',
	'mobile-frontend-leave-feedback-special-title' => 'Pigghia cuntattu cu nuatri',
	'mobile-frontend-feedback-no-subject' => '(senza uggettu)',
	'mobile-frontend-feedback-no-subject-field' => "Pi favuri metti n'uggettu",
	'mobile-frontend-feedback-no-message' => 'Scriviti lu missaggiu ccà',
	'mobile-frontend-feedback-edit-summary' => '$1 - pubbricatu autumaticamenti utilizzannu lu [[Special:MobileFeedback|strummentu pi la valutazzioni dî dispusitivi mòbbili]]',
	'mobile-frontend-leave-feedback-thanks' => 'Grazzi pi lu tò cummentu',
	'mobile-frontend-language' => 'Lingua:',
	'mobile-frontend-username' => 'Utenti:',
	'mobile-frontend-password' => 'Parola chiavi:',
	'mobile-frontend-login' => 'Trasi',
	'mobile-frontend-placeholder' => 'Dìggita la to circata ccà...', # Fuzzy
	'mobile-frontend-dismiss-notification' => 'Riggetta sta nutificazzioni',
	'mobile-frontend-clear-search' => 'Scancella',
	'mobile-frontend-privacy-link-text' => 'Cunfidinzialitati',
	'mobile-frontend-about-link-text' => 'Nfurmazzioni',
	'mobile-frontend-footer-sitename' => '{{SITENAME}}',
	'mobile-frontend-footer-contact' => 'Cuntatti',
);

/** Serbo-Croatian (srpskohrvatski / српскохрватски)
 */
$messages['sh'] = array(
	'mobile-frontend-search-submit' => 'Idi',
	'mobile-frontend-home-button' => 'Početna',
	'mobile-frontend-random-button' => 'Slučajna',
	'mobile-frontend-back-to-top-of-section' => 'Skoči nazad za jednu sekciju',
	'mobile-frontend-show-button' => 'Pokaži',
	'mobile-frontend-hide-button' => 'Sakrij',
	'mobile-frontend-regular-site' => 'Pogledaj ovu stranicu na običnoj Wikipediji', # Fuzzy
	'mobile-frontend-featured-article' => 'Odabrani članak',
);

/** Tachelhit (Tašlḥiyt/ⵜⴰⵛⵍⵃⵉⵜ)
 */
$messages['shi'] = array(
	'mobile-frontend-home-button' => 'Asbrk',
	'mobile-frontend-back-to-top-of-section' => 'Urrid s yan wayyaw',
	'mobile-frontend-show-button' => 'Mel',
	'mobile-frontend-hide-button' => 'Ḥbu',
	'mobile-frontend-regular-site' => 'Ml tasna yad ɣ wikipidya tamqrant', # Fuzzy
	'mobile-frontend-featured-article' => 'Isisfiwn f ...',
);

/** Sinhala (සිංහල)
 * @author Singhalawap
 * @author පසිඳු කාවින්ද
 * @author බිඟුවා
 * @author ශ්වෙත
 */
$messages['si'] = array(
	'mobile-frontend-desc' => 'ජංගම ඉදිරිපස',
	'mobile-frontend-search-submit' => 'යන්න',
	'mobile-frontend-home-button' => 'මුල් පිටුව',
	'mobile-frontend-logged-out' => 'ප්‍රවිෂ්ට වී නොමැත',
	'mobile-frontend-logged-in-homepage-notification' => 'ආයුබෝවන්, $1!',
	'mobile-frontend-logged-in-toast-notification' => '$1 ලෙස ප්‍රවිෂ්ට වී.',
	'mobile-frontend-sign-up-heading' => 'ලියාපදිංචි වන්න',
	'mobile-frontend-sign-in-heading' => 'පිවිසෙන්න',
	'mobile-frontend-sign-in-why' => 'ඔබ සතුව {{SITENAME}} ගිණුමක් ඇත, ඔබ පහතින් පිවිසිය යුතු වේ.',
	'mobile-frontend-sign-in-error-heading' => 'අයියෝ',
	'mobile-frontend-settings-beta' => 'බීටා',
	'mobile-frontend-save-settings' => 'සැකසුම් සුරකින්න',
	'mobile-frontend-random-button' => 'අහඹු',
	'mobile-frontend-ajax-random-heading' => 'ඥානය නිශ්චයනය කරමින්...',
	'mobile-frontend-ajax-random-question' => 'මෙම පිටුව කියවනවද?',
	'mobile-frontend-ajax-random-yes' => 'ඔව්',
	'mobile-frontend-ajax-random-retry' => 'නැවත උත්සහ කරන්න',
	'mobile-frontend-ajax-random-suggestions' => 'වෙනත් යෝජනාවන්:',
	'mobile-frontend-back-to-top-of-section' => 'කොටසක් ආපසු යන්න',
	'mobile-frontend-close-section' => 'මෙම ඒකකය වසන්න',
	'mobile-frontend-show-button' => 'පෙන්වන්න',
	'mobile-frontend-hide-button' => 'සඟවන්න',
	'mobile-frontend-regular-site' => 'වැඩතල දසුන',
	'mobile-frontend-wml-continue' => 'දිගට කර ගෙන යමින්...',
	'mobile-frontend-wml-back' => 'ආපසු...',
	'mobile-frontend-view' => 'ජංගම දසුන',
	'mobile-frontend-view-desktop' => 'වැඩතලය',
	'mobile-frontend-view-mobile' => 'ජංගම',
	'mobile-frontend-opt-in-explain' => 'බීටා වෙත එක් වීමෙන්, ඔබ හට දෝෂ සහ වාදපද හමුවෙන අනතුරක් වියහැකි, පරීක්ෂාත්මක මුහුණුවර වෙත ප්‍රවේශ වීමේ හැකියාව ඇත.',
	'mobile-frontend-images-status' => 'පිංතූර',
	'mobile-frontend-disable-images' => 'ජංගම අඩවියෙහි පින්තුර අක්‍රීය කරන්න',
	'mobile-frontend-enable-images' => 'ජංගම අඩවියෙහි පින්තුර සක්‍රීය කරන්න',
	'mobile-frontend-missing-image' => 'පිංතූරය',
	'mobile-frontend-off' => 'අක්‍රිය',
	'mobile-frontend-on' => 'සක්‍රිය',
	'mobile-frontend-footer-contributors-text' => 'පිටුව ඔබ වැනි [$1 දායකයන්] ගෙනි',
	'mobile-frontend-featured-article' => 'අද විශේෂාංග ලිපිය',
	'mobile-frontend-news-items' => 'පුවත් වලින්',
	'mobile-frontend-leave-feedback-subject' => 'විෂයය:',
	'mobile-frontend-leave-feedback-message' => 'පණිවුඩය:',
	'mobile-frontend-leave-feedback-submit' => 'ප්‍රතිපෝෂණය ඉදිරිපත් කරන්න',
	'mobile-frontend-leave-feedback-link-text' => 'ජංගමඉදිරිපස විස්තීර්ණ ප්‍රතිචාරය',
	'mobile-frontend-leave-feedback' => 'ජංගම අඩවි ප්‍රතිචාර',
	'mobile-frontend-leave-feedback-title' => 'ඔබගේ ජංගම අඩවි අත්දැකීම පිළිබඳව අපට ප්‍රතිචාරය ලබා දෙන්න',
	'mobile-frontend-leave-feedback-technical-problem-section-header' => 'තාක්ෂණික ගැටළුව',
	'mobile-frontend-leave-feedback-general-section-header' => 'ප්‍රධාන',
	'mobile-frontend-leave-feedback-article-feedback-section-header' => 'ලිපි ප්‍රතිචාරය',
	'mobile-frontend-leave-feedback-technical-link-text' => 'තාක්ෂණික ගැටළුව',
	'mobile-frontend-leave-feedback-general-link-text' => 'ප්‍රධාන ප්‍රතිචාරය',
	'mobile-frontend-leave-feedback-article-factual-link-text' => 'තථ්‍ය දෝෂයක් සම්බන්ධයෙන්',
	'mobile-frontend-leave-feedback-article-other-link-text' => 'වෙනත් ගැටලුවක් සම්බන්ධයෙන්',
	'mobile-frontend-leave-feedback-form-subject-placeholder' => 'පණිවුඩයේ විෂය',
	'mobile-frontend-leave-feedback-form-message-placeholder' => 'ඔබේ පරිකථනය මෙතන ඇතුළු කරන්න',
	'mobile-frontend-leave-feedback-page-title' => 'ජංගම අඩවි ප්‍රතිචාරය',
	'mobile-frontend-leave-feedback-special-title' => 'අපව අමතන්න',
	'mobile-frontend-feedback-no-subject' => '(මාතෘකාවක් නොමැත)',
	'mobile-frontend-feedback-no-subject-field' => 'කරුණාකර මාතෘකාවක් ඇතුළත් කරන්න',
	'mobile-frontend-feedback-no-message' => 'කරුණාකර පණිවුඩය මෙතන ඇතුළු කරන්න',
	'mobile-frontend-leave-feedback-thanks' => 'ස්තුතියි, ඔබේ ප්‍රතිචාරයට!',
	'mobile-frontend-leave-feedback-post-error' => 'ඔබේ පණිවුඩය ක්‍රියානනය කිරීමේදී දෝෂයක් හට ගැනුණි. කරුණාකර පසුව නැවත උත්සහ කරන්න.',
	'mobile-frontend-language' => 'භාෂාව:',
	'mobile-frontend-language-article-heading' => 'වෙනත් භාෂාවකින් කියවන්න',
	'mobile-frontend-language-variant-header' => '{{#language:{{CONTENTLANG}}}} විචල්‍ය තෝරන්න',
	'mobile-frontend-language-footer' => '{{SITENAME}} වෙනත් භාෂාවලින්ද ලබා ගත හැක.', # Fuzzy
	'mobile-frontend-language-site-choose' => 'භාෂාව සොයන්න',
	'mobile-frontend-username' => 'පරිශීලක නාමය:',
	'mobile-frontend-password' => 'මුරපදය:',
	'mobile-frontend-username-placeholder' => 'පරිශීලක නාමය',
	'mobile-frontend-password-placeholder' => 'මුරපදය',
	'mobile-frontend-login' => 'පිවිසෙන්න',
	'mobile-frontend-account-create-submit' => 'ලියාපදිංචි වන්න',
	'mobile-frontend-password-confirm-placeholder' => 'මුරපදය තහවුරු කරන්න',
	'mobile-frontend-account-create-email-placeholder' => 'විද්‍යුත්-තැපැල් ලිපිනය (අමතර)',
	'mobile-frontend-account-create-captcha-placeholder' => 'ආරක්ෂක පාඨය ඇතුළු කරන්න',
	'mobile-frontend-overlay-escape' => 'ආපසු යන්න',
	'mobile-frontend-placeholder' => '{{SITENAME}} ගවේෂණය කරන්න',
	'mobile-frontend-placeholder-beta' => 'සොයන්න {{SITENAME}} (බීටා)',
	'mobile-frontend-placeholder-alpha' => '{{SITENAME}} සොයන්න (මකරාගේ ක්‍රමය)',
	'mobile-frontend-search-help' => 'ඉහළින් සෙවුම් වචනයක් ටයිප් කරන්න, ගැලපෙන පිටු ශීර්ෂයක් එවිට මෙහි දිස්වනු ඇත.',
	'mobile-frontend-dismiss-notification' => 'මෙම නිවේදනය නොසලකන්න',
	'mobile-frontend-clear-search' => 'හිස් කරන්න',
	'mobile-frontend-privacy-link-text' => 'පුද්ගලිකත්වය',
	'mobile-frontend-about-link-text' => 'පිළිබඳ',
	'mobile-frontend-footer-sitename' => '{{SITENAME}}',
	'mobile-frontend-footer-contact' => 'සම්බන්ධ කරන්න',
	'mobile-frontend-main-menu-button-tooltip' => 'ප්‍රධාන මෙනුව විවෘත කරන්න',
	'mobile-frontend-main-menu-page-title' => 'අඩවි යාන්ත්‍රණය',
	'mobile-frontend-main-menu-featured' => 'විශේෂාංගමය',
	'mobile-frontend-main-menu-nearby' => 'අවට',
	'mobile-frontend-main-menu-login' => 'පිවිසෙන්න',
	'mobile-frontend-main-menu-logout' => 'නික්මීම',
	'mobile-frontend-main-menu-watchlist' => 'මුරලැයිස්තුව',
	'mobile-frontend-main-menu-settings' => 'සැකසුම්',
	'mobile-frontend-main-menu-settings-heading' => 'ජංගම අඩවි සැකසුම්',
	'mobile-frontend-settings-site-header' => '{{SITENAME}} භාෂාවන්',
	'mobile-frontend-main-menu-contact' => 'සම්බන්ධ කරන්න',
	'mobile-frontend-main-menu-account-create' => 'ගිණුමක් තනන්න',
	'mobile-frontend-page-menu-contents' => 'අන්තර්ගතයන්',
	'mobile-frontend-page-menu-history' => 'ඉතිහාසය',
	'mobile-frontend-meta-data-issues-header' => 'වාදපද',
	'mobile-frontend-meta-data-issues' => 'මෙම පිටුව සතුව සමහරක් වාදපද ඇත',
	'mobile-frontend-ajax-page-loading' => '$1 පූරණය වෙමින්',
	'mobile-frontend-page-saving' => '$1 සුරකිමින්',
	'mobile-frontend-photo-upload-generic' => 'පින්තූරයක් පරිත්‍යාග කරන්න',
	'mobile-frontend-donate-image-title' => 'පින්තූරයක් පරිත්‍යාග කරන්න',
	'mobile-frontend-donate-image-heading' => 'ඔබේ මෑත දායකත්වයන්',
	'mobile-frontend-watchlist-add' => '$1 ඔබේ මුරලැයිස්තුවට එක් කරන ලදී',
	'mobile-frontend-watchlist-removed' => '$1 ඔබේ මුරලැයිස්තුවෙන් ඉවත් කරන ලදී',
	'mobile-frontend-watchlist-view' => 'ඔබේ මුරලැයිස්තුව නරඹන්න',
	'mobile-frontend-watchlist-a-z' => 'මුරකෙරෙන පිටු', # Fuzzy
	'mobile-frontend-watchlist-feed' => 'වෙනස්කම් සහිත පිටු', # Fuzzy
	'mobile-frontend-changeslist-ip' => 'නිර්නාමික පරිශීලක',
	'mobile-frontend-changeslist-nocomment' => 'සංස්කරණ සාරාංශයක් නොමැත',
	'mobile-frontend-watchlist-filter-all' => 'සියල්ල',
	'mobile-frontend-watchlist-filter-articles' => 'ලිපි',
	'mobile-frontend-watchlist-filter-talk' => 'සාකච්ඡාව',
	'mobile-frontend-watchlist-filter-other' => 'වෙනත්',
	'mobile-frontend-diffview-title' => '$1 වෙත වෙනස් කරන්න', # Fuzzy
	'mobile-frontend-diffview-editcount' => '{{PLURAL:$1|සංස්කරණ|සංස්කරණ}} $1 ක්', # Fuzzy
	'mobile-frontend-diffview-anonymous' => 'නිර්නාමික පරිශීලක',
	'mobile-frontend-table' => 'වගුව $1',
	'mobile-frontend-photo-upload' => 'මෙම පිටුව සඳහා ප්‍රථම ඡායාරූපය එක් කරන්න', # Fuzzy
	'mobile-frontend-photo-article-edit-comment' => 'පිටුව මත භාවිතා කිරීම සඳහා ඡායාරූපයක් එක් කරන ලදී',
	'mobile-frontend-photo-upload-comment' => 'පිටුව වෙත ඡායාරූපයක් එක් කරන ලදී',
	'mobile-frontend-photo-caption-placeholder' => 'මෙම පින්තූරය සඳහා සිරස්තලයක් එක් කරන්න', # Fuzzy
	'mobile-frontend-image-loading' => 'පින්තූරය පූරණය කරමින්',
	'mobile-frontend-image-uploading-wait' => 'පින්තූරය උඩුගත කරමින්', # Fuzzy
	'tag-mobile_edit' => 'ජංගම සංස්කරණය',
	'tag-mobile_edit-description' => 'ජංගම අඩවියෙන් සංස්කරණය සිදු කරන ලදී',
);

/** Slovak (slovenčina)
 * @author Helix84
 * @author Kusavica
 * @author Teslaton
 */
$messages['sk'] = array(
	'mobile-frontend-desc' => 'Mobilné rozhranie',
	'mobile-frontend-search-submit' => 'Ísť na',
	'mobile-frontend-home-button' => 'Hlavná stránka',
	'mobile-frontend-logged-out' => 'Nie ste prihlásený',
	'mobile-frontend-settings-description' => 'Prispôsobte si správanie tohto konkrétneho webu na vašom mobilnom zariadení.',
	'mobile-frontend-settings-beta' => 'Beta',
	'mobile-frontend-save-settings' => 'Uložiť nastavenia',
	'mobile-frontend-random-button' => 'Náhodná',
	'mobile-frontend-back-to-top-of-section' => 'Skočiť o sekciu späť',
	'mobile-frontend-close-section' => 'Zatvoriť túto sekciu',
	'mobile-frontend-show-button' => 'Zobraziť',
	'mobile-frontend-hide-button' => 'Skryť',
	'mobile-frontend-empty-homepage-text' => 'Túto domovskú stránku treba nastaviť. <a href="http://meta.wikimedia.org/wiki/Mobile_Projects/Mobile_Gateway#Mobile_homepage">Podrobnosti sa dozviete tu</a>', # Fuzzy
	'mobile-frontend-regular-site' => 'Klasické zobrazenie',
	'mobile-frontend-wml-continue' => 'Pokračovať...',
	'mobile-frontend-wml-back' => 'Späť...',
	'mobile-frontend-view' => 'Mobilné zobrazenie',
	'mobile-frontend-view-desktop' => 'Štandardné',
	'mobile-frontend-view-mobile' => 'Mobilné',
	'mobile-frontend-opt-in-explain' => 'Ak zapnete beta verziu, budete mať prístup k experimentálnym funkciám, ktorý je však spojený s rizikom, že narazíte na chyby a problémy.',
	'mobile-frontend-images-status' => 'Obrázky',
	'mobile-frontend-disable-images' => 'Vypnúť obrázky v mobilnom rozhraní',
	'mobile-frontend-enable-images' => 'Zapnúť obrázky v mobilnom rozhraní',
	'mobile-frontend-off' => 'VYP',
	'mobile-frontend-on' => 'ZAP',
	'mobile-frontend-footer-contributors-text' => 'Článok napísali <a href="$1">prispievatelia</a> ako vy', # Fuzzy
	'mobile-frontend-featured-article' => 'Článok dňa',
	'mobile-frontend-news-items' => 'V novinkách',
	'mobile-frontend-leave-feedback-notice' => 'Vaše komentáre nám pomáhajú vylepšovať mobilné rozhranie. Vaše komentáre budú zverejnené (spolu s vašim používateľským menom, verziou prehliadača a operačného systému) na stránke „$1“. Prosím, skúste zvoliť informatívny predmet, napr. „Problém s formátovaním širokých tabuliek“. Vaše komentáre podliehajú našim Podmienkam použitia.',
	'mobile-frontend-leave-feedback-warning' => 'Ak nesúhlasíte so zverejnením vašich informácií, prosím, nevkladajte do vašich komentárov osobné informácie.',
	'mobile-frontend-leave-feedback-subject' => 'Predmet:',
	'mobile-frontend-leave-feedback-message' => 'Správa:',
	'mobile-frontend-leave-feedback-submit' => 'Odoslať komentár',
	'mobile-frontend-leave-feedback-link-text' => 'Komentár k rozšíreniu MobileFrontend',
	'mobile-frontend-leave-feedback' => 'Komentáre k mobilnému rozhraniu',
	'mobile-frontend-leave-feedback-title' => 'Pošlite nám vaše komentáre týkajúce sa mobilného rozhrania',
	'mobile-frontend-leave-feedback-technical-problem-section-header' => 'Technický problém',
	'mobile-frontend-leave-feedback-general-section-header' => 'Všeobecné',
	'mobile-frontend-leave-feedback-article-feedback-section-header' => 'Hodnotenie článku',
	'mobile-frontend-leave-feedback-email-body' => 'Prosím, napíšte svoj email nad tento riadok.', # Fuzzy
	'mobile-frontend-leave-feedback-technical-link-text' => 'Technický problém',
	'mobile-frontend-leave-feedback-general-link-text' => 'Všeobecný komentár',
	'mobile-frontend-leave-feedback-article-personal-link-text' => 'Týka sa mňa, osoby alebo spoločnosti, ktorú zastupujem',
	'mobile-frontend-leave-feedback-article-factual-link-text' => 'Týka sa faktickej chyby',
	'mobile-frontend-leave-feedback-article-other-link-text' => 'Iný problém',
	'mobile-frontend-leave-feedback-form-subject-placeholder' => 'Predmet správy',
	'mobile-frontend-leave-feedback-form-message-placeholder' => 'Napíšte svoj komentár sem',
	'mobile-frontend-leave-feedback-page-title' => 'Pošlite nám vaše komentáre týkajúce sa mobilného rozhrania',
	'mobile-frontend-leave-feedback-special-title' => 'Kontaktujte nás',
	'mobile-frontend-feedback-no-subject' => '(bez predmetu)',
	'mobile-frontend-feedback-no-subject-field' => 'Prosím, vyplňte predmet',
	'mobile-frontend-feedback-no-message' => 'Prosím, sem napíšte správu',
	'mobile-frontend-feedback-edit-summary' => '$1 - poslané automaticky pomocou [[Special:MobileFeedback|nástroja mobilnej spätnej väzby]]',
	'mobile-frontend-leave-feedback-thanks' => 'Vďaka za vaše pripomienky!',
	'mobile-frontend-leave-feedback-post-error' => 'Vyskytla sa chyba počas spracovania vašej správy. Prosím, skúste to neskôr znova.',
	'mobile-frontend-language' => 'Jazyk:',
	'mobile-frontend-language-header' => 'Tento článok je dostupný v $1 {{PLURAL:$1|jazyku|jazykoch}}', # Fuzzy
	'mobile-frontend-language-footer' => '[[Special:MobileOptions|Nevidíte svoj jazyk? Pozrite si podrobnosti]].', # Fuzzy
	'mobile-frontend-language-site-choose' => 'Hľadať jazyk',
	'mobile-frontend-username' => 'Používateľské meno:',
	'mobile-frontend-password' => 'Heslo:',
	'mobile-frontend-login' => 'Prihlásiť sa',
	'mobile-frontend-placeholder' => 'Sem napíšte hľadaný výraz...', # Fuzzy
	'mobile-frontend-search-help' => 'Napíšte hľadané slová hore. Zodpovedajúci článok sa objaví tu.', # Fuzzy
	'mobile-frontend-dismiss-notification' => 'zavrieť toto oznámenie',
	'mobile-frontend-clear-search' => 'Vyčistiť',
	'mobile-frontend-privacy-link-text' => 'Súkromie',
	'mobile-frontend-about-link-text' => 'O aplikácii',
	'mobile-frontend-footer-sitename' => '{{SITENAME}}',
	'mobile-frontend-footer-contact' => 'Kontakt',
	'mobile-frontend-search-noresults' => 'Žiadne názvy článkov nezodpovedajú vášmu vyhľadávaniu. Zmeňte hľadané slová alebo stlačením tlačidla hľadať na klávesnici hľadajte v texte článkov.', # Fuzzy
	'mobile-frontend-main-menu-featured' => 'Odporúčané',
	'mobile-frontend-main-menu-nearby' => 'V blízkosti',
	'mobile-frontend-main-menu-settings' => 'Nastavenia',
	'mobile-frontend-main-menu-settings-heading' => 'Nastavenia mobilného webu',
	'mobile-frontend-settings-site-header' => 'Jazyky {{GRAMMAR:genitív|{{SITENAME}}}}',
	'mobile-frontend-settings-site-description' => '{{SITENAME}} je {{GENDER:$1|dostupný|dostupná|dostupné}} v $1 {{PLURAL:$1|jazyku|jazykoch}}. Všetky dostupné verzie sú uvedené nižšie',
	'mobile-frontend-main-menu-contact' => 'Kontakt',
	'mobile-frontend-page-menu-contents' => 'obsah',
);

/** Slovenian (slovenščina)
 * @author Dbc334
 * @author Irena Plahuta
 * @author Yerpo
 */
$messages['sl'] = array(
	'mobile-frontend-desc' => 'Mobilno obličje',
	'mobile-frontend-search-submit' => 'Pojdi',
	'mobile-frontend-home-button' => 'Domov',
	'mobile-frontend-logged-out' => 'Niste prijavljeni',
	'mobile-frontend-logged-in-homepage-notification' => '$1, dobrodošli!',
	'mobile-frontend-logged-in-toast-notification' => 'Prijavljeni ste kot $1.',
	'mobile-frontend-sign-up-heading' => 'Registracija',
	'mobile-frontend-sign-in-heading' => 'Prijava',
	'mobile-frontend-sign-in-why' => 'Če imate račun na {{GRAMMAR:mestnik|{{SITENAME}}}}, se lahko prijavite spodaj.',
	'mobile-frontend-sign-in-error-heading' => 'Ups',
	'mobile-frontend-settings-beta' => 'Beta',
	'mobile-frontend-save-settings' => 'Shrani nastavitve',
	'mobile-frontend-random-button' => 'Naključno',
	'mobile-frontend-ajax-random-heading' => 'Iščem znanje ...',
	'mobile-frontend-ajax-random-question' => 'Preberite stran?',
	'mobile-frontend-ajax-random-yes' => 'Da',
	'mobile-frontend-ajax-random-retry' => 'Poskusi znova',
	'mobile-frontend-ajax-random-suggestions' => 'Drugi predlogi:',
	'mobile-frontend-back-to-top-of-section' => 'Skoči nazaj za oddelek',
	'mobile-frontend-close-section' => 'Zapri razdelek',
	'mobile-frontend-show-button' => 'pokaži',
	'mobile-frontend-hide-button' => 'skrij',
	'mobile-frontend-empty-homepage-text' => 'Domačo stran morate konfigurirati. [//meta.wikimedia.org/wiki/Mobile_Projects/Mobile_Gateway#Mobile_homepage Navodila, kako stran omogočiti na mobilnih napravah]',
	'mobile-frontend-regular-site' => 'Pogled namizja',
	'mobile-frontend-wml-continue' => 'Nadaljuj ...',
	'mobile-frontend-wml-back' => 'Nazaj ...',
	'mobile-frontend-view' => 'Mobilni pogled',
	'mobile-frontend-view-desktop' => 'Namizje',
	'mobile-frontend-view-mobile' => 'Mobilno',
	'mobile-frontend-opt-in-explain' => 'Če se pridružite mobilni beta, boste prejeli dostop do preizkusnih funkcij, vendar ob tem lahko naletite na hrošče in težave.',
	'mobile-frontend-images-status' => 'Slike',
	'mobile-frontend-disable-images' => 'Onemogoči slike na mobilni strani',
	'mobile-frontend-enable-images' => 'Omogoči slike na mobilni strani',
	'mobile-frontend-missing-image' => 'Slika',
	'mobile-frontend-off' => 'IZKL',
	'mobile-frontend-on' => 'VKL',
	'mobile-frontend-footer-contributors-text' => 'Stran [$1 sodelavcev], kot ste vi',
	'mobile-frontend-featured-article' => 'Današnji izbrani članek',
	'mobile-frontend-news-items' => 'V novicah',
	'mobile-frontend-leave-feedback-notice' => 'Vaše povratne informacije nam pomagajo izboljšati izkušnjo z mobilno stranjo. Objavljene bodo javno (skupaj z vašim uporabniškim imenom, različico brskalnika in operacijskim sistemom) na strani »$1«. Prosimo, da poskusite izbrati informativno zadevo, npr. »Težave pri oblikovanju širokih tabel«. Vaša povratna informacija je predmet naših pogojev uporabe.',
	'mobile-frontend-leave-feedback-subject' => 'Zadeva:',
	'mobile-frontend-leave-feedback-message' => 'Sporočilo:',
	'mobile-frontend-leave-feedback-submit' => 'Pošljite povratne informacije',
	'mobile-frontend-leave-feedback-link-text' => 'Povratne informacije o mobilnem obličju',
	'mobile-frontend-leave-feedback' => 'Pustite povratne informacije',
	'mobile-frontend-leave-feedback-title' => 'Povratne informacije mobilne strani',
	'mobile-frontend-leave-feedback-technical-problem-section-header' => 'Tehnična težava',
	'mobile-frontend-leave-feedback-general-section-header' => 'Splošno',
	'mobile-frontend-leave-feedback-article-feedback-section-header' => 'Povratna informacija o članku',
	'mobile-frontend-leave-feedback-email-body' => 'Prosimo, da pod črto opišete težavo, s katero se soočate na {{GRAMMAR:mestnik|{{SITENAME}}}}. Pomnite, da ne moremo odgovoriti na vsako prejeto sporočilo.',
	'mobile-frontend-leave-feedback-technical-link-text' => 'Tehnična težava',
	'mobile-frontend-leave-feedback-general-link-text' => 'Splošna povratna informacija',
	'mobile-frontend-leave-feedback-article-personal-link-text' => 'V zvezi z mano, osebo ali podjetjem, ki ga zastopam',
	'mobile-frontend-leave-feedback-article-factual-link-text' => 'V zvezi z napako v podatku',
	'mobile-frontend-leave-feedback-article-other-link-text' => 'V zvezi z drugo težavo',
	'mobile-frontend-leave-feedback-form-subject-placeholder' => 'Zadeva sporočila',
	'mobile-frontend-leave-feedback-form-message-placeholder' => 'Tukaj vnesite svojo pripombo',
	'mobile-frontend-leave-feedback-page-title' => 'Povratne informacije mobilne strani',
	'mobile-frontend-leave-feedback-special-title' => 'Stopite v stik z nami',
	'mobile-frontend-feedback-no-subject' => '(brez zadeve)',
	'mobile-frontend-feedback-no-subject-field' => 'Prosimo, vnesite zadevo',
	'mobile-frontend-feedback-no-message' => 'Prosimo, da tukaj vnesete sporočilo',
	'mobile-frontend-feedback-edit-summary' => '$1 – samodejno objavljeno z uporabo [[Special:MobileFeedback|orodja za mobilno povratno informacijo]]',
	'mobile-frontend-leave-feedback-thanks' => 'Hvala za povratne informacije!',
	'mobile-frontend-language' => 'Jezik:',
	'mobile-frontend-language-article-heading' => 'Preberite v drugem jeziku',
	'mobile-frontend-username' => 'Uporabniško ime:',
	'mobile-frontend-password' => 'Geslo:',
	'mobile-frontend-username-placeholder' => 'Uporabniško ime',
	'mobile-frontend-password-placeholder' => 'Geslo',
	'mobile-frontend-login' => 'Prijava',
	'mobile-frontend-last-modified-date' => 'Zadnja sprememba: $1 ob $2',
	'mobile-frontend-account-create-submit' => 'Registracija',
	'mobile-frontend-password-confirm-placeholder' => 'Potrditev gesla',
	'mobile-frontend-account-create-email-placeholder' => 'E-poštni naslov (neobvezno)',
	'mobile-frontend-account-create-captcha-placeholder' => 'Vnesite varnostno besedilo',
	'mobile-frontend-overlay-escape' => 'Pojdi nazaj',
	'mobile-frontend-placeholder' => 'Iščite po {{GRAMMAR:mestnik|{{SITENAME}}}}',
	'mobile-frontend-dismiss-notification' => 'skrij obvestilo',
	'mobile-frontend-clear-search' => 'Počisti',
	'mobile-frontend-privacy-link-text' => 'Zasebnost',
	'mobile-frontend-about-link-text' => 'O programu',
	'mobile-frontend-footer-sitename' => '{{SITENAME}}',
	'mobile-frontend-footer-contact' => 'Stik',
	'mobile-frontend-main-menu-login' => 'Prijava',
	'mobile-frontend-main-menu-logout' => 'Odjava',
	'mobile-frontend-main-menu-settings' => 'Nastavitve',
	'mobile-frontend-main-menu-settings-heading' => 'Nastavitve strani za prenosne naprave',
	'mobile-frontend-main-menu-contact' => 'Stik z nami',
	'mobile-frontend-page-menu-contents' => 'vsebina',
	'mobile-frontend-page-menu-history' => 'zgodovina',
	'mobile-frontend-ajax-page-loading' => 'Nalaganje $1',
	'mobile-frontend-page-saving' => 'Shranjevanje $1',
	'mobile-frontend-watchlist-cta-button-login' => 'Prijava',
	'mobile-frontend-watchlist-cta-button-signup' => 'Registracija',
	'mobile-frontend-watchlist-filter-all' => 'Vse',
	'mobile-frontend-watchlist-filter-articles' => 'Članki',
	'mobile-frontend-watchlist-filter-talk' => 'Pogovor',
	'mobile-frontend-watchlist-filter-other' => 'Drugo',
	'mobile-frontend-diffview-title' => 'Spremembe',
	'mobile-frontend-diffview-editcount' => '$1 {{PLURAL:$1|urejanje|urejanji|urejanja|urejanj}}',
	'mobile-frontend-diffview-anonymous' => 'Brezimni uporabnik',
	'mobile-frontend-image-loading' => 'Prenašanje slike',
	'mobile-frontend-image-uploading-wait' => 'Nalaganje slike; prosimo, počakajte.',
	'mobile-frontend-photo-upload-error' => 'Napaka, poskusite znova.',
	'mobile-frontend-photo-submit' => 'Potrdi',
	'mobile-frontend-photo-cancel' => 'Prekliči',
	'tag-mobile_edit' => 'Mobilno urejanje',
	'tag-mobile_edit-description' => 'Urejanje z mobilne spletne strani',
	'mobile-frontend-drawer-cancel' => 'Prekliči',
);

/** Albanian (shqip)
 * @author FatosMorina
 * @author Olsi
 */
$messages['sq'] = array(
	'mobile-frontend-desc' => 'Për celular',
	'mobile-frontend-search-submit' => 'Shko',
	'mobile-frontend-home-button' => 'Kryefaqja',
	'mobile-frontend-logged-out' => 'Nuk jeni qasur',
	'mobile-frontend-settings-description' => 'Rregulloni përvojën tuaj në pajisjen tuaj mobile me këto opsione të posaçme të faqes për mobil.',
	'mobile-frontend-save-settings' => 'Ruani rregullimet',
	'mobile-frontend-random-button' => 'I rastit',
	'mobile-frontend-back-to-top-of-section' => 'Kalo në seksionin A',
	'mobile-frontend-close-section' => 'Mbylleni këtë seksion',
	'mobile-frontend-show-button' => 'Shfaq',
	'mobile-frontend-hide-button' => 'Fshih',
	'mobile-frontend-empty-homepage-text' => 'Kjo ballinë ka nevojë që të konfigurohet. <a href="http://meta.wikimedia.org/wiki/Mobile_Projects/Mobile_Gateway#Mobile_homepage"> Udhëzimet në atë se si ta mundësoni këtë faqe të lëvizhshme</a>', # Fuzzy
	'mobile-frontend-regular-site' => 'Shiko këtë faqe në versionin e rregullt të {{SITENAME}}', # Fuzzy
	'mobile-frontend-wml-continue' => 'Vazhdo...',
	'mobile-frontend-wml-back' => 'Prapa ...',
	'mobile-frontend-view' => 'Për celular',
	'mobile-frontend-view-desktop' => 'Desktopi',
	'mobile-frontend-view-mobile' => 'Pamja për celular',
	'mobile-frontend-opt-in-explain' => 'Duke iu bashkuar versionit beta, ju do të keni qasje në tipare eksperimentale, me riskun e ndeshjes me probleme.',
	'mobile-frontend-images-status' => 'Fotografitë',
	'mobile-frontend-disable-images' => 'Çaktivizo figurat në versionin për celular',
	'mobile-frontend-enable-images' => 'Aktivizo figurat në versionin për celular',
	'mobile-frontend-off' => 'Të paparaqitura',
	'mobile-frontend-on' => 'Të paraqitura',
	'mobile-frontend-footer-contributors-text' => 'Artikulli nga <a href="$1">kontribuuesit</a> si ju', # Fuzzy
	'mobile-frontend-featured-article' => 'Artikulli i ditës',
	'mobile-frontend-news-items' => 'Në lajme',
	'mobile-frontend-leave-feedback-notice' => 'Përshtypja juaj na ndihmon për të përmirësur përvojën e versionit për celular. Do të postohet publikisht (së bashku me emrin tuaj të përdoruesit, versionin e shfletuesit dhe sistemin operativ) në faqen &quot;$1&quot;. Ju lutemi provoni të zgjidhni një linjë subjekti informativ, p.sh. "Formatimi i çështjeve me tabela të gjera". Përshtypja juaj është subjekt i kushteve tona të përdorimit.',
	'mobile-frontend-leave-feedback-warning' => 'Derisa ju të pajtoheni që të bëni publik informacionin tuaj, ju lutemi mos e përfshini informacionin personal në komentet tuaja.',
	'mobile-frontend-leave-feedback-subject' => 'Subjekti:', # Fuzzy
	'mobile-frontend-leave-feedback-message' => 'Mesazhi', # Fuzzy
	'mobile-frontend-leave-feedback-submit' => 'Paraqit përshtypjet',
	'mobile-frontend-leave-feedback-link-text' => 'Shtesë përshtypjeje MobileFronted',
	'mobile-frontend-leave-feedback' => 'Përshtypja për versionin e celularit',
	'mobile-frontend-leave-feedback-title' => 'Na jepni përshtypjet tuaja rreth përvojës në versionin e celularit',
	'mobile-frontend-leave-feedback-technical-problem-section-header' => 'Problemi teknik',
	'mobile-frontend-leave-feedback-general-section-header' => 'E përgjithshme',
	'mobile-frontend-leave-feedback-article-feedback-section-header' => 'Reagimi për artikull',
	'mobile-frontend-leave-feedback-email-body' => 'Shkruani e-mailin tuaj mbi këtë rresht.', # Fuzzy
	'mobile-frontend-leave-feedback-technical-link-text' => 'Problemi teknik',
	'mobile-frontend-leave-feedback-general-link-text' => 'Reagimi i përgjithshëm',
	'mobile-frontend-leave-feedback-article-personal-link-text' => 'Në lidhje me mua, një person, ose një ndërmarrje unë përfaqësoj',
	'mobile-frontend-leave-feedback-article-factual-link-text' => 'Në lidhje me një problem faktik',
	'mobile-frontend-leave-feedback-article-other-link-text' => 'Në lidhje me problem tjetër',
	'mobile-frontend-leave-feedback-form-subject-placeholder' => 'Subjekti i porosisë',
	'mobile-frontend-leave-feedback-form-message-placeholder' => 'Shkruani komentin tuaj këtu',
	'mobile-frontend-leave-feedback-page-title' => 'Na jepni përshtypjet tuaja rreth përvojës në versionin e celularit',
	'mobile-frontend-leave-feedback-special-title' => 'Na kontaktoni',
	'mobile-frontend-feedback-no-subject' => '(pa subjekt)',
	'mobile-frontend-feedback-no-subject-field' => 'Ju lutem shkruani një subjekt',
	'mobile-frontend-feedback-no-message' => 'Ju lutem shkruani një porosi këtu',
	'mobile-frontend-feedback-edit-summary' => '$1 - postuar automatikisht duke përdorur [[Special:MobileFeedback|veglën për reagim mobil]]',
	'mobile-frontend-leave-feedback-thanks' => 'Faleminderit për përshtypjet tuaja!',
	'mobile-frontend-leave-feedback-post-error' => 'Ndodhi një gabim në përpunimin e porosisë suaj. Ju lutemi provoni më vonë.',
	'mobile-frontend-language' => 'Gjuha', # Fuzzy
	'mobile-frontend-language-header' => 'Ky artikull është në dispozicion në $1 {{PLURAL:$1|gjuhën|gjuhët}}', # Fuzzy
	'mobile-frontend-language-footer' => '{{SITENAME}} është në dispozicion në gjuhët e tjera.', # Fuzzy
	'mobile-frontend-language-site-choose' => 'Kërkoni gjuhën',
	'mobile-frontend-username' => 'Emri i përdoruesit:',
	'mobile-frontend-password' => 'Fjalëkalimi:',
	'mobile-frontend-login' => 'Hyni',
	'mobile-frontend-placeholder' => 'Shkruani kërkimin tuaj këtu...', # Fuzzy
	'mobile-frontend-search-help' => 'Shkruani termin e kërkimit më sipër dhe titujt e artikujve të përputhshëm do të paraqiten këtu.', # Fuzzy
	'mobile-frontend-dismiss-notification' => 'largoni këtë lajmërim',
	'mobile-frontend-clear-search' => 'Fshije',
	'mobile-frontend-privacy-link-text' => 'Privatësia',
	'mobile-frontend-about-link-text' => 'Rreth',
	'mobile-frontend-footer-sitename' => '{{SITENAME}}',
	'mobile-frontend-footer-contact' => 'Kontakti',
	'mobile-frontend-search-noresults' => 'Asnjë titull i artikujve nuk u përputh me kërkimin tuaj. Ndryshoni kërkimin tuaj, ose shtypni butonin e kërkimit me tastierë për të kërkuar brenda artikujve.', # Fuzzy
	'mobile-frontend-main-menu-featured' => 'I veçuar',
	'mobile-frontend-main-menu-nearby' => 'Pranë',
	'mobile-frontend-main-menu-settings' => 'Parametrat',
	'mobile-frontend-main-menu-settings-heading' => 'Parametrat e faqes për celular',
	'mobile-frontend-settings-site-header' => '{{SITENAME}} Gjuhë',
	'mobile-frontend-settings-site-description' => '{{SITENAME}} është në dispozicion në $1 {{PLURAL:$1|gjuhën|gjuhët}}. Të gjitha versionet janë të listuara më poshtë',
	'mobile-frontend-main-menu-contact' => 'Kontakti',
	'mobile-frontend-page-menu-contents' => 'Përmbajtja',
	'mobile-frontend-page-menu-history' => 'Historiku',
);

/** Serbian (Cyrillic script) (српски (ћирилица)‎)
 * @author Nikola Smolenski
 * @author Rancher
 * @author Михајло Анђелковић
 */
$messages['sr-ec'] = array(
	'mobile-frontend-desc' => 'Кориснички део за мобилне уређаје',
	'mobile-frontend-search-submit' => 'Иди',
	'mobile-frontend-home-button' => 'Почетак',
	'mobile-frontend-logged-out' => 'Нисте пријављени',
	'mobile-frontend-settings-beta' => 'Бета',
	'mobile-frontend-save-settings' => 'Сними подешавања',
	'mobile-frontend-random-button' => 'Насумице',
	'mobile-frontend-back-to-top-of-section' => 'Назад на претходни одељак',
	'mobile-frontend-close-section' => 'Затварање овог одељка',
	'mobile-frontend-show-button' => 'Прикажи',
	'mobile-frontend-hide-button' => 'Сакриј',
	'mobile-frontend-empty-homepage-text' => 'Овој страни је потребна конфигурација. <a href="http://meta.wikimedia.org/wiki/Mobile_Projects/Mobile_Gateway#Mobile_homepage">Погледајте инструкције за омогућавање мобилне верзије сајта</a>', # Fuzzy
	'mobile-frontend-regular-site' => 'Десктоп приказ',
	'mobile-frontend-wml-continue' => 'Настави…',
	'mobile-frontend-wml-back' => 'Назад…',
	'mobile-frontend-view' => 'Мобилни приказ',
	'mobile-frontend-view-desktop' => 'Обичан',
	'mobile-frontend-view-mobile' => 'Мобилни',
	'mobile-frontend-opt-in-explain' => 'Користећи бета верзију, добијате приступ до пробних могућности, али с ризиком да дођете до грешака и проблема.',
	'mobile-frontend-images-status' => 'Слике',
	'mobile-frontend-disable-images' => 'Онемогући слике на мобилним страницама',
	'mobile-frontend-enable-images' => 'Омогући слике на мобилним страницама',
	'mobile-frontend-off' => 'неприказане',
	'mobile-frontend-on' => 'приказане',
	'mobile-frontend-featured-article' => 'Данашњи изабрани чланак',
	'mobile-frontend-news-items' => 'Вести',
	'mobile-frontend-leave-feedback-warning' => 'Ако не желите да ваше информације буду јавне, молимо вас да не наводите личне податке у коментарима.',
	'mobile-frontend-leave-feedback-subject' => 'Наслов:',
	'mobile-frontend-leave-feedback-message' => 'Порука:',
	'mobile-frontend-leave-feedback-submit' => 'Пошаљи повратну информацију',
	'mobile-frontend-leave-feedback-link-text' => 'Мишљење о Мобилном сучељу',
	'mobile-frontend-leave-feedback' => 'Мишљење',
	'mobile-frontend-leave-feedback-title' => 'Реците нам ваше мишљење о мобилној верзији',
	'mobile-frontend-leave-feedback-technical-problem-section-header' => 'Технички проблем',
	'mobile-frontend-leave-feedback-general-section-header' => 'Опште',
	'mobile-frontend-leave-feedback-article-feedback-section-header' => 'Оцењивање чланка',
	'mobile-frontend-leave-feedback-email-body' => 'Напишите поруку изнад овог реда.', # Fuzzy
	'mobile-frontend-leave-feedback-technical-link-text' => 'Технички проблем',
	'mobile-frontend-leave-feedback-general-link-text' => 'Општа повратна информација',
	'mobile-frontend-leave-feedback-article-personal-link-text' => 'У моје име, у име особе или фирме коју заступам',
	'mobile-frontend-leave-feedback-article-factual-link-text' => 'У вези са чињеничном грешком',
	'mobile-frontend-leave-feedback-article-other-link-text' => 'У вези с другим проблемом',
	'mobile-frontend-leave-feedback-form-subject-placeholder' => 'Наслов поруке',
	'mobile-frontend-leave-feedback-form-message-placeholder' => 'Овде унесите коментар',
	'mobile-frontend-leave-feedback-page-title' => 'Повратне информације о мобилној верзији',
	'mobile-frontend-feedback-page' => 'Project:Мишљења о мобилном додатку',
	'mobile-frontend-leave-feedback-special-title' => 'Контакт',
	'mobile-frontend-feedback-no-subject' => '(нема наслова)',
	'mobile-frontend-feedback-no-subject-field' => 'Молимо, унесите наслов',
	'mobile-frontend-feedback-no-message' => 'Молимо, унесите поруку овде',
	'mobile-frontend-feedback-edit-summary' => '$1 – аутоматски постављено помоћу [[Special:MobileFeedback|алатке за слање повратних информација о мобилној верзији]]',
	'mobile-frontend-leave-feedback-thanks' => 'Хвала вам на повратној информацији.',
	'mobile-frontend-leave-feedback-post-error' => 'Дошло је до грешке при обради поруке. Молимо, покушајте касније.',
	'mobile-frontend-language' => 'Језик:',
	'mobile-frontend-language-header' => 'Овај чланак је доступан на $1 {{PLURAL:$1|језику|језика|језика}}', # Fuzzy
	'mobile-frontend-language-footer' => 'Пројекат „{{SITENAME}}“ је доступан на другим језицима.', # Fuzzy
	'mobile-frontend-language-site-choose' => 'Претрага језика',
	'mobile-frontend-username' => 'Корисничко име:',
	'mobile-frontend-password' => 'Лозинка:',
	'mobile-frontend-login' => 'Пријави ме',
	'mobile-frontend-placeholder' => 'Претражите {{SITENAME}}',
	'mobile-frontend-search-help' => 'Изнад унесите оно што тражите, а овде ће се приказати чланци који одговарају захтеву.', # Fuzzy
	'mobile-frontend-dismiss-notification' => 'склони ово обавештење',
	'mobile-frontend-clear-search' => 'Очисти',
	'mobile-frontend-privacy-link-text' => 'Приватност',
	'mobile-frontend-about-link-text' => 'О',
	'mobile-frontend-footer-sitename' => '{{SITENAME}}',
	'mobile-frontend-footer-contact' => 'Контакт',
	'mobile-frontend-search-noresults' => 'Нема чланка који одговара претрази. Промените услове претраге, или притисните дугме за претрагу да бисте је проширили на садржај чланака.', # Fuzzy
	'mobile-frontend-main-menu-featured' => 'Изабрано',
	'mobile-frontend-main-menu-nearby' => 'Околина',
	'mobile-frontend-main-menu-settings' => 'Подешавања',
	'mobile-frontend-main-menu-settings-heading' => 'Подешавања мобилног сајта',
	'mobile-frontend-main-menu-contact' => 'Контакт',
	'mobile-frontend-page-menu-contents' => 'садржај',
	'mobile-frontend-page-menu-history' => 'Историја',
);

/** Serbian (Latin script) (srpski (latinica)‎)
 */
$messages['sr-el'] = array(
	'mobile-frontend-desc' => 'Korisnički deo za mobilne uređaje',
	'mobile-frontend-search-submit' => 'Idi',
	'mobile-frontend-home-button' => 'Početak',
	'mobile-frontend-logged-out' => 'Niste prijavljeni',
	'mobile-frontend-settings-beta' => 'Beta',
	'mobile-frontend-save-settings' => 'Snimi podešavanja',
	'mobile-frontend-random-button' => 'Nasumice',
	'mobile-frontend-back-to-top-of-section' => 'Nazad na prethodni odeljak',
	'mobile-frontend-close-section' => 'Zatvaranje ovog odeljka',
	'mobile-frontend-show-button' => 'Prikaži',
	'mobile-frontend-hide-button' => 'Sakrij',
	'mobile-frontend-empty-homepage-text' => 'Ovoj strani je potrebna konfiguracija. <a href="http://meta.wikimedia.org/wiki/Mobile_Projects/Mobile_Gateway#Mobile_homepage">Pogledajte instrukcije za omogućavanje mobilne verzije sajta</a>', # Fuzzy
	'mobile-frontend-regular-site' => 'Desktop prikaz',
	'mobile-frontend-wml-continue' => 'Nastavi…',
	'mobile-frontend-wml-back' => 'Nazad…',
	'mobile-frontend-view' => 'Mobilni prikaz',
	'mobile-frontend-view-desktop' => 'Običan',
	'mobile-frontend-view-mobile' => 'Mobilni',
	'mobile-frontend-opt-in-explain' => 'Koristeći beta verziju, dobijate pristup do probnih mogućnosti, ali s rizikom da dođete do grešaka i problema.',
	'mobile-frontend-images-status' => 'Slike',
	'mobile-frontend-disable-images' => 'Onemogući slike na mobilnim stranicama',
	'mobile-frontend-enable-images' => 'Omogući slike na mobilnim stranicama',
	'mobile-frontend-off' => 'neprikazane',
	'mobile-frontend-on' => 'prikazane',
	'mobile-frontend-featured-article' => 'Današnji izabrani članak',
	'mobile-frontend-news-items' => 'Vesti',
	'mobile-frontend-leave-feedback-warning' => 'Ako ne želite da vaše informacije budu javne, molimo vas da ne navodite lične podatke u komentarima.',
	'mobile-frontend-leave-feedback-subject' => 'Naslov:',
	'mobile-frontend-leave-feedback-message' => 'Poruka:',
	'mobile-frontend-leave-feedback-submit' => 'Pošalji povratnu informaciju',
	'mobile-frontend-leave-feedback-link-text' => 'Mišljenje o Mobilnom sučelju',
	'mobile-frontend-leave-feedback' => 'Mišljenje',
	'mobile-frontend-leave-feedback-title' => 'Recite nam vaše mišljenje o mobilnoj verziji',
	'mobile-frontend-leave-feedback-technical-problem-section-header' => 'Tehnički problem',
	'mobile-frontend-leave-feedback-general-section-header' => 'Opšte',
	'mobile-frontend-leave-feedback-article-feedback-section-header' => 'Ocenjivanje članka',
	'mobile-frontend-leave-feedback-technical-link-text' => 'Tehnički problem',
	'mobile-frontend-leave-feedback-general-link-text' => 'Opšta povratna informacija',
	'mobile-frontend-leave-feedback-article-personal-link-text' => 'U moje ime, u ime osobe ili firme koju zastupam',
	'mobile-frontend-leave-feedback-article-factual-link-text' => 'U vezi sa činjeničnom greškom',
	'mobile-frontend-leave-feedback-article-other-link-text' => 'U vezi s drugim problemom',
	'mobile-frontend-leave-feedback-form-subject-placeholder' => 'Naslov poruke',
	'mobile-frontend-leave-feedback-form-message-placeholder' => 'Ovde unesite komentar',
	'mobile-frontend-leave-feedback-page-title' => 'Povratne informacije o mobilnoj verziji',
	'mobile-frontend-feedback-page' => 'Project:Mišljenja o mobilnom dodatku',
	'mobile-frontend-leave-feedback-special-title' => 'Kontakt',
	'mobile-frontend-feedback-no-subject' => '(nema naslova)',
	'mobile-frontend-feedback-no-subject-field' => 'Molimo, unesite naslov',
	'mobile-frontend-feedback-no-message' => 'Molimo, unesite poruku ovde',
	'mobile-frontend-feedback-edit-summary' => '$1 – automatski postavljeno pomoću [[Special:MobileFeedback|alatke za slanje povratnih informacija o mobilnoj verziji]]',
	'mobile-frontend-leave-feedback-thanks' => 'Hvala vam na povratnoj informaciji.',
	'mobile-frontend-leave-feedback-post-error' => 'Došlo je do greške pri obradi poruke. Molimo, pokušajte kasnije.',
	'mobile-frontend-language' => 'Jezik:',
	'mobile-frontend-language-header' => 'Ovaj članak je dostupan na $1 {{PLURAL:$1|jeziku|jezika|jezika}}', # Fuzzy
	'mobile-frontend-language-footer' => 'Projekat „{{SITENAME}}“ je dostupan na drugim jezicima.', # Fuzzy
	'mobile-frontend-language-site-choose' => 'Pretraga jezika',
	'mobile-frontend-username' => 'Korisničko ime:',
	'mobile-frontend-password' => 'Lozinka:',
	'mobile-frontend-login' => 'Prijavi me',
	'mobile-frontend-placeholder' => 'Pretražite {{SITENAME}}',
	'mobile-frontend-search-help' => 'Iznad unesite ono što tražite, a ovde će se prikazati članci koji odgovaraju zahtevu.', # Fuzzy
	'mobile-frontend-dismiss-notification' => 'skloni ovo obaveštenje',
	'mobile-frontend-clear-search' => 'Očisti',
	'mobile-frontend-privacy-link-text' => 'Privatnost',
	'mobile-frontend-about-link-text' => 'O',
	'mobile-frontend-footer-sitename' => '{{SITENAME}}',
	'mobile-frontend-footer-contact' => 'Kontakt',
	'mobile-frontend-search-noresults' => 'Nema članka koji odgovara pretrazi. Promenite uslove pretrage, ili pritisnite dugme za pretragu da biste je proširili na sadržaj članaka.', # Fuzzy
	'mobile-frontend-main-menu-featured' => 'Izabrano',
	'mobile-frontend-main-menu-nearby' => 'Okolina',
	'mobile-frontend-main-menu-settings' => 'Podešavanja',
	'mobile-frontend-main-menu-settings-heading' => 'Podešavanja mobilnog sajta',
	'mobile-frontend-main-menu-contact' => 'Kontakt',
	'mobile-frontend-page-menu-contents' => 'sadržaj',
	'mobile-frontend-page-menu-history' => 'Istorija',
);

/** Sundanese (Basa Sunda)
 */
$messages['su'] = array(
	'mobile-frontend-search-submit' => 'Jung',
	'mobile-frontend-home-button' => 'Tepas',
	'mobile-frontend-random-button' => 'Acak',
	'mobile-frontend-back-to-top-of-section' => 'Balik ka Bagian Saméméhna',
	'mobile-frontend-show-button' => 'Témbongkeun',
	'mobile-frontend-hide-button' => 'Sumputkeun',
	'mobile-frontend-regular-site' => 'Pidangkeun ieu kaca dina Wikipédia biasa', # Fuzzy
	'mobile-frontend-featured-article' => 'Artikel Petingan Poé Ieu',
);

/** Swedish (svenska)
 * @author Ainali
 * @author Cybjit
 * @author Diupwijk
 * @author JoolzWiki
 * @author Lokal Profil
 * @author WikiPhoenix
 */
$messages['sv'] = array(
	'mobile-frontend-desc' => 'Mobilt gränssnitt',
	'mobile-frontend-search-submit' => 'Gå till',
	'mobile-frontend-home-button' => 'Huvudsida',
	'mobile-frontend-logged-out' => 'Inte inloggad',
	'mobile-frontend-logged-in-homepage-notification' => 'Välkommen, $1!',
	'mobile-frontend-logged-in-toast-notification' => 'Inloggad som $1.',
	'mobile-frontend-sign-up-heading' => 'Registrera dig',
	'mobile-frontend-sign-in-heading' => 'Logga in',
	'mobile-frontend-sign-in-why' => 'Om du har ett {{SITENAME}}konto kan du logga in nedan.',
	'mobile-frontend-sign-in-error-heading' => 'Hoppsan',
	'mobile-frontend-settings-description' => 'Skräddarsy din upplevelse på din mobila enhet med dessa mobilspecifika inställningar.',
	'mobile-frontend-settings-beta' => 'Beta',
	'mobile-frontend-settings-alpha' => '[//en.wikipedia.org/wiki/Here_be_dragons Läget "Här finns drakar"]',
	'mobile-frontend-settings-alpha-description' => 'Kliv in i det farliga och outforskade mobilterritoriet. Få mer experimentella funktion, men med mer fara för buggar.',
	'mobile-frontend-save-settings' => 'Spara inställningar',
	'mobile-frontend-random-button' => 'Slumpartikel',
	'mobile-frontend-ajax-random-heading' => 'Söker efter kunskap...',
	'mobile-frontend-ajax-random-quote' => 'Intellektuell tillväxt bör påbörjas vid födseln och upphöra endast vid dödsfall',
	'mobile-frontend-ajax-random-question' => 'Läs denna sida?',
	'mobile-frontend-ajax-random-yes' => 'Ja',
	'mobile-frontend-ajax-random-retry' => 'Försök igen',
	'mobile-frontend-ajax-random-suggestions' => 'Andra förslag:',
	'mobile-frontend-back-to-top-of-section' => 'Hoppa ett avsnitt bakåt',
	'mobile-frontend-close-section' => 'Stäng detta avsnitt',
	'mobile-frontend-show-button' => 'Visa',
	'mobile-frontend-hide-button' => 'Göm',
	'mobile-frontend-empty-homepage-text' => 'Denna hemsida måste konfigureras. [http://meta.wikimedia.org/wiki/Mobile_Projects/Mobile_Gateway#Mobile_homepage Instruktioner om hur du får denna mobila webbplats aktiverad]',
	'mobile-frontend-regular-site' => 'Skrivbordsvy',
	'mobile-frontend-wml-continue' => 'Fortsätt ...',
	'mobile-frontend-wml-back' => 'Tillbaka ...',
	'mobile-frontend-view' => 'Mobil vy',
	'mobile-frontend-view-desktop' => 'Stationär dator',
	'mobile-frontend-view-mobile' => 'Mobil',
	'mobile-frontend-opt-in-explain' => 'Genom att gå med i betaprogrammet, får du tillgång till experimentella funktioner, med risk för att stöta på problem och buggar.',
	'mobile-frontend-images-status' => 'Bilder',
	'mobile-frontend-disable-images' => 'Inaktivera bilder på mobilsidan',
	'mobile-frontend-enable-images' => 'Aktivera bilder på mobil webbplats',
	'mobile-frontend-missing-image' => 'Bild',
	'mobile-frontend-off' => 'AV',
	'mobile-frontend-on' => 'PÅ',
	'mobile-frontend-footer-contributors-text' => 'Sida av [$1 bidragsgivare] som dig',
	'mobile-frontend-featured-article' => 'Dagens utvalda artikel',
	'mobile-frontend-news-items' => 'I nyheterna',
	'mobile-frontend-leave-feedback-notice' => 'Din feedback hjälper oss att förbättra din upplevelse på den mobila webbplatsen. Den kommer att publiceras offentligt (tillsammans med ditt användarnamn, webbläsarversion och operativsystem) på sidan "$1". Försök att välja en informativ ämnesrad, t.ex. "formateringsproblem med breda tabeller". Din feedback är föremål för våra Användarvillkor.',
	'mobile-frontend-leave-feedback-warning' => 'Om du inte vill att information om dig ska göras publik, skriv ingen personlig information i dina kommentarer.',
	'mobile-frontend-leave-feedback-subject' => 'Ämne:',
	'mobile-frontend-leave-feedback-message' => 'Meddelande:',
	'mobile-frontend-leave-feedback-submit' => 'Skicka in feedback',
	'mobile-frontend-leave-feedback-link-text' => 'Feedback för mobilgränssnitt',
	'mobile-frontend-leave-feedback' => 'Lämna feedback',
	'mobile-frontend-leave-feedback-title' => 'Feedback för den mobila webbplatsen',
	'mobile-frontend-leave-feedback-technical-problem-section-header' => 'Tekniska problem',
	'mobile-frontend-leave-feedback-general-section-header' => 'Allmänt',
	'mobile-frontend-leave-feedback-article-feedback-section-header' => 'Artikelfeedback',
	'mobile-frontend-leave-feedback-email-body' => 'Beskriv problemet du upplever med {{SITENAME}} ovanför denna rad. Notera att vi inte kan svara på varje meddelande vi får.',
	'mobile-frontend-leave-feedback-technical-link-text' => 'Tekniska problem',
	'mobile-frontend-leave-feedback-general-link-text' => 'Allmän feedback',
	'mobile-frontend-leave-feedback-article-personal-link-text' => 'Det gäller mig, en person eller ett företag jag företräder',
	'mobile-frontend-leave-feedback-article-factual-link-text' => 'Det gäller faktafel',
	'mobile-frontend-leave-feedback-article-other-link-text' => 'Det gäller ett annat problem',
	'mobile-frontend-leave-feedback-form-subject-placeholder' => 'Ämne',
	'mobile-frontend-leave-feedback-form-message-placeholder' => 'Skriv din kommentar här',
	'mobile-frontend-leave-feedback-page-title' => 'Feedback för den mobila webbplatsen',
	'mobile-frontend-leave-feedback-special-title' => 'Kontakta oss',
	'mobile-frontend-feedback-no-subject' => '(inget ämne)',
	'mobile-frontend-feedback-no-subject-field' => 'Ange ett ämne',
	'mobile-frontend-feedback-no-message' => 'Ange ett meddelande här',
	'mobile-frontend-feedback-edit-summary' => '$1 - skickas automatiskt med hjälp av [[Special:MobileFeedback|mobil feedback-verktyget]]',
	'mobile-frontend-leave-feedback-thanks' => 'Tack för din feedback!',
	'mobile-frontend-leave-feedback-post-error' => 'Ett fel uppstod när ditt meddelande behandlades. Försök igen senare.',
	'mobile-frontend-language' => 'Språk:',
	'mobile-frontend-language-article-heading' => 'Läs på ett annat språk',
	'mobile-frontend-language-header' => 'Denna artikel är tillgänglig på $1 {{PLURAL:$1|språk}}',
	'mobile-frontend-language-variant-header' => 'Välj varianten {{#language:{{CONTENTLANG}}}}',
	'mobile-frontend-language-footer' => 'Notera: Denna sida är kanske inte skriven på ditt önskade språk. Du kan se vilka språk {{SITENAME}} stöder genom att klicka här.',
	'mobile-frontend-language-site-choose' => 'Sök språk',
	'mobile-frontend-username' => 'Användarnamn:',
	'mobile-frontend-password' => 'Lösenord:',
	'mobile-frontend-username-placeholder' => 'Användarnamn',
	'mobile-frontend-password-placeholder' => 'Lösenord',
	'mobile-frontend-login' => 'Logga in',
	'mobile-frontend-last-modified-date' => 'Senast redigerad den $1, kl $2',
	'mobile-frontend-last-modified-seconds' => 'Senast redigerad {{PLURAL:$1|$1 sekund|$1 sekunder}} sedan',
	'mobile-frontend-last-modified-minutes' => 'Senast redigerad {{PLURAL:$1|$1 minut|$1 minuter}} sedan',
	'mobile-frontend-last-modified-hours' => 'Senast redigerad {{PLURAL:$1|$1 timme|$1 timmar}} sedan',
	'mobile-frontend-last-modified-days' => 'Senast redigerad {{PLURAL:$1|$1 dag|$1 dagar}} sedan',
	'mobile-frontend-last-modified-months' => 'Senast redigerad {{PLURAL:$1|$1 månad|$1 månader}} sedan',
	'mobile-frontend-last-modified-years' => 'Senast redigerad {{PLURAL:$1|$1 år}} sedan',
	'mobile-frontend-account-create-submit' => 'Registrera dig',
	'mobile-frontend-password-confirm-placeholder' => 'Bekräfta lösenord',
	'mobile-frontend-account-create-email-placeholder' => 'E-postadress (valfritt)',
	'mobile-frontend-account-create-captcha-placeholder' => 'Ange säkerhetstext',
	'mobile-frontend-overlay-escape' => 'Gå tillbaka',
	'mobile-frontend-placeholder' => 'Sök på {{SITENAME}}',
	'mobile-frontend-placeholder-beta' => 'Sök i {{SITENAME}} (Beta)',
	'mobile-frontend-placeholder-alpha' => 'Sök {{SITENAME}} (Drakläge)',
	'mobile-frontend-search-help' => 'Skriv in sökterm ovanför och matchande sidnamn kommer att synas här.',
	'mobile-frontend-dismiss-notification' => 'avfärda detta meddelande',
	'mobile-frontend-clear-search' => 'Rensa',
	'mobile-frontend-privacy-link-text' => 'Sekretess',
	'mobile-frontend-about-link-text' => 'Om',
	'mobile-frontend-footer-sitename' => '{{SITENAME}}',
	'mobile-frontend-footer-license-text' => 'Innehåll som finns tillgängligt under [//en.m.wikipedia.org/wiki/Wikipedia:Text_of_Creative_Commons_Attribution-ShareAlike_3.0_Unported_License?useformat=mobile CC BY-SA 3.0]',
	'mobile-frontend-terms-use-text' => '[//wikimediafoundation.org/wiki/Terms_of_use?useformat=mobile Användarvillkor]',
	'mobile-frontend-footer-contact' => 'Kontakt',
	'mobile-frontend-search-noresults' => 'Inga sidor matchar din sökning. Ändra sökningen eller tryck på tangentbordets sökknapp för att söka inuti sidor.',
	'mobile-frontend-main-menu-button-tooltip' => 'Öppna huvudmenyn',
	'mobile-frontend-main-menu-page-title' => 'Navigering',
	'mobile-frontend-main-menu-featured' => 'Utmärkt',
	'mobile-frontend-main-menu-nearby' => 'I närheten',
	'mobile-frontend-main-menu-login' => 'Logga in',
	'mobile-frontend-main-menu-logout' => 'Logga ut',
	'mobile-frontend-main-menu-watchlist' => 'Bevakningslista',
	'mobile-frontend-main-menu-settings' => 'Inställningar',
	'mobile-frontend-main-menu-settings-heading' => 'Inställningar för mobilsidan',
	'mobile-frontend-settings-site-header' => '{{SITENAME}} språk',
	'mobile-frontend-settings-site-description' => '{{SITENAME}} är tillgängligt på $1 {{PLURAL:$1|språk|språk}}. Alla versioner visas nedan',
	'mobile-frontend-main-menu-contact' => 'Kontakt',
	'mobile-frontend-main-menu-account-create' => 'Skapa konto',
	'mobile-frontend-page-menu-contents' => 'innehåll',
	'mobile-frontend-page-menu-history' => 'Historik',
	'mobile-frontend-meta-data-issues-header' => 'Problem',
	'mobile-frontend-meta-data-issues' => 'Denna sida har några problem',
	'mobile-frontend-ajax-page-loading' => 'Laddar $1',
	'mobile-frontend-page-saving' => 'Sparar $1',
	'mobile-frontend-ajax-page-error' => 'Hoppsan! Något gick fel där. Försök uppdatera webbläsaren.',
	'mobile-frontend-photo-upload-generic' => 'Donera en bild',
	'mobile-frontend-donate-image-title' => 'Donera en bild',
	'mobile-frontend-donate-image-summary' => 'Foton ger liv åt sidorna på {{SITENAME}}.
Det finns många sidor som inte har några foton på grund av allvarlig brist på fritt licensierade bilder.
Hjälp till att ge liv i dessa sidor genom att donera dina bilder som du är villig att ge bort och skulle kunna användas till den bredare redigeringsgemenskapen på {{SITENAME}}.',
	'mobile-frontend-donate-image-heading' => 'Dina senaste bidrag',
	'mobile-frontend-watchlist-add' => 'Lade till $1 till din bevakningslista',
	'mobile-frontend-watchlist-removed' => 'Tog bort $1 från din bevakningslista',
	'mobile-frontend-watchlist-view' => 'Visa din bevakningslista',
	'mobile-frontend-watchlist-more' => 'mer',
	'mobile-frontend-watchlist-cta' => 'Var god logga in eller registrera dig för att titta på denna sida.',
	'mobile-frontend-watchlist-cta-button-login' => 'Logga in',
	'mobile-frontend-watchlist-cta-button-signup' => 'Registrera dig',
	'mobile-frontend-watchlist-a-z' => 'Alla',
	'mobile-frontend-watchlist-feed' => 'Ändrade',
	'mobile-frontend-watchlist-a-z-empty' => 'Du bevakar för tillfället inte några sidor',
	'mobile-frontend-watchlist-a-z-empty-howto-alt' => 'Klicka på stjärnan längst upp på sidan',
	'mobile-frontend-watchlist-feed-empty' => 'Det finns inga sidor med senaste ändringar',
	'mobile-frontend-watchlist-back-home' => 'Tillbaka hem',
	'mobile-frontend-changeslist-ip' => 'Anonym användare',
	'mobile-frontend-changeslist-nocomment' => 'ingen redigeringssammanfattning',
	'mobile-frontend-watchlist-filter-all' => 'Alla',
	'mobile-frontend-watchlist-filter-articles' => 'Artiklar',
	'mobile-frontend-watchlist-filter-talk' => 'Diskussion',
	'mobile-frontend-watchlist-filter-other' => 'Andra',
	'mobile-frontend-watchlist-modified' => 'Redigerades för $1',
	'mobile-frontend-diffview-404-title' => 'Dålig version',
	'mobile-frontend-diffview-title' => 'Ändringar',
	'mobile-frontend-diffview-editcount' => '$1 {{PLURAL:$1|redigering|redigeringar}}',
	'mobile-frontend-diffview-anonymous' => 'Anonym användare',
	'mobile-frontend-diffview-bytesadded' => '$1 {{PLURAL:$1|byte}} lades till',
	'mobile-frontend-diffview-bytesremoved' => '$1 {{PLURAL:$1|byte|}} togs bort',
	'mobile-frontend-diffview-explained' => 'Följande rader har lagts till (+) och tagits bort (-):',
	'mobile-frontend-table' => 'Tabell $1',
	'mobile-frontend-saving-exit-page' => 'Ditt bidrag sparas fortfarande. Om du lämnar din bidrag kommer de förloras. Är du säker på att du vill avsluta?',
	'mobile-frontend-photo-upload' => 'Lägg till det första fotot på denna sida',
	'mobile-frontend-photo-article-edit-comment' => 'Lade till foto för användning på sidan',
	'mobile-frontend-photo-article-donate-comment' => 'Donerad bild från mobiltelefon',
	'mobile-frontend-photo-upload-comment' => 'Lade till foto på sidan',
	'mobile-frontend-photo-upload-progress' => 'Laddar upp din bild till denna sida',
	'mobile-frontend-photo-caption-placeholder' => 'Lägg till en bildtext för denna bild',
	'mobile-frontend-image-loading' => 'Läser in bild',
	'mobile-frontend-image-uploading' => 'Laddar upp bild',
	'mobile-frontend-photo-upload-error' => 'Ett fel uppstod när bilden skulle överföras. Var god prova en annan bild.',
	'mobile-frontend-image-saving-to-article' => 'Spara bilden till sidan',
	'mobile-frontend-photo-license' => 'OBS: Alla foton du publicerar kommer att publiceras under licensen [//en.wikipedia.org/wiki/Wikipedia:Text_of_Creative_Commons_Attribution-ShareAlike_3.0_Unported_License CC BY-SA 3.0]',
	'tag-mobile_edit' => 'Mobilredigering',
	'tag-mobile_edit-description' => 'Redigering gjordes från mobilsidan',
	'mobile-frontend-drawer-cancel' => 'Avbryt',
);

/** Swahili (Kiswahili)
 * @author Kwisha
 * @author Muddyb Blast Producer
 * @author Stephenwanjau
 */
$messages['sw'] = array(
	'mobile-frontend-search-submit' => 'Nenda',
	'mobile-frontend-home-button' => 'Mwanzo',
	'mobile-frontend-logged-out' => 'Hujaingia',
	'mobile-frontend-save-settings' => 'Hifadhi mpangilio',
	'mobile-frontend-random-button' => 'Bahatisha',
	'mobile-frontend-back-to-top-of-section' => 'Rudi Sehemu A',
	'mobile-frontend-close-section' => 'Funga sehemu hii',
	'mobile-frontend-show-button' => 'Onyesha',
	'mobile-frontend-hide-button' => 'Ficha',
	'mobile-frontend-regular-site' => 'Onesha ukurasa huu katika {{SITENAME}} ya kawaida',
	'mobile-frontend-wml-continue' => 'Endelea...',
	'mobile-frontend-wml-back' => 'Nyuma...',
	'mobile-frontend-view' => 'Mtazamo wa rununu',
	'mobile-frontend-view-desktop' => 'Dawati',
	'mobile-frontend-view-mobile' => 'Simu ya rununu',
	'mobile-frontend-images-status' => 'Picha',
	'mobile-frontend-enable-images' => 'Wezesha picha katika wavuti wa simu ya rununu',
	'mobile-frontend-featured-article' => 'Makala Bora ya Leo',
	'mobile-frontend-news-items' => 'Katika habari',
	'mobile-frontend-leave-feedback-subject' => 'Mada:',
	'mobile-frontend-leave-feedback-message' => 'Ujumbe:',
	'mobile-frontend-leave-feedback-general-section-header' => 'Jumla',
	'mobile-frontend-leave-feedback-article-feedback-section-header' => 'Maoni ya makala',
	'mobile-frontend-leave-feedback-email-body' => 'Tafadhali andika anwani ya barua pepe juu ya laini hii.', # Fuzzy
	'mobile-frontend-leave-feedback-technical-link-text' => 'Shida ya kimitambo',
	'mobile-frontend-leave-feedback-general-link-text' => 'Maoni ya ujumla',
	'mobile-frontend-leave-feedback-article-personal-link-text' => 'Kunihusu mimi, mtu au kampuni ninayowakilisha',
	'mobile-frontend-leave-feedback-form-subject-placeholder' => 'Mada ya ujumbe',
	'mobile-frontend-leave-feedback-form-message-placeholder' => 'Andika maoni yako hapa',
	'mobile-frontend-leave-feedback-page-title' => 'Maoni ya wavuti wa simu ya rununu',
	'mobile-frontend-leave-feedback-special-title' => 'Wasiliana nasi',
	'mobile-frontend-feedback-no-subject' => '(hakuna mada)',
	'mobile-frontend-feedback-no-subject-field' => 'Tafadhali ingiza mada',
	'mobile-frontend-feedback-no-message' => 'Tafadhali ingiza ujumbe hapa',
	'mobile-frontend-leave-feedback-thanks' => 'Asante kwa maoni yako',
	'mobile-frontend-language' => 'Lugha:',
	'mobile-frontend-language-header' => 'Makala haya yanapatikana katika {{PLURAL:$1|language|lugha}} $1', # Fuzzy
	'mobile-frontend-language-site-choose' => 'Tafuta lugha',
	'mobile-frontend-username' => 'Jina la mtumiaji:',
	'mobile-frontend-password' => 'Nywila:',
	'mobile-frontend-login' => 'Ingia',
	'mobile-frontend-placeholder' => 'Tafuta {{SITENAME}}',
	'mobile-frontend-dismiss-notification' => 'futilia mbali arifa hii',
	'mobile-frontend-clear-search' => 'Futa',
	'mobile-frontend-privacy-link-text' => 'Faragha',
	'mobile-frontend-about-link-text' => 'Kuhusu',
	'mobile-frontend-footer-sitename' => '{{SITENAME}}',
	'mobile-frontend-footer-contact' => 'Mawasiliano',
	'mobile-frontend-main-menu-nearby' => 'Karibu',
	'mobile-frontend-main-menu-settings' => 'Mpangilio',
	'mobile-frontend-main-menu-settings-heading' => 'Mpangilio wa wavuti wa simu ya rununu',
	'mobile-frontend-settings-site-header' => '{{SITENAME}} Lugha',
	'mobile-frontend-settings-site-description' => '{{SITENAME}} inapatikana katika $1 {{PLURAL:$1|language|lugha}}. Toleo zote zinazopatikana zimeorodhweshwa hapa chini',
	'mobile-frontend-main-menu-contact' => 'Mawasiliano',
	'mobile-frontend-page-menu-contents' => 'Maudhui',
	'mobile-frontend-page-menu-history' => 'Historia',
);

/** Silesian (ślůnski)
 */
$messages['szl'] = array(
	'mobile-frontend-home-button' => 'Přodńo zajta',
);

/** Tamil (தமிழ்)
 * @author Balajijagadesh
 * @author Karthi.dr
 * @author Logicwiki
 * @author Shanmugamp7
 * @author Sodabottle
 * @author Surya Prakash.S.A.
 * @author மதனாஹரன்
 */
$messages['ta'] = array(
	'mobile-frontend-desc' => 'கைபேசி முகப்பு',
	'mobile-frontend-search-submit' => 'செல்',
	'mobile-frontend-home-button' => 'முகப்பு',
	'mobile-frontend-logged-out' => 'புகுபதிகை செய்யப்படவில்லை',
	'mobile-frontend-logged-in-homepage-notification' => 'வருக $1',
	'mobile-frontend-logged-in-toast-notification' => '$1 என்ற பெயரிலான புகுபதிகை',
	'mobile-frontend-sign-up-heading' => 'பதிவுசெய்',
	'mobile-frontend-sign-in-heading' => 'புகுபதிகை',
	'mobile-frontend-sign-in-error-heading' => 'ஓ!',
	'mobile-frontend-settings-beta' => 'பீட்டா',
	'mobile-frontend-save-settings' => 'அமைப்புகளை சேமி',
	'mobile-frontend-random-button' => 'ஏதாவது ஒரு',
	'mobile-frontend-ajax-random-question' => 'இப்பக்கத்தை படித்தீர்களா?',
	'mobile-frontend-ajax-random-yes' => 'ஆம்',
	'mobile-frontend-ajax-random-retry' => 'மீண்டும் முயலவும்',
	'mobile-frontend-ajax-random-suggestions' => 'மற்ற பரிந்துரைகள்:',
	'mobile-frontend-back-to-top-of-section' => 'முதல் பத்திக்குச் செல்',
	'mobile-frontend-close-section' => 'இப்பகுதியை மூடுக',
	'mobile-frontend-show-button' => 'காட்டு',
	'mobile-frontend-hide-button' => 'மறை',
	'mobile-frontend-empty-homepage-text' => 'இந்த முகப்பு பக்கம் கைபேசி  தளத்திற்கேற்றார்போல் அமைக்கப்படவேண்டும். <a href="http://meta.wikimedia.org/wiki/Mobile_Projects/Mobile_Gateway#Mobile_homepage">விவரங்களுக்கு பார்க்க</a>', # Fuzzy
	'mobile-frontend-regular-site' => 'இப்பக்கத்தை வழக்கமான {{SITENAME}} தளத்தில் காண',
	'mobile-frontend-wml-continue' => 'தொடர்க...',
	'mobile-frontend-wml-back' => 'பின்னால்...',
	'mobile-frontend-view' => 'கைபேசிப் பார்வை',
	'mobile-frontend-view-desktop' => 'கணினி பதிப்பு',
	'mobile-frontend-view-mobile' => 'கைபேசி',
	'mobile-frontend-images-status' => 'படங்கள்',
	'mobile-frontend-disable-images' => 'கைபேசித் தளத்தில் படிமங்களைச் செயலிழக்கச் செய்க',
	'mobile-frontend-enable-images' => 'கைபேசித் தளத்தில் படிமங்களைச் செயற்படுத்துக',
	'mobile-frontend-missing-image' => 'படம்',
	'mobile-frontend-off' => 'அணை',
	'mobile-frontend-on' => 'இயங்குகிறது',
	'mobile-frontend-footer-contributors-text' => 'உங்களைப் போன்ற <a href="$1">பங்களிப்பாளர்களின்</a> கட்டுரை', # Fuzzy
	'mobile-frontend-featured-article' => 'முதற்பக்கக் கட்டுரைகள்',
	'mobile-frontend-news-items' => 'செய்திகளில்',
	'mobile-frontend-leave-feedback-notice' => 'உங்கள் கருத்துக்கள் எங்களை கைபேசி தளத்தை மேம்படுத்த உதவும். உங்கள் பயனர் பெயர், உலாவி பதிப்பு, இயங்குதளம் போன்ற விவரங்களோடு கருத்துக்கள் அனைவராலும் பார்க்கக் கூடிய "$1" பக்கத்தில் இடம்பெறும்; உங்கள் கருத்துக்களுக்கு முறையாக தலைப்பிடுங்கள், உதா. "பக்க வடிவத்தில் அகலமான அட்டவணைகள் தெரிகின்றன". உங்கள் கருத்துக்கள் எங்களது பயன்பாட்டு விதிமுறைகளுக்கு உட்பட்டது.',
	'mobile-frontend-leave-feedback-warning' => 'உங்கள் விவரங்களைப் பொதுவில் அளிக்க நீங்கள்  ஒத்துக்கொள்ளாவிடில் அருள்கூர்ந்து உங்கள் கருத்துரைகளில் தனிப்பட்ட விவரங்களைத் தர வேண்டாம்.',
	'mobile-frontend-leave-feedback-subject' => 'தலைப்பு:',
	'mobile-frontend-leave-feedback-message' => 'தகவல்:',
	'mobile-frontend-leave-feedback-submit' => 'கருத்தைச் சமர்ப்பிக்கவும்',
	'mobile-frontend-leave-feedback-link-text' => 'MobileFrontend விரிவாக்க கருத்து',
	'mobile-frontend-leave-feedback' => 'கைப்பேசி தளத்தின் கருத்து',
	'mobile-frontend-leave-feedback-title' => 'கைபேசித் தளத்தைப் பற்றிய கருத்துகளைத் தரவும்',
	'mobile-frontend-leave-feedback-technical-problem-section-header' => 'தொழில்நுட்பக் கோளாறு / பின்னூட்டம்',
	'mobile-frontend-leave-feedback-general-section-header' => 'பொது',
	'mobile-frontend-leave-feedback-article-feedback-section-header' => 'கட்டுரைக்கான கருத்து',
	'mobile-frontend-leave-feedback-email-body' => 'அருள்கூர்ந்து இந்த வரிக்கு மேல் உங்கள் மின்னஞ்சலை எழுதவும்.', # Fuzzy
	'mobile-frontend-leave-feedback-technical-link-text' => 'தொழில்நுட்பக் கோளாறு',
	'mobile-frontend-leave-feedback-general-link-text' => 'பொதுவான கருத்து',
	'mobile-frontend-leave-feedback-article-personal-link-text' => 'என்னையோ, ஒரு நபரையோ அல்லது நான் பிரதிநிதியாக இருக்கும் நிறுவனம் தொடர்பாக',
	'mobile-frontend-leave-feedback-article-factual-link-text' => 'மெய் தன்மை குறிதது',
	'mobile-frontend-leave-feedback-article-other-link-text' => 'மற்றொரு சிக்கல் பற்றி',
	'mobile-frontend-leave-feedback-form-subject-placeholder' => 'தகவலின் பொருள்',
	'mobile-frontend-leave-feedback-form-message-placeholder' => 'உங்கள் கருத்தை இங்கு தட்டச்சு செய்யவும்',
	'mobile-frontend-leave-feedback-page-title' => 'கைபேசித் தளம் பற்றி கருத்துக்கள்',
	'mobile-frontend-leave-feedback-special-title' => 'எங்களைத் தொடர்புகொள்ள',
	'mobile-frontend-feedback-no-subject' => '(தலைப்பு இல்லை)',
	'mobile-frontend-feedback-no-subject-field' => 'தயவுசெய்து ஒரு தலைப்பை இடுங்கள்',
	'mobile-frontend-feedback-no-message' => 'தயவுசெய்து ஒரு தகவலை உள்ளீடுக',
	'mobile-frontend-feedback-edit-summary' => '$1 - [[Special:MobileFeedback|கைபேசிப் பின்னூட்டக் கருவியின்]] மூலம் தானியங்கு முறையில் பதிவு செய்யப்பட்டது',
	'mobile-frontend-leave-feedback-thanks' => 'உங்கள் கருத்துக்கு நன்றி.',
	'mobile-frontend-leave-feedback-post-error' => 'தங்கள் தகவலைச் செயல்படுத்துவதில் ஒரு பிழை ஏற்பட்டுள்ளது. மீண்டும் முயற்சிக்கவும்.',
	'mobile-frontend-language' => 'மொழி:',
	'mobile-frontend-language-article-heading' => 'வேறொரு மொழியில் படிக்கவும்',
	'mobile-frontend-language-header' => 'இக்கட்டுரை $1 {{PLURAL:$1|மொழியில்|மொழிகளில்}} உள்ளது', # Fuzzy
	'mobile-frontend-language-footer' => 'ஏனைய மொழிகளில் {{SITENAME}} உள்ளது.', # Fuzzy
	'mobile-frontend-language-site-choose' => 'மொழியை தேடு',
	'mobile-frontend-username' => 'பயனர் பெயர்:',
	'mobile-frontend-password' => 'கடவுச்சொல்:',
	'mobile-frontend-username-placeholder' => 'பயனர் பெயர்',
	'mobile-frontend-password-placeholder' => 'கடவுச்சொல்',
	'mobile-frontend-login' => 'புகுபதிகை',
	'mobile-frontend-account-create-submit' => 'பதிவுசெய்',
	'mobile-frontend-password-confirm-placeholder' => 'கடவுச்சொல்லை உறுதிசெய்',
	'mobile-frontend-account-create-email-placeholder' => 'மின்னஞ்சல் முகவரி (விருப்பத்தேர்வு)',
	'mobile-frontend-account-create-captcha-placeholder' => 'பாதுகாப்பு உரையை உள்ளிடவும்',
	'mobile-frontend-overlay-escape' => 'பின் செல்லவும்',
	'mobile-frontend-placeholder' => '{{SITENAME}} - இல் தேடுக',
	'mobile-frontend-dismiss-notification' => 'இந்த அறிவிப்பை அகற்று',
	'mobile-frontend-clear-search' => 'வெறுமையாக்கு',
	'mobile-frontend-privacy-link-text' => 'தகவல் பாதுகாப்பு',
	'mobile-frontend-about-link-text' => 'விவரம்',
	'mobile-frontend-footer-sitename' => '{{SITENAME}}',
	'mobile-frontend-footer-contact' => 'தொடர்புக்கு',
	'mobile-frontend-main-menu-button-tooltip' => 'முதன்மை பட்டியைத் திறக்கவும்',
	'mobile-frontend-main-menu-page-title' => 'தள வழிசெலுத்துதல்',
	'mobile-frontend-main-menu-featured' => 'சிறப்பானவை',
	'mobile-frontend-main-menu-nearby' => 'அருகிலுள்ள',
	'mobile-frontend-main-menu-login' => 'புகுபதிகை',
	'mobile-frontend-main-menu-logout' => 'விடுபதிகை',
	'mobile-frontend-main-menu-watchlist' => 'கவனிப்புப் பட்டியல்',
	'mobile-frontend-main-menu-settings' => 'அமைப்புகள்',
	'mobile-frontend-main-menu-upload' => 'பதிவேற்றுக',
	'mobile-frontend-main-menu-settings-heading' => 'அலைபேசி தள அமைப்புகள்',
	'mobile-frontend-settings-site-header' => '{{SITENAME}} மொழிகள்',
	'mobile-frontend-settings-site-description' => '$1 {{PLURAL:$1|மொழியில்|மொழிகளில்}} {{SITENAME}} உள்ளது. கிடைக்கின்ற அனைத்துப் பதிப்புகளும் கீழே பட்டியலிடப்பட்டுள்ளன',
	'mobile-frontend-main-menu-contact' => 'தொடர்புக்கு',
	'mobile-frontend-main-menu-account-create' => 'கணக்கை உருவாக்கு',
	'mobile-frontend-page-menu-contents' => 'பொருளடக்கம்',
	'mobile-frontend-page-menu-history' => 'வரலாறு',
	'mobile-frontend-meta-data-issues-header' => 'பிரச்னைகள்',
	'mobile-frontend-meta-data-issues' => 'இந்த பக்கம் சில பிரச்சனைகளை கொண்டுள்ளது',
	'mobile-frontend-ajax-page-loading' => '$1 ஏற்றப்படுகிறது',
	'mobile-frontend-page-saving' => '$1 சேமிக்கப்படுகிறது',
	'mobile-frontend-ajax-page-error' => 'ஏதோ தவறு நடந்துள்ளது. தயவுசெய்து உங்களது உலாவியை புதுப்பித்து மீண்டும் முயலவும்.',
	'mobile-frontend-nearby-title' => 'அருகிலுள்ள',
	'mobile-frontend-nearby-lookup-error' => 'கண்டுபிடிக்க முடியவில்லை. மீண்டும் முயற்சிக்கவும்',
	'mobile-frontend-donate-image-login' => 'உங்கள் பதிவேற்றத்தைப்பார்க்க உள்நுழையவும்',
	'mobile-frontend-photo-upload-generic' => 'ஒரு படத்தை கொடையளிக்கவும்',
	'mobile-frontend-donate-image-title' => 'ஒரு படத்தை கொடையளிக்கவும்',
	'mobile-frontend-donate-image-heading' => 'உங்களது அண்மைய பங்களிப்புகள்',
	'mobile-frontend-donate-image-page-title' => 'பதிவேற்றுக',
	'mobile-frontend-listed-image-no-description' => 'விவரனை இல்லை',
	'mobile-frontend-donate-photo-first-upload-success' => 'வெற்றி ! தங்கள் முதல் பங்களிப்பிற்கு நன்றி !',
	'mobile-frontend-watchlist-add' => '$1 உங்களது கவனிப்புப் பட்டியலில் சேர்க்கப்பட்டது.',
	'mobile-frontend-watchlist-removed' => '$1 உங்களது கவனிப்புப் பட்டியலிலிருந்து நீக்கப்பட்டது',
	'mobile-frontend-watchlist-view' => 'உங்களது கவனிப்புப் பட்டியலைக் காண்க',
	'mobile-frontend-watchlist-more' => 'மேலும்',
	'mobile-frontend-watchlist-cta' => 'இந்த பக்கத்தை கவனிக்க புகுபதிகை செய்யவும் அல்லது பதிவு செய்யவும்',
	'mobile-frontend-watchlist-cta-button-login' => 'புகுபதிகை',
	'mobile-frontend-watchlist-cta-button-signup' => 'பதிவுசெய்',
	'mobile-frontend-watchlist-a-z' => 'கவனிக்கப்பட்ட பக்கங்கள்', # Fuzzy
	'mobile-frontend-watchlist-feed' => 'மாற்றங்களுடன் கூடிய பக்கங்கள்', # Fuzzy
	'mobile-frontend-watchlist-a-z-empty' => 'தற்பொழுது தாங்கள் எந்த பக்கமும் கவனிக்கவில்லை',
	'mobile-frontend-watchlist-a-z-empty-howto-alt' => 'பக்கத்தில் தொடக்கத்தில் உள்ள நட்சத்திரத்தை சொடுக்கவும்',
	'mobile-frontend-watchlist-feed-empty' => 'தற்பொழுதைய மாற்றங்கள் கொண்ட பக்கங்கள் ஏதும் இல்லை',
	'mobile-frontend-changeslist-ip' => 'அடையாளம் காட்டாத பயனர்',
	'mobile-frontend-changeslist-nocomment' => 'தொகுப்பு சுருக்கம் இல்லை',
	'mobile-frontend-watchlist-filter-all' => 'அனைத்தும்',
	'mobile-frontend-watchlist-filter-articles' => 'கட்டுரைகள்',
	'mobile-frontend-watchlist-filter-talk' => 'உரையாடல்',
	'mobile-frontend-watchlist-filter-other' => 'மற்றவை',
	'mobile-frontend-diffview-title' => '$1 -க்கு மாறவும்', # Fuzzy
	'mobile-frontend-diffview-editcount' => '$1 {{PLURAL:$1|தொகுப்புதொகுப்புகள்}}',
	'mobile-frontend-diffview-anonymous' => 'அடையாளம் காட்டாத பயனர்',
	'mobile-frontend-diffview-bytesadded' => '$1 {{PLURAL:$1|பைட்டு|பைட்டுகள்}} சேர்க்கப்பட்டது',
	'mobile-frontend-diffview-bytesremoved' => '$1 {{PLURAL:$1|பைட்டு|பைட்டுகள்}} நீக்கப்பட்டது',
	'mobile-frontend-table' => 'அட்டவணை $1',
	'mobile-frontend-photo-upload' => 'இந்ந பக்கத்திற்கு ஒரு படம் சேர்க்கவும்',
	'mobile-frontend-photo-upload-comment' => 'பக்கத்திற்கு படம் சேர்க்கப்பட்டுள்ளது',
	'mobile-frontend-image-loading' => 'படிமம் ஏற்றப்படுகிறது',
	'mobile-frontend-image-uploading-wait' => 'படம் பதிவேற்றப்படுகிறது', # Fuzzy
	'mobile-frontend-photo-upload-error' => 'தவறு, மீண்டும் முயற்சிக்கவும்.',
	'mobile-frontend-photo-submit' => 'சமர்ப்பி',
	'mobile-frontend-photo-cancel' => 'விட்டுவிடு',
	'mobile-frontend-photo-upload-user-count-over-limit' => '500+ பதிவேற்றங்கள்',
	'mobile-frontend-drawer-cancel' => 'விட்டுவிடு',
);

/** Telugu (తెలుగు)
 * @author Jprmvnvijay5
 * @author Veeven
 * @author Wellwisher
 */
$messages['te'] = array(
	'mobile-frontend-search-submit' => 'వెళ్ళు',
	'mobile-frontend-home-button' => 'ముంగిలి',
	'mobile-frontend-settings-beta' => 'బీటా',
	'mobile-frontend-save-settings' => 'అమరికలను భద్రపరచు',
	'mobile-frontend-random-button' => 'యాదృచ్చిక',
	'mobile-frontend-back-to-top-of-section' => 'ఒక విభాగం వెనక్కి గెంతండి',
	'mobile-frontend-close-section' => 'ఈ విభాగాన్ని మూసివేయుము',
	'mobile-frontend-show-button' => 'చూపించు',
	'mobile-frontend-hide-button' => 'దాచు',
	'mobile-frontend-regular-site' => 'ఈ పేజీని మామూలు {{SITENAME}}లో చూడండి', # Fuzzy
	'mobile-frontend-wml-continue' => 'కొనసాగించు ...',
	'mobile-frontend-wml-back' => 'వెనుకకు ...',
	'mobile-frontend-view' => 'మొబైల్ వీక్షణ',
	'mobile-frontend-images-status' => 'బొమ్మలు',
	'mobile-frontend-off' => 'చూపించకు',
	'mobile-frontend-on' => 'చూపించు',
	'mobile-frontend-footer-contributors-text' => 'వ్యాసం వ్రాసినది మీ లాంటి <a href="$1">ఔత్సాహికులు</a>', # Fuzzy
	'mobile-frontend-featured-article' => 'నేటి విశేష వ్యాసం',
	'mobile-frontend-news-items' => 'వార్తల్లో',
	'mobile-frontend-leave-feedback-warning' => 'మీ సమాచారాన్ని బహిరంగపచాలనుకుంటే తప్ప, మీ వ్యాఖ్యలలో వ్యక్తిగత సమాచారాన్ని ఇవ్వకండి.',
	'mobile-frontend-leave-feedback-subject' => 'విషయం:',
	'mobile-frontend-leave-feedback-message' => 'సందేశం:',
	'mobile-frontend-leave-feedback-submit' => 'అభిప్రాయమును సమర్పించు',
	'mobile-frontend-leave-feedback-technical-problem-section-header' => 'సాంకేతిక సమస్య',
	'mobile-frontend-leave-feedback-general-section-header' => 'సాధారణం',
	'mobile-frontend-leave-feedback-article-feedback-section-header' => 'వ్యాసంపై ప్రతిస్పందన',
	'mobile-frontend-leave-feedback-email-body' => 'ఈ పంక్తిపైన మీ ఈమెయిల్‌ను రాయుము', # Fuzzy
	'mobile-frontend-leave-feedback-technical-link-text' => 'సాంకేతిక సమస్య',
	'mobile-frontend-leave-feedback-article-factual-link-text' => 'అనివార్య తప్పిదమునందు',
	'mobile-frontend-leave-feedback-article-other-link-text' => 'ఇతర లోపము కొరకై',
	'mobile-frontend-leave-feedback-form-subject-placeholder' => 'సందేశ విషయం',
	'mobile-frontend-leave-feedback-form-message-placeholder' => 'మీ వ్యాఖ్యను ఇక్కడ వ్రాయండి',
	'mobile-frontend-leave-feedback-special-title' => 'మమ్మల్ని సంప్రదించండి',
	'mobile-frontend-feedback-no-subject' => '(విషయం లేదు)',
	'mobile-frontend-feedback-no-subject-field' => 'పాఠ్యాంశమును రాయుము',
	'mobile-frontend-feedback-no-message' => ' ఇక్కడ సమాచారమును రాయండి',
	'mobile-frontend-leave-feedback-thanks' => 'మీ ప్రతిస్పందనకు కృతజ్ఞతలు!',
	'mobile-frontend-leave-feedback-post-error' => 'ఈ సందేశాన్ని పరిక్రియాపన చెయ్యడంలో పొరపాటు జరిగింది. దయచేసి కాసేపాగి ప్రయత్నించండి.',
	'mobile-frontend-language' => 'భాష:',
	'mobile-frontend-language-header' => 'ఈ వ్యాసం $1 {{PLURAL:$1|భాషలో|భాషలలో}} లభ్యం', # Fuzzy
	'mobile-frontend-language-footer' => 'గమనిక: ఈ వ్యాసం మీ భాషలో లేకపోవచ్చు. {{SITENAME}} ఏయో భాషలలో లభిస్తుందో ఇక్కడ నొక్కి తెలుసుకోవచ్చు.', # Fuzzy
	'mobile-frontend-language-site-choose' => 'వెతికే భాష',
	'mobile-frontend-username' => 'వాడుకరి పేరు:',
	'mobile-frontend-password' => 'సంకేతపదం:',
	'mobile-frontend-login' => 'ప్రవేశించండి',
	'mobile-frontend-placeholder' => 'మీ శోధనపదమును ఇక్కడ రాయుము', # Fuzzy
	'mobile-frontend-search-help' => 'పైన శోధనపదమును రాసినచో, సంబంధిత సంచికలు ఇక్కడ కనిపించును', # Fuzzy
	'mobile-frontend-dismiss-notification' => 'ఈ చాటింపును తొలగించు',
	'mobile-frontend-clear-search' => 'తుడిచివేయి',
	'mobile-frontend-privacy-link-text' => 'మరుగు',
	'mobile-frontend-about-link-text' => 'గురించి',
	'mobile-frontend-footer-sitename' => '{{SITENAME}}',
	'mobile-frontend-footer-contact' => 'సంప్రదింపులు',
	'mobile-frontend-main-menu-nearby' => 'దగ్గరలో',
	'mobile-frontend-main-menu-settings' => 'అమరికలు',
	'mobile-frontend-main-menu-settings-heading' => 'మొబైలు సైటు అమరికలు',
	'mobile-frontend-settings-site-header' => '{{SITENAME}} భాషలు',
	'mobile-frontend-settings-site-description' => '{{SITENAME}} $1 {{PLURAL:$1|భాషలో|భాషలలో}} లభ్యమవుతూంది. లభ్యమయ్యే సంచికలు అన్నీ క్రింద ఇవ్వబడ్డాయి',
	'mobile-frontend-main-menu-contact' => 'సంప్రదింపులు',
	'mobile-frontend-page-menu-contents' => 'విషయ సూచిక',
	'mobile-frontend-page-menu-history' => 'చరిత్ర',
);

/** Tajik (Cyrillic script) (тоҷикӣ)
 * @author Ibrahim
 */
$messages['tg-cyrl'] = array(
	'mobile-frontend-search-submit' => 'Бирав',
	'mobile-frontend-home-button' => 'Хона',
	'mobile-frontend-random-button' => 'Тасодуфӣ',
	'mobile-frontend-back-to-top-of-section' => 'Бозгашт Ба Қисмати A',
	'mobile-frontend-show-button' => 'Намоиш',
	'mobile-frontend-hide-button' => 'Нуҳуфтан',
	'mobile-frontend-regular-site' => 'Намоиши ин саҳифа дар Википедиаи маъмулӣ', # Fuzzy
	'mobile-frontend-view-desktop' => 'Компютер',
	'mobile-frontend-view-mobile' => 'Мобил',
	'mobile-frontend-off' => 'Хомӯш',
	'mobile-frontend-on' => 'Равшан',
	'mobile-frontend-featured-article' => 'Мақолаи Баргузидаи Имрӯз',
);

/** Tajik (Latin script) (tojikī)
 */
$messages['tg-latn'] = array(
	'mobile-frontend-search-submit' => 'Birav',
	'mobile-frontend-home-button' => 'Xona',
	'mobile-frontend-random-button' => 'Tasodufī',
	'mobile-frontend-back-to-top-of-section' => 'Bozgaşt Ba Qismati A',
	'mobile-frontend-show-button' => 'Namoiş',
	'mobile-frontend-hide-button' => 'Nuhuftan',
	'mobile-frontend-featured-article' => 'Maqolai Barguzidai Imrūz',
);

/** Thai (ไทย)
 * @author Horus
 */
$messages['th'] = array(
	'mobile-frontend-search-submit' => 'ไป',
	'mobile-frontend-home-button' => 'หน้าหลัก',
	'mobile-frontend-random-button' => 'สุ่ม',
	'mobile-frontend-back-to-top-of-section' => 'กลับไปที่หัวข้อ',
	'mobile-frontend-show-button' => 'แสดง',
	'mobile-frontend-hide-button' => 'ซ่อน',
	'mobile-frontend-regular-site' => 'ดูหน้านี้ในวิกิพีเดียรุ่นปกติ', # Fuzzy
	'mobile-frontend-view' => 'รุ่นโมบายล์',
	'mobile-frontend-featured-article' => 'บทความคัดสรรวันนี้',
	'mobile-frontend-news-items' => 'เรื่องจากข่าว',
	'mobile-frontend-leave-feedback-message' => 'ข้อความ', # Fuzzy
	'mobile-frontend-language' => 'ภาษา', # Fuzzy
);

/** Turkmen (Türkmençe)
 */
$messages['tk'] = array(
	'mobile-frontend-search-submit' => 'Git',
	'mobile-frontend-show-button' => 'Görkez',
);

/** Tagalog (Tagalog)
 * @author AnakngAraw
 */
$messages['tl'] = array(
	'mobile-frontend-desc' => 'Harapan ng hulihan ng paglilipat-lipat',
	'mobile-frontend-search-submit' => 'Gawin',
	'mobile-frontend-home-button' => 'Tahanan',
	'mobile-frontend-logged-out' => 'Hindi nakalagda',
	'mobile-frontend-settings-description' => 'Ipasadya ang karanasan mo sa iyong kasangkapang naililipat-lipat sa pamamagitan ng tiyak na mga katakdaang pampook na ito na naililipat-lipat.',
	'mobile-frontend-settings-beta' => 'Beta',
	'mobile-frontend-save-settings' => 'Sagipin ang mga katakdaan',
	'mobile-frontend-random-button' => 'Alin man',
	'mobile-frontend-back-to-top-of-section' => 'Tumalong Pabalik Ng Isang Seksyon',
	'mobile-frontend-close-section' => 'Isara ang bahaging ito',
	'mobile-frontend-show-button' => 'Ipakita',
	'mobile-frontend-hide-button' => 'Itago',
	'mobile-frontend-empty-homepage-text' => 'Ang tahanang pahinang ito ay kailangang maisaayos. <a href="http://meta.wikimedia.org/wiki/Mobile_Projects/Mobile_Gateway#Mobile_homepage">Mga tagubilin sa kung paano mapapagana ang mobil na ito ng pook</a>', # Fuzzy
	'mobile-frontend-regular-site' => 'Pagtanaw na nasa ibabaw ng mesa',
	'mobile-frontend-wml-continue' => 'Magpatuloy...',
	'mobile-frontend-wml-back' => 'Bumalik...',
	'mobile-frontend-view' => 'Tanawing naililipat-lipat',
	'mobile-frontend-view-desktop' => 'Ibabaw ng mesa',
	'mobile-frontend-view-mobile' => 'Naililipat-lipat',
	'mobile-frontend-opt-in-explain' => 'Sa pagsali sa beta, magkakaroon ka ng pagkanakakapunta sa mga tampok na iniiksperimento, na maaaring makipagsapalaran sa pagharap sa mga sira at mga suliranin.',
	'mobile-frontend-images-status' => 'Mga larawan',
	'mobile-frontend-disable-images' => 'Huwag paganahin ang mga larawan sa pook na naililipat-lipat',
	'mobile-frontend-enable-images' => 'Paganahina ng mga larawan sa pook na naililipat-lipat',
	'mobile-frontend-off' => 'HUWAG BUHAYIN',
	'mobile-frontend-on' => 'BUHAYIN',
	'mobile-frontend-footer-contributors-text' => 'Artikulo ng <a href="$1">mga tagapag-ambag</a> na katulad mo', # Fuzzy
	'mobile-frontend-featured-article' => 'Napiling Artikulo Ngayon',
	'mobile-frontend-news-items' => 'Nasa Balita',
	'mobile-frontend-leave-feedback-notice' => 'Ang tugon mo ay nakakatulong sa amin na mapainam ang iyong karanasan sa pook na naililipat-lipat. Ipapaskil ito sa madla (kasama ang iyong pangalan ng tagagamit, bersiyon ng pantingin-tingin at sistemang pampaandar) sa pahinang &quot;$1&quot;. Paki sumubok na pumili ng isang makabatirang pananalita na pangpaksa, halimbawa na ang "Mga suliranin sa pagpopormat ng malalapad na mga talahanayan". Ang tugon mo ay nasasaklawan ng aming mga hinihingi sa paggamit.',
	'mobile-frontend-leave-feedback-warning' => 'Maliban na lamang kung sumasang-ayon ka na maging pangmadla ang kabatiran mo, paki huwag magsama ng pansariling impormasyon sa loob ng mga puna mo.',
	'mobile-frontend-leave-feedback-subject' => 'Paksa:',
	'mobile-frontend-leave-feedback-message' => 'Mensahe:',
	'mobile-frontend-leave-feedback-submit' => 'Ipasa ang tugon',
	'mobile-frontend-leave-feedback-link-text' => 'Tugon ng Dugtong ng Harapan ng Likuran na Naililipat-lipat',
	'mobile-frontend-leave-feedback' => 'Tugon ng pook na napapagalaw',
	'mobile-frontend-leave-feedback-title' => 'Tugon ng pook na napapagalaw',
	'mobile-frontend-leave-feedback-technical-problem-section-header' => 'Suliraning teknikal',
	'mobile-frontend-leave-feedback-general-section-header' => 'Pangkalahatan',
	'mobile-frontend-leave-feedback-article-feedback-section-header' => 'Tugon sa artikulo',
	'mobile-frontend-leave-feedback-email-body' => 'Pakisulat ang e-liham mo sa ibabaw ng guhit na ito.', # Fuzzy
	'mobile-frontend-leave-feedback-technical-link-text' => 'Suliraning teknikal',
	'mobile-frontend-leave-feedback-general-link-text' => 'Pangkalahatang katugunan',
	'mobile-frontend-leave-feedback-article-personal-link-text' => 'Tungkol sa akin, isang tao, o isang kumpanyang kinakatawan ko',
	'mobile-frontend-leave-feedback-article-factual-link-text' => 'Hinggil sa kamaliang batay sa pangyayari',
	'mobile-frontend-leave-feedback-article-other-link-text' => 'Hinggil sa ibang suliranin',
	'mobile-frontend-leave-feedback-form-subject-placeholder' => 'Paksa ng mensahe',
	'mobile-frontend-leave-feedback-form-message-placeholder' => 'Makinilyahin dito ang puna mo',
	'mobile-frontend-leave-feedback-page-title' => 'Tugon ng pook na napapagalaw',
	'mobile-frontend-feedback-page' => 'Project:Tugon sa Dugtong na Mobil',
	'mobile-frontend-leave-feedback-special-title' => 'Makipag-ugnayan sa amin',
	'mobile-frontend-feedback-no-subject' => '(walang paksa)',
	'mobile-frontend-feedback-no-subject-field' => 'Pakipasok ang isang paksa',
	'mobile-frontend-feedback-no-message' => 'Pakipasok dito ang isang mensahe',
	'mobile-frontend-feedback-edit-summary' => '$1 - kusang ipinaskil sa pamamagitan ng [[Special:MobileFeedback|kasangkapang pangtugon na naililipat-lipat]]',
	'mobile-frontend-leave-feedback-thanks' => 'Salamat sa tugon mo!',
	'mobile-frontend-leave-feedback-post-error' => 'Nagkaroon ng kamalian sa pagsasagawa ng mensahe mo. Pakisubukan uli mamaya.',
	'mobile-frontend-language' => 'Wika:',
	'mobile-frontend-language-header' => 'Ang artikulong ito ay makukuhang nasa $1 {{PLURAL:$1|wika|mga wika}}', # Fuzzy
	'mobile-frontend-language-footer' => 'Ang {{SITENAME}} ay makukuha sa iba pang mga wika.', # Fuzzy
	'mobile-frontend-language-site-choose' => 'Maghanap ng wika',
	'mobile-frontend-username' => 'Pangalan ng tagagamit:',
	'mobile-frontend-password' => 'Hudyat:',
	'mobile-frontend-login' => 'Lumagda',
	'mobile-frontend-placeholder' => 'Maghanap sa {{SITENAME}}',
	'mobile-frontend-search-help' => 'Makinilyahin sa itaas ang katagang hinahanap at dito lilitaw ang tumutugmang mga pamagat ng artikulo.', # Fuzzy
	'mobile-frontend-dismiss-notification' => 'iwaksi ang pagpapabatid na ito',
	'mobile-frontend-clear-search' => 'Hawiin',
	'mobile-frontend-privacy-link-text' => 'Pagsasarilinan',
	'mobile-frontend-about-link-text' => 'Patungkol',
	'mobile-frontend-footer-sitename' => '{{SITENAME}}',
	'mobile-frontend-footer-contact' => 'Kaugnayan',
	'mobile-frontend-search-noresults' => 'Walang mga pamagat ng artikulo na tumugma sa paghahanap mo. Baguhin ang hinahanap mo, pindutin ang pindutang panghanap ng tipahan upang maghanap sa loob ng mga artikulo.', # Fuzzy
	'mobile-frontend-main-menu-featured' => 'Itinatampok',
	'mobile-frontend-main-menu-nearby' => 'Kalapit',
	'mobile-frontend-main-menu-settings' => 'Mga katakdaan',
	'mobile-frontend-main-menu-settings-heading' => 'Mga katakdaan ng pook na naililipat-lipat',
	'mobile-frontend-settings-site-header' => 'Mga Wika sa {{SITENAME}}',
	'mobile-frontend-settings-site-description' => 'Makukuha ang {{SITENAME}} sa $1 {{PLURAL:$1|wika|mga wika}}. Ang lahat ng mga bersiyon ay nakalista sa ibaba',
	'mobile-frontend-main-menu-contact' => 'Kaugnayan',
	'mobile-frontend-page-menu-contents' => 'mga nilalaman',
	'mobile-frontend-page-menu-language-current' => '{{#language:{{CONTENTLANG}}}}',
	'mobile-frontend-page-menu-history' => 'Kasaysayan',
);

/** толышә зывон (толышә зывон)
 * @author Erdemaslancan
 * @author Гусейн
 */
$messages['tly'] = array(
	'mobile-frontend-search-submit' => 'Давард',
	'mobile-frontend-home-button' => 'Әсосә сәһифә',
	'mobile-frontend-random-button' => 'Рајрастә',
	'mobile-frontend-show-button' => 'Нишо дој',
	'mobile-frontend-wml-continue' => 'Давом...',
	'mobile-frontend-wml-back' => 'Бә думо...',
);

/** Tok Pisin (Tok Pisin)
 */
$messages['tpi'] = array(
	'mobile-frontend-search-submit' => 'Go',
	'mobile-frontend-home-button' => 'Fran pes',
	'mobile-frontend-random-button' => 'Wanpela pes',
	'mobile-frontend-show-button' => 'Soim',
	'mobile-frontend-featured-article' => 'Pes long dispela de',
);

/** Turkish (Türkçe)
 * @author Cekli829
 * @author Emperyan
 * @author Erdemaslancan
 * @author Hcagri
 * @author Incelemeelemani
 * @author Nazif İLBEK
 * @author Suelnur
 */
$messages['tr'] = array(
	'mobile-frontend-desc' => 'Mobil Arayüz',
	'mobile-frontend-search-submit' => 'Git',
	'mobile-frontend-home-button' => 'Ana',
	'mobile-frontend-settings-beta' => 'Deneme',
	'mobile-frontend-save-settings' => 'Ayarları kaydet',
	'mobile-frontend-random-button' => 'Rastgele',
	'mobile-frontend-back-to-top-of-section' => 'Bir Bölüm Geri Atla',
	'mobile-frontend-close-section' => 'Bu bölümü kapat',
	'mobile-frontend-show-button' => 'Göster',
	'mobile-frontend-hide-button' => 'Gizle',
	'mobile-frontend-empty-homepage-text' => 'Bu ana sayfa yapılandırılmalıdır. <a href="http://meta.wikimedia.org/wiki/Mobile_Projects/Mobile_Gateway#Mobile_homepage">Devamını buradan okuyun</a>.', # Fuzzy
	'mobile-frontend-regular-site' => 'Masaüstü görünümü',
	'mobile-frontend-wml-continue' => 'Devamı...',
	'mobile-frontend-wml-back' => 'Geri...',
	'mobile-frontend-view' => 'Mobil Görünüm',
	'mobile-frontend-view-desktop' => 'Masaüstü',
	'mobile-frontend-view-mobile' => 'Mobil',
	'mobile-frontend-images-status' => 'Resimler',
	'mobile-frontend-disable-images' => 'Mobil sitede resimleri devre dışı bırak',
	'mobile-frontend-enable-images' => 'Mobil sitede resimleri etkinleştir',
	'mobile-frontend-off' => 'KAPALI',
	'mobile-frontend-on' => 'AÇIK',
	'mobile-frontend-featured-article' => 'Haftanın Seçkin Maddesi',
	'mobile-frontend-leave-feedback-subject' => 'Konu:',
	'mobile-frontend-leave-feedback-message' => 'İleti:',
	'mobile-frontend-leave-feedback-title' => 'Mobil site geri bildirimi',
	'mobile-frontend-leave-feedback-technical-problem-section-header' => 'Teknik sorun',
	'mobile-frontend-leave-feedback-general-section-header' => 'Genel',
	'mobile-frontend-leave-feedback-article-feedback-section-header' => 'Madde geri bildirimi',
	'mobile-frontend-leave-feedback-technical-link-text' => 'Teknik sorun',
	'mobile-frontend-leave-feedback-general-link-text' => 'Genel geri bildirim',
	'mobile-frontend-leave-feedback-form-subject-placeholder' => 'İleti konusu',
	'mobile-frontend-leave-feedback-form-message-placeholder' => 'Eleştirilerinizi buraya yazınız',
	'mobile-frontend-leave-feedback-page-title' => 'Mobil site geri bildirimi',
	'mobile-frontend-leave-feedback-special-title' => 'İletişim',
	'mobile-frontend-feedback-no-subject' => '(konu yok)',
	'mobile-frontend-feedback-no-subject-field' => 'Lütfen bir konu giriniz.',
	'mobile-frontend-feedback-no-message' => 'Buraya bir ileti giriniz',
	'mobile-frontend-leave-feedback-thanks' => 'Geri bildiriminiz için teşekkürler!',
	'mobile-frontend-language' => 'Dil:',
	'mobile-frontend-username' => 'Kullanıcı adı:',
	'mobile-frontend-password' => 'Şifre:',
	'mobile-frontend-login' => 'Oturum aç',
	'mobile-frontend-placeholder' => 'Buraya arayacağınız kelimeleri yazınız...', # Fuzzy
	'mobile-frontend-dismiss-notification' => 'bildirimi kapat',
	'mobile-frontend-clear-search' => 'Temizle',
	'mobile-frontend-privacy-link-text' => 'Gizlilik',
	'mobile-frontend-about-link-text' => 'Hakkında',
	'mobile-frontend-footer-sitename' => '{{SITENAME}}',
	'mobile-frontend-footer-contact' => 'İletişim',
	'mobile-frontend-main-menu-settings' => 'Ayarlar',
);

/** Turoyo (Ṫuroyo)
 * @author Ariyo
 */
$messages['tru'] = array(
	'mobile-frontend-language' => 'Leşono', # Fuzzy
);

/** Tatar (Cyrillic script) (татарча)
 * @author Ильнар
 */
$messages['tt-cyrl'] = array(
	'mobile-frontend-desc' => 'Мобиль интерфейс',
	'mobile-frontend-search-submit' => 'Күчү',
	'mobile-frontend-home-button' => 'Өйгә',
	'mobile-frontend-random-button' => 'Очраклы',
	'mobile-frontend-back-to-top-of-section' => 'Бер бүлеккә артка',
	'mobile-frontend-show-button' => 'Күрсәтү',
	'mobile-frontend-hide-button' => 'Яшерү',
	'mobile-frontend-regular-site' => 'Сәхифәне гади {{SITENAME}} сәхифәсендә карау', # Fuzzy
	'mobile-frontend-view' => 'Мобиль юрама',
	'mobile-frontend-featured-article' => 'Көннең сайланган мәкаләсе',
);

/** Tati (Tati)
 * @author Erdemaslancan
 */
$messages['ttt'] = array(
	'mobile-frontend-search-submit' => 'Buşu',
	'mobile-frontend-home-button' => 'Keye',
);

/** Central Atlas Tamazight (ⵜⴰⵎⴰⵣⵉⵖⵜ)
 * @author Tifinaghes
 */
$messages['tzm'] = array(
	'mobile-frontend-home-button' => 'ⴰⵙⵏⵓⴱⴳ',
	'mobile-frontend-save-settings' => 'ⵣⵎⵎⴻⵎ ⵉⵎⵙⴳⵉⴷⴷⴰ',
	'mobile-frontend-ajax-random-yes' => 'ⵢⵢⵉⵀ',
	'mobile-frontend-view-mobile' => 'ⴰⵎⴰⴼⵓⵙ (Mobile)',
	'mobile-frontend-images-status' => 'ⵜⵉⵡⵍⴰⴼⵉⵏ',
	'mobile-frontend-missing-image' => 'ⵜⴰⵡⵍⴰⴼⵜ',
	'mobile-frontend-news-items' => 'ⴷⵉ ⵉⵏⵖⵎⵉⵙⵏ',
	'mobile-frontend-leave-feedback-message' => 'ⵜⴰⴱⵔⴰⵜ:',
	'mobile-frontend-language' => 'ⵜⵓⵜⵍⴰⵢⵜ:',
	'mobile-frontend-page-menu-history' => 'ⴰⵎⵣⵔⵓⵢ',
);

/** Uyghur (Arabic script) (ئۇيغۇرچە)
 * @author Sahran
 */
$messages['ug-arab'] = array(
	'mobile-frontend-search-submit' => 'يۆتكەل',
	'mobile-frontend-home-button' => 'باش بەت',
	'mobile-frontend-logged-out' => 'تىزىمغا كىرمىدى',
	'mobile-frontend-logged-in-homepage-notification' => '$1، خۇش كەپسىز!',
	'mobile-frontend-sign-up-heading' => 'خەتلىتىش',
	'mobile-frontend-random-button' => 'خالىغان',
	'mobile-frontend-ajax-random-yes' => 'ھەئە',
	'mobile-frontend-ajax-random-retry' => 'قايتا سىنا',
	'mobile-frontend-back-to-top-of-section' => 'كەينىگە بىر ئابزاس داجى',
	'mobile-frontend-show-button' => 'كۆرسەت',
	'mobile-frontend-hide-button' => 'يوشۇر',
	'mobile-frontend-regular-site' => 'بۇ بەتنى ئەسلى {{SITENAME}} دا كۆرسەت', # Fuzzy
	'mobile-frontend-view-desktop' => 'ئۈستەلئۈستى',
	'mobile-frontend-view-mobile' => 'يانفون',
	'mobile-frontend-images-status' => 'سۈرەتلەر',
	'mobile-frontend-missing-image' => 'سۈرەت',
	'mobile-frontend-featured-article' => 'بۈگۈنكى ئالاھىدە ماقالە',
	'mobile-frontend-leave-feedback-subject' => 'تېما:',
	'mobile-frontend-leave-feedback-message' => 'ئۇچۇر:',
	'mobile-frontend-leave-feedback-general-section-header' => 'ئادەتتىكى',
	'mobile-frontend-leave-feedback-article-feedback-section-header' => 'ماقالە قايتۇرما ئىنكاسى',
	'mobile-frontend-language' => 'تىل:',
	'mobile-frontend-username' => 'ئىشلەتكۈچى ئاتى:',
	'mobile-frontend-password' => 'ئىم:',
	'mobile-frontend-username-placeholder' => 'ئىشلەتكۈچى ئاتى',
	'mobile-frontend-password-placeholder' => 'ئىم',
	'mobile-frontend-account-create-submit' => 'خەتلىتىش',
	'mobile-frontend-password-confirm-placeholder' => 'ئىم جەزملە',
	'mobile-frontend-overlay-escape' => 'كەينىگە',
	'mobile-frontend-placeholder' => '{{SITENAME}} ئىزدە',
	'mobile-frontend-clear-search' => 'تازىلا',
	'mobile-frontend-privacy-link-text' => 'شەخسىي سىر',
	'mobile-frontend-about-link-text' => 'ھەققىدە',
	'mobile-frontend-footer-sitename' => '{{SITENAME}}',
	'mobile-frontend-footer-contact' => 'ئالاقەداش',
	'mobile-frontend-main-menu-featured' => 'ئالاھىدىلىك',
	'mobile-frontend-main-menu-nearby' => 'يېقىندىكى',
	'mobile-frontend-main-menu-login' => 'تىزىمغا كىرىڭ',
	'mobile-frontend-main-menu-logout' => 'تىزىمدىن چىق',
	'mobile-frontend-main-menu-watchlist' => 'كۆزەت تىزىملىكى',
	'mobile-frontend-main-menu-settings' => 'تەڭشەكلەر',
	'mobile-frontend-main-menu-contact' => 'ئالاقەداش',
	'mobile-frontend-main-menu-account-create' => 'ھېسابات قۇر',
	'mobile-frontend-page-menu-history' => 'تارىخ',
	'mobile-frontend-changeslist-ip' => 'ئاتسىز ئىشلەتكۈچى',
	'mobile-frontend-watchlist-filter-all' => 'ھەممىسى',
	'mobile-frontend-watchlist-filter-articles' => 'ماقالىلەر',
	'mobile-frontend-watchlist-filter-talk' => 'مۇنازىرە',
	'mobile-frontend-watchlist-filter-other' => 'باشقا',
	'mobile-frontend-diffview-editcount' => '$1 {{PLURAL:$1|قېتىم|قېتىم}} تەھرىرلەنگەن', # Fuzzy
	'mobile-frontend-diffview-anonymous' => 'ئاتسىز ئىشلەتكۈچى',
);

/** Ukrainian (українська)
 * @author A1
 * @author AS
 * @author Amire80
 * @author AtUkr
 * @author Base
 * @author Dim Grits
 * @author Gucci Mane Burrr
 * @author Kross
 * @author Microcell
 * @author Olvin
 * @author Sodmy
 * @author Steve.rusyn
 * @author WTM
 * @author Ата
 * @author Тест
 */
$messages['uk'] = array(
	'mobile-frontend-desc' => 'Мобільний інтерфейс',
	'mobile-frontend-search-submit' => 'Перейти',
	'mobile-frontend-home-button' => 'Домашня',
	'mobile-frontend-logged-out' => 'Ви не ввійшли до системи',
	'mobile-frontend-logged-in-homepage-notification' => 'Вітаємо, $1!',
	'mobile-frontend-logged-in-toast-notification' => 'Увійти в систему як $1',
	'mobile-frontend-sign-up-heading' => 'Реєстрація',
	'mobile-frontend-sign-in-heading' => 'Увійти',
	'mobile-frontend-sign-in-why' => 'Якщо у вас уже є акаунт у {{GRAMMAR:genitive|{{SITENAME}}}}, то можете представитись нижче.',
	'mobile-frontend-sign-in-error-heading' => 'Ой',
	'mobile-frontend-settings-description' => 'Налаштуйте мобільну версію якнайзручніше.',
	'mobile-frontend-settings-beta' => 'Бета-версія',
	'mobile-frontend-settings-alpha' => '[//en.wikipedia.org/wiki/Here_be_dragons Ви перейдете в небезпечний] режим',
	'mobile-frontend-settings-alpha-description' => 'Ввійдіть в небезпечну та невідому мобільну територію. Отримайте ще більше експерементальних можливостей, але у Вас з`явиться більша можливість знайти помилку.',
	'mobile-frontend-save-settings' => 'Зберегти налаштування',
	'mobile-frontend-random-button' => 'Випадкова',
	'mobile-frontend-ajax-random-heading' => 'Пошук знань…',
	'mobile-frontend-ajax-random-quote' => 'Інтелектуальне зростання має початися в момент народження і закінчитися тільки при смерті.',
	'mobile-frontend-ajax-random-question' => 'Читати цю сторінку?',
	'mobile-frontend-ajax-random-yes' => 'Так',
	'mobile-frontend-ajax-random-retry' => 'Спробуйте ще раз',
	'mobile-frontend-ajax-random-suggestions' => 'Інші пропозіції:',
	'mobile-frontend-back-to-top-of-section' => 'Повернутися на розділ назад',
	'mobile-frontend-close-section' => 'Закрити цей розділ',
	'mobile-frontend-show-button' => 'Показати',
	'mobile-frontend-hide-button' => 'Сховати',
	'mobile-frontend-empty-homepage-text' => 'Ця домашня сторінка потребує налаштування. [//meta.wikimedia.org/wiki/Mobile_Projects/Mobile_Gateway#Mobile_homepage Тут можна прочитати про це докладніше]',
	'mobile-frontend-regular-site' => 'Стандартний вигляд сторінки',
	'mobile-frontend-wml-continue' => 'Далі...',
	'mobile-frontend-wml-back' => 'Назад...',
	'mobile-frontend-view' => 'Мобільний вигляд',
	'mobile-frontend-view-desktop' => 'Стаціонарний',
	'mobile-frontend-view-mobile' => 'Мобільний',
	'mobile-frontend-opt-in-explain' => 'Приєднавшись до бета-тестування, Ви отримаєте доступ до деяких експериментальних функцій, але також збільшиться ризик зустріти помилку чи проблему',
	'mobile-frontend-images-status' => 'Зображення',
	'mobile-frontend-disable-images' => 'Вимкнути зображення на мобільному сайті',
	'mobile-frontend-enable-images' => 'Увімкнути зображення на мобільному сайті',
	'mobile-frontend-missing-image' => 'Зображення',
	'mobile-frontend-off' => 'ВИМК',
	'mobile-frontend-on' => 'ВМК',
	'mobile-frontend-footer-contributors-text' => 'Сторінку створено такими ж [$1 користувачами], як Ви',
	'mobile-frontend-featured-article' => 'Вибрана стаття',
	'mobile-frontend-news-items' => 'У новинах',
	'mobile-frontend-leave-feedback-notice' => 'Ваш відгук допоможе нам покращити користування мобільним сайтом. Він буде розміщений публічно (разом з іменем користувача, версією браузера та операційної системи) на сторінці &quot;$1&quot;. Будь ласка, оберіть інформативний рядок, наприклад, "Проблеми форматування широких таблиць". Висловлюйтесь у відповідності до наших умов використання.',
	'mobile-frontend-leave-feedback-warning' => 'Якщо ви згодні з тим, щоб Ваша інформація була оприлюднена, будь ласка не інформуйте персональну інформацію в коментарях.',
	'mobile-frontend-leave-feedback-subject' => 'Тема:',
	'mobile-frontend-leave-feedback-message' => 'Повідомлення:',
	'mobile-frontend-leave-feedback-submit' => 'Залишити відгук',
	'mobile-frontend-leave-feedback-link-text' => 'Відгуки про мобільний інтерфейс',
	'mobile-frontend-leave-feedback' => 'Залишити відгук',
	'mobile-frontend-leave-feedback-title' => 'Залиште для нас власний відгук про мобільний інтерфейс',
	'mobile-frontend-leave-feedback-technical-problem-section-header' => 'Технічна проблема',
	'mobile-frontend-leave-feedback-general-section-header' => 'Загальні',
	'mobile-frontend-leave-feedback-article-feedback-section-header' => "Стаття зворотнього зв'язку",
	'mobile-frontend-leave-feedback-email-body' => 'Будь ласка, опишіть проблему яку Ви відчуваєте на сайті «{{SITENAME}}» над цим рядком. Зауважте, будь ласка, що ми не можемо відповісти на кожне повідомлення, що ми отримуємо.',
	'mobile-frontend-leave-feedback-technical-link-text' => 'Технічна проблема',
	'mobile-frontend-leave-feedback-general-link-text' => "Загальний зворотній зв'язок",
	'mobile-frontend-leave-feedback-article-personal-link-text' => 'Стосується мене, або людини чи компанії, яких я представляю',
	'mobile-frontend-leave-feedback-article-factual-link-text' => 'Стосовно фактичної помилки',
	'mobile-frontend-leave-feedback-article-other-link-text' => 'Стосовно іншої проблеми',
	'mobile-frontend-leave-feedback-form-subject-placeholder' => 'Тема повідомлення',
	'mobile-frontend-leave-feedback-form-message-placeholder' => 'Введіть тут свій коментар',
	'mobile-frontend-leave-feedback-page-title' => 'Залиште для нас власний відгук про мобільний інтерфейс',
	'mobile-frontend-feedback-page' => 'Project:Mobile Extension Feedback',
	'mobile-frontend-leave-feedback-special-title' => "Зв'язатися з нами",
	'mobile-frontend-feedback-no-subject' => '(немає теми)',
	'mobile-frontend-feedback-no-subject-field' => 'Будь ласка, введіть тему',
	'mobile-frontend-feedback-no-message' => 'Будь ласка, введіть повідомлення тут',
	'mobile-frontend-feedback-edit-summary' => '$1 - автоматично розміщенно через [[Special:MobileFeedback|mobile feedback tool]]',
	'mobile-frontend-leave-feedback-thanks' => 'Дякуємо, за ваш відгук!',
	'mobile-frontend-leave-feedback-post-error' => 'При обробці Вашого повідомлення виникла помилка. Будь ласка, повторіть спробу пізніше.',
	'mobile-frontend-language' => 'Мова:',
	'mobile-frontend-language-article-heading' => 'Читати іншою мовою',
	'mobile-frontend-language-header' => 'Сторінка доступна $1 {{PLURAL:$1|мовою|мовами}}',
	'mobile-frontend-language-variant-header' => 'Оберіть варіант мови {{#language:{{CONTENTLANG}}}}',
	'mobile-frontend-language-footer' => 'Примітка: у цієї сторінки немає перекладу Вашою мовою. Ви можете вибрати іншу мову {{SITENAME}} натиснувши тут.',
	'mobile-frontend-language-site-choose' => 'Пошук мови',
	'mobile-frontend-username' => "Ім'я користувача:",
	'mobile-frontend-password' => 'Пароль:',
	'mobile-frontend-username-placeholder' => "Ім'я користувача",
	'mobile-frontend-password-placeholder' => 'Пароль',
	'mobile-frontend-login' => 'Увійти',
	'mobile-frontend-last-modified-date' => 'Останні зміни: $1, $2',
	'mobile-frontend-last-modified-seconds' => 'Остання зміна була $1 {{PLURAL:$1|секунду|секунди|секунд}} тому',
	'mobile-frontend-last-modified-minutes' => 'Остання зміна була $1 {{PLURAL:$1|хвилину|хвилини|хвилин}} тому',
	'mobile-frontend-last-modified-hours' => 'Остання зміна була $1 {{PLURAL:$1|годину|години|годин}} тому',
	'mobile-frontend-last-modified-days' => 'Остання зміна була $1 {{PLURAL:$1|день|дні|днів}} тому',
	'mobile-frontend-last-modified-months' => 'Остання зміна була $1 {{PLURAL:$1|місяць|місяці|місяців}} тому',
	'mobile-frontend-last-modified-years' => 'Остання зміна була $1 {{PLURAL:$1|рік|роки|років}} тому',
	'mobile-frontend-account-create-submit' => 'Зареєструватися',
	'mobile-frontend-password-confirm-placeholder' => 'Підтвердження пароля:',
	'mobile-frontend-account-create-email-placeholder' => 'E-mail адреса (за бажанням)',
	'mobile-frontend-account-create-captcha-placeholder' => 'Введіть текст безпеки',
	'mobile-frontend-overlay-escape' => 'Повернутися',
	'mobile-frontend-placeholder' => 'Шукати у {{GRAMMAR:genitive|{{SITENAME}}}}',
	'mobile-frontend-placeholder-beta' => 'Пошук у {{GRAMMAR:genitive|{{SITENAME}}}} (бета)',
	'mobile-frontend-placeholder-alpha' => 'Пошук {{SITENAME}} (Бета режим)',
	'mobile-frontend-search-help' => 'Введіть вище термін, що шукаєте, і тут буде показано заголовки сторінок, що співпадають.',
	'mobile-frontend-dismiss-notification' => 'приховати це сповіщення',
	'mobile-frontend-clear-search' => 'Очистити',
	'mobile-frontend-privacy-link-text' => 'Конфіденційність',
	'mobile-frontend-about-link-text' => 'Про',
	'mobile-frontend-footer-sitename' => '{{SITENAME}}',
	'mobile-frontend-footer-license-text' => 'Вміст доступний під ліцензією [//en.m.wikipedia.org/wiki/Wikipedia:Text_of_Creative_Commons_Attribution-ShareAlike_3.0_Unported_License?useformat=mobile?uselang=uk CC BY-SA 3.0]',
	'mobile-frontend-terms-use-text' => '[//wikimediafoundation.org/wiki/Terms_of_use?useformat=mobile&uselang=uk Умови використання]',
	'mobile-frontend-footer-contact' => "Зв'язок",
	'mobile-frontend-search-noresults' => 'Немає заголовків сторінок, які відповідають критеріям пошуку. Змініть параметри пошуку, або натисніть кнопку пошуку, щоб знайти всередині сторінок.',
	'mobile-frontend-main-menu-button-tooltip' => 'Відкрити головне меню',
	'mobile-frontend-main-menu-page-title' => 'Навігація по сайту',
	'mobile-frontend-main-menu-featured' => 'Вибране',
	'mobile-frontend-main-menu-nearby' => 'Поблизу',
	'mobile-frontend-main-menu-login' => 'Увійти',
	'mobile-frontend-main-menu-logout' => 'Вийти',
	'mobile-frontend-main-menu-watchlist' => 'Список спостереження',
	'mobile-frontend-main-menu-settings' => 'Налаштування',
	'mobile-frontend-main-menu-upload' => 'Завантаження',
	'mobile-frontend-main-menu-settings-heading' => 'Налаштування мобільної версії сайту',
	'mobile-frontend-settings-site-header' => 'Мови проекту {{SITENAME}}',
	'mobile-frontend-settings-site-description' => '{{SITENAME}} доступний на {{PLURAL:$1|мові|мовах}}. Всі доступні версії перелічені нижче',
	'mobile-frontend-main-menu-contact' => 'Контакт',
	'mobile-frontend-main-menu-account-create' => 'Створити обліковий запис',
	'mobile-frontend-page-menu-contents' => 'зміст',
	'mobile-frontend-page-menu-history' => 'Історія',
	'mobile-frontend-meta-data-issues-header' => 'Запитання',
	'mobile-frontend-meta-data-issues' => 'Ця сторінка має деякі запитання',
	'mobile-frontend-ajax-page-loading' => 'Завантаження $1',
	'mobile-frontend-page-saving' => 'Збереження $1',
	'mobile-frontend-ajax-page-error' => 'Ой! Щось пішло не так. Будь ласка оновіть вікно Вашого браузера.',
	'mobile-frontend-nearby-title' => 'Поблизу',
	'mobile-frontend-nearby-loading' => 'Завантаження інформації про те, що знаходиться поблизу Вас',
	'mobile-frontend-nearby-requirements' => 'Ця сторінка вимагає увімкненого JavaScript і браузера, що отримує інформацію про місцеположення.',
	'mobile-frontend-nearby-distance-report' => '$1 км від Вашого поточного місця розташування',
	'mobile-frontend-nearby-lookup-error' => 'Не вдалося знайти Вас. Пробуємо знову...',
	'mobile-frontend-nearby-noresults' => 'Ви знаходитесь в центрі невідомості і нам не вдалося знайти ніяких тем. Чому б не написати щось?',
	'mobile-frontend-nearby-refresh' => 'Ми визначити Ваше місцеположення точніше. Натисніть тут, щоб оновити список найближчих сторінок',
	'mobile-frontend-nearby-error' => "Сталася неочікувана помилка при спробі знайти сторінки, пов'язані з Вашим місцеперебуванням",
	'mobile-frontend-donate-image-login' => 'Ви повинні увійти в систему, щоб побачити свої завантаження.',
	'mobile-frontend-photo-upload-generic' => 'Пожертвувати зображення',
	'mobile-frontend-donate-image-title' => 'Пожертвувати зображення',
	'mobile-frontend-donate-image-summary' => 'Фотографії роблять сторінки проекту {{SITENAME}} живими.
Багато сторінок не мають фотографій через гостру недостачу зображень під вільними ліцензіями.
Допоможіть оживити ці сторінки, завантаживши свої зображення, якими Ви хочете поділитись і які могтимуть використовуватись усією спільнотою дописувачів проекту {{SITENAME}}.',
	'mobile-frontend-donate-image-heading' => 'Ваш недавній внесок',
	'mobile-frontend-donate-image-page-title' => 'Завантажити',
	'mobile-frontend-donate-image-anon' => 'Для перегляду сторінки завантажень треба мати [[Special:UserLogin|обліковий запис користувача]]',
	'mobile-frontend-listed-image-no-description' => 'Немає опису',
	'mobile-frontend-donate-photo-upload-success' => 'Успішно! Тепер Ваше зображення можна використовувати на сайті {{SITENAME}}!',
	'mobile-frontend-donate-photo-first-upload-success' => 'Успішно! Дякуємо за Ваш перший внесок!',
	'mobile-frontend-watchlist-add' => 'Додано $1 у ваш список спостереження',
	'mobile-frontend-watchlist-removed' => 'Вилучено $1 з Вашого списку спостереження',
	'mobile-frontend-watchlist-view' => 'Переглянути список спостереження',
	'mobile-frontend-watchlist-more' => 'більше',
	'mobile-frontend-watchlist-cta' => 'Будь ласка, для перегляду цієї сторінки увійдіть або зареєструйтеся.',
	'mobile-frontend-watchlist-cta-button-login' => 'Увійти',
	'mobile-frontend-watchlist-cta-button-signup' => 'Зареєструватися',
	'mobile-frontend-watch-login' => 'Ви повинні увійти в систему для перегляду сторінок.',
	'mobile-frontend-watchlist-a-z' => 'Усі',
	'mobile-frontend-watchlist-feed' => 'Змінені',
	'mobile-frontend-watchlist-a-z-empty' => 'Наразі Ви не спостерігаєте за жодною сторінкою',
	'mobile-frontend-watchlist-a-z-empty-howto-alt' => 'Клацніть зірочку у верхній частині сторінки',
	'mobile-frontend-watchlist-a-z-empty-howto' => 'Спостерігайте за цікавою Вам сторінкою, клацнувши на зірочку у верхній частині екрану. Це додасть сторінку в закладки і дозволить бачити, коли її будуть змінювати.',
	'mobile-frontend-watchlist-feed-empty' => 'Немає сторінок з недавніми змінами',
	'mobile-frontend-watchlist-back-home' => 'Додому',
	'mobile-frontend-changeslist-ip' => 'Анонімний користувач',
	'mobile-frontend-changeslist-nocomment' => 'нема опису редагування',
	'mobile-frontend-watchlist-filter-all' => 'Усі',
	'mobile-frontend-watchlist-filter-articles' => 'Статті',
	'mobile-frontend-watchlist-filter-talk' => 'Обговорення',
	'mobile-frontend-watchlist-filter-other' => 'Інші',
	'mobile-frontend-watchlist-modified' => 'Змінена $1',
	'mobile-frontend-diffview-404-title' => 'Некоректна версія',
	'mobile-frontend-diffview-404-desc' => 'Не існує версії із заданим вами ідентифікатором',
	'mobile-frontend-diffview-title' => 'Змінити',
	'mobile-frontend-diffview-editcount' => '$1 {{PLURAL:$1|редагування|редагування|редагувань}}',
	'mobile-frontend-diffview-anonymous' => 'Анонімний користувач',
	'mobile-frontend-diffview-bytesadded' => '$1 {{PLURAL:$1|байт|байти|байтів}} додано',
	'mobile-frontend-diffview-bytesremoved' => '$1 {{PLURAL:$1|байт|байти|байтів}} вилучено',
	'mobile-frontend-diffview-explained' => 'Наступні рядки були додані (+) і видалені (-):',
	'mobile-frontend-table' => 'Таблиця $1',
	'mobile-frontend-saving-exit-page' => 'Ваш внесок збережений. Якщо Ви залишите сторінку, Ваш внесок буде втрачено. Ви впевнені что бажаєте вийти?',
	'mobile-frontend-photo-upload' => 'Додати фото до цієї статті',
	'mobile-frontend-photo-article-edit-comment' => 'Додані фотографії для використання на сторінці.',
	'mobile-frontend-photo-article-donate-comment' => 'Пожертвував зображення з мобільного пристрою',
	'mobile-frontend-photo-upload-comment' => 'Додати фото на сторінку',
	'mobile-frontend-photo-caption-placeholder' => "Додати опис (обов'язково)",
	'mobile-frontend-image-loading' => 'Завантаження зображень',
	'mobile-frontend-image-uploading-wait' => 'Завантаження зображення, зачекайте, будь ласка.',
	'mobile-frontend-image-uploading-long' => 'Зображення досі завантажується! Дякуємо за ваше терпіння.',
	'mobile-frontend-image-uploading-cancel' => '<a href="#">Скасувати</a>, якщо це займає надто багато часу.',
	'mobile-frontend-photo-upload-error' => 'Сталася помилка, спробуйте ще раз.',
	'mobile-frontend-photo-upload-success-article' => 'Завантаження вдалося! Тепер ваше зображення розміщене на цій сторінці.',
	'mobile-frontend-photo-license' => 'Натиснувши кнопку "Надіслати", ви погоджуєтеся з нашими [//wikimediafoundation.org/wiki/Terms_of_use умовами використання] і згодні надати ваше фото під [//creativecommons.org/licenses/by-sa/3.0/   ліцензією Creative Commons Attribution-ShareAlike 3.0].',
	'mobile-frontend-photo-submit' => 'Надіслати',
	'mobile-frontend-photo-cancel' => 'Скасувати',
	'mobile-frontend-photo-upload-user-count' => '{{PLURAL:$1|1 завантаження|$1 завантажень}}', # Fuzzy
	'mobile-frontend-photo-upload-user-count-over-limit' => '500+ завантажень',
	'tag-mobile_edit' => 'Редагування з мобільного пристрою',
	'tag-mobile_edit-description' => 'Редагування, зроблені з мобільної версії сайту',
	'mobile-frontend-drawer-cancel' => 'Скасувати',
);

/** Urdu (اردو)
 * @author පසිඳු කාවින්ද
 */
$messages['ur'] = array(
	'mobile-frontend-desc' => 'موبائل پیشدید',
	'mobile-frontend-search-submit' => 'چلو',
	'mobile-frontend-home-button' => 'سرورق',
	'mobile-frontend-logged-out' => 'لاگ ان نہیں',
	'mobile-frontend-save-settings' => 'ترتیبات کو محفوظ کریں',
	'mobile-frontend-random-button' => 'بےترتیب',
	'mobile-frontend-back-to-top-of-section' => 'ایک قطعہ پیچھے جاؤ',
	'mobile-frontend-close-section' => 'اس سیکشن میں بند',
	'mobile-frontend-show-button' => 'دکھاؤ',
	'mobile-frontend-hide-button' => 'چُھپاؤ',
	'mobile-frontend-regular-site' => 'یہ صفحہ اصل ویکیپیڈیا پر ملاحظہ کیجئے', # Fuzzy
	'mobile-frontend-view' => 'موبائل دیکھیں',
	'mobile-frontend-view-desktop' => 'ڈیسک ٹاپ',
	'mobile-frontend-view-mobile' => 'موبائل',
	'mobile-frontend-images-status' => 'تصویر',
	'mobile-frontend-featured-article' => 'آج کا منتخب مقالہ',
	'mobile-frontend-leave-feedback-subject' => 'موضوع:',
	'mobile-frontend-leave-feedback-message' => 'پیغام:',
	'mobile-frontend-leave-feedback-general-section-header' => 'جنرل',
	'mobile-frontend-leave-feedback-special-title' => 'ہم سے رابطہ کریں',
	'mobile-frontend-language' => 'زبان:',
	'mobile-frontend-username' => 'صارف کا نام:',
	'mobile-frontend-password' => 'پاس ورڈ:',
	'mobile-frontend-login' => 'میں لاگ ان کریں',
	'mobile-frontend-clear-search' => 'واضح',
	'mobile-frontend-privacy-link-text' => 'پرائیویسی',
	'mobile-frontend-about-link-text' => 'کے بارے میں',
	'mobile-frontend-footer-sitename' => '{{SITENAME}}',
	'mobile-frontend-footer-contact' => 'سے رابطہ کریں',
	'mobile-frontend-main-menu-featured' => 'نمایاں',
	'mobile-frontend-main-menu-nearby' => 'قریبی',
	'mobile-frontend-main-menu-settings' => 'ترتیبات',
	'mobile-frontend-main-menu-contact' => 'سے رابطہ کریں',
	'mobile-frontend-page-menu-history' => 'تاریخچہ',
);

/** Uzbek (oʻzbekcha)
 * @author CoderSI
 */
$messages['uz'] = array(
	'mobile-frontend-view' => 'Mobil versiya',
);

/** vèneto (vèneto)
 * @author Frigotoni
 * @author GatoSelvadego
 */
$messages['vec'] = array(
	'mobile-frontend-desc' => 'Interfacia mobiłe',
	'mobile-frontend-search-submit' => 'Và',
	'mobile-frontend-home-button' => 'Inissio',
	'mobile-frontend-logged-out' => 'Aceso mia efetuà',
	'mobile-frontend-logged-in-homepage-notification' => 'Benvegnù, $1!',
	'mobile-frontend-logged-in-toast-notification' => 'Aceso efetuà cofà $1.',
	'mobile-frontend-sign-up-heading' => 'Notate',
	'mobile-frontend-sign-in-heading' => 'Iscrìvate',
	'mobile-frontend-sign-in-why' => 'Se te ghe un account {{SITENAME}}, te poi acedare dal form soto.',
	'mobile-frontend-sign-in-error-heading' => 'Oops!',
	'mobile-frontend-settings-description' => "Personałixa ła to esperiensa so'l dispoxitivo mobiłe có łe inpostasion spesifeghe par sta version.",
	'mobile-frontend-settings-beta' => 'Beta',
	'mobile-frontend-settings-alpha' => 'Modałità [//en.wikipedia.org/wiki/Here_be_dragons Here be dragons]',
	'mobile-frontend-settings-alpha-description' => 'Ocio te si drio entrar in teritori pericołoxi e nó esplorai. Otien carateristeghe ncora pì sperimentałi ma có pì pericołi e difeti.',
	'mobile-frontend-save-settings' => 'Salva inpostasion',
	'mobile-frontend-random-button' => 'A caso',
	'mobile-frontend-ajax-random-heading' => 'Individuasion de łe conosense...',
	'mobile-frontend-ajax-random-quote' => 'Ła cresita intełetuałe ła gavaria da inisiar da ła nasita e finir soło che a ła morte',
	'mobile-frontend-ajax-random-question' => 'Vuto lexare sta pàjina?',
	'mobile-frontend-ajax-random-yes' => 'Sì',
	'mobile-frontend-ajax-random-retry' => 'Ripróva',
	'mobile-frontend-ajax-random-suggestions' => 'Altri sugerimenti:',
	'mobile-frontend-back-to-top-of-section' => 'Va a inisio sesion',
	'mobile-frontend-close-section' => 'Sara sta sesion',
	'mobile-frontend-show-button' => 'Mostra',
	'mobile-frontend-hide-button' => 'Scondi',
	'mobile-frontend-empty-homepage-text' => "Sta pàjina prinsipałe ła ga da esar configurà. [//meta.wikimedia.org/wiki/Mobile_Projects/Mobile_Gateway#Mobile_homepage Istrusion so come abiłitar sto sito pa' dispoxitivi mobiłi]",
	'mobile-frontend-regular-site' => 'Vista desktop',
	'mobile-frontend-wml-continue' => 'Continua ...',
	'mobile-frontend-wml-back' => 'Indrio...',
	'mobile-frontend-view' => 'Version mobiłe',
	'mobile-frontend-view-desktop' => 'Desktop',
	'mobile-frontend-view-mobile' => 'Celular',
	'mobile-frontend-opt-in-explain' => "Partesipando a ła version de proa te gavarè ła posibiłità de doparar funsionałità sperimentałi, ma có 'l ris-cio de incontrar erori e problemi.",
	'mobile-frontend-images-status' => 'Imaxene',
	'mobile-frontend-disable-images' => "Dixabiłita łe imaxene so'l sito par dispoxitivi mobiłi",
	'mobile-frontend-enable-images' => "Abiłita łe imaxene so'l sito par dispoxitivi mobiłi",
	'mobile-frontend-missing-image' => 'Imaxene',
	'mobile-frontend-off' => 'OFF',
	'mobile-frontend-on' => 'ON',
	'mobile-frontend-footer-contributors-text' => 'Pàjina scrita da [$1 contributori] cofà ti',
	'mobile-frontend-featured-article' => 'Vetrina',
	'mobile-frontend-news-items' => 'Novità',
	'mobile-frontend-leave-feedback-notice' => 'I to comenti i ne juta a mejorar ła to esperiensa inte\'l sito par dispoxitivi mobiłi. Sarà publicà (insieme al to nome utente, version del browser e sistema operatìo) a ła pàjina "$1". Par piasere, siełi un ogeto descritivo (a exenpio, "Problemi de formatasion có tabełe larghe"). El to come el xe sogeto a łe condision d\'uxo.',
	'mobile-frontend-leave-feedback-warning' => "Se no te si d'acordo a rendar publisi i to dati, par piasere nó inserir informasion personałi inte i to comenti.",
	'mobile-frontend-leave-feedback-subject' => 'Ogeto:',
	'mobile-frontend-leave-feedback-message' => 'Mesajo:',
	'mobile-frontend-leave-feedback-submit' => 'Invia feedback',
	'mobile-frontend-leave-feedback-link-text' => "Comenti so'l estension interfacia mobiłe",
	'mobile-frontend-leave-feedback' => "Comenti so'l sito par dispoxitivi mobiłi",
	'mobile-frontend-leave-feedback-title' => "Comenti so'l sito par dispoxitivi mobiłi",
	'mobile-frontend-leave-feedback-technical-problem-section-header' => 'Problema tenico',
	'mobile-frontend-leave-feedback-general-section-header' => 'Xenerałe',
	'mobile-frontend-leave-feedback-article-feedback-section-header' => 'Comenta na voxe',
	'mobile-frontend-leave-feedback-email-body' => 'Descrivi el problema che te ghe riscontrà có {{SITENAME}} sora de sta linea. Se scuxemo in antisipo, ma purtropo nó riusemo a rispondare a ogni mesajo che risevemo.',
	'mobile-frontend-leave-feedback-technical-link-text' => 'Problema tenico',
	'mobile-frontend-leave-feedback-general-link-text' => 'Comento xeneral',
	'mobile-frontend-leave-feedback-article-personal-link-text' => 'Che rivarda mi, na persona o na dita che raprexento',
	'mobile-frontend-leave-feedback-article-factual-link-text' => 'Che rivarda un eror fatuałe',
	'mobile-frontend-leave-feedback-article-other-link-text' => "Che rivarda 'n altro problema",
	'mobile-frontend-leave-feedback-form-subject-placeholder' => 'Ogeto del mesajo',
	'mobile-frontend-leave-feedback-form-message-placeholder' => 'Scrivi cuà el to comento',
	'mobile-frontend-leave-feedback-page-title' => "Comenti so'l sito par dispoxitivi mobiłi",
	'mobile-frontend-leave-feedback-special-title' => 'Contàtane',
	'mobile-frontend-feedback-no-subject' => '(nisun ogeto)',
	'mobile-frontend-feedback-no-subject-field' => 'Se prega de inserir un ogeto',
	'mobile-frontend-feedback-no-message' => 'Se prega de inserir un mesajo cuà',
	'mobile-frontend-feedback-edit-summary' => '$1 - invià automategamente doparando el [[Special:MobileFeedback|strumento mobile feedback]]',
	'mobile-frontend-leave-feedback-thanks' => 'Grasie par averne łasà un feedback!',
	'mobile-frontend-leave-feedback-post-error' => "S'à verifegà un eror durante l'elaborasion del mesajo. Se prega de riprovar pì tardi.",
	'mobile-frontend-language' => 'Léngua:',
	'mobile-frontend-language-article-heading' => "Lexe inte n'altra léngua",
	'mobile-frontend-language-header' => 'Sta pàjina ła xe disponibiłe in $1 {{PLURAL:$1|léngua|léngue}}',
	'mobile-frontend-language-variant-header' => 'Siełi na variante {{#language:{{CONTENTLANG}}}}',
	'mobile-frontend-language-footer' => 'Nota: sta pàjina ła podaria nó esar scrita inte ła to léngua preferia. Se pol vedare cuałi léngue łe xe suportae da {{SITENAME}} strucando cuà.',
	'mobile-frontend-language-site-choose' => 'Riserca léngua',
	'mobile-frontend-username' => 'Nome utente:',
	'mobile-frontend-password' => 'Password:',
	'mobile-frontend-username-placeholder' => 'Nome utente',
	'mobile-frontend-password-placeholder' => 'Password',
	'mobile-frontend-login' => 'Iscrìvate',
	'mobile-frontend-last-modified-date' => 'Ultimo canbiamento el $1 a łe $2',
	'mobile-frontend-last-modified-seconds' => 'Ultimo canbiamento {{PLURAL:$1|$1 secondo|$1 secondi}} fa',
	'mobile-frontend-last-modified-minutes' => 'Ultimo canbiamento {{PLURAL:$1|$1 minuto|$1 minuti}} fa',
	'mobile-frontend-last-modified-hours' => 'Ultimo canbiamento {{PLURAL:$1|$1 ora|$1 ore}} fa',
	'mobile-frontend-last-modified-days' => 'Ultimo canbiamento {{PLURAL:$1|$1 xorno|$1 xorni}} fa',
	'mobile-frontend-last-modified-months' => 'Ultimo canbiamento {{PLURAL:$1|$1 mexe|$1 mexi}} fa',
	'mobile-frontend-last-modified-years' => 'Ultimo canbiamento {{PLURAL:$1|$1 ano|$1 ani}} fa',
	'mobile-frontend-account-create-submit' => 'Notate',
	'mobile-frontend-password-confirm-placeholder' => 'Conferma password',
	'mobile-frontend-account-create-email-placeholder' => 'Indiriso e-mail (opsionałe)',
	'mobile-frontend-account-create-captcha-placeholder' => 'Inserir el testo de sicuresa',
	'mobile-frontend-overlay-escape' => 'Torna indrìo',
	'mobile-frontend-placeholder' => 'Serca drento de {{SITENAME}}',
	'mobile-frontend-placeholder-beta' => 'Riserca so {{SITENAME}} (Beta)',
	'mobile-frontend-placeholder-alpha' => 'Serca so {{SITENAME}} (Dragon Mode)',
	'mobile-frontend-search-help' => 'Digita łe parołe da sercar e i titołi de łe pàjina trovae i aparirà cuà.',
	'mobile-frontend-dismiss-notification' => 'ignora sta notifega',
	'mobile-frontend-clear-search' => 'Sneta',
	'mobile-frontend-privacy-link-text' => 'Privacy',
	'mobile-frontend-about-link-text' => 'Informasion',
	'mobile-frontend-footer-sitename' => '{{SITENAME}}',
	'mobile-frontend-footer-license-text' => 'Contegnui disponibiłi secondo ła licensa [//en.m.wikipedia.org/wiki/Wikipedia:Text_of_Creative_Commons_Attribution-ShareAlike_3.0_Unported_License?useformat=mobile CC BY-SA 3.0]',
	'mobile-frontend-terms-use-text' => "[//wikimediafoundation.org/wiki/Terms_of_use?useformat=mobile Condision d'uxo]",
	'mobile-frontend-footer-contact' => 'Contati',
	'mobile-frontend-search-noresults' => 'Nisuna pajina ła ga un titoło che \'l corisponde a ła to riserca. Canbia ła to riserca, opur struca el boton de ła tastiera "Serca" par ła riserca inte\'l testo de łe pàjine.',
	'mobile-frontend-main-menu-button-tooltip' => 'Verxi el menu prinsipałe',
	'mobile-frontend-main-menu-page-title' => "Navegasion so'l sito",
	'mobile-frontend-main-menu-featured' => 'In primo pian',
	'mobile-frontend-main-menu-nearby' => 'Arente cuà',
	'mobile-frontend-main-menu-login' => 'Entra',
	'mobile-frontend-main-menu-logout' => 'Và fora',
	'mobile-frontend-main-menu-watchlist' => "Pàjine tegnùe d'ocio",
	'mobile-frontend-main-menu-settings' => 'Inpostasion',
	'mobile-frontend-main-menu-upload' => 'Carga',
	'mobile-frontend-main-menu-settings-heading' => 'Inpostasion del sito par celulari',
	'mobile-frontend-settings-site-header' => 'Léngue {{SITENAME}}',
	'mobile-frontend-settings-site-description' => '{{SITENAME}} xe disponibiłe in $1 {{PLURAL:$1|léngua|léngue}}. Tute łe version disponibiłi łe xe elencae de seguito',
	'mobile-frontend-main-menu-contact' => 'Contato',
	'mobile-frontend-main-menu-account-create' => 'Crea un utente novo',
	'mobile-frontend-page-menu-contents' => 'contegnùi',
	'mobile-frontend-page-menu-history' => 'Istòria',
	'mobile-frontend-meta-data-issues-header' => 'Anomałie',
	'mobile-frontend-meta-data-issues' => 'Sta pàjina ła ga calche problema',
	'mobile-frontend-ajax-page-loading' => 'So drio cargar $1',
	'mobile-frontend-page-saving' => 'So drio salvar $1',
	'mobile-frontend-ajax-page-error' => 'Oops! Calcosa xe ndà storto. Proa a axornar ła fenestra del browser.',
	'mobile-frontend-nearby-title' => 'Arente cuà',
	'mobile-frontend-nearby-loading' => 'Carga argomenti visini a ła to poxision atuałe',
	'mobile-frontend-nearby-requirements' => 'Sta pàjina ła dimanda JavaScript e un browser có ła locałixasion ativà.',
	'mobile-frontend-nearby-distance-report' => '$1 km da ła to poxision de deso',
	'mobile-frontend-nearby-lookup-error' => 'Inposibiłe catarte. Próa da novo...',
	'mobile-frontend-nearby-noresults' => 'Te si in mexo al gnente e nó semo boni catar nisun articoło. Parché no te ghi ne scrivi uno?',
	'mobile-frontend-nearby-refresh' => 'Te ghemo catà na poxision pì precixa. Struca cuà par ricrear ła lista de łe pàjine visine',
	'mobile-frontend-nearby-error' => 'Ghe xe sta un eror nó spetà mentre se jera drio sercar łe pàjine visine',
	'mobile-frontend-donate-image-login' => 'Entra par varda i file che te ghe cargà',
	'mobile-frontend-photo-upload-generic' => "Dona n'imaxene",
	'mobile-frontend-donate-image-title' => "Dona n'imaxene",
	'mobile-frontend-donate-image-summary' => "Łe someje łe porta łe pàjine so {{SITENAME}} a ła vita.
Ghe xe tante pàjine che nó łe ga gnanca na someja a cauxa de na grave mancansa de someje có licensa libara.
Jutane a portar ste pàjine a ła vita donandoghe łe to someje, podaria anca esar utiłe pa' ła pì granda comunità de editing de {{SITENAME}}.",
	'mobile-frontend-donate-image-heading' => 'I to contributi resenti',
	'mobile-frontend-donate-image-page-title' => 'Carga',
	'mobile-frontend-donate-image-anon' => 'Un [[Special:UserLogin|account utente]] el xe dimandà par vardar ła pàjina de cargamento',
	'mobile-frontend-listed-image-no-description' => 'Nisuna descrision',
	'mobile-frontend-watchlist-add' => "Xonta $1 a łe to tegnùe d'ocio",
	'mobile-frontend-watchlist-removed' => "Cava $1 da łe to tegnùe d'ocio",
	'mobile-frontend-watchlist-view' => "Varda łe to tegnùe d'ocio",
	'mobile-frontend-watchlist-more' => 'altro',
	'mobile-frontend-watchlist-cta' => "Efetua 'l aceso o notate par xontare sta pàjina a łe tegnùe d'ocio.",
	'mobile-frontend-watchlist-cta-button-login' => 'Va drento',
	'mobile-frontend-watchlist-cta-button-signup' => 'Notate',
	'mobile-frontend-watchlist-a-z' => 'Tute',
	'mobile-frontend-watchlist-feed' => 'Canbiae',
	'mobile-frontend-watchlist-a-z-empty' => "No te si drio tegner d'ocio gnanca na pàjina",
	'mobile-frontend-watchlist-a-z-empty-howto-alt' => 'Struca so ła steła in sima a ła pàjina',
	'mobile-frontend-watchlist-a-z-empty-howto' => "Tien d'ocio ła pàjina che te ghe catà interesante strucando so ła steła in sima a ła pàjina. Sta asion te consentirà de segnarte łe pàjine che te intaresa e de tegner d'ocio cuando che łe vien modifegae.",
	'mobile-frontend-watchlist-feed-empty' => 'No ghe xe pàjine có canbiamenti resenti',
	'mobile-frontend-watchlist-back-home' => 'Torna indrio',
	'mobile-frontend-changeslist-ip' => 'Utente anonemo',
	'mobile-frontend-changeslist-nocomment' => 'nisun ogeto de ła modifega',
	'mobile-frontend-watchlist-filter-all' => 'Tute',
	'mobile-frontend-watchlist-filter-articles' => 'Voxe',
	'mobile-frontend-watchlist-filter-talk' => 'Discusion',
	'mobile-frontend-watchlist-filter-other' => 'Altro',
	'mobile-frontend-watchlist-modified' => 'Canbià $1',
	'mobile-frontend-diffview-404-title' => 'Eror version',
	'mobile-frontend-diffview-404-desc' => "El id par ła version dimandà nó 'l existe",
	'mobile-frontend-diffview-title' => 'Canbiamenti',
	'mobile-frontend-diffview-editcount' => '$1 {{PLURAL:$1|contributo|contributi}}',
	'mobile-frontend-diffview-anonymous' => 'Utente anonemo',
	'mobile-frontend-diffview-bytesadded' => '$1 byte {{PLURAL:$1|xontà|xontai}}',
	'mobile-frontend-diffview-bytesremoved' => '$1 byte {{PLURAL:$1|cavà|cavai}}',
	'mobile-frontend-diffview-explained' => 'Łe righe seguenti łe xe stae xontae (+) e cavae (-):',
	'mobile-frontend-table' => 'Tabeła $1',
	'mobile-frontend-saving-exit-page' => 'El to canbiamento el xe ncora da salvar. Se te ve fora i to contributi i ndarà persi. Sito seguro de vołer ndar fora?',
	'mobile-frontend-photo-upload' => 'Xonta na someja a sta voxe',
	'mobile-frontend-photo-article-edit-comment' => 'Xonta na someja a sta pàjina',
	'mobile-frontend-photo-article-donate-comment' => 'Imaxine donà da tełefonin',
	'mobile-frontend-photo-upload-comment' => 'Xonta sta someja a na pàjina',
	'mobile-frontend-photo-caption-placeholder' => 'Xonta na descrision (obligatoria)',
	'mobile-frontend-image-loading' => 'Cargamento imaxene',
	'mobile-frontend-image-uploading-wait' => 'Cargamento imaxene, speta.', # Fuzzy
	'mobile-frontend-photo-upload-error' => 'Eror, proa oncora.',
	'mobile-frontend-photo-upload-success-article' => 'Fato! Ła to imaxene ła xe deso inte ła pàjina.',
	'mobile-frontend-photo-license' => 'Strucando "Manda", te dixi de esar d\'acordo có i nostri [//wikimediafoundation.org/wiki/Terms_of_use Termini d\'Uxo] e te rełasi łe to someje có ła [//en.wikipedia.org/wiki/Wikipedia:Text_of_Creative_Commons_Attribution-ShareAlike_3.0_Unported_License licensa Creative Common Atribusion-Condividi al steso modo 3.0]',
	'mobile-frontend-photo-submit' => 'Manda',
	'mobile-frontend-photo-cancel' => 'Anuła',
	'tag-mobile_edit' => 'Canbiamento da tełefonin',
	'tag-mobile_edit-description' => "Modifega fata dal sito pa' dispoxitivi mobiłi",
	'mobile-frontend-drawer-cancel' => 'Anuła',
);

/** Veps (vepsän kel’)
 * @author Игорь Бродский
 */
$messages['vep'] = array(
	'mobile-frontend-search-submit' => 'Tehta',
	'mobile-frontend-home-button' => 'Pälehtpolele',
	'mobile-frontend-show-button' => 'Ozutada',
	'mobile-frontend-hide-button' => 'Peitta',
	'mobile-frontend-wml-continue' => 'Jätkta...',
	'mobile-frontend-wml-back' => 'Tagaze...',
	'mobile-frontend-view' => 'Mobiline versii',
	'mobile-frontend-news-items' => 'Uzištusiš',
	'mobile-frontend-leave-feedback-subject' => 'Tem', # Fuzzy
	'mobile-frontend-leave-feedback-message' => 'Tedotuz', # Fuzzy
	'mobile-frontend-language' => 'Kel’', # Fuzzy
	'mobile-frontend-password' => 'Peitsana:',
);

/** Vietnamese (Tiếng Việt)
 * @author Minh Nguyen
 * @author Tranletuhan
 * @author පසිඳු කාවින්ද
 */
$messages['vi'] = array(
	'mobile-frontend-desc' => 'Giao diện di động',
	'mobile.css' => '/* Mã CSS đặt ở đây sẽ ảnh hưởng đến những người sử dụng trang di động */',
	'mobile.js' => '/* Mã JavaScript đặt ở đây sẽ được tải khi nào sử dụng trang di động */',
	'mobile-frontend-search-submit' => 'Xem',
	'mobile-frontend-home-button' => 'Trang đầu',
	'mobile-frontend-logged-out' => 'Chưa đăng nhập',
	'mobile-frontend-logged-in-homepage-notification' => 'Hoan nghênh, $1!',
	'mobile-frontend-logged-in-toast-notification' => 'Đã đăng nhập là $1.',
	'mobile-frontend-sign-up-heading' => 'Mở tài khoản',
	'mobile-frontend-sign-in-heading' => 'Đăng nhập',
	'mobile-frontend-sign-in-why' => 'Nếu đã có tài khoản tại {{SITENAME}}, bạn có thể đăng nhập ở dưới.',
	'mobile-frontend-sign-in-error-heading' => 'Ôi',
	'mobile-frontend-settings-description' => 'Tùy biến giao diện trên thiết bị di động của bạn với các tùy chọn di động này.',
	'mobile-frontend-settings-beta' => 'Beta',
	'mobile-frontend-settings-alpha' => 'Chế độ nguy hiểm',
	'mobile-frontend-settings-alpha-description' => 'Đi vào lãnh thổ nguy hiểm chưa quen. Chịu thêm tính năng di động thử nghiệm có thể có nhiều lỗi hơn.',
	'mobile-frontend-save-settings' => 'Lưu thiết lập',
	'mobile-frontend-random-button' => 'Ngẫu nhiên',
	'mobile-frontend-ajax-random-heading' => 'Đang kiếm tri thức…',
	'mobile-frontend-ajax-random-quote' => 'Sự phát triển trí tuệ nên bắt đầu lúc sinh và chỉ nên ngừng lúc chết',
	'mobile-frontend-ajax-random-question' => 'Có muốn đọc trang này?',
	'mobile-frontend-ajax-random-yes' => 'Có',
	'mobile-frontend-ajax-random-retry' => 'Thử lại',
	'mobile-frontend-ajax-random-suggestions' => 'Gợi ý khác:',
	'mobile-frontend-back-to-top-of-section' => 'Nhảy về đầu phần',
	'mobile-frontend-close-section' => 'Đóng phần này',
	'mobile-frontend-show-button' => 'Hiện',
	'mobile-frontend-hide-button' => 'Ẩn',
	'mobile-frontend-empty-homepage-text' => 'Trang chủ này cần được thiết lập. [//meta.wikimedia.org/wiki/Mobile_Projects/Mobile_Gateway?uselang=vi#Mobile_homepage Hướng dẫn kích hoạt chế độ di động cho trang này].',
	'mobile-frontend-regular-site' => 'Bản dành cho máy tính để bàn',
	'mobile-frontend-wml-continue' => 'Tiếp tục…',
	'mobile-frontend-wml-back' => 'Quay lại…',
	'mobile-frontend-view' => 'Phiên bản di động',
	'mobile-frontend-view-desktop' => 'Máy tính để bàn',
	'mobile-frontend-view-mobile' => 'Di động',
	'mobile-frontend-opt-in-explain' => 'Với việc tham gia cuộc thử nghiệm, bạn có thể sử dụng các tính năng thử nghiệm nhưng cũng có thể gặp lỗi và vấn đề trục trặc.',
	'mobile-frontend-images-status' => 'Hình ảnh',
	'mobile-frontend-disable-images' => 'Tắt hình ảnh tại trang di động',
	'mobile-frontend-enable-images' => 'Hiện hình ảnh trên trang di động',
	'mobile-frontend-missing-image' => 'Hình',
	'mobile-frontend-off' => 'TẮT',
	'mobile-frontend-on' => 'BẬT',
	'mobile-frontend-footer-contributors-text' => 'Trang do [$1 những người giống bạn] đóng góp',
	'mobile-frontend-featured-article' => 'Bài viết chọn lọc',
	'mobile-frontend-news-items' => 'Tin tức',
	'mobile-frontend-leave-feedback-notice' => 'Phản hồi giúp chúng tôi cải tiến các trang di động. Những cảm nghĩ của bạn sẽ được đăng công khai vào trang “$1”, cùng với tên người dùng, phiên bản trình duyệt, và hệ điều hành của bạn. Xin vui lòng chọn một tiêu đề có ý nghĩa, thí dụ “Vấn đề hiển thị bảng rộng”. Phản hồi của bạn sẽ được xử lý theo các điều khoản sử dụng.',
	'mobile-frontend-leave-feedback-warning' => 'Xin vui lòng không bao gồm thông tin cá nhân trong bình luận của bạn, không thôi thông tin của bạn sẽ có sẵn công khai.',
	'mobile-frontend-leave-feedback-subject' => 'Tiêu đề:',
	'mobile-frontend-leave-feedback-message' => 'Thông điệp:',
	'mobile-frontend-leave-feedback-submit' => 'Gửi phản hồi',
	'mobile-frontend-leave-feedback-link-text' => 'Phản hồi về giao diện di động',
	'mobile-frontend-leave-feedback' => 'Gửi phản hồi',
	'mobile-frontend-leave-feedback-title' => 'Phản hồi về giao diện di động',
	'mobile-frontend-leave-feedback-technical-problem-section-header' => 'Vấn đề kỹ thuật',
	'mobile-frontend-leave-feedback-general-section-header' => 'Tổng quát',
	'mobile-frontend-leave-feedback-article-feedback-section-header' => 'Phản hồi bài',
	'mobile-frontend-leave-feedback-email-body' => 'Xin vui lòng miêu tả vấn đề bạn đang gặp tại {{SITENAME}} ở trên dòng này. Lưu ý rằng chúng tôi không thể trả lời tất cả mọi thông điệp được gửi cho chúng tôi.',
	'mobile-frontend-leave-feedback-technical-link-text' => 'Vấn đề kỹ thuật',
	'mobile-frontend-leave-feedback-general-link-text' => 'Phản hồi chung',
	'mobile-frontend-leave-feedback-article-personal-link-text' => 'Về tôi hoặc người hay công ty mà tôi đại diện',
	'mobile-frontend-leave-feedback-article-factual-link-text' => 'Về thông tin không chính xác',
	'mobile-frontend-leave-feedback-article-other-link-text' => 'Về vấn đề khác',
	'mobile-frontend-leave-feedback-form-subject-placeholder' => 'Tiêu đề thông điệp',
	'mobile-frontend-leave-feedback-form-message-placeholder' => 'Đưa bình luận vào đây',
	'mobile-frontend-leave-feedback-page-title' => 'Phản hồi về giao diện di động',
	'mobile-frontend-feedback-page' => 'Project:Phản hồi Phần mở rộng Di động',
	'mobile-frontend-leave-feedback-special-title' => 'Liên lạc',
	'mobile-frontend-feedback-no-subject' => '(không tiêu đề)',
	'mobile-frontend-feedback-no-subject-field' => 'Xin vui lòng đưa vào một tiêu đề',
	'mobile-frontend-feedback-no-message' => 'Xin vui lòng nhắn tin vào đây',
	'mobile-frontend-feedback-edit-summary' => '$1 – do [[Special:MobileFeedback|công cụ phản hồi di động]] đăng tự động',
	'mobile-frontend-leave-feedback-thanks' => 'Cám ơn phản hồi của bạn!',
	'mobile-frontend-leave-feedback-post-error' => 'Đã xảy ra lỗi khi xử lý thông điệp của bạn. Xin hãy thử lại sau.',
	'mobile-frontend-language' => 'Ngôn ngữ:',
	'mobile-frontend-language-article-heading' => 'Đọc trong ngôn ngữ khác',
	'mobile-frontend-language-header' => 'Trang này có sẵn trong $1 ngôn ngữ',
	'mobile-frontend-language-variant-header' => 'Chọn bộ chữ {{#language:{{CONTENTLANG}}}}',
	'mobile-frontend-language-footer' => 'Lưu ý: Trang này có thể không được viết bằng ngôn ngữ chính của bạn. Nhấn chuột tại đây để xem {{SITENAME}} có sẵn trong ngôn ngữ nào.',
	'mobile-frontend-language-site-choose' => 'Tìm ngôn ngữ',
	'mobile-frontend-username' => 'Tên người dùng:',
	'mobile-frontend-password' => 'Mật khẩu:',
	'mobile-frontend-username-placeholder' => 'Tên người dùng',
	'mobile-frontend-password-placeholder' => 'Mật khẩu',
	'mobile-frontend-login' => 'Đăng nhập',
	'mobile-frontend-last-modified-date' => 'Sửa đổi lần cuối lúc $2 vào $1',
	'mobile-frontend-last-modified-seconds' => 'Sửa đổi lần cuối cách đây $1 giây',
	'mobile-frontend-last-modified-minutes' => 'Sửa đổi lần cuối cách đây $1 phút',
	'mobile-frontend-last-modified-hours' => 'Sửa đổi lần cuối cách đây $1 giờ',
	'mobile-frontend-last-modified-days' => 'Sửa đổi lần cuối cách đây $1 ngày',
	'mobile-frontend-last-modified-months' => 'Sửa đổi lần cuối cách đây $1 tháng',
	'mobile-frontend-last-modified-years' => 'Sửa đổi lần cuối cách đây $1 năm',
	'mobile-frontend-account-create-submit' => 'Mở tài khoản',
	'mobile-frontend-password-confirm-placeholder' => 'Xác nhận mật khẩu',
	'mobile-frontend-account-create-email-placeholder' => 'Địa chỉ thư điện tử (tùy chọn)',
	'mobile-frontend-account-create-captcha-placeholder' => 'Nhập văn bản bảo mật',
	'mobile-frontend-overlay-escape' => 'Quay lại',
	'mobile-frontend-placeholder' => 'Tìm kiếm {{SITENAME}}…',
	'mobile-frontend-placeholder-beta' => 'Tìm kiếm {{SITENAME}} (Beta)',
	'mobile-frontend-placeholder-alpha' => 'Tìm {{SITENAME}} (Chế độ nguy hiểm)',
	'mobile-frontend-search-help' => 'Nhập từ khóa tìm kiếm ở trên để xem các trang trùng tên ở đây.',
	'mobile-frontend-dismiss-notification' => 'bỏ qua thông báo này',
	'mobile-frontend-clear-search' => 'Tẩy trống',
	'mobile-frontend-privacy-link-text' => 'Riêng tư',
	'mobile-frontend-about-link-text' => 'Giới thiệu',
	'mobile-frontend-footer-sitename' => '{{SITENAME}}',
	'mobile-frontend-footer-license-text' => 'Nội dung có sẵn theo [//vi.m.wikipedia.org/wiki/Wikipedia:Nguyên_văn_Giấy_phép_Creative_Commons_Ghi_công–Chia_sẻ_tương_tự_phiên_bản_3.0_Chưa_chuyển_đổi?useformat=mobile CC BY-SA 3.0]',
	'mobile-frontend-terms-use-text' => '[//wikimediafoundation.org/wiki/Điều_khoản_Sử_dụng?useformat=mobile&uselang=vi Các Điều khoản Sử dụng]',
	'mobile-frontend-footer-contact' => 'Liên lạc',
	'mobile-frontend-search-noresults' => 'Không tìm thấy trang trùng tên. Hãy thay đổi truy vấn hoặc bấm phím tìm kiếm để tìm kiếm trong trang.',
	'mobile-frontend-main-menu-button-tooltip' => 'Mở trình đơn chính',
	'mobile-frontend-main-menu-page-title' => 'Điều hướng các trang',
	'mobile-frontend-main-menu-featured' => 'Chọn lọc',
	'mobile-frontend-main-menu-nearby' => 'Kề bên',
	'mobile-frontend-main-menu-login' => 'Đăng nhập',
	'mobile-frontend-main-menu-logout' => 'Đăng xuất',
	'mobile-frontend-main-menu-watchlist' => 'Danh sách theo dõi',
	'mobile-frontend-main-menu-settings' => 'Tùy chọn',
	'mobile-frontend-main-menu-upload' => 'Tập tin tải lên',
	'mobile-frontend-main-menu-settings-heading' => 'Tùy chọn di động',
	'mobile-frontend-settings-site-header' => 'Ngôn ngữ {{SITENAME}}',
	'mobile-frontend-settings-site-description' => '{{SITENAME}} có sẵn trong $1 ngôn ngữ. Tất cả các phiên bản có sẵn ở dưới:',
	'mobile-frontend-main-menu-contact' => 'Liên lạc',
	'mobile-frontend-main-menu-account-create' => 'Mở tài khoản',
	'mobile-frontend-page-menu-contents' => 'mục lục',
	'mobile-frontend-page-menu-history' => 'Lịch sử',
	'mobile-frontend-meta-data-issues-header' => 'Các vấn đề',
	'mobile-frontend-meta-data-issues' => 'Trang này có một số vấn đề',
	'mobile-frontend-ajax-page-loading' => 'Đang tải $1',
	'mobile-frontend-page-saving' => 'Đang lưu $1',
	'mobile-frontend-ajax-page-error' => 'Ôi! Có gì đó bị trục trặc rồi. Hãy thử làm tươi cửa sổ trình duyệt.',
	'mobile-frontend-nearby-title' => 'Kề bên',
	'mobile-frontend-nearby-loading' => 'Đang tải các đề tài gần vị trí của bạn',
	'mobile-frontend-nearby-requirements' => 'Trang này cần JavaScript và một trình duyệt biết gửi vị trí.',
	'mobile-frontend-nearby-distance-report' => 'Hiện tại cách bạn $1 km',
	'mobile-frontend-nearby-lookup-error' => 'Không tìm thấy bạn. Đang thử lại…',
	'mobile-frontend-nearby-noresults' => 'Bạn đang ở vùng xa xôi hẻo lánh, nên chúng tôi không tìm thấy đề tài nào. Hãy viết đề tài mới!',
	'mobile-frontend-nearby-refresh' => 'Chúng tôi đã chỉnh lại vị trí của bạn. Nhấn chuột vào đây để tải lại danh sách các trang kề bên.',
	'mobile-frontend-nearby-error' => 'Xuất hiện lỗi bất ngờ khi tìm kiếm trang kề bên',
	'mobile-frontend-donate-image-login' => 'Bạn phải đăng nhập để xem các tập tin bạn đã tải lên.',
	'mobile-frontend-photo-upload-generic' => 'Đóng góp một hình ảnh',
	'mobile-frontend-donate-image-title' => 'Đóng góp một hình ảnh',
	'mobile-frontend-donate-image-summary' => 'Các hình ảnh làm cho {{SITENAME}} thú vị hơn.
Hiện nay rất nhiều trang thiếu hình ảnh vì không có đủ hình ảnh được phát hành theo giấy phép tự do.
Hãy giúp làm các trang này thú vị hơn bằng cách vui lòng đóng góp những hình ảnh của bạn mà bạn cảm thấy có thể giúp ích cộng đồng biên tập {{SITENAME}}.',
	'mobile-frontend-donate-image-heading' => 'Đóng góp của bạn gần đây',
	'mobile-frontend-donate-image-page-title' => 'Tải lên',
	'mobile-frontend-donate-image-anon' => 'Cần có [[Special:UserLogin|tài khoản người dùng]] để xem trang tải lên.',
	'mobile-frontend-listed-image-no-description' => 'Không miêu tả',
	'mobile-frontend-donate-photo-upload-success' => 'Thành công! Bây giờ bạn có thể sử dụng hình ảnh của bạn trên {{SITENAME}}!',
	'mobile-frontend-donate-photo-first-upload-success' => 'Thành công! Cám ơn bạn đã đóng góp lần đầu tiên!',
	'mobile-frontend-watchlist-add' => 'Đã thêm $1 vào danh sách theo dõi của bạn',
	'mobile-frontend-watchlist-removed' => 'Đã dời $1 khỏi danh sách theo dõi của bạn',
	'mobile-frontend-watchlist-view' => 'Xem danh sách theo dõi của bạn',
	'mobile-frontend-watchlist-more' => 'thêm',
	'mobile-frontend-watchlist-cta' => 'Xin hãy đăng nhập hay mở tài khoản để theo dõi trang này.',
	'mobile-frontend-watchlist-cta-button-login' => 'Đăng nhập',
	'mobile-frontend-watchlist-cta-button-signup' => 'Mở tài khoản',
	'mobile-frontend-watch-login' => 'Bạn phải đăng nhập để theo dõi trang.',
	'mobile-frontend-watchlist-a-z' => 'Tất cả',
	'mobile-frontend-watchlist-feed' => 'Các thay đổi',
	'mobile-frontend-watchlist-a-z-empty' => 'Bạn hiện không theo dõi trang nào',
	'mobile-frontend-watchlist-a-z-empty-howto-alt' => 'Bấm vào ngôi sao ở đầu trang',
	'mobile-frontend-watchlist-a-z-empty-howto' => 'Theo dõi một trang mà bạn cảm thấy thú vị bằng cách bấm vào hình ngôi sao ở phía trên màn hình. Trang sẽ được đánh dấu để cho bạn biết khi nào nó thay đổi.',
	'mobile-frontend-watchlist-feed-empty' => 'Không có trang nào được thay đổi gần đây',
	'mobile-frontend-watchlist-back-home' => 'Quay lại nhà',
	'mobile-frontend-changeslist-ip' => 'Người dùng vô danh',
	'mobile-frontend-changeslist-nocomment' => 'không có tóm lược sửa đổi',
	'mobile-frontend-watchlist-filter-all' => 'Tất cả',
	'mobile-frontend-watchlist-filter-articles' => 'Bài viết',
	'mobile-frontend-watchlist-filter-talk' => 'Thảo luận',
	'mobile-frontend-watchlist-filter-other' => 'Khác',
	'mobile-frontend-watchlist-modified' => 'Được sửa đổi $1',
	'mobile-frontend-diffview-404-title' => 'Phiên bản sai',
	'mobile-frontend-diffview-404-desc' => 'Số phiên bản được yêu cầu không tồn tại.',
	'mobile-frontend-diffview-title' => 'Các thay đổi',
	'mobile-frontend-diffview-editcount' => '$1 lần sửa đổi',
	'mobile-frontend-diffview-anonymous' => 'Người dùng vô danh',
	'mobile-frontend-diffview-bytesadded' => 'thêm $1 byte',
	'mobile-frontend-diffview-bytesremoved' => 'bớt $1 byte',
	'mobile-frontend-diffview-explained' => 'Các dòng sau đã được thêm (+) và xóa (-):',
	'mobile-frontend-table' => 'Bảng $1',
	'mobile-frontend-saving-exit-page' => 'Các đóng góp của bạn còn đang được lưu giữ. Nếu bạn bỏ đi, các đóng góp này sẽ bị mất. Bạn có chắc muốn thoát?',
	'mobile-frontend-photo-upload' => 'Thêm hình vào bài này',
	'mobile-frontend-photo-article-edit-comment' => 'Đã thêm hình để sử dụng trong trang',
	'mobile-frontend-photo-article-donate-comment' => 'Đã đóng góp hình ảnh từ thiết bị di động',
	'mobile-frontend-photo-upload-comment' => 'Đã thêm hình vào trang',
	'mobile-frontend-photo-caption-placeholder' => 'Thêm miêu tả (bắt buộc)',
	'mobile-frontend-image-loading' => 'Đang tải hình',
	'mobile-frontend-image-uploading-wait' => 'Đang tải lên hình; xin vui lòng chờ.',
	'mobile-frontend-image-uploading-long' => 'Vẫn đang còn tải lên hình! Cám ơn sự kiên nhẫn của bạn.',
	'mobile-frontend-image-uploading-cancel' => 'Hãy <a href="#">hủy bỏ</a> nếu việc tải lên mất nhiều thì giờ quá.',
	'mobile-frontend-photo-upload-error' => 'Đã xuất hiện lỗi; hãy thử lại.',
	'mobile-frontend-photo-upload-success-article' => 'Xong rồi, trang này hiện có hình ảnh của bạn.',
	'mobile-frontend-photo-license' => 'Với việc bấm “Tải lên”, bạn chấp nhận [//wikimediafoundation.org/wiki/Terms_of_Use/vi?uselang=vi các Điều khoản Sử dụng], và bạn đồng ý phát hành hình ảnh của mình theo [//creativecommons.org/licenses/by-sa/3.0/deed.vi Giấy phép Creative Commons Ghi công–Chia sẻ tương tự 3.0].',
	'mobile-frontend-photo-submit' => 'Tải lên',
	'mobile-frontend-photo-cancel' => 'Hủy bỏ',
	'mobile-frontend-photo-upload-user-count' => '<span>$1</span> tải lên',
	'mobile-frontend-photo-upload-user-count-over-limit' => '500+ tải lên',
	'tag-mobile_edit' => 'Sửa đổi di động',
	'tag-mobile_edit-description' => 'Trang được sửa đổi dùng trang di động',
	'mobile-frontend-drawer-cancel' => 'Hủy bỏ',
);

/** Volapük (Volapük)
 * @author Malafaya
 */
$messages['vo'] = array(
	'mobile-frontend-show-button' => 'Jonön',
	'mobile-frontend-hide-button' => 'Klänedön',
	'mobile-frontend-language' => 'Pük:',
);

/** Võro (Võro)
 */
$messages['vro'] = array(
	'mobile-frontend-search-submit' => 'Mineq',
	'mobile-frontend-home-button' => 'Pääleht',
	'mobile-frontend-random-button' => 'Johuslinõ leht',
	'mobile-frontend-back-to-top-of-section' => 'Mineq tagasi	 jakko A',
	'mobile-frontend-show-button' => 'Näütäq',
	'mobile-frontend-hide-button' => 'Käkiq',
	'mobile-frontend-regular-site' => 'Näütäq seod lehte hariligun Vikipeediän', # Fuzzy
	'mobile-frontend-featured-article' => 'Täämbädse päävä artikli',
);

/** Wolof (Wolof)
 */
$messages['wo'] = array(
	'mobile-frontend-search-submit' => 'Ayca',
	'mobile-frontend-home-button' => ' xët wu njëkk',
	'mobile-frontend-show-button' => 'Wone',
	'mobile-frontend-hide-button' => 'Nëbb',
	'mobile-frontend-regular-site' => 'Wone xët wi ci {{SITENAME}} wees baaxoo', # Fuzzy
	'mobile-frontend-featured-article' => 'Jukkib bés bi',
);

/** Kalmyk (хальмг)
 */
$messages['xal'] = array(
	'mobile-frontend-search-submit' => 'Ор',
	'mobile-frontend-home-button' => 'Герт',
	'mobile-frontend-random-button' => 'Уршг',
	'mobile-frontend-back-to-top-of-section' => 'Хүвәр хәрү',
	'mobile-frontend-show-button' => 'Үзүлх',
	'mobile-frontend-hide-button' => 'Бултулх',
	'mobile-frontend-regular-site' => 'Кирин Бикипедин халх хәләх', # Fuzzy
	'mobile-frontend-featured-article' => 'Өдрә суңһгдсн халх',
);

/** Mingrelian (მარგალური)
 */
$messages['xmf'] = array(
	'mobile-frontend-show-button' => 'ძირაფა',
	'mobile-frontend-hide-button' => 'ტყობინაფა',
);

/** Yiddish (ייִדיש)
 * @author Imre
 * @author פוילישער
 */
$messages['yi'] = array(
	'mobile-frontend-desc' => 'מאבייל אויסשטעלונג',
	'mobile-frontend-search-submit' => 'גיי',
	'mobile-frontend-home-button' => 'היימבלאַט',
	'mobile-frontend-logged-out' => 'נישט ארײַנלאגירט',
	'mobile-frontend-logged-in-homepage-notification' => 'ברוך הבא, $1!',
	'mobile-frontend-logged-in-toast-notification' => 'ארײַנלאגירט ווי $1.',
	'mobile-frontend-sign-up-heading' => 'פֿארשרייבן זיך',
	'mobile-frontend-sign-in-heading' => 'איינשרייבונג',
	'mobile-frontend-settings-description' => 'פאַסט צו אײַער מאבייל דערפֿאַרונג מיט די ספעציפישע אײַנשטעלונגען פאר מאבייל אפאראטן.',
	'mobile-frontend-settings-beta' => 'בעטע',
	'mobile-frontend-save-settings' => 'אויפהיטן אײַנשטעלונגען',
	'mobile-frontend-random-button' => 'צופֿעליג',
	'mobile-frontend-ajax-random-question' => 'געליינטט דעם בלאט?',
	'mobile-frontend-ajax-random-yes' => 'יאָ',
	'mobile-frontend-ajax-random-retry' => 'פרובירט נאכאמאל',
	'mobile-frontend-back-to-top-of-section' => 'צוריקשפרינגען אַן אָפטייל',
	'mobile-frontend-close-section' => 'פארמאכן דעם אפטייל',
	'mobile-frontend-show-button' => 'ווײַזן',
	'mobile-frontend-hide-button' => 'באַהאַלטן',
	'mobile-frontend-empty-homepage-text' => 'דעם היימבלאט דארף מען קאנפיגורירן. [//meta.wikimedia.org/wiki/Mobile_Projects/Mobile_Gateway#Mobile_homepage אנווייזן ווי צו שאפן דאס וועבזייטל מאבייל־אקטיווירט]',
	'mobile-frontend-regular-site' => 'נארמאַלער קאמפיוטער באַקוק',
	'mobile-frontend-wml-continue' => 'ווײַטער …',
	'mobile-frontend-wml-back' => 'צוריק ...',
	'mobile-frontend-view' => 'מאבילער קוק',
	'mobile-frontend-view-desktop' => 'נארמאלע אויסשטעלונג',
	'mobile-frontend-view-mobile' => 'מאבייל אויסשטעלונג',
	'mobile-frontend-images-status' => 'בילדער',
	'mobile-frontend-disable-images' => 'אומאקטיווירן בילדער פאר מאביילן',
	'mobile-frontend-enable-images' => 'אקטיווירן בילדער פאר מאביילן',
	'mobile-frontend-off' => 'אויס',
	'mobile-frontend-on' => 'אקטיוויזירט',
	'mobile-frontend-footer-contributors-text' => 'בלאט פון [$1 בײַשטײַערער] ווי איר',
	'mobile-frontend-featured-article' => 'דער הײַנטיקער רעקאמענדירטער אַרטיקל',
	'mobile-frontend-news-items' => 'אין די נײַעס',
	'mobile-frontend-leave-feedback-subject' => 'טעמע:',
	'mobile-frontend-leave-feedback-message' => 'מעלדונג:',
	'mobile-frontend-leave-feedback-submit' => 'ארײַנגעבן פֿידבעק',
	'mobile-frontend-leave-feedback-title' => 'מאבייל וועבארט פידבעק',
	'mobile-frontend-leave-feedback-technical-problem-section-header' => 'טעכנישער פראבלעם',
	'mobile-frontend-leave-feedback-general-section-header' => 'אַלגעמיין',
	'mobile-frontend-leave-feedback-article-feedback-section-header' => 'ארטיקל פֿידבעק',
	'mobile-frontend-leave-feedback-email-body' => '!ביטע שילדערט דעם פראבלעם וואס איר האט מיט {{SITENAME}} איבער דער שורה. ליידער קענען מיר נישט ענטפערן יעדע מעלדונג וואס מיר באקומען.',
	'mobile-frontend-leave-feedback-technical-link-text' => 'טעכנישער פראבלעם',
	'mobile-frontend-leave-feedback-general-link-text' => 'אלגעמיינער פֿידבעק',
	'mobile-frontend-leave-feedback-article-other-link-text' => 'וועגן אן אנדער פראבלעם',
	'mobile-frontend-leave-feedback-form-subject-placeholder' => 'מעלדונג טעמע',
	'mobile-frontend-leave-feedback-form-message-placeholder' => 'קלאפט ארײַן אײַער הערה דא',
	'mobile-frontend-leave-feedback-special-title' => 'קאנטאקטירן אונז',
	'mobile-frontend-feedback-no-subject' => '(קיין טעמע)',
	'mobile-frontend-feedback-no-subject-field' => 'ביטע ארײַנגעבן א סוביעקט',
	'mobile-frontend-feedback-no-message' => 'ביטע גיט ארײַן א מעלדונג דא',
	'mobile-frontend-leave-feedback-thanks' => 'ייש"כ פאר אייער פידבעק!',
	'mobile-frontend-leave-feedback-post-error' => 'עס האט פאסירט א פעלער ביים פראצעסירן אייער מעלדונג. ביטע פרובירט נאכאמאל שפעטער.',
	'mobile-frontend-language' => 'שפּראַך:',
	'mobile-frontend-language-article-heading' => 'לייענען אין אן אנדער שפראך',
	'mobile-frontend-language-header' => 'דער בלאט איז פאראן אין $1 {{PLURAL:$1|שפראך|שפראכן}}',
	'mobile-frontend-language-site-choose' => 'זוך שפראך',
	'mobile-frontend-username' => 'באַניצער נאָמען:',
	'mobile-frontend-password' => 'פאסווארט:',
	'mobile-frontend-login' => 'אַרײַנלאגירן',
	'mobile-frontend-placeholder' => 'זוכן {{SITENAME}}',
	'mobile-frontend-search-help' => 'קלאפט ארײַן זוכווארט אויבן. צוגעפאסטע בלאט קעפלעך וועט מען ווײַזן דא.',
	'mobile-frontend-dismiss-notification' => 'באהאלטן דעם קאמוניקאט',
	'mobile-frontend-clear-search' => 'רייניקן',
	'mobile-frontend-privacy-link-text' => 'פריוואטקייט',
	'mobile-frontend-about-link-text' => 'וועגן',
	'mobile-frontend-footer-sitename' => '{{SITENAME}}',
	'mobile-frontend-footer-contact' => 'קאנטאקט',
	'mobile-frontend-main-menu-featured' => 'רעקאמנדירט',
	'mobile-frontend-main-menu-nearby' => 'דערבײַ',
	'mobile-frontend-main-menu-login' => 'אַרײַנלאָגירן',
	'mobile-frontend-main-menu-logout' => 'אַרויסלאגירן',
	'mobile-frontend-main-menu-settings' => 'איינשטעלונגען',
	'mobile-frontend-main-menu-settings-heading' => 'מאביילן איינשטעלונגען',
	'mobile-frontend-settings-site-header' => '{{SITENAME}} שפראכן',
	'mobile-frontend-settings-site-description' => '{{SITENAME}} איז דערגרייכלעך אין $1 {{PLURAL:$1|שפראך|שפראכן}}. אלע דערגרייכלעכע ווערסיעס געפינען זיך אונטן',
	'mobile-frontend-main-menu-contact' => 'קאנטאַקט',
	'mobile-frontend-page-menu-contents' => 'אינהאַלט',
	'mobile-frontend-page-menu-history' => 'היסטאריע',
	'mobile-frontend-meta-data-issues-header' => 'פראגעס',
	'mobile-frontend-meta-data-issues' => 'דער בלאט האט עטלעכע פֿראגעס',
	'mobile-frontend-ajax-page-loading' => 'לאָדן $1',
	'mobile-frontend-page-saving' => 'אויפֿהיטן $1',
	'mobile-frontend-ajax-page-error' => 'אוי־וויי! עפעס איז געשען דא. זייט אזוי גוט פרובירט דערפרישן אייער בלעטער פענסטער.',
	'mobile-frontend-watchlist-add' => 'צוגעלייגט $1 צו אייער אויפפאסונג ליסטע',
	'mobile-frontend-watchlist-removed' => 'אראפגענומען $1 פון אייער אויפפאסונג ליסטע',
	'mobile-frontend-watchlist-view' => 'באקוקן אייער אויפפאסונג ליסטע',
	'mobile-frontend-photo-caption-placeholder' => 'צולייגן א באשרייבונג (באדארפט)',
	'mobile-frontend-photo-upload-error' => 'פֿעלער, פרובירט נאכאמאל.',
	'mobile-frontend-photo-cancel' => 'אַנולירן',
	'mobile-frontend-drawer-cancel' => 'אַנולירן',
);

/** Yoruba (Yorùbá)
 * @author Demmy
 */
$messages['yo'] = array(
	'mobile-frontend-search-submit' => 'Lọ',
	'mobile-frontend-home-button' => 'Ibùdó',
	'mobile-frontend-random-button' => 'Ojúewé àrìnnàkò',
	'mobile-frontend-show-button' => 'Fihàn',
	'mobile-frontend-hide-button' => 'Bòmọ́lẹ̀',
	'mobile-frontend-language' => 'Èdè', # Fuzzy
	'mobile-frontend-username' => 'Orúkọ oníṣe:',
);

/** Cantonese (粵語)
 * @author Waihorace
 */
$messages['yue'] = array(
	'mobile-frontend-back-to-top-of-section' => '番去上一章',
	'mobile-frontend-show-button' => '打開',
	'mobile-frontend-hide-button' => '收埋',
	'mobile-frontend-regular-site' => '喺正常嘅{{SITENAME}}睇呢版', # Fuzzy
	'mobile-frontend-view' => '流動版',
	'mobile-frontend-disable-images' => '喺手機版唔睇圖',
);

/** Simplified Chinese (中文（简体）‎)
 * @author Anakmalaysia
 * @author Bencmq
 * @author Dimension
 * @author Hydra
 * @author Hzy980512
 * @author Kuailong
 * @author Liangent
 * @author Linforest
 * @author Mys 721tx
 * @author PhiLiP
 * @author Shirayuki
 * @author Shizhao
 * @author Simon Shek
 * @author Xiaomingyan
 * @author Yfdyh000
 * @author 乌拉跨氪
 */
$messages['zh-hans'] = array(
	'mobile-frontend-desc' => '移动前端',
	'mobile-frontend-search-submit' => '搜索',
	'mobile-frontend-home-button' => '首页',
	'mobile-frontend-logged-out' => '未登录',
	'mobile-frontend-logged-in-homepage-notification' => '欢迎，$1！',
	'mobile-frontend-logged-in-toast-notification' => '以$1登录。',
	'mobile-frontend-sign-up-heading' => '注册',
	'mobile-frontend-sign-in-heading' => '登录',
	'mobile-frontend-sign-in-why' => '如果你有一个{{SITENAME}}的帐号，你可以在下面登录。',
	'mobile-frontend-sign-in-error-heading' => '呃，错了',
	'mobile-frontend-settings-description' => '调整这些移动版网站设置，以定制你的移动设备体验。',
	'mobile-frontend-settings-beta' => '测试版',
	'mobile-frontend-settings-alpha' => '[//en.wikipedia.org/wiki/Here_be_dragons Here be dragons]（探索）模式',
	'mobile-frontend-settings-alpha-description' => '进入危险、未知的移动领域。可以获得更多的实验性功能，但同时也有更多危险的错误。',
	'mobile-frontend-save-settings' => '保存设置',
	'mobile-frontend-random-button' => '随机',
	'mobile-frontend-ajax-random-heading' => '知识定位...',
	'mobile-frontend-ajax-random-quote' => '一个人智力的增长应该从出生开始直到死亡',
	'mobile-frontend-ajax-random-question' => '要阅读这篇页面吗？',
	'mobile-frontend-ajax-random-yes' => '是',
	'mobile-frontend-ajax-random-retry' => '再试试',
	'mobile-frontend-ajax-random-suggestions' => '其他建议：',
	'mobile-frontend-back-to-top-of-section' => '返回章节顶部',
	'mobile-frontend-close-section' => '关闭本章节',
	'mobile-frontend-show-button' => '展开',
	'mobile-frontend-hide-button' => '隐藏',
	'mobile-frontend-empty-homepage-text' => '此首页需要设置。[//meta.wikimedia.org/wiki/Mobile_Projects/Mobile_Gateway#Mobile_homepage 了解如何启动此站的移动版本]',
	'mobile-frontend-regular-site' => '桌面版视图',
	'mobile-frontend-wml-continue' => '继续...',
	'mobile-frontend-wml-back' => '返回...',
	'mobile-frontend-view' => '移动版视图',
	'mobile-frontend-view-desktop' => '桌面版',
	'mobile-frontend-view-mobile' => '移动版',
	'mobile-frontend-opt-in-explain' => '加入测试版，你将可以使用实验功能，但可能遇到漏洞和问题。',
	'mobile-frontend-images-status' => '图像',
	'mobile-frontend-disable-images' => '在移动版网站禁用图像',
	'mobile-frontend-enable-images' => '在移动版网站启用图像',
	'mobile-frontend-missing-image' => '图像',
	'mobile-frontend-off' => '关',
	'mobile-frontend-on' => '开',
	'mobile-frontend-footer-contributors-text' => '条目由同你一样的[$1 贡献者]编辑',
	'mobile-frontend-featured-article' => '特色条目',
	'mobile-frontend-news-items' => '新闻动态',
	'mobile-frontend-leave-feedback-notice' => '你的反馈将帮助我们改进你的移动版网站体验。它们（附有你的用户名、浏览器版本和操作系统信息）会被公开发布在“$1”页面。请使用实用的主题，如“宽表格式问题”。你的反馈必须符合我们的使用条款。',
	'mobile-frontend-leave-feedback-warning' => '除非你同意公开你的信息，请不要在你的意见中包含个人信息。',
	'mobile-frontend-leave-feedback-subject' => '主题：',
	'mobile-frontend-leave-feedback-message' => '信息：',
	'mobile-frontend-leave-feedback-submit' => '提交反馈',
	'mobile-frontend-leave-feedback-link-text' => '移动前端扩展程序反馈',
	'mobile-frontend-leave-feedback' => '移动版网站反馈',
	'mobile-frontend-leave-feedback-title' => '移动版网站反馈',
	'mobile-frontend-leave-feedback-technical-problem-section-header' => '技术问题',
	'mobile-frontend-leave-feedback-general-section-header' => '普通',
	'mobile-frontend-leave-feedback-article-feedback-section-header' => '条目反馈',
	'mobile-frontend-leave-feedback-email-body' => '请在本行上面描述你在{{SITENAME}}遇到的问题。请注意我们不会回复所有接收到的消息。',
	'mobile-frontend-leave-feedback-technical-link-text' => '技术问题',
	'mobile-frontend-leave-feedback-general-link-text' => '普通反馈',
	'mobile-frontend-leave-feedback-article-personal-link-text' => '关于我、我代表的人或我代表的公司',
	'mobile-frontend-leave-feedback-article-factual-link-text' => '关于事实错误',
	'mobile-frontend-leave-feedback-article-other-link-text' => '关于其他问题',
	'mobile-frontend-leave-feedback-form-subject-placeholder' => '信息主题',
	'mobile-frontend-leave-feedback-form-message-placeholder' => '请在这里输入你的意见',
	'mobile-frontend-leave-feedback-page-title' => '移动版网站反馈',
	'mobile-frontend-feedback-page' => 'Project:移动版扩展程序反馈',
	'mobile-frontend-leave-feedback-special-title' => '联系我们',
	'mobile-frontend-feedback-no-subject' => '（无主题）',
	'mobile-frontend-feedback-no-subject-field' => '请输入主题',
	'mobile-frontend-feedback-no-message' => '请在这里输入信息',
	'mobile-frontend-feedback-edit-summary' => '$1 - 使用[[Special:MobileFeedback|移动版反馈工具]]自动发布',
	'mobile-frontend-leave-feedback-thanks' => '谢谢你的反馈！',
	'mobile-frontend-leave-feedback-post-error' => '处理你的信息时出错。请稍候重试。',
	'mobile-frontend-language' => '语言：',
	'mobile-frontend-language-article-heading' => '阅读其他语言',
	'mobile-frontend-language-header' => '此页面有$1{{PLURAL:$1|种语言|种语言}}可阅读',
	'mobile-frontend-language-variant-header' => '选择{{#language:{{CONTENTLANG}}}}转换版本',
	'mobile-frontend-language-footer' => '注意：此页面可能没有使用你的母语书写。你可以点击这里浏览其它语言的{{SITENAME}}。',
	'mobile-frontend-language-site-choose' => '搜索语言',
	'mobile-frontend-username' => '用户名：',
	'mobile-frontend-password' => '密码：',
	'mobile-frontend-username-placeholder' => '用户名',
	'mobile-frontend-password-placeholder' => '密码',
	'mobile-frontend-login' => '登录',
	'mobile-frontend-last-modified-date' => '最后更新于$1 $2',
	'mobile-frontend-last-modified-seconds' => '最后更新于{{PLURAL:$1|$1秒|$1秒}}之前',
	'mobile-frontend-last-modified-minutes' => '最后更新于{{PLURAL:$1|$1分钟|$1分钟}}之前',
	'mobile-frontend-last-modified-hours' => '最后更新于{{PLURAL:$1|$1小时|$1小时}}之前',
	'mobile-frontend-last-modified-days' => '最后更新于{{PLURAL:$1|$1天|$1天}}之前',
	'mobile-frontend-last-modified-months' => '最后更新于{{PLURAL:$1|$1个月|$1个月}}之前',
	'mobile-frontend-last-modified-years' => '最后更新于{{PLURAL:$1|$1年|$1年}}之前',
	'mobile-frontend-account-create-submit' => '注册',
	'mobile-frontend-password-confirm-placeholder' => '确认密码',
	'mobile-frontend-account-create-email-placeholder' => '电邮地址（可选）',
	'mobile-frontend-account-create-captcha-placeholder' => '输入校验码',
	'mobile-frontend-overlay-escape' => '返回',
	'mobile-frontend-placeholder' => '搜索{{SITENAME}}',
	'mobile-frontend-placeholder-beta' => '搜索{{SITENAME}}（测试版）',
	'mobile-frontend-placeholder-alpha' => '搜索{{SITENAME}}（探索模式）',
	'mobile-frontend-search-help' => '请在上面输入搜索关键词，匹配的页面标题将会在这里显示。',
	'mobile-frontend-dismiss-notification' => '关闭本通知',
	'mobile-frontend-clear-search' => '清除',
	'mobile-frontend-privacy-link-text' => '隐私',
	'mobile-frontend-about-link-text' => '关于',
	'mobile-frontend-footer-sitename' => '{{SITENAME}}',
	'mobile-frontend-footer-license-text' => '内容采用[//zh.m.wikipedia.org/wiki/Wikipedia:CC-BY-SA-3.0协议文本?useformat=mobile CC BY-SA 3.0]授权',
	'mobile-frontend-terms-use-text' => '[//wikimediafoundation.org/wiki/%E4%BD%BF%E7%94%A8%E6%9D%A1%E6%AC%BE?useformat=mobile 使用条款]',
	'mobile-frontend-footer-contact' => '联系',
	'mobile-frontend-search-noresults' => '无页面标题匹配你的搜索。请更换关键词，或按键盘搜索键在页面中搜索。',
	'mobile-frontend-main-menu-button-tooltip' => '打开主菜单',
	'mobile-frontend-main-menu-page-title' => '站点导航',
	'mobile-frontend-main-menu-featured' => '特色',
	'mobile-frontend-main-menu-nearby' => '附近',
	'mobile-frontend-main-menu-login' => '登录',
	'mobile-frontend-main-menu-logout' => '退出',
	'mobile-frontend-main-menu-watchlist' => '监视列表',
	'mobile-frontend-main-menu-settings' => '设置',
	'mobile-frontend-main-menu-upload' => '上传',
	'mobile-frontend-main-menu-settings-heading' => '移动版网站设置',
	'mobile-frontend-settings-site-header' => '{{SITENAME}}的语言',
	'mobile-frontend-settings-site-description' => '{{SITENAME}}有$1种语言。下面列出所有的语言。',
	'mobile-frontend-main-menu-contact' => '联系',
	'mobile-frontend-main-menu-account-create' => '创建帐号',
	'mobile-frontend-page-menu-contents' => '目录',
	'mobile-frontend-page-menu-history' => '历史',
	'mobile-frontend-meta-data-issues-header' => '存在的问题',
	'mobile-frontend-meta-data-issues' => '此页面有问题',
	'mobile-frontend-ajax-page-loading' => '正在载入$1',
	'mobile-frontend-page-saving' => '正在保存$1',
	'mobile-frontend-ajax-page-error' => '呃！出错了。请尝试刷新你的浏览器窗口。',
	'mobile-frontend-nearby-title' => '附近',
	'mobile-frontend-nearby-loading' => '加载您当前位置附近的主题',
	'mobile-frontend-nearby-requirements' => '此页面需要JavaScript和浏览器位置信息。',
	'mobile-frontend-nearby-distance-report' => '据您当前位置$1公里',
	'mobile-frontend-nearby-lookup-error' => '无法找到您的位置。请重试...',
	'mobile-frontend-nearby-noresults' => '你位于一个偏僻的地方，我们找不到任何主题。为什么不写一个呢？',
	'mobile-frontend-nearby-refresh' => '我们为您找到一个更准确位置。若要刷新附近的页面列表，请点击此处',
	'mobile-frontend-nearby-error' => '试图找到附近的页面时发生意外错误',
	'mobile-frontend-donate-image-login' => '登录查看您上传的图像', # Fuzzy
	'mobile-frontend-photo-upload-generic' => '捐献一个图片',
	'mobile-frontend-donate-image-title' => '捐献一个图片',
	'mobile-frontend-donate-image-summary' => '照片给{{SITENAME}}上的页面带来了生命。
由于严重缺乏自由版权的照片，而导致很多页面没有图片。
你捐献的图片可以使页面鲜活起来，同时也可以让{{SITENAME}}编辑社群更广泛的使用你的照片。',
	'mobile-frontend-donate-image-heading' => '你最近的贡献',
	'mobile-frontend-donate-image-page-title' => '上传',
	'mobile-frontend-donate-image-anon' => '查看上传页面需要一个[[Special:UserLogin|用户帐号]]',
	'mobile-frontend-listed-image-no-description' => '没有说明',
	'mobile-frontend-donate-photo-upload-success' => '成功！您的图像现在可以在 {{SITENAME}} 上使用！',
	'mobile-frontend-donate-photo-first-upload-success' => '成功！感谢您第一次的贡献！',
	'mobile-frontend-watchlist-add' => '已增加$1到你的监视列表',
	'mobile-frontend-watchlist-removed' => '已从你的监视列表中移除$1',
	'mobile-frontend-watchlist-view' => '查看你的监视列表',
	'mobile-frontend-watchlist-more' => '更多',
	'mobile-frontend-watchlist-cta' => '请登录或注册以监视此页。',
	'mobile-frontend-watchlist-cta-button-login' => '登录',
	'mobile-frontend-watchlist-cta-button-signup' => '注册',
	'mobile-frontend-watchlist-a-z' => '全部',
	'mobile-frontend-watchlist-feed' => '已修改',
	'mobile-frontend-watchlist-a-z-empty' => '您目前没有监视任何页面',
	'mobile-frontend-watchlist-a-z-empty-howto-alt' => '点击页面顶部的星星',
	'mobile-frontend-watchlist-a-z-empty-howto' => '点击页面顶部的星号可将该页面加入监视列表中，以便于及时查看到该条目出现的更改。',
	'mobile-frontend-watchlist-feed-empty' => '没有最近修改的页面',
	'mobile-frontend-watchlist-back-home' => '返回首页',
	'mobile-frontend-changeslist-ip' => '匿名用户',
	'mobile-frontend-changeslist-nocomment' => '无编辑摘要',
	'mobile-frontend-watchlist-filter-all' => '全部',
	'mobile-frontend-watchlist-filter-articles' => '条目',
	'mobile-frontend-watchlist-filter-talk' => '讨论',
	'mobile-frontend-watchlist-filter-other' => '其他',
	'mobile-frontend-watchlist-modified' => '$1前修改',
	'mobile-frontend-diffview-404-title' => '损坏的版本',
	'mobile-frontend-diffview-404-desc' => '您请求的版本ID不存在',
	'mobile-frontend-diffview-title' => '修改',
	'mobile-frontend-diffview-editcount' => '$1次{{PLURAL:$1|编辑|编辑}}',
	'mobile-frontend-diffview-anonymous' => '匿名用户',
	'mobile-frontend-diffview-bytesadded' => '$1字节已增加',
	'mobile-frontend-diffview-bytesremoved' => '$1字节已移除',
	'mobile-frontend-diffview-explained' => '以下行添加（+），并删除（-）：',
	'mobile-frontend-table' => '表$1',
	'mobile-frontend-saving-exit-page' => '正在保存您的贡献。如果离开的话，你的贡献将会丢失。你真的要离开吗？',
	'mobile-frontend-photo-upload' => '为本段添加第一张图像',
	'mobile-frontend-photo-article-edit-comment' => '添加照片以用于页面',
	'mobile-frontend-photo-article-donate-comment' => '从手机捐献图像',
	'mobile-frontend-photo-upload-comment' => '添加照片到页面',
	'mobile-frontend-photo-caption-placeholder' => '为本图像添加说明文字（必需）',
	'mobile-frontend-image-loading' => '正在载入图像',
	'mobile-frontend-image-uploading-wait' => '正在上传图像，请稍候。',
	'mobile-frontend-image-uploading-long' => '图像仍在上传中!感谢您耐心等待。',
	'mobile-frontend-image-uploading-cancel' => '<a href="#">取消</a>，如耗时过长。',
	'mobile-frontend-photo-upload-error' => '上传失败，请重试。',
	'mobile-frontend-photo-upload-success-article' => '完成！您的图像已被添加到页面中。',
	'mobile-frontend-photo-license' => '点击“提交”意味着您同意我们的[//wikimediafoundation.org/wiki/Terms_of_use 使用条款]，并同意在[//en.wikipedia.org/wiki/Wikipedia:Text_of_Creative_Commons_Attribution-ShareAlike_3.0_Unported_License CC BY-SA 3.0协议]下释出您的照片。',
	'mobile-frontend-photo-submit' => '提交',
	'mobile-frontend-photo-cancel' => '取消',
	'mobile-frontend-photo-upload-user-count-over-limit' => '500+上传',
	'tag-mobile_edit' => '手机编辑',
	'tag-mobile_edit-description' => '从网站移动版的编辑',
	'mobile-frontend-drawer-cancel' => '取消',
);

/** Traditional Chinese (中文（繁體）‎)
 * @author Anakmalaysia
 * @author Bencmq
 * @author Lauhenry
 * @author Liangent
 * @author Shirayuki
 * @author Simon Shek
 * @author Waihorace
 * @author Xiaomingyan
 * @author Yfdyh000
 */
$messages['zh-hant'] = array(
	'mobile-frontend-desc' => '手機前端',
	'mobile-frontend-search-submit' => '進入',
	'mobile-frontend-home-button' => '首頁',
	'mobile-frontend-logged-out' => '未登入',
	'mobile-frontend-logged-in-homepage-notification' => '歡迎，$1！',
	'mobile-frontend-logged-in-toast-notification' => '以$1登入。',
	'mobile-frontend-sign-up-heading' => '註冊',
	'mobile-frontend-sign-in-heading' => '登入',
	'mobile-frontend-sign-in-why' => '如果您有一個{{SITENAME}}的用戶，您可以在下面登入。',
	'mobile-frontend-sign-in-error-heading' => '哎呀',
	'mobile-frontend-settings-description' => '調整手機版網頁設定，以定制你的手機瀏覽體驗。',
	'mobile-frontend-settings-beta' => '測試版',
	'mobile-frontend-settings-alpha' => '[//en.wikipedia.org/wiki/Here_be_dragons 妖怪]初版',
	'mobile-frontend-settings-alpha-description' => '進入危險和探索移動領土。更多實驗性的功能，更危險的錯誤。',
	'mobile-frontend-save-settings' => '儲存設定',
	'mobile-frontend-random-button' => '隨機條目',
	'mobile-frontend-ajax-random-heading' => '查找知識...',
	'mobile-frontend-ajax-random-quote' => '智力發展始於出生，止於死亡',
	'mobile-frontend-ajax-random-question' => '閱讀此頁面嗎？',
	'mobile-frontend-ajax-random-yes' => '是',
	'mobile-frontend-ajax-random-retry' => '再試一次',
	'mobile-frontend-ajax-random-suggestions' => '其他建議：',
	'mobile-frontend-back-to-top-of-section' => '跳轉至前一章節',
	'mobile-frontend-close-section' => '關閉本章節',
	'mobile-frontend-show-button' => '顯示',
	'mobile-frontend-hide-button' => '隱藏',
	'mobile-frontend-empty-homepage-text' => '本首頁需要設置。[//meta.wikimedia.org/wiki/Mobile_Projects/Mobile_Gateway#Mobile_homepage Instructions 如何設置本站的手機版]',
	'mobile-frontend-regular-site' => '桌面版',
	'mobile-frontend-wml-continue' => '繼續...',
	'mobile-frontend-wml-back' => '返回...',
	'mobile-frontend-view' => '手機版',
	'mobile-frontend-view-desktop' => '桌面版',
	'mobile-frontend-view-mobile' => '手機版',
	'mobile-frontend-opt-in-explain' => '參加公測後，您將可以訪問實驗性功能，但會遇到不少錯誤和問題。',
	'mobile-frontend-images-status' => '圖片',
	'mobile-frontend-disable-images' => '在手機版網頁上禁用圖像',
	'mobile-frontend-enable-images' => '在手機版網頁上啟用圖像',
	'mobile-frontend-missing-image' => '圖片',
	'mobile-frontend-off' => '關',
	'mobile-frontend-on' => '開',
	'mobile-frontend-footer-contributors-text' => '頁面由和您一樣的[$1 貢獻者]編寫',
	'mobile-frontend-featured-article' => '特色條目',
	'mobile-frontend-news-items' => '新聞動態',
	'mobile-frontend-leave-feedback-notice' => '您的意見將幫助我們改善你的手機版網頁體驗。它們（附有您的用戶名稱、 瀏覽器版本和操作系統）將公開張貼到頁面「$1」。請選擇內容豐富的標題，例如「寬表格格式有問題」。您的反饋遵守我們的使用條款。',
	'mobile-frontend-leave-feedback-warning' => '除非您同意公開發佈您的資料，否則請勿在意見中加入個人資料。',
	'mobile-frontend-leave-feedback-subject' => '主題：',
	'mobile-frontend-leave-feedback-message' => '訊息：',
	'mobile-frontend-leave-feedback-submit' => '提交意見',
	'mobile-frontend-leave-feedback-link-text' => '手機前端擴展意見',
	'mobile-frontend-leave-feedback' => '手機版網站意見',
	'mobile-frontend-leave-feedback-title' => '手機版網頁意見',
	'mobile-frontend-leave-feedback-technical-problem-section-header' => '技術問題',
	'mobile-frontend-leave-feedback-general-section-header' => '一般',
	'mobile-frontend-leave-feedback-article-feedback-section-header' => '條目意見',
	'mobile-frontend-leave-feedback-email-body' => '請在本行上描述你在{{SITENAME}}遇到的問題。請注意我們不能回覆所有接收到的訊息。',
	'mobile-frontend-leave-feedback-technical-link-text' => '技術問題',
	'mobile-frontend-leave-feedback-general-link-text' => '一般意見',
	'mobile-frontend-leave-feedback-article-personal-link-text' => '關於我本人．代表的人或我代表的公司',
	'mobile-frontend-leave-feedback-article-factual-link-text' => '關於事實錯誤',
	'mobile-frontend-leave-feedback-article-other-link-text' => '關於其他問題',
	'mobile-frontend-leave-feedback-form-subject-placeholder' => '信息主題',
	'mobile-frontend-leave-feedback-form-message-placeholder' => '在此輸入您的意見',
	'mobile-frontend-leave-feedback-page-title' => '手機版網頁意見',
	'mobile-frontend-feedback-page' => 'Project:移動版擴展程序反饋',
	'mobile-frontend-leave-feedback-special-title' => '聯繫我們',
	'mobile-frontend-feedback-no-subject' => '（沒有主題）',
	'mobile-frontend-feedback-no-subject-field' => '請輸入主題',
	'mobile-frontend-feedback-no-message' => '請在此輸入訊息。',
	'mobile-frontend-feedback-edit-summary' => '$1 - 使用[[Special:MobileFeedback|手機意見工具]]自動發佈',
	'mobile-frontend-leave-feedback-thanks' => '謝謝您的意見！',
	'mobile-frontend-leave-feedback-post-error' => '在處理的過程中出錯。請稍後再試。',
	'mobile-frontend-language' => '語言:',
	'mobile-frontend-language-article-heading' => '閱讀其他語言',
	'mobile-frontend-language-header' => '本頁有$1種語言版本',
	'mobile-frontend-language-variant-header' => '選擇{{#language:{{CONTENTLANG}}}}轉換版本',
	'mobile-frontend-language-footer' => '注意：此條目可能未在您所選的語言提供。您可以按此瀏覽其它語言的{{SITENAME}}。',
	'mobile-frontend-language-site-choose' => '搜尋語言',
	'mobile-frontend-username' => '用戶名：',
	'mobile-frontend-password' => '密碼：',
	'mobile-frontend-username-placeholder' => '用戶名',
	'mobile-frontend-password-placeholder' => '密碼',
	'mobile-frontend-login' => '登入',
	'mobile-frontend-last-modified-date' => '最後修訂於$1$2',
	'mobile-frontend-last-modified-seconds' => '最後修訂於$1秒前',
	'mobile-frontend-last-modified-minutes' => '最後修訂於$1分鐘前',
	'mobile-frontend-last-modified-hours' => '最後修訂於$1小時前',
	'mobile-frontend-last-modified-days' => '最後修訂於$1天前',
	'mobile-frontend-last-modified-months' => '最後修訂於$1小時前',
	'mobile-frontend-last-modified-years' => '最後修訂於$1年前',
	'mobile-frontend-account-create-submit' => '註冊',
	'mobile-frontend-password-confirm-placeholder' => '確認密碼',
	'mobile-frontend-account-create-email-placeholder' => '電郵地址（可選）',
	'mobile-frontend-account-create-captcha-placeholder' => '輸入驗證碼',
	'mobile-frontend-overlay-escape' => '返回',
	'mobile-frontend-placeholder' => '搜索{{SITENAME}}',
	'mobile-frontend-placeholder-beta' => '搜尋{{SITENAME}}（測試版）',
	'mobile-frontend-placeholder-alpha' => '搜尋{{SITENAME}}（初版）',
	'mobile-frontend-search-help' => '在上面輸入搜尋字詞，匹配的頁面標題便會在此顯示。',
	'mobile-frontend-dismiss-notification' => '關閉此通知',
	'mobile-frontend-clear-search' => '清除',
	'mobile-frontend-privacy-link-text' => '隱私',
	'mobile-frontend-about-link-text' => '關於',
	'mobile-frontend-footer-sitename' => '{{SITENAME}}',
	'mobile-frontend-footer-license-text' => '內容在[//zh.m.wikipedia.org/wiki/Wikipedia:CC-BY-SA-3.0协议文本?useformat=mobile CC BY-SA 3.0]協議下提供',
	'mobile-frontend-terms-use-text' => '[//wikimediafoundation.org/wiki/Terms_of_use?useformat=mobile 使用條款]',
	'mobile-frontend-footer-contact' => '聯繫',
	'mobile-frontend-search-noresults' => '沒有頁面標題匹配您的搜尋字詞。更改您的搜索，或按鍵盤搜尋鍵進行全文搜索。',
	'mobile-frontend-main-menu-button-tooltip' => '開啟主目錄',
	'mobile-frontend-main-menu-page-title' => '網站導航',
	'mobile-frontend-main-menu-featured' => '特色',
	'mobile-frontend-main-menu-nearby' => '附近',
	'mobile-frontend-main-menu-login' => '登入',
	'mobile-frontend-main-menu-logout' => '登出',
	'mobile-frontend-main-menu-watchlist' => '監視列表',
	'mobile-frontend-main-menu-settings' => '設定',
	'mobile-frontend-main-menu-upload' => '上傳',
	'mobile-frontend-main-menu-settings-heading' => '手機版網頁設定',
	'mobile-frontend-settings-site-header' => '{{SITENAME}}的語言版本',
	'mobile-frontend-settings-site-description' => '{{SITENAME}}有$1種語言版本。下面列出所有版本',
	'mobile-frontend-main-menu-contact' => '聯繫',
	'mobile-frontend-main-menu-account-create' => '建立帳號',
	'mobile-frontend-page-menu-contents' => '目錄',
	'mobile-frontend-page-menu-history' => '歷史',
	'mobile-frontend-meta-data-issues-header' => '問題',
	'mobile-frontend-meta-data-issues' => '此頁上的一些問題',
	'mobile-frontend-ajax-page-loading' => '正在載入$1',
	'mobile-frontend-page-saving' => '正在保存$1',
	'mobile-frontend-ajax-page-error' => '哎呀！出錯了。請嘗試重新載入你的瀏覽器視窗。',
	'mobile-frontend-nearby-title' => '附近',
	'mobile-frontend-nearby-loading' => '載入您當前的位置附近的主題',
	'mobile-frontend-nearby-requirements' => '此頁需要 JavaScript 和瀏覽器位置定位的功能。',
	'mobile-frontend-nearby-distance-report' => '離您目前所在位置$1公里',
	'mobile-frontend-nearby-lookup-error' => '無法找到您。再試一次...',
	'mobile-frontend-nearby-noresults' => '你目前在的地方尚未有任何相關主題。為何不寫一個？',
	'mobile-frontend-nearby-refresh' => '我們為您找到更準確的位置定位。點擊這裡刷新附近頁面列表',
	'mobile-frontend-nearby-error' => '試圖尋找附近頁面時出現錯誤',
	'mobile-frontend-donate-image-login' => '您必須登入以查看您的上傳。',
	'mobile-frontend-photo-upload-generic' => '捐出圖片',
	'mobile-frontend-donate-image-title' => '捐出圖片',
	'mobile-frontend-donate-image-summary' => '照片為{{SITENAME}}頁面添加色彩。
因沒有自由版權的照片，很多頁面都是沒有照片的。
捐贈您的照片，使這些頁更精彩。亦讓{{SITENAME}}編輯社群使用您的照片。',
	'mobile-frontend-donate-image-heading' => '您最近的貢獻',
	'mobile-frontend-donate-image-page-title' => '上傳',
	'mobile-frontend-donate-image-anon' => '必須先註冊成[[Special:UserLogin|用戶]]，才能查看上傳頁面',
	'mobile-frontend-listed-image-no-description' => '沒有說明',
	'mobile-frontend-donate-photo-upload-success' => '成功！您的圖像現在可以在{{SITENAME}} 上使用！',
	'mobile-frontend-donate-photo-first-upload-success' => '成功！感謝您第一次的貢獻！',
	'mobile-frontend-watchlist-add' => '已添加$1到您的監視列表',
	'mobile-frontend-watchlist-removed' => '已從您的監視列表移除$1',
	'mobile-frontend-watchlist-view' => '查看您的監視列表',
	'mobile-frontend-watchlist-more' => '更多',
	'mobile-frontend-watchlist-cta' => '請登入或註冊以監視此頁。',
	'mobile-frontend-watchlist-cta-button-login' => '登入',
	'mobile-frontend-watchlist-cta-button-signup' => '註冊',
	'mobile-frontend-watch-login' => '您必須登入以查看監視頁面。',
	'mobile-frontend-watchlist-a-z' => '所有',
	'mobile-frontend-watchlist-feed' => '曾修改',
	'mobile-frontend-watchlist-a-z-empty' => '目前沒有在監視任何頁面',
	'mobile-frontend-watchlist-a-z-empty-howto-alt' => '按位於頁頂的星號',
	'mobile-frontend-watchlist-a-z-empty-howto' => '按位於頁頂的星號把頁面加到監視列表，讓您關注這些頁面和讓你知道它們有更新。',
	'mobile-frontend-watchlist-feed-empty' => '頁面最近沒有修改',
	'mobile-frontend-watchlist-back-home' => '返回首頁',
	'mobile-frontend-changeslist-ip' => '匿名用戶',
	'mobile-frontend-changeslist-nocomment' => '沒有編輯摘要',
	'mobile-frontend-watchlist-filter-all' => '全部',
	'mobile-frontend-watchlist-filter-articles' => '條目',
	'mobile-frontend-watchlist-filter-talk' => '討論',
	'mobile-frontend-watchlist-filter-other' => '其他',
	'mobile-frontend-watchlist-modified' => '$1前修改',
	'mobile-frontend-diffview-404-title' => '損壞的版本',
	'mobile-frontend-diffview-404-desc' => '版本ID不存在',
	'mobile-frontend-diffview-title' => '修改',
	'mobile-frontend-diffview-editcount' => '$1次編輯',
	'mobile-frontend-diffview-anonymous' => '匿名用戶',
	'mobile-frontend-diffview-bytesadded' => '已增加$1位元組',
	'mobile-frontend-diffview-bytesremoved' => '已移除$1位元組',
	'mobile-frontend-diffview-explained' => '以下行被添加（+）和刪除（-）：',
	'mobile-frontend-table' => '表$1',
	'mobile-frontend-saving-exit-page' => '正在保存您的貢獻。如果離開的話，你的貢獻將會丟失。你真的要離開嗎？',
	'mobile-frontend-photo-upload' => '為本頁添加圖像',
	'mobile-frontend-photo-article-edit-comment' => '已在頁面上添加照片',
	'mobile-frontend-photo-article-donate-comment' => '捐贈來自手機的相片',
	'mobile-frontend-photo-upload-comment' => '已添加照片到頁面上',
	'mobile-frontend-photo-caption-placeholder' => '添加描述 （必填）',
	'mobile-frontend-image-loading' => '正在載入圖片',
	'mobile-frontend-image-uploading-wait' => '正在上傳圖片，請稍候。',
	'mobile-frontend-image-uploading-long' => '圖像仍在上傳中！感謝您耐心等候。',
	'mobile-frontend-image-uploading-cancel' => '若耗時過長，可<a href="#">取消</a>。',
	'mobile-frontend-photo-upload-error' => '上傳錯誤，請重試。',
	'mobile-frontend-photo-upload-success-article' => '完成！您的圖像已被添加到頁面中。',
	'mobile-frontend-photo-license' => '點擊「提交」表示您同意[//wikimediafoundation.org/wiki/Terms_of_use 使用條款]，並同意依據[//creativecommons.org/licenses/by-sa/3.0/ CC BY-SA 3.0協議]授權您的照片。',
	'mobile-frontend-photo-submit' => '提交',
	'mobile-frontend-photo-cancel' => '取消',
	'mobile-frontend-photo-upload-user-count' => '{{PLURAL:$1|<span>1</span>個上載|<span>$1</span>個上載}}',
	'mobile-frontend-photo-upload-user-count-over-limit' => '500+上載',
	'tag-mobile_edit' => '手機編輯',
	'tag-mobile_edit-description' => '從手機版所作的編輯',
	'mobile-frontend-drawer-cancel' => '取消',
);

/** Chinese (Hong Kong) (‪中文(香港)‬)
 * @author Liangent
 * @author Waihorace
 */
$messages['zh-hk'] = array(
	'mobile-frontend-search-submit' => '進入',
	'mobile-frontend-featured-article' => '特色條目',
	'mobile-frontend-home-button' => '首頁',
	'mobile-frontend-random-button' => '隨機條目',
	'mobile-frontend-show-button' => '顯示',
	'mobile-frontend-hide-button' => '隱藏',
	'mobile-frontend-regular-site' => '在原版維基百科瀏覽此頁',
	'mobile-frontend-view' => '流動瀏覽',
	'mobile-frontend-disable-images' => '在流動版停用圖像',
);
