( function( M, $ ) {

var toggle = ( function() {

	var u = M.utils,
		message = M.message,
		showLabel = message( 'mobile-frontend-show-button' ),
		hideLabel = message( 'mobile-frontend-hide-button' );

	function wm_toggle_section( section_id ) {
		var b = document.getElementById( 'section_' + section_id ), id,
			hash, d,
			bb = b.getElementsByTagName( 'button' )[0], i, e, closed, reset = [];
		if( u( b ).hasClass( 'openSection' ) ) {
			u( b ).removeClass( 'openSection' );
			u( bb ).text( showLabel );
			closed = true;
		} else {
			reset.push( b );
			u( b ).addClass( 'openSection' );
			u( bb ).text( hideLabel );
		}
		for ( i = 0, d = ['content_','anchor_']; i<=1; i++ ) {
			e = document.getElementById( d[i] + section_id );
			if ( e && u( e ).hasClass( 'openSection' ) ) {
				u( e ).removeClass( 'openSection' );
			} else if( e ) {
				reset.push( e );
				u( e ).addClass( 'openSection' );
			}
		}
		// NOTE: # means top of page so using a dummy hash #_ to prevent page jump
		id = 'section_' + section_id;
		hash = closed ? '#_' : '#' + id;
		if ( hash !== '#section_nav' ) {
			M.history.replaceHash( hash );
		}
	}

	function wm_reveal_for_hash( hash ) {
		var targetel = document.getElementById( hash.substr(1) ),
			p, section_idx;
		if ( targetel ) {
			p = targetel;
			while ( p && !u(p).hasClass( 'content_block' ) &&
				!u(p).hasClass( 'section_heading' ) ) {
				p = p.parentNode;
			}
			if ( p && ! u( p ).hasClass( 'openSection' ) ) {
				section_idx = p.id.split( '_' )[1];
				wm_toggle_section( section_idx );
			}
		}
	}

	function init() {
		u( document.documentElement ).addClass( 'togglingEnabled' );
		var i, a, heading, h2,
			sectionHeadings = [], content;

		content = document.getElementById( 'content_wrapper' );
		h2 = document.getElementsByTagName( 'H2' );

		for( i = 0; i < h2.length; i++) {
			heading = h2[i];
			if( u( heading ).hasClass( 'section_heading') ) {
				sectionHeadings.push( heading );
			}
		}

		function openSectionHandler() {
			var sectionName = this.id ? this.id.split( '_' )[1] : -1;
			if( sectionName !== -1 ) {
				wm_toggle_section( sectionName );
			}
		}
		function createButton() {
			var btn = document.createElement( 'button' );
			u( btn ).text( showLabel );
			return btn;
		}

		for( i = 0; i < sectionHeadings.length; i++ ) {
			heading = sectionHeadings[i];
			heading.insertBefore( createButton(), heading.firstChild );
			$( '#anchor_' + heading.id.split( '_' )[ 1 ] ).remove();
			u( heading ).bind( 'mousedown', openSectionHandler );
		}
		
		function checkHash() {
			var hash = window.location.hash;
			if ( hash.indexOf( '#' ) === 0 ) {
				wm_reveal_for_hash( hash );
			}
			if( hash ) {
				M.history.replaceHash( '#_' ); // clear existing hash for case of jump to top
				M.history.replaceHash( hash );
			}
		}
		checkHash();
		for ( a = content.getElementsByTagName( 'a' ), i = 0; i < a.length; i++ ) {
			u( a[i] ).bind( 'click', checkHash );
		}
	}

	return {
		wm_reveal_for_hash: wm_reveal_for_hash,
		wm_toggle_section: wm_toggle_section,
		init: init
	};

}());

M.define( 'toggle', toggle );

}( mw.mobileFrontend, jQuery ) );
