class HomePage
  include PageObject

  def self.url
    if ENV['MEDIAWIKI_URL']
      base_url = ENV['MEDIAWIKI_URL']
    else
      base_url = 'http://127.0.0.1:80/wiki/'
    end
      "#{base_url}Main_Page"
  end

  page_url url

  a(:mainmenu_button, id: 'mw-mf-main-menu-button')
  a(:login_button, class: 'external login')
  a(:login, text: 'Login')
  a(:search_result, class: 'search-result-item')
  text_field(:search_box, id: 'mw-mf-search')
  div(:menupage, id: 'mw-mf-menu-page')
  a(:watch_link, class: 'watch-this-article')
  a(:watched_link, class: 'watch-this-article watched')
  div(:watch_note, text: 'Added San Francisco Chronicle to your watchlist')
  div(:watch_note_removed, text: 'Removed San Francisco Chronicle from your watchlist')
  button(:openfooter_button, class:   'openSection')
  span(:mobile_select, text: 'Mobile')
  a(:contrib_link, text: 'contributors')
  a(:content_link, text: 'CC BY-SA 3.0')
  a(:terms_link, text: 'Terms of Use')
  a(:privacy_link, text: 'Privacy')
  a(:about_link, text: 'About')
  a(:disclaimer_link, text: 'Disclaimers')
  form(:search_form, id: 'mw-mf-searchForm')
  a(:sign_up, text: 'Sign up')
  div(:main_page, id: 'mainpage')
end
