<?php

/**
 * @group MobileFrontend
 */
class MFResourceLoaderModuleTest extends MediaWikiTestCase {
	private $modules = array(
		array(
			'messages' => array( 'foo', 'bar' ),
		),
		array(
			'messages' => array(
				'foo',
				'mobile-frontend-photo-license' => array( 'parse' ),
			),
		),
		array(
			'messages' => array(
				'foo',
				'mobile-frontend-photo-license' => array( 'unknown' ),
			),
		),

		'templateModule' => array(
			'templates' => array(
				'template', 'template2',
			)
		),

		'dependenciesModule' => array(
			'dependencies' => array( 'dependency1', 'dependency2' )
		)
	);
	// providers
	public function providerGetMessages() {
		return array(
			array(
				$this->modules[0],
				array( 'foo', 'bar' ),
			),
			array(
				$this->modules[1],
				array( 'foo' ),
			),
			array(
				$this->modules[2],
				array( 'foo' ),
			),
		);
	}

	public function providerAddParsedMessages() {
		$msg = wfMessage( 'mobile-frontend-photo-license' )->parse();
		$expected = "\n" . Xml::encodeJsCall( 'mw.messages.set',
			array( 'mobile-frontend-photo-license', $msg ) );

		return array(
			// test case 1
			array(
				$this->modules[0],
				// expected value
				"\n"
			),
			// test case 2
			array(
				$this->modules[1],
				// expected value 2
				$expected
			),
			// test case 3
			array(
				$this->modules[2],
				// expected value 2
				"\n"
			),
		);
	}

	public function providerGetTemplateNames() {
		return array(
			array(
				$this->modules[0], array(),
			),
			array(
				$this->modules['templateModule'], array( 'template', 'template2' ),
			)
		);
	}

	public function providerGetTemplateScript() {
		$module = $this->modules['templateModule'];
		$module['localTemplateBasePath'] = dirname( __FILE__ ) . '/../templates';
		return array(
			array(
				$this->modules[0], ''
			),
			array(
				$module,
				'mw.mobileFrontend.template.add("template", "hello\n");' . "\n" .
				'mw.mobileFrontend.template.add("template2", "goodbye\n");' . "\n"
			)
		);
	}

	// tests

	/**
	 * @dataProvider providerAddParsedMessages
	 */
	public function testAddParsedMessages( $module, $expectedJavascript ) {
		$rl = new MFResourceLoaderModule( $module );
		$js = $rl->addParsedMessages();

		$this->assertEquals( $js, $expectedJavascript );
	}

	/**
	 * @dataProvider providerGetMessages
	 */
	public function testGetMessages( $module, $expectedMessages ) {
		$rl = new MFResourceLoaderModule( $module );
		$msgs = $rl->getMessages();

		$this->assertEquals( $msgs, $expectedMessages );
	}

	/**
	 * @dataProvider providerGetTemplateNames
	 */
	public function testGetTemplateNames( $module, $expected ) {
		$rl = new MFResourceLoaderModule( $module );
		$names = $rl->getTemplateNames();

		$this->assertEquals( $names, $expected );
	}

	/**
	 * @dataProvider providerGetTemplateScript
	 */
	public function testGetTemplateScript( $module, $expected ) {
		$rl = new MFResourceLoaderModule( $module );
		$js = $rl->getTemplateScript();

		$this->assertEquals( $js, $expected );
	}

	public function testGetDependencies() {
		$rlModule = new MFResourceLoaderModule( $this->modules['dependenciesModule'] );
		$dependencies = $rlModule->getDependencies();

		$this->assertContains( 'dependency1', $dependencies );
		$this->assertContains( 'dependency2', $dependencies );
		$this->assertContains( 'mobile.startup', $dependencies );
	}
}
