<?php
/**
 * Internationalisation for Vector extension
 *
 * @file
 * @ingroup Extensions
 */

$messages = array();

/** English
 * @author Trevor Parscal
 */
$messages['en'] = array(
	'vector' => 'UI improvements for Vector',
	'vector-desc' => 'Enhances the user interface when using the Vector skin',
	'vector-collapsiblenav-preference' => 'Enable collapsing of items in the sidebar in Vector skin',
	'vector-collapsiblenav-more' => 'More languages',
	'vector-editwarning-warning' => 'Leaving this page may cause you to lose any changes you have made.
If you are logged in, you can disable this warning in the "Editing" section of your preferences.',
	'vector-editwarning-preference' => 'Warn me when I leave an edit page with unsaved changes',
	'vector-simplesearch-search' => 'Search',
	'vector-simplesearch-containing' => 'containing...',
	'vector-noexperiments-preference' => 'Exclude me from feature experiments',
	'vector-footercleanup-transclusion' => 'This page contains {{PLURAL:$1|transclusion|transclusions}} of {{PLURAL:$1|one other page|$1 other pages}}.',
	'vector-footercleanup-templates' => 'View templates on this page',
	'vector-footercleanup-categories' => 'View hidden categories on this page',
);

/** Message documentation (Message documentation)
 * @author Fryed-peach
 * @author Lloffiwr
 * @author Nemo bis
 * @author Srtxg
 * @author Umherirrender
 */
$messages['qqq'] = array(
	'vector' => 'UI means User Interface. Vector is the name of an interface skin.',
	'vector-desc' => '{{desc}}',
	'vector-collapsiblenav-preference' => 'The message refers to the sidebar, whose sections are collapsible in Vector skin (some of them collapsed by default and some no); the preference disables collapsing entirely and is among "Advanced options" in the "Appearence" section.',
	'vector-editwarning-warning' => "{{doc-important|Do ''not'' use <nowiki>{{int:prefs-editing}}</nowiki> for \"Editing\". It is forbidden in this message, see [[mwr:68405]].}}

but you can see the text of that button here: {{msg-mw|Prefs-editing}}",
	'vector-simplesearch-search' => 'Greyed out default text in the simple search box in the Vector skin. (It disappears and lets the user enter the requested search terms when the search box receives focus.)

{{Identical|Search}}',
	'vector-simplesearch-containing' => 'Label used in the special item of the search suggestions list which gives the user an option to perform a full text search for the term.',
	'vector-noexperiments-preference' => 'An option in [[Special:Preferences]]',
	'vector-footercleanup-transclusion' => 'Label used in the footer while editing to display the count of how many transclusions a page contains.',
);

/** Turoyo (Ṫuroyo)
 * @author Ariyo
 */
$messages['tru'] = array(
	'vector-simplesearch-search' => 'Kruxyo',
);

/** Achinese (Acèh)
 * @author Si Gam Acèh
 */
$messages['ace'] = array(
	'vector-simplesearch-search' => 'Mita',
);

/** Afrikaans (Afrikaans)
 * @author Adriaan
 * @author Naudefj
 * @author පසිඳු කාවින්ද
 */
$messages['af'] = array(
	'vector' => 'Gebruikerskoppelvlak-verbeteringe vir Vektor',
	'vector-desc' => 'Verbeter die gebruikerskoppelvlak-elemente van die Vektor omslag (skin).',
	'vector-collapsiblenav-preference' => 'Inklapbare navigasiespyskaart by die gebruik van Vector toelaat',
	'vector-collapsiblenav-more' => 'Meer tale',
	'vector-editwarning-warning' => 'As u hierdie bladsy verlaat, verloor u moontlik die wysigings wat u aangebring het.
Indien u aangemeld is, kan u hierdie waarskuwing in die {{int:prefs-editing}}"-afdeling van u voorkeure afskakel.',
	'vector-editwarning-preference' => "Waarsku my as ek 'n gewysigde bladsy verlaat alvorens dit gestoor is",
	'vector-simplesearch-search' => 'Soek',
	'vector-simplesearch-containing' => 'bevat...',
	'vector-noexperiments-preference' => 'Verban my uit funksie eksperimente',
);

/** Gheg Albanian (Gegë)
 * @author Mdupont
 */
$messages['aln'] = array(
	'vector' => 'përmirësime UI për Vektor',
	'vector-desc' => 'Në elementet përmirëson ndërfaqen e përdoruesit të lëkurës Vektor.',
	'vector-collapsiblenav-preference' => 'Aktivizo paloset la navigacion menu',
	'vector-editwarning-warning' => 'Duke e lënë këtë faqe mund të bëjë që ju të humbni ndonjë ndryshim që keni bërë. Nëse ju jeni regjistruar, ju mund ta çaktivizoni këtë paralajmërim në "Tue redaktue" seksionin e preferencave tuaja.',
	'vector-editwarning-preference' => 'Paralajmëron mua kur unë të lë një redakto faqe me ndryshimet e para shpëtimit',
	'vector-simplesearch-search' => 'Kërkim',
	'vector-simplesearch-containing' => 'përmban ...',
);

/** Amharic (አማርኛ)
 * @author Codex Sinaiticus
 */
$messages['am'] = array(
	'vector-simplesearch-search' => 'ፈልግ',
	'vector-simplesearch-containing' => 'በመጣጥፎች ይዘት ለመፈልግ...',
);

/** Aragonese (aragonés)
 * @author Juanpabl
 */
$messages['an'] = array(
	'vector' => "Milloras d'a interficie ta Vector",
	'vector-desc' => "Milloras en os elementos d'interficie d'usuario de l'aparencia Vector.",
	'vector-collapsiblenav-preference' => "Activar a opción de plegar os menús de navegación en l'aparencia Vector",
	'vector-collapsiblenav-more' => 'Más luengas',
	'vector-editwarning-warning' => "Si sale d'ista pachina perderá totz os cambios que haiga feito. Si tiene una cuenta d'usuario, puet eliminar ista alvertencia en a sección «Caixa d'edición» d'as suyas preferencies.",
	'vector-editwarning-preference' => "Alvertir-me quan salga d'una pachina d'edición sin alzar os cambios",
	'vector-simplesearch-search' => 'Mirar',
	'vector-simplesearch-containing' => 'que contién...',
	'vector-noexperiments-preference' => "Excluir-me d'as caracteristicas experimentals",
);

/** Arabic (العربية)
 * @author Aiman titi
 * @author Alexknight12
 * @author DRIHEM
 * @author Meno25
 * @author OsamaK
 */
$messages['ar'] = array(
	'vector' => 'تحسينات واجهة المستخدم لفكتور',
	'vector-desc' => 'تحسينات في عناصر واجهة المستخدم لواجهة فكتور.',
	'vector-collapsiblenav-preference' => 'مكّن طي العناصر في قائمة التصفح في واجهة فكتور',
	'vector-collapsiblenav-more' => 'لغات أخرى',
	'vector-editwarning-warning' => 'قد تتسبب مغادرة هذه الصفحة بخسارتك لأي تغييرات قمت بها.
يمكنك تعطيل هذا التحذير إذا كنت والجلًا في قسم "التحرير" في تفضيلاتك.',
	'vector-editwarning-preference' => 'حذّرني عندما أغادر تحرير صفحة ذات تغييرات غير محفوظة',
	'vector-simplesearch-search' => 'بحث',
	'vector-simplesearch-containing' => 'يحتوي...',
	'vector-noexperiments-preference' => 'استبعدني من تجارب الخاصية',
	'vector-footercleanup-transclusion' => 'هذه الصفحة تحتوي على {{PLURAL:$1تضمين|تضمينات}} لـ {{PLURAL:$1|صفحة واحدة أخرى|$1 صفحات أخرى}}.',
);

/** Aramaic (ܐܪܡܝܐ)
 * @author Basharh
 */
$messages['arc'] = array(
	'vector-editwarning-warning' => 'ܐܢ ܫܒܩ ܐܢܬ ܦܐܬܐ ܗܕܐ ܡܬܡܨܝܢܬܐ ܐܝܬܝܗ ܕܚܣܪ ܐܢܬ ܟܠ ܫܘܚܠܦ̈ܐ ܕܥܒܝܕ ܐܢܬ ܗܪܟܐ.
ܡܨܐ ܐܢܬ ܕܬܒܛܠ ܙܘܗܪܐ ܗܢܐ ܐܢ ܥܠܝܠܐ ܐܝܬܝܟ ܒܡܢܬܐ ܕ"ܫܚܠܦܬܐ" ܒܨܒܝܢܝܘܬ̈ܐ.',
	'vector-editwarning-preference' => 'ܙܗܪ ܠܝ ܐܡܬܝ ܫܒܩ ܐܢܐ ܦܐܬܐ ܕܫܘܚܠܦܐ ܕܐܝܬ ܒܗ ܫܘܚܠܦ̈ܐ ܠܐ ܠܒܝܟ̈ܐ',
	'vector-simplesearch-search' => 'ܒܨܝ',
	'vector-simplesearch-containing' => 'ܬܚܒܘܫ...',
	'vector-footercleanup-templates' => 'ܚܙܝ ܩܠܒ̈ܐ ܒܦܐܬܐ ܗܕܐ',
	'vector-footercleanup-categories' => 'ܚܙܝ ܣܕܪ̈ܐ ܛܘܫܝ̈ܐ ܒܦܐܬܐ ܗܕܐ',
);

/** Egyptian Spoken Arabic (مصرى)
 * @author Dudi
 * @author Meno25
 */
$messages['arz'] = array(
	'vector' => 'تحسينات واجهه المستخدم لفكتور',
	'vector-desc' => 'تحسينات فى عناصر واجهه المستخدم لواجهه فكتور.',
	'vector-collapsiblenav-preference' => 'خلّى الليستات بتاعة مينيو الاستكشاف تبان مقفوله فى Vector skin',
	'vector-collapsiblenav-more' => 'لغات اكتر',
	'vector-editwarning-warning' => 'لو سيبت الصفحه دى ممكن يخلّيك تضيّع اى تغييرات عملتها.
لو انت مسجّل دخولك, ممكن تعطّل التحذير ده من الجزء بتاع "تعديل" فى تفضيلاتك.',
	'vector-editwarning-preference' => 'حذّرنى لما اسيب صفحة تعديل فيها تغييرات مش متسييڤه',
	'vector-simplesearch-search' => 'تدوير',
	'vector-simplesearch-containing' => 'جوّاه...',
);

/** Assamese (অসমীয়া)
 * @author Bishnu Saikia
 * @author Gitartha.bordoloi
 */
$messages['as'] = array(
	'vector' => 'ভেক্টৰৰ বাবে ব্যৱহাৰকাৰী যোগাযোগৰ উন্নতি সাধন',
	'vector-desc' => "ভেক্টৰ আৱৰণৰ ব্যৱহাৰকাৰী ইণ্টাৰফে'চ উপাদানৰ উন্নতি সাধন।",
	'vector-collapsiblenav-preference' => 'ভেক্টৰ আৱৰণত ভাঁজযুক্ত নেভিগছন মেনু সক্ৰিয় কৰক',
	'vector-collapsiblenav-more' => 'অধিক ভাষা',
	'vector-editwarning-warning' => 'এই পৃষ্ঠাটো এৰিলে আপুনি কৰা পৰিবৰ্তনসমূহ হেৰাব পাৰে। যদি আপুনি প্ৰৱেশ কৰা অৱস্থাত আছে, আপুনি এই সতৰ্কবাৰ্তাক আপোনাৰ পছন্দসমূহৰ "সম্পাদনা" অংশত অসামৰ্থবান কৰিব পাৰিব।',
	'vector-editwarning-preference' => 'সালসলনি সংৰক্ষণ নকৰাকৈ সম্পাদনা পৃষ্ঠা ত্যাগৰ সময়ত মোক সাৱধান কৰক',
	'vector-simplesearch-search' => 'সন্ধান কৰক',
	'vector-simplesearch-containing' => 'যি আছে...',
	'vector-noexperiments-preference' => 'ভৱিষ্যতৰ পৰীক্ষাবোৰৰ পৰা মোক ৰেহাই দিয়ক',
	'vector-footercleanup-transclusion' => 'এই পৃষ্ঠাটোৱে {{PLURAL:$1|অন্য এটা পৃষ্ঠাৰ|$1 অন্য পৃষ্ঠাসমূহৰ}} {{PLURAL:$1|বেষ্টন|বেষ্টনসমূহ}} অন্তৰ্ভুক্ত কৰে।',
);

/** Asturian (asturianu)
 * @author Xuacu
 */
$messages['ast'] = array(
	'vector' => "Meyores de la interfaz d'usuariu pa Vector",
	'vector-desc' => "Ameyora la interfaz d'usuariu al usar l'aspeutu Vector.",
	'vector-collapsiblenav-preference' => 'Activar anubrir elementos nel panel llateral del aspeutu Vector',
	'vector-collapsiblenav-more' => 'Más llingües',
	'vector-editwarning-warning' => 'Salir d\'esta páxina pue facer que se pierda cualesquier cambiu fechu.
Si aniciasti sesión, puedes desactivar esti avisu na seición "Edición" de les tos preferencies.',
	'vector-editwarning-preference' => "Avisame cuando salga d'una páxina d'edición con cambios ensin guardar",
	'vector-simplesearch-search' => 'Guetar',
	'vector-simplesearch-containing' => 'que contién...',
	'vector-noexperiments-preference' => 'Escluíme de carauterístiques esperimentales',
	'vector-footercleanup-transclusion' => "Esta páxina contién {{PLURAL:$1|una tresclusión|tresclusiones}} {{PLURAL:$1|d'otra páxina|d'otres $1 páxines}}.",
	'vector-footercleanup-templates' => "Ver los modelos d'esta páxina",
	'vector-footercleanup-categories' => "Ver les categoríes anubríes d'esta páxina",
);

/** Azerbaijani (azərbaycanca)
 * @author PPerviz
 * @author Vugar 1981
 */
$messages['az'] = array(
	'vector-collapsiblenav-more' => 'Çoxlu dillər',
	'vector-simplesearch-search' => 'Axtar',
);

/** Bashkir (башҡортса)
 * @author Assele
 */
$messages['ba'] = array(
	'vector' => '"Векторлы" күренешен яҡшыртыуҙар',
	'vector-desc' => '"Векторлы" күренешенең ҡулланыусы интерфейсында яҡшыртыуҙар.',
	'vector-collapsiblenav-preference' => '"Векторлы" күренешендә һул яҡ менюла блоктарҙы төрөргә рөхсәт итергә',
	'vector-collapsiblenav-more' => 'Күберәк телдәр',
	'vector-editwarning-warning' => 'Икенсе биткә күсеү һеҙ индергән үҙгәрештәрҙең юғалыуына килтереүе мөмкин.
Әгәр системала танылыу үтһәгеҙ, көйләүҙәрегеҙ битенең "Мөхәррирләү" бүлегендә был киҫәтеүҙе һүндерә алаһығыҙ.',
	'vector-editwarning-preference' => 'Мөхәррирләү битенән үҙгәртеүҙәрҙе һаҡламайынса сыҡҡан ваҡытта мине киҫәтергә',
	'vector-simplesearch-search' => 'Эҙләү',
	'vector-simplesearch-containing' => 'эстәлегендә...',
	'vector-noexperiments-preference' => 'Һынау өсөн мөмкинлектәр тәҡдим итмәҫкә',
);

/** Bavarian (Boarisch)
 * @author Mucalexx
 * @author ✓
 */
$messages['bar'] = array(
	'vector' => "Vabesserrungen fyr d' Vector-Benutzerowerflächen",
	'vector-desc' => 'Vabesserrungen an da Vektor-Benutzerowerflächen',
	'vector-collapsiblenav-preference' => 'Zåmmkloppm vo Elemente im Navigazionsmenü vo da Benutzerowerflächen Vector aktivirn',
	'vector-collapsiblenav-more' => 'Weiderne Sproochen',
	'vector-editwarning-warning' => "'s Valossen vo derer Seiten kå dodazua fyrn, daas d' Änderrungen valurn geengan.
Ois ågmödter Benutzer kå's Åzoang vo derer Warnung im \"Beorweiten\"-Bereich vo de Eistellungen obgschoiden wern.",
	'vector-editwarning-preference' => ' A Warung geem, sofern a zur da Beorweitung geffnate Seiten valossen werd, de ned gspeicherde Änderrungen enthoit.',
	'vector-simplesearch-search' => 'Suach',
	'vector-simplesearch-containing' => 'Voitextsuach noch ...',
	'vector-noexperiments-preference' => 'Ned an Funkzions-Experimenten teilnemmer',
);

/** Belarusian (беларуская)
 * @author Maksim L.
 */
$messages['be'] = array(
	'vector' => 'Паляпшае інтэрфэйс для кажуха Vector',
	'vector-desc' => 'Паляпшае элементы інтэрфэйсу ўдзельніка для кажуха Vector',
	'vector-collapsiblenav-preference' => 'Уключыць згортванне блокаў у навігацыйным меню для кажуха Vector',
	'vector-collapsiblenav-more' => 'Болей моваў',
	'vector-editwarning-warning' => 'Выхад з гэтай старонкі прывядзе да страты правак, якія вы зрабілі. 
Калі Вы зарэгістраваныя ў сістэме, Вы можаце адключыць гэта папярэджанне ў закладцы "Праца" Вашых настаўленняў.',
	'vector-editwarning-preference' => 'Папярэдзіць мяне, калі я пакідаю старонку з незахаванымі праўкамі',
	'vector-simplesearch-search' => 'Знайсці',
	'vector-simplesearch-containing' => 'змяшчае...',
);

/** Belarusian (Taraškievica orthography) (беларуская (тарашкевіца)‎)
 * @author EugeneZelenko
 * @author Jim-by
 * @author Wizardist
 * @author Zedlik
 */
$messages['be-tarask'] = array(
	'vector' => 'Паляпшэньні інтэрфэйсу для афармленьня «Вэктар»',
	'vector-desc' => 'Паляпшае элемэнты інтэрфэйсу карыстальніка для афармленьня «Вэктар»',
	'vector-collapsiblenav-preference' => 'Дазволіць згортваньне блёкаў у навігацыйным мэню для афармленьня «Вэктар»',
	'vector-collapsiblenav-more' => 'Болей моваў',
	'vector-editwarning-warning' => 'Усе зробленыя Вамі зьмены могуць быць страчаныя, калі Вы пакінеце гэтую старонку.
Калі Вы ўвайшлі ў сыстэму, Вы можаце адключыць гэтае папярэджаньне у сэкцыі «Рэдагаваньне» Вашых наладаў.',
	'vector-editwarning-preference' => 'Папярэджваць мяне, калі я буду пакідаць старонку рэдагаваньня зь незахаванымі зьменамі',
	'vector-simplesearch-search' => 'Пошук',
	'vector-simplesearch-containing' => 'утрымлівае...',
	'vector-noexperiments-preference' => 'Не прапаноўваць экспэрымэнтальныя магчымасьці',
	'vector-footercleanup-transclusion' => 'Гэтая старонка ўключае {{PLURAL:$1|адну іншую старонку|$1 іншыя старонкі|$1 іншых старонак}}.',
	'vector-footercleanup-templates' => 'Паказаць шаблёны на гэтай старонцы',
	'vector-footercleanup-categories' => 'Паказаць схаваныя катэгорыі да гэтай старонкі',
);

/** Bulgarian (български)
 * @author DCLXVI
 * @author Spiritia
 * @author Turin
 */
$messages['bg'] = array(
	'vector' => 'Подобрения на потребителския интерфейс за облик Вектор',
	'vector-desc' => 'Подобрява елементите от потребителския интерфейс на облик Вектор.',
	'vector-collapsiblenav-preference' => 'Включване на сгъваемо/разгъваемо меню за навигация в облика Vector',
	'vector-collapsiblenav-more' => 'Още езици',
	'vector-editwarning-warning' => 'Ако излезете от тази страница, може да загубите всички незапазени промени, които сте направили. 
Ако сте влезли в системата, можете да изключите това предупреждение през меню "Редактиране" във вашите лични настройки.',
	'vector-editwarning-preference' => 'Предупреждаване при опит за напускане на страница, отворена в режим на редактиране, без да са запазени промените',
	'vector-simplesearch-search' => 'Търсене',
	'vector-noexperiments-preference' => 'Не желая да участвам в бъдещи експерименти',
);

/** Banjar (Bahasa Banjar)
 * @author Ezagren
 */
$messages['bjn'] = array(
	'vector-collapsiblenav-more' => 'Labih banyak bahasa',
	'vector-editwarning-preference' => 'Ingatakan ulun pabila maninggalakan tungkaran pambabakan sabalum manyimpan parubahan',
	'vector-simplesearch-search' => 'Gagai',
	'vector-simplesearch-containing' => 'isian ...',
);

/** Bengali (বাংলা)
 * @author Bellayet
 * @author Nasir8891
 * @author Wikitanvir
 */
$messages['bn'] = array(
	'vector' => 'ভেক্টরের জন্য ব্যবহারকারী ইন্টারফেসের উন্নতি সাধন',
	'vector-desc' => 'ভেক্টর স্কিনের ইন্টারফেস উপাদানের উন্নতি সাধন',
	'vector-collapsiblenav-preference' => 'ভেক্টর স্কিনে ভাঁজযোগ্য নেভিগেশন মেনু সক্রিয় করো',
	'vector-collapsiblenav-more' => 'আরও ভাষা',
	'vector-editwarning-warning' => 'এই পাতাটি ত্যাগ করলে আপনার আপনার করা পরিবর্তনগুলো হারিয়ে যেতে পারে।
আপনি যদি লগইন করা থাকেন, আপনি এই সতর্কীকরণ বার্তাটি আপনার পছন্দের "সমপাদনা" অনুচ্ছেদ থেকে নিস্ক্রিয় করতে পারেন।',
	'vector-editwarning-preference' => 'অসংরক্ষিত পরিবর্তন সহ কোনো পাতা ত্যাগের সময় সাবধান করো',
	'vector-simplesearch-search' => 'অনুসন্ধান',
	'vector-simplesearch-containing' => 'যা আছে...',
	'vector-noexperiments-preference' => 'বৈশিষ্ট পরীক্ষার তালিকা থেকে আমাকে বাদ দেয়া হোক',
);

/** Bishnupria Manipuri (বিষ্ণুপ্রিয়া মণিপুরী)
 * @author Usingha
 */
$messages['bpy'] = array(
	'vector' => 'ভেক্টরর কা আতাকুরার ইন্টারফেসহার উন্নতি করানিহান',
	'vector-desc' => 'ভেক্টর স্কিনর ইন্টারফেস মাথেলর উন্নতি করানি।',
	'vector-collapsiblenav-preference' => 'ভেক্টর স্কিনহানার থিপকরানি একরব নেভিগেশন মেনু থা কর',
	'vector-collapsiblenav-more' => 'আরাকউ ঠার',
	'vector-editwarning-warning' => 'পাতা এহান বেলিয়া গেলেগা তি সিলকরিসত অতা মাঙুইতে পারে।
তি লগইন করিসতগ ইলে, এরে সিঙকরানির পৌ এহান তর "পতানি" থাকেত্ত আরুম করানি পারর।',
	'vector-editwarning-preference' => 'পতানির সময় ইতু নাকরিয়া বেলিয়া গেলেগা মরে সিঙকরেদিস',
	'vector-simplesearch-search' => 'বিসারা',
	'vector-simplesearch-containing' => 'আসেতা...',
);

/** Breton (brezhoneg)
 * @author Fulup
 * @author Y-M D
 */
$messages['br'] = array(
	'vector' => 'Gwellaennoù IU evit Vector',
	'vector-desc' => 'Gwellaat a ra elfennoù eus ar gwiskadur Vector war an etrefas implijer.',
	'vector-collapsiblenav-preference' => 'Aotren al lañser merdeiñ pak-dispak a-gleiz gant an neuz Vector',
	'vector-collapsiblenav-more' => "Muioc'h a yezhoù",
	'vector-editwarning-warning' => "Mar kuitait ar bajenn-mañ e c'hallit koll ar c'hemmoù degaset ganeoc'h.
Ma'z oc'h kevreet e c'hallit diweredekaat ar c'hemenn-diwall-mañ e rann \"Prenestr skridaozañ\" ho penndibaboù.",
	'vector-editwarning-preference' => 'Kas keloù din pa guitaan ur bajenn degaset kemmoù enni hep enrollañ',
	'vector-simplesearch-search' => 'Klask',
	'vector-simplesearch-containing' => 'ennañ...',
	'vector-noexperiments-preference' => "Lezit-me er-maez eus al labour amprouiñ an arc'hwelioù nevez",
	'vector-footercleanup-templates' => 'Gwelet patromoù ar bajenn-mañ',
	'vector-footercleanup-categories' => 'Gwelet ar rummadoù kuzhet evit ar pennad-mañ',
);

/** Bosnian (bosanski)
 * @author CERminator
 */
$messages['bs'] = array(
	'vector' => 'UI poboljšanja za Vector',
	'vector-desc' => 'Poboljšava elemente korisničkog interfejsa u koži Vector.',
	'vector-collapsiblenav-preference' => 'Omogući skrivanje stavki u navigacionom meniju u koži Vector',
	'vector-collapsiblenav-more' => 'Više jezika',
	'vector-editwarning-warning' => 'Napuštanje ove stranice može dovesti do gubitka svih promjena koje ste načinili.
Ako ste prijavljeni, možete isključiti ovo upozorenje u "Veličine tekstualnog polja" dijelu vaših opcija.',
	'vector-editwarning-preference' => 'Upozori me kada napustim stranicu za izmjene bez spašenih promjena',
	'vector-simplesearch-search' => 'Traži',
	'vector-simplesearch-containing' => 'sadrži...',
	'vector-noexperiments-preference' => 'Isključi me iz funkcijskih probi',
);

/** Catalan (català)
 * @author Grondin
 * @author Paucabot
 * @author SMP
 * @author Vriullop
 */
$messages['ca'] = array(
	'vector' => 'Millores de la interfície per a Vector',
	'vector-desc' => "Millores en els elements d'interfície d'usuari de l'aparença Vector.",
	'vector-collapsiblenav-preference' => "Activa l'opció de plegar els menús de navegació en l'aparença Vector",
	'vector-collapsiblenav-more' => 'Més llengües',
	'vector-editwarning-warning' => "Si sortiu d'aquesta pàgina perdreu tots els canvis que hàgiu fet.
Si teniu un compte d'usuari, podeu eliminar aquest avís a la secció «Caixa d'edició» de les vostres preferències.",
	'vector-editwarning-preference' => "Avisa'm quan surti d'una pàgina d'edició amb canvis sense desar",
	'vector-simplesearch-search' => 'Cerca',
	'vector-simplesearch-containing' => 'que conté ...',
	'vector-noexperiments-preference' => 'Exclou-me dels experiments de funcionalitats',
	'vector-footercleanup-transclusion' => "Aquesta pàgina conté {{PLURAL:$1|una transclusió d'una altra pàgina|unes transclusions de $1 altres pàgines}}.",
);

/** Chechen (нохчийн)
 * @author Sasan700
 */
$messages['ce'] = array(
	'vector-simplesearch-search' => 'Лаха',
);

/** Sorani Kurdish (کوردی)
 * @author Asoxor
 * @author Marmzok
 */
$messages['ckb'] = array(
	'vector-collapsiblenav-preference' => 'ڕێگە بدە بە کرانەوەی بڕگەکانی پێرستی ڕێدۆزی لە بەرگی ڤێکتۆردا.',
	'vector-collapsiblenav-more' => 'زمانەکانی دیکە',
	'vector-editwarning-warning' => 'بەجێ‌هێشتنی ئەم لاپەڕەیە دەبێتە هۆی لە‌دەست چوونی هەموو ئەو گۆڕانکاریانەی کردووتە.
ئەگەر لەژوورەوەی، دەتوانی ئەم ئاگادارییە لە بەشی "دەستکاریی" لە ھەڵبژاردەکانی، لەکاربخەی.',
	'vector-editwarning-preference' => 'ھۆشیارم بکەوە کاتێک لە پەڕەیەکی دەستکاری بە گۆڕانکاریی پاشەکەوت‌نەکراو دەردەچم',
	'vector-simplesearch-search' => 'گەڕان',
	'vector-simplesearch-containing' => 'بە لەبەرگرتنەوەی ...',
);

/** Crimean Turkish (Latin script) (qırımtatarca (Latin)‎)
 * @author Don Alessandro
 */
$messages['crh-latn'] = array(
	'vector-simplesearch-search' => 'Qıdır',
	'vector-simplesearch-containing' => 'içinde bu olğan...',
);

/** Crimean Turkish (Cyrillic script) (къырымтатарджа (Кирилл)‎)
 * @author Don Alessandro
 */
$messages['crh-cyrl'] = array(
	'vector-simplesearch-search' => 'Къыдыр',
	'vector-simplesearch-containing' => 'ичинде бу олгъан...',
);

/** Czech (česky)
 * @author Mormegil
 */
$messages['cs'] = array(
	'vector' => 'Vylepšení uživatelského rozhraní pro Vektor',
	'vector-desc' => 'Vylepšuje uživatelské rozhraní při užití vzhledu Vektor',
	'vector-collapsiblenav-preference' => 'Povolit sbalování položek v navigačním menu ve vzhledu Vektor',
	'vector-collapsiblenav-more' => 'Další jazyky',
	'vector-editwarning-warning' => 'Opuštěním této stránky se mohou veškeré provedené změny ztratit.
Pokud jste přihlášeni, můžete si toto varování vypnout na záložce „Editace“ v uživatelském nastavení.',
	'vector-editwarning-preference' => 'Upozornit, když budu opouštět editaci bez uložení změn',
	'vector-simplesearch-search' => 'Hledat',
	'vector-simplesearch-containing' => 'obsahující…',
	'vector-noexperiments-preference' => 'Neúčastnit se experimentů s novými funkcemi',
	'vector-footercleanup-transclusion' => 'Do této stránky {{PLURAL:$1|je vložena $1 jiná stránka|jsou vloženy $1 jiné stránky|je vloženo $1 jiných stránek}}.',
	'vector-footercleanup-templates' => 'Zobrazit šablony na této stránce',
	'vector-footercleanup-categories' => 'Zobrazit skryté kategorie na této stránce',
);

/** Kashubian (kaszëbsczi)
 * @author Kuvaly
 */
$messages['csb'] = array(
	'vector-simplesearch-search' => 'Szëkba',
);

/** Church Slavic (словѣ́ньскъ / ⰔⰎⰑⰂⰡⰐⰠⰔⰍⰟ)
 * @author ОйЛ
 */
$messages['cu'] = array(
	'vector-collapsiblenav-more' => 'дроуꙃи ѩꙁꙑци',
	'vector-simplesearch-search' => 'исканиѥ',
	'vector-simplesearch-containing' => 'сѥ дрьжащи···',
);

/** Chuvash (Чӑвашла)
 * @author FLAGELLVM DEI
 */
$messages['cv'] = array(
	'vector-simplesearch-search' => 'Шырав',
);

/** Welsh (Cymraeg)
 * @author Lloffiwr
 */
$messages['cy'] = array(
	'vector' => "Gwelliannau i'r rhyngwyneb ar gyfer Vector",
	'vector-desc' => 'Yn gwella ar y rhyngwyneb yn y wedd Vector.',
	'vector-collapsiblenav-preference' => "Galluogi crebachu'r ddewislen lywio yn y wedd Vector",
	'vector-collapsiblenav-more' => 'Rhagor o ieithoedd',
	'vector-editwarning-warning' => 'Os y gadewch y dudalen hon mae\'n bosib y collwch eich newidiadau iddi.
Gallwch ddiddymu\'r rhybudd hwn yn yr adran "Golygu" yn eich dewisiadau.',
	'vector-editwarning-preference' => "Tynnwch fy sylw pan wyf ar fin gadael tudalen olygu heb roi'r newidiadau ar gadw",
	'vector-simplesearch-search' => 'Chwilio',
	'vector-simplesearch-containing' => 'yn cynnwys...',
	'vector-noexperiments-preference' => "Peidio â'm cynnwys mewn arbrofion ar y nodweddion",
	'vector-footercleanup-transclusion' => "Mae'r dudalen hon yn cynnwys {{PLURAL:$1||tudalen|$1 dudalen|$1 tudalen|$1 thudalen|$1 tudalen}} sydd wedi cael {{PLURAL:$1||ei thrawsgynnwys|eu trawsgynnwys}}.",
);

/** Danish (dansk)
 * @author Froztbyte
 * @author Peter Alberti
 * @author Sarrus
 * @author Sir48
 */
$messages['da'] = array(
	'vector' => 'Forbedringer af brugerfladen til Vector',
	'vector-desc' => 'Forbedrer brugerfladen, når Vector-udseendet er i brug.',
	'vector-collapsiblenav-preference' => 'Aktiver sammenklapning af sidemenuen i Vector-udseendet',
	'vector-collapsiblenav-more' => 'Flere sprog',
	'vector-editwarning-warning' => 'Hvis du forlader siden nu, risikerer du at miste alle ændringer som du har lavet.
Denne advarsel kan slås fra under Redigering i dine indstillinger.',
	'vector-editwarning-preference' => 'Advar mig, hvis jeg forlader en redigeringsside med ændringer, der ikke er gemt.',
	'vector-simplesearch-search' => 'Søg',
	'vector-simplesearch-containing' => 'indeholder...',
	'vector-noexperiments-preference' => 'Udeluk mig fra funktionseksperimenter',
	'vector-footercleanup-transclusion' => 'Denne side indeholder {{PLURAL:$1|en transklusion|transklusioner}} af {{PLURAL:$1|én anden side|$1 andre sider}}.',
	'vector-footercleanup-templates' => 'Vis skabeloner på denne side',
	'vector-footercleanup-categories' => 'Vis skjulte kategorier på denne side',
);

/** German (Deutsch)
 * @author Church of emacs
 * @author Kghbln
 * @author SVG
 * @author The Evil IP address
 * @author Tischbeinahe
 * @author ✓
 */
$messages['de'] = array(
	'vector' => 'Verbesserungen für die Benutzeroberfläche „Vector“',
	'vector-desc' => 'Ermöglicht zusätzliche Verbesserungen der Benutzeroberfläche „Vector“',
	'vector-collapsiblenav-preference' => 'Zusammenklappen von Elementen im Navigationsmenü der Benutzeroberfläche Vector aktivieren',
	'vector-collapsiblenav-more' => 'Weitere Sprachen',
	'vector-editwarning-warning' => 'Das Verlassen dieser Seite kann dazu führen, dass die Änderungen verloren gehen.
Als angemeldeter Benutzer kann das Anzeigen dieser Warnung im „Bearbeiten“-Bereich der Einstellungen abgeschaltet werden.',
	'vector-editwarning-preference' => 'Warnen, sofern eine zur Bearbeitung geöffnete Seite verlassen wird, die nicht gespeicherte Änderungen enthält',
	'vector-simplesearch-search' => 'Suche',
	'vector-simplesearch-containing' => 'Volltextsuche nach …',
	'vector-noexperiments-preference' => 'Nicht an Funktionsexperimenten teilnehmen',
	'vector-footercleanup-transclusion' => 'In diese Seite {{PLURAL:$1|wurde eine Seite|wurden $1 Seiten}} eingebunden.',
	'vector-footercleanup-templates' => 'Vorlagen auf dieser Seite anzeigen',
	'vector-footercleanup-categories' => 'Versteckte Kategorien auf dieser Seite anzeigen',
);

/** German (formal address) (Deutsch (Sie-Form)‎) */
$messages['de-formal'] = array(
	'vector-editwarning-warning' => 'Das Verlassen dieser Seite kann dazu führen, dass Ihre Änderungen verloren gehen.
Wenn Sie angemeldet sind, können Sie das Anzeigen dieser Warnung im „Bearbeiten“-Bereich Ihrer Einstellungen abschalten.',
);

/** Zazaki (Zazaki)
 * @author Erdemaslancan
 * @author Mirzali
 * @author Xoser
 */
$messages['diq'] = array(
	'vector' => 'Ser vectori UI hacetanê hewli',
	'vector-desc' => 'Yeweniya asayışa vektori da rıasayışe karberi keno weş.',
	'vector-collapsiblenav-preference' => 'Eyarê qic kerdisê ke hecatan menuyê navigasyon ke Vector de inan a bike',
	'vector-collapsiblenav-more' => 'Ziwananê binan',
	'vector-editwarning-warning' => 'ihtimal o ke wexta şıma peli ra bıveci, vurnayiş o ke şıma kerdo, hewna şiyêro .
eke şıma kewtê hesabê xo, no hişyari tercihanê xo ra şıma eşkeni "Ho vurnayeno" bıvındarnî .',
	'vector-editwarning-preference' => 'wexta ke ez pelo nêqeydbiyaye ra veciyaya mı hişyar bıker',
	'vector-simplesearch-search' => 'Cı geyre',
	'vector-simplesearch-containing' => 'Estên...',
	'vector-noexperiments-preference' => 'Mı tewrê cerbnayışan dê bahdoyêna meke',
	'vector-footercleanup-transclusion' => 'Zerrey ena pela {{PLURAL:$1|vıraştışen|Vıraştışeni}} sera {{PLURAL:$1|pelaya bin|$1 zewbi pelaya}}.',
	'vector-footercleanup-templates' => 'Şablonanê ena perer bıvinê',
	'vector-footercleanup-categories' => 'Nımıte kategoriyanê ena perer bıvinê',
);

/** Lower Sorbian (dolnoserbski)
 * @author Michawiki
 */
$messages['dsb'] = array(
	'vector' => 'Pólěpšenja wužywarskego pówjercha za Vector',
	'vector-desc' => '!Pólěpša wužywarski pówjerch za drastwu Vector.',
	'vector-collapsiblenav-preference' => 'Złožowanje zapiskow w bocnicy w drastwje Vector zmóžniś',
	'vector-collapsiblenav-more' => 'Dalšne rěcy',
	'vector-editwarning-warning' => 'Gaž toś ten bok se spušća, mógu se změny zgubiś, kótarež sy pśewjadł. Jolic sy pśizjawjeny, móžoš toś to warnowanje we wótrězku Wobźěłaś swójich nastajenjow znjemóžniś.',
	'vector-editwarning-preference' => 'Warnowaś, gaž bok spušća se z njeskłaźonymi změnami',
	'vector-simplesearch-search' => 'Pytaś',
	'vector-simplesearch-containing' => 'wopśimujo...',
	'vector-noexperiments-preference' => 'Mě z funkciskich eksperimentow wuzamknuś',
	'vector-footercleanup-transclusion' => 'Toś ten bok wopśimujo {{PLURAL:$1|transkluziju|transkluziji|transkluzije|transkluzije}} $1 {{PLURAL:$1|drugego boka|drugeju bokowu|drugich bokow|drugich bokow}}.',
	'vector-footercleanup-templates' => 'Pśedłogi na toś tom boku zwobrazniś',
	'vector-footercleanup-categories' => 'Schowane kategorije na toś tom boku pokazaś',
);

/** Greek (Ελληνικά)
 * @author Dead3y3
 * @author Geraki
 * @author Glavkos
 * @author Απεργός
 */
$messages['el'] = array(
	'vector' => 'βελτιώσεις στο UI για το Vector',
	'vector-desc' => 'Παρέχει βελτίωση στα στοιχεία διεπαφής χρήστη του skin Vector.',
	'vector-collapsiblenav-preference' => 'Ενεργοποίηση πτυσσόμενων ενοτήτων στο μενού πλοήγησης με το θέμα Vector',
	'vector-collapsiblenav-more' => 'Περισσότερες γλώσσες',
	'vector-editwarning-warning' => 'Αφήνοντας αυτή τη σελίδα μπορεί να σας κάνει να χάσετε κάποιες αλλαγές που έχετε κάνει.
Αν έχετε συνδεθεί, μπορείτε να απενεργοποιήσετε αυτή την προειδοποίηση στο τμήμα "Επεξεργασία" των προτιμήσεών σας.',
	'vector-editwarning-preference' => 'Προειδοποίηση όταν εγκαταλείπω μία σελίδα επεξεργασίας χωρίς να έχω πρώτα αποθηκεύσει τις αλλαγές',
	'vector-simplesearch-search' => 'Αναζήτηση',
	'vector-simplesearch-containing' => 'περιέχει...',
	'vector-noexperiments-preference' => 'Εξαιρέστε με από την λειτουργία πειραμάτων',
);

/** Esperanto (Esperanto)
 * @author AVRS
 * @author Maximillion Pegasus
 * @author Yekrats
 */
$messages['eo'] = array(
	'vector' => 'Plibonigado de grafika interfaco por Vector',
	'vector-desc' => 'Plibonigas la elementojn de la uzula interfaco de la Vector-etoso.',
	'vector-collapsiblenav-preference' => 'Ŝalti kaŝebladon de aĵoj en la dekstra navigmenuo kun etoso Vector',
	'vector-collapsiblenav-more' => 'Pli lingvoj',
	'vector-editwarning-warning' => 'Forlasante ĉi tiun paĝon kaŭzos al vi perdi iun ajn ŝanĝojn kiujn vi faris.
Se vi ensalutas, vi povas malŝalti ĉi tiun averton en la sekcio "Grandeco de redakta tekstujo" de viaj preferoj.',
	'vector-editwarning-preference' => 'Averti min kiam mi forlasas redaktan paĝon kun nekonservitaj ŝanĝoj',
	'vector-simplesearch-search' => 'Serĉi',
	'vector-simplesearch-containing' => 'enhavas...',
	'vector-noexperiments-preference' => 'Ekskluzivu min de estontecaj testoj',
	'vector-footercleanup-transclusion' => 'Ĉi tiu paĝo enhavas {{PLURAL:$1|transinkluzivaĵon|transinkluzivaĵojn}} de {{PLURAL:$1|unu alia paĝo|$1 aliaj paĝoj}}.',
);

/** Spanish (español)
 * @author Armando-Martin
 * @author Crazymadlover
 * @author Drini
 * @author Fitoschido
 * @author Locos epraix
 * @author Translationista
 */
$messages['es'] = array(
	'vector' => 'Mejoras de interfaz de usuario para Vector',
	'vector-desc' => 'Mejora la interfaz de usuario cuando se utiliza Vector como aspecto',
	'vector-collapsiblenav-preference' => 'Activar menús plegables en la barra lateral de la piel Vector',
	'vector-collapsiblenav-more' => 'Más idiomas',
	'vector-editwarning-warning' => 'El dejar esta página causará la pérdida de cualquier cambio que hayas realizado.
Si has iniciado sesión, puedes desactivar este aviso en la sección «Edición» en tus preferencias.',
	'vector-editwarning-preference' => 'Advertirme cuando abandone una página editada con cambios sin grabar',
	'vector-simplesearch-search' => 'Buscar',
	'vector-simplesearch-containing' => 'conteniendo...',
	'vector-noexperiments-preference' => 'Excluirme de características experimentales',
	'vector-footercleanup-transclusion' => 'Esta página contiene {{PLURAL:$1|una transclusión|transclusiones}} {{PLURAL:$1|de otra página|de otras $1 páginas}}.',
	'vector-footercleanup-templates' => 'Ver las plantillas de esta página',
	'vector-footercleanup-categories' => 'Ver las categorías ocultas de esta página',
);

/** Estonian (eesti)
 * @author Pikne
 */
$messages['et'] = array(
	'vector' => 'Vector-kujunduse kasutajaliidese täiustused',
	'vector-desc' => 'Täiustab Vectori-kujunduse kasutajaliidest.',
	'vector-collapsiblenav-preference' => 'Luba Vektori-kujundusega navigeerimismenüü üksusi peita',
	'vector-collapsiblenav-more' => 'Veel keeli',
	'vector-editwarning-warning' => 'Sellelt leheküljelt lahkumise tõttu võivad tehtud muudatused kaotsi minna.
Kui oled sisse loginud, saad selle hoiatuse eelistuste alaosas "Toimetamine" keelata.',
	'vector-editwarning-preference' => 'Hoiata mind, kui lahkun redigeerimisleheküljelt muudatusi salvestamata',
	'vector-simplesearch-search' => 'Otsi',
	'vector-simplesearch-containing' => 'sisalduv...',
	'vector-noexperiments-preference' => 'Jäta mind funktsioonide katsetamisest kõrvale',
	'vector-footercleanup-transclusion' => 'Sellel leheküljel kasutatakse mallina {{PLURAL:$1|üht|$1}} teist lehekülge.',
	'vector-footercleanup-templates' => 'Näita malle, mida leheküljel kasutatakse',
	'vector-footercleanup-categories' => 'Näita peidetud kategooriaid, millesse lehekülg kuulub',
);

/** Basque (euskara)
 * @author An13sa
 */
$messages['eu'] = array(
	'vector' => 'EI hobekuntzak Vector-entzat',
	'vector-desc' => 'Vector skin-eko lankidearen interfazeko elementuak hobetzen ditu.',
	'vector-collapsiblenav-preference' => 'Vector skin-ean ezkerreko nabigazio menua irekigarri bihurtzen du',
	'vector-collapsiblenav-more' => 'Hizkuntza gehiago',
	'vector-editwarning-warning' => 'Orrialde honetatik irteten bazara, egindako aldaketak galdu egingo dira.
Saioa hasi baduzu, mezu hau kendu dezakezu zure hobespenen orrialdeko "Aldatzen" atalean.',
	'vector-editwarning-preference' => 'Abisa nazazu gorde gabeko aldaketak eginez orrialde bat uzten dudanean',
	'vector-simplesearch-search' => 'Bilatu',
	'vector-simplesearch-containing' => 'edukian...',
);

/** Persian (فارسی)
 * @author Ebraminio
 * @author Huji
 * @author Ladsgroup
 * @author Sahim
 * @author ZxxZxxZ
 */
$messages['fa'] = array(
	'vector' => 'بهبودهای رابط کاربر برای پوستهٔ برداری',
	'vector-desc' => 'بهبود در عناصر رابط کاربری از طریق پوسته وکتور',
	'vector-collapsiblenav-preference' => 'فعال‌کردن منوی تاشوی ناوبری در پوسته وکتور',
	'vector-collapsiblenav-more' => 'زبان‌های بیشتر',
	'vector-editwarning-warning' => 'خروج از این صفحه ممکن است باعث از دست رفتن هرچه نوشته‌اید شود.
اگر شما با نام کاربری وارد شده‌اید می‌توانید این هشدار را در بخش «در حال ویرایش» ترجیحاتتان بیابید.',
	'vector-editwarning-preference' => 'زمان خروج از صفحهٔ ویرایش در صورت داشتن ویرایش‌های‌ ذخیره‌نشده به من هشدار داده شود',
	'vector-simplesearch-search' => 'جستجو',
	'vector-simplesearch-containing' => 'صفحه‌های دربردارنده...',
	'vector-noexperiments-preference' => 'من را از ویژگی‌های آزمایشی مستثنی کن',
	'vector-footercleanup-transclusion' => 'این صفحه شامل {{PLURAL:$1|تراگنجانش|تراگنجانش‌های}} {{PLURAL:$1|صفحه‌ای دیگر است|$1 صفحهٔ دیگر است}}.',
);

/** Finnish (suomi)
 * @author Crt
 * @author Nike
 * @author Olli
 * @author Str4nd
 */
$messages['fi'] = array(
	'vector' => 'Käyttöliittymän parannukset Vectorille',
	'vector-desc' => 'Parantaa käyttöliittymää Vector-ulkoasua käytettäessä.',
	'vector-collapsiblenav-preference' => 'Ota käyttöön sivupalkin kohteiden piilottaminen Vector-ulkoasussa',
	'vector-collapsiblenav-more' => 'Muilla kielillä',
	'vector-editwarning-warning' => 'Tältä sivulta poistuminen saattaa aiheuttaa kaikkien tekemiesi muutosten katoamisen.
Jos olet kirjautuneena sisään, voit poistaa tämän varoituksen käytöstä asetuksissa ”Muokkaus”-osiossa.',
	'vector-editwarning-preference' => 'Varoita minua, kun poistun muokkaussivulta tallentamatta muutoksia',
	'vector-simplesearch-search' => 'Hae',
	'vector-simplesearch-containing' => 'sisältää...',
	'vector-noexperiments-preference' => 'Älä ota minua mukaan ominaisuuskokeiluihin',
	'vector-footercleanup-templates' => 'Näytä mallineet tällä sivulla',
	'vector-footercleanup-categories' => 'Näytä piilotetut luokat tällä sivulla',
);

/** Faroese (føroyskt)
 * @author Diupwijk
 */
$messages['fo'] = array(
	'vector-simplesearch-search' => 'Leita',
);

/** French (français)
 * @author Gomoko
 * @author IAlex
 * @author Jean-Frédéric
 * @author McDutchie
 * @author PieRRoMaN
 * @author Sherbrooke
 * @author Urhixidur
 */
$messages['fr'] = array(
	'vector' => 'Améliorations IU pour Vector',
	'vector-desc' => "Améliore l’interface utilisateur lors de l'utilisation de l'habillage Vecteur",
	'vector-collapsiblenav-preference' => "Activer le menu de navigation à gauche repliable avec l'habillage vector",
	'vector-collapsiblenav-more' => 'Plus de langues',
	'vector-editwarning-warning' => 'Quitter cette page vous fera perdre toutes les modifications que vous avez faites.
Si vous êtes connecté avec votre compte, vous pouvez retirer cet avertissement dans la section « Fenêtre de modification » de vos préférences.',
	'vector-editwarning-preference' => 'M’avertir quand je quitte une page de modification sans publier les changements',
	'vector-simplesearch-search' => 'Rechercher',
	'vector-simplesearch-containing' => 'contenant...',
	'vector-noexperiments-preference' => "M'exclure des expériences de nouvelles fonctionnalités",
	'vector-footercleanup-transclusion' => 'Cette page contient {{PLURAL:$1|une traduction|des traductions}} de $1 {{PLURAL:$1|autre page|autres pages}}.',
	'vector-footercleanup-templates' => 'Afficher les modèles sur cette page',
	'vector-footercleanup-categories' => 'Afficher les catégories cachées sur cette page',
);

/** Franco-Provençal (arpetan)
 * @author ChrisPtDe
 */
$messages['frp'] = array(
	'vector' => 'Mèlyoracions EU por « Vèctor »',
	'vector-desc' => 'Mèlyoracions des èlèments de l’entèrface usanciér de l’habelyâjo « Vèctor ».',
	'vector-collapsiblenav-preference' => 'Activar lo menu de navigacion repleyâblo avouéc l’habelyâjo « Vèctor »',
	'vector-collapsiblenav-more' => 'Més de lengoues',
	'vector-editwarning-warning' => 'Quitar ceta pâge vos farat pèrdre tôs los changements que vos éd fêts.
Se vos éte branchiê, vos pouede enlevar ceti avèrtissement dens la sèccion « Fenétra d’èdicion » de voutres prèferences.',
	'vector-editwarning-preference' => 'M’avèrtir quand quito una pâge de changement sen sôvar los changements',
	'vector-simplesearch-search' => 'Rechèrchiér',
	'vector-simplesearch-containing' => 'que contint...',
	'vector-noexperiments-preference' => 'M’èxcllure des èxpèriences de novèles fonccionalitâts',
);

/** Friulian (furlan)
 * @author Klenje
 */
$messages['fur'] = array(
	'vector-collapsiblenav-more' => 'Altris lenghis',
	'vector-editwarning-preference' => 'Visimi cuant che o stoi par lassâ une pagjine dulà che a son cambiaments no salvâts',
	'vector-simplesearch-search' => 'Ricercje',
	'vector-simplesearch-containing' => 'che al à dentri...',
);

/** Irish (Gaeilge)
 * @author පසිඳු කාවින්ද
 */
$messages['ga'] = array(
	'vector-simplesearch-search' => 'Cuardaigh',
);

/** Simplified Gan script (赣语（简体）‎) */
$messages['gan-hans'] = array(
	'vector-simplesearch-search' => '寻吖',
);

/** Traditional Gan script (贛語（繁體）‎)
 * @author Symane
 */
$messages['gan-hant'] = array(
	'vector-simplesearch-search' => '尋吖',
);

/** Scottish Gaelic (Gàidhlig)
 * @author Akerbeltz
 */
$messages['gd'] = array(
	'vector' => 'Leasachaidhean an UI airson Vector',
	'vector-desc' => 'Cuiridh seo piseach air eileamaidean eadar-aghaidh nan cleachdaichean san chraiceann Vector.',
	'vector-collapsiblenav-preference' => 'Cuir an comas dùmhlachadh nan rudan san chlàr-taice seòlaidh san chraiceann Vector',
	'vector-collapsiblenav-more' => 'Barrachd chànan',
	'vector-editwarning-warning' => 'Ma dh\'fhàgas tu an duilleag seo, faodaidh gun caill thu mùthadh sam bith a rinn thu.
Ma tha thu air logadh a-steach, \'s urrainn dhut an rabhadh seo a chur dheth san roinn "Deasachadh" sna roghainnean agad.',
	'vector-editwarning-preference' => 'Thoir rabhadh dhomh ma bhios mi an impis duilleag deasachaidh fhàgail mus do shàbhail mi na mùthaidhean agam',
	'vector-simplesearch-search' => 'Lorg',
	'vector-simplesearch-containing' => 'anns a bheil...',
);

/** Galician (galego)
 * @author Toliño
 */
$messages['gl'] = array(
	'vector' => 'Melloras na interface de usuario para a aparencia Vector',
	'vector-desc' => 'Mellora a interface de usuario ao usar a aparencia Vector',
	'vector-collapsiblenav-preference' => 'Activar o menú de navegación despregable á esquerda na aparencia Vector',
	'vector-collapsiblenav-more' => 'Máis linguas',
	'vector-editwarning-warning' => 'Deixar esta páxina pode causar a perda de calquera cambio feito.
Se accedeu ao sistema, pode desactivar esta mensaxe de advertencia na sección "Edición" das súas preferencias.',
	'vector-editwarning-preference' => 'Avisádeme cando deixe unha páxina de edición cos cambios sen gardar',
	'vector-simplesearch-search' => 'Procurar',
	'vector-simplesearch-containing' => 'que conteña...',
	'vector-noexperiments-preference' => 'Excluídeme das novas características',
	'vector-footercleanup-transclusion' => 'Esta páxina contén {{PLURAL:$1|unha transclusión|transclusións}} {{PLURAL:$1|doutra páxina|doutras $1 páxinas}}.',
	'vector-footercleanup-templates' => 'Ver os modelos desta páxina',
	'vector-footercleanup-categories' => 'Ver as categorías ocultas desta páxina',
);

/** Ancient Greek (Ἀρχαία ἑλληνικὴ) */
$messages['grc'] = array(
	'vector-simplesearch-search' => 'Ζητεῖν',
	'vector-simplesearch-containing' => 'περιέχον...',
);

/** Swiss German (Alemannisch)
 * @author Als-Holder
 */
$messages['gsw'] = array(
	'vector' => 'BI-Verbesserige fir Vektor',
	'vector-desc' => 'Verbesserige an dr Elemänt vu dr Benutzeroberflechi bim Vector-skin',
	'vector-collapsiblenav-preference' => 'Yyklappbar Navgationsmenü yyschalte bi dr Verwändig vu Vector',
	'vector-collapsiblenav-more' => 'Meh Sproche',
	'vector-editwarning-warning' => 'Wänn Du die Syte verlosch, cha s syy, ass Du alli Bearbeitige verliersch, wu Du do dra gmacht hesch.
Wänn Du aagmäldet bisch, chasch s Anzeige vu däre Warnig im „Tekscht-Ygab“-Beryych vu Dyyne Yystelligen abstelle.',
	'vector-editwarning-preference' => 'Warn mi, wänn I ne Syte verloss mit Bearbeitige, wu nonig gspycheret sin',
	'vector-simplesearch-search' => 'Suechi',
	'vector-simplesearch-containing' => 'din het s …',
	'vector-noexperiments-preference' => 'Mi uusschließe vu dr Dailnahm Feature-Experimänt',
	'vector-footercleanup-transclusion' => 'In die Syte {{PLURAL:$1|isch ei Syte|sin $1 Syte}} yybunde wore.',
	'vector-footercleanup-templates' => 'Vorlage uf däre Syten aazeige',
	'vector-footercleanup-categories' => 'Versteckti Kategorie uf däre Syten aazeige',
);

/** Gujarati (ગુજરાતી)
 * @author Ashok modhvadia
 * @author KartikMistry
 * @author Sushant savla
 */
$messages['gu'] = array(
	'vector' => 'વેક્ટર માટે UI સુધારા',
	'vector-desc' => 'વેક્ટર સ્કીનના યુઝર ઈંટરફેઝ ના તત્વોને સુધારે છે',
	'vector-collapsiblenav-preference' => 'વેક્ટર સ્કીનના સાઈડ બારમાં કોલેપ્સીંગ સક્રીય કરશે.',
	'vector-collapsiblenav-more' => 'વધુ ભાષાઓ',
	'vector-editwarning-warning' => 'આ પાનું છોડી દેશો તો તમારા ફેરફારો સચવાશે નહીં.
જો તમે પ્રવેશ કરેલો હોય તો તમે આ ચેતવણીને તમારી પસંદના "ફેરફાર" વિભાગના વિકલ્પો બદલીને બંધ કરી શકો છો.',
	'vector-editwarning-preference' => 'સાચવ્યા વગર જો હું પૃષ્ઠ છોડું તો મને ચેતવણી આપો',
	'vector-simplesearch-search' => 'શોધો',
	'vector-simplesearch-containing' => 'ધરાવતી...',
	'vector-noexperiments-preference' => 'મને પ્રયોગોમાંથી બાકાત રાખો',
);

/** Manx (Gaelg)
 * @author Shimmin Beg
 */
$messages['gv'] = array(
	'vector-collapsiblenav-more' => 'Tooilley çhengaghyn',
	'vector-editwarning-warning' => "My faagys oo y duillag, hed caghlaaghyn erbee er coayl, foddee.
My t'ou uss loggalt stiagh, foddee oo lhiettal y raaue shoh 'sy tosheeaghtyn ayd, 'sy rheynn \"Reaghey\".",
	'vector-editwarning-preference' => 'Cur raaue dou my ta mee faagail duillag reaghey gyn sauail yn obbyr jeant aym',
	'vector-simplesearch-search' => 'Ronsaghey',
	'vector-simplesearch-containing' => 'goaill stiagh...',
);

/** Hebrew (עברית)
 * @author Amire80
 * @author Ofekalef
 * @author Rotemliss
 * @author YaronSh
 * @author Yonidebest
 */
$messages['he'] = array(
	'vector' => 'שיפורי מנשק משתמש עבור וקטור',
	'vector-desc' => 'הרחבת ממשק המשתמש בעת השימוש בעיצוב וקטור',
	'vector-collapsiblenav-preference' => 'הפעלת קיפול פריטים בתפריט הניווט בעיצוב וקטור',
	'vector-collapsiblenav-more' => 'דף זה בשפות אחרות',
	'vector-editwarning-warning' => 'עזיבת דף זה עשויה לגרום לאובדן כל השינויים שביצעתם.
אם אתם מחוברים לחשבון, תוכלו לבטל אזהרה זו בחלק "עריכה" שבהעדפות שלכם.',
	'vector-editwarning-preference' => 'הצגת אזהרה בעת עזיבת דף עריכה עם שינויים שטרם נשמרו',
	'vector-simplesearch-search' => 'חיפוש',
	'vector-simplesearch-containing' => 'כולל...',
	'vector-noexperiments-preference' => 'אל תכללו אותי בניסויים בעתיד',
	'vector-footercleanup-transclusion' => 'הדף הזה מכליל {{PLURAL:$1|דף אחד אחר|$1 דפים אחרים}}',
	'vector-footercleanup-templates' => 'הצגת תבניות בדף הזה',
	'vector-footercleanup-categories' => 'הצגת קטגוריות מוסתרות בדף הזה',
);

/** Hindi (हिन्दी)
 * @author Ansumang
 */
$messages['hi'] = array(
	'vector' => 'यूआई उन्नति वेक्टर स्किन के लिए',
	'vector-collapsiblenav-more' => 'और अधिक भाषाएं',
	'vector-simplesearch-search' => 'खोज',
	'vector-noexperiments-preference' => 'मुझे सुविधा प्रयोगों से बाहर निकालें',
);

/** Fiji Hindi (Latin script) (Fiji Hindi)
 * @author Karthi.dr
 */
$messages['hif-latn'] = array(
	'vector-simplesearch-search' => 'Khojo',
);

/** Croatian (hrvatski)
 * @author Anton008
 * @author Excaliboor
 * @author SpeedyGonsales
 */
$messages['hr'] = array(
	'vector' => 'Poboljšanja sučelja stila Vektor',
	'vector-desc' => 'Poboljšava elemente korisničkog sučelja stila Vector.',
	'vector-collapsiblenav-preference' => 'Omogući sklopivi lijevi navigacijski izbornik za Vektor stil',
	'vector-collapsiblenav-more' => 'Više jezika',
	'vector-editwarning-warning' => 'Napuštanje ove stranice može uzrokovati gubitak svake izmjene koju ste napravili.
Možete onemogućiti ovo upozorenje u odjeljku "Širina okvira za uređivanje" Vaših postavki.',
	'vector-editwarning-preference' => 'Upozori me kad napuštam stranicu za uređivanje bez spremanja izmjena',
	'vector-simplesearch-search' => 'Traži',
	'vector-simplesearch-containing' => 'sadrži....',
	'vector-noexperiments-preference' => 'Isključi me iz daljnjih eksperimentiranja',
);

/** Upper Sorbian (hornjoserbsce)
 * @author Michawiki
 */
$messages['hsb'] = array(
	'vector' => 'Polěpšenja wužiwarskeho powjercha za Vector',
	'vector-desc' => 'Polěpša wužiwarski powjerch drasty Vector',
	'vector-collapsiblenav-preference' => 'Fałdowanje zapiskow w bóčnicy w drasće Vector zmóžnić',
	'vector-collapsiblenav-more' => 'Dalše rěče',
	'vector-editwarning-warning' => 'Hdyž so strona wopušća, móžeja so změny zhubić, kotrež sy přewjedł. Jeli sy přizjewjeny, móžeš tute warnowanje we wotrězku "Wobdźěłowanje" swojich nastajenjow znjemóžnić.',
	'vector-editwarning-preference' => 'Warnować, hdyž so wobdźěłowanska strona z njeskładowanymi změnami wopušća',
	'vector-simplesearch-search' => 'Pytać',
	'vector-simplesearch-containing' => 'wobsahuje...',
	'vector-noexperiments-preference' => 'Mje z funkciskich eksperimentow wuzamknyć',
	'vector-footercleanup-transclusion' => 'Tuta strona wobsahuje {{PLURAL:$1|transkluziju|transkluziji|transkluzije|transkluzije}} $1 {{PLURAL:$1|druheje strony|druheju stronow|druhich stronow|druhich stronow}}.',
	'vector-footercleanup-templates' => 'Předłohi na tutej stronje zwobraznić',
	'vector-footercleanup-categories' => 'Schowane kategorije na tutej stronje pokazać',
);

/** Hungarian (magyar)
 * @author Dani
 * @author Hunyadym
 * @author Tgr
 */
$messages['hu'] = array(
	'vector' => 'Fejlesztések a Vector felhasználói felületén',
	'vector-desc' => 'Fejlesztések a Vector felület felhasználói felületének elemein.',
	'vector-collapsiblenav-preference' => 'Összecsukható navigációs menü engedélyezése a Vector felületen',
	'vector-collapsiblenav-more' => 'Más nyelveken',
	'vector-editwarning-warning' => 'A lap elhagyásával az összes itt végzett változtatás elveszhet.
Ha be vagy jelentkezve letilthatod ezt a figyelmeztetést a beállításaid „Szerkesztés” szakaszában.',
	'vector-editwarning-preference' => 'Figyelmeztessen, ha szerkesztéskor a módosítások mentése nélkül akarom elhagyni a lapot',
	'vector-simplesearch-search' => 'Keresés',
	'vector-simplesearch-containing' => 'tartalmazza…',
	'vector-noexperiments-preference' => 'Nem akarok kísérleti funkciókat használni',
);

/** Armenian (Հայերեն)
 * @author Xelgen
 */
$messages['hy'] = array(
	'vector-editwarning-warning' => 'Այս էջը լքելով դուք կարող եք կորցնել ձեր կատարած փոփոխությունները։
Եթե դուք գրանցված եք համակարգում, կարող եք անջատել այս նախազգուշացումը ձեր նախընրությունների «Խմբագրում» բաժնում։',
	'vector-editwarning-preference' => 'Զգուշացնել ինձ, երբ ես լքում եմ խմբագրման էջը առանց կատարած փոփոխությունները հիշելու։',
	'vector-simplesearch-search' => 'Որոնել',
);

/** Interlingua (interlingua)
 * @author McDutchie
 */
$messages['ia'] = array(
	'vector' => 'Meliorationes del interfacie de usator pro Vector',
	'vector-desc' => 'Meliora le elementos del interfacie de usator del apparentia Vector.',
	'vector-collapsiblenav-preference' => 'Render plicabile le elementos in le menu de navigation in le apparentia Vector',
	'vector-collapsiblenav-more' => 'Plus linguas',
	'vector-editwarning-warning' => 'Quitar iste pagina pote causar le perdita de omne modificationes que tu ha facite.
Si tu ha aperite un session, tu pote disactivar iste aviso in le section "Modification" de tu preferentias.',
	'vector-editwarning-preference' => 'Advertir me quando io quita un pagina de modification sin publicar le cambiamentos',
	'vector-simplesearch-search' => 'Cercar',
	'vector-simplesearch-containing' => 'continente...',
	'vector-noexperiments-preference' => 'Excluder me de functionalitate experimental',
	'vector-footercleanup-transclusion' => 'Iste pagina contine {{PLURAL:$1|un transclusion|transclusiones}} de $1 altere {{PLURAL:$1|pagina|paginas}}.',
);

/** Indonesian (Bahasa Indonesia)
 * @author Farras
 * @author Irwangatot
 * @author IvanLanin
 * @author Kenrick95
 */
$messages['id'] = array(
	'vector' => 'Meningkatkan UI untuk Vector',
	'vector-desc' => 'Meningkatkan elemen pada antarmuka penguna dari kulit Vector.',
	'vector-collapsiblenav-preference' => 'Aktifkan fungsi menu navigasi kiri yang dapat ditampilkan pada kulit Vektor',
	'vector-collapsiblenav-more' => 'Lebih banyak bahasa',
	'vector-editwarning-warning' => 'Meninggalkan halaman ini dapat menyebabkan semua perubahan yang belum tersimpan hilang.
Jika Anda telah masuk log, Anda dapat mematikan peringatan ini lewat "Penyuntingan" pada halaman preferensi Anda.',
	'vector-editwarning-preference' => 'Ingatkan saya bila meninggalkan halaman penyuntingan sebelum menyimpan perubahan',
	'vector-simplesearch-search' => 'Cari',
	'vector-simplesearch-containing' => 'isian ...',
	'vector-noexperiments-preference' => 'Kecualikan saya dari percobaan fitur',
	'vector-footercleanup-transclusion' => 'Halaman ini berisi {{PLURAL:$1|transklusi|transklusi}} {{PLURAL:$1|sebuah halaman lain|$1 halaman lain}}.',
);

/** Igbo (Igbo)
 * @author Ukabia
 */
$messages['ig'] = array(
	'vector-simplesearch-search' => 'Chọwa',
);

/** Iloko (Ilokano)
 * @author Lam-ang
 */
$messages['ilo'] = array(
	'vector' => 'Napasayat nga UI para iti Vector',
	'vector-desc' => 'Pasayaatenna ti interface ti agar-aramat no agusar ti kudil a Vector',
	'vector-collapsiblenav-preference' => 'Pakabaelanna ti panarebba dagiti banag ti uneg ti igid a baras iti kudil a Vector',
	'vector-collapsiblenav-more' => 'Adu pay a pagsasao',
	'vector-editwarning-warning' => 'Ti ipapanaw ti daytoy a panid ket makapataud ti panakapukaw kadagiti amiaman a binalbaliwam.
No nakastrekka, mabalinmo nga ibaldado daytoy a ballaag idiay "Panagurnos" a paset kadagiti kakaykayatam.',
	'vector-editwarning-preference' => 'Pakaunaannak no pumanawak ti pagurnosan a panid nga adda ti saan a naidulin a sinuksukatan',
	'vector-simplesearch-search' => 'Biruken',
	'vector-simplesearch-containing' => 'naglaon ti...',
	'vector-noexperiments-preference' => 'Saannak nga iraman kadagiti eksperimento a langa',
	'vector-footercleanup-transclusion' => 'Daytoy a panid ket naglaon  {{PLURAL:$1|ti transklusion|kadagiti transklusion}}  {{PLURAL:$1|ti maysa a panid|dagiti $1 a nadumaduma a pampanid}}.',
	'vector-footercleanup-templates' => 'Kitaen dagiti plantilia iti daytoy a panid',
	'vector-footercleanup-categories' => 'Ipakita dagiti nailemmeng a kategoria iti daytoy a panid',
);

/** Ido (Ido)
 * @author Malafaya
 */
$messages['io'] = array(
	'vector-collapsiblenav-more' => 'Plusa lingui',
	'vector-simplesearch-search' => 'Serchez',
	'vector-simplesearch-containing' => 'quan kontenas...',
);

/** Icelandic (íslenska)
 * @author Krun
 * @author Snævar
 * @author Ævar Arnfjörð Bjarmason
 */
$messages['is'] = array(
	'vector' => 'Viðmóts lagfæringar á Vector-sniði',
	'vector-desc' => 'Endurbætir notanda viðmót Vector sniðsins.',
	'vector-collapsiblenav-preference' => 'Fella saman hluti í hliðarstiku Vector sniðsins',
	'vector-collapsiblenav-more' => 'Fleiri tungumál',
	'vector-editwarning-warning' => 'Ef farið er frá þessari síðu gætu þær breytingar sem þú hefur gert tapast.
Ef þú ert skráður inn, þá getur þú óvirkjað þessi skilaboð í „Breytingarflipanum" undir stillingum.',
	'vector-editwarning-preference' => 'Vara mig við þegar ég fer frá breytingarsíðu með óvistaðar breytingar',
	'vector-simplesearch-search' => 'Leita',
	'vector-simplesearch-containing' => 'sem innihalda ...',
	'vector-noexperiments-preference' => 'Útiloka mig frá tilraunum framvegis.',
	'vector-footercleanup-transclusion' => 'Þessi síða ítengist {{PLURAL:$1|einni síðu|$1 öðrum síðum}}.',
);

/** Italian (italiano)
 * @author Beta16
 * @author F. Cosoleto
 * @author Una giornata uggiosa '94
 */
$messages['it'] = array(
	'vector' => "Miglioramenti all'interfaccia utente per Vector",
	'vector-desc' => "Potenzia l'interfaccia utente quando si usa la skin Vector",
	'vector-collapsiblenav-preference' => 'Abilita menù di navigazione nascondibile per la skin Vector',
	'vector-collapsiblenav-more' => 'Altre lingue',
	'vector-editwarning-warning' => 'Lasciare questa pagina potrebbe costarti la perdita di tutti i cambiamenti effettuati.
Se sei loggato, puoi disattivare questo avviso nella sezione "Casella di modifica" delle tue preferenze.',
	'vector-editwarning-preference' => 'Avvisa quando si lascia una pagina di modifica con modifiche non salvate',
	'vector-simplesearch-search' => 'Ricerca',
	'vector-simplesearch-containing' => 'contenente...',
	'vector-noexperiments-preference' => 'Escludimi dalle funzionalità sperimentali',
	'vector-footercleanup-transclusion' => "Questa pagina contiene {{PLURAL:$1|un'inclusione|delle inclusioni}} di {{PLURAL:$1|un'altra pagina|$1 altre pagine}}.",
	'vector-footercleanup-templates' => 'Mostra i template di questa pagina',
	'vector-footercleanup-categories' => 'Mostra le categorie nascoste di questa pagina',
);

/** Japanese (日本語)
 * @author Fryed-peach
 * @author Shirayuki
 * @author Whym
 * @author 青子守歌
 */
$messages['ja'] = array(
	'vector' => 'ベクター外装用ユーザーインターフェイス改良',
	'vector-desc' => 'ベクター外装の使用時にユーザーインターフェイスを強化する',
	'vector-collapsiblenav-preference' => 'ベクター外装のナビゲーションで、項目の折り畳みを有効にする',
	'vector-collapsiblenav-more' => '他の言語',
	'vector-editwarning-warning' => 'このページを離れると、あなたが行った変更がすべて失われるおそれがあります。
ログインしている場合は、個人設定の「編集」タブでこの警告を表示しない設定に変更できます。',
	'vector-editwarning-preference' => '変更を保存せずに編集画面から離れようとしたら警告',
	'vector-simplesearch-search' => '検索',
	'vector-simplesearch-containing' => 'この語句を全文検索',
	'vector-noexperiments-preference' => '開発中の機能から自分を除外',
	'vector-footercleanup-transclusion' => 'このページでは、{{PLURAL:$1|他の $1 件のページ}}を{{PLURAL:$1|参照読み込み}}しています。',
	'vector-footercleanup-templates' => 'このページのテンプレートを閲覧',
	'vector-footercleanup-categories' => 'このページの隠しカテゴリを閲覧',
);

/** Javanese (Basa Jawa)
 * @author NoiX180
 */
$messages['jv'] = array(
	'vector' => 'Pambenahan UI kanggo Vector',
	'vector-desc' => 'Benahi unsur antarmuka panganggo saka kulit Vector.',
	'vector-collapsiblenav-more' => 'Luwih akèh basa',
	'vector-editwarning-preference' => 'Èlingaké kula yèn kula ninggalaké suntingan sing durung kasimpen',
	'vector-simplesearch-search' => 'Golèk',
	'vector-simplesearch-containing' => 'ngisi...',
	'vector-noexperiments-preference' => 'Sajabakaké kula saka èksperimèn piranti',
);

/** Georgian (ქართული)
 * @author BRUTE
 * @author David1010
 * @author ITshnik
 * @author გიორგიმელა
 */
$messages['ka'] = array(
	'vector' => 'ვექტორული თემის ინტერფეისის გაუმჯობესება',
	'vector-desc' => 'ვექტორული თემის სამომხმარებლო ინტერფეისის გაუმჯობესება',
	'vector-collapsiblenav-preference' => 'დართეთ მარცხნივ "ვექტორ" დიზაინში ბლოკების ჩაკეცვა',
	'vector-collapsiblenav-more' => 'დამატებითი ენები',
	'vector-editwarning-warning' => 'სხვა გვერდზე გადასვლა გამოიწვევს ცვლილებების დაკარგვას.',
	'vector-editwarning-preference' => 'გამაფრთხილე, როდესაც დავტოვებ რედაქტირებად გვერდს, დაუმახსოვრებელი ცვლილებებით',
	'vector-simplesearch-search' => 'ძიება',
	'vector-simplesearch-containing' => 'შეიცავს...',
	'vector-noexperiments-preference' => 'გამომრიცხე შემდგომი ექსპერიმენტებისგან.',
	'vector-footercleanup-transclusion' => 'ეს გვერდი შეიცავს {{PLURAL:$1|ერთი სხვა გვერდის|$1 სხვა გვერდის}} {{PLURAL:$1|ჩანართს|ჩანართს}}.',
);

/** Kazakh (Қазақша)
 * @author Kaztrans
 */
$messages['kk'] = array(
	'vector-editwarning-warning' => 'Басқа бетке өтсеңіз сіздің жазған соңғы өңдемелеріңіз жойылуы мүмкін. 
Егер сiз жүйеде тiркелсеңiз, онда сiз баптауларыңыздағы «Өңдеу» бөлігіне кіріп, бұл ескертуді өшіре аласыз.',
);

/** Kazakh (Cyrillic script) (қазақша (кирил)‎)
 * @author GaiJin
 * @author Kaztrans
 */
$messages['kk-cyrl'] = array(
	'vector-editwarning-warning' => 'Басқа бетке өтсеңіз сіздің жазған соңғы өңдемелеріңіз жойылуы мүмкін. 
Егер сiз жүйеде тiркелсеңiз, онда сiз баптауларыңыздағы «Өңдеу» бөлігіне кіріп, бұл ескертуді өшіре аласыз.',
	'vector-simplesearch-search' => 'Іздеу',
	'vector-noexperiments-preference' => 'Параметр эксперименттеріне қатыстырма',
);

/** Kalaallisut (kalaallisut)
 * @author Qaqqalik
 */
$messages['kl'] = array(
	'vector-simplesearch-search' => 'Ujarlerit',
);

/** Khmer (ភាសាខ្មែរ)
 * @author គីមស៊្រុន
 */
$messages['km'] = array(
	'vector-collapsiblenav-more' => 'ភាសាផ្សេងទៀត',
	'vector-editwarning-warning' => 'ចាកចេញពីទំព័រនេះ នឹងធ្វើឲ្យអ្នកបាត់បង់កំណែប្រែដែលអ្នកបានធ្វើ។
ប្រសិនបើអ្នកបានកត់ឈ្មោះរួចហើយ អ្នកអាច​បិទ​បម្រាម​នេះ​នៅ​ក្នុងផ្នែក​ "កំណែប្រែ" នៃ​ចំណូល​ចិត្ត​របស់​អ្នក​។',
	'vector-editwarning-preference' => 'សូមព្រមាន​ខ្ញុំ​ ពេលដែលខ្ញុំ​ចាកចេញ​ពី​ទំព័រ​កែប្រែដោយមិន​បានរក្សា​ទុកបំលាស់ប្ដូរ​នានា​',
	'vector-simplesearch-search' => 'ស្វែងរក​',
	'vector-simplesearch-containing' => 'ដែលមានពាក្យ...',
	'vector-noexperiments-preference' => 'ដកខ្ញុំចេញពីការពិសោធន៍មុខងារថ្មីៗ',
);

/** Korean (한국어)
 * @author Albamhandae
 * @author IRTC1015
 * @author Kwj2772
 * @author 아라
 */
$messages['ko'] = array(
	'vector' => '벡터 스킨의 인터페이스 향상',
	'vector-desc' => '벡터 스킨을 사용할 때 사용자 인터페이스를 향상',
	'vector-collapsiblenav-preference' => '벡터 스킨에서 왼쪽 사이드바 메뉴 접기',
	'vector-collapsiblenav-more' => '기타 언어',
	'vector-editwarning-warning' => '이 창에서 벗어나면 저장하지 않은 편집이 모두 사라집니다.
로그인한 경우, 환경 설정 "편집 상자"란에서 이 경고창을 띄우지 않도록 설정할 수 있습니다.',
	'vector-editwarning-preference' => '수정한 내용을 저장하지 않고 편집 양식을 닫거나 다른 페이지로 이동할 때 알림',
	'vector-simplesearch-search' => '찾기',
	'vector-simplesearch-containing' => '다음의 어구가 들어간 문서 찾기...',
	'vector-noexperiments-preference' => '새 기능 실험에서 나를 제외합니다.',
	'vector-footercleanup-transclusion' => '이 페이지는 다른 $1 페이지의 트랜스클루전이 포함되어 있습니다.',
	'vector-footercleanup-templates' => '이 문서에서 틀 보기',
	'vector-footercleanup-categories' => '이 문서에서 숨은 분류 보기',
);

/** Karachay-Balkar (къарачай-малкъар)
 * @author Iltever
 */
$messages['krc'] = array(
	'vector' => '«Вектор» темагъа интерфейсни игилендириу',
	'vector-desc' => '«Вектор» темагъа къошулуучу интерфейсни игилендириулери',
	'vector-collapsiblenav-preference' => 'Сол менюда «Вектор» темада блокла джашырыу амалны джандыр',
	'vector-collapsiblenav-more' => 'Дагъыда тилле',
	'vector-editwarning-warning' => 'Башха бетге кёчсегиз, этген тюрлениулеригиз тас болургъа боллукъдула.
Системада регистрацияны ётген эсегиз, бу билдириуню джарашдырыуларыгъызны «Тюрлендириу» деген бёлюмюнде джукълатыргъа боллукъсуз.',
	'vector-editwarning-preference' => 'Тюрлендириулени сакълатмай редакторлау бетден кетген сагъатымда билдир',
	'vector-simplesearch-search' => 'Излеу',
	'vector-simplesearch-containing' => 'ичиндегиси…',
);

/** Colognian (Ripoarisch)
 * @author Purodha
 */
$messages['ksh'] = array(
	'vector' => 'Verbäßert Schnettschtäll för Minsche en dä Vektor Bovverfläsch.',
	'vector-desc' => 'Verbäßert Schnettschtäll för Minsche en dä Vektor Bovverfläsch.',
	'vector-collapsiblenav-preference' => 'Donn zohlohße, Ußwahle em Ußsinn „Vektor“ zoh_ze_klappe',
	'vector-collapsiblenav-more' => 'Mieh Shprooche',
	'vector-editwarning-warning' => 'Wann de vun hee dä Sigg fott jeihß, doh künnte all Ding Änderunge aan dä Sigg verschött jonn.
Do kanns heh di Warnung affschallde, wann de aanjemelldt un enjelogg bes, dann kriß de se nieh mieh wider. Jangk doför en dä Affschnett „Beim Bearbeide“ en Dinge Enshtellunge.',
	'vector-editwarning-preference' => 'Donn mesch warne, wann esch vun en Sigg fott jonn, ih dat esch all ming Änderunge avjeschpeischert hann.',
	'vector-simplesearch-search' => 'Söhke',
	'vector-simplesearch-containing' => 'dren änthallde…',
	'vector-noexperiments-preference' => 'Donn mesch nit met neue Saache zom Ußprobeere behällijje',
	'vector-footercleanup-transclusion' => 'Heh di Sigg trick {{PLURAL:$1|ein ander Sigg|$1 ander Sigge|kein ander Sigg}} en sesch eren.',
);

/** Kurdish (Latin script) (Kurdî (latînî)‎)
 * @author Erdal Ronahi
 */
$messages['ku-latn'] = array(
	'vector-collapsiblenav-more' => 'Zêdetir ziman',
	'vector-simplesearch-search' => 'Lêgerîn',
	'vector-simplesearch-containing' => 'dihundirîne...',
);

/** Cornish (kernowek)
 * @author Kw-Moon
 * @author Nrowe
 */
$messages['kw'] = array(
	'vector-collapsiblenav-more' => 'Moy yethow',
	'vector-editwarning-warning' => 'Mar tewgh hwi ha gasa an folen-ma, hwi a alsa kelli chanjyow eus gwres genowgh.
Mars owgh hwi omgelmys, hwi a ell dialosegi an gwarnyans-ma en trogh "Chanjya" agas dowisyansow.',
	'vector-editwarning-preference' => 'Gwra ow gwarnya pan wrellen vy gasa folen chanjya gans chanjyow nag eus gwithys',
	'vector-simplesearch-search' => 'Hwilas',
	'vector-simplesearch-containing' => 'ow senji...',
);

/** Latin (Latina) */
$messages['la'] = array(
	'vector-simplesearch-search' => 'Quaerere',
);

/** Luxembourgish (Lëtzebuergesch)
 * @author Robby
 */
$messages['lb'] = array(
	'vector' => 'Verbesserunge vum Benotzer-IInterface (UI) fir Vector',
	'vector-desc' => "Verbessert am Benotzer-Interface Elementer wann d'Ausgesinn ''Vector'' benotzt gëtt.",
	'vector-collapsiblenav-preference' => 'Zesummeklappe vun Objeten am Navigatiounsmenü am Vector-Ausgesinn aschalten',
	'vector-collapsiblenav-more' => 'Méi Sproochen',
	'vector-editwarning-warning' => 'Wann Dir dës Säit verloosst kann dat dozou féieren datt Dir all Ännerungen, déi Dir gemaach hutt, verléiert.
Wann Dir ageloggt sidd, kënnt Dir dës Warnung an der Sektioun "Änneren" vun Ären Astellungen ausschalten.',
	'vector-editwarning-preference' => "Mech warne wann ech d'Ännerung vun enger Säit verloosen, ouni Ännerunge gespäichert ze hunn",
	'vector-simplesearch-search' => 'Sichen',
	'vector-simplesearch-containing' => 'mat ...',
	'vector-noexperiments-preference' => 'Mech vun Experimenter mat neie Fonctiounen eraushuelen',
	'vector-footercleanup-templates' => 'Schablounen op dëser Säit weisen',
	'vector-footercleanup-categories' => 'Verstoppte Kategorien op dëser Säit weisen',
);

/** Ganda (Luganda)
 * @author Kizito
 */
$messages['lg'] = array(
	'vector-editwarning-warning' => 'Bw\'ova ku lupapula luno kiyinza okuleetera enkyukakyuka z\'olukozeko okuvawo.<br />
Bw\'oba nga okola oyingidde mu sisitemu, okulabula kuno oyinza okukusirisa nga weyambisa<br />
ebiri mu kitundu ekya "Kukyusa" eky\'omu "Nteekateeka yange".',
);

/** Limburgish (Limburgs)
 * @author Ooswesthoesbes
 */
$messages['li'] = array(
	'vector' => 'Vectorgebroekersinterfaceverbaeteringe',
	'vector-desc' => 'Verbaetertj de vectorgebroekersinterface-illemente',
	'vector-collapsiblenav-preference' => 'Zèt inklapbaar navigatiemenu in bie vectorgebroek',
	'vector-collapsiblenav-more' => 'Mieë spräök',
	'vector-editwarning-warning' => "Es se dees pagina verleets verluus se meugelik wieziginge die se haes gemaak.
Es se bös aangemeld, kins se dees waorsjoewing oetzètten in 't bewerkingstabblaad in dien veurkäöre.",
	'vector-editwarning-preference' => "Waorssjoew mich es ich 'n bewerkdje pagina die nag neet is opgeslage wil verlaote",
	'vector-simplesearch-search' => 'Zeuke',
	'vector-simplesearch-containing' => 'bevat...',
	'vector-noexperiments-preference' => "Laot mich in 't vervolg neet mier mitdoon aan experimente",
	'vector-footercleanup-transclusion' => "Dees pagina bevat {{PLURAL:$1|'n transclusie|transclusies}} van {{PLURAL:$1|ein anger pagina|$1 anger pagina's}}.",
);

/** Lithuanian (lietuvių)
 * @author Garas
 * @author Matasg
 */
$messages['lt'] = array(
	'vector' => '„Vektorinės“ vartotojo sąsajos patobulinimai',
	'vector-collapsiblenav-more' => 'Daugiau kalbų',
	'vector-editwarning-warning' => 'Palikdamas šį puslapį jūs prarasite visus padarytus pakeitimus.',
	'vector-editwarning-preference' => 'Perspėti mane, kai palieku redagavimo puslapį, o jame yra neišsaugotų pakeitimų',
	'vector-simplesearch-search' => 'Ieškoti',
);

/** Lushai (Mizo ţawng)
 * @author RMizo
 */
$messages['lus'] = array(
	'vector-collapsiblenav-more' => 'Ţawng dangin',
	'vector-editwarning-preference' => 'Ka phêk siam danglamna ka dahţhat theihnghilh palh chuan min hrilh rawh',
	'vector-simplesearch-search' => 'Zawnna',
	'vector-simplesearch-containing' => 'hemi thu telna hi...',
);

/** Latvian (latviešu)
 * @author GreenZeb
 * @author Xil
 */
$messages['lv'] = array(
	'vector' => 'Vector lietotāja saskarsnes uzlabojumi',
	'vector-desc' => 'Uzlabo lietotāja saskarsnes elementus Vector apdarē.',
	'vector-collapsiblenav-more' => 'Vairāk valodu',
	'vector-editwarning-warning' => 'Atstājot šo lapu tu zaudēsi izdarītās izmaiņas. 
Ja esi pieteicies, jūs vari atspējot šo brīdinājumu savās izvēlēs sadaļā "rediģēšana"',
	'vector-editwarning-preference' => 'Brīdināt mani, kad es atstāju lapas rediģēšanu nesaglabājot izmaiņas',
	'vector-simplesearch-search' => 'Meklēt',
	'vector-simplesearch-containing' => 'Meklējamā frāze:',
);

/** Minangkabau (Baso Minangkabau)
 * @author VoteITP
 */
$messages['min'] = array(
	'vector' => 'Membaiki UI untuak Vektor',
	'vector-desc' => 'Membaiki elemen pado antamuka pangguno dari kulit Vektor',
	'vector-collapsiblenav-preference' => 'Aktifkan fungsi menu navigasi yang dapek ditampilkan pado kulit Vektor',
	'vector-collapsiblenav-more' => 'Labiah banyak baso',
	'vector-editwarning-warning' => 'Maninggakan laman ko dapek maakibatkan parubahan yang awak buek hilang. Jiko awak lah masuak log, awak dapek maabaikan maklumat ko malalui "Suntingan" pado laman preferensi awak.',
	'vector-editwarning-preference' => 'Ingekkan denai katiko denai maninggakan laman suntiang sabalun menyimpan parubahan',
	'vector-simplesearch-search' => 'Cari',
	'vector-simplesearch-containing' => 'Barisi...',
);

/** Macedonian (македонски)
 * @author Bjankuloski06
 * @author Brest
 */
$messages['mk'] = array(
	'vector' => 'Подобрувања на посредникот за изгледот „Векторски“',
	'vector-desc' => 'Ги подобрува корисничкиот посредник кога се користи рувото „Векторско“',
	'vector-collapsiblenav-preference' => 'Овозможи расклопување на елементи во навигационо мени во рувото „Векторско“',
	'vector-collapsiblenav-more' => 'Повеќе јазици',
	'vector-editwarning-warning' => 'Ако ја напуштите страницата ќе ги изгубите сите промени кои сте ги направиле.
Ако сте најавени, можете да го исклучите ова предупредување во одделот „Уредување“ во вашите нагодувања.',
	'vector-editwarning-preference' => 'Предупреди ме кога сакам да напуштам страница за уредување без да ги имам зачувано промените',
	'vector-simplesearch-search' => 'Пребарување',
	'vector-simplesearch-containing' => 'содржи...',
	'vector-noexperiments-preference' => 'Изземи ме од експерименти сo функции',
	'vector-footercleanup-transclusion' => 'Оваа страница содржи {{PLURAL:$1|превметнување|превметнувања}} на уште $1 {{PLURAL:$1|друга страница|други страници}}.',
	'vector-footercleanup-templates' => 'Погл. шаблони на страницава',
	'vector-footercleanup-categories' => 'Погл. скриени категории на страницава',
);

/** Malayalam (മലയാളം)
 * @author Junaidpv
 * @author Praveenp
 */
$messages['ml'] = array(
	'vector' => 'വെക്റ്റർ ദൃശ്യരൂപത്തിന്റെ സമ്പർക്കമുഖ മെച്ചപ്പെടുത്തലുകൾ',
	'vector-desc' => 'വെക്റ്റർ ദൃശ്യരൂപം ഉപയോഗിക്കുമ്പോൾ ഉപയോക്തൃസമ്പർക്കമുഖം മെച്ചപ്പെടുത്തുന്നു',
	'vector-collapsiblenav-preference' => 'വെക്റ്റർ ദൃശ്യരൂപത്തിൽ ഇടതുവശത്തെ വഴികാട്ടി മെനു ചുരുക്കാവുന്നതാക്കി സജ്ജീകരിക്കുക',
	'vector-collapsiblenav-more' => 'ഇതര ഭാഷകളിൽ',
	'vector-editwarning-warning' => 'ഈ താളിൽ നിന്നും പോകുന്നത് താങ്കൾ വരുത്തിയ മാറ്റങ്ങൾ നഷ്ടപ്പെടാൻ ഇടയാക്കും.
താങ്കൾ ലോഗിൻ ചെയ്തിട്ടുണ്ടെങ്കിൽ, താങ്കളുടെ ക്രമീകരണങ്ങളിൽ "തിരുത്തൽ" എന്ന ഭാഗത്ത് ചെന്ന് ഈ അറിയിപ്പ് പ്രദർശിപ്പിക്കുന്നത് ഒഴിവാക്കാവുന്നതാണ്.',
	'vector-editwarning-preference' => 'സേവ് ചെയ്യാത്ത മാറ്റങ്ങളോടു കൂടിയ തിരുത്തൽ താളിൽ നിന്നും പോകുമ്പോൾ എന്നെ അറിയിക്കുക',
	'vector-simplesearch-search' => 'തിരയുക',
	'vector-simplesearch-containing' => 'ഉൾപ്പെടുന്നവ...',
	'vector-noexperiments-preference' => 'സവിശേഷഗുണങ്ങൾ പരീക്ഷിക്കുന്നതിൽ നിന്നും എന്നെ ഒഴിവാക്കുക',
	'vector-footercleanup-transclusion' => 'ഈ താളിൽ {{PLURAL:$1|മറ്റൊരു താൾ|മറ്റ് $1 താളുകൾ}} ഉൾപ്പെടുത്തിയിട്ടുണ്ട്.',
	'vector-footercleanup-templates' => 'ഈ താളിലെ ഫലകങ്ങൾ കാണുക',
	'vector-footercleanup-categories' => 'ഈ താളിൽ മറഞ്ഞിരിക്കുന്ന വർഗ്ഗങ്ങൾ കാണുക',
);

/** Mongolian (монгол) */
$messages['mn'] = array(
	'vector-simplesearch-search' => 'Хайх',
);

/** Marathi (मराठी)
 * @author Mahitgar
 * @author V.narsikar
 */
$messages['mr'] = array(
	'vector' => 'समदिश परिधानाच्या उपयोगकर्ता-आंतरपृष्ठातील(UI) सुधारणा',
	'vector-desc' => 'समदिश परिधान (व्हेक्टर) त्वचेच्या उपयोगकर्ता-आंतरपृष्ठ (इंटरफेस) घटकांमध्ये सुधारणा करते',
	'vector-collapsiblenav-preference' => 'समदिश परिधानाच्या सुचालनानुक्रमातील घटकांची घडीक्षमता सक्षम करा.',
	'vector-collapsiblenav-more' => 'इतर भाषा दाखवा',
	'vector-editwarning-warning' => "या पानावरुन दुसर्‍या पानावर गेल्यास, तुम्ही येथे केलेले बदल जतन होणार नाहीत.
ही सूचना घालवण्यासाठी ''माझ्या पसंती'' मधील संपादनपसंतीत बदल करा.",
	'vector-editwarning-preference' => 'जर मी संपादित करीत असलेल्या पानावरील माझे संपादिलेले बदल जतन न केल्यास मला इशारा द्या',
	'vector-simplesearch-search' => 'शोधा',
	'vector-simplesearch-containing' => '.......हे असलेले',
	'vector-noexperiments-preference' => 'प्रायोगिक वैशिष्ट्यापासून मला दूर ठेवा',
);

/** Malay (Bahasa Melayu)
 * @author Anakmalaysia
 * @author Aurora
 * @author Diagramma Della Verita
 */
$messages['ms'] = array(
	'vector' => 'pembaikian untuk Vector',
	'vector-desc' => 'Meningkatkan antara muka pengguna ketika menggunakan kulit Vector',
	'vector-collapsiblenav-preference' => 'Aktifkan menu navigasi pada laman',
	'vector-collapsiblenav-more' => 'Bahasa lain',
	'vector-editwarning-warning' => 'Meninggalkan laman ini mungkin akan menyebabkan anda kehilangan sebarang perubahan yang telah anda lakukan.
Anda boleh melumpuhkan amaran in di bahagian "Menyunting" dalam keutamaan anda.',
	'vector-editwarning-preference' => 'Beri saya amaran apabila saya meninggalkan sesebuah laman penyuntingan tanpa menyimpan perubahan.',
	'vector-simplesearch-search' => 'Cari',
	'vector-simplesearch-containing' => 'mengandungi...',
	'vector-noexperiments-preference' => 'Kecualikan saya dari uji kaji ciri',
	'vector-footercleanup-transclusion' => 'Laman ini mengandungi {{PLURAL:$1|transklusi|transklusi-transklusi}} {{PLURAL:$1|satu laman lain|$1 laman lain}}.',
	'vector-footercleanup-templates' => 'Lihat templat pada halaman ini',
	'vector-footercleanup-categories' => 'Lihat kategori tersembunyi pada halaman ini',
);

/** Maltese (Malti)
 * @author Chrisportelli
 */
$messages['mt'] = array(
	'vector' => 'Titjib tal-interfaċċa tal-utent għal Vector',
	'vector-desc' => 'Ittejjeb l-elementi tal-interfaċċa tal-utent tal-aspett grafiku Vector.',
	'vector-collapsiblenav-preference' => "Ippermetti ''menus'' tan-navigazzjoni li jistew jinħbew fl-aspett grafiku Vector",
	'vector-collapsiblenav-more' => 'Aktar lingwi',
	'vector-editwarning-warning' => 'Jekk tħalli din il-paġna jista\' jwassal sabiex titlef kwalunkwe tibdil li tkun għamilt. Jekk int tinsab fil-kont tiegħek, tista\' tneħħi dan l-avviż fis-sezzjoni "Modifiki" tal-preferenzi tiegħek.',
	'vector-editwarning-preference' => "Avżani kull meta nħalli paġna ta' modifika b'modifiki li għadhom ma ġewx salvati",
	'vector-simplesearch-search' => 'Fittex',
	'vector-simplesearch-containing' => 'li tinkludi...',
	'vector-noexperiments-preference' => 'Eskludini minn esperimenti tal-funzjonalitajiet',
	'vector-footercleanup-transclusion' => "Din il-paġna tinkludi l-{{PLURAL:$1|inklużjoni|inklużjonijiet}} ta' {{PLURAL:$1|paġna oħra|$1 paġni oħra}}.",
);

/** Nahuatl (Nāhuatl)
 * @author Ricardo gs
 * @author Teòtlalili
 */
$messages['nah'] = array(
	'vector-collapsiblenav-more' => 'Okseki tlâtòltìn',
	'vector-simplesearch-search' => 'Tlatēmoliztli',
);

/** Norwegian Bokmål (norsk (bokmål)‎)
 * @author Danmichaelo
 * @author Jsoby
 * @author Laaknor
 * @author Nghtwlkr
 */
$messages['nb'] = array(
	'vector' => 'Brukergrensesnittsforbedringer for Vector',
	'vector-desc' => 'Forbedrer elementer i brukergrensesnittet for Vector-utseendet.',
	'vector-collapsiblenav-preference' => 'Aktiver sammenlegging av element i navigeringsmenyen i drakten Vector',
	'vector-collapsiblenav-more' => 'Flere språk',
	'vector-editwarning-warning' => 'Ved å forlate siden vil du miste alle endringer du har utført.
Denne advarselen kan slås av under Redigering i instillingene dine.',
	'vector-editwarning-preference' => 'Si ifra dersom jeg forlater en side jeg har gjort redigeringer på men ikke har lagret siden.',
	'vector-simplesearch-search' => 'Søk',
	'vector-simplesearch-containing' => 'inneholder …',
	'vector-noexperiments-preference' => 'Ekskluder meg fra funksjonseksperimenter',
	'vector-footercleanup-transclusion' => 'Denne siden inneholder {{PLURAL:$1|en transklusjon|transklusjoner}} av {{PLURAL:$1|én annen side|$1 andre sider}}.',
	'vector-footercleanup-templates' => 'Vis maler på denne siden',
	'vector-footercleanup-categories' => 'Vis skjulte kategorier på denne siden',
);

/** Nedersaksisch (Nedersaksisch)
 * @author Servien
 */
$messages['nds-nl'] = array(
	'vector-collapsiblenav-preference' => 'Inklapbaor navigasiemenu inschakelen bie t gebruuk van Vector',
	'vector-collapsiblenav-more' => 'Meer talen',
	'vector-editwarning-warning' => "A'j disse zied aofsluten dan kan t ween dat der wieziging die'j emaakt hebben kwiet raken.
A'j an-emeld bin, dan ku'j disse waorschuwing uutzetten in t tabblad \"Bewarken\" in joew veurkeuren.",
	'vector-editwarning-preference' => "Waorschuw mien a'k n bewörken zied aof wil sluten die nog niet op-esleugen is",
	'vector-simplesearch-search' => 'Zeuken / zuken / zuiken',
	'vector-simplesearch-containing' => 'bevat...',
);

/** Dutch (Nederlands)
 * @author SPQRobin
 * @author Siebrand
 */
$messages['nl'] = array(
	'vector' => 'Gebruikersinterfaceverbeteringen voor Vector',
	'vector-desc' => 'Verbetert de gebruikersinterface van het uiterlijk Vector',
	'vector-collapsiblenav-preference' => 'Inklapbaar navigatiemenu inschakelen bij gebruik van Vector',
	'vector-collapsiblenav-more' => 'Meer talen',
	'vector-editwarning-warning' => 'Als u deze pagina verlaat verliest u mogelijk wijzigingen die u hebt gemaakt.
Als u bent aangemeld, kunt u deze waarschuwing uitschakelen in het tabblad "Bewerken" in uw voorkeuren.',
	'vector-editwarning-preference' => 'Waarschuw mij als ik een bewerkte pagina die nog niet is opgeslagen wil verlaten',
	'vector-simplesearch-search' => 'Zoeken',
	'vector-simplesearch-containing' => 'bevat...',
	'vector-noexperiments-preference' => 'Mij in de toekomst niet laten deelnemen aan experimenten',
	'vector-footercleanup-transclusion' => "Deze pagina bevat {{PLURAL:$1|een transclusie|transclusies}} van {{PLURAL:$1|één andere pagina|$1 andere pagina's}}.",
	'vector-footercleanup-templates' => 'Sjablonen van deze pagina weergeven',
	'vector-footercleanup-categories' => 'Verborgen categorieën van deze pagina weergeven',
);

/** Nederlands (informeel)‎ (Nederlands (informeel)‎)
 * @author Siebrand
 */
$messages['nl-informal'] = array(
	'vector-editwarning-warning' => 'Als je deze pagina verlaat verlies je mogelijk wijzigingen die je hebt gemaakt.
Als je bent aangemeld, kan je deze waarschuwing uitschakelen in het tabblad "Bewerken" in je voorkeuren.',
);

/** Norwegian Nynorsk (norsk (nynorsk)‎)
 * @author Gunnernett
 * @author Njardarlogar
 */
$messages['nn'] = array(
	'vector-collapsiblenav-more' => 'Fleire språk',
	'vector-editwarning-warning' => 'Gjennom å navigera bort frå sida vil du missa alle endringane du måtte ha gjort.
Om du er innlogga, kan du slå av denne åtvaringa under «Endring» i instillingane dine.',
	'vector-editwarning-preference' => 'Gje ei åtvaring om eg går ut av ei redigeringsside og ikkje alle endringar er lagra',
	'vector-simplesearch-search' => 'Søk',
	'vector-simplesearch-containing' => 'inneheld ...',
);

/** Occitan (occitan)
 * @author Cedric31
 */
$messages['oc'] = array(
	'vector' => 'Melhoraments IU per Vector',
	'vector-desc' => "Melhoraments dels elements de l'interfàcia d'utilizaire de l'abilhatge Vector.",
	'vector-collapsiblenav-preference' => "Activar lo menut de navigacion d'esquèrra replegable",
	'vector-editwarning-warning' => "Quitar aquesta pagina vos farà pèrdre totas las modificacions qu'avètz fachas.
Se sètz connectat amb vòstre compte, podètz levar aqueste avertiment dins la seccion Fenèstra de modificacion de vòstras preferéncias.",
	'vector-editwarning-preference' => 'M’avisar quand quiti una pagina de modificacion sens publicar los cambiaments',
	'vector-simplesearch-search' => 'Recercar',
	'vector-simplesearch-containing' => 'que conten...',
);

/** Oriya (ଓଡ଼ିଆ)
 * @author Odisha1
 * @author Psubhashish
 * @author Shisir 1945
 */
$messages['or'] = array(
	'vector' => 'ଭେକ୍ଟର ପାଇଁ ଇଉଜର ଇଣ୍ଟରଫେସ ଉନ୍ନତିକରଣ',
	'vector-desc' => 'ଭେକ୍ଟର ଆବରଣରେ ଇଉଜର ଇଣ୍ଟରଫେସ ଉପାଦାନସମୂହକୁ ଉନ୍ନତ କରିବେ ।',
	'vector-collapsiblenav-preference' => 'ଭେକ୍ଟର ବହିରାବରଣରେ କଡ଼ରେ ଥିବା ପଟିକାର ଚିଜ ସବୁକୁ ଦେଖାଇବା-ଲୁଚାଇବା ସଚଳ କରିବେ',
	'vector-collapsiblenav-more' => 'ଅଧିକ ଭାଷା',
	'vector-editwarning-warning' => 'ଏହି ପୃଷ୍ଠାକୁ ଛାଡ଼ି ଚାଲିଗଲେ ହୁଏ ତ ଆପଣ କରିଥିବା କିଛି ସମ୍ପାଦନା ହରାଇ ପାରନ୍ତି ।
ଯଦି ଆପଣ ଲଗ ଇନ କରିଥାନ୍ତି ତେବେ ଆପଣଙ୍କ ପସନ୍ଦର "ସମ୍ପାଦନା" ଭାଗରେ ଏହି ଚେତାବନୀଟିକୁ ଅଚଳ କରିପାରିବେ ।',
	'vector-editwarning-preference' => 'ଯେତେବେଳେ ମୁଁ ଗୋଟିଏ ସାଇତାଯାଇନଥିବା ପୃଷ୍ଠାକୁ ବନ୍ଦ କରିଦିଏ ମୋତେ ଚେତାବନୀ ଦେବେ',
	'vector-simplesearch-search' => 'ଖୋଜିବା',
	'vector-simplesearch-containing' => 'ଧାରଣ ହେଉଛି...',
	'vector-noexperiments-preference' => 'ସୁବିଧାର ପରଖରୁ ମୋତେ ବାହାର କରିବେ',
	'vector-footercleanup-transclusion' => 'ଏହି ପୃଷ୍ଟାରେ {{PLURAL:$1|one other page|$1 other pages}} ର {{PLURAL:$1|transclusion|transclusions}} ଅଛି',
);

/** Punjabi (ਪੰਜਾਬੀ)
 * @author Amire80
 */
$messages['pa'] = array(
	'vector-simplesearch-search' => 'ਖੋਜ',
);

/** Deitsch (Deitsch)
 * @author Xqt
 */
$messages['pdc'] = array(
	'vector-collapsiblenav-more' => 'Weidere Schprooche',
	'vector-simplesearch-search' => 'Uffgucke',
);

/** Pälzisch (Pälzisch)
 * @author Manuae
 */
$messages['pfl'] = array(
	'vector-collapsiblenav-more' => 'Mea Schbooche',
	'vector-simplesearch-search' => 'Suche',
);

/** Polish (polski)
 * @author BeginaFelicysym
 * @author Sp5uhe
 */
$messages['pl'] = array(
	'vector' => 'Ulepszenia interfejsu użytkownika dla skórki Wektor',
	'vector-desc' => 'Poprawia elementy interfejsu użytkownika skórki Wektor.',
	'vector-collapsiblenav-preference' => 'Włącz po lewej rozwijalne menu nawigacyjne w skórce Wektor',
	'vector-collapsiblenav-more' => 'Inne języki',
	'vector-editwarning-warning' => 'Opuszczenie tej strony może spowodować utratę wprowadzonych przez Ciebie zmian.
Jeśli jesteś zalogowany możesz wyłączyć wyświetlanie tego ostrzeżenia w zakładce Edycja w swoich preferencjach.',
	'vector-editwarning-preference' => 'Ostrzegaj mnie, gdy opuszczam stronę edycji bez zapisania zmian',
	'vector-simplesearch-search' => 'Szukaj',
	'vector-simplesearch-containing' => 'zawierające...',
	'vector-noexperiments-preference' => 'Nie chcę w przyszłości brać udziału w testach',
	'vector-footercleanup-transclusion' => 'Ta strona zawiera {{PLURAL:$1|dołączoną treść|dołączone treści}} z {{PLURAL:$1|jednej innej strony|$1 innych stron|$1 innych stron}}.',
);

/** Piedmontese (Piemontèis)
 * @author Borichèt
 * @author Dragonòt
 */
$messages['pms'] = array(
	'vector' => 'Ameliorament UI për Vector',
	'vector-desc' => "Ameliorament ëd j'element dl'antërfacia utent dla pel Vector.",
	'vector-collapsiblenav-preference' => "Abilité a stërmé j'element ant la bara ëd navigassion ant ël livel Vector",
	'vector-collapsiblenav-more' => "Pì 'd lenghe",
	'vector-editwarning-warning' => "Lassé sta pàgina-sì a peul fé an manera che it perde tute le modìfiche ch'it l'has fàit.
S'it ses logà, it peule disabilité st'avis-sì ant la session \"Quàder ëd modìfica dël test\" dij tò gust.",
	'vector-editwarning-preference' => 'Avisme quand che i lasso na pàgina ëd modìfiche con modìfiche nen salvà',
	'vector-simplesearch-search' => 'Arserca',
	'vector-simplesearch-containing' => 'contenent ...',
	'vector-noexperiments-preference' => "Gav-me da j'esperiment ëd le funsion",
	'vector-footercleanup-transclusion' => "Costa pàgina a conten {{PLURAL:$1|transclusion|transclusion}} ëd {{PLURAL:$1|n'àutra pàgina|$1 àutre pàgine}}.",
);

/** Western Punjabi (پنجابی)
 * @author Khalid Mahmood
 */
$messages['pnb'] = array(
	'vector' => 'یو آئی بہتریاں ویکٹر لئی',
	'vector-desc' => 'ورتن والے دے وکھالے',
	'vector-collapsiblenav-preference' => 'ویکٹر سکن چ سائیڈ بار چ چیزاں دا ڈگنا ہون دیو۔',
	'vector-collapsiblenav-more' => 'ہور بولیاں',
	'vector-editwarning-warning' => 'اے صفے توں جان تے ہو سکدا اوہ ساریاں تبدیلیاں مک جان جیہڑیاں تساں بناياں نیں۔
اگر تسیں لاکان او، تسیں ایڈیٹنگ سیکشن چ  اپنی پسنداں چ ایس خبرداری نوں پعلے ناں۔',
	'vector-editwarning-preference' => 'جدوں میں کوئی صفحہ تبدیلی کر کے بچاۓ بغیر چھڈن لگاں تے منوں دس دیو',
	'vector-simplesearch-search' => 'کھوج',
	'vector-simplesearch-containing' => 'بند کر ریا اے۔۔۔',
	'vector-noexperiments-preference' => 'منوں نویاں شیواں دے تجربیاں توں بار رکھو',
);

/** Pontic (Ποντιακά) */
$messages['pnt'] = array(
	'vector-simplesearch-search' => 'Αράεμαν',
);

/** Pashto (پښتو)
 * @author Ahmed-Najib-Biabani-Ibrahimkhel
 */
$messages['ps'] = array(
	'vector-collapsiblenav-more' => 'نورې ژبې',
	'vector-simplesearch-search' => 'پلټل',
);

/** Portuguese (português)
 * @author Hamilton Abreu
 * @author Helder.wiki
 */
$messages['pt'] = array(
	'vector' => 'Melhorias da interface do tema Vector',
	'vector-desc' => 'Melhora os elementos da interface do utilizador para o tema Vector',
	'vector-collapsiblenav-preference' => 'Permitir o ocultamento dos elementos do menu de navegação no tema Vector',
	'vector-collapsiblenav-more' => 'Mais línguas',
	'vector-editwarning-warning' => 'Abandonar esta página pode fazer com que perca todas as suas alterações.
Se estiver autenticado, pode desactivar este aviso na secção "Edição" das preferências.',
	'vector-editwarning-preference' => 'Avisar-me ao abandonar uma página editada sem gravar as alterações.',
	'vector-simplesearch-search' => 'Pesquisa',
	'vector-simplesearch-containing' => 'contendo...',
	'vector-noexperiments-preference' => 'Excluir-me da experimentação de funcionalidades',
	'vector-footercleanup-transclusion' => 'Esta página contém a transclusão de {{PLURAL:$1|uma outra página|$1 outras páginas}}.',
);

/** Brazilian Portuguese (português do Brasil)
 * @author Daemorris
 * @author Everton137
 * @author Giro720
 * @author Helder.wiki
 */
$messages['pt-br'] = array(
	'vector' => 'Melhorias da IU do Vector',
	'vector-desc' => 'Melhora a interface do usuário do tema Vector',
	'vector-collapsiblenav-preference' => 'Ativar o ocultamento de itens no menu de navegação no tema Vector',
	'vector-collapsiblenav-more' => 'Mais idiomas',
	'vector-editwarning-warning' => 'Abandonar esta página pode fazer com que você perca todas as alterações que fez.
Se você estiver autenticado, você pode desabilitar este aviso na seção "Opções de edição" de suas preferências.',
	'vector-editwarning-preference' => 'Avisar-me quando eu deixar uma janela de edição sem ter salvo as alterações',
	'vector-simplesearch-search' => 'Pesquisa',
	'vector-simplesearch-containing' => 'contendo...',
	'vector-noexperiments-preference' => 'Excluir-me da experimentação de funcionalidades',
);

/** Quechua (Runa Simi)
 * @author AlimanRuna
 */
$messages['qu'] = array(
	'vector' => 'Ruraqpaq uyapurapi Vector nisqapaq allinchasqakuna',
	'vector-desc' => 'Ruraqpaq uyapurapi Vector qarap qallawankunata allinchan.',
	'vector-collapsiblenav-preference' => "Vector qarap wamp'unanpi qallawa pakana llamk'anata atichiy",
	'vector-collapsiblenav-more' => 'Aswan rimaykuna',
	'vector-editwarning-warning' => "Kay p'anqata saqispaykiqa lliw rurarqusqayki hukchasqakunatachá chinkachiykiman.
Yaykusqa kaspaykiqa, kay yuyampayta hark'ayta atinki allinkachinaykikunapi \"Llamk'apusqa\" rakipi.",
	'vector-editwarning-preference' => "Yuyampaway p'anqata saqiptiy manaraq rurarqusqay hukchasqakunata waqaychaspay.",
	'vector-simplesearch-search' => 'Maskay',
	'vector-simplesearch-containing' => 'kaykunayuq: ...',
	'vector-noexperiments-preference' => 'Ñuqawan ama lliplli llanchikukunata ruraychu',
);

/** Romanian (română)
 * @author AdiJapan
 * @author Minisarm
 */
$messages['ro'] = array(
	'vector' => 'Îmbunătățiri la nivelul interfeței Vector',
	'vector-desc' => 'Îmbunătățiri ale interfeței când se utilizează interfața Vector.',
	'vector-collapsiblenav-preference' => 'Activează ascunderea elementelor meniului de navigare în interfața Vector',
	'vector-collapsiblenav-more' => 'Mai multe limbi',
	'vector-editwarning-warning' => 'Părăsind această pagină, există riscul pierderii modificărilor efectuate.
Dacă sunteți autentificat, puteți dezactiva această avertizare în secțiunea „Modificare” a preferințelor dumneavoastră.',
	'vector-editwarning-preference' => 'Avertizează-mă când părăsesc o pagină fără a salva modificările',
	'vector-simplesearch-search' => 'Căutare',
	'vector-simplesearch-containing' => 'conținând...',
	'vector-noexperiments-preference' => 'Nu mai vreau să iau parte la experimente viitoare',
	'vector-footercleanup-transclusion' => 'Această pagină conține {{PLURAL:$1|o transcludere a |transcluderi ale}} {{PLURAL:$1|unei alte pagini|altor $1 pagini|altor $1 de pagini}}.',
);

/** tarandíne (tarandíne)
 * @author Joetaras
 */
$messages['roa-tara'] = array(
	'vector' => 'Miglioramende UI pe Vector',
	'vector-desc' => "Migliore l'elemende de l'inderfacce utende quanne ause 'a visualizzazzione Vector",
	'vector-collapsiblenav-preference' => "Abbilete 'a chiusure de le artichele jndr'à 'u menu de navigazione sus a 'u skin Vector",
	'vector-collapsiblenav-more' => 'Cchiù linguagge',
	'vector-editwarning-warning' => 'Assenne da sta pàgene tu puè perdè tutte le date ca è cangiate.
Ce tu è trasute, tu puè disabbilità st\'avvertimende jndr\'à sezione "Cangiaminde..." de le preferenze tune.',
	'vector-editwarning-preference' => "Avvisave quanne jie lasse 'na pàgene cangiate senze ca agghie sarvate le cangiaminde",
	'vector-simplesearch-search' => 'Cirche',
	'vector-simplesearch-containing' => 'tène...',
	'vector-noexperiments-preference' => 'Escludeme da le funziune sperimendale',
	'vector-footercleanup-templates' => "'Ndruche le template de sta pàgene",
);

/** Russian (русский)
 * @author G0rn
 * @author Ignatus
 * @author KPu3uC B Poccuu
 * @author Kaganer
 * @author MaxSem
 * @author Александр Сигачёв
 */
$messages['ru'] = array(
	'vector' => 'Улучшения интерфейса для темы «Векторное»',
	'vector-desc' => 'Улучшает пользовательский интерфейс для темы оформления «Векторное»',
	'vector-collapsiblenav-preference' => 'Разрешить сворачивать блоки в левом меню в теме «Векторное»',
	'vector-collapsiblenav-more' => 'Больше языков',
	'vector-editwarning-warning' => 'Переход на другую страницу может привести к потере сделанных вами изменений.
Если вы зарегистрированы в системе, то вы можете отключить это предупреждение в разделе «Редактирование» ваших настроек.',
	'vector-editwarning-preference' => 'Предупреждать, когда я покидаю страницу с несохранёнными изменениями',
	'vector-simplesearch-search' => 'Поиск',
	'vector-simplesearch-containing' => 'содержащие…',
	'vector-noexperiments-preference' => 'Не предлагать экспериментальные возможности',
	'vector-footercleanup-transclusion' => 'Эта страница содержит {{PLURAL:$1|включение|включения}} {{PLURAL:$1|другой страницы|$1 других страниц}}.',
	'vector-footercleanup-templates' => 'Показать шаблоны, используемые этой страницей',
	'vector-footercleanup-categories' => 'Показать скрытые категории этой страницы',
);

/** Rusyn (русиньскый)
 * @author Engelseziekte
 * @author Gazeb
 */
$messages['rue'] = array(
	'vector' => 'Здоконалїня хосновательского інтерфейсу про Вектор',
	'vector-desc' => 'Здоконалює елементы хосновательского інтерфейсу Вектор.',
	'vector-collapsiblenav-preference' => 'Поволити згортати положкы навіґачного меню во взглядї «Векторне»',
	'vector-collapsiblenav-more' => 'Іншы языкы',
	'vector-editwarning-warning' => 'Зохаблїнём той стрінкы ся можуть вшыткы учінены зміны стратити.
Кідь сьте приголошеный, можете тото варованя выпнути на картї „Едітованя“ в хосновательскім інтерфейсї.',
	'vector-editwarning-preference' => 'Упозорнити ня, кідь буду опущати сторінку без уложіня змін',
	'vector-simplesearch-search' => 'Глядати',
	'vector-simplesearch-containing' => 'обсягуючій...',
	'vector-noexperiments-preference' => 'Не брати участь на експеріментах з новыма функціями',
);

/** Sanskrit (संस्कृतम्)
 * @author Ansumang
 * @author Shubha
 */
$messages['sa'] = array(
	'vector' => 'वाहकाय यु ऐ प्रगतिः',
	'vector-desc' => 'आकृतिचर्मणः योजकमध्यस्थांशेषु प्रगतिः',
	'vector-collapsiblenav-preference' => 'आकृतिचर्मणि पार्श्वदण्डे वस्तुपतनस्य सक्रियता',
	'vector-collapsiblenav-more' => 'अन्याः भाषाः',
	'vector-editwarning-warning' => 'अस्मात् पृष्ठात् गमनेन अत्र भवता कृतानि परिवर्तनानि निष्फलानि भवेयुः ।
भवता यदि प्रविष्टं तर्हि मम इष्टतमानि इत्यत्र अस्मिन् विभागे सम्पादनेन एषः प्रबोधः यथा न आगच्छेत् तथा कर्तुं शक्यते ।',
	'vector-editwarning-preference' => 'सम्पादनानन्तरं रक्षणेन विना पृष्ठत्यागावसरे स्मार्यताम्',
	'vector-simplesearch-search' => 'अन्वेषणम्',
	'vector-simplesearch-containing' => 'विद्यन्ते......',
	'vector-noexperiments-preference' => 'प्रयोगव्यवस्थातः मां बहिष्करोतु',
	'vector-footercleanup-transclusion' => 'अस्मिन् पृष्ठे {{PLURAL:$1|one other page|$1 other pages}}इत्येतस्य {{PLURAL:$1|transclusion|transclusions}}विद्यते ।',
);

/** Sakha (саха тыла)
 * @author HalanTul
 */
$messages['sah'] = array(
	'vector' => '"Вектор" диэн тиэмэни тупсарар',
	'vector-desc' => 'Вектор диэн тиэмэ туттар интерфейсын тупсарыы',
	'vector-collapsiblenav-preference' => 'Вектор тиэмэ хаҥас менютугар блоктары куччатары (сворачивание) көҥүллүүргэ',
	'vector-collapsiblenav-more' => 'Өссө тыллар',
	'vector-editwarning-warning' => 'Атын сирэйгэ көстөххүнэ билигин оҥорбут уларытыыларыҥ барыта сүтэн хаалыахтара.
Бэлиэтэммит буоллаҕына, бу сэрэтиини туруорууларыҥ «Уларытыы» сирэйигэр араарыаххын сөп.',
	'vector-editwarning-preference' => 'Эрэдээксийэлиир сирэйтэн уларытыыларбын бигэргэппэккэ тахсаары гыннахпына сэрэтээр',
	'vector-simplesearch-search' => 'Көрдөөһүн',
	'vector-simplesearch-containing' => 'тыл баар ыстатыйалара...',
	'vector-noexperiments-preference' => 'Эспэримиэн быһыытынан бэриллэр кыахтары туһаммат гын',
);

/** Sardinian (sardu)
 * @author Andria
 */
$messages['sc'] = array(
	'vector-simplesearch-search' => 'Chirca',
);

/** Sicilian (sicilianu) */
$messages['scn'] = array(
	'vector-simplesearch-search' => 'Ricerca',
);

/** Northern Sami (sámegiella)
 * @author Jeblad
 */
$messages['se'] = array(
	'vector-simplesearch-search' => 'Oza',
);

/** Sinhala (සිංහල)
 * @author Budhajeewa
 * @author Calcey
 * @author තඹරු විජේසේකර
 * @author පසිඳු කාවින්ද
 * @author බිඟුවා
 */
$messages['si'] = array(
	'vector' => 'දෛශික සඳහා UI දියුණු කිරීම්',
	'vector-desc' => 'දෛශික පෘෂ්ඨයේ පරිශීලක අතුරු මුහුණත් මූලිකාංග මත දියුණු කරයි',
	'vector-collapsiblenav-preference' => 'Vector ඡවියේ ගමන්කෙරුම් මෙනුවේ අංග හැකිළුම සක්‍රීය කරයි',
	'vector-collapsiblenav-more' => 'තවත් භාෂාවන්',
	'vector-editwarning-warning' => 'අවධානයට: මෙම පිටුවෙන් නික්ම යාම ඔබ සිදු කළ වෙනස්කම් නැතිවී යෑමට හේතු විය හැක.
ඔබ ප්‍රවිෂ්ටවී ඇත්නම්, ඔබගේ වරණයන්වල "සංසකරණය කිරීම්" කොටසේ ඇති මෙම අනතුරු ඇඟවීම අක්‍රීය කළ හැක.',
	'vector-editwarning-preference' => 'මා සංස්කරණ පිටුවක් සුරකිනු නොලැබූ වෙනස්කිරීම් සමඟ අතහැර යන විට අවවාද කරන්න',
	'vector-simplesearch-search' => 'ගවේශණය කරන්න',
	'vector-simplesearch-containing' => 'ඇතුළත් වෙමින් පවතී...',
	'vector-noexperiments-preference' => 'ඉදිරි අත්හදා බැලීම් වලින් මාව බැහැර කරන්න',
);

/** Slovak (slovenčina)
 * @author Helix84
 * @author Teslaton
 */
$messages['sk'] = array(
	'vector' => 'Vylepšenia použ. rozhrania Vector',
	'vector-desc' => 'Vylepšuje prvky používateľského rozhrania témy vzhľady Vector',
	'vector-collapsiblenav-preference' => 'Povoliť zbaľovanie položiek v navigačnom menu v téme vzhľadu Vector',
	'vector-collapsiblenav-more' => 'Ďalšie jazyky',
	'vector-editwarning-warning' => 'Ak opustíte túto stránku, môžete tým stratiť všetky vykonané zmeny.
Ak ste prihlásený, toto upozornenie môžete vypnúť v sekcii „Úpravy“ svojich nastavení.',
	'vector-editwarning-preference' => 'Upozorniť ma, keď opúšťam upravovaciu stránku s neuloženými zmenami',
	'vector-simplesearch-search' => 'Hľadať',
	'vector-simplesearch-containing' => 'obsahuje...',
	'vector-noexperiments-preference' => 'Vylúčiť ma z budúcich experimentov',
	'vector-footercleanup-transclusion' => 'Táto stránka obsahuje {{PLURAL:$1|transklúziu|transklúzie}} $1 {{PLURAL:$1|inej stránky|iných stránok}}.',
);

/** Slovenian (slovenščina)
 * @author Dbc334
 */
$messages['sl'] = array(
	'vector' => 'Izboljšave uporabniškega vmesnika za Vector',
	'vector-desc' => 'Izboljšave elementov uporabniškega vmesnika kože Vector.',
	'vector-collapsiblenav-preference' => 'Omogoči zlaganje vnosov v navigacijskem meniju v koži Vector',
	'vector-collapsiblenav-more' => 'Več jezikov',
	'vector-editwarning-warning' => 'Če zapustite stran, boste morda izgubili vse spremembe, ki ste jih naredili.
Če ste prijavljeni, lahko to opozorilo onemogočite v razdelku »Urejanje« v svojih nastavitvah.',
	'vector-editwarning-preference' => 'Opozori me, ko skušam zapreti urejevalno polje z neshranjenimi spremembami',
	'vector-simplesearch-search' => 'Iskanje',
	'vector-simplesearch-containing' => 'vsebujoč ...',
	'vector-noexperiments-preference' => 'Izključi me iz prihodnjih preizkusov',
	'vector-footercleanup-transclusion' => 'Stran vsebuje {{PLURAL:$1|vključitev|vključitvi|vključitve}} $1 {{PLURAL:$1|druge strani|drugih strani}}.',
	'vector-footercleanup-templates' => 'Ogled predlog na strani',
	'vector-footercleanup-categories' => 'Ogled skritih kategorij na strani',
);

/** Somali (Soomaaliga)
 * @author Maax
 */
$messages['so'] = array(
	'vector-simplesearch-search' => 'Raadi',
);

/** Albanian (shqip)
 * @author Mikullovci11
 * @author Olsi
 */
$messages['sq'] = array(
	'vector' => 'Përmirësime UI për Vector',
	'vector-desc' => 'Përmirësime në elementet e ndërfaqes së përdoruesit të pamjes Vector.',
	'vector-collapsiblenav-preference' => 'Aktivizoni mbylljen e artikujve në menunë e navigimit në pamjen Vector',
	'vector-collapsiblenav-more' => 'Gjuhët tjera',
	'vector-editwarning-warning' => 'Lënia e kësaj faqeje mund t\'ju shkaktojë humbjen e çdo ndryshimi që keni bërë.
Nëse keni hyrë brenda, ju mund ta hiqni këtë paralajmërim në seksionin "Redaktimi" tek preferencat tuaja.',
	'vector-editwarning-preference' => 'Më paralajmëro kur unë lë një redaktim faqeje me ndryshime të paruajtura',
	'vector-simplesearch-search' => 'Kërko',
	'vector-simplesearch-containing' => 'përmban ...',
);

/** Serbian (Cyrillic script) (српски (ћирилица)‎)
 * @author Helios13
 * @author Rancher
 * @author Жељко Тодоровић
 */
$messages['sr-ec'] = array(
	'vector' => 'Побољшања корисничког интерфејса за вектор',
	'vector-desc' => 'Побољшава корисничке елементе сучеља за пресвлаку Вектор.',
	'vector-collapsiblenav-preference' => 'Скупљање ставки навигационог менија у Vector пресвлаци',
	'vector-collapsiblenav-more' => 'Више језика:',
	'vector-editwarning-warning' => 'Ако напустите ову страницу, изгубићете све измене које сте направили.
Ако сте пријављени, можете онемогућити ово упозорење у својим подешавањима, у одељку „Уређивање“.',
	'vector-editwarning-preference' => 'Упозори ме када напустим страницу која није сачувана',
	'vector-simplesearch-search' => 'Претрага',
	'vector-simplesearch-containing' => 'садржи...',
	'vector-noexperiments-preference' => 'Изузми ме из пробних могућности',
	'vector-footercleanup-transclusion' => 'Ова страница садржи {{PLURAL:$1|укључивање|укључивања}} на још $1 {{PLURAL:$1|другу страницу|друге странице|других страница}}.',
);

/** Serbian (Latin script) (srpski (latinica)‎)
 * @author Liangent
 */
$messages['sr-el'] = array(
	'vector' => 'Poboljšanja korisničkog interfejsa za vektor',
	'vector-desc' => 'Poboljšava korisničke elemente sučelja za presvlaku Vektor.',
	'vector-collapsiblenav-preference' => 'Skupljanje stavki navigacionog menija u Vector presvlaci',
	'vector-collapsiblenav-more' => 'Još jezika:',
	'vector-editwarning-warning' => 'Ako napustite ovu stranicu, izgubićete sve izmene koje ste napravili.
Ako ste prijavljeni, možete onemogućiti ovo upozorenje u svojim podešavanjima, u odeljku „Uređivanje“.',
	'vector-editwarning-preference' => 'Upozori me kada napustim stranicu sa nesačuvanim promenama',
	'vector-simplesearch-search' => 'Pretraga',
	'vector-simplesearch-containing' => 'sadrži...',
	'vector-noexperiments-preference' => 'Izuzmi me iz probnih mogućnosti',
	'vector-footercleanup-transclusion' => 'Ova stranica sadrži {{PLURAL:$1|uključivanje|uključivanja}} na još $1 {{PLURAL:$1|drugu stranicu|druge stranice|drugih stranica}}.',
);

/** Seeltersk (Seeltersk)
 * @author Pyt
 */
$messages['stq'] = array(
	'vector-simplesearch-search' => 'Säik',
	'vector-simplesearch-containing' => 'Fultextsäike ätter ...',
);

/** Sundanese (Basa Sunda)
 * @author Kandar
 */
$messages['su'] = array(
	'vector-collapsiblenav-more' => 'Basa lianna',
	'vector-editwarning-preference' => 'Béjaan kuring lamun ninggalkeun kaca édit anu parobahanana can disimpen',
	'vector-simplesearch-search' => 'Sungsi',
	'vector-simplesearch-containing' => 'ngandung...',
);

/** Swedish (svenska)
 * @author Ainali
 * @author Boivie
 * @author MagnusA
 * @author Martinwiss
 */
$messages['sv'] = array(
	'vector' => 'Användargränssnittsförbättringar för Vector',
	'vector-desc' => 'Förbättrar användargränssnittet när man använder Vector-utseendet',
	'vector-collapsiblenav-preference' => 'Aktivera hopfällning av poster i navigeringsmenyn i Vector-utseendet',
	'vector-collapsiblenav-more' => 'Fler språk',
	'vector-editwarning-warning' => 'Om du lämnar den här sidan kommer du att förlora alla ändringar du har gjort.
Om du är inloggad kan du slå av den här varningen under "Redigering" i dina inställningar.',
	'vector-editwarning-preference' => 'Varna mig om jag lämnar en redigeringssida där jag gjort ändringar men inte sparat.',
	'vector-simplesearch-search' => 'Sök',
	'vector-simplesearch-containing' => 'innehåller...',
	'vector-noexperiments-preference' => 'Uteslut mig från funktionsexperiment',
	'vector-footercleanup-transclusion' => 'Denna sida innehåller {{PLURAL:$1| transklusion|transklusioner}} av {{PLURAL:$1|en annan sida| $1 andra sidor}}.',
	'vector-footercleanup-templates' => 'Visa mallar på den här sidan',
	'vector-footercleanup-categories' => 'Visa dolda kategorier på den här sidan',
);

/** Swahili (Kiswahili)
 * @author Lloffiwr
 * @author Muddyb Blast Producer
 */
$messages['sw'] = array(
	'vector' => 'Mabadiliko ya kuendeleza kusano ya Vector',
	'vector-desc' => 'Inaboresha kusano kwa ajili ya watumiaji wa umbo la Vector.',
	'vector-collapsiblenav-preference' => 'Kuwezesha vitu vikunjike katika orodha ya urambazaji, katika umbo la Vector',
	'vector-collapsiblenav-more' => 'Lugha zingine',
	'vector-editwarning-warning' => 'Ukitoka kwenye ukurasa huu labda utapoteza madabiliko uliyoyafanya.
Unaweza kuondoa ilani hii ukienda kwenye sehemu ya "Kuhariri" kwenye mapendekezo yako.',
	'vector-editwarning-preference' => 'Unionyeshe ilani ninapotaka kutoka kwenye ukurasa ninouhariri, bila kuhifadhi mabadiliko',
	'vector-simplesearch-search' => 'Kutafuta',
	'vector-simplesearch-containing' => 'ya maneno...',
);

/** Tamil (தமிழ்)
 * @author Sodabottle
 * @author TRYPPN
 * @author மதனாஹரன்
 */
$messages['ta'] = array(
	'vector-collapsiblenav-more' => 'மேலும் அதிகமான மொழிகள்',
	'vector-editwarning-preference' => 'தொகுத்துக் கொண்டிருக்கும் பக்கத்தை சேமிக்காமல் வெளியேறினால் எனக்கு எச்சரிக்கை செய்',
	'vector-simplesearch-search' => 'தேடு',
	'vector-simplesearch-containing' => 'கொண்டுள்ளது...',
	'vector-noexperiments-preference' => 'வசதிப் பரிசோதனைகளிலிருந்து என்னை விலக்கவும்',
);

/** Telugu (తెలుగు)
 * @author Veeven
 */
$messages['te'] = array(
	'vector' => 'వెక్టర్ కొరకు ముఖాంతరపు మెరుగులు',
	'vector-collapsiblenav-more' => 'మరిన్ని భాషలు',
	'vector-editwarning-warning' => 'ఈ పేజీని వదిలివెళ్ళడం వల్ల మీరు చేసిన మార్పులను కోల్పోయే అవకాశం ఉంది.
మీరు ప్రవేశించివుంటే, ఈ హెచ్చరికని మీ అభిరుచులలో "మరపులు" అనే విభాగంలో అచేతనం చేసుకోవచ్చు.',
	'vector-editwarning-preference' => 'ఏదైనా పేజీని నేను వదిలివెళ్తున్నప్పుడు దానిలో భద్రపరచని మార్పులు ఉంటే నన్ను హెచ్చరించు',
	'vector-simplesearch-search' => 'వెతుకు',
);

/** Thai (ไทย)
 * @author Horus
 * @author Octahedron80
 * @author Woraponboonkerd
 */
$messages['th'] = array(
	'vector-desc' => 'ข้อปรับปรุงองค์ประกอบอินเตอร์เฟซผู้ใช้ของสกินเวกเตอร์',
	'vector-collapsiblenav-preference' => 'ใช้งานการย่อรายการของเมนูนำทางในสกินเวกเตอร์',
	'vector-collapsiblenav-more' => 'ภาษาอื่นๆ',
	'vector-editwarning-warning' => 'การออกจากหน้านี้อาจทำให้ความเปลี่ยนแปลงที่คุณกระทำสูญหาย
ถ้าคุณล็อกอินแล้ว คุณสามารถปิดคำเตือนนี้ได้ที่ส่วน "การแก้ไข" ในการตั้งค่าของคุณ',
	'vector-editwarning-preference' => 'เตือนฉัน เมื่อฉันกำลังจะออกจากหน้าแก้ไขโดยมีข้อมูลที่ยังไม่ได้บันทึก',
	'vector-simplesearch-search' => 'ค้นหา',
	'vector-simplesearch-containing' => 'ประกอบไปด้วย...',
);

/** Turkmen (Türkmençe)
 * @author Hanberke
 */
$messages['tk'] = array(
	'vector' => 'Vector üçin interfeýs gowulandyrmalary',
	'vector-collapsiblenav-more' => 'Has köp dil',
	'vector-simplesearch-search' => 'Gözleg',
	'vector-simplesearch-containing' => 'öz içine alýar...',
);

/** Tagalog (Tagalog)
 * @author AnakngAraw
 */
$messages['tl'] = array(
	'vector' => 'Mga pagpapainam na UI para sa Vector',
	'vector-desc' => 'Nagpapainam sa mga sangkap ng dugtungang-mukha na pangtatagamit ng pabalat ng Vector.',
	'vector-collapsiblenav-preference' => 'Paganahin ang pagkanatitiklop ng mga bagay na nasa loob ng talaang panglibot sa loob ng pabalat na Vector',
	'vector-collapsiblenav-more' => 'Iba pang mga wika',
	'vector-editwarning-warning' => 'Ang paglisan mula sa pahinang ito ay maaaring makasanhi sa iyo ng pagkawala ng anumang mga pagbabagong ginawa mo.
Kung nakalagda ka, maaari mong huwag paganahin ang babalang ito sa loob ng seksyong "May binabago" ng mga nais mo.',
	'vector-editwarning-preference' => 'Magbabala sa akin kapag umalis ako sa isang pahina ng pampatnugot na hindi pa nasasagip ang mga pagbabago',
	'vector-simplesearch-search' => 'Maghanap',
	'vector-simplesearch-containing' => 'naglalaman ng ...',
	'vector-noexperiments-preference' => 'Huwag akong isali sa tampok na mga eksperimento',
	'vector-footercleanup-transclusion' => 'Ang pahinang ito ay naglalaman ng {{PLURAL:$1|transklusyon|mga transklusyon}} ng {{PLURAL:$1|isang ibang pahina|$1 ibang mga pahina}}.',
);

/** Tok Pisin (Tok Pisin)
 * @author Iketsi
 */
$messages['tpi'] = array(
	'vector-simplesearch-search' => 'Painim',
);

/** Turkish (Türkçe)
 * @author Hcagri
 * @author Karduelis
 * @author Srhat
 * @author Vito Genovese
 */
$messages['tr'] = array(
	'vector' => 'Vector için kullanıcı arabirimi iyileştirmeleri',
	'vector-desc' => 'Vector görünümünün kullanıcı arayüzü bileşenlerini iyileştirir',
	'vector-collapsiblenav-preference' => 'Vector temasında dolaşım menüsündeki ögelerin daraltılmasını etkinleştir',
	'vector-collapsiblenav-more' => 'Daha fazla dil',
	'vector-editwarning-warning' => 'Bu sayfadan ayrılmak yaptığınız herhangi bir değişikliği kaybetmenize sebep olabilir.
Eğer giriş yaptıysanız, bu uyarıyı, tercihlerinizin "Sayfa yazma alanı" bölümünde devre dışı bırakabilirsiniz.',
	'vector-editwarning-preference' => 'Kaydedilmemiş değişikliğe sahip bir değişiklik sayfasından çıkarken beni uyar',
	'vector-simplesearch-search' => 'Ara',
	'vector-simplesearch-containing' => 'içeren...',
	'vector-noexperiments-preference' => 'Beni gelecekteki deneylere dahil etme',
);

/** Tatar (Cyrillic script) (татарча)
 * @author Ильнар
 */
$messages['tt-cyrl'] = array(
	'vector' => '«Сызымлы» бизәлеше өчен яңартулар',
	'vector-collapsiblenav-preference' => '«Сызымлы» бизәлеше өчен сул менюдагы блокларны ябарга рөхсәт итү',
	'vector-collapsiblenav-more' => 'Башка телләр',
	'vector-editwarning-warning' => 'Башка биткә күчү вакытында бу мәкаләгә керткән үзгәрешләр югалырга мөмкин.
Әгәрдә сез теркәлгән булсагыз, бу искәрмәне сез «Көйләнмәләрем» өлешендә үзгәртә аласыз.',
	'vector-editwarning-preference' => 'Битне сакламыйча китү вакытында мине кисәтергә',
	'vector-simplesearch-search' => 'Эзләү',
	'vector-simplesearch-containing' => 'эчтәлек...',
	'vector-noexperiments-preference' => 'Тикшерүдәге мөмкинлекләрне кулланмаска',
);

/** Ukrainian (українська)
 * @author AS
 * @author Microcell
 * @author Olvin
 * @author Prima klasy4na
 */
$messages['uk'] = array(
	'vector' => 'Удосконалення інтерфейсу користувача за допомогою «векторного» оформлення',
	'vector-desc' => 'Покращує елементи інтерфейсу користувача за допомогою «векторного» оформлення.',
	'vector-collapsiblenav-preference' => 'Дозволити згортання бічного меню в оформленні «Векторне»',
	'vector-collapsiblenav-more' => 'Інші мови',
	'vector-editwarning-warning' => 'Перехід на іншу сторінку призведе до втрати ваших змін.
Якщо ви ввійшли до системи, то ви можете відключити це попередження в розділі «Редагування» ваших налаштувань.',
	'vector-editwarning-preference' => 'Попереджати мене, якщо я залишаю сторінку редагування з незбереженими змінами',
	'vector-simplesearch-search' => 'Пошук',
	'vector-simplesearch-containing' => 'що містять...',
	'vector-noexperiments-preference' => 'Відмовитись від випробування технічних експериментів',
	'vector-footercleanup-transclusion' => 'Ця сторінка містить {{PLURAL:$1|включення|включення|включень}} інших сторінок',
);

/** Urdu (اردو)
 * @author පසිඳු කාවින්ද
 */
$messages['ur'] = array(
	'vector-desc' => 'صارف انٹرفیس کے عناصر ویکٹر جلد کے پر بہتر ہے.',
	'vector-collapsiblenav-preference' => 'فعال حصہ ویکٹر جلد میں سائڈبار میں آئیٹمز کی',
	'vector-collapsiblenav-more' => 'مزید زبانوں میں',
	'vector-editwarning-preference' => 'خبردار مجھے جب میں غیر محفوظ کردہ تبدیلیوں کے ساتھ ایک ترمیم کے صفحے کو چھوڑ دو',
	'vector-simplesearch-search' => 'تلاش',
);

/** Uzbek (oʻzbekcha)
 * @author CoderSI
 */
$messages['uz'] = array(
	'vector-collapsiblenav-preference' => '"Vektor" tashqi ko\'rinishida (skinida) chap menyu unsurlarini yoyishga ruxsat berish',
	'vector-simplesearch-search' => 'Qidiruv',
	'vector-noexperiments-preference' => 'Tajribaviy imkoniyatlarni tavsiya qilmaslik',
);

/** vèneto (vèneto)
 * @author Candalua
 * @author Vajotwo
 */
$messages['vec'] = array(
	'vector' => 'Mejoramenti de interfacia utente (UI) par el Vector.',
	'vector-desc' => "Mejora l'interfacia utente del tema Vector.",
	'vector-collapsiblenav-preference' => 'Abiłita menù de navigaxion nascondibiłe par ła skin Vector',
	'vector-collapsiblenav-more' => 'Pì łengue',
	'vector-editwarning-warning' => 'Se te vè via da sta pagina te podaressi pèrdar tute le modìfeghe che te ghè fato.
Se te sì loggà, te poli disabilitar sto aviso in te la sezion "Dimension de la casela de modifica" de le to preferense.',
	'vector-editwarning-preference' => 'Dime se sto lassando na pagina de modifica sensa aver salvà',
	'vector-simplesearch-search' => 'Serca',
	'vector-simplesearch-containing' => 'che contien...',
);

/** Veps (vepsän kel’) */
$messages['vep'] = array(
	'vector-simplesearch-search' => 'Ectä',
	'vector-simplesearch-containing' => 'mülütajad...',
);

/** Vietnamese (Tiếng Việt)
 * @author Minh Nguyen
 * @author Vinhtantran
 */
$messages['vi'] = array(
	'vector' => 'Giao diện tích hợp với Vectơ',
	'vector-desc' => 'Hoàn thiện giao diện khi sử dụng hình dạng Vectơ',
	'vector-collapsiblenav-preference' => 'Bật trình đơn chuyển hướng gấp lại được ở bên phải trong bề ngoài Vectơ',
	'vector-collapsiblenav-more' => 'Thêm ngôn ngữ khác',
	'vector-editwarning-warning' => 'Rời khỏi trang này sẽ khiến bạn mất các sửa đổi đã thực hiện.
Nếu đã đăng nhập, bạn có thể tắt cảnh báo này tại mục “Sửa đổi” trong tùy chọn cá nhân.',
	'vector-editwarning-preference' => 'Cảnh báo khi tôi thoát trang sửa đổi mà chưa lưu trang',
	'vector-simplesearch-search' => 'Tìm kiếm',
	'vector-simplesearch-containing' => 'có chứa…',
	'vector-noexperiments-preference' => 'Loại trừ tôi khỏi các thí nghiệm tính năng',
	'vector-footercleanup-transclusion' => 'Trang này nhúng nội dung của {{PLURAL:$1|một trang khác|$1 trang khác}}.',
	'vector-footercleanup-templates' => 'Xem các bản mẫu dùng trong trang này',
	'vector-footercleanup-categories' => 'Xem các thể loại ẩn gồm trang này',
);

/** Volapük (Volapük)
 * @author Malafaya
 */
$messages['vo'] = array(
	'vector-collapsiblenav-more' => 'Püks pluik',
	'vector-simplesearch-search' => 'Suk',
	'vector-simplesearch-containing' => 'ninädöl...',
);

/** Walloon (walon)
 * @author Srtxg
 */
$messages['wa'] = array(
	'vector' => "Amidraedjes di l' eterface pol pea «Vector»",
	'vector-desc' => "Amidraedjes pol pea d' eterface d' uzeu «Vector»",
	'vector-collapsiblenav-preference' => "Permete d' erôler les cayets del båre di costé avou l' pea «Vector»",
	'vector-collapsiblenav-more' => 'Pus di lingaedjes',
	'vector-editwarning-warning' => "Cwiter cisse pådje ci vos frè piede tos les candjmints ki vos avoz fwait.
Si vos estoz elodjî, vos ploz dismete cist adviertixhmint ci dins l' linwete «Boesse di tecse» di vos preferinces.",
	'vector-editwarning-preference' => "M' advierti cwand dji cwite ene pådje k' a des candjmints nén schapés",
	'vector-simplesearch-search' => 'Cweri',
	'vector-simplesearch-containing' => 'ki contént...',
	'vector-noexperiments-preference' => 'Mi rsaetchî des esperyinces di fonccionalité',
	'vector-footercleanup-transclusion' => "Cisse pådje ci a {{PLURAL:$1|on ravalé elemint|des ravalés elemints}} vnant d' {{PLURAL:$1|ene ôte pådje|$1 ôtès pådjes}}.",
);

/** Mingrelian (მარგალური) */
$messages['xmf'] = array(
	'vector-simplesearch-search' => 'გორუა',
);

/** Yiddish (ייִדיש)
 * @author פוילישער
 */
$messages['yi'] = array(
	'vector' => 'באַניצער־אויבערפֿלאַך פֿאַרבעסערונגען פֿאַר וועקטאר',
	'vector-desc' => 'פֿאַרבעסערט דעם באניצער אויבערפֿלאַך ווען מען ניצט די וועקטאר ווײַזונג.',
	'vector-collapsiblenav-preference' => 'אַקטיווירן צונויפֿלייגן איינהייטן אינעם נאַוויגאַציע מעניו אין דעם וועקטאר געשטעל',
	'vector-collapsiblenav-more' => 'נאך שפראַכן',
	'vector-editwarning-warning' => 'איבערלאזן דעם בלאט קען גורם זײַן פֿארלירן אײַערע ענדערונגען.
אויב איר זענט ארײַנלאגירט, קענט איר מבטל זײַן די דאזיגע ווארענונג אין דער "באארבעטן" אפטיילונג פון אײַערע פרעפערענצן.',
	'vector-editwarning-preference' => 'שטעלן א ווארענונג ווען איך לאז איבער א רעדאקטירונג בלאט מיט נישט אויפגעהיטענע ענדערונגען',
	'vector-simplesearch-search' => 'זוכן',
	'vector-simplesearch-containing' => 'כולל…',
	'vector-footercleanup-templates' => 'ווײַזן מוסטער אויף דעם בלאט',
	'vector-footercleanup-categories' => 'ווײַזן באהאלטענע קאטעגאריעס אויף דעם בלאט',
);

/** Yoruba (Yorùbá)
 * @author Demmy
 */
$messages['yo'] = array(
	'vector' => 'Àwọn ìmúdára UI fún Vector',
	'vector-collapsiblenav-more' => 'Àwọn èdè lẹ́kùúnrẹ́rẹ́',
	'vector-editwarning-warning' => 'Kíkúrò ní ojúewé yìí yíò jẹ́ kí ẹ pòfo àwọn àtúnṣe tí ẹ ti ṣe.
Tó bá jẹ́ pé ẹ ti wọlé, ẹ lè dẹ́kun ìkìlọ̀ yìí nínù abala "Àtúnṣe ṣíṣe" ti àwọn ìfẹ́ràn yín.',
	'vector-editwarning-preference' => 'Kìlọ̀ fún mi tí mo bá únkúrò ní ojúewé àtúnṣe láì tíì mupamọ́',
	'vector-simplesearch-search' => 'Ṣàwárí',
	'vector-simplesearch-containing' => 'tó ní...',
);

/** Cantonese (粵語)
 * @author Horacewai2
 * @author Waihorace
 */
$messages['yue'] = array(
	'vector' => '對於Vector嘅界面改進',
	'vector-desc' => '改進Vector畫面嘅界面元素。',
	'vector-collapsiblenav-preference' => '用可折疊導航列',
	'vector-collapsiblenav-more' => '更多語言',
	'vector-editwarning-warning' => '離開呢一版會令到你嘅修改唔見咗。
你可以響你嘅喜好設定嘅"編輯中"小節度停用呢個警告。',
	'vector-editwarning-preference' => '當我離開未保存好嘅修改嗰陣警告我',
	'vector-simplesearch-search' => '搵嘢',
	'vector-simplesearch-containing' => '名單傳送緊...',
);

/** Simplified Chinese (中文（简体）‎)
 * @author Bencmq
 * @author Dimension
 * @author Liangent
 * @author Onecountry
 * @author Yfdyh000
 * @author 阿pp
 */
$messages['zh-hans'] = array(
	'vector' => 'Vector用户界面改进',
	'vector-desc' => '改进Vector皮肤中的用户界面元素。',
	'vector-collapsiblenav-preference' => '在Vector皮肤的导航菜单中折叠项目',
	'vector-collapsiblenav-more' => '更多语言',
	'vector-editwarning-warning' => '离开这个页面可能会令您失去之前的所有更改。若您已经登入，您可在您参数设置的“编辑”一栏中关闭此警告。',
	'vector-editwarning-preference' => '如在更改未保存时离开页面，则发出警告',
	'vector-simplesearch-search' => '搜索',
	'vector-simplesearch-containing' => '含有...',
	'vector-noexperiments-preference' => '功能实验中排除我',
	'vector-footercleanup-transclusion' => '此页{{PLURAL:$1|嵌入包含}}有{{PLURAL:$1|一个其他页面|$1个其他页面}}。',
	'vector-footercleanup-templates' => '查看该页调用的模板',
	'vector-footercleanup-categories' => '查看该页所属的隐藏类别',
);

/** Traditional Chinese (中文（繁體）‎)
 * @author Bencmq
 * @author Gaoxuewei
 * @author Liangent
 * @author Mark85296341
 * @author Waihorace
 * @author Wrightbus
 */
$messages['zh-hant'] = array(
	'vector' => 'Vector 使用者介面改進',
	'vector-desc' => '改進 Vector 外觀中的使用者介面元素。',
	'vector-collapsiblenav-preference' => '在 Vector 外觀的導覽選單中摺疊項目',
	'vector-collapsiblenav-more' => '更多語言',
	'vector-editwarning-warning' => '離開這個頁面可能會令您失去之前的所有更改。若您已經登入，您可在您偏好設定的「編輯」節中關閉此警告。',
	'vector-editwarning-preference' => '當我在更改未儲存時離開頁面時警告我',
	'vector-simplesearch-search' => '搜尋',
	'vector-simplesearch-containing' => '包含...',
	'vector-noexperiments-preference' => '我不參與功能實險',
	'vector-footercleanup-transclusion' => '此頁{{PLURAL:$1|嵌入包含}}有{{PLURAL:$1|一|$1}}個其他頁面。',
	'vector-footercleanup-templates' => '查看該頁調用的模板',
	'vector-footercleanup-categories' => '查看該頁所屬的隱藏類別',
);

