<?php
/**
 * Internationalisation for WikiEditor extension
 *
 * @file
 * @ingroup Extensions
 */

$messages = array();

/** English
 * @author Trevor Parscal
 */
$messages['en'] = array(
	/* WikiEditor */
	'wikieditor' => 'Advanced wikitext editing interface',
	'wikieditor-desc' => 'Provides an extendable wikitext editing interface and many feature-providing modules',
	'wikieditor-wikitext-tab' => 'Wikitext',
	'wikieditor-loading' => 'Loading...',
	/* Preview */
	'wikieditor-preview-preference' => 'Enable side-by-side preview',
	'wikieditor-preview-tab' => 'Preview',
	'wikieditor-preview-changes-tab' => 'Changes',
	'wikieditor-preview-loading' => 'Loading...',
	/* Preview Dialog */
	'wikieditor-previewDialog-preference' => 'Enable preview dialog',
	'wikieditor-previewDialog-tab' => 'Preview',
	'wikieditor-previewDialog-loading' => 'Loading...',
	/* Publish */
	'wikieditor-publish-preference' => 'Enable step-by-step publishing',
	'wikieditor-publish-button-publish' => 'Publish',
	'wikieditor-publish-button-cancel' => 'Cancel',
	'wikieditor-publish-dialog-title' => 'Publish to {{SITENAME}}',
	'wikieditor-publish-dialog-summary' => 'Edit summary (briefly describe the changes you have made):',
	'wikieditor-publish-dialog-minor' => 'Minor edit',
	'wikieditor-publish-dialog-watch' => 'Watch this page',
	'wikieditor-publish-dialog-publish' => 'Publish',
	'wikieditor-publish-dialog-goback' => 'Go back',
	/* Template Editor */
	'wikieditor-template-editor-preference' => 'Enable form-based editing of wiki templates',
	'wikieditor-template-editor-dialog-title' => 'Edit template',
	'wikieditor-template-editor-dialog-submit' => 'Update',
	'wikieditor-template-editor-dialog-cancel' => 'Cancel',
	/* Templates */
	'wikieditor-templates-preference' => 'Enable template collapsing',
	/* Table of Contents */
	'wikieditor-toc-preference' => 'Enable navigable table of contents',
	'wikieditor-toc-show' => 'Show contents',
	'wikieditor-toc-hide' => 'Hide contents',
	/* Toolbar */
	'wikieditor-toolbar' => 'Editing toolbar',
	'wikieditor-toolbar-desc' => 'Edit page toolbar with enhanced usability',
	'wikieditor-toolbar-preference' => 'Enable enhanced editing toolbar',
	'wikieditor-toolbar-dialogs-preference' => 'Enable dialogs for inserting links, tables and more',
	'wikieditor-toolbar-hidesig' => 'Hide the signature button from pages in the main namespace',
	'wikieditor-toolbar-loading' => 'Loading...',
	/* Toolbar - Main Section */
	'wikieditor-toolbar-tool-bold' => 'Bold',
	'wikieditor-toolbar-tool-bold-example' => 'Bold text',
	'wikieditor-toolbar-tool-italic' => 'Italic',
	'wikieditor-toolbar-tool-italic-example' => 'Italic text',
	'wikieditor-toolbar-tool-ilink' => 'Internal link',
	'wikieditor-toolbar-tool-ilink-example' => 'Link title',
	'wikieditor-toolbar-tool-xlink' => 'External link (remember http:// prefix)',
	'wikieditor-toolbar-tool-xlink-example' => 'http://www.example.com link title',
	'wikieditor-toolbar-tool-link' => 'Link',
	'wikieditor-toolbar-tool-link-title' => 'Insert link',
	'wikieditor-toolbar-tool-link-int' => 'To a wiki page',
	'wikieditor-toolbar-tool-link-int-target' => 'Target page or URL:',
	'wikieditor-toolbar-tool-link-int-target-tooltip' => 'Page title or URL',
	'wikieditor-toolbar-tool-link-int-text' => 'Text to display:',
	'wikieditor-toolbar-tool-link-int-text-tooltip' => 'Text to be displayed',
	'wikieditor-toolbar-tool-link-ext' => 'To an external web page',
	'wikieditor-toolbar-tool-link-ext-target' => 'Link URL:',
	'wikieditor-toolbar-tool-link-ext-text' => 'Link text:',
	'wikieditor-toolbar-tool-link-insert' => 'Insert link',
	'wikieditor-toolbar-tool-link-cancel' => 'Cancel',
	'wikieditor-toolbar-tool-link-int-target-status-exists' => 'Page exists',
	'wikieditor-toolbar-tool-link-int-target-status-notexists' => 'Page does not exist',
	'wikieditor-toolbar-tool-link-int-target-status-invalid' => 'Invalid title',
	'wikieditor-toolbar-tool-link-int-target-status-external' => 'External link',
	'wikieditor-toolbar-tool-link-int-target-status-loading' => 'Checking page existence...',
	'wikieditor-toolbar-tool-link-int-invalid' => 'The title you specified is invalid.',
	'wikieditor-toolbar-tool-link-lookslikeinternal' => 'The URL you specified looks like it was intended as a link to another wiki page.
Do you want to make it an internal link?',
	'wikieditor-toolbar-tool-link-lookslikeinternal-int' => 'Internal link',
	'wikieditor-toolbar-tool-link-lookslikeinternal-ext' => 'External link',
	'wikieditor-toolbar-tool-link-empty' => "You did not enter anything to link to.",
	'wikieditor-toolbar-tool-file' => 'Embedded file',
	'wikieditor-toolbar-tool-file-example' => 'Example.jpg',
	'wikieditor-toolbar-tool-file-title' => 'Insert file',
	'wikieditor-toolbar-file-target' => 'Filename:',
	'wikieditor-toolbar-file-caption' => 'Caption:',
	'wikieditor-toolbar-file-size' => 'Size:',
	'wikieditor-toolbar-file-float' => 'Align:',
	'wikieditor-toolbar-file-default' => '(default)',
	'wikieditor-toolbar-file-format' => 'Format:',
	'wikieditor-toolbar-file-format-none' => 'none',
	'wikieditor-toolbar-tool-file-insert' => 'Insert',
	'wikieditor-toolbar-tool-file-cancel' => 'Cancel',
	'wikieditor-toolbar-tool-reference' => 'Reference',
	'wikieditor-toolbar-tool-reference-example' => 'Insert footnote text here',
	'wikieditor-toolbar-tool-reference-cancel' => 'Cancel',
	'wikieditor-toolbar-tool-reference-title' => 'Insert reference',
	'wikieditor-toolbar-tool-reference-insert' => 'Insert',
	'wikieditor-toolbar-tool-reference-text' => 'Reference text',
	'wikieditor-toolbar-tool-signature' => 'Signature and timestamp',
	/* Toolbar - Advanced Section */
	'wikieditor-toolbar-section-advanced' => 'Advanced',
	'wikieditor-toolbar-tool-heading' => 'Heading',
	'wikieditor-toolbar-tool-heading-1' => 'Level 1',
	'wikieditor-toolbar-tool-heading-2' => 'Level 2',
	'wikieditor-toolbar-tool-heading-3' => 'Level 3',
	'wikieditor-toolbar-tool-heading-4' => 'Level 4',
	'wikieditor-toolbar-tool-heading-5' => 'Level 5',
	'wikieditor-toolbar-tool-heading-example' => 'Heading text',
	'wikieditor-toolbar-group-format' => 'Format',
	'wikieditor-toolbar-tool-ulist' => 'Bulleted list',
	'wikieditor-toolbar-tool-ulist-example' => 'Bulleted list item',
	'wikieditor-toolbar-tool-olist' => 'Numbered list',
	'wikieditor-toolbar-tool-olist-example' => 'Numbered list item',
	'wikieditor-toolbar-tool-indent' => 'Indentation',
	'wikieditor-toolbar-tool-indent-example' => 'Indented line',
	'wikieditor-toolbar-tool-nowiki' => 'No wiki formatting',
	'wikieditor-toolbar-tool-nowiki-example' => 'Insert non-formatted text here',
	'wikieditor-toolbar-tool-redirect' => 'Redirect',
	'wikieditor-toolbar-tool-redirect-example' => 'Target page name',
	'wikieditor-toolbar-tool-big' => 'Big',
	'wikieditor-toolbar-tool-big-example' => 'Big text',
	'wikieditor-toolbar-tool-small' => 'Small',
	'wikieditor-toolbar-tool-small-example' => 'Small text',
	'wikieditor-toolbar-tool-superscript' => 'Superscript',
	'wikieditor-toolbar-tool-superscript-example' => 'Superscript text',
	'wikieditor-toolbar-tool-subscript' => 'Subscript',
	'wikieditor-toolbar-tool-subscript-example' => 'Subscript text',
	'wikieditor-toolbar-group-insert' => 'Insert',
	'wikieditor-toolbar-tool-gallery' => 'Picture gallery',
	'wikieditor-toolbar-tool-gallery-example' => "$1:Example.jpg|Caption1
$1:Example.jpg|Caption2",
	'wikieditor-toolbar-tool-newline' => 'New line',
	'wikieditor-toolbar-tool-table' => 'Table',
	'wikieditor-toolbar-tool-table-example-old' => "-
! header 1
! header 2
! header 3
|-
| row 1, cell 1
| row 1, cell 2
| row 1, cell 3
|-
| row 2, cell 1
| row 2, cell 2
| row 2, cell 3",
	'wikieditor-toolbar-tool-table-example-cell-text' => 'Cell text',
	'wikieditor-toolbar-tool-table-example-header' => 'Header text',
	'wikieditor-toolbar-tool-table-title' => 'Insert table',
	'wikieditor-toolbar-tool-table-dimensions-rows' => 'Rows',
	'wikieditor-toolbar-tool-table-dimensions-columns' => 'Columns',
	'wikieditor-toolbar-tool-table-dimensions-header' => 'Add header row',
	'wikieditor-toolbar-tool-table-wikitable' => 'Style with borders',
	'wikieditor-toolbar-tool-table-sortable' => 'Make table sortable',
	'wikieditor-toolbar-tool-table-example' => 'Example',
	'wikieditor-toolbar-tool-table-preview' => 'Preview',
	'wikieditor-toolbar-tool-table-insert' => 'Insert',
	'wikieditor-toolbar-tool-table-cancel' => 'Cancel',
	'wikieditor-toolbar-tool-table-example-text' => 'Lorem ipsum dolor sit amet, consectetur adipiscing elit. Ut nec purus diam. Sed aliquam imperdiet nunc quis lacinia. Donec rutrum consectetur placerat. Sed volutpat neque non purus faucibus id ultricies enim euismod.',
	'wikieditor-toolbar-tool-table-toomany' => 'Inserting a table with more than $1 cells is not possible with this dialog.',
	'wikieditor-toolbar-tool-table-invalidnumber' => 'You have not entered a valid number of rows or columns.',
	'wikieditor-toolbar-tool-table-zero' => 'You cannot insert a table with zero rows or columns.',
	'wikieditor-toolbar-tool-replace' => 'Search and replace',
	'wikieditor-toolbar-tool-replace-title' => 'Search and replace',
	'wikieditor-toolbar-tool-replace-search' => 'Search for:',
	'wikieditor-toolbar-tool-replace-replace' => 'Replace with:',
	'wikieditor-toolbar-tool-replace-case' => 'Match case',
	'wikieditor-toolbar-tool-replace-regex' => 'Treat search string as a regular expression',
	'wikieditor-toolbar-tool-replace-button-findnext' => 'Find next',
	'wikieditor-toolbar-tool-replace-button-replace' => 'Replace',
	'wikieditor-toolbar-tool-replace-button-replaceall' => 'Replace all',
	'wikieditor-toolbar-tool-replace-close' => 'Close',
	'wikieditor-toolbar-tool-replace-nomatch' => 'Your search did not match anything.',
	'wikieditor-toolbar-tool-replace-success' => '$1 replacement(s) made.',
	'wikieditor-toolbar-tool-replace-emptysearch' => 'You did not enter anything to search for.',
	'wikieditor-toolbar-tool-replace-invalidregex' => 'The regular expression you entered is invalid: $1',
	/* Toolbar - Special characters Section */
	'wikieditor-toolbar-section-characters' => 'Special characters',
	'wikieditor-toolbar-characters-page-latin' => 'Latin',
	'wikieditor-toolbar-characters-page-latinextended' => 'Latin extended',
	'wikieditor-toolbar-characters-page-ipa' => 'IPA',
	'wikieditor-toolbar-characters-page-symbols' => 'Symbols',
	'wikieditor-toolbar-characters-page-greek' => 'Greek',
	'wikieditor-toolbar-characters-page-cyrillic' => 'Cyrillic',
	'wikieditor-toolbar-characters-page-arabic' => 'Arabic',
	'wikieditor-toolbar-characters-page-arabicextended' => 'Arabic extended',
	'wikieditor-toolbar-characters-page-persian' => 'Persian',
	'wikieditor-toolbar-characters-page-hebrew' => 'Hebrew',
	'wikieditor-toolbar-characters-page-bangla' => 'Bangla',
	'wikieditor-toolbar-characters-page-tamil' => 'Tamil',
	'wikieditor-toolbar-characters-page-telugu' => 'Telugu',
	'wikieditor-toolbar-characters-page-sinhala' => 'Sinhala',
	'wikieditor-toolbar-characters-page-gujarati' => 'Gujarati',
	'wikieditor-toolbar-characters-page-devanagari' => 'Devanagari',
	'wikieditor-toolbar-characters-page-thai' => 'Thai',
	'wikieditor-toolbar-characters-page-lao' => 'Lao',
	'wikieditor-toolbar-characters-page-khmer' => 'Khmer',
	/* Toolbar - Help Section */
	'wikieditor-toolbar-section-help' => 'Help',
	'wikieditor-toolbar-help-heading-description' => 'Description',
	'wikieditor-toolbar-help-heading-syntax' => 'What you type',
	'wikieditor-toolbar-help-heading-result' => 'What you get',
	'wikieditor-toolbar-help-page-format' => 'Formatting',
	'wikieditor-toolbar-help-page-link' => 'Links',
	'wikieditor-toolbar-help-page-heading' => 'Headings',
	'wikieditor-toolbar-help-page-list' => 'Lists',
	'wikieditor-toolbar-help-page-file' => 'Files',
	'wikieditor-toolbar-help-page-reference' => 'References',
	'wikieditor-toolbar-help-page-discussion' => 'Discussion',
	'wikieditor-toolbar-help-content-italic-description' => 'Italic',
	'wikieditor-toolbar-help-content-italic-syntax' => "''Italic text''",
	'wikieditor-toolbar-help-content-italic-result' => '<em>Italic text</em>',
	'wikieditor-toolbar-help-content-bold-description' => 'Bold',
	'wikieditor-toolbar-help-content-bold-syntax' => "'''Bold text'''",
	'wikieditor-toolbar-help-content-bold-result' => '<strong>Bold text</strong>',
	'wikieditor-toolbar-help-content-bolditalic-description' => 'Bold &amp; italic',
	'wikieditor-toolbar-help-content-bolditalic-syntax' => "'''''Bold &amp; italic text'''''",
	'wikieditor-toolbar-help-content-bolditalic-result' => '<strong><em>Bold &amp; italic text</em></strong>',
	'wikieditor-toolbar-help-content-ilink-description' => 'Internal link',
	'wikieditor-toolbar-help-content-ilink-syntax' => '[[Page title|Link label]]<br />[[Page title]]',
	'wikieditor-toolbar-help-content-ilink-result' => "<a href='#'>Link label</a><br /><a href='#'>Page title</a>",
	'wikieditor-toolbar-help-content-xlink-description' => 'External link',
	'wikieditor-toolbar-help-content-xlink-syntax' => '[http://www.example.org Link label]<br />[http://www.example.org]<br />http://www.example.org',
	'wikieditor-toolbar-help-content-xlink-result' => "<a href='#' class='external'>Link label</a><br /><a href='#' class='external autonumber'>[1]</a><br /><a href='#' class='external'>http://www.example.org</a>",
	'wikieditor-toolbar-help-content-heading2-description' => '2nd level heading',
	'wikieditor-toolbar-help-content-heading2-syntax' => '== Heading text ==',
	'wikieditor-toolbar-help-content-heading2-result' => '<h2>Heading text</h2>',
	'wikieditor-toolbar-help-content-heading3-description' => '3rd level heading',
	'wikieditor-toolbar-help-content-heading3-syntax' => '=== Heading text ===',
	'wikieditor-toolbar-help-content-heading3-result' => '<h3>Heading text</h3>',
	'wikieditor-toolbar-help-content-heading4-description' => '4th level heading',
	'wikieditor-toolbar-help-content-heading4-syntax' => '==== Heading text ====',
	'wikieditor-toolbar-help-content-heading4-result' => '<h4>Heading text</h4>',
	'wikieditor-toolbar-help-content-heading5-description' => '5th level heading',
	'wikieditor-toolbar-help-content-heading5-syntax' => '===== Heading text =====',
	'wikieditor-toolbar-help-content-heading5-result' => '<h5>Heading text</h5>',
	'wikieditor-toolbar-help-content-ulist-description' => 'Bulleted list',
	'wikieditor-toolbar-help-content-ulist-syntax' => '* List item<br />* List item',
	'wikieditor-toolbar-help-content-ulist-result' => '<ul><li>List item</li><li>List item</li></ul>',
	'wikieditor-toolbar-help-content-olist-description' => 'Numbered list',
	'wikieditor-toolbar-help-content-olist-syntax' => '# List item<br /># List item',
	'wikieditor-toolbar-help-content-olist-result' => '<ol><li>List item</li><li>List item</li></ol>',
	'wikieditor-toolbar-help-content-file-description' => 'Embedded file',
	'wikieditor-toolbar-help-content-file-syntax' => '[[$1:Example.png|thumb|Caption text]]',
	'wikieditor-toolbar-help-content-file-result' => "<div style='width:104px;' class='thumbinner'><a title='Caption text' class='image' href='#'><img height='50' width='100' border='0' class='thumbimage' src='$2/WikiEditor/modules/images/toolbar/example-image.png' alt=''/></a><div class='thumbcaption'><div class='magnify'><a title='Enlarge' class='internal' href='#'><img height='11' width='15' alt='' src='$1/common/images/magnify-clip.png'/></a></div>Caption text</div></div>",
	'wikieditor-toolbar-help-content-reference-description' => 'Reference',
	'wikieditor-toolbar-help-content-reference-syntax' => 'Page text.&lt;ref name="test"&gt;[http://www.example.org Link text], additional text.&lt;/ref&gt;',
	'wikieditor-toolbar-help-content-reference-result' => "Page text.<sup><a href='#'>[1]</a></sup>",
	'wikieditor-toolbar-help-content-rereference-description' => 'Additional use of same reference',
	'wikieditor-toolbar-help-content-rereference-syntax' => '&lt;ref name="test" /&gt;',
	'wikieditor-toolbar-help-content-rereference-result' => "Page text.<sup><a href='#'>[1]</a></sup>",
	'wikieditor-toolbar-help-content-showreferences-description' => 'Display references',
	'wikieditor-toolbar-help-content-showreferences-syntax' => '&lt;references /&gt;',
	'wikieditor-toolbar-help-content-showreferences-result' => "<ol class='references'><li id='cite_note-test-0'><b><a title='' href='#'>^</a></b> <a rel='nofollow' title='http://www.example.org' class='external text' href='#'>Link text</a>, additional text.</li></ol>",
	'wikieditor-toolbar-help-content-signaturetimestamp-description' => 'Signature with timestamp',
	'wikieditor-toolbar-help-content-signaturetimestamp-syntax' => '~~~~',
	'wikieditor-toolbar-help-content-signaturetimestamp-result' => "<a href='#' title='{{#special:mypage}}'>Username</a> (<a href='#' title='{{#special:mytalk}}'>talk</a>) 15:54, 10 June 2009 (UTC)",
	'wikieditor-toolbar-help-content-signature-description' => 'Signature',
	'wikieditor-toolbar-help-content-signature-syntax' => '~~~',
	'wikieditor-toolbar-help-content-signature-result' => "<a href='#' title='{{#special:mypage}}'>Username</a> (<a href='#' title='{{#special:mytalk}}'>talk</a>)",
	'wikieditor-toolbar-help-content-indent-description' => 'Indent',
	'wikieditor-toolbar-help-content-indent-syntax' => 'Normal text<br />:Indented text<br />::Indented text',
	'wikieditor-toolbar-help-content-indent-result' => 'Normal text<dl><dd>Indented text<dl><dd>Indented text</dd></dl></dd></dl>',
);

/** Message documentation (Message documentation)
 * @author Amire80
 * @author EugeneZelenko
 * @author Hamilton Abreu
 * @author Harald Khan
 * @author Kghbln
 * @author Liangent
 * @author Lloffiwr
 * @author Mormegil
 * @author Njardarlogar
 * @author Onecountry
 * @author Prima klasy4na
 * @author Raymond
 * @author Siebrand
 * @author Umherirrender
 * @author Yekrats
 */
$messages['qqq'] = array(
	'wikieditor' => 'An extension to allow for advanced editing features.
http://www.mediawiki.org/wiki/Extension:WikiEditor',
	'wikieditor-desc' => "{{desc}}

I guess that 'feature-providing modules' means the same as 'modules providing features'.",
	'wikieditor-wikitext-tab' => 'Caption of the tab containing the edit box',
	'wikieditor-loading' => "Explanatory text for the temporary cover placed over the wikieditor while it's being assembled.
{{Identical|Loading}}",
	'wikieditor-preview-preference' => "Option in [[Special:Preferences]], tab ''{{int:prefs-editing}}''",
	'wikieditor-preview-tab' => 'Caption of the tab containing the preview

{{Identical|Preview}}',
	'wikieditor-preview-changes-tab' => "Caption of the tab containing a diff of the user's changes, à la ''{{int:Showdiff}}'' ({{msg-mw|Showdiff|notext=1}}).

{{Identical|Change}}",
	'wikieditor-preview-loading' => 'Alt text for spinner displayed while preview is being loaded
{{Identical|Loading}}',
	'wikieditor-previewDialog-tab' => 'Caption of the tab containing the preview

{{Identical|Preview}}',
	'wikieditor-previewDialog-loading' => 'Alt text for spinner displayed while preview is being loaded
{{Identical|Loading}}',
	'wikieditor-publish-preference' => "Option in [[Special:Preferences]], tab ''{{int:prefs-editing}}''",
	'wikieditor-publish-button-publish' => 'Button to the right of the Edit/Preview tabs that opens a dialog window that lets the user save their edit

{{Identical|Publish}}',
	'wikieditor-publish-button-cancel' => 'Button to the right of the Edit/Preview tabs that has the same effect as the {{msg-mw|Cancel}} link below the edit box.

{{Identical|Cancel}}',
	'wikieditor-publish-dialog-title' => 'Title of the dialog that opens when the user clicks the Publish button',
	'wikieditor-publish-dialog-summary' => 'Label for the edit summary textbox in the dialog that opens when the user clicks the Publish button. See also {{msg-mw|Summary}}.',
	'wikieditor-publish-dialog-minor' => 'Label for the minor edit checkbox in the dialog that opens when the user clicks the Publish button. See also {{msg-mw|Minoredit}}',
	'wikieditor-publish-dialog-watch' => 'Label for the watch checkbox in the dialog that opens when the user clicks the Publish button

{{Identical|Watch this page}}',
	'wikieditor-publish-dialog-publish' => "Button that saves the user's edit in the dialog that opens when the user clicks the Publish button

{{Identical|Publish}}",
	'wikieditor-publish-dialog-goback' => 'Button that closes the dialog that opens when the user clicks the Publish button

{{Identical|Go back}}',
	'wikieditor-template-editor-dialog-submit' => '{{Identical|Update}}',
	'wikieditor-template-editor-dialog-cancel' => '{{Identical|Cancel}}',
	'wikieditor-toc-preference' => "Option at [[Special:Preferences]], tab ''{{int:prefs-editing}}''",
	'wikieditor-toc-show' => 'Label of the show/hide link when the navigable table of contents is hidden',
	'wikieditor-toc-hide' => 'Label of the show/hide link when the navigable table of contents is visible',
	'wikieditor-toolbar' => 'A customizable toolbar for the WikiEditor.
For more information, see http://www.mediawiki.org/wiki/Extension:WikiEditor/Toolbar_customization',
	'wikieditor-toolbar-desc' => '{{desc}}',
	'wikieditor-toolbar-preference' => 'Option in [[Special:Preferences]]',
	'wikieditor-toolbar-dialogs-preference' => "Caption of a checkbox on [[Special:Preferences]] (''editing'' tab), enabling helper dialogs for various features of the advanced edit toolbar (e.g. inserting links or tables).
{{Identical|Enable dialogs for inserting links, tables and more}}",
	'wikieditor-toolbar-loading' => '{{Identical|Loading}}',
	'wikieditor-toolbar-tool-bold' => '{{Identical|Bold}}',
	'wikieditor-toolbar-tool-bold-example' => '{{Identical|Bold text}}',
	'wikieditor-toolbar-tool-italic' => '{{Identical|Italic}}',
	'wikieditor-toolbar-tool-italic-example' => '{{Identical|Italic text}}',
	'wikieditor-toolbar-tool-ilink' => '{{Identical|Internal link}}',
	'wikieditor-toolbar-tool-xlink' => '{{Identical|External link (remember http:// prefix)}}',
	'wikieditor-toolbar-tool-xlink-example' => "www.example.com is not a real website, but it has been reserved to use in software documentation, and will never be sold or used for advertising. If you translate the word example and try to go to that web address then you might get a message that it doesn't exist. But somebody may have created a commercial web page for that address, such as www.Beispiel.org, using the German word for example. It is therefore recommended that you do not translate http://www.example.com at all. If you do wish to translate it you should first check where the translated link takes you, and bear in mind that anybody could purchase that name in the future.",
	'wikieditor-toolbar-tool-link' => '{{Identical|Link}}',
	'wikieditor-toolbar-tool-link-cancel' => '{{Identical|Cancel}}',
	'wikieditor-toolbar-tool-link-int-target-status-exists' => 'Text shown when the title the user entered exists',
	'wikieditor-toolbar-tool-link-int-target-status-notexists' => 'Text shown when the title the user entered does not exist',
	'wikieditor-toolbar-tool-link-int-target-status-invalid' => 'Text shown when the title the user entered is invalid',
	'wikieditor-toolbar-tool-link-int-target-status-external' => 'Text shown when the link target the user entered points to an external web site
{{Identical|External link}}',
	'wikieditor-toolbar-tool-link-int-target-status-loading' => 'alt text and title text for the image shown while the title the user entered is being checked for existence',
	'wikieditor-toolbar-tool-link-int-invalid' => 'This message appears when you try to create an internal link but the page title in the link is invalid.',
	'wikieditor-toolbar-tool-link-lookslikeinternal-int' => '{{Identical|Internal link}}',
	'wikieditor-toolbar-tool-link-lookslikeinternal-ext' => '{{Identical|External link}}',
	'wikieditor-toolbar-tool-file' => '{{Identical|Embedded file}}',
	'wikieditor-toolbar-tool-file-title' => 'Title for insert file dialog',
	'wikieditor-toolbar-file-target' => 'Label for the input of filename on insert file dialog',
	'wikieditor-toolbar-file-caption' => 'Label for input of caption on insert file dialog

{{Identical|Caption}}',
	'wikieditor-toolbar-file-size' => 'Label for input of size on insert file dialog',
	'wikieditor-toolbar-file-float' => 'Label for image align selector on insert file dialog',
	'wikieditor-toolbar-file-default' => 'Label for default option in insert file dialog selectors',
	'wikieditor-toolbar-file-format' => 'Label for image format selector on insert file dialog',
	'wikieditor-toolbar-file-format-none' => 'Option in file dialog for no format for the added image',
	'wikieditor-toolbar-tool-file-insert' => '{{Identical|Insert}}',
	'wikieditor-toolbar-tool-file-cancel' => '{{Identical|Cancel}}',
	'wikieditor-toolbar-tool-reference' => '{{Identical|Reference}}',
	'wikieditor-toolbar-tool-reference-cancel' => '{{Identical|Cancel}}',
	'wikieditor-toolbar-tool-reference-title' => 'Title of insert reference dialog. This text is on the very top bar of the dialog.',
	'wikieditor-toolbar-tool-reference-insert' => 'Button text for the insert action of the insert reference dialog.
{{Identical|Insert}}',
	'wikieditor-toolbar-tool-reference-text' => 'Label for the input field on the insert reference dialog.',
	'wikieditor-toolbar-tool-signature' => '{{Identical|Signature with timestamp}}',
	'wikieditor-toolbar-section-advanced' => '{{Identical|Advanced}}',
	'wikieditor-toolbar-group-format' => '{{Identical|Format}}',
	'wikieditor-toolbar-tool-ulist' => '{{Identical|Bulleted list}}',
	'wikieditor-toolbar-tool-olist' => '{{Identical|Numbered list}}',
	'wikieditor-toolbar-tool-nowiki' => 'This is the text that appears when you hover the mouse over the third button from the right on the edit toolbar.',
	'wikieditor-toolbar-tool-redirect' => "Tooltip for icon to place wiki text for a redirect in the edit box. The label before these icons says 'Insert'. 'Redirect' is a noun here.
{{Identical|Redirect}}",
	'wikieditor-toolbar-tool-redirect-example' => "Target is an adjective describing the page name. You could use 'destination' instead of 'target'. 'Target page name' is the destination of the redirect and appears when the wikitext for a redirect is inserted in the text box thus
 <nowiki>#REDIRECT [[target page name]]</nowiki>",
	'wikieditor-toolbar-tool-small' => '{{Identical|Small}}',
	'wikieditor-toolbar-group-insert' => '{{Identical|Insert}}',
	'wikieditor-toolbar-tool-table' => '{{Identical|Table}}',
	'wikieditor-toolbar-tool-table-example-cell-text' => '[[File:Wikieditor-toolbar-tool-table.png|thumb]] See screenshot.',
	'wikieditor-toolbar-tool-table-example-header' => '[[File:Wikieditor-toolbar-tool-table.png|thumb]] See screenshot.',
	'wikieditor-toolbar-tool-table-title' => '[[File:Wikieditor-toolbar-tool-table.png|thumb]] See screenshot.',
	'wikieditor-toolbar-tool-table-dimensions-rows' => '[[File:Wikieditor-toolbar-tool-table.png|thumb]] See screenshot.',
	'wikieditor-toolbar-tool-table-dimensions-columns' => '[[File:Wikieditor-toolbar-tool-table.png|thumb]] See screenshot.',
	'wikieditor-toolbar-tool-table-dimensions-header' => '[[File:Wikieditor-toolbar-tool-table.png|thumb]] See screenshot.',
	'wikieditor-toolbar-tool-table-wikitable' => '[[File:Wikieditor-toolbar-tool-table.png|thumb]] See screenshot.',
	'wikieditor-toolbar-tool-table-sortable' => '[[File:Wikieditor-toolbar-tool-table.png|thumb]] See screenshot.',
	'wikieditor-toolbar-tool-table-example' => '{{Identical|Example}}
  [[File:Wikieditor-toolbar-tool-table.png|thumb]]This is a noun. Important to indicate that this is not a preview of what the table will look like, but an example of what it will look similar to. See screenshot.',
	'wikieditor-toolbar-tool-table-preview' => '{{Identical|Preview}}

[[File:Wikieditor-toolbar-tool-table.png|thumb]]This is a noun. See screenshot.',
	'wikieditor-toolbar-tool-table-insert' => '{{Identical|Insert}}

[[File:Wikieditor-toolbar-tool-table.png|thumb]] See screenshot.',
	'wikieditor-toolbar-tool-table-cancel' => '{{Identical|Cancel}}',
	'wikieditor-toolbar-tool-table-example-text' => '{{optional}}
Placeholder text to help the table example appear to be in the context of an article. Should be lorem ipsum, or equivalent.',
	'wikieditor-toolbar-tool-table-toomany' => '[[file:Bulbgraph.png|left|22px]]
This message does not support PLURAL on $1.',
	'wikieditor-toolbar-tool-replace' => '{{Identical|Search and replace}}',
	'wikieditor-toolbar-tool-replace-title' => '{{Identical|Search and replace}}',
	'wikieditor-toolbar-tool-replace-search' => '{{Identical|Search}}',
	'wikieditor-toolbar-tool-replace-case' => 'This could as well be translated as "case sensitive search" -
"case" refers to character case, that is upper case, or lower case.',
	'wikieditor-toolbar-tool-replace-regex' => 'A "regular expression" is a syntax to find strings based on patterns, for more see [[wikipedia:Regular expression|the Wikipedia article]].

More notes:
* "Regular expression" is mostly a programmer tool, which is sometimes exposed to normal users too. It\'s almost as an programming language, but it is used to describe different kinds of strings (sometimes also called patterns and pattern matching), and is often used to change (parts of) the strings too.',
	'wikieditor-toolbar-tool-replace-button-replace' => '{{Identical|Replace}}',
	'wikieditor-toolbar-tool-replace-close' => '{{Identical|Close}}',
	'wikieditor-toolbar-tool-replace-success' => '[[file:Bulbgraph.png|left|22px]]
This message does not support PLURAL on $1.',
	'wikieditor-toolbar-tool-replace-invalidregex' => '$1 is a browser-supplied error message, probably in English, possibly in the browser language.

A "regular expression" is a syntax to find strings based on patterns, for more see [[wikipedia:Regular expression|the Wikipedia article]].

Regular expressions are mostly a programmer tool, which is sometimes exposed to normal users too. It\'s almost as an programming language, but it is used to describe different kinds of strings (sometimes also called patterns and pattern matching), and is often used to change (parts of) the strings too.',
	'wikieditor-toolbar-section-characters' => 'This will be a toolbar for special characters, like emoticons.
For more information, see http://www.mediawiki.org/wiki/Extension:WikiEditor/Toolbar_customization',
	'wikieditor-toolbar-characters-page-latin' => 'This is the name of a script, or alphabet, not a language',
	'wikieditor-toolbar-characters-page-latinextended' => 'The name of the Latin Extended character set section of the toolbar.
For more information, see http://www.mediawiki.org/wiki/Extension:WikiEditor/Toolbar_customization',
	'wikieditor-toolbar-characters-page-ipa' => 'IPA means a script: "international phonetic alphabet" here, and not "international phonetic association", the organization behind it.',
	'wikieditor-toolbar-characters-page-symbols' => 'The section name for symbols on the wiki-toolbar.
For more information, see http://www.mediawiki.org/wiki/Extension:WikiEditor/Toolbar_customization',
	'wikieditor-toolbar-characters-page-greek' => 'This is the name of a script, or alphabet, not a language.',
	'wikieditor-toolbar-characters-page-cyrillic' => 'This is the name of a script, or a group of alphabets, used mainly in Eastern Europe and North and Central Asia.',
	'wikieditor-toolbar-characters-page-arabic' => 'This is the name of a script, or alphabet, not a language.',
	'wikieditor-toolbar-characters-page-arabicextended' => 'This is a description of the additional group of Arabic script characters for languages such as a Persian, Urdu, Pashto and others. This message is supposed to be similar to {{msg-mw|Wikieditor-toolbar-characters-page-latinextended}}.',
	'wikieditor-toolbar-characters-page-persian' => 'The name of the Persian character set (alphabet) on the toolbar.
For more information, see http://www.mediawiki.org/wiki/Extension:WikiEditor/Toolbar_customization',
	'wikieditor-toolbar-characters-page-hebrew' => 'This is the name of a script, or alphabet, not a language.',
	'wikieditor-toolbar-characters-page-bangla' => 'The name of the [[w:Bengali alphabet|Bangla]] (a.k.a. Bengali) character set (alphabet) on the toolbar.
For more information, see http://www.mediawiki.org/wiki/Extension:WikiEditor/Toolbar_customization',
	'wikieditor-toolbar-characters-page-tamil' => 'The name of the [[w:Tamil_Script#Numerals_and_symbols|Tamil]] numerals and symbols on the toolbar.
For more information, see http://www.mediawiki.org/wiki/Extension:WikiEditor/Toolbar_customization',
	'wikieditor-toolbar-characters-page-telugu' => 'The name of the [[w:Telugu language#Alphabet|Telugu]] character set (alphabet) on the toolbar.
For more information, see http://www.mediawiki.org/wiki/Extension:WikiEditor/Toolbar_customization',
	'wikieditor-toolbar-section-help' => '{{Identical|Help}}',
	'wikieditor-toolbar-help-heading-description' => '{{Identical|Description}}',
	'wikieditor-toolbar-help-page-link' => '{{Identical|Links}}',
	'wikieditor-toolbar-help-page-list' => '{{Identical|List}}',
	'wikieditor-toolbar-help-page-file' => '{{Identical|File}}',
	'wikieditor-toolbar-help-page-reference' => '{{Identical|Reference}}',
	'wikieditor-toolbar-help-page-discussion' => '{{Identical|Discussion}}',
	'wikieditor-toolbar-help-content-italic-description' => '{{Identical|Italic}}',
	'wikieditor-toolbar-help-content-italic-syntax' => '{{Identical|Italic text}}',
	'wikieditor-toolbar-help-content-italic-result' => '{{Identical|Italic text}}',
	'wikieditor-toolbar-help-content-bold-description' => '{{Identical|Bold}}',
	'wikieditor-toolbar-help-content-bold-syntax' => '{{Identical|Bold text}}',
	'wikieditor-toolbar-help-content-bold-result' => '{{Identical|Bold text}}',
	'wikieditor-toolbar-help-content-bolditalic-description' => '"& amp;" is displayed as &. It means "and".',
	'wikieditor-toolbar-help-content-bolditalic-syntax' => '"& amp;" is displayed as &. It means "and".',
	'wikieditor-toolbar-help-content-bolditalic-result' => '"& amp;" is displayed as &. It means "and".',
	'wikieditor-toolbar-help-content-ilink-description' => '{{Identical|Internal link}}',
	'wikieditor-toolbar-help-content-xlink-description' => '{{Identical|External link}}',
	'wikieditor-toolbar-help-content-xlink-syntax' => "www.example.org is not a real website, but it has been reserved to use in software documentation. If you translate the word example and try to go to that web address then you might get a message that it doesn't exist. But somebody may have created a commercial web page for that address, such as www.Beispiel.org, using the German word for example. It is therefore recommended that you do not translate http://www.example.org at all. If you do wish to translate it you should first check where the translated link takes you.",
	'wikieditor-toolbar-help-content-xlink-result' => "www.example.org is not a real website, but it has been reserved to use in software documentation. If you translate the word example and try to go to that web address then you might get a message that it doesn't exist. But somebody may have created a commercial web page for that address, such as www.Beispiel.org, using the German word for example. It is therefore recommended that you do not translate http://www.example.org at all. If you do wish to translate it you should first check where the translated link takes you.",
	'wikieditor-toolbar-help-content-heading2-syntax' => '{{Identical|Heading text}}',
	'wikieditor-toolbar-help-content-heading2-result' => '{{Identical|Heading text}}',
	'wikieditor-toolbar-help-content-heading3-syntax' => '{{Identical|Heading text}}',
	'wikieditor-toolbar-help-content-heading3-result' => '{{Identical|Heading text}}',
	'wikieditor-toolbar-help-content-heading4-syntax' => '{{Identical|Heading text}}',
	'wikieditor-toolbar-help-content-heading4-result' => '{{Identical|Heading text}}',
	'wikieditor-toolbar-help-content-heading5-syntax' => '{{Identical|Heading text}}',
	'wikieditor-toolbar-help-content-heading5-result' => '{{Identical|Heading text}}',
	'wikieditor-toolbar-help-content-ulist-description' => '{{Identical|Bulleted list}}',
	'wikieditor-toolbar-help-content-olist-description' => '{{Identical|Numbered list}}',
	'wikieditor-toolbar-help-content-file-description' => '{{Identical|Embedded file}}',
	'wikieditor-toolbar-help-content-file-syntax' => "{{doc-important|''thumb'' is a magic word. Leave it untranslated!}}",
	'wikieditor-toolbar-help-content-file-result' => '{{doc-important|Do not translate anything except "Caption text" (twice) and "Enlarge" (to "{{int:thumbnail-more}}").}}',
	'wikieditor-toolbar-help-content-reference-description' => '{{Identical|Reference}}',
	'wikieditor-toolbar-help-content-reference-syntax' => 'I suggest leaving the <code>name="test"</code> string in English

www.example.org is not a real website, but it has been reserved to use in software documentation. If you translate the word example and try to go to that web address then you might get a message that it doesn\'t exist. But somebody may have created a commercial web page for that address, such as www.Beispiel.org, using the German word for example. It is therefore recommended that you do not translate http://www.example.org at all. If you do wish to translate it you should first check where the translated link takes you.',
	'wikieditor-toolbar-help-content-rereference-syntax' => '{{Optional}}',
	'wikieditor-toolbar-help-content-showreferences-syntax' => '{{Optional}}',
	'wikieditor-toolbar-help-content-showreferences-result' => 'For the <code><nowiki><li></nowiki></code> tag’s <code>id</code> attribute, non-ASCII characters are URL-encoded as follows: a period (<code>.</code>) followed by a capital hexadecimal code. For example, <code><nowiki><ref name="thử"></nowiki></code> produces <code><nowiki><li id="cite_note-th.E1.BB.AD-0"></nowiki></code>.

www.example.org is not a real website, but it has been reserved to use in software documentation. If you translate the word example and try to go to that web address then you might get a message that it doesn\'t exist. But somebody may have created a commercial web page for that address, such as www.Beispiel.org, using the German word for example. It is therefore recommended that you do not translate http://www.example.org at all. If you do wish to translate it you should first check where the translated link takes you.',
	'wikieditor-toolbar-help-content-signaturetimestamp-description' => '{{Identical|Signature with timestamp}}',
	'wikieditor-toolbar-help-content-signature-description' => '{{Identical|Signature}}',
);

/** Abkhazian (Аҧсшәа)
 * @author Temuri rajavi
 */
$messages['ab'] = array(
	'wikieditor-toolbar-characters-page-latin' => 'Алаҭын',
	'wikieditor-toolbar-characters-page-greek' => 'Аберзентә',
	'wikieditor-toolbar-characters-page-cyrillic' => 'Акирилица',
	'wikieditor-toolbar-characters-page-arabic' => 'Араҧтә',
	'wikieditor-toolbar-section-help' => 'Ацхыраара',
	'wikieditor-toolbar-help-page-file' => 'Афаилқәа',
	'wikieditor-toolbar-help-page-discussion' => 'Ахцәажәара',
	'wikieditor-toolbar-help-content-signature-result' => "<a href='#' title='Special:MyPage'> Алахәыла ахьʒ</a> (<a href='#' title='Special:MyTalk'> ахцәажәара </a>)",
);

/** Afrikaans (Afrikaans)
 * @author Adriaan
 * @author Anrie
 * @author Naudefj
 * @author පසිඳු කාවින්ද
 */
$messages['af'] = array(
	'wikieditor' => 'Uitgebreide teksverwerker vir wikiteks',
	'wikieditor-desc' => "Voorsien 'n uitbreibare wikiteks-verwerker en modules met bykomende funksies",
	'wikieditor-wikitext-tab' => 'Wikiteks',
	'wikieditor-loading' => 'Laai tans',
	'wikieditor-preview-preference' => 'Wysig en voorskou langs mekaar',
	'wikieditor-preview-tab' => 'Voorskou',
	'wikieditor-preview-changes-tab' => 'Wysigings',
	'wikieditor-preview-loading' => 'Besig om te laai...',
	'wikieditor-previewDialog-preference' => 'Aktiveer voorskou-dialoog',
	'wikieditor-previewDialog-tab' => 'Voorskou',
	'wikieditor-previewDialog-loading' => 'Besig om te laai...',
	'wikieditor-publish-preference' => 'Aktiveer stap-vir-stap publisering',
	'wikieditor-publish-button-publish' => 'Publiseer',
	'wikieditor-publish-button-cancel' => 'Kanselleer',
	'wikieditor-publish-dialog-title' => 'Publiseer na {{SITENAME}}',
	'wikieditor-publish-dialog-summary' => 'Wysigingsopsomming (beskryf kortliks wat u verander het):',
	'wikieditor-publish-dialog-minor' => 'Klein wysiging',
	'wikieditor-publish-dialog-watch' => 'Hou die bladsy dop',
	'wikieditor-publish-dialog-publish' => 'Publiseer',
	'wikieditor-publish-dialog-goback' => 'Terug',
	'wikieditor-template-editor-preference' => 'Aktiveer vorm-gebaseerde wysiging van wikisjablone',
	'wikieditor-template-editor-dialog-title' => 'Wysig sjabloon',
	'wikieditor-template-editor-dialog-submit' => 'Bywerk',
	'wikieditor-template-editor-dialog-cancel' => 'Kanselleer',
	'wikieditor-templates-preference' => 'Inklapbare sjablone toelaat',
	'wikieditor-toc-preference' => 'Aktiveer navigeerbare inhoudsopgawe',
	'wikieditor-toc-show' => 'Wys inhoud',
	'wikieditor-toc-hide' => 'Versteek inhoud',
	'wikieditor-toolbar' => 'Wysigingswerksbalk',
	'wikieditor-toolbar-desc' => 'Wysigingsbalk met verhoogde bruikbaarheid',
	'wikieditor-toolbar-preference' => 'Gebruik gevorderde redigeringsbalk',
	'wikieditor-toolbar-dialogs-preference' => 'Aktiveer dialoog vir die byvoeging van skakels, tabelle en meer',
	'wikieditor-toolbar-hidesig' => 'Steek die ondertekening knoppie van die bladsye in die hoof naamruimte',
	'wikieditor-toolbar-loading' => 'Besig om te laai...',
	'wikieditor-toolbar-tool-bold' => 'Vetdruk',
	'wikieditor-toolbar-tool-bold-example' => 'Vetgedrukte teks',
	'wikieditor-toolbar-tool-italic' => 'Skuinsdruk',
	'wikieditor-toolbar-tool-italic-example' => 'Skuinsgedrukte teks',
	'wikieditor-toolbar-tool-ilink' => 'Interne skakel',
	'wikieditor-toolbar-tool-ilink-example' => 'Skakel se titel',
	'wikieditor-toolbar-tool-xlink' => 'Eksterne skakel (onthou http:// vooraan)',
	'wikieditor-toolbar-tool-xlink-example' => 'http://www.voorbeeld.co.za skakel se titel',
	'wikieditor-toolbar-tool-link' => 'Skakel',
	'wikieditor-toolbar-tool-link-title' => 'Voeg skakel by',
	'wikieditor-toolbar-tool-link-int' => "Na 'n wikibladsy",
	'wikieditor-toolbar-tool-link-int-target' => 'Bladsynaam:',
	'wikieditor-toolbar-tool-link-int-target-tooltip' => 'Bladsynaam of URL',
	'wikieditor-toolbar-tool-link-int-text' => 'Skakel se teks:',
	'wikieditor-toolbar-tool-link-int-text-tooltip' => 'Sleutel die teks wat vertoon moet word in',
	'wikieditor-toolbar-tool-link-ext' => "Na 'n eksterne webbladsy",
	'wikieditor-toolbar-tool-link-ext-target' => 'URL:',
	'wikieditor-toolbar-tool-link-ext-text' => 'Skakel se teks:',
	'wikieditor-toolbar-tool-link-insert' => 'Skakel byvoeg',
	'wikieditor-toolbar-tool-link-cancel' => 'kanselleer',
	'wikieditor-toolbar-tool-link-int-target-status-exists' => 'Die bladsy bestaan al',
	'wikieditor-toolbar-tool-link-int-target-status-notexists' => 'Die bladsy bestaan nie',
	'wikieditor-toolbar-tool-link-int-target-status-invalid' => 'Ongeldige bladsynaam',
	'wikieditor-toolbar-tool-link-int-target-status-external' => 'Eksterne skakel',
	'wikieditor-toolbar-tool-link-int-target-status-loading' => 'Kontroleer of die bladsy reeds bestaan...',
	'wikieditor-toolbar-tool-link-int-invalid' => 'Die titel wat u verskaf het is ongeldig.',
	'wikieditor-toolbar-tool-link-lookslikeinternal' => "Die URL wat u verskaf het lyk asof dit bedoel is as skakel na 'n ander wikibladsy.
Wil u dit na 'n interne skakel verander?",
	'wikieditor-toolbar-tool-link-lookslikeinternal-int' => 'Interne skakel',
	'wikieditor-toolbar-tool-link-lookslikeinternal-ext' => 'Eksterne skakel',
	'wikieditor-toolbar-tool-link-empty' => 'U het niks ingesleutel om na te skakel nie.',
	'wikieditor-toolbar-tool-file' => 'Ingebedde lêer',
	'wikieditor-toolbar-tool-file-example' => 'Voorbeeld.jpg',
	'wikieditor-toolbar-file-target' => 'Lêernaam:',
	'wikieditor-toolbar-file-caption' => 'Byskrif:',
	'wikieditor-toolbar-file-size' => 'Grootte:',
	'wikieditor-toolbar-file-format' => 'Formaat:',
	'wikieditor-toolbar-tool-file-insert' => 'Invoeg',
	'wikieditor-toolbar-tool-file-cancel' => 'Kanselleer',
	'wikieditor-toolbar-tool-reference' => 'Verwysing',
	'wikieditor-toolbar-tool-reference-example' => 'Voeg teks vir voetnota hier in',
	'wikieditor-toolbar-tool-reference-cancel' => 'Kanselleer',
	'wikieditor-toolbar-tool-reference-title' => 'Verwysing invoeg',
	'wikieditor-toolbar-tool-reference-insert' => 'Invoeg',
	'wikieditor-toolbar-tool-reference-text' => 'Verwysingteks',
	'wikieditor-toolbar-tool-signature' => 'Handtekening en tydstempel',
	'wikieditor-toolbar-section-advanced' => 'Gevorderde funksies',
	'wikieditor-toolbar-tool-heading' => 'Opskrif',
	'wikieditor-toolbar-tool-heading-1' => 'Vlak 1',
	'wikieditor-toolbar-tool-heading-2' => 'Vlak 2',
	'wikieditor-toolbar-tool-heading-3' => 'Vlak 3',
	'wikieditor-toolbar-tool-heading-4' => 'Vlak 4',
	'wikieditor-toolbar-tool-heading-5' => 'Vlak 5',
	'wikieditor-toolbar-tool-heading-example' => 'Opskrifteks',
	'wikieditor-toolbar-group-format' => 'Formatteer:',
	'wikieditor-toolbar-tool-ulist' => 'Ongenommerde lys',
	'wikieditor-toolbar-tool-ulist-example' => 'Lyn in ongenommerde lys',
	'wikieditor-toolbar-tool-olist' => 'Genommerde lys',
	'wikieditor-toolbar-tool-olist-example' => 'Lyn in genommerde lys',
	'wikieditor-toolbar-tool-indent' => 'Indentasie',
	'wikieditor-toolbar-tool-indent-example' => 'Ingekeepte lyn',
	'wikieditor-toolbar-tool-nowiki' => 'Geen wiki-formattering',
	'wikieditor-toolbar-tool-nowiki-example' => 'Ongeformatteerde teks hier invoeg',
	'wikieditor-toolbar-tool-redirect' => 'Aanstuur',
	'wikieditor-toolbar-tool-redirect-example' => 'Teikenbladsynaam',
	'wikieditor-toolbar-tool-big' => 'Groot',
	'wikieditor-toolbar-tool-big-example' => 'Groot gedrukte teks',
	'wikieditor-toolbar-tool-small' => 'Klein',
	'wikieditor-toolbar-tool-small-example' => 'Klein gedrukte teks',
	'wikieditor-toolbar-tool-superscript' => 'Boskrif',
	'wikieditor-toolbar-tool-superscript-example' => 'Teks in boskrif',
	'wikieditor-toolbar-tool-subscript' => 'Onderskrif',
	'wikieditor-toolbar-tool-subscript-example' => 'Teks in onderskrif',
	'wikieditor-toolbar-group-insert' => 'Invoeg',
	'wikieditor-toolbar-tool-gallery' => 'Fotogalery',
	'wikieditor-toolbar-tool-gallery-example' => '$1:Voorbeeld1|Byskrif1
$1:Voorbeeld2|Byskrif2',
	'wikieditor-toolbar-tool-newline' => 'Nuwe lyn',
	'wikieditor-toolbar-tool-table' => 'Tabel',
	'wikieditor-toolbar-tool-table-example-old' => '-
! opskrif 1
! opskrif 2
! opskrif 3
|-
| ry 1, sel 1
| ry 1, sel 2
| ry 1, sel 3
|-
| ry 2, sel 1
| ry 2, sel 2
| ry 2, sel 3',
	'wikieditor-toolbar-tool-table-example-cell-text' => 'Selteks',
	'wikieditor-toolbar-tool-table-example-header' => 'Opskrifteks',
	'wikieditor-toolbar-tool-table-title' => 'Voeg tabel in',
	'wikieditor-toolbar-tool-table-dimensions-rows' => 'Rye',
	'wikieditor-toolbar-tool-table-dimensions-columns' => 'Kolomme',
	'wikieditor-toolbar-tool-table-dimensions-header' => 'Voeg opskriflyn in',
	'wikieditor-toolbar-tool-table-wikitable' => 'Styl met rante',
	'wikieditor-toolbar-tool-table-sortable' => 'Maak tabel sorteerbaar',
	'wikieditor-toolbar-tool-table-example' => 'Selteks',
	'wikieditor-toolbar-tool-table-preview' => 'Voorskou',
	'wikieditor-toolbar-tool-table-insert' => 'Invoeg',
	'wikieditor-toolbar-tool-table-cancel' => 'Kanselleer',
	'wikieditor-toolbar-tool-table-toomany' => "U kan nie 'n tabel met meer as $1 selle met die dialoog invoeg nie.",
	'wikieditor-toolbar-tool-table-invalidnumber' => "U het 'n ongeldige aantal lyne of kolomme verskaf.",
	'wikieditor-toolbar-tool-table-zero' => "U kan nie 'n tabel sonder lyne en kolomme invoeg nie.",
	'wikieditor-toolbar-tool-replace' => 'Soek en vervang',
	'wikieditor-toolbar-tool-replace-title' => 'Soek en vervang',
	'wikieditor-toolbar-tool-replace-search' => 'Soek na:',
	'wikieditor-toolbar-tool-replace-replace' => 'Vervang met:',
	'wikieditor-toolbar-tool-replace-case' => 'Gevoelig vir hoofletters',
	'wikieditor-toolbar-tool-replace-regex' => 'Hanteer die soekstring as \'n "regular expression"',
	'wikieditor-toolbar-tool-replace-button-findnext' => 'Vind volgende',
	'wikieditor-toolbar-tool-replace-button-replace' => 'Vervang',
	'wikieditor-toolbar-tool-replace-button-replaceall' => 'Vervang alles',
	'wikieditor-toolbar-tool-replace-close' => 'Sluit',
	'wikieditor-toolbar-tool-replace-nomatch' => 'U soektog het geen resultate opgelewer nie.',
	'wikieditor-toolbar-tool-replace-success' => '$1 vervangings gemaak.',
	'wikieditor-toolbar-tool-replace-emptysearch' => 'U het niks ingesleutel om na te soek nie.',
	'wikieditor-toolbar-tool-replace-invalidregex' => 'Die "regular expression" wat u verskaf het is ongeldig: $1',
	'wikieditor-toolbar-section-characters' => 'Spesiale karakters',
	'wikieditor-toolbar-characters-page-latin' => 'Latyns',
	'wikieditor-toolbar-characters-page-latinextended' => 'Latyns uitgebreid',
	'wikieditor-toolbar-characters-page-ipa' => 'IFA',
	'wikieditor-toolbar-characters-page-symbols' => 'Simbole',
	'wikieditor-toolbar-characters-page-greek' => 'Grieks',
	'wikieditor-toolbar-characters-page-cyrillic' => 'Cyrillies',
	'wikieditor-toolbar-characters-page-arabic' => 'Arabies',
	'wikieditor-toolbar-characters-page-arabicextended' => 'Arabies uitgebrei',
	'wikieditor-toolbar-characters-page-persian' => 'Persiese',
	'wikieditor-toolbar-characters-page-hebrew' => 'Hebreeus',
	'wikieditor-toolbar-characters-page-bangla' => 'Bengaals',
	'wikieditor-toolbar-characters-page-tamil' => 'Tamil',
	'wikieditor-toolbar-characters-page-telugu' => 'Telugu',
	'wikieditor-toolbar-characters-page-sinhala' => 'Sinhala',
	'wikieditor-toolbar-characters-page-gujarati' => 'Gujarati',
	'wikieditor-toolbar-characters-page-devanagari' => 'Devanagari',
	'wikieditor-toolbar-characters-page-thai' => 'Thai',
	'wikieditor-toolbar-characters-page-lao' => 'Lao',
	'wikieditor-toolbar-characters-page-khmer' => 'Khmer',
	'wikieditor-toolbar-section-help' => 'Hulp',
	'wikieditor-toolbar-help-heading-description' => 'Beskrywing',
	'wikieditor-toolbar-help-heading-syntax' => 'Wat u tik',
	'wikieditor-toolbar-help-heading-result' => 'Wat u sal sien',
	'wikieditor-toolbar-help-page-format' => 'Formatering',
	'wikieditor-toolbar-help-page-link' => 'Skakels',
	'wikieditor-toolbar-help-page-heading' => 'Opskrifte',
	'wikieditor-toolbar-help-page-list' => 'Lyste',
	'wikieditor-toolbar-help-page-file' => 'Lêers',
	'wikieditor-toolbar-help-page-reference' => 'Verwysings',
	'wikieditor-toolbar-help-page-discussion' => 'Bespreking',
	'wikieditor-toolbar-help-content-italic-description' => 'Kursief',
	'wikieditor-toolbar-help-content-italic-syntax' => "''Kursiewe teks''",
	'wikieditor-toolbar-help-content-italic-result' => '<em>Kursief gedrukte teks</em>',
	'wikieditor-toolbar-help-content-bold-description' => 'Vet',
	'wikieditor-toolbar-help-content-bold-syntax' => "'''Vetgedrukte teks'''",
	'wikieditor-toolbar-help-content-bold-result' => '<strong>Vetgedrukte teks</strong>',
	'wikieditor-toolbar-help-content-bolditalic-description' => 'Vet &amp; kursief',
	'wikieditor-toolbar-help-content-bolditalic-syntax' => "'''''Vet- en kursief gedrukte teks'''''",
	'wikieditor-toolbar-help-content-bolditalic-result' => '<em><strong>Vet- en kursief gedrukte teks</strong></em>',
	'wikieditor-toolbar-help-content-ilink-description' => 'Interne skakel',
	'wikieditor-toolbar-help-content-ilink-syntax' => '[[Bladsynaam|Skakel se teks]]<br />[[Bladsynaam]]',
	'wikieditor-toolbar-help-content-ilink-result' => "<a href='#'>Etiket van skakel</a><br /><a href='#'>Bladsynaam</a>",
	'wikieditor-toolbar-help-content-xlink-description' => 'Eksterne skakel',
	'wikieditor-toolbar-help-content-xlink-syntax' => '[http://www.voorbeeld.org Skakel se etiket]<br />[http://www.voorbeeld.org]<br />http://www.voorbeeld.org',
	'wikieditor-toolbar-help-content-xlink-result' => "<a href='#' class='external'>Skakel se etiket</a><br /><a href='#' class='external autonumber'>[1]</a><br /><a href='#' class='external'>http://www.voorbeeld.org</a>",
	'wikieditor-toolbar-help-content-heading2-description' => 'Vlak 2 opskrif',
	'wikieditor-toolbar-help-content-heading2-syntax' => '== Opskrifteks ==',
	'wikieditor-toolbar-help-content-heading2-result' => '<h2>Opskrifteks</h2>',
	'wikieditor-toolbar-help-content-heading3-description' => 'Vlak 3 opskrif',
	'wikieditor-toolbar-help-content-heading3-syntax' => '=== Opskrifteks ===',
	'wikieditor-toolbar-help-content-heading3-result' => '<h3>Opskrifteks</h3>',
	'wikieditor-toolbar-help-content-heading4-description' => 'Vlak 4 opskrif',
	'wikieditor-toolbar-help-content-heading4-syntax' => '==== Opskrifteks ====',
	'wikieditor-toolbar-help-content-heading4-result' => '<h4>Opskrifteks</h4>',
	'wikieditor-toolbar-help-content-heading5-description' => 'Vlak 5 opskrif',
	'wikieditor-toolbar-help-content-heading5-syntax' => '===== Opskrifteks =====',
	'wikieditor-toolbar-help-content-heading5-result' => '<h5>Opskrifteks</h5>',
	'wikieditor-toolbar-help-content-ulist-description' => 'Ongenommerde lys',
	'wikieditor-toolbar-help-content-ulist-syntax' => '* Lyn in ongenommerde lys<br />* Lyn in ongenommerde lys',
	'wikieditor-toolbar-help-content-ulist-result' => '<ul><li>Lyn in ongenommerde lys</li><li>Lyn in ongenommerde lys</li></ul>',
	'wikieditor-toolbar-help-content-olist-description' => 'Genommerde lys',
	'wikieditor-toolbar-help-content-olist-syntax' => '# Lyn in genommerde lys<br /># Lyn in genommerde lys',
	'wikieditor-toolbar-help-content-olist-result' => '<ol><li>Lyn in genommerde lys</li><li>Lyn in genommerde lys</li></ol>',
	'wikieditor-toolbar-help-content-file-description' => 'Ingebedde lêer',
	'wikieditor-toolbar-help-content-file-syntax' => '[[$1:Voorbeeld.png|thumb|Byskrif]]',
	'wikieditor-toolbar-help-content-file-result' => "<div style='width:104px;' class='thumbinner'><a title='Byskrif' class='image' href='#'><img height='50' width='100' border='0' class='thumbimage' src='$2/WikiEditor/modules/images/toolbar/example-image.png' alt=''/></a><div class='thumbcaption'><div class='magnify'><a title='Vergroot' class='internal' href='#'><img height='11' width='15' alt='' src='$1/common/images/magnify-clip.png'/></a></div>Byskrif</div></div>",
	'wikieditor-toolbar-help-content-reference-description' => 'Verwysing',
	'wikieditor-toolbar-help-content-reference-syntax' => 'Bladsyteks.&lt;ref name="test"&gt;[http://www.voorbeeld.org Skakel se teks], addisionele teks.&lt;/ref&gt;',
	'wikieditor-toolbar-help-content-reference-result' => "Bladsyteks <sup><a href='#'>[1]</a></sup>",
	'wikieditor-toolbar-help-content-rereference-description' => 'Hergebruik van dieselfde verwysing',
	'wikieditor-toolbar-help-content-rereference-result' => "Bladsyteks <sup><a href='#'>[1]</a></sup>",
	'wikieditor-toolbar-help-content-showreferences-description' => 'Wys verwysings',
	'wikieditor-toolbar-help-content-showreferences-result' => "<ol class='references'><li id='cite_note-test-0'><b><a title='' href='#'>^</a></b> <a rel='nofollow' title='http://www.voorbeeld.org' class='external text' href='#'>Skakel se teks</a>, addisionele teks.</li></ol>",
	'wikieditor-toolbar-help-content-signaturetimestamp-description' => 'Handtekening met tydstempel',
	'wikieditor-toolbar-help-content-signaturetimestamp-result' => "<a href='#' title='{{#special:mypage}}'>Gebruikersnaam</a> (<a href='#' title='{{#special:mytalk}}'>bespreking</a>) 15:54, 10 Junie 2009 (UTC)",
	'wikieditor-toolbar-help-content-signature-description' => 'Handtekening',
	'wikieditor-toolbar-help-content-signature-result' => "<a href='#' title='{{#special:mypage}}'>Gebruikersnaam</a> (<a href='#' title='{{#special:mytalk}}'>bespreking</a>)",
	'wikieditor-toolbar-help-content-indent-description' => 'Indenteer',
	'wikieditor-toolbar-help-content-indent-syntax' => 'Normale teks<br />: Geïndenteerde teks<br />::Geïndenteerde teks',
	'wikieditor-toolbar-help-content-indent-result' => 'Normale teks<dl><dd>Geïndenteerde teks<dl><dd>Geïndenteerde teks</dd></dl></dd></dl>',
);

/** Gheg Albanian (Gegë)
 * @author Mdupont
 */
$messages['aln'] = array(
	'wikieditor' => 'redaktimi i avancuar wikitext interface',
	'wikieditor-desc' => 'Siguron një ndërfaqe të vazhdohet redaktimi wikitext dhe module shumë me metrazh të siguruar',
	'wikieditor-wikitext-tab' => 'Wikitext',
	'wikieditor-loading' => 'Ngarkim',
	'wikieditor-preview-preference' => 'Aktivizo-krah për krah preview',
	'wikieditor-preview-tab' => 'Preview',
	'wikieditor-preview-changes-tab' => 'Ndryshimet',
	'wikieditor-preview-loading' => 'Loading ...',
	'wikieditor-previewDialog-tab' => 'Preview',
	'wikieditor-previewDialog-loading' => 'Loading ...',
	'wikieditor-publish-preference' => 'Aktivizo-hap pas hapi botuese',
	'wikieditor-publish-button-publish' => 'Publikoj',
	'wikieditor-publish-button-cancel' => 'Anuloj',
	'wikieditor-publish-dialog-title' => 'Publikimi në {{SITENAME}}',
	'wikieditor-publish-dialog-summary' => 'përmbledhje Edit (përshkruaj shkurtimisht ndryshimet që keni bërë):',
	'wikieditor-publish-dialog-minor' => 'Minor redakto',
	'wikieditor-publish-dialog-watch' => 'Watch këtë faqe',
	'wikieditor-publish-dialog-publish' => 'Publikoj',
	'wikieditor-publish-dialog-goback' => 'Kthehem',
	'wikieditor-template-editor-preference' => 'Lejo redaktimin e bazuar në formë të wiki templates',
	'wikieditor-template-editor-dialog-title' => 'Edit template',
	'wikieditor-template-editor-dialog-submit' => 'Update',
	'wikieditor-template-editor-dialog-cancel' => 'Anuloj',
	'wikieditor-templates-preference' => 'Aktivizo template kolaps',
	'wikieditor-toc-preference' => 'Tabela e përmbajtjeve Aktivizo lundrueshëm',
	'wikieditor-toc-show' => 'Përmbajtja Show',
	'wikieditor-toc-hide' => 'Përmbajtja Hide',
	'wikieditor-toolbar' => 'Editing toolbar',
	'wikieditor-toolbar-desc' => 'toolbar Redakto faqe me të përdorshmërisë zgjeruar',
	'wikieditor-toolbar-preference' => 'Lejo redaktimin zgjeruar toolbar',
	'wikieditor-toolbar-dialogs-preference' => 'dialogs Aktivizo për futjen e lidhjeve, tavolina dhe më shumë',
	'wikieditor-toolbar-loading' => 'Loading ...',
	'wikieditor-toolbar-tool-bold' => 'Guximtar',
	'wikieditor-toolbar-tool-bold-example' => 'Tekst i trashë',
	'wikieditor-toolbar-tool-italic' => 'Kursiv',
	'wikieditor-toolbar-tool-italic-example' => 'Teksti i pjerrët',
	'wikieditor-toolbar-tool-ilink' => 'Lidhje të Brendshme',
	'wikieditor-toolbar-tool-ilink-example' => 'Titulli Link',
	'wikieditor-toolbar-tool-xlink' => 'Lidhje e jashtme (most harro prefiksin http://)',
	'wikieditor-toolbar-tool-xlink-example' => 'Lidhje http://www.example.com Titulli',
	'wikieditor-toolbar-tool-link' => 'Lidhje',
	'wikieditor-toolbar-tool-link-title' => 'Vendos Lidhje',
	'wikieditor-toolbar-tool-link-int' => 'Për një faqe wiki',
	'wikieditor-toolbar-tool-link-int-target' => 'faqe synuar ose URL:',
	'wikieditor-toolbar-tool-link-int-target-tooltip' => 'Titulli i faqes ose URL',
	'wikieditor-toolbar-tool-link-int-text' => 'Tekst për të shfaqur:',
	'wikieditor-toolbar-tool-link-int-text-tooltip' => "Tekst për t'u shfaqur",
	'wikieditor-toolbar-tool-link-ext' => 'Për një faqe të jashtme interneti',
	'wikieditor-toolbar-tool-link-ext-target' => 'URL Link:',
	'wikieditor-toolbar-tool-link-ext-text' => 'text Link:',
	'wikieditor-toolbar-tool-link-insert' => 'Vendos Lidhje',
	'wikieditor-toolbar-tool-link-cancel' => 'Anuloj',
	'wikieditor-toolbar-tool-link-int-target-status-exists' => 'Page ekziston',
	'wikieditor-toolbar-tool-link-int-target-status-notexists' => 'Faqja nuk ekziston',
	'wikieditor-toolbar-tool-link-int-target-status-invalid' => 'Titulli i pavlefshëm',
	'wikieditor-toolbar-tool-link-int-target-status-external' => 'Lidhje e jashtme',
	'wikieditor-toolbar-tool-link-int-target-status-loading' => 'Kontrollit të ekzistencës faqe ...',
	'wikieditor-toolbar-tool-link-int-invalid' => 'Titulli ju specifikuar është i pavlefshëm.',
	'wikieditor-toolbar-tool-link-lookslikeinternal' => 'URL-in që të specifikuar duket si ajo ishte menduar si një lidhje në faqe të tjera wiki.
A doni ta bërë atë një lidhje të brendshme?',
	'wikieditor-toolbar-tool-link-lookslikeinternal-int' => 'Lidhje të Brendshme',
	'wikieditor-toolbar-tool-link-lookslikeinternal-ext' => 'Lidhje e jashtme',
	'wikieditor-toolbar-tool-link-empty' => 'Ju nuk kanë hyrë në ndonjë gjë për të link.',
	'wikieditor-toolbar-tool-file' => 'Embedded file',
	'wikieditor-toolbar-tool-file-example' => 'Example.jpg',
	'wikieditor-toolbar-tool-reference' => 'Referim',
	'wikieditor-toolbar-tool-reference-example' => 'Vendos tekst shënimin këtu',
	'wikieditor-toolbar-tool-reference-cancel' => 'Anuloj',
	'wikieditor-toolbar-tool-reference-title' => 'Fut referencë',
	'wikieditor-toolbar-tool-reference-insert' => 'Kall',
	'wikieditor-toolbar-tool-reference-text' => 'tekstit Referenca',
	'wikieditor-toolbar-tool-signature' => 'Nënshkrimi dhe gjithë kohë',
	'wikieditor-toolbar-section-advanced' => 'I avancuar',
	'wikieditor-toolbar-tool-heading' => 'Titull',
	'wikieditor-toolbar-tool-heading-1' => 'Niveli 1',
	'wikieditor-toolbar-tool-heading-2' => 'Niveli 2',
	'wikieditor-toolbar-tool-heading-3' => 'Niveli 3',
	'wikieditor-toolbar-tool-heading-4' => 'Niveli 4',
	'wikieditor-toolbar-tool-heading-5' => 'Niveli 5',
	'wikieditor-toolbar-tool-heading-example' => 'Titull tekst',
	'wikieditor-toolbar-group-format' => 'Format',
	'wikieditor-toolbar-tool-ulist' => 'Lista e bulleted',
	'wikieditor-toolbar-tool-ulist-example' => 'pika bulleted lista',
	'wikieditor-toolbar-tool-olist' => 'Lista e Numëruar',
	'wikieditor-toolbar-tool-olist-example' => 'pika Numëruar lista',
	'wikieditor-toolbar-tool-indent' => 'Gjurmë',
	'wikieditor-toolbar-tool-indent-example' => 'Shkarko prerë',
	'wikieditor-toolbar-tool-nowiki' => 'Nuk formatimit wiki',
	'wikieditor-toolbar-tool-nowiki-example' => 'Vendos tekst këtu nuk duhet të formatohet',
	'wikieditor-toolbar-tool-redirect' => 'Përcjellëse',
	'wikieditor-toolbar-tool-redirect-example' => 'Emri i synuar faqe',
	'wikieditor-toolbar-tool-big' => 'I madh',
	'wikieditor-toolbar-tool-big-example' => 'Big tekst',
	'wikieditor-toolbar-tool-small' => 'I vogël',
	'wikieditor-toolbar-tool-small-example' => 'tekstin e vogla',
	'wikieditor-toolbar-tool-superscript' => 'Indeks i sipërm',
	'wikieditor-toolbar-tool-superscript-example' => 'tekstit Sipërshkrim',
	'wikieditor-toolbar-tool-subscript' => 'Subscript',
	'wikieditor-toolbar-tool-subscript-example' => 'tekstit Subscript',
	'wikieditor-toolbar-group-insert' => 'Kall',
	'wikieditor-toolbar-tool-gallery' => 'galeri artesh',
	'wikieditor-toolbar-tool-gallery-example' => '$1: Example.jpg|Caption1
$1: Example.jpg|Caption2',
	'wikieditor-toolbar-tool-newline' => 'Linjë e re',
	'wikieditor-toolbar-tool-table' => 'Tryezë',
	'wikieditor-toolbar-tool-table-example-old' => '-
! header 1
! header 2
! header 3
|-
| rresht 1, qelizë 1
| rresht 1, qelizë 2
| rresht 1, qelizë 3
| -
| rresht 2, qelizë 1
| rresht 2, qelizë 2
| rresht 2, qelizë 3',
	'wikieditor-toolbar-tool-table-example-cell-text' => 'tekstit qelizë',
	'wikieditor-toolbar-tool-table-example-header' => 'tekstit Header',
	'wikieditor-toolbar-tool-table-title' => 'Fut tabelë',
	'wikieditor-toolbar-tool-table-dimensions-rows' => 'Rreshtave',
	'wikieditor-toolbar-tool-table-dimensions-columns' => 'Kolumne',
	'wikieditor-toolbar-tool-table-dimensions-header' => 'Shto rreshtit',
	'wikieditor-toolbar-tool-table-wikitable' => 'Logo me kufij',
	'wikieditor-toolbar-tool-table-sortable' => 'Bëni tryezë llojllojshme',
	'wikieditor-toolbar-tool-table-example' => 'Shembull',
	'wikieditor-toolbar-tool-table-preview' => 'Preview',
	'wikieditor-toolbar-tool-table-insert' => 'Kall',
	'wikieditor-toolbar-tool-table-cancel' => 'Anuloj',
	'wikieditor-toolbar-tool-table-toomany' => 'Futur një tavolinë me shumë se qelizat e $1 nuk është e mundur me këtë dialog.',
	'wikieditor-toolbar-tool-table-invalidnumber' => 'Ju nuk keni hyrë në një numër të vlefshme të rreshtave dhe kolonave.',
	'wikieditor-toolbar-tool-table-zero' => 'Ju nuk mund të vendos një tabelë me zero rreshta ose kolona.',
	'wikieditor-toolbar-tool-replace' => 'Kërkoni dhe zëvendësuar',
	'wikieditor-toolbar-tool-replace-title' => 'Kërkoni dhe zëvendësuar',
	'wikieditor-toolbar-tool-replace-search' => 'Kërko për:',
	'wikieditor-toolbar-tool-replace-replace' => 'Replace me:',
	'wikieditor-toolbar-tool-replace-case' => 'rast Match',
	'wikieditor-toolbar-tool-replace-regex' => 'string Silleni kërkim si një shprehje e rregullt',
	'wikieditor-toolbar-tool-replace-button-findnext' => 'Gjej të ardhshëm',
	'wikieditor-toolbar-tool-replace-button-replaceall' => 'Zëvendësojnë të gjithë',
	'wikieditor-toolbar-tool-replace-close' => 'Mshele',
	'wikieditor-toolbar-tool-replace-nomatch' => 'Kërkimi juaj nuk u përputh me ndonjë gjë.',
	'wikieditor-toolbar-tool-replace-success' => '$1 zëvendësimit (s) bëhet.',
	'wikieditor-toolbar-tool-replace-emptysearch' => 'Ju nuk shkruani ndonjë gjë për të kërkuar për.',
	'wikieditor-toolbar-tool-replace-invalidregex' => 'Shprehje e rregullt keni hyrë është i pavlefshëm: $1',
	'wikieditor-toolbar-section-characters' => 'karaktere të veçanta',
	'wikieditor-toolbar-characters-page-latin' => 'Latinisht',
	'wikieditor-toolbar-characters-page-latinextended' => 'Latine zgjeruar',
	'wikieditor-toolbar-characters-page-ipa' => 'IPA',
	'wikieditor-toolbar-characters-page-symbols' => 'Simbolet',
	'wikieditor-toolbar-characters-page-greek' => 'Grek',
	'wikieditor-toolbar-characters-page-cyrillic' => 'I sllavishtes së vjetër',
	'wikieditor-toolbar-characters-page-arabic' => 'Arabisht',
	'wikieditor-toolbar-characters-page-hebrew' => 'Hebraisht',
	'wikieditor-toolbar-characters-page-bangla' => 'Shqip',
	'wikieditor-toolbar-characters-page-telugu' => 'Telugu',
	'wikieditor-toolbar-characters-page-sinhala' => 'Sinhala',
	'wikieditor-toolbar-characters-page-gujarati' => 'Guxharati',
	'wikieditor-toolbar-section-help' => 'Ndihmë',
	'wikieditor-toolbar-help-heading-description' => 'Përshkrim',
	'wikieditor-toolbar-help-heading-syntax' => 'Çfarë ju lloji',
	'wikieditor-toolbar-help-heading-result' => 'Çfarë ju të merrni',
	'wikieditor-toolbar-help-page-format' => 'Formatimi',
	'wikieditor-toolbar-help-page-link' => 'Lidhje',
	'wikieditor-toolbar-help-page-heading' => 'Titujt',
	'wikieditor-toolbar-help-page-list' => 'Listat',
	'wikieditor-toolbar-help-page-file' => 'Files',
	'wikieditor-toolbar-help-page-reference' => 'Lidhje të jashtme',
	'wikieditor-toolbar-help-page-discussion' => 'Diskutim',
	'wikieditor-toolbar-help-content-italic-description' => 'Kursiv',
	'wikieditor-toolbar-help-content-italic-syntax' => "Teksti i pjerrët''''",
	'wikieditor-toolbar-help-content-italic-result' => '<em>Teksti i pjerrët</em>',
	'wikieditor-toolbar-help-content-bold-description' => 'Guximtar',
	'wikieditor-toolbar-help-content-bold-syntax' => "'''Tekst i trashë'''",
	'wikieditor-toolbar-help-content-bold-result' => '<strong>Tekst i trashë</strong>',
	'wikieditor-toolbar-help-content-bolditalic-description' => 'Bold & italic',
	'wikieditor-toolbar-help-content-bolditalic-syntax' => "'''''Bold &amp; tekst kursiv'''''",
	'wikieditor-toolbar-help-content-bolditalic-result' => '<strong><em>Bold & italic text</em></strong>',
	'wikieditor-toolbar-help-content-ilink-description' => 'Lidhje të Brendshme',
	'wikieditor-toolbar-help-content-ilink-syntax' => '[[Page title|Link emërtim]]<br />[[Page title]]',
	'wikieditor-toolbar-help-content-ilink-result' => "<a href='#'>Etiketa Link</a><br /><a href='#'>Titulli i faqes</a>",
	'wikieditor-toolbar-help-content-xlink-description' => 'Lidhje e jashtme',
	'wikieditor-toolbar-help-content-xlink-syntax' => 'Etiketa [http://www.example.org Link] <br /> [Http://www.example.org] <br /> http://www.example.org',
	'wikieditor-toolbar-help-content-xlink-result' => "<a href='#' class='external'>Etiketa Link</a> <br /> <a href='#' class='external autonumber'>[1]</a> <br /> <a href='#' class='external'>http://www.example.org</a>",
	'wikieditor-toolbar-help-content-heading2-description' => 'Niveli 2 titull',
	'wikieditor-toolbar-help-content-heading2-syntax' => 'Text == == Titull',
	'wikieditor-toolbar-help-content-heading2-result' => '<h2> Titull tekst </h2>',
	'wikieditor-toolbar-help-content-heading3-description' => 'Niveli 3 titull',
	'wikieditor-toolbar-help-content-heading3-syntax' => '=== Tekst === Titull',
	'wikieditor-toolbar-help-content-heading3-result' => '<h3> Titull tekst </h3>',
	'wikieditor-toolbar-help-content-heading4-description' => 'Niveli 4 titull',
	'wikieditor-toolbar-help-content-heading4-syntax' => '==== Tekst Titulli ====',
	'wikieditor-toolbar-help-content-heading4-result' => '<h4> Titull tekst </h4>',
	'wikieditor-toolbar-help-content-heading5-description' => 'Niveli 5 titull',
	'wikieditor-toolbar-help-content-heading5-syntax' => '===== ===== Tekst Titulli',
	'wikieditor-toolbar-help-content-heading5-result' => '<h5> Titull tekst </h5>',
	'wikieditor-toolbar-help-content-ulist-description' => 'Lista e bulleted',
	'wikieditor-toolbar-help-content-ulist-syntax' => '* Pika Lista <br /> * Pika Lista',
	'wikieditor-toolbar-help-content-ulist-result' => '<ul><li> pika Lista </li><li> pika Lista </li></ul>',
	'wikieditor-toolbar-help-content-olist-description' => 'Lista e Numëruar',
	'wikieditor-toolbar-help-content-olist-syntax' => 'pika # Lista <br /> pika # Lista',
	'wikieditor-toolbar-help-content-olist-result' => '<ol><li> pika Lista </li><li> pika Lista </li></ol>',
	'wikieditor-toolbar-help-content-file-description' => 'Embedded file',
	'wikieditor-toolbar-help-content-file-syntax' => '[[$1:Example.png|thumb|Caption teksti]]',
	'wikieditor-toolbar-help-content-file-result' => "<div style='width:104px;' class='thumbinner'> <a title=\"tekstit Legjenda\" class='image' href='#'><img height='50' width='100' border='0' class='thumbimage' src='\$2/WikiEditor/modules/images/toolbar/example-image.png' alt=''/></a> <div class='thumbcaption'><div class='magnify'> <a title=\"Zmadho\" class='internal' href='#'><img height='11' width='15' alt='' src='\$1/common/images/magnify-clip.png'/></a> </div> tekstit Legjenda </div></div>",
	'wikieditor-toolbar-help-content-reference-description' => 'Referim',
	'wikieditor-toolbar-help-content-reference-syntax' => 'Tekst faqesh. name="test"> <ref [http://www.example.org] teksti Link, teksti shtesë. </> ref',
	'wikieditor-toolbar-help-content-reference-result' => "Tekst faqesh. <a href='#'><sup>[1]</sup></a>",
	'wikieditor-toolbar-help-content-rereference-description' => 'përdorimin shtesë të njëjtën referencë',
	'wikieditor-toolbar-help-content-rereference-result' => "Tekst faqesh. <a href='#'><sup>[1]</sup></a>",
	'wikieditor-toolbar-help-content-showreferences-description' => 'referenca Display',
	'wikieditor-toolbar-help-content-showreferences-result' => "<ol class='references'><li id='cite_note-test-0'> <a title='' href='#'><b>^</b></a> <a rel='nofollow' title=\"http://www.example.org\" class='external text' href='#'>Teksti Link</a> , teksti shtesë. </li></ol>",
	'wikieditor-toolbar-help-content-signaturetimestamp-description' => 'Nënshkrimi me gjithë kohë',
	'wikieditor-toolbar-help-content-signaturetimestamp-result' => '<a href=\'#\' title="{{#special:mypage}}">Emri i përdoruesit</a> ( <a href=\'#\' title="{{#special:mytalk}}">të folur</a> ) 15:54, 10 Qershor 2009 (UTC)',
	'wikieditor-toolbar-help-content-signature-description' => 'Nënshkrim',
	'wikieditor-toolbar-help-content-signature-result' => '<a href=\'#\' title="{{#special:mypage}}">Emri i përdoruesit</a> ( <a href=\'#\' title="{{#special:mytalk}}">të folur</a> )',
	'wikieditor-toolbar-help-content-indent-description' => 'Porosit',
	'wikieditor-toolbar-help-content-indent-syntax' => 'tekstit Normale <br /> : Teksti i prerë <br /> :: Teksti i prerë',
	'wikieditor-toolbar-help-content-indent-result' => 'tekstit Normale <dl><dd> Teksti i prerë <dl><dd> Teksti i prerë </dd></dl></dd></dl>',
);

/** Aragonese (aragonés)
 * @author Juanpabl
 */
$messages['an'] = array(
	'wikieditor' => "Interficie abanzada d'edición de wikitexto",
	'wikieditor-desc' => 'Proporciona una interficie extensible de modificación de wikitexto y quantos modulos de funcionalidatz',
	'wikieditor-wikitext-tab' => 'Wikitexto',
	'wikieditor-loading' => 'Cargando',
	'wikieditor-preview-preference' => 'Activar a previsualización costau a costau',
	'wikieditor-preview-tab' => 'Previsualizar',
	'wikieditor-preview-changes-tab' => 'Cambios',
	'wikieditor-preview-loading' => 'Cargando...',
	'wikieditor-previewDialog-preference' => 'Activar o dialogo de visualización previa',
	'wikieditor-previewDialog-tab' => 'Previsualización',
	'wikieditor-previewDialog-loading' => 'Cargando…',
	'wikieditor-publish-preference' => 'Activar a publicación trango a trango',
	'wikieditor-publish-button-publish' => 'Publicar',
	'wikieditor-publish-button-cancel' => 'Cancelar',
	'wikieditor-publish-dialog-title' => 'Publicar en {{SITENAME}}',
	'wikieditor-publish-dialog-summary' => "Resumen d'edición (describa breument os cambios que ha feito):",
	'wikieditor-publish-dialog-minor' => 'Edición menor',
	'wikieditor-publish-dialog-watch' => 'Cosirar ista pachina',
	'wikieditor-publish-dialog-publish' => 'Publicar',
	'wikieditor-publish-dialog-goback' => 'Tornar',
	'wikieditor-template-editor-preference' => 'Activar a edición de plantillas basada en formularios',
	'wikieditor-template-editor-dialog-title' => 'Editar a plantilla',
	'wikieditor-template-editor-dialog-submit' => 'Actualizar',
	'wikieditor-template-editor-dialog-cancel' => 'Cancelar',
	'wikieditor-templates-preference' => 'Activar o replegamiento de plantillas',
	'wikieditor-toc-preference' => 'Activar a tabla de contenius navigable',
	'wikieditor-toc-show' => 'Amostrar o conteniu',
	'wikieditor-toc-hide' => 'Amagar o conteniu',
	'wikieditor-toolbar' => "Barra de ferramientas d'edición",
	'wikieditor-toolbar-desc' => "Barra de ferramientas d'edición con usabilidat amillorada",
	'wikieditor-toolbar-preference' => "Activar a barra de ferramientas d'edición amillorada",
	'wikieditor-toolbar-dialogs-preference' => 'Activar as caixas de dialogos ta ficar vinclos, tablas y atros',
	'wikieditor-toolbar-hidesig' => 'Amagar o botón sinyar en as pachinas en o espacio de nombres prencipal',
	'wikieditor-toolbar-loading' => 'Cargando...',
	'wikieditor-toolbar-tool-bold' => 'Negreta',
	'wikieditor-toolbar-tool-bold-example' => 'Texto en negreta',
	'wikieditor-toolbar-tool-italic' => 'Cursiva',
	'wikieditor-toolbar-tool-italic-example' => 'Texto en cursiva',
	'wikieditor-toolbar-tool-ilink' => 'Vinclo interno',
	'wikieditor-toolbar-tool-ilink-example' => "Títol d'o vinclo",
	'wikieditor-toolbar-tool-xlink' => "Vinclo externo (recorde-se-ne d'o prefixo http://)",
	'wikieditor-toolbar-tool-xlink-example' => "http://www.example.com títol d'o vinclo",
	'wikieditor-toolbar-tool-link' => 'Vinclo',
	'wikieditor-toolbar-tool-link-title' => 'Fique un vinclo',
	'wikieditor-toolbar-tool-link-int' => 'Enta una pachina wiki',
	'wikieditor-toolbar-tool-link-int-target' => 'Pachina u URL de destino:',
	'wikieditor-toolbar-tool-link-int-target-tooltip' => "Títol d'a pachina u URL",
	'wikieditor-toolbar-tool-link-int-text' => "Texto d'o vinclo:",
	'wikieditor-toolbar-tool-link-int-text-tooltip' => 'Texto a amostrar',
	'wikieditor-toolbar-tool-link-ext' => 'Enta una pachina web externa',
	'wikieditor-toolbar-tool-link-ext-target' => "URL d'o vinclo:",
	'wikieditor-toolbar-tool-link-ext-text' => "Texto d'o vinclo:",
	'wikieditor-toolbar-tool-link-insert' => 'Fique un vinclo',
	'wikieditor-toolbar-tool-link-cancel' => 'Cancelar',
	'wikieditor-toolbar-tool-link-int-target-status-exists' => 'A pachina existe',
	'wikieditor-toolbar-tool-link-int-target-status-notexists' => 'A pachina no existe',
	'wikieditor-toolbar-tool-link-int-target-status-invalid' => 'Títol invalido',
	'wikieditor-toolbar-tool-link-int-target-status-external' => 'Vinclo externo',
	'wikieditor-toolbar-tool-link-int-target-status-loading' => "Comprebando a existencia d'a pachina...",
	'wikieditor-toolbar-tool-link-int-invalid' => 'O títol que ha especificato no ye valido.',
	'wikieditor-toolbar-tool-link-lookslikeinternal' => "O URL que ha especificato pareix que enlazaba con un atra pachina d'o wiki. Quiere tornar-lo en un vinclo interno?",
	'wikieditor-toolbar-tool-link-lookslikeinternal-int' => 'Vinclo interno',
	'wikieditor-toolbar-tool-link-lookslikeinternal-ext' => 'Vinclo externo',
	'wikieditor-toolbar-tool-link-empty' => 'No ha escrito garra cosa ta enlazar.',
	'wikieditor-toolbar-tool-file' => 'Imachen incorporada',
	'wikieditor-toolbar-tool-file-example' => 'Exemplo.jpg',
	'wikieditor-toolbar-tool-reference' => 'Referencia',
	'wikieditor-toolbar-tool-reference-example' => 'Ficar aquí una nota a lo piet',
	'wikieditor-toolbar-tool-reference-cancel' => 'Cancelar',
	'wikieditor-toolbar-tool-reference-title' => 'Ficar referencia',
	'wikieditor-toolbar-tool-reference-insert' => 'Insertar',
	'wikieditor-toolbar-tool-reference-text' => "Texto d'a referencia",
	'wikieditor-toolbar-tool-signature' => 'Sinyatura, calendata y hora',
	'wikieditor-toolbar-section-advanced' => 'Abanzato',
	'wikieditor-toolbar-tool-heading' => 'Títol',
	'wikieditor-toolbar-tool-heading-1' => 'Livel 1',
	'wikieditor-toolbar-tool-heading-2' => 'Livel 2',
	'wikieditor-toolbar-tool-heading-3' => 'Livel 3',
	'wikieditor-toolbar-tool-heading-4' => 'Livel 4',
	'wikieditor-toolbar-tool-heading-5' => 'Livel 5',
	'wikieditor-toolbar-tool-heading-example' => 'Texto de títol',
	'wikieditor-toolbar-group-format' => 'Formato',
	'wikieditor-toolbar-tool-ulist' => 'Lista con puntos',
	'wikieditor-toolbar-tool-ulist-example' => "Elemento d'a lista con puntos",
	'wikieditor-toolbar-tool-olist' => 'Lista numerata',
	'wikieditor-toolbar-tool-olist-example' => "Elemento d'a lista numerata",
	'wikieditor-toolbar-tool-indent' => 'Indentación',
	'wikieditor-toolbar-tool-indent-example' => 'Linia indentada',
	'wikieditor-toolbar-tool-nowiki' => 'Sin formato wiki',
	'wikieditor-toolbar-tool-nowiki-example' => 'Escriba aquí texto sin formateyar',
	'wikieditor-toolbar-tool-redirect' => 'Reendrecera',
	'wikieditor-toolbar-tool-redirect-example' => "Nombre d'a pachina de destino",
	'wikieditor-toolbar-tool-big' => 'Gran',
	'wikieditor-toolbar-tool-big-example' => 'Texto gran',
	'wikieditor-toolbar-tool-small' => 'Chicot',
	'wikieditor-toolbar-tool-small-example' => 'Texto chicot',
	'wikieditor-toolbar-tool-superscript' => 'Superéndiz',
	'wikieditor-toolbar-tool-superscript-example' => 'Texto en superéndiz',
	'wikieditor-toolbar-tool-subscript' => 'Subéndiz',
	'wikieditor-toolbar-tool-subscript-example' => 'Texto en subéndiz',
	'wikieditor-toolbar-group-insert' => 'Insertar',
	'wikieditor-toolbar-tool-gallery' => "Galería d'imachens",
	'wikieditor-toolbar-tool-gallery-example' => '$1:Eixemplo.jpg|Piet_de_foto_1
$1:Eixemplo.jpg|Piet_de_foto_2',
	'wikieditor-toolbar-tool-newline' => 'Nueva linia',
	'wikieditor-toolbar-tool-table' => 'Tabla',
	'wikieditor-toolbar-tool-table-example-old' => '-
! encabezau 1
! encabezau 2
! encabezau 3
|-
| ringlera 1, celda 1
| ringlera 1, celda 2
| ringlera 1, celda 3
|-
| ringlera 2, celda 1
| ringlera 2, celda 2
| ringlera 2, celda 3',
	'wikieditor-toolbar-tool-table-example-cell-text' => "Texto d'a celda",
	'wikieditor-toolbar-tool-table-example-header' => 'Texto de títol',
	'wikieditor-toolbar-tool-table-title' => 'Insertar una tabla',
	'wikieditor-toolbar-tool-table-dimensions-rows' => 'Ringleras',
	'wikieditor-toolbar-tool-table-dimensions-columns' => 'Columnas',
	'wikieditor-toolbar-tool-table-dimensions-header' => "Adhibir una filera d'encabezau",
	'wikieditor-toolbar-tool-table-wikitable' => 'Estilo con cantos',
	'wikieditor-toolbar-tool-table-sortable' => 'Fer a tabla ordenable',
	'wikieditor-toolbar-tool-table-example' => 'Eixemplo',
	'wikieditor-toolbar-tool-table-preview' => 'Visualización previa',
	'wikieditor-toolbar-tool-table-insert' => 'Insertar',
	'wikieditor-toolbar-tool-table-cancel' => 'Cancelar',
	'wikieditor-toolbar-tool-table-toomany' => 'Con iste quadro de dialogo no ye posible insertar una tabla con más de $1 celdas.',
	'wikieditor-toolbar-tool-table-invalidnumber' => 'No ha escrito un numero valido de fileras u columnas.',
	'wikieditor-toolbar-tool-table-zero' => 'No se puet insertar una tabla con zero fileras u columnas.',
	'wikieditor-toolbar-tool-replace' => 'Buscar y reemplazar',
	'wikieditor-toolbar-tool-replace-title' => 'Buscar y reemplazar',
	'wikieditor-toolbar-tool-replace-search' => 'Mirar:',
	'wikieditor-toolbar-tool-replace-replace' => 'Reemplazar por:',
	'wikieditor-toolbar-tool-replace-case' => 'Distinguir mayusclas/minusclas',
	'wikieditor-toolbar-tool-replace-regex' => 'Tractar a cadena a mirar como una expresión regular',
	'wikieditor-toolbar-tool-replace-button-findnext' => 'Mirar o siguient',
	'wikieditor-toolbar-tool-replace-button-replace' => 'Reemplazar',
	'wikieditor-toolbar-tool-replace-button-replaceall' => 'Substituir tot',
	'wikieditor-toolbar-tool-replace-close' => 'Zarrar',
	'wikieditor-toolbar-tool-replace-nomatch' => 'A suya busca no ha trobau garra resultau concordant.',
	'wikieditor-toolbar-tool-replace-success' => "S'han feito $1 substitucions.",
	'wikieditor-toolbar-tool-replace-emptysearch' => 'No ha escrito garra cosa ta mirar.',
	'wikieditor-toolbar-tool-replace-invalidregex' => 'A expresión regular que ha escrito ye invalida: $1',
	'wikieditor-toolbar-section-characters' => 'Carácters especials',
	'wikieditor-toolbar-characters-page-latin' => 'Latín',
	'wikieditor-toolbar-characters-page-latinextended' => 'Latín enamplau',
	'wikieditor-toolbar-characters-page-ipa' => 'AFI(IPA)',
	'wikieditor-toolbar-characters-page-symbols' => 'Símbols',
	'wikieditor-toolbar-characters-page-greek' => 'Griego',
	'wikieditor-toolbar-characters-page-cyrillic' => 'Cirilico',
	'wikieditor-toolbar-characters-page-arabic' => 'Arabico',
	'wikieditor-toolbar-characters-page-arabicextended' => 'Arabigo extendiu',
	'wikieditor-toolbar-characters-page-persian' => 'Persa',
	'wikieditor-toolbar-characters-page-hebrew' => 'Hebreu',
	'wikieditor-toolbar-characters-page-bangla' => 'Bengalí',
	'wikieditor-toolbar-characters-page-telugu' => 'Telugu',
	'wikieditor-toolbar-characters-page-sinhala' => 'Cingalés',
	'wikieditor-toolbar-characters-page-gujarati' => 'Gujaratí',
	'wikieditor-toolbar-characters-page-thai' => 'Thai',
	'wikieditor-toolbar-characters-page-lao' => 'Laosiano',
	'wikieditor-toolbar-characters-page-khmer' => 'Khmer',
	'wikieditor-toolbar-section-help' => 'Aduya',
	'wikieditor-toolbar-help-heading-description' => 'Descripción',
	'wikieditor-toolbar-help-heading-syntax' => 'O que vusté escribe',
	'wikieditor-toolbar-help-heading-result' => "O que s'obtiene",
	'wikieditor-toolbar-help-page-format' => 'Formateyo',
	'wikieditor-toolbar-help-page-link' => 'Vinclos',
	'wikieditor-toolbar-help-page-heading' => 'Títol',
	'wikieditor-toolbar-help-page-list' => 'Listas',
	'wikieditor-toolbar-help-page-file' => 'Fichers',
	'wikieditor-toolbar-help-page-reference' => 'Referencias',
	'wikieditor-toolbar-help-page-discussion' => 'Discusión',
	'wikieditor-toolbar-help-content-italic-description' => 'Cursiva',
	'wikieditor-toolbar-help-content-italic-syntax' => "''Texto en cursiva''",
	'wikieditor-toolbar-help-content-italic-result' => '<em>Texto en cursiva</em>',
	'wikieditor-toolbar-help-content-bold-description' => 'Negreta',
	'wikieditor-toolbar-help-content-bold-syntax' => "'''Texto en negreta'''",
	'wikieditor-toolbar-help-content-bold-result' => '<strong>Texto en negreta</strong>',
	'wikieditor-toolbar-help-content-bolditalic-description' => 'Negreta y cursiva',
	'wikieditor-toolbar-help-content-bolditalic-syntax' => "'''''Texto en negreta y cursiva'''''",
	'wikieditor-toolbar-help-content-bolditalic-result' => '<strong><em>Texto en negreta y cursiva</em></strong>',
	'wikieditor-toolbar-help-content-ilink-description' => 'Vinclo interno',
	'wikieditor-toolbar-help-content-ilink-syntax' => "[[Títol d'a pachina|Texto d'o vinclo]]<br />[[Títol de pachina]]",
	'wikieditor-toolbar-help-content-ilink-result' => "<a href='#'>Texto d'o vinclo</a><br /><a href='#'>Títol d'a pachina</a>",
	'wikieditor-toolbar-help-content-xlink-description' => 'Vinclo externo',
	'wikieditor-toolbar-help-content-xlink-syntax' => "[http://www.example.org Texto d'o vinclo]<br />[http://www.example.org]<br />http://www.example.org",
	'wikieditor-toolbar-help-content-xlink-result' => "<a href='#' class='external'>Texto d'o vinclo</a><br /><a href='#' class='external autonumber'>[1]</a><br /><a href='#' class='external'>http://www.example.org</a>",
	'wikieditor-toolbar-help-content-heading2-description' => 'Títol de 2o ran',
	'wikieditor-toolbar-help-content-heading2-syntax' => "== Texto d'o títol ==",
	'wikieditor-toolbar-help-content-heading2-result' => "<h2>Texto d'o títol</h2>",
	'wikieditor-toolbar-help-content-heading3-description' => 'Títol de 3r ran',
	'wikieditor-toolbar-help-content-heading3-syntax' => "=== Texto d'o títol ===",
	'wikieditor-toolbar-help-content-heading3-result' => "<h3>Texto d'o títol</h3>",
	'wikieditor-toolbar-help-content-heading4-description' => 'Títol de 4o ran',
	'wikieditor-toolbar-help-content-heading4-syntax' => "==== Texto d'o títol ====",
	'wikieditor-toolbar-help-content-heading4-result' => "<h4>Texto d'o títol</h4>",
	'wikieditor-toolbar-help-content-heading5-description' => 'Títol de 5o ran',
	'wikieditor-toolbar-help-content-heading5-syntax' => "===== Texto d'o títol =====",
	'wikieditor-toolbar-help-content-heading5-result' => "<h5>Texto d'o títol</h5>",
	'wikieditor-toolbar-help-content-ulist-description' => 'Lista con puntos',
	'wikieditor-toolbar-help-content-ulist-syntax' => "* Elemento d'a lista<br />* Elemento d'a lista",
	'wikieditor-toolbar-help-content-ulist-result' => "<ul><li>Elemento d'a lista</li><li>Elemento d'a lista</li></ul>",
	'wikieditor-toolbar-help-content-olist-description' => 'Lista numerata',
	'wikieditor-toolbar-help-content-olist-syntax' => "# Elemento d'a lista<br /># Elemento d'a lista",
	'wikieditor-toolbar-help-content-olist-result' => "<ol><li>Elemento d'a lista</li><li>Elemento d'a lista</li></ol>",
	'wikieditor-toolbar-help-content-file-description' => 'Fichero incorporato',
	'wikieditor-toolbar-help-content-file-syntax' => "[[$1:Eixemplo.png|thumb|Texto descriptivo d'a imachen]]",
	'wikieditor-toolbar-help-content-file-result' => "<div style='width:104px;' class='thumbinner'><a title='Texto de piet de foto' class='image' href='#'><img height='50' width='100' border='0' class='thumbimage' src='$2/WikiEditor/modules/images/toolbar/example-image.png' alt=''/></a><div class='thumbcaption'><div class='magnify'><a title='Fer más gran' class='internal' href='#'><img height='11' width='15' alt='' src='$1/common/images/magnify-clip.png'/></a></div>Texto de piet de foto</div></div>",
	'wikieditor-toolbar-help-content-reference-description' => 'Referencia',
	'wikieditor-toolbar-help-content-reference-syntax' => 'Texto d\'a pachina.&lt;ref name="test"&gt;[http://www.example.org Texto d\'o vinclo], texto adicional.&lt;/ref&gt;',
	'wikieditor-toolbar-help-content-reference-result' => "Texto d'a pachina.<sup><a href='#'>[1]</a></sup>",
	'wikieditor-toolbar-help-content-rereference-description' => "Uso adicional d'a mesma referencia",
	'wikieditor-toolbar-help-content-rereference-result' => "Texto d'a pachina.<sup><a href='#'>[1]</a></sup>",
	'wikieditor-toolbar-help-content-showreferences-description' => 'Amostrar as referencias',
	'wikieditor-toolbar-help-content-showreferences-result' => "<ol class='referencias'><li id='cite_note-test-0'><b><a title='' href='#'>^</a></b> <a rel='nofollow' title='http://www.example.org' class='external text' href='#'>Texto d'o vinclo</a>, texto adicional.</li></ol>",
	'wikieditor-toolbar-help-content-signaturetimestamp-description' => 'Sinyatura, calendata y hora',
	'wikieditor-toolbar-help-content-signaturetimestamp-result' => "<a href='#' title='{{#special:mypage}}'>Nombre d'usuario</a> (<a href='#' title='{{#special:mytalk}}'>discusión</a>) 15:54, 10 de chunio de 2009 (UTC)",
	'wikieditor-toolbar-help-content-signature-description' => 'Sinyatura',
	'wikieditor-toolbar-help-content-signature-result' => "<a href='#' title='{{#special:mypage}}'>Nombre d'usuario</a> (<a href='#' title='{{#special:mytalk}}'>discusión</a>)",
	'wikieditor-toolbar-help-content-indent-description' => 'Indentación',
	'wikieditor-toolbar-help-content-indent-syntax' => 'Texto normal<br />:Texto indentato<br />::Texto indentato',
	'wikieditor-toolbar-help-content-indent-result' => 'Texto normal<dl><dd>Texto indentato<dl><dd>Texto indentato</dd></dl></dd></dl>',
);

/** Old English (Ænglisc)
 * @author Wōdenhelm
 */
$messages['ang'] = array(
	'wikieditor-toolbar' => 'Ādihtende tōlscyttel',
	'wikieditor-toolbar-loading' => 'Hlādende...',
	'wikieditor-toolbar-tool-bold' => 'Þicce',
	'wikieditor-toolbar-tool-bold-example' => 'Þicce traht',
	'wikieditor-toolbar-tool-ilink' => 'Innanƿeard hlenċe',
	'wikieditor-toolbar-tool-ilink-example' => 'Hlenċenama',
	'wikieditor-toolbar-tool-xlink' => 'Ūtanƿeard hlenċe (ȝemynd http:// foretraht)',
	'wikieditor-toolbar-tool-link' => 'Hlenċe',
	'wikieditor-toolbar-tool-link-title' => 'Hlenċan ēacian',
	'wikieditor-toolbar-tool-link-int' => 'To ƿikisīdan',
	'wikieditor-toolbar-tool-link-int-target' => 'Gōl sīde oþþe URL:',
	'wikieditor-toolbar-tool-link-int-target-tooltip' => 'Sīdenama oþþe URL',
	'wikieditor-toolbar-tool-link-int-text' => 'Traht to scēaƿienne:',
	'wikieditor-toolbar-tool-link-ext' => 'To ūtanƿeardum ƿebbsīdan',
	'wikieditor-toolbar-tool-link-ext-target' => 'Hlenċe URL',
	'wikieditor-toolbar-tool-link-int-target-status-external' => 'Ūtanƿeard hlenċan',
	'wikieditor-toolbar-tool-link-lookslikeinternal-int' => 'Innanƿeard hlenċe',
	'wikieditor-toolbar-tool-file-example' => 'Bisen.jpg',
	'wikieditor-toolbar-tool-reference' => 'Fruma',
	'wikieditor-toolbar-tool-heading-1' => 'Emnet 1',
	'wikieditor-toolbar-tool-heading-2' => 'Emnet 2',
	'wikieditor-toolbar-tool-heading-3' => 'Emnet 3',
	'wikieditor-toolbar-tool-heading-4' => 'Emnet 4',
	'wikieditor-toolbar-tool-heading-5' => 'Emnet 5',
	'wikieditor-toolbar-tool-big' => 'Miċel',
	'wikieditor-toolbar-tool-big-example' => 'Miċel traht',
	'wikieditor-toolbar-tool-small' => 'Lytel',
	'wikieditor-toolbar-tool-small-example' => 'Lytel traht',
	'wikieditor-toolbar-tool-table' => 'Tæfl',
	'wikieditor-toolbar-tool-table-dimensions-rows' => 'Rǣƿa',
	'wikieditor-toolbar-tool-table-example' => 'Bisen',
	'wikieditor-toolbar-tool-table-preview' => 'Forescēaƿian',
	'wikieditor-toolbar-characters-page-latin' => 'Lǣden',
	'wikieditor-toolbar-characters-page-latinextended' => 'Āstrecced Lǣden',
	'wikieditor-toolbar-characters-page-symbols' => 'Tācnu',
	'wikieditor-toolbar-characters-page-greek' => 'Grēcisc',
	'wikieditor-toolbar-characters-page-cyrillic' => 'Cyrillisc',
	'wikieditor-toolbar-characters-page-arabic' => 'Arabisc',
	'wikieditor-toolbar-characters-page-persian' => 'Perseanisc',
	'wikieditor-toolbar-section-help' => 'Help',
	'wikieditor-toolbar-help-page-link' => 'Hlenċan',
	'wikieditor-toolbar-help-page-discussion' => 'Ȝespreċ',
	'wikieditor-toolbar-help-content-bold-description' => 'Þicce',
	'wikieditor-toolbar-help-content-bold-syntax' => "'''Þicce traht'''",
	'wikieditor-toolbar-help-content-bold-result' => '<strong>Þicce traht</strong>',
	'wikieditor-toolbar-help-content-ilink-description' => 'Innanƿeard hlenċe',
	'wikieditor-toolbar-help-content-reference-description' => 'Fruma',
);

/** Arabic (العربية)
 * @author Aiman titi
 * @author DRIHEM
 * @author McDutchie
 * @author Meno25
 * @author OsamaK
 * @author Samer
 * @author Zack wadghiri
 * @author ترجمان05
 * @author زكريا
 */
$messages['ar'] = array(
	'wikieditor' => 'الواجهة المتقدمة لتعديل نص ويكي',
	'wikieditor-desc' => 'يوفر واجهة تعديل نص ويكي قابلة للتمديد والعديد من الوحدات التي توفر المزايا',
	'wikieditor-wikitext-tab' => 'نص الويكي',
	'wikieditor-loading' => 'جاري التحميل...',
	'wikieditor-preview-preference' => 'مكّن المعاينة جنبًا لجنب',
	'wikieditor-preview-tab' => 'عرض مسبق',
	'wikieditor-preview-changes-tab' => 'تغييرات',
	'wikieditor-preview-loading' => 'جاري التحميل...',
	'wikieditor-previewDialog-preference' => 'مكّن حوار المعاينة',
	'wikieditor-previewDialog-tab' => 'عرض مسبق',
	'wikieditor-previewDialog-loading' => 'جاري التحميل...',
	'wikieditor-publish-preference' => 'فعّل النشر خطوة بخطوة',
	'wikieditor-publish-button-publish' => 'انشر',
	'wikieditor-publish-button-cancel' => 'إلغاء',
	'wikieditor-publish-dialog-title' => 'انشر في {{SITENAME}}',
	'wikieditor-publish-dialog-summary' => 'ملخص التعديل (اشرح باختصار التغييرات التي قمت بها):',
	'wikieditor-publish-dialog-minor' => 'تعديل طفيف',
	'wikieditor-publish-dialog-watch' => 'راقب هذه الصفحة',
	'wikieditor-publish-dialog-publish' => 'انشر',
	'wikieditor-publish-dialog-goback' => 'ارجع',
	'wikieditor-template-editor-preference' => 'فعل تعديل قوالب الويكي المعتمد على النماذج',
	'wikieditor-template-editor-dialog-title' => 'عدّل القالب',
	'wikieditor-template-editor-dialog-submit' => 'حدّث',
	'wikieditor-template-editor-dialog-cancel' => 'إلغاء',
	'wikieditor-templates-preference' => 'مكّن طي القوالب',
	'wikieditor-toc-preference' => 'مكّن جدول المحتويات القابل للتصفح',
	'wikieditor-toc-show' => 'أظهر المحتويات',
	'wikieditor-toc-hide' => 'أخفِ المحتويات',
	'wikieditor-toolbar' => 'شريط أدوات التحرير',
	'wikieditor-toolbar-desc' => 'شريط تحرير الصفحات مع تحسين الاستخدامية',
	'wikieditor-toolbar-preference' => 'مكن شريط أدوات التحرير المحسن',
	'wikieditor-toolbar-dialogs-preference' => 'مكن حوارات إدراج الوصلات والجداول وغيرها',
	'wikieditor-toolbar-hidesig' => 'أخف زر التوقيع في صفحات النطاق الرئيسي',
	'wikieditor-toolbar-loading' => 'جاري التحميل...',
	'wikieditor-toolbar-tool-bold' => 'غليظ',
	'wikieditor-toolbar-tool-bold-example' => 'نص غليظ',
	'wikieditor-toolbar-tool-italic' => 'مائل',
	'wikieditor-toolbar-tool-italic-example' => 'نص مائل',
	'wikieditor-toolbar-tool-ilink' => 'وصلة داخلية',
	'wikieditor-toolbar-tool-ilink-example' => 'عنوان الوصلة',
	'wikieditor-toolbar-tool-xlink' => 'وصلة خارجية (تذكر البدء بhttp://)',
	'wikieditor-toolbar-tool-xlink-example' => 'http://www.example.com عنوان الوصلة',
	'wikieditor-toolbar-tool-link' => 'وصلة',
	'wikieditor-toolbar-tool-link-title' => 'إدراج وصلة',
	'wikieditor-toolbar-tool-link-int' => 'لصفحة ويكي',
	'wikieditor-toolbar-tool-link-int-target' => 'عنوان الصفحة:',
	'wikieditor-toolbar-tool-link-int-target-tooltip' => 'عنوان الصفحة أو المسار',
	'wikieditor-toolbar-tool-link-int-text' => 'نص الوصلة:',
	'wikieditor-toolbar-tool-link-int-text-tooltip' => 'أدخل النص الذي ينبغي إظهاره',
	'wikieditor-toolbar-tool-link-ext' => 'لصفحة وب خارجية',
	'wikieditor-toolbar-tool-link-ext-target' => 'مسار الوصلة:',
	'wikieditor-toolbar-tool-link-ext-text' => 'نص الوصلة:',
	'wikieditor-toolbar-tool-link-insert' => 'أدرج الوصلة',
	'wikieditor-toolbar-tool-link-cancel' => 'إلغاء',
	'wikieditor-toolbar-tool-link-int-target-status-exists' => 'الصفحة موجودة',
	'wikieditor-toolbar-tool-link-int-target-status-notexists' => 'الصفحة غير موجودة',
	'wikieditor-toolbar-tool-link-int-target-status-invalid' => 'عنوان غير صحيح',
	'wikieditor-toolbar-tool-link-int-target-status-external' => 'وصلة خارجية',
	'wikieditor-toolbar-tool-link-int-target-status-loading' => 'يلتمس وجود الصفحة...',
	'wikieditor-toolbar-tool-link-int-invalid' => 'العنوان الذي اخترته غير صالح.',
	'wikieditor-toolbar-tool-link-lookslikeinternal' => 'يبدو أن المُراد بالمسار الذي حددته وصلة إلى صفحة ويكي أخرى. أتريد أن تجعلها وصلة داخلية؟',
	'wikieditor-toolbar-tool-link-lookslikeinternal-int' => 'وصلة داخلية',
	'wikieditor-toolbar-tool-link-lookslikeinternal-ext' => 'وصلة خارجية',
	'wikieditor-toolbar-tool-link-empty' => 'لم تدخل شيئا لتصل به.',
	'wikieditor-toolbar-tool-file' => 'ملف مضمّن',
	'wikieditor-toolbar-tool-file-example' => 'Example.jpg',
	'wikieditor-toolbar-tool-file-title' => 'أدرج الملف',
	'wikieditor-toolbar-file-target' => 'اسم الملف:',
	'wikieditor-toolbar-file-caption' => 'التعليق:',
	'wikieditor-toolbar-file-size' => 'الحجم:',
	'wikieditor-toolbar-file-float' => 'ناحية:',
	'wikieditor-toolbar-file-default' => '(افتراضي)',
	'wikieditor-toolbar-file-format' => 'الصيغة:',
	'wikieditor-toolbar-tool-file-insert' => 'إدراج',
	'wikieditor-toolbar-tool-file-cancel' => 'إلغاء',
	'wikieditor-toolbar-tool-reference' => 'مرجع',
	'wikieditor-toolbar-tool-reference-example' => 'أدرج نص الحاشية هنا',
	'wikieditor-toolbar-tool-reference-cancel' => 'إلغاء',
	'wikieditor-toolbar-tool-reference-title' => 'إدراج مرجع',
	'wikieditor-toolbar-tool-reference-insert' => 'أدرج',
	'wikieditor-toolbar-tool-reference-text' => 'نص المرجع',
	'wikieditor-toolbar-tool-signature' => 'توقيع مع الطابع الزمني',
	'wikieditor-toolbar-section-advanced' => 'متقدم',
	'wikieditor-toolbar-tool-heading' => 'ترويسة',
	'wikieditor-toolbar-tool-heading-1' => 'مستوى 1',
	'wikieditor-toolbar-tool-heading-2' => 'مستوى 2',
	'wikieditor-toolbar-tool-heading-3' => 'مستوى 3',
	'wikieditor-toolbar-tool-heading-4' => 'مستوى 4',
	'wikieditor-toolbar-tool-heading-5' => 'مستوى 5',
	'wikieditor-toolbar-tool-heading-example' => 'نص الترويسة',
	'wikieditor-toolbar-group-format' => 'تنسيق',
	'wikieditor-toolbar-tool-ulist' => 'قائمة منقّطة',
	'wikieditor-toolbar-tool-ulist-example' => 'عنصر قائمة منقطة',
	'wikieditor-toolbar-tool-olist' => 'قائمة مرقمة',
	'wikieditor-toolbar-tool-olist-example' => 'عنصر قائمة مرقمة',
	'wikieditor-toolbar-tool-indent' => 'هامش',
	'wikieditor-toolbar-tool-indent-example' => 'سطر بهامش',
	'wikieditor-toolbar-tool-nowiki' => 'لا تنسيق ويكي',
	'wikieditor-toolbar-tool-nowiki-example' => 'أدرج نصًا غير منسق هنا',
	'wikieditor-toolbar-tool-redirect' => 'تحويلة',
	'wikieditor-toolbar-tool-redirect-example' => 'اسم الصفحة الهدف',
	'wikieditor-toolbar-tool-big' => 'كبير',
	'wikieditor-toolbar-tool-big-example' => 'نص كبير',
	'wikieditor-toolbar-tool-small' => 'صغير',
	'wikieditor-toolbar-tool-small-example' => 'نص صغير',
	'wikieditor-toolbar-tool-superscript' => 'حرف علوي',
	'wikieditor-toolbar-tool-superscript-example' => 'نص الحرف العلوي',
	'wikieditor-toolbar-tool-subscript' => 'حرف سفلي',
	'wikieditor-toolbar-tool-subscript-example' => 'نص الحرف السفلي',
	'wikieditor-toolbar-group-insert' => 'أدرج',
	'wikieditor-toolbar-tool-gallery' => 'معرض صور',
	'wikieditor-toolbar-tool-gallery-example' => '$1:Example.jpg|تعليق1
$1:Example.jpg|تعليق2',
	'wikieditor-toolbar-tool-newline' => 'سطر جديد',
	'wikieditor-toolbar-tool-table' => 'جدولًا',
	'wikieditor-toolbar-tool-table-example-old' => '-
! ترويسة 1
! ترويسة 2
! ترويسة 3
|-
| صف 1، خلية 1
| صف 1، خلية 2
| صف 1، خلية 3
|-
| صف 2، خلية 1
| صف 2، خلية 2
| صف 2، خلية 3',
	'wikieditor-toolbar-tool-table-example-cell-text' => 'نص الخلية',
	'wikieditor-toolbar-tool-table-example-header' => 'نص الترويسة',
	'wikieditor-toolbar-tool-table-title' => 'إدراج جدول',
	'wikieditor-toolbar-tool-table-dimensions-rows' => 'الصفوف',
	'wikieditor-toolbar-tool-table-dimensions-columns' => 'الأعمدة',
	'wikieditor-toolbar-tool-table-dimensions-header' => 'ضمّن صف الترويسة',
	'wikieditor-toolbar-tool-table-wikitable' => 'سمة ذات حدود',
	'wikieditor-toolbar-tool-table-sortable' => 'اجعل الجدول قابلا للترتيب',
	'wikieditor-toolbar-tool-table-example' => 'مثال',
	'wikieditor-toolbar-tool-table-preview' => 'عرض مسبق',
	'wikieditor-toolbar-tool-table-insert' => 'أدرج',
	'wikieditor-toolbar-tool-table-cancel' => 'إلغاء',
	'wikieditor-toolbar-tool-table-toomany' => 'إدراج جدول بأكثر من $1 خلية غير ممكن عبر هذا الحوار.',
	'wikieditor-toolbar-tool-table-invalidnumber' => 'لم تدخل رقما صحيحا للصفوف أو الأعمدة.',
	'wikieditor-toolbar-tool-table-zero' => 'لا يمكن أن تدرج جدولا بلا صفوف أو أعمدة.',
	'wikieditor-toolbar-tool-replace' => 'ابحث واستبدل',
	'wikieditor-toolbar-tool-replace-title' => 'ابحث واستبدل',
	'wikieditor-toolbar-tool-replace-search' => 'ابحث عن:',
	'wikieditor-toolbar-tool-replace-replace' => 'استبدل ب:',
	'wikieditor-toolbar-tool-replace-case' => 'مطابقة الحالة',
	'wikieditor-toolbar-tool-replace-regex' => 'عامل عبارة البحث كتعبير نمطي',
	'wikieditor-toolbar-tool-replace-button-findnext' => 'جِد التالي',
	'wikieditor-toolbar-tool-replace-button-replace' => 'استبدل',
	'wikieditor-toolbar-tool-replace-button-replaceall' => 'استبدل الكل',
	'wikieditor-toolbar-tool-replace-close' => 'أغلق',
	'wikieditor-toolbar-tool-replace-nomatch' => 'بحثك لم يطابق أي شيء.',
	'wikieditor-toolbar-tool-replace-success' => 'أجري $1 استبدال(ات).',
	'wikieditor-toolbar-tool-replace-emptysearch' => 'لم تكتب شيئًا لتبحث عنه.',
	'wikieditor-toolbar-tool-replace-invalidregex' => 'التعبير النمطي الذي أدخلته غير صالح: $1',
	'wikieditor-toolbar-section-characters' => 'أحرف خاصة',
	'wikieditor-toolbar-characters-page-latin' => 'لاتينية',
	'wikieditor-toolbar-characters-page-latinextended' => 'لاتينية موسعة',
	'wikieditor-toolbar-characters-page-ipa' => 'صوتية دولية',
	'wikieditor-toolbar-characters-page-symbols' => 'رموز',
	'wikieditor-toolbar-characters-page-greek' => 'يونانية',
	'wikieditor-toolbar-characters-page-cyrillic' => 'كيريلية',
	'wikieditor-toolbar-characters-page-arabic' => 'عربية',
	'wikieditor-toolbar-characters-page-arabicextended' => 'عربية موسعة',
	'wikieditor-toolbar-characters-page-persian' => 'الفارسية',
	'wikieditor-toolbar-characters-page-hebrew' => 'عبرية',
	'wikieditor-toolbar-characters-page-bangla' => 'بنغالية',
	'wikieditor-toolbar-characters-page-tamil' => 'تاميلية',
	'wikieditor-toolbar-characters-page-telugu' => 'تيلوجية',
	'wikieditor-toolbar-characters-page-sinhala' => 'سنهالية',
	'wikieditor-toolbar-characters-page-gujarati' => 'غجراتية',
	'wikieditor-toolbar-characters-page-devanagari' => 'ديوناكرية',
	'wikieditor-toolbar-characters-page-thai' => 'تايلندية',
	'wikieditor-toolbar-characters-page-lao' => 'لاوية',
	'wikieditor-toolbar-characters-page-khmer' => 'خميرية',
	'wikieditor-toolbar-section-help' => 'مساعدة',
	'wikieditor-toolbar-help-heading-description' => 'الوصف',
	'wikieditor-toolbar-help-heading-syntax' => 'ما تكتبه',
	'wikieditor-toolbar-help-heading-result' => 'ما تحصل عليه',
	'wikieditor-toolbar-help-page-format' => 'تنسيق',
	'wikieditor-toolbar-help-page-link' => 'وصلات',
	'wikieditor-toolbar-help-page-heading' => 'ترويسات',
	'wikieditor-toolbar-help-page-list' => 'قوائم',
	'wikieditor-toolbar-help-page-file' => 'ملفات',
	'wikieditor-toolbar-help-page-reference' => 'مراجع',
	'wikieditor-toolbar-help-page-discussion' => 'نقاش',
	'wikieditor-toolbar-help-content-italic-description' => 'مائل',
	'wikieditor-toolbar-help-content-italic-syntax' => "''نص مائل''",
	'wikieditor-toolbar-help-content-italic-result' => '<em>نص مائل</em>',
	'wikieditor-toolbar-help-content-bold-description' => 'غليظ',
	'wikieditor-toolbar-help-content-bold-syntax' => "'''نص غليظ'''",
	'wikieditor-toolbar-help-content-bold-result' => '<strong>نص غليظ</strong>',
	'wikieditor-toolbar-help-content-bolditalic-description' => 'غليظ ومائل',
	'wikieditor-toolbar-help-content-bolditalic-syntax' => "'''''نص غليظ ومائل'''''",
	'wikieditor-toolbar-help-content-bolditalic-result' => '<strong><em>نص غليظ ومائل</em></strong>',
	'wikieditor-toolbar-help-content-ilink-description' => 'وصلة داخلية',
	'wikieditor-toolbar-help-content-ilink-syntax' => '[[عنوان الصفحة|اسم الوصلة]]<br />[[عنوان الصفحة]]',
	'wikieditor-toolbar-help-content-ilink-result' => "<a href='#'>اسم الوصلة</a><br /><a href='#'>عنوان الصفحة</a>",
	'wikieditor-toolbar-help-content-xlink-description' => 'وصلة خارجية',
	'wikieditor-toolbar-help-content-xlink-syntax' => '[http://www.example.org اسم الوصلة]<br />[http://www.example.org]<br />http://www.example.org',
	'wikieditor-toolbar-help-content-xlink-result' => "<a href='#' class='external'>اسم الوصلة</a><br /><a href='#' class='external autonumber'>[1]</a><br /><a href='#' class='external'>http://www.example.org</a>",
	'wikieditor-toolbar-help-content-heading2-description' => 'ترويسة المستوى الثاني',
	'wikieditor-toolbar-help-content-heading2-syntax' => '== نص الترويسة ==',
	'wikieditor-toolbar-help-content-heading2-result' => '<h2>نص الترويسة</h2>',
	'wikieditor-toolbar-help-content-heading3-description' => 'ترويسة المستوى الثالث',
	'wikieditor-toolbar-help-content-heading3-syntax' => '=== نص الترويسة ===',
	'wikieditor-toolbar-help-content-heading3-result' => '<h3>نص الترويسة</h3>',
	'wikieditor-toolbar-help-content-heading4-description' => 'توريسة المستوى الرابع',
	'wikieditor-toolbar-help-content-heading4-syntax' => '==== نص الترويسة ====',
	'wikieditor-toolbar-help-content-heading4-result' => '<h4>نص الترويسة</h4>',
	'wikieditor-toolbar-help-content-heading5-description' => 'توريسة المستوى الخامس',
	'wikieditor-toolbar-help-content-heading5-syntax' => '===== نص الترويسة =====',
	'wikieditor-toolbar-help-content-heading5-result' => '<h5>نص الترويسة</h5>',
	'wikieditor-toolbar-help-content-ulist-description' => 'قائمة منقّطة',
	'wikieditor-toolbar-help-content-ulist-syntax' => '* عنصر قائمة<br />* عنصر قائمة',
	'wikieditor-toolbar-help-content-ulist-result' => '<ul><li>عنصر قائمة</li><li>عنصر قائمة</li></ul>',
	'wikieditor-toolbar-help-content-olist-description' => 'قائمة مرقمة',
	'wikieditor-toolbar-help-content-olist-syntax' => '# عنصر قائمة<br /># عنصر قائمة',
	'wikieditor-toolbar-help-content-olist-result' => '<ol><li>عنصر قائمة</li><li>عنصر قائمة</li></ol>',
	'wikieditor-toolbar-help-content-file-description' => 'ملف مضمّن',
	'wikieditor-toolbar-help-content-file-syntax' => '[[$1:Example.png|thumb|نص التعليق]]',
	'wikieditor-toolbar-help-content-file-result' => "<div style='width:104px;' class='thumbinner'><a title='نص التعليق' class='image' href='#'><img height='50' width='100' border='0' class='thumbimage' src='$2/WikiEditor/modules/images/toolbar/example-image.png' alt=''/></a><div class='thumbcaption'><div class='magnify'><a title='تكبير' class='internal' href='#'><img height='11' width='15' alt='' src='$1/common/images/magnify-clip.png'/></a></div>نص التعليق</div></div>",
	'wikieditor-toolbar-help-content-reference-description' => 'مرجع',
	'wikieditor-toolbar-help-content-reference-syntax' => 'نص الصفحة.&lt;ref name="test"&gt;[http://www.example.org نص الوصلة]، نص إضافي.&lt;/ref&gt;',
	'wikieditor-toolbar-help-content-reference-result' => "نص الصفحة.<sup><a href='#'>[1]</a></sup>",
	'wikieditor-toolbar-help-content-rereference-description' => 'استخدام نفس المرجع مرة أخرى',
	'wikieditor-toolbar-help-content-rereference-result' => "نص الصفحة.<sup><a href='#'>[1]</a></sup>",
	'wikieditor-toolbar-help-content-showreferences-description' => 'اعرض المراجع',
	'wikieditor-toolbar-help-content-showreferences-result' => "<ol class='references'><li id='cite_note-test-0'><b><a title='' href='#'>^</a></b> <a rel='nofollow' title='http://www.example.org' class='external text' href='#'>نص الرابط</a>، نص إضافي.</li></ol>",
	'wikieditor-toolbar-help-content-signaturetimestamp-description' => 'التوقيع مع الطابع الزمني',
	'wikieditor-toolbar-help-content-signaturetimestamp-result' => "<a href='#' title='{{#special:mypage}}'>اسم المستخدم</a> (<a href='#' title='{{#special:mytalk}}'>ناقش</a>) 15:54، 10 يونيو 2009 (ت‌ع‌م)",
	'wikieditor-toolbar-help-content-signature-description' => 'التوقيع',
	'wikieditor-toolbar-help-content-signature-result' => "<a href='#' title='{{#special:mypage}}'>اسم المستخدم</a> (<a href='#' title='{{#special:mytalk}}'>ناقش</a>)",
	'wikieditor-toolbar-help-content-indent-description' => 'بادئة',
	'wikieditor-toolbar-help-content-indent-syntax' => 'نص عادي<br />:نص ببادئة<br />::نص ببادئة',
	'wikieditor-toolbar-help-content-indent-result' => 'نص عادي<dl><dd>نص ببادئة<dl><dd>نص ببادئة</dd></dl></dd></dl>',
);

/** Aramaic (ܐܪܡܝܐ)
 * @author Basharh
 * @author Michaelovic
 */
$messages['arc'] = array(
	'wikieditor-preview-tab' => 'ܚܝܪܬܐ ܩܕܡܝܬܐ',
	'wikieditor-preview-changes-tab' => 'ܫܘܚܠܦ̈ܐ',
	'wikieditor-previewDialog-tab' => 'ܚܝܪܐ ܩܕܡܝܐ',
	'wikieditor-publish-button-cancel' => 'ܒܛܘܠ',
	'wikieditor-publish-dialog-minor' => 'ܫܘܚܠܦܐ ܙܥܘܪܐ',
	'wikieditor-publish-dialog-watch' => 'ܪܗܝ ܦܐܬܐ ܗܕܐ',
	'wikieditor-template-editor-dialog-title' => 'ܫܚܠܦ ܩܠܒܐ',
	'wikieditor-template-editor-dialog-submit' => 'ܚܕܬ',
	'wikieditor-template-editor-dialog-cancel' => 'ܒܛܘܠ',
	'wikieditor-toc-show' => 'ܚܘܝ ܚܒܝܫܬ̈ܐ',
	'wikieditor-toc-hide' => 'ܛܫܝ ܚܒܝܫܬ̈ܐ',
	'wikieditor-toolbar-tool-bold' => 'ܥܒܝܬܐ',
	'wikieditor-toolbar-tool-bold-example' => 'ܟܬܒܬܐ ܥܒܝܬܐ',
	'wikieditor-toolbar-tool-italic' => 'ܦܠܝܡܬܐ',
	'wikieditor-toolbar-tool-italic-example' => 'ܟܬܒܬܐ ܦܠܝܡܬܐ',
	'wikieditor-toolbar-tool-ilink' => 'ܐܣܘܪܐ ܓܘܝܐ',
	'wikieditor-toolbar-tool-ilink-example' => 'ܟܘܢܝܐ ܕܐܣܘܪܐ',
	'wikieditor-toolbar-tool-xlink' => 'ܐܣܘܪܐ ܒܪܝܐ (ܕܟܘܪ http:// ܩܕܡܝܬܐ)',
	'wikieditor-toolbar-tool-xlink-example' => 'http://www.example.com ܟܘܢܝܐ ܕܐܣܘܪܐ',
	'wikieditor-toolbar-tool-link' => 'ܐܣܘܪܐ',
	'wikieditor-toolbar-tool-link-title' => 'ܣܢܘܦ ܐܣܘܪܐ',
	'wikieditor-toolbar-tool-link-int' => 'ܠܦܐܬܐ ܕܘܝܩܝ',
	'wikieditor-toolbar-tool-link-int-text' => 'ܟܬܒܬܐ ܠܚܘܘܝܐ',
	'wikieditor-toolbar-tool-link-ext' => 'ܠܦܐܬܐ ܕܢܘܠܐ ܒܪܝܬܐ',
	'wikieditor-toolbar-tool-link-insert' => 'ܣܢܘܦ ܐܣܘܪܐ',
	'wikieditor-toolbar-tool-link-cancel' => 'ܒܛܘܠ',
	'wikieditor-toolbar-tool-link-int-target-status-exists' => 'ܦܐܬܐ ܗܕܐ ܐܝܬ',
	'wikieditor-toolbar-tool-link-int-target-status-notexists' => 'ܦܐܬܐ ܗܕܐ ܠܝܬ',
	'wikieditor-toolbar-tool-link-int-target-status-invalid' => 'ܟܘܢܝܐ ܠܐ ܬܪܝܨܐ',
	'wikieditor-toolbar-tool-link-int-target-status-external' => 'ܐܣܘܪܐ ܒܪܝܐ',
	'wikieditor-toolbar-tool-link-lookslikeinternal-int' => 'ܐܣܘܪܐ ܓܘܝܐ',
	'wikieditor-toolbar-tool-link-lookslikeinternal-ext' => 'ܐܣܘܪܐ ܒܪܝܐ',
	'wikieditor-toolbar-tool-file' => 'ܠܦܦܐ ܛܡܝܪܐ',
	'wikieditor-toolbar-tool-file-example' => 'Example.jpg',
	'wikieditor-toolbar-tool-reference' => 'ܡܒܘܥܐ',
	'wikieditor-toolbar-tool-reference-cancel' => 'ܒܛܘܠ',
	'wikieditor-toolbar-tool-reference-title' => 'ܣܢܘܦ ܡܒܘܥܐ',
	'wikieditor-toolbar-tool-reference-insert' => 'ܣܢܘܦ',
	'wikieditor-toolbar-tool-reference-text' => 'ܟܬܒܬܐ ܕܡܒܘܥܐ',
	'wikieditor-toolbar-tool-signature' => 'ܪܡܝ ܐܝܕܐ ܥܡ ܚܬܡܐ ܕܙܒܢܐ',
	'wikieditor-toolbar-section-advanced' => 'ܡܬܩܕܡܢܐ',
	'wikieditor-toolbar-tool-heading' => 'ܪܘܫܢܐ',
	'wikieditor-toolbar-tool-heading-1' => 'ܫܘܝܐ 1',
	'wikieditor-toolbar-tool-heading-2' => 'ܫܘܝܐ 2',
	'wikieditor-toolbar-tool-heading-3' => 'ܫܘܝܐ 3',
	'wikieditor-toolbar-tool-heading-4' => 'ܫܘܝܐ 4',
	'wikieditor-toolbar-tool-heading-5' => 'ܫܘܝܐ 5',
	'wikieditor-toolbar-tool-heading-example' => 'ܟܬܒܬܐ ܕܪܘܫܢܐ',
	'wikieditor-toolbar-group-format' => 'ܣܕܝܪܘܬܐ',
	'wikieditor-toolbar-tool-redirect' => 'ܨܘܝܒܐ',
	'wikieditor-toolbar-tool-redirect-example' => 'ܫܡܐ ܕܦܐܬܐ ܕܢܘܦܐ',
	'wikieditor-toolbar-tool-big' => 'ܪܒܐ',
	'wikieditor-toolbar-tool-big-example' => 'ܟܬܒܬܐ ܪܒܬܐ',
	'wikieditor-toolbar-tool-small' => 'ܙܥܘܪܐ',
	'wikieditor-toolbar-tool-small-example' => 'ܟܬܒܬܐ ܙܥܘܪܬܐ',
	'wikieditor-toolbar-tool-superscript' => 'ܐܬܘܬܐ ܪܡܬܐ',
	'wikieditor-toolbar-tool-superscript-example' => 'ܟܬܒܬܐ ܕܐܬܘܬܐ ܪܡܬܐ',
	'wikieditor-toolbar-tool-subscript' => 'ܐܬܘܬܐ ܬܚܬܝܬܐ',
	'wikieditor-toolbar-tool-subscript-example' => 'ܟܬܒܬܐ ܕܐܬܘܬܐ ܬܚܬܝܬܐ',
	'wikieditor-toolbar-group-insert' => 'ܣܢܘܦ',
	'wikieditor-toolbar-tool-gallery' => 'ܒܝܬ ܓܠܚܐ ܕܨܘܪ̈ܬܐ',
	'wikieditor-toolbar-tool-newline' => 'ܣܪܛܐ ܚܕܬܐ',
	'wikieditor-toolbar-tool-table' => 'ܠܘܚܝܬܐ',
	'wikieditor-toolbar-tool-table-title' => 'ܣܢܦܐ ܕܠܘܚܝܬܐ',
	'wikieditor-toolbar-tool-table-dimensions-rows' => 'ܨ̈ܦܐ',
	'wikieditor-toolbar-tool-table-dimensions-columns' => 'ܥܡܘܕ̈ܐ',
	'wikieditor-toolbar-tool-table-example' => 'ܡܬܠܐ',
	'wikieditor-toolbar-tool-table-preview' => 'ܚܝܪܐ ܩܕܡܝܐ',
	'wikieditor-toolbar-tool-table-insert' => 'ܣܢܘܦ',
	'wikieditor-toolbar-tool-table-cancel' => 'ܒܛܘܠ',
	'wikieditor-toolbar-tool-replace-button-findnext' => 'ܐܫܟܚ ܕܒܬܪ',
	'wikieditor-toolbar-section-characters' => 'ܐܬܘܬ̈ܐ ܕܝܠܢܝܬ̈ܐ',
	'wikieditor-toolbar-characters-page-latin' => 'ܠܐܛܝܢܐܝܬ',
	'wikieditor-toolbar-characters-page-latinextended' => 'ܠܐܛܝܢܐܝܬ ܡܬܝܚܐ',
	'wikieditor-toolbar-characters-page-ipa' => 'ܐܠܒܝܬ ܩܠܝܬܐ ܬܒܝܠܝܬܐ (IPA)',
	'wikieditor-toolbar-characters-page-symbols' => 'ܪ̈ܡܙܐ',
	'wikieditor-toolbar-characters-page-greek' => 'ܝܘܢܐܝܬ',
	'wikieditor-toolbar-characters-page-cyrillic' => 'ܩܝܪܝܠܐܝܬ',
	'wikieditor-toolbar-characters-page-arabic' => 'ܥܪܒܐܝܬ',
	'wikieditor-toolbar-characters-page-arabicextended' => 'ܥܪܒܐܝܬ ܡܬܝܚܐ',
	'wikieditor-toolbar-characters-page-persian' => 'ܦܪܣܐܝܬ',
	'wikieditor-toolbar-characters-page-hebrew' => 'ܥܒܪܐܝܬ',
	'wikieditor-toolbar-characters-page-bangla' => 'ܒܢܓܐܠܐܝܬ',
	'wikieditor-toolbar-characters-page-tamil' => 'ܛܡܝܠ',
	'wikieditor-toolbar-characters-page-telugu' => 'ܛܝܠܘܓܘܐܝܬ',
	'wikieditor-toolbar-characters-page-sinhala' => 'ܣܢܗܐܠܐܝܬ',
	'wikieditor-toolbar-characters-page-gujarati' => 'ܓܘܓܐܪܐܛܝܐܝܬ',
	'wikieditor-toolbar-characters-page-thai' => 'ܛܝܠܢܕܐܝܬ',
	'wikieditor-toolbar-characters-page-lao' => 'ܠܐܘܐܝܬ',
	'wikieditor-toolbar-characters-page-khmer' => 'ܟܡܝܪܐܝܬ',
	'wikieditor-toolbar-section-help' => 'ܥܘܕܪܢܐ',
	'wikieditor-toolbar-help-heading-description' => 'ܫܘܡܗܐ',
	'wikieditor-toolbar-help-heading-syntax' => 'ܡܕܡ ܟܬܒ ܐܢܬ',
	'wikieditor-toolbar-help-heading-result' => 'ܡܕܡ ܐܬܐ ܠܟ',
	'wikieditor-toolbar-help-page-format' => 'ܣܕܝܪܘܬܐ',
	'wikieditor-toolbar-help-page-link' => 'ܐܣܪ̈ܐ',
	'wikieditor-toolbar-help-page-heading' => 'ܪ̈ܘܫܢܐ',
	'wikieditor-toolbar-help-page-list' => 'ܡܟܬܒܘܬ̈ܐ',
	'wikieditor-toolbar-help-page-file' => 'ܠܦܦ̈ܐ',
	'wikieditor-toolbar-help-page-reference' => 'ܡܒܘܥ̈ܐ',
	'wikieditor-toolbar-help-page-discussion' => 'ܡܡܠܠܐ',
	'wikieditor-toolbar-help-content-italic-description' => 'ܦܠܝܡܬܐ',
	'wikieditor-toolbar-help-content-italic-syntax' => "''ܟܬܒܬܐ ܦܠܝܡܬܐ''",
	'wikieditor-toolbar-help-content-italic-result' => '<em>ܟܬܒܬܐ ܦܠܝܡܬܐ</em>',
	'wikieditor-toolbar-help-content-bold-description' => 'ܥܒܝܬܐ',
	'wikieditor-toolbar-help-content-bold-syntax' => "'''ܟܬܒܬܐ ܥܒܝܬܐ'''",
	'wikieditor-toolbar-help-content-bold-result' => '<strong>ܟܬܒܬܐ ܥܒܝܬܐ</strong>',
	'wikieditor-toolbar-help-content-bolditalic-description' => 'ܦܠܝܡܬܐ &amp; ܥܒܝܬܐ',
	'wikieditor-toolbar-help-content-bolditalic-syntax' => 'ܦܠܝܡܬܐ &amp; ܟܬܒܬܐ ܥܒܝܬܐ',
	'wikieditor-toolbar-help-content-bolditalic-result' => '<strong><em>ܦܠܝܡܬܐ &amp; ܥܒܝܬܐ text</em></strong>',
	'wikieditor-toolbar-help-content-ilink-description' => 'ܐܣܘܪܐ ܓܘܝܐ',
	'wikieditor-toolbar-help-content-xlink-description' => 'ܐܣܘܪܐ ܒܪܝܐ',
	'wikieditor-toolbar-help-content-file-description' => 'ܠܦܦܐ ܛܡܝܪܐ',
	'wikieditor-toolbar-help-content-reference-description' => 'ܡܒܘܥܐ',
	'wikieditor-toolbar-help-content-showreferences-description' => 'ܚܘܝ ܡܒܘܥܐ',
	'wikieditor-toolbar-help-content-signature-description' => 'ܪܡܝ ܐܝܕܐ',
);

/** Egyptian Spoken Arabic (مصرى)
 * @author Dudi
 * @author Meno25
 */
$messages['arz'] = array(
	'wikieditor' => 'Interface متقدم بتاع تعديل wikitext',
	'wikieditor-desc' => 'بيدّى interface بتاع wikitext بينفع يتكبّر و modules كتيره بتنفع تعمل مميزات',
	'wikieditor-wikitext-tab' => 'Wikitext',
	'wikieditor-loading' => 'بيلوّد',
	'wikieditor-preview-preference' => 'شغّل الپروڤه بتاعة الجنب مع جنب',
	'wikieditor-preview-tab' => 'پروڤه',
	'wikieditor-preview-changes-tab' => 'تغييرات',
	'wikieditor-preview-loading' => 'بيلوّد...',
	'wikieditor-previewDialog-tab' => 'پروڤه',
	'wikieditor-previewDialog-loading' => 'بيلوّد...',
	'wikieditor-publish-preference' => 'شغل النشر واحده بواحده',
	'wikieditor-publish-button-publish' => 'انشر',
	'wikieditor-publish-button-cancel' => 'كانسل',
	'wikieditor-publish-dialog-title' => 'انشر فى {{SITENAME}}',
	'wikieditor-publish-dialog-summary' => 'ملخص التعديل (اشرح بإختصار التغييرات اللى عملتها):',
	'wikieditor-publish-dialog-minor' => 'تعديل صغير',
	'wikieditor-publish-dialog-watch' => 'راقب الصفحه دى',
	'wikieditor-publish-dialog-publish' => 'انشر',
	'wikieditor-publish-dialog-goback' => 'ارجع',
	'wikieditor-template-editor-preference' => 'شغّل تعديل قوالب الwiki على اساس الفورمه',
	'wikieditor-template-editor-dialog-title' => 'تعديل قالب',
	'wikieditor-template-editor-dialog-submit' => 'تحديث (update)',
	'wikieditor-template-editor-dialog-cancel' => 'كانسل',
	'wikieditor-templates-preference' => 'خلّى القالب يبان مقفول',
	'wikieditor-toc-preference' => 'Enable navigable table of contents',
	'wikieditor-toc-show' => 'بيّن المحتويات',
	'wikieditor-toc-hide' => 'خبّى المحتويات',
	'wikieditor-toolbar' => 'شريط عدّة التحرير',
	'wikieditor-toolbar-desc' => 'عدّل صفحة العدّة بالenhanced usability',
	'wikieditor-toolbar-loading' => 'بتلوّد...',
	'wikieditor-toolbar-tool-bold' => 'Bold',
	'wikieditor-toolbar-tool-bold-example' => 'Bold text',
	'wikieditor-toolbar-tool-italic' => 'Italic',
	'wikieditor-toolbar-tool-italic-example' => 'Italic text',
	'wikieditor-toolbar-tool-ilink' => 'لينك جوّانى',
	'wikieditor-toolbar-tool-ilink-example' => 'عنوان اللينك',
	'wikieditor-toolbar-tool-xlink' => 'لينك برّانى (افتكر تبتدى بـ http://)',
	'wikieditor-toolbar-tool-xlink-example' => 'http://www.example.com عنوان اللينك',
	'wikieditor-toolbar-tool-link' => 'لينك',
	'wikieditor-toolbar-tool-link-title' => 'حُط لينك',
	'wikieditor-toolbar-tool-link-int' => 'لصفحة wiki',
	'wikieditor-toolbar-tool-link-int-target' => 'الصفحه او الURL:',
	'wikieditor-toolbar-tool-link-int-target-tooltip' => 'عنوان الصفحه او الURL',
	'wikieditor-toolbar-tool-link-int-text' => 'التكست اللى يتبيّن:',
	'wikieditor-toolbar-tool-link-int-text-tooltip' => 'التكست اللى ح يبان',
	'wikieditor-toolbar-tool-link-ext' => 'لصفحة web برّانيّه',
	'wikieditor-toolbar-tool-link-ext-target' => 'Link URL:',
	'wikieditor-toolbar-tool-link-ext-text' => 'تكست اللينك:',
	'wikieditor-toolbar-tool-link-insert' => 'حط لينك',
	'wikieditor-toolbar-tool-link-cancel' => 'كانسل',
	'wikieditor-toolbar-tool-link-int-target-status-exists' => 'الصفحه موجوده',
	'wikieditor-toolbar-tool-link-int-target-status-notexists' => 'الصفحه مش موجوده',
	'wikieditor-toolbar-tool-link-int-target-status-invalid' => 'لينك مش موجود',
	'wikieditor-toolbar-tool-link-int-target-status-external' => 'لينك برّانى',
	'wikieditor-toolbar-tool-link-int-target-status-loading' => 'بيتشيّك على وجود الصفحه...',
	'wikieditor-toolbar-tool-link-int-invalid' => 'العنوان اللى حددته مش موجود.',
	'wikieditor-toolbar-tool-link-lookslikeinternal' => 'الURL اللى حددته باين عليه انه كان مقصود انه يحوّل على صفحة ويكى تانيه. عايز تخلّيه لينك جوّانى؟',
	'wikieditor-toolbar-tool-link-lookslikeinternal-int' => 'لينك جوّانى',
	'wikieditor-toolbar-tool-link-lookslikeinternal-ext' => 'لينك برّانى',
	'wikieditor-toolbar-tool-link-empty' => 'انت ما حطّيتش اى حاجه علشان يتوصّل عليها.',
	'wikieditor-toolbar-tool-file' => 'Embedded file',
	'wikieditor-toolbar-tool-reference' => 'مرجع',
	'wikieditor-toolbar-tool-reference-example' => 'اعمل insert لنَص الfootnote هنا',
	'wikieditor-toolbar-tool-reference-cancel' => 'كانسل',
	'wikieditor-toolbar-tool-reference-title' => 'حط مرجع',
	'wikieditor-toolbar-tool-reference-insert' => 'حط',
	'wikieditor-toolbar-tool-reference-text' => 'التكست بتاع المرجع',
	'wikieditor-toolbar-tool-signature' => 'الامضا و ختم الوقت',
	'wikieditor-toolbar-section-advanced' => 'متقدم',
	'wikieditor-toolbar-tool-heading-example' => 'تكست العنوان',
	'wikieditor-toolbar-group-format' => 'Format',
	'wikieditor-toolbar-tool-ulist' => 'ليسته منقطه بـbullets',
	'wikieditor-toolbar-tool-ulist-example' => 'Bulleted list item',
	'wikieditor-toolbar-tool-olist' => 'ليسته مترقمه',
	'wikieditor-toolbar-tool-olist-example' => 'Item اليسته المترقمه',
	'wikieditor-toolbar-tool-indent' => 'المسافه اللى فى الاول (indentation)',
	'wikieditor-toolbar-tool-indent-example' => 'السطر الindented',
	'wikieditor-toolbar-tool-nowiki' => 'مافيش فورمات للويكى',
	'wikieditor-toolbar-tool-nowiki-example' => 'حط تكست مش معمول‍له فورمات هنا',
	'wikieditor-toolbar-tool-redirect' => 'تحويل',
	'wikieditor-toolbar-tool-redirect-example' => 'اسم الصفحه المقصوده',
	'wikieditor-toolbar-tool-big' => 'كبير',
	'wikieditor-toolbar-tool-big-example' => 'تكست كبير',
	'wikieditor-toolbar-tool-small' => 'صغير',
	'wikieditor-toolbar-tool-small-example' => 'تكست صغير',
	'wikieditor-toolbar-tool-superscript' => 'Superscript',
	'wikieditor-toolbar-tool-superscript-example' => 'Superscript text',
	'wikieditor-toolbar-tool-subscript' => 'Subscript',
	'wikieditor-toolbar-tool-subscript-example' => 'Subscript text',
	'wikieditor-toolbar-group-insert' => 'حط',
	'wikieditor-toolbar-tool-gallery' => 'جاليرى الصور',
	'wikieditor-toolbar-tool-gallery-example' => '$1:Example.jpg|Caption1
$1:Example.jpg|Caption2',
	'wikieditor-toolbar-tool-newline' => 'سطر جديد',
	'wikieditor-toolbar-tool-table' => 'جدول',
	'wikieditor-toolbar-tool-table-example-old' => '! header 1
! header 2
! header 3
|-
| row 1, cell 1
| row 1, cell 2
| row 1, cell 3
|-
| row 2, cell 1
| row 2, cell 2',
	'wikieditor-toolbar-tool-table-example-cell-text' => 'Cell text',
	'wikieditor-toolbar-tool-table-example-header' => 'تكست العنوان',
	'wikieditor-toolbar-tool-table-title' => 'حط جدول',
	'wikieditor-toolbar-tool-table-dimensions-rows' => 'صفوق',
	'wikieditor-toolbar-tool-table-dimensions-columns' => 'عواميد',
	'wikieditor-toolbar-tool-table-dimensions-header' => 'زوّد صف عنوان',
	'wikieditor-toolbar-tool-table-wikitable' => 'Style with borders',
	'wikieditor-toolbar-tool-table-sortable' => 'خلّى الجدول ينفع يترتب',
	'wikieditor-toolbar-tool-table-example' => 'مثال',
	'wikieditor-toolbar-tool-table-preview' => 'پروڤه',
	'wikieditor-toolbar-tool-table-insert' => 'حط',
	'wikieditor-toolbar-tool-table-cancel' => 'كانسل',
	'wikieditor-toolbar-tool-table-toomany' => 'مش ممكن يتعمل insert لـ table بأكتر من $1 cells بالـ dialog ده.',
	'wikieditor-toolbar-tool-table-invalidnumber' => 'انت ما دخّلتش رقم موجود للـ rows او الـ columns',
	'wikieditor-toolbar-tool-table-zero' => 'ما ينفعش تعمل insert لـ table من-غير rows او columns.',
	'wikieditor-toolbar-tool-replace' => 'دوّر و بدّل',
	'wikieditor-toolbar-tool-replace-title' => 'دوّر و بدّل',
	'wikieditor-toolbar-tool-replace-search' => 'دوّر على:',
	'wikieditor-toolbar-tool-replace-replace' => 'بدّل بـ:',
	'wikieditor-toolbar-tool-replace-case' => 'Match case',
	'wikieditor-toolbar-tool-replace-regex' => 'Treat search string as a regular expression',
	'wikieditor-toolbar-tool-replace-button-findnext' => 'شوف اللى بعده',
	'wikieditor-toolbar-tool-replace-button-replaceall' => 'بدلهم كلهم',
	'wikieditor-toolbar-tool-replace-close' => 'إقفل',
	'wikieditor-toolbar-tool-replace-nomatch' => 'التدوير بتاعك ما وصلش لأى حاجه.',
	'wikieditor-toolbar-tool-replace-success' => '$1 تبديلات اتعملت.',
	'wikieditor-toolbar-tool-replace-emptysearch' => 'انت ما حطّيتش اى حاجه علشان تدوّر عليها.',
	'wikieditor-toolbar-tool-replace-invalidregex' => 'The regular expression you entered is invalid: $1',
	'wikieditor-toolbar-section-characters' => 'Special characters',
	'wikieditor-toolbar-characters-page-latin' => 'لاتينى',
	'wikieditor-toolbar-characters-page-latinextended' => 'Latin extended',
	'wikieditor-toolbar-characters-page-ipa' => 'IPA',
	'wikieditor-toolbar-characters-page-greek' => 'يونانى',
	'wikieditor-toolbar-characters-page-cyrillic' => 'كيريلى',
	'wikieditor-toolbar-characters-page-arabic' => 'عربى',
	'wikieditor-toolbar-characters-page-hebrew' => 'عبرى',
	'wikieditor-toolbar-characters-page-bangla' => 'بانجلاديشى',
	'wikieditor-toolbar-characters-page-telugu' => 'Telugu',
	'wikieditor-toolbar-characters-page-sinhala' => 'Sinhala',
	'wikieditor-toolbar-characters-page-gujarati' => 'Gujarati',
	'wikieditor-toolbar-section-help' => 'مساعده',
	'wikieditor-toolbar-help-heading-description' => 'الوصف',
	'wikieditor-toolbar-help-heading-syntax' => 'اللى بتكتبه',
	'wikieditor-toolbar-help-heading-result' => 'اللى بتاخده',
	'wikieditor-toolbar-help-page-format' => 'Formatting',
	'wikieditor-toolbar-help-page-link' => 'لينكات',
	'wikieditor-toolbar-help-page-heading' => 'Headings',
	'wikieditor-toolbar-help-page-list' => 'ليسَت',
	'wikieditor-toolbar-help-page-file' => 'فايلات',
	'wikieditor-toolbar-help-page-reference' => 'مراجع',
	'wikieditor-toolbar-help-page-discussion' => 'مناقشه',
	'wikieditor-toolbar-help-content-italic-description' => 'Italic',
	'wikieditor-toolbar-help-content-italic-syntax' => "''Italic text''",
	'wikieditor-toolbar-help-content-italic-result' => '<em>Italic text</em>',
	'wikieditor-toolbar-help-content-bold-description' => 'Bold',
	'wikieditor-toolbar-help-content-bold-syntax' => "'''Bold text'''",
	'wikieditor-toolbar-help-content-bold-result' => '<strong>Bold text</strong>',
	'wikieditor-toolbar-help-content-bolditalic-description' => 'Bold &amp; italic',
	'wikieditor-toolbar-help-content-bolditalic-syntax' => "'''''Bold &amp; italic text'''''",
	'wikieditor-toolbar-help-content-bolditalic-result' => '<strong><em>Bold &amp; italic text</em></strong>',
	'wikieditor-toolbar-help-content-ilink-description' => 'لينك جوّانى',
	'wikieditor-toolbar-help-content-ilink-syntax' => '[[اسم الصفحه|اسم اللينك]]<br />[[اسم الصفحه]]',
	'wikieditor-toolbar-help-content-ilink-result' => "<a href='#'>اسم اللينك</a><br /><a href='#'>اسم الصفحه</a>",
	'wikieditor-toolbar-help-content-xlink-description' => 'لينك برّانى',
	'wikieditor-toolbar-help-content-xlink-syntax' => '[http://www.example.org اسم اللينك]<br />[http://www.example.org]<br />http://www.example.org',
	'wikieditor-toolbar-help-content-xlink-result' => "<a href='#' class='external'>اسم اللينك</a><br /><a href='#' class='external autonumber'>[1]</a><br /><a href='#' class='external'>http://www.example.org</a>",
	'wikieditor-toolbar-help-content-heading2-description' => '2nd level heading',
	'wikieditor-toolbar-help-content-heading2-syntax' => '== Heading text ==',
	'wikieditor-toolbar-help-content-heading2-result' => '<h2>Heading text</h2>',
	'wikieditor-toolbar-help-content-heading3-description' => '3rd level heading',
	'wikieditor-toolbar-help-content-heading3-syntax' => '=== Heading text ===',
	'wikieditor-toolbar-help-content-heading4-description' => '4th level heading',
	'wikieditor-toolbar-help-content-heading4-result' => '<h4>Heading text</h4>',
	'wikieditor-toolbar-help-content-heading5-description' => '5th level heading',
	'wikieditor-toolbar-help-content-heading5-syntax' => '===== Heading text =====',
	'wikieditor-toolbar-help-content-heading5-result' => '<h5>Heading text</h5>',
	'wikieditor-toolbar-help-content-ulist-description' => 'ليسته فيها bullets',
	'wikieditor-toolbar-help-content-ulist-syntax' => '* List item<br />* List item',
	'wikieditor-toolbar-help-content-ulist-result' => '<ul><li>List item</li><li>List item</li></ul>',
	'wikieditor-toolbar-help-content-olist-description' => 'ليسته مترقمه',
	'wikieditor-toolbar-help-content-olist-syntax' => '# List item<br /># List item',
	'wikieditor-toolbar-help-content-olist-result' => '<ol><li>List item</li><li>List item</li></ol>',
	'wikieditor-toolbar-help-content-file-description' => 'Embedded file',
	'wikieditor-toolbar-help-content-file-syntax' => '[[$1:Example.png|thumb|Caption text]]',
	'wikieditor-toolbar-help-content-file-result' => "<div style='width:104px;' class='thumbinner'><a title='Caption text' class='image' href='#'><img height='50' width='100' border='0' class='thumbimage' src='$2/WikiEditor/modules/images/toolbar/example-image.png' alt=''/></a><div class='thumbcaption'><div class='magnify'><a title='Enlarge' class='internal' href='#'><img height='11' width='15' alt='' src='$1/common/images/magnify-clip.png'/></a></div>Caption text</div></div>",
	'wikieditor-toolbar-help-content-reference-description' => 'مرجع',
	'wikieditor-toolbar-help-content-reference-syntax' => 'Page text.&lt;ref name="test"&gt;[http://www.example.org Link text], additional text.&lt;/ref&gt;',
	'wikieditor-toolbar-help-content-reference-result' => "Page text.<sup><a href='#'>[1]</a></sup>",
	'wikieditor-toolbar-help-content-rereference-description' => 'إستعمل تانى نفس المرجع',
	'wikieditor-toolbar-help-content-rereference-result' => "Page text.<sup><a href='#'>[1]</a></sup>",
	'wikieditor-toolbar-help-content-showreferences-description' => 'اعرض المراجع',
	'wikieditor-toolbar-help-content-showreferences-result' => "<ol class='references'><li id='cite_note-test-0'><b><a title='' href='#'>^</a></b> <a rel='nofollow' title='http://www.example.org' class='external text' href='#'>Link text</a>, additional text.</li></ol>",
	'wikieditor-toolbar-help-content-signaturetimestamp-description' => 'الامضا مع ختم الوقت',
	'wikieditor-toolbar-help-content-signaturetimestamp-result' => "<a href='#' title='{{#special:mypage}}'>اسم اليوزر</a> (<a href='#' title='{{#special:mytalk}}'>كلّمه</a>) 15:54,‏ 10 يونيه 2009 ‏(UTC)‏",
	'wikieditor-toolbar-help-content-signature-description' => 'امضا',
	'wikieditor-toolbar-help-content-signature-result' => "<a href='#' title='{{#special:mypage}}'>اسم اليوزر</a> (<a href='#' title='{{#special:mytalk}}'>كلّم</a>)",
	'wikieditor-toolbar-help-content-indent-description' => 'Indent',
	'wikieditor-toolbar-help-content-indent-syntax' => 'Normal text<br />:Indented text<br />::Indented text',
	'wikieditor-toolbar-help-content-indent-result' => 'Normal text<dl><dd>Indented text<dl><dd>Indented text</dd></dl></dd></dl>',
);

/** Assamese (অসমীয়া)
 * @author Bishnu Saikia
 * @author Chaipau
 * @author Gitartha.bordoloi
 * @author Nilamdyuti
 */
$messages['as'] = array(
	'wikieditor' => "উচ্চতৰ ৱিকিপাঠ্য সম্পাদনা ইণ্টাৰফে'চ",
	'wikieditor-desc' => "এখন বহলাব পৰা ৱিকিপাঠ্য সম্পাদনা ইণ্টাৰফে'চ আৰু বহু বৈশিষ্টসম্পন্ন মডিউল প্ৰদান কৰে",
	'wikieditor-wikitext-tab' => 'ৱিকিপাঠ্য',
	'wikieditor-loading' => "ল'ড হৈ আছে…",
	'wikieditor-preview-preference' => 'ওচৰা-ওচৰি প্ৰাক্‌দৰ্শন সক্ৰিয় কৰক',
	'wikieditor-preview-tab' => 'প্রাকদর্শন',
	'wikieditor-preview-changes-tab' => 'পৰিবৰ্তনসমূহ',
	'wikieditor-preview-loading' => "ল'ড হৈ আছে…",
	'wikieditor-previewDialog-preference' => 'প্ৰাকদৰ্শন বাৰ্তা সক্ৰিয় কৰক',
	'wikieditor-previewDialog-tab' => 'খচৰা',
	'wikieditor-previewDialog-loading' => "ল'ড হৈ আছে…",
	'wikieditor-publish-preference' => 'ধাপে ধাপে প্ৰকাশ কৰা সক্ৰিয় কৰক',
	'wikieditor-publish-button-publish' => 'প্ৰকাশ কৰক',
	'wikieditor-publish-button-cancel' => 'বাতিল কৰক',
	'wikieditor-publish-dialog-title' => '{{SITENAME}} ত প্ৰকাশ কৰক',
	'wikieditor-publish-dialog-summary' => 'সম্পাদনা সাৰাংশ (আপুনি কি পৰিবর্তন কৰিছে সেই বিষয়ে অলপ লিখক):',
	'wikieditor-publish-dialog-minor' => 'অগুৰুত্বপূৰ্ণ সম্পাদনা',
	'wikieditor-publish-dialog-watch' => 'এই পৃষ্ঠাটো লক্ষ্য কৰক',
	'wikieditor-publish-dialog-publish' => 'প্ৰকাশ কৰক',
	'wikieditor-publish-dialog-goback' => 'পাছলৈ যাওক',
	'wikieditor-template-editor-preference' => 'ৱিকি সাঁচৰ ফৰ্ম-ভিত্তিক সম্পাদনা সক্ৰিয় কৰক',
	'wikieditor-template-editor-dialog-title' => 'সাঁচ সম্পাদনা',
	'wikieditor-template-editor-dialog-submit' => 'আপডেট',
	'wikieditor-template-editor-dialog-cancel' => 'বাতিল',
	'wikieditor-templates-preference' => 'সাঁচৰ ভাঁজ সক্ৰিয় কৰক',
	'wikieditor-toc-preference' => 'দিক্‌দৰ্শন সূচী সক্ৰিয় কৰক',
	'wikieditor-toc-show' => 'বিষয়বস্তু দেখাওক',
	'wikieditor-toc-hide' => 'সূচীসমূহ লুকুৱাওক',
	'wikieditor-toolbar' => 'সম্পাদনা টুলবাৰ',
	'wikieditor-toolbar-desc' => 'অধিক ব্যৱহাৰযোগ্য সম্পাদনা পৃষ্ঠাৰ টুলবাৰ',
	'wikieditor-toolbar-preference' => 'শক্তিশালী সম্পাদনা টুলবাৰ সক্ৰিয় কৰক',
	'wikieditor-toolbar-dialogs-preference' => 'লিংক, টেবল আৰু অধিক বস্তু সংযোজনৰ বাবে ডায়লগ সক্ৰিয় কৰক',
	'wikieditor-toolbar-hidesig' => 'মুখ্য নামস্থানৰ পৃষ্ঠাবোৰত স্বাক্ষৰ বুটাম লুকুৱাওক',
	'wikieditor-toolbar-loading' => "ল'ড হৈ আছে…",
	'wikieditor-toolbar-tool-bold' => 'গাঢ়',
	'wikieditor-toolbar-tool-bold-example' => 'গাঢ় পাঠ্য',
	'wikieditor-toolbar-tool-italic' => 'হেলনীয়া',
	'wikieditor-toolbar-tool-italic-example' => 'হেলনীয়া পাঠ্য',
	'wikieditor-toolbar-tool-ilink' => 'ভিতৰুৱা সংযোগ',
	'wikieditor-toolbar-tool-ilink-example' => 'শিৰোনামা সংযোগ',
	'wikieditor-toolbar-tool-xlink' => 'বহ্যিক সংযোগ (http:// উপসৰ্গ মনত ৰাখিব)',
	'wikieditor-toolbar-tool-xlink-example' => 'http://www.example.com শীৰ্ষক সংযোগ',
	'wikieditor-toolbar-tool-link' => 'সংযোগ',
	'wikieditor-toolbar-tool-link-title' => 'লিংক যোগ কৰক',
	'wikieditor-toolbar-tool-link-int' => 'কোনো ৱিকি পৃঠালৈ',
	'wikieditor-toolbar-tool-link-int-target' => 'লক্ষ্য পৃষ্ঠা বা ইউ.আৰ.এল.',
	'wikieditor-toolbar-tool-link-int-target-tooltip' => 'পৃষ্ঠাৰ শিৰোনাম বা ইউআৰএল',
	'wikieditor-toolbar-tool-link-int-text' => 'প্ৰদৰ্শন হ’ব লগা পাঠ্য:',
	'wikieditor-toolbar-tool-link-int-text-tooltip' => 'যে পাঠ্য দৃশ্যমান হ’ব',
	'wikieditor-toolbar-tool-link-ext' => 'বাহ্যিক কোনো ৱেবপেজলৈ',
	'wikieditor-toolbar-tool-link-ext-target' => 'সংযোগী ইউআৰএল:',
	'wikieditor-toolbar-tool-link-ext-text' => 'সংযোগী পাঠ্য:',
	'wikieditor-toolbar-tool-link-insert' => 'লিংক যোগ কৰক',
	'wikieditor-toolbar-tool-link-cancel' => 'বাতিল',
	'wikieditor-toolbar-tool-link-int-target-status-exists' => 'পৃষ্ঠা আছে',
	'wikieditor-toolbar-tool-link-int-target-status-notexists' => 'পৃষ্ঠা নাই',
	'wikieditor-toolbar-tool-link-int-target-status-invalid' => 'ভুল শীৰ্ষক',
	'wikieditor-toolbar-tool-link-int-target-status-external' => 'বাহ্যিক সংযোগ',
	'wikieditor-toolbar-tool-link-int-target-status-loading' => 'পৃষ্ঠাৰ অস্তিত্ব পৰীক্ষা কৰি থকা হৈছে...',
	'wikieditor-toolbar-tool-link-int-invalid' => 'আপুনি নিৰ্ধাৰণ কৰা শিৰোনামাটো অবৈধ ।',
	'wikieditor-toolbar-tool-link-lookslikeinternal' => 'আপুনি নিৰ্দেশ কৰা ইউআৰএল টো আন এখন ৱিকি পৃষ্ঠালৈ লিংক যেন অনুমান হৈছে।
আপুনি ইয়াক এটা আভ্যন্তৰীণ লিংক কৰিব খুজিছে নেকি?',
	'wikieditor-toolbar-tool-link-lookslikeinternal-int' => 'আভ্যন্তৰীণ সংযোগ',
	'wikieditor-toolbar-tool-link-lookslikeinternal-ext' => 'বাহ্যিক সংযোগ',
	'wikieditor-toolbar-tool-link-empty' => 'লিংক কৰিবলৈ আপুনি একো টাইপ কৰা নাই।',
	'wikieditor-toolbar-tool-file' => 'এম্বেডেড ফাইল',
	'wikieditor-toolbar-tool-file-example' => 'Example.jpg',
	'wikieditor-toolbar-tool-file-title' => 'ফাইল সুমুৱাওক',
	'wikieditor-toolbar-file-target' => 'ফাইলৰ নাম:',
	'wikieditor-toolbar-file-caption' => 'পাতনি:',
	'wikieditor-toolbar-file-size' => 'আকাৰ:',
	'wikieditor-toolbar-file-float' => 'সংৰেখিত কৰক',
	'wikieditor-toolbar-file-default' => '(default)',
	'wikieditor-toolbar-file-format' => 'বিন্যাস:',
	'wikieditor-toolbar-tool-file-insert' => 'সুমুৱাওক',
	'wikieditor-toolbar-tool-file-cancel' => 'বাতিল কৰক',
	'wikieditor-toolbar-tool-reference' => 'তথ্যসংগ্ৰহ',
	'wikieditor-toolbar-tool-reference-example' => 'পাদটীকাৰ লিখনি ইয়াত যোগ দিয়ক',
	'wikieditor-toolbar-tool-reference-cancel' => 'বাতিল',
	'wikieditor-toolbar-tool-reference-title' => 'তথ্যসূত্ৰ যোগ',
	'wikieditor-toolbar-tool-reference-insert' => 'যোগ কৰক',
	'wikieditor-toolbar-tool-reference-text' => 'তথ্যসূত্ৰ পাঠ্য',
	'wikieditor-toolbar-tool-signature' => 'সময়ৰ সৈতে আপোনাৰ স্বাক্ষৰ',
	'wikieditor-toolbar-section-advanced' => 'উচ্চতৰ',
	'wikieditor-toolbar-tool-heading' => 'শিৰোনাম',
	'wikieditor-toolbar-tool-heading-1' => 'শিৰোনাম ১',
	'wikieditor-toolbar-tool-heading-2' => 'শিৰোনাম ২',
	'wikieditor-toolbar-tool-heading-3' => 'শিৰোনাম ৩',
	'wikieditor-toolbar-tool-heading-4' => 'শিৰোনাম ৪',
	'wikieditor-toolbar-tool-heading-5' => 'শিৰোনাম ৫',
	'wikieditor-toolbar-tool-heading-example' => 'শিৰোনামা পাঠ্য',
	'wikieditor-toolbar-group-format' => 'ফৰ্মেট:',
	'wikieditor-toolbar-tool-ulist' => 'বুলেটকৃত তালিকা',
	'wikieditor-toolbar-tool-ulist-example' => 'বুলেটকৃত তালিকা আইটেম',
	'wikieditor-toolbar-tool-olist' => 'সংখ্যায়িত তালিকা',
	'wikieditor-toolbar-tool-olist-example' => 'সংখ্যায়িত তালিকা আইটেম',
	'wikieditor-toolbar-tool-indent' => 'ইণ্ডেটেছন',
	'wikieditor-toolbar-tool-indent-example' => 'ইণ্ডেটেড শাৰী',
	'wikieditor-toolbar-tool-nowiki' => 'কোনো ৱিকি ফৰ্মেটিং নাই',
	'wikieditor-toolbar-tool-nowiki-example' => 'নসজোৱা পাঠ্য ইয়াত অন্তৰ্ভুক্ত কৰক',
	'wikieditor-toolbar-tool-redirect' => 'পুনঃনিৰ্দেশ',
	'wikieditor-toolbar-tool-redirect-example' => 'লক্ষ পৃষ্ঠাৰ নাম',
	'wikieditor-toolbar-tool-big' => 'ডাঙৰ',
	'wikieditor-toolbar-tool-big-example' => 'ডাঙৰ আখৰ',
	'wikieditor-toolbar-tool-small' => 'সৰু',
	'wikieditor-toolbar-tool-small-example' => 'সৰু আখৰ',
	'wikieditor-toolbar-tool-superscript' => 'চুপাৰস্ক্ৰিপ্ট',
	'wikieditor-toolbar-tool-superscript-example' => 'চুপাৰস্ক্ৰিপ্ট পাঠ্য',
	'wikieditor-toolbar-tool-subscript' => 'চাব্‌স্ক্ৰিপ্ট',
	'wikieditor-toolbar-tool-subscript-example' => 'চাব্‌স্ক্ৰিপ্ট পাঠ্য',
	'wikieditor-toolbar-group-insert' => 'যোগ কৰক',
	'wikieditor-toolbar-tool-gallery' => 'আলোকচিত্ৰ ভৰাল',
	'wikieditor-toolbar-tool-gallery-example' => '$1:Example.jpg|শিৰোনাম ১
$1:Example.jpg|শিৰোনাম ২',
	'wikieditor-toolbar-tool-newline' => 'নতুন লাইন',
	'wikieditor-toolbar-tool-table' => 'টেবুল',
	'wikieditor-toolbar-tool-table-example-old' => '-
! শিৰোনাম ১
! শিৰোনাম ২
! শিৰোনাম ৩
|-
| শাৰী ১, ঘৰ ১
| শাৰী ১, ঘৰ ২
| শাৰী ১, ঘৰ ৩
|-
| শাৰী ২, ঘৰ ১
| শাৰী ২, ঘৰ ২
| শাৰী ২, ঘৰ ৩',
	'wikieditor-toolbar-tool-table-example-cell-text' => 'ঘৰৰ আখৰ',
	'wikieditor-toolbar-tool-table-example-header' => 'শিৰোনামৰ আখৰ',
	'wikieditor-toolbar-tool-table-title' => 'টেবুল যোগ কৰক',
	'wikieditor-toolbar-tool-table-dimensions-rows' => 'পথালী শাৰী:',
	'wikieditor-toolbar-tool-table-dimensions-columns' => 'ঠিয় শাৰী:',
	'wikieditor-toolbar-tool-table-dimensions-header' => 'শিৰোনাম শাৰী অন্তৰ্ভুক্ত কৰক',
	'wikieditor-toolbar-tool-table-wikitable' => 'সীমান্ত শৈলী',
	'wikieditor-toolbar-tool-table-sortable' => 'সম্প্ৰসাৰণ্যোগ্য টেবুল সৃষ্টি কৰক',
	'wikieditor-toolbar-tool-table-example' => 'উদাহৰণ',
	'wikieditor-toolbar-tool-table-preview' => 'প্ৰাকদৰ্শন',
	'wikieditor-toolbar-tool-table-insert' => 'যোগ কৰক',
	'wikieditor-toolbar-tool-table-cancel' => 'বাতিল',
	'wikieditor-toolbar-tool-table-toomany' => 'এই ডায়লগৰ দ্বাৰা $1 ঘৰতকৈ বেছি থকা টেবুল যোগ কৰা সম্ভৱ নহয়।',
	'wikieditor-toolbar-tool-table-invalidnumber' => 'আপুনি উলম্ব আৰু পথালী শাৰীৰ বৈধ সংখ্যা লিখাত ভুল কৰিছে।',
	'wikieditor-toolbar-tool-table-zero' => 'আপুনি শূন্য উলম্ব বা পথালী শাৰী থকা টেবুল যোগ কৰিব নোৱাৰে।',
	'wikieditor-toolbar-tool-replace' => 'অনুসন্ধান আৰু প্ৰতিস্থাপন',
	'wikieditor-toolbar-tool-replace-title' => 'অনুসন্ধান আৰু প্ৰতিস্থাপন',
	'wikieditor-toolbar-tool-replace-search' => 'ৰ কাৰণে সন্ধান কৰক',
	'wikieditor-toolbar-tool-replace-replace' => 'ইয়াৰ লগত প্ৰতিস্থাপন কৰক:',
	'wikieditor-toolbar-tool-replace-case' => 'আখৰৰ ফলা মিলাওক',
	'wikieditor-toolbar-tool-replace-regex' => 'অনুসন্ধান বাক্যক নিয়মিত এক্সপ্ৰেছন হিচাপে গণ্য কৰক',
	'wikieditor-toolbar-tool-replace-button-findnext' => 'পৰৱৰ্তী অনুসন্ধান',
	'wikieditor-toolbar-tool-replace-button-replace' => 'প্ৰতিস্থাপন',
	'wikieditor-toolbar-tool-replace-button-replaceall' => 'সকলো  প্ৰতিস্থাপন',
	'wikieditor-toolbar-tool-replace-close' => 'বন্ধ',
	'wikieditor-toolbar-tool-replace-nomatch' => 'আপোনাৰ অনুসন্ধানৰ কতো সামঞ্জচ্য পোৱা ন’গল।',
	'wikieditor-toolbar-tool-replace-success' => '$1 টো প্ৰতিস্থাপন সম্পন্ন হৈছে।',
	'wikieditor-toolbar-tool-replace-emptysearch' => 'সন্ধান কৰিবলৈ আপুনি একো টাইপ কৰা নাই।',
	'wikieditor-toolbar-tool-replace-invalidregex' => 'আপুনি প্ৰদান কৰা ৰেগুলাৰ এক্সপ্রেছনটো অবৈধ: $1',
	'wikieditor-toolbar-section-characters' => 'বিশেষ চিহ্নসমূহ:',
	'wikieditor-toolbar-characters-page-latin' => 'লেটিন',
	'wikieditor-toolbar-characters-page-latinextended' => 'সম্প্ৰসাৰিত লেটিন',
	'wikieditor-toolbar-characters-page-ipa' => 'আইপিএ (IPA)',
	'wikieditor-toolbar-characters-page-symbols' => 'চিহ্নসমূহ',
	'wikieditor-toolbar-characters-page-greek' => 'গ্ৰীক',
	'wikieditor-toolbar-characters-page-cyrillic' => 'ছিৰিলিক',
	'wikieditor-toolbar-characters-page-arabic' => 'আৰবীক',
	'wikieditor-toolbar-characters-page-arabicextended' => 'সম্প্ৰসাৰিত আৰবীক',
	'wikieditor-toolbar-characters-page-persian' => 'ফাৰ্ছী',
	'wikieditor-toolbar-characters-page-hebrew' => 'হিব্ৰু',
	'wikieditor-toolbar-characters-page-bangla' => 'বাংলা',
	'wikieditor-toolbar-characters-page-tamil' => 'তামিল',
	'wikieditor-toolbar-characters-page-telugu' => 'তেলেগু',
	'wikieditor-toolbar-characters-page-sinhala' => 'সিংহলী',
	'wikieditor-toolbar-characters-page-gujarati' => 'গুজৰাটী',
	'wikieditor-toolbar-characters-page-devanagari' => 'দেবনাগৰী',
	'wikieditor-toolbar-characters-page-thai' => 'থাই',
	'wikieditor-toolbar-characters-page-lao' => 'লাও',
	'wikieditor-toolbar-characters-page-khmer' => 'খেমাৰ',
	'wikieditor-toolbar-section-help' => 'সহায়',
	'wikieditor-toolbar-help-heading-description' => 'বিৱৰণ',
	'wikieditor-toolbar-help-heading-syntax' => 'আপনি যি টাইপ কৰিছে',
	'wikieditor-toolbar-help-heading-result' => 'আপনি যি দেখা পাইছে',
	'wikieditor-toolbar-help-page-format' => 'বিন্যাসন',
	'wikieditor-toolbar-help-page-link' => 'সংযোগসমূহ',
	'wikieditor-toolbar-help-page-heading' => 'শিৰোনামসমূহ',
	'wikieditor-toolbar-help-page-list' => 'তালিকাসমূহ',
	'wikieditor-toolbar-help-page-file' => 'ফাইলসমূহ',
	'wikieditor-toolbar-help-page-reference' => 'তথ্যসংগ্ৰহ',
	'wikieditor-toolbar-help-page-discussion' => 'আলোচনা',
	'wikieditor-toolbar-help-content-italic-description' => 'হেলনীয়া',
	'wikieditor-toolbar-help-content-italic-syntax' => "''হেলনীয়া আখৰ''",
	'wikieditor-toolbar-help-content-italic-result' => '<em>হেলনীয়া আখৰ</em>',
	'wikieditor-toolbar-help-content-bold-description' => 'গাঢ়',
	'wikieditor-toolbar-help-content-bold-syntax' => "'''গাঢ় আখৰ'''",
	'wikieditor-toolbar-help-content-bold-result' => '<strong>গাঢ় আখৰ</strong>',
	'wikieditor-toolbar-help-content-bolditalic-description' => 'গাঢ় &amp; হেলনীয়া',
	'wikieditor-toolbar-help-content-bolditalic-syntax' => "'''''গাঢ় &amp; হেলনীয়া আখৰ'''''",
	'wikieditor-toolbar-help-content-bolditalic-result' => '<strong><em>গাঢ় &amp; হেলনীয়া আখৰ</em></strong>',
	'wikieditor-toolbar-help-content-ilink-description' => 'ভিতৰুৱা সংযোগ',
	'wikieditor-toolbar-help-content-ilink-syntax' => '[[পৃষ্ঠাৰ শিৰোনাম|সংযোগ লেবেল]]<br />[[পৃষ্ঠাৰ শিৰোনাম]]',
	'wikieditor-toolbar-help-content-ilink-result' => "<a href='#'>সংযোগ লেবেল</a><br /><a href='#'>পৃষ্ঠাৰ শিৰোনাম</a>",
	'wikieditor-toolbar-help-content-xlink-description' => 'বাহ্যিক সংযোগ',
	'wikieditor-toolbar-help-content-xlink-syntax' => '[http://www.example.org সংযোগ লেবেল]<br />[http://www.example.org]<br />http://www.example.org',
	'wikieditor-toolbar-help-content-xlink-result' => "<a href='#' class='external'>সংযোগ লেবেল</a><br /><a href='#' class='external autonumber'>[1]</a><br /><a href='#' class='external'>http://www.example.org</a>",
	'wikieditor-toolbar-help-content-heading2-description' => '২য় পৰ্যায়ৰ শিৰোনাম',
	'wikieditor-toolbar-help-content-heading2-syntax' => '== শিৰোনাম পাঠ্য ==',
	'wikieditor-toolbar-help-content-heading2-result' => '<h2> শিৰোনাম পাঠ্য </h2>',
	'wikieditor-toolbar-help-content-heading3-description' => '৩য় পৰ্যায়ৰ শিৰোনাম',
	'wikieditor-toolbar-help-content-heading3-syntax' => '== শিৰোনাম পাঠ্য ==',
	'wikieditor-toolbar-help-content-heading3-result' => '<h2> শিৰোনাম পাঠ্য </h2>',
	'wikieditor-toolbar-help-content-heading4-description' => '৪ৰ্থ পৰ্যায়ৰ শিৰোনাম',
	'wikieditor-toolbar-help-content-heading4-syntax' => '== শিৰোনাম পাঠ্য ==',
	'wikieditor-toolbar-help-content-heading4-result' => '<h4>শিৰোনাম পাঠ্য</h4>',
	'wikieditor-toolbar-help-content-heading5-description' => '৫ম পৰ্যায়ৰ শিৰোনাম',
	'wikieditor-toolbar-help-content-heading5-syntax' => '== শিৰোনাম পাঠ্য ==',
	'wikieditor-toolbar-help-content-heading5-result' => '<h5>শিৰোনাম পাঠ্য</h5>',
	'wikieditor-toolbar-help-content-ulist-description' => 'বুলেটকৃত তালিকা',
	'wikieditor-toolbar-help-content-ulist-syntax' => '* তালিকা আইটেম<br />* তালিকা আইটেম',
	'wikieditor-toolbar-help-content-ulist-result' => '<ul><li>তালিকা আইটেম</li><li>তালিকা আইটেম</li></ul>',
	'wikieditor-toolbar-help-content-olist-description' => 'সংখ্যায়িত তালিকা',
	'wikieditor-toolbar-help-content-olist-syntax' => '# তালিকা আইটেম <br /># তালিকা আইটেম',
	'wikieditor-toolbar-help-content-olist-result' => '<ol><li>তালিকা আইটেম</li><li>তালিকা আইটেম</li></ol>',
	'wikieditor-toolbar-help-content-file-description' => 'এম্বেডেড ফাইল',
	'wikieditor-toolbar-help-content-file-syntax' => '[[$1:Example.png|thumb|শিৰোনাম পাঠ্য]]',
	'wikieditor-toolbar-help-content-file-result' => "<div style='width:104px;' class='thumbinner'><a title=''শীৰ্ষ পাঠ্য'' class='image' href='#'><img height='50' width='100' border='0' class='thumbimage' src='$2/WikiEditor/modules/images/toolbar/example-image.png' alt=''/></a><div class='thumbcaption'><div class='magnify'><a title='ডাঙৰকৈ চাওক' class='internal' href='#'><img height='11' width='15' alt='' src='$1/common/images/magnify-clip.png'/></a></div>শীৰ্ষ পাঠ্য'</div></div>",
	'wikieditor-toolbar-help-content-reference-description' => 'তথ্যসংগ্ৰহ',
	'wikieditor-toolbar-help-content-reference-syntax' => 'Page text.&lt;ref name="test"&gt;[http://www.example.org Link text], additional text.&lt;/ref&gt;',
	'wikieditor-toolbar-help-content-reference-result' => "পৃষ্ঠাৰ পাঠ্য।<sup><a href='#'>[1]</a></sup>",
	'wikieditor-toolbar-help-content-rereference-description' => 'এটা তথ্য উত্সৰ একাধিক ব্যৱহাৰ',
	'wikieditor-toolbar-help-content-rereference-result' => "পৃষ্ঠাৰ পাঠ্য।<sup><a href='#'>[1]</a></sup>",
	'wikieditor-toolbar-help-content-showreferences-description' => 'তথ্যসংগ্ৰহ প্ৰদৰ্শন কৰক',
	'wikieditor-toolbar-help-content-showreferences-result' => "<ol class='references'><li id='cite_note-test-0'><b><a title='' href='#'>^</a></b> <a rel='nofollow' title='http://www.example.org' class='external text' href='#'>সংযোগ পাঠ্য</a>, অধিক পাঠ্য।</li></ol>",
	'wikieditor-toolbar-help-content-signaturetimestamp-description' => 'সময়ৰ সৈতে আপোনাৰ স্বাক্ষৰ',
	'wikieditor-toolbar-help-content-signaturetimestamp-result' => "<a href='#' title='{{#special:mypage}}'>ব্যৱহাৰকাৰী</a> (<a href='#' title='{{#special:mytalk}}'>আলোচনা</a>) ১৫:৫৪, ১০ জুন ২০০৯ (UTC)",
	'wikieditor-toolbar-help-content-signature-description' => 'স্বাক্ষৰ',
	'wikieditor-toolbar-help-content-signature-result' => "<a href='#' title='{{#special:mypage}}'>ব্যৱহাৰকাৰী</a> (<a href='#' title='{{#special:mytalk}}'>আলোচনা</a>)",
	'wikieditor-toolbar-help-content-indent-description' => 'ইণ্ডেণ্ট',
	'wikieditor-toolbar-help-content-indent-syntax' => 'সাধাৰন আখৰ<br />:ইন্টেন্ডেণ্ট আখৰ<br />::ইন্টেন্ডেণ্ট আখৰ',
	'wikieditor-toolbar-help-content-indent-result' => 'সাধাৰণ পাঠ্য<dl><dd>ইণ্ডেণ্ট কৰা পাঠ্য<dl><dd>ইণ্ডেণ্ট কৰা পাঠ্য</dd></dl></dd></dl>',
);

/** Asturian (asturianu)
 * @author Xuacu
 */
$messages['ast'] = array(
	'wikieditor' => "Interfaz avanzada d'edición de testu wiki",
	'wikieditor-desc' => "Ufre una interfaz estensible d'edición de testu wiki y munchos módulos de funciones",
	'wikieditor-wikitext-tab' => 'Testu wiki',
	'wikieditor-loading' => 'Cargando...',
	'wikieditor-preview-preference' => 'Activar la vista previa comparativa',
	'wikieditor-preview-tab' => 'Vista previa',
	'wikieditor-preview-changes-tab' => 'Cambios',
	'wikieditor-preview-loading' => 'Cargando...',
	'wikieditor-previewDialog-preference' => 'Activar el diálogu de vista previa',
	'wikieditor-previewDialog-tab' => 'Vista previa',
	'wikieditor-previewDialog-loading' => 'Cargando...',
	'wikieditor-publish-preference' => 'Activar la publicación pasu a pasu',
	'wikieditor-publish-button-publish' => 'Publicar',
	'wikieditor-publish-button-cancel' => 'Encaboxar',
	'wikieditor-publish-dialog-title' => 'Publicar en {{SITENAME}}',
	'wikieditor-publish-dialog-summary' => "Resume d'edición (describe de mou curtiu los cambios que ficisti):",
	'wikieditor-publish-dialog-minor' => 'Edición menor',
	'wikieditor-publish-dialog-watch' => 'Vixilar esta páxina',
	'wikieditor-publish-dialog-publish' => 'Publicar',
	'wikieditor-publish-dialog-goback' => 'Volver',
	'wikieditor-template-editor-preference' => 'Activar la edición de plantíes wiki basada en formularios',
	'wikieditor-template-editor-dialog-title' => 'Editar plantía',
	'wikieditor-template-editor-dialog-submit' => 'Anovar',
	'wikieditor-template-editor-dialog-cancel' => 'Encaboxar',
	'wikieditor-templates-preference' => 'Activar el plegáu de plantíes',
	'wikieditor-toc-preference' => 'Activar la tabla de conteníu navegable',
	'wikieditor-toc-show' => 'Amosar el conteníu',
	'wikieditor-toc-hide' => 'Anubrir el conteníu',
	'wikieditor-toolbar' => 'Editando la barra de ferramientes',
	'wikieditor-toolbar-desc' => "Barra de ferramientes de la páxina d'edición con usabilidá enantada",
	'wikieditor-toolbar-preference' => "Activar a barra d'edición enantada",
	'wikieditor-toolbar-dialogs-preference' => "Activar los diálogos p'amestar enllaces, tables y más",
	'wikieditor-toolbar-hidesig' => 'Anubrir el botón de robla nes páxines del espaciu de nomes principal',
	'wikieditor-toolbar-loading' => 'Cargando...',
	'wikieditor-toolbar-tool-bold' => 'Negrina',
	'wikieditor-toolbar-tool-bold-example' => 'Testu en negrina',
	'wikieditor-toolbar-tool-italic' => 'Cursiva',
	'wikieditor-toolbar-tool-italic-example' => 'Testu en cursiva',
	'wikieditor-toolbar-tool-ilink' => 'Enllaz internu',
	'wikieditor-toolbar-tool-ilink-example' => 'Títulu del enllaz',
	'wikieditor-toolbar-tool-xlink' => "Enllaz esternu (recuerda'l prefixu http://)",
	'wikieditor-toolbar-tool-xlink-example' => 'http://www.example.com títulu del enllaz',
	'wikieditor-toolbar-tool-link' => 'Enllaz',
	'wikieditor-toolbar-tool-link-title' => 'Inxertar enllaz',
	'wikieditor-toolbar-tool-link-int' => 'A una páxina del wiki',
	'wikieditor-toolbar-tool-link-int-target' => 'Páxina destín o URL:',
	'wikieditor-toolbar-tool-link-int-target-tooltip' => 'Títulu de la páxina o URL',
	'wikieditor-toolbar-tool-link-int-text' => 'Testu a amosar:',
	'wikieditor-toolbar-tool-link-int-text-tooltip' => "El testu que s'amosará",
	'wikieditor-toolbar-tool-link-ext' => 'A una páxina web esterna',
	'wikieditor-toolbar-tool-link-ext-target' => 'URL del enllaz:',
	'wikieditor-toolbar-tool-link-ext-text' => 'Testu del enllaz:',
	'wikieditor-toolbar-tool-link-insert' => 'Inxertar enllaz',
	'wikieditor-toolbar-tool-link-cancel' => 'Encaboxar',
	'wikieditor-toolbar-tool-link-int-target-status-exists' => 'La páxina yá esiste',
	'wikieditor-toolbar-tool-link-int-target-status-notexists' => 'La páxina nun esiste',
	'wikieditor-toolbar-tool-link-int-target-status-invalid' => 'Títulu inválidu',
	'wikieditor-toolbar-tool-link-int-target-status-external' => 'Enllaz esternu',
	'wikieditor-toolbar-tool-link-int-target-status-loading' => 'Comprobando la esistencia de la páxina...',
	'wikieditor-toolbar-tool-link-int-invalid' => 'El títulu que conseñasti nun ye válidu.',
	'wikieditor-toolbar-tool-link-lookslikeinternal' => 'La URL que conseñasti paez que quería ser un enllaz a otra páxina de la wiki.
¿Quies convertila nún enllaz internu?',
	'wikieditor-toolbar-tool-link-lookslikeinternal-int' => 'Enllaz internu',
	'wikieditor-toolbar-tool-link-lookslikeinternal-ext' => 'Enllaz esternu',
	'wikieditor-toolbar-tool-link-empty' => 'Nun escribisti nada pa enllazar.',
	'wikieditor-toolbar-tool-file' => 'Ficheru incrustáu',
	'wikieditor-toolbar-tool-file-example' => 'Exemplu.jpg',
	'wikieditor-toolbar-tool-file-title' => 'Inxertar un ficheru',
	'wikieditor-toolbar-file-target' => 'Nome del ficheru:',
	'wikieditor-toolbar-file-caption' => 'Lleenda:',
	'wikieditor-toolbar-file-size' => 'Tamañu:',
	'wikieditor-toolbar-file-float' => 'Alliniamientu:',
	'wikieditor-toolbar-file-default' => '(predetermináu)',
	'wikieditor-toolbar-file-format' => 'Formatu:',
	'wikieditor-toolbar-tool-file-insert' => 'Inxertar',
	'wikieditor-toolbar-tool-file-cancel' => 'Encaboxar',
	'wikieditor-toolbar-tool-reference' => 'Referencia',
	'wikieditor-toolbar-tool-reference-example' => 'Escribir equí el testu de la nota al pie',
	'wikieditor-toolbar-tool-reference-cancel' => 'Encaboxar',
	'wikieditor-toolbar-tool-reference-title' => 'Inxertar referencia',
	'wikieditor-toolbar-tool-reference-insert' => 'Inxertar',
	'wikieditor-toolbar-tool-reference-text' => 'Testu de la referencia',
	'wikieditor-toolbar-tool-signature' => 'Robla, data y hora',
	'wikieditor-toolbar-section-advanced' => 'Avanzao',
	'wikieditor-toolbar-tool-heading' => 'Cabecera',
	'wikieditor-toolbar-tool-heading-1' => 'Nivel 1',
	'wikieditor-toolbar-tool-heading-2' => 'Nivel 2',
	'wikieditor-toolbar-tool-heading-3' => 'Nivel 3',
	'wikieditor-toolbar-tool-heading-4' => 'Nivel 4',
	'wikieditor-toolbar-tool-heading-5' => 'Nivel 5',
	'wikieditor-toolbar-tool-heading-example' => 'Testu de cabecera',
	'wikieditor-toolbar-group-format' => 'Formatu',
	'wikieditor-toolbar-tool-ulist' => 'Llista con puntos',
	'wikieditor-toolbar-tool-ulist-example' => 'Elementu de la llista con puntos',
	'wikieditor-toolbar-tool-olist' => 'Llista numberada',
	'wikieditor-toolbar-tool-olist-example' => 'Elementu de la llista numberada',
	'wikieditor-toolbar-tool-indent' => 'Sangría',
	'wikieditor-toolbar-tool-indent-example' => 'Llinia con sangría',
	'wikieditor-toolbar-tool-nowiki' => 'Ensin formatu wiki',
	'wikieditor-toolbar-tool-nowiki-example' => 'Pon equí testu ensin formatu',
	'wikieditor-toolbar-tool-redirect' => 'Redireición',
	'wikieditor-toolbar-tool-redirect-example' => 'Nome de la páxina de destín',
	'wikieditor-toolbar-tool-big' => 'Grande',
	'wikieditor-toolbar-tool-big-example' => 'Testu grande',
	'wikieditor-toolbar-tool-small' => 'Pequeñu',
	'wikieditor-toolbar-tool-small-example' => 'Testu pequeñu',
	'wikieditor-toolbar-tool-superscript' => 'Superíndiz',
	'wikieditor-toolbar-tool-superscript-example' => 'Testu en superíndiz',
	'wikieditor-toolbar-tool-subscript' => 'Subíndiz',
	'wikieditor-toolbar-tool-subscript-example' => 'Testu en subíndiz',
	'wikieditor-toolbar-group-insert' => 'Inxertar',
	'wikieditor-toolbar-tool-gallery' => "Galería d'imaxes",
	'wikieditor-toolbar-tool-gallery-example' => '$1:Exemplu.jpg|Pie1
$1:Exemplu.jpg|Pie2',
	'wikieditor-toolbar-tool-newline' => 'Nueva llinia',
	'wikieditor-toolbar-tool-table' => 'Tabla',
	'wikieditor-toolbar-tool-table-example-old' => '-
! testera 1
! testera 2
! testera 3
|-
| filera 1, caxella 1
| filera 1, caxella 2
| filera 1, caxella 3
|-
| filera 2, caxella 1
| filera 2, caxella 2
| filera 2, caxella 3',
	'wikieditor-toolbar-tool-table-example-cell-text' => 'Testu de la caxella',
	'wikieditor-toolbar-tool-table-example-header' => 'Testu de cabecera',
	'wikieditor-toolbar-tool-table-title' => 'Inxertar una tabla',
	'wikieditor-toolbar-tool-table-dimensions-rows' => 'Fileres',
	'wikieditor-toolbar-tool-table-dimensions-columns' => 'Columnes',
	'wikieditor-toolbar-tool-table-dimensions-header' => 'Incluir llinia de cabecera',
	'wikieditor-toolbar-tool-table-wikitable' => 'Estilu con bordes',
	'wikieditor-toolbar-tool-table-sortable' => 'Facer que la tabla pueda ordenase',
	'wikieditor-toolbar-tool-table-example' => 'Exemplu',
	'wikieditor-toolbar-tool-table-preview' => 'Vista previa',
	'wikieditor-toolbar-tool-table-insert' => 'Inxertar',
	'wikieditor-toolbar-tool-table-cancel' => 'Encaboxar',
	'wikieditor-toolbar-tool-table-toomany' => 'Con esti diálogu nun ye posible inxertar una tabla de más de $1 caxelles.',
	'wikieditor-toolbar-tool-table-invalidnumber' => 'Nun escribisti un númberu válidu de fileres o columnes.',
	'wikieditor-toolbar-tool-table-zero' => 'Nun pues inxertar una tabla con cero fileres o columnes.',
	'wikieditor-toolbar-tool-replace' => 'Guetar y reemplazar',
	'wikieditor-toolbar-tool-replace-title' => 'Guetar y reemplazar',
	'wikieditor-toolbar-tool-replace-search' => 'Buscar:',
	'wikieditor-toolbar-tool-replace-replace' => 'Sustituir por:',
	'wikieditor-toolbar-tool-replace-case' => 'Distinguir mayúscules',
	'wikieditor-toolbar-tool-replace-regex' => 'Tratar la cadena de gueta como una espresión regular',
	'wikieditor-toolbar-tool-replace-button-findnext' => 'Alcontrar siguiente',
	'wikieditor-toolbar-tool-replace-button-replace' => 'Sustituir',
	'wikieditor-toolbar-tool-replace-button-replaceall' => 'Sustituir toos',
	'wikieditor-toolbar-tool-replace-close' => 'Zarrar',
	'wikieditor-toolbar-tool-replace-nomatch' => 'La to gueta nun alcontró coincidencies.',
	'wikieditor-toolbar-tool-replace-success' => '$1 reemplazos fechos',
	'wikieditor-toolbar-tool-replace-emptysearch' => 'Nun escribisti nada pa guetar.',
	'wikieditor-toolbar-tool-replace-invalidregex' => "La espresión regular qu'escribisti ye inválida: $1",
	'wikieditor-toolbar-section-characters' => 'Caráuteres especiales',
	'wikieditor-toolbar-characters-page-latin' => 'Llatín',
	'wikieditor-toolbar-characters-page-latinextended' => 'Llatín estendíu',
	'wikieditor-toolbar-characters-page-ipa' => 'AFI',
	'wikieditor-toolbar-characters-page-symbols' => 'Símbolos',
	'wikieditor-toolbar-characters-page-greek' => 'Griegu',
	'wikieditor-toolbar-characters-page-cyrillic' => 'Cirílicu',
	'wikieditor-toolbar-characters-page-arabic' => 'Árabe',
	'wikieditor-toolbar-characters-page-arabicextended' => 'Árabe estendíu',
	'wikieditor-toolbar-characters-page-persian' => 'Persa',
	'wikieditor-toolbar-characters-page-hebrew' => 'Hebréu',
	'wikieditor-toolbar-characters-page-bangla' => 'Bengalín',
	'wikieditor-toolbar-characters-page-tamil' => 'Tamil',
	'wikieditor-toolbar-characters-page-telugu' => 'Telugu',
	'wikieditor-toolbar-characters-page-sinhala' => 'Cingalés',
	'wikieditor-toolbar-characters-page-gujarati' => 'Gujarati',
	'wikieditor-toolbar-characters-page-devanagari' => 'Devanagari',
	'wikieditor-toolbar-characters-page-thai' => 'Tailandés',
	'wikieditor-toolbar-characters-page-lao' => 'Laosianu',
	'wikieditor-toolbar-characters-page-khmer' => 'Khmer',
	'wikieditor-toolbar-section-help' => 'Ayuda',
	'wikieditor-toolbar-help-heading-description' => 'Descripción',
	'wikieditor-toolbar-help-heading-syntax' => "Lo qu'escribes",
	'wikieditor-toolbar-help-heading-result' => 'Lo que te sal',
	'wikieditor-toolbar-help-page-format' => 'Dar formatu',
	'wikieditor-toolbar-help-page-link' => 'Enllaces',
	'wikieditor-toolbar-help-page-heading' => 'Cabeceres',
	'wikieditor-toolbar-help-page-list' => 'Llistes',
	'wikieditor-toolbar-help-page-file' => 'Ficheros',
	'wikieditor-toolbar-help-page-reference' => 'Referencies',
	'wikieditor-toolbar-help-page-discussion' => 'Alderique',
	'wikieditor-toolbar-help-content-italic-description' => 'Cursiva',
	'wikieditor-toolbar-help-content-italic-syntax' => "''Testu en cursiva''",
	'wikieditor-toolbar-help-content-italic-result' => '<em>Testu en cursiva</em>',
	'wikieditor-toolbar-help-content-bold-description' => 'Negrina',
	'wikieditor-toolbar-help-content-bold-syntax' => "'''Testu en negrina'''",
	'wikieditor-toolbar-help-content-bold-result' => '<strong>Testu en negrina</strong>',
	'wikieditor-toolbar-help-content-bolditalic-description' => 'Negrina &amp; cursiva',
	'wikieditor-toolbar-help-content-bolditalic-syntax' => "'''''Testu en negrina y cursiva'''''",
	'wikieditor-toolbar-help-content-bolditalic-result' => '<strong><em>Testu en negrina &amp; cursiva</em></strong>',
	'wikieditor-toolbar-help-content-ilink-description' => 'Enllaz internu',
	'wikieditor-toolbar-help-content-ilink-syntax' => '[[Títulu de la páxina|Etiqueta del enllaz]]<br />[[Títulu de la páxina]]',
	'wikieditor-toolbar-help-content-ilink-result' => "<a href='#'>Etiqueta del enllaz</a><br /><a href='#'>Títulu de la páxina</a>",
	'wikieditor-toolbar-help-content-xlink-description' => 'Enllaz esternu',
	'wikieditor-toolbar-help-content-xlink-syntax' => '[http://www.example.org Etiqueta del enllaz]<br />[http://www.example.org]<br />http://www.example.org',
	'wikieditor-toolbar-help-content-xlink-result' => "<a href='#' class='external'>Etiqueta del enllaz</a><br /><a href='#' class='external autonumber'>[1]</a><br /><a href='#' class='external'>http://www.example.org</a>",
	'wikieditor-toolbar-help-content-heading2-description' => 'Cabecera de 2ᵘ nivel',
	'wikieditor-toolbar-help-content-heading2-syntax' => '== Testu de la cabecera ==',
	'wikieditor-toolbar-help-content-heading2-result' => '<h2>Testu de la cabecera</h2>',
	'wikieditor-toolbar-help-content-heading3-description' => 'Cabecera de 3ᵉʳ nivel',
	'wikieditor-toolbar-help-content-heading3-syntax' => '=== Testu de la cabecera ===',
	'wikieditor-toolbar-help-content-heading3-result' => '<h3>Testu de la cabecera</h3>',
	'wikieditor-toolbar-help-content-heading4-description' => 'Cabecera de 4ᵘ nivel',
	'wikieditor-toolbar-help-content-heading4-syntax' => '==== Testu de la cabecera ====',
	'wikieditor-toolbar-help-content-heading4-result' => '<h4>Testu de la cabecera</h4>',
	'wikieditor-toolbar-help-content-heading5-description' => 'Cabecera de 5ᵘ nivel',
	'wikieditor-toolbar-help-content-heading5-syntax' => '===== Testu de la cabecera =====',
	'wikieditor-toolbar-help-content-heading5-result' => '<h5>Testu de la cabecera</h5>',
	'wikieditor-toolbar-help-content-ulist-description' => 'Llista con puntos',
	'wikieditor-toolbar-help-content-ulist-syntax' => '* Elementu de la llista<br />* Elementu de la llista',
	'wikieditor-toolbar-help-content-ulist-result' => '<ul><li>Elementu de la llista</li><li>Elementu de la llista</li></ul>',
	'wikieditor-toolbar-help-content-olist-description' => 'Llista numberada',
	'wikieditor-toolbar-help-content-olist-syntax' => '# Elementu de la llista<br /># Elementu de la llista',
	'wikieditor-toolbar-help-content-olist-result' => '<ol><li>Elementu de la llista</li><li>Elementu de la llista</li></ol>',
	'wikieditor-toolbar-help-content-file-description' => 'Ficheru incrustáu',
	'wikieditor-toolbar-help-content-file-syntax' => '[[$1:Exemplu.png|thumb|Testu del pie]]',
	'wikieditor-toolbar-help-content-file-result' => "<div style='width:104px;' class='thumbinner'><a title='Testu del pie' class='image' href='#'><img height='50' width='100' border='0' class='thumbimage' src='$2/WikiEditor/modules/images/toolbar/example-image.png' alt=''/></a><div class='thumbcaption'><div class='magnify'><a title='Ampliar' class='internal' href='#'><img height='11' width='15' alt='' src='$1/common/images/magnify-clip.png'/></a></div>Testu del pie</div></div>",
	'wikieditor-toolbar-help-content-reference-description' => 'Referencia',
	'wikieditor-toolbar-help-content-reference-syntax' => 'Testu de la páxina&lt;ref name="test"&gt;[http://www.example.org Testu del enllaz], otru testu.&lt;/ref&gt;.',
	'wikieditor-toolbar-help-content-reference-result' => "Testu de la páxina.<sup><a href='#'>[1]</a></sup>",
	'wikieditor-toolbar-help-content-rereference-description' => 'Otros usos de la mesma referencia',
	'wikieditor-toolbar-help-content-rereference-result' => "Testu de la páxina.<sup><a href='#'>[1]</a></sup>",
	'wikieditor-toolbar-help-content-showreferences-description' => 'Amosar les referencies',
	'wikieditor-toolbar-help-content-showreferences-result' => "<ol class='references'><li id='cite_note-test-0'><b><a title='' href='#'>^</a></b> <a rel='nofollow' title='http://www.example.org' class='external text' href='#'>Testu del enllaz</a>, otru testu.</li></ol>",
	'wikieditor-toolbar-help-content-signaturetimestamp-description' => 'Robla con data y hora',
	'wikieditor-toolbar-help-content-signaturetimestamp-result' => "<a href='#' title='{{#special:mypage}}'>Nome d'usuariu</a> (<a href='#' title='{{#special:mytalk}}'>alderique</a>) 15:54, 10 xunu 2009 (UTC)",
	'wikieditor-toolbar-help-content-signature-description' => 'Robla',
	'wikieditor-toolbar-help-content-signature-result' => "<a href='#' title='{{#special:mypage}}'>Nome d'usuariu</a> (<a href='#' title='{{#special:mytalk}}'>alderique</a>)",
	'wikieditor-toolbar-help-content-indent-description' => 'Sangría',
	'wikieditor-toolbar-help-content-indent-syntax' => 'Testu normal<br />:Testu con sangría<br />::Testu con sangría',
	'wikieditor-toolbar-help-content-indent-result' => 'Testu normal<dl><dd>Testu con sangría<dl><dd>Testu con sangría</dd></dl></dd></dl>',
);

/** Azerbaijani (azərbaycanca)
 * @author Cekli829
 * @author Koc61
 * @author PPerviz
 * @author Vago
 * @author Vugar 1981
 */
$messages['az'] = array(
	'wikieditor-wikitext-tab' => 'Vikimətn',
	'wikieditor-loading' => 'Yüklə',
	'wikieditor-preview-tab' => 'Sınaq göstərişi',
	'wikieditor-preview-changes-tab' => 'Dəyişikliklər',
	'wikieditor-preview-loading' => 'Yüklənir…',
	'wikieditor-previewDialog-tab' => 'Sınaq göstərişi',
	'wikieditor-previewDialog-loading' => 'Yüklənir…',
	'wikieditor-publish-button-publish' => 'Yeniləmə',
	'wikieditor-publish-button-cancel' => 'Ləğv et',
	'wikieditor-publish-dialog-minor' => 'Kiçik dəyişiklik',
	'wikieditor-publish-dialog-watch' => 'Bu səhifəni izlə',
	'wikieditor-publish-dialog-publish' => 'Publish',
	'wikieditor-publish-dialog-goback' => 'Geriyə',
	'wikieditor-template-editor-dialog-title' => 'Şablonu redaktə et',
	'wikieditor-template-editor-dialog-submit' => 'Yenilə',
	'wikieditor-template-editor-dialog-cancel' => 'Ləğv et',
	'wikieditor-toc-show' => 'Möhtəviyyata bax',
	'wikieditor-toc-hide' => 'Möhtəviyyatı gizlət',
	'wikieditor-toolbar-loading' => 'Yüklənir…',
	'wikieditor-toolbar-tool-bold' => 'Qalın',
	'wikieditor-toolbar-tool-bold-example' => 'Qalın mətn',
	'wikieditor-toolbar-tool-italic' => 'Kursiv',
	'wikieditor-toolbar-tool-italic-example' => 'Kursiv mətn',
	'wikieditor-toolbar-tool-ilink' => 'Daxili keçid',
	'wikieditor-toolbar-tool-ilink-example' => 'Keçidin başlığı',
	'wikieditor-toolbar-tool-xlink-example' => 'http://www.example.com başlıq',
	'wikieditor-toolbar-tool-link' => 'Keçid',
	'wikieditor-toolbar-tool-link-title' => 'Keçid yerləşdir',
	'wikieditor-toolbar-tool-link-int-target-tooltip' => 'URL üçün səhifə başlığı',
	'wikieditor-toolbar-tool-link-ext-target' => 'URL linki:',
	'wikieditor-toolbar-tool-link-cancel' => 'Ləğv et',
	'wikieditor-toolbar-tool-link-int-target-status-notexists' => 'Səhifə mövcud deyil',
	'wikieditor-toolbar-tool-link-int-target-status-invalid' => 'Yanlış başlıq',
	'wikieditor-toolbar-tool-link-lookslikeinternal-int' => 'Daxili keçid',
	'wikieditor-toolbar-tool-link-lookslikeinternal-ext' => 'Xarici keçid',
	'wikieditor-toolbar-tool-file' => 'Şəkil əlavə etmə',
	'wikieditor-toolbar-tool-file-example' => 'Misal.jpg',
	'wikieditor-toolbar-tool-reference' => 'İstinad',
	'wikieditor-toolbar-tool-reference-cancel' => 'Ləğv et',
	'wikieditor-toolbar-tool-reference-insert' => 'Yerləşdirmək',
	'wikieditor-toolbar-tool-reference-text' => 'İstinad mətn',
	'wikieditor-toolbar-tool-signature' => 'İmza və vaxt qeydi',
	'wikieditor-toolbar-section-advanced' => 'Ətraflı',
	'wikieditor-toolbar-tool-heading' => 'Başlıq',
	'wikieditor-toolbar-tool-heading-1' => 'Səviyyə 1',
	'wikieditor-toolbar-tool-heading-2' => 'Səviyyə 2',
	'wikieditor-toolbar-tool-heading-3' => 'Səviyyə 3',
	'wikieditor-toolbar-tool-heading-4' => 'Səviyyə 4',
	'wikieditor-toolbar-tool-heading-5' => 'Səviyyə 5',
	'wikieditor-toolbar-tool-heading-example' => 'Başlıq mətni',
	'wikieditor-toolbar-group-format' => 'Format',
	'wikieditor-toolbar-tool-redirect' => 'Yönləndirmə',
	'wikieditor-toolbar-tool-redirect-example' => 'Səhifə adını əlavə et',
	'wikieditor-toolbar-tool-big' => 'Böyük',
	'wikieditor-toolbar-tool-big-example' => 'Böyük mətn',
	'wikieditor-toolbar-tool-small' => 'Kiçik',
	'wikieditor-toolbar-tool-small-example' => 'Kiçik mətn',
	'wikieditor-toolbar-tool-subscript' => 'Subscript',
	'wikieditor-toolbar-group-insert' => 'Yerləşdirmək',
	'wikieditor-toolbar-tool-gallery' => 'Şəkil qalereyası',
	'wikieditor-toolbar-tool-newline' => 'Yeni xətt',
	'wikieditor-toolbar-tool-table' => 'Cədvəl',
	'wikieditor-toolbar-tool-table-example-old' => '-
! başlıq 1
! başlıq 2
! başlıq 3
|-
| sıra 1, sütun 1
| sıra 1, sütun 2
| sıra 1, sütun 3
|-
| sıra 2, sütun 1
| sıra 2, sütun 2
| sıra 2, sütun 3',
	'wikieditor-toolbar-tool-table-example-header' => 'Başlıq mətni',
	'wikieditor-toolbar-tool-table-title' => 'Cədvəl yerləşdir',
	'wikieditor-toolbar-tool-table-dimensions-rows' => 'Sətirlər:',
	'wikieditor-toolbar-tool-table-dimensions-columns' => 'Sütunlar:',
	'wikieditor-toolbar-tool-table-example' => 'Nümunə',
	'wikieditor-toolbar-tool-table-preview' => 'Sınaq göstərişi',
	'wikieditor-toolbar-tool-table-insert' => 'Yerləşdirmək',
	'wikieditor-toolbar-tool-table-cancel' => 'Ləğv et',
	'wikieditor-toolbar-tool-replace' => 'Axtar və dəyiş',
	'wikieditor-toolbar-tool-replace-title' => 'Axtar və dəyiş',
	'wikieditor-toolbar-tool-replace-search' => 'Axtar:',
	'wikieditor-toolbar-tool-replace-replace' => 'Bununla dəyiş:',
	'wikieditor-toolbar-tool-replace-button-findnext' => 'Növbətini axtar',
	'wikieditor-toolbar-tool-replace-button-replaceall' => 'Hamısını dəyiş',
	'wikieditor-toolbar-tool-replace-close' => 'Bağla',
	'wikieditor-toolbar-section-characters' => 'Xüsusi işarələr',
	'wikieditor-toolbar-characters-page-latin' => 'Latın',
	'wikieditor-toolbar-characters-page-latinextended' => 'Latın genişləndirilmiş',
	'wikieditor-toolbar-characters-page-ipa' => 'IPA',
	'wikieditor-toolbar-characters-page-symbols' => 'Simvollar',
	'wikieditor-toolbar-characters-page-greek' => 'Yunan',
	'wikieditor-toolbar-characters-page-cyrillic' => 'Kiril',
	'wikieditor-toolbar-characters-page-arabic' => 'Ərəb',
	'wikieditor-toolbar-characters-page-persian' => 'Fars',
	'wikieditor-toolbar-characters-page-hebrew' => 'İvrit',
	'wikieditor-toolbar-characters-page-bangla' => 'Benqal',
	'wikieditor-toolbar-characters-page-telugu' => 'Teluqu',
	'wikieditor-toolbar-characters-page-sinhala' => 'Sinqal',
	'wikieditor-toolbar-characters-page-gujarati' => 'Qucarat',
	'wikieditor-toolbar-characters-page-thai' => 'Tay',
	'wikieditor-toolbar-characters-page-lao' => 'Lao',
	'wikieditor-toolbar-characters-page-khmer' => 'Khmer',
	'wikieditor-toolbar-section-help' => 'Kömək',
	'wikieditor-toolbar-help-heading-description' => 'Təsvir',
	'wikieditor-toolbar-help-heading-syntax' => 'Yazdığınız',
	'wikieditor-toolbar-help-heading-result' => 'Aldığınız',
	'wikieditor-toolbar-help-page-format' => 'Formatlaşdırmaq',
	'wikieditor-toolbar-help-page-link' => 'Keçidlər',
	'wikieditor-toolbar-help-page-heading' => 'Başlıqlar',
	'wikieditor-toolbar-help-page-list' => 'Siyahılar',
	'wikieditor-toolbar-help-page-file' => 'Fayllar',
	'wikieditor-toolbar-help-page-reference' => 'İstinadlar',
	'wikieditor-toolbar-help-page-discussion' => 'Müzakirə',
	'wikieditor-toolbar-help-content-italic-description' => 'Kursiv',
	'wikieditor-toolbar-help-content-italic-syntax' => "''Kursiv mətn''",
	'wikieditor-toolbar-help-content-italic-result' => '<em>Kursiv mətn</em>',
	'wikieditor-toolbar-help-content-bold-description' => 'Qalın',
	'wikieditor-toolbar-help-content-bold-syntax' => "'''Qalın mətn'''",
	'wikieditor-toolbar-help-content-bold-result' => '<strong>Qalın mətn</strong>',
	'wikieditor-toolbar-help-content-bolditalic-description' => 'Qalın və kursiv',
	'wikieditor-toolbar-help-content-bolditalic-syntax' => "'''''Qalın və kursiv mətn'''''",
	'wikieditor-toolbar-help-content-bolditalic-result' => '<strong><em>Qalın və kursiv mətn</em></strong>',
	'wikieditor-toolbar-help-content-ilink-description' => 'Daxili keçid',
	'wikieditor-toolbar-help-content-ilink-syntax' => '[[Səhifənin adı|Keçidin adı]]<br />[[Səhifənin adı]]',
	'wikieditor-toolbar-help-content-ilink-result' => "<a href='#'>Keçidin adı</a><br /><a href='#'>Səhifənin adı</a>",
	'wikieditor-toolbar-help-content-xlink-description' => 'Xarici keçid',
	'wikieditor-toolbar-help-content-xlink-syntax' => '[http://www.example.org Keçidin adı]<br />[http://www.example.org]<br />http://www.example.org',
	'wikieditor-toolbar-help-content-xlink-result' => "<a href='#' class='external'>Keçidin adı</a><br /><a href='#' class='external autonumber'>[1]</a><br /><a href='#' class='external'>http://www.example.org</a>",
	'wikieditor-toolbar-help-content-heading2-description' => '2-ci səviyyəlı başlıq',
	'wikieditor-toolbar-help-content-heading2-syntax' => '== Başlıq mətn ==',
	'wikieditor-toolbar-help-content-heading2-result' => '<h2>Başlıq mətn</h2>',
	'wikieditor-toolbar-help-content-heading3-description' => '3-cü səviyyəli başlıq',
	'wikieditor-toolbar-help-content-heading3-syntax' => '=== Başlıq mətn ===',
	'wikieditor-toolbar-help-content-heading3-result' => '<h3>Başlıq mətn</h3>',
	'wikieditor-toolbar-help-content-heading4-description' => '4-cü səviyyəli başlıq',
	'wikieditor-toolbar-help-content-heading4-syntax' => '==== Başlıq mətn ====',
	'wikieditor-toolbar-help-content-heading4-result' => '<h4>Başlıq mətn</h4>',
	'wikieditor-toolbar-help-content-heading5-description' => '5-ci səviyyəlı başlıq',
	'wikieditor-toolbar-help-content-heading5-syntax' => '===== Başlıq mətn =====',
	'wikieditor-toolbar-help-content-heading5-result' => '<h5>Başlıq mətn</h5>',
	'wikieditor-toolbar-help-content-ulist-description' => 'Markalanmış siyahı',
	'wikieditor-toolbar-help-content-ulist-syntax' => '* Siyahı bəndi<br />* Siyahı bəndi',
	'wikieditor-toolbar-help-content-ulist-result' => '<ul><li>Siyahı bəndi</li><li>Siyahı bəndi</li></ul>',
	'wikieditor-toolbar-help-content-olist-description' => 'Nömrələnən siyahı',
	'wikieditor-toolbar-help-content-olist-syntax' => '# Siyahı bəndi<br /># Siyahı bəndi',
	'wikieditor-toolbar-help-content-olist-result' => '<ol><li>Siyahı bəndi</li><li>Siyahı bəndi</li></ol>',
	'wikieditor-toolbar-help-content-file-description' => 'Şəkil əlavə etmə',
	'wikieditor-toolbar-help-content-file-syntax' => '[[$1:Example.png|thumb|Mövzu mətni]]',
	'wikieditor-toolbar-help-content-file-result' => "<div style='width:104px;' class='thumbinner'><a title='Mövzu mətni' class='image' href='#'><img height='50' width='100' border='0' class='thumbimage' src='$2/WikiEditor/modules/images/toolbar/example-image.png' alt=''/></a><div class='thumbcaption'><div class='magnify'><a title='Böyüt' class='internal' href='#'><img height='11' width='15' alt='' src='$1/common/images/magnify-clip.png'/></a></div>Mövzu mətni</div></div>",
	'wikieditor-toolbar-help-content-reference-description' => 'İstinad',
	'wikieditor-toolbar-help-content-reference-syntax' => 'Səhifənin mətni.&lt;ref name="test"&gt;[http://www.example.org Keçidin mətni], əlavə mətnt.&lt;/ref&gt;',
	'wikieditor-toolbar-help-content-reference-result' => "Səhifənin mətni.<sup><a href='#'>[1]</a></sup>",
	'wikieditor-toolbar-help-content-rereference-description' => 'Eyni istinaddan istifadənin əlavəsi',
	'wikieditor-toolbar-help-content-rereference-result' => "Səhifə mətni.<sup><a href='#'>[1]</a></sup>",
	'wikieditor-toolbar-help-content-showreferences-description' => 'İstinadları göstər',
	'wikieditor-toolbar-help-content-showreferences-result' => "<ol class='references'><li id='cite_note-test-0'><b><a title='' href='#'>^</a></b> <a rel='nofollow' title='http://www.example.org' class='external text' href='#'>Keçid mətni</a>, əlavə mətn.</li></ol>",
	'wikieditor-toolbar-help-content-signaturetimestamp-description' => 'Vaxt qeydi ilə imza',
	'wikieditor-toolbar-help-content-signaturetimestamp-result' => "<a href='#' title='{{#special:mypage}}'>İstifadəçi adı</a> (<a href='#' title='{{#special:mytalk}}'>müzakirə</a>) 15:54, 10 iyun 2009 (UTC)",
	'wikieditor-toolbar-help-content-signature-description' => 'İmza',
	'wikieditor-toolbar-help-content-signature-result' => "<a href='#' title='{{#special:mypage}}'>İstifadəçi adı</a> (<a href='#' title='{{#special:mytalk}}'>müzakirə</a>)",
	'wikieditor-toolbar-help-content-indent-description' => 'Abzas',
	'wikieditor-toolbar-help-content-indent-syntax' => 'Normal mətn<br />:Abzasla mətn<br />::Abzasla mətn',
	'wikieditor-toolbar-help-content-indent-result' => 'Normal mətn<dl><dd>Abzasla mətn<dl><dd>Abzasla mətn</dd></dl></dd></dl>',
);

/** Bashkir (башҡортса)
 * @author Assele
 * @author Haqmar
 */
$messages['ba'] = array(
	'wikieditor' => 'Киңәйтелгән викитекст мөхәррирләү интерфейсы',
	'wikieditor-desc' => 'Киңәйтелгән викитекст мөхәррирләү интерфейсы менән һәм модулдәр тарафынан күп мөмкинлектәр менән тәьмин итә',
	'wikieditor-wikitext-tab' => 'Викитекст',
	'wikieditor-loading' => 'Сығарыу',
	'wikieditor-preview-preference' => 'Йәнәш ҡарап сығыуҙы тоҡандырырға',
	'wikieditor-preview-tab' => 'Ҡарап сығыу',
	'wikieditor-preview-changes-tab' => 'Үҙгәрештәр',
	'wikieditor-preview-loading' => 'Сығарыу...',
	'wikieditor-previewDialog-preference' => 'Ҡарап сығыу диалогын тоҡандырырға',
	'wikieditor-previewDialog-tab' => 'Ҡарап сығыу',
	'wikieditor-previewDialog-loading' => 'Сығарыу...',
	'wikieditor-publish-preference' => 'Аҙымлап баҫтырыуҙы тоҡандырырға',
	'wikieditor-publish-button-publish' => 'Баҫтырып сығарырға',
	'wikieditor-publish-button-cancel' => 'Кире алырға',
	'wikieditor-publish-dialog-title' => ' {{SITENAME}} проектына баҫтырып сығарырға',
	'wikieditor-publish-dialog-summary' => 'Үҙгәртеүҙәр тасуирламаһы (ниндәй үҙгәртеүҙәр кереткәнегеҙҙе ҡыҫҡаса тасуирлағыҙ):',
	'wikieditor-publish-dialog-minor' => 'Әҙ генә үҙгәрештәр',
	'wikieditor-publish-dialog-watch' => 'Был битте күҙәтергә',
	'wikieditor-publish-dialog-publish' => 'Баҫтырып сығарырға',
	'wikieditor-publish-dialog-goback' => 'Кире ҡайтырға',
	'wikieditor-template-editor-preference' => 'Ҡалыптарҙы формалар ярҙамында үҙгәртеүҙе тоҡандырырға',
	'wikieditor-template-editor-dialog-title' => 'Ҡалыпты үҙгәртеү',
	'wikieditor-template-editor-dialog-submit' => 'Яңыртырға',
	'wikieditor-template-editor-dialog-cancel' => 'Кире алырға',
	'wikieditor-templates-preference' => 'Ҡалыптарҙы йыйыу мөмкинлеген тоҡандырырға',
	'wikieditor-toc-preference' => 'Йөкмәтке буйлап күсеү һылтанмаларын күрһәтергә',
	'wikieditor-toc-show' => 'Йөкмәткене күрһәтергә',
	'wikieditor-toc-hide' => 'Йөкмәткене йәшерергә',
	'wikieditor-toolbar' => 'Мөхәррирләү ҡоралдары',
	'wikieditor-toolbar-desc' => 'Яҡшыртылған мөхәррирләү ҡоралдары',
	'wikieditor-toolbar-preference' => 'Яҡшыртылған мөхәррирләү ҡоралдарын ҡулланырға',
	'wikieditor-toolbar-dialogs-preference' => 'Һылтанмалар, таблицалар һәм башҡаларҙы өҫтәү өсөн диалогтар ҡулланырға',
	'wikieditor-toolbar-loading' => 'Сығарыу...',
	'wikieditor-toolbar-tool-bold' => 'Ҡалын',
	'wikieditor-toolbar-tool-bold-example' => 'Ҡалын яҙылыш',
	'wikieditor-toolbar-tool-italic' => 'Ҡыя',
	'wikieditor-toolbar-tool-italic-example' => 'Ҡыя яҙылыш',
	'wikieditor-toolbar-tool-ilink' => 'Эске һылтанма',
	'wikieditor-toolbar-tool-ilink-example' => 'Һылтанма исеме',
	'wikieditor-toolbar-tool-xlink' => 'Тышҡы һылтанма (http:// префиксын онотмағыҙ)',
	'wikieditor-toolbar-tool-xlink-example' => 'http://www.example.com һылтанма исеме',
	'wikieditor-toolbar-tool-link' => 'Һылтанма',
	'wikieditor-toolbar-tool-link-title' => 'Һылтанма өҫтәү',
	'wikieditor-toolbar-tool-link-int' => 'Вики биткә күсеү',
	'wikieditor-toolbar-tool-link-int-target' => 'Кәрәкле бит йәки URL:',
	'wikieditor-toolbar-tool-link-int-target-tooltip' => 'Биттең исеме йәки URL адресы:',
	'wikieditor-toolbar-tool-link-int-text' => 'Күрһәтелеүсе текст:',
	'wikieditor-toolbar-tool-link-int-text-tooltip' => 'Күрһәтелеүсе текст',
	'wikieditor-toolbar-tool-link-ext' => 'Тышҡы веб сайтҡа',
	'wikieditor-toolbar-tool-link-ext-target' => 'Һылтанманың URL адресы:',
	'wikieditor-toolbar-tool-link-ext-text' => 'Һылтанманың тексты:',
	'wikieditor-toolbar-tool-link-insert' => 'Һылтанма өҫтәргә',
	'wikieditor-toolbar-tool-link-cancel' => 'Кире алырға',
	'wikieditor-toolbar-tool-link-int-target-status-exists' => 'Был бит бар инде',
	'wikieditor-toolbar-tool-link-int-target-status-notexists' => 'Был бит юҡ',
	'wikieditor-toolbar-tool-link-int-target-status-invalid' => 'Исем дөрөҫ түгел',
	'wikieditor-toolbar-tool-link-int-target-status-external' => 'Тышҡы һылтанма',
	'wikieditor-toolbar-tool-link-int-target-status-loading' => 'Биттең барлығын тикшереү...',
	'wikieditor-toolbar-tool-link-int-invalid' => 'Керетелгән исем дөрөҫ түгел.',
	'wikieditor-toolbar-tool-link-lookslikeinternal' => 'Һеҙ күрһәткән URL адрес башҡа вики-биттең һылтанмаһына оҡшаған.
Был һылтанманы эске һылтанмаға әйләндерергә теләйһегеҙме?',
	'wikieditor-toolbar-tool-link-lookslikeinternal-int' => 'Эске һылтанма',
	'wikieditor-toolbar-tool-link-lookslikeinternal-ext' => 'Тышҡы һылтанма',
	'wikieditor-toolbar-tool-link-empty' => 'Һеҙ нимәгә һылтанма яһағанығыҙҙы күрһәтмәгәнһегеҙ.',
	'wikieditor-toolbar-tool-file' => 'Индерелгән файл',
	'wikieditor-toolbar-tool-file-example' => 'Миҫал.jpg',
	'wikieditor-toolbar-tool-file-title' => 'Файл өҫтәү',
	'wikieditor-toolbar-file-target' => 'Файл исеме:',
	'wikieditor-toolbar-file-size' => 'Күләме:',
	'wikieditor-toolbar-file-float' => 'Тигеҙләү:',
	'wikieditor-toolbar-file-default' => '(ғәҙәттәге)',
	'wikieditor-toolbar-file-format' => 'Формат:',
	'wikieditor-toolbar-tool-file-insert' => 'Өҫтәү',
	'wikieditor-toolbar-tool-file-cancel' => 'Кире алырға',
	'wikieditor-toolbar-tool-reference' => 'Төшөрмә',
	'wikieditor-toolbar-tool-reference-example' => 'Төшөрмәнең текстын бында керетегеҙ',
	'wikieditor-toolbar-tool-reference-cancel' => 'Кире алырға',
	'wikieditor-toolbar-tool-reference-title' => 'Төшөрмә өҫтәү',
	'wikieditor-toolbar-tool-reference-insert' => 'Өҫтәргә',
	'wikieditor-toolbar-tool-reference-text' => 'Төшөрмәнең тексты',
	'wikieditor-toolbar-tool-signature' => 'Имза һәм ҡуйыу ваҡыты',
	'wikieditor-toolbar-section-advanced' => 'Киңәйтелгән',
	'wikieditor-toolbar-tool-heading' => 'Исем',
	'wikieditor-toolbar-tool-heading-1' => '1-се быуын',
	'wikieditor-toolbar-tool-heading-2' => '2-се быуын',
	'wikieditor-toolbar-tool-heading-3' => '3-сө быуын',
	'wikieditor-toolbar-tool-heading-4' => '4-се быуын',
	'wikieditor-toolbar-tool-heading-5' => '5-се быуын',
	'wikieditor-toolbar-tool-heading-example' => 'Исем',
	'wikieditor-toolbar-group-format' => 'Форматлау',
	'wikieditor-toolbar-tool-ulist' => 'Тамғалы исемлек',
	'wikieditor-toolbar-tool-ulist-example' => 'Тамғалы исемлектең бер юлы',
	'wikieditor-toolbar-tool-olist' => 'Һанлы исемлек',
	'wikieditor-toolbar-tool-olist-example' => 'Һанлы исемлектең бер юлы',
	'wikieditor-toolbar-tool-indent' => 'Буш ара',
	'wikieditor-toolbar-tool-indent-example' => 'Буш аралы юл',
	'wikieditor-toolbar-tool-nowiki' => 'Вики-форматлауға иғтибар итмәҫкә',
	'wikieditor-toolbar-tool-nowiki-example' => 'Бында форматланмаған тексты өҫтәгеҙ.',
	'wikieditor-toolbar-tool-redirect' => 'Күсереү',
	'wikieditor-toolbar-tool-redirect-example' => 'Күсә торған биттең исеме',
	'wikieditor-toolbar-tool-big' => 'Эре',
	'wikieditor-toolbar-tool-big-example' => 'Эре текст',
	'wikieditor-toolbar-tool-small' => 'Ваҡ',
	'wikieditor-toolbar-tool-small-example' => 'Ваҡ текст',
	'wikieditor-toolbar-tool-superscript' => 'Юлдан өҫтә',
	'wikieditor-toolbar-tool-superscript-example' => 'Юлдан өҫтәге текст',
	'wikieditor-toolbar-tool-subscript' => 'Юлдан аҫта',
	'wikieditor-toolbar-tool-subscript-example' => 'Юлдан аҫтағы текст',
	'wikieditor-toolbar-group-insert' => 'Өҫтәү',
	'wikieditor-toolbar-tool-gallery' => 'Рәсемдәр йыйынтығы',
	'wikieditor-toolbar-tool-gallery-example' => '$1:Миҫал.jpg|Тасуирлама1
$1:Миҫал.jpg|Тасуирлама2',
	'wikieditor-toolbar-tool-newline' => 'Яңы юл',
	'wikieditor-toolbar-tool-table' => 'Таблица',
	'wikieditor-toolbar-tool-table-example-old' => '! башлыҡ 1
! башлыҡ 2
! башлыҡ 3
|-
| юл 1, күҙәнәк 1
| юл 1, күҙәнәк 2
| юл 1, күҙәнәк 3
|-
| юл 2, күҙәнәк 1
| юл 2, күҙәнәк 2
| юл 2, күҙәнәк 3',
	'wikieditor-toolbar-tool-table-example-cell-text' => 'Текст',
	'wikieditor-toolbar-tool-table-example-header' => 'Исем',
	'wikieditor-toolbar-tool-table-title' => 'Таблица өҫтәү',
	'wikieditor-toolbar-tool-table-dimensions-rows' => 'Юлдар',
	'wikieditor-toolbar-tool-table-dimensions-columns' => 'Бағаналар',
	'wikieditor-toolbar-tool-table-dimensions-header' => 'Башлыҡ юлын өҫтәү',
	'wikieditor-toolbar-tool-table-wikitable' => 'Сиктәрен яһау',
	'wikieditor-toolbar-tool-table-sortable' => 'Таблицаны тәртипкә килтермәле итергә',
	'wikieditor-toolbar-tool-table-example' => 'Текст',
	'wikieditor-toolbar-tool-table-preview' => 'Ҡарап сығырға',
	'wikieditor-toolbar-tool-table-insert' => 'Өҫтәргә',
	'wikieditor-toolbar-tool-table-cancel' => 'Кире алырға',
	'wikieditor-toolbar-tool-table-toomany' => 'Был диалог аша $1 күҙәнәктән ашыу дәүмәл менән таблица өҫтәргә мөмкин түгел.',
	'wikieditor-toolbar-tool-table-invalidnumber' => 'Һеҙ юлдар һәм бағаналар һанын дөрөҫ күрһәтмәгәнһегеҙ.',
	'wikieditor-toolbar-tool-table-zero' => 'Юлдар һәм бағаналар һаны нуль була алмай.',
	'wikieditor-toolbar-tool-replace' => 'Эҙләү һәм алмаштырыу',
	'wikieditor-toolbar-tool-replace-title' => 'Эҙләү һәм алмаштырыу',
	'wikieditor-toolbar-tool-replace-search' => 'Табырға:',
	'wikieditor-toolbar-tool-replace-replace' => 'Ошоға алмаштырырға:',
	'wikieditor-toolbar-tool-replace-case' => 'Регистрҙы иҫәпкә алырға',
	'wikieditor-toolbar-tool-replace-regex' => 'Эҙләү өсөн текстты регуляр аңлатма тип иҫәпләргә',
	'wikieditor-toolbar-tool-replace-button-findnext' => 'Сираттағыны табырға',
	'wikieditor-toolbar-tool-replace-button-replace' => 'Алмаштырырға',
	'wikieditor-toolbar-tool-replace-button-replaceall' => 'Барыһын да алмаштырырға',
	'wikieditor-toolbar-tool-replace-close' => 'Ябырға',
	'wikieditor-toolbar-tool-replace-nomatch' => 'Һеҙҙең һорауығыҙ буйынса бер ни ҙә табылманы.',
	'wikieditor-toolbar-tool-replace-success' => '$1 алмаштырыу үткәрелде.',
	'wikieditor-toolbar-tool-replace-emptysearch' => 'Һеҙ нимә эҙләгәнегеҙҙе күрһәтмәгәнһегеҙ.',
	'wikieditor-toolbar-tool-replace-invalidregex' => 'Һеҙ кереткән регуляр аңлатма дөрөҫ түгел:  $1',
	'wikieditor-toolbar-section-characters' => 'Махсус тамғалар',
	'wikieditor-toolbar-characters-page-latin' => 'Латин',
	'wikieditor-toolbar-characters-page-latinextended' => 'Латин (киңәйтелгән)',
	'wikieditor-toolbar-characters-page-ipa' => 'ХАФӘ (IPA)',
	'wikieditor-toolbar-characters-page-symbols' => 'Тамғалар',
	'wikieditor-toolbar-characters-page-greek' => 'Грек',
	'wikieditor-toolbar-characters-page-cyrillic' => 'Кириллик',
	'wikieditor-toolbar-characters-page-arabic' => 'Ғәрәп',
	'wikieditor-toolbar-characters-page-persian' => 'Фарсы',
	'wikieditor-toolbar-characters-page-hebrew' => 'Йәһүд',
	'wikieditor-toolbar-characters-page-bangla' => 'Бенгал',
	'wikieditor-toolbar-characters-page-tamil' => 'Тамиль',
	'wikieditor-toolbar-characters-page-telugu' => 'Телугу',
	'wikieditor-toolbar-characters-page-sinhala' => 'Сингал',
	'wikieditor-toolbar-characters-page-gujarati' => 'Гуджарати',
	'wikieditor-toolbar-characters-page-devanagari' => 'Деванагари',
	'wikieditor-toolbar-characters-page-thai' => 'Тай',
	'wikieditor-toolbar-characters-page-lao' => 'Лао',
	'wikieditor-toolbar-characters-page-khmer' => 'Кһмер',
	'wikieditor-toolbar-section-help' => 'Белешмә',
	'wikieditor-toolbar-help-heading-description' => 'Тасуирлама',
	'wikieditor-toolbar-help-heading-syntax' => 'Һеҙ керетәһегеҙ',
	'wikieditor-toolbar-help-heading-result' => 'Килеп сыға',
	'wikieditor-toolbar-help-page-format' => 'Форматлау',
	'wikieditor-toolbar-help-page-link' => 'Һылтанмалар',
	'wikieditor-toolbar-help-page-heading' => 'Исемдәр',
	'wikieditor-toolbar-help-page-list' => 'Исемлектәр',
	'wikieditor-toolbar-help-page-file' => 'Файлдар',
	'wikieditor-toolbar-help-page-reference' => 'Төшөрмәләр',
	'wikieditor-toolbar-help-page-discussion' => 'Фекер алышыу',
	'wikieditor-toolbar-help-content-italic-description' => 'Ҡыя',
	'wikieditor-toolbar-help-content-italic-syntax' => "''Ҡыя яҙыу''",
	'wikieditor-toolbar-help-content-italic-result' => '<em>Ҡыя яҙыу</em>',
	'wikieditor-toolbar-help-content-bold-description' => 'Ҡалын',
	'wikieditor-toolbar-help-content-bold-syntax' => "'''Ҡалын яҙыу'''",
	'wikieditor-toolbar-help-content-bold-result' => '<strong>Ҡалын яҙыу</strong>',
	'wikieditor-toolbar-help-content-bolditalic-description' => 'Ҡалын һәм ҡыя',
	'wikieditor-toolbar-help-content-bolditalic-syntax' => "'''''Ҡалын һәм ҡыя яҙыу'''''",
	'wikieditor-toolbar-help-content-bolditalic-result' => '<strong><em>Ҡалын һәм ҡыя яҙыу</em></strong>',
	'wikieditor-toolbar-help-content-ilink-description' => 'Эске һылтанма',
	'wikieditor-toolbar-help-content-ilink-syntax' => '[[Биттең исеме|Һылтанма тексты]]<br />[[Биттең исеме]]',
	'wikieditor-toolbar-help-content-ilink-result' => "<a href='#'>Һылтанма тексты</a><br /><a href='#'>Биттең исеме</a>",
	'wikieditor-toolbar-help-content-xlink-description' => 'Тышҡы һылтанма',
	'wikieditor-toolbar-help-content-xlink-syntax' => '[http://www.example.org Һылтанма тексты]<br />[http://www.example.org]<br />http://www.example.org',
	'wikieditor-toolbar-help-content-xlink-result' => "<a href='#' class='external'>Һылтанма тексты</a><br /><a href='#' class='external autonumber'>[1]</a><br /><a href='#' class='external'>http://www.example.org</a>",
	'wikieditor-toolbar-help-content-heading2-description' => '2-се быуындағы исем',
	'wikieditor-toolbar-help-content-heading2-syntax' => '==Исем ==',
	'wikieditor-toolbar-help-content-heading2-result' => '<h2>Исем</h2>',
	'wikieditor-toolbar-help-content-heading3-description' => '3-сө быуындағы исем',
	'wikieditor-toolbar-help-content-heading3-syntax' => '=== Исем ===',
	'wikieditor-toolbar-help-content-heading3-result' => '<h3>Исем</h3>',
	'wikieditor-toolbar-help-content-heading4-description' => '4-се быуындағы исем',
	'wikieditor-toolbar-help-content-heading4-syntax' => '==== Исем ====',
	'wikieditor-toolbar-help-content-heading4-result' => '<h4>Исем</h4>',
	'wikieditor-toolbar-help-content-heading5-description' => '5-се быуындағы исем',
	'wikieditor-toolbar-help-content-heading5-syntax' => '===== Исем =====',
	'wikieditor-toolbar-help-content-heading5-result' => '<h5>Исем</h5>',
	'wikieditor-toolbar-help-content-ulist-description' => 'Тамғалы исемлек',
	'wikieditor-toolbar-help-content-ulist-syntax' => '* Исемлектең бер юлы<br />* Исемлектең бер юлы',
	'wikieditor-toolbar-help-content-ulist-result' => '<ul><li>Исемлектең бер юлы</li><li>Исемлектең бер юлы</li></ul>',
	'wikieditor-toolbar-help-content-olist-description' => 'Һанлы исемлек',
	'wikieditor-toolbar-help-content-olist-syntax' => '# Исемлектең бер юлы<br /># Исемлектең бер юлы',
	'wikieditor-toolbar-help-content-olist-result' => '<ol><li>Исемлектең бер юлы</li><li>Исемлектең бер юлы</li></ol>',
	'wikieditor-toolbar-help-content-file-description' => 'Индерелгән файл',
	'wikieditor-toolbar-help-content-file-syntax' => '[[$1:Миҫал.png|thumb|Аңлатма]]',
	'wikieditor-toolbar-help-content-file-result' => "<div style='width:104px;' class='thumbinner'><a title='Аңлатма' class='image' href='#'><img height='50' width='100' border='0' class='thumbimage' src='$2/WikiEditor/modules/images/toolbar/example-image.png' alt=''/></a><div class='thumbcaption'><div class='magnify'><a title='Ҙурайтырға' class='internal' href='#'><img height='11' width='15' alt='' src='$1/common/images/magnify-clip.png'/></a></div>Аңлатма</div></div>",
	'wikieditor-toolbar-help-content-reference-description' => 'Төшөрмә',
	'wikieditor-toolbar-help-content-reference-syntax' => 'Биттәге текст.&lt;ref name="test"&gt;[http://www.example.org Һылтанма тексты], өҫтәмә текст.&lt;/ref&gt;',
	'wikieditor-toolbar-help-content-reference-result' => "Биттәге текст.<sup><a href='#'>[1]</a></sup>",
	'wikieditor-toolbar-help-content-rereference-description' => 'Бер үк төшөрмәне ҡабаттан ҡулланыу',
	'wikieditor-toolbar-help-content-rereference-result' => "Биттәге текст.<sup><a href='#'>[1]</a></sup>",
	'wikieditor-toolbar-help-content-showreferences-description' => 'Төшөрмәләрҙе күрһәтеү',
	'wikieditor-toolbar-help-content-showreferences-result' => "<ol class='references'><li id='cite_note-test-0'><b><a title='' href='#'>^</a></b> <a rel='nofollow' title='http://www.example.org' class='external text' href='#'>Һылтанма тексты</a>, өҫтәмә текст.</li></ol>",
	'wikieditor-toolbar-help-content-signaturetimestamp-description' => 'Имза һәм ҡуйыу ваҡыты',
	'wikieditor-toolbar-help-content-signaturetimestamp-result' => "<a href='#' title='{{#special:mypage}}'>Ҡатнашыусы исеме</a> (<a href='#' title='{{#special:mytalk}}'>фекер алышыу</a>) 11:56, 30 август (Урағай) 2010 (UTC)",
	'wikieditor-toolbar-help-content-signature-description' => 'Имза',
	'wikieditor-toolbar-help-content-signature-result' => "<a href='#' title='{{#special:mypage}}'>Ҡатнашыусы исеме</a> (<a href='#' title='{{#special:mytalk}}'>фекер алышыу</a>)",
	'wikieditor-toolbar-help-content-indent-description' => 'Буш ара',
	'wikieditor-toolbar-help-content-indent-syntax' => 'Ғәҙәттәге юл<br />:Буш аралы юл<br />::Буш аралы юл',
	'wikieditor-toolbar-help-content-indent-result' => 'Ғәҙәттәге юл<dl><dd>Буш аралы юл<dl><dd>Буш аралы юл</dd></dl></dd></dl>',
);

/** Bavarian (Boarisch)
 * @author Mucalexx
 */
$messages['bar'] = array(
	'wikieditor-template-editor-preference' => 'Formularbasirnds Beorweiten voh Wiki-Vurlong aktivirn',
	'wikieditor-template-editor-dialog-title' => 'Vurlog beorweiten',
	'wikieditor-template-editor-dialog-submit' => 'Aktualisirn',
	'wikieditor-template-editor-dialog-cancel' => 'Obbrechen',
	'wikieditor-templates-preference' => 'Aktiviarung vom Eih- und Ausblenden voh Vurlong',
);

/** Belarusian (беларуская)
 * @author Maksim L.
 * @author Yury Tarasievich
 */
$messages['be'] = array(
	'wikieditor' => 'Палепшаны інтэрфейс праўкі вікітэкста',
	'wikieditor-desc' => 'Дадае палепшаны інтэрфейс праўкі вікітэкста і шмат модульных функцый',
	'wikieditor-wikitext-tab' => 'Вікітэкст',
	'wikieditor-loading' => 'Загрузка',
	'wikieditor-preview-preference' => 'Уключыць перадпаказ бок аб бок',
	'wikieditor-preview-tab' => 'Перадпаказ',
	'wikieditor-preview-changes-tab' => 'Змены',
	'wikieditor-preview-loading' => 'Загрузка...',
	'wikieditor-publish-preference' => 'Уключыць пакрокавую публікацыю',
	'wikieditor-publish-button-publish' => 'Апублікаваць',
	'wikieditor-publish-button-cancel' => 'Закрыць',
	'wikieditor-publish-dialog-title' => 'Апублікаваць у {{GRAMMAR:месны|{{SITENAME}}}}',
	'wikieditor-publish-dialog-summary' => 'Тлумачэнне правак (каротка апішыце зробленыя праўкі)',
	'wikieditor-publish-dialog-minor' => 'Дробная праўка',
	'wikieditor-publish-dialog-watch' => 'Назіраць за гэтай старонкай',
	'wikieditor-publish-dialog-publish' => 'Апублікаваць',
	'wikieditor-publish-dialog-goback' => 'Вярнуцца',
	'wikieditor-template-editor-preference' => 'Уключыць праўку шаблонаў праз дыялогі',
	'wikieditor-template-editor-dialog-title' => 'Правіць шаблон',
	'wikieditor-template-editor-dialog-submit' => 'Абнавіць',
	'wikieditor-template-editor-dialog-cancel' => 'Закрыць',
	'wikieditor-templates-preference' => 'Уключыць згортванне шаблонаў',
	'wikieditor-toc-preference' => 'Уключыць змест з магчымасцю навігацыі',
	'wikieditor-toc-show' => 'Паказаць змест',
	'wikieditor-toc-hide' => 'Схаваць змест',
	'wikieditor-toolbar' => 'Панэль інструментаў',
	'wikieditor-toolbar-desc' => 'Панэль інструментаў з палепшанымі магчымасцямі',
	'wikieditor-toolbar-preference' => 'Уключыць панэль інструментаў з палепшанымі магчымасцямі',
	'wikieditor-toolbar-dialogs-preference' => 'Уключыць дыялогі для ўстаўкі спасылак, табліц і інш.',
	'wikieditor-toolbar-loading' => 'Загрузка…',
	'wikieditor-toolbar-tool-bold' => 'Цёмны',
	'wikieditor-toolbar-tool-bold-example' => 'Цёмны тэкст',
	'wikieditor-toolbar-tool-italic' => 'Курсіў',
	'wikieditor-toolbar-tool-italic-example' => 'Курсіўны тэкст',
	'wikieditor-toolbar-tool-ilink' => 'Унутраная спасылка',
	'wikieditor-toolbar-tool-ilink-example' => 'Назва спасылкі',
	'wikieditor-toolbar-tool-xlink' => 'Спасылка ў Сеціва (памятайце пра прэфікс http://)',
	'wikieditor-toolbar-tool-xlink-example' => 'http://www.example.com назва спасылкі',
	'wikieditor-toolbar-tool-link' => 'Спасылка',
	'wikieditor-toolbar-tool-link-title' => 'Уставіць спасылку',
	'wikieditor-toolbar-tool-link-int' => 'На вікі-старонку',
	'wikieditor-toolbar-tool-link-int-target' => 'Мэтавая старонка або URL:',
	'wikieditor-toolbar-tool-link-int-target-tooltip' => 'Назва старонкі або URL',
	'wikieditor-toolbar-tool-link-int-text' => 'Тэкст для паказу:',
	'wikieditor-toolbar-tool-link-int-text-tooltip' => 'Упішыце тэкст, які будзе паказаны',
	'wikieditor-toolbar-tool-link-ext' => 'На старонку ў Сеціве',
	'wikieditor-toolbar-tool-link-ext-target' => 'URL спасылкі:',
	'wikieditor-toolbar-tool-link-ext-text' => 'Тэкст спасылкі:',
	'wikieditor-toolbar-tool-link-insert' => 'Уставіць спасылку',
	'wikieditor-toolbar-tool-link-cancel' => 'Закрыць',
	'wikieditor-toolbar-tool-link-int-target-status-exists' => 'Старонка існуе',
	'wikieditor-toolbar-tool-link-int-target-status-notexists' => 'Старонкі не існуе',
	'wikieditor-toolbar-tool-link-int-target-status-invalid' => 'Няслушная назва',
	'wikieditor-toolbar-tool-link-int-target-status-external' => 'Спасылка ў Сеціва',
	'wikieditor-toolbar-tool-link-int-target-status-loading' => 'Праверка наяўнасці старонкі...',
	'wikieditor-toolbar-tool-link-int-invalid' => 'Упісаная няслушная назва.',
	'wikieditor-toolbar-tool-link-lookslikeinternal' => 'Устаўлены URL, падобны да спасылкі на іншую вікі-старонку.
Зрабіць спасылку ўнутранай?',
	'wikieditor-toolbar-tool-link-lookslikeinternal-int' => 'Унутраная спасылка',
	'wikieditor-toolbar-tool-link-lookslikeinternal-ext' => 'Спасылка ў Сеціва',
	'wikieditor-toolbar-tool-link-empty' => 'Вы не ўставілі адрас спасылкі.',
	'wikieditor-toolbar-tool-file' => 'Файл у тэксце',
	'wikieditor-toolbar-tool-file-example' => 'Example.jpg',
	'wikieditor-toolbar-tool-reference' => 'Зноска',
	'wikieditor-toolbar-tool-reference-example' => 'Упішыце сюды тэкст зноскі',
	'wikieditor-toolbar-tool-reference-cancel' => 'Закрыць',
	'wikieditor-toolbar-tool-reference-title' => 'Уставіць зноску',
	'wikieditor-toolbar-tool-reference-insert' => 'Уставіць',
	'wikieditor-toolbar-tool-reference-text' => 'Тэкст зноскі',
	'wikieditor-toolbar-tool-signature' => 'Ваш подпіс і адзначаны час',
	'wikieditor-toolbar-section-advanced' => 'Дадаткова',
	'wikieditor-toolbar-tool-heading' => 'Загаловак',
	'wikieditor-toolbar-tool-heading-1' => 'Узровень 1',
	'wikieditor-toolbar-tool-heading-2' => 'Узровень 2',
	'wikieditor-toolbar-tool-heading-3' => 'Узровень 3',
	'wikieditor-toolbar-tool-heading-4' => 'Узровень 4',
	'wikieditor-toolbar-tool-heading-5' => 'Узровень 5',
	'wikieditor-toolbar-tool-heading-example' => 'Тэкст загалоўка',
	'wikieditor-toolbar-group-format' => 'Фармат',
	'wikieditor-toolbar-tool-ulist' => 'Маркіраваны пералік',
	'wikieditor-toolbar-tool-ulist-example' => 'Элемент маркіраванага пераліку',
	'wikieditor-toolbar-tool-olist' => 'Нумараваны пералік',
	'wikieditor-toolbar-tool-olist-example' => 'Элемент нумараванага пераліку',
	'wikieditor-toolbar-tool-indent' => 'Водступ',
	'wikieditor-toolbar-tool-indent-example' => 'Радок з водступам',
	'wikieditor-toolbar-tool-nowiki' => 'Без вікі-фарматавання',
	'wikieditor-toolbar-tool-nowiki-example' => 'Устаўце сюды нефарматаваны тэкст',
	'wikieditor-toolbar-tool-redirect' => 'Redirect',
	'wikieditor-toolbar-tool-redirect-example' => 'Назва мэтавай старонкі',
	'wikieditor-toolbar-tool-big' => 'Буйны',
	'wikieditor-toolbar-tool-big-example' => 'Буйны тэкст',
	'wikieditor-toolbar-tool-small' => 'Дробны',
	'wikieditor-toolbar-tool-small-example' => 'Дробны тэкст',
	'wikieditor-toolbar-tool-superscript' => 'Верхні індэкс',
	'wikieditor-toolbar-tool-superscript-example' => 'Надрадковы тэкст',
	'wikieditor-toolbar-tool-subscript' => 'Ніжні індэкс',
	'wikieditor-toolbar-tool-subscript-example' => 'Падрадковы тэкст',
	'wikieditor-toolbar-group-insert' => 'Уставіць',
	'wikieditor-toolbar-tool-gallery' => 'Галерэя выяў',
	'wikieditor-toolbar-tool-gallery-example' => '$1:Example.jpg|Апісанне1
$1:Example.jpg|Апісанне2',
	'wikieditor-toolbar-tool-newline' => 'Новы радок',
	'wikieditor-toolbar-tool-table' => 'Табліца',
	'wikieditor-toolbar-tool-table-example-old' => '-
 ! загаловак 1
 ! загаловак 2
 ! загаловак 3
 | -
 | радок 1, ячэйка 1
 | радок 1, ячэйка 2
 | радок 1, ячэйка 3
 | -
 | радок 2, ячэйка 1
 | радок 2, ячэйка 2
 | радок 2, ячэйка 3',
	'wikieditor-toolbar-tool-table-example-cell-text' => 'Тэкст ячэйкі',
	'wikieditor-toolbar-tool-table-example-header' => 'Тэкст загалоўка',
	'wikieditor-toolbar-tool-table-title' => 'Уставіць табліцу',
	'wikieditor-toolbar-tool-table-dimensions-rows' => 'Радкоў',
	'wikieditor-toolbar-tool-table-dimensions-columns' => 'Слупкоў',
	'wikieditor-toolbar-tool-table-dimensions-header' => 'Дадаць радок загалоўка',
	'wikieditor-toolbar-tool-table-wikitable' => 'Стыль з граніцамі',
	'wikieditor-toolbar-tool-table-sortable' => 'Дадаць магчымасць сартавання',
	'wikieditor-toolbar-tool-table-example' => 'Тэкст ячэйкі',
	'wikieditor-toolbar-tool-table-preview' => 'Перадпаказ',
	'wikieditor-toolbar-tool-table-insert' => 'Уставіць',
	'wikieditor-toolbar-tool-table-cancel' => 'Закрыць',
	'wikieditor-toolbar-tool-table-toomany' => 'Устаўка табліцы больш чым з $ 1 {{PLURAL:$1|ячэйкай|ячэйкамі|ячэйкамі}} не магчыма праз гэты дыялог.',
	'wikieditor-toolbar-tool-table-invalidnumber' => 'Вы не ўвялі слушную колькасць радкоў або слупкоў.',
	'wikieditor-toolbar-tool-table-zero' => 'Вы не можаце ўставіць табліцу з нулявой колькасцю радкоў або слупкоў.',
	'wikieditor-toolbar-tool-replace' => 'Знайсці і замяніць',
	'wikieditor-toolbar-tool-replace-title' => 'Пошук і замена',
	'wikieditor-toolbar-tool-replace-search' => 'Знайсці:',
	'wikieditor-toolbar-tool-replace-replace' => 'Замяніць на:',
	'wikieditor-toolbar-tool-replace-case' => 'З улікам рэгістру',
	'wikieditor-toolbar-tool-replace-regex' => 'Лічыць радок пошуку рэгулярным выразам',
	'wikieditor-toolbar-tool-replace-button-findnext' => 'Знайсці наступнае',
	'wikieditor-toolbar-tool-replace-button-replaceall' => 'Замяніць усе',
	'wikieditor-toolbar-tool-replace-close' => 'Закрыць',
	'wikieditor-toolbar-tool-replace-nomatch' => 'Ваш пошук нічога не даў.',
	'wikieditor-toolbar-tool-replace-success' => 'Зроблена $1 замен.',
	'wikieditor-toolbar-tool-replace-emptysearch' => 'Вы не далі чаго шукаць.',
	'wikieditor-toolbar-tool-replace-invalidregex' => 'Вы далі няверны рэгулярны выраз: $1',
	'wikieditor-toolbar-section-characters' => 'Спецыяльныя сімвалы',
	'wikieditor-toolbar-characters-page-latin' => 'Лацінскія',
	'wikieditor-toolbar-characters-page-latinextended' => 'Лацінскія дадатковыя',
	'wikieditor-toolbar-characters-page-ipa' => 'IPA',
	'wikieditor-toolbar-characters-page-symbols' => 'Сімвалы',
	'wikieditor-toolbar-characters-page-greek' => 'Грэчаскія',
	'wikieditor-toolbar-characters-page-cyrillic' => 'Кірылічныя',
	'wikieditor-toolbar-characters-page-arabic' => 'Арабскія',
	'wikieditor-toolbar-characters-page-persian' => 'Персідскія',
	'wikieditor-toolbar-characters-page-hebrew' => 'Іўрыт',
	'wikieditor-toolbar-characters-page-bangla' => 'Бенгальскія',
	'wikieditor-toolbar-characters-page-telugu' => 'Целугу',
	'wikieditor-toolbar-characters-page-sinhala' => 'Сінгальскія',
	'wikieditor-toolbar-characters-page-gujarati' => 'Гуджараці',
	'wikieditor-toolbar-characters-page-thai' => 'Тайскія',
	'wikieditor-toolbar-characters-page-lao' => 'Лаоскія',
	'wikieditor-toolbar-characters-page-khmer' => 'Кхмерскія',
	'wikieditor-toolbar-section-help' => 'Даведка',
	'wikieditor-toolbar-help-heading-description' => 'Апісанне',
	'wikieditor-toolbar-help-heading-syntax' => 'Што Вы ўпісваеце',
	'wikieditor-toolbar-help-heading-result' => 'Што Вы атрымаеце',
	'wikieditor-toolbar-help-page-format' => 'Фарматаванне',
	'wikieditor-toolbar-help-page-link' => 'Спасылкі',
	'wikieditor-toolbar-help-page-heading' => 'Загалоўкі',
	'wikieditor-toolbar-help-page-list' => 'Пералікі',
	'wikieditor-toolbar-help-page-file' => 'Файлы',
	'wikieditor-toolbar-help-page-reference' => 'Зноскі',
	'wikieditor-toolbar-help-page-discussion' => 'Размовы',
	'wikieditor-toolbar-help-content-italic-description' => 'Курсіў',
	'wikieditor-toolbar-help-content-italic-syntax' => "''Курсіўны тэкст''",
	'wikieditor-toolbar-help-content-italic-result' => '<em>Курсіўны тэкст</em>',
	'wikieditor-toolbar-help-content-bold-description' => 'Цёмны',
	'wikieditor-toolbar-help-content-bold-syntax' => "'''Цёмны тэкст'''",
	'wikieditor-toolbar-help-content-bold-result' => '<strong>Цёмны тэкст</strong>',
	'wikieditor-toolbar-help-content-bolditalic-description' => 'Цёмны курсіў',
	'wikieditor-toolbar-help-content-bolditalic-syntax' => "'''''Цёмны курсіўны тэкст'''''",
	'wikieditor-toolbar-help-content-bolditalic-result' => '<em><strong>Цёмны курсіўны тэкст</strong></em>',
	'wikieditor-toolbar-help-content-ilink-description' => 'Унутраная спасылка',
	'wikieditor-toolbar-help-content-ilink-syntax' => '[[Назва мэтавай старонкі|Тэкст спасылкі]]<br />[[Назва мэтавай старонкі]]',
	'wikieditor-toolbar-help-content-ilink-result' => "<a href='#'>Тэкст спасылкі</a><br /><a href='#'>Назва мэтавай старонкі</a>",
	'wikieditor-toolbar-help-content-xlink-description' => 'Спасылка ў Сеціва',
	'wikieditor-toolbar-help-content-xlink-syntax' => '[http://www.example.org Тэкст спасылкі]<br />[http://www.example.org]<br />http://www.example.org',
	'wikieditor-toolbar-help-content-xlink-result' => "<a href='#' class='external'>Тэкст спасылкі</a><br /><a href='#' class='external autonumber'>[1]</a><br /><a href='#' class='external'>http://www.example.org</a>",
	'wikieditor-toolbar-help-content-heading2-description' => 'Загаловак 2-га ўзроўню',
	'wikieditor-toolbar-help-content-heading2-syntax' => '== Тэкст загалоўка ==',
	'wikieditor-toolbar-help-content-heading2-result' => '<h2>Тэкст загалоўка</h2>',
	'wikieditor-toolbar-help-content-heading3-description' => 'Загаловак 3-га ўзроўню',
	'wikieditor-toolbar-help-content-heading3-syntax' => '=== Тэкст загалоўка ===',
	'wikieditor-toolbar-help-content-heading3-result' => '<h3>Тэкст загалоўка</h3>',
	'wikieditor-toolbar-help-content-heading4-description' => 'Загаловак 4-га ўзроўню',
	'wikieditor-toolbar-help-content-heading4-syntax' => '==== Тэкст загалоўка ====',
	'wikieditor-toolbar-help-content-heading4-result' => '<h4>Тэкст загалоўка</h4>',
	'wikieditor-toolbar-help-content-heading5-description' => 'Загаловак 5-га ўзроўню',
	'wikieditor-toolbar-help-content-heading5-syntax' => '===== Тэкст загалоўка =====',
	'wikieditor-toolbar-help-content-heading5-result' => '<h5>Тэкст загалоўка</h5>',
	'wikieditor-toolbar-help-content-ulist-description' => 'Маркіраваны пералік',
	'wikieditor-toolbar-help-content-ulist-syntax' => '* Элемент пераліка<br /> * Элемент пераліка',
	'wikieditor-toolbar-help-content-ulist-result' => '<ul><li>Элемент пераліка</li><li>Элемент пераліка</li></ul>',
	'wikieditor-toolbar-help-content-olist-description' => 'Нумараваны пералік',
	'wikieditor-toolbar-help-content-olist-syntax' => '# Элемент пераліка<br /># Элемент пераліка',
	'wikieditor-toolbar-help-content-olist-result' => '<ol><li>Элемент пераліка</li><li>Элемент пераліка</li></ol>',
	'wikieditor-toolbar-help-content-file-description' => 'Файл у тэксце',
	'wikieditor-toolbar-help-content-file-syntax' => '[[$1:Example.png|thumb|Апісанне файла]]',
	'wikieditor-toolbar-help-content-file-result' => "<div style='width:104px;' class='thumbinner'><a title='Апісанне файла' class='image' href='#'><img height='50' width='100' border='0' class='thumbimage' src='$2/WikiEditor/modules/images/toolbar/example-image.png' alt=''/></a><div class='thumbcaption'><div class='magnify'><a title='Enlarge' class='internal' href='#'><img height='11' width='15' alt='' src='$1/common/images/magnify-clip.png'/></a></div>Апісанне файла</div></div>",
	'wikieditor-toolbar-help-content-reference-description' => 'Зноска',
	'wikieditor-toolbar-help-content-reference-syntax' => 'Тэкст на старонцы.&lt;ref name="test"&gt;[http://www.example.org Тэкст спасылкі], астатні тэкст зноскі.&lt;/ref&gt;',
	'wikieditor-toolbar-help-content-reference-result' => "Тэкст на старонцы.<sup><a href='#'>[1]</a></sup>",
	'wikieditor-toolbar-help-content-rereference-description' => 'Шматразовае карыстанне зноскай',
	'wikieditor-toolbar-help-content-rereference-result' => "Тэкст на старонцы.<sup><a href='#'>[1]</a></sup>",
	'wikieditor-toolbar-help-content-showreferences-description' => 'Паказаць зноскі',
	'wikieditor-toolbar-help-content-showreferences-result' => "<ol class='references'><li id='cite_note-test-0'><b><a title='' href='#'>^</a></b> <a rel='nofollow' title='http://www.example.org' class='external text' href='#'>Тэскт спасылкі</a>, астатні тэкст зноскі.</li></ol>",
	'wikieditor-toolbar-help-content-signaturetimestamp-description' => 'Ваш подпіс і адзначаны час',
	'wikieditor-toolbar-help-content-signaturetimestamp-result' => "<a href='#' title='{{#special:mypage}}'>Імя ўдзельніка</a> (<a href='#' title='{{#special:mytalk}}'>размовы</a>) 15:54, 10 June 2009 (UTC)",
	'wikieditor-toolbar-help-content-signature-description' => 'Подпіс',
	'wikieditor-toolbar-help-content-signature-result' => "<a href='#' title='{{#special:mypage}}'>Імя ўдзельніка</a> (<a href='#' title='{{#special:mytalk}}'>размовы</a>)",
	'wikieditor-toolbar-help-content-indent-description' => 'Водступ',
	'wikieditor-toolbar-help-content-indent-syntax' => 'Просты тэкст<br />:Тэкст з водступам<br />::Тэкст з водступам',
	'wikieditor-toolbar-help-content-indent-result' => 'Просты тэкст<dl><dd>Тэкст з водступам<dl><dd>Тэкст з водступам</dd></dl></dd></dl>',
);

/** Belarusian (Taraškievica orthography) (беларуская (тарашкевіца)‎)
 * @author EugeneZelenko
 * @author Jim-by
 * @author Renessaince
 * @author Wizardist
 * @author Zedlik
 */
$messages['be-tarask'] = array(
	'wikieditor' => 'Пашыраны інтэрфэйс рэдагаваньня вікі-тэксту',
	'wikieditor-desc' => 'Дадае пашыраны інтэрфэйс рэдагаваньня вікі-тэксту і шмат модульных магчымасьцяў',
	'wikieditor-wikitext-tab' => 'Вікі-тэкст',
	'wikieditor-loading' => 'Загрузка',
	'wikieditor-preview-preference' => 'Уключыць папярэдні прагляд адзін каля аднаго',
	'wikieditor-preview-tab' => 'Папярэдні прагляд',
	'wikieditor-preview-changes-tab' => 'Зьмены',
	'wikieditor-preview-loading' => 'Загрузка…',
	'wikieditor-previewDialog-preference' => 'Уключыць дыялёг папярэдняга прагляду',
	'wikieditor-previewDialog-tab' => 'Папярэдні прагляд',
	'wikieditor-previewDialog-loading' => 'Загрузка…',
	'wikieditor-publish-preference' => 'Уключыць пакрокавую публікацыю',
	'wikieditor-publish-button-publish' => 'Апублікаваць',
	'wikieditor-publish-button-cancel' => 'Скасаваць',
	'wikieditor-publish-dialog-title' => 'Апублікаваць у {{GRAMMAR:месны|{{SITENAME}}}}',
	'wikieditor-publish-dialog-summary' => 'Апісаньне рэдагаваньняў (коратка апішыце зробленыя Вамі зьмены):',
	'wikieditor-publish-dialog-minor' => 'Дробная праўка',
	'wikieditor-publish-dialog-watch' => 'Назіраць за гэтай старонкай',
	'wikieditor-publish-dialog-publish' => 'Апублікаваць',
	'wikieditor-publish-dialog-goback' => 'Вярнуцца',
	'wikieditor-template-editor-preference' => 'Дазволіць рэдагаваньне шаблёнаў вікі праз формы',
	'wikieditor-template-editor-dialog-title' => 'Рэдагаваць шаблён',
	'wikieditor-template-editor-dialog-submit' => 'Абнавіць',
	'wikieditor-template-editor-dialog-cancel' => 'Скасаваць',
	'wikieditor-templates-preference' => 'Уключыць згортваньне шаблёнаў',
	'wikieditor-toc-preference' => 'Уключыць зьмест з магчымасьцю навігацыі',
	'wikieditor-toc-show' => 'Паказаць зьмест',
	'wikieditor-toc-hide' => 'Схаваць зьмест',
	'wikieditor-toolbar' => 'Панэль інструмэнтаў для рэдагаваньня',
	'wikieditor-toolbar-desc' => 'Панэль інструмэнтаў для рэдагаваньня з палепшанай зручнасьцю',
	'wikieditor-toolbar-preference' => 'Уключыць палепшаную панэль інструмэнтаў для рэдагаваньня',
	'wikieditor-toolbar-dialogs-preference' => 'Дазволіць формы для ўстаўкі спасылак, табліцаў і іншых элемэнтаў',
	'wikieditor-toolbar-hidesig' => 'Схаваць кнопку подпісу са старонак у асноўнай прасторы назваў',
	'wikieditor-toolbar-loading' => 'Загрузка…',
	'wikieditor-toolbar-tool-bold' => 'Тоўсты',
	'wikieditor-toolbar-tool-bold-example' => 'Тоўсты тэкст',
	'wikieditor-toolbar-tool-italic' => 'Курсіў',
	'wikieditor-toolbar-tool-italic-example' => 'Курсіўны тэкст',
	'wikieditor-toolbar-tool-ilink' => 'Унутраная спасылка',
	'wikieditor-toolbar-tool-ilink-example' => 'Назва спасылкі',
	'wikieditor-toolbar-tool-xlink' => 'Вонкавая спасылка (не забывайцеся пачынаць з http://)',
	'wikieditor-toolbar-tool-xlink-example' => 'http://www.example.com назва спасылкі',
	'wikieditor-toolbar-tool-link' => 'Спасылка',
	'wikieditor-toolbar-tool-link-title' => 'Уставіць спасылку',
	'wikieditor-toolbar-tool-link-int' => 'На вікі-старонку',
	'wikieditor-toolbar-tool-link-int-target' => 'Назва старонкі:',
	'wikieditor-toolbar-tool-link-int-target-tooltip' => 'Назва старонкі альбо URL-адрас',
	'wikieditor-toolbar-tool-link-int-text' => 'Тэкст спасылкі:',
	'wikieditor-toolbar-tool-link-int-text-tooltip' => 'Увядзіце тэкст, які павінен быць паказаны',
	'wikieditor-toolbar-tool-link-ext' => 'На вонкавую ўэб-старонку',
	'wikieditor-toolbar-tool-link-ext-target' => 'URL-адрас спасылкі:',
	'wikieditor-toolbar-tool-link-ext-text' => 'Тэкст спасылкі:',
	'wikieditor-toolbar-tool-link-insert' => 'Уставіць спасылку',
	'wikieditor-toolbar-tool-link-cancel' => 'Закрыць',
	'wikieditor-toolbar-tool-link-int-target-status-exists' => 'Старонка існуе',
	'wikieditor-toolbar-tool-link-int-target-status-notexists' => 'Старонка не існуе',
	'wikieditor-toolbar-tool-link-int-target-status-invalid' => 'Няслушная назва',
	'wikieditor-toolbar-tool-link-int-target-status-external' => 'Вонкавая спасылка',
	'wikieditor-toolbar-tool-link-int-target-status-loading' => 'Праверка існаваньня старонкі…',
	'wikieditor-toolbar-tool-link-int-invalid' => 'Пазначаная няслушная назва.',
	'wikieditor-toolbar-tool-link-lookslikeinternal' => 'Пададзены URL-адрас верагодна зьяўляецца спасылкай на іншую вікі-старонку.
Ці жадаеце зрабіць яе ўнутранай спасылкай?',
	'wikieditor-toolbar-tool-link-lookslikeinternal-int' => 'Унутраная спасылка',
	'wikieditor-toolbar-tool-link-lookslikeinternal-ext' => 'Вонкавая спасылка',
	'wikieditor-toolbar-tool-link-empty' => 'Вы не ўвялі адрас спасылкі.',
	'wikieditor-toolbar-tool-file' => 'Укладзены файл',
	'wikieditor-toolbar-tool-file-example' => 'Прыклад.jpg',
	'wikieditor-toolbar-tool-file-title' => 'Уставіць файл',
	'wikieditor-toolbar-file-target' => 'Назва файла:',
	'wikieditor-toolbar-file-caption' => 'Подпіс:',
	'wikieditor-toolbar-file-size' => 'Памер:',
	'wikieditor-toolbar-file-float' => 'Раўнаваньне:',
	'wikieditor-toolbar-file-default' => '(стандартнае)',
	'wikieditor-toolbar-file-format' => 'Фармат:',
	'wikieditor-toolbar-file-format-none' => 'няма',
	'wikieditor-toolbar-tool-file-insert' => 'Уставіць',
	'wikieditor-toolbar-tool-file-cancel' => 'Скасаваць',
	'wikieditor-toolbar-tool-reference' => 'Зноска',
	'wikieditor-toolbar-tool-reference-example' => 'Устаўце сюды тэкст зноскі',
	'wikieditor-toolbar-tool-reference-cancel' => 'Закрыць',
	'wikieditor-toolbar-tool-reference-title' => 'Уставіць зноску',
	'wikieditor-toolbar-tool-reference-insert' => 'Уставіць',
	'wikieditor-toolbar-tool-reference-text' => 'Тэкст зноскі',
	'wikieditor-toolbar-tool-signature' => 'Подпіс і час',
	'wikieditor-toolbar-section-advanced' => 'Дадаткова',
	'wikieditor-toolbar-tool-heading' => 'Загаловак',
	'wikieditor-toolbar-tool-heading-1' => 'Узровень 1',
	'wikieditor-toolbar-tool-heading-2' => 'Узровень 2',
	'wikieditor-toolbar-tool-heading-3' => 'Узровень 3',
	'wikieditor-toolbar-tool-heading-4' => 'Узровень 4',
	'wikieditor-toolbar-tool-heading-5' => 'Узровень 5',
	'wikieditor-toolbar-tool-heading-example' => 'Тэкст загалоўку',
	'wikieditor-toolbar-group-format' => 'Фармат',
	'wikieditor-toolbar-tool-ulist' => 'Маркіраваны сьпіс',
	'wikieditor-toolbar-tool-ulist-example' => 'Элемэнт маркіраванага сьпісу',
	'wikieditor-toolbar-tool-olist' => 'Нумараваны сьпіс',
	'wikieditor-toolbar-tool-olist-example' => 'Элемэнт нумараванага сьпісу',
	'wikieditor-toolbar-tool-indent' => 'Водступ',
	'wikieditor-toolbar-tool-indent-example' => 'Радок з водступам',
	'wikieditor-toolbar-tool-nowiki' => 'Ігнараваць вікі-фарматаваньне',
	'wikieditor-toolbar-tool-nowiki-example' => 'Устаўце сюды нефарматаваны тэкст',
	'wikieditor-toolbar-tool-redirect' => 'Перанакіраваньне',
	'wikieditor-toolbar-tool-redirect-example' => 'Назва мэтавай старонкі',
	'wikieditor-toolbar-tool-big' => 'Буйны',
	'wikieditor-toolbar-tool-big-example' => 'Буйны тэкст',
	'wikieditor-toolbar-tool-small' => 'Дробны',
	'wikieditor-toolbar-tool-small-example' => 'Дробны тэкст',
	'wikieditor-toolbar-tool-superscript' => 'Верхні індэкс',
	'wikieditor-toolbar-tool-superscript-example' => 'Надрадковы тэкст',
	'wikieditor-toolbar-tool-subscript' => 'Ніжні індэкс',
	'wikieditor-toolbar-tool-subscript-example' => 'Падрадковы тэкст',
	'wikieditor-toolbar-group-insert' => 'Уставіць',
	'wikieditor-toolbar-tool-gallery' => 'Галерэя выяваў',
	'wikieditor-toolbar-tool-gallery-example' => '$1:Прыклад.jpg|Подпіс1
$1:Прыклад.jpg|Подпіс2',
	'wikieditor-toolbar-tool-newline' => 'Новы радок',
	'wikieditor-toolbar-tool-table' => 'Табліца',
	'wikieditor-toolbar-tool-table-example-old' => '-
! загаловак 1
! загаловак 2
! загаловак 3
|-
| радок 1, ячэйка 1
| радок 1, ячэйка 2
| радок 1, ячэйка 3
|-
| радок 2, ячэйка 1
| радок 2, ячэйка 2
| радок 2, ячэйка 3',
	'wikieditor-toolbar-tool-table-example-cell-text' => 'Тэкст у ячэйцы',
	'wikieditor-toolbar-tool-table-example-header' => 'Тэкст загалоўку',
	'wikieditor-toolbar-tool-table-title' => 'Уставіць табліцу',
	'wikieditor-toolbar-tool-table-dimensions-rows' => 'Радкоў',
	'wikieditor-toolbar-tool-table-dimensions-columns' => 'Слупкоў',
	'wikieditor-toolbar-tool-table-dimensions-header' => 'Дадаць радок загалоўку',
	'wikieditor-toolbar-tool-table-wikitable' => 'Стыль зь межамі',
	'wikieditor-toolbar-tool-table-sortable' => 'Дадаць магчымасьць сартаваньня',
	'wikieditor-toolbar-tool-table-example' => 'Тэкст у ячэйцы',
	'wikieditor-toolbar-tool-table-preview' => 'Папярэдні прагляд',
	'wikieditor-toolbar-tool-table-insert' => 'Уставіць',
	'wikieditor-toolbar-tool-table-cancel' => 'Закрыць',
	'wikieditor-toolbar-tool-table-toomany' => 'Гэтая форма ня можа ўставіць табліцу, якая ўтрымлівае больш за $1 {{PLURAL:$1|ячэйку|ячэйкі|ячэек}}.',
	'wikieditor-toolbar-tool-table-invalidnumber' => 'Вы не ўвялі слушную колькасьць радкоў ці слупкоў.',
	'wikieditor-toolbar-tool-table-zero' => 'Вы ня можаце ўставіць табліцу з нулявой колькасьцю радкоў ці слупкоў.',
	'wikieditor-toolbar-tool-replace' => 'Знайсьці і замяніць',
	'wikieditor-toolbar-tool-replace-title' => 'Пошук і замена',
	'wikieditor-toolbar-tool-replace-search' => 'Шукаць:',
	'wikieditor-toolbar-tool-replace-replace' => 'Замяніць на:',
	'wikieditor-toolbar-tool-replace-case' => 'Улічваць рэгістар літар',
	'wikieditor-toolbar-tool-replace-regex' => 'Лічыць радок пошуку рэгулярным выразам',
	'wikieditor-toolbar-tool-replace-button-findnext' => 'Працягваць пошук',
	'wikieditor-toolbar-tool-replace-button-replace' => 'Замяніць',
	'wikieditor-toolbar-tool-replace-button-replaceall' => 'Замяніць усё',
	'wikieditor-toolbar-tool-replace-close' => 'Закрыць',
	'wikieditor-toolbar-tool-replace-nomatch' => 'Па Вашым запыце нічога ня знойдзена.',
	'wikieditor-toolbar-tool-replace-success' => 'Зроблена заменаў: $1.',
	'wikieditor-toolbar-tool-replace-emptysearch' => 'Вы не ўвялі нічога для пошуку.',
	'wikieditor-toolbar-tool-replace-invalidregex' => 'Уведзены Вамі рэгулярны выраз зьяўляецца няслушным: $1',
	'wikieditor-toolbar-section-characters' => 'Спэцыяльныя сымбалі',
	'wikieditor-toolbar-characters-page-latin' => 'Лацінскія',
	'wikieditor-toolbar-characters-page-latinextended' => 'Лацінскія дадатковыя',
	'wikieditor-toolbar-characters-page-ipa' => 'МФА (IPA)',
	'wikieditor-toolbar-characters-page-symbols' => 'Сымбалі',
	'wikieditor-toolbar-characters-page-greek' => 'Грэцкія',
	'wikieditor-toolbar-characters-page-cyrillic' => 'Кірылічныя',
	'wikieditor-toolbar-characters-page-arabic' => 'Арабскія',
	'wikieditor-toolbar-characters-page-arabicextended' => 'Арабскія пашыраныя',
	'wikieditor-toolbar-characters-page-persian' => 'Пэрсыдзкія',
	'wikieditor-toolbar-characters-page-hebrew' => 'Іўрыт',
	'wikieditor-toolbar-characters-page-bangla' => 'Бэнгальскія',
	'wikieditor-toolbar-characters-page-tamil' => 'Тамільскія',
	'wikieditor-toolbar-characters-page-telugu' => 'Тэлугу',
	'wikieditor-toolbar-characters-page-sinhala' => 'Сынгальскія',
	'wikieditor-toolbar-characters-page-gujarati' => 'Гуджараці',
	'wikieditor-toolbar-characters-page-devanagari' => 'Дэванагары',
	'wikieditor-toolbar-characters-page-thai' => 'Тайскія',
	'wikieditor-toolbar-characters-page-lao' => 'Лаоскія',
	'wikieditor-toolbar-characters-page-khmer' => 'Кхмэрскія',
	'wikieditor-toolbar-section-help' => 'Дапамога',
	'wikieditor-toolbar-help-heading-description' => 'Апісаньне',
	'wikieditor-toolbar-help-heading-syntax' => 'Што Вы ўводзіце',
	'wikieditor-toolbar-help-heading-result' => 'Што Вы атрымаеце',
	'wikieditor-toolbar-help-page-format' => 'Фарматаваньне',
	'wikieditor-toolbar-help-page-link' => 'Спасылкі',
	'wikieditor-toolbar-help-page-heading' => 'Загалоўкі',
	'wikieditor-toolbar-help-page-list' => 'Сьпісы',
	'wikieditor-toolbar-help-page-file' => 'Файлы',
	'wikieditor-toolbar-help-page-reference' => 'Зноскі',
	'wikieditor-toolbar-help-page-discussion' => 'Абмеркаваньне',
	'wikieditor-toolbar-help-content-italic-description' => 'Курсіў',
	'wikieditor-toolbar-help-content-italic-syntax' => "''Курсіўны тэкст''",
	'wikieditor-toolbar-help-content-italic-result' => '<em>Курсіўны тэкст</em>',
	'wikieditor-toolbar-help-content-bold-description' => 'Тоўсты',
	'wikieditor-toolbar-help-content-bold-syntax' => "'''Тоўсты тэкст'''",
	'wikieditor-toolbar-help-content-bold-result' => '<strong>Тоўсты тэкст</strong>',
	'wikieditor-toolbar-help-content-bolditalic-description' => 'Тоўсты курсіў',
	'wikieditor-toolbar-help-content-bolditalic-syntax' => "'''''Тоўсты курсіўны тэкст'''''",
	'wikieditor-toolbar-help-content-bolditalic-result' => '<strong><em>Тоўсты курсіўны тэкст</em></strong>',
	'wikieditor-toolbar-help-content-ilink-description' => 'Унутраная спасылка',
	'wikieditor-toolbar-help-content-ilink-syntax' => '[[Назва старонкі|Метка спасылкі]]<br />[[Назва старонкі]]',
	'wikieditor-toolbar-help-content-ilink-result' => "<a href='#'>Тэкст спасылкі</a><br /><a href='#'>Назва старонкі</a>",
	'wikieditor-toolbar-help-content-xlink-description' => 'Вонкавая спасылка',
	'wikieditor-toolbar-help-content-xlink-syntax' => '[http://www.example.org Тэкст спасылкі]<br />[http://www.example.org]<br />http://www.example.org',
	'wikieditor-toolbar-help-content-xlink-result' => "<a href='#' class='external'>Метка спасылкі</a><br /><a href='#' class='external autonumber'>[1]</a><br /><a href='#' class='external'>http://www.example.org</a>",
	'wikieditor-toolbar-help-content-heading2-description' => 'Загаловак 2-га ўзроўню',
	'wikieditor-toolbar-help-content-heading2-syntax' => '== Тэкст загалоўку ==',
	'wikieditor-toolbar-help-content-heading2-result' => '<h2>Тэкст загалоўку</h2>',
	'wikieditor-toolbar-help-content-heading3-description' => 'Загаловак 3-га ўзроўню',
	'wikieditor-toolbar-help-content-heading3-syntax' => '=== Тэкст загалоўку ===',
	'wikieditor-toolbar-help-content-heading3-result' => '<h3>Тэкст загалоўку</h3>',
	'wikieditor-toolbar-help-content-heading4-description' => 'Загаловак 4-га ўзроўню',
	'wikieditor-toolbar-help-content-heading4-syntax' => '==== Тэкст загалоўку ====',
	'wikieditor-toolbar-help-content-heading4-result' => '<h4>Тэкст загалоўку</h4>',
	'wikieditor-toolbar-help-content-heading5-description' => 'Загаловак 5-га ўзроўню',
	'wikieditor-toolbar-help-content-heading5-syntax' => '===== Тэкст загалоўку =====',
	'wikieditor-toolbar-help-content-heading5-result' => '<h5>Тэкст загалоўку</h5>',
	'wikieditor-toolbar-help-content-ulist-description' => 'Маркіраваны сьпіс',
	'wikieditor-toolbar-help-content-ulist-syntax' => '* Элемэнт сьпісу<br />* Элемэнт сьпісу',
	'wikieditor-toolbar-help-content-ulist-result' => '<ul><li>Элемэнт сьпісу</li><li>Элемэнт сьпісу</li></ul>',
	'wikieditor-toolbar-help-content-olist-description' => 'Нумараваны сьпіс',
	'wikieditor-toolbar-help-content-olist-syntax' => '# Элемэнт сьпісу<br /># Элемэнт сьпісу',
	'wikieditor-toolbar-help-content-olist-result' => '<ol><li>Элемэнт сьпісу</li><li>Элемэнт сьпісу</li></ol>',
	'wikieditor-toolbar-help-content-file-description' => 'Укладзены файл',
	'wikieditor-toolbar-help-content-file-syntax' => '[[$1:Прыклад.png|thumb|Тэкст подпісу]]',
	'wikieditor-toolbar-help-content-file-result' => "<div style='width:104px;' class='thumbinner'><a title='Тэкст подпісу' class='image' href='#'><img height='50' width='100' border='0' class='thumbimage' src='$2/WikiEditor/modules/images/toolbar/example-image.png' alt=''/></a><div class='thumbcaption'><div class='magnify'><a title='Enlarge' class='internal' href='#'><img height='11' width='15' alt='' src='$1/common/images/magnify-clip.png'/></a></div>Тэкст подпісу</div></div>",
	'wikieditor-toolbar-help-content-reference-description' => 'Зноска',
	'wikieditor-toolbar-help-content-reference-syntax' => 'Тэкст старонкі.&lt;ref name="test"&gt;[http://www.example.org Тэкст спасылкі], дадатковы тэкст.&lt;/ref&gt;',
	'wikieditor-toolbar-help-content-reference-result' => "Тэкст старонкі.<sup><a href='#'>[1]</a></sup>",
	'wikieditor-toolbar-help-content-rereference-description' => 'Паўторнае выкарыстаньне той жа зноскі',
	'wikieditor-toolbar-help-content-rereference-result' => "Тэкст старонкі.<sup><a href='#'>[1]</a></sup>",
	'wikieditor-toolbar-help-content-showreferences-description' => 'Паказваць зноскі',
	'wikieditor-toolbar-help-content-showreferences-result' => "<ol class='references'><li id='cite_note-test-0'><b><a title='' href='#'>^</a></b> <a rel='nofollow' title='http://www.example.org' class='external text' href='#'>Тэкст спасылкі</a>, дадатковы тэкст.</li></ol>",
	'wikieditor-toolbar-help-content-signaturetimestamp-description' => 'Подпіс і час',
	'wikieditor-toolbar-help-content-signaturetimestamp-result' => "<a href='#' title='{{#special:mypage}}'>Імя ўдзельніка</a> (<a href='#' title='{{#special:mytalk}}'>гутаркі</a>) 15:54, 10 чэрвеня 2009 (UTC)",
	'wikieditor-toolbar-help-content-signature-description' => 'Подпіс',
	'wikieditor-toolbar-help-content-signature-result' => "<a href='#' title='{{#special:mypage}}'>Імя ўдзельніка</a> (<a href='#' title='{{#special:mytalk}}'>гутаркі</a>)",
	'wikieditor-toolbar-help-content-indent-description' => 'Водступ',
	'wikieditor-toolbar-help-content-indent-syntax' => 'Звычайны тэкст<br />:Тэкст з водступам<br />::Тэкст з водступам',
	'wikieditor-toolbar-help-content-indent-result' => 'Звычайны тэкст<dl><dd>Тэкст з водступам<dl><dd>Тэкст з водступам</dd></dl></dd></dl>',
);

/** Bulgarian (български)
 * @author DCLXVI
 * @author McDutchie
 * @author Spiritia
 * @author Turin
 * @author Wizardist
 */
$messages['bg'] = array(
	'wikieditor' => 'Подобрен интерфейс за редактиране на уикитекст',
	'wikieditor-desc' => 'Предлага разширяем интерфейс за редактиране на уикитекст и множество модули с допълнителни функционалности',
	'wikieditor-wikitext-tab' => 'Уикитекст',
	'wikieditor-loading' => 'Зареждане',
	'wikieditor-preview-tab' => 'Предварителен преглед',
	'wikieditor-preview-changes-tab' => 'Промени',
	'wikieditor-preview-loading' => 'Зареждане...',
	'wikieditor-previewDialog-tab' => 'Предварителен преглед',
	'wikieditor-previewDialog-loading' => 'Зареждане...',
	'wikieditor-publish-preference' => 'Включване на публикуване стъпка по стъпка',
	'wikieditor-publish-button-publish' => 'Публикуване',
	'wikieditor-publish-button-cancel' => 'Отказване',
	'wikieditor-publish-dialog-title' => 'Публикуване в {{SITENAME}}',
	'wikieditor-publish-dialog-summary' => 'Резюме на редакцията (кратко описание на текущо направените промени):',
	'wikieditor-publish-dialog-minor' => 'Малка промяна',
	'wikieditor-publish-dialog-watch' => 'Наблюдаване на страницата',
	'wikieditor-publish-dialog-publish' => 'Публикуване',
	'wikieditor-publish-dialog-goback' => 'Връщане',
	'wikieditor-template-editor-preference' => 'Разрешено редактирането на уикишаблони чрез формуляр',
	'wikieditor-template-editor-dialog-title' => 'Редактиране на шаблона',
	'wikieditor-template-editor-dialog-submit' => 'Обновяване',
	'wikieditor-template-editor-dialog-cancel' => 'Отказване',
	'wikieditor-toc-preference' => 'Разрешена навигируема таблица на съдържанието',
	'wikieditor-toc-show' => 'Показване на съдържанието',
	'wikieditor-toc-hide' => 'Скриване на съдържанието',
	'wikieditor-toolbar' => 'Лента за редактиране',
	'wikieditor-toolbar-desc' => 'Лента за редактиране с подобрени възможности за използваемост',
	'wikieditor-toolbar-preference' => 'Включване на разширената лента с инструменти',
	'wikieditor-toolbar-dialogs-preference' => 'Включване на инструменти за вмъкване на препратки, таблици и други',
	'wikieditor-toolbar-hidesig' => 'Скриване на бутона за подпис за страници от основното именно пространство',
	'wikieditor-toolbar-loading' => 'Зареждане...',
	'wikieditor-toolbar-tool-bold' => 'Получер (удебелен) текст',
	'wikieditor-toolbar-tool-bold-example' => 'Получер текст',
	'wikieditor-toolbar-tool-italic' => 'Курсивен (наклонен) текст',
	'wikieditor-toolbar-tool-italic-example' => 'Курсивен текст',
	'wikieditor-toolbar-tool-ilink' => 'Вътрешна препратка',
	'wikieditor-toolbar-tool-ilink-example' => 'Заглавие на препратката',
	'wikieditor-toolbar-tool-xlink' => 'Външна препратка (не забравяйте http:// )',
	'wikieditor-toolbar-tool-xlink-example' => 'http://www.example.com Текст на препратката',
	'wikieditor-toolbar-tool-link' => 'Препратка',
	'wikieditor-toolbar-tool-link-title' => 'Вмъкване на препратка',
	'wikieditor-toolbar-tool-link-int' => 'Към уики-страница',
	'wikieditor-toolbar-tool-link-int-target' => 'Страница или URL за свързване:',
	'wikieditor-toolbar-tool-link-int-target-tooltip' => 'Име на страницата или URL',
	'wikieditor-toolbar-tool-link-int-text' => 'Показван текст:',
	'wikieditor-toolbar-tool-link-int-text-tooltip' => 'Въведете текста, който да се показва',
	'wikieditor-toolbar-tool-link-ext' => 'Към външна уеб-страница',
	'wikieditor-toolbar-tool-link-ext-target' => 'URL-адрес на препратката:',
	'wikieditor-toolbar-tool-link-ext-text' => 'Текст на препратката:',
	'wikieditor-toolbar-tool-link-insert' => 'Вмъкване на препратка',
	'wikieditor-toolbar-tool-link-cancel' => 'Отказване',
	'wikieditor-toolbar-tool-link-int-target-status-exists' => 'Страницата съществува',
	'wikieditor-toolbar-tool-link-int-target-status-notexists' => 'Страницата не съществува',
	'wikieditor-toolbar-tool-link-int-target-status-invalid' => 'Невалидно заглавие',
	'wikieditor-toolbar-tool-link-int-target-status-external' => 'Външна препратка',
	'wikieditor-toolbar-tool-link-int-target-status-loading' => 'Проверка дали страницата съществува...',
	'wikieditor-toolbar-tool-link-int-invalid' => 'Зададеното заглавие е недопустимо.',
	'wikieditor-toolbar-tool-link-lookslikeinternal' => 'URL-адресът, който сте задали, изглежда като връзка към друга уики-страница.
Искате ли препратката да бъде вътрешна?',
	'wikieditor-toolbar-tool-link-lookslikeinternal-int' => 'Вътрешна препратка',
	'wikieditor-toolbar-tool-link-lookslikeinternal-ext' => 'Външна препратка',
	'wikieditor-toolbar-tool-link-empty' => 'Не сте въвели адрес на препратката.',
	'wikieditor-toolbar-tool-file' => 'Вграден файл',
	'wikieditor-toolbar-tool-file-example' => 'Пример.jpg',
	'wikieditor-toolbar-tool-reference' => 'Източник (бележка под линия)',
	'wikieditor-toolbar-tool-reference-example' => 'Въведете тук текст на бележка под линия',
	'wikieditor-toolbar-tool-reference-cancel' => 'Отказване',
	'wikieditor-toolbar-tool-reference-title' => 'Вмъкване на източник (бележка под линия)',
	'wikieditor-toolbar-tool-reference-insert' => 'Вмъкване',
	'wikieditor-toolbar-tool-reference-text' => 'Текст на източника (бележката под линия)',
	'wikieditor-toolbar-tool-signature' => 'Подпис, дата и час',
	'wikieditor-toolbar-section-advanced' => 'Допълнително',
	'wikieditor-toolbar-tool-heading' => 'Заглавие',
	'wikieditor-toolbar-tool-heading-1' => 'Ниво 1',
	'wikieditor-toolbar-tool-heading-2' => 'Ниво 2',
	'wikieditor-toolbar-tool-heading-3' => 'Ниво 3',
	'wikieditor-toolbar-tool-heading-4' => 'Ниво 4',
	'wikieditor-toolbar-tool-heading-5' => 'Ниво 5',
	'wikieditor-toolbar-tool-heading-example' => 'Текст на заглавието',
	'wikieditor-toolbar-group-format' => 'Оформление',
	'wikieditor-toolbar-tool-ulist' => 'Точкуван списък',
	'wikieditor-toolbar-tool-ulist-example' => 'Елемент от точкуван списък',
	'wikieditor-toolbar-tool-olist' => 'Номериран списък',
	'wikieditor-toolbar-tool-olist-example' => 'Елемент от номериран списък',
	'wikieditor-toolbar-tool-indent' => 'Отстъп',
	'wikieditor-toolbar-tool-indent-example' => 'Ред с отстъп',
	'wikieditor-toolbar-tool-nowiki' => 'Пренебрегване на форматиращите команди',
	'wikieditor-toolbar-tool-nowiki-example' => 'Тук въведете текст',
	'wikieditor-toolbar-tool-redirect' => 'Пренасочваща страница',
	'wikieditor-toolbar-tool-redirect-example' => 'Целева страница',
	'wikieditor-toolbar-tool-big' => 'Голям',
	'wikieditor-toolbar-tool-big-example' => 'Голям текст',
	'wikieditor-toolbar-tool-small' => 'Малък',
	'wikieditor-toolbar-tool-small-example' => 'Малък текст',
	'wikieditor-toolbar-tool-superscript' => 'Горен индекс',
	'wikieditor-toolbar-tool-superscript-example' => 'Текст в горен индекс',
	'wikieditor-toolbar-tool-subscript' => 'Долен индекс',
	'wikieditor-toolbar-tool-subscript-example' => 'Текст в долен индекс',
	'wikieditor-toolbar-group-insert' => 'Вмъкване',
	'wikieditor-toolbar-tool-gallery' => 'Галерия',
	'wikieditor-toolbar-tool-gallery-example' => '$1:Example.jpg|Описание1
$1:Example.jpg|Описание2',
	'wikieditor-toolbar-tool-newline' => 'Нов ред',
	'wikieditor-toolbar-tool-table' => 'Таблица',
	'wikieditor-toolbar-tool-table-example-old' => '-
! колона 1
! колона 2
! колона 3
|-
| ред 1, клетка 1
| ред 1, клетка 2
| ред 1, клетка 3
|-
| ред 2, клетка 1
| ред 2, клетка 2
| ред 2, клетка 3',
	'wikieditor-toolbar-tool-table-example-cell-text' => 'Текст в клетката',
	'wikieditor-toolbar-tool-table-example-header' => 'Текст на заглавието',
	'wikieditor-toolbar-tool-table-title' => 'Вмъкване на таблица',
	'wikieditor-toolbar-tool-table-dimensions-rows' => 'Редове',
	'wikieditor-toolbar-tool-table-dimensions-columns' => 'Колони',
	'wikieditor-toolbar-tool-table-dimensions-header' => 'Добавяне на заглавен ред',
	'wikieditor-toolbar-tool-table-wikitable' => 'Изглед с рамки',
	'wikieditor-toolbar-tool-table-sortable' => 'Сортируема таблица',
	'wikieditor-toolbar-tool-table-example' => 'Пример',
	'wikieditor-toolbar-tool-table-preview' => 'Предварителен преглед',
	'wikieditor-toolbar-tool-table-insert' => 'Вмъкване',
	'wikieditor-toolbar-tool-table-cancel' => 'Отказване',
	'wikieditor-toolbar-tool-table-toomany' => 'През този диалогов режим не може да се вмъкне таблица с повече от $1 клетки.',
	'wikieditor-toolbar-tool-table-invalidnumber' => 'Не сте въвели валидно число за броя редове или стълбове.',
	'wikieditor-toolbar-tool-table-zero' => 'Не можете да вмъкнете таблица с нула на брой редове или стълбове.',
	'wikieditor-toolbar-tool-replace' => 'Търсене и замяна',
	'wikieditor-toolbar-tool-replace-title' => 'Търсене и замяна',
	'wikieditor-toolbar-tool-replace-search' => 'Търсене на:',
	'wikieditor-toolbar-tool-replace-replace' => 'Заместване с:',
	'wikieditor-toolbar-tool-replace-case' => 'Чувствителност към регистъра',
	'wikieditor-toolbar-tool-replace-regex' => 'Третиране на низа за търсене като регулярен израз',
	'wikieditor-toolbar-tool-replace-button-findnext' => 'Търсене на следващо',
	'wikieditor-toolbar-tool-replace-button-replaceall' => 'Замяна на всички',
	'wikieditor-toolbar-tool-replace-close' => 'Затваряне',
	'wikieditor-toolbar-tool-replace-nomatch' => 'Нямаше резултати, които да отговарят на вашето търсене.',
	'wikieditor-toolbar-tool-replace-success' => 'Направени са замени: $1.',
	'wikieditor-toolbar-tool-replace-emptysearch' => 'Не сте въвели низ за търсене.',
	'wikieditor-toolbar-tool-replace-invalidregex' => 'Въведеният от вас регулярен израз е невалиден: $1',
	'wikieditor-toolbar-section-characters' => 'Специални символи',
	'wikieditor-toolbar-characters-page-latin' => 'Латиница',
	'wikieditor-toolbar-characters-page-latinextended' => 'Латиница – разширена',
	'wikieditor-toolbar-characters-page-ipa' => 'IPA',
	'wikieditor-toolbar-characters-page-symbols' => 'Символи',
	'wikieditor-toolbar-characters-page-greek' => 'Гръцки',
	'wikieditor-toolbar-characters-page-cyrillic' => 'Кирилица',
	'wikieditor-toolbar-characters-page-arabic' => 'Арабски',
	'wikieditor-toolbar-characters-page-persian' => 'персийски',
	'wikieditor-toolbar-characters-page-hebrew' => 'Иврит',
	'wikieditor-toolbar-characters-page-bangla' => 'Бенгалски',
	'wikieditor-toolbar-characters-page-telugu' => 'Телугу',
	'wikieditor-toolbar-characters-page-sinhala' => 'Синхалски',
	'wikieditor-toolbar-characters-page-gujarati' => 'Гуджарати',
	'wikieditor-toolbar-characters-page-thai' => 'тайландски',
	'wikieditor-toolbar-characters-page-khmer' => 'кхмерски',
	'wikieditor-toolbar-section-help' => 'Помощ',
	'wikieditor-toolbar-help-heading-description' => 'Описание',
	'wikieditor-toolbar-help-heading-syntax' => 'В режим на редактиране',
	'wikieditor-toolbar-help-heading-result' => 'В режим на четене',
	'wikieditor-toolbar-help-page-format' => 'Форматиране',
	'wikieditor-toolbar-help-page-link' => 'Препратки',
	'wikieditor-toolbar-help-page-heading' => 'Заглавия',
	'wikieditor-toolbar-help-page-list' => 'Списъци',
	'wikieditor-toolbar-help-page-file' => 'Файлове',
	'wikieditor-toolbar-help-page-reference' => 'Източници',
	'wikieditor-toolbar-help-page-discussion' => 'Беседа',
	'wikieditor-toolbar-help-content-italic-description' => 'Курсив',
	'wikieditor-toolbar-help-content-italic-syntax' => "''Курсивен текст''",
	'wikieditor-toolbar-help-content-italic-result' => '<em>Курсивен текст</em>',
	'wikieditor-toolbar-help-content-bold-description' => 'Получер',
	'wikieditor-toolbar-help-content-bold-syntax' => "'''Получер текст'''",
	'wikieditor-toolbar-help-content-bold-result' => '<strong>Получер текст</strong>',
	'wikieditor-toolbar-help-content-bolditalic-description' => 'Получер курсив',
	'wikieditor-toolbar-help-content-bolditalic-syntax' => "'''''Получер курсив'''''",
	'wikieditor-toolbar-help-content-bolditalic-result' => '<strong><em>Получер курсив</em></strong>',
	'wikieditor-toolbar-help-content-ilink-description' => 'Вътрешна препратка',
	'wikieditor-toolbar-help-content-ilink-syntax' => '[[Заглавие на страницата|Текст на препратката]]<br />[[Заглавие на страницата]]',
	'wikieditor-toolbar-help-content-ilink-result' => "<a href='#'>Текст на препратката</a><br /><a href='#'>Заглавие на страницата</a>",
	'wikieditor-toolbar-help-content-xlink-description' => 'Външна препратка',
	'wikieditor-toolbar-help-content-xlink-syntax' => '[http://www.example.org Текст на препратката]<br />[http://www.example.org]<br />http://www.example.org',
	'wikieditor-toolbar-help-content-xlink-result' => "<a href='#' class='external'>Текст на препратката</a><br /><a href='#' class='external autonumber'>[1]</a><br /><a href='#' class='external'>http://www.example.org</a>",
	'wikieditor-toolbar-help-content-heading2-description' => 'Заглавие от второ ниво',
	'wikieditor-toolbar-help-content-heading2-syntax' => '== Текст на заглавието ==',
	'wikieditor-toolbar-help-content-heading2-result' => '<h2>Текст на заглавието</h2>',
	'wikieditor-toolbar-help-content-heading3-description' => 'Заглавие от трето ниво',
	'wikieditor-toolbar-help-content-heading3-syntax' => '=== Текст на заглавието ===',
	'wikieditor-toolbar-help-content-heading3-result' => '<h3>Текст на заглавието</h3>',
	'wikieditor-toolbar-help-content-heading4-description' => 'Заглавие от четвърто ниво',
	'wikieditor-toolbar-help-content-heading4-syntax' => '==== Текст на заглавието ====',
	'wikieditor-toolbar-help-content-heading4-result' => '<h4>Текст на заглавието</h4>',
	'wikieditor-toolbar-help-content-heading5-description' => 'Заглавие от пето ниво',
	'wikieditor-toolbar-help-content-heading5-syntax' => '===== Текст на заглавието =====',
	'wikieditor-toolbar-help-content-heading5-result' => '<h5>Текст на заглавието</h5>',
	'wikieditor-toolbar-help-content-ulist-description' => 'Точкуван списък',
	'wikieditor-toolbar-help-content-ulist-syntax' => '* Елемент от списъка<br />* Елемент от списъка',
	'wikieditor-toolbar-help-content-ulist-result' => '<ul><li>Елемент от списъка</li><li>Елемент от списъка</li></ul>',
	'wikieditor-toolbar-help-content-olist-description' => 'Номериран списък',
	'wikieditor-toolbar-help-content-olist-syntax' => '# Елемент от списъка<br /># Елемент от списъка',
	'wikieditor-toolbar-help-content-olist-result' => '<ol><li>Елемент от списъка</li><li>Елемент от списъка</li></ol>',
	'wikieditor-toolbar-help-content-file-description' => 'Вграден файл',
	'wikieditor-toolbar-help-content-file-syntax' => '[[$1:Example.png|thumb|Текст под картинката]]',
	'wikieditor-toolbar-help-content-file-result' => "<div style='width:104px;' class='thumbinner'><a title='Текст под картинката' class='image' href='#'><img height='50' width='100' border='0' class='thumbimage' src='$2/WikiEditor/modules/images/toolbar/example-image.png' alt=''/></a><div class='thumbcaption'><div class='magnify'><a title='Уголемяване' class='internal' href='#'><img height='11' width='15' alt='' src='$1/common/images/magnify-clip.png'/></a></div>Текст под картинката</div></div>",
	'wikieditor-toolbar-help-content-reference-description' => 'Източник',
	'wikieditor-toolbar-help-content-reference-syntax' => 'Текст на страницата.&lt;ref name="test"&gt;[http://www.example.org Текст на външната препратка], допълнителен текст.&lt;/ref&gt;',
	'wikieditor-toolbar-help-content-reference-result' => "Текст на страницата.<sup><a href='#'>[1]</a></sup>",
	'wikieditor-toolbar-help-content-rereference-description' => 'Множествена употреба на един и същ източник',
	'wikieditor-toolbar-help-content-rereference-result' => "Текст на страницата.<sup><a href='#'>[1]</a></sup>",
	'wikieditor-toolbar-help-content-showreferences-description' => 'Извеждане на източниците',
	'wikieditor-toolbar-help-content-showreferences-result' => "<ol class='references'><li id='cite_note-test-0'><b><a title='' href='#'>^</a></b> <a rel='nofollow' title='http://www.example.org' class='external text' href='#'>Текст на външната препратка</a>, допълнителен текст.</li></ol>",
	'wikieditor-toolbar-help-content-signaturetimestamp-description' => 'Подпис с дата и час',
	'wikieditor-toolbar-help-content-signaturetimestamp-result' => "<a href='#' title='{{#special:mypage}}'>Потребителско име</a> (<a href='#' title='{{#special:mytalk}}'>беседа</a>) 15:54, 10 юни 2009 (UTC)",
	'wikieditor-toolbar-help-content-signature-description' => 'Подпис',
	'wikieditor-toolbar-help-content-signature-result' => "<a href='#' title='{{#special:mypage}}'>Потребителско име</a> (<a href='#' title='{{#special:mytalk}}'>беседа</a>)",
	'wikieditor-toolbar-help-content-indent-description' => 'Отстъп',
	'wikieditor-toolbar-help-content-indent-syntax' => 'Текст без отстъп<br />:Текст с единичен отстъп<br />::Текст с двоен отстъп',
	'wikieditor-toolbar-help-content-indent-result' => 'Текст без отстъп<dl><dd>Текст с единичен отстъп<dl><dd>Текст с двоен отстъп</dd></dl></dd></dl>',
);

/** Banjar (Bahasa Banjar)
 * @author Ezagren
 * @author J Subhi
 */
$messages['bjn'] = array(
	'wikieditor-wikitext-tab' => 'NaskahWiki',
	'wikieditor-loading' => 'Mamuat',
	'wikieditor-preview-tab' => 'Tilik',
	'wikieditor-preview-changes-tab' => 'Parubahan',
	'wikieditor-preview-loading' => "Ma'unggah...",
	'wikieditor-previewDialog-tab' => 'Tilik',
	'wikieditor-publish-button-cancel' => 'Walangi',
	'wikieditor-publish-dialog-minor' => 'Babakan sapalih',
	'wikieditor-publish-dialog-watch' => 'Itihi tungkaran ini',
	'wikieditor-publish-dialog-goback' => 'Bulik',
	'wikieditor-template-editor-preference' => 'Aktipakan pambabakan babasis form matan citakan wiki',
	'wikieditor-template-editor-dialog-title' => 'Babak citakan',
	'wikieditor-template-editor-dialog-submit' => 'Hanyarakan',
	'wikieditor-template-editor-dialog-cancel' => 'Walangi',
	'wikieditor-templates-preference' => 'Aktipakan gawian manuhup citakan',
	'wikieditor-toc-preference' => 'Daptar isi nang hingkat dinapigasi',
	'wikieditor-toc-show' => 'Tampaiakan isi',
	'wikieditor-toc-hide' => 'Sungkupakan isi',
	'wikieditor-toolbar' => 'Kukuar pakakas mambabak',
	'wikieditor-toolbar-tool-bold' => 'Kandal',
	'wikieditor-toolbar-tool-bold-example' => 'Naskah kandal',
	'wikieditor-toolbar-tool-italic' => 'Hiring',
	'wikieditor-toolbar-tool-italic-example' => 'Naskah hiring',
	'wikieditor-toolbar-tool-ilink' => 'Tautan dalam',
	'wikieditor-toolbar-tool-ilink-example' => 'Judul tautan',
	'wikieditor-toolbar-tool-xlink' => 'Tautan luar (Ingatakan bamula wan http://)',
	'wikieditor-toolbar-tool-xlink-example' => 'http://www.cuntuh.com judul tautan',
	'wikieditor-toolbar-tool-link' => 'Tautan',
	'wikieditor-toolbar-tool-link-title' => 'Buati tautan',
	'wikieditor-toolbar-tool-link-int' => 'Ka sabuah tungkaran wiki',
	'wikieditor-toolbar-tool-link-int-target' => 'Tungkaran nang dituju atawa URL:',
	'wikieditor-toolbar-tool-link-int-target-tooltip' => 'Judul tungkaran atawa URL',
	'wikieditor-toolbar-tool-link-int-text' => 'Naskah gasan tampilan:',
	'wikieditor-toolbar-tool-link-int-text-tooltip' => 'Naskah gasan ditampilakan',
	'wikieditor-toolbar-tool-link-ext' => 'Ka sabuah tungkaran web luar',
	'wikieditor-toolbar-tool-link-ext-target' => 'URL tautan:',
	'wikieditor-toolbar-tool-link-ext-text' => 'Naskah tautan:',
	'wikieditor-toolbar-tool-link-insert' => 'Buati tautan',
	'wikieditor-toolbar-tool-link-cancel' => 'Walangi',
	'wikieditor-toolbar-tool-link-int-target-status-exists' => 'Tungkaran sudah ada',
	'wikieditor-toolbar-tool-link-int-target-status-notexists' => 'Tungkaran kadada',
	'wikieditor-toolbar-tool-link-int-target-status-invalid' => 'Judul kada sah',
	'wikieditor-toolbar-tool-link-int-target-status-external' => 'Tautan luar',
	'wikieditor-toolbar-tool-link-int-target-status-loading' => 'Tukui adakah tungkaran...',
	'wikieditor-toolbar-tool-link-int-invalid' => 'Judul nang Pian bari kada sah.',
	'wikieditor-toolbar-tool-link-lookslikeinternal' => 'URL nang Pian bariakan tampaknya marupakan tautan ka tungkaran wiki lain.
Apakah Pian handak maulahnya manjadi tautan internal?',
	'wikieditor-toolbar-tool-link-lookslikeinternal-int' => 'Tautan dalam',
	'wikieditor-toolbar-tool-link-lookslikeinternal-ext' => 'Tautan luar',
	'wikieditor-toolbar-tool-link-empty' => 'Pian kada mambuati apa pun ka tautan.',
	'wikieditor-toolbar-tool-file' => 'Maktub-akan barakas',
	'wikieditor-toolbar-tool-file-example' => 'Cuntuh.jpg',
	'wikieditor-toolbar-tool-reference' => 'Rujukan',
	'wikieditor-toolbar-tool-reference-example' => 'Buati naskah catatan batis di sia',
	'wikieditor-toolbar-tool-reference-cancel' => 'Walangi',
	'wikieditor-toolbar-tool-reference-title' => 'Masukakan rujukan',
	'wikieditor-toolbar-tool-reference-insert' => 'Masukakan',
	'wikieditor-toolbar-tool-reference-text' => 'Naskah rujukan',
	'wikieditor-toolbar-tool-signature' => 'Tandatangan wan waktu',
	'wikieditor-toolbar-section-advanced' => 'Lanjutan',
	'wikieditor-toolbar-tool-heading' => 'Judul',
	'wikieditor-toolbar-tool-heading-1' => 'Tingkat 1',
	'wikieditor-toolbar-tool-heading-2' => 'Tingkat 2',
	'wikieditor-toolbar-tool-heading-3' => 'Tingkat 3',
	'wikieditor-toolbar-tool-heading-4' => 'Tingkat 4',
	'wikieditor-toolbar-tool-heading-5' => 'Tingkat 5',
	'wikieditor-toolbar-tool-heading-example' => 'Naskah judul',
	'wikieditor-toolbar-group-format' => 'Bantuk',
	'wikieditor-toolbar-tool-ulist' => 'Daptar bapiluru',
	'wikieditor-toolbar-tool-ulist-example' => 'Baris isi',
	'wikieditor-toolbar-tool-olist' => 'Daptar banumur',
	'wikieditor-toolbar-tool-olist-example' => 'Baris isi',
	'wikieditor-toolbar-tool-indent' => 'Pilukan',
	'wikieditor-toolbar-tool-indent-example' => 'Baris tapiluk',
	'wikieditor-toolbar-tool-nowiki' => 'Kadada pambantukan wiki',
	'wikieditor-toolbar-tool-nowiki-example' => 'Masukakan naskah kada babantuk di sia',
	'wikieditor-toolbar-tool-redirect' => 'Paugahan',
	'wikieditor-toolbar-tool-redirect-example' => 'Ngaran tungkaran tujuan',
	'wikieditor-toolbar-tool-big' => 'Ganal',
	'wikieditor-toolbar-tool-big-example' => 'Naskah ganal',
	'wikieditor-toolbar-tool-small' => 'Halus',
	'wikieditor-toolbar-tool-small-example' => 'Naskah halus',
	'wikieditor-toolbar-tool-superscript' => 'Superscript',
	'wikieditor-toolbar-tool-superscript-example' => 'Naskah superscript',
	'wikieditor-toolbar-tool-subscript' => 'Subscript',
	'wikieditor-toolbar-tool-subscript-example' => 'Naskah subscript',
	'wikieditor-toolbar-group-insert' => 'Masukakan',
	'wikieditor-toolbar-tool-gallery' => 'Ruang gambar',
	'wikieditor-toolbar-tool-gallery-example' => '$1:Cuntuh.jpg|Judul1
$1:Cuntuh.jpg|Judul2',
	'wikieditor-toolbar-tool-newline' => 'Baris hanyar',
	'wikieditor-toolbar-tool-table' => 'Tabel',
	'wikieditor-toolbar-tool-table-example-old' => '	-
! judul hapat 1
! judul hapat 2
! judul hapat 3
|-
| baris 1, sel 1
| baris 1, sel 2
| baris 1, sel 3
|-
| baris 2, sel 1
| baris 2, sel 2
| baris 2, sel 3',
	'wikieditor-toolbar-tool-table-example-cell-text' => 'Naskah sel',
	'wikieditor-toolbar-tool-table-example-header' => 'Naskah judul',
	'wikieditor-toolbar-tool-table-title' => 'Buati tabel',
	'wikieditor-toolbar-tool-table-dimensions-rows' => 'Baris',
	'wikieditor-toolbar-tool-table-dimensions-columns' => 'Kolom',
	'wikieditor-toolbar-tool-table-dimensions-header' => 'Tambahakan baris',
	'wikieditor-toolbar-tool-table-wikitable' => 'Gaya awan babatasan',
	'wikieditor-toolbar-tool-table-sortable' => 'Ulah tabel baurutan',
	'wikieditor-toolbar-tool-table-example' => 'Cuntuh',
	'wikieditor-toolbar-tool-table-preview' => 'Tilik',
	'wikieditor-toolbar-tool-table-insert' => 'Masukakan',
	'wikieditor-toolbar-tool-table-cancel' => 'Walangi',
	'wikieditor-toolbar-tool-replace' => 'Gagai wan gantiakan',
	'wikieditor-toolbar-tool-replace-title' => 'Gagai wan gantiakan',
	'wikieditor-toolbar-tool-replace-search' => 'Gagai:',
	'wikieditor-toolbar-tool-replace-replace' => 'Ganti lawan:',
	'wikieditor-toolbar-tool-replace-case' => 'Rasukakan abjad ganal/halus',
	'wikieditor-toolbar-tool-replace-button-findnext' => 'Gagai dudinya',
	'wikieditor-toolbar-tool-replace-button-replaceall' => 'Ganti samunyaan',
	'wikieditor-toolbar-tool-replace-close' => 'Tuhup',
	'wikieditor-toolbar-tool-replace-nomatch' => 'Panggagaian Pian kadada ruhuinya.',
	'wikieditor-toolbar-tool-replace-emptysearch' => 'Pian kada mambuatakan apa pun gasan di panggagaian',
	'wikieditor-toolbar-section-characters' => 'Karakter istimiwa',
	'wikieditor-toolbar-characters-page-latin' => 'Latin',
	'wikieditor-toolbar-characters-page-ipa' => 'IPA',
	'wikieditor-toolbar-characters-page-symbols' => 'Simbul',
	'wikieditor-toolbar-characters-page-greek' => 'Yunani',
	'wikieditor-toolbar-characters-page-cyrillic' => 'Sirilik',
	'wikieditor-toolbar-characters-page-arabic' => 'Arab',
	'wikieditor-toolbar-characters-page-persian' => 'Parsia',
	'wikieditor-toolbar-characters-page-hebrew' => 'Ibrani',
	'wikieditor-toolbar-characters-page-bangla' => 'Bangla',
	'wikieditor-toolbar-characters-page-telugu' => 'Telugu',
	'wikieditor-toolbar-characters-page-sinhala' => 'Sinhala',
	'wikieditor-toolbar-characters-page-gujarati' => 'Gujarati',
	'wikieditor-toolbar-characters-page-thai' => 'Thai',
	'wikieditor-toolbar-characters-page-lao' => 'Lao',
	'wikieditor-toolbar-characters-page-khmer' => 'Khmer',
	'wikieditor-toolbar-section-help' => 'Patulung',
	'wikieditor-toolbar-help-heading-description' => 'Katarangan',
	'wikieditor-toolbar-help-heading-syntax' => 'Apa nang Pian katik',
	'wikieditor-toolbar-help-heading-result' => 'Apa nang Pian kulihi',
	'wikieditor-toolbar-help-page-format' => 'Pambantukan',
	'wikieditor-toolbar-help-page-link' => 'Tautan',
	'wikieditor-toolbar-help-page-heading' => 'Judul',
	'wikieditor-toolbar-help-page-list' => 'Daptar',
	'wikieditor-toolbar-help-page-file' => 'Barakas',
	'wikieditor-toolbar-help-page-reference' => 'Rujukan',
	'wikieditor-toolbar-help-page-discussion' => 'Pamandiran',
	'wikieditor-toolbar-help-content-italic-description' => 'Hiring',
	'wikieditor-toolbar-help-content-italic-syntax' => "''Naskah hiring''",
	'wikieditor-toolbar-help-content-italic-result' => '<em>Naskah hiring</em>',
	'wikieditor-toolbar-help-content-bold-description' => 'Kandal',
	'wikieditor-toolbar-help-content-bold-syntax' => "'''Naskah kandal'''",
	'wikieditor-toolbar-help-content-bold-result' => '<strong>Naskah kandal</strong>',
	'wikieditor-toolbar-help-content-bolditalic-description' => 'Kandal &amp; hiring',
	'wikieditor-toolbar-help-content-bolditalic-syntax' => "'''''Naskah kandal &amp; hiring'''''",
	'wikieditor-toolbar-help-content-bolditalic-result' => '<strong><em>Naskah kandal &amp; hiring</em></strong>',
	'wikieditor-toolbar-help-content-ilink-description' => 'Tautan dalam',
	'wikieditor-toolbar-help-content-ilink-syntax' => '[[Judul tungkaran|Judul tautan]]<br />[[Judul tungkaran]]',
	'wikieditor-toolbar-help-content-ilink-result' => "<a href='#'>Label tautan</a><br /><a href='#'>Judul tungkaran</a>",
	'wikieditor-toolbar-help-content-xlink-description' => 'Tautan luar',
	'wikieditor-toolbar-help-content-xlink-syntax' => '[http://www.cuntuh.org Label tautan]<br />[http://www.cuntuh.org]<br />http://www.cuntuh.org',
	'wikieditor-toolbar-help-content-xlink-result' => "<a href='#' class='external'>Label pranala</a><br /><a href='#' class='external autonumber'>[1]</a><br /><a href='#' class='external'>http://www.cuntuh.org</a>",
	'wikieditor-toolbar-help-content-heading2-description' => 'Judul tingkatan kadua',
	'wikieditor-toolbar-help-content-heading2-syntax' => '==Naskah judul==',
	'wikieditor-toolbar-help-content-heading2-result' => '<h2>Naskah judul</h2>',
	'wikieditor-toolbar-help-content-heading3-description' => 'Judul tingkatan katalu',
	'wikieditor-toolbar-help-content-heading3-syntax' => '===Naskah judul===',
	'wikieditor-toolbar-help-content-heading3-result' => '<h3>Naskah judul</h3>',
	'wikieditor-toolbar-help-content-heading4-description' => 'Judul tingkatan kaampat',
	'wikieditor-toolbar-help-content-heading4-syntax' => '==== Naskah judul ====',
	'wikieditor-toolbar-help-content-heading4-result' => '<h4>Naskah judul</h4>',
	'wikieditor-toolbar-help-content-heading5-description' => 'Judul tingkatan kalima',
	'wikieditor-toolbar-help-content-heading5-syntax' => '===== Naskah judul =====',
	'wikieditor-toolbar-help-content-heading5-result' => '<h5>Naskah judul</h5>',
	'wikieditor-toolbar-help-content-ulist-description' => 'Daptar bapiluru',
	'wikieditor-toolbar-help-content-ulist-syntax' => '* Isi daptar<br />* Isi daptar',
	'wikieditor-toolbar-help-content-ulist-result' => '<ul><li>Isi daptar</li><li>Isi daptar</li></ul>',
	'wikieditor-toolbar-help-content-olist-description' => 'Daptar banumur',
	'wikieditor-toolbar-help-content-olist-syntax' => '# Isi daptar<br /># Isi daptar',
	'wikieditor-toolbar-help-content-olist-result' => '<ol><li>Isi daptar</li><li>Isi daptar</li></ol>',
	'wikieditor-toolbar-help-content-file-description' => 'Maktub-akan barakas',
	'wikieditor-toolbar-help-content-file-syntax' => '[[$1:Cuntuh.png|thumb|Naskah judul gambar]]',
	'wikieditor-toolbar-help-content-reference-description' => 'Rujukan',
	'wikieditor-toolbar-help-content-reference-result' => "Naskah tungkaran.<sup><a href='#'>[1]</a></sup>",
	'wikieditor-toolbar-help-content-rereference-result' => "Naskah tungkaran.<sup><a href='#'>[1]</a></sup>",
	'wikieditor-toolbar-help-content-showreferences-description' => 'Manampaiakan rujukan',
	'wikieditor-toolbar-help-content-signaturetimestamp-description' => 'Tandatangan lawan waktu',
	'wikieditor-toolbar-help-content-signaturetimestamp-result' => "<a href='#' title='{{#special:mypage}}'>Ngaran-pamakai</a> (<a href='#' title='{{#special:mytalk}}'>pandir</a>) 15:54, 10 Juni 2009 (UTC)",
	'wikieditor-toolbar-help-content-signature-description' => 'Tandatangan',
	'wikieditor-toolbar-help-content-signature-result' => "<a href='#' title='{{#special:mypage}}'>Ngaran-pamakai</a> (<a href='#' title='{{#special:mytalk}}'>pandir</a>)",
	'wikieditor-toolbar-help-content-indent-description' => 'Inden',
);

/** Bengali (বাংলা)
 * @author Bellayet
 * @author Nasir8891
 * @author Wikitanvir
 */
$messages['bn'] = array(
	'wikieditor' => 'উন্নত উইকিটেক্সট সম্পাদনা ইন্টারফেস',
	'wikieditor-wikitext-tab' => 'উইকিটেক্সট',
	'wikieditor-loading' => 'আনা হচ্ছে',
	'wikieditor-preview-preference' => 'পাশাপাশি প্রাকদর্শন সক্রিয় করো',
	'wikieditor-preview-tab' => 'প্রাকদর্শন',
	'wikieditor-preview-changes-tab' => 'পরিবর্তনসমূহ',
	'wikieditor-preview-loading' => 'লোডিং...',
	'wikieditor-previewDialog-preference' => 'প্রিভিউ ডায়লগ সক্রিয়',
	'wikieditor-previewDialog-tab' => 'প্রাকদর্শন',
	'wikieditor-previewDialog-loading' => 'লোডিং...',
	'wikieditor-publish-preference' => 'ধাপে ধাপে প্রকাশ করা সক্রিয় করো',
	'wikieditor-publish-button-publish' => 'প্রকাশ করো',
	'wikieditor-publish-button-cancel' => 'বাতিল',
	'wikieditor-publish-dialog-title' => '{{SITENAME}} এ প্রকাশ করো',
	'wikieditor-publish-dialog-summary' => 'সম্পাদনা সারাংশ (আপনি কি পরিবর্তন করেছেন তা অল্প কথায় লিখুন):',
	'wikieditor-publish-dialog-minor' => 'অনুল্লেখ্য সম্পাদনা',
	'wikieditor-publish-dialog-watch' => 'এই পাতাটি নজরে রাখুন',
	'wikieditor-publish-dialog-publish' => 'প্রকাশ করো',
	'wikieditor-publish-dialog-goback' => 'ফিরে যাও',
	'wikieditor-template-editor-preference' => 'উইকি টেম্পলেটের ফরম ভিত্তিক সম্পাদনা সক্রিয় করো',
	'wikieditor-template-editor-dialog-title' => 'টেম্পলেট সম্পাদনা',
	'wikieditor-template-editor-dialog-submit' => 'হালনাগাদ',
	'wikieditor-template-editor-dialog-cancel' => 'বাতিল',
	'wikieditor-templates-preference' => 'টেম্পলেট ভাঁজ হওয়া সক্রিয়',
	'wikieditor-toc-preference' => 'দিকদর্শী সূচী সক্রিয় করো',
	'wikieditor-toc-show' => 'বিষয়বস্তু দেখাও',
	'wikieditor-toc-hide' => 'বিষয়বস্তু আড়াল করো',
	'wikieditor-toolbar' => 'সম্পাদনা টুলবার',
	'wikieditor-toolbar-desc' => 'বেশি ব্যবহারযোগ্য সম্পাদনা পাতার টুলবার',
	'wikieditor-toolbar-preference' => 'শক্তিশালী সম্পাদনা টুলবার সক্রিয় করো',
	'wikieditor-toolbar-dialogs-preference' => 'যোগকৃত লিংক, ছক এবং আরও কিছুর জন্য ডায়লগ সক্রিয় করো',
	'wikieditor-toolbar-loading' => 'লোডিং…',
	'wikieditor-toolbar-tool-bold' => 'গাঢ়',
	'wikieditor-toolbar-tool-bold-example' => 'গাঢ় লেখা',
	'wikieditor-toolbar-tool-italic' => 'ইটালিক',
	'wikieditor-toolbar-tool-italic-example' => 'ইটালিক লেখা',
	'wikieditor-toolbar-tool-ilink' => 'আভ্যন্তরীণ সংযোগ',
	'wikieditor-toolbar-tool-ilink-example' => 'সংযোগের শিরোনাম',
	'wikieditor-toolbar-tool-xlink' => 'বহিঃসংযোগ (মনে রাখবেন http:// উপসর্গ থাকবে)',
	'wikieditor-toolbar-tool-xlink-example' => 'http://www.example.com সংযোগের শিরোনাম',
	'wikieditor-toolbar-tool-link' => 'লিংক',
	'wikieditor-toolbar-tool-link-title' => 'লিংক যোগ করো',
	'wikieditor-toolbar-tool-link-int' => 'কোনো উইকি পাতায়',
	'wikieditor-toolbar-tool-link-int-target' => 'পাতার শিরোনাম:',
	'wikieditor-toolbar-tool-link-int-target-tooltip' => 'পাতার শিরোনাম অথবা ইউআরএল',
	'wikieditor-toolbar-tool-link-int-text' => 'লিংক লেখা:',
	'wikieditor-toolbar-tool-link-int-text-tooltip' => 'যে লেখা দৃশ্যমান হবে',
	'wikieditor-toolbar-tool-link-ext' => 'বহিঃস্থ কোনো ওয়েব পেইজে',
	'wikieditor-toolbar-tool-link-ext-target' => 'লিংক ইউআরএল:',
	'wikieditor-toolbar-tool-link-ext-text' => 'সংযোগ লেখ:',
	'wikieditor-toolbar-tool-link-insert' => 'লিংক যোগ করো',
	'wikieditor-toolbar-tool-link-cancel' => 'বাতিল',
	'wikieditor-toolbar-tool-link-int-target-status-exists' => 'পাতা রয়েছে',
	'wikieditor-toolbar-tool-link-int-target-status-notexists' => 'কোনো পাতা নাই',
	'wikieditor-toolbar-tool-link-int-target-status-invalid' => 'ভুল শিরোনাম',
	'wikieditor-toolbar-tool-link-int-target-status-external' => 'বহিঃসংযোগ',
	'wikieditor-toolbar-tool-link-int-target-status-loading' => 'পাতার উপস্থিতি যাচাই...',
	'wikieditor-toolbar-tool-link-int-invalid' => 'আপনার শিরোনামটি ঠিক নয়।',
	'wikieditor-toolbar-tool-link-lookslikeinternal' => 'যে ইউআরএলটিকে আপনি নির্দেশ করেছেন, তা অন্য একটি উইকির পাতাকে নির্দেশ করছে। আপনি কী এটিকে একটি আন্তসংযোগে পরিবর্তিত করতে চান?',
	'wikieditor-toolbar-tool-link-lookslikeinternal-int' => 'আন্তঃসংযোগ',
	'wikieditor-toolbar-tool-link-lookslikeinternal-ext' => 'বহিঃসংযোগ',
	'wikieditor-toolbar-tool-link-empty' => 'লিঙ্ক করা জন্য আপনি কোনো কিছু টাইপ করেননি।',
	'wikieditor-toolbar-tool-file' => 'এম্বেডেড ফাইল',
	'wikieditor-toolbar-tool-file-example' => 'Example.jpg',
	'wikieditor-toolbar-tool-file-title' => 'ফাইল সংযোজন',
	'wikieditor-toolbar-file-target' => 'ফাইলের নাম:',
	'wikieditor-toolbar-file-caption' => 'ক্যাপশন:',
	'wikieditor-toolbar-file-size' => 'আকার:',
	'wikieditor-toolbar-file-default' => '(ডিফল্ট)',
	'wikieditor-toolbar-file-format' => 'ফরম্যাট:',
	'wikieditor-toolbar-tool-file-insert' => 'যোগ করো',
	'wikieditor-toolbar-tool-file-cancel' => 'বাতিল',
	'wikieditor-toolbar-tool-reference' => 'তথ্যসূত্র',
	'wikieditor-toolbar-tool-reference-example' => 'পাদটীকার লেখা এখানে যোগ করো',
	'wikieditor-toolbar-tool-reference-cancel' => 'বাতিল',
	'wikieditor-toolbar-tool-reference-title' => 'তথ্যসূত্র যোগ',
	'wikieditor-toolbar-tool-reference-insert' => 'যোগ করো',
	'wikieditor-toolbar-tool-reference-text' => 'তথ্যসূত্র লেখা',
	'wikieditor-toolbar-tool-signature' => 'স্বাক্ষর এবং সময়',
	'wikieditor-toolbar-section-advanced' => 'উচ্চপর্যায়ের টুল',
	'wikieditor-toolbar-tool-heading' => 'শিরোনাম',
	'wikieditor-toolbar-tool-heading-1' => 'শিরোনাম ১',
	'wikieditor-toolbar-tool-heading-2' => 'শিরোনাম ২',
	'wikieditor-toolbar-tool-heading-3' => 'শিরোনাম ৩',
	'wikieditor-toolbar-tool-heading-4' => 'শিরোনাম ৪',
	'wikieditor-toolbar-tool-heading-5' => 'শিরোনাম ৫',
	'wikieditor-toolbar-tool-heading-example' => 'শিরোনাম লেখ',
	'wikieditor-toolbar-group-format' => 'ফরম্যাট',
	'wikieditor-toolbar-tool-ulist' => 'বুলেটকৃত তালিকা',
	'wikieditor-toolbar-tool-ulist-example' => 'বুলেটকৃত তালিকা আইটেম',
	'wikieditor-toolbar-tool-olist' => 'সংখ্যায়িত তালিকা',
	'wikieditor-toolbar-tool-olist-example' => 'সংখ্যায়িত তালিকা আইটেম',
	'wikieditor-toolbar-tool-indent' => 'প্রান্তিককরণ',
	'wikieditor-toolbar-tool-indent-example' => 'প্রান্তিককৃত লাইন',
	'wikieditor-toolbar-tool-nowiki' => 'উইকি ফরম্যাটিং উপেক্ষা করা হোক',
	'wikieditor-toolbar-tool-nowiki-example' => 'অ-ফরম্যাটকৃত টেক্সট এখানে লিখুন',
	'wikieditor-toolbar-tool-redirect' => 'পুনঃনির্দেশ',
	'wikieditor-toolbar-tool-redirect-example' => 'লক্ষ পাতার নাম',
	'wikieditor-toolbar-tool-big' => 'বড়',
	'wikieditor-toolbar-tool-big-example' => 'বড় লেখা',
	'wikieditor-toolbar-tool-small' => 'ছোট',
	'wikieditor-toolbar-tool-small-example' => 'ছোট লেখা',
	'wikieditor-toolbar-tool-superscript' => 'সুপারস্ক্রিপ্ট',
	'wikieditor-toolbar-tool-superscript-example' => 'সুপারস্ক্রিপ্ট লেখা',
	'wikieditor-toolbar-tool-subscript' => 'সাবস্ক্রিপ্ট',
	'wikieditor-toolbar-tool-subscript-example' => 'সাবস্ক্রিপ্ট লেখা',
	'wikieditor-toolbar-group-insert' => 'যোগ করো',
	'wikieditor-toolbar-tool-gallery' => 'ছবির গ্যালারী',
	'wikieditor-toolbar-tool-gallery-example' => '$1:Example.jpg|ক্যাপশন১
$1:Example.jpg|ক্যাপশন২',
	'wikieditor-toolbar-tool-newline' => 'নতুন লাইন',
	'wikieditor-toolbar-tool-table' => 'ছক',
	'wikieditor-toolbar-tool-table-example-old' => '-
! শিরোনাম ১
! শিরোনাম ২
! শিরোনাম ৩
|-
| সারি ১, ঘর ১
| সারি ১, ঘর ২
| সারি ১, ঘর ৩
|-
| সারি ২, ঘর ১
| সারি ২, ঘর ২
| সারি ২, ঘর ৩',
	'wikieditor-toolbar-tool-table-example-cell-text' => 'ঘরের লেখ',
	'wikieditor-toolbar-tool-table-example-header' => 'শিরোনামের লেখ',
	'wikieditor-toolbar-tool-table-title' => 'ছক যোগ করো',
	'wikieditor-toolbar-tool-table-dimensions-rows' => 'সারি',
	'wikieditor-toolbar-tool-table-dimensions-columns' => 'কলাম',
	'wikieditor-toolbar-tool-table-dimensions-header' => 'শিরোনাম সারি অন্তর্ভুক্ত করো',
	'wikieditor-toolbar-tool-table-wikitable' => 'সীমান্ত শৈলী',
	'wikieditor-toolbar-tool-table-sortable' => 'ছক ক্রমায়ন করো',
	'wikieditor-toolbar-tool-table-example' => 'ঘরের লেখ',
	'wikieditor-toolbar-tool-table-preview' => 'প্রাকদর্শন',
	'wikieditor-toolbar-tool-table-insert' => 'যোগ করো',
	'wikieditor-toolbar-tool-table-cancel' => 'বাতিল',
	'wikieditor-toolbar-tool-table-toomany' => 'এই ডায়লগ দ্বারা $1 ঘরের বেশি ছক যোগ করা সম্ভব নয়।',
	'wikieditor-toolbar-tool-table-invalidnumber' => 'আপনি সারি এবং কলামের জন্য ভুল সংখ্যা টাইপ করেছেন।',
	'wikieditor-toolbar-tool-table-zero' => 'আপনি ছকের সারি এবং কলামের সংখ্যা শূন্য দিতে পারবেন না।',
	'wikieditor-toolbar-tool-replace' => 'অনুসন্ধান এবং প্রতিস্থাপন',
	'wikieditor-toolbar-tool-replace-title' => 'অনুসন্ধান ও প্রতিস্থাপন',
	'wikieditor-toolbar-tool-replace-search' => 'অনুসন্ধান:',
	'wikieditor-toolbar-tool-replace-replace' => 'যা দিয়ে প্রতিস্থাপিত হবে:',
	'wikieditor-toolbar-tool-replace-case' => 'অক্ষরের ছাঁদ মেলানো',
	'wikieditor-toolbar-tool-replace-regex' => 'অনুসন্ধান বাক্যকে রেগুলার এক্সপ্রেশন হিসেবে গন্য করো',
	'wikieditor-toolbar-tool-replace-button-findnext' => 'পরবর্তী অনুসন্ধান',
	'wikieditor-toolbar-tool-replace-button-replace' => 'প্রতিস্থাপন',
	'wikieditor-toolbar-tool-replace-button-replaceall' => 'সব প্রতিস্থাপন',
	'wikieditor-toolbar-tool-replace-close' => 'বন্ধ',
	'wikieditor-toolbar-tool-replace-nomatch' => 'আপনার অনুসন্ধান কোনো কিছুর সাথে মিলেনি।',
	'wikieditor-toolbar-tool-replace-success' => '$1 টি প্রতিস্থাপন সম্পন্ন হয়েছে।',
	'wikieditor-toolbar-tool-replace-emptysearch' => 'আপনি অনুসন্ধানের জন্য কোনো কিছু দেননি।',
	'wikieditor-toolbar-tool-replace-invalidregex' => 'আপনার দেওয়া রেগুলার এক্সপ্রেশনটি ঠিক নয়: $1',
	'wikieditor-toolbar-section-characters' => 'বিশেষ বর্ণসমূহ',
	'wikieditor-toolbar-characters-page-latin' => 'লাতিন',
	'wikieditor-toolbar-characters-page-latinextended' => 'সম্প্রসারিত লাতিন',
	'wikieditor-toolbar-characters-page-ipa' => 'আইপিএ (IPA)',
	'wikieditor-toolbar-characters-page-symbols' => 'চিহ্নসমূহ',
	'wikieditor-toolbar-characters-page-greek' => 'গ্রিক',
	'wikieditor-toolbar-characters-page-cyrillic' => 'সিরিলিক',
	'wikieditor-toolbar-characters-page-arabic' => 'আরবীয়',
	'wikieditor-toolbar-characters-page-persian' => 'ফারসি',
	'wikieditor-toolbar-characters-page-hebrew' => 'হিব্রু',
	'wikieditor-toolbar-characters-page-bangla' => 'বাংলা',
	'wikieditor-toolbar-characters-page-tamil' => 'তামিল',
	'wikieditor-toolbar-characters-page-telugu' => 'তেলেগু',
	'wikieditor-toolbar-characters-page-sinhala' => 'শিংহলী',
	'wikieditor-toolbar-characters-page-gujarati' => 'গুজরাতি',
	'wikieditor-toolbar-characters-page-thai' => 'থাই',
	'wikieditor-toolbar-characters-page-lao' => 'লাও',
	'wikieditor-toolbar-characters-page-khmer' => 'খেমার',
	'wikieditor-toolbar-section-help' => 'সাহায্য',
	'wikieditor-toolbar-help-heading-description' => 'বর্ণনা',
	'wikieditor-toolbar-help-heading-syntax' => 'আপনি যা টাইপ করেছেন',
	'wikieditor-toolbar-help-heading-result' => 'আপনি যা দেখতে পাচ্ছেন',
	'wikieditor-toolbar-help-page-format' => 'বিন্যাসন',
	'wikieditor-toolbar-help-page-link' => 'সংযোগসমূহ',
	'wikieditor-toolbar-help-page-heading' => 'শিরোনামসমূহ',
	'wikieditor-toolbar-help-page-list' => 'তালিকাসমূহ',
	'wikieditor-toolbar-help-page-file' => 'ফাইলসমূহ',
	'wikieditor-toolbar-help-page-reference' => 'তথ্যসূত্র',
	'wikieditor-toolbar-help-page-discussion' => 'আলোচনা',
	'wikieditor-toolbar-help-content-italic-description' => 'ইটালিক',
	'wikieditor-toolbar-help-content-italic-syntax' => "''ইটালিক লেখা''",
	'wikieditor-toolbar-help-content-italic-result' => '<em>ইটালিক লেখা</em>',
	'wikieditor-toolbar-help-content-bold-description' => 'গাঢ়',
	'wikieditor-toolbar-help-content-bold-syntax' => "'''গাঢ় লেখা'''",
	'wikieditor-toolbar-help-content-bold-result' => '<strong>গাঢ় লেখা</strong>',
	'wikieditor-toolbar-help-content-bolditalic-description' => 'গাঢ় &amp; ইটালিক',
	'wikieditor-toolbar-help-content-bolditalic-syntax' => "'''''গাঢ় &amp; ইটালিক লেখা'''''",
	'wikieditor-toolbar-help-content-bolditalic-result' => '<strong><em>গাঢ় &amp; ইটালিক লেখা</em></strong>',
	'wikieditor-toolbar-help-content-ilink-description' => 'আভ্যন্তরীণ সংযোগ',
	'wikieditor-toolbar-help-content-ilink-syntax' => '[[পাতার শিরোনাম|সংযোগ লেবেল]]<br />[[পাতার শিরোনাম]]',
	'wikieditor-toolbar-help-content-ilink-result' => "<a href='#'>সংযোগ লেবেল</a><br /><a href='#'>পাতার শিরোনাম</a>",
	'wikieditor-toolbar-help-content-xlink-description' => 'বহিঃসংযোগ',
	'wikieditor-toolbar-help-content-xlink-syntax' => '[http://www.example.org সংযোগ লেবেল]<br />[http://www.example.org]<br />http://www.example.org',
	'wikieditor-toolbar-help-content-xlink-result' => "<a href='#' class='external'>সংযোগ লেবেল</a><br /><a href='#' class='external autonumber'>[1]</a><br /><a href='#' class='external'>http://www.example.org</a>",
	'wikieditor-toolbar-help-content-heading2-description' => '২য় পর্যায়ের শিরোনাম',
	'wikieditor-toolbar-help-content-heading2-syntax' => '== শিরোনাম লেখ ==',
	'wikieditor-toolbar-help-content-heading2-result' => '<h2> শিরোনাম লেখ </h2>',
	'wikieditor-toolbar-help-content-heading3-description' => '৩য় পর্যায়ের শিরোনাম',
	'wikieditor-toolbar-help-content-heading3-syntax' => '=== শিরোনাম লেখ ===',
	'wikieditor-toolbar-help-content-heading3-result' => '<h3> শিরোনাম লেখ </h3>',
	'wikieditor-toolbar-help-content-heading4-description' => '৪থ পর্যায়ের শিরোনাম',
	'wikieditor-toolbar-help-content-heading4-syntax' => '==== শিরোনাম লেখ ====',
	'wikieditor-toolbar-help-content-heading4-result' => '<h4> শিরোনাম লেখ </h4>',
	'wikieditor-toolbar-help-content-heading5-description' => '৫ম পর্যায়ের শিরোনাম',
	'wikieditor-toolbar-help-content-heading5-syntax' => '===== শিরোনাম লেখ =====',
	'wikieditor-toolbar-help-content-heading5-result' => '<h5> শিরোনাম লেখ </h5>',
	'wikieditor-toolbar-help-content-ulist-description' => 'বুলেটকৃত তালিকা',
	'wikieditor-toolbar-help-content-ulist-syntax' => '* তালিকা আইটেম<br />* তালিকা আইটেম',
	'wikieditor-toolbar-help-content-ulist-result' => '<ul><li>তালিকা আইটেম</li><li>তালিকা আইটেম</li></ul>',
	'wikieditor-toolbar-help-content-olist-description' => 'সংখ্যায়িত তালিকা',
	'wikieditor-toolbar-help-content-olist-syntax' => '# তালিকা আইটেম <br /># তালিকা আইটেম',
	'wikieditor-toolbar-help-content-olist-result' => '<ol><li>তালিকা আইটেম</li><li>তালিকা আইটেম</li></ol>',
	'wikieditor-toolbar-help-content-file-description' => 'এম্বেডেড ফাইল',
	'wikieditor-toolbar-help-content-file-syntax' => '[[$1:Example.png|thumb|ক্যাপশন লেখ]]',
	'wikieditor-toolbar-help-content-reference-description' => 'তথ্যসূত্র',
	'wikieditor-toolbar-help-content-reference-result' => "পাতার লেখা।<sup><a href='#'>[1]</a></sup>",
	'wikieditor-toolbar-help-content-rereference-description' => 'একই তথ্যসূত্রের একাধিক ব্যবহার',
	'wikieditor-toolbar-help-content-rereference-result' => "পাতার লেখ।<sup><a href='#'>[1]</a></sup>",
	'wikieditor-toolbar-help-content-showreferences-description' => 'তথ্যসূত্র প্রদর্শন করো',
	'wikieditor-toolbar-help-content-showreferences-result' => "<ol class='references'><li id='cite_note-test-0'><b><a title='' href='#'>^</a></b> <a rel='nofollow' title='http://www.example.org' class='external text' href='#'>সংযোগ লেখ</a>, বাড়তি লেখ।</li></ol>",
	'wikieditor-toolbar-help-content-signaturetimestamp-description' => 'সময় সহ স্বাক্ষর',
	'wikieditor-toolbar-help-content-signaturetimestamp-result' => "<a href='#' title='{{#special:mypage}}'>ব্যবহারকারী</a> (<a href='#' title='{{#special:mytalk}}'>আলাপ</a>) ১৫:৫৪, ১০ জুন ২০০৯ (UTC)",
	'wikieditor-toolbar-help-content-signature-description' => 'স্বাক্ষর',
	'wikieditor-toolbar-help-content-signature-result' => "<a href='#' title='{{#special:mypage}}'>ব্যবহারকারী</a> (<a href='#' title='{{#special:mytalk}}'>আলাপ</a>)",
	'wikieditor-toolbar-help-content-indent-description' => 'প্রান্তিককরণ',
	'wikieditor-toolbar-help-content-indent-syntax' => 'সাধারণ লেখ<br />:প্রান্তিককৃত লেখ<br />::প্রান্তিককৃত লেখ',
	'wikieditor-toolbar-help-content-indent-result' => 'সাধারণ লেখ<dl><dd>প্রান্তিককৃত লেখ<dl><dd>প্রান্তিককৃত লেখ</dd></dl></dd></dl>',
);

/** Tibetan (བོད་ཡིག)
 * @author Freeyak
 */
$messages['bo'] = array(
	'wikieditor-loading' => 'འདྲེན་པ།',
	'wikieditor-preview-tab' => 'སྔ་མ།',
	'wikieditor-publish-button-cancel' => 'རྩིས་མེད།',
	'wikieditor-toolbar-tool-replace-close' => 'སྒོ་རྒྱག་པ།',
	'wikieditor-toolbar-help-page-list' => 'རེའུ་མིག',
);

/** Bishnupria Manipuri (বিষ্ণুপ্রিয়া মণিপুরী)
 * @author Usingha
 */
$messages['bpy'] = array(
	'wikieditor' => 'উচ উইকিটেক্সট পাতানির ইন্টারফেসহান',
	'wikieditor-desc' => 'উইকি-টেক্ট পতানির কা সালকরানি একরব অসারে ইন্টারফেস বারো আরাকউ ফিচার দিতই মডিউল',
	'wikieditor-wikitext-tab' => 'উইকিটেক্সট',
	'wikieditor-loading' => 'আনরাঙ',
	'wikieditor-preview-preference' => 'কাদাহাত আকচা দেখাদে',
	'wikieditor-preview-tab' => 'আগচা',
	'wikieditor-preview-changes-tab' => 'বদালাসিতা',
	'wikieditor-preview-loading' => 'লোডিং…',
	'wikieditor-publish-preference' => 'কাকেয়ে-কাকেয়ে ফঙকরানিহান থা কর',
	'wikieditor-publish-button-publish' => 'ফঙকর',
	'wikieditor-publish-button-cancel' => 'বাতিল করেদে',
	'wikieditor-publish-dialog-title' => '{{SITENAME}} হাত ফঙকর',
	'wikieditor-publish-dialog-summary' => 'পতানির বারে (তি কিহান পতাসত্তা অহানর বারে বাট্টি করে মাতেদে):',
	'wikieditor-publish-dialog-minor' => 'হুরু-মুরু পতানিহান',
	'wikieditor-publish-dialog-watch' => 'পাতাএহান খিয়ালে থ',
	'wikieditor-publish-dialog-publish' => 'ফঙকর',
	'wikieditor-publish-dialog-goback' => 'আলথকে যাগা',
	'wikieditor-template-editor-preference' => 'উইকি টেম্পলেটের ফরমহানি পতানি থা কর',
	'wikieditor-template-editor-dialog-title' => 'টেম্পলেট পতা',
	'wikieditor-template-editor-dialog-submit' => 'আপডেট কর',
	'wikieditor-template-editor-dialog-cancel' => 'বাতিল করেদে',
	'wikieditor-templates-preference' => 'টেম্পলেট থিপ করানি থা কর',
	'wikieditor-toc-preference' => 'দিশাধরুনি সূচী ফঙকর',
	'wikieditor-toc-show' => 'বিষয়বস্তু দেখাদে',
	'wikieditor-toc-hide' => 'বিষয়বস্তু আরুম কর',
	'wikieditor-toolbar' => 'পতানির টুলবার',
	'wikieditor-toolbar-desc' => 'বপ ব্যবহারঅর পতানির পাতা অতার টুলবার',
	'wikieditor-toolbar-preference' => 'লিঙপা পতার টুলবার ফঙে থ',
	'wikieditor-toolbar-dialogs-preference' => 'তিলকরিসি লিংক, ছক বারো আরতার ডায়ালগ ফঙে থ',
	'wikieditor-toolbar-loading' => 'লোডিং…',
	'wikieditor-toolbar-tool-bold' => 'গাঢ়পা',
	'wikieditor-toolbar-tool-bold-example' => 'গাঢ়পা ইকা',
	'wikieditor-toolbar-tool-italic' => 'ইটালিক',
	'wikieditor-toolbar-tool-italic-example' => 'ইটালিক মেয়েক',
	'wikieditor-toolbar-tool-ilink' => 'ভিতরর মিলাপ',
	'wikieditor-toolbar-tool-ilink-example' => 'চিঙনাঙ মিলাপ',
	'wikieditor-toolbar-tool-xlink' => 'বারেদের মিলাপ (মুঙে http:// বারনি না পাহুরিস)',
	'wikieditor-toolbar-tool-xlink-example' => 'http://www.example.com চিঙনাঙ মিলাপ',
	'wikieditor-toolbar-tool-link' => 'লিংক',
	'wikieditor-toolbar-tool-link-title' => 'লিংক বরা',
	'wikieditor-toolbar-tool-link-int' => 'উইকি পাতা আহাত',
	'wikieditor-toolbar-tool-link-int-target' => 'পাতার চিঙনাঙ নাইলে URL:',
	'wikieditor-toolbar-tool-link-int-target-tooltip' => 'পাতার চিঙনাঙ নাইলে ইউআরএল',
	'wikieditor-toolbar-tool-link-int-text' => 'মুঙে থাকরানির মেয়েক:',
	'wikieditor-toolbar-tool-link-int-text-tooltip' => 'মুঙে থাকরানির মেয়েক:',
	'wikieditor-toolbar-tool-link-ext' => 'বারেদের ওয়েব পেইজহান',
	'wikieditor-toolbar-tool-link-ext-target' => 'লিংক ইউআরএল:',
	'wikieditor-toolbar-tool-link-ext-text' => 'মিলপার ইকা:',
	'wikieditor-toolbar-tool-link-insert' => 'লিংক বরা',
	'wikieditor-toolbar-tool-link-cancel' => 'বাতিল করেদে',
	'wikieditor-toolbar-tool-link-int-target-status-exists' => 'পাতা আসে',
	'wikieditor-toolbar-tool-link-int-target-status-notexists' => 'পাতাহান নেই',
	'wikieditor-toolbar-tool-link-int-target-status-invalid' => 'চিঙনাঙে লালুইসে',
	'wikieditor-toolbar-tool-link-int-target-status-external' => 'বারেদের লগে মিলাপ',
	'wikieditor-toolbar-tool-link-int-target-status-loading' => 'পাতাহান চারাঙ',
	'wikieditor-toolbar-tool-link-int-invalid' => 'তর চিঙনাঙহান চুম নাইসে',
	'wikieditor-toolbar-tool-link-lookslikeinternal' => 'যে ইউআরএলহান মাতানি অর অর আরাক উইকির পাতাহানরে বুঝার। ভিতরর মিরাপ সিলকরানি মনারাইথাঙ?',
	'wikieditor-toolbar-tool-link-lookslikeinternal-int' => 'ভিতরর মিলাপ',
	'wikieditor-toolbar-tool-link-lookslikeinternal-ext' => 'বারেদের লগে মিলাপ',
	'wikieditor-toolbar-tool-link-empty' => 'মিলাপ কারানির কা কিত্তাউ না ইকরলে।',
	'wikieditor-toolbar-tool-file' => 'এম্বেডেড ফাইলগ',
	'wikieditor-toolbar-tool-file-example' => 'Example.jpg',
	'wikieditor-toolbar-tool-reference' => 'রেফারেন্সহানি',
	'wikieditor-toolbar-tool-reference-example' => 'পাদটীকারকা ইকা এহাত বরা',
	'wikieditor-toolbar-tool-reference-cancel' => 'বাতিল করেদে',
	'wikieditor-toolbar-tool-reference-title' => 'তথ্যসূত্র বরা',
	'wikieditor-toolbar-tool-reference-insert' => 'বরা',
	'wikieditor-toolbar-tool-reference-text' => 'তথ্যসূত্রর ইকা',
	'wikieditor-toolbar-tool-signature' => 'স্বাক্ষর বারো ক্ষেন্তাম',
	'wikieditor-toolbar-section-advanced' => 'উচ্চতর',
	'wikieditor-toolbar-tool-heading' => 'চিঙনাঙ',
	'wikieditor-toolbar-tool-heading-1' => 'থাক ১',
	'wikieditor-toolbar-tool-heading-2' => 'থাক ২',
	'wikieditor-toolbar-tool-heading-3' => 'থাক ৩',
	'wikieditor-toolbar-tool-heading-4' => 'থাক ৪',
	'wikieditor-toolbar-tool-heading-5' => 'থাক ৫',
	'wikieditor-toolbar-tool-heading-example' => 'চিঙনাঙর খন্তাহানি',
	'wikieditor-toolbar-group-format' => 'ফরমেট',
	'wikieditor-toolbar-tool-ulist' => 'বুলেট করিসি পারেঙহানি',
	'wikieditor-toolbar-tool-ulist-example' => 'বুলেট করিসি মাথেলহানি',
	'wikieditor-toolbar-tool-olist' => 'সংখ্যাল ইকিসি পারেঙহানি',
	'wikieditor-toolbar-tool-olist-example' => 'বুলেট করিসি মাথেলহানি',
	'wikieditor-toolbar-tool-indent' => 'কাসাদেনা',
	'wikieditor-toolbar-tool-indent-example' => 'কাসা দিয়াসি পারেঙহানি',
	'wikieditor-toolbar-tool-nowiki' => 'উইকির পাজালানিহান লালুয়া যাগা',
	'wikieditor-toolbar-tool-nowiki-example' => 'ফরমেট নাকরিসি মেয়েক বরা',
	'wikieditor-toolbar-tool-redirect' => 'কুইকর',
	'wikieditor-toolbar-tool-redirect-example' => 'সই করিসি পাতার নাঙ',
	'wikieditor-toolbar-tool-big' => 'ডাঙর',
	'wikieditor-toolbar-tool-big-example' => 'ডাঙর মেয়েক',
	'wikieditor-toolbar-tool-small' => 'হুরু',
	'wikieditor-toolbar-tool-small-example' => 'হুরু মেয়েক',
	'wikieditor-toolbar-tool-superscript' => 'সুপারস্ক্রিপ্ট',
	'wikieditor-toolbar-tool-superscript-example' => 'সুপারস্ক্রিপ্ট মেয়েক',
	'wikieditor-toolbar-tool-subscript' => 'সাবস্ক্রিপ্ট',
	'wikieditor-toolbar-tool-subscript-example' => 'সাবস্ক্রিপ্ট মেয়েক',
	'wikieditor-toolbar-group-insert' => 'বরা',
	'wikieditor-toolbar-tool-gallery' => 'ফটকর গ্যালারী',
	'wikieditor-toolbar-tool-gallery-example' => '$1:Example.jpg|ক্যাপশন১
$1:Example.jpg|ক্যাপশন২',
	'wikieditor-toolbar-tool-newline' => 'নুৱা পারেঙ',
	'wikieditor-toolbar-tool-table' => 'ছক',
	'wikieditor-toolbar-tool-table-example-old' => '-
! চিঙনাঙ ১
! চিঙনাঙ ২
! চিঙনাঙ ৩
|-
| পারেঙ ১, সাঙ ১
| পারেঙ ১, সাঙ ২
| পারেঙ ১, সাঙ ৩
|-
| পারেঙ ২, সাঙ ১
| পারেঙ ২, সাঙ ২
| পারেঙ ২, সাঙ ৩',
	'wikieditor-toolbar-tool-table-example-cell-text' => 'সাঙর মেয়েক',
	'wikieditor-toolbar-tool-table-example-header' => 'চিঙনাঙর খন্তাহানি',
	'wikieditor-toolbar-tool-table-title' => 'ছক বরা',
	'wikieditor-toolbar-tool-table-dimensions-rows' => 'পারেঙ',
	'wikieditor-toolbar-tool-table-dimensions-columns' => 'দুরগি',
	'wikieditor-toolbar-tool-table-dimensions-header' => 'চিঙনাঙর পারেঙ বরা',
	'wikieditor-toolbar-tool-table-wikitable' => 'বদান হাজা',
	'wikieditor-toolbar-tool-table-sortable' => 'ছক পাজালা',
	'wikieditor-toolbar-tool-table-example' => 'উদাহরন',
	'wikieditor-toolbar-tool-table-preview' => 'আগচা',
	'wikieditor-toolbar-tool-table-insert' => 'বরা',
	'wikieditor-toolbar-tool-table-cancel' => 'বাতিল করেদে',
	'wikieditor-toolbar-tool-table-toomany' => 'এরে ডায়লগ এহান্ন $1 র বপ ছক বরানি নাকরব।',
	'wikieditor-toolbar-tool-table-invalidnumber' => 'তা পারেঙ বারো দুররকা দিয়াসত নম্বর চুম নাইসে।',
	'wikieditor-toolbar-tool-table-zero' => 'তি পারেঙ বারো দুরর কা শুন্য দেনা নুৱারবে।',
	'wikieditor-toolbar-tool-replace' => 'বিসারা বারো সিলকর',
	'wikieditor-toolbar-tool-replace-title' => 'বিসারা বারো সিলকর',
	'wikieditor-toolbar-tool-replace-search' => 'বিসারা:',
	'wikieditor-toolbar-tool-replace-replace' => 'যেহান্ন সিলকরানি ইতই:',
	'wikieditor-toolbar-tool-replace-case' => 'মেয়েকর অংতা মিলা',
	'wikieditor-toolbar-tool-replace-regex' => 'বিসারতেই খন্তাহানরে রেগুলার এক্সপ্রেশনহান বুলিয়া দর',
	'wikieditor-toolbar-tool-replace-button-findnext' => 'থাঙনাত বিসারা',
	'wikieditor-toolbar-tool-replace-button-replaceall' => 'হাবি বদালা',
	'wikieditor-toolbar-tool-replace-close' => 'ঝিপা',
	'wikieditor-toolbar-tool-replace-nomatch' => 'তি যেহান বিসারার অহান কিত্তার লগেউ না মিলের',
	'wikieditor-toolbar-tool-replace-success' => '$1 হান সিলকরানি ইল।',
	'wikieditor-toolbar-tool-replace-emptysearch' => 'মিলাপ কারানির কা কিত্তাউ না ইকরলে।',
	'wikieditor-toolbar-tool-replace-invalidregex' => 'তি দিয়াসত রেগুলার এক্সপ্রেশনহান চুম নাইসে: $1',
	'wikieditor-toolbar-section-characters' => 'বিশেষ আখরগি',
	'wikieditor-toolbar-characters-page-latin' => 'লাতিন',
	'wikieditor-toolbar-characters-page-latinextended' => 'সালকরিসি লাতিন',
	'wikieditor-toolbar-characters-page-ipa' => 'আইপিএ (IPA)',
	'wikieditor-toolbar-characters-page-symbols' => 'চিন্নতহানি',
	'wikieditor-toolbar-characters-page-greek' => 'গ্রিক',
	'wikieditor-toolbar-characters-page-cyrillic' => 'সিরিলিক',
	'wikieditor-toolbar-characters-page-arabic' => 'আরবীয়',
	'wikieditor-toolbar-characters-page-persian' => 'ফারসি',
	'wikieditor-toolbar-characters-page-hebrew' => 'হিব্রু',
	'wikieditor-toolbar-characters-page-bangla' => 'বাংলা',
	'wikieditor-toolbar-characters-page-telugu' => 'তেলেগু',
	'wikieditor-toolbar-characters-page-sinhala' => 'শিংহলী',
	'wikieditor-toolbar-characters-page-gujarati' => 'গুজরাতি',
	'wikieditor-toolbar-characters-page-thai' => 'থাই',
	'wikieditor-toolbar-characters-page-lao' => 'লাও',
	'wikieditor-toolbar-characters-page-khmer' => 'খেমার',
	'wikieditor-toolbar-section-help' => 'পাংলাক',
	'wikieditor-toolbar-help-heading-description' => 'বর্ণনা',
	'wikieditor-toolbar-help-heading-syntax' => 'তি যেহান টাইপ করিসত',
	'wikieditor-toolbar-help-heading-result' => 'তুমি যেহান দেখরাই',
	'wikieditor-toolbar-help-page-format' => 'পাজালানি',
	'wikieditor-toolbar-help-page-link' => 'লিংকহানি',
	'wikieditor-toolbar-help-page-heading' => 'চিঙনাঙহানি',
	'wikieditor-toolbar-help-page-list' => 'লাতঙগি',
	'wikieditor-toolbar-help-page-file' => 'ফাইলগি',
	'wikieditor-toolbar-help-page-reference' => 'রেফারেন্সহানি',
	'wikieditor-toolbar-help-page-discussion' => 'ৱারি',
	'wikieditor-toolbar-help-content-italic-description' => 'ইটালিক',
	'wikieditor-toolbar-help-content-italic-syntax' => "''ইটালিক মেয়েক\"",
	'wikieditor-toolbar-help-content-italic-result' => '<em>ইটালিক মেয়েক</em>',
	'wikieditor-toolbar-help-content-bold-description' => 'গাঢ়পা',
	'wikieditor-toolbar-help-content-bold-syntax' => "'''গাঢ়পা মেয়েক'''",
	'wikieditor-toolbar-help-content-bold-result' => '<strong>গাঢ়পা মেয়েক</strong>',
	'wikieditor-toolbar-help-content-bolditalic-description' => 'গাঢ়পা &amp; ইটালিক',
	'wikieditor-toolbar-help-content-bolditalic-syntax' => "'''''গাঢ়পা &amp; ইটালিক মেয়েক'''''",
	'wikieditor-toolbar-help-content-bolditalic-result' => '<strong><em>গাঢ়পা &amp; ইটালিক মেয়েক</em></strong>',
	'wikieditor-toolbar-help-content-ilink-description' => 'ভিতরর মিলাপ',
	'wikieditor-toolbar-help-content-ilink-syntax' => '[[পাতার চিঙনাঙ|মিলাপর লেবেল]]<br />[[পাতার চিঙনাঙ]]',
	'wikieditor-toolbar-help-content-ilink-result' => "<a href='#'>মিলাপ লেবেল</a><br /><a href='#'>পাতার চিঙনাঙ</a>",
	'wikieditor-toolbar-help-content-xlink-description' => 'বারেদের লগে মিলাপ',
	'wikieditor-toolbar-help-content-xlink-syntax' => '[http://www.example.org মিরাপ লেবেল]<br />[http://www.example.org]<br />http://www.example.org',
	'wikieditor-toolbar-help-content-xlink-result' => "<a href='#' class='external'>মিলাপ লেবেল</a><br /><a href='#' class='external autonumber'>[1]</a><br /><a href='#' class='external'>http://www.example.org</a>",
	'wikieditor-toolbar-help-content-heading2-description' => '২য় থাকর চিঙনাঙ',
	'wikieditor-toolbar-help-content-heading2-syntax' => '== চিঙনাঙর মেয়েক ==',
	'wikieditor-toolbar-help-content-heading2-result' => '<h2> চিঙনাঙর মেয়েক </h2>',
	'wikieditor-toolbar-help-content-heading3-description' => '৩য় থাকর চিঙনাঙ',
	'wikieditor-toolbar-help-content-heading3-syntax' => '== চিঙনাঙর মেয়েক ==',
	'wikieditor-toolbar-help-content-heading3-result' => '<h3> চিঙনাঙর মেয়েক </h3>',
	'wikieditor-toolbar-help-content-heading4-description' => '৪র্থ থাকর চিঙনাঙ',
	'wikieditor-toolbar-help-content-heading4-syntax' => '== চিঙনাঙর মেয়েক ==',
	'wikieditor-toolbar-help-content-heading4-result' => '<h4> চিঙনাঙর মেয়েক </h4>',
	'wikieditor-toolbar-help-content-heading5-description' => '৫ম থাকর চিঙনাঙ',
	'wikieditor-toolbar-help-content-heading5-syntax' => '===== চিঙনাঙর মেয়েক =====',
	'wikieditor-toolbar-help-content-heading5-result' => '<h5> চিঙনাঙর মেয়েক </h5>',
	'wikieditor-toolbar-help-content-ulist-description' => 'বুলেট করিসি পারেঙহানি',
	'wikieditor-toolbar-help-content-ulist-syntax' => '* পারেঙর মেথেল<br />* পারেঙর মেথেল',
	'wikieditor-toolbar-help-content-ulist-result' => '<ul><li>পারেঙর মেথেল</li><li>পারেঙর মেথেল</li></ul>',
	'wikieditor-toolbar-help-content-olist-description' => 'সংখ্যাল ইকিসি পারেঙহানি',
	'wikieditor-toolbar-help-content-olist-syntax' => '# পারেঙর মেথেল<br /># পারেঙর মেথেল',
	'wikieditor-toolbar-help-content-olist-result' => '<ol><li>পারেঙর মেথেল</li><li>পারেঙর মেথেল</li></ol>',
	'wikieditor-toolbar-help-content-file-description' => 'এম্বেডেড ফাইলগ',
	'wikieditor-toolbar-help-content-file-syntax' => '[[$1:Example.png|thumb|ক্যাপশনর মেয়ক]]',
	'wikieditor-toolbar-help-content-file-result' => "<div style='width:104px;' class='thumbinner'><a title='ক্যাপশর মেয়েক' class='image' href='#'><img height='50' width='100' border='0' class='thumbimage' src='$2/WikiEditor/modules/images/toolbar/example-image.png' alt=''/></a><div class='thumbcaption'><div class='magnify'><a title='ডাঙরকর' class='internal' href='#'><img height='11' width='15' alt='' src='$1/common/images/magnify-clip.png'/></a></div>ক্যাপশর মেয়েক</div></div>",
	'wikieditor-toolbar-help-content-reference-description' => 'রেফারেন্সহানি',
	'wikieditor-toolbar-help-content-reference-syntax' => 'পাতার ইকাহানি।&lt;ref name="test"&gt;[http://www.example.org মিলাপর মেয়েকগি], আরতাউ মেয়েক।&lt;/ref&gt;',
	'wikieditor-toolbar-help-content-reference-result' => "পাতার ইকা।<sup><a href='#'>[1]</a></sup>",
	'wikieditor-toolbar-help-content-rereference-description' => 'তথ্যসূত্র আকহানর কত্তমাউ ব্যবহার',
	'wikieditor-toolbar-help-content-rereference-result' => "পাতার ইকা।<sup><a href='#'>[1]</a></sup>",
	'wikieditor-toolbar-help-content-showreferences-description' => 'তথ্যসূত্র দেহাদে',
	'wikieditor-toolbar-help-content-showreferences-result' => "<ol class='references'><li id='cite_note-test-0'><b><a title='' href='#'>^</a></b> <a rel='nofollow' title='http://www.example.org' class='external text' href='#'>মিলাপর মেয়েকগি</a>, হেলপা মেয়েকগি।</li></ol>",
	'wikieditor-toolbar-help-content-signaturetimestamp-description' => 'স্বাক্ষরহান লগে খেন্তাম বরিয়া',
	'wikieditor-toolbar-help-content-signaturetimestamp-result' => "<a href='#' title='{{#special:mypage}}'>আতাকুরা</a> (<a href='#' title='{{#special:mytalk}}'>য়্যারী</a>) ১৫:৫৪, ১০ আগষ্ট ২০১০(UTC)",
	'wikieditor-toolbar-help-content-signature-description' => 'স্বাক্ষর',
	'wikieditor-toolbar-help-content-signature-result' => "<a href='#' title='{{#special:mypage}}'>আতাকুরা</a> (<a href='#' title='{{#special:mytalk}}'>য়্যারী</a>)",
	'wikieditor-toolbar-help-content-indent-description' => 'কাসাদেনা',
	'wikieditor-toolbar-help-content-indent-syntax' => 'চুমকার ইকা<br />:কাসাদিয়াসি ইকা<br />::কাসাদিয়াসি ইকা',
	'wikieditor-toolbar-help-content-indent-result' => 'চুমকার ইকা<dl><dd>কাসাদিয়াসি ইকা<dl><dd>কাসাদিয়াসি ইকা</dd></dl></dd></dl>',
);

/** Breton (brezhoneg)
 * @author Fohanno
 * @author Fulup
 * @author Gwendal
 * @author Y-M D
 */
$messages['br'] = array(
	'wikieditor' => 'Etrefas kemmañ wikitestenn klokaet',
	'wikieditor-desc' => "Poruchas a ra un etrefas kemmañ wikitestenn astennidik ha meur a arc'hwel all.",
	'wikieditor-wikitext-tab' => 'Wikitestenn',
	'wikieditor-loading' => 'O kargañ...',
	'wikieditor-preview-preference' => 'Gweredekaat ar rakweled skoaz-ouzh-skoaz',
	'wikieditor-preview-tab' => 'Rakwelet',
	'wikieditor-preview-changes-tab' => 'Kemmoù',
	'wikieditor-preview-loading' => 'O kargañ...',
	'wikieditor-previewDialog-preference' => 'Gweredekaat prenestr kendivizout ar rakweled',
	'wikieditor-previewDialog-tab' => 'Rakwelet',
	'wikieditor-previewDialog-loading' => 'O kargañ...',
	'wikieditor-publish-preference' => 'Gweredekaat an embann pazenn-ha-pazenn',
	'wikieditor-publish-button-publish' => 'Embann',
	'wikieditor-publish-button-cancel' => 'Nullañ',
	'wikieditor-publish-dialog-title' => 'Embann war {{SITENAME}}',
	'wikieditor-publish-dialog-summary' => "Aozañ an diverrañ (deskrivañ berr-ha-berr ar c'hemmoù degaset ganeoc'h) :",
	'wikieditor-publish-dialog-minor' => 'Kemmig dister',
	'wikieditor-publish-dialog-watch' => 'Evezhiañ ar bajenn-mañ',
	'wikieditor-publish-dialog-publish' => 'Embann',
	'wikieditor-publish-dialog-goback' => 'Distreiñ',
	'wikieditor-template-editor-preference' => "Gweredekaat ar c'hemmañ patromoù wiki diwar furmskridoù",
	'wikieditor-template-editor-dialog-title' => 'Kemmañ ar patrom',
	'wikieditor-template-editor-dialog-submit' => 'Hizivaat',
	'wikieditor-template-editor-dialog-cancel' => 'Nullañ',
	'wikieditor-templates-preference' => "Gweredekaat ar c'huzhat patromoù",
	'wikieditor-toc-preference' => 'Gweredekaat an daolenn verdeüs',
	'wikieditor-toc-show' => 'Diskouez an danvez',
	'wikieditor-toc-hide' => 'Kuzhat an danvez',
	'wikieditor-toolbar' => 'Barrenn ostilhoù kemmañ',
	'wikieditor-toolbar-desc' => "Barrenn ostilhoù kemmañ aesoc'h da implijout",
	'wikieditor-toolbar-preference' => 'Gweredekaat ar varrenn ostilhoù kemmañ gwellaet',
	'wikieditor-toolbar-dialogs-preference' => 'Gweredekaat ar boestoù divizout evit ouzhpennañ liammoù, taolennoù ha traoù all',
	'wikieditor-toolbar-hidesig' => 'Kuzhat ar bouton sinañ er pajennoù zo en esaouenn anv pennañ',
	'wikieditor-toolbar-loading' => 'O kargañ...',
	'wikieditor-toolbar-tool-bold' => 'Tev',
	'wikieditor-toolbar-tool-bold-example' => 'Testenn dev',
	'wikieditor-toolbar-tool-italic' => 'Italek',
	'wikieditor-toolbar-tool-italic-example' => 'Testenn italek',
	'wikieditor-toolbar-tool-ilink' => 'Liamm diabarzh',
	'wikieditor-toolbar-tool-ilink-example' => 'Anv al liamm',
	'wikieditor-toolbar-tool-xlink' => 'Liamm diavaez (arabat disoñjal ar rakger http:// )',
	'wikieditor-toolbar-tool-xlink-example' => 'http://www.example.com anv al liamm',
	'wikieditor-toolbar-tool-link' => 'Liamm',
	'wikieditor-toolbar-tool-link-title' => "Ensoc'hañ ul liamm",
	'wikieditor-toolbar-tool-link-int' => 'war-du ur bajenn wiki',
	'wikieditor-toolbar-tool-link-int-target' => 'Anv ar bajenn :',
	'wikieditor-toolbar-tool-link-int-target-tooltip' => 'Titl pe URL ar bajenn',
	'wikieditor-toolbar-tool-link-int-text' => 'Testenn al liamm :',
	'wikieditor-toolbar-tool-link-int-text-tooltip' => 'Ebarzhit an destenn da vezañ diskwelet',
	'wikieditor-toolbar-tool-link-ext' => 'War-du ur bajenn web diavaez',
	'wikieditor-toolbar-tool-link-ext-target' => 'URL al liamm :',
	'wikieditor-toolbar-tool-link-ext-text' => 'Testenn al liamm :',
	'wikieditor-toolbar-tool-link-insert' => "Ensoc'hañ al liamm",
	'wikieditor-toolbar-tool-link-cancel' => 'Nullañ',
	'wikieditor-toolbar-tool-link-int-target-status-exists' => "Bez' ez eus eus ar bajenn-mañ",
	'wikieditor-toolbar-tool-link-int-target-status-notexists' => "Ar bajenn-mañ n'eus ket anezhi",
	'wikieditor-toolbar-tool-link-int-target-status-invalid' => 'Titl direizh',
	'wikieditor-toolbar-tool-link-int-target-status-external' => 'Liamm diavaez',
	'wikieditor-toolbar-tool-link-int-target-status-loading' => 'O wiriañ hag-eñ ez eus eus ar bajenn...',
	'wikieditor-toolbar-tool-link-int-invalid' => "Kamm eo an titl hoc'h eus merket.",
	'wikieditor-toolbar-tool-link-lookslikeinternal' => "Seblantout kas ul liamm davet ur bajenn all eus ar wiki a ra an URL lakaet ganeoc'h.
Hag ul liamm diabarzh eo a fell deoc'h lakaat?",
	'wikieditor-toolbar-tool-link-lookslikeinternal-int' => 'Liamm diabarzh',
	'wikieditor-toolbar-tool-link-lookslikeinternal-ext' => 'Liamm diavaez',
	'wikieditor-toolbar-tool-link-empty' => "N'hoc'h eus merket netra a c'haller sevel liammoù outañ.",
	'wikieditor-toolbar-tool-file' => 'Restr enframmet',
	'wikieditor-toolbar-tool-file-example' => 'Skouer.jpg',
	'wikieditor-toolbar-tool-file-title' => "Ensoc'hañ ur restr",
	'wikieditor-toolbar-file-target' => 'Anv ar restr :',
	'wikieditor-toolbar-file-caption' => "Alc'hwez :",
	'wikieditor-toolbar-file-size' => 'Ment :',
	'wikieditor-toolbar-file-default' => '(dre ziouer)',
	'wikieditor-toolbar-file-format' => 'Furmad :',
	'wikieditor-toolbar-file-format-none' => 'hini ebet',
	'wikieditor-toolbar-tool-file-insert' => "Ensoc'hañ",
	'wikieditor-toolbar-tool-file-cancel' => 'Nullañ',
	'wikieditor-toolbar-tool-reference' => 'Daveenn',
	'wikieditor-toolbar-tool-reference-example' => "Ensoc'hañ amañ testenn notenn traoñ pajenn",
	'wikieditor-toolbar-tool-reference-cancel' => 'Nullañ',
	'wikieditor-toolbar-tool-reference-title' => "Ensoc'hañ un daveenn",
	'wikieditor-toolbar-tool-reference-insert' => "Ensoc'hañ",
	'wikieditor-toolbar-tool-reference-text' => 'Testenn an daveenn',
	'wikieditor-toolbar-tool-signature' => 'Sinadur ha deiziad',
	'wikieditor-toolbar-section-advanced' => 'Araokaet',
	'wikieditor-toolbar-tool-heading' => 'Titl',
	'wikieditor-toolbar-tool-heading-1' => 'Live 1',
	'wikieditor-toolbar-tool-heading-2' => 'Live 2',
	'wikieditor-toolbar-tool-heading-3' => 'Live 3',
	'wikieditor-toolbar-tool-heading-4' => 'Live 4',
	'wikieditor-toolbar-tool-heading-5' => 'Live 5',
	'wikieditor-toolbar-tool-heading-example' => 'Testenn an titl',
	'wikieditor-toolbar-group-format' => 'Furmad',
	'wikieditor-toolbar-tool-ulist' => 'Roll padelliget',
	'wikieditor-toolbar-tool-ulist-example' => 'Elfenn eus ar roll padelliget',
	'wikieditor-toolbar-tool-olist' => 'Roll niverennet',
	'wikieditor-toolbar-tool-olist-example' => 'Elfenn eus ar roll niverennet',
	'wikieditor-toolbar-tool-indent' => 'Endantadur',
	'wikieditor-toolbar-tool-indent-example' => 'Linenn endantet',
	'wikieditor-toolbar-tool-nowiki' => 'Hep ereadur wiki',
	'wikieditor-toolbar-tool-nowiki-example' => "Ensoc'hañ amañ un destenn difurmad",
	'wikieditor-toolbar-tool-redirect' => 'Adkas',
	'wikieditor-toolbar-tool-redirect-example' => 'Anv ar bajenn da dizhout',
	'wikieditor-toolbar-tool-big' => 'Bras',
	'wikieditor-toolbar-tool-big-example' => 'Mell testenn',
	'wikieditor-toolbar-tool-small' => 'Bihan',
	'wikieditor-toolbar-tool-small-example' => 'Testennig',
	'wikieditor-toolbar-tool-superscript' => 'Gallouter',
	'wikieditor-toolbar-tool-superscript-example' => 'Testenn e gallouter',
	'wikieditor-toolbar-tool-subscript' => 'Feur',
	'wikieditor-toolbar-tool-subscript-example' => 'Testenn e feur',
	'wikieditor-toolbar-group-insert' => "Ensoc'hañ",
	'wikieditor-toolbar-tool-gallery' => 'Skeudennaoueg',
	'wikieditor-toolbar-tool-gallery-example' => '$1:Skouer.jpg|Deskrivadur1
$1:Skouer.jpg|Deskrivadur2',
	'wikieditor-toolbar-tool-newline' => 'Linenn nevez',
	'wikieditor-toolbar-tool-table' => 'Taolenn',
	'wikieditor-toolbar-tool-table-example-old' => '-
! talbenn 1
! talbenn 2
! talbenn 3
|-
| linenn 1, kellig 1
| linenn 1, kellig 2
| linenn 1, kellig 3
|-
| linenn 2, kellig 1
| linenn 2, kellig 2
| linenn 2, kellig 3',
	'wikieditor-toolbar-tool-table-example-cell-text' => 'Tenstenn er gellig',
	'wikieditor-toolbar-tool-table-example-header' => 'Testenn an talbenn',
	'wikieditor-toolbar-tool-table-title' => "Ensoc'hañ un daolenn",
	'wikieditor-toolbar-tool-table-dimensions-rows' => 'Linennoù',
	'wikieditor-toolbar-tool-table-dimensions-columns' => 'Bannoù',
	'wikieditor-toolbar-tool-table-dimensions-header' => 'Lakaat  al linenn dalbenn e-barzh',
	'wikieditor-toolbar-tool-table-wikitable' => 'Stil gant bevennoù',
	'wikieditor-toolbar-tool-table-sortable' => 'Kinnig urzhiañ roadennoù an daolenn',
	'wikieditor-toolbar-tool-table-example' => 'Testenn er gellig',
	'wikieditor-toolbar-tool-table-preview' => 'Rakwelet',
	'wikieditor-toolbar-tool-table-insert' => "Ensoc'hañ",
	'wikieditor-toolbar-tool-table-cancel' => 'Nullañ',
	'wikieditor-toolbar-tool-table-toomany' => "N'haller ket ensoc'hañ un daolenn enni muioc'h eget $1 kellig gant an ostilh-mañ.",
	'wikieditor-toolbar-tool-table-invalidnumber' => "Merket hoc'h eus un niver a linennoù pe a vannoù direizh.",
	'wikieditor-toolbar-tool-table-zero' => "N'hallit ket ensoc'hañ un daolenn hep bann na linenn.",
	'wikieditor-toolbar-tool-replace' => "Klask hag erlec'hiañ",
	'wikieditor-toolbar-tool-replace-title' => "Klask hag erlec'hiañ",
	'wikieditor-toolbar-tool-replace-search' => 'Klask :',
	'wikieditor-toolbar-tool-replace-replace' => "Erlec'hiañ gant :",
	'wikieditor-toolbar-tool-replace-case' => "Diforc'hañ Pennlizherennoù/Lizherennoù bihan",
	'wikieditor-toolbar-tool-replace-regex' => 'Sellet ouzh ar chadennad klask evel ouzh ur jedad reoliek',
	'wikieditor-toolbar-tool-replace-button-findnext' => 'Kavout an hini da-heul',
	'wikieditor-toolbar-tool-replace-button-replace' => "Erlec'hiañ",
	'wikieditor-toolbar-tool-replace-button-replaceall' => "Erlec'hiañ pep tra",
	'wikieditor-toolbar-tool-replace-close' => 'Serriñ',
	'wikieditor-toolbar-tool-replace-nomatch' => "N'eus bet kavet netra o klotañ gant ar pezh a glaskit.",
	'wikieditor-toolbar-tool-replace-success' => "$1 erlec'hiadenn graet",
	'wikieditor-toolbar-tool-replace-emptysearch' => "N'hoc'h eus ebarzhet netra da glask.",
	'wikieditor-toolbar-tool-replace-invalidregex' => "Direizh eo ar jedad reoliek hoc'h eus lakaet : $1",
	'wikieditor-toolbar-section-characters' => 'Arouezennoù dibar',
	'wikieditor-toolbar-characters-page-latin' => 'Latin',
	'wikieditor-toolbar-characters-page-latinextended' => 'Latin astennet',
	'wikieditor-toolbar-characters-page-ipa' => 'LFE (IPA)',
	'wikieditor-toolbar-characters-page-symbols' => 'Arouezennoù',
	'wikieditor-toolbar-characters-page-greek' => 'Gresianek',
	'wikieditor-toolbar-characters-page-cyrillic' => 'Kirillek',
	'wikieditor-toolbar-characters-page-arabic' => 'Arabeg',
	'wikieditor-toolbar-characters-page-arabicextended' => 'Arabeg astennet',
	'wikieditor-toolbar-characters-page-persian' => 'Perseg',
	'wikieditor-toolbar-characters-page-hebrew' => 'Hebraek',
	'wikieditor-toolbar-characters-page-bangla' => 'Banglaek',
	'wikieditor-toolbar-characters-page-tamil' => 'Tamileg',
	'wikieditor-toolbar-characters-page-telugu' => 'Telougou',
	'wikieditor-toolbar-characters-page-sinhala' => 'Sinhala',
	'wikieditor-toolbar-characters-page-gujarati' => 'Gujarati',
	'wikieditor-toolbar-characters-page-devanagari' => 'Devanagari',
	'wikieditor-toolbar-characters-page-thai' => 'Thai',
	'wikieditor-toolbar-characters-page-lao' => 'Laoseg',
	'wikieditor-toolbar-characters-page-khmer' => 'Khmer',
	'wikieditor-toolbar-section-help' => 'Skoazell',
	'wikieditor-toolbar-help-heading-description' => 'Deskrivadur',
	'wikieditor-toolbar-help-heading-syntax' => 'Ar pezh a skrivit',
	'wikieditor-toolbar-help-heading-result' => "An disoc'h war-lerc'h",
	'wikieditor-toolbar-help-page-format' => 'Furmadiñ',
	'wikieditor-toolbar-help-page-link' => 'Liammoù',
	'wikieditor-toolbar-help-page-heading' => 'Titloù',
	'wikieditor-toolbar-help-page-list' => 'Rolloù',
	'wikieditor-toolbar-help-page-file' => 'Restroù',
	'wikieditor-toolbar-help-page-reference' => 'Daveennoù',
	'wikieditor-toolbar-help-page-discussion' => 'Kaozeadenn',
	'wikieditor-toolbar-help-content-italic-description' => 'Italek',
	'wikieditor-toolbar-help-content-italic-syntax' => "''Testenn italek''",
	'wikieditor-toolbar-help-content-italic-result' => '<em>Testenn italek</em>',
	'wikieditor-toolbar-help-content-bold-description' => 'Tev',
	'wikieditor-toolbar-help-content-bold-syntax' => "'''Testenn dev'''",
	'wikieditor-toolbar-help-content-bold-result' => '<strong>Testenn dev</strong>',
	'wikieditor-toolbar-help-content-bolditalic-description' => 'Tev &amp; italek',
	'wikieditor-toolbar-help-content-bolditalic-syntax' => "'''''Testenn dev hag italek'''''",
	'wikieditor-toolbar-help-content-bolditalic-result' => '<strong><em>Testenn dev &amp; italek</em></strong>',
	'wikieditor-toolbar-help-content-ilink-description' => 'Liamm diabarzh',
	'wikieditor-toolbar-help-content-ilink-syntax' => '[[Titl ar bajenn|Testenn al liamm]]<br />[[Titl ar bajenn]]',
	'wikieditor-toolbar-help-content-ilink-result' => "<a href='#'>Testenn al liamm</a><br /><a href='#'>Titl ar bajenn</a>",
	'wikieditor-toolbar-help-content-xlink-description' => 'Liamm diavaez',
	'wikieditor-toolbar-help-content-xlink-syntax' => '[http://www.example.org Testenn al liamm]<br />[http://www.example.org]<br />http://www.example.org',
	'wikieditor-toolbar-help-content-xlink-result' => "<a href='#' class='external'>Testenn al liamm</a><br /><a href='#' class='external autonumber'>[1]</a><br /><a href='#' class='external'>http://www.example.org</a>",
	'wikieditor-toolbar-help-content-heading2-description' => 'Titl a eil live',
	'wikieditor-toolbar-help-content-heading2-syntax' => '== Testenn an titl ==',
	'wikieditor-toolbar-help-content-heading2-result' => '<h2>Testenn an titl</h2>',
	'wikieditor-toolbar-help-content-heading3-description' => 'Titl a drede live',
	'wikieditor-toolbar-help-content-heading3-syntax' => '=== Testenn an titl ===',
	'wikieditor-toolbar-help-content-heading3-result' => '<h3>Testenn an titl</h3>',
	'wikieditor-toolbar-help-content-heading4-description' => 'Titl a bevare live',
	'wikieditor-toolbar-help-content-heading4-syntax' => '==== Testenn an titl ====',
	'wikieditor-toolbar-help-content-heading4-result' => '<h4>Testenn an titl</h4>',
	'wikieditor-toolbar-help-content-heading5-description' => 'Titl a bempvet live',
	'wikieditor-toolbar-help-content-heading5-syntax' => '===== Testenn an titl =====',
	'wikieditor-toolbar-help-content-heading5-result' => '<h5>Testenn an titl</h5>',
	'wikieditor-toolbar-help-content-ulist-description' => 'Roll padelliget',
	'wikieditor-toolbar-help-content-ulist-syntax' => '* Elfenn eus ar roll<br />* Elfenn eus ar roll',
	'wikieditor-toolbar-help-content-ulist-result' => '<ul><li>Elfenn eus ar roll</li><li>Elfenn eus ar roll</li></ul>',
	'wikieditor-toolbar-help-content-olist-description' => 'Roll niverennet',
	'wikieditor-toolbar-help-content-olist-syntax' => '# Elfenn eus ar roll<br /># Elfenn eus ar roll',
	'wikieditor-toolbar-help-content-olist-result' => '<ol><li>Elfenn eus ar roll</li><li>Elfenn eus ar roll</li></ol>',
	'wikieditor-toolbar-help-content-file-description' => 'Restr enframmet',
	'wikieditor-toolbar-help-content-file-syntax' => "[[$1:Example.png|thumb|Alc'hwez ar skeudenn]]",
	'wikieditor-toolbar-help-content-file-result' => "<div style='width:104px;' class='thumbinner'><a title='Testenn an alc'hwez' class='image' href='#'><img height='50' width='100' border='0' class='thumbimage' src='$2/WikiEditor/modules/images/toolbar/example-image.png' alt=''/></a><div class='thumbcaption'><div class='magnify'><a title='Brasaat' class='internal' href='#'><img height='11' width='15' alt='' src='$1/common/images/magnify-clip.png'/></a></div>Testenn an alc'hwez</div></div>",
	'wikieditor-toolbar-help-content-reference-description' => 'Daveenn',
	'wikieditor-toolbar-help-content-reference-syntax' => 'Testenn ar bajenn.&lt;ref name="test"&gt;[http://www.example.org testenn al liamm], testenn ouzhpenn.&lt;/ref&gt;',
	'wikieditor-toolbar-help-content-reference-result' => "Testenn ar bajenn.<sup><a href='#'>[1]</a></sup>",
	'wikieditor-toolbar-help-content-rereference-description' => 'Adimplij eus an hevelep daveenn',
	'wikieditor-toolbar-help-content-rereference-result' => "Testenn ar bajenn.<sup><a href='#'>[1]</a></sup>",
	'wikieditor-toolbar-help-content-showreferences-description' => 'Diskwel an daveennoù',
	'wikieditor-toolbar-help-content-showreferences-result' => "<ol class='references'><li id='cite_note-test-0'><b><a title='' href='#'>^</a></b> <a rel='nofollow' title='http://www.example.org' class='external text' href='#'>Anv al liamm</a>, testenn ouzhpenn.</li></ol>",
	'wikieditor-toolbar-help-content-signaturetimestamp-description' => 'Sinadur gant an deiziad',
	'wikieditor-toolbar-help-content-signaturetimestamp-result' => "<a href='#' title='{{#special:mypage}}'>Anv implijer</a> (<a href='#' title='{{#special:mytalk}}'>kaozeal</a>) 15:54, 10 Mezheven 2009 (UTC)",
	'wikieditor-toolbar-help-content-signature-description' => 'Sinadur',
	'wikieditor-toolbar-help-content-signature-result' => "<a href='#' title='{{#special:mypage}}'>Anv implijer</a> (<a href='#' title='{{#special:mytalk}}'>kaozeal</a>)",
	'wikieditor-toolbar-help-content-indent-description' => 'Endantadur',
	'wikieditor-toolbar-help-content-indent-syntax' => 'Testenn normal<br />:Testenn endantet<br />::Testenn endantet',
	'wikieditor-toolbar-help-content-indent-result' => 'Testenn normal<dl><dd>Testenn endantet<dl><dd>Testenn endantet</dd></dl></dd></dl>',
);

/** Bosnian (bosanski)
 * @author CERminator
 * @author Palapa
 */
$messages['bs'] = array(
	'wikieditor' => 'Napredni interfejs za uređivanje wikiteksta',
	'wikieditor-desc' => 'Omogućava proširivi interfejs za uređivanje wikiteksta i mnoge module sa brojnim mogućnostima',
	'wikieditor-wikitext-tab' => 'Wikitekst',
	'wikieditor-loading' => 'Učitavanje',
	'wikieditor-preview-preference' => 'Omogući pretpregled s obje strane',
	'wikieditor-preview-tab' => 'Pregled',
	'wikieditor-preview-changes-tab' => 'Promjene',
	'wikieditor-preview-loading' => 'Učitavam...',
	'wikieditor-previewDialog-preference' => 'Omogući dijalog pretpregleda',
	'wikieditor-previewDialog-tab' => 'Pregled',
	'wikieditor-previewDialog-loading' => 'Učitavam...',
	'wikieditor-publish-preference' => 'Omogući objavljivanje u koracima',
	'wikieditor-publish-button-publish' => 'Objavi',
	'wikieditor-publish-button-cancel' => 'Odustani',
	'wikieditor-publish-dialog-title' => 'Objavi na {{SITENAME}}',
	'wikieditor-publish-dialog-summary' => 'Uredi sažetak (kratko opiši izmjene koje ste načinili):',
	'wikieditor-publish-dialog-minor' => 'mala izmjena',
	'wikieditor-publish-dialog-watch' => 'Prati ovu stranicu',
	'wikieditor-publish-dialog-publish' => 'Objavi',
	'wikieditor-publish-dialog-goback' => 'Vrati se nazad',
	'wikieditor-template-editor-preference' => 'Omogućava uređivanje wiki šablon putem obrazaca',
	'wikieditor-template-editor-dialog-title' => 'Uredi šablon',
	'wikieditor-template-editor-dialog-submit' => 'Ažuriraj',
	'wikieditor-template-editor-dialog-cancel' => 'Odustani',
	'wikieditor-templates-preference' => 'Omogući sakrivanje sadržaja šablona',
	'wikieditor-toc-preference' => 'Omogući navigacijski sadržaj',
	'wikieditor-toc-show' => 'Pokaži sadržaj',
	'wikieditor-toc-hide' => 'Sakrij sadržaj',
	'wikieditor-toolbar' => 'Uređivanje alatne trake',
	'wikieditor-toolbar-desc' => 'Alatna traka stranice za uređivanje sa poboljšanom upotrebljivošću',
	'wikieditor-toolbar-preference' => 'Omogući naprednu traku za uređivanje',
	'wikieditor-toolbar-dialogs-preference' => 'Omogući dijaloge za dodavanje linkova, tabela i više',
	'wikieditor-toolbar-hidesig' => 'Sakrij dugme potpisa sa stranica u glavnom imenskom prostoru',
	'wikieditor-toolbar-loading' => 'Punjenje...',
	'wikieditor-toolbar-tool-bold' => 'Podebljano',
	'wikieditor-toolbar-tool-bold-example' => 'Podebljan tekst',
	'wikieditor-toolbar-tool-italic' => 'Ukošeno',
	'wikieditor-toolbar-tool-italic-example' => 'Ukošeni tekst',
	'wikieditor-toolbar-tool-ilink' => 'Unutrašnji link',
	'wikieditor-toolbar-tool-ilink-example' => 'Naslov linka',
	'wikieditor-toolbar-tool-xlink' => 'Vanjski link (zapamtite prefiks http://)',
	'wikieditor-toolbar-tool-xlink-example' => 'http://www.example.com naslov linka',
	'wikieditor-toolbar-tool-link' => 'Link',
	'wikieditor-toolbar-tool-link-title' => 'Ubaci link',
	'wikieditor-toolbar-tool-link-int' => 'Na wiki stranicu',
	'wikieditor-toolbar-tool-link-int-target' => 'Naslov stranice:',
	'wikieditor-toolbar-tool-link-int-target-tooltip' => 'Naslov stranice ili URL',
	'wikieditor-toolbar-tool-link-int-text' => 'Tekst linka:',
	'wikieditor-toolbar-tool-link-int-text-tooltip' => 'Unesite tekst koji bi trebao biti prikazan',
	'wikieditor-toolbar-tool-link-ext' => 'Na vanjsku web stranicu',
	'wikieditor-toolbar-tool-link-ext-target' => 'URL linka:',
	'wikieditor-toolbar-tool-link-ext-text' => 'Tekst linka:',
	'wikieditor-toolbar-tool-link-insert' => 'Ubaci link',
	'wikieditor-toolbar-tool-link-cancel' => 'Odustani',
	'wikieditor-toolbar-tool-link-int-target-status-exists' => 'Stranica postoji',
	'wikieditor-toolbar-tool-link-int-target-status-notexists' => 'Stranica ne postoji',
	'wikieditor-toolbar-tool-link-int-target-status-invalid' => 'Nevaljan naslov',
	'wikieditor-toolbar-tool-link-int-target-status-external' => 'Vanjski link',
	'wikieditor-toolbar-tool-link-int-target-status-loading' => 'Provjeravam postojanje stranice...',
	'wikieditor-toolbar-tool-link-int-invalid' => 'Naslov koji ste unijeli je nevaljan.',
	'wikieditor-toolbar-tool-link-lookslikeinternal' => 'URL koji ste naveli izgleda da je prepoznat kao link na drugu wiki stranicu.
Da li želite napraviti interni link?',
	'wikieditor-toolbar-tool-link-lookslikeinternal-int' => 'Unutrašnji link',
	'wikieditor-toolbar-tool-link-lookslikeinternal-ext' => 'Vanjski link',
	'wikieditor-toolbar-tool-link-empty' => 'Niste unijeli ništa za linkovanje.',
	'wikieditor-toolbar-tool-file' => 'Uklopljena datoteka',
	'wikieditor-toolbar-tool-file-example' => 'Primjer.jpg',
	'wikieditor-toolbar-tool-reference' => 'Reference',
	'wikieditor-toolbar-tool-reference-example' => 'Ubaci tekst fusnote ovdje',
	'wikieditor-toolbar-tool-reference-cancel' => 'Odustani',
	'wikieditor-toolbar-tool-reference-title' => 'Unesi referencu',
	'wikieditor-toolbar-tool-reference-insert' => 'Unesi',
	'wikieditor-toolbar-tool-reference-text' => 'Tekst reference',
	'wikieditor-toolbar-tool-signature' => 'Potpis i vrijeme',
	'wikieditor-toolbar-section-advanced' => 'Napredno',
	'wikieditor-toolbar-tool-heading' => 'Naslov',
	'wikieditor-toolbar-tool-heading-1' => 'Nivo 1',
	'wikieditor-toolbar-tool-heading-2' => 'Nivo 2',
	'wikieditor-toolbar-tool-heading-3' => 'Nivo 3',
	'wikieditor-toolbar-tool-heading-4' => 'Nivo 4',
	'wikieditor-toolbar-tool-heading-5' => 'Nivo 5',
	'wikieditor-toolbar-tool-heading-example' => 'Tekst naslova',
	'wikieditor-toolbar-group-format' => 'Format',
	'wikieditor-toolbar-tool-ulist' => 'Uređeni spisak',
	'wikieditor-toolbar-tool-ulist-example' => 'Stavka uređenog spiska',
	'wikieditor-toolbar-tool-olist' => 'Numerisani spisak',
	'wikieditor-toolbar-tool-olist-example' => 'Stavka numerisanog spiska',
	'wikieditor-toolbar-tool-indent' => 'Uvlaka',
	'wikieditor-toolbar-tool-indent-example' => 'Linija uvlake',
	'wikieditor-toolbar-tool-nowiki' => 'Nema wiki formatiranja',
	'wikieditor-toolbar-tool-nowiki-example' => 'Unesi neformatirani tekst ovdje',
	'wikieditor-toolbar-tool-redirect' => 'Preusmjeri',
	'wikieditor-toolbar-tool-redirect-example' => 'Ime ciljne stranice',
	'wikieditor-toolbar-tool-big' => 'Veliko',
	'wikieditor-toolbar-tool-big-example' => 'Povećan tekst',
	'wikieditor-toolbar-tool-small' => 'Smanjeno',
	'wikieditor-toolbar-tool-small-example' => 'Smanjen tekst',
	'wikieditor-toolbar-tool-superscript' => 'Eksponent',
	'wikieditor-toolbar-tool-superscript-example' => 'Tekst eksponenta',
	'wikieditor-toolbar-tool-subscript' => 'Indeks',
	'wikieditor-toolbar-tool-subscript-example' => 'Tekst indeksa',
	'wikieditor-toolbar-group-insert' => 'Ubaci',
	'wikieditor-toolbar-tool-gallery' => 'Galerija slika',
	'wikieditor-toolbar-tool-gallery-example' => '$1:Example.jpg|Opis1
$1:Example.jpg|Opis2',
	'wikieditor-toolbar-tool-newline' => 'Nova linija',
	'wikieditor-toolbar-tool-table' => 'Tabela',
	'wikieditor-toolbar-tool-table-example-old' => '-
! naslov 1
! naslov 2
! naslov 3
|-
| red 1, ćelija 1
| red 1, ćelija 2
| red 1, ćelija 3
|-
| red 2, ćelija 1
| red 2, ćelija 2
| red 2, ćelija 3',
	'wikieditor-toolbar-tool-table-example-cell-text' => 'Tekst ćelije',
	'wikieditor-toolbar-tool-table-example-header' => 'Tekst zaglavlja',
	'wikieditor-toolbar-tool-table-title' => 'Ubaci tabelu',
	'wikieditor-toolbar-tool-table-dimensions-rows' => 'Redovi',
	'wikieditor-toolbar-tool-table-dimensions-columns' => 'Kolone',
	'wikieditor-toolbar-tool-table-dimensions-header' => 'Uključi red zaglavlja',
	'wikieditor-toolbar-tool-table-wikitable' => 'Stil sa okvirima',
	'wikieditor-toolbar-tool-table-sortable' => 'Napravi sortirajuću tabelu',
	'wikieditor-toolbar-tool-table-example' => 'Tekst ćelije',
	'wikieditor-toolbar-tool-table-preview' => 'Pregled',
	'wikieditor-toolbar-tool-table-insert' => 'Ubaci',
	'wikieditor-toolbar-tool-table-cancel' => 'Odustani',
	'wikieditor-toolbar-tool-table-toomany' => 'Ubacivanje tabele sa više od $1 ćelija nije moguće putem ovog dijaloga.',
	'wikieditor-toolbar-tool-table-invalidnumber' => 'Niste unijeli valjan broj redova ili kolona.',
	'wikieditor-toolbar-tool-table-zero' => 'Ne možete unijeti tabelu bez redova ili kolona.',
	'wikieditor-toolbar-tool-replace' => 'Pronađi i zamijeni',
	'wikieditor-toolbar-tool-replace-title' => 'Nađi i zamijeni',
	'wikieditor-toolbar-tool-replace-search' => 'Pretraži:',
	'wikieditor-toolbar-tool-replace-replace' => 'Zamijeni sa:',
	'wikieditor-toolbar-tool-replace-case' => 'Razlikuj velika i mala slova',
	'wikieditor-toolbar-tool-replace-regex' => 'Smatraj traženi pojam kao regularni izraz',
	'wikieditor-toolbar-tool-replace-button-findnext' => 'Nađi slijedeći',
	'wikieditor-toolbar-tool-replace-button-replaceall' => 'Zamijeni sve',
	'wikieditor-toolbar-tool-replace-close' => 'Zatvori',
	'wikieditor-toolbar-tool-replace-nomatch' => 'Vaša pretraga nije dala nijedan rezultat.',
	'wikieditor-toolbar-tool-replace-success' => 'Načinjeno $1 izmjena.',
	'wikieditor-toolbar-tool-replace-emptysearch' => 'Niste unijeli ništa za pretragu.',
	'wikieditor-toolbar-tool-replace-invalidregex' => 'Regularni izraz koji ste unijeli nije valjan: $1',
	'wikieditor-toolbar-section-characters' => 'Posebni znakovi',
	'wikieditor-toolbar-characters-page-latin' => 'Latinica',
	'wikieditor-toolbar-characters-page-latinextended' => 'Prošireni latinski',
	'wikieditor-toolbar-characters-page-ipa' => 'IPA',
	'wikieditor-toolbar-characters-page-symbols' => 'Simboli',
	'wikieditor-toolbar-characters-page-greek' => 'Grčki',
	'wikieditor-toolbar-characters-page-cyrillic' => 'Ćirilica',
	'wikieditor-toolbar-characters-page-arabic' => 'Arapski',
	'wikieditor-toolbar-characters-page-persian' => 'Perzijski',
	'wikieditor-toolbar-characters-page-hebrew' => 'Hebrejski',
	'wikieditor-toolbar-characters-page-bangla' => 'Bangladeški',
	'wikieditor-toolbar-characters-page-telugu' => 'Telugu',
	'wikieditor-toolbar-characters-page-sinhala' => 'Sinhala',
	'wikieditor-toolbar-characters-page-gujarati' => 'Gujarati',
	'wikieditor-toolbar-characters-page-thai' => 'Tajlandski',
	'wikieditor-toolbar-characters-page-lao' => 'Laoški',
	'wikieditor-toolbar-characters-page-khmer' => 'Kmerski',
	'wikieditor-toolbar-section-help' => 'Pomoć',
	'wikieditor-toolbar-help-heading-description' => 'Opis',
	'wikieditor-toolbar-help-heading-syntax' => 'Šta upisujete',
	'wikieditor-toolbar-help-heading-result' => 'Šta dobijate',
	'wikieditor-toolbar-help-page-format' => 'Formatiranje',
	'wikieditor-toolbar-help-page-link' => 'Linkovi',
	'wikieditor-toolbar-help-page-heading' => 'Naslovi',
	'wikieditor-toolbar-help-page-list' => 'Spiskovi',
	'wikieditor-toolbar-help-page-file' => 'Datoteke',
	'wikieditor-toolbar-help-page-reference' => 'Reference',
	'wikieditor-toolbar-help-page-discussion' => 'Razgovor',
	'wikieditor-toolbar-help-content-italic-description' => 'Kurziv',
	'wikieditor-toolbar-help-content-italic-syntax' => "''Ukošen tekst''",
	'wikieditor-toolbar-help-content-italic-result' => '<em>Ukošen tekst</em>',
	'wikieditor-toolbar-help-content-bold-description' => 'Podebljano',
	'wikieditor-toolbar-help-content-bold-syntax' => "'''Podebljan tekst'''",
	'wikieditor-toolbar-help-content-bold-result' => '<strong>Podebljan tekst</strong>',
	'wikieditor-toolbar-help-content-bolditalic-description' => 'Podebljano &amp; ukošeno',
	'wikieditor-toolbar-help-content-bolditalic-syntax' => "'''''Podebljan &amp; ukošen tekst'''''",
	'wikieditor-toolbar-help-content-bolditalic-result' => '<strong><em>Podebljan &amp; ukošen tekst</em></strong>',
	'wikieditor-toolbar-help-content-ilink-description' => 'Unutrašnji link',
	'wikieditor-toolbar-help-content-ilink-syntax' => '[[Naslov stranice|Naslov linka]]<br />[[Naslov stranice]]',
	'wikieditor-toolbar-help-content-ilink-result' => "<a href='#'>Naslov linka</a><br /><a href='#'>Naslov stranice</a>",
	'wikieditor-toolbar-help-content-xlink-description' => 'Vanjski link',
	'wikieditor-toolbar-help-content-xlink-syntax' => '[http://www.example.org Naslov linka]<br />[http://www.example.org]<br />http://www.example.org',
	'wikieditor-toolbar-help-content-xlink-result' => "<a href='#' class='external'>Naslov linka</a><br /><a href='#' class='external autonumber'>[1]</a><br /><a href='#' class='external'>http://www.example.org</a>",
	'wikieditor-toolbar-help-content-heading2-description' => 'Naslov 2. nivoa',
	'wikieditor-toolbar-help-content-heading2-syntax' => '== Tekst naslova ==',
	'wikieditor-toolbar-help-content-heading2-result' => '<h2>Tekst naslova</h2>',
	'wikieditor-toolbar-help-content-heading3-description' => 'Naslov 3. nivoa',
	'wikieditor-toolbar-help-content-heading3-syntax' => '=== Tekst naslova ===',
	'wikieditor-toolbar-help-content-heading3-result' => '<h3>Tekst naslova</h3>',
	'wikieditor-toolbar-help-content-heading4-description' => 'Naslov 4. nivoa',
	'wikieditor-toolbar-help-content-heading4-syntax' => '==== Tekst naslova ====',
	'wikieditor-toolbar-help-content-heading4-result' => '<h4>Tekst naslova</h4>',
	'wikieditor-toolbar-help-content-heading5-description' => 'Naslov 5. nivoa',
	'wikieditor-toolbar-help-content-heading5-syntax' => '===== Tekst naslova =====',
	'wikieditor-toolbar-help-content-heading5-result' => '<h5>Tekst naslova</h5>',
	'wikieditor-toolbar-help-content-ulist-description' => 'Uređeni spisak',
	'wikieditor-toolbar-help-content-ulist-syntax' => '* Stavka spiska<br />* Stavka spiska',
	'wikieditor-toolbar-help-content-ulist-result' => '<ul><li>Stavka spiska</li><li>Stavka spiska</li></ul>',
	'wikieditor-toolbar-help-content-olist-description' => 'Numerisani spisak',
	'wikieditor-toolbar-help-content-olist-syntax' => '# Stavka spiska<br /># Stavka spiska',
	'wikieditor-toolbar-help-content-olist-result' => '<ol><li>Stavka spiska</li><li>Stavka spiska</li></ol>',
	'wikieditor-toolbar-help-content-file-description' => 'Uklopljena datoteka',
	'wikieditor-toolbar-help-content-file-syntax' => '[[$1:Example.png|thumb|Opis slike]]',
	'wikieditor-toolbar-help-content-file-result' => "<div style='width:104px;' class='thumbinner'><a title='Opis slike' class='image' href='#'><img height='50' width='100' border='0' class='thumbimage' src='$2/WikiEditor/modules/images/toolbar/example-image.png' alt=''/></a><div class='thumbcaption'><div class='magnify'><a title='Uvećajte' class='internal' href='#'><img height='11' width='15' alt='' src='$1/common/images/magnify-clip.png'/></a></div>Opis slike</div></div>",
	'wikieditor-toolbar-help-content-reference-description' => 'Reference',
	'wikieditor-toolbar-help-content-reference-syntax' => 'Tekst stranice.&lt;ref name="test"&gt;[http://www.example.org Tekst linka], dodatni tekst.&lt;/ref&gt;',
	'wikieditor-toolbar-help-content-reference-result' => "Tekst stranice.<sup><a href='#'>[1]</a></sup>",
	'wikieditor-toolbar-help-content-rereference-description' => 'Dodatna upotreba istog izvora',
	'wikieditor-toolbar-help-content-rereference-result' => "Tekst stranice.<sup><a href='#'>[1]</a></sup>",
	'wikieditor-toolbar-help-content-showreferences-description' => 'Prikaži izvore',
	'wikieditor-toolbar-help-content-showreferences-result' => "<ol class='references'><li id='cite_note-test-0'><b><a title='' href='#'>^</a></b> <a rel='nofollow' title='http://www.example.org' class='external text' href='#'>Tekst linka</a>, dodatni tekst.</li></ol>",
	'wikieditor-toolbar-help-content-signaturetimestamp-description' => 'Potpis s trenutnim vremenom',
	'wikieditor-toolbar-help-content-signaturetimestamp-result' => "<a href='#' title='{{#special:mypage}}'>Korisničko ime</a> (<a href='#' title='{{#special:mytalk}}'>Razgovor</a>) 15:54, 10. juni 2009 (UTC)",
	'wikieditor-toolbar-help-content-signature-description' => 'Potpis',
	'wikieditor-toolbar-help-content-signature-result' => "<a href='#' title='{{#special:mypage}}'>Korisničko ime</a> (<a href='#' title='{{#special:mytalk}}'>razgovor</a>)",
	'wikieditor-toolbar-help-content-indent-description' => 'Uvučeno',
	'wikieditor-toolbar-help-content-indent-syntax' => 'Obični tekst<br />:Uvučeni tekst<br />::Uvučeni tekst',
	'wikieditor-toolbar-help-content-indent-result' => 'Obični tekst<dl><dd>Uvučeni tekst<dl><dd>Uvučeni tekst</dd></dl></dd></dl>',
);

/** Catalan (català)
 * @author Arnaugir
 * @author BroOk
 * @author Martorell
 * @author Paucabot
 * @author SMP
 * @author Solde
 * @author Toniher
 * @author Vriullop
 */
$messages['ca'] = array(
	'wikieditor' => 'Interfície avançada de modificació de wikitext',
	'wikieditor-desc' => 'Proporciona una interfície extensible de modificació de wikitext i diversos mòduls de funcionalitats',
	'wikieditor-wikitext-tab' => 'Wikitext',
	'wikieditor-loading' => 'Carregant',
	'wikieditor-preview-preference' => 'Habilita la previsualització costat per costat',
	'wikieditor-preview-tab' => 'Previsualització',
	'wikieditor-preview-changes-tab' => 'Canvis',
	'wikieditor-preview-loading' => 'Carregant ...',
	'wikieditor-previewDialog-preference' => 'Activa el diàleg de vista prèvia',
	'wikieditor-previewDialog-tab' => 'Previsualització',
	'wikieditor-previewDialog-loading' => 'Carregant ...',
	'wikieditor-publish-preference' => 'Habilita la publicació pas a pas',
	'wikieditor-publish-button-publish' => 'Publica',
	'wikieditor-publish-button-cancel' => 'Anuŀla',
	'wikieditor-publish-dialog-title' => 'Publicar a {{SITENAME}}',
	'wikieditor-publish-dialog-summary' => "Resum d'edició (descriviu breument els canvis realitzats):",
	'wikieditor-publish-dialog-minor' => 'Modificació menor',
	'wikieditor-publish-dialog-watch' => 'Vigila aquesta pàgina',
	'wikieditor-publish-dialog-publish' => 'Publica',
	'wikieditor-publish-dialog-goback' => 'Torna',
	'wikieditor-template-editor-preference' => "Permetre l'edició basada en formularis de plantilles",
	'wikieditor-template-editor-dialog-title' => 'Modifica la plantilla',
	'wikieditor-template-editor-dialog-submit' => 'Actualitza',
	'wikieditor-template-editor-dialog-cancel' => 'Anuŀla',
	'wikieditor-templates-preference' => 'Habilita el replegament de plantilles',
	'wikieditor-toc-preference' => 'Habilita la taula de continguts navegable',
	'wikieditor-toc-show' => 'Mostra el contingut',
	'wikieditor-toc-hide' => 'Amaga el contingut',
	'wikieditor-toolbar' => "Editant la barra d'eines",
	'wikieditor-toolbar-desc' => "Barra d'eines d'edició amb usabilitat millorada",
	'wikieditor-toolbar-preference' => "Habilita la barra d'eines millorada",
	'wikieditor-toolbar-dialogs-preference' => 'Habilita caixes de diàleg per inserir enllaços, taules i altres',
	'wikieditor-toolbar-hidesig' => "Amaga el botó de signar de les pàgines de l'espai de noms principal",
	'wikieditor-toolbar-loading' => 'Carregant...',
	'wikieditor-toolbar-tool-bold' => 'Negreta',
	'wikieditor-toolbar-tool-bold-example' => 'Text en negreta',
	'wikieditor-toolbar-tool-italic' => 'Cursiva',
	'wikieditor-toolbar-tool-italic-example' => 'Text en cursiva',
	'wikieditor-toolbar-tool-ilink' => 'Enllaç intern',
	'wikieditor-toolbar-tool-ilink-example' => "Títol de l'enllaç",
	'wikieditor-toolbar-tool-xlink' => 'Enllaç extern (recordeu el prefix http://)',
	'wikieditor-toolbar-tool-xlink-example' => "http://www.example.org títol de l'enllaç",
	'wikieditor-toolbar-tool-link' => 'Enllaç',
	'wikieditor-toolbar-tool-link-title' => 'Insereix un enllaç',
	'wikieditor-toolbar-tool-link-int' => 'A una pàgina del wiki',
	'wikieditor-toolbar-tool-link-int-target' => "Nom de l'article:",
	'wikieditor-toolbar-tool-link-int-target-tooltip' => 'Títol de la pàgina o URL',
	'wikieditor-toolbar-tool-link-int-text' => "Text de l'enllaç:",
	'wikieditor-toolbar-tool-link-int-text-tooltip' => 'Text a mostrar',
	'wikieditor-toolbar-tool-link-ext' => 'A una pàgina web externa',
	'wikieditor-toolbar-tool-link-ext-target' => "URL de l'enllaç",
	'wikieditor-toolbar-tool-link-ext-text' => "Text de l'enllaç:",
	'wikieditor-toolbar-tool-link-insert' => 'Insereix un enllaç',
	'wikieditor-toolbar-tool-link-cancel' => 'Canceŀla',
	'wikieditor-toolbar-tool-link-int-target-status-exists' => 'La pàgina existeix',
	'wikieditor-toolbar-tool-link-int-target-status-notexists' => 'La pàgina no existeix',
	'wikieditor-toolbar-tool-link-int-target-status-invalid' => 'Títol no vàlid',
	'wikieditor-toolbar-tool-link-int-target-status-external' => 'Enllaç extern',
	'wikieditor-toolbar-tool-link-int-target-status-loading' => "Comprovació de l'existència de la pàgina ...",
	'wikieditor-toolbar-tool-link-int-invalid' => 'El títol que heu especificat no és vàlid.',
	'wikieditor-toolbar-tool-link-lookslikeinternal' => "L'URL que heu especificat sembla que enllaça a una altra pàgina del wiki.
Voleu convertir-lo en un enllaç intern?",
	'wikieditor-toolbar-tool-link-lookslikeinternal-int' => 'Enllaç intern',
	'wikieditor-toolbar-tool-link-lookslikeinternal-ext' => 'Enllaç extern',
	'wikieditor-toolbar-tool-link-empty' => 'No heu entrat res per enllaçar.',
	'wikieditor-toolbar-tool-file' => 'Fitxer incrustat',
	'wikieditor-toolbar-tool-file-example' => 'Exemple.png',
	'wikieditor-toolbar-tool-file-title' => 'Insereix arxiu',
	'wikieditor-toolbar-file-target' => 'Nom del fitxer:',
	'wikieditor-toolbar-file-caption' => 'Títol:',
	'wikieditor-toolbar-file-size' => 'Mida:',
	'wikieditor-toolbar-file-float' => 'Alineació:',
	'wikieditor-toolbar-file-default' => '(per defecte)',
	'wikieditor-toolbar-file-format' => 'Format:',
	'wikieditor-toolbar-tool-file-insert' => 'Inserta',
	'wikieditor-toolbar-tool-file-cancel' => 'Cancel·la',
	'wikieditor-toolbar-tool-reference' => 'Referència',
	'wikieditor-toolbar-tool-reference-example' => 'Inseriu la nota al peu aquí',
	'wikieditor-toolbar-tool-reference-cancel' => 'Cancel·la',
	'wikieditor-toolbar-tool-reference-title' => 'Inserir una referència',
	'wikieditor-toolbar-tool-reference-insert' => 'Insereix',
	'wikieditor-toolbar-tool-reference-text' => 'Text de la referència',
	'wikieditor-toolbar-tool-signature' => 'Signatura, data i hora',
	'wikieditor-toolbar-section-advanced' => 'Avançat',
	'wikieditor-toolbar-tool-heading' => 'Encapçalament',
	'wikieditor-toolbar-tool-heading-1' => 'Nivell 1',
	'wikieditor-toolbar-tool-heading-2' => 'Nivell 2',
	'wikieditor-toolbar-tool-heading-3' => 'Nivell 3',
	'wikieditor-toolbar-tool-heading-4' => 'Nivell 4',
	'wikieditor-toolbar-tool-heading-5' => 'Nivell 5',
	'wikieditor-toolbar-tool-heading-example' => "Text d'encapçalament",
	'wikieditor-toolbar-group-format' => 'Format',
	'wikieditor-toolbar-tool-ulist' => 'Llista puntejada',
	'wikieditor-toolbar-tool-ulist-example' => 'Element de la llista puntejada',
	'wikieditor-toolbar-tool-olist' => 'Llista numerada',
	'wikieditor-toolbar-tool-olist-example' => 'Element de la llista numerada',
	'wikieditor-toolbar-tool-indent' => 'Sagnat',
	'wikieditor-toolbar-tool-indent-example' => 'Línia sagnada',
	'wikieditor-toolbar-tool-nowiki' => 'Sense format wiki',
	'wikieditor-toolbar-tool-nowiki-example' => 'Inseriu aquí un text sense format',
	'wikieditor-toolbar-tool-redirect' => 'Redirecció',
	'wikieditor-toolbar-tool-redirect-example' => 'Nom de la pàgina destinació',
	'wikieditor-toolbar-tool-big' => 'Gran',
	'wikieditor-toolbar-tool-big-example' => 'Text gran',
	'wikieditor-toolbar-tool-small' => 'Petit',
	'wikieditor-toolbar-tool-small-example' => 'Text petit',
	'wikieditor-toolbar-tool-superscript' => 'Superíndex',
	'wikieditor-toolbar-tool-superscript-example' => 'Text en superíndex',
	'wikieditor-toolbar-tool-subscript' => 'Subíndex',
	'wikieditor-toolbar-tool-subscript-example' => 'Text en subíndex',
	'wikieditor-toolbar-group-insert' => 'Insereix',
	'wikieditor-toolbar-tool-gallery' => "Galeria d'imatges",
	'wikieditor-toolbar-tool-gallery-example' => '$1:Example.jpg|Peu1
$1:Example.jpg|Peu2',
	'wikieditor-toolbar-tool-newline' => 'Nova línia',
	'wikieditor-toolbar-tool-table' => 'Taula',
	'wikieditor-toolbar-tool-table-example-old' => '-
! capçalera 1
! capçalera 2
! capçalera 3
|-
| fila 1, cel·la 1
| fila 1, cel·la 2
| fila 1, cel·la 3
|-
| fila 2, cel·la 1
| fila 2, cel·la 2
| fila 2, cel·la 3',
	'wikieditor-toolbar-tool-table-example-cell-text' => 'Text de cel·la',
	'wikieditor-toolbar-tool-table-example-header' => 'Text de capçalera',
	'wikieditor-toolbar-tool-table-title' => 'Insereix una taula',
	'wikieditor-toolbar-tool-table-dimensions-rows' => 'Files',
	'wikieditor-toolbar-tool-table-dimensions-columns' => 'Columnes',
	'wikieditor-toolbar-tool-table-dimensions-header' => "Amb una fila d'encapçalament",
	'wikieditor-toolbar-tool-table-wikitable' => 'Estil amb vores',
	'wikieditor-toolbar-tool-table-sortable' => 'Taula ordenable',
	'wikieditor-toolbar-tool-table-example' => 'Text de cel·la',
	'wikieditor-toolbar-tool-table-preview' => 'Previsualització',
	'wikieditor-toolbar-tool-table-insert' => 'Insereix',
	'wikieditor-toolbar-tool-table-cancel' => 'Anuŀla',
	'wikieditor-toolbar-tool-table-toomany' => 'Amb aquesta caixa de diàleg no és possible inserir una taula amb més de $1 ceŀles.',
	'wikieditor-toolbar-tool-table-invalidnumber' => 'No heu introduït un nombre vàlid de files o columnes.',
	'wikieditor-toolbar-tool-table-zero' => 'No podeu inserir una taula amb zero files o columnes.',
	'wikieditor-toolbar-tool-replace' => 'Cerca i reemplaça',
	'wikieditor-toolbar-tool-replace-title' => 'Cerca i reemplaça',
	'wikieditor-toolbar-tool-replace-search' => 'Cerca:',
	'wikieditor-toolbar-tool-replace-replace' => 'Reemplaça per:',
	'wikieditor-toolbar-tool-replace-case' => 'Distingeix majúscules/minúscules',
	'wikieditor-toolbar-tool-replace-regex' => 'Tracta la cadena de cerca com una expressió regular',
	'wikieditor-toolbar-tool-replace-button-findnext' => 'Cerca següent',
	'wikieditor-toolbar-tool-replace-button-replace' => 'Reemplaça',
	'wikieditor-toolbar-tool-replace-button-replaceall' => 'Substitueix-ho tot',
	'wikieditor-toolbar-tool-replace-close' => 'Tanca',
	'wikieditor-toolbar-tool-replace-nomatch' => 'La vostra cerca no ha trobat cap coincidència.',
	'wikieditor-toolbar-tool-replace-success' => "S'han fet $1 substitucions.",
	'wikieditor-toolbar-tool-replace-emptysearch' => 'No heu introduït res per a cercar.',
	'wikieditor-toolbar-tool-replace-invalidregex' => "L'expressió regular que heu introduït no és vàlida: $1",
	'wikieditor-toolbar-section-characters' => 'Caràcters especials',
	'wikieditor-toolbar-characters-page-latin' => 'Llatí',
	'wikieditor-toolbar-characters-page-latinextended' => 'Llatí ampliat',
	'wikieditor-toolbar-characters-page-ipa' => 'AFI',
	'wikieditor-toolbar-characters-page-symbols' => 'Símbols',
	'wikieditor-toolbar-characters-page-greek' => 'Grec',
	'wikieditor-toolbar-characters-page-cyrillic' => 'Ciríŀlic',
	'wikieditor-toolbar-characters-page-arabic' => 'Aràbic',
	'wikieditor-toolbar-characters-page-arabicextended' => 'Aràbic estès',
	'wikieditor-toolbar-characters-page-persian' => 'Persa',
	'wikieditor-toolbar-characters-page-hebrew' => 'Hebreu',
	'wikieditor-toolbar-characters-page-bangla' => 'Bengalí',
	'wikieditor-toolbar-characters-page-tamil' => 'Tamil',
	'wikieditor-toolbar-characters-page-telugu' => 'Telugu',
	'wikieditor-toolbar-characters-page-sinhala' => 'Sinhala',
	'wikieditor-toolbar-characters-page-gujarati' => 'Gujarati',
	'wikieditor-toolbar-characters-page-devanagari' => 'Devanagari',
	'wikieditor-toolbar-characters-page-thai' => 'Tailandès',
	'wikieditor-toolbar-characters-page-lao' => 'Laosià',
	'wikieditor-toolbar-characters-page-khmer' => 'Khmer',
	'wikieditor-toolbar-section-help' => 'Ajuda',
	'wikieditor-toolbar-help-heading-description' => 'Descripció',
	'wikieditor-toolbar-help-heading-syntax' => 'El que teclegeu',
	'wikieditor-toolbar-help-heading-result' => 'El que obteniu',
	'wikieditor-toolbar-help-page-format' => 'Format',
	'wikieditor-toolbar-help-page-link' => 'Enllaços',
	'wikieditor-toolbar-help-page-heading' => 'Encapçalaments',
	'wikieditor-toolbar-help-page-list' => 'Llistes',
	'wikieditor-toolbar-help-page-file' => 'Fitxers',
	'wikieditor-toolbar-help-page-reference' => 'Referències',
	'wikieditor-toolbar-help-page-discussion' => 'Discussió',
	'wikieditor-toolbar-help-content-italic-description' => 'Cursiva',
	'wikieditor-toolbar-help-content-italic-syntax' => "''Text en cursiva''",
	'wikieditor-toolbar-help-content-italic-result' => '<em>Text en cursiva</em>',
	'wikieditor-toolbar-help-content-bold-description' => 'Negreta',
	'wikieditor-toolbar-help-content-bold-syntax' => "'''Text en negreta'''",
	'wikieditor-toolbar-help-content-bold-result' => '<strong>Text en negreta</strong>',
	'wikieditor-toolbar-help-content-bolditalic-description' => 'Negreta i cursiva',
	'wikieditor-toolbar-help-content-bolditalic-syntax' => "'''''Text en negreta i cursiva'''''",
	'wikieditor-toolbar-help-content-bolditalic-result' => '<strong><em>Text en negreta i cursiva</em></strong>',
	'wikieditor-toolbar-help-content-ilink-description' => 'Enllaç intern',
	'wikieditor-toolbar-help-content-ilink-syntax' => "[[Nom de la pàgina|Nom de l'enllaç]]<br />[[Nom de la pàgina]]",
	'wikieditor-toolbar-help-content-ilink-result' => "<a href='#'>Nom de l'enllaç</a><br /><a href='#'>Nom de la pàgina</a>",
	'wikieditor-toolbar-help-content-xlink-description' => 'Enllaç extern',
	'wikieditor-toolbar-help-content-xlink-syntax' => "[http://www.example.org Nom de l'enllaç]<br />[http://www.example.org]<br />http://www.example.org",
	'wikieditor-toolbar-help-content-xlink-result' => "<a href='#' class='external'>Títol de l'enllaç</a><br /><a href='#' class='external autonumber'>[1]</a><br /><a href='#' class='external'>http://www.example.org</a>",
	'wikieditor-toolbar-help-content-heading2-description' => 'Encapçalament de 2n nivell',
	'wikieditor-toolbar-help-content-heading2-syntax' => "==Text de l'encapçalament==",
	'wikieditor-toolbar-help-content-heading2-result' => "<h2>Text de l'encapçalament</h2>",
	'wikieditor-toolbar-help-content-heading3-description' => 'Encapçalament de 3r nivell',
	'wikieditor-toolbar-help-content-heading3-syntax' => "===Text de l'encapçalament===",
	'wikieditor-toolbar-help-content-heading3-result' => "<h3>Text de l'encapçalament</h3>",
	'wikieditor-toolbar-help-content-heading4-description' => 'Encapçalament de 4t nivell',
	'wikieditor-toolbar-help-content-heading4-syntax' => "====Text de l'encapçalament====",
	'wikieditor-toolbar-help-content-heading4-result' => "<h4>Text de l'encapçalament</h4>",
	'wikieditor-toolbar-help-content-heading5-description' => 'Encapçalament de 5è nivell',
	'wikieditor-toolbar-help-content-heading5-syntax' => "=====Text de l'encapçalament=====",
	'wikieditor-toolbar-help-content-heading5-result' => "<h5>Text de l'encapçalament</h5>",
	'wikieditor-toolbar-help-content-ulist-description' => 'Llista puntejada',
	'wikieditor-toolbar-help-content-ulist-syntax' => '* Element de la llista<br />* Element de la llista',
	'wikieditor-toolbar-help-content-ulist-result' => '<ul><li>Element de la llista</li><li>Element de la llista</li></ul>',
	'wikieditor-toolbar-help-content-olist-description' => 'Llista numerada',
	'wikieditor-toolbar-help-content-olist-syntax' => '# Element de la llista<br /># Element de la llista',
	'wikieditor-toolbar-help-content-olist-result' => '<ol><li>Element de la llista</li><li>Element de la llista</li></ol>',
	'wikieditor-toolbar-help-content-file-description' => 'Fitxer incrustat',
	'wikieditor-toolbar-help-content-file-syntax' => '[[$1:Example.png|thumb|Text descriptiu de la imatge]]',
	'wikieditor-toolbar-help-content-file-result' => "<div style='width:104px;' class='thumbinner'><a title='Caption text' class='image' href='#'><img height='50' width='100' border='0' class='thumbimage' src='$2/WikiEditor/modules/images/toolbar/example-image.png' alt=''/></a><div class='thumbcaption'><div class='magnify'><a title='Enlarge' class='internal' href='#'><img height='11' width='15' alt='' src='$1/common/images/magnify-clip.png'/></a></div>Llegenda</div></div>",
	'wikieditor-toolbar-help-content-reference-description' => 'Referències',
	'wikieditor-toolbar-help-content-reference-syntax' => 'Text de la pàgina.&lt;ref name="test"&gt;[http://www.exemple.cat Nom de l\'enllaç], text addicional.&lt;/ref&gt;',
	'wikieditor-toolbar-help-content-reference-result' => "Text de la pàgina.<sup><a href='#'>[1]</a></sup>",
	'wikieditor-toolbar-help-content-rereference-description' => 'Ús addicional de la mateixa referència',
	'wikieditor-toolbar-help-content-rereference-result' => "Text de la pàgina.<sup><a href='#'>[1]</a></sup>",
	'wikieditor-toolbar-help-content-showreferences-description' => 'Mostra les referències',
	'wikieditor-toolbar-help-content-showreferences-result' => "<ol class='references'><li id='cite_note-test-0'><b><a title='' href='#'>^</a></b> <a rel='nofollow' title='http://www.exemple.cat' class='external text' href='#'>Nom de l'enllaç</a>, text addicional.</li></ol>",
	'wikieditor-toolbar-help-content-signaturetimestamp-description' => 'Signatura, data i hora',
	'wikieditor-toolbar-help-content-signaturetimestamp-result' => "<a href='#' title='{{#special:mypage}}'>Nom d'usuari</a> (<a href='#' title='{{#special:mytalk}}'>discussió</a>) 15:54, 10 de juny de 2009 (UTC)",
	'wikieditor-toolbar-help-content-signature-description' => 'Signatura',
	'wikieditor-toolbar-help-content-signature-result' => "<a href='#' title='{{#special:mypage}}'>Nom d'usuari</a> (<a href='#' title='{{#special:mytalk}}'>discussió</a>)",
	'wikieditor-toolbar-help-content-indent-description' => 'Sagnat',
	'wikieditor-toolbar-help-content-indent-syntax' => 'Text normal<br />:Text sagnat<br />::Text sagnat',
	'wikieditor-toolbar-help-content-indent-result' => 'Text normal<dl><dd>Text sagnat<dl><dd>Text sagnat</dd></dl></dd></dl>',
);

/** Chechen (нохчийн)
 * @author Sasan700
 */
$messages['ce'] = array(
	'wikieditor' => 'Викийозан рéдоккхучечохь аллсам чулоцург',
	'wikieditor-desc' => 'Аьтто бо тlе хуттучо, викийозан аъ ишта кхечу харжамна рéдоккхучечохь аллсам чулоцучо',
	'wikieditor-wikitext-tab' => 'Викийоза',
	'wikieditor-loading' => 'Чуйолуш',
	'wikieditor-preview-preference' => 'Латайé хьалха муха ю хьажар дуьхь дуьхьал',
	'wikieditor-preview-tab' => 'Хьалха муха ю хьажа',
	'wikieditor-preview-changes-tab' => 'Хийцамаш',
	'wikieditor-preview-loading' => 'Чуйолуш…',
	'wikieditor-previewDialog-preference' => 'Латайé йоза хьалха муха ду хьажар',
	'wikieditor-previewDialog-tab' => 'Хьалха муха ю хьажа',
	'wikieditor-previewDialog-loading' => 'Чуйолуш…',
	'wikieditor-publish-preference' => 'Латайé цхьац ког бокхуш чутохар',
	'wikieditor-publish-button-publish' => 'Нахангайта',
	'wikieditor-publish-button-cancel' => 'Цаоьшу',
	'wikieditor-publish-dialog-title' => 'Нахангайта оцу кхолламехь {{SITENAME}}',
	'wikieditor-publish-dialog-summary' => 'Хийцамах лаьцна (доц язде хlу хийцам бина ахьа):',
	'wikieditor-publish-dialog-minor' => 'Жим хийцам',
	'wikieditor-publish-dialog-watch' => 'Тергам бé хlокху агlон',
	'wikieditor-publish-dialog-publish' => 'Нахангайта',
	'wikieditor-publish-dialog-goback' => 'Юхьа',
	'wikieditor-template-editor-preference' => 'Латайé куцкепа рéдаккхар бáраман гlонца',
	'wikieditor-template-editor-dialog-title' => 'Куцкеп хийцам',
	'wikieditor-template-editor-dialog-submit' => 'Карлаяккха',
	'wikieditor-template-editor-dialog-cancel' => 'Цаоьшу',
	'wikieditor-templates-preference' => 'Латедé куцкеп хьарчар',
	'wikieditor-toc-preference' => 'Латедé коьрта дерг шавигарна аттонца',
	'wikieditor-toc-show' => 'Гайта коьртехь дерг',
	'wikieditor-toc-hide' => 'Къайлахьо коьртехь дерг',
	'wikieditor-toolbar' => 'Рéдоккху меттиг',
	'wikieditor-toolbar-desc' => 'Рéдоккху меттиг гlоле лелорца',
	'wikieditor-toolbar-preference' => 'Латайé гlоле йолу рéдоккхург',
	'wikieditor-toolbar-dialogs-preference' => 'Латайé йозан хьажориг йуьллург, таблийцан аъ кхин хlумнашна',
	'wikieditor-toolbar-loading' => 'Чуйолуш…',
	'wikieditor-toolbar-tool-bold' => 'Дерстино',
	'wikieditor-toolbar-tool-bold-example' => 'Дерстино до йоза',
	'wikieditor-toolbar-tool-italic' => 'Курсетта',
	'wikieditor-toolbar-tool-italic-example' => 'Курсеттан до йоза',
	'wikieditor-toolbar-tool-ilink' => 'Чоьхьа хьажориг',
	'wikieditor-toolbar-tool-ilink-example' => 'Хьажориган коьрта могlа',
	'wikieditor-toolbar-tool-xlink' => 'Арахьа хьажориг (йиц ма йе хlотталушерг http://)',
	'wikieditor-toolbar-tool-xlink-example' => 'http://www.example.com хьажориг корта',
	'wikieditor-toolbar-tool-link' => 'Хьажориг',
	'wikieditor-toolbar-tool-link-title' => 'Чуйилла хьажориг',
	'wikieditor-toolbar-tool-link-int' => 'Оцу вики агlон',
	'wikieditor-toolbar-tool-link-int-target' => 'Хьажийна агlо йа URL:',
	'wikieditor-toolbar-tool-link-int-target-tooltip' => 'Агlон цlе йа URL',
	'wikieditor-toolbar-tool-link-int-text' => 'Гойтуш долу йоза:',
	'wikieditor-toolbar-tool-link-int-text-tooltip' => 'Чудилла схьагайта дезаш долу йоза',
	'wikieditor-toolbar-tool-link-ext' => 'Хьалхара агlон чохь',
	'wikieditor-toolbar-tool-link-ext-target' => 'URL хьажоригаш:',
	'wikieditor-toolbar-tool-link-ext-text' => 'Хьажориган йоза:',
	'wikieditor-toolbar-tool-link-insert' => 'Чуйилла хьажориг',
	'wikieditor-toolbar-tool-link-cancel' => 'Цаоьшу',
	'wikieditor-toolbar-tool-link-int-target-status-exists' => 'Ишта агlо йолш ю',
	'wikieditor-toolbar-tool-link-int-target-status-notexists' => 'Ишта агlо яц',
	'wikieditor-toolbar-tool-link-int-target-status-invalid' => 'Ца магайо цlе',
	'wikieditor-toolbar-tool-link-int-target-status-external' => 'Арахьа хьажориг',
	'wikieditor-toolbar-tool-link-int-target-status-loading' => 'Агlо ю яц хьоьжуш…',
	'wikieditor-toolbar-tool-link-int-invalid' => 'Гойтуш йолу цlе ца магайо.',
	'wikieditor-toolbar-tool-link-lookslikeinternal' => 'Ахьа хоттийна URL кхечу вики-агlонан хьажоригах тера ю. Хьо лууш ву и хьажориг чоьхьарчех йа?',
	'wikieditor-toolbar-tool-link-lookslikeinternal-int' => 'Чоьхьа хьажориг',
	'wikieditor-toolbar-tool-link-lookslikeinternal-ext' => 'Арахьа хьажориг',
	'wikieditor-toolbar-tool-link-empty' => 'Ахьа ца гайтин мичхьа хьажойеза хьажориг.',
	'wikieditor-toolbar-tool-file' => 'Чохь йолу хlум',
	'wikieditor-toolbar-tool-file-example' => 'Example.jpg',
	'wikieditor-toolbar-tool-reference' => 'Такхо',
	'wikieditor-toolbar-tool-reference-example' => 'Чудилла кхузе такхо деза йоза',
	'wikieditor-toolbar-tool-reference-cancel' => 'Цаоьшу',
	'wikieditor-toolbar-tool-reference-title' => 'Чудилла такхо',
	'wikieditor-toolbar-tool-reference-insert' => 'Чудилла',
	'wikieditor-toolbar-tool-reference-text' => 'Такхо деза йоза',
	'wikieditor-toolbar-tool-signature' => 'Куьгтаlор хан хlоттош',
	'wikieditor-toolbar-section-advanced' => 'Кхин тlе дукха',
	'wikieditor-toolbar-tool-heading' => 'Корта',
	'wikieditor-toolbar-tool-heading-1' => 'Локхалла 1',
	'wikieditor-toolbar-tool-heading-2' => 'Локхалла 2',
	'wikieditor-toolbar-tool-heading-3' => 'Локхалла 3',
	'wikieditor-toolbar-tool-heading-4' => 'Локхалла 4',
	'wikieditor-toolbar-tool-heading-5' => 'Локхалла 5',
	'wikieditor-toolbar-tool-heading-example' => 'Коьрта йоза',
	'wikieditor-toolbar-group-format' => 'Бáрам',
	'wikieditor-toolbar-tool-ulist' => 'Къастам бина могlам',
	'wikieditor-toolbar-tool-ulist-example' => 'Къастам бина могlаман хlум',
	'wikieditor-toolbar-tool-olist' => 'Терахьца болу могlам',
	'wikieditor-toolbar-tool-olist-example' => 'Терахьца болу могlаман хlум',
	'wikieditor-toolbar-tool-indent' => 'Дlахило',
	'wikieditor-toolbar-tool-indent-example' => 'Могlа дlахилабо',
	'wikieditor-toolbar-tool-nowiki' => 'Тергал ца бо вики-бáрамхlоттор',
	'wikieditor-toolbar-tool-nowiki-example' => 'Чудилла кхузе йоза, бáрам хlотто ца оьшуш дерг',
	'wikieditor-toolbar-tool-redirect' => 'Дlасахьажор',
	'wikieditor-toolbar-tool-redirect-example' => 'Хьжочу агlонан цlе',
	'wikieditor-toolbar-tool-big' => 'Доккха',
	'wikieditor-toolbar-tool-big-example' => 'Доккха йоза',
	'wikieditor-toolbar-tool-small' => 'Жима',
	'wikieditor-toolbar-tool-small-example' => 'Жима йоза',
	'wikieditor-toolbar-tool-superscript' => 'Могlан лакха',
	'wikieditor-toolbar-tool-superscript-example' => 'Могlан лакхар йоза',
	'wikieditor-toolbar-tool-subscript' => 'Могlан буха',
	'wikieditor-toolbar-tool-subscript-example' => 'Могlан бухар йоза',
	'wikieditor-toolbar-group-insert' => 'Диллар',
	'wikieditor-toolbar-tool-gallery' => 'Дуккха суьрташ',
	'wikieditor-toolbar-tool-gallery-example' => '$1:Example.jpg|Цуьнах лаце1
$1:Example.jpg|Цуьнах лаце2',
	'wikieditor-toolbar-tool-newline' => 'Керла могlа',
	'wikieditor-toolbar-tool-table' => 'Таблийца',
	'wikieditor-toolbar-tool-table-example-old' => '-
! коьрта могlа 1
! коьрта могlа 2
! коьрта могlа 3
|-
| могlа 1, чоь 1
| могlа 1, чоь 2
| могlа 1, чоь 3
|-
| могlа 2, чоь 1
| могlа 2, чоь 2
| могlа 2, чоь 3',
	'wikieditor-toolbar-tool-table-example-cell-text' => 'Чоьнан йоза',
	'wikieditor-toolbar-tool-table-example-header' => 'Коьрта йоза',
	'wikieditor-toolbar-tool-table-title' => 'Чуйилла таблийца',
	'wikieditor-toolbar-tool-table-dimensions-rows' => 'Могlнаш',
	'wikieditor-toolbar-tool-table-dimensions-columns' => 'Бlогlамаш',
	'wikieditor-toolbar-tool-table-dimensions-header' => 'Тlетоха коьрта могlан могlа',
	'wikieditor-toolbar-tool-table-wikitable' => 'Кечйеш дозанашца',
	'wikieditor-toolbar-tool-table-sortable' => 'Листалуш йе таблийца',
	'wikieditor-toolbar-tool-table-example' => 'Чоьнан йоза',
	'wikieditor-toolbar-tool-table-preview' => 'Хьалха муха ю хьажа',
	'wikieditor-toolbar-tool-table-insert' => 'Чуйилла',
	'wikieditor-toolbar-tool-table-cancel' => 'Цаоьшу',
	'wikieditor-toolbar-tool-table-toomany' => 'Оцул чоьнаш йа аьтту ца болу, таблийцан чоьнашна бáрам $1 хоттало.',
	'wikieditor-toolbar-tool-table-invalidnumber' => 'Ахьа нийса ца хоттийн цхьатерра могlанаш ле бlогlамаш.',
	'wikieditor-toolbar-tool-table-zero' => 'Хьога йиллалур яц таблийца йоцургца могlанаш ле бlогlамаш долуш.',
	'wikieditor-toolbar-tool-replace' => 'Лаха хийца аъ хуьйцуш',
	'wikieditor-toolbar-tool-replace-title' => 'Лаха хийца аъ хуьйцуш',
	'wikieditor-toolbar-tool-replace-search' => 'Лаха:',
	'wikieditor-toolbar-tool-replace-replace' => 'Хийца оцуьнца:',
	'wikieditor-toolbar-tool-replace-case' => 'Яздар тидаме оьцуш',
	'wikieditor-toolbar-tool-replace-regex' => 'Хилийта могlа юх-юха лохуш долу дош',
	'wikieditor-toolbar-tool-replace-button-findnext' => 'Караде тlаьхьадогlург',
	'wikieditor-toolbar-tool-replace-button-replaceall' => 'Деригге хийца',
	'wikieditor-toolbar-tool-replace-close' => 'Дlачlагlа',
	'wikieditor-toolbar-tool-replace-nomatch' => 'Хьан дехарца хlумма ца карийна.',
	'wikieditor-toolbar-tool-replace-success' => 'Балийна хийцам: $1.',
	'wikieditor-toolbar-tool-replace-emptysearch' => 'Ахьа ца гайтна хlу лаха деза.',
	'wikieditor-toolbar-tool-replace-invalidregex' => 'Ахьа язйина цlе юх-юха нийса яц: $1',
	'wikieditor-toolbar-section-characters' => 'Саболу куьцаш',
	'wikieditor-toolbar-characters-page-latin' => 'Латинхойн',
	'wikieditor-toolbar-characters-page-latinextended' => 'Латинхойн аллсам',
	'wikieditor-toolbar-characters-page-ipa' => 'ДАЭ (IPA)',
	'wikieditor-toolbar-characters-page-symbols' => 'Саболурш',
	'wikieditor-toolbar-characters-page-greek' => 'Гlайрхойн',
	'wikieditor-toolbar-characters-page-cyrillic' => 'Кирилан',
	'wikieditor-toolbar-characters-page-arabic' => 'Iарбойн',
	'wikieditor-toolbar-characters-page-persian' => 'Пхьарсхойн',
	'wikieditor-toolbar-characters-page-hebrew' => 'Жуьгтийн',
	'wikieditor-toolbar-characters-page-bangla' => 'Бангалойн',
	'wikieditor-toolbar-characters-page-telugu' => 'Телугойн',
	'wikieditor-toolbar-characters-page-sinhala' => 'Синхалойн',
	'wikieditor-toolbar-characters-page-gujarati' => 'Гужаратойн',
	'wikieditor-toolbar-characters-page-thai' => 'Тайхойн',
	'wikieditor-toolbar-characters-page-lao' => 'Лаохойн',
	'wikieditor-toolbar-characters-page-khmer' => 'Кхимерхойн',
	'wikieditor-toolbar-section-help' => 'Нисвохаам',
	'wikieditor-toolbar-help-heading-description' => 'Цуьнах лаьцна',
	'wikieditor-toolbar-help-heading-syntax' => 'Хlу йуьллу ахьа',
	'wikieditor-toolbar-help-heading-result' => 'Хlу хуьлу хьуна',
	'wikieditor-toolbar-help-page-format' => 'Бáрамхlоттор',
	'wikieditor-toolbar-help-page-link' => 'Хьажоригаш',
	'wikieditor-toolbar-help-page-heading' => 'Коьрта могlнаш',
	'wikieditor-toolbar-help-page-list' => 'Могlамаш',
	'wikieditor-toolbar-help-page-file' => 'Хlумнаш',
	'wikieditor-toolbar-help-page-reference' => 'Билгалдаккхар',
	'wikieditor-toolbar-help-page-discussion' => 'Дийцаре',
	'wikieditor-toolbar-help-content-italic-description' => 'Курсетта',
	'wikieditor-toolbar-help-content-italic-syntax' => "''Курсеттан до йоза''",
	'wikieditor-toolbar-help-content-italic-result' => '<em>Курсеттан до йоза</em>',
	'wikieditor-toolbar-help-content-bold-description' => 'Дерстино',
	'wikieditor-toolbar-help-content-bold-syntax' => "'''Дерстино до йоза'''",
	'wikieditor-toolbar-help-content-bold-result' => '<strong>Дерстино до йоза</strong>',
	'wikieditor-toolbar-help-content-bolditalic-description' => 'Дерстино курсеттан',
	'wikieditor-toolbar-help-content-bolditalic-syntax' => "'''''Дерстино курсеттан'''''",
	'wikieditor-toolbar-help-content-bolditalic-result' => '<em><strong>Дерстино курсеттан</strong></em>',
	'wikieditor-toolbar-help-content-ilink-description' => 'Чоьхьа хьажориг',
	'wikieditor-toolbar-help-content-ilink-syntax' => '[[Агlонан коьрта могlа|Хьажориган йоза]]<br />[[Агlонан коьрта могlа]]',
	'wikieditor-toolbar-help-content-ilink-result' => "<a href='#'>Хьажориган йоза</a><br /><a href='#'>Агlонан коьрта могlа</a>",
	'wikieditor-toolbar-help-content-xlink-description' => 'Арахьа хьажориг',
	'wikieditor-toolbar-help-content-xlink-syntax' => '[http://www.example.org Хьажориган йоза]<br />[http://www.example.org]<br />http://www.example.org',
	'wikieditor-toolbar-help-content-xlink-result' => "<a href='#' class='external'>Хьажориган йоза</a><br /><a href='#' class='external autonumber'>[1]</a><br /><a href='#' class='external'>http://www.example.org</a>",
	'wikieditor-toolbar-help-content-heading2-description' => 'Коьрта могlа 2-гlа локхалла',
	'wikieditor-toolbar-help-content-heading2-syntax' => '== Коьрта могlан йоза ==',
	'wikieditor-toolbar-help-content-heading2-result' => '<h2>Коьрта могlан йоза</h2>',
	'wikieditor-toolbar-help-content-heading3-description' => 'Коьрта могlа 3-гlа локхалла',
	'wikieditor-toolbar-help-content-heading3-syntax' => '=== Коьрта могlан йоза ===',
	'wikieditor-toolbar-help-content-heading3-result' => '<h3>Коьрта могlан йоза</h3>',
	'wikieditor-toolbar-help-content-heading4-description' => 'Коьрта могlа 4-гlа локхалла',
	'wikieditor-toolbar-help-content-heading4-syntax' => '==== Коьрта могlан йоза ====',
	'wikieditor-toolbar-help-content-heading4-result' => '<h4>Коьрта могlан йоза</h4>',
	'wikieditor-toolbar-help-content-heading5-description' => 'Коьрта могlа 5-гlа локхалла',
	'wikieditor-toolbar-help-content-heading5-syntax' => '===== Коьрта могlан йоза =====',
	'wikieditor-toolbar-help-content-heading5-result' => '<h5>Коьрта могlан йоза</h5>',
	'wikieditor-toolbar-help-content-ulist-description' => 'Къастам бина могlам',
	'wikieditor-toolbar-help-content-ulist-syntax' => '* Могlаман хlум<br />* Могlаман хlум',
	'wikieditor-toolbar-help-content-ulist-result' => '<ul><li>Могlаман хlум</li><li>Могlаман хlум</li></ul>',
	'wikieditor-toolbar-help-content-olist-description' => 'Терахьца болу могlам',
	'wikieditor-toolbar-help-content-olist-syntax' => '# Могlаман хlум<br /># Могlаман хlум',
	'wikieditor-toolbar-help-content-olist-result' => '<ol><li>Могlаман хlум</li><li>Могlаман хlум</li></ol>',
	'wikieditor-toolbar-help-content-file-description' => 'Чохь йолу хlум',
	'wikieditor-toolbar-help-content-file-syntax' => '[[$1:Example.png|thumb|Оцуьнах лаьцна йоза]]',
	'wikieditor-toolbar-help-content-file-result' => "<div style='width:104px;' class='thumbinner'><a title='
Оцуьнах лаьцна йоза' class='image' href='#'><img height='50' width='100' border='0' class='thumbimage' src='$2/WikiEditor/modules/images/toolbar/example-image.png' alt=''/></a><div class='thumbcaption'><div class='magnify'><a title='Доккха дан' class='internal' href='#'><img height='11' width='15' alt='' src='$1/common/images/magnify-clip.png'/></a></div>
Оцуьнах лаьцна йоза</div></div>",
	'wikieditor-toolbar-help-content-reference-description' => 'Билгалдаккхар',
	'wikieditor-toolbar-help-content-reference-syntax' => 'Агlонан йоза.&lt;ref name="test"&gt;[http://www.example.org Хьажориган йоза], кхин тlе дузуш йоза.&lt;/ref&gt;',
	'wikieditor-toolbar-help-content-reference-result' => "Агlонан йоза.<sup><a href='#'>[1]</a></sup>",
	'wikieditor-toolbar-help-content-rereference-description' => 'Кхин тlе лело изза хьажориг',
	'wikieditor-toolbar-help-content-rereference-result' => "Агlонан йоза<sup><a href='#'>[1]</a></sup>.",
	'wikieditor-toolbar-help-content-showreferences-description' => 'Гайта билгалдаккхар',
	'wikieditor-toolbar-help-content-showreferences-result' => "<ol class='references'><li id='cite_note-test-0'><b><a title='' href='#'>^</a></b> <a rel='nofollow' title='http://www.example.org' class='external text' href='#'>Хьажориган йоза</a>, кхин тlе дузуш йоза.</li></ol>",
	'wikieditor-toolbar-help-content-signaturetimestamp-description' => 'Куьгтаlор хан хlоттош',
	'wikieditor-toolbar-help-content-signaturetimestamp-result' => "<a href='#' title='{{#special:mypage}}'>Декъашхон цlе</a> (<a href='#' title='{{#special:mytalk}}'>дийцаре</a>) 15:54, 10 Мангал бутт 2009 (UTC)",
	'wikieditor-toolbar-help-content-signature-description' => 'Куьгтаlор',
	'wikieditor-toolbar-help-content-signature-result' => "<a href='#' title='{{#special:mypage}}'>Декъашхон цlе</a> (<a href='#' title='{{#special:mytalk}}'>дийцаре</a>)",
	'wikieditor-toolbar-help-content-indent-description' => 'Дlахило',
	'wikieditor-toolbar-help-content-indent-syntax' => 'Гуттарлера йоза<br />:Дlахилийна йоза<br />::Дlахилийна йоза',
	'wikieditor-toolbar-help-content-indent-result' => 'Гуттарлера йоза<dl><dd>Дlахилийна йоза<dl><dd>Дlахилийна йоза</dd></dl></dd></dl>',
);

/** Sorani Kurdish (کوردی)
 * @author Asoxor
 * @author Calak
 * @author Marmzok
 * @author McDutchie
 * @author Muhammed taha
 */
$messages['ckb'] = array(
	'wikieditor' => 'ڕووکاری پێشکەوتووی دەستکاریکردنی ویکیدەق',
	'wikieditor-wikitext-tab' => 'ویکیدەق',
	'wikieditor-loading' => 'بارکردن',
	'wikieditor-preview-preference' => 'ڕێگەپێدان بە پێشبینینی شانبەشان',
	'wikieditor-preview-tab' => 'پێشبینین',
	'wikieditor-preview-changes-tab' => 'گۆڕانکارییەکان',
	'wikieditor-preview-loading' => 'باركردن‌ ...',
	'wikieditor-previewDialog-preference' => 'ڕێگە بدە بە پەنجەرەی پێشبینین',
	'wikieditor-previewDialog-tab' => 'پێشبینین',
	'wikieditor-previewDialog-loading' => 'باركردن‌ ...',
	'wikieditor-publish-preference' => 'ڕێگە بدە بە بڵاوکردنەوەی ھەنگاوبەھەنگاو',
	'wikieditor-publish-button-publish' => 'بڵاوی بکەوە',
	'wikieditor-publish-button-cancel' => 'ھەڵوەشاندنەوە',
	'wikieditor-publish-dialog-title' => 'لە {{SITENAME}} بڵاوی بکەوە',
	'wikieditor-publish-dialog-summary' => 'پوختەی دەستکاری (بە کورتی ئەی گۆڕانکارییانەی کردووتە ئاشکرا دەکاتەوە):',
	'wikieditor-publish-dialog-minor' => 'دەستکاریی بچووک',
	'wikieditor-publish-dialog-watch' => 'ئەم پەڕەیە بخە ژێر چاودێری',
	'wikieditor-publish-dialog-publish' => 'بڵاوی بکەوە',
	'wikieditor-publish-dialog-goback' => 'بگەڕێوە',
	'wikieditor-template-editor-preference' => 'ڕێگە بدە بە دەستکاریکردنی وەک فۆرم بۆ داڕێژەکانی ویکی',
	'wikieditor-template-editor-dialog-title' => 'دەستکاریکردنی دارێژە',
	'wikieditor-template-editor-dialog-submit' => 'نوێ کردنەوە',
	'wikieditor-template-editor-dialog-cancel' => 'ھەڵوەشاندنەوە',
	'wikieditor-templates-preference' => 'مۆڵەتدانی کۆکردنەوەی داڕێژە',
	'wikieditor-toc-preference' => 'خستنەکاری خشتە ڕێدۆزەکانی ناوەڕۆک',
	'wikieditor-toc-show' => 'ناوەرۆک نیشانبدە',
	'wikieditor-toc-hide' => 'شاردنەوەی ناوەڕۆک',
	'wikieditor-toolbar' => 'شریتامرازی دەستکاریکردن',
	'wikieditor-toolbar-desc' => 'شریتامرازی پەڕەی دەستکاریکردن بە کارەمەیی پەرەپێدراو',
	'wikieditor-toolbar-preference' => 'ڕێگە بدە بە شریتامرازی پەرەسندووی دەستکاری کردن',
	'wikieditor-toolbar-dialogs-preference' => 'ڕێگە بدە بە پەنجەرە وتووێژییەکان بۆ تێخستنی بەستەرەکان، خشتەکان و ھتد.',
	'wikieditor-toolbar-loading' => 'خەریکی بارکردن...',
	'wikieditor-toolbar-tool-bold' => 'تۆخ',
	'wikieditor-toolbar-tool-bold-example' => 'دەقی تۆخ',
	'wikieditor-toolbar-tool-italic' => 'لار',
	'wikieditor-toolbar-tool-italic-example' => 'دەقی لار',
	'wikieditor-toolbar-tool-ilink' => 'بەستەری ناوەکی',
	'wikieditor-toolbar-tool-ilink-example' => 'سەردێڕی بەستەر',
	'wikieditor-toolbar-tool-xlink' => 'بەستەری دەرەکی (پێشگری http:// لەبیرنەکەی)',
	'wikieditor-toolbar-tool-xlink-example' => 'http://www.example.com سەردێڕی بەستەر',
	'wikieditor-toolbar-tool-link' => 'بەستەر',
	'wikieditor-toolbar-tool-link-title' => 'دانانی بەستەر',
	'wikieditor-toolbar-tool-link-int' => 'بە پەڕەیەکی ویکی',
	'wikieditor-toolbar-tool-link-int-target' => 'پەڕەی مەبەست یان URL:',
	'wikieditor-toolbar-tool-link-int-target-tooltip' => 'ناونیشانی پەڕە یان URL',
	'wikieditor-toolbar-tool-link-int-text' => 'دەق بۆ نیشاندان:',
	'wikieditor-toolbar-tool-link-int-text-tooltip' => 'دقێک کە نیشان ئەدرێت',
	'wikieditor-toolbar-tool-link-ext' => 'بۆ وێب‌پەڕەیەکی دەرەکی',
	'wikieditor-toolbar-tool-link-ext-target' => 'بەستەری URL:',
	'wikieditor-toolbar-tool-link-ext-text' => 'دەقی بەستەر:',
	'wikieditor-toolbar-tool-link-insert' => 'دانانی بەستەر',
	'wikieditor-toolbar-tool-link-cancel' => 'ھەڵوەشاندنەوە',
	'wikieditor-toolbar-tool-link-int-target-status-exists' => 'پەڕەکە ھەیە',
	'wikieditor-toolbar-tool-link-int-target-status-notexists' => 'پەڕە بوونی نییە',
	'wikieditor-toolbar-tool-link-int-target-status-invalid' => 'ناونیشان ھەڵە',
	'wikieditor-toolbar-tool-link-int-target-status-external' => 'بەستەری دەرەکی',
	'wikieditor-toolbar-tool-link-int-target-status-loading' => 'پشکنینی ھەبوونی پەڕە ...',
	'wikieditor-toolbar-tool-link-int-invalid' => 'ئەو ناونیشانە دەستنیشانت کردووە نادروستە',
	'wikieditor-toolbar-tool-link-lookslikeinternal' => 'ئەو ناونیشانەی ڕەچاوت کردووە لەوەدەچێ بەستەرێک بێت بۆ پەڕەیەکی ویکی دیکە. ئایا دەتەوێ بیکەی بە بەستەرێکی ناوەکی؟',
	'wikieditor-toolbar-tool-link-lookslikeinternal-int' => 'بەستەری ناوخۆ',
	'wikieditor-toolbar-tool-link-lookslikeinternal-ext' => 'بەستەری دەرەکی',
	'wikieditor-toolbar-tool-link-empty' => 'ھیچێک بۆ بەستەر بۆ کردن نەخستە ناوی',
	'wikieditor-toolbar-tool-file' => 'پەڕگەی نێودەق',
	'wikieditor-toolbar-tool-file-example' => 'نموونە.jpg',
	'wikieditor-toolbar-file-target' => 'ناوی پەرگە:',
	'wikieditor-toolbar-file-format' => 'داڕشتن:',
	'wikieditor-toolbar-tool-file-insert' => 'تێخستن',
	'wikieditor-toolbar-tool-file-cancel' => 'ھەڵوەشاندنەوە',
	'wikieditor-toolbar-tool-reference' => 'سەرچاوە',
	'wikieditor-toolbar-tool-reference-example' => 'دەقی پانووس بخەرە ئێرە',
	'wikieditor-toolbar-tool-reference-cancel' => 'ھەڵوەشاندنەوە',
	'wikieditor-toolbar-tool-reference-title' => 'زۆرکردنی سەرچاوە',
	'wikieditor-toolbar-tool-reference-insert' => 'تێخستن',
	'wikieditor-toolbar-tool-reference-text' => 'دەقی سەرچاوە',
	'wikieditor-toolbar-tool-signature' => 'واژۆ و ڕێکەوت',
	'wikieditor-toolbar-section-advanced' => 'پەرەسەندوو',
	'wikieditor-toolbar-tool-heading' => 'سەردێڕ',
	'wikieditor-toolbar-tool-heading-1' => 'ئاستی ١',
	'wikieditor-toolbar-tool-heading-2' => 'ئاستی ٢',
	'wikieditor-toolbar-tool-heading-3' => 'ئاستی ٣',
	'wikieditor-toolbar-tool-heading-4' => 'ئاستی ٤',
	'wikieditor-toolbar-tool-heading-5' => 'ئاستی ٥',
	'wikieditor-toolbar-tool-heading-example' => 'دەقی سەردێڕ',
	'wikieditor-toolbar-group-format' => 'داڕشتن',
	'wikieditor-toolbar-tool-ulist' => 'لیستی خاڵبەندکراو',
	'wikieditor-toolbar-tool-ulist-example' => 'ئەندامی لیستی خاڵبەندکراو',
	'wikieditor-toolbar-tool-olist' => 'لیستی ژمارەکراو',
	'wikieditor-toolbar-tool-olist-example' => 'ئەندامی لیستی ژمارەکراو',
	'wikieditor-toolbar-tool-indent' => 'پێشبردن',
	'wikieditor-toolbar-tool-indent-example' => 'ھێڵی پێشبراو',
	'wikieditor-toolbar-tool-nowiki' => 'بەکارنەھێنانی فۆڕماتەکانی ویکی',
	'wikieditor-toolbar-tool-nowiki-example' => 'ئەو دەقەی دەتەوێ بێ فۆڕمات بێت لێرە دابنە',
	'wikieditor-toolbar-tool-redirect' => 'ڕەوانەکردن',
	'wikieditor-toolbar-tool-redirect-example' => 'ناوی پەڕەی مەبەست',
	'wikieditor-toolbar-tool-big' => 'گەورە',
	'wikieditor-toolbar-tool-big-example' => 'دەقی گەورە',
	'wikieditor-toolbar-tool-small' => 'بچووک',
	'wikieditor-toolbar-tool-small-example' => 'دەقی بچووک',
	'wikieditor-toolbar-tool-superscript' => 'سەرنووس',
	'wikieditor-toolbar-tool-superscript-example' => 'دەقی سەرنووس',
	'wikieditor-toolbar-tool-subscript' => 'ژێرنووس',
	'wikieditor-toolbar-tool-subscript-example' => 'دەقی ژێرنووس',
	'wikieditor-toolbar-group-insert' => 'تێخستن',
	'wikieditor-toolbar-tool-gallery' => 'گالێری وێنە',
	'wikieditor-toolbar-tool-gallery-example' => '$1:نموونە.jpg|شرۆڤەی ١
$1:نموونە.jpg|شرۆڤەی ٢',
	'wikieditor-toolbar-tool-newline' => 'ھێڵی نوێ',
	'wikieditor-toolbar-tool-table' => 'خشتە',
	'wikieditor-toolbar-tool-table-example-old' => '-
! سەردێڕی ١
! سەردێڕی ٢
! سەردێڕی ٣
|-
| ڕیزی ١، خانەی ١
| ڕیزی ١، خانەی ٢
| ڕیزی ١، خانەی ٣
|-
| ڕیزی ٢، خانەی ١
| ڕیزی ٢، خانەی ٢
| ڕیزی ٢، خانەی ٣',
	'wikieditor-toolbar-tool-table-example-cell-text' => 'دەقی خانە',
	'wikieditor-toolbar-tool-table-example-header' => 'دەقی سەردێڕ',
	'wikieditor-toolbar-tool-table-title' => 'دانانی خشتە',
	'wikieditor-toolbar-tool-table-dimensions-rows' => 'ڕیزەکان',
	'wikieditor-toolbar-tool-table-dimensions-columns' => 'ستوونەکان',
	'wikieditor-toolbar-tool-table-dimensions-header' => 'زیادکردنی ڕیزی سەردێڕ',
	'wikieditor-toolbar-tool-table-wikitable' => 'شێوازی بەقەراغ',
	'wikieditor-toolbar-tool-table-sortable' => 'با خشتەکە بە ڕیز بکرێت',
	'wikieditor-toolbar-tool-table-example' => 'نموونە',
	'wikieditor-toolbar-tool-table-preview' => 'پێشبینین',
	'wikieditor-toolbar-tool-table-insert' => 'تێخستن',
	'wikieditor-toolbar-tool-table-cancel' => 'ھەڵوەشاندنەوە',
	'wikieditor-toolbar-tool-table-toomany' => 'تێخستنی خشتەیەک بە زۆرتر لە $1 خانەوە بەم ئامرازەوە ناکرێ.',
	'wikieditor-toolbar-tool-table-invalidnumber' => 'ژمارەیەکی دروستت بۆ ڕیزەکان یان ستوونەکان نەداوە.',
	'wikieditor-toolbar-tool-table-zero' => 'ناتوانی خشتەیەک بێ ھیچ ڕیز یان ستوونێک تێبخەی',
	'wikieditor-toolbar-tool-replace' => 'دۆزینەوە و لەجێدانان',
	'wikieditor-toolbar-tool-replace-title' => 'بیدۆزەوە و لەجێیدانە',
	'wikieditor-toolbar-tool-replace-search' => 'بگەڕێ بۆ:',
	'wikieditor-toolbar-tool-replace-replace' => 'جێبەجێی بکە لەگەڵ:',
	'wikieditor-toolbar-tool-replace-case' => 'کوت و مت وەک خۆی',
	'wikieditor-toolbar-tool-replace-regex' => 'لەگەڵ نووسەی گەڕانەکە وەک دەقی ڕێک ھەڵسوکەوت بکە',
	'wikieditor-toolbar-tool-replace-button-findnext' => 'دوای ئەمە بدۆزەوە',
	'wikieditor-toolbar-tool-replace-button-replaceall' => 'ھەموویان جێگیر بکە',
	'wikieditor-toolbar-tool-replace-close' => 'دایخە',
	'wikieditor-toolbar-tool-replace-nomatch' => 'گەڕانەکەت لەگەڵ ھیچ شتێک نەگونجا.',
	'wikieditor-toolbar-tool-replace-success' => '$1 جێگرتنەوە ئەنجامدرا.',
	'wikieditor-toolbar-tool-replace-emptysearch' => 'ھیچ شتێکت بۆ گەڕان ڕەچاو نەکردوو.',
	'wikieditor-toolbar-tool-replace-invalidregex' => 'ئەو regular expression کە نووسیوتە گونجاو نییە: $1',
	'wikieditor-toolbar-section-characters' => 'نووسە تایبەتەکان',
	'wikieditor-toolbar-characters-page-latin' => 'لاتینی',
	'wikieditor-toolbar-characters-page-latinextended' => 'لاتینیی پەرەپێدراو',
	'wikieditor-toolbar-characters-page-ipa' => 'ئای پی ئەی',
	'wikieditor-toolbar-characters-page-symbols' => 'ھێماکان',
	'wikieditor-toolbar-characters-page-greek' => 'یۆنانی',
	'wikieditor-toolbar-characters-page-cyrillic' => 'کیریلی',
	'wikieditor-toolbar-characters-page-arabic' => 'عەرەبی',
	'wikieditor-toolbar-characters-page-arabicextended' => 'عەرەبیی پەرەپێدراو',
	'wikieditor-toolbar-characters-page-persian' => 'فارسی',
	'wikieditor-toolbar-characters-page-hebrew' => 'عیبری',
	'wikieditor-toolbar-characters-page-bangla' => 'بەنگالی',
	'wikieditor-toolbar-characters-page-telugu' => 'تێلوگو',
	'wikieditor-toolbar-characters-page-sinhala' => 'سینھالا',
	'wikieditor-toolbar-characters-page-gujarati' => 'گوجەراتی',
	'wikieditor-toolbar-characters-page-thai' => 'تایلەندی',
	'wikieditor-toolbar-characters-page-khmer' => 'خمێری',
	'wikieditor-toolbar-section-help' => 'یارمەتی',
	'wikieditor-toolbar-help-heading-description' => 'وەسف',
	'wikieditor-toolbar-help-heading-syntax' => 'ئەوی تایپی دەکەی',
	'wikieditor-toolbar-help-heading-result' => 'ئەوەی بەدەستی دێنی',
	'wikieditor-toolbar-help-page-format' => 'ڕازاندنەوە',
	'wikieditor-toolbar-help-page-link' => 'بەستەرەکان',
	'wikieditor-toolbar-help-page-heading' => 'سەردێڕەکان',
	'wikieditor-toolbar-help-page-list' => 'لیستەکان',
	'wikieditor-toolbar-help-page-file' => 'پەڕگەکان',
	'wikieditor-toolbar-help-page-reference' => 'سەرچاوەکان',
	'wikieditor-toolbar-help-page-discussion' => 'وتووێژ',
	'wikieditor-toolbar-help-content-italic-description' => 'لار',
	'wikieditor-toolbar-help-content-italic-syntax' => "''دەقی لار''",
	'wikieditor-toolbar-help-content-italic-result' => '<em>دەقی لار</em>',
	'wikieditor-toolbar-help-content-bold-description' => 'تۆخ',
	'wikieditor-toolbar-help-content-bold-syntax' => "'''دەقی تۆخ'''",
	'wikieditor-toolbar-help-content-bold-result' => '<strong>دەقی تۆخ</strong>',
	'wikieditor-toolbar-help-content-bolditalic-description' => 'تۆخ و لار',
	'wikieditor-toolbar-help-content-bolditalic-syntax' => "'''''دەقی تۆخ و لار'''''",
	'wikieditor-toolbar-help-content-bolditalic-result' => '<strong><em>دەقی تۆخ و لار</em></strong>',
	'wikieditor-toolbar-help-content-ilink-description' => 'بەستەری ناوەکی',
	'wikieditor-toolbar-help-content-ilink-syntax' => '[[ناونیشانی پەڕە|نازناوی بەستەر]]<br />[[ناونیشانی پەڕە]]',
	'wikieditor-toolbar-help-content-ilink-result' => "<a href='#'>نازناوی بەستەر</a><br /><a href='#'>ناونیشانی پەڕە</a>",
	'wikieditor-toolbar-help-content-xlink-description' => 'بەستەری دەرەکی',
	'wikieditor-toolbar-help-content-xlink-syntax' => '[http://www.example.org سەردێڕی بەستەر]<br />[http://www.example.org]<br />http://www.example.org',
	'wikieditor-toolbar-help-content-xlink-result' => "<a href='#' class='external'>سەردێڕی بەستەر</a><br /><a href='#' class='external autonumber'>[1]</a><br /><a href='#' class='external'>http://www.example.org</a>",
	'wikieditor-toolbar-help-content-heading2-description' => 'سەردێڕی ئاستی دووهەم',
	'wikieditor-toolbar-help-content-heading2-syntax' => '== دەقی سەردێڕ ==',
	'wikieditor-toolbar-help-content-heading2-result' => '<h2>دەقی سەردێڕ</h2>',
	'wikieditor-toolbar-help-content-heading3-description' => 'سەردێڕی ئاستی سێهەم',
	'wikieditor-toolbar-help-content-heading3-syntax' => '=== دەقی سەردێڕ ===',
	'wikieditor-toolbar-help-content-heading3-result' => '<h3>دەقی سەردێڕ</h3>',
	'wikieditor-toolbar-help-content-heading4-description' => 'سەردێڕی ئاستی چوارەم',
	'wikieditor-toolbar-help-content-heading4-syntax' => '==== دەقی سەردێڕ ====',
	'wikieditor-toolbar-help-content-heading4-result' => '<h4>دەقی سەردێڕ</h4>',
	'wikieditor-toolbar-help-content-heading5-description' => 'سەردێڕی ئاستی پەنجەم',
	'wikieditor-toolbar-help-content-heading5-syntax' => '===== دەقی سەردێڕ =====',
	'wikieditor-toolbar-help-content-heading5-result' => '<h5>دەقی سەردێڕ</h5>',
	'wikieditor-toolbar-help-content-ulist-description' => 'لیستی خاڵبەندکراو',
	'wikieditor-toolbar-help-content-ulist-syntax' => '* ئەندامی لیست<br />* ئەندامی لیست',
	'wikieditor-toolbar-help-content-ulist-result' => '<ul><li>ئەندامی لیست</li><li>ئەندامی لیست</li></ul>',
	'wikieditor-toolbar-help-content-olist-description' => 'لیستی ژمارەکراو',
	'wikieditor-toolbar-help-content-olist-syntax' => '# ئەندامی لیست<br /># ئەندامی لیست',
	'wikieditor-toolbar-help-content-olist-result' => '<ol><li>ئەندامی لیست</li><li>ئەندامی لیست</li></ol>',
	'wikieditor-toolbar-help-content-file-description' => 'پەڕگەی نێودەق',
	'wikieditor-toolbar-help-content-file-syntax' => '[[$1:Example.png|thumb|دەقی شرۆڤە]]',
	'wikieditor-toolbar-help-content-file-result' => "<div style='width:104px;' class='thumbinner'><a title='دەقی شرۆڤە' class='image' href='#'><img height='50' width='100' border='0' class='thumbimage' src='$2/WikiEditor/modules/images/toolbar/example-image.png' alt=''/></a><div class='thumbcaption'><div class='magnify'><a title='گەورەکردنەوە' class='internal' href='#'><img height='11' width='15' alt='' src='$1/common/images/magnify-clip.png'/></a></div>دەقی شرۆڤە</div></div>",
	'wikieditor-toolbar-help-content-reference-description' => 'سەرچاوە',
	'wikieditor-toolbar-help-content-reference-syntax' => 'دەقی پەڕە.&lt;ref name="test"&gt;[http://www.example.org دەقی بەستەر], دەقی زیادی.&lt;/ref&gt;',
	'wikieditor-toolbar-help-content-reference-result' => "دەقی پەڕە.<sup><a href='#'>[1]</a></sup>",
	'wikieditor-toolbar-help-content-rereference-description' => 'بەکارھێنانی دیکەی ئەو سەرچاوەیە',
	'wikieditor-toolbar-help-content-rereference-result' => "دەقی پەڕە.<sup><a href='#'>[1]</a></sup>",
	'wikieditor-toolbar-help-content-showreferences-description' => 'نیشان‌دانی سەرچاوەکان',
	'wikieditor-toolbar-help-content-showreferences-result' => "<ol class='references'><li id='cite_note-test-0'><b><a title='' href='#'>^</a></b> <a rel='nofollow' title='http://www.example.org' class='external text' href='#'>دەقی بەستەر</a>, دەقی زیادی.</li></ol>",
	'wikieditor-toolbar-help-content-signaturetimestamp-description' => 'واژۆ لەگەڵ ڕێکەوتدا',
	'wikieditor-toolbar-help-content-signaturetimestamp-result' => "<a href='#' title='{{#special:mypage}}'>ناوی بەکارھێنەر</a> (<a href='#' title='{{#special:mytalk}}'>لێدوان</a>) 15:54, 10 June 2009 (UTC)",
	'wikieditor-toolbar-help-content-signature-description' => 'واژۆ',
	'wikieditor-toolbar-help-content-signature-result' => "<a href='#' title='{{#special:mypage}}'>ناوی بەکارھێنەر</a> (<a href='#' title='{{#special:mytalk}}'>لێدوان</a>)",
	'wikieditor-toolbar-help-content-indent-description' => 'پێشبردن',
	'wikieditor-toolbar-help-content-indent-syntax' => 'دەقی ئاسایی<br />:دەقی پێشچوو<br />::دەقی پێشچوو',
	'wikieditor-toolbar-help-content-indent-result' => 'دەقی ئاسایی<dl><dd>دەقی پێشچوو<dl><dd>دەقی پێشچوو</dd></dl></dd></dl>',
);

/** Corsican (corsu) */
$messages['co'] = array(
	'wikieditor-toolbar-tool-heading-1' => 'Livellu 1',
	'wikieditor-toolbar-tool-heading-2' => 'Livellu 2',
	'wikieditor-toolbar-tool-heading-3' => 'Livellu 3',
	'wikieditor-toolbar-tool-heading-4' => 'Livellu 4',
	'wikieditor-toolbar-tool-heading-5' => 'Livellu 5',
);

/** Czech (česky)
 * @author Jkjk
 * @author Kuvaly
 * @author Mormegil
 */
$messages['cs'] = array(
	'wikieditor' => 'Vylepšené rozhraní pro editaci wikitextu',
	'wikieditor-desc' => 'Poskytuje rozšiřitelné editační rozhraní a mnoho modulů s novými funkcemi',
	'wikieditor-wikitext-tab' => 'Wikitext',
	'wikieditor-loading' => 'Načítá se',
	'wikieditor-preview-preference' => 'Zapnout náhledy v panelu',
	'wikieditor-preview-tab' => 'Náhled',
	'wikieditor-preview-changes-tab' => 'Změny',
	'wikieditor-preview-loading' => 'Načítá se…',
	'wikieditor-previewDialog-preference' => 'Používat dialog pro náhled',
	'wikieditor-previewDialog-tab' => 'Náhled',
	'wikieditor-previewDialog-loading' => 'Načítá se…',
	'wikieditor-publish-preference' => 'Zapnout průvodce publikováním',
	'wikieditor-publish-button-publish' => 'Publikovat',
	'wikieditor-publish-button-cancel' => 'Storno',
	'wikieditor-publish-dialog-title' => 'Publikovat do {{grammar:2sg|{{SITENAME}}}}',
	'wikieditor-publish-dialog-summary' => 'Shrnutí editace (stručně popište provedené změny):',
	'wikieditor-publish-dialog-minor' => 'Malá editace',
	'wikieditor-publish-dialog-watch' => 'Sledovat tuto stránku',
	'wikieditor-publish-dialog-publish' => 'Publikovat',
	'wikieditor-publish-dialog-goback' => 'Zpět',
	'wikieditor-template-editor-preference' => 'Zapnout formulářovou editaci šablon wiki',
	'wikieditor-template-editor-dialog-title' => 'Upravit šablonu',
	'wikieditor-template-editor-dialog-submit' => 'Aktualizovat',
	'wikieditor-template-editor-dialog-cancel' => 'Storno',
	'wikieditor-templates-preference' => 'Zapnout sbalování šablon',
	'wikieditor-toc-preference' => 'Zapnout navigovatelný obsah',
	'wikieditor-toc-show' => 'Zobrazit obsah',
	'wikieditor-toc-hide' => 'Skrýt obsah',
	'wikieditor-toolbar' => 'Editační panel nástrojů',
	'wikieditor-toolbar-desc' => 'Editační panel nástrojů s vylepšenou použitelností',
	'wikieditor-toolbar-preference' => 'Zapnout vylepšený panel nástrojů',
	'wikieditor-toolbar-dialogs-preference' => 'Používat dialogy pro vkládání odkazů, tabulek atd.',
	'wikieditor-toolbar-hidesig' => 'Skrýt tlačítko podpisu na stránkách v hlavním jmenném prostoru',
	'wikieditor-toolbar-loading' => 'Načítá se…',
	'wikieditor-toolbar-tool-bold' => 'Tučně',
	'wikieditor-toolbar-tool-bold-example' => 'Tučný text',
	'wikieditor-toolbar-tool-italic' => 'Kurzíva',
	'wikieditor-toolbar-tool-italic-example' => 'Text kurzívou',
	'wikieditor-toolbar-tool-ilink' => 'Vnitřní odkaz',
	'wikieditor-toolbar-tool-ilink-example' => 'Název odkazu',
	'wikieditor-toolbar-tool-xlink' => 'Externí odkaz (nezapomeňte na předponu http://)',
	'wikieditor-toolbar-tool-xlink-example' => 'http://www.example.com Titulek odkazu',
	'wikieditor-toolbar-tool-link' => 'Odkaz',
	'wikieditor-toolbar-tool-link-title' => 'Vložit odkaz',
	'wikieditor-toolbar-tool-link-int' => 'Na wiki stránku',
	'wikieditor-toolbar-tool-link-int-target' => 'Název stránky:',
	'wikieditor-toolbar-tool-link-int-target-tooltip' => 'Název stránky nebo URL',
	'wikieditor-toolbar-tool-link-int-text' => 'Text odkazu:',
	'wikieditor-toolbar-tool-link-int-text-tooltip' => 'Text, který se má zobrazit',
	'wikieditor-toolbar-tool-link-ext' => 'Na externí webovou stránku',
	'wikieditor-toolbar-tool-link-ext-target' => 'Cíl odkazu:',
	'wikieditor-toolbar-tool-link-ext-text' => 'Text odkazu:',
	'wikieditor-toolbar-tool-link-insert' => 'Vložit odkaz',
	'wikieditor-toolbar-tool-link-cancel' => 'Storno',
	'wikieditor-toolbar-tool-link-int-target-status-exists' => 'Stránka existuje',
	'wikieditor-toolbar-tool-link-int-target-status-notexists' => 'Stránka neexistuje',
	'wikieditor-toolbar-tool-link-int-target-status-invalid' => 'Neplatný název',
	'wikieditor-toolbar-tool-link-int-target-status-external' => 'Externí odkaz',
	'wikieditor-toolbar-tool-link-int-target-status-loading' => 'Zjišťování existence stránky…',
	'wikieditor-toolbar-tool-link-int-invalid' => 'Vámi zadaný název je neplatný.',
	'wikieditor-toolbar-tool-link-lookslikeinternal' => 'Uvedené URL vypadá jako odkaz na jinou stránku této wiki.
Chcete z něj tedy udělat vnitřní odkaz?',
	'wikieditor-toolbar-tool-link-lookslikeinternal-int' => 'Vnitřní odkaz',
	'wikieditor-toolbar-tool-link-lookslikeinternal-ext' => 'Externí odkaz',
	'wikieditor-toolbar-tool-link-empty' => 'Musíte uvést cíl odkazu.',
	'wikieditor-toolbar-tool-file' => 'Vložený soubor',
	'wikieditor-toolbar-tool-file-example' => 'Příklad.jpg',
	'wikieditor-toolbar-tool-file-title' => 'Vložit soubor',
	'wikieditor-toolbar-file-target' => 'Název souboru:',
	'wikieditor-toolbar-file-caption' => 'Popisek:',
	'wikieditor-toolbar-file-size' => 'Velikost:',
	'wikieditor-toolbar-file-float' => 'Zarovnání:',
	'wikieditor-toolbar-file-default' => '(výchozí)',
	'wikieditor-toolbar-file-format' => 'Formát:',
	'wikieditor-toolbar-file-format-none' => 'žádný',
	'wikieditor-toolbar-tool-file-insert' => 'Vložit',
	'wikieditor-toolbar-tool-file-cancel' => 'Storno',
	'wikieditor-toolbar-tool-reference' => 'Poznámky',
	'wikieditor-toolbar-tool-reference-example' => 'Sem uveďte text poznámky',
	'wikieditor-toolbar-tool-reference-cancel' => 'Storno',
	'wikieditor-toolbar-tool-reference-title' => 'Vložit referenci',
	'wikieditor-toolbar-tool-reference-insert' => 'Vložit',
	'wikieditor-toolbar-tool-reference-text' => 'Text reference',
	'wikieditor-toolbar-tool-signature' => 'Podpis a datum',
	'wikieditor-toolbar-section-advanced' => 'Další',
	'wikieditor-toolbar-tool-heading' => 'Nadpis',
	'wikieditor-toolbar-tool-heading-1' => 'Úroveň 1',
	'wikieditor-toolbar-tool-heading-2' => 'Úroveň 2',
	'wikieditor-toolbar-tool-heading-3' => 'Úroveň 3',
	'wikieditor-toolbar-tool-heading-4' => 'Úroveň 4',
	'wikieditor-toolbar-tool-heading-5' => 'Úroveň 5',
	'wikieditor-toolbar-tool-heading-example' => 'Text nadpisu',
	'wikieditor-toolbar-group-format' => 'Formát',
	'wikieditor-toolbar-tool-ulist' => 'Seznam s odrážkami',
	'wikieditor-toolbar-tool-ulist-example' => 'Položka odrážkového seznamu',
	'wikieditor-toolbar-tool-olist' => 'Číslovaný seznam',
	'wikieditor-toolbar-tool-olist-example' => 'Položka číslovaného seznamu',
	'wikieditor-toolbar-tool-indent' => 'Odsazení',
	'wikieditor-toolbar-tool-indent-example' => 'Odsazená řádka',
	'wikieditor-toolbar-tool-nowiki' => 'Bez formátování wiki',
	'wikieditor-toolbar-tool-nowiki-example' => 'Sem vložte neformátovaný text',
	'wikieditor-toolbar-tool-redirect' => 'Přesměrování',
	'wikieditor-toolbar-tool-redirect-example' => 'Název cílové stránky',
	'wikieditor-toolbar-tool-big' => 'Větší',
	'wikieditor-toolbar-tool-big-example' => 'Zvětšený text',
	'wikieditor-toolbar-tool-small' => 'Menší',
	'wikieditor-toolbar-tool-small-example' => 'Zmenšený text',
	'wikieditor-toolbar-tool-superscript' => 'Horní index',
	'wikieditor-toolbar-tool-superscript-example' => 'Text v horním indexu',
	'wikieditor-toolbar-tool-subscript' => 'Dolní index',
	'wikieditor-toolbar-tool-subscript-example' => 'Text v dolním indexu',
	'wikieditor-toolbar-group-insert' => 'Vložit',
	'wikieditor-toolbar-tool-gallery' => 'Galerie obrázků',
	'wikieditor-toolbar-tool-gallery-example' => '$1:Příklad.jpg|Titulek 1
$1:Příklad.jpg|Titulek 2',
	'wikieditor-toolbar-tool-newline' => 'Nový řádek',
	'wikieditor-toolbar-tool-table' => 'Tabulka',
	'wikieditor-toolbar-tool-table-example-old' => '-
! hlavička 1
! hlavička 2
! hlavička 3
|-
| řádek 1, buňka 1
| řádek 1, buňka 2
| řádek 1, buňka 3
|-
| řádek 2, buňka 1
| řádek 2, buňka 2
| řádek 2, buňka 3',
	'wikieditor-toolbar-tool-table-example-cell-text' => 'Text buňky',
	'wikieditor-toolbar-tool-table-example-header' => 'Text záhlaví',
	'wikieditor-toolbar-tool-table-title' => 'Vložení tabulky',
	'wikieditor-toolbar-tool-table-dimensions-rows' => 'Řádků',
	'wikieditor-toolbar-tool-table-dimensions-columns' => 'Sloupců',
	'wikieditor-toolbar-tool-table-dimensions-header' => 'Přidat řádek s hlavičkou',
	'wikieditor-toolbar-tool-table-wikitable' => 'Styl s okraji',
	'wikieditor-toolbar-tool-table-sortable' => 'Umožnit řazení tabulky',
	'wikieditor-toolbar-tool-table-example' => 'Text buňky',
	'wikieditor-toolbar-tool-table-preview' => 'Náhled',
	'wikieditor-toolbar-tool-table-insert' => 'Vložit',
	'wikieditor-toolbar-tool-table-cancel' => 'Storno',
	'wikieditor-toolbar-tool-table-toomany' => 'Pomocí tohoto dialogu nelze vložit tabulku s více než $1 buňkami.',
	'wikieditor-toolbar-tool-table-invalidnumber' => 'Musíte zadat platný počet řádků nebo sloupců.',
	'wikieditor-toolbar-tool-table-zero' => 'Nemůžete vložit tabulku s nulovým počet řádků nebo sloupců.',
	'wikieditor-toolbar-tool-replace' => 'Najít a nahradit',
	'wikieditor-toolbar-tool-replace-title' => 'Najít a nahradit',
	'wikieditor-toolbar-tool-replace-search' => 'Najít:',
	'wikieditor-toolbar-tool-replace-replace' => 'Nahradit za:',
	'wikieditor-toolbar-tool-replace-case' => 'Rozlišovat velikost písmen',
	'wikieditor-toolbar-tool-replace-regex' => 'Hledat pomocí regulárního výrazu',
	'wikieditor-toolbar-tool-replace-button-findnext' => 'Najít další',
	'wikieditor-toolbar-tool-replace-button-replace' => 'Nahradit',
	'wikieditor-toolbar-tool-replace-button-replaceall' => 'Nahradit vše',
	'wikieditor-toolbar-tool-replace-close' => 'Zavřít',
	'wikieditor-toolbar-tool-replace-nomatch' => 'Zadanému hledání nic neodpovídá.',
	'wikieditor-toolbar-tool-replace-success' => 'Nahrazeno $1krát.',
	'wikieditor-toolbar-tool-replace-emptysearch' => 'Musíte uvést, co se má hledat.',
	'wikieditor-toolbar-tool-replace-invalidregex' => 'Zadaný regulární výraz je neplatný: $1',
	'wikieditor-toolbar-section-characters' => 'Zvláštní znaky',
	'wikieditor-toolbar-characters-page-latin' => 'Latinka',
	'wikieditor-toolbar-characters-page-latinextended' => 'Rozšíření latinky',
	'wikieditor-toolbar-characters-page-ipa' => 'Mezinárodní fonetická abeceda (IPA)',
	'wikieditor-toolbar-characters-page-symbols' => 'Symboly',
	'wikieditor-toolbar-characters-page-greek' => 'Řecká abeceda',
	'wikieditor-toolbar-characters-page-cyrillic' => 'Cyrilice',
	'wikieditor-toolbar-characters-page-arabic' => 'Arabské písmo',
	'wikieditor-toolbar-characters-page-arabicextended' => 'Rozšíření arabštiny',
	'wikieditor-toolbar-characters-page-persian' => 'Perština',
	'wikieditor-toolbar-characters-page-hebrew' => 'Hebrejské písmo',
	'wikieditor-toolbar-characters-page-bangla' => 'Bengálské písmo',
	'wikieditor-toolbar-characters-page-tamil' => 'Tamilština',
	'wikieditor-toolbar-characters-page-telugu' => 'Telugské písmo',
	'wikieditor-toolbar-characters-page-sinhala' => 'Sinhálské písmo',
	'wikieditor-toolbar-characters-page-gujarati' => 'Gudžarátské písmo',
	'wikieditor-toolbar-characters-page-devanagari' => 'Dévanágarí',
	'wikieditor-toolbar-characters-page-thai' => 'Thajština',
	'wikieditor-toolbar-characters-page-lao' => 'Laoština',
	'wikieditor-toolbar-characters-page-khmer' => 'Khmerština',
	'wikieditor-toolbar-section-help' => 'Nápověda',
	'wikieditor-toolbar-help-heading-description' => 'Popis',
	'wikieditor-toolbar-help-heading-syntax' => 'Napíšete',
	'wikieditor-toolbar-help-heading-result' => 'Výsledek',
	'wikieditor-toolbar-help-page-format' => 'Formátování',
	'wikieditor-toolbar-help-page-link' => 'Odkazy',
	'wikieditor-toolbar-help-page-heading' => 'Nadpisy',
	'wikieditor-toolbar-help-page-list' => 'Seznamy',
	'wikieditor-toolbar-help-page-file' => 'Soubory',
	'wikieditor-toolbar-help-page-reference' => 'Poznámky',
	'wikieditor-toolbar-help-page-discussion' => 'Diskuse',
	'wikieditor-toolbar-help-content-italic-description' => 'Kurzíva',
	'wikieditor-toolbar-help-content-italic-syntax' => "''Text kurzívou''",
	'wikieditor-toolbar-help-content-italic-result' => '<em>Text kurzívou</em>',
	'wikieditor-toolbar-help-content-bold-description' => 'Tučné písmo',
	'wikieditor-toolbar-help-content-bold-syntax' => "'''Tučný text'''",
	'wikieditor-toolbar-help-content-bold-result' => '<strong>Tučný text</strong>',
	'wikieditor-toolbar-help-content-bolditalic-description' => 'Tučná kurzíva',
	'wikieditor-toolbar-help-content-bolditalic-syntax' => "'''''Text tučnou kurzívou'''''",
	'wikieditor-toolbar-help-content-bolditalic-result' => '<strong><em>Text tučnou kurzívou</em></strong>',
	'wikieditor-toolbar-help-content-ilink-description' => 'Vnitřní odkaz',
	'wikieditor-toolbar-help-content-ilink-syntax' => '[[Název stránky|Text odkazu]]<br />[[Název stránky]]',
	'wikieditor-toolbar-help-content-ilink-result' => "<a href='#'>Text odkazu</a><br /><a href='#'>Název stránky</a>",
	'wikieditor-toolbar-help-content-xlink-description' => 'Externí odkaz',
	'wikieditor-toolbar-help-content-xlink-syntax' => '[http://www.example.org Text odkazu]<br />[http://www.example.org]<br />http://www.example.org',
	'wikieditor-toolbar-help-content-xlink-result' => "<a href='#' class='external'>Text odkazu</a><br /><a href='#' class='external autonumber'>[1]</a><br /><a href='#' class='external'>http://www.example.org</a>",
	'wikieditor-toolbar-help-content-heading2-description' => 'Nadpis 2. úrovně',
	'wikieditor-toolbar-help-content-heading2-syntax' => '== Text nadpisu ==',
	'wikieditor-toolbar-help-content-heading2-result' => '<h2>Text nadpisu</h2>',
	'wikieditor-toolbar-help-content-heading3-description' => 'Nadpis 3. úrovně',
	'wikieditor-toolbar-help-content-heading3-syntax' => '=== Text nadpisu ===',
	'wikieditor-toolbar-help-content-heading3-result' => '<h3>Text nadpisu</h3>',
	'wikieditor-toolbar-help-content-heading4-description' => 'Nadpis 4. úrovně',
	'wikieditor-toolbar-help-content-heading4-syntax' => '==== Text nadpisu ====',
	'wikieditor-toolbar-help-content-heading4-result' => '<h4>Text nadpisu</h4>',
	'wikieditor-toolbar-help-content-heading5-description' => 'Nadpis 5. úrovně',
	'wikieditor-toolbar-help-content-heading5-syntax' => '===== Text nadpisu =====',
	'wikieditor-toolbar-help-content-heading5-result' => '<h5>Text nadpisu</h5>',
	'wikieditor-toolbar-help-content-ulist-description' => 'Seznam s odrážkami',
	'wikieditor-toolbar-help-content-ulist-syntax' => '* Položka seznamu<br />* Položka seznamu',
	'wikieditor-toolbar-help-content-ulist-result' => '<ul><li>Položka seznamu</li><li>Položka seznamu</li></ul>',
	'wikieditor-toolbar-help-content-olist-description' => 'Číslovaný seznam',
	'wikieditor-toolbar-help-content-olist-syntax' => '# Položka seznamu<br /># Položka seznamu',
	'wikieditor-toolbar-help-content-olist-result' => '<ol><li>Položka seznamu</li><li>Položka seznamu</li></ol>',
	'wikieditor-toolbar-help-content-file-description' => 'Vložení souboru',
	'wikieditor-toolbar-help-content-file-syntax' => '[[$1:Příklad.png|thumb|Text titulku]]',
	'wikieditor-toolbar-help-content-file-result' => "<div style='width:104px;' class='thumbinner'><a title='Text titulku' class='image' href='#'><img height='50' width='100' border='0' class='thumbimage' src='$2/WikiEditor/modules/images/toolbar/example-image.png' alt=''/></a><div class='thumbcaption'><div class='magnify'><a title='Zvětšit' class='internal' href='#'><img height='11' width='15' alt='' src='$1/common/images/magnify-clip.png'/></a></div>Text titulku</div></div>",
	'wikieditor-toolbar-help-content-reference-description' => 'Poznámka',
	'wikieditor-toolbar-help-content-reference-syntax' => 'Text stránky.&lt;ref name="test"&gt;[http://www.example.org Text odkazu], další text.&lt;/ref&gt;',
	'wikieditor-toolbar-help-content-reference-result' => "Text stránky.<sup><a href='#'>[1]</a></sup>",
	'wikieditor-toolbar-help-content-rereference-description' => 'Další odkaz na stejnou poznámku',
	'wikieditor-toolbar-help-content-rereference-result' => "Text stránky.<sup><a href='#'>[1]</a></sup>",
	'wikieditor-toolbar-help-content-showreferences-description' => 'Zobrazení poznámek',
	'wikieditor-toolbar-help-content-showreferences-result' => "<ol class='references'><li id='cite_note-test-0'><b><a title='' href='#'>^</a></b> <a rel='nofollow' title='http://www.example.org' class='external text' href='#'>Text odkazu</a>, další text.</li></ol>",
	'wikieditor-toolbar-help-content-signaturetimestamp-description' => 'Podpis a datum',
	'wikieditor-toolbar-help-content-signaturetimestamp-result' => "<a href='#' title='{{ns:User}}:Uživatelské jméno'>Uživatelské jméno</a> 23. 6. 2009, 10:43 (UTC)",
	'wikieditor-toolbar-help-content-signature-description' => 'Podpis',
	'wikieditor-toolbar-help-content-signature-result' => "<a href='#' title='{{ns:User}}:Uživatelské jméno'>Uživatelské jméno</a>",
	'wikieditor-toolbar-help-content-indent-description' => 'Odsazení',
	'wikieditor-toolbar-help-content-indent-syntax' => 'Základní text<br />:Odsazený text<br />::Odsazený text',
	'wikieditor-toolbar-help-content-indent-result' => 'Základní text<dl><dd>Odsazený text<dl><dd>Odsazený text</dd></dl></dd></dl>',
);

/** Kashubian (kaszëbsczi)
 * @author Kuvaly
 */
$messages['csb'] = array(
	'wikieditor-preview-loading' => 'Ladowanié...',
	'wikieditor-previewDialog-loading' => 'Ladowanié...',
	'wikieditor-template-editor-dialog-submit' => 'Aktualizacëjô',
	'wikieditor-template-editor-dialog-cancel' => 'Anulujë',
	'wikieditor-toolbar-loading' => 'Ladowanié...',
	'wikieditor-toolbar-tool-bold' => 'Grëbi',
	'wikieditor-toolbar-tool-bold-example' => 'Wëtłëszczony drëk',
	'wikieditor-toolbar-tool-italic' => 'Kùrsywa',
	'wikieditor-toolbar-tool-italic-example' => 'Ùchëłi tekst',
	'wikieditor-toolbar-tool-ilink' => 'Bënowi lënk',
	'wikieditor-toolbar-tool-ilink-example' => 'Titel lënka',
	'wikieditor-toolbar-tool-xlink-example' => 'http://www.example.com titel lënka',
	'wikieditor-toolbar-tool-link' => 'Lënka',
	'wikieditor-toolbar-tool-link-title' => 'Wstôwi lënka',
	'wikieditor-toolbar-tool-link-insert' => 'Wstôwi lënka',
	'wikieditor-toolbar-tool-link-cancel' => 'Anulujë',
	'wikieditor-toolbar-tool-file-example' => 'Przëmiôr.jpg',
	'wikieditor-toolbar-tool-reference-cancel' => 'Anulujë',
	'wikieditor-toolbar-tool-reference-insert' => 'Wstôwi',
	'wikieditor-toolbar-section-advanced' => 'Awansowóné',
	'wikieditor-toolbar-tool-heading-1' => 'Równiô 1',
	'wikieditor-toolbar-tool-heading-2' => 'Równiô 2',
	'wikieditor-toolbar-tool-heading-3' => 'Równiô 3',
	'wikieditor-toolbar-tool-heading-4' => 'Równiô 4',
	'wikieditor-toolbar-tool-heading-5' => 'Równiô 5',
	'wikieditor-toolbar-tool-redirect' => 'Przeczerowani',
	'wikieditor-toolbar-group-insert' => 'Wstôwi',
	'wikieditor-toolbar-tool-table' => 'Tabela',
	'wikieditor-toolbar-tool-table-dimensions-rows' => 'Régów',
	'wikieditor-toolbar-tool-table-dimensions-columns' => 'Kòlumnów',
	'wikieditor-toolbar-tool-table-example' => 'Przëmiôr',
	'wikieditor-toolbar-tool-table-preview' => 'Pòdzérk',
	'wikieditor-toolbar-tool-table-insert' => 'Wstôwi',
	'wikieditor-toolbar-tool-table-cancel' => 'Anulujë',
	'wikieditor-toolbar-tool-replace-button-findnext' => 'Nalezë pòstãpné',
	'wikieditor-toolbar-tool-replace-close' => 'Anulujë',
	'wikieditor-toolbar-section-characters' => 'Specjalnë céchów',
	'wikieditor-toolbar-characters-page-ipa' => 'IPA',
	'wikieditor-toolbar-characters-page-symbols' => 'Céchë',
	'wikieditor-toolbar-characters-page-greek' => 'Grecczi',
	'wikieditor-toolbar-characters-page-cyrillic' => 'Cërylica',
	'wikieditor-toolbar-characters-page-arabic' => 'Arabsczi',
	'wikieditor-toolbar-characters-page-hebrew' => 'Hebrajsczi',
	'wikieditor-toolbar-section-help' => 'Pòmòc',
	'wikieditor-toolbar-help-heading-description' => 'Òpis',
	'wikieditor-toolbar-help-content-italic-description' => 'Kùrsywa',
	'wikieditor-toolbar-help-content-italic-syntax' => "''Kùrsywa''",
	'wikieditor-toolbar-help-content-italic-result' => '<em>Kùrsywa</em>',
	'wikieditor-toolbar-help-content-bold-description' => 'Grëbi',
	'wikieditor-toolbar-help-content-ilink-description' => 'Bënowi lënk',
	'wikieditor-toolbar-help-content-xlink-description' => 'Bùtnowé lënczi',
);

/** Church Slavic (словѣ́ньскъ / ⰔⰎⰑⰂⰡⰐⰠⰔⰍⰟ)
 * @author ОйЛ
 */
$messages['cu'] = array(
	'wikieditor-preview-changes-tab' => 'мѣнꙑ',
	'wikieditor-publish-button-publish' => 'съхранѥниѥ',
	'wikieditor-publish-dialog-minor' => 'малаꙗ мѣна',
	'wikieditor-publish-dialog-watch' => 'си страницѧ блюдєниѥ',
	'wikieditor-publish-dialog-publish' => 'съхранѥниѥ',
	'wikieditor-template-editor-dialog-title' => 'обраꙁьца исправлѥниѥ',
	'wikieditor-toolbar-tool-ilink-example' => 'съвѧꙁи имѧ',
	'wikieditor-toolbar-tool-xlink-example' => 'http://www.example.com съвѧꙁи имѧ',
	'wikieditor-toolbar-tool-link' => 'съвѧꙁь',
	'wikieditor-toolbar-tool-link-title' => 'съвѧꙁи приложєниѥ',
	'wikieditor-toolbar-tool-link-insert' => 'съвѧꙁи приложєниѥ',
	'wikieditor-toolbar-tool-link-int-target-status-notexists' => 'страницѧ нѣстъ',
	'wikieditor-toolbar-tool-link-lookslikeinternal-ext' => 'вънѣщьнꙗ съвѧꙁь',
	'wikieditor-toolbar-tool-file-example' => 'Прикладъ.jpg',
	'wikieditor-toolbar-tool-signature' => 'аѵтографъ и нꙑнѣшьна врѣмѧ и дьнь',
	'wikieditor-toolbar-tool-redirect' => 'прѣнаправлѥниѥ',
	'wikieditor-toolbar-tool-big' => 'вєликъ',
	'wikieditor-toolbar-tool-small' => 'малъ',
	'wikieditor-toolbar-tool-newline' => 'новъ рѧдъ',
	'wikieditor-toolbar-tool-table' => 'та́влїѥ',
	'wikieditor-toolbar-tool-table-dimensions-rows' => 'рѧдꙑ',
	'wikieditor-toolbar-tool-table-example' => 'прикладъ',
	'wikieditor-toolbar-section-characters' => 'допльнитєл҄ьнꙑ сѷмволи',
	'wikieditor-toolbar-characters-page-latin' => 'латиньска аꙁъбоукꙑ',
	'wikieditor-toolbar-characters-page-latinextended' => 'латиньскꙑ аꙁъбоукьвє доложєниѥ',
	'wikieditor-toolbar-characters-page-ipa' => 'М҃ФА',
	'wikieditor-toolbar-characters-page-symbols' => 'сѷмволи',
	'wikieditor-toolbar-characters-page-greek' => 'грьчьска аꙁъбоукꙑ',
	'wikieditor-toolbar-characters-page-cyrillic' => 'климєнтовица / гражданьска аꙁъбоукꙑ',
	'wikieditor-toolbar-characters-page-arabic' => 'аравьска аꙁъбоукꙑ',
	'wikieditor-toolbar-characters-page-hebrew' => 'єврєиска аꙁъбоукꙑ',
	'wikieditor-toolbar-characters-page-bangla' => 'бангальска аꙁъбоукꙑ',
	'wikieditor-toolbar-characters-page-telugu' => 'тєлоужьска аꙁъбоукꙑ',
	'wikieditor-toolbar-characters-page-sinhala' => 'синхальска аꙁъбоукꙑ',
	'wikieditor-toolbar-section-help' => 'помощь',
	'wikieditor-toolbar-help-page-link' => 'съвѧꙁи',
	'wikieditor-toolbar-help-page-file' => 'дѣла',
	'wikieditor-toolbar-help-page-discussion' => 'бєсѣда',
	'wikieditor-toolbar-help-content-signaturetimestamp-description' => 'аѵтографъ и нꙑнѣшьна врѣмѧ и дьнь',
	'wikieditor-toolbar-help-content-signature-description' => 'аѵтографъ',
);

/** Welsh (Cymraeg)
 * @author Lloffiwr
 * @author Xxglennxx
 */
$messages['cy'] = array(
	'wikieditor' => 'Rhyngwyneb golygu testun wici uwch',
	'wikieditor-desc' => 'Yn darparu rhyngwyneb estynadwy ar gyfer golygu testun wici a llawer o fodiwlau o nodweddion arbennig',
	'wikieditor-wikitext-tab' => 'Testun wici',
	'wikieditor-loading' => "Wrthi'n llwytho",
	'wikieditor-preview-preference' => 'Galluogi rhagolwg ochr-yn-ochr',
	'wikieditor-preview-tab' => 'Rhagolwg',
	'wikieditor-preview-changes-tab' => 'Newidiadau',
	'wikieditor-preview-loading' => "Wrthi'n llwytho...",
	'wikieditor-previewDialog-preference' => 'Galluogi blwch deialog rhagolygon',
	'wikieditor-previewDialog-tab' => 'Rhagolwg',
	'wikieditor-previewDialog-loading' => "Wrthi'n llwytho...",
	'wikieditor-publish-preference' => 'Galluogi cyhoeddi cam-wrth-gam',
	'wikieditor-publish-button-publish' => 'Cyhoeddi',
	'wikieditor-publish-button-cancel' => 'Diddymu',
	'wikieditor-publish-dialog-title' => 'Cyhoeddi ar {{SITENAME}}',
	'wikieditor-publish-dialog-summary' => "Crynodeb golygu (rhowch ddisgrifiad byr o'ch newididau):",
	'wikieditor-publish-dialog-minor' => 'Golygiad bychan',
	'wikieditor-publish-dialog-watch' => 'Dilyn hynt y dudalen hon',
	'wikieditor-publish-dialog-publish' => 'Cyhoedder',
	'wikieditor-publish-dialog-goback' => 'Yn ôl',
	'wikieditor-template-editor-preference' => 'Galluogi golygu nodynnau wici drwy ffurflen',
	'wikieditor-template-editor-dialog-title' => "Golygu'r nodyn",
	'wikieditor-template-editor-dialog-submit' => 'Diweddarer',
	'wikieditor-template-editor-dialog-cancel' => 'Diddymer',
	'wikieditor-templates-preference' => 'Galluogi crebachu nodyn',
	'wikieditor-toc-preference' => 'Galluogi rhestr gynnwys fordwyol',
	'wikieditor-toc-show' => "Dangos 'Cynnwys'",
	'wikieditor-toc-hide' => "Cuddio 'Cynnwys'",
	'wikieditor-toolbar' => 'Bar offer golygu',
	'wikieditor-toolbar-desc' => 'Bar offer y dudalen olygu gyda gwelliannau defnyddioldeb',
	'wikieditor-toolbar-preference' => "Defnyddio'r bar offer golygu estynedig",
	'wikieditor-toolbar-dialogs-preference' => 'Galluoger y blychau yn y rhyngwyneb ar gyfer mewnosod cysylltiadau, tablau ag ati',
	'wikieditor-toolbar-hidesig' => "Cuddio'r botwm llofnodi rhag y tudalennau yn y prif barth",
	'wikieditor-toolbar-loading' => "Wrthi'n llwytho...",
	'wikieditor-toolbar-tool-bold' => 'Praff',
	'wikieditor-toolbar-tool-bold-example' => 'Testun praff',
	'wikieditor-toolbar-tool-italic' => 'Italig',
	'wikieditor-toolbar-tool-italic-example' => 'Testun italig',
	'wikieditor-toolbar-tool-ilink' => 'Cyswllt mewnol',
	'wikieditor-toolbar-tool-ilink-example' => 'Teitl y cyswllt',
	'wikieditor-toolbar-tool-xlink' => 'Cyswllt allanol (cofiwch rhagddodi http://)',
	'wikieditor-toolbar-tool-xlink-example' => 'http://www.example.com teitl y cyswllt',
	'wikieditor-toolbar-tool-link' => 'Cyswllt',
	'wikieditor-toolbar-tool-link-title' => 'Mewnosod cyswllt',
	'wikieditor-toolbar-tool-link-int' => 'At dudalen wici',
	'wikieditor-toolbar-tool-link-int-target' => 'Teitl y dudalen:',
	'wikieditor-toolbar-tool-link-int-target-tooltip' => 'Teitl y dudalen neu ei URL',
	'wikieditor-toolbar-tool-link-int-text' => 'Testun y cyswllt:',
	'wikieditor-toolbar-tool-link-int-text-tooltip' => "Gosodwch yr ysgrifen a fydd i'w weld",
	'wikieditor-toolbar-tool-link-ext' => 'At dudalen we allanol',
	'wikieditor-toolbar-tool-link-ext-target' => 'URL y cyswllt:',
	'wikieditor-toolbar-tool-link-ext-text' => 'Ysgrifen y cyswllt:',
	'wikieditor-toolbar-tool-link-insert' => 'Mewnosod cyswllt',
	'wikieditor-toolbar-tool-link-cancel' => 'Diddymu',
	'wikieditor-toolbar-tool-link-int-target-status-exists' => 'Y dudalen ar gael',
	'wikieditor-toolbar-tool-link-int-target-status-notexists' => "Nid yw'r dudalen ar gael",
	'wikieditor-toolbar-tool-link-int-target-status-invalid' => 'Teitl annilys',
	'wikieditor-toolbar-tool-link-int-target-status-external' => 'Cyswllt allanol',
	'wikieditor-toolbar-tool-link-int-target-status-loading' => "Wrthi'n gwirio a yw'r dudalen ar gael...",
	'wikieditor-toolbar-tool-link-int-invalid' => 'Ysgrifennwyd teitl annilys.',
	'wikieditor-toolbar-tool-link-lookslikeinternal' => "Mae'n ymddangos bod yr URL a osodwyd yn arwain at dudalen arall yn y wici.
Ydych chi am ei osod ar ffurf cyswllt mewnol?",
	'wikieditor-toolbar-tool-link-lookslikeinternal-int' => 'Cyswllt mewnol',
	'wikieditor-toolbar-tool-link-lookslikeinternal-ext' => 'Cyswllt allanol',
	'wikieditor-toolbar-tool-link-empty' => "Nid ydych wedi ysgrifennu nod i'r cyswllt fynd ato.",
	'wikieditor-toolbar-tool-file' => 'Ffeil mewnosodol',
	'wikieditor-toolbar-tool-file-example' => 'Enghraifft.jpg',
	'wikieditor-toolbar-tool-reference' => 'Troednodyn',
	'wikieditor-toolbar-tool-reference-example' => 'Ysgrifennwch droednodyn fan hyn',
	'wikieditor-toolbar-tool-reference-cancel' => 'Diddymu',
	'wikieditor-toolbar-tool-reference-title' => 'Mewnosod cyfeirnod',
	'wikieditor-toolbar-tool-reference-insert' => 'Mewnosod',
	'wikieditor-toolbar-tool-reference-text' => 'Testun y cyfeirnod',
	'wikieditor-toolbar-tool-signature' => 'Llofnod a stamp amser',
	'wikieditor-toolbar-section-advanced' => 'Uwch',
	'wikieditor-toolbar-tool-heading' => 'Pennawd',
	'wikieditor-toolbar-tool-heading-1' => 'Lefel 1',
	'wikieditor-toolbar-tool-heading-2' => 'Lefel 2',
	'wikieditor-toolbar-tool-heading-3' => 'Lefel 3',
	'wikieditor-toolbar-tool-heading-4' => 'Lefel 4',
	'wikieditor-toolbar-tool-heading-5' => 'Lefel 5',
	'wikieditor-toolbar-tool-heading-example' => 'Ysgrifennwch y pennawd fan hyn',
	'wikieditor-toolbar-group-format' => 'Fformat:',
	'wikieditor-toolbar-tool-ulist' => 'Rhestr gyda bwledi',
	'wikieditor-toolbar-tool-ulist-example' => 'Eitem ar restr gyda bwledi',
	'wikieditor-toolbar-tool-olist' => "Rhestr wedi'i rhifo",
	'wikieditor-toolbar-tool-olist-example' => "Eitem ar restr wedi'i rhifo",
	'wikieditor-toolbar-tool-indent' => 'Mewnoliad',
	'wikieditor-toolbar-tool-indent-example' => "Llinell wedi'i mewnoli",
	'wikieditor-toolbar-tool-nowiki' => 'Dim cystrawen wici',
	'wikieditor-toolbar-tool-nowiki-example' => 'Rhowch destun heb ei fformatio yma',
	'wikieditor-toolbar-tool-redirect' => 'Ailgyfeiriad',
	'wikieditor-toolbar-tool-redirect-example' => 'Enw tudalen y pen draw',
	'wikieditor-toolbar-tool-big' => 'Mawr',
	'wikieditor-toolbar-tool-big-example' => 'Llythrennau mawr',
	'wikieditor-toolbar-tool-small' => 'Bach',
	'wikieditor-toolbar-tool-small-example' => 'Ysgrifen bach',
	'wikieditor-toolbar-tool-superscript' => 'Uwchysgrif',
	'wikieditor-toolbar-tool-superscript-example' => 'Ysgrifennwch uwchysgrif fan hyn',
	'wikieditor-toolbar-tool-subscript' => 'Isysgrif',
	'wikieditor-toolbar-tool-subscript-example' => 'Ysgrifennwch isysgrif fan hyn',
	'wikieditor-toolbar-group-insert' => 'Mewnosod',
	'wikieditor-toolbar-tool-gallery' => 'Oriel lluniau',
	'wikieditor-toolbar-tool-gallery-example' => '$1:Enghraifft.jpg|Disgrifiad1
$1:Enghraifft.jpg|Disgrifiad2',
	'wikieditor-toolbar-tool-newline' => 'Llinell newydd',
	'wikieditor-toolbar-tool-table' => 'Tabl',
	'wikieditor-toolbar-tool-table-example-old' => '-
! pennawd 1
! pennawd 2
! pennawd 3
|-
| rhes 1, cell 1
| rhes 1, cell 2
| rhes 1, cell 3
|-
| rhes 2, cell 1
| rhes 2, cell 2
| rhes 2, cell 3',
	'wikieditor-toolbar-tool-table-example-cell-text' => 'Testun y gell',
	'wikieditor-toolbar-tool-table-example-header' => 'Testun y pennawd',
	'wikieditor-toolbar-tool-table-title' => 'Mewnosod tabl',
	'wikieditor-toolbar-tool-table-dimensions-rows' => 'Rhesi',
	'wikieditor-toolbar-tool-table-dimensions-columns' => 'Colofnau',
	'wikieditor-toolbar-tool-table-dimensions-header' => 'Cynhwysir rhes y penawdau',
	'wikieditor-toolbar-tool-table-wikitable' => 'Dangos borderi',
	'wikieditor-toolbar-tool-table-sortable' => 'Gosod tabl y gellir ei drefnu',
	'wikieditor-toolbar-tool-table-example' => 'Testun y gell',
	'wikieditor-toolbar-tool-table-preview' => 'Rhagolwg',
	'wikieditor-toolbar-tool-table-insert' => 'Mewnosod',
	'wikieditor-toolbar-tool-table-cancel' => 'Diddymu',
	'wikieditor-toolbar-tool-table-toomany' => "Nid yw'n bosib gosod tabl ag iddo mwy na $1 o gelloedd trwy ddefnyddio'r deialog hwn.",
	'wikieditor-toolbar-tool-table-invalidnumber' => 'Nid ydych wedi gosod nifer (dilys) o resi neu o golofnau.',
	'wikieditor-toolbar-tool-table-zero' => 'Ni allwch osod tabl heb unrhyw resi neu golofnau iddo.',
	'wikieditor-toolbar-tool-replace' => 'Canfod a disodli',
	'wikieditor-toolbar-tool-replace-title' => 'Canfod a disodli',
	'wikieditor-toolbar-tool-replace-search' => 'Chwilier am:',
	'wikieditor-toolbar-tool-replace-replace' => 'Gosoder yn ei le:',
	'wikieditor-toolbar-tool-replace-case' => 'Trin llythrennau mawr a bach fel llythrennau gwahanol',
	'wikieditor-toolbar-tool-replace-regex' => 'Trin y llinyn chwilio fel ymadrodd rheolaidd',
	'wikieditor-toolbar-tool-replace-button-findnext' => 'Chwilio am y nesaf',
	'wikieditor-toolbar-tool-replace-button-replace' => 'Disodli',
	'wikieditor-toolbar-tool-replace-button-replaceall' => "Disodli'r cwbwl",
	'wikieditor-toolbar-tool-replace-close' => 'Cau',
	'wikieditor-toolbar-tool-replace-nomatch' => 'Ni chanfyddwyd yr hyn a chwiliwyd amdano.',
	'wikieditor-toolbar-tool-replace-success' => 'Gwnaethpwyd $1 amnewidiad.',
	'wikieditor-toolbar-tool-replace-emptysearch' => 'Ni osodwyd unrhywbeth yn y blwch chwilio.',
	'wikieditor-toolbar-tool-replace-invalidregex' => "Nid yw'r ymadrodd rheolaidd a ysgrifennwyd gennych yn ddilys: $1",
	'wikieditor-toolbar-section-characters' => 'Nodau arbennig',
	'wikieditor-toolbar-characters-page-latin' => 'Lladin',
	'wikieditor-toolbar-characters-page-latinextended' => 'Lladin estynedig',
	'wikieditor-toolbar-characters-page-ipa' => 'Yr wyddor phonetig rhyngwladol (IPA)',
	'wikieditor-toolbar-characters-page-symbols' => 'Symbolau',
	'wikieditor-toolbar-characters-page-greek' => 'Groeg',
	'wikieditor-toolbar-characters-page-cyrillic' => 'Cyrilig',
	'wikieditor-toolbar-characters-page-arabic' => 'Arabeg',
	'wikieditor-toolbar-characters-page-arabicextended' => 'Arabeg estynedig',
	'wikieditor-toolbar-characters-page-persian' => 'Perseg',
	'wikieditor-toolbar-characters-page-hebrew' => 'Hebraeg',
	'wikieditor-toolbar-characters-page-bangla' => 'Bangla',
	'wikieditor-toolbar-characters-page-tamil' => 'Tamileg',
	'wikieditor-toolbar-characters-page-telugu' => 'Telugu',
	'wikieditor-toolbar-characters-page-sinhala' => 'Sinhala',
	'wikieditor-toolbar-characters-page-gujarati' => 'Gwjarati',
	'wikieditor-toolbar-characters-page-devanagari' => 'Defanagari',
	'wikieditor-toolbar-characters-page-thai' => 'Thai',
	'wikieditor-toolbar-characters-page-lao' => 'Laoseg',
	'wikieditor-toolbar-characters-page-khmer' => 'Chmereg',
	'wikieditor-toolbar-section-help' => 'Cymorth',
	'wikieditor-toolbar-help-heading-description' => 'Disgrifiad',
	'wikieditor-toolbar-help-heading-syntax' => 'Pan deipiwch hyn',
	'wikieditor-toolbar-help-heading-result' => 'fe gewch',
	'wikieditor-toolbar-help-page-format' => 'Fformatio',
	'wikieditor-toolbar-help-page-link' => 'Cysylltau',
	'wikieditor-toolbar-help-page-heading' => 'Penawdau',
	'wikieditor-toolbar-help-page-list' => 'Rhestri',
	'wikieditor-toolbar-help-page-file' => 'Ffeiliau',
	'wikieditor-toolbar-help-page-reference' => 'Troednodion',
	'wikieditor-toolbar-help-page-discussion' => 'Sgwrs',
	'wikieditor-toolbar-help-content-italic-description' => 'Italig',
	'wikieditor-toolbar-help-content-italic-syntax' => "''Ysgrifen italig''",
	'wikieditor-toolbar-help-content-italic-result' => '<em>Ysgrifen italig</em>',
	'wikieditor-toolbar-help-content-bold-description' => 'Praff',
	'wikieditor-toolbar-help-content-bold-syntax' => "'''Testun praff'''",
	'wikieditor-toolbar-help-content-bold-result' => '<strong>Testun praff</strong>',
	'wikieditor-toolbar-help-content-bolditalic-description' => 'Praff &amp; italig',
	'wikieditor-toolbar-help-content-bolditalic-syntax' => "'''''Ysgrifen praff &amp; italig'''''",
	'wikieditor-toolbar-help-content-bolditalic-result' => '<strong><em>Ysgrifen praff &amp; italig</em></strong>',
	'wikieditor-toolbar-help-content-ilink-description' => 'Cyswllt mewnol',
	'wikieditor-toolbar-help-content-ilink-syntax' => '[[Page title|Label y cyswllt]]<br />[[Teitl y dudalen]]',
	'wikieditor-toolbar-help-content-ilink-result' => "<a href='#'>Label y cyswllt</a><br /><a href='#'>Teitl y dudalen</a>",
	'wikieditor-toolbar-help-content-xlink-description' => 'Cyswllt allanol',
	'wikieditor-toolbar-help-content-xlink-syntax' => '[http://www.enghraifft.org Label y cyswllt]<br />[http://www.enghraifft.org]<br />http://www.enghraifft.org',
	'wikieditor-toolbar-help-content-xlink-result' => "<a href='#' class='external'>Label y cyswllt</a><br /><a href='#' class='external autonumber'>[1]</a><br /><a href='#' class='external'>http://www.example.org</a>",
	'wikieditor-toolbar-help-content-heading2-description' => 'pennawd ar lefel 2',
	'wikieditor-toolbar-help-content-heading2-syntax' => '== Y pennawd ==',
	'wikieditor-toolbar-help-content-heading2-result' => '<h2>Y pennawd</h2>',
	'wikieditor-toolbar-help-content-heading3-description' => 'pennawd ar lefel 3',
	'wikieditor-toolbar-help-content-heading3-syntax' => '=== Y pennawd ===',
	'wikieditor-toolbar-help-content-heading3-result' => '<h3>Y pennawd</h3>',
	'wikieditor-toolbar-help-content-heading4-description' => 'pennawd ar lefel 4',
	'wikieditor-toolbar-help-content-heading4-syntax' => '==== Y pennawd ====',
	'wikieditor-toolbar-help-content-heading4-result' => '<h4>Y pennawd</h4>',
	'wikieditor-toolbar-help-content-heading5-description' => 'pennawd ar lefel 5',
	'wikieditor-toolbar-help-content-heading5-syntax' => '===== Y pennawd =====',
	'wikieditor-toolbar-help-content-heading5-result' => '<h5>Y pennawd</h5>',
	'wikieditor-toolbar-help-content-ulist-description' => 'Rhestr gyda bwledi',
	'wikieditor-toolbar-help-content-ulist-syntax' => '* Eitem ar y rhestr<br />* Eitem ar y rhestr',
	'wikieditor-toolbar-help-content-ulist-result' => '<ul><li>Eitem ar y rhestr</li><li>Eitem ar y rhestr</li></ul>',
	'wikieditor-toolbar-help-content-olist-description' => "Rhestr wedi'i rhifo",
	'wikieditor-toolbar-help-content-olist-syntax' => '# Eitem ar y rhestr<br /># Eitem ar y rhestr',
	'wikieditor-toolbar-help-content-olist-result' => '<ol><li>Eitem ar y rhestr</li><li>Eitem ar y rhestr</li></ol>',
	'wikieditor-toolbar-help-content-file-description' => 'Ffeil mewnosodol',
	'wikieditor-toolbar-help-content-file-syntax' => '[[$1:Example.png|thumb|Disgrifiad]]',
	'wikieditor-toolbar-help-content-file-result' => "<div style='width:104px;' class='thumbinner'><a title='Egluryn' class='image' href='#'><img height='50' width='100' border='0' class='thumbimage' src='$2/WikiEditor/modules/images/toolbar/example-image.png' alt=''/></a><div class='thumbcaption'><div class='magnify'><a title='Chwyddo' class='internal' href='#'><img height='11' width='15' alt='' src='$1/common/images/magnify-clip.png'/></a></div>Egluryn</div></div>",
	'wikieditor-toolbar-help-content-reference-description' => 'Troednodyn',
	'wikieditor-toolbar-help-content-reference-syntax' => 'Testun y dudalen.&lt;ref name="test"&gt;[http://www.enghraifft.org ysgrifen y cyswllt], ysgrifen ychwanegol.&lt;/ref&gt;',
	'wikieditor-toolbar-help-content-reference-result' => 'Testun y dudalen.',
	'wikieditor-toolbar-help-content-rereference-description' => 'Ail-ddefnyddio troednodyn',
	'wikieditor-toolbar-help-content-rereference-result' => "Testun y dudalen.<sup><a href='#'>[1]</a></sup>",
	'wikieditor-toolbar-help-content-showreferences-description' => 'Dangos y troednodion',
	'wikieditor-toolbar-help-content-showreferences-result' => "<ol class='references'><li id='cite_note-test-0'><b><a title='' href='#'>^</a></b> <a rel='nofollow' title='http://www.example.org' class='external text' href='#'>Ysgrifen y cyswllt</a>, ysgrifen arall.</li></ol>",
	'wikieditor-toolbar-help-content-signaturetimestamp-description' => 'Llofnod gyda stamp amser',
	'wikieditor-toolbar-help-content-signaturetimestamp-result' => "<a href='#' title='{{#special:mypage}}'>Enw defnyddiwr</a> (<a href='#' title='{{#special:mytalk}}'>sgwrs</a>) 15:54, 10 Mehefin 2009 (UTC)",
	'wikieditor-toolbar-help-content-signature-description' => 'Llofnod',
	'wikieditor-toolbar-help-content-signature-result' => "<a href='#' title='{{#special:mypage}}'>Enw defnyddiwr</a> (<a href='#' title='{{#special:mytalk}}'>sgwrs</a>)",
	'wikieditor-toolbar-help-content-indent-description' => 'Mewnoli',
	'wikieditor-toolbar-help-content-indent-syntax' => "Ysgrifen rheolaidd<br />:Ysgrifen wedi'i mewnoli<br />::Ysgrifen wedi'i mewnoli",
	'wikieditor-toolbar-help-content-indent-result' => "Ysgrifen rheolaidd<dl><dd>Ysgrifen wedi'i mewnoli<dl><dd>Ysgrifen wedi'i mewnoli</dd></dl></dd></dl>",
);

/** Danish (dansk)
 * @author Christian List
 * @author F. Cosoleto
 * @author Froztbyte
 * @author Hylle
 * @author Peter Alberti
 * @author Sarrus
 * @author Sir48
 */
$messages['da'] = array(
	'wikieditor' => 'Avanceret interface til redigering af wikitekst',
	'wikieditor-desc' => 'Giver et udvidet interface til redigering af wikitekst og mange moduler med hjælpefunktioner',
	'wikieditor-wikitext-tab' => 'wikitekst',
	'wikieditor-loading' => 'Indlæser',
	'wikieditor-preview-preference' => 'Aktiver forhåndsvisning side-om-side',
	'wikieditor-preview-tab' => 'Forhåndsvisning',
	'wikieditor-preview-changes-tab' => 'Ændringer',
	'wikieditor-preview-loading' => 'Indlæser...',
	'wikieditor-previewDialog-preference' => 'Aktiver forhåndsvisningsdialog',
	'wikieditor-previewDialog-tab' => 'Forhåndsvisning',
	'wikieditor-previewDialog-loading' => 'Indlæser…',
	'wikieditor-publish-preference' => 'Aktiver skridt-for-skridt udgivelse',
	'wikieditor-publish-button-publish' => 'Udgiv',
	'wikieditor-publish-button-cancel' => 'Afbryd',
	'wikieditor-publish-dialog-title' => 'Udgiv som {{SITENAME}}',
	'wikieditor-publish-dialog-summary' => 'Redigeringsbeskrivelse (beskriv kort de ændringer, du har gjort)',
	'wikieditor-publish-dialog-minor' => 'Mindre ændring',
	'wikieditor-publish-dialog-watch' => 'Overvåg denne side',
	'wikieditor-publish-dialog-publish' => 'Udgiv',
	'wikieditor-publish-dialog-goback' => 'Gå tilbage',
	'wikieditor-template-editor-preference' => 'Aktiver formbaseret redigering af wikiskabeloner',
	'wikieditor-template-editor-dialog-title' => 'Rediger skabelon',
	'wikieditor-template-editor-dialog-submit' => 'Opdater',
	'wikieditor-template-editor-dialog-cancel' => 'Afbryd',
	'wikieditor-templates-preference' => 'Aktiver sammenklappelige skabeloner',
	'wikieditor-toc-preference' => 'Aktiver navigerbar indholdsfortegnelse',
	'wikieditor-toc-show' => 'Vis indhold',
	'wikieditor-toc-hide' => 'Skjul indhold',
	'wikieditor-toolbar' => 'Værktøjslinje til redigering',
	'wikieditor-toolbar-desc' => 'Værktøjslinje til redigering med udvidet brugervenlighed',
	'wikieditor-toolbar-preference' => 'Aktiver forbedret værktøjslinje til redigering',
	'wikieditor-toolbar-dialogs-preference' => 'Aktiver dialoger til indsættelse af links, tabeller og mere.',
	'wikieditor-toolbar-hidesig' => 'Skjul signaturknappen på sider i hovednavnerummet',
	'wikieditor-toolbar-loading' => 'Indlæser ...',
	'wikieditor-toolbar-tool-bold' => 'Fed',
	'wikieditor-toolbar-tool-bold-example' => 'Fed tekst',
	'wikieditor-toolbar-tool-italic' => 'Kursiv',
	'wikieditor-toolbar-tool-italic-example' => 'Kursiv tekst',
	'wikieditor-toolbar-tool-ilink' => 'Intern henvisning',
	'wikieditor-toolbar-tool-ilink-example' => 'Henvisningstekst',
	'wikieditor-toolbar-tool-xlink' => 'Ekstern henvisning (husk http:// først)',
	'wikieditor-toolbar-tool-xlink-example' => 'http://www.example.com henvisningstekst',
	'wikieditor-toolbar-tool-link' => 'Henvisning',
	'wikieditor-toolbar-tool-link-title' => 'Indsæt henvisning',
	'wikieditor-toolbar-tool-link-int' => 'Til en wikiartikel/-side',
	'wikieditor-toolbar-tool-link-int-target' => 'Artikeltitel:',
	'wikieditor-toolbar-tool-link-int-target-tooltip' => 'Sidetitel eller internetadresse',
	'wikieditor-toolbar-tool-link-int-text' => 'Henvisningstekst:',
	'wikieditor-toolbar-tool-link-int-text-tooltip' => 'Tekst, der skal vises',
	'wikieditor-toolbar-tool-link-ext' => 'Til en ekstern webside',
	'wikieditor-toolbar-tool-link-ext-target' => 'Henvisnings-URL:',
	'wikieditor-toolbar-tool-link-ext-text' => 'Henvisningstekst:',
	'wikieditor-toolbar-tool-link-insert' => 'Indsæt henvisning',
	'wikieditor-toolbar-tool-link-cancel' => 'Annuller',
	'wikieditor-toolbar-tool-link-int-target-status-exists' => 'Siden findes',
	'wikieditor-toolbar-tool-link-int-target-status-notexists' => 'Siden findes ikke',
	'wikieditor-toolbar-tool-link-int-target-status-invalid' => 'Ugyldig titel',
	'wikieditor-toolbar-tool-link-int-target-status-external' => 'Ekstern henvisning',
	'wikieditor-toolbar-tool-link-int-target-status-loading' => 'Kontrollerer om siden findes ...',
	'wikieditor-toolbar-tool-link-int-invalid' => 'Titlen du gav, er ugyldig.',
	'wikieditor-toolbar-tool-link-lookslikeinternal' => "URL'en, du har angivet, ser ud til at være tiltænkt som en henvisning til en anden wikiside.
Ønsker du at gøre den til en intern henvisning.",
	'wikieditor-toolbar-tool-link-lookslikeinternal-int' => 'Intern henvisning',
	'wikieditor-toolbar-tool-link-lookslikeinternal-ext' => 'Ekstern henvisning',
	'wikieditor-toolbar-tool-link-empty' => 'Du har ikke angivet noget at linke til.',
	'wikieditor-toolbar-tool-file' => 'Indlejret fil',
	'wikieditor-toolbar-tool-file-example' => 'Eksempel.jpg',
	'wikieditor-toolbar-tool-file-title' => 'Indsæt fil',
	'wikieditor-toolbar-file-target' => 'Filnavn:',
	'wikieditor-toolbar-file-caption' => 'Billedtekst:',
	'wikieditor-toolbar-file-size' => 'Størrelse:',
	'wikieditor-toolbar-file-float' => 'Justering:',
	'wikieditor-toolbar-file-default' => '(standard)',
	'wikieditor-toolbar-file-format' => 'Format:',
	'wikieditor-toolbar-tool-file-insert' => 'Indsæt',
	'wikieditor-toolbar-tool-file-cancel' => 'Annuller',
	'wikieditor-toolbar-tool-reference' => 'Fodnote',
	'wikieditor-toolbar-tool-reference-example' => 'Indsæt fodnotetekst her',
	'wikieditor-toolbar-tool-reference-cancel' => 'Annullér',
	'wikieditor-toolbar-tool-reference-title' => 'Indsæt reference',
	'wikieditor-toolbar-tool-reference-insert' => 'Indsæt',
	'wikieditor-toolbar-tool-reference-text' => 'Referencetekst',
	'wikieditor-toolbar-tool-signature' => 'Signatur og tidsstempel',
	'wikieditor-toolbar-section-advanced' => 'Avanceret',
	'wikieditor-toolbar-tool-heading' => 'Overskrift',
	'wikieditor-toolbar-tool-heading-1' => 'Niveau 1',
	'wikieditor-toolbar-tool-heading-2' => 'Niveau 2',
	'wikieditor-toolbar-tool-heading-3' => 'Niveau 3',
	'wikieditor-toolbar-tool-heading-4' => 'Niveau 4',
	'wikieditor-toolbar-tool-heading-5' => 'Niveau 5',
	'wikieditor-toolbar-tool-heading-example' => 'Overskriftstekst',
	'wikieditor-toolbar-group-format' => 'Format',
	'wikieditor-toolbar-tool-ulist' => 'Punktliste',
	'wikieditor-toolbar-tool-ulist-example' => 'Element i punktliste',
	'wikieditor-toolbar-tool-olist' => 'Nummereret liste',
	'wikieditor-toolbar-tool-olist-example' => 'Element i nummereret liste',
	'wikieditor-toolbar-tool-indent' => 'Indrykning',
	'wikieditor-toolbar-tool-indent-example' => 'Indrykket linje',
	'wikieditor-toolbar-tool-nowiki' => 'Ingen wikiformatering',
	'wikieditor-toolbar-tool-nowiki-example' => 'Indsæt uformateret tekst her',
	'wikieditor-toolbar-tool-redirect' => 'Omdirigering',
	'wikieditor-toolbar-tool-redirect-example' => 'Målsidens navn',
	'wikieditor-toolbar-tool-big' => 'Stor',
	'wikieditor-toolbar-tool-big-example' => 'Stor tekst',
	'wikieditor-toolbar-tool-small' => 'Lille',
	'wikieditor-toolbar-tool-small-example' => 'Lille tekst',
	'wikieditor-toolbar-tool-superscript' => 'Hævet skrift',
	'wikieditor-toolbar-tool-superscript-example' => 'Hævet tekst',
	'wikieditor-toolbar-tool-subscript' => 'Sænket skrift',
	'wikieditor-toolbar-tool-subscript-example' => 'Sænket skrift',
	'wikieditor-toolbar-group-insert' => 'Indsæt',
	'wikieditor-toolbar-tool-gallery' => 'Billedgalleri',
	'wikieditor-toolbar-tool-gallery-example' => '$1:Eksempel.jpg|Billedtekst1
$1:Eksempel.jpg|Billedtekst2',
	'wikieditor-toolbar-tool-newline' => 'Ny linje',
	'wikieditor-toolbar-tool-table' => 'Tabel',
	'wikieditor-toolbar-tool-table-example-old' => '-
! overskrift 1
! overskrift 2
! overskrift 3
|-
| række 1, celle 1
| række 1, celle 2
| række 1, celle 3
|-
| række 2, celle 1
| række 2, celle 2
| række 2, celle 3',
	'wikieditor-toolbar-tool-table-example-cell-text' => 'Række $1, celle $2',
	'wikieditor-toolbar-tool-table-example-header' => 'Overskriftstekst',
	'wikieditor-toolbar-tool-table-title' => 'Indsæt tabel',
	'wikieditor-toolbar-tool-table-dimensions-rows' => 'Rækker',
	'wikieditor-toolbar-tool-table-dimensions-columns' => 'Kolonner',
	'wikieditor-toolbar-tool-table-dimensions-header' => 'Tilføj række til kolonneoverskrifter',
	'wikieditor-toolbar-tool-table-wikitable' => 'Stil med kanter',
	'wikieditor-toolbar-tool-table-sortable' => 'Gør tabel sorterbar',
	'wikieditor-toolbar-tool-table-example' => 'Celletekst',
	'wikieditor-toolbar-tool-table-preview' => 'Forhåndsvisning',
	'wikieditor-toolbar-tool-table-insert' => 'Indsæt',
	'wikieditor-toolbar-tool-table-cancel' => 'Annullér',
	'wikieditor-toolbar-tool-table-toomany' => 'Det er ikke muligt at indsætte en tabel med mere end $1 celler med denne dialogboks',
	'wikieditor-toolbar-tool-table-invalidnumber' => 'Du har ikke angivet et gyldigt antal rækker eller kolonner.',
	'wikieditor-toolbar-tool-table-zero' => 'Du kan ikke indsætte en tabel med nul rækker eller kolonner',
	'wikieditor-toolbar-tool-replace' => 'Søg og erstat',
	'wikieditor-toolbar-tool-replace-title' => 'Søg og erstat',
	'wikieditor-toolbar-tool-replace-search' => 'Søg efter:',
	'wikieditor-toolbar-tool-replace-replace' => 'Erstat med:',
	'wikieditor-toolbar-tool-replace-case' => 'Skeln mellem store og små bogstaver',
	'wikieditor-toolbar-tool-replace-regex' => 'Behandl søgestrengen som et regulært udtryk',
	'wikieditor-toolbar-tool-replace-button-findnext' => 'Find næste',
	'wikieditor-toolbar-tool-replace-button-replace' => 'Erstat',
	'wikieditor-toolbar-tool-replace-button-replaceall' => 'Erstat alle',
	'wikieditor-toolbar-tool-replace-close' => 'Luk',
	'wikieditor-toolbar-tool-replace-nomatch' => 'Din søgning gav ingen resultater',
	'wikieditor-toolbar-tool-replace-success' => '$1 udskiftning(er) foretaget.',
	'wikieditor-toolbar-tool-replace-emptysearch' => 'Du skrev ikke noget at søge efter',
	'wikieditor-toolbar-tool-replace-invalidregex' => 'Det regulære udtryk du skrev er ugyldigt: $1',
	'wikieditor-toolbar-section-characters' => 'Specialtegn',
	'wikieditor-toolbar-characters-page-latin' => 'Latin',
	'wikieditor-toolbar-characters-page-latinextended' => 'Udvidet latin',
	'wikieditor-toolbar-characters-page-ipa' => 'IPA',
	'wikieditor-toolbar-characters-page-symbols' => 'Symboler',
	'wikieditor-toolbar-characters-page-greek' => 'Græsk',
	'wikieditor-toolbar-characters-page-cyrillic' => 'Kyrillisk',
	'wikieditor-toolbar-characters-page-arabic' => 'Arabisk',
	'wikieditor-toolbar-characters-page-arabicextended' => 'Udvidet arabisk',
	'wikieditor-toolbar-characters-page-persian' => 'Persisk',
	'wikieditor-toolbar-characters-page-hebrew' => 'Hebraisk',
	'wikieditor-toolbar-characters-page-bangla' => 'Bengali',
	'wikieditor-toolbar-characters-page-tamil' => 'Tamilsk',
	'wikieditor-toolbar-characters-page-telugu' => 'Telugu',
	'wikieditor-toolbar-characters-page-sinhala' => 'Singalesisk',
	'wikieditor-toolbar-characters-page-gujarati' => 'Gujarati',
	'wikieditor-toolbar-characters-page-devanagari' => 'Devanagari',
	'wikieditor-toolbar-characters-page-thai' => 'Thai',
	'wikieditor-toolbar-characters-page-lao' => 'Laotisk',
	'wikieditor-toolbar-characters-page-khmer' => 'Khmer',
	'wikieditor-toolbar-section-help' => 'Hjælp',
	'wikieditor-toolbar-help-heading-description' => 'Beskrivelse',
	'wikieditor-toolbar-help-heading-syntax' => 'Hvad du skriver',
	'wikieditor-toolbar-help-heading-result' => 'Hvad du får',
	'wikieditor-toolbar-help-page-format' => 'Formatering',
	'wikieditor-toolbar-help-page-link' => 'Henvisninger',
	'wikieditor-toolbar-help-page-heading' => 'Overskrifter',
	'wikieditor-toolbar-help-page-list' => 'Lister',
	'wikieditor-toolbar-help-page-file' => 'Filer',
	'wikieditor-toolbar-help-page-reference' => 'Fodnoter',
	'wikieditor-toolbar-help-page-discussion' => 'Diskussion',
	'wikieditor-toolbar-help-content-italic-description' => 'Kursiv',
	'wikieditor-toolbar-help-content-italic-syntax' => "''Kursiv tekst''",
	'wikieditor-toolbar-help-content-italic-result' => '<em>Kursiv tekst</em>',
	'wikieditor-toolbar-help-content-bold-description' => 'Fed',
	'wikieditor-toolbar-help-content-bold-syntax' => "'''Fed tekst'''",
	'wikieditor-toolbar-help-content-bold-result' => '<strong>Fed tekst</strong>',
	'wikieditor-toolbar-help-content-bolditalic-description' => 'Fed &amp; kursiv',
	'wikieditor-toolbar-help-content-bolditalic-syntax' => "'''''Fed &amp; kursiv tekst'''''",
	'wikieditor-toolbar-help-content-bolditalic-result' => '<strong><em>Fed &amp; kursiv tekst</em></strong>',
	'wikieditor-toolbar-help-content-ilink-description' => 'Intern henvisning',
	'wikieditor-toolbar-help-content-ilink-syntax' => '[[Sidetitel|Henvisningstekst]]<br />[[Sidetitel]]',
	'wikieditor-toolbar-help-content-ilink-result' => "<a href='#'>Henvisningstekst</a><br /><a href='#'>Sidetitel</a>",
	'wikieditor-toolbar-help-content-xlink-description' => 'Ekstern henvisning',
	'wikieditor-toolbar-help-content-xlink-syntax' => '[http://www.example.org Henvisningstekst]<br />[http://www.example.org]<br />http://www.example.org',
	'wikieditor-toolbar-help-content-xlink-result' => "<a href='#' class='external'>Henvisningstekst</a><br /><a href='#' class='external autonumber'>[1]</a><br /><a href='#' class='external'>http://www.example.org</a>",
	'wikieditor-toolbar-help-content-heading2-description' => 'Overskrift på niveau 2',
	'wikieditor-toolbar-help-content-heading2-syntax' => '== Overskriftstekst ==',
	'wikieditor-toolbar-help-content-heading2-result' => '<h2>Overskriftstekst</h2>',
	'wikieditor-toolbar-help-content-heading3-description' => 'Overskrift på niveau 3',
	'wikieditor-toolbar-help-content-heading3-syntax' => '=== Overskriftstekst ===',
	'wikieditor-toolbar-help-content-heading3-result' => '<h3>Overskriftstekst</h3>',
	'wikieditor-toolbar-help-content-heading4-description' => 'Overskrift på niveau 4',
	'wikieditor-toolbar-help-content-heading4-syntax' => '==== Overskriftstekst ====',
	'wikieditor-toolbar-help-content-heading4-result' => '<h4>Overskriftstekst</h4>',
	'wikieditor-toolbar-help-content-heading5-description' => 'Overskrift på niveau 5',
	'wikieditor-toolbar-help-content-heading5-syntax' => '===== Overskriftstekst =====',
	'wikieditor-toolbar-help-content-heading5-result' => '<h5>Overskriftstekst</h5>',
	'wikieditor-toolbar-help-content-ulist-description' => 'Punktliste',
	'wikieditor-toolbar-help-content-ulist-syntax' => '* Listeelement<br />* Listeelement',
	'wikieditor-toolbar-help-content-ulist-result' => '<ul><li>Listeelement</li><li>Listeelement</li></ul>',
	'wikieditor-toolbar-help-content-olist-description' => 'Nummereret liste',
	'wikieditor-toolbar-help-content-olist-syntax' => '# Listeelement<br /># Listeelement',
	'wikieditor-toolbar-help-content-olist-result' => '<ol><li>Listeelement</li><li>Listeelement</li></ol>',
	'wikieditor-toolbar-help-content-file-description' => 'Indlejret fil',
	'wikieditor-toolbar-help-content-file-syntax' => '[[$1:Example.png|thumb|Billedtekst]]',
	'wikieditor-toolbar-help-content-file-result' => "<div style='width:104px;' class='thumbinner'><a title='Billedtekst' class='image' href='#'><img height='50' width='100' border='0' class='thumbimage' src='$2/WikiEditor/modules/images/toolbar/example-image.png' alt=''/></a><div class='thumbcaption'><div class='magnify'><a title='Forstør' class='internal' href='#'><img height='11' width='15' alt='' src='$1/common/images/magnify-clip.png'/></a></div>Billedtekst</div></div>",
	'wikieditor-toolbar-help-content-reference-description' => 'Fodnote',
	'wikieditor-toolbar-help-content-reference-syntax' => 'Sidetekst.&lt;ref name="test"&gt;[http://www.example.org Henvisningstekst], yderligere tekst.&lt;/ref&gt;',
	'wikieditor-toolbar-help-content-reference-result' => "Sidetekst.<sup><a href='#'>[1]</a></sup>",
	'wikieditor-toolbar-help-content-rereference-description' => 'Yderligere henvisninger til samme fodnote',
	'wikieditor-toolbar-help-content-rereference-result' => "Sidetekst.<sup><a href='#'>[1]</a></sup>",
	'wikieditor-toolbar-help-content-showreferences-description' => 'Vis fodnoter',
	'wikieditor-toolbar-help-content-showreferences-result' => "<ol class='references'><li id='cite_note-test-0'><b><a title='' href='#'>^</a></b> <a rel='nofollow' title='http://www.example.org' class='external text' href='#'>Henvisningstekst</a>, yderligere tekst.</li></ol>",
	'wikieditor-toolbar-help-content-signaturetimestamp-description' => 'Signatur og tidsstempel',
	'wikieditor-toolbar-help-content-signaturetimestamp-result' => "<a href='#' title='{{#special:mypage}}'>Brugernavn</a> (<a href='#' title='{{#special:mytalk}}'>diskussion</a>) 10. juni 2009, 15:54 (CEST)",
	'wikieditor-toolbar-help-content-signature-description' => 'Signatur',
	'wikieditor-toolbar-help-content-signature-result' => "<a href='#' title='{{#special:mypage}}'>Brugernavn</a> (<a href='#' title='{{#special:mytalk}}'>diskussion</a>)",
	'wikieditor-toolbar-help-content-indent-description' => 'Indrykning',
	'wikieditor-toolbar-help-content-indent-syntax' => 'Normal tekst<br />:Indrykket tekst<br />::Indrykket tekst',
	'wikieditor-toolbar-help-content-indent-result' => 'Normal tekst<dl><dd>Indrykket tekst<dl><dd>Indrykket tekst</dd></dl></dd></dl>',
);

/** German (Deutsch)
 * @author Als-Holder
 * @author Church of emacs
 * @author DaSch
 * @author Kghbln
 * @author MF-Warburg
 * @author Metalhead64
 * @author Mikullovci11
 * @author Ojay
 * @author Umherirrender
 * @author Ziko
 * @author ✓
 */
$messages['de'] = array(
	'wikieditor' => 'Fortgeschrittener Wikitext-Editor',
	'wikieditor-desc' => 'Ermöglicht eine erweiterbare Oberfläche zur Wikitext-Bearbeitung sowie viele weitere neue Funktionen',
	'wikieditor-wikitext-tab' => 'Wikitext',
	'wikieditor-loading' => 'Lade …',
	'wikieditor-preview-preference' => 'Gegenüberstellungsvorschau ermöglichen',
	'wikieditor-preview-tab' => 'Vorschau',
	'wikieditor-preview-changes-tab' => 'Änderungen',
	'wikieditor-preview-loading' => 'Lade …',
	'wikieditor-previewDialog-preference' => 'Aktiviere die Abfrage zur Vorschau',
	'wikieditor-previewDialog-tab' => 'Vorschau',
	'wikieditor-previewDialog-loading' => 'Lade …',
	'wikieditor-publish-preference' => 'Schritt-für-Schritt-Veröffentlichung ermöglichen',
	'wikieditor-publish-button-publish' => 'Veröffentlichen',
	'wikieditor-publish-button-cancel' => 'Abbrechen',
	'wikieditor-publish-dialog-title' => 'Auf {{SITENAME}} veröffentlichen',
	'wikieditor-publish-dialog-summary' => 'Zusammenfassung (kurze Beschreibung der von dir vorgenommenen Änderungen):',
	'wikieditor-publish-dialog-minor' => 'Kleine Änderung',
	'wikieditor-publish-dialog-watch' => 'Diese Seite beobachten',
	'wikieditor-publish-dialog-publish' => 'Veröffentlichen',
	'wikieditor-publish-dialog-goback' => 'Zurück',
	'wikieditor-template-editor-preference' => 'Formulargestütztes Bearbeiten von Wikivorlagen aktivieren',
	'wikieditor-template-editor-dialog-title' => 'Vorlage bearbeiten',
	'wikieditor-template-editor-dialog-submit' => 'Aktualisieren',
	'wikieditor-template-editor-dialog-cancel' => 'Abbrechen',
	'wikieditor-templates-preference' => 'Aktivierung des Ein- und Ausblendens von Vorlagen',
	'wikieditor-toc-preference' => 'Inhaltsverzeichnis im Bearbeitungsfenster aktivieren',
	'wikieditor-toc-show' => 'Inhaltsverzeichnis einblenden',
	'wikieditor-toc-hide' => 'Inhaltsverzeichnis ausblenden',
	'wikieditor-toolbar' => 'Bearbeiten-Werkzeugleiste',
	'wikieditor-toolbar-desc' => 'Bearbeiten-Werkzeugleiste mit erweiterter Benutzerfreundlichkeit',
	'wikieditor-toolbar-preference' => 'Erweiterte Bearbeiten-Werkzeugleiste aktivieren',
	'wikieditor-toolbar-dialogs-preference' => 'Dialoge für das Einfügen von Links, Tabellen usw. aktivieren',
	'wikieditor-toolbar-hidesig' => 'Die Schaltfläche für die Signatur bei Seiten im Artikelnamensraum ausblenden',
	'wikieditor-toolbar-loading' => 'Lade …',
	'wikieditor-toolbar-tool-bold' => 'Fett',
	'wikieditor-toolbar-tool-bold-example' => 'Fetter Text',
	'wikieditor-toolbar-tool-italic' => 'Kursiv',
	'wikieditor-toolbar-tool-italic-example' => 'Kursiver Text',
	'wikieditor-toolbar-tool-ilink' => 'Interner Link',
	'wikieditor-toolbar-tool-ilink-example' => 'Linktitel',
	'wikieditor-toolbar-tool-xlink' => 'Externer Link (http:// beachten)',
	'wikieditor-toolbar-tool-xlink-example' => 'http://www.example.org Text für den Link',
	'wikieditor-toolbar-tool-link' => 'Link',
	'wikieditor-toolbar-tool-link-title' => 'Link einfügen',
	'wikieditor-toolbar-tool-link-int' => 'Zu einer Wikiseite',
	'wikieditor-toolbar-tool-link-int-target' => 'Zielseite oder URL:',
	'wikieditor-toolbar-tool-link-int-target-tooltip' => 'Der Titel oder die URL der Seite',
	'wikieditor-toolbar-tool-link-int-text' => 'Anzuzeigender Text / Text für den Link:',
	'wikieditor-toolbar-tool-link-int-text-tooltip' => 'Der Text, der angezeigt werden soll',
	'wikieditor-toolbar-tool-link-ext' => 'Zu einer externen Internetseite',
	'wikieditor-toolbar-tool-link-ext-target' => 'URL des Links:',
	'wikieditor-toolbar-tool-link-ext-text' => 'Linkbezeichnung:',
	'wikieditor-toolbar-tool-link-insert' => 'Link einfügen',
	'wikieditor-toolbar-tool-link-cancel' => 'Abbrechen',
	'wikieditor-toolbar-tool-link-int-target-status-exists' => 'Seite bereits vorhanden',
	'wikieditor-toolbar-tool-link-int-target-status-notexists' => 'Seite existiert nicht',
	'wikieditor-toolbar-tool-link-int-target-status-invalid' => 'Ungültiger Titel',
	'wikieditor-toolbar-tool-link-int-target-status-external' => 'Externer Link',
	'wikieditor-toolbar-tool-link-int-target-status-loading' => 'Prüfe, ob Seite vorhanden ist …',
	'wikieditor-toolbar-tool-link-int-invalid' => 'Der angegebene Seitenname ist ungültig.',
	'wikieditor-toolbar-tool-link-lookslikeinternal' => 'Die von dir angegebene URL wirkt wie eine, die auf eine andere Wikiseite verlinken würde.
Möchtest du daraus einen internen Link machen?',
	'wikieditor-toolbar-tool-link-lookslikeinternal-int' => 'Interner Link',
	'wikieditor-toolbar-tool-link-lookslikeinternal-ext' => 'Externer Link',
	'wikieditor-toolbar-tool-link-empty' => 'Du hast nichts zum Verlinken angegeben.',
	'wikieditor-toolbar-tool-file' => 'Eingebettete Datei',
	'wikieditor-toolbar-tool-file-example' => 'Beispiel.jpg',
	'wikieditor-toolbar-tool-file-title' => 'Datei einfügen',
	'wikieditor-toolbar-file-target' => 'Dateiname:',
	'wikieditor-toolbar-file-caption' => 'Legende:',
	'wikieditor-toolbar-file-size' => 'Größe:',
	'wikieditor-toolbar-file-float' => 'Ausrichtung:',
	'wikieditor-toolbar-file-default' => '(Standard)',
	'wikieditor-toolbar-file-format' => 'Format:',
	'wikieditor-toolbar-file-format-none' => 'keine',
	'wikieditor-toolbar-tool-file-insert' => 'Einfügen',
	'wikieditor-toolbar-tool-file-cancel' => 'Abbrechen',
	'wikieditor-toolbar-tool-reference' => 'Quellenangabe',
	'wikieditor-toolbar-tool-reference-example' => 'Hier den Fußnotentext eingeben',
	'wikieditor-toolbar-tool-reference-cancel' => 'Abbrechen',
	'wikieditor-toolbar-tool-reference-title' => 'Einzelnachweis einfügen',
	'wikieditor-toolbar-tool-reference-insert' => 'Einfügen',
	'wikieditor-toolbar-tool-reference-text' => 'Text des Einzelnachweises',
	'wikieditor-toolbar-tool-signature' => 'Signatur und Zeitstempel',
	'wikieditor-toolbar-section-advanced' => 'Erweitert',
	'wikieditor-toolbar-tool-heading' => 'Überschrift',
	'wikieditor-toolbar-tool-heading-1' => 'Ebene 1',
	'wikieditor-toolbar-tool-heading-2' => 'Ebene 2',
	'wikieditor-toolbar-tool-heading-3' => 'Ebene 3',
	'wikieditor-toolbar-tool-heading-4' => 'Ebene 4',
	'wikieditor-toolbar-tool-heading-5' => 'Ebene 5',
	'wikieditor-toolbar-tool-heading-example' => 'Kopfzeile',
	'wikieditor-toolbar-group-format' => 'Format',
	'wikieditor-toolbar-tool-ulist' => 'Aufgezählte Liste',
	'wikieditor-toolbar-tool-ulist-example' => 'Aufgezählter Listeneintrag',
	'wikieditor-toolbar-tool-olist' => 'Nummerierte Liste',
	'wikieditor-toolbar-tool-olist-example' => 'Nummerierter Listeneintrag',
	'wikieditor-toolbar-tool-indent' => 'Einrückung',
	'wikieditor-toolbar-tool-indent-example' => 'Eingerückte Zeile',
	'wikieditor-toolbar-tool-nowiki' => 'Keine Wikiformatierung',
	'wikieditor-toolbar-tool-nowiki-example' => 'Hier den unformatierten Text eingeben',
	'wikieditor-toolbar-tool-redirect' => 'Weiterleitung',
	'wikieditor-toolbar-tool-redirect-example' => 'Name der Zielseite',
	'wikieditor-toolbar-tool-big' => 'Groß',
	'wikieditor-toolbar-tool-big-example' => 'Großer Text',
	'wikieditor-toolbar-tool-small' => 'Klein',
	'wikieditor-toolbar-tool-small-example' => 'Kleiner Text',
	'wikieditor-toolbar-tool-superscript' => 'Hochgestellt',
	'wikieditor-toolbar-tool-superscript-example' => 'Hochgestellter Text',
	'wikieditor-toolbar-tool-subscript' => 'Tiefgestellt',
	'wikieditor-toolbar-tool-subscript-example' => 'Tiefgestellter Text',
	'wikieditor-toolbar-group-insert' => 'Einfügen',
	'wikieditor-toolbar-tool-gallery' => 'Bildergalerie',
	'wikieditor-toolbar-tool-gallery-example' => '$1:Beispiel.jpg|Beschreibung1
$1:Beispiel.jpg|Beschreibung2',
	'wikieditor-toolbar-tool-newline' => 'Zeilenumbruch erzwingen (nicht im Fließtext verwenden)',
	'wikieditor-toolbar-tool-table' => 'Tabelle',
	'wikieditor-toolbar-tool-table-example-old' => '-
! Überschrift 1
! Überschrift 2
! Überschrift 3
|-
| Zeile 1, Zelle 1
| Zeile 1, Zelle 2
| Zeile 1, Zelle 3
|-
| Zeile 2, Zelle 1
| Zeile 2, Zelle 2
| Zeile 2, Zelle 3',
	'wikieditor-toolbar-tool-table-example-cell-text' => 'Zellentext',
	'wikieditor-toolbar-tool-table-example-header' => 'Überschrift',
	'wikieditor-toolbar-tool-table-title' => 'Tabelle einfügen',
	'wikieditor-toolbar-tool-table-dimensions-rows' => 'Zeilen',
	'wikieditor-toolbar-tool-table-dimensions-columns' => 'Spalten',
	'wikieditor-toolbar-tool-table-dimensions-header' => 'mit Kopfzeile',
	'wikieditor-toolbar-tool-table-wikitable' => 'mit Rahmen',
	'wikieditor-toolbar-tool-table-sortable' => 'Tabelle sortierbar machen',
	'wikieditor-toolbar-tool-table-example' => 'Beispiel',
	'wikieditor-toolbar-tool-table-preview' => 'Vorschau',
	'wikieditor-toolbar-tool-table-insert' => 'Einfügen',
	'wikieditor-toolbar-tool-table-cancel' => 'Abbrechen',
	'wikieditor-toolbar-tool-table-toomany' => 'Das Einfügen einer Tabelle mit mehr als $1 Zellen ist mit diesem Dialog nicht möglich.',
	'wikieditor-toolbar-tool-table-invalidnumber' => 'Du hast keine gültige Anzahl von Zeilen oder Spalten angegeben.',
	'wikieditor-toolbar-tool-table-zero' => 'Du kannst keine Tabelle einfügen, die weder Zeilen noch Spalten hat.',
	'wikieditor-toolbar-tool-replace' => 'Suchen und Ersetzen',
	'wikieditor-toolbar-tool-replace-title' => 'Suchen und Ersetzen',
	'wikieditor-toolbar-tool-replace-search' => 'Suche nach:',
	'wikieditor-toolbar-tool-replace-replace' => 'Ersetze durch:',
	'wikieditor-toolbar-tool-replace-case' => 'Groß- und Kleinschreibung beachten',
	'wikieditor-toolbar-tool-replace-regex' => 'Die Zeichenkette der Suche als regulären Ausdruck behandeln',
	'wikieditor-toolbar-tool-replace-button-findnext' => 'Nächste finden',
	'wikieditor-toolbar-tool-replace-button-replace' => 'Ersetzen',
	'wikieditor-toolbar-tool-replace-button-replaceall' => 'Alle ersetzen',
	'wikieditor-toolbar-tool-replace-close' => 'Schließen',
	'wikieditor-toolbar-tool-replace-nomatch' => 'Deine Suche hat keine Ergebnisse erbracht.',
	'wikieditor-toolbar-tool-replace-success' => '$1 Ersetzung(en) durchgeführt.',
	'wikieditor-toolbar-tool-replace-emptysearch' => 'Du hast nichts zum Suchen eingegeben.',
	'wikieditor-toolbar-tool-replace-invalidregex' => 'Der eingegebene reguläre Ausdruck ist ungültig: $1',
	'wikieditor-toolbar-section-characters' => 'Sonderzeichen',
	'wikieditor-toolbar-characters-page-latin' => 'Lateinisch',
	'wikieditor-toolbar-characters-page-latinextended' => 'Lateinisch, erweitert',
	'wikieditor-toolbar-characters-page-ipa' => 'Internationales Phonetisches Alphabet (IPA)',
	'wikieditor-toolbar-characters-page-symbols' => 'Symbole',
	'wikieditor-toolbar-characters-page-greek' => 'Griechisch',
	'wikieditor-toolbar-characters-page-cyrillic' => 'Kyrillisch',
	'wikieditor-toolbar-characters-page-arabic' => 'Arabisch',
	'wikieditor-toolbar-characters-page-arabicextended' => 'Arabisch, erweitert',
	'wikieditor-toolbar-characters-page-persian' => 'Persisch',
	'wikieditor-toolbar-characters-page-hebrew' => 'Hebräisch',
	'wikieditor-toolbar-characters-page-bangla' => 'Bengalisch',
	'wikieditor-toolbar-characters-page-tamil' => 'Tamilisch',
	'wikieditor-toolbar-characters-page-telugu' => 'Telugu',
	'wikieditor-toolbar-characters-page-sinhala' => 'Singhalesisch',
	'wikieditor-toolbar-characters-page-gujarati' => 'Gujarati',
	'wikieditor-toolbar-characters-page-devanagari' => 'Devanagari',
	'wikieditor-toolbar-characters-page-thai' => 'Thailändisch',
	'wikieditor-toolbar-characters-page-lao' => 'Laotisch',
	'wikieditor-toolbar-characters-page-khmer' => 'Khmer',
	'wikieditor-toolbar-section-help' => 'Hilfe',
	'wikieditor-toolbar-help-heading-description' => 'Beschreibung',
	'wikieditor-toolbar-help-heading-syntax' => 'Was du eingibst',
	'wikieditor-toolbar-help-heading-result' => 'Wie es aussieht',
	'wikieditor-toolbar-help-page-format' => 'Formatierung',
	'wikieditor-toolbar-help-page-link' => 'Links',
	'wikieditor-toolbar-help-page-heading' => 'Überschriften',
	'wikieditor-toolbar-help-page-list' => 'Listen',
	'wikieditor-toolbar-help-page-file' => 'Dateien',
	'wikieditor-toolbar-help-page-reference' => 'Quellenangaben',
	'wikieditor-toolbar-help-page-discussion' => 'Diskussion',
	'wikieditor-toolbar-help-content-italic-description' => 'Kursiv',
	'wikieditor-toolbar-help-content-italic-syntax' => "''Kursiver Text''",
	'wikieditor-toolbar-help-content-italic-result' => '<em>Kursiver Text</em>',
	'wikieditor-toolbar-help-content-bold-description' => 'Fett',
	'wikieditor-toolbar-help-content-bold-syntax' => "'''Fetter Text'''",
	'wikieditor-toolbar-help-content-bold-result' => '<strong>Fetter Text</strong>',
	'wikieditor-toolbar-help-content-bolditalic-description' => 'Fett und kursiv',
	'wikieditor-toolbar-help-content-bolditalic-syntax' => "'''''Fetter und kursiver Text'''''",
	'wikieditor-toolbar-help-content-bolditalic-result' => '<strong><em>Fetter und kursiver Text</em></strong>',
	'wikieditor-toolbar-help-content-ilink-description' => 'Interner Link',
	'wikieditor-toolbar-help-content-ilink-syntax' => '[[Seitentitel|Linktext]]<br />[[Seitentitel]]',
	'wikieditor-toolbar-help-content-ilink-result' => "<a href='#'>Linktext</a><br /><a href='#'>Seitentitel</a>",
	'wikieditor-toolbar-help-content-xlink-description' => 'Externer Link',
	'wikieditor-toolbar-help-content-xlink-syntax' => '[http://www.example.org Linktext]<br />[http://www.example.org]<br />http://www.example.org',
	'wikieditor-toolbar-help-content-xlink-result' => "<a href='#' class='external'>Linktext</a><br /><a href='#' class='external autonumber'>[1]</a><br /><a href='#' class='external'>http://www.example.org</a>",
	'wikieditor-toolbar-help-content-heading2-description' => 'Kopfzeile Ebene 2',
	'wikieditor-toolbar-help-content-heading2-syntax' => '== Überschrift ==',
	'wikieditor-toolbar-help-content-heading2-result' => '<h2>Überschrift</h2>',
	'wikieditor-toolbar-help-content-heading3-description' => 'Kopfzeile Ebene 3',
	'wikieditor-toolbar-help-content-heading3-syntax' => '=== Überschrift ===',
	'wikieditor-toolbar-help-content-heading3-result' => '<h3>Überschrift</h3>',
	'wikieditor-toolbar-help-content-heading4-description' => 'Kopfzeile Ebene 4',
	'wikieditor-toolbar-help-content-heading4-syntax' => '==== Überschrift ====',
	'wikieditor-toolbar-help-content-heading4-result' => '<h4>Überschrift</h4>',
	'wikieditor-toolbar-help-content-heading5-description' => 'Kopfzeile Ebene 5',
	'wikieditor-toolbar-help-content-heading5-syntax' => '===== Überschrift =====',
	'wikieditor-toolbar-help-content-heading5-result' => '<h5>Überschrift</h5>',
	'wikieditor-toolbar-help-content-ulist-description' => 'Aufgezählte Liste',
	'wikieditor-toolbar-help-content-ulist-syntax' => '* Listeneintrag<br />* Listeneintrag',
	'wikieditor-toolbar-help-content-ulist-result' => '<ul><li>Listeneintrag</li><li>Listeneintrag</li></ul>',
	'wikieditor-toolbar-help-content-olist-description' => 'Nummerierte Liste',
	'wikieditor-toolbar-help-content-olist-syntax' => '# Listeneintrag<br /># Listeneintrag',
	'wikieditor-toolbar-help-content-olist-result' => '<ol><li>Listeneintrag</li><li>Listeneintrag</li></ol>',
	'wikieditor-toolbar-help-content-file-description' => 'Eingebettete Datei',
	'wikieditor-toolbar-help-content-file-syntax' => '[[$1:Beispiel.png|miniatur|Beschreibung]]',
	'wikieditor-toolbar-help-content-file-result' => "<div style='width:104px;' class='thumbinner'><a title='Beschreibung' class='image' href='#'><img height='50' width='100' border='0' class='thumbimage' src='$2/WikiEditor/modules/images/toolbar/example-image.png' alt=''/></a><div class='thumbcaption'><div class='magnify'><a title='Vergrößern' class='internal' href='#'><img height='11' width='15' alt='' src='$1/common/images/magnify-clip.png'/></a></div>Beschreibung</div></div>",
	'wikieditor-toolbar-help-content-reference-description' => 'Einzelnachweis',
	'wikieditor-toolbar-help-content-reference-syntax' => 'Seitentext.&lt;ref name="test"&gt;[http://www.example.org Linktext], zusätzlicher Text.&lt;/ref&gt;',
	'wikieditor-toolbar-help-content-reference-result' => "Seitentext.<sup><a href='#'>[1]</a></sup>",
	'wikieditor-toolbar-help-content-rereference-description' => 'Den gleichen Einzelnachweis erneut verwenden',
	'wikieditor-toolbar-help-content-rereference-result' => "Seitentext.<sup><a href='#'>[1]</a></sup>",
	'wikieditor-toolbar-help-content-showreferences-description' => 'Einzelnachweise anzeigen',
	'wikieditor-toolbar-help-content-showreferences-result' => "<ol class='references'><li id='cite_note-test-0'><b><a title='' href='#'>^</a></b> <a rel='nofollow' title='http://www.example.org' class='external text' href='#'>Linktext</a>, zusätzlicher Text.</li></ol>",
	'wikieditor-toolbar-help-content-signaturetimestamp-description' => 'Signatur mit Zeitstempel',
	'wikieditor-toolbar-help-content-signaturetimestamp-result' => "<a href='#' title='{{#special:mypage}}'>Benutzername</a> (<a href='#' title='{{#special:mytalk}}'>Diskussion</a>) 15:54, 10. Jun. 2009 (UTC)",
	'wikieditor-toolbar-help-content-signature-description' => 'Signatur',
	'wikieditor-toolbar-help-content-signature-result' => "<a href='#' title='{{#special:mypage}}'>Benutzername</a> (<a href='#' title='{{#special:mytalk}}'>Diskussion</a>)",
	'wikieditor-toolbar-help-content-indent-description' => 'Einrücken',
	'wikieditor-toolbar-help-content-indent-syntax' => 'Normaler Text<br />:Eingerückter Text<br />::Eingerückter Text',
	'wikieditor-toolbar-help-content-indent-result' => 'Normaler Text<dl><dd>Eingerückter Text<dl><dd>Eingerückter Text</dd></dl></dd></dl>',
);

/** Swiss High German (Schweizer Hochdeutsch)
 * @author Geitost
 */
$messages['de-ch'] = array(
	'wikieditor-toolbar-tool-reference-example' => 'Fussnotentext hier einfügen',
	'wikieditor-toolbar-tool-big' => 'Gross',
	'wikieditor-toolbar-tool-big-example' => 'Grosser Text',
	'wikieditor-toolbar-tool-newline' => 'Zeilenumbruch erzwingen (nicht im Fliesstext verwenden)',
	'wikieditor-toolbar-tool-replace-case' => 'Gross- und Kleinschreibung beachten',
	'wikieditor-toolbar-tool-replace-close' => 'Schliessen',
	'wikieditor-toolbar-help-content-file-result' => "<div style='width:104px;' class='thumbinner'><a title='Beschreibung' class='image' href='#'><img height='50' width='100' border='0' class='thumbimage' src='$2/WikiEditor/modules/images/toolbar/example-image.png' alt=''/></a><div class='thumbcaption'><div class='magnify'><a title='Vergrössern' class='internal' href='#'><img height='11' width='15' alt='' src='$1/common/images/magnify-clip.png'/></a></div>Beschreibung</div></div>",
);

/** German (formal address) (Deutsch (Sie-Form)‎)
 * @author Imre
 * @author Kghbln
 */
$messages['de-formal'] = array(
	'wikieditor-publish-dialog-summary' => 'Zusammenfassung (kurze Beschreibung der von Ihnen vorgenommenen Änderungen):',
	'wikieditor-toolbar-tool-link-lookslikeinternal' => 'Die von Ihnen angegebene URL wirkt wie eine, die auf eine andere Wikiseite verlinken würde.
Möchten Sie daraus einen internen Link machen?',
	'wikieditor-toolbar-tool-link-empty' => 'Sie haben nichts zum Verlinken angegeben.',
	'wikieditor-toolbar-tool-table-invalidnumber' => 'Sie haben keine gültige Anzahl von Zeilen oder Spalten angegeben.',
	'wikieditor-toolbar-tool-table-zero' => 'Sie können keine Tabelle einfügen, die weder Zeilen noch Spalten hat.',
	'wikieditor-toolbar-tool-replace-nomatch' => 'Ihre Suche hat keine Ergebnisse erzielt.',
	'wikieditor-toolbar-tool-replace-emptysearch' => 'Sie haben nichts zum Suchen eingegeben.',
	'wikieditor-toolbar-help-heading-syntax' => 'Was Sie eingeben',
);

/** Zazaki (Zazaki)
 * @author Erdemaslancan
 * @author Mirzali
 * @author Xoser
 */
$messages['diq'] = array(
	'wikieditor' => 'Interfaceye wikitext ke raver siyayo',
	'wikieditor-desc' => 'Yew pedê nuştişiyê girdi u moduleyanê binan dano',
	'wikieditor-wikitext-tab' => 'Wikimetin',
	'wikieditor-loading' => 'Bar keno',
	'wikieditor-preview-preference' => 'verqeyde miqeyese a bike',
	'wikieditor-preview-tab' => 'Verqayt',
	'wikieditor-preview-changes-tab' => 'Vurnayışi',
	'wikieditor-preview-loading' => 'Ho bar keno...',
	'wikieditor-previewDialog-preference' => 'Verqaytê mesacan bıqefılne',
	'wikieditor-previewDialog-tab' => 'Verqayt',
	'wikieditor-previewDialog-loading' => 'Ho bar keno...',
	'wikieditor-publish-preference' => 'Game be game çap kerdişi a bike',
	'wikieditor-publish-button-publish' => 'Vıla ke',
	'wikieditor-publish-button-cancel' => 'Iptal bike',
	'wikieditor-publish-dialog-title' => '{{SITENAME}} rê çap ke',
	'wikieditor-publish-dialog-summary' => 'Xulasayê vurnayişi (ser vurnayişê xo xulasa binuse):',
	'wikieditor-publish-dialog-minor' => 'Vurnayişo qickek',
	'wikieditor-publish-dialog-watch' => 'Ena pele seyr ke',
	'wikieditor-publish-dialog-publish' => 'Vıla ke',
	'wikieditor-publish-dialog-goback' => 'Reyna şi',
	'wikieditor-template-editor-preference' => 'Vurnayışê form-bıngeyınê şablonanê wikiy feal ke',
	'wikieditor-template-editor-dialog-title' => 'Sabloni bivurnê',
	'wikieditor-template-editor-dialog-submit' => 'Noroc resn',
	'wikieditor-template-editor-dialog-cancel' => 'Bıterkne',
	'wikieditor-templates-preference' => 'Qic kerdisê sabloni a bike',
	'wikieditor-toc-preference' => 'Tabloyo tedeesteyi ke navigasyon keno ay a bike',
	'wikieditor-toc-show' => 'Tedeesteyi bimocne',
	'wikieditor-toc-hide' => 'Tedeesteyi binumne',
	'wikieditor-toolbar' => 'nizamkerdışê çuyaya haceti',
	'wikieditor-toolbar-desc' => 'Xacetê çuveyî pê enhanced usability bivurne',
	'wikieditor-toolbar-preference' => 'çuyaya haceti yo dewlemendbiyayeyi aktif ker',
	'wikieditor-toolbar-dialogs-preference' => "qey têare kerdışê gıre, tablo usb'ani mesajan aktif bıker",
	'wikieditor-toolbar-hidesig' => 'Vanganê naman de serênan pela dı maka  imzer bınımnê',
	'wikieditor-toolbar-loading' => 'bar beno...',
	'wikieditor-toolbar-tool-bold' => 'qalın',
	'wikieditor-toolbar-tool-bold-example' => 'Metno qalın',
	'wikieditor-toolbar-tool-italic' => 'İtalik',
	'wikieditor-toolbar-tool-italic-example' => 'Metno vırandere',
	'wikieditor-toolbar-tool-ilink' => 'Gıreyê miyani',
	'wikieditor-toolbar-tool-ilink-example' => 'sernameyê gıreyi',
	'wikieditor-toolbar-tool-xlink' => 'gıreyê teberi (http:// prefixi xo vir ra mekerê)',
	'wikieditor-toolbar-tool-xlink-example' => 'http://www.misal.com sernameyê gıreyi',
	'wikieditor-toolbar-tool-link' => 'Link',
	'wikieditor-toolbar-tool-link-title' => 'Gıre bıerz',
	'wikieditor-toolbar-tool-link-int' => 'yew pelê wiki re',
	'wikieditor-toolbar-tool-link-int-target' => 'sernameyê peli',
	'wikieditor-toolbar-tool-link-int-target-tooltip' => 'Sernamey ya zi URL',
	'wikieditor-toolbar-tool-link-int-text' => 'metnê gıreyi',
	'wikieditor-toolbar-tool-link-int-text-tooltip' => 'Nuştewo ke gani bımocniyo ey bınuse',
	'wikieditor-toolbar-tool-link-ext' => 'yew keyepelê teberi re',
	'wikieditor-toolbar-tool-link-ext-target' => "Greyê URL'i:",
	'wikieditor-toolbar-tool-link-ext-text' => 'Metnê gri:',
	'wikieditor-toolbar-tool-link-insert' => 'Gıre bıerz',
	'wikieditor-toolbar-tool-link-cancel' => 'ibtal',
	'wikieditor-toolbar-tool-link-int-target-status-exists' => 'pel esto',
	'wikieditor-toolbar-tool-link-int-target-status-notexists' => 'pel çino',
	'wikieditor-toolbar-tool-link-int-target-status-invalid' => 'Sernameyo xırab.',
	'wikieditor-toolbar-tool-link-int-target-status-external' => 'Gırêy teberi',
	'wikieditor-toolbar-tool-link-int-target-status-loading' => 'mewcudiyetê peli konrol beno',
	'wikieditor-toolbar-tool-link-int-invalid' => 'Sernameyo ke şımayê vanê ravêrde niyo.',
	'wikieditor-toolbar-tool-link-lookslikeinternal' => 'URLyo ke şıma nişan kerdo, pelê yewna wikiyi re gıre biyo aseno.
şıma wazeni no gıre yew gıreyo daxili bıbo?',
	'wikieditor-toolbar-tool-link-lookslikeinternal-int' => 'Gıreyê miyani',
	'wikieditor-toolbar-tool-link-lookslikeinternal-ext' => 'Gırêy teberi',
	'wikieditor-toolbar-tool-link-empty' => 'Gırey to be thebay çıniyo.',
	'wikieditor-toolbar-tool-file' => 'dosyaya  wedarteyi/weradaye',
	'wikieditor-toolbar-tool-file-example' => 'misal.jpg',
	'wikieditor-toolbar-tool-file-title' => 'Dosya bıerz',
	'wikieditor-toolbar-file-target' => 'Nameyê dosya:',
	'wikieditor-toolbar-file-caption' => 'Bınnuşte',
	'wikieditor-toolbar-file-size' => 'Gırdiye',
	'wikieditor-toolbar-file-float' => 'Ratnayış:',
	'wikieditor-toolbar-file-default' => '(hesıbyaye)',
	'wikieditor-toolbar-file-format' => 'Format:',
	'wikieditor-toolbar-file-format-none' => 'çıniyo',
	'wikieditor-toolbar-tool-file-insert' => 'Têare ker',
	'wikieditor-toolbar-tool-file-cancel' => 'Bıterkne',
	'wikieditor-toolbar-tool-reference' => 'çıme',
	'wikieditor-toolbar-tool-reference-example' => 'metnê notê bınini tiya kerê',
	'wikieditor-toolbar-tool-reference-cancel' => 'Bıterkne',
	'wikieditor-toolbar-tool-reference-title' => 'Referance de bike',
	'wikieditor-toolbar-tool-reference-insert' => 'de bike',
	'wikieditor-toolbar-tool-reference-text' => 'Nusteyê Referansi',
	'wikieditor-toolbar-tool-signature' => 'tamğayê imza ve zamani',
	'wikieditor-toolbar-section-advanced' => 'Raver',
	'wikieditor-toolbar-tool-heading' => 'sername',
	'wikieditor-toolbar-tool-heading-1' => 'seviyeya 1.',
	'wikieditor-toolbar-tool-heading-2' => 'seviyeya 2.',
	'wikieditor-toolbar-tool-heading-3' => 'seviyeya 3.',
	'wikieditor-toolbar-tool-heading-4' => 'seviyeya 4.',
	'wikieditor-toolbar-tool-heading-5' => 'seviyeya 5.',
	'wikieditor-toolbar-tool-heading-example' => 'metnê sernameyi',
	'wikieditor-toolbar-group-format' => 'Format',
	'wikieditor-toolbar-tool-ulist' => 'listeya maddeya işaretıni',
	'wikieditor-toolbar-tool-ulist-example' => 'unsuro listeya maddeya işaretıni',
	'wikieditor-toolbar-tool-olist' => 'listeya numreyıni',
	'wikieditor-toolbar-tool-olist-example' => 'unsuro listeya numreyıni',
	'wikieditor-toolbar-tool-indent' => 'Paragraf',
	'wikieditor-toolbar-tool-indent-example' => 'Rêza paragrafi',
	'wikieditor-toolbar-tool-nowiki' => 'Formetê wiki çıniyo',
	'wikieditor-toolbar-tool-nowiki-example' => 'Ne-format nuşte itiya ra bıerz',
	'wikieditor-toolbar-tool-redirect' => 'Hetenayış',
	'wikieditor-toolbar-tool-redirect-example' => 'Nameyê pele ke hedef biyo',
	'wikieditor-toolbar-tool-big' => 'gırd',
	'wikieditor-toolbar-tool-big-example' => 'metno gırd',
	'wikieditor-toolbar-tool-small' => 'qıc',
	'wikieditor-toolbar-tool-small-example' => 'metno qıc',
	'wikieditor-toolbar-tool-superscript' => 'simgeya serıni',
	'wikieditor-toolbar-tool-superscript-example' => 'metnê simgeya serıni',
	'wikieditor-toolbar-tool-subscript' => 'simgeya cêrıni',
	'wikieditor-toolbar-tool-subscript-example' => 'metnê simgeya cêrıni',
	'wikieditor-toolbar-group-insert' => 'têare ker',
	'wikieditor-toolbar-tool-gallery' => 'galeriya resmi',
	'wikieditor-toolbar-tool-gallery-example' => '$1:misal.jpg|nuşteyê resmi1
$1:misal.jpg|nuşteyê resmi2',
	'wikieditor-toolbar-tool-newline' => 'satıro newe',
	'wikieditor-toolbar-tool-table' => 'Tablo',
	'wikieditor-toolbar-tool-table-example-old' => '-
! sername 1
! sername 2
! sername 3
|-
| satır 1, hucre 1
| satır 1, hucre 2
| satır 1, hucre 3
|-
| satır 2, hucre 1
| satır 2, hucre 2
| satır 2, hucre 3',
	'wikieditor-toolbar-tool-table-example-cell-text' => 'Metnê hucra',
	'wikieditor-toolbar-tool-table-example-header' => 'metnê sernameyi',
	'wikieditor-toolbar-tool-table-title' => 'Tablo bıerz',
	'wikieditor-toolbar-tool-table-dimensions-rows' => 'satıri/rêzi',
	'wikieditor-toolbar-tool-table-dimensions-columns' => 'estuni',
	'wikieditor-toolbar-tool-table-dimensions-header' => 'satırê sername zi bıger',
	'wikieditor-toolbar-tool-table-wikitable' => 'sinorê stili',
	'wikieditor-toolbar-tool-table-sortable' => 'make table rêz bena',
	'wikieditor-toolbar-tool-table-example' => 'metnê hucreyi',
	'wikieditor-toolbar-tool-table-preview' => 'Verqayt',
	'wikieditor-toolbar-tool-table-insert' => 'têare ker',
	'wikieditor-toolbar-tool-table-cancel' => 'ibtal',
	'wikieditor-toolbar-tool-table-toomany' => '$1 hucreyın ra ziyed tablo eştış pê no mesaj mumkin niyo',
	'wikieditor-toolbar-tool-table-invalidnumber' => 'şıma pê yew amaro meqbul o satır u estun cı nêkewti',
	'wikieditor-toolbar-tool-table-zero' => 'tablo ya ke tede satır u estun çinibo şıma nêşkeni têare bıkeri',
	'wikieditor-toolbar-tool-replace' => 'bıgêr u bıvurn',
	'wikieditor-toolbar-tool-replace-title' => 'bıgêr u bıvurn',
	'wikieditor-toolbar-tool-replace-search' => 'qey ıney bıgêr',
	'wikieditor-toolbar-tool-replace-replace' => 'pê ıney bıvurn',
	'wikieditor-toolbar-tool-replace-case' => 'harfa gırd u qıci re hessas o',
	'wikieditor-toolbar-tool-replace-regex' => 'qutiya cıgerayişi de yew muameleya ifade bıker.',
	'wikieditor-toolbar-tool-replace-button-findnext' => 'dıma ke yeno bıvin',
	'wikieditor-toolbar-tool-replace-button-replace' => 'Bıvurnê',
	'wikieditor-toolbar-tool-replace-button-replaceall' => 'pêroyin bıvurn',
	'wikieditor-toolbar-tool-replace-close' => 'Racnê',
	'wikieditor-toolbar-tool-replace-nomatch' => 'çi yo ke şıma gêrenê cı çin o.',
	'wikieditor-toolbar-tool-replace-success' => '$1 vurnayiş vıraziya.',
	'wikieditor-toolbar-tool-replace-emptysearch' => 'şıma qey cıgêrayiş taway/çiyek nênuşt',
	'wikieditor-toolbar-tool-replace-invalidregex' => 'ifadeya normal a ke şıma kwene cı meqbul niya: $1',
	'wikieditor-toolbar-section-characters' => 'karakterê xususiyî',
	'wikieditor-toolbar-characters-page-latin' => 'Latin',
	'wikieditor-toolbar-characters-page-latinextended' => 'latinkiya hêrabiyaye',
	'wikieditor-toolbar-characters-page-ipa' => 'IPA',
	'wikieditor-toolbar-characters-page-symbols' => 'Semboli',
	'wikieditor-toolbar-characters-page-greek' => 'Yunan',
	'wikieditor-toolbar-characters-page-cyrillic' => 'Kiril',
	'wikieditor-toolbar-characters-page-arabic' => 'Erebki',
	'wikieditor-toolbar-characters-page-arabicextended' => 'Erebkiya Heraye',
	'wikieditor-toolbar-characters-page-persian' => 'Fariski',
	'wikieditor-toolbar-characters-page-hebrew' => 'İbraniki',
	'wikieditor-toolbar-characters-page-bangla' => 'Bangla',
	'wikieditor-toolbar-characters-page-tamil' => 'Tamil',
	'wikieditor-toolbar-characters-page-telugu' => 'Telugu',
	'wikieditor-toolbar-characters-page-sinhala' => 'Sinhalaki',
	'wikieditor-toolbar-characters-page-gujarati' => 'Gujaratki',
	'wikieditor-toolbar-characters-page-devanagari' => 'Devanagari',
	'wikieditor-toolbar-characters-page-thai' => 'Thai',
	'wikieditor-toolbar-characters-page-lao' => 'Lao',
	'wikieditor-toolbar-characters-page-khmer' => 'Khmer',
	'wikieditor-toolbar-section-help' => 'Peşti',
	'wikieditor-toolbar-help-heading-description' => 'Şınasnayış',
	'wikieditor-toolbar-help-heading-syntax' => 'o yo ke şıma nuşt',
	'wikieditor-toolbar-help-heading-result' => 'o yo ke şıma gırewt',
	'wikieditor-toolbar-help-page-format' => 'fesal dayiş/format',
	'wikieditor-toolbar-help-page-link' => 'gıreyi',
	'wikieditor-toolbar-help-page-heading' => 'sernameyi',
	'wikieditor-toolbar-help-page-list' => 'listeyi',
	'wikieditor-toolbar-help-page-file' => 'dosyayi',
	'wikieditor-toolbar-help-page-reference' => 'Çımey',
	'wikieditor-toolbar-help-page-discussion' => 'werê-ameyiş/munaqeşa',
	'wikieditor-toolbar-help-content-italic-description' => 'italik',
	'wikieditor-toolbar-help-content-italic-syntax' => "''metno italik''",
	'wikieditor-toolbar-help-content-italic-result' => '<em>metno italik</em>',
	'wikieditor-toolbar-help-content-bold-description' => 'qalın',
	'wikieditor-toolbar-help-content-bold-syntax' => "'''metno qalın'''",
	'wikieditor-toolbar-help-content-bold-result' => '<strong>metno qalın</strong>',
	'wikieditor-toolbar-help-content-bolditalic-description' => 'qalın &amp; italik',
	'wikieditor-toolbar-help-content-bolditalic-syntax' => "'''''qalın &amp; metno italik'''''",
	'wikieditor-toolbar-help-content-bolditalic-result' => '<strong><em>qalın &amp; metno italik</em></strong>',
	'wikieditor-toolbar-help-content-ilink-description' => 'Gıreyê miyani',
	'wikieditor-toolbar-help-content-ilink-syntax' => '[[sernameyê peli|sernameyê gıreyi]]<br />[[sernameyê peli]]',
	'wikieditor-toolbar-help-content-ilink-result' => "<a href='#'>sernameyê gıreyi</a><br /><a href='#'>sernameyê peli</a>",
	'wikieditor-toolbar-help-content-xlink-description' => 'Gırêy teberi',
	'wikieditor-toolbar-help-content-xlink-syntax' => '[http://www.misal.org sernamyê gıreyi]<br />[http://www.misal.org]<br />http://www.misal.org',
	'wikieditor-toolbar-help-content-xlink-result' => "<a href='#' class='external'>sernameyê gıreyi</a><br /><a href='#' class='external autonumber'>[1]</a><br /><a href='#' class='external'>http://www.misal.org</a>",
	'wikieditor-toolbar-help-content-heading2-description' => 'sernameyê seviyeya 2.',
	'wikieditor-toolbar-help-content-heading2-syntax' => '== sernameyê metni ==',
	'wikieditor-toolbar-help-content-heading2-result' => '<h2>sernameyê metni</h2>',
	'wikieditor-toolbar-help-content-heading3-description' => 'sernameyê seviyeya 3.',
	'wikieditor-toolbar-help-content-heading3-syntax' => '=== sernameyê metni ===',
	'wikieditor-toolbar-help-content-heading3-result' => '<h3>sernameyê seviyeya 3.</h3>',
	'wikieditor-toolbar-help-content-heading4-description' => 'sernameyê seviyeya 4.',
	'wikieditor-toolbar-help-content-heading4-syntax' => '== sernameyê metni ==',
	'wikieditor-toolbar-help-content-heading4-result' => '<h4>sernameyê seviyeya 4.</h4>',
	'wikieditor-toolbar-help-content-heading5-description' => 'sernameyê seviyeya 5.',
	'wikieditor-toolbar-help-content-heading5-syntax' => '===== sernameyê metni =====',
	'wikieditor-toolbar-help-content-heading5-result' => '<h5>sernameyê seviyeya 5.</h5>',
	'wikieditor-toolbar-help-content-ulist-description' => 'listeya işareti ya maddeyın',
	'wikieditor-toolbar-help-content-ulist-syntax' => '* unsurê listeyi<br />* unsurê listeyi',
	'wikieditor-toolbar-help-content-ulist-result' => '<ul><li>unsurê listeyi</li><li>unsurê listeyi</li></ul>',
	'wikieditor-toolbar-help-content-olist-description' => 'listeya numreyın',
	'wikieditor-toolbar-help-content-olist-syntax' => '# unsurê listeyi<br /># unsurê listeyi',
	'wikieditor-toolbar-help-content-olist-result' => '<ol><li>unsurê listeyi</li><li>unsurê listeyi</li></ol>',
	'wikieditor-toolbar-help-content-file-description' => 'dosyaya weradaye/nımıte',
	'wikieditor-toolbar-help-content-file-syntax' => '[[$1:Example.png|thumb|Nuşteyê resîmî]]',
	'wikieditor-toolbar-help-content-file-result' => "<div style='width:104px;' class='thumbinner'><a title='Caption text' class='image' href='#'><img height='50' width='100' border='0' class='thumbimage' src='$2/WikiEditor/modules/images/toolbar/example-image.png' alt=''/></a><div class='thumbcaption'><div class='magnify'><a title='Enlarge' class='internal' href='#'><img height='11' width='15' alt='' src='$1/common/images/magnify-clip.png'/></a></div>metnê resmi</div></div>",
	'wikieditor-toolbar-help-content-reference-description' => 'çıme/referans',
	'wikieditor-toolbar-help-content-reference-syntax' => 'metnê peli.&lt;ref name="tesel kerdış/cerebnayiş"&gt;[http://www.misal.org metnê gıreyi], zeylê metni.&lt;/ref&gt;',
	'wikieditor-toolbar-help-content-reference-result' => "metnê peli.<sup><a href='#'>[1]</a></sup>",
	'wikieditor-toolbar-help-content-rereference-description' => 'şuxulnayişê zeylê o çımeyi',
	'wikieditor-toolbar-help-content-rereference-result' => "metnê peli.<sup><a href='#'>[1]</a></sup>",
	'wikieditor-toolbar-help-content-showreferences-description' => 'çımeyi ramocın',
	'wikieditor-toolbar-help-content-showreferences-result' => "<ol class='references'><li id='cite_note-test-0'><b><a title='' href='#'>^</a></b> <a rel='nofollow' title='http://www.misal.org' class='external text' href='#'>metnê gıreyi</a>, zeylê metni.</li></ol>",
	'wikieditor-toolbar-help-content-signaturetimestamp-description' => 'pê tamğayê zemani imza eştış',
	'wikieditor-toolbar-help-content-signaturetimestamp-result' => "<a href='#' title='{{#special:mypage}}'>nameyê karberi</a> (<a href='#' title='{{#special:mytalk}}'>mesaj</a>) 15:54, 10 Heziran 2009 (UTC)",
	'wikieditor-toolbar-help-content-signature-description' => 'imza',
	'wikieditor-toolbar-help-content-signature-result' => "<a href='#' title='{{#special:mypage}}'>Namey karberi</a> (<a href='#' title='{{#special:mytalk}}'>mesac</a>)",
	'wikieditor-toolbar-help-content-indent-description' => 'Indent',
	'wikieditor-toolbar-help-content-indent-syntax' => 'metno normal<br />:metno indent<br />::metno indent',
	'wikieditor-toolbar-help-content-indent-result' => 'metno normal<dl><dd>metno indent<dl><dd>metno indent</dd></dl></dd></dl>',
);

/** Lower Sorbian (dolnoserbski)
 * @author Michawiki
 */
$messages['dsb'] = array(
	'wikieditor' => 'Rozšyrjony pówjerch za wobźěkowabnje wikiteksta',
	'wikieditor-desc' => 'Stoj rozšyrjobny pówjerch za wobźěłowanje wikiteksta a wjele modulow k dispoziciji',
	'wikieditor-wikitext-tab' => 'WikiTekst',
	'wikieditor-loading' => 'Zacytujo se',
	'wikieditor-preview-preference' => 'Pśeglěd bok pó boku zmóžniś',
	'wikieditor-preview-tab' => 'Pśeglěd',
	'wikieditor-preview-changes-tab' => 'Změny',
	'wikieditor-preview-loading' => 'Zacytujo se...',
	'wikieditor-previewDialog-preference' => 'Pśeglědowy dialog zmóžniś',
	'wikieditor-previewDialog-tab' => 'Pśeglěd',
	'wikieditor-previewDialog-loading' => 'Zacytujo se...',
	'wikieditor-publish-preference' => 'Publicěrowanje kšać pó kšacu zmóžniś',
	'wikieditor-publish-button-publish' => 'Wózjawiś',
	'wikieditor-publish-button-cancel' => 'Pśetergnuś',
	'wikieditor-publish-dialog-title' => 'Do {{GRAMMAR:genitiw|{{SITENAME}}}} wózjawiś',
	'wikieditor-publish-dialog-summary' => 'Zespominanje změnow (wópisaj krotko změny, kótareř sy cynił):',
	'wikieditor-publish-dialog-minor' => 'Snadna změna',
	'wikieditor-publish-dialog-watch' => 'Toś ten bok wobglědowaś',
	'wikieditor-publish-dialog-publish' => 'Wózjawiś',
	'wikieditor-publish-dialog-goback' => 'Slědk',
	'wikieditor-template-editor-preference' => 'Wobźěłowanje wikipśedłogow na zakłaźe formularow zmóžniś',
	'wikieditor-template-editor-dialog-title' => 'Pśedłogu wobźěłaś',
	'wikieditor-template-editor-dialog-submit' => 'Aktualizěrowaś',
	'wikieditor-template-editor-dialog-cancel' => 'Pśetergnuś',
	'wikieditor-templates-preference' => 'Fałdowanje pśedłogow zmóžniś',
	'wikieditor-toc-preference' => 'Nawigěrujobny zapis wopśimjeśa zmóžniś',
	'wikieditor-toc-show' => 'Wopśimjeśe pokazaś',
	'wikieditor-toc-hide' => 'Wopśimjeśe schowaś',
	'wikieditor-toolbar' => 'Wobźěłowańska rědowa kšoma',
	'wikieditor-toolbar-desc' => 'Rědowa kšoma za wobźěłowanje bokow z pólěpšoneju wužywajobnosću',
	'wikieditor-toolbar-preference' => 'Pólěpšonu wobźěłowańsku rědowu kšomu aktiwěrowaś',
	'wikieditor-toolbar-dialogs-preference' => 'Dialogi za zasajźenje wótkazow, tabelow a hynakšego zmóžniś',
	'wikieditor-toolbar-hidesig' => 'Pódpisowy tłočašk w bokach w głownem mjenjowem rumje schowaś',
	'wikieditor-toolbar-loading' => 'Zacytujo se...',
	'wikieditor-toolbar-tool-bold' => 'Tucny',
	'wikieditor-toolbar-tool-bold-example' => 'Tucny tekst',
	'wikieditor-toolbar-tool-italic' => 'Kursiwny',
	'wikieditor-toolbar-tool-italic-example' => 'Kursiwny tekst',
	'wikieditor-toolbar-tool-ilink' => 'Interny wótkaz',
	'wikieditor-toolbar-tool-ilink-example' => 'Titel wótkaza',
	'wikieditor-toolbar-tool-xlink' => 'Eksterny wótkaz (njezabydni prefiks http://)',
	'wikieditor-toolbar-tool-xlink-example' => 'http://www.pśikład.de titel wótkaza',
	'wikieditor-toolbar-tool-link' => 'Wótkaz',
	'wikieditor-toolbar-tool-link-title' => 'Wótkaz zasunuś',
	'wikieditor-toolbar-tool-link-int' => 'K wikijowemu nastawkoju/bokoju',
	'wikieditor-toolbar-tool-link-int-target' => 'Titel nastawka:',
	'wikieditor-toolbar-tool-link-int-target-tooltip' => 'Titel boka abo URL',
	'wikieditor-toolbar-tool-link-int-text' => 'Wótkazowy tekst:',
	'wikieditor-toolbar-tool-link-int-text-tooltip' => 'Tekst zapódaś, kótaryž ma se pokazaś',
	'wikieditor-toolbar-tool-link-ext' => 'K eksternemu webbokoju',
	'wikieditor-toolbar-tool-link-ext-target' => 'URL wótkaza:',
	'wikieditor-toolbar-tool-link-ext-text' => 'Tekst wótkaza:',
	'wikieditor-toolbar-tool-link-insert' => 'Wótkaz zasunuś',
	'wikieditor-toolbar-tool-link-cancel' => 'Pśetergnuś',
	'wikieditor-toolbar-tool-link-int-target-status-exists' => 'Bok eksistěrujo',
	'wikieditor-toolbar-tool-link-int-target-status-notexists' => 'Bok njeeksistěrujo',
	'wikieditor-toolbar-tool-link-int-target-status-invalid' => 'Njepłaśiwy titel',
	'wikieditor-toolbar-tool-link-int-target-status-external' => 'Eksterny wótkaz',
	'wikieditor-toolbar-tool-link-int-target-status-loading' => 'Eksistenca boka se pśekontrolěrujo...',
	'wikieditor-toolbar-tool-link-int-invalid' => 'Titel, kótaryž sy pódał, jo njepłaśiwy.',
	'wikieditor-toolbar-tool-link-lookslikeinternal' => 'URL, kótaryž sy pódał, wuglěda, ako by był za wótkaz k drugemu wikibokoju.
Coš jen do internego wótkaza psétwóriś?',
	'wikieditor-toolbar-tool-link-lookslikeinternal-int' => 'Interny wótkaz',
	'wikieditor-toolbar-tool-link-lookslikeinternal-ext' => 'Eksterny wótkaz',
	'wikieditor-toolbar-tool-link-empty' => 'Njejsy nic za wótkazowanje pódał.',
	'wikieditor-toolbar-tool-file' => 'Zasajźona dataja',
	'wikieditor-toolbar-tool-file-example' => 'Psikład.jpg',
	'wikieditor-toolbar-tool-file-title' => 'Dataju zasunuś',
	'wikieditor-toolbar-file-target' => 'Datajowe mě:',
	'wikieditor-toolbar-file-caption' => 'Pópisanje:',
	'wikieditor-toolbar-file-size' => 'Wjelikosć:',
	'wikieditor-toolbar-file-float' => 'Wusměrjenje:',
	'wikieditor-toolbar-file-default' => '(standard)',
	'wikieditor-toolbar-file-format' => 'Format:',
	'wikieditor-toolbar-tool-file-insert' => 'Zasunuś',
	'wikieditor-toolbar-tool-file-cancel' => 'Pśetergnuś',
	'wikieditor-toolbar-tool-reference' => 'Referenca',
	'wikieditor-toolbar-tool-reference-example' => 'Nožku how zasajźiś',
	'wikieditor-toolbar-tool-reference-cancel' => 'Pśetergnuś',
	'wikieditor-toolbar-tool-reference-title' => 'Referencu zasunuś',
	'wikieditor-toolbar-tool-reference-insert' => 'Zasunuś',
	'wikieditor-toolbar-tool-reference-text' => 'Tekst reference',
	'wikieditor-toolbar-tool-signature' => 'Signatura a casowy kołk',
	'wikieditor-toolbar-section-advanced' => 'Rozšyrjony',
	'wikieditor-toolbar-tool-heading' => 'Nadpismo',
	'wikieditor-toolbar-tool-heading-1' => 'Rownina 1',
	'wikieditor-toolbar-tool-heading-2' => 'Rownina 2',
	'wikieditor-toolbar-tool-heading-3' => 'Rownina 3',
	'wikieditor-toolbar-tool-heading-4' => 'Rownina 4',
	'wikieditor-toolbar-tool-heading-5' => 'Rownina 5',
	'wikieditor-toolbar-tool-heading-example' => 'Nadpismowy tekst',
	'wikieditor-toolbar-group-format' => 'Format',
	'wikieditor-toolbar-tool-ulist' => 'Naliceńska lisćina',
	'wikieditor-toolbar-tool-ulist-example' => 'Zapisk naliceńskeje lisćiny',
	'wikieditor-toolbar-tool-olist' => 'Numerěrowana lisćina',
	'wikieditor-toolbar-tool-olist-example' => 'Zapisk numerěrowaneje lisćiny',
	'wikieditor-toolbar-tool-indent' => 'Zasunjenje',
	'wikieditor-toolbar-tool-indent-example' => 'Zasunjona smužka',
	'wikieditor-toolbar-tool-nowiki' => 'Žedno wikiformatěrowanje',
	'wikieditor-toolbar-tool-nowiki-example' => 'Njeformatěrowany tekst how zasunuś',
	'wikieditor-toolbar-tool-redirect' => 'Dalejpósrědnjenje',
	'wikieditor-toolbar-tool-redirect-example' => 'Mě celowego boka',
	'wikieditor-toolbar-tool-big' => 'Wjeliki',
	'wikieditor-toolbar-tool-big-example' => 'Wjeliki tekst',
	'wikieditor-toolbar-tool-small' => 'Mały',
	'wikieditor-toolbar-tool-small-example' => 'Mały tekst',
	'wikieditor-toolbar-tool-superscript' => 'Wusoko stajony',
	'wikieditor-toolbar-tool-superscript-example' => 'Wusoko stajony tekst',
	'wikieditor-toolbar-tool-subscript' => 'Dłymoko stajony',
	'wikieditor-toolbar-tool-subscript-example' => 'Dłymoko stajony tekst',
	'wikieditor-toolbar-group-insert' => 'Zasunuś',
	'wikieditor-toolbar-tool-gallery' => 'Wobrazowa galerija',
	'wikieditor-toolbar-tool-gallery-example' => '$1:Pśikład.jpg|Pópisanje1
$1:Pśikład.jpg|Pópisanje2',
	'wikieditor-toolbar-tool-newline' => 'Nowa smužka',
	'wikieditor-toolbar-tool-table' => 'Tabela',
	'wikieditor-toolbar-tool-table-example-old' => '-
! głowa 1
! głowa 2
! głowa 3
|-
| smužka 1, cela 1
| smužka 1, cela 2
| smužka 1, cela 3
|-
| smužka 2, cela 1
| smužka 2, cela 2
| smužka 2, cela 3',
	'wikieditor-toolbar-tool-table-example-cell-text' => 'Celowy tekst',
	'wikieditor-toolbar-tool-table-example-header' => 'Głowowy tekst',
	'wikieditor-toolbar-tool-table-title' => 'Tabelu zasunuś',
	'wikieditor-toolbar-tool-table-dimensions-rows' => 'Smužki',
	'wikieditor-toolbar-tool-table-dimensions-columns' => 'Słupy',
	'wikieditor-toolbar-tool-table-dimensions-header' => 'Smužku głowy zapśěgnuś',
	'wikieditor-toolbar-tool-table-wikitable' => 'Stil z ramikami',
	'wikieditor-toolbar-tool-table-sortable' => 'Sortěrujobna tabela',
	'wikieditor-toolbar-tool-table-example' => 'Celowy tekst',
	'wikieditor-toolbar-tool-table-preview' => 'Pśeglěd',
	'wikieditor-toolbar-tool-table-insert' => 'Zasunuś',
	'wikieditor-toolbar-tool-table-cancel' => 'Pśetergnuś',
	'wikieditor-toolbar-tool-table-toomany' => 'Zasajźenje tabele z wěcej ako $1 {{PLURAL:$1|celu|celoma|celami|celami}} njejo móžno z toś tym dialogom.',
	'wikieditor-toolbar-tool-table-invalidnumber' => 'Njejsy płaśiwu licbu smužkow abo słupow zapódał.',
	'wikieditor-toolbar-tool-table-zero' => 'Njamóžoš tabelu bźez smužkow abo słupow zasunuś.',
	'wikieditor-toolbar-tool-replace' => 'Pytaś a wuměniś',
	'wikieditor-toolbar-tool-replace-title' => 'Pytaś a wuměniś',
	'wikieditor-toolbar-tool-replace-search' => 'Pytaś za:',
	'wikieditor-toolbar-tool-replace-replace' => 'Wuměniś pśez:',
	'wikieditor-toolbar-tool-replace-case' => 'Wótpowědnik',
	'wikieditor-toolbar-tool-replace-regex' => 'Z pytańskim teksto ako z regularnym wurazom wobchadaś',
	'wikieditor-toolbar-tool-replace-button-findnext' => 'Dalej pytaś',
	'wikieditor-toolbar-tool-replace-button-replace' => 'Wuměniś',
	'wikieditor-toolbar-tool-replace-button-replaceall' => 'Wšykne wuměniś',
	'wikieditor-toolbar-tool-replace-close' => 'Zacyniś',
	'wikieditor-toolbar-tool-replace-nomatch' => 'Twójo pytanje njejo žedno wustupowanje namakało.',
	'wikieditor-toolbar-tool-replace-success' => '$1 {{PLURAL:$1|wuměnjenje pśewjeźone|wuměnjeni pśewjeźonej|wuměnjenja pśewjeźone|wuměnjenjow pśewjeźonych}}.',
	'wikieditor-toolbar-tool-replace-emptysearch' => 'Njejsy žeden pytański wuraz zapódał.',
	'wikieditor-toolbar-tool-replace-invalidregex' => 'Regularny wuraz, kótaryž sy zapódał, jo njepłaśiwy: $1',
	'wikieditor-toolbar-section-characters' => 'Specialne znamješka',
	'wikieditor-toolbar-characters-page-latin' => 'Łatyńske',
	'wikieditor-toolbar-characters-page-latinextended' => 'Łatyńske rozšyrjone',
	'wikieditor-toolbar-characters-page-ipa' => 'IPA',
	'wikieditor-toolbar-characters-page-symbols' => 'Symbole',
	'wikieditor-toolbar-characters-page-greek' => 'Grichiske',
	'wikieditor-toolbar-characters-page-cyrillic' => 'Kyriliske',
	'wikieditor-toolbar-characters-page-arabic' => 'Arabiske',
	'wikieditor-toolbar-characters-page-arabicextended' => 'Rozšyrjona arabšćina',
	'wikieditor-toolbar-characters-page-persian' => 'Persiske',
	'wikieditor-toolbar-characters-page-hebrew' => 'Hebrejske',
	'wikieditor-toolbar-characters-page-bangla' => 'Bengalšćina',
	'wikieditor-toolbar-characters-page-tamil' => 'Tamilšćina',
	'wikieditor-toolbar-characters-page-telugu' => 'Telugu',
	'wikieditor-toolbar-characters-page-sinhala' => 'Singalezišćina',
	'wikieditor-toolbar-characters-page-gujarati' => 'Guźarati',
	'wikieditor-toolbar-characters-page-devanagari' => 'Devanagari',
	'wikieditor-toolbar-characters-page-thai' => 'thailandšćina',
	'wikieditor-toolbar-characters-page-lao' => 'Laošćina',
	'wikieditor-toolbar-characters-page-khmer' => 'Khmeršćina',
	'wikieditor-toolbar-section-help' => 'Pomoc',
	'wikieditor-toolbar-help-heading-description' => 'Wopisanje',
	'wikieditor-toolbar-help-heading-syntax' => 'Což zapisujoš',
	'wikieditor-toolbar-help-heading-result' => 'Což dostanjoš',
	'wikieditor-toolbar-help-page-format' => 'Formatěrowanje',
	'wikieditor-toolbar-help-page-link' => 'Wótkaze',
	'wikieditor-toolbar-help-page-heading' => 'Nadpisma',
	'wikieditor-toolbar-help-page-list' => 'Lisćiny',
	'wikieditor-toolbar-help-page-file' => 'Dataje',
	'wikieditor-toolbar-help-page-reference' => 'Reference',
	'wikieditor-toolbar-help-page-discussion' => 'Diskusija',
	'wikieditor-toolbar-help-content-italic-description' => 'Kursiwny',
	'wikieditor-toolbar-help-content-italic-syntax' => "''Kursiwny tekst''",
	'wikieditor-toolbar-help-content-italic-result' => '<em>Kursiwny tekst</em>',
	'wikieditor-toolbar-help-content-bold-description' => 'Tucny',
	'wikieditor-toolbar-help-content-bold-syntax' => "'''Tucny tekst'''",
	'wikieditor-toolbar-help-content-bold-result' => '<strong>Tucny tekst</strong>',
	'wikieditor-toolbar-help-content-bolditalic-description' => 'Tucny &amp; kursiwny',
	'wikieditor-toolbar-help-content-bolditalic-syntax' => "'''''Tucny &amp; kursiwny tekst'''''",
	'wikieditor-toolbar-help-content-bolditalic-result' => '<strong><em>Tucny &amp; kursiwny tekst</em></strong>',
	'wikieditor-toolbar-help-content-ilink-description' => 'Interny wótkaz',
	'wikieditor-toolbar-help-content-ilink-syntax' => '[[Page title|Tekst wótkaza]]<br />[[Page title]]',
	'wikieditor-toolbar-help-content-ilink-result' => "<a href='#'>Tekst wótkaza</a><br /><a href='#'>Titel boka</a>",
	'wikieditor-toolbar-help-content-xlink-description' => 'Eksterny wótkaz',
	'wikieditor-toolbar-help-content-xlink-syntax' => '[http://www.example.org Tekst wótkaza]<br />[http://www.example.org]<br />http://www.example.org',
	'wikieditor-toolbar-help-content-xlink-result' => "<a href='#' class='external'>Tekst wótkaza</a><br /><a href='#' class='external autonumber'>[1]</a><br /><a href='#' class='external'>http://www.example.org</a>",
	'wikieditor-toolbar-help-content-heading2-description' => 'Nadpismo 2. rowniny',
	'wikieditor-toolbar-help-content-heading2-syntax' => '== Nadpismowy tekst ==',
	'wikieditor-toolbar-help-content-heading2-result' => '<h2>Nadpismowy tekst</h2>',
	'wikieditor-toolbar-help-content-heading3-description' => 'Nadpismo 3. rowniny',
	'wikieditor-toolbar-help-content-heading3-syntax' => '=== Nadpismowy tekst ===',
	'wikieditor-toolbar-help-content-heading3-result' => '<h3>Nadpismowy tekst</h3>',
	'wikieditor-toolbar-help-content-heading4-description' => 'Nadpismo 4. rowniny',
	'wikieditor-toolbar-help-content-heading4-syntax' => '==== Nadpismowy tekst ====',
	'wikieditor-toolbar-help-content-heading4-result' => '<h4>Nadpismowy tekst</h4>',
	'wikieditor-toolbar-help-content-heading5-description' => 'Nadpismo 5. rowniny',
	'wikieditor-toolbar-help-content-heading5-syntax' => '===== Nadpismowy tekst =====',
	'wikieditor-toolbar-help-content-heading5-result' => '<h5>Nadpismowy tekst</h5>',
	'wikieditor-toolbar-help-content-ulist-description' => 'Naliceńska lisćina',
	'wikieditor-toolbar-help-content-ulist-syntax' => '* Lisćinowy zapisk<br />* Lisćinowy zapisk',
	'wikieditor-toolbar-help-content-ulist-result' => '<ul><li>Lisćinowy zapisk</li><li>Lisćinowy zapisk</li></ul>',
	'wikieditor-toolbar-help-content-olist-description' => 'Numerěrowana lisćina',
	'wikieditor-toolbar-help-content-olist-syntax' => '# Lisćinowy zapisk<br /># Lisćinowy zapisk',
	'wikieditor-toolbar-help-content-olist-result' => '<ol><li>Lisćinowy zapisk</li><li>Lisćinowy zapisk</li></ol>',
	'wikieditor-toolbar-help-content-file-description' => 'Zasajźona dataja',
	'wikieditor-toolbar-help-content-file-syntax' => '[[$1:Example.png|thumb|Wobrazowe pópisanje]]',
	'wikieditor-toolbar-help-content-file-result' => "<div style='width:104px;' class='thumbinner'><a title='Wobrazowe pópisanje' class='image' href='#'><img height='50' width='100' border='0' class='thumbimage' src='$2/WikiEditor/modules/images/toolbar/example-image.png' alt=''/></a><div class='thumbcaption'><div class='magnify'><a title='Powětšyś' class='internal' href='#'><img height='11' width='15' alt='' src='$1/common/images/magnify-clip.png'/></a></div>Wobrazowe pópisanje</div></div>",
	'wikieditor-toolbar-help-content-reference-description' => 'Referenca',
	'wikieditor-toolbar-help-content-reference-syntax' => 'Tekst boka.&lt;ref name="test"&gt;[http://www.example.org Tekst wótkaza], pśidatny tekst.&lt;/ref&gt;',
	'wikieditor-toolbar-help-content-reference-result' => "Tekst boka.<sup><a href='#'>[1]</a></sup>",
	'wikieditor-toolbar-help-content-rereference-description' => 'Pśidatne wužywanje samskeje reference',
	'wikieditor-toolbar-help-content-rereference-result' => "Tekst boka.<sup><a href='#'>[1]</a></sup>",
	'wikieditor-toolbar-help-content-showreferences-description' => 'Reference zwobrazniś',
	'wikieditor-toolbar-help-content-showreferences-result' => "<ol class='references'><li id='cite_note-test-0'><b><a title='' href='#'>^</a></b> <a rel='nofollow' title='http://www.example.org' class='external text' href='#'>Tekst wótkaza</a>, pśidanty tekst.</li></ol>",
	'wikieditor-toolbar-help-content-signaturetimestamp-description' => 'Signatura z casowym kołkom',
	'wikieditor-toolbar-help-content-signaturetimestamp-result' => "<a href='#' title='{{#special:mypage}}'>Wužywarske mě</a> (<a href='#' title='{{#special:mytalk}}'>diskusija</a>) 15:54, 10. junija 2009 (UTC)",
	'wikieditor-toolbar-help-content-signature-description' => 'Signatura',
	'wikieditor-toolbar-help-content-signature-result' => "<a href='#' title='{{#special:mypage}}'>Wužywarske mě</a> (<a href='#' title='{{#special:mytalk}}'>diskusija</a>)",
	'wikieditor-toolbar-help-content-indent-description' => 'Zasunjenje',
	'wikieditor-toolbar-help-content-indent-syntax' => 'Normalny tekst<br />:Zasunjony tekst<br />::Zasunjony tekst',
	'wikieditor-toolbar-help-content-indent-result' => 'Normalny tekst<dl><dd>Zasunjony tekst<dl><dd>Zasunjony tekst</dd></dl></dd></dl>',
);

/** Greek (Ελληνικά)
 * @author AK
 * @author Dead3y3
 * @author Flyax
 * @author Geraki
 * @author Glavkos
 * @author Lou
 * @author ZaDiak
 * @author Απεργός
 * @author Περίεργος
 */
$messages['el'] = array(
	'wikieditor' => 'Προχωρημένη διεπαφή επεξεργασίας κειμένου wiki',
	'wikieditor-desc' => 'Παρέχει μία επεκτάσιμη διεπαφή επεξεργασίας κειμένου wiki και πολλές μονάδες παροχής χαρακτηριστικών',
	'wikieditor-wikitext-tab' => 'Κείμενο wiki',
	'wikieditor-loading' => 'Φόρτωση',
	'wikieditor-preview-preference' => 'Ενεργοποίηση προεπισκόπησης δίπλα-δίπλα',
	'wikieditor-preview-tab' => 'Προεπισκόπηση',
	'wikieditor-preview-changes-tab' => 'Αλλαγές',
	'wikieditor-preview-loading' => 'Φόρτωση...',
	'wikieditor-previewDialog-preference' => 'Ενεργοποίηση διαλόγου προεπισκόπησης',
	'wikieditor-previewDialog-tab' => 'Προεπισκόπηση',
	'wikieditor-previewDialog-loading' => 'Φόρτωση...',
	'wikieditor-publish-preference' => 'Ενεργοποίηση δημοσίευσης βήμα προς βήμα',
	'wikieditor-publish-button-publish' => 'Δημοσίευση',
	'wikieditor-publish-button-cancel' => 'Άκυρο',
	'wikieditor-publish-dialog-title' => 'Δημοσίευση στο {{SITENAME}}',
	'wikieditor-publish-dialog-summary' => 'Σύνοψη επεξεργασίας (περιγράψτε συντόμως τις αλλαγές που έχετε κάνει):',
	'wikieditor-publish-dialog-minor' => '"Μικρή" επεξεργασία',
	'wikieditor-publish-dialog-watch' => 'Παρακολούθηση αυτής της σελίδας',
	'wikieditor-publish-dialog-publish' => 'Δημοσίευση',
	'wikieditor-publish-dialog-goback' => 'Πήγαινε πίσω',
	'wikieditor-template-editor-preference' => 'Ενεργοποίηση επεξεργασίας των προτύπων wiki χάρη σε μια φόρμα',
	'wikieditor-template-editor-dialog-title' => 'Επεξεργασία προτύπου',
	'wikieditor-template-editor-dialog-submit' => 'Ενημέρωση',
	'wikieditor-template-editor-dialog-cancel' => 'Ακύρωση',
	'wikieditor-templates-preference' => 'Ενεργοποίηση της απόκρυψης προτύπων',
	'wikieditor-toc-preference' => 'Ενεργοποιήστε πλοηγήσιμο πίνακα περιεχομένων',
	'wikieditor-toc-show' => 'Εμφάνιση περιεχομένων',
	'wikieditor-toc-hide' => 'Απόκρυψη περιεχομένων',
	'wikieditor-toolbar' => 'Επεξεργασία εργαλειοθήκης',
	'wikieditor-toolbar-desc' => 'Μπάρα εργαλείων επεξεργασίας σελίδων με περισσότερες δυνατότητες χρήσης',
	'wikieditor-toolbar-preference' => 'Ενεργοποιήστε την μπάρα εργαλείων με τις περισσότερες δυνατότητες επεξεργασίας',
	'wikieditor-toolbar-dialogs-preference' => 'Ενεργοποιήστε παράθυρα διαλόγων για την εισαγωγή συνδέσμων, πινάκων και άλλων',
	'wikieditor-toolbar-loading' => 'Φόρτωση...',
	'wikieditor-toolbar-tool-bold' => 'Έντονα',
	'wikieditor-toolbar-tool-bold-example' => 'Έντονο κείμενο',
	'wikieditor-toolbar-tool-italic' => 'Πλάγια',
	'wikieditor-toolbar-tool-italic-example' => 'Κείμενο με πλάγιους χαρακτήρες',
	'wikieditor-toolbar-tool-ilink' => 'Εσωτερικός σύνδεσμος',
	'wikieditor-toolbar-tool-ilink-example' => 'Τίτλος συνδέσμου',
	'wikieditor-toolbar-tool-xlink' => 'Εξωτερικός σύνδεσμος (μην ξεχάστε το πρόθεμα http:// )',
	'wikieditor-toolbar-tool-xlink-example' => 'http://www.example.com τίτλος συνδέσμου',
	'wikieditor-toolbar-tool-link' => 'Σύνδεσμος',
	'wikieditor-toolbar-tool-link-title' => 'Εισαγωγή συνδέσμου',
	'wikieditor-toolbar-tool-link-int' => 'Σε μία σελίδα wiki',
	'wikieditor-toolbar-tool-link-int-target' => 'Τίτλος άρθρου:',
	'wikieditor-toolbar-tool-link-int-target-tooltip' => 'Τίτλος ή URL της σελίδας',
	'wikieditor-toolbar-tool-link-int-text' => 'Κείμενο συνδέσμου:',
	'wikieditor-toolbar-tool-link-int-text-tooltip' => 'Κείμενο προς εμφάνιση',
	'wikieditor-toolbar-tool-link-ext' => 'Σε μία εξωτερική ιστοσελίδα',
	'wikieditor-toolbar-tool-link-ext-target' => 'Σύνδεσμος URL:',
	'wikieditor-toolbar-tool-link-ext-text' => 'Κείμενο συνδέσμου:',
	'wikieditor-toolbar-tool-link-insert' => 'Εισαγωγή συνδέσμου',
	'wikieditor-toolbar-tool-link-cancel' => 'Ακύρωση',
	'wikieditor-toolbar-tool-link-int-target-status-exists' => 'Η σελίδα υπάρχει',
	'wikieditor-toolbar-tool-link-int-target-status-notexists' => 'Η σελίδα δεν υπάρχει',
	'wikieditor-toolbar-tool-link-int-target-status-invalid' => 'Άκυρος τίτλος',
	'wikieditor-toolbar-tool-link-int-target-status-external' => 'Εξωτερικός σύνδεσμος',
	'wikieditor-toolbar-tool-link-int-target-status-loading' => 'Έλεγχος ύπαρξης σελίδας...',
	'wikieditor-toolbar-tool-link-int-invalid' => 'Ο τίτλος που καθορίσατε δεν είναι έγκυρος.',
	'wikieditor-toolbar-tool-link-lookslikeinternal' => 'Η διεύθυνση URL που ορίσατε φαίνεται πως προορίζεται για σύνδεσμο σε σελίδα σε άλλο βίκι.
Θέλετε να τη μετατρέψετε σε εσωτερικό σύνδεσμο;',
	'wikieditor-toolbar-tool-link-lookslikeinternal-int' => 'Εσωτερικός σύνδεσμος',
	'wikieditor-toolbar-tool-link-lookslikeinternal-ext' => 'Εξωτερικός σύνδεσμος',
	'wikieditor-toolbar-tool-link-empty' => 'Δεν εισάγατε τίποτα για σύνδεση σε αυτό.',
	'wikieditor-toolbar-tool-file' => 'Ενσωματωμένο αρχείο',
	'wikieditor-toolbar-tool-file-example' => 'Paradeigma.jpg',
	'wikieditor-toolbar-tool-file-title' => 'Εισαγωγή αρχείου',
	'wikieditor-toolbar-file-target' => 'Όνομα αρχείου:',
	'wikieditor-toolbar-file-caption' => 'Λεζάντα',
	'wikieditor-toolbar-file-size' => 'Μέγεθος:',
	'wikieditor-toolbar-file-float' => 'Ευθυγράμμιση:',
	'wikieditor-toolbar-tool-file-insert' => 'Εισαγωγή',
	'wikieditor-toolbar-tool-file-cancel' => 'Άκυρο',
	'wikieditor-toolbar-tool-reference' => 'Παραπομπή',
	'wikieditor-toolbar-tool-reference-example' => 'Εισάγετε εδώ το κείμενο της παραπομπής.',
	'wikieditor-toolbar-tool-reference-cancel' => 'Ακύρωση',
	'wikieditor-toolbar-tool-reference-title' => 'Εισαγωγή παραπομπής',
	'wikieditor-toolbar-tool-reference-insert' => 'Εισαγωγή',
	'wikieditor-toolbar-tool-reference-text' => 'Κείμενο παραπομπής',
	'wikieditor-toolbar-tool-signature' => 'Υπογραφή και σφραγίδα χρόνου',
	'wikieditor-toolbar-section-advanced' => 'Προχωρημένο',
	'wikieditor-toolbar-tool-heading' => 'Επικεφαλίδα',
	'wikieditor-toolbar-tool-heading-1' => 'Επίπεδο 1',
	'wikieditor-toolbar-tool-heading-2' => 'Επίπεδο 2',
	'wikieditor-toolbar-tool-heading-3' => 'Επίπεδο 3',
	'wikieditor-toolbar-tool-heading-4' => 'Επίπεδο 4',
	'wikieditor-toolbar-tool-heading-5' => 'Επίπεδο 5',
	'wikieditor-toolbar-tool-heading-example' => 'Κείμενο τίτλου',
	'wikieditor-toolbar-group-format' => 'Μορφή',
	'wikieditor-toolbar-tool-ulist' => 'Λίστα με τελείες',
	'wikieditor-toolbar-tool-ulist-example' => 'Αντικείμενο λίστας με τελείες',
	'wikieditor-toolbar-tool-olist' => 'Αριθμημένη λίστα',
	'wikieditor-toolbar-tool-olist-example' => 'Αντικείμενο αριθμημένης λίστας',
	'wikieditor-toolbar-tool-indent' => 'Εσοχή',
	'wikieditor-toolbar-tool-indent-example' => 'Γραμμή με εσοχή',
	'wikieditor-toolbar-tool-nowiki' => 'Χωρίς μορφοποίηση Wiki',
	'wikieditor-toolbar-tool-nowiki-example' => 'Εισάγετε εδώ το μη μορφοποιημένο κείμενο',
	'wikieditor-toolbar-tool-redirect' => 'Ανακατεύθυνση',
	'wikieditor-toolbar-tool-redirect-example' => 'Όνομα της σελίδας στόχου',
	'wikieditor-toolbar-tool-big' => 'Μεγάλα',
	'wikieditor-toolbar-tool-big-example' => 'Κείμενο με μεγάλους χαρακτήρες',
	'wikieditor-toolbar-tool-small' => 'Μικρά',
	'wikieditor-toolbar-tool-small-example' => 'Κείμενο με μικρούς χαρακτήρες',
	'wikieditor-toolbar-tool-superscript' => 'Εκθέτης',
	'wikieditor-toolbar-tool-superscript-example' => 'Κείμενο-εκθέτης',
	'wikieditor-toolbar-tool-subscript' => 'Δείκτης',
	'wikieditor-toolbar-tool-subscript-example' => 'Κείμενο-δείκτης',
	'wikieditor-toolbar-group-insert' => 'Εισαγωγή',
	'wikieditor-toolbar-tool-gallery' => 'Συλλογή εικόνων',
	'wikieditor-toolbar-tool-gallery-example' => '$1:Example.jpg|Λεζάντα1
$1:Example.jpg|Λεζάντα2',
	'wikieditor-toolbar-tool-newline' => 'Νέα γραμμή',
	'wikieditor-toolbar-tool-table' => 'Πίνακας',
	'wikieditor-toolbar-tool-table-example-old' => '-
! κεφαλίδα 1
! κεφαλίδα 2
! κεφαλίδα 3
|-
| γραμμή 1, κελί 1
| γραμμή 1, κελί 2
| γραμμή 1, κελί 3
|-
| γραμμή 2, κελί 1
| γραμμή 2, κελί 2
| γραμμή 2, κελί 3',
	'wikieditor-toolbar-tool-table-example-cell-text' => 'Κείμενο κελιού',
	'wikieditor-toolbar-tool-table-example-header' => 'Κείμενο κεφαλίδας',
	'wikieditor-toolbar-tool-table-title' => 'Εισαγωγή πίνακα',
	'wikieditor-toolbar-tool-table-dimensions-rows' => 'Σειρές',
	'wikieditor-toolbar-tool-table-dimensions-columns' => 'Στήλες',
	'wikieditor-toolbar-tool-table-dimensions-header' => 'Προσθήκη σειράς κεφαλίδων',
	'wikieditor-toolbar-tool-table-wikitable' => 'Διακόσμηση με περιγράμματα',
	'wikieditor-toolbar-tool-table-sortable' => 'Δυνατότητα ταξινόμησης',
	'wikieditor-toolbar-tool-table-example' => 'Κείμενο κελιού',
	'wikieditor-toolbar-tool-table-preview' => 'Προεπισκόπηση',
	'wikieditor-toolbar-tool-table-insert' => 'Εισαγωγή',
	'wikieditor-toolbar-tool-table-cancel' => 'Άκυρο',
	'wikieditor-toolbar-tool-table-toomany' => 'Η εισαγωγή ενός πίνακα με περισσότερα από $1 κελιά δεν είναι δυνατή με αυτό το πλαίσιο διαλόγου.',
	'wikieditor-toolbar-tool-table-invalidnumber' => 'Δεν έχετε εισαγάγει έναν έγκυρο αριθμό των γραμμών ή στηλών.',
	'wikieditor-toolbar-tool-table-zero' => 'Δεν μπορείτε να εισαγάγετε έναν πίνακα χωρίς γραμμές ή στήλες.',
	'wikieditor-toolbar-tool-replace' => 'Αναζήτηση και αντικατάσταση',
	'wikieditor-toolbar-tool-replace-title' => 'Αναζήτηση και αντικατάσταση',
	'wikieditor-toolbar-tool-replace-search' => 'Αναζήτηση για:',
	'wikieditor-toolbar-tool-replace-replace' => 'Αντικατάσταση από:',
	'wikieditor-toolbar-tool-replace-case' => 'Ταίριασμα πεζών-κεφαλαίων',
	'wikieditor-toolbar-tool-replace-regex' => 'Το αναζητούμενο κείμενο είναι κανονική έκφραση',
	'wikieditor-toolbar-tool-replace-button-findnext' => 'Εύρεση επόμενου',
	'wikieditor-toolbar-tool-replace-button-replace' => 'Αντικατάσταση',
	'wikieditor-toolbar-tool-replace-button-replaceall' => 'Αντικατάσταση όλων',
	'wikieditor-toolbar-tool-replace-close' => 'Κλείσιμο',
	'wikieditor-toolbar-tool-replace-nomatch' => 'Η αναζήτηση δεν ταίριαξε με κάτι.',
	'wikieditor-toolbar-tool-replace-success' => 'Έγιναν $1 αντικαταστάσεις.',
	'wikieditor-toolbar-tool-replace-emptysearch' => 'Δεν εισάγατε τίποτα προς αναζήτηση.',
	'wikieditor-toolbar-tool-replace-invalidregex' => 'Η κανονική έκφραση που δώσατε είναι άκυρη: $1',
	'wikieditor-toolbar-section-characters' => 'Ειδικοί χαρακτήρες',
	'wikieditor-toolbar-characters-page-latin' => 'Λατινικό',
	'wikieditor-toolbar-characters-page-latinextended' => 'Προέκταση του λατινικού',
	'wikieditor-toolbar-characters-page-ipa' => 'ΔΦΑ',
	'wikieditor-toolbar-characters-page-symbols' => 'Σύμβολα',
	'wikieditor-toolbar-characters-page-greek' => 'Ελληνικό',
	'wikieditor-toolbar-characters-page-cyrillic' => 'Κυριλλικό',
	'wikieditor-toolbar-characters-page-arabic' => 'Αραβικό',
	'wikieditor-toolbar-characters-page-persian' => 'Περσικό',
	'wikieditor-toolbar-characters-page-hebrew' => 'Εβραϊκό',
	'wikieditor-toolbar-characters-page-bangla' => 'Μπενγκάλι',
	'wikieditor-toolbar-characters-page-tamil' => 'Ταμίλ',
	'wikieditor-toolbar-characters-page-telugu' => 'Τελούγκου',
	'wikieditor-toolbar-characters-page-sinhala' => 'Σινχάλα',
	'wikieditor-toolbar-characters-page-gujarati' => 'Γκουχαράτι',
	'wikieditor-toolbar-characters-page-devanagari' => 'Ντεβαναγκάρι',
	'wikieditor-toolbar-characters-page-thai' => 'ταϊλανδικά',
	'wikieditor-toolbar-characters-page-lao' => 'λαοτινά',
	'wikieditor-toolbar-characters-page-khmer' => 'καμποτζιανά',
	'wikieditor-toolbar-section-help' => 'Βοήθεια',
	'wikieditor-toolbar-help-heading-description' => 'Περιγραφή',
	'wikieditor-toolbar-help-heading-syntax' => 'Τι πληκτρολογείς',
	'wikieditor-toolbar-help-heading-result' => 'Τι αποτέλεσμα λαμβάνεις',
	'wikieditor-toolbar-help-page-format' => 'Μορφοποίηση',
	'wikieditor-toolbar-help-page-link' => 'Σύνδεσμοι',
	'wikieditor-toolbar-help-page-heading' => 'Τίτλοι',
	'wikieditor-toolbar-help-page-list' => 'Λίστες',
	'wikieditor-toolbar-help-page-file' => 'Αρχεία',
	'wikieditor-toolbar-help-page-reference' => 'Παραπομπές',
	'wikieditor-toolbar-help-page-discussion' => 'Συζήτηση',
	'wikieditor-toolbar-help-content-italic-description' => 'Πλάγια',
	'wikieditor-toolbar-help-content-italic-syntax' => "''Κείμενο με πλάγιους χαρακτήρες''",
	'wikieditor-toolbar-help-content-italic-result' => '<em>Κείμενο με πλάγιους χαρακτήρες</em>',
	'wikieditor-toolbar-help-content-bold-description' => 'Έντονα',
	'wikieditor-toolbar-help-content-bold-syntax' => "'''Έντονο κείμενο'''",
	'wikieditor-toolbar-help-content-bold-result' => '<strong>Έντονο κείμενο</strong>',
	'wikieditor-toolbar-help-content-bolditalic-description' => 'Έντονα &amp; πλάγια',
	'wikieditor-toolbar-help-content-bolditalic-syntax' => "'''''Έντονο &amp; πλάγιο κείμενο'''''",
	'wikieditor-toolbar-help-content-bolditalic-result' => '<strong><em>Έντονο &amp; πλάγιο κείμενο</em></strong>',
	'wikieditor-toolbar-help-content-ilink-description' => 'Εσωτερικός σύνδεσμος',
	'wikieditor-toolbar-help-content-ilink-syntax' => '[[Τίτλος σελίδας|Ταμπέλα συνδέσμου]]<br />[[Τίτλος σελίδας]]',
	'wikieditor-toolbar-help-content-ilink-result' => "<a href='#'>Τίτλος συνδέσμου</a><br /><a href='#'>Τίτλος σελίδας</a>",
	'wikieditor-toolbar-help-content-xlink-description' => 'Εξωτερικοί σύνδεσμοι',
	'wikieditor-toolbar-help-content-xlink-syntax' => '[http://www.example.org Ταμπέλα συνδέσμου]<br />[http://www.example.org]<br />http://www.example.org',
	'wikieditor-toolbar-help-content-xlink-result' => "<a href='#' class='external'>Ταμπέλα συνδέσμου</a><br /><a href='#' class='external autonumber'>[1]</a><br /><a href='#' class='external'>http://www.example.org</a>",
	'wikieditor-toolbar-help-content-heading2-description' => 'Επικεφαλίδα 2ου επιπέδου',
	'wikieditor-toolbar-help-content-heading2-syntax' => '== Κείμενο επικεφαλίδας ==',
	'wikieditor-toolbar-help-content-heading2-result' => '<h2>Κείμενο επικεφαλίδας</h2>',
	'wikieditor-toolbar-help-content-heading3-description' => 'Επικεφαλίδα 3ου επιπέδου',
	'wikieditor-toolbar-help-content-heading3-syntax' => '=== Κείμενο επικεφαλίδας ===',
	'wikieditor-toolbar-help-content-heading3-result' => '<h3>Κείμενο επικεφαλίδας</h3>',
	'wikieditor-toolbar-help-content-heading4-description' => 'Επικεφαλίδα 4ου επιπέδου',
	'wikieditor-toolbar-help-content-heading4-syntax' => '==== Κείμενο επικεφαλίδας ====',
	'wikieditor-toolbar-help-content-heading4-result' => '<h4>Κείμενο επικεφαλίδας</h4>',
	'wikieditor-toolbar-help-content-heading5-description' => 'Επικεφαλίδα 5ου επιπέδου',
	'wikieditor-toolbar-help-content-heading5-syntax' => '===== Κείμενο επικεφαλίδας =====',
	'wikieditor-toolbar-help-content-heading5-result' => '<h5>Κείμενο επικεφαλίδας</h5>',
	'wikieditor-toolbar-help-content-ulist-description' => 'Λίστα με τελείες',
	'wikieditor-toolbar-help-content-ulist-syntax' => '* Στοιχείο της λίστας<br />* Στοιχείο της λίστας',
	'wikieditor-toolbar-help-content-ulist-result' => '<ul><li>Στοιχείο λίστας</li><li>Στοιχείο λίστας</li></ul>',
	'wikieditor-toolbar-help-content-olist-description' => 'Αριθμημένη λίστα',
	'wikieditor-toolbar-help-content-olist-syntax' => '# Αντικείμενο της λίστας<br /># Αντικείμενο της λίστας',
	'wikieditor-toolbar-help-content-olist-result' => '<ol><li>Στοιχείο λίστας</li><li>Στοιχείο λίστας</li></ol>',
	'wikieditor-toolbar-help-content-file-description' => 'Ενσωματωμένο αρχείο',
	'wikieditor-toolbar-help-content-file-syntax' => '[[$1:Example.png|thumb|Κείμενο περιγραφής]]',
	'wikieditor-toolbar-help-content-file-result' => "<div style='width:104px;' class='thumbinner'><a title='Κείμενο τίτλων' class='image' href='#'><img height='50' width='100' border='0' class='thumbimage' src='$2/WikiEditor/modules/images/toolbar/example-image.png' alt=''/></a><div class='thumbcaption'><div class='magnify'><a title='Enlarge' class='internal' href='#'><img height='11' width='15' alt='' src='$1/common/images/magnify-clip.png'/></a></div>Κείμενο τίτλων</div></div>",
	'wikieditor-toolbar-help-content-reference-description' => 'Παραπομπή',
	'wikieditor-toolbar-help-content-reference-syntax' => 'Κείμενο σελίδας.&lt;ref name="test"&gt;[http://www.example.org Κείμενο συνδέσμου], επιπλέον κείμενο.&lt;/ref&gt;',
	'wikieditor-toolbar-help-content-reference-result' => "Κείμενο σελίδας.<sup><a href='#'>[1]</a></sup>",
	'wikieditor-toolbar-help-content-rereference-description' => 'Πρόσθετη χρήση της ίδιας παραπομπής',
	'wikieditor-toolbar-help-content-rereference-result' => "Κείμενο σελίδας.<sup><a href='#'>[1]</a></sup>",
	'wikieditor-toolbar-help-content-showreferences-description' => 'Εμφάνιση παραπομπών',
	'wikieditor-toolbar-help-content-showreferences-result' => "<ol class='references'><li id='cite_note-test-0'><b><a title='' href='#'>^</a></b> <a rel='nofollow' title='http://www.example.org' class='external text' href='#'>Κείμενο συνδέσμου</a>, επιπλέον κείμενο.</li></ol>",
	'wikieditor-toolbar-help-content-signaturetimestamp-description' => 'Υπογραφή με σφραγίδα χρόνου',
	'wikieditor-toolbar-help-content-signaturetimestamp-result' => "<a href='#' title='{{#special:mypage}}'>Όνομα χρήστη</a> (<a href='#' title='{{#special:mytalk}}'>συζήτηση</a>) 10 Ιουνίου 2009 15:54 (UTC)",
	'wikieditor-toolbar-help-content-signature-description' => 'Υπογραφή',
	'wikieditor-toolbar-help-content-signature-result' => "<a href='#' title='{{#special:mypage}}'>Όνομα χρήστη</a> (<a href='#' title='{{#special:mytalk}}'>συζήτηση</a>)",
	'wikieditor-toolbar-help-content-indent-description' => 'Οδόντωση',
	'wikieditor-toolbar-help-content-indent-syntax' => 'Κανονικό κείμενο<br />:Παραγραφοποιημένο κείμενο<br />::Παραγραφοποιημένο κείμενο',
	'wikieditor-toolbar-help-content-indent-result' => 'Κανονικό κείμενο<dl><dd>Παραγραφοποιημένο κείμενο<dl><dd>Παραγραφοποιημένο κείμενο</dd></dl></dd></dl>',
);

/** Esperanto (Esperanto)
 * @author ArnoLagrange
 * @author Lucas
 * @author Marcos
 * @author Michawiki
 * @author Yekrats
 * @author Ziko
 */
$messages['eo'] = array(
	'wikieditor' => 'Progresa redaktilo por vikiteksto',
	'wikieditor-desc' => 'Ebligas redaktan interfacon por etendebla vikiteksto kaj multaj utilaj moduloj',
	'wikieditor-wikitext-tab' => 'Vikiteksto',
	'wikieditor-loading' => 'Ŝargante',
	'wikieditor-preview-preference' => 'Enŝaltu antaŭvidon apud la redaktofenestro',
	'wikieditor-preview-tab' => 'Antaŭvido',
	'wikieditor-preview-changes-tab' => 'Ŝanĝoj',
	'wikieditor-preview-loading' => 'Ŝargante...',
	'wikieditor-previewDialog-preference' => 'Ŝalti antaŭvidan dialogon',
	'wikieditor-previewDialog-tab' => 'Antaŭvido',
	'wikieditor-previewDialog-loading' => 'Ŝargante...',
	'wikieditor-publish-preference' => 'Ŝalti po-paŝan eldonadon',
	'wikieditor-publish-button-publish' => 'Konservi',
	'wikieditor-publish-button-cancel' => 'Nuligi',
	'wikieditor-publish-dialog-title' => 'Konservi al {{SITENAME}}',
	'wikieditor-publish-dialog-summary' => 'Resumo (mallonge priskribu la ŝanĝoj faritaj):',
	'wikieditor-publish-dialog-minor' => 'Eta redakto',
	'wikieditor-publish-dialog-watch' => 'Atenti ĉi tiun paĝon',
	'wikieditor-publish-dialog-publish' => 'Eldoni',
	'wikieditor-publish-dialog-goback' => 'Reen',
	'wikieditor-template-editor-preference' => 'Ŝalti formularan redaktadon de vikiaj ŝablonoj',
	'wikieditor-template-editor-dialog-title' => 'Redakti ŝablonon',
	'wikieditor-template-editor-dialog-submit' => 'Ĝisdatigi',
	'wikieditor-template-editor-dialog-cancel' => 'Nuligi',
	'wikieditor-templates-preference' => 'Ŝalti ŝablonan kaŝadon',
	'wikieditor-toc-preference' => 'Ŝalti navigeblan tabelon de enhavo',
	'wikieditor-toc-show' => 'Montri enhavon',
	'wikieditor-toc-hide' => 'Kaŝi enhavon',
	'wikieditor-toolbar' => 'Ilobreto por redaktoj',
	'wikieditor-toolbar-desc' => 'Ilobreto por redaktoj, kun plibonigita uzebleco',
	'wikieditor-toolbar-preference' => 'Enŝalti plibonigitan ilobreton por redaktoj',
	'wikieditor-toolbar-dialogs-preference' => 'Enŝalti dialogujojn por aldoni ligilojn, tabelojn kaj pli',
	'wikieditor-toolbar-hidesig' => 'Kaŝi la subskribo-butonon de paĝoj en la ĉefa nomspaco',
	'wikieditor-toolbar-loading' => 'Ŝarĝante...',
	'wikieditor-toolbar-tool-bold' => 'Diklitera',
	'wikieditor-toolbar-tool-bold-example' => 'Diklitera teksto',
	'wikieditor-toolbar-tool-italic' => 'Kursiva',
	'wikieditor-toolbar-tool-italic-example' => 'Kursiva teksto',
	'wikieditor-toolbar-tool-ilink' => 'Interna ligilo',
	'wikieditor-toolbar-tool-ilink-example' => 'Titolo de ligilo',
	'wikieditor-toolbar-tool-xlink' => 'Ekstera ligilo (memoru prefikson http://)',
	'wikieditor-toolbar-tool-xlink-example' => 'http://www.ekzemplo.com titolo de ligilo',
	'wikieditor-toolbar-tool-link' => 'Ligilo',
	'wikieditor-toolbar-tool-link-title' => 'Enmeti ligilon',
	'wikieditor-toolbar-tool-link-int' => 'Al paĝo de vikio',
	'wikieditor-toolbar-tool-link-int-target' => 'Titolo de paĝo aŭ retadreso (URL):',
	'wikieditor-toolbar-tool-link-int-target-tooltip' => 'Titolo de paĝo aŭ URL-o',
	'wikieditor-toolbar-tool-link-int-text' => 'Teksto por la ligilo:',
	'wikieditor-toolbar-tool-link-int-text-tooltip' => 'Enigi la tekston montrotan',
	'wikieditor-toolbar-tool-link-ext' => 'Al paĝo ekster la vikio',
	'wikieditor-toolbar-tool-link-ext-target' => 'Retadreso (URL) de la ligilo:',
	'wikieditor-toolbar-tool-link-ext-text' => 'Teksto de ligilo:',
	'wikieditor-toolbar-tool-link-insert' => 'Enmeti ligilon',
	'wikieditor-toolbar-tool-link-cancel' => 'Nuligi',
	'wikieditor-toolbar-tool-link-int-target-status-exists' => 'Paĝo ekzistas',
	'wikieditor-toolbar-tool-link-int-target-status-notexists' => 'Paĝo ne ekzistas',
	'wikieditor-toolbar-tool-link-int-target-status-invalid' => 'Nepermesita titolo',
	'wikieditor-toolbar-tool-link-int-target-status-external' => 'Ligilo al ekstero',
	'wikieditor-toolbar-tool-link-int-target-status-loading' => 'Kontrolante ekziston de paĝo...',
	'wikieditor-toolbar-tool-link-int-invalid' => 'La titolo kiun vi enmetis estas nepermesita.',
	'wikieditor-toolbar-tool-link-lookslikeinternal' => 'La retadreso (URL), kiun vi indikis, aspektas kvazaŭ ĝi estas ligilo al paĝo de alia vikio.
Ĉu vi volas ŝanĝi ĝin al interna ligilo?',
	'wikieditor-toolbar-tool-link-lookslikeinternal-int' => 'Interna ligilo',
	'wikieditor-toolbar-tool-link-lookslikeinternal-ext' => 'Ligilo al ekstero',
	'wikieditor-toolbar-tool-link-empty' => 'Vi ne enigis ion ajn por alligi',
	'wikieditor-toolbar-tool-file' => 'Enmetita dosiero',
	'wikieditor-toolbar-tool-file-example' => 'Ekzemplo.jpg',
	'wikieditor-toolbar-tool-file-title' => 'Enmeti dosieron',
	'wikieditor-toolbar-file-target' => 'Dosiernomo:',
	'wikieditor-toolbar-file-caption' => 'Subteksto:',
	'wikieditor-toolbar-file-size' => 'Grandeco:',
	'wikieditor-toolbar-file-float' => 'Ĝisrandigo:',
	'wikieditor-toolbar-file-default' => '(defaŭlto)',
	'wikieditor-toolbar-file-format' => 'Formato:',
	'wikieditor-toolbar-tool-file-insert' => 'Enmeti',
	'wikieditor-toolbar-tool-file-cancel' => 'Nuligi',
	'wikieditor-toolbar-tool-reference' => 'Piednoto',
	'wikieditor-toolbar-tool-reference-example' => 'Enmetu tekston de piednoto ĉi tien',
	'wikieditor-toolbar-tool-reference-cancel' => 'Nuligi',
	'wikieditor-toolbar-tool-reference-title' => 'Enmeti piednoton',
	'wikieditor-toolbar-tool-reference-insert' => 'Enmeti',
	'wikieditor-toolbar-tool-reference-text' => 'Teksto de piednoto',
	'wikieditor-toolbar-tool-signature' => 'Subskribo kaj tempindiko',
	'wikieditor-toolbar-section-advanced' => 'Pliaj iloj',
	'wikieditor-toolbar-tool-heading' => 'Titolo',
	'wikieditor-toolbar-tool-heading-1' => 'Nivelo 1',
	'wikieditor-toolbar-tool-heading-2' => 'Nivelo 2',
	'wikieditor-toolbar-tool-heading-3' => 'Nivelo 3',
	'wikieditor-toolbar-tool-heading-4' => 'Nivelo 4',
	'wikieditor-toolbar-tool-heading-5' => 'Nivelo 5',
	'wikieditor-toolbar-tool-heading-example' => 'Titola teksto',
	'wikieditor-toolbar-group-format' => 'Formato',
	'wikieditor-toolbar-tool-ulist' => 'Sennumera listigo',
	'wikieditor-toolbar-tool-ulist-example' => 'Listigo kun numeroj',
	'wikieditor-toolbar-tool-olist' => 'Listigo kun numeroj',
	'wikieditor-toolbar-tool-olist-example' => 'Ero en listigo kun numeroj',
	'wikieditor-toolbar-tool-indent' => 'Krommarĝeno',
	'wikieditor-toolbar-tool-indent-example' => 'Krommarĝena linio',
	'wikieditor-toolbar-tool-nowiki' => 'Sen vikia formatado',
	'wikieditor-toolbar-tool-nowiki-example' => 'Enmetu tekston sen formato ĉi tie',
	'wikieditor-toolbar-tool-redirect' => 'Alidirektilo',
	'wikieditor-toolbar-tool-redirect-example' => 'Nomo de la paĝo, kiun vi celas',
	'wikieditor-toolbar-tool-big' => 'Granda',
	'wikieditor-toolbar-tool-big-example' => 'Granda teksto',
	'wikieditor-toolbar-tool-small' => 'Malgranda',
	'wikieditor-toolbar-tool-small-example' => 'Malgranda teksto',
	'wikieditor-toolbar-tool-superscript' => 'Alta skribo',
	'wikieditor-toolbar-tool-superscript-example' => 'Alta skribo',
	'wikieditor-toolbar-tool-subscript' => 'Malalta skribo',
	'wikieditor-toolbar-tool-subscript-example' => 'Malalta skribo',
	'wikieditor-toolbar-group-insert' => 'Enmeti',
	'wikieditor-toolbar-tool-gallery' => 'Bilda galerio',
	'wikieditor-toolbar-tool-gallery-example' => '$1:Ekzemplo.jpg|Teksto1 pri dosiero
$1:Ekzemplo.jpg|Teksto2 pri dosiero',
	'wikieditor-toolbar-tool-newline' => 'Nova linio',
	'wikieditor-toolbar-tool-table' => 'Tabelo',
	'wikieditor-toolbar-tool-table-example-old' => '-
! titolo 1
! titolo 2
! titolo 3
|-
| linio 1, ĉelo 1
| linio 1, ĉelo 2
| linio 1, ĉelo 3
|-
| linio 2, ĉelo 1
| linio 2, ĉelo 2
| linio 2, ĉelo 3',
	'wikieditor-toolbar-tool-table-example-cell-text' => 'Teksto de ĉelo',
	'wikieditor-toolbar-tool-table-example-header' => 'Teksto de titolo',
	'wikieditor-toolbar-tool-table-title' => 'Enmeti tabelon',
	'wikieditor-toolbar-tool-table-dimensions-rows' => 'Linioj',
	'wikieditor-toolbar-tool-table-dimensions-columns' => 'Kolumnoj',
	'wikieditor-toolbar-tool-table-dimensions-header' => 'Aldonu titolan linion',
	'wikieditor-toolbar-tool-table-wikitable' => 'Akdonu bordojn',
	'wikieditor-toolbar-tool-table-sortable' => 'Fari tabelon ordigebla',
	'wikieditor-toolbar-tool-table-example' => 'Teksto de ĉelo',
	'wikieditor-toolbar-tool-table-preview' => 'Antaŭvido',
	'wikieditor-toolbar-tool-table-insert' => 'Enmeti',
	'wikieditor-toolbar-tool-table-cancel' => 'Nuligi',
	'wikieditor-toolbar-tool-table-toomany' => 'Enmeti tabelon kun pli ol $1 ĉeloj ne eblas per ĉi tiu dialogujo.',
	'wikieditor-toolbar-tool-table-invalidnumber' => 'Vi ne enigis permesitan nombron de linioj aŭ kolumnoj.',
	'wikieditor-toolbar-tool-table-zero' => 'Vi ne povas enigi tabelon kun nul linioj aŭ kolumnoj.',
	'wikieditor-toolbar-tool-replace' => 'Serĉi kaj anstataŭigi',
	'wikieditor-toolbar-tool-replace-title' => 'Serĉi kaj anstataŭigi',
	'wikieditor-toolbar-tool-replace-search' => 'Serĉi:',
	'wikieditor-toolbar-tool-replace-replace' => 'Anstataŭigi per:',
	'wikieditor-toolbar-tool-replace-case' => 'Gravas ĉu majusklo / minusklo',
	'wikieditor-toolbar-tool-replace-regex' => 'Trakti signoĉenon kiel regularan esprimon',
	'wikieditor-toolbar-tool-replace-button-findnext' => 'Trovi sekvan',
	'wikieditor-toolbar-tool-replace-button-replace' => 'Anstataŭigi',
	'wikieditor-toolbar-tool-replace-button-replaceall' => 'Anstataŭigi ĉiujn',
	'wikieditor-toolbar-tool-replace-close' => 'Fermi',
	'wikieditor-toolbar-tool-replace-nomatch' => 'Via serĉo trafis nenion.',
	'wikieditor-toolbar-tool-replace-success' => '$1 anstataŭigoj okazis.',
	'wikieditor-toolbar-tool-replace-emptysearch' => 'Vi ne enigis ion ajn por serĉi.',
	'wikieditor-toolbar-tool-replace-invalidregex' => 'La regula esprimo kiun vi enigis estas nepermesita: $1',
	'wikieditor-toolbar-section-characters' => 'Specialaj signoj',
	'wikieditor-toolbar-characters-page-latin' => 'Latina',
	'wikieditor-toolbar-characters-page-latinextended' => 'Latina etendita',
	'wikieditor-toolbar-characters-page-ipa' => 'IPA',
	'wikieditor-toolbar-characters-page-symbols' => 'Simboloj',
	'wikieditor-toolbar-characters-page-greek' => 'Greka',
	'wikieditor-toolbar-characters-page-cyrillic' => 'Cirila',
	'wikieditor-toolbar-characters-page-arabic' => 'Araba',
	'wikieditor-toolbar-characters-page-arabicextended' => 'araba etendite',
	'wikieditor-toolbar-characters-page-persian' => 'persa',
	'wikieditor-toolbar-characters-page-hebrew' => 'Hebrea',
	'wikieditor-toolbar-characters-page-bangla' => 'Bengala',
	'wikieditor-toolbar-characters-page-tamil' => 'Tamila',
	'wikieditor-toolbar-characters-page-telugu' => 'Telegua',
	'wikieditor-toolbar-characters-page-sinhala' => 'Sinhala',
	'wikieditor-toolbar-characters-page-gujarati' => 'Guĝarata',
	'wikieditor-toolbar-characters-page-devanagari' => 'Nagario',
	'wikieditor-toolbar-characters-page-thai' => 'Taja',
	'wikieditor-toolbar-characters-page-lao' => 'laŭa',
	'wikieditor-toolbar-characters-page-khmer' => 'kmera',
	'wikieditor-toolbar-section-help' => 'Helpo',
	'wikieditor-toolbar-help-heading-description' => 'Priskribo',
	'wikieditor-toolbar-help-heading-syntax' => 'Kion vi tajpas',
	'wikieditor-toolbar-help-heading-result' => 'Tion vi vidos',
	'wikieditor-toolbar-help-page-format' => 'Formatado',
	'wikieditor-toolbar-help-page-link' => 'Ligiloj',
	'wikieditor-toolbar-help-page-heading' => 'Titoloj',
	'wikieditor-toolbar-help-page-list' => 'Listoj',
	'wikieditor-toolbar-help-page-file' => 'Dosieroj',
	'wikieditor-toolbar-help-page-reference' => 'Referencoj',
	'wikieditor-toolbar-help-page-discussion' => 'Diskuto',
	'wikieditor-toolbar-help-content-italic-description' => 'Kursiva',
	'wikieditor-toolbar-help-content-italic-syntax' => "''Kursiva teksto''",
	'wikieditor-toolbar-help-content-italic-result' => '<em>Kursiva teksto</em>',
	'wikieditor-toolbar-help-content-bold-description' => 'Diklitera',
	'wikieditor-toolbar-help-content-bold-syntax' => "'''Diklitera teksto'''",
	'wikieditor-toolbar-help-content-bold-result' => '<strong>Diklitera teksto</strong>',
	'wikieditor-toolbar-help-content-bolditalic-description' => 'Diklitera &amp; kursiva',
	'wikieditor-toolbar-help-content-bolditalic-syntax' => "'''''Diklitera &amp; kursiva teksto'''''",
	'wikieditor-toolbar-help-content-bolditalic-result' => '<strong><em>Diklitera &amp; kursiva teksto</em></strong>',
	'wikieditor-toolbar-help-content-ilink-description' => 'Interna ligilo',
	'wikieditor-toolbar-help-content-ilink-syntax' => '[[Paĝa titolo|Ligila etikedo]]<br />[[Paĝa titolo]]',
	'wikieditor-toolbar-help-content-ilink-result' => "<a href='#'>Ligila etikedo</a><br /><a href='#'>Paĝa titolo</a>",
	'wikieditor-toolbar-help-content-xlink-description' => 'Ekstera ligilo',
	'wikieditor-toolbar-help-content-xlink-syntax' => '[http://www.ekzemplo.org Ligila etikedo]<br />[http://www.ekzemplo.org]<br />http://www.ekzemplo.org',
	'wikieditor-toolbar-help-content-xlink-result' => "<a href='#' class='external'>Ligila etikedo</a><br /><a href='#' class='external autonumber'>[1]</a><br /><a href='#' class='external'>http://www.ekzemplo.org</a>",
	'wikieditor-toolbar-help-content-heading2-description' => '2-a nivela titolo',
	'wikieditor-toolbar-help-content-heading2-syntax' => '== Titola teksto ==',
	'wikieditor-toolbar-help-content-heading2-result' => '<h2>Titola teksto</h2>',
	'wikieditor-toolbar-help-content-heading3-description' => '3-a nivela titolo',
	'wikieditor-toolbar-help-content-heading3-syntax' => '=== Titola teksto ===',
	'wikieditor-toolbar-help-content-heading3-result' => '<h3>Titola teksto</h3>',
	'wikieditor-toolbar-help-content-heading4-description' => '4-a nivela titolo',
	'wikieditor-toolbar-help-content-heading4-syntax' => '==== Titola teksto ====',
	'wikieditor-toolbar-help-content-heading4-result' => '<h4>Titola teksto</h4>',
	'wikieditor-toolbar-help-content-heading5-description' => '5-a nivela titolo',
	'wikieditor-toolbar-help-content-heading5-syntax' => '===== Titola teksto =====',
	'wikieditor-toolbar-help-content-heading5-result' => '<h5>Titola teksto</h5>',
	'wikieditor-toolbar-help-content-ulist-description' => 'Sennumera listigo',
	'wikieditor-toolbar-help-content-ulist-syntax' => '* Listero<br />* Listero',
	'wikieditor-toolbar-help-content-ulist-result' => '<ul><li>Listero</li><li>Listero</li></ul>',
	'wikieditor-toolbar-help-content-olist-description' => 'Nombrita listo',
	'wikieditor-toolbar-help-content-olist-syntax' => '# Listero<br /># Listero',
	'wikieditor-toolbar-help-content-olist-result' => '<ol><li>Listero</li><li>Listero</li></ol>',
	'wikieditor-toolbar-help-content-file-description' => 'Enmetita dosiero',
	'wikieditor-toolbar-help-content-file-syntax' => '[[$1:Example.png|thumb|Teksto pri dosiero]]',
	'wikieditor-toolbar-help-content-file-result' => "<div style='width:104px;' class='thumbinner'><a title='Caption text' class='image' href='#'><img height='50' width='100' border='0' class='thumbimage' src='$2/WikiEditor/modules/images/toolbar/example-image.png' alt=''/></a><div class='thumbcaption'><div class='magnify'><a title='Pligrandigi' class='internal' href='#'><img height='11' width='15' alt='' src='$1/common/images/magnify-clip.png'/></a></div>Teksto pri dosiero</div></div>",
	'wikieditor-toolbar-help-content-reference-description' => 'Piednoto',
	'wikieditor-toolbar-help-content-reference-syntax' => 'Paĝa teksto.&lt;ref name="test"&gt;[http://www.ekzemplo.org Ligila teksto], aldona teksto.&lt;/ref&gt;',
	'wikieditor-toolbar-help-content-reference-result' => "Paĝa teksto.<sup><a href='#'>[1]</a></sup>",
	'wikieditor-toolbar-help-content-rereference-description' => 'Reuzo de la sama piednoto.',
	'wikieditor-toolbar-help-content-rereference-result' => "Paĝa teksto.<sup><a href='#'>[1]</a></sup>",
	'wikieditor-toolbar-help-content-showreferences-description' => 'Montri piednotojn',
	'wikieditor-toolbar-help-content-showreferences-result' => "<ol class='references'><li id='cite_note-test-0'><b><a title='' href='#'>^</a></b> <a rel='nofollow' title='http://www.ekzemplo.org' class='external text' href='#'>Ligila teksto</a>, aldona teksto.</li></ol>",
	'wikieditor-toolbar-help-content-signaturetimestamp-description' => 'Subskribo kun tempindiko',
	'wikieditor-toolbar-help-content-signaturetimestamp-result' => "<a href='#' title='{{#special:mypage}}'>Salutnomo</a> (<a href='#' title='{{#special:mytalk}}'>diskuto</a>) 15:54, 10 junio 2009 (UTC)",
	'wikieditor-toolbar-help-content-signature-description' => 'Subskribo',
	'wikieditor-toolbar-help-content-signature-result' => "<a href='#' title='{{#special:mypage}}'>Salutnomo</a> (<a href='#' title='{{#special:mytalk}}'>diskuto</a>)",
	'wikieditor-toolbar-help-content-indent-description' => 'Krommarĝeno',
	'wikieditor-toolbar-help-content-indent-syntax' => 'Norma teksto<br />:Krommarĝena teksto<br />::Krommarĝena teksto',
	'wikieditor-toolbar-help-content-indent-result' => 'Norma teksto<dl><dd>Krommarĝena teksto<dl><dd>Krommarĝena teksto</dd></dl><dd></dl>',
);

/** Spanish (español)
 * @author -jem-
 * @author AlimanRuna
 * @author Armando-Martin
 * @author Crazymadlover
 * @author Fitoschido
 * @author Imre
 * @author Invadinado
 * @author Locos epraix
 * @author McDutchie
 * @author PerroVerd
 * @author Pertile
 * @author Peter17
 * @author Platonides
 * @author Translationista
 * @author Vivaelcelta
 */
$messages['es'] = array(
	'wikieditor' => 'Interfaz avanzada de edición de wikitexto',
	'wikieditor-desc' => 'Provee de una interfaz extensible de edición de wikitexto y varios módulos que ofrecen características',
	'wikieditor-wikitext-tab' => 'Wikitexto',
	'wikieditor-loading' => 'Cargando',
	'wikieditor-preview-preference' => 'Habilitar previsualización comparativa',
	'wikieditor-preview-tab' => 'Previsualizar',
	'wikieditor-preview-changes-tab' => 'Cambios',
	'wikieditor-preview-loading' => 'Cargando...',
	'wikieditor-previewDialog-preference' => 'Habilitar diálogo de vista previa',
	'wikieditor-previewDialog-tab' => 'Previsualizar',
	'wikieditor-previewDialog-loading' => 'Cargando...',
	'wikieditor-publish-preference' => 'Habilitar publicación paso a paso',
	'wikieditor-publish-button-publish' => 'Publicar',
	'wikieditor-publish-button-cancel' => 'Cancelar',
	'wikieditor-publish-dialog-title' => 'Publicar en {{SITENAME}}',
	'wikieditor-publish-dialog-summary' => 'Resumen de edición (describe brevemente los cambios que has realizado):',
	'wikieditor-publish-dialog-minor' => 'Edición menor',
	'wikieditor-publish-dialog-watch' => 'Vigilar esta página',
	'wikieditor-publish-dialog-publish' => 'Publicar',
	'wikieditor-publish-dialog-goback' => 'Regresar',
	'wikieditor-template-editor-preference' => 'Habilitar la edición plantillas usando formularios',
	'wikieditor-template-editor-dialog-title' => 'Editar plantilla',
	'wikieditor-template-editor-dialog-submit' => 'Actualizar',
	'wikieditor-template-editor-dialog-cancel' => 'Cancelar',
	'wikieditor-templates-preference' => 'Habilitar colapso de plantilla',
	'wikieditor-toc-preference' => 'Habilitar tabla de contenidos navegable',
	'wikieditor-toc-show' => 'Mostrar el contenido',
	'wikieditor-toc-hide' => 'Ocultar el contenido',
	'wikieditor-toolbar' => 'Barra de herramientas de edición',
	'wikieditor-toolbar-desc' => 'Barra de herramientas de la página de edición con usabilidad mejorada',
	'wikieditor-toolbar-preference' => 'Habilitar la barra de herramientas de edición mejorada',
	'wikieditor-toolbar-dialogs-preference' => 'Habilitar diálogos para insertar enlaces, tablas y más',
	'wikieditor-toolbar-hidesig' => 'Ocultar el botón firmar de las páginas en el espacio de nombres principal',
	'wikieditor-toolbar-loading' => 'Cargando...',
	'wikieditor-toolbar-tool-bold' => 'Negrita',
	'wikieditor-toolbar-tool-bold-example' => 'Texto en negrita',
	'wikieditor-toolbar-tool-italic' => 'Cursiva',
	'wikieditor-toolbar-tool-italic-example' => 'Texto en cursiva',
	'wikieditor-toolbar-tool-ilink' => 'Vínculo interno',
	'wikieditor-toolbar-tool-ilink-example' => 'Título del enlace',
	'wikieditor-toolbar-tool-xlink' => 'Enlace externo (recordar prefijo http://)',
	'wikieditor-toolbar-tool-xlink-example' => 'http://www.example.com título del enlace',
	'wikieditor-toolbar-tool-link' => 'Enlace',
	'wikieditor-toolbar-tool-link-title' => 'Insertar enlace',
	'wikieditor-toolbar-tool-link-int' => 'A una página wiki',
	'wikieditor-toolbar-tool-link-int-target' => 'Título de página:',
	'wikieditor-toolbar-tool-link-int-target-tooltip' => 'Título de la página o URL',
	'wikieditor-toolbar-tool-link-int-text' => 'Título del enlace',
	'wikieditor-toolbar-tool-link-int-text-tooltip' => 'Introducir el texto para mostrar',
	'wikieditor-toolbar-tool-link-ext' => 'A una página web externa',
	'wikieditor-toolbar-tool-link-ext-target' => 'URL del enlace:',
	'wikieditor-toolbar-tool-link-ext-text' => 'Título del enlace:',
	'wikieditor-toolbar-tool-link-insert' => 'Insertar enlace',
	'wikieditor-toolbar-tool-link-cancel' => 'Cancelar',
	'wikieditor-toolbar-tool-link-int-target-status-exists' => 'La página existe',
	'wikieditor-toolbar-tool-link-int-target-status-notexists' => 'No existe la página',
	'wikieditor-toolbar-tool-link-int-target-status-invalid' => 'Título inválido',
	'wikieditor-toolbar-tool-link-int-target-status-external' => 'Enlace externo',
	'wikieditor-toolbar-tool-link-int-target-status-loading' => 'Revisando existencia de la página...',
	'wikieditor-toolbar-tool-link-int-invalid' => 'El título que ha especificado no es válido.',
	'wikieditor-toolbar-tool-link-lookslikeinternal' => 'EL URL que has especificado parece que tenia como finalidad ser un vínculo para otra página wiki.
¿Deseas hacerlo un vínculo interno?',
	'wikieditor-toolbar-tool-link-lookslikeinternal-int' => 'Enlace interno',
	'wikieditor-toolbar-tool-link-lookslikeinternal-ext' => 'Enlace externo',
	'wikieditor-toolbar-tool-link-empty' => 'No has escrito nada a qué vincular.',
	'wikieditor-toolbar-tool-file' => 'Archivo empotrado',
	'wikieditor-toolbar-tool-file-example' => 'Ejemplo.jpg',
	'wikieditor-toolbar-tool-file-title' => 'Insertar archivo',
	'wikieditor-toolbar-file-target' => 'Nombre de archivo:',
	'wikieditor-toolbar-file-caption' => 'Leyenda:',
	'wikieditor-toolbar-file-size' => 'Tamaño:',
	'wikieditor-toolbar-file-float' => 'Alinear:',
	'wikieditor-toolbar-file-default' => '(por defecto)',
	'wikieditor-toolbar-file-format' => 'Formato:',
	'wikieditor-toolbar-file-format-none' => 'ninguno',
	'wikieditor-toolbar-tool-file-insert' => 'Insertar',
	'wikieditor-toolbar-tool-file-cancel' => 'Cancelar',
	'wikieditor-toolbar-tool-reference' => 'Referencia',
	'wikieditor-toolbar-tool-reference-example' => 'Insertar nota a pie de página aquí',
	'wikieditor-toolbar-tool-reference-cancel' => 'Cancelar',
	'wikieditor-toolbar-tool-reference-title' => 'Insertar una referencia',
	'wikieditor-toolbar-tool-reference-insert' => 'Insertar',
	'wikieditor-toolbar-tool-reference-text' => 'Texto de referencia',
	'wikieditor-toolbar-tool-signature' => 'Firma y fecha',
	'wikieditor-toolbar-section-advanced' => 'Avanzado',
	'wikieditor-toolbar-tool-heading' => 'Encabezado',
	'wikieditor-toolbar-tool-heading-1' => 'Nivel 1',
	'wikieditor-toolbar-tool-heading-2' => 'Nivel 2',
	'wikieditor-toolbar-tool-heading-3' => 'Nivel 3',
	'wikieditor-toolbar-tool-heading-4' => 'Nivel 4',
	'wikieditor-toolbar-tool-heading-5' => 'Nivel 5',
	'wikieditor-toolbar-tool-heading-example' => 'Texto de encabezado',
	'wikieditor-toolbar-group-format' => 'Formato',
	'wikieditor-toolbar-tool-ulist' => 'Lista viñeteada',
	'wikieditor-toolbar-tool-ulist-example' => 'Ítem de lista de viñetas',
	'wikieditor-toolbar-tool-olist' => 'Lista numerada',
	'wikieditor-toolbar-tool-olist-example' => 'Ítem de lista numerada',
	'wikieditor-toolbar-tool-indent' => 'Indentación',
	'wikieditor-toolbar-tool-indent-example' => 'Línea indentada',
	'wikieditor-toolbar-tool-nowiki' => 'Sin formato wiki',
	'wikieditor-toolbar-tool-nowiki-example' => 'Introduzca texto sin formato aquí',
	'wikieditor-toolbar-tool-redirect' => 'Redirección',
	'wikieditor-toolbar-tool-redirect-example' => 'Nombre de la página destino',
	'wikieditor-toolbar-tool-big' => 'Grande',
	'wikieditor-toolbar-tool-big-example' => 'Texto grande',
	'wikieditor-toolbar-tool-small' => 'Pequeño',
	'wikieditor-toolbar-tool-small-example' => 'Texto pequeño',
	'wikieditor-toolbar-tool-superscript' => 'Superescrito',
	'wikieditor-toolbar-tool-superscript-example' => 'Texto superescrito',
	'wikieditor-toolbar-tool-subscript' => 'Suscribir',
	'wikieditor-toolbar-tool-subscript-example' => 'Texto suscrito',
	'wikieditor-toolbar-group-insert' => 'Insertar',
	'wikieditor-toolbar-tool-gallery' => 'Galería de fotos',
	'wikieditor-toolbar-tool-gallery-example' => '$1:Ejemplo.jpg|Descripción1
$1:Ejemplo.jpg|Descripción2',
	'wikieditor-toolbar-tool-newline' => 'Nueva línea',
	'wikieditor-toolbar-tool-table' => 'Tabla',
	'wikieditor-toolbar-tool-table-example-old' => '-
! encabezado 1
! encabezado 2
! encabezado 3
|-
| fila 1, celda 1
| fila 1, celda 2
| fila 1, celda 3
|-
| fila 2, celda 1
| fila 2, celda 2
| fila 2, celda 3',
	'wikieditor-toolbar-tool-table-example-cell-text' => 'Texto de celda',
	'wikieditor-toolbar-tool-table-example-header' => 'Texto de encabezado',
	'wikieditor-toolbar-tool-table-title' => 'Inserte tabla',
	'wikieditor-toolbar-tool-table-dimensions-rows' => 'Filas',
	'wikieditor-toolbar-tool-table-dimensions-columns' => 'Columnas',
	'wikieditor-toolbar-tool-table-dimensions-header' => 'Incluir encabezado de fila',
	'wikieditor-toolbar-tool-table-wikitable' => 'Estilo con bordes',
	'wikieditor-toolbar-tool-table-sortable' => 'Hacer la tabla organizable',
	'wikieditor-toolbar-tool-table-example' => 'Texto de celda',
	'wikieditor-toolbar-tool-table-preview' => 'Previsualización',
	'wikieditor-toolbar-tool-table-insert' => 'Insertar',
	'wikieditor-toolbar-tool-table-cancel' => 'Cancelar',
	'wikieditor-toolbar-tool-table-toomany' => 'Insertar una tabla con más de $1 celdas no es posible con este cuadro de diálogo.',
	'wikieditor-toolbar-tool-table-invalidnumber' => 'No se ha introducido un número válido de filas o columnas.',
	'wikieditor-toolbar-tool-table-zero' => 'No se puede insertar una tabla con cero filas o columnas.',
	'wikieditor-toolbar-tool-replace' => 'Buscar y reemplazar',
	'wikieditor-toolbar-tool-replace-title' => 'Buscar y reemplazar',
	'wikieditor-toolbar-tool-replace-search' => 'Buscar:',
	'wikieditor-toolbar-tool-replace-replace' => 'Reemplazar por:',
	'wikieditor-toolbar-tool-replace-case' => 'Considerar mayúsculas',
	'wikieditor-toolbar-tool-replace-regex' => 'Tratar la cadena de búsqueda como expresión regular',
	'wikieditor-toolbar-tool-replace-button-findnext' => 'Buscar siguiente',
	'wikieditor-toolbar-tool-replace-button-replace' => 'Reemplazar',
	'wikieditor-toolbar-tool-replace-button-replaceall' => 'Reemplazar todo',
	'wikieditor-toolbar-tool-replace-close' => 'Cerrar',
	'wikieditor-toolbar-tool-replace-nomatch' => 'Su búsqueda no halló resultados.',
	'wikieditor-toolbar-tool-replace-success' => '$1 reemplazos hechos',
	'wikieditor-toolbar-tool-replace-emptysearch' => 'No ingresó nada para buscar.',
	'wikieditor-toolbar-tool-replace-invalidregex' => 'La expresión regular que ha introducido es inválida: $1',
	'wikieditor-toolbar-section-characters' => 'Caracteres especiales',
	'wikieditor-toolbar-characters-page-latin' => 'Latín',
	'wikieditor-toolbar-characters-page-latinextended' => 'Latín extendido',
	'wikieditor-toolbar-characters-page-ipa' => 'AFI',
	'wikieditor-toolbar-characters-page-symbols' => 'Símbolos',
	'wikieditor-toolbar-characters-page-greek' => 'Griego',
	'wikieditor-toolbar-characters-page-cyrillic' => 'Cirílico',
	'wikieditor-toolbar-characters-page-arabic' => 'Árabe',
	'wikieditor-toolbar-characters-page-arabicextended' => 'Arábico extendido',
	'wikieditor-toolbar-characters-page-persian' => 'Persa',
	'wikieditor-toolbar-characters-page-hebrew' => 'Hebreo',
	'wikieditor-toolbar-characters-page-bangla' => 'Bengalí',
	'wikieditor-toolbar-characters-page-tamil' => 'Tamil',
	'wikieditor-toolbar-characters-page-telugu' => 'Telugú',
	'wikieditor-toolbar-characters-page-sinhala' => 'Sinhala',
	'wikieditor-toolbar-characters-page-gujarati' => 'Gujarati',
	'wikieditor-toolbar-characters-page-devanagari' => 'Devanagari',
	'wikieditor-toolbar-characters-page-thai' => 'Thai',
	'wikieditor-toolbar-characters-page-lao' => 'Lao',
	'wikieditor-toolbar-characters-page-khmer' => 'Khmer',
	'wikieditor-toolbar-section-help' => 'Ayuda',
	'wikieditor-toolbar-help-heading-description' => 'Descripción',
	'wikieditor-toolbar-help-heading-syntax' => 'Lo que escribe',
	'wikieditor-toolbar-help-heading-result' => 'Lo que obtiene',
	'wikieditor-toolbar-help-page-format' => 'Formateando',
	'wikieditor-toolbar-help-page-link' => 'Enlaces',
	'wikieditor-toolbar-help-page-heading' => 'Encabezados',
	'wikieditor-toolbar-help-page-list' => 'Listas',
	'wikieditor-toolbar-help-page-file' => 'Archivos',
	'wikieditor-toolbar-help-page-reference' => 'Referencias',
	'wikieditor-toolbar-help-page-discussion' => 'Discusión',
	'wikieditor-toolbar-help-content-italic-description' => 'Itálica',
	'wikieditor-toolbar-help-content-italic-syntax' => "''Texto en cursiva''",
	'wikieditor-toolbar-help-content-italic-result' => '<em>Texto en cursiva</em>',
	'wikieditor-toolbar-help-content-bold-description' => 'Negrita',
	'wikieditor-toolbar-help-content-bold-syntax' => "'''Texto en negrita'''",
	'wikieditor-toolbar-help-content-bold-result' => '<strong>Texto en negrita</strong>',
	'wikieditor-toolbar-help-content-bolditalic-description' => 'Negrita &amp; cursiva',
	'wikieditor-toolbar-help-content-bolditalic-syntax' => "'''''Texto en negrita y cursiva'''''",
	'wikieditor-toolbar-help-content-bolditalic-result' => '<strong><em>Texto en negrita &amp; cursiva</em></strong>',
	'wikieditor-toolbar-help-content-ilink-description' => 'Enlace interno',
	'wikieditor-toolbar-help-content-ilink-syntax' => '[[Título de la página|Texto del enlace]]<br />[[Título de la página]]',
	'wikieditor-toolbar-help-content-ilink-result' => "<a href='#'>Etiqueta de vínculo</a><br /><a href='#'>Título de página</a>",
	'wikieditor-toolbar-help-content-xlink-description' => 'Enlace externo',
	'wikieditor-toolbar-help-content-xlink-syntax' => '[http://www.example.org Etiqueta del enlace]<br />[http://www.example.org]<br />http://www.example.org',
	'wikieditor-toolbar-help-content-xlink-result' => "<a href='#' class='external'>Etiqueta del enlace</a><br /><a href='#' class='external autonumber'>[1]</a><br /><a href='#' class='external'>http://www.example.org</a>",
	'wikieditor-toolbar-help-content-heading2-description' => 'Encabezado de 2º nivel',
	'wikieditor-toolbar-help-content-heading2-syntax' => '== Texto de encabezado ==',
	'wikieditor-toolbar-help-content-heading2-result' => '<h2>Texto de encabezado</h2>',
	'wikieditor-toolbar-help-content-heading3-description' => 'Encabezado de 3º nivel',
	'wikieditor-toolbar-help-content-heading3-syntax' => '=== Texto de encabezado ===',
	'wikieditor-toolbar-help-content-heading3-result' => '<h3>Texto de encabezado</h3>',
	'wikieditor-toolbar-help-content-heading4-description' => 'Encabezado de 4º nivel',
	'wikieditor-toolbar-help-content-heading4-syntax' => '==== Texto de encabezado ====',
	'wikieditor-toolbar-help-content-heading4-result' => '<h4>Texto de encabezado</h4>',
	'wikieditor-toolbar-help-content-heading5-description' => 'Encabezado de 5º nivel',
	'wikieditor-toolbar-help-content-heading5-syntax' => '===== Texto de encabezado =====',
	'wikieditor-toolbar-help-content-heading5-result' => '<h5>Texto de encabezado</h5>',
	'wikieditor-toolbar-help-content-ulist-description' => 'Lista viñeteada',
	'wikieditor-toolbar-help-content-ulist-syntax' => '* Listar item<br />* Listar item',
	'wikieditor-toolbar-help-content-ulist-result' => '<ul><li>Listar item</li><li>Listar item</li></ul>',
	'wikieditor-toolbar-help-content-olist-description' => 'Lista numerada',
	'wikieditor-toolbar-help-content-olist-syntax' => '# Listar item<br /># Listar item',
	'wikieditor-toolbar-help-content-olist-result' => '<ol><li>Listar item</li><li>Listar item</li></ol>',
	'wikieditor-toolbar-help-content-file-description' => 'Archivo empotrado',
	'wikieditor-toolbar-help-content-file-syntax' => '[[$1:Ejemplo.png|thumb|Texto de la leyenda]]',
	'wikieditor-toolbar-help-content-file-result' => "<div style='width:104px;' class='thumbinner'><a title='Caption text' class='image' href='#'><img height='50' width='100' border='0' class='thumbimage' src='$2/WikiEditor/modules/images/toolbar/example-image.png' alt=''/></a><div class='thumbcaption'><div class='magnify'><a title='Enlarge' class='internal' href='#'><img height='11' width='15' alt='' src='$1/common/images/magnify-clip.png'/></a></div>Texto leyenda</div></div>",
	'wikieditor-toolbar-help-content-reference-description' => 'Referencia',
	'wikieditor-toolbar-help-content-reference-syntax' => 'Texto de página.&lt;ref name="test"&gt;[http://www.example.org Texto de vínculo], texto adicional.&lt;/ref&gt;',
	'wikieditor-toolbar-help-content-reference-result' => "Texto de página.<sup><a href='#'>[1]</a></sup>",
	'wikieditor-toolbar-help-content-rereference-description' => 'Uso adicional de la misma referencia',
	'wikieditor-toolbar-help-content-rereference-result' => "Texto de página.<sup><a href='#'>[1]</a></sup>",
	'wikieditor-toolbar-help-content-showreferences-description' => 'Mostrar referencias',
	'wikieditor-toolbar-help-content-showreferences-result' => "<ol class='references'><li id='cite_note-test-0'><b><a title='' href='#'>^</a></b> <a rel='nofollow' title='http://www.example.org' class='external text' href='#'>Texto de vínculo</a>, texto adicional.</li></ol>",
	'wikieditor-toolbar-help-content-signaturetimestamp-description' => 'Fecha y firma',
	'wikieditor-toolbar-help-content-signaturetimestamp-result' => "<a href='#' title='{{#special:mypage}}'>Nombre de usuario</a> (<a href='#' title='{{#special:mytalk}}'>discusión</a>) 15:54, 10 June 2009 (UTC)",
	'wikieditor-toolbar-help-content-signature-description' => 'Firma',
	'wikieditor-toolbar-help-content-signature-result' => "<a href='#' title='{{#special:mypage}}'>Nombre de usuario</a> (<a href='#' title='{{#special:mytalk}}'>discusión</a>)",
	'wikieditor-toolbar-help-content-indent-description' => 'Indentado',
	'wikieditor-toolbar-help-content-indent-syntax' => 'Texto normal<br />:Texto indentado<br />::Texto indentado',
	'wikieditor-toolbar-help-content-indent-result' => 'Texto normal<dl><dd>Texto indentado<dl><dd>Texto indentado</dd></dl></dd></dl>',
);

/** Estonian (eesti)
 * @author Avjoska
 * @author Kyng
 * @author Pikne
 * @author WikedKentaur
 */
$messages['et'] = array(
	'wikieditor' => 'Vikiteksti laiendatud redigeerimisliides',
	'wikieditor-desc' => 'Sisaldab vikiteksti laiendatud redigeerimisliidest ja palju redigeerimisfunktsioone.',
	'wikieditor-wikitext-tab' => 'Vikitekst',
	'wikieditor-loading' => 'Laadimine...',
	'wikieditor-preview-preference' => 'Kuva eelvaade külgmisel sakil',
	'wikieditor-preview-tab' => 'Eelvaade',
	'wikieditor-preview-changes-tab' => 'Muudatused',
	'wikieditor-preview-loading' => 'Laadimine...',
	'wikieditor-previewDialog-tab' => 'Eelvaade',
	'wikieditor-previewDialog-loading' => 'Laadimine...',
	'wikieditor-publish-preference' => 'Kasuta astmelist avaldamist',
	'wikieditor-publish-button-publish' => 'Avalda',
	'wikieditor-publish-button-cancel' => 'Loobu',
	'wikieditor-publish-dialog-title' => '{{GRAMMAR:inessive|{{SITENAME}}}} avaldamine',
	'wikieditor-publish-dialog-summary' => 'Redaktsiooni kokkuvõte (kirjelda lühidalt tehtud muudatusi):',
	'wikieditor-publish-dialog-minor' => 'Pisimuudatus',
	'wikieditor-publish-dialog-watch' => 'Jälgi seda lehekülge',
	'wikieditor-publish-dialog-publish' => 'Avalda',
	'wikieditor-publish-dialog-goback' => 'Tagasi',
	'wikieditor-template-editor-preference' => 'Luba vormipõhine viki mallide toimetamine',
	'wikieditor-template-editor-dialog-title' => 'Muuda malli',
	'wikieditor-template-editor-dialog-submit' => 'Uuendus',
	'wikieditor-template-editor-dialog-cancel' => 'Loobu',
	'wikieditor-templates-preference' => 'Luba mallide kokkulükkamine',
	'wikieditor-toc-preference' => 'Kasuta navigeerimist võimaldavat sisukorda',
	'wikieditor-toc-show' => 'Näita sisu',
	'wikieditor-toc-hide' => 'Peida sisu',
	'wikieditor-toolbar' => 'Toimetamise tööriistariba',
	'wikieditor-toolbar-desc' => 'Täiustatud kasutushõlpsusega redigeerimislehekülje tööriistariba',
	'wikieditor-toolbar-preference' => 'Kasuta laiendatud redigeerimisriba',
	'wikieditor-toolbar-dialogs-preference' => 'Kasuta tabelite ja muu lisamiseks dialoogikaste',
	'wikieditor-toolbar-hidesig' => 'Peida põhinimeruumi lehekülgedel allkirjanupp',
	'wikieditor-toolbar-loading' => 'Laadimine...',
	'wikieditor-toolbar-tool-bold' => 'Rasvane',
	'wikieditor-toolbar-tool-bold-example' => 'Rasvane kiri',
	'wikieditor-toolbar-tool-italic' => 'Kaldkiri',
	'wikieditor-toolbar-tool-italic-example' => 'Kaldkiri',
	'wikieditor-toolbar-tool-ilink' => 'Siselink',
	'wikieditor-toolbar-tool-ilink-example' => 'Lingi pealkiri',
	'wikieditor-toolbar-tool-xlink' => 'Välislink (ära unusta eesliidet http://)',
	'wikieditor-toolbar-tool-xlink-example' => 'http://www.näide.ee lingi pealkiri',
	'wikieditor-toolbar-tool-link' => 'Link',
	'wikieditor-toolbar-tool-link-title' => 'Lingi lisamine',
	'wikieditor-toolbar-tool-link-int' => 'Vikileheküljele',
	'wikieditor-toolbar-tool-link-int-target' => 'Lehekülje pealkiri:',
	'wikieditor-toolbar-tool-link-int-target-tooltip' => 'Lehekülje pealkiri või internetiaadress',
	'wikieditor-toolbar-tool-link-int-text' => 'Lingi tekst:',
	'wikieditor-toolbar-tool-link-int-text-tooltip' => 'Kuvatav tekst',
	'wikieditor-toolbar-tool-link-ext' => 'Välisele võrguleheküljele',
	'wikieditor-toolbar-tool-link-ext-target' => 'Lingi aadress:',
	'wikieditor-toolbar-tool-link-ext-text' => 'Lingi tekst:',
	'wikieditor-toolbar-tool-link-insert' => 'Lisa link',
	'wikieditor-toolbar-tool-link-cancel' => 'Loobu',
	'wikieditor-toolbar-tool-link-int-target-status-exists' => 'Lehekülg on olemas',
	'wikieditor-toolbar-tool-link-int-target-status-notexists' => 'Lehekülge pole',
	'wikieditor-toolbar-tool-link-int-target-status-invalid' => 'Vigane pealkiri',
	'wikieditor-toolbar-tool-link-int-target-status-external' => 'Välislink',
	'wikieditor-toolbar-tool-link-int-target-status-loading' => 'Lehekülje olemasolu kindlakstegemine...',
	'wikieditor-toolbar-tool-link-int-invalid' => 'Määratud pealkiri on vigane.',
	'wikieditor-toolbar-tool-link-lookslikeinternal' => 'Paistab, et sisestatud internetiaadress viitab teisele vikileheküljele.
Kas soovid sellest siselingi teha?',
	'wikieditor-toolbar-tool-link-lookslikeinternal-int' => 'Siselink',
	'wikieditor-toolbar-tool-link-lookslikeinternal-ext' => 'Välislink',
	'wikieditor-toolbar-tool-link-empty' => 'Sa ei sisestanud midagi, millele linkida.',
	'wikieditor-toolbar-tool-file' => 'Manusfail',
	'wikieditor-toolbar-tool-file-example' => 'Näide.jpg',
	'wikieditor-toolbar-tool-file-title' => 'Faili lisamine',
	'wikieditor-toolbar-file-target' => 'Failinimi:',
	'wikieditor-toolbar-file-caption' => 'Allkiri:',
	'wikieditor-toolbar-file-size' => 'Suurus:',
	'wikieditor-toolbar-file-float' => 'Joondus:',
	'wikieditor-toolbar-file-default' => '(vaikeväärtus)',
	'wikieditor-toolbar-file-format' => 'Vormistus:',
	'wikieditor-toolbar-tool-file-insert' => 'Lisa',
	'wikieditor-toolbar-tool-file-cancel' => 'Loobu',
	'wikieditor-toolbar-tool-reference' => 'Viide',
	'wikieditor-toolbar-tool-reference-example' => 'Lisa siia allmärkuse tekst',
	'wikieditor-toolbar-tool-reference-cancel' => 'Loobu',
	'wikieditor-toolbar-tool-reference-title' => 'Viite lisamine',
	'wikieditor-toolbar-tool-reference-insert' => 'Lisa',
	'wikieditor-toolbar-tool-reference-text' => 'Viite tekst',
	'wikieditor-toolbar-tool-signature' => 'Allkiri ja ajatempel',
	'wikieditor-toolbar-section-advanced' => 'Laiendatud',
	'wikieditor-toolbar-tool-heading' => 'Pealkiri',
	'wikieditor-toolbar-tool-heading-1' => 'Pealkiri 1',
	'wikieditor-toolbar-tool-heading-2' => 'Pealkiri 2',
	'wikieditor-toolbar-tool-heading-3' => 'Pealkiri 3',
	'wikieditor-toolbar-tool-heading-4' => 'Pealkiri 4',
	'wikieditor-toolbar-tool-heading-5' => 'Pealkiri 5',
	'wikieditor-toolbar-tool-heading-example' => 'Pealkirja tekst',
	'wikieditor-toolbar-group-format' => 'Vorming',
	'wikieditor-toolbar-tool-ulist' => 'Täpploend',
	'wikieditor-toolbar-tool-ulist-example' => 'Täpploendi liige',
	'wikieditor-toolbar-tool-olist' => 'Numberloend',
	'wikieditor-toolbar-tool-olist-example' => 'Numberloendi liige',
	'wikieditor-toolbar-tool-indent' => 'Taane',
	'wikieditor-toolbar-tool-indent-example' => 'Taandrida',
	'wikieditor-toolbar-tool-nowiki' => 'Vikivorminduseta',
	'wikieditor-toolbar-tool-nowiki-example' => 'Lisa siia mittevormindatav tekst',
	'wikieditor-toolbar-tool-redirect' => 'Ümbersuunamine',
	'wikieditor-toolbar-tool-redirect-example' => 'Sihtlehekülje pealkiri',
	'wikieditor-toolbar-tool-big' => 'Suur',
	'wikieditor-toolbar-tool-big-example' => 'Suur tekst',
	'wikieditor-toolbar-tool-small' => 'Väike',
	'wikieditor-toolbar-tool-small-example' => 'Väike tekst',
	'wikieditor-toolbar-tool-superscript' => 'Ülaindeks',
	'wikieditor-toolbar-tool-superscript-example' => 'Tekst ülaindeksina',
	'wikieditor-toolbar-tool-subscript' => 'Allindeks',
	'wikieditor-toolbar-tool-subscript-example' => 'Tekst allindeksina',
	'wikieditor-toolbar-group-insert' => 'Lisa',
	'wikieditor-toolbar-tool-gallery' => 'Pildigalerii',
	'wikieditor-toolbar-tool-gallery-example' => '$1:Näide.jpg|Pildiallkiri1
$1:Näide.jpg|Pildiallkiri2',
	'wikieditor-toolbar-tool-newline' => 'Uus rida',
	'wikieditor-toolbar-tool-table' => 'Tabel',
	'wikieditor-toolbar-tool-table-example-old' => '-
! päis 1
! päis 2
! päis 3
|-
| 1. rida, 1. lahter
| 1. rida, 2. lahter
| 1. rida, 3. lahter
|-
| 2. rida, 1. lahter
| 2. rida, 2. lahter
| 2. rida, 3. lahter',
	'wikieditor-toolbar-tool-table-example-cell-text' => 'Lahtri tekst',
	'wikieditor-toolbar-tool-table-example-header' => 'Päise tekst',
	'wikieditor-toolbar-tool-table-title' => 'Tabeli lisamine',
	'wikieditor-toolbar-tool-table-dimensions-rows' => 'Ridu',
	'wikieditor-toolbar-tool-table-dimensions-columns' => 'Veerge',
	'wikieditor-toolbar-tool-table-dimensions-header' => 'Lisa päiserida',
	'wikieditor-toolbar-tool-table-wikitable' => 'Stiliseeritud äärised',
	'wikieditor-toolbar-tool-table-sortable' => 'Tee tabel sorditavaks',
	'wikieditor-toolbar-tool-table-example' => 'Näide',
	'wikieditor-toolbar-tool-table-preview' => 'Eelvaade',
	'wikieditor-toolbar-tool-table-insert' => 'Lisa',
	'wikieditor-toolbar-tool-table-cancel' => 'Loobu',
	'wikieditor-toolbar-tool-table-toomany' => 'Selle dialoogiaknaga ei saa lisada tabelit, millel on rohkem kui $1 lahter.',
	'wikieditor-toolbar-tool-table-invalidnumber' => 'Sa pole sisestanud sobivat ridade ega veergude määra.',
	'wikieditor-toolbar-tool-table-zero' => 'Ühegi rea ega veeruta tabelit ei saa lisada',
	'wikieditor-toolbar-tool-replace' => 'Otsi ja asenda',
	'wikieditor-toolbar-tool-replace-title' => 'Otsimine ja asendus',
	'wikieditor-toolbar-tool-replace-search' => 'Otsitav:',
	'wikieditor-toolbar-tool-replace-replace' => 'Asendaja:',
	'wikieditor-toolbar-tool-replace-case' => 'Tõstutundlik',
	'wikieditor-toolbar-tool-replace-regex' => 'Pea otsisõnet regulaaravaldiseks',
	'wikieditor-toolbar-tool-replace-button-findnext' => 'Otsi järgmine',
	'wikieditor-toolbar-tool-replace-button-replace' => 'Asenda',
	'wikieditor-toolbar-tool-replace-button-replaceall' => 'Asenda kõik',
	'wikieditor-toolbar-tool-replace-close' => 'Sulge',
	'wikieditor-toolbar-tool-replace-nomatch' => 'Ühtegi otsitavat ei leitud.',
	'wikieditor-toolbar-tool-replace-success' => '$1 asendus(t) tehtud.',
	'wikieditor-toolbar-tool-replace-emptysearch' => 'Otsitav on sisestamata.',
	'wikieditor-toolbar-tool-replace-invalidregex' => 'Sisestatud regulaaravaldis on vigane: $1',
	'wikieditor-toolbar-section-characters' => 'Erimärgid',
	'wikieditor-toolbar-characters-page-latin' => 'Ladina',
	'wikieditor-toolbar-characters-page-latinextended' => 'Ladina (laiendatud)',
	'wikieditor-toolbar-characters-page-ipa' => 'IPA-laiendid',
	'wikieditor-toolbar-characters-page-symbols' => 'Sümbolid',
	'wikieditor-toolbar-characters-page-greek' => 'Kreeka',
	'wikieditor-toolbar-characters-page-cyrillic' => 'Kirillitsa',
	'wikieditor-toolbar-characters-page-arabic' => 'Araabia',
	'wikieditor-toolbar-characters-page-arabicextended' => 'Araabia (laiendatud)',
	'wikieditor-toolbar-characters-page-persian' => 'Pärsia',
	'wikieditor-toolbar-characters-page-hebrew' => 'Heebrea',
	'wikieditor-toolbar-characters-page-bangla' => 'Bengali',
	'wikieditor-toolbar-characters-page-tamil' => 'Tamili',
	'wikieditor-toolbar-characters-page-telugu' => 'Telugu',
	'wikieditor-toolbar-characters-page-sinhala' => 'Singali',
	'wikieditor-toolbar-characters-page-gujarati' => 'Gudžarati',
	'wikieditor-toolbar-characters-page-devanagari' => 'Devanaagari',
	'wikieditor-toolbar-characters-page-thai' => 'Tai',
	'wikieditor-toolbar-characters-page-lao' => 'Lao',
	'wikieditor-toolbar-characters-page-khmer' => 'Khmeeri',
	'wikieditor-toolbar-section-help' => 'Abi',
	'wikieditor-toolbar-help-heading-description' => 'Kirjeldus',
	'wikieditor-toolbar-help-heading-syntax' => 'Trükitu',
	'wikieditor-toolbar-help-heading-result' => 'Tulemus',
	'wikieditor-toolbar-help-page-format' => 'Vorming',
	'wikieditor-toolbar-help-page-link' => 'Lingid',
	'wikieditor-toolbar-help-page-heading' => 'Pealkirjad',
	'wikieditor-toolbar-help-page-list' => 'Loendid',
	'wikieditor-toolbar-help-page-file' => 'Failid',
	'wikieditor-toolbar-help-page-reference' => 'Viited',
	'wikieditor-toolbar-help-page-discussion' => 'Arutelu',
	'wikieditor-toolbar-help-content-italic-description' => 'Kaldkiri',
	'wikieditor-toolbar-help-content-italic-syntax' => "''Kaldkirjas tekst''",
	'wikieditor-toolbar-help-content-italic-result' => '<em>Kaldkirjas tekst</em>',
	'wikieditor-toolbar-help-content-bold-description' => 'Rasvane',
	'wikieditor-toolbar-help-content-bold-syntax' => "'''Rasvane tekst'''",
	'wikieditor-toolbar-help-content-bold-result' => '<strong>Rasvane tekst</strong>',
	'wikieditor-toolbar-help-content-bolditalic-description' => 'Rasvane kaldkiri',
	'wikieditor-toolbar-help-content-bolditalic-syntax' => "'''''Rasvane kaldkirjas tekst'''''",
	'wikieditor-toolbar-help-content-bolditalic-result' => '<strong><em>Rasvane kaldkirjas tekst</em></strong>',
	'wikieditor-toolbar-help-content-ilink-description' => 'Siselink',
	'wikieditor-toolbar-help-content-ilink-syntax' => '[[Lehekülje pealkiri|Lingi silt]]<br />[[Lehekülje pealkiri]]',
	'wikieditor-toolbar-help-content-ilink-result' => "<a href='#'>Lingi silt</a><br /><a href='#'>Lehekülje pealkiri</a>",
	'wikieditor-toolbar-help-content-xlink-description' => 'Välislink',
	'wikieditor-toolbar-help-content-xlink-syntax' => '[http://www.näide.ee Lingi silt]<br />[http://www.näide.ee]<br />http://www.näide.ee',
	'wikieditor-toolbar-help-content-xlink-result' => "<a href='#' class='external'>Lingi silt</a><br /><a href='#' class='external autonumber'>[1]</a><br /><a href='#' class='external'>http://www.näide.ee</a>",
	'wikieditor-toolbar-help-content-heading2-description' => '2. taseme pealkiri',
	'wikieditor-toolbar-help-content-heading2-syntax' => '==Pealkirjatekst==',
	'wikieditor-toolbar-help-content-heading2-result' => '<h2>Pealkirjatekst</h2>',
	'wikieditor-toolbar-help-content-heading3-description' => '3. taseme pealkiri',
	'wikieditor-toolbar-help-content-heading3-syntax' => '===Pealkirjatekst===',
	'wikieditor-toolbar-help-content-heading3-result' => '<h3>Pealkirjatekst</h3>',
	'wikieditor-toolbar-help-content-heading4-description' => '4. taseme pealkiri',
	'wikieditor-toolbar-help-content-heading4-syntax' => '==== Pealkirjatekst ====',
	'wikieditor-toolbar-help-content-heading4-result' => '<h4>Pealkirjatekst</h4>',
	'wikieditor-toolbar-help-content-heading5-description' => '5. taseme pealkiri',
	'wikieditor-toolbar-help-content-heading5-syntax' => '===== Pealkirjatekst =====',
	'wikieditor-toolbar-help-content-heading5-result' => '<h5>Pealkirjatekst</h5>',
	'wikieditor-toolbar-help-content-ulist-description' => 'Täpploend',
	'wikieditor-toolbar-help-content-ulist-syntax' => '* Loendi liige<br />* Loendi liige',
	'wikieditor-toolbar-help-content-ulist-result' => '<ul><li>Loendi liige</li><li>Loendi liige</li></ul>',
	'wikieditor-toolbar-help-content-olist-description' => 'Numberloend',
	'wikieditor-toolbar-help-content-olist-syntax' => '# Loendi liige<br /># Loendi liige',
	'wikieditor-toolbar-help-content-olist-result' => '<ol><li>Loendi liige</li><li>Loendi liige</li></ol>',
	'wikieditor-toolbar-help-content-file-description' => 'Manusfail',
	'wikieditor-toolbar-help-content-file-syntax' => '[[$1:Näide.png|thumb|Pildiallkiri]]',
	'wikieditor-toolbar-help-content-file-result' => "<div style='width:104px;' class='thumbinner'><a title='Pildiallkiri' class='image' href='#'><img height='50' width='100' border='0' class='thumbimage' src='$2/WikiEditor/modules/images/toolbar/example-image.png' alt=''/></a><div class='thumbcaption'><div class='magnify'><a title='Suurenda' class='internal' href='#'><img height='11' width='15' alt='' src='$1/common/images/magnify-clip.png'/></a></div>Pildiallkiri</div></div>",
	'wikieditor-toolbar-help-content-reference-description' => 'Viide',
	'wikieditor-toolbar-help-content-reference-syntax' => 'Lehekülje tekst.&lt;ref name="test"&gt;[http://www.näide.ee Lingi tekst], täiendav tekst.&lt;/ref&gt;',
	'wikieditor-toolbar-help-content-reference-result' => "Lehekülje tekst.<sup><a href='#'>[1]</a></sup>",
	'wikieditor-toolbar-help-content-rereference-description' => 'Sama viite mitmekordne kasutamine',
	'wikieditor-toolbar-help-content-rereference-syntax' => 'Lehekülje tekst.&lt;ref name="test" /&gt;',
	'wikieditor-toolbar-help-content-rereference-result' => "Lehekülje tekst.<sup><a href='#'>[1]</a></sup>",
	'wikieditor-toolbar-help-content-showreferences-description' => 'Viidete kuvamine',
	'wikieditor-toolbar-help-content-showreferences-result' => "<ol class='references'><li id='cite_note-test-0'><b><a title='' href='#'>^</a></b> <a rel='nofollow' title='http://www.näide.ee' class='external text' href='#'>Lingi tekst</a>, täiendav tekst.</li></ol>",
	'wikieditor-toolbar-help-content-signaturetimestamp-description' => 'Allkiri ja ajatempel',
	'wikieditor-toolbar-help-content-signaturetimestamp-result' => "<a href='#' title='{{#special:mypage}}'>Kasutajanimi</a> 10. juuni 2009, kell 15:54 (UTC)",
	'wikieditor-toolbar-help-content-signature-description' => 'Allkiri',
	'wikieditor-toolbar-help-content-signature-result' => "<a href='#' title='{{#special:mypage}}'>Kasutajanimi</a>",
	'wikieditor-toolbar-help-content-indent-description' => 'Taane',
	'wikieditor-toolbar-help-content-indent-syntax' => 'Harilik tekst<br />:Taandega tekst<br />::Taandega tekst',
	'wikieditor-toolbar-help-content-indent-result' => 'Harilik tekst<dl><dd>Taandega tekst<dl><dd>Taandega tekst</dd></dl></dd></dl>',
);

/** Basque (euskara)
 * @author An13sa
 * @author Inorbez
 * @author Joxemai
 * @author Xabier Armendaritz
 * @author පසිඳු කාවින්ද
 */
$messages['eu'] = array(
	'wikieditor' => 'Wikitestu edizio-interfaze aurreratua',
	'wikieditor-desc' => 'Wikitestua editatzeko interfazea eta ezaugarri berriak ematen ditu',
	'wikieditor-wikitext-tab' => 'Wikitestua',
	'wikieditor-loading' => 'Kargatzen',
	'wikieditor-preview-preference' => 'Aldetik aldeko aurrikuspena gaitu',
	'wikieditor-preview-tab' => 'Aurreikuspena',
	'wikieditor-preview-changes-tab' => 'Aldaketak',
	'wikieditor-preview-loading' => 'Kargatzen...',
	'wikieditor-previewDialog-preference' => 'Aurrikuspen kutxa gaitu',
	'wikieditor-previewDialog-tab' => 'Aurreikuspena',
	'wikieditor-previewDialog-loading' => 'Kargatzen...',
	'wikieditor-publish-preference' => 'Pausoz pausoko argitarapena ahalbideratu',
	'wikieditor-publish-button-publish' => 'Argitaratu',
	'wikieditor-publish-button-cancel' => 'Utzi',
	'wikieditor-publish-dialog-title' => '{{SITENAME}}era argitaratu',
	'wikieditor-publish-dialog-summary' => 'Laburpena (Egindako aldaketak laburki azaldu):',
	'wikieditor-publish-dialog-minor' => 'Aldaketa txikia',
	'wikieditor-publish-dialog-watch' => 'Orrialde hau jarraitu',
	'wikieditor-publish-dialog-publish' => 'Argitaratu',
	'wikieditor-publish-dialog-goback' => 'Atzera joan',
	'wikieditor-template-editor-preference' => 'Forman oinarritutako wiki txantiloien edizioa gaitu',
	'wikieditor-template-editor-dialog-title' => 'Txantiloia aldatu',
	'wikieditor-template-editor-dialog-submit' => 'Eguneratu',
	'wikieditor-template-editor-dialog-cancel' => 'Utzi',
	'wikieditor-templates-preference' => 'Txantiloien ixtea eta irekitzea gaitu',
	'wikieditor-toc-preference' => 'Eduki-taula nabigagarria gaitu',
	'wikieditor-toc-show' => 'Edukiak erakutsi',
	'wikieditor-toc-hide' => 'Edukiak ezkutatu',
	'wikieditor-toolbar' => 'Tresna-barra aldatzen',
	'wikieditor-toolbar-desc' => 'Orrialdeko editatzeko barra aldatu era erabilgarritasun hobetuarekin',
	'wikieditor-toolbar-preference' => 'Editatzeko tresna barra hobetua gaitu',
	'wikieditor-toolbar-dialogs-preference' => 'Elkarrizketa kutxak gaitu loturak, taula eta bestelakoak sartzeko',
	'wikieditor-toolbar-loading' => 'Kargatzen...',
	'wikieditor-toolbar-tool-bold' => 'Beltza',
	'wikieditor-toolbar-tool-bold-example' => 'Testu beltza',
	'wikieditor-toolbar-tool-italic' => 'Etzana',
	'wikieditor-toolbar-tool-italic-example' => 'Testu etzana',
	'wikieditor-toolbar-tool-ilink' => 'Barne lotura',
	'wikieditor-toolbar-tool-ilink-example' => 'Loturaren izenburua',
	'wikieditor-toolbar-tool-xlink' => 'Kanpo lotura (gogoratu http:// aurrizkia)',
	'wikieditor-toolbar-tool-xlink-example' => 'http://www.adibidea.com loturaren izenburua',
	'wikieditor-toolbar-tool-link' => 'Lotura',
	'wikieditor-toolbar-tool-link-title' => 'Sartu lotura',
	'wikieditor-toolbar-tool-link-int' => 'Wiki orrialde batera',
	'wikieditor-toolbar-tool-link-int-target' => 'Orrialdearen izenburua:',
	'wikieditor-toolbar-tool-link-int-target-tooltip' => 'Orriaren izenburua edo URL',
	'wikieditor-toolbar-tool-link-int-text' => 'Lotutako testua:',
	'wikieditor-toolbar-tool-link-int-text-tooltip' => 'Idatzi erakutsi beharreko testua',
	'wikieditor-toolbar-tool-link-ext' => 'Kanpoko orrialde batera',
	'wikieditor-toolbar-tool-link-ext-target' => 'Lotura URLa:',
	'wikieditor-toolbar-tool-link-ext-text' => 'Lotura testua:',
	'wikieditor-toolbar-tool-link-insert' => 'Lotura txertatu',
	'wikieditor-toolbar-tool-link-cancel' => 'Utzi',
	'wikieditor-toolbar-tool-link-int-target-status-exists' => 'Orrialdea existitzen da',
	'wikieditor-toolbar-tool-link-int-target-status-notexists' => 'Orrialdea ez da existitzen',
	'wikieditor-toolbar-tool-link-int-target-status-invalid' => 'Balio gabeko izenburua',
	'wikieditor-toolbar-tool-link-int-target-status-external' => 'Kanpo lotura',
	'wikieditor-toolbar-tool-link-int-target-status-loading' => 'Orriaren existentzia egiaztatzen...',
	'wikieditor-toolbar-tool-link-int-invalid' => 'Zehaztutako izenburua ez dago zuzen.',
	'wikieditor-toolbar-tool-link-lookslikeinternal' => 'Adierazi duzun URL beste wiki orri batera lotzen duela dirudi.
Barne lotura bezala sortu nahi duzu?',
	'wikieditor-toolbar-tool-link-lookslikeinternal-int' => 'Barne lotura',
	'wikieditor-toolbar-tool-link-lookslikeinternal-ext' => 'Kanpo lotura',
	'wikieditor-toolbar-tool-link-empty' => 'Ez duzu bilatu beharreko ezer adierazi.',
	'wikieditor-toolbar-tool-file' => 'Fitxategia txertatu',
	'wikieditor-toolbar-tool-file-example' => 'Adibidea.jpg',
	'wikieditor-toolbar-file-size' => 'Tamaina:',
	'wikieditor-toolbar-file-format' => 'Formatua:',
	'wikieditor-toolbar-tool-file-insert' => 'Txertatu',
	'wikieditor-toolbar-tool-file-cancel' => 'Utzi',
	'wikieditor-toolbar-tool-reference' => 'Erreferentzia',
	'wikieditor-toolbar-tool-reference-example' => 'Txertatu testu oina hemen',
	'wikieditor-toolbar-tool-reference-cancel' => 'Utzi',
	'wikieditor-toolbar-tool-reference-title' => 'Txertatu erreferentzia',
	'wikieditor-toolbar-tool-reference-insert' => 'Txertatu',
	'wikieditor-toolbar-tool-reference-text' => 'Erreferentzia-testua',
	'wikieditor-toolbar-tool-signature' => 'Sinadura, eguna eta ordua',
	'wikieditor-toolbar-section-advanced' => 'Aurreratua',
	'wikieditor-toolbar-tool-heading' => 'Izenburua',
	'wikieditor-toolbar-tool-heading-1' => '1. maila',
	'wikieditor-toolbar-tool-heading-2' => '2. maila',
	'wikieditor-toolbar-tool-heading-3' => '3. maila',
	'wikieditor-toolbar-tool-heading-4' => '4. maila',
	'wikieditor-toolbar-tool-heading-5' => '5. maila',
	'wikieditor-toolbar-tool-heading-example' => '&#32;Izenburuaren testua&#32;',
	'wikieditor-toolbar-group-format' => 'Formatua',
	'wikieditor-toolbar-tool-ulist' => 'Puntudun zerrenda',
	'wikieditor-toolbar-tool-ulist-example' => 'Puntudun zerrendako elementua',
	'wikieditor-toolbar-tool-olist' => 'Zenbakidun zerrenda',
	'wikieditor-toolbar-tool-olist-example' => 'Zenbakidun zerrendako elementua',
	'wikieditor-toolbar-tool-indent' => 'Koska',
	'wikieditor-toolbar-tool-indent-example' => 'Koskadun lerroa',
	'wikieditor-toolbar-tool-nowiki' => 'Ez egin jaramonik wiki formatuari',
	'wikieditor-toolbar-tool-nowiki-example' => 'Formatu gabeko testua hemen idatzi',
	'wikieditor-toolbar-tool-redirect' => 'Birzuzenketa',
	'wikieditor-toolbar-tool-redirect-example' => 'Bilatzen den orriaren izena',
	'wikieditor-toolbar-tool-big' => 'Handia',
	'wikieditor-toolbar-tool-big-example' => 'Testu handia',
	'wikieditor-toolbar-tool-small' => 'Txikia',
	'wikieditor-toolbar-tool-small-example' => 'Testu txikia',
	'wikieditor-toolbar-tool-superscript' => 'Goi-indizea',
	'wikieditor-toolbar-tool-superscript-example' => 'Goi-indizearen testua',
	'wikieditor-toolbar-tool-subscript' => 'Azpiindizea',
	'wikieditor-toolbar-tool-subscript-example' => 'Azpiindizearen testua',
	'wikieditor-toolbar-group-insert' => 'Txertatu',
	'wikieditor-toolbar-tool-gallery' => 'Irudi galeria',
	'wikieditor-toolbar-tool-gallery-example' => '$1:Adibidea.jpg|Oina1
$1:Adibidea.jpg|Oina2',
	'wikieditor-toolbar-tool-newline' => 'Lerro berria',
	'wikieditor-toolbar-tool-table' => 'Taula',
	'wikieditor-toolbar-tool-table-example-old' => '-
! goiburua 1
! goiburua 2
! goiburua 3
|-
| errenkada 1, gela 1
| errenkada 1, gela 2
| errenkada 1, gela 3
|-
| errenkada 2, gela 1
| errenkada 2, gela 2
| errenkada 2, gela 3',
	'wikieditor-toolbar-tool-table-example-cell-text' => 'Gelatxo testua',
	'wikieditor-toolbar-tool-table-example-header' => 'Goiburu testua',
	'wikieditor-toolbar-tool-table-title' => 'Taula txertatu',
	'wikieditor-toolbar-tool-table-dimensions-rows' => 'Errenkadak',
	'wikieditor-toolbar-tool-table-dimensions-columns' => 'Zutabeak',
	'wikieditor-toolbar-tool-table-dimensions-header' => 'Goiburu errendaka txertatu',
	'wikieditor-toolbar-tool-table-wikitable' => 'Estiloa ertzekin',
	'wikieditor-toolbar-tool-table-sortable' => 'Egin taula sailkagarri',
	'wikieditor-toolbar-tool-table-example' => 'Gelatxo testua',
	'wikieditor-toolbar-tool-table-preview' => 'Aurreikuspena',
	'wikieditor-toolbar-tool-table-insert' => 'Txertatu',
	'wikieditor-toolbar-tool-table-cancel' => 'Utzi',
	'wikieditor-toolbar-tool-table-toomany' => 'Elkarrizketa-kutxa honekin ezinezkoa da $1 zutabe baino gehiago dituen taula txertatzea',
	'wikieditor-toolbar-tool-table-invalidnumber' => 'Ez duzu idatzi errenkada edo zutabe-kopuru zuzen bat.',
	'wikieditor-toolbar-tool-table-zero' => 'Ezin duzu 0 errenkada edo zutabe duen taularik txertatu.',
	'wikieditor-toolbar-tool-replace' => 'Bilatu eta ordezkatu',
	'wikieditor-toolbar-tool-replace-title' => 'Bilatu eta aldatu',
	'wikieditor-toolbar-tool-replace-search' => 'Bilatu hau:',
	'wikieditor-toolbar-tool-replace-replace' => 'Honegatik aldatu:',
	'wikieditor-toolbar-tool-replace-case' => 'Bilaketa zehatza',
	'wikieditor-toolbar-tool-replace-regex' => 'Bilaketa hitzak espresio erregular gisa tratatu',
	'wikieditor-toolbar-tool-replace-button-findnext' => 'Hurrengoa bilatu',
	'wikieditor-toolbar-tool-replace-button-replace' => 'Ordezkatu',
	'wikieditor-toolbar-tool-replace-button-replaceall' => 'Denak ordezkatu',
	'wikieditor-toolbar-tool-replace-close' => 'Itxi',
	'wikieditor-toolbar-tool-replace-nomatch' => 'Ez dago bilaketarekin bat egiten duten emaitzarik.',
	'wikieditor-toolbar-tool-replace-success' => '$1 ordezkapen eginda.',
	'wikieditor-toolbar-tool-replace-emptysearch' => 'Ez duzu bilatu beharreko ezer adierazi.',
	'wikieditor-toolbar-tool-replace-invalidregex' => 'Txertatu duzun adierazpen erregularra ez da zzuena:  $1',
	'wikieditor-toolbar-section-characters' => 'Karaktere bereziak',
	'wikieditor-toolbar-characters-page-latin' => 'Latina',
	'wikieditor-toolbar-characters-page-latinextended' => 'Latin hedatua',
	'wikieditor-toolbar-characters-page-ipa' => 'NAF',
	'wikieditor-toolbar-characters-page-symbols' => 'Ikurrak',
	'wikieditor-toolbar-characters-page-greek' => 'Greziera',
	'wikieditor-toolbar-characters-page-cyrillic' => 'Zirilikoa',
	'wikieditor-toolbar-characters-page-arabic' => 'Arabiera',
	'wikieditor-toolbar-characters-page-persian' => 'Persiera',
	'wikieditor-toolbar-characters-page-hebrew' => 'Hebreera',
	'wikieditor-toolbar-characters-page-bangla' => 'Bangla',
	'wikieditor-toolbar-characters-page-telugu' => 'Telugu',
	'wikieditor-toolbar-characters-page-sinhala' => 'Sinhala',
	'wikieditor-toolbar-characters-page-gujarati' => 'Guajarati',
	'wikieditor-toolbar-characters-page-thai' => 'Thaiera',
	'wikieditor-toolbar-characters-page-lao' => 'Laosera',
	'wikieditor-toolbar-characters-page-khmer' => 'Khmerrera',
	'wikieditor-toolbar-section-help' => 'Laguntza',
	'wikieditor-toolbar-help-heading-description' => 'Deskribapena',
	'wikieditor-toolbar-help-heading-syntax' => 'Idazten duzuna',
	'wikieditor-toolbar-help-heading-result' => 'Lortzen duzuna',
	'wikieditor-toolbar-help-page-format' => 'Formatua ematen',
	'wikieditor-toolbar-help-page-link' => 'Loturak',
	'wikieditor-toolbar-help-page-heading' => 'Goiburuak',
	'wikieditor-toolbar-help-page-list' => 'Zerrendak',
	'wikieditor-toolbar-help-page-file' => 'Fitxategiak',
	'wikieditor-toolbar-help-page-reference' => 'Erreferentziak',
	'wikieditor-toolbar-help-page-discussion' => 'Eztabaida',
	'wikieditor-toolbar-help-content-italic-description' => 'Etzana',
	'wikieditor-toolbar-help-content-italic-syntax' => "''Testu etzana''",
	'wikieditor-toolbar-help-content-italic-result' => '<em>Testu etzana</em>',
	'wikieditor-toolbar-help-content-bold-description' => 'Beltza',
	'wikieditor-toolbar-help-content-bold-syntax' => "'''Testu beltza'''",
	'wikieditor-toolbar-help-content-bold-result' => '<strong>Testu beltza</strong>',
	'wikieditor-toolbar-help-content-bolditalic-description' => 'Beltza eta etzana',
	'wikieditor-toolbar-help-content-bolditalic-syntax' => "'''''Testu beltza eta etzana'''''",
	'wikieditor-toolbar-help-content-bolditalic-result' => '<strong><em>Testu beltza eta etzana</em></strong>',
	'wikieditor-toolbar-help-content-ilink-description' => 'Barne lotura',
	'wikieditor-toolbar-help-content-ilink-syntax' => '[[Orriaren titulua|Loturaren izena]]<br />[[Orriaren titulua]]',
	'wikieditor-toolbar-help-content-ilink-result' => "<a href='#'>Loturaren izena</a><br /><a href='#'>Orriaren titulua</a>",
	'wikieditor-toolbar-help-content-xlink-description' => 'Kanpo lotura',
	'wikieditor-toolbar-help-content-xlink-syntax' => '[http://www.adibidea.org Loturaren izena]<br />[http://www.adibidea.org]<br />http://www.adibidea.org',
	'wikieditor-toolbar-help-content-xlink-result' => "<a href='#' class='external'>Loturaren izena</a><br /><a href='#' class='external autonumber'>[1]</a><br /><a href='#' class='external'>http://www.adibidea.org</a>",
	'wikieditor-toolbar-help-content-heading2-description' => '2. mailako goiburua',
	'wikieditor-toolbar-help-content-heading2-syntax' => '== Izenburuaren testua ==',
	'wikieditor-toolbar-help-content-heading2-result' => '<h2>Izenburuaren testua</h2>',
	'wikieditor-toolbar-help-content-heading3-description' => '3. mailako izenburua',
	'wikieditor-toolbar-help-content-heading3-syntax' => '=== Izenburuaren testua ===',
	'wikieditor-toolbar-help-content-heading3-result' => '<h3>Izenburuaren testua</h3>',
	'wikieditor-toolbar-help-content-heading4-description' => '4. mailako izenburua',
	'wikieditor-toolbar-help-content-heading4-syntax' => '==== Izenburuaren testua ====',
	'wikieditor-toolbar-help-content-heading4-result' => '<h4>Izenburuaren testua</h4>',
	'wikieditor-toolbar-help-content-heading5-description' => '5. mailako izenburua',
	'wikieditor-toolbar-help-content-heading5-syntax' => '===== Izenburuaren testua =====',
	'wikieditor-toolbar-help-content-heading5-result' => '<h5>Izenburuaren testua</h5>',
	'wikieditor-toolbar-help-content-ulist-description' => 'Puntudun zerrenda',
	'wikieditor-toolbar-help-content-ulist-syntax' => '* Zerrendako elementua<br />* Zerrendako elementua',
	'wikieditor-toolbar-help-content-ulist-result' => '<ul><li>Zerrendako elementua</li><li>Zerrendako elementua</li></ul>',
	'wikieditor-toolbar-help-content-olist-description' => 'Zenbakidun zerrenda',
	'wikieditor-toolbar-help-content-olist-syntax' => '# Zerrendako elementua<br /># Zerrendako elementua',
	'wikieditor-toolbar-help-content-olist-result' => '<ol><li>Zerrendako elementua</li><li>Zerrendako elementua</li></ol>',
	'wikieditor-toolbar-help-content-file-description' => 'Fitxategia txertatu',
	'wikieditor-toolbar-help-content-file-syntax' => '[[$1:Adibidea.png|thumb|Irudi oina]]',
	'wikieditor-toolbar-help-content-file-result' => "<div style='width:104px;' class='thumbinner'><a title='Irudiaren testua' class='image' href='#'><img height='50' width='100' border='0' class='thumbimage' src='$2/WikiEditor/modules/images/toolbar/example-image.png' alt=''/></a><div class='thumbcaption'><div class='magnify'><a title='Handitu' class='internal' href='#'><img height='11' width='15' alt='' src='$1/common/images/magnify-clip.png'/></a></div>Irudi oina</div></div>",
	'wikieditor-toolbar-help-content-reference-description' => 'Erreferentzia',
	'wikieditor-toolbar-help-content-reference-syntax' => 'Orrialdearen testua.&lt;ref name="proba"&gt;[http://www.adibidea.org Loturaren testua], testu gehigarria.&lt;/ref&gt;',
	'wikieditor-toolbar-help-content-reference-result' => "Orrialdearen testua.<sup><a href='#'>[1]</a></sup>",
	'wikieditor-toolbar-help-content-rereference-description' => 'Erreferentzia beraren erabilera gehiago',
	'wikieditor-toolbar-help-content-rereference-result' => "Orrialdearen testua.<sup><a href='#'>[1]</a></sup>",
	'wikieditor-toolbar-help-content-showreferences-description' => 'Erreferentziak erakutsi',
	'wikieditor-toolbar-help-content-showreferences-result' => "<ol class='references'><li id='cite_note-test-0'><b><a title='' href='#'>^</a></b> <a rel='nofollow' title='http://www.adibidea.org' class='external text' href='#'>Loturaren testua</a>, testu gehigarria.</li></ol>",
	'wikieditor-toolbar-help-content-signaturetimestamp-description' => 'Sindaura, eguna eta ordua',
	'wikieditor-toolbar-help-content-signaturetimestamp-result' => "<a href='#' title='{{#special:mypage}}'>Lankide izena</a> (<a href='#' title='{{#special:mytalk}}'>eztabaida</a>) 2009-06-10, 15:54 (UTC)",
	'wikieditor-toolbar-help-content-signature-description' => 'Sinadura',
	'wikieditor-toolbar-help-content-signature-result' => "<a href='#' title='{{#special:mypage}}'>Lankide izena</a> (<a href='#' title='{{#special:mytalk}}'>eztabaida</a>)",
	'wikieditor-toolbar-help-content-indent-description' => 'Koska',
	'wikieditor-toolbar-help-content-indent-syntax' => 'Testu normala<br />: Koskatutako testua<br />:: Koskatutako testua',
	'wikieditor-toolbar-help-content-indent-result' => 'Testu arrunta<dl><dd>Koskatutako testua<dl><dd>Koskatutako testua</dd></dl></dd></dl>',
);

/** Persian (فارسی)
 * @author Ebraminio
 * @author Huji
 * @author Ladsgroup
 * @author Mjbmr
 * @author Reza1615
 * @author Wayiran
 * @author ZxxZxxZ
 */
$messages['fa'] = array(
	'wikieditor' => 'رابط ویرایش پیشرفته ویکی‌متن',
	'wikieditor-desc' => 'یک رابط ویرایش پیشرفته ویکی‌متن و چندین پودمان دارای قابلیت فراهم می‌کند',
	'wikieditor-wikitext-tab' => 'ویکی‌متن',
	'wikieditor-loading' => 'در حال بارگیری',
	'wikieditor-preview-preference' => 'فعال‌سازی پیش‌نمایش کنار یک دیگر',
	'wikieditor-preview-tab' => 'پیش‌نمایش',
	'wikieditor-preview-changes-tab' => 'تغییرها',
	'wikieditor-preview-loading' => 'در حال بارگیری...',
	'wikieditor-previewDialog-preference' => 'فعال کردن پنجره‌های تعاملی پیش‌نمایش',
	'wikieditor-previewDialog-tab' => 'پیش‌نمایش',
	'wikieditor-previewDialog-loading' => 'در حال بارگیری...',
	'wikieditor-publish-preference' => 'فعال‌سازی انتشار گام‌به‌گام',
	'wikieditor-publish-button-publish' => 'انتشار',
	'wikieditor-publish-button-cancel' => 'لغو',
	'wikieditor-publish-dialog-title' => 'انتشار در {{SITENAME}}',
	'wikieditor-publish-dialog-summary' => 'خلاصه ویرایش (توضیح مختصر در مورد تغییری که دادید):',
	'wikieditor-publish-dialog-minor' => 'ویرایش جزئی',
	'wikieditor-publish-dialog-watch' => 'پی‌گیری این صفحه',
	'wikieditor-publish-dialog-publish' => 'انتشار',
	'wikieditor-publish-dialog-goback' => 'بازگشت به عقب',
	'wikieditor-template-editor-preference' => 'فعال‌سازی ویرایش مبتنی بر فرم الگوهای ویکی',
	'wikieditor-template-editor-dialog-title' => 'ویرایش الگو',
	'wikieditor-template-editor-dialog-submit' => 'به‌روزرسانی',
	'wikieditor-template-editor-dialog-cancel' => 'لغو',
	'wikieditor-templates-preference' => 'فعال‌سازی نهفتن الگوها',
	'wikieditor-toc-preference' => 'فعال‌سازی فهرست مطالب قابل پیمایش',
	'wikieditor-toc-show' => 'نمایش محتوا',
	'wikieditor-toc-hide' => 'نهفتن محتوا',
	'wikieditor-toolbar' => 'نوار ابزار ویرایش',
	'wikieditor-toolbar-desc' => 'نوار ابزار ویرایش صفحه با استفاده‌پذیری بالاتر',
	'wikieditor-toolbar-preference' => 'فعال‌کردن نوارابزار ویرایش پیشرفته',
	'wikieditor-toolbar-dialogs-preference' => 'فعال‌سازی پنجره‌های تعاملی برای وارد کردن پیوندها، جدول‌ها و غیره',
	'wikieditor-toolbar-hidesig' => 'نهفتن دکمهٔ امضا از صفحه‌های فضای نام اصلی',
	'wikieditor-toolbar-loading' => 'در حال بارگیری...',
	'wikieditor-toolbar-tool-bold' => 'پررنگ',
	'wikieditor-toolbar-tool-bold-example' => 'متن پررنگ',
	'wikieditor-toolbar-tool-italic' => 'مورب',
	'wikieditor-toolbar-tool-italic-example' => 'متن مورب',
	'wikieditor-toolbar-tool-ilink' => 'پیوند داخلی',
	'wikieditor-toolbar-tool-ilink-example' => 'عنوان پیوند',
	'wikieditor-toolbar-tool-xlink' => 'پیوند به بیرون (پیشوند http:// فراموش نشود)',
	'wikieditor-toolbar-tool-xlink-example' => 'http://www.example.com عنوان پیوند',
	'wikieditor-toolbar-tool-link' => 'پیوند',
	'wikieditor-toolbar-tool-link-title' => 'افزودن پیوند',
	'wikieditor-toolbar-tool-link-int' => 'به یک صفحهٔ ویکی',
	'wikieditor-toolbar-tool-link-int-target' => 'صفحهٔ هدف یا نشانی اینترنتی:',
	'wikieditor-toolbar-tool-link-int-target-tooltip' => 'عنوان صفحه یا نشانی اینترنتی',
	'wikieditor-toolbar-tool-link-int-text' => 'متن برای نمایش:',
	'wikieditor-toolbar-tool-link-int-text-tooltip' => 'متنی که نمایش می‌یابد',
	'wikieditor-toolbar-tool-link-ext' => 'به یک صفحهٔ وب خارج از ویکی',
	'wikieditor-toolbar-tool-link-ext-target' => 'نشانی اینترنتی پیوند:',
	'wikieditor-toolbar-tool-link-ext-text' => 'متن پیوند:',
	'wikieditor-toolbar-tool-link-insert' => 'افزودن پیوند',
	'wikieditor-toolbar-tool-link-cancel' => 'لغو',
	'wikieditor-toolbar-tool-link-int-target-status-exists' => 'صفحه وجود دارد',
	'wikieditor-toolbar-tool-link-int-target-status-notexists' => 'صفحه وجود ندارد',
	'wikieditor-toolbar-tool-link-int-target-status-invalid' => 'عنوان نادرست',
	'wikieditor-toolbar-tool-link-int-target-status-external' => 'پیوند به بیرون',
	'wikieditor-toolbar-tool-link-int-target-status-loading' => 'بررسی وجود داشتن صفحه...',
	'wikieditor-toolbar-tool-link-int-invalid' => 'عنوان تعیین‌شده نامعتبر است.',
	'wikieditor-toolbar-tool-link-lookslikeinternal' => 'نشانی اینترنتی که وارد کردید به شکلی است که نمایانگر یک پیوند به صفحه‌ای داخل ویکی است. آیا می‌خواهید آن را به یک پیوند داخلی تبدیل کنید؟',
	'wikieditor-toolbar-tool-link-lookslikeinternal-int' => 'پیوند داخلی',
	'wikieditor-toolbar-tool-link-lookslikeinternal-ext' => 'پیوند به بیرون',
	'wikieditor-toolbar-tool-link-empty' => 'شما چیزی برای پیونددادن وارد نکردید.',
	'wikieditor-toolbar-tool-file' => 'پروندهٔ جاسازی‌شده',
	'wikieditor-toolbar-tool-file-example' => 'مثال.jpg',
	'wikieditor-toolbar-tool-file-title' => 'درج پرونده',
	'wikieditor-toolbar-file-target' => 'نام پرونده:',
	'wikieditor-toolbar-file-caption' => 'عنوان:',
	'wikieditor-toolbar-file-size' => 'اندازه:',
	'wikieditor-toolbar-file-float' => 'تراز:',
	'wikieditor-toolbar-file-default' => '(پیش‌فرض)',
	'wikieditor-toolbar-file-format' => 'قالب:',
	'wikieditor-toolbar-tool-file-insert' => 'درج',
	'wikieditor-toolbar-tool-file-cancel' => 'لغو',
	'wikieditor-toolbar-tool-reference' => 'منبع',
	'wikieditor-toolbar-tool-reference-example' => 'متن زیرنویس را اینجا اضافه کنید',
	'wikieditor-toolbar-tool-reference-cancel' => 'لغو',
	'wikieditor-toolbar-tool-reference-title' => 'افزودن منبع',
	'wikieditor-toolbar-tool-reference-insert' => 'افزودن',
	'wikieditor-toolbar-tool-reference-text' => 'متن منبع',
	'wikieditor-toolbar-tool-signature' => 'امضا و برچسب زمان',
	'wikieditor-toolbar-section-advanced' => 'پیشرفته',
	'wikieditor-toolbar-tool-heading' => 'عنوان',
	'wikieditor-toolbar-tool-heading-1' => 'سطح ۱',
	'wikieditor-toolbar-tool-heading-2' => 'سطح ۲',
	'wikieditor-toolbar-tool-heading-3' => 'سطح ۳',
	'wikieditor-toolbar-tool-heading-4' => 'سطح ۴',
	'wikieditor-toolbar-tool-heading-5' => 'سطح ۵',
	'wikieditor-toolbar-tool-heading-example' => 'متن عنوان',
	'wikieditor-toolbar-group-format' => 'قالب',
	'wikieditor-toolbar-tool-ulist' => 'فهرست گلوله‌ای',
	'wikieditor-toolbar-tool-ulist-example' => 'مورد فهرست گلوله‌ای',
	'wikieditor-toolbar-tool-olist' => 'فهرست شماره‌ای',
	'wikieditor-toolbar-tool-olist-example' => 'مورد فهرست شماره‌ای',
	'wikieditor-toolbar-tool-indent' => 'تورفتگی',
	'wikieditor-toolbar-tool-indent-example' => 'خط تورفته',
	'wikieditor-toolbar-tool-nowiki' => 'نادیده‌گرفتن قالب‌بندی ویکی',
	'wikieditor-toolbar-tool-nowiki-example' => 'اینجا متن قالب‌بندی‌نشده وارد شود',
	'wikieditor-toolbar-tool-redirect' => 'تغییرمسیر',
	'wikieditor-toolbar-tool-redirect-example' => 'نام صفحه مقصد',
	'wikieditor-toolbar-tool-big' => 'بزرگ',
	'wikieditor-toolbar-tool-big-example' => 'متن بزرگ',
	'wikieditor-toolbar-tool-small' => 'کوچک',
	'wikieditor-toolbar-tool-small-example' => 'متن کوچک',
	'wikieditor-toolbar-tool-superscript' => 'بالانویس',
	'wikieditor-toolbar-tool-superscript-example' => 'متن بالانویس',
	'wikieditor-toolbar-tool-subscript' => 'زیرنویس',
	'wikieditor-toolbar-tool-subscript-example' => 'متن زیرنویس',
	'wikieditor-toolbar-group-insert' => 'افزودن',
	'wikieditor-toolbar-tool-gallery' => 'نگارخانهٔ تصویر',
	'wikieditor-toolbar-tool-gallery-example' => '$1:مثال.jpg|عنوان ۱
$1:مثال.jpg|عنوان ۲',
	'wikieditor-toolbar-tool-newline' => 'خط جدید',
	'wikieditor-toolbar-tool-table' => 'جدول',
	'wikieditor-toolbar-tool-table-example-old' => '-
! عنوان ۱
! عنوان ۲
! عنوان ۳
|-
| ردیف ۱، خانه ۱
| ردیف ۱، خانه ۲
| ردیف ۱، خانه ۳
|-
| ردیف ۲، خانه ۱
| ردیف ۲، خانه ۲
| ردیف ۲، خانه ۳',
	'wikieditor-toolbar-tool-table-example-cell-text' => 'متن خانه',
	'wikieditor-toolbar-tool-table-example-header' => 'متن عنوان',
	'wikieditor-toolbar-tool-table-title' => 'افزودن جدول',
	'wikieditor-toolbar-tool-table-dimensions-rows' => 'ردیف‌ها',
	'wikieditor-toolbar-tool-table-dimensions-columns' => 'ستون‌ها',
	'wikieditor-toolbar-tool-table-dimensions-header' => 'افزودن ردیف سرتیتر',
	'wikieditor-toolbar-tool-table-wikitable' => 'سبک با لبه',
	'wikieditor-toolbar-tool-table-sortable' => 'ساختن جدول قابل مرتب‌سازی',
	'wikieditor-toolbar-tool-table-example' => 'مثال',
	'wikieditor-toolbar-tool-table-preview' => 'پیش‌نمایش',
	'wikieditor-toolbar-tool-table-insert' => 'افزودن',
	'wikieditor-toolbar-tool-table-cancel' => 'لغو',
	'wikieditor-toolbar-tool-table-toomany' => 'اضافه کردن جدولی با بیش از $1 خانه توسط این ابزار ممکن نیست.',
	'wikieditor-toolbar-tool-table-invalidnumber' => 'شما عدد درستی برای تعداد ردیف‌ها و ستون‌ها وارد نکرده‌اید.',
	'wikieditor-toolbar-tool-table-zero' => 'شما نمی‌توانید جدولی با صفر ردیف یا ستون اضافه کنید.',
	'wikieditor-toolbar-tool-replace' => 'یافتن و جایگزین کردن',
	'wikieditor-toolbar-tool-replace-title' => 'جستجو و جایگزین کردن',
	'wikieditor-toolbar-tool-replace-search' => 'جستجو برای:',
	'wikieditor-toolbar-tool-replace-replace' => 'جایگزین کردن با:',
	'wikieditor-toolbar-tool-replace-case' => 'تطبیق بزرگی و کوچکی حروف',
	'wikieditor-toolbar-tool-replace-regex' => 'به‌کارگیری عبارت جستجو به عنوان یک عبارت باقاعده',
	'wikieditor-toolbar-tool-replace-button-findnext' => 'یافتن بعدی',
	'wikieditor-toolbar-tool-replace-button-replace' => 'جایگزینی',
	'wikieditor-toolbar-tool-replace-button-replaceall' => 'جایگزین کردن همه موارد',
	'wikieditor-toolbar-tool-replace-close' => 'بستن',
	'wikieditor-toolbar-tool-replace-nomatch' => 'جستجوی شما با هیچ موردی مطابقت نداشت.',
	'wikieditor-toolbar-tool-replace-success' => '$1 جایگزینی انجام شد.',
	'wikieditor-toolbar-tool-replace-emptysearch' => 'شما چیزی برای جستجو وارد نکردید.',
	'wikieditor-toolbar-tool-replace-invalidregex' => 'عبارت باقاعده‌ای که وارد کردید مجاز نیست: $1',
	'wikieditor-toolbar-section-characters' => 'نویسه‌های ویژه',
	'wikieditor-toolbar-characters-page-latin' => 'لاتین',
	'wikieditor-toolbar-characters-page-latinextended' => 'لاتین گسترش‌یافته',
	'wikieditor-toolbar-characters-page-ipa' => 'آوانگاری بین‌المللی',
	'wikieditor-toolbar-characters-page-symbols' => 'نمادها',
	'wikieditor-toolbar-characters-page-greek' => 'یونانی',
	'wikieditor-toolbar-characters-page-cyrillic' => 'سیریلیک',
	'wikieditor-toolbar-characters-page-arabic' => 'عربی',
	'wikieditor-toolbar-characters-page-arabicextended' => 'عربی گسترش‌یافته',
	'wikieditor-toolbar-characters-page-persian' => 'فارسی',
	'wikieditor-toolbar-characters-page-hebrew' => 'عبری',
	'wikieditor-toolbar-characters-page-bangla' => 'بنگالی',
	'wikieditor-toolbar-characters-page-tamil' => 'تامیلی',
	'wikieditor-toolbar-characters-page-telugu' => 'تالوگو',
	'wikieditor-toolbar-characters-page-sinhala' => 'سینهالی',
	'wikieditor-toolbar-characters-page-gujarati' => 'گجراتی',
	'wikieditor-toolbar-characters-page-devanagari' => 'دیواناگرى',
	'wikieditor-toolbar-characters-page-thai' => 'تایلندی',
	'wikieditor-toolbar-characters-page-lao' => 'لائو',
	'wikieditor-toolbar-characters-page-khmer' => 'خمر',
	'wikieditor-toolbar-section-help' => 'راهنما',
	'wikieditor-toolbar-help-heading-description' => 'توضیح',
	'wikieditor-toolbar-help-heading-syntax' => 'آن چه می‌نویسید',
	'wikieditor-toolbar-help-heading-result' => 'آن چه به دست می‌آورید',
	'wikieditor-toolbar-help-page-format' => 'قالب‌بندی',
	'wikieditor-toolbar-help-page-link' => 'پیوندها',
	'wikieditor-toolbar-help-page-heading' => 'عنوان‌ها',
	'wikieditor-toolbar-help-page-list' => 'فهرست‌ها',
	'wikieditor-toolbar-help-page-file' => 'پرونده‌ها',
	'wikieditor-toolbar-help-page-reference' => 'منابع',
	'wikieditor-toolbar-help-page-discussion' => 'بحث',
	'wikieditor-toolbar-help-content-italic-description' => 'مورب',
	'wikieditor-toolbar-help-content-italic-syntax' => "''متن مورب''",
	'wikieditor-toolbar-help-content-italic-result' => '<em>متن مورب</em>',
	'wikieditor-toolbar-help-content-bold-description' => 'پررنگ',
	'wikieditor-toolbar-help-content-bold-syntax' => "'''متن پررنگ'''",
	'wikieditor-toolbar-help-content-bold-result' => '<strong>متن پررنگ</strong>',
	'wikieditor-toolbar-help-content-bolditalic-description' => 'پررنگ و مورب',
	'wikieditor-toolbar-help-content-bolditalic-syntax' => "'''''متن پررنگ و مورب'''''",
	'wikieditor-toolbar-help-content-bolditalic-result' => '<strong><em>متن پررنگ و مورب</em></strong>',
	'wikieditor-toolbar-help-content-ilink-description' => 'پیوند داخلی',
	'wikieditor-toolbar-help-content-ilink-syntax' => '[[عنوان صفحه|عنوان پیوند]]<br />[[عنوان صفحه]]',
	'wikieditor-toolbar-help-content-ilink-result' => "<a href='#'>عنوان پیوند</a><br /><a href='#'>عنوان صفحه</a>",
	'wikieditor-toolbar-help-content-xlink-description' => 'پیوند به بیرون',
	'wikieditor-toolbar-help-content-xlink-syntax' => '[http://www.example.org عنوان پیوند]<br />[http://www.example.org]<br />http://www.example.org',
	'wikieditor-toolbar-help-content-xlink-result' => "<a href='#' class='external'>عنوان پیوند</a><br /><a href='#' class='external autonumber'>[1]</a><br /><a href='#' class='external'>http://www.example.org</a>",
	'wikieditor-toolbar-help-content-heading2-description' => 'عنوان سطح دوم',
	'wikieditor-toolbar-help-content-heading2-syntax' => '== متن عنوان ==',
	'wikieditor-toolbar-help-content-heading2-result' => '<h2>متن عنوان</h2>',
	'wikieditor-toolbar-help-content-heading3-description' => 'عنوان سطح سوم',
	'wikieditor-toolbar-help-content-heading3-syntax' => '=== متن عنوان ===',
	'wikieditor-toolbar-help-content-heading3-result' => '<h3>متن عنوان</h3>',
	'wikieditor-toolbar-help-content-heading4-description' => 'عنوان سطح چهارم',
	'wikieditor-toolbar-help-content-heading4-syntax' => '==== متن عنوان ====',
	'wikieditor-toolbar-help-content-heading4-result' => '<h4>متن عنوان</h4>',
	'wikieditor-toolbar-help-content-heading5-description' => 'عنوان سطح پنجم',
	'wikieditor-toolbar-help-content-heading5-syntax' => '===== متن عنوان =====',
	'wikieditor-toolbar-help-content-heading5-result' => '<h5>متن عنوان</h5>',
	'wikieditor-toolbar-help-content-ulist-description' => 'فهرست گلوله‌ای',
	'wikieditor-toolbar-help-content-ulist-syntax' => '* مورد فهرست<br />* مورد فهرست',
	'wikieditor-toolbar-help-content-ulist-result' => '<ul><li>مورد فهرست</li><li>مورد فهرست</li></ul>',
	'wikieditor-toolbar-help-content-olist-description' => 'فهرست شماره‌ای',
	'wikieditor-toolbar-help-content-olist-syntax' => '# مورد فهرست<br /># مورد فهرست',
	'wikieditor-toolbar-help-content-olist-result' => '<ol><li>مورد فهرست</li><li>مورد فهرست</li></ol>',
	'wikieditor-toolbar-help-content-file-description' => 'پرونده جاسازی‌شده',
	'wikieditor-toolbar-help-content-file-syntax' => '[[$1:مثال.png|بندانگشتی|متن عنوان]]',
	'wikieditor-toolbar-help-content-file-result' => "<div style='width:104px;' class='thumbinner'><a title='متن عنوان' class='image' href='#'><img height='50' width='100' border='0' class='thumbimage' src='$2/WikiEditor/modules/images/toolbar/example-image.png' alt=''/></a><div class='thumbcaption'><div class='magnify'><a title='بزرگ‌نمایی' class='internal' href='#'><img height='11' width='15' alt='' src='$1/common/images/magnify-clip.png'/></a></div>متن عنوان</div></div>",
	'wikieditor-toolbar-help-content-reference-description' => 'منبع',
	'wikieditor-toolbar-help-content-reference-syntax' => 'متن صفحه.&lt;ref name="test"&gt;[http://www.example.org متن پیوند]، متن اضافی.&lt;/ref&gt;',
	'wikieditor-toolbar-help-content-reference-result' => "متن صفحه.<sup><a href='#'>[1]</a></sup>",
	'wikieditor-toolbar-help-content-rereference-description' => 'استفادهٔ دوباره از همان منبع',
	'wikieditor-toolbar-help-content-rereference-result' => "متن صفحه.<sup><a href='#'>[1]</a></sup>",
	'wikieditor-toolbar-help-content-showreferences-description' => 'نمایش منابع',
	'wikieditor-toolbar-help-content-showreferences-result' => "<ol class='references'><li id='cite_note-test-0'><b><a title='' href='#'>^</a></b> <a rel='nofollow' title='http://www.example.org' class='external text' href='#'>متن پیوند</a>، متن اضافی.</li></ol>",
	'wikieditor-toolbar-help-content-signaturetimestamp-description' => 'امضا به همراه برچسب زمان',
	'wikieditor-toolbar-help-content-signaturetimestamp-result' => "<a href='#' title='{{#special:mypage}}'>نام کاربری</a> (<a href='#' title='{{#special:mytalk}}'>بحث</a>) 15:54, 10 June 2009 (UTC)",
	'wikieditor-toolbar-help-content-signature-description' => 'امضا',
	'wikieditor-toolbar-help-content-signature-result' => "<a href='#' title='{{#special:mypage}}'>نام کاربری</a> (<a href='#' title='{{#special:mytalk}}'>بحث</a>)",
	'wikieditor-toolbar-help-content-indent-description' => 'تورفتگی',
	'wikieditor-toolbar-help-content-indent-syntax' => 'متن عادی<br />:متن تورفته<br />::متن تورفته',
	'wikieditor-toolbar-help-content-indent-result' => 'متن عادی<dl><dd>متن تورفته<dl><dd>متن تورفته</dd></dl></dd></dl>',
);

/** Finnish (suomi)
 * @author Beluga
 * @author Crt
 * @author Linnea
 * @author Nedergard
 * @author Nike
 * @author Olli
 * @author Silvonen
 * @author Str4nd
 * @author ZeiP
 */
$messages['fi'] = array(
	'wikieditor' => 'Edistynyt wikitext-muokkauskäyttöliittymä',
	'wikieditor-desc' => 'Tarjoaa laajennettavan wikitext-muokkauskäyttöliittymän ja monia toimintoja tarjoavia laajennuksia.',
	'wikieditor-wikitext-tab' => 'Wikiteksti',
	'wikieditor-loading' => 'Ladataan',
	'wikieditor-preview-preference' => 'Ota käyttöön vierekkäinen esikatselu',
	'wikieditor-preview-tab' => 'Esikatselu',
	'wikieditor-preview-changes-tab' => 'Muutokset',
	'wikieditor-preview-loading' => 'Ladataan…',
	'wikieditor-previewDialog-preference' => 'Ota esikatseluikkuna käyttöön',
	'wikieditor-previewDialog-tab' => 'Esikatselu',
	'wikieditor-previewDialog-loading' => 'Ladataan…',
	'wikieditor-publish-preference' => 'Ota käyttöön vaiheittainen julkaisu',
	'wikieditor-publish-button-publish' => 'Julkaise',
	'wikieditor-publish-button-cancel' => 'Peruuta',
	'wikieditor-publish-dialog-title' => 'Julkaise {{GRAMMAR:inessive|{{SITENAME}}}}',
	'wikieditor-publish-dialog-summary' => 'Muokkausyhteenveto (kuvaa lyhyesti tekemiäsi muutoksia):',
	'wikieditor-publish-dialog-minor' => 'Pieni muutos',
	'wikieditor-publish-dialog-watch' => 'Tarkkaile tätä sivua',
	'wikieditor-publish-dialog-publish' => 'Julkaise',
	'wikieditor-publish-dialog-goback' => 'Palaa takaisin',
	'wikieditor-template-editor-preference' => 'Ota käyttöön wikimallineiden lomakepohjainen muokkaus',
	'wikieditor-template-editor-dialog-title' => 'Muokkaa mallinetta',
	'wikieditor-template-editor-dialog-submit' => 'Päivitä',
	'wikieditor-template-editor-dialog-cancel' => 'Peruuta',
	'wikieditor-templates-preference' => 'Ota mallineiden piilotus käyttöön',
	'wikieditor-toc-preference' => 'Ota käyttöön navigoitava sisällysluettelo',
	'wikieditor-toc-show' => 'Näytä sisältö',
	'wikieditor-toc-hide' => 'Piilota sisältö',
	'wikieditor-toolbar' => 'Työkalupalkki muokkaukseen',
	'wikieditor-toolbar-desc' => 'Muokkaussivun työkalupalkki paremmalla käytettävyydellä.',
	'wikieditor-toolbar-preference' => 'Ota käyttöön parannettu työkalupalkki muokkauksissa',
	'wikieditor-toolbar-dialogs-preference' => 'Ota käyttöön valintatoiminto, jonka avulla voit lisätä linkkejä, taulukoita ja muuta',
	'wikieditor-toolbar-hidesig' => 'Piilota allekirjoituspainike sivuilta päänimiavaruudessa',
	'wikieditor-toolbar-loading' => 'Ladataan…',
	'wikieditor-toolbar-tool-bold' => 'Lihavointi',
	'wikieditor-toolbar-tool-bold-example' => 'Lihavoitu teksti',
	'wikieditor-toolbar-tool-italic' => 'Kursivointi',
	'wikieditor-toolbar-tool-italic-example' => 'Kursivoitu teksti',
	'wikieditor-toolbar-tool-ilink' => 'Sisäinen linkki',
	'wikieditor-toolbar-tool-ilink-example' => 'Linkin otsikko',
	'wikieditor-toolbar-tool-xlink' => 'Ulkoinen linkki (muista http://-etuliite)',
	'wikieditor-toolbar-tool-xlink-example' => 'http://www.example.com linkin otsikko',
	'wikieditor-toolbar-tool-link' => 'Linkki',
	'wikieditor-toolbar-tool-link-title' => 'Lisää linkki',
	'wikieditor-toolbar-tool-link-int' => 'Wikisivuun',
	'wikieditor-toolbar-tool-link-int-target' => 'Kohdesivu tai URL:',
	'wikieditor-toolbar-tool-link-int-target-tooltip' => 'Sivun otsikko tai URL',
	'wikieditor-toolbar-tool-link-int-text' => 'Näytettävä teksti:',
	'wikieditor-toolbar-tool-link-int-text-tooltip' => 'Teksti, joka näytetään',
	'wikieditor-toolbar-tool-link-ext' => 'Ulkoiseen sivustoon',
	'wikieditor-toolbar-tool-link-ext-target' => 'Linkin URL:',
	'wikieditor-toolbar-tool-link-ext-text' => 'Linkin teksti:',
	'wikieditor-toolbar-tool-link-insert' => 'Lisää linkki',
	'wikieditor-toolbar-tool-link-cancel' => 'Peruuta',
	'wikieditor-toolbar-tool-link-int-target-status-exists' => 'Sivu on olemassa',
	'wikieditor-toolbar-tool-link-int-target-status-notexists' => 'Sivua ei ole olemassa',
	'wikieditor-toolbar-tool-link-int-target-status-invalid' => 'Virheellinen otsikko',
	'wikieditor-toolbar-tool-link-int-target-status-external' => 'Ulkoinen linkki',
	'wikieditor-toolbar-tool-link-int-target-status-loading' => 'Tarkastetaan sivun olemassaolo…',
	'wikieditor-toolbar-tool-link-int-invalid' => 'Antamasi otsikko on virheellinen.',
	'wikieditor-toolbar-tool-link-lookslikeinternal' => 'URL-osoite, jonka annoit näyttää siltä kuin se olisi linkki toiselle wikisivulle.
Haluatko tehdä siitä sisäisen linkin?',
	'wikieditor-toolbar-tool-link-lookslikeinternal-int' => 'Sisäinen linkki',
	'wikieditor-toolbar-tool-link-lookslikeinternal-ext' => 'Ulkoinen linkki',
	'wikieditor-toolbar-tool-link-empty' => 'Et antanut mitään linkitettävää.',
	'wikieditor-toolbar-tool-file' => 'Tallennettu tiedosto',
	'wikieditor-toolbar-tool-file-example' => 'Esimerkki.jpg',
	'wikieditor-toolbar-tool-file-title' => 'Lisää tiedosto',
	'wikieditor-toolbar-file-target' => 'Tiedostonimi:',
	'wikieditor-toolbar-file-caption' => 'Kuvaus:',
	'wikieditor-toolbar-file-size' => 'Koko:',
	'wikieditor-toolbar-file-float' => 'Tasaus:',
	'wikieditor-toolbar-file-default' => '(oletus)',
	'wikieditor-toolbar-file-format' => 'Tiedostomuoto:',
	'wikieditor-toolbar-tool-file-insert' => 'Lisää',
	'wikieditor-toolbar-tool-file-cancel' => 'Peruuta',
	'wikieditor-toolbar-tool-reference' => 'Viite',
	'wikieditor-toolbar-tool-reference-example' => 'Lisää alahuomautusteksti tähän',
	'wikieditor-toolbar-tool-reference-cancel' => 'Peruuta',
	'wikieditor-toolbar-tool-reference-title' => 'Lisää viite',
	'wikieditor-toolbar-tool-reference-insert' => 'Lisää',
	'wikieditor-toolbar-tool-reference-text' => 'Viiteteksti',
	'wikieditor-toolbar-tool-signature' => 'Allekirjoitus ja aikaleima',
	'wikieditor-toolbar-section-advanced' => 'Laajennettu',
	'wikieditor-toolbar-tool-heading' => 'Otsikko',
	'wikieditor-toolbar-tool-heading-1' => 'Taso 1',
	'wikieditor-toolbar-tool-heading-2' => 'Taso 2',
	'wikieditor-toolbar-tool-heading-3' => 'Taso 3',
	'wikieditor-toolbar-tool-heading-4' => 'Taso 4',
	'wikieditor-toolbar-tool-heading-5' => 'Taso 5',
	'wikieditor-toolbar-tool-heading-example' => 'Otsikkoteksti',
	'wikieditor-toolbar-group-format' => 'Muoto',
	'wikieditor-toolbar-tool-ulist' => 'Luettelo',
	'wikieditor-toolbar-tool-ulist-example' => 'Luettelon kohta',
	'wikieditor-toolbar-tool-olist' => 'Numeroitu luettelo',
	'wikieditor-toolbar-tool-olist-example' => 'Numeroidun luettelon kohta',
	'wikieditor-toolbar-tool-indent' => 'Sisennys',
	'wikieditor-toolbar-tool-indent-example' => 'Sisennetty rivi',
	'wikieditor-toolbar-tool-nowiki' => 'Tekstiä, jota wiki ei muotoile',
	'wikieditor-toolbar-tool-nowiki-example' => 'Lisää muotoilematon teksti tähän',
	'wikieditor-toolbar-tool-redirect' => 'Ohjaus',
	'wikieditor-toolbar-tool-redirect-example' => 'Kohdesivun nimi',
	'wikieditor-toolbar-tool-big' => 'Suuri',
	'wikieditor-toolbar-tool-big-example' => 'Suuri teksti',
	'wikieditor-toolbar-tool-small' => 'Pieni',
	'wikieditor-toolbar-tool-small-example' => 'Pieni teksti',
	'wikieditor-toolbar-tool-superscript' => 'Yläindeksi',
	'wikieditor-toolbar-tool-superscript-example' => 'Yläindeksin teksti',
	'wikieditor-toolbar-tool-subscript' => 'Alaindeksi',
	'wikieditor-toolbar-tool-subscript-example' => 'Alaindeksin teksti',
	'wikieditor-toolbar-group-insert' => 'Lisää',
	'wikieditor-toolbar-tool-gallery' => 'Kuvagalleria',
	'wikieditor-toolbar-tool-gallery-example' => '$1:Esimerkki.jpg|Kuvateksti1
$1:Esimerkki.jpg|Kuvateksti2',
	'wikieditor-toolbar-tool-newline' => 'Uusi rivi',
	'wikieditor-toolbar-tool-table' => 'Taulukko',
	'wikieditor-toolbar-tool-table-example-old' => '-
! otsikko 1
! otsikko 2
! otsikko 3
|-
| rivi 1, solu 1
| rivi 1, solu 2
| rivi 1, solu 3
|-
| rivi 2, solu 1
| rivi 2, solu 2
| rivi 2, solu 3',
	'wikieditor-toolbar-tool-table-example-cell-text' => 'Solun teksti',
	'wikieditor-toolbar-tool-table-example-header' => 'Otsikkoteksti',
	'wikieditor-toolbar-tool-table-title' => 'Lisää taulukko',
	'wikieditor-toolbar-tool-table-dimensions-rows' => 'Rivit',
	'wikieditor-toolbar-tool-table-dimensions-columns' => 'Sarakkeet',
	'wikieditor-toolbar-tool-table-dimensions-header' => 'Lisää otsikkorivi',
	'wikieditor-toolbar-tool-table-wikitable' => 'Tyylitellyt reunat',
	'wikieditor-toolbar-tool-table-sortable' => 'Tee taulukosta lajiteltava',
	'wikieditor-toolbar-tool-table-example' => 'Esimerkki',
	'wikieditor-toolbar-tool-table-preview' => 'Esikatselu',
	'wikieditor-toolbar-tool-table-insert' => 'Lisää',
	'wikieditor-toolbar-tool-table-cancel' => 'Peruuta',
	'wikieditor-toolbar-tool-table-toomany' => 'Tällä toiminnolla ei voi tehdä taulukkoa, jossa on yli $1 solua.',
	'wikieditor-toolbar-tool-table-invalidnumber' => 'Et syöttänyt kelvollista rivi- tai sarakemäärää.',
	'wikieditor-toolbar-tool-table-zero' => 'Et voi lisätä taulukkoa, jossa ei ole yhtään riviä tai saraketta.',
	'wikieditor-toolbar-tool-replace' => 'Etsi ja korvaa',
	'wikieditor-toolbar-tool-replace-title' => 'Etsi ja korvaa',
	'wikieditor-toolbar-tool-replace-search' => 'Etsi seuraavaa:',
	'wikieditor-toolbar-tool-replace-replace' => 'Korvaa seuraavalla:',
	'wikieditor-toolbar-tool-replace-case' => 'Huomio kirjainkoko',
	'wikieditor-toolbar-tool-replace-regex' => 'Kohtele hakuarvoa säännöllisenä lausekkeena',
	'wikieditor-toolbar-tool-replace-button-findnext' => 'Etsi seuraava',
	'wikieditor-toolbar-tool-replace-button-replace' => 'Korvaa',
	'wikieditor-toolbar-tool-replace-button-replaceall' => 'Korvaa kaikki',
	'wikieditor-toolbar-tool-replace-close' => 'Sulje',
	'wikieditor-toolbar-tool-replace-nomatch' => 'Hakusi ei tuottanut osumia.',
	'wikieditor-toolbar-tool-replace-success' => '$1 korvausta tehty.',
	'wikieditor-toolbar-tool-replace-emptysearch' => 'Et antanut mitään haettavaa.',
	'wikieditor-toolbar-tool-replace-invalidregex' => 'Syöttämäsi säännöllinen lauseke ei ole kelvollinen: $1',
	'wikieditor-toolbar-section-characters' => 'Erikoismerkit',
	'wikieditor-toolbar-characters-page-latin' => 'Latina',
	'wikieditor-toolbar-characters-page-latinextended' => 'Laajennettu latina',
	'wikieditor-toolbar-characters-page-ipa' => 'Kansainvälinen foneettinen kirjaimisto (IPA)',
	'wikieditor-toolbar-characters-page-symbols' => 'Symbolit',
	'wikieditor-toolbar-characters-page-greek' => 'Kreikka',
	'wikieditor-toolbar-characters-page-cyrillic' => 'Kyrillinen',
	'wikieditor-toolbar-characters-page-arabic' => 'Arabia',
	'wikieditor-toolbar-characters-page-arabicextended' => 'Laajennettu arabia',
	'wikieditor-toolbar-characters-page-persian' => 'Persia',
	'wikieditor-toolbar-characters-page-hebrew' => 'Heprea',
	'wikieditor-toolbar-characters-page-bangla' => 'Bengali',
	'wikieditor-toolbar-characters-page-tamil' => 'Tamili',
	'wikieditor-toolbar-characters-page-telugu' => 'Telugu',
	'wikieditor-toolbar-characters-page-sinhala' => 'Sinhali',
	'wikieditor-toolbar-characters-page-gujarati' => 'Gudžarati',
	'wikieditor-toolbar-characters-page-devanagari' => 'Devanāgarī',
	'wikieditor-toolbar-characters-page-thai' => 'Thai',
	'wikieditor-toolbar-characters-page-lao' => 'Lao',
	'wikieditor-toolbar-characters-page-khmer' => 'Khmer',
	'wikieditor-toolbar-section-help' => 'Ohje',
	'wikieditor-toolbar-help-heading-description' => 'Kuvaus',
	'wikieditor-toolbar-help-heading-syntax' => 'Mitä kirjoitat',
	'wikieditor-toolbar-help-heading-result' => 'Mitä saat',
	'wikieditor-toolbar-help-page-format' => 'Muotoilu',
	'wikieditor-toolbar-help-page-link' => 'Linkit',
	'wikieditor-toolbar-help-page-heading' => 'Otsikot',
	'wikieditor-toolbar-help-page-list' => 'Luettelot',
	'wikieditor-toolbar-help-page-file' => 'Tiedostot',
	'wikieditor-toolbar-help-page-reference' => 'Viitteet',
	'wikieditor-toolbar-help-page-discussion' => 'Keskustelu',
	'wikieditor-toolbar-help-content-italic-description' => 'Kursivointi',
	'wikieditor-toolbar-help-content-italic-syntax' => "''Kursivoitu teksti''",
	'wikieditor-toolbar-help-content-italic-result' => '<em>Kursivoitu teksti</em>',
	'wikieditor-toolbar-help-content-bold-description' => 'Lihavointi',
	'wikieditor-toolbar-help-content-bold-syntax' => "'''Lihavoitu teksti'''",
	'wikieditor-toolbar-help-content-bold-result' => '<strong>Lihavoitu teksti</strong>',
	'wikieditor-toolbar-help-content-bolditalic-description' => 'Lihavointi ja kursivointi',
	'wikieditor-toolbar-help-content-bolditalic-syntax' => "'''''Lihavoitu ja kursivoitu teksti'''''",
	'wikieditor-toolbar-help-content-bolditalic-result' => '<strong><em>Lihavoitu ja kursivoitu teksti</em></strong>',
	'wikieditor-toolbar-help-content-ilink-description' => 'Sisäinen linkki',
	'wikieditor-toolbar-help-content-ilink-syntax' => '[[Sivun nimi|Linkin nimi]]<br />[[Sivun nimi]]',
	'wikieditor-toolbar-help-content-ilink-result' => "<a href='#'>Linkin nimi</a><br /><a href='#'>Sivun nimi</a>",
	'wikieditor-toolbar-help-content-xlink-description' => 'Ulkoinen linkki',
	'wikieditor-toolbar-help-content-xlink-syntax' => '[http://www.example.org Linkin nimi]<br />[http://www.example.org]<br />http://www.example.org',
	'wikieditor-toolbar-help-content-xlink-result' => "<a href='#' class='external'>Linkin nimi</a><br /><a href='#' class='external autonumber'>[1]</a><br /><a href='#' class='external'>http://www.example.org</a>",
	'wikieditor-toolbar-help-content-heading2-description' => '2. tason otsikko',
	'wikieditor-toolbar-help-content-heading2-syntax' => '== Otsikkoteksti ==',
	'wikieditor-toolbar-help-content-heading2-result' => '<h2>Otsikkoteksti</h2>',
	'wikieditor-toolbar-help-content-heading3-description' => '3. tason otsikko',
	'wikieditor-toolbar-help-content-heading3-syntax' => '=== Otsikkoteksti ===',
	'wikieditor-toolbar-help-content-heading3-result' => '<h3>Otsikkoteksti</h3>',
	'wikieditor-toolbar-help-content-heading4-description' => '4. tason otsikko',
	'wikieditor-toolbar-help-content-heading4-syntax' => '==== Otsikkoteksti ====',
	'wikieditor-toolbar-help-content-heading4-result' => '<h4>Otsikkoteksti</h4>',
	'wikieditor-toolbar-help-content-heading5-description' => '5. tason otsikko',
	'wikieditor-toolbar-help-content-heading5-syntax' => '===== Otsikkoteksti =====',
	'wikieditor-toolbar-help-content-heading5-result' => '<h5>Otsikkoteksti</h5>',
	'wikieditor-toolbar-help-content-ulist-description' => 'Luettelo',
	'wikieditor-toolbar-help-content-ulist-syntax' => '* Luettelon kohta<br />* Luettelon kohta',
	'wikieditor-toolbar-help-content-ulist-result' => '<ul><li>Luettelon kohta</li><li>Luettelon kohta</li></ul>',
	'wikieditor-toolbar-help-content-olist-description' => 'Numeroitu luettelo',
	'wikieditor-toolbar-help-content-olist-syntax' => '# Luettelon kohta<br /># Luettelon kohta',
	'wikieditor-toolbar-help-content-olist-result' => '<ol><li>Luettelon kohta</li><li>Luettelon kohta</li></ol>',
	'wikieditor-toolbar-help-content-file-description' => 'Tallennettu tiedosto',
	'wikieditor-toolbar-help-content-file-syntax' => '[[$1:Example.png|thumb|Kuvateksti]]',
	'wikieditor-toolbar-help-content-file-result' => "<div style='width:104px;' class='thumbinner'><a title='Kuvateksti' class='image' href='#'><img height='50' width='100' border='0' class='thumbimage' src='$2/WikiEditor/modules/images/toolbar/example-image.png' alt=''/></a><div class='thumbcaption'><div class='magnify'><a title='Suurenna' class='internal' href='#'><img height='11' width='15' alt='' src='$1/common/images/magnify-clip.png'/></a></div>Kuvateksti</div></div>",
	'wikieditor-toolbar-help-content-reference-description' => 'Viite',
	'wikieditor-toolbar-help-content-reference-syntax' => 'Sivun teksti.&lt;ref name="testi"&gt;[http://www.example.org Linkin teksti], lisäteksti.&lt;/ref&gt;',
	'wikieditor-toolbar-help-content-reference-result' => "Sivun teksti.<sup><a href='#'>[1]</a></sup>",
	'wikieditor-toolbar-help-content-rereference-description' => 'Saman viitteen lisäkäyttö',
	'wikieditor-toolbar-help-content-rereference-result' => "Sivun teksti.<sup><a href='#'>[1]</a></sup>",
	'wikieditor-toolbar-help-content-showreferences-description' => 'Näytä viitteet',
	'wikieditor-toolbar-help-content-showreferences-result' => "<ol class='references'><li id='cite_note-test-0'><b><a title='' href='#'>^</a></b> <a rel='nofollow' title='http://www.example.org' class='external text' href='#'>Linkin teksti</a>, lisäteksti.</li></ol>",
	'wikieditor-toolbar-help-content-signaturetimestamp-description' => 'Allekirjoitus aikaleimalla',
	'wikieditor-toolbar-help-content-signaturetimestamp-result' => "<a href='#' title='{{#special:mypage}}'>Käyttäjätunnus</a> (<a href='#' title='{{#special:mytalk}}'>keskustelu</a>) 10. kesäkuuta 2009 kello 15.54 (EEST)",
	'wikieditor-toolbar-help-content-signature-description' => 'Allekirjoitus',
	'wikieditor-toolbar-help-content-signature-result' => "<a href='#' title='{{#special:mypage}}'>Käyttäjätunnus</a> (<a href='#' title='{{#special:mytalk}}'>keskustelu</a>)",
	'wikieditor-toolbar-help-content-indent-description' => 'Sisennys',
	'wikieditor-toolbar-help-content-indent-syntax' => 'Normaali teksti<br />:Sisennetty teksti<br />::Sisennetty teksti',
	'wikieditor-toolbar-help-content-indent-result' => 'Normaali teksti<dl><dd>Sisennetty teksti<dl><dd>Sisennetty teksti</dd></dl></dd></dl>',
);

/** French (français)
 * @author Cquoi
 * @author Crochet.david
 * @author DavidL
 * @author Erkethan
 * @author Gomoko
 * @author IAlex
 * @author Jean-Frédéric
 * @author McDutchie
 * @author Peter17
 * @author PieRRoMaN
 * @author Urhixidur
 * @author Verdy p
 * @author Zetud
 */
$messages['fr'] = array(
	'wikieditor' => 'Interface avancée de modification de wikitexte',
	'wikieditor-desc' => 'Fournit un interface de modification de wikitexte extensible et plusieurs fonctionnalités.',
	'wikieditor-wikitext-tab' => 'WikiTexte',
	'wikieditor-loading' => 'Chargement',
	'wikieditor-preview-preference' => 'Activer la prévisualisation côte à côte',
	'wikieditor-preview-tab' => 'Prévisualisation',
	'wikieditor-preview-changes-tab' => 'Changements',
	'wikieditor-preview-loading' => 'Chargement...',
	'wikieditor-previewDialog-preference' => 'Activer la boîte de dialogue d’aperçu',
	'wikieditor-previewDialog-tab' => 'Prévisualisation',
	'wikieditor-previewDialog-loading' => 'Chargement...',
	'wikieditor-publish-preference' => 'Activer la publication étape par étape',
	'wikieditor-publish-button-publish' => 'Publier',
	'wikieditor-publish-button-cancel' => 'Annuler',
	'wikieditor-publish-dialog-title' => 'Publier sur {{SITENAME}}',
	'wikieditor-publish-dialog-summary' => 'Résumé de modification (décrivez brièvement les changements que vous avez apportés) :',
	'wikieditor-publish-dialog-minor' => 'Modification mineure',
	'wikieditor-publish-dialog-watch' => 'Suivre cette page',
	'wikieditor-publish-dialog-publish' => 'Publier',
	'wikieditor-publish-dialog-goback' => 'Revenir en arrière',
	'wikieditor-template-editor-preference' => 'Activer la modification à base de formulaires des modèles wiki',
	'wikieditor-template-editor-dialog-title' => 'Modifier le modèle',
	'wikieditor-template-editor-dialog-submit' => 'Mettre à jour',
	'wikieditor-template-editor-dialog-cancel' => 'Annuler',
	'wikieditor-templates-preference' => 'Activer le repliement des modèles',
	'wikieditor-toc-preference' => 'Activer la table des matières navigable',
	'wikieditor-toc-show' => 'Afficher le contenu',
	'wikieditor-toc-hide' => 'Masquer le contenu',
	'wikieditor-toolbar' => 'Barre d’outils de modification',
	'wikieditor-toolbar-desc' => 'Barre d’outils de modification avec l’utilisabilité améliorée',
	'wikieditor-toolbar-preference' => 'Activer la barre d’outils améliorée',
	'wikieditor-toolbar-dialogs-preference' => 'Activer les boîtes de dialogue pour ajouter des liens, des tableaux et plus',
	'wikieditor-toolbar-hidesig' => "Masquer le bouton de signature dans les pages de l'espace de noms principal",
	'wikieditor-toolbar-loading' => 'Chargement...',
	'wikieditor-toolbar-tool-bold' => 'Gras',
	'wikieditor-toolbar-tool-bold-example' => 'Texte en gras',
	'wikieditor-toolbar-tool-italic' => 'Italique',
	'wikieditor-toolbar-tool-italic-example' => 'Texte en italique',
	'wikieditor-toolbar-tool-ilink' => 'Lien interne',
	'wikieditor-toolbar-tool-ilink-example' => 'Titre du lien',
	'wikieditor-toolbar-tool-xlink' => 'Lien externe (n’oubliez pas le préfixe http://)',
	'wikieditor-toolbar-tool-xlink-example' => 'http://www.example.com titre du lien',
	'wikieditor-toolbar-tool-link' => 'Lien',
	'wikieditor-toolbar-tool-link-title' => 'Insérer un lien',
	'wikieditor-toolbar-tool-link-int' => 'Vers un article / une page wiki',
	'wikieditor-toolbar-tool-link-int-target' => 'Titre de la page :',
	'wikieditor-toolbar-tool-link-int-target-tooltip' => 'Titre de la page ou URL',
	'wikieditor-toolbar-tool-link-int-text' => 'Texte du lien :',
	'wikieditor-toolbar-tool-link-int-text-tooltip' => 'Entrez le texte qui devrait être affiché',
	'wikieditor-toolbar-tool-link-ext' => 'Vers une page web externe',
	'wikieditor-toolbar-tool-link-ext-target' => 'URL cible du lien :',
	'wikieditor-toolbar-tool-link-ext-text' => 'Texte du lien :',
	'wikieditor-toolbar-tool-link-insert' => 'Insérer le lien',
	'wikieditor-toolbar-tool-link-cancel' => 'Annuler',
	'wikieditor-toolbar-tool-link-int-target-status-exists' => 'La page existe',
	'wikieditor-toolbar-tool-link-int-target-status-notexists' => 'La page n’existe pas',
	'wikieditor-toolbar-tool-link-int-target-status-invalid' => 'Titre invalide',
	'wikieditor-toolbar-tool-link-int-target-status-external' => 'Lien externe',
	'wikieditor-toolbar-tool-link-int-target-status-loading' => 'Vérification de l’existence de la page...',
	'wikieditor-toolbar-tool-link-int-invalid' => 'Le titre que vous avez spécifié est incorrect.',
	'wikieditor-toolbar-tool-link-lookslikeinternal' => 'L’URL que vous avez spécifiée semble mener à une autre page du wiki.
Voulez-vous utiliser un lien interne à la place ?',
	'wikieditor-toolbar-tool-link-lookslikeinternal-int' => 'Lien interne',
	'wikieditor-toolbar-tool-link-lookslikeinternal-ext' => 'Lien externe',
	'wikieditor-toolbar-tool-link-empty' => 'Vous n’avez rien entré qui puisse être lié.',
	'wikieditor-toolbar-tool-file' => 'Fichier inséré',
	'wikieditor-toolbar-tool-file-example' => 'Exemple.jpg',
	'wikieditor-toolbar-tool-file-title' => 'Importer un fichier',
	'wikieditor-toolbar-file-target' => 'Nom de fichier :',
	'wikieditor-toolbar-file-caption' => 'Légende :',
	'wikieditor-toolbar-file-size' => 'Taille :',
	'wikieditor-toolbar-file-float' => 'Alignement :',
	'wikieditor-toolbar-file-default' => '(par défaut)',
	'wikieditor-toolbar-file-format' => 'Format :',
	'wikieditor-toolbar-file-format-none' => 'aucun',
	'wikieditor-toolbar-tool-file-insert' => 'Insérer',
	'wikieditor-toolbar-tool-file-cancel' => 'Annuler',
	'wikieditor-toolbar-tool-reference' => 'Référence',
	'wikieditor-toolbar-tool-reference-example' => 'Insérer le texte de la note de bas de page ici',
	'wikieditor-toolbar-tool-reference-cancel' => 'Annuler',
	'wikieditor-toolbar-tool-reference-title' => 'Insérer une référence',
	'wikieditor-toolbar-tool-reference-insert' => 'Insérer',
	'wikieditor-toolbar-tool-reference-text' => 'Texte de la référence',
	'wikieditor-toolbar-tool-signature' => 'Signature et date',
	'wikieditor-toolbar-section-advanced' => 'Avancé',
	'wikieditor-toolbar-tool-heading' => 'Titre',
	'wikieditor-toolbar-tool-heading-1' => 'Niveau 1',
	'wikieditor-toolbar-tool-heading-2' => 'Niveau 2',
	'wikieditor-toolbar-tool-heading-3' => 'Niveau 3',
	'wikieditor-toolbar-tool-heading-4' => 'Niveau 4',
	'wikieditor-toolbar-tool-heading-5' => 'Niveau 5',
	'wikieditor-toolbar-tool-heading-example' => 'Texte du titre',
	'wikieditor-toolbar-group-format' => 'Format',
	'wikieditor-toolbar-tool-ulist' => 'Liste à puces',
	'wikieditor-toolbar-tool-ulist-example' => 'Élément de la liste à puces',
	'wikieditor-toolbar-tool-olist' => 'Liste numérotée',
	'wikieditor-toolbar-tool-olist-example' => 'Élément de la liste numérotée',
	'wikieditor-toolbar-tool-indent' => 'Retrait',
	'wikieditor-toolbar-tool-indent-example' => 'Ligne en retrait',
	'wikieditor-toolbar-tool-nowiki' => 'Pas de formatage wiki',
	'wikieditor-toolbar-tool-nowiki-example' => 'Insérer ici un texte non formaté',
	'wikieditor-toolbar-tool-redirect' => 'Redirection',
	'wikieditor-toolbar-tool-redirect-example' => 'Nom de la page de destination',
	'wikieditor-toolbar-tool-big' => 'Grand',
	'wikieditor-toolbar-tool-big-example' => 'Grand texte',
	'wikieditor-toolbar-tool-small' => 'Petit',
	'wikieditor-toolbar-tool-small-example' => 'Petit texte',
	'wikieditor-toolbar-tool-superscript' => 'Exposant',
	'wikieditor-toolbar-tool-superscript-example' => 'Texte en exposant',
	'wikieditor-toolbar-tool-subscript' => 'Indice',
	'wikieditor-toolbar-tool-subscript-example' => 'Texte en indice',
	'wikieditor-toolbar-group-insert' => 'Insérer',
	'wikieditor-toolbar-tool-gallery' => 'Galerie de fichiers',
	'wikieditor-toolbar-tool-gallery-example' => '$1:Exemple.jpg|Description 1
$1:Exemple.jpg|Description 2',
	'wikieditor-toolbar-tool-newline' => 'Saut de ligne',
	'wikieditor-toolbar-tool-table' => 'Tableau',
	'wikieditor-toolbar-tool-table-example-old' => '-
! en-tête 1
! en-tête 2
! en-tête 3
|-
| ligne 1, case 1
| ligne 1, case 2
| ligne 1, case 3
|-
| ligne 2, case 1
| ligne 2, case 2
| ligne 2, case 3',
	'wikieditor-toolbar-tool-table-example-cell-text' => 'Texte de la cellule',
	'wikieditor-toolbar-tool-table-example-header' => 'Texte de l’en-tête',
	'wikieditor-toolbar-tool-table-title' => 'Insérer un tableau',
	'wikieditor-toolbar-tool-table-dimensions-rows' => 'Lignes',
	'wikieditor-toolbar-tool-table-dimensions-columns' => 'Colonnes',
	'wikieditor-toolbar-tool-table-dimensions-header' => 'Inclure la ligne d’en-tête',
	'wikieditor-toolbar-tool-table-wikitable' => 'Style avec bordures',
	'wikieditor-toolbar-tool-table-sortable' => 'Rendre le tableau triable',
	'wikieditor-toolbar-tool-table-example' => 'Texte de la cellule',
	'wikieditor-toolbar-tool-table-preview' => 'Prévisualisation',
	'wikieditor-toolbar-tool-table-insert' => 'Insérer',
	'wikieditor-toolbar-tool-table-cancel' => 'Annuler',
	'wikieditor-toolbar-tool-table-toomany' => 'Il n’est pas possible d’insérer un tableau de plus de $1 cellules avec cet outil.',
	'wikieditor-toolbar-tool-table-invalidnumber' => 'Vous n’avez pas entré un nombre de lignes ou de colonnes valide.',
	'wikieditor-toolbar-tool-table-zero' => 'Vous ne pouvez pas insérer un tableau sans ligne ou sans colonne.',
	'wikieditor-toolbar-tool-replace' => 'Rechercher et remplacer',
	'wikieditor-toolbar-tool-replace-title' => 'Rechercher et remplacer',
	'wikieditor-toolbar-tool-replace-search' => 'Rechercher :',
	'wikieditor-toolbar-tool-replace-replace' => 'Remplacer par :',
	'wikieditor-toolbar-tool-replace-case' => 'Faire correspondre la casse',
	'wikieditor-toolbar-tool-replace-regex' => 'Traiter la chaîne de recherche comme une expression rationnelle',
	'wikieditor-toolbar-tool-replace-button-findnext' => 'Rechercher le suivant',
	'wikieditor-toolbar-tool-replace-button-replace' => 'Remplacer',
	'wikieditor-toolbar-tool-replace-button-replaceall' => 'Remplacer tout',
	'wikieditor-toolbar-tool-replace-close' => 'Fermer',
	'wikieditor-toolbar-tool-replace-nomatch' => 'Votre recherche n’a abouti à aucune correspondance.',
	'wikieditor-toolbar-tool-replace-success' => '$1 remplacements faits.',
	'wikieditor-toolbar-tool-replace-emptysearch' => 'Vous n’avez pas indiqué de texte à rechercher.',
	'wikieditor-toolbar-tool-replace-invalidregex' => 'L’expression rationnelle entrée est invalide : $1',
	'wikieditor-toolbar-section-characters' => 'Caractères spéciaux',
	'wikieditor-toolbar-characters-page-latin' => 'latin',
	'wikieditor-toolbar-characters-page-latinextended' => 'latin étendu',
	'wikieditor-toolbar-characters-page-ipa' => 'API',
	'wikieditor-toolbar-characters-page-symbols' => 'symboles',
	'wikieditor-toolbar-characters-page-greek' => 'grec',
	'wikieditor-toolbar-characters-page-cyrillic' => 'cyrillique',
	'wikieditor-toolbar-characters-page-arabic' => 'arabe',
	'wikieditor-toolbar-characters-page-arabicextended' => 'arabe étendu',
	'wikieditor-toolbar-characters-page-persian' => 'persan',
	'wikieditor-toolbar-characters-page-hebrew' => 'hébreu',
	'wikieditor-toolbar-characters-page-bangla' => 'bengalî',
	'wikieditor-toolbar-characters-page-tamil' => 'tamoul',
	'wikieditor-toolbar-characters-page-telugu' => 'télougou',
	'wikieditor-toolbar-characters-page-sinhala' => 'cingalais',
	'wikieditor-toolbar-characters-page-gujarati' => 'gujarâtî',
	'wikieditor-toolbar-characters-page-devanagari' => 'Devanagari',
	'wikieditor-toolbar-characters-page-thai' => 'thaï',
	'wikieditor-toolbar-characters-page-lao' => 'laotien',
	'wikieditor-toolbar-characters-page-khmer' => 'khmer',
	'wikieditor-toolbar-section-help' => 'Aide',
	'wikieditor-toolbar-help-heading-description' => 'Description',
	'wikieditor-toolbar-help-heading-syntax' => 'Ce que vous tapez',
	'wikieditor-toolbar-help-heading-result' => 'Ce que vous obtenez',
	'wikieditor-toolbar-help-page-format' => 'Formatage',
	'wikieditor-toolbar-help-page-link' => 'Liens',
	'wikieditor-toolbar-help-page-heading' => 'Titres',
	'wikieditor-toolbar-help-page-list' => 'Listes',
	'wikieditor-toolbar-help-page-file' => 'Fichiers',
	'wikieditor-toolbar-help-page-reference' => 'Références',
	'wikieditor-toolbar-help-page-discussion' => 'Discussion',
	'wikieditor-toolbar-help-content-italic-description' => 'Italique',
	'wikieditor-toolbar-help-content-italic-syntax' => "''Texte italique''",
	'wikieditor-toolbar-help-content-italic-result' => '<em>Texte italique</em>',
	'wikieditor-toolbar-help-content-bold-description' => 'Gras',
	'wikieditor-toolbar-help-content-bold-syntax' => "'''Texte gras'''",
	'wikieditor-toolbar-help-content-bold-result' => '<strong>Texte gras</strong>',
	'wikieditor-toolbar-help-content-bolditalic-description' => 'Gras &amp; italique',
	'wikieditor-toolbar-help-content-bolditalic-syntax' => "'''''Texte gras &amp; italique'''''",
	'wikieditor-toolbar-help-content-bolditalic-result' => '<strong><em>Texte gras &amp; italique</em></strong>',
	'wikieditor-toolbar-help-content-ilink-description' => 'Lien interne',
	'wikieditor-toolbar-help-content-ilink-syntax' => '[[Titre de la page|Texte du lien]]<br />[[Titre de la page]]',
	'wikieditor-toolbar-help-content-ilink-result' => "<a href='#'>Texte du lien</a><br /><a href='#'>Titre de la page</a>",
	'wikieditor-toolbar-help-content-xlink-description' => 'Lien externe',
	'wikieditor-toolbar-help-content-xlink-syntax' => '[http://www.example.org Texte du lien]<br />[http://www.example.org]<br />http://www.example.org',
	'wikieditor-toolbar-help-content-xlink-result' => "<a href='#' class='external'>Texte du lien</a><br /><a href='#' class='external autonumber'>[1]</a><br /><a href='#' class='external'>http://www.example.org</a>",
	'wikieditor-toolbar-help-content-heading2-description' => 'Titre de deuxième niveau',
	'wikieditor-toolbar-help-content-heading2-syntax' => '== Texte du titre ==',
	'wikieditor-toolbar-help-content-heading2-result' => '<h2>Texte du titre</h2>',
	'wikieditor-toolbar-help-content-heading3-description' => 'Titre de troisième niveau',
	'wikieditor-toolbar-help-content-heading3-syntax' => '=== Texte du titre ===',
	'wikieditor-toolbar-help-content-heading3-result' => '<h3>Texte du titre</h3>',
	'wikieditor-toolbar-help-content-heading4-description' => 'Titre de quatrième niveau',
	'wikieditor-toolbar-help-content-heading4-syntax' => '==== Texte du titre ====',
	'wikieditor-toolbar-help-content-heading4-result' => '<h4>Texte du titre</h4>',
	'wikieditor-toolbar-help-content-heading5-description' => 'Titre de cinquième niveau',
	'wikieditor-toolbar-help-content-heading5-syntax' => '===== Texte du titre =====',
	'wikieditor-toolbar-help-content-heading5-result' => '<h5>Texte du titre</h5>',
	'wikieditor-toolbar-help-content-ulist-description' => 'Liste à puces',
	'wikieditor-toolbar-help-content-ulist-syntax' => '* Élément de la liste<br />* Élément de la liste',
	'wikieditor-toolbar-help-content-ulist-result' => '<ul><li>Élément de la liste</li><li>Élément de la liste</li></ul>',
	'wikieditor-toolbar-help-content-olist-description' => 'Liste numérotée',
	'wikieditor-toolbar-help-content-olist-syntax' => '# Élément de la liste<br /># Élément de la liste',
	'wikieditor-toolbar-help-content-olist-result' => '<ol><li>Élément de la liste</li><li>Élément de la liste</li></ol>',
	'wikieditor-toolbar-help-content-file-description' => 'Fichier inséré',
	'wikieditor-toolbar-help-content-file-syntax' => '[[$1:Exemple.png|thumb|Texte affiché]]',
	'wikieditor-toolbar-help-content-file-result' => "<div style='width:104px;' class='thumbinner'><a title='Texte affiché' class='image' href='#'><img height='50' width='100' border='0' class='thumbimage' src='$2/WikiEditor/modules/images/toolbar/example-image.png' alt=''/></a><div class='thumbcaption'><div class='magnify'><a title='Enlarge' class='internal' href='#'><img height='11' width='15' alt='' src='$1/common/images/magnify-clip.png'/></a></div>Texte affiché</div></div>",
	'wikieditor-toolbar-help-content-reference-description' => 'Référence',
	'wikieditor-toolbar-help-content-reference-syntax' => 'Texte de la page&lt;ref name="test"&gt;[http://www.example.org texte du lien], texte additionnel.&lt;/ref&gt;',
	'wikieditor-toolbar-help-content-reference-result' => "Texte de la page <sup><a href='#'>[1]</a></sup>",
	'wikieditor-toolbar-help-content-rereference-description' => 'Utilisation additionnelle de la même référence',
	'wikieditor-toolbar-help-content-rereference-result' => "Texte de la page <sup><a href='#'>[1]</a></sup>",
	'wikieditor-toolbar-help-content-showreferences-description' => 'Afficher les références',
	'wikieditor-toolbar-help-content-showreferences-result' => "<ol class='references'><li id='cite_note-test-0'><b><a title='' href='#'>^</a></b> <a rel='nofollow' title='http://www.example.org' class='external text' href='#'>Texte du lien</a>, texte additionnel.</li></ol>",
	'wikieditor-toolbar-help-content-signaturetimestamp-description' => 'Signature avec date',
	'wikieditor-toolbar-help-content-signaturetimestamp-result' => "<a href='#' title='{{#special:mypage}}'>Nom d’utilisateur</a> (<a href='#' title='{{#special:mytalk}}'>discuter</a>) 10 Juin 2009 à 15:54 (UTC)",
	'wikieditor-toolbar-help-content-signature-description' => 'Signature',
	'wikieditor-toolbar-help-content-signature-result' => "<a href='#' title='{{#special:mypage}}'>Nom d’utilisateur</a> (<a href='#' title='{{#special:mytalk}}'>discuter</a>)",
	'wikieditor-toolbar-help-content-indent-description' => 'Retrait',
	'wikieditor-toolbar-help-content-indent-syntax' => 'Texte normal<br />:Texte en retrait<br />::Texte en retrait',
	'wikieditor-toolbar-help-content-indent-result' => 'Texte normal<dl><dd>Texte en retrait<dl><dd>Texte en retrait</dd></dl></dd></dl>',
);

/** Franco-Provençal (arpetan)
 * @author ChrisPtDe
 */
$messages['frp'] = array(
	'wikieditor' => 'Entèrface avanciê de changement de vouiquitèxto',
	'wikieditor-desc' => 'Balye una entèrface de changement de vouiquitèxto èxtensibla et un mouél de fonccionalitâts.',
	'wikieditor-wikitext-tab' => 'Vouiquitèxto',
	'wikieditor-loading' => 'Chargement',
	'wikieditor-preview-preference' => 'Activar la prèvisualisacion a châ couta',
	'wikieditor-preview-tab' => 'Prèvisualisacion',
	'wikieditor-preview-changes-tab' => 'Changements',
	'wikieditor-preview-loading' => 'Chargement...',
	'wikieditor-previewDialog-preference' => 'Activar la bouèta de dialogo d’apèrçu',
	'wikieditor-previewDialog-tab' => 'Prèvisualisacion',
	'wikieditor-previewDialog-loading' => 'Chargement...',
	'wikieditor-publish-preference' => 'Activar la publecacion a châ ètapa',
	'wikieditor-publish-button-publish' => 'Publeyér',
	'wikieditor-publish-button-cancel' => 'Anular',
	'wikieditor-publish-dialog-title' => 'Publeyér dessus {{SITENAME}}',
	'wikieditor-publish-dialog-summary' => 'Rèsumâ de changement (dècrîde en grôs los changements que vos éd fêts) :',
	'wikieditor-publish-dialog-minor' => 'Petiôt changement',
	'wikieditor-publish-dialog-watch' => 'Siuvre ceta pâge',
	'wikieditor-publish-dialog-publish' => 'Publeyér',
	'wikieditor-publish-dialog-goback' => 'Retôrn',
	'wikieditor-template-editor-preference' => 'Activar lo changement a bâsa de formulèros des modèlos vouiqui',
	'wikieditor-template-editor-dialog-title' => 'Changiér lo modèlo',
	'wikieditor-template-editor-dialog-submit' => 'Betar a jorn',
	'wikieditor-template-editor-dialog-cancel' => 'Anular',
	'wikieditor-templates-preference' => 'Activar lo retrèt des modèlos',
	'wikieditor-toc-preference' => 'Activar la trâbla de les matiéres navigâbla',
	'wikieditor-toc-show' => 'Fâre vêre lo contegnu',
	'wikieditor-toc-hide' => 'Cachiér lo contegnu',
	'wikieditor-toolbar' => 'Bârra d’outils d’èdicion',
	'wikieditor-toolbar-desc' => 'Bârra d’outils d’èdicion avouéc l’utilisabilitât mèlyorâ',
	'wikieditor-toolbar-preference' => 'Activar la bârra d’outils d’èdicion mèlyorâ',
	'wikieditor-toolbar-dialogs-preference' => 'Activar les bouètes de dialogo por apondre des lims, des tablôs et ples',
	'wikieditor-toolbar-hidesig' => 'Cachiér lo boton de signatura dens les pâges de l’èspâço de noms principâl',
	'wikieditor-toolbar-loading' => 'Chargement...',
	'wikieditor-toolbar-tool-bold' => 'Grâs',
	'wikieditor-toolbar-tool-bold-example' => 'Tèxto en grâs',
	'wikieditor-toolbar-tool-italic' => 'Étalico',
	'wikieditor-toolbar-tool-italic-example' => 'Tèxto en étalico',
	'wikieditor-toolbar-tool-ilink' => 'Lim de dedens',
	'wikieditor-toolbar-tool-ilink-example' => 'Titro du lim',
	'wikieditor-toolbar-tool-xlink' => 'Lim de defôr (oubliâd pas lo prèfixo http://)',
	'wikieditor-toolbar-tool-xlink-example' => 'http://www.example.com titro du lim',
	'wikieditor-toolbar-tool-link' => 'Lim',
	'wikieditor-toolbar-tool-link-title' => 'Entrebetar un lim',
	'wikieditor-toolbar-tool-link-int' => 'De vers una pâge vouiqui',
	'wikieditor-toolbar-tool-link-int-target' => 'Titro de la pâge ou ben URL :',
	'wikieditor-toolbar-tool-link-int-target-tooltip' => 'Titro de la pâge ou ben URL',
	'wikieditor-toolbar-tool-link-int-text' => 'Tèxto du lim :',
	'wikieditor-toolbar-tool-link-int-text-tooltip' => 'Buchiéd lo tèxto que devrêt étre montrâ',
	'wikieditor-toolbar-tool-link-ext' => 'De vers una pâge vouèbe de defôr',
	'wikieditor-toolbar-tool-link-ext-target' => 'URL ciba du lim :',
	'wikieditor-toolbar-tool-link-ext-text' => 'Tèxto du lim :',
	'wikieditor-toolbar-tool-link-insert' => 'Entrebetar lo lim',
	'wikieditor-toolbar-tool-link-cancel' => 'Anular',
	'wikieditor-toolbar-tool-link-int-target-status-exists' => 'La pâge ègziste',
	'wikieditor-toolbar-tool-link-int-target-status-notexists' => 'La pâge ègziste pas',
	'wikieditor-toolbar-tool-link-int-target-status-invalid' => 'Titro envalido',
	'wikieditor-toolbar-tool-link-int-target-status-external' => 'Lim de defôr',
	'wikieditor-toolbar-tool-link-int-target-status-loading' => 'Contrôlo de l’ègzistence de la pâge...',
	'wikieditor-toolbar-tool-link-int-invalid' => 'Lo titro que vos éd spècefiâ est fôx.',
	'wikieditor-toolbar-tool-link-lookslikeinternal' => 'L’URL que vos éd spècefiâ semble liyér vers una ôtra pâge du vouiqui.
Voléd-vos utilisar un lim de dedens a la place ?',
	'wikieditor-toolbar-tool-link-lookslikeinternal-int' => 'Lim de dedens',
	'wikieditor-toolbar-tool-link-lookslikeinternal-ext' => 'Lim de defôr',
	'wikieditor-toolbar-tool-link-empty' => 'Vos éd ren buchiê que pouesse étre liyê.',
	'wikieditor-toolbar-tool-file' => 'Fichiér entrebetâ',
	'wikieditor-toolbar-tool-file-example' => 'Ègzemplo.jpg',
	'wikieditor-toolbar-tool-file-title' => 'Entrebetar un fichiér',
	'wikieditor-toolbar-file-target' => 'Nom du fichiér :',
	'wikieditor-toolbar-file-caption' => 'Lègenda :',
	'wikieditor-toolbar-file-size' => 'Talye :',
	'wikieditor-toolbar-file-float' => 'Alegnement :',
	'wikieditor-toolbar-file-default' => '(per dèfôt)',
	'wikieditor-toolbar-file-format' => 'Format :',
	'wikieditor-toolbar-tool-file-insert' => 'Entrebetar',
	'wikieditor-toolbar-tool-file-cancel' => 'Anular',
	'wikieditor-toolbar-tool-reference' => 'Refèrence',
	'wikieditor-toolbar-tool-reference-example' => 'Buchiéd lo tèxto de la nota d’avâl la pâge ique',
	'wikieditor-toolbar-tool-reference-cancel' => 'Anular',
	'wikieditor-toolbar-tool-reference-title' => 'Entrebetar una refèrence',
	'wikieditor-toolbar-tool-reference-insert' => 'Entrebetar',
	'wikieditor-toolbar-tool-reference-text' => 'Tèxto de la refèrence',
	'wikieditor-toolbar-tool-signature' => 'Signatura et dâta',
	'wikieditor-toolbar-section-advanced' => 'Avanciê',
	'wikieditor-toolbar-tool-heading' => 'Titro',
	'wikieditor-toolbar-tool-heading-1' => 'Nivél 1',
	'wikieditor-toolbar-tool-heading-2' => 'Nivél 2',
	'wikieditor-toolbar-tool-heading-3' => 'Nivél 3',
	'wikieditor-toolbar-tool-heading-4' => 'Nivél 4',
	'wikieditor-toolbar-tool-heading-5' => 'Nivél 5',
	'wikieditor-toolbar-tool-heading-example' => 'Tèxto du titro',
	'wikieditor-toolbar-group-format' => 'Format',
	'wikieditor-toolbar-tool-ulist' => 'Lista de puges',
	'wikieditor-toolbar-tool-ulist-example' => 'Èlèment de la lista de puges',
	'wikieditor-toolbar-tool-olist' => 'Lista numerotâ',
	'wikieditor-toolbar-tool-olist-example' => 'Èlèment de la lista numerotâ',
	'wikieditor-toolbar-tool-indent' => 'Endentacion',
	'wikieditor-toolbar-tool-indent-example' => 'Legne endentâ',
	'wikieditor-toolbar-tool-nowiki' => 'Gins de formatâjo vouiqui',
	'wikieditor-toolbar-tool-nowiki-example' => 'Buchiéd lo tèxto pas formatâ ique',
	'wikieditor-toolbar-tool-redirect' => 'Redirèccion',
	'wikieditor-toolbar-tool-redirect-example' => 'Nom de la pâge de dèstinacion',
	'wikieditor-toolbar-tool-big' => 'Grôs',
	'wikieditor-toolbar-tool-big-example' => 'Grôs tèxto',
	'wikieditor-toolbar-tool-small' => 'Petiôt',
	'wikieditor-toolbar-tool-small-example' => 'Petiôt tèxto',
	'wikieditor-toolbar-tool-superscript' => 'Èxposent',
	'wikieditor-toolbar-tool-superscript-example' => 'Tèxto en èxposent',
	'wikieditor-toolbar-tool-subscript' => 'Segno',
	'wikieditor-toolbar-tool-subscript-example' => 'Tèxto en segno',
	'wikieditor-toolbar-group-insert' => 'Entrebetar',
	'wikieditor-toolbar-tool-gallery' => 'Galerie d’émâges',
	'wikieditor-toolbar-tool-gallery-example' => '$1:Ègzemplo.jpg|Dèscripcion 1
$1:Ègzemplo.jpg|Dèscripcion 2',
	'wikieditor-toolbar-tool-newline' => 'Sôt de legne',
	'wikieditor-toolbar-tool-table' => 'Tablô',
	'wikieditor-toolbar-tool-table-example-old' => '-
! en-téta 1
! en-téta 2
! en-téta 3
|-
| legne 1, câsa 1
| legne 1, câsa 2
| legne 1, câsa 3
|-
| legne 2, câsa 1
| legne 2, câsa 2
| legne 2, câsa 3',
	'wikieditor-toolbar-tool-table-example-cell-text' => 'Tèxto de la cèlula',
	'wikieditor-toolbar-tool-table-example-header' => 'Tèxto de l’en-téta',
	'wikieditor-toolbar-tool-table-title' => 'Entrebetar un tablô',
	'wikieditor-toolbar-tool-table-dimensions-rows' => 'Legnes',
	'wikieditor-toolbar-tool-table-dimensions-columns' => 'Colones',
	'wikieditor-toolbar-tool-table-dimensions-header' => 'Encllure la legne d’en-téta',
	'wikieditor-toolbar-tool-table-wikitable' => 'Stilo avouéc bordures',
	'wikieditor-toolbar-tool-table-sortable' => 'Rendre lo tablô triâblo',
	'wikieditor-toolbar-tool-table-example' => 'Ègzemplo',
	'wikieditor-toolbar-tool-table-preview' => 'Prèvisualisacion',
	'wikieditor-toolbar-tool-table-insert' => 'Entrebetar',
	'wikieditor-toolbar-tool-table-cancel' => 'Anular',
	'wikieditor-toolbar-tool-table-toomany' => 'O est pas possiblo d’entrebetar un tablô de més de $1 cèlules avouéc cél outil.',
	'wikieditor-toolbar-tool-table-invalidnumber' => 'Vos éd pas buchiê un nombro de legnes ou ben de colones valido.',
	'wikieditor-toolbar-tool-table-zero' => 'Vos pouede pas entrebetar un tablô sen legne ou ben sen colona.',
	'wikieditor-toolbar-tool-replace' => 'Rechèrchiér et pués remplaciér',
	'wikieditor-toolbar-tool-replace-title' => 'Rechèrchiér et pués remplaciér',
	'wikieditor-toolbar-tool-replace-search' => 'Rechèrchiér :',
	'wikieditor-toolbar-tool-replace-replace' => 'Remplaciér avouéc :',
	'wikieditor-toolbar-tool-replace-case' => 'Fâre corrèspondre la câssa',
	'wikieditor-toolbar-tool-replace-regex' => 'Trètar la chêna de rechèrche coment una èxprèssion racionèla',
	'wikieditor-toolbar-tool-replace-button-findnext' => 'Rechèrchiér celi d’aprés',
	'wikieditor-toolbar-tool-replace-button-replace' => 'Remplaciér',
	'wikieditor-toolbar-tool-replace-button-replaceall' => 'Remplaciér tot',
	'wikieditor-toolbar-tool-replace-close' => 'Cllôre',
	'wikieditor-toolbar-tool-replace-nomatch' => 'Voutra rechèrche at trovâ gins de corrèspondance.',
	'wikieditor-toolbar-tool-replace-success' => '$1 remplacements fêts.',
	'wikieditor-toolbar-tool-replace-emptysearch' => 'Vos éd buchiê gins de tèxto a rechèrchiér.',
	'wikieditor-toolbar-tool-replace-invalidregex' => 'L’èxprèssion racionèla buchiê est envalida : $1',
	'wikieditor-toolbar-section-characters' => 'Caractèros spèciâls',
	'wikieditor-toolbar-characters-page-latin' => 'Latin',
	'wikieditor-toolbar-characters-page-latinextended' => 'Latin ètendu',
	'wikieditor-toolbar-characters-page-ipa' => 'AFE (IPA)',
	'wikieditor-toolbar-characters-page-symbols' => 'Simbolos',
	'wikieditor-toolbar-characters-page-greek' => 'Grèco',
	'wikieditor-toolbar-characters-page-cyrillic' => 'Cirilico',
	'wikieditor-toolbar-characters-page-arabic' => 'Arabo',
	'wikieditor-toolbar-characters-page-arabicextended' => 'Arabo ètendu',
	'wikieditor-toolbar-characters-page-persian' => 'Pèrsan',
	'wikieditor-toolbar-characters-page-hebrew' => 'Hèbrèo',
	'wikieditor-toolbar-characters-page-bangla' => 'Bengali',
	'wikieditor-toolbar-characters-page-tamil' => 'Tamoul',
	'wikieditor-toolbar-characters-page-telugu' => 'Tèlougou',
	'wikieditor-toolbar-characters-page-sinhala' => 'Cingalês',
	'wikieditor-toolbar-characters-page-gujarati' => 'Goudjarati',
	'wikieditor-toolbar-characters-page-devanagari' => 'Devanagari',
	'wikieditor-toolbar-characters-page-thai' => 'Tayi',
	'wikieditor-toolbar-characters-page-lao' => 'Lao',
	'wikieditor-toolbar-characters-page-khmer' => 'C’mère',
	'wikieditor-toolbar-section-help' => 'Éde',
	'wikieditor-toolbar-help-heading-description' => 'Dèscripcion',
	'wikieditor-toolbar-help-heading-syntax' => 'Cen que vos buchiéd',
	'wikieditor-toolbar-help-heading-result' => 'Cen que vos avéd',
	'wikieditor-toolbar-help-page-format' => 'Formatâjo',
	'wikieditor-toolbar-help-page-link' => 'Lims',
	'wikieditor-toolbar-help-page-heading' => 'Titros',
	'wikieditor-toolbar-help-page-list' => 'Listes',
	'wikieditor-toolbar-help-page-file' => 'Fichiérs',
	'wikieditor-toolbar-help-page-reference' => 'Refèrences',
	'wikieditor-toolbar-help-page-discussion' => 'Discussion',
	'wikieditor-toolbar-help-content-italic-description' => 'Étalico',
	'wikieditor-toolbar-help-content-italic-syntax' => "''Tèxto en étalico''",
	'wikieditor-toolbar-help-content-italic-result' => '<em>Tèxto en étalico</em>',
	'wikieditor-toolbar-help-content-bold-description' => 'Grâs',
	'wikieditor-toolbar-help-content-bold-syntax' => "'''Tèxto en grâs'''",
	'wikieditor-toolbar-help-content-bold-result' => '<strong>Tèxto en grâs</strong>',
	'wikieditor-toolbar-help-content-bolditalic-description' => 'Grâs &amp; étalico',
	'wikieditor-toolbar-help-content-bolditalic-syntax' => "'''''Tèxto en grâs &amp; en étalico'''''",
	'wikieditor-toolbar-help-content-bolditalic-result' => '<strong><em>Tèxto en grâs &amp; en étalico</em></strong>',
	'wikieditor-toolbar-help-content-ilink-description' => 'Lim de dedens',
	'wikieditor-toolbar-help-content-ilink-syntax' => '[[Titro de la pâge|Tèxto du lim]]<br />[[Titro de la pâge]]',
	'wikieditor-toolbar-help-content-ilink-result' => "<a href='#'>Tèxto du lim</a><br /><a href='#'>Titro de la pâge</a>",
	'wikieditor-toolbar-help-content-xlink-description' => 'Lim de defôr',
	'wikieditor-toolbar-help-content-xlink-syntax' => '[http://www.example.org Tèxto du lim]<br />[http://www.example.org]<br />http://www.example.org',
	'wikieditor-toolbar-help-content-xlink-result' => "<a href='#' class='external'>Tèxto du lim</a><br /><a href='#' class='external autonumber'>[1]</a><br /><a href='#' class='external'>http://www.example.org</a>",
	'wikieditor-toolbar-help-content-heading2-description' => 'Titro de 2<sup>nd</sup> nivél',
	'wikieditor-toolbar-help-content-heading2-syntax' => '== Tèxto du titro ==',
	'wikieditor-toolbar-help-content-heading2-result' => '<h2>Tèxto du titro</h2>',
	'wikieditor-toolbar-help-content-heading3-description' => 'Titro de 3<sup>émo</sup> nivél',
	'wikieditor-toolbar-help-content-heading3-syntax' => '=== Tèxto du titro ===',
	'wikieditor-toolbar-help-content-heading3-result' => '<h3>Tèxto du titro</h3>',
	'wikieditor-toolbar-help-content-heading4-description' => 'Titro de 4<sup>émo</sup> nivél',
	'wikieditor-toolbar-help-content-heading4-syntax' => '==== Tèxto du titro ====',
	'wikieditor-toolbar-help-content-heading4-result' => '<h4>Tèxto du titro</h4>',
	'wikieditor-toolbar-help-content-heading5-description' => 'Titro de 5<sup>émo</sup> nivél',
	'wikieditor-toolbar-help-content-heading5-syntax' => '===== Tèxto du titro =====',
	'wikieditor-toolbar-help-content-heading5-result' => '<h5>Tèxto du titro</h5>',
	'wikieditor-toolbar-help-content-ulist-description' => 'Lista de puges',
	'wikieditor-toolbar-help-content-ulist-syntax' => '* Èlèment de la lista<br />* Èlèment de la lista',
	'wikieditor-toolbar-help-content-ulist-result' => '<ul><li>Èlèment de la lista</li><li>Èlèment de la lista</li></ul>',
	'wikieditor-toolbar-help-content-olist-description' => 'Lista numerotâ',
	'wikieditor-toolbar-help-content-olist-syntax' => '# Èlèment de la lista<br /># Èlèment de la lista',
	'wikieditor-toolbar-help-content-olist-result' => '<ol><li>Èlèment de la lista</li><li>Èlèment de la lista</li></ol>',
	'wikieditor-toolbar-help-content-file-description' => 'Fichiér entrebetâ',
	'wikieditor-toolbar-help-content-file-syntax' => '[[$1:Ègzemplo.png|thumb|Tèxto montrâ]]',
	'wikieditor-toolbar-help-content-file-result' => "<div style='width:104px;' class='thumbinner'><a title='Tèxto montrâ' class='image' href='#'><img height='50' width='100' border='0' class='thumbimage' src='$2/WikiEditor/modules/images/toolbar/example-image.png' alt=''/></a><div class='thumbcaption'><div class='magnify'><a title='Agrantir' class='internal' href='#'><img height='11' width='15' alt='' src='$1/common/images/magnify-clip.png'/></a></div>Tèxto montrâ</div></div>",
	'wikieditor-toolbar-help-content-reference-description' => 'Refèrence',
	'wikieditor-toolbar-help-content-reference-syntax' => 'Tèxto de la pâge.&lt;ref name="test"&gt;[http://www.example.org tèxto du lim], tèxto de ples.&lt;/ref&gt;',
	'wikieditor-toolbar-help-content-reference-result' => "Tèxto de la pâge.<sup><a href='#'>[1]</a></sup>",
	'wikieditor-toolbar-help-content-rereference-description' => 'Usâjo de ples de la méma refèrence',
	'wikieditor-toolbar-help-content-rereference-result' => "Tèxto de la pâge.<sup><a href='#'>[1]</a></sup>",
	'wikieditor-toolbar-help-content-showreferences-description' => 'Fâre vêre les refèrences',
	'wikieditor-toolbar-help-content-showreferences-result' => "<ol class='references'><li id='cite_note-test-0'><b><a title='' href='#'>^</a></b> <a rel='nofollow' title='http://www.example.org' class='external text' href='#'>Tèxto du lim</a>, tèxto de ples.</li></ol>",
	'wikieditor-toolbar-help-content-signaturetimestamp-description' => 'Signatura avouéc dâta',
	'wikieditor-toolbar-help-content-signaturetimestamp-result' => "<a href='#' title='{{#special:mypage}}'>Nom d’usanciér</a> (<a href='#' title='{{#special:mytalk}}'>discutar</a>) 10 de jouen 2009 a 15:54 (UTC)",
	'wikieditor-toolbar-help-content-signature-description' => 'Signatura',
	'wikieditor-toolbar-help-content-signature-result' => "<a href='#' title='{{#special:mypage}}'>Nom d’usanciér</a> (<a href='#' title='{{#special:mytalk}}'>discutar</a>)",
	'wikieditor-toolbar-help-content-indent-description' => 'Endentacion',
	'wikieditor-toolbar-help-content-indent-syntax' => 'Tèxto normal<br />:Tèxto endentâ<br />::Tèxto endentâ',
	'wikieditor-toolbar-help-content-indent-result' => 'Tèxto normal<dl><dd>Tèxto endentâ<dl><dd>Tèxto endentâ</dd></dl></dd></dl>',
);

/** Friulian (furlan)
 * @author Klenje
 */
$messages['fur'] = array(
	'wikieditor-preview-tab' => 'Anteprime',
	'wikieditor-preview-changes-tab' => 'Cambiaments',
	'wikieditor-preview-loading' => 'Daûr a cjamâ…',
	'wikieditor-previewDialog-tab' => 'Anteprime',
	'wikieditor-previewDialog-loading' => 'Daûr a cjamâ…',
	'wikieditor-toolbar-loading' => 'Daûr a cjamâ…',
	'wikieditor-toolbar-tool-bold' => 'Gruessut',
	'wikieditor-toolbar-tool-bold-example' => 'Test in gruessut',
	'wikieditor-toolbar-tool-italic' => 'Corsîf',
	'wikieditor-toolbar-tool-italic-example' => 'Test in corsîf',
	'wikieditor-toolbar-tool-ilink' => 'Leam interni',
	'wikieditor-toolbar-tool-ilink-example' => 'Titul dal leam',
	'wikieditor-toolbar-tool-link' => 'Leam',
	'wikieditor-toolbar-tool-table-preview' => 'Anteprime',
	'wikieditor-toolbar-characters-page-symbols' => 'Simbols',
	'wikieditor-toolbar-section-help' => 'Jutori',
);

/** Western Frisian (Frysk) */
$messages['fy'] = array(
	'wikieditor-toolbar-tool-link-cancel' => 'Ofbrekke',
);

/** Irish (Gaeilge)
 * @author පසිඳු කාවින්ද
 */
$messages['ga'] = array(
	'wikieditor-loading' => 'Ag Lódáil....',
	'wikieditor-preview-tab' => 'Réamhamharc',
	'wikieditor-preview-loading' => 'Ag Lódáil....',
	'wikieditor-previewDialog-tab' => 'Réamhamharc',
	'wikieditor-previewDialog-loading' => 'Ag Lódáil....',
	'wikieditor-publish-button-cancel' => 'Cealaigh',
	'wikieditor-template-editor-dialog-cancel' => 'Cealaigh',
	'wikieditor-toolbar-loading' => 'Ag Lódáil....',
	'wikieditor-toolbar-tool-link-cancel' => 'Cealaigh',
	'wikieditor-toolbar-file-format' => 'Formáid:',
	'wikieditor-toolbar-tool-file-cancel' => 'Cealaigh',
	'wikieditor-toolbar-tool-reference-cancel' => 'Cealaigh',
	'wikieditor-toolbar-group-format' => 'Formáid',
	'wikieditor-toolbar-tool-table-preview' => 'Réamhamharc',
	'wikieditor-toolbar-tool-table-cancel' => 'Cealaigh',
	'wikieditor-toolbar-tool-replace-close' => 'Dún',
	'wikieditor-toolbar-section-help' => 'Cuidiú',
	'wikieditor-toolbar-help-page-file' => 'Comhaid',
	'wikieditor-toolbar-help-page-discussion' => 'Plé',
	'wikieditor-toolbar-help-content-signature-description' => 'Síniú',
);

/** Scottish Gaelic (Gàidhlig)
 * @author Akerbeltz
 */
$messages['gd'] = array(
	'wikieditor' => 'Eadar-aghaidh deasachadh wikitext adhartach',
	'wikieditor-desc' => 'Bheir seo dhut eadar-aghaidh deasachadh wikitext adhartach agus iomadh mòideal a bheir dhut feartan',
	'wikieditor-wikitext-tab' => 'Wikitext',
	'wikieditor-loading' => "'Ga luchdadh",
	'wikieditor-preview-preference' => 'Cuir an comas ro-shealladh taobh ri taobh',
	'wikieditor-preview-tab' => 'Ro-shealladh',
	'wikieditor-preview-changes-tab' => 'Mùthaidhean',
	'wikieditor-preview-loading' => "'Ga luchdadh...",
	'wikieditor-previewDialog-preference' => 'Cuir an comas còmhradh an ro-sheallaidh',
	'wikieditor-previewDialog-tab' => 'Ro-shealladh',
	'wikieditor-previewDialog-loading' => "'Ga luchdadh...",
	'wikieditor-publish-preference' => 'Cuir an comas foillseachadh ceum air cheum',
	'wikieditor-publish-button-publish' => 'Foillisch',
	'wikieditor-publish-button-cancel' => 'Sguir dheth',
	'wikieditor-publish-dialog-title' => 'Foillsich gu {{SITENAME}}',
	'wikieditor-publish-dialog-summary' => 'Gearr-chunntas an deasachaidh (mìnich na rinn thu gu goirid):',
	'wikieditor-publish-dialog-minor' => 'Mùthadh beag',
	'wikieditor-publish-dialog-watch' => 'Cum sùil air an duilleag seo',
	'wikieditor-publish-dialog-publish' => 'Foillisch',
	'wikieditor-publish-dialog-goback' => 'Air ais',
	'wikieditor-template-editor-preference' => 'Cuir an comas deasachadh de theamplaidean wiki stèidhichte air foirmean',
	'wikieditor-template-editor-dialog-title' => 'Deasaich an teamplaid',
	'wikieditor-template-editor-dialog-submit' => 'Ùraich',
	'wikieditor-template-editor-dialog-cancel' => 'Sguir dheth',
	'wikieditor-templates-preference' => 'Cuir an comas dùmhlachadh theamplaidean',
	'wikieditor-toc-preference' => 'Cuir clàr-innse an comas a ghabhas a sheòladh',
	'wikieditor-toc-show' => 'Seall an clàr-innse',
	'wikieditor-toc-hide' => 'Cuir am falach an clàr-innse',
	'wikieditor-toolbar' => 'Am bàr-inneil deasachaidh',
	'wikieditor-toolbar-desc' => 'Am bàr-inneil deasachaidh le comasan a bharrachd',
	'wikieditor-toolbar-preference' => 'Cuir am bàr-inneil le comasan a bharrachd an comas',
	'wikieditor-toolbar-dialogs-preference' => 'Cuir an comas na còmhraidhean airson ceanglaichean, clàir is rudan eile a chur a-steach',
	'wikieditor-toolbar-loading' => "'Ga luchdadh...",
	'wikieditor-toolbar-tool-bold' => 'Trom',
	'wikieditor-toolbar-tool-bold-example' => 'Teacs trom',
	'wikieditor-toolbar-tool-italic' => 'Clò Eadailteach',
	'wikieditor-toolbar-tool-italic-example' => 'Teacsa Eadailteach',
	'wikieditor-toolbar-tool-ilink' => 'Ceangal am broinn na làraich',
	'wikieditor-toolbar-tool-ilink-example' => "Tiotal a' cheangail",
	'wikieditor-toolbar-tool-xlink' => 'Ceangal dhan taobh a-muigh (cuimhnich an ro-leasachan http://)',
	'wikieditor-toolbar-tool-xlink-example' => "http://www.example.com tiotal a' cheangail",
	'wikieditor-toolbar-tool-link' => 'Ceangail',
	'wikieditor-toolbar-tool-link-title' => 'Cuir a-steach ceangal',
	'wikieditor-toolbar-tool-link-int' => 'Ri duilleag wiki',
	'wikieditor-toolbar-tool-link-int-target' => 'Duilleag amais no URL:',
	'wikieditor-toolbar-tool-link-int-target-tooltip' => 'Tiotal duilleige no URL',
	'wikieditor-toolbar-tool-link-int-text' => 'Teacsa ri shealltainn:',
	'wikieditor-toolbar-tool-link-int-text-tooltip' => 'Teacsa ri shealltainn:',
	'wikieditor-toolbar-tool-link-ext' => 'Ri duilleag-lìn air an taobh a-muigh',
	'wikieditor-toolbar-tool-link-ext-target' => "URL a' cheangail:",
	'wikieditor-toolbar-tool-link-ext-text' => "Teacsa a' cheangail:",
	'wikieditor-toolbar-tool-link-insert' => 'Cuir a-steach ceangal',
	'wikieditor-toolbar-tool-link-cancel' => 'Cancel',
	'wikieditor-toolbar-tool-link-int-target-status-exists' => 'Duilleag ann mu thràth',
	'wikieditor-toolbar-tool-link-int-target-status-notexists' => 'Chan eil an duilleag ann',
	'wikieditor-toolbar-tool-link-int-target-status-invalid' => 'Tiotal mì-dhligheach',
	'wikieditor-toolbar-tool-link-int-target-status-external' => 'Ceangal dhan taobh a-muigh',
	'wikieditor-toolbar-tool-link-int-target-status-loading' => "A' toirt sùil ach a bheil an duilleag ann mu thràth...",
	'wikieditor-toolbar-tool-link-int-invalid' => 'Tha an tiotal a shònraich thu mì-dhligheach.',
	'wikieditor-toolbar-tool-link-lookslikeinternal' => 'Tha coltas aig an URL a shònraich thu gun robh dùil agad ceangal a dhèanamh ri duilleag wiki eile.
A bheil thu airson ceangal am broinn na làraich a dhèanamh dheth?',
	'wikieditor-toolbar-tool-link-lookslikeinternal-int' => 'Ceangal am broinn na làraich',
	'wikieditor-toolbar-tool-link-lookslikeinternal-ext' => 'Ceangal dhan taobh a-muigh',
	'wikieditor-toolbar-tool-link-empty' => 'Cha do chuir thu càil a-steach as urrainnear ceangal a dhèanamh ris.',
	'wikieditor-toolbar-tool-file' => 'Faidhle air a leabachadh',
	'wikieditor-toolbar-tool-file-example' => 'Ball-sampaill.jpg',
	'wikieditor-toolbar-tool-reference' => 'Iomradh',
	'wikieditor-toolbar-tool-reference-example' => "Cuir teacsa a' bhun-nòta an-seo",
	'wikieditor-toolbar-tool-reference-cancel' => 'Sguir dheth',
	'wikieditor-toolbar-tool-reference-title' => 'Cuir a-steach iomradh',
	'wikieditor-toolbar-tool-reference-insert' => 'Cuir a-steach',
	'wikieditor-toolbar-tool-reference-text' => 'Teacsa an iomraidh',
	'wikieditor-toolbar-tool-signature' => 'Ainm sgrìobhte is stampa-ama',
	'wikieditor-toolbar-section-advanced' => 'Adhartach',
	'wikieditor-toolbar-tool-heading' => 'Ceann-sgrìobhaidh',
	'wikieditor-toolbar-tool-heading-1' => 'Leibheil 1',
	'wikieditor-toolbar-tool-heading-2' => 'Leibheil 2',
	'wikieditor-toolbar-tool-heading-3' => 'Leibheil 3',
	'wikieditor-toolbar-tool-heading-4' => 'Leibheil 4',
	'wikieditor-toolbar-tool-heading-5' => 'Leibheil 5',
	'wikieditor-toolbar-tool-heading-example' => "Teacsa a' chinn-loidhne",
	'wikieditor-toolbar-group-format' => 'Fòrmat',
	'wikieditor-toolbar-tool-ulist' => 'Liosta pheilearaichte',
	'wikieditor-toolbar-tool-ulist-example' => 'Ball de liosta pheilearaichte',
	'wikieditor-toolbar-tool-olist' => 'Liosta àireamhaichte',
	'wikieditor-toolbar-tool-olist-example' => 'Ball de liosta àireamhaichte',
	'wikieditor-toolbar-tool-indent' => 'Eagadh',
	'wikieditor-toolbar-tool-indent-example' => 'Loidhne eagaichte',
	'wikieditor-toolbar-tool-nowiki' => 'Gun fhòrmatadh wiki',
	'wikieditor-toolbar-tool-nowiki-example' => 'Cuir a-steach teacsa gun fhòrmatadh an-seo',
	'wikieditor-toolbar-tool-redirect' => 'Ath-sheòl',
	'wikieditor-toolbar-tool-redirect-example' => 'Ainm na duilleige-amais',
	'wikieditor-toolbar-tool-big' => 'Mòr',
	'wikieditor-toolbar-tool-big-example' => 'Teacsa mòr',
	'wikieditor-toolbar-tool-small' => 'Beag',
	'wikieditor-toolbar-tool-small-example' => 'Teacsa beag',
	'wikieditor-toolbar-tool-superscript' => 'Os-sgrìobhte',
	'wikieditor-toolbar-tool-superscript-example' => 'Teacsa os-sgrìobhte',
	'wikieditor-toolbar-tool-subscript' => 'Fo-sgrìobhte',
	'wikieditor-toolbar-tool-subscript-example' => 'Teacsa fo-sgrìobhte',
	'wikieditor-toolbar-group-insert' => 'Cuir a-steach',
	'wikieditor-toolbar-tool-gallery' => 'Gailearaidh nan dealbh',
	'wikieditor-toolbar-tool-gallery-example' => '$1:Ballsampaill.jpg|Mìneachadh an deilbh1
$1:Ballsampaill.jpg|Mìneachadh an deilbh2',
	'wikieditor-toolbar-tool-newline' => 'Loidhne ùr',
	'wikieditor-toolbar-tool-table' => 'Clàr',
	'wikieditor-toolbar-tool-table-example-old' => '-
! bann-cinn 1
! bann-cinn 2
! bann-cinn 3
|-
| sreath 1, cealla 1
| sreath 1, cealla 2
| sreath 1, cealla 3
|-
| sreath 2, cealla 1
| sreath 2, cealla 2
| sreath 2, cealla 3',
	'wikieditor-toolbar-tool-table-example-cell-text' => 'Teacsa na cealla',
	'wikieditor-toolbar-tool-table-example-header' => "Teacsa a' bhanna-chinn",
	'wikieditor-toolbar-tool-table-title' => 'Cuir a-steach clàr',
	'wikieditor-toolbar-tool-table-dimensions-rows' => 'Sreathan',
	'wikieditor-toolbar-tool-table-dimensions-columns' => 'Colbhan',
	'wikieditor-toolbar-tool-table-dimensions-header' => 'Cuir ris sreath-cinn',
	'wikieditor-toolbar-tool-table-wikitable' => 'Stoidhle le iomallan',
	'wikieditor-toolbar-tool-table-sortable' => 'Dèan clàr dheth a ghabhas a sheòrsachadh',
	'wikieditor-toolbar-tool-table-example' => 'Ball-sampaill',
	'wikieditor-toolbar-tool-table-preview' => 'Ro-shealladh',
	'wikieditor-toolbar-tool-table-insert' => 'Cuir a-steach',
	'wikieditor-toolbar-tool-table-cancel' => 'Sguir dheth',
	'wikieditor-toolbar-tool-table-toomany' => "Chan urrainn dhut clàr le barrachd air $1 ceallan a chur a-steach leis a' chòmhradh seo.",
	'wikieditor-toolbar-tool-table-invalidnumber' => 'Cha do chuir thu a-steach àireamh cheadaichte de shreathan is de cholbhan.',
	'wikieditor-toolbar-tool-table-zero' => 'Chan urrainn dhut clàr a chur a-steach aig nach eil sreath no colbh.',
	'wikieditor-toolbar-tool-replace' => "Lorg is cuir 'na àite",
	'wikieditor-toolbar-tool-replace-title' => "Lorg is cuir 'na àite",
	'wikieditor-toolbar-tool-replace-search' => 'Lorg na leanas:',
	'wikieditor-toolbar-tool-replace-replace' => "Cuir na leanas 'na àite:",
	'wikieditor-toolbar-tool-replace-case' => 'Maids an ceas',
	'wikieditor-toolbar-tool-replace-regex' => 'Dèilig ris an t-sreath luirg mar regular expression',
	'wikieditor-toolbar-tool-replace-button-findnext' => 'Lorg an ath-fhear',
	'wikieditor-toolbar-tool-replace-button-replaceall' => 'Cuir an àite gach aon dhiubh',
	'wikieditor-toolbar-tool-replace-close' => 'Dùin',
	'wikieditor-toolbar-tool-replace-nomatch' => 'Cha do fhreagair an lorg agad ri rud sam bith.',
	'wikieditor-toolbar-tool-replace-success' => 'Chaidh rud ùr a chur an àite $1 dhiubh.',
	'wikieditor-toolbar-tool-replace-emptysearch' => 'Cha do chuir thu càil a-steach as urrainnear lorg.',
	'wikieditor-toolbar-tool-replace-invalidregex' => 'Tha an regular expression a chuir thu a-steach mì-dhligheach: $1',
	'wikieditor-toolbar-section-characters' => 'Caractairean sònraichte',
	'wikieditor-toolbar-characters-page-latin' => 'Laideann',
	'wikieditor-toolbar-characters-page-latinextended' => 'Laideann leudaichte',
	'wikieditor-toolbar-characters-page-ipa' => 'IPA',
	'wikieditor-toolbar-characters-page-symbols' => 'Siombalan',
	'wikieditor-toolbar-characters-page-greek' => 'Greugais',
	'wikieditor-toolbar-characters-page-cyrillic' => 'Cirilis',
	'wikieditor-toolbar-characters-page-arabic' => 'Arabais',
	'wikieditor-toolbar-characters-page-persian' => 'Farsaidh',
	'wikieditor-toolbar-characters-page-hebrew' => 'Eabhra',
	'wikieditor-toolbar-characters-page-bangla' => 'Bangla',
	'wikieditor-toolbar-characters-page-telugu' => 'Telugu',
	'wikieditor-toolbar-characters-page-sinhala' => 'Sinhala',
	'wikieditor-toolbar-characters-page-gujarati' => 'Gujarati',
	'wikieditor-toolbar-section-help' => 'Help',
	'wikieditor-toolbar-help-heading-description' => 'Tuairisgeul',
	'wikieditor-toolbar-help-heading-syntax' => 'Na chuireas tu a-steach',
	'wikieditor-toolbar-help-heading-result' => 'Na gheibh thu',
	'wikieditor-toolbar-help-page-format' => 'Fòrmatadh',
	'wikieditor-toolbar-help-page-link' => 'Ceanglaichean',
	'wikieditor-toolbar-help-page-heading' => 'Ceann-sgrìobhaidhean',
	'wikieditor-toolbar-help-page-list' => 'Liostaichean',
	'wikieditor-toolbar-help-page-file' => 'Faidhlichean',
	'wikieditor-toolbar-help-page-reference' => 'Iomraidhean',
	'wikieditor-toolbar-help-page-discussion' => 'Deasbaireachd',
	'wikieditor-toolbar-help-content-italic-description' => 'Eadailteach',
	'wikieditor-toolbar-help-content-italic-syntax' => "''Teacsa Eadailteach''",
	'wikieditor-toolbar-help-content-italic-result' => '<em>Teacsa Eadailteach</em>',
	'wikieditor-toolbar-help-content-bold-description' => 'Trom',
	'wikieditor-toolbar-help-content-bold-syntax' => "'''Teacsa trom'''",
	'wikieditor-toolbar-help-content-bold-result' => '<strong>Teacsa trom</strong>',
	'wikieditor-toolbar-help-content-bolditalic-description' => 'Trom ┐ Eadailteach',
	'wikieditor-toolbar-help-content-bolditalic-syntax' => "'''''Teacsa trom ┐ Eadailteach'''''",
	'wikieditor-toolbar-help-content-bolditalic-result' => '<strong><em>Teacsa trom ┐ Eadailteach</em></strong>',
	'wikieditor-toolbar-help-content-ilink-description' => 'Ceangal am broinn na làraich',
	'wikieditor-toolbar-help-content-ilink-syntax' => "[[Tiotal na duilleige|Leubail a' cheangail]]<br />[[Tiotal na duilleige]]",
	'wikieditor-toolbar-help-content-ilink-result' => "<a href='#'>Leubail a' cheangail</a><br /><a href='#'>Tiotal na duillege</a>",
	'wikieditor-toolbar-help-content-xlink-description' => 'Ceangal dhan taobh a-muigh',
	'wikieditor-toolbar-help-content-xlink-syntax' => "[http://www.ballsampaill.org Leubail a' cheangail]<br />[http://www.ballsampaill.org]<br />http://www.ballsampaill.org",
	'wikieditor-toolbar-help-content-xlink-result' => "<a href='#' class='external'>Leubail a' cheangail</a><br /><a href='#' class='external autonumber'>[1]</a><br /><a href='#' class='external'>http://www.ballsampaill.org</a>",
	'wikieditor-toolbar-help-content-heading2-description' => 'Ceann-sgrìobhaidh dhen 2na ìre',
	'wikieditor-toolbar-help-content-heading2-syntax' => "== Teacsa a' chinn-sgrìobhaidh ==",
	'wikieditor-toolbar-help-content-heading2-result' => "<h2>Teacsa a' chinn-sgrìobhaidh</h2>",
	'wikieditor-toolbar-help-content-heading3-description' => 'Ceann-sgrìobhaidh dhen 3s ìre',
	'wikieditor-toolbar-help-content-heading3-syntax' => "=== Teacsa a' chinn-sgrìobhaidh ===",
	'wikieditor-toolbar-help-content-heading3-result' => "<h3>Teacsa a' chinn-sgrìobhaidh</h3>",
	'wikieditor-toolbar-help-content-heading4-description' => 'Ceann-sgrìobhaidh dhen 4mh ìre',
	'wikieditor-toolbar-help-content-heading4-syntax' => "==== Teacsa a' chinn-sgrìobhaidh ====",
	'wikieditor-toolbar-help-content-heading4-result' => "<h4>Teacsa a' chinn-sgrìobhaidh</h4>",
	'wikieditor-toolbar-help-content-heading5-description' => 'Ceann-sgrìobhaidh dhen 5mh ìre',
	'wikieditor-toolbar-help-content-heading5-syntax' => "===== Teacsa a' chinn-sgrìobhaidh =====",
	'wikieditor-toolbar-help-content-heading5-result' => "<h5>Teacsa a' chinn-sgrìobhaidh</h5>",
	'wikieditor-toolbar-help-content-ulist-description' => 'Liosta pheilearaichte',
	'wikieditor-toolbar-help-content-ulist-syntax' => '* Ball na liosta<br />* Ball na liosta',
	'wikieditor-toolbar-help-content-ulist-result' => '<ul><li>Ball na liosta</li><li>Ball na liosta</li></ul>',
	'wikieditor-toolbar-help-content-olist-description' => 'Liosta àireamhaichte',
	'wikieditor-toolbar-help-content-olist-syntax' => '* Ball na liosta<br />* Ball na liosta',
	'wikieditor-toolbar-help-content-olist-result' => '<ol><li>Ball na liosta</li><li>Ball na liosta</li></ol>',
	'wikieditor-toolbar-help-content-file-description' => 'Embedded file',
	'wikieditor-toolbar-help-content-file-syntax' => '[[$1:Ballsampaill.png|thumb|Mìneachadh an deilbh]]',
	'wikieditor-toolbar-help-content-file-result' => "<div style='width:104px;' class='thumbinner'><a title='Mìneachadh an deilbht' class='image' href='#'><img height='50' width='100' border='0' class='thumbimage' src='$2/WikiEditor/modules/images/toolbar/example-image.png' alt=''/></a><div class='thumbcaption'><div class='magnify'><a title='Meudaich' class='internal' href='#'><img height='11' width='15' alt='' src='$1/common/images/magnify-clip.png'/></a></div>Mìneachadh an deilbh</div></div>",
	'wikieditor-toolbar-help-content-reference-description' => 'Iomradh',
	'wikieditor-toolbar-help-content-reference-syntax' => 'Teacsa na duilleige.&lt;ref name="test"&gt;[http://www.ballsampaill.org Teacsa a\' cheangail], teacsa eile.&lt;/ref&gt;',
	'wikieditor-toolbar-help-content-reference-result' => "Teacsa na duilleige.<sup><a href='#'>[1]</a></sup>",
	'wikieditor-toolbar-help-content-rereference-description' => 'Cleachdadh eile an dearbh iomraidh',
	'wikieditor-toolbar-help-content-rereference-result' => "Teacsa na duilleige.<sup><a href='#'>[1]</a></sup>",
	'wikieditor-toolbar-help-content-showreferences-description' => 'Seall na h-iomraidhean',
	'wikieditor-toolbar-help-content-showreferences-result' => "<ol class='iomraidhean'><li id='cite_note-test-0'><b><a title='' href='#'>^</a></b> <a rel='nofollow' title='http://www.ballsampaill.org' class='external text' href='#'>Teacsa a' cheangail</a>, teacsa eile.</li></ol>",
	'wikieditor-toolbar-help-content-signaturetimestamp-description' => 'Ainm sgrìobhte le stampa-ama',
	'wikieditor-toolbar-help-content-signaturetimestamp-result' => "<a href='#' title='{{#special:mypage}}'>Ainm-cleachdaiche</a> (<a href='#' title='{{#special:mytalk}}'>conaltradh</a>) 15:54, 10 dhen Ògmhios 2009 (UTC)",
	'wikieditor-toolbar-help-content-signature-description' => 'Ainm-sgrìobhte',
	'wikieditor-toolbar-help-content-signature-result' => "<a href='#' title='{{#special:mypage}}'>Ainm-cleachdaiche</a> (<a href='#' title='{{#special:mytalk}}'>conaltradh</a>)",
	'wikieditor-toolbar-help-content-indent-description' => 'Eagaich a-steach',
	'wikieditor-toolbar-help-content-indent-syntax' => 'Teacsa àbhaisteach<br />:Teacsa air eagachadh a-steach<br />::Teacsa air eagachadh a-steach',
	'wikieditor-toolbar-help-content-indent-result' => 'Teacsa àbhaisteach<dl><dd>Teacsa air eagachadh a-steach<dl><dd>Teacsa air eagachadh a-steach</dd></dl></dd></dl>',
);

/** Galician (galego)
 * @author Toliño
 */
$messages['gl'] = array(
	'wikieditor' => 'Interface avanzada de edición de texto wiki',
	'wikieditor-desc' => 'Proporciona unha interface extensible de edición de texto wiki e moitas funcionalidades de módulos',
	'wikieditor-wikitext-tab' => 'Texto wiki',
	'wikieditor-loading' => 'Cargando',
	'wikieditor-preview-preference' => 'Activar a vista previa comparativa',
	'wikieditor-preview-tab' => 'Vista previa',
	'wikieditor-preview-changes-tab' => 'Cambios',
	'wikieditor-preview-loading' => 'Cargando...',
	'wikieditor-previewDialog-preference' => 'Activar o diálogo de vista previa',
	'wikieditor-previewDialog-tab' => 'Vista previa',
	'wikieditor-previewDialog-loading' => 'Cargando...',
	'wikieditor-publish-preference' => 'Activar a publicación paso a paso',
	'wikieditor-publish-button-publish' => 'Publicar',
	'wikieditor-publish-button-cancel' => 'Cancelar',
	'wikieditor-publish-dialog-title' => 'Publicar en {{SITENAME}}',
	'wikieditor-publish-dialog-summary' => 'Resumo de edición (describa brevemente os cambios que fixo):',
	'wikieditor-publish-dialog-minor' => 'Edición pequena',
	'wikieditor-publish-dialog-watch' => 'Vixiar esta páxina',
	'wikieditor-publish-dialog-publish' => 'Publicar',
	'wikieditor-publish-dialog-goback' => 'Volver',
	'wikieditor-template-editor-preference' => 'Activar a edición de modelos wiki baseada en formularios',
	'wikieditor-template-editor-dialog-title' => 'Editar o modelo',
	'wikieditor-template-editor-dialog-submit' => 'Actualizar',
	'wikieditor-template-editor-dialog-cancel' => 'Cancelar',
	'wikieditor-templates-preference' => 'Activar o enrolamento de modelos',
	'wikieditor-toc-preference' => 'Activar a táboa de contidos navegable',
	'wikieditor-toc-show' => 'Mostrar o contido',
	'wikieditor-toc-hide' => 'Agochar o contido',
	'wikieditor-toolbar' => 'Barra de ferramentas de edición',
	'wikieditor-toolbar-desc' => 'Editar a páxina da barra de ferramentas cunha mellor usabilidade',
	'wikieditor-toolbar-preference' => 'Activar a barra de ferramentas de edición mellorada',
	'wikieditor-toolbar-dialogs-preference' => 'Activar os diálogos para engadir ligazóns, táboas e máis',
	'wikieditor-toolbar-hidesig' => 'Agochar o botón de sinatura nas páxinas do espazo de nomes principal',
	'wikieditor-toolbar-loading' => 'Cargando...',
	'wikieditor-toolbar-tool-bold' => 'Negra',
	'wikieditor-toolbar-tool-bold-example' => 'Texto en negra',
	'wikieditor-toolbar-tool-italic' => 'Cursiva',
	'wikieditor-toolbar-tool-italic-example' => 'Texto en cursiva',
	'wikieditor-toolbar-tool-ilink' => 'Ligazón interna',
	'wikieditor-toolbar-tool-ilink-example' => 'Título da ligazón',
	'wikieditor-toolbar-tool-xlink' => 'Ligazón externa (lembre o prefixo http://)',
	'wikieditor-toolbar-tool-xlink-example' => 'http://www.example.com título da ligazón',
	'wikieditor-toolbar-tool-link' => 'Ligazón',
	'wikieditor-toolbar-tool-link-title' => 'Inserir unha ligazón',
	'wikieditor-toolbar-tool-link-int' => 'Cara a unha páxina wiki',
	'wikieditor-toolbar-tool-link-int-target' => 'Título da páxina:',
	'wikieditor-toolbar-tool-link-int-target-tooltip' => 'Título da páxina ou URL',
	'wikieditor-toolbar-tool-link-int-text' => 'Texto da ligazón:',
	'wikieditor-toolbar-tool-link-int-text-tooltip' => 'Insira o texto que se mostrará',
	'wikieditor-toolbar-tool-link-ext' => 'Cara a unha páxina web externa',
	'wikieditor-toolbar-tool-link-ext-target' => 'URL da ligazón:',
	'wikieditor-toolbar-tool-link-ext-text' => 'Texto da ligazón:',
	'wikieditor-toolbar-tool-link-insert' => 'Inserir a ligazón',
	'wikieditor-toolbar-tool-link-cancel' => 'Cancelar',
	'wikieditor-toolbar-tool-link-int-target-status-exists' => 'A páxina existe',
	'wikieditor-toolbar-tool-link-int-target-status-notexists' => 'A páxina non existe',
	'wikieditor-toolbar-tool-link-int-target-status-invalid' => 'Título non válido',
	'wikieditor-toolbar-tool-link-int-target-status-external' => 'Ligazón externa',
	'wikieditor-toolbar-tool-link-int-target-status-loading' => 'Comprobando a existencia da páxina...',
	'wikieditor-toolbar-tool-link-int-invalid' => 'O título que especificou non é válido.',
	'wikieditor-toolbar-tool-link-lookslikeinternal' => 'O enderezo URL que especificou semella ser unha ligazón cara a outra páxina do wiki.
Quere converter ese enderezo nunha ligazón interna?',
	'wikieditor-toolbar-tool-link-lookslikeinternal-int' => 'Ligazón interna',
	'wikieditor-toolbar-tool-link-lookslikeinternal-ext' => 'Ligazón externa',
	'wikieditor-toolbar-tool-link-empty' => 'Non inseriu nada co que ligar.',
	'wikieditor-toolbar-tool-file' => 'Ficheiro embelecido',
	'wikieditor-toolbar-tool-file-example' => 'Exemplo.jpg',
	'wikieditor-toolbar-tool-file-title' => 'Inserir un ficheiro',
	'wikieditor-toolbar-file-target' => 'Nome do ficheiro:',
	'wikieditor-toolbar-file-caption' => 'Pé de foto:',
	'wikieditor-toolbar-file-size' => 'Tamaño:',
	'wikieditor-toolbar-file-float' => 'Aliñamento:',
	'wikieditor-toolbar-file-default' => '(predeterminado)',
	'wikieditor-toolbar-file-format' => 'Formato:',
	'wikieditor-toolbar-file-format-none' => 'ningún',
	'wikieditor-toolbar-tool-file-insert' => 'Inserir',
	'wikieditor-toolbar-tool-file-cancel' => 'Cancelar',
	'wikieditor-toolbar-tool-reference' => 'Referencia',
	'wikieditor-toolbar-tool-reference-example' => 'Insira unha nota aquí',
	'wikieditor-toolbar-tool-reference-cancel' => 'Cancelar',
	'wikieditor-toolbar-tool-reference-title' => 'Inserir unha referencia',
	'wikieditor-toolbar-tool-reference-insert' => 'Inserir',
	'wikieditor-toolbar-tool-reference-text' => 'Texto da referencia',
	'wikieditor-toolbar-tool-signature' => 'Sinatura con data e hora',
	'wikieditor-toolbar-section-advanced' => 'Avanzado',
	'wikieditor-toolbar-tool-heading' => 'Cabeceira',
	'wikieditor-toolbar-tool-heading-1' => 'Nivel 1',
	'wikieditor-toolbar-tool-heading-2' => 'Nivel 2',
	'wikieditor-toolbar-tool-heading-3' => 'Nivel 3',
	'wikieditor-toolbar-tool-heading-4' => 'Nivel 4',
	'wikieditor-toolbar-tool-heading-5' => 'Nivel 5',
	'wikieditor-toolbar-tool-heading-example' => 'Texto de cabeceira',
	'wikieditor-toolbar-group-format' => 'Formato',
	'wikieditor-toolbar-tool-ulist' => 'Lista con asteriscos',
	'wikieditor-toolbar-tool-ulist-example' => 'Elemento da lista con asteriscos',
	'wikieditor-toolbar-tool-olist' => 'Lista numerada',
	'wikieditor-toolbar-tool-olist-example' => 'Elemento da lista numerada',
	'wikieditor-toolbar-tool-indent' => 'Sangría',
	'wikieditor-toolbar-tool-indent-example' => 'Liña con sangría',
	'wikieditor-toolbar-tool-nowiki' => 'Sen formato wiki',
	'wikieditor-toolbar-tool-nowiki-example' => 'Insira aquí un texto sen formato',
	'wikieditor-toolbar-tool-redirect' => 'Redirección',
	'wikieditor-toolbar-tool-redirect-example' => 'Nome da páxina de destino',
	'wikieditor-toolbar-tool-big' => 'Grande',
	'wikieditor-toolbar-tool-big-example' => 'Texto grande',
	'wikieditor-toolbar-tool-small' => 'Pequeno',
	'wikieditor-toolbar-tool-small-example' => 'Texto pequeno',
	'wikieditor-toolbar-tool-superscript' => 'Superíndice',
	'wikieditor-toolbar-tool-superscript-example' => 'Texto de superíndice',
	'wikieditor-toolbar-tool-subscript' => 'Subíndice',
	'wikieditor-toolbar-tool-subscript-example' => 'Texto de subíndice',
	'wikieditor-toolbar-group-insert' => 'Inserir',
	'wikieditor-toolbar-tool-gallery' => 'Galería de imaxes',
	'wikieditor-toolbar-tool-gallery-example' => '$1:Example.jpg|Pé_de_foto_1
$1:Example.jpg|Pé_de_foto_2',
	'wikieditor-toolbar-tool-newline' => 'Nova liña',
	'wikieditor-toolbar-tool-table' => 'Táboa',
	'wikieditor-toolbar-tool-table-example-old' => '-
! cabeceira 1
! cabeceira 2
! cabeceira 3
|-
| liña 1, cela 1
| liña 1, cela 2
| liña 1, cela 3
|-
| liña 2, cela 1
| liña 2, cela 2
| liña 2, cela 3',
	'wikieditor-toolbar-tool-table-example-cell-text' => 'Texto da cela',
	'wikieditor-toolbar-tool-table-example-header' => 'Texto da cabeceira',
	'wikieditor-toolbar-tool-table-title' => 'Inserir unha táboa',
	'wikieditor-toolbar-tool-table-dimensions-rows' => 'Liñas',
	'wikieditor-toolbar-tool-table-dimensions-columns' => 'Columnas',
	'wikieditor-toolbar-tool-table-dimensions-header' => 'Incluír a liña de cabeceira',
	'wikieditor-toolbar-tool-table-wikitable' => 'Estilo con bordos',
	'wikieditor-toolbar-tool-table-sortable' => 'Facer que a táboa se poida ordenar',
	'wikieditor-toolbar-tool-table-example' => 'Texto da cela',
	'wikieditor-toolbar-tool-table-preview' => 'Vista previa',
	'wikieditor-toolbar-tool-table-insert' => 'Inserir',
	'wikieditor-toolbar-tool-table-cancel' => 'Cancelar',
	'wikieditor-toolbar-tool-table-toomany' => 'Non é posible inserir unha táboa con máis de $1 celas con este diálogo.',
	'wikieditor-toolbar-tool-table-invalidnumber' => 'Non inseriu un número válido de fileiras ou columnas.',
	'wikieditor-toolbar-tool-table-zero' => 'Non pode inserir unha táboa con cero fileiras ou columnas.',
	'wikieditor-toolbar-tool-replace' => 'Buscar e substituír',
	'wikieditor-toolbar-tool-replace-title' => 'Buscar e substituír',
	'wikieditor-toolbar-tool-replace-search' => 'Buscar:',
	'wikieditor-toolbar-tool-replace-replace' => 'Substituír por:',
	'wikieditor-toolbar-tool-replace-case' => 'Facer coincidir as maiúsculas e as minúsculas',
	'wikieditor-toolbar-tool-replace-regex' => 'Tratar a secuencia de busca como unha expresión regular',
	'wikieditor-toolbar-tool-replace-button-findnext' => 'Atopar o seguinte',
	'wikieditor-toolbar-tool-replace-button-replace' => 'Substituír',
	'wikieditor-toolbar-tool-replace-button-replaceall' => 'Substituír todos',
	'wikieditor-toolbar-tool-replace-close' => 'Pechar',
	'wikieditor-toolbar-tool-replace-nomatch' => 'A súa busca non atopou nada.',
	'wikieditor-toolbar-tool-replace-success' => 'Fixéronse $1 substitucións.',
	'wikieditor-toolbar-tool-replace-emptysearch' => 'Non inseriu nada que procurar.',
	'wikieditor-toolbar-tool-replace-invalidregex' => 'A expresión regular que inseriu non é válida: $1',
	'wikieditor-toolbar-section-characters' => 'Caracteres especiais',
	'wikieditor-toolbar-characters-page-latin' => 'Latín',
	'wikieditor-toolbar-characters-page-latinextended' => 'Latín estendido',
	'wikieditor-toolbar-characters-page-ipa' => 'IPA',
	'wikieditor-toolbar-characters-page-symbols' => 'Símbolos',
	'wikieditor-toolbar-characters-page-greek' => 'Grego',
	'wikieditor-toolbar-characters-page-cyrillic' => 'Cirílico',
	'wikieditor-toolbar-characters-page-arabic' => 'Árabe',
	'wikieditor-toolbar-characters-page-arabicextended' => 'Árabe estendido',
	'wikieditor-toolbar-characters-page-persian' => 'Persa',
	'wikieditor-toolbar-characters-page-hebrew' => 'Hebreo',
	'wikieditor-toolbar-characters-page-bangla' => 'Bengalí',
	'wikieditor-toolbar-characters-page-tamil' => 'Támil',
	'wikieditor-toolbar-characters-page-telugu' => 'Telugú',
	'wikieditor-toolbar-characters-page-sinhala' => 'Cingalés',
	'wikieditor-toolbar-characters-page-gujarati' => 'Gujarati',
	'wikieditor-toolbar-characters-page-devanagari' => 'Devanāgarī',
	'wikieditor-toolbar-characters-page-thai' => 'Tailandés',
	'wikieditor-toolbar-characters-page-lao' => 'Laosiano',
	'wikieditor-toolbar-characters-page-khmer' => 'Camboxano',
	'wikieditor-toolbar-section-help' => 'Axuda',
	'wikieditor-toolbar-help-heading-description' => 'Descrición',
	'wikieditor-toolbar-help-heading-syntax' => 'O que escribe',
	'wikieditor-toolbar-help-heading-result' => 'O que obtén',
	'wikieditor-toolbar-help-page-format' => 'Dando formato',
	'wikieditor-toolbar-help-page-link' => 'Ligazóns',
	'wikieditor-toolbar-help-page-heading' => 'Cabeceiras',
	'wikieditor-toolbar-help-page-list' => 'Listas',
	'wikieditor-toolbar-help-page-file' => 'Ficheiros',
	'wikieditor-toolbar-help-page-reference' => 'Referencias',
	'wikieditor-toolbar-help-page-discussion' => 'Conversa',
	'wikieditor-toolbar-help-content-italic-description' => 'Cursiva',
	'wikieditor-toolbar-help-content-italic-syntax' => "''Texto en cursiva''",
	'wikieditor-toolbar-help-content-italic-result' => '<em>Texto en cursiva</em>',
	'wikieditor-toolbar-help-content-bold-description' => 'Negra',
	'wikieditor-toolbar-help-content-bold-syntax' => "'''Texto en negra'''",
	'wikieditor-toolbar-help-content-bold-result' => '<strong>Texto en negra</strong>',
	'wikieditor-toolbar-help-content-bolditalic-description' => 'Negra e cursiva',
	'wikieditor-toolbar-help-content-bolditalic-syntax' => "'''''Texto en negra e cursiva'''''",
	'wikieditor-toolbar-help-content-bolditalic-result' => '<strong><em>Texto en negra e cursiva</strong></em>',
	'wikieditor-toolbar-help-content-ilink-description' => 'Ligazón interna',
	'wikieditor-toolbar-help-content-ilink-syntax' => '[[Título da páxina|Texto da ligazón]]<br />[[Título da páxina]]',
	'wikieditor-toolbar-help-content-ilink-result' => "<a href='#'>Texto da ligazón</a><br /><a href='#'>Título da páxina</a>",
	'wikieditor-toolbar-help-content-xlink-description' => 'Ligazón externa',
	'wikieditor-toolbar-help-content-xlink-syntax' => '[http://www.example.org Texto da ligazón]<br />[http://www.example.org]<br />http://www.example.org',
	'wikieditor-toolbar-help-content-xlink-result' => "<a href='#' class='external'>Texto da ligazón</a><br /><a href='#' class='external autonumber'>[1]</a><br /><a href='#' class='external'>http://www.example.org</a>",
	'wikieditor-toolbar-help-content-heading2-description' => 'Cabeceira de 2º nivel',
	'wikieditor-toolbar-help-content-heading2-syntax' => '== Texto de cabeceira ==',
	'wikieditor-toolbar-help-content-heading2-result' => '<h2>Texto de cabeceira</h2>',
	'wikieditor-toolbar-help-content-heading3-description' => 'Cabeceira de 3º nivel',
	'wikieditor-toolbar-help-content-heading3-syntax' => '=== Texto de cabeceira ===',
	'wikieditor-toolbar-help-content-heading3-result' => '<h3>Texto de cabeceira</h3>',
	'wikieditor-toolbar-help-content-heading4-description' => 'Cabeceira de 4º nivel',
	'wikieditor-toolbar-help-content-heading4-syntax' => '==== Texto de cabeceira ====',
	'wikieditor-toolbar-help-content-heading4-result' => '<h4>Texto de cabeceira</h4>',
	'wikieditor-toolbar-help-content-heading5-description' => 'Cabeceira de 5º nivel',
	'wikieditor-toolbar-help-content-heading5-syntax' => '===== Texto de cabeceira =====',
	'wikieditor-toolbar-help-content-heading5-result' => '<h5>Texto de cabeceira</h5>',
	'wikieditor-toolbar-help-content-ulist-description' => 'Lista con asteriscos',
	'wikieditor-toolbar-help-content-ulist-syntax' => '* Elemento da lista<br />* Elemento da lista',
	'wikieditor-toolbar-help-content-ulist-result' => '<ul><li>Elemento da lista</li><li>Elemento da lista</li></ul>',
	'wikieditor-toolbar-help-content-olist-description' => 'Lista numerada',
	'wikieditor-toolbar-help-content-olist-syntax' => '# Elemento da lista<br /># Elemento da lista',
	'wikieditor-toolbar-help-content-olist-result' => '<ol><li>Elemento da lista</li><li>Elemento da lista</li></ol>',
	'wikieditor-toolbar-help-content-file-description' => 'Ficheiro embelecido',
	'wikieditor-toolbar-help-content-file-syntax' => '[[$1:Example.png|thumb|Pé de foto.]]',
	'wikieditor-toolbar-help-content-file-result' => "<div style='width:104px;' class='thumbinner'><a title='Pé de foto' class='image' href='#'><img height='50' width='100' border='0' class='thumbimage' src='$2/WikiEditor/modules/images/toolbar/example-image.png' alt=''/></a><div class='thumbcaption'><div class='magnify'><a title='Ampliar' class='internal' href='#'><img height='11' width='15' alt='' src='$1/common/images/magnify-clip.png'/></a></div>Pé de foto.</div></div>",
	'wikieditor-toolbar-help-content-reference-description' => 'Referencia',
	'wikieditor-toolbar-help-content-reference-syntax' => 'Texto da páxina&lt;ref name="test"&gt;[http://www.example.org Texto da ligazón], texto adicional.&lt;/ref&gt;.',
	'wikieditor-toolbar-help-content-reference-result' => "Texto da páxina<sup><a href='#'>[1]</a></sup>.",
	'wikieditor-toolbar-help-content-rereference-description' => 'Uso adicional da mesma referencia',
	'wikieditor-toolbar-help-content-rereference-result' => "Texto da páxina<sup><a href='#'>[1]</a></sup>.",
	'wikieditor-toolbar-help-content-showreferences-description' => 'Mostrar as referencias',
	'wikieditor-toolbar-help-content-showreferences-result' => "<ol class='references'><li id='cite_note-test-0'><b><a title='' href='#'>^</a></b> <a rel='nofollow' title='http://www.example.org' class='external text' href='#'>Texto da ligazón</a>, texto adicional.</li></ol>",
	'wikieditor-toolbar-help-content-signaturetimestamp-description' => 'Sinatura con data e hora',
	'wikieditor-toolbar-help-content-signaturetimestamp-result' => "<a href='#' title='{{#special:mypage}}'>Nome de usuario</a> (<a href='#' title='{{#special:mytalk}}'>conversa</a>) 10 de xuño de 2009 ás 15:54 (UTC)",
	'wikieditor-toolbar-help-content-signature-description' => 'Sinatura',
	'wikieditor-toolbar-help-content-signature-result' => "<a href='#' title='{{#special:mypage}}'>Nome de usuario</a> (<a href='#' title='{{#special:mytalk}}'>conversa</a>)",
	'wikieditor-toolbar-help-content-indent-description' => 'Sangría',
	'wikieditor-toolbar-help-content-indent-syntax' => 'Texto normal<br />:Texto con sangría<br />::Texto con máis sangría',
	'wikieditor-toolbar-help-content-indent-result' => 'Texto normal<dl><dd>Texto con sangría<dl><dd>Texto con máis sangría</dd></dl></dd></dl>',
);

/** Ancient Greek (Ἀρχαία ἑλληνικὴ)
 * @author Crazymadlover
 */
$messages['grc'] = array(
	'wikieditor-publish-button-cancel' => 'Ἀκυροῦν',
	'wikieditor-template-editor-dialog-cancel' => 'Ἀκυροῦν',
	'wikieditor-toolbar' => 'Ἐργαλειοθήκη μεταγραφῆς',
	'wikieditor-toolbar-loading' => 'Φορτίζειν…',
	'wikieditor-toolbar-tool-bold' => 'ἔντονον',
	'wikieditor-toolbar-tool-bold-example' => 'Γράμματα παχέα',
	'wikieditor-toolbar-tool-italic' => 'πλάγιον',
	'wikieditor-toolbar-tool-italic-example' => 'Γράμματα πλάγια',
	'wikieditor-toolbar-tool-ilink' => 'Ἐσωτερικὸς σύνδεσμος',
	'wikieditor-toolbar-tool-ilink-example' => 'Συνδέσμου ὄνομα',
	'wikieditor-toolbar-tool-xlink' => 'Ἐξώτερος σύνδεσμος (μέμνησο τοῦ προθέματος http://)',
	'wikieditor-toolbar-tool-xlink-example' => 'http://www.example.com ὄνομα συνδέσμου',
	'wikieditor-toolbar-tool-link-cancel' => 'Ἀκυροῦν',
	'wikieditor-toolbar-tool-file' => 'Ἐμβεβαπτισμένον ἀρχεῖον',
	'wikieditor-toolbar-tool-reference' => 'Ἀναφορά',
	'wikieditor-toolbar-tool-reference-example' => 'Εἰσάγειν κείμενον παραπομπῆς ὧδε',
	'wikieditor-toolbar-tool-reference-cancel' => 'Ἀκυροῦν',
	'wikieditor-toolbar-tool-signature' => 'Ὑπογραφή σου μετὰ χρονοσφραγίδος',
	'wikieditor-toolbar-section-advanced' => 'Προεωσμένον',
	'wikieditor-toolbar-tool-heading' => 'Ἐπικεφαλίς',
	'wikieditor-toolbar-tool-heading-1' => 'Ἐπίπεδον 1',
	'wikieditor-toolbar-tool-heading-2' => 'Ἐπίπεδον 2',
	'wikieditor-toolbar-tool-heading-3' => 'Ἐπίπεδον 3',
	'wikieditor-toolbar-tool-heading-4' => 'Ἐπίπεδον 4',
	'wikieditor-toolbar-tool-heading-5' => 'Ἐπίπεδον 5',
	'wikieditor-toolbar-group-format' => 'Κατάλογος',
	'wikieditor-toolbar-tool-big' => 'Μέγα',
	'wikieditor-toolbar-tool-big-example' => 'Μέγα κείμενον',
	'wikieditor-toolbar-tool-small' => 'Σμικρόν',
	'wikieditor-toolbar-tool-small-example' => 'Σμικρόν κείμενον',
	'wikieditor-toolbar-group-insert' => 'Εἰσάγειν',
	'wikieditor-toolbar-tool-gallery' => 'Πινακοθήκη',
	'wikieditor-toolbar-tool-newline' => 'Νέα γραμμή',
	'wikieditor-toolbar-tool-table' => 'Πίναξ',
	'wikieditor-toolbar-tool-table-cancel' => 'Ἀκυροῦν',
	'wikieditor-toolbar-tool-replace' => 'Ζητεῖν καὶ ὑποκαθιστάναι',
	'wikieditor-toolbar-tool-replace-title' => 'Ζητεῖν καὶ ὑποκαθιστάναι',
	'wikieditor-toolbar-tool-replace-search' => 'Zήτησις περί:',
	'wikieditor-toolbar-tool-replace-replace' => 'Ὑποκατάστασις ὑπό:',
	'wikieditor-toolbar-tool-replace-close' => 'Κλῄειν',
	'wikieditor-toolbar-section-characters' => 'Εἰδικοὶ χαρακτῆρες',
	'wikieditor-toolbar-characters-page-latin' => 'Λατινικόν',
	'wikieditor-toolbar-characters-page-latinextended' => 'Λατινικὸν προεκτεταμένον',
	'wikieditor-toolbar-characters-page-ipa' => 'ΔΦΑ',
	'wikieditor-toolbar-characters-page-symbols' => 'Σύμβολα',
	'wikieditor-toolbar-characters-page-greek' => 'Ἑλληνικόν',
	'wikieditor-toolbar-characters-page-cyrillic' => 'Κυριλλικόν',
	'wikieditor-toolbar-characters-page-arabic' => 'Ἀραβικόν',
	'wikieditor-toolbar-characters-page-hebrew' => 'Ἑβραϊκόν',
	'wikieditor-toolbar-characters-page-telugu' => 'Τελουγούϊον',
	'wikieditor-toolbar-section-help' => 'Βοήθεια',
	'wikieditor-toolbar-help-heading-description' => 'Περιγραφή',
	'wikieditor-toolbar-help-page-format' => 'Μορφοποίησις',
	'wikieditor-toolbar-help-page-link' => 'σύνδεσμοι',
	'wikieditor-toolbar-help-page-heading' => 'Ἐπικεφαλίδες',
	'wikieditor-toolbar-help-page-list' => 'Κατάλογοι',
	'wikieditor-toolbar-help-page-file' => 'Ἀρχεῖα',
	'wikieditor-toolbar-help-page-reference' => 'Ἀναφοραί',
	'wikieditor-toolbar-help-page-discussion' => 'Διάλεξις',
	'wikieditor-toolbar-help-content-italic-description' => 'πλάγιον',
	'wikieditor-toolbar-help-content-italic-syntax' => "''Γράμματα πλάγια''",
	'wikieditor-toolbar-help-content-italic-result' => '<em>Γράμματα πλάγια</em>',
	'wikieditor-toolbar-help-content-bold-description' => 'ἔντονον',
	'wikieditor-toolbar-help-content-bold-syntax' => "'''Γράμματα παχέα'''",
	'wikieditor-toolbar-help-content-bold-result' => '<strong>Γράμματα παχέα</strong>',
	'wikieditor-toolbar-help-content-ilink-description' => 'Ἐσωτερικὸς σύνδεσμος',
	'wikieditor-toolbar-help-content-xlink-description' => 'Ἐξωτερικὸς σύνδεσμος',
	'wikieditor-toolbar-help-content-heading2-description' => 'Ἐπικεφαλὶς 2ου ἐπιπέδου',
	'wikieditor-toolbar-help-content-heading2-syntax' => '== Κείμενον ἐπικεφαλίδος ==',
	'wikieditor-toolbar-help-content-heading2-result' => '<h2>Κείμενον ἐπικεφαλίδος</h2>',
	'wikieditor-toolbar-help-content-heading3-description' => 'Ἐπικεφαλὶς 3ου ἐπιπέδου',
	'wikieditor-toolbar-help-content-heading3-syntax' => '=== Κείμενον ἐπικεφαλίδος ===',
	'wikieditor-toolbar-help-content-heading3-result' => '<h3>Κείμενον ἐπικεφαλίδος</h3>',
	'wikieditor-toolbar-help-content-heading4-description' => 'Ἐπικεφαλὶς 4ου ἐπιπέδου',
	'wikieditor-toolbar-help-content-heading4-syntax' => '==== Κείμενον ἐπικεφαλίδος ====',
	'wikieditor-toolbar-help-content-heading4-result' => '<h4>Κείμενον ἐπικεφαλίδος</h4>',
	'wikieditor-toolbar-help-content-heading5-description' => 'Ἐπικεφαλὶς 5ου ἐπιπέδου',
	'wikieditor-toolbar-help-content-heading5-syntax' => '===== Κείμενον ἐπικεφαλίδος =====',
	'wikieditor-toolbar-help-content-heading5-result' => '<h5>Κείμενον ἐπικεφαλίδος</h5>',
	'wikieditor-toolbar-help-content-olist-description' => 'Ἠριθμημένη διαλογή',
	'wikieditor-toolbar-help-content-file-description' => 'Ἐμβεβαπτισμένον ἀρχεῖον',
	'wikieditor-toolbar-help-content-reference-description' => 'Ἀναφορά',
	'wikieditor-toolbar-help-content-reference-syntax' => 'Κείμενον δέλτου.&lt;ref name="test"&gt;[http://www.example.org Κείμενον συνδέσμου], ἐπιπρόσθετον κείμενον.&lt;/ref&gt;',
	'wikieditor-toolbar-help-content-showreferences-description' => 'Δεικνύειν ἀναφοράς',
	'wikieditor-toolbar-help-content-signaturetimestamp-description' => 'Ὑπογραφὴ μετὰ χρονοσφραγίδος',
	'wikieditor-toolbar-help-content-signature-description' => 'Ὑπογραφή',
	'wikieditor-toolbar-help-content-signature-result' => "<a href='#' title='{{#special:mypage}}'>Ὄνομα χρωμένου</a> (<a href='#' title='{{#special:mytalk}}'>διάλεξις</a>)",
	'wikieditor-toolbar-help-content-indent-description' => 'Παραγραφοποίησις',
);

/** Swiss German (Alemannisch)
 * @author Als-Chlämens
 * @author Als-Holder
 * @author Kghbln
 */
$messages['gsw'] = array(
	'wikieditor' => 'Oberflechi fir s fortgschritte Wikitext-Bearbeite',
	'wikieditor-desc' => 'Stellt e uusklappbari Wikitext-Bearbeitigsoberflechi z Verfiegig un vili Modul mit extra Megligkeite',
	'wikieditor-wikitext-tab' => 'WikiText',
	'wikieditor-loading' => 'Am Lade',
	'wikieditor-preview-preference' => 'Gegeiniberstelligs-Vorschau meglig mache',
	'wikieditor-preview-tab' => 'Vorschau',
	'wikieditor-preview-changes-tab' => 'Änderige',
	'wikieditor-preview-loading' => 'Am Lade ...',
	'wikieditor-previewDialog-preference' => 'D Abfrog zue dr Vorschau aaschalte',
	'wikieditor-previewDialog-tab' => 'Vorschau',
	'wikieditor-previewDialog-loading' => 'Am Lade ...',
	'wikieditor-publish-preference' => 'Schritt-fir-Schritt-Vereffentlichung meglig mache',
	'wikieditor-publish-button-publish' => 'Publiziere',
	'wikieditor-publish-button-cancel' => 'Abbräche',
	'wikieditor-publish-dialog-title' => 'Uf {{SITENAME}} publiziere',
	'wikieditor-publish-dialog-summary' => 'Zämmefassig (churzi Bschryybig vu dr Änderige, wu du gmacht hesch):',
	'wikieditor-publish-dialog-minor' => 'Chleinigkeite sin gänderet wore',
	'wikieditor-publish-dialog-watch' => 'Die Syte beobachte',
	'wikieditor-publish-dialog-publish' => 'Publiziere',
	'wikieditor-publish-dialog-goback' => 'Zruck',
	'wikieditor-template-editor-preference' => 'Formatbasiert Bearbeite vu Wikivorlage meglig mache',
	'wikieditor-template-editor-dialog-title' => 'Vorlag bearbeite',
	'wikieditor-template-editor-dialog-submit' => 'Aktualisiere',
	'wikieditor-template-editor-dialog-cancel' => 'Abbräche',
	'wikieditor-templates-preference' => 'Aktivierig vum Yy- un Uusblände vu Vorlage',
	'wikieditor-toc-preference' => 'Navigierbari Inhaltstabälle megli mache',
	'wikieditor-toc-show' => 'Inhalt zeige',
	'wikieditor-toc-hide' => 'Inhalt uusblände',
	'wikieditor-toolbar' => 'Wärchzygchäschtli bearbeite',
	'wikieditor-toolbar-desc' => 'Wärchzygchäschtli mit ere verbesserete Benutzerfrejndligkeit bearbeite',
	'wikieditor-toolbar-preference' => 'Verbesseret Bearbeitigs-Wärchzygchäschtli meglig mache',
	'wikieditor-toolbar-dialogs-preference' => 'Dialog aktiviere zum Links, Tabälle usw. yysetze',
	'wikieditor-toolbar-hidesig' => 'Dr Unterschriftebutton bi Syte im Artikelnamensruum uusblände',
	'wikieditor-toolbar-loading' => 'Am Lade ...',
	'wikieditor-toolbar-tool-bold' => 'Fätt',
	'wikieditor-toolbar-tool-bold-example' => 'Tekscht fätt',
	'wikieditor-toolbar-tool-italic' => 'Kursiv',
	'wikieditor-toolbar-tool-italic-example' => 'Tekscht kursiv',
	'wikieditor-toolbar-tool-ilink' => 'Intärne Link',
	'wikieditor-toolbar-tool-ilink-example' => 'Gleichtitel',
	'wikieditor-toolbar-tool-xlink' => 'Extärne Link (dänk an s Präfix http://)',
	'wikieditor-toolbar-tool-xlink-example' => 'http://www.byschpil.com Gleichtitel',
	'wikieditor-toolbar-tool-link' => 'Link',
	'wikieditor-toolbar-tool-link-title' => 'Link yysetze',
	'wikieditor-toolbar-tool-link-int' => 'Zuen eme Wikiartikel/ere Wikisyte',
	'wikieditor-toolbar-tool-link-int-target' => 'Artikeltitel:',
	'wikieditor-toolbar-tool-link-int-target-tooltip' => 'Sytename oder URL',
	'wikieditor-toolbar-tool-link-int-text' => 'Gleichtext:',
	'wikieditor-toolbar-tool-link-int-text-tooltip' => 'Text yygee, wu soll aazeigt wäre',
	'wikieditor-toolbar-tool-link-ext' => 'Zuen ere extärne Netzsyte',
	'wikieditor-toolbar-tool-link-ext-target' => 'URL-Link:',
	'wikieditor-toolbar-tool-link-ext-text' => 'Gleichtext:',
	'wikieditor-toolbar-tool-link-insert' => 'Link yysetze',
	'wikieditor-toolbar-tool-link-cancel' => 'Abbräche',
	'wikieditor-toolbar-tool-link-int-target-status-exists' => 'Syte git s scho',
	'wikieditor-toolbar-tool-link-int-target-status-notexists' => 'Syte git s nit',
	'wikieditor-toolbar-tool-link-int-target-status-invalid' => 'Nit giltige Titel',
	'wikieditor-toolbar-tool-link-int-target-status-external' => 'Extärne Link',
	'wikieditor-toolbar-tool-link-int-target-status-loading' => 'Am Priefe, eb s Syte git ...',
	'wikieditor-toolbar-tool-link-int-invalid' => 'Dr Titel, wu Du aagee hesch, isch nit giltig.',
	'wikieditor-toolbar-tool-link-lookslikeinternal' => 'D URL, wu Du yygee hesch, siht uus wie ne Link zuen ere andre Wikisyte.
Wettsch e intärne Link setze?',
	'wikieditor-toolbar-tool-link-lookslikeinternal-int' => 'Intärne Link',
	'wikieditor-toolbar-tool-link-lookslikeinternal-ext' => 'Extärne Link',
	'wikieditor-toolbar-tool-link-empty' => 'Du hesch nyt yygee, wu druf cha verwise wäre.',
	'wikieditor-toolbar-tool-file' => 'Yygfiegti Datei',
	'wikieditor-toolbar-tool-file-example' => 'Byschpil.jpg',
	'wikieditor-toolbar-tool-file-title' => 'Datei yyfiege',
	'wikieditor-toolbar-file-target' => 'Dateiname:',
	'wikieditor-toolbar-file-caption' => 'Bschrybig:',
	'wikieditor-toolbar-file-size' => 'Greßi:',
	'wikieditor-toolbar-file-float' => 'Uusrichtig:',
	'wikieditor-toolbar-file-default' => '(Standard)',
	'wikieditor-toolbar-file-format' => 'Format:',
	'wikieditor-toolbar-file-format-none' => 'keini',
	'wikieditor-toolbar-tool-file-insert' => 'Yyfiege',
	'wikieditor-toolbar-tool-file-cancel' => 'Abbräche',
	'wikieditor-toolbar-tool-reference' => 'Quälle',
	'wikieditor-toolbar-tool-reference-example' => 'Do Fuessnotetekscht yyfiege',
	'wikieditor-toolbar-tool-reference-cancel' => 'Abbräche',
	'wikieditor-toolbar-tool-reference-title' => 'Referänz yyfiege',
	'wikieditor-toolbar-tool-reference-insert' => 'Yyfiege',
	'wikieditor-toolbar-tool-reference-text' => 'Referänztext',
	'wikieditor-toolbar-tool-signature' => 'Unterschrift un Zytstämpfel',
	'wikieditor-toolbar-section-advanced' => 'Erwyteret',
	'wikieditor-toolbar-tool-heading' => 'Iberschrift',
	'wikieditor-toolbar-tool-heading-1' => 'Ebeni 1',
	'wikieditor-toolbar-tool-heading-2' => 'Ebeni 2',
	'wikieditor-toolbar-tool-heading-3' => 'Ebeni 3',
	'wikieditor-toolbar-tool-heading-4' => 'Ebeni 4',
	'wikieditor-toolbar-tool-heading-5' => 'Ebeni 5',
	'wikieditor-toolbar-tool-heading-example' => 'Iberschriftetekscht',
	'wikieditor-toolbar-group-format' => 'Format',
	'wikieditor-toolbar-tool-ulist' => 'Nummerierti Lischt',
	'wikieditor-toolbar-tool-ulist-example' => 'Ufzelligslischtepunkt',
	'wikieditor-toolbar-tool-olist' => 'Nummerierti Lischt',
	'wikieditor-toolbar-tool-olist-example' => 'Nummerierti Lischte-Punkt',
	'wikieditor-toolbar-tool-indent' => 'Yygruckt',
	'wikieditor-toolbar-tool-indent-example' => 'Yygruckti Zyyle',
	'wikieditor-toolbar-tool-nowiki' => 'Kei Wiki-Formatierig',
	'wikieditor-toolbar-tool-nowiki-example' => 'Do nit-formatierte Text yygee',
	'wikieditor-toolbar-tool-redirect' => 'Wyterleitig',
	'wikieditor-toolbar-tool-redirect-example' => 'Ziilsytename',
	'wikieditor-toolbar-tool-big' => 'Groß',
	'wikieditor-toolbar-tool-big-example' => 'Grossgschribene Tekscht',
	'wikieditor-toolbar-tool-small' => 'Chlei',
	'wikieditor-toolbar-tool-small-example' => 'Chleigschribene Tekscht',
	'wikieditor-toolbar-tool-superscript' => 'Hochgsetzt',
	'wikieditor-toolbar-tool-superscript-example' => 'Hochgsetzte Tekscht',
	'wikieditor-toolbar-tool-subscript' => 'Untergsetzt',
	'wikieditor-toolbar-tool-subscript-example' => 'Untergsetzte Tekscht',
	'wikieditor-toolbar-group-insert' => 'Yyfiege',
	'wikieditor-toolbar-tool-gallery' => 'Bildergallerii',
	'wikieditor-toolbar-tool-gallery-example' => '$1:Byschpil.jpg|Bschriftig1
$1:Byschpil.jpg|Bschriftig2',
	'wikieditor-toolbar-tool-newline' => 'Neji Zeile',
	'wikieditor-toolbar-tool-table' => 'Tabälle',
	'wikieditor-toolbar-tool-table-example-old' => '-
! Chopf 1
! Chopf 2
! Chopf 3
|-
| Zyylete 1, Zälle 1
| Zyylete 1, Zälle 2
| Zyylete 1, Zälle 3
|-
| Zyylete 2, Zälle 1
| Zyylete 2, Zälle 2
| Zyylete 2, Zälle 3',
	'wikieditor-toolbar-tool-table-example-cell-text' => 'Zälletext',
	'wikieditor-toolbar-tool-table-example-header' => 'Iberschrift',
	'wikieditor-toolbar-tool-table-title' => 'Tabälle yyfiege',
	'wikieditor-toolbar-tool-table-dimensions-rows' => 'Zyle',
	'wikieditor-toolbar-tool-table-dimensions-columns' => 'Spalte',
	'wikieditor-toolbar-tool-table-dimensions-header' => 'Iberschrift yyfiege',
	'wikieditor-toolbar-tool-table-wikitable' => 'Style mit Ramme',
	'wikieditor-toolbar-tool-table-sortable' => 'Tabälle sortierbar mache',
	'wikieditor-toolbar-tool-table-example' => 'Zälletext',
	'wikieditor-toolbar-tool-table-preview' => 'Vorschau',
	'wikieditor-toolbar-tool-table-insert' => 'Yyfiege',
	'wikieditor-toolbar-tool-table-cancel' => 'Abbräche',
	'wikieditor-toolbar-tool-table-toomany' => 'Yyfiege vun ere Tabälle mit meh wie $1 Zälle isch nit megli in däm Dialogfänschter.',
	'wikieditor-toolbar-tool-table-invalidnumber' => 'Du hesch kei giltigi Zahl vu Zyyle oder Spalte yygee.',
	'wikieditor-toolbar-tool-table-zero' => 'Du chasch kei Tabälle yyfiege ohni Zyyle oder Spalte.',
	'wikieditor-toolbar-tool-replace' => 'Suechen un ersetze',
	'wikieditor-toolbar-tool-replace-title' => 'Sueche un ersetze',
	'wikieditor-toolbar-tool-replace-search' => 'Sueche no:',
	'wikieditor-toolbar-tool-replace-replace' => 'Ersetze dur:',
	'wikieditor-toolbar-tool-replace-case' => 'Groß- un Chleibuechstabe unterscheide',
	'wikieditor-toolbar-tool-replace-regex' => 'D Zeichechette wu gsuecht soll wäre as reguläre Uusdruck versueche',
	'wikieditor-toolbar-tool-replace-button-findnext' => 'Negschti sueche',
	'wikieditor-toolbar-tool-replace-button-replace' => 'Ersetze',
	'wikieditor-toolbar-tool-replace-button-replaceall' => 'Alli ersetze',
	'wikieditor-toolbar-tool-replace-close' => 'Zuemache',
	'wikieditor-toolbar-tool-replace-nomatch' => 'Zue Dyyre Suech git s kei Träffer.',
	'wikieditor-toolbar-tool-replace-success' => '$1 Ersetzige durgfiert.',
	'wikieditor-toolbar-tool-replace-emptysearch' => 'Du hesch nyt yygee zum Sueche.',
	'wikieditor-toolbar-tool-replace-invalidregex' => 'Dää regulär Uusdruck, wu Du yygee hesch, isch nit giltig: $1',
	'wikieditor-toolbar-section-characters' => 'Sunderzeiche',
	'wikieditor-toolbar-characters-page-latin' => 'Latynisch',
	'wikieditor-toolbar-characters-page-latinextended' => 'Latin Extended',
	'wikieditor-toolbar-characters-page-ipa' => 'IPA',
	'wikieditor-toolbar-characters-page-symbols' => 'Symbol',
	'wikieditor-toolbar-characters-page-greek' => 'Griechisch',
	'wikieditor-toolbar-characters-page-cyrillic' => 'Kyrillisch',
	'wikieditor-toolbar-characters-page-arabic' => 'Arabisch',
	'wikieditor-toolbar-characters-page-arabicextended' => 'Erwyyterts Arabisch',
	'wikieditor-toolbar-characters-page-persian' => 'Persisch',
	'wikieditor-toolbar-characters-page-hebrew' => 'Hebräisch',
	'wikieditor-toolbar-characters-page-bangla' => 'Bengalisch',
	'wikieditor-toolbar-characters-page-tamil' => 'Tamilisch',
	'wikieditor-toolbar-characters-page-telugu' => 'Telugu',
	'wikieditor-toolbar-characters-page-sinhala' => 'Singhalesisch',
	'wikieditor-toolbar-characters-page-gujarati' => 'Gujarati',
	'wikieditor-toolbar-characters-page-devanagari' => 'Devanagari',
	'wikieditor-toolbar-characters-page-thai' => 'Thai',
	'wikieditor-toolbar-characters-page-lao' => 'Lao',
	'wikieditor-toolbar-characters-page-khmer' => 'Khmer',
	'wikieditor-toolbar-section-help' => 'Hilf',
	'wikieditor-toolbar-help-heading-description' => 'Bschrybig',
	'wikieditor-toolbar-help-heading-syntax' => 'Was Du schrybsch',
	'wikieditor-toolbar-help-heading-result' => 'Was Du derby kriegsch',
	'wikieditor-toolbar-help-page-format' => 'Formatiere',
	'wikieditor-toolbar-help-page-link' => 'Links',
	'wikieditor-toolbar-help-page-heading' => 'Iberschrifte',
	'wikieditor-toolbar-help-page-list' => 'Lischte',
	'wikieditor-toolbar-help-page-file' => 'Dateie',
	'wikieditor-toolbar-help-page-reference' => 'Quälle',
	'wikieditor-toolbar-help-page-discussion' => 'Diskussion',
	'wikieditor-toolbar-help-content-italic-description' => 'Kursiv',
	'wikieditor-toolbar-help-content-italic-syntax' => "''Kursive Tekscht''",
	'wikieditor-toolbar-help-content-italic-result' => '<em>Kursive Tekscht</em>',
	'wikieditor-toolbar-help-content-bold-description' => 'Fett',
	'wikieditor-toolbar-help-content-bold-syntax' => "'''Fette Tekscht'''",
	'wikieditor-toolbar-help-content-bold-result' => '<strong>Fette Tekscht</strong>',
	'wikieditor-toolbar-help-content-bolditalic-description' => 'Fett &amp; kursiv',
	'wikieditor-toolbar-help-content-bolditalic-syntax' => "'''''Fette &amp; kursive Tekscht'''''",
	'wikieditor-toolbar-help-content-bolditalic-result' => '<strong><em>Fette &amp; kursive Tekscht</em></strong>',
	'wikieditor-toolbar-help-content-ilink-description' => 'Intärne Link',
	'wikieditor-toolbar-help-content-ilink-syntax' => '[[Page title|Gleichname]]<br />[[Page title]]',
	'wikieditor-toolbar-help-content-ilink-result' => "<a href='#'>Gleichname</a><br /><a href='#'>Sytetitel</a>",
	'wikieditor-toolbar-help-content-xlink-description' => 'Extärne Link',
	'wikieditor-toolbar-help-content-xlink-syntax' => '[http://www.byschpil.org Gleichname]<br />[http://www.byschpil.org]<br />http://www.byschpil.org',
	'wikieditor-toolbar-help-content-xlink-result' => "<a href='#' class='external'>Gleichname</a><br /><a href='#' class='external autonumber'>[1]</a><br /><a href='#' class='external'>http://www.byschpil.org</a>",
	'wikieditor-toolbar-help-content-heading2-description' => 'Iberschrift 2. Ebeni',
	'wikieditor-toolbar-help-content-heading2-syntax' => '== Iberschriftetekscht ==',
	'wikieditor-toolbar-help-content-heading2-result' => '<h2>Iberschriftetekscht</h2>',
	'wikieditor-toolbar-help-content-heading3-description' => 'Iberschrift 3. Ebeni',
	'wikieditor-toolbar-help-content-heading3-syntax' => '=== Iberschriftetekscht ===',
	'wikieditor-toolbar-help-content-heading3-result' => '<h3>Iberschriftetekscht</h3>',
	'wikieditor-toolbar-help-content-heading4-description' => 'Iberschrift 4. Ebeni',
	'wikieditor-toolbar-help-content-heading4-syntax' => '==== Iberschriftetekscht ====',
	'wikieditor-toolbar-help-content-heading4-result' => '<h4>Iberschriftetekscht</h4>',
	'wikieditor-toolbar-help-content-heading5-description' => 'Iberschrift 5. Ebeni',
	'wikieditor-toolbar-help-content-heading5-syntax' => '===== Iberschriftetekscht =====',
	'wikieditor-toolbar-help-content-heading5-result' => '<h5>Iberschriftetekscht</h5>',
	'wikieditor-toolbar-help-content-ulist-description' => 'Lischt mit Ufzellig',
	'wikieditor-toolbar-help-content-ulist-syntax' => '* Lischtepunkt<br />* Lischtepunkt',
	'wikieditor-toolbar-help-content-ulist-result' => '<ul><li>Lischtepunkt</li><li>Lischtepunkt</li></ul>',
	'wikieditor-toolbar-help-content-olist-description' => 'Nummerierti Lischt',
	'wikieditor-toolbar-help-content-olist-syntax' => '# Lischtepunkt<br /># Lischtepunkt',
	'wikieditor-toolbar-help-content-olist-result' => '<ol><li>Lischtepunkt</li><li>Lischtepunkt</li></ol>',
	'wikieditor-toolbar-help-content-file-description' => 'Yygfiegti Datei',
	'wikieditor-toolbar-help-content-file-syntax' => '[[$1:Example.png|thumb|Bildbschriftig]]',
	'wikieditor-toolbar-help-content-file-result' => "<div style='width:104px;' class='thumbinner'><a title='Bildbschriftig' class='image' href='/wiki/Datei:Wiki.png'><img height='50' width='100' border='0' class='thumbimage' src='$2/WikiEditor/modules/images/toolbar/example-image.png' alt=''/></a><div class='Bschriftig'><div class='magnify'><a title='Enlarge' class='internal' href='#'><img height='11' width='15' alt='' src='$1/common/images/magnify-clip.png'/></a></div>Bildbschriftig</div></div>",
	'wikieditor-toolbar-help-content-reference-description' => 'Quälle',
	'wikieditor-toolbar-help-content-reference-syntax' => 'Sytetekscht.&lt;ref name="test"&gt;[http://www.byschpil.org Gleichtekscht], zuesätzlige Tekscht.&lt;/ref&gt;',
	'wikieditor-toolbar-help-content-reference-result' => "Sytetekscht.<sup><a href='#'>[1]</a></sup>",
	'wikieditor-toolbar-help-content-rereference-description' => 'Zuesätzlige Verwändig vu dr glyche Quälle',
	'wikieditor-toolbar-help-content-rereference-result' => "Sytetekscht.<sup><a href='#'>[1]</a></sup>",
	'wikieditor-toolbar-help-content-showreferences-description' => 'Quälle aazeige',
	'wikieditor-toolbar-help-content-showreferences-result' => "<ol class='references'><li id='cite_note-test-0'><b><a title='' href='#'>^</a></b> <a rel='nofollow' title='http://www.byschpil.org' class='Extärne Tekscht' href='#'>Linktekscht</a>, zuesätzlige Tekscht.</li></ol>",
	'wikieditor-toolbar-help-content-signaturetimestamp-description' => 'Unterschrift mit Zytaagab',
	'wikieditor-toolbar-help-content-signaturetimestamp-result' => "<a href='#' title='{{#special:mypage}}'>Benutzername</a> (<a href='#' title='{{#special:mytalk}}'>talk</a>) 15:54, 10 June 2009 (UTC)",
	'wikieditor-toolbar-help-content-signature-description' => 'Unterschrift',
	'wikieditor-toolbar-help-content-signature-result' => "<a href='#' title='{{#special:mypage}}'>Benutzername</a> (<a href='#' title='{{#special:mytalk}}'>talk</a>)",
	'wikieditor-toolbar-help-content-indent-description' => 'Zeileyyzug',
	'wikieditor-toolbar-help-content-indent-syntax' => 'Normale Tekscht<br />:Yygruckte Tekscht<br />::Yygruckte Tekscht',
	'wikieditor-toolbar-help-content-indent-result' => 'Normale Tekscht<dl><dd>Yygruckte Tekscht<dl><dd>Yygruckte Tekscht</dd></dl></dd></dl>',
);

/** Gujarati (ગુજરાતી)
 * @author Ashok modhvadia
 * @author KartikMistry
 * @author Sushant savla
 */
$messages['gu'] = array(
	'wikieditor' => 'ઉચ્ચ વિકિલખાણ ફેરફાર દેખાવ',
	'wikieditor-desc' => 'વિસ્તૃત વિકિલખાણ દેખાવ અને ઘણી સુવિધાઓ વાળા મોડ્યુલ્સ પૂરા પાડે છે',
	'wikieditor-wikitext-tab' => 'વિકિલેખન (વિકિટેક્સ્ટ)‌',
	'wikieditor-loading' => 'લવાઇ રહ્યું છે...',
	'wikieditor-preview-preference' => 'બાજુમાં પુન:અવલોકન ચાલુ રાખો',
	'wikieditor-preview-tab' => 'પૂર્વાવલોકન',
	'wikieditor-preview-changes-tab' => 'ફેરફારો',
	'wikieditor-preview-loading' => 'લવાઇ રહ્યું છે...',
	'wikieditor-previewDialog-preference' => 'સંભાષણ પુનરાવલોકન સક્રીય કરો',
	'wikieditor-previewDialog-tab' => 'પૂર્વાવલોકન',
	'wikieditor-previewDialog-loading' => 'લવાઇ રહ્યું છે...',
	'wikieditor-publish-preference' => 'ટપ્પા વાર પ્રકાશન કાર્યાન્વીત કરો',
	'wikieditor-publish-button-publish' => 'પ્રસિદ્ધ કરો',
	'wikieditor-publish-button-cancel' => 'રદ કરો',
	'wikieditor-publish-dialog-title' => '{{SITENAME}} પર પ્રસિદ્ધ કરો',
	'wikieditor-publish-dialog-summary' => 'સારમાં ફેરફાર કરો. (તમે કરેલા ફેરફારનો સાર):',
	'wikieditor-publish-dialog-minor' => 'નાનકડો ફેરફાર',
	'wikieditor-publish-dialog-watch' => 'આ પાનાને ધ્યાનમાં રાખો',
	'wikieditor-publish-dialog-publish' => 'પ્રસિદ્ધ કરો',
	'wikieditor-publish-dialog-goback' => 'પાછાં જાવ',
	'wikieditor-template-editor-preference' => 'વિકિ ટેમ્પલેટ્સ માટે ફોર્મ-આધારિત ફેરફાર સક્રિય કરો',
	'wikieditor-template-editor-dialog-title' => 'ઢાંચામાં ફેરફાર કરો',
	'wikieditor-template-editor-dialog-submit' => 'અદ્યતન કરો',
	'wikieditor-template-editor-dialog-cancel' => 'રદ કરો',
	'wikieditor-templates-preference' => 'ઢાંચાનું નીચે તરફ ફેલાવ સક્રીય કરો',
	'wikieditor-toc-preference' => 'નેવીગેબલ કોઠો સક્રીય કરો',
	'wikieditor-toc-show' => 'ટિપ્પણીઓ બતાવો',
	'wikieditor-toc-hide' => 'ટિપ્પણીઓ સંતાડો',
	'wikieditor-toolbar' => 'ફેરફાર  સાધન કંપાસ',
	'wikieditor-toolbar-desc' => 'પૃષ્ઠના ફેરફાર સાધનો ને વધારેલ વપરાશ સાધનો ધરાવતી પેટી ઉમેરી મુકો',
	'wikieditor-toolbar-preference' => 'અદ્યતન સંપાદન સાધનો સક્રીય કરો',
	'wikieditor-toolbar-dialogs-preference' => 'કડીઓ, કોઠા અને અન્ય વસ્તુઓ ઉમેરવા સંભાષણ સક્રીય કરો',
	'wikieditor-toolbar-hidesig' => 'મુખ્ય નામ સ્થળ  પરના પાના પરથી હસ્તાક્ષર બટન હટાવો',
	'wikieditor-toolbar-loading' => 'લવાઇ રહ્યું છે...',
	'wikieditor-toolbar-tool-bold' => 'ઘાટું',
	'wikieditor-toolbar-tool-bold-example' => 'ઘાટું લખાણ',
	'wikieditor-toolbar-tool-italic' => 'ત્રાંસું',
	'wikieditor-toolbar-tool-italic-example' => 'ત્રાંસું લખાણ',
	'wikieditor-toolbar-tool-ilink' => 'આંતરિક કડી',
	'wikieditor-toolbar-tool-ilink-example' => 'કડીનું શીર્ષક',
	'wikieditor-toolbar-tool-xlink' => 'બાહ્ય કડી (શરૂઆતમાં http:// ઉમેરવાનું ભુલશો નહી)',
	'wikieditor-toolbar-tool-xlink-example' => 'http://www.example.com કડીનું શીર્ષક',
	'wikieditor-toolbar-tool-link' => 'કડી',
	'wikieditor-toolbar-tool-link-title' => 'કડી ઉમેરો',
	'wikieditor-toolbar-tool-link-int' => 'વિકિ પાના તરફ',
	'wikieditor-toolbar-tool-link-int-target' => 'ઈચ્છીત સ્થળ કે URL:',
	'wikieditor-toolbar-tool-link-int-target-tooltip' => 'પૃષ્ઠ શીર્ષક કે  URL',
	'wikieditor-toolbar-tool-link-int-text' => 'દર્શાવવાનું લખાણ:',
	'wikieditor-toolbar-tool-link-int-text-tooltip' => 'દર્શાવવાનું લખાણ',
	'wikieditor-toolbar-tool-link-ext' => 'બાહ્ય વેબ પાનાં તરફ',
	'wikieditor-toolbar-tool-link-ext-target' => 'URL કડી:',
	'wikieditor-toolbar-tool-link-ext-text' => 'કડીના શબ્દો:',
	'wikieditor-toolbar-tool-link-insert' => 'કડી ઉમેરો',
	'wikieditor-toolbar-tool-link-cancel' => 'રદ કરો',
	'wikieditor-toolbar-tool-link-int-target-status-exists' => 'પાનું પહેલેથી મોજૂદ છે',
	'wikieditor-toolbar-tool-link-int-target-status-notexists' => 'પાનું અસ્તિત્વ ધરાવતું નથી.',
	'wikieditor-toolbar-tool-link-int-target-status-invalid' => 'અમાન્ય મથાળું.',
	'wikieditor-toolbar-tool-link-int-target-status-external' => 'બાહ્ય કડી',
	'wikieditor-toolbar-tool-link-int-target-status-loading' => 'અન્ય સ્થળે પાનાની મોજૂદગી ચકાસાઈ રહી છે',
	'wikieditor-toolbar-tool-link-int-invalid' => 'આ શીર્ષક અમાન્ય છે.',
	'wikieditor-toolbar-tool-link-lookslikeinternal' => 'તમે જણાવેલ URL  પરથી લાગે છે કે તમે અન્ય વિકિ સાથે કડી જોડવા માંગો છો.
શું તમે આંતરીક કડી બનાવવા માંગો છો?',
	'wikieditor-toolbar-tool-link-lookslikeinternal-int' => 'બાહ્ય કડીઓ',
	'wikieditor-toolbar-tool-link-lookslikeinternal-ext' => 'બાહ્ય કડી',
	'wikieditor-toolbar-tool-link-empty' => 'તમે શોધવા માટે કંઈ દાખલ કર્યું નથી.',
	'wikieditor-toolbar-tool-file' => 'અંદર વણાયેલી (Embedded) ફાઇલ',
	'wikieditor-toolbar-tool-file-example' => 'Example.jpg (ઉદાહરણ)',
	'wikieditor-toolbar-tool-file-title' => 'ફાઇલ ઉમેરો',
	'wikieditor-toolbar-file-target' => 'ફાઇલનામ:',
	'wikieditor-toolbar-file-size' => 'માપ:',
	'wikieditor-toolbar-file-default' => '(મૂળભૂત)',
	'wikieditor-toolbar-file-format' => 'શૈલી:',
	'wikieditor-toolbar-tool-file-insert' => 'ઉમેરો',
	'wikieditor-toolbar-tool-file-cancel' => 'રદ કરો',
	'wikieditor-toolbar-tool-reference' => 'સંદર્ભ',
	'wikieditor-toolbar-tool-reference-example' => 'પૃષ્ઠની નીચેના પાયામાં લખવાનું લેખન અહીં લખો',
	'wikieditor-toolbar-tool-reference-cancel' => 'રદ કરો',
	'wikieditor-toolbar-tool-reference-title' => 'સંદર્ભ ઉમેરો',
	'wikieditor-toolbar-tool-reference-insert' => 'ઉમેરો',
	'wikieditor-toolbar-tool-reference-text' => 'સંદર્ભ લખાણ',
	'wikieditor-toolbar-tool-signature' => 'હસ્તાક્ષર અને સમયછાપ',
	'wikieditor-toolbar-section-advanced' => 'ઉચ્ચ',
	'wikieditor-toolbar-tool-heading' => 'મથાળું',
	'wikieditor-toolbar-tool-heading-1' => 'સ્તર ૧',
	'wikieditor-toolbar-tool-heading-2' => 'સ્તર ૨',
	'wikieditor-toolbar-tool-heading-3' => 'સ્તર ૩',
	'wikieditor-toolbar-tool-heading-4' => 'સ્તર ૪',
	'wikieditor-toolbar-tool-heading-5' => 'સ્તર ૫',
	'wikieditor-toolbar-tool-heading-example' => 'મથાળાનાં મોટા અક્ષર',
	'wikieditor-toolbar-group-format' => 'શૈલી',
	'wikieditor-toolbar-tool-ulist' => 'ચિન્હાંકીત યાદી',
	'wikieditor-toolbar-tool-ulist-example' => 'ચિન્હાંકીત યાદીની વસ્તુ',
	'wikieditor-toolbar-tool-olist' => 'ક્રમગત: યાદી',
	'wikieditor-toolbar-tool-olist-example' => 'ક્રમગત: યાદીની વસ્તુ',
	'wikieditor-toolbar-tool-indent' => 'હાંસિયો',
	'wikieditor-toolbar-tool-indent-example' => 'હાંસિયાની રેખા',
	'wikieditor-toolbar-tool-nowiki' => 'વિકિ ફોર્મેટીંગ ગેરહાજર',
	'wikieditor-toolbar-tool-nowiki-example' => 'ફોર્મેટ કર્યા વગરનું લખાણ અહીં ઉમેરો',
	'wikieditor-toolbar-tool-redirect' => 'દિશાનિર્દેશ',
	'wikieditor-toolbar-tool-redirect-example' => 'લક્ષ્યાંકીત પૃષ્ઠ નામ',
	'wikieditor-toolbar-tool-big' => 'મોટું',
	'wikieditor-toolbar-tool-big-example' => 'મોટું લખાણ',
	'wikieditor-toolbar-tool-small' => 'નાનું',
	'wikieditor-toolbar-tool-small-example' => 'નાનું લખાણ',
	'wikieditor-toolbar-tool-superscript' => 'ઉપલા સ્તરના અક્ષરો',
	'wikieditor-toolbar-tool-superscript-example' => 'ઉપલા સ્તરના અક્ષર દેહ',
	'wikieditor-toolbar-tool-subscript' => 'નીચલા સ્તરના અક્ષરો',
	'wikieditor-toolbar-tool-subscript-example' => 'નીચલા સ્તરનો અક્ષર દેહ',
	'wikieditor-toolbar-group-insert' => 'ઉમેરો',
	'wikieditor-toolbar-tool-gallery' => 'ચિત્ર માલા',
	'wikieditor-toolbar-tool-gallery-example' => '$1:Example.jpg|Caption1
$1:Example.jpg|Caption2',
	'wikieditor-toolbar-tool-newline' => 'નવું વાક્ય',
	'wikieditor-toolbar-tool-table' => 'કોષ્ટક',
	'wikieditor-toolbar-tool-table-example-old' => '-
! header 1
! header 2
! header 3
|-
| row 1, cell 1
| row 1, cell 2
| row 1, cell 3
|-
| row 2, cell 1
| row 2, cell 2
| row 2, cell 3',
	'wikieditor-toolbar-tool-table-example-cell-text' => 'ખાનાના અક્ષરો',
	'wikieditor-toolbar-tool-table-example-header' => 'મથાળાનાં અક્ષર',
	'wikieditor-toolbar-tool-table-title' => 'કોષ્ટક ઉમેરો',
	'wikieditor-toolbar-tool-table-dimensions-rows' => 'પંક્તિઓ',
	'wikieditor-toolbar-tool-table-dimensions-columns' => 'સ્તંભો',
	'wikieditor-toolbar-tool-table-dimensions-header' => 'મથાળાની હરોળ ઉમેરો',
	'wikieditor-toolbar-tool-table-wikitable' => 'શૈલી સાથી સીમા',
	'wikieditor-toolbar-tool-table-sortable' => 'વર્ગાંતર સક્ષમ કોઠો બનાવો',
	'wikieditor-toolbar-tool-table-example' => 'ઉદાહરણ',
	'wikieditor-toolbar-tool-table-preview' => 'પૂર્વાવલોકન',
	'wikieditor-toolbar-tool-table-insert' => 'ઉમેરો',
	'wikieditor-toolbar-tool-table-cancel' => 'રદ કરો',
	'wikieditor-toolbar-tool-table-toomany' => 'આ સંભાષણ કોઠાને વાપરીને $1 થી વધારે ચોકઠાંનો કોઠો નહીં બનાવી શકાય',
	'wikieditor-toolbar-tool-table-invalidnumber' => 'તમે હરોળ કે સ્તંભની સંખ્યા યોગ્ય રીતે નથી મૂકી',
	'wikieditor-toolbar-tool-table-zero' => 'તમે શૂન્ય હરોળ અને શૂન્ય સ્તંભ ધરાવતો કોઠો ન બનાવી શકો',
	'wikieditor-toolbar-tool-replace' => 'શોધો અને બદલો',
	'wikieditor-toolbar-tool-replace-title' => 'શોધો અને બદલો',
	'wikieditor-toolbar-tool-replace-search' => 'આ માટે શોધો',
	'wikieditor-toolbar-tool-replace-replace' => 'આનાથી બદલો',
	'wikieditor-toolbar-tool-replace-case' => 'કેસ મોળવો',
	'wikieditor-toolbar-tool-replace-regex' => 'સર્ચ સ્ટ્રીંગને સામાન્ય ઍસ્કપ્રેશન તરીકે જાણો',
	'wikieditor-toolbar-tool-replace-button-findnext' => 'આગળ શોધો',
	'wikieditor-toolbar-tool-replace-button-replace' => 'બદલો',
	'wikieditor-toolbar-tool-replace-button-replaceall' => 'બધા બદલો',
	'wikieditor-toolbar-tool-replace-close' => 'બંધ કરો',
	'wikieditor-toolbar-tool-replace-nomatch' => 'તમારી શોધ કશાયને મળતી આવતી નથી',
	'wikieditor-toolbar-tool-replace-success' => '$1 બદલાવ(વો) કરાયાં.',
	'wikieditor-toolbar-tool-replace-emptysearch' => 'તમે શોધવા માટે કંઈ દાખલ કર્યું નથી.',
	'wikieditor-toolbar-tool-replace-invalidregex' => 'તમે માહિતી મૂકી તે અમાન્ય છે : $1',
	'wikieditor-toolbar-section-characters' => 'ખાસ અક્ષરો કે ચિન્હો',
	'wikieditor-toolbar-characters-page-latin' => 'લેટિન',
	'wikieditor-toolbar-characters-page-latinextended' => 'લેટિન વિસ્તૃત',
	'wikieditor-toolbar-characters-page-ipa' => 'IPA',
	'wikieditor-toolbar-characters-page-symbols' => 'સંજ્ઞાઓ',
	'wikieditor-toolbar-characters-page-greek' => 'ગ્રીક',
	'wikieditor-toolbar-characters-page-cyrillic' => 'સીરિલિક',
	'wikieditor-toolbar-characters-page-arabic' => 'અરેબિક',
	'wikieditor-toolbar-characters-page-arabicextended' => 'અરેબિક વિસ્તૃત',
	'wikieditor-toolbar-characters-page-persian' => 'પર્સિયન',
	'wikieditor-toolbar-characters-page-hebrew' => 'હિબ્રૂ',
	'wikieditor-toolbar-characters-page-bangla' => 'બાંગ્લા',
	'wikieditor-toolbar-characters-page-tamil' => 'તામિલ',
	'wikieditor-toolbar-characters-page-telugu' => 'તેલુગુ',
	'wikieditor-toolbar-characters-page-sinhala' => 'સિંહાલા',
	'wikieditor-toolbar-characters-page-gujarati' => 'ગુજરાતી',
	'wikieditor-toolbar-characters-page-devanagari' => 'દેવનાગરી',
	'wikieditor-toolbar-characters-page-thai' => 'થાઈ',
	'wikieditor-toolbar-characters-page-lao' => 'લાઓ',
	'wikieditor-toolbar-characters-page-khmer' => 'ખ્મેર',
	'wikieditor-toolbar-section-help' => 'મદદ',
	'wikieditor-toolbar-help-heading-description' => 'વર્ણન',
	'wikieditor-toolbar-help-heading-syntax' => 'તમે જે લખો',
	'wikieditor-toolbar-help-heading-result' => 'તમે જે મેળવો',
	'wikieditor-toolbar-help-page-format' => 'રચના શૈલિ',
	'wikieditor-toolbar-help-page-link' => 'કડીઓ',
	'wikieditor-toolbar-help-page-heading' => 'મથાળું',
	'wikieditor-toolbar-help-page-list' => 'યાદીઓ',
	'wikieditor-toolbar-help-page-file' => 'ફાઈલો',
	'wikieditor-toolbar-help-page-reference' => 'સંદર્ભો',
	'wikieditor-toolbar-help-page-discussion' => 'ચર્ચા',
	'wikieditor-toolbar-help-content-italic-description' => 'ત્રાંસું',
	'wikieditor-toolbar-help-content-italic-syntax' => "''ત્રાંસા અક્ષરો''",
	'wikieditor-toolbar-help-content-italic-result' => '<em>ત્રાંસા અક્ષરો</em>',
	'wikieditor-toolbar-help-content-bold-description' => 'ઘાટું',
	'wikieditor-toolbar-help-content-bold-syntax' => "'''ઘાટં અક્ષરો'''",
	'wikieditor-toolbar-help-content-bold-result' => '<strong>ઘાટું લખાણ</strong>',
	'wikieditor-toolbar-help-content-bolditalic-description' => 'ઘાટા &amp; ત્રાંસા',
	'wikieditor-toolbar-help-content-bolditalic-syntax' => "'''''ઘાટું &amp; ત્રાસુ લેખન'''''",
	'wikieditor-toolbar-help-content-bolditalic-result' => '<strong><em>ઘાટું &amp; ત્રાંસુ લખાણ</em></strong>',
	'wikieditor-toolbar-help-content-ilink-description' => 'આંતરિક કડી',
	'wikieditor-toolbar-help-content-ilink-syntax' => '[[પાનાં શીર્ષક|કડી લેબલ]]<br />[[પાનાં શીર્ષક]]',
	'wikieditor-toolbar-help-content-ilink-result' => "<a href='#'>કડી લેબલ</a><br /><a href='#'>પાનાં શીર્ષક</a>",
	'wikieditor-toolbar-help-content-xlink-description' => 'બાહ્ય કડી',
	'wikieditor-toolbar-help-content-xlink-syntax' => '[http://www.example.org Link label]<br />[http://www.example.org]<br />http://www.example.org',
	'wikieditor-toolbar-help-content-xlink-result' => "<a href='#' class='external'>લિંક લેબલ</a><br /><a href='#' class='external autonumber'>[1]</a><br /><a href='#' class='external'>http://www.example.org</a>",
	'wikieditor-toolbar-help-content-heading2-description' => 'બીજા સ્તરનું મથાળું',
	'wikieditor-toolbar-help-content-heading2-syntax' => '== મથાળાના અક્ષરો ==',
	'wikieditor-toolbar-help-content-heading2-result' => '<h2>મથાળાનાં અક્ષરો</h2>',
	'wikieditor-toolbar-help-content-heading3-description' => 'ત્રીજા સ્તરનું મથાળું',
	'wikieditor-toolbar-help-content-heading3-syntax' => '=== મથાળાના અક્ષરો ===',
	'wikieditor-toolbar-help-content-heading3-result' => '<h3>મથાળાનાં અક્ષરો</h3>',
	'wikieditor-toolbar-help-content-heading4-description' => 'ચોથા સ્તરનું મથાળું',
	'wikieditor-toolbar-help-content-heading4-syntax' => '==== મથાળાના અક્ષરો ====',
	'wikieditor-toolbar-help-content-heading4-result' => '<h4>મથાળાનાં અક્ષરો</h4>',
	'wikieditor-toolbar-help-content-heading5-description' => 'પાંચમાં સ્તરનું મથાળું',
	'wikieditor-toolbar-help-content-heading5-syntax' => '===== મથાળાના અક્ષરો =====',
	'wikieditor-toolbar-help-content-heading5-result' => '<h5>મથાળાનાં અક્ષરો</h5>',
	'wikieditor-toolbar-help-content-ulist-description' => 'ચિન્હાંકીત યાદી',
	'wikieditor-toolbar-help-content-ulist-syntax' => '* વસ્તુ યાદી<br />* વસ્તુ યાદી',
	'wikieditor-toolbar-help-content-ulist-result' => '<ul><li>યાદી વસ્તુ</li><li>યાદી વસ્તુ</li></ul>',
	'wikieditor-toolbar-help-content-olist-description' => 'ક્રમગત: યાદી',
	'wikieditor-toolbar-help-content-olist-syntax' => '# યાદી વસ્તુ<br /># યાદી વસ્તુ',
	'wikieditor-toolbar-help-content-olist-result' => '<ol><li>વસ્તુ યાદી</li><li>વસ્તુ યાદી</li></ol>',
	'wikieditor-toolbar-help-content-file-description' => 'અંદર વણાયેલી (Embedded) ફાઇલ',
	'wikieditor-toolbar-help-content-file-syntax' => '[[$1:Example.png|thumb|કેપ્શન લખાણ]]',
	'wikieditor-toolbar-help-content-file-result' => "<div style='width:104px;' class='thumbinner'><a title='Caption text' class='image' href='#'><img height='50' width='100' border='0' class='thumbimage' src='$2/WikiEditor/modules/images/toolbar/example-image.png' alt=''/></a><div class='thumbcaption'><div class='magnify'><a title='Enlarge' class='internal' href='#'><img height='11' width='15' alt='' src='$1/common/images/magnify-clip.png'/></a></div>Caption text</div></div>",
	'wikieditor-toolbar-help-content-reference-description' => 'સંદર્ભ',
	'wikieditor-toolbar-help-content-reference-syntax' => 'પાનાં લખાણ.&lt;ref name="test"&gt;[http://www.example.org કડી લખાણ], વધારાનું લખાણ.&lt;/ref&gt;',
	'wikieditor-toolbar-help-content-reference-result' => "પૃષ્ઠ લેખન.<sup><a href='#'>[1]</a></sup>",
	'wikieditor-toolbar-help-content-rereference-description' => 'તેજ સંદર્ભનો વધારાનો વપરાશ',
	'wikieditor-toolbar-help-content-rereference-result' => "પૃષ્ઠ લેખન.<sup><a href='#'>[1]</a></sup>",
	'wikieditor-toolbar-help-content-showreferences-description' => 'સંદર્ભો દર્શાવો',
	'wikieditor-toolbar-help-content-showreferences-result' => "<ol class='references'><li id='cite_note-test-0'><b><a title='' href='#'>^</a></b> <a rel='nofollow' title='http://www.example.org' class='external text' href='#'>કડીની માહિતી</a>, વધારાની માહિતી.</li></ol>",
	'wikieditor-toolbar-help-content-signaturetimestamp-description' => 'સમયછાપ સાથે હસ્તાક્ષર',
	'wikieditor-toolbar-help-content-signaturetimestamp-result' => "<a href='#' title='{{#special:mypage}}'>સભ્યનામ</a> (<a href='#' title='{{#special:mytalk}}'>talk</a>) 15:54, 10 June 2009 (UTC)",
	'wikieditor-toolbar-help-content-signature-description' => 'હસ્તાક્ષર',
	'wikieditor-toolbar-help-content-signature-result' => "<a href='#' title='{{#special:mypage}}'>સભ્યનામ</a> (<a href='#' title='{{#special:mytalk}}'>ચર્ચા</a>)",
	'wikieditor-toolbar-help-content-indent-description' => 'હાંસિયો',
	'wikieditor-toolbar-help-content-indent-syntax' => 'સામાન્ય અક્ષરો<br />:હાંસિયા મારેલા અક્ષરો<br />::હાંસિયા મારેલા અક્ષરો',
	'wikieditor-toolbar-help-content-indent-result' => 'સામાન્ય લેખન<dl><dd>હાંસિયા મારેલ લેખન<dl><dd>હાંસિયા મારેલ લેખન</dd></dl></dd></dl>',
);

/** Manx (Gaelg)
 * @author MacTire02
 * @author Shimmin Beg
 */
$messages['gv'] = array(
	'wikieditor-wikitext-tab' => 'Teks wiki',
	'wikieditor-loading' => 'Laadey',
	'wikieditor-preview-preference' => 'Lhiggey da roie-haishbynys çheu-ry-heu',
	'wikieditor-preview-tab' => 'Roie-haishbynys',
	'wikieditor-preview-changes-tab' => 'Caghlaaghyn',
	'wikieditor-preview-loading' => 'Laadey...',
	'wikieditor-publish-preference' => 'Lhiggey da soilshaghey magh beggan er veggan',
	'wikieditor-publish-button-publish' => 'Soilshaghey magh',
	'wikieditor-publish-button-cancel' => 'Dolley magh',
	'wikieditor-publish-dialog-title' => 'Soilshaghey magh myr {{SITENAME}}',
	'wikieditor-publish-dialog-summary' => 'Giare-choontey (insh dooin dy giare ny ren uss caghlaa):',
	'wikieditor-publish-dialog-minor' => 'Myn-arraghey',
	'wikieditor-publish-dialog-watch' => 'Freill arrey er y duillag shoh',
	'wikieditor-publish-dialog-publish' => 'Soilshaghey magh',
	'wikieditor-publish-dialog-goback' => 'Erash',
	'wikieditor-template-editor-preference' => 'Lhiggey dhyt reaghey clowanyn liorish formyn',
	'wikieditor-template-editor-dialog-title' => 'Reaghey clowan',
	'wikieditor-template-editor-dialog-submit' => 'Jannoo ass y noa',
	'wikieditor-template-editor-dialog-cancel' => 'Dolley magh',
	'wikieditor-templates-preference' => 'Lhiggey da clowanyn filley',
	'wikieditor-toc-preference' => 'Lhiggey da claare chooid yn-stiurey',
	'wikieditor-toc-show' => 'Taishbyney',
	'wikieditor-toc-hide' => 'Follaghey',
	'wikieditor-toolbar' => 'Barr greieyn reaghey',
	'wikieditor-toolbar-desc' => 'Barr greieyn reaghey tooilley yn-ymmydey',
	'wikieditor-toolbar-preference' => 'Lhiggey da barr greieyn reaghey tooilley yn-ymmydey',
	'wikieditor-toolbar-dialogs-preference' => 'Lhiggey da kishtaghyn cooney dys cur stiagh kianglaghyn, taabylyn as reddyn elley',
	'wikieditor-toolbar-loading' => 'Laadey...',
	'wikieditor-toolbar-tool-bold' => 'Trome',
	'wikieditor-toolbar-tool-bold-example' => 'Teks trome',
	'wikieditor-toolbar-tool-italic' => 'Iddaalagh',
	'wikieditor-toolbar-tool-italic-example' => 'Teks iddaalagh',
	'wikieditor-toolbar-tool-ilink' => 'Kiangley sthie',
	'wikieditor-toolbar-tool-ilink-example' => 'Ennym y chiangley',
	'wikieditor-toolbar-tool-xlink' => 'Kiangley mooie (chooinee y meer roish http://)',
	'wikieditor-toolbar-tool-xlink-example' => 'http://www.sampleyr.com ennym kiangley',
	'wikieditor-toolbar-tool-link' => 'Kiangley',
	'wikieditor-toolbar-tool-link-title' => 'Cur stiagh kiangley',
	'wikieditor-toolbar-tool-link-int' => 'Da duillag wiki',
	'wikieditor-toolbar-tool-link-int-target' => 'Duillag ny kiangley er laccal',
	'wikieditor-toolbar-tool-link-int-target-tooltip' => 'Ennym ny kiangley y duillag',
	'wikieditor-toolbar-tool-link-int-text' => 'Teks y chiangley',
	'wikieditor-toolbar-tool-link-int-text-tooltip' => 'Teks y hoilshaghey',
	'wikieditor-toolbar-tool-link-ext' => 'Da ynnyd-eggey çheumooie',
	'wikieditor-toolbar-tool-link-ext-target' => 'URL y chiangley',
	'wikieditor-toolbar-tool-link-ext-text' => 'Teks y chiangley',
	'wikieditor-toolbar-tool-link-insert' => 'Cur stiagh kiangley',
	'wikieditor-toolbar-tool-link-cancel' => 'Dolley magh',
	'wikieditor-toolbar-tool-link-int-target-status-exists' => "Ta'n duillag ayn",
	'wikieditor-toolbar-tool-link-int-target-status-notexists' => 'Cha nel y duillag ayn',
	'wikieditor-toolbar-tool-link-int-target-status-invalid' => 'Ennym gyn vree',
	'wikieditor-toolbar-tool-link-int-target-status-external' => 'Kiangley çheumooie',
	'wikieditor-toolbar-tool-link-int-target-status-loading' => "Firrinaghey my ta'n duillag ayn...",
	'wikieditor-toolbar-tool-link-int-invalid' => 'Hug oo stiagh ennym gyn vree.',
	'wikieditor-toolbar-tool-link-lookslikeinternal' => "Rere y chiangley hug oo stiagh, t'eh jeeaghyn dy row eh foyd kiangley rish duillag wiki elley.
By vie lhiat jannoo kiangley çheusthie jeh?",
	'wikieditor-toolbar-tool-link-lookslikeinternal-int' => 'Kiangley sthie',
	'wikieditor-toolbar-tool-link-lookslikeinternal-ext' => 'Kiangley mooie',
	'wikieditor-toolbar-tool-link-empty' => 'Cha dug oo stiagh red erbee dy chiangley rish.',
	'wikieditor-toolbar-tool-file' => 'Coadan jingit',
	'wikieditor-toolbar-tool-file-example' => 'Sampleyr.jpg',
	'wikieditor-toolbar-tool-reference' => 'Imraa',
	'wikieditor-toolbar-tool-reference-example' => 'Cur stiagh teks fo-screeuyn ayns shoh',
	'wikieditor-toolbar-tool-reference-cancel' => 'Dolley magh',
	'wikieditor-toolbar-tool-reference-title' => 'Cur imraa stiagh',
	'wikieditor-toolbar-tool-reference-insert' => 'Cur stiagh',
	'wikieditor-toolbar-tool-reference-text' => 'Teks yn imraa',
	'wikieditor-toolbar-tool-signature' => 'Ennym screeuit as stampey traa',
	'wikieditor-toolbar-section-advanced' => 'Cast',
	'wikieditor-toolbar-tool-heading' => 'Kione-linney',
	'wikieditor-toolbar-tool-heading-1' => 'Keim 1',
	'wikieditor-toolbar-tool-heading-2' => 'Keim 2',
	'wikieditor-toolbar-tool-heading-3' => 'Keim 3',
	'wikieditor-toolbar-tool-heading-4' => 'Keim 4',
	'wikieditor-toolbar-tool-heading-5' => 'Keim 5',
	'wikieditor-toolbar-tool-heading-example' => 'Teks y chione-linney',
	'wikieditor-toolbar-group-format' => 'Cummey',
	'wikieditor-toolbar-tool-ulist' => 'Rolley bulladit',
	'wikieditor-toolbar-tool-ulist-example' => 'Meer rolley bulladit',
	'wikieditor-toolbar-tool-olist' => 'Rolley earrit',
	'wikieditor-toolbar-tool-olist-example' => 'Meer rolley earrit',
	'wikieditor-toolbar-tool-indent' => 'Jingey',
	'wikieditor-toolbar-tool-indent-example' => 'Linney er ny jinney',
	'wikieditor-toolbar-tool-nowiki' => 'Ny chur tastey da cummey wikiagh',
	'wikieditor-toolbar-tool-nowiki-example' => 'Cur stiagh teks gyn cummey ayns shoh',
	'wikieditor-toolbar-tool-redirect' => 'Aa-enmys',
	'wikieditor-toolbar-tool-redirect-example' => 'Ennym duillag er laccal',
	'wikieditor-toolbar-tool-big' => 'Mooar',
	'wikieditor-toolbar-tool-big-example' => 'Teks mooar',
	'wikieditor-toolbar-tool-small' => 'Beg',
	'wikieditor-toolbar-tool-small-example' => 'Teks beg',
	'wikieditor-toolbar-tool-superscript' => 'Erskyn-screeuit',
	'wikieditor-toolbar-tool-superscript-example' => 'Teks erskyn-screeuit',
	'wikieditor-toolbar-tool-subscript' => 'Fo-screeuit',
	'wikieditor-toolbar-tool-subscript-example' => 'Teks fo-screeuit',
	'wikieditor-toolbar-group-insert' => 'Cur stiagh',
	'wikieditor-toolbar-tool-gallery' => 'Galleree jallooyn',
	'wikieditor-toolbar-tool-gallery-example' => '$1:Example.jpg|Fo-heidyl1
$1:Example.jpg|Fo-heidyl2',
	'wikieditor-toolbar-tool-newline' => 'Linney noa',
	'wikieditor-toolbar-tool-table' => 'Taabyl',
	'wikieditor-toolbar-tool-table-example-old' => '-
! kione-linney 1
! kione-linney 2
! kione-linney 3
|-
| roa 1, killag 1
| roa 1, killag 2
| roa 1, killag 3
|-
| roa 2, killag 1
| roa 2, killag 2
| roa 2, killag 3',
	'wikieditor-toolbar-tool-table-example-cell-text' => 'Teks ny killag',
	'wikieditor-toolbar-tool-table-example-header' => 'Teks ny kione-linney',
	'wikieditor-toolbar-tool-table-title' => 'Cur taabyl stiagh',
	'wikieditor-toolbar-tool-table-dimensions-rows' => 'Roaghyn',
	'wikieditor-toolbar-tool-table-dimensions-columns' => 'Collooghyn',
	'wikieditor-toolbar-tool-table-dimensions-header' => 'Cur stiagh roa kione-linney',
	'wikieditor-toolbar-tool-table-wikitable' => 'Cur creeaghyn er',
	'wikieditor-toolbar-tool-table-sortable' => 'Jean eh yn-sorçhal',
	'wikieditor-toolbar-tool-table-example' => 'Sampleyr',
	'wikieditor-toolbar-tool-table-preview' => 'Roie-haishbynys',
	'wikieditor-toolbar-tool-table-insert' => 'Cur stiagh',
	'wikieditor-toolbar-tool-table-cancel' => 'Dolley magh',
	'wikieditor-toolbar-tool-table-toomany' => 'Cha nod oo cur stiagh taabyl as ny smoo na $1 killag echey liorish y chishtey cooney shoh.',
	'wikieditor-toolbar-tool-table-invalidnumber' => 'Cha dug oo stiagh earroo cooie dy roaghyn ny collooghyn.',
	'wikieditor-toolbar-tool-table-zero' => 'Cha nod oo cur stiagh taabyl gyn roaghyn ny collooghyn.',
	'wikieditor-toolbar-tool-replace' => 'Ronsaghey as coonrey',
	'wikieditor-toolbar-tool-replace-title' => 'Ronsaghey as coonrey',
	'wikieditor-toolbar-tool-replace-search' => 'Ronsaghey er son:',
	'wikieditor-toolbar-tool-replace-replace' => 'Caghlaa dys:',
	'wikieditor-toolbar-tool-replace-case' => 'Cur tastey da case',
	'wikieditor-toolbar-tool-replace-regex' => 'Gra dy nee slonn reiltagh eh y raa ry-hirrey',
	'wikieditor-toolbar-tool-replace-button-findnext' => "Feddyn y nah 'er",
	'wikieditor-toolbar-tool-replace-button-replaceall' => 'Caghlaa dagh fer',
	'wikieditor-toolbar-tool-replace-close' => 'Dooney',
	'wikieditor-toolbar-tool-replace-nomatch' => 'Cha row y raa ry-hirrey ayd ry-akin.',
	'wikieditor-toolbar-tool-replace-success' => '$1 c(h)aghlaa(ghyn) jeant.',
	'wikieditor-toolbar-tool-replace-emptysearch' => 'Cha dug oo stiagh red erbee dy hirrey.',
	'wikieditor-toolbar-tool-replace-invalidregex' => 'Hug oo stiagh slonn reiltagh gyn vree: $1',
	'wikieditor-toolbar-section-characters' => 'Cowraghyn er lheh',
	'wikieditor-toolbar-characters-page-latin' => 'Romanagh',
	'wikieditor-toolbar-characters-page-latinextended' => 'Romanagh sheeynt',
	'wikieditor-toolbar-characters-page-ipa' => 'ASE',
	'wikieditor-toolbar-characters-page-symbols' => 'Cowraghyn',
	'wikieditor-toolbar-characters-page-greek' => 'Greagagh',
	'wikieditor-toolbar-characters-page-cyrillic' => 'Kyrillagh',
	'wikieditor-toolbar-characters-page-arabic' => 'Arabagh',
	'wikieditor-toolbar-characters-page-persian' => 'Pershish',
	'wikieditor-toolbar-characters-page-hebrew' => 'Ewagh',
	'wikieditor-toolbar-characters-page-bangla' => 'Bengaalish',
	'wikieditor-toolbar-characters-page-telugu' => 'Telugish',
	'wikieditor-toolbar-characters-page-sinhala' => 'Sinhalish',
	'wikieditor-toolbar-characters-page-gujarati' => 'Gujaratish',
	'wikieditor-toolbar-characters-page-thai' => 'Thaish',
	'wikieditor-toolbar-characters-page-lao' => 'Laosish',
	'wikieditor-toolbar-characters-page-khmer' => 'Khmerish',
	'wikieditor-toolbar-section-help' => 'Cooney',
	'wikieditor-toolbar-help-heading-description' => 'Coontey',
	'wikieditor-toolbar-help-heading-syntax' => "Ny t'ou uss screeu",
	'wikieditor-toolbar-help-heading-result' => 'Ny vaikys oo',
	'wikieditor-toolbar-help-page-format' => 'Cummey',
	'wikieditor-toolbar-help-page-link' => 'Kianglaghyn',
	'wikieditor-toolbar-help-page-heading' => 'Kione-linnaghyn',
	'wikieditor-toolbar-help-page-list' => 'Rollaghyn',
	'wikieditor-toolbar-help-page-file' => 'Coadanyn',
	'wikieditor-toolbar-help-page-reference' => 'Imraaghyn',
	'wikieditor-toolbar-help-page-discussion' => 'Resoonaght',
	'wikieditor-toolbar-help-content-italic-description' => 'Iddaalagh',
	'wikieditor-toolbar-help-content-italic-syntax' => "''Clou iddaalagh''",
	'wikieditor-toolbar-help-content-italic-result' => '<em>Teks iddaalagh</em>',
	'wikieditor-toolbar-help-content-bold-description' => 'Trome',
	'wikieditor-toolbar-help-content-bold-syntax' => "'''Clou trome'''",
	'wikieditor-toolbar-help-content-bold-result' => '<strong>Teks trome</strong>',
	'wikieditor-toolbar-help-content-bolditalic-description' => 'Trome &amp; iddaalagh',
	'wikieditor-toolbar-help-content-bolditalic-syntax' => "'''''Teks trome &amp; iddaalagh'''''",
	'wikieditor-toolbar-help-content-bolditalic-result' => '<strong><em>Teks trome &amp; iddaalagh</em></strong>',
	'wikieditor-toolbar-help-content-ilink-description' => 'Kiangley yn-veanagh',
	'wikieditor-toolbar-help-content-ilink-syntax' => '[[Ennym duillag|Teks kiangley]]<br />[[Ennym duillag]]',
	'wikieditor-toolbar-help-content-ilink-result' => "<a href='#'>Teks kiangley</a><br /><a href='#'>Ennym duillag</a>",
	'wikieditor-toolbar-help-content-xlink-description' => 'Kiangley mooie',
	'wikieditor-toolbar-help-content-xlink-syntax' => '[http://www.example.org Teks kiangley]<br />[http://www.example.org]<br />http://www.example.org',
	'wikieditor-toolbar-help-content-xlink-result' => "<a href='#' class='external'>Teks kiangley</a><br /><a href='#' class='external autonumber'>[1]</a><br /><a href='#' class='external'>http://www.example.org</a>",
	'wikieditor-toolbar-help-content-heading2-description' => 'Kione-linney y nah cheim',
	'wikieditor-toolbar-help-content-heading2-syntax' => '== Kione-linney ==',
	'wikieditor-toolbar-help-content-heading2-result' => '<h2>Kione-linney</h2>',
	'wikieditor-toolbar-help-content-heading3-description' => 'Kione-linney y treeoo cheim',
	'wikieditor-toolbar-help-content-heading3-syntax' => '=== Kione-linney ===',
	'wikieditor-toolbar-help-content-heading3-result' => '<h3>Kione-linney</h3>',
	'wikieditor-toolbar-help-content-heading4-description' => 'Kione-linney y chiarroo cheim',
	'wikieditor-toolbar-help-content-heading4-syntax' => '==== Kione-linney ====',
	'wikieditor-toolbar-help-content-heading4-result' => '<h4>Kione-linney</h4>',
	'wikieditor-toolbar-help-content-heading5-description' => 'Kione-linney y wheiggoo cheim',
	'wikieditor-toolbar-help-content-heading5-syntax' => '===== Kione-linney =====',
	'wikieditor-toolbar-help-content-heading5-result' => '<h5>Kione-linney</h5>',
	'wikieditor-toolbar-help-content-ulist-description' => 'Rolley bulladagh',
	'wikieditor-toolbar-help-content-ulist-syntax' => '* Meer rolley<br />* Meer rolley',
	'wikieditor-toolbar-help-content-ulist-result' => '<ul><li>Meer rolley</li><li>Meer rolley</li></ul>',
	'wikieditor-toolbar-help-content-olist-description' => 'Rolley earrit',
	'wikieditor-toolbar-help-content-olist-syntax' => '# Meer rolley<br /># Meer rolley',
	'wikieditor-toolbar-help-content-olist-result' => '<ol><li>Meer rolley</li><li>Meer rolley</li></ol>',
	'wikieditor-toolbar-help-content-file-description' => 'Coadan jingit',
	'wikieditor-toolbar-help-content-file-syntax' => '[[$1:Example.png|thumb|Teks fo-heidyl]]',
	'wikieditor-toolbar-help-content-file-result' => "<div style='width:104px;' class='thumbinner'><a title='Teks fo-heidyl' class='image' href='#'><img height='50' width='100' border='0' class='thumbimage' src='$2/WikiEditor/modules/images/toolbar/example-image.png' alt=''/></a><div class='thumbcaption'><div class='magnify'><a title='Mooadaghey' class='internal' href='#'><img height='11' width='15' alt='' src='$1/common/images/magnify-clip.png'/></a></div>Teks fo-heidyl</div></div>",
	'wikieditor-toolbar-help-content-reference-description' => 'Imraa',
	'wikieditor-toolbar-help-content-reference-syntax' => 'Teks duillag.&lt;ref name="test"&gt;[http://www.example.org Teks kiangley], tooilley teks.&lt;/ref&gt;',
	'wikieditor-toolbar-help-content-reference-result' => "Teks duillag.<sup><a href='#'>[1]</a></sup>",
	'wikieditor-toolbar-help-content-rereference-description' => "Tooilley ymmyd jeh'n imraa cheddin",
	'wikieditor-toolbar-help-content-rereference-result' => "Teks duillag.<sup><a href='#'>[1]</a></sup>",
	'wikieditor-toolbar-help-content-showreferences-description' => 'Soilshaghey imraaghyn',
	'wikieditor-toolbar-help-content-showreferences-result' => "<ol class='references'><li id='cite_note-test-0'><b><a title='' href='#'>^</a></b> <a rel='nofollow' title='http://www.example.org' class='external text' href='#'>Teks kiangley</a>, tooilley teks.</li></ol>",
	'wikieditor-toolbar-help-content-signaturetimestamp-description' => 'Ennym screeuit as stampey traa',
	'wikieditor-toolbar-help-content-signaturetimestamp-result' => "<a href='#' title='{{#special:mypage}}'>Ymmydeyr</a> (<a href='#' title='{{#special:mytalk}}'>resoonaght</a>) 15:54, 10 Mean Souree 2009 (UTC)",
	'wikieditor-toolbar-help-content-signature-description' => 'Ennym screeuit',
	'wikieditor-toolbar-help-content-signature-result' => "<a href='#' title='{{#special:mypage}}'>Ymmydeyr</a> (<a href='#' title='{{#special:mytalk}}'>resoonaght</a>)",
	'wikieditor-toolbar-help-content-indent-description' => 'Jingey',
	'wikieditor-toolbar-help-content-indent-syntax' => 'Teks cadjin<br />:Teks jingit<br />::Teks jingit',
	'wikieditor-toolbar-help-content-indent-result' => 'Teks cadjin<dl><dd>Teks jingit<dl><dd>Teks jingit</dd></dl></dd></dl>',
);

/** Hausa (Hausa) */
$messages['ha'] = array(
	'wikieditor-template-editor-dialog-cancel' => 'Soke',
	'wikieditor-toolbar-tool-bold-example' => 'Rubutu mai gwaɓi',
	'wikieditor-toolbar-tool-italic-example' => 'Rubutun tsutsa',
	'wikieditor-toolbar-tool-ilink' => 'Mahaɗin ciki',
	'wikieditor-toolbar-tool-ilink-example' => 'Sunan mahaɗi',
	'wikieditor-toolbar-tool-xlink' => 'Mahaɗi mai zuwa waje (a tuna da zagin http://)',
	'wikieditor-toolbar-tool-xlink-example' => 'http://www.example.com sunan mahaɗi',
	'wikieditor-toolbar-tool-link-cancel' => 'Soke',
	'wikieditor-toolbar-tool-reference-cancel' => 'Soke',
	'wikieditor-toolbar-tool-table-cancel' => 'Soke',
);

/** Hebrew (עברית)
 * @author Amire80
 * @author Rotemliss
 * @author YaronSh
 * @author Yonidebest
 * @author חיים
 */
$messages['he'] = array(
	'wikieditor' => 'ממשק מתקדם לעריכת טקסט ויקי',
	'wikieditor-desc' => 'מספקת מנשק עריכת ויקיטקסט הניתן להרחבה ומודולים המאפשרים להוסיף יכולות',
	'wikieditor-wikitext-tab' => 'קוד ויקי',
	'wikieditor-loading' => 'בטעינה',
	'wikieditor-preview-preference' => 'הפעלת תצוגה מקדימה מקבילה',
	'wikieditor-preview-tab' => 'תצוגה מקדימה',
	'wikieditor-preview-changes-tab' => 'שינויים',
	'wikieditor-preview-loading' => 'נטען...',
	'wikieditor-previewDialog-preference' => 'הפעלת תיבת דו־שיח התצוגה המקדימה',
	'wikieditor-previewDialog-tab' => 'תצוגה מקדימה',
	'wikieditor-previewDialog-loading' => 'נטען...',
	'wikieditor-publish-preference' => 'הפעלת פרסום "צעד־אחר־צעד"',
	'wikieditor-publish-button-publish' => 'פרסום',
	'wikieditor-publish-button-cancel' => 'ביטול',
	'wikieditor-publish-dialog-title' => 'פרסום אל {{SITENAME}}',
	'wikieditor-publish-dialog-summary' => 'תקציר העריכה (תיאור קצר של השינויים שעשיתם):',
	'wikieditor-publish-dialog-minor' => 'עריכה משנית',
	'wikieditor-publish-dialog-watch' => 'מעקב אחר דף זה',
	'wikieditor-publish-dialog-publish' => 'פרסום',
	'wikieditor-publish-dialog-goback' => 'חזרה אחורה',
	'wikieditor-template-editor-preference' => 'הפעלת עריכה מבוססת טופס של תבניות ויקי',
	'wikieditor-template-editor-dialog-title' => 'עריכת התבנית',
	'wikieditor-template-editor-dialog-submit' => 'עדכון',
	'wikieditor-template-editor-dialog-cancel' => 'ביטול',
	'wikieditor-templates-preference' => 'הפעלת קיפול תבניות',
	'wikieditor-toc-preference' => 'הפעלת תוכן עניינים עם אפשרות ניווט',
	'wikieditor-toc-show' => 'להציג תוכן עניינים',
	'wikieditor-toc-hide' => 'להסתיר תוכן עניינים',
	'wikieditor-toolbar' => 'סרגל עריכה',
	'wikieditor-toolbar-desc' => 'הרחבת השמישות של סרגל עריכת הדף',
	'wikieditor-toolbar-preference' => 'הפעלת סרגל עריכה משופר',
	'wikieditor-toolbar-dialogs-preference' => 'הפעלת תיבות דו־שיח להוספת קישורים, טבלאות ועוד',
	'wikieditor-toolbar-hidesig' => 'להחביא את כפתור החתימה מהדפים במרחב הראשי',
	'wikieditor-toolbar-loading' => 'בטעינה...',
	'wikieditor-toolbar-tool-bold' => 'הדגשה',
	'wikieditor-toolbar-tool-bold-example' => 'טקסט מודגש',
	'wikieditor-toolbar-tool-italic' => 'הטיה',
	'wikieditor-toolbar-tool-italic-example' => 'טקסט נטוי',
	'wikieditor-toolbar-tool-ilink' => 'קישור פנימי',
	'wikieditor-toolbar-tool-ilink-example' => 'כותרת הקישור',
	'wikieditor-toolbar-tool-xlink' => 'קישור חיצוני (זכרו להוסיף את הקידומת http://)',
	'wikieditor-toolbar-tool-xlink-example' => 'http://www.example.com כותרת הקישור',
	'wikieditor-toolbar-tool-link' => 'קישור',
	'wikieditor-toolbar-tool-link-title' => 'הוספת קישור',
	'wikieditor-toolbar-tool-link-int' => 'לדף ויקי',
	'wikieditor-toolbar-tool-link-int-target' => 'כותרת הדף:',
	'wikieditor-toolbar-tool-link-int-target-tooltip' => 'כותרת הדף או כתובת URL',
	'wikieditor-toolbar-tool-link-int-text' => 'טקסט הקישור:',
	'wikieditor-toolbar-tool-link-int-text-tooltip' => 'הזינו את הטקסט המיועד לתצוגה',
	'wikieditor-toolbar-tool-link-ext' => 'לדף אינטרנט חיצוני',
	'wikieditor-toolbar-tool-link-ext-target' => 'כתובת הקישור:',
	'wikieditor-toolbar-tool-link-ext-text' => 'טקסט הקישור:',
	'wikieditor-toolbar-tool-link-insert' => 'הוספת הקישור',
	'wikieditor-toolbar-tool-link-cancel' => 'ביטול',
	'wikieditor-toolbar-tool-link-int-target-status-exists' => 'הדף קיים',
	'wikieditor-toolbar-tool-link-int-target-status-notexists' => 'הדף אינו קיים',
	'wikieditor-toolbar-tool-link-int-target-status-invalid' => 'כותרת בלתי תקינה',
	'wikieditor-toolbar-tool-link-int-target-status-external' => 'קישור חיצוני',
	'wikieditor-toolbar-tool-link-int-target-status-loading' => 'בדיקה האם הדף קיים...',
	'wikieditor-toolbar-tool-link-int-invalid' => 'הכותרת שצוינה אינה תקינה.',
	'wikieditor-toolbar-tool-link-lookslikeinternal' => 'הכתובת שציינתם נראית כאילו היא מיועדת לקשר לדף אחר בוויקי. האם ברצונכם להפוך זאת לקישור פנימי?',
	'wikieditor-toolbar-tool-link-lookslikeinternal-int' => 'קישור פנימי',
	'wikieditor-toolbar-tool-link-lookslikeinternal-ext' => 'קישור חיצוני',
	'wikieditor-toolbar-tool-link-empty' => 'לא הזנתם שום דבר לקשר אליו.',
	'wikieditor-toolbar-tool-file' => 'קובץ המוצג בדף',
	'wikieditor-toolbar-tool-file-example' => 'דוגמה.jpg',
	'wikieditor-toolbar-tool-file-title' => 'הוספת קובץ',
	'wikieditor-toolbar-file-target' => 'שם הקובץ:',
	'wikieditor-toolbar-file-caption' => 'תיאור:',
	'wikieditor-toolbar-file-size' => 'גודל:',
	'wikieditor-toolbar-file-float' => 'יישור:',
	'wikieditor-toolbar-file-default' => '(ברירת מחדל)',
	'wikieditor-toolbar-file-format' => 'עיצוב:',
	'wikieditor-toolbar-file-format-none' => 'אין',
	'wikieditor-toolbar-tool-file-insert' => 'הוספה',
	'wikieditor-toolbar-tool-file-cancel' => 'ביטול',
	'wikieditor-toolbar-tool-reference' => 'הערת שוליים',
	'wikieditor-toolbar-tool-reference-example' => 'כתבו את טקסט הערת השוליים כאן',
	'wikieditor-toolbar-tool-reference-cancel' => 'ביטול',
	'wikieditor-toolbar-tool-reference-title' => 'הוספת הערת שוליים',
	'wikieditor-toolbar-tool-reference-insert' => 'הוספה',
	'wikieditor-toolbar-tool-reference-text' => 'תוכן ההערה',
	'wikieditor-toolbar-tool-signature' => 'חתימה ותאריך ושעה',
	'wikieditor-toolbar-section-advanced' => 'מתקדם',
	'wikieditor-toolbar-tool-heading' => 'כותרת',
	'wikieditor-toolbar-tool-heading-1' => 'רמה 1',
	'wikieditor-toolbar-tool-heading-2' => 'רמה 2',
	'wikieditor-toolbar-tool-heading-3' => 'רמה 3',
	'wikieditor-toolbar-tool-heading-4' => 'רמה 4',
	'wikieditor-toolbar-tool-heading-5' => 'רמה 5',
	'wikieditor-toolbar-tool-heading-example' => 'טקסט הכותרת',
	'wikieditor-toolbar-group-format' => 'מבנה:',
	'wikieditor-toolbar-tool-ulist' => 'רשימה עם תבליטים',
	'wikieditor-toolbar-tool-ulist-example' => 'פריט רשימה עם תבליטים',
	'wikieditor-toolbar-tool-olist' => 'רשימה ממוספרת',
	'wikieditor-toolbar-tool-olist-example' => 'פריט רשימה ממוספרת',
	'wikieditor-toolbar-tool-indent' => 'הזחה',
	'wikieditor-toolbar-tool-indent-example' => 'שורה מוזחת',
	'wikieditor-toolbar-tool-nowiki' => 'ללא עיצוב ויקי',
	'wikieditor-toolbar-tool-nowiki-example' => 'טקסט לא מעוצב',
	'wikieditor-toolbar-tool-redirect' => 'הפניה',
	'wikieditor-toolbar-tool-redirect-example' => 'שם דף היעד',
	'wikieditor-toolbar-tool-big' => 'גדול',
	'wikieditor-toolbar-tool-big-example' => 'טקסט מוגדל',
	'wikieditor-toolbar-tool-small' => 'קטן',
	'wikieditor-toolbar-tool-small-example' => 'טקסט מוקטן',
	'wikieditor-toolbar-tool-superscript' => 'הגבהה',
	'wikieditor-toolbar-tool-superscript-example' => 'טקסט מוגבה',
	'wikieditor-toolbar-tool-subscript' => 'הנמכה',
	'wikieditor-toolbar-tool-subscript-example' => 'טקסט מונמך',
	'wikieditor-toolbar-group-insert' => 'הוספה',
	'wikieditor-toolbar-tool-gallery' => 'גלריית תמונות',
	'wikieditor-toolbar-tool-gallery-example' => '$1:דוגמה.jpg|כותרת 1
$1:דוגמה.jpg|כותרת 2',
	'wikieditor-toolbar-tool-newline' => 'שורה חדשה',
	'wikieditor-toolbar-tool-table' => 'טבלה',
	'wikieditor-toolbar-tool-table-example-old' => '-
! כותרת 1
! כותרת 2
! כותרת 3
|-
| שורה 1, תא 1
| שורה 1, תא 2
| שורה 1, תא 3
|-
| שורה 2, תא 1
| שורה 2, תא 2
| שורה 2, תא 3',
	'wikieditor-toolbar-tool-table-example-cell-text' => 'טקסט התא',
	'wikieditor-toolbar-tool-table-example-header' => 'טקסט הכותרת',
	'wikieditor-toolbar-tool-table-title' => 'הוספת טבלה',
	'wikieditor-toolbar-tool-table-dimensions-rows' => 'שורות',
	'wikieditor-toolbar-tool-table-dimensions-columns' => 'עמודות',
	'wikieditor-toolbar-tool-table-dimensions-header' => 'כולל שורת הכותרת',
	'wikieditor-toolbar-tool-table-wikitable' => 'סגנון עם מסגרות',
	'wikieditor-toolbar-tool-table-sortable' => 'הפיכת הטבלה לניתנת למיון',
	'wikieditor-toolbar-tool-table-example' => 'טקסט התא',
	'wikieditor-toolbar-tool-table-preview' => 'תצוגה מקדימה',
	'wikieditor-toolbar-tool-table-insert' => 'הוספה',
	'wikieditor-toolbar-tool-table-cancel' => 'ביטול',
	'wikieditor-toolbar-tool-table-example-text' => 'מַה־נָּעִים הָעֶרֶב לִלְבַב כָּל־גֶּבֶר, אִם מַר־נֶפֶשׁ הוּא, אִם גֶּבֶר צוֹלֵחַ; לָזֶה עִם הָעֶרֶב יָבֹא קֵץ שֶׁבֶר וָזֶה בָּעֶרֶב פִּי שֶׁבַע שָׂמֵחַ. כִּי רַעַשׁ הַיּוֹם, אוֹר שֶׁמֶשׁ זוֹרֵחַ, יַלְאוּ הַנֶּפֶשׁ וִיקַצְּצוּ הָאֵבֶר, וּבְדִמְמַת עֶרֶב אֶל נֹגַהּ יָרֵחַ תִּנָּפַשׁ אַף תַּחֲלִיף עָצְמָה וָשֵׁבֶר.',
	'wikieditor-toolbar-tool-table-toomany' => 'הוספת טבלה בת יותר מ־$1 תאים אינה אפשרית בתיבת הדו־שיח הזו.',
	'wikieditor-toolbar-tool-table-invalidnumber' => 'מספר השורות או העמודות שהוזן אינו תקין.',
	'wikieditor-toolbar-tool-table-zero' => 'לא ניתן להוסיף טבלה בעלת אפס שורות או עמודות.',
	'wikieditor-toolbar-tool-replace' => 'חיפוש והחלפה',
	'wikieditor-toolbar-tool-replace-title' => 'חיפוש והחלפה',
	'wikieditor-toolbar-tool-replace-search' => 'חיפוש של:',
	'wikieditor-toolbar-tool-replace-replace' => 'החלפה ב:',
	'wikieditor-toolbar-tool-replace-case' => 'התאמת רישיות',
	'wikieditor-toolbar-tool-replace-regex' => 'בדיקת מחרוזת החיפוש כביטוי רגולרי',
	'wikieditor-toolbar-tool-replace-button-findnext' => 'חיפוש הבא',
	'wikieditor-toolbar-tool-replace-button-replace' => 'החלפה',
	'wikieditor-toolbar-tool-replace-button-replaceall' => 'החלפת הכול',
	'wikieditor-toolbar-tool-replace-close' => 'סגירה',
	'wikieditor-toolbar-tool-replace-nomatch' => 'לא התקבלו התאמות לחיפושכם.',
	'wikieditor-toolbar-tool-replace-success' => 'בוצעו $1 החלפות.',
	'wikieditor-toolbar-tool-replace-emptysearch' => 'לא כתבתם טקסט לחיפוש.',
	'wikieditor-toolbar-tool-replace-invalidregex' => 'הביטוי הרגולרי שהוכנס אינו תקין: $1',
	'wikieditor-toolbar-section-characters' => 'תווים מיוחדים',
	'wikieditor-toolbar-characters-page-latin' => 'לטיני',
	'wikieditor-toolbar-characters-page-latinextended' => 'לטיני מורחב',
	'wikieditor-toolbar-characters-page-ipa' => 'אלפבית פונטי בינלאומי (IPA)',
	'wikieditor-toolbar-characters-page-symbols' => 'סימנים',
	'wikieditor-toolbar-characters-page-greek' => 'יווני',
	'wikieditor-toolbar-characters-page-cyrillic' => 'קירילי',
	'wikieditor-toolbar-characters-page-arabic' => 'ערבי',
	'wikieditor-toolbar-characters-page-arabicextended' => 'ערבי מורחב',
	'wikieditor-toolbar-characters-page-persian' => 'פרסית',
	'wikieditor-toolbar-characters-page-hebrew' => 'עברי',
	'wikieditor-toolbar-characters-page-bangla' => 'בנגלית',
	'wikieditor-toolbar-characters-page-tamil' => 'טמילית',
	'wikieditor-toolbar-characters-page-telugu' => 'טלוגו',
	'wikieditor-toolbar-characters-page-sinhala' => 'סינהלה',
	'wikieditor-toolbar-characters-page-gujarati' => "גוג'רטית",
	'wikieditor-toolbar-characters-page-devanagari' => 'דוונגארי',
	'wikieditor-toolbar-characters-page-thai' => 'תאית',
	'wikieditor-toolbar-characters-page-lao' => 'לאו',
	'wikieditor-toolbar-characters-page-khmer' => 'קמר',
	'wikieditor-toolbar-section-help' => 'עזרה',
	'wikieditor-toolbar-help-heading-description' => 'תיאור',
	'wikieditor-toolbar-help-heading-syntax' => 'מה יש להקליד',
	'wikieditor-toolbar-help-heading-result' => 'מה מתקבל',
	'wikieditor-toolbar-help-page-format' => 'עיצוב',
	'wikieditor-toolbar-help-page-link' => 'קישורים',
	'wikieditor-toolbar-help-page-heading' => 'כותרות',
	'wikieditor-toolbar-help-page-list' => 'רשימות',
	'wikieditor-toolbar-help-page-file' => 'קבצים',
	'wikieditor-toolbar-help-page-reference' => 'הערות שוליים',
	'wikieditor-toolbar-help-page-discussion' => 'דפי שיחה',
	'wikieditor-toolbar-help-content-italic-description' => 'הטיה',
	'wikieditor-toolbar-help-content-italic-syntax' => "''טקסט נטוי''",
	'wikieditor-toolbar-help-content-italic-result' => '<em>טקסט נטוי</em>',
	'wikieditor-toolbar-help-content-bold-description' => 'הדגשה',
	'wikieditor-toolbar-help-content-bold-syntax' => "'''טקסט מודגש'''",
	'wikieditor-toolbar-help-content-bold-result' => '<strong>טקסט מודגש</strong>',
	'wikieditor-toolbar-help-content-bolditalic-description' => 'הדגשה והטיה',
	'wikieditor-toolbar-help-content-bolditalic-syntax' => "'''''טקסט מודגש ונטוי'''''",
	'wikieditor-toolbar-help-content-bolditalic-result' => '<strong><em>טקסט מודגש ונטוי</em></strong>',
	'wikieditor-toolbar-help-content-ilink-description' => 'קישור פנימי',
	'wikieditor-toolbar-help-content-ilink-syntax' => '[[כותרת הדף|כותרת הקישור]]<br />[[כותרת הדף]]',
	'wikieditor-toolbar-help-content-ilink-result' => "<a href='#'>כותרת הקישור</a><br /><a href='#'>כותרת הדף</a>",
	'wikieditor-toolbar-help-content-xlink-description' => 'קישור חיצוני',
	'wikieditor-toolbar-help-content-xlink-syntax' => '[http://www.example.org כותרת הקישור]<br />[http://www.example.org]<br />http://www.example.org',
	'wikieditor-toolbar-help-content-xlink-result' => "<a href='#' class='external'>כותרת הקישור</a><br /><a href='#' class='external autonumber'>[1]</a><br /><a href='#' class='external'>http://www.example.org</a>",
	'wikieditor-toolbar-help-content-heading2-description' => 'רמת כותרת שנייה',
	'wikieditor-toolbar-help-content-heading2-syntax' => '== טקסט הכותרת ==',
	'wikieditor-toolbar-help-content-heading2-result' => '<h2>טקסט הכותרת</h2>',
	'wikieditor-toolbar-help-content-heading3-description' => 'רמת כותרת שלישית',
	'wikieditor-toolbar-help-content-heading3-syntax' => '=== טקסט הכותרת ===',
	'wikieditor-toolbar-help-content-heading3-result' => '<h3>טקסט הכותרת</h3>',
	'wikieditor-toolbar-help-content-heading4-description' => 'רמת כותרת רביעית',
	'wikieditor-toolbar-help-content-heading4-syntax' => '==== טקסט הכותרת ====',
	'wikieditor-toolbar-help-content-heading4-result' => '<h4>טקסט הכותרת</h4>',
	'wikieditor-toolbar-help-content-heading5-description' => 'רמת כותרת חמישית',
	'wikieditor-toolbar-help-content-heading5-syntax' => '===== טקסט הכותרת =====',
	'wikieditor-toolbar-help-content-heading5-result' => '<h5>טקסט הכותרת</h5>',
	'wikieditor-toolbar-help-content-ulist-description' => 'רשימה עם תבליטים',
	'wikieditor-toolbar-help-content-ulist-syntax' => '* פריט רשימה<br />* פריט רשימה',
	'wikieditor-toolbar-help-content-ulist-result' => '<ul><li>פריט רשימה</li><li>פריט רשימה</li></ul>',
	'wikieditor-toolbar-help-content-olist-description' => 'רשימה ממוספרת',
	'wikieditor-toolbar-help-content-olist-syntax' => '# פריט רשימה<br /># פריט רשימה',
	'wikieditor-toolbar-help-content-olist-result' => '<ol><li>פריט רשימה</li><li>פריט רשימה</li></ol>',
	'wikieditor-toolbar-help-content-file-description' => 'קובץ המוצג בדף',
	'wikieditor-toolbar-help-content-file-syntax' => '[[$1:Example.png|thumb|טקסט הכותרת]]',
	'wikieditor-toolbar-help-content-file-result' => "<div style='width:104px;' class='thumbinner'><a title='טקסט הכותרת' class='image' href='#'><img height='50' width='100' border='0' class='thumbimage' src='$2/WikiEditor/modules/images/toolbar/example-image.png' alt=''/></a><div class='thumbcaption'><div class='magnify'><a title='Enlarge' class='internal' href='#'><img height='11' width='15' alt='' src='$1/common/images/magnify-clip.png'/></a></div>טקסט הכותרת</div></div>",
	'wikieditor-toolbar-help-content-reference-description' => 'הערת שוליים',
	'wikieditor-toolbar-help-content-reference-syntax' => 'טקסט הדף.&lt;ref name="test"&gt;[http://www.example.org טקסט הקישור], טקסט נוסף.&lt;/ref&gt;',
	'wikieditor-toolbar-help-content-reference-result' => "טקסט הדף.<sup><a href='#'>[1]</a></sup>",
	'wikieditor-toolbar-help-content-rereference-description' => 'שימוש נוסף באותה הערת שוליים',
	'wikieditor-toolbar-help-content-rereference-result' => "טקסט הדף.<sup><a href='#'>[1]</a></sup>",
	'wikieditor-toolbar-help-content-showreferences-description' => 'הצגת הערות שוליים',
	'wikieditor-toolbar-help-content-showreferences-result' => "<ol class='references'><li id='cite_note-test-0'><b><a title='' href='#'>^</a></b> <a rel='nofollow' title='http://www.example.org' class='external text' href='#'>טקסט הקישור</a>, טקסט נוסף.</li></ol>",
	'wikieditor-toolbar-help-content-signaturetimestamp-description' => 'חתימה עם תאריך ושעה',
	'wikieditor-toolbar-help-content-signaturetimestamp-result' => "<a href='#' title='{{#special:mypage}}'>שם המשתמש</a> (<a href='#' title='{{#special:mytalk}}'>שיחה</a>) 15:54, 10 ביוני 2009 (IDT)",
	'wikieditor-toolbar-help-content-signature-description' => 'חתימה',
	'wikieditor-toolbar-help-content-signature-result' => "<a href='#' title='{{#special:mypage}}'>שם המשתמש</a> (<a href='#' title='{{#special:mytalk}}'>שיחה</a>)",
	'wikieditor-toolbar-help-content-indent-description' => 'הזחה',
	'wikieditor-toolbar-help-content-indent-syntax' => 'טקסט רגיל<br />:טקסט מוזח<br />::טקסט מוזח',
	'wikieditor-toolbar-help-content-indent-result' => 'טקסט רגיל<dl><dd>טקסט מוזח<dl><dd>טקסט מוזח</dd></dl></dd></dl>',
);

/** Hindi (हिन्दी)
 * @author Ansumang
 * @author Karthi.dr
 * @author Pooja.srivastava
 * @author Siddhartha Ghai
 */
$messages['hi'] = array(
	'wikieditor' => 'उन्नत विकितेक्ष्त् संपादन इन्तेर्फचे',
	'wikieditor-desc' => 'प्रदान करता है एक विकितेक्ष्त् एदितिङ् इन्तेर्फचे और् बहुत् सुविधा प्रदान कर्ता है मॉड्यूल',
	'wikieditor-wikitext-tab' => 'व्विकितेक्ष्त्',
	'wikieditor-loading' => 'लदान',
	'wikieditor-preview-preference' => 'सक्षम पक्ष ध्वारा पक्ष पूर्वावलोकन',
	'wikieditor-preview-tab' => 'पूर्वावलोकन',
	'wikieditor-preview-changes-tab' => 'बद्लाप्न्',
	'wikieditor-preview-loading' => 'लदान्',
	'wikieditor-previewDialog-preference' => 'सक्श्म्',
	'wikieditor-previewDialog-tab' => 'पूर्वावलोकन',
	'wikieditor-previewDialog-loading' => 'लदान्',
	'wikieditor-publish-preference' => 'सक्श्म्',
	'wikieditor-publish-button-publish' => 'प्प्रकाशित करना',
	'wikieditor-publish-button-cancel' => 'रद्द करें',
	'wikieditor-publish-dialog-title' => '{{SITENAME}} को छापा जाय',
	'wikieditor-publish-dialog-minor' => 'छोटा संपादन',
	'wikieditor-publish-dialog-watch' => 'इस पृष्ठ पे ध्यान रखेँ',
	'wikieditor-publish-dialog-publish' => 'प्रकाशित करें',
	'wikieditor-publish-dialog-goback' => 'पीछे जाइए',
	'wikieditor-template-editor-dialog-title' => 'साँचा संपादित करें',
	'wikieditor-template-editor-dialog-submit' => 'अपड़ेट',
	'wikieditor-template-editor-dialog-cancel' => 'रद्द करें',
	'wikieditor-toc-show' => 'सामग्री दिखाएँ',
	'wikieditor-toc-hide' => 'सामग्री छुपाएँ',
	'wikieditor-toolbar' => 'संपादन उपकरण पट्टी',
	'wikieditor-toolbar-loading' => 'लोड हो रहा है...',
	'wikieditor-toolbar-tool-bold' => 'बोल्ड',
	'wikieditor-toolbar-tool-bold-example' => 'मोटे अक्षर',
	'wikieditor-toolbar-tool-italic' => 'इटैलिक',
	'wikieditor-toolbar-tool-italic-example' => 'तिरछे अक्षर',
	'wikieditor-toolbar-tool-ilink' => 'आंतरिक कड़ी',
	'wikieditor-toolbar-tool-ilink-example' => 'कड़ी शीर्षक',
	'wikieditor-toolbar-tool-xlink' => 'बाहरी कड़ी (http:// उपसर्ग याद रखें)',
	'wikieditor-toolbar-tool-xlink-example' => 'http://www.example.com कड़ी शीर्षक',
	'wikieditor-toolbar-tool-link' => 'लिंक',
	'wikieditor-toolbar-tool-link-title' => 'लिंक सम्मिलित करें',
	'wikieditor-toolbar-tool-link-int' => 'एक विकि पृष्ठ तक',
	'wikieditor-toolbar-tool-link-int-target' => 'लक्ष्य पृष्ठ या URL:',
	'wikieditor-toolbar-tool-link-int-target-tooltip' => 'पृष्ठ शीर्षक या URL',
	'wikieditor-toolbar-tool-link-int-text' => 'पाठ को प्रदर्शित करने के लिए:',
	'wikieditor-toolbar-tool-link-int-text-tooltip' => 'पाठ प्रदर्शित करना',
	'wikieditor-toolbar-tool-link-ext' => 'एक बाह्य वेब पेज तक',
	'wikieditor-toolbar-tool-link-ext-target' => 'लिंक URL:',
	'wikieditor-toolbar-tool-link-ext-text' => 'कड़ी पाठ:',
	'wikieditor-toolbar-tool-link-insert' => 'लिंक सम्मिलित करें',
	'wikieditor-toolbar-tool-link-cancel' => 'रद्द करें',
	'wikieditor-toolbar-tool-link-int-target-status-exists' => 'पृष्ठ मौजूद है',
	'wikieditor-toolbar-tool-link-int-target-status-notexists' => 'पृष्ठ मौजूद नहीं है',
	'wikieditor-toolbar-tool-link-int-target-status-invalid' => 'अवैध शीर्षक',
	'wikieditor-toolbar-tool-link-int-target-status-external' => 'बाहरी कड़ियाँ',
	'wikieditor-toolbar-tool-link-int-target-status-loading' => 'पृष्ठ अस्तित्व की जाँच...',
	'wikieditor-toolbar-tool-link-int-invalid' => 'आपके द्वारा निर्दिष्ट शीर्षक अमान्य है।',
	'wikieditor-toolbar-tool-link-lookslikeinternal-int' => 'आंतरिक लिंक',
	'wikieditor-toolbar-tool-link-lookslikeinternal-ext' => 'बाहरी कड़ियाँ',
	'wikieditor-toolbar-tool-link-empty' => 'आप लिंक करने के लिए कुछ दर्ज़ नहीं किए थे ।',
	'wikieditor-toolbar-tool-file' => 'संलग्न फ़ाइल',
	'wikieditor-toolbar-tool-file-example' => 'उदाहरण.jpg',
	'wikieditor-toolbar-tool-file-cancel' => 'रद्द करें',
	'wikieditor-toolbar-tool-reference' => 'संदर्भ',
	'wikieditor-toolbar-tool-reference-example' => 'आधार पाठ यहाँ सम्मिलित करें',
	'wikieditor-toolbar-tool-reference-cancel' => 'रद्द करें',
	'wikieditor-toolbar-tool-reference-title' => 'संदर्भ सम्मिलित करें',
	'wikieditor-toolbar-tool-reference-insert' => 'सम्मिलित करें',
	'wikieditor-toolbar-tool-reference-text' => 'संदर्भ पाठ',
	'wikieditor-toolbar-tool-signature' => 'हस्ताक्षर और टाइमस्टैम्प',
	'wikieditor-toolbar-section-advanced' => 'उन्नत',
	'wikieditor-toolbar-tool-heading' => 'शीर्षक',
	'wikieditor-toolbar-tool-heading-1' => 'स्तर १',
	'wikieditor-toolbar-tool-heading-2' => 'स्तर २',
	'wikieditor-toolbar-tool-heading-3' => 'स्तर ३',
	'wikieditor-toolbar-tool-heading-4' => 'स्तर ४',
	'wikieditor-toolbar-tool-heading-5' => 'स्तर ५',
	'wikieditor-toolbar-tool-heading-example' => 'शीर्ष पाठ',
	'wikieditor-toolbar-group-format' => 'स्वरूप',
	'wikieditor-toolbar-tool-ulist' => 'बुलेटेड सूची',
	'wikieditor-toolbar-tool-ulist-example' => 'बुलेटेड सूची आइटम',
	'wikieditor-toolbar-tool-olist' => 'क्रमांकित सूची',
	'wikieditor-toolbar-tool-olist-example' => 'क्रमांकित सूची आइटम',
	'wikieditor-toolbar-tool-indent' => 'अभिस्थापन',
	'wikieditor-toolbar-tool-indent-example' => 'अभिस्थापित रेखा',
	'wikieditor-toolbar-tool-nowiki' => 'कोई विकि स्वरूपण नहीं',
	'wikieditor-toolbar-tool-nowiki-example' => 'गैर-स्वरूपित पाठ यहाँ सम्मिलित करें',
	'wikieditor-toolbar-tool-redirect' => 'पुनर्निर्देशन',
	'wikieditor-toolbar-tool-redirect-example' => 'लक्ष्य पृष्ठ नाम',
	'wikieditor-toolbar-tool-big' => 'बड़ा',
	'wikieditor-toolbar-tool-big-example' => 'बड़ा पाठ',
	'wikieditor-toolbar-tool-small' => 'छोटा',
	'wikieditor-toolbar-tool-small-example' => 'छोटे पाठ',
	'wikieditor-toolbar-tool-superscript' => 'सुपरस्क्रिप्ट',
	'wikieditor-toolbar-tool-superscript-example' => 'सुपरस्क्रिप्ट पाठ',
	'wikieditor-toolbar-tool-subscript' => 'सबस्क्रिप्ट',
	'wikieditor-toolbar-tool-subscript-example' => 'सबस्क्रिप्ट पाठ',
	'wikieditor-toolbar-group-insert' => 'सम्मिलित करें',
	'wikieditor-toolbar-tool-gallery' => 'तस्वीर गैलरी',
	'wikieditor-toolbar-tool-gallery-example' => '$1:उदाहरण.jpg|चित्रशीर्षक१
$1:उदाहरण.jpg|चित्रशीर्षक२',
	'wikieditor-toolbar-tool-newline' => 'नई पंक्ति',
	'wikieditor-toolbar-tool-table' => 'सारणी',
	'wikieditor-toolbar-tool-table-example-old' => '-
! शीर्ष लेख १
! शीर्ष लेख २
! शीर्ष लेख ३
|-
| पंक्ति १, प्रकोष्ठ १
| पंक्ति १, प्रकोष्ठ २
| पंक्ति १, प्रकोष्ठ ३
|-
| पंक्ति २, प्रकोष्ठ १
| पंक्ति २, प्रकोष्ठ २
| पंक्ति २, प्रकोष्ठ ३',
	'wikieditor-toolbar-tool-table-example-cell-text' => 'प्रकोष्ठ पाठ',
	'wikieditor-toolbar-tool-table-example-header' => 'शीर्ष पाठ',
	'wikieditor-toolbar-tool-table-title' => 'सारणी सम्मिलित करें',
	'wikieditor-toolbar-tool-table-dimensions-rows' => 'पंक्तियाँ',
	'wikieditor-toolbar-tool-table-dimensions-columns' => 'कॉलम',
	'wikieditor-toolbar-tool-table-dimensions-header' => 'शीर्ष लेख पंक्ति जोड़ें',
	'wikieditor-toolbar-tool-table-wikitable' => 'बॉर्डर के साथ शैली',
	'wikieditor-toolbar-tool-table-sortable' => 'सारणी सॉर्टबल बनाएँ',
	'wikieditor-toolbar-tool-table-example' => 'उदाहरण',
	'wikieditor-toolbar-tool-table-preview' => 'पूर्वावलोकन',
	'wikieditor-toolbar-tool-table-insert' => 'सम्मिलित करें',
	'wikieditor-toolbar-tool-table-cancel' => 'रद्द करें',
	'wikieditor-toolbar-tool-replace' => 'खोजें और बदलें',
	'wikieditor-toolbar-tool-replace-title' => 'खोजें और बदलें',
	'wikieditor-toolbar-tool-replace-search' => 'खोजें:',
	'wikieditor-toolbar-tool-replace-replace' => 'इसके साथ बदलें:',
	'wikieditor-toolbar-tool-replace-case' => 'केस मिलाएँ',
	'wikieditor-toolbar-tool-replace-button-findnext' => 'अगला ढूँढें',
	'wikieditor-toolbar-tool-replace-button-replace' => 'इससे बदलें',
	'wikieditor-toolbar-tool-replace-button-replaceall' => 'सभी बदलें',
	'wikieditor-toolbar-tool-replace-close' => 'बंद करें',
	'wikieditor-toolbar-tool-replace-nomatch' => 'आपके खोज कुछ मिला नहीं',
	'wikieditor-toolbar-tool-replace-success' => '$1 प्रतिस्थापन बनें ।',
	'wikieditor-toolbar-section-characters' => 'विशेष वर्ण',
	'wikieditor-toolbar-characters-page-latin' => 'लाटिन',
	'wikieditor-toolbar-characters-page-latinextended' => 'लाटिन विस्तारित',
	'wikieditor-toolbar-characters-page-ipa' => 'आइपीए',
	'wikieditor-toolbar-characters-page-symbols' => 'प्रतीक',
	'wikieditor-toolbar-characters-page-greek' => 'ग्रीक',
	'wikieditor-toolbar-characters-page-cyrillic' => 'सिरिलिक',
	'wikieditor-toolbar-characters-page-arabic' => 'अरबी',
	'wikieditor-toolbar-characters-page-arabicextended' => 'अरबी विस्तारित',
	'wikieditor-toolbar-characters-page-persian' => 'फार्सी',
	'wikieditor-toolbar-characters-page-hebrew' => 'हिब्रू',
	'wikieditor-toolbar-characters-page-bangla' => 'बांग्ला',
	'wikieditor-toolbar-characters-page-tamil' => 'तमिल',
	'wikieditor-toolbar-characters-page-telugu' => 'तेलूगू',
	'wikieditor-toolbar-characters-page-sinhala' => 'सिंहल',
	'wikieditor-toolbar-characters-page-gujarati' => 'गुजराती',
	'wikieditor-toolbar-characters-page-devanagari' => 'देवनागरी',
	'wikieditor-toolbar-characters-page-thai' => 'थाई',
	'wikieditor-toolbar-characters-page-lao' => 'लाओ',
	'wikieditor-toolbar-characters-page-khmer' => 'खमेर',
	'wikieditor-toolbar-section-help' => 'सहायता',
	'wikieditor-toolbar-help-heading-description' => 'वर्णन',
	'wikieditor-toolbar-help-heading-syntax' => 'तुम क्या लिखोगे',
	'wikieditor-toolbar-help-heading-result' => 'तुम्हें क्या मिला',
	'wikieditor-toolbar-help-page-format' => 'स्वरूपण',
	'wikieditor-toolbar-help-page-link' => 'कड़ियाँ',
	'wikieditor-toolbar-help-page-heading' => 'शीर्षक',
	'wikieditor-toolbar-help-page-list' => 'सूचियाँ',
	'wikieditor-toolbar-help-page-file' => 'फ़ाइलें',
	'wikieditor-toolbar-help-page-reference' => 'संदर्भ',
	'wikieditor-toolbar-help-page-discussion' => 'वार्ता',
	'wikieditor-toolbar-help-content-italic-description' => 'इटैलिक',
	'wikieditor-toolbar-help-content-italic-syntax' => "''इटैलिक पाठ ''",
	'wikieditor-toolbar-help-content-italic-result' => '<em>इटैलिक पाठ</em>',
	'wikieditor-toolbar-help-content-bold-description' => 'बोल्ड',
	'wikieditor-toolbar-help-content-bold-syntax' => "''' बोल्ड पाठ '''",
	'wikieditor-toolbar-help-content-bold-result' => '<strong>बोल्ड पाठ</strong>',
	'wikieditor-toolbar-help-content-bolditalic-description' => 'बोल्ड &amp; इटैलिक',
	'wikieditor-toolbar-help-content-bolditalic-syntax' => "'''''बोल्ड &amp; इटैलिक पाठ'''''",
	'wikieditor-toolbar-help-content-bolditalic-result' => '<strong><em>बोल्ड &amp; इटैलिक पाठ</em></strong>',
	'wikieditor-toolbar-help-content-ilink-description' => 'आंतरिक कड़ी',
	'wikieditor-toolbar-help-content-ilink-syntax' => '[[पृष्ठ शीर्षक|दृश्य शब्दलेखन]]<br />[[पृष्ठ शीर्षक]]',
	'wikieditor-toolbar-help-content-ilink-result' => "<a href='#'>लिंक लेबल</a><br /><a href='#'>पृष्ठ शीर्षक</a>",
	'wikieditor-toolbar-help-content-xlink-description' => 'बाहरी कड़ि',
	'wikieditor-toolbar-help-content-xlink-syntax' => '[http://www.example.org  लिंक लेबल]<br />[http://www.example.org]<br />http://www.example.org',
	'wikieditor-toolbar-help-content-xlink-result' => "<a href='#' class='external'>लिंक लेबल</a><br /><a href='#' class='external autonumber'>[1]</a><br /><a href='#' class='external'>http://www.example.org</a>",
	'wikieditor-toolbar-help-content-heading2-description' => 'द्वितीय स्तर शीर्षक',
	'wikieditor-toolbar-help-content-heading2-syntax' => '== शीर्षक लेख ==',
	'wikieditor-toolbar-help-content-heading2-result' => '<h2>शीर्षक लेख</h2>',
	'wikieditor-toolbar-help-content-heading3-description' => 'तृतीय स्तर शीर्षक',
	'wikieditor-toolbar-help-content-heading3-syntax' => '=== शीर्षक लेख ===',
	'wikieditor-toolbar-help-content-heading3-result' => '<h3>शीर्षक लेख</h3>',
	'wikieditor-toolbar-help-content-heading4-description' => 'चतुर्थ स्तर शीर्षक',
	'wikieditor-toolbar-help-content-heading4-syntax' => '==== शीर्षक लेख ====',
	'wikieditor-toolbar-help-content-heading4-result' => '<h4>शीर्षक लेख</h4>',
	'wikieditor-toolbar-help-content-heading5-description' => 'पंचम स्तर शीर्षक',
	'wikieditor-toolbar-help-content-heading5-syntax' => '===== शीर्षक लेख =====',
	'wikieditor-toolbar-help-content-heading5-result' => '<h5>शीर्षक लेख</h5>',
	'wikieditor-toolbar-help-content-ulist-description' => 'बुलेटेड सूची',
	'wikieditor-toolbar-help-content-ulist-syntax' => '* सूची आइटम<br />* सूची आइटम',
	'wikieditor-toolbar-help-content-ulist-result' => '<ul><li>सूची आइटम</li><li>सूची आइटम</li></ul>',
	'wikieditor-toolbar-help-content-olist-description' => 'क्रमांकित सूची',
	'wikieditor-toolbar-help-content-olist-syntax' => '# सूची आइटम<br /># सूची आइटम',
	'wikieditor-toolbar-help-content-olist-result' => '<ol><li>सूची आइटम</li><li>सूची आइटम</li></ol>',
	'wikieditor-toolbar-help-content-file-description' => 'संलग्न फ़ाइल',
	'wikieditor-toolbar-help-content-file-syntax' => '[[$1:उदाहरण.png|thumb|शीर्षक नाम]]',
	'wikieditor-toolbar-help-content-file-result' => "<div style='चौड़ाई:104px;' class='thumbinner'><a title='शीर्षक नाम' class='इमेज' href='#'><img height='50' width='100' border='0' class='thumbimage' src='$2/WikiEditor/modules/images/toolbar/example-image.png' alt=''/></a><div class='thumbcaption'><div class='magnify'><a title='बढ़ाना' class='आंतरिक' href='#'><img height='11' width='15' alt='' src='$1/common/images/magnify-clip.png'/></a></div>शीर्षक नाम</div></div>",
	'wikieditor-toolbar-help-content-reference-description' => 'संदर्भ',
	'wikieditor-toolbar-help-content-reference-syntax' => 'पृष्ठ लेख ।&lt;ref name="test"&gt;[http://www.example.org लिंक लेख], अतिरिक्त लेख.&lt;/ref&gt;',
	'wikieditor-toolbar-help-content-reference-result' => "पृष्ठ लेख ।<sup><a href='#'>[1]</a></sup>",
	'wikieditor-toolbar-help-content-rereference-description' => 'वही संदर्भ का अतिरिक्त उपयोग',
	'wikieditor-toolbar-help-content-rereference-result' => "पृष्ठ लेख ।<sup><a href='#'>[1]</a></sup>",
	'wikieditor-toolbar-help-content-showreferences-description' => 'संदर्भ दिखाएँ',
	'wikieditor-toolbar-help-content-showreferences-result' => "<ol class='संदर्भ'><li id='cite_note-test-0'><b><a title='' href='#'>^</a></b> <a rel='nofollow' title='http://www.example.org' class='बाहरी लेख' href='#'>लिंक लेख</a>, अतिरिक्त लेख ।</li></ol>",
	'wikieditor-toolbar-help-content-signaturetimestamp-description' => 'हस्ताक्षर टाइमस्टैम्प सहित',
	'wikieditor-toolbar-help-content-signaturetimestamp-result' => "<a href='#' title='{{#special:mypage}}'>सदस्यनाम</a> (<a href='#' title='{{#special:mytalk}}'>चर्चा</a>) 15:54, 10 June 2009 (UTC)",
	'wikieditor-toolbar-help-content-signature-description' => 'हस्ताक्षर',
	'wikieditor-toolbar-help-content-signature-result' => "<a href='#' title='{{#special:mypage}}'>सदस्यनाम</a> (<a href='#' title='{{#special:mytalk}}'>वार्ता</a>)",
	'wikieditor-toolbar-help-content-indent-description' => 'इनडेंट',
	'wikieditor-toolbar-help-content-indent-syntax' => 'सामान्य लेख<br />:इनडेंटेड लेख<br />::इनडेंटेड लेख',
	'wikieditor-toolbar-help-content-indent-result' => 'सामान्य लेख<dl><dd>इनडेंटेड लेख<dl><dd>इनडेंटेड लेख</dd></dl></dd></dl>',
);

/** Fiji Hindi (Latin script) (Fiji Hindi) */
$messages['hif-latn'] = array(
	'wikieditor-toolbar-tool-bold' => 'Mota',
	'wikieditor-toolbar-tool-bold-example' => 'Mota akchhar',
	'wikieditor-toolbar-tool-italic' => 'Tirchha',
);

/** Croatian (hrvatski)
 * @author Bugoslav
 * @author Ex13
 * @author Excaliboor
 * @author Roberta F.
 * @author SpeedyGonsales
 */
$messages['hr'] = array(
	'wikieditor' => 'Napredno sučelje uređivanja wikiteksta',
	'wikieditor-desc' => 'Pruža proširivo sučelje za uređivanje wikiteksta i više modula s raznim dodacima',
	'wikieditor-wikitext-tab' => 'Wikitekst',
	'wikieditor-loading' => 'Učitavanje',
	'wikieditor-preview-preference' => 'Omogući usporedni pregled',
	'wikieditor-preview-tab' => 'Pregled',
	'wikieditor-preview-changes-tab' => 'Promjene',
	'wikieditor-preview-loading' => 'Učitavam…',
	'wikieditor-previewDialog-preference' => 'Omogući dijalog za pregled',
	'wikieditor-previewDialog-tab' => 'Pregled kako će stranica izgledati',
	'wikieditor-previewDialog-loading' => 'Učitavam…',
	'wikieditor-publish-preference' => 'Omogućiti korak-po-korak izdavanje',
	'wikieditor-publish-button-publish' => 'Objaviti',
	'wikieditor-publish-button-cancel' => 'Odustani',
	'wikieditor-publish-dialog-title' => 'Objavi na {{SITENAME}}',
	'wikieditor-publish-dialog-summary' => 'Uredi sažetak (kratko opišite promjene koje ste učinili):',
	'wikieditor-publish-dialog-minor' => 'Manja promjena',
	'wikieditor-publish-dialog-watch' => 'Prati ovu stranicu',
	'wikieditor-publish-dialog-publish' => 'Objaviti',
	'wikieditor-publish-dialog-goback' => 'Idi natrag',
	'wikieditor-template-editor-preference' => 'Omogući uređivanje wiki predložaka po upitniku',
	'wikieditor-template-editor-dialog-title' => 'Uredi predložak',
	'wikieditor-template-editor-dialog-submit' => 'Osvježi',
	'wikieditor-template-editor-dialog-cancel' => 'Odustani',
	'wikieditor-templates-preference' => 'Omogući skrivanje predložaka',
	'wikieditor-toc-preference' => 'Omogući navigaciju sadržaja',
	'wikieditor-toc-show' => 'Prikaži sadržaj',
	'wikieditor-toc-hide' => 'Sakrij sadržaj',
	'wikieditor-toolbar' => 'Alatna vrpca',
	'wikieditor-toolbar-desc' => 'Alatna vrpca za uređivanje s poboljšanom uporabljivošću',
	'wikieditor-toolbar-preference' => 'Omogući poboljšanu alatnu traku',
	'wikieditor-toolbar-dialogs-preference' => 'Dopusti upitnike za unos veza, tablica i ostalog',
	'wikieditor-toolbar-hidesig' => 'Sakrij gumb potpisa sa stranica u glavnom imenskom prostoru',
	'wikieditor-toolbar-loading' => 'Učitavam...',
	'wikieditor-toolbar-tool-bold' => 'Podebljano',
	'wikieditor-toolbar-tool-bold-example' => 'Podebljani tekst',
	'wikieditor-toolbar-tool-italic' => 'Kurziv',
	'wikieditor-toolbar-tool-italic-example' => 'Kurzivni tekst',
	'wikieditor-toolbar-tool-ilink' => 'Unutarnja poveznica',
	'wikieditor-toolbar-tool-ilink-example' => 'Naziv poveznice',
	'wikieditor-toolbar-tool-xlink' => 'Vanjska poveznica (nužan je prefiks http://)',
	'wikieditor-toolbar-tool-xlink-example' => 'http://www.primjer.com naziv poveznice',
	'wikieditor-toolbar-tool-link' => 'Poveznica',
	'wikieditor-toolbar-tool-link-title' => 'Umetni poveznicu',
	'wikieditor-toolbar-tool-link-int' => 'U wiki stranicu',
	'wikieditor-toolbar-tool-link-int-target' => 'Naslov stranice:',
	'wikieditor-toolbar-tool-link-int-target-tooltip' => 'Naslov ili URL stranice',
	'wikieditor-toolbar-tool-link-int-text' => 'Tekst poveznice',
	'wikieditor-toolbar-tool-link-int-text-tooltip' => 'Tekst za prikaz',
	'wikieditor-toolbar-tool-link-ext' => 'Za vanjske web stranice',
	'wikieditor-toolbar-tool-link-ext-target' => 'URL poveznice:',
	'wikieditor-toolbar-tool-link-ext-text' => 'Tekst poveznice:',
	'wikieditor-toolbar-tool-link-insert' => 'Umetni poveznicu',
	'wikieditor-toolbar-tool-link-cancel' => 'Odustani',
	'wikieditor-toolbar-tool-link-int-target-status-exists' => 'Stranica postoji',
	'wikieditor-toolbar-tool-link-int-target-status-notexists' => 'Stranica ne postoji',
	'wikieditor-toolbar-tool-link-int-target-status-invalid' => 'Nevaljani naslov',
	'wikieditor-toolbar-tool-link-int-target-status-external' => 'Vanjska poveznica',
	'wikieditor-toolbar-tool-link-int-target-status-loading' => 'Provjera postoji li stranica...',
	'wikieditor-toolbar-tool-link-int-invalid' => 'Naslov koji ste naveli je nevažeći.',
	'wikieditor-toolbar-tool-link-lookslikeinternal' => 'URL koji ste predali čini se namijenjen kao poveznica na drugu wiki stranicu.
Želite li napraviti unutrašnju poveznicu?',
	'wikieditor-toolbar-tool-link-lookslikeinternal-int' => 'Unutarnja poveznica',
	'wikieditor-toolbar-tool-link-lookslikeinternal-ext' => 'Vanjska poveznica',
	'wikieditor-toolbar-tool-link-empty' => 'Niste unijeli ništa za povezivanje.',
	'wikieditor-toolbar-tool-file' => 'Uložena datoteka',
	'wikieditor-toolbar-tool-file-example' => 'Primjer.jpg',
	'wikieditor-toolbar-tool-reference' => 'Bilješke',
	'wikieditor-toolbar-tool-reference-example' => 'Umetni tekst fusnote ovdje',
	'wikieditor-toolbar-tool-reference-cancel' => 'Odustani',
	'wikieditor-toolbar-tool-reference-title' => 'Umetni poveznicu',
	'wikieditor-toolbar-tool-reference-insert' => 'Umetni',
	'wikieditor-toolbar-tool-reference-text' => 'Referentni tekst',
	'wikieditor-toolbar-tool-signature' => 'Potpis i datum',
	'wikieditor-toolbar-section-advanced' => 'Napredno',
	'wikieditor-toolbar-tool-heading' => 'Podnaslov',
	'wikieditor-toolbar-tool-heading-1' => 'Razina 1',
	'wikieditor-toolbar-tool-heading-2' => 'Razina 2',
	'wikieditor-toolbar-tool-heading-3' => 'Razina 3',
	'wikieditor-toolbar-tool-heading-4' => 'Razina 4',
	'wikieditor-toolbar-tool-heading-5' => 'Razina 5',
	'wikieditor-toolbar-tool-heading-example' => 'Tekst podnaslova',
	'wikieditor-toolbar-group-format' => 'Format',
	'wikieditor-toolbar-tool-ulist' => 'Popis s grafičkim oznakama',
	'wikieditor-toolbar-tool-ulist-example' => 'Stavka popisa s grafičkim oznakama',
	'wikieditor-toolbar-tool-olist' => 'Numerirani popis',
	'wikieditor-toolbar-tool-olist-example' => 'Stavka numeriranog popisa',
	'wikieditor-toolbar-tool-indent' => 'Uvlačenje',
	'wikieditor-toolbar-tool-indent-example' => 'Uvučeni red',
	'wikieditor-toolbar-tool-nowiki' => 'Nema wiki oblikovanja',
	'wikieditor-toolbar-tool-nowiki-example' => 'Ovdje unesite neoblikovani tekst',
	'wikieditor-toolbar-tool-redirect' => 'Preusmjeravanje',
	'wikieditor-toolbar-tool-redirect-example' => 'Ime ciljne stranice',
	'wikieditor-toolbar-tool-big' => 'Velika slova',
	'wikieditor-toolbar-tool-big-example' => 'Tekst velikim slovima',
	'wikieditor-toolbar-tool-small' => 'Malim slovima',
	'wikieditor-toolbar-tool-small-example' => 'Tekst malim slovima',
	'wikieditor-toolbar-tool-superscript' => 'Eksponent',
	'wikieditor-toolbar-tool-superscript-example' => 'Tekst eksponenta',
	'wikieditor-toolbar-tool-subscript' => 'Indeks',
	'wikieditor-toolbar-tool-subscript-example' => 'Tekst indeksa',
	'wikieditor-toolbar-group-insert' => 'Uloži',
	'wikieditor-toolbar-tool-gallery' => 'Galerija slika',
	'wikieditor-toolbar-tool-gallery-example' => '$1:Primjer.jpg|Opis1
$1:Primjer.jpg|Opis2',
	'wikieditor-toolbar-tool-newline' => 'Novi redak',
	'wikieditor-toolbar-tool-table' => 'Tablica',
	'wikieditor-toolbar-tool-table-example-old' => '-
! naslov 1
! naslov 2
! naslov 3
|-
| red 1, ćelija 1
| red 1, ćelija 2
| red 1, ćelija 3
|-
| red 2, ćelija 1
| red 2, ćelija 2
| red 2, ćelija 3',
	'wikieditor-toolbar-tool-table-example-cell-text' => 'Redak $1, ćelija $2',
	'wikieditor-toolbar-tool-table-example-header' => 'Tekst zaglavlja',
	'wikieditor-toolbar-tool-table-title' => 'Umetni tablicu',
	'wikieditor-toolbar-tool-table-dimensions-rows' => 'Retci',
	'wikieditor-toolbar-tool-table-dimensions-columns' => 'Stupci',
	'wikieditor-toolbar-tool-table-dimensions-header' => 'Dodavanje zaglavlja redaka',
	'wikieditor-toolbar-tool-table-wikitable' => 'Stil s granicama',
	'wikieditor-toolbar-tool-table-sortable' => 'Učini tablicu sortabilnom',
	'wikieditor-toolbar-tool-table-example' => 'Primjer',
	'wikieditor-toolbar-tool-table-preview' => 'Pregled',
	'wikieditor-toolbar-tool-table-insert' => 'Umetni',
	'wikieditor-toolbar-tool-table-cancel' => 'Odustani',
	'wikieditor-toolbar-tool-table-toomany' => 'Umetanje tablice s više od $1 polja nije moguće s ovim dijalogu.',
	'wikieditor-toolbar-tool-table-invalidnumber' => 'Niste unijeli valjani broj redaka ili stupaca.',
	'wikieditor-toolbar-tool-table-zero' => 'Ne možete umetnuti tablicu sa nula redaka ili stupaca.',
	'wikieditor-toolbar-tool-replace' => 'Zamijeni',
	'wikieditor-toolbar-tool-replace-title' => 'Traži i zamijeni',
	'wikieditor-toolbar-tool-replace-search' => 'Traži:',
	'wikieditor-toolbar-tool-replace-replace' => 'Zamijeni s:',
	'wikieditor-toolbar-tool-replace-case' => 'Pazi na velika slova',
	'wikieditor-toolbar-tool-replace-regex' => 'Postupaj s traženim nizom kao regularnim izrazom',
	'wikieditor-toolbar-tool-replace-button-findnext' => 'Nađi sljedeću',
	'wikieditor-toolbar-tool-replace-button-replaceall' => 'Zamijeni sve',
	'wikieditor-toolbar-tool-replace-close' => 'Zatvori',
	'wikieditor-toolbar-tool-replace-nomatch' => 'Pretraživanje nije pronašlo ništa.',
	'wikieditor-toolbar-tool-replace-success' => '$1 zamjena načinjeno.',
	'wikieditor-toolbar-tool-replace-emptysearch' => 'Niste unijeli ništa za pretragu.',
	'wikieditor-toolbar-tool-replace-invalidregex' => 'Izraz koji ste unijeli nije ispravan: $1',
	'wikieditor-toolbar-section-characters' => 'Posebni znakovi',
	'wikieditor-toolbar-characters-page-latin' => 'latinica',
	'wikieditor-toolbar-characters-page-latinextended' => 'proširena latinica',
	'wikieditor-toolbar-characters-page-ipa' => 'IPA',
	'wikieditor-toolbar-characters-page-symbols' => 'simboli',
	'wikieditor-toolbar-characters-page-greek' => 'grčki',
	'wikieditor-toolbar-characters-page-cyrillic' => 'ćirilica',
	'wikieditor-toolbar-characters-page-arabic' => 'arapski',
	'wikieditor-toolbar-characters-page-persian' => 'Perzijski',
	'wikieditor-toolbar-characters-page-hebrew' => 'hebrejski',
	'wikieditor-toolbar-characters-page-bangla' => 'Bangla znakovi',
	'wikieditor-toolbar-characters-page-telugu' => 'telugu',
	'wikieditor-toolbar-characters-page-sinhala' => 'Sinhaleški znakovi',
	'wikieditor-toolbar-characters-page-gujarati' => 'Gudžaratski znakovi',
	'wikieditor-toolbar-characters-page-thai' => 'Tajlandski (tajski) znakovi',
	'wikieditor-toolbar-characters-page-lao' => 'Laoski znakovi',
	'wikieditor-toolbar-characters-page-khmer' => 'kmerski',
	'wikieditor-toolbar-section-help' => 'Pomoć',
	'wikieditor-toolbar-help-heading-description' => 'Opis',
	'wikieditor-toolbar-help-heading-syntax' => 'Što upisujete',
	'wikieditor-toolbar-help-heading-result' => 'Što dobivate',
	'wikieditor-toolbar-help-page-format' => 'Formatiranje',
	'wikieditor-toolbar-help-page-link' => 'Poveznice',
	'wikieditor-toolbar-help-page-heading' => 'Podnaslovi',
	'wikieditor-toolbar-help-page-list' => 'Popisi',
	'wikieditor-toolbar-help-page-file' => 'Datoteke',
	'wikieditor-toolbar-help-page-reference' => 'Bilješke',
	'wikieditor-toolbar-help-page-discussion' => 'Razgovor',
	'wikieditor-toolbar-help-content-italic-description' => 'Kurziv',
	'wikieditor-toolbar-help-content-italic-syntax' => "''Kurzivni tekst''",
	'wikieditor-toolbar-help-content-italic-result' => '<em>Kurzivni tekst</em>',
	'wikieditor-toolbar-help-content-bold-description' => 'Podebljano',
	'wikieditor-toolbar-help-content-bold-syntax' => "'''Podebljani tekst'''",
	'wikieditor-toolbar-help-content-bold-result' => '<strong>Podebljani tekst</strong>',
	'wikieditor-toolbar-help-content-bolditalic-description' => 'Podebljano i kurziv',
	'wikieditor-toolbar-help-content-bolditalic-syntax' => "'''''Podebljani i kurzivni tekst'''''",
	'wikieditor-toolbar-help-content-bolditalic-result' => '<strong><em>Podebljani i kurzivni tekst</em></strong>',
	'wikieditor-toolbar-help-content-ilink-description' => 'Unutarnja poveznica',
	'wikieditor-toolbar-help-content-ilink-syntax' => '[[Naslov stranice|Oznaka poveznice]]<br />[[Naslov stranice]]',
	'wikieditor-toolbar-help-content-ilink-result' => "<a href='#'>Oznaka poveznice</a><br /><a href='#'>Naslov stranice</a>",
	'wikieditor-toolbar-help-content-xlink-description' => 'Vanjska poveznica',
	'wikieditor-toolbar-help-content-xlink-syntax' => '[http://www.primjer.org Oznaka poveznice]<br />[http://www.primjer.org]<br />http://www.primjer.org',
	'wikieditor-toolbar-help-content-xlink-result' => "<a href='#' class='external'>Oznaka poveznice</a><br /><a href='#' class='external autonumber'>[1]</a><br /><a href='#' class='external'>http://www.primjer.org</a>",
	'wikieditor-toolbar-help-content-heading2-description' => 'Podnaslov 2. razine',
	'wikieditor-toolbar-help-content-heading2-syntax' => '== Tekst podnaslova ==',
	'wikieditor-toolbar-help-content-heading2-result' => '<h2> Tekst podnaslova </h2>',
	'wikieditor-toolbar-help-content-heading3-description' => 'Podnaslov 3. razine',
	'wikieditor-toolbar-help-content-heading3-syntax' => '=== Tekst podnaslova ===',
	'wikieditor-toolbar-help-content-heading3-result' => '<h3> Tekst podnaslova </h3>',
	'wikieditor-toolbar-help-content-heading4-description' => 'Podnaslov 4. razine',
	'wikieditor-toolbar-help-content-heading4-syntax' => '==== Tekst podnaslova ====',
	'wikieditor-toolbar-help-content-heading4-result' => '<h4> Tekst podnaslova </h4>',
	'wikieditor-toolbar-help-content-heading5-description' => 'Podnaslov 5. razine',
	'wikieditor-toolbar-help-content-heading5-syntax' => '===== Tekst podnaslova =====',
	'wikieditor-toolbar-help-content-heading5-result' => '<h5> Tekst podnaslova </h5>',
	'wikieditor-toolbar-help-content-ulist-description' => 'Popis s grafičkim oznakama',
	'wikieditor-toolbar-help-content-ulist-syntax' => '* stavka popisa<br />* stavka popisa',
	'wikieditor-toolbar-help-content-ulist-result' => '<ul><li>stavka popisa</li><li>stavka popisa</li></ul>',
	'wikieditor-toolbar-help-content-olist-description' => 'Numerirani popis',
	'wikieditor-toolbar-help-content-olist-syntax' => '# stavka popisa<br /># stavka popisa',
	'wikieditor-toolbar-help-content-olist-result' => '<ol><li>stavka popisa</li><li>stavka popisa</li></ol>',
	'wikieditor-toolbar-help-content-file-description' => 'Uložena datoteka',
	'wikieditor-toolbar-help-content-file-syntax' => '[[$1:Example.png|thumb|Tekst opisa]]',
	'wikieditor-toolbar-help-content-file-result' => "<div style='width:104px;' class='thumbinner'><a title='Tekst opisa' class='image' href='#'><img height='50' width='100' border='0' class='thumbimage' src='$2/WikiEditor/modules/images/toolbar/example-image.png' alt=''/></a><div class='thumbcaption'><div class='magnify'><a title='Povećaj' class='internal' href='#'><img height='11' width='15' alt='' src='$1/common/images/magnify-clip.png'/></a></div>Tekst opisa'</div></div>",
	'wikieditor-toolbar-help-content-reference-description' => 'Bilješke',
	'wikieditor-toolbar-help-content-reference-syntax' => 'Tekst stranice.&lt;ref name="test"&gt;[http://www.primjer.org Tekst poveznice], dodatni tekst.&lt;/ref&gt;',
	'wikieditor-toolbar-help-content-reference-result' => "Tekst stranice.<sup><a href='#'>[1]</a></sup>",
	'wikieditor-toolbar-help-content-rereference-description' => 'Dodatno korištenje iste bilješke',
	'wikieditor-toolbar-help-content-rereference-result' => "Tekst stranice.<sup><a href='#'>[1]</a></sup>",
	'wikieditor-toolbar-help-content-showreferences-description' => 'Prikazivanje bilješki',
	'wikieditor-toolbar-help-content-showreferences-result' => "<ol class='references'><li id='cite_note-test-0'><b><a title='' href='#'>^</a></b> <a rel='nofollow' title='http://www.primjer.org' class='vanjski tekst' href='#'>Teks poveznice</a>, dodatni tekst.</li></ol>",
	'wikieditor-toolbar-help-content-signaturetimestamp-description' => 'Potpis s datumom',
	'wikieditor-toolbar-help-content-signaturetimestamp-result' => "<a href='#' title='{{#special:mypage}}'>Suradničko ime</a> (<a href='#' title='{{#special:mytalk}}'>razgovor</a>) 15:54, 10. lipnja 2009. (UTC)",
	'wikieditor-toolbar-help-content-signature-description' => 'Potpis',
	'wikieditor-toolbar-help-content-signature-result' => "<a href='#' title='{{#special:mypage}}'>Suradničko ime</a> (<a href='#' title='{{#special:mytalk}}'>razgovor</a>)",
	'wikieditor-toolbar-help-content-indent-description' => 'Uvlaka',
	'wikieditor-toolbar-help-content-indent-syntax' => 'Normalni tekst<br />:Uvučeni tekst <br />::Uvučeni tekst',
	'wikieditor-toolbar-help-content-indent-result' => 'Normalni tekst<dl><dd>Uvučeni tekst<dl><dd>Uvučeni tekst</dd></dl></dd></dl>',
);

/** Upper Sorbian (hornjoserbsce)
 * @author Michawiki
 */
$messages['hsb'] = array(
	'wikieditor' => 'Rozšěrjeny powjerch za wobdźěłowanje wikiteksta',
	'wikieditor-desc' => 'Steji rozšěrjujomny powjerch za wobdźěłowanje wikiteksta a wjele modulow k dispoziciji.',
	'wikieditor-wikitext-tab' => 'WikiTekst',
	'wikieditor-loading' => 'Začituje so',
	'wikieditor-preview-preference' => 'Přehlad bok po boku zmóžnić',
	'wikieditor-preview-tab' => 'Přehlad',
	'wikieditor-preview-changes-tab' => 'Změny',
	'wikieditor-preview-loading' => 'Začituje so...',
	'wikieditor-previewDialog-preference' => 'Dialog za přehlad zmóžnić',
	'wikieditor-previewDialog-tab' => 'Přehlad',
	'wikieditor-previewDialog-loading' => 'Začituje so...',
	'wikieditor-publish-preference' => 'Publikowanje krok po kroku zmóžnić',
	'wikieditor-publish-button-publish' => 'Wozjewić',
	'wikieditor-publish-button-cancel' => 'Přetorhnyć',
	'wikieditor-publish-dialog-title' => 'Do {{GRAMMAR:genitiw|{{SITENAME}}}} wozjewić',
	'wikieditor-publish-dialog-summary' => 'Zjeće změnow (wopisaj krótko změny, kotrež sy činił):',
	'wikieditor-publish-dialog-minor' => 'Snadna změna',
	'wikieditor-publish-dialog-watch' => 'Tutu stronu wobkedźbować',
	'wikieditor-publish-dialog-publish' => 'Wozjewić',
	'wikieditor-publish-dialog-goback' => 'Wróćo',
	'wikieditor-template-editor-preference' => 'Wobdźěłowanje wikipředłohow na zakładźe formularow zmóžnić',
	'wikieditor-template-editor-dialog-title' => 'Předłohu wobdźěłać',
	'wikieditor-template-editor-dialog-submit' => 'Aktualizować',
	'wikieditor-template-editor-dialog-cancel' => 'Přetorhnyć',
	'wikieditor-templates-preference' => 'Fałdowanje předłohow zmóžnić',
	'wikieditor-toc-preference' => 'Nawigěrujomny zapis wobsaha zmóžnić',
	'wikieditor-toc-show' => 'Wobsah pokazać',
	'wikieditor-toc-hide' => 'Wobsah schować',
	'wikieditor-toolbar' => 'Gratowa lajsta za wobdźěłowanje',
	'wikieditor-toolbar-desc' => 'Gratowa lajsta za wobdźěłowanje stronow z polěpšenej wužiwajomnosću',
	'wikieditor-toolbar-preference' => 'Polěpšenu gratowu lajstu za wobdźěłowanje aktiwizować',
	'wikieditor-toolbar-dialogs-preference' => 'Dialogi za zasunjenje wotkazow, tabelow a hinašeho zmóžnić',
	'wikieditor-toolbar-hidesig' => 'Podpisowe tłóčatko w stronach we hłownym mjenowym rumje schować',
	'wikieditor-toolbar-loading' => 'Čita so...',
	'wikieditor-toolbar-tool-bold' => 'Tučny',
	'wikieditor-toolbar-tool-bold-example' => 'Tučny tekst',
	'wikieditor-toolbar-tool-italic' => 'Kursiwny',
	'wikieditor-toolbar-tool-italic-example' => 'Kursiwny tekst',
	'wikieditor-toolbar-tool-ilink' => 'Interny wotkaz',
	'wikieditor-toolbar-tool-ilink-example' => 'Titul wotkaza',
	'wikieditor-toolbar-tool-xlink' => 'Eksterny wotkaz (njezabudź na prefiks http://)',
	'wikieditor-toolbar-tool-xlink-example' => 'titul wotkaza http://www.přikład.de',
	'wikieditor-toolbar-tool-link' => 'Wotkaz',
	'wikieditor-toolbar-tool-link-title' => 'Wotkaz zasunyć',
	'wikieditor-toolbar-tool-link-int' => 'K wikinastawkej/stronje',
	'wikieditor-toolbar-tool-link-int-target' => 'Titul nastawka:',
	'wikieditor-toolbar-tool-link-int-target-tooltip' => 'Titul strony abo URL',
	'wikieditor-toolbar-tool-link-int-text' => 'Tekst wotkaza:',
	'wikieditor-toolbar-tool-link-int-text-tooltip' => 'Tekst, kotryž ma so pokazać, zapodać',
	'wikieditor-toolbar-tool-link-ext' => 'K eksternej webstronje',
	'wikieditor-toolbar-tool-link-ext-target' => 'URL wotkaza:',
	'wikieditor-toolbar-tool-link-ext-text' => 'Tekst wotkaza:',
	'wikieditor-toolbar-tool-link-insert' => 'Wotkaz zasunyć',
	'wikieditor-toolbar-tool-link-cancel' => 'Přetorhnyć',
	'wikieditor-toolbar-tool-link-int-target-status-exists' => 'Strona eksistuje',
	'wikieditor-toolbar-tool-link-int-target-status-notexists' => 'Strona njeeksistuje',
	'wikieditor-toolbar-tool-link-int-target-status-invalid' => 'Njepłaćiwy titul',
	'wikieditor-toolbar-tool-link-int-target-status-external' => 'Eksterny wotkaz',
	'wikieditor-toolbar-tool-link-int-target-status-loading' => 'Eksistenca strony so přepruwuje...',
	'wikieditor-toolbar-tool-link-int-invalid' => 'Titul, kotryž sy podał, je njepłaćiwy.',
	'wikieditor-toolbar-tool-link-lookslikeinternal' => 'URL, kotryž sy podał, wupada kaž by jako wotkaz k druhej wikistronje měrjeny był.
Chceš jón do interneho wotkaza přetworić?',
	'wikieditor-toolbar-tool-link-lookslikeinternal-int' => 'Interny wotkaz',
	'wikieditor-toolbar-tool-link-lookslikeinternal-ext' => 'Eksterny wotkaz',
	'wikieditor-toolbar-tool-link-empty' => 'Njejsy ničo zapodał, na kotrež ma so wotkazować.',
	'wikieditor-toolbar-tool-file' => 'Zasadźena dataja',
	'wikieditor-toolbar-tool-file-example' => 'Přikład.jpg',
	'wikieditor-toolbar-tool-file-title' => 'Dataju zasunyć',
	'wikieditor-toolbar-file-target' => 'Datajowe mjeno:',
	'wikieditor-toolbar-file-caption' => 'Popis:',
	'wikieditor-toolbar-file-size' => 'Wulkosć:',
	'wikieditor-toolbar-file-float' => 'Wusměrjenje:',
	'wikieditor-toolbar-file-default' => '(standard)',
	'wikieditor-toolbar-file-format' => 'Format:',
	'wikieditor-toolbar-file-format-none' => 'žadyn',
	'wikieditor-toolbar-tool-file-insert' => 'Zasunyć',
	'wikieditor-toolbar-tool-file-cancel' => 'Přetorhnyć',
	'wikieditor-toolbar-tool-reference' => 'Referenca',
	'wikieditor-toolbar-tool-reference-example' => 'Tekst nóžki tu zasunyć',
	'wikieditor-toolbar-tool-reference-cancel' => 'Přetorhnyć',
	'wikieditor-toolbar-tool-reference-title' => 'Referencu zasunyć',
	'wikieditor-toolbar-tool-reference-insert' => 'Zasunyć',
	'wikieditor-toolbar-tool-reference-text' => 'Tekst referency',
	'wikieditor-toolbar-tool-signature' => 'Signatura a časowy kołk',
	'wikieditor-toolbar-section-advanced' => 'Rozšěrjeny',
	'wikieditor-toolbar-tool-heading' => 'Nadpis',
	'wikieditor-toolbar-tool-heading-1' => 'Runina 1',
	'wikieditor-toolbar-tool-heading-2' => 'Runina 2',
	'wikieditor-toolbar-tool-heading-3' => 'Runina 3',
	'wikieditor-toolbar-tool-heading-4' => 'Runina 4',
	'wikieditor-toolbar-tool-heading-5' => 'Runina 5',
	'wikieditor-toolbar-tool-heading-example' => 'Tekst nadpisa',
	'wikieditor-toolbar-group-format' => 'Format',
	'wikieditor-toolbar-tool-ulist' => 'Naličenska lisćina',
	'wikieditor-toolbar-tool-ulist-example' => 'Zapisk naličenskeje lisćiny',
	'wikieditor-toolbar-tool-olist' => 'Čisłowana lisćina',
	'wikieditor-toolbar-tool-olist-example' => 'Zapisk čisłowaneje lisćiny',
	'wikieditor-toolbar-tool-indent' => 'Zasunjenje',
	'wikieditor-toolbar-tool-indent-example' => 'Zasunjena linka',
	'wikieditor-toolbar-tool-nowiki' => 'Žane wikiformatowanje',
	'wikieditor-toolbar-tool-nowiki-example' => 'Njeformatowany tekst tu zasunyć',
	'wikieditor-toolbar-tool-redirect' => 'Dalesposrědkowanje',
	'wikieditor-toolbar-tool-redirect-example' => 'Mjeno ciloweje strony',
	'wikieditor-toolbar-tool-big' => 'Wulki',
	'wikieditor-toolbar-tool-big-example' => 'Wulki tekst',
	'wikieditor-toolbar-tool-small' => 'Mały',
	'wikieditor-toolbar-tool-small-example' => 'Mały tekst',
	'wikieditor-toolbar-tool-superscript' => 'Wysoko stajeny',
	'wikieditor-toolbar-tool-superscript-example' => 'Wysoko stajeny tekst',
	'wikieditor-toolbar-tool-subscript' => 'Hłuboko stajeny',
	'wikieditor-toolbar-tool-subscript-example' => 'Hłuboko stajeny tekst',
	'wikieditor-toolbar-group-insert' => 'Zasunyć',
	'wikieditor-toolbar-tool-gallery' => 'Wobrazowa galerija',
	'wikieditor-toolbar-tool-gallery-example' => '$1:Example.jpg|Popis1
$1:Example.jpg|Popis2',
	'wikieditor-toolbar-tool-newline' => 'Nowa linka',
	'wikieditor-toolbar-tool-table' => 'Tabela',
	'wikieditor-toolbar-tool-table-example-old' => '-
! hłowa 1
! hłowa 2
! hłowa 3
|-
| rjadka 1, cela 1
| rjadka 1, cela 2
| rjadka 1, cela 3
|-
| rjadka 2, cela 1
| rjadka 2, cela 2
| rjadka 2, cela 3',
	'wikieditor-toolbar-tool-table-example-cell-text' => 'Celowy tekst',
	'wikieditor-toolbar-tool-table-example-header' => 'Hłowowy tekst',
	'wikieditor-toolbar-tool-table-title' => 'Tabelu zasunyć',
	'wikieditor-toolbar-tool-table-dimensions-rows' => 'Rjadki',
	'wikieditor-toolbar-tool-table-dimensions-columns' => 'Špalty',
	'wikieditor-toolbar-tool-table-dimensions-header' => 'Rjadku hłowy zapřijeć',
	'wikieditor-toolbar-tool-table-wikitable' => 'Stil z ramikami',
	'wikieditor-toolbar-tool-table-sortable' => 'Sortěrujomna tabela',
	'wikieditor-toolbar-tool-table-example' => 'Celowy tekst',
	'wikieditor-toolbar-tool-table-preview' => 'Přehlad',
	'wikieditor-toolbar-tool-table-insert' => 'Zasunyć',
	'wikieditor-toolbar-tool-table-cancel' => 'Přetorhnyć',
	'wikieditor-toolbar-tool-table-toomany' => 'Zasuwanje tabele z přez $1 {{PLURAL:$1|celu|celomaj|celemi|celemi}} z tutym dialogom móžno njeje.',
	'wikieditor-toolbar-tool-table-invalidnumber' => 'Njejsy płaćiwu ličbu rjadkow abo špaltow zapodał.',
	'wikieditor-toolbar-tool-table-zero' => 'Njemóžeš tabelu bjez rjadkow abo špaltow zasunyć.',
	'wikieditor-toolbar-tool-replace' => 'Pytać a narunać',
	'wikieditor-toolbar-tool-replace-title' => 'Pytać a narunać',
	'wikieditor-toolbar-tool-replace-search' => 'Pytać za:',
	'wikieditor-toolbar-tool-replace-replace' => 'Narunać přez:',
	'wikieditor-toolbar-tool-replace-case' => 'Wotpowědowanje',
	'wikieditor-toolbar-tool-replace-regex' => 'Z pytanskim tekstom kaž z regularnym wurazom wobchadźeć',
	'wikieditor-toolbar-tool-replace-button-findnext' => 'Dale pytać',
	'wikieditor-toolbar-tool-replace-button-replace' => 'Narunać',
	'wikieditor-toolbar-tool-replace-button-replaceall' => 'Wšě narunać',
	'wikieditor-toolbar-tool-replace-close' => 'Začinić',
	'wikieditor-toolbar-tool-replace-nomatch' => 'Twoje pytanje njeje wotpowědnik namakał.',
	'wikieditor-toolbar-tool-replace-success' => '$1 {{PLURAL:$1|narunanje přewjedźene|narunani přewjedźenej|narunanja přewjedźene|narunanjow přewjedźenych}}.',
	'wikieditor-toolbar-tool-replace-emptysearch' => 'Njejsy žadyn pytanski wuraz zapodał.',
	'wikieditor-toolbar-tool-replace-invalidregex' => 'Regularny wuraz, kotryž sy zapodał, je njepłaćiwy: $1',
	'wikieditor-toolbar-section-characters' => 'Specialne znamješka',
	'wikieditor-toolbar-characters-page-latin' => 'Łaćonske',
	'wikieditor-toolbar-characters-page-latinextended' => 'Łaćonske rozšěrjene',
	'wikieditor-toolbar-characters-page-ipa' => 'IPA',
	'wikieditor-toolbar-characters-page-symbols' => 'Symbole',
	'wikieditor-toolbar-characters-page-greek' => 'Grjekske',
	'wikieditor-toolbar-characters-page-cyrillic' => 'Kyriliske',
	'wikieditor-toolbar-characters-page-arabic' => 'Arabske',
	'wikieditor-toolbar-characters-page-arabicextended' => 'Rozšěrjena arabšćina',
	'wikieditor-toolbar-characters-page-persian' => 'Persiske',
	'wikieditor-toolbar-characters-page-hebrew' => 'Hebrejske',
	'wikieditor-toolbar-characters-page-bangla' => 'Bengalšćina',
	'wikieditor-toolbar-characters-page-tamil' => 'Tamilšćina',
	'wikieditor-toolbar-characters-page-telugu' => 'Telugu',
	'wikieditor-toolbar-characters-page-sinhala' => 'Singalezišćina',
	'wikieditor-toolbar-characters-page-gujarati' => 'Gudźarati',
	'wikieditor-toolbar-characters-page-devanagari' => 'Devanagari',
	'wikieditor-toolbar-characters-page-thai' => 'Thailandšćina',
	'wikieditor-toolbar-characters-page-lao' => 'Laošćina',
	'wikieditor-toolbar-characters-page-khmer' => 'Khmeršćina',
	'wikieditor-toolbar-section-help' => 'Pomoc',
	'wikieditor-toolbar-help-heading-description' => 'Wopisanje',
	'wikieditor-toolbar-help-heading-syntax' => 'Štož zapisuješ',
	'wikieditor-toolbar-help-heading-result' => 'Štož dóstanješ',
	'wikieditor-toolbar-help-page-format' => 'Formatowanje',
	'wikieditor-toolbar-help-page-link' => 'Wotkazy',
	'wikieditor-toolbar-help-page-heading' => 'Nadpisy',
	'wikieditor-toolbar-help-page-list' => 'Lisćiny',
	'wikieditor-toolbar-help-page-file' => 'Dataje',
	'wikieditor-toolbar-help-page-reference' => 'Referency',
	'wikieditor-toolbar-help-page-discussion' => 'Diskusija',
	'wikieditor-toolbar-help-content-italic-description' => 'Kursiwny',
	'wikieditor-toolbar-help-content-italic-syntax' => "''Kursiwny tekst''",
	'wikieditor-toolbar-help-content-italic-result' => '<em>Kursiwny tekst</em>',
	'wikieditor-toolbar-help-content-bold-description' => 'Tučny',
	'wikieditor-toolbar-help-content-bold-syntax' => "'''Tučny tekst'''",
	'wikieditor-toolbar-help-content-bold-result' => '<strong>Tučny tekst</strong>',
	'wikieditor-toolbar-help-content-bolditalic-description' => 'Tučny &amp; kursiwny',
	'wikieditor-toolbar-help-content-bolditalic-syntax' => "'''''Tučny &amp; kursiwny tekst'''''",
	'wikieditor-toolbar-help-content-bolditalic-result' => '<strong><em>Tučny &amp; kursiwny tekst</em></strong>',
	'wikieditor-toolbar-help-content-ilink-description' => 'Interny wotkaz',
	'wikieditor-toolbar-help-content-ilink-syntax' => '[[Page title|Popis wotkaza]]<br />[[Page title]]',
	'wikieditor-toolbar-help-content-ilink-result' => "<a href='#'>Popis wotkaza</a><br /><a href='#'>Titul wotkaza</a>",
	'wikieditor-toolbar-help-content-xlink-description' => 'Eksterny wotkaz',
	'wikieditor-toolbar-help-content-xlink-syntax' => '[http://www.example.org Popis wotkaza]<br />[http://www.example.org]<br />http://www.example.org',
	'wikieditor-toolbar-help-content-xlink-result' => "<a href='#' class='external'>Popis wotkaza</a><br /><a href='#' class='external autonumber'>[1]</a><br /><a href='#' class='external'>http://www.example.org</a>",
	'wikieditor-toolbar-help-content-heading2-description' => 'nadpis 2. runiny',
	'wikieditor-toolbar-help-content-heading2-syntax' => '== Nadpisowy tekst ==',
	'wikieditor-toolbar-help-content-heading2-result' => '<h2>Nadpisowy tekst</h2>',
	'wikieditor-toolbar-help-content-heading3-description' => 'Nadpis 3. runiny',
	'wikieditor-toolbar-help-content-heading3-syntax' => '=== Nadpisowy tekst ===',
	'wikieditor-toolbar-help-content-heading3-result' => '<h3>Nadpisowy tekst</h3>',
	'wikieditor-toolbar-help-content-heading4-description' => 'Nadpis 4. runiny',
	'wikieditor-toolbar-help-content-heading4-syntax' => '==== Nadpisowy tekst ====',
	'wikieditor-toolbar-help-content-heading4-result' => '<h4>Nadpisowy tekst</h4>',
	'wikieditor-toolbar-help-content-heading5-description' => 'Nadpis 5. runiny',
	'wikieditor-toolbar-help-content-heading5-syntax' => '===== Nadpisowy tekst =====',
	'wikieditor-toolbar-help-content-heading5-result' => '<h5>Nadpisowy tekst</h5>',
	'wikieditor-toolbar-help-content-ulist-description' => 'Naličenska lisćina',
	'wikieditor-toolbar-help-content-ulist-syntax' => '* Lisćinowy zapisk<br />* Lisćinowy zapisk',
	'wikieditor-toolbar-help-content-ulist-result' => '<ul><li>Lisćinowy zapisk</li><li>Lisćinowy zapisk</li></ul>',
	'wikieditor-toolbar-help-content-olist-description' => 'Čisłowana lisćina',
	'wikieditor-toolbar-help-content-olist-syntax' => '# Lisćinowy zapisk<br /># Lisćinowy zapisk',
	'wikieditor-toolbar-help-content-olist-result' => '<ol><li>Lisćinowy zapisk</li><li>Lisćinowy zapisk</li></ol>',
	'wikieditor-toolbar-help-content-file-description' => 'Zasadźena dataja',
	'wikieditor-toolbar-help-content-file-syntax' => '[[$1:Example.png|thumb|Tekst wobrazoweho popisa]]',
	'wikieditor-toolbar-help-content-file-result' => "<div style='width:104px;' class='thumbinner'><a title='Tekst wobrazeho popisa' class='image' href='#'><img height='50' width='100' border='0' class='thumbimage' src='$2/WikiEditor/modules/images/toolbar/example-image.png' alt=''/></a><div class='thumbcaption'><div class='magnify'><a title='Powjetšić' class='internal' href='#'><img height='11' width='15' alt='' src='$1/common/images/magnify-clip.png'/></a></div>Tekst wobrazoweho popisa</div></div>",
	'wikieditor-toolbar-help-content-reference-description' => 'Referenca',
	'wikieditor-toolbar-help-content-reference-syntax' => 'Tekst strony.&lt;ref name="test"&gt;[http://www.example.org tekst wotkaza], přidatny tekst.&lt;/ref&gt;',
	'wikieditor-toolbar-help-content-reference-result' => "Tekst strony.<sup><a href='#'>[1]</a></sup>",
	'wikieditor-toolbar-help-content-rereference-description' => 'Přidatne wužiwanje samsneje referency',
	'wikieditor-toolbar-help-content-rereference-result' => "Tekst strony.<sup><a href='#'>[1]</a></sup>",
	'wikieditor-toolbar-help-content-showreferences-description' => 'Referency zwobraznić',
	'wikieditor-toolbar-help-content-showreferences-result' => "<ol class='references'><li id='cite_note-test-0'><b><a title='' href='#'>^</a></b> <a rel='nofollow' title='http://www.example.org' class='external text' href='#'>Tekst wotkaza</a>, přidatny tekst.</li></ol>",
	'wikieditor-toolbar-help-content-signaturetimestamp-description' => 'Signatura z časowym kołkom',
	'wikieditor-toolbar-help-content-signaturetimestamp-result' => "<a href='#' title='{{#special:mypage}}'>Wužiwarske mjeno</a> (<a href='#' title='{{#special:mytalk}}'>diskusija</a>) 15:54, 10. junija 2009 (UTC)",
	'wikieditor-toolbar-help-content-signature-description' => 'Signatura',
	'wikieditor-toolbar-help-content-signature-result' => "<a href='#' title='{{#special:mypage}}'>Wužiwarske mjeno</a> (<a href='#' title='{{#special:mytalk}}'>diskusija</a>)",
	'wikieditor-toolbar-help-content-indent-description' => 'Zasunjenje',
	'wikieditor-toolbar-help-content-indent-syntax' => 'Normalny tekst<br />:Zasunjeny tekst<br />::Zasunjeny tekst',
	'wikieditor-toolbar-help-content-indent-result' => 'Normalny tekst<dl><dd>Zasunjeny tekst<dl><dd>Zasunjeny tekst</dd></dl></dd></dl>',
);

/** Hungarian (magyar)
 * @author Bdamokos
 * @author Dani
 * @author Dj
 * @author Glanthor Reviol
 * @author Hunyadym
 * @author McDutchie
 * @author Misibacsi
 */
$messages['hu'] = array(
	'wikieditor' => 'Fejlett szerkesztőfelület wikiszöveghez',
	'wikieditor-desc' => 'Bővíthető szerkesztőfelület wikiszöveghez és több, új funkciókat kínáló modul',
	'wikieditor-wikitext-tab' => 'Wikiszöveg',
	'wikieditor-loading' => 'Betöltés…',
	'wikieditor-preview-preference' => 'Előnézet egymás mellett engedélyezése',
	'wikieditor-preview-tab' => 'Előnézet',
	'wikieditor-preview-changes-tab' => 'Változtatások',
	'wikieditor-preview-loading' => 'Betöltés…',
	'wikieditor-previewDialog-preference' => 'Előnézet párbeszédablak bekapcsolása',
	'wikieditor-previewDialog-tab' => 'Előnézet',
	'wikieditor-previewDialog-loading' => 'Betöltés…',
	'wikieditor-publish-preference' => 'Lépésről-lépésre közzététel engedélyezése',
	'wikieditor-publish-button-publish' => 'Közzététel',
	'wikieditor-publish-button-cancel' => 'Mégse',
	'wikieditor-publish-dialog-title' => 'Közzététel a(z) {{SITENAME}} wikin',
	'wikieditor-publish-dialog-summary' => 'Szerkesztési összefoglaló (pontosan írd le az általad végzett változtatásokat):',
	'wikieditor-publish-dialog-minor' => 'Apró szerkesztés',
	'wikieditor-publish-dialog-watch' => 'Lap figyelése',
	'wikieditor-publish-dialog-publish' => 'Közzététel',
	'wikieditor-publish-dialog-goback' => 'Vissza',
	'wikieditor-template-editor-preference' => 'Wiki sablonok űrlap alapú szerkesztésének engedélyezése',
	'wikieditor-template-editor-dialog-title' => 'Sablon szerkesztése',
	'wikieditor-template-editor-dialog-submit' => 'Frissítés',
	'wikieditor-template-editor-dialog-cancel' => 'Mégse',
	'wikieditor-templates-preference' => 'Sablonok összecsukásának engedélyezése',
	'wikieditor-toc-preference' => 'Tartalomjegyzék megjelenítése szerkesztéskor',
	'wikieditor-toc-show' => 'Tartalomjegyzék megjelenítése',
	'wikieditor-toc-hide' => 'Tartalomjegyzék elrejtése',
	'wikieditor-toolbar' => 'Szerkesztő-eszköztár',
	'wikieditor-toolbar-desc' => 'Használhatóbb szerkesztő eszköztár',
	'wikieditor-toolbar-preference' => 'Fejlettebb szerkesztő-eszköztár használata',
	'wikieditor-toolbar-dialogs-preference' => 'Párbeszédablakok engedélyezése hivatkozások, táblázatok és egyebek beillesztéséhez',
	'wikieditor-toolbar-hidesig' => 'Aláírás gomb elrejtése a szócikknévtérben',
	'wikieditor-toolbar-loading' => 'Betöltés…',
	'wikieditor-toolbar-tool-bold' => 'Félkövér',
	'wikieditor-toolbar-tool-bold-example' => 'Félkövér szöveg',
	'wikieditor-toolbar-tool-italic' => 'Dőlt',
	'wikieditor-toolbar-tool-italic-example' => 'Dőlt szöveg',
	'wikieditor-toolbar-tool-ilink' => 'Belső hivatkozás',
	'wikieditor-toolbar-tool-ilink-example' => 'Hivatkozás címe',
	'wikieditor-toolbar-tool-xlink' => 'Külső hivatkozás (ne felejtkezz el a http:// előtagról)',
	'wikieditor-toolbar-tool-xlink-example' => 'http://www.peldaoldal.hu hivatkozás címe',
	'wikieditor-toolbar-tool-link' => 'Hivatkozás',
	'wikieditor-toolbar-tool-link-title' => 'Hivatkozás beszúrása',
	'wikieditor-toolbar-tool-link-int' => 'A wiki egy lapjára',
	'wikieditor-toolbar-tool-link-int-target' => 'Lap címe:',
	'wikieditor-toolbar-tool-link-int-target-tooltip' => 'Lapcím vagy URL',
	'wikieditor-toolbar-tool-link-int-text' => 'A hivatkozás szövege:',
	'wikieditor-toolbar-tool-link-int-text-tooltip' => 'Add meg a megjelenítendő szöveget',
	'wikieditor-toolbar-tool-link-ext' => 'Egy külső weboldalra',
	'wikieditor-toolbar-tool-link-ext-target' => 'URL-cím:',
	'wikieditor-toolbar-tool-link-ext-text' => 'A hivatkozás szövege:',
	'wikieditor-toolbar-tool-link-insert' => 'Hivatkozás beszúrása',
	'wikieditor-toolbar-tool-link-cancel' => 'Mégse',
	'wikieditor-toolbar-tool-link-int-target-status-exists' => 'A lap létezik',
	'wikieditor-toolbar-tool-link-int-target-status-notexists' => 'A lap nem létezik',
	'wikieditor-toolbar-tool-link-int-target-status-invalid' => 'Érvénytelen cím',
	'wikieditor-toolbar-tool-link-int-target-status-external' => 'Külső hivatkozás',
	'wikieditor-toolbar-tool-link-int-target-status-loading' => 'Ellenőrzöm, hogy létezik-e a lap…',
	'wikieditor-toolbar-tool-link-int-invalid' => 'A megadott cím érvénytelen',
	'wikieditor-toolbar-tool-link-lookslikeinternal' => 'Úgy tűnik, hogy a megadott URL másik wiki lapra mutató hivatkozás akart lenni.
Szeretnéd belső hivatkozássá alakítani?',
	'wikieditor-toolbar-tool-link-lookslikeinternal-int' => 'Belső hivatkozás',
	'wikieditor-toolbar-tool-link-lookslikeinternal-ext' => 'Külső hivatkozás',
	'wikieditor-toolbar-tool-link-empty' => 'Nem adtad meg, hogy hová szeretnél hivatkozást készíteni.',
	'wikieditor-toolbar-tool-file' => 'Fájl beszúrása',
	'wikieditor-toolbar-tool-file-example' => 'Egyszerikép.jpg',
	'wikieditor-toolbar-tool-file-title' => 'Fájl beillesztése',
	'wikieditor-toolbar-file-target' => 'Fájlnév:',
	'wikieditor-toolbar-file-caption' => 'Felirat:',
	'wikieditor-toolbar-file-size' => 'Méret:',
	'wikieditor-toolbar-file-float' => 'Illesztés:',
	'wikieditor-toolbar-file-default' => '(alapértelmezett)',
	'wikieditor-toolbar-file-format' => 'Formátum:',
	'wikieditor-toolbar-tool-file-insert' => 'Beszúrás',
	'wikieditor-toolbar-tool-file-cancel' => 'Mégse',
	'wikieditor-toolbar-tool-reference' => 'Forráshivatkozás',
	'wikieditor-toolbar-tool-reference-example' => 'Ide írd a lábjegyzet szövegét',
	'wikieditor-toolbar-tool-reference-cancel' => 'Mégse',
	'wikieditor-toolbar-tool-reference-title' => 'Forráshivatkozás beszúrása',
	'wikieditor-toolbar-tool-reference-insert' => 'Beszúrás',
	'wikieditor-toolbar-tool-reference-text' => 'Forráshivatkozás szövege',
	'wikieditor-toolbar-tool-signature' => 'Aláírás és időbélyeg',
	'wikieditor-toolbar-section-advanced' => 'Haladó',
	'wikieditor-toolbar-tool-heading' => 'Címsor',
	'wikieditor-toolbar-tool-heading-1' => '1. szintű',
	'wikieditor-toolbar-tool-heading-2' => '2. szintű',
	'wikieditor-toolbar-tool-heading-3' => '3. szintű',
	'wikieditor-toolbar-tool-heading-4' => '4. szintű',
	'wikieditor-toolbar-tool-heading-5' => '5. szintű',
	'wikieditor-toolbar-tool-heading-example' => 'Címsor szövege',
	'wikieditor-toolbar-group-format' => 'Formázás',
	'wikieditor-toolbar-tool-ulist' => 'Felsorolásjeles lista',
	'wikieditor-toolbar-tool-ulist-example' => 'Listaelem',
	'wikieditor-toolbar-tool-olist' => 'Számozott lista',
	'wikieditor-toolbar-tool-olist-example' => 'Listaelem',
	'wikieditor-toolbar-tool-indent' => 'Behúzás',
	'wikieditor-toolbar-tool-indent-example' => 'Behúzott sor',
	'wikieditor-toolbar-tool-nowiki' => 'wikiformázás kikapcsolása',
	'wikieditor-toolbar-tool-nowiki-example' => 'ide írd a formázatlan szöveget',
	'wikieditor-toolbar-tool-redirect' => 'Átirányítás',
	'wikieditor-toolbar-tool-redirect-example' => 'Céllap neve',
	'wikieditor-toolbar-tool-big' => 'Nagy',
	'wikieditor-toolbar-tool-big-example' => 'Nagy szöveg',
	'wikieditor-toolbar-tool-small' => 'Kicsi',
	'wikieditor-toolbar-tool-small-example' => 'Kicsi szöveg',
	'wikieditor-toolbar-tool-superscript' => 'Felső index',
	'wikieditor-toolbar-tool-superscript-example' => 'Felső index szövege',
	'wikieditor-toolbar-tool-subscript' => 'Alsó index',
	'wikieditor-toolbar-tool-subscript-example' => 'Alsó index szövege',
	'wikieditor-toolbar-group-insert' => 'Beszúrás',
	'wikieditor-toolbar-tool-gallery' => 'Képgaléria',
	'wikieditor-toolbar-tool-gallery-example' => '$1:Példa.jpg|képaláírás1
$1:Példa.jpg|képaláírás2',
	'wikieditor-toolbar-tool-newline' => 'Új sor',
	'wikieditor-toolbar-tool-table' => 'Táblázat',
	'wikieditor-toolbar-tool-table-example-old' => '-
! 1. fejléc
! 2. fejléc
! 3. fejléc
|-
| 1. sor, 1. cella
| 1. sor, 2. cella
| 1. sor, 3. cella
|-
| 2. sor, 1. cella
| 2. sor, 2. cella
| 2. sor, 3. cella',
	'wikieditor-toolbar-tool-table-example-cell-text' => 'Cella szövege',
	'wikieditor-toolbar-tool-table-example-header' => 'Fejléc szövege',
	'wikieditor-toolbar-tool-table-title' => 'Tábla beszúrása',
	'wikieditor-toolbar-tool-table-dimensions-rows' => 'Sorok száma',
	'wikieditor-toolbar-tool-table-dimensions-columns' => 'Oszlopok száma',
	'wikieditor-toolbar-tool-table-dimensions-header' => 'A fejlécet is beleértve',
	'wikieditor-toolbar-tool-table-wikitable' => 'Stílus szegélyekkel',
	'wikieditor-toolbar-tool-table-sortable' => 'Legyen a táblázat rendezhető',
	'wikieditor-toolbar-tool-table-example' => 'Cella szövege',
	'wikieditor-toolbar-tool-table-preview' => 'Előnézet',
	'wikieditor-toolbar-tool-table-insert' => 'Beszúrás',
	'wikieditor-toolbar-tool-table-cancel' => 'Mégse',
	'wikieditor-toolbar-tool-table-toomany' => 'Több mint $1 cellát tartalmazó táblázat beillesztése nem lehetséges ezzel a párbeszédablakkal.',
	'wikieditor-toolbar-tool-table-invalidnumber' => 'Nem megfelelő számú sort vagy oszlopot adtál meg.',
	'wikieditor-toolbar-tool-table-zero' => 'Nem szúrhatsz be nulla sort vagy oszlopot tartalmazó táblázatot.',
	'wikieditor-toolbar-tool-replace' => 'Keresés és csere',
	'wikieditor-toolbar-tool-replace-title' => 'Keresés és csere',
	'wikieditor-toolbar-tool-replace-search' => 'Keresendő szöveg:',
	'wikieditor-toolbar-tool-replace-replace' => 'Csere:',
	'wikieditor-toolbar-tool-replace-case' => 'Kis- és nagybetű-érzékenység',
	'wikieditor-toolbar-tool-replace-regex' => 'A beírt szöveg egy reguláris kifejezés',
	'wikieditor-toolbar-tool-replace-button-findnext' => 'Következő keresése',
	'wikieditor-toolbar-tool-replace-button-replace' => 'Csere',
	'wikieditor-toolbar-tool-replace-button-replaceall' => 'Összes cseréje',
	'wikieditor-toolbar-tool-replace-close' => 'Bezárás',
	'wikieditor-toolbar-tool-replace-nomatch' => 'Nincs egyetlen találat sem.',
	'wikieditor-toolbar-tool-replace-success' => '$1 csere történt.',
	'wikieditor-toolbar-tool-replace-emptysearch' => 'Nem adtad meg, hogy mit akarsz keresni.',
	'wikieditor-toolbar-tool-replace-invalidregex' => 'A megadott reguláris kifejezés érvénytelen: $1',
	'wikieditor-toolbar-section-characters' => 'Különleges karakterek',
	'wikieditor-toolbar-characters-page-latin' => 'Latin',
	'wikieditor-toolbar-characters-page-latinextended' => 'Bővített latin',
	'wikieditor-toolbar-characters-page-ipa' => 'IPA',
	'wikieditor-toolbar-characters-page-symbols' => 'Szimbólumok',
	'wikieditor-toolbar-characters-page-greek' => 'Görög',
	'wikieditor-toolbar-characters-page-cyrillic' => 'Cirill',
	'wikieditor-toolbar-characters-page-arabic' => 'Arab',
	'wikieditor-toolbar-characters-page-arabicextended' => 'Arab (bővített)',
	'wikieditor-toolbar-characters-page-persian' => 'Perzsa',
	'wikieditor-toolbar-characters-page-hebrew' => 'Héber',
	'wikieditor-toolbar-characters-page-bangla' => 'Bengáli',
	'wikieditor-toolbar-characters-page-tamil' => 'Tamil',
	'wikieditor-toolbar-characters-page-telugu' => 'Telugu',
	'wikieditor-toolbar-characters-page-sinhala' => 'Szingaléz',
	'wikieditor-toolbar-characters-page-gujarati' => 'Gudzsaráti',
	'wikieditor-toolbar-characters-page-devanagari' => 'Dévanágari',
	'wikieditor-toolbar-characters-page-thai' => 'Thai',
	'wikieditor-toolbar-characters-page-lao' => 'Lao',
	'wikieditor-toolbar-characters-page-khmer' => 'Khmer',
	'wikieditor-toolbar-section-help' => 'Segítség',
	'wikieditor-toolbar-help-heading-description' => 'Leírás',
	'wikieditor-toolbar-help-heading-syntax' => 'Amit be kell írnod',
	'wikieditor-toolbar-help-heading-result' => 'Az eredmény',
	'wikieditor-toolbar-help-page-format' => 'Formázás',
	'wikieditor-toolbar-help-page-link' => 'Hivatkozások',
	'wikieditor-toolbar-help-page-heading' => 'Címsorok',
	'wikieditor-toolbar-help-page-list' => 'Listák',
	'wikieditor-toolbar-help-page-file' => 'Fájlok',
	'wikieditor-toolbar-help-page-reference' => 'Forráshivatkozások',
	'wikieditor-toolbar-help-page-discussion' => 'Megbeszélés',
	'wikieditor-toolbar-help-content-italic-description' => 'Dőlt',
	'wikieditor-toolbar-help-content-italic-syntax' => "''Dőlt szöveg''",
	'wikieditor-toolbar-help-content-italic-result' => '<em>Dőlt szöveg</em>',
	'wikieditor-toolbar-help-content-bold-description' => 'Félkövér',
	'wikieditor-toolbar-help-content-bold-syntax' => "'''Félkövér szöveg'''",
	'wikieditor-toolbar-help-content-bold-result' => '<strong>Félkövér szöveg</strong>',
	'wikieditor-toolbar-help-content-bolditalic-description' => 'Félkövér és dőlt',
	'wikieditor-toolbar-help-content-bolditalic-syntax' => "'''''Félkövér és dőlt szöveg'''''",
	'wikieditor-toolbar-help-content-bolditalic-result' => '<strong><em>Félkövér és dőlt szöveg</em></strong>',
	'wikieditor-toolbar-help-content-ilink-description' => 'Belső hivatkozás',
	'wikieditor-toolbar-help-content-ilink-syntax' => '[[Lap címe|Hivatkozás szövege]]<br />[[Lap címe]]',
	'wikieditor-toolbar-help-content-ilink-result' => "<a href='#'>Hivatkozás szövege</a><br /><a href='#'>Lap címe</a>",
	'wikieditor-toolbar-help-content-xlink-description' => 'Külső hivatkozás',
	'wikieditor-toolbar-help-content-xlink-syntax' => '[http://www.peldaoldal.hu Hivatkozás szövege]<br />[http://www.peldaoldal.hu]<br />http://www.peldaoldal.hu',
	'wikieditor-toolbar-help-content-xlink-result' => "<a href='#' class='external'>Hivatkozás szövege</a><br /><a href='#' class='external autonumber'>[1]</a><br /><a href='#' class='external'>http://www.peldaoldal.hu</a>",
	'wikieditor-toolbar-help-content-heading2-description' => 'Második szintű címsor',
	'wikieditor-toolbar-help-content-heading2-syntax' => '== Címsor szövege ==',
	'wikieditor-toolbar-help-content-heading2-result' => '<h2>Címsor szövege</h2>',
	'wikieditor-toolbar-help-content-heading3-description' => 'Harmadik szintű címsor',
	'wikieditor-toolbar-help-content-heading3-syntax' => '=== Címsor szövege ===',
	'wikieditor-toolbar-help-content-heading3-result' => '<h3>Címsor szövege</h3>',
	'wikieditor-toolbar-help-content-heading4-description' => 'Negyedik szintű címsor',
	'wikieditor-toolbar-help-content-heading4-syntax' => '==== Címsor szövege ====',
	'wikieditor-toolbar-help-content-heading4-result' => '<h4>Címsor szövege</h4>',
	'wikieditor-toolbar-help-content-heading5-description' => 'Ötödik szintű címsor',
	'wikieditor-toolbar-help-content-heading5-syntax' => '===== Címsor szövege =====',
	'wikieditor-toolbar-help-content-heading5-result' => '<h5>Címsor szövege</h5>',
	'wikieditor-toolbar-help-content-ulist-description' => 'Felsorolásjeles lista',
	'wikieditor-toolbar-help-content-ulist-syntax' => '* Listaelem<br />* Listaelem',
	'wikieditor-toolbar-help-content-ulist-result' => '<ul><li>Listaelem</li><li>Listaelem</li></ul>',
	'wikieditor-toolbar-help-content-olist-description' => 'Számozott lista',
	'wikieditor-toolbar-help-content-olist-syntax' => '# Listaelem<br /># Listaelem',
	'wikieditor-toolbar-help-content-olist-result' => '<ol><li>Listaelem</li><li>Listaelem</li></ol>',
	'wikieditor-toolbar-help-content-file-description' => 'Beszúrt fájl',
	'wikieditor-toolbar-help-content-file-syntax' => '[[$1:Example.png|thumb|Képaláírás]]',
	'wikieditor-toolbar-help-content-file-result' => "<div style='width:104px;' class='thumbinner'><a title='Caption text' class='image' href='#'><img height='50' width='100' border='0' class='thumbimage' src='$2/WikiEditor/modules/images/toolbar/example-image.png' alt=''/></a><div class='thumbcaption'><div class='magnify'><a title='A kép nagyítása' class='internal' href='#'><img height='11' width='15' alt='' src='$1/common/images/magnify-clip.png'/></a></div>Képaláírás</div></div>",
	'wikieditor-toolbar-help-content-reference-description' => 'Forráshivatkozás',
	'wikieditor-toolbar-help-content-reference-syntax' => 'Lap szövege.&lt;ref name="test"&gt;[http://www.példaoldal.hu Hivatkozás szövege], további szöveg.&lt;/ref&gt;',
	'wikieditor-toolbar-help-content-reference-result' => "Lap szövege.<sup><a href='#'>[1]</a></sup>",
	'wikieditor-toolbar-help-content-rereference-description' => 'Ugyanazon forráshivatkozás későbbi használata',
	'wikieditor-toolbar-help-content-rereference-result' => "Lap szövege.<sup><a href='#'>[1]</a></sup>",
	'wikieditor-toolbar-help-content-showreferences-description' => 'Forráshivatkozások listázása',
	'wikieditor-toolbar-help-content-showreferences-result' => "<ol class='references'><li id='cite_note-test-0'><b><a title='' href='#'>^</a></b> <a rel='nofollow' title='http://www.peldaoldal.hu' class='external text' href='#'>Hivatkozás szövege</a>, további szöveg.</li></ol>",
	'wikieditor-toolbar-help-content-signaturetimestamp-description' => 'Aláírás időbélyeggel',
	'wikieditor-toolbar-help-content-signaturetimestamp-result' => "<a href='#' title='{{#special:mypage}}'>Szerkesztőnév</a> (<a href='#' title='{{#special:mytalk}}'>vita</a>) 2009. június 10., 15:54 (CEST)",
	'wikieditor-toolbar-help-content-signature-description' => 'Aláírás',
	'wikieditor-toolbar-help-content-signature-result' => "<a href='#' title='{{#special:mypage}}'>Szerkesztőnév</a> (<a href='#' title='{{#special:mytalk}}'>vita</a>)",
	'wikieditor-toolbar-help-content-indent-description' => 'Behúzás',
	'wikieditor-toolbar-help-content-indent-syntax' => 'Sima szöveg<br />:Behúzott szöveg<br />::Behúzott szöveg',
	'wikieditor-toolbar-help-content-indent-result' => 'Sima szöveg<dl><dd>Behúzott szöveg<dl><dd>Behúzott szöveg</dd></dl></dd></dl>',
);

/** Armenian (Հայերեն)
 * @author Chaojoker
 * @author Xelgen
 */
$messages['hy'] = array(
	'wikieditor-preview-preference' => 'Ակտիվացնել կողք–կողքի նախադիտումը',
	'wikieditor-preview-tab' => 'Նախադիտել',
	'wikieditor-preview-loading' => 'Բեռնում…',
	'wikieditor-previewDialog-tab' => 'Նախադիտել',
	'wikieditor-previewDialog-loading' => 'Բեռնում…',
	'wikieditor-publish-button-publish' => 'Հրատարակել',
	'wikieditor-publish-button-cancel' => 'Բեկանել',
	'wikieditor-publish-dialog-title' => 'Հրատարակել {{SITENAME}} նախագծում',
	'wikieditor-publish-dialog-summary' => 'Խմբագրման ամփոփում (հակիրճ նկարագրեք ձեր կատարած փոփոխությունները)',
	'wikieditor-publish-dialog-minor' => 'Չնչին խմբագրում',
	'wikieditor-publish-dialog-watch' => 'Հսկել այս էջը',
	'wikieditor-publish-dialog-publish' => 'Հրատարակել',
	'wikieditor-publish-dialog-goback' => 'Հետ գնալ',
	'wikieditor-toc-preference' => 'Ակտիվացնել նավարկելի բովանդակության ցանկ',
	'wikieditor-toc-show' => 'Ցուցադրել բովանդակությունը',
	'wikieditor-toc-hide' => 'Թաքցնել բովանդակությունը',
	'wikieditor-toolbar' => 'Խմբագրման վահանակ',
	'wikieditor-toolbar-desc' => 'Բարձրացրած հարմարավետությամբ խմբագրման վահանակ',
	'wikieditor-toolbar-preference' => 'Ակտիվացնել բարելավված խմբագրման վահանակը',
	'wikieditor-toolbar-dialogs-preference' => 'Ակտիվացնել երկխոսությունները հղումների, աղյուսակների և այլնի համար',
	'wikieditor-toolbar-loading' => 'Բեռնում…',
	'wikieditor-toolbar-tool-bold' => 'Թավատառ',
	'wikieditor-toolbar-tool-bold-example' => 'Թավատառ տեքստ',
	'wikieditor-toolbar-tool-italic' => 'Շեղատառ',
	'wikieditor-toolbar-tool-italic-example' => 'Շեղատառ տեքստ',
	'wikieditor-toolbar-tool-ilink' => 'Ներքին հղում',
	'wikieditor-toolbar-tool-ilink-example' => 'Հղման վերնագիր',
	'wikieditor-toolbar-tool-xlink' => 'Արտաքին հղում (հիշեք ավելացնել http:// նախածանցը)',
	'wikieditor-toolbar-tool-xlink-example' => 'http://www.example.com հղման վերնագիրը',
	'wikieditor-toolbar-tool-link' => 'Հղում',
	'wikieditor-toolbar-tool-link-title' => 'Ավելացնել հղում',
	'wikieditor-toolbar-tool-link-int' => 'Վիքիի էջին',
	'wikieditor-toolbar-tool-link-int-target' => 'Էջի վերնագիր․',
	'wikieditor-toolbar-tool-link-int-target-tooltip' => 'Էջի վերնագիր կամ URL',
	'wikieditor-toolbar-tool-link-int-text' => 'Հղման տեսքստ․',
	'wikieditor-toolbar-tool-link-int-text-tooltip' => 'Ներմուծեք տեքստը, որ պետք է ցուցադրվի',
	'wikieditor-toolbar-tool-link-ext' => 'Արտաքին վեբ էջին',
	'wikieditor-toolbar-tool-link-ext-target' => 'Հղման URL․',
	'wikieditor-toolbar-tool-link-ext-text' => 'Հղման տեքստ․',
	'wikieditor-toolbar-tool-link-insert' => 'Ավելացնել հղում',
	'wikieditor-toolbar-tool-link-cancel' => 'Բեկանել',
	'wikieditor-toolbar-tool-link-int-target-status-exists' => 'Էջը գոյություն ունի',
	'wikieditor-toolbar-tool-link-int-target-status-notexists' => 'Էջը գոյություն չունի',
	'wikieditor-toolbar-tool-link-int-target-status-invalid' => 'Սխալ վերնագիր',
	'wikieditor-toolbar-tool-link-int-target-status-external' => 'Արտաքին հղում',
	'wikieditor-toolbar-tool-link-int-target-status-loading' => 'Էջի գոյության ստուգում…',
	'wikieditor-toolbar-tool-link-int-invalid' => 'Ձեր նշած վերնագիրը անթույլատրելի է։',
	'wikieditor-toolbar-tool-link-lookslikeinternal' => 'Ձեր նշած URL-ը նման է վիքիի այլ էջին հղմանը։
Դուք ուզո՞ւմ եք այս հղումը սարքել ներքին։',
	'wikieditor-toolbar-tool-link-lookslikeinternal-int' => 'Ներքին հղում',
	'wikieditor-toolbar-tool-link-lookslikeinternal-ext' => 'Արտաքին հղում',
	'wikieditor-toolbar-tool-link-empty' => 'Դուք հղվելու որևէ բան չեք նշել։',
	'wikieditor-toolbar-tool-file' => 'Ներկառուցված նիշք',
	'wikieditor-toolbar-tool-file-example' => 'Օրինակ.jpg',
	'wikieditor-toolbar-tool-reference' => 'Ծանոթագրություն',
	'wikieditor-toolbar-tool-reference-example' => 'Գրեք այստեղ ծանոթագրության տեքստը',
	'wikieditor-toolbar-tool-reference-cancel' => 'Բեկանել',
	'wikieditor-toolbar-tool-reference-title' => 'Ավելացնել ծանոթագրություն',
	'wikieditor-toolbar-tool-reference-insert' => 'Ավելացնել',
	'wikieditor-toolbar-tool-reference-text' => 'Ծանոթագրության տեքստը',
	'wikieditor-toolbar-tool-signature' => 'Ստորագրությունը ամսաթվով',
	'wikieditor-toolbar-section-advanced' => 'Ընդլայնված',
	'wikieditor-toolbar-tool-heading' => 'Վերնագիր',
	'wikieditor-toolbar-tool-heading-1' => '1-ին մակարդակի',
	'wikieditor-toolbar-tool-heading-2' => '2-րդ մակարդակի',
	'wikieditor-toolbar-tool-heading-3' => '3-րդ մակարդակի',
	'wikieditor-toolbar-tool-heading-4' => '4-րդ մակարդակի',
	'wikieditor-toolbar-tool-heading-5' => '5-րդ մակարդակի',
	'wikieditor-toolbar-tool-heading-example' => 'Վերնագրի տեքստ',
	'wikieditor-toolbar-group-format' => 'Ձևավորել',
	'wikieditor-toolbar-tool-ulist' => 'Չհամարակալած ցանկ',
	'wikieditor-toolbar-tool-ulist-example' => 'Չհամարակալած ցանկի տարր',
	'wikieditor-toolbar-tool-olist' => 'Համարակալած ցանկ',
	'wikieditor-toolbar-tool-olist-example' => 'Համարակալած ցանկի տարր',
	'wikieditor-toolbar-tool-indent' => 'Խորքից',
	'wikieditor-toolbar-tool-indent-example' => 'Խորքից գրված տող',
	'wikieditor-toolbar-tool-nowiki' => 'Անտեսել վիքի ձևավորումը',
	'wikieditor-toolbar-tool-nowiki-example' => 'Մուտքագրեք չձևավորված տեքստը այստեղ',
	'wikieditor-toolbar-tool-redirect' => 'Վերահղում',
	'wikieditor-toolbar-tool-redirect-example' => 'անվանումով էջին',
	'wikieditor-toolbar-tool-big' => 'Խոշոր',
	'wikieditor-toolbar-tool-big-example' => 'Խոշոր տեքստ',
	'wikieditor-toolbar-tool-small' => 'Մանր',
	'wikieditor-toolbar-tool-small-example' => 'Մանր տեքստ',
	'wikieditor-toolbar-tool-superscript' => 'Վերտողային',
	'wikieditor-toolbar-tool-superscript-example' => 'Վերտողային տեքստ',
	'wikieditor-toolbar-tool-subscript' => 'Ենթատողային',
	'wikieditor-toolbar-tool-subscript-example' => 'Ենթատողային տեքստ',
	'wikieditor-toolbar-group-insert' => 'Ավելացնել',
	'wikieditor-toolbar-tool-gallery' => 'Պատկերասրահ',
	'wikieditor-toolbar-tool-gallery-example' => '$1:Example.jpg|Նկարագրություն1
$1:Example.jpg|Նկարագրություն2',
	'wikieditor-toolbar-tool-newline' => 'Նոր տող',
	'wikieditor-toolbar-tool-table' => 'Աղյուսակ',
	'wikieditor-toolbar-tool-table-example-old' => '-
! վերնագիր 1
! վերնագիր 2
! վերնագիր 3
|-
| տող 1, սյունակ 1
| տող 1, սյունակ 2
| տող 1, սյունակ 3
|-
| տող 2, սյունակ 1
| տող 2, սյունակ 2
| տող 2, սյունակ 3',
	'wikieditor-toolbar-tool-table-example-cell-text' => 'Վանդակի տեքստ',
	'wikieditor-toolbar-tool-table-example-header' => 'Վերնագրի տեքստ',
	'wikieditor-toolbar-tool-table-title' => 'Ավելացնել աղյուսակ',
	'wikieditor-toolbar-tool-table-dimensions-rows' => 'Տողեր',
	'wikieditor-toolbar-tool-table-dimensions-columns' => 'Սյունակներ',
	'wikieditor-toolbar-tool-table-dimensions-header' => 'Ավելացնել վերնագրերի տող',
	'wikieditor-toolbar-tool-table-wikitable' => 'Եզրազարդել աղյուսակը',
	'wikieditor-toolbar-tool-table-sortable' => 'Աղյուսակը դասավորվող անել',
	'wikieditor-toolbar-tool-table-example' => 'Վանդակի տեքստ',
	'wikieditor-toolbar-tool-table-preview' => 'Նախադիտում',
	'wikieditor-toolbar-tool-table-insert' => 'Ավելացնել',
	'wikieditor-toolbar-tool-table-cancel' => 'Բեկանել',
	'wikieditor-toolbar-tool-table-toomany' => 'Այս երկխոսության միջոցով հնարավոր չէ $1 վանդակից ավել վանդակ ունեցող աղյուսակ ստեղծել։',
	'wikieditor-toolbar-tool-table-invalidnumber' => 'Դուք չեք նշել տողերի կամ սյունակների թույլատրելի քանակ։',
	'wikieditor-toolbar-tool-table-zero' => 'Դուք չեք կարող ավելացնել տողերի կամ սյունակների զրոյական քանակությամբ աղյուսակ։',
	'wikieditor-toolbar-tool-replace' => 'Որոնում և փոխարինում',
	'wikieditor-toolbar-tool-replace-title' => 'Որոնում և փոխարինում',
	'wikieditor-toolbar-tool-replace-search' => 'Որոնել․',
	'wikieditor-toolbar-tool-replace-replace' => 'Եվ փոխարինել․',
	'wikieditor-toolbar-tool-replace-case' => 'Համընկում ըստ տառաշարի (մեծատառ/փոքրատառ)',
	'wikieditor-toolbar-tool-replace-regex' => 'Որոնման տողը ընկալել որպես regular expression',
	'wikieditor-toolbar-tool-replace-button-findnext' => 'Գտնել հաջորդը',
	'wikieditor-toolbar-tool-replace-button-replaceall' => 'Փոխարինել բոլորը',
	'wikieditor-toolbar-tool-replace-close' => 'Բեկանել',
	'wikieditor-toolbar-tool-replace-nomatch' => 'Ձեր որոնմանը համապատասխանող արդյունքներ չեն գտնվել։',
	'wikieditor-toolbar-tool-replace-success' => 'Կատարվել է $1 փոխարինում։',
	'wikieditor-toolbar-tool-replace-emptysearch' => 'Դուք որոնելու որևէ բան չեք նշել։',
	'wikieditor-toolbar-tool-replace-invalidregex' => 'Ձեր նշած regular expression-ը սխալ է․ $1',
	'wikieditor-toolbar-section-characters' => 'Հատուկ նշաններ',
	'wikieditor-toolbar-characters-page-latin' => 'Լատիներեն',
	'wikieditor-toolbar-characters-page-latinextended' => 'Լատիներեն ընդլայնված',
	'wikieditor-toolbar-characters-page-ipa' => 'IPA',
	'wikieditor-toolbar-characters-page-symbols' => 'Սիմվոլներ',
	'wikieditor-toolbar-characters-page-greek' => 'Հունարեն',
	'wikieditor-toolbar-characters-page-cyrillic' => 'Կիրիլիցա',
	'wikieditor-toolbar-characters-page-arabic' => 'Արաբերեն',
	'wikieditor-toolbar-characters-page-arabicextended' => 'Արաբերեն ընդլայնված',
	'wikieditor-toolbar-characters-page-hebrew' => 'Եբրայերեն',
	'wikieditor-toolbar-characters-page-bangla' => 'Բենգալերեն',
	'wikieditor-toolbar-characters-page-telugu' => 'Տելուգու',
	'wikieditor-toolbar-characters-page-sinhala' => 'Սինհալերեն',
	'wikieditor-toolbar-characters-page-gujarati' => 'Գուջարատի',
	'wikieditor-toolbar-section-help' => 'Օգնություն',
	'wikieditor-toolbar-help-heading-description' => 'Նկարագրություն',
	'wikieditor-toolbar-help-heading-syntax' => 'Ինչ եք հավաքում',
	'wikieditor-toolbar-help-heading-result' => 'Ինչ եք ստանում',
	'wikieditor-toolbar-help-page-format' => 'Ձևավորում',
	'wikieditor-toolbar-help-page-link' => 'Հղումներ',
	'wikieditor-toolbar-help-page-heading' => 'Վերնագրեր',
	'wikieditor-toolbar-help-page-list' => 'Ցանկեր',
	'wikieditor-toolbar-help-page-file' => 'Նիշքեր',
	'wikieditor-toolbar-help-page-reference' => 'Ծանոթագրություններ',
	'wikieditor-toolbar-help-page-discussion' => 'Քննարկում',
	'wikieditor-toolbar-help-content-italic-description' => 'Շեղատառ',
	'wikieditor-toolbar-help-content-italic-syntax' => "''Շեղատառ տեքստ''",
	'wikieditor-toolbar-help-content-italic-result' => '<em>Շեղատառ տեքստ</em>',
	'wikieditor-toolbar-help-content-bold-description' => 'Թավատառ',
	'wikieditor-toolbar-help-content-bold-syntax' => "'''Թավատառ տեքստ'''",
	'wikieditor-toolbar-help-content-bold-result' => '<strong>Թավատառ տեքստ</strong>',
	'wikieditor-toolbar-help-content-bolditalic-description' => 'Թավատառ և շեղատառ',
	'wikieditor-toolbar-help-content-bolditalic-syntax' => "'''''Թավատառ և շեղատառ տեքստ'''''",
	'wikieditor-toolbar-help-content-bolditalic-result' => '<strong><em>Թավատառ և շեղատառ տեքստ</em></strong>',
	'wikieditor-toolbar-help-content-ilink-description' => 'Ներքին հղում',
	'wikieditor-toolbar-help-content-ilink-syntax' => '[[Էջի անվանում|հղման տեքստ]]<br />[[Էջի անվանում]]',
	'wikieditor-toolbar-help-content-ilink-result' => "<a href='#'>հղման տեքստ</a><br /><a href='#'>Էջի անվանում</a>",
	'wikieditor-toolbar-help-content-xlink-description' => 'Արտաքին հղում',
	'wikieditor-toolbar-help-content-xlink-syntax' => '[http://www.example.org Հղման տեքստ]<br />[http://www.example.org]<br />http://www.example.org',
	'wikieditor-toolbar-help-content-xlink-result' => "<a href='#' class='external'>Հղման տեքստ</a><br /><a href='#' class='external autonumber'>[1]</a><br /><a href='#' class='external'>http://www.example.org</a>",
	'wikieditor-toolbar-help-content-heading2-description' => '2-րդ մակարդակի վերնագիր',
	'wikieditor-toolbar-help-content-heading2-syntax' => '== Վերնագրի տեքստ ==',
	'wikieditor-toolbar-help-content-heading2-result' => '<h2>Վերնագրի տեքստ</h2>',
	'wikieditor-toolbar-help-content-heading3-description' => '3-րդ մակարդակի վերնագիր',
	'wikieditor-toolbar-help-content-heading3-syntax' => '=== Վերնագրի տեքստ ===',
	'wikieditor-toolbar-help-content-heading3-result' => '<h3>Վերնագրի տեքստ</h3>',
	'wikieditor-toolbar-help-content-heading4-description' => '4-րդ մակարդակի վերնագիր',
	'wikieditor-toolbar-help-content-heading4-syntax' => '==== Վերնագրի տեքստ ====',
	'wikieditor-toolbar-help-content-heading4-result' => '<h4>Վերնագրի տեքստ</h4>',
	'wikieditor-toolbar-help-content-heading5-description' => '5-րդ մակարդակի վերնագիր',
	'wikieditor-toolbar-help-content-heading5-syntax' => '===== Վերնագրի տեքստ =====',
	'wikieditor-toolbar-help-content-heading5-result' => '<h5>Վերնագրի տեքստ</h5>',
	'wikieditor-toolbar-help-content-ulist-description' => 'Չհամարակալած ցանկ',
	'wikieditor-toolbar-help-content-ulist-syntax' => '* Ցանկի տարր<br />* Ցանկի տարր',
	'wikieditor-toolbar-help-content-ulist-result' => '<ul><li>Ցանկի տարր</li><li>Ցանկի տարր</li></ul>',
	'wikieditor-toolbar-help-content-olist-description' => 'Համարակալած ցանկ',
	'wikieditor-toolbar-help-content-olist-syntax' => '# Ցանկի տարր<br /># Ցանկի տարր',
	'wikieditor-toolbar-help-content-olist-result' => '<ol><li>Ցանկի տարր</li><li>Ցանկի տարր</li></ol>',
	'wikieditor-toolbar-help-content-file-description' => 'Ներկառուցված նիշք',
	'wikieditor-toolbar-help-content-file-syntax' => '[[$1:Example.png|thumb|Նկարագրություն]]',
	'wikieditor-toolbar-help-content-file-result' => "<div style='width:104px;' class='thumbinner'><a title='Նկարագրություն' class='image' href='#'><img height='50' width='100' border='0' class='thumbimage' src='$2/WikiEditor/modules/images/toolbar/example-image.png' alt=''/></a><div class='thumbcaption'><div class='magnify'><a title='Ընդարձակել' class='internal' href='#'><img height='11' width='15' alt='' src='$1/common/images/magnify-clip.png'/></a></div>Նկարագրություն</div></div>",
	'wikieditor-toolbar-help-content-reference-description' => 'Ծանոթագրություն',
	'wikieditor-toolbar-help-content-reference-syntax' => 'Տեքստ էջում&lt;ref name="test"&gt;[http://www.example.org Հղման տեքստ], հավելյալ տեքստ։&lt;/ref&gt;։',
	'wikieditor-toolbar-help-content-reference-result' => "Տեքստ էջում<sup><a href='#'>[1]</a></sup>։",
	'wikieditor-toolbar-help-content-rereference-description' => 'Նույն ծանոթագրության կրկնակի օգտագործում',
	'wikieditor-toolbar-help-content-rereference-result' => "Տեքստ էջում<sup><a href='#'>[1]</a></sup>։",
	'wikieditor-toolbar-help-content-showreferences-description' => 'Ցուցադրել ծանոթագրությունները',
	'wikieditor-toolbar-help-content-showreferences-result' => "<ol class='references'><li id='cite_note-test-0'><b><a title='' href='#'>^</a></b> <a rel='nofollow' title='http://www.example.org' class='external text' href='#'>Հղման տեքստ</a>, հավելյալ տեքստ։</li></ol>",
	'wikieditor-toolbar-help-content-signaturetimestamp-description' => 'Ստորագրությունը ամսաթվով',
	'wikieditor-toolbar-help-content-signaturetimestamp-result' => "<a href='#' title='{{#special:mypage}}'>Մասնակցի Անուն</a> (<a href='#' title='{{#special:mytalk}}'>քննարկում</a>) 15:54, 29 հունիս 2009 (UTC)",
	'wikieditor-toolbar-help-content-signature-description' => 'Ստորագրություն',
	'wikieditor-toolbar-help-content-signature-result' => "<a href='#' title='{{#special:mypage}}'>Մասնակցի Անուն</a> (<a href='#' title='{{#special:mytalk}}'>քննարկում</a>)",
	'wikieditor-toolbar-help-content-indent-description' => 'Խորքից',
	'wikieditor-toolbar-help-content-indent-syntax' => 'Սովորական տեքստ<br />:Խորքից գրված տեքստ<br />::Խորքից գրված տեքստ',
	'wikieditor-toolbar-help-content-indent-result' => 'Սովորական տեքստ<dl><dd>Խորքից գրված տեքստ<dl><dd>Խորքից գրված տեքստ</dd></dl></dd></dl>',
);

/** Interlingua (interlingua)
 * @author McDutchie
 */
$messages['ia'] = array(
	'wikieditor' => 'Interfacie avantiate de modification de wikitexto',
	'wikieditor-desc' => 'Forni un interfacie de modification de wikitexto extensibile con multe modulos a functiones additional',
	'wikieditor-wikitext-tab' => 'Wikitexto',
	'wikieditor-loading' => 'Carga…',
	'wikieditor-preview-preference' => 'Activar le previsualisation latere a latere',
	'wikieditor-preview-tab' => 'Previsualisation',
	'wikieditor-preview-changes-tab' => 'Modificationes',
	'wikieditor-preview-loading' => 'Cargamento...',
	'wikieditor-previewDialog-preference' => 'Activar le dialogo de previsualisation',
	'wikieditor-previewDialog-tab' => 'Previsualisation',
	'wikieditor-previewDialog-loading' => 'Cargamento...',
	'wikieditor-publish-preference' => 'Activar publication passo a passo',
	'wikieditor-publish-button-publish' => 'Publicar',
	'wikieditor-publish-button-cancel' => 'Cancellar',
	'wikieditor-publish-dialog-title' => 'Publicar in {{SITENAME}}',
	'wikieditor-publish-dialog-summary' => 'Summario del modification (describe brevemente le cambios que tu ha facite):',
	'wikieditor-publish-dialog-minor' => 'Modification minor',
	'wikieditor-publish-dialog-watch' => 'Observar iste pagina',
	'wikieditor-publish-dialog-publish' => 'Publicar',
	'wikieditor-publish-dialog-goback' => 'Retornar',
	'wikieditor-template-editor-preference' => 'Permitter le modification de patronos wiki con formularios',
	'wikieditor-template-editor-dialog-title' => 'Modificar patrono',
	'wikieditor-template-editor-dialog-submit' => 'Actualisar',
	'wikieditor-template-editor-dialog-cancel' => 'Cancellar',
	'wikieditor-templates-preference' => 'Activar patronos plicabile',
	'wikieditor-toc-preference' => 'Activar le tabula de contento navigabile',
	'wikieditor-toc-show' => 'Revelar contento',
	'wikieditor-toc-hide' => 'Celar contento',
	'wikieditor-toolbar' => 'Instrumentario de modification',
	'wikieditor-toolbar-desc' => 'Barra con instrumentos de modification con augmento de usabilitate',
	'wikieditor-toolbar-preference' => 'Activar le instrumentario de modification meliorate',
	'wikieditor-toolbar-dialogs-preference' => 'Activar dialogos pro inserer ligamines, tabulas e plus',
	'wikieditor-toolbar-hidesig' => 'Celar le button de signatura in paginas in le spatio de nomines principal',
	'wikieditor-toolbar-loading' => 'Cargamento in curso…',
	'wikieditor-toolbar-tool-bold' => 'Grasse',
	'wikieditor-toolbar-tool-bold-example' => 'Texto grasse',
	'wikieditor-toolbar-tool-italic' => 'Italic',
	'wikieditor-toolbar-tool-italic-example' => 'Texto italic',
	'wikieditor-toolbar-tool-ilink' => 'Ligamine interne',
	'wikieditor-toolbar-tool-ilink-example' => 'Titulo del ligamine',
	'wikieditor-toolbar-tool-xlink' => 'Ligamine externe (non oblida le prefixo http://)',
	'wikieditor-toolbar-tool-xlink-example' => 'http://www.example.com titulo del ligamine',
	'wikieditor-toolbar-tool-link' => 'Ligamine',
	'wikieditor-toolbar-tool-link-title' => 'Inserer ligamine',
	'wikieditor-toolbar-tool-link-int' => 'A un pagina wiki',
	'wikieditor-toolbar-tool-link-int-target' => 'Titulo del pagina:',
	'wikieditor-toolbar-tool-link-int-target-tooltip' => 'Titulo o URL del pagina',
	'wikieditor-toolbar-tool-link-int-text' => 'Texto del ligamine:',
	'wikieditor-toolbar-tool-link-int-text-tooltip' => 'Entra le texto que debe esser monstrate',
	'wikieditor-toolbar-tool-link-ext' => 'A un pagina web externe',
	'wikieditor-toolbar-tool-link-ext-target' => 'URL del ligamine:',
	'wikieditor-toolbar-tool-link-ext-text' => 'Texto del ligamine:',
	'wikieditor-toolbar-tool-link-insert' => 'Inserer ligamine',
	'wikieditor-toolbar-tool-link-cancel' => 'Cancellar',
	'wikieditor-toolbar-tool-link-int-target-status-exists' => 'Pagina existente',
	'wikieditor-toolbar-tool-link-int-target-status-notexists' => 'Pagina non existente',
	'wikieditor-toolbar-tool-link-int-target-status-invalid' => 'Titulo invalide',
	'wikieditor-toolbar-tool-link-int-target-status-external' => 'Ligamine externe',
	'wikieditor-toolbar-tool-link-int-target-status-loading' => 'Verifica existentia del pagina...',
	'wikieditor-toolbar-tool-link-int-invalid' => 'Le titulo que tu specificava es invalide.',
	'wikieditor-toolbar-tool-link-lookslikeinternal' => 'Le URL que tu specificava pare esser intendite como ligamine a un altere pagina wiki.
Vole tu facer lo un ligamine interne?',
	'wikieditor-toolbar-tool-link-lookslikeinternal-int' => 'Ligamine interne',
	'wikieditor-toolbar-tool-link-lookslikeinternal-ext' => 'Ligamine externe',
	'wikieditor-toolbar-tool-link-empty' => 'Tu ha entrate nihil a que ligar.',
	'wikieditor-toolbar-tool-file' => 'File incastrate',
	'wikieditor-toolbar-tool-file-example' => 'Exemplo.jpg',
	'wikieditor-toolbar-tool-file-title' => 'Inserer file',
	'wikieditor-toolbar-file-target' => 'Nomine del file:',
	'wikieditor-toolbar-file-caption' => 'Legenda:',
	'wikieditor-toolbar-file-size' => 'Dimension:',
	'wikieditor-toolbar-file-float' => 'Alineamento:',
	'wikieditor-toolbar-file-default' => '(predefinition)',
	'wikieditor-toolbar-file-format' => 'Formato:',
	'wikieditor-toolbar-tool-file-insert' => 'Inserer',
	'wikieditor-toolbar-tool-file-cancel' => 'Cancellar',
	'wikieditor-toolbar-tool-reference' => 'Referentia',
	'wikieditor-toolbar-tool-reference-example' => 'Inserer hic le texto del nota',
	'wikieditor-toolbar-tool-reference-cancel' => 'Cancellar',
	'wikieditor-toolbar-tool-reference-title' => 'Inserer un referentia',
	'wikieditor-toolbar-tool-reference-insert' => 'Inserer',
	'wikieditor-toolbar-tool-reference-text' => 'Texto del referentia',
	'wikieditor-toolbar-tool-signature' => 'Signatura con data e hora',
	'wikieditor-toolbar-section-advanced' => 'Avantiate',
	'wikieditor-toolbar-tool-heading' => 'Titulo',
	'wikieditor-toolbar-tool-heading-1' => 'Nivello 1',
	'wikieditor-toolbar-tool-heading-2' => 'Nivello 2',
	'wikieditor-toolbar-tool-heading-3' => 'Nivello 3',
	'wikieditor-toolbar-tool-heading-4' => 'Nivello 4',
	'wikieditor-toolbar-tool-heading-5' => 'Nivello 5',
	'wikieditor-toolbar-tool-heading-example' => 'Texto del titulo',
	'wikieditor-toolbar-group-format' => 'Formato',
	'wikieditor-toolbar-tool-ulist' => 'Lista a punctos',
	'wikieditor-toolbar-tool-ulist-example' => 'Elemento de lista a punctos',
	'wikieditor-toolbar-tool-olist' => 'Lista numerate',
	'wikieditor-toolbar-tool-olist-example' => 'Elemento de lista numerate',
	'wikieditor-toolbar-tool-indent' => 'Indentation',
	'wikieditor-toolbar-tool-indent-example' => 'Linea indentate',
	'wikieditor-toolbar-tool-nowiki' => 'Nulle formatation wiki',
	'wikieditor-toolbar-tool-nowiki-example' => 'Insere texto non formatate hic',
	'wikieditor-toolbar-tool-redirect' => 'Redirection',
	'wikieditor-toolbar-tool-redirect-example' => 'Nomine del pagina de destination',
	'wikieditor-toolbar-tool-big' => 'Grande',
	'wikieditor-toolbar-tool-big-example' => 'Texto grande',
	'wikieditor-toolbar-tool-small' => 'Micre',
	'wikieditor-toolbar-tool-small-example' => 'Texto micre',
	'wikieditor-toolbar-tool-superscript' => 'Superscripto',
	'wikieditor-toolbar-tool-superscript-example' => 'Texto in superscripto',
	'wikieditor-toolbar-tool-subscript' => 'Subscripto',
	'wikieditor-toolbar-tool-subscript-example' => 'Texto in subscripto',
	'wikieditor-toolbar-group-insert' => 'Inserer',
	'wikieditor-toolbar-tool-gallery' => 'Galeria de imagines',
	'wikieditor-toolbar-tool-gallery-example' => '$1:Exemplo.jpg|Legenda1
$1:Exemplo.jpg|Legenda2',
	'wikieditor-toolbar-tool-newline' => 'Nove linea',
	'wikieditor-toolbar-tool-table' => 'Tabella',
	'wikieditor-toolbar-tool-table-example-old' => '-
! capite 1
! capite 2
! capite 3
|-
| linea 1, cellula 1
| linea 1, cellula 2
| linea 1, cellula 3
|-
| linea 2, cellula 1
| linea 2, cellula 2
| linea 2, cellula 3',
	'wikieditor-toolbar-tool-table-example-cell-text' => 'Texto del cellula',
	'wikieditor-toolbar-tool-table-example-header' => 'Texto del capite',
	'wikieditor-toolbar-tool-table-title' => 'Inserer tabella',
	'wikieditor-toolbar-tool-table-dimensions-rows' => 'Lineas',
	'wikieditor-toolbar-tool-table-dimensions-columns' => 'Columnas',
	'wikieditor-toolbar-tool-table-dimensions-header' => 'Includer linea de capite',
	'wikieditor-toolbar-tool-table-wikitable' => 'Stilo con bordos',
	'wikieditor-toolbar-tool-table-sortable' => 'Render tabella assortibile',
	'wikieditor-toolbar-tool-table-example' => 'Texto del cellula',
	'wikieditor-toolbar-tool-table-preview' => 'Previsualisation',
	'wikieditor-toolbar-tool-table-insert' => 'Inserer',
	'wikieditor-toolbar-tool-table-cancel' => 'Cancellar',
	'wikieditor-toolbar-tool-table-toomany' => 'Inserer un tabula con plus de $1 cellulas non es possibile con iste dialogo.',
	'wikieditor-toolbar-tool-table-invalidnumber' => 'Tu non ha entrate un numero valide de lineas o columnas.',
	'wikieditor-toolbar-tool-table-zero' => 'Tu non pote inserer un tabula con zero lineas o columnas.',
	'wikieditor-toolbar-tool-replace' => 'Cercar e reimplaciar',
	'wikieditor-toolbar-tool-replace-title' => 'Cercar e reimplaciar',
	'wikieditor-toolbar-tool-replace-search' => 'Cercar:',
	'wikieditor-toolbar-tool-replace-replace' => 'Reimplaciar per:',
	'wikieditor-toolbar-tool-replace-case' => 'Distinguer inter majusculas e minusculas',
	'wikieditor-toolbar-tool-replace-regex' => 'Tractar le catena de recerca como un expression regular',
	'wikieditor-toolbar-tool-replace-button-findnext' => 'Cercar sequente',
	'wikieditor-toolbar-tool-replace-button-replace' => 'Reimplaciar',
	'wikieditor-toolbar-tool-replace-button-replaceall' => 'Reimplaciar toto',
	'wikieditor-toolbar-tool-replace-close' => 'Clauder',
	'wikieditor-toolbar-tool-replace-nomatch' => 'Tu recerca non ha producite resultatos.',
	'wikieditor-toolbar-tool-replace-success' => '$1 reimplaciamentos facite.',
	'wikieditor-toolbar-tool-replace-emptysearch' => 'Tu non entrava texto a cercar.',
	'wikieditor-toolbar-tool-replace-invalidregex' => 'Le expression regular que tu entrava es invalide: $1',
	'wikieditor-toolbar-section-characters' => 'Characteres special',
	'wikieditor-toolbar-characters-page-latin' => 'Latin',
	'wikieditor-toolbar-characters-page-latinextended' => 'Latin extendite',
	'wikieditor-toolbar-characters-page-ipa' => 'IPA',
	'wikieditor-toolbar-characters-page-symbols' => 'Symbolos',
	'wikieditor-toolbar-characters-page-greek' => 'Greco',
	'wikieditor-toolbar-characters-page-cyrillic' => 'Cyrillic',
	'wikieditor-toolbar-characters-page-arabic' => 'Arabe',
	'wikieditor-toolbar-characters-page-arabicextended' => 'Arabe extendite',
	'wikieditor-toolbar-characters-page-persian' => 'Persiano',
	'wikieditor-toolbar-characters-page-hebrew' => 'Hebreo',
	'wikieditor-toolbar-characters-page-bangla' => 'Bengali',
	'wikieditor-toolbar-characters-page-tamil' => 'Tamil',
	'wikieditor-toolbar-characters-page-telugu' => 'Telugu',
	'wikieditor-toolbar-characters-page-sinhala' => 'Sinhala',
	'wikieditor-toolbar-characters-page-gujarati' => 'Gujarati',
	'wikieditor-toolbar-characters-page-devanagari' => 'Devanāgarī',
	'wikieditor-toolbar-characters-page-thai' => 'Thailandese',
	'wikieditor-toolbar-characters-page-lao' => 'Laotiano',
	'wikieditor-toolbar-characters-page-khmer' => 'Cambodgiano',
	'wikieditor-toolbar-section-help' => 'Adjuta',
	'wikieditor-toolbar-help-heading-description' => 'Description',
	'wikieditor-toolbar-help-heading-syntax' => 'Entrata',
	'wikieditor-toolbar-help-heading-result' => 'Resultato',
	'wikieditor-toolbar-help-page-format' => 'Formatation',
	'wikieditor-toolbar-help-page-link' => 'Ligamines',
	'wikieditor-toolbar-help-page-heading' => 'Titulos',
	'wikieditor-toolbar-help-page-list' => 'Listas',
	'wikieditor-toolbar-help-page-file' => 'Files',
	'wikieditor-toolbar-help-page-reference' => 'Referentias',
	'wikieditor-toolbar-help-page-discussion' => 'Discussion',
	'wikieditor-toolbar-help-content-italic-description' => 'Italic',
	'wikieditor-toolbar-help-content-italic-syntax' => "''Texto italic''",
	'wikieditor-toolbar-help-content-italic-result' => '<em>Texto italic</em>',
	'wikieditor-toolbar-help-content-bold-description' => 'Grasse',
	'wikieditor-toolbar-help-content-bold-syntax' => "'''Texto grasse'''",
	'wikieditor-toolbar-help-content-bold-result' => '<strong>Texto grasse</strong>',
	'wikieditor-toolbar-help-content-bolditalic-description' => 'Grasse &amp; italic',
	'wikieditor-toolbar-help-content-bolditalic-syntax' => "'''''Texto grasse &amp; italic'''''",
	'wikieditor-toolbar-help-content-bolditalic-result' => '<strong><em>Texto grasse &amp; italic</em></strong>',
	'wikieditor-toolbar-help-content-ilink-description' => 'Ligamine interne',
	'wikieditor-toolbar-help-content-ilink-syntax' => '[[Titulo del pagina|Texto del ligamine]]<br />[[Titulo del pagina]]',
	'wikieditor-toolbar-help-content-ilink-result' => "<a href='#'>Texto del ligamine</a><br /><a href='#'>Titulo del pagina</a>",
	'wikieditor-toolbar-help-content-xlink-description' => 'Ligamine externe',
	'wikieditor-toolbar-help-content-xlink-syntax' => '[http://www.example.org Texto del ligamine]<br />[http://www.example.org]<br />http://www.example.org',
	'wikieditor-toolbar-help-content-xlink-result' => "<a href='#' class='external'>Texto del ligamine</a><br /><a href='#' class='external autonumber'>[1]</a><br /><a href='#' class='external'>http://www.example.org</a>",
	'wikieditor-toolbar-help-content-heading2-description' => 'Titulo del secunde nivello',
	'wikieditor-toolbar-help-content-heading2-syntax' => '== Texto del titulo ==',
	'wikieditor-toolbar-help-content-heading2-result' => '<h2>Texto del titulo</h2>',
	'wikieditor-toolbar-help-content-heading3-description' => 'Titulo del tertie nivello',
	'wikieditor-toolbar-help-content-heading3-syntax' => '=== Texto del titulo ===',
	'wikieditor-toolbar-help-content-heading3-result' => '<h3>Texto del titulo</h3>',
	'wikieditor-toolbar-help-content-heading4-description' => 'Titulo del quarte nivello',
	'wikieditor-toolbar-help-content-heading4-syntax' => '==== Texto del titulo ====',
	'wikieditor-toolbar-help-content-heading4-result' => '<h4>Texto del titulo</h4>',
	'wikieditor-toolbar-help-content-heading5-description' => 'Titulo del quinte nivello',
	'wikieditor-toolbar-help-content-heading5-syntax' => '===== Texto del titulo =====',
	'wikieditor-toolbar-help-content-heading5-result' => '<h5>Texto del titulo</h5>',
	'wikieditor-toolbar-help-content-ulist-description' => 'Lista a punctos',
	'wikieditor-toolbar-help-content-ulist-syntax' => '* Elemento del lista<br />* Elemento del lista',
	'wikieditor-toolbar-help-content-ulist-result' => '<ul><li>Elemento del lista</li><li>Elemento del lista</li></ul>',
	'wikieditor-toolbar-help-content-olist-description' => 'Lista numerate',
	'wikieditor-toolbar-help-content-olist-syntax' => '# Elemento del lista<br /># Elemento del lista',
	'wikieditor-toolbar-help-content-olist-result' => '<ol><li>Elemento del lista</li><li>Elemento del lista</li></ol>',
	'wikieditor-toolbar-help-content-file-description' => 'File incastrate',
	'wikieditor-toolbar-help-content-file-syntax' => '[[$1:Exemplo.png|thumb|Texto del legenda]]',
	'wikieditor-toolbar-help-content-file-result' => "<div style='width:104px;' class='thumbinner'><a title='Texto del legenda' class='image' href='#'><img height='50' width='100' border='0' class='thumbimage' src='$2/WikiEditor/modules/images/toolbar/example-image.png' alt=''/></a><div class='thumbcaption'><div class='magnify'><a title='Enlarge' class='internal' href='#'><img height='11' width='15' alt='' src='$1/common/images/magnify-clip.png'/></a></div>Texto del legenda</div></div>",
	'wikieditor-toolbar-help-content-reference-description' => 'Referentia',
	'wikieditor-toolbar-help-content-reference-syntax' => 'Texto del pagina.&lt;ref name="test"&gt;[http://www.example.org Texto del ligamine], texto additional.&lt;/ref&gt;',
	'wikieditor-toolbar-help-content-reference-result' => "Texto del pagina.<sup><a href='#'>[1]</a></sup>",
	'wikieditor-toolbar-help-content-rereference-description' => 'Uso additional del mesme referentia',
	'wikieditor-toolbar-help-content-rereference-result' => "Texto del pagina.<sup><a href='#'>[1]</a></sup>",
	'wikieditor-toolbar-help-content-showreferences-description' => 'Monstrar referentias',
	'wikieditor-toolbar-help-content-showreferences-result' => "ol class='references'><li id='cite_note-test-0'><b><a title='' href='#'>^</a></b> <a rel='nofollow' title='http://www.example.org' class='external text' href='#'>Texto del ligamine</a>, texto additional.</li></ol>",
	'wikieditor-toolbar-help-content-signaturetimestamp-description' => 'Signatura con data e hora',
	'wikieditor-toolbar-help-content-signaturetimestamp-result' => "<a href='#' title='{{#special:mypage}}'>Nomine de usator</a> (<a href='#' title='{{#special:mytalk}}'>discussion</a>) 15:54, 10 junio 2009 (UTC)",
	'wikieditor-toolbar-help-content-signature-description' => 'Signatura',
	'wikieditor-toolbar-help-content-signature-result' => "<a href='#' title='{{#special:mypage}}'>Nomine de usator</a> (<a href='#' title='{{#special:mytalk}}'>discussion</a>)",
	'wikieditor-toolbar-help-content-indent-description' => 'Indentation',
	'wikieditor-toolbar-help-content-indent-syntax' => 'Texto normal<br />:Texto indentate<br />::Texto indentate',
	'wikieditor-toolbar-help-content-indent-result' => 'Texto normal<dl><dd>Texto indentate<dl><dd>Texto indentate</dd></dl></dd></dl>',
);

/** Indonesian (Bahasa Indonesia)
 * @author Bennylin
 * @author Farras
 * @author Irwangatot
 * @author IvanLanin
 * @author Kenrick95
 */
$messages['id'] = array(
	'wikieditor' => 'Antarmuka penyuntingan teks wiki canggih',
	'wikieditor-desc' => 'Menyediakan antarmuka penyuntingan teks wiki yang lebih berkembang dan banyak modul penyedia fitur',
	'wikieditor-wikitext-tab' => 'TeksWiki',
	'wikieditor-loading' => 'Pembebanan',
	'wikieditor-preview-preference' => 'Aktifkan pratayang bersisian',
	'wikieditor-preview-tab' => 'Pratayang',
	'wikieditor-preview-changes-tab' => 'Perubahan',
	'wikieditor-preview-loading' => 'Mengunggah...',
	'wikieditor-previewDialog-preference' => 'Izinkan kotak pratayang',
	'wikieditor-previewDialog-tab' => 'Pratayang',
	'wikieditor-previewDialog-loading' => 'Mengunggah...',
	'wikieditor-publish-preference' => 'Aktifkan penerbitan langkah demi langkah',
	'wikieditor-publish-button-publish' => 'Terbitkan',
	'wikieditor-publish-button-cancel' => 'Batalkan',
	'wikieditor-publish-dialog-title' => 'Terbitkan ke',
	'wikieditor-publish-dialog-summary' => 'Ringkasan suntingan (jelaskan dengan ringkas perubahan yang Anda buat):',
	'wikieditor-publish-dialog-minor' => 'Suntingan kecil',
	'wikieditor-publish-dialog-watch' => 'Pantau halaman ini',
	'wikieditor-publish-dialog-publish' => 'Terbitkan',
	'wikieditor-publish-dialog-goback' => 'Kembali',
	'wikieditor-template-editor-preference' => 'Aktifkan penyuntingan berbasis form dari templat wiki',
	'wikieditor-template-editor-dialog-title' => 'Sunting templat',
	'wikieditor-template-editor-dialog-submit' => 'Perbarui',
	'wikieditor-template-editor-dialog-cancel' => 'Batalkan',
	'wikieditor-templates-preference' => 'Aktifkan fungsi menutup templat',
	'wikieditor-toc-preference' => 'Daftar isi yang dapat dinavigasi',
	'wikieditor-toc-show' => 'Tampilkan isi',
	'wikieditor-toc-hide' => 'Sembunyikan isi',
	'wikieditor-toolbar' => 'Bilah alat penyuntingan',
	'wikieditor-toolbar-desc' => 'Bilah alat penyuntingan dengan kebergunaan yang ditingkatkan',
	'wikieditor-toolbar-preference' => 'Aktifkan bilah alat penyuntingan yang telah ditingkatkan',
	'wikieditor-toolbar-dialogs-preference' => 'Aktifkan bantuan untuk menambahkan pranala, tabel dan lainnya',
	'wikieditor-toolbar-hidesig' => 'Sembunyikan tombol tanda tangan dari halaman pada ruang nama utama',
	'wikieditor-toolbar-loading' => 'Mengunggah...',
	'wikieditor-toolbar-tool-bold' => 'Tebal',
	'wikieditor-toolbar-tool-bold-example' => 'Teks tebal',
	'wikieditor-toolbar-tool-italic' => 'Miring',
	'wikieditor-toolbar-tool-italic-example' => 'Teks miring',
	'wikieditor-toolbar-tool-ilink' => 'Pranala internal',
	'wikieditor-toolbar-tool-ilink-example' => 'Judul pranala',
	'wikieditor-toolbar-tool-xlink' => 'Pranala luar (ingat prefiks http://)',
	'wikieditor-toolbar-tool-xlink-example' => 'http://www.contoh.com judul pranala',
	'wikieditor-toolbar-tool-link' => 'Pranala',
	'wikieditor-toolbar-tool-link-title' => 'Masukkan pranala',
	'wikieditor-toolbar-tool-link-int' => 'Ke halaman wiki',
	'wikieditor-toolbar-tool-link-int-target' => 'Judul pranala:',
	'wikieditor-toolbar-tool-link-int-target-tooltip' => 'Masukkan judul atau URL halaman',
	'wikieditor-toolbar-tool-link-int-text' => 'Teks pranala:',
	'wikieditor-toolbar-tool-link-int-text-tooltip' => 'Masukkan teks yang harus ditampilkan',
	'wikieditor-toolbar-tool-link-ext' => 'Ke halaman web eksternal',
	'wikieditor-toolbar-tool-link-ext-target' => 'URL pranala:',
	'wikieditor-toolbar-tool-link-ext-text' => 'Teks pranala',
	'wikieditor-toolbar-tool-link-insert' => 'Masukkan pranala',
	'wikieditor-toolbar-tool-link-cancel' => 'Batalkan',
	'wikieditor-toolbar-tool-link-int-target-status-exists' => 'Halaman sudah ada',
	'wikieditor-toolbar-tool-link-int-target-status-notexists' => 'Halaman tidak ada',
	'wikieditor-toolbar-tool-link-int-target-status-invalid' => 'Judul tidak sah',
	'wikieditor-toolbar-tool-link-int-target-status-external' => 'Pranala luar',
	'wikieditor-toolbar-tool-link-int-target-status-loading' => 'Memeriksa keberadaan halaman...',
	'wikieditor-toolbar-tool-link-int-invalid' => 'Judul yang Anda berikan tidak sah.',
	'wikieditor-toolbar-tool-link-lookslikeinternal' => 'URL yang Anda berikan tampaknya merupakan pranala ke halaman wiki lain.
Apakah Anda ingin membuatnya menjadi pranala internal?',
	'wikieditor-toolbar-tool-link-lookslikeinternal-int' => 'Pranala internal',
	'wikieditor-toolbar-tool-link-lookslikeinternal-ext' => 'Pranala luar',
	'wikieditor-toolbar-tool-link-empty' => 'Anda tidak memasukkan apa pun untuk ditautkan.',
	'wikieditor-toolbar-tool-file' => 'Sisipkan berkas',
	'wikieditor-toolbar-tool-file-example' => 'Contoh.jpg',
	'wikieditor-toolbar-tool-file-title' => 'Sisipkan berkas',
	'wikieditor-toolbar-file-target' => 'Nama berkas:',
	'wikieditor-toolbar-file-caption' => 'Keterangan',
	'wikieditor-toolbar-file-size' => 'Ukuran:',
	'wikieditor-toolbar-file-float' => 'Rata:',
	'wikieditor-toolbar-file-default' => '(baku)',
	'wikieditor-toolbar-file-format' => 'Format:',
	'wikieditor-toolbar-tool-file-insert' => 'Sisipkan',
	'wikieditor-toolbar-tool-file-cancel' => 'Batal',
	'wikieditor-toolbar-tool-reference' => 'Referensi',
	'wikieditor-toolbar-tool-reference-example' => 'Sisipkan teks catatan kaki di sini',
	'wikieditor-toolbar-tool-reference-cancel' => 'Batalkan',
	'wikieditor-toolbar-tool-reference-title' => 'Masukkan referensi',
	'wikieditor-toolbar-tool-reference-insert' => 'Masukkan',
	'wikieditor-toolbar-tool-reference-text' => 'Teks referensi',
	'wikieditor-toolbar-tool-signature' => 'Tanda tangan dan waktu',
	'wikieditor-toolbar-section-advanced' => 'Lanjutan',
	'wikieditor-toolbar-tool-heading' => 'Judul',
	'wikieditor-toolbar-tool-heading-1' => 'Tingkat 1',
	'wikieditor-toolbar-tool-heading-2' => 'Tingkat 2',
	'wikieditor-toolbar-tool-heading-3' => 'Tingkat 3',
	'wikieditor-toolbar-tool-heading-4' => 'Tingkat 4',
	'wikieditor-toolbar-tool-heading-5' => 'Tingkat 5',
	'wikieditor-toolbar-tool-heading-example' => 'Teks judul',
	'wikieditor-toolbar-group-format' => 'Format',
	'wikieditor-toolbar-tool-ulist' => 'Daftar dengan poin',
	'wikieditor-toolbar-tool-ulist-example' => 'Baris isi',
	'wikieditor-toolbar-tool-olist' => 'Daftar bernomor',
	'wikieditor-toolbar-tool-olist-example' => 'Baris isi',
	'wikieditor-toolbar-tool-indent' => 'Lekukan',
	'wikieditor-toolbar-tool-indent-example' => 'Baris terlekuk',
	'wikieditor-toolbar-tool-nowiki' => 'Tidak ada pemformatan wiki',
	'wikieditor-toolbar-tool-nowiki-example' => 'Masukkan teks yang tidak akan diformat di sini',
	'wikieditor-toolbar-tool-redirect' => 'Pengalihan',
	'wikieditor-toolbar-tool-redirect-example' => 'Nama halaman tujuan',
	'wikieditor-toolbar-tool-big' => 'Besar',
	'wikieditor-toolbar-tool-big-example' => 'Teks besar',
	'wikieditor-toolbar-tool-small' => 'Kecil',
	'wikieditor-toolbar-tool-small-example' => 'Teks kecil',
	'wikieditor-toolbar-tool-superscript' => 'Superscript',
	'wikieditor-toolbar-tool-superscript-example' => 'Teks superscript',
	'wikieditor-toolbar-tool-subscript' => 'Subscript',
	'wikieditor-toolbar-tool-subscript-example' => 'Teks subscript',
	'wikieditor-toolbar-group-insert' => 'Masukkan',
	'wikieditor-toolbar-tool-gallery' => 'Galeri gambar',
	'wikieditor-toolbar-tool-gallery-example' => '$1:Contoh.jpg|Judul1
$1:Contoh.jpg|Judul2',
	'wikieditor-toolbar-tool-newline' => 'Baris baru',
	'wikieditor-toolbar-tool-table' => 'Tabel',
	'wikieditor-toolbar-tool-table-example-old' => '	-
! judul bagian 1
! judul bagian 2
! judul bagian 3
|-
| baris 1, sel 1
| baris 1, sel 2
| baris 1, sel 3
|-
| baris 2, sel 1
| baris 2, sel 2
| baris 2, sel 3',
	'wikieditor-toolbar-tool-table-example-cell-text' => 'Teks sel',
	'wikieditor-toolbar-tool-table-example-header' => 'Teks judul',
	'wikieditor-toolbar-tool-table-title' => 'Masukkan tabel',
	'wikieditor-toolbar-tool-table-dimensions-rows' => 'Baris',
	'wikieditor-toolbar-tool-table-dimensions-columns' => 'Kolom',
	'wikieditor-toolbar-tool-table-dimensions-header' => 'Sertakan baris',
	'wikieditor-toolbar-tool-table-wikitable' => 'Gaya dengan bingkai',
	'wikieditor-toolbar-tool-table-sortable' => 'Buat tabel dapat diurutkan',
	'wikieditor-toolbar-tool-table-example' => 'Teks sel',
	'wikieditor-toolbar-tool-table-preview' => 'Pratayang',
	'wikieditor-toolbar-tool-table-insert' => 'Masukkan',
	'wikieditor-toolbar-tool-table-cancel' => 'Batalkan',
	'wikieditor-toolbar-tool-table-toomany' => 'Anda tidak dapat membuat tabel dengan jumlah sel yang lebih dari $1',
	'wikieditor-toolbar-tool-table-invalidnumber' => 'Anda tidak memasukkan jumlah kolom atau baris yang sah',
	'wikieditor-toolbar-tool-table-zero' => 'Anda tidak dapat memasukkan tabel dengan jumlah baris atau kolom nol.',
	'wikieditor-toolbar-tool-replace' => 'Cari dan gantikan',
	'wikieditor-toolbar-tool-replace-title' => 'Cari dan ganti',
	'wikieditor-toolbar-tool-replace-search' => 'Cari:',
	'wikieditor-toolbar-tool-replace-replace' => 'Ganti dengan:',
	'wikieditor-toolbar-tool-replace-case' => 'Cocokkan huruf besar/kecil',
	'wikieditor-toolbar-tool-replace-regex' => "Perlakukan string pencarian sebagai ''regular expression (regex)''",
	'wikieditor-toolbar-tool-replace-button-findnext' => 'Cari berikutnya',
	'wikieditor-toolbar-tool-replace-button-replace' => 'Ganti',
	'wikieditor-toolbar-tool-replace-button-replaceall' => 'Ganti semua',
	'wikieditor-toolbar-tool-replace-close' => 'Tutup',
	'wikieditor-toolbar-tool-replace-nomatch' => 'Pencarian Anda tidak membuahkan hasil.',
	'wikieditor-toolbar-tool-replace-success' => 'Terjadi $1 penggantian.',
	'wikieditor-toolbar-tool-replace-emptysearch' => 'Anda tidak memasukan apa pun untuk di pencarian.',
	'wikieditor-toolbar-tool-replace-invalidregex' => 'Kalimat biasa yang Anda masukkan tidak sah: $1',
	'wikieditor-toolbar-section-characters' => 'Karakter spesial',
	'wikieditor-toolbar-characters-page-latin' => 'Latin',
	'wikieditor-toolbar-characters-page-latinextended' => 'Ekstensi Latin',
	'wikieditor-toolbar-characters-page-ipa' => 'IPA',
	'wikieditor-toolbar-characters-page-symbols' => 'Simbol',
	'wikieditor-toolbar-characters-page-greek' => 'Yunani',
	'wikieditor-toolbar-characters-page-cyrillic' => 'Sirilik',
	'wikieditor-toolbar-characters-page-arabic' => 'Arab',
	'wikieditor-toolbar-characters-page-arabicextended' => 'Arab tambahan',
	'wikieditor-toolbar-characters-page-persian' => 'Persia',
	'wikieditor-toolbar-characters-page-hebrew' => 'Ibrani',
	'wikieditor-toolbar-characters-page-bangla' => 'Bangla',
	'wikieditor-toolbar-characters-page-tamil' => 'Tamil',
	'wikieditor-toolbar-characters-page-telugu' => 'Telugu',
	'wikieditor-toolbar-characters-page-sinhala' => 'Sinhala',
	'wikieditor-toolbar-characters-page-gujarati' => 'Gujarati',
	'wikieditor-toolbar-characters-page-devanagari' => 'Dewanagari',
	'wikieditor-toolbar-characters-page-thai' => 'Thai',
	'wikieditor-toolbar-characters-page-lao' => 'Lao',
	'wikieditor-toolbar-characters-page-khmer' => 'Khmer',
	'wikieditor-toolbar-section-help' => 'Bantuan',
	'wikieditor-toolbar-help-heading-description' => 'Keterangan',
	'wikieditor-toolbar-help-heading-syntax' => 'Yang Anda ketikkan',
	'wikieditor-toolbar-help-heading-result' => 'Hasil tampilan',
	'wikieditor-toolbar-help-page-format' => 'Pemformatan',
	'wikieditor-toolbar-help-page-link' => 'Pranala',
	'wikieditor-toolbar-help-page-heading' => 'Judul',
	'wikieditor-toolbar-help-page-list' => 'Daftar',
	'wikieditor-toolbar-help-page-file' => 'Berkas',
	'wikieditor-toolbar-help-page-reference' => 'Referensi',
	'wikieditor-toolbar-help-page-discussion' => 'Diskusi',
	'wikieditor-toolbar-help-content-italic-description' => 'Cetak miring',
	'wikieditor-toolbar-help-content-italic-syntax' => "''Teks miring''",
	'wikieditor-toolbar-help-content-italic-result' => '<em>Teks miring</em>',
	'wikieditor-toolbar-help-content-bold-description' => 'Tebal',
	'wikieditor-toolbar-help-content-bold-syntax' => "'''Teks tebal'''",
	'wikieditor-toolbar-help-content-bold-result' => '<strong>Teks tebal</strong>',
	'wikieditor-toolbar-help-content-bolditalic-description' => 'Tebal &amp; miring',
	'wikieditor-toolbar-help-content-bolditalic-syntax' => "'''''Teks tebal &amp; miring'''''",
	'wikieditor-toolbar-help-content-bolditalic-result' => '<strong><em>Teks tebal &amp; miring</em></strong>',
	'wikieditor-toolbar-help-content-ilink-description' => 'Pranala internal',
	'wikieditor-toolbar-help-content-ilink-syntax' => '[[Judul halaman|Judul pranala]]<br />[[Judul halaman]]',
	'wikieditor-toolbar-help-content-ilink-result' => "<a href='#'>Label pranala</a><br /><a href='#'>Judul halaman</a>",
	'wikieditor-toolbar-help-content-xlink-description' => 'Pranala luar',
	'wikieditor-toolbar-help-content-xlink-syntax' => '[http://www.contoh.org Label pranala]<br />[http://www.contoh.org]<br />http://www.contoh.org',
	'wikieditor-toolbar-help-content-xlink-result' => "<a href='#' class='external'>Label pranala</a><br /><a href='#' class='external autonumber'>[1]</a><br /><a href='#' class='external'>http://www.contoh.org</a>",
	'wikieditor-toolbar-help-content-heading2-description' => 'Judul bagian tingkat kedua',
	'wikieditor-toolbar-help-content-heading2-syntax' => '== Teks judul ==',
	'wikieditor-toolbar-help-content-heading2-result' => '<h2>Teks judul</h2>',
	'wikieditor-toolbar-help-content-heading3-description' => 'Judul bagian tingkat ketiga',
	'wikieditor-toolbar-help-content-heading3-syntax' => '=== Teks judul ===',
	'wikieditor-toolbar-help-content-heading3-result' => '<h3>Teks judul</h3>',
	'wikieditor-toolbar-help-content-heading4-description' => 'Judul bagian tingkat keempat',
	'wikieditor-toolbar-help-content-heading4-syntax' => '==== Teks judul ====',
	'wikieditor-toolbar-help-content-heading4-result' => '<h4>Teks judul</h4>',
	'wikieditor-toolbar-help-content-heading5-description' => 'Judul bagian tingkat kelima',
	'wikieditor-toolbar-help-content-heading5-syntax' => '===== Teks judul =====',
	'wikieditor-toolbar-help-content-heading5-result' => '<h5>Teks judul</h5>',
	'wikieditor-toolbar-help-content-ulist-description' => 'Daftar berpoin',
	'wikieditor-toolbar-help-content-ulist-syntax' => '* Isi daftar<br />* Isi daftar',
	'wikieditor-toolbar-help-content-ulist-result' => '<ul><li>Isi daftar</li><li>Isi daftar</li></ul>',
	'wikieditor-toolbar-help-content-olist-description' => 'Daftar bernomor',
	'wikieditor-toolbar-help-content-olist-syntax' => '# Isi daftar<br /># Isi daftar',
	'wikieditor-toolbar-help-content-olist-result' => '<ol><li>Isi daftar</li><li>Isi daftar</li></ol>',
	'wikieditor-toolbar-help-content-file-description' => 'Menyisipkan berkas',
	'wikieditor-toolbar-help-content-file-syntax' => '[[$1:Contoh.png|thumb|Teks judul gambar]]',
	'wikieditor-toolbar-help-content-file-result' => "<div style='width:104px;' class='thumbinner'><a title='Teks judul gambar' class='image' href='/wiki/Berkas:Wiki.png'><img height='50' width='100' border='0' class='thumbimage' src='$2/WikiEditor/modules/images/toolbar/example-image.png' alt=''/></a><div class='thumbcaption'><div class='magnify'><a title='Perbesar' class='internal' href='/wiki/Berkas:Wiki.png'><img height='11' width='15' alt='' src='$1/common/images/magnify-clip.png'/></a></div>Teks judul gambar</div></div>",
	'wikieditor-toolbar-help-content-reference-description' => 'Referensi',
	'wikieditor-toolbar-help-content-reference-syntax' => 'Teks halaman.&lt;ref name="test"&gt;[http://www.contoh.org Teks pranala], teks tambahan.&lt;/ref&gt;',
	'wikieditor-toolbar-help-content-reference-result' => "Teks halaman.<sup><a href='#'>[1]</a></sup>",
	'wikieditor-toolbar-help-content-rereference-description' => 'Penggunaan kembali referensi yang sama',
	'wikieditor-toolbar-help-content-rereference-result' => "Teks halaman.<sup><a href='#'>[1]</a></sup>",
	'wikieditor-toolbar-help-content-showreferences-description' => 'Menampilkan referensi',
	'wikieditor-toolbar-help-content-showreferences-result' => "<ol class='references'><li id='cite_note-test-0'><b><a title='' href='#'>^</a></b> <a rel='nofollow' title='http://www.contoh.org' class='external text' href='#'>Teks pranala</a>, teks tambahan.</li></ol>",
	'wikieditor-toolbar-help-content-signaturetimestamp-description' => 'Tanda tangan dengan waktu',
	'wikieditor-toolbar-help-content-signaturetimestamp-result' => "<a href='#' title='{{#special:mypage}}'>Name pengguna</a> (<a href='#' title='{{#special:mytalk}}'>bicara</a>) 15:54, 10 June 2009 (UTC)",
	'wikieditor-toolbar-help-content-signature-description' => 'Tanda tangan',
	'wikieditor-toolbar-help-content-signature-result' => "<a href='#' title='{{#special:mypage}}'>Nama pengguna</a> (<a href='#' title='{{#special:mytalk}}'>bicara</a>)",
	'wikieditor-toolbar-help-content-indent-description' => 'Inden',
	'wikieditor-toolbar-help-content-indent-syntax' => 'Teks biasa<br />:Teks inden<br />::Teks inden',
	'wikieditor-toolbar-help-content-indent-result' => 'Teks normal<dl><dd>Teks inden<dl><dd>Teks inden</dd></dl></dd></dl>',
);

/** Igbo (Igbo)
 * @author Ukabia
 */
$messages['ig'] = array(
	'wikieditor-loading' => 'Ọ na biá',
	'wikieditor-preview-changes-tab' => 'Ihe gbanwere',
	'wikieditor-preview-loading' => 'Ọ biágó...',
	'wikieditor-previewDialog-tab' => 'Lètú',
	'wikieditor-publish-button-publish' => 'Bìpụta',
	'wikieditor-publish-button-cancel' => 'Kàchá',
	'wikieditor-publish-dialog-minor' => 'Orü ntà',
	'wikieditor-publish-dialog-publish' => 'Bìpụta',
	'wikieditor-publish-dialog-goback' => 'Gá na àzú',
	'wikieditor-template-editor-dialog-title' => 'Rüwa àtụ',
	'wikieditor-template-editor-dialog-submit' => 'Dịnwanye mmā',
	'wikieditor-template-editor-dialog-cancel' => 'Kàchá',
	'wikieditor-toc-show' => 'Zí ihe di ímé',
	'wikieditor-toc-hide' => 'Zonari ihe di ímé',
	'wikieditor-toolbar-loading' => 'Ọ biágó...',
	'wikieditor-toolbar-tool-bold' => 'Shí íke',
	'wikieditor-toolbar-tool-bold-example' => 'Mkpúrù èdè íke',
	'wikieditor-toolbar-tool-italic' => 'Édémédé nsem',
	'wikieditor-toolbar-tool-italic-example' => 'Mkpurụ okwu sélénsé',
	'wikieditor-toolbar-tool-ilink' => 'Jikodo nke ímé',
	'wikieditor-toolbar-tool-ilink-example' => 'Ishi edemede nke jikodo',
	'wikieditor-toolbar-tool-link' => 'Jikodo',
	'wikieditor-toolbar-tool-link-title' => 'Tìnyé jikodo',
	'wikieditor-toolbar-tool-link-ext-target' => 'Jikodo URL:',
	'wikieditor-toolbar-tool-link-ext-text' => 'Jikodo mkpúrù èdè:',
	'wikieditor-toolbar-tool-link-cancel' => 'Kàchá',
	'wikieditor-toolbar-tool-link-int-target-status-exists' => 'Ihü dị',
	'wikieditor-toolbar-tool-link-int-target-status-external' => 'Jikodo di èzí',
	'wikieditor-toolbar-tool-reference-cancel' => 'Kàchá',
	'wikieditor-toolbar-tool-reference-insert' => 'Tìnyé',
	'wikieditor-toolbar-tool-heading-1' => 'Ọtú 1',
	'wikieditor-toolbar-tool-heading-2' => 'Ọtú 2',
	'wikieditor-toolbar-tool-heading-3' => 'Ọtú 3',
	'wikieditor-toolbar-tool-heading-4' => 'Ọtú 4',
	'wikieditor-toolbar-tool-heading-5' => 'Ọtú 5',
	'wikieditor-toolbar-tool-heading-example' => 'Mkpụrụ édé íshí',
	'wikieditor-toolbar-tool-big' => 'Ukwu',
	'wikieditor-toolbar-tool-big-example' => 'Mkpụrụ okwu nke ukwu',
	'wikieditor-toolbar-tool-small' => 'Ntàkiri',
	'wikieditor-toolbar-tool-small-example' => 'Mkpụrụ okwu nke ntàkịrị',
	'wikieditor-toolbar-tool-newline' => 'Áhịrị ohürù',
	'wikieditor-toolbar-tool-table' => 'Agada',
	'wikieditor-toolbar-tool-table-dimensions-rows' => 'Ǹdịlị',
	'wikieditor-toolbar-tool-table-dimensions-columns' => 'Ogìdì',
	'wikieditor-toolbar-tool-table-cancel' => 'Kàchá',
	'wikieditor-toolbar-tool-replace-search' => 'Chọwa màkà:',
	'wikieditor-toolbar-tool-replace-close' => 'Mèchié',
	'wikieditor-toolbar-characters-page-latin' => 'Latin',
	'wikieditor-toolbar-characters-page-latinextended' => 'Latin dọrọ',
	'wikieditor-toolbar-characters-page-ipa' => 'IPA',
	'wikieditor-toolbar-characters-page-symbols' => 'Nkárí',
	'wikieditor-toolbar-characters-page-greek' => 'Greek',
	'wikieditor-toolbar-characters-page-cyrillic' => 'Cyrillic',
	'wikieditor-toolbar-characters-page-arabic' => 'Arabiki',
	'wikieditor-toolbar-characters-page-persian' => 'Asụsụ Persia',
	'wikieditor-toolbar-characters-page-hebrew' => 'Asụsụ Hebrew',
	'wikieditor-toolbar-characters-page-bangla' => 'Bangla',
	'wikieditor-toolbar-characters-page-telugu' => 'Telugu',
	'wikieditor-toolbar-characters-page-sinhala' => 'Sinhala',
	'wikieditor-toolbar-characters-page-gujarati' => 'Gujarati',
	'wikieditor-toolbar-characters-page-thai' => 'Asụsụ Thai',
	'wikieditor-toolbar-characters-page-lao' => 'Asụsụ Laos',
	'wikieditor-toolbar-characters-page-khmer' => 'Khmer',
	'wikieditor-toolbar-section-help' => 'Nkwádo',
	'wikieditor-toolbar-help-heading-description' => 'Nkówká ihe ȯ bụ',
	'wikieditor-toolbar-help-page-link' => 'Jikodo',
	'wikieditor-toolbar-help-page-heading' => 'Íshí édé',
	'wikieditor-toolbar-help-page-list' => 'Ndetu',
	'wikieditor-toolbar-help-page-file' => 'Usòrò',
	'wikieditor-toolbar-help-page-discussion' => 'Ákíkó',
	'wikieditor-toolbar-help-content-italic-description' => 'Édémédé nsem',
	'wikieditor-toolbar-help-content-bold-description' => 'Shí íke',
	'wikieditor-toolbar-help-content-bold-syntax' => "'''Édémédé shírí íké'''",
	'wikieditor-toolbar-help-content-ilink-description' => 'Jikodo nke ímé',
	'wikieditor-toolbar-help-content-xlink-description' => 'Jikodo di èzí',
	'wikieditor-toolbar-help-content-heading2-syntax' => '== Édémédé íshí ==',
	'wikieditor-toolbar-help-content-heading2-result' => '<h2>Íshí edemede</h2>',
	'wikieditor-toolbar-help-content-heading3-syntax' => '=== Édémédé íshí ===',
	'wikieditor-toolbar-help-content-heading3-result' => '<h3>Íshí edemede</h3>',
	'wikieditor-toolbar-help-content-heading4-syntax' => '==== Édémédé íshí ====',
	'wikieditor-toolbar-help-content-heading4-result' => '<h4>Íshí edemede</h4>',
	'wikieditor-toolbar-help-content-heading5-syntax' => '===== Édémédé íshí =====',
	'wikieditor-toolbar-help-content-heading5-result' => '<h5>Íshí edemede</h5>',
	'wikieditor-toolbar-help-content-signature-description' => 'Áhà gi',
	'wikieditor-toolbar-help-content-indent-description' => 'Tụ atụ',
);

/** Iloko (Ilokano)
 * @author Lam-ang
 */
$messages['ilo'] = array(
	'wikieditor' => 'Napasayaat a wikitext nga interface ti panagurnos',
	'wikieditor-desc' => 'Mangited ti maipadakkel a wikitext nga interface ti panagurnos ken adu pay a langa a maited dagiti modulo',
	'wikieditor-wikitext-tab' => 'Wikitext',
	'wikieditor-loading' => 'Agkarkarga...',
	'wikieditor-preview-preference' => 'Pakabaelanna ti agsumbangir a panagipadas',
	'wikieditor-preview-tab' => 'Ipadas',
	'wikieditor-preview-changes-tab' => 'Dagiti sinukatan',
	'wikieditor-preview-loading' => 'Agkarkarga...',
	'wikieditor-previewDialog-preference' => 'Pakabaelan ti panakisinnarita a panagipadas',
	'wikieditor-previewDialog-tab' => 'Ipadas',
	'wikieditor-previewDialog-loading' => 'Agkarkarga...',
	'wikieditor-publish-preference' => 'Pakabaelan ti naiyaddang a panagipablaak',
	'wikieditor-publish-button-publish' => 'Ipablaak',
	'wikieditor-publish-button-cancel' => 'Ukasen',
	'wikieditor-publish-dialog-title' => 'Ipabablaak idiay {{SITENAME}}',
	'wikieditor-publish-dialog-summary' => 'Pakapukpukan ti panagurnos (ipalawag bassit dagiti sinukatam) :',
	'wikieditor-publish-dialog-minor' => 'Bassit a panag-urnos',
	'wikieditor-publish-dialog-watch' => 'Bantayan daytoy a panid',
	'wikieditor-publish-dialog-publish' => 'Ipablaak',
	'wikieditor-publish-dialog-goback' => 'Agsubli',
	'wikieditor-template-editor-preference' => 'Pakabaelanna ti naibatay ti porma a panag-urnos kadagiti plantilia ti wiki',
	'wikieditor-template-editor-dialog-title' => 'Urnosen ti plantilia',
	'wikieditor-template-editor-dialog-submit' => 'Pabaruen',
	'wikieditor-template-editor-dialog-cancel' => 'Ukasen',
	'wikieditor-templates-preference' => 'Pakabaelanna ti panagrebba ti plantilia',
	'wikieditor-toc-preference' => 'Pakabaelanna ti madaliasat a tabla dagiti linaon',
	'wikieditor-toc-show' => 'Ipakita dagiti linaon',
	'wikieditor-toc-hide' => 'Ilemmeng dagiti linaon',
	'wikieditor-toolbar' => 'Ramit a baras ti panag-urnos',
	'wikieditor-toolbar-desc' => 'Ramit ti baras ti panag-urnos nga addan ti napasayaat a panag-usar',
	'wikieditor-toolbar-preference' => 'Pakabaelanna ti napasayaat a ramit ti baras a panag-urnos',
	'wikieditor-toolbar-dialogs-preference' => 'Pakabaekanna dagiti panakisinnarita para iti panagisengngat kadagiti panilpo, tab-tabla ken adu pay',
	'wikieditor-toolbar-hidesig' => 'Ilemmeng ti pirma a buton manipud kadagiti panid iti umuna a nagan ti lugar',
	'wikieditor-toolbar-loading' => 'Agkarkarga...',
	'wikieditor-toolbar-tool-bold' => 'Napuskol',
	'wikieditor-toolbar-tool-bold-example' => 'Napuskol a testo',
	'wikieditor-toolbar-tool-italic' => 'Agir-irig',
	'wikieditor-toolbar-tool-italic-example' => 'Nakairig a testo',
	'wikieditor-toolbar-tool-ilink' => 'Akinuneg a panilpo',
	'wikieditor-toolbar-tool-ilink-example' => 'Titulo ti panilpo',
	'wikieditor-toolbar-tool-xlink' => 'Akinruar a panilpo (laglagipen ti http:// a pasaruno)',
	'wikieditor-toolbar-tool-xlink-example' => 'http://www.example.com titulo ti panilpo',
	'wikieditor-toolbar-tool-link' => 'Panilpo',
	'wikieditor-toolbar-tool-link-title' => 'Isengngat ti panilpo',
	'wikieditor-toolbar-tool-link-int' => 'Iti panid a wiki',
	'wikieditor-toolbar-tool-link-int-target' => 'Puntaan a panid wenno URL:',
	'wikieditor-toolbar-tool-link-int-target-tooltip' => 'Titulo ti panid wenno URL',
	'wikieditor-toolbar-tool-link-int-text' => 'Testo nga iparang:',
	'wikieditor-toolbar-tool-link-int-text-tooltip' => 'Testo nga iparang',
	'wikieditor-toolbar-tool-link-ext' => 'Idiay akinuneg a panid ti sapot',
	'wikieditor-toolbar-tool-link-ext-target' => 'Isilpo ti URL:',
	'wikieditor-toolbar-tool-link-ext-text' => 'Isilpo ti testo:',
	'wikieditor-toolbar-tool-link-insert' => 'Isengngat ti panilpo',
	'wikieditor-toolbar-tool-link-cancel' => 'Ukasen',
	'wikieditor-toolbar-tool-link-int-target-status-exists' => 'Addaan ti panid',
	'wikieditor-toolbar-tool-link-int-target-status-notexists' => 'Awan ti panid',
	'wikieditor-toolbar-tool-link-int-target-status-invalid' => 'Imbalido a titulo',
	'wikieditor-toolbar-tool-link-int-target-status-external' => 'Kasilpo iti ruar',
	'wikieditor-toolbar-tool-link-int-target-status-loading' => 'Kitkitaen no adda ti panid...',
	'wikieditor-toolbar-tool-link-int-invalid' => 'Ti titulo a nainaganam ket imbalido.',
	'wikieditor-toolbar-tool-link-lookslikeinternal' => 'Ti URL a nainaganam ket kasla naaramid a panilpo iti sabali a panid ti wiki.
Kayatmo nga aramiden daytoy nga akinuneg a panilpo?',
	'wikieditor-toolbar-tool-link-lookslikeinternal-int' => 'Akinuneg a panilpo',
	'wikieditor-toolbar-tool-link-lookslikeinternal-ext' => 'Kasilpo iti ruar',
	'wikieditor-toolbar-tool-link-empty' => 'Awan ti inkabilmo a pakaisilpuan.',
	'wikieditor-toolbar-tool-file' => 'Naisengngat a papeles',
	'wikieditor-toolbar-tool-file-example' => 'Kas pagarigan.jpg',
	'wikieditor-toolbar-tool-file-title' => 'Isengngat ti papeles',
	'wikieditor-toolbar-file-target' => 'Nagan ti papeles:',
	'wikieditor-toolbar-file-caption' => 'Maisurat:',
	'wikieditor-toolbar-file-size' => 'Kadakkel:',
	'wikieditor-toolbar-file-float' => 'Ilinia:',
	'wikieditor-toolbar-file-default' => '(kasisigud)',
	'wikieditor-toolbar-file-format' => 'Pormat:',
	'wikieditor-toolbar-file-format-none' => 'awan',
	'wikieditor-toolbar-tool-file-insert' => 'Isengngat',
	'wikieditor-toolbar-tool-file-cancel' => 'Ukasen',
	'wikieditor-toolbar-tool-reference' => 'Pinagibasaran',
	'wikieditor-toolbar-tool-reference-example' => 'Isengngat ti paammo ti baba a testo ditoy',
	'wikieditor-toolbar-tool-reference-cancel' => 'Ukasen',
	'wikieditor-toolbar-tool-reference-title' => 'Isengngat ti pinagibasaran',
	'wikieditor-toolbar-tool-reference-insert' => 'Isengngat',
	'wikieditor-toolbar-tool-reference-text' => 'Testo ti pinagibasaran',
	'wikieditor-toolbar-tool-signature' => 'Pirma, petsa ken oras',
	'wikieditor-toolbar-section-advanced' => 'Napasayaat',
	'wikieditor-toolbar-tool-heading' => 'Paulo',
	'wikieditor-toolbar-tool-heading-1' => 'Agpang 1',
	'wikieditor-toolbar-tool-heading-2' => 'Agpang 2',
	'wikieditor-toolbar-tool-heading-3' => 'Agpang 3',
	'wikieditor-toolbar-tool-heading-4' => 'Agpang 4',
	'wikieditor-toolbar-tool-heading-5' => 'Agpang 5',
	'wikieditor-toolbar-tool-heading-example' => 'Testo ti paulo',
	'wikieditor-toolbar-group-format' => 'Pormat',
	'wikieditor-toolbar-tool-ulist' => 'Punglo a listaan',
	'wikieditor-toolbar-tool-ulist-example' => 'Punglo a listaan ti banag',
	'wikieditor-toolbar-tool-olist' => 'Nabilangan a listaan',
	'wikieditor-toolbar-tool-olist-example' => 'Nabilangan a listaan ti banag',
	'wikieditor-toolbar-tool-indent' => 'Lennekan',
	'wikieditor-toolbar-tool-indent-example' => 'Nalennekan a linia',
	'wikieditor-toolbar-tool-nowiki' => 'Saan a pormaen a kas wiki',
	'wikieditor-toolbar-tool-nowiki-example' => 'Mangisuldong ti saan a nabuklan a testo ditoy',
	'wikieditor-toolbar-tool-redirect' => 'Baw-ing',
	'wikieditor-toolbar-tool-redirect-example' => 'Nagan ti puntaan a panid',
	'wikieditor-toolbar-tool-big' => 'Dakkel',
	'wikieditor-toolbar-tool-big-example' => 'Dakkel a testo',
	'wikieditor-toolbar-tool-small' => 'Bassit',
	'wikieditor-toolbar-tool-small-example' => 'Bassit a testo',
	'wikieditor-toolbar-tool-superscript' => 'Superscript',
	'wikieditor-toolbar-tool-superscript-example' => 'Testo ti superscript',
	'wikieditor-toolbar-tool-subscript' => 'Subscript',
	'wikieditor-toolbar-tool-subscript-example' => 'Testo ti subscript',
	'wikieditor-toolbar-group-insert' => 'Isengngat',
	'wikieditor-toolbar-tool-gallery' => 'Palko ti retrato',
	'wikieditor-toolbar-tool-gallery-example' => '$1:Example.jpg|Naisurat1
$1:Example.jpg|Naisurat2',
	'wikieditor-toolbar-tool-newline' => 'Baro a linia',
	'wikieditor-toolbar-tool-table' => 'Tabla',
	'wikieditor-toolbar-tool-table-example-old' => '-
! paulo 1
! paulo 2
! paulo 3
|-
| aray 1, selula 1
| aray 1, selula 2
| aray 1, selula 3
|-
| aray 2, selula 1
| aray 2, selula 2
| aray 2, selula 3',
	'wikieditor-toolbar-tool-table-example-cell-text' => 'Testo ti selula',
	'wikieditor-toolbar-tool-table-example-header' => 'Testo ti paulo',
	'wikieditor-toolbar-tool-table-title' => 'Isengngat ti tabla',
	'wikieditor-toolbar-tool-table-dimensions-rows' => 'Ar-aray',
	'wikieditor-toolbar-tool-table-dimensions-columns' => 'Binnatong',
	'wikieditor-toolbar-tool-table-dimensions-header' => 'Agnayon to paulo nga aray',
	'wikieditor-toolbar-tool-table-wikitable' => 'Estilo nga adda kadagiti pagbeddengan',
	'wikieditor-toolbar-tool-table-sortable' => 'Aramiden ti tabla tapno mabalin a mailasin',
	'wikieditor-toolbar-tool-table-example' => 'Kas pagarigan',
	'wikieditor-toolbar-tool-table-preview' => 'Ipadas',
	'wikieditor-toolbar-tool-table-insert' => 'Isengngat',
	'wikieditor-toolbar-tool-table-cancel' => 'Ukasen',
	'wikieditor-toolbar-tool-table-toomany' => 'Ti panagisengngat ti tabla nga adda ti adadu ngem $1 a selula ket saan a mabalin iti daytoy a pagsaritaan.',
	'wikieditor-toolbar-tool-table-invalidnumber' => 'Saan ka pay a nakaikabil ti umisu a numero iti ar-aray wenno binnatong.',
	'wikieditor-toolbar-tool-table-zero' => 'Saan mo a mabalin ti agisengngat ti tabla nga adda ti sero nga ar-aray wenno binnatong.',
	'wikieditor-toolbar-tool-replace' => 'Agbiruk ken sukatan',
	'wikieditor-toolbar-tool-replace-title' => 'Agbiruk ken sukatan',
	'wikieditor-toolbar-tool-replace-search' => 'Biruken iti:',
	'wikieditor-toolbar-tool-replace-replace' => 'Sukatan iti:',
	'wikieditor-toolbar-tool-replace-case' => 'Agpada a kaso',
	'wikieditor-toolbar-tool-replace-regex' => 'Tratuen ti biruken a kuerdas a kasla kadawyan a panangisao',
	'wikieditor-toolbar-tool-replace-button-findnext' => 'Sapulen ti sumaruno',
	'wikieditor-toolbar-tool-replace-button-replace' => 'Sukatan',
	'wikieditor-toolbar-tool-replace-button-replaceall' => 'Sukatan amin',
	'wikieditor-toolbar-tool-replace-close' => 'Irikep',
	'wikieditor-toolbar-tool-replace-nomatch' => 'Ti panagbirukmo ket awan ti napadana.',
	'wikieditor-toolbar-tool-replace-success' => '$1 ti naaramid a nasukatan.',
	'wikieditor-toolbar-tool-replace-emptysearch' => 'Awan ti inkabilmo  a biruken.',
	'wikieditor-toolbar-tool-replace-invalidregex' => 'Ti kadawyan a panangisao nga inkabilmo ket imbalido: $1',
	'wikieditor-toolbar-section-characters' => 'Dagiti naipangpangruna a karakter',
	'wikieditor-toolbar-characters-page-latin' => 'Latin',
	'wikieditor-toolbar-characters-page-latinextended' => 'Latin napaatiddog',
	'wikieditor-toolbar-characters-page-ipa' => 'IPA',
	'wikieditor-toolbar-characters-page-symbols' => 'Dagiti simbolo',
	'wikieditor-toolbar-characters-page-greek' => 'Griego',
	'wikieditor-toolbar-characters-page-cyrillic' => 'Siriliko',
	'wikieditor-toolbar-characters-page-arabic' => 'Arabiko',
	'wikieditor-toolbar-characters-page-arabicextended' => 'Arabiko a napaatiddog',
	'wikieditor-toolbar-characters-page-persian' => 'Persiano',
	'wikieditor-toolbar-characters-page-hebrew' => 'Hebreo',
	'wikieditor-toolbar-characters-page-bangla' => 'Bangla',
	'wikieditor-toolbar-characters-page-tamil' => 'Tamil',
	'wikieditor-toolbar-characters-page-telugu' => 'Telugu',
	'wikieditor-toolbar-characters-page-sinhala' => 'Sinhala',
	'wikieditor-toolbar-characters-page-gujarati' => 'Gujarati',
	'wikieditor-toolbar-characters-page-devanagari' => 'Devanagari',
	'wikieditor-toolbar-characters-page-thai' => 'Thai',
	'wikieditor-toolbar-characters-page-lao' => 'Lao',
	'wikieditor-toolbar-characters-page-khmer' => 'Khmer',
	'wikieditor-toolbar-section-help' => 'Tulong',
	'wikieditor-toolbar-help-heading-description' => 'Panagipalpalawag',
	'wikieditor-toolbar-help-heading-syntax' => 'Ti imakiniliam',
	'wikieditor-toolbar-help-heading-result' => 'Ti maalam',
	'wikieditor-toolbar-help-page-format' => 'Panagporma',
	'wikieditor-toolbar-help-page-link' => 'Dagiti panilpo',
	'wikieditor-toolbar-help-page-heading' => 'Dagiti paulo',
	'wikieditor-toolbar-help-page-list' => 'Dagiti listaan',
	'wikieditor-toolbar-help-page-file' => 'Dagiti papeles',
	'wikieditor-toolbar-help-page-reference' => 'Pinagibasaran',
	'wikieditor-toolbar-help-page-discussion' => 'Pagtungtongan',
	'wikieditor-toolbar-help-content-italic-description' => 'Naka-irig',
	'wikieditor-toolbar-help-content-italic-syntax' => "''Naka-irig a testo''",
	'wikieditor-toolbar-help-content-italic-result' => '<em>Naka-irig  a testo</em>',
	'wikieditor-toolbar-help-content-bold-description' => 'Napuskol',
	'wikieditor-toolbar-help-content-bold-syntax' => "'''Napuskol a testo'''",
	'wikieditor-toolbar-help-content-bold-result' => '<strong>Napuskol a testo</strong>',
	'wikieditor-toolbar-help-content-bolditalic-description' => 'Napuskol &amp; nakairig',
	'wikieditor-toolbar-help-content-bolditalic-syntax' => "'''''Napuskol &amp; nakairig a testo'''''",
	'wikieditor-toolbar-help-content-bolditalic-result' => '<strong><em>Napuskol &amp; nakairig a testo</em></strong>',
	'wikieditor-toolbar-help-content-ilink-description' => 'Akinuneg a panilpo',
	'wikieditor-toolbar-help-content-ilink-syntax' => '[[Titulo ti panid|Etiketa ti panilpo]]<br />[[Titulo ti panid]]',
	'wikieditor-toolbar-help-content-ilink-result' => "<a href='#'>Etiketa ti panilpo</a><br /><a href='#'>Titulo ti panid</a>",
	'wikieditor-toolbar-help-content-xlink-description' => 'Kasilpo iti ruar',
	'wikieditor-toolbar-help-content-xlink-syntax' => '[http://www.example.org Etiketa ti panilpo]<br />[http://www.example.org]<br />http://www.example.org',
	'wikieditor-toolbar-help-content-xlink-result' => "<a href='#' class='external'>Etiketa ti panilpo</a><br /><a href='#' class='external autonumber'>[1]</a><br /><a href='#' class='external'>http://www.example.org</a>",
	'wikieditor-toolbar-help-content-heading2-description' => 'Maika-2 nga agpang a paulo',
	'wikieditor-toolbar-help-content-heading2-syntax' => '== Testo ti paulo ==',
	'wikieditor-toolbar-help-content-heading2-result' => '<h2>Testo ti paulo</h2>',
	'wikieditor-toolbar-help-content-heading3-description' => 'Maika-3 nga agpang a paulo',
	'wikieditor-toolbar-help-content-heading3-syntax' => '=== Testo ti paulo ===',
	'wikieditor-toolbar-help-content-heading3-result' => '<h3>Testo ti paulo</h3>',
	'wikieditor-toolbar-help-content-heading4-description' => 'Maika-4 nga agpang a paulo',
	'wikieditor-toolbar-help-content-heading4-syntax' => '==== Testo ti paulo ====',
	'wikieditor-toolbar-help-content-heading4-result' => '<h4>Testo ti paulo</h4>',
	'wikieditor-toolbar-help-content-heading5-description' => 'Maika-5 nga agpang a paulo',
	'wikieditor-toolbar-help-content-heading5-syntax' => '===== Testo ti paulo =====',
	'wikieditor-toolbar-help-content-heading5-result' => '<h5>Testo ti paulo</h5>',
	'wikieditor-toolbar-help-content-ulist-description' => 'Punglo a listaan',
	'wikieditor-toolbar-help-content-ulist-syntax' => '* Ilista ti banag<br />* Ilista ti banag',
	'wikieditor-toolbar-help-content-ulist-result' => '<ul><li>Ilista ti banag</li><li>Ilista ti banag</li></ul>',
	'wikieditor-toolbar-help-content-olist-description' => 'Nabilangan a listaan',
	'wikieditor-toolbar-help-content-olist-syntax' => '# Ilista ti banag<br /># Ilista ti banag',
	'wikieditor-toolbar-help-content-olist-result' => '<ol><li>Ilista ti banag</li><li>Ilista ti banag</li></ol>',
	'wikieditor-toolbar-help-content-file-description' => 'Naisengngat a papeles',
	'wikieditor-toolbar-help-content-file-syntax' => '[[$1:Example.png|thumb|Naisurat a testo]]',
	'wikieditor-toolbar-help-content-file-result' => "<div style='width:104px;' class='thumbinner'><a title='Naisurat a testo' class='image' href='#'><img height='50' width='100' border='0' class='thumbimage' src='$2/WikiEditor/modules/images/toolbar/example-image.png' alt=''/></a><div class='thumbcaption'><div class='magnify'><a title='Padakkelen' class='internal' href='#'><img height='11' width='15' alt='' src='$1/common/images/magnify-clip.png'/></a></div>Naisurat a testo</div></div>",
	'wikieditor-toolbar-help-content-reference-description' => 'Pinagibasaran',
	'wikieditor-toolbar-help-content-reference-syntax' => 'Testo ti panid.&lt;ref name="test"&gt;[http://www.example.org Testo ti panilpo], nainayon a testo.&lt;/ref&gt;',
	'wikieditor-toolbar-help-content-reference-result' => "Testo ti panid.<sup><a href='#'>[1]</a></sup>",
	'wikieditor-toolbar-help-content-rereference-description' => 'Nainayon a panagusar ti kapada a pinagibasaran',
	'wikieditor-toolbar-help-content-rereference-result' => "Testo ti panid.<sup><a href='#'>[1]</a></sup>",
	'wikieditor-toolbar-help-content-showreferences-description' => 'Iparang dagiti pinagibasaran',
	'wikieditor-toolbar-help-content-showreferences-result' => "<ol class='references'><li id='cite_note-test-0'><b><a title='' href='#'>^</a></b> <a rel='nofollow' title='http://www.example.org' class='external text' href='#'>Testo ti panilpo</a>, nainayon a testo.</li></ol>",
	'wikieditor-toolbar-help-content-signaturetimestamp-description' => 'Ti pirmam nga addan ti oras ken petsa',
	'wikieditor-toolbar-help-content-signaturetimestamp-result' => "<a href='#' title='{{#special:mypage}}'>Nagan ti agar-aramat</a> (<a href='#' title='{{#special:mytalk}}'>tungtungan</a>) 15:54, 10 Hunio 2009 (UTC)",
	'wikieditor-toolbar-help-content-signature-description' => 'Pirma',
	'wikieditor-toolbar-help-content-signature-result' => "<a href='#' title='{{#special:mypage}}'>Nagan ti agar-aramat</a> (<a href='#' title='{{#special:mytalk}}'>tungtungan</a>)",
	'wikieditor-toolbar-help-content-indent-description' => 'Lennekan',
	'wikieditor-toolbar-help-content-indent-syntax' => 'Kadawyan a testo<br />:Nalennekan a testo<br />::Nalennekan a testo',
	'wikieditor-toolbar-help-content-indent-result' => 'Kadawyan a testo<dl><dd>Nalennekan a testo<dl><dd>Nalennekan a testo</dd></dl></dd></dl>',
);

/** Ingush (ГӀалгӀай)
 * @author Amire80
 * @author Sapral Mikail
 */
$messages['inh'] = array(
	'wikieditor-toolbar-characters-page-latin' => 'Лаьтмий',
	'wikieditor-toolbar-characters-page-greek' => 'Джелтий',
	'wikieditor-toolbar-characters-page-cyrillic' => 'Цырилиций',
	'wikieditor-toolbar-characters-page-arabic' => 'Ӏарбий',
	'wikieditor-toolbar-characters-page-persian' => 'Фаьранзий',
	'wikieditor-toolbar-characters-page-hebrew' => 'Жугтий',
);

/** Ido (Ido)
 * @author Malafaya
 */
$messages['io'] = array(
	'wikieditor-preview-changes-tab' => 'Chanji',
	'wikieditor-publish-button-cancel' => 'Anular',
	'wikieditor-publish-dialog-minor' => 'Mikra chanjo',
	'wikieditor-publish-dialog-watch' => 'Surveyar ca pagino',
	'wikieditor-publish-dialog-goback' => 'Retroirar',
	'wikieditor-template-editor-dialog-submit' => 'Aktualigar',
	'wikieditor-template-editor-dialog-cancel' => 'Anular',
	'wikieditor-toolbar-tool-italic' => 'Kursiva',
	'wikieditor-toolbar-tool-italic-example' => 'Kursiva texto',
	'wikieditor-toolbar-tool-ilink' => 'Interna ligilo',
	'wikieditor-toolbar-tool-ilink-example' => 'Titulo dil ligilo',
	'wikieditor-toolbar-tool-xlink' => 'Extera ligilo (memorez la http://-prefixo)',
	'wikieditor-toolbar-tool-xlink-example' => 'http://www.example.com titulo dil ligilo',
	'wikieditor-toolbar-tool-link' => 'Ligilo',
	'wikieditor-toolbar-tool-link-title' => 'Adjuntar ligilo',
	'wikieditor-toolbar-tool-link-int' => 'A wiki-pagino',
	'wikieditor-toolbar-tool-link-insert' => 'Adjuntar ligilo',
	'wikieditor-toolbar-tool-link-cancel' => 'Anular',
	'wikieditor-toolbar-tool-link-int-target-status-exists' => 'La pagino existas',
	'wikieditor-toolbar-tool-link-int-target-status-notexists' => 'La pagino ne existas',
	'wikieditor-toolbar-tool-link-int-target-status-invalid' => 'Ne-valida titulo',
	'wikieditor-toolbar-tool-link-lookslikeinternal-int' => 'Interna ligilo',
	'wikieditor-toolbar-tool-link-lookslikeinternal-ext' => 'Extera ligilo',
	'wikieditor-toolbar-tool-file-example' => 'Exemplo.jpg',
	'wikieditor-toolbar-tool-reference-insert' => 'Adjuntar',
	'wikieditor-toolbar-tool-heading-1' => 'Nivelo 1',
	'wikieditor-toolbar-tool-heading-2' => 'Nivelo 2',
	'wikieditor-toolbar-tool-heading-3' => 'Nivelo 3',
	'wikieditor-toolbar-tool-heading-4' => 'Nivelo 4',
	'wikieditor-toolbar-tool-heading-5' => 'Nivelo 5',
	'wikieditor-toolbar-group-format' => 'Listo',
	'wikieditor-toolbar-tool-big' => 'Granda',
	'wikieditor-toolbar-tool-big-example' => 'Granda texto',
	'wikieditor-toolbar-tool-small' => 'Mikra',
	'wikieditor-toolbar-tool-small-example' => 'Mikra texto',
	'wikieditor-toolbar-tool-newline' => 'Nova lineo',
	'wikieditor-toolbar-tool-table' => 'Tabelo',
	'wikieditor-toolbar-tool-table-title' => 'Adjuntar tabelo',
	'wikieditor-toolbar-tool-table-dimensions-rows' => 'Linei',
	'wikieditor-toolbar-tool-table-dimensions-columns' => 'Kolumni',
	'wikieditor-toolbar-tool-table-example' => 'Exemplo',
	'wikieditor-toolbar-tool-table-preview' => 'Previdar',
	'wikieditor-toolbar-tool-table-insert' => 'Adjuntar',
	'wikieditor-toolbar-tool-table-cancel' => 'Anular',
	'wikieditor-toolbar-tool-replace-search' => 'Serchar:',
	'wikieditor-toolbar-tool-replace-close' => 'Klozar',
	'wikieditor-toolbar-tool-replace-success' => '$1 remplasigo(i) facita.',
	'wikieditor-toolbar-characters-page-latin' => 'Latina',
	'wikieditor-toolbar-characters-page-latinextended' => 'Latina extensita',
	'wikieditor-toolbar-characters-page-symbols' => 'Simboli',
	'wikieditor-toolbar-characters-page-greek' => 'Grekiana',
	'wikieditor-toolbar-characters-page-cyrillic' => 'Kirila',
	'wikieditor-toolbar-characters-page-arabic' => 'Arabiana',
	'wikieditor-toolbar-characters-page-persian' => 'Persiana',
	'wikieditor-toolbar-section-help' => 'Helpo',
	'wikieditor-toolbar-help-page-link' => 'Ligili',
	'wikieditor-toolbar-help-page-list' => 'Listi',
	'wikieditor-toolbar-help-page-file' => 'Arkivi',
	'wikieditor-toolbar-help-content-ilink-description' => 'Interna ligilo',
	'wikieditor-toolbar-help-content-xlink-description' => 'Extera ligilo',
	'wikieditor-toolbar-help-content-signature-description' => 'Signaturo',
);

/** Icelandic (íslenska)
 * @author Krun
 * @author Maxí
 * @author Snævar
 */
$messages['is'] = array(
	'wikieditor-wikitext-tab' => 'Wiki-texti',
	'wikieditor-loading' => 'Hleður...',
	'wikieditor-preview-preference' => 'Virkja forskoðun á samanburði síðna',
	'wikieditor-preview-tab' => 'Forskoða',
	'wikieditor-preview-changes-tab' => 'Breytingar',
	'wikieditor-preview-loading' => 'Hleð...',
	'wikieditor-previewDialog-preference' => 'Virkja forskoðunar valmynd',
	'wikieditor-previewDialog-tab' => 'Forskoða',
	'wikieditor-previewDialog-loading' => 'Hleð...',
	'wikieditor-publish-preference' => 'Virkja skref-eftir-skref útgáfu',
	'wikieditor-publish-button-publish' => 'Útgefa',
	'wikieditor-publish-button-cancel' => 'Hætta við',
	'wikieditor-publish-dialog-title' => 'Útgefa á {{SITENAME}}',
	'wikieditor-publish-dialog-summary' => 'Breytingarágrip (lýstu stuttlega þeim breytingum sem þú hefur gert):',
	'wikieditor-publish-dialog-minor' => 'Minniháttar breyting',
	'wikieditor-publish-dialog-watch' => 'Vakta þessa síðu',
	'wikieditor-publish-dialog-publish' => 'Útgefa',
	'wikieditor-publish-dialog-goback' => 'Fara til baka',
	'wikieditor-template-editor-preference' => 'Virkja eyðublaðs-stíl við breytingar á wiki sniðum',
	'wikieditor-template-editor-dialog-title' => 'Breyta sniði',
	'wikieditor-template-editor-dialog-submit' => 'Uppfæra',
	'wikieditor-template-editor-dialog-cancel' => 'Hætta við',
	'wikieditor-templates-preference' => 'Virkja fellilista í sniðum',
	'wikieditor-toc-preference' => 'Virkja valmynd fyrir efniskrá',
	'wikieditor-toc-show' => 'Sýna efnisyfirlit',
	'wikieditor-toc-hide' => 'Fela efnisyfirlit',
	'wikieditor-toolbar' => 'Breytingarstika',
	'wikieditor-toolbar-desc' => 'Breytingarstika með auknu notagildi',
	'wikieditor-toolbar-dialogs-preference' => 'Virkja valmynd fyrir innsetningu tengla, taflna og fleira',
	'wikieditor-toolbar-hidesig' => 'Fela undirskriftar hnappinn á síðum í aðalnafnrými',
	'wikieditor-toolbar-loading' => 'Hleð...',
	'wikieditor-toolbar-tool-bold' => 'Feitletrað',
	'wikieditor-toolbar-tool-bold-example' => 'Feitletraður texti',
	'wikieditor-toolbar-tool-italic' => 'Skáletrað',
	'wikieditor-toolbar-tool-italic-example' => 'Skáletraður texti',
	'wikieditor-toolbar-tool-ilink' => 'Innri tengill',
	'wikieditor-toolbar-tool-ilink-example' => 'Titill tengils',
	'wikieditor-toolbar-tool-xlink' => 'Ytri tengill (munið að setja http:// á undan)',
	'wikieditor-toolbar-tool-xlink-example' => 'http://www.example.com titill tengils',
	'wikieditor-toolbar-tool-link' => 'Tengill',
	'wikieditor-toolbar-tool-link-title' => 'Setja inn tengil',
	'wikieditor-toolbar-tool-link-int' => 'Í wiki-síðu',
	'wikieditor-toolbar-tool-link-int-target' => 'Síða sem tengja á í, eða vefslóð',
	'wikieditor-toolbar-tool-link-int-target-tooltip' => 'Titill síðu eða vefslóð',
	'wikieditor-toolbar-tool-link-int-text' => 'Texti til birtingar:',
	'wikieditor-toolbar-tool-link-int-text-tooltip' => 'Texti sem á að birta',
	'wikieditor-toolbar-tool-link-ext' => 'Í ytri vefsíðu',
	'wikieditor-toolbar-tool-link-ext-target' => 'Vefslóð tengils:',
	'wikieditor-toolbar-tool-link-ext-text' => 'Texti tengils:',
	'wikieditor-toolbar-tool-link-insert' => 'Settu inn tengil',
	'wikieditor-toolbar-tool-link-cancel' => 'Hætta við',
	'wikieditor-toolbar-tool-link-int-target-status-exists' => 'Síðan er til',
	'wikieditor-toolbar-tool-link-int-target-status-notexists' => 'Síðan er ekki til',
	'wikieditor-toolbar-tool-link-int-target-status-invalid' => 'Ógildur titill',
	'wikieditor-toolbar-tool-link-int-target-status-external' => 'Ytri tengill',
	'wikieditor-toolbar-tool-link-int-target-status-loading' => 'Athuga hvort síðan sé til...',
	'wikieditor-toolbar-tool-link-int-invalid' => 'Titillinn sem þú gafst upp er ógildur.',
	'wikieditor-toolbar-tool-link-lookslikeinternal' => 'Slóðin sem þú gafst upp lítur út eins og hún hafi verið ætluð til að tengja í aðra wiki-síðu.
Viltu gera hana að innri tengli?',
	'wikieditor-toolbar-tool-link-lookslikeinternal-int' => 'Innri tengill',
	'wikieditor-toolbar-tool-link-lookslikeinternal-ext' => 'Ytri tengill',
	'wikieditor-toolbar-tool-link-empty' => 'Þú slóst ekki inn neitt til að tengja í.',
	'wikieditor-toolbar-tool-file' => 'Bæta við mynd',
	'wikieditor-toolbar-tool-file-example' => 'Sýnishorn.jpg',
	'wikieditor-toolbar-tool-file-title' => 'Setja inn skrá',
	'wikieditor-toolbar-file-target' => 'Skráarnafn:',
	'wikieditor-toolbar-file-caption' => 'Myndlýsing:',
	'wikieditor-toolbar-file-size' => 'Stærð:',
	'wikieditor-toolbar-file-float' => 'Jöfnun:',
	'wikieditor-toolbar-file-default' => '(sjálfgefið)',
	'wikieditor-toolbar-file-format' => 'Snið:',
	'wikieditor-toolbar-tool-file-insert' => 'Setja inn',
	'wikieditor-toolbar-tool-file-cancel' => 'Hætta við',
	'wikieditor-toolbar-tool-reference' => 'Tilvísanir',
	'wikieditor-toolbar-tool-reference-example' => 'Settu tilvísunina hér',
	'wikieditor-toolbar-tool-reference-cancel' => 'Hætta við',
	'wikieditor-toolbar-tool-reference-title' => 'Setja inn tilvísun',
	'wikieditor-toolbar-tool-reference-insert' => 'Setja inn',
	'wikieditor-toolbar-tool-reference-text' => 'Tilvísunar texti',
	'wikieditor-toolbar-tool-signature' => 'Undirskrift og tímasetning',
	'wikieditor-toolbar-section-advanced' => 'Ítarlegt',
	'wikieditor-toolbar-tool-heading' => 'Fyrirsagnir',
	'wikieditor-toolbar-tool-heading-1' => '1 stig',
	'wikieditor-toolbar-tool-heading-2' => '2 stig',
	'wikieditor-toolbar-tool-heading-3' => '3 stig',
	'wikieditor-toolbar-tool-heading-4' => '4 stig',
	'wikieditor-toolbar-tool-heading-5' => '5 stig',
	'wikieditor-toolbar-tool-heading-example' => 'Fyrirsagnartexti',
	'wikieditor-toolbar-group-format' => 'Útlitsmótun',
	'wikieditor-toolbar-tool-ulist' => 'Punktalisti',
	'wikieditor-toolbar-tool-ulist-example' => 'Atriði í punktalista',
	'wikieditor-toolbar-tool-olist' => 'Tölusettur listi',
	'wikieditor-toolbar-tool-olist-example' => 'Tölusett atriði',
	'wikieditor-toolbar-tool-indent' => 'Inndráttur',
	'wikieditor-toolbar-tool-indent-example' => 'Inndregin lína',
	'wikieditor-toolbar-tool-nowiki' => 'Engin wiki stílviðmið',
	'wikieditor-toolbar-tool-nowiki-example' => 'Setjið inn ósniðinn texta hér',
	'wikieditor-toolbar-tool-redirect' => 'Tilvísun',
	'wikieditor-toolbar-tool-redirect-example' => 'Nafn síðu sem tilvísunin beinist að',
	'wikieditor-toolbar-tool-big' => 'Stór',
	'wikieditor-toolbar-tool-big-example' => 'Stór texti',
	'wikieditor-toolbar-tool-small' => 'Lítill',
	'wikieditor-toolbar-tool-small-example' => 'Lítill texti',
	'wikieditor-toolbar-tool-superscript' => 'Yfirskrift',
	'wikieditor-toolbar-tool-superscript-example' => 'texti í yfirskrift',
	'wikieditor-toolbar-tool-subscript' => 'Niðurskrift',
	'wikieditor-toolbar-tool-subscript-example' => 'texti í niðurskrift',
	'wikieditor-toolbar-group-insert' => 'Setja inn',
	'wikieditor-toolbar-tool-gallery' => 'Mynda safn',
	'wikieditor-toolbar-tool-gallery-example' => '$1:Example.jpg|Myndlýsing1
$1:Example.jpg|Myndlýsing2',
	'wikieditor-toolbar-tool-newline' => 'Ný lína',
	'wikieditor-toolbar-tool-table' => 'Töflu',
	'wikieditor-toolbar-tool-table-example-old' => '-
! titill 1
! titill 2
! titill 3
|-
| röð 1, reitur 1
| röð 1, reitur 2
| röð 1, reitur 3
| -
| röð 2, reitur 1
| röð 2, reitur 2
| röð 2, reitur 3',
	'wikieditor-toolbar-tool-table-example-cell-text' => 'Texti reitar',
	'wikieditor-toolbar-tool-table-example-header' => 'Texti raðar',
	'wikieditor-toolbar-tool-table-title' => 'Setja inn töflu',
	'wikieditor-toolbar-tool-table-dimensions-rows' => 'Raðir',
	'wikieditor-toolbar-tool-table-dimensions-columns' => 'Dálkar',
	'wikieditor-toolbar-tool-table-dimensions-header' => 'Bæta titilröð við',
	'wikieditor-toolbar-tool-table-wikitable' => 'Móta með jöðrum',
	'wikieditor-toolbar-tool-table-sortable' => 'Gera töfluna raðanlega',
	'wikieditor-toolbar-tool-table-example' => 'Útlit',
	'wikieditor-toolbar-tool-table-preview' => 'Forskoðun',
	'wikieditor-toolbar-tool-table-insert' => 'Setja inn',
	'wikieditor-toolbar-tool-table-cancel' => 'Hætta við',
	'wikieditor-toolbar-tool-table-toomany' => 'Ekki er hægt að búa til töflu með fleiri en $1 reiti með þessari valmynd.',
	'wikieditor-toolbar-tool-table-invalidnumber' => 'Ógildur fjöldi raða eða reita.',
	'wikieditor-toolbar-tool-table-zero' => 'Taflan getur ekki innihaldið núll raðir eða reiti.',
	'wikieditor-toolbar-tool-replace' => 'Leita og skipta út',
	'wikieditor-toolbar-tool-replace-title' => 'Leita og skipta út',
	'wikieditor-toolbar-tool-replace-search' => 'Leitarstrengur:',
	'wikieditor-toolbar-tool-replace-replace' => 'Skipta út fyrir:',
	'wikieditor-toolbar-tool-replace-case' => 'Sama stafsetur',
	'wikieditor-toolbar-tool-replace-regex' => 'Meðhöndla leitarorð sem reglulega segð',
	'wikieditor-toolbar-tool-replace-button-findnext' => 'Finna næstu',
	'wikieditor-toolbar-tool-replace-button-replace' => 'Skipta út',
	'wikieditor-toolbar-tool-replace-button-replaceall' => 'Skipta út öllum',
	'wikieditor-toolbar-tool-replace-close' => 'Loka',
	'wikieditor-toolbar-tool-replace-nomatch' => 'Engar niðurstöður fundust.',
	'wikieditor-toolbar-tool-replace-success' => '$1 útskiptingar gerðar.',
	'wikieditor-toolbar-tool-replace-emptysearch' => 'Þú slóst ekki inn neitt til að leita að.',
	'wikieditor-toolbar-tool-replace-invalidregex' => 'Ógild regluleg segð: $1',
	'wikieditor-toolbar-section-characters' => 'Sérstafir',
	'wikieditor-toolbar-characters-page-latin' => 'Latneskt',
	'wikieditor-toolbar-characters-page-latinextended' => 'Aukið latneskt',
	'wikieditor-toolbar-characters-page-ipa' => 'IPA',
	'wikieditor-toolbar-characters-page-symbols' => 'Tákn',
	'wikieditor-toolbar-characters-page-greek' => 'Grískt',
	'wikieditor-toolbar-characters-page-cyrillic' => 'Kýrillískt',
	'wikieditor-toolbar-characters-page-arabic' => 'Arabískt',
	'wikieditor-toolbar-characters-page-arabicextended' => 'Aukið arabískt',
	'wikieditor-toolbar-characters-page-persian' => 'Persneskt',
	'wikieditor-toolbar-characters-page-hebrew' => 'Hebreskt',
	'wikieditor-toolbar-characters-page-bangla' => 'Bengalskt',
	'wikieditor-toolbar-characters-page-tamil' => 'Tamílska',
	'wikieditor-toolbar-characters-page-telugu' => 'Telúgú',
	'wikieditor-toolbar-characters-page-sinhala' => 'Sinhalskt',
	'wikieditor-toolbar-characters-page-devanagari' => 'Devanagari',
	'wikieditor-toolbar-characters-page-thai' => 'Taílenskt',
	'wikieditor-toolbar-characters-page-lao' => 'Laoskt',
	'wikieditor-toolbar-section-help' => 'Hjálp',
	'wikieditor-toolbar-help-heading-description' => 'Lýsing',
	'wikieditor-toolbar-help-heading-syntax' => 'Það sem þú skrifar',
	'wikieditor-toolbar-help-heading-result' => 'Það sem kemur út',
	'wikieditor-toolbar-help-page-format' => 'Stílviðmið',
	'wikieditor-toolbar-help-page-link' => 'Tenglar',
	'wikieditor-toolbar-help-page-heading' => 'Fyrirsagnir',
	'wikieditor-toolbar-help-page-list' => 'Listar',
	'wikieditor-toolbar-help-page-file' => 'Myndir',
	'wikieditor-toolbar-help-page-reference' => 'Heimildir',
	'wikieditor-toolbar-help-page-discussion' => 'Umræða',
	'wikieditor-toolbar-help-content-italic-description' => 'Skáletrað',
	'wikieditor-toolbar-help-content-italic-syntax' => "''Skáletraður texti''",
	'wikieditor-toolbar-help-content-italic-result' => '<em>Skáletraður texti</em>',
	'wikieditor-toolbar-help-content-bold-description' => 'Feitletrað',
	'wikieditor-toolbar-help-content-bold-syntax' => "'''Feitletraður texti'''",
	'wikieditor-toolbar-help-content-bold-result' => '<strong>Feitletraður texti</strong>',
	'wikieditor-toolbar-help-content-bolditalic-description' => 'Feit- og skáletrað',
	'wikieditor-toolbar-help-content-bolditalic-syntax' => "'''''Feit- og skáletraður texti'''''",
	'wikieditor-toolbar-help-content-bolditalic-result' => '<em><strong>Feit- og skáletraður texti</strong></em>',
	'wikieditor-toolbar-help-content-ilink-description' => 'Innri tengill',
	'wikieditor-toolbar-help-content-ilink-syntax' => '[[Síðuheiti|Tengiltexti]] <br /> [[Síðuheiti]]',
	'wikieditor-toolbar-help-content-ilink-result' => "<a href='#'>Tengiltexti</a> <br /> <a href='#'>Síðuheiti</a>",
	'wikieditor-toolbar-help-content-xlink-description' => 'Ytri tengill',
	'wikieditor-toolbar-help-content-xlink-syntax' => '[http://www.example.org Tengiltexti]<br />[http://www.example.org]<br />http://www.example.org',
	'wikieditor-toolbar-help-content-xlink-result' => "<a href='#' class='external'>Tengiltexti</a> <br /> <a href='#' class='external autonumber'>[1]</a> <br /> <a href='#' class='external'>http://www.example.org</a>",
	'wikieditor-toolbar-help-content-heading2-description' => '2. stigs fyrirsögn',
	'wikieditor-toolbar-help-content-heading2-syntax' => '== Fyrirsögn ==',
	'wikieditor-toolbar-help-content-heading2-result' => '<h2>Fyrirsögn</h2>',
	'wikieditor-toolbar-help-content-heading3-description' => '3. stigs fyrirsögn',
	'wikieditor-toolbar-help-content-heading3-syntax' => '=== Fyrirsögn ===',
	'wikieditor-toolbar-help-content-heading3-result' => '<h3>Fyrirsögn</h3>',
	'wikieditor-toolbar-help-content-heading4-description' => '4. stigs fyrirsögn',
	'wikieditor-toolbar-help-content-heading4-syntax' => '==== Fyrirsögn ====',
	'wikieditor-toolbar-help-content-heading4-result' => '<h4>Fyrirsögn</h4>',
	'wikieditor-toolbar-help-content-heading5-description' => '5. stigs fyrirsögn',
	'wikieditor-toolbar-help-content-heading5-syntax' => '===== Fyrirsögn =====',
	'wikieditor-toolbar-help-content-heading5-result' => '<h5>Fyrirsögn</h5>',
	'wikieditor-toolbar-help-content-ulist-description' => 'Punktalisti',
	'wikieditor-toolbar-help-content-ulist-syntax' => '* Lista atriði<br />* Lista atriði',
	'wikieditor-toolbar-help-content-ulist-result' => '<ul><li>Lista atriði</li><li>Lista atriði</li></ul>',
	'wikieditor-toolbar-help-content-olist-description' => 'Tölusettur listi',
	'wikieditor-toolbar-help-content-olist-syntax' => '# Lista atriði<br /># Lista atriði',
	'wikieditor-toolbar-help-content-olist-result' => '<ol><li>Lista atriði</li><li>Lista atriði</li></ol>',
	'wikieditor-toolbar-help-content-file-description' => 'Bæta við mynd',
	'wikieditor-toolbar-help-content-file-syntax' => '[[$1:Example.png|thumb|Myndlýsing]]',
	'wikieditor-toolbar-help-content-file-result' => "<div style='width:104px;' class='thumbinner'><a title='Myndlýsing' class='image' href='#'><img height='50' width='100' border='0' class='thumbimage' src='$2/WikiEditor/modules/images/toolbar/example-image.png' alt=''/></a><div class='thumbcaption'><div class='magnify'><a title='Stækka' class='internal' href='#'><img height='11' width='15' alt='' src='$1/common/images/magnify-clip.png'/></a></div>Myndlýsing</div></div>",
	'wikieditor-toolbar-help-content-reference-description' => 'Tilvísun',
	'wikieditor-toolbar-help-content-reference-syntax' => 'Texti síðu.&lt;ref name="test"&gt;[http://www.example.org Titill síðu], Skoðað 1. janúar 2010.&lt;/ref&gt;',
	'wikieditor-toolbar-help-content-reference-result' => "Texti síðu.<sup><a href='#'>[1]</a></sup>",
	'wikieditor-toolbar-help-content-rereference-description' => 'Áframhaldandi notkun á sömu tilvísun',
	'wikieditor-toolbar-help-content-rereference-result' => "Texti síðu.<sup><a href='#'>[1]</a></sup>",
	'wikieditor-toolbar-help-content-showreferences-description' => 'Sýna tilvísanir',
	'wikieditor-toolbar-help-content-showreferences-result' => "<ol class='references'><li id='cite_note-test-0'><b><a title='' href='#'>^</a></b> <a rel='nofollow' title='http://www.example.org' class='external text' href='#'>Texti tengils</a>, viðbótar texti.</li></ol>",
	'wikieditor-toolbar-help-content-signaturetimestamp-description' => 'Undirskrift þín auk tímasetningar',
	'wikieditor-toolbar-help-content-signaturetimestamp-result' => "<a href='#' title='{{#special:mypage}}'>Notendanafn</a> (<a href='#' title='{{#special:mytalk}}'>spjall</a>) 15:54, 10. Júní 2009 (UTC)",
	'wikieditor-toolbar-help-content-signature-description' => 'Undirskrift',
	'wikieditor-toolbar-help-content-signature-result' => "<a href='#' title='{{#special:mypage}}'>Notendanafn</a> (<a href='#' title='{{#special:mytalk}}'>spjall</a>)",
	'wikieditor-toolbar-help-content-indent-description' => 'Inndráttur',
	'wikieditor-toolbar-help-content-indent-syntax' => 'Venjulegur texti<br />:Inndreginn texti<br />::Inndreginn texti',
	'wikieditor-toolbar-help-content-indent-result' => 'Venjulegur texti<dl><dd>Inndreginn texti<dl><dd>Inndreginn texti</dd></dl></dd></dl>',
);

/** Italian (italiano)
 * @author Aushulz
 * @author Beta16
 * @author Darth Kule
 * @author F. Cosoleto
 * @author Gianfranco
 * @author Gliu
 * @author McDutchie
 * @author Nemo bis
 * @author PaoloRomano
 * @author Una giornata uggiosa '94
 * @author Vituzzu
 */
$messages['it'] = array(
	'wikieditor' => 'Interfaccia avanzata di modifica del wikitesto',
	'wikieditor-desc' => "Fornisce un'interfaccia di modifica del wikitesto estensibile e molti moduli che forniscono altre funzionalità",
	'wikieditor-wikitext-tab' => 'Wikitesto',
	'wikieditor-loading' => 'Caricamento',
	'wikieditor-preview-preference' => 'Abilita anteprima laterale',
	'wikieditor-preview-tab' => 'Anteprima',
	'wikieditor-preview-changes-tab' => 'Modifiche',
	'wikieditor-preview-loading' => 'Caricamento in corso...',
	'wikieditor-previewDialog-preference' => 'Abilita la finestra di dialogo di anteprima',
	'wikieditor-previewDialog-tab' => 'Anteprima',
	'wikieditor-previewDialog-loading' => 'Caricamento in corso...',
	'wikieditor-publish-preference' => 'Abilita pubblicazione passo dopo passo',
	'wikieditor-publish-button-publish' => 'Pubblica',
	'wikieditor-publish-button-cancel' => 'Annulla',
	'wikieditor-publish-dialog-title' => 'Pubblica su {{SITENAME}}',
	'wikieditor-publish-dialog-summary' => 'Oggetto (descrivi brevemente le modifiche che hai fatto):',
	'wikieditor-publish-dialog-minor' => 'Modifica di minore importanza',
	'wikieditor-publish-dialog-watch' => 'Osserva questa pagina',
	'wikieditor-publish-dialog-publish' => 'Pubblica',
	'wikieditor-publish-dialog-goback' => 'Indietro',
	'wikieditor-template-editor-preference' => 'Abilita la modifica dei template attraverso moduli',
	'wikieditor-template-editor-dialog-title' => 'Modifica template',
	'wikieditor-template-editor-dialog-submit' => 'Aggiorna',
	'wikieditor-template-editor-dialog-cancel' => 'Annulla',
	'wikieditor-templates-preference' => 'Abilita la funzione per nascondere i template',
	'wikieditor-toc-preference' => 'Abilita indice navigabile',
	'wikieditor-toc-show' => 'Mostra i contenuti',
	'wikieditor-toc-hide' => 'Nascondi i contenuti',
	'wikieditor-toolbar' => 'Barra degli strumenti di modifica',
	'wikieditor-toolbar-desc' => 'Barra degli strumenti di modifica della pagina con migliorata usabilità',
	'wikieditor-toolbar-preference' => 'Abilita barra degli strumenti di modifica avanzata',
	'wikieditor-toolbar-dialogs-preference' => "Abilita le finestre per l'inserimento di link, tabelle ed altro",
	'wikieditor-toolbar-hidesig' => 'Nasconde il pulsante della firma dalle pagine nel namespace principale',
	'wikieditor-toolbar-loading' => 'Caricamento in corso...',
	'wikieditor-toolbar-tool-bold' => 'Grassetto',
	'wikieditor-toolbar-tool-bold-example' => 'Testo in grassetto',
	'wikieditor-toolbar-tool-italic' => 'Corsivo',
	'wikieditor-toolbar-tool-italic-example' => 'Testo in corsivo',
	'wikieditor-toolbar-tool-ilink' => 'Collegamento interno',
	'wikieditor-toolbar-tool-ilink-example' => 'Titolo del collegamento',
	'wikieditor-toolbar-tool-xlink' => 'Collegamento esterno (ricorda il prefisso http:// )',
	'wikieditor-toolbar-tool-xlink-example' => 'http://www.example.com titolo del collegamento',
	'wikieditor-toolbar-tool-link' => 'Collegamento',
	'wikieditor-toolbar-tool-link-title' => 'Inserisci link',
	'wikieditor-toolbar-tool-link-int' => 'A una pagina wiki',
	'wikieditor-toolbar-tool-link-int-target' => 'Titolo della pagina:',
	'wikieditor-toolbar-tool-link-int-target-tooltip' => 'Titolo della pagina o URL',
	'wikieditor-toolbar-tool-link-int-text' => 'Testo del link:',
	'wikieditor-toolbar-tool-link-int-text-tooltip' => 'Inserisci il testo da visualizzare',
	'wikieditor-toolbar-tool-link-ext' => 'A una pagina di un sito web esterno',
	'wikieditor-toolbar-tool-link-ext-target' => 'URL del link:',
	'wikieditor-toolbar-tool-link-ext-text' => 'Testo del link:',
	'wikieditor-toolbar-tool-link-insert' => 'Inserisci link',
	'wikieditor-toolbar-tool-link-cancel' => 'Annulla',
	'wikieditor-toolbar-tool-link-int-target-status-exists' => 'Pagina esistente',
	'wikieditor-toolbar-tool-link-int-target-status-notexists' => 'Pagina inesistente',
	'wikieditor-toolbar-tool-link-int-target-status-invalid' => 'Titolo non valido',
	'wikieditor-toolbar-tool-link-int-target-status-external' => 'Collegamento esterno',
	'wikieditor-toolbar-tool-link-int-target-status-loading' => "Controllo dell'esistenza della pagina in corso....",
	'wikieditor-toolbar-tool-link-int-invalid' => 'Il titolo che hai specificato non è valido.',
	'wikieditor-toolbar-tool-link-lookslikeinternal' => "La URL che hai indicato sembra un link verso un'altra pagina wiki.
Vuoi che sia un link interno?",
	'wikieditor-toolbar-tool-link-lookslikeinternal-int' => 'Link interno',
	'wikieditor-toolbar-tool-link-lookslikeinternal-ext' => 'Collegamento esterno',
	'wikieditor-toolbar-tool-link-empty' => 'Non hai indicato la destinazione del collegamento.',
	'wikieditor-toolbar-tool-file' => 'File incorporato',
	'wikieditor-toolbar-tool-file-example' => 'Esempio.jpg',
	'wikieditor-toolbar-tool-file-title' => 'Inserisci file',
	'wikieditor-toolbar-file-target' => 'Nome file:',
	'wikieditor-toolbar-file-caption' => 'Didascalia:',
	'wikieditor-toolbar-file-size' => 'Dimensione:',
	'wikieditor-toolbar-file-float' => 'Allineamento:',
	'wikieditor-toolbar-file-default' => '(predefinito)',
	'wikieditor-toolbar-file-format' => 'Formato:',
	'wikieditor-toolbar-file-format-none' => 'nessuno',
	'wikieditor-toolbar-tool-file-insert' => 'Inserisci',
	'wikieditor-toolbar-tool-file-cancel' => 'Annulla',
	'wikieditor-toolbar-tool-reference' => 'Nota',
	'wikieditor-toolbar-tool-reference-example' => 'Inserire qui il testo della nota',
	'wikieditor-toolbar-tool-reference-cancel' => 'Annulla',
	'wikieditor-toolbar-tool-reference-title' => 'Inserisci nota',
	'wikieditor-toolbar-tool-reference-insert' => 'Inserisci',
	'wikieditor-toolbar-tool-reference-text' => 'Testo della nota',
	'wikieditor-toolbar-tool-signature' => 'Firma e data',
	'wikieditor-toolbar-section-advanced' => 'Avanzate',
	'wikieditor-toolbar-tool-heading' => 'Intestazione',
	'wikieditor-toolbar-tool-heading-1' => 'Livello 1',
	'wikieditor-toolbar-tool-heading-2' => 'Livello 2',
	'wikieditor-toolbar-tool-heading-3' => 'Livello 3',
	'wikieditor-toolbar-tool-heading-4' => 'Livello 4',
	'wikieditor-toolbar-tool-heading-5' => 'Livello 5',
	'wikieditor-toolbar-tool-heading-example' => 'Titolo sezione',
	'wikieditor-toolbar-group-format' => 'Formato',
	'wikieditor-toolbar-tool-ulist' => 'Elenco puntato',
	'wikieditor-toolbar-tool-ulist-example' => "Elemento dell'elenco puntato",
	'wikieditor-toolbar-tool-olist' => 'Elenco numerato',
	'wikieditor-toolbar-tool-olist-example' => "Elemento dell'elenco numerato",
	'wikieditor-toolbar-tool-indent' => 'Indentazione',
	'wikieditor-toolbar-tool-indent-example' => "Linea d'indentazione",
	'wikieditor-toolbar-tool-nowiki' => 'Ignora formattazione wiki',
	'wikieditor-toolbar-tool-nowiki-example' => 'Inserisci il testo da non formattare',
	'wikieditor-toolbar-tool-redirect' => "Rinvia a un'altra pagina",
	'wikieditor-toolbar-tool-redirect-example' => 'Nome della pagina di destinazione',
	'wikieditor-toolbar-tool-big' => 'Grande',
	'wikieditor-toolbar-tool-big-example' => 'Testo grande',
	'wikieditor-toolbar-tool-small' => 'Piccolo',
	'wikieditor-toolbar-tool-small-example' => 'Testo piccolo',
	'wikieditor-toolbar-tool-superscript' => 'Apice',
	'wikieditor-toolbar-tool-superscript-example' => 'Testo in apice',
	'wikieditor-toolbar-tool-subscript' => 'Pedice',
	'wikieditor-toolbar-tool-subscript-example' => 'Testo in pedice',
	'wikieditor-toolbar-group-insert' => 'Inserisci',
	'wikieditor-toolbar-tool-gallery' => 'Galleria di immagini',
	'wikieditor-toolbar-tool-gallery-example' => '$1:Esempio.jpg|Didascalia1
$1:Esempio.jpg|Didascalia2',
	'wikieditor-toolbar-tool-newline' => 'Nuova riga',
	'wikieditor-toolbar-tool-table' => 'Tabella',
	'wikieditor-toolbar-tool-table-example-old' => '-
! titolo 1
! titolo 2
! titolo 3
|-
| riga 1, cella 1
| riga 1, cella 2
| riga 1, cella 3
|-
| riga 2, cella 1
| riga 2, cella 2
| riga 2, cella 3',
	'wikieditor-toolbar-tool-table-example-cell-text' => 'Testo della cella',
	'wikieditor-toolbar-tool-table-example-header' => 'Testo del titolo',
	'wikieditor-toolbar-tool-table-title' => 'Inserisci tabella',
	'wikieditor-toolbar-tool-table-dimensions-rows' => 'Righe',
	'wikieditor-toolbar-tool-table-dimensions-columns' => 'Colonne',
	'wikieditor-toolbar-tool-table-dimensions-header' => 'Includi una riga per i titoli',
	'wikieditor-toolbar-tool-table-wikitable' => 'Stile con bordi',
	'wikieditor-toolbar-tool-table-sortable' => 'Rendi la tabella ordinabile',
	'wikieditor-toolbar-tool-table-example' => 'Testo della cella',
	'wikieditor-toolbar-tool-table-preview' => 'Anteprima',
	'wikieditor-toolbar-tool-table-insert' => 'Inserisci',
	'wikieditor-toolbar-tool-table-cancel' => 'Annulla',
	'wikieditor-toolbar-tool-table-toomany' => 'Con questo strumento non è possibile inserire una tabella che abbia più di $1 celle.',
	'wikieditor-toolbar-tool-table-invalidnumber' => 'Non hai indicato un numero valido di righe o di colonne.',
	'wikieditor-toolbar-tool-table-zero' => 'Non puoi inserire una tabella senza righe e/o senza colonne.',
	'wikieditor-toolbar-tool-replace' => 'Cerca e sostituisci',
	'wikieditor-toolbar-tool-replace-title' => 'Cerca e sostituisci',
	'wikieditor-toolbar-tool-replace-search' => 'Cerca:',
	'wikieditor-toolbar-tool-replace-replace' => 'Sostituisci con:',
	'wikieditor-toolbar-tool-replace-case' => 'Maiuscole/minuscole',
	'wikieditor-toolbar-tool-replace-regex' => "Usa la stringa di ricerca come un'espressione regolare",
	'wikieditor-toolbar-tool-replace-button-findnext' => 'Trova successivi',
	'wikieditor-toolbar-tool-replace-button-replace' => 'Sostituisci',
	'wikieditor-toolbar-tool-replace-button-replaceall' => 'Sostituisci tutto',
	'wikieditor-toolbar-tool-replace-close' => 'Chiudi',
	'wikieditor-toolbar-tool-replace-nomatch' => 'La tua ricerca non ha prodotto risultati.',
	'wikieditor-toolbar-tool-replace-success' => '$1 sostituzione/i effettuata/e.',
	'wikieditor-toolbar-tool-replace-emptysearch' => 'Non hai indicato cosa cercare.',
	'wikieditor-toolbar-tool-replace-invalidregex' => "L'espressione regolare immessa non è valida: $1",
	'wikieditor-toolbar-section-characters' => 'Caratteri speciali',
	'wikieditor-toolbar-characters-page-latin' => 'Latino',
	'wikieditor-toolbar-characters-page-latinextended' => 'Latino esteso',
	'wikieditor-toolbar-characters-page-ipa' => 'IPA',
	'wikieditor-toolbar-characters-page-symbols' => 'Simboli',
	'wikieditor-toolbar-characters-page-greek' => 'Greco',
	'wikieditor-toolbar-characters-page-cyrillic' => 'Cirillico',
	'wikieditor-toolbar-characters-page-arabic' => 'Arabo',
	'wikieditor-toolbar-characters-page-arabicextended' => 'Arabo esteso',
	'wikieditor-toolbar-characters-page-persian' => 'Persiano',
	'wikieditor-toolbar-characters-page-hebrew' => 'Ebraico',
	'wikieditor-toolbar-characters-page-bangla' => 'Bengalese',
	'wikieditor-toolbar-characters-page-tamil' => 'Tamil',
	'wikieditor-toolbar-characters-page-telugu' => 'Telugu',
	'wikieditor-toolbar-characters-page-sinhala' => 'Singalese',
	'wikieditor-toolbar-characters-page-gujarati' => 'Gujarati',
	'wikieditor-toolbar-characters-page-devanagari' => 'Devanagari',
	'wikieditor-toolbar-characters-page-thai' => 'Thailandese',
	'wikieditor-toolbar-characters-page-lao' => 'Lao',
	'wikieditor-toolbar-characters-page-khmer' => 'Khmer',
	'wikieditor-toolbar-section-help' => 'Aiuto',
	'wikieditor-toolbar-help-heading-description' => 'Descrizione',
	'wikieditor-toolbar-help-heading-syntax' => 'Cosa si digita',
	'wikieditor-toolbar-help-heading-result' => 'Cosa si ottiene',
	'wikieditor-toolbar-help-page-format' => 'Formattazione',
	'wikieditor-toolbar-help-page-link' => 'Collegamenti',
	'wikieditor-toolbar-help-page-heading' => 'Intestazioni',
	'wikieditor-toolbar-help-page-list' => 'Elenchi',
	'wikieditor-toolbar-help-page-file' => 'File',
	'wikieditor-toolbar-help-page-reference' => 'Note',
	'wikieditor-toolbar-help-page-discussion' => 'Discussione',
	'wikieditor-toolbar-help-content-italic-description' => 'Corsivo',
	'wikieditor-toolbar-help-content-italic-syntax' => "''Testo in corsivo''",
	'wikieditor-toolbar-help-content-italic-result' => '<em>Testo in corsivo</em>',
	'wikieditor-toolbar-help-content-bold-description' => 'Grassetto',
	'wikieditor-toolbar-help-content-bold-syntax' => "'''Testo in grassetto'''",
	'wikieditor-toolbar-help-content-bold-result' => '<strong>Testo in grassetto</strong>',
	'wikieditor-toolbar-help-content-bolditalic-description' => 'Grassetto e corsivo',
	'wikieditor-toolbar-help-content-bolditalic-syntax' => "'''''Testo in grassetto e corsivo'''''",
	'wikieditor-toolbar-help-content-bolditalic-result' => '<strong><em>Testo in grassetto e corsivo</em></strong>',
	'wikieditor-toolbar-help-content-ilink-description' => 'Collegamento interno',
	'wikieditor-toolbar-help-content-ilink-syntax' => '[[Titolo pagina|Etichetta collegamento]]<br />[[Titolo pagina]]',
	'wikieditor-toolbar-help-content-ilink-result' => "<a href='#'>Etichetta collegamento</a><br /><a href='#'>Titolo pagina</a>",
	'wikieditor-toolbar-help-content-xlink-description' => 'Collegamento esterno',
	'wikieditor-toolbar-help-content-xlink-syntax' => '[http://www.example.org Etichetta collegamento]<br />[http://www.example.org]<br />http://www.example.org',
	'wikieditor-toolbar-help-content-xlink-result' => "<a href='#' class='external'>Etichetta collegamento</a><br /><a href='#' class='external autonumber'>[1]</a><br /><a href='#' class='external'>http://www.example.org</a>",
	'wikieditor-toolbar-help-content-heading2-description' => '2° livello di intestazione',
	'wikieditor-toolbar-help-content-heading2-syntax' => '== Titolo sezione ==',
	'wikieditor-toolbar-help-content-heading2-result' => '<h2>Titolo sezione</h2>',
	'wikieditor-toolbar-help-content-heading3-description' => '3° livello di intestazione',
	'wikieditor-toolbar-help-content-heading3-syntax' => '=== Titolo sezione ===',
	'wikieditor-toolbar-help-content-heading3-result' => '<h3>Titolo sezione</h3>',
	'wikieditor-toolbar-help-content-heading4-description' => '4° livello di intestazione',
	'wikieditor-toolbar-help-content-heading4-syntax' => '==== Titolo sezione ====',
	'wikieditor-toolbar-help-content-heading4-result' => '<h4>Titolo sezione</h4>',
	'wikieditor-toolbar-help-content-heading5-description' => '5° livello di intestazione',
	'wikieditor-toolbar-help-content-heading5-syntax' => '===== Titolo sezione =====',
	'wikieditor-toolbar-help-content-heading5-result' => '<h5>Titolo sezione</h5>',
	'wikieditor-toolbar-help-content-ulist-description' => 'Elenco puntato',
	'wikieditor-toolbar-help-content-ulist-syntax' => "* Elemento dell'elenco<br />* Elemento dell'elenco",
	'wikieditor-toolbar-help-content-ulist-result' => "<ul><li>Elemento dell'elenco</li><li>Elemento dell'elenco</li></ul>",
	'wikieditor-toolbar-help-content-olist-description' => 'Elenco numerato',
	'wikieditor-toolbar-help-content-olist-syntax' => "# Elemento dell'elenco<br /># Elemento dell'elenco",
	'wikieditor-toolbar-help-content-olist-result' => "<ol><li>Elemento dell'elenco</li><li>Elemento dell'elenco</li></ol>",
	'wikieditor-toolbar-help-content-file-description' => 'File incorporato',
	'wikieditor-toolbar-help-content-file-syntax' => '[[$1:Esempio.png|thumb|Testo della didascalia]]',
	'wikieditor-toolbar-help-content-file-result' => "<div style='width:104px;' class='thumbinner'><a title='Caption text' class='image' href='#'><img height='50' width='100' border='0' class='thumbimage' src='$2/WikiEditor/modules/images/toolbar/example-image.png' alt=''/></a><div class='thumbcaption'><div class='magnify'><a title='Enlarge' class='internal' href='#'><img height='11' width='15' alt='' src='$1/common/images/magnify-clip.png'/></a></div>Testo della didascalia</div></div>",
	'wikieditor-toolbar-help-content-reference-description' => 'Nota',
	'wikieditor-toolbar-help-content-reference-syntax' => 'Testo della pagina.&lt;ref name="test"&gt;[http://www.example.org Testo del collegamento], testo aggiuntivo.&lt;/ref&gt;',
	'wikieditor-toolbar-help-content-reference-result' => "Testo della pagina.<sup><a href='#'>[1]</a></sup>",
	'wikieditor-toolbar-help-content-rereference-description' => 'Ulteriore uso della stessa nota',
	'wikieditor-toolbar-help-content-rereference-result' => "Testo della pagina.<sup><a href='#'>[1]</a></sup>",
	'wikieditor-toolbar-help-content-showreferences-description' => 'Mostra note',
	'wikieditor-toolbar-help-content-showreferences-result' => "<ol class='references'><li id='cite_note-test-0'><b><a title='' href='#'>^</a></b> <a rel='nofollow' title='http://www.example.org' class='external text' href='#'>Testo del collegamento</a>, testo aggiuntivo.</li></ol>",
	'wikieditor-toolbar-help-content-signaturetimestamp-description' => 'Firma con data e ora',
	'wikieditor-toolbar-help-content-signaturetimestamp-result' => "<a href='#' title='{{#special:mypage}}'>Nome utente</a> (<a href='#' title='{{#special:mytalk}}'>discussione</a>) 15:54, 10 giu 2009 (UTC)",
	'wikieditor-toolbar-help-content-signature-description' => 'Firma',
	'wikieditor-toolbar-help-content-signature-result' => "<a href='#' title='{{#special:mypage}}'>Nome utente</a> (<a href='#' title='{{#special:mytalk}}'>discussione</a>)",
	'wikieditor-toolbar-help-content-indent-description' => 'Indentazione',
	'wikieditor-toolbar-help-content-indent-syntax' => 'Testo normale<br />:Testo indentato<br />::Testo indentato',
	'wikieditor-toolbar-help-content-indent-result' => 'Testo normale<dl><dd>Testo indentato<dl><dd>Testo indentato</dd></dl></dd></dl>',
);

/** Japanese (日本語)
 * @author 2nd-player
 * @author Aotake
 * @author Fryed-peach
 * @author Hosiryuhosi
 * @author Ohgi
 * @author Schu
 * @author Shirayuki
 * @author Whym
 * @author 青子守歌
 */
$messages['ja'] = array(
	'wikieditor' => '高度なウィキテキスト編集インターフェイス',
	'wikieditor-desc' => '拡張可能なウィキテキスト編集インターフェイスと多数の機能モジュールを提供する',
	'wikieditor-wikitext-tab' => 'ウィキテキスト',
	'wikieditor-loading' => '読み込み中...',
	'wikieditor-preview-preference' => '比較プレビューを有効にする',
	'wikieditor-preview-tab' => 'プレビュー',
	'wikieditor-preview-changes-tab' => '差分',
	'wikieditor-preview-loading' => '読み込み中...',
	'wikieditor-previewDialog-preference' => 'プレビューダイアログを有効にする',
	'wikieditor-previewDialog-tab' => 'プレビュー',
	'wikieditor-previewDialog-loading' => '読み込み中...',
	'wikieditor-publish-preference' => '段階的投稿を有効にする',
	'wikieditor-publish-button-publish' => '投稿',
	'wikieditor-publish-button-cancel' => '中止',
	'wikieditor-publish-dialog-title' => '{{SITENAME}} への投稿',
	'wikieditor-publish-dialog-summary' => '編集内容の要約（あなたが行なった変更を簡潔に説明してください）：',
	'wikieditor-publish-dialog-minor' => '細部の編集',
	'wikieditor-publish-dialog-watch' => 'このページをウォッチ',
	'wikieditor-publish-dialog-publish' => '投稿',
	'wikieditor-publish-dialog-goback' => '戻る',
	'wikieditor-template-editor-preference' => 'フォームを利用したテンプレートの編集を有効にする',
	'wikieditor-template-editor-dialog-title' => 'テンプレートを編集',
	'wikieditor-template-editor-dialog-submit' => '更新',
	'wikieditor-template-editor-dialog-cancel' => '中止',
	'wikieditor-templates-preference' => 'テンプレート折り畳みを有効にする',
	'wikieditor-toc-preference' => '編集画面の目次を有効にする',
	'wikieditor-toc-show' => '目次を表示',
	'wikieditor-toc-hide' => '目次を非表示',
	'wikieditor-toolbar' => '編集ツールバー',
	'wikieditor-toolbar-desc' => '使いやすさの向上したページ編集ツールバー',
	'wikieditor-toolbar-preference' => '改良型編集ツールバーを有効にする',
	'wikieditor-toolbar-dialogs-preference' => 'リンクや表などの挿入ダイアログを有効にする',
	'wikieditor-toolbar-hidesig' => '標準名前空間で署名ボタンを非表示にする',
	'wikieditor-toolbar-loading' => '読み込み中...',
	'wikieditor-toolbar-tool-bold' => '太字',
	'wikieditor-toolbar-tool-bold-example' => '太字文',
	'wikieditor-toolbar-tool-italic' => '斜体',
	'wikieditor-toolbar-tool-italic-example' => '斜体文',
	'wikieditor-toolbar-tool-ilink' => '内部リンク',
	'wikieditor-toolbar-tool-ilink-example' => 'リンクタイトル',
	'wikieditor-toolbar-tool-xlink' => '外部リンク (接頭辞 http:// を忘れずに)',
	'wikieditor-toolbar-tool-xlink-example' => 'http://www.example.com リンクタイトル',
	'wikieditor-toolbar-tool-link' => 'リンク',
	'wikieditor-toolbar-tool-link-title' => 'リンクの挿入',
	'wikieditor-toolbar-tool-link-int' => 'ウィキページへ',
	'wikieditor-toolbar-tool-link-int-target' => 'ページ名:',
	'wikieditor-toolbar-tool-link-int-target-tooltip' => 'ページ名か URL',
	'wikieditor-toolbar-tool-link-int-text' => 'リンク文:',
	'wikieditor-toolbar-tool-link-int-text-tooltip' => '表示する文字列を入力してください',
	'wikieditor-toolbar-tool-link-ext' => '外部のウェブページへ',
	'wikieditor-toolbar-tool-link-ext-target' => 'リンクURL:',
	'wikieditor-toolbar-tool-link-ext-text' => 'リンク テキスト:',
	'wikieditor-toolbar-tool-link-insert' => 'リンク挿入',
	'wikieditor-toolbar-tool-link-cancel' => '中止',
	'wikieditor-toolbar-tool-link-int-target-status-exists' => 'ページは存在します',
	'wikieditor-toolbar-tool-link-int-target-status-notexists' => 'ページは存在しません',
	'wikieditor-toolbar-tool-link-int-target-status-invalid' => 'ページ名として無効です',
	'wikieditor-toolbar-tool-link-int-target-status-external' => '外部リンク',
	'wikieditor-toolbar-tool-link-int-target-status-loading' => 'ページの存在を確認中…',
	'wikieditor-toolbar-tool-link-int-invalid' => '指定したページ名は無効です。',
	'wikieditor-toolbar-tool-link-lookslikeinternal' => '指定された URL は別のウィキページへのリンクのようです。
これを内部リンクにしますか？',
	'wikieditor-toolbar-tool-link-lookslikeinternal-int' => '内部リンク',
	'wikieditor-toolbar-tool-link-lookslikeinternal-ext' => '外部リンク',
	'wikieditor-toolbar-tool-link-empty' => 'リンクすべき入力が与えられていません。',
	'wikieditor-toolbar-tool-file' => '埋め込みファイル',
	'wikieditor-toolbar-tool-file-example' => '例.jpg',
	'wikieditor-toolbar-tool-file-title' => 'ファイルの挿入',
	'wikieditor-toolbar-file-target' => 'ファイル名:',
	'wikieditor-toolbar-file-caption' => 'キャプション:',
	'wikieditor-toolbar-file-size' => 'サイズ:',
	'wikieditor-toolbar-file-float' => '配置:',
	'wikieditor-toolbar-file-default' => '(既定)',
	'wikieditor-toolbar-file-format' => '形式:',
	'wikieditor-toolbar-file-format-none' => 'なし',
	'wikieditor-toolbar-tool-file-insert' => 'ファイル挿入',
	'wikieditor-toolbar-tool-file-cancel' => '中止',
	'wikieditor-toolbar-tool-reference' => '注釈',
	'wikieditor-toolbar-tool-reference-example' => '注釈文をここに入力してください',
	'wikieditor-toolbar-tool-reference-cancel' => '中止',
	'wikieditor-toolbar-tool-reference-title' => '出典を挿入',
	'wikieditor-toolbar-tool-reference-insert' => '挿入',
	'wikieditor-toolbar-tool-reference-text' => '出典情報',
	'wikieditor-toolbar-tool-signature' => '時刻印付き署名',
	'wikieditor-toolbar-section-advanced' => '上級',
	'wikieditor-toolbar-tool-heading' => '見出し',
	'wikieditor-toolbar-tool-heading-1' => 'レベル1',
	'wikieditor-toolbar-tool-heading-2' => 'レベル2',
	'wikieditor-toolbar-tool-heading-3' => 'レベル3',
	'wikieditor-toolbar-tool-heading-4' => 'レベル4',
	'wikieditor-toolbar-tool-heading-5' => 'レベル5',
	'wikieditor-toolbar-tool-heading-example' => '見出しタイトル',
	'wikieditor-toolbar-group-format' => '形式',
	'wikieditor-toolbar-tool-ulist' => '番号なし箇条書き',
	'wikieditor-toolbar-tool-ulist-example' => '番号なし箇条書きの項目',
	'wikieditor-toolbar-tool-olist' => '番号付き箇条書き',
	'wikieditor-toolbar-tool-olist-example' => '番号付き箇条書きの項目',
	'wikieditor-toolbar-tool-indent' => '字下げ',
	'wikieditor-toolbar-tool-indent-example' => '字下げされた行',
	'wikieditor-toolbar-tool-nowiki' => 'ウィキ書式なし',
	'wikieditor-toolbar-tool-nowiki-example' => 'ここにマークアップを無効にするテキストを入力します',
	'wikieditor-toolbar-tool-redirect' => '転送',
	'wikieditor-toolbar-tool-redirect-example' => '転送先のページ名',
	'wikieditor-toolbar-tool-big' => '大',
	'wikieditor-toolbar-tool-big-example' => '大きなテキスト',
	'wikieditor-toolbar-tool-small' => '小',
	'wikieditor-toolbar-tool-small-example' => '小さなテキスト',
	'wikieditor-toolbar-tool-superscript' => '上付き文字',
	'wikieditor-toolbar-tool-superscript-example' => '上付き文字',
	'wikieditor-toolbar-tool-subscript' => '下付き文字',
	'wikieditor-toolbar-tool-subscript-example' => '下付き文字',
	'wikieditor-toolbar-group-insert' => '挿入',
	'wikieditor-toolbar-tool-gallery' => '画像ギャラリー',
	'wikieditor-toolbar-tool-gallery-example' => '$1:Example.jpg|キャプション1
$1:Example.jpg|キャプション2',
	'wikieditor-toolbar-tool-newline' => '改行',
	'wikieditor-toolbar-tool-table' => '表',
	'wikieditor-toolbar-tool-table-example-old' => '-
! 見出し 1
! 見出し 2
! 見出し 3
|-
| 行 1、セル 1
| 行 1、セル 2
| 行 1、セル 3
|-
| 行 2、セル 1
| 行 2、セル 2
| 行 2、セル 3',
	'wikieditor-toolbar-tool-table-example-cell-text' => 'セル内のテキスト',
	'wikieditor-toolbar-tool-table-example-header' => '見出しテキスト',
	'wikieditor-toolbar-tool-table-title' => '表を挿入',
	'wikieditor-toolbar-tool-table-dimensions-rows' => '行数',
	'wikieditor-toolbar-tool-table-dimensions-columns' => '列数',
	'wikieditor-toolbar-tool-table-dimensions-header' => '見出し行を含める',
	'wikieditor-toolbar-tool-table-wikitable' => '罫線のあるスタイル',
	'wikieditor-toolbar-tool-table-sortable' => '表を並べ替えられるようにする',
	'wikieditor-toolbar-tool-table-example' => 'セル内のテキスト',
	'wikieditor-toolbar-tool-table-preview' => 'プレビュー',
	'wikieditor-toolbar-tool-table-insert' => '挿入',
	'wikieditor-toolbar-tool-table-cancel' => '中止',
	'wikieditor-toolbar-tool-table-toomany' => 'このダイアログでは、$1個以上のセルがある表は挿入できません。',
	'wikieditor-toolbar-tool-table-invalidnumber' => '入力した行数または列数が有効ではありません。',
	'wikieditor-toolbar-tool-table-zero' => '行数または列数が0の表は挿入できません。',
	'wikieditor-toolbar-tool-replace' => '検索と置換',
	'wikieditor-toolbar-tool-replace-title' => '検索と置換',
	'wikieditor-toolbar-tool-replace-search' => '検索する文字列:',
	'wikieditor-toolbar-tool-replace-replace' => '置換後の文字列:',
	'wikieditor-toolbar-tool-replace-case' => '大文字・小文字を区別する',
	'wikieditor-toolbar-tool-replace-regex' => '正規表現で検索する',
	'wikieditor-toolbar-tool-replace-button-findnext' => '次を検索',
	'wikieditor-toolbar-tool-replace-button-replace' => '置換',
	'wikieditor-toolbar-tool-replace-button-replaceall' => 'すべて置換',
	'wikieditor-toolbar-tool-replace-close' => '閉じる',
	'wikieditor-toolbar-tool-replace-nomatch' => '検索文字列に一致するものはありませんでした。',
	'wikieditor-toolbar-tool-replace-success' => '$1回の置換が行われました。',
	'wikieditor-toolbar-tool-replace-emptysearch' => '検索するものが何も入力されていません。',
	'wikieditor-toolbar-tool-replace-invalidregex' => '入力された正規表現に誤りがあります: $1',
	'wikieditor-toolbar-section-characters' => '特殊文字',
	'wikieditor-toolbar-characters-page-latin' => 'ラテン文字',
	'wikieditor-toolbar-characters-page-latinextended' => 'ラテン文字拡張',
	'wikieditor-toolbar-characters-page-ipa' => '国際音声記号',
	'wikieditor-toolbar-characters-page-symbols' => '記号',
	'wikieditor-toolbar-characters-page-greek' => 'ギリシア文字',
	'wikieditor-toolbar-characters-page-cyrillic' => 'キリル文字',
	'wikieditor-toolbar-characters-page-arabic' => 'アラビア文字',
	'wikieditor-toolbar-characters-page-arabicextended' => 'アラビア文字拡張',
	'wikieditor-toolbar-characters-page-persian' => 'ペルシア文字',
	'wikieditor-toolbar-characters-page-hebrew' => 'ヘブライ文字',
	'wikieditor-toolbar-characters-page-bangla' => 'ベンガル文字',
	'wikieditor-toolbar-characters-page-tamil' => 'タミール',
	'wikieditor-toolbar-characters-page-telugu' => 'テルグ文字',
	'wikieditor-toolbar-characters-page-sinhala' => 'シンハラ文字',
	'wikieditor-toolbar-characters-page-gujarati' => 'グジャラート文字',
	'wikieditor-toolbar-characters-page-devanagari' => 'デーヴァナーガリー文字',
	'wikieditor-toolbar-characters-page-thai' => 'タイ文字',
	'wikieditor-toolbar-characters-page-lao' => 'ラオス文字',
	'wikieditor-toolbar-characters-page-khmer' => 'クメール文字',
	'wikieditor-toolbar-section-help' => 'ヘルプ',
	'wikieditor-toolbar-help-heading-description' => '解説',
	'wikieditor-toolbar-help-heading-syntax' => '入力内容',
	'wikieditor-toolbar-help-heading-result' => '出力結果',
	'wikieditor-toolbar-help-page-format' => '書式設定',
	'wikieditor-toolbar-help-page-link' => 'リンク',
	'wikieditor-toolbar-help-page-heading' => '見出し',
	'wikieditor-toolbar-help-page-list' => '箇条書き',
	'wikieditor-toolbar-help-page-file' => 'ファイル',
	'wikieditor-toolbar-help-page-reference' => '注釈',
	'wikieditor-toolbar-help-page-discussion' => '議論',
	'wikieditor-toolbar-help-content-italic-description' => '斜体',
	'wikieditor-toolbar-help-content-italic-syntax' => "''斜体テキスト''",
	'wikieditor-toolbar-help-content-italic-result' => '<em>斜体テキスト</em>',
	'wikieditor-toolbar-help-content-bold-description' => '太字',
	'wikieditor-toolbar-help-content-bold-syntax' => "'''太字テキスト'''",
	'wikieditor-toolbar-help-content-bold-result' => '<strong>太字テキスト</strong>',
	'wikieditor-toolbar-help-content-bolditalic-description' => '太字かつ斜体',
	'wikieditor-toolbar-help-content-bolditalic-syntax' => "'''''太字かつ斜体'''''",
	'wikieditor-toolbar-help-content-bolditalic-result' => '<strong><em>太字かつ斜体</em></strong>',
	'wikieditor-toolbar-help-content-ilink-description' => '内部リンク',
	'wikieditor-toolbar-help-content-ilink-syntax' => '[[ページ名|リンクラベル]]<br />[[ページ名]]',
	'wikieditor-toolbar-help-content-ilink-result' => "<a href='#'>リンクラベル</a><br /><a href='#'>ページ名</a>",
	'wikieditor-toolbar-help-content-xlink-description' => '外部リンク',
	'wikieditor-toolbar-help-content-xlink-syntax' => '[http://www.example.org リンクラベル]<br />[http://www.example.org]<br />http://www.example.org',
	'wikieditor-toolbar-help-content-xlink-result' => "<a href='#' class='external'>リンクラベル</a><br /><a href='#' class='external autonumber'>[1]</a><br /><a href='#' class='external'>http://www.example.org</a>",
	'wikieditor-toolbar-help-content-heading2-description' => '見出しレベル2',
	'wikieditor-toolbar-help-content-heading2-syntax' => '== 見出し ==',
	'wikieditor-toolbar-help-content-heading2-result' => '<h2>見出し</h2>',
	'wikieditor-toolbar-help-content-heading3-description' => '見出しレベル3',
	'wikieditor-toolbar-help-content-heading3-syntax' => '=== 見出し ===',
	'wikieditor-toolbar-help-content-heading3-result' => '<h3>見出し</h3>',
	'wikieditor-toolbar-help-content-heading4-description' => '見出しレベル4',
	'wikieditor-toolbar-help-content-heading4-syntax' => '==== 見出し ====',
	'wikieditor-toolbar-help-content-heading4-result' => '<h4>見出し</h4>',
	'wikieditor-toolbar-help-content-heading5-description' => '見出しレベル5',
	'wikieditor-toolbar-help-content-heading5-syntax' => '===== 見出し =====',
	'wikieditor-toolbar-help-content-heading5-result' => '<h5>見出し</h5>',
	'wikieditor-toolbar-help-content-ulist-description' => '番号なし箇条書き',
	'wikieditor-toolbar-help-content-ulist-syntax' => '* 箇条書き項目<br />* 箇条書き項目',
	'wikieditor-toolbar-help-content-ulist-result' => '<ul><li>箇条書き項目</li><li>箇条書き項目</li></ul>',
	'wikieditor-toolbar-help-content-olist-description' => '番号付き箇条書き',
	'wikieditor-toolbar-help-content-olist-syntax' => '# 箇条書き項目<br /># 箇条書き項目',
	'wikieditor-toolbar-help-content-olist-result' => '<ol><li>箇条書き項目</li><li>箇条書き項目</li></ol>',
	'wikieditor-toolbar-help-content-file-description' => '埋め込みファイル',
	'wikieditor-toolbar-help-content-file-syntax' => '[[$1:Example.png|thumb|キャプション]]',
	'wikieditor-toolbar-help-content-file-result' => "<div style='width:104px;' class='thumbinner'><a title='キャプション' class='image' href='#'><img height='50' width='100' border='0' class='thumbimage' src='$2/WikiEditor/modules/images/toolbar/example-image.png' alt=''/></a><div class='thumbcaption'><div class='magnify'><a title='拡大' class='internal' href='#'><img height='11' width='15' alt='' src='$1/common/images/magnify-clip.png'/></a></div>キャプション</div></div>",
	'wikieditor-toolbar-help-content-reference-description' => '注釈',
	'wikieditor-toolbar-help-content-reference-syntax' => 'ページ本文&lt;ref name="test"&gt;[http://www.example.org リンクタイトル]、追加テキスト&lt;/ref&gt;。',
	'wikieditor-toolbar-help-content-reference-result' => "ページ本文<sup><a href='#'>[1]</a></sup>。",
	'wikieditor-toolbar-help-content-rereference-description' => '同じ注釈の追加利用',
	'wikieditor-toolbar-help-content-rereference-result' => "ページ本文<sup><a href='#'>[1]</a></sup>。",
	'wikieditor-toolbar-help-content-showreferences-description' => '脚注の表示',
	'wikieditor-toolbar-help-content-showreferences-result' => "<ol class='references'><li id='cite_note-test-0'><b><a title='' href='#'>^</a></b> <a rel='nofollow' title='http://www.example.org' class='external text' href='#'>リンクタイトル</a>、追加テキスト</li></ol>",
	'wikieditor-toolbar-help-content-signaturetimestamp-description' => '時刻印付き署名',
	'wikieditor-toolbar-help-content-signaturetimestamp-result' => "<a href='#' title='{{#special:mypage}}'>利用者名</a> (<a href='#' title='{{#special:mytalk}}'>トーク</a>) 2009年6月10日 (水) 15:54 (UTC)",
	'wikieditor-toolbar-help-content-signature-description' => '署名',
	'wikieditor-toolbar-help-content-signature-result' => "<a href='#' title='{{#special:mypage}}'>利用者名</a> (<a href='#' title='{{#special:mytalk}}'>トーク</a>)",
	'wikieditor-toolbar-help-content-indent-description' => 'インデント',
	'wikieditor-toolbar-help-content-indent-syntax' => '通常の文章<br />:インデントされた文章<br />::インデントされた文章',
	'wikieditor-toolbar-help-content-indent-result' => '通常の文章<dl><dd>インデントされた文章<dl><dd>インデントされた文章</dd></dl></dd></dl>',
);

/** Lojban (Lojban)
 * @author Ruzihm
 */
$messages['jbo'] = array(
	'wikieditor-toolbar' => 'stika samtcikajna',
	'wikieditor-toolbar-desc' => "samtcikajna pe lo stika mutpapri zi'e poi filmau selpli",
	'wikieditor-toolbar-loading' => 'ca puvbre',
	'wikieditor-toolbar-tool-bold' => 'plana',
);

/** Javanese (Basa Jawa)
 * @author Meursault2004
 * @author NoiX180
 */
$messages['jv'] = array(
	'wikieditor' => 'Antarmuka panyuntingan tèks wiki canggih',
	'wikieditor-desc' => 'Nyadhiyakaké antarmuka tèks wiki sing bisa didhawakaké lan modul-modul sing nyadhiyakaké akèh piranti',
	'wikieditor-wikitext-tab' => 'TèksWiki',
	'wikieditor-loading' => 'Ngemot...',
	'wikieditor-preview-preference' => 'Urubaké pratayang sisi mbaka sisi',
	'wikieditor-preview-tab' => 'Pratayang',
	'wikieditor-preview-changes-tab' => 'Owah-owahan',
	'wikieditor-preview-loading' => 'Ngemot...',
	'wikieditor-previewDialog-preference' => 'Urubaké dialog pratayang',
	'wikieditor-previewDialog-tab' => 'Pratayang',
	'wikieditor-previewDialog-loading' => 'Ngemot...',
	'wikieditor-publish-preference' => 'Urubaké panerbitan tahap mbaka tahap',
	'wikieditor-publish-button-publish' => 'Terbitaké',
	'wikieditor-publish-button-cancel' => 'Batalna',
	'wikieditor-publish-dialog-title' => 'Terbitaké nèng {{SITENAME}}',
	'wikieditor-publish-dialog-summary' => 'Sunting ringkesan (ringkes njelasaké owahané Sampéyan):',
	'wikieditor-publish-dialog-minor' => 'Suntingan cilik',
	'wikieditor-publish-dialog-watch' => 'Awasi kaca iki',
	'wikieditor-publish-dialog-publish' => 'Terbitaké',
	'wikieditor-publish-dialog-goback' => 'Mbalik',
	'wikieditor-template-editor-preference' => 'Urubaké panyuntingan adhasar pormulir kanggo témplat wiki',
	'wikieditor-template-editor-dialog-title' => 'Sunting tèmplat',
	'wikieditor-template-editor-dialog-submit' => 'Anyari',
	'wikieditor-template-editor-dialog-cancel' => 'Batal',
	'wikieditor-templates-preference' => 'Urubaké piranti nutup témplat',
	'wikieditor-toc-preference' => 'Urubaké daptar isi sing mayar diarahaké',
	'wikieditor-toc-show' => 'Tuduhaké isi',
	'wikieditor-toc-hide' => 'Dhelikaké isi',
	'wikieditor-toolbar' => 'Bilah prangkat panyuntingan',
	'wikieditor-toolbar-desc' => 'Sunting bilah prangkat kaca mawa kagunan canggih',
	'wikieditor-toolbar-preference' => 'Urubaké bilah prangkat panyuntingan canggih',
	'wikieditor-toolbar-dialogs-preference' => 'Urubaké dialog kanggo nglebokaké pranala, tabèl lan liyané',
	'wikieditor-toolbar-hidesig' => 'Dhelikaké pencetan tapak asta saka kaca-kaca nèng bilik jeneng utama',
	'wikieditor-toolbar-loading' => 'Ngemot...',
	'wikieditor-toolbar-tool-bold' => 'Kandel',
	'wikieditor-toolbar-tool-bold-example' => 'Tèks kandel',
	'wikieditor-toolbar-tool-italic' => 'Miring',
	'wikieditor-toolbar-tool-italic-example' => 'Tèks miring',
	'wikieditor-toolbar-tool-ilink' => 'Pranala njero',
	'wikieditor-toolbar-tool-ilink-example' => 'Judhul pranala',
	'wikieditor-toolbar-tool-xlink' => 'Pranala njaba (èling ater-ater http://)',
	'wikieditor-toolbar-tool-xlink-example' => 'http://www.conto.com judhul pranala',
	'wikieditor-toolbar-tool-link' => 'Pranala',
	'wikieditor-toolbar-tool-link-title' => 'Lebokaké pranala',
	'wikieditor-toolbar-tool-link-int' => 'Nuju kaca wiki',
	'wikieditor-toolbar-tool-link-int-target' => 'Kaca utawa URL patujon:',
	'wikieditor-toolbar-tool-link-int-target-tooltip' => 'Judhul utawa URL kaca',
	'wikieditor-toolbar-tool-link-int-text' => 'Tèks sing tampil:',
	'wikieditor-toolbar-tool-link-int-text-tooltip' => 'Tèks sing ditampilaké',
	'wikieditor-toolbar-tool-link-ext' => 'Nuju kaca wèb njaba',
	'wikieditor-toolbar-tool-link-ext-target' => 'URL pranala:',
	'wikieditor-toolbar-tool-link-ext-text' => 'Tèks pranala:',
	'wikieditor-toolbar-tool-link-insert' => 'Lebokaké pranala',
	'wikieditor-toolbar-tool-link-cancel' => 'Batal',
	'wikieditor-toolbar-tool-link-int-target-status-exists' => 'Kacané ana',
	'wikieditor-toolbar-tool-link-int-target-status-notexists' => 'Kaca ora ana',
	'wikieditor-toolbar-tool-link-int-target-status-invalid' => 'Judhul ora sah',
	'wikieditor-toolbar-tool-link-int-target-status-external' => 'Pranala njaba',
	'wikieditor-toolbar-tool-link-int-target-status-loading' => 'Mriksa anané kaca...',
	'wikieditor-toolbar-tool-link-int-invalid' => 'Judhul sing Sampéyan awèhaké ora sah.',
	'wikieditor-toolbar-tool-link-lookslikeinternal' => 'URL sing Sampéyan awèhaké kayané pranala nuju kaca wiki liya.
Apa Sampéyan arep ndadékaé kuwi pranala njero?',
	'wikieditor-toolbar-tool-link-lookslikeinternal-int' => 'Pranala njero',
	'wikieditor-toolbar-tool-link-lookslikeinternal-ext' => 'Pranala njaba',
	'wikieditor-toolbar-tool-link-empty' => 'Sampéyan ora nglebokaké apa-apa kanggo ngubungaké.',
	'wikieditor-toolbar-tool-file' => 'Berkas kasisip',
	'wikieditor-toolbar-tool-file-example' => 'Conto.jpg',
	'wikieditor-toolbar-tool-file-title' => 'Lebokaké berkas',
	'wikieditor-toolbar-file-target' => 'Jeneng berkas:',
	'wikieditor-toolbar-file-caption' => 'Katrangan:',
	'wikieditor-toolbar-file-size' => 'Gedhéné:',
	'wikieditor-toolbar-file-float' => 'Rata:',
	'wikieditor-toolbar-file-default' => '(gawan)',
	'wikieditor-toolbar-file-format' => 'Pormat:',
	'wikieditor-toolbar-tool-file-insert' => 'Lebokaké',
	'wikieditor-toolbar-tool-file-cancel' => 'Batal',
	'wikieditor-toolbar-tool-reference' => 'Reperènsi',
	'wikieditor-toolbar-tool-reference-example' => 'Lebokaké tèks cathetan sikil kéné',
	'wikieditor-toolbar-tool-reference-cancel' => 'Batal',
	'wikieditor-toolbar-tool-reference-title' => 'Lebokaké reperènsi',
	'wikieditor-toolbar-tool-reference-insert' => 'Lebokaké',
	'wikieditor-toolbar-tool-reference-text' => 'Tèks reperènsi',
	'wikieditor-toolbar-tool-signature' => 'Tapak asta lan cap wektu',
	'wikieditor-toolbar-section-advanced' => 'Canggih',
	'wikieditor-toolbar-tool-heading' => 'Sirah',
	'wikieditor-toolbar-tool-heading-1' => 'Undhakan 1',
	'wikieditor-toolbar-tool-heading-2' => 'Undhakan 2',
	'wikieditor-toolbar-tool-heading-3' => 'Undhakan 3',
	'wikieditor-toolbar-tool-heading-4' => 'Undhakan 4',
	'wikieditor-toolbar-tool-heading-5' => 'Undhakan 5',
	'wikieditor-toolbar-tool-heading-example' => 'Tèks sirah',
	'wikieditor-toolbar-group-format' => 'Pormat',
	'wikieditor-toolbar-tool-ulist' => 'Daptar coblos',
	'wikieditor-toolbar-tool-ulist-example' => 'Barang daptar coblos',
	'wikieditor-toolbar-tool-olist' => 'Daptar angka',
	'wikieditor-toolbar-tool-olist-example' => 'Barang daptar angka',
	'wikieditor-toolbar-tool-indent' => 'Legokan',
	'wikieditor-toolbar-tool-indent-example' => 'Garis legok',
	'wikieditor-toolbar-tool-nowiki' => 'Ora ana pamormatan wiki',
	'wikieditor-toolbar-tool-nowiki-example' => 'Lebokaké tèks non-pormat kéné',
	'wikieditor-toolbar-tool-redirect' => 'Alihaké',
	'wikieditor-toolbar-tool-redirect-example' => 'Jeneng kaca patujon',
	'wikieditor-toolbar-tool-big' => 'Gedhé',
	'wikieditor-toolbar-tool-big-example' => 'Tèks gedhé',
	'wikieditor-toolbar-tool-small' => 'Cilik',
	'wikieditor-toolbar-tool-small-example' => 'Tèks cilik',
	'wikieditor-toolbar-tool-superscript' => 'Pangkat',
	'wikieditor-toolbar-tool-superscript-example' => 'Tèks pangkat',
	'wikieditor-toolbar-tool-subscript' => 'Subskrip',
	'wikieditor-toolbar-tool-subscript-example' => 'Tèks subskrip',
	'wikieditor-toolbar-group-insert' => 'Lebokaké',
	'wikieditor-toolbar-tool-gallery' => 'Galèri gambar',
	'wikieditor-toolbar-tool-gallery-example' => '$1:Conto.jpg|Katrangan1
$1:Conto.jpg|Katrangan2',
	'wikieditor-toolbar-tool-newline' => 'Larik anyar',
	'wikieditor-toolbar-tool-table' => 'Tabèl',
	'wikieditor-toolbar-tool-table-example-old' => '-
! Irah-irahan 1
! Irah-irahan 2
! Irah-irahan 3
|-
| larik 1, sèl 1
| larik 1, sèl 2
| larik 1, sèl 3
|-
| larik 2, sèl 1
| larik 2, sèl 2
| larik 2, sèl 3',
	'wikieditor-toolbar-tool-table-example-cell-text' => 'Tèks sèl',
	'wikieditor-toolbar-tool-table-example-header' => 'Tèks sirah',
	'wikieditor-toolbar-tool-table-title' => 'Lebokaké tabèl',
	'wikieditor-toolbar-tool-table-dimensions-rows' => 'Larik',
	'wikieditor-toolbar-tool-table-dimensions-columns' => 'Kolom',
	'wikieditor-toolbar-tool-table-dimensions-header' => 'Tambah larik sirah',
	'wikieditor-toolbar-tool-table-wikitable' => 'Gaya mawa watesan',
	'wikieditor-toolbar-tool-table-sortable' => 'Gawé tabèlé bisa diurutaké',
	'wikieditor-toolbar-tool-table-example' => 'Conto',
	'wikieditor-toolbar-tool-table-preview' => 'Pratayang',
	'wikieditor-toolbar-tool-table-insert' => 'Lebokaké',
	'wikieditor-toolbar-tool-table-cancel' => 'Batal',
	'wikieditor-toolbar-tool-table-toomany' => 'Nglebokaké tabèl mawa luwih saka $1 sèl ora dimungkinaké nganggo dialog iki.',
	'wikieditor-toolbar-tool-table-invalidnumber' => 'Sampéyan durung nglebokaké angka larik utawa kolom sing sah.',
	'wikieditor-toolbar-tool-table-zero' => 'Sampéyan ora bisa nglebokaké tabèl kanthi larik utawa kolom kosong.',
	'wikieditor-toolbar-tool-replace' => 'Golèk lan ganti',
	'wikieditor-toolbar-tool-replace-title' => 'Golèk lan ganti',
	'wikieditor-toolbar-tool-replace-search' => 'Golèki:',
	'wikieditor-toolbar-tool-replace-replace' => 'Ganti mawa:',
	'wikieditor-toolbar-tool-replace-case' => 'Cocokaké aksara',
	'wikieditor-toolbar-tool-replace-button-findnext' => 'Temokaké sabanjuré',
	'wikieditor-toolbar-tool-replace-button-replace' => 'Ganti',
	'wikieditor-toolbar-tool-replace-button-replaceall' => 'Ganti kabèh',
	'wikieditor-toolbar-tool-replace-close' => 'Tutup',
	'wikieditor-toolbar-tool-replace-nomatch' => 'Panggolèkan Sampéyan ora cocok karo apa waé.',
	'wikieditor-toolbar-tool-replace-success' => 'Nggawé $1 gantèn.',
	'wikieditor-toolbar-tool-replace-emptysearch' => 'Sampéyan ora nglebokaké apa-apa kanggo digolèki.',
	'wikieditor-toolbar-tool-replace-invalidregex' => 'Èkspresi biasa sing Sampéyan lebokaké ora sah: $1',
	'wikieditor-toolbar-section-characters' => 'Karakter kusus',
	'wikieditor-toolbar-characters-page-latin' => 'Latin',
	'wikieditor-toolbar-characters-page-latinextended' => 'Latin pepak',
	'wikieditor-toolbar-characters-page-ipa' => 'IPA',
	'wikieditor-toolbar-characters-page-symbols' => 'Simbol',
	'wikieditor-toolbar-characters-page-greek' => 'Yunani',
	'wikieditor-toolbar-characters-page-cyrillic' => 'Srilik',
	'wikieditor-toolbar-characters-page-arabic' => 'Arab',
	'wikieditor-toolbar-characters-page-arabicextended' => 'Arab pepak',
	'wikieditor-toolbar-characters-page-persian' => 'Persia',
	'wikieditor-toolbar-characters-page-hebrew' => 'Ibrani',
	'wikieditor-toolbar-characters-page-bangla' => 'Bengali',
	'wikieditor-toolbar-characters-page-tamil' => 'Tamil',
	'wikieditor-toolbar-characters-page-telugu' => 'Telugu',
	'wikieditor-toolbar-characters-page-sinhala' => 'Sinhala',
	'wikieditor-toolbar-characters-page-gujarati' => 'Gujarat',
	'wikieditor-toolbar-characters-page-devanagari' => 'Dewanagari',
	'wikieditor-toolbar-characters-page-thai' => 'Thailand',
	'wikieditor-toolbar-characters-page-lao' => 'Lao',
	'wikieditor-toolbar-characters-page-khmer' => 'Khmer',
	'wikieditor-toolbar-section-help' => 'Pitulung',
	'wikieditor-toolbar-help-heading-description' => 'Wedharan',
	'wikieditor-toolbar-help-heading-syntax' => 'Sing Sampéyan tulis',
	'wikieditor-toolbar-help-heading-result' => 'Sing Sampéyan éntukaké',
	'wikieditor-toolbar-help-page-format' => 'Pormat',
	'wikieditor-toolbar-help-page-link' => 'Pranala',
	'wikieditor-toolbar-help-page-heading' => 'Irah-irahan',
	'wikieditor-toolbar-help-page-list' => 'Daptar',
	'wikieditor-toolbar-help-page-file' => 'Berkas',
	'wikieditor-toolbar-help-page-reference' => 'Reperènsi',
	'wikieditor-toolbar-help-page-discussion' => 'Guneman',
	'wikieditor-toolbar-help-content-italic-description' => 'Miring',
	'wikieditor-toolbar-help-content-italic-syntax' => "'''Tèks miring'''",
	'wikieditor-toolbar-help-content-italic-result' => '<em>Tèks miring</em>',
	'wikieditor-toolbar-help-content-bold-description' => 'Kandel',
	'wikieditor-toolbar-help-content-bold-syntax' => "'''Tèks kandel'''",
	'wikieditor-toolbar-help-content-bold-result' => '<strong>Tèks kandel</strong>',
	'wikieditor-toolbar-help-content-bolditalic-description' => 'Kandel &amp; miring',
	'wikieditor-toolbar-help-content-bolditalic-syntax' => "'''''Tèks kandel &amp; miring'''''",
	'wikieditor-toolbar-help-content-bolditalic-result' => '<strong><em>Tèks kandel &amp; miring</em></strong>',
	'wikieditor-toolbar-help-content-ilink-description' => 'Pranala njero',
	'wikieditor-toolbar-help-content-ilink-syntax' => '[[Judhul kaca|Labèl pranala]]<br />[[Judhul kaca]]',
	'wikieditor-toolbar-help-content-ilink-result' => "<a href='#'>Labèl pranala</a><br /><a href='#'>Judhul kaca</a>",
	'wikieditor-toolbar-help-content-xlink-description' => 'Pranala njaba',
	'wikieditor-toolbar-help-content-xlink-syntax' => '[http://www.conto.org Labèl pranala]<br />[http://www.conto.org]<br />http://www.conto.org',
	'wikieditor-toolbar-help-content-xlink-result' => "<a href='#' class='external'>Labèl pranala</a><br /><a href='#' class='external autonumber'>[1]</a><br /><a href='#' class='external'>http://www.conto.org</a>",
	'wikieditor-toolbar-help-content-heading2-description' => 'Irah-irahan undhak ka-2',
	'wikieditor-toolbar-help-content-heading2-syntax' => '== Tulisan irah-irahan ==',
	'wikieditor-toolbar-help-content-heading2-result' => '<h2>Tulisan irah-irahan</h2>',
	'wikieditor-toolbar-help-content-heading3-description' => 'Irah-irahan undhak ka-3',
	'wikieditor-toolbar-help-content-heading3-syntax' => '=== Tulisan irah-irahan ===',
	'wikieditor-toolbar-help-content-heading3-result' => '<h3>Tulisan irah-irahan</h3>',
	'wikieditor-toolbar-help-content-heading4-description' => 'Irah-irahan undhak ka-4',
	'wikieditor-toolbar-help-content-heading4-syntax' => '==== Tulisan irah-irahan ====',
	'wikieditor-toolbar-help-content-heading4-result' => '<h4>Tulisan irah-irahan</h4>',
	'wikieditor-toolbar-help-content-heading5-description' => 'Irah-irahan undhak ka-5',
	'wikieditor-toolbar-help-content-heading5-syntax' => '===== Tulisan irah-irahan =====',
	'wikieditor-toolbar-help-content-heading5-result' => '<h5>Tulisan irah-irahan</h5>',
	'wikieditor-toolbar-help-content-ulist-description' => 'Daptar poin',
	'wikieditor-toolbar-help-content-ulist-syntax' => '* Baranging daptar<br />* Baranging daptar',
	'wikieditor-toolbar-help-content-ulist-result' => '<ul><li>Baranging daptar</li><li>Baranging daptar</li></ul>',
	'wikieditor-toolbar-help-content-olist-description' => 'Daptar angka',
	'wikieditor-toolbar-help-content-olist-syntax' => '# Baranging daptar<br /># Baranging daptar',
	'wikieditor-toolbar-help-content-olist-result' => '<ol><li>Baranging daptar</li><li>Baranging daptar</li></ol>',
	'wikieditor-toolbar-help-content-file-description' => 'Berkas kasisipaké',
	'wikieditor-toolbar-help-content-file-syntax' => '[[$1:Conto.png|gambar|Tulisan katrangan]]',
	'wikieditor-toolbar-help-content-reference-description' => 'Rujukan',
	'wikieditor-toolbar-help-content-reference-syntax' => 'Tèks kaca.&lt;ref name="test"&gt;[http://www.conto.org Tèks pranala], tèks tambahan.&lt;/ref&gt;',
	'wikieditor-toolbar-help-content-reference-result' => "Tèks kaca.<sup><a href='#'>[1]</a></sup>",
	'wikieditor-toolbar-help-content-rereference-description' => 'Panganggoan tambahan saka rujukan sing padha',
	'wikieditor-toolbar-help-content-rereference-result' => "Tèks kaca.<sup><a href='#'>[1]</a></sup>",
	'wikieditor-toolbar-help-content-showreferences-description' => 'Tampilaké réferensi',
	'wikieditor-toolbar-help-content-showreferences-result' => "<ol class='references'><li id='cite_note-test-0'><b><a title='' href='#'>^</a></b> <a rel='nofollow' title='http://www.conto.org' class='external text' href='#'>Tèks pranala</a>, tèks tambahan.</li></ol>",
	'wikieditor-toolbar-help-content-signaturetimestamp-description' => 'Tapak asta lan cap wektu',
	'wikieditor-toolbar-help-content-signaturetimestamp-result' => "<a href='#' title='{{#special:mypage}}'>Panganggo</a> (<a href='#' title='{{#special:mytalk}}'>wicara</a>) 15:54, 10 Juni 2009 (UTC)",
	'wikieditor-toolbar-help-content-signature-description' => 'Tapak asta',
	'wikieditor-toolbar-help-content-signature-result' => "<a href='#' title='{{#special:mypage}}'>Panganggo</a> (<a href='#' title='{{#special:mytalk}}'>wicara</a>)",
	'wikieditor-toolbar-help-content-indent-description' => 'Indèn',
);

/** Georgian (ქართული)
 * @author BRUTE
 * @author David1010
 * @author Dawid Deutschland
 * @author ITshnik
 * @author გიორგიმელა
 */
$messages['ka'] = array(
	'wikieditor' => 'ვიკიტექსტის რედაქტირების გაფართოებული ინტერფეისი',
	'wikieditor-desc' => 'ვიკიტექსტის რედაქტირების გაფართოებული ინტერფეისისა და სხვა ფუნქციებს უზრუნველყოფს',
	'wikieditor-wikitext-tab' => 'ვიკიტექსტი',
	'wikieditor-loading' => 'იტვირთება',
	'wikieditor-preview-preference' => 'ჩართეთ გვერდითი გადახედვა',
	'wikieditor-preview-tab' => 'წინასწარ',
	'wikieditor-preview-changes-tab' => 'ცვლილებები',
	'wikieditor-preview-loading' => 'იტვირთება...',
	'wikieditor-previewDialog-preference' => 'წინასწარი გადახედვის დიალოგის ჩართვა',
	'wikieditor-previewDialog-tab' => 'წინასწარ',
	'wikieditor-previewDialog-loading' => 'იტვირთება...',
	'wikieditor-publish-preference' => 'ჩართეთ ნაბიჯ-ნაბიჯი პუბლიკაცია',
	'wikieditor-publish-button-publish' => 'გამოქვეყნება',
	'wikieditor-publish-button-cancel' => 'გაუქმება',
	'wikieditor-publish-dialog-title' => 'გამოქვეყნება {{SITENAME}}-ში.',
	'wikieditor-publish-dialog-summary' => 'ცვლილების მოკლე აღწერა (წერილობით აღწერეთ, თუ რა ცვლილება შეიტანეთ):',
	'wikieditor-publish-dialog-minor' => 'მცირე შესწორება',
	'wikieditor-publish-dialog-watch' => 'ამ გვერდის თვალთვალი',
	'wikieditor-publish-dialog-publish' => 'გამოქვეყნება',
	'wikieditor-publish-dialog-goback' => 'უკან',
	'wikieditor-template-editor-preference' => 'თარგების რედაქტირება ფორმების მეშვეობით - ჩართვა',
	'wikieditor-template-editor-dialog-title' => 'თარგის რედაქტირება',
	'wikieditor-template-editor-dialog-submit' => 'განახლება',
	'wikieditor-template-editor-dialog-cancel' => 'გაუქმება',
	'wikieditor-templates-preference' => 'ჩაკეცილი თარგის ჩართვა',
	'wikieditor-toc-preference' => 'ჩართეთ სარჩევი ნავიგაციის შესაძლებლობით',
	'wikieditor-toc-show' => 'აჩვენეთ სარჩევი',
	'wikieditor-toc-hide' => 'სარჩევის დამალვა',
	'wikieditor-toolbar' => 'რედაქტირების პანელი',
	'wikieditor-toolbar-desc' => 'რედაქტირების პანელი გაუმჯობესებული იუზაბილითით',
	'wikieditor-toolbar-preference' => 'ჩართეთ რედაქტირების გაუმჯობესებული პანელი',
	'wikieditor-toolbar-dialogs-preference' => 'ჩართეთ დიალოგები ბმულების, ტაბულებისა და სხვა ობიექტების ჩასასმელად',
	'wikieditor-toolbar-hidesig' => 'ხელმოწერის ღილაკის დამალვა სახელთა სივრცის ძირითად გვერდებზე',
	'wikieditor-toolbar-loading' => 'იტვირთება…',
	'wikieditor-toolbar-tool-bold' => 'მუქი',
	'wikieditor-toolbar-tool-bold-example' => 'მუქი ტექსტი',
	'wikieditor-toolbar-tool-italic' => 'კურსივი',
	'wikieditor-toolbar-tool-italic-example' => 'კურსივის ტექსტი',
	'wikieditor-toolbar-tool-ilink' => 'შიდა ბმული',
	'wikieditor-toolbar-tool-ilink-example' => 'ბმულის სათაური',
	'wikieditor-toolbar-tool-xlink' => 'გარე ბმული (გახსოვდეთ http:// პრეფიქსი)',
	'wikieditor-toolbar-tool-xlink-example' => 'http://www.example.com ბმულის სათაური',
	'wikieditor-toolbar-tool-link' => 'ბმული',
	'wikieditor-toolbar-tool-link-title' => 'ბმულის ჩასმა',
	'wikieditor-toolbar-tool-link-int' => 'ვიკი გვერდზე',
	'wikieditor-toolbar-tool-link-int-target' => 'გვერდის სათაური:',
	'wikieditor-toolbar-tool-link-int-target-tooltip' => 'გვერდის სახელი ან URL',
	'wikieditor-toolbar-tool-link-int-text' => 'ნაჩვენები ტექსტი:',
	'wikieditor-toolbar-tool-link-int-text-tooltip' => 'საჩვენებელი ტექსტი',
	'wikieditor-toolbar-tool-link-ext' => 'გარე ვებ-გვერდზე',
	'wikieditor-toolbar-tool-link-ext-target' => 'URL ბმული:',
	'wikieditor-toolbar-tool-link-ext-text' => 'ბმულის ტექსტი:',
	'wikieditor-toolbar-tool-link-insert' => 'ბმულის ჩასმა',
	'wikieditor-toolbar-tool-link-cancel' => 'გაუქმება',
	'wikieditor-toolbar-tool-link-int-target-status-exists' => 'გვერდი არსებობს',
	'wikieditor-toolbar-tool-link-int-target-status-notexists' => 'გვერდი არ არსებობს',
	'wikieditor-toolbar-tool-link-int-target-status-invalid' => 'არასწორი დასახელება',
	'wikieditor-toolbar-tool-link-int-target-status-external' => 'გარე ბმული',
	'wikieditor-toolbar-tool-link-int-target-status-loading' => 'არსებული გვერდების შემოწმება...',
	'wikieditor-toolbar-tool-link-int-invalid' => 'მითითებული დასახელება არ არსებობს',
	'wikieditor-toolbar-tool-link-lookslikeinternal' => 'თქვენ მიერ მითითებული URL, როგორც ჩანს მითითებულია სხვა ვიკი-გვერდზე. გინდათ იყოს ის შიდა ბმული?',
	'wikieditor-toolbar-tool-link-lookslikeinternal-int' => 'შიდა ბმული',
	'wikieditor-toolbar-tool-link-lookslikeinternal-ext' => 'გარე ბმული',
	'wikieditor-toolbar-tool-link-empty' => 'თქვენ არ მიუთითეთ ბმული.',
	'wikieditor-toolbar-tool-file' => 'ჩასმული ფაილი',
	'wikieditor-toolbar-tool-file-example' => 'მაგალითი.jpg',
	'wikieditor-toolbar-tool-file-title' => 'ფაილის ჩასმა',
	'wikieditor-toolbar-file-target' => 'ფაილის სახელი:',
	'wikieditor-toolbar-file-caption' => 'წარწერა:',
	'wikieditor-toolbar-file-size' => 'ზომა:',
	'wikieditor-toolbar-file-default' => '(სტანდარტული)',
	'wikieditor-toolbar-file-format' => 'ფორმატი:',
	'wikieditor-toolbar-file-format-none' => 'არა',
	'wikieditor-toolbar-tool-file-insert' => 'ჩასმა',
	'wikieditor-toolbar-tool-file-cancel' => 'გაუქმება',
	'wikieditor-toolbar-tool-reference' => 'მინიშნებები',
	'wikieditor-toolbar-tool-reference-example' => 'ჩასვით მინიშნებების ტექსტი აქ',
	'wikieditor-toolbar-tool-reference-cancel' => 'გაუქმება',
	'wikieditor-toolbar-tool-reference-title' => 'სქოლიოს ჩასმა',
	'wikieditor-toolbar-tool-reference-insert' => 'ჩასმა',
	'wikieditor-toolbar-tool-reference-text' => 'სქოლიოს ტექსტი',
	'wikieditor-toolbar-tool-signature' => 'ხელმოწერა და დრო',
	'wikieditor-toolbar-section-advanced' => 'დამატებით',
	'wikieditor-toolbar-tool-heading' => 'სათაური',
	'wikieditor-toolbar-tool-heading-1' => 'დონე 1',
	'wikieditor-toolbar-tool-heading-2' => 'დონე 2',
	'wikieditor-toolbar-tool-heading-3' => 'დონე 3',
	'wikieditor-toolbar-tool-heading-4' => 'დონე4',
	'wikieditor-toolbar-tool-heading-5' => 'დონე 5',
	'wikieditor-toolbar-tool-heading-example' => 'სათაურის ტექსტი',
	'wikieditor-toolbar-group-format' => 'ფორმატი',
	'wikieditor-toolbar-tool-ulist' => 'მონიშნული სია',
	'wikieditor-toolbar-tool-ulist-example' => 'მონიშნული სიის ელემენტი',
	'wikieditor-toolbar-tool-olist' => 'დათვლადი სია',
	'wikieditor-toolbar-tool-olist-example' => 'დათვლადი სიის ელემენტი',
	'wikieditor-toolbar-tool-indent' => 'გადახრა',
	'wikieditor-toolbar-tool-indent-example' => 'ხაზი გადახრით',
	'wikieditor-toolbar-tool-nowiki' => 'ვიკის ფორმატირების იგნორირება',
	'wikieditor-toolbar-tool-nowiki-example' => 'ჩასვით დაუფორმატებელი ტექსტი აქ',
	'wikieditor-toolbar-tool-redirect' => 'გადამისამართება',
	'wikieditor-toolbar-tool-redirect-example' => 'გვერდის სამიზნო სახელი',
	'wikieditor-toolbar-tool-big' => 'დიდი',
	'wikieditor-toolbar-tool-big-example' => 'დიდი ტექსტი',
	'wikieditor-toolbar-tool-small' => 'მცირე',
	'wikieditor-toolbar-tool-small-example' => 'მცირე ტექსტი',
	'wikieditor-toolbar-tool-superscript' => 'ზეხაზური',
	'wikieditor-toolbar-tool-superscript-example' => 'ზეხაზური ტექსტი',
	'wikieditor-toolbar-tool-subscript' => 'ქვეხაზური',
	'wikieditor-toolbar-tool-subscript-example' => 'ქვეხაზური ტექსტი',
	'wikieditor-toolbar-group-insert' => 'ჩასმა',
	'wikieditor-toolbar-tool-gallery' => 'გამოსახულებათა გალერეა',
	'wikieditor-toolbar-tool-gallery-example' => '$1:Example.jpg|აღწერა1
$1:Example.jpg|აღწერა2',
	'wikieditor-toolbar-tool-newline' => 'ახალი ხაზი',
	'wikieditor-toolbar-tool-table' => 'ტაბულა',
	'wikieditor-toolbar-tool-table-example-old' => '-
! სახელი 1
! სახელი 2
! სახელი 3
|-
| ხაზი 1, უჯრედი 1
| ხაზი 1, უჯრედი 2
| ხაზი 1, უჯრედი 3
|-
| ხაზი 2, უჯრედი 1
| ხაზი 2, უჯრედი 2
| ხაზი 2, უჯრედი 3',
	'wikieditor-toolbar-tool-table-example-cell-text' => 'უჯრედის ტექსტი',
	'wikieditor-toolbar-tool-table-example-header' => 'სათაურის ტექსტი',
	'wikieditor-toolbar-tool-table-title' => 'ტაბულის ჩასმა',
	'wikieditor-toolbar-tool-table-dimensions-rows' => 'რიგიები',
	'wikieditor-toolbar-tool-table-dimensions-columns' => 'სვეტები',
	'wikieditor-toolbar-tool-table-dimensions-header' => 'ჩასვათ სათაურის ხაზი',
	'wikieditor-toolbar-tool-table-wikitable' => 'გაფორმება საზღვრებით',
	'wikieditor-toolbar-tool-table-sortable' => 'სორტირებული ცხრილის შექმნა',
	'wikieditor-toolbar-tool-table-example' => 'მაგალითი',
	'wikieditor-toolbar-tool-table-preview' => 'წინასწარ',
	'wikieditor-toolbar-tool-table-insert' => 'ჩასმა',
	'wikieditor-toolbar-tool-table-cancel' => 'გაუქმება',
	'wikieditor-toolbar-tool-table-toomany' => 'ეს დიალოგი ვერ შექმნის $1 უჯრედზე მეტი უჯრედის შემცვლელ ტაბულას',
	'wikieditor-toolbar-tool-table-invalidnumber' => 'თქვენ არ მიგითითებიათ ხაზების ან სვეტების რაოდენობა',
	'wikieditor-toolbar-tool-table-zero' => 'თქვენ ვერ ჩასვავთ ხაზების ან სვეტების ნულოვან რაოდენობას',
	'wikieditor-toolbar-tool-replace' => 'ძებნა და შეცვლა',
	'wikieditor-toolbar-tool-replace-title' => 'ძებნა და შეცვლა',
	'wikieditor-toolbar-tool-replace-search' => 'ძიება:',
	'wikieditor-toolbar-tool-replace-replace' => 'შეცვლა:',
	'wikieditor-toolbar-tool-replace-case' => 'რეგისტრის გათვალისწინება',
	'wikieditor-toolbar-tool-replace-regex' => 'ჩათვალეთ ძიების ხაზი რეგულარულ გამოსახულებად',
	'wikieditor-toolbar-tool-replace-button-findnext' => 'შემდეგის მოძიება',
	'wikieditor-toolbar-tool-replace-button-replace' => 'ჩანაცვლება',
	'wikieditor-toolbar-tool-replace-button-replaceall' => 'შეცვალეთ ყველაფერი',
	'wikieditor-toolbar-tool-replace-close' => 'დახურვა',
	'wikieditor-toolbar-tool-replace-nomatch' => 'თქვენი მოთხოვნის შესაბამისი არაფერია ნაპოვნი',
	'wikieditor-toolbar-tool-replace-success' => '$1 შეცვლა განხორციელდა.',
	'wikieditor-toolbar-tool-replace-emptysearch' => 'თქვენ არ მიუთითეთ საძიებელი.',
	'wikieditor-toolbar-tool-replace-invalidregex' => 'თქვენს მიერ შეტანილი რეგულარული გამოსახულება არასწორია: $1',
	'wikieditor-toolbar-section-characters' => 'სპეციალური სიმბოლოები',
	'wikieditor-toolbar-characters-page-latin' => 'ლათინური',
	'wikieditor-toolbar-characters-page-latinextended' => 'ლათინური გაფართოება',
	'wikieditor-toolbar-characters-page-ipa' => 'IPA',
	'wikieditor-toolbar-characters-page-symbols' => 'სიმბოლოები',
	'wikieditor-toolbar-characters-page-greek' => 'ბერძნული',
	'wikieditor-toolbar-characters-page-cyrillic' => 'კირილიცა',
	'wikieditor-toolbar-characters-page-arabic' => 'არაბული',
	'wikieditor-toolbar-characters-page-arabicextended' => 'არაბული გაფართოება',
	'wikieditor-toolbar-characters-page-persian' => 'სპარსული',
	'wikieditor-toolbar-characters-page-hebrew' => 'ებრაული',
	'wikieditor-toolbar-characters-page-bangla' => 'ბენგალური',
	'wikieditor-toolbar-characters-page-tamil' => 'ტამილური',
	'wikieditor-toolbar-characters-page-telugu' => 'ტელუგუ',
	'wikieditor-toolbar-characters-page-sinhala' => 'სინგალური',
	'wikieditor-toolbar-characters-page-gujarati' => 'გუჯარათი',
	'wikieditor-toolbar-characters-page-devanagari' => 'დევანაგარი',
	'wikieditor-toolbar-characters-page-thai' => 'ტაილანდური',
	'wikieditor-toolbar-characters-page-lao' => 'ლაოსური',
	'wikieditor-toolbar-characters-page-khmer' => 'ქჰმერული',
	'wikieditor-toolbar-section-help' => 'დახმარება',
	'wikieditor-toolbar-help-heading-description' => 'აღწერა',
	'wikieditor-toolbar-help-heading-syntax' => 'რას ბეჭდავთ',
	'wikieditor-toolbar-help-heading-result' => 'რას მიიღებთ',
	'wikieditor-toolbar-help-page-format' => 'ფორმატირება',
	'wikieditor-toolbar-help-page-link' => 'ბმულები',
	'wikieditor-toolbar-help-page-heading' => 'სათაურები',
	'wikieditor-toolbar-help-page-list' => 'სიები',
	'wikieditor-toolbar-help-page-file' => 'ფაილები',
	'wikieditor-toolbar-help-page-reference' => 'მინიშნებები',
	'wikieditor-toolbar-help-page-discussion' => 'განხილვა',
	'wikieditor-toolbar-help-content-italic-description' => 'კურსივი',
	'wikieditor-toolbar-help-content-italic-syntax' => "''დახრილი ტექსტი''",
	'wikieditor-toolbar-help-content-italic-result' => '<em>დახრილი ტექსტი</em>',
	'wikieditor-toolbar-help-content-bold-description' => 'სქელი',
	'wikieditor-toolbar-help-content-bold-syntax' => "'''სქელი ტექსტი'''",
	'wikieditor-toolbar-help-content-bold-result' => '<strong>სქელი ტექსტი</strong>',
	'wikieditor-toolbar-help-content-bolditalic-description' => 'სქელი დახრილი',
	'wikieditor-toolbar-help-content-bolditalic-syntax' => "'''''სქელი დახრილი ტექსტი'''''",
	'wikieditor-toolbar-help-content-bolditalic-result' => '<em><strong>სქელი დახრილი ტექსტი</strong></em>',
	'wikieditor-toolbar-help-content-ilink-description' => 'შიდა ბმული',
	'wikieditor-toolbar-help-content-ilink-syntax' => '[[გვერდის სათაური|ბმულის წარწერა]]<br />[[გვერდის სათაური]]',
	'wikieditor-toolbar-help-content-ilink-result' => "<a href='#'>ბმულის ტექსტი</a><br /><a href='#'>გვერდის სათაური</a>",
	'wikieditor-toolbar-help-content-xlink-description' => 'გარე ბმული',
	'wikieditor-toolbar-help-content-xlink-syntax' => '[http://www.example.org ბმულის წარწერა]<br />[http://www.example.org]<br />http://www.example.org',
	'wikieditor-toolbar-help-content-xlink-result' => "<a href='#' class='external'>ბმულის წარწერა</a><br /><a href='#' class='external autonumber'>[1]</a><br /><a href='#' class='external'>http://www.example.org</a>",
	'wikieditor-toolbar-help-content-heading2-description' => 'მე-2&nbsp;დონის სათაური',
	'wikieditor-toolbar-help-content-heading2-syntax' => '== სათაურის ტექსტი ==',
	'wikieditor-toolbar-help-content-heading2-result' => '<h2>სათაურის ტექსტი</h2>',
	'wikieditor-toolbar-help-content-heading3-description' => 'მე-3&nbsp;დონის საათაური',
	'wikieditor-toolbar-help-content-heading3-syntax' => '=== სათაურის ტექსტი ===',
	'wikieditor-toolbar-help-content-heading3-result' => '<h3>სათაურის ტექსტი</h3>',
	'wikieditor-toolbar-help-content-heading4-description' => 'მე-4&nbsp; დონის სათაური',
	'wikieditor-toolbar-help-content-heading4-syntax' => '==== სათაურის ტექსტი ====',
	'wikieditor-toolbar-help-content-heading4-result' => '<h4>სათაურის ტექსტი</h4>',
	'wikieditor-toolbar-help-content-heading5-description' => 'მე-5&nbsp; დონის სათაური',
	'wikieditor-toolbar-help-content-heading5-syntax' => '===== სათაურის ტექსტი =====',
	'wikieditor-toolbar-help-content-heading5-result' => '<h5>სათაურის ტექსტი</h5>',
	'wikieditor-toolbar-help-content-ulist-description' => 'მარკირებული სია',
	'wikieditor-toolbar-help-content-ulist-syntax' => '* სიის ელემენტი<br />* სიის ელემენტი',
	'wikieditor-toolbar-help-content-ulist-result' => '<ul><li>სიის ელემენტი</li><li>სიის ელემენტი</li></ul>',
	'wikieditor-toolbar-help-content-olist-description' => 'დანომრილი სია',
	'wikieditor-toolbar-help-content-olist-syntax' => '#სიის ელემენტი<br /># სიის ელემენტი',
	'wikieditor-toolbar-help-content-olist-result' => '<ol><li>სიის ელემენტი</li><li>სიის ელემენტი</li></ol>',
	'wikieditor-toolbar-help-content-file-description' => 'ჩასმული ფაილი',
	'wikieditor-toolbar-help-content-file-syntax' => '[[$1:Example.png|thumb|წარწერის ტექსტი]]',
	'wikieditor-toolbar-help-content-file-result' => "<div style='width:104px;' class='thumbinner'><a title='წარწერის ტექსტი' class='image' href='#'><img height='50' width='100' border='0' class='thumbimage' src='$2/WikiEditor/modules/images/toolbar/example-image.png' alt=''/></a><div class='thumbcaption'><div class='magnify'><a title='Enlarge' class='internal' href='#'><img height='11' width='15' alt='' src='$1/common/images/magnify-clip.png'/></a></div>წარწერის ტექსტი</div></div>",
	'wikieditor-toolbar-help-content-reference-description' => 'მინიშნება',
	'wikieditor-toolbar-help-content-reference-syntax' => 'გვერდის ტექსტი&lt;ref name="test"&gt;[http://www.example.org ბმულის ტექსტი], დამატებითი ტექსტი.&lt;/ref&gt;.',
	'wikieditor-toolbar-help-content-reference-result' => "გვერდის ტექსტი<sup><a href='#'>[1]</a></sup>.",
	'wikieditor-toolbar-help-content-rereference-description' => 'იგივე მინიშნების დამატებითი გამოყენება',
	'wikieditor-toolbar-help-content-rereference-result' => "გვერდის ტექსტი<sup><a href='#'>[1]</a></sup>.",
	'wikieditor-toolbar-help-content-showreferences-description' => 'სქოლიოს ჩვენება',
	'wikieditor-toolbar-help-content-showreferences-result' => "<ol class='references'><li id='cite_note-test-0'><b><a title='' href='#'>^</a></b> <a rel='nofollow' title='http://www.example.org' class='external text' href='#'>ბმულის ტექსტი</a>, დამატებითი ტექსტი.</li></ol>",
	'wikieditor-toolbar-help-content-signaturetimestamp-description' => 'ხელმოწერა დროის მითითებით',
	'wikieditor-toolbar-help-content-signaturetimestamp-result' => "<a href='#' title='{{#special:mypage}}'>მომხმარებლის სახელი</a> (<a href='#' title='{{#special:mytalk}}'>განხილვა</a>) 15:54, 10 ივნისი 2009 (UTC)",
	'wikieditor-toolbar-help-content-signature-description' => 'ხელმოწერა',
	'wikieditor-toolbar-help-content-signature-result' => "<a href='#' title='{{#special:mypage}}'>მომხმარებლის სახელი</a> (<a href='#' title='{{#special:mytalk}}'>განხილვა</a>)",
	'wikieditor-toolbar-help-content-indent-description' => 'შეწევა',
	'wikieditor-toolbar-help-content-indent-syntax' => 'ჩვეულებრივი ტექსტი<br />:შეწეული ტექსტი<br />::შეწეული ტექსტი',
	'wikieditor-toolbar-help-content-indent-result' => 'ჩვეულებრივი ტექსტი<dl><dd>შეწეული ტექსტი<dl><dd>შეწეული ტექსტი</dd></dl></dd></dl>',
);

/** Адыгэбзэ (Адыгэбзэ)
 * @author Bogups
 */
$messages['kbd-cyrl'] = array(
	'wikieditor-toolbar-tool-reference' => 'ЩӀэупӀщӀэгъуэ',
	'wikieditor-toolbar-section-advanced' => 'Нэхъыбу',
	'wikieditor-toolbar-section-characters' => 'Дэмыгъэ специалхэр',
);

/** Kirmanjki (Kırmancki)
 * @author Mirzali
 */
$messages['kiu'] = array(
	'wikieditor-toolbar-tool-link' => 'Girê',
);

/** Kazakh (Cyrillic script) (қазақша (кирил)‎)
 * @author GaiJin
 * @author Kaztrans
 */
$messages['kk-cyrl'] = array(
	'wikieditor' => 'Уикимәтінді өңдеудің кеңейтілген интерфейсі',
	'wikieditor-wikitext-tab' => 'Уикимәтін',
	'wikieditor-loading' => 'Күте тұр...',
	'wikieditor-preview-tab' => 'Қарап шығу',
	'wikieditor-preview-changes-tab' => 'Өзгерістер',
	'wikieditor-preview-loading' => 'Күте тұр...',
	'wikieditor-previewDialog-tab' => 'Қарап шығу',
	'wikieditor-previewDialog-loading' => 'Күте тұр...',
	'wikieditor-publish-button-publish' => 'Жариялау',
	'wikieditor-publish-button-cancel' => 'Болдырмау',
	'wikieditor-publish-dialog-minor' => 'Шағын өңдеме',
	'wikieditor-publish-dialog-watch' => 'Бұл бетті бақылау',
	'wikieditor-publish-dialog-publish' => 'Жариялау',
	'wikieditor-publish-dialog-goback' => 'Артқа',
	'wikieditor-template-editor-dialog-submit' => 'Жаңарту',
	'wikieditor-template-editor-dialog-cancel' => 'Болдырмау',
	'wikieditor-toolbar' => 'Өңдеу жақтауы',
	'wikieditor-toolbar-loading' => 'Жүктеуде…',
	'wikieditor-toolbar-tool-bold' => 'Жуан жазу',
	'wikieditor-toolbar-tool-bold-example' => 'Жуан мәтін',
	'wikieditor-toolbar-tool-italic' => 'Көлбеу мәтін',
	'wikieditor-toolbar-tool-italic-example' => 'Көлбеу мәтін',
	'wikieditor-toolbar-tool-ilink' => 'Ішкі сілтеме',
	'wikieditor-toolbar-tool-ilink-example' => 'Сілтеме тақырыбы',
	'wikieditor-toolbar-tool-xlink' => 'Сыртқы сілтеме (алдына http:// енгізуін ұмытпаңыз)',
	'wikieditor-toolbar-tool-xlink-example' => 'http://www.example.com сілтеме тақырыбы',
	'wikieditor-toolbar-tool-link' => 'Сілтеме',
	'wikieditor-toolbar-tool-link-title' => 'Сілтеме қою',
	'wikieditor-toolbar-tool-link-int' => 'уики бетіне бару',
	'wikieditor-toolbar-tool-link-int-text' => 'Көрсетілетін мәтін:',
	'wikieditor-toolbar-tool-link-insert' => 'Сілтеме енгізу',
	'wikieditor-toolbar-tool-link-cancel' => 'Болдырмау',
	'wikieditor-toolbar-tool-link-int-target-status-exists' => 'Бұл бет бар',
	'wikieditor-toolbar-tool-link-int-target-status-notexists' => 'Бұл бет жоқ',
	'wikieditor-toolbar-tool-link-int-target-status-invalid' => 'Жарамайтын атау',
	'wikieditor-toolbar-tool-link-int-target-status-external' => 'Сыртқы сілтеме',
	'wikieditor-toolbar-tool-link-int-target-status-loading' => 'Беттің бар-жоғын тексеру…',
	'wikieditor-toolbar-tool-link-lookslikeinternal-int' => 'Ішкі сілтеме',
	'wikieditor-toolbar-tool-link-lookslikeinternal-ext' => 'Сыртқы сілтеме',
	'wikieditor-toolbar-tool-file' => 'Файл орнату',
	'wikieditor-toolbar-tool-reference' => 'Дереккөз',
	'wikieditor-toolbar-tool-reference-cancel' => 'Болдырмау',
	'wikieditor-toolbar-tool-reference-title' => 'Дереккөз енгізу',
	'wikieditor-toolbar-tool-reference-insert' => 'Енгізу',
	'wikieditor-toolbar-tool-reference-text' => 'Дереккөз мәтіні',
	'wikieditor-toolbar-tool-signature' => 'Қолтаңба және уақыт',
	'wikieditor-toolbar-section-advanced' => 'Кеңейтілген',
	'wikieditor-toolbar-tool-heading' => 'Бөлім',
	'wikieditor-toolbar-tool-heading-1' => '1 деңгей',
	'wikieditor-toolbar-tool-heading-2' => '2 деңгей',
	'wikieditor-toolbar-tool-heading-3' => '3 деңгей',
	'wikieditor-toolbar-tool-heading-4' => '4 деңгей',
	'wikieditor-toolbar-tool-heading-5' => '5 деңгей',
	'wikieditor-toolbar-tool-heading-example' => 'Бөлім тақырыбы',
	'wikieditor-toolbar-group-format' => 'Пішім',
	'wikieditor-toolbar-tool-ulist' => 'Таңбаланған тізім',
	'wikieditor-toolbar-tool-ulist-example' => 'Таңбаланған тізім элементі',
	'wikieditor-toolbar-tool-olist' => 'Нөмірленген тізім',
	'wikieditor-toolbar-tool-olist-example' => 'Нөмірленген тізім элементі',
	'wikieditor-toolbar-tool-indent' => 'Шегініс',
	'wikieditor-toolbar-tool-indent-example' => 'Шегінген жол',
	'wikieditor-toolbar-tool-nowiki' => 'Уики-форматтауды елемеу',
	'wikieditor-toolbar-tool-nowiki-example' => 'Форматтауды қажет етпейтін мәтінді мында енгізіңіз',
	'wikieditor-toolbar-tool-redirect' => 'Айдау',
	'wikieditor-toolbar-tool-big' => 'Ірі жазу',
	'wikieditor-toolbar-tool-big-example' => 'Ірі жазу',
	'wikieditor-toolbar-tool-small' => 'Кішірек жазу',
	'wikieditor-toolbar-tool-small-example' => 'Кішірек жазу',
	'wikieditor-toolbar-tool-superscript' => 'Үстіңгі жазу',
	'wikieditor-toolbar-tool-superscript-example' => 'Үстіңгі жазу',
	'wikieditor-toolbar-tool-subscript' => 'Астыңғы жазу',
	'wikieditor-toolbar-tool-subscript-example' => 'Астыңғы жазу',
	'wikieditor-toolbar-group-insert' => 'Енгізу',
	'wikieditor-toolbar-tool-gallery' => 'Сурет галереясы',
	'wikieditor-toolbar-tool-gallery-example' => '$1:Example.jpg|Сипаттамасы1
$1:Example.jpg|Сипаттамасы2',
	'wikieditor-toolbar-tool-newline' => 'Жаңа жол',
	'wikieditor-toolbar-tool-table' => 'Кесте',
	'wikieditor-toolbar-tool-table-example-old' => '! тақырыпша 1
! тақырыпша 2
! тақырыпша 3
|-
| жол 1, ұяшық 1
| жол 1, ұяшық 2
| жол 1, ұяшық 3
|-
| жол 2, ұяшық 1
| жол 2, ұяшық 2
| жол 2, ұяшық 3',
	'wikieditor-toolbar-tool-table-example-cell-text' => 'Ұяшық мәтіні',
	'wikieditor-toolbar-tool-table-example-header' => 'Тақырыпша мәтіні',
	'wikieditor-toolbar-tool-table-title' => 'Кесте енгізу',
	'wikieditor-toolbar-tool-table-dimensions-rows' => 'Жолдар',
	'wikieditor-toolbar-tool-table-dimensions-columns' => 'Бағандар',
	'wikieditor-toolbar-tool-table-dimensions-header' => 'Тақырыпша жолағын қосу',
	'wikieditor-toolbar-tool-table-wikitable' => 'Кестені шекарасымен жасау',
	'wikieditor-toolbar-tool-table-sortable' => 'Сұрыпталмалы кесте жасау',
	'wikieditor-toolbar-tool-table-example' => 'Ұяшық мәтіні',
	'wikieditor-toolbar-tool-table-preview' => 'Қарап шығу',
	'wikieditor-toolbar-tool-table-insert' => 'Енгізу',
	'wikieditor-toolbar-tool-table-cancel' => 'Болдырмау',
	'wikieditor-toolbar-tool-replace' => 'Іздеу және алмастыру',
	'wikieditor-toolbar-tool-replace-title' => 'Іздеу және алмастыру',
	'wikieditor-toolbar-tool-replace-search' => 'Іздеу:',
	'wikieditor-toolbar-tool-replace-replace' => 'Мына сөзбен алмастыру:',
	'wikieditor-toolbar-tool-replace-case' => 'Әріп регистрін ескеру',
	'wikieditor-toolbar-tool-replace-regex' => 'Іздеу жолағын жүйелі әрекет ретінде қарастыру',
	'wikieditor-toolbar-tool-replace-button-findnext' => 'Келесін іздеу',
	'wikieditor-toolbar-tool-replace-button-replace' => 'Алмастыру',
	'wikieditor-toolbar-tool-replace-button-replaceall' => 'Барлығын алмастыру',
	'wikieditor-toolbar-tool-replace-close' => 'Жабу',
	'wikieditor-toolbar-tool-replace-nomatch' => 'Сіздің сұрауыңыз бойынша еш нәрсе табылмады.',
	'wikieditor-toolbar-tool-replace-success' => '$1 алмастыру жасалды.',
	'wikieditor-toolbar-section-characters' => 'Арнайы таңбалар',
	'wikieditor-toolbar-characters-page-latin' => 'Латын',
	'wikieditor-toolbar-characters-page-symbols' => 'Белгілер',
	'wikieditor-toolbar-section-help' => 'Анықтама',
	'wikieditor-toolbar-help-heading-description' => 'Сипаттамасы',
	'wikieditor-toolbar-help-content-italic-description' => 'Көлбеу жазу',
	'wikieditor-toolbar-help-content-italic-syntax' => "''Көлбеу мәтін''",
	'wikieditor-toolbar-help-content-italic-result' => '<em>Көлбеу мәтін</em>',
	'wikieditor-toolbar-help-content-bold-description' => 'Жуан жазу',
	'wikieditor-toolbar-help-content-bold-syntax' => "'''Жуан мәтін'''",
	'wikieditor-toolbar-help-content-bold-result' => '<strong>Жуан мәтін</strong>',
	'wikieditor-toolbar-help-content-bolditalic-description' => 'Жуан көлбеу жазу',
	'wikieditor-toolbar-help-content-bolditalic-syntax' => "'''''Жуан көлбеу мәтін'''''",
	'wikieditor-toolbar-help-content-bolditalic-result' => '<strong><em>Жуан көлбеу мәтін</em></strong>',
	'wikieditor-toolbar-help-content-ilink-description' => 'Ішкі сілтеме',
	'wikieditor-toolbar-help-content-xlink-description' => 'Сыртқы сілтеме',
	'wikieditor-toolbar-help-content-heading2-description' => '2-ші деңгейлі бөлім',
	'wikieditor-toolbar-help-content-heading2-syntax' => '== Бөлім мәтіні ==',
	'wikieditor-toolbar-help-content-heading2-result' => '<h2>Бөлім мәтіні</h2>',
	'wikieditor-toolbar-help-content-heading3-description' => '3-ші деңгейлі бөлім',
	'wikieditor-toolbar-help-content-heading3-syntax' => '=== Бөлім мәтіні ===',
	'wikieditor-toolbar-help-content-heading3-result' => '<h3>Бөлім мәтіні</h3>',
	'wikieditor-toolbar-help-content-heading4-description' => '4-ші деңгейлі бөлім',
	'wikieditor-toolbar-help-content-heading4-syntax' => '==== Бөлім мәтіні ====',
	'wikieditor-toolbar-help-content-heading4-result' => '<h4>Бөлім мәтіні</h4>',
	'wikieditor-toolbar-help-content-heading5-description' => '5-ші деңгейлі бөлім',
	'wikieditor-toolbar-help-content-heading5-syntax' => '===== Бөлім мәтіні =====',
	'wikieditor-toolbar-help-content-heading5-result' => '<h5>Бөлім мәтіні</h5>',
	'wikieditor-toolbar-help-content-ulist-description' => 'Таңбаланған тізім',
	'wikieditor-toolbar-help-content-olist-description' => 'Нөмірленген тізім',
	'wikieditor-toolbar-help-content-file-description' => 'Файл орнату',
	'wikieditor-toolbar-help-content-file-syntax' => '[[$1:Example.png|thumb|Файл тақырыбы]]',
	'wikieditor-toolbar-help-content-reference-description' => 'Дереккөз',
	'wikieditor-toolbar-help-content-showreferences-description' => 'Дереккөзін көрсету',
	'wikieditor-toolbar-help-content-signaturetimestamp-description' => 'Қолтаңба және уақыт',
	'wikieditor-toolbar-help-content-signature-description' => 'Қолтаңба',
	'wikieditor-toolbar-help-content-indent-description' => 'Шегініс',
);

/** Khmer (ភាសាខ្មែរ)
 * @author គីមស៊្រុន
 */
$messages['km'] = array(
	'wikieditor' => 'អន្តរមុខសំរាប់កែប្រែអត្ថបទវិគីថ្នាក់ខ្ពស់',
	'wikieditor-wikitext-tab' => 'អត្ថបទវិគី',
	'wikieditor-loading' => 'កំពុងផ្ទុក',
	'wikieditor-preview-preference' => 'ប្រើការមើលមុខផ្ទឹមគ្នា',
	'wikieditor-preview-tab' => 'ការមើលមុន',
	'wikieditor-preview-changes-tab' => 'បំលាស់ប្ដូរ',
	'wikieditor-preview-loading' => 'កំពុងផ្ទុក…',
	'wikieditor-previewDialog-tab' => 'ការមើលមុន',
	'wikieditor-previewDialog-loading' => 'កំពុងផ្ទុក…',
	'wikieditor-publish-preference' => 'ប្រើការផ្សព្វផ្យាយជាដំណាក់ៗ',
	'wikieditor-publish-button-publish' => 'បោះផ្សាយ',
	'wikieditor-publish-button-cancel' => 'បោះបង់',
	'wikieditor-publish-dialog-title' => 'បោះផ្សាយក្នុង{{SITENAME}}',
	'wikieditor-publish-dialog-summary' => 'ចំណារពន្យល់ (រៀបរាប់ដោយសង្ខេបពីកំណែប្រែដែលអ្នកបានធ្វើឡើង)៖',
	'wikieditor-publish-dialog-minor' => 'កំណែប្រែតិចតួច',
	'wikieditor-publish-dialog-watch' => 'តាមដាន​ទំព័រនេះ',
	'wikieditor-publish-dialog-publish' => 'បោះផ្សាយ',
	'wikieditor-publish-dialog-goback' => 'ត្រឡប់​ក្រោយ',
	'wikieditor-template-editor-dialog-submit' => 'ធ្វើឱ្យទាន់សម័យ',
	'wikieditor-template-editor-dialog-cancel' => 'បោះបង់',
	'wikieditor-toc-show' => 'បង្ហាញខ្លឺមសារ',
	'wikieditor-toc-hide' => 'លាក់ខ្លឹមសារ',
	'wikieditor-toolbar' => 'របារឧបករណ៍កែប្រែ',
	'wikieditor-toolbar-preference' => 'ប្រើរបារឧបករណ៍កែប្រែទំនើប',
	'wikieditor-toolbar-dialogs-preference' => 'ប្រើផ្ទាំងពិសេសសំរាប់បញ្ចូលតំណភ្ជាប់ តារាង ជាដើម',
	'wikieditor-toolbar-loading' => 'កំពុងផ្ទុក…',
	'wikieditor-toolbar-tool-bold' => 'អក្សរដិត',
	'wikieditor-toolbar-tool-bold-example' => 'អត្ថបទជាអក្សរដិត',
	'wikieditor-toolbar-tool-italic' => 'អក្សរទ្រេត',
	'wikieditor-toolbar-tool-italic-example' => 'អត្ថបទជាអក្សរទ្រេត',
	'wikieditor-toolbar-tool-ilink' => 'តំណភ្ជាប់​ខាងក្នុង',
	'wikieditor-toolbar-tool-ilink-example' => 'ចំណងជើង​តំណភ្ជាប់',
	'wikieditor-toolbar-tool-xlink' => 'តំណភ្ជាប់​ខាងក្រៅ (កុំភ្លេច​ដាក់ http:// នៅពីមុខ)',
	'wikieditor-toolbar-tool-xlink-example' => 'http://www.example.com ចំណងជើង​តំណភ្ជាប់',
	'wikieditor-toolbar-tool-link' => 'តំណ​ភ្ជាប់',
	'wikieditor-toolbar-tool-link-title' => 'បញ្ចូលតំណភ្ជាប់',
	'wikieditor-toolbar-tool-link-int' => 'ទៅកាន់ទំព័រក្នុងវិគី',
	'wikieditor-toolbar-tool-link-int-target' => 'ទំព័រគោលដៅឬURL៖',
	'wikieditor-toolbar-tool-link-int-target-tooltip' => 'ចំណងជើងទំព័រឫURL',
	'wikieditor-toolbar-tool-link-int-text' => 'ពាក្យដែលត្រូវបង្ហាញ៖',
	'wikieditor-toolbar-tool-link-int-text-tooltip' => 'ពាក្យដែលត្រូវបង្ហាញ',
	'wikieditor-toolbar-tool-link-ext' => 'ទៅកាន់ទំព័រវិបសាយខាងក្រៅ',
	'wikieditor-toolbar-tool-link-ext-target' => 'តំណភ្ជាប់URL',
	'wikieditor-toolbar-tool-link-ext-text' => 'ពាក្យត្រូវដាក់តំណភ្ជាប់៖',
	'wikieditor-toolbar-tool-link-insert' => 'បញ្ចូលតំណភ្ជាប់',
	'wikieditor-toolbar-tool-link-cancel' => 'បោះបង់​',
	'wikieditor-toolbar-tool-link-int-target-status-exists' => 'ទំព័រ​មានរួចហើយ',
	'wikieditor-toolbar-tool-link-int-target-status-notexists' => 'ទំព័រមិនទាន់មាន',
	'wikieditor-toolbar-tool-link-int-target-status-invalid' => 'ចំណងជើងមិនត្រឹមត្រូវ',
	'wikieditor-toolbar-tool-link-int-target-status-external' => 'តំណភ្ជាប់​ខាងក្រៅ',
	'wikieditor-toolbar-tool-link-int-target-status-loading' => 'កំពុងពិនិត្យថាតើទំព័រមានហើយឫនៅ...',
	'wikieditor-toolbar-tool-link-int-invalid' => 'ចំណងជើងដែលអ្នកបានផ្ដល់អោយមិនត្រឹមត្រូវទេ',
	'wikieditor-toolbar-tool-link-lookslikeinternal' => 'URLដែលអ្នកបានផ្ដល់អោយ ទំនងជាតំណភ្ជាប់ទៅកាន់ទំព័រមួយទៀតក្នុងវិគី។

តើអ្នកចង់ប្ដូរវាជាតំណភ្ជាប់ខាងក្នុងវិញទេ?',
	'wikieditor-toolbar-tool-link-lookslikeinternal-int' => 'តំណភ្ជាប់​ខាងក្នុង',
	'wikieditor-toolbar-tool-link-lookslikeinternal-ext' => 'តំណភ្ជាប់​ខាងក្រៅ',
	'wikieditor-toolbar-tool-link-empty' => 'អ្នកមិនបានវាយបញ្ចូលពាក្យសំរាប់ដាក់តំណភ្ជាប់ទេ។',
	'wikieditor-toolbar-tool-file' => 'រូបភាពបង្កប់',
	'wikieditor-toolbar-tool-file-example' => 'ឧទាហរណ៍.jpg',
	'wikieditor-toolbar-tool-reference' => 'ឯកសារយោង',
	'wikieditor-toolbar-tool-reference-example' => 'បញ្ចូលអត្ថបទយោងនៅទីនេះ',
	'wikieditor-toolbar-tool-reference-cancel' => 'បោះបង់',
	'wikieditor-toolbar-tool-reference-title' => 'បញ្ចូលឯកសារយោង',
	'wikieditor-toolbar-tool-reference-insert' => 'បញ្ចូល',
	'wikieditor-toolbar-tool-reference-text' => 'អត្ថបទយោង',
	'wikieditor-toolbar-tool-signature' => 'ហត្ថលេខា​និងកាលបរិច្ឆេទ',
	'wikieditor-toolbar-section-advanced' => 'ថ្នាក់ខ្ពស់',
	'wikieditor-toolbar-tool-heading' => 'កូនចំណងជើង',
	'wikieditor-toolbar-tool-heading-1' => 'កំរិត១',
	'wikieditor-toolbar-tool-heading-2' => 'កំរិត២',
	'wikieditor-toolbar-tool-heading-3' => 'កំរិត៣',
	'wikieditor-toolbar-tool-heading-4' => 'កំរិត៤',
	'wikieditor-toolbar-tool-heading-5' => 'កំរិត៥',
	'wikieditor-toolbar-tool-heading-example' => 'អត្ថបទកូនចំណងជើង',
	'wikieditor-toolbar-group-format' => 'ទំរង់',
	'wikieditor-toolbar-tool-ulist' => 'បញ្ជីផ្ដើមដោយត្រេ',
	'wikieditor-toolbar-tool-ulist-example' => 'ធាតុរបស់បញ្ជីផ្ដើមដោយត្រេ',
	'wikieditor-toolbar-tool-olist' => 'បញ្ជីផ្ដើមដោយលេខរៀង',
	'wikieditor-toolbar-tool-olist-example' => 'ធាតុរបស់បញ្ជីផ្ដើមដោយលេខរៀង',
	'wikieditor-toolbar-tool-indent' => 'ចូលបន្ទាត់',
	'wikieditor-toolbar-tool-indent-example' => 'ជួរចូលបន្ទាត់',
	'wikieditor-toolbar-tool-nowiki' => 'មិនមានទំរង់វិគី',
	'wikieditor-toolbar-tool-nowiki-example' => 'បញ្ចូល​អត្ថបទគ្មានទម្រង់​នៅទីនេះ',
	'wikieditor-toolbar-tool-redirect' => 'បញ្ជូនបន្ត',
	'wikieditor-toolbar-tool-redirect-example' => 'ទំព័រគោលដៅ',
	'wikieditor-toolbar-tool-big' => 'ធំ',
	'wikieditor-toolbar-tool-big-example' => 'អត្ថបទធំ',
	'wikieditor-toolbar-tool-small' => 'តូច',
	'wikieditor-toolbar-tool-small-example' => 'អត្ថបទតូច',
	'wikieditor-toolbar-tool-superscript' => 'និទស្សន្តន៍',
	'wikieditor-toolbar-tool-superscript-example' => 'ឃ្លាជានិទស្សន្តន៍',
	'wikieditor-toolbar-tool-subscript' => 'សន្ទស្សន៍',
	'wikieditor-toolbar-tool-subscript-example' => 'ឃ្លាជាសន្ទស្សន៍',
	'wikieditor-toolbar-group-insert' => 'បញ្ជូល',
	'wikieditor-toolbar-tool-gallery' => 'វិចិត្រសាលរូបភាព',
	'wikieditor-toolbar-tool-gallery-example' => '$1:ឧទាហរណ៍.jpg|ចំនងជើងក្រោមរូបភាព១

$1:ឧទាហរណ៍.jpg|ចំនងជើងក្រោមរូបភាព២',
	'wikieditor-toolbar-tool-newline' => 'ចុះបន្ទាត់',
	'wikieditor-toolbar-tool-table' => 'តារាង',
	'wikieditor-toolbar-tool-table-example-old' => '-
! ឈ្មោះជួរឈរ 1
! ឈ្មោះជួរឈរ 2
! ឈ្មោះជួរឈរ 3
|-
| ជួរដេក 1, ប្រអប់ 1
| ជួរដេក 1, ប្រអប់ 2
| ជួរដេក 1, ប្រអប់ 3
|-
| ជួរដេក 2, ប្រអប់ 1
| ជួរដេក 2, ប្រអប់ 2
| ជួរដេក 2, ប្រអប់ 3',
	'wikieditor-toolbar-tool-table-example-cell-text' => 'អត្ថបទក្នុងប្រអប់',
	'wikieditor-toolbar-tool-table-example-header' => 'ឈ្មោះជួរឈរ',
	'wikieditor-toolbar-tool-table-title' => 'បញ្ចូលតារាង',
	'wikieditor-toolbar-tool-table-dimensions-rows' => 'ជួរដេក',
	'wikieditor-toolbar-tool-table-dimensions-columns' => 'ជួរឈរ',
	'wikieditor-toolbar-tool-table-dimensions-header' => 'បន្ថែមជេរដេកឈ្មោះជួរឈរ',
	'wikieditor-toolbar-tool-table-wikitable' => 'រចនាបថមានស៊ុមព័ទ្ធជុំវិញ',
	'wikieditor-toolbar-tool-table-sortable' => 'ធ្វើតារាងដែលអាចធ្វើការតំរៀបតាមអក្ខរក្រមបាន',
	'wikieditor-toolbar-tool-table-example' => 'ឧទាហរណ៍',
	'wikieditor-toolbar-tool-table-preview' => 'មើលជាមុន',
	'wikieditor-toolbar-tool-table-insert' => 'បញ្ចូល',
	'wikieditor-toolbar-tool-table-cancel' => 'បោះបង់​',
	'wikieditor-toolbar-tool-table-invalidnumber' => 'អ្នកមិនបានបញ្ចូលចំនួនជួរដេកនិងជួរឈរបានត្រឹមត្រូវទេ។',
	'wikieditor-toolbar-tool-table-zero' => 'អ្នកមិនអាចបញ្ចូលតារាងដែលមានជួរដេកឬជួរឈរចំនួនសូន្យបានទេ។',
	'wikieditor-toolbar-tool-replace' => 'ស្វែងរកនិងជំនួស',
	'wikieditor-toolbar-tool-replace-title' => 'ស្វែងរកនិងជំនួស',
	'wikieditor-toolbar-tool-replace-search' => 'ស្វែងរក៖',
	'wikieditor-toolbar-tool-replace-replace' => 'ជំនួសដោយ៖',
	'wikieditor-toolbar-tool-replace-button-findnext' => 'រុករក​បន្ទាប់​',
	'wikieditor-toolbar-tool-replace-button-replace' => 'ជំនួស',
	'wikieditor-toolbar-tool-replace-button-replaceall' => 'ជំនួសទាំងអស់',
	'wikieditor-toolbar-tool-replace-close' => 'បិទ',
	'wikieditor-toolbar-tool-replace-nomatch' => 'រកមិនឃើញអ្វីដែលអ្នកចង់រកទេ។',
	'wikieditor-toolbar-tool-replace-success' => 'បានធ្វើការជំនួសចំនួន $1។',
	'wikieditor-toolbar-tool-replace-emptysearch' => 'អ្នកមិនបានវាយបញ្ចូលពាក្យសំរាប់ស្វែងរកទេ។',
	'wikieditor-toolbar-section-characters' => 'តួអក្សរពិសេសៗ',
	'wikieditor-toolbar-characters-page-latin' => 'អក្សរឡាតាំង',
	'wikieditor-toolbar-characters-page-latinextended' => 'អក្សរឡាតាំងផ្សេងទៀត',
	'wikieditor-toolbar-characters-page-ipa' => 'អក្ខរក្រមសំលេងអន្តរជាតិ',
	'wikieditor-toolbar-characters-page-symbols' => 'សញ្ញា',
	'wikieditor-toolbar-characters-page-greek' => 'អក្សរក្រិច',
	'wikieditor-toolbar-characters-page-cyrillic' => 'អក្សរស៊ីរីល',
	'wikieditor-toolbar-characters-page-arabic' => 'អក្សរអារ៉ាប់',
	'wikieditor-toolbar-characters-page-arabicextended' => 'អក្សរអារ៉ាប់បន្ថែម',
	'wikieditor-toolbar-characters-page-persian' => 'អក្សរពែក្ស',
	'wikieditor-toolbar-characters-page-hebrew' => 'អក្សរហេប៊្រូ',
	'wikieditor-toolbar-characters-page-bangla' => 'អក្សរបេងក្លា',
	'wikieditor-toolbar-characters-page-telugu' => 'អក្សរតិលគ្គ',
	'wikieditor-toolbar-characters-page-sinhala' => 'អក្សរស៊ិនហាឡា',
	'wikieditor-toolbar-characters-page-gujarati' => 'អក្សរគុចរទី',
	'wikieditor-toolbar-characters-page-thai' => 'អក្សរថៃ',
	'wikieditor-toolbar-characters-page-lao' => 'អក្សរឡាវ',
	'wikieditor-toolbar-characters-page-khmer' => 'អក្សរខ្មែរ',
	'wikieditor-toolbar-section-help' => 'ជំនួយ',
	'wikieditor-toolbar-help-heading-description' => 'ការពិពណ៌នា',
	'wikieditor-toolbar-help-heading-syntax' => 'អ្វីដែលអ្នកវាយបញ្ចូល',
	'wikieditor-toolbar-help-heading-result' => 'អ្វីដែលអ្នកបាន',
	'wikieditor-toolbar-help-page-format' => 'ទំរង់ទ្រង់ទ្រាយ',
	'wikieditor-toolbar-help-page-link' => 'តំណភ្ជាប់',
	'wikieditor-toolbar-help-page-heading' => 'កូនចំនងជើង',
	'wikieditor-toolbar-help-page-list' => 'បញ្ជី',
	'wikieditor-toolbar-help-page-file' => 'ឯកសារ',
	'wikieditor-toolbar-help-page-reference' => 'ឯកសារយោង',
	'wikieditor-toolbar-help-page-discussion' => 'ការពិភាក្សា',
	'wikieditor-toolbar-help-content-italic-description' => 'អក្សរទ្រេត',
	'wikieditor-toolbar-help-content-italic-syntax' => "''អត្ថបទជាអក្សរទ្រេត''",
	'wikieditor-toolbar-help-content-italic-result' => '<em>អត្ថបទជាអក្សរទ្រេត</em>',
	'wikieditor-toolbar-help-content-bold-description' => 'អក្សរដិត',
	'wikieditor-toolbar-help-content-bold-syntax' => "'''អត្ថបទជាអក្សរដិត'''",
	'wikieditor-toolbar-help-content-bold-result' => '<strong>អត្ថបទជាអក្សរដិត</strong>',
	'wikieditor-toolbar-help-content-bolditalic-description' => 'អក្សរដិត &amp; ទ្រេត',
	'wikieditor-toolbar-help-content-bolditalic-syntax' => "'''''អត្ថបទជាអក្សរដិត &amp; ទ្រេត'''''",
	'wikieditor-toolbar-help-content-bolditalic-result' => '<strong><em>អត្ថបទជាអក្សរដិត &amp; ទ្រេត</em></strong>',
	'wikieditor-toolbar-help-content-ilink-description' => 'តំណភ្ជាប់​ខាងក្នុង',
	'wikieditor-toolbar-help-content-ilink-syntax' => '[[ចំនងជើងទំព័រ|ប្លាកសំគាល់តំនភ្ជាប់]]<br />[[ចំនងជើងទំព័រ]]',
	'wikieditor-toolbar-help-content-ilink-result' => "<a href='#'>ប្លាកសំគាល់តំនភ្ជាប់</a><br /><a href='#'>ចំនងជើងទំព័រ</a>",
	'wikieditor-toolbar-help-content-xlink-description' => 'តំណភ្ជាប់​ខាងក្រៅ',
	'wikieditor-toolbar-help-content-xlink-syntax' => '[http://www.ឧទាហរណ៍.org ប្លាកសំគាល់តំនភ្ជាប់]<br />[http://www.ឧទាហរណ៍.org]<br />http://www.ឧទាហរណ៍.org',
	'wikieditor-toolbar-help-content-xlink-result' => "<a href='#' class='external'>ប្លាកសំគាល់តំនភ្ជាប់</a><br /><a href='#' class='external autonumber'>[1]</a><br /><a href='#' class='external'>http://www.ឧទាហរណ៍.org</a>",
	'wikieditor-toolbar-help-content-heading2-description' => 'កូនចំនងជើងកំរិត២',
	'wikieditor-toolbar-help-content-heading2-syntax' => '== កូនចំនងជើង ==',
	'wikieditor-toolbar-help-content-heading2-result' => '<h2>កូនចំនងជើង</h2>',
	'wikieditor-toolbar-help-content-heading3-description' => 'កូនចំនងជើងកំរិត៣',
	'wikieditor-toolbar-help-content-heading3-syntax' => '=== កូនចំនងជើង ===',
	'wikieditor-toolbar-help-content-heading3-result' => '<h3>កូនចំនងជើង</h3>',
	'wikieditor-toolbar-help-content-heading4-description' => 'កូនចំនងជើងកំរិត៤',
	'wikieditor-toolbar-help-content-heading4-syntax' => '==== កូនចំនងជើង ====',
	'wikieditor-toolbar-help-content-heading4-result' => '<h4>កូនចំនងជើង</h4>',
	'wikieditor-toolbar-help-content-heading5-description' => 'កូនចំនងជើងកំរិត៥',
	'wikieditor-toolbar-help-content-heading5-syntax' => '===== កូនចំនងជើង =====',
	'wikieditor-toolbar-help-content-heading5-result' => '<h5>កូនចំនងជើង</h5>',
	'wikieditor-toolbar-help-content-ulist-description' => 'បញ្ជីផ្ដើមដោយត្រេ',
	'wikieditor-toolbar-help-content-ulist-syntax' => '* ធាតុរបស់បញ្ជី<br />* ធាតុរបស់បញ្ជី',
	'wikieditor-toolbar-help-content-ulist-result' => '<ul><li>ធាតុរបស់បញ្ជី</li><li>ធាតុរបស់បញ្ជី</li></ul>',
	'wikieditor-toolbar-help-content-olist-description' => 'បញ្ជីផ្ដើមដោយលេខ',
	'wikieditor-toolbar-help-content-olist-syntax' => '# ធាតុរបស់បញ្ជី<br /># ធាតុរបស់បញ្ចី',
	'wikieditor-toolbar-help-content-olist-result' => '<ol><li>ធាតុរបស់បញ្ជី</li><li>ធាតុរបស់បញ្ជី</li></ol>',
	'wikieditor-toolbar-help-content-file-description' => 'រូបភាពបង្កប់',
	'wikieditor-toolbar-help-content-file-syntax' => '[[$1:ឧទាហរណ៍.png|thumb|ចំនងជើងក្រោមរូបភាព]]',
	'wikieditor-toolbar-help-content-file-result' => "<div style='width:104px;' class='thumbinner'><a title='ចំណងជើងក្រោមរូបភាព' class='image' href='#'><img height='50' width='100' border='0' class='thumbimage' src='$2/WikiEditor/modules/images/toolbar/example-image.png' alt=''/></a><div class='thumbcaption'><div class='magnify'><a title='ពង្រីក' class='internal' href='#'><img height='11' width='15' alt='' src='$1/common/images/magnify-clip.png'/></a></div>ចំណងជើងក្រោមរូបភាព</div></div>",
	'wikieditor-toolbar-help-content-reference-description' => 'ឯកសារ​យោង​',
	'wikieditor-toolbar-help-content-reference-syntax' => 'អត្ថបទ​ទំព័រ​.&lt;ref name="test"&gt;[http://www.example.org តំណ​ភ្ជាប់], អក្សរ​បន្ថែម​.&lt;/ref&gt;',
	'wikieditor-toolbar-help-content-reference-result' => "អត្ថបទ​ទំព័រ​.<sup><a href='#'>[1]</a></sup>",
	'wikieditor-toolbar-help-content-rereference-description' => 'ការប្រើប្រាស់​បន្ថែម​នៃ​ឯកសារ​យោង​ដូចគ្នា​',
	'wikieditor-toolbar-help-content-rereference-result' => "អត្ថបទ​ទំព័រ​.<sup><a href='#'>[1]</a></sup>",
	'wikieditor-toolbar-help-content-showreferences-description' => 'បង្ហាញ​ឯកសារ​យោង​',
	'wikieditor-toolbar-help-content-showreferences-result' => "<ol class='references'><li id='cite_note-test-0'><b><a title='' href='#'>^</a></b> <a rel='nofollow' title='http://www.example.org' class='external text' href='#'>អត្ថបទតំណភ្ជាប់/a>, អត្ថបទបន្ថែម។</li></ol>",
	'wikieditor-toolbar-help-content-signaturetimestamp-description' => 'ហត្ថលេខា​ ជាមួយនឹង​ត្រាពេលវេលា​',
	'wikieditor-toolbar-help-content-signaturetimestamp-result' => "<a href='#' title='{{#special:mypage}}'>អត្តនាម</a> (<a href='#' title='{{#special:mytalk}}'>ការពិភាក្សា</a>) ១៥:៥៤, ១០ មិថុនា ២០០៩ (UTC)",
	'wikieditor-toolbar-help-content-signature-description' => 'ហត្ថលេខា​',
	'wikieditor-toolbar-help-content-signature-result' => "<a href='#' title='{{#special:mypage}}'>អត្តនាម</a> (<a href='#' title='{{#special:mytalk}}'>ការពិភាក្សា</a>)",
	'wikieditor-toolbar-help-content-indent-description' => 'ខិតចូល (Indent)',
	'wikieditor-toolbar-help-content-indent-syntax' => 'អក្សរ​ធម្មតា​<br />:អក្សរ​ខិតចូល​<br />::អក្សរ​ខិតចូល​',
	'wikieditor-toolbar-help-content-indent-result' => 'អក្សរ​ធម្មតា​​<dl><dd>អក្សរ​ខិតចូល​<dl><dd>អក្សរ​ខិតចូល​</dd></dl></dd></dl>',
);

/** Kannada (ಕನ್ನಡ)
 * @author Nayvik
 */
$messages['kn'] = array(
	'wikieditor-preview-tab' => 'ಮುನ್ನೋಟ',
	'wikieditor-previewDialog-tab' => 'ಮುನ್ನೋಟ',
	'wikieditor-template-editor-dialog-cancel' => 'ರದ್ದು ಮಾಡು',
	'wikieditor-toolbar-tool-reference-cancel' => 'ರದ್ದು ಮಾಡು',
	'wikieditor-toolbar-tool-heading-1' => 'ದರ್ಜೆ ೧',
	'wikieditor-toolbar-tool-heading-2' => 'ದರ್ಜೆ ೨',
	'wikieditor-toolbar-tool-heading-3' => 'ದರ್ಜೆ ೩',
	'wikieditor-toolbar-tool-heading-4' => 'ದರ್ಜೆ ೪',
	'wikieditor-toolbar-tool-heading-5' => 'ದರ್ಜೆ ೫',
	'wikieditor-toolbar-group-format' => 'ಪಟ್ಟಿ',
	'wikieditor-toolbar-tool-big' => 'ದೊಡ್ದ',
	'wikieditor-toolbar-tool-table' => 'ಪಟ್ಟಿ',
	'wikieditor-toolbar-tool-table-example' => 'ಉದಾಹರಣೆ',
	'wikieditor-toolbar-tool-table-preview' => 'ಮುನ್ನೋಟ',
	'wikieditor-toolbar-characters-page-latin' => 'ಲ್ಯಾಟಿನ',
	'wikieditor-toolbar-characters-page-greek' => 'ಗ್ರೀಕ್',
	'wikieditor-toolbar-characters-page-arabic' => 'ಅರೇಬಿಕ್',
	'wikieditor-toolbar-characters-page-hebrew' => 'ಹೀಬ್ರೂ',
	'wikieditor-toolbar-characters-page-telugu' => 'ತೆಲುಗು',
	'wikieditor-toolbar-characters-page-gujarati' => 'ಗುಜರಾತಿ',
	'wikieditor-toolbar-help-page-list' => 'ಪಟ್ಟಿಗಳು',
	'wikieditor-toolbar-help-content-heading2-syntax' => '== ಶೀರ್ಷಿಕೆ ಪಠ್ಯ ==',
	'wikieditor-toolbar-help-content-signature-description' => 'ಸಹಿ',
);

/** Korean (한국어)
 * @author Devunt
 * @author IRTC1015
 * @author Klutzy
 * @author Kwj2772
 * @author Mintz0223
 * @author 관인생략
 * @author 아라
 */
$messages['ko'] = array(
	'wikieditor' => '확장된 위키텍스트 편집 인터페이스',
	'wikieditor-desc' => '확장된 위키 문법 편집 인터페이스와 다양한 기능을 제공하는 모듈을 제공',
	'wikieditor-wikitext-tab' => '위키텍스트',
	'wikieditor-loading' => '불러오는 중...',
	'wikieditor-preview-preference' => '미리 보기 비교 활성화',
	'wikieditor-preview-tab' => '미리 보기',
	'wikieditor-preview-changes-tab' => '차이',
	'wikieditor-preview-loading' => '불러오는 중...',
	'wikieditor-previewDialog-preference' => '미리 보기 대화 상자 사용하기',
	'wikieditor-previewDialog-tab' => '미리 보기',
	'wikieditor-previewDialog-loading' => '불러오는 중...',
	'wikieditor-publish-preference' => '한 단계씩 게시 활성화',
	'wikieditor-publish-button-publish' => '게시',
	'wikieditor-publish-button-cancel' => '취소',
	'wikieditor-publish-dialog-title' => '{{SITENAME}}에 게시',
	'wikieditor-publish-dialog-summary' => '편집 요약 (무엇을 편집했는지 간략하게 설명합니다):',
	'wikieditor-publish-dialog-minor' => '사소한 편집',
	'wikieditor-publish-dialog-watch' => '이 문서 주시하기',
	'wikieditor-publish-dialog-publish' => '게시',
	'wikieditor-publish-dialog-goback' => '돌아가기',
	'wikieditor-template-editor-preference' => '위키 틀의 양식 기반 편집을 활성화하기',
	'wikieditor-template-editor-dialog-title' => '틀 편집하기',
	'wikieditor-template-editor-dialog-submit' => '업데이트',
	'wikieditor-template-editor-dialog-cancel' => '취소',
	'wikieditor-templates-preference' => '틀 접기 활성화하기',
	'wikieditor-toc-preference' => '편집용 목차를 활성화',
	'wikieditor-toc-show' => '내용 보기',
	'wikieditor-toc-hide' => '내용 숨김',
	'wikieditor-toolbar' => '편집 툴바',
	'wikieditor-toolbar-desc' => '사용성이 향상된 편집 툴바',
	'wikieditor-toolbar-preference' => '기능이 향상된 편집 툴바 사용하기',
	'wikieditor-toolbar-dialogs-preference' => '링크와 표 등을 삽입할 때 대화 상자 사용하기',
	'wikieditor-toolbar-hidesig' => '일반 문서 이름공간에서 서명 단추를 숨기기',
	'wikieditor-toolbar-loading' => '불러오는 중…',
	'wikieditor-toolbar-tool-bold' => '굵은 글씨',
	'wikieditor-toolbar-tool-bold-example' => '굵은 글씨',
	'wikieditor-toolbar-tool-italic' => '기울인 글씨',
	'wikieditor-toolbar-tool-italic-example' => '기울인 글씨',
	'wikieditor-toolbar-tool-ilink' => '내부 링크',
	'wikieditor-toolbar-tool-ilink-example' => '문서 제목',
	'wikieditor-toolbar-tool-xlink' => '바깥 링크 (주소 앞에 http://가 있어야 합니다.)',
	'wikieditor-toolbar-tool-xlink-example' => 'http://www.example.com 링크 이름',
	'wikieditor-toolbar-tool-link' => '링크',
	'wikieditor-toolbar-tool-link-title' => '링크 추가',
	'wikieditor-toolbar-tool-link-int' => '위키 문서로 연결',
	'wikieditor-toolbar-tool-link-int-target' => '대상 문서 또는 URL:',
	'wikieditor-toolbar-tool-link-int-target-tooltip' => '문서 제목 또는 URL',
	'wikieditor-toolbar-tool-link-int-text' => '링크 텍스트:',
	'wikieditor-toolbar-tool-link-int-text-tooltip' => '문서에 보여지는 문장',
	'wikieditor-toolbar-tool-link-ext' => '외부 웹 페이지로 연결',
	'wikieditor-toolbar-tool-link-ext-target' => '링크 URL:',
	'wikieditor-toolbar-tool-link-ext-text' => '링크 텍스트:',
	'wikieditor-toolbar-tool-link-insert' => '링크 추가하기',
	'wikieditor-toolbar-tool-link-cancel' => '취소',
	'wikieditor-toolbar-tool-link-int-target-status-exists' => '문서가 존재합니다.',
	'wikieditor-toolbar-tool-link-int-target-status-notexists' => '문서가 존재하지 않습니다.',
	'wikieditor-toolbar-tool-link-int-target-status-invalid' => '제목이 잘못되었습니다.',
	'wikieditor-toolbar-tool-link-int-target-status-external' => '바깥 링크',
	'wikieditor-toolbar-tool-link-int-target-status-loading' => '문서가 존재하는 지 확인 중...',
	'wikieditor-toolbar-tool-link-int-invalid' => '입력한 제목이 잘못되었습니다.',
	'wikieditor-toolbar-tool-link-lookslikeinternal' => '당신이 입력한 URL은 다른 내부 문서일 수 있습니다.
내부 링크로 바꾸겠습니까?',
	'wikieditor-toolbar-tool-link-lookslikeinternal-int' => '내부 링크',
	'wikieditor-toolbar-tool-link-lookslikeinternal-ext' => '바깥 링크',
	'wikieditor-toolbar-tool-link-empty' => '링크할 대상을 입력하지 않았습니다.',
	'wikieditor-toolbar-tool-file' => '파일 넣기',
	'wikieditor-toolbar-tool-file-example' => 'Example.jpg',
	'wikieditor-toolbar-tool-file-title' => '파일 추가하기',
	'wikieditor-toolbar-file-target' => '파일 이름:',
	'wikieditor-toolbar-file-caption' => '설명:',
	'wikieditor-toolbar-file-size' => '크기:',
	'wikieditor-toolbar-file-float' => '정렬:',
	'wikieditor-toolbar-file-default' => '(기본값)',
	'wikieditor-toolbar-file-format' => '형식:',
	'wikieditor-toolbar-file-format-none' => '없음',