DROP TABLE IF EXISTS wp_lofaro_labs_scroll_commentmeta;

CREATE TABLE `wp_lofaro_labs_scroll_commentmeta` (
  `meta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `comment_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  `meta_key` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `meta_value` longtext COLLATE utf8mb4_unicode_ci,
  PRIMARY KEY (`meta_id`),
  KEY `comment_id` (`comment_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;


DROP TABLE IF EXISTS wp_lofaro_labs_scroll_comments;

CREATE TABLE `wp_lofaro_labs_scroll_comments` (
  `comment_ID` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `comment_post_ID` bigint(20) unsigned NOT NULL DEFAULT '0',
  `comment_author` tinytext COLLATE utf8mb4_unicode_ci NOT NULL,
  `comment_author_email` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `comment_author_url` varchar(200) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `comment_author_IP` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `comment_date` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `comment_date_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `comment_content` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `comment_karma` int(11) NOT NULL DEFAULT '0',
  `comment_approved` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '1',
  `comment_agent` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `comment_type` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `comment_parent` bigint(20) unsigned NOT NULL DEFAULT '0',
  `user_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`comment_ID`),
  KEY `comment_post_ID` (`comment_post_ID`),
  KEY `comment_approved_date_gmt` (`comment_approved`,`comment_date_gmt`),
  KEY `comment_date_gmt` (`comment_date_gmt`),
  KEY `comment_parent` (`comment_parent`),
  KEY `comment_author_email` (`comment_author_email`(10))
) ENGINE=InnoDB AUTO_INCREMENT=7 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO wp_lofaro_labs_scroll_comments VALUES("2", "166", "Aviation Lawyers Challenge State Laws Restricting Drones - Boston Commons High Tech", "", "http://www.bostoncommons.net/aviation-lawyers-challenge-state-laws-restricting-drones/", "72.167.190.147", "2016-02-06 14:57:56", "2016-02-06 14:57:56", "[&#8230;] 27. (12) Chris Vo and Dan Lofaro in The Connection article Fairfax Area Becomes a &#8216;No Drone Zone&#8217;&#8230; [&#8230;]", "0", "0", "The Incutio XML-RPC PHP Library -- WordPress/4.4.2", "pingback", "0", "0");
INSERT INTO wp_lofaro_labs_scroll_comments VALUES("3", "182", "Lofaro Labs | Because Robots are People Too", "", "http://serpowerlists.com", "185.130.5.165", "2016-04-02 09:57:34", "2016-04-02 09:57:34", "[&#8230;] Presenting Robots at the 2016 NoVA Mini Maker Faire [&#8230;]", "0", "0", "Mozilla/4.0 (compatible: MSIE 7.0; Windows NT 6.0)", "pingback", "0", "0");
INSERT INTO wp_lofaro_labs_scroll_comments VALUES("4", "182", "Cıvata", "", "http://dunno.dynu.com/civatacilar", "54.171.83.145", "2016-06-14 15:20:14", "2016-06-14 15:20:14", "[&#8230;] http://lofarolabs.com/index.php/2016/03/14/at-nova-mini-maker-faire/ [&#8230;]", "0", "0", "The Incutio XML-RPC PHP Library", "pingback", "0", "0");
INSERT INTO wp_lofaro_labs_scroll_comments VALUES("5", "314", "", "", "http://thezeitgeistmovementforum.org/science-technology/2498-robots-lecture-series-raj-madhavan-lofarolabs-com.html#post15857", "184.154.167.98", "2016-11-22 09:52:15", "2016-11-22 09:52:15", "[&#8230;] ROBOTS: A Lecture Series ? Raj Madhavan | Lofaro Labs  Lets Talk About Using Robots For Good Robotics Automation for Societal Good  Underlying Challenges in Humanitarian Technology, Sustainability, and Public Policy  Who: Dr. Raj Madhavan What: Distinguished Speaker When: Monday November 28th Time: 12:00 pm to 1:00pm Where: Engineering 3507 (George Mason University Fairfax campus) [&#8230;]", "0", "0", "Mozilla/4.0 (vBSEO; http://www.vbseo.com)", "pingback", "0", "0");
INSERT INTO wp_lofaro_labs_scroll_comments VALUES("6", "273", "Lofaro Labs | Because Robots are People Too", "", "http://vyborpmr.ru/", "51.15.53.56", "2016-12-11 22:56:54", "2016-12-11 22:56:54", "[&#8230;] Jaemi Hubo Turns 8 (that is 104 in robot years) [&#8230;]", "0", "0", "Mozilla/4.0 (compatible: MSIE 7.0; Windows NT 6.0)", "pingback", "0", "0");

DROP TABLE IF EXISTS wp_lofaro_labs_scroll_duplicator_packages;

CREATE TABLE `wp_lofaro_labs_scroll_duplicator_packages` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(250) NOT NULL,
  `hash` varchar(50) NOT NULL,
  `status` int(11) NOT NULL,
  `created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `owner` varchar(60) NOT NULL,
  `package` longtext NOT NULL,
  PRIMARY KEY (`id`),
  KEY `hash` (`hash`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=latin1;


DROP TABLE IF EXISTS wp_lofaro_labs_scroll_links;

CREATE TABLE `wp_lofaro_labs_scroll_links` (
  `link_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `link_url` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `link_name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `link_image` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `link_target` varchar(25) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `link_description` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `link_visible` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'Y',
  `link_owner` bigint(20) unsigned NOT NULL DEFAULT '1',
  `link_rating` int(11) NOT NULL DEFAULT '0',
  `link_updated` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `link_rel` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `link_notes` mediumtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `link_rss` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`link_id`),
  KEY `link_visible` (`link_visible`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;


DROP TABLE IF EXISTS wp_lofaro_labs_scroll_njt_fastdup_entities;

CREATE TABLE `wp_lofaro_labs_scroll_njt_fastdup_entities` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `type` varchar(255) NOT NULL,
  `data` text NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;


DROP TABLE IF EXISTS wp_lofaro_labs_scroll_njt_fastdup_packages;

CREATE TABLE `wp_lofaro_labs_scroll_njt_fastdup_packages` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(250) NOT NULL,
  `hash` varchar(50) NOT NULL,
  `status` int(11) NOT NULL,
  `created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `package` mediumblob NOT NULL,
  PRIMARY KEY (`id`),
  KEY `hash` (`hash`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;


DROP TABLE IF EXISTS wp_lofaro_labs_scroll_options;

CREATE TABLE `wp_lofaro_labs_scroll_options` (
  `option_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `option_name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `option_value` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `autoload` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'yes',
  PRIMARY KEY (`option_id`),
  UNIQUE KEY `option_name` (`option_name`)
) ENGINE=InnoDB AUTO_INCREMENT=56116 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO wp_lofaro_labs_scroll_options VALUES("1", "siteurl", "http://lofarolabs.com", "yes");
INSERT INTO wp_lofaro_labs_scroll_options VALUES("2", "home", "http://lofarolabs.com", "yes");
INSERT INTO wp_lofaro_labs_scroll_options VALUES("3", "blogname", "Lofaro Labs", "yes");
INSERT INTO wp_lofaro_labs_scroll_options VALUES("4", "blogdescription", "Because Robots are People Too", "yes");
INSERT INTO wp_lofaro_labs_scroll_options VALUES("5", "users_can_register", "0", "yes");
INSERT INTO wp_lofaro_labs_scroll_options VALUES("6", "admin_email", "dan@danlofaro.com", "yes");
INSERT INTO wp_lofaro_labs_scroll_options VALUES("7", "start_of_week", "1", "yes");
INSERT INTO wp_lofaro_labs_scroll_options VALUES("8", "use_balanceTags", "0", "yes");
INSERT INTO wp_lofaro_labs_scroll_options VALUES("9", "use_smilies", "1", "yes");
INSERT INTO wp_lofaro_labs_scroll_options VALUES("10", "require_name_email", "1", "yes");
INSERT INTO wp_lofaro_labs_scroll_options VALUES("11", "comments_notify", "1", "yes");
INSERT INTO wp_lofaro_labs_scroll_options VALUES("12", "posts_per_rss", "10", "yes");
INSERT INTO wp_lofaro_labs_scroll_options VALUES("13", "rss_use_excerpt", "0", "yes");
INSERT INTO wp_lofaro_labs_scroll_options VALUES("14", "mailserver_url", "mail.example.com", "yes");
INSERT INTO wp_lofaro_labs_scroll_options VALUES("15", "mailserver_login", "login@example.com", "yes");
INSERT INTO wp_lofaro_labs_scroll_options VALUES("16", "mailserver_pass", "password", "yes");
INSERT INTO wp_lofaro_labs_scroll_options VALUES("17", "mailserver_port", "110", "yes");
INSERT INTO wp_lofaro_labs_scroll_options VALUES("18", "default_category", "1", "yes");
INSERT INTO wp_lofaro_labs_scroll_options VALUES("19", "default_comment_status", "open", "yes");
INSERT INTO wp_lofaro_labs_scroll_options VALUES("20", "default_ping_status", "open", "yes");
INSERT INTO wp_lofaro_labs_scroll_options VALUES("21", "default_pingback_flag", "1", "yes");
INSERT INTO wp_lofaro_labs_scroll_options VALUES("22", "posts_per_page", "10", "yes");
INSERT INTO wp_lofaro_labs_scroll_options VALUES("23", "date_format", "F j, Y", "yes");
INSERT INTO wp_lofaro_labs_scroll_options VALUES("24", "time_format", "g:i a", "yes");
INSERT INTO wp_lofaro_labs_scroll_options VALUES("25", "links_updated_date_format", "F j, Y g:i a", "yes");
INSERT INTO wp_lofaro_labs_scroll_options VALUES("26", "comment_moderation", "1", "yes");
INSERT INTO wp_lofaro_labs_scroll_options VALUES("27", "moderation_notify", "1", "yes");
INSERT INTO wp_lofaro_labs_scroll_options VALUES("28", "permalink_structure", "/index.php/%year%/%monthnum%/%day%/%postname%/", "yes");
INSERT INTO wp_lofaro_labs_scroll_options VALUES("29", "hack_file", "0", "yes");
INSERT INTO wp_lofaro_labs_scroll_options VALUES("30", "blog_charset", "UTF-8", "yes");
INSERT INTO wp_lofaro_labs_scroll_options VALUES("31", "moderation_keys", "", "no");
INSERT INTO wp_lofaro_labs_scroll_options VALUES("32", "active_plugins", "a:3:{i:0;s:25:\"duplicator/duplicator.php\";i:1;s:19:\"fastdup/fastdup.php\";i:2;s:34:\"wp-clone-by-wp-academy/wpclone.php\";}", "yes");
INSERT INTO wp_lofaro_labs_scroll_options VALUES("33", "category_base", "", "yes");
INSERT INTO wp_lofaro_labs_scroll_options VALUES("34", "ping_sites", "http://rpc.pingomatic.com/", "yes");
INSERT INTO wp_lofaro_labs_scroll_options VALUES("35", "comment_max_links", "2", "yes");
INSERT INTO wp_lofaro_labs_scroll_options VALUES("36", "gmt_offset", "0", "yes");
INSERT INTO wp_lofaro_labs_scroll_options VALUES("37", "default_email_category", "1", "yes");
INSERT INTO wp_lofaro_labs_scroll_options VALUES("38", "recently_edited", "a:5:{i:0;s:63:\"/var/www/lofarolabs.com/wp-content/themes/imbalance2/footer.php\";i:2;s:63:\"/var/www/lofarolabs.com/wp-content/themes/imbalance2/header.php\";i:3;s:62:\"/var/www/lofarolabs.com/wp-content/themes/imbalance2/style.css\";i:4;s:58:\"/var/www/lofarolabs.com/wp-content/themes/visual/style.css\";i:5;s:62:\"/var/www/lofarolabs.com/wp-content/plugins/akismet/akismet.php\";}", "no");
INSERT INTO wp_lofaro_labs_scroll_options VALUES("39", "template", "imbalance2", "yes");
INSERT INTO wp_lofaro_labs_scroll_options VALUES("40", "stylesheet", "imbalance2", "yes");
INSERT INTO wp_lofaro_labs_scroll_options VALUES("41", "comment_whitelist", "1", "yes");
INSERT INTO wp_lofaro_labs_scroll_options VALUES("42", "blacklist_keys", "", "no");
INSERT INTO wp_lofaro_labs_scroll_options VALUES("43", "comment_registration", "1", "yes");
INSERT INTO wp_lofaro_labs_scroll_options VALUES("44", "html_type", "text/html", "yes");
INSERT INTO wp_lofaro_labs_scroll_options VALUES("45", "use_trackback", "0", "yes");
INSERT INTO wp_lofaro_labs_scroll_options VALUES("46", "default_role", "subscriber", "yes");
INSERT INTO wp_lofaro_labs_scroll_options VALUES("47", "db_version", "35700", "yes");
INSERT INTO wp_lofaro_labs_scroll_options VALUES("48", "uploads_use_yearmonth_folders", "1", "yes");
INSERT INTO wp_lofaro_labs_scroll_options VALUES("49", "upload_path", "", "yes");
INSERT INTO wp_lofaro_labs_scroll_options VALUES("50", "blog_public", "1", "yes");
INSERT INTO wp_lofaro_labs_scroll_options VALUES("51", "default_link_category", "2", "yes");
INSERT INTO wp_lofaro_labs_scroll_options VALUES("52", "show_on_front", "posts", "yes");
INSERT INTO wp_lofaro_labs_scroll_options VALUES("53", "tag_base", "", "yes");
INSERT INTO wp_lofaro_labs_scroll_options VALUES("54", "show_avatars", "1", "yes");
INSERT INTO wp_lofaro_labs_scroll_options VALUES("55", "avatar_rating", "G", "yes");
INSERT INTO wp_lofaro_labs_scroll_options VALUES("56", "upload_url_path", "", "yes");
INSERT INTO wp_lofaro_labs_scroll_options VALUES("57", "thumbnail_size_w", "150", "yes");
INSERT INTO wp_lofaro_labs_scroll_options VALUES("58", "thumbnail_size_h", "150", "yes");
INSERT INTO wp_lofaro_labs_scroll_options VALUES("59", "thumbnail_crop", "1", "yes");
INSERT INTO wp_lofaro_labs_scroll_options VALUES("60", "medium_size_w", "300", "yes");
INSERT INTO wp_lofaro_labs_scroll_options VALUES("61", "medium_size_h", "300", "yes");
INSERT INTO wp_lofaro_labs_scroll_options VALUES("62", "avatar_default", "mystery", "yes");
INSERT INTO wp_lofaro_labs_scroll_options VALUES("63", "large_size_w", "1024", "yes");
INSERT INTO wp_lofaro_labs_scroll_options VALUES("64", "large_size_h", "1024", "yes");
INSERT INTO wp_lofaro_labs_scroll_options VALUES("65", "image_default_link_type", "none", "yes");
INSERT INTO wp_lofaro_labs_scroll_options VALUES("66", "image_default_size", "", "yes");
INSERT INTO wp_lofaro_labs_scroll_options VALUES("67", "image_default_align", "", "yes");
INSERT INTO wp_lofaro_labs_scroll_options VALUES("68", "close_comments_for_old_posts", "1", "yes");
INSERT INTO wp_lofaro_labs_scroll_options VALUES("69", "close_comments_days_old", "0", "yes");
INSERT INTO wp_lofaro_labs_scroll_options VALUES("70", "thread_comments", "1", "yes");
INSERT INTO wp_lofaro_labs_scroll_options VALUES("71", "thread_comments_depth", "5", "yes");
INSERT INTO wp_lofaro_labs_scroll_options VALUES("72", "page_comments", "", "yes");
INSERT INTO wp_lofaro_labs_scroll_options VALUES("73", "comments_per_page", "50", "yes");
INSERT INTO wp_lofaro_labs_scroll_options VALUES("74", "default_comments_page", "newest", "yes");
INSERT INTO wp_lofaro_labs_scroll_options VALUES("75", "comment_order", "asc", "yes");
INSERT INTO wp_lofaro_labs_scroll_options VALUES("76", "sticky_posts", "a:0:{}", "yes");
INSERT INTO wp_lofaro_labs_scroll_options VALUES("77", "widget_categories", "a:2:{i:2;a:4:{s:5:\"title\";s:0:\"\";s:5:\"count\";i:0;s:12:\"hierarchical\";i:0;s:8:\"dropdown\";i:0;}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO wp_lofaro_labs_scroll_options VALUES("78", "widget_text", "a:2:{i:1;a:0:{}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO wp_lofaro_labs_scroll_options VALUES("79", "widget_rss", "a:2:{i:1;a:0:{}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO wp_lofaro_labs_scroll_options VALUES("80", "uninstall_plugins", "a:1:{s:34:\"wp-clone-by-wp-academy/wpclone.php\";s:21:\"wpa_wpclone_uninstall\";}", "no");
INSERT INTO wp_lofaro_labs_scroll_options VALUES("81", "timezone_string", "", "yes");
INSERT INTO wp_lofaro_labs_scroll_options VALUES("82", "page_for_posts", "0", "yes");
INSERT INTO wp_lofaro_labs_scroll_options VALUES("83", "page_on_front", "0", "yes");
INSERT INTO wp_lofaro_labs_scroll_options VALUES("84", "default_post_format", "0", "yes");
INSERT INTO wp_lofaro_labs_scroll_options VALUES("85", "link_manager_enabled", "0", "yes");
INSERT INTO wp_lofaro_labs_scroll_options VALUES("86", "finished_splitting_shared_terms", "1", "yes");
INSERT INTO wp_lofaro_labs_scroll_options VALUES("87", "site_icon", "11", "yes");
INSERT INTO wp_lofaro_labs_scroll_options VALUES("88", "medium_large_size_w", "768", "yes");
INSERT INTO wp_lofaro_labs_scroll_options VALUES("89", "medium_large_size_h", "0", "yes");
INSERT INTO wp_lofaro_labs_scroll_options VALUES("90", "initial_db_version", "35700", "yes");
INSERT INTO wp_lofaro_labs_scroll_options VALUES("91", "wp_lofaro_labs_scroll_user_roles", "a:5:{s:13:\"administrator\";a:2:{s:4:\"name\";s:13:\"Administrator\";s:12:\"capabilities\";a:61:{s:13:\"switch_themes\";b:1;s:11:\"edit_themes\";b:1;s:16:\"activate_plugins\";b:1;s:12:\"edit_plugins\";b:1;s:10:\"edit_users\";b:1;s:10:\"edit_files\";b:1;s:14:\"manage_options\";b:1;s:17:\"moderate_comments\";b:1;s:17:\"manage_categories\";b:1;s:12:\"manage_links\";b:1;s:12:\"upload_files\";b:1;s:6:\"import\";b:1;s:15:\"unfiltered_html\";b:1;s:10:\"edit_posts\";b:1;s:17:\"edit_others_posts\";b:1;s:20:\"edit_published_posts\";b:1;s:13:\"publish_posts\";b:1;s:10:\"edit_pages\";b:1;s:4:\"read\";b:1;s:8:\"level_10\";b:1;s:7:\"level_9\";b:1;s:7:\"level_8\";b:1;s:7:\"level_7\";b:1;s:7:\"level_6\";b:1;s:7:\"level_5\";b:1;s:7:\"level_4\";b:1;s:7:\"level_3\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:17:\"edit_others_pages\";b:1;s:20:\"edit_published_pages\";b:1;s:13:\"publish_pages\";b:1;s:12:\"delete_pages\";b:1;s:19:\"delete_others_pages\";b:1;s:22:\"delete_published_pages\";b:1;s:12:\"delete_posts\";b:1;s:19:\"delete_others_posts\";b:1;s:22:\"delete_published_posts\";b:1;s:20:\"delete_private_posts\";b:1;s:18:\"edit_private_posts\";b:1;s:18:\"read_private_posts\";b:1;s:20:\"delete_private_pages\";b:1;s:18:\"edit_private_pages\";b:1;s:18:\"read_private_pages\";b:1;s:12:\"delete_users\";b:1;s:12:\"create_users\";b:1;s:17:\"unfiltered_upload\";b:1;s:14:\"edit_dashboard\";b:1;s:14:\"update_plugins\";b:1;s:14:\"delete_plugins\";b:1;s:15:\"install_plugins\";b:1;s:13:\"update_themes\";b:1;s:14:\"install_themes\";b:1;s:11:\"update_core\";b:1;s:10:\"list_users\";b:1;s:12:\"remove_users\";b:1;s:13:\"promote_users\";b:1;s:18:\"edit_theme_options\";b:1;s:13:\"delete_themes\";b:1;s:6:\"export\";b:1;}}s:6:\"editor\";a:2:{s:4:\"name\";s:6:\"Editor\";s:12:\"capabilities\";a:34:{s:17:\"moderate_comments\";b:1;s:17:\"manage_categories\";b:1;s:12:\"manage_links\";b:1;s:12:\"upload_files\";b:1;s:15:\"unfiltered_html\";b:1;s:10:\"edit_posts\";b:1;s:17:\"edit_others_posts\";b:1;s:20:\"edit_published_posts\";b:1;s:13:\"publish_posts\";b:1;s:10:\"edit_pages\";b:1;s:4:\"read\";b:1;s:7:\"level_7\";b:1;s:7:\"level_6\";b:1;s:7:\"level_5\";b:1;s:7:\"level_4\";b:1;s:7:\"level_3\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:17:\"edit_others_pages\";b:1;s:20:\"edit_published_pages\";b:1;s:13:\"publish_pages\";b:1;s:12:\"delete_pages\";b:1;s:19:\"delete_others_pages\";b:1;s:22:\"delete_published_pages\";b:1;s:12:\"delete_posts\";b:1;s:19:\"delete_others_posts\";b:1;s:22:\"delete_published_posts\";b:1;s:20:\"delete_private_posts\";b:1;s:18:\"edit_private_posts\";b:1;s:18:\"read_private_posts\";b:1;s:20:\"delete_private_pages\";b:1;s:18:\"edit_private_pages\";b:1;s:18:\"read_private_pages\";b:1;}}s:6:\"author\";a:2:{s:4:\"name\";s:6:\"Author\";s:12:\"capabilities\";a:10:{s:12:\"upload_files\";b:1;s:10:\"edit_posts\";b:1;s:20:\"edit_published_posts\";b:1;s:13:\"publish_posts\";b:1;s:4:\"read\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:12:\"delete_posts\";b:1;s:22:\"delete_published_posts\";b:1;}}s:11:\"contributor\";a:2:{s:4:\"name\";s:11:\"Contributor\";s:12:\"capabilities\";a:5:{s:10:\"edit_posts\";b:1;s:4:\"read\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:12:\"delete_posts\";b:1;}}s:10:\"subscriber\";a:2:{s:4:\"name\";s:10:\"Subscriber\";s:12:\"capabilities\";a:2:{s:4:\"read\";b:1;s:7:\"level_0\";b:1;}}}", "yes");
INSERT INTO wp_lofaro_labs_scroll_options VALUES("92", "widget_search", "a:2:{i:2;a:1:{s:5:\"title\";s:0:\"\";}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO wp_lofaro_labs_scroll_options VALUES("93", "widget_recent-posts", "a:2:{i:2;a:2:{s:5:\"title\";s:0:\"\";s:6:\"number\";i:5;}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO wp_lofaro_labs_scroll_options VALUES("94", "widget_recent-comments", "a:2:{i:2;a:2:{s:5:\"title\";s:0:\"\";s:6:\"number\";i:5;}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO wp_lofaro_labs_scroll_options VALUES("95", "widget_archives", "a:2:{i:2;a:3:{s:5:\"title\";s:0:\"\";s:5:\"count\";i:0;s:8:\"dropdown\";i:0;}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO wp_lofaro_labs_scroll_options VALUES("96", "widget_meta", "a:2:{i:2;a:1:{s:5:\"title\";s:0:\"\";}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO wp_lofaro_labs_scroll_options VALUES("97", "sidebars_widgets", "a:3:{s:19:\"wp_inactive_widgets\";a:0:{}s:18:\"orphaned_widgets_1\";a:6:{i:0;s:8:\"search-2\";i:1;s:14:\"recent-posts-2\";i:2;s:17:\"recent-comments-2\";i:3;s:10:\"archives-2\";i:4;s:12:\"categories-2\";i:5;s:6:\"meta-2\";}s:13:\"array_version\";i:3;}", "yes");
INSERT INTO wp_lofaro_labs_scroll_options VALUES("100", "widget_pages", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO wp_lofaro_labs_scroll_options VALUES("101", "widget_calendar", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO wp_lofaro_labs_scroll_options VALUES("102", "widget_tag_cloud", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO wp_lofaro_labs_scroll_options VALUES("103", "widget_nav_menu", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO wp_lofaro_labs_scroll_options VALUES("104", "cron", "a:5:{i:1656052743;a:3:{s:16:\"wp_version_check\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}s:17:\"wp_update_plugins\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}s:16:\"wp_update_themes\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1656052752;a:1:{s:19:\"wp_scheduled_delete\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1656053309;a:1:{s:30:\"wp_scheduled_auto_draft_delete\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1656055080;a:1:{s:20:\"wp_maybe_auto_update\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}s:7:\"version\";i:2;}", "yes");
INSERT INTO wp_lofaro_labs_scroll_options VALUES("119", "can_compress_scripts", "0", "yes");
INSERT INTO wp_lofaro_labs_scroll_options VALUES("137", "_transient_twentysixteen_categories", "1", "yes");
INSERT INTO wp_lofaro_labs_scroll_options VALUES("138", "_site_transient_timeout_wporg_theme_feature_list", "1451900445", "yes");
INSERT INTO wp_lofaro_labs_scroll_options VALUES("139", "_site_transient_wporg_theme_feature_list", "a:4:{s:6:\"Colors\";a:15:{i:0;s:5:\"black\";i:1;s:4:\"blue\";i:2;s:5:\"brown\";i:3;s:4:\"gray\";i:4;s:5:\"green\";i:5;s:6:\"orange\";i:6;s:4:\"pink\";i:7;s:6:\"purple\";i:8;s:3:\"red\";i:9;s:6:\"silver\";i:10;s:3:\"tan\";i:11;s:5:\"white\";i:12;s:6:\"yellow\";i:13;s:4:\"dark\";i:14;s:5:\"light\";}s:6:\"Layout\";a:9:{i:0;s:12:\"fixed-layout\";i:1;s:12:\"fluid-layout\";i:2;s:17:\"responsive-layout\";i:3;s:10:\"one-column\";i:4;s:11:\"two-columns\";i:5;s:13:\"three-columns\";i:6;s:12:\"four-columns\";i:7;s:12:\"left-sidebar\";i:8;s:13:\"right-sidebar\";}s:8:\"Features\";a:20:{i:0;s:19:\"accessibility-ready\";i:1;s:8:\"blavatar\";i:2;s:10:\"buddypress\";i:3;s:17:\"custom-background\";i:4;s:13:\"custom-colors\";i:5;s:13:\"custom-header\";i:6;s:11:\"custom-menu\";i:7;s:12:\"editor-style\";i:8;s:21:\"featured-image-header\";i:9;s:15:\"featured-images\";i:10;s:15:\"flexible-header\";i:11;s:20:\"front-page-post-form\";i:12;s:19:\"full-width-template\";i:13;s:12:\"microformats\";i:14;s:12:\"post-formats\";i:15;s:20:\"rtl-language-support\";i:16;s:11:\"sticky-post\";i:17;s:13:\"theme-options\";i:18;s:17:\"threaded-comments\";i:19;s:17:\"translation-ready\";}s:7:\"Subject\";a:3:{i:0;s:7:\"holiday\";i:1;s:13:\"photoblogging\";i:2;s:8:\"seasonal\";}}", "yes");
INSERT INTO wp_lofaro_labs_scroll_options VALUES("140", "theme_mods_twentysixteen", "a:1:{s:16:\"sidebars_widgets\";a:2:{s:4:\"time\";i:1451889900;s:4:\"data\";a:2:{s:19:\"wp_inactive_widgets\";a:0:{}s:9:\"sidebar-1\";a:6:{i:0;s:8:\"search-2\";i:1;s:14:\"recent-posts-2\";i:2;s:17:\"recent-comments-2\";i:3;s:10:\"archives-2\";i:4;s:12:\"categories-2\";i:5;s:6:\"meta-2\";}}}}", "yes");
INSERT INTO wp_lofaro_labs_scroll_options VALUES("141", "current_theme", "Imbalance 2", "yes");
INSERT INTO wp_lofaro_labs_scroll_options VALUES("142", "theme_mods_visual", "a:2:{i:0;b:0;s:16:\"sidebars_widgets\";a:2:{s:4:\"time\";i:1451936174;s:4:\"data\";a:2:{s:19:\"wp_inactive_widgets\";a:0:{}s:9:\"sidebar-1\";a:6:{i:0;s:8:\"search-2\";i:1;s:14:\"recent-posts-2\";i:2;s:17:\"recent-comments-2\";i:3;s:10:\"archives-2\";i:4;s:12:\"categories-2\";i:5;s:6:\"meta-2\";}}}}", "yes");
INSERT INTO wp_lofaro_labs_scroll_options VALUES("143", "theme_switched", "", "yes");
INSERT INTO wp_lofaro_labs_scroll_options VALUES("151", "visual-theme", "a:1:{s:11:\"footer_text\";s:137:\"<a href=\"http://www.lofarolabs.com\" title=\"Lofaro Labs\" rel=\"generator\">Lofaro Labs</a> <a href=\"http://www.lofarolabs.com/\">Robotics</a>\";}", "yes");
INSERT INTO wp_lofaro_labs_scroll_options VALUES("276", "recently_activated", "a:0:{}", "yes");
INSERT INTO wp_lofaro_labs_scroll_options VALUES("278", "auto_load_next_post_install_date", "2016-01-04", "yes");
INSERT INTO wp_lofaro_labs_scroll_options VALUES("285", "theme_mods_illustratr", "a:2:{i:0;b:0;s:16:\"sidebars_widgets\";a:2:{s:4:\"time\";i:1451899252;s:4:\"data\";a:2:{s:19:\"wp_inactive_widgets\";a:0:{}s:9:\"sidebar-1\";a:6:{i:0;s:8:\"search-2\";i:1;s:14:\"recent-posts-2\";i:2;s:17:\"recent-comments-2\";i:3;s:10:\"archives-2\";i:4;s:12:\"categories-2\";i:5;s:6:\"meta-2\";}}}}", "yes");
INSERT INTO wp_lofaro_labs_scroll_options VALUES("289", "widget_widget_twentyfourteen_ephemera", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO wp_lofaro_labs_scroll_options VALUES("291", "_transient_twentyfourteen_category_count", "1", "yes");
INSERT INTO wp_lofaro_labs_scroll_options VALUES("293", "_transient_timeout_infinite_scroll_presets", "1451985586", "no");
INSERT INTO wp_lofaro_labs_scroll_options VALUES("294", "_transient_infinite_scroll_presets", "a:28:{s:0:\"\";O:8:\"stdClass\":5:{s:5:\"theme\";N;s:15:\"contentSelector\";N;s:11:\"navSelector\";N;s:12:\"itemSelector\";N;s:12:\"nextSelector\";N;}s:6:\"Avenue\";O:8:\"stdClass\":5:{s:5:\"theme\";s:6:\"Avenue\";s:15:\"contentSelector\";s:14:\"#main .archive\";s:11:\"navSelector\";s:11:\".pagination\";s:12:\"itemSelector\";s:20:\"#main .archive .post\";s:12:\"nextSelector\";s:32:\".pagination .current + .inactive\";}s:6:\"Gaming\";O:8:\"stdClass\":5:{s:5:\"theme\";s:6:\"Gaming\";s:15:\"contentSelector\";s:8:\"#content\";s:11:\"navSelector\";s:10:\"#nav-below\";s:12:\"itemSelector\";s:5:\".post\";s:12:\"nextSelector\";s:18:\"#nav-below a:first\";}s:9:\"atahualpa\";O:8:\"stdClass\":5:{s:5:\"theme\";s:9:\"atahualpa\";s:15:\"contentSelector\";s:9:\"td#middle\";s:11:\"navSelector\";s:21:\"div.navigation-bottom\";s:12:\"itemSelector\";s:18:\"td#middle div.post\";s:12:\"nextSelector\";s:16:\"div.newer a:link\";}s:6:\"befree\";O:8:\"stdClass\":5:{s:5:\"theme\";s:6:\"befree\";s:15:\"contentSelector\";s:14:\"#main.col-left\";s:11:\"navSelector\";s:12:\".nav-entries\";s:12:\"itemSelector\";s:19:\".border-post-second\";s:12:\"nextSelector\";s:14:\".nav-entries a\";}s:8:\"cleanmag\";O:8:\"stdClass\":5:{s:5:\"theme\";s:8:\"cleanmag\";s:15:\"contentSelector\";s:8:\"#content\";s:11:\"navSelector\";s:10:\"#nav-below\";s:12:\"itemSelector\";s:5:\".post\";s:12:\"nextSelector\";s:18:\"#nav-below a:first\";}s:9:\"extranews\";O:8:\"stdClass\":5:{s:5:\"theme\";s:9:\"extranews\";s:15:\"contentSelector\";s:8:\"#content\";s:11:\"navSelector\";s:14:\"div.navigation\";s:12:\"itemSelector\";s:17:\"#content div.post\";s:12:\"nextSelector\";s:22:\"div.navigation a:first\";}s:9:\"glassical\";O:8:\"stdClass\":5:{s:5:\"theme\";s:9:\"glassical\";s:15:\"contentSelector\";s:8:\"#content\";s:11:\"navSelector\";s:12:\"#wp_pagenavi\";s:12:\"itemSelector\";s:5:\".post\";s:12:\"nextSelector\";s:18:\"#wp_pagenavi:first\";}s:5:\"gonzo\";O:8:\"stdClass\":5:{s:5:\"theme\";s:5:\"gonzo\";s:15:\"contentSelector\";s:9:\"#omc-main\";s:11:\"navSelector\";s:11:\".pagination\";s:12:\"itemSelector\";s:9:\"#omc-main\";s:12:\"nextSelector\";s:21:\".pagination .inactive\";}s:10:\"gridlocked\";O:8:\"stdClass\":5:{s:5:\"theme\";s:10:\"gridlocked\";s:15:\"contentSelector\";s:8:\"#primary\";s:11:\"navSelector\";s:17:\"#index-navigation\";s:12:\"itemSelector\";s:16:\"#content .hentry\";s:12:\"nextSelector\";s:35:\"#index-navigation .nav-next a:first\";}s:2:\"h5\";O:8:\"stdClass\":5:{s:5:\"theme\";s:2:\"h5\";s:15:\"contentSelector\";s:9:\"#masonary\";s:11:\"navSelector\";s:12:\".wp-pagenavi\";s:12:\"itemSelector\";s:4:\".box\";s:12:\"nextSelector\";s:27:\".wp-pagenavi .nextpostslink\";}s:5:\"inove\";O:8:\"stdClass\":5:{s:5:\"theme\";s:5:\"inove\";s:15:\"contentSelector\";s:5:\"#main\";s:11:\"navSelector\";s:14:\"#main div.post\";s:12:\"itemSelector\";s:9:\"#pagenavi\";s:12:\"nextSelector\";s:28:\"#pagenavi span.older a:first\";}s:6:\"launch\";O:8:\"stdClass\":5:{s:5:\"theme\";s:6:\"launch\";s:15:\"contentSelector\";s:14:\"#primary.hfeed\";s:11:\"navSelector\";s:14:\"div.navigation\";s:12:\"itemSelector\";s:5:\".post\";s:12:\"nextSelector\";s:11:\".nav-next a\";}s:9:\"litepress\";O:8:\"stdClass\":5:{s:5:\"theme\";s:9:\"litepress\";s:15:\"contentSelector\";s:8:\"#content\";s:11:\"navSelector\";s:11:\".navigation\";s:12:\"itemSelector\";s:12:\".recent-post\";s:12:\"nextSelector\";s:17:\".navigation .next\";}s:8:\"mockfive\";O:8:\"stdClass\":5:{s:5:\"theme\";s:8:\"mockfive\";s:15:\"contentSelector\";s:8:\"#content\";s:11:\"navSelector\";s:14:\"div.navigation\";s:12:\"itemSelector\";s:17:\"#content div.post\";s:12:\"nextSelector\";s:22:\"div.navigation a:first\";}s:9:\"pagelines\";O:8:\"stdClass\":5:{s:5:\"theme\";s:9:\"pagelines\";s:15:\"contentSelector\";s:9:\"#postloop\";s:11:\"navSelector\";s:11:\"#pagination\";s:12:\"itemSelector\";s:27:\"#postloop .copy-pad article\";s:12:\"nextSelector\";s:65:\"#pagination .copy-pad .page-nav-default .previous-entries a:first\";}s:9:\"picolight\";O:8:\"stdClass\":5:{s:5:\"theme\";s:9:\"picolight\";s:15:\"contentSelector\";s:8:\"#content\";s:11:\"navSelector\";s:14:\"div.navigation\";s:12:\"itemSelector\";s:5:\".post\";s:12:\"nextSelector\";s:30:\"div.navigation div.alignleft a\";}s:8:\"platform\";O:8:\"stdClass\":5:{s:5:\"theme\";s:8:\"platform\";s:15:\"contentSelector\";s:18:\"#pagelines_content\";s:11:\"navSelector\";s:36:\"#pagelines_content .page-nav-default\";s:12:\"itemSelector\";s:5:\".post\";s:12:\"nextSelector\";s:38:\"#pagelines_content .page-nav-default a\";}s:6:\"rustik\";O:8:\"stdClass\":5:{s:5:\"theme\";s:6:\"rustik\";s:15:\"contentSelector\";s:8:\"#content\";s:11:\"navSelector\";s:10:\"#nav-below\";s:12:\"itemSelector\";s:5:\".post\";s:12:\"nextSelector\";s:18:\"#nav-below a:first\";}s:19:\"shaken-grid-premium\";O:8:\"stdClass\":5:{s:5:\"theme\";s:19:\"shaken-grid-premium\";s:15:\"contentSelector\";s:8:\"#content\";s:11:\"navSelector\";s:10:\"#nav-below\";s:12:\"itemSelector\";s:5:\".post\";s:12:\"nextSelector\";s:18:\"#nav-below a:first\";}s:5:\"swift\";O:8:\"stdClass\":5:{s:5:\"theme\";s:5:\"swift\";s:15:\"contentSelector\";s:8:\"#content\";s:11:\"navSelector\";s:14:\"div.navigation\";s:12:\"itemSelector\";s:8:\"#content\";s:12:\"nextSelector\";s:22:\"div.navigation a:first\";}s:8:\"thematic\";O:8:\"stdClass\":5:{s:5:\"theme\";s:8:\"thematic\";s:15:\"contentSelector\";s:8:\"#content\";s:11:\"navSelector\";s:12:\"footer.below\";s:12:\"itemSelector\";s:12:\"article.post\";s:12:\"nextSelector\";s:15:\"a.nextpostslink\";}s:12:\"twentyeleven\";O:8:\"stdClass\":5:{s:5:\"theme\";s:12:\"twentyeleven\";s:15:\"contentSelector\";s:8:\"#content\";s:11:\"navSelector\";s:10:\"#nav-below\";s:12:\"itemSelector\";s:21:\"#content article.post\";s:12:\"nextSelector\";s:32:\"#nav-below .nav-previous a:first\";}s:9:\"twentyten\";O:8:\"stdClass\":5:{s:5:\"theme\";s:9:\"twentyten\";s:15:\"contentSelector\";s:8:\"#content\";s:11:\"navSelector\";s:14:\"div.navigation\";s:12:\"itemSelector\";s:18:\"#content  div.post\";s:12:\"nextSelector\";s:22:\"div.navigation a:first\";}s:14:\"twentythirteen\";O:8:\"stdClass\":5:{s:5:\"theme\";s:14:\"twentythirteen\";s:15:\"contentSelector\";s:8:\"#content\";s:11:\"navSelector\";s:10:\"#nav-below\";s:12:\"itemSelector\";s:5:\".post\";s:12:\"nextSelector\";s:18:\"#nav-below a:first\";}s:12:\"twentytwelve\";O:8:\"stdClass\":5:{s:5:\"theme\";s:12:\"twentytwelve\";s:15:\"contentSelector\";s:8:\"#content\";s:11:\"navSelector\";s:12:\"#content nav\";s:12:\"itemSelector\";s:7:\".hentry\";s:12:\"nextSelector\";s:14:\"#content nav a\";}s:13:\"weaver-ii-pro\";O:8:\"stdClass\":5:{s:5:\"theme\";s:13:\"weaver-ii-pro\";s:15:\"contentSelector\";s:8:\"#content\";s:11:\"navSelector\";s:10:\"#nav-below\";s:12:\"itemSelector\";s:21:\"#content article.post\";s:12:\"nextSelector\";s:32:\"#nav-below .nav-previous a:first\";}s:4:\"wiki\";O:8:\"stdClass\":5:{s:5:\"theme\";s:4:\"wiki\";s:15:\"contentSelector\";s:8:\".content\";s:11:\"navSelector\";s:11:\".pagination\";s:12:\"itemSelector\";s:5:\".post\";s:12:\"nextSelector\";s:5:\".next\";}}", "no");
INSERT INTO wp_lofaro_labs_scroll_options VALUES("295", "infinite_scroll", "a:8:{s:7:\"loading\";a:3:{s:7:\"msgText\";s:19:\"<em>Loading...</em>\";s:11:\"finishedMsg\";s:29:\"<em>No additional posts.</em>\";s:3:\"img\";s:76:\"http://lofarolabs.com/wp-content/plugins/infinite-scroll/img/ajax-loader.gif\";}s:12:\"nextSelector\";s:18:\"#nav-below a:first\";s:11:\"navSelector\";s:10:\"#nav-below\";s:12:\"itemSelector\";s:5:\".post\";s:15:\"contentSelector\";s:8:\"#content\";s:5:\"debug\";b:0;s:8:\"behavior\";s:0:\"\";s:10:\"db_version\";s:5:\"2.6.1\";}", "yes");
INSERT INTO wp_lofaro_labs_scroll_options VALUES("320", "widget_aboutmewidget", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO wp_lofaro_labs_scroll_options VALUES("321", "widget_adsensewidget", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO wp_lofaro_labs_scroll_options VALUES("322", "widget_advwidget", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO wp_lofaro_labs_scroll_options VALUES("323", "et_images_temp_folder", "/var/www/lofarolabs.com/wp-content/uploads/et_temp", "yes");
INSERT INTO wp_lofaro_labs_scroll_options VALUES("324", "et_schedule_clean_images_last_time", "1451933813", "yes");
INSERT INTO wp_lofaro_labs_scroll_options VALUES("325", "widget_tabbedwidget", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO wp_lofaro_labs_scroll_options VALUES("326", "_transient_all_the_cool_cats", "1", "yes");
INSERT INTO wp_lofaro_labs_scroll_options VALUES("327", "_enable_dropdowns", "false", "yes");
INSERT INTO wp_lofaro_labs_scroll_options VALUES("328", "_enable_dropdowns_categories", "false", "yes");
INSERT INTO wp_lofaro_labs_scroll_options VALUES("329", "widget_customlogowidget", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO wp_lofaro_labs_scroll_options VALUES("330", "widget_topratedwidget", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO wp_lofaro_labs_scroll_options VALUES("331", "_color_scheme", "Default", "yes");
INSERT INTO wp_lofaro_labs_scroll_options VALUES("332", "widget_searchwidget", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO wp_lofaro_labs_scroll_options VALUES("333", "widget_taxonomieswidget", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO wp_lofaro_labs_scroll_options VALUES("334", "widget_recentwidget", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO wp_lofaro_labs_scroll_options VALUES("335", "widget_popularwidget", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO wp_lofaro_labs_scroll_options VALUES("336", "widget_randomwidget", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO wp_lofaro_labs_scroll_options VALUES("337", "widget_testimonialswidget", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO wp_lofaro_labs_scroll_options VALUES("338", "widget_ettabbedwidget", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO wp_lofaro_labs_scroll_options VALUES("339", "widget_ettopauthorswidget", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO wp_lofaro_labs_scroll_options VALUES("340", "widget_etrecentfromwidget", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO wp_lofaro_labs_scroll_options VALUES("341", "widget_etcenteredadwidget", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO wp_lofaro_labs_scroll_options VALUES("342", "widget_etrecentvideoswidget", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO wp_lofaro_labs_scroll_options VALUES("343", "widget_socialwidget", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO wp_lofaro_labs_scroll_options VALUES("344", "_transient_et_featured_post_ids", "a:10:{i:0;i:71;i:1;i:79;i:2;i:75;i:3;i:82;i:4;i:88;i:5;i:91;i:6;i:95;i:7;i:98;i:8;i:101;i:9;i:67;}", "yes");
INSERT INTO wp_lofaro_labs_scroll_options VALUES("345", "widget_etsearchwidget", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO wp_lofaro_labs_scroll_options VALUES("346", "jetpack_options", "a:2:{s:7:\"version\";s:16:\"3.8.2:1451934342\";s:11:\"old_version\";s:16:\"3.8.2:1451934342\";}", "yes");
INSERT INTO wp_lofaro_labs_scroll_options VALUES("347", "jetpack_activated", "1", "yes");
INSERT INTO wp_lofaro_labs_scroll_options VALUES("348", "jetpack_file_data", "a:1:{s:5:\"3.8.2\";a:48:{s:32:\"31e5b9ae08b62c2b0cd8a7792242298b\";a:14:{s:4:\"name\";s:20:\"Spelling and Grammar\";s:11:\"description\";s:89:\"Check your spelling, style, and grammar with the After the Deadline proofreading service.\";s:14:\"jumpstart_desc\";s:0:\"\";s:4:\"sort\";s:1:\"6\";s:20:\"recommendation_order\";s:0:\"\";s:10:\"introduced\";s:3:\"1.1\";s:7:\"changed\";s:0:\"\";s:10:\"deactivate\";s:0:\"\";s:4:\"free\";s:0:\"\";s:19:\"requires_connection\";s:3:\"Yes\";s:13:\"auto_activate\";s:3:\"Yes\";s:11:\"module_tags\";s:7:\"Writing\";s:7:\"feature\";s:0:\"\";s:25:\"additional_search_queries\";s:115:\"after the deadline, afterthedeadline, spell, spellchecker, spelling, grammar, proofreading, style, language, cliche\";}s:32:\"3f41b2d629265b5de8108b463abbe8e2\";a:14:{s:4:\"name\";s:8:\"Carousel\";s:11:\"description\";s:63:\"Transform standard image galleries into full-screen slideshows.\";s:14:\"jumpstart_desc\";s:79:\"Brings your photos and images to life as full-size, easily navigable galleries.\";s:4:\"sort\";s:2:\"22\";s:20:\"recommendation_order\";s:2:\"12\";s:10:\"introduced\";s:3:\"1.5\";s:7:\"changed\";s:0:\"\";s:10:\"deactivate\";s:0:\"\";s:4:\"free\";s:0:\"\";s:19:\"requires_connection\";s:2:\"No\";s:13:\"auto_activate\";s:2:\"No\";s:11:\"module_tags\";s:17:\"Photos and Videos\";s:7:\"feature\";s:9:\"Jumpstart\";s:25:\"additional_search_queries\";s:80:\"gallery, carousel, diaporama, slideshow, images, lightbox, exif, metadata, image\";}s:32:\"c6ebb418dde302de09600a6025370583\";a:14:{s:4:\"name\";s:8:\"Comments\";s:11:\"description\";s:79:\"Let readers comment with WordPress.com, Twitter, Facebook, or Google+ accounts.\";s:14:\"jumpstart_desc\";s:0:\"\";s:4:\"sort\";s:2:\"20\";s:20:\"recommendation_order\";s:0:\"\";s:10:\"introduced\";s:3:\"1.4\";s:7:\"changed\";s:0:\"\";s:10:\"deactivate\";s:0:\"\";s:4:\"free\";s:0:\"\";s:19:\"requires_connection\";s:3:\"Yes\";s:13:\"auto_activate\";s:2:\"No\";s:11:\"module_tags\";s:6:\"Social\";s:7:\"feature\";s:0:\"\";s:25:\"additional_search_queries\";s:53:\"comments, comment, facebook, twitter, google+, social\";}s:32:\"836f9485669e1bbb02920cb474730df0\";a:14:{s:4:\"name\";s:12:\"Contact Form\";s:11:\"description\";s:44:\"Insert a contact form anywhere on your site.\";s:14:\"jumpstart_desc\";s:111:\"Adds a button to your post and page editors, allowing you to build simple forms to help visitors stay in touch.\";s:4:\"sort\";s:2:\"15\";s:20:\"recommendation_order\";s:2:\"14\";s:10:\"introduced\";s:3:\"1.3\";s:7:\"changed\";s:0:\"\";s:10:\"deactivate\";s:0:\"\";s:4:\"free\";s:0:\"\";s:19:\"requires_connection\";s:2:\"No\";s:13:\"auto_activate\";s:3:\"Yes\";s:11:\"module_tags\";s:5:\"Other\";s:7:\"feature\";s:9:\"Jumpstart\";s:25:\"additional_search_queries\";s:44:\"contact, form, grunion, feedback, submission\";}s:32:\"ea3970eebf8aac55fc3eca5dca0e0157\";a:14:{s:4:\"name\";s:20:\"Custom Content Types\";s:11:\"description\";s:92:\"Organize and display different types of content on your site, separate from posts and pages.\";s:14:\"jumpstart_desc\";s:0:\"\";s:4:\"sort\";s:2:\"34\";s:20:\"recommendation_order\";s:0:\"\";s:10:\"introduced\";s:3:\"3.1\";s:7:\"changed\";s:0:\"\";s:10:\"deactivate\";s:0:\"\";s:4:\"free\";s:0:\"\";s:19:\"requires_connection\";s:2:\"No\";s:13:\"auto_activate\";s:3:\"Yes\";s:11:\"module_tags\";s:7:\"Writing\";s:7:\"feature\";s:0:\"\";s:25:\"additional_search_queries\";s:72:\"cpt, custom post types, portfolio, portfolios, testimonial, testimonials\";}s:32:\"d2bb05ccad3d8789df40ca3abb97336c\";a:14:{s:4:\"name\";s:10:\"Custom CSS\";s:11:\"description\";s:57:\"Customize your site’s CSS without modifying your theme.\";s:14:\"jumpstart_desc\";s:0:\"\";s:4:\"sort\";s:1:\"2\";s:20:\"recommendation_order\";s:0:\"\";s:10:\"introduced\";s:3:\"1.7\";s:7:\"changed\";s:0:\"\";s:10:\"deactivate\";s:0:\"\";s:4:\"free\";s:0:\"\";s:19:\"requires_connection\";s:2:\"No\";s:13:\"auto_activate\";s:3:\"Yes\";s:11:\"module_tags\";s:10:\"Appearance\";s:7:\"feature\";s:0:\"\";s:25:\"additional_search_queries\";s:108:\"css, customize, custom, style, editor, less, sass, preprocessor, font, mobile, appearance, theme, stylesheet\";}s:32:\"a2064eec5b9c7e0d816af71dee7a715f\";a:14:{s:4:\"name\";s:0:\"\";s:11:\"description\";s:0:\"\";s:14:\"jumpstart_desc\";s:0:\"\";s:4:\"sort\";s:0:\"\";s:20:\"recommendation_order\";s:0:\"\";s:10:\"introduced\";s:0:\"\";s:7:\"changed\";s:0:\"\";s:10:\"deactivate\";s:0:\"\";s:4:\"free\";s:0:\"\";s:19:\"requires_connection\";s:0:\"\";s:13:\"auto_activate\";s:0:\"\";s:11:\"module_tags\";s:0:\"\";s:7:\"feature\";s:0:\"\";s:25:\"additional_search_queries\";s:0:\"\";}s:32:\"53a4ec755022ef3953699734c343da02\";a:14:{s:4:\"name\";s:21:\"Enhanced Distribution\";s:11:\"description\";s:27:\"Increase reach and traffic.\";s:14:\"jumpstart_desc\";s:0:\"\";s:4:\"sort\";s:1:\"5\";s:20:\"recommendation_order\";s:0:\"\";s:10:\"introduced\";s:3:\"1.2\";s:7:\"changed\";s:0:\"\";s:10:\"deactivate\";s:0:\"\";s:4:\"free\";s:0:\"\";s:19:\"requires_connection\";s:3:\"Yes\";s:13:\"auto_activate\";s:6:\"Public\";s:11:\"module_tags\";s:7:\"Writing\";s:7:\"feature\";s:7:\"Traffic\";s:25:\"additional_search_queries\";s:54:\"google, seo, firehose, search, broadcast, broadcasting\";}s:32:\"72fecb67ee6704ba0a33e0225316ad06\";a:14:{s:4:\"name\";s:0:\"\";s:11:\"description\";s:0:\"\";s:14:\"jumpstart_desc\";s:0:\"\";s:4:\"sort\";s:0:\"\";s:20:\"recommendation_order\";s:0:\"\";s:10:\"introduced\";s:0:\"\";s:7:\"changed\";s:0:\"\";s:10:\"deactivate\";s:0:\"\";s:4:\"free\";s:0:\"\";s:19:\"requires_connection\";s:0:\"\";s:13:\"auto_activate\";s:0:\"\";s:11:\"module_tags\";s:0:\"\";s:7:\"feature\";s:0:\"\";s:25:\"additional_search_queries\";s:0:\"\";}s:32:\"d56e2886185a9eace719cc57d46770df\";a:14:{s:4:\"name\";s:19:\"Gravatar Hovercards\";s:11:\"description\";s:58:\"Enable pop-up business cards over commenters’ Gravatars.\";s:14:\"jumpstart_desc\";s:131:\"Let commenters link their profiles to their Gravatar accounts, making it easy for your visitors to learn more about your community.\";s:4:\"sort\";s:2:\"11\";s:20:\"recommendation_order\";s:2:\"13\";s:10:\"introduced\";s:3:\"1.1\";s:7:\"changed\";s:0:\"\";s:10:\"deactivate\";s:0:\"\";s:4:\"free\";s:0:\"\";s:19:\"requires_connection\";s:2:\"No\";s:13:\"auto_activate\";s:3:\"Yes\";s:11:\"module_tags\";s:18:\"Social, Appearance\";s:7:\"feature\";s:9:\"Jumpstart\";s:25:\"additional_search_queries\";s:20:\"gravatar, hovercards\";}s:32:\"e391e760617bd0e0736550e34a73d7fe\";a:14:{s:4:\"name\";s:0:\"\";s:11:\"description\";s:0:\"\";s:14:\"jumpstart_desc\";s:0:\"\";s:4:\"sort\";s:0:\"\";s:20:\"recommendation_order\";s:0:\"\";s:10:\"introduced\";s:8:\"2.0.3 ??\";s:7:\"changed\";s:0:\"\";s:10:\"deactivate\";s:0:\"\";s:4:\"free\";s:0:\"\";s:19:\"requires_connection\";s:2:\"No\";s:13:\"auto_activate\";s:3:\"Yes\";s:11:\"module_tags\";s:0:\"\";s:7:\"feature\";s:0:\"\";s:25:\"additional_search_queries\";s:0:\"\";}s:32:\"2e345370766346c616b3c5046e817720\";a:14:{s:4:\"name\";s:15:\"Infinite Scroll\";s:11:\"description\";s:46:\"Add support for infinite scroll to your theme.\";s:14:\"jumpstart_desc\";s:0:\"\";s:4:\"sort\";s:2:\"26\";s:20:\"recommendation_order\";s:0:\"\";s:10:\"introduced\";s:3:\"2.0\";s:7:\"changed\";s:0:\"\";s:10:\"deactivate\";s:0:\"\";s:4:\"free\";s:0:\"\";s:19:\"requires_connection\";s:2:\"No\";s:13:\"auto_activate\";s:2:\"No\";s:11:\"module_tags\";s:10:\"Appearance\";s:7:\"feature\";s:0:\"\";s:25:\"additional_search_queries\";s:33:\"scroll, infinite, infinite scroll\";}s:32:\"bd69edbf134de5fae8fdcf2e70a45b56\";a:14:{s:4:\"name\";s:8:\"JSON API\";s:11:\"description\";s:69:\"Allow applications to securely access your content through the cloud.\";s:14:\"jumpstart_desc\";s:0:\"\";s:4:\"sort\";s:2:\"19\";s:20:\"recommendation_order\";s:0:\"\";s:10:\"introduced\";s:3:\"1.9\";s:7:\"changed\";s:0:\"\";s:10:\"deactivate\";s:0:\"\";s:4:\"free\";s:0:\"\";s:19:\"requires_connection\";s:3:\"Yes\";s:13:\"auto_activate\";s:6:\"Public\";s:11:\"module_tags\";s:19:\"Writing, Developers\";s:7:\"feature\";s:0:\"\";s:25:\"additional_search_queries\";s:50:\"api, rest, develop, developers, json, klout, oauth\";}s:32:\"8110b7a4423aaa619dfa46b8843e10d1\";a:14:{s:4:\"name\";s:14:\"Beautiful Math\";s:11:\"description\";s:85:\"Use LaTeX markup language in posts and pages for complex equations and other geekery.\";s:14:\"jumpstart_desc\";s:0:\"\";s:4:\"sort\";s:2:\"12\";s:20:\"recommendation_order\";s:0:\"\";s:10:\"introduced\";s:3:\"1.1\";s:7:\"changed\";s:0:\"\";s:10:\"deactivate\";s:0:\"\";s:4:\"free\";s:0:\"\";s:19:\"requires_connection\";s:2:\"No\";s:13:\"auto_activate\";s:3:\"Yes\";s:11:\"module_tags\";s:7:\"Writing\";s:7:\"feature\";s:0:\"\";s:25:\"additional_search_queries\";s:47:\"latex, math, equation, equations, formula, code\";}s:32:\"fd7e85d3b4887fa6b6f997d6592c1f33\";a:14:{s:4:\"name\";s:5:\"Likes\";s:11:\"description\";s:70:\"Give visitors an easy way to show their appreciation for your content.\";s:14:\"jumpstart_desc\";s:0:\"\";s:4:\"sort\";s:2:\"23\";s:20:\"recommendation_order\";s:0:\"\";s:10:\"introduced\";s:3:\"2.2\";s:7:\"changed\";s:0:\"\";s:10:\"deactivate\";s:0:\"\";s:4:\"free\";s:0:\"\";s:19:\"requires_connection\";s:3:\"Yes\";s:13:\"auto_activate\";s:2:\"No\";s:11:\"module_tags\";s:6:\"Social\";s:7:\"feature\";s:0:\"\";s:25:\"additional_search_queries\";s:26:\"like, likes, wordpress.com\";}s:32:\"c5dfef41fad5bcdcaae8e315e5cfc420\";a:14:{s:4:\"name\";s:6:\"Manage\";s:11:\"description\";s:76:\"Manage all your sites from a centralized place, https://wordpress.com/sites.\";s:14:\"jumpstart_desc\";s:151:\"Helps you remotely manage plugins, turn on automated updates, and more from <a href=\"https://wordpress.com/plugins/\" target=\"_blank\">wordpress.com</a>.\";s:4:\"sort\";s:1:\"1\";s:20:\"recommendation_order\";s:1:\"3\";s:10:\"introduced\";s:3:\"3.4\";s:7:\"changed\";s:0:\"\";s:10:\"deactivate\";s:0:\"\";s:4:\"free\";s:0:\"\";s:19:\"requires_connection\";s:3:\"Yes\";s:13:\"auto_activate\";s:2:\"No\";s:11:\"module_tags\";s:35:\"Centralized Management, Recommended\";s:7:\"feature\";s:22:\"Recommended, Jumpstart\";s:25:\"additional_search_queries\";s:26:\"manage, management, remote\";}s:32:\"fd6dc399b92bce76013427e3107c314f\";a:14:{s:4:\"name\";s:8:\"Markdown\";s:11:\"description\";s:51:\"Write posts or pages in plain-text Markdown syntax.\";s:14:\"jumpstart_desc\";s:0:\"\";s:4:\"sort\";s:2:\"31\";s:20:\"recommendation_order\";s:0:\"\";s:10:\"introduced\";s:3:\"2.8\";s:7:\"changed\";s:0:\"\";s:10:\"deactivate\";s:0:\"\";s:4:\"free\";s:0:\"\";s:19:\"requires_connection\";s:2:\"No\";s:13:\"auto_activate\";s:2:\"No\";s:11:\"module_tags\";s:7:\"Writing\";s:7:\"feature\";s:0:\"\";s:25:\"additional_search_queries\";s:12:\"md, markdown\";}s:32:\"c49a35b6482b0426cb07ad28ecf5d7df\";a:14:{s:4:\"name\";s:12:\"Mobile Theme\";s:11:\"description\";s:64:\"Optimize your site with a mobile-friendly theme for smartphones.\";s:14:\"jumpstart_desc\";s:0:\"\";s:4:\"sort\";s:2:\"21\";s:20:\"recommendation_order\";s:2:\"11\";s:10:\"introduced\";s:3:\"1.8\";s:7:\"changed\";s:0:\"\";s:10:\"deactivate\";s:0:\"\";s:4:\"free\";s:0:\"\";s:19:\"requires_connection\";s:2:\"No\";s:13:\"auto_activate\";s:2:\"No\";s:11:\"module_tags\";s:31:\"Appearance, Mobile, Recommended\";s:7:\"feature\";s:11:\"Recommended\";s:25:\"additional_search_queries\";s:24:\"mobile, theme, minileven\";}s:32:\"b42e38f6fafd2e4104ebe5bf39b4be47\";a:14:{s:4:\"name\";s:0:\"\";s:11:\"description\";s:0:\"\";s:14:\"jumpstart_desc\";s:0:\"\";s:4:\"sort\";s:0:\"\";s:20:\"recommendation_order\";s:0:\"\";s:10:\"introduced\";s:0:\"\";s:7:\"changed\";s:0:\"\";s:10:\"deactivate\";s:0:\"\";s:4:\"free\";s:0:\"\";s:19:\"requires_connection\";s:0:\"\";s:13:\"auto_activate\";s:0:\"\";s:11:\"module_tags\";s:0:\"\";s:7:\"feature\";s:0:\"\";s:25:\"additional_search_queries\";s:0:\"\";}s:32:\"771cfeeba0d3d23ec344d5e781fb0ae2\";a:14:{s:4:\"name\";s:0:\"\";s:11:\"description\";s:0:\"\";s:14:\"jumpstart_desc\";s:0:\"\";s:4:\"sort\";s:0:\"\";s:20:\"recommendation_order\";s:0:\"\";s:10:\"introduced\";s:0:\"\";s:7:\"changed\";s:0:\"\";s:10:\"deactivate\";s:0:\"\";s:4:\"free\";s:0:\"\";s:19:\"requires_connection\";s:0:\"\";s:13:\"auto_activate\";s:0:\"\";s:11:\"module_tags\";s:0:\"\";s:7:\"feature\";s:0:\"\";s:25:\"additional_search_queries\";s:0:\"\";}s:32:\"54f0661d27c814fc8bde39580181d939\";a:14:{s:4:\"name\";s:0:\"\";s:11:\"description\";s:0:\"\";s:14:\"jumpstart_desc\";s:0:\"\";s:4:\"sort\";s:0:\"\";s:20:\"recommendation_order\";s:0:\"\";s:10:\"introduced\";s:0:\"\";s:7:\"changed\";s:0:\"\";s:10:\"deactivate\";s:0:\"\";s:4:\"free\";s:0:\"\";s:19:\"requires_connection\";s:0:\"\";s:13:\"auto_activate\";s:0:\"\";s:11:\"module_tags\";s:0:\"\";s:7:\"feature\";s:0:\"\";s:25:\"additional_search_queries\";s:0:\"\";}s:32:\"46c4c413b5c72bbd3c3dbd14ff8f8adc\";a:14:{s:4:\"name\";s:0:\"\";s:11:\"description\";s:0:\"\";s:14:\"jumpstart_desc\";s:0:\"\";s:4:\"sort\";s:0:\"\";s:20:\"recommendation_order\";s:0:\"\";s:10:\"introduced\";s:0:\"\";s:7:\"changed\";s:0:\"\";s:10:\"deactivate\";s:0:\"\";s:4:\"free\";s:0:\"\";s:19:\"requires_connection\";s:0:\"\";s:13:\"auto_activate\";s:0:\"\";s:11:\"module_tags\";s:0:\"\";s:7:\"feature\";s:0:\"\";s:25:\"additional_search_queries\";s:0:\"\";}s:32:\"9ea52fa25783e5ceeb6bfaed3268e64e\";a:14:{s:4:\"name\";s:7:\"Monitor\";s:11:\"description\";s:25:\"Reports on site downtime.\";s:14:\"jumpstart_desc\";s:0:\"\";s:4:\"sort\";s:2:\"28\";s:20:\"recommendation_order\";s:2:\"10\";s:10:\"introduced\";s:3:\"2.6\";s:7:\"changed\";s:0:\"\";s:10:\"deactivate\";s:0:\"\";s:4:\"free\";s:0:\"\";s:19:\"requires_connection\";s:3:\"Yes\";s:13:\"auto_activate\";s:2:\"No\";s:11:\"module_tags\";s:11:\"Recommended\";s:7:\"feature\";s:33:\"Recommended, Performance-Security\";s:25:\"additional_search_queries\";s:37:\"monitor, uptime, downtime, monitoring\";}s:32:\"cfcaafd0fcad087899d715e0b877474d\";a:14:{s:4:\"name\";s:13:\"Notifications\";s:11:\"description\";s:84:\"Receive notification of site activity via the admin toolbar and your Mobile devices.\";s:14:\"jumpstart_desc\";s:0:\"\";s:4:\"sort\";s:2:\"13\";s:20:\"recommendation_order\";s:0:\"\";s:10:\"introduced\";s:3:\"1.9\";s:7:\"changed\";s:0:\"\";s:10:\"deactivate\";s:0:\"\";s:4:\"free\";s:0:\"\";s:19:\"requires_connection\";s:3:\"Yes\";s:13:\"auto_activate\";s:3:\"Yes\";s:11:\"module_tags\";s:5:\"Other\";s:7:\"feature\";s:0:\"\";s:25:\"additional_search_queries\";s:62:\"notification, notifications, toolbar, adminbar, push, comments\";}s:32:\"0d18bfa69bec61550c1d813ce64149b0\";a:14:{s:4:\"name\";s:10:\"Omnisearch\";s:11:\"description\";s:66:\"Search your entire database from a single field in your Dashboard.\";s:14:\"jumpstart_desc\";s:0:\"\";s:4:\"sort\";s:2:\"16\";s:20:\"recommendation_order\";s:0:\"\";s:10:\"introduced\";s:3:\"2.3\";s:7:\"changed\";s:0:\"\";s:10:\"deactivate\";s:0:\"\";s:4:\"free\";s:0:\"\";s:19:\"requires_connection\";s:2:\"No\";s:13:\"auto_activate\";s:3:\"Yes\";s:11:\"module_tags\";s:10:\"Developers\";s:7:\"feature\";s:0:\"\";s:25:\"additional_search_queries\";s:6:\"search\";}s:32:\"3f0a11e23118f0788d424b646a6d465f\";a:14:{s:4:\"name\";s:6:\"Photon\";s:11:\"description\";s:27:\"Speed up images and photos.\";s:14:\"jumpstart_desc\";s:141:\"Mirrors and serves your images from our free and fast image CDN, improving your site’s performance with no additional load on your servers.\";s:4:\"sort\";s:2:\"25\";s:20:\"recommendation_order\";s:1:\"1\";s:10:\"introduced\";s:3:\"2.0\";s:7:\"changed\";s:0:\"\";s:10:\"deactivate\";s:0:\"\";s:4:\"free\";s:0:\"\";s:19:\"requires_connection\";s:3:\"Yes\";s:13:\"auto_activate\";s:2:\"No\";s:11:\"module_tags\";s:42:\"Photos and Videos, Appearance, Recommended\";s:7:\"feature\";s:44:\"Recommended, Jumpstart, Performance-Security\";s:25:\"additional_search_queries\";s:38:\"photon, image, cdn, performance, speed\";}s:32:\"e37cfbcb72323fb1fe8255a2edb4d738\";a:14:{s:4:\"name\";s:13:\"Post by Email\";s:11:\"description\";s:58:\"Publish posts by email, using any device and email client.\";s:14:\"jumpstart_desc\";s:0:\"\";s:4:\"sort\";s:2:\"14\";s:20:\"recommendation_order\";s:0:\"\";s:10:\"introduced\";s:3:\"2.0\";s:7:\"changed\";s:0:\"\";s:10:\"deactivate\";s:0:\"\";s:4:\"free\";s:0:\"\";s:19:\"requires_connection\";s:3:\"Yes\";s:13:\"auto_activate\";s:3:\"Yes\";s:11:\"module_tags\";s:7:\"Writing\";s:7:\"feature\";s:0:\"\";s:25:\"additional_search_queries\";s:20:\"post by email, email\";}s:32:\"728290d131a480bfe7b9e405d7cd925f\";a:14:{s:4:\"name\";s:7:\"Protect\";s:11:\"description\";s:28:\"Prevent brute force attacks.\";s:14:\"jumpstart_desc\";s:0:\"\";s:4:\"sort\";s:1:\"1\";s:20:\"recommendation_order\";s:1:\"4\";s:10:\"introduced\";s:3:\"3.4\";s:7:\"changed\";s:0:\"\";s:10:\"deactivate\";s:0:\"\";s:4:\"free\";s:0:\"\";s:19:\"requires_connection\";s:3:\"Yes\";s:13:\"auto_activate\";s:3:\"Yes\";s:11:\"module_tags\";s:11:\"Recommended\";s:7:\"feature\";s:33:\"Recommended, Performance-Security\";s:25:\"additional_search_queries\";s:65:\"security, secure, protection, botnet, brute force, protect, login\";}s:32:\"f9ce784babbbf4dcca99b8cd2ceb420c\";a:14:{s:4:\"name\";s:9:\"Publicize\";s:11:\"description\";s:30:\"Automatically promote content.\";s:14:\"jumpstart_desc\";s:0:\"\";s:4:\"sort\";s:2:\"10\";s:20:\"recommendation_order\";s:1:\"7\";s:10:\"introduced\";s:3:\"2.0\";s:7:\"changed\";s:0:\"\";s:10:\"deactivate\";s:0:\"\";s:4:\"free\";s:0:\"\";s:19:\"requires_connection\";s:3:\"Yes\";s:13:\"auto_activate\";s:3:\"Yes\";s:11:\"module_tags\";s:19:\"Social, Recommended\";s:7:\"feature\";s:20:\"Recommended, Traffic\";s:25:\"additional_search_queries\";s:107:\"facebook, twitter, google+, googleplus, google, path, tumblr, linkedin, social, tweet, connections, sharing\";}s:32:\"052c03877dd3d296a71531cb07ad939a\";a:14:{s:4:\"name\";s:0:\"\";s:11:\"description\";s:0:\"\";s:14:\"jumpstart_desc\";s:0:\"\";s:4:\"sort\";s:0:\"\";s:20:\"recommendation_order\";s:0:\"\";s:10:\"introduced\";s:0:\"\";s:7:\"changed\";s:0:\"\";s:10:\"deactivate\";s:0:\"\";s:4:\"free\";s:0:\"\";s:19:\"requires_connection\";s:0:\"\";s:13:\"auto_activate\";s:0:\"\";s:11:\"module_tags\";s:0:\"\";s:7:\"feature\";s:0:\"\";s:25:\"additional_search_queries\";s:0:\"\";}s:32:\"52edecb2a75222e75b2dce4356a4efce\";a:14:{s:4:\"name\";s:13:\"Related Posts\";s:11:\"description\";s:24:\"Display similar content.\";s:14:\"jumpstart_desc\";s:113:\"Keep visitors engaged on your blog by highlighting relevant and new content at the bottom of each published post.\";s:4:\"sort\";s:2:\"29\";s:20:\"recommendation_order\";s:1:\"9\";s:10:\"introduced\";s:3:\"2.9\";s:7:\"changed\";s:0:\"\";s:10:\"deactivate\";s:0:\"\";s:4:\"free\";s:0:\"\";s:19:\"requires_connection\";s:3:\"Yes\";s:13:\"auto_activate\";s:2:\"No\";s:11:\"module_tags\";s:11:\"Recommended\";s:7:\"feature\";s:31:\"Recommended, Jumpstart, Traffic\";s:25:\"additional_search_queries\";s:22:\"related, related posts\";}s:32:\"8b059cb50a66b717f1ec842e736b858c\";a:14:{s:4:\"name\";s:7:\"Sharing\";s:11:\"description\";s:32:\"Visitors can share your content.\";s:14:\"jumpstart_desc\";s:116:\"Twitter, Facebook and Google+ buttons at the bottom of each post, making it easy for visitors to share your content.\";s:4:\"sort\";s:1:\"7\";s:20:\"recommendation_order\";s:1:\"6\";s:10:\"introduced\";s:3:\"1.1\";s:7:\"changed\";s:3:\"1.2\";s:10:\"deactivate\";s:0:\"\";s:4:\"free\";s:0:\"\";s:19:\"requires_connection\";s:2:\"No\";s:13:\"auto_activate\";s:3:\"Yes\";s:11:\"module_tags\";s:19:\"Social, Recommended\";s:7:\"feature\";s:31:\"Recommended, Jumpstart, Traffic\";s:25:\"additional_search_queries\";s:141:\"share, sharing, sharedaddy, buttons, icons, email, facebook, twitter, google+, linkedin, pinterest, pocket, press this, print, reddit, tumblr\";}s:32:\"a6d2394329871857401255533a9873f7\";a:14:{s:4:\"name\";s:16:\"Shortcode Embeds\";s:11:\"description\";s:77:\"Embed content from YouTube, Vimeo, SlideShare, and more, no coding necessary.\";s:14:\"jumpstart_desc\";s:0:\"\";s:4:\"sort\";s:1:\"3\";s:20:\"recommendation_order\";s:0:\"\";s:10:\"introduced\";s:3:\"1.1\";s:7:\"changed\";s:3:\"1.2\";s:10:\"deactivate\";s:0:\"\";s:4:\"free\";s:0:\"\";s:19:\"requires_connection\";s:2:\"No\";s:13:\"auto_activate\";s:3:\"Yes\";s:11:\"module_tags\";s:46:\"Photos and Videos, Social, Writing, Appearance\";s:7:\"feature\";s:0:\"\";s:25:\"additional_search_queries\";s:251:\"shortcodes, shortcode, embeds, media, bandcamp, blip.tv, dailymotion, digg, facebook, flickr, google calendars, google maps, google+, polldaddy, recipe, recipes, scribd, slideshare, slideshow, slideshows, soundcloud, ted, twitter, vimeo, vine, youtube\";}s:32:\"21496e2897ea5f81605e2f2ac3beb921\";a:14:{s:4:\"name\";s:16:\"WP.me Shortlinks\";s:11:\"description\";s:56:\"Enable WP.me-powered shortlinks for all posts and pages.\";s:14:\"jumpstart_desc\";s:0:\"\";s:4:\"sort\";s:1:\"8\";s:20:\"recommendation_order\";s:0:\"\";s:10:\"introduced\";s:3:\"1.1\";s:7:\"changed\";s:0:\"\";s:10:\"deactivate\";s:0:\"\";s:4:\"free\";s:0:\"\";s:19:\"requires_connection\";s:3:\"Yes\";s:13:\"auto_activate\";s:3:\"Yes\";s:11:\"module_tags\";s:6:\"Social\";s:7:\"feature\";s:0:\"\";s:25:\"additional_search_queries\";s:17:\"shortlinks, wp.me\";}s:32:\"e2a54a5d7879a4162709e6ffb540dd08\";a:14:{s:4:\"name\";s:9:\"Site Icon\";s:11:\"description\";s:29:\"Add a site icon to your site.\";s:14:\"jumpstart_desc\";s:0:\"\";s:4:\"sort\";s:2:\"22\";s:20:\"recommendation_order\";s:0:\"\";s:10:\"introduced\";s:3:\"3.2\";s:7:\"changed\";s:0:\"\";s:10:\"deactivate\";s:0:\"\";s:4:\"free\";s:0:\"\";s:19:\"requires_connection\";s:2:\"No\";s:13:\"auto_activate\";s:2:\"No\";s:11:\"module_tags\";s:5:\"Other\";s:7:\"feature\";s:0:\"\";s:25:\"additional_search_queries\";s:24:\"favicon, icon, site icon\";}s:32:\"59a23643437358a9b557f1d1e20ab040\";a:14:{s:4:\"name\";s:0:\"\";s:11:\"description\";s:0:\"\";s:14:\"jumpstart_desc\";s:0:\"\";s:4:\"sort\";s:0:\"\";s:20:\"recommendation_order\";s:0:\"\";s:10:\"introduced\";s:0:\"\";s:7:\"changed\";s:0:\"\";s:10:\"deactivate\";s:0:\"\";s:4:\"free\";s:0:\"\";s:19:\"requires_connection\";s:0:\"\";s:13:\"auto_activate\";s:0:\"\";s:11:\"module_tags\";s:0:\"\";s:7:\"feature\";s:0:\"\";s:25:\"additional_search_queries\";s:0:\"\";}s:32:\"6a90f97c3194cfca5671728eaaeaf15e\";a:14:{s:4:\"name\";s:14:\"Single Sign On\";s:11:\"description\";s:27:\"Secure user authentication.\";s:14:\"jumpstart_desc\";s:98:\"Lets you log in to all your Jetpack-enabled sites with one click using your WordPress.com account.\";s:4:\"sort\";s:2:\"30\";s:20:\"recommendation_order\";s:1:\"5\";s:10:\"introduced\";s:3:\"2.6\";s:7:\"changed\";s:0:\"\";s:10:\"deactivate\";s:0:\"\";s:4:\"free\";s:0:\"\";s:19:\"requires_connection\";s:3:\"Yes\";s:13:\"auto_activate\";s:2:\"No\";s:11:\"module_tags\";s:10:\"Developers\";s:7:\"feature\";s:31:\"Jumpstart, Performance-Security\";s:25:\"additional_search_queries\";s:34:\"sso, single sign on, login, log in\";}s:32:\"b65604e920392e2f7134b646760b75e8\";a:14:{s:4:\"name\";s:10:\"Site Stats\";s:11:\"description\";s:35:\"Collect traffic stats and insights.\";s:14:\"jumpstart_desc\";s:0:\"\";s:4:\"sort\";s:1:\"1\";s:20:\"recommendation_order\";s:1:\"2\";s:10:\"introduced\";s:3:\"1.1\";s:7:\"changed\";s:0:\"\";s:10:\"deactivate\";s:0:\"\";s:4:\"free\";s:0:\"\";s:19:\"requires_connection\";s:3:\"Yes\";s:13:\"auto_activate\";s:3:\"Yes\";s:11:\"module_tags\";s:23:\"Site Stats, Recommended\";s:7:\"feature\";s:20:\"Recommended, Traffic\";s:25:\"additional_search_queries\";s:54:\"statistics, tracking, analytics, views, traffic, stats\";}s:32:\"23a586dd7ead00e69ec53eb32ef740e4\";a:14:{s:4:\"name\";s:13:\"Subscriptions\";s:11:\"description\";s:88:\"Allow users to subscribe to your posts and comments and receive notifications via email.\";s:14:\"jumpstart_desc\";s:126:\"Give visitors two easy subscription options — while commenting, or via a separate email subscription widget you can display.\";s:4:\"sort\";s:1:\"9\";s:20:\"recommendation_order\";s:1:\"8\";s:10:\"introduced\";s:3:\"1.2\";s:7:\"changed\";s:0:\"\";s:10:\"deactivate\";s:0:\"\";s:4:\"free\";s:0:\"\";s:19:\"requires_connection\";s:3:\"Yes\";s:13:\"auto_activate\";s:3:\"Yes\";s:11:\"module_tags\";s:6:\"Social\";s:7:\"feature\";s:9:\"Jumpstart\";s:25:\"additional_search_queries\";s:74:\"subscriptions, subscription, email, follow, followers, subscribers, signup\";}s:32:\"1d978b8d84d2f378fe1a702a67633b6d\";a:14:{s:4:\"name\";s:0:\"\";s:11:\"description\";s:0:\"\";s:14:\"jumpstart_desc\";s:0:\"\";s:4:\"sort\";s:0:\"\";s:20:\"recommendation_order\";s:0:\"\";s:10:\"introduced\";s:0:\"\";s:7:\"changed\";s:0:\"\";s:10:\"deactivate\";s:0:\"\";s:4:\"free\";s:0:\"\";s:19:\"requires_connection\";s:0:\"\";s:13:\"auto_activate\";s:0:\"\";s:11:\"module_tags\";s:0:\"\";s:7:\"feature\";s:0:\"\";s:25:\"additional_search_queries\";s:0:\"\";}s:32:\"b3b983461d7f3d27322a3551ed8a9405\";a:14:{s:4:\"name\";s:15:\"Tiled Galleries\";s:11:\"description\";s:73:\"Display your image galleries in a variety of sleek, graphic arrangements.\";s:14:\"jumpstart_desc\";s:0:\"\";s:4:\"sort\";s:2:\"24\";s:20:\"recommendation_order\";s:0:\"\";s:10:\"introduced\";s:3:\"2.1\";s:7:\"changed\";s:0:\"\";s:10:\"deactivate\";s:0:\"\";s:4:\"free\";s:0:\"\";s:19:\"requires_connection\";s:2:\"No\";s:13:\"auto_activate\";s:2:\"No\";s:11:\"module_tags\";s:17:\"Photos and Videos\";s:7:\"feature\";s:0:\"\";s:25:\"additional_search_queries\";s:43:\"gallery, tiles, tiled, grid, mosaic, images\";}s:32:\"d924e5b05722b0e104448543598f54c0\";a:14:{s:4:\"name\";s:0:\"\";s:11:\"description\";s:0:\"\";s:14:\"jumpstart_desc\";s:0:\"\";s:4:\"sort\";s:0:\"\";s:20:\"recommendation_order\";s:0:\"\";s:10:\"introduced\";s:0:\"\";s:7:\"changed\";s:0:\"\";s:10:\"deactivate\";s:0:\"\";s:4:\"free\";s:0:\"\";s:19:\"requires_connection\";s:0:\"\";s:13:\"auto_activate\";s:0:\"\";s:11:\"module_tags\";s:0:\"\";s:7:\"feature\";s:0:\"\";s:25:\"additional_search_queries\";s:0:\"\";}s:32:\"36741583b10c521997e563ad8e1e8b77\";a:14:{s:4:\"name\";s:10:\"VaultPress\";s:11:\"description\";s:27:\"Backups and security scans.\";s:14:\"jumpstart_desc\";s:0:\"\";s:4:\"sort\";s:2:\"32\";s:20:\"recommendation_order\";s:0:\"\";s:10:\"introduced\";s:5:\"0:1.2\";s:7:\"changed\";s:0:\"\";s:10:\"deactivate\";s:5:\"false\";s:4:\"free\";s:5:\"false\";s:19:\"requires_connection\";s:3:\"Yes\";s:13:\"auto_activate\";s:3:\"Yes\";s:11:\"module_tags\";s:0:\"\";s:7:\"feature\";s:20:\"Performance-Security\";s:25:\"additional_search_queries\";s:28:\"vaultpress, backup, security\";}s:32:\"2b9b44f09b5459617d68dd82ee17002a\";a:14:{s:4:\"name\";s:17:\"Site Verification\";s:11:\"description\";s:77:\"Verify your site or domain with Google Search Console, Pinterest, and others.\";s:14:\"jumpstart_desc\";s:0:\"\";s:4:\"sort\";s:2:\"33\";s:20:\"recommendation_order\";s:0:\"\";s:10:\"introduced\";s:3:\"3.0\";s:7:\"changed\";s:0:\"\";s:10:\"deactivate\";s:0:\"\";s:4:\"free\";s:0:\"\";s:19:\"requires_connection\";s:2:\"No\";s:13:\"auto_activate\";s:3:\"Yes\";s:11:\"module_tags\";s:0:\"\";s:7:\"feature\";s:0:\"\";s:25:\"additional_search_queries\";s:56:\"webmaster, seo, google, bing, pinterest, search, console\";}s:32:\"5ab4c0db7c42e10e646342da0274c491\";a:14:{s:4:\"name\";s:10:\"VideoPress\";s:11:\"description\";s:68:\"Upload and embed videos right on your site. (Subscription required.)\";s:14:\"jumpstart_desc\";s:0:\"\";s:4:\"sort\";s:2:\"27\";s:20:\"recommendation_order\";s:0:\"\";s:10:\"introduced\";s:3:\"2.5\";s:7:\"changed\";s:0:\"\";s:10:\"deactivate\";s:0:\"\";s:4:\"free\";s:5:\"false\";s:19:\"requires_connection\";s:3:\"Yes\";s:13:\"auto_activate\";s:0:\"\";s:11:\"module_tags\";s:17:\"Photos and Videos\";s:7:\"feature\";s:0:\"\";s:25:\"additional_search_queries\";s:25:\"video, videos, videopress\";}s:32:\"60a1d3aa38bc0fe1039e59dd60888543\";a:14:{s:4:\"name\";s:17:\"Widget Visibility\";s:11:\"description\";s:57:\"Specify which widgets appear on which pages of your site.\";s:14:\"jumpstart_desc\";s:0:\"\";s:4:\"sort\";s:2:\"17\";s:20:\"recommendation_order\";s:0:\"\";s:10:\"introduced\";s:3:\"2.4\";s:7:\"changed\";s:0:\"\";s:10:\"deactivate\";s:0:\"\";s:4:\"free\";s:0:\"\";s:19:\"requires_connection\";s:2:\"No\";s:13:\"auto_activate\";s:3:\"Yes\";s:11:\"module_tags\";s:10:\"Appearance\";s:7:\"feature\";s:0:\"\";s:25:\"additional_search_queries\";s:54:\"widget visibility, logic, conditional, widgets, widget\";}s:32:\"174ed3416476c2cb9ff5b0f671280b15\";a:14:{s:4:\"name\";s:21:\"Extra Sidebar Widgets\";s:11:\"description\";s:79:\"Add images, Twitter streams, your site’s RSS links, and more to your sidebar.\";s:14:\"jumpstart_desc\";s:0:\"\";s:4:\"sort\";s:1:\"4\";s:20:\"recommendation_order\";s:0:\"\";s:10:\"introduced\";s:3:\"1.2\";s:7:\"changed\";s:0:\"\";s:10:\"deactivate\";s:0:\"\";s:4:\"free\";s:0:\"\";s:19:\"requires_connection\";s:2:\"No\";s:13:\"auto_activate\";s:3:\"Yes\";s:11:\"module_tags\";s:18:\"Social, Appearance\";s:7:\"feature\";s:0:\"\";s:25:\"additional_search_queries\";s:65:\"widget, widgets, facebook, gallery, twitter, gravatar, image, rss\";}s:32:\"28b931a1db19bd24869bd54b14e733d5\";a:14:{s:4:\"name\";s:0:\"\";s:11:\"description\";s:0:\"\";s:14:\"jumpstart_desc\";s:0:\"\";s:4:\"sort\";s:0:\"\";s:20:\"recommendation_order\";s:0:\"\";s:10:\"introduced\";s:0:\"\";s:7:\"changed\";s:0:\"\";s:10:\"deactivate\";s:0:\"\";s:4:\"free\";s:0:\"\";s:19:\"requires_connection\";s:0:\"\";s:13:\"auto_activate\";s:0:\"\";s:11:\"module_tags\";s:0:\"\";s:7:\"feature\";s:0:\"\";s:25:\"additional_search_queries\";s:0:\"\";}}}", "yes");
INSERT INTO wp_lofaro_labs_scroll_options VALUES("349", "jetpack_available_modules", "a:1:{s:5:\"3.8.2\";a:36:{s:18:\"after-the-deadline\";s:3:\"1.1\";s:8:\"carousel\";s:3:\"1.5\";s:8:\"comments\";s:3:\"1.4\";s:12:\"contact-form\";s:3:\"1.3\";s:20:\"custom-content-types\";s:3:\"3.1\";s:10:\"custom-css\";s:3:\"1.7\";s:21:\"enhanced-distribution\";s:3:\"1.2\";s:19:\"gravatar-hovercards\";s:3:\"1.1\";s:15:\"infinite-scroll\";s:3:\"2.0\";s:8:\"json-api\";s:3:\"1.9\";s:5:\"latex\";s:3:\"1.1\";s:5:\"likes\";s:3:\"2.2\";s:6:\"manage\";s:3:\"3.4\";s:8:\"markdown\";s:3:\"2.8\";s:9:\"minileven\";s:3:\"1.8\";s:7:\"monitor\";s:3:\"2.6\";s:5:\"notes\";s:3:\"1.9\";s:10:\"omnisearch\";s:3:\"2.3\";s:6:\"photon\";s:3:\"2.0\";s:13:\"post-by-email\";s:3:\"2.0\";s:7:\"protect\";s:3:\"3.4\";s:9:\"publicize\";s:3:\"2.0\";s:13:\"related-posts\";s:3:\"2.9\";s:10:\"sharedaddy\";s:3:\"1.1\";s:10:\"shortcodes\";s:3:\"1.1\";s:10:\"shortlinks\";s:3:\"1.1\";s:9:\"site-icon\";s:3:\"3.2\";s:3:\"sso\";s:3:\"2.6\";s:5:\"stats\";s:3:\"1.1\";s:13:\"subscriptions\";s:3:\"1.2\";s:13:\"tiled-gallery\";s:3:\"2.1\";s:10:\"vaultpress\";s:5:\"0:1.2\";s:18:\"verification-tools\";s:3:\"3.0\";s:10:\"videopress\";s:3:\"2.5\";s:17:\"widget-visibility\";s:3:\"2.4\";s:7:\"widgets\";s:3:\"1.2\";}}", "yes");
INSERT INTO wp_lofaro_labs_scroll_options VALUES("351", "jetpack_security_report", "a:0:{}", "yes");
INSERT INTO wp_lofaro_labs_scroll_options VALUES("352", "_site_transient_timeout_security_report_performed_recently", "1451935243", "yes");
INSERT INTO wp_lofaro_labs_scroll_options VALUES("353", "_site_transient_security_report_performed_recently", "1", "yes");
INSERT INTO wp_lofaro_labs_scroll_options VALUES("354", "jetpack_unique_connection", "a:1:{s:12:\"disconnected\";i:1;}", "yes");
INSERT INTO wp_lofaro_labs_scroll_options VALUES("358", "theme_mods_imbalance2", "a:2:{i:0;b:0;s:18:\"nav_menu_locations\";a:3:{s:12:\"header-right\";i:3;s:11:\"footer-left\";i:0;s:12:\"footer-right\";i:0;}}", "yes");
INSERT INTO wp_lofaro_labs_scroll_options VALUES("361", "imbalance2_theme_options", "a:8:{s:10:\"navigation\";s:1:\"1\";s:5:\"color\";s:7:\"#b0b0b0\";s:4:\"font\";s:1:\"1\";s:6:\"google\";s:0:\"\";s:7:\"favicon\";s:0:\"\";s:11:\"images_only\";i:0;s:7:\"related\";i:0;s:5:\"fluid\";i:0;}", "yes");
INSERT INTO wp_lofaro_labs_scroll_options VALUES("388", "disable_comments_options", "a:5:{s:19:\"disabled_post_types\";a:3:{i:0;s:4:\"post\";i:1;s:4:\"page\";i:2;s:10:\"attachment\";}s:17:\"remove_everywhere\";b:1;s:9:\"permanent\";b:0;s:16:\"extra_post_types\";b:0;s:10:\"db_version\";i:6;}", "yes");
INSERT INTO wp_lofaro_labs_scroll_options VALUES("391", "nav_menu_options", "a:2:{i:0;b:0;s:8:\"auto_add\";a:0:{}}", "yes");
INSERT INTO wp_lofaro_labs_scroll_options VALUES("399", "_transient_timeout_settings_errors", "1451945637", "no");
INSERT INTO wp_lofaro_labs_scroll_options VALUES("400", "_transient_settings_errors", "a:1:{i:0;a:4:{s:7:\"setting\";s:7:\"general\";s:4:\"code\";s:16:\"settings_updated\";s:7:\"message\";s:15:\"Settings saved.\";s:4:\"type\";s:7:\"updated\";}}", "no");
INSERT INTO wp_lofaro_labs_scroll_options VALUES("565", "_site_transient_timeout_browser_c57d0fad98b69395de107549dcc6d347", "1453134265", "yes");
INSERT INTO wp_lofaro_labs_scroll_options VALUES("566", "_site_transient_browser_c57d0fad98b69395de107549dcc6d347", "a:9:{s:8:\"platform\";s:9:\"Macintosh\";s:4:\"name\";s:6:\"Chrome\";s:7:\"version\";s:13:\"47.0.2526.106\";s:10:\"update_url\";s:28:\"http://www.google.com/chrome\";s:7:\"img_src\";s:49:\"http://s.wordpress.org/images/browsers/chrome.png\";s:11:\"img_src_ssl\";s:48:\"https://wordpress.org/images/browsers/chrome.png\";s:15:\"current_version\";s:2:\"18\";s:7:\"upgrade\";b:0;s:8:\"insecure\";b:0;}", "yes");
INSERT INTO wp_lofaro_labs_scroll_options VALUES("837", "_site_transient_timeout_browser_102f6e1c06450491a2ad9f5ce48bb831", "1454088719", "yes");
INSERT INTO wp_lofaro_labs_scroll_options VALUES("838", "_site_transient_browser_102f6e1c06450491a2ad9f5ce48bb831", "a:9:{s:8:\"platform\";s:9:\"Macintosh\";s:4:\"name\";s:6:\"Chrome\";s:7:\"version\";s:13:\"47.0.2526.111\";s:10:\"update_url\";s:28:\"http://www.google.com/chrome\";s:7:\"img_src\";s:49:\"http://s.wordpress.org/images/browsers/chrome.png\";s:11:\"img_src_ssl\";s:48:\"https://wordpress.org/images/browsers/chrome.png\";s:15:\"current_version\";s:2:\"18\";s:7:\"upgrade\";b:0;s:8:\"insecure\";b:0;}", "yes");
INSERT INTO wp_lofaro_labs_scroll_options VALUES("1935", "_site_transient_timeout_browser_16665463245ffa641313df40020546b5", "1458058575", "yes");
INSERT INTO wp_lofaro_labs_scroll_options VALUES("1936", "_site_transient_browser_16665463245ffa641313df40020546b5", "a:9:{s:8:\"platform\";s:9:\"Macintosh\";s:4:\"name\";s:6:\"Chrome\";s:7:\"version\";s:13:\"48.0.2564.116\";s:10:\"update_url\";s:28:\"http://www.google.com/chrome\";s:7:\"img_src\";s:49:\"http://s.wordpress.org/images/browsers/chrome.png\";s:11:\"img_src_ssl\";s:48:\"https://wordpress.org/images/browsers/chrome.png\";s:15:\"current_version\";s:2:\"18\";s:7:\"upgrade\";b:0;s:8:\"insecure\";b:0;}", "yes");
INSERT INTO wp_lofaro_labs_scroll_options VALUES("4083", "_site_transient_timeout_browser_c0d0782a06686b51c144080c9fa19674", "1463683433", "yes");
INSERT INTO wp_lofaro_labs_scroll_options VALUES("4084", "_site_transient_browser_c0d0782a06686b51c144080c9fa19674", "a:9:{s:8:\"platform\";s:9:\"Macintosh\";s:4:\"name\";s:6:\"Chrome\";s:7:\"version\";s:12:\"50.0.2661.94\";s:10:\"update_url\";s:28:\"http://www.google.com/chrome\";s:7:\"img_src\";s:49:\"http://s.wordpress.org/images/browsers/chrome.png\";s:11:\"img_src_ssl\";s:48:\"https://wordpress.org/images/browsers/chrome.png\";s:15:\"current_version\";s:2:\"18\";s:7:\"upgrade\";b:0;s:8:\"insecure\";b:0;}", "yes");
INSERT INTO wp_lofaro_labs_scroll_options VALUES("5075", "auto_core_update_notified", "a:4:{s:4:\"type\";s:6:\"manual\";s:5:\"email\";s:17:\"dan@danlofaro.com\";s:7:\"version\";s:5:\"4.7.1\";s:9:\"timestamp\";i:1484680039;}", "yes");
INSERT INTO wp_lofaro_labs_scroll_options VALUES("6946", "_site_transient_timeout_browser_1b9ac2a15647e9b5f8ac9c00060fa7ce", "1474600202", "yes");
INSERT INTO wp_lofaro_labs_scroll_options VALUES("6947", "_site_transient_browser_1b9ac2a15647e9b5f8ac9c00060fa7ce", "a:9:{s:8:\"platform\";s:9:\"Macintosh\";s:4:\"name\";s:6:\"Chrome\";s:7:\"version\";s:13:\"52.0.2743.116\";s:10:\"update_url\";s:28:\"http://www.google.com/chrome\";s:7:\"img_src\";s:49:\"http://s.wordpress.org/images/browsers/chrome.png\";s:11:\"img_src_ssl\";s:48:\"https://wordpress.org/images/browsers/chrome.png\";s:15:\"current_version\";s:2:\"18\";s:7:\"upgrade\";b:0;s:8:\"insecure\";b:0;}", "yes");
INSERT INTO wp_lofaro_labs_scroll_options VALUES("7115", "_site_transient_timeout_browser_8a252acff6e64d3fd36b036f7c3430d4", "1475069964", "yes");
INSERT INTO wp_lofaro_labs_scroll_options VALUES("7116", "_site_transient_browser_8a252acff6e64d3fd36b036f7c3430d4", "a:9:{s:8:\"platform\";s:9:\"Macintosh\";s:4:\"name\";s:6:\"Chrome\";s:7:\"version\";s:13:\"52.0.2743.116\";s:10:\"update_url\";s:28:\"http://www.google.com/chrome\";s:7:\"img_src\";s:49:\"http://s.wordpress.org/images/browsers/chrome.png\";s:11:\"img_src_ssl\";s:48:\"https://wordpress.org/images/browsers/chrome.png\";s:15:\"current_version\";s:2:\"18\";s:7:\"upgrade\";b:0;s:8:\"insecure\";b:0;}", "yes");
INSERT INTO wp_lofaro_labs_scroll_options VALUES("7835", "_site_transient_timeout_browser_ba99042ddf1ce92babd6fbeaf08f26bd", "1477635445", "yes");
INSERT INTO wp_lofaro_labs_scroll_options VALUES("7836", "_site_transient_browser_ba99042ddf1ce92babd6fbeaf08f26bd", "a:9:{s:8:\"platform\";s:9:\"Macintosh\";s:4:\"name\";s:6:\"Chrome\";s:7:\"version\";s:13:\"53.0.2785.143\";s:10:\"update_url\";s:28:\"http://www.google.com/chrome\";s:7:\"img_src\";s:49:\"http://s.wordpress.org/images/browsers/chrome.png\";s:11:\"img_src_ssl\";s:48:\"https://wordpress.org/images/browsers/chrome.png\";s:15:\"current_version\";s:2:\"18\";s:7:\"upgrade\";b:0;s:8:\"insecure\";b:0;}", "yes");
INSERT INTO wp_lofaro_labs_scroll_options VALUES("7963", "_site_transient_timeout_browser_7b8bf67cfd29599b52e69d8f0721ac86", "1477951830", "yes");
INSERT INTO wp_lofaro_labs_scroll_options VALUES("7964", "_site_transient_browser_7b8bf67cfd29599b52e69d8f0721ac86", "a:9:{s:8:\"platform\";s:9:\"Macintosh\";s:4:\"name\";s:6:\"Chrome\";s:7:\"version\";s:13:\"53.0.2785.143\";s:10:\"update_url\";s:28:\"http://www.google.com/chrome\";s:7:\"img_src\";s:49:\"http://s.wordpress.org/images/browsers/chrome.png\";s:11:\"img_src_ssl\";s:48:\"https://wordpress.org/images/browsers/chrome.png\";s:15:\"current_version\";s:2:\"18\";s:7:\"upgrade\";b:0;s:8:\"insecure\";b:0;}", "yes");
INSERT INTO wp_lofaro_labs_scroll_options VALUES("8100", "_site_transient_timeout_browser_87e996a567ff01141cb6e7c44c3d8db5", "1478482502", "yes");
INSERT INTO wp_lofaro_labs_scroll_options VALUES("8101", "_site_transient_browser_87e996a567ff01141cb6e7c44c3d8db5", "a:9:{s:8:\"platform\";s:9:\"Macintosh\";s:4:\"name\";s:6:\"Chrome\";s:7:\"version\";s:12:\"54.0.2840.71\";s:10:\"update_url\";s:28:\"http://www.google.com/chrome\";s:7:\"img_src\";s:49:\"http://s.wordpress.org/images/browsers/chrome.png\";s:11:\"img_src_ssl\";s:48:\"https://wordpress.org/images/browsers/chrome.png\";s:15:\"current_version\";s:2:\"18\";s:7:\"upgrade\";b:0;s:8:\"insecure\";b:0;}", "yes");
INSERT INTO wp_lofaro_labs_scroll_options VALUES("8161", "_site_transient_timeout_browser_7e97349c9563f79ce3df7d1d443331a4", "1478542209", "yes");
INSERT INTO wp_lofaro_labs_scroll_options VALUES("8162", "_site_transient_browser_7e97349c9563f79ce3df7d1d443331a4", "a:9:{s:8:\"platform\";s:9:\"Macintosh\";s:4:\"name\";s:6:\"Chrome\";s:7:\"version\";s:12:\"54.0.2840.71\";s:10:\"update_url\";s:28:\"http://www.google.com/chrome\";s:7:\"img_src\";s:49:\"http://s.wordpress.org/images/browsers/chrome.png\";s:11:\"img_src_ssl\";s:48:\"https://wordpress.org/images/browsers/chrome.png\";s:15:\"current_version\";s:2:\"18\";s:7:\"upgrade\";b:0;s:8:\"insecure\";b:0;}", "yes");
INSERT INTO wp_lofaro_labs_scroll_options VALUES("8930", "_site_transient_timeout_browser_63c0f29397915831da643e30e327a91c", "1481264401", "yes");
INSERT INTO wp_lofaro_labs_scroll_options VALUES("8931", "_site_transient_browser_63c0f29397915831da643e30e327a91c", "a:9:{s:8:\"platform\";s:9:\"Macintosh\";s:4:\"name\";s:6:\"Chrome\";s:7:\"version\";s:12:\"54.0.2840.98\";s:10:\"update_url\";s:28:\"http://www.google.com/chrome\";s:7:\"img_src\";s:49:\"http://s.wordpress.org/images/browsers/chrome.png\";s:11:\"img_src_ssl\";s:48:\"https://wordpress.org/images/browsers/chrome.png\";s:15:\"current_version\";s:2:\"18\";s:7:\"upgrade\";b:0;s:8:\"insecure\";b:0;}", "yes");
INSERT INTO wp_lofaro_labs_scroll_options VALUES("8979", "_site_transient_timeout_browser_aa9f7db3c4a47183582943c91b21e3e3", "1481383844", "yes");
INSERT INTO wp_lofaro_labs_scroll_options VALUES("8980", "_site_transient_browser_aa9f7db3c4a47183582943c91b21e3e3", "a:9:{s:8:\"platform\";s:6:\"iPhone\";s:4:\"name\";s:6:\"iPhone\";s:7:\"version\";s:8:\"601.1.46\";s:10:\"update_url\";s:0:\"\";s:7:\"img_src\";s:0:\"\";s:11:\"img_src_ssl\";s:0:\"\";s:15:\"current_version\";s:0:\"\";s:7:\"upgrade\";b:0;s:8:\"insecure\";b:0;}", "yes");
INSERT INTO wp_lofaro_labs_scroll_options VALUES("9081", "_site_transient_timeout_browser_28b7617ebd1af6c43abd93f8725ccf3a", "1481672891", "yes");
INSERT INTO wp_lofaro_labs_scroll_options VALUES("9082", "_site_transient_browser_28b7617ebd1af6c43abd93f8725ccf3a", "a:9:{s:8:\"platform\";s:9:\"Macintosh\";s:4:\"name\";s:6:\"Chrome\";s:7:\"version\";s:12:\"54.0.2840.98\";s:10:\"update_url\";s:28:\"http://www.google.com/chrome\";s:7:\"img_src\";s:49:\"http://s.wordpress.org/images/browsers/chrome.png\";s:11:\"img_src_ssl\";s:48:\"https://wordpress.org/images/browsers/chrome.png\";s:15:\"current_version\";s:2:\"18\";s:7:\"upgrade\";b:0;s:8:\"insecure\";b:0;}", "yes");
INSERT INTO wp_lofaro_labs_scroll_options VALUES("10182", "_site_transient_timeout_browser_bf4f08c4a8e1166b00d057455a15d2c3", "1485456380", "yes");
INSERT INTO wp_lofaro_labs_scroll_options VALUES("10183", "_site_transient_browser_bf4f08c4a8e1166b00d057455a15d2c3", "a:9:{s:8:\"platform\";s:9:\"Macintosh\";s:4:\"name\";s:6:\"Chrome\";s:7:\"version\";s:12:\"55.0.2883.95\";s:10:\"update_url\";s:28:\"http://www.google.com/chrome\";s:7:\"img_src\";s:49:\"http://s.wordpress.org/images/browsers/chrome.png\";s:11:\"img_src_ssl\";s:48:\"https://wordpress.org/images/browsers/chrome.png\";s:15:\"current_version\";s:2:\"18\";s:7:\"upgrade\";b:0;s:8:\"insecure\";b:0;}", "yes");
INSERT INTO wp_lofaro_labs_scroll_options VALUES("10707", "_site_transient_timeout_browser_ec4cf25286764ea36e907bd93ed023da", "1487167957", "yes");
INSERT INTO wp_lofaro_labs_scroll_options VALUES("10708", "_site_transient_browser_ec4cf25286764ea36e907bd93ed023da", "a:9:{s:8:\"platform\";s:9:\"Macintosh\";s:4:\"name\";s:6:\"Chrome\";s:7:\"version\";s:12:\"55.0.2883.95\";s:10:\"update_url\";s:28:\"http://www.google.com/chrome\";s:7:\"img_src\";s:49:\"http://s.wordpress.org/images/browsers/chrome.png\";s:11:\"img_src_ssl\";s:48:\"https://wordpress.org/images/browsers/chrome.png\";s:15:\"current_version\";s:2:\"18\";s:7:\"upgrade\";b:0;s:8:\"insecure\";b:0;}", "yes");
INSERT INTO wp_lofaro_labs_scroll_options VALUES("10905", "_site_transient_timeout_browser_303937ef543d5effcbb0e9341df418cf", "1487817822", "yes");
INSERT INTO wp_lofaro_labs_scroll_options VALUES("10906", "_site_transient_browser_303937ef543d5effcbb0e9341df418cf", "a:9:{s:8:\"platform\";s:9:\"Macintosh\";s:4:\"name\";s:6:\"Chrome\";s:7:\"version\";s:12:\"56.0.2924.87\";s:10:\"update_url\";s:28:\"http://www.google.com/chrome\";s:7:\"img_src\";s:49:\"http://s.wordpress.org/images/browsers/chrome.png\";s:11:\"img_src_ssl\";s:48:\"https://wordpress.org/images/browsers/chrome.png\";s:15:\"current_version\";s:2:\"18\";s:7:\"upgrade\";b:0;s:8:\"insecure\";b:0;}", "yes");
INSERT INTO wp_lofaro_labs_scroll_options VALUES("19175", "_site_transient_timeout_browser_f1c21279eb3f690f3b70a624cd19986e", "1516210557", "yes");
INSERT INTO wp_lofaro_labs_scroll_options VALUES("19176", "_site_transient_browser_f1c21279eb3f690f3b70a624cd19986e", "a:10:{s:4:\"name\";s:6:\"Chrome\";s:7:\"version\";s:12:\"63.0.3239.84\";s:8:\"platform\";s:9:\"Macintosh\";s:10:\"update_url\";s:29:\"https://www.google.com/chrome\";s:7:\"img_src\";s:43:\"http://s.w.org/images/browsers/chrome.png?1\";s:11:\"img_src_ssl\";s:44:\"https://s.w.org/images/browsers/chrome.png?1\";s:15:\"current_version\";s:2:\"18\";s:7:\"upgrade\";b:0;s:8:\"insecure\";b:0;s:6:\"mobile\";b:0;}", "yes");
INSERT INTO wp_lofaro_labs_scroll_options VALUES("19528", "_site_transient_timeout_browser_619cde154faa6febdc7a92814a62ece2", "1517071478", "yes");
INSERT INTO wp_lofaro_labs_scroll_options VALUES("19529", "_site_transient_browser_619cde154faa6febdc7a92814a62ece2", "a:10:{s:4:\"name\";s:6:\"Chrome\";s:7:\"version\";s:13:\"63.0.3239.132\";s:8:\"platform\";s:9:\"Macintosh\";s:10:\"update_url\";s:29:\"https://www.google.com/chrome\";s:7:\"img_src\";s:43:\"http://s.w.org/images/browsers/chrome.png?1\";s:11:\"img_src_ssl\";s:44:\"https://s.w.org/images/browsers/chrome.png?1\";s:15:\"current_version\";s:2:\"18\";s:7:\"upgrade\";b:0;s:8:\"insecure\";b:0;s:6:\"mobile\";b:0;}", "yes");
INSERT INTO wp_lofaro_labs_scroll_options VALUES("20196", "_site_transient_timeout_browser_acd235bf877ee1a167fa84073eedc64e", "1519155767", "yes");
INSERT INTO wp_lofaro_labs_scroll_options VALUES("20197", "_site_transient_browser_acd235bf877ee1a167fa84073eedc64e", "a:10:{s:4:\"name\";s:6:\"Chrome\";s:7:\"version\";s:13:\"63.0.3239.132\";s:8:\"platform\";s:9:\"Macintosh\";s:10:\"update_url\";s:29:\"https://www.google.com/chrome\";s:7:\"img_src\";s:43:\"http://s.w.org/images/browsers/chrome.png?1\";s:11:\"img_src_ssl\";s:44:\"https://s.w.org/images/browsers/chrome.png?1\";s:15:\"current_version\";s:2:\"18\";s:7:\"upgrade\";b:0;s:8:\"insecure\";b:0;s:6:\"mobile\";b:0;}", "yes");
INSERT INTO wp_lofaro_labs_scroll_options VALUES("20447", "_site_transient_timeout_browser_3299c25b46a2ce0cd309a371cc9d3e47", "1520002060", "yes");
INSERT INTO wp_lofaro_labs_scroll_options VALUES("20448", "_site_transient_browser_3299c25b46a2ce0cd309a371cc9d3e47", "a:10:{s:4:\"name\";s:6:\"Chrome\";s:7:\"version\";s:13:\"64.0.3282.167\";s:8:\"platform\";s:9:\"Macintosh\";s:10:\"update_url\";s:29:\"https://www.google.com/chrome\";s:7:\"img_src\";s:43:\"http://s.w.org/images/browsers/chrome.png?1\";s:11:\"img_src_ssl\";s:44:\"https://s.w.org/images/browsers/chrome.png?1\";s:15:\"current_version\";s:2:\"18\";s:7:\"upgrade\";b:0;s:8:\"insecure\";b:0;s:6:\"mobile\";b:0;}", "yes");
INSERT INTO wp_lofaro_labs_scroll_options VALUES("20612", "_site_transient_timeout_browser_6df47feeeda72948e2378527bc065d7f", "1520528425", "yes");
INSERT INTO wp_lofaro_labs_scroll_options VALUES("20613", "_site_transient_browser_6df47feeeda72948e2378527bc065d7f", "a:10:{s:4:\"name\";s:7:\"Firefox\";s:7:\"version\";s:4:\"57.0\";s:8:\"platform\";s:5:\"Linux\";s:10:\"update_url\";s:24:\"https://www.firefox.com/\";s:7:\"img_src\";s:44:\"http://s.w.org/images/browsers/firefox.png?1\";s:11:\"img_src_ssl\";s:45:\"https://s.w.org/images/browsers/firefox.png?1\";s:15:\"current_version\";s:2:\"56\";s:7:\"upgrade\";b:0;s:8:\"insecure\";b:0;s:6:\"mobile\";b:0;}", "yes");
INSERT INTO wp_lofaro_labs_scroll_options VALUES("21879", "_site_transient_timeout_browser_e71c82be845bd36cecbb5839941ba64e", "1525108631", "yes");
INSERT INTO wp_lofaro_labs_scroll_options VALUES("21880", "_site_transient_browser_e71c82be845bd36cecbb5839941ba64e", "a:10:{s:4:\"name\";s:6:\"Chrome\";s:7:\"version\";s:13:\"65.0.3325.181\";s:8:\"platform\";s:9:\"Macintosh\";s:10:\"update_url\";s:29:\"https://www.google.com/chrome\";s:7:\"img_src\";s:43:\"http://s.w.org/images/browsers/chrome.png?1\";s:11:\"img_src_ssl\";s:44:\"https://s.w.org/images/browsers/chrome.png?1\";s:15:\"current_version\";s:2:\"18\";s:7:\"upgrade\";b:0;s:8:\"insecure\";b:0;s:6:\"mobile\";b:0;}", "yes");
INSERT INTO wp_lofaro_labs_scroll_options VALUES("24294", "_site_transient_timeout_browser_f1d0a817a5cad8e5d395ed0b05b9b8ea", "1534820043", "yes");
INSERT INTO wp_lofaro_labs_scroll_options VALUES("24295", "_site_transient_browser_f1d0a817a5cad8e5d395ed0b05b9b8ea", "a:10:{s:4:\"name\";s:6:\"Chrome\";s:7:\"version\";s:12:\"68.0.3440.84\";s:8:\"platform\";s:9:\"Macintosh\";s:10:\"update_url\";s:29:\"https://www.google.com/chrome\";s:7:\"img_src\";s:43:\"http://s.w.org/images/browsers/chrome.png?1\";s:11:\"img_src_ssl\";s:44:\"https://s.w.org/images/browsers/chrome.png?1\";s:15:\"current_version\";s:2:\"18\";s:7:\"upgrade\";b:0;s:8:\"insecure\";b:0;s:6:\"mobile\";b:0;}", "yes");
INSERT INTO wp_lofaro_labs_scroll_options VALUES("24978", "_site_transient_timeout_browser_0298b062e017eac1d86ec2a29e8864e4", "1537231822", "yes");
INSERT INTO wp_lofaro_labs_scroll_options VALUES("24979", "_site_transient_browser_0298b062e017eac1d86ec2a29e8864e4", "a:10:{s:4:\"name\";s:6:\"Chrome\";s:7:\"version\";s:13:\"68.0.3440.106\";s:8:\"platform\";s:9:\"Macintosh\";s:10:\"update_url\";s:29:\"https://www.google.com/chrome\";s:7:\"img_src\";s:43:\"http://s.w.org/images/browsers/chrome.png?1\";s:11:\"img_src_ssl\";s:44:\"https://s.w.org/images/browsers/chrome.png?1\";s:15:\"current_version\";s:2:\"18\";s:7:\"upgrade\";b:0;s:8:\"insecure\";b:0;s:6:\"mobile\";b:0;}", "yes");
INSERT INTO wp_lofaro_labs_scroll_options VALUES("25046", "_site_transient_timeout_browser_45dbb6da330b511799c6994ed45946fa", "1537410204", "yes");
INSERT INTO wp_lofaro_labs_scroll_options VALUES("25047", "_site_transient_browser_45dbb6da330b511799c6994ed45946fa", "a:10:{s:4:\"name\";s:6:\"Chrome\";s:7:\"version\";s:13:\"68.0.3440.106\";s:8:\"platform\";s:9:\"Macintosh\";s:10:\"update_url\";s:29:\"https://www.google.com/chrome\";s:7:\"img_src\";s:43:\"http://s.w.org/images/browsers/chrome.png?1\";s:11:\"img_src_ssl\";s:44:\"https://s.w.org/images/browsers/chrome.png?1\";s:15:\"current_version\";s:2:\"18\";s:7:\"upgrade\";b:0;s:8:\"insecure\";b:0;s:6:\"mobile\";b:0;}", "yes");
INSERT INTO wp_lofaro_labs_scroll_options VALUES("25344", "_site_transient_timeout_browser_ceb243bb650c558864d747c046f105df", "1538366360", "yes");
INSERT INTO wp_lofaro_labs_scroll_options VALUES("25345", "_site_transient_browser_ceb243bb650c558864d747c046f105df", "a:10:{s:4:\"name\";s:6:\"Chrome\";s:7:\"version\";s:13:\"69.0.3497.100\";s:8:\"platform\";s:9:\"Macintosh\";s:10:\"update_url\";s:29:\"https://www.google.com/chrome\";s:7:\"img_src\";s:43:\"http://s.w.org/images/browsers/chrome.png?1\";s:11:\"img_src_ssl\";s:44:\"https://s.w.org/images/browsers/chrome.png?1\";s:15:\"current_version\";s:2:\"18\";s:7:\"upgrade\";b:0;s:8:\"insecure\";b:0;s:6:\"mobile\";b:0;}", "yes");
INSERT INTO wp_lofaro_labs_scroll_options VALUES("26264", "_site_transient_timeout_browser_24aef8e33a987431325813361dbd04b3", "1541614062", "yes");
INSERT INTO wp_lofaro_labs_scroll_options VALUES("26265", "_site_transient_browser_24aef8e33a987431325813361dbd04b3", "a:10:{s:4:\"name\";s:6:\"Chrome\";s:7:\"version\";s:13:\"69.0.3497.100\";s:8:\"platform\";s:9:\"Macintosh\";s:10:\"update_url\";s:29:\"https://www.google.com/chrome\";s:7:\"img_src\";s:43:\"http://s.w.org/images/browsers/chrome.png?1\";s:11:\"img_src_ssl\";s:44:\"https://s.w.org/images/browsers/chrome.png?1\";s:15:\"current_version\";s:2:\"18\";s:7:\"upgrade\";b:0;s:8:\"insecure\";b:0;s:6:\"mobile\";b:0;}", "yes");
INSERT INTO wp_lofaro_labs_scroll_options VALUES("26278", "_site_transient_timeout_browser_c966badb280761b723177d831175acee", "1541615321", "yes");
INSERT INTO wp_lofaro_labs_scroll_options VALUES("26279", "_site_transient_browser_c966badb280761b723177d831175acee", "a:10:{s:4:\"name\";s:6:\"Chrome\";s:7:\"version\";s:12:\"70.0.3538.77\";s:8:\"platform\";s:9:\"Macintosh\";s:10:\"update_url\";s:29:\"https://www.google.com/chrome\";s:7:\"img_src\";s:43:\"http://s.w.org/images/browsers/chrome.png?1\";s:11:\"img_src_ssl\";s:44:\"https://s.w.org/images/browsers/chrome.png?1\";s:15:\"current_version\";s:2:\"18\";s:7:\"upgrade\";b:0;s:8:\"insecure\";b:0;s:6:\"mobile\";b:0;}", "yes");
INSERT INTO wp_lofaro_labs_scroll_options VALUES("28991", "_site_transient_timeout_browser_5509789ec57d17a366c6ff0f12582530", "1551489837", "yes");
INSERT INTO wp_lofaro_labs_scroll_options VALUES("28992", "_site_transient_browser_5509789ec57d17a366c6ff0f12582530", "a:10:{s:4:\"name\";s:6:\"Chrome\";s:7:\"version\";s:13:\"72.0.3626.119\";s:8:\"platform\";s:9:\"Macintosh\";s:10:\"update_url\";s:29:\"https://www.google.com/chrome\";s:7:\"img_src\";s:43:\"http://s.w.org/images/browsers/chrome.png?1\";s:11:\"img_src_ssl\";s:44:\"https://s.w.org/images/browsers/chrome.png?1\";s:15:\"current_version\";s:2:\"18\";s:7:\"upgrade\";b:0;s:8:\"insecure\";b:0;s:6:\"mobile\";b:0;}", "yes");
INSERT INTO wp_lofaro_labs_scroll_options VALUES("29993", "_site_transient_timeout_browser_c976eda41861f38dbf19d0df55075ea0", "1555032599", "yes");
INSERT INTO wp_lofaro_labs_scroll_options VALUES("29994", "_site_transient_browser_c976eda41861f38dbf19d0df55075ea0", "a:10:{s:4:\"name\";s:7:\"Firefox\";s:7:\"version\";s:4:\"66.0\";s:8:\"platform\";s:9:\"Macintosh\";s:10:\"update_url\";s:24:\"https://www.firefox.com/\";s:7:\"img_src\";s:44:\"http://s.w.org/images/browsers/firefox.png?1\";s:11:\"img_src_ssl\";s:45:\"https://s.w.org/images/browsers/firefox.png?1\";s:15:\"current_version\";s:2:\"56\";s:7:\"upgrade\";b:0;s:8:\"insecure\";b:0;s:6:\"mobile\";b:0;}", "yes");
INSERT INTO wp_lofaro_labs_scroll_options VALUES("32260", "_site_transient_timeout_browser_445d353404398214bba64c7a8f629e36", "1563030349", "yes");
INSERT INTO wp_lofaro_labs_scroll_options VALUES("32261", "_site_transient_browser_445d353404398214bba64c7a8f629e36", "a:10:{s:4:\"name\";s:7:\"Firefox\";s:7:\"version\";s:4:\"67.0\";s:8:\"platform\";s:9:\"Macintosh\";s:10:\"update_url\";s:24:\"https://www.firefox.com/\";s:7:\"img_src\";s:44:\"http://s.w.org/images/browsers/firefox.png?1\";s:11:\"img_src_ssl\";s:45:\"https://s.w.org/images/browsers/firefox.png?1\";s:15:\"current_version\";s:2:\"56\";s:7:\"upgrade\";b:0;s:8:\"insecure\";b:0;s:6:\"mobile\";b:0;}", "yes");
INSERT INTO wp_lofaro_labs_scroll_options VALUES("33537", "_site_transient_timeout_browser_b25e5f1ad38d1e3ed2ae16000feb42e3", "1568414711", "yes");
INSERT INTO wp_lofaro_labs_scroll_options VALUES("33538", "_site_transient_browser_b25e5f1ad38d1e3ed2ae16000feb42e3", "a:10:{s:4:\"name\";s:7:\"Firefox\";s:7:\"version\";s:4:\"67.0\";s:8:\"platform\";s:5:\"Linux\";s:10:\"update_url\";s:24:\"https://www.firefox.com/\";s:7:\"img_src\";s:44:\"http://s.w.org/images/browsers/firefox.png?1\";s:11:\"img_src_ssl\";s:45:\"https://s.w.org/images/browsers/firefox.png?1\";s:15:\"current_version\";s:2:\"56\";s:7:\"upgrade\";b:0;s:8:\"insecure\";b:0;s:6:\"mobile\";b:0;}", "yes");
INSERT INTO wp_lofaro_labs_scroll_options VALUES("33562", "category_children", "a:0:{}", "yes");
INSERT INTO wp_lofaro_labs_scroll_options VALUES("33563", "rewrite_rules", "a:78:{s:11:\"^wp-json/?$\";s:22:\"index.php?rest_route=/\";s:14:\"^wp-json/(.*)?\";s:33:\"index.php?rest_route=/$matches[1]\";s:57:\"index.php/category/(.+?)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:52:\"index.php?category_name=$matches[1]&feed=$matches[2]\";s:52:\"index.php/category/(.+?)/(feed|rdf|rss|rss2|atom)/?$\";s:52:\"index.php?category_name=$matches[1]&feed=$matches[2]\";s:45:\"index.php/category/(.+?)/page/?([0-9]{1,})/?$\";s:53:\"index.php?category_name=$matches[1]&paged=$matches[2]\";s:27:\"index.php/category/(.+?)/?$\";s:35:\"index.php?category_name=$matches[1]\";s:54:\"index.php/tag/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:42:\"index.php?tag=$matches[1]&feed=$matches[2]\";s:49:\"index.php/tag/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:42:\"index.php?tag=$matches[1]&feed=$matches[2]\";s:42:\"index.php/tag/([^/]+)/page/?([0-9]{1,})/?$\";s:43:\"index.php?tag=$matches[1]&paged=$matches[2]\";s:24:\"index.php/tag/([^/]+)/?$\";s:25:\"index.php?tag=$matches[1]\";s:55:\"index.php/type/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?post_format=$matches[1]&feed=$matches[2]\";s:50:\"index.php/type/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?post_format=$matches[1]&feed=$matches[2]\";s:43:\"index.php/type/([^/]+)/page/?([0-9]{1,})/?$\";s:51:\"index.php?post_format=$matches[1]&paged=$matches[2]\";s:25:\"index.php/type/([^/]+)/?$\";s:33:\"index.php?post_format=$matches[1]\";s:12:\"robots\\.txt$\";s:18:\"index.php?robots=1\";s:48:\".*wp-(atom|rdf|rss|rss2|feed|commentsrss2)\\.php$\";s:18:\"index.php?feed=old\";s:20:\".*wp-app\\.php(/.*)?$\";s:19:\"index.php?error=403\";s:18:\".*wp-register.php$\";s:23:\"index.php?register=true\";s:42:\"index.php/feed/(feed|rdf|rss|rss2|atom)/?$\";s:27:\"index.php?&feed=$matches[1]\";s:37:\"index.php/(feed|rdf|rss|rss2|atom)/?$\";s:27:\"index.php?&feed=$matches[1]\";s:30:\"index.php/page/?([0-9]{1,})/?$\";s:28:\"index.php?&paged=$matches[1]\";s:51:\"index.php/comments/feed/(feed|rdf|rss|rss2|atom)/?$\";s:42:\"index.php?&feed=$matches[1]&withcomments=1\";s:46:\"index.php/comments/(feed|rdf|rss|rss2|atom)/?$\";s:42:\"index.php?&feed=$matches[1]&withcomments=1\";s:54:\"index.php/search/(.+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:40:\"index.php?s=$matches[1]&feed=$matches[2]\";s:49:\"index.php/search/(.+)/(feed|rdf|rss|rss2|atom)/?$\";s:40:\"index.php?s=$matches[1]&feed=$matches[2]\";s:42:\"index.php/search/(.+)/page/?([0-9]{1,})/?$\";s:41:\"index.php?s=$matches[1]&paged=$matches[2]\";s:24:\"index.php/search/(.+)/?$\";s:23:\"index.php?s=$matches[1]\";s:57:\"index.php/author/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?author_name=$matches[1]&feed=$matches[2]\";s:52:\"index.php/author/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?author_name=$matches[1]&feed=$matches[2]\";s:45:\"index.php/author/([^/]+)/page/?([0-9]{1,})/?$\";s:51:\"index.php?author_name=$matches[1]&paged=$matches[2]\";s:27:\"index.php/author/([^/]+)/?$\";s:33:\"index.php?author_name=$matches[1]\";s:79:\"index.php/([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/feed/(feed|rdf|rss|rss2|atom)/?$\";s:80:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&feed=$matches[4]\";s:74:\"index.php/([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/(feed|rdf|rss|rss2|atom)/?$\";s:80:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&feed=$matches[4]\";s:67:\"index.php/([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/page/?([0-9]{1,})/?$\";s:81:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&paged=$matches[4]\";s:49:\"index.php/([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/?$\";s:63:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]\";s:66:\"index.php/([0-9]{4})/([0-9]{1,2})/feed/(feed|rdf|rss|rss2|atom)/?$\";s:64:\"index.php?year=$matches[1]&monthnum=$matches[2]&feed=$matches[3]\";s:61:\"index.php/([0-9]{4})/([0-9]{1,2})/(feed|rdf|rss|rss2|atom)/?$\";s:64:\"index.php?year=$matches[1]&monthnum=$matches[2]&feed=$matches[3]\";s:54:\"index.php/([0-9]{4})/([0-9]{1,2})/page/?([0-9]{1,})/?$\";s:65:\"index.php?year=$matches[1]&monthnum=$matches[2]&paged=$matches[3]\";s:36:\"index.php/([0-9]{4})/([0-9]{1,2})/?$\";s:47:\"index.php?year=$matches[1]&monthnum=$matches[2]\";s:53:\"index.php/([0-9]{4})/feed/(feed|rdf|rss|rss2|atom)/?$\";s:43:\"index.php?year=$matches[1]&feed=$matches[2]\";s:48:\"index.php/([0-9]{4})/(feed|rdf|rss|rss2|atom)/?$\";s:43:\"index.php?year=$matches[1]&feed=$matches[2]\";s:41:\"index.php/([0-9]{4})/page/?([0-9]{1,})/?$\";s:44:\"index.php?year=$matches[1]&paged=$matches[2]\";s:23:\"index.php/([0-9]{4})/?$\";s:26:\"index.php?year=$matches[1]\";s:68:\"index.php/[0-9]{4}/[0-9]{1,2}/[0-9]{1,2}/[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:78:\"index.php/[0-9]{4}/[0-9]{1,2}/[0-9]{1,2}/[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:98:\"index.php/[0-9]{4}/[0-9]{1,2}/[0-9]{1,2}/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:93:\"index.php/[0-9]{4}/[0-9]{1,2}/[0-9]{1,2}/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:93:\"index.php/[0-9]{4}/[0-9]{1,2}/[0-9]{1,2}/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:74:\"index.php/[0-9]{4}/[0-9]{1,2}/[0-9]{1,2}/[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:63:\"index.php/([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/([^/]+)/embed/?$\";s:91:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&name=$matches[4]&embed=true\";s:67:\"index.php/([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/([^/]+)/trackback/?$\";s:85:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&name=$matches[4]&tb=1\";s:87:\"index.php/([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:97:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&name=$matches[4]&feed=$matches[5]\";s:82:\"index.php/([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:97:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&name=$matches[4]&feed=$matches[5]\";s:75:\"index.php/([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/([^/]+)/page/?([0-9]{1,})/?$\";s:98:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&name=$matches[4]&paged=$matches[5]\";s:82:\"index.php/([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/([^/]+)/comment-page-([0-9]{1,})/?$\";s:98:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&name=$matches[4]&cpage=$matches[5]\";s:71:\"index.php/([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/([^/]+)(?:/([0-9]+))?/?$\";s:97:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&name=$matches[4]&page=$matches[5]\";s:57:\"index.php/[0-9]{4}/[0-9]{1,2}/[0-9]{1,2}/[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:67:\"index.php/[0-9]{4}/[0-9]{1,2}/[0-9]{1,2}/[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:87:\"index.php/[0-9]{4}/[0-9]{1,2}/[0-9]{1,2}/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:82:\"index.php/[0-9]{4}/[0-9]{1,2}/[0-9]{1,2}/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:82:\"index.php/[0-9]{4}/[0-9]{1,2}/[0-9]{1,2}/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:63:\"index.php/[0-9]{4}/[0-9]{1,2}/[0-9]{1,2}/[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:74:\"index.php/([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/comment-page-([0-9]{1,})/?$\";s:81:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&cpage=$matches[4]\";s:61:\"index.php/([0-9]{4})/([0-9]{1,2})/comment-page-([0-9]{1,})/?$\";s:65:\"index.php?year=$matches[1]&monthnum=$matches[2]&cpage=$matches[3]\";s:48:\"index.php/([0-9]{4})/comment-page-([0-9]{1,})/?$\";s:44:\"index.php?year=$matches[1]&cpage=$matches[2]\";s:37:\"index.php/.?.+?/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:47:\"index.php/.?.+?/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:67:\"index.php/.?.+?/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:62:\"index.php/.?.+?/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:62:\"index.php/.?.+?/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:43:\"index.php/.?.+?/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:26:\"index.php/(.?.+?)/embed/?$\";s:41:\"index.php?pagename=$matches[1]&embed=true\";s:30:\"index.php/(.?.+?)/trackback/?$\";s:35:\"index.php?pagename=$matches[1]&tb=1\";s:50:\"index.php/(.?.+?)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:47:\"index.php?pagename=$matches[1]&feed=$matches[2]\";s:45:\"index.php/(.?.+?)/(feed|rdf|rss|rss2|atom)/?$\";s:47:\"index.php?pagename=$matches[1]&feed=$matches[2]\";s:38:\"index.php/(.?.+?)/page/?([0-9]{1,})/?$\";s:48:\"index.php?pagename=$matches[1]&paged=$matches[2]\";s:45:\"index.php/(.?.+?)/comment-page-([0-9]{1,})/?$\";s:48:\"index.php?pagename=$matches[1]&cpage=$matches[2]\";s:34:\"index.php/(.?.+?)(?:/([0-9]+))?/?$\";s:47:\"index.php?pagename=$matches[1]&page=$matches[2]\";}", "yes");
INSERT INTO wp_lofaro_labs_scroll_options VALUES("33675", "_site_transient_timeout_browser_c3a96145f692e24e60f00cb7dd0d97a4", "1568731440", "yes");
INSERT INTO wp_lofaro_labs_scroll_options VALUES("33676", "_site_transient_browser_c3a96145f692e24e60f00cb7dd0d97a4", "a:10:{s:4:\"name\";s:6:\"Chrome\";s:7:\"version\";s:13:\"76.0.3809.100\";s:8:\"platform\";s:9:\"Macintosh\";s:10:\"update_url\";s:29:\"https://www.google.com/chrome\";s:7:\"img_src\";s:43:\"http://s.w.org/images/browsers/chrome.png?1\";s:11:\"img_src_ssl\";s:44:\"https://s.w.org/images/browsers/chrome.png?1\";s:15:\"current_version\";s:2:\"18\";s:7:\"upgrade\";b:0;s:8:\"insecure\";b:0;s:6:\"mobile\";b:0;}", "yes");
INSERT INTO wp_lofaro_labs_scroll_options VALUES("33799", "_site_transient_timeout_browser_aece8f177339f2b6e18c28d02595d9b4", "1569113675", "yes");
INSERT INTO wp_lofaro_labs_scroll_options VALUES("33800", "_site_transient_browser_aece8f177339f2b6e18c28d02595d9b4", "a:10:{s:4:\"name\";s:7:\"Firefox\";s:7:\"version\";s:4:\"69.0\";s:8:\"platform\";s:9:\"Macintosh\";s:10:\"update_url\";s:24:\"https://www.firefox.com/\";s:7:\"img_src\";s:44:\"http://s.w.org/images/browsers/firefox.png?1\";s:11:\"img_src_ssl\";s:45:\"https://s.w.org/images/browsers/firefox.png?1\";s:15:\"current_version\";s:2:\"56\";s:7:\"upgrade\";b:0;s:8:\"insecure\";b:0;s:6:\"mobile\";b:0;}", "yes");
INSERT INTO wp_lofaro_labs_scroll_options VALUES("36493", "_site_transient_timeout_browser_c4f8f7e5ff72fa19bc56c9c28cb6f72b", "1578276887", "yes");
INSERT INTO wp_lofaro_labs_scroll_options VALUES("36494", "_site_transient_browser_c4f8f7e5ff72fa19bc56c9c28cb6f72b", "a:10:{s:4:\"name\";s:7:\"Firefox\";s:7:\"version\";s:4:\"71.0\";s:8:\"platform\";s:9:\"Macintosh\";s:10:\"update_url\";s:24:\"https://www.firefox.com/\";s:7:\"img_src\";s:44:\"http://s.w.org/images/browsers/firefox.png?1\";s:11:\"img_src_ssl\";s:45:\"https://s.w.org/images/browsers/firefox.png?1\";s:15:\"current_version\";s:2:\"56\";s:7:\"upgrade\";b:0;s:8:\"insecure\";b:0;s:6:\"mobile\";b:0;}", "yes");
INSERT INTO wp_lofaro_labs_scroll_options VALUES("40782", "_site_transient_timeout_browser_dc533af2dc34d59fa5f9e5e34b0fe56f", "1593726776", "yes");
INSERT INTO wp_lofaro_labs_scroll_options VALUES("40783", "_site_transient_browser_dc533af2dc34d59fa5f9e5e34b0fe56f", "a:10:{s:4:\"name\";s:7:\"Firefox\";s:7:\"version\";s:4:\"77.0\";s:8:\"platform\";s:5:\"Linux\";s:10:\"update_url\";s:32:\"https://www.mozilla.org/firefox/\";s:7:\"img_src\";s:44:\"http://s.w.org/images/browsers/firefox.png?1\";s:11:\"img_src_ssl\";s:45:\"https://s.w.org/images/browsers/firefox.png?1\";s:15:\"current_version\";s:2:\"56\";s:7:\"upgrade\";b:0;s:8:\"insecure\";b:0;s:6:\"mobile\";b:0;}", "yes");
INSERT INTO wp_lofaro_labs_scroll_options VALUES("41316", "_site_transient_timeout_browser_143a0e030baf1ddd52b60df6ce5fc3ca", "1595894713", "yes");
INSERT INTO wp_lofaro_labs_scroll_options VALUES("41317", "_site_transient_browser_143a0e030baf1ddd52b60df6ce5fc3ca", "a:10:{s:4:\"name\";s:7:\"Firefox\";s:7:\"version\";s:4:\"78.0\";s:8:\"platform\";s:9:\"Macintosh\";s:10:\"update_url\";s:32:\"https://www.mozilla.org/firefox/\";s:7:\"img_src\";s:44:\"http://s.w.org/images/browsers/firefox.png?1\";s:11:\"img_src_ssl\";s:45:\"https://s.w.org/images/browsers/firefox.png?1\";s:15:\"current_version\";s:2:\"56\";s:7:\"upgrade\";b:0;s:8:\"insecure\";b:0;s:6:\"mobile\";b:0;}", "yes");
INSERT INTO wp_lofaro_labs_scroll_options VALUES("45751", "_site_transient_timeout_browser_604c9df48ec37f50ad354c017b0e25f2", "1614563319", "yes");
INSERT INTO wp_lofaro_labs_scroll_options VALUES("45752", "_site_transient_browser_604c9df48ec37f50ad354c017b0e25f2", "a:10:{s:4:\"name\";s:7:\"Firefox\";s:7:\"version\";s:4:\"85.0\";s:8:\"platform\";s:5:\"Linux\";s:10:\"update_url\";s:32:\"https://www.mozilla.org/firefox/\";s:7:\"img_src\";s:44:\"http://s.w.org/images/browsers/firefox.png?1\";s:11:\"img_src_ssl\";s:45:\"https://s.w.org/images/browsers/firefox.png?1\";s:15:\"current_version\";s:2:\"56\";s:7:\"upgrade\";b:0;s:8:\"insecure\";b:0;s:6:\"mobile\";b:0;}", "yes");
INSERT INTO wp_lofaro_labs_scroll_options VALUES("46070", "_site_transient_update_core", "O:8:\"stdClass\":4:{s:7:\"updates\";a:20:{i:0;O:8:\"stdClass\":10:{s:8:\"response\";s:7:\"upgrade\";s:8:\"download\";s:57:\"https://downloads.wordpress.org/release/wordpress-6.0.zip\";s:6:\"locale\";s:5:\"en_US\";s:8:\"packages\";O:8:\"stdClass\":5:{s:4:\"full\";s:57:\"https://downloads.wordpress.org/release/wordpress-6.0.zip\";s:10:\"no_content\";s:68:\"https://downloads.wordpress.org/release/wordpress-6.0-no-content.zip\";s:11:\"new_bundled\";s:69:\"https://downloads.wordpress.org/release/wordpress-6.0-new-bundled.zip\";s:7:\"partial\";b:0;s:8:\"rollback\";b:0;}s:7:\"current\";s:3:\"6.0\";s:7:\"version\";s:3:\"6.0\";s:11:\"php_version\";s:6:\"5.6.20\";s:13:\"mysql_version\";s:3:\"5.0\";s:11:\"new_bundled\";s:3:\"5.9\";s:15:\"partial_version\";s:0:\"\";}i:1;O:8:\"stdClass\":10:{s:8:\"response\";s:7:\"upgrade\";s:8:\"download\";s:60:\"https://downloads.wordpress.org/release/wordpress-5.1.13.zip\";s:6:\"locale\";s:5:\"en_US\";s:8:\"packages\";O:8:\"stdClass\":5:{s:4:\"full\";s:60:\"https://downloads.wordpress.org/release/wordpress-5.1.13.zip\";s:10:\"no_content\";s:71:\"https://downloads.wordpress.org/release/wordpress-5.1.13-no-content.zip\";s:11:\"new_bundled\";s:72:\"https://downloads.wordpress.org/release/wordpress-5.1.13-new-bundled.zip\";s:7:\"partial\";b:0;s:8:\"rollback\";b:0;}s:7:\"current\";s:6:\"5.1.13\";s:7:\"version\";s:6:\"5.1.13\";s:11:\"php_version\";s:5:\"5.2.4\";s:13:\"mysql_version\";s:3:\"5.0\";s:11:\"new_bundled\";s:3:\"5.9\";s:15:\"partial_version\";s:0:\"\";}i:2;O:8:\"stdClass\":11:{s:8:\"response\";s:10:\"autoupdate\";s:8:\"download\";s:57:\"https://downloads.wordpress.org/release/wordpress-6.0.zip\";s:6:\"locale\";s:5:\"en_US\";s:8:\"packages\";O:8:\"stdClass\":5:{s:4:\"full\";s:57:\"https://downloads.wordpress.org/release/wordpress-6.0.zip\";s:10:\"no_content\";s:68:\"https://downloads.wordpress.org/release/wordpress-6.0-no-content.zip\";s:11:\"new_bundled\";s:69:\"https://downloads.wordpress.org/release/wordpress-6.0-new-bundled.zip\";s:7:\"partial\";b:0;s:8:\"rollback\";b:0;}s:7:\"current\";s:3:\"6.0\";s:7:\"version\";s:3:\"6.0\";s:11:\"php_version\";s:6:\"5.6.20\";s:13:\"mysql_version\";s:3:\"5.0\";s:11:\"new_bundled\";s:3:\"5.9\";s:15:\"partial_version\";s:0:\"\";s:9:\"new_files\";s:1:\"1\";}i:3;O:8:\"stdClass\":11:{s:8:\"response\";s:10:\"autoupdate\";s:8:\"download\";s:59:\"https://downloads.wordpress.org/release/wordpress-5.9.3.zip\";s:6:\"locale\";s:5:\"en_US\";s:8:\"packages\";O:8:\"stdClass\":5:{s:4:\"full\";s:59:\"https://downloads.wordpress.org/release/wordpress-5.9.3.zip\";s:10:\"no_content\";s:70:\"https://downloads.wordpress.org/release/wordpress-5.9.3-no-content.zip\";s:11:\"new_bundled\";s:71:\"https://downloads.wordpress.org/release/wordpress-5.9.3-new-bundled.zip\";s:7:\"partial\";b:0;s:8:\"rollback\";b:0;}s:7:\"current\";s:5:\"5.9.3\";s:7:\"version\";s:5:\"5.9.3\";s:11:\"php_version\";s:6:\"5.6.20\";s:13:\"mysql_version\";s:3:\"5.0\";s:11:\"new_bundled\";s:3:\"5.9\";s:15:\"partial_version\";s:0:\"\";s:9:\"new_files\";s:1:\"1\";}i:4;O:8:\"stdClass\":11:{s:8:\"response\";s:10:\"autoupdate\";s:8:\"download\";s:59:\"https://downloads.wordpress.org/release/wordpress-5.9.2.zip\";s:6:\"locale\";s:5:\"en_US\";s:8:\"packages\";O:8:\"stdClass\":5:{s:4:\"full\";s:59:\"https://downloads.wordpress.org/release/wordpress-5.9.2.zip\";s:10:\"no_content\";s:70:\"https://downloads.wordpress.org/release/wordpress-5.9.2-no-content.zip\";s:11:\"new_bundled\";s:71:\"https://downloads.wordpress.org/release/wordpress-5.9.2-new-bundled.zip\";s:7:\"partial\";b:0;s:8:\"rollback\";b:0;}s:7:\"current\";s:5:\"5.9.2\";s:7:\"version\";s:5:\"5.9.2\";s:11:\"php_version\";s:6:\"5.6.20\";s:13:\"mysql_version\";s:3:\"5.0\";s:11:\"new_bundled\";s:3:\"5.9\";s:15:\"partial_version\";s:0:\"\";s:9:\"new_files\";s:1:\"1\";}i:5;O:8:\"stdClass\":11:{s:8:\"response\";s:10:\"autoupdate\";s:8:\"download\";s:59:\"https://downloads.wordpress.org/release/wordpress-5.8.4.zip\";s:6:\"locale\";s:5:\"en_US\";s:8:\"packages\";O:8:\"stdClass\":5:{s:4:\"full\";s:59:\"https://downloads.wordpress.org/release/wordpress-5.8.4.zip\";s:10:\"no_content\";s:70:\"https://downloads.wordpress.org/release/wordpress-5.8.4-no-content.zip\";s:11:\"new_bundled\";s:71:\"https://downloads.wordpress.org/release/wordpress-5.8.4-new-bundled.zip\";s:7:\"partial\";b:0;s:8:\"rollback\";b:0;}s:7:\"current\";s:5:\"5.8.4\";s:7:\"version\";s:5:\"5.8.4\";s:11:\"php_version\";s:6:\"5.6.20\";s:13:\"mysql_version\";s:3:\"5.0\";s:11:\"new_bundled\";s:3:\"5.9\";s:15:\"partial_version\";s:0:\"\";s:9:\"new_files\";s:1:\"1\";}i:6;O:8:\"stdClass\":11:{s:8:\"response\";s:10:\"autoupdate\";s:8:\"download\";s:59:\"https://downloads.wordpress.org/release/wordpress-5.7.6.zip\";s:6:\"locale\";s:5:\"en_US\";s:8:\"packages\";O:8:\"stdClass\":5:{s:4:\"full\";s:59:\"https://downloads.wordpress.org/release/wordpress-5.7.6.zip\";s:10:\"no_content\";s:70:\"https://downloads.wordpress.org/release/wordpress-5.7.6-no-content.zip\";s:11:\"new_bundled\";s:71:\"https://downloads.wordpress.org/release/wordpress-5.7.6-new-bundled.zip\";s:7:\"partial\";b:0;s:8:\"rollback\";b:0;}s:7:\"current\";s:5:\"5.7.6\";s:7:\"version\";s:5:\"5.7.6\";s:11:\"php_version\";s:6:\"5.6.20\";s:13:\"mysql_version\";s:3:\"5.0\";s:11:\"new_bundled\";s:3:\"5.9\";s:15:\"partial_version\";s:0:\"\";s:9:\"new_files\";s:1:\"1\";}i:7;O:8:\"stdClass\":11:{s:8:\"response\";s:10:\"autoupdate\";s:8:\"download\";s:59:\"https://downloads.wordpress.org/release/wordpress-5.6.8.zip\";s:6:\"locale\";s:5:\"en_US\";s:8:\"packages\";O:8:\"stdClass\":5:{s:4:\"full\";s:59:\"https://downloads.wordpress.org/release/wordpress-5.6.8.zip\";s:10:\"no_content\";s:70:\"https://downloads.wordpress.org/release/wordpress-5.6.8-no-content.zip\";s:11:\"new_bundled\";s:71:\"https://downloads.wordpress.org/release/wordpress-5.6.8-new-bundled.zip\";s:7:\"partial\";b:0;s:8:\"rollback\";b:0;}s:7:\"current\";s:5:\"5.6.8\";s:7:\"version\";s:5:\"5.6.8\";s:11:\"php_version\";s:6:\"5.6.20\";s:13:\"mysql_version\";s:3:\"5.0\";s:11:\"new_bundled\";s:3:\"5.9\";s:15:\"partial_version\";s:0:\"\";s:9:\"new_files\";s:1:\"1\";}i:8;O:8:\"stdClass\":11:{s:8:\"response\";s:10:\"autoupdate\";s:8:\"download\";s:59:\"https://downloads.wordpress.org/release/wordpress-5.5.9.zip\";s:6:\"locale\";s:5:\"en_US\";s:8:\"packages\";O:8:\"stdClass\":5:{s:4:\"full\";s:59:\"https://downloads.wordpress.org/release/wordpress-5.5.9.zip\";s:10:\"no_content\";s:70:\"https://downloads.wordpress.org/release/wordpress-5.5.9-no-content.zip\";s:11:\"new_bundled\";s:71:\"https://downloads.wordpress.org/release/wordpress-5.5.9-new-bundled.zip\";s:7:\"partial\";b:0;s:8:\"rollback\";b:0;}s:7:\"current\";s:5:\"5.5.9\";s:7:\"version\";s:5:\"5.5.9\";s:11:\"php_version\";s:6:\"5.6.20\";s:13:\"mysql_version\";s:3:\"5.0\";s:11:\"new_bundled\";s:3:\"5.9\";s:15:\"partial_version\";s:0:\"\";s:9:\"new_files\";s:1:\"1\";}i:9;O:8:\"stdClass\":11:{s:8:\"response\";s:10:\"autoupdate\";s:8:\"download\";s:60:\"https://downloads.wordpress.org/release/wordpress-5.4.10.zip\";s:6:\"locale\";s:5:\"en_US\";s:8:\"packages\";O:8:\"stdClass\":5:{s:4:\"full\";s:60:\"https://downloads.wordpress.org/release/wordpress-5.4.10.zip\";s:10:\"no_content\";s:71:\"https://downloads.wordpress.org/release/wordpress-5.4.10-no-content.zip\";s:11:\"new_bundled\";s:72:\"https://downloads.wordpress.org/release/wordpress-5.4.10-new-bundled.zip\";s:7:\"partial\";b:0;s:8:\"rollback\";b:0;}s:7:\"current\";s:6:\"5.4.10\";s:7:\"version\";s:6:\"5.4.10\";s:11:\"php_version\";s:6:\"5.6.20\";s:13:\"mysql_version\";s:3:\"5.0\";s:11:\"new_bundled\";s:3:\"5.9\";s:15:\"partial_version\";s:0:\"\";s:9:\"new_files\";s:1:\"1\";}i:10;O:8:\"stdClass\":11:{s:8:\"response\";s:10:\"autoupdate\";s:8:\"download\";s:60:\"https://downloads.wordpress.org/release/wordpress-5.3.12.zip\";s:6:\"locale\";s:5:\"en_US\";s:8:\"packages\";O:8:\"stdClass\":5:{s:4:\"full\";s:60:\"https://downloads.wordpress.org/release/wordpress-5.3.12.zip\";s:10:\"no_content\";s:71:\"https://downloads.wordpress.org/release/wordpress-5.3.12-no-content.zip\";s:11:\"new_bundled\";s:72:\"https://downloads.wordpress.org/release/wordpress-5.3.12-new-bundled.zip\";s:7:\"partial\";b:0;s:8:\"rollback\";b:0;}s:7:\"current\";s:6:\"5.3.12\";s:7:\"version\";s:6:\"5.3.12\";s:11:\"php_version\";s:6:\"5.6.20\";s:13:\"mysql_version\";s:3:\"5.0\";s:11:\"new_bundled\";s:3:\"5.9\";s:15:\"partial_version\";s:0:\"\";s:9:\"new_files\";s:1:\"1\";}i:11;O:8:\"stdClass\":11:{s:8:\"response\";s:10:\"autoupdate\";s:8:\"download\";s:60:\"https://downloads.wordpress.org/release/wordpress-5.2.15.zip\";s:6:\"locale\";s:5:\"en_US\";s:8:\"packages\";O:8:\"stdClass\":5:{s:4:\"full\";s:60:\"https://downloads.wordpress.org/release/wordpress-5.2.15.zip\";s:10:\"no_content\";s:71:\"https://downloads.wordpress.org/release/wordpress-5.2.15-no-content.zip\";s:11:\"new_bundled\";s:72:\"https://downloads.wordpress.org/release/wordpress-5.2.15-new-bundled.zip\";s:7:\"partial\";b:0;s:8:\"rollback\";b:0;}s:7:\"current\";s:6:\"5.2.15\";s:7:\"version\";s:6:\"5.2.15\";s:11:\"php_version\";s:6:\"5.6.20\";s:13:\"mysql_version\";s:3:\"5.0\";s:11:\"new_bundled\";s:3:\"5.9\";s:15:\"partial_version\";s:0:\"\";s:9:\"new_files\";s:1:\"1\";}i:12;O:8:\"stdClass\":11:{s:8:\"response\";s:10:\"autoupdate\";s:8:\"download\";s:60:\"https://downloads.wordpress.org/release/wordpress-5.1.13.zip\";s:6:\"locale\";s:5:\"en_US\";s:8:\"packages\";O:8:\"stdClass\":5:{s:4:\"full\";s:60:\"https://downloads.wordpress.org/release/wordpress-5.1.13.zip\";s:10:\"no_content\";s:71:\"https://downloads.wordpress.org/release/wordpress-5.1.13-no-content.zip\";s:11:\"new_bundled\";s:72:\"https://downloads.wordpress.org/release/wordpress-5.1.13-new-bundled.zip\";s:7:\"partial\";b:0;s:8:\"rollback\";b:0;}s:7:\"current\";s:6:\"5.1.13\";s:7:\"version\";s:6:\"5.1.13\";s:11:\"php_version\";s:5:\"5.2.4\";s:13:\"mysql_version\";s:3:\"5.0\";s:11:\"new_bundled\";s:3:\"5.9\";s:15:\"partial_version\";s:0:\"\";s:9:\"new_files\";s:1:\"1\";}i:13;O:8:\"stdClass\":11:{s:8:\"response\";s:10:\"autoupdate\";s:8:\"download\";s:60:\"https://downloads.wordpress.org/release/wordpress-5.0.16.zip\";s:6:\"locale\";s:5:\"en_US\";s:8:\"packages\";O:8:\"stdClass\":5:{s:4:\"full\";s:60:\"https://downloads.wordpress.org/release/wordpress-5.0.16.zip\";s:10:\"no_content\";s:71:\"https://downloads.wordpress.org/release/wordpress-5.0.16-no-content.zip\";s:11:\"new_bundled\";s:72:\"https://downloads.wordpress.org/release/wordpress-5.0.16-new-bundled.zip\";s:7:\"partial\";b:0;s:8:\"rollback\";b:0;}s:7:\"current\";s:6:\"5.0.16\";s:7:\"version\";s:6:\"5.0.16\";s:11:\"php_version\";s:5:\"5.2.4\";s:13:\"mysql_version\";s:3:\"5.0\";s:11:\"new_bundled\";s:3:\"5.9\";s:15:\"partial_version\";s:0:\"\";s:9:\"new_files\";s:1:\"1\";}i:14;O:8:\"stdClass\":11:{s:8:\"response\";s:10:\"autoupdate\";s:8:\"download\";s:60:\"https://downloads.wordpress.org/release/wordpress-4.9.20.zip\";s:6:\"locale\";s:5:\"en_US\";s:8:\"packages\";O:8:\"stdClass\":5:{s:4:\"full\";s:60:\"https://downloads.wordpress.org/release/wordpress-4.9.20.zip\";s:10:\"no_content\";s:71:\"https://downloads.wordpress.org/release/wordpress-4.9.20-no-content.zip\";s:11:\"new_bundled\";s:72:\"https://downloads.wordpress.org/release/wordpress-4.9.20-new-bundled.zip\";s:7:\"partial\";b:0;s:8:\"rollback\";b:0;}s:7:\"current\";s:6:\"4.9.20\";s:7:\"version\";s:6:\"4.9.20\";s:11:\"php_version\";s:5:\"5.2.4\";s:13:\"mysql_version\";s:3:\"5.0\";s:11:\"new_bundled\";s:3:\"5.9\";s:15:\"partial_version\";s:0:\"\";s:9:\"new_files\";s:1:\"1\";}i:15;O:8:\"stdClass\":11:{s:8:\"response\";s:10:\"autoupdate\";s:8:\"download\";s:60:\"https://downloads.wordpress.org/release/wordpress-4.8.19.zip\";s:6:\"locale\";s:5:\"en_US\";s:8:\"packages\";O:8:\"stdClass\":5:{s:4:\"full\";s:60:\"https://downloads.wordpress.org/release/wordpress-4.8.19.zip\";s:10:\"no_content\";s:71:\"https://downloads.wordpress.org/release/wordpress-4.8.19-no-content.zip\";s:11:\"new_bundled\";s:72:\"https://downloads.wordpress.org/release/wordpress-4.8.19-new-bundled.zip\";s:7:\"partial\";b:0;s:8:\"rollback\";b:0;}s:7:\"current\";s:6:\"4.8.19\";s:7:\"version\";s:6:\"4.8.19\";s:11:\"php_version\";s:5:\"5.2.4\";s:13:\"mysql_version\";s:3:\"5.0\";s:11:\"new_bundled\";s:3:\"5.9\";s:15:\"partial_version\";s:0:\"\";s:9:\"new_files\";s:1:\"1\";}i:16;O:8:\"stdClass\":11:{s:8:\"response\";s:10:\"autoupdate\";s:8:\"download\";s:60:\"https://downloads.wordpress.org/release/wordpress-4.7.23.zip\";s:6:\"locale\";s:5:\"en_US\";s:8:\"packages\";O:8:\"stdClass\":5:{s:4:\"full\";s:60:\"https://downloads.wordpress.org/release/wordpress-4.7.23.zip\";s:10:\"no_content\";s:71:\"https://downloads.wordpress.org/release/wordpress-4.7.23-no-content.zip\";s:11:\"new_bundled\";s:72:\"https://downloads.wordpress.org/release/wordpress-4.7.23-new-bundled.zip\";s:7:\"partial\";b:0;s:8:\"rollback\";b:0;}s:7:\"current\";s:6:\"4.7.23\";s:7:\"version\";s:6:\"4.7.23\";s:11:\"php_version\";s:5:\"5.2.4\";s:13:\"mysql_version\";s:3:\"5.0\";s:11:\"new_bundled\";s:3:\"5.9\";s:15:\"partial_version\";s:0:\"\";s:9:\"new_files\";s:1:\"1\";}i:17;O:8:\"stdClass\":11:{s:8:\"response\";s:10:\"autoupdate\";s:8:\"download\";s:60:\"https://downloads.wordpress.org/release/wordpress-4.6.23.zip\";s:6:\"locale\";s:5:\"en_US\";s:8:\"packages\";O:8:\"stdClass\":5:{s:4:\"full\";s:60:\"https://downloads.wordpress.org/release/wordpress-4.6.23.zip\";s:10:\"no_content\";s:71:\"https://downloads.wordpress.org/release/wordpress-4.6.23-no-content.zip\";s:11:\"new_bundled\";s:72:\"https://downloads.wordpress.org/release/wordpress-4.6.23-new-bundled.zip\";s:7:\"partial\";b:0;s:8:\"rollback\";b:0;}s:7:\"current\";s:6:\"4.6.23\";s:7:\"version\";s:6:\"4.6.23\";s:11:\"php_version\";s:5:\"5.2.4\";s:13:\"mysql_version\";s:3:\"5.0\";s:11:\"new_bundled\";s:3:\"5.9\";s:15:\"partial_version\";s:0:\"\";s:9:\"new_files\";s:1:\"1\";}i:18;O:8:\"stdClass\":11:{s:8:\"response\";s:10:\"autoupdate\";s:8:\"download\";s:60:\"https://downloads.wordpress.org/release/wordpress-4.5.26.zip\";s:6:\"locale\";s:5:\"en_US\";s:8:\"packages\";O:8:\"stdClass\":5:{s:4:\"full\";s:60:\"https://downloads.wordpress.org/release/wordpress-4.5.26.zip\";s:10:\"no_content\";s:71:\"https://downloads.wordpress.org/release/wordpress-4.5.26-no-content.zip\";s:11:\"new_bundled\";s:72:\"https://downloads.wordpress.org/release/wordpress-4.5.26-new-bundled.zip\";s:7:\"partial\";b:0;s:8:\"rollback\";b:0;}s:7:\"current\";s:6:\"4.5.26\";s:7:\"version\";s:6:\"4.5.26\";s:11:\"php_version\";s:5:\"5.2.4\";s:13:\"mysql_version\";s:3:\"5.0\";s:11:\"new_bundled\";s:3:\"5.9\";s:15:\"partial_version\";s:0:\"\";s:9:\"new_files\";s:1:\"1\";}i:19;O:8:\"stdClass\":11:{s:8:\"response\";s:10:\"autoupdate\";s:8:\"download\";s:60:\"https://downloads.wordpress.org/release/wordpress-4.4.27.zip\";s:6:\"locale\";s:5:\"en_US\";s:8:\"packages\";O:8:\"stdClass\":5:{s:4:\"full\";s:60:\"https://downloads.wordpress.org/release/wordpress-4.4.27.zip\";s:10:\"no_content\";s:71:\"https://downloads.wordpress.org/release/wordpress-4.4.27-no-content.zip\";s:11:\"new_bundled\";s:72:\"https://downloads.wordpress.org/release/wordpress-4.4.27-new-bundled.zip\";s:7:\"partial\";s:70:\"https://downloads.wordpress.org/release/wordpress-4.4.27-partial-0.zip\";s:8:\"rollback\";s:71:\"https://downloads.wordpress.org/release/wordpress-4.4.27-rollback-0.zip\";}s:7:\"current\";s:6:\"4.4.27\";s:7:\"version\";s:6:\"4.4.27\";s:11:\"php_version\";s:5:\"5.2.4\";s:13:\"mysql_version\";s:3:\"5.0\";s:11:\"new_bundled\";s:3:\"5.9\";s:15:\"partial_version\";s:3:\"4.4\";s:9:\"new_files\";s:0:\"\";}}s:12:\"last_checked\";i:1656011909;s:15:\"version_checked\";s:3:\"4.4\";s:12:\"translations\";a:0:{}}", "yes");
INSERT INTO wp_lofaro_labs_scroll_options VALUES("48605", "_site_transient_timeout_browser_178746d87f638f81f7ffa5b727584a57", "1626215792", "yes");
INSERT INTO wp_lofaro_labs_scroll_options VALUES("48606", "_site_transient_browser_178746d87f638f81f7ffa5b727584a57", "a:10:{s:4:\"name\";s:7:\"Firefox\";s:7:\"version\";s:4:\"89.0\";s:8:\"platform\";s:5:\"Linux\";s:10:\"update_url\";s:32:\"https://www.mozilla.org/firefox/\";s:7:\"img_src\";s:44:\"http://s.w.org/images/browsers/firefox.png?1\";s:11:\"img_src_ssl\";s:45:\"https://s.w.org/images/browsers/firefox.png?1\";s:15:\"current_version\";s:2:\"56\";s:7:\"upgrade\";b:0;s:8:\"insecure\";b:0;s:6:\"mobile\";b:0;}", "yes");
INSERT INTO wp_lofaro_labs_scroll_options VALUES("51894", "_site_transient_timeout_browser_7a1be88ae2876bc140d8e40ea8063137", "1639799164", "yes");
INSERT INTO wp_lofaro_labs_scroll_options VALUES("51895", "_site_transient_browser_7a1be88ae2876bc140d8e40ea8063137", "a:10:{s:4:\"name\";s:6:\"Chrome\";s:7:\"version\";s:12:\"96.0.4664.93\";s:8:\"platform\";s:9:\"Macintosh\";s:10:\"update_url\";s:29:\"https://www.google.com/chrome\";s:7:\"img_src\";s:43:\"http://s.w.org/images/browsers/chrome.png?1\";s:11:\"img_src_ssl\";s:44:\"https://s.w.org/images/browsers/chrome.png?1\";s:15:\"current_version\";s:2:\"18\";s:7:\"upgrade\";b:0;s:8:\"insecure\";b:0;s:6:\"mobile\";b:0;}", "yes");
INSERT INTO wp_lofaro_labs_scroll_options VALUES("54208", "_site_transient_timeout_browser_3c16d2552fdcae2a06290e26ac42b751", "1649077464", "yes");
INSERT INTO wp_lofaro_labs_scroll_options VALUES("54209", "_site_transient_browser_3c16d2552fdcae2a06290e26ac42b751", "a:10:{s:4:\"name\";s:6:\"Chrome\";s:7:\"version\";s:12:\"99.0.4844.84\";s:8:\"platform\";s:9:\"Macintosh\";s:10:\"update_url\";s:29:\"https://www.google.com/chrome\";s:7:\"img_src\";s:43:\"http://s.w.org/images/browsers/chrome.png?1\";s:11:\"img_src_ssl\";s:44:\"https://s.w.org/images/browsers/chrome.png?1\";s:15:\"current_version\";s:2:\"18\";s:7:\"upgrade\";b:0;s:8:\"insecure\";b:0;s:6:\"mobile\";b:0;}", "yes");
INSERT INTO wp_lofaro_labs_scroll_options VALUES("55400", "_transient_timeout_mailserver_last_checked", "1653373522", "no");
INSERT INTO wp_lofaro_labs_scroll_options VALUES("55401", "_transient_mailserver_last_checked", "1", "no");
INSERT INTO wp_lofaro_labs_scroll_options VALUES("55835", "_site_transient_timeout_browser_d0130996dcc248c264c45b4ea726c975", "1655757212", "yes");
INSERT INTO wp_lofaro_labs_scroll_options VALUES("55836", "_site_transient_browser_d0130996dcc248c264c45b4ea726c975", "a:10:{s:4:\"name\";s:7:\"Firefox\";s:7:\"version\";s:5:\"100.0\";s:8:\"platform\";s:5:\"Linux\";s:10:\"update_url\";s:32:\"https://www.mozilla.org/firefox/\";s:7:\"img_src\";s:44:\"http://s.w.org/images/browsers/firefox.png?1\";s:11:\"img_src_ssl\";s:45:\"https://s.w.org/images/browsers/firefox.png?1\";s:15:\"current_version\";s:2:\"56\";s:7:\"upgrade\";b:0;s:8:\"insecure\";b:0;s:6:\"mobile\";b:0;}", "yes");
INSERT INTO wp_lofaro_labs_scroll_options VALUES("56079", "_site_transient_update_themes", "O:8:\"stdClass\":4:{s:12:\"last_checked\";i:1656046244;s:7:\"checked\";a:8:{s:11:\"dw-timeline\";s:5:\"1.0.9\";s:10:\"illustratr\";s:5:\"1.2.3\";s:10:\"imbalance2\";s:5:\"1.0.3\";s:15:\"metro-creativex\";s:5:\"1.3.6\";s:13:\"twentyfifteen\";s:3:\"1.4\";s:14:\"twentyfourteen\";s:3:\"1.6\";s:13:\"twentysixteen\";s:3:\"1.0\";s:6:\"visual\";s:5:\"1.2.0\";}s:8:\"response\";a:5:{s:10:\"illustratr\";a:6:{s:5:\"theme\";s:10:\"illustratr\";s:11:\"new_version\";s:5:\"1.3.3\";s:3:\"url\";s:40:\"https://wordpress.org/themes/illustratr/\";s:7:\"package\";s:58:\"https://downloads.wordpress.org/theme/illustratr.1.3.3.zip\";s:8:\"requires\";s:3:\"4.2\";s:12:\"requires_php\";b:0;}s:13:\"twentyfifteen\";a:6:{s:5:\"theme\";s:13:\"twentyfifteen\";s:11:\"new_version\";s:3:\"3.2\";s:3:\"url\";s:43:\"https://wordpress.org/themes/twentyfifteen/\";s:7:\"package\";s:59:\"https://downloads.wordpress.org/theme/twentyfifteen.3.2.zip\";s:8:\"requires\";b:0;s:12:\"requires_php\";s:5:\"5.2.4\";}s:14:\"twentyfourteen\";a:6:{s:5:\"theme\";s:14:\"twentyfourteen\";s:11:\"new_version\";s:3:\"3.4\";s:3:\"url\";s:44:\"https://wordpress.org/themes/twentyfourteen/\";s:7:\"package\";s:60:\"https://downloads.wordpress.org/theme/twentyfourteen.3.4.zip\";s:8:\"requires\";b:0;s:12:\"requires_php\";s:5:\"5.2.4\";}s:13:\"twentysixteen\";a:6:{s:5:\"theme\";s:13:\"twentysixteen\";s:11:\"new_version\";s:3:\"2.7\";s:3:\"url\";s:43:\"https://wordpress.org/themes/twentysixteen/\";s:7:\"package\";s:59:\"https://downloads.wordpress.org/theme/twentysixteen.2.7.zip\";s:8:\"requires\";s:3:\"4.4\";s:12:\"requires_php\";s:5:\"5.2.4\";}s:6:\"visual\";a:6:{s:5:\"theme\";s:6:\"visual\";s:11:\"new_version\";s:5:\"1.3.2\";s:3:\"url\";s:36:\"https://wordpress.org/themes/visual/\";s:7:\"package\";s:54:\"https://downloads.wordpress.org/theme/visual.1.3.2.zip\";s:8:\"requires\";b:0;s:12:\"requires_php\";b:0;}}s:12:\"translations\";a:0:{}}", "yes");
INSERT INTO wp_lofaro_labs_scroll_options VALUES("56080", "_site_transient_timeout_browser_276137e981fb49f45b6f0086f2d67529", "1656644511", "yes");
INSERT INTO wp_lofaro_labs_scroll_options VALUES("56081", "_site_transient_browser_276137e981fb49f45b6f0086f2d67529", "a:10:{s:4:\"name\";s:7:\"Firefox\";s:7:\"version\";s:5:\"101.0\";s:8:\"platform\";s:5:\"Linux\";s:10:\"update_url\";s:32:\"https://www.mozilla.org/firefox/\";s:7:\"img_src\";s:44:\"http://s.w.org/images/browsers/firefox.png?1\";s:11:\"img_src_ssl\";s:45:\"https://s.w.org/images/browsers/firefox.png?1\";s:15:\"current_version\";s:2:\"56\";s:7:\"upgrade\";b:0;s:8:\"insecure\";b:0;s:6:\"mobile\";b:0;}", "yes");
INSERT INTO wp_lofaro_labs_scroll_options VALUES("56082", "_transient_timeout_feed_ac0b00fe65abe10e0c5b588f3ed8c7ca", "1656082912", "no");
INSERT INTO wp_lofaro_labs_scroll_options VALUES("56083", "_transient_feed_ac0b00fe65abe10e0c5b588f3ed8c7ca", "a:4:{s:5:\"child\";a:1:{s:0:\"\";a:1:{s:3:\"rss\";a:1:{i:0;a:6:{s:4:\"data\";s:3:\"\n\n\n\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:7:\"version\";s:3:\"2.0\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:1:{s:0:\"\";a:1:{s:7:\"channel\";a:1:{i:0;a:6:{s:4:\"data\";s:112:\"\n	\n	\n	\n	\n	\n	\n	\n	\n	\n\n \n	\n		\n		\n		\n		\n		\n		\n		\n		\n		\n		\n		\n		\n		\n		\n		\n		\n		\n		\n		\n		\n		\n		\n		\n		\n		\n		\n		\n		\n		\n	\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:4:{s:0:\"\";a:8:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:14:\"WordPress News\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:26:\"https://wordpress.org/news\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:59:\"The latest news about WordPress and the WordPress community\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:13:\"lastBuildDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Mon, 13 Jun 2022 11:01:44 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"language\";a:1:{i:0;a:5:{s:4:\"data\";s:5:\"en-US\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:9:\"generator\";a:1:{i:0;a:5:{s:4:\"data\";s:40:\"https://wordpress.org/?v=6.1-alpha-53560\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:5:\"image\";a:1:{i:0;a:6:{s:4:\"data\";s:11:\"\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:1:{s:0:\"\";a:5:{s:3:\"url\";a:1:{i:0;a:5:{s:4:\"data\";s:29:\"https://s.w.org/favicon.ico?2\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:14:\"WordPress News\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:26:\"https://wordpress.org/news\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:5:\"width\";a:1:{i:0;a:5:{s:4:\"data\";s:2:\"32\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:6:\"height\";a:1:{i:0;a:5:{s:4:\"data\";s:2:\"32\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}}s:4:\"item\";a:30:{i:0;a:6:{s:4:\"data\";s:61:\"\n		\n		\n		\n		\n		\n				\n		\n		\n\n					\n										\n					\n		\n		\n\n			\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:4:{s:0:\"\";a:7:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:59:\"WP Briefing: Episode 33: Some Important Questions from WCEU\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:81:\"https://wordpress.org/news/2022/06/episode-33-some-important-questions-from-wceu/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Mon, 13 Jun 2022 11:01:44 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:2:{i:0;a:5:{s:4:\"data\";s:7:\"Podcast\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:1;a:5:{s:4:\"data\";s:11:\"wp-briefing\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:53:\"https://wordpress.org/news/?post_type=podcast&p=13005\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:165:\"WordPress Executive Director Josepha Haden Chomphosy covers some important questions from WordCamp Europe on this special episode of the WordPress Briefing podcast. \";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:9:\"enclosure\";a:1:{i:0;a:5:{s:4:\"data\";s:0:\"\";s:7:\"attribs\";a:1:{s:0:\"\";a:3:{s:3:\"url\";s:60:\"https://wordpress.org/news/files/2022/06/WP-Briefing-033.mp3\";s:6:\"length\";s:1:\"0\";s:4:\"type\";s:0:\"\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:14:\"Santana Inniss\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:13788:\"\n<p>In the thirty-third episode of the WordPress Briefing, hear Josepha Haden Chomphosy recap important questions from WordCamp Europe, and a selection of Contributor Day interviews. </p>\n\n\n\n<p><em><strong>Have a question you&#8217;d like answered? You can submit them to <a href=\"mailto:wpbriefing@wordpress.org\">wpbriefing@wordpress.org</a>, either written or as a voice recording.</strong></em><br></p>\n\n\n\n<h2 id=\"credits\">Credits</h2>\n\n\n\n<ul><li>Editor: <a href=\"https://profiles.wordpress.org/dustinhartzler/\">Dustin Hartzler</a></li><li>Logo: <a href=\"https://profiles.wordpress.org/beafialho/\">Beatriz Fialho</a></li><li>Production: <a href=\"https://profiles.wordpress.org/santanainniss/\">Santana Inniss</a></li><li>Production Assistance: <a href=\"https://profiles.wordpress.org/priethor/\" data-type=\"URL\" data-id=\"https://profiles.wordpress.org/priethor/\">Héctor Prieto</a></li><li>Special Guests: <a href=\"https://profiles.wordpress.org/milana_cap/\" data-type=\"URL\" data-id=\"https://profiles.wordpress.org/milana_cap/\">Milana Cap</a>, <a href=\"https://profiles.wordpress.org/daugis/\">Daugirdas Jankus</a>, and <a href=\"https://profiles.wordpress.org/desrosj/\" data-type=\"URL\" data-id=\"https://profiles.wordpress.org/desrosj/\">Jonathan Desrosiers</a></li><li>Song: Fearless First by Kevin MacLeod</li></ul>\n\n\n\n<h2>References</h2>\n\n\n\n<ul><li><em><a href=\"https://en.wikipedia.org/wiki/L%27esprit_de_l%27escalier\" data-type=\"URL\" data-id=\"https://en.wikipedia.org/wiki/L%27esprit_de_l%27escalier\">L&#8217;esprit de l&#8217;escalier</a></em></li><li><a href=\"https://make.wordpress.org/core/2022/05/20/core-editor-improvement-creating-containing-containers/\" data-type=\"URL\">Flexbox Layout Blocks</a></li><li><a href=\"https://make.wordpress.org/training/2022/03/10/recap-of-training-team-meetings-march-8-and-10-2022/\" data-type=\"URL\" data-id=\"https://make.wordpress.org/training/2022/03/10/recap-of-training-team-meetings-march-8-and-10-2022/\">Translating Content on Learn WordPress</a></li><li><a href=\"https://make.wordpress.org/training/handbook/workshops/workshop-subtitles-and-transcripts/translating-subtitles/\" data-type=\"URL\" data-id=\"https://make.wordpress.org/training/handbook/workshops/workshop-subtitles-and-transcripts/translating-subtitles/\">Translating Subtitles</a></li><li><a href=\"https://josepha.blog/2020/01/15/fostering-collaboration-across-cultures/\" data-type=\"URL\" data-id=\"https://josepha.blog/2020/01/15/fostering-collaboration-across-cultures/\">Collaboration Across Cultures</a> (Blog)</li><li><a href=\"https://www.youtube.com/watch?v=8MzJCT2BVV0\" data-type=\"URL\" data-id=\"https://www.youtube.com/watch?v=8MzJCT2BVV0\">Collaboration Across Cultures</a> (YouTube Video)</li><li><a href=\"https://europe.wordcamp.org/2023/call-for-organisers/\" data-type=\"URL\" data-id=\"https://europe.wordcamp.org/2023/call-for-organisers/\">WordCamp Europe Athens: Call for Organizers</a></li><li><a href=\"https://twitter.com/matias_ventura/status/1534602705456480260\" data-type=\"URL\" data-id=\"https://twitter.com/matias_ventura/status/1534602705456480260\">6.1 Release Planning Twitter Thread</a></li><li><a href=\"https://make.wordpress.org/core/2022/06/04/roadmap-to-6-1/\" data-type=\"URL\" data-id=\"https://make.wordpress.org/core/2022/06/04/roadmap-to-6-1/\">6.1 Release Planning Roadmap Post</a></li><li><a href=\"https://make.wordpress.org/meetings/\" data-type=\"URL\" data-id=\"https://make.wordpress.org/meetings/\">Make WordPress Meetings Calendar</a></li></ul>\n\n\n\n<h2>Transcript</h2>\n\n\n\n<span id=\"more-13005\"></span>\n\n\n\n<p>[<strong>Daugirdas Jankus </strong>00:00:04]&nbsp;</p>\n\n\n\n<p>Honestly, it&#8217;s not a secret. It&#8217;s a big part of our business. And I think it&#8217;s like WordPress is a big part of all the hosting company, company’s, businesses, you know? So for us, it is like, we want to make it better. We want to give back. We want to understand, you know, where we can contribute the most. And we see it as a, you know, win, win, win situation for everyone, for clients, for the whole ecosystem.</p>\n\n\n\n<p>And for us as a business, of course!</p>\n\n\n\n<p>[<strong>Milana Cap </strong>00:00:32]&nbsp;</p>\n\n\n\n<p>My favorite WordPress component is WP CLI. That&#8217;s my crush, haha, because I love terminal. I love doing it. I&#8217;m not a really UI type of person, I get lost in UI. But in terminal, you just type command and it does what you want. And a WP CLI is much more powerful than WordPress dashboard. You can do so many things there and you can have fun.</p>\n\n\n\n<p>Uh, so that&#8217;s my go-to tool!</p>\n\n\n\n<p>[<strong>Josepha Haden Chomphosy </strong>00:01:10]&nbsp;</p>\n\n\n\n<p>Hello everyone. And welcome to the WordPress Briefing– the podcast where you can catch quick explanations of the ideas behind the WordPress open source project, some insight into the community that supports it, and get a small list of big things coming up in the next two weeks. I&#8217;m your host, Josepha Haden Chomphosy.</p>\n\n\n\n<p>Here we go!</p>\n\n\n\n<p>[<strong>Josepha Haden Chomphosy </strong>00:01:36]&nbsp;</p>\n\n\n\n<p>Many, many people were at WordCamp Europe a couple of weeks ago. And at the end, Matt and I closed out the event sessions with a little question and answer time from the community. I was excited to see everyone and excited to answer their questions. But as with all spur of the moment answers, I experienced this <em>l&#8217;esprit de l&#8217;escalier </em>and I found that there were a few things that I would have answered a little more completely if I had taken more than two seconds to think about them.</p>\n\n\n\n<p>So today I&#8217;m going to augment some of the answers from that session with a little more context and clarity. There was a question from Laura Byrne about favorite blocks in recent WordPress releases. And given that I was exclusively holding WordCamp Europe information in my brain at the time, I couldn&#8217;t think of which block was my favorite. While I was sitting there on that stage,</p>\n\n\n\n<p>I realized that one of my favorite things about WordPress’s 6.0 release, like Matt, wasn&#8217;t really a block, but it was a functional workflow sort of thing. So my favorite thing was the ability to lock blocks, but I mean, the question was about favorite blocks. And so I do know that some of the most anticipated blocks are the Flexbox layout blocks. Whew. What a sentence!</p>\n\n\n\n<p>[<strong>Josepha Haden Chomphosy </strong>00:02:46]</p>\n\n\n\n<p>Try to say that three times fast! Those blocks are the Flexbox layout blocks, they are sort of shortcuts that show up when you&#8217;re selecting multiple blocks and allow for easy side-by-side layouts. I&#8217;m not explaining it in a way that does it much justice, but I will share a link in the show notes that has more information and you can kind of see how empowering that particular block is in the block editor.</p>\n\n\n\n<p>The next question I wanted to give a little more context to came from Courtney Robertson. She asked about how to make translated content more readily available on learn.wordpress.org. My answer was pretty far ranging and talked about why it&#8217;s harder to commit to prioritizing that over, for my example, translating WordPress core.&nbsp;</p>\n\n\n\n<p>But I also understand that there are people who want to help and just need someone to point them in the right direction. And so I want to be clear that it is possible to have workshops in any language on learn.wordpress.org right now. We just don&#8217;t have a lot of people contributing those translations.</p>\n\n\n\n<p>So there are conversations going on right now in the training team about using Glotpress on learn.wordpress.org, and also how to translate subtitles. So, if you are looking for ways to give back through translation and training is an important kind of area of your focus. I will have links to both of those things in the show notes as well.</p>\n\n\n\n<p>[<strong>Josepha Haden Chomphosy </strong>00:04:11]</p>\n\n\n\n<p>I also gave a quick answer, uh, after this question about how hard it is to recognize contributions that are separate from a major event or major release. In this case, when I say recognize, that&#8217;s recognized as in thank, not recognize as in, know it exists. In case it&#8217;s not clear why that was connected, why that answer was connected to the question, training materials are self-serve and not always specific to individual releases of WordPress.</p>\n\n\n\n<p>So that means the maintenance of any content around training happens routinely over the course of time, rather than because of a specific release or a WordCamp. What sometimes can make it a little harder to entice people to join us in that work.&nbsp;</p>\n\n\n\n<p>And now the third question I&#8217;d like to tackle is the one that came from Megan Rose. She asked how we can encourage better diversity as we go back to in-person events. My answer was more about the big picture, program-wide work that has been done and specific awarenesses that I, as a leader, have been keeping top of mind. That answer is still true and is still important, but again, it doesn&#8217;t really help anyone who&#8217;s wondering how they can show up today in their own communities, and do the hard work of fostering an inclusive space there so that we can confidently welcome more diverse voices together.&nbsp;</p>\n\n\n\n<p>[<strong>Josepha Haden Chomphosy </strong>00:05:27]</p>\n\n\n\n<p>A great place to start is to have conversations with people who aren&#8217;t like you and really listen. Also recognizing that we all come from different backgrounds that give us more or less opportunity and always be asking yourself, who is missing from this conversation and why, how can I find them and invite them into our own WordPress spaces?</p>\n\n\n\n<p>If that all kind of feels right up your alley, I would check out the show notes. I&#8217;ll have some links in there to the community team’s site, as well as a few posts that will help you to explore that a bit further as well.&nbsp;</p>\n\n\n\n<p>There were also a couple of questions about market share slash usage of WordPress, and Five for the Future that I really do want to answer, but as I was writing up the context and just kind of exploring the questions that people were raising, it turned out to really be quite a big set of answers.</p>\n\n\n\n<p>So I will do those in either two separate episodes of their own or one surprisingly long, for me, episode. And so there you have it, a lightning round, deep dive on a few questions from WordCamp Europe.</p>\n\n\n\n<p>[<strong>Jonathan Desrosiers </strong>00:06:41]&nbsp;</p>\n\n\n\n<p>Yeah, it&#8217;s definitely great to be back in person. Um, it&#8217;s been a long two years, two or three years for a lot of people and it&#8217;s, it&#8217;s, it&#8217;s great that we&#8217;re such an asynchronous community and we can all stay connected online through Slack and different means. Um, but there are some things that you can&#8217;t replace, like making friends with people and learning people&#8217;s demeanors and having some discussions in person that you can&#8217;t replace.</p>\n\n\n\n<p>And so, uh, I&#8217;m really excited to see people I haven&#8217;t seen in a long time. Meet new people and, um, you know, have some of those discussions here today in Portugal.</p>\n\n\n\n<p>[<strong>Josepha Haden Chomphosy </strong>00:07:21]&nbsp;</p>\n\n\n\n<p>Which then brings us to our small list of big things.&nbsp;</p>\n\n\n\n<p>If you missed the announcement, WordCamp Europe will be in Athens next year. And the call for organizers is open already. It&#8217;s an experience that is absolutely irreplaceable. So I&#8217;ll link to that in the show notes, in case you&#8217;ve always wanted to give back to WordPress that way.</p>\n\n\n\n<p>The second thing on my list is that work on the next major release of WordPress is already underway. There is a post with roadmap info that was published recently, as well as a slightly more casual thread on Twitter. I&#8217;ve linked both of those in the show notes, so that you have some concept of what it is that we are aiming for in 6.1, and also a concept of where to go to get started working on it if that&#8217;s what you feel like doing, uh, for the next three to four months– 120 days, roughly.</p>\n\n\n\n<p>Uh, and finally. This is less of like a thing to be aware of in the next two weeks and kind of a little WordPress project tool tip. Did you know that we have a calendar that shows all meetings for all teams all week long? It will make you feel tired by the amount of work that gets done in the WordPress project every week, but it&#8217;s right there on make.wordpress.org/meetings.</p>\n\n\n\n<p>So you never have to wonder where folks are meeting to talk about things ever again. And that my friends is your small list of big things. Thank you for tuning in today for the WordPress Briefing. I&#8217;m your host, Josepha Haden Chomphosy, and I&#8217;ll see you again in a couple of weeks.</p>\n\n\n\n<p>[<strong>Santana Inniss &amp; Héctor Prieto </strong>00:09:11]&nbsp;</p>\n\n\n\n<p>Hello! Mic test. One, two, one, two.&nbsp;</p>\n\n\n\n<p>We are testing the USB microphone. Let&#8217;s hope we&#8217;re using it actually.&nbsp;</p>\n\n\n\n<p>I think so. I think so.&nbsp;</p>\n\n\n\n<p>Yes. Because now I am far, and now I am much closer to the microphone. Yes.&nbsp;</p>\n\n\n\n<p>And I am sitting in the same spot.&nbsp;</p>\n\n\n\n<p>Good. Hello?&nbsp;</p>\n\n\n\n<p>Hello!&nbsp;</p>\n\n\n\n<p>Mic test one, two.</p>\n\n\n\n<p>Mic test one, two.&nbsp;</p>\n\n\n\n<p>[record scratching sound effect]</p>\n\n\n\n<p>[laughter]</p>\n\n\n\n<p>And, close.</p>\n\n\n\n<p>Mic check.&nbsp;</p>\n\n\n\n<p>Mic check.&nbsp;</p>\n\n\n\n<p>[record scratching sound effect]</p>\n\n\n\n<p>I&#8217;m close to the mic. I&#8217;m far from the mic.&nbsp;</p>\n\n\n\n<p>I&#8217;m far from the mic. Wow.</p>\n\n\n\n<p>Not so far.</p>\n\n\n\n<p>[laughter]</p>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:30:\"com-wordpress:feed-additions:1\";a:1:{s:7:\"post-id\";a:1:{i:0;a:5:{s:4:\"data\";s:5:\"13005\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:1;a:6:{s:4:\"data\";s:60:\"\n		\n		\n		\n		\n		\n				\n		\n		\n\n					\n										\n					\n		\n		\n			\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:4:{s:0:\"\";a:6:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:35:\"The Month in WordPress – May 2022\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:67:\"https://wordpress.org/news/2022/06/the-month-in-wordpress-may-2022/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 02 Jun 2022 11:35:47 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:2:{i:0;a:5:{s:4:\"data\";s:18:\"Month in WordPress\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:1;a:5:{s:4:\"data\";s:18:\"month in wordpress\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:35:\"https://wordpress.org/news/?p=12993\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:346:\"WordPress has a lot to celebrate this month. The newest release “Arturo” is here. WordPress turned 19 years old last week. And WordCamp Europe, the first in-person flagship WordCamp in two years, is starting today in Porto, Portugal. Read on to learn more about these and other exciting news around WordPress! Say hello to WordPress [&#8230;]\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:14:\"rmartinezduque\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:12471:\"\n<p>WordPress has a lot to celebrate this month. The newest release “Arturo” is here. WordPress turned 19 years old last week. And WordCamp Europe, the first in-person flagship WordCamp in two years, is starting today in Porto, Portugal. Read on to learn more about these and other exciting news around WordPress!</p>\n\n\n\n<hr class=\"wp-block-separator has-css-opacity\" />\n\n\n\n<h2>Say hello to WordPress 6.0 “Arturo”</h2>\n\n\n\n<p><strong>WordPress 6.0 “Arturo” was released on May 24, 2022</strong>. Named in honor of the Latin jazz musician Arturo O’Farrill, the awaited release brings more customization tools and numerous updates to make the site-building experience more intuitive.</p>\n\n\n\n<p>Check out the <a href=\"https://youtu.be/oe452WcY7fA\">WordPress 6.0 video</a> and the <a href=\"https://wordpress.org/news/2022/05/arturo/\">announcement post</a> for an overview of the most important changes. Interested in knowing more about the features that will help you build with and extend WordPress? Then the WordPress 6.0 <a href=\"https://make.wordpress.org/core/2022/05/03/wordpress-6-0-field-guide/\">Field Guide</a> might be for you.</p>\n\n\n\n<figure class=\"wp-block-embed is-type-video is-provider-youtube wp-block-embed-youtube wp-embed-aspect-16-9 wp-has-aspect-ratio\"><div class=\"wp-block-embed__wrapper\">\n<iframe class=\"youtube-player\" width=\"600\" height=\"338\" src=\"https://www.youtube.com/embed/oe452WcY7fA?version=3&#038;rel=1&#038;showsearch=0&#038;showinfo=1&#038;iv_load_policy=1&#038;fs=1&#038;hl=en-US&#038;autohide=2&#038;wmode=transparent\" allowfullscreen=\"true\" style=\"border:0;\" sandbox=\"allow-scripts allow-same-origin allow-popups allow-presentation\"></iframe>\n</div></figure>\n\n\n\n<p>Over 500+ people in 58+ countries made WordPress 6.0 possible – Thank you!</p>\n\n\n\n<div class=\"wp-container-1 wp-block-buttons\">\n<div class=\"wp-block-button aligncenter\"><a class=\"wp-block-button__link\" href=\"https://wordpress.org/download/\"><strong>Download WordPress 6.0</strong></a></div>\n</div>\n\n\n\n<h2>Happy 19th birthday, WordPress!</h2>\n\n\n\n<p>Time flies, doesn&#8217;t it? Believe it or not, May 27 marked the 19th anniversary of WordPress’ first release! To celebrate, the community put together <a href=\"https://wp19.day/\">a special site</a> (wp19.day) where contributors shared thoughts, videos, live shows, and more.</p>\n\n\n\n<p>You can still join the fun using the hashtag #WP19Day on social media, or even contribute photos of the swag you used to celebrate to the <a href=\"https://wordpress.org/photos/\">WordPress Photo Directory</a>.</p>\n\n\n\n<div class=\"wp-container-2 wp-block-buttons\">\n<div class=\"wp-block-button aligncenter\"><a class=\"wp-block-button__link\" href=\"https://make.wordpress.org/marketing/2022/04/01/grow-your-story-on-wordpress/\"><strong><strong><strong>If you haven&#8217;t yet, this is also a great opportunity to share your WordPress story. Visit the #GrowYourStoryWP initiative to learn more – We’d love to hear from you.</strong></strong></strong></a></div>\n</div>\n\n\n\n<h2>New in Gutenberg</h2>\n\n\n\n<p>Two new versions of Gutenberg were released last month:</p>\n\n\n\n<ul><li><a href=\"https://make.wordpress.org/core/2022/05/12/whats-new-in-gutenberg-13-2-may-11/\">Gutenberg 13.2</a> shipped on May 11, 2022, and brings a new API to save editor preferences on the server, visual guides for padding and margins, and improvements to the Comment block.</li><li><a href=\"https://make.wordpress.org/core/2022/05/26/whats-new-in-gutenberg-13-3-0-may-25/\">Gutenberg 13.3</a> comes with a new Table of Contents block and a number of enhancements to existing blocks to provide more ways to display content, among other highlights. It was released on May 25, 2022.</li></ul>\n\n\n\n<div class=\"wp-container-3 wp-block-buttons\">\n<div class=\"wp-block-button aligncenter\"><a class=\"wp-block-button__link\" href=\"https://make.wordpress.org/core/tag/gutenberg-new/\"><strong><strong>Follow the </strong><strong>#gutenberg-new</strong><strong> posts for more details on the latest updates.</strong></strong></a></div>\n</div>\n\n\n\n<h2>Team updates: Five for the Future, guidelines for in-person regional WordCamps, and more</h2>\n\n\n\n<ul><li>Following an earlier discussion on in-person regional WordCamps, the Community team announced new <a href=\"https://make.wordpress.org/community/2022/05/23/regional-in-person-wordcamps-going-forward/\">guidelines</a> for these WordPress events.</li><li>The Five for the Future (5ftF) initiative is key to ensuring the future of the WordPress project. As part of the ongoing efforts to improve this initiative, Executive Director Josepha Haden suggested a <a href=\"https://make.wordpress.org/project/2022/05/20/defining-five-for-the-future-pledges-contributions/\">definition</a> for 5ftF pledges and contributions.</li><li>Tonya Mork posted a summary of the <a href=\"https://make.wordpress.org/test/2022/05/31/core-test-stats-for-wordpress-6-0/\">core test stats for WordPress 6.0</a>.</li><li>The Meta and Theme Review teams shared an update on the work done over the past year to <a href=\"https://make.wordpress.org/meta/2022/05/23/theme-reviews-improvements/\">improve the theme review process</a>. As a result, the average time for themes to be reviewed has decreased by 90%.</li><li>Josepha Haden kicked off a discussion post to gather feedback on the <a href=\"https://make.wordpress.org/project/2022/05/20/discussion-contrib-handbook-part-3/\">Community Code of Conduct</a> section of the new <a href=\"https://make.wordpress.org/updates/2021/03/16/proposal-a-wordpress-project-contributor-handbook/\">Contributor Handbook</a>.</li><li>On a similar note, the Community team created a new <a href=\"https://make.wordpress.org/updates/2022/05/26/announcement-incident-response-training/\">Incident Response Training</a>. The course, which is live on <a href=\"https://learn.wordpress.org/course/incident-response-team-training/\">Learn WordPress</a> and considered a work in progress, addresses how WordPress contributors take and respond to code of conduct reports.</li><li>The Training team published new lesson plans, workshops, courses, and Social Learning Spaces on Learn WordPress. <a href=\"https://make.wordpress.org/updates/2022/05/01/whats-new-on-learnwp-in-april-2022/\">See what’s new</a>.</li><li>The #WPDiversity working group organized several <a href=\"https://make.wordpress.org/community/2022/05/06/report-allyship-and-diverse-speaker-workshops-april-2022/\">Allyship and Diverse Speaker Workshops</a> in April. Attendees reported a 40% increase in public speaking confidence after attending the Speaker workshops. <a href=\"https://make.wordpress.org/community/tag/wpdiversity/\">Stay tuned</a> for the next events!</li><li>A <a href=\"https://make.wordpress.org/test/2022/05/30/fse-program-rallying-recipe-reviewers-summary/\">summary</a> of the 14th testing call of the Full Site Editing (FSE) Outreach program – “Rallying Recipe Reviewers” was recently published.</li><li>You can also find <a href=\"https://make.wordpress.org/core/2022/05/31/high-level-feedback-from-the-fse-outreach-program-may-2022/\">high-level feedback on the FSE Program</a> in this May 2022 post.</li><li>Learn more about the <a href=\"https://make.wordpress.org/design/2022/05/23/design-share-may-9-20/\">projects</a> the Design team contributed to over the past month.</li><li>Anne McCarthy hosted a Hallway Hangout to talk about various FSE pull requests and designs. The recording is available in <a href=\"https://make.wordpress.org/test/2022/05/25/hallway-hangout-discussion-on-full-site-editing-issues-prs-designs-25-may/\">this post</a>. </li><li>The May editions of the <a href=\"https://make.wordpress.org/community/2022/05/20/meetup-organizer-newsletter-may-2022/\">Meetup Organizer Newsletter</a> and the <a href=\"https://make.wordpress.org/polyglots/2022/05/31/polyglots-monthly-newsletter-may-2022/\">Polyglots Monthly Newsletter</a> were published.</li><li>The latest edition of People of WordPress features the story of <a href=\"https://wordpress.org/news/2022/05/people-of-wordpress-dee-teal/\">Dee Teal</a>.</li></ul>\n\n\n\n<div class=\"wp-container-4 wp-block-buttons\">\n<div class=\"wp-block-button\"><a class=\"wp-block-button__link\" href=\"https://wordpress.org/news/2022/05/episode-31-open-source-accessibility-celebrating-global-accessibility-awareness-day-with-guest-joe-devon/\"><strong><strong>The </strong><strong>thirty-first episode of WP Briefing</strong><strong> celebrated Global Accessibility Awareness Day (May 19) with guest Joe Devon.</strong></strong></a></div>\n</div>\n\n\n\n<h2>Open feedback/testing calls</h2>\n\n\n\n<ul><li>The Core team is working on ​​an experimental pull request (PR) to implement <a href=\"https://make.wordpress.org/core/2022/05/27/block-font-sizes-and-fluid-typography/\">fluid typography</a>. They welcome feedback on design, functionality, and API.</li><li>Version 20.0 of WordPress for <a href=\"https://make.wordpress.org/mobile/2022/05/31/call-for-testing-wordpress-for-android-20-0/\">Android</a> and <a href=\"https://make.wordpress.org/mobile/2022/05/30/call-for-testing-wordpress-for-ios-20-0/\">iOS</a> is now available for testing.</li><li>Were you involved in the WordPress 6.0 release? Take some time to reflect on what you learned and participate with your feedback in this <a href=\"https://make.wordpress.org/core/2022/05/27/wordpress-6-0-arturo-retrospective/\">retrospective</a>.</li></ul>\n\n\n\n<div class=\"is-content-justification-center wp-container-5 wp-block-buttons\">\n<div class=\"wp-block-button aligncenter\"><a class=\"wp-block-button__link\" href=\"https://make.wordpress.org/project/2022/05/23/request-for-feedback-recording-five-for-the-future-contributions/\"><strong><strong><strong>Angela Jin has asked for feedback to help identify and record Five for the Future contributions from Make teams. </strong><strong>Share your ideas in this post</strong><strong>.</strong></strong></strong></a></div>\n</div>\n\n\n\n<h2>WordCamp Europe is here!</h2>\n\n\n\n<ul><li>WordPress Foundation’s Kim Parsell Memorial Scholarship returns for WordCamp US 2022. <a href=\"https://us.wordcamp.org/2022/the-kim-parsells-memorial-scholarship-apply-now/\">Visit this post</a> for more information.</li><li>The WordCamp US <a href=\"https://us.wordcamp.org/2022/call-for-sponsors-open-wcus/\">Call for Sponsors</a> is now open.</li><li>Two more in-person WordCamps are happening this month:<ul><li><img src=\"https://s.w.org/images/core/emoji/14.0.0/72x72/1f1f5-1f1f1.png\" alt=\"🇵🇱\" class=\"wp-smiley\" style=\"height: 1em; max-height: 1em;\" /> <a href=\"https://warsaw.wordcamp.org/2022/\">WordCamp Warsaw</a>, Poland on June 11-12, 2022</li><li><img src=\"https://s.w.org/images/core/emoji/14.0.0/72x72/1f1fa-1f1f8.png\" alt=\"🇺🇸\" class=\"wp-smiley\" style=\"height: 1em; max-height: 1em;\" /> <a href=\"https://montclair.wordcamp.org/2022/\">WordCamp Montclair</a>, NJ, USA on June 25, 2022</li></ul></li><li>The WordPress community is meeting today at <a href=\"https://europe.wordcamp.org/2022/\">WordCamp Europe</a> (June 2-4) in Porto, Portugal. This edition celebrates the return to in-person events and the 10th anniversary of WCEU. For everyone heading to Porto, have a great WordCamp!</li></ul>\n\n\n\n<div class=\"is-content-justification-center wp-container-6 wp-block-buttons\">\n<div class=\"wp-block-button aligncenter\"><a class=\"wp-block-button__link\" href=\"https://wordpress.org/news/2022/05/episode-32-an-open-source-reading-list/\"><strong><strong><strong><strong>Traveling to WCEU? Check out Josepha Haden’s </strong><strong>open source reading list</strong><strong> for interesting reads while you travel!</strong></strong></strong></strong></a></div>\n</div>\n\n\n\n<hr class=\"wp-block-separator has-css-opacity\" />\n\n\n\n<p><strong><em><strong><em>Have a story that we could include in the next issue of The Month in WordPress? Let us know by filling out </em></strong><a href=\"https://make.wordpress.org/community/month-in-wordpress-submissions/\"><strong><em>this form</em></strong></a><strong><em>.</em></strong></em></strong></p>\n\n\n\n<p><em>The following folks contributed to this Month in WordPress: <a href=\'https://profiles.wordpress.org/rmartinezduque/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>rmartinezduque</a>, <a href=\'https://profiles.wordpress.org/laurlittle/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>laurlittle</a>, <a href=\'https://profiles.wordpress.org/harishanker/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>harishanker</a></em>.</p>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:30:\"com-wordpress:feed-additions:1\";a:1:{s:7:\"post-id\";a:1:{i:0;a:5:{s:4:\"data\";s:5:\"12993\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:2;a:6:{s:4:\"data\";s:72:\"\n		\n		\n		\n		\n		\n				\n		\n		\n		\n		\n		\n		\n\n					\n										\n					\n		\n		\n			\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:4:{s:0:\"\";a:6:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:29:\"People of WordPress: Dee Teal\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:64:\"https://wordpress.org/news/2022/05/people-of-wordpress-dee-teal/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Tue, 31 May 2022 17:51:53 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:6:{i:0;a:5:{s:4:\"data\";s:9:\"Community\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:1;a:5:{s:4:\"data\";s:8:\"Features\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:2;a:5:{s:4:\"data\";s:7:\"General\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:3;a:5:{s:4:\"data\";s:10:\"Interviews\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:4;a:5:{s:4:\"data\";s:9:\"HeroPress\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:5;a:5:{s:4:\"data\";s:19:\"People of WordPress\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:35:\"https://wordpress.org/news/?p=12946\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:90:\"This month\'s People of WordPress feature shares the story of Dee Teal, based in Australia.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:28:\"webcommsat AbhaNonStopNewsUK\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:14950:\"\n<p>In this series, we share some of the inspiring stories of how WordPress and its global network of contributors can change people&#8217;s lives for the better. This month we feature a WordPress development and large project specialist on the difference the software and community can make to your career and life.</p>\n\n\n\n<figure class=\"wp-block-image size-large\"><img decoding=\"async\" loading=\"lazy\" width=\"1024\" height=\"515\" src=\"https://i2.wp.com/wordpress.org/news/files/2022/05/Dee-Teal.jpg?resize=1024%2C515&#038;ssl=1\" alt=\"\" class=\"wp-image-12955\" srcset=\"https://i2.wp.com/wordpress.org/news/files/2022/05/Dee-Teal.jpg?resize=1024%2C515&amp;ssl=1 1024w, https://i2.wp.com/wordpress.org/news/files/2022/05/Dee-Teal.jpg?resize=300%2C151&amp;ssl=1 300w, https://i2.wp.com/wordpress.org/news/files/2022/05/Dee-Teal.jpg?resize=768%2C386&amp;ssl=1 768w, https://i2.wp.com/wordpress.org/news/files/2022/05/Dee-Teal.jpg?w=1247&amp;ssl=1 1247w\" sizes=\"(max-width: 1000px) 100vw, 1000px\" data-recalc-dims=\"1\" /></figure>\n\n\n\n<p>Dee’s story with computers started at school in New Zealand where discovering how a mouse worked and learning BASIC and Pascal was a catalyst for what later became a programming career.</p>\n\n\n\n<p>At a time when computers were just becoming mainstream, there were no opportunities for girls in her school to consider this as a further option. She recalls: “No one thought to say, ‘Dee, you look like you’re good at this, you should pursue it…’. I mean, I was a girl (and I was told girls didn’t ‘do’ computers). No one in the circles I moved in really had any idea where this technology revolution would take us.”</p>\n\n\n\n<p>With no particular career path into technology, Dee was encouraged in her final year of school to apply for a job in a bank where she worked and became a teller three years later. She gained financial independence, which enabled her to travel as a 20-year-old and spend the next three years exploring the US and Europe.</p>\n\n\n\n<p>Looking back, she noted how the world had changed: the first computer mouse she had seen had come out in 1983, and 20 years later WordPress was founded.</p>\n\n\n\n<h2>Journey into coding</h2>\n\n\n\n<p>During those 20 years, Dee worked as a nanny, working in child care centers, in customer support, and as a temp.</p>\n\n\n\n<p>In 1999, she packed up her bags once again, and moved from New Zealand to Australia. She took a place at a performing arts school where she honed her singing and performance skills and volunteered her time to the music director who was starting to experiment with sending out HTML newsletters and updates via email.</p>\n\n\n\n<p>“And so my personal revolution began. On the day after I graduated from that course, I walked into a full-time role as that music director’s assistant and began my journey back to code.”</p>\n\n\n\n<p>As part of that job, Dee edited and sent HTML newsletters on a weekly basis. This ignited her interest in programming, and she bought books about coding for the web and experimented on her home-built PC making web pages. </p>\n\n\n\n<blockquote class=\"wp-block-quote\"><p>“I’m sure, like a lot of us, I remember the thrill of creating that first HTML file and seeing a ‘Hello World’ or similar heading rendered in the browser. From there, I was completely hooked.”</p><cite>Dee Teal</cite></blockquote>\n\n\n\n<p>Later she moved to the IT department and took on maintenance of all the websites. By 2004, she was working full-time as a webmaster. A year later, she was running a small business creating sites on the side. Four years after that, her business became her full-time job as she left employment to pursue her Masters Degree in Digital Communication and Culture.</p>\n\n\n\n<figure class=\"wp-block-image size-large\"><img decoding=\"async\" loading=\"lazy\" width=\"1024\" height=\"768\" src=\"https://i0.wp.com/wordpress.org/news/files/2022/05/R0011864.jpg?resize=1024%2C768&#038;ssl=1\" alt=\"Dee with other contributors getting things ready for a WordCamp\" class=\"wp-image-12961\" srcset=\"https://i0.wp.com/wordpress.org/news/files/2022/05/R0011864.jpg?resize=1024%2C768&amp;ssl=1 1024w, https://i0.wp.com/wordpress.org/news/files/2022/05/R0011864.jpg?resize=300%2C225&amp;ssl=1 300w, https://i0.wp.com/wordpress.org/news/files/2022/05/R0011864.jpg?resize=768%2C576&amp;ssl=1 768w, https://i0.wp.com/wordpress.org/news/files/2022/05/R0011864.jpg?w=1200&amp;ssl=1 1200w\" sizes=\"(max-width: 1000px) 100vw, 1000px\" data-recalc-dims=\"1\" /><figcaption>Dee and other volunteers setting up for a local WordCamp</figcaption></figure>\n\n\n\n<p>Dee found the theory and sociology behind the web, and its facilitation of human and machine communication fascinating.</p>\n\n\n\n<p>She said: “I love the fact that the tech industry involves a constant constant curve of growth and discovery, which results in a perpetual exercise in finding creative elegant solutions for sticky problems.”</p>\n\n\n\n<p>For Dee, being able to use her innate curiosity to leverage processes, people, and tools, fuelled by a focus on communicating a message, has been a defining inspiration in her work.</p>\n\n\n\n<p>This combined fascination coincided with her meeting WordPress in 2009 and subsequently its community. She moved her existing blog to the software and it became the CMS of choice for all her client work.</p>\n\n\n\n<h2>The WordPress community can change your world</h2>\n\n\n\n<p>In 2011, she stumbled across WordCamps and by extension the WordPress community. Dee has reflected publicly that WordPress didn’t change her life, its community changed her world!</p>\n\n\n\n<p>She flew on a whim from her then home in Sydney to attend a WordCamp in Melbourne she had found after a search for ‘WordPress Conferences’.</p>\n\n\n\n<p>She said: “I met welcoming people, made friends, connected, and came back home excited and hopeful about continuing this connection with the wider WordPress community.”</p>\n\n\n\n<p>Building a community locally around WordPress got off to a slow start in Sydney. From an inauspicious early WordPress Sydney meetup in the function room of a pub, her connection and involvement took off. Before long she was helping organize that meetup, and by the time she moved away from that great city it had branched into two meetups, and soon after, into three.</p>\n\n\n\n<p>She was so inspired by the community that at the end of that first year and her second WordCamp, she raised her hand to help organize a WordCamp Sydney in 2012, and after moving interstate, WordCamp Melbourne in 2013.</p>\n\n\n\n<blockquote class=\"wp-block-quote\"><p>&#8220;WordPress and any other software package exist to serve people.&#8221;</p><cite>Dee Teal</cite></blockquote>\n\n\n\n<p>Dee said: “WordPress, software, technology, the Internet will come and go, morph, and change, evolve. Maybe WordPress will last forever, maybe it will morph into something else, maybe one day it will look completely different than it did when I first started (actually, that’s true now). The thing that doesn’t change is the humanity around it. WordPress and any other software package exist to serve people.”</p>\n\n\n\n<p>She added: “The thing that I have learned, not only through WordPress but in life, is that if we too serve the people around what we’re doing, we ourselves will grow, develop and change alongside the people we serve, and the tools we use to serve them.”</p>\n\n\n\n<figure class=\"wp-block-image size-large\"><img decoding=\"async\" loading=\"lazy\" width=\"1024\" height=\"329\" src=\"https://i0.wp.com/wordpress.org/news/files/2022/05/Dee_POW_5.6_slice-large.png?resize=1024%2C329&#038;ssl=1\" alt=\"Dee pictured second from left as part of the WordPress 5.6 contributors\" class=\"wp-image-12957\" srcset=\"https://i0.wp.com/wordpress.org/news/files/2022/05/Dee_POW_5.6_slice-large.png?resize=1024%2C329&amp;ssl=1 1024w, https://i0.wp.com/wordpress.org/news/files/2022/05/Dee_POW_5.6_slice-large.png?resize=300%2C96&amp;ssl=1 300w, https://i0.wp.com/wordpress.org/news/files/2022/05/Dee_POW_5.6_slice-large.png?resize=768%2C246&amp;ssl=1 768w, https://i0.wp.com/wordpress.org/news/files/2022/05/Dee_POW_5.6_slice-large.png?w=1200&amp;ssl=1 1200w\" sizes=\"(max-width: 1000px) 100vw, 1000px\" data-recalc-dims=\"1\" /><figcaption>Some of the contributors to the <em>WordPress 5.6 release</em> </figcaption></figure>\n\n\n\n<p>Dee was a coordinator for WordPress 5.6 release in 2020 and was able to encourage others to learn about the process.</p>\n\n\n\n<h2>Helping others and sharing knowledge through WordPress</h2>\n\n\n\n<p>Dee has been an advocate for cross-cultural collaboration and understanding in both WordPress and her work for a large distributed agency which has people from more than 24 countries and operates across 16 timezones. She has also written about closing the gap between diverse distributed teams and how to meet the challenges of cross cultural remote work.</p>\n\n\n\n<p>Dee has given talks at WordCamps, including at WordCamp Europe in 2019, on developing ourselves, our relationships, and our communities in increasingly diverse environments.</p>\n\n\n\n<p>With a strong desire to share her professional knowledge and experience, Dee hopes her involvement in the WordPress community from being part of a Release Squad in the Core Team, and volunteering in the community through organizing and speaking at WordCamp events, will inspire others to get involved.</p>\n\n\n\n<blockquote class=\"wp-block-quote\"><p>&#8220;It’s the connections, it’s the friendships. It’s the network of work, referrals, support, help and encouragement.&#8221;</p><cite>Dee Teal talking about the community that makes WordPress specialbenefits of the WordPress community</cite></blockquote>\n\n\n\n<figure class=\"wp-block-image size-large\"><img decoding=\"async\" loading=\"lazy\" width=\"1024\" height=\"576\" src=\"https://i1.wp.com/wordpress.org/news/files/2022/05/dee-wceu2019.png?resize=1024%2C576&#038;ssl=1\" alt=\"Dee Teal\'s talk at WordCamp Europe 2019 on \'Working a world apart\'\" class=\"wp-image-12958\" srcset=\"https://i1.wp.com/wordpress.org/news/files/2022/05/dee-wceu2019.png?resize=1024%2C576&amp;ssl=1 1024w, https://i1.wp.com/wordpress.org/news/files/2022/05/dee-wceu2019.png?resize=300%2C169&amp;ssl=1 300w, https://i1.wp.com/wordpress.org/news/files/2022/05/dee-wceu2019.png?resize=768%2C432&amp;ssl=1 768w, https://i1.wp.com/wordpress.org/news/files/2022/05/dee-wceu2019.png?resize=1536%2C864&amp;ssl=1 1536w, https://i1.wp.com/wordpress.org/news/files/2022/05/dee-wceu2019.png?w=1920&amp;ssl=1 1920w\" sizes=\"(max-width: 1000px) 100vw, 1000px\" data-recalc-dims=\"1\" /><figcaption><em>Dee shared her experience with attendees at WordCamp Europe 2019</em></figcaption></figure>\n\n\n\n<p>In contributing to WordPress and organizing community events around it, Dee found that for her: “At the end of the day it isn’t actually WordPress that matters. It’s those connections, it’s the friendships. It’s the network of work, referrals, support, help, encouragement that has kept me wired into this community and committed to helping other people find that connection and growth for themselves.”</p>\n\n\n\n<p>Dee’s career in WordPress has moved through coding, into project management of large scale WordPress projects, and now into delivery leadership. Her connections to community have helped &#8216;fuel the transitions&#8217; through these chapters of her life.</p>\n\n\n\n<p>She said: “I believe that the place I’ve found and the opportunities I have had owe as much to my own desire and ambition as they do to the help, support and belief of the community around me; sometimes even more than I’ve felt in myself.”</p>\n\n\n\n<p>She feels that she is ‘living proof’ that by helping, connecting, and resourcing other people, you can be helped, resourced and connected into places you had never thought possible.</p>\n\n\n\n<p>This has enabled her to reach and have a career in technology that she did not know existed as a teenager playing with that first computer mouse and experimenting with code. Dee hopes her story will inspire others in their journey.</p>\n\n\n\n<h2 id=\"share-the-stories\">Share the stories</h2>\n\n\n\n<p>Help share these stories of open source contributors and continue to grow the community. Meet more WordPressers in the <a href=\"https://wordpress.org/news/category/newsletter/interviews/\">People of WordPress series</a>.</p>\n\n\n\n<h2>Contributors</h2>\n\n\n\n<p>Thanks to Abha Thakor (<a href=\'https://profiles.wordpress.org/webcommsat/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>webcommsat</a>), Meher Bala (<a href=\'https://profiles.wordpress.org/meher/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>meher</a>), Mary Baum (<a href=\'https://profiles.wordpress.org/marybaum/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>marybaum</a>), Chloe Bringmann (<a href=\'https://profiles.wordpress.org/cbringmann/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>cbringmann</a>), Nalini Thakor (<a href=\'https://profiles.wordpress.org/nalininonstopnewsuk/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>nalininonstopnewsuk</a>), and Larissa Murillo (<a href=\'https://profiles.wordpress.org/lmurillom/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>lmurillom</a>) for work on this feature. Thank you to Josepha Haden (<a href=\'https://profiles.wordpress.org/chanthaboune/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>chanthaboune</a>) and Topher DeRosia (<a href=\'https://profiles.wordpress.org/topher1kenobe/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>topher1kenobe</a>) for support of the series. Thank you too to <a href=\'https://profiles.wordpress.org/thewebprincess/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>thewebprincess</a> for sharing her experiences.</p>\n\n\n\n<p>This article is inspired by an article originally published on HeroPress.com, a community initiative created by Topher DeRosia. It highlights people in the WordPress community who have overcome barriers and whose stories would otherwise go unheard.<br>Meet more WordPress community members in our People of WordPress series.</p>\n\n\n\n<div class=\"wp-block-media-text is-stacked-on-mobile is-vertically-aligned-center\" style=\"grid-template-columns:29% auto\"><figure class=\"wp-block-media-text__media\"><img decoding=\"async\" loading=\"lazy\" width=\"180\" height=\"135\" src=\"https://i1.wp.com/wordpress.org/news/files/2020/03/heropress_logo_180.png?resize=180%2C135&#038;ssl=1\" alt=\"HeroPress logo\" class=\"wp-image-8409 size-full\" data-recalc-dims=\"1\" /></figure><div class=\"wp-block-media-text__content\">\n<p class=\"has-small-font-size\"><em>This People of WordPress feature is inspired by an essay originally published on </em><a href=\"https://heropress.com/\"><em>HeroPress.com</em></a><em>, a community initiative created by Topher DeRosia. It highlights people in the WordPress community who have overcome barriers and whose stories might otherwise go unheard. </em>#HeroPress </p>\n</div></div>\n\n\n\n<p></p>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:30:\"com-wordpress:feed-additions:1\";a:1:{s:7:\"post-id\";a:1:{i:0;a:5:{s:4:\"data\";s:5:\"12946\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:3;a:6:{s:4:\"data\";s:61:\"\n		\n		\n		\n		\n		\n				\n		\n		\n\n					\n										\n					\n		\n		\n\n			\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:4:{s:0:\"\";a:7:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:52:\"WP Briefing: Episode 32: An Open Source Reading List\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:74:\"https://wordpress.org/news/2022/05/episode-32-an-open-source-reading-list/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Mon, 30 May 2022 17:00:00 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:2:{i:0;a:5:{s:4:\"data\";s:7:\"Podcast\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:1;a:5:{s:4:\"data\";s:11:\"wp-briefing\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:53:\"https://wordpress.org/news/?post_type=podcast&p=12940\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:448:\"In the thirty-second episode of the WordPress Briefing, WordPress Executive Director Josepha Haden Chomphosy shares her open source reading list for that post-WordCamp Europe downtime. Have a question you&#8217;d like answered? You can submit them to wpbriefing@wordpress.org, either written or as a voice recording. Credits Editor:&#160;Dustin Hartzler Logo:&#160;Beatriz Fialho Production:&#160;Santana Inniss and Chloé Bringmann Song: [&#8230;]\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:9:\"enclosure\";a:1:{i:0;a:5:{s:4:\"data\";s:0:\"\";s:7:\"attribs\";a:1:{s:0:\"\";a:3:{s:3:\"url\";s:60:\"https://wordpress.org/news/files/2022/05/WP-Briefing-032.mp3\";s:6:\"length\";s:1:\"0\";s:4:\"type\";s:0:\"\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:14:\"Santana Inniss\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:11975:\"\n<p>In the thirty-second episode of the WordPress Briefing, WordPress Executive Director Josepha Haden Chomphosy shares her open source reading list for that post-WordCamp Europe downtime. <br></p>\n\n\n\n<p><em><strong>Have a question you&#8217;d like answered? You can submit them to <a href=\"mailto:wpbriefing@wordpress.org\">wpbriefing@wordpress.org</a>, either written or as a voice recording.</strong></em></p>\n\n\n\n<h2 id=\"credits\">Credits</h2>\n\n\n\n<ul><li>Editor:&nbsp;<a href=\"https://profiles.wordpress.org/dustinhartzler/\">Dustin Hartzler</a></li><li>Logo:&nbsp;<a href=\"https://profiles.wordpress.org/beafialho/\">Beatriz Fialho</a></li><li>Production:&nbsp;<a href=\"https://profiles.wordpress.org/santanainniss/\">Santana Inniss</a> and <a href=\"https://profiles.wordpress.org/cbringmann/\">Chloé Bringmann</a></li><li>Song: Fearless First by Kevin MacLeod</li></ul>\n\n\n\n<h2>References</h2>\n\n\n\n<ul><li><a href=\"https://producingoss.com/en/index.html\">Producing Open Source Software</a>, Karl Fogel</li><li><a href=\"https://www.amazon.com/dp/B08BDGXVK9/ref=dp-kindle-redirect?_encoding=UTF8&amp;btkr=1\">Working in Public: The Making and Maintenance of Open Source Software</a>, Nadia Eghbal</li><li><a href=\"https://www.amazon.com/CODE-Collaborative-Ownership-Digital-Leonardo/dp/0262572362\">Collaborative Ownership and the Digital Economy</a>, ed Rishab Aiyer Ghosh, Roger F. Malina PhD, Sean Cubitt</li><li><a href=\"https://www.amazon.com/Humble-Inquiry-Second-Relationships-Organizations/dp/B08VCRL6WQ/ref=sr_1_1?crid=39U1NLFRD52VO&amp;keywords=Humble+Inquiry&amp;qid=1653587884&amp;s=books&amp;sprefix=humble+inquiry%2Cstripbooks%2C63&amp;sr=1-1\">Humble Inquiry</a>, Edgar H. Schein (Author), Peter A. Schein</li><li><a href=\"https://github.com/WordPress/book/\">WordPress Milestones</a></li><li><a href=\"https://europe.wordcamp.org/2022/\">WordCamp Europe 2022</a></li><li><a href=\"https://wp.me/p2U65r-9f3\">2022 Annual Meetup Survey</a></li></ul>\n\n\n\n<h2>Transcript</h2>\n\n\n\n<span id=\"more-12940\"></span>\n\n\n\n<p><strong>[Josepha Haden Chomphosy 00:00:00]&nbsp;</strong></p>\n\n\n\n<p>Hello everyone. And welcome to the WordPress Briefing. The podcast where you can catch quick explanations of some of the ideas behind the WordPress open source project and the community around it. As well as get a small list of big things coming up in the next two weeks. I&#8217;m your host Josepha Haden Chomphosy. Here we go!</p>\n\n\n\n<p><strong>[Josepha Haden Chomphosy 00:00:40]&nbsp;</strong></p>\n\n\n\n<p>With the approach of various mid-year breaks and the prospect of wandering off for some safe, restorative travel, I&#8217;ve been updating my to-read and re-read list. As I was looking at the queued books for my Northern hemisphere summer, there were some common threads, mostly around leadership, but there&#8217;s also like a chunk that&#8217;s about cross-cultural group theory and economics, and then like some beach reads, but there&#8217;s one group in particular that you all might find interesting.</p>\n\n\n\n<p>And that&#8217;s a group that&#8217;s sort of like a back-to-FOSS basics list. So I&#8217;ll share my top few with you in case you want to pack a copy for your next getaway.&nbsp;</p>\n\n\n\n<p>The first one on our list is called Producing Open Source Software by Karl Fogel. I think everyone who contributes to FOSS projects has received this as one of their first recommendations. Like, y&#8217;all are building open software? Excellent, you need to read Producing Open Source Software. Like, that is just a sentence that comes out of everyone&#8217;s mouths. So this was one of the first open source books that was recommended to me when I joined the WordPress community. It was freshly revised in 2020, and I haven&#8217;t given it a read since then, which is why it is on my reread list this year.</p>\n\n\n\n<p><strong>[Josepha Haden Chomphosy 00:01:54]</strong></p>\n\n\n\n<p>However, it shaped the early days of the WordPress project’s leadership, and their lead developers, and some of WordPress&#8217;s basic philosophies. It&#8217;s all available online, under a creative commons, ShareAlike license. And so it&#8217;s worth the read. I&#8217;ll put a link to it in the show notes so it&#8217;s easy for everyone to find in the event that is your preferred beach read.</p>\n\n\n\n<p>The second one on this list is a book from Nadia Eghbal. She wrote the excellent Roads and Bridges report that also is probably not light beach reading, but you know, this one is on my list to read this summer because Eghbal always delivers truths about the reality of maintaining popular software, popular, open source software, in a way that&#8217;s easy for me to access and process rather than getting paralyzed by the enormity of it all.</p>\n\n\n\n<p>For what it&#8217;s worth your mileage may vary on that. I realized that, like, I live and breathe open source stuff. And so just because I am not paralyzed by the enormity of her explanations of things doesn&#8217;t necessarily mean that you will have a similar experience. And so I&#8217;m just going to claim that elephant in the room for all of us.</p>\n\n\n\n<p>However, if you only read one book on this list this year, I think that this should be the one that you read.</p>\n\n\n\n<p><strong>[Josepha Haden Chomphosy 00:03:14]</strong></p>\n\n\n\n<p>The third one is called Code: Collaborative Ownership and the Digital Economy. It was edited by Rishab Aiyer Ghosh. I am certain that I butchered that name. And so I apologize on my own behalf to everyone that knows whether or not I said it correctly.</p>\n\n\n\n<p>This book focuses on intellectual property rights and the original purpose of having anything like copyright in the world. So, right up my alley! The writers who contributed to this work promise exploration of the plight of creativity in the commons, the role of sharing in creative advancement, and a concept of what it would look like if intellectual property were to mean the second closing of an ecosystem versus a triumph of the commons.</p>\n\n\n\n<p>I mean, obviously, this one is very light reading. You can take this topic to high tea and everyone will not know what you&#8217;re talking about. However, this one looks like a really interesting book to me and I am just super ready to read it.&nbsp;</p>\n\n\n\n<p><strong>[Josepha Haden Chomphosy 00:04:19]</strong></p>\n\n\n\n<p>The second to last one on the list is a book called Humble Inquiry.</p>\n\n\n\n<p>This is a new-to-me book that seems right in line with one of my favorite books to recommend to leaders in the open source space. From reviews of it, I have gathered that it takes a hard look at the value of listening and asking for clarification in a world that puts a high value on an unsolicited hot take.</p>\n\n\n\n<p>It puts the importance of high trust relationship building, which is at the heart of any cross-culturally aware organization. And for folks who&#8217;ve been working with me for a while, you know, that relationship building is an important part of my leadership expectations for myself. So it puts relationship building at the front and center with a promise of practical applications for everyday life.</p>\n\n\n\n<p>And if you ever have tried to tackle a complicated topic like this, you know that practical applications are really hard to come by and it&#8217;s often hard to understand it if you don&#8217;t have those practical applications. And so that is why this one is on my read and reread list this year.&nbsp;</p>\n\n\n\n<p><strong>[Josepha Haden Chomphosy 00:05:24]</strong></p>\n\n\n\n<p>And then finally the WordPress Milestones book.</p>\n\n\n\n<p>So this sounds like a shameless plug for WordPress. And on the one hand, this whole podcast is about WordPress. And so, yes! But on the other hand, I actually am reading this for two specific reasons. I&#8217;m rereading this actually. I read it when I first joined Automattic. And so the first of the two reasons that I&#8217;m rereading it this year is that volume two of this is, like the second decade of WordPress currently, being researched and written in preparation for WordPress’s 20th birthday next year.&nbsp;</p>\n\n\n\n<p>So I am rereading this to kind of get that all back in my mind as that work is getting done. And the second reason is that I honestly like to remind myself of how far we&#8217;ve come sometimes. I talk about our work frequently. And I talk about what we&#8217;re working on right now, all the time.</p>\n\n\n\n<p>I talk about what we&#8217;re looking at three years from now, five years from now. The biggest concerns of today, tomorrow, and the future-future. And it&#8217;s very easy to forget how much success WordPress has had and how much growth the contributors that support us have had over the course of our long and storied history.</p>\n\n\n\n<p><strong>[Josepha Haden Chomphosy 00:06:40]</strong></p>\n\n\n\n<p>And so I like to go back to that just to kind of give myself some grounding in our progress, as well as get some concept for how we can move forward together. So that one is also available online. Also under a creative commons ShareAlike license and it is also worth the read. I will share a link to that with the other one in the show notes as well.</p>\n\n\n\n<p>That brings us now to our small list of big things. Let&#8217;s see what we got in the old lineup today.&nbsp;</p>\n\n\n\n<p>So, firstly WordCamp Europe is happening this week and it&#8217;s possible to watch the live stream from the comfort of your own home. There are some smart and talented speakers at the event. So I encourage you to catch a few if you have the time. I&#8217;ll include a link to the live stream information in the show notes below, and then also you can always keep an eye out on Twitter.&nbsp;</p>\n\n\n\n<p>There will be a lot of discussions, a lot of conversation there. And so you can engage with folks that are there at the time and catch up on those conversations, catch up on those presentations in your own time, as it fits into your day.</p>\n\n\n\n<p><strong>[Josepha Haden Chomphosy 00:07:50]</strong></p>\n\n\n\n<p>The second thing is that WordPress’s community team is preparing the annual meetup survey right now. So if you participate in meetup events, keep an eye out for that because your feedback helps us to make plans to improve that program so that it works better for you. And it helps you to learn WordPress better and feel more confident with what you are taking out into the world that way.</p>\n\n\n\n<p>But, if you are wanting to use this as a chance to contribute, we actually will need folks who are able to translate the surveys as well. So I&#8217;ll leave a link to some information about that in the show notes. If all of that stuff about contribution didn&#8217;t make any sense, then just like keep an eye out from your meetup organizer and they will make sure that you have that survey so that you can have your voice heard.&nbsp;</p>\n\n\n\n<p><strong>[Josepha Haden Chomphosy 00:08:33]</strong></p>\n\n\n\n<p>And then item three is less of an item. I mean, it&#8217;s an item cause it&#8217;s in this list, but it&#8217;s less of, like, a thing to know and more of a general thing to be aware of. It&#8217;s a general awareness item. There&#8217;s a lot going on in WordPress right now. I can see how hard it is to keep track of some of these things these days.</p>\n\n\n\n<p>And I know as someone who&#8217;s looking at this all day every day that, yeah, it&#8217;s a lot. And it&#8217;s hard to get your bearings. So if you have a team that you contribute to already, don&#8217;t forget to reach out to each other, just to check-in. Sometimes we don&#8217;t think to ask for help. Sometimes we don&#8217;t think to offer help and you know, if no one needs any help from you at that moment, a little hello also can brighten someone&#8217;s day.</p>\n\n\n\n<p>And that, my friends, is your smallest of big things. Thank you for tuning in today for the WordPress Briefing. I&#8217;m your host, Josepha Haden Chomphosy. And I&#8217;ll see you again in a couple of weeks.</p>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:30:\"com-wordpress:feed-additions:1\";a:1:{s:7:\"post-id\";a:1:{i:0;a:5:{s:4:\"data\";s:5:\"12940\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:4;a:6:{s:4:\"data\";s:63:\"\n		\n		\n		\n		\n		\n				\n		\n		\n		\n\n					\n										\n					\n		\n		\n			\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:4:{s:0:\"\";a:6:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:26:\"WordPress 6.0 “Arturo”\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:42:\"https://wordpress.org/news/2022/05/arturo/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Tue, 24 May 2022 20:01:05 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:3:{i:0;a:5:{s:4:\"data\";s:8:\"Releases\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:1;a:5:{s:4:\"data\";s:3:\"6.0\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:2;a:5:{s:4:\"data\";s:8:\"releases\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:35:\"https://wordpress.org/news/?p=12879\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:278:\"Say hello to “Arturo” and WordPress 6.0, inspired by Grammy-winning jazz musician, Arturo O’Farrill. With nearly 1,000 enhancements and bug fixes, the second major release of 2022 is here. Download it now! As of today, WordPress powers more than 42% of websites worldwide.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:14:\"Matt Mullenweg\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:56990:\"\n<figure class=\"wp-block-image size-full\"><img decoding=\"async\" loading=\"lazy\" width=\"4161\" height=\"2822\" src=\"https://i2.wp.com/wordpress.org/news/files/2022/05/Main-image-News-post.png?fit=4161%2C2822&amp;ssl=1\" alt=\"WordPress 6.0 Arturo\" class=\"wp-image-12919\" srcset=\"https://i2.wp.com/wordpress.org/news/files/2022/05/Main-image-News-post.png?w=4161&amp;ssl=1 4161w, https://i2.wp.com/wordpress.org/news/files/2022/05/Main-image-News-post.png?resize=300%2C203&amp;ssl=1 300w, https://i2.wp.com/wordpress.org/news/files/2022/05/Main-image-News-post.png?resize=1024%2C694&amp;ssl=1 1024w, https://i2.wp.com/wordpress.org/news/files/2022/05/Main-image-News-post.png?resize=768%2C521&amp;ssl=1 768w, https://i2.wp.com/wordpress.org/news/files/2022/05/Main-image-News-post.png?resize=1536%2C1042&amp;ssl=1 1536w, https://i2.wp.com/wordpress.org/news/files/2022/05/Main-image-News-post.png?resize=2048%2C1389&amp;ssl=1 2048w, https://i2.wp.com/wordpress.org/news/files/2022/05/Main-image-News-post.png?w=3000&amp;ssl=1 3000w\" sizes=\"(max-width: 1000px) 100vw, 1000px\" /></figure>\n\n\n\n<h2>Welcome to &#8220;Arturo&#8221;</h2>\n\n\n\n<p>Say hello to “Arturo” and WordPress 6.0, inspired by Grammy-winning jazz musician, <a href=\"https://en.wikipedia.org/wiki/Arturo_O\'Farrill\">Arturo O’Farrill</a>. Known for his influence on contemporary Latin jazz, Arturo has pressed more than 15 albums spanning a body of work across five decades.&nbsp;</p>\n\n\n\n<p>Take some time to explore WordPress 6.0, built to help you unlock your creative aspirations and make your site-building experience more intuitive. And check out some of Arturo’s inspirational sounds that span Afro Cuban jazz, contemporary Latin jazz, and so much more.</p>\n\n\n\n<p>With nearly 1,000 enhancements and bug fixes, the second major release of 2022 is here. <a href=\"https://wordpress.org/wordpress-6.0.zip\">Download it now</a>! As of today, WordPress powers more than 42% of websites worldwide.<sup><a href=\"#footnote\">1</a></sup></p>\n\n\n\n<p>Site owners and administrators should upgrade to take full advantage of the many stability, performance, and usability enhancements today. WordPress content creators will enjoy a suite of new features geared toward improving the writing and designing experiences.</p>\n\n\n\n<blockquote class=\"wp-block-quote\"><p>Expanding Gutenberg into a full site editing experience in WordPress means that all of the problems the community had to address were complex and far-reaching. WordPress 6.0 is an example of the community’s commitment to tackling these tough challenges together. With thoughtful updates to the writing experience, building better block functionality, and adding a new intuitive style switcher, I’m really proud of the work that’s been done in this release to make a great site editing experience.</p><cite>Josepha Haden Chomphosy, Executive Director</cite></blockquote>\n\n\n\n<div class=\"wp-container-7 wp-block-buttons\">\n<div class=\"wp-block-button\"><a class=\"wp-block-button__link\" href=\"https://wordpress.org/wordpress-6.0.zip\">Download WordPress 6.0</a></div>\n</div>\n\n\n\n<h2>What’s Inside</h2>\n\n\n\n<figure class=\"wp-block-image size-full\"><img decoding=\"async\" loading=\"lazy\" width=\"1204\" height=\"700\" src=\"https://i2.wp.com/wordpress.org/news/files/2022/05/Writing-Improvements-1.png?fit=1204%2C700&amp;ssl=1\" alt=\"Selecting multiple lines of text from two blocks\" class=\"wp-image-12887\" srcset=\"https://i2.wp.com/wordpress.org/news/files/2022/05/Writing-Improvements-1.png?w=1204&amp;ssl=1 1204w, https://i2.wp.com/wordpress.org/news/files/2022/05/Writing-Improvements-1.png?resize=300%2C174&amp;ssl=1 300w, https://i2.wp.com/wordpress.org/news/files/2022/05/Writing-Improvements-1.png?resize=1024%2C595&amp;ssl=1 1024w, https://i2.wp.com/wordpress.org/news/files/2022/05/Writing-Improvements-1.png?resize=768%2C447&amp;ssl=1 768w\" sizes=\"(max-width: 1000px) 100vw, 1000px\" /></figure>\n\n\n\n<h3>Enhanced Writing Experience</h3>\n\n\n\n<p>Writing improvements abound, whether you’re writing a brand new post or adding elements to an existing page. Explore more ways to streamline your content creation process, including:</p>\n\n\n\n<ul><li>Select text across multiple blocks for easier copying and pasting.</li><li>Type two open brackets `<code>[[</code>` to quickly access a list of recent posts and pages.</li><li>Keep existing styles when you transform some blocks from one kind to another—from a Paragraph block to a Code block, for instance.</li><li>Create customized buttons and any new buttons you make will retain the style customizations automatically.</li><li>Make tag clouds and social icons even more appealing with updated settings and controls, and a new outline style for the tag cloud.</li></ul>\n\n\n\n<figure class=\"wp-block-image size-full\"><img decoding=\"async\" loading=\"lazy\" width=\"1204\" height=\"700\" src=\"https://i0.wp.com/wordpress.org/news/files/2022/05/Style-switcher-big.gif?fit=1204%2C700&amp;ssl=1\" alt=\"Style variations of Twenty Twenty Two theme\" class=\"wp-image-12893\" /></figure>\n\n\n\n<h3>Style Switching&nbsp;</h3>\n\n\n\n<p>Block themes now include the option to contain multiple style variations. This expands the new Style system even further and enables shortcuts to switch the look and feel of your site all within a single theme. In block themes that support this feature, you can change both the available settings, like the font-weight, and the style options, like the default color palette. Change the look and feel of your site with just a few clicks.</p>\n\n\n\n<figure class=\"wp-block-image size-full\"><img decoding=\"async\" loading=\"lazy\" width=\"1204\" height=\"700\" src=\"https://i2.wp.com/wordpress.org/news/files/2022/05/Expanded-templates.png?fit=1204%2C700&amp;ssl=1\" alt=\"Popover listing available templates\" class=\"wp-image-12889\" srcset=\"https://i2.wp.com/wordpress.org/news/files/2022/05/Expanded-templates.png?w=1204&amp;ssl=1 1204w, https://i2.wp.com/wordpress.org/news/files/2022/05/Expanded-templates.png?resize=300%2C174&amp;ssl=1 300w, https://i2.wp.com/wordpress.org/news/files/2022/05/Expanded-templates.png?resize=1024%2C595&amp;ssl=1 1024w, https://i2.wp.com/wordpress.org/news/files/2022/05/Expanded-templates.png?resize=768%2C447&amp;ssl=1 768w\" sizes=\"(max-width: 1000px) 100vw, 1000px\" /></figure>\n\n\n\n<h3>More Template Choices</h3>\n\n\n\n<p>WordPress 6.0 includes five new template options for block themes: author, date, categories, tag, and taxonomy. These additional templates provide greater flexibility for content creators. Tailor each with the tools you already know or with the following new options in this release:&nbsp;</p>\n\n\n\n<ul><li>Featured images can be used in the cover block.</li><li>New featured image sizing controls make it easier to get the results you want.</li><li>While editing a template, at the root, or between blocks, the quick inserter shows you patterns and template parts to help you work faster and discover new layout options.</li><li>The query block supports filtering on multiple authors, support for custom taxonomies, and support for customizing what is shown when there are no results.</li></ul>\n\n\n\n<figure class=\"wp-block-image size-full\"><img decoding=\"async\" loading=\"lazy\" width=\"1204\" height=\"700\" src=\"https://i1.wp.com/wordpress.org/news/files/2022/05/Integrated-Patterns.png?fit=1204%2C700&amp;ssl=1\" alt=\"Browsing footer patterns in the quick inserter\" class=\"wp-image-12890\" srcset=\"https://i1.wp.com/wordpress.org/news/files/2022/05/Integrated-Patterns.png?w=1204&amp;ssl=1 1204w, https://i1.wp.com/wordpress.org/news/files/2022/05/Integrated-Patterns.png?resize=300%2C174&amp;ssl=1 300w, https://i1.wp.com/wordpress.org/news/files/2022/05/Integrated-Patterns.png?resize=1024%2C595&amp;ssl=1 1024w, https://i1.wp.com/wordpress.org/news/files/2022/05/Integrated-Patterns.png?resize=768%2C447&amp;ssl=1 768w\" sizes=\"(max-width: 1000px) 100vw, 1000px\" /></figure>\n\n\n\n<h3>Integrated Patterns</h3>\n\n\n\n<p>Patterns will now appear when you need them in even more places, like in the quick inserter or when creating a new header or footer. If you’re a block theme author, you can even <a href=\"https://developer.wordpress.org/block-editor/reference-guides/block-api/block-patterns/\">register patterns from the Pattern Directory using `<code>theme.json</code>`</a>, enabling you to prioritize specific patterns that are most helpful to your theme’s users.</p>\n\n\n\n<h3>Additional Design Tools</h3>\n\n\n\n<p>Design tools grow more powerful and intuitive with each release. Some highlights for 6.0 include:&nbsp;</p>\n\n\n\n<ul><li>A new color panel design saves space, but still shows your options at a glance.&nbsp;</li><li>New border controls offer a simpler way to set your border exactly as you like it.&nbsp;</li><li>Transparency levels for your colors allow for even more creative color options.</li><li>Control gaps, margins, typography, and more on a collection of blocks, all at once, in the Group block.</li><li>Switch between stack, row, and group variations to position groups of blocks with more layout flexibility.</li><li>Use the gap support functionality in the Gallery block to create different looks – from adding spacing between all images, to removing spacing altogether.</li></ul>\n\n\n\n<figure class=\"wp-block-image size-full\"><img decoding=\"async\" loading=\"lazy\" width=\"1204\" height=\"700\" src=\"https://i0.wp.com/wordpress.org/news/files/2022/05/List-view.png?fit=1204%2C700&amp;ssl=1\" alt=\"Selecting multiple blocks in the list view\" class=\"wp-image-12891\" srcset=\"https://i0.wp.com/wordpress.org/news/files/2022/05/List-view.png?w=1204&amp;ssl=1 1204w, https://i0.wp.com/wordpress.org/news/files/2022/05/List-view.png?resize=300%2C174&amp;ssl=1 300w, https://i0.wp.com/wordpress.org/news/files/2022/05/List-view.png?resize=1024%2C595&amp;ssl=1 1024w, https://i0.wp.com/wordpress.org/news/files/2022/05/List-view.png?resize=768%2C447&amp;ssl=1 768w\" sizes=\"(max-width: 1000px) 100vw, 1000px\" /></figure>\n\n\n\n<h3>Better List View</h3>\n\n\n\n<p>New keyboard shortcuts enable you to select multiple blocks from the list view, modify them in bulk, and drag and drop them within the list. List View can be opened and closed easily; it comes collapsed by default and it automatically expands to the current selection whenever you select a block.&nbsp;</p>\n\n\n\n<figure class=\"wp-block-image size-full\"><img decoding=\"async\" loading=\"lazy\" width=\"1204\" height=\"700\" src=\"https://i1.wp.com/wordpress.org/news/files/2022/05/Block-Locking-Controls.png?fit=1204%2C700&amp;ssl=1\" alt=\"Unlocking the block in the block toolbar\" class=\"wp-image-12892\" srcset=\"https://i1.wp.com/wordpress.org/news/files/2022/05/Block-Locking-Controls.png?w=1204&amp;ssl=1 1204w, https://i1.wp.com/wordpress.org/news/files/2022/05/Block-Locking-Controls.png?resize=300%2C174&amp;ssl=1 300w, https://i1.wp.com/wordpress.org/news/files/2022/05/Block-Locking-Controls.png?resize=1024%2C595&amp;ssl=1 1024w, https://i1.wp.com/wordpress.org/news/files/2022/05/Block-Locking-Controls.png?resize=768%2C447&amp;ssl=1 768w\" sizes=\"(max-width: 1000px) 100vw, 1000px\" /></figure>\n\n\n\n<h3>Block Locking Controls</h3>\n\n\n\n<p>Now you can lock your blocks. Choose to disable the option to move a block, remove a block, or both. This simplifies project handover, allowing your clients to unleash their creativity without worrying about accidentally breaking their site in the process.</p>\n\n\n\n<h2>Improved Performance in WordPress 6.0</h2>\n\n\n\n<p>This release includes several updates focused on improving the performance of WordPress. These enhancements cover a range of performance areas including improving the page and post-load speed, reducing the execution time of various query types, caching, navigation menus, and much more. The performance team working group is an important focus area of the core development team. For more information on this group’s work, please follow their work on Making WordPress with the <a href=\"https://make.wordpress.org/core/tag/performance/\">#performance hashtag</a>.</p>\n\n\n\n<h2>Enhancing WordPress 6.0 Accessibility</h2>\n\n\n\n<p>Accessibility is an integral part of the WordPress mission of fostering an inclusive community and supporting users of all types around the world. With this in mind, WordPress 6.0 includes more than 50 updates specifically focused on enhancing the accessibility of the platform. You can <a href=\"https://make.wordpress.org/core/2022/04/20/wordpress-6-0-accessibility-improvements/\">read about these updates</a> and learn more about the accessibility initiatives that are ongoing.</p>\n\n\n\n<h2>Learn More About WordPress 6.0</h2>\n\n\n\n<p>See WordPress 6.0 in action! <a href=\"https://www.youtube.com/watch?v=oe452WcY7fA\">Watch a brief overview video</a> highlighting some of the major features debuting in WordPress 6.0.</p>\n\n\n\n<figure class=\"wp-block-embed is-type-video is-provider-youtube wp-block-embed-youtube wp-embed-aspect-16-9 wp-has-aspect-ratio\"><div class=\"wp-block-embed__wrapper\">\n<iframe loading=\"lazy\" class=\"youtube-player\" width=\"600\" height=\"338\" src=\"https://www.youtube.com/embed/oe452WcY7fA?version=3&#038;rel=1&#038;showsearch=0&#038;showinfo=1&#038;iv_load_policy=1&#038;fs=1&#038;hl=en-US&#038;autohide=2&#038;wmode=transparent\" allowfullscreen=\"true\" style=\"border:0;\" sandbox=\"allow-scripts allow-same-origin allow-popups allow-presentation\"></iframe>\n</div></figure>\n\n\n\n<p>Explore <a href=\"https://learn.wordpress.org/\">learn.wordpress.org</a> for quick how-to videos and lots more on new features in WordPress. Or join a live <a href=\"https://learn.wordpress.org/social-learning/\">interactive online learning session</a> on a specific WordPress topic.</p>\n\n\n\n<p>Developers can explore the <a href=\"https://make.wordpress.org/core/2022/05/03/wordpress-6-0-field-guide/\">WordPress 6.0 Field Guide</a>. It is overflowing with detailed developer notes to help you build with and extend WordPress.</p>\n\n\n\n<p>Read the <a href=\"https://wordpress.org/support/wordpress-version/version-6-0/\">WordPress 6.0 Release Notes</a> for more information on the included enhancements and issues fixed, installation information, developer notes and resources, release contributors, and the list of file changes in this release.</p>\n\n\n\n<h2>The WordPress 6.0 Release Squad</h2>\n\n\n\n<p>The group listed below tirelessly supported the release, from conception to ship date, and beyond:</p>\n\n\n\n<ul><li>Release Lead: <a href=\"https://profiles.wordpress.org/matt/\">Matt Mullenweg</a>&nbsp;</li><li>Release Coordinators: <a href=\"https://profiles.wordpress.org/priethor/\">Héctor Prieto</a> and <a href=\"https://profiles.wordpress.org/annezazu/\">Anne McCarthy</a></li><li>Core Tech Lead: <a href=\"https://profiles.wordpress.org/peterwilsoncc/\">Peter Wilson</a></li><li>Editor Tech Leads: <a href=\"https://profiles.wordpress.org/zieladam/\">Adam Zieliński</a> and <a href=\"https://profiles.wordpress.org/gziolo/\">Greg Ziółkowski</a></li><li>Core Triage Leads: <a href=\"https://profiles.wordpress.org/chaion07/\">Ahmed Chaion</a> and <a href=\"https://profiles.wordpress.org/costdev/\">Colin Stewart</a></li><li>Editor Triage Lead: <a href=\"https://profiles.wordpress.org/ndiego/\">Nick Diego</a></li><li>Documentation Leads: <a href=\"https://profiles.wordpress.org/bph/\">Birgit Pauli-Haack</a>, <a href=\"https://profiles.wordpress.org/milana_cap/\">Milana Cap</a>, and <a href=\"https://profiles.wordpress.org/webcommsat/\">Abha Thakor</a></li><li>Marketing &amp; Communications Lead: <a href=\"https://profiles.wordpress.org/dansoschin/\">Dan Soschin</a></li><li>Test Leads: <a href=\"https://profiles.wordpress.org/boniu91/\">Piotrek Boniu</a> and <a href=\"https://profiles.wordpress.org/ironprogrammer/\">Brian Alexander</a></li><li>Design Lead: <a href=\"https://profiles.wordpress.org/critterverse/\">Channing Ritter</a></li></ul>\n\n\n\n<h2>Thank you to 500+ Contributors</h2>\n\n\n\n<p>WordPress 6.0 would not have been possible without the contributions of more than 500 people in at least 58 countries. Their asynchronous coordination to deliver hundreds of enhancements and fixes into a stable release is a testament to the power and capability of the WordPress community.</p>\n\n\n<p class=\"is-style-wporg-props-long alignfull\"><a href=\"https://profiles.wordpress.org/jorbin/\">Aaron Jorbin</a> · <a href=\"https://profiles.wordpress.org/aaronrobertshaw/\">Aaron Robertshaw</a> · <a href=\"https://profiles.wordpress.org/abdullahramzan/\">Abdullah Ramzan</a> · <a href=\"https://profiles.wordpress.org/webcommsat/\">Abha Thakor</a> · <a href=\"https://profiles.wordpress.org/adamsilverstein/\">Adam Silverstein</a> · <a href=\"https://profiles.wordpress.org/zieladam/\">Adam Zielinski</a> · <a href=\"https://profiles.wordpress.org/adi64bit/\">adi64bit</a> · <a href=\"https://profiles.wordpress.org/aadilali/\">Adil Ali</a> · <a href=\"https://profiles.wordpress.org/agepcom/\">agepcom</a> · <a href=\"https://profiles.wordpress.org/chaion07/\">Ahmed Chaion</a> · <a href=\"https://profiles.wordpress.org/wildworks/\">Aki Hamano</a> · <a href=\"https://profiles.wordpress.org/atachibana/\">Akira Tachibana</a> · <a href=\"https://profiles.wordpress.org/schlessera/\">Alain Schlesser</a> · <a href=\"https://profiles.wordpress.org/alanjacobmathew/\">Alan Jacob Mathew</a> · <a href=\"https://profiles.wordpress.org/alansyue/\">alansyue</a> · <a href=\"https://profiles.wordpress.org/aljullu/\">Albert Juh&#233; Lluveras</a> · <a href=\"https://profiles.wordpress.org/albertomake/\">albertomake</a> · <a href=\"https://profiles.wordpress.org/alefesouza/\">Alefe Souza</a> · <a href=\"https://profiles.wordpress.org/alex897/\">Aleksandar Kostov</a> · <a href=\"https://profiles.wordpress.org/xknown/\">Alex Concha</a> · <a href=\"https://profiles.wordpress.org/ajlende/\">Alex Lende</a> · <a href=\"https://profiles.wordpress.org/viper007bond/\">Alex Mills</a> · <a href=\"https://profiles.wordpress.org/alexstine/\">Alex Stine</a> · <a href=\"https://profiles.wordpress.org/aliakseyenkaihar/\">aliakseyenkaihar</a> · <a href=\"https://profiles.wordpress.org/alkesh7/\">Alkesh Miyani</a> · <a href=\"https://profiles.wordpress.org/alokstha1/\">Alok Shrestha</a> · <a href=\"https://profiles.wordpress.org/shedonist/\">Amanda Giles</a> · <a href=\"https://profiles.wordpress.org/afercia/\">Andrea Fercia</a> · <a href=\"https://profiles.wordpress.org/andraganescu/\">Andrei Draganescu</a> · <a href=\"https://profiles.wordpress.org/_smartik_/\">Andrei Surdu</a> · <a href=\"https://profiles.wordpress.org/aandrewdixon/\">Andrew Dixon</a> · <a href=\"https://profiles.wordpress.org/nacin/\">Andrew Nacin</a> · <a href=\"https://profiles.wordpress.org/azaozz/\">Andrew Ozz</a> · <a href=\"https://profiles.wordpress.org/andrewserong/\">Andrew Serong</a> · <a href=\"https://profiles.wordpress.org/rarst/\">Andrey \"Rarst\" Savchenko</a> · <a href=\"https://profiles.wordpress.org/oandregal/\">André</a> · <a href=\"https://profiles.wordpress.org/afragen/\">Andy Fragen</a> · <a href=\"https://profiles.wordpress.org/la-geek/\">Angelika Reisiger</a> · <a href=\"https://profiles.wordpress.org/rilwis/\">Anh Tran</a> · <a href=\"https://profiles.wordpress.org/ankit-k-gupta/\">Ankit K Gupta</a> · <a href=\"https://profiles.wordpress.org/annezazu/\">Anne McCarthy</a> · <a href=\"https://profiles.wordpress.org/anoopranawat/\">Anoop Ranawat</a> · <a href=\"https://profiles.wordpress.org/antpb/\">Anthony Burchell</a> · <a href=\"https://profiles.wordpress.org/paranoia1906/\">Anthony Ledesma</a> · <a href=\"https://profiles.wordpress.org/antonvlasenko/\">Anton Vlasenko</a> · <a href=\"https://profiles.wordpress.org/antonrinas/\">antonrinas</a> · <a href=\"https://profiles.wordpress.org/antonynz/\">Antony Booker</a> · <a href=\"https://profiles.wordpress.org/arcangelini/\">arcangelini</a> · <a href=\"https://profiles.wordpress.org/aristath/\">Ari Stathopoulos</a> · <a href=\"https://profiles.wordpress.org/arnee/\">Arne</a> · <a href=\"https://profiles.wordpress.org/arpitgshah/\">Arpit G Shah</a> · <a href=\"https://profiles.wordpress.org/artdecotech/\">artdecotech</a> · <a href=\"https://profiles.wordpress.org/madeinua/\">ArteMa</a> · <a href=\"https://profiles.wordpress.org/arthur791004/\">Arthur Chu</a> · <a href=\"https://profiles.wordpress.org/asaquzzaman/\">Asaquzzaman mishu</a> · <a href=\"https://profiles.wordpress.org/atomicjack/\">atomicjack</a> · <a href=\"https://profiles.wordpress.org/ajoah/\">Aur&#233;lien Joahny</a> · <a href=\"https://profiles.wordpress.org/aurooba/\">Aurooba Ahmed</a> · <a href=\"https://profiles.wordpress.org/barryhughes/\">Barry</a> · <a href=\"https://profiles.wordpress.org/barryceelen/\">Barry Ceelen</a> · <a href=\"https://profiles.wordpress.org/bartoszgadomski/\">Bartosz Gadomski</a> · <a href=\"https://profiles.wordpress.org/bedas/\">Beda</a> · <a href=\"https://profiles.wordpress.org/scruffian/\">Ben Dwyer</a> · <a href=\"https://profiles.wordpress.org/utz119/\">Benachi</a> · <a href=\"https://profiles.wordpress.org/bernhard-reiter/\">Bernie Reiter</a> · <a href=\"https://profiles.wordpress.org/bettyjj/\">BettyJJ</a> · <a href=\"https://profiles.wordpress.org/bhrugesh12/\">Bhrugesh Bavishi</a> · <a href=\"https://profiles.wordpress.org/binarymoon/\">binarymoon</a> · <a href=\"https://profiles.wordpress.org/birgire/\">Birgir Erlendsson (birgire)</a> · <a href=\"https://profiles.wordpress.org/bph/\">Birgit Pauli-Haack</a> · <a href=\"https://profiles.wordpress.org/supercleanse/\">Blair Williams</a> · <a href=\"https://profiles.wordpress.org/blogaid/\">BlogAid</a> · <a href=\"https://profiles.wordpress.org/boonebgorges/\">Boone Gorges</a> · <a href=\"https://profiles.wordpress.org/wpe_bdurette/\">Brandon DuRette</a> · <a href=\"https://profiles.wordpress.org/kraftbj/\">Brandon Kraft</a> · <a href=\"https://profiles.wordpress.org/ironprogrammer/\">Brian Alexander</a> · <a href=\"https://profiles.wordpress.org/bronsonquick/\">bronsonquick</a> · <a href=\"https://profiles.wordpress.org/brookemk/\">Brooke Kaminski</a> · <a href=\"https://profiles.wordpress.org/brookedot/\">Brooke.</a> · <a href=\"https://profiles.wordpress.org/ribaricplusplus/\">Bruno Ribaric</a> · <a href=\"https://profiles.wordpress.org/caraya/\">caraya</a> · <a href=\"https://profiles.wordpress.org/cbravobernal/\">Carlos Bravo</a> · <a href=\"https://profiles.wordpress.org/carlosgprim/\">Carlos Garcia</a> · <a href=\"https://profiles.wordpress.org/poena/\">Carolina Nymark</a> · <a href=\"https://profiles.wordpress.org/cbigler/\">cbigler</a> · <a href=\"https://profiles.wordpress.org/shireling/\">Chad Chadbourne</a> · <a href=\"https://profiles.wordpress.org/critterverse/\">Channing Ritter</a> · <a href=\"https://profiles.wordpress.org/charleyparkerdesign/\">charleyparkerdesign</a> · <a href=\"https://profiles.wordpress.org/charlyox/\">charlyox</a> · <a href=\"https://profiles.wordpress.org/chintan1896/\">Chintan hingrajiya</a> · <a href=\"https://profiles.wordpress.org/cbringmann/\">Chloe Bringmann</a> · <a href=\"https://profiles.wordpress.org/chouby/\">Chouby</a> · <a href=\"https://profiles.wordpress.org/clubkert/\">Chris Lubkert</a> · <a href=\"https://profiles.wordpress.org/chrisvanpatten/\">Chris Van Patten</a> · <a href=\"https://profiles.wordpress.org/chriscct7/\">chriscct7</a> · <a href=\"https://profiles.wordpress.org/clonemykey/\">clonemykey</a> · <a href=\"https://profiles.wordpress.org/costdev/\">Colin Stewart</a> · <a href=\"https://profiles.wordpress.org/conner_bw/\">conner_bw</a> · <a href=\"https://profiles.wordpress.org/cr0ybot/\">Cory Hughart</a> · <a href=\"https://profiles.wordpress.org/courane01/\">Courtney Robertson</a> · <a href=\"https://profiles.wordpress.org/mitogh/\">Crisoforo Gaspar</a> · <a href=\"https://profiles.wordpress.org/dansoschin/\">Dan Soschin</a> · <a href=\"https://profiles.wordpress.org/danielbachhuber/\">Daniel Bachhuber</a> · <a href=\"https://profiles.wordpress.org/talldanwp/\">Daniel Richards</a> · <a href=\"https://profiles.wordpress.org/danieldudzic/\">danieldudzic</a> · <a href=\"https://profiles.wordpress.org/darerodz/\">darerodz</a> · <a href=\"https://profiles.wordpress.org/htdat/\">Dat Hoang</a> · <a href=\"https://profiles.wordpress.org/get_dave/\">Dave Smith</a> · <a href=\"https://profiles.wordpress.org/davidbaumwald/\">David Baumwald</a> · <a href=\"https://profiles.wordpress.org/davidbinda/\">David Biňovec</a> · <a href=\"https://profiles.wordpress.org/dpcalhoun/\">David Calhoun</a> · <a href=\"https://profiles.wordpress.org/dgwyer/\">David Gwyer</a> · <a href=\"https://profiles.wordpress.org/dlh/\">David Herrera</a> · <a href=\"https://profiles.wordpress.org/dshanske/\">David Shanske</a> · <a href=\"https://profiles.wordpress.org/devutpol/\">Deb Nath Utpol</a> · <a href=\"https://profiles.wordpress.org/delowardev/\">Delowar Hossain</a> · <a href=\"https://profiles.wordpress.org/denishua/\">denishua</a> · <a href=\"https://profiles.wordpress.org/dennisatyoast/\">Dennis Claassen</a> · <a href=\"https://profiles.wordpress.org/dmsnell/\">Dennis Snell</a> · <a href=\"https://profiles.wordpress.org/dhanendran/\">Dhanendran</a> · <a href=\"https://profiles.wordpress.org/dharm1025/\">Dharmesh Patel</a> · <a href=\"https://profiles.wordpress.org/dhusakovic/\">dhusakovic</a> · <a href=\"https://profiles.wordpress.org/dilipbheda/\">Dilip Bheda</a> · <a href=\"https://profiles.wordpress.org/dd32/\">Dion Hulse</a> · <a href=\"https://profiles.wordpress.org/ocean90/\">Dominik Schilling</a> · <a href=\"https://profiles.wordpress.org/donmhico/\">donmhico</a> · <a href=\"https://profiles.wordpress.org/drago239/\">drago239</a> · <a href=\"https://profiles.wordpress.org/drewapicture/\">Drew Jaynes</a> · <a href=\"https://profiles.wordpress.org/dromero20/\">dromero20</a> · <a href=\"https://profiles.wordpress.org/eddystile/\">Eddy</a> · <a href=\"https://profiles.wordpress.org/ehtis/\">ehtis</a> · <a href=\"https://profiles.wordpress.org/eliezerspp/\">Eliezer Pe&#241;a</a> · <a href=\"https://profiles.wordpress.org/ellatrix/\">Ella van Durpe</a> · <a href=\"https://profiles.wordpress.org/manooweb/\">Emmanuel Hesry</a> · <a href=\"https://profiles.wordpress.org/lopo/\">Enrico Battocchi</a> · <a href=\"https://profiles.wordpress.org/eric3d/\">eric3d</a> · <a href=\"https://profiles.wordpress.org/kebbet/\">Erik Betshammar</a> · <a href=\"https://profiles.wordpress.org/espiat/\">espiat</a> · <a href=\"https://profiles.wordpress.org/estelaris/\">Estela Rueda</a> · <a href=\"https://profiles.wordpress.org/etaproducto/\">etaproducto</a> · <a href=\"https://profiles.wordpress.org/everpress/\">EverPress</a> · <a href=\"https://profiles.wordpress.org/fabiankaegy/\">Fabian K&#228;gy</a> · <a href=\"https://profiles.wordpress.org/iogui/\">Fabio Blanco</a> · <a href=\"https://profiles.wordpress.org/faison/\">Faison</a> · <a href=\"https://profiles.wordpress.org/felipeelia/\">Felipe Elia</a> · <a href=\"https://profiles.wordpress.org/flixos90/\">Felix Arntz</a> · <a href=\"https://profiles.wordpress.org/femkreations/\">Femy Praseeth</a> · <a href=\"https://profiles.wordpress.org/florianbrinkmann/\">Florian Brinkmann</a> · <a href=\"https://profiles.wordpress.org/mista-flo/\">Florian TIAR</a> · <a href=\"https://profiles.wordpress.org/foliovision/\">FolioVision</a> · <a href=\"https://profiles.wordpress.org/francina/\">Francesca Marano</a> · <a href=\"https://profiles.wordpress.org/fcoveram/\">Francisco Vera</a> · <a href=\"https://profiles.wordpress.org/frankei/\">frankei</a> · <a href=\"https://profiles.wordpress.org/furi3r/\">furi3r</a> · <a href=\"https://profiles.wordpress.org/gadhiyaravi/\">gadhiyaravi</a> · <a href=\"https://profiles.wordpress.org/garrett-eclipse/\">Garrett Hyder</a> · <a href=\"https://profiles.wordpress.org/voldemortensen/\">Garth Mortensen</a> · <a href=\"https://profiles.wordpress.org/garyj/\">Gary Jones</a> · <a href=\"https://profiles.wordpress.org/pento/\">Gary Pendergast</a> · <a href=\"https://profiles.wordpress.org/genosseeinhorn/\">genosseeinhorn</a> · <a href=\"https://profiles.wordpress.org/revgeorge/\">George Hotelling</a> · <a href=\"https://profiles.wordpress.org/mamaduka/\">George Mamadashvili</a> · <a href=\"https://profiles.wordpress.org/georgestephanis/\">George Stephanis</a> · <a href=\"https://profiles.wordpress.org/geriux/\">Gerardo Pacheco</a> · <a href=\"https://profiles.wordpress.org/glendaviesnz/\">Glen Davies</a> · <a href=\"https://profiles.wordpress.org/greglone/\">Gr&#233;gory Viguier</a> · <a href=\"https://profiles.wordpress.org/grantmkin/\">Grant M. Kinney</a> · <a href=\"https://profiles.wordpress.org/gziolo/\">Greg Ziółkowski</a> · <a href=\"https://profiles.wordpress.org/gregoiresailland/\">gregoiresailland</a> · <a href=\"https://profiles.wordpress.org/wido/\">Guido Scialfa</a> · <a href=\"https://profiles.wordpress.org/gumacahin/\">gumacahin</a> · <a href=\"https://profiles.wordpress.org/gvgvgvijayan/\">gvgvgvijayan</a> · <a href=\"https://profiles.wordpress.org/hareesh-pillai/\">Hareesh</a> · <a href=\"https://profiles.wordpress.org/hasanuzzamanshamim/\">Hasanuzzaman</a> · <a href=\"https://profiles.wordpress.org/hasnainashfaq/\">Hasnain Ashfaq</a> · <a href=\"https://profiles.wordpress.org/azhiyadev/\">Hauwa Abashiya</a> · <a href=\"https://profiles.wordpress.org/hazdiego/\">Haz</a> · <a href=\"https://profiles.wordpress.org/helen/\">Helen Hou-Sandi</a> · <a href=\"https://profiles.wordpress.org/helgatheviking/\">HelgaTheViking</a> · <a href=\"https://profiles.wordpress.org/henrywright/\">Henry Wright</a> · <a href=\"https://profiles.wordpress.org/hilayt24/\">Hilay Trivedi</a> · <a href=\"https://profiles.wordpress.org/hitendra-chopda/\">Hitendra Chopda</a> · <a href=\"https://profiles.wordpress.org/hristok/\">HristoK</a> · <a href=\"https://profiles.wordpress.org/hlashbrooke/\">Hugh Lashbrooke</a> · <a href=\"https://profiles.wordpress.org/priethor/\">Héctor Prieto</a> · <a href=\"https://profiles.wordpress.org/ianbelanger/\">Ian Belanger</a> · <a href=\"https://profiles.wordpress.org/iandunn/\">Ian Dunn</a> · <a href=\"https://profiles.wordpress.org/ianatkins/\">ianatkins</a> · <a href=\"https://profiles.wordpress.org/ianmjones/\">ianmjones</a> · <a href=\"https://profiles.wordpress.org/credo61/\">ImanGM</a> · <a href=\"https://profiles.wordpress.org/imokol/\">imokol</a> · <a href=\"https://profiles.wordpress.org/isabel_brison/\">Isabel Brison</a> · <a href=\"https://profiles.wordpress.org/ishitaka/\">ishitaka</a> · <a href=\"https://profiles.wordpress.org/itsamoreh/\">itsamoreh</a> · <a href=\"https://profiles.wordpress.org/iulia-cazan/\">Iulia Cazan</a> · <a href=\"https://profiles.wordpress.org/ivanlutrov/\">Ivan Lutrov</a> · <a href=\"https://profiles.wordpress.org/jadpm/\">jadpm</a> · <a href=\"https://profiles.wordpress.org/whyisjake/\">Jake Spurlock</a> · <a href=\"https://profiles.wordpress.org/jakeparis/\">jakeparis</a> · <a href=\"https://profiles.wordpress.org/jameskoster/\">James Koster</a> · <a href=\"https://profiles.wordpress.org/codente/\">Jamie VanRaalte</a> · <a href=\"https://profiles.wordpress.org/rumpel2116/\">Jan Weiss</a> · <a href=\"https://profiles.wordpress.org/janh2/\">janh2</a> · <a href=\"https://profiles.wordpress.org/jarretc/\">Jarret</a> · <a href=\"https://profiles.wordpress.org/jsnjohnston/\">Jason Johnston</a> · <a href=\"https://profiles.wordpress.org/madtownlems/\">Jason LeMahieu (MadtownLems)</a> · <a href=\"https://profiles.wordpress.org/javiarce/\">Javier Arce</a> · <a href=\"https://profiles.wordpress.org/jprieton/\">Javier Prieto</a> · <a href=\"https://profiles.wordpress.org/grandeljay/\">Jay Trees</a> · <a href=\"https://profiles.wordpress.org/jazbek/\">jazbek</a> · <a href=\"https://profiles.wordpress.org/audrasjb/\">Jean-Baptiste Audras</a> · <a href=\"https://profiles.wordpress.org/jblz/\">Jeff Bowen</a> · <a href=\"https://profiles.wordpress.org/jeffmatson/\">Jeff Matson</a> · <a href=\"https://profiles.wordpress.org/jffng/\">Jeff Ong</a> · <a href=\"https://profiles.wordpress.org/jeffpaul/\">Jeff Paul</a> · <a href=\"https://profiles.wordpress.org/jdy68/\">Jenny Dupuy</a> · <a href=\"https://profiles.wordpress.org/miss_jwo/\">Jenny Wong</a> · <a href=\"https://profiles.wordpress.org/jeremyfelt/\">Jeremy Felt</a> · <a href=\"https://profiles.wordpress.org/jeherve/\">Jeremy Herve</a> · <a href=\"https://profiles.wordpress.org/jeremyyip/\">Jeremy Yip</a> · <a href=\"https://profiles.wordpress.org/sausajez/\">Jez Emery</a> · <a href=\"https://profiles.wordpress.org/jhned/\">jhned</a> · <a href=\"https://profiles.wordpress.org/jhnstn/\">jhnstn</a> · <a href=\"https://profiles.wordpress.org/jigar-bhanushali/\">jigar bhanushali</a> · <a href=\"https://profiles.wordpress.org/jiteshdhamaniya/\">jiteshdhamaniya</a> · <a href=\"https://profiles.wordpress.org/joedolson/\">Joe Dolson</a> · <a href=\"https://profiles.wordpress.org/joemcgill/\">Joe McGill</a> · <a href=\"https://profiles.wordpress.org/joen/\">Joen Asmussen</a> · <a href=\"https://profiles.wordpress.org/goaroundagain/\">Johannes Kinast</a> · <a href=\"https://profiles.wordpress.org/johnbillion/\">John Blackbourn</a> · <a href=\"https://profiles.wordpress.org/johnjamesjacoby/\">John James Jacoby</a> · <a href=\"https://profiles.wordpress.org/johnregan3/\">John Regan</a> · <a href=\"https://profiles.wordpress.org/johnwatkins0/\">John Watkins</a> · <a href=\"https://profiles.wordpress.org/jb510/\">Jon Brown</a> · <a href=\"https://profiles.wordpress.org/jrchamp/\">Jonathan Champ</a> · <a href=\"https://profiles.wordpress.org/desrosj/\">Jonathan Desrosiers</a> · <a href=\"https://profiles.wordpress.org/spacedmonkey/\">Jonny Harris</a> · <a href=\"https://profiles.wordpress.org/jonoaldersonwp/\">Jono Alderson</a> · <a href=\"https://profiles.wordpress.org/jorgecontreras/\">Jorge</a> · <a href=\"https://profiles.wordpress.org/jorgefilipecosta/\">Jorge Costa</a> · <a href=\"https://profiles.wordpress.org/josearcos/\">Jos&#233; Arcos</a> · <a href=\"https://profiles.wordpress.org/chanthaboune/\">Josepha</a> · <a href=\"https://profiles.wordpress.org/jostnes/\">Josepha Dambul</a> · <a href=\"https://profiles.wordpress.org/joshf/\">Joshua Fredrickson</a> · <a href=\"https://profiles.wordpress.org/joyously/\">Joy</a> · <a href=\"https://profiles.wordpress.org/jrivett/\">jrivett</a> · <a href=\"https://profiles.wordpress.org/jsnajdr/\">jsnajdr</a> · <a href=\"https://profiles.wordpress.org/juanlopez4691/\">juanlopez4691</a> · <a href=\"https://profiles.wordpress.org/juanmaguitar/\">JuanMa Garrido</a> · <a href=\"https://profiles.wordpress.org/jrf/\">Juliette Reinders Folmer</a> · <a href=\"https://profiles.wordpress.org/junaidkbr/\">Junaid Ahmed</a> · <a href=\"https://profiles.wordpress.org/justinahinon/\">Justin Ahinon</a> · <a href=\"https://profiles.wordpress.org/justinbusa/\">Justin Busa</a> · <a href=\"https://profiles.wordpress.org/certainstrings/\">Justin Tucker</a> · <a href=\"https://profiles.wordpress.org/kafleg/\">KafleG</a> · <a href=\"https://profiles.wordpress.org/kevin940726/\">Kai Hao</a> · <a href=\"https://profiles.wordpress.org/kajalgohel/\">Kajal Gohel</a> · <a href=\"https://profiles.wordpress.org/kapacity/\">kapacity</a> · <a href=\"https://profiles.wordpress.org/kapilpaul/\">Kapil Paul</a> · <a href=\"https://profiles.wordpress.org/karolinakulinska/\">karolinakulinska</a> · <a href=\"https://profiles.wordpress.org/kasparsd/\">Kaspars</a> · <a href=\"https://profiles.wordpress.org/kbat82/\">kbatdorf</a> · <a href=\"https://profiles.wordpress.org/ryelle/\">Kelly Choyce-Dwan</a> · <a href=\"https://profiles.wordpress.org/w33zy/\">Kemory Grubb</a> · <a href=\"https://profiles.wordpress.org/gwwar/\">Kerry Liu</a> · <a href=\"https://profiles.wordpress.org/kprovance/\">Kev Provance</a> · <a href=\"https://profiles.wordpress.org/kharisblank/\">Kharis Sulistiyono</a> · <a href=\"https://profiles.wordpress.org/kirtan95/\">Kirtan Gajjar</a> · <a href=\"https://profiles.wordpress.org/kjellr/\">Kjell Reigstad</a> · <a href=\"https://profiles.wordpress.org/kmix39/\">KMix</a> · <a href=\"https://profiles.wordpress.org/knutsp/\">Knut Sparhell</a> · <a href=\"https://profiles.wordpress.org/konradyoast/\">Konrad.K</a> · <a href=\"https://profiles.wordpress.org/obenland/\">Konstantin Obenland</a> · <a href=\"https://profiles.wordpress.org/kpegoraro/\">kpegoraro</a> · <a href=\"https://profiles.wordpress.org/kubiq/\">kubiq</a> · <a href=\"https://profiles.wordpress.org/sainthkh/\">Kukhyeon Heo</a> · <a href=\"https://profiles.wordpress.org/laurlittle/\">Lauren</a> · <a href=\"https://profiles.wordpress.org/0mirka00/\">Lena Morita</a> · <a href=\"https://profiles.wordpress.org/lenasterg/\">lenasterg</a> · <a href=\"https://profiles.wordpress.org/uzumymw/\">leskam</a> · <a href=\"https://profiles.wordpress.org/layotte/\">Lew Ayotte</a> · <a href=\"https://profiles.wordpress.org/linux4me2/\">linux4me2</a> · <a href=\"https://profiles.wordpress.org/lschuyler/\">Lisa Schuyler</a> · <a href=\"https://profiles.wordpress.org/lkraav/\">lkraav</a> · <a href=\"https://profiles.wordpress.org/louislaugesen/\">Louis</a> · <a href=\"https://profiles.wordpress.org/thelovekesh/\">Lovekesh Kumar</a> · <a href=\"https://profiles.wordpress.org/karpstrucking/\">Lucas Karpiuk</a> · <a href=\"https://profiles.wordpress.org/zaguiini/\">Luis Felipe Zaguini</a> · <a href=\"https://profiles.wordpress.org/luisherranz/\">luisherranz</a> · <a href=\"https://profiles.wordpress.org/lukecavanagh/\">Luke Cavanagh</a> · <a href=\"https://profiles.wordpress.org/pyrobd/\">Lukman Nakib</a> · <a href=\"https://profiles.wordpress.org/michelangelovandam/\">M. van Dam</a> · <a href=\"https://profiles.wordpress.org/macbookandrew/\">macbookandrew</a> · <a href=\"https://profiles.wordpress.org/mashikag/\">Maciej</a> · <a href=\"https://profiles.wordpress.org/onemaggie/\">Maggie Cabrera</a> · <a href=\"https://profiles.wordpress.org/maguijo/\">maguijo</a> · <a href=\"https://profiles.wordpress.org/mhimon/\">Mahbub Hasan Imon</a> · <a href=\"https://profiles.wordpress.org/malthert/\">malthert</a> · <a href=\"https://profiles.wordpress.org/manfcarlo/\">manfcarlo</a> · <a href=\"https://profiles.wordpress.org/fullofcaffeine/\">Marcelo de Moraes Serpa</a> · <a href=\"https://profiles.wordpress.org/mciampini/\">Marco Ciampini</a> · <a href=\"https://profiles.wordpress.org/mkaz/\">Marcus Kazmierczak</a> · <a href=\"https://profiles.wordpress.org/tyxla/\">Marin Atanasov</a> · <a href=\"https://profiles.wordpress.org/clorith/\">Marius L. J.</a> · <a href=\"https://profiles.wordpress.org/markjaquith/\">Mark Jaquith</a> · <a href=\"https://profiles.wordpress.org/mkox/\">Markus Kosmal</a> · <a href=\"https://profiles.wordpress.org/marv2/\">marv2</a> · <a href=\"https://profiles.wordpress.org/marybaum/\">Mary Baum</a> · <a href=\"https://profiles.wordpress.org/mat-lipe/\">Mat Lipe</a> · <a href=\"https://profiles.wordpress.org/paapst/\">Mathieu</a> · <a href=\"https://profiles.wordpress.org/matveb/\">Matias Ventura</a> · <a href=\"https://profiles.wordpress.org/mmaattiiaass/\">matiasbenedetto</a> · <a href=\"https://profiles.wordpress.org/mattchowning/\">Matt Chowning</a> · <a href=\"https://profiles.wordpress.org/sivel/\">Matt Martz</a> · <a href=\"https://profiles.wordpress.org/matt/\">Matt Mullenweg</a> · <a href=\"https://profiles.wordpress.org/themattroyal/\">Matt Royal</a> · <a href=\"https://profiles.wordpress.org/mjstoney/\">Matt Stoney</a> · <a href=\"https://profiles.wordpress.org/mattwiebe/\">Matt Wiebe</a> · <a href=\"https://profiles.wordpress.org/mauriac/\">maur</a> · <a href=\"https://profiles.wordpress.org/azouamauriac/\">Mauriac AZOUA</a> · <a href=\"https://profiles.wordpress.org/maxkellermann/\">Max Kellermann</a> · <a href=\"https://profiles.wordpress.org/mehedi890/\">Mehedi Foysal</a> · <a href=\"https://profiles.wordpress.org/meher/\">Meher Bala</a> · <a href=\"https://profiles.wordpress.org/mgol/\">mgol</a> · <a href=\"https://profiles.wordpress.org/mburridge/\">Michael Burridge</a> · <a href=\"https://profiles.wordpress.org/czapla/\">Michal Czaplinski</a> · <a href=\"https://profiles.wordpress.org/mcsf/\">Miguel Fonseca</a> · <a href=\"https://profiles.wordpress.org/mauteri/\">Mike Auteri</a> · <a href=\"https://profiles.wordpress.org/mikeschroder/\">Mike Schroder</a> · <a href=\"https://profiles.wordpress.org/miken32/\">miken32</a> · <a href=\"https://profiles.wordpress.org/dimadin/\">Milan Dinić</a> · <a href=\"https://profiles.wordpress.org/milana_cap/\">Milana Cap</a> · <a href=\"https://profiles.wordpress.org/multidots1896/\">Minal Diwan</a> · <a href=\"https://profiles.wordpress.org/mirkolofio/\">Mirco Babini</a> · <a href=\"https://profiles.wordpress.org/mmdeveloper/\">MMDeveloper</a> · <a href=\"https://profiles.wordpress.org/mohadeseghasemi/\">Mohadese Ghasemi</a> · <a href=\"https://profiles.wordpress.org/ahsan03/\">Mohammad Ahsan Habib</a> · <a href=\"https://profiles.wordpress.org/opurockey/\">Mohammad Rockeybul Alam</a> · <a href=\"https://profiles.wordpress.org/mjkhajeh/\">MohammadJafar Khajeh</a> · <a href=\"https://profiles.wordpress.org/mor10/\">Morten Rand-Hendriksen</a> · <a href=\"https://profiles.wordpress.org/moushik/\">moushik</a> · <a href=\"https://profiles.wordpress.org/computerguru/\">mqudsi</a> · <a href=\"https://profiles.wordpress.org/muhammadfaizanhaidar/\">Muhammad Faizan Haidar</a> · <a href=\"https://profiles.wordpress.org/mukesh27/\">Mukesh Panchal</a> · <a href=\"https://profiles.wordpress.org/amustaque97/\">Mustaque Ahmed</a> · <a href=\"https://profiles.wordpress.org/nabil_kadimi/\">Nabil</a> · <a href=\"https://profiles.wordpress.org/nagpai/\">Nagesh Pai - a11n</a> · <a href=\"https://profiles.wordpress.org/nalininonstopnewsuk/\">Nalini Thakor</a> · <a href=\"https://profiles.wordpress.org/nhadsall/\">Nathan</a> · <a href=\"https://profiles.wordpress.org/nayana123/\">Nayana Maradia</a> · <a href=\"https://profiles.wordpress.org/eidolonnight/\">Nicholas Garofalo</a> · <a href=\"https://profiles.wordpress.org/nickciske/\">Nick Ciske</a> · <a href=\"https://profiles.wordpress.org/ndiego/\">Nick Diego</a> · <a href=\"https://profiles.wordpress.org/rahe/\">Nicolas Juen</a> · <a href=\"https://profiles.wordpress.org/nidhidhandhukiya/\">nidhidhandhukiya</a> · <a href=\"https://profiles.wordpress.org/ntsekouras/\">Nik Tsekouras</a> · <a href=\"https://profiles.wordpress.org/knilkantha/\">Nil</a> · <a href=\"https://profiles.wordpress.org/nmschaller/\">nmschaller</a> · <a href=\"https://profiles.wordpress.org/noahtallen/\">Noah Allen</a> · <a href=\"https://profiles.wordpress.org/oakesjosh/\">oakesjosh</a> · <a href=\"https://profiles.wordpress.org/oguzkocer/\">oguzkocer</a> · <a href=\"https://profiles.wordpress.org/domainsupport/\">Oliver Campion</a> · <a href=\"https://profiles.wordpress.org/alshakero/\">Omar Alshaker</a> · <a href=\"https://profiles.wordpress.org/opr18/\">opr18</a> · <a href=\"https://profiles.wordpress.org/otshelnik-fm/\">Otshelnik-Fm</a> · <a href=\"https://profiles.wordpress.org/overclokk/\">overclokk</a> · <a href=\"https://profiles.wordpress.org/ovidiul/\">ovidiul</a> · <a href=\"https://profiles.wordpress.org/paaljoachim/\">Paal Joachim Romdahl</a> · <a href=\"https://profiles.wordpress.org/pablohoneyhoney/\">Pablo Honey</a> · <a href=\"https://profiles.wordpress.org/pls78/\">Paolo L. Scala</a> · <a href=\"https://profiles.wordpress.org/paragoninitiativeenterprises/\">Paragon Initiative Enterprises</a> · <a href=\"https://profiles.wordpress.org/swissspidy/\">Pascal Birchler</a> · <a href=\"https://profiles.wordpress.org/pbearne/\">Paul Bearne</a> · <a href=\"https://profiles.wordpress.org/pbiron/\">Paul Biron</a> · <a href=\"https://profiles.wordpress.org/figureone/\">Paul Ryan</a> · <a href=\"https://profiles.wordpress.org/pschrottky/\">Paul Von Schrottky</a> · <a href=\"https://profiles.wordpress.org/paulkevan/\">paulkevan</a> · <a href=\"https://profiles.wordpress.org/pavanpatil1/\">Pavan Patil</a> · <a href=\"https://profiles.wordpress.org/malinevskiy/\">Pavlo</a> · <a href=\"https://profiles.wordpress.org/pbking/\">pbking</a> · <a href=\"https://profiles.wordpress.org/pedromendonca/\">Pedro Mendon&#231;a</a> · <a href=\"https://profiles.wordpress.org/petaryoast/\">Petar Ratković</a> · <a href=\"https://profiles.wordpress.org/psmits1567/\">Peter Smits</a> · <a href=\"https://profiles.wordpress.org/westi/\">Peter Westwood</a> · <a href=\"https://profiles.wordpress.org/peterwilsoncc/\">Peter Wilson</a> · <a href=\"https://profiles.wordpress.org/petrosparaskevopoulos/\">petrosparaskevopoulos</a> · <a href=\"https://profiles.wordpress.org/walbo/\">Petter Walb&#248; Johnsg&#229;rd</a> · <a href=\"https://profiles.wordpress.org/pgpagely/\">pgpagely</a> · <a href=\"https://profiles.wordpress.org/johnstonphilip/\">Phil Johnston</a> · <a href=\"https://profiles.wordpress.org/nekojonez/\">Pieterjan Deneys</a> · <a href=\"https://profiles.wordpress.org/pikamander2/\">pikamander2</a> · <a href=\"https://profiles.wordpress.org/boniu91/\">Piotrek Boniu</a> · <a href=\"https://profiles.wordpress.org/webtechpooja/\">Pooja Derashri</a> · <a href=\"https://profiles.wordpress.org/pooja1210/\">Pooja N Muchandikar</a> · <a href=\"https://profiles.wordpress.org/pravinparmar2404/\">Pravin Parmar</a> · <a href=\"https://profiles.wordpress.org/presskopp/\">Presskopp</a> · <a href=\"https://profiles.wordpress.org/presstoke/\">presstoke</a> · <a href=\"https://profiles.wordpress.org/priyank9033/\">Priyank</a> · <a href=\"https://profiles.wordpress.org/pypwalters/\">pypwalters</a> · <a href=\"https://profiles.wordpress.org/r-a-y/\">r-a-y</a> · <a href=\"https://profiles.wordpress.org/rachelbaker/\">Rachel Baker</a> · <a href=\"https://profiles.wordpress.org/rafiahmedd/\">Rafi Ahmed</a> · <a href=\"https://profiles.wordpress.org/superpoincare/\">Ramanan</a> · <a href=\"https://profiles.wordpress.org/rahmohn/\">Ramon Ahnert</a> · <a href=\"https://profiles.wordpress.org/ramonopoly/\">Ramon James</a> · <a href=\"https://profiles.wordpress.org/nextend_ramona/\">Ramona</a> · <a href=\"https://profiles.wordpress.org/jontyravi/\">Ravi Vaghela</a> · <a href=\"https://profiles.wordpress.org/ravipatel/\">Ravikumar Patel</a> · <a href=\"https://profiles.wordpress.org/razvanonofrei/\">Razvan Onofrei</a> · <a href=\"https://profiles.wordpress.org/rehanali/\">Rehan Ali</a> · <a href=\"https://profiles.wordpress.org/tabrisrp/\">Remy Perona</a> · <a href=\"https://profiles.wordpress.org/youknowriad/\">Riad Benguella</a> · <a href=\"https://profiles.wordpress.org/rianrietveld/\">Rian Rietveld</a> · <a href=\"https://profiles.wordpress.org/richtabor/\">Rich Tabor</a> · <a href=\"https://profiles.wordpress.org/richybkreckel/\">Richard B. Kreckel</a> · <a href=\"https://profiles.wordpress.org/ricomoorman/\">ricomoorman</a> · <a href=\"https://profiles.wordpress.org/r0bsc0tt/\">Rob Scott</a> · <a href=\"https://profiles.wordpress.org/noisysocks/\">Robert Anderson</a> · <a href=\"https://profiles.wordpress.org/ravanh/\">Rolf Allard van Hagen</a> · <a href=\"https://profiles.wordpress.org/rolfsiebers/\">Rolf Siebers</a> · <a href=\"https://profiles.wordpress.org/costasovo/\">Rostislav Woln&#253;</a> · <a href=\"https://profiles.wordpress.org/rufus87/\">Rufus87</a> · <a href=\"https://profiles.wordpress.org/ryan/\">Ryan Boren</a> · <a href=\"https://profiles.wordpress.org/bookdude13/\">Ryan Fredlund</a> · <a href=\"https://profiles.wordpress.org/rmccue/\">Ryan McCue</a> · <a href=\"https://profiles.wordpress.org/welcher/\">Ryan Welcher</a> · <a href=\"https://profiles.wordpress.org/sebastienserre/\">S&#233;bastien SERRE</a> · <a href=\"https://profiles.wordpress.org/soean/\">S&#246;ren Wrede</a> · <a href=\"https://profiles.wordpress.org/sabbir1991/\">Sabbir Ahmed</a> · <a href=\"https://profiles.wordpress.org/sabbirshouvo/\">Sabbir Hasan</a> · <a href=\"https://profiles.wordpress.org/samiff/\">Sami Falah</a> · <a href=\"https://profiles.wordpress.org/sanzeeb3/\">Sanjeev Aryal</a> · <a href=\"https://profiles.wordpress.org/santosguillamot/\">santosguillamot</a> · <a href=\"https://profiles.wordpress.org/mikachan/\">Sarah Norris</a> · <a href=\"https://profiles.wordpress.org/arasae/\">Sarah Snow</a> · <a href=\"https://profiles.wordpress.org/sarayourfriend/\">sarayourfriend</a> · <a href=\"https://profiles.wordpress.org/sathyapulse/\">Sathiyamoorthy V</a> · <a href=\"https://profiles.wordpress.org/sayedulsayem/\">Sayedul Sayem</a> · <a href=\"https://profiles.wordpress.org/sbossarte/\">sbossarte</a> · <a href=\"https://profiles.wordpress.org/sclayf1/\">sclayf1</a> · <a href=\"https://profiles.wordpress.org/swb1192/\">Scott Buscemi</a> · <a href=\"https://profiles.wordpress.org/coffee2code/\">Scott Reilly</a> · <a href=\"https://profiles.wordpress.org/wonderboymusic/\">Scott Taylor</a> · <a href=\"https://profiles.wordpress.org/omaeyusuke/\">Segayuu</a> · <a href=\"https://profiles.wordpress.org/sergeybiryukov/\">Sergey Biryukov</a> · <a href=\"https://profiles.wordpress.org/sheepysheep60/\">sheepysheep60</a> · <a href=\"https://profiles.wordpress.org/shital-patel/\">Shital Marakana</a> · <a href=\"https://profiles.wordpress.org/shreyasikhar26/\">Shreyas Ikhar</a> · <a href=\"https://profiles.wordpress.org/rsiddharth/\">siddharth ravikumar</a> · <a href=\"https://profiles.wordpress.org/nomnom99/\">Siddharth Thevaril</a> · <a href=\"https://profiles.wordpress.org/silb3r/\">silb3r</a> · <a href=\"https://profiles.wordpress.org/lumpysimon/\">Simon Blackbourn</a> · <a href=\"https://profiles.wordpress.org/pross/\">Simon Prosser</a> · <a href=\"https://profiles.wordpress.org/simonhammes/\">simonhammes</a> · <a href=\"https://profiles.wordpress.org/siobhyb/\">Siobhan</a> · <a href=\"https://profiles.wordpress.org/smit08/\">Smit Rathod</a> · <a href=\"https://profiles.wordpress.org/snapfractalpop/\">snapfractalpop</a> · <a href=\"https://profiles.wordpress.org/socalchristina/\">socalchristina</a> · <a href=\"https://profiles.wordpress.org/spencercameron/\">Spencer Cameron-Morin</a> · <a href=\"https://profiles.wordpress.org/stacimc/\">stacimc</a> · <a href=\"https://profiles.wordpress.org/stefanfisk/\">stefanfisk</a> · <a href=\"https://profiles.wordpress.org/satollo/\">Stefano Lissa</a> · <a href=\"https://profiles.wordpress.org/ryokuhi/\">Stefano Minoia</a> · <a href=\"https://profiles.wordpress.org/hypest/\">Stefanos Togoulidis</a> · <a href=\"https://profiles.wordpress.org/sabernhardt/\">Stephen Bernhardt</a> · <a href=\"https://profiles.wordpress.org/netweb/\">Stephen Edgar</a> · <a href=\"https://profiles.wordpress.org/stephenharris/\">Stephen Harris</a> · <a href=\"https://profiles.wordpress.org/stevegrunwell/\">Steve Grunwell</a> · <a href=\"https://profiles.wordpress.org/subrataemfluence/\">Subrata Sarkar</a> · <a href=\"https://profiles.wordpress.org/5um17/\">Sumit Singh</a> · <a href=\"https://profiles.wordpress.org/sumitsingh/\">Sumit Singh</a> · <a href=\"https://profiles.wordpress.org/csesumonpro/\">Sumon Sarker</a> · <a href=\"https://profiles.wordpress.org/sunil25393/\">SunilPrajapati</a> · <a href=\"https://profiles.wordpress.org/sunyatasattva/\">sunyatasattva</a> · <a href=\"https://profiles.wordpress.org/mahype/\">Sven Wagener</a> · <a href=\"https://profiles.wordpress.org/cybr/\">Sybre Waaijer</a> · <a href=\"https://profiles.wordpress.org/synchro/\">Synchro</a> · <a href=\"https://profiles.wordpress.org/inc2734/\">Takashi Kitajima</a> · <a href=\"https://profiles.wordpress.org/karmatosed/\">Tammie Lister</a> · <a href=\"https://profiles.wordpress.org/tharsheblows/\">tharsheblows</a> · <a href=\"https://profiles.wordpress.org/legendusmaximus/\">Theo H</a> · <a href=\"https://profiles.wordpress.org/thimalw/\">Thimal Wickremage</a> · <a href=\"https://profiles.wordpress.org/twistermc/\">Thomas McMahon</a> · <a href=\"https://profiles.wordpress.org/thomasplevy/\">Thomas Patrick Levy</a> · <a href=\"https://profiles.wordpress.org/xiven/\">Thomas Pike</a> · <a href=\"https://profiles.wordpress.org/tillkruess/\">Till Kr&#252;ss</a> · <a href=\"https://profiles.wordpress.org/waterfire/\">Tim Blankenship</a> · <a href=\"https://profiles.wordpress.org/tnolte/\">Tim Nolte</a> · <a href=\"https://profiles.wordpress.org/timothyblynjacobs/\">Timothy Jacobs</a> · <a href=\"https://profiles.wordpress.org/tobifjellner/\">tobifjellner (Tor-Bjorn Fjellner)</a> · <a href=\"https://profiles.wordpress.org/tomjdevisser/\">Tom</a> · <a href=\"https://profiles.wordpress.org/tomasztunik/\">Tomasz Tunik</a> · <a href=\"https://profiles.wordpress.org/tomalec/\">Tomek</a> · <a href=\"https://profiles.wordpress.org/shimotomoki/\">Tomoki Shimomura</a> · <a href=\"https://profiles.wordpress.org/ttahmouch/\">Tony Tahmouch</a> · <a href=\"https://profiles.wordpress.org/hellofromtonya/\">Tonya Mork</a> · <a href=\"https://profiles.wordpress.org/toro_unit/\">Toro_Unit (Hiroshi Urabe)</a> · <a href=\"https://profiles.wordpress.org/zodiac1978/\">Torsten Landsiedel</a> · <a href=\"https://profiles.wordpress.org/sierratr/\">Tracy</a> · <a href=\"https://profiles.wordpress.org/trex005/\">trex005</a> · <a href=\"https://profiles.wordpress.org/tszming/\">tszming</a> · <a href=\"https://profiles.wordpress.org/tumas2/\">tumas2</a> · <a href=\"https://profiles.wordpress.org/twstokes/\">twstokes</a> · <a href=\"https://profiles.wordpress.org/junsuijin/\">Tynan Beatty</a> · <a href=\"https://profiles.wordpress.org/tzipporahwitty/\">tzipporahwitty</a> · <a href=\"https://profiles.wordpress.org/uday17035/\">Uday Kokitkar</a> · <a href=\"https://profiles.wordpress.org/ugljanin/\">ugljanin</a> · <a href=\"https://profiles.wordpress.org/ugyensupport/\">Ugyen Dorji</a> · <a href=\"https://profiles.wordpress.org/grapplerulrich/\">Ulrich</a> · <a href=\"https://profiles.wordpress.org/utkarshpatel/\">Utkarsh</a> · <a href=\"https://profiles.wordpress.org/valer1e/\">valer1e</a> · <a href=\"https://profiles.wordpress.org/versusbassz/\">versusbassz</a> · <a href=\"https://profiles.wordpress.org/vcanales/\">Vicente Canales</a> · <a href=\"https://profiles.wordpress.org/elifvish/\">Vishal Kumar</a> · <a href=\"https://profiles.wordpress.org/vladolaru/\">vlad.olaru</a> · <a href=\"https://profiles.wordpress.org/volodymyrkolesnykov/\">Volodymyr Kolesnykov</a> · <a href=\"https://profiles.wordpress.org/vortfu/\">vortfu</a> · <a href=\"https://profiles.wordpress.org/webmandesign/\">WebMan Design &#124; Oliver Juhas</a> · <a href=\"https://profiles.wordpress.org/wendyjchen/\">Wendy Chen</a> · <a href=\"https://profiles.wordpress.org/west7/\">Wes Theron</a> · <a href=\"https://profiles.wordpress.org/westonruter/\">Weston Ruter</a> · <a href=\"https://profiles.wordpress.org/whoisnegrello/\">whoisnegrello</a> · <a href=\"https://profiles.wordpress.org/skorasaurus/\">Will Skora</a> · <a href=\"https://profiles.wordpress.org/wpmakenorg/\">wpmakenorg</a> · <a href=\"https://profiles.wordpress.org/wpsoul/\">wpsoul</a> · <a href=\"https://profiles.wordpress.org/wraithkenny/\">WraithKenny</a> · <a href=\"https://profiles.wordpress.org/wslyhbb/\">wslyhbb</a> · <a href=\"https://profiles.wordpress.org/upsuper/\">Xidorn Quan</a> · <a href=\"https://profiles.wordpress.org/fierevere/\">Yui</a> · <a href=\"https://profiles.wordpress.org/dolphingg/\">Yunus Ertuğrul</a> · <a href=\"https://profiles.wordpress.org/zebulan/\">Zebulan Stanphill</a> · <a href=\"https://profiles.wordpress.org/znuff/\">znuff</a> · <a href=\"https://profiles.wordpress.org/chesio/\">Česlav Przywara</a></p>\n\n\n\n<p>By release day, 76 locales had translated 90-percent or more of WordPress 6.0 into their language. Community translators continue after a release ensuring more translations are on their way. Thank you to everyone who helps to make WordPress available in 205 languages.</p>\n\n\n\n<p>Many thanks to all of the community volunteers who contribute to the <a href=\"https://wordpress.org/support/\">support forums</a> by answering questions from WordPress users around the world.</p>\n\n\n\n<p>If contributing to WordPress appeals to you, it’s easy to learn more and get involved. Discover the different teams that come together to <a href=\"https://make.wordpress.org/\">Make WordPress</a> and explore the product roadmap on the <a href=\"https://make.wordpress.org/core/\">core development blog</a>.</p>\n\n\n\n<h2>The WordPress Mission &amp; You</h2>\n\n\n\n<p>WordPress is software designed for everyone, emphasizing accessibility, performance, security, and ease of use. The project believes great software should work with minimum setup, so you can focus on sharing your story, product, or services freely. The basic WordPress software is simple and predictable so you can easily get started. It also offers powerful features for growth and success.</p>\n\n\n\n<p>WordPress believes in democratizing publishing and <a href=\"https://opensource.org/osd-annotated\">the freedoms that come with open source</a>. Supporting this idea is a large community of people collaborating on and contributing to this project. The WordPress community is welcoming and inclusive. Our contributors’ passion drives the success of WordPress which, in turn, helps you reach your goals.</p>\n\n\n\n<p><a href=\"https://wordpress.org/about/\">Learn more about WordPress</a> and how you can join our community to help shape the future of the world’s most popular website platform.</p>\n\n\n\n<hr class=\"wp-block-separator has-alpha-channel-opacity\" />\n\n\n\n<h2>A Release Haiku</h2>\n\n\n\n<p>Six-point-oh is here<br>Time to download and upgrade<br>Let’s pause, celebrate</p>\n\n\n\n<hr class=\"wp-block-separator has-alpha-channel-opacity\" />\n\n\n\n<p id=\"footnote\">1&nbsp;<a href=\"https://w3techs.com/technologies/overview/content_management\">According to W3Techs as of May 5, 2022</a>. </p>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:30:\"com-wordpress:feed-additions:1\";a:1:{s:7:\"post-id\";a:1:{i:0;a:5:{s:4:\"data\";s:5:\"12879\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:5;a:6:{s:4:\"data\";s:69:\"\n		\n		\n		\n		\n		\n				\n		\n		\n		\n		\n		\n\n					\n										\n					\n		\n		\n			\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:4:{s:0:\"\";a:6:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:65:\"WordPress 6.0 Release Candidate 3 (RC3) Now Available for Testing\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:99:\"https://wordpress.org/news/2022/05/wordpress-6-0-release-candidate-3-rc3-now-available-for-testing/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Tue, 17 May 2022 16:39:51 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:5:{i:0;a:5:{s:4:\"data\";s:11:\"Development\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:1;a:5:{s:4:\"data\";s:8:\"Releases\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:2;a:5:{s:4:\"data\";s:3:\"6.0\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:3;a:5:{s:4:\"data\";s:11:\"development\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:4;a:5:{s:4:\"data\";s:8:\"releases\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:35:\"https://wordpress.org/news/?p=12866\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:166:\"WordPress 6.0 Release Candidate 3 is now available for testing! You can download and help test RC3 in three ways. 6.0 is planned for general release on May 24, 2022.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:11:\"Dan Soschin\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:4240:\"\n<p>WordPress 6.0 is scheduled for release next week on May 24, 2022! This RC3 release is the final opportunity for you to test and help contribute to making the 6.0 release great.</p>\n\n\n\n<p>You can view changes since the RC2 release via <a href=\"https://github.com/WordPress/gutenberg/commits/wp/6.0\">Gutenberg</a> and <a href=\"https://core.trac.wordpress.org/query?status=accepted&amp;status=closed&amp;changetime=05%2F10%2F2022..05%2F17%2F2022&amp;resolution=fixed&amp;milestone=6.0&amp;col=id&amp;col=summary&amp;col=status&amp;col=milestone&amp;col=owner&amp;col=type&amp;col=priority&amp;order=id\">Trac</a>.</p>\n\n\n\n<h1>Installing RC3</h1>\n\n\n\n<p><strong>This version of the WordPress software is under development</strong>. Please do not install, run, and test this version of WordPress on production or mission-critical websites. Instead, it is recommended that you install RC3 on a test server and site.&nbsp;</p>\n\n\n\n<p>You can test WordPress 6.0 RC3 in three ways:</p>\n\n\n\n<p><strong>Option 1: </strong>Install and activate the <a href=\"https://wordpress.org/plugins/wordpress-beta-tester/\">WordPress Beta Tester</a> plugin (select the “Bleeding edge” channel and “Beta/RC Only” stream).</p>\n\n\n\n<p><strong>Option 2: </strong>Direct download the <a href=\"https://wordpress.org/wordpress-6.0-RC3.zip\">release candidate (zip)</a>.</p>\n\n\n\n<p><strong>Option 3:</strong> When using WP-CLI to upgrade from Beta 1, 2, 3, 4, RC1, or RC2 on a case-insensitive filesystem, please use the following command:</p>\n\n\n\n<p><code>wp core update --version=6.0-RC3</code></p>\n\n\n\n<h1>Plugin and Theme Developers</h1>\n\n\n\n<p>All plugin and theme developers are encouraged to complete testing of their respective extensions against WordPress 6.0 RC3 and update the “<em>Tested up to”</em> version in their readme file to 6.0 this week. If you find compatibility problems, please be sure to post detailed information to the <a href=\"https://wordpress.org/support/forum/alphabeta/\">support forums</a>, so these items can be investigated further prior to the final release date of May 24.</p>\n\n\n\n<p>Review the <a href=\"https://make.wordpress.org/core/2022/05/03/wordpress-6-0-field-guide/\"><em>WordPress 6.0 Field Guide</em></a>, for more details on this release.</p>\n\n\n\n<p>Review additional information on the full <a href=\"https://make.wordpress.org/core/6-0/\">6.0 release cycle</a>.</p>\n\n\n\n<p>Check the <a href=\"https://make.wordpress.org/core/\">Make WordPress Core blog</a> for <a href=\"https://make.wordpress.org/core/tag/dev-notes+6-0/\">6.0-related developer notes</a> in the coming weeks which will detail upcoming changes.</p>\n\n\n\n<h1>Translate WordPress</h1>\n\n\n\n<p>Do you speak a language other than English? <a href=\"https://translate.wordpress.org/projects/wp/dev\">Help translate WordPress into more than 100 languages.</a></p>\n\n\n\n<h1>How to Help Test WordPress</h1>\n\n\n\n<p>Testing for issues is critical for stabilizing a release throughout its development. Testing is also a great way to contribute to WordPress. If you are new to testing, check out this <a href=\"https://make.wordpress.org/test/2022/04/12/help-wanted-test-wordpress-6-0/\">detailed guide</a> that will walk you through how to get started.</p>\n\n\n\n<p>If you think you have run into an issue, please report it to the <a href=\"https://wordpress.org/support/forum/alphabeta/\">Alpha/Beta area</a> in the support forums. If you are comfortable writing a reproducible bug report, you can <a href=\"https://core.trac.wordpress.org/newticket\">file one on WordPress Trac</a>. This is also where you can find a list of <a href=\"https://core.trac.wordpress.org/tickets/major\">known bugs</a>.</p>\n\n\n\n<hr class=\"wp-block-separator has-alpha-channel-opacity\" />\n\n\n\n<h2>RC3, An (Almost) Final Haiku</h2>\n\n\n\n<p>It’s near time for six<br>The reward is the journey<br>Just one week to go</p>\n\n\n\n<hr class=\"wp-block-separator has-alpha-channel-opacity\" />\n\n\n\n<p>Thank you to the following contributors for collaborating on this post: <a href=\'https://profiles.wordpress.org/dansoschin/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>dansoschin</a>, <a href=\'https://profiles.wordpress.org/webcommsat/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>webcommsat</a>.&nbsp;</p>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:30:\"com-wordpress:feed-additions:1\";a:1:{s:7:\"post-id\";a:1:{i:0;a:5:{s:4:\"data\";s:5:\"12866\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:6;a:6:{s:4:\"data\";s:61:\"\n		\n		\n		\n		\n		\n				\n		\n		\n\n					\n										\n					\n		\n		\n\n			\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:4:{s:0:\"\";a:7:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:127:\"WP Briefing: Episode 31: Open Source &amp; Accessibility– Celebrating Global Accessibility Awareness Day With Guest Joe Devon\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:140:\"https://wordpress.org/news/2022/05/episode-31-open-source-accessibility-celebrating-global-accessibility-awareness-day-with-guest-joe-devon/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Mon, 16 May 2022 12:00:00 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:2:{i:0;a:5:{s:4:\"data\";s:7:\"Podcast\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:1;a:5:{s:4:\"data\";s:11:\"wp-briefing\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:53:\"https://wordpress.org/news/?post_type=podcast&p=12855\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:392:\"In the thirty-first episode of the WordPress Briefing, GAAD Co-Founder Joe Devon joins WordPress Executive Director Josepha Haden Chomphosy to discuss Global Accessibility Awareness Day and the role of open source in accessibility. Have a question you&#8217;d like answered? You can submit them to wpbriefing@wordpress.org, either written or as a voice recording. Credits Guest: Joe [&#8230;]\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:9:\"enclosure\";a:1:{i:0;a:5:{s:4:\"data\";s:0:\"\";s:7:\"attribs\";a:1:{s:0:\"\";a:3:{s:3:\"url\";s:60:\"https://wordpress.org/news/files/2022/05/WP-Briefing-031.mp3\";s:6:\"length\";s:1:\"0\";s:4:\"type\";s:0:\"\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:15:\"Chloe Bringmann\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:33186:\"\n<p>In the thirty-first episode of the WordPress Briefing, GAAD Co-Founder Joe Devon joins WordPress Executive Director Josepha Haden Chomphosy to discuss Global Accessibility Awareness Day and the role of open source in accessibility. </p>\n\n\n\n<p><em><strong>Have a question you&#8217;d like answered? You can submit them to <a href=\"mailto:wpbriefing@wordpress.org\">wpbriefing@wordpress.org</a>, either written or as a voice recording.</strong></em><br></p>\n\n\n\n<h2 id=\"credits\">Credits</h2>\n\n\n\n<ul><li>Guest: Joe Devon</li><li>Editor:&nbsp;<a href=\"https://profiles.wordpress.org/dustinhartzler/\">Dustin Hartzler</a></li><li>Logo:&nbsp;<a href=\"https://profiles.wordpress.org/beafialho/\">Beatriz Fialho</a></li><li>Production:&nbsp;<a href=\"https://profiles.wordpress.org/santanainniss/\">Santana Inniss</a> and <a href=\"https://profiles.wordpress.org/cbringmann/\">Chloé Bringmann</a></li><li>Song: Fearless First by Kevin MacLeod</li></ul>\n\n\n\n<h2>References</h2>\n\n\n\n<ul><li><a href=\"https://accessibility.day/about/\">About GAAD</a></li><li><a href=\"https://gaad.foundation/gaadpledge/\">GAAD Foundation Pledge</a></li><li><a href=\"https://www.who.int/health-topics/disability#tab=tab_1\">World Health Organization on Disability  </a></li><li><a href=\"https://en.wikipedia.org/wiki/The_dress\">The Dress Phenomenon</a></li><li>The Guardian on <a href=\"https://www.youtube.com/watch?v=7X_WvGAhMlQ\">Yanny or Laurel  </a></li><li><a href=\"https://josepha.blog/2019/05/24/empathy-vs-altruism-in-modern-leadership/\">Empathy vs. Altruism in Modern Leadership</a>, Josepha Haden Chomphosy </li><li><a href=\"https://webaim.org/projects/million/\">The WebAim Million 2022 Report</a></li><li><a href=\"https://make.wordpress.org/core/6-0/\">WordPress 6.0 Development Cycle </a></li><li><a href=\"https://europe.wordcamp.org/2022/\">WordCamp Europe 2022</a></li></ul>\n\n\n\n<h2>Transcript</h2>\n\n\n\n<span id=\"more-12855\"></span>\n\n\n\n<p>[<strong>Josepha Haden Chomphosy </strong>00:00:00]&nbsp;</p>\n\n\n\n<p>Hello everyone. And welcome to the WordPress Briefing. The podcast where you can catch quick explanations of the ideas behind the WordPress open source project, some insight into the community that supports it, and get a small list of big things coming up in the next two weeks. I&#8217;m your host Josepha Haden Chomphosy. Here we go!</p>\n\n\n\n<p>[<strong>Josepha Haden Chomphosy </strong>00:00:40]&nbsp;</p>\n\n\n\n<p>Y&#8217;all, we&#8217;ve got an absolutely jam-packed couple of weeks in WordPress. We&#8217;ve got events happening and releases shipping and contributor days being coordinated (I almost said contributor days being contributed). That&#8217;s also what they&#8217;re doing. I&#8217;ll share some of those highlights in today&#8217;s small list of big things, but I did want to specifically call out something that&#8217;s coming up this week on Thursday (May 19, 2022), and that something is Global Accessibility Awareness Day.</p>\n\n\n\n<p>The team of contributors over on the Accessibility team has participated in the Global Accessibility Awareness Day in the past. So I thought it would be interesting to hear from one of the co-founders of this particular day of awareness.</p>\n\n\n\n<p>[<strong>Josepha Haden Chomphosy </strong>00:01:27]&nbsp;</p>\n\n\n\n<p>All right. And with that, Joe Devin, would you like to tell us a little bit more about yourself?&nbsp;</p>\n\n\n\n<p><strong>[Joe Devon 00:01:34] </strong></p>\n\n\n\n<p>Sure. So I am the co-founder of Global Accessibility Awareness Day, which is a day that goes viral every year on the third Thursday of May. We typically have the Twitter reach on the GAAD hashtag on Twitter of 200 million users, which is, I think, pretty much their active user count. We stopped counting once we hit their daily active user count. </p>\n\n\n\n<p>And then, I am Chair of the GAAD Foundation, which we launched last year. And then I have a day job too, where I&#8217;m CEO and co-founder of Diamond, which is an inclusive digital agency that builds software accessibly by default. </p>\n\n\n\n<p>[<strong>Josepha Haden Chomphosy </strong>00:02:15]&nbsp;</p>\n\n\n\n<p>Wonderful. Well, we are so excited to have you today. I said we like it&#8217;s me and the mouse in my pocket—we in the WordPress community that&#8217;s going to listen to this. Super excited to have you today. So you mentioned GAAD, Global Accessibility Awareness Day. Last year was your 10th anniversary, which is very exciting, but like with so many good things, I hear it all started with a blog post and a blog post on WordPress, no less.</p>\n\n\n\n<p>So I&#8217;d love to hear about how GAAD evolved from that, with, as I understand it, your co-founder of Jennison (Asuncion). That must be where you met him, I assume.</p>\n\n\n\n<p><strong>[Joe Devon 00:02:51] </strong></p>\n\n\n\n<p>Yes. Yes. So what happened was I started a WordPress blog called <em>My SQL Talk</em>. So it&#8217;s a database blog, and I just thought it was a brilliant name. I mean, My SQL Talk, like that, should be super popular.</p>\n\n\n\n<p>And it probably had maybe ten people who ever looked. Um, and then my dad was getting older, and my dad was a survivor of the concentration camps, and he was a genius. He spoke ten languages. It, he was one of those people. That, when he walked into a room, he just commanded respect. You knew that there was history. I don&#8217;t know how to explain it really, but it was special when my dad walked into the room. And considering all of this that he suffered in his life, watching him get older and struggle, particularly with his banking, was very painful to see. And the bank wasn&#8217;t accessible, so I wrote this blog post proposing that we create a Global Accessibility Awareness Day.</p>\n\n\n\n<p>Sometimes I get these visions, and they never turn into anything. But while I think about it, I&#8217;m like, &#8220;all right, let&#8217;s write this blog post and this can definitely work. Right?&#8221; And then you finish the blog post to hit send, and you&#8217;re like, &#8220;this is not going to work.&#8221;</p>\n\n\n\n<p>But I wasn&#8217;t even smart enough to do social media on it. But fortunately, WordPress had an auto-tweet feature, and it tweeted it out, and Jennison Asuncion, my co-founder, happened to be around and not out that Saturday night. And he read the blog post, and he said, &#8220;this is a great idea. Let&#8217;s make it happen.&#8221;</p>\n\n\n\n<p>And we had two busy people, but we both had a community. He had the accessibility community, and I was building a tech scene in Los Angeles. And what I discovered is if you combine a great idea with the community, great things can happen. </p>\n\n\n\n<p><strong>[Josepha Haden Chomphosy 00:04:49]</strong></p>\n\n\n\n<p>Oh man, you&#8217;re speaking my language over here, helping people find their communities, knowing that community is the thing that is the lifeblood of society.</p>\n\n\n\n<p>That sounded like a tautology. It is not a tautology. You can have a society with an attempt to not have any sort of community around it, but I bet it doesn&#8217;t work very well. Well, that&#8217;s, that&#8217;s very interesting. And so you all just kind of talked through what that would look like, I assume in confidence, or that would have to take place, right? Or was it on Twitter in those days?&nbsp;</p>\n\n\n\n<p><strong>[Joe Devon 00:05:24]</strong> </p>\n\n\n\n<p>Oh, you could still look in the comments and see the back and forth of Jennison and a bunch of other people that got pretty involved with GAAD that are some legendary folks in there. It&#8217;s kind of mind-blowing because I dunno how, how you feel, but for me, when I used to code, uh, three months later, I&#8217;d look back at old code and be like, &#8220;oh, I suck,&#8221; you know, or write an email even and you look back on it a day later and are like &#8220;what a stupid email, how stupid am I?&#8221; You know?  But I look back on that one after ten years; I was scared to look at it because I&#8217;m like, it must&#8217;ve been really bad. But you know, it kind of held up, and exactly what I wrote in there happened &#8211; to my utter shock.</p>\n\n\n\n<p><strong>[Josepha Haden Chomphosy 00:06:06]</strong></p>\n\n\n\n<p>But also, it&#8217;s kinda nice, though, to look back and be like, &#8220;oh, I used to be much dumber.&#8221;</p>\n\n\n\n<p>Cause then you&#8217;re like, look how far I&#8217;ve come. I&#8217;m no longer that dumb. I&#8217;m a different kind of dumb now; good for me. I always hope to be a different kind of dumb as I go forward. </p>\n\n\n\n<p>So then, okay, so that was your ten-year anniversary last year. GAAD, in general, now has been going on for 11 years, and at the time of this recording, in a couple of weeks, but then probably a week when it finally publishes, you have your next, your next round of that going.</p>\n\n\n\n<p>I think it seems safe to assume that awareness of the need for accessibility has increased during that time, but we all know that the work of accessibility is ongoing. And so, I&#8217;m just curious to hear from your perspective if the awareness of the need for accessibility has generally started to permeate developer communities.</p>\n\n\n\n<p>And are you seeing more developer awareness around the need for accessibility in tech in general?&nbsp;</p>\n\n\n\n<p><strong>[Joe Devon 00:07:12]</strong> </p>\n\n\n\n<p>Yeah. You know, it&#8217;s not enough. It&#8217;s certainly improved a lot.  I keynoted a conference probably four years after GAAD started, maybe five, and I kind of assumed nobody would have heard of accessibility, and I was taken aback when I asked who had heard of it, and a good chunk of the room had. So even then, there had been a difference, and I&#8217;d say now I see accessibility mentioned a lot more in conferences and stuff. But when it comes to actually building it, there&#8217;s a tremendous amount of ignorance. There, there still needs to be a lot more awareness.</p>\n\n\n\n<p>And I think partially people are a little bit scared to dip their toe because they&#8217;re scared that they&#8217;re going to be told that &#8220;no, it&#8217;s not accessible,&#8221; or that they&#8217;re going to say the wrong word or offend somebody. So I&#8217;d say that there&#8217;s some degree of trepidation, but also developers, and it&#8217;s not just developers, designers, and product people. There&#8217;s so much to learn, and it&#8217;s like, &#8220;oh God, there&#8217;s another piece that I have to learn.&#8221; </p>\n\n\n\n<p>And I&#8217;m so glad that you invited me on this podcast because it&#8217;s the developers that, you know, I am a developer, not anymore, I haven&#8217;t touched code in years, but that&#8217;s where I came from. Right? This is my peach, right? Particularly WordPress folks, because I had done a fair bit of WordPress before I moved on to some other things. And, I think we have to talk about usability and understand that accessibility is so much more than how we look at disability.</p>\n\n\n\n<p>And if you don&#8217;t mind, I&#8217;m going to ask you a question. How do you think the typical WordPress developer or designer would define disability? </p>\n\n\n\n<p><strong>[Josepha Haden Chomphosy 00:09:05] </strong></p>\n\n\n\n<p>in the kinds of conversations that I&#8217;ve had over the years, it frequently has to do with visual things. Because it&#8217;s just screens all day, right? And that&#8217;s a primary area where our designers and developers really have made some effort.</p>\n\n\n\n<p>But my personal favorite sort of, of example, for like, when you&#8217;re looking at how to make sure that your products are accessible is, what, if you have to use your website, or you have to build your website using only one arm. Because that gives you an opportunity to kind of look at disability from a permanent standpoint.</p>\n\n\n\n<p>Like if you have lost permanent use of one arm, but also gives you an opportunity to look at the temporary options for that sort of lack of mobility. Like you&#8217;re a mother with an infant, and so you have to be able to, you know, get your stuff done with one arm. And so I know that we paid a bunch of attention to screen readers and what works in not way back in 2018 and 2019 did a lot of work with. Literally zero screen. And can you still do the thing that you need to do, which was incredibly difficult. And I was really excited to see what our developers came up with around that. But I think that that is quite a bit of that discussion as we&#8217;re going through it from the beginning to the&nbsp;end.</p>\n\n\n\n<p><strong>[Joe Devon 00:10:27] </strong></p>\n\n\n\n<p>Yeah. I mean, that&#8217;s a great answer, and you definitely understand some of the nuances way better than I think that the average creator, digital product creator, I&#8217;m including the, you know, the product people, the designers, and the developers.&nbsp;</p>\n\n\n\n<p><strong>[Josepha Haden Chomphosy 00:10:42] </strong></p>\n\n\n\n<p>We&#8217;re very fortunate to have more than just developers in WordPress.</p>\n\n\n\n<p><strong>[Joe Devon 00:10:50]  </strong></p>\n\n\n\n<p>The reason I bring this up is that the WHO (World Health Organization) had to; they&#8217;re the ones that did massive research across the globe. And they had to, they had to come up with a definition, and in their definition, they needed to draw a line. Typically, I don&#8217;t remember the exact thing cause it&#8217;s a 350-page report, and I kept looking for where they defined it again.</p>\n\n\n\n<p>It was a little hard to find, but essentially it&#8217;s if there&#8217;s a major disability or a disability that impacts some significant portion of your day-to-day activities. And that&#8217;s really great when you&#8217;re trying to do a report on how many disabilities there are out there; what percentage of the population has a disability?</p>\n\n\n\n<p>And their figures are something like 15% of the population has a disability, which is a huge number. But at the same time, they also mentioned that 2.2 billion people have a visual impairment. And we also know that over 33% of the population is over 50, and I&#8217;m included in that population. And I can say that when you&#8217;re over 50, you know, I&#8217;ve got clouds in my eyes.</p>\n\n\n\n<p>I don&#8217;t know where they came from, but they definitely make it harder to see. When I&#8217;m in a restaurant, I can&#8217;t focus on the person across from me the same way. My hearing is not the same, and anybody over 50 is going to have certain impairments and won&#8217;t see as well; color contrast issues are a big deal.</p>\n\n\n\n<p>Being able to raise the font is a big deal. And I think that accessibility is connected in most people&#8217;s minds with disability. And they&#8217;ll attach that to something like being blind or being deaf or hard of hearing or having a missing limb or having some other kind of disability. </p>\n\n\n\n<p>And, as a result, they&#8217;re like, &#8220;well, I don&#8217;t even know any people in that category possibly,&#8221; and as a result, they&#8217;re like, &#8220;well, how important is this?&#8221; Yes. They might feel guilty. I should do the right thing. This is the right thing to do. But honestly, like how much money should I spend on it? How much, what percentage of my time should I spend on it?</p>\n\n\n\n<p>And it&#8217;s because they don&#8217;t realize that everybody has different abilities. And so, I&#8217;m starting to go away from even talking about disabilities and asking people to remember that all of us perceive things differently. </p>\n\n\n\n<p>Do you remember the gold dress where they were trying to say, what color is this dress? Is it gold and white or blue and black? And it is blue and black, but to me, all I see is gold and white. And then there was Laurel or Yanny. Do you remember that?. And some people heard it, and typically older people heard it as Laurel, and I&#8217;ve, and I do this in some of my presentations. I play that, that sound. And usually, it&#8217;s Laurel for me, but sometimes it&#8217;s Yanny. Even personally, it changes. </p>\n\n\n\n<p>And so, we have a totally different perception. Now think about memory. There&#8217;s a different kind of blindness. If you try and remember, let&#8217;s say a relative or a friend that is no longer. How well do you see that picture?</p>\n\n\n\n<p>Because for me, it is very, very vague, but for some people, they say, and I&#8217;ve been asking people, and I&#8217;d love your answer as well. How vivid is it? And some people say, I can read the, I can see the pattern on the shirt. It&#8217;s as vivid as if I see with opening my eyes, seeing, you know, the regular in front of me, and I can even read a name tag in the memory.</p>\n\n\n\n<p>And I&#8217;m like, Woah, so maybe I&#8217;m blind in a way. Right? So how do you see it? How do you remember things?&nbsp;</p>\n\n\n\n<p><strong>[Josepha Haden Chomphosy 00:14:42] </strong></p>\n\n\n\n<p>Oh, I&#8217;m a, I&#8217;m a real visual person and a tactile person. And so, like if I interacted with someone, I&#8217;m very likely to be able to picture, like, recreate that mental picture pretty well in my mind. I recently, very recently, met some of my first people in that executive leadership space who were like, yeah, I don&#8217;t, I don&#8217;t visualize things.</p>\n\n\n\n<p>And I was like, what are you, how do you do this work? Because like, you have to be able to do that. And they were like, no, I don&#8217;t have mental pictures.&nbsp;</p>\n\n\n\n<p><strong>[Joe Devon 00:15:13] </strong></p>\n\n\n\n<p>Some people don&#8217;t have an inner dialogue.&nbsp;</p>\n\n\n\n<p><strong>[Josepha Haden Chomphosy 00:15:17] </strong></p>\n\n\n\n<p>I don&#8217;t understand that either,&nbsp;</p>\n\n\n\n<p><strong>[Joe Devon 00:15:19] </strong></p>\n\n\n\n<p>Me either. So accessibility studies all of these differences with respect to how you&#8217;re presenting all of this information.</p>\n\n\n\n<p>And if you don&#8217;t pay attention to accessibility, you&#8217;re really just missing out. And then there&#8217;s colorblindness. If you&#8217;re creating something like slack that has an online/offline indicator, and you only use red and green for people who are colorblind, they see gray and gray. And so what I&#8217;m trying to teach the community with digital product creators is that no, you cannot ignore it.</p>\n\n\n\n<p>You can ignore accessibility, but then you&#8217;re not good at your job. I mean, I don&#8217;t mean to say it in an offensive way, but you&#8217;re not good at your job if you&#8217;re unaware. If you break a rule on purpose, great. But if you don&#8217;t know the rule, it&#8217;s just a lack of craft, and you absolutely should make it a priority.</p>\n\n\n\n<p>And you&#8217;re not doing it as a charity. You&#8217;re doing it because you care about your users, and you care about your craft, and you want to build things well, and it&#8217;s a necessity. And I think that this is the kind of message that our community needs to hear.&nbsp;</p>\n\n\n\n<p><strong>[Josepha Haden Chomphosy 00:16:31]</strong></p>\n\n\n\n<p>I want to touch on something that you sort of brought up a bit, um, at the start of the answer there.</p>\n\n\n\n<p>So you brought up the concept of usability. And in the last time that I did a podcast about accessibility, I defined accessibility as a subset of usability. Do you think that if we were to consistently draw that line for people so that it&#8217;s not just like accessibility is this thing that you should do outside of usability?</p>\n\n\n\n<p>If we were to more consistently draw that line, do you think that that would help people to see and understand better that its shades of existence, usability, and accessibility?  &nbsp;</p>\n\n\n\n<p><strong>[Joe Devon 00:17:10] </strong></p>\n\n\n\n<p>Oh, 100%, a hundred percent. And in my company, we kind of realized that that&#8217;s exactly what we have to do. We have to see this as usability.</p>\n\n\n\n<p>And I don&#8217;t, we talk about accessibility a lot, but I don&#8217;t want to. It&#8217;s part of the plumbing for us. We&#8217;ve made it part of the plumbing, and I can tell you it&#8217;s a struggle to take accessibility and make it part of an organization, even when you&#8217;re bringing it top-down, believe it or not. For our teams, particularly the designers, they are blown away by what they&#8217;re learning because they&#8217;re improving their craft.</p>\n\n\n\n<p>And design is typically where there&#8217;s a struggle to get accessibility accepted because there seems to be a very strong idea of what a design should look like. And I think it&#8217;s really about the approach because UX and design it&#8217;s all about empathy for people. And when you approach it, not as, even though empathy should mean that, that, you know, do the right thing at the same time, it&#8217;s more about empathy for your user, and your user includes so much more than just people with disabilities that you haven&#8217;t run into somebody that has that disability and therefore you build it better, and it&#8217;s, it&#8217;s completely blown their mind. They love it. They love doing it. And I&#8217;m not hiring people with accessibility coming in. We&#8217;re training them to work accessibly. </p>\n\n\n\n<p><strong>[Josepha Haden Chomphosy 00:18:34] </strong></p>\n\n\n\n<p>So I think it&#8217;s interesting that you talk about empathy as part of being able to make sure that you&#8217;re creating something that&#8217;s accessible because I actually feel like empathy is. Like it&#8217;s being considered this gold standard for many, many things right now. And I think it actually is more harmful in the long run than instead making altruistic choices.</p>\n\n\n\n<p>And so, I have a blog post that I will link in our show notes that will kind of help everybody see more fully my concept there. But when you rely on empathy, you do kind of have to rely on one, being able to run into all of the issues you were mentioning. You have to know people who have problems in order to know that the problems exist.</p>\n\n\n\n<p>And then you also kind of have to assume that once you have willingly put yourself into the discomfort of that kind of disability, whatever, wherever it exists on that spectrum, your experience of that discomfort is the same as someone who lives with it. And I just don&#8217;t think that we can necessarily do that.</p>\n\n\n\n<p>I always think that trying to do the altruistic thing, like doing your research and figuring out what it is and trying to make decisions on behalf of other people as best you can, which is a terrible thing. Still, like decisions that take into account the experiences that people are sharing with you and then going to them and saying, &#8220;does this make that experience better or worse?&#8221; is the more sustainable option from my perspective, this is specifically leadership. Still, I think it&#8217;s true for accessibility as well, and probably product design as a whole, but it&#8217;s very difficult. Like people really feel like they understand the concept of empathy right now. And I do think that sometimes that leads us down the wrong path for things.</p>\n\n\n\n<p>What&#8217;s your thought on that? I think you kind of agree based on what your answer was&nbsp;</p>\n\n\n\n<p><strong>[Joe Devon 00:20:33]</strong> </p>\n\n\n\n<p>Oh, no, absolutely. And you know, we, you, can&#8217;t never about us without us, as the common saying, and we&#8217;ve gathered a group of a hundred people with a wide variety of disabilities for research. Whenever we do any UX and research, and sometimes we&#8217;re asked to just do research projects, we go out and ask the users.</p>\n\n\n\n<p>We had some really interesting companies approach us to do innovation and accessibility, and they had strong assumptions. We looked at the assumptions and agreed with it, but we&#8217;re like, all right, they were smart. They said, &#8220;vet this with users for us, please,&#8221; because they didn&#8217;t want to gather their own group.</p>\n\n\n\n<p>We vetted with users, and we&#8217;re blown away, always blown away because there are so many things you just don&#8217;t know unless you&#8217;ve lived with a particular disability. You can&#8217;t guess, and you&#8217;ve got to speak to your users and a wide variety of them. &nbsp;</p>\n\n\n\n<p><strong>[Josepha Haden Chomphosy 00:21:30]</strong></p>\n\n\n\n<p>Yes, absolutely. Absolutely. What role does open source play in expanding accessibility, either in specifically the digital space or just accessibility in general?</p>\n\n\n\n<p><strong>[Joe Devon 00:21:42] </strong></p>\n\n\n\n<p>I guess if the question is, what role does it play? I would say the role it plays is it is, unfortunately, it makes accessibility worse because, for the most part open source is not very accessible. And it&#8217;s a personal passion of mine, so I&#8217;m really glad that you brought that up. </p>\n\n\n\n<p>You know, it is so bizarre. You write a blog post and then it goes viral, and it goes viral every year to a degree that you can&#8217;t even believe it, that all these companies that you know are running events. Privately, publicly talking about it. And then you get all these people thanking you for what you&#8217;ve done year after year.</p>\n\n\n\n<p>And then one year, you read on Twitter, The Blind Onion; I&#8217;m sure you&#8217;re familiar with The Onion, the satirical clip, there&#8217;s the Blind Onion. And they tweet out, &#8220;Now that Global Accessibility Awareness Day is over, we look forward to 364 days of global accessibility oblivion.&#8221; And that really hurt at the time, but at the same time, and I was told to ignore it, don&#8217;t worry about it, but I&#8217;m like, no, this is coming from a place of pain.</p>\n\n\n\n<p>And the point of GAAD was to make a difference. It wasn&#8217;t too to just give everybody an opportunity to say, &#8220;Hey, look at what we&#8217;re doing,&#8221; and then not make a difference. So, as a result of that, I started to think about, well, where are we with this? And, and so I&#8217;ve created a state of accessibility report that through my company, we&#8217;re able to run for a few years, and it&#8217;s not, you know, the state is not great.</p>\n\n\n\n<p>And I&#8217;m like, well, what can we do to change things? So, as a result of all of this, I really wanted to figure out, well, what can we do to make sure that GAAD does make a difference? And so, I came up with the idea of the GAAD pledge, which is specifically meant for open source frameworks. </p>\n\n\n\n<p>And the idea of the GAAD pledge is that an open source framework, when they are ready, takes the pledge to make accessibility a core value of the framework. Now, terms of what that actually entails are different for every single project because every project is unique. We did create a bit of a framework, which had the idea of saying, okay, you&#8217;re going to, first of all, create an accessibility statement that says that this framework is going to conform to whatever, WCAG, which is Web Content Accessibility Guidelines, to whatever WCAG level is decided and is appropriate for the framework. That there&#8217;s going to be documentation for anybody that is downloading this piece of open source project and trying to implement it, that there should be guidelines for them, that all of the examples should be accessible. </p>\n\n\n\n<p>It&#8217;s really important because even the frameworks that try to pay attention to accessibility. You&#8217;ll often see that people from the community will provide examples, and they&#8217;re inaccessible. And it&#8217;s really sad when you see that because so many people are just copy-pasting. That&#8217;s typically how it works, and they&#8217;re going to copy-paste something bad. So putting a statement around it, I think, would be really great.</p>\n\n\n\n<p>And what we&#8217;re hoping to see is that lots and lots of big open source communities decide to take the pledge. And then it&#8217;ll sort of be table stakes that any new open source projects as well look, all of these frameworks that made it, they took the pledge and therefore we should take the pledge as well.</p>\n\n\n\n<p>And so the very first year, we had React Native take the pledge, and they put a lot of effort into their accessibility. The second group to take it was Ember.js, and they always put a lot of effort into their accessibility, and they continued that effort. We&#8217;re about to announce the next one, but we&#8217;re still two weeks away.</p>\n\n\n\n<p>So I can&#8217;t say anything yet, but yeah, we&#8217;re, uh, we&#8217;re hoping for a lot more uptake on, on the gap pledge because it, it affects so many people downstream. WordPress&#8217;s what percent of the web right now? 43%? So there you go. That&#8217;s so many people.&nbsp;</p>\n\n\n\n<p><strong>[Josepha Haden Chomphosy 00:25:57] </strong></p>\n\n\n\n<p>So many people. Yeah, fun fact Gutenberg, our current rewriting of the editing experience in WordPress, primarily uses React. And so, I&#8217;m glad to hear that they have taken that pledge as well. </p>\n\n\n\n<p>As with any good cooking, it starts with good&nbsp;ingredients.</p>\n\n\n\n<p><strong>[Joe Devon 00:26:12] </strong></p>\n\n\n\n<p>You said it. That was great. I wish I was a cook, though.</p>\n\n\n\n<p><strong>[Josepha Haden Chomphosy 00:26:23] </strong></p>\n\n\n\n<p>I love it. All right. Let&#8217;s what keeps you up at night when it comes to the state of accessibility?&nbsp;</p>\n\n\n\n<p><strong>[Joe Devon 00:26:29] </strong></p>\n\n\n\n<p>What keeps me up at night is how to move the needle. It is such a big thing to change. And there are so many angles that you can approach this with, but at the end of the day, it&#8217;s, it&#8217;s a monster.</p>\n\n\n\n<p>It&#8217;s a monster. There are so many legacy sites out there. If you look at WebAIM, they do a yearly report on the state of accessibility as well. They call it the WebAIM Million, and they&#8217;re typically seeing 97% inaccessible, 98%. It goes up and down a little bit every year. And that&#8217;s, that&#8217;s just a huge boat to move.</p>\n\n\n\n<p>I think we need to at least get the newer, uh, newer websites and mobile apps to move. And what we&#8217;ve seen in our state of accessibility report is that only the very top companies seem to put in the effort to make their products accessible. There is a big push with the enterprise companies to do it.</p>\n\n\n\n<p>The CEOs are starting to talk about it, but what we need is the entire culture of software development to change. Or I should even say digital product development change and to move that boat is massive. And that&#8217;s I put it in my tagline in my email like that&#8217;s my mission in life, and I hope to achieve it before I die.</p>\n\n\n\n<p>So that keeps me up at night.</p>\n\n\n\n<p><strong>[Josepha Haden Chomphosy 00:27:52] </strong></p>\n\n\n\n<p>I think that would keep me up at night as well. I mean, it seems like you are really just personally mission-driven and impact-driven. Do you feel like, in the event that the work that you&#8217;ve accomplished so far is what you accomplish, you feel still like you&#8217;ve had an impact?</p>\n\n\n\n<p>I feel like you have had&nbsp;an impact. </p>\n\n\n\n<p><strong>[Joe Devon 00:28:13] </strong></p>\n\n\n\n<p>I&#8217;m not one of those people that tries to have a legacy or like tries to focus on what my impact is and all of that. I just try and do good work. And hopefully, it just shows at the end of the day. I&#8217;m just trying to have the impact without the accolades.</p>\n\n\n\n<p><strong>[Josepha Haden Chomphosy 00:28:34]</strong></p>\n\n\n\n<p>I get it. Well, Joe, thank you so much for joining us here on this episode of WP Briefing. You have been a delight to chat with.</p>\n\n\n\n<p><strong>[Joe Devon 00:28:42]</strong></p>\n\n\n\n<p>Likewise, it&#8217;s really been a pleasure to meet you, and uh, and I appreciate the opportunity.</p>\n\n\n\n<p><strong>[Josepha Haden Chomphosy 00:28:54] </strong></p>\n\n\n\n<p>And now it&#8217;s time for our smallest of big things. As I mentioned at the start, it is packed. Number one tomorrow, May 17th, RC3. So one of the final RCs that we&#8217;re going to have for the WordPress 6.0 release, unless something goes horribly, horribly wrong, which I don&#8217;t think it will. </p>\n\n\n\n<p>And then, two days after that, Global Accessibility Awareness Day, as I mentioned, will be on May 19th. So, this coming Thursday. </p>\n\n\n\n<p>And then next week, we have the 6.0 release. We have the WordPress 6.0 release on May 24th. </p>\n\n\n\n<p> Three days after that, WordPress turns 19 on May 27th, starting its final teenage year before we turn twenty in 2023. So that was the rapid-fire dance card for the next two weeks.</p>\n\n\n\n<p>The stuff that is happening with and around WordPress for everyone to know. As a heads up, also, many people are headed to WordCamp Europe in Porto(, Portugal). The first week of June, I am going to do a live from WordCamp Europe episode. It will not be live. I&#8217;ll just record it live. And so. You know you&#8217;ll get to hear me with my hoarsest voice and maybe singing to my computer. Cause that almost always happens at these things. </p>\n\n\n\n<p>And that, my friends, is your small list of big things. Thank you for tuning in today for the WordPress Briefing. I&#8217;m your host, Josepha Haden Chomphosy. And I&#8217;ll see you again in a couple of weeks.</p>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:30:\"com-wordpress:feed-additions:1\";a:1:{s:7:\"post-id\";a:1:{i:0;a:5:{s:4:\"data\";s:5:\"12855\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:7;a:6:{s:4:\"data\";s:69:\"\n		\n		\n		\n		\n		\n				\n		\n		\n		\n		\n		\n\n					\n										\n					\n		\n		\n			\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:4:{s:0:\"\";a:6:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:65:\"WordPress 6.0 Release Candidate 2 (RC2) Now Available for Testing\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:99:\"https://wordpress.org/news/2022/05/wordpress-6-0-release-candidate-2-rc2-now-available-for-testing/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Tue, 10 May 2022 18:06:09 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:5:{i:0;a:5:{s:4:\"data\";s:11:\"Development\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:1;a:5:{s:4:\"data\";s:8:\"Releases\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:2;a:5:{s:4:\"data\";s:3:\"6.0\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:3;a:5:{s:4:\"data\";s:11:\"development\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:4;a:5:{s:4:\"data\";s:8:\"releases\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:35:\"https://wordpress.org/news/?p=12840\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:171:\"WordPress 6.0 Release Candidate 2 is now available for testing! You can \ndownload and help test RC2 in three ways. You can also help translate WordPress to 100+ languages.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:11:\"Dan Soschin\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:4830:\"\n<p>The next release candidate for WordPress 6.0 is now available!&nbsp;</p>\n\n\n\n<p>WordPress 6.0 is scheduled for release on May 24th, 2022 &#8211; just two weeks from today.</p>\n\n\n\n<p>“Release Candidate” means that this version of WordPress is ready for release! Since the WordPress ecosystem includes thousands of plugins and themes, it is important that everyone within the WordPress community check to see if anything was missed along the way. That means the project would love your help.</p>\n\n\n\n<p>Thank you to everyone who has contributed towards testing and logging issues to help make WordPress 6.0 stable (and awesome). WordPress still needs your help testing, especially theme and plugin developers.</p>\n\n\n\n<p>Since the RC1 release on May 3rd, 2022, there have been approximately 40 issues resolved in <a href=\"https://github.com/WordPress/gutenberg/commits/wp/6.0\">Gutenberg</a> and <a href=\"https://core.trac.wordpress.org/query?status=accepted&amp;status=closed&amp;changetime=05%2F03%2F2022..05%2F10%2F2022&amp;resolution=fixed&amp;milestone=6.0&amp;col=id&amp;col=summary&amp;col=status&amp;col=milestone&amp;col=owner&amp;col=type&amp;col=priority&amp;order=id\">Trac</a>.</p>\n\n\n\n<h1>Installing RC2</h1>\n\n\n\n<p><strong>This version of the WordPress software is under development</strong>. Please do not install, run, and test this version of WordPress on a production or mission-critical website. Instead, it is recommended that you RC2 on a test server and site.&nbsp;</p>\n\n\n\n<p>You can test WordPress 6.0 RC2 in three ways:</p>\n\n\n\n<ul><li><strong>Option 1: </strong>Install and activate the <a href=\"https://wordpress.org/plugins/wordpress-beta-tester/\">WordPress Beta Tester</a> plugin (select the “Bleeding edge” channel and “Beta/RC Only” stream).</li></ul>\n\n\n\n<ul><li><strong>Option 2: </strong>Direct download the <a href=\"https://wordpress.org/wordpress-6.0-RC2.zip\">release candidate version here (zip)</a>.</li></ul>\n\n\n\n<ul><li><strong>Option 3:</strong> When using WP-CLI to upgrade from Beta 1, 2, 3, 4, or RC1 on a case-insensitive filesystem, please use the following command:<br><code>wp core update --version=6.0-RC2</code></li></ul>\n\n\n\n<p>Additional information on the full <a href=\"https://make.wordpress.org/core/6-0/\">6.0 release cycle is available here</a>.</p>\n\n\n\n<p>Check the <a href=\"https://make.wordpress.org/core/\">Make WordPress Core blog</a> for <a href=\"https://make.wordpress.org/core/tag/dev-notes+6-0/\">6.0-related developer notes</a> in the coming weeks, which will detail all upcoming changes.</p>\n\n\n\n<h1>Plugin and Theme Developers</h1>\n\n\n\n<p>All plugin and theme developers should test their respective extensions against WordPress 6.0 RC2 and update the “<em>Tested up to”</em> version in their readme file to 6.0. If you find compatibility problems, please be sure to post detailed information to the <a href=\"https://wordpress.org/support/forum/alphabeta/\">support forums</a> so that these items can be investigated further prior to the final release date of May 24th.</p>\n\n\n\n<p>Review the <a href=\"https://make.wordpress.org/core/2022/05/03/wordpress-6-0-field-guide/\"><em>WordPress 6.0 Field Guide</em></a> for more details on this release.</p>\n\n\n\n<h1>Translate WordPress</h1>\n\n\n\n<p>Do you speak a language other than English? <a href=\"https://translate.wordpress.org/projects/wp/dev\">Help translate WordPress into more than 100 languages</a>.</p>\n\n\n\n<h1>How to Help Test WordPress</h1>\n\n\n\n<p>Testing for issues is critical for stabilizing a release throughout its development. Testing is also a great way to contribute to WordPress. If you are new to testing, check out this <a href=\"https://make.wordpress.org/test/2022/04/12/help-wanted-test-wordpress-6-0/\">detailed guide</a> that will walk you through how to get started.</p>\n\n\n\n<p>If you think you have run into an issue, please report it to the <a href=\"https://wordpress.org/support/forum/alphabeta/\">Alpha/Beta area</a> in the support forums. If you are comfortable writing a reproducible bug report, you can <a href=\"https://core.trac.wordpress.org/newticket\">file one on WordPress Trac</a>. This is also where you can find a list of <a href=\"https://core.trac.wordpress.org/tickets/major\">known bugs</a>.</p>\n\n\n\n<hr class=\"wp-block-separator has-alpha-channel-opacity\" />\n\n\n\n<h2>An RC2 Haiku for You</h2>\n\n\n\n<p>Anticipation<br>Sprinting toward G/A now<br>Please — test, translate — thanks!</p>\n\n\n\n<hr class=\"wp-block-separator has-alpha-channel-opacity\" />\n\n\n\n<p>Thank you to the following contributors for collaborating on this post: <a href=\'https://profiles.wordpress.org/dansoschin/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>dansoschin</a>, <a href=\'https://profiles.wordpress.org/priethor/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>priethor</a>.&nbsp;&nbsp;</p>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:30:\"com-wordpress:feed-additions:1\";a:1:{s:7:\"post-id\";a:1:{i:0;a:5:{s:4:\"data\";s:5:\"12840\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:8;a:6:{s:4:\"data\";s:60:\"\n		\n		\n		\n		\n		\n				\n		\n		\n\n					\n										\n					\n		\n		\n			\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:4:{s:0:\"\";a:6:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:37:\"The Month in WordPress – April 2022\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:69:\"https://wordpress.org/news/2022/05/the-month-in-wordpress-april-2022/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 05 May 2022 15:01:33 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:2:{i:0;a:5:{s:4:\"data\";s:18:\"Month in WordPress\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:1;a:5:{s:4:\"data\";s:22:\"the month in wordpress\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:35:\"https://wordpress.org/news/?p=12816\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:329:\"This past month saw a lot of preparation work for WordPress 6.0, due to release on 24 May 2022. This major release brings exciting improvements – read on to find out more about the latest happenings in the WordPress project. WordPress 6.0 Release Candidate 1 The first release candidate (RC1) for WordPress 6.0 is now [&#8230;]\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:14:\"rmartinezduque\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:10623:\"\n<p>This past month saw a lot of preparation work for WordPress 6.0, due to release on 24 May 2022. This major release brings exciting improvements – read on to find out more about the latest happenings in the WordPress project.</p>\n\n\n\n<hr class=\"wp-block-separator has-css-opacity\" />\n\n\n\n<h2>WordPress 6.0 Release Candidate 1</h2>\n\n\n\n<p><strong>The first release candidate (RC1) for WordPress 6.0 is now available for download</strong>. Help improve the project by testing and translating this version to non-English languages. Check out the RC1 <a href=\"https://wordpress.org/news/2022/05/wordpress-6-0-release-candidate-1/\">release post</a> to learn what’s new and how to contribute. For a more in-depth look at the upcoming changes, you can refer to the <a href=\"https://make.wordpress.org/core/2022/05/03/wordpress-6-0-field-guide/\">WordPress 6.0 Field Guide</a>.</p>\n\n\n\n<p>WordPress 6.0 is packed with all kinds of improvements for everyone. It brings new blocks, <a href=\"https://make.wordpress.org/core/2022/04/20/wordpress-6-0-accessibility-improvements/\">accessibility enhancements</a>, refined design tools, the ability to switch theme styles easily, multi-block partial text selection, and a new block locking interface, to name a few of its highlights.</p>\n\n\n\n<div class=\"wp-container-8 wp-block-buttons\">\n<div class=\"wp-block-button aligncenter\"><a class=\"wp-block-button__link\" href=\"https://wordpress.org/news/2022/05/episode-30-a-sneak-peek-at-wordpress-6-0/\" target=\"_blank\" rel=\"noreferrer noopener\"><strong><strong>Listen to the latest </strong><strong>WP Briefing episode</strong><strong> for a sneak peek into the exciting features included in WordPress 6.0.</strong></strong></a></div>\n</div>\n\n\n\n<h2>Gutenberg releases: Versions 13.0 and 13.1 are here</h2>\n\n\n\n<ul><li><a href=\"https://make.wordpress.org/core/2022/04/14/whats-new-in-gutenberg-13-0-14-april/\">Gutenberg 13.0</a> shipped on April 14, 2022, and introduced the final updates that will be part of WordPress 6.0. These include an improved editor experience (with the ability to select text across blocks), better responsive blocks, and prominently exposed block patterns.</li><li><a href=\"https://make.wordpress.org/core/2022/04/28/whats-new-in-gutenberg-13-1-27-april/\">Gutenberg 13.1</a> landed on April 27, 2022. This version adds border support to the Columns block and accessibility and Comment block improvements.</li></ul>\n\n\n\n<div class=\"wp-container-9 wp-block-buttons\">\n<div class=\"wp-block-button aligncenter\"><a class=\"wp-block-button__link\" href=\"https://make.wordpress.org/core/tag/gutenberg-new/\" target=\"_blank\" rel=\"noreferrer noopener\"><strong><strong>Follow the </strong><strong>#gutenberg-new</strong><strong> posts for more details on the latest updates.</strong></strong></a></div>\n</div>\n\n\n\n<h2>Team updates: Updated guidelines for in-person events, redesign of the Gutenberg page, and more</h2>\n\n\n\n<ul><li>The Community team announced <a href=\"https://make.wordpress.org/community/2022/04/21/announcement-updated-covid-19-guidelines-for-official-wordpress-events/\">updated Covid-19 guidelines</a> for official WordPress events.</li><li>The <a href=\"https://make.wordpress.org/meta/2022/04/12/gutenberg-landing-page-kick-off/\">redesign of the Gutenberg landing page</a> on WordPress.org is nearing completion.</li><li>#WPDiversity announced new meeting times for Asia-Pacific (APAC) areas. You can express your interest <a href=\"https://make.wordpress.org/community/2022/04/22/wpdiversity-is-expanding-to-apac/\">in this post</a>.</li><li>The Training team plans to <a href=\"https://make.wordpress.org/training/2022/04/19/migrating-contributor-training-to-learn-wordpress/\">migrate the Contributor Training materials</a> to Learn WordPress. This move will help consolidate all the community-based training content in one place.</li><li>All learners on Learn WordPress can now enjoy using <a href=\"https://make.wordpress.org/training/2022/04/07/demo-sites-for-learn-wordpress-users/\">a live WordPress demo site</a> as they go through courses on the site.</li><li>The first stable <a rel=\"noreferrer noopener\" href=\"https://make.wordpress.org/core/2022/04/18/version-1-0-0-of-the-performance-lab-plugin-published/\" target=\"_blank\">version 1.0.0</a> of the <a href=\"https://wordpress.org/plugins/performance-lab/\">Performance Lab</a> plugin was released.</li><li>Read the latest edition of the <a href=\"https://make.wordpress.org/community/2022/04/21/meetup-organizer-newsletter-april-2022/\">Meetup Organizer Newsletter</a>.</li><li>Everyone is welcome and encouraged to join the new <a href=\"https://make.wordpress.org/photos/\">Photo Directory team</a> meetings. They are held on the first Friday of every month at 14:00 UTC in the <a rel=\"noreferrer noopener\" href=\"https://wordpress.slack.com/messages/photos\" target=\"_blank\">#photos</a> channel of the Make WordPress Slack.</li><li>The Performance team published a <a href=\"https://make.wordpress.org/core/2022/04/12/follow-up-on-webp-by-default-proposal/\">follow-up post</a> with the next steps on the WebP proposal.</li><li>Check out the <a href=\"https://make.wordpress.org/design/2022/04/25/design-share-apr-11-22/\">projects</a> the Design team contributed to over the past couple of weeks.</li><li>Official Featured and Beta plugins now limit <a href=\"https://make.wordpress.org/plugins/2022/04/15/featured-beta-plugins-now-limit-changes/\">ownership and committer changes</a>.</li><li>The April 2022 edition of the <a href=\"https://make.wordpress.org/polyglots/2022/04/22/polyglots-monthly-newsletter-april-2022/\">Polyglots Monthly Newsletter</a> was published.</li><li>The latest edition of People of WordPress features <a href=\"https://wordpress.org/news/2022/04/people-of-wordpress-meher-bala/\">Meher Bala</a>, a frontend web developer and community builder from India.</li><li>The <a rel=\"noreferrer noopener\" href=\"https://wordpress.slack.com/archives/C0FRG66LR\" target=\"_blank\">#props</a> channel of the Make WordPress Slack is now connected to the WordPress.org profile activity! This way when you give props, it will be included on your WordPress.org profile and the profile of those you mention. This change is part of a <a href=\"https://make.wordpress.org/project/2022/03/16/proposal-to-remove-spam-dormant-five-for-the-future-pledges/\">larger project</a> that will help credit more non-code contributions.</li></ul>\n\n\n\n<div class=\"wp-container-10 wp-block-buttons\">\n<div class=\"wp-block-button\"><a class=\"wp-block-button__link\" href=\"https://make.wordpress.org/community/2022/04/11/return-to-in-person-events-share-your-challenges/\" target=\"_blank\" rel=\"noreferrer noopener\"><strong>How do you feel about in-person WordPress gatherings? The Community team wants to hear about the challenges in returning to these events.</strong></a></div>\n</div>\n\n\n\n<h2>Open feedback/testing calls</h2>\n\n\n\n<ul><li>Following this <a href=\"https://make.wordpress.org/updates/2021/03/16/proposal-a-wordpress-project-contributor-handbook/\">proposal</a> for a WordPress Project Contributor Handbook, Executive Director Josepha Haden opened a <a href=\"https://make.wordpress.org/project/2022/04/29/discussion-contrib-handbook-part-2/\">round of discussions</a> to share feedback on the various handbook sections.</li><li>Version 19.8 of WordPress for <a href=\"https://make.wordpress.org/mobile/2022/05/02/call-for-testing-wordpress-for-android-19-8/\">Android</a> and <a href=\"https://make.wordpress.org/mobile/2022/05/02/call-for-testing-wordpress-for-ios-19-8/\">iOS</a> is available for testing.</li><li>Join the 14th testing call of the Full Site Editing (FSE) Outreach program – “<a href=\"https://make.wordpress.org/test/2022/04/28/fse-program-testing-call-14-rallying-recipe-reviewers/\">Rallying Recipe Reviewers</a>.” This call focuses on testing blocks that help recipe authors make their recipe blogs more interactive. Leave your feedback by May 18, 2022.</li></ul>\n\n\n\n<div class=\"is-content-justification-center wp-container-11 wp-block-buttons\">\n<div class=\"wp-block-button aligncenter\"><a class=\"wp-block-button__link\" href=\"https://make.wordpress.org/test/2022/04/12/help-wanted-test-wordpress-6-0/\" target=\"_blank\" rel=\"noreferrer noopener\"><strong><strong>Are you interested in helping test out new WordPress 6.0 features but don’t know where to start? This </strong><strong>detailed guide</strong><strong> will walk you through how to get started.</strong></strong></a></div>\n</div>\n\n\n\n<h2>Get ready for WordCamp Europe in Porto</h2>\n\n\n\n<ul><li>We are four weeks away from <a href=\"https://central.wordcamp.org/news/2022/05/join-the-european-wordpress-community-in-porto-portugal/\">WordCamp Europe</a>. After being postponed twice due to the pandemic, the WordPress event is taking place in Porto, Portugal, on 2-4 June 2022. Check out the <a href=\"https://europe.wordcamp.org/2022/schedule/\">schedule</a> and get your <a href=\"https://europe.wordcamp.org/2022/tickets/\">tickets</a> if you haven’t yet!</li><li>WordCamp US <a href=\"https://us.wordcamp.org/2022/support-underrepresented-speakers-at-wordcamp-us/\">announced</a> a new program to support underrepresented speakers.</li><li><a href=\"https://irun.wordcamp.org/2022/\">WordCamp Irun</a> (Spain) is happening this month on May 21 and 22, 2022.</li></ul>\n\n\n\n<div class=\"is-content-justification-center wp-container-12 wp-block-buttons\">\n<div class=\"wp-block-button aligncenter\"><a class=\"wp-block-button__link\" href=\"https://us.wordcamp.org/2022/our-call-for-volunteers-is-now-open/\" target=\"_blank\" rel=\"noreferrer noopener\"><strong><strong><strong>The </strong><strong>Call for Volunteers</strong><strong> for WordCamp US in San Diego, California, is now open. Newcomers to WordPress are always welcomed. Apply today!</strong></strong></strong></a></div>\n</div>\n\n\n\n<hr class=\"wp-block-separator has-css-opacity\" />\n\n\n\n<p><strong><em><strong><em>Have a story that we could include in the next issue of The Month in WordPress? Let us know by filling out </em></strong><a href=\"https://make.wordpress.org/community/month-in-wordpress-submissions/\"><strong><em>this form</em></strong></a><strong><em>.</em></strong></em></strong></p>\n\n\n\n<p><em>The following folks contributed to this Month in WordPress: <a href=\'https://profiles.wordpress.org/rmartinezduque/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>rmartinezduque</a>, <a href=\'https://profiles.wordpress.org/cbringmann/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>cbringmann</a>, <a href=\'https://profiles.wordpress.org/dansoschin/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>dansoschin</a>.</em></p>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:30:\"com-wordpress:feed-additions:1\";a:1:{s:7:\"post-id\";a:1:{i:0;a:5:{s:4:\"data\";s:5:\"12816\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:9;a:6:{s:4:\"data\";s:69:\"\n		\n		\n		\n		\n		\n				\n		\n		\n		\n		\n		\n\n					\n										\n					\n		\n		\n			\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:4:{s:0:\"\";a:6:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:33:\"WordPress 6.0 Release Candidate 1\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:69:\"https://wordpress.org/news/2022/05/wordpress-6-0-release-candidate-1/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Tue, 03 May 2022 17:18:32 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:5:{i:0;a:5:{s:4:\"data\";s:11:\"Development\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:1;a:5:{s:4:\"data\";s:8:\"Releases\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:2;a:5:{s:4:\"data\";s:3:\"6.0\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:3;a:5:{s:4:\"data\";s:11:\"development\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:4;a:5:{s:4:\"data\";s:8:\"releases\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:35:\"https://wordpress.org/news/?p=12799\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:171:\"WordPress 6.0 Release Candidate 1 is now available for testing! You can \ndownload and help test RC1 in three ways. You can also help translate WordPress to 100+ languages.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:11:\"Dan Soschin\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:7242:\"\n<p>The first release candidate (RC1) for WordPress 6.0 is now available!</p>\n\n\n\n<p>This is an important milestone on the 6.0 release cycle journey. “Release Candidate” means that this version of WordPress is ready for release! Before the official release date, time is set aside for the community to perform final reviews and help test. Since the WordPress ecosystem includes thousands of plugins and themes, it is important that everyone within the WordPress community check to see if anything was missed along the way. That means the project would love your help.</p>\n\n\n\n<p>WordPress 6.0 is planned for official release on May 24th, 2022, three weeks from today.&nbsp;</p>\n\n\n\n<p><strong>This version of the WordPress software is under development</strong>. Please do not install, run, and test this version of WordPress on a production or mission-critical website. Instead, it is recommended that you RC1 on a test server and site.&nbsp;</p>\n\n\n\n<p>You can test WordPress 6.0 RC1 in three ways:</p>\n\n\n\n<p><strong>Option 1: </strong>Install and activate the <a href=\"https://wordpress.org/plugins/wordpress-beta-tester/\">WordPress Beta Tester</a> plugin (select the “Bleeding edge” channel and “Beta/RC Only” stream).</p>\n\n\n\n<p><strong>Option 2: </strong>Direct download the <a href=\"https://wordpress.org/wordpress-6.0-RC1.zip\">release candidate version here (zip)</a>.</p>\n\n\n\n<p><strong>Option 3:</strong> When using WP-CLI to upgrade from Beta 1, 2, 3, or 4, on a case-insensitive filesystem, please use the following command:<br><code>wp core update --version=6.0-RC1</code></p>\n\n\n\n<p>Additional information on the full <a href=\"https://make.wordpress.org/core/6-0/\">6.0 release cycle is available here</a>.</p>\n\n\n\n<p>Check the <a href=\"https://make.wordpress.org/core/\">Make WordPress Core blog</a> for <a href=\"https://make.wordpress.org/core/tag/dev-notes+6-0/\">6.0-related developer notes</a> in the coming weeks which will detail all upcoming changes.</p>\n\n\n\n<h1>What’s in WordPress 6.0 RC1?</h1>\n\n\n\n<p>Since Beta 4, various items have been addressed, including (but not limited to):&nbsp;</p>\n\n\n\n<ul><li>Backport updates of Comment blocks tests (<a href=\"https://core.trac.wordpress.org/ticket/55643\">#55643</a>)</li><li>Backport a bugfix of Comment Template block pagination (<a href=\"https://core.trac.wordpress.org/ticket/55658\">#55658</a>)</li><li>Editor: Backport bug fixes for WordPress 6.0 from Gutenberg (<a href=\"https://core.trac.wordpress.org/ticket/55567\">#55567</a>)</li></ul>\n\n\n\n<p>WordPress 6.0 is the second major release for 2022, following 5.9 which became generally available in January. This release includes nearly 1,000 fixes and enhancements spanning most areas of the WordPress platform. Some key highlights within the content creation and site-building feature sets include:</p>\n\n\n\n<ul><li><strong>Style Switching:</strong> <a href=\"https://make.wordpress.org/core/2022/03/03/core-editor-improvement-choose-your-style/\">switch up the look and feel of your site</a>, all in one block theme. No need to change themes!</li><li><strong>More template options:</strong> use blocks to edit five more templates (author, date, categories, tag, and taxonomy).</li><li><strong>Multi-select: </strong>Easily select text across multiple blocks. Edit to your liking.</li><li><strong>Retain Styles: </strong>Keep your custom styles in place, whether transforming between blocks or creating new buttons.&nbsp;</li><li><strong>More patterns in more places:</strong> the Quick Inserter surfaces patterns that might work well for the condition you’re in, baking in relevant patterns for template parts and pages you’re working on.&nbsp;</li><li><strong>List View improvements: </strong>New keyboard shortcuts (shift + click) let you select multiple blocks to modify in bulk (reposition, delete, etc.), see your content at a glance with a collapsed by default view, and more.</li><li><strong>Refined design tools: </strong>Explore<strong> </strong>a new color panel, transparency options, more group block variations to create new layout options (Stack, Row), the ability to set your featured image in a Cover block, control the exact size of your featured image, gap support for the Gallery block, and more.</li><li><strong>New blocks: </strong>Various Post Comments, Read More, No Results in Query Loop, Post Author Biography, Avatar blocks.&nbsp;</li><li><strong>Block Locking: </strong>Choose to disable the option to remove a block, move it, or both, right in the editor.&nbsp;</li><li><strong>Export block themes: </strong>Explore the improved block theme export tool, as WordPress heads closer to codeless visual block theme building.</li></ul>\n\n\n\n<h1>Plugin and Theme Developers</h1>\n\n\n\n<p>All plugin and theme developers should test their respective extensions against WordPress 6.0 RC1 and update the “<em>Tested up to”</em> version in their readme file to 6.0. If you find compatibility problems, please be sure to post detailed information to the <a href=\"https://wordpress.org/support/forum/alphabeta/\">support forums</a>, so these items can be investigated further prior to the final release date of May 24th.</p>\n\n\n\n<p>Review the <em><a href=\"https://make.wordpress.org/core/2022/05/03/wordpress-6-0-field-guide/\">WordPress 6.0 Field Guide</a></em>, for more details on what’s contained in this release.</p>\n\n\n\n<h1>Translate WordPress</h1>\n\n\n\n<p>Do you speak a language other than English? <a href=\"https://translate.wordpress.org/projects/wp/dev\">Help translate WordPress into more than 100 languages.</a> This release also marks the <a href=\"https://make.wordpress.org/polyglots/handbook/glossary/#hard-freeze\">hard string freeze</a> point of the 6.0 release cycle.</p>\n\n\n\n<h1>How to Help Test WordPress</h1>\n\n\n\n<p>Testing for issues is critical for stabilizing a release throughout its development. Testing is also a great way to contribute to WordPress. If you are new to testing, check out this <a href=\"https://make.wordpress.org/test/2022/04/12/help-wanted-test-wordpress-6-0/\">detailed guide</a> that will walk you through how to get started.</p>\n\n\n\n<p>If you think you have run into an issue, please report it to the <a href=\"https://wordpress.org/support/forum/alphabeta/\">Alpha/Beta area</a> in the support forums. If you are comfortable writing a reproducible bug report, you can <a href=\"https://core.trac.wordpress.org/newticket\">file one on WordPress Trac</a>. This is also where you can find a list of <a href=\"https://core.trac.wordpress.org/tickets/major\">known bugs</a>.</p>\n\n\n\n<hr class=\"wp-block-separator has-alpha-channel-opacity\" />\n\n\n\n<h2>Haiku Fun for RC 1</h2>\n\n\n\n<p>Release candidate&nbsp;<br>Our journey nearly done<br>Get ready, WordPress</p>\n\n\n\n<hr class=\"wp-block-separator has-alpha-channel-opacity\" />\n\n\n\n<p>Thank you to the following contributors for collaborating on this post: <a href=\'https://profiles.wordpress.org/dansoschin/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>dansoschin</a>, <a href=\'https://profiles.wordpress.org/webcommsat/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>webcommsat</a>, and <a href=\'https://profiles.wordpress.org/annezazu/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>annezazu</a>.</p>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:30:\"com-wordpress:feed-additions:1\";a:1:{s:7:\"post-id\";a:1:{i:0;a:5:{s:4:\"data\";s:5:\"12799\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:10;a:6:{s:4:\"data\";s:69:\"\n		\n		\n		\n		\n		\n				\n		\n		\n		\n		\n		\n\n					\n										\n					\n		\n		\n			\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:4:{s:0:\"\";a:6:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:20:\"WordPress 6.0 Beta 4\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:56:\"https://wordpress.org/news/2022/05/wordpress-6-0-beta-4/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Mon, 02 May 2022 16:46:21 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:5:{i:0;a:5:{s:4:\"data\";s:11:\"Development\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:1;a:5:{s:4:\"data\";s:8:\"Releases\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:2;a:5:{s:4:\"data\";s:3:\"6.0\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:3;a:5:{s:4:\"data\";s:11:\"development\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:4;a:5:{s:4:\"data\";s:8:\"releases\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:35:\"https://wordpress.org/news/?p=12787\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:103:\"WordPress 6.0 Beta 4 is now available for testing! You can download and help test Beta 4 in three ways.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:11:\"Dan Soschin\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:5813:\"\n<p>WordPress 6.0 Beta 4 is now available for testing!</p>\n\n\n\n<p>Beta 4 was not part of the originally published development cycle. It is aimed at providing an opportunity for testing some specific issues that were resolved since Beta 3. WordPress will continue with the regularly scheduled release milestones on May 3rd, 2022, with the RC1 release.</p>\n\n\n\n<p><strong>This version of the WordPress software is under development</strong>. Please do not install, run, and test this version of WordPress on a production or mission-critical website. Instead, it is recommended that you test Beta 4 on a test server and site.&nbsp;</p>\n\n\n\n<p>You can test WordPress 6.0 Beta 4 in three ways:</p>\n\n\n\n<p><strong>Option 1: </strong>Install and activate the <a href=\"https://wordpress.org/plugins/wordpress-beta-tester/\">WordPress Beta Tester</a> plugin (select the “Bleeding edge” channel and “Beta/RC Only” stream).</p>\n\n\n\n<p><strong>Option 2: </strong>Direct download the <a href=\"https://wordpress.org/wordpress-6.0-beta4.zip\" data-type=\"URL\" data-id=\"https://wordpress.org/wordpress-6.0-beta4.zip\">beta version here (zip)</a>.</p>\n\n\n\n<p><strong>Option 3:</strong> Use WP-CLI to test: wp core update &#8211;version=6.0-beta4.<br><em>Do not use this option if your filesystem is case-insensitive.</em></p>\n\n\n\n<p>The current target for the final 6.0 release is May 24, 2022, which is in less than a month!&nbsp;</p>\n\n\n\n<p>Additional information on the full <a href=\"https://make.wordpress.org/core/6-0/\">6.0 release cycle is available</a>.</p>\n\n\n\n<p>Check the <a href=\"https://make.wordpress.org/core/\">Make WordPress Core blog</a> for <a href=\"https://make.wordpress.org/core/tag/dev-notes+6-0/\">6.0-related developer notes</a> in the coming weeks which will detail all upcoming changes.</p>\n\n\n\n<h2>Explore What’s in Beta 4</h2>\n\n\n\n<p>Since Beta 3, various items have been addressed, including (but not limited to): </p>\n\n\n\n<ul><li>Update post content placeholder (<a href=\"https://github.com/WordPress/gutenberg/pull/40177\">#40177</a>)</li><li>Comments block: Fix glitches found while backporting (<a href=\"https://github.com/WordPress/gutenberg/pull/40628\">#40628</a>)</li><li>Show add pattern label when patterns are being prioritised (<a href=\"https://github.com/WordPress/gutenberg/pull/40598\">#40598</a>)</li><li>Fix regression with featured images in latest posts (<a href=\"https://github.com/WordPress/gutenberg/pull/40662\">#40662</a>)</li><li>Navigation Link: Avoid unnecessary re-renders (<a href=\"https://github.com/WordPress/gutenberg/pull/40696\">#40696</a>)</li><li>Navigation: Improve selector performance (<a href=\"https://github.com/WordPress/gutenberg/pull/40700\">#40700</a>)</li><li>Comments Title: Count toggle working in &#8216;Singular&#8217; editing mode (<a href=\"https://github.com/WordPress/gutenberg/pull/40728\">#40728</a>)</li><li>[Writing Flow]: Try to fix multi-selection with shift+click (<a href=\"https://github.com/WordPress/gutenberg/pull/40687\">#40687</a>)</li><li>Fix alignment issue with comment author name (<a href=\"https://github.com/WordPress/gutenberg/pull/40610\">#40610</a>)</li><li>Comment Content: Show moderation message (<a href=\"https://github.com/WordPress/gutenberg/pull/40612\">#40612</a>)</li><li>Display paragraph breaks in comment contents block (<a href=\"https://github.com/WordPress/gutenberg/pull/40667\">#40667</a>)</li><li>Fix style comment awaiting moderation indentation (<a href=\"https://github.com/WordPress/gutenberg/pull/40681\">#40681</a>)</li><li>Fix: Page patterns don&#8217;t show when only one pattern is available (<a href=\"https://github.com/WordPress/gutenberg/pull/40707\">#40707</a>)</li><li>Update the placeholder for post excerpt (<a href=\"https://github.com/WordPress/gutenberg/pull/40178\">#40178</a>)</li><li>REST API: Fix regression in the Pattern Directory endpoint. (<a href=\"https://core.trac.wordpress.org/ticket/55617\">#55617</a>)</li><li>REST API: Fix the scheme for the Block Directory search endpoint. (<a href=\"https://core.trac.wordpress.org/ticket/53621\">#53621</a>)</li><li>Show comments previews in the Comment Query Loop. (<a href=\"https://core.trac.wordpress.org/ticket/55634\">#55634</a>)</li><li>Avoid DB error in comment meta queries. (<a href=\"https://core.trac.wordpress.org/ticket/55218\">#55218</a>)</li></ul>\n\n\n\n<h2>How to Help</h2>\n\n\n\n<p>Testing for issues is critical for stabilizing a release throughout its development. Testing is also a great way to contribute to WordPress. If you are new to testing, check out this <a href=\"https://make.wordpress.org/test/2022/04/12/help-wanted-test-wordpress-6-0/\">detailed guide</a> that will walk you through how to get started.</p>\n\n\n\n<p>If you think you have run into an issue, please report it to the <a href=\"https://wordpress.org/support/forum/alphabeta/\">Alpha/Beta area</a> in the support forums. If you are comfortable writing a reproducible bug report, you can <a href=\"https://core.trac.wordpress.org/newticket\">file one on WordPress Trac</a>. This is also where you can find a list of <a href=\"https://core.trac.wordpress.org/tickets/major\">known bugs</a>.</p>\n\n\n\n<hr class=\"wp-block-separator has-alpha-channel-opacity\" />\n\n\n\n<h2>Another Haiku, Just for You</h2>\n\n\n\n<p>Beta four, surprise!<br>Iterating all day long<br>Time to share and test</p>\n\n\n\n<hr class=\"wp-block-separator has-alpha-channel-opacity\" />\n\n\n\n<p>Thank you to the following contributors for collaborating on this post: <br><a href=\'https://profiles.wordpress.org/dansoschin/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>dansoschin</a>, <a href=\'https://profiles.wordpress.org/annezazu/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>annezazu</a>, and <a href=\'https://profiles.wordpress.org/costdev/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>costdev</a></p>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:30:\"com-wordpress:feed-additions:1\";a:1:{s:7:\"post-id\";a:1:{i:0;a:5:{s:4:\"data\";s:5:\"12787\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:11;a:6:{s:4:\"data\";s:61:\"\n		\n		\n		\n		\n		\n				\n		\n		\n\n					\n										\n					\n		\n		\n\n			\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:4:{s:0:\"\";a:7:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:54:\"WP Briefing: Episode 30: A Sneak Peek at WordPress 6.0\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:76:\"https://wordpress.org/news/2022/05/episode-30-a-sneak-peek-at-wordpress-6-0/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Mon, 02 May 2022 13:03:41 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:2:{i:0;a:5:{s:4:\"data\";s:7:\"Podcast\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:1;a:5:{s:4:\"data\";s:11:\"wp-briefing\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:53:\"https://wordpress.org/news/?post_type=podcast&p=12742\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:132:\"Get a behind the scenes sneak peek at the WordPress 6.0 release on this episode of the WordPress Briefing featuring a special guest!\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:9:\"enclosure\";a:1:{i:0;a:5:{s:4:\"data\";s:0:\"\";s:7:\"attribs\";a:1:{s:0:\"\";a:3:{s:3:\"url\";s:60:\"https://wordpress.org/news/files/2022/04/WP-Briefing-030.mp3\";s:6:\"length\";s:1:\"0\";s:4:\"type\";s:0:\"\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:14:\"Santana Inniss\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:33449:\"\n<p>In the thirtieth episode of the WordPress Briefing, Executive Director Josepha Haden Chomphosy and special guest Channing Ritter give listeners a sneak peek into the WordPress 6.0 release ahead of the Release Candidate 1 (RC1). </p>\n\n\n\n<p><em><strong>Have a question you&#8217;d like answered? You can submit them to <a href=\"mailto:wpbriefing@wordpress.org\">wpbriefing@wordpress.org</a>, either written or as a voice recording.</strong></em></p>\n\n\n\n<h2 id=\"credits\">Credits</h2>\n\n\n\n<ul><li>Special Guest: <a href=\"https://profiles.wordpress.org/critterverse/\" data-type=\"URL\" data-id=\"https://profiles.wordpress.org/critterverse/\">Channing Ritter</a></li><li>Editor:&nbsp;<a href=\"https://profiles.wordpress.org/dustinhartzler/\">Dustin Hartzler</a></li><li>Logo:&nbsp;<a href=\"https://profiles.wordpress.org/beafialho/\">Beatriz Fialho</a></li><li>Production:&nbsp;<a href=\"https://profiles.wordpress.org/santanainniss/\">Santana Inniss</a> </li><li>Song: Fearless First by Kevin MacLeod</li></ul>\n\n\n\n<h2>References</h2>\n\n\n\n<ul><li><a href=\"https://wordpress.org/themes/twentytwentytwo/\">Twenty Twenty-Two Theme</a></li><li><a href=\"https://make.wordpress.org/core/2022/01/08/locking-blocks-in-wordpress-5-9/\">Block Locking</a></li><li><a href=\"https://wordpress.tv/2017/12/10/josepha-haden-beginners-guide-to-contributions/\">Beginner&#8217;s Guide to Contributing</a>, Josepha Haden Chomphosy</li><li><a rel=\"noreferrer noopener\" href=\"https://wordsesh.com/\" data-type=\"URL\" data-id=\"https://wordsesh.com/\" target=\"_blank\">WordSesh</a></li><li><a rel=\"noreferrer noopener\" href=\"https://learn.wordpress.org/social-learning/\" data-type=\"URL\" data-id=\"https://learn.wordpress.org/social-learning/\" target=\"_blank\">Social Learning Spaces</a></li><li><a rel=\"noreferrer noopener\" href=\"https://europe.wordcamp.org/2022/contributor-day/\" data-type=\"URL\" data-id=\"https://europe.wordcamp.org/2022/contributor-day/\" target=\"_blank\">WordCamp Europe Contributor Day</a></li></ul>\n\n\n\n<h2>Transcript</h2>\n\n\n\n<span id=\"more-12742\"></span>\n\n\n\n<p>[<strong>Josepha Haden Chomphosy </strong>00:00:00]&nbsp;</p>\n\n\n\n<p>Hello everyone, and welcome to the WordPress Briefing, the podcast where you can catch quick explanations of the ideas behind the WordPress open source project, some insight into the community that supports it, and get a small list of big things coming up in the next two weeks. I&#8217;m your host, Josepha Haden Chomphosy. Here we go!</p>\n\n\n\n<p>[<strong>Josepha Haden Chomphosy </strong>00:00:40]</p>\n\n\n\n<p>Tomorrow&#8217;s a big day. It marks the beginning of what is called the RC period, or release candidate period, for the current major release of the WordPress CMS. If you&#8217;re not super familiar with the way release cycles work, this is the point in the process where the code should pretty much be done changing.&nbsp;</p>\n\n\n\n<p>That way you can call in your designers, developers, and anyone else who builds things for others using your software. And they can either start testing their products on it, or they can figure out what new things they need to be able to teach their clients, whichever is most relevant to them. That is generally true for WordPress as well, but in true open source fashion, there is a caveat built in that helps us to get in last-minute, vital changes from contributors.</p>\n\n\n\n<p>We have a two-person sign-off rule that&#8217;s been around for about as long as I can remember, but lets things be added late in the release cycle, as long as there are two sign-offs from qualified contributors. Most of the time, those qualified contributors are lead developers of the project, but not always. We have a good group of people who are around helping us make sure that this is doable and the best thing that we can offer to all of our users.</p>\n\n\n\n<p>[<strong>Josepha Haden Chomphosy </strong>00:01:50]</p>\n\n\n\n<p>And so, yeah, two-person sign-off, that is the little bit of release process trivia that you never knew you needed. And since we&#8217;re looking at a release trivia, kind of hidden bits of how software is made, I actually have a guest with me today, Channing Ritter. So Channing is a product and visual designer based in Brooklyn, New York.</p>\n\n\n\n<p>She&#8217;s a design director at Automattic and has been working on the WordPress project as a full-time sponsored contributor since January, 2021. She is joining us to share some behind the scenes intel on what&#8217;s going into the 6.0 release, her role in that process, and then we&#8217;ll just kind of see how the conversation goes from there.</p>\n\n\n\n<p>[<strong>Josepha Haden Chomphosy </strong>00:02:40]</p>\n\n\n\n<p>Well, and with that, I&#8217;d like to welcome Channing to the WordPress Briefing. Hi Channing!</p>\n\n\n\n<p>[<strong>Channing Ritter </strong>00:02:45]</p>\n\n\n\n<p>Hey Josepha. Thanks so much for having me.&nbsp;</p>\n\n\n\n<p>[<strong>Josepha Haden Chomphosy</strong> 00:02:48] </p>\n\n\n\n<p>I&#8217;m excited to have you here. If I understand, you are working on the design side of things with the release. So why don&#8217;t you tell me a little bit about the role you&#8217;ve played?</p>\n\n\n\n<p>[<strong>Channing Ritter</strong> 00:02:59] </p>\n\n\n\n<p>I am. I am the design release lead for the 6.0 release. And if I understand correctly, this is a position that has been unfulfilled for the past few release cycles. So I&#8217;m kind of the first person to step in over the past few releases. And I think that&#8217;s really exciting, especially because design has started to play such a more important role in the WordPress project over the past few years.</p>\n\n\n\n<p>So it makes sense that design would have a seat at the table, and I&#8217;m really excited to be helping advocate for the design team and learning from other folks on the release squad. Who&#8217;ve been doing this for a while.</p>\n\n\n\n<p>[<strong>Josepha Haden Chomphosy</strong> 00:03:33] </p>\n\n\n\n<p>So. First big question about 6.0, what is the feature that you are most excited about?&nbsp;</p>\n\n\n\n<p>[<strong>Channing Ritter</strong> 00:03:39] </p>\n\n\n\n<p>I&#8217;m most excited about the style switcher within the global styles panel. Um, so if folks still don&#8217;t know what I&#8217;m talking about there, it&#8217;s the ability to change between different variations of the theme.json without actually switching the theme.&nbsp;</p>\n\n\n\n<p>So this is a way to get a drastically different look and feels across your site with just a single click. And I see it as a really fun place to experiment and kind of get inspired for the different ways your site could appear without ever having to change your theme.</p>\n\n\n\n<p>And in terms of the Twenty Twenty-Two variations, they&#8217;re just really gorgeous and all so diverse. Like you have the main default theme that has the deep green and kind of peachy colors and this really elegant type treatment with a really thin Serif typeface. But then the variations are so different from that. And I think my favorite one is the Swiss variation.</p>\n\n\n\n<p>[<strong>Josepha Haden Chomphosy</strong> 00:04:36]</p>\n\n\n\n<p>The Swiss variation?&nbsp;</p>\n\n\n\n<p>[<strong>Channing Ritter</strong> 00:04:38]</p>\n\n\n\n<p>Yeah, every graphic design nerd loves Swiss design.&nbsp;</p>\n\n\n\n<p>[<strong>Josepha Haden Chomphosy</strong> 00:04:42] </p>\n\n\n\n<p>Oh, ok! Now I know!&nbsp;</p>\n\n\n\n<p>[<strong>Channing Ritter</strong> 00:04:38] </p>\n\n\n\n<p>Really awesome things found in there. It&#8217;s a really high contrast, bold variation. It&#8217;s kind of black and white with red accents. I just love how different it is from the default style and how easy it is to change up your site and just get a whole drastically different look and feel.</p>\n\n\n\n<p>[<strong>Josepha Haden Chomphosy</strong> 00:05:00] </p>\n\n\n\n<p>That&#8217;s excellent. So for folks who do not know what we&#8217;re referring to, when we talk about the Twenty Twenty-Two variation, that is the default theme, Twenty Twenty-Two. I&#8217;ll put a link to both the classic and block-based versions in our show notes, but you&#8217;ll want to use the block-based version to look at these style variations that Channing has mentioned here.&nbsp;</p>\n\n\n\n<p>[<strong>Channing Ritter</strong> 00:05:24] </p>\n\n\n\n<p>You know, we&#8217;re really excited that the first-ever default block theme was released with 5.9, which is when Twenty Twenty-Two first went out and was bundled with 5.9.</p>\n\n\n\n<p>But now, with 6.0, I think even more so it&#8217;s starting to showcase the real power of block themes and what can actually be done there. And style variations is a huge kind of first step into this new world of block themes and starting to really open up the possibilities and all the flexibility that you have there.</p>\n\n\n\n<p>[<strong>Josepha Haden Chomphosy</strong> 00:05:55] </p>\n\n\n\n<p>Yeah, absolutely. So when we&#8217;re talking about the Twenty Twenty-Two default theme, when we&#8217;re talking about switching these variations inside the theme itself, that seems to me to be a very user-focused kind of feature. And when we talk about users in WordPress, there&#8217;s a lot of room for interpretation. Like if we look at it kind of in a framework of three types of users of WordPress, you have, like end-users. So people who are site owners using it as a site to, like, enable their business.&nbsp;</p>\n\n\n\n<p>But you also have mid-end users—people who use it to build sites for others. And what I like to call back-end users, people who are using WordPress as a framework. And of course at the start of the Gutenberg project, way back in forever, a million years ago, one of the big calls to action that we had around even, like, trying to do this, was that we wanted to make WordPress easier for users. Just plain users.&nbsp;</p>\n\n\n\n<p>And, and to me, that means making WordPress easier for those mid-end users, people who are creating WordPress sites for other people. But also should give some power and autonomy back to those end-users, the people who are using sites to enable their business or are site owners.&nbsp;</p>\n\n\n\n<p>[<strong>Josepha Haden Chomphosy</strong> 00:07:14] </p>\n\n\n\n<p>And so in that context, between 5.9 and 6.0, do you feel like we have features that are really giving that kind of power and agency back to our end-users? Do you feel like we have some features that are really focused on those mid-end users, as opposed to our backend users? For a long time, we focused heavily on enabling our backend users, and now Gutenberg kind of moves us into those other two areas.</p>\n\n\n\n<p>And so do you think that things like being able to switch between your style of variations, other things like that are moving us closer to that particular goal of Gutenberg?</p>\n\n\n\n<p>[<strong>Channing Ritter</strong> 00:07:51] </p>\n\n\n\n<p>That&#8217;s a great question. I think it&#8217;s both. I think some of the features being released in 6.0 are absolutely going to empower that end-user.</p>\n\n\n\n<p>Particularly in terms of improvements around design tools and some of the quality of life improvements. For example, partially selecting across multiple blocks and being able to partially select texts there. That&#8217;s the type of thing that really brings the writing experience in the editor to be on par with how you would expect a text editing experience to work.</p>\n\n\n\n<p>And there are tons of small quality of life improvements in this release that I think are really gonna help those end-users. But there are also improvements around what we might call the maintainers who are building sites for others. I think block locking in particular is something that is really going to start filling a gap between people who build the sites and then people who do the day-to-day maintenance within a site.</p>\n\n\n\n<p>For example, in 6.0, we&#8217;re introducing some interface UI around block locking, but also there&#8217;ll be control around the ability to lock user roles.</p>\n\n\n\n<p>[<strong>Josepha Haden Chomphosy</strong> 00:09:03]</p>\n\n\n\n<p>Which I think makes a lot of sense. I mean, we have all of these user roles in the CMS itself, and for a long time, we&#8217;ve just been like free for all on blocks, which was great and is great and should be available to people.</p>\n\n\n\n<p>But also if we are saying, like, it makes sense to have this gradient of users and their abilities for the CMS itself, and we are saying that we want to move control of the website and the content to be at the base layer in these blocks, then it also makes sense that we should be able to provide that same sort of granular level of access in the blocks.</p>\n\n\n\n<p>So I think that&#8217;s a great thing. If you all, if dear listeners, you do not know what we mean by “block locking,” I&#8217;m sure that I can find a link for us in our show notes below as well. If for anyone who&#8217;s been talking through Gutenberg things with me for a while, you know that this is one of the primary use cases that I think has been a long time coming.</p>\n\n\n\n<p>[<strong>Josepha Haden Chomphosy</strong> 00:10:05]</p>\n\n\n\n<p>It was one of the first examples that I offered to folks when we had that question of like, who is this being built for? In what way is this beneficial to that mid-end user, as opposed to just giving all of the power and autonomy to users in a way that maybe is not the best for their visitors?&nbsp;</p>\n\n\n\n<p>This is one of those use cases that made the most sense to me being able to say, okay, well, the opportunity to, as somebody who runs an agency and is building websites for people to be able to say, yeah, ‘You can do anything that is possible in this instance of WordPress and all the things that you are allowed to do will not break your instance. It won&#8217;t break your website’.&nbsp;</p>\n\n\n\n<p>And so it gives a lot of time back to agencies to focus on their client&#8217;s most important problems, as opposed to not knowing how to update the hours in their footer or something like that. And so I&#8217;m very excited about that particular feature.</p>\n\n\n\n<p>[<strong>Channing Ritter</strong> 00:11:01]</p>\n\n\n\n<p>It&#8217;s such a long-requested feature. I mean, we&#8217;ve been hearing requests around this particular feature for years and, you know, often when something gets requested over a span of years like that, it&#8217;s because there are some complexities to figure out how it works.</p>\n\n\n\n<p>And that&#8217;s definitely been the case with moving forward with block locking. And there are a lot of nuances there. But I think what you were saying, I totally agree with. There’s always a push and pull. And as we enable more and more flexibility for end-users, there needs to be a little bit of push from the other side to kind of give more granular controls, more locking options, and make sure that everything can still be easily maintained.</p>\n\n\n\n<p>[<strong>Josepha Haden Chomphosy</strong> 00:11:43]</p>\n\n\n\n<p>Yeah, we mentioned in that answer the concept of maintainers. If you are a contributor, it&#8217;s not <em>that</em> kind of ‘maintainer.’ So if you&#8217;re a WordPress contributor and we said maintainers there, um, just know that that&#8217;s not what we&#8217;re referring to. If you don&#8217;t know what I&#8217;m talking about when I say ‘contributor,’ there is a whole community of open source people and maintainers are people who specifically take care of a particular part of the WordPress software or the WordPress project, um, that makes all this possible.</p>\n\n\n\n<p>So there&#8217;s, ya know….&nbsp;</p>\n\n\n\n<p>[<strong>Channing Ritter</strong> 00:12:19] </p>\n\n\n\n<p>So true! The maintainer has another meaning in this context.</p>\n\n\n\n<p>[<strong>Josepha Haden Chomphosy</strong> 00:12:20]</p>\n\n\n\n<p>Yeah, we have a mix in our audience and I love it, but it also makes me frequently spend like 10% of my podcast being like, by the way, when I said this, I didn&#8217;t mean you, but I did mean <em>you</em>, which makes it harder. I know.&nbsp;</p>\n\n\n\n<p>So. You’ve been with the project for a little bit, but if I recall correctly, this is the first time that you were, like, leading part of a release.</p>\n\n\n\n<p>So what would you say was the most challenging part of that?</p>\n\n\n\n<p>[<strong>Channing Ritter</strong>  00:12:52] </p>\n\n\n\n<p>Another great question. This is my first time being this closely involved with the release. Although I was involved with the 5.9 release, but mostly in a release assets capacity. So I helped with the <em>About Page</em> and the welcome banner that goes on the dashboard.</p>\n\n\n\n<p>So I did get some insight in the last release cycle. Which was great preparation for being more involved as a release lead on this cycle. From the design perspective, one of the hardest things is always going to be figuring out what exactly goes into the release and what needs more time. In the sense, you know, that there might be some features that need to stay in the Gutenberg plugin for a while and get more testing before they get released to a much wider audience in a major WordPress release.</p>\n\n\n\n<p>So I think on the design side, we definitely have some goals that are big, long-term projects that are likely going to span across, you know, many releases, maybe even over many years. And I think the full site editor is a great example of that in a sense that it&#8217;s not something that you just were gone in one release and then it all gets released and then it&#8217;s all good to go.</p>\n\n\n\n<p>[<strong>Channing Ritter</strong>  00:14:06] </p>\n\n\n\n<p>It&#8217;s something that has to be staggered across many releases, and there&#8217;s a lot of thought that goes into it; does this make sense in this more limited capacity, and what else needs to go in in order for this feature to go in? And the most complex things about the WordPress project is how interconnected things are.</p>\n\n\n\n<p>So when you start making those decisions about what should go in, what should get pulled out, often there&#8217;s sort of a domino effect of like, well, that would affect this feature and then, well, maybe they shouldn&#8217;t go in, or maybe this does need to go in. And that is really one of the most challenging, but also one of the most fascinating aspects of the release process.</p>\n\n\n\n<p>[<strong>Josepha Haden Chomphosy</strong> 00:14:46] </p>\n\n\n\n<p>Yes. It is very, very true that there are kind of no small problems left in WordPress. *laughs* Yeah, when we, when we first started with this like bigger release squad, cause that has not been routine for the history of the project. When we first started with that, I know that expanding out the exposure to like how much one change affects 25 different things was really, it was really good for all of us to be reminded.</p>\n\n\n\n<p>And as I mentioned at the top of our episode today, tomorrow begins the RC period. It begins the release candidate period, which is when it&#8217;s supposed to be, as locked down as possible. But if you all have been following along with our release process in general, which if you&#8217;re listening to this, you probably have, you know that last week or a couple of weeks ago, we had this whole question about the Webfonts API, and we had that conversation in a public space as best we could,&nbsp;</p>\n\n\n\n<p>Like, there are always things that you can&#8217;t, like, fully disclose in public spaces, but we had a very open and transparent conversation about, like, who is most affected by putting it in, in the state that the API was in. And, who&#8217;s most affected if we take it out. And where can we make compromises on either side so that both sides are a little happy and a little unhappy?</p>\n\n\n\n<p>[<strong>Josepha Haden Chomphosy</strong> 00:16:09] </p>\n\n\n\n<p>And, like, that is all so hard to do. Not only in general. We have a 20-year-old code base and a five-year-old code base. And it&#8217;s all a big, big undertaking to understand what is happening and where it happens. And so there&#8217;s this moment always when we are trying to decide, like, is this baked enough? Did we put it in too early? Should we pull it out? How, if we pull it out, did we ask people to do too much work before we decided to pull it out anyway?</p>\n\n\n\n<p>Like, you always have those kinds of questions about it. And honestly, I think that most of us weren&#8217;t around the last time, that WordPress was, was this experimental in public, like it&#8217;s always been open source. It&#8217;s always been experimental and iterating publicly, which is just the hardest way to work on anything. We like, we shipped our best guesses. Don&#8217;t be mad. It&#8217;ll be… we&#8217;re coming for it. We&#8217;re going to fix it. Like, that&#8217;s always hard, but the last time around, when it was this substantial a change was, like, 2008 or something, like, it was ages and ages ago.</p>\n\n\n\n<p>[<strong>Josepha Haden Chomphosy</strong>  00:17:14] </p>\n\n\n\n<p>And we were smaller than, we had a smaller number of contributors. We had a smaller group of people actually using the CMS. And so over time it has gotten more and more complicated. And, and I don&#8217;t think that we can ever understate the complexities of that. And so for you, you had a little bit of exposure to it in 5.9 and then showed up for like really doing it in 6.0.</p>\n\n\n\n<p>Has it been a surprising change? Like, were you surprised much more by how complicated it was when you were closer to it?&nbsp;</p>\n\n\n\n<p>[<strong>Channing Ritter</strong> 00:17:47] </p>\n\n\n\n<p>Yeah, definitely. It’s been a real learning process, especially coming to understand how much there really are no easy answers. I think a lot of us are in the release squad are real problem solver types of people and, and want it to, you know, be a really neat, tidy answer.&nbsp;</p>\n\n\n\n<p>And it&#8217;s not always the case. You know, sometimes parts of the feature might go in, or some contingency plan might get put into place and things didn&#8217;t go exactly as planned. But what you said of being an experiment and being on kind of the cutting edge of trying out new things, I think there is a lot of passion around that in the WordPress project.&nbsp;</p>\n\n\n\n<p>Right now, we&#8217;re in such a transitional period for the project, you know, moving from classic themes to block themes and really changing the ideas of how we approach designing sites. And because of that, I think there is a lot of momentum and energy around getting new features, as many new features as possible into each release. But there&#8217;s also, you know, a lot of testing and stuff that needs to happen.</p>\n\n\n\n<p>And to make sure that, like you said, these things aren&#8217;t going out too early.&nbsp;</p>\n\n\n\n<p>[<strong>Josepha Haden Chomphosy</strong> 00:19:01] </p>\n\n\n\n<p>Well, and there&#8217;s always that difficulty, we&#8217;re going to just leap right into open source areas now. There&#8217;s always that difficulty around, like, there&#8217;s this concept that when, like, we always want to ship something that doesn&#8217;t break backward compatibility when possible, we don&#8217;t want to ship vulnerabilities. Like, that&#8217;s always true, but we are in an open source project, and open source projects are necessarily kind of tolerant of like, that&#8217;s not our best, but like it skates, right?&nbsp;</p>\n\n\n\n<p>This was, we aimed for Ferrari and got a skateboard because sometimes you got to start with a skateboard, right? *laughter* Like if it gets you from one place to another, that&#8217;s kind of where we&#8217;ve got to aim some days.&nbsp;</p>\n\n\n\n<p>[<strong>Channing Ritter</strong> 00:19:45] </p>\n\n\n\n<p>Totally.</p>\n\n\n\n<p>[<strong>Josepha Haden Chomphosy</strong>  00:19:46] </p>\n\n\n\n<p>And that&#8217;s always so, so difficult, especially cause, like, for the big change that 5.0 represented, and that 5.9 represented– 6.0 is not as big a shock as 5.9 was.&nbsp; But, like, as big a change as those represented, it still skates. And that&#8217;s, I think what makes the work especially hard, especially nuanced. And like, we haven&#8217;t gotten together as human beings in two years. And so sometimes people just kind of forget there&#8217;s a human being back there.</p>\n\n\n\n<p>We&#8217;re humans. Everyone be nice. Yeah. I don&#8217;t know that part of running a release definitely was surprising to me. My first release that I ran was 5.0 and…</p>\n\n\n\n<p>[<strong>Channing Ritter</strong> 00:20:31] </p>\n\n\n\n<p>Oh, wow!</p>\n\n\n\n<p>[<strong>Josepha Haden Chomphosy</strong> 00:20:32]</p>\n\n\n\n<p> Yeah, it was, like, that was  2018. And then I became the executive director at the top of 2019. And I distinctly remember one core chat where I showed up and just was like the most transparent, vulnerable person we&#8217;ve ever experienced in life.</p>\n\n\n\n<p>That&#8217;s not true. We have very vulnerable people in the project and very transparent people, but I told everyone like, there are a million of you and one of me, and it&#8217;s kind of terrifying that you&#8217;re leaping on me in this—like you&#8217;re scaring me a lot right now. And that was quite a thing to say to like, all these… it&#8217;s terrifying! Right?</p>\n\n\n\n<p>[<strong>Channing Ritter</strong> 00:21:12] </p>\n\n\n\n<p>I love when you see that type of vulnerability in the project. I think it takes… it takes a degree of comfort and familiarity with the project to even be able to admit to that. And to me, that&#8217;s a real sign of growth in the project. Like when I first started contributing, I don&#8217;t think I ever would have just said, like, ‘How is the feature supposed to work? I have no idea.’ That&#8217;s something that I say all the time now.</p>\n\n\n\n<p>*Laughter*</p>\n\n\n\n<p>And you know, that is completely fine and more than okay. It&#8217;s a massive project. There are folks who have done deep thinking about a feature over the course of years. You know, and there are experts who can help shed light on various problems that maybe you just haven&#8217;t had a chance to dive into yet and really understand the nuances of yet.</p>\n\n\n\n<p>So that&#8217;s the amazing thing about open source is that you can lean on folks who do have expertise in that particular area. You&#8217;re not expected to be an expert-expert in every single domain. It&#8217;s okay to say, I don&#8217;t really have a good idea or a good concept of this feature. I don&#8217;t have a good feeling for it. What do other folks think?&nbsp;</p>\n\n\n\n<p>[<strong>Channing Ritter</strong> 00:22:24] </p>\n\n\n\n<p>And even people who have been in the project for a long time, decade plus, still say that all the time. You know, or you might just say, like, I have a really rough idea of how this works, are other people seeing this the same way? Or did other people have a different, you know, mental picture of how this might work?</p>\n\n\n\n<p>Even if, sometimes it feels like you&#8217;re over-communicating, it&#8217;s really helpful because often people do have really dramatically different ideas about how a feature might take shape.</p>\n\n\n\n<p>[<strong>Josepha Haden Chomphosy</strong> 00:22:49] </p>\n\n\n\n<p>And I hope that&#8217;s one of the things that we never lose in the project. Like we are an old, old project now and we support a bunch of the web with a tiny, tiny group of people compared to the amount of the web that we support.</p>\n\n\n\n<p>And I hope that we always have that opportunity as senior leaders, which I am, and all of our upcoming leaders to all of us, just at some point, be like, can we stop the train? I don&#8217;t understand. I don’t understand that. Um, and not necessarily feel that that has made us a worse contributor. Cause I think that it&#8217;s when we are transparent about our lack of understanding.</p>\n\n\n\n<p>That&#8217;s when we have the opportunity to make what we&#8217;re offering to the world more solid and always better.&nbsp;&nbsp;</p>\n\n\n\n<p>[<strong>Channing Ritter</strong> 00:23:35] </p>\n\n\n\n<p>I love it. I think it&#8217;s the, one of the most lovely things about the WordPress community. There&#8217;s really low judgment around those types of questions and people are really inclusive and more than happy to take a moment to explain something to you or shed some light on an issue you might not have thought that much about.&nbsp;</p>\n\n\n\n<p>I think that&#8217;s one of the best things you can always reach out for help. And folks are always willing to provide guidance or context or even historical information about, you know, whether it&#8217;s been tried in the past or previous explorations and that sort of thing.</p>\n\n\n\n<p>[<strong>Josepha Haden Chomphosy</strong> 00:24:10] </p>\n\n\n\n<p> All right. Well, that covers all of my questions for you. Do you have a final thought about the release that you would like to share with everyone you don&#8217;t have to, if you don&#8217;t want to, not everyone has like a final sign off.&nbsp;</p>\n\n\n\n<p>[<strong>Channing Ritter</strong> 00:24:25] </p>\n\n\n\n<p>Yeah. One of the things I&#8217;m most excited about for this 6.0 release is all of the improvements around design tools.</p>\n\n\n\n<p>And these are just small improvements around a ton of different things, like the color panel, border controls, gap support, typography options, flexible container blocks, etc. These are the types of tools that are a designer&#8217;s dream. You know, they really make the difference between being able to make a really crisp, finished looking final product and having something that&#8217;s a little rough around the edges.</p>\n\n\n\n<p>And as a designer, like those are the things that your eye goes straight towards. And all of these nuanced new tools, they really allow designers to have that fine detailed control to create really pixel perfect sites. And I think that&#8217;s something that, you know, myself and a lot of others on the design team are just so beyond excited about.</p>\n\n\n\n<p>[<strong>Josepha Haden Chomphosy</strong> 00:25:25]</p>\n\n\n\n<p>Excellent. Well, Channing, thank you so much for joining us today on the WordPress Briefing; it has been an absolute delight.&nbsp;</p>\n\n\n\n<p>[<strong>Channing Ritter</strong> 00:25:32] </p>\n\n\n\n<p>Thank you for having me.</p>\n\n\n\n<p>[<strong>Josepha Haden Chomphosy</strong> 00:25:41] </p>\n\n\n\n<p>And now it is time, woohoo, for the small list of big things. My favorite part of this podcast, that&#8217;s not true. I have a lot of things that I love about this podcast. I just, in particular love being able to share like three things that are coming up in the next couple of weeks that everybody should be aware of. And I really particularly like the list I have this week.&nbsp;</p>\n\n\n\n<p>First as of today, we are two weeks away from WordSesh. If you&#8217;re looking forward to your first in-person WordPress event, but feel like you could use a little foundation information, a little bit of a WordPress primer, then this event has a lot of excellent thought leaders in the project that you can learn from.</p>\n\n\n\n<p>If you&#8217;re looking for more practical or hands-on opportunities, uh, you can also check out social learning spaces. All of those are free for anyone. So I will include links to both of them in the show notes.&nbsp;</p>\n\n\n\n<p>[<strong>Josepha Haden Chomphosy </strong>00:26:30]&nbsp;</p>\n\n\n\n<p>Second, as of today, we are four weeks away from WordCamp Europe. This is one of our flagship events. So it also includes a contributor day, which I encourage you to look into. If you have never heard of one before. I will be there to meet some of the contributors that have joined the project since the end of 2019. And hopefully, I will see you there as well. If you&#8217;ve never heard of a contributor day, then I&#8217;ll include a link to the beginner&#8217;s guide to contributions, a little talk that I gave in 2017 in the show notes that should help you get your bearings or at the very least know what questions to ask yourself to figure out if a contributor day is right for you.</p>\n\n\n\n<p>And then the third thing as of today, it has been one week since <a href=\"https://profiles.wordpress.org/iandunn/\">Ian Dunn</a> and the <a href=\"https://make.wordpress.org/meta/\">Meta</a> developers… Um, that sounds like a band… Ian Dunn and the Meta developers connected the props channel in the community Slack to WordPress.org profile activity. I&#8217;m really excited about this. It&#8217;s the first in a long list of changes that are part of a larger project to credit more non-code contributions, more contributions that are not specific to a major release or event.</p>\n\n\n\n<p>And also to set us up to be able to provide more quality checks and balances for our growing Five for the Future program. If you&#8217;ve not been over there lately, if you&#8217;re not super sure what I&#8217;m talking about, there&#8217;s a link to the discussion post that we had about it, but also you can wander right over into the Making WordPress Slack and check out the props channel to just kind of see a running list of contributors that people are really grateful for. Which, frankly, if you ever are having a bad day, that is a wonderful place to just kind of wander in and see all of the positive vibes that people are sending around to each other.</p>\n\n\n\n<p>Uh, yeah, so the props channel, is always good. Uh, and that my friends is your small list of big things. Thank you for tuning in today for the WordPress Briefing. </p>\n\n\n\n<p>I&#8217;m your host, Josepha Haden Chomphosy. And I&#8217;ll see you again in a couple of weeks.</p>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:30:\"com-wordpress:feed-additions:1\";a:1:{s:7:\"post-id\";a:1:{i:0;a:5:{s:4:\"data\";s:5:\"12742\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:12;a:6:{s:4:\"data\";s:75:\"\n		\n		\n		\n		\n		\n				\n		\n		\n		\n		\n		\n		\n		\n\n					\n										\n					\n		\n		\n			\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:4:{s:0:\"\";a:6:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"People of WordPress: Meher Bala\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:66:\"https://wordpress.org/news/2022/04/people-of-wordpress-meher-bala/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Sat, 30 Apr 2022 09:20:54 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:7:{i:0;a:5:{s:4:\"data\";s:9:\"Community\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:1;a:5:{s:4:\"data\";s:8:\"Features\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:2;a:5:{s:4:\"data\";s:10:\"Interviews\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:3;a:5:{s:4:\"data\";s:9:\"HeroPress\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:4;a:5:{s:4:\"data\";s:19:\"People of WordPress\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:5;a:5:{s:4:\"data\";s:15:\"WordCamp Mumbai\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:6;a:5:{s:4:\"data\";s:16:\"wptranslationday\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:35:\"https://wordpress.org/news/?p=12706\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:106:\"This month\'s People of WordPress feature shares the story of developer and e-commerce builder Meher Bala. \";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:28:\"webcommsat AbhaNonStopNewsUK\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:16754:\"\n<p>In this series, we share some of the inspiring stories of how WordPress and its global network of contributors can change people’s lives for the better. This month we feature a Indian-based WordPress developer and long term contributor on how it helped her find a career and a local and global community to belong to.</p>\n\n\n\n<figure class=\"wp-block-image size-large\"><img decoding=\"async\" loading=\"lazy\" width=\"1024\" height=\"515\" src=\"https://i2.wp.com/wordpress.org/news/files/2022/04/meher-1.jpg?resize=1024%2C515&#038;ssl=1\" alt=\"Meher pictured against the backdrop of a window overlooking trees \" class=\"wp-image-12728\" srcset=\"https://i2.wp.com/wordpress.org/news/files/2022/04/meher-1.jpg?resize=1024%2C515&amp;ssl=1 1024w, https://i2.wp.com/wordpress.org/news/files/2022/04/meher-1.jpg?resize=300%2C151&amp;ssl=1 300w, https://i2.wp.com/wordpress.org/news/files/2022/04/meher-1.jpg?resize=768%2C386&amp;ssl=1 768w, https://i2.wp.com/wordpress.org/news/files/2022/04/meher-1.jpg?w=1247&amp;ssl=1 1247w\" sizes=\"(max-width: 1000px) 100vw, 1000px\" data-recalc-dims=\"1\" /></figure>\n\n\n\n<p><strong>WordPress is an inspiration to Meher Bala, a frontend web developer and community builder from India. From using the software as a basic website tool to helping entrepreneurs and good causes around the world fulfill their aspirations, she has overcome personal barriers and now aims to inspire others.</strong></p>\n\n\n\n<p>Meher found her vocation and learned new skills through WordPress. She also discovered a way to encourage other women to consider careers in IT.&nbsp;</p>\n\n\n\n<h2>Opening the doors to a career in technology</h2>\n\n\n\n<p>As a child, Meher was diagnosed with dyslexia (difficulty in reading the written word) and dyscalculia (difficulty in comprehending numbers and mathematical functions). With the support of her parents and a tutor, she was able to overcome this learning obstacle. She developed coping techniques and a determination to work to overcome challenges as they appeared later in life.</p>\n\n\n\n<p>In school, she got an opportunity to replace one subject with computer studies as an alternative. This proved to be an eye-opener to future career possibilities.&nbsp;</p>\n\n\n\n<p>She began to research not only what the internet had to offer but also how it worked, including the new and fascinating concepts of email and websites. Her father bought the family’s first desktop computer so she could do her research at home.</p>\n\n\n\n<p>Meher’s father wanted to turn her love for computers into something that would serve her well in the future. In 2005, he enrolled her in a short computer course from a global IT training provider. The course tutor was so impressed with her performance, she was advised to enroll in a four year software development course.</p>\n\n\n\n<p>That meant she had studied the software development course alongside her higher education college course. Looking back, she enjoyed the dual challenge of the degree course in commerce, and the experience prepared her well to keep learning software while working as a developer. Within three years, she had learned C#, C, C++, HTML, Java, and .NET. </p>\n\n\n\n<p>After graduation, she was in a dilemma to choose between commerce and IT. What to choose? She had a compulsory one-year technology internship to complete, and her choice of focus for that year would prove to be a defining moment.</p>\n\n\n\n<p>In 2009, on her birthday, Meher was offered an internship. On the first day of the internship, she was introduced to WordPress. Her initial assignment was to change the look and feel of the WordPress dashboard — in just six hours. But there was a problem &#8211; she had never worked with WordPress before!</p>\n\n\n\n<blockquote class=\"wp-block-quote\"><p>&#8220;I stared at the whiteboard and thought that task given was impossible and difficult to meet the deadline. I wondered if my boss was joking and did not know then what you could do with WordPress as a developer and how it could slot into your toolbox. It opened my eyes.&#8221;&nbsp;</p><cite>Meher Bala</cite></blockquote>\n\n\n\n<p>Meher used her research skills to know more about using WordPress. She found a plugin that would help her achieve her task. She met the deadline and it ingrained an interest that she would never lose. </p>\n\n\n\n<h2>Re-discovering WordPress</h2>\n\n\n\n<p>Five years after her initial WordPress experience, Meher was assigned to lead an international project in WordPress.&nbsp;She was hesitant — she had lost touch with the CMS during that five years, but the project was a great opportunity to become a team leader and lead from the front.&nbsp;</p>\n\n\n\n<p>She decided to update her WordPress skills, relying again on the strength of her research skills and determination. In the process, she also taught her team all about WordPress, inspiring many of those members to continue to develop their WordPress skill set.</p>\n\n\n\n<p>The success of that project was a pivotal moment for Meher and a new dawn as a developer specializing in WordPress.</p>\n\n\n\n<p>As a team lead, Meher soon found it was not possible to always have all the answers straight away. She found internet searches gave practical solutions—but rarely explained the theory behind it.</p>\n\n\n\n<p>So she went looking for a WordPress group to help her expand the scope and depth of her knowledge.</p>\n\n\n\n<h2>Finding the community and its developer learning opportunities </h2>\n\n\n\n<figure class=\"wp-block-image size-full\"><img decoding=\"async\" loading=\"lazy\" width=\"999\" height=\"667\" src=\"https://i2.wp.com/wordpress.org/news/files/2022/04/dsc_00345.jpg?resize=999%2C667&#038;ssl=1\" alt=\"Meher at WordCamp Nagpur in 2017\" class=\"wp-image-12762\" srcset=\"https://i2.wp.com/wordpress.org/news/files/2022/04/dsc_00345.jpg?w=999&amp;ssl=1 999w, https://i2.wp.com/wordpress.org/news/files/2022/04/dsc_00345.jpg?resize=300%2C200&amp;ssl=1 300w, https://i2.wp.com/wordpress.org/news/files/2022/04/dsc_00345.jpg?resize=768%2C513&amp;ssl=1 768w\" sizes=\"(max-width: 999px) 100vw, 999px\" data-recalc-dims=\"1\" /><figcaption>Meher enjoying being part of <em>WordCamp Nagpur in 2017</em></figcaption></figure>\n\n\n\n<p>In 2015, while browsing Facebook, Meher came across an advertisement for something called WordCamp Mumbai, an event that had taken two days before. She did a little digging to learn what a WordCamp was, and about the people behind it. She took the plunge and joined the WordPress Mumbai Meetup group.</p>\n\n\n\n<p>Her first Meetup experience was not love at first sight. She felt the topics were for advanced users, and the timing late in the evening made it difficult to attend.</p>\n\n\n\n<p>But a few months later, the Meetup addressed a topic that could help her resolve an issue in one of her current projects. She made the effort to show up and came away with a number of important tips.&nbsp;The speaker had taken the time to speak to individual attendees. When he came to Meher, she took the opportunity to ask a couple of questions about her project issues. </p>\n\n\n\n<p>Thereafter she went to more Meetups and got to know the people behind this group, just as they started talking about WordCamp Mumbai 2016.</p>\n\n\n\n<h2>A WordCamp adventure</h2>\n\n\n\n<figure class=\"wp-block-image size-full is-resized\"><img decoding=\"async\" loading=\"lazy\" src=\"https://i1.wp.com/wordpress.org/news/files/2022/04/wcm16.jpg?resize=600%2C800&#038;ssl=1\" alt=\"Meher pictured with the WordCamp Mumbai 2016 sign \" class=\"wp-image-12758\" width=\"600\" height=\"800\" srcset=\"https://i1.wp.com/wordpress.org/news/files/2022/04/wcm16.jpg?w=600&amp;ssl=1 600w, https://i1.wp.com/wordpress.org/news/files/2022/04/wcm16.jpg?resize=225%2C300&amp;ssl=1 225w\" sizes=\"(max-width: 600px) 100vw, 600px\" data-recalc-dims=\"1\" /><figcaption>Meher discovering <em>WordCamps in Mumbai in 2016</em></figcaption></figure>\n\n\n\n<p>Meher expressed interest in being a part of the coming&nbsp; WordCamp Mumbai and started in an entry-level role with basic responsibilities.</p>\n\n\n\n<p>At first, she thought WordCamp was a formal conference with about 100 people. So on the first day of WordCamp Mumbai 2016, she was surprised to see so many WordCamp enthusiasts attending and enjoying such a relaxed and friendly conference.</p>\n\n\n\n<p>After that great experience, Meher went to many more meetups and did more volunteering. She started taking on responsibilities in the coming WordCamps and getting to know the different aspects of the camp.&nbsp;</p>\n\n\n\n<p>In the following years, at each WordPress, she took up a new role like speaker vetting, sponsors, and volunteer coordination. This allowed her to know more about what an organizer needs to do, from planning to execution, to make WordCamp a successful event.</p>\n\n\n\n<figure class=\"wp-block-image size-full\"><img decoding=\"async\" loading=\"lazy\" width=\"900\" height=\"600\" src=\"https://i2.wp.com/wordpress.org/news/files/2022/04/wcmumbai-17.jpg?resize=900%2C600&#038;ssl=1\" alt=\"WordCamp Mumbai 2017 group photo of the team\" class=\"wp-image-12765\" srcset=\"https://i2.wp.com/wordpress.org/news/files/2022/04/wcmumbai-17.jpg?w=900&amp;ssl=1 900w, https://i2.wp.com/wordpress.org/news/files/2022/04/wcmumbai-17.jpg?resize=300%2C200&amp;ssl=1 300w, https://i2.wp.com/wordpress.org/news/files/2022/04/wcmumbai-17.jpg?resize=768%2C512&amp;ssl=1 768w\" sizes=\"(max-width: 900px) 100vw, 900px\" data-recalc-dims=\"1\" /><figcaption>With the team at <em>WordCamp Mumbai in 2017</em></figcaption></figure>\n\n\n\n<p>Meher is grateful for her WordPress journey which was fostered in the Mumbai community. It has been filled with beautiful surprises.&nbsp;</p>\n\n\n\n<p>When people ask why she’s chosen to specialize professionally in WordPress, Meher says WordPress is easy to teach a non-technical person, yet it is still highly customizable. Being a WordPress developer has given her the opportunity to work&nbsp; remotely for global web development companies that let her think out of the box. And she learns new skills with every release.</p>\n\n\n\n<h3>The community makes WordPress special</h3>\n\n\n\n<p>Meher says that some of her most memorable WordPress moments have revolved around special friendships, trying new things, and participating in community building.&nbsp;</p>\n\n\n\n<p>WordPress has let her explore different parts of India, make new friends locally and internationally, and encourage women to be a part of meetup groups and events across India.&nbsp;</p>\n\n\n\n<p>One of Meher’s biggest dreams was to lead WordCamp Mumbai as a lead organizer and show others what could be achieved by working together in open source. In 2019, she did just that and has volunteered at international WordCamps and meetups since.</p>\n\n\n\n<figure class=\"wp-block-image size-large\"><img decoding=\"async\" loading=\"lazy\" width=\"1024\" height=\"515\" src=\"https://i0.wp.com/wordpress.org/news/files/2022/04/wc-19.jpg?resize=1024%2C515&#038;ssl=1\" alt=\"Meher speaking at WordCamp Mumbai 2019\" class=\"wp-image-12731\" srcset=\"https://i0.wp.com/wordpress.org/news/files/2022/04/wc-19.jpg?resize=1024%2C515&amp;ssl=1 1024w, https://i0.wp.com/wordpress.org/news/files/2022/04/wc-19.jpg?resize=300%2C151&amp;ssl=1 300w, https://i0.wp.com/wordpress.org/news/files/2022/04/wc-19.jpg?resize=768%2C386&amp;ssl=1 768w, https://i0.wp.com/wordpress.org/news/files/2022/04/wc-19.jpg?w=1247&amp;ssl=1 1247w\" sizes=\"(max-width: 1000px) 100vw, 1000px\" data-recalc-dims=\"1\" /><figcaption>Taking to the stage at WordCamp Mumbai in 2019</figcaption></figure>\n\n\n\n<p>As part of her enthusiasm for sharing the opportunities WordPress can give people, especially women, she has given time to co-organize two global <a href=\"https://wptranslationday.org/\">WordPress Translation month long events</a> and contributor events in India.&nbsp;&nbsp;&nbsp;</p>\n\n\n\n<p>Meher said: “I was first introduced to translation at one of the meetups which was organised to support the WordPress Translation Day. I realized this was another way to support my local communities and bring the power of WordPress to them by contributing in Gujarati and Hindi. I did not imagine I would a few years later be a global organizer for the event itself!”</p>\n\n\n\n<p>With her commitment to ongoing learning as a developer and to model what she believes about the value and community growth opportunities of open source, Meher has given time and energy to the Marketing Team, where she has been a Team Rep, to the Training Team, and to the Core Team contributing to multiple releases.&nbsp;</p>\n\n\n\n<h2>The developer adventure with WordPress is unlimited</h2>\n\n\n\n<blockquote class=\"wp-block-quote\"><p>At the start of my software developer journey, I always thought the C++ and Java were the only skills you required to excel in your career. From the time I started exploring WordPress in depth, I realized the potential and the power of WordPress in web development.</p><cite>Meher Bala</cite></blockquote>\n\n\n\n<p>Being a part of the WordPress community, Meher learned that there is so much more than just building blogs on WordPress. She started exploring different features of WordPress, created her first theme, and eventually specialized as a frontend specialist.</p>\n\n\n\n<p>Meher now works as a consultant and front end developer with an international agency specializing in WordPress. Asked what she thought was the best thing about being a WordPress developer, Meher replied: &#8220;Through WordPress, I have an opportunity to build unique out of the box websites and work&nbsp;remotely for global web development companies that encourages you to think out of the box. There is always opportunity to continuously advance my coding skills and learn new techniques with every release.&#8221; </p>\n\n\n\n<p>She believes that there is no limit to where using the software can take you and what you can combine it with to find solutions to projects big and small.</p>\n\n\n\n<p>If you earn a living from WordPress, her advice is from the heart: try to give back to the WordPress community.</p>\n\n\n\n<p>“I am sure you will learn or teach something new and definitely make friends across the world. There is no shame in making mistakes, as you can learn from them and develop your skills further. You can also help others as they build their skills.”</p>\n\n\n\n<p>Meher added: “Don’t let the things you find difficult get in the way of your success.”</p>\n\n\n\n<h2 id=\"share-the-stories\">Share the stories</h2>\n\n\n\n<p>Help share these stories of open source contributors and continue to grow the community. Meet more WordPressers in the <a href=\"https://wordpress.org/news/category/newsletter/interviews/\">People of WordPress series</a>.</p>\n\n\n\n<h2>Contributors</h2>\n\n\n\n<p>Thanks to Abha Thakor (<a href=\'https://profiles.wordpress.org/webcommsat/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>webcommsat</a>), Larissa Murillo (<a href=\'https://profiles.wordpress.org/lmurillom/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>lmurillom</a>), Mary Baum (<a href=\'https://profiles.wordpress.org/marybaum/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>marybaum</a>), Chloé Bringmann (<a href=\'https://profiles.wordpress.org/cbringmann/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>cbringmann</a>), and Meg Phillips (<a href=\'https://profiles.wordpress.org/megphillips91/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>megphillips91</a>) for interviews, writing and image work on this story. Thank you to Meher Bala (<a href=\'https://profiles.wordpress.org/meher/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>meher</a>) for sharing her experiences and to Josepha Haden Chomphosy (<a href=\'https://profiles.wordpress.org/chanthaboune/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>chanthaboune</a>) and Topher DeRosia (<a href=\'https://profiles.wordpress.org/topher1kenobe/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>topher1kenobe</a>) for their support of the series. </p>\n\n\n\n<div class=\"wp-block-media-text is-stacked-on-mobile is-vertically-aligned-center\" style=\"grid-template-columns:29% auto\"><figure class=\"wp-block-media-text__media\"><img decoding=\"async\" loading=\"lazy\" width=\"180\" height=\"135\" src=\"https://i1.wp.com/wordpress.org/news/files/2020/03/heropress_logo_180.png?resize=180%2C135&#038;ssl=1\" alt=\"HeroPress logo\" class=\"wp-image-8409 size-full\" data-recalc-dims=\"1\" /></figure><div class=\"wp-block-media-text__content\">\n<p class=\"has-small-font-size\"><em>This People of WordPress feature is inspired by an essay originally published on </em><a href=\"https://heropress.com/\"><em>HeroPress.com</em></a><em>, a community initiative created by Topher DeRosia. It highlights people in the WordPress community who have overcome barriers and whose stories might otherwise go unheard. </em>#HeroPress </p>\n</div></div>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:30:\"com-wordpress:feed-additions:1\";a:1:{s:7:\"post-id\";a:1:{i:0;a:5:{s:4:\"data\";s:5:\"12706\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:13;a:6:{s:4:\"data\";s:69:\"\n		\n		\n		\n		\n		\n				\n		\n		\n		\n		\n		\n\n					\n										\n					\n		\n		\n			\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:4:{s:0:\"\";a:6:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:20:\"WordPress 6.0 Beta 3\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:56:\"https://wordpress.org/news/2022/04/wordpress-6-0-beta-3/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Tue, 26 Apr 2022 16:43:38 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:5:{i:0;a:5:{s:4:\"data\";s:11:\"Development\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:1;a:5:{s:4:\"data\";s:8:\"Releases\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:2;a:5:{s:4:\"data\";s:3:\"6.0\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:3;a:5:{s:4:\"data\";s:11:\"development\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:4;a:5:{s:4:\"data\";s:8:\"releases\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:35:\"https://wordpress.org/news/?p=12690\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:103:\"WordPress 6.0 Beta 3 is now available for testing! You can download and help test Beta 3 in three ways.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:11:\"Dan Soschin\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:5387:\"\n<p>WordPress 6.0 Beta 3 is now available for testing!</p>\n\n\n\n<p><strong>This version of the WordPress software is under development</strong>. Please do not install, run, or test this version of WordPress production or mission-critical websites. Instead, it is recommended that you test Beta 3 on a test server and site.&nbsp;</p>\n\n\n\n<p>You can test WordPress 6.0 Beta 3 in three ways:</p>\n\n\n\n<p><strong>Option 1: </strong>Install and activate the <a href=\"https://wordpress.org/plugins/wordpress-beta-tester/\">WordPress Beta Tester</a> plugin (select the “Bleeding edge” channel and “Beta/RC Only” stream).</p>\n\n\n\n<p><strong>Option 2: </strong>Direct download the <a href=\"https://wordpress.org/wordpress-6.0-beta3.zip\">beta version here (zip)</a>.</p>\n\n\n\n<p><strong>Option 3:</strong> Use WP-CLI to test: <code>wp core update --version=6.0-beta3</code>.<br><em>Do not use this option if your filesystem is case-insensitive.</em></p>\n\n\n\n<p>The current target for the final 6.0 release is May 24, 2022, which is in less than a month!&nbsp;</p>\n\n\n\n<p>Additional information on the full <a href=\"https://make.wordpress.org/core/6-0/\">6.0 release cycle is available here</a>.</p>\n\n\n\n<p>Check the <a href=\"https://make.wordpress.org/core/\">Make WordPress Core blog</a> for <a href=\"https://make.wordpress.org/core/tag/dev-notes+6-0/\">6.0-related developer notes</a> in the coming weeks which will detail all upcoming changes.</p>\n\n\n\n<h2>See What’s in Beta 3</h2>\n\n\n\n<p>Since Beta 2, various items have been addressed, including (but not limited to):&nbsp;</p>\n\n\n\n<ul><li>Twenty Twenty-Two: Implement alternate json files <a href=\"https://core.trac.wordpress.org/ticket/55433\">#55433</a></li><li>Fix duotone rendering in site editor <a href=\"https://github.com/WordPress/gutenberg/pull/37727\">#37727</a>&nbsp;</li><li>Create Comments Title block with simple styling <a href=\"https://github.com/WordPress/gutenberg/pull/40419\">#40419</a>&nbsp;</li><li>Navigation block: After choosing an option from Select Menu, focus after block render <a href=\"https://github.com/WordPress/gutenberg/pull/40390\">#40390</a></li><li>Add comment id to all comments inside comments query loop <a href=\"https://github.com/WordPress/gutenberg/pull/40268\">#40268</a></li><li>Add post-comments-form block to comments template <a href=\"https://github.com/WordPress/gutenberg/pull/40256\">#40256</a></li><li>Elements: Add styles to the footer before the block is rendered <a href=\"https://github.com/WordPress/gutenberg/pull/37728\">#37728</a></li><li>Add default comment status to discussion settings&nbsp; <a href=\"https://core.trac.wordpress.org/ticket/55567\">#55567</a></li><li>Fix styles for nested elements (link color) <a href=\"https://core.trac.wordpress.org/ticket/55567\">#55567</a></li><li>Move <code>wp_enqueue_block_style()</code> to <code>wp-includes/script-loader.php</code>, for better consistency <a href=\"https://core.trac.wordpress.org/ticket/55182\">#55182</a>, <a href=\"https://core.trac.wordpress.org/ticket/55148\">#55148</a></li><li>Move administration related hooks to admin-filters.php <a href=\"https://core.trac.wordpress.org/ticket/54795\">#54795</a></li></ul>\n\n\n\n<h2>Update on the Webfonts API and Style Variations in Twenty Twenty-Two</h2>\n\n\n\n<p>A <a href=\"https://wordpress.org/news/2022/04/wordpress-6-0-beta-1/\">prior announcement</a> for WordPress 6.0 Beta 1 included a reference to “Webfonts API:<strong> </strong>Manage local fonts with PHP or theme.json”, as a feature that would be included in the release. WordPress 6.0 Beta 3 will allow theme authors to use webfonts in theme.json, with a public API for plugins to register and enqueue webfonts available in a future version for WordPress. Beta 3 will also include <a href=\"https://core.trac.wordpress.org/ticket/55433\">three new style variations</a> to the Twenty Twenty-Two default theme.</p>\n\n\n\n<h2>How to Help</h2>\n\n\n\n<p>Testing for issues is critical for stabilizing a release throughout its development. Testing is also a great way to contribute to WordPress. If you are new to testing, check out this <a href=\"https://make.wordpress.org/test/2022/04/12/help-wanted-test-wordpress-6-0/\">detailed guide</a> that will walk you through how to get started.</p>\n\n\n\n<p>If you think you have run into an issue, please report it to the <a href=\"https://wordpress.org/support/forum/alphabeta/\">Alpha/Beta area</a> in the support forums. If you are comfortable writing a reproducible bug report, you can <a href=\"https://core.trac.wordpress.org/newticket\">file one on WordPress Trac</a>. This is also where you can find a list of <a href=\"https://core.trac.wordpress.org/tickets/major\">known bugs</a>.</p>\n\n\n\n<hr class=\"wp-block-separator has-alpha-channel-opacity\" />\n\n\n\n<p>Thank you to the following contributors for collaborating on this post: <a href=\'https://profiles.wordpress.org/dansoschin/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>dansoschin</a>&nbsp; <a href=\'https://profiles.wordpress.org/webcommsat/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>webcommsat</a>, <a href=\'https://profiles.wordpress.org/audrasjb/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>audrasjb</a></p>\n\n\n\n<hr class=\"wp-block-separator has-alpha-channel-opacity\" />\n\n\n\n<p><strong>And now another WordPress haiku:</strong></p>\n\n\n\n<p>Release day is near<br>6.0 abounds with joy<br>New features soon here</p>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:30:\"com-wordpress:feed-additions:1\";a:1:{s:7:\"post-id\";a:1:{i:0;a:5:{s:4:\"data\";s:5:\"12690\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:14;a:6:{s:4:\"data\";s:60:\"\n		\n		\n		\n		\n		\n				\n		\n		\n\n					\n										\n					\n		\n		\n			\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:4:{s:0:\"\";a:6:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:20:\"WordPress 6.0 Beta 2\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:56:\"https://wordpress.org/news/2022/04/wordpress-6-0-beta-2/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Tue, 19 Apr 2022 16:43:30 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:2:{i:0;a:5:{s:4:\"data\";s:11:\"Development\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:1;a:5:{s:4:\"data\";s:8:\"Releases\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:35:\"https://wordpress.org/news/?p=12666\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:337:\"WordPress 6.0 Beta 2 is now available for testing! This version of the WordPress software is under development. Please do not install, run, and test this version of WordPress on a production or mission-critical website. Instead, it is recommended that you test Beta 2 on a test server and site.&#160; You can test the WordPress [&#8230;]\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:15:\"Chloe Bringmann\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:5119:\"\n<p>WordPress 6.0 Beta 2 is now available for testing!</p>\n\n\n\n<p><strong>This version of the WordPress software is under development</strong>. Please do not install, run, and test this version of WordPress on a production or mission-critical website. Instead, it is recommended that you test Beta 2 on a test server and site.&nbsp;</p>\n\n\n\n<p>You can test the WordPress 6.0 Beta 2 in three ways:</p>\n\n\n\n<p><strong>Option 1: </strong>Install and activate the <a href=\"https://wordpress.org/plugins/wordpress-beta-tester/\">WordPress Beta Tester</a> plugin (select the “Bleeding edge” channel and “Beta/RC Only” stream).</p>\n\n\n\n<p><strong>Option 2: </strong>Direct download the<a href=\"https://wordpress.org/wordpress-6.0-beta2.zip\"> beta version here (zip)</a>.</p>\n\n\n\n<p><strong>Option 3:</strong> Use WP-CLI to test: <code>wp core update --version=6.0-beta2</code><br><strong><em>Do not use this option if your filesystem is case-insensitive.</em></strong></p>\n\n\n\n<p>The current target for the final release is May 24, 2022, which is about five weeks away.&nbsp;</p>\n\n\n\n<p>Additional information on the full <a href=\"https://make.wordpress.org/core/6-0/\">6.0 release cycle is available</a>.</p>\n\n\n\n<p>Check the <a href=\"https://make.wordpress.org/core/\">Make WordPress Core blog</a> for <a href=\"https://make.wordpress.org/core/tag/dev-notes+6-0/\">6.0-related developer notes</a> in the coming weeks, which will detail all upcoming changes.</p>\n\n\n\n<h2><strong>What’s New In Beta 2</strong></h2>\n\n\n\n<p>As a reminder, contributors have fixed&nbsp;<a href=\"https://core.trac.wordpress.org/query?status=closed&amp;resolution=fixed&amp;milestone=6.0&amp;group=component&amp;order=priority\">209 tickets in WordPress 6.0</a>, including&nbsp;<a href=\"https://core.trac.wordpress.org/query?status=closed&amp;status=reopened&amp;changetime=04%2F12%2F2022..04%2F19%2F2022&amp;type=enhancement&amp;type=feature+request&amp;milestone=6.0&amp;group=component&amp;col=id&amp;col=summary&amp;col=type&amp;col=status&amp;col=milestone&amp;col=changetime&amp;col=owner&amp;col=priority&amp;col=keywords&amp;order=changetime\">110 new features and enhancements</a>. Each beta cycle focuses on bug fixes, and more are on the way with your help through testing. Here are a few of the changes you will find in Beta 2 specifically:&nbsp;</p>\n\n\n\n<ul><li>Block Editor: Prevent styles from being added to the site editor (#<a href=\"https://core.trac.wordpress.org/ticket/55567\">55567</a>)</li><li>Patterns REST API: Add &#8216;inserter&#8217; to the schema&nbsp; (#<a href=\"https://core.trac.wordpress.org/ticket/55567\">55567</a>)</li><li>Don’t load remote patterns twice in WP_REST_Block_Patterns_Controller::get_items (#<a href=\"https://core.trac.wordpress.org/ticket/55567\">55567</a>)</li><li>Add the ability to filter the whole notification email in retrieve_password (<a href=\"https://core.trac.wordpress.org/ticket/54690\">#54690</a>)</li><li>Avoid translating empty plugin headers (<a href=\"https://core.trac.wordpress.org/ticket/54586\">#54586</a>)</li></ul>\n\n\n\n<h3><strong>Note on Webfonts API</strong></h3>\n\n\n\n<p>Last week’s announcement for <a href=\"https://wordpress.org/news/2022/04/wordpress-6-0-beta-1/\">WordPress 6.0 Beta 1</a> includes a reference to “Webfonts API:<strong> </strong>Manage local fonts with PHP or theme.json,” as a feature that would be included in the release. This specific functionality was not included in Beta 2 but may be available at RC.</p>\n\n\n\n<h2><strong>How to Help</strong></h2>\n\n\n\n<p>Testing for issues is critical for stabilizing a release throughout its development. Testing is also a great way to contribute to WordPress. If you are new to testing, check out this <a href=\"https://make.wordpress.org/test/2022/04/12/help-wanted-test-wordpress-6-0/\">detailed guide</a> that will walk you through how to get started.</p>\n\n\n\n<p>If you think you have run into an issue, please report it to the<a href=\"https://wordpress.org/support/forum/alphabeta/\"> Alpha/Beta area</a> in the support forums. If you are comfortable writing a reproducible bug report, you can<a href=\"https://core.trac.wordpress.org/newticket\"> file one on WordPress Trac</a>. This is also where you can find a list of<a href=\"https://core.trac.wordpress.org/tickets/major\"> known bugs</a>.</p>\n\n\n\n<hr class=\"wp-block-separator has-alpha-channel-opacity\" />\n\n\n\n<p>Thank you to the following contributors for collaborating on this post: <a href=\'https://profiles.wordpress.org/dansoschin/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>dansoschin</a>, <a href=\'https://profiles.wordpress.org/annezazu/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>annezazu</a>, <a href=\'https://profiles.wordpress.org/costdev/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>costdev</a>, <a href=\'https://profiles.wordpress.org/priethor/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>priethor</a></p>\n\n\n\n<hr class=\"wp-block-separator has-alpha-channel-opacity\" />\n\n\n\n<h4>And now a WordPress Haiku:</h4>\n\n\n\n<p>We code fervently</p>\n\n\n\n<p>A breathless pause for the test</p>\n\n\n\n<p>Key tapping resumes</p>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:30:\"com-wordpress:feed-additions:1\";a:1:{s:7:\"post-id\";a:1:{i:0;a:5:{s:4:\"data\";s:5:\"12666\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:15;a:6:{s:4:\"data\";s:61:\"\n		\n		\n		\n		\n		\n				\n		\n		\n\n					\n										\n					\n		\n		\n\n			\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:4:{s:0:\"\";a:7:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:53:\"WP Briefing: Episode 29: How to Make a WordPress Blog\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:75:\"https://wordpress.org/news/2022/04/episode-29-how-to-make-a-wordpress-blog/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Mon, 18 Apr 2022 12:00:00 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:2:{i:0;a:5:{s:4:\"data\";s:7:\"Podcast\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:1;a:5:{s:4:\"data\";s:11:\"wp-briefing\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:53:\"https://wordpress.org/news/?post_type=podcast&p=12658\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:150:\"Join our host Josepha Haden Chomphosy as she takes us back to WordPress basics. Learn everything you need to know about how to make a WordPress blog! \";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:9:\"enclosure\";a:1:{i:0;a:5:{s:4:\"data\";s:0:\"\";s:7:\"attribs\";a:1:{s:0:\"\";a:3:{s:3:\"url\";s:60:\"https://wordpress.org/news/files/2022/04/WP-Briefing-029.mp3\";s:6:\"length\";s:1:\"0\";s:4:\"type\";s:0:\"\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:14:\"Santana Inniss\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:16764:\"\n<p>In the twenty-ninth episode of the WordPress Briefing, Executive Director Josepha Haden Chomphosy reminds us of our WordPress roots &#8212; blogging &#8212; and discusses the basics of starting your first blog on WordPress.</p>\n\n\n\n<p><em><strong>Have a question you&#8217;d like answered? You can submit them to <a href=\"mailto:wpbriefing@wordpress.org\">wpbriefing@wordpress.org</a>, either written or as a voice recording.</strong></em></p>\n\n\n\n<h2 id=\"credits\">Credits</h2>\n\n\n\n<ul><li>Editor:&nbsp;<a href=\"https://profiles.wordpress.org/dustinhartzler/\">Dustin Hartzler</a></li><li>Logo:&nbsp;<a href=\"https://profiles.wordpress.org/beafialho/\">Beatriz Fialho</a></li><li>Production:&nbsp;<a href=\"https://profiles.wordpress.org/santanainniss/\">Santana Inniss</a> </li><li>Song: Fearless First by Kevin MacLeod</li></ul>\n\n\n\n<h2>References</h2>\n\n\n\n<ul><li><a href=\"https://learn.wordpress.org/course/getting-started-with-wordpress-get-setup/\">Getting Started with WordPress: Get Setup</a></li><li><a href=\"https://make.wordpress.org/core/2022/04/07/6-0-product-walk-through-recap/\">6.0 Product Walkthrough</a></li><li><a href=\"https://www.meetup.com/wordpress-social-learning/events/285233962/\" data-type=\"URL\" data-id=\"https://www.meetup.com/wordpress-social-learning/events/285233962/\">How to Make a WordPress Blog Social Learning Space Event </a></li><li><a href=\"https://make.wordpress.org/community/events/\">Upcoming WordPress Events</a></li><li><a href=\"https://www.meetup.com/pro/wordpress/\" data-type=\"URL\" data-id=\"https://www.meetup.com/pro/wordpress/\">WordPress Meetup Groups</a></li></ul>\n\n\n\n<h2>Transcript</h2>\n\n\n\n<span id=\"more-12658\"></span>\n\n\n\n<p><strong>Josepha Haden Chomphosy [00:00:00] </strong>&nbsp;</p>\n\n\n\n<p>Hello everyone. And welcome to the WordPress Briefing. The podcast where you can catch quick explanations of the ideas behind the WordPress open source project, some insight into the community that supports it, and get a small list of big things coming up in the next two weeks. I&#8217;m your host, Josepha Haden Chomphosy.</p>\n\n\n\n<p>Here we go.</p>\n\n\n\n<p><strong>Josepha Haden Chomphosy [00:00:39] </strong>&nbsp;</p>\n\n\n\n<p>All right. So you&#8217;ve been listening to this podcast for a while. You may be one of these contributors I keep mentioning; you may be an agency owner or freelancer. Maybe you&#8217;ve wondered how to make a WordPress blog for your big idea. Or, maybe you&#8217;re one of the many people who use WordPress for their project or business. Before WordPress was known as a content management system, as a way to get sites online fast, it was a blogging tool.</p>\n\n\n\n<p>We have long since outgrown that, but even 19 years into our journey, blogging is still a key part of what WordPress enables you to do. That&#8217;s because even after those 19 years, the mission of WordPress is still the same. And that is to democratize publishing, to help people have a place online where they can tell their stories or share their projects or set up their businesses.</p>\n\n\n\n<p>If you&#8217;ve ever tried to set up a blog, you know that there isn&#8217;t a lot of information about what to know before you get going at all. So I&#8217;m going to talk about that a little bit today. And just by the way, if you heard the word blog right now and thought, oh, Josepha, how old fashioned? I think it&#8217;s important to remember that there&#8217;s a business advantage to having well-written, relevant content on your website.</p>\n\n\n\n<p><strong>Josepha Haden Chomphosy [00:01:59]</strong></p>\n\n\n\n<p>And if you&#8217;re not blogging for business, because not all of us are, then the benefits are a little different but still important to my mind. Things like the cathartic benefits of journaling, a chance to build community, and the general importance of preserving wisdom for the ages. Anyway, back to the topic at hand. Before we can get to any of the fancy things that WordPress can do nowadays, it&#8217;s important to know a few things as you get ready to set up your first ever website.&nbsp;&nbsp;</p>\n\n\n\n<p>So let&#8217;s dive in. Here is how you need to get yourself started. First, have an idea and a plan. So have an idea for what you&#8217;re doing, the concept of your content, who you want to reach, and some concept of a domain name. I would encourage you to not necessarily get your heart set on a domain name at first. Cause, like, if you want the domain name, wordpress.org, like we own that, you can have that! But if you know that you want a domain like WordPressbloggingforthefuture.com, like that one might be more available. And if you know the kind of words you want in your domain, you can be a bit flexible about what is there.&nbsp;</p>\n\n\n\n<p><strong>Josepha Haden Chomphosy [00:03:09]</strong></p>\n\n\n\n<p>The second thing that you need to do is that if you are just getting started, ask yourself the question, what sort of host do I want? We kind of mentioned all along the WordPress process that, like, you need a good host, but it’s not always clear where that decision has to happen. It happens right here at the start, before you even know what WordPress is most of the time.</p>\n\n\n\n<p>So, the earliest question that you have to answer for yourself is what sort of host do I want? Where do I want my site to live? So ask yourself how much you want to get into the maintenance and configuration of your website and the hardware that it lives on versus creating content or keeping your shop up to date.&nbsp;</p>\n\n\n\n<p>There&#8217;s this whole spectrum of hosting options, and they range from full service where they will keep your WordPress software up to date, provide daily backups, and have customer support if something goes really wrong. So it ranges all the way from full service like that all the way down to essentially zero services, just kind of hands-off.</p>\n\n\n\n<p><strong>Josepha Haden Chomphosy [00:04:11]&nbsp;</strong></p>\n\n\n\n<p>They give you a space to keep your WordPress software, to keep your WordPress site. But they leave everything else up to you. They leave the backups up to you. They leave updating up to you, things like. So that&#8217;s the first thing you have to ask yourself. And the first question you have to be able to answer. Most of the time, you will want to start with one of the full-service options. That way, you know that your software is set up correctly and safely from the start. And as you learn more about the software and what you want and what you need, and you have the ability to learn in the time that you have, the more that you can add on either service with the existing hosts that you chose or moving to a different host; however that works out for you.</p>\n\n\n\n<p>So if that one sounds like the right option, then you choose a host, go to their site, and actually most of them will have a way to walk you through how to set up a WordPress site inside their system. Most of the time, it&#8217;s just one click and then they ask you some questions to get some configurations right.</p>\n\n\n\n<p><strong>Josepha Haden Chomphosy [00:05:10]&nbsp;</strong></p>\n\n\n\n<p>The other option that on the like zero, zero service side, that&#8217;s not quite fair, but you know, the other side of that spectrum that probably will be appealing to you if you are already familiar with code or already know how to manage a server or, or you know how to work in this thing called c-panel, et cetera.</p>\n\n\n\n<p>So if you already have a lot of information on how all of that works, you can, if you want to, head over to wordpress.org/download, and you can download a zip file of the WordPress software and set that up in your own environment.&nbsp;</p>\n\n\n\n<p>Okay, quick check here. If this all sounds roughly doable to you, or at least it feels like we&#8217;re in the right starting point, but you find yourself thinking, gosh, I just wish she would slow down a little.</p>\n\n\n\n<p>I&#8217;ve got you covered. In the show notes, you&#8217;ll find a link to one of the Learn WP courses for getting started with WordPress. There&#8217;s a section on choosing a host as well as various other early steps of this process. So if you felt like I blazed through all of that, which honestly I kind of did, you can work through those lessons in that course, at your own pace, and it&#8217;s, and it&#8217;s really a very good guide.</p>\n\n\n\n<p><strong>Josepha Haden Chomphosy [00:06:24]&nbsp;</strong></p>\n\n\n\n<p>All right. Let&#8217;s pretend we did all of that. Now you&#8217;ve got yourself a website. The thing that you will want to do next, or rather the first thing that you&#8217;ll notice once you get your site up and running, is that there&#8217;s this ‘Hello World’ post– there&#8217;s a post that already exists in there. The Hello World post is a placeholder for the common features of a blog post.</p>\n\n\n\n<p>There, you can find your featured image, your title, your content, and even some fake comments. You can either edit this post so that you can see how your writing will look from the start, and you can kind of compare like, okay, the Hello World part over here on this page, exists in this field over here on this page. So you can kind of see where everything works, how it all looks together. Or, if you&#8217;re more familiar with WordPress or CMS in general, you can simply remove that and start fresh.&nbsp;</p>\n\n\n\n<p><strong>Josepha Haden Chomphosy [00:07:17]</strong></p>\n\n\n\n<p>So we&#8217;ve got now a website, we know, kind of, how to look at our posts and create posts, where comments are, where they can kind of be moderated and stuff. And so, the most fun task for everyone is choosing a theme. But if it&#8217;s not a fun task, if it doesn&#8217;t sound like a fun task to you, I can help you kind of do some, choose your own adventure guiding questions here.&nbsp;</p>\n\n\n\n<p>Firstly, you can ask yourself how you want the site to look. Do you want it to mostly be a lot of photos or entirely words, mostly animations? You can head to the theme directory and search for a theme with most of the features that you want. There&#8217;s like a filtering system where you can put in, like, you want three columns so that you can have three columns of text if you want it to look kind of like an old school newspaper kind of layout and things like.</p>\n\n\n\n<p><strong>Josepha Haden Chomphosy [00:08:12]</strong></p>\n\n\n\n<p>There&#8217;s also a way to look for themes inside your instance, your WordPress site, but like, if you haven&#8217;t set that up yet, but you do still want to see kind of what your theme options are, you can go to wordpress.org/themes and and take a look at what&#8217;s out there. Just as a quick side note, if you get to that theme directory, if you get to wordpress.org/themes, and it feels overwhelming, which I can understand, I recommend starting with a theme that is designed for blogging specifically so that you can see how things look right away.</p>\n\n\n\n<p>And there&#8217;s actually a theme that does come with every WordPress site. So if you&#8217;re not ready, you can skip this thing entirely and just work with the theme that&#8217;s already there. Every word, press instance ships with a theme and it is fully functional when you, when you get your site up and running. So you don&#8217;t need to choose a theme right now if you don&#8217;t feel ready.</p>\n\n\n\n<p>And then the other very fun thing that people do with their WordPress sites is to add plugins to them. So plugins are these little pieces of software that you add on to the WordPress software that lets it do additional things. It adds additional functionality. The questions that you can ask to kind of guide yourself through what sorts of plugins you might want, what sorts of functionality you might want to add to your site are a little similar to the ones that you want to ask for figuring out which theme.&nbsp;</p>\n\n\n\n<p><strong>Josepha Haden Chomphosy [00:09:36]</strong></p>\n\n\n\n<p>So figure out if there are tasks that you need visitors to do. Do you need them to contact you? Do you want them to watch a video? Should they review and respond to questions?</p>\n\n\n\n<p>If you have a concept of the things that you want users to do on your website, then you can head to the plugin directory and search for a plugin with features that you need. Also, there are just endless lists of recommended plugins out there; if that is something that you find valuable as part of your research, those are also easy to find.</p>\n\n\n\n<p>And as a general side note here, there are even more plugins than there are themes. So if you have gotten to this point and feel like you don&#8217;t quite know the answers to the questions that I shared, and, and it&#8217;s going to be a while until you feel like you can know what those answers are. That&#8217;s totally fine.</p>\n\n\n\n<p>I&#8217;ll tell you this. I have never seen a site without a contact form. So feel free to begin your journey there. There are a lot of great plugins for contact forms and it can kind of help you figure out how to work with plugins in that way. So yeah, I made it sound like you can get a WordPress website built in like seven minutes and on the one hand you definitely can.</p>\n\n\n\n<p><strong>Josepha Haden Chomphosy [00:09:36]</strong></p>\n\n\n\n<p>And on the other hand, it&#8217;s still a little bit more complicated. So here I have a final note for everyone. You will hear around the WordPress ecosystem. And obviously, here, are some things that could make you feel a little nervous about doing this for the first time. Things like the five-second installation, which WordPress has been famous for years.</p>\n\n\n\n<p>But also about how easy and simple it all is. And as somebody who was once in the position of learning WordPress for the first time, like I first encountered a WordPress site in 2009 and I started learning how to use WordPress in 2010. So I can say with confidence that once you learn it, it&#8217;s easy.</p>\n\n\n\n<p>We are the easiest of the hard options for CMS. Like content management systems are just complicated, but we are the easiest one out there. And so, as you&#8217;re learning, I want to just remind you to celebrate your small wins along the way. If you feel like you&#8217;re late to this blogging game, like you should have had a website for years. I mean, sure that could be true. And yes, the best time to plant a tree was 20 years ago. But the second-best time to plant that tree is today.&nbsp;</p>\n\n\n\n<p>WordPress didn&#8217;t start out powering over 40% of the web, and your first site can&#8217;t be immediately measured in the millions of readers. So, what will your small beginning lead you to?&nbsp;</p>\n\n\n\n<p><strong>Josepha Haden Chomphosy [00:12:25]</strong></p>\n\n\n\n<p>And now that brings us to our small list of big things.&nbsp;</p>\n\n\n\n<p>The first one, the next release of WordPress, WordPress 6.0, has reached its beta phase. That means the full focus is on finding and fixing the bugs we accidentally created during this development cycle. Beta two comes out tomorrow and you can follow along in the core channel in the Making WordPress Slack.</p>\n\n\n\n<p>If you&#8217;ve never seen how those releases get packaged, and if you just want to keep an eye on what everybody&#8217;s doing so that you can be the first to know, yeah, Making WordPress Slack is the way to go.&nbsp;</p>\n\n\n\n<p>The second thing on our small list is that speaking of WordPress 6.0, we had the public walk through a couple of weeks ago, which means that in a few weeks, I&#8217;ll do a WordPress 6.0 sneak peek. I&#8217;ll share some highlights of the release features and why I think they are super important for you to take a look. Sooner rather than later.&nbsp;</p>\n\n\n\n<p><strong>Josepha Haden Chomphosy [00:13:22]</strong></p>\n\n\n\n<p>And then the final, big thing, if you are new to WordPress and this episode has you all fired up to start your blog, we have a bunch of contributors over on the Learn WP team that have just the thing for you.</p>\n\n\n\n<p>You can join the online social learning space called How to Make a WordPress Blog. It&#8217;s a free online event that will help you get started. I&#8217;ll link the information in the show notes below. And I&#8217;ll also share in the show notes, a list of WordPress Meetup groups, where you can find more opportunities to learn and get support from other people locally who are also doing things with WordPress.&nbsp;</p>\n\n\n\n<p>But you can also find a list in the dashboard of your newly installed WordPress blog you no doubt have after this podcast.&nbsp;&nbsp;</p>\n\n\n\n<p>And that my friends is your small list of big things. Thank you for tuning in today for the WordPress Briefing. I&#8217;m your host Josepha Haden Chomphosy, and I&#8217;ll see you again in a couple of weeks.</p>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:30:\"com-wordpress:feed-additions:1\";a:1:{s:7:\"post-id\";a:1:{i:0;a:5:{s:4:\"data\";s:5:\"12658\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:16;a:6:{s:4:\"data\";s:63:\"\n		\n		\n		\n		\n		\n				\n		\n		\n		\n\n					\n										\n					\n		\n		\n			\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:4:{s:0:\"\";a:6:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:20:\"WordPress 6.0 Beta 1\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:56:\"https://wordpress.org/news/2022/04/wordpress-6-0-beta-1/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Tue, 12 Apr 2022 19:08:59 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:3:{i:0;a:5:{s:4:\"data\";s:11:\"Development\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:1;a:5:{s:4:\"data\";s:8:\"Releases\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:2;a:5:{s:4:\"data\";s:3:\"6.0\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:35:\"https://wordpress.org/news/?p=12644\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:63:\"WordPress 6.0 Beta 1 is now available for download and testing.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:11:\"Dan Soschin\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:7809:\"\n<p>WordPress 6.0 Beta 1 is now available for download and testing.</p>\n\n\n\n<p><strong>This version of the WordPress software is under development</strong>. Please do not install, run, and test this version of WordPress on a production or mission-critical website. Instead, it is recommended that you test Beta 1 on a test server and site.&nbsp;</p>\n\n\n\n<p>You can test the WordPress 6.0 Beta 1 in three ways:</p>\n\n\n\n<ul><li>Option 1: Install and activate the <a href=\"https://wordpress.org/plugins/wordpress-beta-tester/\">WordPress Beta Tester</a> plugin (select the “Bleeding edge” channel and “Beta/RC Only” stream).</li><li>Option 2: Direct download the <a href=\"https://wordpress.org/wordpress-6.0-beta1.zip\">beta version here (zip)</a>.</li><li>Option 3: Use WP-CLI to test: <code>wp core update --version=6.0-beta1</code>. <br><strong><em>Do not use this option if your filesystem is case-insensitive.</em></strong></li></ul>\n\n\n\n<p>The current target for the final release is May 24, 2022, which is about six weeks away.&nbsp;</p>\n\n\n\n<p>Additional information on the full <a href=\"https://make.wordpress.org/core/6-0/\">6.0 release cycle is available</a>.</p>\n\n\n\n<p>Check the <a href=\"https://make.wordpress.org/core/\">Make WordPress Core blog</a> for <a href=\"https://make.wordpress.org/core/tag/dev-notes+6-0/\">6.0-related developer notes</a> in the coming weeks which will detail all upcoming changes.</p>\n\n\n\n<h2><strong>Keep WordPress Bug Free – Help with Testing</strong></h2>\n\n\n\n<p>Testing for issues is critical for stabilizing a release throughout its development. Testing is also a great way to contribute. If you have never tested a beta release before, <a href=\"https://make.wordpress.org/test/2022/04/12/help-wanted-test-wordpress-6-0/\">this detailed guide</a> will walk you through how to get started.</p>\n\n\n\n<p>Testing helps make sure that this and future releases of WordPress are as stable and issue-free as possible. And anyone can do it – especially great WordPress community members just like you.</p>\n\n\n\n<p>Want to know more about testing releases like this one? Read about the <a href=\"https://make.wordpress.org/test/\">testing initiatives</a> that happen in Make Core. You can also join a <a href=\"https://wordpress.slack.com/messages/core-test/\">publicly-accessible channel</a> on the <a href=\"https://wordpress.slack.com\">Making WordPress Slack workspace</a>.</p>\n\n\n\n<p>If you think you have run into an issue, please report it to the <a href=\"https://wordpress.org/support/forum/alphabeta/\">Alpha/Beta area</a> in the support forums. If you are comfortable writing a reproducible bug report, you can <a href=\"https://core.trac.wordpress.org/newticket\">file one on WordPress Trac</a>. This is also where you can find a list of <a href=\"https://core.trac.wordpress.org/tickets/major\">known bugs</a>.</p>\n\n\n\n<p>To review features in the Gutenberg releases since WordPress 5.9 (the most recent major release of WordPress), access the <em>What’s New In Gutenberg</em> posts for 13.0 (release pending), <a href=\"https://make.wordpress.org/core/2022/03/30/whats-new-in-gutenberg-12-9-30-march/\">12.9</a>, <a href=\"https://make.wordpress.org/core/2022/03/16/whats-new-in-gutenberg-12-8-16-march/\">12.8</a>, <a href=\"https://make.wordpress.org/core/2022/03/02/whats-new-in-gutenberg-12-7-2-march/\">12.7</a>, <a href=\"https://make.wordpress.org/core/2022/02/16/whats-new-in-gutenberg-12-6-16-february/\">12.6</a>, <a href=\"https://make.wordpress.org/core/2022/02/03/whats-new-in-gutenberg-12-5-february-2nd/\">12.5</a>, <a href=\"https://make.wordpress.org/core/2022/01/19/whats-new-in-gutenberg-12-4-19-january/\">12.4</a>, <a href=\"https://make.wordpress.org/core/2022/01/05/whats-new-in-gutenberg-12-3-5-january/\">12.3</a>, <a href=\"https://make.wordpress.org/core/2021/12/22/whats-new-in-gutenberg-12-2-22-december/\">12.2</a>, <a href=\"https://make.wordpress.org/core/2021/12/08/whats-new-in-gutenberg-12-1-8-december/\">12.1</a>, and <a href=\"https://make.wordpress.org/core/2021/11/29/whats-new-in-gutenberg-12-0-24-november/\">12.0</a>.&nbsp;&nbsp;</p>\n\n\n\n<p>Beyond the noted changes, which include more than 400 updates and 500 bug fixes for the editor, contributors have fixed <a href=\"https://core.trac.wordpress.org/query?status=closed&amp;milestone=6.0&amp;group=component&amp;max=500&amp;col=id&amp;col=summary&amp;col=owner&amp;col=type&amp;col=priority&amp;col=component&amp;col=version&amp;order=priority\">189 tickets for the WordPress 6.0</a> core, including <a href=\"https://core.trac.wordpress.org/query?status=closed&amp;status=reopened&amp;type=enhancement&amp;type=feature+request&amp;milestone=6.0&amp;col=id&amp;col=summary&amp;col=type&amp;col=status&amp;col=milestone&amp;col=owner&amp;col=priority&amp;col=changetime&amp;col=keywords&amp;order=changetime\">91 new features and enhancements</a>. More fixes are on the way.</p>\n\n\n\n<h2><strong>Some Highlights</strong></h2>\n\n\n\n<p><em>Want to know what’s new in version 6.0? Read on for some highlights.</em></p>\n\n\n\n<p>The WordPress 6.0 release will be packed with all kinds of improvements. Here are just a few:</p>\n\n\n\n<ul><li><strong>Style Switching:</strong> <a href=\"https://make.wordpress.org/core/2022/03/03/core-editor-improvement-choose-your-style/\">switch up the look and feel of your site</a>, all in one block theme. No need to change themes!</li><li><strong>More template options:</strong> use blocks to edit five more templates (author, date, categories, tag, and taxonomy).</li><li><strong>Multi-select: </strong>Easily select text across multiple blocks. Edit to your liking.</li><li><strong>Retain Styles: </strong>Keep your custom styles in place, whether transforming between blocks or creating new buttons.&nbsp;</li><li><strong>More patterns in more places:</strong> the Quick Inserter surfaces patterns that might work well for the condition you’re in, baking in relevant patterns for template parts and pages you’re working on.&nbsp;</li><li><strong>List View improvements: </strong>New keyboard shortcuts (shift + click) let you select multiple blocks to modify in bulk (reposition, delete, etc.), see your content at a glance with a collapsed by default view, and more.</li><li><strong>Refined design tools: </strong>Explore<strong> </strong>a new color panel, transparency options, more group block variations to create new layout options (Stack, Row), the ability to set your featured image in a Cover block, control the exact size of your featured image, gap support for the Gallery block, and more.</li><li><strong>New blocks: </strong>Comments, Read More, No results in Query Loop, Post Author biography, Avatar blocks.&nbsp;</li><li><strong>Block Locking UI: </strong>Choose to disable the option to remove a block, move it, or both, right in the editor.&nbsp;</li><li><strong>Export block themes: </strong>Explore the improved block theme export tool, as WordPress heads closer to codeless visual block theme building.</li><li><strong>Webfonts API: </strong>Manage local fonts with PHP or theme.json.&nbsp;</li></ul>\n\n\n\n<hr class=\"wp-block-separator has-alpha-channel-opacity\" />\n\n\n\n<p>Thank you to the following contributors for collaborating on this post: <a href=\'https://profiles.wordpress.org/annezazu/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>annezazu</a>, <a href=\'https://profiles.wordpress.org/chanthaboune/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>chanthaboune</a>, <a href=\'https://profiles.wordpress.org/marybaum/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>marybaum</a>, <a href=\'https://profiles.wordpress.org/priethor/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>priethor</a>, and <a href=\'https://profiles.wordpress.org/webcommsat/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>webcommsat</a>.</p>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:30:\"com-wordpress:feed-additions:1\";a:1:{s:7:\"post-id\";a:1:{i:0;a:5:{s:4:\"data\";s:5:\"12644\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:17;a:6:{s:4:\"data\";s:60:\"\n		\n		\n		\n		\n		\n				\n		\n		\n\n					\n										\n					\n		\n		\n			\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:4:{s:0:\"\";a:6:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:35:\"WordPress 5.9.3 Maintenance Release\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:71:\"https://wordpress.org/news/2022/04/wordpress-5-9-3-maintenance-release/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Tue, 05 Apr 2022 19:50:17 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:2:{i:0;a:5:{s:4:\"data\";s:8:\"Releases\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:1;a:5:{s:4:\"data\";s:3:\"5.9\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:35:\"https://wordpress.org/news/?p=12575\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:125:\"WordPress 5.9.3 is now available! This maintenance release features 9 bug fixes in Core and 9 bug fixes in the block editor.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:9:\"Jb Audras\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:3896:\"\n<p>WordPress 5.9.3 is now available!</p>\n\n\n\n<p>This maintenance release features&nbsp;9 bug fixes in Core and 10 bug fixes in the block editor.</p>\n\n\n\n<p>WordPress 5.9.3 is a short-cycle maintenance release. The next major release will be version&nbsp;<a href=\"https://make.wordpress.org/core/6.0/\">6.0</a>.</p>\n\n\n\n<p>You can&nbsp;<a href=\"https://wordpress.org/wordpress-5.9.3.zip\">download WordPress 5.9.3 from WordPress.org</a>, or visit your Dashboard&nbsp;→ Updates and click “Update Now”.</p>\n\n\n\n<p>If you have sites that support automatic background updates, they’ve already started the update process.</p>\n\n\n\n<p>For more information, browse the&nbsp;<a href=\"https://make.wordpress.org/core/2022/03/30/wordpress-5-9-3-rc-1/\">full list of both Trac and GitHub changes in the release candidate post</a>, or check out the&nbsp;<a href=\"https://wordpress.org/support/wordpress-version/version-5-9-3/\">changelog of version 5.9.3 on HelpHub</a>.</p>\n\n\n\n<h2 id=\"thanks-and-props\">Thanks and props!</h2>\n\n\n\n<p>The 5.9.3 release was led by&nbsp;<a href=\"https://profiles.wordpress.org/audrasjb/\">Jb Audras</a>&nbsp;and&nbsp;<a href=\"https://profiles.wordpress.org/mamaduka/\">George Mamadashvili</a>.</p>\n\n\n\n<p>Special props to&nbsp;<a href=\"https://profiles.wordpress.org/sergeybiryukov/\">Sergey Biryukov</a>&nbsp;for running mission control.</p>\n\n\n\n<p>Thank you to everyone who helped make WordPress 5.9.3 happen:</p>\n\n\n\n<p class=\"alignfull is-style-wporg-props-medium\"><a href=\"https://profiles.wordpress.org/wildworks/\">Aki Hamano</a>, <a href=\"https://profiles.wordpress.org/alexstine/\">Alex Stine</a>, <a href=\"https://profiles.wordpress.org/aliakseyenkaihar/\">aliakseyenkaihar</a>, <a href=\"https://profiles.wordpress.org/antonvlasenko/\">Anton Vlasenko</a>, <a href=\"https://profiles.wordpress.org/binarymoon/\">binarymoon</a>, <a href=\"https://profiles.wordpress.org/cbravobernal/\">Carlos Bravo</a>, <a href=\"https://profiles.wordpress.org/costdev/\">Colin Stewart</a>, <a href=\"https://profiles.wordpress.org/davidbaumwald/\">David Baumwald</a>, <a href=\"https://profiles.wordpress.org/dd32/\">Dion Hulse</a>, <a href=\"https://profiles.wordpress.org/mamaduka/\">George Mamadashvili</a>, <a href=\"https://profiles.wordpress.org/glendaviesnz/\">glendaviesnz</a>, <a href=\"https://profiles.wordpress.org/gziolo/\">Greg Ziółkowski</a>, <a href=\"https://profiles.wordpress.org/ironprogrammer/\">ironprogrammer</a>, <a href=\"https://profiles.wordpress.org/iulia-cazan/\">Iulia Cazan</a>, <a href=\"https://profiles.wordpress.org/audrasjb/\">Jb Audras</a>, <a href=\"https://profiles.wordpress.org/joedolson/\">Joe Dolson</a>, <a href=\"https://profiles.wordpress.org/joen/\">Joen A.</a>, <a href=\"https://profiles.wordpress.org/jorgefilipecosta/\">Jorge Costa</a>, <a href=\"https://profiles.wordpress.org/jsnajdr/\">jsnajdr</a>, <a href=\"https://profiles.wordpress.org/clorith/\">Marius L. J.</a>, <a href=\"https://profiles.wordpress.org/ndiego/\">Nick Diego</a>, <a href=\"https://profiles.wordpress.org/pbiron/\">Paul Biron</a>, <a href=\"https://profiles.wordpress.org/psmits1567/\">Peter Smits</a>, <a href=\"https://profiles.wordpress.org/pgpagely/\">pgpagely</a>, <a href=\"https://profiles.wordpress.org/rafiahmedd/\">Rafi Ahmed</a>, <a href=\"https://profiles.wordpress.org/richybkreckel/\">Richard B. Kreckel</a>, <a href=\"https://profiles.wordpress.org/noisysocks/\">Robert Anderson</a>, <a href=\"https://profiles.wordpress.org/rufus87/\">Rufus87</a>, <a href=\"https://profiles.wordpress.org/sergeybiryukov/\">Sergey Biryukov</a>, <a href=\"https://profiles.wordpress.org/tobifjellner/\">Tor-Bjorn Fjellner</a>, <a href=\"https://profiles.wordpress.org/hellofromtonya/\">Tonya Mork</a>, <a href=\"https://profiles.wordpress.org/webcommsat/\">Abha Thakor</a>, <a href=\"https://profiles.wordpress.org/webmandesign/\">Oliver Juhas</a>, and <a href=\"https://profiles.wordpress.org/westonruter/\">Weston Ruter</a>.</p>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:30:\"com-wordpress:feed-additions:1\";a:1:{s:7:\"post-id\";a:1:{i:0;a:5:{s:4:\"data\";s:5:\"12575\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:18;a:6:{s:4:\"data\";s:60:\"\n		\n		\n		\n		\n		\n				\n		\n		\n\n					\n										\n					\n		\n		\n			\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:4:{s:0:\"\";a:6:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:37:\"The Month in WordPress – March 2022\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:69:\"https://wordpress.org/news/2022/04/the-month-in-wordpress-march-2022/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Tue, 05 Apr 2022 13:00:00 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:2:{i:0;a:5:{s:4:\"data\";s:18:\"Month in WordPress\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:1;a:5:{s:4:\"data\";s:22:\"the month in wordpress\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:35:\"https://wordpress.org/news/?p=12583\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:325:\"We hope that you and your beloved ones are staying safe during these difficult times. If you’re looking for a way to support the humanitarian crisis in Ukraine, you can refer to this episode of WP Briefing. There you will find a list of Non-Governmental Organizations (NGOs) that can help. In parallel to the work [&#8230;]\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:14:\"rmartinezduque\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:13319:\"\n<p>We hope that you and your beloved ones are staying safe during these difficult times. If you’re looking for a way to support the humanitarian crisis in Ukraine, you can refer to <a href=\"https://wordpress.org/news/2022/03/episode-26-matt-mullenweg-on-ukraine-community-and-wordpress/\">this episode of WP Briefing</a>. There you will find a list of Non-Governmental Organizations (NGOs) that can help.</p>\n\n\n\n<p>In parallel to the work the community is doing in preparation for the next major release, WordPress 6.0, March has seen the launch of some exciting projects and proposals. Read on to find out more about the latest updates and how to get involved. </p>\n\n\n\n<hr class=\"wp-block-separator has-css-opacity\" />\n\n\n\n<h2>The Pattern Directory is open for public submissions</h2>\n\n\n\n<figure class=\"wp-block-image size-large\"><a href=\"https://i2.wp.com/wordpress.org/news/files/2022/04/home-patterns.png?ssl=1\"><img decoding=\"async\" loading=\"lazy\" width=\"1024\" height=\"659\" src=\"https://i2.wp.com/wordpress.org/news/files/2022/04/home-patterns.png?resize=1024%2C659&#038;ssl=1\" alt=\"View of the Pattern Directory page at WordPress.org.\" class=\"wp-image-12584\" srcset=\"https://i2.wp.com/wordpress.org/news/files/2022/04/home-patterns.png?resize=1024%2C659&amp;ssl=1 1024w, https://i2.wp.com/wordpress.org/news/files/2022/04/home-patterns.png?resize=300%2C193&amp;ssl=1 300w, https://i2.wp.com/wordpress.org/news/files/2022/04/home-patterns.png?resize=768%2C494&amp;ssl=1 768w, https://i2.wp.com/wordpress.org/news/files/2022/04/home-patterns.png?resize=1536%2C988&amp;ssl=1 1536w, https://i2.wp.com/wordpress.org/news/files/2022/04/home-patterns.png?resize=2048%2C1318&amp;ssl=1 2048w\" sizes=\"(max-width: 1000px) 100vw, 1000px\" data-recalc-dims=\"1\" /></a></figure>\n\n\n\n<p>The <a href=\"https://wordpress.org/patterns/new-pattern/\">WordPress Pattern Creator</a> is live! This new tool allows anyone with a WordPress.org user account to build, edit and submit their best block patterns to the <a href=\"https://wordpress.org/patterns/\">Pattern Directory</a>.<br><br>If you&#8217;ve used patterns in WordPress, you&#8217;ll know that they make it easy to add unique layouts to your website. These include galleries, testimonials, pricing tables, and more. Opening the directory to public submissions enables any WordPress user to enjoy a wider variety of patterns to use on their sites.</p>\n\n\n\n<div class=\"wp-container-13 wp-block-buttons\">\n<div class=\"wp-block-button aligncenter\"><a class=\"wp-block-button__link\" href=\"https://wordpress.org/news/2022/03/get-creative-with-the-all-new-pattern-creator/\" target=\"_blank\" rel=\"noreferrer noopener\"><strong>Check out the Pattern Creator announcement to learn more</strong></a></div>\n</div>\n\n\n\n<h2>WordPress 6.0 Walkthrough scheduled for April 5, 2022</h2>\n\n\n\n<p>A few updates to the <a href=\"https://make.wordpress.org/core/2022/03/11/wordpress-6-0-planning-update/\">WordPress 6.0 planning</a> were published last month. In case you missed them, <strong>today (April 5) at 15:00 UTC</strong> there is a live and interactive <a href=\"https://make.wordpress.org/core/2022/03/30/6-0-product-walk-through/\">WordPress 6.0 walkthrough</a> hosted by contributors of the release squad.</p>\n\n\n\n<p>The event will take place via Zoom and include a discussion on the new features, potential blockers, and a Q&amp;A session with the community. Attendance is open to anyone who wants to know more about what’s coming in WordPress 6.0.</p>\n\n\n\n<div class=\"wp-container-14 wp-block-buttons\">\n<div class=\"wp-block-button aligncenter\"><a class=\"wp-block-button__link\" href=\"https://make.wordpress.org/core/2022/03/30/6-0-product-walk-through/\" target=\"_blank\" rel=\"noreferrer noopener\"><strong>Join the WordPress 6.0 product walkthrough</strong></a></div>\n</div>\n\n\n\n<h2>Gutenberg releases: Versions 12.8 and 12.9 are here</h2>\n\n\n\n<p>Versions 12.8 and 12.9 of the Gutenberg plugin were released last month. With them, some new exciting features and updates.</p>\n\n\n\n<ul><li><a href=\"https://make.wordpress.org/core/2022/03/16/whats-new-in-gutenberg-12-8-16-march/\">Gutenberg 12.8</a> includes a new Webfonts API, iterative UX enhancements, and bug fixes to increase the editor’s stability.</li><li><a href=\"https://make.wordpress.org/core/2022/03/30/whats-new-in-gutenberg-12-9-30-march/\">Gutenberg 12.9</a> introduces the new block locking UI and support for spacing between Gallery images. Also, many other improvements to give you more control over what is editable and presented to users.</li></ul>\n\n\n\n<div class=\"is-content-justification-center wp-container-15 wp-block-buttons\">\n<div class=\"wp-block-button aligncenter\"><a class=\"wp-block-button__link\" href=\"https://make.wordpress.org/core/tag/gutenberg-new/\" target=\"_blank\" rel=\"noreferrer noopener\"><strong>Follow #gutenberg-new to stay updated on the latest Gutenberg releases</strong></a></div>\n</div>\n\n\n\n<div class=\"wp-container-16 wp-block-buttons\"></div>\n\n\n\n<h2>Team updates: Team Reps for the Photo Directory team, community proposals, and more</h2>\n\n\n\n<ul><li><a href=\"https://wordpress.org/news/2022/03/wordpress-5-9-2-security-maintenance-release/\">WordPress 5.9.2</a> is available for download. This security and maintenance release features one bug fix and three security fixes.</li><li>The Team Representatives for the Make Photo Directory team for 2022 <a href=\"https://make.wordpress.org/photos/2022/03/23/announcement-photo-directory-team-reps-2022/\">have been announced</a>. Congrats to Marcus Burnette (<a href=\'https://profiles.wordpress.org/mdburnette/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>mdburnette</a>), Katie Richards (<a href=\'https://profiles.wordpress.org/katiejrichards/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>katiejrichards</a>), and Topher DeRosia (<a href=\'https://profiles.wordpress.org/topher1kenobe/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>topher1kenobe</a>)!</li><li>The Community team considered <a href=\"https://make.wordpress.org/community/2022/03/17/discussion-revisiting-in-person-regional-wordcamps/\">revisiting the existing guidelines</a> for in-person regional WordCamps. Conclusions and next steps will be shared soon.</li><li>On a similar note, Cate DeRosia (<a href=\'https://profiles.wordpress.org/mysweetcate/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>mysweetcate</a>) is <a href=\"https://make.wordpress.org/community/2022/03/23/return-to-events-blue-sky-thinking/\">looking for ideas</a> on how to support organizers who are trying to restart in-person events in their communities. Share yours by April 13, 2022.</li><li>The Training team published new lesson plans, workshops, and social learning spaces on Learn WordPress. <a href=\"https://make.wordpress.org/updates/2022/04/01/whats-new-on-learnwp-in-march-2022/\">Check out what’s new in March 2022.</a></li><li>How has WordPress helped grow your story? The Make Marketing team <a href=\"https://make.wordpress.org/marketing/2022/04/01/grow-your-story-on-wordpress/\">wants to hear about your experience</a>!</li><li>The <a href=\"https://make.wordpress.org/core/2022/03/07/the-performance-lab-plugin-has-been-released/\">Performance Lab plugin</a>, a set of modules that aim to improve performance in WordPress, was released last month.</li><li>Openverse released <a href=\"https://make.wordpress.org/openverse/2022/03/10/openverse-frontend-v3-1-1-release/\">new updates</a> in March. They include a redesigned content reporting flow and new image detail pages.</li><li>WordPress Executive Director Josepha Haden Chomphosy posted a <a href=\"https://make.wordpress.org/project/2022/03/23/removal-of-the-zamir-plugin/\">public statement</a> on the removal of the Zamir plugin a few weeks ago.</li><li>The March 2022 editions of the <a href=\"https://make.wordpress.org/community/2022/03/14/meetup-organizer-newsletter-march-2022/\">Meetup Organizer Newsletter</a> and the <a href=\"https://make.wordpress.org/polyglots/2022/03/22/polyglots-monthly-newsletter-march-2022/\">Polyglots Monthly Newsletter</a> were published.</li><li>The latest edition of People of WordPress features the contributor story of the Argentinian web developer and product manager <a href=\"https://wordpress.org/news/2022/03/people-of-wordpress-juanfra-aldasoro/\">Juanfra Aldasoro</a>.</li><li>WordPress community members launched the <a href=\"https://block-museum.com/\">Museum of Block Art (MOBA)</a>. This initiative seeks to inspire creativity and push the limits around what can be done with WordPress. All the art curated in this virtual museum is built using the block editor.</li></ul>\n\n\n\n<div class=\"is-content-justification-center wp-container-17 wp-block-buttons\">\n<div class=\"wp-block-button aligncenter\"><a class=\"wp-block-button__link\" href=\"https://make.wordpress.org/community/2022/03/30/proposal-steps-to-integrate-wpdiversity-into-wordpress-event-organizing/\" target=\"_blank\" rel=\"noreferrer noopener\"><strong>Help us build a thriving and inclusive community. Share your thoughts on this </strong><strong>proposal</strong><strong> to introduce WordCamp and Meetup organizers to #WPDiversity programs by April 8, 2022.</strong></a></div>\n</div>\n\n\n\n<h2>Testing requests: WebP feature, template for author pages</h2>\n\n\n\n<ul><li>The Performance Team published a <a href=\"https://make.wordpress.org/core/2022/03/28/enabling-webp-by-default/\">proposal</a> to integrate the WebP image format by default into WordPress core. Your feedback on this feature is appreciated.</li><li><a href=\"https://make.wordpress.org/mobile/2022/04/04/call-for-testing-wordpress-for-ios-19-6/\">Version 19.6</a> of WordPress for iOS is available for testing.</li></ul>\n\n\n\n<div class=\"is-content-justification-center wp-container-18 wp-block-buttons\">\n<div class=\"wp-block-button aligncenter\"><a class=\"wp-block-button__link\" href=\"https://make.wordpress.org/test/2022/03/31/fse-program-testing-call-13-authoring-an-author-template/\" target=\"_blank\" rel=\"noreferrer noopener\"><strong> There&#8217;s a new call for testing as part of the Full Site Editing Outreach Program: Authoring an Author Template. The deadline to participate is April 21, 2022.</strong></a></div>\n</div>\n\n\n\n<h2>The first flagship WordCamp Asia is looking for organizers</h2>\n\n\n\n<ul><li>WordCamp Asia is tentatively scheduled for February 2023. After two years since the organizing team announced that the first flagship WordCamp Asia was canceled due to the pandemic, they are back together and <a href=\"https://asia.wordcamp.org/2023/call-for-organisers/\">looking for more members</a> to join them in planning the event.</li><li>The <a href=\"https://us.wordcamp.org/2022/apply-to-speak-at-wcus/\">Call for Speakers</a> for WordCamp US 2022 is now open. You can submit your application by April 17, 2022.</li><li>Three in-person WordCamps are happening this month:<ul><li><img src=\"https://s.w.org/images/core/emoji/14.0.0/72x72/1f1e8-1f1ed.png\" alt=\"🇨🇭\" class=\"wp-smiley\" style=\"height: 1em; max-height: 1em;\" /> <a href=\"https://geneve.wordcamp.org/2022/\">WordCamp Genève</a>, Switzerland on April 9, 2022</li><li><img src=\"https://s.w.org/images/core/emoji/14.0.0/72x72/1f1ec-1f1f7.png\" alt=\"🇬🇷\" class=\"wp-smiley\" style=\"height: 1em; max-height: 1em;\" /> <a href=\"https://athens.wordcamp.org/2022/\">WordCamp Athens</a>, Greece on April 9-10, 2022</li><li><img src=\"https://s.w.org/images/core/emoji/14.0.0/72x72/1f1e6-1f1f9.png\" alt=\"🇦🇹\" class=\"wp-smiley\" style=\"height: 1em; max-height: 1em;\" /> <a href=\"https://vienna.wordcamp.org/2022/\">WordCamp Vienna</a>, Austria on April 23-24, 2022</li></ul></li><li>Check out the latest episodes of WordPress Briefing with Josepha Haden:<ul><li><a href=\"https://wordpress.org/news/2022/04/episode-28-coming-to-a-wordcamp-near-you-a-return-to-in-person-wp-events/\">Coming to a WordCamp Near You: A Return to In-Person WP Events</a></li><li><a href=\"https://wordpress.org/news/2022/03/episode-27-is-wordpress-made-for-me/\">Is WordPress Made for Me?</a></li></ul></li></ul>\n\n\n\n<div class=\"is-content-justification-center wp-container-19 wp-block-buttons\">\n<div class=\"wp-block-button aligncenter\"><a class=\"wp-block-button__link\" href=\"https://europe.wordcamp.org/2022/call-for-volunteers/\" target=\"_blank\" rel=\"noreferrer noopener\"><strong><strong>The </strong><strong>Call for Volunteers</strong><strong> for WordCamp Europe 2022 is still open. If you want to get involved with the WordPress community and have a lot of fun, this is your chance!</strong></strong></a></div>\n</div>\n\n\n\n<hr class=\"wp-block-separator has-css-opacity\" />\n\n\n\n<p><strong><em>Have a story that we could include in the next ‘Month in WordPress’ post? Let us know by filling out </em></strong><a href=\"https://make.wordpress.org/community/month-in-wordpress-submissions/\"><strong><em>this form</em></strong></a><strong><em>.</em></strong></p>\n\n\n\n<p><em>The following folks contributed to this Month in WordPress: </em><a href=\'https://profiles.wordpress.org/rmartinezduque/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>rmartinezduque</a>, <a href=\'https://profiles.wordpress.org/mysweetcate/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>mysweetcate</a>, <a href=\'https://profiles.wordpress.org/anjanavasan/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>anjanavasan</a>.</p>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:30:\"com-wordpress:feed-additions:1\";a:1:{s:7:\"post-id\";a:1:{i:0;a:5:{s:4:\"data\";s:5:\"12583\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:19;a:6:{s:4:\"data\";s:61:\"\n		\n		\n		\n		\n		\n				\n		\n		\n\n					\n										\n					\n		\n		\n\n			\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:4:{s:0:\"\";a:7:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:87:\"WP Briefing: Episode 28: Coming to a WordCamp Near You: A Return to In-Person WP Events\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:108:\"https://wordpress.org/news/2022/04/episode-28-coming-to-a-wordcamp-near-you-a-return-to-in-person-wp-events/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Mon, 04 Apr 2022 12:00:00 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:2:{i:0;a:5:{s:4:\"data\";s:7:\"Podcast\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:1;a:5:{s:4:\"data\";s:11:\"wp-briefing\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:53:\"https://wordpress.org/news/?post_type=podcast&p=12506\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:172:\"Curious about returning to WordPress events safely? Tune in as WordPress Executive Director Josepha Haden Chomphosy discusses guidelines for returning to in-person events. \";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:9:\"enclosure\";a:1:{i:0;a:5:{s:4:\"data\";s:0:\"\";s:7:\"attribs\";a:1:{s:0:\"\";a:3:{s:3:\"url\";s:60:\"https://wordpress.org/news/files/2022/03/WP-Briefing-028.mp3\";s:6:\"length\";s:1:\"0\";s:4:\"type\";s:0:\"\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:14:\"Santana Inniss\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:11997:\"\n<p>In the twenty-eighth episode of the WordPress Briefing, Executive Director, Josepha Haden Chomphosy discusses returning to in-person WordPress events.</p>\n\n\n\n<p><em><strong>Have a question you&#8217;d like answered? You can submit them to <a href=\"mailto:wpbriefing@wordpress.org\">wpbriefing@wordpress.org</a>, either written or as a voice recording.</strong></em></p>\n\n\n\n<h2 id=\"credits\">Credits</h2>\n\n\n\n<ul><li>Editor:&nbsp;<a href=\"https://profiles.wordpress.org/dustinhartzler/\">Dustin Hartzler</a></li><li>Logo:&nbsp;<a href=\"https://profiles.wordpress.org/beafialho/\">Beatriz Fialho</a></li><li>Production:&nbsp;<a href=\"https://profiles.wordpress.org/cbringmann/\">Chloé Bringmann</a> &amp; <a href=\"https://profiles.wordpress.org/santanainniss/\">Santana Inniss</a> </li><li>Song: Fearless First by Kevin MacLeod</li><li>Special thanks to: <a href=\"https://profiles.wordpress.org/angelasjin/\" data-type=\"URL\" data-id=\"https://profiles.wordpress.org/angelasjin/\">Angela Jin</a></li></ul>\n\n\n\n<h2>References</h2>\n\n\n\n<ul><li><a href=\"https://wordcampcentral.survey.fm/2022-host-in-person-wordpress-event-checklist\">Event Safety Checklist</a></li><li><a href=\"https://asia.wordcamp.org/2023/call-for-organisers/\">WordCamp Asia Call for Organizers</a></li><li><a href=\"https://make.wordpress.org/community/2022/03/23/return-to-events-blue-sky-thinking/\">Open Discussion: Returning to In-Person Events</a></li><li><a href=\"https://make.wordpress.org/community/2022/03/17/discussion-revisiting-in-person-regional-wordcamps/\">Open Discussion: Returning to Regional Events</a></li></ul>\n\n\n\n<h2>Transcript</h2>\n\n\n\n<span id=\"more-12506\"></span>\n\n\n\n<p><strong>Josepha Haden Chomphosy [00:00:00] </strong>&nbsp;</p>\n\n\n\n<p>Hello everyone! And welcome to the WordPress Briefing: the podcast where you can catch quick explanations of the ideas behind the WordPress open source project, some insight into the community that supports it and get a small list of big things coming up in the next two weeks. I&#8217;m your host, Josepha Haden Chomphosy. Here we go.</p>\n\n\n\n<p><strong>Josepha Haden Chomphosy [00:00:40]&nbsp;</strong></p>\n\n\n\n<p>I was checking the list of upcoming events recently as part of just my regular work and saw that the call for organizers for WordCamp Asia is open. On the one hand, it made my heart skip a beat with excitement. That event is six years or so in the making. And on the other hand, it reminded me of February 10th, 2020, the day that Matt told me that we had to proactively cancel WordCamp Asia. That week was truly heartbreaking for me as well as I think the entire organizing team.</p>\n\n\n\n<p>But it also, fortunately, was prescient. As I think back over the two years since then, I&#8217;m grateful for our community wranglers and deputies who have consistently hosted important discussions about how to return to in-person events safely. And with two of our major flagship events returning this year, I&#8217;m here to summarize, sort of, what the rules and guidelines are.</p>\n\n\n\n<p>But certainly I hope that you come away from this with an idea of what&#8217;s being done to keep everyone safe as we are best able.</p>\n\n\n\n<p><strong>Josepha Haden Chomphosy [00:01:44]&nbsp;</strong></p>\n\n\n\n<p>Firstly, before we dig into specifics, I want to be clear upfront that the guidelines for COVID-aware events are mandatory, unless otherwise stated. For folks who&#8217;ve been attending WordPress events, or participating in the community for a long time, this is a change. As a program, we have always done our best to be flexible with guidelines so that we can prioritize local knowledge. But our responsibility is to the long-term success of this community and this program. So moving forward with in-person events that risk the health of our community members poses risks to the program itself. So with that in mind, let&#8217;s learn what we&#8217;re going to see at events for the rest of the.&nbsp;</p>\n\n\n\n<p><strong>Josepha Haden Chomphosy [00:02:28]&nbsp;</strong></p>\n\n\n\n<p>For any WordPress event that is gathering more than 50 people, the new mandatory guidelines are:</p>\n\n\n\n<p>Number one, follow local laws and guidelines. If your area has suggested guidelines on top of the mandatory ones, follow those.</p>\n\n\n\n<p>Second, is if you are in a location where laws or guidelines require or permit venues to limit admission based on a person&#8217;s vaccination status and masking, then events can only happen in venues that are willing to provide staff to check for vaccination status at the door. And then also to remind participants to wear masks during the event.</p>\n\n\n\n<p>And the third thing is if your area or venue legally cannot check vaccination status, your area must pass the in-person checklist, which I will link in the show notes below. But that in-person checklist has to be passed at the time of the application and then again at the time of the event. And in addition to that, the venue must be willing to provide staff who will remind participants to wear masks and check for temperature during the event.</p>\n\n\n\n<p><strong>Josepha Haden Chomphosy [00:03:33]&nbsp;</strong></p>\n\n\n\n<p>Organizers in these areas must be prepared to move online or cancel if the region fails the safety checklist, which again, will be linked in the show notes below. So those are the three things and they are pretty dense, but also I think allow for a fair amount of flexibility. There is also a tidy flow chart linked in the sidebar of make.wordpress.org/community that will help you to decide what sort of event your own area can support right now.&nbsp;</p>\n\n\n\n<p>So those are the mandatory guidelines for WordPress events in general right now, but you probably also have a few specific questions. So I&#8217;ve got the three most common questions ready to go with answers from Angela Jin who helped me to kind of pull together the information for this particular podcast props to Angela. Thank you.&nbsp;</p>\n\n\n\n<p><strong>Josepha Haden Chomphosy [00:04:25]&nbsp;</strong></p>\n\n\n\n<p>So, first question, anything specific to know about WordCamp Europe? WordCamp Europe will be following these guidelines as well. All attendees and participants are expected to wear a mask while they are at the event and catering will be offered outside so people can remove their masks to eat.&nbsp;</p>\n\n\n\n<p>The second common question is how will these guidelines change as countries and local governments begin deescalating restrictions and safety measures? We should consider these guidelines to be subject to evolution based on what the team is hearing and seeing from the community. But right now we intend to keep these stricter guidelines in place until we see how the loosened rules play out elsewhere.&nbsp;</p>\n\n\n\n<p>And then a third frequent question is what&#8217;s going to happen to all these online events?</p>\n\n\n\n<p>The community team will continue to support online events right now. So if your community doesn&#8217;t feel ready to have an in-person event, but still wants to kind of get everyone together that is still allowed, and still&nbsp; encouraged. And finally the community team will continue to keep a close eye on situations around the world.</p>\n\n\n\n<p>If it becomes safe to do so, and your community is interested, they of course will be happy to chat with you about a WordCamp. There is an application that I will share the link to in the show notes below as well. In case that is something that your community is wanting to look into.&nbsp;</p>\n\n\n\n<p><strong>Josepha Haden Chomphosy [00:05:54]</strong></p>\n\n\n\n<p>Oh, and I have a little postscript also. I know I was like finally, and now I&#8217;m doing a finally, finally. That&#8217;s what postscripts are about. P.S. If you have not stopped by the community team’s site or any of their meetings, they&#8217;ve been doing a really great job of keeping things moving through two years of unpredictable changes. If you are a community team member, I want to offer you a huge thanks. Thank you so much for helping us to stay aware and able to move forward.&nbsp;</p>\n\n\n\n<p>If you are an organizer, pat yourself on the back. I want to thank you for pivoting with us, moving through online events, even though they are not at all the same as in-person events and certainly they don&#8217;t share the reasons that we get people together sometimes.</p>\n\n\n\n<p>And finally, if you are an end to end attendee, if you go to WordPress meetups or you go to any sort of WordPress online events or WordCamps, anything like that, thank your local organizer. They have been doing this probably for a while, and I&#8217;m sure that they are looking forward to getting back to in-person events themselves, but even, so they have been putting in a lot of volunteer hours to help make sure that we all know how to use WordPress.</p>\n\n\n\n<p>And so find them, thank them, and I&#8217;m sure that they&#8217;ll appreciate it.</p>\n\n\n\n<p><strong>Josepha Haden Chomphosy [00:07:20]</strong></p>\n\n\n\n<p>And with that, it is time for our small list of big things. Number one, WordCamp Asia has a call for organizers open! This event will be in 2023. And I think that we all simply cannot wait. So I&#8217;ll link the call for organizers in the show notes. And then of course you can follow that whole site to stay up to date on what&#8217;s happening there.</p>\n\n\n\n<p>The second thing is, while we&#8217;re on the topic of events, there&#8217;s also an open discussion about how we can best support organizers who are getting back to in-person events. We&#8217;d like thoughts from both organizers and attendees. So feel free to drop by and leave a note in the comments section. And while you&#8217;re over there, the third thing in my small list of big things, there&#8217;s also an open discussion about regional events. So go over there, get all your thoughts about WordPress events together. Get them all sorted out in one go. Just leave comments, boom, boom, boom, boom, boom. All over the place.&nbsp;</p>\n\n\n\n<p>And that my friends is your small list of big things. Thank you for tuning in today for the WordPress Briefing. I&#8217;m your host Josepha Haden Chomphosy.</p>\n\n\n\n<p>And I&#8217;ll see you again in a couple of weeks.</p>\n\n\n\n<p><strong>Josepha Haden Chomphosy [00:08:54]</strong></p>\n\n\n\n<p>So my most embarrassing WordCamp story actually has to do with where I was supposed to be versus where people thought I was supposed to be. This was early on in my time with WordPress, with Automattic. And I had convinced someone, I had convinced a colleague and friend of mine to go to my home WordCamp, WordCamp Fayetteville over there in Arkansas.</p>\n\n\n\n<p>And then I didn&#8217;t go. But I knew I wasn&#8217;t going, I knew I was going to WordCamp Boston, but he did not know that I was not going to go. And so he arrived at WordCamp Fayetteville, WordCamp Northwest Arkansas. I can&#8217;t remember what it was called at the time. And immediately was confused about where I was and why I wasn&#8217;t there.</p>\n\n\n\n<p>And so there was this excellent moment of mass confusion among states where the folks at WordCamp Fayetteville started tweeting about how I had convinced this contributor to go to that event and then didn&#8217;t show up. And then the folks at WordCamp Boston, we&#8217;re looking at all of those tweets, because if you are a WordCamp organizer, you are always looking at the tweets from all the other WordCamps happening in your weekend.</p>\n\n\n\n<p>And people got very confused about why I was in Boston while they were thinking that I was in Fayetteville, even though the tweets were talking about how, like, I wasn&#8217;t in Fayetteville. They probably didn&#8217;t say that it was probably more along the lines of like, “Hey, let&#8217;s share a photo with Josepha” to, like, make fun of the fact that I wasn&#8217;t there.</p>\n\n\n\n<p>And so I caused mass confusion in multiple states. That&#8217;s probably my most embarrassing WordCamp story. You&#8217;re welcome. Bye!</p>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:30:\"com-wordpress:feed-additions:1\";a:1:{s:7:\"post-id\";a:1:{i:0;a:5:{s:4:\"data\";s:5:\"12506\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:20;a:6:{s:4:\"data\";s:75:\"\n		\n		\n		\n		\n		\n				\n		\n		\n		\n		\n		\n		\n		\n\n					\n										\n					\n		\n		\n			\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:4:{s:0:\"\";a:6:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:34:\"People of WordPress: Juan Aldasoro\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:72:\"https://wordpress.org/news/2022/03/people-of-wordpress-juanfra-aldasoro/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 31 Mar 2022 21:42:10 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:7:{i:0;a:5:{s:4:\"data\";s:9:\"Community\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:1;a:5:{s:4:\"data\";s:8:\"Features\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:2;a:5:{s:4:\"data\";s:10:\"Interviews\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:3;a:5:{s:4:\"data\";s:9:\"HeroPress\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:4;a:5:{s:4:\"data\";s:19:\"People of WordPress\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:5;a:5:{s:4:\"data\";s:20:\"Polyglot Contributor\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:6;a:5:{s:4:\"data\";s:12:\"Support Team\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:35:\"https://wordpress.org/news/?p=12512\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:120:\"The People of WordPress feature this month shares the story of web and plugin developer Juanfra Aldasoro from Argentina.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:28:\"webcommsat AbhaNonStopNewsUK\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:20070:\"\n<p><strong>In this series, we share some of the inspiring stories of how WordPress and its global network of contributors can change people’s lives for the better. This month we feature a website developer and product manager from Argentina, who found in the software a way to live his life in the way he dreamed.</strong></p>\n\n\n\n<figure class=\"wp-block-image size-large\"><img decoding=\"async\" loading=\"lazy\" width=\"1024\" height=\"768\" src=\"https://i2.wp.com/wordpress.org/news/files/2022/03/Juanfra_2333.jpg?resize=1024%2C768&#038;ssl=1\" alt=\"Juan standing in front of a mural\" class=\"wp-image-12525\" srcset=\"https://i0.wp.com/wordpress.org/news/files/2022/03/Juanfra_2333-scaled.jpg?resize=1024%2C768&amp;ssl=1 1024w, https://i0.wp.com/wordpress.org/news/files/2022/03/Juanfra_2333-scaled.jpg?resize=300%2C225&amp;ssl=1 300w, https://i0.wp.com/wordpress.org/news/files/2022/03/Juanfra_2333-scaled.jpg?resize=768%2C576&amp;ssl=1 768w, https://i0.wp.com/wordpress.org/news/files/2022/03/Juanfra_2333-scaled.jpg?resize=1536%2C1152&amp;ssl=1 1536w, https://i0.wp.com/wordpress.org/news/files/2022/03/Juanfra_2333-scaled.jpg?resize=2048%2C1536&amp;ssl=1 2048w\" sizes=\"(max-width: 1000px) 100vw, 1000px\" data-recalc-dims=\"1\" /></figure>\n\n\n\n<p>WordPress offers something to everyone. For Juan Aldasoro, a developer and product manager for a large distributed company, it provides an opportunity to combine his different interests and skills to live the type of life he wanted.&nbsp;</p>\n\n\n\n<p>“I like visual, creative and technical things. The joy of WordPress is that you can do all of these things, you don’t have to limit yourself to any one aspect . You can also do this from almost anywhere in the world!”</p>\n\n\n\n<p>From working in products since 2012, Juan sees WordPress as a major part of his skillset and toolbox. He said: “It gives you an opportunity to be part of building a product which could potentially be used by thousands of people and more on your site. It encourages you to think about different languages and how you can make it accessible. It allows you to work on different platforms. Working in WordPress gives you this broad approach. Working this way on products ended up pushing me into learning about all these different things. Only in open source can you really do this and use your creative side to find solutions.”</p>\n\n\n\n<h2><strong>Learning about being part of a community</strong></h2>\n\n\n\n<figure class=\"wp-block-image size-large\"><img decoding=\"async\" loading=\"lazy\" width=\"1024\" height=\"924\" src=\"https://i0.wp.com/wordpress.org/news/files/2022/03/Juanfra_2813.jpeg?resize=1024%2C924&#038;ssl=1\" alt=\"Juan standing in a astreet with murals behind him\" class=\"wp-image-12529\" srcset=\"https://i0.wp.com/wordpress.org/news/files/2022/03/Juanfra_2813-scaled.jpeg?resize=1024%2C924&amp;ssl=1 1024w, https://i0.wp.com/wordpress.org/news/files/2022/03/Juanfra_2813-scaled.jpeg?resize=300%2C271&amp;ssl=1 300w, https://i0.wp.com/wordpress.org/news/files/2022/03/Juanfra_2813-scaled.jpeg?resize=768%2C693&amp;ssl=1 768w, https://i0.wp.com/wordpress.org/news/files/2022/03/Juanfra_2813-scaled.jpeg?resize=1536%2C1386&amp;ssl=1 1536w, https://i0.wp.com/wordpress.org/news/files/2022/03/Juanfra_2813-scaled.jpeg?resize=2048%2C1847&amp;ssl=1 2048w\" sizes=\"(max-width: 1000px) 100vw, 1000px\" data-recalc-dims=\"1\" /></figure>\n\n\n\n<p>Born in a mid-sized city in Argentina, Juan was raised in a family in which music, arts and sports were always an essential part of everyday life.</p>\n\n\n\n<p>“These activities encourage human beings to be creative and participative, and at the same time they are highly formative when it comes to mould people in order to become part of a group, a team, a community.”</p>\n\n\n\n<p>The youngest of five siblings, Juan became highly motivated, trying to follow the steps of his siblings. Having a computer at home, he started to make connections that laid the foundation for his career as a developer. His interest in computers grew through that access to a machine running MS-DOS &#8211; the one with the black screen command line! Mastering this became a challenge to him and something to share with others. Through doing this, he found a way to more social interaction and new friendships.&nbsp;</p>\n\n\n\n<blockquote class=\"wp-block-quote\"><p>Without being conscious of it, my friends and I were sharing pieces of code.</p></blockquote>\n\n\n\n<p>He said: “I started learning some super easy stuff that made me feel like Houdini at that time. I could save a game play, something intangible, on a floppy disk and carry that piece of plastic and magnetic material back home. I was saving the play or game in a square object and then loading that back at home. I now realize, those were my first interactions with computer commands. Without being conscious of it, my friends and I were sharing pieces of code in a unique way.”</p>\n\n\n\n<p>This interest grew further through computer magazines and experimenting as &#8220;there was always something new to learn.” Although sport became a big part of Juan’s life in his teens, he kept up his computer learning. Taking a new direction, he found online tutorials enabling him to learn how to play the guitar. This led to setting up a punk rock band with his friends.&nbsp;</p>\n\n\n\n<p>“Education has always been important in my family, and thanks to my parent’s efforts, I attended a school where I learned to express myself in another language.” The school had hired a satellite internet connection in the mid-nineties and had HTML on the computer studies program. These facilities were not that common in Argentina or many other countries either at that time. Also, his parents had the foresight to secure a rare internet connection at the house in 1997. </p>\n\n\n\n<p>Juan recalled: “Browsing around the Internet opened a new universe in my mind. This new universe was extremely fantastic but also extremely expensive. I needed to make the most of every second online.”<br><br>“It was a whole new world and one thing led to the other. I started learning a bit of everything, editing graphics, scripting and so on. I still remember my first website in the fantastic sunset strip, Geocities.”</p>\n\n\n\n<h3><strong>Trying to go pro</strong></h3>\n\n\n\n<p>After high school, Juan moved to the city along with his brother and began to study IT at University. When he was asked by a friend to work at a software company, he decided to try that whilst continuing his studies. Through his job he had the chance to explore web-related opportunities, and with a friend from university, they started managing teams and projects across Latin America and Spain.<br><br>Juan describes this experience as one of the most fulfilling in his life. He was able to travel abroad for work, experience remote working, manage teams, present projects and speak formally in front of senior people. As the company grew at a fast pace, they learned how to set up and run a large organization. Eventually, he decided to drop out of his university program and focus on the opportunity of learning first hand.</p>\n\n\n\n<figure class=\"wp-block-image size-full\"><img decoding=\"async\" loading=\"lazy\" width=\"600\" height=\"600\" src=\"https://i0.wp.com/wordpress.org/news/files/2022/03/juanfra.jpg?resize=600%2C600&#038;ssl=1\" alt=\"Juan riding a bicycle in a historical city during his travels\" class=\"wp-image-12509\" srcset=\"https://i0.wp.com/wordpress.org/news/files/2022/03/juanfra.jpg?w=600&amp;ssl=1 600w, https://i0.wp.com/wordpress.org/news/files/2022/03/juanfra.jpg?resize=300%2C300&amp;ssl=1 300w, https://i0.wp.com/wordpress.org/news/files/2022/03/juanfra.jpg?resize=150%2C150&amp;ssl=1 150w\" sizes=\"(max-width: 600px) 100vw, 600px\" data-recalc-dims=\"1\" /></figure>\n\n\n\n<p>One of the key early learning from working internationally was that business and web development could be just as fast-moving and successful in Argentina as in other places. “I realized there’s no such thing as a secret sauce for success. Projects are backed by people’s talent and time, and you can find that in any latitude.”<br><br>By his mid-20s, Juan decided he wanted to try building something from scratch. He created a social network for photo sharing in Latin America, which was used by more than 30,000 people across Latin America and Spain in its time. Through this, he discovered that other people had a blog and he did not want to be left behind. The discovery of WordPress was to change the focus of his life.<br></p>\n\n\n\n<h2>Hello to WordPress</h2>\n\n\n\n<p>Spending some time traveling around Europe, Juan found himself ‘surrounded by uncertainty’ and worried about what the future could bring. “I had some clues, but under uncertainty, the more you ask the less you answer. I started thinking about embracing the following philosophy: I didn’t want to be part of a large company, I didn’t want to continue studying and I wanted to travel as much as I could.” He did not realize at that time how this vision for his life was to mirror what he would find in WordPress.</p>\n\n\n\n<p>He started using WordPress for a few sites in 2005. By 2007 he was using it for almost everything. He was struck by the magnitude and range of what the software could do, from a simple tool used to create a blog in the blink of an eye through to complex projects.</p>\n\n\n\n<p>His first problem-solving project was simple and saved data received through a contact form plugin. “To complete this project I discovered the Codex and I learned how easy and intuitive it is to create a plugin. I had fallen in love with WordPress.”</p>\n\n\n\n<blockquote class=\"wp-block-quote\"><p>I was truly amazed by how I could learn from others.</p></blockquote>\n\n\n\n<p>As he explored the options with the software, Juan was unsure of how intellectual property worked and wanted to be respectful of other people’s work. “I didn’t understand open source yet, and I wasn’t sure if I was stealing from others. That was my first interaction with GPL and open source. I was truly amazed by how I could learn from others and improve things created by others or by myself.”</p>\n\n\n\n<p>He realized: “WordPress was the way to go if I wanted to pursue a dream of traveling, skipping winter, and working at the same time; what we now call a digital nomad. I already knew how to work remotely, I could work for companies located anywhere, as long as they could communicate in English or Spanish.”</p>\n\n\n\n<p>Juan started his own web agency, where he provided services to small and medium-sized companies abroad in the USA, UK, and Australia. He built his reputation and developed strong relationships in WordPress. “The experience couldn’t be better. I was learning, having fun, making a living out of it, and at the same time exploring the world.”</p>\n\n\n\n<p>In mid-2012, he discovered the full power of the WordPress community firsthand. In his spare time he started developing themes and from all he heard, wanted to attend a major event with lots of others in WordPress, a WordCamp. He took the plunge and booked for WordCamp in Edinburgh, in the UK. He said: “I got to meet many super talented people, and the atmosphere of the event was awesome. A place where competitors were also colleagues. Seeing the humility of somebody like Mike Little, the co-founder of WordPress, was amazing.”</p>\n\n\n\n<p>He added: “While there, unconsciously, I started dreaming of holding something like that in Argentina &#8211; the joy of hosting the WordPress community in my home country.”</p>\n\n\n\n<p>Back home, while browsing the Codex, he happened to see that WordPress was turning 10. A lot of meetups were going to be organized worldwide to celebrate the birthday. But there was nothing organized in Argentina. This was a catalyst for starting a local meetup. Together with a colleague, he&nbsp; organized an Argentinian 10th birthday meetup. </p>\n\n\n\n<p>More than 20 people showed up. “There was a common denominator. We all loved WordPress, it was part of our day-to-day life. We wanted to share experiences, make new friends and continue growing from what we could learn from others. That day we were a group of people with shared interests. That’s the simplest way to define a community, isn’t it?” This early meetup led to the formation of what is now called <a href=\"http://wpargentina.org/\">WordPress Argentina</a>.</p>\n\n\n\n<p>In his desire to skip winters and do more traveling, his next adventure was to take him to visit family working in the US and attend one of the biggest WordCamps in the world in San Francisco. His interest kept growing and he traveled across Europe to be part of the first edition of WordCamp Europe in the Netherlands in 2013.</p>\n\n\n\n<p>He said: “There’s almost nothing I could write to fully express what you experience in such events. They are the main WordPress events worldwide. The best part: I made a lot of good friends from many different places. I’m glad I have more excuses to continue traveling.”</p>\n\n\n\n<p>Once again in Argentina, our organization started growing thanks to the energy of the whole group, we started hosting formal meetups. In May 2015, we crowned all these efforts with a new <a href=\"https://buenosaires.wordcamp.org/2015/\">WordCamp in Buenos Aires</a>, Argentina.</p>\n\n\n\n<figure class=\"wp-block-image size-large\"><img decoding=\"async\" loading=\"lazy\" width=\"1024\" height=\"683\" src=\"https://i0.wp.com/wordpress.org/news/files/2022/03/Juanfra-WCBA15-51.jpg?resize=1024%2C683&#038;ssl=1\" alt=\"Juan speaking at WordCamp Buenos Aires\" class=\"wp-image-12528\" srcset=\"https://i1.wp.com/wordpress.org/news/files/2022/03/Juanfra-WCBA15-51-scaled.jpg?resize=1024%2C683&amp;ssl=1 1024w, https://i1.wp.com/wordpress.org/news/files/2022/03/Juanfra-WCBA15-51-scaled.jpg?resize=300%2C200&amp;ssl=1 300w, https://i1.wp.com/wordpress.org/news/files/2022/03/Juanfra-WCBA15-51-scaled.jpg?resize=768%2C512&amp;ssl=1 768w, https://i1.wp.com/wordpress.org/news/files/2022/03/Juanfra-WCBA15-51-scaled.jpg?resize=1536%2C1024&amp;ssl=1 1536w, https://i1.wp.com/wordpress.org/news/files/2022/03/Juanfra-WCBA15-51-scaled.jpg?resize=2048%2C1365&amp;ssl=1 2048w\" sizes=\"(max-width: 1000px) 100vw, 1000px\" data-recalc-dims=\"1\" /></figure>\n\n\n\n<p>“Organizing such an event in my home country with many of the contributors I had met from the very first meetup was an experience I will always keep with me.”</p>\n\n\n\n<p>Juan believes one of his biggest contributions to open source was as part of being able to expand the community in Argentina and to share this with other Latin American and Spanish speaking countries. He also contributes as a volunteer translator in the Polyglots Team, to the Make WordPress Support team, and contributes to code blocks and Gutenberg. “I am really excited about seeing the future of Gutenberg as it is the future of WordPress.”</p>\n\n\n\n<p>Throughout his time contributing, Juan believes in helping to set the foundations and encouraging others to give their time and talents. He is keen to share that contributing does not have to be the same all the time and that you can have breaks and focus on one area in a particular period too. He gives the example of how in his spare time he watches Trac, where tickets about the software are logged, and looks where he might be able to help or think of solutions.</p>\n\n\n\n<p>He said: “Anytime I find I can contribute to or make improvements in code-related areas, I will do as it is important to keep giving to the community. I enjoy crawling over meta, trac, GitHub and the different places that are requesting help. There is always somewhere you can help. At the moment, my focus is code and translations. I always try to save time to help these two areas. It is like you give and you get, you learn things. You meet amazing people and opportunities arrive.”</p>\n\n\n\n<h2>Finding your path in WordPress</h2>\n\n\n\n<figure class=\"wp-block-image size-large\"><img decoding=\"async\" loading=\"lazy\" width=\"768\" height=\"1024\" src=\"https://i1.wp.com/wordpress.org/news/files/2022/03/Juanfra_1505.jpeg?resize=768%2C1024&#038;ssl=1\" alt=\"Juan sat in a street cafe surrounded by parked motorcycles\" class=\"wp-image-12527\" srcset=\"https://i2.wp.com/wordpress.org/news/files/2022/03/Juanfra_1505-scaled.jpeg?resize=768%2C1024&amp;ssl=1 768w, https://i2.wp.com/wordpress.org/news/files/2022/03/Juanfra_1505-scaled.jpeg?resize=225%2C300&amp;ssl=1 225w, https://i2.wp.com/wordpress.org/news/files/2022/03/Juanfra_1505-scaled.jpeg?resize=1152%2C1536&amp;ssl=1 1152w, https://i2.wp.com/wordpress.org/news/files/2022/03/Juanfra_1505-scaled.jpeg?resize=1536%2C2048&amp;ssl=1 1536w, https://i2.wp.com/wordpress.org/news/files/2022/03/Juanfra_1505-scaled.jpeg?w=1920&amp;ssl=1 1920w\" sizes=\"(max-width: 768px) 100vw, 768px\" data-recalc-dims=\"1\" /></figure>\n\n\n\n<p>“Life is about experiences, it is about the people you surround yourself with and trying to do what you love. What you can find in an open source project like WordPress is an environment full of people who work with a tool they love. An environment that is ready to help and to give advice. Follow what makes you happy, try to be surrounded by people who make you better, try to empower others, try to give back. Try. Make your own path.”</p>\n\n\n\n<h2 id=\"share-the-stories\">Share the stories</h2>\n\n\n\n<p>Help share these stories of open source contributors and continue to grow the community. Meet more WordPressers in the <a href=\"https://wordpress.org/news/category/newsletter/interviews/\">People of WordPress series</a>.</p>\n\n\n\n<h2 id=\"contributors-to-this-feature\">Contributors to this feature</h2>\n\n\n\n<p>Thank you to Juan Aldasoro (<a href=\'https://profiles.wordpress.org/juanfra/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>juanfra</a>) for sharing his story.&nbsp;</p>\n\n\n\n<p>Interviews and feature by Abha Thakor (<a href=\'https://profiles.wordpress.org/webcommsat/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>webcommsat</a>) and Surendra Thakor (<a href=\'https://profiles.wordpress.org/sthakor/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>sthakor</a>). Reviews by Mary Baum (<a href=\'https://profiles.wordpress.org/marybaum/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>marybaum</a>), Chloe Bringmann (<a href=\'https://profiles.wordpress.org/cbringmann/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>cbringmann</a>), Meher Bala (<a href=\'https://profiles.wordpress.org/meher/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>meher</a>), Anjana Vasan (<a href=\'https://profiles.wordpress.org/anjanavasan/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>anjanavasan</a>) and Yvette Sonneveld (<a href=\'https://profiles.wordpress.org/yvettesonneveld/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>yvettesonneveld</a>).</p>\n\n\n\n<p><em>Thanks to Josepha Haden Chomphosy&nbsp;(<a href=\'https://profiles.wordpress.org/chanthaboune/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>chanthaboune</a>) and Topher DeRosia (<a href=\'https://profiles.wordpress.org/topher1kenobe/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>topher1kenobe</a>) and others for their support&nbsp;</em>of this initiative.</p>\n\n\n\n<div class=\"wp-block-media-text is-stacked-on-mobile is-vertically-aligned-center\" style=\"grid-template-columns:29% auto\"><figure class=\"wp-block-media-text__media\"><img decoding=\"async\" loading=\"lazy\" width=\"180\" height=\"135\" src=\"https://i1.wp.com/wordpress.org/news/files/2020/03/heropress_logo_180.png?resize=180%2C135&#038;ssl=1\" alt=\"HeroPress logo\" class=\"wp-image-8409 size-full\" data-recalc-dims=\"1\" /></figure><div class=\"wp-block-media-text__content\">\n<p class=\"has-small-font-size\"><em>This People of WordPress feature is inspired by an essay originally published on </em><a href=\"https://heropress.com/\"><em>HeroPress.com</em></a><em>, a community initiative created by Topher DeRosia. It highlights people in the WordPress community who have overcome barriers and whose stories might otherwise go unheard. </em>#HeroPress </p>\n</div></div>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:30:\"com-wordpress:feed-additions:1\";a:1:{s:7:\"post-id\";a:1:{i:0;a:5:{s:4:\"data\";s:5:\"12512\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:21;a:6:{s:4:\"data\";s:57:\"\n		\n		\n		\n		\n		\n				\n		\n\n					\n										\n					\n		\n		\n			\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:4:{s:0:\"\";a:6:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:45:\"Get Creative with the All-New Pattern Creator\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:81:\"https://wordpress.org/news/2022/03/get-creative-with-the-all-new-pattern-creator/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Fri, 25 Mar 2022 17:34:42 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:1:{i:0;a:5:{s:4:\"data\";s:7:\"General\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:35:\"https://wordpress.org/news/?p=12460\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:351:\"It’s been less than a year since the WordPress Pattern Directory was launched, and we already have more exciting news to share. The Pattern Creator is live! You can now build, edit, and submit your best block patterns to the Pattern Directory—submissions are open to all with a WordPress.org user account! The WordPress Pattern Directory [&#8230;]\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:12:\"Anjana Vasan\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:5751:\"\n<p>It’s been less than a year since the <a rel=\"noreferrer noopener\" href=\"https://wordpress.org/patterns/\" target=\"_blank\">WordPress Pattern Directory</a> was launched, and we already have more exciting news to share. <strong>The <a rel=\"noreferrer noopener\" href=\"https://wordpress.org/patterns/new-pattern/\" target=\"_blank\">Pattern Creator</a> is live! You can now build, edit, and submit your best block patterns to the Pattern Directory—submissions are open to all with a WordPress.org user account!</strong></p>\n\n\n\n<figure class=\"wp-container-21 wp-block-gallery-20 wp-block-gallery alignfull has-nested-images columns-default\">\n<figure class=\"wp-block-image size-full\"><img decoding=\"async\" loading=\"lazy\" width=\"2800\" height=\"3000\" data-id=\"12485\"  src=\"https://i0.wp.com/wordpress.org/news/files/2022/03/patterns.png?resize=2800%2C3000&#038;ssl=1\" alt=\"Pattern Directory, showing gallery patterns.\" class=\"wp-image-12485\" srcset=\"https://i0.wp.com/wordpress.org/news/files/2022/03/patterns.png?w=2800&amp;ssl=1 2800w, https://i0.wp.com/wordpress.org/news/files/2022/03/patterns.png?resize=280%2C300&amp;ssl=1 280w, https://i0.wp.com/wordpress.org/news/files/2022/03/patterns.png?resize=956%2C1024&amp;ssl=1 956w, https://i0.wp.com/wordpress.org/news/files/2022/03/patterns.png?resize=768%2C823&amp;ssl=1 768w, https://i0.wp.com/wordpress.org/news/files/2022/03/patterns.png?resize=1434%2C1536&amp;ssl=1 1434w, https://i0.wp.com/wordpress.org/news/files/2022/03/patterns.png?resize=1911%2C2048&amp;ssl=1 1911w, https://i0.wp.com/wordpress.org/news/files/2022/03/patterns.png?w=2000&amp;ssl=1 2000w\" sizes=\"(max-width: 1000px) 100vw, 1000px\" data-recalc-dims=\"1\" /></figure>\n\n\n\n<figure class=\"wp-block-image size-full\"><img decoding=\"async\" loading=\"lazy\" width=\"2800\" height=\"2841\" data-id=\"12468\"  src=\"https://i0.wp.com/wordpress.org/news/files/2022/03/community-pattern-3-1-1.png?resize=2800%2C2841&#038;ssl=1\" alt=\"View of a user-submitted pattern.\" class=\"wp-image-12468\" srcset=\"https://i0.wp.com/wordpress.org/news/files/2022/03/community-pattern-3-1-1.png?w=2800&amp;ssl=1 2800w, https://i0.wp.com/wordpress.org/news/files/2022/03/community-pattern-3-1-1.png?resize=296%2C300&amp;ssl=1 296w, https://i0.wp.com/wordpress.org/news/files/2022/03/community-pattern-3-1-1.png?resize=1009%2C1024&amp;ssl=1 1009w, https://i0.wp.com/wordpress.org/news/files/2022/03/community-pattern-3-1-1.png?resize=768%2C779&amp;ssl=1 768w, https://i0.wp.com/wordpress.org/news/files/2022/03/community-pattern-3-1-1.png?resize=1514%2C1536&amp;ssl=1 1514w, https://i0.wp.com/wordpress.org/news/files/2022/03/community-pattern-3-1-1.png?resize=2018%2C2048&amp;ssl=1 2018w\" sizes=\"(max-width: 1000px) 100vw, 1000px\" data-recalc-dims=\"1\" /></figure>\n<figcaption class=\"blocks-gallery-caption\">Pattern Directory — List of patterns, and a single pattern detail.</figcaption></figure>\n\n\n\n<p>The <a rel=\"noreferrer noopener\" href=\"https://wordpress.org/support/article/block-pattern-directory/\" target=\"_blank\">WordPress Pattern Directory</a> includes attractive, handy patterns created by designers that can make your experience building a stunning site <em>much</em> easier. <a href=\"https://wordpress.org/support/article/block-pattern/\" target=\"_blank\" rel=\"noreferrer noopener\">Patterns</a> can save you a significant amount of time and also give you greater freedom when you’re building your site. With patterns, you can make or replicate complex layouts with just a few clicks, and using them is as simple as copy and paste.</p>\n\n\n\n<h2>Create Your Own Bold, Beautiful Patterns Built Entirely with Blocks</h2>\n\n\n\n<figure class=\"wp-block-image size-large\"><a href=\"https://i1.wp.com/wordpress.org/news/files/2022/03/submission-2.png?ssl=1\"><img decoding=\"async\" loading=\"lazy\" width=\"1024\" height=\"683\" src=\"https://i1.wp.com/wordpress.org/news/files/2022/03/submission-2.png?resize=1024%2C683&#038;ssl=1\" alt=\"Pattern submission screen, successfully submitted pattern with a &quot;Thank you&quot; modal.\" class=\"wp-image-12479\" srcset=\"https://i1.wp.com/wordpress.org/news/files/2022/03/submission-2.png?resize=1024%2C683&amp;ssl=1 1024w, https://i1.wp.com/wordpress.org/news/files/2022/03/submission-2.png?resize=300%2C200&amp;ssl=1 300w, https://i1.wp.com/wordpress.org/news/files/2022/03/submission-2.png?resize=768%2C512&amp;ssl=1 768w, https://i1.wp.com/wordpress.org/news/files/2022/03/submission-2.png?resize=1536%2C1024&amp;ssl=1 1536w, https://i1.wp.com/wordpress.org/news/files/2022/03/submission-2.png?resize=2048%2C1365&amp;ssl=1 2048w\" sizes=\"(max-width: 1000px) 100vw, 1000px\" data-recalc-dims=\"1\" /></a></figure>\n\n\n\n<p>As the name implies, the <a rel=\"noreferrer noopener\" href=\"https://wordpress.org/patterns/new-pattern/\" target=\"_blank\">Pattern Creator</a> allows anyone, from designers to content creators, to make custom patterns: a collection of blocks arranged in any way, for any purpose intended by the creator. Like most things in WordPress, these are available for public use once it’s submitted to the WordPress Pattern Directory. Have a look at <a rel=\"noreferrer noopener\" href=\"https://wordpress.org/patterns/about/\" target=\"_blank\">these guidelines</a> to learn more about what makes a pattern suitable for listing in the directory.</p>\n\n\n\n<p>So what are you waiting for? Check out <a href=\"https://wordpress.org/patterns/\" target=\"_blank\" rel=\"noreferrer noopener\">all the patterns</a> already available or better yet, make your own!</p>\n\n\n\n<div class=\"wp-container-22 wp-block-buttons\">\n<div class=\"wp-block-button aligncenter is-style-fill\"><a class=\"wp-block-button__link\" href=\"https://wordpress.org/patterns/about/\" style=\"border-radius:75px\"><strong>Learn more about creating patterns</strong></a></div>\n</div>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:30:\"com-wordpress:feed-additions:1\";a:1:{s:7:\"post-id\";a:1:{i:0;a:5:{s:4:\"data\";s:5:\"12460\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:22;a:6:{s:4:\"data\";s:61:\"\n		\n		\n		\n		\n		\n				\n		\n		\n\n					\n										\n					\n		\n		\n\n			\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:4:{s:0:\"\";a:7:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:50:\"WP Briefing: Episode 27: Is WordPress Made for Me?\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:71:\"https://wordpress.org/news/2022/03/episode-27-is-wordpress-made-for-me/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Mon, 21 Mar 2022 12:57:38 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:2:{i:0;a:5:{s:4:\"data\";s:7:\"Podcast\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:1;a:5:{s:4:\"data\";s:11:\"wp-briefing\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:53:\"https://wordpress.org/news/?post_type=podcast&p=12451\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:416:\"Who is WordPress actually made for? Join our host, WordPress Executive Director Josepha Haden Chomphosy, as she explores this controversial question and three things that can help find the answer. Have a question you&#8217;d like answered? You can submit them to wpbriefing@wordpress.org, either written or as a voice recording. Hosts: Josepha Haden Chomphosy Editor:&#160;Dustin HartzlerLogo:&#160;Beatriz [&#8230;]\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:9:\"enclosure\";a:1:{i:0;a:5:{s:4:\"data\";s:0:\"\";s:7:\"attribs\";a:1:{s:0:\"\";a:3:{s:3:\"url\";s:60:\"https://wordpress.org/news/files/2022/03/WP-Briefing-027.mp3\";s:6:\"length\";s:1:\"0\";s:4:\"type\";s:0:\"\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:14:\"Santana Inniss\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:9785:\"\n<p>Who is WordPress actually made for? Join our host, WordPress Executive Director Josepha Haden Chomphosy, as she explores this controversial question and three things that can help find the answer.</p>\n\n\n\n<p><strong><em>H</em></strong><em><strong>ave a question you&#8217;d like answered? You can submit them to <a href=\"mailto:wpbriefing@wordpress.org\">wpbriefing@wordpress.org</a>, either written or as a voice recording.</strong></em> </p>\n\n\n\n<p>Hosts: <a href=\"https://profiles.wordpress.org/chanthaboune/\">Josepha Haden Chomphosy</a> <br>Editor:&nbsp;<a href=\"https://profiles.wordpress.org/dustinhartzler/\">Dustin Hartzler</a><br>Logo:&nbsp;<a href=\"https://profiles.wordpress.org/beafialho/\">Beatriz Fialho</a><br>Production:&nbsp;<a href=\"https://profiles.wordpress.org/santanainniss/\">Santana Inniss</a></p>\n\n\n\n<h2>References</h2>\n\n\n\n<ul><li><a href=\"https://europe.wordcamp.org/2022/call-for-volunteers/\">WordCamp Europe call for volunteers</a></li><li><a href=\"https://make.wordpress.org/photos/\">WordPress Photo Directory team</a></li><li><a href=\"https://www.unicefusa.org/stories/unicef-children-crossfire-ukraine-crisis/39542?utm_campaign=20220225_Emergencies&amp;utm_medium=Organic&amp;utm_source=UkraineWebStoryChildrenFeb2022&amp;utm_content=LearnMoreUkraineWebStoryChildrenFeb2022&amp;ms=Organic_PRL_2022_Emergencies_20220225_UkraineWebStoryChildrenFeb2022_LearnMoreUkraineWebStoryChildrenFeb2022_none_none&amp;initialms=Organic_PRL_2022_Emergencies_20220225_UkraineWebStoryChildrenFeb2022_LearnMoreUkraineWebStoryChildrenFeb2022_none_none\">UNICEF</a></li><li><a href=\"https://www.doctorswithoutborders.org/what-we-do/countries/ukraine\">Médecins Sans Frontieres</a>&nbsp;</li><li><a href=\"https://www.icrc.org/en/where-we-work/europe-central-asia/ukraine\">International Committee of the Red Cross</a>&nbsp;</li><li><a href=\"https://help.rescue.org/donate/ukraine-acq?ms=gs_ppc_fy22_ukraine_mmus_feb&amp;initialms=gs_ppc_fy22_ukraine_mmus_feb&amp;gclid=CjwKCAiAjoeRBhAJEiwAYY3nDHNlEUUNRM4wKl1bY0ploy1RNl0M7G1OlLTqawZdg_XhrJ0TircZ_RoCfh8QAvD_BwE\">International Rescue Committee</a></li><li><a href=\"https://www.unrefugees.org/what-we-do/\">UN Refugee Agency</a>&nbsp;</li><li><a href=\"https://donate.wck.org/give/236738/#!/donation/checkout\">World Central Kitchen</a></li><li><a href=\"https://www.techtotherescue.org/tech/tech-for-ukraine\">Tech For Ukraine</a></li><li><a href=\"https://twitter.com/hashtag/wp4ukraine\">#WP4Ukraine</a></li></ul>\n\n\n\n<h2>Transcript </h2>\n\n\n<a class=\"wp-block-read-more\" href=\"https://wordpress.org/news/2022/03/episode-27-is-wordpress-made-for-me/\" target=\"_self\">Read more</a>\n\n\n<p><strong>Episode 27</strong></p>\n\n\n\n<p><strong>Josepha Haden Chomphosy [00:00:00]&nbsp;</strong></p>\n\n\n\n<p>Hello everyone, and welcome to the WordPress Briefing: the podcast where you can catch quick explanations of the ideas behind the WordPress open source project, some insight into the community that supports it, and get a small list of big things coming up in the next two weeks. I&#8217;m your host, Josepha Haden Chomphosy. Here we go!</p>\n\n\n\n<p>Today, we&#8217;re talking about who WordPress is built for. I was talking to a group of contributors last week and we encountered some questions around just who WordPress is built for. And it&#8217;s a question that you&#8217;ll find any time that you&#8217;re working on user testing or on triaging tickets, and especially when that comes up when you look at the big picture, roadmap sorts of things. The easiest answer for this question is, of course, everyone because WordPress&#8217; mission is to democratize publishing and that should be available to everyone.</p>\n\n\n\n<p><strong>Josepha Haden Chomphosy </strong><strong>[00:01:11]</strong></p>\n\n\n\n<p>However, everyone is a really big target and certainly doesn&#8217;t help get your mind around the people that you&#8217;re wanting to actually build it for, the people that you actually want to be able to use your product, your software on a day-to-day basis. So let&#8217;s take a look at the one question that can help us figure out who it&#8217;s built for today and how we get it to being something that&#8217;s built forever.</p>\n\n\n\n<p>Firstly, there&#8217;s a basic premise of open source that informs this thought. And that premise is that we are citizens of a community of contributors therefore the decisions are made by the people who show up. In general, I believe that to be true, though, I also believe that some basic qualifications are needed.</p>\n\n\n\n<p><strong>Josepha Haden Chomphosy [00:01:50]&nbsp;</strong></p>\n\n\n\n<p>So with that in mind, the one question that can help us figure out who a software is built for is this: how do your active contributors see themselves? I would bet that most contributors to open source software projects, like WordPress, are developers of some sort, it is sort of written right into the definition of the project.&nbsp;</p>\n\n\n\n<p>If you work on software, then you need developers. And what I love about WordPress, in particular, is that we do work to include contributors who are not developers. Yet it still remains true that there is a fairly high level of technical knowledge required to actively contribute.&nbsp;</p>\n\n\n\n<p><strong>Josepha Haden Chomphosy [00:2:25]&nbsp;</strong></p>\n\n\n\n<p>Which kind of brings us to the second half of the original question of how can we make sure that WordPress can be something that&#8217;s built for everyone? The answer to this one is easy to say, hard to do, and that is to make sure to include them as co-creators in the development process.&nbsp;</p>\n\n\n\n<p>We&#8217;ve talked about co-creators in open source before. It&#8217;s this idea that people who use the software every day are likely to know the biggest pain points. So if you want your software to be used by people who don&#8217;t know HTML, talk to a bunch of people who don&#8217;t know HTML about how it is to use your software.&nbsp;</p>\n\n\n\n<p>If you want your software to be mostly used by enterprise agencies, talk to enterprise agencies, but also ask them what their clients hate, because everyone has more than one stakeholder. And I know that I said this already, but it bears repeating that, obviously, this is all very easy to say and hard to do.&nbsp;</p>\n\n\n\n<p><strong>Josepha Haden Chomphosy [00:3:20]&nbsp;</strong></p>\n\n\n\n<p>So what is my best guess for the how-to-do part for WordPress? There are three things.&nbsp;</p>\n\n\n\n<p>The first is testing. This not only helps bring in new contributors and helps train future contributors, which I&#8217;ve talked about on the podcast before. But testing also gives us a higher chance of actionable feedback from folks who don&#8217;t necessarily spend time directly in the WordPress project.&nbsp;</p>\n\n\n\n<p>Frequently the feedback that we do get that is just kind of undirected and ad hoc is exactly that– it is undirected and ad hoc and is then hard to follow up on and make sure that we understand what was wrong and how we can help fix it. And so testing is important for that. And testing it turns out is important for a bunch of things. When you&#8217;re working in open source.&nbsp;</p>\n\n\n\n<p>The next thing is support. So checking in with support teams at hosts, as well as the hardworking support teams in the project. And that can really help us to get early indications of what difficulties exist now. They have routinely seen problems and issues that are raised in support forums, and from their everyday users that they are providing support to.&nbsp;</p>\n\n\n\n<p>That probably could be fixed in WordPress if we had a good understanding of just what was not going right, how many people really needed it to go better, and what our targets were to fix that particular problem.&nbsp;</p>\n\n\n\n<p><strong>Josepha Haden Chomphosy [00:4:45]&nbsp;</strong></p>\n\n\n\n<p>And the third thing is communication. I know that I&#8217;ve gone on record in many places as saying that most of our problems at the end of the day are communication problems. And I&#8217;m going on record about it again here in this podcast, establishing better communication patterns with users is key.&nbsp;</p>\n\n\n\n<p>That can be a multi-year project in itself. And even after that, it&#8217;s going to be an ongoing journey. But it is one of the many things that WordCamps and other WordPress events have given to us over the years, an opportunity to really hear from and see the struggles that people who are not building with WordPress every day, or literally building WordPress every day are actually having.</p>\n\n\n\n<p><strong>Josepha Haden Chomphosy [00:5:34]&nbsp;</strong></p>\n\n\n\n<p>So now that you&#8217;ve heard my small list of way too big things, that brings us to our regular small list of big things. The first thing is that WordCamp Europe is still looking for volunteers. If you&#8217;ve never done that before, I think it&#8217;s quite fun. You get to meet a lot of people and the team of organizers is super fun, but I&#8217;ll leave a link for you in the show notes.</p>\n\n\n\n<p>We also have a new code-free way to contribute through the photo directory. That team is just getting started and still is working toward building out its programs. So now&#8217;s a good time to drop in and just kind of see what they are up to. And finally, a reminder that we do have contributors who are affected by the war in Ukraine right now. I will reshare the list of humanitarian organizations in case you missed them a couple of weeks ago as well.&nbsp;</p>\n\n\n\n<p><strong>Josepha Haden Chomphosy [00:6:21]&nbsp;</strong></p>\n\n\n\n<p>And that my friends is your small list of big things. Thank you for tuning in today for this WordPress Briefing. I&#8217;m your host, Josepha Haden Chomphosy. I&#8217;ll see you again in a couple of weeks.</p>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:30:\"com-wordpress:feed-additions:1\";a:1:{s:7:\"post-id\";a:1:{i:0;a:5:{s:4:\"data\";s:5:\"12451\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:23;a:6:{s:4:\"data\";s:63:\"\n		\n		\n		\n		\n		\n				\n		\n		\n		\n\n					\n										\n					\n		\n		\n			\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:4:{s:0:\"\";a:6:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:48:\"WordPress 5.9.2 Security and Maintenance Release\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:80:\"https://wordpress.org/news/2022/03/wordpress-5-9-2-security-maintenance-release/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Fri, 11 Mar 2022 02:24:13 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:3:{i:0;a:5:{s:4:\"data\";s:8:\"Releases\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:1;a:5:{s:4:\"data\";s:8:\"Security\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:2;a:5:{s:4:\"data\";s:3:\"5.9\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:35:\"https://wordpress.org/news/?p=12421\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:367:\"WordPress 5.9.2&#160;is now available! This security and maintenance release features 1 bug fix in addition to 3 security fixes. Because this is a security release, it is recommended that you update your sites immediately. All versions since WordPress 3.7 have also been updated. WordPress 5.9.2 is a security and maintenance release. The next major release [&#8230;]\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:9:\"Jb Audras\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:3697:\"\n<p><strong>WordPress 5.9.2&nbsp;</strong>is now available!</p>\n\n\n\n<p>This security and maintenance release features <a href=\"https://core.trac.wordpress.org/ticket/54578\">1 bug fix</a> in addition to 3 security fixes. Because this is a <strong>security release</strong>, it is recommended that you update your sites immediately. All versions since WordPress 3.7 have also been updated.</p>\n\n\n\n<p>WordPress 5.9.2 is a security and maintenance release. The next major release will be version&nbsp;<a href=\"https://make.wordpress.org/core/6-0/\">6.0</a>.</p>\n\n\n\n<p>You can&nbsp;<a href=\"https://wordpress.org/wordpress-5.9.2.zip\">download WordPress 5.9.2 from WordPress.org</a>, or visit your Dashboard&nbsp;→ Updates and click “Update Now”.</p>\n\n\n\n<p>If you have sites that support automatic background updates, they’ve already started the update process.</p>\n\n\n\n<p>The security team would like to thank the following people for responsively reporting vulnerabilities, allowing them to be fixed in this release:</p>\n\n\n\n<ul><li>Melar Dev, for finding a Prototype Pollution Vulnerability in a jQuery dependency</li><li>Ben Bidner&nbsp;of the WordPress security team, for finding a Stored Cross Site Scripting Vulnerability</li><li>Researchers from <em>Johns Hopkins University, </em>for finding a Prototype Pollution Vulnerability in the block editor</li></ul>\n\n\n\n<p>For more information, browse the&nbsp;<a href=\"https://core.trac.wordpress.org/query?milestone=5.9.2&amp;group=component&amp;col=id&amp;col=summary&amp;col=owner&amp;col=type&amp;col=status&amp;col=priority&amp;col=milestone&amp;order=priority\">full list of changes</a>&nbsp;on Trac, or check out the&nbsp;<a href=\"https://wordpress.org/support/wordpress-version/version-5-9-2/\">version 5.9.2 HelpHub documentation page</a>.</p>\n\n\n\n<h2 id=\"thanks-and-props\">Thanks and props!</h2>\n\n\n\n<p>The 5.9.2 release was led by <a href=\"https://profiles.wordpress.org/audrasjb/\">Jb Audras</a>, with the help of <a href=\"https://profiles.wordpress.org/jorgefilipecosta/\">Jorge Costa</a> on package updates, <a href=\"https://profiles.wordpress.org/sergeybiryukov/\">Sergey Biryukov</a> on mission control, and <a href=\"https://profiles.wordpress.org/davidbaumwald/\">David Baumwald</a> on backport commits.</p>\n\n\n\n<p>In addition to the release squad members and security researchers mentioned above, thank you to everyone who helped make WordPress 5.9.2 happen:</p>\n\n\n\n<p class=\"is-style-wporg-props-short alignfull\"><a href=\"https://profiles.wordpress.org/alanjacobmathew/\">Alan Jacob Mathew</a>, <a href=\"https://profiles.wordpress.org/xknown/\">Alex Concha</a>, <a href=\"https://profiles.wordpress.org/oandregal/\">André</a>, <a href=\"https://profiles.wordpress.org/antonvlasenko/\">Anton Vlasenko</a>, <a href=\"https://profiles.wordpress.org/davidbaumwald/\">David Baumwald</a>, <a href=\"https://profiles.wordpress.org/ehtis/\">ehtis</a>, <a href=\"https://profiles.wordpress.org/audrasjb/\">Jb Audras</a>, <a href=\"https://profiles.wordpress.org/sergeybiryukov/\">Jorge Costa</a>, <a href=\"https://profiles.wordpress.org/peterwilsoncc/\">Peter Wilson</a>, <a href=\"https://profiles.wordpress.org/sergeybiryukov/\">Sergey Biryukov</a>, <a href=\"https://profiles.wordpress.org/hellofromTonya/\">Tonya Mork</a>, and <a href=\"https://profiles.wordpress.org/ironprogrammer/\">ironprogrammer</a>.</p>\n\n\n\n<p class=\"has-text-align-right has-small-font-size\"><em>Props <a href=\'https://profiles.wordpress.org/davidbaumwald/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>davidbaumwald</a> and <a href=\'https://profiles.wordpress.org/sergeybiryukov/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>sergeybiryukov</a> for peer review.</em></p>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:30:\"com-wordpress:feed-additions:1\";a:1:{s:7:\"post-id\";a:1:{i:0;a:5:{s:4:\"data\";s:5:\"12421\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:24;a:6:{s:4:\"data\";s:61:\"\n		\n		\n		\n		\n		\n				\n		\n		\n\n					\n										\n					\n		\n		\n\n			\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:4:{s:0:\"\";a:7:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:76:\"WP Briefing: Episode 26: Matt Mullenweg on Ukraine, Community, and WordPress\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:96:\"https://wordpress.org/news/2022/03/episode-26-matt-mullenweg-on-ukraine-community-and-wordpress/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Fri, 04 Mar 2022 21:39:46 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:2:{i:0;a:5:{s:4:\"data\";s:7:\"Podcast\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:1;a:5:{s:4:\"data\";s:11:\"wp-briefing\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:53:\"https://wordpress.org/news/?post_type=podcast&p=12415\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:384:\"Matt Mullenweg speaks to WordPress contributors worldwide on this special edition of the WP Briefing podcast with Josepha Haden Chomphosy. Join us to hear Matt’s thoughts on Ukraine. Have a question you&#8217;d like answered? You can submit them to wpbriefing@wordpress.org, either written or as a voice recording. Credits Hosts: Josepha Haden Chomphosy and Matt Mullenweg [&#8230;]\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:9:\"enclosure\";a:1:{i:0;a:5:{s:4:\"data\";s:0:\"\";s:7:\"attribs\";a:1:{s:0:\"\";a:3:{s:3:\"url\";s:62:\"https://wordpress.org/news/files/2022/03/WP-Briefing-026-1.mp3\";s:6:\"length\";s:1:\"0\";s:4:\"type\";s:0:\"\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:15:\"Chloe Bringmann\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:6361:\"\n<p>Matt Mullenweg speaks to WordPress contributors worldwide on this special edition of the WP Briefing podcast with Josepha Haden Chomphosy. Join us to hear Matt’s thoughts on Ukraine.</p>\n\n\n\n<p><strong><em>H</em></strong><em><strong>ave a question you&#8217;d like answered? You can submit them to <a href=\"mailto:wpbriefing@wordpress.org\">wpbriefing@wordpress.org</a>, either written or as a voice recording.</strong></em></p>\n\n\n\n<h2 id=\"credits\">Credits</h2>\n\n\n\n<ul><li>Hosts: <a href=\"https://profiles.wordpress.org/chanthaboune/\">Josepha Haden Chomphosy</a> and <a href=\"https://profiles.wordpress.org/matt/\">Matt Mullenweg</a></li><li>Editor:&nbsp;<a href=\"https://profiles.wordpress.org/dustinhartzler/\">Dustin Hartzler</a></li><li>Logo:&nbsp;<a href=\"https://profiles.wordpress.org/beafialho/\">Beatriz Fialho</a></li><li>Production:&nbsp;<a href=\"https://profiles.wordpress.org/cbringmann/\">Chloé Bringmann</a> &amp; <a href=\"https://profiles.wordpress.org/santanainniss/\">Santana Inniss</a></li></ul>\n\n\n\n<h2>How You Can Help</h2>\n\n\n\n<p><a href=\"https://www.unicefusa.org/stories/unicef-children-crossfire-ukraine-crisis/39542?utm_campaign=20220225_Emergencies&amp;utm_medium=Organic&amp;utm_source=UkraineWebStoryChildrenFeb2022&amp;utm_content=LearnMoreUkraineWebStoryChildrenFeb2022&amp;ms=Organic_PRL_2022_Emergencies_20220225_UkraineWebStoryChildrenFeb2022_LearnMoreUkraineWebStoryChildrenFeb2022_none_none&amp;initialms=Organic_PRL_2022_Emergencies_20220225_UkraineWebStoryChildrenFeb2022_LearnMoreUkraineWebStoryChildrenFeb2022_none_none\">UNICEF</a></p>\n\n\n\n<p><a href=\"https://www.doctorswithoutborders.org/what-we-do/countries/ukraine\">Médecins Sans Frontieres</a>&nbsp;</p>\n\n\n\n<p><a href=\"https://www.icrc.org/en/where-we-work/europe-central-asia/ukraine\">International Committee of the Red Cross</a>&nbsp;</p>\n\n\n\n<p><a href=\"https://help.rescue.org/donate/ukraine-acq?ms=gs_ppc_fy22_ukraine_mmus_feb&amp;initialms=gs_ppc_fy22_ukraine_mmus_feb&amp;gclid=CjwKCAiAjoeRBhAJEiwAYY3nDHNlEUUNRM4wKl1bY0ploy1RNl0M7G1OlLTqawZdg_XhrJ0TircZ_RoCfh8QAvD_BwE\">International Rescue Committee</a></p>\n\n\n\n<p><a href=\"https://www.unrefugees.org/what-we-do/\">UN Refugee Agency</a>&nbsp;</p>\n\n\n\n<p><a href=\"https://donate.wck.org/give/236738/#!/donation/checkout\">World Central Kitchen</a></p>\n\n\n\n<p><a href=\"https://www.techtotherescue.org/tech/tech-for-ukraine\">Tech For Ukraine</a></p>\n\n\n\n<p><a href=\"https://twitter.com/hashtag/wp4ukraine\">#WP4Ukraine</a></p>\n\n\n\n<h2>Transcript</h2>\n\n\n\n<span id=\"more-12415\"></span>\n\n\n\n<p><strong>Josepha Haden Chomphosy&nbsp; </strong>00:00</p>\n\n\n\n<p>Hello, everyone, and welcome to a special edition of the WordPress Briefing. I have Matt here with me today because we want to acknowledge that we are once again at the start of a very difficult time. Neither of us would presume to know what it&#8217;s like to be at the heart of such massive disruption in our lives. But who would we be if we didn&#8217;t stop and check in with you all, the project that we hold so dear? And with that, I&#8217;ll hand it right over to you, Matt.</p>\n\n\n\n<p><strong>Matt Mullenweg&nbsp; </strong>00:27</p>\n\n\n\n<p>Hello everyone. First, I want to thank Josepha for inviting me to join the WordPress Briefing to share what’s been on my mind in light of recent global events.&nbsp;</p>\n\n\n\n<p><strong>Matt Mullenweg&nbsp; </strong>00:37</p>\n\n\n\n<p>I&#8217;ve been listening and watching events escalate in Ukraine, often in a state of shock. The scale alone is hard to take in. I mean, in the last 7 days, more than 500,000 people have fled their homes, more refugees are expected every day. The downstream humanitarian crises of the invasion are unimaginable.&nbsp;&nbsp;</p>\n\n\n\n<p><strong>Matt Mullenweg&nbsp; </strong>00:56</p>\n\n\n\n<p>And seeing destruction in the world we live in is confusing, disconcerting, and difficult. In my experience, open source and WordPress bring people together; people from other countries and cultures, people that we know as friends and colleagues. Technology connects us, regardless of where we are. Nothing can negate the bad things happening in the world, but when I see how this community of contributors collaborates, regardless of borders, you all remind me of the good in the world every day.</p>\n\n\n\n<p><strong>Matt Mullenweg&nbsp; </strong>01:30</p>\n\n\n\n<p>I firmly believe that the web can be an equalizer and a force for good in the world. To me, the WordPress project is the epitome of goodness—everyone has a voice, a platform, and a community. You have the power to make your corner of the world, and the web, a sanctuary for those who need it—especially now.</p>\n\n\n\n<p><strong>Matt Mullenweg&nbsp; </strong>01:45</p>\n\n\n\n<p>If you or someone you know is affected by this war, I encourage you to be present as the ramifications unfold. While we may all feel fatigued and have a sense of languishing from the past two years of the Covid pandemic, the gift of time and support for one another cannot be overstated. I&#8217;m confident that every single person in the WordPress community will approach the situation in Ukraine with sensitivity and understanding.&nbsp;</p>\n\n\n\n<p><strong>Matt Mullenweg&nbsp; </strong>02:07</p>\n\n\n\n<p>I invite you to join me in standing with those in the world working to end conflict and working toward a world of peace, promise, and opportunity. If you&#8217;re looking for a way to help support the humanitarian crisis in Ukraine, I will offer some suggested NGOs, or Non-Governmental Organizations, that provide assistance to local peacebuilders in the region.&nbsp;</p>\n\n\n\n<p><strong>Matt Mullenweg&nbsp; </strong>02:26</p>\n\n\n\n<p>In closing, please know that my thoughts are with everyone in our community. I know that my words here can’t change anything there, but I hope that we all remember that words of support are never unwelcome. And we can never know when a little human kindness can help someone share the invisible heaviness in their heart.&nbsp;</p>\n\n\n\n<p><strong>Josepha Haden Chomphosy&nbsp; </strong>02:44</p>\n\n\n\n<p>Thanks for that, Matt. My friends, there are links in the show notes to some of the groups that Matt referenced. And that is it for this special edition of the WordPress Briefing. I&#8217;m your host, Josepha Haden Chomphosy. Be safe, be kind to yourself and others, and I&#8217;ll see you again in a couple of weeks.</p>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:30:\"com-wordpress:feed-additions:1\";a:1:{s:7:\"post-id\";a:1:{i:0;a:5:{s:4:\"data\";s:5:\"12415\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:25;a:6:{s:4:\"data\";s:60:\"\n		\n		\n		\n		\n		\n				\n		\n		\n\n					\n										\n					\n		\n		\n			\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:4:{s:0:\"\";a:6:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:40:\"The Month in WordPress – February 2022\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:72:\"https://wordpress.org/news/2022/03/the-month-in-wordpress-february-2022/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Fri, 04 Mar 2022 17:40:49 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:2:{i:0;a:5:{s:4:\"data\";s:18:\"Month in WordPress\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:1;a:5:{s:4:\"data\";s:22:\"the month in wordpress\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:35:\"https://wordpress.org/news/?p=12411\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:332:\"There’s a lot going on in the world right now, and safety is top of mind for everyone in the WordPress community. If you don&#8217;t know where to begin, or how to support your peers, Executive Director Josepha Chomphosy’s advice to the global community is to start small.&#160; Overall, February has been a busy month [&#8230;]\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:12:\"Anjana Vasan\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:11940:\"\n<p>There’s a lot going on in the world right now, and safety is top of mind for everyone in the WordPress community. If you don&#8217;t know where to begin, or how to support your peers, Executive Director <a href=\"https://josepha.blog/2022/02/25/to-my-global-community-start-small/\">Josepha Chomphosy’s advice</a> to the global community is to start small.&nbsp;</p>\n\n\n\n<p>Overall, February has been a busy month for WordPress. To begin with, it was thrilling to see the enthusiasm for the release of WordPress 5.9 Joséphine from January continue last month, and that’s not all.&nbsp;</p>\n\n\n\n<p>We have many exciting updates to share, so keep reading to learn about the latest achievements from the WordPress community.</p>\n\n\n\n<hr class=\"wp-block-separator\" />\n\n\n\n<h2>WordPress 6.0: May 24, 2022 is the proposed release date</h2>\n\n\n\n<ul><li>The proposed <a href=\"https://make.wordpress.org/core/2022/02/16/wordpress-6-0-planning-roundup/\">release schedule for WordPress 6.0</a>, the second major release of 2022, has been published.</li><li>While we’re waiting for 6.0, check out the <a href=\"https://wordpress.org/news/2022/02/wordpress-5-9-1-maintenance-release/\">WordPress 5.9.1 maintenance release</a> which was released on February 22, 2022.</li></ul>\n\n\n\n<div class=\"wp-container-23 wp-block-buttons\">\n<div class=\"wp-block-button aligncenter\"><a class=\"wp-block-button__link\" href=\"https://wordpress.slack.com/archives/C02RQBWTW\" target=\"_blank\" rel=\"noreferrer noopener\"><strong>Are you interested in contributing to WordPress core?</strong> Join the #core channel in Slack. Also, don&#8217;t miss the Core Team’s weekly developer chat on Wednesdays at 8 PM UTC.</a></div>\n</div>\n\n\n\n<h2>Gutenberg releases: Versions 12.5, 12.6, and 12.7 were released</h2>\n\n\n\n<p>The Core Team launched three new versions of Gutenberg last month. All come with new features, code quality improvements, and bug fixes.</p>\n\n\n\n<ul><li><a href=\"https://make.wordpress.org/core/2022/03/02/whats-new-in-gutenberg-12-7-2-march/\">Gutenberg 12.7 </a>is available to download. This version improves the Patterns experience, allows you to add border styles to column blocks, and includes other new features.</li><li><a href=\"https://make.wordpress.org/core/2022/02/16/whats-new-in-gutenberg-12-6-16-february/\">Gutenberg 12.6</a> was launched on February 16, 2022. This release includes a new color panel, updated color controls, a new Post Author Biography block, Read More block, and plenty of other exciting updates!</li><li><a href=\"https://make.wordpress.org/core/2022/02/03/whats-new-in-gutenberg-12-5-february-2nd/\">Gutenberg 12.5 </a>was released on February 2, 2022. This version allows switching theme styles variations, custom taxonomies filtering, and more.</li></ul>\n\n\n\n<div class=\"wp-container-24 wp-block-buttons\">\n<div class=\"wp-block-button aligncenter\"><a class=\"wp-block-button__link\" href=\"https://make.wordpress.org/chat/\" target=\"_blank\" rel=\"noreferrer noopener\"><strong>Want to get involved in developing Gutenberg? </strong>Contribute to Gutenberg on GitHub, and join the #core-editor channel in the Make WordPress Slack. Follow the #gutenberg-new tag for details on the latest updates.</a></div>\n</div>\n\n\n\n<h2>WordPress News gets a new look</h2>\n\n\n\n<p>The redesign of <a href=\"https://wordpress.org/news\">WordPress News</a>, which was first announced by Matt Mullenweg, Co-Founder of WordPress, in State of the Word 2021, went live on February 16, 2022.</p>\n\n\n\n<div class=\"wp-container-25 wp-block-buttons\">\n<div class=\"wp-block-button aligncenter\"><a class=\"wp-block-button__link\" href=\"https://wordpress.org/news/2022/02/a-new-wordpress-news/\" target=\"_blank\" rel=\"noreferrer noopener\"><strong>Read the redesign announcement </strong>to learn more about the inspiration behind the new look.</a></div>\n</div>\n\n\n\n<h2>Team updates: #WP Diversity, a new blog for developers, and more</h2>\n\n\n\n<ul><li>The #WPDiversity working group, which is part of the Community Team, hosted an open Zoom meeting with volunteers on February 23, 2022. If you’re interested in contributing, read the <a href=\"https://make.wordpress.org/community/2022/02/24/recap-of-the-diverse-speaker-training-group-wpdiversity-on-february-23-2022/\">recap of the meeting</a> to view available roles.&nbsp;</li><li>The Core Team shared a <a href=\"https://make.wordpress.org/core/2022/02/25/proposal-to-start-a-news-blog-on-developer-wordpress-org/\">proposal to start a blog</a> on developer.wordpress.org to share news and updates relevant to developers.&nbsp;</li><li>The first Gutenberg Developer Hours session hosted on February 8th by the Core Team was successful. Head over to <a href=\"https://make.wordpress.org/core/2022/02/24/february-8th-gutenberg-developer-hours-session-evaluation/\">this page</a> to learn more about the participants’ feedback.</li><li>The Core Team published “<a href=\"https://make.wordpress.org/core/2022/02/24/feature-project-plugin-dependencies/\">Feature Project: Plugin Dependencies</a>,” where they identified the problems with plugin dependencies and suggested potential solutions to improve the plugin experience.</li><li>The WordPress Photo Directory has a <a href=\"https://make.wordpress.org/photos/\">new Make team</a>. There is currently an open <a href=\"https://make.wordpress.org/photos/2022/02/23/photo-directory-team-rep-nominations-for-2022/\">call for team reps</a> and collaboration is happening at the new <a href=\"https://wordpress.slack.com/messages/photos/\">#photos</a> channel of the Make WordPress Slack.</li><li>The Polyglots Team shared a proposal for a <a href=\"https://make.wordpress.org/polyglots/2022/02/01/proposal-milestone-template-for-polyglots-locale-teams/\">milestone template </a>for the Polyglots Locale Teams.</li><li>The Community Team published a proposal for <a href=\"https://make.wordpress.org/community/2022/02/16/proposal-refurbishing-camera-kits/\">refurbishing camera kits</a>.</li><li>The <a href=\"https://make.wordpress.org/community/2022/02/21/2022-global-sponsors-announcement/\">Global Community Sponsors for 2022</a> have been announced.</li><li>The February 2022 edition of the monthly <a href=\"https://make.wordpress.org/community/2022/02/15/meetup-organizer-newsletter-february-2022/\">Meetup Organizer Newsletter</a> has been published.</li><li>The latest edition of People of WordPress highlighting <a href=\"https://wordpress.org/news/2022/02/people-of-wordpress-tonya-mork/\">Tonya Mork</a> was published on February 28, 2022. Read Tonya’s story to learn more about how WordPress helped her find herself again after a health crisis.&nbsp;</li><li>The February 2022 edition of the <a href=\"https://make.wordpress.org/polyglots/2022/02/22/polyglots-monthly-newsletter-february-2022/\">Polyglots Monthly Newsletter</a> has been published.</li></ul>\n\n\n\n<div class=\"wp-container-26 wp-block-buttons\">\n<div class=\"wp-block-button aligncenter\"><a class=\"wp-block-button__link\" href=\"\" target=\"_blank\" rel=\"noreferrer noopener\"><strong>The Community Team published a discussion on diversity in WordPress events.</strong> If you’re comfortable sharing your experience, you can still comment on the post.</a></div>\n</div>\n\n\n\n<h2>Feedback/Testing requests: WordPress iOS 19.3 and Android 19.3 </h2>\n\n\n\n<ul><li><a href=\"https://make.wordpress.org/mobile/2022/02/22/call-for-testing-wordpress-for-ios-19-3/\">WordPress for iOS 19.3</a> beta is available for testing, along with <a href=\"https://make.wordpress.org/mobile/2022/02/22/call-for-testing-wordpress-for-android-19-3/\">WordPress for Android 19.3</a></li></ul>\n\n\n\n<div class=\"wp-container-27 wp-block-buttons\">\n<div class=\"wp-block-button aligncenter\"><a class=\"wp-block-button__link\" href=\"https://make.wordpress.org/polyglots/2022/02/08/call-for-early-testers-glotpress-feedback-feature/\" target=\"_blank\" rel=\"noreferrer noopener\"><strong>Test and share your feedback</strong> on the GlotPress feedback feature.</a></div>\n</div>\n\n\n\n<h2>WordCamp Europe 2022 announces steps to ensure a diverse, inclusive, and welcoming event</h2>\n\n\n\n<ul><li>WordCamp Europe 2022 <a href=\"https://europe.wordcamp.org/2022/diversity-at-wceu/\">announced a plan</a> to ensure more diversity and inclusion in events moving forward.</li><li>The WordPress Foundation published a post on how <a href=\"https://wordpressfoundation.org/news/2022/open-source-software-good-for-business/\">open source software is good for business</a>.</li><li>In a recent episode of WP Briefing titled “<a href=\"https://wordpress.org/news/2022/02/episode-25-five-cents-on-five-for-the-future/\">Five Cents on Five for the Future</a>,” Executive Director Josepha Haden Chomphosy talks about future-proofing the WordPress project with the Five for the Future pledge.</li><li>The Training Team is hosting several WordPress Social Learning Meetups <a href=\"https://www.meetup.com/wordpress-social-learning/events/\">in March 2022</a>.</li><li>Don’t miss the following upcoming WordCamps:<ul><li><img src=\"https://s.w.org/images/core/emoji/14.0.0/72x72/1f1e8-1f1ed.png\" alt=\"🇨🇭\" class=\"wp-smiley\" style=\"height: 1em; max-height: 1em;\" /> <a href=\"https://geneve.wordcamp.org/2022/\">WordCamp Genève</a>, Switzerland on April 9, 2022 (in person)</li><li><img src=\"https://s.w.org/images/core/emoji/14.0.0/72x72/1f1ec-1f1f7.png\" alt=\"🇬🇷\" class=\"wp-smiley\" style=\"height: 1em; max-height: 1em;\" /> <a href=\"https://central.wordcamp.org/wordcamps/wordcamp-athens-attica-greece-2022/\">WordCamp Athens</a>, Greece between April 9 and 10, 2022 (in person)</li><li><img src=\"https://s.w.org/images/core/emoji/14.0.0/72x72/1f1e6-1f1f9.png\" alt=\"🇦🇹\" class=\"wp-smiley\" style=\"height: 1em; max-height: 1em;\" /> <a href=\"https://vienna.wordcamp.org/2022/\">WordCamp Vienna</a>, Austria from April 23 to 24, 2022 (in person)</li><li><img src=\"https://s.w.org/images/core/emoji/14.0.0/72x72/1f1ea-1f1fa.png\" alt=\"🇪🇺\" class=\"wp-smiley\" style=\"height: 1em; max-height: 1em;\" /> <a href=\"https://europe.wordcamp.org/2022/\">WordCamp Europe</a> in Porto, Portugal from June 2 to 4, 2022 (in person)</li><li><img src=\"https://s.w.org/images/core/emoji/14.0.0/72x72/1f1fa-1f1f8.png\" alt=\"🇺🇸\" class=\"wp-smiley\" style=\"height: 1em; max-height: 1em;\" /> <a href=\"https://montclair.wordcamp.org/2022/\">WordCamp Montclair</a> in New Jersey, USA June 25 (in person)</li><li><img src=\"https://s.w.org/images/core/emoji/14.0.0/72x72/1f1fa-1f1f8.png\" alt=\"🇺🇸\" class=\"wp-smiley\" style=\"height: 1em; max-height: 1em;\" /> <a href=\"https://us.wordcamp.org/2022/\">WordCamp US</a> in San Diego, California from September 9 to 11, 2022 (in person)</li></ul></li></ul>\n\n\n\n<div class=\"wp-container-28 wp-block-buttons\">\n<div class=\"wp-block-button aligncenter\"><a class=\"wp-block-button__link\" href=\"https://europe.wordcamp.org/2022/call-for-volunteers/\" target=\"_blank\" rel=\"noreferrer noopener\"><strong>It’s not too late to be a volunteer at WordCamp Europe 2022. </strong>If you’re interested, head over to this page to apply.</a></div>\n</div>\n\n\n\n<hr class=\"wp-block-separator\" />\n\n\n\n<p><strong><em>Have a story that we could include in the next ‘Month in WordPress’ post? Let us know by filling out </em></strong><a href=\"https://make.wordpress.org/community/month-in-wordpress-submissions/\"><strong><em>this form</em></strong></a><strong><em>.</em></strong></p>\n\n\n\n<p><em>The following folks contributed to this Month in WordPress: </em><a href=\'https://profiles.wordpress.org/anjanavasan/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>anjanavasan</a><em> </em><a href=\'https://profiles.wordpress.org/harishanker/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>harishanker</a><em> </em><a href=\'https://profiles.wordpress.org/rmartinezduque/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>rmartinezduque</a> <a href=\'https://profiles.wordpress.org/mysweetcate/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>mysweetcate</a></p>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:30:\"com-wordpress:feed-additions:1\";a:1:{s:7:\"post-id\";a:1:{i:0;a:5:{s:4:\"data\";s:5:\"12411\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:26;a:6:{s:4:\"data\";s:78:\"\n		\n		\n		\n		\n		\n				\n		\n		\n		\n		\n		\n		\n		\n		\n\n					\n										\n					\n		\n		\n			\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:4:{s:0:\"\";a:6:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"People of WordPress: Tonya Mork\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:66:\"https://wordpress.org/news/2022/02/people-of-wordpress-tonya-mork/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Mon, 28 Feb 2022 23:55:13 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:8:{i:0;a:5:{s:4:\"data\";s:9:\"Community\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:1;a:5:{s:4:\"data\";s:8:\"Features\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:2;a:5:{s:4:\"data\";s:10:\"Interviews\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:3;a:5:{s:4:\"data\";s:3:\"5.9\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:4;a:5:{s:4:\"data\";s:4:\"core\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:5;a:5:{s:4:\"data\";s:9:\"HeroPress\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:6;a:5:{s:4:\"data\";s:19:\"People of WordPress\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:7;a:5:{s:4:\"data\";s:9:\"Test Team\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:35:\"https://wordpress.org/news/?p=12151\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:98:\"The People of WordPress feature this month shares the story of engineer and developer Tonya Mork. \";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:28:\"webcommsat AbhaNonStopNewsUK\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:14216:\"\n<p><strong>In this series, we share some of the inspiring stories of how WordPress and its global network of contributors can change people’s lives for the better. This month we feature a website developer and engineer from the US, who found the software and its community provide the impetus to keep her going forward.</strong></p>\n\n\n\n<p>WordPress gave Tonya Mork a new lease of energy after a health crisis from which she nearly died. She had spent two decades as an electrical and software engineer in high tech automated manufacturing. But when she discovered the WordPress software, teaching it to others became her new purpose. Through this discovery, she has gone on to help thousands of developers understand and build code in great depth.</p>\n\n\n\n<p>As part of her WordPress journey, she has shared her skills in the roles of Release Coordinator and the Core Tech Editor for the most recent major WordPress release, <a href=\"https://make.wordpress.org/core/5-9/\">5.9</a> Joséphine.&nbsp;</p>\n\n\n\n<div class=\"wp-block-image\"><figure class=\"aligncenter size-large\"><img decoding=\"async\" loading=\"lazy\" width=\"1024\" height=\"515\" src=\"https://i0.wp.com/wordpress.org/news/files/2022/02/featured-img-tonyamork.jpg?resize=1024%2C515&#038;ssl=1\" alt=\"Tonya pictured in her work room\" class=\"wp-image-12326\" srcset=\"https://i0.wp.com/wordpress.org/news/files/2022/02/featured-img-tonyamork.jpg?resize=1024%2C515&amp;ssl=1 1024w, https://i0.wp.com/wordpress.org/news/files/2022/02/featured-img-tonyamork.jpg?resize=300%2C151&amp;ssl=1 300w, https://i0.wp.com/wordpress.org/news/files/2022/02/featured-img-tonyamork.jpg?resize=768%2C386&amp;ssl=1 768w, https://i0.wp.com/wordpress.org/news/files/2022/02/featured-img-tonyamork.jpg?w=1247&amp;ssl=1 1247w\" sizes=\"(max-width: 1000px) 100vw, 1000px\" data-recalc-dims=\"1\" /></figure></div>\n\n\n\n<h2 id=\"life-takes-an-unexpected-turn\">Life takes an unexpected turn</h2>\n\n\n\n<p>For the first 22 years of Tonya’s life, she rose through the ranks from enlisted personnel in the US Navy to a highly sought after chief engineer with a multi million-dollar industrial automation engineering firm.  </p>\n\n\n\n<p>However, while she was working in engineering, her life was to change dramatically. In 2007, Tonya started to face health challenges that had an impact on all that she had known.</p>\n\n\n\n<blockquote class=\"wp-block-quote\"><p><strong>“My career defined me. It was my canvas and my art. When it was gone, I did not recognize myself.</strong></p><cite>Tonya Mork</cite></blockquote>\n\n\n\n<p>One day, she woke up at home ready to visit a client’s facility where her firm was building a robotic system. She said: “As I headed for the door, I fell to my knees, as this wave of pain crushed down on my chest.”</p>\n\n\n\n<p>Doctors diagnosed her with a very rare heart disease that caused her blood vessels to spasm, cutting off blood to whatever was downstream of the blockage. </p>\n\n\n\n<p>A few months later, she was diagnosed with a second rare and more serious condition, related to the migraines from which she had been suffering. Combined with her heart condition, this made every migraine attack life-threatening.</p>\n\n\n\n<p>For nearly seven years, the unexpected changes to her health left her mostly homebound and constantly monitored. This meant she had to close her engineering firm and say goodbye to staff and clients. </p>\n\n\n\n<p>“My career defined me. It was my canvas and my art. When it was gone, I was lost. I didn’t recognize myself.”</p>\n\n\n\n<p>But in her darkest hour, she found her strength. Tonya made a choice to move forward, and make the most of her life.</p>\n\n\n\n<p>“When you are at rock bottom, you have to make a decision or else it will consume you. My decision was that I chose to be happy,” said Tonya.</p>\n\n\n\n<p>One of Tonya’s first steps was to start writing a blog using WordPress. In this she shared insights on how to find peace and joy in any situation. She wrote about kindness and helping one another.&nbsp;</p>\n\n\n\n<p>The joy of making solutions through WordPress became a way for Tonya to accept her new life and not feel as limited by her health. She wanted purpose, and in WordPress, she found just that.</p>\n\n\n\n<p>Tonya felt she could do something worthwhile in the virtual world.&nbsp;</p>\n\n\n\n<h2 id=\"a-ray-of-hope-for-tonya\">A ray of hope for Tonya</h2>\n\n\n\n<div class=\"wp-block-image\"><figure class=\"aligncenter size-full\"><img decoding=\"async\" loading=\"lazy\" width=\"1000\" height=\"750\" src=\"https://i1.wp.com/wordpress.org/news/files/2022/02/tonya.jpg?resize=1000%2C750&#038;ssl=1\" alt=\"\" class=\"wp-image-12327\" srcset=\"https://i1.wp.com/wordpress.org/news/files/2022/02/tonya.jpg?w=1000&amp;ssl=1 1000w, https://i1.wp.com/wordpress.org/news/files/2022/02/tonya.jpg?resize=300%2C225&amp;ssl=1 300w, https://i1.wp.com/wordpress.org/news/files/2022/02/tonya.jpg?resize=768%2C576&amp;ssl=1 768w\" sizes=\"(max-width: 1000px) 100vw, 1000px\" data-recalc-dims=\"1\" /></figure></div>\n\n\n\n<p>In 2013, Tonya’s health deteriorated further. She was admitted into intensive care and was diagnosed with a third rare disease, this time related to her autoimmunity. She was not expected to survive this time. </p>\n\n\n\n<p>Following what she describes as a ‘miraculous recovery,’ she became stronger and was able to stop relying on a wheelchair. She used the energy from working on websites to keep going. “WordPress kept my mind alive,” said Tonya.</p>\n\n\n\n<p>She had first used WordPress for her engineering firm’s intranet. But when she discovered the software’s full potential and the collaborative opportunities of open source, it opened a new world.&nbsp;</p>\n\n\n\n<figure class=\"wp-block-pullquote\"><blockquote><p>&#8220;Finding WordPress helped me to find myself again&#8221;</p><cite>Tonya Mork</cite></blockquote></figure>\n\n\n\n<p>During the years which followed, she donated her time to build some WordPress websites and plugins. She said: “Through giving my time, I was able to do something other than sit in isolation.” </p>\n\n\n\n<p>Tonya was amazed by the sharing in open source in general and in WordPress in particular. She said: “I was amazed to see people sharing so much information freely with one another. In my former engineering world, information was proprietary. Throughout my career, I had worked to break down those silos and help anyone to understand complex systems. I was drawn to this open community.”&nbsp;</p>\n\n\n\n<p>She also became aware that WordPress developers were hungry to learn more about development. She wanted to be part of the solution with her passion for teaching and the knowledge she had gained in industry.<br><br>She said: “Finding WordPress helped me to find myself again. Here in this community, I was able to feel like a person again, not a sick one, but a professional with something to give.”</p>\n\n\n\n<p>As her interest in the software grew, Tonya decided to start a non-profit where she turned to WordPress to build the websites. This re-sparked her interest in programming. She said: “I wanted to really know the code and understand what made it tick.”</p>\n\n\n\n<p>The realization led Tonya to start the WP Developers’ Club, which in turn spawned <a href=\"https://knowthecode.io/\">Know the Code</a>, to help educate individual developers, and is still used today.</p>\n\n\n\n<h2 id=\"from-helping-wordpress-companies-to-working-on-wordpress-core\">From helping WordPress companies to working on WordPress Core</h2>\n\n\n\n<div class=\"wp-block-image\"><figure class=\"aligncenter size-full\"><img decoding=\"async\" loading=\"lazy\" width=\"300\" height=\"300\" src=\"https://i0.wp.com/wordpress.org/news/files/2022/02/tonya-with-dog.jpg?resize=300%2C300&#038;ssl=1\" alt=\"Tonya pictured with her dog\" class=\"wp-image-12328\" srcset=\"https://i0.wp.com/wordpress.org/news/files/2022/02/tonya-with-dog.jpg?w=300&amp;ssl=1 300w, https://i0.wp.com/wordpress.org/news/files/2022/02/tonya-with-dog.jpg?resize=150%2C150&amp;ssl=1 150w\" sizes=\"(max-width: 300px) 100vw, 300px\" data-recalc-dims=\"1\" /></figure></div>\n\n\n\n<p>Tonya went on to work with big and medium size WordPress companies helping their developers and supporting them in raising their firms’ leverage with WordPress.</p>\n\n\n\n<p>By late 2020, she knew she wanted to do even more with WordPress.</p>\n\n\n\n<p>In February 2021, Tonya joined an international firm in the ecosystem and began working closely on WordPress Core.</p>\n\n\n\n<p>At that time, WordPress Core was pulling together a new Triage team. Tonya started volunteering on that team to find collaborative solutions, and help others do so. In 2020 for <a href=\"https://wordpress.org/news/2020/12/simone/\">WordPress 5.6 Simone</a>, she became the release’s Triage lead, and again for <a href=\"https://make.wordpress.org/core/5-7/\">WordPress 5.7 Esperanza</a>.&nbsp;</p>\n\n\n\n<p>In 2021, she became a Test Team Rep and helped to expand the team and is an advocate for the value of testing and feedback in the release development process.</p>\n\n\n\n<h2 id=\"a-new-successful-chapter-with-wordpress-5-9\">A new, successful chapter with WordPress 5.9</h2>\n\n\n\n<div class=\"wp-block-image\"><figure class=\"aligncenter size-large\"><img decoding=\"async\" loading=\"lazy\" width=\"1024\" height=\"480\" src=\"https://i1.wp.com/wordpress.org/news/files/2022/02/WP59-thumbnail-jb.png?resize=1024%2C480&#038;ssl=1\" alt=\"Tonya was one of the notable contributors to the WordPress 5.9 release featured in this picture.\" class=\"wp-image-12329\" srcset=\"https://i1.wp.com/wordpress.org/news/files/2022/02/WP59-thumbnail-jb.png?resize=1024%2C480&amp;ssl=1 1024w, https://i1.wp.com/wordpress.org/news/files/2022/02/WP59-thumbnail-jb.png?resize=300%2C141&amp;ssl=1 300w, https://i1.wp.com/wordpress.org/news/files/2022/02/WP59-thumbnail-jb.png?resize=768%2C360&amp;ssl=1 768w, https://i1.wp.com/wordpress.org/news/files/2022/02/WP59-thumbnail-jb.png?resize=1536%2C719&amp;ssl=1 1536w, https://i1.wp.com/wordpress.org/news/files/2022/02/WP59-thumbnail-jb.png?resize=2048%2C959&amp;ssl=1 2048w\" sizes=\"(max-width: 1000px) 100vw, 1000px\" data-recalc-dims=\"1\" /></figure></div>\n\n\n\n<p>Tonya’s passion for the software and getting people involved in its growth continued. For the WordPress 5.9 release in 2021, she took on the role of both the Core Tech Lead and the Release Coordinator. As this was a big release and included the first major implementation of Full Site Editing, it had many moving parts and hundreds of contributors. She was able to share the skills she had learned in communication and project management from her days streamlining and documenting engineering software and processes.&nbsp;</p>\n\n\n\n<p>In the first 24 hours of WordPress 5.9 landing, it had more than 10 million downloads—and 17 formally reported bugs.</p>\n\n\n\n<h2 id=\"giving-back-to-open-source\">Giving back to open source</h2>\n\n\n\n<p>Now in what Tonya describes as her third chapter. She said: “I’m a very different person from the engineer I used to know. What really matters in this world is when you reach out and make a difference in someone’s life.”</p>\n\n\n\n<p>She feels she has found her purpose in this life. “I’m on a mission to give back and make a difference. Teaching is how I will do it. And in WordPress I have found my professional home, and I have all this software knowledge that I just want to share.”</p>\n\n\n\n<h2 id=\"share-the-stories\">Share the stories</h2>\n\n\n\n<p>Help share these stories of open source contributors and continue to grow the community. Meet more WordPressers in the <a href=\"https://wordpress.org/news/category/newsletter/interviews/\">People of WordPress series</a>.</p>\n\n\n\n<h2 id=\"contributors-to-this-feature\">Contributors to this feature</h2>\n\n\n\n<p>Thank you to Tonya Mork (<a href=\'https://profiles.wordpress.org/hellofromtonya/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>hellofromtonya</a>) for sharing her story. </p>\n\n\n\n<p>Interviews and feature by Abha Thakor (<a href=\'https://profiles.wordpress.org/webcommsat/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>webcommsat</a>) and Mary Baum (<a href=\'https://profiles.wordpress.org/marybaum/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>marybaum</a>). Reviewed by Chloe Bringmann (<a href=\'https://profiles.wordpress.org/cbringmann/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>cbringmann</a>), Nalini Thakor (<a href=\'https://profiles.wordpress.org/nalininonstopnewsuk/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>nalininonstopnewsuk</a>), Meher Bala (<a href=\'https://profiles.wordpress.org/meher/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>meher</a>), and Anjana Vasan (<a href=\'https://profiles.wordpress.org/anjanavasan/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>anjanavasan</a>). Photo editing Reyez Martínez (<a href=\'https://profiles.wordpress.org/rmartinezduque/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>rmartinezduque</a>) and Jean Baptiste Audras (<a href=\'https://profiles.wordpress.org/audrasjb/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>audrasjb</a>). </p>\n\n\n\n<p><em>Thanks to Josepha Haden Chomphosy&nbsp;(@<a href=\"https://profiles.wordpress.org/chanthaboune/\">chanthaboune</a>) and Topher DeRosia (<a href=\"https://profiles.wordpress.org/topher1kenobe/\">@topher1kenobe</a>) and others for their support&nbsp;</em>of this initiative.</p>\n\n\n\n<div class=\"wp-block-media-text is-stacked-on-mobile is-vertically-aligned-center\" style=\"grid-template-columns:29% auto\"><figure class=\"wp-block-media-text__media\"><img decoding=\"async\" loading=\"lazy\" width=\"180\" height=\"135\" src=\"https://i1.wp.com/wordpress.org/news/files/2020/03/heropress_logo_180.png?resize=180%2C135&#038;ssl=1\" alt=\"HeroPress logo\" class=\"wp-image-8409 size-full\" data-recalc-dims=\"1\" /></figure><div class=\"wp-block-media-text__content\">\n<p class=\"has-small-font-size\"><em>This People of WordPress feature is inspired by an essay originally published on </em><a href=\"https://heropress.com/\"><em>HeroPress.com</em></a><em>, a community initiative created by Topher DeRosia. It highlights people in the WordPress community who have overcome barriers and whose stories might otherwise go unheard. </em>#HeroPress </p>\n</div></div>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:30:\"com-wordpress:feed-additions:1\";a:1:{s:7:\"post-id\";a:1:{i:0;a:5:{s:4:\"data\";s:5:\"12151\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:27;a:6:{s:4:\"data\";s:57:\"\n		\n		\n		\n		\n		\n				\n		\n\n					\n										\n					\n		\n		\n			\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:4:{s:0:\"\";a:6:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:35:\"WordPress 5.9.1 Maintenance Release\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:71:\"https://wordpress.org/news/2022/02/wordpress-5-9-1-maintenance-release/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Tue, 22 Feb 2022 15:49:40 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:1:{i:0;a:5:{s:4:\"data\";s:8:\"Releases\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:35:\"https://wordpress.org/news/?p=12266\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:33:\"WordPress 5.9.1 is now available!\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:9:\"Jb Audras\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:7802:\"\n<p>WordPress 5.9.1 is now available!</p>\n\n\n\n<p>This maintenance release features&nbsp;82 bug fixes in both Core and the block editor.</p>\n\n\n\n<p>WordPress 5.9.1 is a short-cycle maintenance release. The next major release will be version&nbsp;<a href=\"https://make.wordpress.org/core/6.0/\">6.0</a>.</p>\n\n\n\n<p>You can <a href=\"https://wordpress.org/wordpress-5.9.1.zip\">download WordPress 5.9.1 from WordPress.org</a>, or visit your Dashboard&nbsp;→ Updates and click &#8220;Update Now&#8221;.</p>\n\n\n\n<p>If you have sites that support automatic background updates, they’ve already started the update process.</p>\n\n\n\n<p>For more information, browse the <a href=\"https://make.wordpress.org/core/2022/02/16/wordpress-5-9-1-rc-1/\">full list of both Trac and GitHub changes in the release candidate post</a>, or check out the&nbsp;<a href=\"https://wordpress.org/support/wordpress-version/version-5-9-1/\">version 5.9.1 HelpHub documentation page</a>.</p>\n\n\n\n<h2 id=\"thanks-and-props\">Thanks and props!</h2>\n\n\n\n<p>The 5.9.1 release was led by&nbsp;<a href=\"https://profiles.wordpress.org/audrasjb/\">Jb Audras</a>&nbsp;and&nbsp;<a href=\"https://profiles.wordpress.org/mamaduka/\">George Mamadashvili</a>.</p>\n\n\n\n<p>Special props to <a href=\'https://profiles.wordpress.org/sergeybiryukov/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>sergeybiryukov</a> for running mission control.</p>\n\n\n\n<p>Thank you to everyone who helped make WordPress 5.9.1 happen:</p>\n\n\n\n<p class=\"is-style-wporg-props-medium alignfull\"><a href=\"https://profiles.wordpress.org/aljullu/\">Albert Juhé Lluveras</a>, <a href=\"https://profiles.wordpress.org/ajlende/\">Alex Lende</a>, <a href=\"https://profiles.wordpress.org/alexstine/\">alexstine</a>, <a href=\"https://profiles.wordpress.org/oandregal/\">André</a>, <a href=\"https://profiles.wordpress.org/antonvlasenko/\">Anton Vlasenko</a>, <a href=\"https://profiles.wordpress.org/aristath/\">Ari Stathopoulos</a>, <a href=\"https://profiles.wordpress.org/madeinua/\">ArteMa</a>, <a href=\"https://profiles.wordpress.org/scruffian/\">Ben Dwyer</a>, <a href=\"https://profiles.wordpress.org/blogaid/\">BlogAid</a>, <a href=\"https://profiles.wordpress.org/poena/\">Carolina Nymark</a>, <a href=\"https://profiles.wordpress.org/critterverse/\">Channing Ritter</a>, <a href=\"https://profiles.wordpress.org/chrisvanpatten/\">Chris Van Patten</a>, <a href=\"https://profiles.wordpress.org/costdev/\">Colin Stewart</a>, <a href=\"https://profiles.wordpress.org/talldanwp/\">Daniel Richards</a>, <a href=\"https://profiles.wordpress.org/davidbinda/\">David Biňovec</a>, <a href=\"https://profiles.wordpress.org/get_dave/\">David Smith</a>, <a href=\"https://profiles.wordpress.org/dd32/\">Dion Hulse</a>, <a href=\"https://profiles.wordpress.org/ocean90/\">Dominik Schilling</a>, <a href=\"https://profiles.wordpress.org/eddystile/\">Eddy</a>, <a href=\"https://profiles.wordpress.org/ellatrix/\">Ella van Durpe</a>, <a href=\"https://profiles.wordpress.org/kebbet/\">Erik</a>, <a href=\"https://profiles.wordpress.org/fabiankaegy/\">Fabian Kägy</a>, <a href=\"https://profiles.wordpress.org/azouamauriac/\">Flinim Asso</a>, <a href=\"https://profiles.wordpress.org/gadhiyaravi/\">gadhiyaravi</a>, <a href=\"https://profiles.wordpress.org/revgeorge/\">George Hotelling</a>, <a href=\"https://profiles.wordpress.org/mamaduka/\">George Mamadashvili</a>, <a href=\"https://profiles.wordpress.org/glendaviesnz/\">glendaviesnz</a>, <a href=\"https://profiles.wordpress.org/gziolo/\">Greg Ziółkowski</a>, <a href=\"https://profiles.wordpress.org/ianatkins/\">ianatkins</a>, <a href=\"https://profiles.wordpress.org/ianbelanger/\">Ian Belanger</a>, <a href=\"https://profiles.wordpress.org/ironprogrammer/\">ironprogrammer</a>, <a href=\"https://profiles.wordpress.org/itsamoreh/\">itsamoreh</a>, <a href=\"https://profiles.wordpress.org/audrasjb/\">Jb Audras</a>, <a href=\"https://profiles.wordpress.org/jffng/\">Jeff Ong</a>, <a href=\"https://profiles.wordpress.org/jeherve/\">Jeremy Herve</a>, <a href=\"https://profiles.wordpress.org/joedolson/\">Joe Dolson</a>, <a href=\"https://profiles.wordpress.org/joen/\">Joen A.</a>, <a href=\"https://profiles.wordpress.org/johnbillion/\">John Blackbourn</a>, <a href=\"https://profiles.wordpress.org/desrosj/\">Jonathan Desrosiers</a>, <a href=\"https://profiles.wordpress.org/jorgefilipecosta/\">Jorge Costa</a>, <a href=\"https://profiles.wordpress.org/jrf/\">Juliette Reinders Folmer</a>, <a href=\"https://profiles.wordpress.org/kafleg/\">KafleG</a>, <a href=\"https://profiles.wordpress.org/kapilpaul/\">Kapil Paul</a>, <a href=\"https://profiles.wordpress.org/kjellr/\">Kjell Reigstad</a>, <a href=\"https://profiles.wordpress.org/linux4me2/\">linux4me2</a>, <a href=\"https://profiles.wordpress.org/pyrobd/\">Lukman Nakib</a>, <a href=\"https://profiles.wordpress.org/manfcarlo/\">manfcarlo</a>, <a href=\"https://profiles.wordpress.org/clorith/\">Marius L. J.</a>, <a href=\"https://profiles.wordpress.org/mgol/\">mgol</a>, <a href=\"https://profiles.wordpress.org/nidhidhandhukiya/\">nidhidhandhukiya</a>, <a href=\"https://profiles.wordpress.org/ntsekouras/\">Nik Tsekouras</a>, <a href=\"https://profiles.wordpress.org/alshakero/\">Omar Alshaker</a>, <a href=\"https://profiles.wordpress.org/pls78/\">Paolo L. Scala</a>, <a href=\"https://profiles.wordpress.org/swissspidy/\">Pascal Birchler</a>, <a href=\"https://profiles.wordpress.org/pbearne/\">Paul Bearne</a>, <a href=\"https://profiles.wordpress.org/malinevskiy/\">Pavlo</a>, <a href=\"https://profiles.wordpress.org/petaryoast/\">Petar Ratković</a>, <a href=\"https://profiles.wordpress.org/peterwilsoncc/\">Peter Wilson</a>, <a href=\"https://profiles.wordpress.org/walbo/\">Petter Walbø Johnsgård</a>, <a href=\"https://profiles.wordpress.org/johnstonphilip/\">Phil Johnston</a>, <a href=\"https://profiles.wordpress.org/boniu91/\">Piotrek Boniu</a>, <a href=\"https://profiles.wordpress.org/ravipatel/\">ravipatel</a>, <a href=\"https://profiles.wordpress.org/youknowriad/\">Riad Benguella</a>, <a href=\"https://profiles.wordpress.org/noisysocks/\">Robert Anderson</a>, <a href=\"https://profiles.wordpress.org/rolfsiebers/\">Rolf Siebers</a>, <a href=\"https://profiles.wordpress.org/sergeybiryukov/\">Sergey Biryukov</a>, <a href=\"https://profiles.wordpress.org/stacimc/\">stacimc</a>, <a href=\"https://profiles.wordpress.org/sabernhardt/\">Stephen Bernhardt</a>, <a href=\"https://profiles.wordpress.org/mahype/\">Sven Wagener</a>, <a href=\"https://profiles.wordpress.org/staatic/\">Team Staatic</a>, <a href=\"https://profiles.wordpress.org/tnolte/\">Tim Nolte</a>, <a href=\"https://profiles.wordpress.org/hellofromtonya/\">Tonya Mork</a>, <a href=\"https://profiles.wordpress.org/webcommsat/\">webcommsat AbhaNonStopNewsUK</a>, <a href=\"https://profiles.wordpress.org/webmandesign/\">WebMan Design | Oliver Juhas</a>, <a href=\"https://profiles.wordpress.org/antonynz/\">wpcharged</a>, <a href=\"https://profiles.wordpress.org/wpsoul/\">wpsoul</a>, <a href=\"https://profiles.wordpress.org/dolphingg/\">Yunus Ertuğrul</a>, and <a href=\"https://profiles.wordpress.org/rafiahmedd/\">Rafi Ahmed</a>.</p>\n\n\n\n<p>Thanks to <a href=\'https://profiles.wordpress.org/estelaris/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>estelaris</a>, <a href=\'https://profiles.wordpress.org/pbiron/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>pbiron</a>, <a href=\'https://profiles.wordpress.org/ironprogrammer/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>ironprogrammer</a>, <a href=\'https://profiles.wordpress.org/bph/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>bph</a>, <a href=\'https://profiles.wordpress.org/abhanonstopnewsuk/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>abhanonstopnewsuk</a> and <a href=\'https://profiles.wordpress.org/threadi/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>threadi</a> for their help to test the release package.</p>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:30:\"com-wordpress:feed-additions:1\";a:1:{s:7:\"post-id\";a:1:{i:0;a:5:{s:4:\"data\";s:5:\"12266\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:28;a:6:{s:4:\"data\";s:61:\"\n		\n		\n		\n		\n		\n				\n		\n		\n\n					\n										\n					\n		\n		\n\n			\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:4:{s:0:\"\";a:7:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:58:\"WP Briefing: Episode 25: Five Cents on Five for the Future\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:80:\"https://wordpress.org/news/2022/02/episode-25-five-cents-on-five-for-the-future/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Mon, 21 Feb 2022 12:00:00 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:2:{i:0;a:5:{s:4:\"data\";s:7:\"Podcast\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:1;a:5:{s:4:\"data\";s:11:\"wp-briefing\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:53:\"https://wordpress.org/news/?post_type=podcast&p=12288\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:450:\"In this twenty-fifth episode of the WordPress Briefing, Executive Director, Josepha Haden Chomphosy discusses future-proofing the WordPress project with the Five for the Future pledge. Have a question you&#8217;d like answered? You can submit them to wpbriefing@wordpress.org, either written or as a voice recording. Credits Editor:&#160;Dustin Hartzler Logo:&#160;Beatriz Fialho Production:&#160;Chloé Bringmann &#38; Santana Inniss Song: [&#8230;]\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:9:\"enclosure\";a:1:{i:0;a:5:{s:4:\"data\";s:0:\"\";s:7:\"attribs\";a:1:{s:0:\"\";a:3:{s:3:\"url\";s:60:\"https://wordpress.org/news/files/2022/02/WP-Briefing-025.mp3\";s:6:\"length\";s:1:\"0\";s:4:\"type\";s:0:\"\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:15:\"Chloe Bringmann\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:10286:\"\n<p>In this twenty-fifth episode of the WordPress Briefing, Executive Director, Josepha Haden Chomphosy discusses future-proofing the WordPress project with the Five for the Future pledge. </p>\n\n\n\n<p><em><strong>Have a question you&#8217;d like answered? You can submit them to <a href=\"mailto:wpbriefing@wordpress.org\">wpbriefing@wordpress.org</a>, either written or as a voice recording.</strong></em></p>\n\n\n\n<h2 id=\"credits\">Credits</h2>\n\n\n\n<ul><li>Editor:&nbsp;<a href=\"https://profiles.wordpress.org/dustinhartzler/\">Dustin Hartzler</a></li><li>Logo:&nbsp;<a href=\"https://profiles.wordpress.org/beafialho/\">Beatriz Fialho</a></li><li>Production:&nbsp;<a href=\"https://profiles.wordpress.org/cbringmann/\">Chloé Bringmann</a> &amp; <a href=\"https://profiles.wordpress.org/santanainniss/\">Santana Inniss</a></li><li>Song: Fearless First by Kevin MacLeod</li></ul>\n\n\n\n<h2 id=\"references\">References</h2>\n\n\n\n<ul><li><a href=\"https://ma.tt/2014/09/five-for-the-future/\">Five for the Future</a>, on ma.tt circa 2014</li><li><a href=\"https://www.cambridge.org/core/books/governing-the-commons/A8BB63BC4A1433A50A3FB92EDBBB97D5\">Governing the Commons</a>, Elinor Ostrom</li><li><a href=\"https://wordpress.org/five-for-the-future/files/2022/01/WP-Sponsored-Contributor-Team-White-Paper-Google-Docs.pdf\">Five for the Future White Paper</a></li><li><a href=\"https://make.wordpress.org/core/2022/02/16/wordpress-6-0-planning-roundup/\">6.0 Planning Roundup</a></li><li><a href=\"https://learn.wordpress.org/course/simple-site-design-with-full-site-editing/\">Part I: Full Site Editing Course</a></li><li><a href=\"https://learn.wordpress.org/course/part-2-personalized-site-design-with-full-site-editing-and-theme-blocks/\">Part II: Full Site Editing Course</a></li><li><a href=\"https://learn.wordpress.org/course/part-3-advanced-site-design-with-full-site-editing-site-editor-templates-and-template-parts/\">Part III: Full Site Eiditing Course</a></li></ul>\n\n\n\n<h2 id=\"transcript\">Transcript</h2>\n\n\n\n<span id=\"more-12288\"></span>\n\n\n\n<p>Episode 25</p>\n\n\n\n<p><strong>Josepha Haden Chomphosy [00:00:00]&nbsp;</strong></p>\n\n\n\n<p>Hello everyone, and welcome to the WordPress Briefing. The podcast where you can catch quick explanations of the ideas behind the WordPress open source project. Some insight into the community that supports it and get a small list of big things coming up in the next two weeks. I&#8217;m your host, Josepha Haden Chomphosy &#8211; here we go!</p>\n\n\n\n<p><strong>Josepha Haden Chomphosy [00:00:42]&nbsp;</strong></p>\n\n\n\n<p>I have a non-mailbag mailbag question that I would like to answer for y&#8217;all today. Non-mailbag because no one actually emailed me about it and mailbag because Twitter is basically like a giant mailbag. And I do get a lot of DMS about this particular topic. If you want to send something to my actual WP Briefing mailbag, you can send it to <a href=\"mailto:wpbriefing@worpress.org\">wpbriefing@worpress.org</a>.&nbsp;</p>\n\n\n\n<p><strong>Josepha Haden Chomphosy [00:01:06]&nbsp;</strong></p>\n\n\n\n<p>But the question that I frequently get asked in my DMS on Twitter is: what is Five for the Future? It&#8217;s not always that tidy the question, but that still is the question we&#8217;re answering today. So if you take a casual survey of active contributors to the WordPress project, the high-level answer that you&#8217;re likely to get to that question is “a way to remind people to give back to the project.” Or, if you run in more business-y circles, you might hear that it is an initiative that encourages companies to give back 5% of their resources.&nbsp;</p>\n\n\n\n<p><strong>Josepha Haden Chomphosy [00:01:40]&nbsp;</strong></p>\n\n\n\n<p>And both of those answers are true. So a quick mini-history lesson; the original concept of Five for the Future came from Matt Mullenweg in 2014. There&#8217;s a lovely blog post on it that I will link in the notes below, but it was essentially a call to any companies experiencing success with WordPress to contribute back to the project and make sure that the project was a success.</p>\n\n\n\n<p><strong>Josepha Haden Chomphosy [00:02:07]&nbsp;</strong></p>\n\n\n\n<p>The initial program then included outreach recognition, et cetera, proposed in 2017 by <a href=\"https://wordpress.org/support/users/liljimmi/\">Tracy Levesque</a> and <a href=\"https://wordpress.org/support/users/iandunn/\">Ian Dunn</a>. Then that was defined and formalized with the help of the WordPress community in 2018. And then, in 2019, we had our first trial run with entire dedicated teams sponsored by companies inside the WordPress ecosystem.</p>\n\n\n\n<p><strong>Josepha Haden Chomphosy [00:02:36]&nbsp;</strong></p>\n\n\n\n<p>So that&#8217;s the mini-history lesson chronology of this program. The intentions that informed the work of building the program in 2017 have become a bit lost to the ages. So I&#8217;m here to share it with you. The basic heart and soul of the Five for the Future program is to make sure that there is a way to refresh the commons of the WordPress community and ecosystem.</p>\n\n\n\n<p><strong>Josepha Haden Chomphosy [00:03:00]&nbsp;</strong></p>\n\n\n\n<p>And as a result, ensure that the common resources of WordPress are available long after we have stopped being available to care for them. If you are familiar with the concept of the tragedy of the commons, Five for the Future was created to help avoid that tragedy. There were two original goals for formalizing the program.</p>\n\n\n\n<p><strong>Josepha Haden Chomphosy [00:03:22]&nbsp;</strong></p>\n\n\n\n<p>The first one was to acknowledge companies that participated in Five for the Future by sponsoring contributors to work on the WordPress project. And the second was to motivate more companies to sponsor more volunteers. Either by hiring them and paying them to contribute or by assigning their existing employees to contribute to the WordPress project.</p>\n\n\n\n<p><strong>Josepha Haden Chomphosy [00:03:46]&nbsp;</strong></p>\n\n\n\n<p>Of course, it&#8217;s hard to quantify participation and hard to qualify what should be seen as an impactful contribution, which is why when the program was originally created, it was in partnership with team reps and community members who were active at the time. There are many posts around that discuss the next steps for this program.</p>\n\n\n\n<p><strong>Josepha Haden Chomphosy [00:04:07]&nbsp;</strong></p>\n\n\n\n<p>And as I&#8217;m looking through them, the next steps revolve around some of the hardest and most important questions that we have to answer as a project and as stewards of open source. Those questions are things like:</p>\n\n\n\n<ul><li> How do we remain true to these gloriously subversive values of WordPress and open source while also finding a way to thoughtfully secure our organization&#8217;s future?</li><li>Does contributing without the expectation of reciprocity hold up when we are looking at how to acknowledge contributors who sustain us?</li></ul>\n\n\n\n<p><strong>Josepha Haden Chomphosy [00:04:40]&nbsp;</strong></p>\n\n\n\n<p>And if you&#8217;re familiar with Elinor Ostrom&#8217;s award-winning work, Governing the Commons, you may also be wondering how this particular program aligns with her eight principles designed to sustain organizations like ours.</p>\n\n\n\n<p><strong>Josepha Haden Chomphosy [00:04:57]&nbsp;</strong></p>\n\n\n\n<p>As an aside to that last question, this particular program does not have all eight principles accounted for, but among WordPress&#8217;s many programs, we do account for most of them. Although imperfectly, as is the way with human beings, that&#8217;s probably a whole episode unto itself, I did want to quickly answer that particular question.</p>\n\n\n\n<p><strong>Josepha Haden Chomphosy [00:05:16]&nbsp;</strong></p>\n\n\n\n<p>So to get back to my non-mailbag, mailbag question, if I had to tell you in the span of an elevator ride what Five for the Future was, this would be my answer. <strong>It is a v1 program with a dual goal of boldly declaring the need to refresh the shared resources of WordPress and offering the ways and means for communities and individuals alike to participate in refreshing those resources</strong>.</p>\n\n\n\n<p><strong>Josepha Haden Chomphosy [00:05:45]&nbsp;</strong></p>\n\n\n\n<p>If you want to learn more about the Five for the Future initiative, you can check out wordpress.org/5. Like literally just the number five. Or, if you want to learn more about the program that has grown from the Five for the Future initiative, you can check out the white paper that&#8217;s linked in the notes below.</p>\n\n\n\n<p><strong>Josepha Haden Chomphosy [00:06:11]&nbsp;</strong></p>\n\n\n\n<p>And that brings us now to our small list of big things. Number one on my small list, the planning post for WordPress 6.0 is out. I&#8217;ve included a link in my massive list of links below. But it includes our best guess at timing, features that we intend to include, and a call for volunteers as well. So if you are looking for ways to give back, that is a clear and immediate option.</p>\n\n\n\n<p><strong>Josepha Haden Chomphosy [00:06:38]&nbsp;</strong></p>\n\n\n\n<p>The second thing on the list is if you are a team rep, don&#8217;t forget that we have daylight saving time ending and starting depending on your hemisphere within the month. If you move meetings, if you&#8217;re in a team that moves your meetings, discuss it now so that folks have time to adjust their calendars.&nbsp;</p>\n\n\n\n<p><strong>Josepha Haden Chomphosy [00:06:55]&nbsp;</strong></p>\n\n\n\n<p>And the third thing on my small list of big things is that there&#8217;s a suite of Full Site Editing courses that are now available on learn.wordpress.org. I will add that to my giant list of links below, but I encourage you to wander on over and see what all the fuss is about. I think the courses are excellent. They&#8217;re great for folks who don&#8217;t quite know what Full Site Editing is yet, but then also they give you a few intermediate tips and tricks as you&#8217;re getting your legs underneath you.</p>\n\n\n\n<p><strong>Josepha Haden Chomphosy [00:07:27]&nbsp;</strong></p>\n\n\n\n<p>So, that my friends, is your small list of big things. Thank you for tuning in today for the WordPress Briefing. I&#8217;m your host, Josepha Haden Chomphosy. I&#8217;ll see you again in a couple of weeks.</p>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:30:\"com-wordpress:feed-additions:1\";a:1:{s:7:\"post-id\";a:1:{i:0;a:5:{s:4:\"data\";s:5:\"12288\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:29;a:6:{s:4:\"data\";s:63:\"\n		\n		\n		\n		\n		\n				\n		\n		\n		\n\n					\n										\n					\n		\n		\n			\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:4:{s:0:\"\";a:6:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:20:\"A New WordPress News\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:56:\"https://wordpress.org/news/2022/02/a-new-wordpress-news/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Wed, 16 Feb 2022 17:56:05 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:3:{i:0;a:5:{s:4:\"data\";s:6:\"Design\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:1;a:5:{s:4:\"data\";s:7:\"General\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:2;a:5:{s:4:\"data\";s:4:\"Meta\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:35:\"https://wordpress.org/news/?p=12244\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:385:\"In June 2021, @beafialho in collaboration with @pablohoney floated the idea of giving WordPress News a new look. Today, those ideas become a reality—we&#8217;re excited to share that redesign of WordPress News is live! The new design leans on the aesthetics of jazz, intrinsically connected to WordPress and which ultimately translates its uniqueness, historic significance [&#8230;]\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Kelly Hoffman\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:5795:\"\n<figure class=\"wp-block-image alignfull size-full\"><img decoding=\"async\" loading=\"lazy\" width=\"2560\" height=\"1605\" src=\"https://i1.wp.com/wordpress.org/news/files/2022/02/news_responsive_sizes-scaled.jpg?resize=2560%2C1605&#038;ssl=1\" alt=\"\" class=\"wp-image-12279\" srcset=\"https://i1.wp.com/wordpress.org/news/files/2022/02/news_responsive_sizes-scaled.jpg?w=2560&amp;ssl=1 2560w, https://i1.wp.com/wordpress.org/news/files/2022/02/news_responsive_sizes-scaled.jpg?resize=300%2C188&amp;ssl=1 300w, https://i1.wp.com/wordpress.org/news/files/2022/02/news_responsive_sizes-scaled.jpg?resize=1024%2C642&amp;ssl=1 1024w, https://i1.wp.com/wordpress.org/news/files/2022/02/news_responsive_sizes-scaled.jpg?resize=768%2C482&amp;ssl=1 768w, https://i1.wp.com/wordpress.org/news/files/2022/02/news_responsive_sizes-scaled.jpg?resize=1536%2C963&amp;ssl=1 1536w, https://i1.wp.com/wordpress.org/news/files/2022/02/news_responsive_sizes-scaled.jpg?resize=2048%2C1284&amp;ssl=1 2048w\" sizes=\"(max-width: 1000px) 100vw, 1000px\" data-recalc-dims=\"1\" /></figure>\n\n\n\n<p>In June 2021, <a href=\'https://profiles.wordpress.org/beafialho/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>beafialho</a> in collaboration with <a href=\'https://profiles.wordpress.org/pablohoney/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>pablohoney</a> <a href=\"https://make.wordpress.org/design/2021/06/03/redesign-of-wordpress-org-news/\">floated the idea</a> of giving WordPress News a new look. Today, those ideas become a reality—we&#8217;re excited to share that redesign of <a href=\"https://wordpress.org/news/\">WordPress News</a> is live!</p>\n\n\n\n<p>The new design leans on the aesthetics of jazz, intrinsically connected to WordPress and which ultimately translates its uniqueness, historic significance and future potential. Among other improvements, the new design leaves more space for content and includes new typefaces for better readability. It also uses a color palette intended to reflect the evolving Gutenberg language.</p>\n\n\n\n<figure class=\"wp-block-image size-full\"><img decoding=\"async\" loading=\"lazy\" width=\"2560\" height=\"1605\" src=\"https://i0.wp.com/wordpress.org/news/files/2022/02/news_postpages-scaled.jpg?resize=2560%2C1605&#038;ssl=1\" alt=\"\" class=\"wp-image-12260\" srcset=\"https://i0.wp.com/wordpress.org/news/files/2022/02/news_postpages-scaled.jpg?w=2560&amp;ssl=1 2560w, https://i0.wp.com/wordpress.org/news/files/2022/02/news_postpages-scaled.jpg?resize=300%2C188&amp;ssl=1 300w, https://i0.wp.com/wordpress.org/news/files/2022/02/news_postpages-scaled.jpg?resize=1024%2C642&amp;ssl=1 1024w, https://i0.wp.com/wordpress.org/news/files/2022/02/news_postpages-scaled.jpg?resize=768%2C482&amp;ssl=1 768w, https://i0.wp.com/wordpress.org/news/files/2022/02/news_postpages-scaled.jpg?resize=1536%2C963&amp;ssl=1 1536w, https://i0.wp.com/wordpress.org/news/files/2022/02/news_postpages-scaled.jpg?resize=2048%2C1284&amp;ssl=1 2048w\" sizes=\"(max-width: 1000px) 100vw, 1000px\" data-recalc-dims=\"1\" /></figure>\n\n\n\n<figure class=\"wp-block-image size-full\"><img decoding=\"async\" loading=\"lazy\" width=\"2560\" height=\"1605\" src=\"https://i2.wp.com/wordpress.org/news/files/2022/02/news_communitypodcast-scaled.jpg?resize=2560%2C1605&#038;ssl=1\" alt=\"\" class=\"wp-image-12262\" srcset=\"https://i2.wp.com/wordpress.org/news/files/2022/02/news_communitypodcast-scaled.jpg?w=2560&amp;ssl=1 2560w, https://i2.wp.com/wordpress.org/news/files/2022/02/news_communitypodcast-scaled.jpg?resize=300%2C188&amp;ssl=1 300w, https://i2.wp.com/wordpress.org/news/files/2022/02/news_communitypodcast-scaled.jpg?resize=1024%2C642&amp;ssl=1 1024w, https://i2.wp.com/wordpress.org/news/files/2022/02/news_communitypodcast-scaled.jpg?resize=768%2C482&amp;ssl=1 768w, https://i2.wp.com/wordpress.org/news/files/2022/02/news_communitypodcast-scaled.jpg?resize=1536%2C963&amp;ssl=1 1536w, https://i2.wp.com/wordpress.org/news/files/2022/02/news_communitypodcast-scaled.jpg?resize=2048%2C1284&amp;ssl=1 2048w\" sizes=\"(max-width: 1000px) 100vw, 1000px\" data-recalc-dims=\"1\" /></figure>\n\n\n\n<p>The revamp of the WordPress News page includes the header and footer of the page. We also shipped those two global elements to all pages of WordPress.org. However, there’s more work to do within the header to improve the information architecture. This new design is just the first, small step to modernize and improve the site iteratively. Any further discussion on future redesigns will occur in the <a href=\"http://wordpress.slack.com\">#design channel on Slack</a>.</p>\n\n\n\n<figure class=\"wp-block-image alignfull size-full\"><img decoding=\"async\" loading=\"lazy\" width=\"2560\" height=\"1605\" src=\"https://i1.wp.com/wordpress.org/news/files/2022/02/news_mobile_menu-scaled.jpg?resize=2560%2C1605&#038;ssl=1\" alt=\"\" class=\"wp-image-12263\" srcset=\"https://i1.wp.com/wordpress.org/news/files/2022/02/news_mobile_menu-scaled.jpg?w=2560&amp;ssl=1 2560w, https://i1.wp.com/wordpress.org/news/files/2022/02/news_mobile_menu-scaled.jpg?resize=300%2C188&amp;ssl=1 300w, https://i1.wp.com/wordpress.org/news/files/2022/02/news_mobile_menu-scaled.jpg?resize=1024%2C642&amp;ssl=1 1024w, https://i1.wp.com/wordpress.org/news/files/2022/02/news_mobile_menu-scaled.jpg?resize=768%2C482&amp;ssl=1 768w, https://i1.wp.com/wordpress.org/news/files/2022/02/news_mobile_menu-scaled.jpg?resize=1536%2C963&amp;ssl=1 1536w, https://i1.wp.com/wordpress.org/news/files/2022/02/news_mobile_menu-scaled.jpg?resize=2048%2C1284&amp;ssl=1 2048w\" sizes=\"(max-width: 1000px) 100vw, 1000px\" data-recalc-dims=\"1\" /></figure>\n\n\n\n<p>Take a look around and subscribe to WordPress News if you haven’t already. If you see something in the design that doesn’t look right, please submit an issue on <a href=\"https://github.com/WordPress/wporg-news-2021/\">GitHub</a>.</p>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:30:\"com-wordpress:feed-additions:1\";a:1:{s:7:\"post-id\";a:1:{i:0;a:5:{s:4:\"data\";s:5:\"12244\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}}}s:27:\"http://www.w3.org/2005/Atom\";a:1:{s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:0:\"\";s:7:\"attribs\";a:1:{s:0:\"\";a:3:{s:4:\"href\";s:32:\"https://wordpress.org/news/feed/\";s:3:\"rel\";s:4:\"self\";s:4:\"type\";s:19:\"application/rss+xml\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:44:\"http://purl.org/rss/1.0/modules/syndication/\";a:2:{s:12:\"updatePeriod\";a:1:{i:0;a:5:{s:4:\"data\";s:9:\"\n	hourly	\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:15:\"updateFrequency\";a:1:{i:0;a:5:{s:4:\"data\";s:4:\"\n	1	\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:30:\"com-wordpress:feed-additions:1\";a:1:{s:4:\"site\";a:1:{i:0;a:5:{s:4:\"data\";s:8:\"14607090\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}}}}}}}}s:4:\"type\";i:128;s:7:\"headers\";a:10:{s:6:\"server\";s:5:\"nginx\";s:4:\"date\";s:29:\"Fri, 24 Jun 2022 03:00:59 GMT\";s:12:\"content-type\";s:34:\"application/rss+xml; charset=UTF-8\";s:10:\"connection\";s:5:\"close\";s:25:\"strict-transport-security\";s:11:\"max-age=360\";s:6:\"x-olaf\";s:3:\"⛄\";s:13:\"last-modified\";s:29:\"Mon, 13 Jun 2022 11:01:44 GMT\";s:4:\"link\";s:63:\"<https://wordpress.org/news/wp-json/>; rel=\"https://api.w.org/\"\";s:15:\"x-frame-options\";s:10:\"SAMEORIGIN\";s:4:\"x-nc\";s:9:\"HIT ord 2\";}s:5:\"build\";s:14:\"20130911040210\";}", "no");
INSERT INTO wp_lofaro_labs_scroll_options VALUES("56084", "_transient_timeout_feed_mod_ac0b00fe65abe10e0c5b588f3ed8c7ca", "1656082912", "no");
INSERT INTO wp_lofaro_labs_scroll_options VALUES("56085", "_transient_feed_mod_ac0b00fe65abe10e0c5b588f3ed8c7ca", "1656039712", "no");
INSERT INTO wp_lofaro_labs_scroll_options VALUES("56086", "_transient_timeout_feed_d117b5738fbd35bd8c0391cda1f2b5d9", "1656082912", "no");
INSERT INTO wp_lofaro_labs_scroll_options VALUES("56087", "_transient_feed_d117b5738fbd35bd8c0391cda1f2b5d9", "a:4:{s:5:\"child\";a:1:{s:0:\"\";a:1:{s:3:\"rss\";a:1:{i:0;a:6:{s:4:\"data\";s:3:\"\n\n\n\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:7:\"version\";s:3:\"2.0\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:1:{s:0:\"\";a:1:{s:7:\"channel\";a:1:{i:0;a:6:{s:4:\"data\";s:61:\"\n	\n	\n	\n	\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:1:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:16:\"WordPress Planet\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:28:\"http://planet.wordpress.org/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"language\";a:1:{i:0;a:5:{s:4:\"data\";s:2:\"en\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:47:\"WordPress Planet - http://planet.wordpress.org/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"item\";a:50:{i:0;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:72:\"Post Status: WooCommerce Function of the Week: woocommerce_wp_text_input\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"https://poststatus.com/?p=99025\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:82:\"https://poststatus.com/woocommerce-function-of-the-week-woocommerce_wp_text_input/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:147:\"Learn how to add custom fields to settings in WooCommerce meta boxes — and give back to WooCommerce when you find some code that can be improved.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Fri, 24 Jun 2022 02:30:06 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:15:\"Rodolfo Melogli\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:1;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:111:\"WPTavern: Gutenberg 13.5 Adds Featured Image Placeholder Support for Cover Block, Cleaner Pasting to Other Apps\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:30:\"https://wptavern.com/?p=135515\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:121:\"https://wptavern.com/gutenberg-13-5-adds-featured-image-placeholder-support-for-cover-block-cleaner-pasting-to-other-apps\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:4048:\"<p><a href=\"https://make.wordpress.org/core/2022/06/22/whats-new-in-gutenberg-13-5-22-june/\">Gutenberg 13.5</a> is now available. The release comes two weeks after the plugin introduced support for button elements in theme.json, axial spacing in the Gallery block, and a redesigned Publish popover in <a href=\"https://make.wordpress.org/core/2022/06/10/whats-new-in-gutenberg-13-4-8-june/\">13.4.</a> The latest release includes 12 enhancements and 15&nbsp;bug&nbsp;fixes with the most notable changes landing in the Cover block. </p>\n\n\n\n<p>Prior to 13.5, the Cover block&#8217;s support for using a featured image had a more confusing UI with&nbsp;a separate button in the block toolbar. The featured image toggle has now been <a href=\"https://github.com/WordPress/gutenberg/pull/41476\">relocated to the media replace flow</a>. The Cover block has also been updated to <a href=\"https://github.com/WordPress/gutenberg/pull/41460\">display a placeholder</a> when the featured image in use.</p>\n\n\n\n<img />image source: <a href=\"https://make.wordpress.org/core/2022/06/22/whats-new-in-gutenberg-13-5-22-june/\">Gutenberg 13.5 release post</a>\n\n\n\n<p>The Cover block&#8217;s overlay color and opacity controls have been <a href=\"https://github.com/WordPress/gutenberg/pull/41102\">moved into the inspector controls sidebar&#8217;s Color panel</a> for consistency to match the UI for other blocks.</p>\n\n\n\n<p>Gutenberg 13.5 also expands the design tools available to the Post Navigation block. Users can now set the link color and font family. This is one of those situations where contributors <a href=\"https://github.com/WordPress/gutenberg/pull/41378\">discussed</a> how much design control makes sense for users in this context. Automattic-sponsored contributor Jeff Ong made the case for instances where users may want to have post navigation use the heading font, instead of the body font.</p>\n\n\n\n<img />image credit: Jeff Ong &#8211; <a href=\"https://github.com/WordPress/gutenberg/pull/41378\">Gutenberg PR #41378</a>\n\n\n\n<p>One small update to the Publish date picker is that it now highlights today&#8217;s date, expanding on the <a href=\"https://github.com/WordPress/gutenberg/pull/41097\">popover design update</a> introduced in 13.4. </p>\n\n\n\n<p>Gutenberg users who frequently copy and paste between other writing apps may be pleased to learn that version 13.5 introduces a change that <a href=\"https://github.com/WordPress/gutenberg/pull/41366\">strips the HTML from copied block markup</a> for the text/plain version of the clipboard. Gutenberg engineer Andrei Draganescu explained the reasoning behind the change:</p>\n\n\n\n<blockquote class=\"wp-block-quote\"><p>Pasting into plain text editors should only paste the text we see on screen not the whole underlying markup.</p><p>This is an improvement in the experience of writing in a different app rather than in the WordPress editor itself, and then bringing over the content. Since one could move text content back and forth a few times, pasting block markup is annoying if not even prone to introducing problems.</p></blockquote>\n\n\n\n<p>Prior to this change, pasting from Gutenberg into another app looked something like this:</p>\n\n\n\n<img />\n\n\n\n<p>Stripping the HTML out of serialized data in the copy handler before placing it in the&nbsp;<code>text/plain</code>&nbsp;version results in a cleaner paste, as Draganescu demonstrated in a video:</p>\n\n\n\nVideo Source: <a href=\"https://github.com/WordPress/gutenberg/pull/41366\">Gutenberg PR #41366</a>\n\n\n\n<p>Check out the <a href=\"https://make.wordpress.org/core/2022/06/22/whats-new-in-gutenberg-13-5-22-june/\">release post</a> for a full list of changes in 13.5. If you don&#8217;t have the Gutenberg plugin installed, you will have to wait until the next major WordPress release to take advantage of these fixes and enhancements. WordPress 6.1&#8217;s release date was <a href=\"https://make.wordpress.org/core/2022/06/23/wordpress-6-1-planning-roundup/\">announced</a> today as October 25, 2022, following a long alpha and two short beta periods.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 23 Jun 2022 20:36:07 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Sarah Gooding\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:2;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:90:\"Do The Woo Community: Woo BizChat Hits WordCamp Europe with Vito Peleg and Robert Windisch\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:28:\"https://dothewoo.io/?p=72050\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:52:\"https://dothewoo.io/wceu-vito-peleg-robert-windisch/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:424:\"<p>Another in the series of recordings we did at WordCamp Europe. A great conversation that brings you IRL to the camp experience.</p>\n<p>&gt;&gt; The post <a rel=\"nofollow\" href=\"https://dothewoo.io/wceu-vito-peleg-robert-windisch/\">Woo BizChat Hits WordCamp Europe with Vito Peleg and Robert Windisch</a> appeared first on <a rel=\"nofollow\" href=\"https://dothewoo.io\">Do the Woo - a WooCommerce Builder Community</a>	.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 23 Jun 2022 09:04:00 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:5:\"BobWP\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:3;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:44:\"WPTavern: WordPress Appears In NYT Crossword\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:30:\"https://wptavern.com/?p=135473\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:55:\"https://wptavern.com/wordpress-appears-in-nyt-crossword\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:4627:\"<p>At the risk of spoiling the answer to a clue included in the image below, WordPress made an appearance in the New York Times crossword puzzle today. Likely nobody reading this post would struggle to answer the clue &#8220;popular blogging platform&#8221; with nine letters. New York-based digital consultant and media co-founder Matt DeSiena <a href=\"https://twitter.com/theinstantwin/status/1539635386741399552\">tweeted</a> a screenshot with the caption, &#8220;You know it&#8217;s a good day when WordPress makes an appearance in the NYT Crossword.&#8221;</p>\n\n\n\n<img />\n\n\n\n<p>Despite the software powering <a href=\"https://w3techs.com/technologies/details/cm-wordpress\">43% of websites</a>, many of us working in the world of WordPress still cannot adequately explain what we do to some of our friends and family. The rare pop culture reference still gives an exciting and affirming jolt of recognition to WordPress&#8217; fondest fans. </p>\n\n\n\n<p>One of the more obscure and unforgettable WordPress references happened 12 years ago when the code was used to guide missiles. WordPress lead developer Dion Hulse spotted the project&#8217;s <a href=\"https://core.trac.wordpress.org/browser/trunk/wp-admin/js/post.dev.js?rev=15239\">post.js</a> code in episode 5 of the British mini-series <a rel=\"noreferrer noopener\" href=\"http://en.wikipedia.org/wiki/Strike_Back_%28TV_series%29\" target=\"_blank\">Strike Back</a> as part of a weapons guidance system. Mark Jaquith then <a rel=\"noreferrer noopener\" href=\"https://core.trac.wordpress.org/changeset/15239\" target=\"_blank\">ported those changes back to core</a>, giving props to Left Bank Pictures.</p>\n\n\n\n<img />photo credit: Alex Mills <a href=\"http://www.viper007bond.com/2010/06/12/so-apparently-wordpress-can-guide-missiles/\">&#8220;So Apparently WordPress Can Guide Missiles&#8221;</a>\n\n\n\n<p>The software was also mentioned in Lily Allen’s “<a rel=\"noreferrer noopener\" href=\"https://www.youtube.com/watch?v=lDlofPAOZy0\" target=\"_blank\">URL Badman</a>” released in 2014, and briefly mentioned on the popular Netflix original series <a rel=\"noreferrer noopener\" href=\"https://www.netflix.com/title/70242311\" target=\"_blank\">Orange is the New Black</a> in 2015.</p>\n\n\n\n<div class=\"wp-block-embed__wrapper\">\n<blockquote class=\"twitter-tweet\"><p lang=\"en\" dir=\"ltr\">pahahaha, I captured <a href=\"https://twitter.com/hashtag/WordPress?src=hash&ref_src=twsrc%5Etfw\">#WordPress</a> on <a href=\"https://twitter.com/hashtag/oitnb?src=hash&ref_src=twsrc%5Etfw\">#oitnb</a>. too real, if I had a nickel for every time I got an inquiry like this&#8230; <a href=\"http://t.co/XCfo5jtpZU\">pic.twitter.com/XCfo5jtpZU</a></p>&mdash; Megan Gray (@HouseofGrays) <a href=\"https://twitter.com/HouseofGrays/status/610669209144721408?ref_src=twsrc%5Etfw\">June 16, 2015</a></blockquote>\n</div>\n\n\n\n<p>WordPress.com has also twice been featured on Jeopardy, an American television game show. In 2014, the platform was included in a clue under the category &#8220;dot-com&#8221; with the answer &#8220;What are blogs?&#8221;</p>\n\n\n\n<div class=\"wp-block-embed__wrapper\">\n<blockquote class=\"twitter-tweet\"><p lang=\"en\" dir=\"ltr\">.<a href=\"https://twitter.com/wordpressdotcom?ref_src=twsrc%5Etfw\">@wordpressdotcom</a> was featured on today\'s episode of <a href=\"https://twitter.com/Jeopardy?ref_src=twsrc%5Etfw\">@Jeopardy</a>! So cool! Photo by my co-worker Brian. <a href=\"http://t.co/cYwSKRlBbB\">pic.twitter.com/cYwSKRlBbB</a></p>&mdash; Alex Mills (@Viper007Bond) <a href=\"https://twitter.com/Viper007Bond/status/440625114803994625?ref_src=twsrc%5Etfw\">March 3, 2014</a></blockquote>\n</div>\n\n\n\n<p>More recently, in 2020, WordPress.com was featured in a Jeopardy clue that read like an advertisement. The  answer, &#8220;What are blogs?&#8221;, echoed the previous Jeopardy reference. </p>\n\n\n\n<div class=\"wp-block-embed__wrapper\">\n<blockquote class=\"twitter-tweet\"><p lang=\"en\" dir=\"ltr\">Good question. What ARE blogs in 2020? <a href=\"https://twitter.com/hashtag/whatareblogs?src=hash&ref_src=twsrc%5Etfw\">#whatareblogs</a><br /><br />Thanks for featuring us on tonight\'s episode, <a href=\"https://twitter.com/Jeopardy?ref_src=twsrc%5Etfw\">@Jeopardy</a>! <a href=\"https://t.co/XR9th5bt2r\">pic.twitter.com/XR9th5bt2r</a></p>&mdash; WordPress.com (@wordpressdotcom) <a href=\"https://twitter.com/wordpressdotcom/status/1223044290386907137?ref_src=twsrc%5Etfw\">January 31, 2020</a></blockquote>\n</div>\n\n\n\n<p>There are probably many more references that have gone unnoticed, as WordPress is becoming more of a household name these days. Where have you seen it mentioned in the wild recently?</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Wed, 22 Jun 2022 21:31:36 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Sarah Gooding\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:4;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:123:\"WPTavern: GitHub Makes Copilot Available to the Public for $10/month, Free for Students and Open Source Project Maintainers\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:30:\"https://wptavern.com/?p=135448\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:132:\"https://wptavern.com/github-makes-copilot-available-to-the-public-for-10-month-free-for-students-and-open-source-project-maintainers\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:3577:\"<p>GitHub has <a href=\"https://github.blog/2022-06-21-github-copilot-is-generally-available-to-all-developers/\">announced</a> that Copilot, its new AI pair programming assistant, is now available to developers for $10/month or $100/year. Verified students and maintainers of open source projects will have free access to Copilot. The assistant is available as an extension for popular code editors, including Neovim, JetBrains IDEs, Visual Studio, and Visual Studio Code.</p>\n\n\n\n<p>Copilot was trained on billions of lines of public code in order to offer real-time code suggestions inside the editor. GitHub claims it is capable of suggesting complete methods, boilerplate code, whole unit tests, and complex algorithms. </p>\n\n\n\n<p>&#8220;With GitHub Copilot, for the first time in the history of software, AI can be broadly harnessed by developers to write and complete code,&#8221; GitHub CEO Thomas Dohmke said. &#8220;Just like the rise of compilers and open source, we believe AI-assisted coding will fundamentally change the nature of software development, giving developers a new tool to write code easier and faster so they can be happier in their lives.&#8221;</p>\n\n\n\n<p>Despite its many claims to improve developer efficiency, Copilot is still a controversial tool. Opponents object to the tool&#8217;s creators training the AI on open source code hosted on GitHub, generating code without attribution, and then charging users monthly to use Copilot. It has also been criticized for <a href=\"https://arxiv.org/pdf/2108.09293.pdf\">producing insecure code</a> and <a href=\"https://news.ycombinator.com/item?id=27710287\">copying large chunks of code</a> <a href=\"https://www.theinsaneapp.com/2021/07/github-copilot-ai-facing-criticism.html\">verbatim</a>.</p>\n\n\n\n<div class=\"wp-block-embed__wrapper\">\n<blockquote class=\"twitter-tweet\"><p lang=\"en\" dir=\"ltr\">GitHub charging $10/month for an A.I. feature trained on open source code hosted on their service is the software developer version of if you’re not paying for the product then you are the product.<a href=\"https://t.co/pdHcZPJauk\">https://t.co/pdHcZPJauk</a></p>&mdash; Dare Obasanjo (@Carnage4Life) <a href=\"https://twitter.com/Carnage4Life/status/1539330297057095680?ref_src=twsrc%5Etfw\">June 21, 2022</a></blockquote>\n</div>\n\n\n\n<div class=\"wp-block-embed__wrapper\">\n<blockquote class=\"twitter-tweet\"><p lang=\"en\" dir=\"ltr\">github copilot is incredible. it just sells code other people wrote, but because it\'s an \"AI\" it is apparently allowed to launder that code without it being a \"derivative work\". lol. lmao. what an amazing grift.</p>&mdash; Senior Oops Engineer (@ReinH) <a href=\"https://twitter.com/ReinH/status/1539626662274269185?ref_src=twsrc%5Etfw\">June 22, 2022</a></blockquote>\n</div>\n\n\n\n<p>Evan after 12 months in technical preview, Copilot <a href=\"https://twitter.com/wesbos/status/1539614060236443649\">remains generally polarizing</a> at its public launch. Developers either seem to be impressed by its capabilities or offended by its ethical ambiguities. GitHub had more than 1.2 million developers in its technical preview and reports that those who started using Copilot quickly found it &#8220;an indispensable part of their daily workflows.&#8221;</p>\n\n\n\n<p>&#8220;In files where it’s enabled, nearly 40% of code is being written by GitHub Copilot in popular coding languages, like Python—and we expect that to increase,&#8221; Dohmke said. &#8220;That’s creating more time and space for developers to focus on solving bigger problems and building even better software.&#8221;</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Wed, 22 Jun 2022 19:42:50 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Sarah Gooding\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:5;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:92:\"Post Status: Post Status Comments (No. 11) — WordPress 19th Anniversary Meetup Celebration\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"https://poststatus.com/?p=98838\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:69:\"https://poststatus.com/wordpress-19th-anniversary-meetup-celebration/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:189:\"A 19th birthday celebration for #WordPress with Mary Job, Nathan Wrigley, Naoko Takano, Carrie Dils, David Yarde, Joe Simpson Jr., Pat Ramsey, John Jacoby, Yvette Sonneveld, and Taco Verdo.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Wed, 22 Jun 2022 18:45:06 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:12:\"David Bisset\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:6;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:96:\"Post Status: Promoting WordCamps, GDPR and Google Fonts, Invalid Reviews, 5FTF, and the Admin UX\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"https://poststatus.com/?p=99475\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:52:\"https://cdn.poststatus.com/make-wordpress-6-22-2022/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:312:\"How should WordCamps be promoted on official WordPress channels? • How to comply with the GDPR when you\'re using Google Fonts. • What\'s the deal with invalid plugin/theme reviews? Mika Epstein explains. • Important decisions in The Five for the Future GitHub repo. • Thinking through the Admin UX. <br />\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Wed, 22 Jun 2022 18:13:28 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:18:\"Courtney Robertson\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:7;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:78:\"WPTavern: #31 – Milan Ivanovic on the Importance of Real World Versus Online\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:48:\"https://wptavern.com/?post_type=podcast&p=135351\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:92:\"https://wptavern.com/podcast/31-milan-ivanovic-on-the-importance-of-real-world-versus-online\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:35995:\"<p>On the podcast today we have <a href=\"https://twitter.com/lanche86\">Milan Ivanovic</a>.</p>\n\n\n\n<p>Milan is a WordPress Developer at <a href=\"https://www.valet.io/\">Valet.io</a>, and is a WordCamp volunteer, speaker, and organizer.</p>\n\n\n\n<p>He’s the WordPress.org global translation editor, WordPress Serbia lead, and is now part of the WordCamp Europe alumni.</p>\n\n\n\n<p>As if that weren’t enough, Milan is one of the lecturers of the WordPress Academy in Serbia, where he has given talks and WordPress Workshops. He’s also a member of the Theme Review and Community Get Involved Teams.</p>\n\n\n\n<p>It’s pretty clear to see that WordPress and WordPress events play a major role in Milan’s life, and that’s what this podcast is about.</p>\n\n\n\n<p>We’re drilling down on why the community which surrounds WordPress is a key part in the success of the whole project.</p>\n\n\n\n<p>The recent hiatus of in-person events has meant that all the events moved online. Whilst this was a good stop gap, Milan, as you will hear, is pleased that real world events are back.</p>\n\n\n\n<p>We talk about the importance of the WordPress community as a whole, as well as exploring what the situation is like in Milan’s home country of Serbia.</p>\n\n\n\n<p>We discuss how Milan got started as a community member and the different roles that events like WordCamps can offer people wishing to dip their toes in the community waters.</p>\n\n\n\n<p>We also get into the subject of diversity and how Europe as a continent might face diversity challenges which differ from other parts of the world.</p>\n\n\n\n<p>Milan is an enthusiastic speaker and I’m sure that you’ll get a fresh perspective from listening to the podcast.</p>\n\n\n\nTranscription<div>\n<p>[00:00:00] <strong>Nathan Wrigley:</strong> Welcome to the Jukebox podcast from WP Tavern. My name is Nathan Wrigley. Jukebox is a podcast which is dedicated to all things WordPress. The people, the events, the plugins, the blocks, the themes, and in this case, the importance of real world WordPress events.</p>\n\n\n\n<p>If you&#8217;d like to subscribe to the podcast, you can do that by searching for WP Tavern in your podcast player of choice, or by going to WPTavern.com forward slash feed forward slash podcast. And you can copy that URL into most podcast players. If you have a topic that you&#8217;d like us to feature on the podcast, well, I&#8217;m more than keen to hear from you and hopefully get you, or your idea featured on the show. Head over to WPTavern.com forward slash contact forward slash jukebox. And use the contact form there.</p>\n\n\n\n<p>So on the podcast today, we have Milan Ivanovic. Milan is a WordPress developer at valet.io. And is a WordCamp volunteer, speaker, and organizer. He&#8217;s the wordpress.org global translation editor, WordPress Serbia lead, and is now part of the WordCamp Europe alumni. As if that weren&#8217;t enough, Milan is one of the lecturers of the WordPress academy in Serbia, where he has given talks and WordPress workshops. He&#8217;s also a member of the Theme Review and Community Gets Involved teams.</p>\n\n\n\n<p>It&#8217;s pretty clear to see that WordPress and WordPress events play a major role in Milan&#8217;s life. And that&#8217;s what this podcast is about. We&#8217;re drilling down on why the community which surrounds WordPress is a key part in the success of the whole project.</p>\n\n\n\n<p>The recent hiatus of in-person events has meant that all the events moved online. Whilst this was a good stop gap, Milan, as you will hear, is pleased that real world events are back.</p>\n\n\n\n<p>We talk about the importance of the WordPress community as a whole, as well as exploring what the situation is like in Milan&#8217;s home country of Serbia.</p>\n\n\n\n<p>We discussed how Milan got started as a community member, and the different roles that events like WordCamp offer people wishing to dip their toes in the WordPress waters.</p>\n\n\n\n<p>We also get into the subject of diversity and how Europe as a continent might face diversity challenges which differ from other parts of the world.</p>\n\n\n\n<p>Milan is an enthusiastic speaker. And I&#8217;m sure that you&#8217;ll get some new perspectives from listening to the podcast.</p>\n\n\n\n<p>If you&#8217;re interested in finding out more, you can find all the links in the show notes by heading over to WPTavern.com forward slash podcast, where you&#8217;ll also find all the other episodes.</p>\n\n\n\n<p>And so without further delay, I bring you Milan Ivanovic.</p>\n\n\n\n<p>I am joined on the podcast today by Milan Ivanovic. Hello.</p>\n\n\n\n<p>[00:03:34] <strong>Milan Ivanovic:</strong> Hello.</p>\n\n\n\n<p>[00:03:34] <strong>Nathan Wrigley:</strong> Very nice to have you with us. We&#8217;re gonna be talking about WordCamp Europe, and WordCamps and community in general. First of all, Milan, would you like to just spend a moment introducing yourself? What&#8217;s your background in WordPress?</p>\n\n\n\n<p>[00:03:45] <strong>Milan Ivanovic:</strong> Yeah, would love to. I started really early with WordPress and just like looking for community back in Serbia. We, I didn&#8217;t know that if you are looking for community there isn&#8217;t one, like maybe you can start it. So 2013, I moved to Norway and then all of a sudden they already had the meetups in place. So I helped organize those meetups. You know, just being there as a speaker, as one of the organizers. So I moved back to Serbia in 2014 and I was like, you know what? They already had one meetup and nothing happened from it. And then I just started a little bit with no expectations, like how many people would show up, how many people will jump in.</p>\n\n\n\n<p>Just like start it and see how it goes. 2014 was the first official WordPress Serbia meetup. And now we have 16 different cities with meetups across Serbia.</p>\n\n\n\n<p>[00:04:33] <strong>Nathan Wrigley:</strong> Wow. That&#8217;s that is really impressive. From everything that I&#8217;ve seen, and obviously I don&#8217;t really know intimate details about your life, but from everything I&#8217;ve seen, you are really committed to the community. Like more so than almost anybody, it feels like.</p>\n\n\n\n<p>[00:04:47] <strong>Milan Ivanovic:</strong> Pretty much. I got hooked up, like the first WordCamp for me was WorkCamp Europe, in Leiden 2013. I immediately knew that I need to help organize. I need, I saw volunteers dedicating their time. They&#8217;re passionate. I&#8217;m like, yeah. How can I help?</p>\n\n\n\n<p>So they explained next year, follow the website, we are gonna open the call for volunteers, and then you can sign up. I think that it passed like one millisecond before I saw it. I&#8217;m like, yep, yep. Filling in the form already. So my first volunteering, official volunteering experience was 2014 already, just like, yeah. I was at the registration desk letters A and B. The happiest person at the registration, that&#8217;s me just like smiling all over the face. Like, hello, welcome WordCamp Europe.</p>\n\n\n\n<p>[00:05:29] <strong>Nathan Wrigley:</strong> But you&#8217;ve really taken it to heart. And you&#8217;ve committed an awful lot of time and been involved in some of the biggest events that WordCamp, in particular has to offer. WordCamp Europes, and you were really influential in all of that taking off.</p>\n\n\n\n<p>[00:05:41] <strong>Milan Ivanovic:</strong> I like bringing people. Like, I, believe in like that all of us, together we could like push mountains. And when you see these guys, like they come to the conference and all of a sudden you have like bunch of amateurs, like in organizing the event, but they give it all.</p>\n\n\n\n<p>Organizing doing like all of a sudden, you see someone, you know, in charge for TVs, like, workshops, pushing tables and stuff. Everyone is giving what they have. But if you collect hundred of those, like different people willing to make this event happen, the best way possible, that was like heart touching for me, like in the beginning.</p>\n\n\n\n<p>So yeah, I&#8217;ve been involved like into organizing. Started really slow, and low, you know, just like being the foot soldier. Working at the doors, or like happened with the registration. Then, you know, my involvement grew over the years. So in 2015 was in charge like for a small registration desk.</p>\n\n\n\n<p>And then immediately we knew that we need to make this happen. In 2015, we had the first WordCamp in Serbia, WordCamp Belgrade, almost 200 people. And they were like, yeah, wow, this can really be a thing. Then we started with more meetups, more people got involved, more people willing to help, in Serbia. Expressly we had the growth, like in WordCamp Europe. You see the Seville, Vienna when Vienna happened in 2016, we had like 2000 people. I&#8217;m like, whoa, this was a big thing.</p>\n\n\n\n<p>[00:07:04] <strong>Nathan Wrigley:</strong> The listenership, for the podcast is pretty broad because there&#8217;s so many people, of all different walks of life consuming WP Tavern content. Just give us an insight into the kind of things that you could do if you volunteered. And the reason I ask that is I know for a fact that many of the people that I now have as very good friends in the WordPress community, they tell the story of, I didn&#8217;t know. I didn&#8217;t know there was a thing.</p>\n\n\n\n<p>I used the software because it was free and I enjoyed it. But no way. What, how could there be a community about software? That&#8217;s just not normal and yet here it is. I mean maybe some of the top 10 things that you&#8217;ve enjoyed or the jobs that you might find yourself in, if you come to an event like WordCamp Europe, and get involved.</p>\n\n\n\n<p>[00:07:45] <strong>Milan Ivanovic:</strong> So I heard I&#8217;m not a hundred percent sure about the data, but looks like that we have like around 60% of first timers at this WordCamp Europe. Uh, we haven&#8217;t had like in person events three years now for WordCamp Europe. The last one was in Berlin, 2019. I think the power of this whole thing is our community. Just like people being here, being present, and then the networking simply happens.</p>\n\n\n\n<p>Uh, you will see because of that diversity and knowledge and background, different backgrounds. The more diverse we are, the stronger we are. That&#8217;s why you end up with, someone sitting next to and chatting with someone who actually put the code in the core of WordPress. And then you see someone who just like installed it and they are simply using it. Not having a clue what&#8217;s behind it. Like who put up the code what&#8217;s there and then you see those two, the person&#8217;s just chatting.</p>\n\n\n\n<p>Hey, what would you like to improve? Like, I think that&#8217;s the power of this whole mess that we are into. Yeah. So, uh, networking and just like being present. That&#8217;s what I think is the power of our community. If you do see like all those after movies or short interviews, when just someone goes, takes a camera and goes around and say like, Hey, what is the only thing that you, that you like here?</p>\n\n\n\n<p>I think nine out of 10, we say community, community because of community, we are here because of community, and we are so supportive. We are highly opinionated community about everything, but we are so supportive.</p>\n\n\n\n<p>[00:09:15] <strong>Nathan Wrigley:</strong> I strongly get that impression as well. That&#8217;s lovely. This particular event, everybody&#8217;s wearing a black t-shirt. And there are black t-shirts everywhere. I mean really everywhere, just in the corridor outside, where we&#8217;re recording this, I think there&#8217;s three people wearing black t-shirts. These are the people who volunteered their time for free. So there&#8217;s people assisting you to find me so that we can have this interview.</p>\n\n\n\n<p>There&#8217;s people publishing the little lanyards that we wear around our neck. There&#8217;s people that are putting up signage. There&#8217;s basically people doing all sorts of hidden roles. You know all of this stuff intimately. There must be hundreds of different things, and if I was somebody that had never come across the community, I think there&#8217;s a chance that I would think, I don&#8217;t code, I shouldn&#8217;t go. But that&#8217;s not the case. There&#8217;s a job for everybody. So give us some of the, sort of the things that you might encourage people to do if they volunteer for a WordCamp, that first time.</p>\n\n\n\n<p>[00:10:05] <strong>Milan Ivanovic:</strong> I got involved into volunteering because I want to make this event happen. when you see that your small role doesn&#8217;t matter, like how small it is, makes a difference. It&#8217;s amazing. Even if you&#8217;re a mic runner. Imagine that someone is expecting that mic and you like, feel so powerful, I brought that mic, like here is the mic. You can ask your question. Those small bits that we had, like in Seville I think we had around 70 to 80 volunteers plus the organizing team.</p>\n\n\n\n<p>In Vienna we had 160. It&#8217;s an army of people wearing the same coloured t-shirts, This year we, I think they have, 70 to 80 organizers, and then 200 volunteers. That&#8217;s why there&#8217;s as many black t-shirts because everyone is having their shifts. Everyone is, you know, have a purpose. Everyone is just like enjoying the event and you see that all like happy or smiling, everyone willing to help.</p>\n\n\n\n<p>I think like in the beginning, when we started the whole army of volunteers. You get to the event, and you don&#8217;t know where the registration is. You don&#8217;t know what to do after registration. You get the lanyard, like, how is it going? Like, should I just say my name? You say your name and you get a lanyard, you get a small goodie bag.</p>\n\n\n\n<p>Everyone is happy, but all the volunteers like guiding you, like, Hey, welcome to event. Here&#8217;s the coffee. Here are some sessions, and there is something for everyone, if they&#8217;re willing to help. If you say that, I want to help with, I wanna be in a room or I would like to be at the registration, or I would like to help carrying boxes, there is job for everyone.</p>\n\n\n\n<p>[00:11:41] <strong>Nathan Wrigley:</strong> Yeah.</p>\n\n\n\n<p>[00:11:42] <strong>Milan Ivanovic:</strong> And that&#8217;s a good thing.</p>\n\n\n\n<p>[00:11:43] <strong>Nathan Wrigley:</strong> You basically don&#8217;t need to be into the code. You can, like you said, you can carry boxes, you can print lanyards, you can guide people, you can put up signage. There&#8217;s just so many things. If I was on the organizing team at the level that you were in Berlin in 2019, in other words, you were really responsible for that event.</p>\n\n\n\n<p>How long before the door opened on the first day, how long before did you begin that planning process? And I&#8217;m just trying to get a measure of how many hours go into that, and how it trickles down and you know, how you disseminate that and discover the volunteers and basically how does it all fit together?</p>\n\n\n\n<p>[00:12:13] <strong>Milan Ivanovic:</strong> Oh, it&#8217;s a, it&#8217;s a long process. It&#8217;s a long process because, selecting the future city, every year WordCamp Europe changes country. For WordCamp Europe 2018 in Belgrade, me and the local team, we worked on it from September 2015. To make it happen in June 2018. Because it&#8217;s a long process. You need to prepare your local team because it&#8217;s was a team around 10 of us. You are just investing so much time. The first thing you need to work on is the application, because we have that application process where you submit your application and it&#8217;s usually like three to four cities, you know, fully prepared to organize the event.</p>\n\n\n\n<p>Then, previous organizers, foundation WordPress foundation. Uh, we go on a meeting and then we talk about, we&#8217;ll look at those applications and then we decide which city is that going to be? So, for Belgrade, it was a long, long period because we had to prepare our local community as well, to start with local meetups and just to educate people what actually WordCamp Europe is.</p>\n\n\n\n<p>We had the same, like everywhere else. Like people haven&#8217;t had idea that you can, all of a sudden, you can have a conference with like 2, 3000 people. That&#8217;s creme de la creme of WordPress communities going to be there. we had to like go educate people, do the meetups, do the all kinds of stuff just to prepare it.</p>\n\n\n\n<p>For Berlin, their team, like I&#8217;m talking about the local team for Berlin. It was again long process for them as well, because they worked on the application. Then they submitted application, they got approved. And then you want that team, future team to be on this year&#8217;s team. Because you want them to see how it goes, And yeah, just to educate them by watching and just like being involved. You need to have them in, involved, like you need to educate them. So, is a long process.</p>\n\n\n\n<p>[00:14:12] <strong>Nathan Wrigley:</strong> And presumably you mentioned that you worked a lot. That&#8217;s gotta be something that if you volunteer you have to allocate time. It&#8217;s not a just show up and do a little bit here and there, maybe depending on where you step into that hierarchy.</p>\n\n\n\n<p>[00:14:24] <strong>Milan Ivanovic:</strong> All the WordCamps where we are going, or I&#8217;m talking about the WordCamp Europe, wherever you&#8217;re going, like the local team is the basically most important team. I knew that in Belgrade, like the last, I call like photo finish, last couple of weeks, or like couple of months, just like where all the work kept on piling up.</p>\n\n\n\n<p>I was getting up like super early, to make it like through all the meetings with the venue. To go through all the notes. Connect all the bits and pieces. And then because all of us, we have the day jobs. Some of us being supported by the companies, some are not. So involvement of the people change through time, and because it&#8217;s a long process and specifically for WordCamp Europe, you don&#8217;t have all the teams.</p>\n\n\n\n<p>All the different teams. We had like 10 different teams working all together. Like at the same time, like the, the high level. You&#8217;ll see, like in the beginning you have a huge impact on sponsors because they need to put up a call for sponsors. They need to sell all those packages. They need to see with the venue, how big is going to be expo area.</p>\n\n\n\n<p>There are just like so many things, yeah. Volunteers that they are coming into late, like volunteers, team. Communications. Communications team. It&#8217;s one that has been hit hardest. And the longest, because they like keep on putting all the things to the event because yeah, we had to like increase the number of organizers, but it is challenging.</p>\n\n\n\n<p>[00:15:52] <strong>Nathan Wrigley:</strong> Yeah.</p>\n\n\n\n<p>[00:15:52] <strong>Milan Ivanovic:</strong> Yeah, as I said many times already, like it&#8217;s a long process, but it&#8217;s an amazing process.</p>\n\n\n\n<p>[00:15:57] <strong>Nathan Wrigley:</strong> I&#8217;ve had a really interesting slight window into what is involved at this event, just because of the location of where we&#8217;re at and seeing all the sort of backstage stuff. Really fascinating, and just as an example, the attention to detail to allow us to be in this room at this exact moment. The coordination that goes on there, you know, great big spreadsheets. And, and although I knew that on some level that was happening, that&#8217;s a tiny part of a tiny part of a tiny part of the bigger event. And yet, somebody&#8217;s had to deal with that and take care of it. And it&#8217;s absolutely amazing.</p>\n\n\n\n<p>[00:16:27] <strong>Milan Ivanovic:</strong> Through the years we learned, we from our mistakes. I&#8217;ll call it mistakes. I&#8217;m doing the air quotes Because how the number of attendees grew, our problems grew as well. In Seville all of a sudden we had an amazing, amazing thing. People bringing their kids. We&#8217;re like, oh, we need to provide childcare service for the event. So we have, since 2016, we have the free childcare service for every WordCamp Europe. Then all of a sudden you have like more volunteers.</p>\n\n\n\n<p>You want more bigger exposure like in media. So you need to organize one room. Then all of a sudden that room is too small, then organized two rooms. Then you need to be like, Hey, the venue is quite big. We need someone guiding. It&#8217;s like, okay. So we need dedicated volunteer who will take speaker or whoever to the stage. Will take to media room and how the number of attendees grew, our problems went.</p>\n\n\n\n<p>[00:17:25] <strong>Nathan Wrigley:</strong> Genuinely in awe of the amount of things that are going on. Really remarkable. We&#8217;re very lucky though to be back. 2022, we&#8217;ve had a couple of years where, well, that hasn&#8217;t been the case for the reason that everybody knows. We&#8217;re all delighted that we&#8217;re back, but we&#8217;ve had a real moment where everything got a bit shaky, the community, every community, not just WordPress, but every community forced online.</p>\n\n\n\n<p>And I just wondered what your thoughts were about the impact of that. Fatigue of zoom calls and whether or not local events have kind of taken a hit in numbers. Certainly I think where I live, the interest in turning up monthly or whatever it might be to these meetups, when it&#8217;s been online month after month after month, it seems like the interest is sort of slowly waning.</p>\n\n\n\n<p>So maybe we&#8217;re an inflection point where it will begin to pick up again. But yeah, just interested in your thoughts on that.</p>\n\n\n\n<p>[00:18:12] <strong>Milan Ivanovic:</strong> Oh yeah. When we started, I was so glad when we switched to online. I was in Bangkok, waiting on the WordCamp Asia. And it was like, Hey, it&#8217;s gonna happen. And then the team made the best decision ever that will turn out to be like the best decision ever not to have it. Even though everyone, we like super sad. We were like in Thailand, you know, just like waiting for that conference, and it&#8217;s been in the making for so long and the local team and everyone involved wanted so badly that conference to happen.</p>\n\n\n\n<p>And then when we were there and someone said like, well maybe, maybe just, maybe we are not going to have it. And then they canceled. I&#8217;m like, yeah, what are we gonna do? So we stayed in Thailand, came back. Then when online happened, every day I have two meetings. It&#8217;s a Zoom meetings, I&#8217;m like, I&#8217;m not doing this.</p>\n\n\n\n<p>Again, like a conference. I can&#8217;t do it. And then I was so happy, like, when it happened that I, again get to see all the people involved. I was amazed by the number of people who signed up. Like, I think 2020, 8, 9,000 people signed up. The good thing is that you have way more people being able to attend.</p>\n\n\n\n<p>To just join the event. But I was super sad after it ended.</p>\n\n\n\n<p>[00:19:28] <strong>Nathan Wrigley:</strong> Yeah.</p>\n\n\n\n<p>[00:19:28] <strong>Milan Ivanovic:</strong> Because, being involved so many years back, to see all those people hug everyone, talk to everyone. When it ended, I was like, whoa, no. It felt so empty. I&#8217;m like, no, no, this is not happening.</p>\n\n\n\n<p>Yeah. I was glad that this was happening online, also for, for us in Serbia. Couple of guys decided like, Hey, we are not gonna go with online, but couple did. And I was so glad that it did because it kept something happening throughout the years. We are now in the limbo between those online events, someone wants to, someone is waiting on the in person events, like to start happening all over again, meetups with the restrictions over.</p>\n\n\n\n<p>But yeah, in Serbia as well, you are going to a few now online, but yesterday on contributors day, as a part of the community team, we formed a plan that we gonna contact all the meetup organizers asking how their involvement is now, because it&#8217;s been so long, two or three years that, no in person meetup happened.</p>\n\n\n\n<p>So we&#8217;re just gonna remind them, ask them about the help, how we, as a community can help them. People change jobs, a lot of things happen. In the meantime during COVID I got married, I got kid, but I&#8217;m still gonna be involved and see how we can help. So now the focus is on community to revamp and to see just like, Hey, how we can do with the meetups in person.</p>\n\n\n\n<p>Is it possible? Are those organizers who are like organizing those meetups, they gonna do it, or we need to look for someone else from that meetup group?</p>\n\n\n\n<p>[00:21:03] <strong>Nathan Wrigley:</strong> It&#8217;s a kind of reevaluation, where you&#8217;re gonna start again and see where we&#8217;re at right now? Yeah, it does feel like the involvement has gone down, but curiously, as you said at the top, 60% of the people who showed up to this event are new to the community. So there&#8217;s clearly some hanking for it. And so maybe when those events get rebooted with whoever they are, then maybe it&#8217;ll be the same, you know, 60% in the meetups will be new people, and that&#8217;s very encouraging.</p>\n\n\n\n<p>[00:21:27] <strong>Milan Ivanovic:</strong> starting the day after tomorrow, we are gonna see so many new meetups and like so interested.</p>\n\n\n\n<p>[00:21:32] <strong>Nathan Wrigley:</strong> Yeah. We&#8217;ll see, see where we are next year. Let&#8217;s just change focus a little bit. You mentioned a, a moment ago about the fact that you&#8217;re based in Serbia. And Europe is a, is an interesting continent. Lots and lots of countries, some big, some very small. Lots and lots of languages, so that the barrier literally may be impenetrable. For example, if you are in Serbia, that may be the only way that you can engage.</p>\n\n\n\n<p>A few months ago, there was some sort of coverage about diversity and whether or not the community organizing the team for WordCamp Europe had addressed that well enough. We actually did a podcast episode in which we aired those thoughts. So there is that to listen to. But the whole diversity debate, isn&#8217;t quite as straightforward, is it in Europe as it may be elsewhere, because, it&#8217;s not about the same things. Diversity might be language diversity, or it might be which country you&#8217;ve come from, or what have you. So, let&#8217;s just get into that.</p>\n\n\n\n<p>[00:22:21] <strong>Milan Ivanovic:</strong> Europe is a strange place. Europe is a strange place. Every year we try so hard. I know even when I was involved, and we as a community, we just need to keep on, keeping on about diversity.</p>\n\n\n\n<p>We need to educate people. I know that I had to educate myself first. I had to go for all the meetups. So when we start the meetup I&#8217;m doing, the first talk I&#8217;m doing, is about diversity. Is about code of conduct . And then yet again, people need to be reminded about it. I&#8217;m sure like this year as well, organizing team did a great job.</p>\n\n\n\n<p>But there&#8217;s always, like every year, there&#8217;s a, just a little bit of that sense that we could do a bit more, every year. And I&#8217;ve been haunted, you know, when you are like selecting teams, you&#8217;ve been involved in some decisions.</p>\n\n\n\n<p>I always had, just a a little bit like, maybe we could do more. When you see the organizing team, when you see event happening, I was like, yeah, well just maybe if we started early or maybe if we change this, or maybe if we put up a blog post, or maybe if we did something, something will be better.</p>\n\n\n\n<p>But what we are not noticing that is getting better, it&#8217;s never going to be perfect. But as long as we are talking and we are constantly repeating and like wanting to change, sooner or later, like we gonna be so close to that perfect. So yeah, I know the difficulties. I heard about. Uh, wasn&#8217;t involved, but heard about difficulties, this year organizing team, and like, just that limbo of that is it going to happen? You know, so they organized like local team for Portugal. They organized in 2019, for 2020 and then like, yeah, it&#8217;s not happening. Online.</p>\n\n\n\n<p>Then should we do like this year? Then, you know, some, some people from organizing team dropped off because life happened the meantime. So 2021, you kind of lost the momentum. Like 2022, you need to just like, Hey, this year is actually happening. You know, when you do like two tries and you fail, I&#8217;m doing the air quotes again. You fail, like you just need to pick everyone up. You need to form a team because as I said, like, this is a long event.</p>\n\n\n\n<p>Now we need someone ready who will dedicate a time. Who will dedicate a passion. Who will be willing to help. But yeah, I&#8217;m totally supporting the organized team and all the decisions they made. So happy for them. Again, we are not gonna reach that perfect, but as long as we are like longing for that, we&#8217;ll be good.</p>\n\n\n\n<p>[00:24:52] <strong>Nathan Wrigley:</strong> A couple of follow up questions from that. The first one is, do you, on a personal level, when you sort of hear these, criticisms from people, does it get you on a personal level or can you differentiate? Okay, that&#8217;s what somebody thinks over there. That&#8217;s fine. Okay. We&#8217;ll try our best next time. You&#8217;re giving up a lot of free time here.</p>\n\n\n\n<p>[00:25:08] <strong>Milan Ivanovic:</strong> Yeah. So in the beginning it was harder. You know, in the beginning it was harder because, you know how much you give yourself into, you know, organizing and, you know that we all have different backgrounds. And you know the what&#8217;s the backstory of organizer being, or the organizing team.</p>\n\n\n\n<p>And you know that people are sacrificing their time, sacrificing their families, relationship with friends. They can&#8217;t be with their friends, families. And then you hear that someone says like, Hey, well, maybe that. team, they could change this, and you&#8217;ll be like, because you know the both sides of the story. You can&#8217;t be like, no, like that&#8217;s not, but yet you can&#8217;t get into argue.</p>\n\n\n\n<p>I was couple times being part of the WP drama. And I realized that because of the language barrier, because we all different that, defending yourself, you&#8217;re only going deeper. Like deeper into the problem. So I always try to talk to that person. Hey, there are things that you are not aware something. But, yeah, as I said, like highly opinionated community about everything. That&#8217;s what I love about, and that&#8217;s what I hate a little bit.</p>\n\n\n\n<p>[00:26:19] <strong>Nathan Wrigley:</strong> When this event is over, presumably there&#8217;s a process of going, okay, let&#8217;s figure out what we did. What we did well. What could have been improved.</p>\n\n\n\n<p>Is there a thing like that? And can people like attendees, somebody like me, for example, can I put my opinion forward about, okay, next time, less of this and more of this.</p>\n\n\n\n<p>[00:26:36] <strong>Milan Ivanovic:</strong> Yeah.</p>\n\n\n\n<p>[00:26:36] <strong>Nathan Wrigley:</strong> Yeah. There&#8217;s a process for that?</p>\n\n\n\n<p>[00:26:38] <strong>Milan Ivanovic:</strong> Yeah, yeah, yeah. That&#8217;s a process in place that you put up the form. Hey, give us the feedback. My personal opinion is that like you are not reading the, you know, the worst possible things. Luckily, we never had those and you&#8217;re not reading all those, the best things ever, like best WordCamp ever. You are looking, at least I am looking, for something that was constructive criticism. Yeah. You go through there and you know that you failed. I don&#8217;t know with food could be better or something could be better.</p>\n\n\n\n<p>You are aware, but you&#8217;re looking for the constructive criticism. And we always like, till now, like waited for about two weeks because two weeks is, um, a period of time that people need to just think about everything. Because if you give like today, if you give that form to attendees and be like, oh my God, it&#8217;s so crazy.</p>\n\n\n\n<p>If you give that form to me, I just won the hat on the claw machine, but is going to be like the best WordCamp ever, because I just won. We are waiting about two weeks just for people to breathe in, decompress, you know, sell their thoughts and then you&#8217;ll give the attendees a survey to fill in.</p>\n\n\n\n<p>We did that every year and it turned out to be an amazing thing for the future reference. Team will also put up the handbook. They will put up the handbook of all the things that they&#8217;ve learned, challenges that they faced. What could be better, what could be improved? Because we have the internal P2 for organizers, for teams to communicate. So yeah, that&#8217;s their life, probably at next month. They would just like decompress and just all the thoughts put together in one place for the future organisers.</p>\n\n\n\n<p>[00:28:21] <strong>Nathan Wrigley:</strong> Are you here as an attendee this year? Or do you have any?</p>\n\n\n\n<p>[00:28:25] <strong>Milan Ivanovic:</strong> Yeah, well, I&#8217;m, I&#8217;m speaking, I&#8217;m speaking because, we started that and I love that rule actually. Whoever was like the global lead for the previous year, you&#8217;ll be like the keynote, speaker for the next WordCamp Europe. Like on track one, you&#8217;ll do the talk. My talk was about community and I knew that it&#8217;s going to be emotional.</p>\n\n\n\n<p>But I never knew it&#8217;s going to be this emotional. Yeah. So yeah, I had, I had tears, but I&#8217;m proud of those. It was emotional talk because those are all the things that I&#8217;m super passionate about. I&#8217;m super passionate about diversity. I&#8217;m super passionate about community in general. I&#8217;m super passionate about changing myself first and then helping change community for better.</p>\n\n\n\n<p>So many times, so many stories that I&#8217;ve heard about people just like attending one single meetup, and then they realize that, you know what, this is good. This is a solid foundation for the career change or changing life. I had one guy in Serbia attended our meetups. He was a hairdresser and I knew his face.</p>\n\n\n\n<p>He was constantly attending our meetups, but he was always super silent. He&#8217;s like, no, no, no. All good. I&#8217;m just like listening to talks. But he&#8217;s a good guy. So after two years he switched roles and he said like, finally, I&#8217;m doing the front end work. I got my first job. Thank you so much.</p>\n\n\n\n<p>Thanks to community. It changed me in so many levels. So I did this talk and I completely stopped because all those images flashed in front of my eyes. I have slide that how many, uh, how much this community and being involved, this whole involvement changed me as a person. I had all these images just like flashing because I&#8217;ve been through some like tough times, like everyone.</p>\n\n\n\n<p>And then I knew how much this whole community&#8217;s been listening and helping, supportive. And I basically stopped just like froze at the stage. I&#8217;m like, oh my God, I&#8217;m gonna cry. You&#8217;re not gonna cry. You&#8217;re gonna continue. I got the applause and just like, and that&#8217;s the support I&#8217;m talking about, and I continued, but really personal talk for me and I loved it. I loved the subject that I was sharing and, people say that I&#8217;m quite passionate and that can, I can make something happen.</p>\n\n\n\n<p>[00:30:47] <strong>Nathan Wrigley:</strong> Final question. And it&#8217;s a quick one. Will you be back next year?</p>\n\n\n\n<p>[00:30:52] <strong>Milan Ivanovic:</strong> Oh yeah. Oh yeah.</p>\n\n\n\n<p>[00:30:54] <strong>Nathan Wrigley:</strong> Milan. Thank you for chatting to me today.</p>\n\n\n\n<p>[00:30:56] <strong>Milan Ivanovic:</strong> Thanks so much Nathan for having me.</p>\n</div>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Wed, 22 Jun 2022 14:00:00 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:14:\"Nathan Wrigley\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:8;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:61:\"Do The Woo Community: Meet Silvana Pop, First-Time WordCamper\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:28:\"https://dothewoo.io/?p=72037\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:59:\"https://dothewoo.io/meet-silvana-pop-first-time-wordcamper/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:392:\"<p>There is always that first WordCamp experience. In this short BuilderByte, meet Silvana who attended WordCamp Europe.</p>\n<p>&gt;&gt; The post <a rel=\"nofollow\" href=\"https://dothewoo.io/meet-silvana-pop-first-time-wordcamper/\">Meet Silvana Pop, First-Time WordCamper</a> appeared first on <a rel=\"nofollow\" href=\"https://dothewoo.io\">Do the Woo - a WooCommerce Builder Community</a>	.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Wed, 22 Jun 2022 10:45:00 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:5:\"BobWP\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:9;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:84:\"Do The Woo Community: Building Data Driven Content Personas for WooCommerce Builders\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:28:\"https://dothewoo.io/?p=72015\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:58:\"https://dothewoo.io/building-data-driven-content-personas/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:390:\"<p>Even developers, freelancers and agencies need to create their content persona the right way.</p>\n<p>&gt;&gt; The post <a rel=\"nofollow\" href=\"https://dothewoo.io/building-data-driven-content-personas/\">Building Data Driven Content Personas for WooCommerce Builders</a> appeared first on <a rel=\"nofollow\" href=\"https://dothewoo.io\">Do the Woo - a WooCommerce Builder Community</a>	.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Wed, 22 Jun 2022 09:15:00 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:5:\"BobWP\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:10;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:94:\"WPTavern: Elementor Lays Off 15% of Workforce, Citing Rising Inflation and Impending Recession\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:30:\"https://wptavern.com/?p=135347\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:103:\"https://wptavern.com/elementor-lays-off-15-of-workforce-citing-rising-inflation-and-impending-recession\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:4320:\"<p>With inflation rising and the unemployment rate falling, economic forecasters are <a href=\"https://fortune.com/2022/04/09/why-wall-street-predicting-recession-2023-federal-reserve-inflation-unemployment-yield-curve-carl-icahn/\">predicting an impending recession</a> in 2023. A few major WordPress companies are tightening their belts ahead of what many believe will be an unavoidable economic downturn.  </p>\n\n\n\n<p>Elementor announced that it is laying off 60 employees, 15% of its workforce, in a tightly controlled release of information to <a href=\"https://en.globes.co.il/en/article-elementor-begins-laying-off-15-of-workforce-1001415176\">Globes</a>, an Israeli business newspaper. Co-founder and CEO Yoni Luksenberg gave the following statement: </p>\n\n\n\n<blockquote class=\"wp-block-quote\"><p> “Today, we make the difficult decision to say goodbye to some of our colleagues. We are in a changing global situation with rising inflation and a pending recession. To ensure the efficiency and effectiveness of our business, we are restructuring and optimizing our workforce, becoming more efficient in certain areas and continuing to grow our product offerings, to secure the company’s long-term success, growth and business goals as we plan for 2023 and beyond.&#8221;</p></blockquote>\n\n\n\n<p>The Globes article states that &#8220;most of the layoff will be in the company&#8217;s marketing department and will apparently not effect engineers and development staff.&#8221; Elementor has raised a total of $65M across three funding rounds since 2017, but the Globes&#8217; statement fueled speculation about why their marketing department had such a large number of employees available to be cut.</p>\n\n\n\n<div class=\"wp-block-embed__wrapper\">\n<blockquote class=\"twitter-tweet\"><p lang=\"en\" dir=\"ltr\">The other way around probably. Less money spent on people means more money to spend on ads <img src=\"https://s.w.org/images/core/emoji/14.0.0/72x72/1f926-200d-2642-fe0f.png\" alt=\"🤦‍♂️\" class=\"wp-smiley\" /></p>&mdash; Robert DeVore (@deviorobert) <a href=\"https://twitter.com/deviorobert/status/1537185187133411328?ref_src=twsrc%5Etfw\">June 15, 2022</a></blockquote>\n</div>\n\n\n\n<p>Earlier this month, <a href=\"https://wptavern.com/elementor-acquires-strattic\">Elementor acquired Strattic</a>, a static and headless WordPress hosting company. A representative from Elementor confirmed that no Strattic team employees were affected by the layoffs. The company declined to answer specific questions about whether all the discharged employees belonged to the marketing department or if developers were included among them. </p>\n\n\n\n<p>Elementor&#8217;s former VP of Marketing, Yam Regev was not one of those cut from the company during the layoffs. Regev resigned a few weeks ahead of a large swath of the marketing team getting cut. He declined to comment on the layoffs but <a href=\"https://www.linkedin.com/feed/update/urn:li:activity:6942403165312925696/\">posted</a> on LinkedIn that &#8220;the decision to move on is pragmatic and ego-less on such a level that I feel it is purely professional.&#8221;</p>\n\n\n\n<p>Envato, the Australia-based digital assets company that sells thousands of WordPress products, has also recently <a href=\"https://www.afr.com/technology/rich-listers-envato-lays-off-100-staff-and-rejigs-product-focus-20220605-p5ar5o\">laid off 100 of its 700 employees</a>, roughly the same percentage as Elementor. </p>\n\n\n\n<p>“We were spread too thin across all of these products we’d established,” Envato CEO Hichame Assi told told&nbsp;The Australian Financial Review.</p>\n\n\n\n<p>“They’re all creative products, but some are older with legacy platforms, whereas some are newer and going really well. We wanted to sharpen focus on our future products that are going really well.”</p>\n\n\n\n<p>Assi also cited global conflicts and inflation as factors affecting the company.</p>\n\n\n\n<p>“There’s been flow on effects in markets like Europe and the US, and there has also been a pull down from inflation that has not helped as well,” Assi said.</p>\n\n\n\n<p>These WordPress product companies join Netflix, Tesla, Coinbase, Zumper, Wealthsimple, Notarize, and many others in <a href=\"https://techcrunch.com/2022/06/17/layoffs-crypto-real-estate-tech-june/\">widespread tech layoffs</a>.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Tue, 21 Jun 2022 20:28:48 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Sarah Gooding\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:11;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:91:\"Do The Woo Community: Bringing Multilingual to WordPress and WooCommerce with Augustin Prot\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:28:\"https://dothewoo.io/?p=72025\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:90:\"https://dothewoo.io/bringing-multilingual-to-wordpress-and-woocommerce-with-augustin-prot/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:464:\"<p>Augustin Prot from Weglot joined us at WordCamp Europe to talk about community and multilingual WordPress and WooCommerce sites.</p>\n<p>&gt;&gt; The post <a rel=\"nofollow\" href=\"https://dothewoo.io/bringing-multilingual-to-wordpress-and-woocommerce-with-augustin-prot/\">Bringing Multilingual to WordPress and WooCommerce with Augustin Prot</a> appeared first on <a rel=\"nofollow\" href=\"https://dothewoo.io\">Do the Woo - a WooCommerce Builder Community</a>	.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Tue, 21 Jun 2022 09:10:00 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:5:\"BobWP\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:12;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:89:\"WPTavern: WordPress.org Strongly Urges Theme Authors to Switch to Locally Hosted Webfonts\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:30:\"https://wptavern.com/?p=134958\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:100:\"https://wptavern.com/wordpress-org-strongly-urges-theme-authors-to-switch-to-locally-hosted-webfonts\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:4633:\"<p>In light of a recent German court case, which <a href=\"https://wptavern.com/german-court-fines-website-owner-for-violating-the-gdpr-by-using-google-hosted-fonts\">fined a website owner for violating the GDPR by using Google-hosted webfonts</a>, WordPress.org&#8217;s themes team is updating its recommendations for hosting webfonts. Most theme authors have been enqueuing Google Fonts from the Google CDN for better performance, but this method exposes visitors&#8217; IP addresses.</p>\n\n\n\n<p>&#8220;The themes team strongly encourages the theme authors to update their themes,&#8221; Themes Team representative @benachi said in a recent <a href=\"https://make.wordpress.org/themes/2022/06/18/complying-with-gdpr-when-using-google-fonts/\">announcement</a>. &#8220;We recommend updating by switching to locally hosted webfonts. Luckily Google Fonts can be downloaded and bundled in a theme. Bundled font files allow users to host webfonts locally and comply with GDPR.&#8221;</p>\n\n\n\n<p>The Themes Team is also considering banning remotely hosted fonts moving forward and will discuss at the next meeting. </p>\n\n\n\n<p>Core contributors are now working on <a href=\"https://core.trac.wordpress.org/ticket/55985\">updating all the default themes</a> from Twenty Twelve through Twenty Seventeen to use locally hosted webfonts. The task had previously been discussed but was renewed by <a href=\"https://de.wordpress.org/support/topic/google-fonts-werde-hier-abgemahnt-twentyseventeen-fonts/\">a recent topic in the German support forums</a>. A user created a small website using the Twenty Seventeen theme and said he has been threatened by a site visitor who cited the German court ruling. The ruling threatens a fine of €250,000.00 for each case of infringement or, alternatively, six months imprisonment, if the site owner does not comply and continues to provide Google with IP addresses through their use of Google Fonts.</p>\n\n\n\n<p>&#8220;While in the newer default themes fonts got added as an asset, the older default themes remained untouched,&#8221; WordPress contributor Jessica Lyschik said. &#8220;This can cause issues with users not being aware of both the legal stuff and the fact that Google Fonts are directly used in default themes.</p>\n\n\n\n<p>&#8220;We think while it is still widely among plugins and other themes to use Google Fonts directly, the default themes of WordPress should be able to used risk-free and compliant with the GDPR.&#8221;</p>\n\n\n\n<p>The Themes Team recommends authors refer to the <a href=\"https://wordpress.org/themes/twentytwentytwo/\">Twenty Twenty-Two</a> theme to learn how to bundle locally hosted webfont files using&nbsp;<code>theme.json</code>. Another option, for those using functions.php, is to follow the <a rel=\"noreferrer noopener\" href=\"https://make.wordpress.org/core/2021/09/28/implementing-a-webfonts-api-in-wordpress-core/\" target=\"_blank\">Implementing a Webfonts API in WordPress Core</a>&nbsp;tutorial.</p>\n\n\n\n<p>Many theme authors may not update their themes until forced to by a ban from WordPress.org. In the meantime, users might consider adding a plugin to host webfonts locally. WordPress developer Xaver Birsak has created a small single-purpose plugin called <a href=\"https://wordpress.org/plugins/local-google-fonts/\">Local Google Fonts</a> that automatically detects Google font sources and gives users the option to download them and use them locally.</p>\n\n\n\n<img />Local Google Fonts admin screen\n\n\n\n<p>This plugin checks for fonts embedded via <a href=\"https://developer.wordpress.org/reference/functions/wp_enqueue_style/\"><code>wp_enqueue_style</code></a>. Users who are embedding Google fonts via <code>@import</code> will need to change that before using the plugin. It currently auto downloads new font versions if available. Birsak has created it as a set-it-and-forget it kind of plugin. This may be a good option for non-technical users who have a theme that hasn&#8217;t yet been updated by the author. <a href=\"https://wordpress.org/plugins/local-google-fonts/\">Local Google Fonts</a> is available for free on WordPress.org. </p>\n\n\n\n<p>Another free plugin option on WordPress.org is the <a href=\"https://wordpress.org/plugins/host-webfonts-local/\">OMGF | Host Google Fonts Locally</a> plugin, which has a few additional features. It preloads fonts to reduce Cumulative Layout Shift above the fold, unloads fonts that are not used by the theme or plugins, allows users to set a fallback font stack, and will replace font-families with system fonts to speed up loading times. A commercial version offers multisite support and more advanced features.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Mon, 20 Jun 2022 22:45:16 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Sarah Gooding\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:13;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:85:\"WPTavern: WordPress.org Forces Security Update for Critical Ninja Forms Vulnerability\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:30:\"https://wptavern.com/?p=135341\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:96:\"https://wptavern.com/wordpress-org-forces-security-update-for-critical-ninja-forms-vulnerability\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:3390:\"<p>Late last week, Ninja Forms users received a forced security update from WordPress.org for a critical  PHP Object Injection vulnerability. This particular vulnerability can be exploited remotely without any authentication. It was publicly disclosed last week and patched in the latest version, 3.6.11. Patches were also backported to versions 3.0.34.2, 3.1.10, 3.2.28, 3.3.21.4, 3.4.34.2, and 3.5.8.4.</p>\n\n\n\n<p>Wordfence noticed a back-ported security update in the form builder plugin, which has more than a million active installs. Threat analyst Chloe Chamberland explained the vulnerability in an <a href=\"https://www.wordfence.com/blog/2022/06/psa-critical-vulnerability-patched-in-ninja-forms-wordpress-plugin/\">advisory</a> alerting the company&#8217;s users:  </p>\n\n\n\n<blockquote class=\"wp-block-quote\"><p>We uncovered a code injection vulnerability that made it possible for unauthenticated attackers to call a limited number of methods in various Ninja Forms classes, including a method that unserialized user-supplied content, resulting in Object Injection. This could allow attackers to execute arbitrary code or delete arbitrary files on sites where a separate POP chain was present.</p></blockquote>\n\n\n\n<p>The vulnerability affects Ninja Forms&#8217; &#8220;Merge Tags&#8221; feature that auto-populates values from Post IDs and usernames, for example. Wordfence threat analyst Ramuel Gall reverse engineered the vulnerability&#8217;s patches to create a working proof of concept. He found that it is possible to call various Ninja Forms classes that could be used for a wide range of exploits, including complete site takeover. Chamberland reports there is evidence to suggest the vulnerability is being actively exploited in the wild.</p>\n\n\n\n<p>WordPress.org&#8217;s forced security updates are a mitigation effort used in rare instances where the vulnerability is particularly severe and affects a large number of users. More than 680,000 sites were updated on June 14. This PHP object injection vulnerability scores 9.8 on the Common Vulnerability Scoring System, but it has not yet been given a CVE ID. </p>\n\n\n\n<img />\n\n\n\n<p>Reviewing <a href=\"https://www.cvedetails.com/vulnerability-list/vendor_id-15289/product_id-31215/Ninjaforms-Ninja-Forms.html\">previous CVE ID&#8217;s</a> for Ninja Forms, this is the most severe vulnerability in the plugin&#8217;s history. Ninja Forms&#8217; changelog doesn&#8217;t communicate the severity of the threat, categorizing it as a &#8220;security enhancement:&#8221;</p>\n\n\n\n<blockquote class=\"wp-block-quote\"><p>3.6.11 (14 JUNE 2022)</p><p><em>Security Enhancements</em><br />* Apply more strict sanitization to merge tag values</p></blockquote>\n\n\n\n<p>Ninja Forms did not post about the security update on its blog or social media accounts.  Wordfence plans to update the text of its <a href=\"https://www.wordfence.com/blog/2022/06/psa-critical-vulnerability-patched-in-ninja-forms-wordpress-plugin/\">advisory</a> as the company learns more about how attackers are exploiting the vulnerability.  Ninja Forms users should check their sites to ensure the automatic security update went through. This update comes just one week after Ninja Forms <a href=\"https://wpscan.com/vulnerability/795acab2-f621-4662-834b-ebb6205ef7de\">patched</a> a less severe, authenticated stored cross-site scripting (XSS) vulnerability on June 7. </p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Mon, 20 Jun 2022 19:35:41 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Sarah Gooding\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:14;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:78:\"Do The Woo Community: devlife-snippet: Writing as a Developer, the Soft Skills\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:28:\"https://dothewoo.io/?p=71893\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:75:\"https://dothewoo.io/devlife-snippet-writing-as-a-developer-the-soft-skills/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:465:\"<p>Developers who have learned and grown their writing skills may question themselves whether those writing skills have a direct impact for them as a developer.</p>\n<p>&gt;&gt; The post <a rel=\"nofollow\" href=\"https://dothewoo.io/devlife-snippet-writing-as-a-developer-the-soft-skills/\">devlife-snippet: Writing as a Developer, the Soft Skills</a> appeared first on <a rel=\"nofollow\" href=\"https://dothewoo.io\">Do the Woo - a WooCommerce Builder Community</a>	.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Mon, 20 Jun 2022 09:00:00 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:5:\"BobWP\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:15;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:101:\"Gutenberg Times: 84 Block Themes, Reusable Blocks, Create-Block-Theme-Plugin – Weekend Edition #219\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:35:\"https://gutenbergtimes.com/?p=21360\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:105:\"https://gutenbergtimes.com/84-block-themes-reusable-blocks-create-block-theme-plugin-weekend-edition-219/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:18225:\"<p>Howdy, </p>\n\n\n\n<p>Summer is almost here! I love the warmer days, but the heat wave making its way through Europe is brutal. Stay safe and keep cool, please. </p>\n\n\n\n<p>This week, the usual business set in again and we have ton of great articles and products to link to. </p>\n\n\n\n<p>Have a great weekend! </p>\n\n\n\n<p><br />Yours, 💕<br />Birgit</p>\n\n\n\n<p>PS: Don&#8217;t miss it: </p>\n\n\n\n<p>July 22 at 11 am EDT / 15:00 UTC Gutenberg Times Live Q &amp; A:  <a href=\"https://us02web.zoom.us/webinar/register/7216548519021/WN_Af50AS7VQbuyCrUdQnormw\"><strong>Block First Approach at the Pew Research Center</strong>,</a> we will discuss with <strong>Seth Rubinstein</strong>, Lead Developer, and <strong>Michael Piccorossi</strong>, Director of Digital Strategy, how they use a mixture of Core and Custom Blocks to streamline their publishing process, and to create powerful charts and quizzes for the Pew Research Center. <a href=\"https://us02web.zoom.us/webinar/register/7216548519021/WN_Af50AS7VQbuyCrUdQnormw\">Join us!</a></p>\n\n\n\n<a href=\"https://us02web.zoom.us/webinar/register/7216548519021/WN_Af50AS7VQbuyCrUdQnormw\"><img /></a>\n\n\n\n\n<div class=\"wp-container-1 wp-block-group has-light-background-background-color has-background\"><div class=\"wp-block-group__inner-container\">\n<p><strong>Table of Contents</strong></p>\n\n\n\n<div class=\"wp-block-sortabrilliant-guidepost\"><ul><li><a href=\"https://gutenbergtimes.com/feed/#0-word-press-team-updates-around-the-block-editor\">WordPress team updates around the Block editor</a></li><li><a href=\"https://gutenbergtimes.com/feed/#1-content-creators-and-site-builders\">NoCode Site builders and Content Creators using Gutenberg</a></li><li><a href=\"https://gutenbergtimes.com/feed/#2-d\">Developing with Gutenberg and building blocks</a></li><li><a href=\"https://gutenbergtimes.com/feed/#3-theme-building-for-blocks-and-full-site-editing\">Theme Building for Blocks and Full-site Editing. </a></li><li><a href=\"https://gutenbergtimes.com/feed/#2-word-press-events\">WordPress Events</a><ul><li><a href=\"https://gutenbergtimes.com/feed/#5-s\">Social Learning Spaces</a></li><li><a href=\"https://gutenbergtimes.com/feed/#3-page-builder-summit-start-monday\">Page Builder Summit starts Monday! </a></li></ul></li></ul></div>\n</div></div>\n\n\n\n\n<h2 id=\"0-word-press-team-updates-around-the-block-editor\">WordPress team updates around the Block editor</h2>\n\n\n\n<p>In his latest video, <a href=\"https://www.youtube.com/watch?v=qn-tjjnyvYk\"><strong>Core Developer reviews WordPress 6.0 &#8211; see his top 3 feature picks,</strong></a> <strong>Dave Smith</strong> talked to Adam Zielinski, Editor release lead for, to get the low down on the latest release of the software. They covered features of WordPress 6.0, and discussed the the responsibilities and challenges of being release lead. Smith and Zielinski also touched on the project wide discussion around experimental APIs in Gutenberg.</p>\n\n\n\n<hr class=\"wp-block-separator has-alpha-channel-opacity is-style-wide\" />\n\n\n\n<p><a href=\"https://wordpress.org/gutenberg/\"><strong>Gutenberg Landing Page</strong></a> received a major overhaul. <strong>Steven Dufrensne</strong> just <a href=\"https://make.wordpress.org/meta/2022/06/16/gutenberg-landing-page-launched/\">announced taking the site live</a>. Designer Beatriz Fialho started working on the <a href=\"https://make.wordpress.org/design/2021/10/29/redesign-of-the-gutenberg-page/\">Redesign</a> back in October 2021. &#8220;Now that&nbsp;Gutenberg&nbsp;has been a part of WordPress for a few years, it makes sense to update it, shifting the message from what used to be the new post editor to the editor that can power all parts of your site.&#8221; Fialho wrote in her earlier post. </p>\n\n\n\n<p>Such an undertaking takes a whole team. It also needs maintenance and if you want to contribute, the <a href=\"https://github.com/WordPress/wporg-gutenberg\">theme repo is available on GitHub</a>. What do you think about the new Gutenberg Landing page? Please share in the comments on the <a href=\"https://make.wordpress.org/meta/2022/06/16/gutenberg-landing-page-launched/\">post</a>.</p>\n\n\n\n<hr class=\"wp-block-separator has-alpha-channel-opacity is-style-wide\" />\n\n\n\n<p><strong>Matias Ventura</strong> published his <a href=\"https://make.wordpress.org/design/2022/06/13/thinking-through-the-wordpress-admin-experience/\"><strong>thinking through the WordPress Admin experience</strong></a> following some lessons learned from the Site editor menu designs and behavior. <br />&#8220;Given the&nbsp;<a href=\"https://wordpress.org/about/roadmap/\">third phase of the current WordPress roadmap</a>&nbsp;has a focus around workflows and multiplayer, considerations around the various admin flows become all the more important.&#8221; he explained. The post takes a look at the various aspects: </p>\n\n\n\n<p><strong>Shell and Canvas</strong> &#8211; a full-screen view as the default experience with sub-menus sliding in and out of the screen. That way the admin can also give access to out of context information or configurations. The&nbsp;<strong>shell</strong>&nbsp;as awayfinder with drill-down panels and the&nbsp;<strong>canvas</strong>&nbsp;as the place to browse, manage, edit, customize.</p>\n\n\n\n<p><strong>The Home Button</strong> as it is now in the Dashboard or the Site editor has different targets, and it&#8217;s a place for confusion with many users. It&#8217;s meant to be a place to espace the inner most focus, and go one level higher. Hopefully with some breadcrumps to show the location clearly. &#8220;The aim of this interface element is to both give control and build familiarity to navigate away from any context.&#8221; Ventura wrote. </p>\n\n\n\n<p><strong>Make it&nbsp;Extensible</strong> is the headline of the next section. Given the nature of WordPress as extensible plattform for website, and its promise of backwards compatibility,  this seems like a given. I</p>\n\n\n\n<p>I am particularily intrigued by the contemplations around <strong>&#8220;Make it Personal&#8221;.</strong> Customization of the Admin menu has long been plugin territory, and it would be great if that can become built-in functionality as it would also come with standards and guard rails for plugins and themes. Each user should be able to hide/show specific menu items they need. I would love the &#8220;recently visited areas as some sort of stack&#8221; feature. Most of the time, i only do a few things on certain web sites, and if those activities could be available as Quick links that would be fabulous. </p>\n\n\n\n<p>There are more sections in these early sharing of creative thinking about the future WPAdmin. There is certainly nothing set in stone or even remotely concrete available, but it&#8217;s worth reading and also sharing your opinion on the post. </p>\n\n\n\n<div class=\"wp-container-2 wp-block-group has-light-background-background-color has-background\"><div class=\"wp-block-group__inner-container\">\n<p><strong>🎙️ </strong> New episode: <a href=\"https://gutenbergtimes.com/podcast/gutenberg-changelog-68-wordcamp-europe-gutenberg-13-4-and-wordpress-6-1/\">Gutenberg Changelog #68 –  WordCamp Europe, Gutenberg 13.4 and WordPress 6.1</a> with Birgit Pauli-Haack and Mary Job, and special guest: Dave Smith </p>\n</div></div>\n\n\n\n\n<p><strong>&nbsp;<a href=\"https://make.wordpress.org/core/handbook/references/keeping-up-with-gutenberg-index/\" target=\"_blank\" rel=\"noreferrer noopener\">&#8220;Keeping up with Gutenberg &#8211; Index 2022&#8221;</a>&nbsp;</strong><br />A chronological list of the WordPress Make Blog posts from various teams involved in Gutenberg development: Design, Theme Review Team, Core Editor, Core JS, Core CSS, Test and Meta team from Jan. 2021 on. Updated by yours truly.  <a href=\"https://make.wordpress.org/core/handbook/references/keeping-up-with-gutenberg-index/keeping-up-with-gutenberg-index-2020/\"><em>The index 2020 is here</em></a></p>\n\n\n\n\n<h2 id=\"1-content-creators-and-site-builders\">NoCode Site builders and Content Creators using Gutenberg</h2>\n\n\n\n<p><strong><a href=\"https://twitter.com/dumitru\">Dumitru Brînzan</a></strong> published a post on how <a href=\"https://www.ilovewp.com/wordpress-reusable-blocks-detailed-guide/\"><strong>Reusable Blocks will change the way you create WordPress websites</strong></a>. It not a quick mention of this powerful feature, but a step-by-step tutorial that will help you streamline your creation processes and speed up your idea to publish time. Brînzan&#8217;s biggest give away is a list of use cases and how to accomplish those with Reusable block. The 11 minute-video add great demos to the written guide. </p>\n\n\n\n<hr class=\"wp-block-separator has-alpha-channel-opacity is-style-wide\" />\n\n\n\n<p>Speaking of Guide, <a href=\"https://twitter.com/karks88\"><strong>Eric Karkovack</strong></a>&nbsp;published <a href=\"https://speckyboy.com/choosing-the-right-wordpress-block-plugins/\"><strong>A Guide to Choosing the Right WordPress Block Plugins</strong></a>. Many Block collections plugins were published in the early years of the Block editor, as core blocks were lacking basic customizations features. Now that the block editor matured, Karkovack walk you through the decision making process on how to select the right extensions for your site. </p>\n\n\n\n<hr class=\"wp-block-separator has-alpha-channel-opacity is-style-wide\" />\n\n\n\n<p>It&#8217;s been a while since we reported on new <strong>Themes in the WordPress.org repository featuring Full-Site Editing.</strong> Today&#8217;s count is 84. </p>\n\n\n\n<p>Among the newest addition are two themes from the team at Extendify. </p>\n\n\n\n<p>The first one is called <strong>Extendable</strong>,  &#8220;a distinct, dynamic block theme designed as a canvas for your next online venture. Sporting multiple style variations, Extendable is the most expressive block theme yet. Go fresh, bold, bohemaian or minimal.&#8221; Or so they say. It does have 12 Style variations some of them quite intriguing with great harmony of fonts and color, some are less engaging.  </p>\n\n\n\n<p>The second theme is called Wei and it comes from the experience block and theme builder <strong>Rich Tabor</strong>, head of product at Extendify. He writes about his theme &#8221;&nbsp;a minimal block theme inspired by entirely by simplicity. Embracing clean type, beautifully bold color schemes, and color-matched featured images&#8221;. Tabor goes into more detail in his post: <a href=\"https://richtabor.com/wei/\"><strong>Introducing Wei, a minimalistic block theme with gobs of creativity</strong></a>. Or you can check out this <a href=\"https://twitter.com/richard_tabor/status/1537397184118890503\">Twitter thread</a></p>\n\n\n\n<img />\n\n\n\n<hr class=\"wp-block-separator has-alpha-channel-opacity is-style-wide\" />\n\n\n\n<p>On WordPress.tv, you can find the newests recording of the WordPress Social Learning event with <strong><a href=\"https://twitter.com/nickmdiego\">Nick Diego</a> </strong><a href=\"https://wordpress.tv/2022/06/16/nick-diego-builder-basics-lets-build-a-custom-theme-no-coding-required/\"><strong>Builder Basics – Let’s Build a Custom Theme (No Coding Required)</strong></a>. Diego took the Twenty Twenty-Two theme and fully customized it using the Site Editor and Global Styles. He make template chnages, updated the color pallete and the layout. The he exported these changes into a complete new theme. </p>\n\n\n\n<h2 id=\"2-d\">Developing with Gutenberg and building blocks</h2>\n\n\n\n<p><strong><a href=\"https://twitter.com/kathyzant\">Kathy Zant</a></strong> explains in her post <a href=\"https://www.zant.com/why-wordpress-in-2022-full-site-editing-vs-dynamic-templating/\"><strong>Full Site Editing vs. Dynamic Templating</strong></a>, when she prefers to use the block editor and when ACF and template for the custom fields are better for her needs. </p>\n\n\n\n<hr class=\"wp-block-separator has-alpha-channel-opacity is-style-wide\" />\n\n\n\n<p><strong>Tuan Nguyen</strong>, a full-stack LAMP developer from California, dives into the details of his decision making process on <strong><a href=\"https://www.webdevelopertuan.com/gutenberg-block-editor-when-to-use-editor-versus-css-styles/\">When to Use Editor Versus CSS Styles</a></strong>. Nguyen walks you through the various aspects on styling blocks, how to override the Global Styles for core blocks, how to adjust styling for Custom HTML Blocks or how apply mobile styles via Media queries. It&#8217;s a great introduction. </p>\n\n\n\n\n<p><strong><a href=\"https://gutenbergtimes.com/need-a-zip-from-master/\">Need a plugin .zip from Gutenberg&#8217;s master branch?</a></strong><br />Gutenberg Times provides daily build for testing and review. <br />Have you been using it? Hit reply and let me know.</p>\n\n\n\n<p><img alt=\"GitHub all releases\" src=\"https://img.shields.io/github/downloads/bph/gutenberg/total?style=for-the-badge\" /></p>\n\n\n\n\n<h2 id=\"3-theme-building-for-blocks-and-full-site-editing\">Theme Building for Blocks and Full-site Editing. </h2>\n\n\n\n<p>If you want to learn more about Style Variations, that came to WordPress 6.0 check out Rich Tabor&#8217;s article: <a href=\"https://richtabor.com/wordpress-style-variations/\"><strong>How to add style variations to WordPress Block Themes</strong></a>. &#8220;Just because a method of defining a theme style is standardized, doesn’t mean the styles themselves are.&#8221;.</p>\n\n\n\n<hr class=\"wp-block-separator has-alpha-channel-opacity is-style-wide\" />\n\n\n\n<p>About four weeks ago, in Weekend Edition 215, I shared <a href=\"https://gutenbergtimes.com/three-block-theme-generators-gutenberg-13-2-coupons-with-blocks-and-more-weekend-edition-215/#0-block-theme-generators\">three block theme generator</a> provided by members of the larger WordPress Community. Today, a new plugin from WordPress contributors went live the plugin repository: the <a href=\"https://wordpress.org/plugins/create-block-theme/\"><strong>Create-Block Theme</strong></a> plugin. This plugin provides tools to enable theme builders to create block themes. There are four different ways of using it: </p>\n\n\n\n<ol><li><strong>Export</strong>: The current theme gets exported as a zip file, along with the user’s changes. This is essentially the same as the export option in the Site Editor</li><li><strong>Create a child theme</strong><br />Creates a new child theme with the currently activated theme as a parent.</li><li><strong>Clone the current theme</strong><br />Creates a new theme by cloning the activated theme. The resulting theme will have all of the assets of the activated theme combined with the user’s changes.</li><li><strong>Overwrite theme files</strong><br />Saves user’s changes to the theme files and deletes the user’s changes.</li></ol>\n\n\n\n<p>It&#8217;s in its first version. The team would appreciate some more testing and <a href=\"https://github.com/WordPress/create-block-theme\">start discussions on GitHub issues</a> or send in your PRs. </p>\n\n\n\n<h2 id=\"2-word-press-events\">WordPress Events</h2>\n\n\n\n<h3 id=\"5-s\">Social Learning Spaces</h3>\n\n\n\n<p>June 27, 2022 &#8211; 1 pm EDT /  17:00 UTC<br /><strong><a href=\"https://www.meetup.com/wordpress-social-learning/events/286560368/\">Hello Blocks! Coding a custom block</a></strong> with Ryan Welcher</p>\n\n\n\n<p>July 4, 2022 5 pm EDT / 21:00 UTC <br /><a href=\"https://www.meetup.com/wordpress-social-learning/events/286558681/\"><strong>Using Block Patterns</strong></a> with Wes Theron</p>\n\n\n\n<p>July 12, 2022, 5 pm EDT / 21:00 UTC<br /><strong><a href=\"https://www.meetup.com/wordpress-social-learning/events/286603818/\">Explore the Block Directory</a></strong> with Wes Theron</p>\n\n\n\n<h3 id=\"3-page-builder-summit-start-monday\">Page Builder Summit starts Monday! </h3>\n\n\n\n<p>Here is a selection from <a href=\"https://pagebuildersummit.com/\">the schedule</a> of Gutenberg talks. </p>\n\n\n\n<ul><li>Jun 20 &#8211; 8 am EDT / 12:00 UTC &#8211; <strong>Gutenberg, Full Site Editing and WooCommerce</strong> with Jamie Marsland </li><li>Jun 20 &#8211; 2 pm EDT / 18:00 UTC <strong>Creating Effective WooCommerce Sites with Kadence Blocks Template</strong> w/ Ben Ritner</li><li>Jun 22- 10 am EDT / 14:00 UTC <strong>It’s Time to Get Serious About Full Site Editing</strong> w/ Nick Diego </li><li>Jun 23 &#8211; 11 EDT 15:00 UTC <strong>Creating Dynamic Content with Kadence Blocks</strong> w/ Kathy Zant </li><li>Jun 24 8am EDT / 12:00 UTC <strong>Pagebuilders in a world of Full Site Editing and Block</strong>s w/ Jakob Trost </li><li>Jun 24 &#8211; 10 am EDT / 14:00 UTC <strong>The Full Site Editor and the Cwicly Toolkit </strong>with David McCan </li></ul>\n\n\n\n<p></p>\n\n\n\n\n<p>Featured Image: &#8220;<a href=\"https://www.flickr.com/photos/73645804@N00/2475349116\" target=\"_blank\" rel=\"noreferrer noopener\">Pablo&#8217;s cubism period began at three</a>&#8221; by&nbsp;<a href=\"https://www.flickr.com/photos/73645804@N00\" target=\"_blank\" rel=\"noreferrer noopener\">woodleywonderworks</a>&nbsp;is licensed under&nbsp;<a href=\"https://creativecommons.org/licenses/by/2.0/?ref=openverse\" target=\"_blank\" rel=\"noreferrer noopener\">CC BY 2.0</a>.</p>\n\n\n\n<hr class=\"wp-block-separator has-css-opacity is-style-wide\" />\n\n\n\n<p class=\"has-text-align-left\"><strong>Don&#8217;t want to miss the next Weekend Edition? </strong></p>\n\n\n\n<form class=\"wp-block-newsletterglue-form ngl-form ngl-portrait\" action=\"https://gutenbergtimes.com/feed/\" method=\"post\"><div class=\"ngl-form-container\"><div class=\"ngl-form-field\"><label class=\"ngl-form-label\" for=\"ngl_email\"><br />Type in your Email address to subscribe.</label><div class=\"ngl-form-input\"><input type=\"email\" class=\"ngl-form-input-text\" name=\"ngl_email\" id=\"ngl_email\" /></div></div><button type=\"submit\" class=\"ngl-form-button\">Subscribe</button><p class=\"ngl-form-text\">We hate spam, too and won&#8217;t give your email address to anyone except Mailchimp to send out our Weekend Edition</p></div><div class=\"ngl-message-overlay\"><div class=\"ngl-message-svg-wrap\"></div><div class=\"ngl-message-overlay-text\">Thanks for subscribing.</div></div><input type=\"hidden\" name=\"ngl_list_id\" id=\"ngl_list_id\" value=\"26f81bd8ae\" /><input type=\"hidden\" name=\"ngl_double_optin\" id=\"ngl_double_optin\" value=\"yes\" /></form>\n\n\n\n<hr class=\"wp-block-separator has-css-opacity is-style-wide\" />\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Sat, 18 Jun 2022 11:17:00 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:18:\"Birgit Pauli-Haack\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:16;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:30:\"Post Status: Flooding the zone\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"https://poststatus.com/?p=99358\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:41:\"https://poststatus.com/flooding-the-zone/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:55:\"<strong>Why not take a nice long bath instead?</strong>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Fri, 17 Jun 2022 23:35:58 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:10:\"Dan Knauss\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:17;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:38:\"Post Status: Today in WordCamp History\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"https://poststatus.com/?p=99352\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:49:\"https://poststatus.com/today-in-wordcamp-history/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:254:\"Starting today and every day for the next year, I’ll be sharing 1-4 photos that appear on that day from the WP events I was at. I’ll tag the location and people there as well as I can. You can follow on Twitter @KitchensinkWP or at kitchensinkwp.com.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Fri, 17 Jun 2022 22:34:29 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:11:\"Adam Silver\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:18;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:44:\"Post Status: Not Dead Yet! Just Mostly Dead?\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"https://poststatus.com/?p=98849\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:53:\"https://poststatus.com/not-dead-yet-just-mostly-dead/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:411:\"Gutenberg 13.4 • Learning FSE sooner rather than later • Gutenberg in Tumblr and Day One • WordCamps and the vitality of the WordPress community • AUS WordPress community only mostly dead? • Get SEO Schema graphs • Web font loading geek out • PHP is 28! • PHP namespaces and autoloaders • You can work anywhere... why not Cleveland? • North Commerce — faster than the rest? • and more...\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Fri, 17 Jun 2022 20:00:16 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:12:\"David Bisset\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:19;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:71:\"Do The Woo Community: WooBits: WordCamp Europe Before, During and After\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:28:\"https://dothewoo.io/?p=71996\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:60:\"https://dothewoo.io/wordcamp-europe-before-during-and-after/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:399:\"<p>I had an amazing time at WordCamp Europe in Porto, Portugal. Here are some highlight around and during the event.</p>\n<p>&gt;&gt; The post <a rel=\"nofollow\" href=\"https://dothewoo.io/wordcamp-europe-before-during-and-after/\">WooBits: WordCamp Europe Before, During and After</a> appeared first on <a rel=\"nofollow\" href=\"https://dothewoo.io\">Do the Woo - a WooCommerce Builder Community</a>	.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Fri, 17 Jun 2022 16:58:29 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:5:\"BobWP\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:20;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:95:\"Post Status: Richard Midson on WordPress and the Future of Podcasting — Post Status Draft 116\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"https://poststatus.com/?p=99125\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:69:\"https://poststatus.com/richard-midson-wordpress-future-of-podcasting/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:118:\"Richard Midson of Automattic on the future of podcasting and the opportunities for WordPress as a podcasting platform.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Fri, 17 Jun 2022 14:11:13 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Olivia Bisset\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:21;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:43:\"Post Status: How Do We Get There From Here?\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"https://poststatus.com/?p=99139\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:53:\"https://poststatus.com/how-do-we-get-there-from-here/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:360:\"Our WordPress Podcast and Video Picks for the Week of June 13 🎙️ JavaScript development journeys • Questions coming out of WCEU • The WordPress toolkit for podcasters • How newcomers and outsiders view WordPress • Are WordPress developers \"real developers?\" • Gutenber changes • Dave Martin on WP.com • A Gutenberg roadmap for WordPress 6.1.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Fri, 17 Jun 2022 06:57:47 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:12:\"David Bisset\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:22;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:55:\"Post Status: This Week at WordPress.org (June 13, 2022)\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"https://poststatus.com/?p=99202\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:63:\"https://poststatus.com/this-week-at-wordpress-org-june-13-2022/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:319:\"Each week we are highlighting the news from WordPress.org that you don\'t want to miss. If you or your company create products or services that use WordPress, we\'ve got the news you need to know. Be sure to share this resource with your product and project managers. Are you interested in giving back and contributing...\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Wed, 15 Jun 2022 14:30:07 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:18:\"Courtney Robertson\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:23;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:88:\"WPTavern: #30 – Matt Mullenweg on the Future of Technology and Where WordPress Fits In\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:48:\"https://wptavern.com/?post_type=podcast&p=135311\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:102:\"https://wptavern.com/podcast/30-matt-mullenweg-on-the-future-of-technology-and-where-wordpress-fits-in\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:49712:\"<p>On the podcast today we have <a href=\"https://ma.tt/\">Matt Mullenweg</a>.</p>\n\n\n\n<p>Matt is the co-founder of WordPress, and as a result, he has been a user for as long as anyone.</p>\n\n\n\n<p>We recorded this podcast whilst at WordCamp Europe in Portugal a couple of weeks ago. It’s a wide-ranging discussion, covering a lot of ground.&nbsp;</p>\n\n\n\n<p>We start out with Matt’s reflections of WordPress at 19 years old. Which aspects of the project would he change if he had his time over, and which parts is he proud of?</p>\n\n\n\n<p>Did Covid, and the restrictions around community events, have an impact upon the project, given that much of the time dedicated to WordPress is done by volunteers? What lessons have we learned about events like WordCamp Europe?</p>\n\n\n\n<p>In recent news, and for the first time, there’s some data pointing to the fact that WordPress’ market share might have flattened out. Is this a cause for concern?</p>\n\n\n\n<p>Where are we at with WordPress right now, given that it’s changing the scope of what non-technical users can do with it out of the box?</p>\n\n\n\n<p>We then get into some more personal matters, including how Matt manages his time over the variety of projects he’s involved with, and does he regard advances in artificial intelligence as always positive?</p>\n\n\n\n<p>You might notice that the sound is a little patchy in places. This was a function of the environment we were in. There’s a few booms on the mic here and there, but it’s certainly listenable.</p>\n\n\n\n<h2>Useful links.</h2>\n\n\n\n<p><a href=\"https://wordpress.org/five-for-the-future/\">Five for the future</a></p>\n\n\n\n<p><a href=\"https://openai.com/blog/dall-e/\">DALL·E: Creating Images from Text</a></p>\n\n\n\n<p><a href=\"https://openai.com/api/\">OpenAI</a></p>\n\n\n\nTranscript<div>\n<p>[00:00:00] Welcome to the Jukebox podcast from WP Tavern. My name is Nathan Wrigley. Jukebox is a podcast, which is dedicated to all things WordPress, the people, the events, the plugins, the blocks, the themes, and in this case, the place of WordPress in the technology landscape.</p>\n\n\n\n<p>[00:00:38] If you&#8217;d like to subscribe to the podcast, you can do that by searching for WP Tavern in your podcast player of choice, or go to WP Tavern.com forward slash feed forward slash podcast. And you can copy that URL into most podcast players as well. If you have a topic that you&#8217;d like us to feature on the podcast well I&#8217;m very keen to hear from you and hopefully get you, or your idea featured on the show. Head to WP Tavern.com forward slash contact forward slash jukebox. And use the contact form there.</p>\n\n\n\n<p>[00:01:13] So on the podcast today. We have Matt Mullenweg. Matt is the co-founder of WordPress. And as a result, he&#8217;s been a user of WordPress for as long as anybody. We recorded this podcast while at WordCamp Europe in Portugal, a couple of weeks ago. It&#8217;s a wide ranging discussion, covering a lot of ground.</p>\n\n\n\n<p>[00:01:41] We start out with Matt&#8217;s reflections of WordPress at 19 years old. Which aspects of the project would he change if he had his time over and which parts is he proud of? Did Covid, and the restrictions around community events, have an impact upon the project, given that much of the time dedicated to WordPress is done by volunteers? What lessons have we learned about events like WordCamp Europe?</p>\n\n\n\n<p>[00:02:08] In recent news, and for the first time, there&#8217;s been some data pointing to the fact that WordPress&#8217; market share might have flattened out. Is this a cause for concern?</p>\n\n\n\n<p>[00:02:20] Where are we at with WordPress right now, given that it&#8217;s changing the scope of what non-technical users can do with it out of the box.</p>\n\n\n\n<p>[00:02:30] We then get into some more personal matters, including how Matt manages his time over the variety of projects he&#8217;s involved with. And does he regard advances in artificial intelligence as always positive?</p>\n\n\n\n<p>[00:02:43] You might notice that the sound is a bit patchy in places. This was a function of the environment we were in. There&#8217;s a few booms on the mic here and there, but it&#8217;s certainly listenable. If you&#8217;re interested in finding out more, you can find all the links in the show notes by heading over to WP tavern.com forward slash podcast, where you&#8217;ll find all the other episodes as well.</p>\n\n\n\n<p>[00:03:07] And so without further delay, I bring you Matt Mullenweg.</p>\n\n\n\n<p>[00:03:17] I am joined on the podcast today by Matt Mullenweg. Hello Matt.</p>\n\n\n\n<p>[00:03:22] Howdy, good to see you.</p>\n\n\n\n<p>[00:03:23] Yeah. They&#8217;re really nice to see you.</p>\n\n\n\n<p>[00:03:25] As far as I&#8217;m aware, you&#8217;re one of two people who can claim to go all the way back with WordPress. And it&#8217;s been just last week, 19 years, I think.</p>\n\n\n\n<p>[00:03:35] Yeah, that was a pretty exciting anniversary.</p>\n\n\n\n<p>[00:03:37] Yeah, does that kind of stuff fill you with nostalgia? Do you sort of look back and think, wow, what a journey this has been? Or are always focusing on the future?</p>\n\n\n\n<p>[00:03:45] You know, I am very future-focused personally, but it&#8217;s partially because I have a terrible memory. No really. It&#8217;s one of the reasons I started blogging. I learned a lot from the archives of my blog that I forgot. It&#8217;s also why I&#8217;m not too attached to like, arguing about the past. It&#8217;s like, you remember it differently. It&#8217;s fine. I&#8217;ll even go with your version, but what&#8217;s happening next? What are we doing in the future? And I try to live my life primarily oriented towards moving forward.</p>\n\n\n\n<p>[00:04:12] The reason I laughed is because I&#8217;m exactly the same. I more or less everything that happened 30 minutes ago. But looking back over those 19 years, what would be some of the highlights? So I&#8217;m forcing you to be nostalgic.</p>\n\n\n\n<p>[00:04:25] Hm. You know to me, it&#8217;s all about the people. Like we created lots of great stuff together, and still are. And so there&#8217;s definitely things like the first plugins, the first themes, the first international versions of WordPress with the Wiziwig coming in, which was quite controversial. And then Gutenberg coming in, which is quite controversial.</p>\n\n\n\n<p>[00:04:46] That&#8217;s part of why I dipped back into more active WordPress stuff day to day for a while there. But, I really think of the people. From the early folks like Mike Little, some who&#8217;ve passed away like Alex King. To the incredible array of people we have here today.</p>\n\n\n\n<p>[00:05:00] And my favorite part about WordCamps, what I miss the most was just meeting folks. Reconnecting with people who I&#8217;ve seen before, or just meeting people who, lives have been touched by WordPress in some way. And I&#8217;ve never, we&#8217;ve never run into each other before. I really enjoy that side of it. I learn a lot too. So it actually is very helpful for me in terms of thinking about the roadmap for WordPress. Just the stories. I hear, the things I see in the booths, the talks that happen. I definitely learn a ton from it.</p>\n\n\n\n<p>[00:05:29] Staying on nostalgic thing, are there any bits which you think, I wish it had played out differently, bits where you look back and you think, oh, WordPress could have gone in that direction, or there was a moment in time where we could have done this, and we we didn&#8217;t do that?</p>\n\n\n\n<p>[00:05:40] Hmm. Probably would have left the Rest API as a plugin, or maybe skipped straight to GraphQL or something. We did need to support all the feeds other than RSS2. We probably didn&#8217;t need all the others. Gosh, what else? I definitely, if I could go back to the very early days, we&#8217;ve always been really big on backwards compatibility.</p>\n\n\n\n<p>[00:06:00] And so there&#8217;s a few database tables that are just inconsistent in their namings, you know, as capital ID or something like that. Going all the way back to the B2 days, even before WordPress. So I kind of wish we had just renamed some of those early, actually it might be easier to do it now because no one accesses those tables directly anymore, but some of those minor things kinda.</p>\n\n\n\n<p>[00:06:18] I&#8217;d say broadly on the whole year you got it fairly right? I&#8217;m staying on the nostalgic bit, but this is the last couple of years. I mean, everybody knows what I mean by that sentence. The last couple of years, Covid and so on. How&#8217;s that been for WordPress in general? Everybody started staring at screens and looking at Zoom and, I feel that we were as prepared as an industry, as any. We got the zoom calls. We knew how to get the computer to do all those things. We had the mics, we had the cameras, but yet it wore pretty thin, after a period of time. And I wonder if the community, was sort of slowly leached away a little bit and I if there&#8217;s any of that.</p>\n\n\n\n<p>[00:06:56] I don&#8217;t think in a way that was unique to WordPress. Like you said, we&#8217;re fortunate that we&#8217;ve always connected online. It&#8217;s a fairly positive community. People are very supportive of each other. Competitors grabbed dinner together. What we miss was definitely these events like what&#8217;s happening right now.</p>\n\n\n\n<p>[00:07:11] It&#8217;s always been part of our magic sauce, secret sauce, if you will. Like we work remotely, but then when we get together, it makes it that much more special. And then more broadly, I think it&#8217;s just, you can&#8217;t ignore the impact all this has just had in people&#8217;s lives. And if there&#8217;s something going on in your life, you&#8217;re gonna have less energy for work or volunteering or other things.</p>\n\n\n\n<p>[00:07:32] And certainly if it&#8217;s anything health related, right. All the priorities melt away, right? When you, or a loved one facing a health challenge. So I think that, so many parts of the world are back to normal or like nothing happened, but it&#8217;s easy to forget, like the vast human costs of what we&#8217;ve been through. And it&#8217;s still ongoing for many people.</p>\n\n\n\n<p>[00:07:49] In terms of the contributions to the project, did that wick away? Is there the same engagement today, well, maybe let&#8217;s say three months ago, as there was two years ago, to core and all the other bits and pieces, or was that a struggle to keep going?</p>\n\n\n\n<p>[00:08:07] I don&#8217;t have the numbers in front of me, but if I recall there was a boost at the beginning, when we&#8217;re stuck at home. And I think like, as people started returning, to normal life, it dipped a bit, which makes sense, right there probably like have saved up. I know I&#8217;ve been going to like a thousand weddings. It feels like everyone in the world is doing their wedding. So I think there&#8217;s just some natural time that goes back to life, which by the way is great, because then we&#8217;ll return to equilibrium there. If you looked at 6.0 though, amazing number of contributors, contributor day yesterday was way over populated.</p>\n\n\n\n<p>[00:08:42] Yeah, it was so overpopulated, there was a struggle with food.</p>\n\n\n\n<p>[00:08:44] We literally ran out of food and we always over half that. So I think that&#8217;s showing that there is a, um, to say WordPress can continue to serve the needs of the world and our community. There&#8217;s no reason for it to, uh, not continue to grow and get more involved. That flywheels, it gets more users, some percentage of those contribute. And then of course we have programs like five for the future. That I feel like every open source project should have, but it&#8217;s very mature in WordPress where it&#8217;s just a cultural mores of people, for whom they get a lot from WordPress, take a little bit of time to give back. And that again is part of it. It&#8217;s all the people at the end. I think I&#8217;m going to say that 10 times.</p>\n\n\n\n<p>[00:09:22] No, it&#8217;s okay. I don&#8217;t know if you know, but apparently the two thousand seven hundred people who are registered, apparently 1,700 are brand new. Never been any WordPress event. About 60% of the people who are in this building have never been. So it feels if that was the thing it&#8217;s back in reverse.</p>\n\n\n\n<p>[00:09:41] It makes me wonder what the 2022 WordCamp Europe would be without a global pandemic we are just are coming out of and like, kind of in, in many places still. So yeah, 2,700 that&#8217;s amazing.</p>\n\n\n\n<p>[00:09:54] What do you think about events like this? It&#8217;s a generic question, but what are your thoughts? I mean, you&#8217;ve got such a different perspective, I guess, than somebody like me who turns up, attend events and go to people speaking and go to various different bits and pieces. What is this for you? Is it an enjoyable experience?</p>\n\n\n\n<p>[00:10:11] I mean, that&#8217;s, that&#8217;s what I do too. You know, I&#8217;ll drop it in the back and check out talks. If for whatever reason not in the room often I&#8217;m live streaming them. I would say the difference for me is like, I leave a pretty under the radar life generally. It&#8217;s not like people recognize me or anything like that. But at WordCamps, definitely. So I go stopped sometimes every five feet, to take a picture or talk to people, but you know what, that&#8217;s kind of why I&#8217;m here too.</p>\n\n\n\n<p>[00:10:40] Like if that&#8217;s a any way I can be of service to the community, sign me up for it.</p>\n\n\n\n<p>[00:10:44] Maybe that was the target of the question. Is it a strange thing to drop into for a period of time where life generally is normal and then it&#8217;s extraordinary for a bit, and then it goes back to whatever the normal is.</p>\n\n\n\n<p>[00:10:57] You know, I also just love talking about WordPress and technology. So I&#8217;m doing that for fun anyway. I&#8217;d say the main difference from my normal life is being recognized, which is just kind of a bizarre human experience. I never want to be actual, famous. Keep me out of the Daily Mail or The Post or whatever it is like. I&#8217;m happy to be well known among a community creating things like we do in WordPress.</p>\n\n\n\n<p>[00:11:20] So yeah, that&#8217;s kind of fun. And also the to and from, because like all the restaurants around. The planes to and from the event. You&#8217;ll just run into people and, you know, I could take a hundred flights without anyone ever stopping me. Yeah, my backpack actually has the WordPress logo embroided on it, but it&#8217;s black on black, so it&#8217;s a little subtle.</p>\n\n\n\n<p>[00:11:36] Normally no one recognizes. But often to or from a WordCamp, people will be like, oh, hey. But even I can go to WordCamps. I remember, often before WordCamp US, I&#8217;ll go to a bunch of the smaller ones. Just to kind of test out my material, like a comedian, playing smaller clubs before the big ones.</p>\n\n\n\n<p>[00:11:51] I remember going to working at Scranton, I think it was. Uh, Pennsylvania. I forget where Scranton is, someplace, um, and smaller WordCamp, maybe 110 people, which are some of my favorites, but, you know, we sat down at the lunch. No one knows who I am. They&#8217;re like, what do you do? And then after my talk, they were like, oh wow.</p>\n\n\n\n<p>[00:12:08] You&#8217;re like, you did that. And so it&#8217;s, it&#8217;s also fun to just kind of be like a secret shopper, if you will. Like often I&#8217;ll just sit down at random tables or go over to people. And, uh, again, like I said, I learn a ton, and sometimes when people don&#8217;t know who I am, I&#8217;m able to learn even more because they are more unguarded and more relaxed.</p>\n\n\n\n<p>[00:12:26] These kinds of events feel to me almost like the glue that binds so much more together. These are three days where all sorts of new relationships are forged and old relationships are rekindled, and it feels like there&#8217;s been a great, big chasm. They&#8217;ve been missing. And, I&#8217;m just really glad they&#8217;re back.</p>\n\n\n\n<p>[00:12:45] It&#8217;s funny, one of the things I&#8217;ve said that gets quoted the most, like on Instagram posts and stuff, is technology is best when it brings people together. And that really came out of the WordCamp experience. It&#8217;s a tremendous amount of work, and this is where I&#8217;d actually like to call out and thank the WordCamp Europe team.</p>\n\n\n\n<p>[00:13:00] They really push the bar every year and raise it. Right. I have a little more involved with US. Every time Europe happens I&#8217;m like, man, we got to up our game. And I know it&#8217;s exhausting. Everyone like, you know, needs a break at the end. But wow. Really is one of the, I think one of the best contributions to the WordPress community.</p>\n\n\n\n<p>[00:13:18] They&#8217;re all wearing black t-shirts and there&#8217;s black T-shirts everywhere. You know, there&#8217;s hundreds and hundreds of people who are giving up their time. And It&#8217;s amazing, you know, they&#8217;re doing it because they want to do it. There&#8217;s no coercion there. They&#8217;re really keen on the community and it&#8217;s this lovely.</p>\n\n\n\n<p>[00:13:33] It&#8217;s a lot of fun too. Often my sister, she&#8217;s been to, I think, WordCamp US and Europe until this one. Unfortunately she tested positive before the flight, so she ended up staying home, wasn&#8217;t feeling well. But often she&#8217;ll volunteer at like the check-in stage or something like that. But she now loves it for the people, you know, like she&#8217;s a fan of mine obviously. We&#8217;re brother and sister for a long time, she has so many friends here now.</p>\n\n\n\n<p>[00:13:56] I know for a fact that there&#8217;s people here just in the few people that I know who&#8217;ve brought their husband or wife and they&#8217;d just in, cause it&#8217;s a nice thing to do. Staring into the future, forever, it seems, the numbers for WordPress up, up, up, up, up, 25%, 40%, 43%, whatever it is. I think, you know where this is going.</p>\n\n\n\n<p>[00:14:15] Recently, I don&#8217;t know how dubious the statistics are. There&#8217;s this possible leveling off. Is any of that of interest to you? Is growth the thing, or is it, is there something else? Are you thinking about that at any point? Does it worry you or give you pause for thought?</p>\n\n\n\n<p>[00:14:31] I think growth is the result. So if we create something that&#8217;s accessible, well designed, solves people&#8217;s problems, we should grow. And so, yeah, it&#8217;s concerning to me when we don&#8217;t grow. That number is going to be a little wonky over the next year, year and a half, because as you&#8217;re probably aware, Alexa, the toolbar is shut down.</p>\n\n\n\n<p>[00:14:51] So even though they&#8217;re still providing data, the W3Techs, that data is more stale than it used to be and will, I think degrade over time and eventually W3Techs are switching to a different data set. I forget which one it&#8217;s called. So I don&#8217;t know that off the top of my head, sorry, my computer&#8217;s over there, but on Built With, Built With is something else that indexes the whole web and says how many it is. We&#8217;ve generally talked about the W3Techs number, which I think got up to like 42 or 43% before it started to wobble a little bit. Built With had us at like 30 something percent. I think the answer is somewhere in between there.</p>\n\n\n\n<p>[00:15:23] So I can see the W3Techs number coming down, maybe even 15 or 20%, uh, regardless of the actual underlying fundamentals of WordPress. And luckily we have some other of data that we get back, and the wordpress.org plugin directory from the update pings, things like that, that show the health of WordPress.</p>\n\n\n\n<p>[00:15:40] Uh, so those are always what I look at as the leading metrics. So we keep an eye on those. If there were to see a big migration, we would definitely take a look at the why, and see if there&#8217;s something we can improve in the software. And then finally, I&#8217;m a little less worried least at the moment because I&#8217;d really like to switch Tumblr over to WordPress, which is, well half a billion blogs. There&#8217;s a lot of Tumblrs out there.</p>\n\n\n\n<p>[00:16:03] And of course not all active, so it won&#8217;t move the number that much, but, yeah, a good amount. I&#8217;m very excited to bring that part of the web, which is so vibrant, has such a strong community and has a demographic, you know, younger, more female, than we might normally have at a WordPress event. Having it be like an on-ramp to the WordPress world.</p>\n\n\n\n<p>[00:16:20] Some of the commentary around that, whatever that was, this leveling off, was around things like, well maybe WordPress, there&#8217;s a lot of work to do in terms of performance and things like that. And I know that there&#8217;s initiatives in place and things are being done. I just wondered if there was anything you had on that.</p>\n\n\n\n<p>[00:16:38] I think we need to improve every single part of WordPress. And there was some performance data. I think is it, Alaine talked about today in his presentation? That shows that some WordPress sites are not as performant as some others. Now, the tough thing is I think you need to adjust to that per dollar.</p>\n\n\n\n<p>[00:16:57] So, you know, comparing it to essentially a hosted platform, like Squarespace that people might be paying $25 a month. To a web host you might be paying like $4 a month for is not an apples to apples comparison. There&#8217;s going to be some performance differential there. And of course, one reason why so many people use WordPress, especially globally is the accessibility.</p>\n\n\n\n<p>[00:17:16] The job that the web hosts do, making it extremely affordable. You know, the average Shopify subscriber spends $1,200 per year. Average WordPress subscriber, it&#8217;s, I don&#8217;t know cause it&#8217;s across so many hosts, it would be closer to like a hundred dollars a year, maybe even less when you look at like how reasonable a lot of these hosting plans are, but definitely anything we could do in Core is helpful.</p>\n\n\n\n<p>[00:17:39] And it&#8217;s also part of why, I think part of the story of the past 10 years of WordPress has been our really close partnerships with all the hosts. So the auto upgrade almost every well, every major host upgrades by default. Getting them on the new PHP versions, which actually have huge performance increases. PHP seven doubles performance essentially. So helping them be on the edge of the technology adoption curve.</p>\n\n\n\n<p>[00:18:01] But it&#8217;s not true, I&#8217;d strongly disagree that WordPress is slow. In fact, WordPress sites can be some of the fastest ones out there, but when you think of 40% of the web, a lot of them on less expensive hosting providers, it&#8217;s going to pull our overall numbers down. If you&#8217;re looking at all sites, not just the fastest ones.</p>\n\n\n\n<p>[00:18:20] Gutenberg WordPress 5.0. At seminal moment, everything changed.</p>\n\n\n\n<p>[00:18:25] Yeah. It was a good one.</p>\n\n\n\n<p>[00:18:27] There&#8217;s been a lot, there&#8217;s been a lot that&#8217;s changed since then. I&#8217;m just wondering over the course of those, what is that? Three years, some, three years.</p>\n\n\n\n<p>[00:18:34] Yeah, right about.</p>\n\n\n\n<p>[00:18:35] How you feel that&#8217;s gone. was a messaging thing at the beginning, you know, how, how did it get rolled out. But it feels to me as if the people who are developing on top of it more and more and more. Are getting excited and the talk is more and more and more about the possibilities and what&#8217;s going to be possible. So just that really. Are you pleased with the direction it&#8217;s going in? Where we&#8217;re at now, full site editing, all of those, block themes.</p>\n\n\n\n<p>[00:18:59] I&#8217;m pretty thrilled with it. Of course, I&#8217;m an impatient person. So I would love to move faster. But the truth is in 2022, if you&#8217;re not building a site on Gutenberg by default, you&#8217;re kind of setting it up for obsolescence or really expensive upgrade paths in the future. It is so capable. I think people underestimate how much you can do with Core blocks</p>\n\n\n\n<p>[00:19:21] Like without adding any of these block ad-ons or anything. And yet also, that&#8217;s such a clear roadmap, so many improvements are coming in every release. It was just at 6.0. I&#8217;d like to move us to be more releases per year. You know, maybe we can get to four per year instead of three, but it&#8217;s coming along. I&#8217;m thrilled with it.</p>\n\n\n\n<p>[00:19:37] And other CMSs are starting to copy it, and we&#8217;re getting Gutenberg and a lot more places too, which is also exciting. Um, Gutenberg is live for Tumblr by the way.</p>\n\n\n\n<p>[00:19:47] Is the intention that it&#8217;s the editor for the web, basically.</p>\n\n\n\n<p>[00:19:49] A hundred percent. It&#8217;s bigger than WordPress.</p>\n\n\n\n<p>[00:19:51] It&#8217;ll be everywhere and ubiquitous. So on the phone and on the, whatever CMS that you&#8217;re using and the whole thing.</p>\n\n\n\n<p>[00:19:58] Yeah. And there was this announcement for something called the block protocol, which I think, if you look at it, it&#8217;s exactly what we&#8217;ve been doing with Gutenberg and they probably should just adopt a Gutenberg and then like build from there.</p>\n\n\n\n<p>[00:20:07] Yeah. That was a really interesting project. The idea that it&#8217;s completely interoperable across everything. Yeah. Really, really, really interesting.</p>\n\n\n\n<p>[00:20:14] That&#8217;s what we&#8217;re doing. We have the mobile versions for iOS and Android. I believe we&#8217;re relicensing those right now to be even more open. So they&#8217;re easier to embed in commercial apps. And then of course the web version is getting pretty robust. And it&#8217;s just, it&#8217;s weird edge cases that you start to deal with.</p>\n\n\n\n<p>[00:20:29] There was one I found the other day actually through a friend. This is why I love doing tech support and people talking to me about the problems with WordPress. I think it was copying and pasting from Facebook images. So they had a lot of their photos on Facebook and they would right click to click copy and paste and in Gutenberg, what it was doing was making that a link to the image, versus actually uploading the image. And so, because it was to like a private URL, it would break for other people. But it would look normal to that person.</p>\n\n\n\n<p>[00:20:59] This was just a workflow no one has pointed out to us. It was like pretty easy to fix once we knew about it. But, it was interesting because one thing we do when something like that comes up is we look at other editors and see which other editors support that use case. Actually Google docs did. So at some point, Google docs figured this out, but a bunch of other editors did. Google docs is actually one of the software projects I repect the most.</p>\n\n\n\n<p>[00:21:22] I entirely agree. I&#8217;m waiting for the day when, um, we can do the concurrent editing, that will be.</p>\n\n\n\n<p>[00:21:26] Oh my goodness.</p>\n\n\n\n<p>[00:21:27] It&#8217;s almost as if that&#8217;s the minimum requirement now. I&#8217;ve got so used to using Google docs and seeing the other people contributing at the same time. I remember the experience of seeing that for the first time and thinking what that&#8217;s voodoo.</p>\n\n\n\n<p>[00:21:39] How, did that happen? But you you&#8217;re happy. You&#8217;re pleased with the development and you&#8217;re pleased with the way it&#8217;s looking?</p>\n\n\n\n<p>[00:21:45] No, I&#8217;m impatient. I&#8217;m really proud of what we&#8217;ve done, but there&#8217;s so much more to do. And especially if we&#8217;re trying to make the editor for the entire web, it&#8217;s even bigger than WordPress. I think that&#8217;s going to have such a benefit, to both developments, like speed of development. It&#8217;s not unlike web components or other things like we&#8217;ll have these standard things everyone can use.</p>\n\n\n\n<p>[00:22:06] And then there&#8217;s also usability because users will be able to learn how blocks work, once, and then create almost anything. Like how cool is that? It&#8217;s like a fundamental, literally fundamental building block of the web, almost like the DNA.</p>\n\n\n\n<p>[00:22:17] I&#8217;m going to phrase this in a way which I suspect you&#8217;ll push back on, but let&#8217;s see where we go. The five for the future initiative. That would be so great if everybody was a part of that. And I wonder if you would like more people to be a part of that? Whether or not there&#8217;s some inertia.</p>\n\n\n\n<p>[00:22:36] I&#8217;m struggling to find the words. The speed of everything could go more rapidly. Everything could happen more quickly. And that speaks to your impatience. If more people were able and willing to step up for that initiative.</p>\n\n\n\n<p>[00:22:49] You know, I value even if people just have one hour, once a month. You know, five for the future isn&#8217;t meant to say you need to do 5% or nothing. It&#8217;s just meant to say that, Hey, if enough people do the 5%, WordPress will really thrive. But if not everyone does it, that&#8217;s okay too. In fact, you know, not everyone does it and doing pretty well.</p>\n\n\n\n<p>[00:23:12] It&#8217;s funny cause contributing, it&#8217;s kind of hard to start and maybe it&#8217;s intimidating to think like, oh, do I take like two hours a week to be part of WordPress. 5% of a 40 hour week or something. But it&#8217;s hard to stop too. Once get involved, it&#8217;s infectious because it&#8217;s such a great way to learn.</p>\n\n\n\n<p>[00:23:28] It&#8217;s really great to be connected to something larger than yourself. Do some work and then see the ripples throughout the web or throughout WordCamps. It&#8217;s really fun to like overhear someone talking about something at a WordCamp that you were involved in building or contributing to or documenting or translating.</p>\n\n\n\n<p>[00:23:44] I dunno, it&#8217;s just like a source of pride. It&#8217;s kind of how I got involved. Like I contributed some code to B2 at the time and I just got such a high. From knowing that, you know, hundreds of websites were running my code, and I&#8217;ve just been chasing that ever since. Like it&#8217;s still compelling, even if it&#8217;s a plugin that only like 10 people use to like, you know, obviously any changes the Core go to a lot of the web. At any point it&#8217;s just kinda like leaving a dent in the universe, leaving the world a little bit better than you found it.</p>\n\n\n\n<p>[00:24:10] It&#8217;s funny, you said the word proud, well you said pride and my question contains the word proud, and it is follows. What are the things, and you&#8217;ve covered this a little bit. But this doesn&#8217;t have to be the code, it doesn&#8217;t have to be the community, although maybe that is the bit. What are the bits that you&#8217;re most proud of? The bits that you look back and think I am so pleased that bit happened. And it could be a big thing, could be a tiny thing, but the bit that makes you internally smile.</p>\n\n\n\n<p>[00:24:36] I&#8217;m really proud, to the extent WordPress, it can be a very welcoming place. We really strive to be inclusive, to bring folks from all over the world, all backgrounds. Now I&#8217;m sure there&#8217;s mistakes. I&#8217;m sure there&#8217;s things that happen at WordCamps sometimes, but like we correct that and the norm of the community is expecting to make someone feel welcome. Yeah, I really appreciate that. I mean you look around WordCamp, could not be a more different group of folks.</p>\n\n\n\n<p>[00:25:03] Yeah, that&#8217;s true. They&#8217;re an interesting, there&#8217;s an eclectic mix of people up there.</p>\n\n\n\n<p>[00:25:08] Oh my goodness, even it just like fashion styles or like you know, like hairstyles, styles, ages, colors, everything. And how beautiful that? That we can come together with a shared passion, communicate with each other as humans. Every person is unique. You&#8217;re not what it says on your badge or where you work. It&#8217;s really about connecting as humans and that&#8217;s, to me, what&#8217;s great about blogging. It&#8217;s about, what&#8217;s great about the open web. It&#8217;s recognizing the beauty, brilliance and uniqueness of every person.</p>\n\n\n\n<p>[00:25:37] How do you manage your time? Because I know that you&#8217;ve got more things than I&#8217;m doing. Let&#8217;s put it that way. You&#8217;ve got Tumblr, you&#8217;ve got WordPress. Where does it all fit in? Do you like a run a regular week? Are you a 40 hour a week person? Do you tend to work late into the evening or?</p>\n\n\n\n<p>[00:25:53] I guess there&#8217;s multiple levels to answer that. Where I&#8217;m spending my time in terms of all the projects that are going on, is kinda like rotations. Like often I&#8217;ll move into something, spend a lot of time there and then I&#8217;ll drift back out once, you know, whatever I was coming in for has changed. Probably a good example of that recently was Gutenberg.</p>\n\n\n\n<p>[00:26:16] So that&#8217;s one took a more active role and kind of release lead, the driving, the getting that happening. Even like the product itself. And then as that really got great you know, 5.1, 5.2, able to step back and allow others to like take a more active role and leading that or driving that. Tumblr&#8217;s is a good example.</p>\n\n\n\n<p>[00:26:38] Like, you know, stepping into it for a bit. I hope to be able to pass it to someone in the future and say like, take this, keep it going. It&#8217;s going great. And so that&#8217;s kind of how the projects do. And then personally, I just try to manage my energy, to match that to the tasks that are happening.</p>\n\n\n\n<p>[00:26:53] Unfortunately, I work very strange hours sometimes, and, I just try to capture, like, if I get a burst of inspiration late at night to write something or, feeling really engaged, we&#8217;re in the mood for like doing communication stuff versus like I&#8217;m in the mood for reading, whatever that is, and run with it. Versus trying to say like, every morning I&#8217;m going to do this. Some mornings I&#8217;m tired. Some mornings, you know, maybe I&#8217;m feeling a little more burnt out. And so, like, I don&#8217;t feel that sort of creative spark to, to write a thousand words, but it might be easier to catch up on some P2 posts. Catch up on the Slacks.</p>\n\n\n\n<p>[00:27:26] It sounds like you take care of yourself. You take time to step away and, I came in here you were listening to jazz music, which was quite nice sort of background. But, you know, you take time to do all of that. And have you always coped with pressure well, because I&#8217;m guessing there&#8217;s a fair amount of pressure your life, yet you always have this fairly serene composure to you.</p>\n\n\n\n<p>[00:27:46] I guess what a lot of people think is pressure doesn&#8217;t bother me very much, because you know, I feel like you should worry about the things you can change. So if you know, we got to note your biggest client is leaving you, they&#8217;ve already made up their mind. You can&#8217;t do anything. It&#8217;s like okay. Like learn from it, but don&#8217;t beat yourself up over it. Like suffer once. Like so often we suffer more, this is a quote, we suffer more in our heads than we do in reality, either for imagined things which is anxiety. Reliving the past, or just kind of beating ourselves up for something. And so it&#8217;s better to just recognize reality. Acknowledge it, learn from it, get as much information as possible, but then what&#8217;s next?</p>\n\n\n\n<p>[00:28:27] Where it definitely hits me harder is when there&#8217;s something you can&#8217;t change, with a loved one, you know, like someone passing, getting sick, those things hit me really hard. That&#8217;s probably the place where, when that happens, I have to step away for a bit. Just kind of recharge or get in nature, hydrate, make sure I&#8217;m sleeping well. Those things are tough for, I think everyone, but the calmness that happens in normal, like code or business or whatever it is that normally would stress me out. Those are bigger.</p>\n\n\n\n<p>[00:28:59] There&#8217;s this phrase, I&#8217;ve written it down here. Benevolent dictator for life. Benevolent is such a nice word. It&#8217;s great. Everybody loves benevolent. Dictator, maybe that&#8217;s a different thing.</p>\n\n\n\n<p>[00:29:10] I feel like that branding&#8217;s a little less good recently.</p>\n\n\n\n<p>[00:29:13] But, we all know what that means? Do you plan to be here in several years time? Would you love still to be at the helm of WordPress? Is this going to be the life for Matt Mullenweg for the foreseeable future?</p>\n\n\n\n<p>[00:29:26] Yeah, three out of those four words are millions to. I hope to be of service to the WordPress community, benevolently. That&#8217;s always something I will do my best. I always say I&#8217;m human. I&#8217;m going to make mistakes. We&#8217;re going to mess up That&#8217;s the only thing I can a hundred percent promise. But we&#8217;ll try to learn from them.</p>\n\n\n\n<p>[00:29:41] Try to course correct and be right more often than not. And then the, for life. Yeah, a hundred percent. Like it&#8217;s been 19 years. I think because WordPress changes so much, I&#8217;m never bored of it. You know, it&#8217;s like one of these things that you know when WordPress launched, javascript was called DHTML. It wasn&#8217;t really common. There was no iPhone. like that. Everything has changed so much and it still is. You know, it&#8217;s hard to imagine looking from 2003 to now, how much things have changed looking forward another 19 years to that would be 2041 or something. Like what will be enabled? And in technology, and don&#8217;t know if you&#8217;ve seen things like the open AI projects, like GPT3 or DALL-E, like utterly astounding,</p>\n\n\n\n<p>[00:30:25] I find it a bit scary. Aspects of that worry me. The aspects I think that worry me are the loss of control and that, at some point we&#8217;re going to just be creating 10,000 word articles. So the bot creates the article, which is then read by the Google bot. The cyclical creation of things.</p>\n\n\n\n<p>[00:30:44] And also the destabilization of the belief in what your eyes tell you. You know, you see a picture of some famous person allegedly doing something, which they never did, but somebody created it with a click of a button. Those pieces worry me. So you sound much more sanguine about it.</p>\n\n\n\n<p>[00:30:59] I&#8217;m pretty excited. The text side is interesting, but I&#8217;m actually really excited by the image creation, not the deep fakes, but more like DALL-E, you can give a prompt. Like I want to see a spaceship cat eating ice cream, while riding a bike.</p>\n\n\n\n<p>[00:31:17] That&#8217;s the one everybody&#8217;s going to say.</p>\n\n\n\n<p>[00:31:18] And this image has never existed humanity. Yet you can speak your words and it will be created. And it will create like 15 of them. And some of them are weird, but some of them are incredible. And you can say, do it in the style of Salvador Dali, or do it like a Monet painting. Or do it like an illustration. Like that is unlocking that kind of co-creation of art, I find so compelling because that&#8217;s essentially, when technology creates things we can&#8217;t expect that hypercharged creativity.</p>\n\n\n\n<p>[00:31:50] So even when you imagine, when we moved from drumming and using our voices instruments to having, the creation of the first instruments, whether they were stringed instruments, lutes, organs where the most sophisticated technology at a time. Today, the way we can use synthesizers and remix things and multiple tracks. I&#8217;m sure it&#8217;s certain points, and I&#8217;m sure there&#8217;s examples of this creating bad art. You have to make a lot of terrible art to get to the good art.</p>\n\n\n\n<p>[00:32:13] The boundary comes down, doesn&#8217;t it? You don&#8217;t need to have that dexterity with the pencil or the pen, the paint brush or whatever it is. You have to have the vocabulary to describe it.</p>\n\n\n\n<p>[00:32:22] There&#8217;s an art to that too, like. I feel like there&#8217;s a skill to doing a good Google searches, like crafting the search term in a way that helps you find what you want. And we kind of co-learn with it. There&#8217;s a feedback loop. You put in a search, you don&#8217;t find what you want, and you start to tweak it and you learn.</p>\n\n\n\n<p>[00:32:38] I think that the sort of generative art tools like a Dali are the same way. I think Mind Journey is another one. You can go through and feed in some texts and then see what happens. And then like keep going. I mean, how cool would that be. Actually for Tavern, I would love for you to see you all use it more, like, make some, more like Mine Journey or DALL-E type images?</p>\n\n\n\n<p>[00:32:56] that then leads me to the question about AI creation of websites. So, do you want a future where you build the website with that kind of an interface? So I would like a website that&#8217;s to do with volcanoes and I would like a picture of a volcano at the top. No, not that one. Slightly more fiery. And can we have a button, but no, no red, not blue. Wider. Yeah, no stop there. So that kind of an interface. So we drop the mouse and we describe the website and move the components with our voice, or whatever we&#8217;re using, maybe we&#8217;re plugged point.</p>\n\n\n\n<p>[00:33:28] And how powerful are blocks for that? Right, so we&#8217;re creating the sort of raw ingredients that could be used. I used to not believe this stuff would happen. But it&#8217;s gotten so great. If you&#8217;ve seen Codepilot, Codepilot on Github, or some of the stuff that GPT3 can do around like interface creation or even app creation. It&#8217;s fairly powerful.</p>\n\n\n\n<p>[00:33:49] We&#8217;re going to have much better machine learning models around translation of languages. I think we&#8217;ll get to a point, you know, we&#8217;ve always joked, like will WordPress ever be written in something other than PHP? I think we&#8217;ll have translators over the next five to 10 years, that could take something as complex as a WordPress and translate the code to another language and it&#8217;ll work.</p>\n\n\n\n<p>[00:34:08] Right, because essentially that&#8217;s, what&#8217;s happening. All these languages go to a bytecode or some sort of something much closer to the wire. So once a computer can truly deeply understand what&#8217;s happening in the code and find the equivalents in another language, right?</p>\n\n\n\n<p>[00:34:22] You&#8217;re close to just thinking a website into creation at that point, aren&#8217;t you? The boundary is, can you imagine, and if you can imagine an elucidate it, then you&#8217;ve done it.</p>\n\n\n\n<p>[00:34:32] And think how much creativity has been unlocked by things like Photoshop or Illustrator or the pen for the iPad anything. Like you put these things in front of a child, they just start producing.</p>\n\n\n\n<p>[00:34:42] Oh, immediately. That&#8217;s interesting.</p>\n\n\n\n<p>[00:34:44] And that&#8217;s, that&#8217;s cool, right? And so it kind of comes back to what&#8217;s what&#8217;s the limits of human imagination and a little bit, our limits are what we&#8217;ve experienced so far. So there&#8217;s this idea of adjacent possibilities. That whatever&#8217;s going on in the world, people consume, and then that gives them the ideas for what&#8217;s next. But you need the previous stuff to exist first. Right? We build on the, we stand on the shoulders of giants and every generation that&#8217;s come before. And now with global communication, everything, a cycle of that feedback loop of new things happening and then spreading throughout the culture.</p>\n\n\n\n<p>[00:35:19] I mean, used to take hundreds of years. There&#8217;s examples where they knew that scurvy was caused by lack of vitamin C like hundreds of years before it was kind of widely known knowledge. And. You know, they can sequence a novel coronavirus, create the vaccine, literally within like a day, the sequencing being available. What was it, a year and a half later? Like there&#8217;s a billion doses in people&#8217;s arms.</p>\n\n\n\n<p>[00:35:45] The impediment was the testing, not the creation.</p>\n\n\n\n<p>[00:35:47] Wow. Even making a billion of something in like a little over a year is kinda wild as well. So that is, think of it both a faster kind of clock speed for the evolution of culture and thought and knowledge that&#8217;s enabled, and also hopefully faster antibodies, both literal and societal to things that can cause harm.</p>\n\n\n\n<p>[00:36:11] You know, I don&#8217;t think it&#8217;s, it&#8217;s a stretch to think of misinformation, disinformation, you know, sort of the information wars that are happening right now, both hot and cold throughout, um, authoritarian and more democratic regimes as a type of pathogen. Almost like a novel mean virus or idea virus, which right now we&#8217;re not very strong against, but we&#8217;re starting to develop the antibodies too, including things like detecting bots and coordinated inauthentic behavior.</p>\n\n\n\n<p>[00:36:37] That right now I think is causing a lot of problems throughout society. but we&#8217;ll get better at figuring that out.</p>\n\n\n\n<p>[00:36:44] It&#8217;s fascinating because I think technology can take you in one of two directions, you know, the, the apocalyptic version and then the sort of, desirable, let&#8217;s say that. And it feels to me that you are ,firmly on the desirable side. You&#8217;ve got a very positive approach that the technology in the future doesn&#8217;t worry you.</p>\n\n\n\n<p>[00:37:03] It&#8217;s not that it doesn&#8217;t worry me. It&#8217;s just I&#8217;m a builder. So I need to choose that I&#8217;m going to work on.</p>\n\n\n\n<p>[00:37:07] Yeah, sadly, my</p>\n\n\n\n<p>[00:37:08] work on the things that things better.</p>\n\n\n\n<p>[00:37:10] My vocabulary left me at that point.</p>\n\n\n\n<p>[00:37:12] Techno optimist, maybe. Yes. Like, uh, I would say that I tend towards optimism and the thing that gives me that optimism is often deeply engaging with a criticism of it.</p>\n\n\n\n<p>[00:37:23] So I want to really strongly understand, be able to make the argument for why all the things I just talked about are going to destroy society. But then once you understand that, how can we build it or how can we do it in a way that&#8217;s going to be more positive. And also how can we check our assumptions? Like if we look back, to what we thought was going to ruin society before, did it?</p>\n\n\n\n<p>[00:37:43] It&#8217;s funny, there&#8217;s a, gosh, I forget the name of the account, but it just pulls up old criticisms of the technology. And there was one that showed a subway, and everyone&#8217;s, um, reading a newspaper? They&#8217;re like, oh, what&#8217;s happened to society, people used to talk on the subway, they used to engage with each other. Now just the heads are all buried.</p>\n\n\n\n<p>[00:38:00] Of course Gutenberg, you know, the original, uh, needs to read it&#8217;s, you know, it&#8217;s dangerous.</p>\n\n\n\n<p>[00:38:08] And it turns out that it was dangerous, like wow. Protestant, like, how much change that kicked off, but it was really about knowledge is power. It was about the distribution of a more wider distribution of knowledge and opportunity. And that shook up society. But you know what? I needed to be shooken up.</p>\n\n\n\n<p>[00:38:25] It&#8217;s the message. Maybe this is the perfect point to end?</p>\n\n\n\n<p>[00:38:27] That&#8217;s what WordPress shakes up, you know? So we take things that, by the way, equivalent to what WordPress does for free, 10 years ago, you&#8217;d pay like millions of dollars a site core or Magento or something like that to do it, which now like you can download WooCommerce and it does everything that did and way more.</p>\n\n\n\n<p>[00:38:45] So we&#8217;re kind of taking, I sometimes make the analogy that we have a promethean task, climb mountain, take the fire from the gods and then bring it to the people. As we do that, sometimes it generates a lot of blow back. You know, if you recall a really big criticism of Gutenberg early on was that it was going to destroy agencies and web builders.</p>\n\n\n\n<p>[00:39:05] People would just be able to build their sites themselves. They would lose all their business, everything like that. As you walk around WordCamp ask anyone who&#8217;s building websites, like, do you have more business or less business? How&#8217;s it going? I&#8217;m sure there&#8217;s some exceptions, but by and large, the businesses are larger than ever.</p>\n\n\n\n<p>[00:39:19] They&#8217;re growing faster. Site builders doing fine, the themes that are like, you know, there&#8217;s going to be some changes, right? Some of us might be making horse buggies, and those might not be as in demand in the future, but you can also like shift and it&#8217;s kind of cool. I have people tell me that they&#8217;re way more profitable now because they can build things in Gutenberg that they used to have to code custom. So even though they could code a custom, they can just click some buttons and build a site and be done so they can now do more of them. How cool is that?</p>\n\n\n\n<p>[00:39:45] So the change definitely disrupts things. It can definitely be sometimes rocky, but ultimately, if you embrace the change and you sort of work from your principles and your morals to be on the right side of history, it can be incredibly empowering. Matt Mullenweg, thank you for talking to me today. Thank you. Thanks for coming.</p>\n</div>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Wed, 15 Jun 2022 14:00:00 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:14:\"Nathan Wrigley\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:24;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:74:\"Do The Woo Community: devlife_snippet: From Sprints to Managed WooCommerce\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:28:\"https://dothewoo.io/?p=71725\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:56:\"https://dothewoo.io/from-sprints-to-managed-woocommerce/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:398:\"<p>A sprint is a nice change of pace when you start a WooCommerce web agency but not always recommended. Here\'s why.</p>\n<p>&gt;&gt; The post <a rel=\"nofollow\" href=\"https://dothewoo.io/from-sprints-to-managed-woocommerce/\">devlife_snippet: From Sprints to Managed WooCommerce</a> appeared first on <a rel=\"nofollow\" href=\"https://dothewoo.io\">Do the Woo - a WooCommerce Builder Community</a>	.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Wed, 15 Jun 2022 11:43:45 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:5:\"BobWP\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:25;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:79:\"WordPress.org blog: WP Briefing: Episode 33: Some Important Questions from WCEU\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:53:\"https://wordpress.org/news/?post_type=podcast&p=13005\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:81:\"https://wordpress.org/news/2022/06/episode-33-some-important-questions-from-wceu/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:12737:\"<p>In the thirty-third episode of the WordPress Briefing, hear Josepha Haden Chomphosy recap important questions from WordCamp Europe, and a selection of Contributor Day interviews. </p>\n\n\n\n<p><em><strong>Have a question you&#8217;d like answered? You can submit them to <a href=\"mailto:wpbriefing@wordpress.org\">wpbriefing@wordpress.org</a>, either written or as a voice recording.</strong></em><br /></p>\n\n\n\n<h2 id=\"credits\">Credits</h2>\n\n\n\n<ul><li>Editor: <a href=\"https://profiles.wordpress.org/dustinhartzler/\">Dustin Hartzler</a></li><li>Logo: <a href=\"https://profiles.wordpress.org/beafialho/\">Beatriz Fialho</a></li><li>Production: <a href=\"https://profiles.wordpress.org/santanainniss/\">Santana Inniss</a></li><li>Production Assistance: <a href=\"https://profiles.wordpress.org/priethor/\">Héctor Prieto</a></li><li>Special Guests: <a href=\"https://profiles.wordpress.org/milana_cap/\">Milana Cap</a>, <a href=\"https://profiles.wordpress.org/daugis/\">Daugirdas Jankus</a>, and <a href=\"https://profiles.wordpress.org/desrosj/\">Jonathan Desrosiers</a></li><li>Song: Fearless First by Kevin MacLeod</li></ul>\n\n\n\n<h2>References</h2>\n\n\n\n<ul><li><em><a href=\"https://en.wikipedia.org/wiki/L%27esprit_de_l%27escalier\">L&#8217;esprit de l&#8217;escalier</a></em></li><li><a href=\"https://make.wordpress.org/core/2022/05/20/core-editor-improvement-creating-containing-containers/\">Flexbox Layout Blocks</a></li><li><a href=\"https://make.wordpress.org/training/2022/03/10/recap-of-training-team-meetings-march-8-and-10-2022/\">Translating Content on Learn WordPress</a></li><li><a href=\"https://make.wordpress.org/training/handbook/workshops/workshop-subtitles-and-transcripts/translating-subtitles/\">Translating Subtitles</a></li><li><a href=\"https://josepha.blog/2020/01/15/fostering-collaboration-across-cultures/\">Collaboration Across Cultures</a> (Blog)</li><li><a href=\"https://www.youtube.com/watch?v=8MzJCT2BVV0\">Collaboration Across Cultures</a> (YouTube Video)</li><li><a href=\"https://europe.wordcamp.org/2023/call-for-organisers/\">WordCamp Europe Athens: Call for Organizers</a></li><li><a href=\"https://twitter.com/matias_ventura/status/1534602705456480260\">6.1 Release Planning Twitter Thread</a></li><li><a href=\"https://make.wordpress.org/core/2022/06/04/roadmap-to-6-1/\">6.1 Release Planning Roadmap Post</a></li><li><a href=\"https://make.wordpress.org/meetings/\">Make WordPress Meetings Calendar</a></li></ul>\n\n\n\n<h2>Transcript</h2>\n\n\n\n<span id=\"more-13005\"></span>\n\n\n\n<p>[<strong>Daugirdas Jankus </strong>00:00:04]&nbsp;</p>\n\n\n\n<p>Honestly, it&#8217;s not a secret. It&#8217;s a big part of our business. And I think it&#8217;s like WordPress is a big part of all the hosting company, company’s, businesses, you know? So for us, it is like, we want to make it better. We want to give back. We want to understand, you know, where we can contribute the most. And we see it as a, you know, win, win, win situation for everyone, for clients, for the whole ecosystem.</p>\n\n\n\n<p>And for us as a business, of course!</p>\n\n\n\n<p>[<strong>Milana Cap </strong>00:00:32]&nbsp;</p>\n\n\n\n<p>My favorite WordPress component is WP CLI. That&#8217;s my crush, haha, because I love terminal. I love doing it. I&#8217;m not a really UI type of person, I get lost in UI. But in terminal, you just type command and it does what you want. And a WP CLI is much more powerful than WordPress dashboard. You can do so many things there and you can have fun.</p>\n\n\n\n<p>Uh, so that&#8217;s my go-to tool!</p>\n\n\n\n<p>[<strong>Josepha Haden Chomphosy </strong>00:01:10]&nbsp;</p>\n\n\n\n<p>Hello everyone. And welcome to the WordPress Briefing– the podcast where you can catch quick explanations of the ideas behind the WordPress open source project, some insight into the community that supports it, and get a small list of big things coming up in the next two weeks. I&#8217;m your host, Josepha Haden Chomphosy.</p>\n\n\n\n<p>Here we go!</p>\n\n\n\n<p>[<strong>Josepha Haden Chomphosy </strong>00:01:36]&nbsp;</p>\n\n\n\n<p>Many, many people were at WordCamp Europe a couple of weeks ago. And at the end, Matt and I closed out the event sessions with a little question and answer time from the community. I was excited to see everyone and excited to answer their questions. But as with all spur of the moment answers, I experienced this <em>l&#8217;esprit de l&#8217;escalier </em>and I found that there were a few things that I would have answered a little more completely if I had taken more than two seconds to think about them.</p>\n\n\n\n<p>So today I&#8217;m going to augment some of the answers from that session with a little more context and clarity. There was a question from Laura Byrne about favorite blocks in recent WordPress releases. And given that I was exclusively holding WordCamp Europe information in my brain at the time, I couldn&#8217;t think of which block was my favorite. While I was sitting there on that stage,</p>\n\n\n\n<p>I realized that one of my favorite things about WordPress’s 6.0 release, like Matt, wasn&#8217;t really a block, but it was a functional workflow sort of thing. So my favorite thing was the ability to lock blocks, but I mean, the question was about favorite blocks. And so I do know that some of the most anticipated blocks are the Flexbox layout blocks. Whew. What a sentence!</p>\n\n\n\n<p>[<strong>Josepha Haden Chomphosy </strong>00:02:46]</p>\n\n\n\n<p>Try to say that three times fast! Those blocks are the Flexbox layout blocks, they are sort of shortcuts that show up when you&#8217;re selecting multiple blocks and allow for easy side-by-side layouts. I&#8217;m not explaining it in a way that does it much justice, but I will share a link in the show notes that has more information and you can kind of see how empowering that particular block is in the block editor.</p>\n\n\n\n<p>The next question I wanted to give a little more context to came from Courtney Robertson. She asked about how to make translated content more readily available on learn.wordpress.org. My answer was pretty far ranging and talked about why it&#8217;s harder to commit to prioritizing that over, for my example, translating WordPress core.&nbsp;</p>\n\n\n\n<p>But I also understand that there are people who want to help and just need someone to point them in the right direction. And so I want to be clear that it is possible to have workshops in any language on learn.wordpress.org right now. We just don&#8217;t have a lot of people contributing those translations.</p>\n\n\n\n<p>So there are conversations going on right now in the training team about using Glotpress on learn.wordpress.org, and also how to translate subtitles. So, if you are looking for ways to give back through translation and training is an important kind of area of your focus. I will have links to both of those things in the show notes as well.</p>\n\n\n\n<p>[<strong>Josepha Haden Chomphosy </strong>00:04:11]</p>\n\n\n\n<p>I also gave a quick answer, uh, after this question about how hard it is to recognize contributions that are separate from a major event or major release. In this case, when I say recognize, that&#8217;s recognized as in thank, not recognize as in, know it exists. In case it&#8217;s not clear why that was connected, why that answer was connected to the question, training materials are self-serve and not always specific to individual releases of WordPress.</p>\n\n\n\n<p>So that means the maintenance of any content around training happens routinely over the course of time, rather than because of a specific release or a WordCamp. What sometimes can make it a little harder to entice people to join us in that work.&nbsp;</p>\n\n\n\n<p>And now the third question I&#8217;d like to tackle is the one that came from Megan Rose. She asked how we can encourage better diversity as we go back to in-person events. My answer was more about the big picture, program-wide work that has been done and specific awarenesses that I, as a leader, have been keeping top of mind. That answer is still true and is still important, but again, it doesn&#8217;t really help anyone who&#8217;s wondering how they can show up today in their own communities, and do the hard work of fostering an inclusive space there so that we can confidently welcome more diverse voices together.&nbsp;</p>\n\n\n\n<p>[<strong>Josepha Haden Chomphosy </strong>00:05:27]</p>\n\n\n\n<p>A great place to start is to have conversations with people who aren&#8217;t like you and really listen. Also recognizing that we all come from different backgrounds that give us more or less opportunity and always be asking yourself, who is missing from this conversation and why, how can I find them and invite them into our own WordPress spaces?</p>\n\n\n\n<p>If that all kind of feels right up your alley, I would check out the show notes. I&#8217;ll have some links in there to the community team’s site, as well as a few posts that will help you to explore that a bit further as well.&nbsp;</p>\n\n\n\n<p>There were also a couple of questions about market share slash usage of WordPress, and Five for the Future that I really do want to answer, but as I was writing up the context and just kind of exploring the questions that people were raising, it turned out to really be quite a big set of answers.</p>\n\n\n\n<p>So I will do those in either two separate episodes of their own or one surprisingly long, for me, episode. And so there you have it, a lightning round, deep dive on a few questions from WordCamp Europe.</p>\n\n\n\n<p>[<strong>Jonathan Desrosiers </strong>00:06:41]&nbsp;</p>\n\n\n\n<p>Yeah, it&#8217;s definitely great to be back in person. Um, it&#8217;s been a long two years, two or three years for a lot of people and it&#8217;s, it&#8217;s, it&#8217;s great that we&#8217;re such an asynchronous community and we can all stay connected online through Slack and different means. Um, but there are some things that you can&#8217;t replace, like making friends with people and learning people&#8217;s demeanors and having some discussions in person that you can&#8217;t replace.</p>\n\n\n\n<p>And so, uh, I&#8217;m really excited to see people I haven&#8217;t seen in a long time. Meet new people and, um, you know, have some of those discussions here today in Portugal.</p>\n\n\n\n<p>[<strong>Josepha Haden Chomphosy </strong>00:07:21]&nbsp;</p>\n\n\n\n<p>Which then brings us to our small list of big things.&nbsp;</p>\n\n\n\n<p>If you missed the announcement, WordCamp Europe will be in Athens next year. And the call for organizers is open already. It&#8217;s an experience that is absolutely irreplaceable. So I&#8217;ll link to that in the show notes, in case you&#8217;ve always wanted to give back to WordPress that way.</p>\n\n\n\n<p>The second thing on my list is that work on the next major release of WordPress is already underway. There is a post with roadmap info that was published recently, as well as a slightly more casual thread on Twitter. I&#8217;ve linked both of those in the show notes, so that you have some concept of what it is that we are aiming for in 6.1, and also a concept of where to go to get started working on it if that&#8217;s what you feel like doing, uh, for the next three to four months– 120 days, roughly.</p>\n\n\n\n<p>Uh, and finally. This is less of like a thing to be aware of in the next two weeks and kind of a little WordPress project tool tip. Did you know that we have a calendar that shows all meetings for all teams all week long? It will make you feel tired by the amount of work that gets done in the WordPress project every week, but it&#8217;s right there on make.wordpress.org/meetings.</p>\n\n\n\n<p>So you never have to wonder where folks are meeting to talk about things ever again. And that my friends is your small list of big things. Thank you for tuning in today for the WordPress Briefing. I&#8217;m your host, Josepha Haden Chomphosy, and I&#8217;ll see you again in a couple of weeks.</p>\n\n\n\n<p>[<strong>Santana Inniss &amp; Héctor Prieto </strong>00:09:11]&nbsp;</p>\n\n\n\n<p>Hello! Mic test. One, two, one, two.&nbsp;</p>\n\n\n\n<p>We are testing the USB microphone. Let&#8217;s hope we&#8217;re using it actually.&nbsp;</p>\n\n\n\n<p>I think so. I think so.&nbsp;</p>\n\n\n\n<p>Yes. Because now I am far, and now I am much closer to the microphone. Yes.&nbsp;</p>\n\n\n\n<p>And I am sitting in the same spot.&nbsp;</p>\n\n\n\n<p>Good. Hello?&nbsp;</p>\n\n\n\n<p>Hello!&nbsp;</p>\n\n\n\n<p>Mic test one, two.</p>\n\n\n\n<p>Mic test one, two.&nbsp;</p>\n\n\n\n<p>[record scratching sound effect]</p>\n\n\n\n<p>[laughter]</p>\n\n\n\n<p>And, close.</p>\n\n\n\n<p>Mic check.&nbsp;</p>\n\n\n\n<p>Mic check.&nbsp;</p>\n\n\n\n<p>[record scratching sound effect]</p>\n\n\n\n<p>I&#8217;m close to the mic. I&#8217;m far from the mic.&nbsp;</p>\n\n\n\n<p>I&#8217;m far from the mic. Wow.</p>\n\n\n\n<p>Not so far.</p>\n\n\n\n<p>[laughter]</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Mon, 13 Jun 2022 11:01:44 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:14:\"Santana Inniss\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:26;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:95:\"Gutenberg Times: Gutenberg Changelog #68 –  WordCamp Europe, Gutenberg 13.4 and WordPress 6.1\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:53:\"https://gutenbergtimes.com/?post_type=podcast&p=21307\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:107:\"https://gutenbergtimes.com/podcast/gutenberg-changelog-68-wordcamp-europe-gutenberg-13-4-and-wordpress-6-1/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:66424:\"<p>Birgit Pauli-Haack, and Mary Job talk with this week&#8217;s special guest Dave Smith about WordCamp Europe, WordPress 6.1 and Gutenberg 13.4. You also learn what in the works via the GitHub repo. </p>\n\n\n\n<ul><li>Music:&nbsp;<a href=\"https://soundcloud.com/xirclebox\">Homer Gaines</a></li><li>Editor:&nbsp;<a href=\"https://www.linkedin.com/in/sandy-reed/\">Sandy Reed</a></li><li>Logo:&nbsp;<a href=\"https://markuraine.com/\">Mark Uraine</a></li><li>Production:&nbsp;<a href=\"https://icodeforapurpose.com\">Birgit Pauli-Haack</a></li></ul>\n\n\n\n<span id=\"more-21307\"></span>\n\n\n\n<p><a href=\"https://gutenbergtimes.com/podcast/gutenberg-changelog-67-wordpress-6-0#shownotes\">Show Notes</a> / <a href=\"https://gutenbergtimes.com/podcast/gutenberg-changelog-67-wordpress-6-0/#transcript\">Transcript</a></p>\n\n\n\n<p class=\"has-large-font-size\" id=\"shownotes\"><strong>Show Notes</strong></p>\n\n\n\n<p>Special Guest: <strong>Dave Smith</strong>, JavaScript Engineer and full-time Core Contributor on the Gutenberg project, sponsored by Automattic as part of the Five for the Future program.</p>\n\n\n\n<ul><li><a href=\"http://youtube.com/daveonwp\">Dave on WP</a> YouTube Channel </li><li>WP Profile: <a href=\"https://profiles.wordpress.org/get_dave/\">get_dave</a></li></ul>\n\n\n\n<h2>WordCamp Europe</h2>\n\n\n\n<p><a href=\"https://gutenbergtimes.com/wordpress-6-0-wordcamp-europe-and-roadmap-for-6-1-weekend-edition-217/\">WordPress 6.0, WordCamp Europe and Roadmap for 6.1 –Weekend Edition 217</a></p>\n\n\n\n<p><a href=\"https://wordpress.org/plugins/blockmeister/\">BlockMeister – Block Pattern Builder</a></p>\n\n\n\n<h2>WordPress 6.1</h2>\n\n\n\n<p><a href=\"https://make.wordpress.org/core/2022/06/04/roadmap-to-6-1/\">Roadmap to 6.1</a> for Gutenberg Phase 2</p>\n\n\n\n<p>Video by Dave Smith: <a href=\"https://www.youtube.com/watch?v=8Vj_Oh6jMHw\">Gutenberg Roadmap for WordPress 6.1 &#8211; amazing new features planned!</a></p>\n\n\n\n<p>Matias Ventura: <a href=\"https://twitter.com/matias_ventura/status/1534602705456480260\">Twitter Thread on WCEU and  WordPress 6.1</a> </p>\n\n\n\n<p><a href=\"https://wptavern.com/wordpress-6-1-to-focus-on-refining-full-site-editing-next-phase-collaboration-and-multilingual-features-anticipated-in-2023-2025\">WordPress 6.1 to Focus On Refining Full-Site Editing, Next Phase Collaboration and Multilingual Features Anticipated in 2023-2025</a> (WPTavern)</p>\n\n\n\n<h2>Community Contributions</h2>\n\n\n\n<p><a href=\"https://wptavern.com/lottiefiles-releases-official-wordpress-plugin\">LottieFiles Releases Official WordPress Plugin</a></p>\n\n\n\n<p><a href=\"https://us02web.zoom.us/webinar/register/7616548519194/WN_Af50AS7VQbuyCrUdQnormw\">Gutenberg Times Live Q &amp; A: <strong>Block First Approach at the Pew Research Center</strong> </a>&#8211; Using a mixture of Core and Custom Blocks for a streamlined publishing process, and to create powerful charts and quizzes with Seth Rubinstein, lead developer and Michael Piccorossi, Director of Digital Strategy. (<a href=\"https://us02web.zoom.us/webinar/register/7616548519194/WN_Af50AS7VQbuyCrUdQnormw\">Register now</a>)</p>\n\n\n\n<p><a href=\"https://twitter.com/SethRubenstein/status/1529294274751348736\">Twitter Thread by Seth Rubinstein</a> that inspired the Live Q &amp; A </p>\n\n\n\n<h2>Gutenberg 13.4 </h2>\n\n\n\n<p><a href=\"https://github.com/WordPress/gutenberg/releases/tag/v13.4.0\">Gutenberg 13.4 </a>(Changelog on GitHub)</p>\n\n\n\n<p><a href=\"https://make.wordpress.org/core/2022/06/10/whats-new-in-gutenberg-13-4-8-june/\">What’s new in Gutenberg 13.4? (8 June)</a></p>\n\n\n\n<p><a href=\"https://make.wordpress.org/core/2022/03/23/migrating-wordpress-e2e-tests-to-playwright/\">Migrating</a><a href=\"https://make.wordpress.org/core/?p=94139\">&nbsp;WordPress E2E tests to Playwright</a></p>\n\n\n\n<h2>What&#8217;s discussed or in the works</h2>\n\n\n\n<p><a href=\"https://github.com/WordPress/gutenberg/issues/38277\">Nav block: Add design controls for interactive states (:hover, :focus .etc)</a></p>\n\n\n\n<p><a href=\"https://github.com/WordPress/create-block-theme\">Create a Block Theme</a> plugin</p>\n\n\n\n<p class=\"has-large-font-size\">Stay in Touch</p>\n\n\n\n<ul><li>Did you like this episode?&nbsp;<a href=\"https://lovethepodcast.com/gutenbergchangelog\"><strong>Please write us a review</strong></a></li><li>Ping us on Twitter or send DMs with questions.&nbsp;<a href=\"https://twitter.com/maryojob\">@maryojob&nbsp;</a>and&nbsp;<a href=\"https://twitter.com/bph\">@bph</a>.</li><li><em>If you have questions or suggestions, or news you want us to include, send them to&nbsp;<a href=\"mailto:changelog@gutenbergtimes.com\">changelog@gutenbergtimes.com</a>.</em></li><li><em>Please write us a review on iTunes!&nbsp;<a href=\"https://gutenbergtimes.com/itunes/\">(Click here to learn how)</a></em></li></ul>\n\n\n\n<p class=\"has-large-font-size\" id=\"transcript\"><strong>Transcript</strong></p>\n\n\n\n<p><em>Birgit Pauli-Haack</em>: Hello, and welcome to our 68th episode of the Gutenberg Changelog Podcast. In today&#8217;s episode, we will talk about WordCamp Europe. Gutenberg 13.4 and WordPress 6.1, and a lot of other things. I&#8217;m Birgit Pauli-Haack, curator at the Gutenberg Times and WordPress developer advocate. And I&#8217;m here with my co-host, Mary Job, WordPress advocate, support engineer at Paid Memberships Pro, and community organizer at wpafrica.org.</p>\n\n\n\n<p>Good evening, Mary. How are you today?</p>\n\n\n\n<p><em>Mary Job</em>: Oh, I&#8217;m doing absolutely great, Birgit. Thank you for that. Yeah, I&#8217;m doing wonderful. I just recovered from malaria, but I&#8217;m doing great.</p>\n\n\n\n<p><em>Birgit Pauli-Haack</em>: Oh, wow. Yeah, glad you recovered. Yes.</p>\n\n\n\n<p><em>Mary Job</em>: Hi, everyone. I&#8217;m Mary and today I have the honor to present also our special guest tonight. Welcome to Dave Smith, JavaScript engineer, and full-time co contributor on the Gutenberg Project, sponsored by Automattic as part of the Five for the Future program. Thank you so much for joining us tonight, Dave. We&#8217;re happy to have you here, and I&#8217;m sure our listeners are looking forward to listening to you on this episode.</p>\n\n\n\n<p><em>Dave Smith</em>: Well, thank you. And hello Mary and hello Birgit. It&#8217;s a real pleasure to join you here today. I&#8217;m actually a long-time fan of the show. I had a look back at my podcast episodes and I think I&#8217;ve been listening since some of the very earliest, I think. So yeah, it&#8217;s a fantastic resource. In all the time I&#8217;ve been listening, it&#8217;s really helped me keep up-to-date with the latest happenings with the block editor and with WordPress beyond. So yeah, thank you from me for such a great resource, and it&#8217;s a pleasure to be here.</p>\n\n\n\n<p><em>Birgit Pauli-Haack</em>: Well, thank you for these kind words. And I told him to say that. You listeners, you know me.</p>\n\n\n\n<p><em>Dave Smith</em>: Not at all. Not at all.</p>\n\n\n\n<p><em>Birgit Pauli-Haack</em>: No, glad to have you, and it&#8217;s going to be a great show with you here.</p>\n\n\n\n<p><em>Mary Job</em>: Yes, it is.</p>\n\n\n\n<p><em>Birgit Pauli-Haack</em>: Yeah.</p>\n\n\n\n<p><em>Mary Job</em>: I can already feel it&#8217;s going to be a great show. So before we add into the changelog and the rest of the show, Dave, would you briefly tell us what your WordPress origin story is and what your focus is on the Gutenberg project?</p>\n\n\n\n<p><em>Dave Smith</em>: Yeah, absolutely. Well, I&#8217;ve been working on the web since I think about 2013, although I&#8217;ve started to lose count now. And back in those days, the company I worked for had a proprietary PHP based CMS system, but the thing is, I kept getting asked to do freelance work on the side and I didn&#8217;t have a way to provide my clients with a ability to administer their own sites. And so I found WordPress and that was it, I never looked back.</p>\n\n\n\n<p>And so prior to joining Automattic, I was a technical lead at an agency that was based in Bristol, which is here in the south of the UK, where I live. And we use WordPress on everything, from small business websites to very large enterprise builds as well. In fact, at one point I think myself and a colleague, we even developed a sort of pseudo pattern system using advanced custom fields to allow our clients to sort of make their own pages. So we&#8217;ve really done everything, and it&#8217;s quite cool now to see some of this technology being available natively within the editor.</p>\n\n\n\n<p>But I joined Automattic four years ago, and during that time I&#8217;ve been consistently involved in the Gutenberg Project. I&#8217;ve contributed to various features, probably the most well known would be the Navigation Block and the link creation user interface. So right now I&#8217;m part of a team that&#8217;s focused on improving the theme authoring and development experience. And as part of that, most recently I&#8217;ve started my own YouTube channel where I&#8217;m posting my firsthand insights into what&#8217;s coming next in the WordPress block editor project.</p>\n\n\n\n<p><em>Birgit Pauli-Haack</em>: Yeah, that&#8217;s awesome. It&#8217;s interesting that you also tried to build your own, to work on a CMS and that&#8217;s a proprietary, and I think that&#8217;s what a lot of developers did before they joined WordPress. Interesting. Yeah.</p>\n\n\n\n<p><em>Dave Smith</em>: Yeah, absolutely. Yeah.</p>\n\n\n\n<p><em>Birgit Pauli-Haack</em>: Yeah.</p>\n\n\n\n<p><em>Dave Smith</em>: It did work out well, that.</p>\n\n\n\n<p><em>Birgit Pauli-Haack</em>: Yeah.</p>\n\n\n\n<p><em>Dave Smith</em>: I think it was definitely a good move moving to WordPress.</p>\n\n\n\n<h3><strong>Announcements</strong></h3>\n\n\n\n<p><em>Birgit Pauli-Haack</em>: Yeah, definitely. Well, thank you for being here, and that&#8217;s great. So the first part of the announcement was WordCamp Europe, it was absolutely the best. It has been three years, and I was meeting so many friends and made new ones, it&#8217;s a wonderful thing. And I&#8217;m so glad that I actually met you Dave in person for the first time. Did you get home all right? And I know it was your first WordCamp, so what are your takeaways?</p>\n\n\n\n<p><em>Dave Smith</em>: Yeah, absolutely. It was a real pleasure to meet you finally, Birgit, after so long that we&#8217;ve been unable to do that. But yeah, I had a fantastic time. It was, as you said, my first WordCamp of any kind actually, not just WordCamp Europe.</p>\n\n\n\n<p><em>Birgit Pauli-Haack</em>: Cool.</p>\n\n\n\n<p><em>Dave Smith</em>: Yeah. So for me, it was just really good to see the community in person, in evidence of what amazing community we have, and it was just fantastic to sort of meet all these people for the first time. Yes, I did have some travel disruption from the UK, there was a lot of problems in the UK with getting to Europe at this time. So I did, in fact, miss the contributor day, which I was hoping to go to, which was a shame. But on the other side, I did get there for the main conference and I saw lots of talks and I got to meet lots of contributors. So it was a really, really good experience. And how about you both? I mean, I&#8217;m guessing this wasn&#8217;t the first WordCamp for either of you, right?</p>\n\n\n\n<p><em>Mary Job</em>: Oh, for me, I wasn&#8217;t at this year&#8217;s WordCamp Europe. I&#8217;ve been trying to get to WordCamp here probably for how long now, but I wasn&#8217;t able to get to it, but definitely not my first WordCamp.</p>\n\n\n\n<p><em>Birgit Pauli-Haack</em>: So you must have felt quite some FOMO fear of missing out when you saw all the tweets coming through and all the pictures.</p>\n\n\n\n<p><em>Mary Job</em>: No, I intentionally didn&#8217;t follow the news because I didn&#8217;t want to cry this time.</p>\n\n\n\n<p><em>Birgit Pauli-Haack</em>: Mm-hmm. Oh, yeah and I would&#8217;ve loved to meet you.</p>\n\n\n\n<p><em>Dave Smith</em>: Another time.</p>\n\n\n\n<p><em>Birgit Pauli-Haack:</em> Yeah. We need to work on the WordCamp Africa there, definitely.</p>\n\n\n\n<p><em>Mary Job</em>: Oh, yes.</p>\n\n\n\n<p><em>Dave Smith</em>: Yeah.</p>\n\n\n\n<p><em>Mary Job</em>: Yes. I&#8217;ve been getting a lot of people asking about it, but we&#8217;re still working on it. We need to get to know each other in the community for us, that&#8217;s what I always say, and then we can have a WordCamp.</p>\n\n\n\n<p><em>Birgit Pauli-Haack</em>: Yeah, because you can&#8217;t do it alone. When I looked at the last pictures that I took for WordCamp Europe, there were about 200 organizers and volunteers, or 250, to make it all happen. And it&#8217;s a huge effort and they planned it all for a year almost. Yeah, Dave, you were right, I haven&#8217;t counted yet, but it was probably my 20th WordCamp also.</p>\n\n\n\n<p><em>Dave Smith</em>: Right.</p>\n\n\n\n<p><em>Birgit Pauli-Haack</em>: Or close to it. Yeah.</p>\n\n\n\n<p><em>Mary Job</em>: Oh, wow. I want to be like you.</p>\n\n\n\n<p><em>Birgit Pauli-Haack</em>: Oh, no, you don&#8217;t want to be like me. It&#8217;s hard being me. Yeah, and I was blown away by the community&#8217;s ability to show up. So at contributor today it was the biggest contributor day ever in the history of WordCamps, with over 800 people. And normally they&#8217;re between 200 and 400, but 800 people were really great.</p>\n\n\n\n<p><em>Dave Smith</em>: Wow.</p>\n\n\n\n<p><em>Birgit Pauli-Haack</em>: Yeah. And that was the first part, and the other part was that, it was a real hug fest with meeting all the friends we haven&#8217;t seen for three years. It was such a great atmosphere, there was a great energy, everybody was nice and excited. There were also quite a few block editor-related talks and dear listeners you will find links to the times spans of the livestream recording in our weekend edition, number 217.</p>\n\n\n\n<p>And of course we link it in the show notes, but there were a great mix between code examples, high-level strategy and future exploration. And then the workshops were recorded, but not live streamed, so we don&#8217;t have links yet, but they will be uploaded soon to WordPress TV, and we&#8217;ll let you know in a future episode. So Dave, did you get to see any talks at the WordCamp Europe?</p>\n\n\n\n<p><em>Dave Smith</em>: Yeah, I certainly did. Yeah, I agree with you, there was a really good mix of talks and I thought that was great to see because there was probably something in there for everyone. And I enjoyed listening to a number of them, including one by someone you might know, your excellent ex co-host, Grezgorz, who&#8217;s obviously a colleague of mine at Automattic, but I really enjoyed his talk. But as someone who&#8217;s a full-time contributor to the project, for me, I was just mainly curious to see the sort of topics that folks were interested in having presentations about, and also to sort of listening to the Q&amp;A, because that can often be very revealing as I&#8217;m sure you know.</p>\n\n\n\n<p><em>Birgit Pauli-Haack</em>: Yeah.</p>\n\n\n\n<p><em>Dave Smith</em>: But of all the talks that I saw, I think the one that really stood out to me was the block pattern revolution, which was by Sean Blakely, I think was his name. And in this talk, he covered how his, he works for a very large agency, and in the talk he sort of was just describing how the agency&#8217;s actually using Gutenberg patterns to improve the website creation process as a whole. So it just really resonated with me, because I don&#8217;t know if I said, but worked in agencies for about 10 years prior to joining Automattic, so it&#8217;s a really tough environment to create something, and as you would know, Birgit, of course.</p>\n\n\n\n<p>And I was just really fascinated to learn how they were using the editor itself as a designer developer collaboration tool. And that was just fascinating to me, that actually using WordPress that as part of the design experience and before that. And one of the tools they did a shout out for was something called the BlockMeister plugin. And what it does is, it gives you a custom post type for patterns, or at least that&#8217;s what I understand. So you can sort of build the patterns themselves within the editor, and they do that sort of collaboratively, not only with the designers and the developers, but also with the client.</p>\n\n\n\n<p>So the client&#8217;s kind of kept in the loop and they see the design evolving in the browser via WordPress, via patterns. And all of this work helps avoid, what we call in the industry, the big reveal, where the big reveal was always where someone went away and Photoshopped, designed the site and went, &#8220;Ta-da,&#8221; and the client said, &#8220;I hate it, I want the logo bigger,&#8221; that kind of thing. And by doing it in WordPress like that, they avoid that, and I just thought that was fascinating.</p>\n\n\n\n<p><em>Birgit Pauli-Haack</em>: Yeah. And doing it in WordPress also adds another layer of experience to it, because it&#8217;s clickable.</p>\n\n\n\n<p><em>Dave Smith</em>: Yeah.</p>\n\n\n\n<p><em>Birgit Pauli-Haack</em>: Kind of people, the client can see what happens when I click on it, and all that. So they also start thinking about that quite a bit.</p>\n\n\n\n<p><em>Mary Job</em>: Yeah.</p>\n\n\n\n<p><em>Dave Smith</em>: Yeah. And it&#8217;s super easy to prototype, change those layouts and change things around. So yeah, definitely.</p>\n\n\n\n<p><em>Birgit Pauli-Haack</em>: Yeah. It was a kind of a complimentary talk to Tammie Lister&#8217;s lightning talk. No, it wasn&#8217;t a lightning talk, it was a full talk on design systems in future WordPress and how to kind of use all the tools, all the units of the block editor to build a design system that can be reused. And I think that was a great example of that, what Sean lately showed.</p>\n\n\n\n<p><em>Dave Smith</em>: Yeah. And these are topics that have been going around in the web community for a long time, but it&#8217;s just really good that we&#8217;re now seeing the editor as a way to deliver some of these things that have been talked about for so long.</p>\n\n\n\n<p><em>Birgit Pauli-Haack</em>: Mm-hmm.</p>\n\n\n\n<p><em>Dave Smith</em>: So yeah, and I think it was really inspiring.</p>\n\n\n\n<p><em>Birgit Pauli-Haack</em>: Yeah. Excellent. Yeah.</p>\n\n\n\n<p><em>Dave Smith</em>: But I didn&#8217;t get to make it to any of the workshops, I&#8217;m afraid though. I heard there was a lot of good things about a number of them, but there was one about the block themes by Daisy Olsen, did either of you, well, of course, Birgit, you were there. So did you manage to attend that one?</p>\n\n\n\n<p><em>Birgit Pauli-Haack</em>: No. It was fully booked fast, early in the morning.</p>\n\n\n\n<p><em>Dave Smith</em>: Yeah.</p>\n\n\n\n<p><em>Birgit Pauli-Haack</em>: And I&#8217;m not an early riser, so I didn&#8217;t get in. But I heard great comments about it and it was recorded, and it will be published on the WordPress TV. And there was a lot of people there, I think it was full by 100 people also, it was a really great interest on block themes. And I had some conversations with people about propagating updates of block patterns, and that was kind of an interesting, near the reveal, but that&#8217;s a new word that I learned from you.</p>\n\n\n\n<p>It was an interesting aspect of it, that there are quite a few entities like the block patterns, the theme when it was used, when it already was edited by a user and the blocks that are not dynamic blocks, when you change them, you only change them for a new, but never go back to propagate those changes to the former instances of patterns or blocks or even a theme. Because if a user touched it, the new design on the template part or template will not come into that install when you update the theme.</p>\n\n\n\n<p>So for that part, I know you could always do an additional block part, a block pattern and make that an upgrade. But it&#8217;s interesting that some of the mechanisms that worked before are hard to come by now. So I&#8217;m sure that we will kind of see some updates there and discussions in the community even more, but that was kind of what came out there.</p>\n\n\n\n<p><em>Dave Smith</em>: I definitely hear the conversation around block patterns, particularly, and there&#8217;s a desire somewhere there, I think to be able to have a central source of truth for block patterns, and be able to put them into lots of different posts, but then come back and be able to say, &#8220;Oh, I want to change the border color and add this block,&#8221; and have that propagate to all the previous instances of patterns.</p>\n\n\n\n<p><em>Birgit Pauli-Haack</em>: Mm-hmm.</p>\n\n\n\n<p><em>Dave Smith</em>: But of course, as you know, patterns are supposed to be a one-time thing. Once they&#8217;re in the editor, that&#8217;s it, they&#8217;re not tied back to anything, they&#8217;re just blocks again. So it&#8217;s not something we can do now, but it seems to be something that people want. So whether this is a workflow thing that we just need to do better at describing to people how the different options they got, or whether this is a new sort of, a new desire for a whole new paradigm of something that&#8217;s sort of halfway between a reusable block and a pattern and a template part. It&#8217;s all a bit muddy at the moment.</p>\n\n\n\n<p><em>Birgit Pauli-Haack</em>: Yeah. And the reusable block actually does that. So if you change a reusable block, it propagates the other instances. So I think that, I don&#8217;t know if that can be duplicated or maybe the transformation API can help with that, but these are all conversations for GitHub. And later on, speaking of what&#8217;s next for WordPress Gutenberg Phase 2.</p>\n\n\n\n<p>So for the keynote, there was the AMA town old style, interact with Matt Mullenweg at the end of WordCamp Europe. Matias Ventura was supposed to be on stage, he couldn&#8217;t make it, but he had prepared a few things. But what also happened was that day, he also published the roadmap for 6.1 for the Gutenberg Phase 2, which is the customization part.</p>\n\n\n\n<p>And Ventura, he wrote the tune of the release will be to refine the experiences introduced, 5.9 and 6.0, weave the various flows into more coherent and fulfilling experiences for users, maintainers and extenders and close some gaps in functionality.</p>\n\n\n\n<p>As we start to look towards Phase 3 of the Gutenberg roadmap, Phase 3, just as a note, that was the end of the quote. But Phase 3 for Gutenberg is collaborative editing, like Google style collaborative editing. So Dave, you created a short video introducing your top five features, you are excited about coming to WordPress 6.1, what were they?</p>\n\n\n\n<p><em>Dave Smith</em>: Yeah, I did. And it&#8217;s on my channel, which will be in the show notes. But I based my video largely around the GitHub tracking issue that Matias has been updating after WordPress 6.0 was launched. And obviously now he&#8217;s come out and subsequently posted the high-level overview on make blog. But the video just aims to be a really quick and easily digestible overview of everything that&#8217;s sort of planned for 6.1, for anyone who wants to get up to speed quickly and what&#8217;s coming next.</p>\n\n\n\n<p>And it&#8217;s not really canonical, I think Matias has posted it as the place you want to look, that said, I mean, my video does seem to sync with what Matias said quite well, which is mainly there&#8217;s site editing and template changes. There&#8217;s going to be a lot of focus on patterns. There&#8217;s going to be upgrades to the whole styling, the way we deal with styling and editor, and then obviously upgrades to key blocks like nav block and comments block. And then we&#8217;ve also got theming improvements coming. And we can talk about those in a little bit more detail if you&#8217;d like.</p>\n\n\n\n<p><em>Birgit Pauli-Haack</em>: Yeah. Well, talking about the template editor, there are a few more additional stages there, like a browse stage or a view of that is to come. And then the unifying kind of, like you can zoom out of a template and see the full page, and then you can zoom in again to make those changes. And one goal is also to provide more clarity. And that&#8217;s definitely good news for the community and the theme developers, more clarity between the global elements like templates, template parts and styles.</p>\n\n\n\n<p><em>Dave Smith</em>: Yeah.</p>\n\n\n\n<p><em>Birgit Pauli-Haack</em>: And then the improvement of navigation block that had a few iterations and could do some more.</p>\n\n\n\n<p><em>Mary Job</em>: Yeah.</p>\n\n\n\n<p><em>Dave Smith</em>: Yeah, the navigation block is a really tough one, and that&#8217;s definitely due some work in this release. I mean, some of the key things for me having worked on it is the ability to carry menus when you&#8217;re switching themes.</p>\n\n\n\n<p><em>Birgit Pauli-Haack</em>: Mm-hmm.</p>\n\n\n\n<p>Dave Smith: And also, there needs to be an improved integration with global styles. And then a lot of people have been asking for things like, &#8220;Can we use different menus on different screen sizes?&#8221; We may be able to look into that. But one of the interesting things that Matias highlighted in his post was the effort that&#8217;s currently actually underway. And we have a prototype already in the plugin, which you may have come across, but to have a way to show the navigation structure outside of the navigation block.</p>\n\n\n\n<p>So at the moment in the Gutenberg editor, there&#8217;s a prototype of a sidebar that will come in and you can manage the structure, the data of your navigation, and that&#8217;s kind of separate from the block, which if you think about the block, it also ties together visual aspects as well, so that&#8217;s something that I&#8217;m definitely going to be focused on as part of my work.</p>\n\n\n\n<p><em>Birgit Pauli-Haack</em>: Yeah.</p>\n\n\n\n<p><em>Dave Smith</em>: And in terms of patterns, we&#8217;ve got the aerial view, which is, I don&#8217;t know if anyone&#8217;s seen this yet, but it&#8217;s like a zoomed out view of the editor canvas, and that&#8217;s going to be really exciting because it means we&#8217;ll be able to think about patterns more as sections of a website. And instead of having to deal with all the sort of low level, fine grain blocks and it can get a bit confusing and too many options, we might be able to give our clients a, &#8220;Go into this section editor view, and you&#8217;ll be able to just pick the block patterns and quickly build out a site.&#8221; And it sort of resonates quite well again with what we are discussing from the talk by Sean earlier, then you can imagine how those two things would play together very, very nicely.</p>\n\n\n\n<p><em>Birgit Pauli-Haack</em>: Mm-hmm. Yeah. And I see that Matias Ventura also mentioned that managing safe patterns would also be part of the roadmap or at least the goal is on it. So that kind of probably comes back to the discussion about safe patterns and kind of get back to it when you transform it and also kind of maybe even propagated through the updates through that. Mary, do you see anything in there that excites you for 6.1 that you want to talk about?</p>\n\n\n\n<p><em>Mary Job</em>: Oh, for me, I think it&#8217;ll be the patterns. I&#8217;m liking the fact that people can actually contribute patterns. Like you literally have, you don&#8217;t need to be a programmer to contribute to that.</p>\n\n\n\n<p><em>Birgit Pauli-Haack</em>: Yes.&nbsp;</p>\n\n\n\n<p><em>Dave Smith</em>: Yeah, that&#8217;s really, really important.</p>\n\n\n\n<p><em>Birgit Pauli-Haack</em>: Yeah. Pen and directory. Yeah, it&#8217;s open for submissions. Yes. Yeah, it&#8217;s awesome. And there are probably, I saw a number, like 10,000 patterns that are in the directory, but they are also translated in multiple languages. So it could be a thousand translated into 10 languages, so that made quite a few.</p>\n\n\n\n<p><em>Mary Job</em>: So-</p>\n\n\n\n<p><em>Birgit Pauli-Haack</em>: So&#8230; Yeah, go ahead.</p>\n\n\n\n<p><em>Mary Job</em>: No, I was going to say, it might seem like a small feature, but I think it&#8217;s going to make WordPress more accessible.</p>\n\n\n\n<p><em>Birgit Pauli-Haack</em>: For sure. Yeah.</p>\n\n\n\n<p><em>Mary Job</em>: More accessible to more people in far corners of the globe, because then literally it means that you don&#8217;t have to be actively into the ecosystem for you to be able to use WordPress.</p>\n\n\n\n<p><em>Birgit Pauli-Haack</em>: For sure. Yeah. Good point. So what else is in the 6.1? Yeah, we have this great discussion about responsive and intrinsic design, where I see some people in the community kind of missing the view points, kind of the break points for the tablet, mobile and desktop view. And I think there are some philosophy, or there&#8217;s the more modern way to do it is with intrinsic design, because all the break points are pretty arbitrary and you have different sizes even beyond those.</p>\n\n\n\n<p>And it also has to do with the components because you can use a column or a cover block over the full website or width of the website, or you can put it into a column, in a two-column website, and it still needs to behave and be adapted to it. So I think the same with the fluid typography system and managing web fonts that is in the works. And so we&#8217;ll see quite a few things changing here.</p>\n\n\n\n<p><em>Dave Smith</em>: Definitely. I think we&#8217;ve seen with the way CSS works and it&#8217;s evolved towards things like using CSS grid for layout. I mean, that&#8217;s intrinsic by nature, we don&#8217;t have to give all the individual break points and say, &#8220;At this size, you should do this, at this size you should do that,&#8221; you just tell the algorithm how you want it to behave, and it just does the layout for you.</p>\n\n\n\n<p><em>Birgit Pauli-Haack</em>: Mm-hmm.</p>\n\n\n\n<p><em>Dave Smith</em>: And I think it&#8217;s been something that, as you say, people have been asking for media queries in Gutenberg for some time, but if we can avoid having to do that, for the majority of users it&#8217;s going to provide a much better experience, because whilst we are all intimately familiar with media queries and having to change break points, the majority of our users are not going to be, and nor would they want to be.</p>\n\n\n\n<p>So we want it to be so it just works, I&#8217;ll be interested to see how far we can take that, I mean, whether at some point we&#8217;ll end up having a medic, a break point interface in Gutenberg is a bigger question that I&#8217;m not qualified to answer, but it certainly will be interesting. But you mentioned fluid typography, I mean, we&#8217;ve already got, I&#8217;ve seen a PR for that very recently, and so that is on the way, I mean, we&#8217;re going to have this system where the font size will adapt appropriately based on the size of your view port, and it&#8217;s a hot topic the in CSS world right now, and bringing it already into the editors is a big win.</p>\n\n\n\n<p><em>Birgit Pauli-Haack</em>: Mm-hmm. Yeah. And I think the page fillers that have been in business for five to seven years, there wasn&#8217;t anything about intrinsic design available, it was just the way to adapt to different screen sizes was through media queries. I think Jen Simmons, who kind of coined the word, intrinsic design, only talked about it since 2019 or something like that, or &#8217;18, but it&#8217;s already four years old. I always think that the two years of COVID, it&#8217;s kind of half a year, but it has been two years. I&#8217;m kind of getting my history a little bit bogged down. Yeah. A sense of time is skewed.</p>\n\n\n\n<p><em>Mary Job</em>: It feels like it was for four years or five.</p>\n\n\n\n<p><em>Dave Smith</em>: Yeah.</p>\n\n\n\n<p><em>Birgit Pauli-Haack</em>: Yeah. At one point it&#8217;s just yesterday and then one point it&#8217;s five years. Yeah. Yeah, and the last part or sections that Matias Ventura mentioned was the theming improvements with a theme building plugin that&#8217;s in the works and will come to the repo pretty soon, to the WordPress plugins repo. So you could export it or you can create a new block theme, or you can have all the user settings that you put into the theme exported to have it in the theme. So it sounds like a really good plugin to come and then also have templates and parts put between themes. Yeah, that&#8217;s another paradigm shift a little bit, it kind of makes it interesting. Yeah, it&#8217;s not only the template parts of&#8230; Yeah.</p>\n\n\n\n<p><em>Dave Smith</em>: Yeah. Well, if you&#8217;re working on a template or a part, you&#8217;ve crafted that in one theme and there&#8217;s no reason why you wouldn&#8217;t expect that to be taken over to a new theme if you switch. And I think that&#8217;s really the goal is to make the content, not so tightly coupled to your theme, and we&#8217;ve already sort of broken the design away from the theme to some extent, and it&#8217;s just that doing the same with the content and templates and parts is definitely a goal that we should be looking to achieve.</p>\n\n\n\n<p><em>Birgit Pauli-Haack</em>: Yeah. And that&#8217;s where also it comes in, that blocks are separate from the theme. Yeah, because if you have a site title tag, it doesn&#8217;t matter what the header is, if the site title block is in it, it will show up right, and that&#8217;s really great. Yeah.</p>\n\n\n\n<p><em>Dave Smith</em>: Yeah, absolutely. I&#8217;m also looking forward to the comments form block coming, maybe in 6.1, because we&#8217;ve had the comments query loop land in 6.0. But I think the form is still using a Pitch P server side rendering, there&#8217;s like a legacy form of the block, an initial form of it.</p>\n\n\n\n<p><em>Birgit Pauli-Haack</em>: Yeah.</p>\n\n\n\n<p><em>Dave Smith</em>: But to have a fully block based comments form block is going to be quite something, I think. It&#8217;s my understanding of it, I&#8217;ve been speaking to some of the people working on it, is that it&#8217;s pretty complex to realize, but if we do realize it&#8217;s going to be a bit like the navigation block in that it will provide a lot of knock-on benefits to the wider block ecosystem. So I&#8217;m excited to see how that develops in this release cycle.</p>\n\n\n\n<p><em>Birgit Pauli-Haack</em>: Yeah, it also could be kind of a prototype on how forms handling can be done in block fashion. So yeah, it&#8217;s definitely something to look forward to. And one of the goals for the 6.1 is also to allow for gradual adoption of the full-site editing features and see if one or other features can be modified to be available for the classic themes. For instance, calling a full-site editing template part and headers and footers, but the rest of it is still a classic theme.</p>\n\n\n\n<p>I saw a few PRs there, it was also the conversation that, so Matias was on the show after he published a roadmap for 6.0, and in that conversation, he also talked about that FSE or block themes, not necessarily need to replace classic themes, it just adds a few layers of user interactions that can be switched on and off with the block locking features and theme JSON, for the theme builder. But it enhances actually classic themes, and they can all be used side by side, and it&#8217;s just an evolving of the whole template, and then the interaction with the global styles.</p>\n\n\n\n<p>And maybe we can get that to be a little bit more cohesive with the classic themes and not have that. Our language is like, there is a break, there&#8217;s going to be a break one time we do that, and then the next time we are doing something totally different, and the old one is not good anymore, which isn&#8217;t the case because it&#8217;s all WordPress and it&#8217;s all feasible. And why should a theme developer need to change if the market doesn&#8217;t really value that.</p>\n\n\n\n<p><em>Dave Smith</em>: Yeah, absolutely.</p>\n\n\n\n<p><em>Birgit Pauli-Haack</em>: So I think we need to really be conscious about that. We are not kind of before and after, and as well as kind of put it together with that.</p>\n\n\n\n<p><em>Dave Smith</em>: I like the way Matias thinks about these things, because I know that there&#8217;s been quite a few people exploring sort of hybrid or universal themes where I think my colleague, Ben Dwyer posted on ThemeShaper blog, which is a blog all about, surprisingly, about theming. And he had a couple of explorations where they were sort of, it was like a halfway house between a classic theme, but it was also consuming blocks in a different way, and I think that&#8217;s a really healthy way of thinking about things rather than this sort of hard dividing line. You either are on the classic theme or you&#8217;re on a block theme, it&#8217;s like there is a middle ground there somewhere for people to explore, and I think that&#8217;s really healthy.</p>\n\n\n\n<p><em>Birgit Pauli-Haack</em>: Yeah.</p>\n\n\n\n<p><em>Dave Smith</em>: I think it&#8217;s really good for the ecosystem.</p>\n\n\n\n<p><em>Birgit Pauli-Haack</em>: Well, and WordPress has the promise of the backwards compatibility, everything that the classic themes do is in rapid score and it will stay there.</p>\n\n\n\n<p><em>Dave Smith</em>: Indeed.</p>\n\n\n\n<p><em>Birgit Pauli-Haack</em>: I haven&#8217;t seen any talk or any effort at all yet to kind of make that obsolete or something like that.</p>\n\n\n\n<p><em>Dave Smith</em>: Right.</p>\n\n\n\n<p><em>Birgit Pauli-Haack</em>: It&#8217;s just, I know it&#8217;s a fear in the community, but I think there&#8217;s just, trust the system. You trusted it before the last 19 years there, now we go into the next 25 years or so. So yeah, all right, that&#8217;s all about the philosophies.&nbsp;</p>\n\n\n\n<h3><strong>Community Contributions</strong></h3>\n\n\n\n<p>So for community contributions, I only have two things in there. So Lottie has created an official plugin for the WordPress repository to bring animations to the block editor and the interface to control the settings for the animation.</p>\n\n\n\n<p>And it&#8217;s a single block plugin, and this is really cool, if you are not a fan of gradients and if you&#8217;re not a fan of dual tone, you&#8217;re probably also not a fan of animations, but for those who play around with all of the things, it&#8217;s really cool that you have additional interfaces there and additional interaction pretty much. So WordPress Tavern has an article about it, and we also shared it of course, in the show notes, and there are other plugins who offer that, but this is the official LottieFiles plugin.</p>\n\n\n\n<p>And so if you are into that and want this to offer some of your client site, check it out. All right. And the second thing that I wanted to let our users know, or our listeners know, we just scheduled the next Gutenberg Times live Q&amp;A. We haven&#8217;t had one for quite a while, I think the last one was in October, and the title is, Blocked First Approach, at the Pew Research Center, using a mixture of core and custom blocks for a streamlined publishing process, and to create powerful charge and quizzes.</p>\n\n\n\n<p>Guests will be Seth Rubenstein, the lead developer of Pew Research website and Michael Piccorossi, who&#8217;s the head of digital, it&#8217;s the content creators. And right now I only have save-the-date, it&#8217;s July 22nd 2022 at 11 Eastern Daylight 1500 UTC. And it was inspired by this Twitter thread that he started out with saying for all its naysayers, &#8220;Gutenberg is a game changer for digital news apps. It&#8217;s a force multiplier for your team, we&#8217;ve spent the last three years going all in on block development.&#8221; And then he followed up with a thread that we definitely will discuss in that show. So save-the-date, July 22nd 11:00 AM Eastern 1500 UTC.</p>\n\n\n\n<h3><strong>What’s Released</strong></h3>\n\n\n\n<p><em>Mary Job</em>: Moving on to what&#8217;s released, this brings us to the latest Gutenberg plugin release, 13.4 246 contributors match PRs for this release and among them are five new contributors.</p>\n\n\n\n<p><em>Birgit Pauli-Haack</em>: Yay, five new contributors. Excellent. Congratulations. Yeah, so there are quite a few enhancements in this release.&nbsp;</p>\n\n\n\n<h3><strong>Enhancements</strong></h3>\n\n\n\n<p>We have, one is, the gallery block now has an opt-in axial block spacing control. So you can control separately the columns, gata, as well as the rogue gata. So you can have interesting layouts for your gallery.</p>\n\n\n\n<p>That is really great, I saw some of the designs that are in the PR, it&#8217;s 41175. Yeah, it&#8217;s definitely great. Another enhancement is that the search block has now the ability to specify additional search query variables, so you can add additional parameters to the URL and share that, so that is like a post type product, or a post type book or any of the other variables there, it could be a date, it could be a category as well.</p>\n\n\n\n<p><em>Dave Smith</em>: Yeah, it&#8217;s really powerful that, especially if you&#8217;re using WooCommerce or another eCommerce system, like to be able to just say to the search block, &#8220;I want to search my products.&#8221; That&#8217;s definitely something that&#8217;s been missing for quite a while, so I was pleased to see that land.</p>\n\n\n\n<p><em>Birgit Pauli-Haack</em>: Mm-hmm. Yeah, definitely. Another one is that a color picker finally strips out the hash sign from the pasted hex values, when you come in from a color style guide or something like that, and you just want to add the color to a block entity and you didn&#8217;t know if you use the hash or not the hash, and it now strips out the hash and you don&#8217;t have to worry about it anymore. There were also some design updates to the published pop over time, daytime picker, so that&#8217;s definitely also a quality of life kind of change. It&#8217;s a bit better to navigate that.</p>\n\n\n\n<p><em>Dave Smith</em>: Yeah, we&#8217;ve seen a number of upgrades to that in recent times. It&#8217;s getting better and better. I definitely appreciate Rob&#8217;s work on this one, especially, he&#8217;s been looking really hard at sort of making it work in different scripts and different languages, which is obviously really important because we don&#8217;t all speak English.</p>\n\n\n\n<p><em>Birgit Pauli-Haack</em>: Yeah. Well actually the majority of installations are not in English, so definitely a good….</p>\n\n\n\n<p><em>Dave Smith</em>: Important work.</p>\n\n\n\n<p><em>Birgit Pauli-Haack</em>: Totally. Yeah. And all the people that use WordPress actually benefit from that quite a bit.</p>\n\n\n\n<p><em>Dave Smith</em>: Yeah, I was also interested in another one, another PR that came, landed in this release, which was the adding support for button elements to theme JSON. So this is something that&#8217;s part of a wider effort that&#8217;s really to allow themes to better target specific HTML elements within blocks, without requiring custom CSS. So currently you can kind of say, &#8220;Within the editor globally or within this block, I want to target all link elements or H3 elements, or whatever.</p>\n\n\n\n<p>And I want to make them a certain color, or I want to add certain spacing.&#8221; But it&#8217;s fairly limited. And so there&#8217;s an effort underway to sort of expand that range of elements that you&#8217;ll be able to target. And the real key here is it&#8217;s going to be able to sort of reduce the amount of sort of specificity wars that we have with CSS, where we&#8217;re trying to overload core styles with custom CSS, if you&#8217;re looking to extend your block.</p>\n\n\n\n<p><em>Birgit Pauli-Haack</em>: Yeah.</p>\n\n\n\n<p><em>Dave Smith</em>: The best thing about this feature is I can see is that it&#8217;s actually going to allow these elements to be exposed by global styles, so if you&#8217;re going to the global styles UI as a normal user and be able to say, &#8220;I want all my links to be this color,&#8221; or &#8220;I want all my links within the paragraph block to be slightly another color,&#8221; or &#8220;I want to have an underline,&#8221; or whatever.</p>\n\n\n\n<p>And that&#8217;s really powerful because it means we&#8217;re removing the need for our users to have to understand CSS, which has always been a problem, and we still hear that, &#8220;Please we need the custom CSS field back in the editor.&#8221; But by moving these things and inter-theme JSON, we do allow this to be exposed in a much more intuitive way via UI, so that&#8217;s an important thing to do.</p>\n\n\n\n<p>And if we think about into the future, we&#8217;re going to have this rolled out towards all sorts of form elements. So imagine you can say, &#8220;Oh, I want all input type elements, including sort of text areas and things like that to have this color border,&#8221; and you can just do that in one go, without having to know all the relatively complex CSX CSS selectors that you&#8217;d need to know to target all form elements. And if you&#8217;ve ever tried to style a form using CSS, you know exactly what I&#8217;m talking about, it&#8217;s not the simplest of things after this many years of CSS, it&#8217;s still quite tricky.</p>\n\n\n\n<p><em>Birgit Pauli-Haack</em>: It&#8217;s still quite tricky, yes that&#8217;s true. And there are quite a few PRs that support those button elements in theme JSON, like also the fire blocks and the search blocks have a button that now is an element button, so it follow that design that you will have in theme JSON as well. And also in the post comments, the buttons there as well. So I think the buttons are moving forward with that and that informs on the designers and developers on how well it&#8217;s going.</p>\n\n\n\n<h3><strong>APIs&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;</strong></h3>\n\n\n\n<p>And if there is some need for adjustments there, how to do that. And then we had a few, for developers there&#8217;s a new API available now that moves the visible block state into the block editor store, so that means that anybody who can tap into the store API can see if a block is visible or not, so you have some conditional handling in any of the, be it a plugin or in additional blocks. So that is definitely an improvement for extensibility.</p>\n\n\n\n<p><em>Dave Smith</em>: Yeah, absolutely. And as we move forward with patterns, I think that&#8217;s going to be important because we&#8217;re going to be able to detect whether the block is actually currently shown on the current screen, like it might be off the screen, it might be below the scroll fold, so that&#8217;s going to be an important thing, previously it was sort of hidden in the react context and you couldn&#8217;t get a hold of it, but now they&#8217;re exposing it, and I think it&#8217;s part of the work to do what we talked about earlier with this sort of aerial exploded view of the block patterns, the sort of blocks as sections that Matias has mentioned in this post, so this is work towards that roadmap already?</p>\n\n\n\n<p><em>Birgit Pauli-Haack</em>: Yeah. We also had some three PRs that are very influential on the performance of the websites or the block editor, and one is that the auto completer performance is improved. And then also the external library react spring was upgraded, actually two versions, two full versions from 2.4 to 4.5, and it&#8217;s a better handling of the downtime of the block editor. Before it was always something kind of pinging something in the background and it was slowing down the block editor, and now that has been fixed and react spring and now it comes to the block editor as well.</p>\n\n\n\n<p>And the biggest part is that CSS is conditionally loaded per block, so if a block is not on canvas, it will not load the CSS, or on the front end, if it&#8217;s not used, it will also not load the CSS into the file when it&#8217;s rendered. So those are great improvements. We have not seen a make blog yet, I think it&#8217;s coming out tomorrow or later today where also the performance numbers are going to be published, but I think we&#8217;re going to see some improvements there. And I had one other thing, did I jump over some of it?</p>\n\n\n\n<p>So for the developers who are using the create block script, there have been some improvements to the block templates. One is about the dynamic blocks and then also additional template variables in there to make sure that it fixes some of the issues that people run into. And it also remove the wrapping of the diff, so there are no usability issue anymore on, what was it? The edit JSS.</p>\n\n\n\n<p>So what else? Create block always gets some nice additional features to improve the developer experience. We&#8217;re starting out with block development, so I love to highlight that in this changelog that&#8217;s kind of taken over from Grzegorz who is working on it. I really appreciate the work on that because I learned quite a bit through that.</p>\n\n\n\n<p><em>Dave Smith</em>: Yeah, that script is a big time saver. If you ever want to create a block and it&#8217;s gone through so many iterations in the past year, it&#8217;s come on leaps and bounds and anyone who creates a block today should be very thankful to the likes of Grzegorz and other people have been working on that consistently. It&#8217;s a great tool.</p>\n\n\n\n<p><em>Birgit Pauli-Haack</em>: Yeah. Ryan Welcher has also been working on that quite a bit because he uses it every time he does a live twitch stream, he starts out with a create block command line. And he also found, &#8220;Okay, if I want to do a dynamic block, I need a different template. If I want to do instead of a single block plugin, I want to do a multi block plugin, what does the template need to change?&#8221; And he was very instrumental to get those two templates into the grade block and then also talked about it on his twitch theme. So if you ever, I could share some of his videos also on YouTube, in the show notes. So if you wanted to get started, I think it&#8217;s a great way to see how that&#8217;s going to work.</p>\n\n\n\n<p><em>Dave Smith</em>: Yeah, that sounds really good. I was using it to extend a block recently. I wonder if there&#8217;s a template for that, that&#8217;d be interesting to see. So yeah, I&#8217;ll look out for those show notes.</p>\n\n\n\n<p><em>Birgit Pauli-Haack</em>: Mm-hmm.</p>\n\n\n\n<p><em>Dave Smith</em>: Another thing that went into this release was the navigation editor screen has been removed from the experiments page. As I did this PI I&#8217;ve had quite a few questions about it, So I just wanted to talk briefly.</p>\n\n\n\n<p><em>Birgit Pauli-Haack</em>: Mm-hmm.</p>\n\n\n\n<p><em>Dave Smith</em>: And just to clarify, it&#8217;s not necessarily a formal deprecation of the navigation editor screen or the project, but what we were finding is that with the run up to 6.0, and that there weren&#8217;t any contributors who were actively working on that screen, but we still kept getting quite a few bug reports saying it no longer works with the new navigation block entity system, and this thing is out-of-date.</p>\n\n\n\n<p>And we took the decision, that rather than confusing contributors or people are coming to the Gutenberg plugin, we would just hide it for now, and therefore we wouldn&#8217;t have so many bug reports from people spending time in basing those when they didn&#8217;t need to. But it is something that we will, no doubt, utilize some of the technology for, to build things like exposing the navigation structure in the sidebar, which we talked about earlier on. So no doubt it will be harvested for all useful things that happened.</p>\n\n\n\n<p><em>Birgit Pauli-Haack</em>: Mary, is there anything that you wanted to point out from that changelog that we kind of skipped over it?</p>\n\n\n\n<p><em>Mary Job</em>: No.</p>\n\n\n\n<p><em>Birgit Pauli-Haack</em>: Okay. Yeah. Tell me, Dave, about the switch over from Puppeteer to Playwright in the testing suite. What&#8217;s the nature of that?</p>\n\n\n\n<p><em>Dave Smith</em>: Yeah, absolutely. Well, our fellow contributor, Kai Hai, and also Isabelle Brison, they&#8217;ve both been working quite a while now on migrating these tests to a new system called Playwright, away from the existing system called Puppeteer. For those who don&#8217;t know, what we&#8217;re talking about is that Gutenberg has a set of automated tests, which run in a real browser and run against a real WordPress install, but everything&#8217;s kind of thrown away, so it doesn&#8217;t necessarily start if the tests are run.</p>\n\n\n\n<p>But it&#8217;s just asserting that the way the software behaves is correct, and it gives you confidence when you&#8217;re doing release that you haven&#8217;t broken everything. I mean, obviously it can&#8217;t catch every single bug, but it definitely helps to improve things. But what we&#8217;ve been finding is that the software that&#8217;s been underused is called Puppeteer, that controls these tests.</p>\n\n\n\n<p>And we are finding there&#8217;s been a lot of what we call, flaky tests, and these are actually automatically flagged up now in the repo that if a test fails several times, it&#8217;s marked as flaky and then someone&#8217;s supposed to come and deal with it, but they&#8217;ve been building up and building up and there&#8217;s been more and more of them. And Kai actually looked into seeing if there&#8217;s other systems that could help us offer more stable tests.</p>\n\n\n\n<p>And in fact, he concluded and he wrote on make blog at length about moving over to this new system called, Playwright. It&#8217;s much better maintained, there&#8217;s a lot more people working on it, it offers better debugging. But also I think most interestingly it encourages testing of the actual interface that our users experience rather than, there&#8217;s a temptation when you&#8217;re writing these tests to sort of say, &#8220;Get me this element by class name or a ID,&#8221; and then do something with it.</p>\n\n\n\n<p>But of course, normal users can&#8217;t see class names or IDs, so you&#8217;re kind of circumventing, the tests aren&#8217;t testing the real software. So with Playwright, it makes it a lot easier, let&#8217;s say, to test in a way that is more akin to our users. And in the future, we may also be able to test on other browsers. Currently we can only test on Chromium, but we may also in the future be able to run these tests against the likes of Firefox and Safari.</p>\n\n\n\n<p>And hopefully these tests will become faster, more stable and more reliable as a result of this. So I think it&#8217;s really good work and Kai and Isabelle are making good headway on it, and I&#8217;d encourage anyone who&#8217;s looking to contribute and who&#8217;s got experience of testing to come and help them with their effort, because they&#8217;ve got a lot of tests to migrate, but yes, it&#8217;s a very worthwhile project, in my opinion.</p>\n\n\n\n<p><em>Birgit Pauli-Haack</em>: Yeah. Yeah, no, it really sounds like it. Well, I&#8217;m always kind of thinking about who else can use that, is that recommended for plugin developers who built their own custom blocks to also kind of look into the testing suite, the Playwright and kind of reuse some of those tests for their own purpose?</p>\n\n\n\n<p><em>Dave Smith</em>: Yeah. Well, I can&#8217;t say that I personally have done that yet and explored that, but I know that the software itself is designed to be used in any context. I can&#8217;t see why there would be a reason why you couldn&#8217;t do that. I mean, again, it&#8217;s going to be the same process, which is you&#8217;re going to spin up a WordPress install. You&#8217;re going to activate your block plugin and then you are going to create a post, put your block into the post and then interact with it programmatically to determine if it works. So I would imagine that there&#8217;ll be things that we can do to reuse some of the technology we&#8217;ve got in Gutenberg when you&#8217;re building a custom block, so I&#8217;ll be interested to hear if anyone&#8217;s explored that already, and yeah, please do reach out to me or Kai, or Isabelle to discuss that, as I&#8217;m sure they&#8217;d be very interested.</p>\n\n\n\n<p><em>Birgit Pauli-Haack</em>: Awesome. Awesome. All right. I think that concludes our changelog of 13.4. It has a few quality of life things, great enhancements for some of the pieces and then also for developers. So yeah, test it out. It&#8217;s now available in the repo, and that brings us to the section of what&#8217;s an active development or discuss and needs some input.</p>\n\n\n\n<h3><strong>What’s in Active Development or Discussed</strong></h3>\n\n\n\n<p>If you had something that you wanted to talk about, like the ability to control interactivity states in the editor, that, that&#8217;s in the works, and I saw that, is that the java state or the visited state or what else, do you talk about that?</p>\n\n\n\n<p><em>Dave Smith</em>: Yeah, absolutely. Well, you&#8217;ve covered it pretty well there. I mean, there&#8217;s been a request for quite a while to be able to change the way that things look based on how you interact with an element. I think probably the classic example is if you&#8217;ve got a navigation menu, and sometimes when you hover over one of the items in that menu, it changes visually, doesn&#8217;t it, perhaps the color changes or there&#8217;s a background or there&#8217;s an underlying, and that isn&#8217;t possible currently in the editor, which is obviously quite a big failing at the moment and something we need to address.</p>\n\n\n\n<p>So there&#8217;s work underway to allow the ability to target these things, and it&#8217;s actually a much more complex thing than you&#8217;d imagine to achieve in a robust manner, because we need to consider things like, it should be only limited to specific elements and specific properties because it&#8217;s not good to have, if you&#8217;re rolling over a heading, you don&#8217;t want that suddenly changing link color, I mean that would be a very bad thing for accessibility, for some people that will really throw them off.</p>\n\n\n\n<p>So it should only be things like anchors and things that you can interact with or focus. So we&#8217;re going to be starting rolling this out. It&#8217;s going to be, starting with a technical implementation first, so it&#8217;ll land first in theme JSON, so developers will be able to take use of it. But ultimately, it will be rolled out to the global sales interface. So in the future one day, hopefully by 6.1, we will see, you might be able to go into your navigation block, set the color of the text to be blue, for example, but then say, &#8220;Oh, but when the text is hovered or your mouse rolls over it, I want it to go to yellow.</p>\n\n\n\n<p>And if someone focuses it with a keyboard, I want to have a blue underline underneath it.&#8221; And you&#8217;ll be able to do that all through the editor. So again, another way that we&#8217;re removing the need for users to necessarily to understand the ins and outs of CSS, pseudo selectors and things like that. So yeah, a shout out to Andre Draganescu for his work on this feature. And if you want to follow up, it&#8217;s Gutenberg issue number 38277.</p>\n\n\n\n<p><em>Birgit Pauli-Haack</em>: Yes. And of course we will have the link to that issue in the show notes. Now does it also cover in the navigation bar when I am on the page, does it also trigger the active kind of state of&#8230; So I&#8217;m on my about page, does that about page, is there a possibility to give that a different color when I&#8217;m on the about page, so kind of help with the navigation and kind of&#8230; Yeah.</p>\n\n\n\n<p><em>Dave Smith</em>: Yeah. So there is an active pseudo selector in CSS that we could include in this and that might help a bit, but I think in terms of styling something based on what page you are on, if it&#8217;s the current page, for example, then I think there is a known bug again that, that is something that we&#8217;d need to add programmatically in CSS and in PHP to determine, are you on that page and which nav item represents that page and then add the appropriate class name.</p>\n\n\n\n<p>So there&#8217;s kind of two ways that could be tackled. But I mean, ultimately it should be open to any CSS, pseudo selector, but just probably on a limited number of elements, and we&#8217;ve got to liaise with the community and especially the accessibility team to determine what is the most appropriate. So there&#8217;s some really, really good designs that are already out in the wild about this, on that issue.</p>\n\n\n\n<p>And I definitely encourage people to check that out because it shows how the interactions will work, and if you think there should be certain things that it&#8217;s able to do or it&#8217;s not able to do then now is the time to input because it&#8217;s under active development right now and being designed as we speak, so it&#8217;d be great to hear from people if they&#8217;ve got thoughts on it.</p>\n\n\n\n<p><em>Birgit Pauli-Haack</em>: All right. And then I think I mentioned it briefly before. So in the Gutenberg Times weekend edition of 215, I listed three block theme JSON generator or theme generators. And now we have a fourth one to come that&#8217;s the great block theme plugin that will be&#8230; We have a link in the show notes to the getup repo, but it will be a community plugin. What do you know more about it?</p>\n\n\n\n<p><em>Dave Smith</em>: Yeah, this is a plugin that&#8217;s kind of spun out of work that my team would be doing. I mentioned earlier that we&#8217;ve been working on improving the developer and theme or theme authoring experience. And what we found is that there are some things we wanted to do that aren&#8217;t necessarily that appropriate to land in court, it could add additional complexity that everyday users don&#8217;t want to have.</p>\n\n\n\n<p>For example, the much requested feature, which is when you are editing templates in the site editor people often say, &#8220;I want those changes to be persisted back to the file system as pattern files or template part files,&#8221; sorry, &#8220;Templates or template part files.&#8221; But for a normal user, that&#8217;s not something that you&#8217;d probably want to do, but if you&#8217;re creating a theme from scratch, it very much is. So what has been born out of this is this create block theme plugin, create block theme, being the operative word there, theme.</p>\n\n\n\n<p><em>Birgit Pauli-Haack</em>: Mm-hmm.</p>\n\n\n\n<p><em>Dave Smith</em>: And it used to be owned by Automattic, but we decided that it was something that would be beneficial to the wider community. So it&#8217;s now been open sourced and it&#8217;s now the property of the WordPress project. And it&#8217;s very much targeted at theme builders. So if you&#8217;re someone who wants to create a theme from scratch, then this plugin is likely to be something you want to at least take a look at.</p>\n\n\n\n<p>And as I said, things like saving to file system and giving you extra export controls are there, it&#8217;s far from perfect at this point, and I mean, a lot of it has to be accessed from its own dedicated setting screen. It&#8217;s not fully integrated with the editor much as we would like, but it&#8217;s definitely showing promise, and we&#8217;re hoping that it&#8217;ll become the sort of, almost like a standard plugin for the WordPress ecosystem for crafting block themes from scratch.</p>\n\n\n\n<p><em>Birgit Pauli-Haack</em>: Yeah. And I like that it also offers a possibility to create a child theme of the current activity theme, and that you can also clone themes. So it&#8217;s quite powerful in the idea and has already quite a few options in there. And you install it on your site, right, if I understand that correctly.</p>\n\n\n\n<p><em>Dave Smith</em>: Yes.</p>\n\n\n\n<p><em>Birgit Pauli-Haack</em>: And then you have an additional menu item under appearance with a new page that&#8217;s called, create block theme, and then you have all the options that are in there, like set up, style, customization, templates and the save part. And of course you can always use the export theme from the site editor or from the plugin to download the theme. So it&#8217;s quite an interesting plugin and I know that the community has been waiting for that. All right.</p>\n\n\n\n<p>Well, this is the end of the show. It&#8217;s marvelous. And thank you very much for your great contributions here, Dave, you&#8217;ve given us a lot of insights into the background of some of the features and some of the work. So I want to remind everyone again on save-the-date of July 22nd, 11:00 AM Eastern to 1500 UTC with a live Q&amp;A, with the Pew Research Team who builds sites with a block editor, first approach. Also, Dave, when people want to connect with you, how can they find you, and what&#8217;s the URL of your YouTube channel?</p>\n\n\n\n<p><em>Dave Smith</em>: Yeah, absolutely. So I usually appear as, getdave or sometimes get_dave on various websites around the internet. And if you want to get in touch with me, you can find me on WordPress Slack. But also be sure to check out my YouTube channel and you can access that with a link that&#8217;s going to be published in the show notes.</p>\n\n\n\n<p><em>Birgit Pauli-Haack</em>: Fabulous. So, Mary, do you have anything that you didn&#8217;t get in before? So now is your chance.</p>\n\n\n\n<p><em>Mary Job</em>: No, I think we covered everything we wanted to.</p>\n\n\n\n<p><em>Birgit Pauli-Haack</em>: Yeah. How can people reach you?</p>\n\n\n\n<p><em>Mary Job</em>: Oh, me, I&#8217;m maryjob on Twitter. I like spending my time on the streets of Twitter.</p>\n\n\n\n<p><em>Birgit Pauli-Haack</em>: All right. And as always, the show notes will be published on gutenbergtimes.com for this podcast. This is episode 68, and if you have questions or suggestions or news you want us to include, send them to <a href=\"mailto:changelog@gutenbergtimes.com\">changelog@gutenbergtimes.com</a>. That&#8217;s <a href=\"mailto:changelog@gutenbergtimes.com\">changelog@gutenbergtimes.com</a>. So thank you, Mary, for being with us. Thank you, Dave. And thank you everybody for listening. This is it for me, I say goodbye. And until the next time.</p>\n\n\n\n<p><em>Dave Smith</em>:&nbsp; Thank you for having me. See you next time. Bye.</p>\n\n\n\n<p><em>Mary Job</em>: Thank you, Dave.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Sun, 12 Jun 2022 08:57:38 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:19:\"Gutenberg Changelog\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:27;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:98:\"Gutenberg Times: Block First Approach, Gutenberg 13.4, Page vs Site Editor – Weekend Edition 218\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:35:\"https://gutenbergtimes.com/?p=21309\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:103:\"https://gutenbergtimes.com/block-first-approach-gutenberg-13-4-page-vs-site-editor-weekend-edition-218/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:14894:\"<p>Howdy, howdy, </p>\n\n\n\n<p>Hopefully, with this edition, I am back curating the Weekend Edition for Saturdays&#8230; </p>\n\n\n\n<p>At WordCamp Europe, I connected with many members of the German WordPress community and I joined the German WordPress Slack space to learn more about the efforts to organize a WordCamp Deutschland. After meeting sooo many Community Deputies and friends in the WordPress community, it seems I got my motivation back as community organizer. </p>\n\n\n\n<p>As mentioned earlier this week, we also have a new <strong>Gutenberg Times Live Q &amp; A</strong> on our schedule and <a href=\"https://us02web.zoom.us/webinar/register/7216548519021/WN_Af50AS7VQbuyCrUdQnormw\">registration is open now.</a> In &#8220;<strong>Block First Approach at the Pew Research Center</strong>, we will discuss with Seth Rubinstein, Lead Developer, and Michael Piccorossi, Director of Digital Strategy, how they use a mixture of Core and Custom Blocks to streamline their publishing process, and to create powerful charts and quizzes for the Pew Research Center. <a href=\"https://us02web.zoom.us/webinar/register/7216548519021/WN_Af50AS7VQbuyCrUdQnormw\">Join us!</a> </p>\n\n\n\n<p>I am already looking forward to my next WordCamp: <a href=\"https://us.wordcamp.org/2022/\">WordCamp US in September</a> in San Diego. The team is getting ready to update the website and soon will announce the first round of speakers. </p>\n\n\n\n\n\n<p>Have a great weekend, <br />Yours, 💕<br />Birgit</p>\n\n\n\n\n<div class=\"wp-container-3 wp-block-group has-light-background-background-color has-background\"><div class=\"wp-block-group__inner-container\">\n<p><strong>Table of Contents</strong></p>\n\n\n\n<div class=\"wp-block-sortabrilliant-guidepost\"><ul><li><a href=\"https://gutenbergtimes.com/feed/#0-gutenberg-13-4\">Gutenberg 13.4</a></li><li><a href=\"https://gutenbergtimes.com/feed/#1-g\">General  News</a></li><li><a href=\"https://gutenbergtimes.com/feed/#2-t\">Block Theme building with code</a></li><li><a href=\"https://gutenbergtimes.com/feed/#3-s\">NoCode Site building</a></li><li><a href=\"https://gutenbergtimes.com/feed/#5-word-press-social-learning-events\">WordPress Social Learning Events</a></li></ul></div>\n</div></div>\n\n\n\n\n<h2 id=\"0-gutenberg-13-4\">Gutenberg 13.4</h2>\n\n\n\n<p>Héctor Prieto lead this week&#8217;s Gutenberg plugin release and published <a href=\"https://make.wordpress.org/core/2022/06/10/whats-new-in-gutenberg-13-4-8-june/\">What’s new in Gutenberg 13.4? (8 June)</a>. The highlights: </p>\n\n\n\n<ul><li><a href=\"https://make.wordpress.org/core/2022/06/10/whats-new-in-gutenberg-13-4-8-june/#support-for-button-elements-in-theme-json\">Support for button elements in theme.json</a></li><li><a href=\"https://make.wordpress.org/core/2022/06/10/whats-new-in-gutenberg-13-4-8-june/#axial-spacing-in-gallery-block\">Axial spacing in Gallery Block</a></li><li><a href=\"https://make.wordpress.org/core/2022/06/10/whats-new-in-gutenberg-13-4-8-june/#sidebar-design-updates\">Sidebar design updates</a></li><li><a href=\"https://make.wordpress.org/core/2022/06/10/whats-new-in-gutenberg-13-4-8-june/#search-block-variations-now-support-query-vars\">Search Block variations now support query vars</a></li><li><a href=\"https://make.wordpress.org/core/2022/06/10/whats-new-in-gutenberg-13-4-8-june/#performance-improvements\">Performance Improvements</a></li></ul>\n\n\n\n<p>On the Changelog, Mary and I, had a great conversation with <a href=\"https://gutenbergtimes.com/podcast/gutenberg-changelog-68-wordcamp-europe-gutenberg-13-4-and-wordpress-6-1/\">Dave Smith around Gutenberg 13.4, WordPress 6.1 and WordCamp Europe.</a></p>\n\n\n\n<a href=\"https://gutenbergtimes.com/podcast/gutenberg-changelog-68-wordcamp-europe-gutenberg-13-4-and-wordpress-6-1/\"><img /></a>\n\n\n\n<div class=\"wp-container-4 wp-block-group has-light-background-background-color has-background\"><div class=\"wp-block-group__inner-container\">\n<p><strong>🎙️ </strong> New episode: <a href=\"https://gutenbergtimes.com/podcast/gutenberg-changelog-68-wordcamp-europe-gutenberg-13-4-and-wordpress-6-1/\">Gutenberg Changelog #68 –  WordCamp Europe, Gutenberg 13.4 and WordPress 6.1</a> with Birgit Pauli-Haack and Mary Job, and special guest: Dave Smith </p>\n</div></div>\n\n\n\n\n<p><strong>&nbsp;<a href=\"https://make.wordpress.org/core/handbook/references/keeping-up-with-gutenberg-index/\" target=\"_blank\" rel=\"noreferrer noopener\">&#8220;Keeping up with Gutenberg &#8211; Index 2022&#8221;</a>&nbsp;</strong><br />A chronological list of the WordPress Make Blog posts from various teams involved in Gutenberg development: Design, Theme Review Team, Core Editor, Core JS, Core CSS, Test and Meta team from Jan. 2021 on. Updated by yours truly.  <a href=\"https://make.wordpress.org/core/handbook/references/keeping-up-with-gutenberg-index/keeping-up-with-gutenberg-index-2020/\"><em>The index 2020 is here</em></a></p>\n\n\n\n\n<h2 id=\"1-g\">General  News</h2>\n\n\n\n<p><strong>David Bisset</strong> list in his Post Status post the <a href=\"https://poststatus.com/9-things-i-learned-from-wordcamp-europe-2022/\"><strong>9 Things I Learned from WordCamp Europe 2022</strong></a>, mostly reporting from the Townhall Q &amp; A with Matt Mullenweg and Josepha Haden Chomphosy, but also from talks by Pablo Postigo on the future of frontend development in WordPress and by Feliz Arndt on WordPress performance, among others. </p>\n\n\n\n<hr class=\"wp-block-separator has-alpha-channel-opacity is-style-wide\" />\n\n\n\n<p>After the release of WordPress 6.0, <a href=\"https://twitter.com/martinibuster\"><strong>Roger Montti </strong></a>curated voices from the Advanced WordPress Group on Facebook and on Reddit for the Search Engine Journal. In his article <a href=\"https://www.searchenginejournal.com/wordpress-community-reacts-to-6-0-arturo/453174/#close\"><strong>WordPress Community Reacts To 6.0 Arturo</strong></a> he quotes a variety of WordPress users from both communities. </p>\n\n\n\n<hr class=\"wp-block-separator has-alpha-channel-opacity is-style-wide\" />\n\n\n\n<p><strong>Matias Ventura</strong>, couldn&#8217;t make it to the Keynote session, Matias couldn’t make it to WordCamp Europe&#8217;s Saturday’s keynote. He had prepared some cool things for it and he<a href=\"https://twitter.com/matias_ventura/status/1534602705456480260\"> tweeted about the earlier this week</a>. Some of it he also listed in the <a href=\"https://make.wordpress.org/core/2022/06/04/roadmap-to-6-1/\">Roadmap for 6.1 of the Gutenberg Plugin Phase 2 </a> post. </p>\n\n\n\n<hr class=\"wp-block-separator has-alpha-channel-opacity is-style-wide\" />\n\n\n\n<p><strong>Sarah Gooding</strong> in her post <a href=\"https://wptavern.com/gutenberg-editor-now-in-testing-on-tumblr-and-day-one-web-apps\">Gutenberg Editor Now In Testing On Tumblr and Day One Web Apps</a> picked up on Ventura&#8217;s tweet that the Gutenberg editor is now also used outside the WordPress context. Tumblr, the microblogging site <a href=\"https://www.theverge.com/2019/8/14/20804894/tumblr-acquisition-matt-mullenweg-ceo-automattic-wordpress-verizon-changes-vergecast\">Automattic rescued from Verizon&#8217;s chopping block in 2019</a>, offers it to its users as the new shiny post editor in a Beta version. The developer team at <a href=\"https://techcrunch.com/2021/06/14/wordpress-com-owner-automattic-acquires-journaling-app-day-one/\">Day One, an Automattic aquisition from last year,</a> is also experimenting offering Gutenberg editor to the journaling app users. </p>\n\n\n\n<img />\n\n\n\n<p>From Gooding&#8217;s post, I also learned that the company working on an overall Block Protocol, Hash is looking for a developer to buil a WordPress plugin for the Block Protocol. She wrote: &#8220;When the Block Protocol project was announced, it didn’t seem likely that it would use Gutenberg as the basis for its spec. However, the wide usage of Gutenberg across the web cannot be ignored. This forthcoming plugin appears to be more like a bridge or connector that ensures Gutenberg is still relevant in the Block Protocol ecosystem.&#8221; There might be big things a foot. </p>\n\n\n\n<hr class=\"wp-block-separator has-alpha-channel-opacity is-style-wide\" />\n\n\n\n<h2 id=\"2-t\">Block Theme building with code</h2>\n\n\n\n<p>If you wanted to get started with Block Patterns, <strong>Ganesh Dahal</strong> wrote a Tutorial on CSS-Tricks for you: <a href=\"https://css-tricks.com/how-to-create-block-theme-patterns-in-wordpress-6-0/\">How to Create Block Theme Patterns in WordPress&nbsp;6.0</a>. Dahal takes you through the code examples from the WordPress default theme, Twenty-Twenty-Two, that came out with the WordPress 5.9 release earlier this year. You learn how to register patterns and pattern cateogries and how to best organize your theme folders. </p>\n\n\n\n<p>In the second part of the post, you learn how to offer patterns without the registration steps with features introduced with WordPress 6.0, the autodetect mechanism from a patterns folder in your theme, or refering to the slug of a pattern from the WordPress Pattern Directory. Dahal also covers the newest feature to add context to the pattern and offer Page Patterns during the page creation process to a user. </p>\n\n\n\n<p>Ganash Dahal also wrote the following tutorials on CSS-Tricks: </p>\n\n\n\n<ul><li><a href=\"https://css-tricks.com/creating-style-variations-in-wordpress-block-themes/\">How to Create Style Variations in WordPress 6.0 Block&nbsp;Themes</a></li><li><a href=\"https://css-tricks.com/a-deep-introduction-to-wordpress-block-themes/\">A Deep Introduction to WordPress Block&nbsp;Themes</a></li></ul>\n\n\n\n<hr class=\"wp-block-separator has-alpha-channel-opacity is-style-wide\" />\n\n\n\n<p><a href=\"https://twitter.com/jeffikus\"><strong>Jeffrey Pearce</strong></a>, reminisced about  his WordPress journey in <a href=\"https://jeffikus.com/blog/2022/06/11/fifteen-years-of-wordpress-themes/\">Fifteen Years of Building WordPress Themes</a>. He now leads Automattic&#8217;s Theme development team. </p>\n\n\n\n<hr class=\"wp-block-separator has-alpha-channel-opacity is-style-wide\" />\n\n\n\n<p><strong>Anne McCarthy</strong> wrote a recap on the <a href=\"https://make.wordpress.org/test/2022/06/02/hallway-hangout-discussion-on-full-site-editing-issues-prs-designs-1-june/\">Hallway Hangout: Discussion on Full Site Editing Issues/PRs/Designs (1 June)</a> a discussion among Theme builders on what’s missing and what’s stopping people from switching to&nbsp;block&nbsp;themes. Participants also talked about the progress of implementing fluid typography for themes. </p>\n\n\n\n<p></p>\n\n\n\n\n<p><strong><a href=\"https://gutenbergtimes.com/need-a-zip-from-master/\">Need a plugin .zip from Gutenberg&#8217;s master branch?</a></strong><br />Gutenberg Times provides daily build for testing and review. <br />Have you been using it? Hit reply and let me know.</p>\n\n\n\n<p><img alt=\"GitHub all releases\" src=\"https://img.shields.io/github/downloads/bph/gutenberg/total?style=for-the-badge\" /></p>\n\n\n\n\n<h2 id=\"3-s\">NoCode Site building</h2>\n\n\n\n<p>On learn.WordPress.org <strong>Sarah Snow</strong> recently published a video on <a href=\"https://learn.wordpress.org/workshop/creating-a-front-page-for-a-block-theme/\"><strong>Creating a Front Page for a Block Theme</strong></a>. Her short tutorial walks you through the process to set a page as the front page of your site, instead of the latest posts, and then design the particular page with the Site Editor. </p>\n\n\n\n<p>You might also be interested in the upcoming WordPress Social Learning event with Wes Theron, who invites you to <a href=\"https://www.meetup.com/wordpress-social-learning/events/286028824/\"><strong>Let&#8217;s build a homepage together</strong></a>. </p>\n\n\n\n<hr class=\"wp-block-separator has-alpha-channel-opacity is-style-wide\" />\n\n\n\n<p>If you are just getting the hang of working with the block theme, you might also be interested in another Workshop on Learn.WordPress.org: <a href=\"https://learn.wordpress.org/workshop/understanding-the-page-editor-vs-site-editor/\"><strong>Understanding the Page Editor vs. Site Editor</strong></a> with <strong><a href=\"https://twitter.com/GeorginaReeder\">Georgina Reeder</a></strong>. It takes your understanding from editing a single page on your site to editing a template that is applied to all pages of your site and figure out what stay&#8217;s the same and what is different. Knowing the difference between the page editor and the Site editor, takes you page creatioin process to the next level and you get the tools to act upon your site in a more strategic mind set. </p>\n\n\n\n<p><strong>Munir Kamal</strong> published a new tutorial on YouTube: <a href=\"https://www.youtube.com/watch?v=Eu9qgEqABu4\"><strong>Responsive Product Card Hover Effect in WordPress Gutenberg.</strong></a> The purpose teach you how to create the creative content design in Gutenberg using default blocks without a 3rd party block plugin.</p>\n\n\n\n<hr class=\"wp-block-separator has-alpha-channel-opacity is-style-wide\" />\n\n\n\n<h2 id=\"5-word-press-social-learning-events\">WordPress Social Learning Events</h2>\n\n\n\n<p>The training team scheduled new Social Learning Events covering the Block editor. </p>\n\n\n\n<p><strong>June 14, 2022 2 pm EDT / 18:00 UTC<br /><a href=\"https://www.meetup.com/wordpress-social-learning/events/286256957/\">Builder Basics: Let’s Build a Custom Theme (No Coding Required)</a></strong> w/ Nick Diego </p>\n\n\n\n<p><strong>June 16, 2022 &#8211; 3 pm EDT / 19:00 UTC </strong><br /><strong><a href=\"https://www.meetup.com/wordpress-social-learning/events/286028824/\">Let&#8217;s build a homepage together</a></strong> w/ Wes Theron. </p>\n\n\n\n<p><a href=\"https://wordpress.org/openverse/image/2317505c-075f-4d45-bd43-891eba815b63\"><em>Features image: Ian Shane &#8211; City Blocks, found via Openverse</em></a></p>\n\n\n\n<hr class=\"wp-block-separator has-css-opacity is-style-wide\" />\n\n\n\n<p class=\"has-text-align-left\"><strong>Don&#8217;t want to miss the next Weekend Edition? </strong></p>\n\n\n\n<form class=\"wp-block-newsletterglue-form ngl-form ngl-portrait\" action=\"https://gutenbergtimes.com/feed/\" method=\"post\"><div class=\"ngl-form-container\"><div class=\"ngl-form-field\"><label class=\"ngl-form-label\" for=\"ngl_email\"><br />Type in your Email address to subscribe.</label><div class=\"ngl-form-input\"><input type=\"email\" class=\"ngl-form-input-text\" name=\"ngl_email\" id=\"ngl_email\" /></div></div><button type=\"submit\" class=\"ngl-form-button\">Subscribe</button><p class=\"ngl-form-text\">We hate spam, too and won&#8217;t give your email address to anyone except Mailchimp to send out our Weekend Edition</p></div><div class=\"ngl-message-overlay\"><div class=\"ngl-message-svg-wrap\"></div><div class=\"ngl-message-overlay-text\">Thanks for subscribing.</div></div><input type=\"hidden\" name=\"ngl_list_id\" id=\"ngl_list_id\" value=\"26f81bd8ae\" /><input type=\"hidden\" name=\"ngl_double_optin\" id=\"ngl_double_optin\" value=\"yes\" /></form>\n\n\n\n<hr class=\"wp-block-separator has-css-opacity is-style-wide\" />\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Sat, 11 Jun 2022 13:00:15 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:18:\"Birgit Pauli-Haack\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:28;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:45:\"WPTavern: Athens to Host WordCamp Europe 2023\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:30:\"https://wptavern.com/?p=135284\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:56:\"https://wptavern.com/athens-to-host-wordcamp-europe-2023\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:3195:\"<img />photo credit: <a href=\"https://commons.wikimedia.org/wiki/File:City_of_Athens,_Greece_%2826488103637%29.jpg\">Wikimedia Commons</a>\n\n\n\n<p><a href=\"https://europe.wordcamp.org/2022/\">WordCamp Europe 2022</a> concluded last weekend in Porto, Portugal. The event sold 2,746 tickets and had 2,304 people attend. It kicked off with a record-setting Contributor Day that coordinated the efforts of 800 participants giving back to WordPress and its related projects.</p>\n\n\n\n<div class=\"wp-block-embed__wrapper\">\n<blockquote class=\"instagram-media\"><div> <a href=\"https://www.instagram.com/p/CeWBFKCO6ZZ/?utm_source=ig_embed&utm_campaign=loading\" target=\"_blank\"> <div> <div></div> <div> <div></div> <div></div></div></div><div></div> <div></div><div> <div>View this post on Instagram</div></div><div></div> <div><div> <div></div> <div></div> <div></div></div><div> <div></div> <div></div></div><div> <div></div> <div></div> <div></div></div></div> <div> <div></div> <div></div></div></a><p><a href=\"https://www.instagram.com/p/CeWBFKCO6ZZ/?utm_source=ig_embed&utm_campaign=loading\" target=\"_blank\">A post shared by WP Tavern (@wptav)</a></p></div></blockquote>\n</div>\n\n\n\n<p>WCEU featured 70 speakers across 26 sessions and 18 workshops, made possible by the efforts of 65 sponsors, 91 organizers, and 164 volunteers.</p>\n\n\n\n<p>Attendees and organizers were thrilled to be back together in person after two years of not hosting the event due to the COVID-19 pandemic.  Remkus de Vries, one of the founders of WCEU, joined our recent <a href=\"https://wptavern.com/podcast/29-remkus-de-vries-on-how-wordcamp-europe-got-started\">WP Jukebox podcast</a> and commented on the importance of being back in person with fellow WordPress enthusiasts. He characterized WordCamps as the &#8220;glue&#8221; that keeps the community together.</p>\n\n\n\n<p>&#8220;I think the glue part is way more important than people thought that it was,&#8221; de Vries said. &#8220;I think you can say the same thing for what we’re seeing here. Yes, you can be connected. You can have great relationships online and everything, but the real deal is in real life. That’s where you make the actual connections. </p>\n\n\n\n<p>&#8220;You have things you say that you then in real life have time to correct if that wasn’t the intent that you actually had. All of these little things make up what that glue actually consists of, so not having that for two years creates a like a vacuum of things that are not seen, not communicated, not spoken about, not processed.</p>\n\n\n\n<p>&#8220;There have been companies started from WordCamps. There have been mergers started. There have been friends made there have been marriages come from WordCamps. Everything happens when you’re together.&#8221;</p>\n\n\n\n<p>In 2023, the project that is democratizing publishing will be hosting its European conference in the birthplace of democracy, Athens, Greece. The date is set for June 8-10, and the <a href=\"https://europe.wordcamp.org/2023/call-for-organisers/\">call for organizers</a> has already been published. Check out the intro video below for a taste of what&#8217;s to come next year.</p>\n\n\n\n<div class=\"wp-block-embed__wrapper\">\n\n</div>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Fri, 10 Jun 2022 21:32:16 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Sarah Gooding\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:29;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:72:\"WPTavern: Gutenberg Editor Now In Testing On Tumblr and Day One Web Apps\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:30:\"https://wptavern.com/?p=135231\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:83:\"https://wptavern.com/gutenberg-editor-now-in-testing-on-tumblr-and-day-one-web-apps\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:6400:\"<p>One of the most thought-provoking statements to come out of WordCamp Europe 2022, was when Matt Mullenweg said, &#8220;I believe that Gutenberg can be a bigger contribution to the world than WordPress itself.&#8221; </p>\n\n\n\n<p>This isn&#8217;t the first time Mullenweg has cast this vision of Gutenberg&#8217;s preeminence as an open source project. In the Q&amp;A following his <a href=\"https://wptavern.com/state-of-the-word-2021-wordpress-passes-43-market-share-looks-to-expand-the-commons-through-openverse\">2021 State of the Word</a> address, he said, &#8220;Gutenberg is something even bigger than WordPress, which is basically saying how do we edit and create the web? And how can we get as many people, both proprietary and open source collaborating on that as possible?&#8221; </p>\n\n\n\n<p>Making Gutenberg available to the broader web was part of the reasoning behind <a href=\"https://wptavern.com/proposal-and-steps-to-dual-license-gutenberg-under-the-gpl-and-mpl\">dual-licensing the project</a> under the GPL and MIT. Proprietary, and particularly mobile application use (where the GPL is not common), is better supported by the MIT license. </p>\n\n\n\n<p>Gutenberg is already finding a destiny of its own outside of WordPress. Projects like <a href=\"https://www.drupal.org/project/gutenberg\">Drupal Gutenberg</a> and <a href=\"https://wptavern.com/laraberg-a-gutenberg-implementation-for-laravel-is-now-in-beta\">Laraberg</a> were some the early seeds of the wider Gutenberg ecosystem, demonstrating that communities other than WordPress find value in the project and can adapt it for use with their applications. At WordCamp Europe, Mullenweg announced that both <a href=\"https://www.tumblr.com/\">Tumblr</a> and <a href=\"https://dayoneapp.com/\">Day One</a> are now testing Gutenberg in their web apps. </p>\n\n\n\n<div class=\"wp-block-embed__wrapper\">\n<blockquote class=\"twitter-tweet\"><p lang=\"en\" dir=\"ltr\">Day One web, currently in internal alpha, is following soon. We hope that these reference points help illustrate the flexibility of the block editor beyond WordPress. <a href=\"https://t.co/VLTwgfdi2v\">pic.twitter.com/VLTwgfdi2v</a></p>&mdash; Matías Ventura (@matias_ventura) <a href=\"https://twitter.com/matias_ventura/status/1534602884196753411?ref_src=twsrc%5Etfw\">June 8, 2022</a></blockquote>\n</div>\n\n\n\n<p>Tumblr users who want to access the <a href=\"https://help.tumblr.com/hc/en-us/articles/4965854988695-Updates-to-the-Beta-Post-Editor\">new beta post editor</a>, which was code named &#8220;Gutenblr,&#8221; can click on the prompt at the top of the page to  switch. It&#8217;s opt-in for now while it&#8217;s still being tested. </p>\n\n\n\n<img />\n\n\n\n<p>Activating the beta unlocks the new Gutenberg-powered editor with redesigned buttons and icons. Users can post a series of multiple blocks in what feels like a mini, pared-back post editor. Certain blocks can be dragged and dropped into a different order on the draft, but this is still a little buggy. Tumblr&#8217;s editor is fun to use compared to WordPress&#8217; version of Gutenberg which does a lot more but at the expense of having to support many more settings and controls. </p>\n\n\n\n<img />\n\n\n\n<p>When <a href=\"https://wptavern.com/automattic-acquires-tumblr-plans-to-rebuild-the-backend-powered-by-wordpress\">Automattic acquired Tumblr</a> in 2019,  Mullenweg was forthright about his intention to replace the Tumblr backend with WordPress.  </p>\n\n\n\n<p>“WordPress is an open source web operating system that can power pretty much anything, including Tumblr.com, but it’s also a large property so will take a bit to figure out and migrate,” Mullenweg said.</p>\n\n\n\n<p>Two years later, in November 2021, the Tumblr changelog <a href=\"https://changes.tumblr.com/post/668673552865804288/tuesday-november-23rd-2021\">noted</a> that the development team was working on a new major version of the beta post editor on web, leveraging parts of Gutenberg. In a Twitter <a href=\"https://twitter.com/matias_ventura/status/1530212971150028801\">conversation</a> discussing Tumblr&#8217;s architecture, Gutenberg lead architect Matías Ventura said its implementation of Gutenberg stores everything as JSON, whereas WordPress serializes HTML as the default experience because it needs to work with the ecosystem. In both cases, blocks are created as structured data.</p>\n\n\n\n<p>&#8220;I&#8217;m personally looking forward to when you could just copy and paste blocks between platforms like you do with patterns!&#8221; Matías Ventura said when tweeting out the screenshots of Gutenberg on Tumblr and Day One. </p>\n\n\n\n<p>This sort of interoperability across apps is similar to the idea behind the <a href=\"https://wptavern.com/block-protocol-project-aims-to-create-universal-block-system-may-collaborate-with-gutenberg\">Block Protocol</a> project. It aims to build a block system for embedding interactive blocks in any web application. As more of the web embraces the block paradigm, it would be helpful to be able to share blocks across a standardized protocol.  </p>\n\n\n\n<p>The Block Protocol spec is being developed by the team at <a href=\"https://hash.ai/blog/announcing-the-block-protocol\">HASH</a>, which is currently <a href=\"https://hash.ai/careers/wordpress-plugin-developer\">hiring a WordPress developer</a> to create a Block Protocol Gutenberg plugin. The goal of the plugin is to &#8220;unlock the entire Block Protocol ecosystem of blocks for all users of WordPress (both technical and not),&#8221; which would extend the range of blocks available to Gutenberg users. </p>\n\n\n\n<p>When the Block Protocol project was announced, it didn&#8217;t seem likely that it would use Gutenberg as the basis for its spec. However, the wide usage of Gutenberg across the web cannot be ignored. This forthcoming plugin appears to be more like a bridge or connector that ensures Gutenberg is still relevant in the Block Protocol ecosystem. </p>\n\n\n\n<p>WordPress is an important player in the creation of both blocks and an intuitive editor for publishing them, as the primary incubator for Gutenberg&#8217;s initial development and essentially its first adopter. The block editor making its way to more apps like Tumblr and Day One is a major milestone, and it&#8217;s inspiring to see collaboration on an initiative connecting Gutenberg users with another global registry of blocks designed to move across apps on the web.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Fri, 10 Jun 2022 19:40:35 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Sarah Gooding\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:30;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:139:\"WPTavern: WordPress 6.1 to Focus On Refining Full-Site Editing, Next Phase Collaboration and Multilingual Features Anticipated in 2023-2025\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:30:\"https://wptavern.com/?p=135186\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:149:\"https://wptavern.com/wordpress-6-1-to-focus-on-refining-full-site-editing-next-phase-collaboration-and-multilingual-features-anticipated-in-2023-2025\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:7918:\"<p>Gutenberg lead architect Matías Ventura has identified refinements to experiences introduced in 5.9 and 6.0 as the main goal for the upcoming 6.1 release. He published the  <a href=\"https://make.wordpress.org/core/2022/06/04/roadmap-to-6-1/\">roadmap for 6.1</a> ahead of the closing session at WordCamp Europe in Porto, where he was scheduled to join Matt Mullenweg and Josepha Haden Chomphosy for a demo. Ventura wasn&#8217;t able to make it but he tweeted a <a href=\"https://twitter.com/matias_ventura/status/1534602705456480260?t=C2rmnIxHX8gaYkWk8TKkZA&s=09\">thread</a> with video demos of some exciting interface updates that Gutenberg contributors are working on.</p>\n\n\n\n<p>One of the main thrusts is making site navigation a smoother experience through a new &#8220;browse mode&#8221; that will allow site editors to zoom in and out while working. </p>\n\n\n\n<p>Patterns are another major focus that Ventura has identified as &#8220;a central piece of the creative experience.&#8221; Contributors are working on making it easier to <a href=\"https://github.com/WordPress/gutenberg/issues/38529\">build with patterns</a>, with plans to improve the discovery and insertion process. WordPress 6.1 will bring better support for pattern usage in <a href=\"https://github.com/WordPress/gutenberg/issues/41398\">custom post types</a>, block types, and a more intuitive experience locking patterns and managing saved patterns.</p>\n\n\n\n<img />image credit: <a href=\"https://make.wordpress.org/core/2022/06/04/roadmap-to-6-1/\">WordPress 6.1 Roadmap</a>\n\n\n\n<p>Contributors are also exploring a <a href=\"https://github.com/WordPress/gutenberg/issues/39281\">new aerial view and other ideas</a> for making it easier to interact with patterns as sections of a page, as Ventura demonstrated in his thread.</p>\n\n\n\n<div class=\"wp-block-embed__wrapper\">\n<blockquote class=\"twitter-tweet\"><p lang=\"en\" dir=\"ltr\">Patterns were a big focus at the conference in Porto and with 6.1 we\'ll be trying ti elevate them further. A new aerial view is being explored to allow focusing on the top level sections of a page or template. <a href=\"https://t.co/7JSeQQANt7\">pic.twitter.com/7JSeQQANt7</a></p>&mdash; Matías Ventura (@matias_ventura) <a href=\"https://twitter.com/matias_ventura/status/1534602854446637056?ref_src=twsrc%5Etfw\">June 8, 2022</a></blockquote>\n</div>\n\n\n\n<p>Ventura said another goal for WordPress 6.1 is to improve the global styles interface with better support for restrictions, privileges, and curated presets. Design tools will also be updated to support responsive typography and allow managing webfonts.</p>\n\n\n\n<p>&#8220;The tune of the release will be to refine the experiences introduced in 5.9 and 6.0, weave the various flows into more coherent and fulfilling experiences for users, maintainers, and extenders, and close some gaps in functionality as we start to look towards Phase 3 of the Gutenberg roadmap,&#8221; Ventura said.</p>\n\n\n\n<h3>Beyond WordPress 6.1: Collaboration Phase 3 Will Precede Multilingual Phase 4 to Establish Core Architecture</h3>\n\n\n\n<p>Matt Mullenweg and Josepha Haden Chomphosy addressed several questions regarding WordPress&#8217; long term roadmap during their Q&amp;A session at WordCamp Europe. (The video from the livestream is embedded below.)</p>\n\n\n\n<div class=\"wp-block-embed__wrapper\">\n\n</div>\n\n\n\n<p>WordPress core contributors plan to close out the Customization phase before beginning on the Collaboration phase in 2023. During the Q&amp;A session, one of the polyglot contributors asked why WordPress is waiting until Phase 4 to begin working on multilingual features in core. </p>\n\n\n\n<p>&#8220;Part of the reason we don&#8217;t want to set data now and then work on the feature later is that we have learned every time that it&#8217;s hard to create the architecture for something without creating the user experience,&#8221; Mullwenweg said. &#8220;When we try to do one without the other, for example with the REST API we got into the REST API before we were fully using it ourselves. As we started to do first-party usage of the REST API with Gutenberg, we found a bunch of gaps. I would feel particularly bad if those gaps meant plugins had been building on the wrong architecture for a few years.&#8221;</p>\n\n\n\n<p>Mullenweg also explained why he believes it&#8217;s important to prioritize Phase 3, which he referred to as &#8220;workflow,&#8221; before the multilingual features:</p>\n\n\n\n<blockquote class=\"wp-block-quote\"><p>Phase 3 is Workflow. This is basically where we&#8217;re going to take real-time co-editing into WordPress, much like Google docs or something else. When you log in to edit a page or your sites or a template or something, if someone else is in there at the same time, you&#8217;ll be able to see them moving around. Of course, we want to make sure we have version control built in like we do for posts and pages, into as many parts of WP as possible, so if someone makes a mistake or an edit to the site, you will be able to roll it back easily, which I think is really key for giving people confidence.</p></blockquote>\n\n\n\n<p>He emphasized the importance of establishing the collaboration architecture before introducing multilingual support into core.</p>\n\n\n\n<p>&#8220;I think that the workflows around multilingual are important,&#8221; Mullenweg said. &#8220;So where is the content being canonically created, how do changes flow from one language to another, maybe even bi-directionally, depending on the people editing the site, and how that affects the rest of the templates &#8211; things that are outside the post and page content.&#8221;</p>\n\n\n\n<p>He also noted the many third-party multilingual solutions that already exist will have a transition period as core integrates these features.</p>\n\n\n\n<p>&#8220;I expect that much like has happened with page builders, once there&#8217;s something in core, they will either have a data migration path or integrate with whatever foundation we put into core,&#8221; Mullenweg said. &#8220;But I would like to set expectations that it&#8217;s probably more of a 2024 or 2025 initiative for WordPress. And we want to get these other phases done really well first. Why do we have to go in order? We can only do so much at once.&#8221;</p>\n\n\n\n<p>When the person who had asked the question pressed for a reason why a contingency work group could not begin now, Mullenweg encouraged any eager contributors to put their work into a plugin. He referenced Gutenberg, which began as a plugin and was tested for years before bringing it into core. </p>\n\n\n\n<blockquote class=\"wp-block-quote\"><p>I would say when we look at phase 4, the first thing we&#8217;re going to look at is how all the plugins are doing it. Perhaps one of those plugins could even become the basis for what comes into core. It&#8217;s OK if the plugins take different architectural approaches, because we want to see pluses and minuses of those. Remember people use WordPress with millions and millions of posts and pages, sometimes tens of millions. We want this to scale, we want this to be performant, we want it to be accessible. Take all the things people know and trust about WordPress. and bring it to this functionality.</p></blockquote>\n\n\n\n<p>Mullenweg said he thinks multilingual is &#8220;probably going to be one of the most complex things we bring into core, even more so than blocks.&#8221; The reason behind this is because blocks took what WordPress did before and gave it a new interface on top of HTML.</p>\n\n\n\n<p>&#8220;Multilingual is taking every single thing inside of WordPress &#8211; tags, categories, pages, templates, and making it multi-factorial so it&#8217;s like a factorial amount of complexity on top of what right now is more of a one-to-one relationship,&#8221; he said. &#8220;If you have some ideas for how to do it, get involved with one of the existing plugins or start your own.&#8221;</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 09 Jun 2022 20:14:30 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Sarah Gooding\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:31;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:104:\"Do The Woo Community: Extending Your WordPress Plugin for WooCommerce with Mark Westguard and Lesley Sim\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:28:\"https://dothewoo.io/?p=71684\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:50:\"https://dothewoo.io/extending-plugins-woocommerce/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:443:\"<p>Lesley wants to add WooCommerce functionality to her WordPress plugin. Mark has done it. A unique conversation between two developers.</p>\n<p>&gt;&gt; The post <a rel=\"nofollow\" href=\"https://dothewoo.io/extending-plugins-woocommerce/\">Extending Your WordPress Plugin for WooCommerce with Mark Westguard and Lesley Sim</a> appeared first on <a rel=\"nofollow\" href=\"https://dothewoo.io\">Do the Woo - a WooCommerce Builder Community</a>	.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 09 Jun 2022 09:20:00 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:5:\"BobWP\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:32;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:54:\"Post Status: This Week at WordPress.org (June 6, 2022)\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"https://poststatus.com/?p=98964\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:62:\"https://poststatus.com/this-week-at-wordpress-org-june-6-2022/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:319:\"Each week we are highlighting the news from WordPress.org that you don\'t want to miss. If you or your company create products or services that use WordPress, we\'ve got the news you need to know. Be sure to share this resource with your product and project managers. Are you interested in giving back and contributing...\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Wed, 08 Jun 2022 23:00:14 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:18:\"Courtney Robertson\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:33;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:37:\"WPTavern: Elementor Acquires Strattic\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:30:\"https://wptavern.com/?p=135146\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:48:\"https://wptavern.com/elementor-acquires-strattic\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:4715:\"<p><a href=\"https://elementor.com/blog/elementor-acquires-strattic/\">Elementor</a>, a popular website builder <a href=\"https://wordpress.org/plugins/elementor/\">plugin</a> that is active on more than five million websites, has acquired <a href=\"https://www.strattic.com/strattic-acquired-by-elementor/\">Strattic</a>, a static and headless WordPress hosting company.  Strattic will continue operating as &#8220;Strattic by Elementor&#8221; and the team will remain as its own unit within the company.</p>\n\n\n\n<p>Elementor founders Yoni Luksenberg and Ariel Klikstein met Strattic founder and CEO Miriam Schwab 10 years ago when they attended a WordCamp she organized in Jerusalem. The following year Elementor sponsored the WordCamp she organized the in Tel Aviv.  In 2020, <a href=\"https://wptavern.com/elementor-raises-15-million-plans-to-invest-in-the-team-product-and-community\">Elementor raised $15M</a> its first round of funding, led by Lightspeed Venture Partners, after passing four million users.</p>\n\n\n\n<p>Schwab founded Strattic in 2018 as the first WordPress hosting company to streamline the creation of static files managed via a headless install. </p>\n\n\n\n<p>&#8220;Very early on it became clear to us at Strattic that we had better make sure we support Elementor in the static versions of our sites,&#8221; Schwab said. &#8220;More and more users were coming to us with sites built on Elementor, which was a strong indication of the plugin’s growing adoption and popularity. We prioritized supporting it in general, including rolling out support for their forms, and most recently adding a Strattic publish button from the Elementor editor.&#8221;</p>\n\n\n\n<p>Over the past year, Elementor has been working to capture the market for the entire website creation process by offering hosting alongside its commercial website builder. Earlier this year, the company launched a Google Cloud-based website hosting service that includes Elementor Pro for $99/year. Elementor will promote the new static hosting service alongside its existing cloud service.</p>\n\n\n\n<p>&#8220;I can&#8217;t speak exactly to what Elementor&#8217;s strategy is in terms of Strattic vis a vis their cloud offering, but Strattic will be a parallel offering, at least for the foreseeable future,&#8221; Schwab said.</p>\n\n\n\n<p>Elementor has often been <a href=\"https://wptavern.com/gutenbergs-faster-performance-is-eroding-page-builders-dominance\">criticized for making WordPress sites sluggish</a> so it&#8217;s easy to see the appeal that static hosting brings. Having more customers on Strattic might lessen the urgency of fixing Elementor&#8217;s well-documented speed issues. </p>\n\n\n\n<p>&#8220;This acquisition will allow us to leverage Strattic’s technology to build static websites, helping to solve stability, speed, and security issues in the dynamic sites space,&#8221; Elementor founder Yoni Luksenberg said.</p>\n\n\n\n<p>&#8220;With static hosting, users can deploy their dynamic WordPress websites as static HTML/CSS replicas to global CDN networks, which drastically improves the performance of their sites and eliminates potential security vulnerabilities and site breakdowns during updates. With a dramatically reduced attack surface, WordPress vulnerabilities become irrelevant as security is no longer a defensive endeavor.&#8221;</p>\n\n\n\n<p>Elementor users who sign on for Strattic&#8217;s static hosting approach will have a more stable and secure experience, as the plugin and related third-party add-ons are <a href=\"https://wptavern.com/elementor-3-6-3-patches-critical-remote-code-execution-vulnerability\">frequently</a> <a href=\"https://wptavern.com/elementor-patches-xss-vulnerabilities-affecting-7-million-wordpress-sites\">patching</a> <a href=\"https://wptavern.com/essential-addons-for-elementor-patches-critical-security-vulnerability\">critical</a> <a href=\"https://wptavern.com/attackers-continue-to-exploit-vulnerabilities-in-the-plus-addons-for-elementor-plugin\">vulnerabilities</a>. </p>\n\n\n\n<p>Strattic and Elementor customers can expect deeper integration across these products in the future.</p>\n\n\n\n<p>&#8220;We already have great support for Elementor on our static sites, but of course there&#8217;s always room for improvement so we will be working with Elementor&#8217;s team to make the integration even better,&#8221; Schwab said. She also confirmed there are no pricing changes on the horizon for Strattic customers.</p>\n\n\n\n<p>&#8220;Right now everything will stay pretty much the same for Strattic users. We hope they&#8217;ll soon start to feel the benefit of us joining Elementor in terms of faster release cycles of amazing new features that will make the product even better.&#8221;</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Wed, 08 Jun 2022 19:26:20 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Sarah Gooding\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:34;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:73:\"Do The Woo Community: WooCommerce Announces Functionality for Card Reader\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:28:\"https://dothewoo.io/?p=71917\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:72:\"https://dothewoo.io/woocommerce-announces-functionality-for-card-reader/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:419:\"<p>The press release, received today, announces the features that allow fast transactions and automatic inventory syncing.</p>\n<p>&gt;&gt; The post <a rel=\"nofollow\" href=\"https://dothewoo.io/woocommerce-announces-functionality-for-card-reader/\">WooCommerce Announces Functionality for Card Reader</a> appeared first on <a rel=\"nofollow\" href=\"https://dothewoo.io\">Do the Woo - a WooCommerce Builder Community</a>	.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Wed, 08 Jun 2022 15:25:43 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:5:\"BobWP\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:35;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:68:\"WPTavern: #29 – Remkus de Vries on How WordCamp Europe Got Started\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:48:\"https://wptavern.com/?post_type=podcast&p=135131\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:82:\"https://wptavern.com/podcast/29-remkus-de-vries-on-how-wordcamp-europe-got-started\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:34790:\"<p>On the podcast today we have <a href=\"https://remkus.devries.frl\">Remkus de Vries</a>.</p>\n\n\n\n<p>Remkus is kicking off what might be described as a&nbsp; mini series on the Jukebox podcast.</p>\n\n\n\n<p>Last week almost 3,000 WordPressers from all over the world gathered together in Porto, Portugal for the first in-person <a href=\"https://europe.wordcamp.org/2022/\">WordCamp Europe</a> since 2019.</p>\n\n\n\n<p>Expectations were high, and the event did not disappoint. It really was excellent.</p>\n\n\n\n<p>I went along with some recording equipment and tried to find a quiet spot. I sat down with some of the speakers, organisers and attendees to talk about all manner of subjects, and that’s what this mini series is all about.</p>\n\n\n\n<p>Over the next fews months, I’ll be releasing those conversations as Jukebox podcast episodes.</p>\n\n\n\n<p>Usually, when we record the podcast, there’s typically not a lot of background noise, but that’s not always the case with these interviews. We were competing against crowds and air-conditioning fans. Whilst the podcasts are certainly more than listenable, I hope that you understand that the vagaries of the real world were at play.</p>\n\n\n\n<p>Okay, so back to Remkus. Remkus is one of the founders of WordCamp Europe, just over 10 years ago. I wanted to get him on the podcast to talk about how the community&#8217;s largest WordCamp got started. I also wanted to find out how the current event compares in terms of size and organisation. What&#8217;s changed over the years?</p>\n\n\n\n<p>We talk about the importance of events like WordCamps for the community, and how over the last few years the lack of in-person events altered the community.</p>\n\n\n\n<p>Remkus is a colourful character and full of interesting insights, which are always worth listening to.</p>\n\n\n\nTranscript<div>\n<p>[00:00:00] <strong>Nathan Wrigley:</strong> Welcome to the Jukebox podcast from WP Tavern. My name is Nathan Wrigley. Jukebox is a podcast which is dedicated to all things WordPress. The people, the events, the plugins, the themes, the blocks, and in this case WordCamp Europe.</p>\n\n\n\n<p>If you&#8217;d like to subscribe to the podcast, you can do that by searching for WP Tavern in your podcast player of choice, or by going to WPTavern.com forward slash feed forward slash podcast. And you can copy that URL into most podcast players. If you have a topic that you&#8217;d like us to feature on the podcast, well I&#8217;m very keen to hear from you, and hopefully get you all your idea featured on the show. Head over to WPTavern.com forward slash contact forward slash jukebox, and use the contact form there.</p>\n\n\n\n<p>So on the podcast today we have Remkus de Vries. Remkus is kicking off what might be described as a mini series on the Jukebox podcast. Last week almost 3000 wordPressers from all over the world, gathered together in Porto, Portugal for the first in-person WordCamp Europe since 2019.</p>\n\n\n\n<p>Expectations were high. And the event did not disappoint. It was really excellent. I went along with some recording equipment and tried to find a quiet spot. I sat down with some of the speakers, organizers, and attendees. To talk about all manner of subjects. And that&#8217;s what this mini series is all about.</p>\n\n\n\n<p>Over the next few months, I&#8217;ll be releasing those conversations as Jukebox podcast episodes. Usually when we record the podcast, there&#8217;s typically not a lot of background noise. But that&#8217;s not always the case with these interviews. We were competing against crowds and air conditioning fans. And whilst the podcasts are more than listable. I hope that you understand that the vagaries of real life were at play.</p>\n\n\n\n<p>Okay, so back to Remkus. Remkus is one of the founders of WordCamp Europe, just over 10 years ago. I wanted to get him on the podcast to talk about how the community&#8217;s largest WordCamp got started. I also wanted to find out how the current event compares in terms of size and organization. What has changed over the years?</p>\n\n\n\n<p>We talk about the importance of events like WordCamps for the community and how over the last few years, the lack of in-person events has altered the community. Remkus is a colorful character and full of interesting insights, which are always worth listening to.</p>\n\n\n\n<p>If you&#8217;re interested in finding out more, you can find all the links in the show notes by heading over to WPTavern.com forward slash podcast. And you&#8217;ll find all the other episodes there as well. And so without further delay, I bring you, Remkus de Vries.</p>\n\n\n\n<p>I am joined on the podcast today by Remkus de Vries. Hello.</p>\n\n\n\n<p>[00:03:31] <strong>Remkus de Vries:</strong> Hello Hello.</p>\n\n\n\n<p>[00:03:32] <strong>Nathan Wrigley:</strong> Remkus Remkus and I go back, not a really long way, but we&#8217;re going to talk about a journey which takes him back a long way. Tell us about yourself, your relationship with WordPress. Ignore all the WordCamp Europe bits. If you cannot, otherwise, we&#8217;ll have nothing left to say.</p>\n\n\n\n<p>[00:03:44] <strong>Remkus de Vries:</strong> Ah, okay, okay. My relationship with WordPress. Wow, that is taking me a ways back. So I think the first time I, so I played with WordPress the first time for a couple of months before I did anything serious with it, but this is 2004. I had a bunch of clients at the time, which, we&#8217;re either on Mambo or Joomla, and the ones on Mambo, I was in the process of moving them over. Really didn&#8217;t like the process, but you do what you gotta do with the tools that you have. And at the end of 2005, if I remember correctly, WordPress introduced pages, which then made me switch every single client that I have, which was about 20. I ported their Joomla or Mambo theme over to WordPress because now we have static pages, and I haven&#8217;t looked back.</p>\n\n\n\n<p>[00:04:30] <strong>Nathan Wrigley:</strong> Been going strong ever since.</p>\n\n\n\n<p>[00:04:32] <strong>Remkus de Vries:</strong> Yeah. Yeah.</p>\n\n\n\n<p>[00:04:33] <strong>Nathan Wrigley:</strong> We&#8217;re here to talk about WordCamp Europe because, well we&#8217;re at WordCamp Europe. Let&#8217;s talk about this one just specifically how much you&#8217;ve enjoyed it. When did you arrive?</p>\n\n\n\n<p>[00:04:44] <strong>Remkus de Vries:</strong> Monday.</p>\n\n\n\n<p>[00:04:45] <strong>Nathan Wrigley:</strong> So that was one, no two days before the contributor day. On none of the podcasts that we&#8217;ve recorded before have we talked about Porto the place or anything like that? So let&#8217;s do a little bit of that. I think this location is pretty spectacular. How are you enjoying Porto?</p>\n\n\n\n<p>[00:04:59] <strong>Remkus de Vries:</strong> Porto is very nice. It&#8217;s a little bit like home in terms of the weather. And it&#8217;s a lot not like home because there is elevation. For us, it&#8217;s a 35 minute walk to get here and we&#8217;ve tried quite a few different routes getting here. And whatever you pick, you always end up walking uphill. Which I found interesting, but it highlights the things I like about Porto, because there is nooks and crannies and corners and things you constantly find. Sure there&#8217;s architecture, but if I&#8217;m really honest, I&#8217;ve seen so many European cities, that is roughly the same everywhere. Yeah, the play with the hills and the twisty roads and things like that. I really enjoy it. Plus we&#8217;re close to the sea, as someone who grew up around water, I like that.</p>\n\n\n\n<p>[00:05:42] <strong>Nathan Wrigley:</strong> Oh, it&#8217;s absolutely brilliant. I completely share your comment about the hills. So far, I&#8217;ve only walked up.</p>\n\n\n\n<p>[00:05:48] <strong>Remkus de Vries:</strong> So I&#8217;m here with my son and he keeps saying, uh, you&#8217;re getting old. And, and the last couple of days I take the Uber getting here and he&#8217;s said, I&#8217;m going to walk. I&#8217;m like, fine. I&#8217;m okay with that. I like the Uber now, cause I walked so much.</p>\n\n\n\n<p>[00:06:01] <strong>Nathan Wrigley:</strong> I&#8217;ve got to ask about your son. Is he into WordPress?</p>\n\n\n\n<p>[00:06:05] <strong>Remkus de Vries:</strong> Kinda, sort of. His number one passion, and that is in not just a capital P, but the whole word is in capitals is music. He is doing a Dutch version of Juilliard&#8217;s, if that rings a bell. So it&#8217;s a school that is essentially on the performance arts. I think the official name is the Academy of Pop Culture, and he does music. So that consumes his life. There have been periods where I have used him when we had client migrations. So he&#8217;s done content management mostly. So he understands WordPress. It just hasn&#8217;t built anything in it himself. So we drove up here, so it&#8217;s a father and son road trip, have fun together. and that sort of thing.</p>\n\n\n\n<p>[00:06:40] <strong>Nathan Wrigley:</strong> How long did it take to get here?</p>\n\n\n\n<p>[00:06:41] <strong>Remkus de Vries:</strong> We had a short break in a Bilbao. We spent the night there, so I think all in total 21 hours.</p>\n\n\n\n<p>[00:06:48] <strong>Nathan Wrigley:</strong> I didn&#8217;t know you brought your son. But he&#8217;s not here in the venue?</p>\n\n\n\n<p>[00:06:51] <strong>Remkus de Vries:</strong> He is.</p>\n\n\n\n<p>[00:06:52] <strong>Nathan Wrigley:</strong> So he&#8217;s taking part, he&#8217;s not just enjoying Porto?</p>\n\n\n\n<p>[00:06:54] <strong>Remkus de Vries:</strong> He likes to hang out with people I like to hang out with. So we were, we&#8217;re all good.</p>\n\n\n\n<p>[00:06:57] <strong>Nathan Wrigley:</strong> Ah, nice. And have you&#8217;ve been enjoying, again, we haven&#8217;t discussed this so far, a large proportion of the excitement about WordPress events, WordCamps in particular is the sort of stuff that goes on around the edges. You know, the hallway track. The after parties and all that. We haven&#8217;t had the after-party yet, but there&#8217;s been lots of social events organized in the evenings. Has that side been enriching and fun?</p>\n\n\n\n<p>[00:07:17] <strong>Remkus de Vries:</strong> Very much.</p>\n\n\n\n<p>[00:07:18] <strong>Nathan Wrigley:</strong> You enjoy that bit as much as anybody?</p>\n\n\n\n<p>[00:07:20] <strong>Remkus de Vries:</strong> Absolutely.</p>\n\n\n\n<p>[00:07:21] <strong>Nathan Wrigley:</strong> Because I think one of the key components for people who want to be at these events, but maybe don&#8217;t want to be at these events if you know what I mean? You&#8217;re nervous. It&#8217;s all going to be about code. I don&#8217;t write code.</p>\n\n\n\n<p>[00:07:31] <strong>Remkus de Vries:</strong> No.</p>\n\n\n\n<p>[00:07:33] <strong>Nathan Wrigley:</strong> There&#8217;s a load of social stuff going on.</p>\n\n\n\n<p>[00:07:34] <strong>Remkus de Vries:</strong> So, that whole chain of thought needs to stop anyway, because it is not about code. at one point I&#8217;ve I&#8217;ve been, quoted saying, I came for the software. I came home with family. So, if you keep that in mind, it means there&#8217;s a lot more going on than just this is the code we work with.</p>\n\n\n\n<p>It&#8217;s a CMS we work with and the CMS allows us to do things. And there are many other people that have the similar experience. Like it facilitates them, it empowers them. It&#8217;s not just the content creators themselves democratizing publishing. It&#8217;s not just that. There&#8217;s a whole ecosystem around of people being empowered to use a particular piece of software.</p>\n\n\n\n<p>And the fun thing about WordPress is, as it so happens that the large majority of people enjoying the software turn out also to like each other in real life. So the community part, and then the social component of that gets highlighted at WordCamps.</p>\n\n\n\n<p>[00:08:26] <strong>Nathan Wrigley:</strong> So is it true to say that you, I know that you just said it and it sounded like a trope, but hand on heart, you&#8217;ve got real life friends, in the strictest sense of the word that you never would have known.</p>\n\n\n\n<p>[00:08:37] <strong>Remkus de Vries:</strong> Absolutely.</p>\n\n\n\n<p>[00:08:38] <strong>Nathan Wrigley:</strong> Yeah. That&#8217;s really fascinating.</p>\n\n\n\n<p>[00:08:39] <strong>Remkus de Vries:</strong> Yeah, and not a few.</p>\n\n\n\n<p>[00:08:40] <strong>Nathan Wrigley:</strong> Yeah. You are quite gregarious, I think. You are very good at, being out there.</p>\n\n\n\n<p>[00:08:45] <strong>Remkus de Vries:</strong> I&#8217;m not necessarily an extrovert but, among friends, among like-minded it doesn&#8217;t cost me energy. So I&#8217;m, I&#8217;m a very comfortable semi introvert.</p>\n\n\n\n<p>[00:08:53] <strong>Nathan Wrigley:</strong> Yeah. Let&#8217;s talk to the people out there though who may be introverted. Who think, you know what? There&#8217;s no way I&#8217;m going to a WordPress event. There&#8217;s no way I&#8217;m going to a WordCamp, big one, like WordCamp Europe, or a smaller one that may be in a particular country. Just tell us a little bit about the stuff which is on hand to help them get through it. Cause I know there&#8217;s a lot of preparation and a lot of thought has been put in to make this as accessible as possible well, basically to quieten any nerves for anybody who may be just thinking, okay, this is not for me.</p>\n\n\n\n<p>[00:09:20] <strong>Remkus de Vries:</strong> So the only thing overwhelming that we cannot take away is the number of people, right? So if a small WordCamp for 200 people is a trigger for you, we can&#8217;t solve that. WordCamp Europe in the 2000 plus, is not going to solve that either, but what we can do is provide an open environment.</p>\n\n\n\n<p>Right? So what we do is we make sure that all the angles that we can cover, meaning if you&#8217;d like to sit aside in the corner, you can. There is space to do that, from within the rooms where the presentations are, to what you mentioned earlier, hallway tracks, right? There&#8217;s spaces, there&#8217;s hallways, there&#8217;s various places where you can hang out where you can sit where you can relax a bit, collect your thoughts if that&#8217;s needed, whatever.</p>\n\n\n\n<p>So, the other thing you will find is, like I mentioned earlier, there&#8217;s a lot of like-minded people. And if you are, I think suffering is too big of a word, but if you are in need of anything, you will be spotted and someone will come and, uh, ask are you okay? Is there something I can do to help? So, the whole environment we have is to facilitate the most diverse audience you can think of. That includes the accessibility type of stuff. We have captioning for the live talks. We take into account that if someone creates a presentation, color contrast is correct. So color blinds. You know, I&#8217;m just giving random examples of things that think of in order to facilitate everyone as much as possible.</p>\n\n\n\n<p>So if you&#8217;re an introvert, it&#8217;s going to cost you some energy, sure, but it&#8217;s also going to give you a lot. And at the very least it&#8217;s people you somewhat maybe already know from online interactions and stuff, especially Twitter is good at that. It&#8217;s going to help you cement that sort of relationship into a more, I&#8217;m sitting across from you now, uh, Nathan, and we&#8217;ve spoken quite a few times already, but this is the first time we&#8217;re properly sitting across each other. It&#8217;s different in real life than it is when you&#8217;re, through the digital world are connecting. So the advantage of that is tremendous.</p>\n\n\n\n<p>[00:11:13] <strong>Nathan Wrigley:</strong> I&#8217;m sitting across from you, as you just said, and you&#8217;ve got the lanyard around your neck and it&#8217;s got your name on it. And so if you wish to wear that, everybody can figure out what your name is. Actually, that really does prevent a lot of awkward moments because it&#8217;s totally okay to stare at that. I&#8217;ve done that so many times, hello, and you don&#8217;t have to say, what&#8217;s your name? You just go, oh, hi Remkus and so on.</p>\n\n\n\n<p>But also curiously, and I think I&#8217;ve not seen this before. Well, I&#8217;ve not seen it at other events. Your lanyard yard has a green sticker. Why has it got a green sticker?</p>\n\n\n\n<p>[00:11:43] <strong>Remkus de Vries:</strong> So we&#8217;ve added, we&#8217;ve had this for a few additions now. So on your lanyard, like you said, it says your name and the sticker, that we have some sticker options and one of them has to indicate I&#8217;m okay with you if you approach me..</p>\n\n\n\n<p>I&#8217;m okay. if, if you want to start talking to me. And I am. But there&#8217;s also a sticker that indicates I&#8217;d rather keep my distance. And if, if I want to talk I&#8217;ll approach you instead of you me. So, you know, for those in need, it&#8217;s a great mechanism to help you be as comfortable as can be.</p>\n\n\n\n<p>[00:12:11] <strong>Nathan Wrigley:</strong> Yeah. It&#8217;s because there are all sorts of people here. There are some fairly gregarious people, and if you have, if you&#8217;re just wandering around, there is a chance that you may be just spoken to by random people, cause that happens quite a lot. If you&#8217;re wearing the red one, so I&#8217;m guessing there&#8217;s red, yellow, amber and green, red basically indicates look, I&#8217;m happy to be in this environment, but I would rather it that you just left me to it. I&#8217;m wandering about, to stay wandering about by myself.</p>\n\n\n\n<p>[00:12:37] <strong>Remkus de Vries:</strong> Yeah. I don&#8217;t think the percentage that is using a red one is particularly that high, but it&#8217;s a mechanism that&#8217;s very easy to implement. It&#8217;s very easy if for those who actually need it to use it.</p>\n\n\n\n<p>[00:12:48] <strong>Nathan Wrigley:</strong> There&#8217;s loads of other things, there&#8217;s quiet spaces, there&#8217;s places where you can go and just be quiet. There&#8217;s childcare for, from really early ages, right up 16. If you to take, take that on board, you know, so if the impediment to coming is that you&#8217;ve got children, well it need not be, I can&#8217;t speak for the other events elsewhere, but this one, that&#8217;s happening. There&#8217;s also a ton of nice food, and there&#8217;s a ton of space outside. And we&#8217;re lucky enough that in Porto, we&#8217;ve really managed to avoid the poor weather which was predicted to land.</p>\n\n\n\n<p>[00:13:17] <strong>Remkus de Vries:</strong> Well, we had a bit of the rain yesterday, but you know, it&#8217;s fine.</p>\n\n\n\n<p>[00:13:19] <strong>Nathan Wrigley:</strong> But there&#8217;s tons of outdoor space, so there&#8217;s lots of opportunities to just go and hang out. Yeah, there&#8217;s absolutely loads put on. Right, but the question remains is why are you here talking about this? And the reason you&#8217;re here talking about this is because you were one of the founders of the whole enterprise.</p>\n\n\n\n<p>We&#8217;re at year 10 and there&#8217;s badges and posters all over the place saying happy birthday. Ten years old. You&#8217;re like the father of this along with other mothers and fathers.</p>\n\n\n\n<p>[00:13:49] <strong>Remkus de Vries:</strong> Yes. Yes. So the very first WordCamp I went to was WordCamp Netherlands, and it was also the very first WordCamp I organized. So, what that did is introduced a lot of people from the European continent came to the first WordCamp Netherlands. Through that I got to meet other people that I enjoyed spending time with. One of them was uh, Zé Fontainhas from Portugal. Over the next two years, we found each other at various WordCamps in Europe.</p>\n\n\n\n<p>We both quite quick landed on the idea together that, wouldn&#8217;t it be great if we would have one event in Europe uniting all of Europe as a community? Because we looked at the United States and they have, at that time they had WordPress San Francisco, which is now moving around and called WordCamp US. So we saw there is no European equivalent of it. Fast forward another year, we were in January 2012. We were with a bunch of friends, we were in what we call WP on tour. We rented an incredibly nice and a very, very interesting villa, ask me later. Yeah, so we introduced the idea to other folks there. We got a lot of excitement about it. And then as it so happens, Zé and I, and some other friends were invited for the inaugural WordPress community summit in 2012, October, where Matt and the representative of WordPress Central was also going to be. So we pitched the idea there.</p>\n\n\n\n<p>We had to do some convincing and explaining like, why? Because the rule at the time was you cannot do regional WordCamps. It has to be city-based. Especially this large of a region, Europe sounds like one thing, but it most certainly is not, depending on whichever definition you look up. We eventually got the go ahead, and with, with the slight contingent if I remember correctly, like, we&#8217;ll see how it goes, if it works ,out great, and if it doesn&#8217;t, you know, we tried. that&#8217;s essentially how this whole thing started becoming a thing.</p>\n\n\n\n<p>[00:15:42] <strong>Nathan Wrigley:</strong> Where was the first actual one?</p>\n\n\n\n<p>[00:15:46] <strong>Remkus de Vries:</strong> In Leiden, the Netherlands.</p>\n\n\n\n<p>[00:15:47] <strong>Nathan Wrigley:</strong> Let&#8217;s just draw out over those 10 years where we&#8217;ve got, but let&#8217;s just quickly paint the picture where we are today. WordCamp Europe, 2022. I think correct me if I&#8217;m wrong. 2,700 attendees. I don&#8217;t know how many volunteers, but many, many hundreds, I think because there are, yeah, there&#8217;s t-shirts everywhere. So we&#8217;re definitely I would imagine over 3000 people involved. So let&#8217;s go back 10 years. What did that look like?</p>\n\n\n\n<p>[00:16:16] <strong>Remkus de Vries:</strong> I think we sold 832 tickets and we had about 780 people actually showing up. So the actual turnout percentage was extremely high, but we were already happy we were past 500. Cause we had no idea where it was going to land. Right, so at the time, we started organizing it, with selling tickets early 2013. And we had kind of an idea of how many we should be able to get in terms of attendees, we didn&#8217;t know.</p>\n\n\n\n<p>So at that time countries like France had a small but upcoming WordPress community. Spain was very active. The Netherlands, I was quite active. Portugal as well. But, Italy for instance was fragmented. Serbia close to non-existent, and I think you see where I&#8217;m going with. The whole goal was for us to unite, to be in the same room, talk to each other, learn about each other and see that we are, we have a common goal.</p>\n\n\n\n<p>That was the purpose of working in Europe. But we didn&#8217;t know how many people see the same purpose. See the same benefit. So we had initially said, you know, 500, we&#8217;re good, we&#8217;re good. Nice.</p>\n\n\n\n<p>[00:17:24] <strong>Nathan Wrigley:</strong> So in what ways was it different? The reason I asked that question is because, I&#8217;ve only been to two WordCamp Europes. I went to the previous one in Berlin, which was actually now three years ago. Paint a picture of the difference between what it was like in the first one and what it&#8217;s like now. And the reason I&#8217;m asking that is because here it really, really feels incredibly slick and professional. They both had that feel about them. Was it always thus, or were the first ones a bit more cottage industry? Just tell us what was different.</p>\n\n\n\n<p>[00:17:56] <strong>Remkus de Vries:</strong> I&#8217;d like to think that from the experience of those who were attending, it has been a good experience from the early beginning. Having said that there is a lot of room for improvement as we were doing the first one, we quickly realized there was a lot of things we could do better, should do better. All that. But I think the challenge more has been, as we grew, the amount of effort you have to put in is not, in my experience. is not a linear one. It&#8217;s more of a, what do you call that in English?</p>\n\n\n\n<p>[00:18:27] <strong>Nathan Wrigley:</strong> Parabola.</p>\n\n\n\n<p>[00:18:28] <strong>Remkus de Vries:</strong> Parabola, there you go. So, as you mentioned, there was a lot of volunteers here because the amount of that is just vastly increased. So Yes, there&#8217;s a lot of things that have been much smoother and better taken care of. At the end of WordCamp Europe in Leiden, all of us on the organizing team were absolutely exhausted. Like full on. I&#8217;m not saying they&#8217;re not exhausted now here, but I&#8217;m also telling you it&#8217;s quite different to the level of stress that we had that first time, because nobody knew.</p>\n\n\n\n<p>Every single person there had organized WordCamps before. So we picked that. Some had less experience or maybe just a meetup type of stuff but everybody had some type of experience. So we leaned on each other mostly. But the size is the quantifier there, that determines how much more you have to do. At every single WordCamp after, I get stopped by people all the time, saying hi, some will say, how much they&#8217;ve enjoyed every single one since the first one and all that.</p>\n\n\n\n<p>And uh, some will start reminding me of things happened during the first one or the second one, even. I go like, yeah, I don&#8217;t know. Cos it&#8217;s been a blur. I don&#8217;t know how many kilometers I walked that first one, but it&#8217;s been a lot just in the venue. Cause I was running back and forth constantly because there&#8217;s all these little things we need to take care of in the moment. Now, we know all those things. So we do take care of that before it actually happens. So it&#8217;s, you know, it&#8217;s most certainly has done way more professional.</p>\n\n\n\n<p>Media coverage is one, but, the video recording is another. The captioning. You know, everything we can do to make it better, that has happened continuously. So yes, I think it was quite all right, the first organization. But it&#8217;s gotten way better.</p>\n\n\n\n<p>[00:20:11] <strong>Nathan Wrigley:</strong> It really does feel like Google IO or something like that, you know, incredibly professional and incredibly well managed.</p>\n\n\n\n<p>[00:20:17] <strong>Remkus de Vries:</strong> That&#8217;s a great compliment.</p>\n\n\n\n<p>[00:20:18] <strong>Nathan Wrigley:</strong> Do you see events like this as, they&#8217;re a nice thing to do. You know, you turn up your watch speakers, you hang out and you make friends and all of that kind of stuff. Is it, is it more? Is it more the glue that binds the community together?</p>\n\n\n\n<p>[00:20:32] <strong>Remkus de Vries:</strong> It&#8217;s both.</p>\n\n\n\n<p>[00:20:32] <strong>Nathan Wrigley:</strong> Yeah, because the reason I&#8217;m asking that is because in the last, everybody knows what happened over the last two years. I don&#8217;t need to spell it out, but we had a hiatus, a couple of years. Kind of feels to me, as if things went off the rails a bit with the community. Not like it felt a pieces, but it just had to adapt and feels like there&#8217;s this collective sigh of relief and almost every conversation that I had in the first day for the first few hours until everybody got out of their system was, oh, it&#8217;s so nice to be back.</p>\n\n\n\n<p>[00:21:00] <strong>Remkus de Vries:</strong> Yeah, and it is, it is. I think the glue part is way more important than people thought that it was. You have the same thing happening. So you and I meet over, you know, when I join your podcast, you and I, we do it over a digital connection. It&#8217;s a small screen. It shows a part of your body and it has a diminished version of you. And that&#8217;s vice versa. So there&#8217;s a layer of information I&#8217;m not getting.</p>\n\n\n\n<p>And I think you can say the same thing for what we&#8217;re seeing here. Yes, you can be connected. You can have great relationships online and everything, but the real deal is in real life. That&#8217;s where you make the actual connections. As you mentioned before we started the podcast, you said, I can&#8217;t believe how big you are. So that&#8217;s the thing I keep hearing, right. but you see that in real life. That&#8217;s an example of information you don&#8217;t get when you look at me, cause you have no idea what my surrounding and what. the proportions is. And that&#8217;s such a simple example, but there&#8217;s like, I look you straight in the eyes, that&#8217;s already different.</p>\n\n\n\n<p>You have things you say that you then in real life have time to correct If that wasn&#8217;t the intent that you actually had. All of these little things make up what that glue actually exists of so, not having that for two years creates a like a vacuum of things that are not seen, not communicated, not spoken about, not processed.</p>\n\n\n\n<p>So, there&#8217;ve been companies started from WordCamps. There have been mergers started. There have been friends made there have been marriages come from WordCamps. Everything happens when you&#8217;re together,. Uh, which is one of the prime goals that we had. So I know the theme here is the 10th edition. If I&#8217;m really honest, it&#8217;s not, it&#8217;s the eighth.</p>\n\n\n\n<p>[00:22:39] <strong>Nathan Wrigley:</strong> That&#8217;s a good point. Ten years separated the first and the last.</p>\n\n\n\n<p>[00:22:43] <strong>Remkus de Vries:</strong> Yeah, So online costs me energy. So I barely, barely put any time and effort into that. In real life, gives me energy. As much energy as it costs. So you&#8217;re absorbing information all day. You talk to people all day, which you normally don&#8217;t do. You go out, have drinks, have fun, whatever. That costs energy, but the net result is I have energy. I get energized. Maybe that&#8217;s the better way. Online sucks the life out of me.</p>\n\n\n\n<p>[00:23:11] <strong>Nathan Wrigley:</strong> Yeah, that&#8217;s really interesting. And I think, from the core team, the message, I could be misrepresenting this, but I think that the message was that contributions dropped off a bit. People seem to be.</p>\n\n\n\n<p>[00:23:24] <strong>Remkus de Vries:</strong> I&#8217;m sure it has. I&#8217;m sure it has, but I think that&#8217;s, I don&#8217;t think that&#8217;s necessarily something that&#8217;s attributed to not meeting in real life per se. I think that&#8217;s more attributed to stuff going on.</p>\n\n\n\n<p>[00:23:35] <strong>Nathan Wrigley:</strong> Yeah. Would it be fair to say that during the last couple of years, you&#8217;ve sort of stepped away from WordPress a bit? You&#8217;ve a little bit less, less fired up about it. And, and are you back, are you back where you were a couple of, three years ago?</p>\n\n\n\n<p>[00:23:47] <strong>Remkus de Vries:</strong> I&#8217;m going to quote LL Cool J. LL Cool J said don&#8217;t call it a comeback, I&#8217;ve been here for years. So I&#8217;ve never really left, but I&#8217;ve most certainly moved to more lurking, on the side. Life and work was too busy to be as engaged as I was previously.</p>\n\n\n\n<p>[00:24:03] <strong>Nathan Wrigley:</strong> If people want to get involved, they&#8217;ve got to commit a long time in advance to being a volunteer or an organizer.</p>\n\n\n\n<p>[00:24:11] <strong>Remkus de Vries:</strong> Not that long.</p>\n\n\n\n<p>[00:24:13] <strong>Nathan Wrigley:</strong> How do they do it? Where do they go? What kind of channels do they need to be visiting?</p>\n\n\n\n<p>[00:24:16] <strong>Remkus de Vries:</strong> So, inside your WordPress dashboard, there&#8217;s a little widget and that tells you where there are meetups relative, close to your location. So that&#8217;s the first thing to check out. They don&#8217;t necessarily need volunteers yet, but it gives you, a, an idea to check out what&#8217;s going on.</p>\n\n\n\n<p>What are all those people are raving about, right? Why should I even bother going? Once you find one that you like, you&#8217;ll start meeting people, and maybe you want to use a WordCamp in, I live in the Netherlands. so maybe you want to use a WordCamp in Germany as a, as a nice excuse to get out. So you go to Germany, maybe from there you go like, hmm, interesting, I kind of want to see this grow further. I want to give this my a devotion and time. Every single WordCamp that is up and coming is on central.wordcamp.org. Check them out. Find one you like and see if they are looking for volunteers.</p>\n\n\n\n<p>So maybe the call for volunteers hasn&#8217;t gone out yet. Maybe you would even like to speak. Maybe even you&#8217;d like to organize. Everything is possible. It&#8217;s open. And in some cases you need experienced organizers. In some cases there&#8217;s plenty of room for new people to learn. So we always include new people to learn. and that can be you. That can even be you Nathan.</p>\n\n\n\n<p>[00:25:26] <strong>Nathan Wrigley:</strong> Yes, yes. I think I&#8217;ve found my niche. Sitting on a chair talking into a microphone.</p>\n\n\n\n<p>[00:25:32] <strong>Remkus de Vries:</strong> But you&#8217;re jokingly saying this, but that is actually part of what is contributing. It&#8217;s not a predefined thing, like you need to write code or you need to do translations or you need to help this or this or that. It is whatever helps the project. This is helping the project.</p>\n\n\n\n<p>[00:25:44] <strong>Nathan Wrigley:</strong> There are literally hundreds of roles. I&#8217;ve been quite surprised by the different things I&#8217;ve seen people doing. Obviously there&#8217;s people standing, handing out microphones, there&#8217;s people, moving boxes. There&#8217;s people printing tickets. There&#8217;s people showing time. Yeah. You know, there&#8217;s people making sure that. Well there&#8217;s, yeah, yet, already done it?</p>\n\n\n\n<p>[00:26:04] <strong>Remkus de Vries:</strong> Yeah.</p>\n\n\n\n<p>[00:26:05] <strong>Nathan Wrigley:</strong> How did it go?</p>\n\n\n\n<p>[00:26:05] <strong>Remkus de Vries:</strong> Yesterday morning? I think fine. I forgot a few things, but that was to be expected.</p>\n\n\n\n<p>[00:26:09] <strong>Nathan Wrigley:</strong> Remkus de Vries. Thank you for joining us on the podcast today.</p>\n\n\n\n<p>[00:26:12] <strong>Remkus de Vries:</strong> Happy to have been here.</p>\n\n\n\n<p>[00:26:13] <strong>Nathan Wrigley:</strong> One final question just before we end. 2023, are you going to be there?</p>\n\n\n\n<p>[00:26:18] <strong>Remkus de Vries:</strong> Yeah.</p>\n\n\n\n<p>[00:26:19] <strong>Nathan Wrigley:</strong> Where is it?</p>\n\n\n\n<p>[00:26:22] <strong>Remkus de Vries:</strong> Europe.</p>\n\n\n\n<p>[00:26:22] <strong>Nathan Wrigley:</strong> You know, don&#8217;t you?</p>\n\n\n\n<p>[00:26:23] <strong>Remkus de Vries:</strong> I do.</p>\n</div>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Wed, 08 Jun 2022 14:00:00 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:14:\"Nathan Wrigley\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:36;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:104:\"Post Status: Post Status Comments (No. 10) — Nineteen Years of WordPress: A Look Back and a Look Ahead\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"https://poststatus.com/?p=98836\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:45:\"https://poststatus.com/19-years-of-wordpress/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:138:\"Mary Job, Nathan Wrigley, Naoko Takano, Olivia Bisset, Yvette Sonneveld, Taco Verdo, and Nyasha Green talk about WordPress as it turns 19.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Tue, 07 Jun 2022 21:21:08 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:12:\"David Bisset\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:37;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:57:\"Post Status: 9 Things I Learned from WordCamp Europe 2022\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"https://poststatus.com/?p=98828\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:68:\"https://poststatus.com/9-things-i-learned-from-wordcamp-europe-2022/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:205:\"A lot of interesting things surfaced in the open conversations with Matt and Josepha at WCEU. I also learned a lot from Pablo Postigo, Feliz Arntz, Shane Pearlman, Jonathan Wold, Nora Ferrerio, Milana Cap.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Tue, 07 Jun 2022 20:30:06 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:12:\"David Bisset\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:38;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:90:\"Gutenberg Times: WordPress 6.0, WordCamp Europe and Roadmap for 6.1 –Weekend Edition 217\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:35:\"https://gutenbergtimes.com/?p=21250\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:97:\"https://gutenbergtimes.com/wordpress-6-0-wordcamp-europe-and-roadmap-for-6-1-weekend-edition-217/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:18886:\"<p>Howdy, howdy! </p>\n\n\n\n<p>I hoped to get this edition published before the <a href=\"https://blog.bigorangeheart.org/2019/11/post-wordcamp-emotions/\">After-WordCamp Europe slump</a> would hit me, but I ran out of energy. Nevertheless, I wanted you to have all of below links, so here it is the Weekend Edition on a Tuesday 🙂  </p>\n\n\n\n<p>The first regional in-person WordCamp was a great start into the next phase of Community events.  Approx 800 people worked on the open-source project on Contributor Day and approx 1,500 more attendees joined in for talks, workshops, conversations at the WP Cafe, populated the Sponsor Hall and run into each other on the Hallway Track.  It was not without its challenges, though. Enforcing the in-door mask mandate was surprisingly difficult for an supposedly adult population. </p>\n\n\n\n<p>Nevertheless, the organizers and volunteers with the help of the venue staff, sponsors and speaker produced a high-level extra-ordinary WordCamp together. </p>\n\n\n\n<p>I will have more insights from WordCamp Europe in following editions.  For now I leave you with an impression of the fabulous branding of <a href=\"https://europe.wordcamp.org/2022/organisers/#design-team\">WordCamp Europe design team</a>. Below you&#8217;ll find the links to the Live-streamed talks on YouTube. </p>\n\n\n\n<a href=\"https://europe.wordcamp.org/2022/\"><img /></a>\n\n\n\n<p>The last two weeks were filled with lot of WordPress news, not all Block editor related, though. Enjoy the catch-up. </p>\n\n\n\n<p>Yours, 💕<br /><em>Birgit</em></p>\n\n\n\n<p>PS: More numbers: Five years ago, I started curating news about Gutenberg, after watching the first release video at WordCamp Europe, that took place in Paris in 2017. This year, WordCamp Europe celebrated its 10-year anniversary. Last week, Saturday was the 20-year anniversary of Pauli Systems, the web development company I founded in 2002 and closed earlier this year. Just saying. </p>\n\n\n\n\n\n\n<div class=\"wp-container-5 wp-block-group has-light-background-background-color has-background\"><div class=\"wp-block-group__inner-container\">\n<p><strong>Table of Contents</strong></p>\n\n\n\n<div class=\"wp-block-sortabrilliant-guidepost\"><ul><li><a href=\"https://gutenbergtimes.com/feed/#0-word-camp-europe\">WordCamp Europe</a></li><li><a href=\"https://gutenbergtimes.com/feed/#2-word-press-6-0\">WordPress 6.0 </a></li><li><a href=\"https://gutenbergtimes.com/feed/#3-gutenberg-13-3\">Gutenberg 13.3 </a></li><li><a href=\"https://gutenbergtimes.com/feed/#4-word-press-6-1\">WordPress 6.1 </a></li><li><a href=\"https://gutenbergtimes.com/feed/#4-b\">Miscellenous Block Editor news</a></li><li><a href=\"https://gutenbergtimes.com/feed/#5-word-press-social-learning-events\">WordPress Social Learning Events</a></li><li><a href=\"https://gutenbergtimes.com/feed/#6-other-word-press-events\">Other WordPress Events</a></li></ul></div>\n</div></div>\n\n\n\n\n<h2 id=\"0-word-camp-europe\">WordCamp Europe</h2>\n\n\n\n<p>If you didn&#8217;t get a chance to watch them on the live stream or want to follow-up on them, here are the links to YouTube for the Block-editor related talks Track 1. Lightning talks were around 7 min (click on the title for the recording). Full talks were around 30 min with some Q &amp; A. (click on <em>Recording</em> link). Workshops were recorded but not live streamed and will be uploaded to WordPress.tv soon. </p>\n\n\n\n<p><a href=\"https://europe.wordcamp.org/2022/session/the-block-pattern-revolution/\"><strong>The block pattern revolution</strong></a> with <a href=\"https://twitter.com/SeanBlakeley\">Sean Blakeley</a><br />-&gt; <a href=\"https://youtu.be/91anxAgQGJw?t=8717\"></a><a href=\"https://youtu.be/91anxAgQGJw?t=8717\"><strong>Recording</strong></a></p>\n\n\n\n<p>Workshop: <a href=\"https://europe.wordcamp.org/2022/session/build-your-first-block-theme/\">Build your first block theme</a>&nbsp;<a href=\"https://twitter.com/DaisyOlsen\">Daisy Olsen</a> &#8211; will be published later on WordPress.tv</p>\n\n\n\n<p> <a href=\"https://youtu.be/91anxAgQGJw?t=15891\"><strong>Creating interactive blocks: old, new, and good ways</strong></a> (Lightning Talk) with JuanMa Garrido</p>\n\n\n\n<ul><li><a href=\"https://github.com/wordpress-juanmaguitar/interactive-blocks-demos\">Demo Repo</a></li><li>Request for Comments: <a href=\"https://make.wordpress.org/core/2022/04/27/exploration-to-enable-better-developer-and-visitor-experiences-with-blocks/\">Exploration to enable better Developer and Visitor Experiences with blocks</a></li></ul>\n\n\n\n<p><a href=\"https://youtu.be/91anxAgQGJw?t=16392\"><strong>Extending Gutenberg with SlotFill</strong></a> (Lightning Talk)with <a href=\"https://twitter.com/ryanwelcher\">Ryan Welcher</a></p>\n\n\n\n<ul><li>More Examples on <a href=\"https://github.com/ryanwelcher/gutenberg-slot-fill-system\">this GitHub Repo</a></li></ul>\n\n\n\n<p><a href=\"https://youtu.be/91anxAgQGJw?t=16864\"><strong>Block Themes – The Future of FSE</strong></a> (Lightning Talk) with <a href=\"https://twitter.com/imranhsayed\">Imran Sayed</a></p>\n\n\n\n<p><strong><a href=\"https://youtu.be/91anxAgQGJw?t=17338\">Blockity McBlock Blocks, Oh My!</a> </strong>(Lightning Talk) with <a href=\"https://twitter.com/circlecube\">Evan Mullins</a></p>\n\n\n\n<ul><li><a href=\"https://github.com/circlecube/evans-block-theme\">Evan&#8217;s Block Theme on GitHub</a></li></ul>\n\n\n\n<p><a href=\"https://youtu.be/91anxAgQGJw?t=17892\"><strong>Delivering Personalised Experiences using WordPress</strong></a> (Lightning Talk) with <a href=\"https://twitter.com/paulfhalfpenny\">Paul Halfpenny</a></p>\n\n\n\n<ul><li><a href=\"https://wordpress.org/plugins/wp-dxp/\">WPDXP Plugin</a> at WordPress.org Rule-based block handling. </li></ul>\n\n\n\n<p><a href=\"https://europe.wordcamp.org/2022/session/level-up-block-building-skills/\"><strong>Level Up Block Building Skill</strong>s</a>&nbsp;with <a href=\"https://twitter.com/gziolo\">Greg Ziolkowski</a> <br />-&gt; <a href=\"https://youtu.be/91anxAgQGJw?t=23073\"><strong>Recording</strong></a></p>\n\n\n\n<p>Workshop:&nbsp;<a href=\"https://europe.wordcamp.org/2022/session/creating-a-pre-publish-checklist-for-gutenberg/\">Creating a pre-publish checklist for Gutenberg</a> with Ryan Welcher &#8211; will be published later on WordPress.tv</p>\n\n\n\n<p><a href=\"https://europe.wordcamp.org/2022/session/the-future-of-commerce-in-wordpress-with-full-site-editing/\"><strong>The future of commerce in WordPress with Full Site Editin</strong>g</a> with <a href=\"https://twitter.com/nerrad\">Darren Ethier</a> <br />-&gt; <a href=\"https://youtu.be/Qq1SBFzByDw?t=7476\"><strong>Recording</strong></a></p>\n\n\n\n<p><a href=\"https://europe.wordcamp.org/2022/session/a-glimpse-into-the-future-of-wordpress-from-a-frontend-point-of-view/\"><strong>A glimpse into the future of WordPress from a frontend point of view</strong></a>&nbsp;with <a href=\"https://twitter.com/iamposti\">Pablo Postigo</a> <br />-&gt; <a href=\"https://youtu.be/Qq1SBFzByDw?t=18602\"><strong>Recording</strong></a></p>\n\n\n\n<p><a href=\"https://europe.wordcamp.org/2022/session/growing-the-wordpress-design-system/\"><strong>Growing the WordPress design system</strong>&nbsp;</a>with <a href=\"https://twitter.com/karmatosed\">Tammie Lister</a> <br />-&gt; <a href=\"https://youtu.be/Qq1SBFzByDw?t=21988\"><strong>Recording</strong></a></p>\n\n\n\n<p><a href=\"https://youtu.be/Qq1SBFzByDw?t=25934\"><strong>Townhall Q &amp; A</strong></a> with Matt Mullenweg, co-founder of WordPress and CEO of Automattic and Josepha Haden Chomphosy, executive directory of the WordPress open-source project. </p>\n\n\n\n<p>If you want to look for any of the other talks, and also view the fabulous live interviews with Attendess, here are the YouTube links for all live streamed talks and live interviews. </p>\n\n\n\n<ul><li><a href=\"https://www.youtube.com/watch?v=91anxAgQGJw\">Day 1 &#8211; Track 1</a>  | <a href=\"https://www.youtube.com/watch?v=0GiB99rkivI\">Day 1 &#8211; Track 2</a> </li><li><a href=\"https://www.youtube.com/watch?v=Qq1SBFzByDw\">Day 2 &#8211; Track 1</a> | <a href=\"https://www.youtube.com/watch?v=Da1Jmi7wgCY\">Day 2 &#8211; Track 2</a></li></ul>\n\n\n\n<hr class=\"wp-block-separator has-alpha-channel-opacity is-style-wide\" />\n\n\n\n\n<p><strong>&nbsp;<a href=\"https://make.wordpress.org/core/handbook/references/keeping-up-with-gutenberg-index/\" target=\"_blank\" rel=\"noreferrer noopener\">&#8220;Keeping up with Gutenberg &#8211; Index 2022&#8221;</a>&nbsp;</strong><br />A chronological list of the WordPress Make Blog posts from various teams involved in Gutenberg development: Design, Theme Review Team, Core Editor, Core JS, Core CSS, Test and Meta team from Jan. 2021 on. Updated by yours truly.  <a href=\"https://make.wordpress.org/core/handbook/references/keeping-up-with-gutenberg-index/keeping-up-with-gutenberg-index-2020/\"><em>The index 2020 is here</em></a></p>\n\n\n\n\n<h2 id=\"2-word-press-6-0\">WordPress 6.0 </h2>\n\n\n\n<p>You might have already read and watched most of the official communication. Just in case you need to catch up, I post them here again. </p>\n\n\n\n<ul><li><a href=\"https://wordpress.org/news/2022/05/arturo/wordpress-6-0-release-candidate-2-rc2-now-available-for-testing/\">WordPress 6.0 </a>“Arturo” Release post</li><li><a href=\"https://make.wordpress.org/core/2022/05/03/wordpress-6-0-field-guide/\">WordPress 6.0 Field Guilde</a> with all DevNotes and changes</li><li>Video: <a href=\"https://youtu.be/oe452WcY7fA\">Release announcement</a></li><li><a href=\"https://wptavern.com/new-video-explores-site-building-progress-from-wordpress-5-0-to-6-0\">New Video Explores Site Building Progress From WordPress 5.0 to 6.0</a></li></ul>\n\n\n\n<hr class=\"wp-block-separator has-alpha-channel-opacity is-style-wide\" />\n\n\n\n<p>Just in time for the WordPress 6.0 release, Pantheon published my article on <a href=\"https://pantheon.io/blog/what-expect-wordpress-6\"><strong>What To Expect from WordPress 6</strong>.</a> Apart from the enhancements of the writing experience, the article is more developer oriented with code examples for the new pattern features, Block locking examples and Style variations in theme.json.</p>\n\n\n\n<hr class=\"wp-block-separator has-alpha-channel-opacity is-style-wide\" />\n\n\n\n<p>Celebrating the occasion of WordPress 6.0 and 10 releases after the first introduction of the block editor to WordPress core with the 5.0 version, <strong>Anne McCarthy</strong> published the video <a href=\"https://www.youtube.com/watch?v=MjDhfW7FpAc\">site building progress between WordPress 5.0 and 6.0</a> showing us just how far the Block Editor has progressed since the 2018 version.  </p>\n\n\n\n<p><strong>Sarah Gooding</strong> posted a review of the video: <a href=\"https://wptavern.com/new-video-explores-site-building-progress-from-wordpress-5-0-to-6-0\"><strong>New Video Explores Site Building Progress From WordPress 5.0 to 6.0</strong></a>. &#8220;Ten major versions later, nearly every aspect of a WordPress site is customizable through the site editor. For those who have not yet made the leap into full-site editing – it’s essentially like the old Customizer but with super powers, better instant previews, and the interface is a panel on the right.&#8221; Gooding wrote. </p>\n\n\n\n<h2 id=\"3-gutenberg-13-3\">Gutenberg 13.3 </h2>\n\n\n\n<p>Two weeks ago, <strong>Ryan Welcher</strong> led the release of Gutenberg 13.3 and shared <a href=\"https://make.wordpress.org/core/2022/05/26/whats-new-in-gutenberg-13-3-0-may-25/\"><strong>What’s New in Gutenberg 13.3.0 ( May 25 )</strong></a>. He highlighted the following features: </p>\n\n\n\n<ul><li><a href=\"https://make.wordpress.org/core/2022/05/26/whats-new-in-gutenberg-13-3-0-may-25/#toc-block\">New Table Of Contents Block</a></li><li><a href=\"https://make.wordpress.org/core/2022/05/26/whats-new-in-gutenberg-13-3-0-may-25/#post-terms-block\">Post Terms Block variations to display custom taxonomy terms</a></li><li><a href=\"https://make.wordpress.org/core/2022/05/26/whats-new-in-gutenberg-13-3-0-may-25/#query-loop-parent-filter\">Query Loop Block now supports a “parent” filter</a></li></ul>\n\n\n\n<hr class=\"wp-block-separator has-alpha-channel-opacity is-style-wide\" />\n\n\n\n<p><strong>Sarah Gooding</strong> of WPTavern covered the latest plugin release in her article: <a href=\"https://wptavern.com/gutenberg-13-3-introduces-experimental-table-of-contents-block\"><strong>Gutenberg 13.3 Introduces Experimental Table of Contents Block</strong></a>&nbsp;</p>\n\n\n\n<hr class=\"wp-block-separator has-alpha-channel-opacity is-style-wide\" />\n\n\n\n<p>In the <a href=\"https://gutenbergtimes.com/podcast/gutenberg-changelog-67-wordpress-6-0/\"><strong>67th episode of the Gutenberg Changelog</strong></a>, <strong>Grzegorz Ziolkowski,</strong> subing for Mary Job, and I talk through the latest two plugin releases. We also covered in more details, what the Gutenberg developers and designers are working on and what discussions are could use your input. </p>\n\n\n\n<p class=\"has-border-background-color has-background\"><a href=\"https://gutenbergtimes.com/how-to-disable-theme-features-and-lock-block-templates-for-full-site-editing-in-wordpress/\"><strong>How to disable theme features and Lock Block Templates for Full-Site Editing in WordPress</strong></a> on Gutenberg Times</p>\n\n\n\n<h2 id=\"4-word-press-6-1\">WordPress 6.1 </h2>\n\n\n\n<p>The release cycle for 6.1 already started with some early Bug Scrubs and <strong>Matias Ventura </strong>published the <a href=\"https://make.wordpress.org/core/2022/06/04/roadmap-to-6-1/\"><strong>Roadmap to 6.1 for the Gutenberg Project Phase 2</strong></a>. He wrote: &#8220;The tune of the release will be to refine the experiences introduced in 5.9 and 6.0, weave the various flows into more coherent and fulfilling experiences for users, maintainers, and extenders, and close some gaps in functionality as we start to look towards Phase 3 of the&nbsp;Gutenberg&nbsp;roadmap.&#8221; Ventura also updated the tracking issues on GitHub for the various features: </p>\n\n\n\n<ul><li><a href=\"https://github.com/WordPress/gutenberg/issues/41241\">Template Editor</a></li><li><a href=\"https://github.com/WordPress/gutenberg/issues/41549\">Improving the navigation block</a></li><li><a href=\"https://github.com/WordPress/gutenberg/issues/38529\">Building With Patterns</a></li><li><a href=\"https://github.com/WordPress/gutenberg/issues/41232\">Global Styles&nbsp;</a></li><li><a href=\"https://github.com/WordPress/gutenberg/issues/33447\">Blocks &amp; Design Tools&nbsp;</a></li><li><a href=\"https://github.com/WordPress/gutenberg/issues/39324\">Theme switching flows</a>&nbsp;</li></ul>\n\n\n\n<hr class=\"wp-block-separator has-alpha-channel-opacity is-style-wide\" />\n\n\n\n<p>Need a the short version? <strong>Dave Smith</strong> created a <a href=\"https://www.youtube.com/watch?v=8Vj_Oh6jMHw\"><strong>short video showing off his Top five features </strong></a>and interfaces in the works that are on the roadmap for  WordPress 6.1. </p>\n\n\n\n\n<p><strong><a href=\"https://gutenbergtimes.com/need-a-zip-from-master/\">Need a plugin .zip from Gutenberg&#8217;s master branch?</a></strong><br />Gutenberg Times provides daily build for testing and review. <br />Have you been using it? Hit reply and let me know.</p>\n\n\n\n<p><img alt=\"GitHub all releases\" src=\"https://img.shields.io/github/downloads/bph/gutenberg/total?style=for-the-badge\" /></p>\n\n\n\n\n<h2 id=\"4-b\">Miscellenous Block Editor news</h2>\n\n\n\n<p><strong>Anne McCarthy </strong>announced that <a href=\"https://gutenbergtimes.com/museum-of-block-art-is-open-for-submissions/\">The Museum of Block art is now open for submissions</a></p>\n\n\n\n<hr class=\"wp-block-separator has-alpha-channel-opacity is-style-wide\" />\n\n\n\n<p><strong>Nathan Wrigley</strong> spoke with <a href=\"https://wptavern.com/podcast/28-mark-root-wiley-on-creating-standards-for-css-in-wordpress\">Mark Root-Wiley on creating standards for CSS in WordPress</a> in the 28th episode of the WP Tavern JukeBox podcast. It&#8217;s a  very timely discussion as contributors are working on various aspects of the Style Engine for the block editor. Earlier this year Root-Wiley published a proposal: <a href=\"https://github.com/WordPress/gutenberg/issues/38998\">Standardized block markup, theme.json design tokens, and CSS classes to improve interoperability</a></p>\n\n\n\n<h2 id=\"5-word-press-social-learning-events\">WordPress Social Learning Events</h2>\n\n\n\n<p>The training team scheduled new Social Learning Events covering the Block editor.  </p>\n\n\n\n<p><strong>June 9, 2022 &#8211; 2 pm EDT  /  18:00 UTC<br /><a href=\"https://www.meetup.com/wordpress-social-learning/events/286256895/\">Builder Basics: Everything You Need to Know About Patterns</a></strong> w/ Nick Diego</p>\n\n\n\n<p><strong>June 16, 2022 &#8211; 3 pm EDT / 19:00 UTC </strong><br /><strong><a href=\"https://www.meetup.com/wordpress-social-learning/events/286028824/\">Let&#8217;s build a homepage together</a></strong> w/ Wes Theron. </p>\n\n\n\n<h2 id=\"6-other-word-press-events\">Other WordPress Events</h2>\n\n\n\n<p><strong>June 11 + 12, 2022 </strong> <br /><a href=\"https://warsaw.wordcamp.org/2022/\"><strong>WordCamp Warsaw</strong></a></p>\n\n\n\n<p><strong>June 20 &#8211; 24, 2022</strong> <br /><strong><a href=\"https://pagebuildersummit.com/\">Page Builder Summit </a></strong></p>\n\n\n\n<p><strong>June 25, 2022 </strong><br /><strong><a href=\"https://montclair.wordcamp.org/2022/\">WordCamp Montclair, NJ</a></strong></p>\n\n\n\n<p><strong>September 9 &#8211; 11, 2022</strong><br /><strong><a href=\"https://us.wordcamp.org/2022/\">WordCamp US</a></strong>, San Diego, California</p>\n\n\n\n<p><strong>September 15 + 16, 2022</strong> <br /><a href=\"https://netherlands.wordcamp.org/2022/\"><strong>WordCamp Netherlands</strong></a></p>\n\n\n\n<p><strong>February 17-19 2023</strong> (tent)<br /><a href=\"https://asia.wordcamp.org/2023/\"><strong>WordCamp Asia</strong></a>, Bangkok, Thailand</p>\n\n\n\n\n<hr class=\"wp-block-separator has-css-opacity is-style-wide\" />\n\n\n\n<p class=\"has-text-align-left\"><strong>Don&#8217;t want to miss the next Weekend Edition? </strong></p>\n\n\n\n<form class=\"wp-block-newsletterglue-form ngl-form ngl-portrait\" action=\"https://gutenbergtimes.com/feed/\" method=\"post\"><div class=\"ngl-form-container\"><div class=\"ngl-form-field\"><label class=\"ngl-form-label\" for=\"ngl_email\"><br />Type in your Email address to subscribe.</label><div class=\"ngl-form-input\"><input type=\"email\" class=\"ngl-form-input-text\" name=\"ngl_email\" id=\"ngl_email\" /></div></div><button type=\"submit\" class=\"ngl-form-button\">Subscribe</button><p class=\"ngl-form-text\">We hate spam, too and won&#8217;t give your email address to anyone except Mailchimp to send out our Weekend Edition</p></div><div class=\"ngl-message-overlay\"><div class=\"ngl-message-svg-wrap\"></div><div class=\"ngl-message-overlay-text\">Thanks for subscribing.</div></div><input type=\"hidden\" name=\"ngl_list_id\" id=\"ngl_list_id\" value=\"26f81bd8ae\" /><input type=\"hidden\" name=\"ngl_double_optin\" id=\"ngl_double_optin\" value=\"yes\" /></form>\n\n\n\n<hr class=\"wp-block-separator has-css-opacity is-style-wide\" />\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Tue, 07 Jun 2022 12:13:48 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:18:\"Birgit Pauli-Haack\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:39;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:81:\"Do The Woo Community: WooCommerce Alternatives? Zach, Topher and Luke Take it On.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:28:\"https://dothewoo.io/?p=71702\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:45:\"https://dothewoo.io/woocommerce-alternatives/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:424:\"<p>Are there any direct WooCommerce alternatives that are plugins and not SaaS? Zach Stepek, Topher DeRosia and Luke Carbis take on that question.</p>\n<p>&gt;&gt; The post <a rel=\"nofollow\" href=\"https://dothewoo.io/woocommerce-alternatives/\">WooCommerce Alternatives? Zach, Topher and Luke Take it On.</a> appeared first on <a rel=\"nofollow\" href=\"https://dothewoo.io\">Do the Woo - a WooCommerce Builder Community</a>	.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Tue, 07 Jun 2022 09:01:00 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:5:\"BobWP\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:40;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:58:\"WPTavern: rtCamp Launches WordPress Plugin Compare Project\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:30:\"https://wptavern.com/?p=135089\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:69:\"https://wptavern.com/rtcamp-launches-wordpress-plugin-compare-project\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:4302:\"<p>If you have been navigating the WordPress plugin ecosystem for years, you may instinctively know how to examine and compare two or more plugins&#8217; details pages to select the right solution for your needs. This task can be a big hurdle for newcomers to the platform. The prospect of narrowing down the right plugin from a directory of <a href=\"https://wordpress.org/plugins/\">more than 59,000</a> can be daunting.</p>\n\n\n\n<p>The team behind <a href=\"https://rtcamp.com/\">rtCamp</a>, a 125-person agency and a WordPress VIP Gold agency partner, has launched a new tool called <a href=\"https://wpplugincompare.com/\">WordPress Plugin Compare Project</a> (WPPC) to help users extend WordPress with the right plugins for their needs. WPPC lets users search for plugins to compare and customize each selection displayed on the chart:</p>\n\n\n\n<img />\n\n\n\n<p>The chart displays the age of the plugin, when it was last updated, author, current version, required WP version, required PHP version, and tested up to WP version. It also shows important stats for ratings, total downloads, active installs, support requests and support score. Plugin data is refreshed twice per day, so it&#8217;s always up to date.</p>\n\n\n\n<p>Several major plugin categories where multiple plugins are competing against one another are good candidates for comparison using the WPPC tool, including e-commerce, SEO, analytics, social sharing, performance, block libraries, forms, and security, to name a few. Plug in a few of the top contenders and it&#8217;s easier to see at a glance how they compare in terms of popularity, maintenance, and support. </p>\n\n\n\n<img />\n\n\n\n<p>The comparisons can also be linked. For example, the <a href=\"https://wpplugincompare.com/compare?plugins=genesis-blocks,coblocks,kadence-blocks,otter-blocks\">block collection plugin comparison</a> above and the <a href=\"https://wpplugincompare.com/compare?plugins=contact-form-7,ninja-forms,formidable,wpforms-lite\">forms plugin comparison</a> below is available on the WPPC website. The comparison URL includes each of the four plugin slugs and the tool pulls up the chart on demand. That makes it easy to text or email someone who needs help selecting a plugin for a project. </p>\n\n\n\n<img />\n\n\n\n<p>rtCamp plans to expand the capabilities of the WPPC tool to include the following:</p>\n\n\n\n<ul><li>Additional parameters in the comparison table (e.g. supported languages, performance data, code quality, etc.)</li><li>Single plugin page with all the data laid out in a presentable manner</li><li>“Other plugins by the same author” page</li><li>A dedicated page with filters where one can filter across all 55K+ plugins</li></ul>\n\n\n\n<p>After testing the tool, I found the search to be a little buggy. Searching plugins by  name or slug sometimes doesn&#8217;t work correctly. Overall, it&#8217;s very easy to use and amazing how it pulls in all the plugins&#8217; details into the comparison table automatically. Additional columns could be helpful in certain categories where there are more than four decent plugin options.</p>\n\n\n\n<p>One feature that would be useful is the ability to filter the search to only show plugins that offer blocks or support the block editor. This could also work as one of the parameters in the comparison table. One of the most frustrating things about searching the WordPress Plugin Directory is sorting through to see which results support blocks. While you can browse <a href=\"https://wordpress.org/plugins/browse/blocks/\">block-enabled plugins</a>, there&#8217;s no easy way to search for block-enabled plugins only. </p>\n\n\n\n<p>rtCamp is aiming to raise the bar for free plugins hosted on WordPress.org with the WPPC tool. If it becomes more popular, plugin authors may feel more pressure to compete in their listings by providing more active maintenance and support. It also quickly identifies which plugins have been around the longest. Since WordPress.org is the primary distribution channel for many plugin businesses, a tool like this can quickly highlight any glaring deficiency in a product if its creators are not consistent with updates and support. These are important considerations when selecting a mission-critical tool, like forms or e-commerce, in a business or non-profit&#8217;s suite of plugins.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Mon, 06 Jun 2022 20:35:53 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Sarah Gooding\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:41;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:35:\"Post Status: Post Status Notes #501\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"https://poststatus.com/?p=98546\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:45:\"https://poststatus.com/post-status-notes-501/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:1185:\"<strong>Elementor</strong> acquires <strong>Strattic</strong> • <strong>WP Engine</strong> acquires <strong>Delicious Brains</strong>\' plugins 🧠 • <em>When the Cathedrals own the Bazaars and Shopping Centers and you\'re in a strip mall with a fruit stand...</em> • <strong>Jetpack</strong> decouples • <strong>InstaWP</strong> gets seed funding from <strong>Automattic</strong> 🌱 • <strong>Automattic</strong> hire #2000 • World-class <strong>FSE</strong>, how? 🌐 • <strong>WCEU</strong> by the numbers • <strong>Weglot</strong> gives back • <strong>RoleUp</strong> rolls out • <strong>Tadlock</strong> exits <strong>WP Tavern</strong> 🍺 • Why \'why\' matters most • The Big 2-0 next year • All there is to know about core WordPress email notifications, documented ✉️ • System font stack check • Do not follow by default • <strong>Museum of Block Art</strong> opens 🎨 • Meet <strong>Yvonne Doll</strong> • Mostly modest WordPress wishlists • <strong>WooCommerce Experts</strong> to go global • How to do well in a downturn 📉 • Some things we don\'t — but ought to — talk about. 🐘 Silent no longer about Sustainability.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Fri, 03 Jun 2022 22:33:31 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:12:\"David Bisset\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:42;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:100:\"WPTavern: Five for the Future Program Set To Adopt Official Definition for Pledges and Contributions\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:30:\"https://wptavern.com/?p=135063\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:111:\"https://wptavern.com/five-for-the-future-program-set-to-adopt-official-definition-for-pledges-and-contributions\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:4824:\"<img />photo credit: <a href=\"https://stocksnap.io/photo/seed-tree-01MVFCVHOD\">Christian Joudrey</a>\n\n\n\n<p>WordPress&#8217; <a href=\"https://wordpress.org/five-for-the-future/\">Five for the Future</a> program, an initiative that encourages organizations to contribute five percent of their resources to WordPress development, is poised to adopt an official definition for what constitutes pledges and contributions. Two weeks ago, WordPress Executive Director Josepha Haden Chomphosy <a href=\"https://make.wordpress.org/project/2022/05/20/defining-five-for-the-future-pledges-contributions/\">proposed</a> the program make a clear distinction between ecosystem contributions and core project contributions:</p>\n\n\n\n<blockquote class=\"wp-block-quote\"><p><strong>Participation in Five for the Future means consistent effort by an individual or a company via a Make WordPress team to directly support the WordPress open source project and the project’s current </strong><a href=\"https://make.wordpress.org/updates/2022/01/21/our-three-big-ideas-for-2022/\"><strong>big ideas</strong></a><strong>, rather than the sole benefit of a company or individual.</strong> Simply put, Five for the Future exists to collaboratively invest in the health of the WordPress project, ensuring its long-term sustainability and success.</p></blockquote>\n\n\n\n<p>Haden Chomphosy further clarified that certain contributions fall within a grey area but still fit within this definition, such as mataining WordPress.org, WordCamp.org, Rosetta networks, documentation, training, or speaking at meetups. She also specified another grey area that does not fit within the official definition. This includes things like creating WordPress sites, themes, plugins, or blocks, and providing support.  </p>\n\n\n\n<p>&#8220;These activities are critical to extending the reach and utility of the WordPress project, but they are not considered part of making Five for the Future commitments,&#8221; Haden Chomphosy said.</p>\n\n\n\n<p>&#8220;There are many important efforts and lots of incredible work performed outside of WordPress.org and Make Teams. While these are indispensable activities that further the WordPress ecosystem, Five for the Future is about ensuring that the WordPress project continues to be a fertile foundation for WordPress extenders and users.&#8221;</p>\n\n\n\n<p>This was always the unspoken understanding of the Five for the Future program but this proposal formalizes it ahead of building out official tracking efforts.</p>\n\n\n\n<p>The general consensus in the resulting discussion was agreement on the first part of the definition, that the contribution must move the open source project forward. A few participants were not convinced that themes and plugins would not qualify as a contribution towards this goal.</p>\n\n\n\n<p>&#8220;I can’t help but wonder about the argument to be made that the creation of themes, plugins and blocks that are made freely available are also contributions that move WordPress forward,&#8221; GoDaddy-sponsored contributor Adam Warner said.</p>\n\n\n\n<p>Yoast-sponsored contributor Yvette Sonneveld said the term &#8220;grey area&#8221; has a negative connotation and that &#8220;all the activities are essential to keep the software and community healthy and thriving.&#8221;</p>\n\n\n\n<p>&#8220;I fully understand that these are harder to quantify,&#8221; Sonneveld said.</p>\n\n\n\n<p>&#8220;Personally, I agree that themes and plugins brought out under creative commons licenses also help the software and the community thrive, and should be included in the efforts that help the project move forward.&#8221;</p>\n\n\n\n<p>The definition did not receive much pushback and appears to be already confirmed, as Automattic-sponsored community organizer Angela Jin <a href=\"https://make.wordpress.org/project/2022/05/23/request-for-feedback-recording-five-for-the-future-contributions/\">posted</a> three days later, asking for feedback on how to identify and record contirbutions. </p>\n\n\n\n<p>&#8220;Based on the definition we now have of 5ftF contributions, what other activity, specific to a Make Team or across multiple teams, should be recognized and recorded?&#8221; Jin said. </p>\n\n\n\n<p>The program&#8217;s activity is <a href=\"https://github.com/WordPress/five-for-the-future/issues\">tracked on GitHub</a>, where discussions are open on everything from stats to badges to tracking meetup attendance. Many of these are technical issues that will require building charts and dashboards. It will be interesting to see how  the community and meta teams tackle these challenges to track contributions across teams. Feedback on <a href=\"https://make.wordpress.org/project/2022/05/23/request-for-feedback-recording-five-for-the-future-contributions/\">contributions tracking</a> is still open in the comments of the post.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Fri, 03 Jun 2022 21:24:38 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Sarah Gooding\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:43;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:71:\"Post Status: WooCommerce Function of the Week: wc_current_user_has_role\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"https://poststatus.com/?p=98538\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:81:\"https://poststatus.com/woocommerce-function-of-the-week-wc_current_user_has_role/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:166:\"What if you want to show hidden information only to \"administrators\" or \"shop managers?\" What about displaying a custom \"My Account\" tab just for logged-in customers?\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Fri, 03 Jun 2022 17:57:48 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:15:\"Rodolfo Melogli\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:44;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:51:\"WPTavern: InstaWP Gets Seed Funding From Automattic\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:30:\"https://wptavern.com/?p=135047\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:62:\"https://wptavern.com/instawp-gets-seed-funding-from-automattic\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:2996:\"<p><a href=\"https://instawp.com/\">InstaWP</a> has received an undisclosed amount of <a href=\"https://instawp.com/story-of-instawp-and-investment-by-automattic/?1vt\">seed funding from Automattic</a>. The service <a href=\"https://wptavern.com/instawp-launches-new-service-for-disposable-wordpress-testing-sites\">launched in July 2021</a> as a quick way to set up testing or disposable WordPress sites and users frequently commented on remarkable speed of the tool, which spins up a site in less than a second.</p>\n\n\n\n<p>Founder Vikas Singhal said the investment gives Automattic a percentage of future equity under a SAFE (simple agreement for future equity) arrangement. In order to receive the investment, Singhal was required to register InstaWP Inc. as an independent US-based organization.</p>\n\n\n\n<p>&#8220;InstaWP has a vision of making it easy to get started with WordPress,&#8221; Singhal said.</p>\n\n\n\n<p>&#8220;Initally I thought InstaWP was just a disposable WP tool but fast forward eight months, it&#8217;s much more than that. It&#8217;s a workflow tool now, which makes working with WP 10x easier.&#8221;</p>\n\n\n\n<p>InstaWP provided an Agency plan for LearnWP to use during Social Learning Spaces, Calls for Testing, and similar uses. The fact that it&#8217;s being used in WordPress education, where some users are brand new to the platform, speaks to how user-friendly it is to fire up a new WordPress testing site.</p>\n\n\n\n<p>&#8220;Lots of plugin and theme authors use it for showcasing their product sandboxes,&#8221; Singhal said. &#8220;Agencies are using it to build and deliver websites for their clients. Many developers are using it for end to end testing as well.&#8221;</p>\n\n\n\n<p>Singhal reports more than 23,000 sites have been created with InstaWP. The service currently has 1,600 free users and 50+ paid users. It offers paid plans from $9/month to $59/month and custom pricing for enterprise customers.</p>\n\n\n\n<p>Singhal said the seed funding &#8220;should last for about next 18-24 months,&#8221; as InstaWP has ramped up hiring and marketing. He anticipates the company will be profitable by the end of the year and is open to more investors. </p>\n\n\n\n<p>InstaWP is working on developing native integrations for hosting providers, which would allow users to connect their accounts, see a list of existing sites or create new ones, and select a production site to &#8220;push&#8221; to from InstaWP. The company is currently working with Runcloud and GoDaddy.</p>\n\n\n\n<p>&#8220;We have come a long from being a disposable WP tool,&#8221; Singhal said. &#8220;InstaWP will become a great gateway to WordPress, covering all the use cases such as build, dev, test, showcase, and educate. We will be connecting hosting providers, product vendors and agencies/freelancers alike in a single platform.</p>\n\n\n\n<p>&#8220;We want to become the AWS for the WordPress world, providing an easy way for people to build sites without thinking about the underlying platform.&#8221;</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Fri, 03 Jun 2022 17:30:43 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Sarah Gooding\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:45;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:69:\"Post Status: WordPress Podcast and Video Picks for the Week of May 29\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"https://poststatus.com/?p=98548\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:80:\"https://poststatus.com/wordpress-podcast-and-video-picks-for-the-week-of-may-29/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:316:\"Vikas Singhal on InstaWP\'s backing from Automattic • Raffaella Isidori on the importance of UX • How to get the