use_socket = true;

updateTable = (serial_state) ->
      state = JSON.parse(serial_state);

      # Reference position column
      $('#WST .ref').html( state.ref[0].toFixed(3) )
      $('#NKY .ref').html( state.ref[1].toFixed(3) )
      $('#NK1 .ref').html( state.ref[2].toFixed(3) )
      $('#NK2 .ref').html( state.ref[3].toFixed(3) )
      $('#LSP .ref').html( state.ref[4].toFixed(3) )
      $('#LSR .ref').html( state.ref[5].toFixed(3) )
      $('#LSY .ref').html( state.ref[6].toFixed(3) )
      $('#LEB .ref').html( state.ref[7].toFixed(3) )
      $('#LWY .ref').html( state.ref[8].toFixed(3) )
      $('#LWR .ref').html( state.ref[9].toFixed(3) )
      $('#LWP .ref').html( state.ref[10].toFixed(3) )
      $('#RSP .ref').html( state.ref[11].toFixed(3) )
      $('#RSR .ref').html( state.ref[12].toFixed(3) )
      $('#RSY .ref').html( state.ref[13].toFixed(3) )
      $('#REB .ref').html( state.ref[14].toFixed(3) )
      $('#RWY .ref').html( state.ref[15].toFixed(3) )
      $('#RWR .ref').html( state.ref[16].toFixed(3) )
      $('#RWP .ref').html( state.ref[17].toFixed(3) )
      # mind the gap
      $('#LHY .ref').html( state.ref[19].toFixed(3) )
      $('#LHR .ref').html( state.ref[20].toFixed(3) )
      $('#LHP .ref').html( state.ref[21].toFixed(3) )
      $('#LKN .ref').html( state.ref[22].toFixed(3) )
      $('#LAP .ref').html( state.ref[23].toFixed(3) )
      $('#LAR .ref').html( state.ref[24].toFixed(3) )
      # mind the gap
      $('#RHY .ref').html( state.ref[26].toFixed(3) )
      $('#RHR .ref').html( state.ref[27].toFixed(3) )
      $('#RHP .ref').html( state.ref[28].toFixed(3) )
      $('#RKN .ref').html( state.ref[29].toFixed(3) )
      $('#RAP .ref').html( state.ref[30].toFixed(3) )
      $('#RAR .ref').html( state.ref[31].toFixed(3) )
      $('#RF1 .ref').html( state.ref[32].toFixed(3) )
      $('#RF2 .ref').html( state.ref[33].toFixed(3) )
      $('#RF3 .ref').html( state.ref[34].toFixed(3) )
      $('#RF4 .ref').html( state.ref[35].toFixed(3) )
      $('#RF5 .ref').html( state.ref[36].toFixed(3) )
      $('#LF1 .ref').html( state.ref[37].toFixed(3) )
      $('#LF2 .ref').html( state.ref[38].toFixed(3) )
      $('#LF3 .ref').html( state.ref[39].toFixed(3) )
      $('#LF4 .ref').html( state.ref[40].toFixed(3) )
      $('#LF5 .ref').html( state.ref[41].toFixed(3) )

      # Position column
      $('#WST .pos').html( state.pos[0].toFixed(3) )
      $('#NKY .pos').html( state.pos[1].toFixed(3) )
      $('#NK1 .pos').html( state.pos[2].toFixed(3) )
      $('#NK2 .pos').html( state.pos[3].toFixed(3) )
      $('#LSP .pos').html( state.pos[4].toFixed(3) )
      $('#LSR .pos').html( state.pos[5].toFixed(3) )
      $('#LSY .pos').html( state.pos[6].toFixed(3) )
      $('#LEB .pos').html( state.pos[7].toFixed(3) )
      $('#LWY .pos').html( state.pos[8].toFixed(3) )
      $('#LWR .pos').html( state.pos[9].toFixed(3) )
      $('#LWP .pos').html( state.pos[10].toFixed(3) )
      $('#RSP .pos').html( state.pos[11].toFixed(3) )
      $('#RSR .pos').html( state.pos[12].toFixed(3) )
      $('#RSY .pos').html( state.pos[13].toFixed(3) )
      $('#REB .pos').html( state.pos[14].toFixed(3) )
      $('#RWY .pos').html( state.pos[15].toFixed(3) )
      $('#RWR .pos').html( state.pos[16].toFixed(3) )
      $('#RWP .pos').html( state.pos[17].toFixed(3) )
      # mind the gap
      $('#LHY .pos').html( state.pos[19].toFixed(3) )
      $('#LHR .pos').html( state.pos[20].toFixed(3) )
      $('#LHP .pos').html( state.pos[21].toFixed(3) )
      $('#LKN .pos').html( state.pos[22].toFixed(3) )
      $('#LAP .pos').html( state.pos[23].toFixed(3) )
      $('#LAR .pos').html( state.pos[24].toFixed(3) )
      # mind the gap
      $('#RHY .pos').html( state.pos[26].toFixed(3) )
      $('#RHR .pos').html( state.pos[27].toFixed(3) )
      $('#RHP .pos').html( state.pos[28].toFixed(3) )
      $('#RKN .pos').html( state.pos[29].toFixed(3) )
      $('#RAP .pos').html( state.pos[30].toFixed(3) )
      $('#RAR .pos').html( state.pos[31].toFixed(3) )
      $('#RF1 .pos').html( state.pos[32].toFixed(3) )
      $('#RF2 .pos').html( state.pos[33].toFixed(3) )
      $('#RF3 .pos').html( state.pos[34].toFixed(3) )
      $('#RF4 .pos').html( state.pos[35].toFixed(3) )
      $('#RF5 .pos').html( state.pos[36].toFixed(3) )
      $('#LF1 .pos').html( state.pos[37].toFixed(3) )
      $('#LF2 .pos').html( state.pos[38].toFixed(3) )
      $('#LF3 .pos').html( state.pos[39].toFixed(3) )
      $('#LF4 .pos').html( state.pos[40].toFixed(3) )
      $('#LF5 .pos').html( state.pos[41].toFixed(3) )

      # Current column
      $('#WST .cur').html( state.cur[0].toFixed(3) )
      $('#NKY .cur').html( state.cur[1].toFixed(3) )
      $('#NK1 .cur').html( state.cur[2].toFixed(3) )
      $('#NK2 .cur').html( state.cur[3].toFixed(3) )
      $('#LSP .cur').html( state.cur[4].toFixed(3) )
      $('#LSR .cur').html( state.cur[5].toFixed(3) )
      $('#LSY .cur').html( state.cur[6].toFixed(3) )
      $('#LEB .cur').html( state.cur[7].toFixed(3) )
      $('#LWY .cur').html( state.cur[8].toFixed(3) )
      $('#LWR .cur').html( state.cur[9].toFixed(3) )
      $('#LWP .cur').html( state.cur[10].toFixed(3) )
      $('#RSP .cur').html( state.cur[11].toFixed(3) )
      $('#RSR .cur').html( state.cur[12].toFixed(3) )
      $('#RSY .cur').html( state.cur[13].toFixed(3) )
      $('#REB .cur').html( state.cur[14].toFixed(3) )
      $('#RWY .cur').html( state.cur[15].toFixed(3) )
      $('#RWR .cur').html( state.cur[16].toFixed(3) )
      $('#RWP .cur').html( state.cur[17].toFixed(3) )
      # mind the gap
      $('#LHY .cur').html( state.cur[19].toFixed(3) )
      $('#LHR .cur').html( state.cur[20].toFixed(3) )
      $('#LHP .cur').html( state.cur[21].toFixed(3) )
      $('#LKN .cur').html( state.cur[22].toFixed(3) )
      $('#LAP .cur').html( state.cur[23].toFixed(3) )
      $('#LAR .cur').html( state.cur[24].toFixed(3) )
      # mind the gap
      $('#RHY .cur').html( state.cur[26].toFixed(3) )
      $('#RHR .cur').html( state.cur[27].toFixed(3) )
      $('#RHP .cur').html( state.cur[28].toFixed(3) )
      $('#RKN .cur').html( state.cur[29].toFixed(3) )
      $('#RAP .cur').html( state.cur[30].toFixed(3) )
      $('#RAR .cur').html( state.cur[31].toFixed(3) )
      $('#RF1 .cur').html( state.cur[32].toFixed(3) )
      $('#RF2 .cur').html( state.cur[33].toFixed(3) )
      $('#RF3 .cur').html( state.cur[34].toFixed(3) )
      $('#RF4 .cur').html( state.cur[35].toFixed(3) )
      $('#RF5 .cur').html( state.cur[36].toFixed(3) )
      $('#LF1 .cur').html( state.cur[37].toFixed(3) )
      $('#LF2 .cur').html( state.cur[38].toFixed(3) )
      $('#LF3 .cur').html( state.cur[39].toFixed(3) )
      $('#LF4 .cur').html( state.cur[40].toFixed(3) )
      $('#LF5 .cur').html( state.cur[41].toFixed(3) )

      # Home column
      $('#WST .home').html( state.home[0] )
      $('#NKY .home').html( state.home[1] )
      $('#NK1 .home').html( state.home[2] )
      $('#NK2 .home').html( state.home[3] )
      $('#LSP .home').html( state.home[4] )
      $('#LSR .home').html( state.home[5] )
      $('#LSY .home').html( state.home[6] )
      $('#LEB .home').html( state.home[7] )
      $('#LWY .home').html( state.home[8] )
      $('#LWR .home').html( state.home[9] )
      $('#LWP .home').html( state.home[10] )
      $('#RSP .home').html( state.home[11] )
      $('#RSR .home').html( state.home[12] )
      $('#RSY .home').html( state.home[13] )
      $('#REB .home').html( state.home[14] )
      $('#RWY .home').html( state.home[15] )
      $('#RWR .home').html( state.home[16] )
      $('#RWP .home').html( state.home[17] )
      # mind the gap
      $('#LHY .home').html( state.home[19] )
      $('#LHR .home').html( state.home[20] )
      $('#LHP .home').html( state.home[21] )
      $('#LKN .home').html( state.home[22] )
      $('#LAP .home').html( state.home[23] )
      $('#LAR .home').html( state.home[24] )
      # mind the gap
      $('#RHY .home').html( state.home[26] )
      $('#RHR .home').html( state.home[27] )
      $('#RHP .home').html( state.home[28] )
      $('#RKN .home').html( state.home[29] )
      $('#RAP .home').html( state.home[30] )
      $('#RAR .home').html( state.home[31] )
      $('#RF1 .home').html( state.home[32] )
      $('#RF2 .home').html( state.home[33] )
      $('#RF3 .home').html( state.home[34] )
      $('#RF4 .home').html( state.home[35] )
      $('#RF5 .home').html( state.home[36] )
      $('#LF1 .home').html( state.home[37] )
      $('#LF2 .home').html( state.home[38] )
      $('#LF3 .home').html( state.home[39] )
      $('#LF4 .home').html( state.home[40] )
      $('#LF5 .home').html( state.home[41] )

      # Make rows with errors red.
      $('#WST').css('color', if (state.error[0])  then 'red' else '')
      $('#NKY').css('color', if (state.error[1])  then 'red' else '')
      $('#NK1').css('color', if (state.error[2])  then 'red' else '')
      $('#NK2').css('color', if (state.error[3])  then 'red' else '')
      $('#LSP').css('color', if (state.error[4])  then 'red' else '')
      $('#LSR').css('color', if (state.error[5])  then 'red' else '')
      $('#LSY').css('color', if (state.error[6])  then 'red' else '')
      $('#LEB').css('color', if (state.error[7])  then 'red' else '')
      $('#LWY').css('color', if (state.error[8])  then 'red' else '')
      $('#LWR').css('color', if (state.error[9])  then 'red' else '')
      $('#LWP').css('color', if (state.error[10]) then 'red' else '')
      $('#RSP').css('color', if (state.error[11]) then 'red' else '')
      $('#RSR').css('color', if (state.error[12]) then 'red' else '')
      $('#RSY').css('color', if (state.error[13]) then 'red' else '')
      $('#REB').css('color', if (state.error[14]) then 'red' else '')
      $('#RWY').css('color', if (state.error[15]) then 'red' else '')
      $('#RWR').css('color', if (state.error[16]) then 'red' else '')
      $('#RWP').css('color', if (state.error[17]) then 'red' else '')
      # mind the gap
      $('#LHY').css('color', if (state.error[19]) then 'red' else '')
      $('#LHR').css('color', if (state.error[20]) then 'red' else '')
      $('#LHP').css('color', if (state.error[21]) then 'red' else '')
      $('#LKN').css('color', if (state.error[22]) then 'red' else '')
      $('#LAP').css('color', if (state.error[23]) then 'red' else '')
      $('#LAR').css('color', if (state.error[24]) then 'red' else '')
      # mind the gap
      $('#RHY').css('color', if (state.error[26]) then 'red' else '')
      $('#RHR').css('color', if (state.error[27]) then 'red' else '')
      $('#RHP').css('color', if (state.error[28]) then 'red' else '')
      $('#RKN').css('color', if (state.error[29]) then 'red' else '')
      $('#RAP').css('color', if (state.error[30]) then 'red' else '')
      $('#RAR').css('color', if (state.error[31]) then 'red' else '')
      $('#RF1').css('color', if (state.error[32]) then 'red' else '')
      $('#RF2').css('color', if (state.error[33]) then 'red' else '')
      $('#RF3').css('color', if (state.error[34]) then 'red' else '')
      $('#RF4').css('color', if (state.error[35]) then 'red' else '')
      $('#RF5').css('color', if (state.error[36]) then 'red' else '')
      $('#LF1').css('color', if (state.error[37]) then 'red' else '')
      $('#LF2').css('color', if (state.error[38]) then 'red' else '')
      $('#LF3').css('color', if (state.error[39]) then 'red' else '')
      $('#LF4').css('color', if (state.error[40]) then 'red' else '')
      $('#LF5').css('color', if (state.error[41]) then 'red' else '')

      # Force torque readings
      $('#RH .m_x').html( state.ft[0].toFixed(3) )
      $('#RH .m_y').html( state.ft[1].toFixed(3) )
      $('#RH .f_z').html( state.ft[2].toFixed(3) )
      $('#LH .m_x').html( state.ft[3].toFixed(3) )
      $('#LH .m_y').html( state.ft[4].toFixed(3) )
      $('#LH .f_z').html( state.ft[5].toFixed(3) )
      $('#RF .m_x').html( state.ft[6].toFixed(3) )
      $('#RF .m_y').html( state.ft[7].toFixed(3) )
      $('#RF .f_z').html( state.ft[8].toFixed(3) )
      $('#LF .m_x').html( state.ft[9].toFixed(3) )
      $('#LF .m_y').html( state.ft[10].toFixed(3) )
      $('#LF .f_z').html( state.ft[11].toFixed(3) )

      # IMU readings
      $('#IMU0 .a_x').html( state.imu[0].a_x.toFixed(3) )
      $('#IMU0 .a_y').html( state.imu[0].a_y.toFixed(3) )
      $('#IMU0 .a_z').html( state.imu[0].a_z.toFixed(3) )
      $('#IMU1 .a_x').html( state.imu[1].a_x.toFixed(3) )
      $('#IMU1 .a_y').html( state.imu[1].a_y.toFixed(3) )
      $('#IMU1 .a_z').html( state.imu[1].a_z.toFixed(3) )

      # Power readings
      $('#PWR .v').html( state.power.voltage.toFixed(3) )
      $('#PWR .i').html( state.power.current.toFixed(3) )
      $('#PWR .p').html( state.power.power.toFixed(3) )

      # Time reading
      $('#time').html( state.time.toFixed(3) )      

#
# MAIN
#
$( document ).ready () ->
  if (use_socket)
    socket = io.connect(':6060');
    socket.on 'serial_state', (serial_state) ->
      window.serial_state = serial_state
      updateTable(serial_state)
  else
    window.serial_stateRef = new Firebase('http://drc-hubo.firebaseIO.com/serial_state')
    serial_stateRef.on 'value', (snapshot) ->
      serial_state = snapshot.val()
      window.serial_state = serial_state
      updateTable(serial_state)