<!-- ####################################################################################################### -->
<div class="wrapper col4">
  <div id="breadcrumb">
    <ul>
      <li class="first"><a href="/">Lofaro Labs Robotics</a></li>
      <li>&#187;</li>
      <li class="current"><a href="./">Magnetic Resonator Guitar (MR.G)</a></li>
    </ul>
  </div>
</div>
<!-- ####################################################################################################### -->
<div class="wrapper col5">
  <div id="container">
    <div id="content">
      <h1>Magnetic Resonator Guitar (MR.G)</h1>
      <img src="img/mrgSch2.png" alt="Mr.G" height="190" align="middle"/>
      <img src="img/mrg3d2.png" alt="Mr.G" height="190" align="right"/>


<p align="justify">
The Magnetic Resonator Guitar (MR.G) was inspired by Drexel's <a href="http://music.ece.drexel.edu/research/mrp">Magnetic Resonator Piano</a>. Much like the Magnetic Resonator Piano, MR.G is a hybrid acoustic-electric instrument. While the sound is processed electronically, the music the guitar produces is entirely acoustic. There are no speakers, with the only amplification being in connection to the electromagnetic actuation.
</p>

<p align="justify">
The aim of this project is to expand the musical capacity of the guitar. Over the past few decades, artists have been employing digital techniques to create new forms of music. Some instruments have been modified precisely for this purpose. For example, the keyboard introduced techno to the piano. Our goal is to provide a similar alteration to the guitar, as it is one of the most popular instruments. The difference here is that we seek to preserve the traditional acoustic sound alongside the new techno version. The following is a step by step guide to creating a device that can be attached to an acoustic guitar. It will allow users to add digital sound effects, play songs through resonation, or simply play the guitar as originally intended. We hope this expansion will give musicians more creative freedom. It is provided in an open source format to encourage both professionals and hobbyists to enjoy MR. G.
</p>

<a href="img/Schematic.jpg"><img class="imgl" src="img/Schematic.jpg"  alt="" width="300" /></a>

<p align="justify">
The basic idea of MR.G is the use of resonant frequencies to excite guitar strings. All objects have a frequency at which they vibrate, known as the resonant frequency. If a wave form (it may be sound, electromagnetic, etc.) of that frequency hits an object, it will begin to resonate. In this case, that frequency is the note at which each string is tuned.
</p>
<p align="justify">
The chosen signal for for this project is electromagnetic. The initial sound wave enters through either a microphone or from the Raspberry Pi. It is then amplified and sent out to the strings, which result in the vibration. The sound produced is similar to that of a violin as opposed to the traditional plucking.
</p>

<iframe width="560" height="315" src="https://www.youtube.com/embed/dMMCtgSlwuY" frameborder="0" allowfullscreen></iframe>


    </div>
    <div id="column">
      <div class="subnav">
      <img src="img/mrg.png" alt="Mr. G" width="250" align="middle"/>
<!--        <h2>ARCHR Pages</h2> -->
        <ul>
          <li><a href="http://wiki.lofarolabs.com/index.php/Magnetic_Resonator_Guitar_(MR.G)">How To (wiki)</a></li>
          <li><a href="https://www.tinkercad.com/users/1ZCHE3ZJDXx-hussein-fahema">3D Models</a></li>
          <li><a href="https://github.com/lofarolabs/MRG">Source Code</a><li>
          <li><a href="videos/">Videos</a></li>
        </ul>
      </div>
      <div class="holder">
      </div>
    </div>
    <div class="clear"></div>
  </div>
</div>
